use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

my %queries =
(

 "foo[bar=1" => qr/\[foo_bar\] => 1\n/,
 "foo bar=2" => qr/\[foo_bar\] => 2\n/,
 "foo. .bar=3" => qr/\[foo___bar\] => 3\n/,
 "foobar[=3" => qr/\[foobar_\] => 3\n/,

 "foo[g][=1" => qr/\[g\] => 1\n/, # corruption pre-5.0.2/4.3.9
 "foo[][=2" => qr/\[0\] => 2\n/, # segfault in 5.0.2/4.3.9

 "foo[][[[[[=3" => qr/\[0\] => 3\n/,
 "foo[][][][][]=5" => qr/\[0\] => 5\n/,

 "foo[j]bar=6" => qr/\[j\] => 6\n/,


### tests which have dubious results currently:
# "foo[[[[[[[h]=4" => qr/\[0\] => 4\n/,
# "foo[ ]=7" => qr/\[baz\] => 7\n/,
# "foo[  ]=7" => qr/\[baz\] => 7\n/,

 );

plan tests => (keys %queries) * 1, need_php;

foreach (keys %queries) {
    my $actual = GET_BODY "/security/CAN-2004-0958.php?".$_;
    ok t_cmp($actual, $queries{$_}, "query for $_");
}
