//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)


static const std::array<std::array<typename table_type<T>::type, 4>, 1210> ibeta_derivative_large_data = { {
{{ SC_(1.0476082934474106878042221069335937500000e-05), SC_(3.9078187500000000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9269302505055971245108533005908825520385e-41521) }},
{{ SC_(1.1273314157733693718910217285156250000000e-05), SC_(2.2662017494440078735351562500000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.5833311060979905221980727295357737468569e-05) }},
{{ SC_(1.1377843293303158134222030639648437500000e-05), SC_(3.6544218659400939941406250000000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.3222023158036735998897099680773504451652e-04) }},
{{ SC_(1.1428466677898541092872619628906250000000e-05), SC_(2.4451760109513998031616210937500000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.7033676664585638381273746677575810050956e-05) }},
{{ SC_(1.1846856068586930632591247558593750000000e-05), SC_(1.5964560210704803466796875000000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.5192306869844455469962545850631999485560e-05) }},
{{ SC_(1.2158005119999870657920837402343750000000e-05), SC_(2.4110496093750000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.1691304653994518958586532492091054824083e-1530) }},
{{ SC_(1.3034172297921031713485717773437500000000e-05), SC_(2.6168341796875000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.5131369801838022244189263561014529757933e-1549) }},
{{ SC_(1.3885271982871927320957183837890625000000e-05), SC_(4.9762740731239318847656250000000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.6811171490789982191243977143552781827692e-05) }},
{{ SC_(1.3901616512157488614320755004882812500000e-05), SC_(3.1888823286863043904304504394531250000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.4136860372805759679245829936722379832552e-05) }},
{{ SC_(1.4759907571715302765369415283203125000000e-05), SC_(2.8241312503814697265625000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.7609461264452087672100113133375774171817e-06) }},
{{ SC_(1.5079472177603747695684432983398437500000e-05), SC_(4.8754711315268650650978088378906250000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.6872412074058490069916374670256458887574e-05) }},
{{ SC_(1.5196248568827286362648010253906250000000e-05), SC_(1.6177537109375000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6910083770664820015271856038619503004517e-11850) }},
{{ SC_(1.5544977941317483782768249511718750000000e-05), SC_(4.0469245910644531250000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.5068258519819312527899610527681704563872e-46) }},
{{ SC_(1.5675454051233828067779541015625000000000e-05), SC_(1.0191339242737740278244018554687500000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.9993789667585905658020173941717362428122e-05) }},
{{ SC_(1.5971760149113833904266357421875000000000e-05), SC_(1.9206241607666015625000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.9493607822778359703597009221512935383254e-25) }},
{{ SC_(1.6304524251609109342098236083984375000000e-05), SC_(3.9033559733070433139801025390625000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.4107950737191129013664827309554815349320e-04) }},
{{ SC_(1.6487292668898589909076690673828125000000e-05), SC_(4.7099715625000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.7913621881963152427739710649393818331186e-27804) }},
{{ SC_(1.6504469385836273431777954101562500000000e-05), SC_(3.5758438110351562500000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.0724212982706756891833285332465709443072e-05) }},
{{ SC_(1.6625948774162679910659790039062500000000e-05), SC_(1.4781887500000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.9409752645519688050551102031654135482280e-64250) }},
{{ SC_(1.6847467122715897858142852783203125000000e-05), SC_(2.2076526656746864318847656250000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.5014020851638370971095475825558113712879e-04) }},
{{ SC_(1.7474903870606794953346252441406250000000e-05), SC_(2.6349246501922607421875000000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.7742678064008213233661580897444084068984e-05) }},
{{ SC_(1.7863809262053109705448150634765625000000e-05), SC_(4.3938714599609375000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.8047299302665262153684660799151120674515e-348) }},
{{ SC_(1.8952476239064708352088928222656250000000e-05), SC_(1.0710955858230590820312500000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.5285214215785027121846881868390257772640e-05) }},
{{ SC_(1.9740999050554819405078887939453125000000e-05), SC_(1.0541565704345703125000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2462675909278790257612853184177372341877e-21) }},
{{ SC_(2.0043353288201615214347839355468750000000e-05), SC_(4.8200701904296875000000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.1329908730035636587973495274032238697837e-499) }},
{{ SC_(2.0171286450931802392005920410156250000000e-05), SC_(2.3297929382324218750000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.1334220174761613485155713513907281344154e-19) }},
{{ SC_(2.0203804524498991668224334716796875000000e-05), SC_(4.2833633422851562500000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3622284538930603368044557590928521727262e-07) }},
{{ SC_(2.0300331016187556087970733642578125000000e-05), SC_(4.2389381408691406250000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.0029275784954506006618232886585004960739e-68) }},
{{ SC_(2.0518851670203730463981628417968750000000e-05), SC_(2.3608789062500000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0643188085559563702319912328927622466179e-184762) }},
{{ SC_(2.1041001673438586294651031494140625000000e-05), SC_(3.8230969905853271484375000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.1281844466426513832141657582696990453916e-04) }},
{{ SC_(2.1076917619211599230766296386718750000000e-05), SC_(4.4897153973579406738281250000000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2095682710935519338811690842309612816165e-04) }},
{{ SC_(2.1139929231139831244945526123046875000000e-05), SC_(1.7535277947899885475635528564453125000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.9574596097337548293956783627770428210152e-05) }},
{{ SC_(2.1433561414596624672412872314453125000000e-05), SC_(3.7192790527343750000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.4386567373877537247094205103572131215090e-2728) }},
{{ SC_(2.2448601157520897686481475830078125000000e-05), SC_(4.4507128125000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.9123809355675617071100882089078885260769e-48306) }},
{{ SC_(2.2683978386339731514453887939453125000000e-05), SC_(4.0550004690885543823242187500000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.4143259165111534783158028596193412141163e-04) }},
{{ SC_(2.3484906705562025308609008789062500000000e-05), SC_(2.5542792968750000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4613292200324103655664350909547841376771e-38492) }},
{{ SC_(2.3615430109202861785888671875000000000000e-05), SC_(4.5070295333862304687500000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.5784920607079156960448372936358673309457e-09) }},
{{ SC_(2.3999349650694057345390319824218750000000e-05), SC_(4.6294589233398437500000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.6657197560684365482736346376325868555654e-343) }},
{{ SC_(2.4066381229204125702381134033203125000000e-05), SC_(1.2703814697265625000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2655712285031773270027748649116160693167e-79) }},
{{ SC_(2.5217834263457916676998138427734375000000e-05), SC_(1.8322723388671875000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.7518981066572793563324226008490523514466e-1951) }},
{{ SC_(2.5262335839215666055679321289062500000000e-05), SC_(1.8408362567424774169921875000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0983250061850652554283295484076766673708e-04) }},
{{ SC_(2.5689081667223945260047912597656250000000e-05), SC_(2.6883506216108798980712890625000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.9633400604718586720743586615432362801330e-04) }},
{{ SC_(2.6870451620197854936122894287109375000000e-05), SC_(1.4498581003863364458084106445312500000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6451370278130605379032750160762035080215e-04) }},
{{ SC_(2.7549775040824897587299346923828125000000e-05), SC_(1.5035864710807800292968750000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.4328057232001415511194591117290876249375e-04) }},
{{ SC_(2.7823447453556582331657409667968750000000e-05), SC_(2.9502755403518676757812500000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1867846931583283922909126369607443422528e-04) }},
{{ SC_(2.8775624741683714091777801513671875000000e-05), SC_(2.5491835937500000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.1032298987116139029535922026525897628421e-26157) }},
{{ SC_(2.8931553970323875546455383300781250000000e-05), SC_(4.9498385620117187500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3303003211363903594153077624232194967656e-749) }},
{{ SC_(2.9415024982881732285022735595703125000000e-05), SC_(4.1924233664758503437042236328125000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2888309347861001413319390810778229090474e-04) }},
{{ SC_(2.9590575650217942893505096435546875000000e-05), SC_(2.8319567441940307617187500000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2160492624859091163816259840837589444100e-04) }},
{{ SC_(2.9934562917333096265792846679687500000000e-05), SC_(4.0956687927246093750000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.9881664406985553711866073630971898194878e-07) }},
{{ SC_(3.0238283216021955013275146484375000000000e-05), SC_(4.7602958679199218750000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1978404831482692130972775801809405653434e-09) }},
{{ SC_(3.1141327781369909644126892089843750000000e-05), SC_(3.4814400000000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.7636151215428645239088811782828970918951e-55722) }},
{{ SC_(3.1231902539730072021484375000000000000000e-05), SC_(3.3712953125000000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.6451511761351381992689647997951726838636e-3663) }},
{{ SC_(3.1875260901870205998420715332031250000000e-05), SC_(4.9715250497683882713317871093750000000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2760077294040193845593750743527635175590e-04) }},
{{ SC_(3.1888619560049846768379211425781250000000e-05), SC_(1.6322303771972656250000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.8995995065514632081453892228370578058073e-17) }},
{{ SC_(3.1988944101613014936447143554687500000000e-05), SC_(3.9311948242187500000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0454245477960698497821696693009277312919e-633) }},
{{ SC_(3.2712865504436194896697998046875000000000e-05), SC_(3.1094858398437500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.6234504641719643657188349243191166942956e-4689) }},
{{ SC_(3.2752945116953924298286437988281250000000e-05), SC_(2.5796328125000000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.2940316248959287719701453977114063200351e-20192) }},
{{ SC_(3.3410564356017857789993286132812500000000e-05), SC_(3.3780144042968750000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.8867408213533821609255170573649789313858e-371) }},
{{ SC_(3.3410709875170141458511352539062500000000e-05), SC_(4.2327022552490234375000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3453066297259572962863201470082350879275e-08) }},
{{ SC_(3.4079275792464613914489746093750000000000e-05), SC_(2.8878271875000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.1846471146087755187409010904609987781251e-211458) }},
{{ SC_(3.4641787351574748754501342773437500000000e-05), SC_(4.1155911254882812500000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.5075500323666411922332386777048899317238e-441) }},
{{ SC_(3.5294371627969667315483093261718750000000e-05), SC_(2.2326681573758833110332489013671875000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.8825061761909901699704547785228846393574e-05) }},
{{ SC_(3.5852521250490099191665649414062500000000e-05), SC_(4.1758999228477478027343750000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5666893175158886620967905564647114120000e-04) }},
{{ SC_(3.6163164622848853468894958496093750000000e-05), SC_(3.1193678125000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.6205419590313223140339713942080040984787e-320037) }},
{{ SC_(3.6203920899424701929092407226562500000000e-05), SC_(3.8428153991699218750000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.0469506179784230290418450236810725219770e-05) }},
{{ SC_(3.6219116736901924014091491699218750000000e-05), SC_(1.6954606398940086364746093750000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.4638138364063951367136951395309080460218e-04) }},
{{ SC_(3.6229626857675611972808837890625000000000e-05), SC_(4.1917143389582633972167968750000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.2360265165771222088355388509754324617323e-04) }},
{{ SC_(3.7149406125536188483238220214843750000000e-05), SC_(2.5949541013687849044799804687500000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5713543332694406219681681419267003098489e-04) }},
{{ SC_(3.7188106944086030125617980957031250000000e-05), SC_(1.0112737417221069335937500000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7385216923273657980894867871408613268193e-04) }},
{{ SC_(3.7568581319646909832954406738281250000000e-05), SC_(3.8644028125000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.8174519857164532475052618081523822045041e-410560) }},
{{ SC_(3.7793146475451067090034484863281250000000e-05), SC_(1.5007309615612030029296875000000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6635218409159996366428212380579616386369e-04) }},
{{ SC_(3.7963069189572706818580627441406250000000e-05), SC_(2.6506662368774414062500000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0194824523676295260535644600814027435989e-08) }},
{{ SC_(3.8241843867581337690353393554687500000000e-05), SC_(4.1891194880008697509765625000000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.4245410478400789568923204084271496037891e-04) }},
{{ SC_(3.8374593714252114295959472656250000000000e-05), SC_(4.6834993362426757812500000000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.5423755873953916195187872342969202813532e-04) }},
{{ SC_(3.9725298847770318388938903808593750000000e-05), SC_(2.8990346472710371017456054687500000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.8298749386158703140753906643343103500860e-04) }},
{{ SC_(3.9926064346218481659889221191406250000000e-05), SC_(4.9535178125000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.4290617776725095490336667453265158011523e-746416) }},
{{ SC_(4.0050683310255408287048339843750000000000e-05), SC_(4.2849838256835937500000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0678359287688203306880532695367188626278e-06) }},
{{ SC_(4.0149163396563380956649780273437500000000e-05), SC_(3.2462299804687500000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5336930675938229886332286780388068714272e-3334) }},
{{ SC_(4.0187464037444442510604858398437500000000e-05), SC_(4.2301240563392639160156250000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.0705510604648932922357766768120307107556e-04) }},
{{ SC_(4.0288010495714843273162841796875000000000e-05), SC_(2.5692817382812500000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.2004870568781167091436515375349579989798e-2015) }},
{{ SC_(4.0309605537913739681243896484375000000000e-05), SC_(3.9625889621675014495849609375000000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6261003312483537754887113356800183766633e-04) }},
{{ SC_(4.0620670915814116597175598144531250000000e-05), SC_(1.2048657238483428955078125000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.2877798731857278891970464431915588732656e-04) }},
{{ SC_(4.1166687879012897610664367675781250000000e-05), SC_(2.4253806640625000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.5070549088133660565861898399180474337079e-3886) }},
{{ SC_(4.1688290366437286138534545898437500000000e-05), SC_(4.5137223787605762481689453125000000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.8185709557109402436136787471633998218752e-04) }},
{{ SC_(4.1771381802391260862350463867187500000000e-05), SC_(2.7444700000000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3975926421252055322670197081515642386213e-17367) }},
{{ SC_(4.1807994421105831861495971679687500000000e-05), SC_(1.1457650363445281982421875000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.8789020089134484842547464731539424107949e-04) }},
{{ SC_(4.2011219193227589130401611328125000000000e-05), SC_(2.1881177963223308324813842773437500000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5157142156896466924566287788858944086544e-04) }},
{{ SC_(4.2571391531964763998985290527343750000000e-05), SC_(2.1993269348144531250000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.3490839795111027586662513229267002831104e-28) }},
{{ SC_(4.2588948417687788605690002441406250000000e-05), SC_(1.5419080227729864418506622314453125000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0204546856856587444438914838519185023372e-04) }},
{{ SC_(4.2938314436469227075576782226562500000000e-05), SC_(4.2876128107309341430664062500000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6437241042185292897343445729708760127463e-04) }},
{{ SC_(4.3233147152932360768318176269531250000000e-05), SC_(4.1743901367187500000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9269118950907466700723628906806283479657e-268) }},
{{ SC_(4.3628693674691021442413330078125000000000e-05), SC_(4.9540863037109375000000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2620694809231450405041814497327412772108e-33) }},
{{ SC_(4.3965173972537741065025329589843750000000e-05), SC_(1.8476973054930567741394042968750000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.4921801585809290178839076768301376442551e-04) }},
{{ SC_(4.5636130380444228649139404296875000000000e-05), SC_(2.6926603317260742187500000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.8919855131758802885611021950989483009801e-16) }},
{{ SC_(4.6231678425101563334465026855468750000000e-05), SC_(4.3400345020927488803863525390625000000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9100775749341765707073795070846422202054e-04) }},
{{ SC_(4.6535034925909712910652160644531250000000e-05), SC_(1.8841361452359706163406372070312500000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.2893109181725454291896102270543795795256e-05) }},
{{ SC_(4.6629418648080900311470031738281250000000e-05), SC_(3.5590532934293150901794433593750000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.8277676834481344616373243431487679105154e-04) }},
{{ SC_(4.6687746362295001745223999023437500000000e-05), SC_(3.7809313964843750000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0846108876069304047109011660444924263897e-1647) }},
{{ SC_(4.7170542529784142971038818359375000000000e-05), SC_(1.8689512634277343750000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1997330211405158605366066887009183397685e-85) }},
{{ SC_(4.7359728341689333319664001464843750000000e-05), SC_(3.7254381459206342697143554687500000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1900863102414759603244526491240095764827e-04) }},
{{ SC_(4.7360430471599102020263671875000000000000e-05), SC_(4.8598652343750000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3531980913981155127652388143121372265904e-21126) }},
{{ SC_(4.8008882004069164395332336425781250000000e-05), SC_(2.9623560607433319091796875000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.6350265830804600733382888034272708972335e-04) }},
{{ SC_(4.8286678065778687596321105957031250000000e-05), SC_(1.4394470781553536653518676757812500000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.0992502377112752844171595292905548826023e-04) }},
{{ SC_(4.8300276830559596419334411621093750000000e-05), SC_(4.9858455895446240901947021484375000000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.1006687043250336794851165015937088194068e-04) }},
{{ SC_(4.8371657612733542919158935546875000000000e-05), SC_(3.3238265991210937500000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4724325555539339937177240731958449048173e-28) }},
{{ SC_(4.8379697545897215604782104492187500000000e-05), SC_(3.0146507197059690952301025390625000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3808200450904934089632497449758725390205e-03) }},
{{ SC_(4.8389760195277631282806396484375000000000e-05), SC_(3.2950186729431152343750000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.2692283460254684721987033204415252644015e-07) }},
{{ SC_(4.8595542466500774025917053222656250000000e-05), SC_(4.8707799578551203012466430664062500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.0641826666755796204295255152282937047274e-04) }},
{{ SC_(4.8823709221323952078819274902343750000000e-05), SC_(4.9244385445490479469299316406250000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.7898865609388484268798511737772029804652e-04) }},
{{ SC_(1.0185369319515302777290344238281250000000e-04), SC_(1.1372692824807018041610717773437500000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.1193493995272112143941252952239681474455e-04) }},
{{ SC_(1.0616138024488463997840881347656250000000e-04), SC_(2.6199254989624023437500000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.1934589357854907761660971288736667234060e-08) }},
{{ SC_(1.1720951442839577794075012207031250000000e-04), SC_(4.6337348937988281250000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.6615416516345441711975490952545573653424e-24) }},
{{ SC_(1.1986176832579076290130615234375000000000e-04), SC_(4.2938214540481567382812500000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.6037843067526899324591046426961007671095e-04) }},
{{ SC_(1.2391182826831936836242675781250000000000e-04), SC_(2.7409827709197998046875000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.0447353832814933659540425568425736547556e-07) }},
{{ SC_(1.3038667384535074234008789062500000000000e-04), SC_(4.0496855974197387695312500000000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.0422909018031328321332421163360448124144e-04) }},
{{ SC_(1.3127022248227149248123168945312500000000e-04), SC_(4.4178039388498291373252868652343750000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.1775554816875067114415625030248409953017e-04) }},
{{ SC_(1.3245031004771590232849121093750000000000e-04), SC_(2.5176754760742187500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8676147982590180019361389233063135927969e-382) }},
{{ SC_(1.3352854875847697257995605468750000000000e-04), SC_(4.6503100747941061854362487792968750000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9424736982705336898742482779217463846237e-04) }},
{{ SC_(1.3377434515859931707382202148437500000000e-04), SC_(2.3849334684200584888458251953125000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.2184078066341474578742219730106102110464e-04) }},
{{ SC_(1.3858181773684918880462646484375000000000e-04), SC_(1.8936798572540283203125000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.9605457486851059805988909897685619056742e-05) }},
{{ SC_(1.4266111247707158327102661132812500000000e-04), SC_(2.9941767570562660694122314453125000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.7076992044072550778326704570749480043836e-04) }},
{{ SC_(1.4448109141085296869277954101562500000000e-04), SC_(1.6514885425567626953125000000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.6987332927639351071138185421499164027835e-03) }},
{{ SC_(1.4932757767383009195327758789062500000000e-04), SC_(2.0118238404393196105957031250000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6565556923942602990554383870031871943996e-03) }},
{{ SC_(1.5278931823559105396270751953125000000000e-04), SC_(2.9612059593200683593750000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.8725287183940360855902308967398767256790e-06) }},
{{ SC_(1.5442742733284831047058105468750000000000e-04), SC_(4.2084455490112304687500000000000000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.7990072501530459800083203384608350527665e-04) }},
{{ SC_(1.5798192180227488279342651367187500000000e-04), SC_(3.7211482413113117218017578125000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.9603045340711545732609250537418218428984e-03) }},
{{ SC_(1.5821559645701199769973754882812500000000e-04), SC_(2.1306932903826236724853515625000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.3214268429670641377887551193715142911740e-04) }},
{{ SC_(1.6095121100079268217086791992187500000000e-04), SC_(3.0127601348794996738433837890625000000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0915203276987475317895943106979138421663e-04) }},
{{ SC_(1.6759600839577615261077880859375000000000e-04), SC_(4.2365489959716796875000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0586633886224075348818780294558703274777e-34) }},
{{ SC_(1.6828322259243577718734741210937500000000e-04), SC_(1.9580098437500000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6935529145462839421446512394795950820774e-200886) }},
{{ SC_(1.7273881530854851007461547851562500000000e-04), SC_(4.9294424243271350860595703125000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.6760258784124848535786435071135963068492e-04) }},
{{ SC_(1.7340444901492446660995483398437500000000e-04), SC_(2.5428419494628906250000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.3763480756930622610716119395474755907943e-190) }},
{{ SC_(1.7356312309857457876205444335937500000000e-04), SC_(3.0190840363502502441406250000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0260053599283017788869343192521597308404e-03) }},
{{ SC_(1.7558199760969728231430053710937500000000e-04), SC_(4.2474957275390625000000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.6737803118509648126122866668422930895846e-72) }},
{{ SC_(1.7790572019293904304504394531250000000000e-04), SC_(2.7648940625000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0651325009895042591469758624823221627316e-202455) }},
{{ SC_(1.8309691222384572029113769531250000000000e-04), SC_(3.1605518750000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.4501626999469717477687108215153398543674e-18658) }},
{{ SC_(1.9036870799027383327484130859375000000000e-04), SC_(1.5913159375000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.0945383165983151190759951524057154854408e-124537) }},
{{ SC_(1.9106571562588214874267578125000000000000e-04), SC_(4.1986128125000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.4034851252163134328342054094486879586776e-446066) }},
{{ SC_(1.9159079238306730985641479492187500000000e-04), SC_(3.0219940526876598596572875976562500000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5151986694535019888090520925375634927757e-04) }},
{{ SC_(1.9219527894165366888046264648437500000000e-04), SC_(1.7779815625000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.6508791678068131434383641180273083066262e-28459) }},
{{ SC_(1.9391195382922887802124023437500000000000e-04), SC_(3.2115245819091796875000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2243825511924868167259446811841698557626e-05) }},
{{ SC_(1.9596645142883062362670898437500000000000e-04), SC_(1.1618844233453273773193359375000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3699161871878080393849179613708993079801e-03) }},
{{ SC_(1.9598100334405899047851562500000000000000e-04), SC_(4.2904194444417953491210937500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.5738540357143798248131754057961955287347e-03) }},
{{ SC_(1.9667651213239878416061401367187500000000e-04), SC_(2.0910120010375976562500000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.7717298654636675831642809834478692983483e-04) }},
{{ SC_(2.0394816237967461347579956054687500000000e-04), SC_(1.1802381050074473023414611816406250000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.4468864766797357118870329039334065438989e-04) }},
{{ SC_(2.0552115165628492832183837890625000000000e-04), SC_(1.3814207632094621658325195312500000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.3840539124020049328327563411596503696884e-04) }},
{{ SC_(2.1852832287549972534179687500000000000000e-04), SC_(2.1512197875976562500000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.5804599843033770698818452183648835629220e-17) }},
{{ SC_(2.2049853578209877014160156250000000000000e-04), SC_(1.0738034375000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.5251154920704647877712378961863260052437e-6797) }},
{{ SC_(2.2253980569075793027877807617187500000000e-04), SC_(1.4322476806640625000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.7791869865977691832124271674830516228847e-1052) }},
{{ SC_(2.3508777667302638292312622070312500000000e-04), SC_(4.5509043335914611816406250000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(7.5124667265515485743387331129628009964709e-04) }},
{{ SC_(2.4029082851484417915344238281250000000000e-04), SC_(4.9604398437500000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.1349982054617270986331708242468562525438e-21563) }},
{{ SC_(2.4038094852585345506668090820312500000000e-04), SC_(1.7982048913836479187011718750000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.3706913606916642486294584271655662169782e-03) }},
{{ SC_(2.4126343487296253442764282226562500000000e-04), SC_(1.2126102447509765625000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.5200040860816823647690775134077782737422e-04) }},
{{ SC_(2.4739385116845369338989257812500000000000e-04), SC_(2.3757189941406250000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1646957842810287700316005044007679911745e-189) }},
{{ SC_(2.4769871379248797893524169921875000000000e-04), SC_(1.1330743134021759033203125000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3678631731069562001934006004200159594773e-03) }},
{{ SC_(2.5144376559183001518249511718750000000000e-04), SC_(1.5605753906250000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0116364757464640984425060011555713973621e-990) }},
{{ SC_(2.5589551660232245922088623046875000000000e-04), SC_(1.8412075042724609375000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6694618418878085753293716388249853872035e-03) }},
{{ SC_(2.5991306756623089313507080078125000000000e-04), SC_(4.4235005043447017669677734375000000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9166896618311857057308246077733680587877e-03) }},
{{ SC_(2.6072320179082453250885009765625000000000e-04), SC_(2.5293316692113876342773437500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0822219391986123733744620230621352872681e-03) }},
{{ SC_(2.6156485546380281448364257812500000000000e-04), SC_(2.9697680473327636718750000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.1066254096959193588576610497711714707752e-04) }},
{{ SC_(2.6690683444030582904815673828125000000000e-04), SC_(4.9268922209739685058593750000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2482333376869263402798489472292163993743e-03) }},
{{ SC_(2.7256552129983901977539062500000000000000e-04), SC_(3.9997640997171401977539062500000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2978758093212055883220015631418302464063e-03) }},
{{ SC_(2.7427947497926652431488037109375000000000e-04), SC_(2.8920603125000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.3777204674313794449821915190465508644271e-435788) }},
{{ SC_(2.7434344519861042499542236328125000000000e-04), SC_(2.9544709472656250000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.8636980980809429411126938581640035697138e-476) }},
{{ SC_(2.7707131812348961830139160156250000000000e-04), SC_(3.4169257560279220342636108398437500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0084232417335373601757517274306465738076e-03) }},
{{ SC_(2.7871350175701081752777099609375000000000e-04), SC_(4.0231594238281250000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.4274930603719893727126169680486648796688e-1752) }},
{{ SC_(2.8021665639244019985198974609375000000000e-04), SC_(3.8819736801087856292724609375000000000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0719806615863957032559987721542824807019e-04) }},
{{ SC_(2.8036948060616850852966308593750000000000e-04), SC_(2.5140018463134765625000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2216359549676059229409021219009483202189e-40) }},
{{ SC_(2.8836930869147181510925292968750000000000e-04), SC_(4.6007328125000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.1724159772800828969078529404963347872813e-49933) }},
{{ SC_(2.9471665038727223873138427734375000000000e-04), SC_(4.6422597656250000000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.7115557742922139415242834097788999134456e-507) }},
{{ SC_(2.9570105834864079952239990234375000000000e-04), SC_(3.1762245297431945800781250000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.1458032189872327252545967701753506576203e-03) }},
{{ SC_(2.9634564998559653759002685546875000000000e-04), SC_(1.9913904368877410888671875000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0428254368838716488364878963026179331843e-03) }},
{{ SC_(3.0340347439050674438476562500000000000000e-04), SC_(2.5743593750000000000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.9721692447693484691097003739688256927687e-2018) }},
{{ SC_(3.0430863262154161930084228515625000000000e-04), SC_(4.4807470703125000000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.2135903881069443440369618594805051086345e-4600) }},
{{ SC_(3.0529979267157614231109619140625000000000e-04), SC_(1.5520052984356880187988281250000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3956877473588176022416225825003923840925e-03) }},
{{ SC_(3.1313023646362125873565673828125000000000e-04), SC_(4.7957000000000000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0608459926080077951610595482549956912153e-7678) }},
{{ SC_(3.1533697620034217834472656250000000000000e-04), SC_(3.1863677577348425984382629394531250000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1005023935146748129540212763262377476898e-04) }},
{{ SC_(3.1880356254987418651580810546875000000000e-04), SC_(3.8738800048828125000000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.9305066933282764839034962048169682672998e-26) }},
{{ SC_(3.1994408345781266689300537109375000000000e-04), SC_(1.0323757305741310119628906250000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.0794562479322720515527276863710125707961e-03) }},
{{ SC_(3.2006253604777157306671142578125000000000e-04), SC_(2.5544605468750000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.9338278494735889152345055758304626213553e-26211) }},
{{ SC_(3.3008345053531229496002197265625000000000e-04), SC_(4.0300145149230957031250000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.1833354505875397116897874748142261829785e-07) }},
{{ SC_(3.3188183442689478397369384765625000000000e-04), SC_(3.5095375496894121170043945312500000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.5241142088197290797972608382696464234241e-03) }},
{{ SC_(3.3481788705103099346160888671875000000000e-04), SC_(2.9065523437500000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4231437416199713795072604511704202471692e-43799) }},
{{ SC_(3.4882203908637166023254394531250000000000e-04), SC_(2.7546672150492668151855468750000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9256639195077324806363889581836149433714e-03) }},
{{ SC_(3.4899002639576792716979980468750000000000e-04), SC_(4.1187574218750000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.1298238383770060757160024427497924559871e-43761) }},
{{ SC_(3.5024742828682065010070800781250000000000e-04), SC_(4.2630761718750000000000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.7446612493878234192301409541381325195488e-440) }},
{{ SC_(3.5772722912952303886413574218750000000000e-04), SC_(3.1752218750000000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5726486972822787670136906197406391154408e-1877) }},
{{ SC_(3.5909839789383113384246826171875000000000e-04), SC_(2.9733074188232421875000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1722453640792465653975054758530148617302e-34) }},
{{ SC_(3.5964619019068777561187744140625000000000e-04), SC_(2.0331836700439453125000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.2059449401441647220281445648929755815394e-19) }},
{{ SC_(3.7471018731594085693359375000000000000000e-04), SC_(2.2500318908691406250000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6144516476750531346369937955807009615422e-101) }},
{{ SC_(3.9268896216526627540588378906250000000000e-04), SC_(1.5193861007690429687500000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.1892905961469783135268836981372553247372e-18) }},
{{ SC_(3.9787712739780545234680175781250000000000e-04), SC_(3.4937423706054687500000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.8098739542979414095079831388676686197424e-41) }},
{{ SC_(4.0996418101713061332702636718750000000000e-04), SC_(4.9080082681030035018920898437500000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0469122110398398263248545082423364309994e-03) }},
{{ SC_(4.1028507985174655914306640625000000000000e-04), SC_(2.2144558105468750000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7772038171681098191178136982494880676384e-143) }},
{{ SC_(4.1209097253158688545227050781250000000000e-04), SC_(3.6771405029296875000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1399196908746975912744365056878847187485e-393) }},
{{ SC_(4.1210078052245080471038818359375000000000e-04), SC_(4.5094556808471679687500000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.0127601907321461005838776474307092795783e-03) }},
{{ SC_(4.1793254786171019077301025390625000000000e-04), SC_(4.6684711914062500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.4374868335419786925808844366787929641791e-7037) }},
{{ SC_(4.2002741247415542602539062500000000000000e-04), SC_(3.6404779530130326747894287109375000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.4579001942787952066772257340443028683451e-03) }},
{{ SC_(4.2463216232135891914367675781250000000000e-04), SC_(1.7994914062500000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.1348231193187923167396410256638051177465e-1956) }},
{{ SC_(4.2692126589827239513397216796875000000000e-04), SC_(2.4527459754608571529388427734375000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.6979779664264235898488387393343469835456e-04) }},
{{ SC_(4.2705106898210942745208740234375000000000e-04), SC_(2.4434428710937500000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.4474176773647918690765747050102159822672e-2599) }},
{{ SC_(4.2847762233577668666839599609375000000000e-04), SC_(2.2900428771972656250000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.1466272176851248233096663713890002458385e-06) }},
{{ SC_(4.3032679241150617599487304687500000000000e-04), SC_(2.8498969186330214142799377441406250000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7706140033097601476786660762554636083670e-04) }},
{{ SC_(4.3772353092208504676818847656250000000000e-04), SC_(4.5439925000000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.2717145184729847073889335573392399775587e-197494) }},
{{ SC_(4.4121246901340782642364501953125000000000e-04), SC_(3.1357325613498687744140625000000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.9021927626884155651232632424081707710778e-03) }},
{{ SC_(4.4747791253030300140380859375000000000000e-04), SC_(3.7180789513513445854187011718750000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3444545800271130746267971352845372441737e-03) }},
{{ SC_(4.4771691318601369857788085937500000000000e-04), SC_(1.3102281372994184494018554687500000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4163935337531024507814220130034682740198e-03) }},
{{ SC_(4.5037711970508098602294921875000000000000e-04), SC_(1.0660823242187500000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.5270647184255903946452023089697983264030e-8346) }},
{{ SC_(4.6002154704183340072631835937500000000000e-04), SC_(2.3753580451011657714843750000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.0704798883425581282010490192660132329646e-03) }},
{{ SC_(4.6108645619824528694152832031250000000000e-04), SC_(2.2073093056678771972656250000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5269388416770210593825170303559473044395e-03) }},
{{ SC_(4.6425906475633382797241210937500000000000e-04), SC_(1.5319840749725699424743652343750000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.0368693607998020552046818953580993946558e-03) }},
{{ SC_(4.6533494605682790279388427734375000000000e-04), SC_(3.2330750400433316826820373535156250000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.4169654491479462994714548785391952141588e-04) }},
{{ SC_(4.7175434883683919906616210937500000000000e-04), SC_(2.8339877929687500000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2939688631956513167882116797489029239202e-170) }},
{{ SC_(4.7560062375850975513458251953125000000000e-04), SC_(1.9603037109375000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.9638798961863947019744238416273701503378e-14357) }},
{{ SC_(4.7682021977379918098449707031250000000000e-04), SC_(4.8197736740112304687500000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.8580680030529838148972285596393885354426e-07) }},
{{ SC_(4.7791490214876830577850341796875000000000e-04), SC_(1.1917771399021148681640625000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1354566078007588027257427985333043982727e-03) }},
{{ SC_(4.8245381913147866725921630859375000000000e-04), SC_(3.6078746318817138671875000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.1251190583707849122814306939464009896838e-06) }},
{{ SC_(4.8475922085344791412353515625000000000000e-04), SC_(4.9197027692571282386779785156250000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0814367282728813722144427175154482472037e-03) }},
{{ SC_(4.9845391185954213142395019531250000000000e-04), SC_(2.7903375666937790811061859130859375000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.0965169492126037319385129180292522357343e-04) }},
{{ SC_(1.1146966135129332542419433593750000000000e-03), SC_(3.3842318725585937500000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6212637166027362865736997645785905817280e-57) }},
{{ SC_(1.1168811470270156860351562500000000000000e-03), SC_(2.0636825356632471084594726562500000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.3916012060809226520830341365978986547182e-03) }},
{{ SC_(1.1221637250855565071105957031250000000000e-03), SC_(2.6959133148193359375000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5983318219029844879591913573045476865345e-04) }},
{{ SC_(1.1509554460644721984863281250000000000000e-03), SC_(4.5358744263648986816406250000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.7141483238905229807229639556250400008285e-03) }},
{{ SC_(1.1697246227413415908813476562500000000000e-03), SC_(4.4872207031250000000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.2500709893994874922948110036206609502101e-490) }},
{{ SC_(1.2384754372760653495788574218750000000000e-03), SC_(4.8098876953125000000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.4433873458058292088786383617196922988160e-286) }},
{{ SC_(1.2418846599757671356201171875000000000000e-03), SC_(2.1106562500000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6921662958050124797307339272689183630517e-91736) }},
{{ SC_(1.2857818510383367538452148437500000000000e-03), SC_(4.7384111328125000000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.7484622126110819336108169331891790723530e-761) }},
{{ SC_(1.3338791904971003532409667968750000000000e-03), SC_(4.6277761718750000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.4445488427585501086621205522098573758876e-49168) }},
{{ SC_(1.3420631876215338706970214843750000000000e-03), SC_(4.9741393886506557464599609375000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.4953095111356858676186107117570855708804e-03) }},
{{ SC_(1.3869201065972447395324707031250000000000e-03), SC_(2.1587575683593750000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.8838533182961167879132979009362167950849e-1583) }},
{{ SC_(1.3948490377515554428100585937500000000000e-03), SC_(4.0674161911010742187500000000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.9804477168886506612685545836058155144617e-03) }},
{{ SC_(1.4270475367084145545959472656250000000000e-03), SC_(3.0078976154327392578125000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.5412686472284705812911879325689021932068e-03) }},
{{ SC_(1.4444768894463777542114257812500000000000e-03), SC_(3.8292859244393184781074523925781250000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3709490660009122585354082449348335431230e-04) }},
{{ SC_(1.4696706784889101982116699218750000000000e-03), SC_(2.2998542408458888530731201171875000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3166297178204865419184148903633109677873e-03) }},
{{ SC_(1.5326840803027153015136718750000000000000e-03), SC_(1.3060160156250000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7008426159810406172458099034634845255558e-19681) }},
{{ SC_(1.5462125884369015693664550781250000000000e-03), SC_(4.3884387612342834472656250000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.6615341205683655192427725551461319350401e-03) }},
{{ SC_(1.5994617715477943420410156250000000000000e-03), SC_(1.7804295654296875000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.3149668728855588248346627023637295012342e-2685) }},
{{ SC_(1.6717085381969809532165527343750000000000e-03), SC_(4.8519897460937500000000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.9569465451331914088302201577026536148015e-358) }},
{{ SC_(1.6935544554144144058227539062500000000000e-03), SC_(3.8556156250000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1576757512113325950348333158100592470559e-22759) }},
{{ SC_(1.7316899029538035392761230468750000000000e-03), SC_(1.9800770568847656250000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.2311454578531087331482978360527058620291e-14) }},
{{ SC_(1.7392651643604040145874023437500000000000e-03), SC_(3.3375290513504296541213989257812500000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5326198542071159412136215245411910282875e-04) }},
{{ SC_(1.7912392504513263702392578125000000000000e-03), SC_(3.0554368495941162109375000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4819911541571292497174696910018271567729e-06) }},
{{ SC_(1.8869870109483599662780761718750000000000e-03), SC_(4.3248571455478668212890625000000000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5115383487771413275696362132703994702706e-03) }},
{{ SC_(1.9263775320723652839660644531250000000000e-03), SC_(2.6062861084938049316406250000000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.3140056860435318856818774158299668096278e-03) }},
{{ SC_(1.9491343991830945014953613281250000000000e-03), SC_(4.8745614476501941680908203125000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.7388403715939094081812160693351835503779e-02) }},
{{ SC_(1.9597280770540237426757812500000000000000e-03), SC_(2.3320210266113281250000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9701393528945252769897362728654210027118e-17) }},
{{ SC_(2.0322587806731462478637695312500000000000e-03), SC_(1.6493140719830989837646484375000000000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0675035869108204292978751804409768979190e-04) }},
{{ SC_(2.0474849734455347061157226562500000000000e-03), SC_(2.3111911118030548095703125000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.1090026767928060615712923466974460433092e-03) }},
{{ SC_(2.0488470327109098434448242187500000000000e-03), SC_(1.1682164767989888787269592285156250000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.3924685636133719266360424832550846762826e-04) }},
{{ SC_(2.0499289967119693756103515625000000000000e-03), SC_(1.7262918408960103988647460937500000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.9622194099369500398978516518805255894672e-03) }},
{{ SC_(2.1867034956812858581542968750000000000000e-03), SC_(3.6231195554137229919433593750000000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2538678028876496159232331634153067367053e-03) }},
{{ SC_(2.2444091737270355224609375000000000000000e-03), SC_(1.3592925824923440814018249511718750000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2123960435803204243103676314832148081547e-04) }},
{{ SC_(2.2751130163669586181640625000000000000000e-03), SC_(2.6807599351741373538970947265625000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.8082275065636867675620598133100272001685e-03) }},
{{ SC_(2.3366522509604692459106445312500000000000e-03), SC_(3.8798837661743164062500000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.8750951961221655235410720894124225168797e-06) }},
{{ SC_(2.3414273746311664581298828125000000000000e-03), SC_(1.5162646770477294921875000000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2737761118005416066555590375136452267158e-02) }},
{{ SC_(2.4697466287761926651000976562500000000000e-03), SC_(1.6062967479228973388671875000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.6010895757760152847877882288561779375846e-02) }},
{{ SC_(2.5637513026595115661621093750000000000000e-03), SC_(3.4688196875000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6253534868826310969249464175570424442994e-21948) }},
{{ SC_(2.5820608716458082199096679687500000000000e-03), SC_(3.5458743572235107421875000000000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.5937978414535404707900788526959677612554e-02) }},
{{ SC_(2.5970311835408210754394531250000000000000e-03), SC_(4.4323968750000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.3538058059701126122070972352638462688337e-324553) }},
{{ SC_(2.6348794344812631607055664062500000000000e-03), SC_(1.5349454770330339670181274414062500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.0591581852583689583018032231514018760247e-04) }},
{{ SC_(2.6671977248042821884155273437500000000000e-03), SC_(3.4691165625000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3776939036313978467122830615443127468115e-355918) }},
{{ SC_(2.6966670993715524673461914062500000000000e-03), SC_(4.1276367846876382827758789062500000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.5191298272687294254859489355933240625551e-03) }},
{{ SC_(2.7208295650780200958251953125000000000000e-03), SC_(3.5322547773830592632293701171875000000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.0163965847985196960029212515698138539308e-04) }},
{{ SC_(2.7295660693198442459106445312500000000000e-03), SC_(1.9772785156250000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.0365048601767829339883410426267334895674e-15476) }},
{{ SC_(2.7554798871278762817382812500000000000000e-03), SC_(3.7216264900052919983863830566406250000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6640604374479320782303280410180301099463e-04) }},
{{ SC_(2.8151907026767730712890625000000000000000e-03), SC_(2.7477316406250000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.5776360210863456846948942066750127630285e-20122) }},
{{ SC_(2.8353952802717685699462890625000000000000e-03), SC_(1.8550909589976072311401367187500000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.6940066645013180804654349236336874971099e-02) }},
{{ SC_(2.8843537438660860061645507812500000000000e-03), SC_(2.2729287719726562500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.1307816567650394766984741472626916230355e-344) }},
{{ SC_(2.9196885880082845687866210937500000000000e-03), SC_(2.6060781478881835937500000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.3114493737749930323676866805951793230278e-07) }},
{{ SC_(2.9544357676059007644653320312500000000000e-03), SC_(2.3773116990923881530761718750000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.5167107316854151058858900349799606758940e-03) }},
{{ SC_(2.9555910732597112655639648437500000000000e-03), SC_(2.6531625539064407348632812500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1126039073395881159527878976564198149075e-02) }},
{{ SC_(2.9596057720482349395751953125000000000000e-03), SC_(2.2406239318847656250000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.3704452158580859541037618444287874819504e-100) }},
{{ SC_(2.9766957741230726242065429687500000000000e-03), SC_(1.0501551628112792968750000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.3238261354344209259066605054030325776909e-02) }},
{{ SC_(3.0000896658748388290405273437500000000000e-03), SC_(2.0157722473144531250000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1378749042690357154297130321476561234858e-04) }},
{{ SC_(3.0018866527825593948364257812500000000000e-03), SC_(2.2901318359375000000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9153607794723652787000388164564851124827e-245) }},
{{ SC_(3.0314330942928791046142578125000000000000e-03), SC_(1.4527700841426849365234375000000000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.5938233654378278113991323040444537419371e-03) }},
{{ SC_(3.0743796378374099731445312500000000000000e-03), SC_(4.7442203125000000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(8.1459490509410948607848842976103462234652e-3004) }},
{{ SC_(3.0845431610941886901855468750000000000000e-03), SC_(1.7596220597624778747558593750000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5103006632358401157642710085139062590507e-02) }},
{{ SC_(3.0865992885082960128784179687500000000000e-03), SC_(3.6684562988281250000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.6292013005117905163735709571802430306308e-1597) }},
{{ SC_(3.1075035221874713897705078125000000000000e-03), SC_(4.6357459375000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6377535510420021404970569155481010138464e-362787) }},
{{ SC_(3.1872228719294071197509765625000000000000e-03), SC_(1.9062053412199020385742187500000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.3091976960640926980584365401582194223746e-02) }},
{{ SC_(3.3068859484046697616577148437500000000000e-03), SC_(3.0580783843994140625000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.2366927801395175783763256440746115410099e-48) }},
{{ SC_(3.3141002058982849121093750000000000000000e-03), SC_(2.1265090908855199813842773437500000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5100406412506925639529963415264043887733e-02) }},
{{ SC_(3.3795842900872230529785156250000000000000e-03), SC_(2.7982244500890374183654785156250000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.3134328742881598832919821043945197859701e-03) }},
{{ SC_(3.4113724250346422195434570312500000000000e-03), SC_(4.1894565219990909099578857421875000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.1551847355272232262852658677313507833267e-03) }},
{{ SC_(3.4394664689898490905761718750000000000000e-03), SC_(4.7370025634765625000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.7703111824230420243982582660100832366530e-37) }},
{{ SC_(3.4706655424088239669799804687500000000000e-03), SC_(2.8901008605957031250000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.1591792936091500805406313920248735242083e-25) }},
{{ SC_(3.4962403587996959686279296875000000000000e-03), SC_(1.6806090250611305236816406250000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.8627296684170674467557549597414001939934e-02) }},
{{ SC_(3.5118935629725456237792968750000000000000e-03), SC_(3.0600946875000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.5880099782618915225036041363398497042732e-461107) }},
{{ SC_(3.5959659144282341003417968750000000000000e-03), SC_(3.5727242187500000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.3814279395792897382064202127386045672482e-5720) }},
{{ SC_(3.6150293890386819839477539062500000000000e-03), SC_(1.0063916444778442382812500000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.6451107195725955803987563458257545780140e-02) }},
{{ SC_(3.6274394951760768890380859375000000000000e-03), SC_(1.7232748437500000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.6173443475569842733657281503741625774623e-183083) }},
{{ SC_(3.6384209524840116500854492187500000000000e-03), SC_(2.6888734375000000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0603680427820137333128890938858857784461e-1589) }},
{{ SC_(3.7165421526879072189331054687500000000000e-03), SC_(2.1962072700262069702148437500000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2166771256593736028407516627672298285348e-02) }},
{{ SC_(3.7189119029790163040161132812500000000000e-03), SC_(2.1678431332111358642578125000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.5696774740260169001829774540149959433689e-02) }},
{{ SC_(3.7278875242918729782104492187500000000000e-03), SC_(3.1388840332031250000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(8.4314267388582423303237029118728075076749e-201) }},
{{ SC_(3.7949834950268268585205078125000000000000e-03), SC_(1.2617802619934082031250000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.1922422931770891778917080464863234492299e-03) }},
{{ SC_(3.8448632694780826568603515625000000000000e-03), SC_(1.6702232824172824621200561523437500000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.4726383584781564801142997254964464393380e-04) }},
{{ SC_(3.8507778663188219070434570312500000000000e-03), SC_(3.9876168823242187500000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.5775971052303286445443601414757469649552e-411) }},
{{ SC_(3.8601483684033155441284179687500000000000e-03), SC_(1.3947961330413818359375000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.1125787618849661644041394106024932244811e-03) }},
{{ SC_(3.8849101401865482330322265625000000000000e-03), SC_(1.9230575859546661376953125000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.4849195173537051095956699130733553361342e-02) }},
{{ SC_(3.8897583726793527603149414062500000000000e-03), SC_(3.8188947753906250000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.1327691702263826307684878986299050945931e-4059) }},
{{ SC_(3.9213234558701515197753906250000000000000e-03), SC_(1.4029539888724684715270996093750000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.8241165804593671540495535360298848832279e-03) }},
{{ SC_(3.9762970991432666778564453125000000000000e-03), SC_(3.7592052459716796875000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4323572585148833136096782115778935815878e-04) }},
{{ SC_(4.1162068955600261688232421875000000000000e-03), SC_(2.1463463306427001953125000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.7496587526136662243973876699100327636683e-03) }},
{{ SC_(4.1847354732453823089599609375000000000000e-03), SC_(3.3313855528831481933593750000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.7090572038526990242111183045676710636222e-02) }},
{{ SC_(4.2013223282992839813232421875000000000000e-03), SC_(2.8909285156250000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.3408717554349644586270159619478930393395e-12567) }},
{{ SC_(4.2040585540235042572021484375000000000000e-03), SC_(4.0517253801226615905761718750000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1892694791678998905898300394009178833451e-02) }},
{{ SC_(4.2134574614465236663818359375000000000000e-03), SC_(2.5879273437500000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6750353364106837565378624549986468234093e-41420) }},
{{ SC_(4.2219576425850391387939453125000000000000e-03), SC_(2.9536075592041015625000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2650168226669232402941803223134351485130e-33) }},
{{ SC_(4.2701885104179382324218750000000000000000e-03), SC_(1.9275544433593750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3473705170632958949903169226372866364661e-1979) }},
{{ SC_(4.2725945822894573211669921875000000000000e-03), SC_(1.2620977783203125000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.4637279091897927039132905554730456345950e-990) }},
{{ SC_(4.3012551032006740570068359375000000000000e-03), SC_(3.0236775390625000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3843755051242184364052956520728526255447e-31023) }},
{{ SC_(4.3255193158984184265136718750000000000000e-03), SC_(1.7563367187500000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.0741008774035756147180601071836490561972e-19063) }},
{{ SC_(4.4377688318490982055664062500000000000000e-03), SC_(3.4436649322509765625000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.4736043361596580565078662669662940664044e-37) }},
{{ SC_(4.5406725257635116577148437500000000000000e-03), SC_(4.8368865251541137695312500000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.5548488918404776741291152624452959411366e-02) }},
{{ SC_(4.5460476540029048919677734375000000000000e-03), SC_(3.0094494628906250000000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.9009920122474051033456066258005208264776e-35) }},
{{ SC_(4.5636901631951332092285156250000000000000e-03), SC_(2.4213948249816894531250000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.2399027800223120472893177523486074255967e-04) }},
{{ SC_(4.6148826368153095245361328125000000000000e-03), SC_(2.5390207767486572265625000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.2503175979276396306896959371437684155788e-04) }},
{{ SC_(4.6188887208700180053710937500000000000000e-03), SC_(2.0579061508178710937500000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.2927085924767351365096654961259257101774e-11) }},
{{ SC_(4.6195238828659057617187500000000000000000e-03), SC_(3.9066177123459056019783020019531250000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.6627927728778375717245773878912462203128e-04) }},
{{ SC_(4.6531474217772483825683593750000000000000e-03), SC_(1.0722650587558746337890625000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5052676191845872432482104711933173572268e-02) }},
{{ SC_(4.6935188584029674530029296875000000000000e-03), SC_(3.5782020859187468886375427246093750000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.0020316636328359527217614970333746629356e-04) }},
{{ SC_(4.7154170460999011993408203125000000000000e-03), SC_(1.9765531178563833236694335937500000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.9664284784028490158059407271919601563531e-03) }},
{{ SC_(4.8523540608584880828857421875000000000000e-03), SC_(3.4237127751111984252929687500000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.7766140799949562551584169415201464778911e-02) }},
{{ SC_(4.8918980173766613006591796875000000000000e-03), SC_(1.5688688476562500000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.2047756993917109267911964212159462244489e-1705) }},
{{ SC_(4.9147224053740501403808593750000000000000e-03), SC_(1.9296014404296875000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.6082899790762150403173678537821080967886e-153) }},
{{ SC_(4.9189934507012367248535156250000000000000e-03), SC_(2.4185523216146975755691528320312500000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5928445023260091641581595022128651227028e-04) }},
{{ SC_(4.9519282765686511993408203125000000000000e-03), SC_(4.0769729763269424438476562500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2711471721850292638054402358861645371587e-01) }},
{{ SC_(1.0619485750794410705566406250000000000000e-02), SC_(4.2644682253012433648109436035156250000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.4270176242812503101676568009119854616265e-04) }},
{{ SC_(1.0900503024458885192871093750000000000000e-02), SC_(1.1959328651428222656250000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3032199027247936565850231723956688682484e-10) }},
{{ SC_(1.1304032988846302032470703125000000000000e-02), SC_(1.2501729652285575866699218750000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.2206011306093916297264982312291906860724e-02) }},
{{ SC_(1.1344153434038162231445312500000000000000e-02), SC_(3.1156826782226562500000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.1561225053801713998188174318245568640147e-321) }},
{{ SC_(1.2107079848647117614746093750000000000000e-02), SC_(4.7863091458566486835479736328125000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.6247773661800069168882420375847861861199e-03) }},
{{ SC_(1.2719709426164627075195312500000000000000e-02), SC_(4.6178993750000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.1009697542642831952102526356542305762626e-695841) }},
{{ SC_(1.2752244248986244201660156250000000000000e-02), SC_(2.1846704101562500000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3786551814201166932905921196495321316632e-233) }},
{{ SC_(1.3632931746542453765869140625000000000000e-02), SC_(1.2715393554687500000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0263191117391765521404845086939593954585e-1381) }},
{{ SC_(1.3769173994660377502441406250000000000000e-02), SC_(4.1058148193359375000000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3220033596713889544849849591274816773704e-27) }},
{{ SC_(1.4225168153643608093261718750000000000000e-02), SC_(3.7250854492187500000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.7741166418651004941387158820445736581819e-3959) }},
{{ SC_(1.4248653315007686614990234375000000000000e-02), SC_(2.9711585739278234541416168212890625000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.9585523119552388308798829445486714140575e-04) }},
{{ SC_(1.4310760423541069030761718750000000000000e-02), SC_(2.4992504119873046875000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.2791266215640279844599887015541926534999e-05) }},
{{ SC_(1.4824463985860347747802734375000000000000e-02), SC_(3.8286387920379638671875000000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.9796789546900035662784283134565525384414e-02) }},
{{ SC_(1.5120575204491615295410156250000000000000e-02), SC_(4.5269015245139598846435546875000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.0340296100659621056638698829973092814667e-02) }},
{{ SC_(1.6146268695592880249023437500000000000000e-02), SC_(3.1081712890625000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5362783124682873210856902037619866885897e-13510) }},
{{ SC_(1.6256198287010192871093750000000000000000e-02), SC_(2.3431915789842605590820312500000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1445841612791249020311869692389699554118e-01) }},
{{ SC_(1.6459390521049499511718750000000000000000e-02), SC_(2.9527359008789062500000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.4543355887460501117933850119476066291797e-33) }},
{{ SC_(1.6686735674738883972167968750000000000000e-02), SC_(1.6884712749742902815341949462890625000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.2004087138620815167917380883663784085381e-05) }},
{{ SC_(1.6844842582941055297851562500000000000000e-02), SC_(3.9571900852024555206298828125000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0475338327013753664630065233982584245196e-01) }},
{{ SC_(1.7125299200415611267089843750000000000000e-02), SC_(2.2507077082991600036621093750000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4338390096532705619141603484672265945758e-02) }},
{{ SC_(1.7150647938251495361328125000000000000000e-02), SC_(2.7165061950683593750000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.0802838431341161374865602118474178970526e-42) }},
{{ SC_(1.7617329955101013183593750000000000000000e-02), SC_(2.8260417282581329345703125000000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.5050834765709432208237457513453288391733e-02) }},
{{ SC_(1.7636947333812713623046875000000000000000e-02), SC_(3.3839240670204162597656250000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.7781538985500291978454138534850860433470e-02) }},
{{ SC_(1.7924735322594642639160156250000000000000e-02), SC_(4.4572294427780434489250183105468750000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.2010788992957360126620351048645259142411e-04) }},
{{ SC_(1.9047506153583526611328125000000000000000e-02), SC_(2.9119831323623657226562500000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0590635738635335519487525409488261813930e-01) }},
{{ SC_(1.9628280773758888244628906250000000000000e-02), SC_(2.6630503125000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.8788711458778569572974184004227092106284e-115743) }},
{{ SC_(2.0072245970368385314941406250000000000000e-02), SC_(3.6188943386077880859375000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0986278698629980757604218304609232911129e-01) }},
{{ SC_(2.0429119467735290527343750000000000000000e-02), SC_(3.6368423461914062500000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5389436018890561538737297566595624931140e-07) }},
{{ SC_(2.0611235871911048889160156250000000000000e-02), SC_(4.9858999252319335937500000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5677052336097412990973031678848520857757e-02) }},
{{ SC_(2.0658859983086585998535156250000000000000e-02), SC_(1.2765601562500000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0737730934533970512080094719261458523064e-2044) }},
{{ SC_(2.0764775574207305908203125000000000000000e-02), SC_(4.8875092761591076850891113281250000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.0336528358560516722691488016144201325497e-03) }},
{{ SC_(2.1240210160613059997558593750000000000000e-02), SC_(2.0481953125000000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.5074783480694195224773769182605035050887e-14999) }},
{{ SC_(2.1562583744525909423828125000000000000000e-02), SC_(1.2217657812500000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2897810464099723689100073991273216793707e-95614) }},
{{ SC_(2.1617626771330833435058593750000000000000e-02), SC_(1.3122677803039550781250000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4725031360534077127620759623356594823762e-01) }},
{{ SC_(2.1679364144802093505859375000000000000000e-02), SC_(4.2985266190953552722930908203125000000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6982777484264575590034740194763904557741e-04) }},
{{ SC_(2.2058198228478431701660156250000000000000e-02), SC_(2.2419597953557968139648437500000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.7526442513055651510423320920577991435741e-02) }},
{{ SC_(2.2508755326271057128906250000000000000000e-02), SC_(2.9670085906982421875000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0436745669376453364347058558619798408573e-31) }},
{{ SC_(2.2783989086747169494628906250000000000000e-02), SC_(2.3013114929199218750000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4721974305831553858650404185028582796711e-347) }},
{{ SC_(2.3005828261375427246093750000000000000000e-02), SC_(3.7318659667968750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.1613883301372097075793139902294266520428e-3830) }},
{{ SC_(2.3579735308885574340820312500000000000000e-02), SC_(3.4650889574550092220306396484375000000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1462210929409283097219221936330046504443e-03) }},
{{ SC_(2.3755080997943878173828125000000000000000e-02), SC_(1.8150388002395629882812500000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.8941072025608605789952779485341385108844e-03) }},
{{ SC_(2.4756660684943199157714843750000000000000e-02), SC_(3.5372134298086166381835937500000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.0567070640311999702578733980432036770031e-02) }},
{{ SC_(2.4896388873457908630371093750000000000000e-02), SC_(1.7812990336096845567226409912109375000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2863102227518713794429606406922264945408e-04) }},
{{ SC_(2.5050887838006019592285156250000000000000e-02), SC_(1.6926521062850952148437500000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7386666053151713254447268034876144848811e-01) }},
{{ SC_(2.5384765118360519409179687500000000000000e-02), SC_(1.0728470236063003540039062500000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9993449158886568605404524482785141643612e-01) }},
{{ SC_(2.6304770261049270629882812500000000000000e-02), SC_(3.0641914062500000000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.2906550759884159584505639561636911823865e-334) }},
{{ SC_(2.6709763333201408386230468750000000000000e-02), SC_(3.2671095686964690685272216796875000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.0667033968150906984952015652788468454347e-03) }},
{{ SC_(2.6913423091173171997070312500000000000000e-02), SC_(3.2558594830334186553955078125000000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.1184566139603808751151364057059586868328e-03) }},
{{ SC_(2.6915425434708595275878906250000000000000e-02), SC_(2.5789108276367187500000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6248609022898710713513819222084157173554e-16) }},
{{ SC_(2.6938116177916526794433593750000000000000e-02), SC_(3.7925875000000000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0374821377759484589830311691520590503853e-2400) }},
{{ SC_(2.7010373771190643310546875000000000000000e-02), SC_(4.0798625946044921875000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.5816850548952250617329288311177389203487e-33) }},
{{ SC_(2.7130119502544403076171875000000000000000e-02), SC_(3.9075726270675659179687500000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0114018734095834739974648118205762681740e-01) }},
{{ SC_(2.7266047894954681396484375000000000000000e-02), SC_(2.4372977350139990448951721191406250000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9677986534844407674367216878403592494978e-04) }},
{{ SC_(2.7603406459093093872070312500000000000000e-02), SC_(2.9335007812500000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3934156552902576720665200232905168132515e-22958) }},
{{ SC_(2.8296975418925285339355468750000000000000e-02), SC_(1.3777629882812500000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.8286558891197193698642142940986205725550e-14638) }},
{{ SC_(2.8429036960005760192871093750000000000000e-02), SC_(3.1190520152449607849121093750000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0168350411199027980157730769224832320028e-01) }},
{{ SC_(2.8836971148848533630371093750000000000000e-02), SC_(3.9940206909179687500000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.8929125807452701135189079459970008821990e-65) }},
{{ SC_(2.9280882328748703002929687500000000000000e-02), SC_(4.5102921128273010253906250000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.5532133701454707049953104060621061592921e-02) }},
{{ SC_(2.9587507247924804687500000000000000000000e-02), SC_(1.8167886082665063440799713134765625000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2887873924974142187382147380423523945590e-04) }},
{{ SC_(3.0722083523869514465332031250000000000000e-02), SC_(4.8793487500000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.4919666626127900860665974246525223484549e-28800) }},
{{ SC_(3.1085710972547531127929687500000000000000e-02), SC_(1.5232218750000000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3223100215231888519416678792829795837035e-15628) }},
{{ SC_(3.1234571710228919982910156250000000000000e-02), SC_(3.5244797363281250000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.2796208628301652425762528761302572647640e-209) }},
{{ SC_(3.1253356486558914184570312500000000000000e-02), SC_(3.9944365234375000000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.1553299819205330542714092490987477807636e-3127) }},
{{ SC_(3.1565058976411819458007812500000000000000e-02), SC_(1.9708946347236633300781250000000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.3774609197364965078947774839350112681101e-03) }},
{{ SC_(3.1914833933115005493164062500000000000000e-02), SC_(3.3934754901565611362457275390625000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4220151930375247549361877081903612606417e-03) }},
{{ SC_(3.2447990030050277709960937500000000000000e-02), SC_(1.5262463130056858062744140625000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(8.2897071930265549137231150222801262488789e-02) }},
{{ SC_(3.3319454640150070190429687500000000000000e-02), SC_(3.9893248677253723144531250000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.5950653642645402543195041415464927549186e-01) }},
{{ SC_(3.3362772315740585327148437500000000000000e-02), SC_(4.6284341812133789062500000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.4330177045266572319532893773643241875540e-06) }},
{{ SC_(3.3580299466848373413085937500000000000000e-02), SC_(1.9390623271465301513671875000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4696980514657133797753847795849977554807e-01) }},
{{ SC_(3.3774249255657196044921875000000000000000e-02), SC_(3.3470600128173828125000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.6543178326761265625200973999545018074146e-16) }},
{{ SC_(3.3940948545932769775390625000000000000000e-02), SC_(4.8990173339843750000000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6040561069112446982705502636892551161233e-54) }},
{{ SC_(3.4438345581293106079101562500000000000000e-02), SC_(1.3153695068359375000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3502343648285014335430565766278342976293e-1982) }},
{{ SC_(3.4683633595705032348632812500000000000000e-02), SC_(2.8910765647888183593750000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.7536911807584207784382430626421991624510e-02) }},
{{ SC_(3.5508364439010620117187500000000000000000e-02), SC_(2.0727054687500000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.8852771073826825330445929164138614338264e-22495) }},
{{ SC_(3.5541228950023651123046875000000000000000e-02), SC_(3.5334533691406250000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.6855438426927695190387608079897680586707e-278) }},
{{ SC_(3.5790581256151199340820312500000000000000e-02), SC_(1.9347016513347625732421875000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.4876191991760058266618546338824870445489e-01) }},
{{ SC_(3.6177828907966613769531250000000000000000e-02), SC_(4.9780214843750000000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.5354012778292249594799150228246657312993e-316) }},
{{ SC_(3.6653555929660797119140625000000000000000e-02), SC_(3.9511634968221187591552734375000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.9580633667061597391556309359138333786911e-02) }},
{{ SC_(3.6661118268966674804687500000000000000000e-02), SC_(1.7419039504602551460266113281250000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0903718461834412618381308185012884118850e-02) }},
{{ SC_(3.6767013370990753173828125000000000000000e-02), SC_(1.0332576930522918701171875000000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6109786423776110695155694983037097999428e-02) }},
{{ SC_(3.6872327327728271484375000000000000000000e-02), SC_(3.4549765625000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.7733337436617286800127634939955048499829e-354466) }},
{{ SC_(3.7044893950223922729492187500000000000000e-02), SC_(2.8988734375000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.8531373264673361045739530183974554277199e-212263) }},
{{ SC_(3.7805620580911636352539062500000000000000e-02), SC_(2.9624768750000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1379889721758465720301599144818339146513e-314735) }},
{{ SC_(3.7837971001863479614257812500000000000000e-02), SC_(3.5380081176757812500000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.4720281733966297568052875008239044236833e-155) }},
{{ SC_(3.7924218922853469848632812500000000000000e-02), SC_(4.2914366349577903747558593750000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.6232178859164502046872387024974791091135e-02) }},
{{ SC_(3.7995513528585433959960937500000000000000e-02), SC_(1.2887210083007812500000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3289401384946712813315439612674551204149e-95) }},
{{ SC_(3.8043949753046035766601562500000000000000e-02), SC_(1.4825956895947456359863281250000000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1284241000114918720699964660330720266543e-02) }},
{{ SC_(3.8734357804059982299804687500000000000000e-02), SC_(1.9822989501953125000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.3752313050407738060140620795593655146637e-863) }},
{{ SC_(3.9209950715303421020507812500000000000000e-02), SC_(4.0916037559509277343750000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.9072272362340439611950210447886514915909e-04) }},
{{ SC_(3.9514325559139251708984375000000000000000e-02), SC_(1.6667931049596518278121948242187500000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.4300819673722174125123692152800048968998e-04) }},
{{ SC_(4.1152086108922958374023437500000000000000e-02), SC_(2.8357451171875000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.8638613388039387495330937986140423842413e-1675) }},
{{ SC_(4.2710423469543457031250000000000000000000e-02), SC_(2.3069467544555664062500000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.5258658484795016843061663940426140819077e-04) }},
{{ SC_(4.2799249291419982910156250000000000000000e-02), SC_(3.8978156738281250000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.2617587454658782178651290516017671832417e-625) }},
{{ SC_(4.2975053191184997558593750000000000000000e-02), SC_(3.1283900737762451171875000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.4539014574246092344698204156174957784698e-03) }},
{{ SC_(4.4220913201570510864257812500000000000000e-02), SC_(2.0112933591008186340332031250000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.2748771994828835009234661953549986653473e-01) }},
{{ SC_(4.5014861971139907836914062500000000000000e-02), SC_(1.4815267578125000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7202241349105880078969429760245964298823e-22324) }},
{{ SC_(4.5186147093772888183593750000000000000000e-02), SC_(2.3067970275878906250000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4430113155264305325985832046461032705230e-02) }},
{{ SC_(4.5274659991264343261718750000000000000000e-02), SC_(1.3598117046058177947998046875000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.6572550178750809950081544935547323344611e-02) }},
{{ SC_(4.6252325177192687988281250000000000000000e-02), SC_(4.3923553466796875000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.1824501221792236808563543725246265971302e-03) }},
{{ SC_(4.6813279390335083007812500000000000000000e-02), SC_(2.5698760873638093471527099609375000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9862029446665225645951769154212298635768e-03) }},
{{ SC_(4.7709479928016662597656250000000000000000e-02), SC_(1.5248873387463390827178955078125000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.7724455647693264246145789970442948671148e-03) }},
{{ SC_(4.7744903713464736938476562500000000000000e-02), SC_(4.0251265625000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3347526569583289529540625545737073174007e-25466) }},
{{ SC_(4.8065219074487686157226562500000000000000e-02), SC_(4.5122022856958210468292236328125000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6493937522086133077019089780804562747610e-03) }},
{{ SC_(4.8307757824659347534179687500000000000000e-02), SC_(3.8996237500000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5309884068930981624246111121632455529637e-62411) }},
{{ SC_(4.8745974898338317871093750000000000000000e-02), SC_(2.3293564453125000000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.1769696110369289426164794534511081238409e-1706) }},
{{ SC_(4.9265518784523010253906250000000000000000e-02), SC_(2.9914777725934982299804687500000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.0273166854274506668406600417872717194133e-01) }},
{{ SC_(4.9306534230709075927734375000000000000000e-02), SC_(4.5977439880371093750000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5312250696598766530439046847631154671951e-04) }},
{{ SC_(4.9322098493576049804687500000000000000000e-02), SC_(3.2175212982110679149627685546875000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0570936582548984943856035540639484687035e-02) }},
{{ SC_(4.9362551420927047729492187500000000000000e-02), SC_(2.1735530026489868760108947753906250000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.6140155180135732363990093299156513905495e-05) }},
{{ SC_(4.9963217228651046752929687500000000000000e-02), SC_(3.6968516651540994644165039062500000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.2935400025052453249081479457316943376666e-02) }},
{{ SC_(1.0046042501926422119140625000000000000000e-01), SC_(2.0906679856125265359878540039062500000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4565382075013872601015530908790554715723e-03) }},
{{ SC_(1.0268612951040267944335937500000000000000e-01), SC_(1.9225277355872094631195068359375000000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2298885820585558771829986990493265475068e-04) }},
{{ SC_(1.1430509388446807861328125000000000000000e-01), SC_(4.2258042958565056324005126953125000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3889904239630886976686312198412543920694e-02) }},
{{ SC_(1.1778163909912109375000000000000000000000e-01), SC_(2.0635500000000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.2844291772680370317083639165000816020257e-89686) }},
{{ SC_(1.2543654441833496093750000000000000000000e-01), SC_(2.3307351684570312500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.4623621896439706648677441364672640997859e-351) }},
{{ SC_(1.3644538819789886474609375000000000000000e-01), SC_(1.3448689132928848266601562500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.8940623966739364883535508246073856536341e-02) }},
{{ SC_(1.3752801716327667236328125000000000000000e-01), SC_(4.3384867187500000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.1751802266293312276268399420955727057123e-2745) }},
{{ SC_(1.4231930673122406005859375000000000000000e-01), SC_(4.4478750610351562500000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9483824713894595616043199877802197084371e-456) }},
{{ SC_(1.4387898147106170654296875000000000000000e-01), SC_(2.8226550292968750000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.6968291427613186214328826127075082427870e-300) }},
{{ SC_(1.4768581092357635498046875000000000000000e-01), SC_(4.3794250488281250000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5196753565472780295124105089374851847822e-32) }},
{{ SC_(1.4775849878787994384765625000000000000000e-01), SC_(1.4443174004554748535156250000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.1735930614051908005096552195858669822067e-01) }},
{{ SC_(1.5554967522621154785156250000000000000000e-01), SC_(4.9261616210937500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.5826474847560445698643263250270941188505e-7422) }},
{{ SC_(1.5999889373779296875000000000000000000000e-01), SC_(3.4621112500000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6398546929238207971301655521446151910948e-21903) }},
{{ SC_(1.6108848154544830322265625000000000000000e-01), SC_(3.1610084697604179382324218750000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2023458974856330799976659406611850463731e-02) }},
{{ SC_(1.7034976184368133544921875000000000000000e-01), SC_(2.9454843606799840927124023437500000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.8373787997721315002093716987189530795007e-02) }},
{{ SC_(1.7546479403972625732421875000000000000000e-01), SC_(4.5397706329822540283203125000000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6069532815765540921170549608798949976708e-01) }},
{{ SC_(1.7669810354709625244140625000000000000000e-01), SC_(3.1714483629912137985229492187500000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1799768649804489351723601865614999954379e-02) }},
{{ SC_(1.7681133747100830078125000000000000000000e-01), SC_(4.0871437988281250000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.5376969656185591696761167956809443124998e-4342) }},
{{ SC_(1.8357396125793457031250000000000000000000e-01), SC_(3.3515080809593200683593750000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.6113025257165624746611343266526388371949e-01) }},
{{ SC_(1.8747064471244812011718750000000000000000e-01), SC_(4.0694799804687500000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4911763969604921545010534176652659584491e-318) }},
{{ SC_(1.8961600959300994873046875000000000000000e-01), SC_(4.6731060137972235679626464843750000000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7293914168458517335075611995890656090667e-04) }},
{{ SC_(1.9449223577976226806640625000000000000000e-01), SC_(2.3129458725452423095703125000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.1659678272486430995436672711515150203550e-01) }},
{{ SC_(1.9711413979530334472656250000000000000000e-01), SC_(1.4735862500000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.5585950812567551211581015868154946750779e-115320) }},
{{ SC_(1.9713982939720153808593750000000000000000e-01), SC_(2.3279089946299791336059570312500000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8423382776590486994017188331071072280044e-02) }},
{{ SC_(2.0191606879234313964843750000000000000000e-01), SC_(4.7408571845153346657752990722656250000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8172043371437136281501962162539687317853e-04) }},
{{ SC_(2.0257639884948730468750000000000000000000e-01), SC_(2.3722472190856933593750000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.5095263769061313346143379315166775838932e-03) }},
{{ SC_(2.0485810935497283935546875000000000000000e-01), SC_(4.8050575000000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.8326586835231902752880607620368667842729e-76901) }},
{{ SC_(2.0591160655021667480468750000000000000000e-01), SC_(2.4224435806274414062500000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1088002345714550682451797762507763787037e-04) }},
{{ SC_(2.0762462913990020751953125000000000000000e-01), SC_(4.4282894581556320190429687500000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1586047551795175356607326457243816389998e-01) }},
{{ SC_(2.1499927341938018798828125000000000000000e-01), SC_(3.3723477274179458618164062500000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0590735728594798758794087073591962405708e-01) }},
{{ SC_(2.2722963988780975341796875000000000000000e-01), SC_(3.9870731353759765625000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0454796342862888229325872670534431607777e-17) }},
{{ SC_(2.2898872196674346923828125000000000000000e-01), SC_(2.2186541173141449689865112304687500000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.5434026682891322572069940937786590474997e-03) }},
{{ SC_(2.3644983768463134765625000000000000000000e-01), SC_(3.8920969236642122268676757812500000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4741385190259078247214953054126052636673e-02) }},
{{ SC_(2.3778495192527770996093750000000000000000e-01), SC_(1.9049095499212853610515594482421875000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.3475568111643419670455113404315482901659e-05) }},
{{ SC_(2.3908504843711853027343750000000000000000e-01), SC_(3.9427212500000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.3134750421477624459652477332385611774019e-23270) }},
{{ SC_(2.4008722603321075439453125000000000000000e-01), SC_(1.2749543190002441406250000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.7445396013292730941259713395370216060663e-01) }},
{{ SC_(2.4369129538536071777343750000000000000000e-01), SC_(1.9345748437500000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2229314579982108574476096506416609420204e-291506) }},
{{ SC_(2.4632647633552551269531250000000000000000e-01), SC_(1.4834622802734375000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.6796394177081714018360799557046242459141e-161) }},
{{ SC_(2.5470846891403198242187500000000000000000e-01), SC_(4.9378104449715465307235717773437500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.6235007134424727283448076219068299564675e-03) }},
{{ SC_(2.5738254189491271972656250000000000000000e-01), SC_(4.4778414062500000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.1122134403147667485731779986571509131027e-35042) }},
{{ SC_(2.6183199882507324218750000000000000000000e-01), SC_(4.3530395507812500000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6110358512536599808293938756916482753603e-256) }},
{{ SC_(2.6646342873573303222656250000000000000000e-01), SC_(2.7337188720703125000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.3235817765642130483694661100270141464701e-02) }},
{{ SC_(2.6973962783813476562500000000000000000000e-01), SC_(1.0120048682438209652900695800781250000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.4539025687250638599171808050570310509791e-04) }},
{{ SC_(2.7029150724411010742187500000000000000000e-01), SC_(4.6000882983207702636718750000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.4056644489382650596862268994198657722298e-01) }},
{{ SC_(2.7696090936660766601562500000000000000000e-01), SC_(2.2522628125000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.3037152108950621766081905285268498572607e-231071) }},
{{ SC_(2.7934914827346801757812500000000000000000e-01), SC_(3.2172351074218750000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.1261750581789004209885049055095529892857e-203) }},
{{ SC_(2.8005510568618774414062500000000000000000e-01), SC_(4.8956602811813354492187500000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2397542261582689797972368187914025454669e+00) }},
{{ SC_(2.8349018096923828125000000000000000000000e-01), SC_(3.1329178810119628906250000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.3821157905908272472302444031072157665051e+00) }},
{{ SC_(2.8436654806137084960937500000000000000000e-01), SC_(2.7856958331540226936340332031250000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0506866873483656234824745215572976624125e-03) }},
{{ SC_(2.8497967123985290527343750000000000000000e-01), SC_(2.8760623536072671413421630859375000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0852214411249355894594764574098312212263e-03) }},
{{ SC_(2.8854286670684814453125000000000000000000e-01), SC_(1.9903402426280081272125244140625000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.4482071163159900893229634133260926955322e-03) }},
{{ SC_(2.8939440846443176269531250000000000000000e-01), SC_(1.8625170923769474029541015625000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.9451091767440822363425791188185586179777e-03) }},
{{ SC_(2.9178529977798461914062500000000000000000e-01), SC_(3.8487705230712890625000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4913940113188848314202412359135537031242e-40) }},
{{ SC_(2.9394131898880004882812500000000000000000e-01), SC_(4.3703574218750000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.7468969583453505953814594003217678964229e-32000) }},
{{ SC_(3.0802100896835327148437500000000000000000e-01), SC_(3.4557273437500000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.5461486054507120150629540155813778104181e-52070) }},
{{ SC_(3.0899813771247863769531250000000000000000e-01), SC_(4.3282717895507812500000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.4409719259382945132719169817357646856726e-188) }},
{{ SC_(3.1016176939010620117187500000000000000000e-01), SC_(2.4687779296875000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6673147912906939310758517031136194240482e-2678) }},
{{ SC_(3.1213769316673278808593750000000000000000e-01), SC_(1.2025038085937500000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.5176261672657191902899946359656599955626e-1924) }},
{{ SC_(3.1629574298858642578125000000000000000000e-01), SC_(2.0762573242187500000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0212916772498879413341448987552238387815e-01) }},
{{ SC_(3.1755438446998596191406250000000000000000e-01), SC_(2.4103579711914062500000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0541533580769658941756458499409883380819e-26) }},
{{ SC_(3.1788644194602966308593750000000000000000e-01), SC_(4.0395959472656250000000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6080131634147091258037397102652111254339e-23) }},
{{ SC_(3.1863725185394287109375000000000000000000e-01), SC_(4.9230270087718963623046875000000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.4000957007703752057322770192310076611015e-01) }},
{{ SC_(3.3048373460769653320312500000000000000000e-01), SC_(4.6995040029287338256835937500000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.4014035634536655436658266137987340573813e-01) }},
{{ SC_(3.3289965987205505371093750000000000000000e-01), SC_(4.9709701538085937500000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.2099038677863419822795797992916862343357e-03) }},
{{ SC_(3.3443683385848999023437500000000000000000e-01), SC_(3.6505203125000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.2607784732120216003510374999848437780676e-39616) }},
{{ SC_(3.4086817502975463867187500000000000000000e-01), SC_(3.8475231121992692351341247558593750000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.7145226756397401025996743572564187724630e-04) }},
{{ SC_(3.4292155504226684570312500000000000000000e-01), SC_(1.4970906078815460205078125000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.4255814011790662485491995413164533433679e-01) }},
{{ SC_(3.4295567870140075683593750000000000000000e-01), SC_(2.1347757428884506225585937500000000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3067823681966654467495665900649985617663e-02) }},
{{ SC_(3.4538429975509643554687500000000000000000e-01), SC_(2.2489204406738281250000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.5252688180171457991190493002646798467959e-03) }},
{{ SC_(3.5115855932235717773437500000000000000000e-01), SC_(2.9649570312500000000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.6165722518888360124983894859033549667426e-1288) }},
{{ SC_(3.5431468486785888671875000000000000000000e-01), SC_(4.1111761331558227539062500000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.8241410061512965100951319791344401350276e-01) }},
{{ SC_(3.5572677850723266601562500000000000000000e-01), SC_(4.9306716918945312500000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.6383320202231268161264074052656206559765e-73) }},
{{ SC_(3.5777711868286132812500000000000000000000e-01), SC_(4.7988586127758026123046875000000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2005199997329792846255441128163287307269e+00) }},
{{ SC_(3.5822075605392456054687500000000000000000e-01), SC_(4.8598091125488281250000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.5223375398616930420889261218192519804049e-49) }},
{{ SC_(3.5892459750175476074218750000000000000000e-01), SC_(1.7730415344238281250000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.5232005479519323598121089122035325298938e-11) }},
{{ SC_(3.5904705524444580078125000000000000000000e-01), SC_(4.7380876541137695312500000000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.8191192395589901380323339384275724735893e-01) }},
{{ SC_(3.6477789282798767089843750000000000000000e-01), SC_(3.6492011547088623046875000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5402555530481902924294786851881393961106e+00) }},
{{ SC_(3.6480385065078735351562500000000000000000e-01), SC_(1.8238222599029541015625000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.8081132692174804582464288749144722276633e-01) }},
{{ SC_(3.6713308095932006835937500000000000000000e-01), SC_(2.2153009922476485371589660644531250000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.3910641515374568065435660277318859500269e-05) }},
{{ SC_(3.6857244372367858886718750000000000000000e-01), SC_(1.3019937500000000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.0535867944288109485568197409909987737394e-13356) }},
{{ SC_(3.7013283371925354003906250000000000000000e-01), SC_(3.0404355129576288163661956787109375000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0643516894875995328878048135234374289911e-04) }},
{{ SC_(3.7160670757293701171875000000000000000000e-01), SC_(1.0332970321178436279296875000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3908809598236901987837115334852406272037e-01) }},
{{ SC_(3.7334531545639038085937500000000000000000e-01), SC_(4.6548787504434585571289062500000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6405811244359678073306342991782999742020e-01) }},
{{ SC_(3.7511843442916870117187500000000000000000e-01), SC_(4.4884615625000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.1890236012059698586471286181976379614638e-476854) }},
{{ SC_(3.7850654125213623046875000000000000000000e-01), SC_(4.3846468750000000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.1700634157381043916368443232799527963928e-2586) }},
{{ SC_(3.8371267914772033691406250000000000000000e-01), SC_(3.5991230607032775878906250000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.1946483509311159808402382211023022387454e-01) }},
{{ SC_(3.8841864466667175292968750000000000000000e-01), SC_(1.7852012634277343750000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.6127559307401954625649067446206285660181e-28) }},
{{ SC_(3.8870319724082946777343750000000000000000e-01), SC_(2.6300076860934495925903320312500000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0261770808806877660732720376393861166174e-02) }},
{{ SC_(3.9537075161933898925781250000000000000000e-01), SC_(4.0236986242234706878662109375000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.4557952488129788586753459231834541857125e-02) }},
{{ SC_(3.9650318026542663574218750000000000000000e-01), SC_(1.1295042968750000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.7556726404591589517513825833916053164984e-11998) }},
{{ SC_(4.0197330713272094726562500000000000000000e-01), SC_(4.6775428125000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0882185128372429800839093569740443380433e-342498) }},
{{ SC_(4.0540185570716857910156250000000000000000e-01), SC_(1.8487348632812500000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.7388718640646352788642541536794078610349e-295) }},
{{ SC_(4.0620002150535583496093750000000000000000e-01), SC_(1.0595668107271194458007812500000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.9288276453157794040476901933696167467800e-02) }},
{{ SC_(4.0806388854980468750000000000000000000000e-01), SC_(4.8837764188647270202636718750000000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.9708703331134820178298276544039222778393e-03) }},
{{ SC_(4.0811419486999511718750000000000000000000e-01), SC_(3.8330304622650146484375000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.2851044335652542500086187846667423117114e-01) }},
{{ SC_(4.0879216790199279785156250000000000000000e-01), SC_(2.6386191406250000000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.1393942043828344746739248297359276462866e-1931) }},
{{ SC_(4.1220790147781372070312500000000000000000e-01), SC_(2.7958074497291818261146545410156250000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7021149058176368076984518306891413778264e-04) }},
{{ SC_(4.1389569640159606933593750000000000000000e-01), SC_(1.8604361684992909431457519531250000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.0912697759361200096794174073428251751010e-03) }},
{{ SC_(4.3316668272018432617187500000000000000000e-01), SC_(1.2770501375198364257812500000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.7155345154471215270808106517247883456309e-01) }},
{{ SC_(4.3677169084548950195312500000000000000000e-01), SC_(1.0447703599929809570312500000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.5687068587213371755475659074648871704595e-01) }},
{{ SC_(4.3775686621665954589843750000000000000000e-01), SC_(4.1604071157053112983703613281250000000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1654985443167373583884610268697334160958e-04) }},
{{ SC_(4.4445592164993286132812500000000000000000e-01), SC_(4.9022464843750000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5683888441437877556482661153394843725052e-21304) }},
{{ SC_(4.4797641038894653320312500000000000000000e-01), SC_(4.4282646179199218750000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2728562391551353070926429795649140929801e-04) }},
{{ SC_(4.6639651060104370117187500000000000000000e-01), SC_(3.6208529490977525711059570312500000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2463638255530056021751365869145785308763e-03) }},
{{ SC_(4.6696972846984863281250000000000000000000e-01), SC_(4.2070522904396057128906250000000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3457323261529084149099455227794688761074e-01) }},
{{ SC_(4.7314143180847167968750000000000000000000e-01), SC_(4.0380458984375000000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4306278610749992176590092836060310854201e-3158) }},
{{ SC_(4.7593179345130920410156250000000000000000e-01), SC_(1.8685544967651367187500000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4131709614619977694376526579489376100698e-14) }},
{{ SC_(4.7806963324546813964843750000000000000000e-01), SC_(1.1038354784250259399414062500000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4465997341553751318988623762810028253650e-01) }},
{{ SC_(4.8909634351730346679687500000000000000000e-01), SC_(2.4282570800781250000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4530493380721568544904464930545211183282e-2489) }},
{{ SC_(4.9748182296752929687500000000000000000000e-01), SC_(4.8103790283203125000000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.2970139403511089305751172271071967218422e-351) }},
{{ SC_(1.0020895004272460937500000000000000000000e+00), SC_(1.1342892646789550781250000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.1837815316942722571202823250276515315642e-01) }},
{{ SC_(1.0679317712783813476562500000000000000000e+00), SC_(2.5935651855468750000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.3707345582405875767472899146267976357337e-1124) }},
{{ SC_(1.0783104896545410156250000000000000000000e+00), SC_(1.6118628991534933447837829589843750000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.5619485733955568430014305819353179344884e-05) }},
{{ SC_(1.1279640197753906250000000000000000000000e+00), SC_(2.8082556640625000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5735723265707156836453904942848401657965e-3043) }},
{{ SC_(1.1706095933914184570312500000000000000000e+00), SC_(3.7448643750000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.6800054210597822025114229462546405539356e-40635) }},
{{ SC_(1.1981303691864013671875000000000000000000e+00), SC_(1.8840236328125000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.0688913519008779017094956797722408702163e-13790) }},
{{ SC_(1.2198965549468994140625000000000000000000e+00), SC_(1.3859471678733825683593750000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.8447350727134147912467500268104858477688e+00) }},
{{ SC_(1.3339312076568603515625000000000000000000e+00), SC_(3.2751660156250000000000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6766583676483653877547674486665075894225e-139) }},
{{ SC_(1.3598027229309082031250000000000000000000e+00), SC_(3.9465808868408203125000000000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.4456765242304000754741368121658582024875e-01) }},
{{ SC_(1.4468230009078979492187500000000000000000e+00), SC_(1.7606438696384429931640625000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2059435809226502086139444342152123859716e-01) }},
{{ SC_(1.4834382534027099609375000000000000000000e+00), SC_(1.1596116943359375000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5587282684050219253756729705656930022950e-844) }},
{{ SC_(1.4923349618911743164062500000000000000000e+00), SC_(4.7973695312500000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.1469289808231367573381463286047486594464e-50960) }},
{{ SC_(1.5451701879501342773437500000000000000000e+00), SC_(2.0473089814186096191406250000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6298390609319887538175522002714294573989e-01) }},
{{ SC_(1.5860595703125000000000000000000000000000e+00), SC_(2.6834143750000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.4608114963011865123228306369584390935473e-15831) }},
{{ SC_(1.5904328823089599609375000000000000000000e+00), SC_(1.7513233423233032226562500000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3954831262910867779543076281226038701873e+00) }},
{{ SC_(1.6190093755722045898437500000000000000000e+00), SC_(3.5571128129959106445312500000000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.5116623740340764659282130202178181525055e-02) }},
{{ SC_(1.6690142154693603515625000000000000000000e+00), SC_(4.5049847103655338287353515625000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.4439198415730430248797207396473454874913e-02) }},
{{ SC_(1.7562887668609619140625000000000000000000e+00), SC_(3.7429353125000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.0018417978574030475469012779612804921776e-23672) }},
{{ SC_(1.7588416337966918945312500000000000000000e+00), SC_(3.6945486068725585937500000000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3002128966626827817424428656493213786532e+00) }},
{{ SC_(1.7700415849685668945312500000000000000000e+00), SC_(4.9033269531250000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.4241599929691788127478102157812311220157e-50297) }},
{{ SC_(1.7882151603698730468750000000000000000000e+00), SC_(1.2965712812729179859161376953125000000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.0624625842940743163149928683322242969387e-04) }},
{{ SC_(1.7994513511657714843750000000000000000000e+00), SC_(4.9823746085166931152343750000000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.3213128702986765390982468746683488684984e-02) }},
{{ SC_(1.8219766616821289062500000000000000000000e+00), SC_(3.9458898437500000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.3598075511032067053120419615886859032227e-59449) }},
{{ SC_(1.8376202583312988281250000000000000000000e+00), SC_(3.4357558593750000000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.1006985238871204535038522822222345906382e-5170) }},
{{ SC_(1.8640756607055664062500000000000000000000e+00), SC_(1.4214451948646456003189086914062500000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.4415835548382390026551266523232885749133e-03) }},
{{ SC_(1.9113717079162597656250000000000000000000e+00), SC_(1.6852600097656250000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.9302554412649878155689874764117966990499e-10) }},
{{ SC_(1.9869381189346313476562500000000000000000e+00), SC_(2.9879779052734375000000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.0551993057528729360722212665887293941791e-29) }},
{{ SC_(2.0810818672180175781250000000000000000000e+00), SC_(1.7145990568678826093673706054687500000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.7948159450943820073863252077059031028028e-04) }},
{{ SC_(2.1274673938751220703125000000000000000000e+00), SC_(4.9790993750000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.9828503777065891174187069853317077292796e-216390) }},
{{ SC_(2.2740969657897949218750000000000000000000e+00), SC_(3.1214687973260879516601562500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.9577430019815928100343893455303398182929e-01) }},
{{ SC_(2.3102617263793945312500000000000000000000e+00), SC_(2.3316312581300735473632812500000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.1533515513015031571464636527305166046964e-04) }},
{{ SC_(2.3234314918518066406250000000000000000000e+00), SC_(4.8929148761089891195297241210937500000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3362073139375700284446176650730437943365e-04) }},
{{ SC_(2.4496459960937500000000000000000000000000e+00), SC_(1.2697874023437500000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.2008941021938395119626672326893147933640e-5509) }},
{{ SC_(2.5095820426940917968750000000000000000000e+00), SC_(3.3403583802282810211181640625000000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.3622684306560515102050100341638155180382e-03) }},
{{ SC_(2.5647320747375488281250000000000000000000e+00), SC_(4.5321264769881963729858398437500000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0393687201219931614970723933832163786253e-04) }},
{{ SC_(2.5788297653198242187500000000000000000000e+00), SC_(3.2261272281175479292869567871093750000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5913503198460471739410710191250609742283e-06) }},
{{ SC_(2.5871660709381103515625000000000000000000e+00), SC_(4.6129638212732970714569091796875000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7984772074438255334137281570565104398093e-03) }},
{{ SC_(2.6278192996978759765625000000000000000000e+00), SC_(3.5575762391090393066406250000000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3579665884456847695507087056561346337470e-01) }},
{{ SC_(2.6972379684448242187500000000000000000000e+00), SC_(3.5350676625967025756835937500000000000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.1725801677743676508989534173628671979315e-04) }},
{{ SC_(2.7196855545043945312500000000000000000000e+00), SC_(4.1439200867898762226104736328125000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5433310994241432888356409051102894403901e-05) }},
{{ SC_(2.7545800209045410156250000000000000000000e+00), SC_(4.8456829972565174102783203125000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.9105031303500797961099479635623417260972e-03) }},
{{ SC_(2.7692217826843261718750000000000000000000e+00), SC_(3.6656674637924879789352416992187500000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4328697530983208711632273383340520403842e-05) }},
{{ SC_(2.7807326316833496093750000000000000000000e+00), SC_(4.9595328125000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8475523668207938561581056635563655204613e-747302) }},
{{ SC_(2.9180936813354492187500000000000000000000e+00), SC_(2.1431373596191406250000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.6289270838688533003986306376912502512917e-01) }},
{{ SC_(2.9371860027313232421875000000000000000000e+00), SC_(2.6528596191406250000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0175587832749542530815178275752068185625e-2711) }},
{{ SC_(2.9582800865173339843750000000000000000000e+00), SC_(3.5774589843750000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.8349115391771784778089606618486312420818e-27983) }},
{{ SC_(2.9800233840942382812500000000000000000000e+00), SC_(1.7078122496604919433593750000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.2635691573329513146575652435081167568995e+00) }},
{{ SC_(2.9807081222534179687500000000000000000000e+00), SC_(2.8401073813438415527343750000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.2618628420818462963344871443926851159365e-01) }},
{{ SC_(2.9923772811889648437500000000000000000000e+00), SC_(1.3765993118286132812500000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1275537084773164512642383075617301941720e-07) }},
{{ SC_(2.9964640140533447265625000000000000000000e+00), SC_(2.3522021875000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9705110099469436110145063285977063582727e-241309) }},
{{ SC_(3.0576937198638916015625000000000000000000e+00), SC_(3.2484099268913269042968750000000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.5769475680163308569252891320193861154502e-04) }},
{{ SC_(3.1107203960418701171875000000000000000000e+00), SC_(1.0699528694152832031250000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.4928638749259361095760125109332568046044e+00) }},
{{ SC_(3.1362564563751220703125000000000000000000e+00), SC_(4.1280061006546020507812500000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.4784396305311906228379437740001828164096e-03) }},
{{ SC_(3.1432042121887207031250000000000000000000e+00), SC_(2.4516629687500000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.5038608960381195839663995718630260523491e-260449) }},
{{ SC_(3.1543867588043212890625000000000000000000e+00), SC_(2.7423721875000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.4504258628239322416399838382654393170146e-200786) }},
{{ SC_(3.2091653347015380859375000000000000000000e+00), SC_(1.2216256835937500000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.9072401790111718636333878380404050783415e-711) }},
{{ SC_(3.2422380447387695312500000000000000000000e+00), SC_(1.6813060045242309570312500000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.5871275143088785995826489806896258769964e-02) }},
{{ SC_(3.2986447811126708984375000000000000000000e+00), SC_(1.8054557800292968750000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.9307887514856895904796906510695716193277e-15) }},
{{ SC_(3.3203613758087158203125000000000000000000e+00), SC_(4.7071479492187500000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4503806775737059793955279110715000263299e-743) }},
{{ SC_(3.3257858753204345703125000000000000000000e+00), SC_(3.2248618164062500000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7644153480628797139430469509737300768125e-195) }},
{{ SC_(3.3311638832092285156250000000000000000000e+00), SC_(1.9793136119842529296875000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8164999832325789666902705377068447270265e+00) }},
{{ SC_(3.3439481258392333984375000000000000000000e+00), SC_(3.3443368530273437500000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.3811375647260960753765779383502303261997e-16) }},
{{ SC_(3.3521041870117187500000000000000000000000e+00), SC_(1.5932355076074600219726562500000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.0082112848695947637676413028331306747545e-04) }},
{{ SC_(3.4502658843994140625000000000000000000000e+00), SC_(4.1324951171875000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.5192741279733995123794229031242334919010e+00) }},
{{ SC_(3.4588537216186523437500000000000000000000e+00), SC_(2.9400574218750000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.3487803729752950810063230882624472963581e-4692) }},
{{ SC_(3.5038392543792724609375000000000000000000e+00), SC_(1.7403919982910156250000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.5832825085037679135045223835654419642862e-120) }},
{{ SC_(3.5195336341857910156250000000000000000000e+00), SC_(4.3931828125000000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8040440846905438507135981545693327570683e-2766) }},
{{ SC_(3.5407917499542236328125000000000000000000e+00), SC_(1.9250650000000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.4510460228933144124179944662176169279647e-30793) }},
{{ SC_(3.6437783241271972656250000000000000000000e+00), SC_(4.6066265869140625000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.5368516615402781818993406784472454113715e-351) }},
{{ SC_(3.6656649112701416015625000000000000000000e+00), SC_(3.3638931274414062500000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.2370641463942180063985026279046321826706e-47) }},
{{ SC_(3.6850574016571044921875000000000000000000e+00), SC_(3.7575312890112400054931640625000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.3163364263083460097211102670592583919787e-04) }},
{{ SC_(3.7146091461181640625000000000000000000000e+00), SC_(2.8089791536331176757812500000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.5966384827536888878033849540284353348821e-01) }},
{{ SC_(3.7336635589599609375000000000000000000000e+00), SC_(4.7743691538926213979721069335937500000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.9051822517377290185064511139040478020543e-07) }},
{{ SC_(3.7806520462036132812500000000000000000000e+00), SC_(3.9751706250000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2582816349721949967635738952090820756578e-311069) }},
{{ SC_(3.7866687774658203125000000000000000000000e+00), SC_(4.3225717544555664062500000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6494985294807271977974537862576877060504e+00) }},
{{ SC_(3.8161897659301757812500000000000000000000e+00), SC_(3.0148139558150433003902435302734375000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5846033115092269023014146472742870261916e-06) }},
{{ SC_(3.9190075397491455078125000000000000000000e+00), SC_(1.0978485107421875000000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.5571358930729425244875125442508359275978e-105) }},
{{ SC_(3.9453601837158203125000000000000000000000e+00), SC_(4.2322339140810072422027587890625000000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.1136499919115228115908487830145199413570e-07) }},
{{ SC_(3.9545612335205078125000000000000000000000e+00), SC_(4.2035180664062500000000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6959021418686352802350951773095375388045e-18) }},
{{ SC_(3.9948229789733886718750000000000000000000e+00), SC_(2.7580732479691505432128906250000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.7460496165971111654163524762767095082128e-02) }},
{{ SC_(4.0203084945678710937500000000000000000000e+00), SC_(3.7742473068647086620330810546875000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.9711610459972123582120342456290547729836e-03) }},
{{ SC_(4.0754170417785644531250000000000000000000e+00), SC_(4.6969656832516193389892578125000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6356616221762736609023113926439654524338e-02) }},
{{ SC_(4.0761165618896484375000000000000000000000e+00), SC_(3.3988085937500000000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.8674133498143487678767181671227952718445e-190) }},
{{ SC_(4.0764575004577636718750000000000000000000e+00), SC_(3.5894755274057388305664062500000000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3852586260498222317365299596043534090088e-04) }},
{{ SC_(4.1598520278930664062500000000000000000000e+00), SC_(1.3326035812497138977050781250000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1466570841185206991145131495238786328518e-01) }},
{{ SC_(4.1616287231445312500000000000000000000000e+00), SC_(4.9612796865403652191162109375000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.4279957267116181213281977304546824258853e-06) }},
{{ SC_(4.2053904533386230468750000000000000000000e+00), SC_(4.8055870056152343750000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4116699956365700061336803631018215473006e-15) }},
{{ SC_(4.2340564727783203125000000000000000000000e+00), SC_(1.0238944378215819597244262695312500000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4642825049822637103646018759896999393119e-04) }},
{{ SC_(4.2615890502929687500000000000000000000000e+00), SC_(1.5681400299072265625000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.3628134996424903051373555165612408660066e+00) }},
{{ SC_(4.2868847846984863281250000000000000000000e+00), SC_(2.9798992909491062164306640625000000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.8778675836720973873499420687382944389991e-07) }},
{{ SC_(4.3023352622985839843750000000000000000000e+00), SC_(1.1135534383356571197509765625000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.4835515008911873938081707986960242037211e-02) }},
{{ SC_(4.3340024948120117187500000000000000000000e+00), SC_(1.9063963554799556732177734375000000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.1996460469792270219898346906973924146819e-03) }},
{{ SC_(4.3794226646423339843750000000000000000000e+00), SC_(1.5181336669921875000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.9610324033668402237671875960506080098641e-1600) }},
{{ SC_(4.3807125091552734375000000000000000000000e+00), SC_(4.0124656677246093750000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2780162157509400680832783914472242254480e-53) }},
{{ SC_(4.4028506278991699218750000000000000000000e+00), SC_(2.2954983711242675781250000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.6091156936303065317382561189103974921828e-02) }},
{{ SC_(4.4479217529296875000000000000000000000000e+00), SC_(2.7269781567156314849853515625000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3005753574155338924069144906198969485078e-02) }},
{{ SC_(4.4508428573608398437500000000000000000000e+00), SC_(3.3404672851562500000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.3631003813888593357919273885370363324533e-2600) }},
{{ SC_(4.4617543220520019531250000000000000000000e+00), SC_(2.6371574401855468750000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.6349443239389192496039911609720988881131e-01) }},
{{ SC_(4.5160555839538574218750000000000000000000e+00), SC_(1.6217678785324096679687500000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4684658988864987771809525819947061725873e+00) }},
{{ SC_(4.5371241569519042968750000000000000000000e+00), SC_(4.3504618108272552490234375000000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.6354298721092834190073729552627943936731e-05) }},
{{ SC_(4.5510835647583007812500000000000000000000e+00), SC_(2.8587187989614903926849365234375000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7281213732847501265033504366980009794824e-06) }},
{{ SC_(4.5630083084106445312500000000000000000000e+00), SC_(2.0575057983398437500000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.3223186003302653612816137275225297858906e-209) }},
{{ SC_(4.6034097671508789062500000000000000000000e+00), SC_(2.0956468582153320312500000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.0643485887877059297393226568577021459452e-16) }},
{{ SC_(4.7132520675659179687500000000000000000000e+00), SC_(1.3861311035156250000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.2318274653678730168626033881967662669711e-140) }},
{{ SC_(4.7184352874755859375000000000000000000000e+00), SC_(1.0989363193511962890625000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.0843315179242293106237999076871041832575e-02) }},
{{ SC_(4.7972154617309570312500000000000000000000e+00), SC_(1.9199681701138615608215332031250000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1290049499891117944497847203262973424185e-06) }},
{{ SC_(4.9292125701904296875000000000000000000000e+00), SC_(4.1300610351562500000000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.9225450572748365284120644691160324195427e-610) }},
{{ SC_(4.9556465148925781250000000000000000000000e+00), SC_(2.2120428085327148437500000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5308171958757409117596725143158382036501e+00) }},
{{ SC_(4.9594888687133789062500000000000000000000e+00), SC_(2.8835497796535491943359375000000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.1401177414789815510692891352930921717511e-02) }},
{{ SC_(4.9598007202148437500000000000000000000000e+00), SC_(2.7734874725341796875000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.6263932003266311444286576556205807217937e+00) }},
{{ SC_(1.0531328201293945312500000000000000000000e+01), SC_(4.9491328125000000000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.9136975293292027025923658580122080729660e-3592) }},
{{ SC_(1.1009126663208007812500000000000000000000e+01), SC_(1.8062679097056388854980468750000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.4927492086994666459031665395365088316819e-02) }},
{{ SC_(1.1235581398010253906250000000000000000000e+01), SC_(1.2059705331921577453613281250000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8889648647415719141700207159359303501076e-11) }},
{{ SC_(1.1854049682617187500000000000000000000000e+01), SC_(2.8582398437500000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.7001489752618469110632730248301425753650e-29279) }},
{{ SC_(1.2083115577697753906250000000000000000000e+01), SC_(1.4528108295053243637084960937500000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.1522597636469058765064367098146412790237e-04) }},
{{ SC_(1.2150175094604492187500000000000000000000e+01), SC_(2.5690979003906250000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.4833842832112063251202928954049164404805e-384) }},
{{ SC_(1.2169579505920410156250000000000000000000e+01), SC_(2.4783191084861755371093750000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.4014413631094830098922139190279853929996e-03) }},
{{ SC_(1.2268188476562500000000000000000000000000e+01), SC_(3.1347698211669921875000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.4297740009800401696890958443682383495367e+00) }},
{{ SC_(1.2481808662414550781250000000000000000000e+01), SC_(3.5551128906250000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0596320582632998105136356567178378851195e-25983) }},
{{ SC_(1.2536180496215820312500000000000000000000e+01), SC_(1.1118580587208271026611328125000000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2559336525400707501557967024617578972248e-13) }},
{{ SC_(1.2858113288879394531250000000000000000000e+01), SC_(1.7659459228515625000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9493605141911006643744615471404314656882e-89) }},
{{ SC_(1.3234496116638183593750000000000000000000e+01), SC_(3.8525012500000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.6286973691422089443226117400698279458454e-41753) }},
{{ SC_(1.3282847404479980468750000000000000000000e+01), SC_(4.8034972860477864742279052734375000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2181104167806795746117780404453554554866e-14) }},
{{ SC_(1.3595666885375976562500000000000000000000e+01), SC_(1.5333459375000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9611459439841896265108407866591347839945e-9651) }},
{{ SC_(1.3734819412231445312500000000000000000000e+01), SC_(3.4842180175781250000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1975829568968245214411973433902802404112e-3662) }},
{{ SC_(1.4008861541748046875000000000000000000000e+01), SC_(2.6867980957031250000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7471092809635467497101610267231133953750e+00) }},
{{ SC_(1.4066776275634765625000000000000000000000e+01), SC_(1.0778093750000000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.8470673496796054664196462479794307731086e-647) }},
{{ SC_(1.4160462379455566406250000000000000000000e+01), SC_(2.0103611755371093750000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.7432519340024539818825008977335910473660e-02) }},
{{ SC_(1.4228377342224121093750000000000000000000e+01), SC_(1.2559258902911096811294555664062500000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.4509039066265603396337414149481412753889e-13) }},
{{ SC_(1.4366168975830078125000000000000000000000e+01), SC_(2.3678760937500000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0031598448352695804814074852395823765354e-185239) }},
{{ SC_(1.4726207733154296875000000000000000000000e+01), SC_(2.1476264297962188720703125000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.1104956476927225285727527680494655377734e+00) }},
{{ SC_(1.4957290649414062500000000000000000000000e+01), SC_(3.9003130950732156634330749511718750000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.3971390615061801147813837719306429477210e-17) }},
{{ SC_(1.5357250213623046875000000000000000000000e+01), SC_(1.8632130697369575500488281250000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0995558556977727250556540231319762691328e-15) }},
{{ SC_(1.5364917755126953125000000000000000000000e+01), SC_(2.2678494262695312500000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.9295738898319896256070176122657579544324e-216) }},
{{ SC_(1.5681644439697265625000000000000000000000e+01), SC_(3.6581026506610214710235595703125000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6585743497227779147380907857725784791553e-11) }},
{{ SC_(1.6658418655395507812500000000000000000000e+01), SC_(1.7052462499123066663742065429687500000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5512914214474711908635886019121878938570e-07) }},
{{ SC_(1.7026760101318359375000000000000000000000e+01), SC_(1.1721271514892578125000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5186612396265692826484033384158926882679e-01) }},
{{ SC_(1.7084300994873046875000000000000000000000e+01), SC_(4.1874298453330993652343750000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5198208920293070012700997140669013191648e-01) }},
{{ SC_(1.7104099273681640625000000000000000000000e+01), SC_(3.9452277123928070068359375000000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0627844774821787483372203641143311042218e-02) }},
{{ SC_(1.7124677658081054687500000000000000000000e+01), SC_(4.4758499145507812500000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.2813571577818425121791239370638287658970e-02) }},
{{ SC_(1.7367763519287109375000000000000000000000e+01), SC_(2.1181776428222656250000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2259295405010065441984547723886282835428e-129) }},
{{ SC_(1.7866327285766601562500000000000000000000e+01), SC_(3.5518112792968750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3348113880244574368273432299360846338758e-3595) }},
{{ SC_(1.8239021301269531250000000000000000000000e+01), SC_(3.8734659028705209493637084960937500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.2139011729186614185772264640278178649402e-04) }},
{{ SC_(1.8338453292846679687500000000000000000000e+01), SC_(4.7895769966999068856239318847656250000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.4094455083541289776438559840488604022240e-06) }},
{{ SC_(1.8357866287231445312500000000000000000000e+01), SC_(4.4260616302490234375000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4723902485007057198253669600963556492386e-19) }},
{{ SC_(1.8504062652587890625000000000000000000000e+01), SC_(4.1069604492187500000000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.8181615774249560428705715554099404466914e-585) }},
{{ SC_(1.9699462890625000000000000000000000000000e+01), SC_(1.0440983886718750000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.4419232211803750740990250116488285263157e-83) }},
{{ SC_(2.0811771392822265625000000000000000000000e+01), SC_(1.6864116332726553082466125488281250000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.2341331638916481998632253801488387286208e-09) }},
{{ SC_(2.1513973236083984375000000000000000000000e+01), SC_(1.2695052623748779296875000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.4688072011583551741284478785499829501467e-03) }},
{{ SC_(2.1758922576904296875000000000000000000000e+01), SC_(2.0817528125000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4022716984358396402071490336964406374284e-313588) }},
{{ SC_(2.1821353912353515625000000000000000000000e+01), SC_(4.2416419833898544311523437500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.2561456255953035993323529626821337102085e-06) }},
{{ SC_(2.1893873214721679687500000000000000000000e+01), SC_(1.2260446289062500000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.9611588673578334286554255733324743532592e-5263) }},
{{ SC_(2.1929759979248046875000000000000000000000e+01), SC_(2.1858861328125000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2281801279572626852221726285258416024457e-17032) }},
{{ SC_(2.1997480392456054687500000000000000000000e+01), SC_(2.4120399475097656250000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8168834235388721681131554197033371180646e-215) }},
{{ SC_(2.2052242279052734375000000000000000000000e+01), SC_(2.6856275275349617004394531250000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.3611177251092750741117088688230514688805e-13) }},
{{ SC_(2.2294675827026367187500000000000000000000e+01), SC_(4.7003793945312500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.0702065597956544779811248219623312970367e-7020) }},
{{ SC_(2.3233161926269531250000000000000000000000e+01), SC_(1.3708417117595672607421875000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9108680299281870234071110036296477336858e-01) }},
{{ SC_(2.3283712387084960937500000000000000000000e+01), SC_(3.3643074218750000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.6964017297844638361039914872256217235384e-5312) }},
{{ SC_(2.3317451477050781250000000000000000000000e+01), SC_(2.2672764956951141357421875000000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3232070897428981431273597269511073806627e-03) }},
{{ SC_(2.3433959960937500000000000000000000000000e+01), SC_(2.3290653228759765625000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1096363746352797011621956647831651075454e+00) }},
{{ SC_(2.3523906707763671875000000000000000000000e+01), SC_(3.6384415625000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.0538052496094294676159451878206481973866e-386441) }},
{{ SC_(2.3915166854858398437500000000000000000000e+01), SC_(1.3243019580841064453125000000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5506680045751678364155518677085090222734e-16) }},
{{ SC_(2.4385395050048828125000000000000000000000e+01), SC_(4.9881660461425781250000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7189126927509049877635628389959107675260e-03) }},
{{ SC_(2.5943580627441406250000000000000000000000e+01), SC_(3.6261931527405977249145507812500000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.2996094665683382866229641185400099590684e-02) }},
{{ SC_(2.6580902099609375000000000000000000000000e+01), SC_(2.5000987052917480468750000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2393772302042159231348182975725813793978e+00) }},
{{ SC_(2.6681158065795898437500000000000000000000e+01), SC_(2.5989200366893783211708068847656250000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.9292258084038315367328698237867212469867e-05) }},
{{ SC_(2.7668880462646484375000000000000000000000e+01), SC_(4.6266933593750000000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4515421781394360219563022891530271369212e-1942) }},
{{ SC_(2.7841068267822265625000000000000000000000e+01), SC_(2.3176459968090057373046875000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3909548303480618491876138703809133125726e-14) }},
{{ SC_(2.8242305755615234375000000000000000000000e+01), SC_(4.5229917968750000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.4458392545908312656868651015063716192246e-2591) }},
{{ SC_(2.8593597412109375000000000000000000000000e+01), SC_(4.3943142890930175781250000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.8789473026054358318671880639235313286245e+00) }},
{{ SC_(2.8682727813720703125000000000000000000000e+01), SC_(4.5363664627075195312500000000000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0543023589844137475214268873383522805971e-03) }},
{{ SC_(2.8738727569580078125000000000000000000000e+01), SC_(2.7254573822021484375000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1932916480869268343172544511086083467240e-23) }},
{{ SC_(2.9614292144775390625000000000000000000000e+01), SC_(4.3500265746843069791793823242187500000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.3910647901227763280404527240286484664740e-30) }},
{{ SC_(3.0217124938964843750000000000000000000000e+01), SC_(4.7917328125000000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.1847053191883175629464808288838350491330e-50798) }},
{{ SC_(3.0535097122192382812500000000000000000000e+01), SC_(3.9173173718154430389404296875000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2524474305261954214855835151017778224457e-03) }},
{{ SC_(3.0875427246093750000000000000000000000000e+01), SC_(2.5782653808593750000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.8156973696435742732011902083418034562732e-03) }},
{{ SC_(3.1350877761840820312500000000000000000000e+01), SC_(3.5451693750000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.7203616266348366821838620146786390904619e-259447) }},
{{ SC_(3.1599283218383789062500000000000000000000e+01), SC_(2.9741673469543457031250000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3742512400169905992773829153279249830177e-23) }},
{{ SC_(3.2361301422119140625000000000000000000000e+01), SC_(1.2657617032527923583984375000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.8736589268680549385264888941766307242818e-29) }},
{{ SC_(3.2474456787109375000000000000000000000000e+01), SC_(4.8085726928710937500000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.2647028872365150333315961291692798979905e-162) }},
{{ SC_(3.2599182128906250000000000000000000000000e+01), SC_(2.4035865862970240414142608642578125000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.8891569945797838532957392720045657374110e-07) }},
{{ SC_(3.2948390960693359375000000000000000000000e+01), SC_(1.6735996177885681390762329101562500000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.1975917937728381320079432464342737091300e-06) }},
{{ SC_(3.3888454437255859375000000000000000000000e+01), SC_(3.3126358032226562500000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0408944167077079063307219117146109909689e-212) }},
{{ SC_(3.4838344573974609375000000000000000000000e+01), SC_(2.4838323588483035564422607421875000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3082146919504444593633622073034337996865e-06) }},
{{ SC_(3.5242801666259765625000000000000000000000e+01), SC_(3.0136412500000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1434796404593182792873912465730829182244e-17664) }},
{{ SC_(3.5612472534179687500000000000000000000000e+01), SC_(2.5395145712536759674549102783203125000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.7807244079971666579287500990725091563133e-06) }},
{{ SC_(3.5927936553955078125000000000000000000000e+01), SC_(2.6364326477050781250000000000000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.2552806157969004869391558143505638467608e-03) }},
{{ SC_(3.6512321472167968750000000000000000000000e+01), SC_(1.7059408128261566162109375000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.5075787070107396823411041704326161950615e-03) }},
{{ SC_(3.7015647888183593750000000000000000000000e+01), SC_(2.3332645416259765625000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.3152252536652975160097612559532125867926e-08) }},
{{ SC_(3.8276695251464843750000000000000000000000e+01), SC_(4.6204981803894042968750000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.7727124818858998583126695572245791368643e-19) }},
{{ SC_(3.9146465301513671875000000000000000000000e+01), SC_(2.5820670998655259609222412109375000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.4830119536307678131339780270833903073772e-03) }},
{{ SC_(3.9450698852539062500000000000000000000000e+01), SC_(1.3620869445800781250000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.8499635449383504679436278851497527755252e-01) }},
{{ SC_(3.9513668060302734375000000000000000000000e+01), SC_(2.5859004817903041839599609375000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.3367503533607339310037156072513243862545e-38) }},
{{ SC_(3.9821846008300781250000000000000000000000e+01), SC_(1.5262600708007812500000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1586545112178620103752975674775021301060e+01) }},
{{ SC_(4.0457038879394531250000000000000000000000e+01), SC_(3.2077298828125000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2766208763404335463682499879122814094798e-48199) }},
{{ SC_(4.0558280944824218750000000000000000000000e+01), SC_(2.4588322639465332031250000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.6265292739817175884656161012560562750077e+00) }},
{{ SC_(4.1089622497558593750000000000000000000000e+01), SC_(4.7004003125000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.8264894180590861296101837518838707463763e-75062) }},
{{ SC_(4.1422355651855468750000000000000000000000e+01), SC_(3.9965151809155941009521484375000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6729555534541799554027594155864577714037e-05) }},
{{ SC_(4.2728160858154296875000000000000000000000e+01), SC_(1.5704447031021118164062500000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3330228188271835186709683002118477055964e+00) }},
{{ SC_(4.3032356262207031250000000000000000000000e+01), SC_(3.6546134375000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.4136229839977098762190309797482605055535e-374760) }},
{{ SC_(4.3688262939453125000000000000000000000000e+01), SC_(1.1019987054169178009033203125000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.2654378934176270111656374474902502633196e-02) }},
{{ SC_(4.4119926452636718750000000000000000000000e+01), SC_(2.5921415726770646870136260986328125000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.8279193940939967606664605534500696055368e-33) }},
{{ SC_(4.4164001464843750000000000000000000000000e+01), SC_(3.7055870890617370605468750000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.4253692092647729059847520049642324043021e-38) }},
{{ SC_(4.4357551574707031250000000000000000000000e+01), SC_(2.8652681503444910049438476562500000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.1615509576808099985025278432407563101169e-06) }},
{{ SC_(4.4417617797851562500000000000000000000000e+01), SC_(2.8001288883388042449951171875000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2744471001007193450158740547594860496156e-31) }},
{{ SC_(4.4957092285156250000000000000000000000000e+01), SC_(4.4067830458516255021095275878906250000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1729626260722114333948596433817139954596e-27) }},
{{ SC_(4.5797668457031250000000000000000000000000e+01), SC_(2.4807180175781250000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5354850078027698480557457318619085139872e-87) }},
{{ SC_(4.5887649536132812500000000000000000000000e+01), SC_(3.8356938476562500000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.5901057687820614664710452526031837873884e-2896) }},
{{ SC_(4.5939445495605468750000000000000000000000e+01), SC_(1.2384581565856933593750000000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.0670485647040926451946102571698817177651e-02) }},
{{ SC_(4.6205387115478515625000000000000000000000e+01), SC_(4.6141953125000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.5506970027011288625223272648438322160823e-200346) }},
{{ SC_(4.6206138610839843750000000000000000000000e+01), SC_(1.7227724075317382812500000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.6565215979414871559420837294211434402214e-03) }},
{{ SC_(4.6485298156738281250000000000000000000000e+01), SC_(2.3098428344726562500000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.3832260986857484086180464417260304188665e+00) }},
{{ SC_(4.7248058319091796875000000000000000000000e+01), SC_(1.6102936933748424053192138671875000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8167914218698689342788439938857130668214e-05) }},
{{ SC_(4.7376205444335937500000000000000000000000e+01), SC_(1.3941752258688211441040039062500000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.0103138202239836017769316112699302526558e-27) }},
{{ SC_(4.7565670013427734375000000000000000000000e+01), SC_(1.2347941286861896514892578125000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0571395146097907646300642610654481714251e-33) }},
{{ SC_(4.7917327880859375000000000000000000000000e+01), SC_(4.3436698615550994873046875000000000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.5966845101953736975725300086370918929583e-46) }},
{{ SC_(4.9375934600830078125000000000000000000000e+01), SC_(4.6640709042549133300781250000000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.0413143991088403255839468456431702739770e-12) }},
{{ SC_(4.9536712646484375000000000000000000000000e+01), SC_(3.8639435768127441406250000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.7230765043314033595886203267242701501480e-38) }},
{{ SC_(4.9815589904785156250000000000000000000000e+01), SC_(3.8816207031250000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.4233823688562642907920033779109820205858e-4079) }},
{{ SC_(4.9979667663574218750000000000000000000000e+01), SC_(2.6182122230529785156250000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0267568551349145507814557593474889646847e-21) }},
{{ SC_(1.0312812042236328125000000000000000000000e+02), SC_(1.1406766406250000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0963900779918225814477091972469563801981e-6946) }},
{{ SC_(1.0413464355468750000000000000000000000000e+02), SC_(2.7170151952304877340793609619140625000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.8007837823930525471094945939192213454497e-95) }},
{{ SC_(1.1489385223388671875000000000000000000000e+02), SC_(4.9513237304687500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0170083295672758319171655409021528962949e-7222) }},
{{ SC_(1.1937893676757812500000000000000000000000e+02), SC_(4.2088508052984252572059631347656250000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.4082292880114017344670088439036274179518e-82) }},
{{ SC_(1.2053275299072265625000000000000000000000e+02), SC_(1.5118287410587072372436523437500000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.8973271759227132093330607428107564233157e-13) }},
{{ SC_(1.2376132202148437500000000000000000000000e+02), SC_(3.1601099609375000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.8624976321774599619353123874544560577629e-13407) }},
{{ SC_(1.2463626861572265625000000000000000000000e+02), SC_(2.5919504696503281593322753906250000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4083397054320916983629407532856544874069e-67) }},
{{ SC_(1.2915412902832031250000000000000000000000e+02), SC_(1.9986601546406745910644531250000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1270473047464014015726141368228317674179e-12) }},
{{ SC_(1.3449382019042968750000000000000000000000e+02), SC_(3.6937063932418823242187500000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.7229107122283976189455798575095589862467e-12) }},
{{ SC_(1.3466662597656250000000000000000000000000e+02), SC_(1.3401306867599487304687500000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.3894191594986949553160143028289357320477e-66) }},
{{ SC_(1.3541099548339843750000000000000000000000e+02), SC_(3.0126103665679693222045898437500000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.4166994969427251590218540830870856270044e-08) }},
{{ SC_(1.3659948730468750000000000000000000000000e+02), SC_(4.3410331726074218750000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6114733992251665274891646107862398831360e-06) }},
{{ SC_(1.3694093322753906250000000000000000000000e+02), SC_(1.3135106250000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2442013649686370740384684610277186640062e-7406) }},
{{ SC_(1.4024252319335937500000000000000000000000e+02), SC_(1.0396793365478515625000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.9845975987632120254022407989129683147436e-57) }},
{{ SC_(1.4192529296875000000000000000000000000000e+02), SC_(1.8079894653055816888809204101562500000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.9558594971043267034224231490481231263582e-09) }},
{{ SC_(1.4193849182128906250000000000000000000000e+02), SC_(1.3088135719299316406250000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.9822364504338769746369027268305405382289e-01) }},
{{ SC_(1.4352717590332031250000000000000000000000e+02), SC_(2.7626093750000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.5771863321846490844931573857911004793397e-215673) }},
{{ SC_(1.4390200805664062500000000000000000000000e+02), SC_(3.1782910156250000000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.6198224081623455231357836913959337854421e-58) }},
{{ SC_(1.4414138793945312500000000000000000000000e+02), SC_(2.7948321774601936340332031250000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.2140071650489877717901749729133048475007e-75) }},
{{ SC_(1.4491358947753906250000000000000000000000e+02), SC_(2.1656794738769531250000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.1700759149186047511391708779857437793015e-36) }},
{{ SC_(1.4699714660644531250000000000000000000000e+02), SC_(3.6882355809211730957031250000000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0448230465239603502802762531327833091531e-30) }},
{{ SC_(1.5013287353515625000000000000000000000000e+02), SC_(3.3750347656250000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.2409247125909901787910248692089374396820e-35443) }},
{{ SC_(1.5059994506835937500000000000000000000000e+02), SC_(3.0672200000000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.5577288481703730608320630620291700003250e-325304) }},
{{ SC_(1.5115534973144531250000000000000000000000e+02), SC_(4.0882988832890987396240234375000000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1389491722241814375704100333254468555317e-04) }},
{{ SC_(1.5206057739257812500000000000000000000000e+02), SC_(4.8686925781250000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4599090543805109364697377489719764785921e-72916) }},
{{ SC_(1.5283317565917968750000000000000000000000e+02), SC_(1.8935961648821830749511718750000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.1283190025281850894210509896188838752280e-134) }},
{{ SC_(1.5372131347656250000000000000000000000000e+02), SC_(2.4714421875000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.4775440689326373776004819677720454855259e-371846) }},
{{ SC_(1.6073820495605468750000000000000000000000e+02), SC_(2.5522890090942382812500000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.5607014063971071905837576333187677542484e-108) }},
{{ SC_(1.7498432922363281250000000000000000000000e+02), SC_(3.1078662109375000000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7462433114416927463431303179375310642125e-154) }},
{{ SC_(1.8226980590820312500000000000000000000000e+02), SC_(4.9139490127563476562500000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.4900789803876676270648063826244300924631e-10) }},
{{ SC_(1.8241114807128906250000000000000000000000e+02), SC_(1.8299617767333984375000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5196394593757701851979909512458932572690e-115) }},
{{ SC_(1.9158129882812500000000000000000000000000e+02), SC_(2.2190074920654296875000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.6873837340414033074799224294373282359571e-04) }},
{{ SC_(1.9393077087402343750000000000000000000000e+02), SC_(4.8828536272048950195312500000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.8445854092901725450068262195971105594933e-167) }},
{{ SC_(1.9494920349121093750000000000000000000000e+02), SC_(2.5735282897949218750000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6537319555662917418789399371911049642848e-01) }},
{{ SC_(2.0647154235839843750000000000000000000000e+02), SC_(4.9994448242187500000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0788422591868111458386321128666600327299e-527) }},
{{ SC_(2.0917552185058593750000000000000000000000e+02), SC_(4.3213662109375000000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.7916212415015242859258051464350198331194e-4230) }},
{{ SC_(2.1519079589843750000000000000000000000000e+02), SC_(2.5329818527097813785076141357421875000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.3062591722600557752345170656388994696165e-07) }},
{{ SC_(2.1662812805175781250000000000000000000000e+02), SC_(3.4868240356445312500000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0619257303340107041315507400571390388576e-15) }},
{{ SC_(2.1762652587890625000000000000000000000000e+02), SC_(1.7934913635253906250000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9073969963469536565794012865299415465354e-23) }},
{{ SC_(2.2632455444335937500000000000000000000000e+02), SC_(3.9210187500000000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.1979367430656016130217590625245402918800e-28124) }},
{{ SC_(2.3152568054199218750000000000000000000000e+02), SC_(4.3550487607717514038085937500000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.8210770686247264150669479998297644058852e-19) }},
{{ SC_(2.3503355407714843750000000000000000000000e+02), SC_(1.9701055134646594524383544921875000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5952540186344865928886717429713864709340e-24) }},
{{ SC_(2.4657464599609375000000000000000000000000e+02), SC_(1.3934823870658874511718750000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.9259282985037174935238575715785985099348e-20) }},
{{ SC_(2.4706115722656250000000000000000000000000e+02), SC_(2.6212046146392822265625000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9175557331681791768532208885167674717718e-208) }},
{{ SC_(2.4767951965332031250000000000000000000000e+02), SC_(3.7899664044380187988281250000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.7586181631860206328523734058717684332953e-10) }},
{{ SC_(2.5530865478515625000000000000000000000000e+02), SC_(1.6643607616424560546875000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.1626764601095258127599039769223957114040e-17) }},
{{ SC_(2.5840267944335937500000000000000000000000e+02), SC_(3.4632722167968750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4881159734037920999552963016187612061961e-3155) }},
{{ SC_(2.5860830688476562500000000000000000000000e+02), SC_(4.5402420801110565662384033203125000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.5788163838127423454986684644682341408817e-173) }},
{{ SC_(2.6212615966796875000000000000000000000000e+02), SC_(4.1189559936523437500000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.4240288072745764321202472096851192432393e-01) }},
{{ SC_(2.6924377441406250000000000000000000000000e+02), SC_(2.4888453125000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.9373176083470937725849142021795818357630e-26270) }},
{{ SC_(2.7182580566406250000000000000000000000000e+02), SC_(4.0013292968750000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1817844694107334043664577027886676755289e-2058) }},
{{ SC_(2.7299398803710937500000000000000000000000e+02), SC_(2.1391821289062500000000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.5432429042758335815333700032573356095164e-35) }},
{{ SC_(2.7305694580078125000000000000000000000000e+02), SC_(1.2083953857421875000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0056529862802610718742030210576921104397e-32) }},
{{ SC_(2.8069567871093750000000000000000000000000e+02), SC_(4.0294875000000000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.6048231579056833049718376698024014287161e-3828) }},
{{ SC_(2.9379214477539062500000000000000000000000e+02), SC_(4.3755107879638671875000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2024298938514869638516384021529789911551e-208) }},
{{ SC_(2.9409173583984375000000000000000000000000e+02), SC_(4.1162283159792423248291015625000000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.1226268905174331053421815898651973113403e-257) }},
{{ SC_(2.9504150390625000000000000000000000000000e+02), SC_(4.6118535156250000000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.1157729140747821633183808947325285536478e-2918) }},
{{ SC_(3.1044097900390625000000000000000000000000e+02), SC_(3.6171117244521155953407287597656250000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.7103993274862228539824626167993113957208e-32) }},
{{ SC_(3.1234890747070312500000000000000000000000e+02), SC_(1.7860824584960937500000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.4545097231291842835111449986375118727084e-08) }},
{{ SC_(3.1248370361328125000000000000000000000000e+02), SC_(2.9084796875000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.3538731762045574111415163562025656277360e-211929) }},
{{ SC_(3.1981604003906250000000000000000000000000e+02), SC_(3.4338268451392650604248046875000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.1852850772340309117202026494135840831435e-289) }},
{{ SC_(3.2071142578125000000000000000000000000000e+02), SC_(4.6738977432250976562500000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.1128746057725107492552284590855745519198e-07) }},
{{ SC_(3.2266793823242187500000000000000000000000e+02), SC_(2.9800191987305879592895507812500000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.3790640307999424350384477956675791011267e-283) }},
{{ SC_(3.3327429199218750000000000000000000000000e+02), SC_(4.5115660876035690307617187500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.5089874315181230530318724134008235083731e-05) }},
{{ SC_(3.3917666625976562500000000000000000000000e+02), SC_(4.1113200783729553222656250000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.8952123951594702122517836187805162786228e-04) }},
{{ SC_(3.4138720703125000000000000000000000000000e+02), SC_(3.8420264900196343660354614257812500000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8989815979751191651967741064519226339975e-72) }},
{{ SC_(3.4141339111328125000000000000000000000000e+02), SC_(4.6846847534179687500000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4861739061442735837924893284210103013519e-09) }},
{{ SC_(3.4314636230468750000000000000000000000000e+02), SC_(1.0059650958282873034477233886718750000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.8887307451058544077979951054563084163291e-31) }},
{{ SC_(3.4394287109375000000000000000000000000000e+02), SC_(3.6665765625000000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5273033438702697416788615667960266430864e-5195) }},
{{ SC_(3.5270654296875000000000000000000000000000e+02), SC_(2.1271725000000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2642952576800355734618618058911080399123e-217118) }},
{{ SC_(3.5628717041015625000000000000000000000000e+02), SC_(4.6374622732400894165039062500000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.5920165478651730583459667598581823498943e-33) }},
{{ SC_(3.5677624511718750000000000000000000000000e+02), SC_(3.3235576152801513671875000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.5805993591343952335016074670457707432506e-01) }},
{{ SC_(3.6152481079101562500000000000000000000000e+02), SC_(1.8475575372576713562011718750000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.8340691999544922892876860766674306448136e-17) }},
{{ SC_(3.6219921875000000000000000000000000000000e+02), SC_(3.4435375976562500000000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.6017377743147248022241012875742059723403e-310) }},
{{ SC_(3.6222927856445312500000000000000000000000e+02), SC_(1.3116535937500000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.8620304408155528388507805063294283114576e-20092) }},
{{ SC_(3.6716644287109375000000000000000000000000e+02), SC_(2.3287344447453506290912628173828125000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.3635848966390022583731541903962518152380e-192) }},
{{ SC_(3.6931796264648437500000000000000000000000e+02), SC_(3.5824742187500000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8188626501955497855344877868246122643560e-1549) }},
{{ SC_(3.7348623657226562500000000000000000000000e+02), SC_(3.9074774831533432006835937500000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0763914232774657689270512521089189109902e-335) }},
{{ SC_(3.7401138305664062500000000000000000000000e+02), SC_(1.8638053536415100097656250000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.3954142033531019617870046694925282073518e-15) }},
{{ SC_(3.7701278686523437500000000000000000000000e+02), SC_(4.1205019806511700153350830078125000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.1536603863558681000742832775758488389086e-341) }},
{{ SC_(3.7790087890625000000000000000000000000000e+02), SC_(1.3385350036621093750000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.9456697642729429515082290101186750799807e-06) }},
{{ SC_(3.7857321166992187500000000000000000000000e+02), SC_(2.9545880859375000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.1432791353531270451125161588497078462609e-29446) }},
{{ SC_(3.8290136718750000000000000000000000000000e+02), SC_(4.6764689614064991474151611328125000000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9354816101268989690384391406307683357577e-20) }},
{{ SC_(3.8908981323242187500000000000000000000000e+02), SC_(3.7303078919649124145507812500000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.7062028935331194922555725937091776577887e-256) }},
{{ SC_(3.8916900634765625000000000000000000000000e+02), SC_(4.1367496875000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.5806681823425567917359247466790092272038e-178521) }},
{{ SC_(3.9188378906250000000000000000000000000000e+02), SC_(1.9626211724244058132171630859375000000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.9448891669803086295198821974751478249923e-35) }},
{{ SC_(3.9373641967773437500000000000000000000000e+02), SC_(4.3229237198829650878906250000000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.3560450714575368307988547685799728950173e-81) }},
{{ SC_(3.9398300170898437500000000000000000000000e+02), SC_(2.6916375756263732910156250000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.9665072325969883587149099333457155115372e-258) }},
{{ SC_(3.9601293945312500000000000000000000000000e+02), SC_(3.8362812995910644531250000000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.7429480271160540103608632005594256834523e-354) }},
{{ SC_(3.9650161743164062500000000000000000000000e+02), SC_(2.5799489230848848819732666015625000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.7829495266615135034278055264558006099114e-20) }},
{{ SC_(3.9852539062500000000000000000000000000000e+02), SC_(3.5691202356247231364250183105468750000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8290443748365609041067110848907046765273e-361) }},
{{ SC_(3.9965258789062500000000000000000000000000e+02), SC_(4.8042807728052139282226562500000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3920891060685805099704766484425530498594e-16) }},
{{ SC_(4.0323971557617187500000000000000000000000e+02), SC_(2.3111882019042968750000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0026089406503486018368069537510709995258e-72) }},
{{ SC_(4.0758334350585937500000000000000000000000e+02), SC_(1.5152218017578125000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3753509472146470632005352740188090507140e-785) }},
{{ SC_(4.0877355957031250000000000000000000000000e+02), SC_(3.0767302513122558593750000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4872611352354489407378101259029938657425e-75) }},
{{ SC_(4.0908883666992187500000000000000000000000e+02), SC_(4.1189671875000000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3604064070191511012381925251621678581587e-31267) }},
{{ SC_(4.1207019042968750000000000000000000000000e+02), SC_(2.1117510914336889982223510742187500000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.9607645034354033295363039230406607998367e-86) }},
{{ SC_(4.1255084228515625000000000000000000000000e+02), SC_(3.4153494198108091950416564941406250000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.5285519592629015708032947016839075708538e-20) }},
{{ SC_(4.1277279663085937500000000000000000000000e+02), SC_(1.0240541458129882812500000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.4645325254587513322598677095831898179087e-250) }},
{{ SC_(4.1377114868164062500000000000000000000000e+02), SC_(2.1019207763671875000000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.2511615401688986975890876929168111784667e-198) }},
{{ SC_(4.1574554443359375000000000000000000000000e+02), SC_(1.3229464292526245117187500000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.0528522691196123241318107663906123955136e-369) }},
{{ SC_(4.1913214111328125000000000000000000000000e+02), SC_(4.4209975585937500000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.9238350063674124366172080663693547330093e-1385) }},
{{ SC_(4.1934033203125000000000000000000000000000e+02), SC_(1.5128457453101873397827148437500000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.0920855809486976430750200606430063367110e-19) }},
{{ SC_(4.1958407592773437500000000000000000000000e+02), SC_(2.5380449369549751281738281250000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.2292478652250121229754661501634708035838e-217) }},
{{ SC_(4.4677209472656250000000000000000000000000e+02), SC_(1.3732771575450897216796875000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5530341463746787569188872778155544609474e-89) }},
{{ SC_(4.5619030761718750000000000000000000000000e+02), SC_(2.9975688084959983825683593750000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.8514922172919577322258191790238942244857e-301) }},
{{ SC_(4.7350396728515625000000000000000000000000e+02), SC_(2.3916152343750000000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.5492189069981881032922841683383376349502e-03) }},
{{ SC_(4.7720327758789062500000000000000000000000e+02), SC_(4.9147461540997028350830078125000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.6247955803108351904730572899776289562480e-08) }},
{{ SC_(4.8576907348632812500000000000000000000000e+02), SC_(1.9016734313964843750000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.5881434995648076933628807137510010620742e-04) }},
{{ SC_(4.8823937988281250000000000000000000000000e+02), SC_(4.3491059541702270507812500000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(8.2156862099449491244125181500341886269610e-249) }},
{{ SC_(1.0821430664062500000000000000000000000000e+03), SC_(1.0693661132812500000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.7779987710869617972730393795128718482702e-30) }},
{{ SC_(1.0977360839843750000000000000000000000000e+03), SC_(1.4807869195938110351562500000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.1792867109843257730333828784377738382372e-948) }},
{{ SC_(1.1462520751953125000000000000000000000000e+03), SC_(1.8451454162597656250000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1891352456949949535425247630305069788027e-59) }},
{{ SC_(1.2567484130859375000000000000000000000000e+03), SC_(1.1467122656250000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.7440940886202847887132666884555900921899e-10255) }},
{{ SC_(1.2959790039062500000000000000000000000000e+03), SC_(4.4260006397962570190429687500000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3916902935836776866235089637615021486789e-260) }},
{{ SC_(1.3093872070312500000000000000000000000000e+03), SC_(4.4117416837252676486968994140625000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1694573286272541310156202118792319095123e-672) }},
{{ SC_(1.3940749511718750000000000000000000000000e+03), SC_(1.5517035484313964843750000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3881057137080796678633064714226952556403e-38) }},
{{ SC_(1.3943763427734375000000000000000000000000e+03), SC_(1.4715659744979348033666610717773437500000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.9380402652162004105902430072443196556166e-1254) }},
{{ SC_(1.4236816406250000000000000000000000000000e+03), SC_(3.7307399749755859375000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.8010913546521540704471230104852802702910e-658) }},
{{ SC_(1.4807480468750000000000000000000000000000e+03), SC_(2.9572844238281250000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0863406177476673165459963089720442943492e-63) }},
{{ SC_(1.4994909667968750000000000000000000000000e+03), SC_(4.8578619956970214843750000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2530621033351126999376654879314257470235e-1329) }},
{{ SC_(1.5681090087890625000000000000000000000000e+03), SC_(3.3945001632673665881156921386718750000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.6905650607241250417734188598898261066259e-1365) }},
{{ SC_(1.6143615722656250000000000000000000000000e+03), SC_(2.5700808715820312500000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.5717962750433892553327243061291556181428e-06) }},
{{ SC_(1.6174792480468750000000000000000000000000e+03), SC_(3.2529197633266448974609375000000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5613020555445736127352712987490645993983e-1450) }},
{{ SC_(1.6445358886718750000000000000000000000000e+03), SC_(3.4209486097097396850585937500000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.0160819124353090326534201793113526670053e-1079) }},
{{ SC_(1.6540494384765625000000000000000000000000e+03), SC_(3.4146527343750000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.2928319653373178656154179939085072203992e-12258) }},
{{ SC_(1.6542796630859375000000000000000000000000e+03), SC_(3.6420272827148437500000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.2079533961827636975427015304704947220383e-1089) }},
{{ SC_(1.6648142089843750000000000000000000000000e+03), SC_(3.3929268829524517059326171875000000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3451074699917154027756478638243593405929e-68) }},
{{ SC_(1.6730052490234375000000000000000000000000e+03), SC_(1.0663307875802274793386459350585937500000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.1117683487165279909889352984491767700028e-1101) }},
{{ SC_(1.6817281494140625000000000000000000000000e+03), SC_(4.6525541692972183227539062500000000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3018456593085851397345102963352775027918e-1461) }},
{{ SC_(1.7000389404296875000000000000000000000000e+03), SC_(2.3171976089477539062500000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.8273457863213880209302588382044217997947e-04) }},
{{ SC_(1.7229510498046875000000000000000000000000e+03), SC_(3.1808288574218750000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.4819153027966721997588501107894776424270e-2065) }},
{{ SC_(1.7377346191406250000000000000000000000000e+03), SC_(4.4125562999397516250610351562500000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9619160954255475091902579399076739398521e-1511) }},
{{ SC_(1.7849957275390625000000000000000000000000e+03), SC_(2.8711086997645907104015350341796875000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.1491878523730796243968912087979334854484e-917) }},
{{ SC_(1.8481232910156250000000000000000000000000e+03), SC_(4.8024553689174354076385498046875000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6202952161072480323837196410966773031709e-1214) }},
{{ SC_(1.8486528320312500000000000000000000000000e+03), SC_(2.4980598449707031250000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.9744391389533409984772130035309995209821e-106) }},
{{ SC_(1.8702532958984375000000000000000000000000e+03), SC_(1.3475679224939085543155670166015625000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.5377825303979206340535874324922863367284e-151) }},
{{ SC_(1.9146778564453125000000000000000000000000e+03), SC_(2.4045481250000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0075369133563796046934246237151912613365e-12019) }},
{{ SC_(1.9619135742187500000000000000000000000000e+03), SC_(1.2235392332077026367187500000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.7459845578621576500090092283801101950830e-74) }},
{{ SC_(2.0041676025390625000000000000000000000000e+03), SC_(1.8206319509772583842277526855468750000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6445756484375875413087862168960030718362e-90) }},
{{ SC_(2.0215468750000000000000000000000000000000e+03), SC_(1.2785270996093750000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1429753405612859304214451996114198721339e-995) }},
{{ SC_(2.0304550781250000000000000000000000000000e+03), SC_(2.7725343750000000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.8290763296876344695945426011743914449057e-38585) }},
{{ SC_(2.0311689453125000000000000000000000000000e+03), SC_(1.6711292555555701255798339843750000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.1571982259243589666666175125121460730874e-1334) }},
{{ SC_(2.1607412109375000000000000000000000000000e+03), SC_(4.9396953582763671875000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7273643851825347185101818764724098700456e-1401) }},
{{ SC_(2.1765944824218750000000000000000000000000e+03), SC_(2.2744994610548019409179687500000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.1642966828025469185138375040292436138504e-95) }},
{{ SC_(2.1969001464843750000000000000000000000000e+03), SC_(4.1700664162635803222656250000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.1867557461002767076550277562311888576266e-1439) }},
{{ SC_(2.2537160644531250000000000000000000000000e+03), SC_(4.6744965948164463043212890625000000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.0235799997513014261045136682969176450333e-100) }},
{{ SC_(2.2657160644531250000000000000000000000000e+03), SC_(2.3549166144221089780330657958984375000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.8933115713606004406668946447617924812496e-206) }},
{{ SC_(2.2699191894531250000000000000000000000000e+03), SC_(1.4260323041526135057210922241210937500000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1200641752676728208437884523657134547144e-456) }},
{{ SC_(2.2700825195312500000000000000000000000000e+03), SC_(1.9198791980743408203125000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.5057761793463818129956836720156931533058e-1154) }},
{{ SC_(2.3033344726562500000000000000000000000000e+03), SC_(2.4343950195312500000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.7216504587705396842666096307820798863996e-90) }},
{{ SC_(2.3412451171875000000000000000000000000000e+03), SC_(4.9196591973304748535156250000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7249612540497987797598270059200442951186e-2030) }},
{{ SC_(2.4031069335937500000000000000000000000000e+03), SC_(3.9352804422378540039062500000000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.0325527048842835845782587540401718461412e-215) }},
{{ SC_(2.4384252929687500000000000000000000000000e+03), SC_(4.8907160758972167968750000000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.7808933932913690264351880429977898040787e-216) }},
{{ SC_(2.5253808593750000000000000000000000000000e+03), SC_(4.6969298273324966430664062500000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2602080539839284447423031137666170948226e-2192) }},
{{ SC_(2.5630483398437500000000000000000000000000e+03), SC_(4.4479740625000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.4900570303440855111454634691666150186665e-465798) }},
{{ SC_(2.5871972656250000000000000000000000000000e+03), SC_(1.0755545226857066154479980468750000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.2271873612629810614746179151801014460349e-1325) }},
{{ SC_(2.5955229492187500000000000000000000000000e+03), SC_(2.3112141113281250000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.5963211902400481708734738612595543282536e-537) }},
{{ SC_(2.6087360839843750000000000000000000000000e+03), SC_(3.9381901733577251434326171875000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1561656001284261378786963582091456884137e-104) }},
{{ SC_(2.6095532226562500000000000000000000000000e+03), SC_(4.1527482680976390838623046875000000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4518093229710100798326896241811991450865e-206) }},
{{ SC_(2.6603737792968750000000000000000000000000e+03), SC_(2.0361149902343750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3829171223662426883696841616336596723276e-806) }},
{{ SC_(2.6761933593750000000000000000000000000000e+03), SC_(4.5704346875000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9789169651036254818785550838949957543259e-461879) }},
{{ SC_(2.6905827636718750000000000000000000000000e+03), SC_(2.2973056137561798095703125000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8548921068993254633074545736403774100850e-535) }},
{{ SC_(2.6973391113281250000000000000000000000000e+03), SC_(3.2784470915794372558593750000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0523993901596025445495525162339375098152e-105) }},
{{ SC_(2.7174230957031250000000000000000000000000e+03), SC_(2.7853864431381225585937500000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.6834689384834218473773759040906159760550e-36) }},
{{ SC_(2.7601423339843750000000000000000000000000e+03), SC_(4.6082707031250000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.6823997456048731998300669514715865353485e-44457) }},
{{ SC_(2.8103701171875000000000000000000000000000e+03), SC_(3.5567209124565124511718750000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0378277479617562341441287071847704505078e-1435) }},
{{ SC_(2.8315454101562500000000000000000000000000e+03), SC_(2.6487302780151367187500000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.5792530621032225068873968795629124792154e-115) }},
{{ SC_(2.8530424804687500000000000000000000000000e+03), SC_(2.3232576370239257812500000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.8668293840993527479820601883476551856832e-212) }},
{{ SC_(3.0662329101562500000000000000000000000000e+03), SC_(1.4186326599121093750000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.2539944561524020596698027546009734890785e-1337) }},
{{ SC_(3.1001806640625000000000000000000000000000e+03), SC_(1.4472921142578125000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0466617109715389305878522066046596249655e-579) }},
{{ SC_(3.1225170898437500000000000000000000000000e+03), SC_(3.2955713570117950439453125000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.0472000432501013958731930685605282946755e-124) }},
{{ SC_(3.1635363769531250000000000000000000000000e+03), SC_(2.9823937988281250000000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.0035462731451342187854304379227819269576e+01) }},
{{ SC_(3.1857976074218750000000000000000000000000e+03), SC_(2.1626496582031250000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7422105663766828783637363271018672817229e-298) }},
{{ SC_(3.2229519042968750000000000000000000000000e+03), SC_(1.1407608690205961465835571289062500000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.7025157447946579246098393352282808925154e-2891) }},
{{ SC_(3.2311557617187500000000000000000000000000e+03), SC_(4.2852279148064553737640380859375000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.1122251830355622408689392528471465675113e-256) }},
{{ SC_(3.2332768554687500000000000000000000000000e+03), SC_(3.0209398269653320312500000000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1087348466618828730543091495442476445297e-252) }},
{{ SC_(3.3095766601562500000000000000000000000000e+03), SC_(1.9694058593750000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9832019319527440788972712816924649692044e-16230) }},
{{ SC_(3.3899606933593750000000000000000000000000e+03), SC_(1.2216867506504058837890625000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9073265670137533070192642306663874719553e-3037) }},
{{ SC_(3.4826877441406250000000000000000000000000e+03), SC_(3.3458536490797996520996093750000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.6639647976395077437842750237344939769119e-49) }},
{{ SC_(3.4899890136718750000000000000000000000000e+03), SC_(4.3070979882031679153442382812500000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.6745062308526515712567111417600335126129e-50) }},
{{ SC_(3.5682431640625000000000000000000000000000e+03), SC_(3.5207578125000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(7.4653668023880922943847736800628516901986e-267133) }},
{{ SC_(3.6147607421875000000000000000000000000000e+03), SC_(3.3879837989807128906250000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3490625298255793642675487101707521067901e-709) }},
{{ SC_(3.6147995605468750000000000000000000000000e+03), SC_(4.5861597656250000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.4613621600191471267183046467925838489407e-1726) }},
{{ SC_(3.6639487304687500000000000000000000000000e+03), SC_(1.2549743652343750000000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4726394850453413205828952825451699424718e-2947) }},
{{ SC_(3.6848088378906250000000000000000000000000e+03), SC_(2.3887562500000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4641863068610657855491220759902475725645e-96263) }},
{{ SC_(3.7189355468750000000000000000000000000000e+03), SC_(2.8495684814453125000000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3703037769040852859541227816214131379645e-01) }},
{{ SC_(3.7262419433593750000000000000000000000000e+03), SC_(2.8897109985351562500000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6516375620142039290075695433646445570741e-680) }},
{{ SC_(3.7363840332031250000000000000000000000000e+03), SC_(4.3655070476233959197998046875000000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0282008037304387914970763343157614326674e-334) }},
{{ SC_(3.7421428222656250000000000000000000000000e+03), SC_(2.1638566628098487854003906250000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.7789195504653962968771339538182673535076e-294) }},
{{ SC_(3.8108090820312500000000000000000000000000e+03), SC_(1.3970056152343750000000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5049873664828402089015581397822872822150e-556) }},
{{ SC_(3.8128928222656250000000000000000000000000e+03), SC_(2.9071168683003634214401245117187500000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.1443349738045808742350119888488305398801e-56) }},
{{ SC_(3.8268608398437500000000000000000000000000e+03), SC_(4.4492297456599771976470947265625000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.0701551221413571098727535558368688631659e-344) }},
{{ SC_(3.8608500976562500000000000000000000000000e+03), SC_(4.0868875000000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.0265467846312346207625461598655514617763e-290092) }},
{{ SC_(3.9625922851562500000000000000000000000000e+03), SC_(3.1161039352416992187500000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.1630775901289468843199527699329713869220e-3361) }},
{{ SC_(3.9701813964843750000000000000000000000000e+03), SC_(4.6857738494873046875000000000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.5769445299837698107060018055600525608279e-169) }},
{{ SC_(3.9747534179687500000000000000000000000000e+03), SC_(3.1380681991577148437500000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.3148776920048298452542646966462157519113e-2528) }},
{{ SC_(3.9944755859375000000000000000000000000000e+03), SC_(1.4308979492187500000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8136850849618833119202234597398304363788e-2196) }},
{{ SC_(4.0077858886718750000000000000000000000000e+03), SC_(3.2507290625000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.3063028488744863637837279824507077352144e-13373) }},
{{ SC_(4.0324497070312500000000000000000000000000e+03), SC_(1.4052885584533214569091796875000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.6046978310203278003092909571186757119521e-2063) }},
{{ SC_(4.0373095703125000000000000000000000000000e+03), SC_(1.6881650924682617187500000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.9804264724736939837105609438984408000995e-3570) }},
{{ SC_(4.0555915527343750000000000000000000000000e+03), SC_(3.0240068435668945312500000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.3183135122892188515467120038764947269687e-49) }},
{{ SC_(4.0693178710937500000000000000000000000000e+03), SC_(3.2551334375000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.0418803666216395068910362455840600094813e-44652) }},
{{ SC_(4.1786318359375000000000000000000000000000e+03), SC_(4.6566515625000000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.7004610065273544923895372013771206921088e-30499) }},
{{ SC_(4.2368154296875000000000000000000000000000e+03), SC_(2.6380112304687500000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6348693140356674762104971760954642193685e-1962) }},
{{ SC_(4.2645605468750000000000000000000000000000e+03), SC_(2.3504484375000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.6269808177069328765559826246063423332720e-344935) }},
{{ SC_(4.2942983398437500000000000000000000000000e+03), SC_(3.9175590515136718750000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.2302908200925565076926319523493547611897e-113) }},
{{ SC_(4.3296938476562500000000000000000000000000e+03), SC_(3.5650547593832015991210937500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.9272705154848713185879314100529145911452e-60) }},
{{ SC_(4.4844448242187500000000000000000000000000e+03), SC_(3.4760583192110061645507812500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.9442829729480301034456091021057084185535e-894) }},
{{ SC_(4.5716894531250000000000000000000000000000e+03), SC_(3.0711162253282964229583740234375000000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.1259866941061500763547074426160742669633e-184) }},
{{ SC_(4.5775576171875000000000000000000000000000e+03), SC_(4.6295422363281250000000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.7522730011717117034889622262500337004685e-2378) }},
{{ SC_(4.6552021484375000000000000000000000000000e+03), SC_(4.9212010344490408897399902343750000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.7919989725993217476194160541393923461771e-930) }},
{{ SC_(4.6843891601562500000000000000000000000000e+03), SC_(4.8115414062500000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6835029342999073019801907619414071879542e-28777) }},
{{ SC_(4.6947021484375000000000000000000000000000e+03), SC_(1.5396767578125000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.2054071562668494398305518469484926750109e-303) }},
{{ SC_(4.7304545898437500000000000000000000000000e+03), SC_(3.9692902343750000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0266965016001638553122253855240552225608e-2226) }},
{{ SC_(4.7429238281250000000000000000000000000000e+03), SC_(4.0585746765136718750000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6378020163712498306432912195875769865666e-360) }},
{{ SC_(4.8138286132812500000000000000000000000000e+03), SC_(3.6626776123046875000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(7.5930445373206410921348928178902006870119e-88) }},
{{ SC_(4.8277436523437500000000000000000000000000e+03), SC_(3.2813909053802490234375000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.2710563858842009738260151416446893196866e-420) }},
{{ SC_(4.9313408203125000000000000000000000000000e+03), SC_(3.9180740714073181152343750000000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.1423487417829146642336129832450722072805e-214) }},
{{ SC_(4.9517387695312500000000000000000000000000e+03), SC_(3.1504244543612003326416015625000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.7830981574751854543886342488750611688569e-4439) }},
{{ SC_(1.0727101562500000000000000000000000000000e+04), SC_(2.0614435195922851562500000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.1297491655282602600289247923944309026224e-5421) }},
{{ SC_(1.0865992187500000000000000000000000000000e+04), SC_(4.7252035140991210937500000000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.5372797011135038889940783661490268442006e-9428) }},
{{ SC_(1.1005399414062500000000000000000000000000e+04), SC_(3.7013436667621135711669921875000000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.4550754854594701846615722486033833569038e-436) }},
{{ SC_(1.1199677734375000000000000000000000000000e+04), SC_(2.6937861442565917968750000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4172032479242313224599985089848126386958e-868) }},
{{ SC_(1.1672794921875000000000000000000000000000e+04), SC_(1.5108760070800781250000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.0258461293576176657009787244900415700691e-5638) }},
{{ SC_(1.1802043945312500000000000000000000000000e+04), SC_(2.1559476852416992187500000000000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2267509277527687156853028502496961235997e-1051) }},
{{ SC_(1.2400753906250000000000000000000000000000e+04), SC_(3.5121709515806287527084350585937500000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.2828158207654122891548994692046740103756e-492) }},
{{ SC_(1.2677850585937500000000000000000000000000e+04), SC_(3.8009876251220703125000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.1184940807075490690118072220783244115687e-10892) }},
{{ SC_(1.3303708984375000000000000000000000000000e+04), SC_(1.6683587890625000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.5115508171776630148547003428259902904539e-8742) }},
{{ SC_(1.3483087890625000000000000000000000000000e+04), SC_(3.4626166820526123046875000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.1146601988454921317983335181848353997145e-520) }},
{{ SC_(1.3500014648437500000000000000000000000000e+04), SC_(1.4775004237890243530273437500000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7859643121435528971705876140229482168173e-8849) }},
{{ SC_(1.4277666992187500000000000000000000000000e+04), SC_(2.7566424560546875000000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.6048322911125501728436935731961776803012e-2367) }},
{{ SC_(1.5026183593750000000000000000000000000000e+04), SC_(1.9143568750000000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.4132706086688493775229759759050896542290e-173666) }},
{{ SC_(1.5514759765625000000000000000000000000000e+04), SC_(4.6930514526367187500000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.3210341146049940612637731180794889984228e-13007) }},
{{ SC_(1.5687487304687500000000000000000000000000e+04), SC_(2.8829823713749647140502929687500000000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.0546153623117114166259366836304461437297e-677) }},
{{ SC_(1.7074203125000000000000000000000000000000e+04), SC_(1.0791087988764047622680664062500000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.5403729890727547901614055410776428441396e-1340) }},
{{ SC_(1.7224675781250000000000000000000000000000e+04), SC_(2.2506128996610641479492187500000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5117135142503714565213763460276410676411e-3429) }},
{{ SC_(1.7285642578125000000000000000000000000000e+04), SC_(2.5259585571289062500000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.6818133967820509521977536273068159261257e-10781) }},
{{ SC_(1.7364011718750000000000000000000000000000e+04), SC_(3.2844119705259799957275390625000000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1051895497293772051649848298470960322804e-15559) }},
{{ SC_(1.8709283203125000000000000000000000000000e+04), SC_(3.1106303125000000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2856270526922987332564542369539309279910e-213690) }},
{{ SC_(1.8712064453125000000000000000000000000000e+04), SC_(1.2512817382812500000000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(8.0957619679014602754425436720168695945994e-15920) }},
{{ SC_(1.8950816406250000000000000000000000000000e+04), SC_(2.2483095526695251464843750000000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6147712303824159529382198917113263319868e-16980) }},
{{ SC_(1.8966861328125000000000000000000000000000e+04), SC_(2.1034784731455147266387939453125000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.2751943927810433247337794613555179411712e-9698) }},
{{ SC_(1.9108511718750000000000000000000000000000e+04), SC_(1.5829699039459228515625000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.7329292005642695907330107008467582633284e-9760) }},
{{ SC_(1.9766611328125000000000000000000000000000e+04), SC_(1.1978387451171875000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.3757604873884437711226983213430741910996e-490) }},
{{ SC_(1.9945158203125000000000000000000000000000e+04), SC_(1.3233332633972167968750000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0815052018221374035266814911415241197226e-17303) }},
{{ SC_(2.0612880859375000000000000000000000000000e+04), SC_(4.5445901341736316680908203125000000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.4105723257102964831029471223219782389473e-813) }},
{{ SC_(2.1002789062500000000000000000000000000000e+04), SC_(3.6717395782470703125000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.0507427209609704396819189421460631165512e-18802) }},
{{ SC_(2.1820291015625000000000000000000000000000e+04), SC_(4.2565722656250000000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3472459075369398179471384796623311419816e-263) }},
{{ SC_(2.2356583984375000000000000000000000000000e+04), SC_(4.5783253125000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.0924662548591877233195484751580535889965e-448022) }},
{{ SC_(2.2697115234375000000000000000000000000000e+04), SC_(3.6551278753904625773429870605468750000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.5820652654388408584877277582307886393771e-20339) }},
{{ SC_(2.3467970703125000000000000000000000000000e+04), SC_(2.1435808105468750000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.5707343417199298706931493543040322497578e-2401) }},
{{ SC_(2.3857951171875000000000000000000000000000e+04), SC_(3.4405943750000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.8075864300632438721226741938981360460252e-14609) }},
{{ SC_(2.3897503906250000000000000000000000000000e+04), SC_(2.6466283947229385375976562500000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.0516706451577255883845627738041933459902e-1028) }},
{{ SC_(2.4178228515625000000000000000000000000000e+04), SC_(4.5480566406250000000000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.9585892299491201753646360106337185639122e-520) }},
{{ SC_(2.4181371093750000000000000000000000000000e+04), SC_(4.6375087500000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.8014903778469519629427048915542234360681e-7244) }},
{{ SC_(2.4202947265625000000000000000000000000000e+04), SC_(4.3113681022077798843383789062500000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.2801411784709280839606977524424168580304e-21008) }},
{{ SC_(2.4814507812500000000000000000000000000000e+04), SC_(2.2801845334470272064208984375000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0164012924843465392513059629964650189722e-16265) }},
{{ SC_(2.4942550781250000000000000000000000000000e+04), SC_(3.0992994084954261779785156250000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.7323602403238048196426704755746308988715e-21648) }},
{{ SC_(2.5332253906250000000000000000000000000000e+04), SC_(1.8558505177497863769531250000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0365910641250238646113533760207725427106e-1983) }},
{{ SC_(2.5354742187500000000000000000000000000000e+04), SC_(2.9456734657287597656250000000000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.2055520689512551316446211924913329043294e-349) }},
{{ SC_(2.5489816406250000000000000000000000000000e+04), SC_(4.9681845121085643768310546875000000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.9434891999133029495708988467058342266722e-1999) }},
{{ SC_(2.6425164062500000000000000000000000000000e+04), SC_(3.0739816284179687500000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.2266546058768713381885706690118275448746e-636) }},
{{ SC_(2.6463742187500000000000000000000000000000e+04), SC_(1.9163873046875000000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.1443133389023498433476624775447421821980e-11358) }},
{{ SC_(2.6537091796875000000000000000000000000000e+04), SC_(2.7022928125000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6786347369667304686297334751206780487481e-161408) }},
{{ SC_(2.6844490234375000000000000000000000000000e+04), SC_(4.7333200927823781967163085937500000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.2537466772511903724836947470254906080702e-371) }},
{{ SC_(2.7758564453125000000000000000000000000000e+04), SC_(1.8002581782639026641845703125000000000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.1797674336449805701918822118937086477584e-1197) }},
{{ SC_(2.8065550781250000000000000000000000000000e+04), SC_(3.5871093273162841796875000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.8703025424812756718167462853551567195382e-18379) }},
{{ SC_(2.8187794921875000000000000000000000000000e+04), SC_(3.8499225000000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1765697215713295405340318301386702175011e-128249) }},
{{ SC_(3.0225464843750000000000000000000000000000e+04), SC_(1.0163439583266153931617736816406250000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.7865351836874050543716438208639897790464e-6020) }},
{{ SC_(3.0472796875000000000000000000000000000000e+04), SC_(4.2078734375000000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.1210208144917996471463694012056455408751e-13879) }},
{{ SC_(3.1113873046875000000000000000000000000000e+04), SC_(2.2432495117187500000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.7116106044951068761431986538789695627027e-235) }},
{{ SC_(3.1202068359375000000000000000000000000000e+04), SC_(3.1443485617637634277343750000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.9727482820842737149314536539967523248373e-427) }},
{{ SC_(3.1365501953125000000000000000000000000000e+04), SC_(4.2026626586914062500000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.8362070709616634664104700616377476149626e-2349) }},
{{ SC_(3.1426568359375000000000000000000000000000e+04), SC_(3.5692617893218994140625000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.9590762697840176910525311321949367780032e-1338) }},
{{ SC_(3.2071699218750000000000000000000000000000e+04), SC_(3.7284464843750000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9897203473708097889873232608901989010493e-1792) }},
{{ SC_(3.2841035156250000000000000000000000000000e+04), SC_(2.1188200917094945907592773437500000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.2813516960320668030823600393809819459498e-2925) }},
{{ SC_(3.3019796875000000000000000000000000000000e+04), SC_(3.1799617409706115722656250000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.4878820364955488837266661260702226824229e-1298) }},
{{ SC_(3.3341328125000000000000000000000000000000e+04), SC_(4.4482726562500000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.7656340491166846092178421367375348667258e-1079) }},
{{ SC_(3.3342824218750000000000000000000000000000e+04), SC_(3.3088582031250000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2352192697155419634508714999005364639101e-7195) }},
{{ SC_(3.4105531250000000000000000000000000000000e+04), SC_(2.7232554687500000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.7627099053348591537494708159408393746551e-13023) }},
{{ SC_(3.4199625000000000000000000000000000000000e+04), SC_(2.6727525983005762100219726562500000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4927250300965925313323131562410235460980e-3046) }},
{{ SC_(3.4657742187500000000000000000000000000000e+04), SC_(1.0344102478027343750000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0930022496403192861634422334534551464420e-2852) }},
{{ SC_(3.4691167968750000000000000000000000000000e+04), SC_(1.4123919606208801269531250000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4702057525543813535833287729518822353151e-1490) }},
{{ SC_(3.5037503906250000000000000000000000000000e+04), SC_(1.1689508438110351562500000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.5354869779632963938183350589273468482305e-452) }},
{{ SC_(3.5093859375000000000000000000000000000000e+04), SC_(1.9068343937397003173828125000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0792918308889634663082673323645261735598e-31441) }},
{{ SC_(3.5247550781250000000000000000000000000000e+04), SC_(4.4111299212090671062469482421875000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.4478661683155534001384783094823726586065e-31583) }},
{{ SC_(3.5426453125000000000000000000000000000000e+04), SC_(2.5611940145608969032764434814453125000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.8080423491353945050225427532563477749306e-3157) }},
{{ SC_(3.5604664062500000000000000000000000000000e+04), SC_(4.0435057133436203002929687500000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1847569811953929303598021101580485378797e-18199) }},
{{ SC_(3.6098042968750000000000000000000000000000e+04), SC_(3.5800389014184474945068359375000000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9347743884637374345852119857112186070839e-7187) }},
{{ SC_(3.6424671875000000000000000000000000000000e+04), SC_(2.0534180104732513427734375000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0543753020354550514297172950350955868829e-1434) }},
{{ SC_(3.6495277343750000000000000000000000000000e+04), SC_(2.4849262695312500000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2126715299407873052129489016933027007577e-1050) }},
{{ SC_(3.7065789062500000000000000000000000000000e+04), SC_(2.6105607910156250000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0214041259103274934543102759191641048877e-28150) }},
{{ SC_(3.7207132812500000000000000000000000000000e+04), SC_(3.4851940917968750000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2351031494012275417720163718394759091097e+02) }},
{{ SC_(3.7353542968750000000000000000000000000000e+04), SC_(1.2228216171264648437500000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.2310612706839274556804118169981685771898e-7391) }},
{{ SC_(3.8782804687500000000000000000000000000000e+04), SC_(3.5499773437500000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.3578184462920732765587675231459933537150e-16909) }},
{{ SC_(3.8926941406250000000000000000000000000000e+04), SC_(2.3032411932945251464843750000000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0803686942369745011034579227193172886839e-3049) }},
{{ SC_(3.9031007812500000000000000000000000000000e+04), SC_(2.7533692773431539535522460937500000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0896989006271373414593783465731889491978e-33875) }},
{{ SC_(3.9044175781250000000000000000000000000000e+04), SC_(1.4351400000000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7606360851082660939955928150771874443601e-175633) }},
{{ SC_(3.9369187500000000000000000000000000000000e+04), SC_(4.9284324049949645996093750000000000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.8336230827884293925634639244721097176069e-7837) }},
{{ SC_(3.9833898437500000000000000000000000000000e+04), SC_(4.1319829225540161132812500000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4160085588062046668830639844497584370760e-7926) }},
{{ SC_(4.0020800781250000000000000000000000000000e+04), SC_(3.8980671875000000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.7943868722082223145624877257825624484106e-6679) }},
{{ SC_(4.0673257812500000000000000000000000000000e+04), SC_(3.2051979980468750000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.3446553595514207418935957589233284761921e-16318) }},
{{ SC_(4.1349457031250000000000000000000000000000e+04), SC_(3.8299476623535156250000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.2105042298483616323869933702895634358368e-3574) }},
{{ SC_(4.1562937500000000000000000000000000000000e+04), SC_(2.6003241146099753677845001220703125000000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.1765567232780621544432757161354867364105e-27244) }},
{{ SC_(4.2022343750000000000000000000000000000000e+04), SC_(4.9059000611305236816406250000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.9841284297023870508191654273877496248132e-21476) }},
{{ SC_(4.2083656250000000000000000000000000000000e+04), SC_(4.1985883712768554687500000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.4814474434449437550298629459134630616982e-565) }},
{{ SC_(4.2177980468750000000000000000000000000000e+04), SC_(2.6123690605163574218750000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5107513823797874886931070367498394736178e-8383) }},
{{ SC_(4.2524507812500000000000000000000000000000e+04), SC_(2.8020951151847839355468750000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.8404455938146109148699631562370048853646e-3783) }},
{{ SC_(4.2581589843750000000000000000000000000000e+04), SC_(3.7374455132521688938140869140625000000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.7325086168314766262809333410140456279219e-36959) }},
{{ SC_(4.3662406250000000000000000000000000000000e+04), SC_(4.6618557535111904144287109375000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.2002318561537572214968285579782084270302e-22319) }},
{{ SC_(4.4090558593750000000000000000000000000000e+04), SC_(1.0735684554674662649631500244140625000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.9816352584909401881093978873754081470069e-22540) }},
{{ SC_(4.4669996093750000000000000000000000000000e+04), SC_(4.6779303374933078885078430175781250000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.8830375507284289982538953521592257361417e-617) }},
{{ SC_(4.5414382812500000000000000000000000000000e+04), SC_(4.8692214965820312500000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.9140230457051094357472510183257224853277e-1835) }},
{{ SC_(4.5461753906250000000000000000000000000000e+04), SC_(4.5912575000000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.1146062042302947734427454128743354684284e-30367) }},
{{ SC_(4.5960199218750000000000000000000000000000e+04), SC_(4.9682075500488281250000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2647200831436501229948470343814113806589e-1691) }},
{{ SC_(4.6422796875000000000000000000000000000000e+04), SC_(1.1781878769397735595703125000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.9058550200747503031227710680967569527509e-30425) }},
{{ SC_(4.6983234375000000000000000000000000000000e+04), SC_(1.4450610615313053131103515625000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.5885616716157337090714203852283286367567e-647) }},
{{ SC_(4.7575929687500000000000000000000000000000e+04), SC_(4.2762565612792968750000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0596316221540572631240524840562772666182e-31036) }},
{{ SC_(4.7586441406250000000000000000000000000000e+04), SC_(4.4960131835937500000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2987655600147774729920418493917406250593e-2970) }},
{{ SC_(4.7823167968750000000000000000000000000000e+04), SC_(2.5855817871093750000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.8022885751353874053998956296778935794115e-38569) }},
{{ SC_(4.8035773437500000000000000000000000000000e+04), SC_(4.9997663154499605298042297363281250000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1662659916899623349163209625578678116219e-3765) }},
{{ SC_(4.8295363281250000000000000000000000000000e+04), SC_(2.3451945744454860687255859375000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1866020484005898298214797765371321589049e-2077) }},
{{ SC_(4.8850355468750000000000000000000000000000e+04), SC_(2.8955546875000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7280447883075431813295501305416168634241e-45) }},
{{ SC_(4.9373980468750000000000000000000000000000e+04), SC_(2.2231106567382812500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.2435289095008918980754834138688677019519e-393) }},
{{ SC_(4.9444171875000000000000000000000000000000e+04), SC_(4.6737580299377441406250000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.3090325017378544923079770981825772503827e-4382) }},
{{ SC_(4.9532089843750000000000000000000000000000e+04), SC_(1.8997972412109375000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7524484882650965067439903255839977625504e-29136) }},
{{ SC_(4.9565796875000000000000000000000000000000e+04), SC_(2.7709791183471679687500000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.8132492793433262442151676154447245094003e-44307) }},
{{ SC_(4.9846242187500000000000000000000000000000e+04), SC_(4.9663238281250000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.0082691678303071863615581641196217883273e-45561) }},
{{ SC_(4.9880132812500000000000000000000000000000e+04), SC_(4.6944446512497961521148681640625000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.0580014271161210991749087931187622309894e-32694) }},
{{ SC_(1.0392089843750000000000000000000000000000e+05), SC_(1.1121242096123751252889633178710937500000e-05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.1052893575298684465074285116014156616411e-68113) }},
{{ SC_(1.1276905468750000000000000000000000000000e+05), SC_(4.2152389526367187500000000000000000000000e+02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8293261036117941692399093993120989347304e-4070) }},
{{ SC_(1.1691910937500000000000000000000000000000e+05), SC_(2.3419723437500000000000000000000000000000e+05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4813061910479445307886160545831626876542e-95406) }},
{{ SC_(1.1706393750000000000000000000000000000000e+05), SC_(4.7616380470572039484977722167968750000000e-05), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3759907043495404478831566569854216969115e-9170) }},
{{ SC_(1.1766623437500000000000000000000000000000e+05), SC_(3.7912214174866676330566406250000000000000e-03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.8512186893199147619065070323951051089913e-5058) }},
{{ SC_(1.1902186718750000000000000000000000000000e+05), SC_(1.7245032958984375000000000000000000000000e+03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.7977149814380328114317135301527709449103e-6742) }},
{{ SC_(1.2184664843750000000000000000000000000000e+05), SC_(1.0254781693220138549804687500000000000000e-02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3090525770137023041672828439279424640415e-1674) }},
{{ SC_(1.3963585937500000000000000000000000000000e+05), SC_(3.5944364499300718307495117187500000000000e-03), SC_(8.3502507209777832031250000000000000000000e-01), SC_(7.5450778703295956381670290008083465118324e-10936) }},
{{ SC_(1.3963810937500000000000000000000000000000e+05), SC_(3.6490429192781448364257812500000000000000e-03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7179971262207765394298279924902628313482e-91519) }},
{{ SC_(1.4061356250000000000000000000000000000000e+05), SC_(4.4855728745460510253906250000000000000000e-02), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4740682030443460608422277336171749452671e-6042) }},
{{ SC_(1.4315556250000000000000000000000000000000e+05), SC_(3.8673237431794404983520507812500000000000e-03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2697400923345992591953500858075177797263e-128261) }},
{{ SC_(1.4990960937500000000000000000000000000000e+05), SC_(2.0033237934112548828125000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.1004263595545856058237459235337329604150e-29824) }},
{{ SC_(1.5501864062500000000000000000000000000000e+05), SC_(2.7750885486602783203125000000000000000000e-01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4507629100490726085390920261973979644029e-12137) }},
{{ SC_(1.5510515625000000000000000000000000000000e+05), SC_(2.7467107421875000000000000000000000000000e+04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.5177937026037249257365661166909873634364e-9226) }},
{{ SC_(1.5544068750000000000000000000000000000000e+05), SC_(2.5353656250000000000000000000000000000000e+04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.9590742387967849551382135192018614273508e-180) }},
{{ SC_(1.7084950000000000000000000000000000000000e+05), SC_(4.6143750660121440887451171875000000000000e-04), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.4831590691247992534808154280818401621706e-13381) }},
{{ SC_(1.7159300000000000000000000000000000000000e+05), SC_(3.9015084505081176757812500000000000000000e-02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.0750433948859296286718982336660594601488e-148919) }},
{{ SC_(1.7289100000000000000000000000000000000000e+05), SC_(4.1235238313674926757812500000000000000000e-03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.9889936833435340300560567260702430932487e-150047) }},
{{ SC_(1.7568273437500000000000000000000000000000e+05), SC_(3.4237509375000000000000000000000000000000e+05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9936110088866658816992656215813970800827e-226556) }},
{{ SC_(1.7729814062500000000000000000000000000000e+05), SC_(1.8085639458149671554565429687500000000000e-03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4185427385967103066968451402297781720063e-35287) }},
{{ SC_(1.8405826562500000000000000000000000000000e+05), SC_(4.8123925924301147460937500000000000000000e-02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.6487631238316184143264587648003746292260e-94076) }},
{{ SC_(1.8971082812500000000000000000000000000000e+05), SC_(4.4683465966954827308654785156250000000000e-04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.4807988655162801356916876278593734459248e-169973) }},
{{ SC_(1.9215323437500000000000000000000000000000e+05), SC_(4.4600839843750000000000000000000000000000e+03), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0326322436216600518977941406503376614362e-157793) }},
{{ SC_(1.9457798437500000000000000000000000000000e+05), SC_(3.6247042589820921421051025390625000000000e-04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.5003925886575448653462812251591978601936e-17317) }},
{{ SC_(1.9636200000000000000000000000000000000000e+05), SC_(2.5092312011718750000000000000000000000000e+03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.3317403007360255760444636782163898816230e-628) }},
{{ SC_(2.0762190625000000000000000000000000000000e+05), SC_(4.2250819387845695018768310546875000000000e-04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.3058592603981858772253638192757583386999e-180189) }},
{{ SC_(2.1260060937500000000000000000000000000000e+05), SC_(3.7894721679687500000000000000000000000000e+03), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.4311410080572038440484800472743243085532e-182412) }},
{{ SC_(2.1260309375000000000000000000000000000000e+05), SC_(2.0133156250000000000000000000000000000000e+04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.0529646968092369783265405835067540930701e-111766) }},
{{ SC_(2.2477603125000000000000000000000000000000e+05), SC_(4.1573543101549148559570312500000000000000e-02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.0828302184223209266666421306393115246853e-201387) }},
{{ SC_(2.2898417187500000000000000000000000000000e+05), SC_(4.6157588958740234375000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9767422294675927019227614605667988383541e-198537) }},
{{ SC_(2.3110198437500000000000000000000000000000e+05), SC_(1.5526193237304687500000000000000000000000e+02), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.7628680060942044280597674643545031361091e-117584) }},
{{ SC_(2.3216943750000000000000000000000000000000e+05), SC_(1.6358287811279296875000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.8704704048670574007505778084210093170938e-20595) }},
{{ SC_(2.3558225000000000000000000000000000000000e+05), SC_(1.1084310710430145263671875000000000000000e-02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.3871281296186473978535604385415439710637e-154399) }},
{{ SC_(2.3731515625000000000000000000000000000000e+05), SC_(3.7124271392822265625000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7252814421072380885698717762315323003199e-155514) }},
{{ SC_(2.3951392187500000000000000000000000000000e+05), SC_(3.2365407714843750000000000000000000000000e+03), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3853065905260701832770532417592284367097e-6145) }},
{{ SC_(2.4125671875000000000000000000000000000000e+05), SC_(4.1778706250000000000000000000000000000000e+05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.3443141373957685805290311768852129790028e-2174) }},
{{ SC_(2.4274759375000000000000000000000000000000e+05), SC_(3.0763369750976562500000000000000000000000e+02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.6073612897739928738513714642047464436211e-8852) }},
{{ SC_(2.4425464062500000000000000000000000000000e+05), SC_(1.7745054244995117187500000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1817916807905466164651567553027727980928e-10431) }},
{{ SC_(2.4646273437500000000000000000000000000000e+05), SC_(4.3952445312500000000000000000000000000000e+04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.6684608669475716399900194652850653824194e-2783) }},
{{ SC_(2.5127443750000000000000000000000000000000e+05), SC_(1.3039079931331798434257507324218750000000e-05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.6455255598564352119034356890731374385378e-10801) }},
{{ SC_(2.5600195312500000000000000000000000000000e+05), SC_(3.1027224659919738769531250000000000000000e-01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1064864210573739039991271607080537766145e-10998) }},
{{ SC_(2.5634189062500000000000000000000000000000e+05), SC_(4.5557327568531036376953125000000000000000e-02), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.0420102251032950762598322898193395632324e-10087) }},
{{ SC_(2.5931289062500000000000000000000000000000e+05), SC_(4.0972061157226562500000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.2003354155446749865609562757053675357071e-10185) }},
{{ SC_(2.6556028125000000000000000000000000000000e+05), SC_(1.4267849922180175781250000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.2121137909802673168020755152717445673485e-3600) }},
{{ SC_(2.7268846875000000000000000000000000000000e+05), SC_(4.2792043089866638183593750000000000000000e-01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6722207648429846022800877434402773618781e-236652) }},
{{ SC_(2.7977743750000000000000000000000000000000e+05), SC_(1.1091981250000000000000000000000000000000e+05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.4811695332211663757752325514514085009559e-2655) }},
{{ SC_(2.8053621875000000000000000000000000000000e+05), SC_(1.9981970214843750000000000000000000000000e+03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.2499021891934993297934989140985754850832e-7997) }},
{{ SC_(2.9099687500000000000000000000000000000000e+05), SC_(4.6665043919347226619720458984375000000000e-04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2148520881715984807450117310219240154352e-148736) }},
{{ SC_(2.9426065625000000000000000000000000000000e+05), SC_(3.9324718713760375976562500000000000000000e-01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.5647017312594363052948749732809820033871e-58559) }},
{{ SC_(2.9583775000000000000000000000000000000000e+05), SC_(4.1404437500000000000000000000000000000000e+05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.6102181784080020656814140536821298830761e-73536) }},
{{ SC_(2.9590553125000000000000000000000000000000e+05), SC_(4.0032281540334224700927734375000000000000e-03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3905416043695134491388199822931816943312e-151244) }},
{{ SC_(2.9693803125000000000000000000000000000000e+05), SC_(2.2098767089843750000000000000000000000000e+02), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.1187508968765575242818570041991962086027e-265264) }},
{{ SC_(3.0051318750000000000000000000000000000000e+05), SC_(3.7814271450042724609375000000000000000000e-01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.5947488616754083183212255985879936111289e-269241) }},
{{ SC_(3.0151231250000000000000000000000000000000e+05), SC_(2.9077215625000000000000000000000000000000e+05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9555140143076650666491826147658778909763e-109044) }},
{{ SC_(3.0406100000000000000000000000000000000000e+05), SC_(1.5454678796231746673583984375000000000000e-02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.9135575627576232495757475114445820263416e-60513) }},
{{ SC_(3.1972340625000000000000000000000000000000e+05), SC_(2.0909183502197265625000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.9261771854398876846289572543297923548992e-63541) }},
{{ SC_(3.2090462500000000000000000000000000000000e+05), SC_(2.9053398132324218750000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1457800226432400358263634799394812097033e-210189) }},
{{ SC_(3.2291806250000000000000000000000000000000e+05), SC_(3.5500845406204462051391601562500000000000e-03), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0400522507996764723159519048659119029189e-12707) }},
{{ SC_(3.3528375000000000000000000000000000000000e+05), SC_(2.1810169921875000000000000000000000000000e+04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2609420568838031349148991461901435118853e-1123) }},
{{ SC_(3.3624346875000000000000000000000000000000e+05), SC_(3.1280566406250000000000000000000000000000e+03), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6951763276387895470750442720961047411553e-60555) }},
{{ SC_(3.4733496875000000000000000000000000000000e+05), SC_(4.0688047409057617187500000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5773800296319771717939082301213466391440e-301415) }},
{{ SC_(3.4778862500000000000000000000000000000000e+05), SC_(3.7863533020019531250000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2658129943843678654890047682174589951278e-27094) }},
{{ SC_(3.4948656250000000000000000000000000000000e+05), SC_(4.2981380829587578773498535156250000000000e-04), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4568865802966995648080584295345707248478e-69555) }},
{{ SC_(3.4982918750000000000000000000000000000000e+05), SC_(4.5566977539062500000000000000000000000000e+03), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.2718621574771407558474729287511232269318e-168949) }},
{{ SC_(3.5156959375000000000000000000000000000000e+05), SC_(1.5229020267724990844726562500000000000000e-02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1229148216193076578476367991353173318975e-27529) }},
{{ SC_(3.5859096875000000000000000000000000000000e+05), SC_(1.7338650226593017578125000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1218461560361771380050811598333666120466e-28069) }},
{{ SC_(3.6417518750000000000000000000000000000000e+05), SC_(2.2936718750000000000000000000000000000000e+03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.2752040498627287670975733254124655713561e-28035) }},
{{ SC_(3.6506153125000000000000000000000000000000e+05), SC_(1.3540737915039062500000000000000000000000e+02), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.2818845588214551848553428837353445558035e-4693) }},
{{ SC_(3.6684812500000000000000000000000000000000e+05), SC_(4.8962287500000000000000000000000000000000e+05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0474435542270553096564047220247758835499e-488826) }},
{{ SC_(3.6921246875000000000000000000000000000000e+05), SC_(4.3601836659945547580718994140625000000000e-04), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1642832842365945953394356255791149971473e-241980) }},
{{ SC_(3.7751506250000000000000000000000000000000e+05), SC_(2.5923203793354332447052001953125000000000e-05), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3331733429610889369137543330428131430335e-327633) }},
{{ SC_(3.7789728125000000000000000000000000000000e+05), SC_(2.1777330017089843750000000000000000000000e+02), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1080955142387199883537542126778234953331e-327173) }},
{{ SC_(3.8173584375000000000000000000000000000000e+05), SC_(1.5541230823146179318428039550781250000000e-05), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3761725946964607440174407322196290176164e-15024) }},
{{ SC_(3.8445140625000000000000000000000000000000e+05), SC_(2.8214196777343750000000000000000000000000e+03), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.2631463724764989846962347910653707538372e-245018) }},
{{ SC_(3.8542959375000000000000000000000000000000e+05), SC_(3.3841388225555419921875000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9552988637326071173881258419855350272409e-345304) }},
{{ SC_(3.8601800000000000000000000000000000000000e+05), SC_(1.4093704101562500000000000000000000000000e+04), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.9779219901756648785217634542263380874875e-320188) }},
{{ SC_(3.9180521875000000000000000000000000000000e+05), SC_(3.0559775041183456778526306152343750000000e-05), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.2168322479327038528879855118823377798408e-5385) }},
{{ SC_(3.9223412500000000000000000000000000000000e+05), SC_(2.3254187107086181640625000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3938034864992089699907864108617942177935e-34889) }},
{{ SC_(3.9242034375000000000000000000000000000000e+05), SC_(2.6721417968750000000000000000000000000000e+04), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.5676717781058050126870538298254990651863e-161675) }},
{{ SC_(3.9562887500000000000000000000000000000000e+05), SC_(1.6902102661132812500000000000000000000000e+02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.1717973727978876961796987964561717238285e-34683) }},
{{ SC_(3.9992887500000000000000000000000000000000e+05), SC_(2.3772995471954345703125000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.2057562216012166629783193020436188535653e-5482) }},
{{ SC_(4.0260381250000000000000000000000000000000e+05), SC_(1.5565924644470214843750000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.6259652511233306264430270018263287558222e-15781) }},
{{ SC_(4.0676865625000000000000000000000000000000e+05), SC_(4.2969666537828743457794189453125000000000e-04), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.4027167228817169540188987269931617788441e-16008) }},
{{ SC_(4.0838165625000000000000000000000000000000e+05), SC_(4.5634595153387635946273803710937500000000e-05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.8739534466875695274748457054119137135720e-36342) }},
{{ SC_(4.0899800000000000000000000000000000000000e+05), SC_(4.2365207336843013763427734375000000000000e-03), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.8621698028407938275799496189156900442544e-5619) }},
{{ SC_(4.1314884375000000000000000000000000000000e+05), SC_(4.7996323701227083802223205566406250000000e-05), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.4330297967375352494364320581851835024329e-370162) }},
{{ SC_(4.2270384375000000000000000000000000000000e+05), SC_(1.5069125000000000000000000000000000000000e+04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3502932797576535637299942435308334327045e-30) }},
{{ SC_(4.2464103125000000000000000000000000000000e+05), SC_(2.8405126929283142089843750000000000000000e-01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.6627236905223392654221185894196365954212e-217040) }},
{{ SC_(4.3185734375000000000000000000000000000000e+05), SC_(2.1142301557119935750961303710937500000000e-04), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8359276506887620338175225538921196076932e-18559) }},
{{ SC_(4.3326081250000000000000000000000000000000e+05), SC_(3.3808853626251220703125000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.8199987126866034636196944332461795584860e-18600) }},
{{ SC_(4.3408821875000000000000000000000000000000e+05), SC_(2.1814994812011718750000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.7081694612554075278501949153964465690510e-388816) }},
{{ SC_(4.3468912500000000000000000000000000000000e+05), SC_(3.9291476562500000000000000000000000000000e+04), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.5354553586140894479363470840471968435546e-8618) }},
{{ SC_(4.3512125000000000000000000000000000000000e+05), SC_(3.9758978271484375000000000000000000000000e+02), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.4567391819704301814533944570128322792455e-85385) }},
{{ SC_(4.3728531250000000000000000000000000000000e+05), SC_(2.7882666472578421235084533691406250000000e-05), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.8016541234527082687159056828353597403165e-223508) }},
{{ SC_(4.4247293750000000000000000000000000000000e+05), SC_(4.9476660156250000000000000000000000000000e+04), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.0338496108073627243413602003953433479211e-317409) }},
{{ SC_(4.5081950000000000000000000000000000000000e+05), SC_(4.9921646875000000000000000000000000000000e+05), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.4887320606817642945236562656310813271966e-64183) }},
{{ SC_(4.5777912500000000000000000000000000000000e+05), SC_(3.2678192853927612304687500000000000000000e-01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.0691363661798290444619654536358691206231e-40732) }},
{{ SC_(4.5835662500000000000000000000000000000000e+05), SC_(3.2751315739005804061889648437500000000000e-03), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.5794424223227775374033892050709283732287e-40787) }},
{{ SC_(4.6254571875000000000000000000000000000000e+05), SC_(1.8356585875153541564941406250000000000000e-02), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.1540824524604362021234247741536946897226e-41159) }},
{{ SC_(4.6699753125000000000000000000000000000000e+05), SC_(3.5636156797409057617187500000000000000000e-01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.5531500314299078005956373229540790320992e-6412) }},
{{ SC_(4.6893281250000000000000000000000000000000e+05), SC_(1.8236685718875378370285034179687500000000e-05), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4926576885237780817624361227813481238887e-93327) }},
{{ SC_(4.7094250000000000000000000000000000000000e+05), SC_(3.2636207342147827148437500000000000000000e-01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9675089255454131024578367100624649154215e-18528) }},
{{ SC_(4.7379131250000000000000000000000000000000e+05), SC_(3.7331905332393944263458251953125000000000e-04), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.9570756620576155974501329651784412637437e-6510) }},
{{ SC_(4.7441090625000000000000000000000000000000e+05), SC_(1.5368586778640747070312500000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0797928248481225481903394228790187937258e-242470) }},
{{ SC_(4.8166981250000000000000000000000000000000e+05), SC_(3.6035894775390625000000000000000000000000e+02), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.2720535049390278902859836369355457233839e-36713) }},
{{ SC_(4.8541212500000000000000000000000000000000e+05), SC_(4.8372521875000000000000000000000000000000e+05), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0980719673741476146110997875792484676278e-105645) }},
{{ SC_(4.8909359375000000000000000000000000000000e+05), SC_(1.0160869598388671875000000000000000000000e+02), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.7803399900642206888247563684029691213416e-320138) }},
{{ SC_(4.8918334375000000000000000000000000000000e+05), SC_(1.1880832812500000000000000000000000000000e+05), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.2830847727265375161685101294076503987376e-12475) }},
{{ SC_(4.9165162500000000000000000000000000000000e+05), SC_(3.2955524444580078125000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.7287614727482405026331169412190383065552e-251144) }},
{{ SC_(4.9902409375000000000000000000000000000000e+05), SC_(3.6176475882530212402343750000000000000000e-01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2665423564095430817601142466738879095802e-327052) }}
}};

