.\" dpkg manual page - dpkg-scansources(1)
.\"
.\" Copyright © 2005 Roderick Schertler <roderick@argon.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2009 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-scansources 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-scansources \- create Sources index files
.
.SH SYNOPSIS
.B dpkg\-scansources
.RI [ option "...] " binary-dir
.RI [ override-file
.RI [ path-prefix ]]
.B >
.I Sources
.
.SH DESCRIPTION
\fBdpkg\-scansources\fR scans the given \fIbinary-dir\fR for \fI.dsc\fR files.
These are used to create a Debian source index, which is output to
stdout.
.PP
The \fIoverride-file\fR, if given, is used to set priorities in the resulting
index records and to override the maintainer field given in the \fI.dsc\fR
files.
The file can be compressed (since dpkg 1.15.5).
See
.BR deb\-override (5)
for the format of this file. Note: Since
the override file is indexed by binary, not source packages, there's a bit
of a problem here. The current implementation uses the highest priority of
all the binary packages produced by a \fI.dsc\fR file for the priority of the
source package, and the override entry for the first binary package listed
in the \fI.dsc\fR file to modify maintainer information. This might change.
.PP
The \fIpath-prefix\fR, if given, is prepended to the directory field in the
generated source index. You generally use this to make the directory
fields contain the path from the top of the Debian archive hierarchy.
.
.PP
.B Note:
If you want to access the generated Sources file with
.BR apt (8)
you will probably need to compress the file with
.BR gzip (1)
(generating a Sources.gz file). apt ignores uncompressed Sources files
except on local access (i.e.
.B file://
sources).
.
.SH OPTIONS
.IP "\fB\-n\fR, \fB\-\-no\-sort\fR" 4
Don't sort the index records. Normally they are sorted by source package
name.
.TP
.IP "\fB\-e\fR, \fB\-\-extra\-override\fR \fIfile\fP" 4
Scan \fIfile\fP to find supplementary overrides (since dpkg 1.15.4;
the file can be compressed since dpkg 1.15.5).
See
.BR deb\-extra\-override (5)
for more information on its format.
.IP "\fB\-s\fR, \fB\-\-source\-override\fR \fIfile\fR" 4
Use \fIfile\fR as the source override file (the file can be compressed
since dpkg 1.15.5).
The default is the name of the override file you specified with \fI.src\fR
appended.
.sp
The source override file is in a different format from the binary override
file. It contains only two whitespace separated fields, the first is the
source package name and the second is the section. Blank lines and comment
lines are ignored in the normal manner. If a package appears in both files
the source override takes precedence for setting the section.
.IP "\fB\-\-debug\fR" 4
Turn debugging on.
.IP "\fB\-\-help\fR" 4
Show the usage message and exit.
.IP "\fB\-\-version\fR" 4
Show the version and exit.
.
.SH ENVIRONMENT
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH SEE ALSO
.BR deb\-override (5),
.BR deb\-extra\-override (5),
.BR dpkg\-scanpackages (1).
