/*
 * Blackfin testcase for testing illegal/legal 64-bit opcodes (group 0)
 * from userspace.  we track all instructions which cause some sort of
 * exception when run from userspace, this is normally EXCAUSE :
 *  - 0x22 : illegal instruction combination
 * and walk every instruction from 0xC0000000 to 0xffffffff
 * (and have 0x8000000 set)
 */

# Don't want to enable for normal `make check` as it takes way too long in
# the sim -- executes over 3 billion insns, and even at 10 MIPS, that's 10+
# minutes.  Useful for directed testing, but that's about it.
# mach: bfin
# sim: --environment operating
# xfail: "too many invalid insns are decoded as valid" *-*

#include "test.h"
	.include "testutils.inc"

#define SE_ALL_BITS 32
#include "se_allopcodes.h"

.macro se_all_load_insn
	R2 = [P5];
	R0 = R2 << 16;
	R1 = R2 >> 16;
	R0 = R0 | R1;
.endm

.macro se_all_next_insn
	/* increment, and go again. */
	R0 = R2;

	/* Is this the last insn we'll execute ? */
	R1 = -1 (x);
	CC = R1 == R0;
	IF CC JUMP pass_lvl;

	/* cut across the opcode space in an efficient manner:
	 * increment the high 16bits first since the low 16bits encode
	 * the type of insn ... */
	imm32 R1, 0x10000;
	R0 = R1 + R0;
	CC = R1 < R0 (IU);
	IF CC jump 1f (bp);

	R0 += 1;
	/* skip any 16bit insn chunks */
	R1 = R0;
	R1.L = 0xC800;
	CC = R0 < R1 (IU);
	IF CC R0 = R1;
1:

	/* force parallel insns */
	BITSET (R0, 11);

	/* skip linkage insns */
	R1 = R0;
	R2 = R0;
	R1.L = 0xe800;
	R2.L = 0xe802;
	CC = R0 == R1;
	IF CC R0 = R2;

	[P5] = R0;
.endm

.macro se_all_insn_init
	.dw 0xc800;	/* 32bit */
	.dw 0x0000;	/* insn */
	.dw 0x0000;	/* || group1 */
	.dw 0x0000;	/* || group2; */
.endm
.macro se_all_insn_table
	/* this table must be sorted, and end with zero */
	/* start		end			SEQSTAT */
	.dw 0x1a00, 0xc800,	0x1fff, 0xc800,		0x21, 0
	.dw 0x3a00, 0xc800,	0x3fff, 0xc800,		0x21, 0
	.dw 0x5a00, 0xc800,	0x5fff, 0xc800,		0x21, 0
	.dw 0x7a00, 0xc800,	0x7fff, 0xc800,		0x21, 0
	.dw 0x9a00, 0xc800,	0x9fff, 0xc800,		0x21, 0
	.dw 0xba00, 0xc800,	0xbfff, 0xc800,		0x21, 0
	.dw 0xda00, 0xc800,	0xdfff, 0xc800,		0x21, 0
	.dw 0xfa00, 0xc800,	0xffff, 0xc800,		0x21, 0
	.dw 0x1a00, 0xc801,	0x1fff, 0xc801,		0x21, 0
	.dw 0x3a00, 0xc801,	0x3fff, 0xc801,		0x21, 0
	.dw 0x5a00, 0xc801,	0x5fff, 0xc801,		0x21, 0
	.dw 0x7a00, 0xc801,	0x7fff, 0xc801,		0x21, 0
	.dw 0x9a00, 0xc801,	0x9fff, 0xc801,		0x21, 0
	.dw 0xba00, 0xc801,	0xbfff, 0xc801,		0x21, 0
	.dw 0xda00, 0xc801,	0xdfff, 0xc801,		0x21, 0
	.dw 0xfa00, 0xc801,	0xffff, 0xc801,		0x21, 0
	.dw 0x1a00, 0xc802,	0x1fff, 0xc802,		0x21, 0
	.dw 0x3a00, 0xc802,	0x3fff, 0xc802,		0x21, 0
	.dw 0x5a00, 0xc802,	0x5fff, 0xc802,		0x21, 0
	.dw 0x7a00, 0xc802,	0x7fff, 0xc802,		0x21, 0
	.dw 0x9a00, 0xc802,	0x9fff, 0xc802,		0x21, 0
	.dw 0xba00, 0xc802,	0xbfff, 0xc802,		0x21, 0
	.dw 0xda00, 0xc802,	0xdfff, 0xc802,		0x21, 0
	.dw 0xfa00, 0xc802,	0xffff, 0xc802,		0x21, 0
	.dw 0x1a00, 0xc803,	0x1fff, 0xc803,		0x21, 0
	.dw 0x3a00, 0xc803,	0xffff, 0xc803,		0x21, 0
	.dw 0x1a00, 0xc804,	0x1fff, 0xc804,		0x21, 0
	.dw 0x3a00, 0xc804,	0x3fff, 0xc804,		0x21, 0
	.dw 0x5a00, 0xc804,	0x5fff, 0xc804,		0x21, 0
	.dw 0x7a00, 0xc804,	0x7fff, 0xc804,		0x21, 0
	.dw 0x9a00, 0xc804,	0x9fff, 0xc804,		0x21, 0
	.dw 0xba00, 0xc804,	0xbfff, 0xc804,		0x21, 0
	.dw 0xda00, 0xc804,	0xdfff, 0xc804,		0x21, 0
	.dw 0xfa00, 0xc804,	0xffff, 0xc804,		0x21, 0
	.dw 0x1a00, 0xc805,	0x1fff, 0xc805,		0x21, 0
	.dw 0x3a00, 0xc805,	0x3fff, 0xc805,		0x21, 0
	.dw 0x5a00, 0xc805,	0x5fff, 0xc805,		0x21, 0
	.dw 0x7a00, 0xc805,	0x7fff, 0xc805,		0x21, 0
	.dw 0x9a00, 0xc805,	0x9fff, 0xc805,		0x21, 0
	.dw 0xba00, 0xc805,	0xbfff, 0xc805,		0x21, 0
	.dw 0xda00, 0xc805,	0xdfff, 0xc805,		0x21, 0
	.dw 0xfa00, 0xc805,	0xffff, 0xc805,		0x21, 0
	.dw 0x1a00, 0xc806,	0x1fff, 0xc806,		0x21, 0
	.dw 0x3a00, 0xc806,	0x3fff, 0xc806,		0x21, 0
	.dw 0x5a00, 0xc806,	0x5fff, 0xc806,		0x21, 0
	.dw 0x7a00, 0xc806,	0x7fff, 0xc806,		0x21, 0
	.dw 0x9a00, 0xc806,	0x9fff, 0xc806,		0x21, 0
	.dw 0xba00, 0xc806,	0xbfff, 0xc806,		0x21, 0
	.dw 0xda00, 0xc806,	0xdfff, 0xc806,		0x21, 0
	.dw 0xfa00, 0xc806,	0xffff, 0xc806,		0x21, 0
	.dw 0x1a00, 0xc807,	0x1fff, 0xc807,		0x21, 0
	.dw 0x3a00, 0xc807,	0x1fff, 0xc808,		0x21, 0
	.dw 0x2040, 0xc808,	0x207f, 0xc808,		0x21, 0
	.dw 0x20c0, 0xc808,	0x20ff, 0xc808,		0x21, 0
	.dw 0x2140, 0xc808,	0x217f, 0xc808,		0x21, 0
	.dw 0x21c0, 0xc808,	0x21ff, 0xc808,		0x21, 0
	.dw 0x2240, 0xc808,	0x227f, 0xc808,		0x21, 0
	.dw 0x22c0, 0xc808,	0x22ff, 0xc808,		0x21, 0
	.dw 0x2340, 0xc808,	0x237f, 0xc808,		0x21, 0
	.dw 0x23c0, 0xc808,	0x23ff, 0xc808,		0x21, 0
	.dw 0x2440, 0xc808,	0x247f, 0xc808,		0x21, 0
	.dw 0x24c0, 0xc808,	0x24ff, 0xc808,		0x21, 0
	.dw 0x2540, 0xc808,	0x257f, 0xc808,		0x21, 0
	.dw 0x25c0, 0xc808,	0x25ff, 0xc808,		0x21, 0
	.dw 0x2640, 0xc808,	0x267f, 0xc808,		0x21, 0
	.dw 0x26c0, 0xc808,	0x26ff, 0xc808,		0x21, 0
	.dw 0x2740, 0xc808,	0x277f, 0xc808,		0x21, 0
	.dw 0x27c0, 0xc808,	0x27ff, 0xc808,		0x21, 0
	.dw 0x2840, 0xc808,	0x287f, 0xc808,		0x21, 0
	.dw 0x28c0, 0xc808,	0x28ff, 0xc808,		0x21, 0
	.dw 0x2940, 0xc808,	0x297f, 0xc808,		0x21, 0
	.dw 0x29c0, 0xc808,	0x29ff, 0xc808,		0x21, 0
	.dw 0x2a40, 0xc808,	0x2a7f, 0xc808,		0x21, 0
	.dw 0x2ac0, 0xc808,	0x2aff, 0xc808,		0x21, 0
	.dw 0x2b40, 0xc808,	0x2b7f, 0xc808,		0x21, 0
	.dw 0x2bc0, 0xc808,	0x2bff, 0xc808,		0x21, 0
	.dw 0x2c40, 0xc808,	0x2c7f, 0xc808,		0x21, 0
	.dw 0x2cc0, 0xc808,	0x2cff, 0xc808,		0x21, 0
	.dw 0x2d40, 0xc808,	0x2d7f, 0xc808,		0x21, 0
	.dw 0x2dc0, 0xc808,	0x2dff, 0xc808,		0x21, 0
	.dw 0x2e40, 0xc808,	0x2e7f, 0xc808,		0x21, 0
	.dw 0x2ec0, 0xc808,	0x2eff, 0xc808,		0x21, 0
	.dw 0x2f40, 0xc808,	0x2f7f, 0xc808,		0x21, 0
	.dw 0x2fc0, 0xc808,	0x2fff, 0xc808,		0x21, 0
	.dw 0x3040, 0xc808,	0x307f, 0xc808,		0x21, 0
	.dw 0x30c0, 0xc808,	0x30ff, 0xc808,		0x21, 0
	.dw 0x3140, 0xc808,	0x317f, 0xc808,		0x21, 0
	.dw 0x31c0, 0xc808,	0x31ff, 0xc808,		0x21, 0
	.dw 0x3240, 0xc808,	0x327f, 0xc808,		0x21, 0
	.dw 0x32c0, 0xc808,	0x32ff, 0xc808,		0x21, 0
	.dw 0x3340, 0xc808,	0x337f, 0xc808,		0x21, 0
	.dw 0x33c0, 0xc808,	0x33ff, 0xc808,		0x21, 0
	.dw 0x3440, 0xc808,	0x347f, 0xc808,		0x21, 0
	.dw 0x34c0, 0xc808,	0x34ff, 0xc808,		0x21, 0
	.dw 0x3540, 0xc808,	0x357f, 0xc808,		0x21, 0
	.dw 0x35c0, 0xc808,	0x35ff, 0xc808,		0x21, 0
	.dw 0x3640, 0xc808,	0x367f, 0xc808,		0x21, 0
	.dw 0x36c0, 0xc808,	0x36ff, 0xc808,		0x21, 0
	.dw 0x3740, 0xc808,	0x377f, 0xc808,		0x21, 0
	.dw 0x37c0, 0xc808,	0x37ff, 0xc808,		0x21, 0
	.dw 0x3840, 0xc808,	0x387f, 0xc808,		0x21, 0
	.dw 0x38c0, 0xc808,	0x38ff, 0xc808,		0x21, 0
	.dw 0x3940, 0xc808,	0x397f, 0xc808,		0x21, 0
	.dw 0x39c0, 0xc808,	0x5fff, 0xc808,		0x21, 0
	.dw 0x6040, 0xc808,	0x607f, 0xc808,		0x21, 0
	.dw 0x60c0, 0xc808,	0x60ff, 0xc808,		0x21, 0
	.dw 0x6140, 0xc808,	0x617f, 0xc808,		0x21, 0
	.dw 0x61c0, 0xc808,	0x61ff, 0xc808,		0x21, 0
	.dw 0x6240, 0xc808,	0x627f, 0xc808,		0x21, 0
	.dw 0x62c0, 0xc808,	0x62ff, 0xc808,		0x21, 0
	.dw 0x6340, 0xc808,	0x637f, 0xc808,		0x21, 0
	.dw 0x63c0, 0xc808,	0x63ff, 0xc808,		0x21, 0
	.dw 0x6440, 0xc808,	0x647f, 0xc808,		0x21, 0
	.dw 0x64c0, 0xc808,	0x64ff, 0xc808,		0x21, 0
	.dw 0x6540, 0xc808,	0x657f, 0xc808,		0x21, 0
	.dw 0x65c0, 0xc808,	0x65ff, 0xc808,		0x21, 0
	.dw 0x6640, 0xc808,	0x667f, 0xc808,		0x21, 0
	.dw 0x66c0, 0xc808,	0x66ff, 0xc808,		0x21, 0
	.dw 0x6740, 0xc808,	0x677f, 0xc808,		0x21, 0
	.dw 0x67c0, 0xc808,	0x67ff, 0xc808,		0x21, 0
	.dw 0x6840, 0xc808,	0x687f, 0xc808,		0x21, 0
	.dw 0x68c0, 0xc808,	0x68ff, 0xc808,		0x21, 0
	.dw 0x6940, 0xc808,	0x697f, 0xc808,		0x21, 0
	.dw 0x69c0, 0xc808,	0x69ff, 0xc808,		0x21, 0
	.dw 0x6a40, 0xc808,	0x6a7f, 0xc808,		0x21, 0
	.dw 0x6ac0, 0xc808,	0x6aff, 0xc808,		0x21, 0
	.dw 0x6b40, 0xc808,	0x6b7f, 0xc808,		0x21, 0
	.dw 0x6bc0, 0xc808,	0x6bff, 0xc808,		0x21, 0
	.dw 0x6c40, 0xc808,	0x6c7f, 0xc808,		0x21, 0
	.dw 0x6cc0, 0xc808,	0x6cff, 0xc808,		0x21, 0
	.dw 0x6d40, 0xc808,	0x6d7f, 0xc808,		0x21, 0
	.dw 0x6dc0, 0xc808,	0x6dff, 0xc808,		0x21, 0
	.dw 0x6e40, 0xc808,	0x6e7f, 0xc808,		0x21, 0
	.dw 0x6ec0, 0xc808,	0x6eff, 0xc808,		0x21, 0
	.dw 0x6f40, 0xc808,	0x6f7f, 0xc808,		0x21, 0
	.dw 0x6fc0, 0xc808,	0x6fff, 0xc808,		0x21, 0
	.dw 0x7040, 0xc808,	0x707f, 0xc808,		0x21, 0
	.dw 0x70c0, 0xc808,	0x70ff, 0xc808,		0x21, 0
	.dw 0x7140, 0xc808,	0x717f, 0xc808,		0x21, 0
	.dw 0x71c0, 0xc808,	0x71ff, 0xc808,		0x21, 0
	.dw 0x7240, 0xc808,	0x727f, 0xc808,		0x21, 0
	.dw 0x72c0, 0xc808,	0x72ff, 0xc808,		0x21, 0
	.dw 0x7340, 0xc808,	0x737f, 0xc808,		0x21, 0
	.dw 0x73c0, 0xc808,	0x73ff, 0xc808,		0x21, 0
	.dw 0x7440, 0xc808,	0x747f, 0xc808,		0x21, 0
	.dw 0x74c0, 0xc808,	0x74ff, 0xc808,		0x21, 0
	.dw 0x7540, 0xc808,	0x757f, 0xc808,		0x21, 0
	.dw 0x75c0, 0xc808,	0x75ff, 0xc808,		0x21, 0
	.dw 0x7640, 0xc808,	0x767f, 0xc808,		0x21, 0
	.dw 0x76c0, 0xc808,	0x76ff, 0xc808,		0x21, 0
	.dw 0x7740, 0xc808,	0x777f, 0xc808,		0x21, 0
	.dw 0x77c0, 0xc808,	0x77ff, 0xc808,		0x21, 0
	.dw 0x7840, 0xc808,	0x787f, 0xc808,		0x21, 0
	.dw 0x78c0, 0xc808,	0x78ff, 0xc808,		0x21, 0
	.dw 0x7940, 0xc808,	0x797f, 0xc808,		0x21, 0
	.dw 0x79c0, 0xc808,	0x9fff, 0xc808,		0x21, 0
	.dw 0xa040, 0xc808,	0xa07f, 0xc808,		0x21, 0
	.dw 0xa0c0, 0xc808,	0xa0ff, 0xc808,		0x21, 0
	.dw 0xa140, 0xc808,	0xa17f, 0xc808,		0x21, 0
	.dw 0xa1c0, 0xc808,	0xa1ff, 0xc808,		0x21, 0
	.dw 0xa240, 0xc808,	0xa27f, 0xc808,		0x21, 0
	.dw 0xa2c0, 0xc808,	0xa2ff, 0xc808,		0x21, 0
	.dw 0xa340, 0xc808,	0xa37f, 0xc808,		0x21, 0
	.dw 0xa3c0, 0xc808,	0xa3ff, 0xc808,		0x21, 0
	.dw 0xa440, 0xc808,	0xa47f, 0xc808,		0x21, 0
	.dw 0xa4c0, 0xc808,	0xa4ff, 0xc808,		0x21, 0
	.dw 0xa540, 0xc808,	0xa57f, 0xc808,		0x21, 0
	.dw 0xa5c0, 0xc808,	0xa5ff, 0xc808,		0x21, 0
	.dw 0xa640, 0xc808,	0xa67f, 0xc808,		0x21, 0
	.dw 0xa6c0, 0xc808,	0xa6ff, 0xc808,		0x21, 0
	.dw 0xa740, 0xc808,	0xa77f, 0xc808,		0x21, 0
	.dw 0xa7c0, 0xc808,	0xa7ff, 0xc808,		0x21, 0
	.dw 0xa840, 0xc808,	0xa87f, 0xc808,		0x21, 0
	.dw 0xa8c0, 0xc808,	0xa8ff, 0xc808,		0x21, 0
	.dw 0xa940, 0xc808,	0xa97f, 0xc808,		0x21, 0
	.dw 0xa9c0, 0xc808,	0xa9ff, 0xc808,		0x21, 0
	.dw 0xaa40, 0xc808,	0xaa7f, 0xc808,		0x21, 0
	.dw 0xaac0, 0xc808,	0xaaff, 0xc808,		0x21, 0
	.dw 0xab40, 0xc808,	0xab7f, 0xc808,		0x21, 0
	.dw 0xabc0, 0xc808,	0xabff, 0xc808,		0x21, 0
	.dw 0xac40, 0xc808,	0xac7f, 0xc808,		0x21, 0
	.dw 0xacc0, 0xc808,	0xacff, 0xc808,		0x21, 0
	.dw 0xad40, 0xc808,	0xad7f, 0xc808,		0x21, 0
	.dw 0xadc0, 0xc808,	0xadff, 0xc808,		0x21, 0
	.dw 0xae40, 0xc808,	0xae7f, 0xc808,		0x21, 0
	.dw 0xaec0, 0xc808,	0xaeff, 0xc808,		0x21, 0
	.dw 0xaf40, 0xc808,	0xaf7f, 0xc808,		0x21, 0
	.dw 0xafc0, 0xc808,	0xafff, 0xc808,		0x21, 0
	.dw 0xb040, 0xc808,	0xb07f, 0xc808,		0x21, 0
	.dw 0xb0c0, 0xc808,	0xb0ff, 0xc808,		0x21, 0
	.dw 0xb140, 0xc808,	0xb17f, 0xc808,		0x21, 0
	.dw 0xb1c0, 0xc808,	0xb1ff, 0xc808,		0x21, 0
	.dw 0xb240, 0xc808,	0xb27f, 0xc808,		0x21, 0
	.dw 0xb2c0, 0xc808,	0xb2ff, 0xc808,		0x21, 0
	.dw 0xb340, 0xc808,	0xb37f, 0xc808,		0x21, 0
	.dw 0xb3c0, 0xc808,	0xb3ff, 0xc808,		0x21, 0
	.dw 0xb440, 0xc808,	0xb47f, 0xc808,		0x21, 0
	.dw 0xb4c0, 0xc808,	0xb4ff, 0xc808,		0x21, 0
	.dw 0xb540, 0xc808,	0xb57f, 0xc808,		0x21, 0
	.dw 0xb5c0, 0xc808,	0xb5ff, 0xc808,		0x21, 0
	.dw 0xb640, 0xc808,	0xb67f, 0xc808,		0x21, 0
	.dw 0xb6c0, 0xc808,	0xb6ff, 0xc808,		0x21, 0
	.dw 0xb740, 0xc808,	0xb77f, 0xc808,		0x21, 0
	.dw 0xb7c0, 0xc808,	0xb7ff, 0xc808,		0x21, 0
	.dw 0xb840, 0xc808,	0xb87f, 0xc808,		0x21, 0
	.dw 0xb8c0, 0xc808,	0xb8ff, 0xc808,		0x21, 0
	.dw 0xb940, 0xc808,	0xb97f, 0xc808,		0x21, 0
	.dw 0xb9c0, 0xc808,	0xdfff, 0xc808,		0x21, 0
	.dw 0xe040, 0xc808,	0xe07f, 0xc808,		0x21, 0
	.dw 0xe0c0, 0xc808,	0xe0ff, 0xc808,		0x21, 0
	.dw 0xe140, 0xc808,	0xe17f, 0xc808,		0x21, 0
	.dw 0xe1c0, 0xc808,	0xe1ff, 0xc808,		0x21, 0
	.dw 0xe240, 0xc808,	0xe27f, 0xc808,		0x21, 0
	.dw 0xe2c0, 0xc808,	0xe2ff, 0xc808,		0x21, 0
	.dw 0xe340, 0xc808,	0xe37f, 0xc808,		0x21, 0
	.dw 0xe3c0, 0xc808,	0xe3ff, 0xc808,		0x21, 0
	.dw 0xe440, 0xc808,	0xe47f, 0xc808,		0x21, 0
	.dw 0xe4c0, 0xc808,	0xe4ff, 0xc808,		0x21, 0
	.dw 0xe540, 0xc808,	0xe57f, 0xc808,		0x21, 0
	.dw 0xe5c0, 0xc808,	0xe5ff, 0xc808,		0x21, 0
	.dw 0xe640, 0xc808,	0xe67f, 0xc808,		0x21, 0
	.dw 0xe6c0, 0xc808,	0xe6ff, 0xc808,		0x21, 0
	.dw 0xe740, 0xc808,	0xe77f, 0xc808,		0x21, 0
	.dw 0xe7c0, 0xc808,	0xe7ff, 0xc808,		0x21, 0
	.dw 0xe840, 0xc808,	0xe87f, 0xc808,		0x21, 0
	.dw 0xe8c0, 0xc808,	0xe8ff, 0xc808,		0x21, 0
	.dw 0xe940, 0xc808,	0xe97f, 0xc808,		0x21, 0
	.dw 0xe9c0, 0xc808,	0xe9ff, 0xc808,		0x21, 0
	.dw 0xea40, 0xc808,	0xea7f, 0xc808,		0x21, 0
	.dw 0xeac0, 0xc808,	0xeaff, 0xc808,		0x21, 0
	.dw 0xeb40, 0xc808,	0xeb7f, 0xc808,		0x21, 0
	.dw 0xebc0, 0xc808,	0xebff, 0xc808,		0x21, 0
	.dw 0xec40, 0xc808,	0xec7f, 0xc808,		0x21, 0
	.dw 0xecc0, 0xc808,	0xecff, 0xc808,		0x21, 0
	.dw 0xed40, 0xc808,	0xed7f, 0xc808,		0x21, 0
	.dw 0xedc0, 0xc808,	0xedff, 0xc808,		0x21, 0
	.dw 0xee40, 0xc808,	0xee7f, 0xc808,		0x21, 0
	.dw 0xeec0, 0xc808,	0xeeff, 0xc808,		0x21, 0
	.dw 0xef40, 0xc808,	0xef7f, 0xc808,		0x21, 0
	.dw 0xefc0, 0xc808,	0xefff, 0xc808,		0x21, 0
	.dw 0xf040, 0xc808,	0xf07f, 0xc808,		0x21, 0
	.dw 0xf0c0, 0xc808,	0xf0ff, 0xc808,		0x21, 0
	.dw 0xf140, 0xc808,	0xf17f, 0xc808,		0x21, 0
	.dw 0xf1c0, 0xc808,	0xf1ff, 0xc808,		0x21, 0
	.dw 0xf240, 0xc808,	0xf27f, 0xc808,		0x21, 0
	.dw 0xf2c0, 0xc808,	0xf2ff, 0xc808,		0x21, 0
	.dw 0xf340, 0xc808,	0xf37f, 0xc808,		0x21, 0
	.dw 0xf3c0, 0xc808,	0xf3ff, 0xc808,		0x21, 0
	.dw 0xf440, 0xc808,	0xf47f, 0xc808,		0x21, 0
	.dw 0xf4c0, 0xc808,	0xf4ff, 0xc808,		0x21, 0
	.dw 0xf540, 0xc808,	0xf57f, 0xc808,		0x21, 0
	.dw 0xf5c0, 0xc808,	0xf5ff, 0xc808,		0x21, 0
	.dw 0xf640, 0xc808,	0xf67f, 0xc808,		0x21, 0
	.dw 0xf6c0, 0xc808,	0xf6ff, 0xc808,		0x21, 0
	.dw 0xf740, 0xc808,	0xf77f, 0xc808,		0x21, 0
	.dw 0xf7c0, 0xc808,	0xf7ff, 0xc808,		0x21, 0
	.dw 0xf840, 0xc808,	0xf87f, 0xc808,		0x21, 0
	.dw 0xf8c0, 0xc808,	0xf8ff, 0xc808,		0x21, 0
	.dw 0xf940, 0xc808,	0xf97f, 0xc808,		0x21, 0
	.dw 0xf9c0, 0xc808,	0x1fff, 0xc809,		0x21, 0
	.dw 0x2040, 0xc809,	0x207f, 0xc809,		0x21, 0
	.dw 0x20c0, 0xc809,	0x20ff, 0xc809,		0x21, 0
	.dw 0x2140, 0xc809,	0x217f, 0xc809,		0x21, 0
	.dw 0x21c0, 0xc809,	0x21ff, 0xc809,		0x21, 0
	.dw 0x2240, 0xc809,	0x227f, 0xc809,		0x21, 0
	.dw 0x22c0, 0xc809,	0x22ff, 0xc809,		0x21, 0
	.dw 0x2340, 0xc809,	0x237f, 0xc809,		0x21, 0
	.dw 0x23c0, 0xc809,	0x23ff, 0xc809,		0x21, 0
	.dw 0x2440, 0xc809,	0x247f, 0xc809,		0x21, 0
	.dw 0x24c0, 0xc809,	0x24ff, 0xc809,		0x21, 0
	.dw 0x2540, 0xc809,	0x257f, 0xc809,		0x21, 0
	.dw 0x25c0, 0xc809,	0x25ff, 0xc809,		0x21, 0
	.dw 0x2640, 0xc809,	0x267f, 0xc809,		0x21, 0
	.dw 0x26c0, 0xc809,	0x26ff, 0xc809,		0x21, 0
	.dw 0x2740, 0xc809,	0x277f, 0xc809,		0x21, 0
	.dw 0x27c0, 0xc809,	0x27ff, 0xc809,		0x21, 0
	.dw 0x2840, 0xc809,	0x287f, 0xc809,		0x21, 0
	.dw 0x28c0, 0xc809,	0x28ff, 0xc809,		0x21, 0
	.dw 0x2940, 0xc809,	0x297f, 0xc809,		0x21, 0
	.dw 0x29c0, 0xc809,	0x29ff, 0xc809,		0x21, 0
	.dw 0x2a40, 0xc809,	0x2a7f, 0xc809,		0x21, 0
	.dw 0x2ac0, 0xc809,	0x2aff, 0xc809,		0x21, 0
	.dw 0x2b40, 0xc809,	0x2b7f, 0xc809,		0x21, 0
	.dw 0x2bc0, 0xc809,	0x2bff, 0xc809,		0x21, 0
	.dw 0x2c40, 0xc809,	0x2c7f, 0xc809,		0x21, 0
	.dw 0x2cc0, 0xc809,	0x2cff, 0xc809,		0x21, 0
	.dw 0x2d40, 0xc809,	0x2d7f, 0xc809,		0x21, 0
	.dw 0x2dc0, 0xc809,	0x2dff, 0xc809,		0x21, 0
	.dw 0x2e40, 0xc809,	0x2e7f, 0xc809,		0x21, 0
	.dw 0x2ec0, 0xc809,	0x2eff, 0xc809,		0x21, 0
	.dw 0x2f40, 0xc809,	0x2f7f, 0xc809,		0x21, 0
	.dw 0x2fc0, 0xc809,	0x2fff, 0xc809,		0x21, 0
	.dw 0x3040, 0xc809,	0x307f, 0xc809,		0x21, 0
	.dw 0x30c0, 0xc809,	0x30ff, 0xc809,		0x21, 0
	.dw 0x3140, 0xc809,	0x317f, 0xc809,		0x21, 0
	.dw 0x31c0, 0xc809,	0x31ff, 0xc809,		0x21, 0
	.dw 0x3240, 0xc809,	0x327f, 0xc809,		0x21, 0
	.dw 0x32c0, 0xc809,	0x32ff, 0xc809,		0x21, 0
	.dw 0x3340, 0xc809,	0x337f, 0xc809,		0x21, 0
	.dw 0x33c0, 0xc809,	0x33ff, 0xc809,		0x21, 0
	.dw 0x3440, 0xc809,	0x347f, 0xc809,		0x21, 0
	.dw 0x34c0, 0xc809,	0x34ff, 0xc809,		0x21, 0
	.dw 0x3540, 0xc809,	0x357f, 0xc809,		0x21, 0
	.dw 0x35c0, 0xc809,	0x35ff, 0xc809,		0x21, 0
	.dw 0x3640, 0xc809,	0x367f, 0xc809,		0x21, 0
	.dw 0x36c0, 0xc809,	0x36ff, 0xc809,		0x21, 0
	.dw 0x3740, 0xc809,	0x377f, 0xc809,		0x21, 0
	.dw 0x37c0, 0xc809,	0x37ff, 0xc809,		0x21, 0
	.dw 0x3840, 0xc809,	0x387f, 0xc809,		0x21, 0
	.dw 0x38c0, 0xc809,	0x38ff, 0xc809,		0x21, 0
	.dw 0x3940, 0xc809,	0x397f, 0xc809,		0x21, 0
	.dw 0x39c0, 0xc809,	0x5fff, 0xc809,		0x21, 0
	.dw 0x6040, 0xc809,	0x607f, 0xc809,		0x21, 0
	.dw 0x60c0, 0xc809,	0x60ff, 0xc809,		0x21, 0
	.dw 0x6140, 0xc809,	0x617f, 0xc809,		0x21, 0
	.dw 0x61c0, 0xc809,	0x61ff, 0xc809,		0x21, 0
	.dw 0x6240, 0xc809,	0x627f, 0xc809,		0x21, 0
	.dw 0x62c0, 0xc809,	0x62ff, 0xc809,		0x21, 0
	.dw 0x6340, 0xc809,	0x637f, 0xc809,		0x21, 0
	.dw 0x63c0, 0xc809,	0x63ff, 0xc809,		0x21, 0
	.dw 0x6440, 0xc809,	0x647f, 0xc809,		0x21, 0
	.dw 0x64c0, 0xc809,	0x64ff, 0xc809,		0x21, 0
	.dw 0x6540, 0xc809,	0x657f, 0xc809,		0x21, 0
	.dw 0x65c0, 0xc809,	0x65ff, 0xc809,		0x21, 0
	.dw 0x6640, 0xc809,	0x667f, 0xc809,		0x21, 0
	.dw 0x66c0, 0xc809,	0x66ff, 0xc809,		0x21, 0
	.dw 0x6740, 0xc809,	0x677f, 0xc809,		0x21, 0
	.dw 0x67c0, 0xc809,	0x67ff, 0xc809,		0x21, 0
	.dw 0x6840, 0xc809,	0x687f, 0xc809,		0x21, 0
	.dw 0x68c0, 0xc809,	0x68ff, 0xc809,		0x21, 0
	.dw 0x6940, 0xc809,	0x697f, 0xc809,		0x21, 0
	.dw 0x69c0, 0xc809,	0x69ff, 0xc809,		0x21, 0
	.dw 0x6a40, 0xc809,	0x6a7f, 0xc809,		0x21, 0
	.dw 0x6ac0, 0xc809,	0x6aff, 0xc809,		0x21, 0
	.dw 0x6b40, 0xc809,	0x6b7f, 0xc809,		0x21, 0
	.dw 0x6bc0, 0xc809,	0x6bff, 0xc809,		0x21, 0
	.dw 0x6c40, 0xc809,	0x6c7f, 0xc809,		0x21, 0
	.dw 0x6cc0, 0xc809,	0x6cff, 0xc809,		0x21, 0
	.dw 0x6d40, 0xc809,	0x6d7f, 0xc809,		0x21, 0
	.dw 0x6dc0, 0xc809,	0x6dff, 0xc809,		0x21, 0
	.dw 0x6e40, 0xc809,	0x6e7f, 0xc809,		0x21, 0
	.dw 0x6ec0, 0xc809,	0x6eff, 0xc809,		0x21, 0
	.dw 0x6f40, 0xc809,	0x6f7f, 0xc809,		0x21, 0
	.dw 0x6fc0, 0xc809,	0x6fff, 0xc809,		0x21, 0
	.dw 0x7040, 0xc809,	0x707f, 0xc809,		0x21, 0
	.dw 0x70c0, 0xc809,	0x70ff, 0xc809,		0x21, 0
	.dw 0x7140, 0xc809,	0x717f, 0xc809,		0x21, 0
	.dw 0x71c0, 0xc809,	0x71ff, 0xc809,		0x21, 0
	.dw 0x7240, 0xc809,	0x727f, 0xc809,		0x21, 0
	.dw 0x72c0, 0xc809,	0x72ff, 0xc809,		0x21, 0
	.dw 0x7340, 0xc809,	0x737f, 0xc809,		0x21, 0
	.dw 0x73c0, 0xc809,	0x73ff, 0xc809,		0x21, 0
	.dw 0x7440, 0xc809,	0x747f, 0xc809,		0x21, 0
	.dw 0x74c0, 0xc809,	0x74ff, 0xc809,		0x21, 0
	.dw 0x7540, 0xc809,	0x757f, 0xc809,		0x21, 0
	.dw 0x75c0, 0xc809,	0x75ff, 0xc809,		0x21, 0
	.dw 0x7640, 0xc809,	0x767f, 0xc809,		0x21, 0
	.dw 0x76c0, 0xc809,	0x76ff, 0xc809,		0x21, 0
	.dw 0x7740, 0xc809,	0x777f, 0xc809,		0x21, 0
	.dw 0x77c0, 0xc809,	0x77ff, 0xc809,		0x21, 0
	.dw 0x7840, 0xc809,	0x787f, 0xc809,		0x21, 0
	.dw 0x78c0, 0xc809,	0x78ff, 0xc809,		0x21, 0
	.dw 0x7940, 0xc809,	0x797f, 0xc809,		0x21, 0
	.dw 0x79c0, 0xc809,	0x9fff, 0xc809,		0x21, 0
	.dw 0xa040, 0xc809,	0xa07f, 0xc809,		0x21, 0
	.dw 0xa0c0, 0xc809,	0xa0ff, 0xc809,		0x21, 0
	.dw 0xa140, 0xc809,	0xa17f, 0xc809,		0x21, 0
	.dw 0xa1c0, 0xc809,	0xa1ff, 0xc809,		0x21, 0
	.dw 0xa240, 0xc809,	0xa27f, 0xc809,		0x21, 0
	.dw 0xa2c0, 0xc809,	0xa2ff, 0xc809,		0x21, 0
	.dw 0xa340, 0xc809,	0xa37f, 0xc809,		0x21, 0
	.dw 0xa3c0, 0xc809,	0xa3ff, 0xc809,		0x21, 0
	.dw 0xa440, 0xc809,	0xa47f, 0xc809,		0x21, 0
	.dw 0xa4c0, 0xc809,	0xa4ff, 0xc809,		0x21, 0
	.dw 0xa540, 0xc809,	0xa57f, 0xc809,		0x21, 0
	.dw 0xa5c0, 0xc809,	0xa5ff, 0xc809,		0x21, 0
	.dw 0xa640, 0xc809,	0xa67f, 0xc809,		0x21, 0
	.dw 0xa6c0, 0xc809,	0xa6ff, 0xc809,		0x21, 0
	.dw 0xa740, 0xc809,	0xa77f, 0xc809,		0x21, 0
	.dw 0xa7c0, 0xc809,	0xa7ff, 0xc809,		0x21, 0
	.dw 0xa840, 0xc809,	0xa87f, 0xc809,		0x21, 0
	.dw 0xa8c0, 0xc809,	0xa8ff, 0xc809,		0x21, 0
	.dw 0xa940, 0xc809,	0xa97f, 0xc809,		0x21, 0
	.dw 0xa9c0, 0xc809,	0xa9ff, 0xc809,		0x21, 0
	.dw 0xaa40, 0xc809,	0xaa7f, 0xc809,		0x21, 0
	.dw 0xaac0, 0xc809,	0xaaff, 0xc809,		0x21, 0
	.dw 0xab40, 0xc809,	0xab7f, 0xc809,		0x21, 0
	.dw 0xabc0, 0xc809,	0xabff, 0xc809,		0x21, 0
	.dw 0xac40, 0xc809,	0xac7f, 0xc809,		0x21, 0
	.dw 0xacc0, 0xc809,	0xacff, 0xc809,		0x21, 0
	.dw 0xad40, 0xc809,	0xad7f, 0xc809,		0x21, 0
	.dw 0xadc0, 0xc809,	0xadff, 0xc809,		0x21, 0
	.dw 0xae40, 0xc809,	0xae7f, 0xc809,		0x21, 0
	.dw 0xaec0, 0xc809,	0xaeff, 0xc809,		0x21, 0
	.dw 0xaf40, 0xc809,	0xaf7f, 0xc809,		0x21, 0
	.dw 0xafc0, 0xc809,	0xafff, 0xc809,		0x21, 0
	.dw 0xb040, 0xc809,	0xb07f, 0xc809,		0x21, 0
	.dw 0xb0c0, 0xc809,	0xb0ff, 0xc809,		0x21, 0
	.dw 0xb140, 0xc809,	0xb17f, 0xc809,		0x21, 0
	.dw 0xb1c0, 0xc809,	0xb1ff, 0xc809,		0x21, 0
	.dw 0xb240, 0xc809,	0xb27f, 0xc809,		0x21, 0
	.dw 0xb2c0, 0xc809,	0xb2ff, 0xc809,		0x21, 0
	.dw 0xb340, 0xc809,	0xb37f, 0xc809,		0x21, 0
	.dw 0xb3c0, 0xc809,	0xb3ff, 0xc809,		0x21, 0
	.dw 0xb440, 0xc809,	0xb47f, 0xc809,		0x21, 0
	.dw 0xb4c0, 0xc809,	0xb4ff, 0xc809,		0x21, 0
	.dw 0xb540, 0xc809,	0xb57f, 0xc809,		0x21, 0
	.dw 0xb5c0, 0xc809,	0xb5ff, 0xc809,		0x21, 0
	.dw 0xb640, 0xc809,	0xb67f, 0xc809,		0x21, 0
	.dw 0xb6c0, 0xc809,	0xb6ff, 0xc809,		0x21, 0
	.dw 0xb740, 0xc809,	0xb77f, 0xc809,		0x21, 0
	.dw 0xb7c0, 0xc809,	0xb7ff, 0xc809,		0x21, 0
	.dw 0xb840, 0xc809,	0xb87f, 0xc809,		0x21, 0
	.dw 0xb8c0, 0xc809,	0xb8ff, 0xc809,		0x21, 0
	.dw 0xb940, 0xc809,	0xb97f, 0xc809,		0x21, 0
	.dw 0xb9c0, 0xc809,	0xdfff, 0xc809,		0x21, 0
	.dw 0xe040, 0xc809,	0xe07f, 0xc809,		0x21, 0
	.dw 0xe0c0, 0xc809,	0xe0ff, 0xc809,		0x21, 0
	.dw 0xe140, 0xc809,	0xe17f, 0xc809,		0x21, 0
	.dw 0xe1c0, 0xc809,	0xe1ff, 0xc809,		0x21, 0
	.dw 0xe240, 0xc809,	0xe27f, 0xc809,		0x21, 0
	.dw 0xe2c0, 0xc809,	0xe2ff, 0xc809,		0x21, 0
	.dw 0xe340, 0xc809,	0xe37f, 0xc809,		0x21, 0
	.dw 0xe3c0, 0xc809,	0xe3ff, 0xc809,		0x21, 0
	.dw 0xe440, 0xc809,	0xe47f, 0xc809,		0x21, 0
	.dw 0xe4c0, 0xc809,	0xe4ff, 0xc809,		0x21, 0
	.dw 0xe540, 0xc809,	0xe57f, 0xc809,		0x21, 0
	.dw 0xe5c0, 0xc809,	0xe5ff, 0xc809,		0x21, 0
	.dw 0xe640, 0xc809,	0xe67f, 0xc809,		0x21, 0
	.dw 0xe6c0, 0xc809,	0xe6ff, 0xc809,		0x21, 0
	.dw 0xe740, 0xc809,	0xe77f, 0xc809,		0x21, 0
	.dw 0xe7c0, 0xc809,	0xe7ff, 0xc809,		0x21, 0
	.dw 0xe840, 0xc809,	0xe87f, 0xc809,		0x21, 0
	.dw 0xe8c0, 0xc809,	0xe8ff, 0xc809,		0x21, 0
	.dw 0xe940, 0xc809,	0xe97f, 0xc809,		0x21, 0
	.dw 0xe9c0, 0xc809,	0xe9ff, 0xc809,		0x21, 0
	.dw 0xea40, 0xc809,	0xea7f, 0xc809,		0x21, 0
	.dw 0xeac0, 0xc809,	0xeaff, 0xc809,		0x21, 0
	.dw 0xeb40, 0xc809,	0xeb7f, 0xc809,		0x21, 0
	.dw 0xebc0, 0xc809,	0xebff, 0xc809,		0x21, 0
	.dw 0xec40, 0xc809,	0xec7f, 0xc809,		0x21, 0
	.dw 0xecc0, 0xc809,	0xecff, 0xc809,		0x21, 0
	.dw 0xed40, 0xc809,	0xed7f, 0xc809,		0x21, 0
	.dw 0xedc0, 0xc809,	0xedff, 0xc809,		0x21, 0
	.dw 0xee40, 0xc809,	0xee7f, 0xc809,		0x21, 0
	.dw 0xeec0, 0xc809,	0xeeff, 0xc809,		0x21, 0
	.dw 0xef40, 0xc809,	0xef7f, 0xc809,		0x21, 0
	.dw 0xefc0, 0xc809,	0xefff, 0xc809,		0x21, 0
	.dw 0xf040, 0xc809,	0xf07f, 0xc809,		0x21, 0
	.dw 0xf0c0, 0xc809,	0xf0ff, 0xc809,		0x21, 0
	.dw 0xf140, 0xc809,	0xf17f, 0xc809,		0x21, 0
	.dw 0xf1c0, 0xc809,	0xf1ff, 0xc809,		0x21, 0
	.dw 0xf240, 0xc809,	0xf27f, 0xc809,		0x21, 0
	.dw 0xf2c0, 0xc809,	0xf2ff, 0xc809,		0x21, 0
	.dw 0xf340, 0xc809,	0xf37f, 0xc809,		0x21, 0
	.dw 0xf3c0, 0xc809,	0xf3ff, 0xc809,		0x21, 0
	.dw 0xf440, 0xc809,	0xf47f, 0xc809,		0x21, 0
	.dw 0xf4c0, 0xc809,	0xf4ff, 0xc809,		0x21, 0
	.dw 0xf540, 0xc809,	0xf57f, 0xc809,		0x21, 0
	.dw 0xf5c0, 0xc809,	0xf5ff, 0xc809,		0x21, 0
	.dw 0xf640, 0xc809,	0xf67f, 0xc809,		0x21, 0
	.dw 0xf6c0, 0xc809,	0xf6ff, 0xc809,		0x21, 0
	.dw 0xf740, 0xc809,	0xf77f, 0xc809,		0x21, 0
	.dw 0xf7c0, 0xc809,	0xf7ff, 0xc809,		0x21, 0
	.dw 0xf840, 0xc809,	0xf87f, 0xc809,		0x21, 0
	.dw 0xf8c0, 0xc809,	0xf8ff, 0xc809,		0x21, 0
	.dw 0xf940, 0xc809,	0xf97f, 0xc809,		0x21, 0
	.dw 0xf9c0, 0xc809,	0x1fff, 0xc80a,		0x21, 0
	.dw 0x2040, 0xc80a,	0x207f, 0xc80a,		0x21, 0
	.dw 0x20c0, 0xc80a,	0x20ff, 0xc80a,		0x21, 0
	.dw 0x2140, 0xc80a,	0x217f, 0xc80a,		0x21, 0
	.dw 0x21c0, 0xc80a,	0x21ff, 0xc80a,		0x21, 0
	.dw 0x2240, 0xc80a,	0x227f, 0xc80a,		0x21, 0
	.dw 0x22c0, 0xc80a,	0x22ff, 0xc80a,		0x21, 0
	.dw 0x2340, 0xc80a,	0x237f, 0xc80a,		0x21, 0
	.dw 0x23c0, 0xc80a,	0x23ff, 0xc80a,		0x21, 0
	.dw 0x2440, 0xc80a,	0x247f, 0xc80a,		0x21, 0
	.dw 0x24c0, 0xc80a,	0x24ff, 0xc80a,		0x21, 0
	.dw 0x2540, 0xc80a,	0x257f, 0xc80a,		0x21, 0
	.dw 0x25c0, 0xc80a,	0x25ff, 0xc80a,		0x21, 0
	.dw 0x2640, 0xc80a,	0x267f, 0xc80a,		0x21, 0
	.dw 0x26c0, 0xc80a,	0x26ff, 0xc80a,		0x21, 0
	.dw 0x2740, 0xc80a,	0x277f, 0xc80a,		0x21, 0
	.dw 0x27c0, 0xc80a,	0x27ff, 0xc80a,		0x21, 0
	.dw 0x2840, 0xc80a,	0x287f, 0xc80a,		0x21, 0
	.dw 0x28c0, 0xc80a,	0x28ff, 0xc80a,		0x21, 0
	.dw 0x2940, 0xc80a,	0x297f, 0xc80a,		0x21, 0
	.dw 0x29c0, 0xc80a,	0x29ff, 0xc80a,		0x21, 0
	.dw 0x2a40, 0xc80a,	0x2a7f, 0xc80a,		0x21, 0
	.dw 0x2ac0, 0xc80a,	0x2aff, 0xc80a,		0x21, 0
	.dw 0x2b40, 0xc80a,	0x2b7f, 0xc80a,		0x21, 0
	.dw 0x2bc0, 0xc80a,	0x2bff, 0xc80a,		0x21, 0
	.dw 0x2c40, 0xc80a,	0x2c7f, 0xc80a,		0x21, 0
	.dw 0x2cc0, 0xc80a,	0x2cff, 0xc80a,		0x21, 0
	.dw 0x2d40, 0xc80a,	0x2d7f, 0xc80a,		0x21, 0
	.dw 0x2dc0, 0xc80a,	0x2dff, 0xc80a,		0x21, 0
	.dw 0x2e40, 0xc80a,	0x2e7f, 0xc80a,		0x21, 0
	.dw 0x2ec0, 0xc80a,	0x2eff, 0xc80a,		0x21, 0
	.dw 0x2f40, 0xc80a,	0x2f7f, 0xc80a,		0x21, 0
	.dw 0x2fc0, 0xc80a,	0x2fff, 0xc80a,		0x21, 0
	.dw 0x3040, 0xc80a,	0x307f, 0xc80a,		0x21, 0
	.dw 0x30c0, 0xc80a,	0x30ff, 0xc80a,		0x21, 0
	.dw 0x3140, 0xc80a,	0x317f, 0xc80a,		0x21, 0
	.dw 0x31c0, 0xc80a,	0x31ff, 0xc80a,		0x21, 0
	.dw 0x3240, 0xc80a,	0x327f, 0xc80a,		0x21, 0
	.dw 0x32c0, 0xc80a,	0x32ff, 0xc80a,		0x21, 0
	.dw 0x3340, 0xc80a,	0x337f, 0xc80a,		0x21, 0
	.dw 0x33c0, 0xc80a,	0x33ff, 0xc80a,		0x21, 0
	.dw 0x3440, 0xc80a,	0x347f, 0xc80a,		0x21, 0
	.dw 0x34c0, 0xc80a,	0x34ff, 0xc80a,		0x21, 0
	.dw 0x3540, 0xc80a,	0x357f, 0xc80a,		0x21, 0
	.dw 0x35c0, 0xc80a,	0x35ff, 0xc80a,		0x21, 0
	.dw 0x3640, 0xc80a,	0x367f, 0xc80a,		0x21, 0
	.dw 0x36c0, 0xc80a,	0x36ff, 0xc80a,		0x21, 0
	.dw 0x3740, 0xc80a,	0x377f, 0xc80a,		0x21, 0
	.dw 0x37c0, 0xc80a,	0x37ff, 0xc80a,		0x21, 0
	.dw 0x3840, 0xc80a,	0x387f, 0xc80a,		0x21, 0
	.dw 0x38c0, 0xc80a,	0x38ff, 0xc80a,		0x21, 0
	.dw 0x3940, 0xc80a,	0x397f, 0xc80a,		0x21, 0
	.dw 0x39c0, 0xc80a,	0x5fff, 0xc80a,		0x21, 0
	.dw 0x6040, 0xc80a,	0x607f, 0xc80a,		0x21, 0
	.dw 0x60c0, 0xc80a,	0x60ff, 0xc80a,		0x21, 0
	.dw 0x6140, 0xc80a,	0x617f, 0xc80a,		0x21, 0
	.dw 0x61c0, 0xc80a,	0x61ff, 0xc80a,		0x21, 0
	.dw 0x6240, 0xc80a,	0x627f, 0xc80a,		0x21, 0
	.dw 0x62c0, 0xc80a,	0x62ff, 0xc80a,		0x21, 0
	.dw 0x6340, 0xc80a,	0x637f, 0xc80a,		0x21, 0
	.dw 0x63c0, 0xc80a,	0x63ff, 0xc80a,		0x21, 0
	.dw 0x6440, 0xc80a,	0x647f, 0xc80a,		0x21, 0
	.dw 0x64c0, 0xc80a,	0x64ff, 0xc80a,		0x21, 0
	.dw 0x6540, 0xc80a,	0x657f, 0xc80a,		0x21, 0
	.dw 0x65c0, 0xc80a,	0x65ff, 0xc80a,		0x21, 0
	.dw 0x6640, 0xc80a,	0x667f, 0xc80a,		0x21, 0
	.dw 0x66c0, 0xc80a,	0x66ff, 0xc80a,		0x21, 0
	.dw 0x6740, 0xc80a,	0x677f, 0xc80a,		0x21, 0
	.dw 0x67c0, 0xc80a,	0x67ff, 0xc80a,		0x21, 0
	.dw 0x6840, 0xc80a,	0x687f, 0xc80a,		0x21, 0
	.dw 0x68c0, 0xc80a,	0x68ff, 0xc80a,		0x21, 0
	.dw 0x6940, 0xc80a,	0x697f, 0xc80a,		0x21, 0
	.dw 0x69c0, 0xc80a,	0x69ff, 0xc80a,		0x21, 0
	.dw 0x6a40, 0xc80a,	0x6a7f, 0xc80a,		0x21, 0
	.dw 0x6ac0, 0xc80a,	0x6aff, 0xc80a,		0x21, 0
	.dw 0x6b40, 0xc80a,	0x6b7f, 0xc80a,		0x21, 0
	.dw 0x6bc0, 0xc80a,	0x6bff, 0xc80a,		0x21, 0
	.dw 0x6c40, 0xc80a,	0x6c7f, 0xc80a,		0x21, 0
	.dw 0x6cc0, 0xc80a,	0x6cff, 0xc80a,		0x21, 0
	.dw 0x6d40, 0xc80a,	0x6d7f, 0xc80a,		0x21, 0
	.dw 0x6dc0, 0xc80a,	0x6dff, 0xc80a,		0x21, 0
	.dw 0x6e40, 0xc80a,	0x6e7f, 0xc80a,		0x21, 0
	.dw 0x6ec0, 0xc80a,	0x6eff, 0xc80a,		0x21, 0
	.dw 0x6f40, 0xc80a,	0x6f7f, 0xc80a,		0x21, 0
	.dw 0x6fc0, 0xc80a,	0x6fff, 0xc80a,		0x21, 0
	.dw 0x7040, 0xc80a,	0x707f, 0xc80a,		0x21, 0
	.dw 0x70c0, 0xc80a,	0x70ff, 0xc80a,		0x21, 0
	.dw 0x7140, 0xc80a,	0x717f, 0xc80a,		0x21, 0
	.dw 0x71c0, 0xc80a,	0x71ff, 0xc80a,		0x21, 0
	.dw 0x7240, 0xc80a,	0x727f, 0xc80a,		0x21, 0
	.dw 0x72c0, 0xc80a,	0x72ff, 0xc80a,		0x21, 0
	.dw 0x7340, 0xc80a,	0x737f, 0xc80a,		0x21, 0
	.dw 0x73c0, 0xc80a,	0x73ff, 0xc80a,		0x21, 0
	.dw 0x7440, 0xc80a,	0x747f, 0xc80a,		0x21, 0
	.dw 0x74c0, 0xc80a,	0x74ff, 0xc80a,		0x21, 0
	.dw 0x7540, 0xc80a,	0x757f, 0xc80a,		0x21, 0
	.dw 0x75c0, 0xc80a,	0x75ff, 0xc80a,		0x21, 0
	.dw 0x7640, 0xc80a,	0x767f, 0xc80a,		0x21, 0
	.dw 0x76c0, 0xc80a,	0x76ff, 0xc80a,		0x21, 0
	.dw 0x7740, 0xc80a,	0x777f, 0xc80a,		0x21, 0
	.dw 0x77c0, 0xc80a,	0x77ff, 0xc80a,		0x21, 0
	.dw 0x7840, 0xc80a,	0x787f, 0xc80a,		0x21, 0
	.dw 0x78c0, 0xc80a,	0x78ff, 0xc80a,		0x21, 0
	.dw 0x7940, 0xc80a,	0x797f, 0xc80a,		0x21, 0
	.dw 0x79c0, 0xc80a,	0x9fff, 0xc80a,		0x21, 0
	.dw 0xa040, 0xc80a,	0xa07f, 0xc80a,		0x21, 0
	.dw 0xa0c0, 0xc80a,	0xa0ff, 0xc80a,		0x21, 0
	.dw 0xa140, 0xc80a,	0xa17f, 0xc80a,		0x21, 0
	.dw 0xa1c0, 0xc80a,	0xa1ff, 0xc80a,		0x21, 0
	.dw 0xa240, 0xc80a,	0xa27f, 0xc80a,		0x21, 0
	.dw 0xa2c0, 0xc80a,	0xa2ff, 0xc80a,		0x21, 0
	.dw 0xa340, 0xc80a,	0xa37f, 0xc80a,		0x21, 0
	.dw 0xa3c0, 0xc80a,	0xa3ff, 0xc80a,		0x21, 0
	.dw 0xa440, 0xc80a,	0xa47f, 0xc80a,		0x21, 0
	.dw 0xa4c0, 0xc80a,	0xa4ff, 0xc80a,		0x21, 0
	.dw 0xa540, 0xc80a,	0xa57f, 0xc80a,		0x21, 0
	.dw 0xa5c0, 0xc80a,	0xa5ff, 0xc80a,		0x21, 0
	.dw 0xa640, 0xc80a,	0xa67f, 0xc80a,		0x21, 0
	.dw 0xa6c0, 0xc80a,	0xa6ff, 0xc80a,		0x21, 0
	.dw 0xa740, 0xc80a,	0xa77f, 0xc80a,		0x21, 0
	.dw 0xa7c0, 0xc80a,	0xa7ff, 0xc80a,		0x21, 0
	.dw 0xa840, 0xc80a,	0xa87f, 0xc80a,		0x21, 0
	.dw 0xa8c0, 0xc80a,	0xa8ff, 0xc80a,		0x21, 0
	.dw 0xa940, 0xc80a,	0xa97f, 0xc80a,		0x21, 0
	.dw 0xa9c0, 0xc80a,	0xa9ff, 0xc80a,		0x21, 0
	.dw 0xaa40, 0xc80a,	0xaa7f, 0xc80a,		0x21, 0
	.dw 0xaac0, 0xc80a,	0xaaff, 0xc80a,		0x21, 0
	.dw 0xab40, 0xc80a,	0xab7f, 0xc80a,		0x21, 0
	.dw 0xabc0, 0xc80a,	0xabff, 0xc80a,		0x21, 0
	.dw 0xac40, 0xc80a,	0xac7f, 0xc80a,		0x21, 0
	.dw 0xacc0, 0xc80a,	0xacff, 0xc80a,		0x21, 0
	.dw 0xad40, 0xc80a,	0xad7f, 0xc80a,		0x21, 0
	.dw 0xadc0, 0xc80a,	0xadff, 0xc80a,		0x21, 0
	.dw 0xae40, 0xc80a,	0xae7f, 0xc80a,		0x21, 0
	.dw 0xaec0, 0xc80a,	0xaeff, 0xc80a,		0x21, 0
	.dw 0xaf40, 0xc80a,	0xaf7f, 0xc80a,		0x21, 0
	.dw 0xafc0, 0xc80a,	0xafff, 0xc80a,		0x21, 0
	.dw 0xb040, 0xc80a,	0xb07f, 0xc80a,		0x21, 0
	.dw 0xb0c0, 0xc80a,	0xb0ff, 0xc80a,		0x21, 0
	.dw 0xb140, 0xc80a,	0xb17f, 0xc80a,		0x21, 0
	.dw 0xb1c0, 0xc80a,	0xb1ff, 0xc80a,		0x21, 0
	.dw 0xb240, 0xc80a,	0xb27f, 0xc80a,		0x21, 0
	.dw 0xb2c0, 0xc80a,	0xb2ff, 0xc80a,		0x21, 0
	.dw 0xb340, 0xc80a,	0xb37f, 0xc80a,		0x21, 0
	.dw 0xb3c0, 0xc80a,	0xb3ff, 0xc80a,		0x21, 0
	.dw 0xb440, 0xc80a,	0xb47f, 0xc80a,		0x21, 0
	.dw 0xb4c0, 0xc80a,	0xb4ff, 0xc80a,		0x21, 0
	.dw 0xb540, 0xc80a,	0xb57f, 0xc80a,		0x21, 0
	.dw 0xb5c0, 0xc80a,	0xb5ff, 0xc80a,		0x21, 0
	.dw 0xb640, 0xc80a,	0xb67f, 0xc80a,		0x21, 0
	.dw 0xb6c0, 0xc80a,	0xb6ff, 0xc80a,		0x21, 0
	.dw 0xb740, 0xc80a,	0xb77f, 0xc80a,		0x21, 0
	.dw 0xb7c0, 0xc80a,	0xb7ff, 0xc80a,		0x21, 0
	.dw 0xb840, 0xc80a,	0xb87f, 0xc80a,		0x21, 0
	.dw 0xb8c0, 0xc80a,	0xb8ff, 0xc80a,		0x21, 0
	.dw 0xb940, 0xc80a,	0xb97f, 0xc80a,		0x21, 0
	.dw 0xb9c0, 0xc80a,	0xdfff, 0xc80a,		0x21, 0
	.dw 0xe040, 0xc80a,	0xe07f, 0xc80a,		0x21, 0
	.dw 0xe0c0, 0xc80a,	0xe0ff, 0xc80a,		0x21, 0
	.dw 0xe140, 0xc80a,	0xe17f, 0xc80a,		0x21, 0
	.dw 0xe1c0, 0xc80a,	0xe1ff, 0xc80a,		0x21, 0
	.dw 0xe240, 0xc80a,	0xe27f, 0xc80a,		0x21, 0
	.dw 0xe2c0, 0xc80a,	0xe2ff, 0xc80a,		0x21, 0
	.dw 0xe340, 0xc80a,	0xe37f, 0xc80a,		0x21, 0
	.dw 0xe3c0, 0xc80a,	0xe3ff, 0xc80a,		0x21, 0
	.dw 0xe440, 0xc80a,	0xe47f, 0xc80a,		0x21, 0
	.dw 0xe4c0, 0xc80a,	0xe4ff, 0xc80a,		0x21, 0
	.dw 0xe540, 0xc80a,	0xe57f, 0xc80a,		0x21, 0
	.dw 0xe5c0, 0xc80a,	0xe5ff, 0xc80a,		0x21, 0
	.dw 0xe640, 0xc80a,	0xe67f, 0xc80a,		0x21, 0
	.dw 0xe6c0, 0xc80a,	0xe6ff, 0xc80a,		0x21, 0
	.dw 0xe740, 0xc80a,	0xe77f, 0xc80a,		0x21, 0
	.dw 0xe7c0, 0xc80a,	0xe7ff, 0xc80a,		0x21, 0
	.dw 0xe840, 0xc80a,	0xe87f, 0xc80a,		0x21, 0
	.dw 0xe8c0, 0xc80a,	0xe8ff, 0xc80a,		0x21, 0
	.dw 0xe940, 0xc80a,	0xe97f, 0xc80a,		0x21, 0
	.dw 0xe9c0, 0xc80a,	0xe9ff, 0xc80a,		0x21, 0
	.dw 0xea40, 0xc80a,	0xea7f, 0xc80a,		0x21, 0
	.dw 0xeac0, 0xc80a,	0xeaff, 0xc80a,		0x21, 0
	.dw 0xeb40, 0xc80a,	0xeb7f, 0xc80a,		0x21, 0
	.dw 0xebc0, 0xc80a,	0xebff, 0xc80a,		0x21, 0
	.dw 0xec40, 0xc80a,	0xec7f, 0xc80a,		0x21, 0
	.dw 0xecc0, 0xc80a,	0xecff, 0xc80a,		0x21, 0
	.dw 0xed40, 0xc80a,	0xed7f, 0xc80a,		0x21, 0
	.dw 0xedc0, 0xc80a,	0xedff, 0xc80a,		0x21, 0
	.dw 0xee40, 0xc80a,	0xee7f, 0xc80a,		0x21, 0
	.dw 0xeec0, 0xc80a,	0xeeff, 0xc80a,		0x21, 0
	.dw 0xef40, 0xc80a,	0xef7f, 0xc80a,		0x21, 0
	.dw 0xefc0, 0xc80a,	0xefff, 0xc80a,		0x21, 0
	.dw 0xf040, 0xc80a,	0xf07f, 0xc80a,		0x21, 0
	.dw 0xf0c0, 0xc80a,	0xf0ff, 0xc80a,		0x21, 0
	.dw 0xf140, 0xc80a,	0xf17f, 0xc80a,		0x21, 0
	.dw 0xf1c0, 0xc80a,	0xf1ff, 0xc80a,		0x21, 0
	.dw 0xf240, 0xc80a,	0xf27f, 0xc80a,		0x21, 0
	.dw 0xf2c0, 0xc80a,	0xf2ff, 0xc80a,		0x21, 0
	.dw 0xf340, 0xc80a,	0xf37f, 0xc80a,		0x21, 0
	.dw 0xf3c0, 0xc80a,	0xf3ff, 0xc80a,		0x21, 0
	.dw 0xf440, 0xc80a,	0xf47f, 0xc80a,		0x21, 0
	.dw 0xf4c0, 0xc80a,	0xf4ff, 0xc80a,		0x21, 0
	.dw 0xf540, 0xc80a,	0xf57f, 0xc80a,		0x21, 0
	.dw 0xf5c0, 0xc80a,	0xf5ff, 0xc80a,		0x21, 0
	.dw 0xf640, 0xc80a,	0xf67f, 0xc80a,		0x21, 0
	.dw 0xf6c0, 0xc80a,	0xf6ff, 0xc80a,		0x21, 0
	.dw 0xf740, 0xc80a,	0xf77f, 0xc80a,		0x21, 0
	.dw 0xf7c0, 0xc80a,	0xf7ff, 0xc80a,		0x21, 0
	.dw 0xf840, 0xc80a,	0xf87f, 0xc80a,		0x21, 0
	.dw 0xf8c0, 0xc80a,	0xf8ff, 0xc80a,		0x21, 0
	.dw 0xf940, 0xc80a,	0xf97f, 0xc80a,		0x21, 0
	.dw 0xf9c0, 0xc80a,	0x1fff, 0xc80b,		0x21, 0
	.dw 0x2040, 0xc80b,	0x207f, 0xc80b,		0x21, 0
	.dw 0x20c0, 0xc80b,	0x20ff, 0xc80b,		0x21, 0
	.dw 0x2140, 0xc80b,	0x217f, 0xc80b,		0x21, 0
	.dw 0x21c0, 0xc80b,	0x21ff, 0xc80b,		0x21, 0
	.dw 0x2240, 0xc80b,	0x227f, 0xc80b,		0x21, 0
	.dw 0x22c0, 0xc80b,	0x22ff, 0xc80b,		0x21, 0
	.dw 0x2340, 0xc80b,	0x237f, 0xc80b,		0x21, 0
	.dw 0x23c0, 0xc80b,	0x23ff, 0xc80b,		0x21, 0
	.dw 0x2440, 0xc80b,	0x247f, 0xc80b,		0x21, 0
	.dw 0x24c0, 0xc80b,	0x24ff, 0xc80b,		0x21, 0
	.dw 0x2540, 0xc80b,	0x257f, 0xc80b,		0x21, 0
	.dw 0x25c0, 0xc80b,	0x25ff, 0xc80b,		0x21, 0
	.dw 0x2640, 0xc80b,	0x267f, 0xc80b,		0x21, 0
	.dw 0x26c0, 0xc80b,	0x26ff, 0xc80b,		0x21, 0
	.dw 0x2740, 0xc80b,	0x277f, 0xc80b,		0x21, 0
	.dw 0x27c0, 0xc80b,	0x27ff, 0xc80b,		0x21, 0
	.dw 0x2840, 0xc80b,	0x287f, 0xc80b,		0x21, 0
	.dw 0x28c0, 0xc80b,	0x28ff, 0xc80b,		0x21, 0
	.dw 0x2940, 0xc80b,	0x297f, 0xc80b,		0x21, 0
	.dw 0x29c0, 0xc80b,	0x29ff, 0xc80b,		0x21, 0
	.dw 0x2a40, 0xc80b,	0x2a7f, 0xc80b,		0x21, 0
	.dw 0x2ac0, 0xc80b,	0x2aff, 0xc80b,		0x21, 0
	.dw 0x2b40, 0xc80b,	0x2b7f, 0xc80b,		0x21, 0
	.dw 0x2bc0, 0xc80b,	0x2bff, 0xc80b,		0x21, 0
	.dw 0x2c40, 0xc80b,	0x2c7f, 0xc80b,		0x21, 0
	.dw 0x2cc0, 0xc80b,	0x2cff, 0xc80b,		0x21, 0
	.dw 0x2d40, 0xc80b,	0x2d7f, 0xc80b,		0x21, 0
	.dw 0x2dc0, 0xc80b,	0x2dff, 0xc80b,		0x21, 0
	.dw 0x2e40, 0xc80b,	0x2e7f, 0xc80b,		0x21, 0
	.dw 0x2ec0, 0xc80b,	0x2eff, 0xc80b,		0x21, 0
	.dw 0x2f40, 0xc80b,	0x2f7f, 0xc80b,		0x21, 0
	.dw 0x2fc0, 0xc80b,	0x2fff, 0xc80b,		0x21, 0
	.dw 0x3040, 0xc80b,	0x307f, 0xc80b,		0x21, 0
	.dw 0x30c0, 0xc80b,	0x30ff, 0xc80b,		0x21, 0
	.dw 0x3140, 0xc80b,	0x317f, 0xc80b,		0x21, 0
	.dw 0x31c0, 0xc80b,	0x31ff, 0xc80b,		0x21, 0
	.dw 0x3240, 0xc80b,	0x327f, 0xc80b,		0x21, 0
	.dw 0x32c0, 0xc80b,	0x32ff, 0xc80b,		0x21, 0
	.dw 0x3340, 0xc80b,	0x337f, 0xc80b,		0x21, 0
	.dw 0x33c0, 0xc80b,	0x33ff, 0xc80b,		0x21, 0
	.dw 0x3440, 0xc80b,	0x347f, 0xc80b,		0x21, 0
	.dw 0x34c0, 0xc80b,	0x34ff, 0xc80b,		0x21, 0
	.dw 0x3540, 0xc80b,	0x357f, 0xc80b,		0x21, 0
	.dw 0x35c0, 0xc80b,	0x35ff, 0xc80b,		0x21, 0
	.dw 0x3640, 0xc80b,	0x367f, 0xc80b,		0x21, 0
	.dw 0x36c0, 0xc80b,	0x36ff, 0xc80b,		0x21, 0
	.dw 0x3740, 0xc80b,	0x377f, 0xc80b,		0x21, 0
	.dw 0x37c0, 0xc80b,	0x37ff, 0xc80b,		0x21, 0
	.dw 0x3840, 0xc80b,	0x387f, 0xc80b,		0x21, 0
	.dw 0x38c0, 0xc80b,	0x38ff, 0xc80b,		0x21, 0
	.dw 0x3940, 0xc80b,	0x397f, 0xc80b,		0x21, 0
	.dw 0x39c0, 0xc80b,	0xffff, 0xc80b,		0x21, 0
	.dw 0x0040, 0xc80c,	0x007f, 0xc80c,		0x21, 0
	.dw 0x00c0, 0xc80c,	0x00ff, 0xc80c,		0x21, 0
	.dw 0x0140, 0xc80c,	0x017f, 0xc80c,		0x21, 0
	.dw 0x01c0, 0xc80c,	0x01ff, 0xc80c,		0x21, 0
	.dw 0x0240, 0xc80c,	0x027f, 0xc80c,		0x21, 0
	.dw 0x02c0, 0xc80c,	0x02ff, 0xc80c,		0x21, 0
	.dw 0x0340, 0xc80c,	0x037f, 0xc80c,		0x21, 0
	.dw 0x03c0, 0xc80c,	0x03ff, 0xc80c,		0x21, 0
	.dw 0x0440, 0xc80c,	0x047f, 0xc80c,		0x21, 0
	.dw 0x04c0, 0xc80c,	0x04ff, 0xc80c,		0x21, 0
	.dw 0x0540, 0xc80c,	0x057f, 0xc80c,		0x21, 0
	.dw 0x05c0, 0xc80c,	0x05ff, 0xc80c,		0x21, 0
	.dw 0x0640, 0xc80c,	0x067f, 0xc80c,		0x21, 0
	.dw 0x06c0, 0xc80c,	0x06ff, 0xc80c,		0x21, 0
	.dw 0x0740, 0xc80c,	0x077f, 0xc80c,		0x21, 0
	.dw 0x07c0, 0xc80c,	0x07ff, 0xc80c,		0x21, 0
	.dw 0x0840, 0xc80c,	0x087f, 0xc80c,		0x21, 0
	.dw 0x08c0, 0xc80c,	0x08ff, 0xc80c,		0x21, 0
	.dw 0x0940, 0xc80c,	0x097f, 0xc80c,		0x21, 0
	.dw 0x09c0, 0xc80c,	0x09ff, 0xc80c,		0x21, 0
	.dw 0x0a40, 0xc80c,	0x0a7f, 0xc80c,		0x21, 0
	.dw 0x0ac0, 0xc80c,	0x0aff, 0xc80c,		0x21, 0
	.dw 0x0b40, 0xc80c,	0x0b7f, 0xc80c,		0x21, 0
	.dw 0x0bc0, 0xc80c,	0x0bff, 0xc80c,		0x21, 0
	.dw 0x0c40, 0xc80c,	0x0c7f, 0xc80c,		0x21, 0
	.dw 0x0cc0, 0xc80c,	0x0cff, 0xc80c,		0x21, 0
	.dw 0x0d40, 0xc80c,	0x0d7f, 0xc80c,		0x21, 0
	.dw 0x0dc0, 0xc80c,	0x0dff, 0xc80c,		0x21, 0
	.dw 0x0e40, 0xc80c,	0x0e7f, 0xc80c,		0x21, 0
	.dw 0x0ec0, 0xc80c,	0x0eff, 0xc80c,		0x21, 0
	.dw 0x0f40, 0xc80c,	0x0f7f, 0xc80c,		0x21, 0
	.dw 0x0fc0, 0xc80c,	0x0fff, 0xc80c,		0x21, 0
	.dw 0x1040, 0xc80c,	0x107f, 0xc80c,		0x21, 0
	.dw 0x10c0, 0xc80c,	0x10ff, 0xc80c,		0x21, 0
	.dw 0x1140, 0xc80c,	0x117f, 0xc80c,		0x21, 0
	.dw 0x11c0, 0xc80c,	0x11ff, 0xc80c,		0x21, 0
	.dw 0x1240, 0xc80c,	0x127f, 0xc80c,		0x21, 0
	.dw 0x12c0, 0xc80c,	0x12ff, 0xc80c,		0x21, 0
	.dw 0x1340, 0xc80c,	0x137f, 0xc80c,		0x21, 0
	.dw 0x13c0, 0xc80c,	0x13ff, 0xc80c,		0x21, 0
	.dw 0x1440, 0xc80c,	0x147f, 0xc80c,		0x21, 0
	.dw 0x14c0, 0xc80c,	0x14ff, 0xc80c,		0x21, 0
	.dw 0x1540, 0xc80c,	0x157f, 0xc80c,		0x21, 0
	.dw 0x15c0, 0xc80c,	0x15ff, 0xc80c,		0x21, 0
	.dw 0x1640, 0xc80c,	0x167f, 0xc80c,		0x21, 0
	.dw 0x16c0, 0xc80c,	0x16ff, 0xc80c,		0x21, 0
	.dw 0x1740, 0xc80c,	0x177f, 0xc80c,		0x21, 0
	.dw 0x17c0, 0xc80c,	0x17ff, 0xc80c,		0x21, 0
	.dw 0x1840, 0xc80c,	0x187f, 0xc80c,		0x21, 0
	.dw 0x18c0, 0xc80c,	0x18ff, 0xc80c,		0x21, 0
	.dw 0x1940, 0xc80c,	0x197f, 0xc80c,		0x21, 0
	.dw 0x19c0, 0xc80c,	0x1fff, 0xc80c,		0x21, 0
	.dw 0x2040, 0xc80c,	0x207f, 0xc80c,		0x21, 0
	.dw 0x20c0, 0xc80c,	0x20ff, 0xc80c,		0x21, 0
	.dw 0x2140, 0xc80c,	0x217f, 0xc80c,		0x21, 0
	.dw 0x21c0, 0xc80c,	0x21ff, 0xc80c,		0x21, 0
	.dw 0x2240, 0xc80c,	0x227f, 0xc80c,		0x21, 0
	.dw 0x22c0, 0xc80c,	0x22ff, 0xc80c,		0x21, 0
	.dw 0x2340, 0xc80c,	0x237f, 0xc80c,		0x21, 0
	.dw 0x23c0, 0xc80c,	0x23ff, 0xc80c,		0x21, 0
	.dw 0x2440, 0xc80c,	0x247f, 0xc80c,		0x21, 0
	.dw 0x24c0, 0xc80c,	0x24ff, 0xc80c,		0x21, 0
	.dw 0x2540, 0xc80c,	0x257f, 0xc80c,		0x21, 0
	.dw 0x25c0, 0xc80c,	0x25ff, 0xc80c,		0x21, 0
	.dw 0x2640, 0xc80c,	0x267f, 0xc80c,		0x21, 0
	.dw 0x26c0, 0xc80c,	0x26ff, 0xc80c,		0x21, 0
	.dw 0x2740, 0xc80c,	0x277f, 0xc80c,		0x21, 0
	.dw 0x27c0, 0xc80c,	0x27ff, 0xc80c,		0x21, 0
	.dw 0x2840, 0xc80c,	0x287f, 0xc80c,		0x21, 0
	.dw 0x28c0, 0xc80c,	0x28ff, 0xc80c,		0x21, 0
	.dw 0x2940, 0xc80c,	0x297f, 0xc80c,		0x21, 0
	.dw 0x29c0, 0xc80c,	0x29ff, 0xc80c,		0x21, 0
	.dw 0x2a40, 0xc80c,	0x2a7f, 0xc80c,		0x21, 0
	.dw 0x2ac0, 0xc80c,	0x2aff, 0xc80c,		0x21, 0
	.dw 0x2b40, 0xc80c,	0x2b7f, 0xc80c,		0x21, 0
	.dw 0x2bc0, 0xc80c,	0x2bff, 0xc80c,		0x21, 0
	.dw 0x2c40, 0xc80c,	0x2c7f, 0xc80c,		0x21, 0
	.dw 0x2cc0, 0xc80c,	0x2cff, 0xc80c,		0x21, 0
	.dw 0x2d40, 0xc80c,	0x2d7f, 0xc80c,		0x21, 0
	.dw 0x2dc0, 0xc80c,	0x2dff, 0xc80c,		0x21, 0
	.dw 0x2e40, 0xc80c,	0x2e7f, 0xc80c,		0x21, 0
	.dw 0x2ec0, 0xc80c,	0x2eff, 0xc80c,		0x21, 0
	.dw 0x2f40, 0xc80c,	0x2f7f, 0xc80c,		0x21, 0
	.dw 0x2fc0, 0xc80c,	0x2fff, 0xc80c,		0x21, 0
	.dw 0x3040, 0xc80c,	0x307f, 0xc80c,		0x21, 0
	.dw 0x30c0, 0xc80c,	0x30ff, 0xc80c,		0x21, 0
	.dw 0x3140, 0xc80c,	0x317f, 0xc80c,		0x21, 0
	.dw 0x31c0, 0xc80c,	0x31ff, 0xc80c,		0x21, 0
	.dw 0x3240, 0xc80c,	0x327f, 0xc80c,		0x21, 0
	.dw 0x32c0, 0xc80c,	0x32ff, 0xc80c,		0x21, 0
	.dw 0x3340, 0xc80c,	0x337f, 0xc80c,		0x21, 0
	.dw 0x33c0, 0xc80c,	0x33ff, 0xc80c,		0x21, 0
	.dw 0x3440, 0xc80c,	0x347f, 0xc80c,		0x21, 0
	.dw 0x34c0, 0xc80c,	0x34ff, 0xc80c,		0x21, 0
	.dw 0x3540, 0xc80c,	0x357f, 0xc80c,		0x21, 0
	.dw 0x35c0, 0xc80c,	0x35ff, 0xc80c,		0x21, 0
	.dw 0x3640, 0xc80c,	0x367f, 0xc80c,		0x21, 0
	.dw 0x36c0, 0xc80c,	0x36ff, 0xc80c,		0x21, 0
	.dw 0x3740, 0xc80c,	0x377f, 0xc80c,		0x21, 0
	.dw 0x37c0, 0xc80c,	0x37ff, 0xc80c,		0x21, 0
	.dw 0x3840, 0xc80c,	0x387f, 0xc80c,		0x21, 0
	.dw 0x38c0, 0xc80c,	0x38ff, 0xc80c,		0x21, 0
	.dw 0x3940, 0xc80c,	0x397f, 0xc80c,		0x21, 0
	.dw 0x39c0, 0xc80c,	0x3fff, 0xc80c,		0x21, 0
	.dw 0x4040, 0xc80c,	0x407f, 0xc80c,		0x21, 0
	.dw 0x40c0, 0xc80c,	0x40ff, 0xc80c,		0x21, 0
	.dw 0x4140, 0xc80c,	0x417f, 0xc80c,		0x21, 0
	.dw 0x41c0, 0xc80c,	0x41ff, 0xc80c,		0x21, 0
	.dw 0x4240, 0xc80c,	0x427f, 0xc80c,		0x21, 0
	.dw 0x42c0, 0xc80c,	0x42ff, 0xc80c,		0x21, 0
	.dw 0x4340, 0xc80c,	0x437f, 0xc80c,		0x21, 0
	.dw 0x43c0, 0xc80c,	0x43ff, 0xc80c,		0x21, 0
	.dw 0x4440, 0xc80c,	0x447f, 0xc80c,		0x21, 0
	.dw 0x44c0, 0xc80c,	0x44ff, 0xc80c,		0x21, 0
	.dw 0x4540, 0xc80c,	0x457f, 0xc80c,		0x21, 0
	.dw 0x45c0, 0xc80c,	0x45ff, 0xc80c,		0x21, 0
	.dw 0x4640, 0xc80c,	0x467f, 0xc80c,		0x21, 0
	.dw 0x46c0, 0xc80c,	0x46ff, 0xc80c,		0x21, 0
	.dw 0x4740, 0xc80c,	0x477f, 0xc80c,		0x21, 0
	.dw 0x47c0, 0xc80c,	0x47ff, 0xc80c,		0x21, 0
	.dw 0x4840, 0xc80c,	0x487f, 0xc80c,		0x21, 0
	.dw 0x48c0, 0xc80c,	0x48ff, 0xc80c,		0x21, 0
	.dw 0x4940, 0xc80c,	0x497f, 0xc80c,		0x21, 0
	.dw 0x49c0, 0xc80c,	0x49ff, 0xc80c,		0x21, 0
	.dw 0x4a40, 0xc80c,	0x4a7f, 0xc80c,		0x21, 0
	.dw 0x4ac0, 0xc80c,	0x4aff, 0xc80c,		0x21, 0
	.dw 0x4b40, 0xc80c,	0x4b7f, 0xc80c,		0x21, 0
	.dw 0x4bc0, 0xc80c,	0x4bff, 0xc80c,		0x21, 0
	.dw 0x4c40, 0xc80c,	0x4c7f, 0xc80c,		0x21, 0
	.dw 0x4cc0, 0xc80c,	0x4cff, 0xc80c,		0x21, 0
	.dw 0x4d40, 0xc80c,	0x4d7f, 0xc80c,		0x21, 0
	.dw 0x4dc0, 0xc80c,	0x4dff, 0xc80c,		0x21, 0
	.dw 0x4e40, 0xc80c,	0x4e7f, 0xc80c,		0x21, 0
	.dw 0x4ec0, 0xc80c,	0x4eff, 0xc80c,		0x21, 0
	.dw 0x4f40, 0xc80c,	0x4f7f, 0xc80c,		0x21, 0
	.dw 0x4fc0, 0xc80c,	0x4fff, 0xc80c,		0x21, 0
	.dw 0x5040, 0xc80c,	0x507f, 0xc80c,		0x21, 0
	.dw 0x50c0, 0xc80c,	0x50ff, 0xc80c,		0x21, 0
	.dw 0x5140, 0xc80c,	0x517f, 0xc80c,		0x21, 0
	.dw 0x51c0, 0xc80c,	0x51ff, 0xc80c,		0x21, 0
	.dw 0x5240, 0xc80c,	0x527f, 0xc80c,		0x21, 0
	.dw 0x52c0, 0xc80c,	0x52ff, 0xc80c,		0x21, 0
	.dw 0x5340, 0xc80c,	0x537f, 0xc80c,		0x21, 0
	.dw 0x53c0, 0xc80c,	0x53ff, 0xc80c,		0x21, 0
	.dw 0x5440, 0xc80c,	0x547f, 0xc80c,		0x21, 0
	.dw 0x54c0, 0xc80c,	0x54ff, 0xc80c,		0x21, 0
	.dw 0x5540, 0xc80c,	0x557f, 0xc80c,		0x21, 0
	.dw 0x55c0, 0xc80c,	0x55ff, 0xc80c,		0x21, 0
	.dw 0x5640, 0xc80c,	0x567f, 0xc80c,		0x21, 0
	.dw 0x56c0, 0xc80c,	0x56ff, 0xc80c,		0x21, 0
	.dw 0x5740, 0xc80c,	0x577f, 0xc80c,		0x21, 0
	.dw 0x57c0, 0xc80c,	0x57ff, 0xc80c,		0x21, 0
	.dw 0x5840, 0xc80c,	0x587f, 0xc80c,		0x21, 0
	.dw 0x58c0, 0xc80c,	0x58ff, 0xc80c,		0x21, 0
	.dw 0x5940, 0xc80c,	0x597f, 0xc80c,		0x21, 0
	.dw 0x59c0, 0xc80c,	0x5fff, 0xc80c,		0x21, 0
	.dw 0x6040, 0xc80c,	0x607f, 0xc80c,		0x21, 0
	.dw 0x60c0, 0xc80c,	0x60ff, 0xc80c,		0x21, 0
	.dw 0x6140, 0xc80c,	0x617f, 0xc80c,		0x21, 0
	.dw 0x61c0, 0xc80c,	0x61ff, 0xc80c,		0x21, 0
	.dw 0x6240, 0xc80c,	0x627f, 0xc80c,		0x21, 0
	.dw 0x62c0, 0xc80c,	0x62ff, 0xc80c,		0x21, 0
	.dw 0x6340, 0xc80c,	0x637f, 0xc80c,		0x21, 0
	.dw 0x63c0, 0xc80c,	0x63ff, 0xc80c,		0x21, 0
	.dw 0x6440, 0xc80c,	0x647f, 0xc80c,		0x21, 0
	.dw 0x64c0, 0xc80c,	0x64ff, 0xc80c,		0x21, 0
	.dw 0x6540, 0xc80c,	0x657f, 0xc80c,		0x21, 0
	.dw 0x65c0, 0xc80c,	0x65ff, 0xc80c,		0x21, 0
	.dw 0x6640, 0xc80c,	0x667f, 0xc80c,		0x21, 0
	.dw 0x66c0, 0xc80c,	0x66ff, 0xc80c,		0x21, 0
	.dw 0x6740, 0xc80c,	0x677f, 0xc80c,		0x21, 0
	.dw 0x67c0, 0xc80c,	0x67ff, 0xc80c,		0x21, 0
	.dw 0x6840, 0xc80c,	0x687f, 0xc80c,		0x21, 0
	.dw 0x68c0, 0xc80c,	0x68ff, 0xc80c,		0x21, 0
	.dw 0x6940, 0xc80c,	0x697f, 0xc80c,		0x21, 0
	.dw 0x69c0, 0xc80c,	0x69ff, 0xc80c,		0x21, 0
	.dw 0x6a40, 0xc80c,	0x6a7f, 0xc80c,		0x21, 0
	.dw 0x6ac0, 0xc80c,	0x6aff, 0xc80c,		0x21, 0
	.dw 0x6b40, 0xc80c,	0x6b7f, 0xc80c,		0x21, 0
	.dw 0x6bc0, 0xc80c,	0x6bff, 0xc80c,		0x21, 0
	.dw 0x6c40, 0xc80c,	0x6c7f, 0xc80c,		0x21, 0
	.dw 0x6cc0, 0xc80c,	0x6cff, 0xc80c,		0x21, 0
	.dw 0x6d40, 0xc80c,	0x6d7f, 0xc80c,		0x21, 0
	.dw 0x6dc0, 0xc80c,	0x6dff, 0xc80c,		0x21, 0
	.dw 0x6e40, 0xc80c,	0x6e7f, 0xc80c,		0x21, 0
	.dw 0x6ec0, 0xc80c,	0x6eff, 0xc80c,		0x21, 0
	.dw 0x6f40, 0xc80c,	0x6f7f, 0xc80c,		0x21, 0
	.dw 0x6fc0, 0xc80c,	0x6fff, 0xc80c,		0x21, 0
	.dw 0x7040, 0xc80c,	0x707f, 0xc80c,		0x21, 0
	.dw 0x70c0, 0xc80c,	0x70ff, 0xc80c,		0x21, 0
	.dw 0x7140, 0xc80c,	0x717f, 0xc80c,		0x21, 0
	.dw 0x71c0, 0xc80c,	0x71ff, 0xc80c,		0x21, 0
	.dw 0x7240, 0xc80c,	0x727f, 0xc80c,		0x21, 0
	.dw 0x72c0, 0xc80c,	0x72ff, 0xc80c,		0x21, 0
	.dw 0x7340, 0xc80c,	0x737f, 0xc80c,		0x21, 0
	.dw 0x73c0, 0xc80c,	0x73ff, 0xc80c,		0x21, 0
	.dw 0x7440, 0xc80c,	0x747f, 0xc80c,		0x21, 0
	.dw 0x74c0, 0xc80c,	0x74ff, 0xc80c,		0x21, 0
	.dw 0x7540, 0xc80c,	0x757f, 0xc80c,		0x21, 0
	.dw 0x75c0, 0xc80c,	0x75ff, 0xc80c,		0x21, 0
	.dw 0x7640, 0xc80c,	0x767f, 0xc80c,		0x21, 0
	.dw 0x76c0, 0xc80c,	0x76ff, 0xc80c,		0x21, 0
	.dw 0x7740, 0xc80c,	0x777f, 0xc80c,		0x21, 0
	.dw 0x77c0, 0xc80c,	0x77ff, 0xc80c,		0x21, 0
	.dw 0x7840, 0xc80c,	0x787f, 0xc80c,		0x21, 0
	.dw 0x78c0, 0xc80c,	0x78ff, 0xc80c,		0x21, 0
	.dw 0x7940, 0xc80c,	0x797f, 0xc80c,		0x21, 0
	.dw 0x79c0, 0xc80c,	0x7fff, 0xc80c,		0x21, 0
	.dw 0x8040, 0xc80c,	0x807f, 0xc80c,		0x21, 0
	.dw 0x80c0, 0xc80c,	0x80ff, 0xc80c,		0x21, 0
	.dw 0x8140, 0xc80c,	0x817f, 0xc80c,		0x21, 0
	.dw 0x81c0, 0xc80c,	0x81ff, 0xc80c,		0x21, 0
	.dw 0x8240, 0xc80c,	0x827f, 0xc80c,		0x21, 0
	.dw 0x82c0, 0xc80c,	0x82ff, 0xc80c,		0x21, 0
	.dw 0x8340, 0xc80c,	0x837f, 0xc80c,		0x21, 0
	.dw 0x83c0, 0xc80c,	0x83ff, 0xc80c,		0x21, 0
	.dw 0x8440, 0xc80c,	0x847f, 0xc80c,		0x21, 0
	.dw 0x84c0, 0xc80c,	0x84ff, 0xc80c,		0x21, 0
	.dw 0x8540, 0xc80c,	0x857f, 0xc80c,		0x21, 0
	.dw 0x85c0, 0xc80c,	0x85ff, 0xc80c,		0x21, 0
	.dw 0x8640, 0xc80c,	0x867f, 0xc80c,		0x21, 0
	.dw 0x86c0, 0xc80c,	0x86ff, 0xc80c,		0x21, 0
	.dw 0x8740, 0xc80c,	0x877f, 0xc80c,		0x21, 0
	.dw 0x87c0, 0xc80c,	0x87ff, 0xc80c,		0x21, 0
	.dw 0x8840, 0xc80c,	0x887f, 0xc80c,		0x21, 0
	.dw 0x88c0, 0xc80c,	0x88ff, 0xc80c,		0x21, 0
	.dw 0x8940, 0xc80c,	0x897f, 0xc80c,		0x21, 0
	.dw 0x89c0, 0xc80c,	0x89ff, 0xc80c,		0x21, 0
	.dw 0x8a40, 0xc80c,	0x8a7f, 0xc80c,		0x21, 0
	.dw 0x8ac0, 0xc80c,	0x8aff, 0xc80c,		0x21, 0
	.dw 0x8b40, 0xc80c,	0x8b7f, 0xc80c,		0x21, 0
	.dw 0x8bc0, 0xc80c,	0x8bff, 0xc80c,		0x21, 0
	.dw 0x8c40, 0xc80c,	0x8c7f, 0xc80c,		0x21, 0
	.dw 0x8cc0, 0xc80c,	0x8cff, 0xc80c,		0x21, 0
	.dw 0x8d40, 0xc80c,	0x8d7f, 0xc80c,		0x21, 0
	.dw 0x8dc0, 0xc80c,	0x8dff, 0xc80c,		0x21, 0
	.dw 0x8e40, 0xc80c,	0x8e7f, 0xc80c,		0x21, 0
	.dw 0x8ec0, 0xc80c,	0x8eff, 0xc80c,		0x21, 0
	.dw 0x8f40, 0xc80c,	0x8f7f, 0xc80c,		0x21, 0
	.dw 0x8fc0, 0xc80c,	0x8fff, 0xc80c,		0x21, 0
	.dw 0x9040, 0xc80c,	0x907f, 0xc80c,		0x21, 0
	.dw 0x90c0, 0xc80c,	0x90ff, 0xc80c,		0x21, 0
	.dw 0x9140, 0xc80c,	0x917f, 0xc80c,		0x21, 0
	.dw 0x91c0, 0xc80c,	0x91ff, 0xc80c,		0x21, 0
	.dw 0x9240, 0xc80c,	0x927f, 0xc80c,		0x21, 0
	.dw 0x92c0, 0xc80c,	0x92ff, 0xc80c,		0x21, 0
	.dw 0x9340, 0xc80c,	0x937f, 0xc80c,		0x21, 0
	.dw 0x93c0, 0xc80c,	0x93ff, 0xc80c,		0x21, 0
	.dw 0x9440, 0xc80c,	0x947f, 0xc80c,		0x21, 0
	.dw 0x94c0, 0xc80c,	0x94ff, 0xc80c,		0x21, 0
	.dw 0x9540, 0xc80c,	0x957f, 0xc80c,		0x21, 0
	.dw 0x95c0, 0xc80c,	0x95ff, 0xc80c,		0x21, 0
	.dw 0x9640, 0xc80c,	0x967f, 0xc80c,		0x21, 0
	.dw 0x96c0, 0xc80c,	0x96ff, 0xc80c,		0x21, 0
	.dw 0x9740, 0xc80c,	0x977f, 0xc80c,		0x21, 0
	.dw 0x97c0, 0xc80c,	0x97ff, 0xc80c,		0x21, 0
	.dw 0x9840, 0xc80c,	0x987f, 0xc80c,		0x21, 0
	.dw 0x98c0, 0xc80c,	0x98ff, 0xc80c,		0x21, 0
	.dw 0x9940, 0xc80c,	0x997f, 0xc80c,		0x21, 0
	.dw 0x99c0, 0xc80c,	0x9fff, 0xc80c,		0x21, 0
	.dw 0xa040, 0xc80c,	0xa07f, 0xc80c,		0x21, 0
	.dw 0xa0c0, 0xc80c,	0xa0ff, 0xc80c,		0x21, 0
	.dw 0xa140, 0xc80c,	0xa17f, 0xc80c,		0x21, 0
	.dw 0xa1c0, 0xc80c,	0xa1ff, 0xc80c,		0x21, 0
	.dw 0xa240, 0xc80c,	0xa27f, 0xc80c,		0x21, 0
	.dw 0xa2c0, 0xc80c,	0xa2ff, 0xc80c,		0x21, 0
	.dw 0xa340, 0xc80c,	0xa37f, 0xc80c,		0x21, 0
	.dw 0xa3c0, 0xc80c,	0xa3ff, 0xc80c,		0x21, 0
	.dw 0xa440, 0xc80c,	0xa47f, 0xc80c,		0x21, 0
	.dw 0xa4c0, 0xc80c,	0xa4ff, 0xc80c,		0x21, 0
	.dw 0xa540, 0xc80c,	0xa57f, 0xc80c,		0x21, 0
	.dw 0xa5c0, 0xc80c,	0xa5ff, 0xc80c,		0x21, 0
	.dw 0xa640, 0xc80c,	0xa67f, 0xc80c,		0x21, 0
	.dw 0xa6c0, 0xc80c,	0xa6ff, 0xc80c,		0x21, 0
	.dw 0xa740, 0xc80c,	0xa77f, 0xc80c,		0x21, 0
	.dw 0xa7c0, 0xc80c,	0xa7ff, 0xc80c,		0x21, 0
	.dw 0xa840, 0xc80c,	0xa87f, 0xc80c,		0x21, 0
	.dw 0xa8c0, 0xc80c,	0xa8ff, 0xc80c,		0x21, 0
	.dw 0xa940, 0xc80c,	0xa97f, 0xc80c,		0x21, 0
	.dw 0xa9c0, 0xc80c,	0xa9ff, 0xc80c,		0x21, 0
	.dw 0xaa40, 0xc80c,	0xaa7f, 0xc80c,		0x21, 0
	.dw 0xaac0, 0xc80c,	0xaaff, 0xc80c,		0x21, 0
	.dw 0xab40, 0xc80c,	0xab7f, 0xc80c,		0x21, 0
	.dw 0xabc0, 0xc80c,	0xabff, 0xc80c,		0x21, 0
	.dw 0xac40, 0xc80c,	0xac7f, 0xc80c,		0x21, 0
	.dw 0xacc0, 0xc80c,	0xacff, 0xc80c,		0x21, 0
	.dw 0xad40, 0xc80c,	0xad7f, 0xc80c,		0x21, 0
	.dw 0xadc0, 0xc80c,	0xadff, 0xc80c,		0x21, 0
	.dw 0xae40, 0xc80c,	0xae7f, 0xc80c,		0x21, 0
	.dw 0xaec0, 0xc80c,	0xaeff, 0xc80c,		0x21, 0
	.dw 0xaf40, 0xc80c,	0xaf7f, 0xc80c,		0x21, 0
	.dw 0xafc0, 0xc80c,	0xafff, 0xc80c,		0x21, 0
	.dw 0xb040, 0xc80c,	0xb07f, 0xc80c,		0x21, 0
	.dw 0xb0c0, 0xc80c,	0xb0ff, 0xc80c,		0x21, 0
	.dw 0xb140, 0xc80c,	0xb17f, 0xc80c,		0x21, 0
	.dw 0xb1c0, 0xc80c,	0xb1ff, 0xc80c,		0x21, 0
	.dw 0xb240, 0xc80c,	0xb27f, 0xc80c,		0x21, 0
	.dw 0xb2c0, 0xc80c,	0xb2ff, 0xc80c,		0x21, 0
	.dw 0xb340, 0xc80c,	0xb37f, 0xc80c,		0x21, 0
	.dw 0xb3c0, 0xc80c,	0xb3ff, 0xc80c,		0x21, 0
	.dw 0xb440, 0xc80c,	0xb47f, 0xc80c,		0x21, 0
	.dw 0xb4c0, 0xc80c,	0xb4ff, 0xc80c,		0x21, 0
	.dw 0xb540, 0xc80c,	0xb57f, 0xc80c,		0x21, 0
	.dw 0xb5c0, 0xc80c,	0xb5ff, 0xc80c,		0x21, 0
	.dw 0xb640, 0xc80c,	0xb67f, 0xc80c,		0x21, 0
	.dw 0xb6c0, 0xc80c,	0xb6ff, 0xc80c,		0x21, 0
	.dw 0xb740, 0xc80c,	0xb77f, 0xc80c,		0x21, 0
	.dw 0xb7c0, 0xc80c,	0xb7ff, 0xc80c,		0x21, 0
	.dw 0xb840, 0xc80c,	0xb87f, 0xc80c,		0x21, 0
	.dw 0xb8c0, 0xc80c,	0xb8ff, 0xc80c,		0x21, 0
	.dw 0xb940, 0xc80c,	0xb97f, 0xc80c,		0x21, 0
	.dw 0xb9c0, 0xc80c,	0xbfff, 0xc80c,		0x21, 0
	.dw 0xc040, 0xc80c,	0xc07f, 0xc80c,		0x21, 0
	.dw 0xc0c0, 0xc80c,	0xc0ff, 0xc80c,		0x21, 0
	.dw 0xc140, 0xc80c,	0xc17f, 0xc80c,		0x21, 0
	.dw 0xc1c0, 0xc80c,	0xc1ff, 0xc80c,		0x21, 0
	.dw 0xc240, 0xc80c,	0xc27f, 0xc80c,		0x21, 0
	.dw 0xc2c0, 0xc80c,	0xc2ff, 0xc80c,		0x21, 0
	.dw 0xc340, 0xc80c,	0xc37f, 0xc80c,		0x21, 0
	.dw 0xc3c0, 0xc80c,	0xc3ff, 0xc80c,		0x21, 0
	.dw 0xc440, 0xc80c,	0xc47f, 0xc80c,		0x21, 0
	.dw 0xc4c0, 0xc80c,	0xc4ff, 0xc80c,		0x21, 0
	.dw 0xc540, 0xc80c,	0xc57f, 0xc80c,		0x21, 0
	.dw 0xc5c0, 0xc80c,	0xc5ff, 0xc80c,		0x21, 0
	.dw 0xc640, 0xc80c,	0xc67f, 0xc80c,		0x21, 0
	.dw 0xc6c0, 0xc80c,	0xc6ff, 0xc80c,		0x21, 0
	.dw 0xc740, 0xc80c,	0xc77f, 0xc80c,		0x21, 0
	.dw 0xc7c0, 0xc80c,	0xc7ff, 0xc80c,		0x21, 0
	.dw 0xc840, 0xc80c,	0xc87f, 0xc80c,		0x21, 0
	.dw 0xc8c0, 0xc80c,	0xc8ff, 0xc80c,		0x21, 0
	.dw 0xc940, 0xc80c,	0xc97f, 0xc80c,		0x21, 0
	.dw 0xc9c0, 0xc80c,	0xc9ff, 0xc80c,		0x21, 0
	.dw 0xca40, 0xc80c,	0xca7f, 0xc80c,		0x21, 0
	.dw 0xcac0, 0xc80c,	0xcaff, 0xc80c,		0x21, 0
	.dw 0xcb40, 0xc80c,	0xcb7f, 0xc80c,		0x21, 0
	.dw 0xcbc0, 0xc80c,	0xcbff, 0xc80c,		0x21, 0
	.dw 0xcc40, 0xc80c,	0xcc7f, 0xc80c,		0x21, 0
	.dw 0xccc0, 0xc80c,	0xccff, 0xc80c,		0x21, 0
	.dw 0xcd40, 0xc80c,	0xcd7f, 0xc80c,		0x21, 0
	.dw 0xcdc0, 0xc80c,	0xcdff, 0xc80c,		0x21, 0
	.dw 0xce40, 0xc80c,	0xce7f, 0xc80c,		0x21, 0
	.dw 0xcec0, 0xc80c,	0xceff, 0xc80c,		0x21, 0
	.dw 0xcf40, 0xc80c,	0xcf7f, 0xc80c,		0x21, 0
	.dw 0xcfc0, 0xc80c,	0xcfff, 0xc80c,		0x21, 0
	.dw 0xd040, 0xc80c,	0xd07f, 0xc80c,		0x21, 0
	.dw 0xd0c0, 0xc80c,	0xd0ff, 0xc80c,		0x21, 0
	.dw 0xd140, 0xc80c,	0xd17f, 0xc80c,		0x21, 0
	.dw 0xd1c0, 0xc80c,	0xd1ff, 0xc80c,		0x21, 0
	.dw 0xd240, 0xc80c,	0xd27f, 0xc80c,		0x21, 0
	.dw 0xd2c0, 0xc80c,	0xd2ff, 0xc80c,		0x21, 0
	.dw 0xd340, 0xc80c,	0xd37f, 0xc80c,		0x21, 0
	.dw 0xd3c0, 0xc80c,	0xd3ff, 0xc80c,		0x21, 0
	.dw 0xd440, 0xc80c,	0xd47f, 0xc80c,		0x21, 0
	.dw 0xd4c0, 0xc80c,	0xd4ff, 0xc80c,		0x21, 0
	.dw 0xd540, 0xc80c,	0xd57f, 0xc80c,		0x21, 0
	.dw 0xd5c0, 0xc80c,	0xd5ff, 0xc80c,		0x21, 0
	.dw 0xd640, 0xc80c,	0xd67f, 0xc80c,		0x21, 0
	.dw 0xd6c0, 0xc80c,	0xd6ff, 0xc80c,		0x21, 0
	.dw 0xd740, 0xc80c,	0xd77f, 0xc80c,		0x21, 0
	.dw 0xd7c0, 0xc80c,	0xd7ff, 0xc80c,		0x21, 0
	.dw 0xd840, 0xc80c,	0xd87f, 0xc80c,		0x21, 0
	.dw 0xd8c0, 0xc80c,	0xd8ff, 0xc80c,		0x21, 0
	.dw 0xd940, 0xc80c,	0xd97f, 0xc80c,		0x21, 0
	.dw 0xd9c0, 0xc80c,	0xdfff, 0xc80c,		0x21, 0
	.dw 0xe040, 0xc80c,	0xe07f, 0xc80c,		0x21, 0
	.dw 0xe0c0, 0xc80c,	0xe0ff, 0xc80c,		0x21, 0
	.dw 0xe140, 0xc80c,	0xe17f, 0xc80c,		0x21, 0
	.dw 0xe1c0, 0xc80c,	0xe1ff, 0xc80c,		0x21, 0
	.dw 0xe240, 0xc80c,	0xe27f, 0xc80c,		0x21, 0
	.dw 0xe2c0, 0xc80c,	0xe2ff, 0xc80c,		0x21, 0
	.dw 0xe340, 0xc80c,	0xe37f, 0xc80c,		0x21, 0
	.dw 0xe3c0, 0xc80c,	0xe3ff, 0xc80c,		0x21, 0
	.dw 0xe440, 0xc80c,	0xe47f, 0xc80c,		0x21, 0
	.dw 0xe4c0, 0xc80c,	0xe4ff, 0xc80c,		0x21, 0
	.dw 0xe540, 0xc80c,	0xe57f, 0xc80c,		0x21, 0
	.dw 0xe5c0, 0xc80c,	0xe5ff, 0xc80c,		0x21, 0
	.dw 0xe640, 0xc80c,	0xe67f, 0xc80c,		0x21, 0
	.dw 0xe6c0, 0xc80c,	0xe6ff, 0xc80c,		0x21, 0
	.dw 0xe740, 0xc80c,	0xe77f, 0xc80c,		0x21, 0
	.dw 0xe7c0, 0xc80c,	0xe7ff, 0xc80c,		0x21, 0
	.dw 0xe840, 0xc80c,	0xe87f, 0xc80c,		0x21, 0
	.dw 0xe8c0, 0xc80c,	0xe8ff, 0xc80c,		0x21, 0
	.dw 0xe940, 0xc80c,	0xe97f, 0xc80c,		0x21, 0
	.dw 0xe9c0, 0xc80c,	0xe9ff, 0xc80c,		0x21, 0
	.dw 0xea40, 0xc80c,	0xea7f, 0xc80c,		0x21, 0
	.dw 0xeac0, 0xc80c,	0xeaff, 0xc80c,		0x21, 0
	.dw 0xeb40, 0xc80c,	0xeb7f, 0xc80c,		0x21, 0
	.dw 0xebc0, 0xc80c,	0xebff, 0xc80c,		0x21, 0
	.dw 0xec40, 0xc80c,	0xec7f, 0xc80c,		0x21, 0
	.dw 0xecc0, 0xc80c,	0xecff, 0xc80c,		0x21, 0
	.dw 0xed40, 0xc80c,	0xed7f, 0xc80c,		0x21, 0
	.dw 0xedc0, 0xc80c,	0xedff, 0xc80c,		0x21, 0
	.dw 0xee40, 0xc80c,	0xee7f, 0xc80c,		0x21, 0
	.dw 0xeec0, 0xc80c,	0xeeff, 0xc80c,		0x21, 0
	.dw 0xef40, 0xc80c,	0xef7f, 0xc80c,		0x21, 0
	.dw 0xefc0, 0xc80c,	0xefff, 0xc80c,		0x21, 0
	.dw 0xf040, 0xc80c,	0xf07f, 0xc80c,		0x21, 0
	.dw 0xf0c0, 0xc80c,	0xf0ff, 0xc80c,		0x21, 0
	.dw 0xf140, 0xc80c,	0xf17f, 0xc80c,		0x21, 0
	.dw 0xf1c0, 0xc80c,	0xf1ff, 0xc80c,		0x21, 0
	.dw 0xf240, 0xc80c,	0xf27f, 0xc80c,		0x21, 0
	.dw 0xf2c0, 0xc80c,	0xf2ff, 0xc80c,		0x21, 0
	.dw 0xf340, 0xc80c,	0xf37f, 0xc80c,		0x21, 0
	.dw 0xf3c0, 0xc80c,	0xf3ff, 0xc80c,		0x21, 0
	.dw 0xf440, 0xc80c,	0xf47f, 0xc80c,		0x21, 0
	.dw 0xf4c0, 0xc80c,	0xf4ff, 0xc80c,		0x21, 0
	.dw 0xf540, 0xc80c,	0xf57f, 0xc80c,		0x21, 0
	.dw 0xf5c0, 0xc80c,	0xf5ff, 0xc80c,		0x21, 0
	.dw 0xf640, 0xc80c,	0xf67f, 0xc80c,		0x21, 0
	.dw 0xf6c0, 0xc80c,	0xf6ff, 0xc80c,		0x21, 0
	.dw 0xf740, 0xc80c,	0xf77f, 0xc80c,		0x21, 0
	.dw 0xf7c0, 0xc80c,	0xf7ff, 0xc80c,		0x21, 0
	.dw 0xf840, 0xc80c,	0xf87f, 0xc80c,		0x21, 0
	.dw 0xf8c0, 0xc80c,	0xf8ff, 0xc80c,		0x21, 0
	.dw 0xf940, 0xc80c,	0xf97f, 0xc80c,		0x21, 0
	.dw 0xf9c0, 0xc80c,	0xffff, 0xc80c,		0x21, 0
	.dw 0x0040, 0xc80d,	0x007f, 0xc80d,		0x21, 0
	.dw 0x00c0, 0xc80d,	0x00ff, 0xc80d,		0x21, 0
	.dw 0x0140, 0xc80d,	0x017f, 0xc80d,		0x21, 0
	.dw 0x01c0, 0xc80d,	0x01ff, 0xc80d,		0x21, 0
	.dw 0x0240, 0xc80d,	0x027f, 0xc80d,		0x21, 0
	.dw 0x02c0, 0xc80d,	0x02ff, 0xc80d,		0x21, 0
	.dw 0x0340, 0xc80d,	0x037f, 0xc80d,		0x21, 0
	.dw 0x03c0, 0xc80d,	0x03ff, 0xc80d,		0x21, 0
	.dw 0x0440, 0xc80d,	0x047f, 0xc80d,		0x21, 0
	.dw 0x04c0, 0xc80d,	0x04ff, 0xc80d,		0x21, 0
	.dw 0x0540, 0xc80d,	0x057f, 0xc80d,		0x21, 0
	.dw 0x05c0, 0xc80d,	0x05ff, 0xc80d,		0x21, 0
	.dw 0x0640, 0xc80d,	0x067f, 0xc80d,		0x21, 0
	.dw 0x06c0, 0xc80d,	0x06ff, 0xc80d,		0x21, 0
	.dw 0x0740, 0xc80d,	0x077f, 0xc80d,		0x21, 0
	.dw 0x07c0, 0xc80d,	0x07ff, 0xc80d,		0x21, 0
	.dw 0x0840, 0xc80d,	0x087f, 0xc80d,		0x21, 0
	.dw 0x08c0, 0xc80d,	0x08ff, 0xc80d,		0x21, 0
	.dw 0x0940, 0xc80d,	0x097f, 0xc80d,		0x21, 0
	.dw 0x09c0, 0xc80d,	0x09ff, 0xc80d,		0x21, 0
	.dw 0x0a40, 0xc80d,	0x0a7f, 0xc80d,		0x21, 0
	.dw 0x0ac0, 0xc80d,	0x0aff, 0xc80d,		0x21, 0
	.dw 0x0b40, 0xc80d,	0x0b7f, 0xc80d,		0x21, 0
	.dw 0x0bc0, 0xc80d,	0x0bff, 0xc80d,		0x21, 0
	.dw 0x0c40, 0xc80d,	0x0c7f, 0xc80d,		0x21, 0
	.dw 0x0cc0, 0xc80d,	0x0cff, 0xc80d,		0x21, 0
	.dw 0x0d40, 0xc80d,	0x0d7f, 0xc80d,		0x21, 0
	.dw 0x0dc0, 0xc80d,	0x0dff, 0xc80d,		0x21, 0
	.dw 0x0e40, 0xc80d,	0x0e7f, 0xc80d,		0x21, 0
	.dw 0x0ec0, 0xc80d,	0x0eff, 0xc80d,		0x21, 0
	.dw 0x0f40, 0xc80d,	0x0f7f, 0xc80d,		0x21, 0
	.dw 0x0fc0, 0xc80d,	0x0fff, 0xc80d,		0x21, 0
	.dw 0x1040, 0xc80d,	0x107f, 0xc80d,		0x21, 0
	.dw 0x10c0, 0xc80d,	0x10ff, 0xc80d,		0x21, 0
	.dw 0x1140, 0xc80d,	0x117f, 0xc80d,		0x21, 0
	.dw 0x11c0, 0xc80d,	0x11ff, 0xc80d,		0x21, 0
	.dw 0x1240, 0xc80d,	0x127f, 0xc80d,		0x21, 0
	.dw 0x12c0, 0xc80d,	0x12ff, 0xc80d,		0x21, 0
	.dw 0x1340, 0xc80d,	0x137f, 0xc80d,		0x21, 0
	.dw 0x13c0, 0xc80d,	0x13ff, 0xc80d,		0x21, 0
	.dw 0x1440, 0xc80d,	0x147f, 0xc80d,		0x21, 0
	.dw 0x14c0, 0xc80d,	0x14ff, 0xc80d,		0x21, 0
	.dw 0x1540, 0xc80d,	0x157f, 0xc80d,		0x21, 0
	.dw 0x15c0, 0xc80d,	0x15ff, 0xc80d,		0x21, 0
	.dw 0x1640, 0xc80d,	0x167f, 0xc80d,		0x21, 0
	.dw 0x16c0, 0xc80d,	0x16ff, 0xc80d,		0x21, 0
	.dw 0x1740, 0xc80d,	0x177f, 0xc80d,		0x21, 0
	.dw 0x17c0, 0xc80d,	0x17ff, 0xc80d,		0x21, 0
	.dw 0x1840, 0xc80d,	0x187f, 0xc80d,		0x21, 0
	.dw 0x18c0, 0xc80d,	0x18ff, 0xc80d,		0x21, 0
	.dw 0x1940, 0xc80d,	0x197f, 0xc80d,		0x21, 0
	.dw 0x19c0, 0xc80d,	0x1fff, 0xc80d,		0x21, 0
	.dw 0x2040, 0xc80d,	0x207f, 0xc80d,		0x21, 0
	.dw 0x20c0, 0xc80d,	0x20ff, 0xc80d,		0x21, 0
	.dw 0x2140, 0xc80d,	0x217f, 0xc80d,		0x21, 0
	.dw 0x21c0, 0xc80d,	0x21ff, 0xc80d,		0x21, 0
	.dw 0x2240, 0xc80d,	0x227f, 0xc80d,		0x21, 0
	.dw 0x22c0, 0xc80d,	0x22ff, 0xc80d,		0x21, 0
	.dw 0x2340, 0xc80d,	0x237f, 0xc80d,		0x21, 0
	.dw 0x23c0, 0xc80d,	0x23ff, 0xc80d,		0x21, 0
	.dw 0x2440, 0xc80d,	0x247f, 0xc80d,		0x21, 0
	.dw 0x24c0, 0xc80d,	0x24ff, 0xc80d,		0x21, 0
	.dw 0x2540, 0xc80d,	0x257f, 0xc80d,		0x21, 0
	.dw 0x25c0, 0xc80d,	0x25ff, 0xc80d,		0x21, 0
	.dw 0x2640, 0xc80d,	0x267f, 0xc80d,		0x21, 0
	.dw 0x26c0, 0xc80d,	0x26ff, 0xc80d,		0x21, 0
	.dw 0x2740, 0xc80d,	0x277f, 0xc80d,		0x21, 0
	.dw 0x27c0, 0xc80d,	0x27ff, 0xc80d,		0x21, 0
	.dw 0x2840, 0xc80d,	0x287f, 0xc80d,		0x21, 0
	.dw 0x28c0, 0xc80d,	0x28ff, 0xc80d,		0x21, 0
	.dw 0x2940, 0xc80d,	0x297f, 0xc80d,		0x21, 0
	.dw 0x29c0, 0xc80d,	0x29ff, 0xc80d,		0x21, 0
	.dw 0x2a40, 0xc80d,	0x2a7f, 0xc80d,		0x21, 0
	.dw 0x2ac0, 0xc80d,	0x2aff, 0xc80d,		0x21, 0
	.dw 0x2b40, 0xc80d,	0x2b7f, 0xc80d,		0x21, 0
	.dw 0x2bc0, 0xc80d,	0x2bff, 0xc80d,		0x21, 0
	.dw 0x2c40, 0xc80d,	0x2c7f, 0xc80d,		0x21, 0
	.dw 0x2cc0, 0xc80d,	0x2cff, 0xc80d,		0x21, 0
	.dw 0x2d40, 0xc80d,	0x2d7f, 0xc80d,		0x21, 0
	.dw 0x2dc0, 0xc80d,	0x2dff, 0xc80d,		0x21, 0
	.dw 0x2e40, 0xc80d,	0x2e7f, 0xc80d,		0x21, 0
	.dw 0x2ec0, 0xc80d,	0x2eff, 0xc80d,		0x21, 0
	.dw 0x2f40, 0xc80d,	0x2f7f, 0xc80d,		0x21, 0
	.dw 0x2fc0, 0xc80d,	0x2fff, 0xc80d,		0x21, 0
	.dw 0x3040, 0xc80d,	0x307f, 0xc80d,		0x21, 0
	.dw 0x30c0, 0xc80d,	0x30ff, 0xc80d,		0x21, 0
	.dw 0x3140, 0xc80d,	0x317f, 0xc80d,		0x21, 0
	.dw 0x31c0, 0xc80d,	0x31ff, 0xc80d,		0x21, 0
	.dw 0x3240, 0xc80d,	0x327f, 0xc80d,		0x21, 0
	.dw 0x32c0, 0xc80d,	0x32ff, 0xc80d,		0x21, 0
	.dw 0x3340, 0xc80d,	0x337f, 0xc80d,		0x21, 0
	.dw 0x33c0, 0xc80d,	0x33ff, 0xc80d,		0x21, 0
	.dw 0x3440, 0xc80d,	0x347f, 0xc80d,		0x21, 0
	.dw 0x34c0, 0xc80d,	0x34ff, 0xc80d,		0x21, 0
	.dw 0x3540, 0xc80d,	0x357f, 0xc80d,		0x21, 0
	.dw 0x35c0, 0xc80d,	0x35ff, 0xc80d,		0x21, 0
	.dw 0x3640, 0xc80d,	0x367f, 0xc80d,		0x21, 0
	.dw 0x36c0, 0xc80d,	0x36ff, 0xc80d,		0x21, 0
	.dw 0x3740, 0xc80d,	0x377f, 0xc80d,		0x21, 0
	.dw 0x37c0, 0xc80d,	0x37ff, 0xc80d,		0x21, 0
	.dw 0x3840, 0xc80d,	0x387f, 0xc80d,		0x21, 0
	.dw 0x38c0, 0xc80d,	0x38ff, 0xc80d,		0x21, 0
	.dw 0x3940, 0xc80d,	0x397f, 0xc80d,		0x21, 0
	.dw 0x39c0, 0xc80d,	0x3fff, 0xc80d,		0x21, 0
	.dw 0x4040, 0xc80d,	0x407f, 0xc80d,		0x21, 0
	.dw 0x40c0, 0xc80d,	0x40ff, 0xc80d,		0x21, 0
	.dw 0x4140, 0xc80d,	0x417f, 0xc80d,		0x21, 0
	.dw 0x41c0, 0xc80d,	0x41ff, 0xc80d,		0x21, 0
	.dw 0x4240, 0xc80d,	0x427f, 0xc80d,		0x21, 0
	.dw 0x42c0, 0xc80d,	0x42ff, 0xc80d,		0x21, 0
	.dw 0x4340, 0xc80d,	0x437f, 0xc80d,		0x21, 0
	.dw 0x43c0, 0xc80d,	0x43ff, 0xc80d,		0x21, 0
	.dw 0x4440, 0xc80d,	0x447f, 0xc80d,		0x21, 0
	.dw 0x44c0, 0xc80d,	0x44ff, 0xc80d,		0x21, 0
	.dw 0x4540, 0xc80d,	0x457f, 0xc80d,		0x21, 0
	.dw 0x45c0, 0xc80d,	0x45ff, 0xc80d,		0x21, 0
	.dw 0x4640, 0xc80d,	0x467f, 0xc80d,		0x21, 0
	.dw 0x46c0, 0xc80d,	0x46ff, 0xc80d,		0x21, 0
	.dw 0x4740, 0xc80d,	0x477f, 0xc80d,		0x21, 0
	.dw 0x47c0, 0xc80d,	0x47ff, 0xc80d,		0x21, 0
	.dw 0x4840, 0xc80d,	0x487f, 0xc80d,		0x21, 0
	.dw 0x48c0, 0xc80d,	0x48ff, 0xc80d,		0x21, 0
	.dw 0x4940, 0xc80d,	0x497f, 0xc80d,		0x21, 0
	.dw 0x49c0, 0xc80d,	0x49ff, 0xc80d,		0x21, 0
	.dw 0x4a40, 0xc80d,	0x4a7f, 0xc80d,		0x21, 0
	.dw 0x4ac0, 0xc80d,	0x4aff, 0xc80d,		0x21, 0
	.dw 0x4b40, 0xc80d,	0x4b7f, 0xc80d,		0x21, 0
	.dw 0x4bc0, 0xc80d,	0x4bff, 0xc80d,		0x21, 0
	.dw 0x4c40, 0xc80d,	0x4c7f, 0xc80d,		0x21, 0
	.dw 0x4cc0, 0xc80d,	0x4cff, 0xc80d,		0x21, 0
	.dw 0x4d40, 0xc80d,	0x4d7f, 0xc80d,		0x21, 0
	.dw 0x4dc0, 0xc80d,	0x4dff, 0xc80d,		0x21, 0
	.dw 0x4e40, 0xc80d,	0x4e7f, 0xc80d,		0x21, 0
	.dw 0x4ec0, 0xc80d,	0x4eff, 0xc80d,		0x21, 0
	.dw 0x4f40, 0xc80d,	0x4f7f, 0xc80d,		0x21, 0
	.dw 0x4fc0, 0xc80d,	0x4fff, 0xc80d,		0x21, 0
	.dw 0x5040, 0xc80d,	0x507f, 0xc80d,		0x21, 0
	.dw 0x50c0, 0xc80d,	0x50ff, 0xc80d,		0x21, 0
	.dw 0x5140, 0xc80d,	0x517f, 0xc80d,		0x21, 0
	.dw 0x51c0, 0xc80d,	0x51ff, 0xc80d,		0x21, 0
	.dw 0x5240, 0xc80d,	0x527f, 0xc80d,		0x21, 0
	.dw 0x52c0, 0xc80d,	0x52ff, 0xc80d,		0x21, 0
	.dw 0x5340, 0xc80d,	0x537f, 0xc80d,		0x21, 0
	.dw 0x53c0, 0xc80d,	0x53ff, 0xc80d,		0x21, 0
	.dw 0x5440, 0xc80d,	0x547f, 0xc80d,		0x21, 0
	.dw 0x54c0, 0xc80d,	0x54ff, 0xc80d,		0x21, 0
	.dw 0x5540, 0xc80d,	0x557f, 0xc80d,		0x21, 0
	.dw 0x55c0, 0xc80d,	0x55ff, 0xc80d,		0x21, 0
	.dw 0x5640, 0xc80d,	0x567f, 0xc80d,		0x21, 0
	.dw 0x56c0, 0xc80d,	0x56ff, 0xc80d,		0x21, 0
	.dw 0x5740, 0xc80d,	0x577f, 0xc80d,		0x21, 0
	.dw 0x57c0, 0xc80d,	0x57ff, 0xc80d,		0x21, 0
	.dw 0x5840, 0xc80d,	0x587f, 0xc80d,		0x21, 0
	.dw 0x58c0, 0xc80d,	0x58ff, 0xc80d,		0x21, 0
	.dw 0x5940, 0xc80d,	0x597f, 0xc80d,		0x21, 0
	.dw 0x59c0, 0xc80d,	0x5fff, 0xc80d,		0x21, 0
	.dw 0x6040, 0xc80d,	0x607f, 0xc80d,		0x21, 0
	.dw 0x60c0, 0xc80d,	0x60ff, 0xc80d,		0x21, 0
	.dw 0x6140, 0xc80d,	0x617f, 0xc80d,		0x21, 0
	.dw 0x61c0, 0xc80d,	0x61ff, 0xc80d,		0x21, 0
	.dw 0x6240, 0xc80d,	0x627f, 0xc80d,		0x21, 0
	.dw 0x62c0, 0xc80d,	0x62ff, 0xc80d,		0x21, 0
	.dw 0x6340, 0xc80d,	0x637f, 0xc80d,		0x21, 0
	.dw 0x63c0, 0xc80d,	0x63ff, 0xc80d,		0x21, 0
	.dw 0x6440, 0xc80d,	0x647f, 0xc80d,		0x21, 0
	.dw 0x64c0, 0xc80d,	0x64ff, 0xc80d,		0x21, 0
	.dw 0x6540, 0xc80d,	0x657f, 0xc80d,		0x21, 0
	.dw 0x65c0, 0xc80d,	0x65ff, 0xc80d,		0x21, 0
	.dw 0x6640, 0xc80d,	0x667f, 0xc80d,		0x21, 0
	.dw 0x66c0, 0xc80d,	0x66ff, 0xc80d,		0x21, 0
	.dw 0x6740, 0xc80d,	0x677f, 0xc80d,		0x21, 0
	.dw 0x67c0, 0xc80d,	0x67ff, 0xc80d,		0x21, 0
	.dw 0x6840, 0xc80d,	0x687f, 0xc80d,		0x21, 0
	.dw 0x68c0, 0xc80d,	0x68ff, 0xc80d,		0x21, 0
	.dw 0x6940, 0xc80d,	0x697f, 0xc80d,		0x21, 0
	.dw 0x69c0, 0xc80d,	0x69ff, 0xc80d,		0x21, 0
	.dw 0x6a40, 0xc80d,	0x6a7f, 0xc80d,		0x21, 0
	.dw 0x6ac0, 0xc80d,	0x6aff, 0xc80d,		0x21, 0
	.dw 0x6b40, 0xc80d,	0x6b7f, 0xc80d,		0x21, 0
	.dw 0x6bc0, 0xc80d,	0x6bff, 0xc80d,		0x21, 0
	.dw 0x6c40, 0xc80d,	0x6c7f, 0xc80d,		0x21, 0
	.dw 0x6cc0, 0xc80d,	0x6cff, 0xc80d,		0x21, 0
	.dw 0x6d40, 0xc80d,	0x6d7f, 0xc80d,		0x21, 0
	.dw 0x6dc0, 0xc80d,	0x6dff, 0xc80d,		0x21, 0
	.dw 0x6e40, 0xc80d,	0x6e7f, 0xc80d,		0x21, 0
	.dw 0x6ec0, 0xc80d,	0x6eff, 0xc80d,		0x21, 0
	.dw 0x6f40, 0xc80d,	0x6f7f, 0xc80d,		0x21, 0
	.dw 0x6fc0, 0xc80d,	0x6fff, 0xc80d,		0x21, 0
	.dw 0x7040, 0xc80d,	0x707f, 0xc80d,		0x21, 0
	.dw 0x70c0, 0xc80d,	0x70ff, 0xc80d,		0x21, 0
	.dw 0x7140, 0xc80d,	0x717f, 0xc80d,		0x21, 0
	.dw 0x71c0, 0xc80d,	0x71ff, 0xc80d,		0x21, 0
	.dw 0x7240, 0xc80d,	0x727f, 0xc80d,		0x21, 0
	.dw 0x72c0, 0xc80d,	0x72ff, 0xc80d,		0x21, 0
	.dw 0x7340, 0xc80d,	0x737f, 0xc80d,		0x21, 0
	.dw 0x73c0, 0xc80d,	0x73ff, 0xc80d,		0x21, 0
	.dw 0x7440, 0xc80d,	0x747f, 0xc80d,		0x21, 0
	.dw 0x74c0, 0xc80d,	0x74ff, 0xc80d,		0x21, 0
	.dw 0x7540, 0xc80d,	0x757f, 0xc80d,		0x21, 0
	.dw 0x75c0, 0xc80d,	0x75ff, 0xc80d,		0x21, 0
	.dw 0x7640, 0xc80d,	0x767f, 0xc80d,		0x21, 0
	.dw 0x76c0, 0xc80d,	0x76ff, 0xc80d,		0x21, 0
	.dw 0x7740, 0xc80d,	0x777f, 0xc80d,		0x21, 0
	.dw 0x77c0, 0xc80d,	0x77ff, 0xc80d,		0x21, 0
	.dw 0x7840, 0xc80d,	0x787f, 0xc80d,		0x21, 0
	.dw 0x78c0, 0xc80d,	0x78ff, 0xc80d,		0x21, 0
	.dw 0x7940, 0xc80d,	0x797f, 0xc80d,		0x21, 0
	.dw 0x79c0, 0xc80d,	0x7fff, 0xc80d,		0x21, 0
	.dw 0x8040, 0xc80d,	0x807f, 0xc80d,		0x21, 0
	.dw 0x80c0, 0xc80d,	0x80ff, 0xc80d,		0x21, 0
	.dw 0x8140, 0xc80d,	0x817f, 0xc80d,		0x21, 0
	.dw 0x81c0, 0xc80d,	0x81ff, 0xc80d,		0x21, 0
	.dw 0x8240, 0xc80d,	0x827f, 0xc80d,		0x21, 0
	.dw 0x82c0, 0xc80d,	0x82ff, 0xc80d,		0x21, 0
	.dw 0x8340, 0xc80d,	0x837f, 0xc80d,		0x21, 0
	.dw 0x83c0, 0xc80d,	0x83ff, 0xc80d,		0x21, 0
	.dw 0x8440, 0xc80d,	0x847f, 0xc80d,		0x21, 0
	.dw 0x84c0, 0xc80d,	0x84ff, 0xc80d,		0x21, 0
	.dw 0x8540, 0xc80d,	0x857f, 0xc80d,		0x21, 0
	.dw 0x85c0, 0xc80d,	0x85ff, 0xc80d,		0x21, 0
	.dw 0x8640, 0xc80d,	0x867f, 0xc80d,		0x21, 0
	.dw 0x86c0, 0xc80d,	0x86ff, 0xc80d,		0x21, 0
	.dw 0x8740, 0xc80d,	0x877f, 0xc80d,		0x21, 0
	.dw 0x87c0, 0xc80d,	0x87ff, 0xc80d,		0x21, 0
	.dw 0x8840, 0xc80d,	0x887f, 0xc80d,		0x21, 0
	.dw 0x88c0, 0xc80d,	0x88ff, 0xc80d,		0x21, 0
	.dw 0x8940, 0xc80d,	0x897f, 0xc80d,		0x21, 0
	.dw 0x89c0, 0xc80d,	0x89ff, 0xc80d,		0x21, 0
	.dw 0x8a40, 0xc80d,	0x8a7f, 0xc80d,		0x21, 0
	.dw 0x8ac0, 0xc80d,	0x8aff, 0xc80d,		0x21, 0
	.dw 0x8b40, 0xc80d,	0x8b7f, 0xc80d,		0x21, 0
	.dw 0x8bc0, 0xc80d,	0x8bff, 0xc80d,		0x21, 0
	.dw 0x8c40, 0xc80d,	0x8c7f, 0xc80d,		0x21, 0
	.dw 0x8cc0, 0xc80d,	0x8cff, 0xc80d,		0x21, 0
	.dw 0x8d40, 0xc80d,	0x8d7f, 0xc80d,		0x21, 0
	.dw 0x8dc0, 0xc80d,	0x8dff, 0xc80d,		0x21, 0
	.dw 0x8e40, 0xc80d,	0x8e7f, 0xc80d,		0x21, 0
	.dw 0x8ec0, 0xc80d,	0x8eff, 0xc80d,		0x21, 0
	.dw 0x8f40, 0xc80d,	0x8f7f, 0xc80d,		0x21, 0
	.dw 0x8fc0, 0xc80d,	0x8fff, 0xc80d,		0x21, 0
	.dw 0x9040, 0xc80d,	0x907f, 0xc80d,		0x21, 0
	.dw 0x90c0, 0xc80d,	0x90ff, 0xc80d,		0x21, 0
	.dw 0x9140, 0xc80d,	0x917f, 0xc80d,		0x21, 0
	.dw 0x91c0, 0xc80d,	0x91ff, 0xc80d,		0x21, 0
	.dw 0x9240, 0xc80d,	0x927f, 0xc80d,		0x21, 0
	.dw 0x92c0, 0xc80d,	0x92ff, 0xc80d,		0x21, 0
	.dw 0x9340, 0xc80d,	0x937f, 0xc80d,		0x21, 0
	.dw 0x93c0, 0xc80d,	0x93ff, 0xc80d,		0x21, 0
	.dw 0x9440, 0xc80d,	0x947f, 0xc80d,		0x21, 0
	.dw 0x94c0, 0xc80d,	0x94ff, 0xc80d,		0x21, 0
	.dw 0x9540, 0xc80d,	0x957f, 0xc80d,		0x21, 0
	.dw 0x95c0, 0xc80d,	0x95ff, 0xc80d,		0x21, 0
	.dw 0x9640, 0xc80d,	0x967f, 0xc80d,		0x21, 0
	.dw 0x96c0, 0xc80d,	0x96ff, 0xc80d,		0x21, 0
	.dw 0x9740, 0xc80d,	0x977f, 0xc80d,		0x21, 0
	.dw 0x97c0, 0xc80d,	0x97ff, 0xc80d,		0x21, 0
	.dw 0x9840, 0xc80d,	0x987f, 0xc80d,		0x21, 0
	.dw 0x98c0, 0xc80d,	0x98ff, 0xc80d,		0x21, 0
	.dw 0x9940, 0xc80d,	0x997f, 0xc80d,		0x21, 0
	.dw 0x99c0, 0xc80d,	0x9fff, 0xc80d,		0x21, 0
	.dw 0xa040, 0xc80d,	0xa07f, 0xc80d,		0x21, 0
	.dw 0xa0c0, 0xc80d,	0xa0ff, 0xc80d,		0x21, 0
	.dw 0xa140, 0xc80d,	0xa17f, 0xc80d,		0x21, 0
	.dw 0xa1c0, 0xc80d,	0xa1ff, 0xc80d,		0x21, 0
	.dw 0xa240, 0xc80d,	0xa27f, 0xc80d,		0x21, 0
	.dw 0xa2c0, 0xc80d,	0xa2ff, 0xc80d,		0x21, 0
	.dw 0xa340, 0xc80d,	0xa37f, 0xc80d,		0x21, 0
	.dw 0xa3c0, 0xc80d,	0xa3ff, 0xc80d,		0x21, 0
	.dw 0xa440, 0xc80d,	0xa47f, 0xc80d,		0x21, 0
	.dw 0xa4c0, 0xc80d,	0xa4ff, 0xc80d,		0x21, 0
	.dw 0xa540, 0xc80d,	0xa57f, 0xc80d,		0x21, 0
	.dw 0xa5c0, 0xc80d,	0xa5ff, 0xc80d,		0x21, 0
	.dw 0xa640, 0xc80d,	0xa67f, 0xc80d,		0x21, 0
	.dw 0xa6c0, 0xc80d,	0xa6ff, 0xc80d,		0x21, 0
	.dw 0xa740, 0xc80d,	0xa77f, 0xc80d,		0x21, 0
	.dw 0xa7c0, 0xc80d,	0xa7ff, 0xc80d,		0x21, 0
	.dw 0xa840, 0xc80d,	0xa87f, 0xc80d,		0x21, 0
	.dw 0xa8c0, 0xc80d,	0xa8ff, 0xc80d,		0x21, 0
	.dw 0xa940, 0xc80d,	0xa97f, 0xc80d,		0x21, 0
	.dw 0xa9c0, 0xc80d,	0xa9ff, 0xc80d,		0x21, 0
	.dw 0xaa40, 0xc80d,	0xaa7f, 0xc80d,		0x21, 0
	.dw 0xaac0, 0xc80d,	0xaaff, 0xc80d,		0x21, 0
	.dw 0xab40, 0xc80d,	0xab7f, 0xc80d,		0x21, 0
	.dw 0xabc0, 0xc80d,	0xabff, 0xc80d,		0x21, 0
	.dw 0xac40, 0xc80d,	0xac7f, 0xc80d,		0x21, 0
	.dw 0xacc0, 0xc80d,	0xacff, 0xc80d,		0x21, 0
	.dw 0xad40, 0xc80d,	0xad7f, 0xc80d,		0x21, 0
	.dw 0xadc0, 0xc80d,	0xadff, 0xc80d,		0x21, 0
	.dw 0xae40, 0xc80d,	0xae7f, 0xc80d,		0x21, 0
	.dw 0xaec0, 0xc80d,	0xaeff, 0xc80d,		0x21, 0
	.dw 0xaf40, 0xc80d,	0xaf7f, 0xc80d,		0x21, 0
	.dw 0xafc0, 0xc80d,	0xafff, 0xc80d,		0x21, 0
	.dw 0xb040, 0xc80d,	0xb07f, 0xc80d,		0x21, 0
	.dw 0xb0c0, 0xc80d,	0xb0ff, 0xc80d,		0x21, 0
	.dw 0xb140, 0xc80d,	0xb17f, 0xc80d,		0x21, 0
	.dw 0xb1c0, 0xc80d,	0xb1ff, 0xc80d,		0x21, 0
	.dw 0xb240, 0xc80d,	0xb27f, 0xc80d,		0x21, 0
	.dw 0xb2c0, 0xc80d,	0xb2ff, 0xc80d,		0x21, 0
	.dw 0xb340, 0xc80d,	0xb37f, 0xc80d,		0x21, 0
	.dw 0xb3c0, 0xc80d,	0xb3ff, 0xc80d,		0x21, 0
	.dw 0xb440, 0xc80d,	0xb47f, 0xc80d,		0x21, 0
	.dw 0xb4c0, 0xc80d,	0xb4ff, 0xc80d,		0x21, 0
	.dw 0xb540, 0xc80d,	0xb57f, 0xc80d,		0x21, 0
	.dw 0xb5c0, 0xc80d,	0xb5ff, 0xc80d,		0x21, 0
	.dw 0xb640, 0xc80d,	0xb67f, 0xc80d,		0x21, 0
	.dw 0xb6c0, 0xc80d,	0xb6ff, 0xc80d,		0x21, 0
	.dw 0xb740, 0xc80d,	0xb77f, 0xc80d,		0x21, 0
	.dw 0xb7c0, 0xc80d,	0xb7ff, 0xc80d,		0x21, 0
	.dw 0xb840, 0xc80d,	0xb87f, 0xc80d,		0x21, 0
	.dw 0xb8c0, 0xc80d,	0xb8ff, 0xc80d,		0x21, 0
	.dw 0xb940, 0xc80d,	0xb97f, 0xc80d,		0x21, 0
	.dw 0xb9c0, 0xc80d,	0xbfff, 0xc80d,		0x21, 0
	.dw 0xc040, 0xc80d,	0xc07f, 0xc80d,		0x21, 0
	.dw 0xc0c0, 0xc80d,	0xc0ff, 0xc80d,		0x21, 0
	.dw 0xc140, 0xc80d,	0xc17f, 0xc80d,		0x21, 0
	.dw 0xc1c0, 0xc80d,	0xc1ff, 0xc80d,		0x21, 0
	.dw 0xc240, 0xc80d,	0xc27f, 0xc80d,		0x21, 0
	.dw 0xc2c0, 0xc80d,	0xc2ff, 0xc80d,		0x21, 0
	.dw 0xc340, 0xc80d,	0xc37f, 0xc80d,		0x21, 0
	.dw 0xc3c0, 0xc80d,	0xc3ff, 0xc80d,		0x21, 0
	.dw 0xc440, 0xc80d,	0xc47f, 0xc80d,		0x21, 0
	.dw 0xc4c0, 0xc80d,	0xc4ff, 0xc80d,		0x21, 0
	.dw 0xc540, 0xc80d,	0xc57f, 0xc80d,		0x21, 0
	.dw 0xc5c0, 0xc80d,	0xc5ff, 0xc80d,		0x21, 0
	.dw 0xc640, 0xc80d,	0xc67f, 0xc80d,		0x21, 0
	.dw 0xc6c0, 0xc80d,	0xc6ff, 0xc80d,		0x21, 0
	.dw 0xc740, 0xc80d,	0xc77f, 0xc80d,		0x21, 0
	.dw 0xc7c0, 0xc80d,	0xc7ff, 0xc80d,		0x21, 0
	.dw 0xc840, 0xc80d,	0xc87f, 0xc80d,		0x21, 0
	.dw 0xc8c0, 0xc80d,	0xc8ff, 0xc80d,		0x21, 0
	.dw 0xc940, 0xc80d,	0xc97f, 0xc80d,		0x21, 0
	.dw 0xc9c0, 0xc80d,	0xc9ff, 0xc80d,		0x21, 0
	.dw 0xca40, 0xc80d,	0xca7f, 0xc80d,		0x21, 0
	.dw 0xcac0, 0xc80d,	0xcaff, 0xc80d,		0x21, 0
	.dw 0xcb40, 0xc80d,	0xcb7f, 0xc80d,		0x21, 0
	.dw 0xcbc0, 0xc80d,	0xcbff, 0xc80d,		0x21, 0
	.dw 0xcc40, 0xc80d,	0xcc7f, 0xc80d,		0x21, 0
	.dw 0xccc0, 0xc80d,	0xccff, 0xc80d,		0x21, 0
	.dw 0xcd40, 0xc80d,	0xcd7f, 0xc80d,		0x21, 0
	.dw 0xcdc0, 0xc80d,	0xcdff, 0xc80d,		0x21, 0
	.dw 0xce40, 0xc80d,	0xce7f, 0xc80d,		0x21, 0
	.dw 0xcec0, 0xc80d,	0xceff, 0xc80d,		0x21, 0
	.dw 0xcf40, 0xc80d,	0xcf7f, 0xc80d,		0x21, 0
	.dw 0xcfc0, 0xc80d,	0xcfff, 0xc80d,		0x21, 0
	.dw 0xd040, 0xc80d,	0xd07f, 0xc80d,		0x21, 0
	.dw 0xd0c0, 0xc80d,	0xd0ff, 0xc80d,		0x21, 0
	.dw 0xd140, 0xc80d,	0xd17f, 0xc80d,		0x21, 0
	.dw 0xd1c0, 0xc80d,	0xd1ff, 0xc80d,		0x21, 0
	.dw 0xd240, 0xc80d,	0xd27f, 0xc80d,		0x21, 0
	.dw 0xd2c0, 0xc80d,	0xd2ff, 0xc80d,		0x21, 0
	.dw 0xd340, 0xc80d,	0xd37f, 0xc80d,		0x21, 0
	.dw 0xd3c0, 0xc80d,	0xd3ff, 0xc80d,		0x21, 0
	.dw 0xd440, 0xc80d,	0xd47f, 0xc80d,		0x21, 0
	.dw 0xd4c0, 0xc80d,	0xd4ff, 0xc80d,		0x21, 0
	.dw 0xd540, 0xc80d,	0xd57f, 0xc80d,		0x21, 0
	.dw 0xd5c0, 0xc80d,	0xd5ff, 0xc80d,		0x21, 0
	.dw 0xd640, 0xc80d,	0xd67f, 0xc80d,		0x21, 0
	.dw 0xd6c0, 0xc80d,	0xd6ff, 0xc80d,		0x21, 0
	.dw 0xd740, 0xc80d,	0xd77f, 0xc80d,		0x21, 0
	.dw 0xd7c0, 0xc80d,	0xd7ff, 0xc80d,		0x21, 0
	.dw 0xd840, 0xc80d,	0xd87f, 0xc80d,		0x21, 0
	.dw 0xd8c0, 0xc80d,	0xd8ff, 0xc80d,		0x21, 0
	.dw 0xd940, 0xc80d,	0xd97f, 0xc80d,		0x21, 0
	.dw 0xd9c0, 0xc80d,	0xdfff, 0xc80d,		0x21, 0
	.dw 0xe040, 0xc80d,	0xe07f, 0xc80d,		0x21, 0
	.dw 0xe0c0, 0xc80d,	0xe0ff, 0xc80d,		0x21, 0
	.dw 0xe140, 0xc80d,	0xe17f, 0xc80d,		0x21, 0
	.dw 0xe1c0, 0xc80d,	0xe1ff, 0xc80d,		0x21, 0
	.dw 0xe240, 0xc80d,	0xe27f, 0xc80d,		0x21, 0
	.dw 0xe2c0, 0xc80d,	0xe2ff, 0xc80d,		0x21, 0
	.dw 0xe340, 0xc80d,	0xe37f, 0xc80d,		0x21, 0
	.dw 0xe3c0, 0xc80d,	0xe3ff, 0xc80d,		0x21, 0
	.dw 0xe440, 0xc80d,	0xe47f, 0xc80d,		0x21, 0
	.dw 0xe4c0, 0xc80d,	0xe4ff, 0xc80d,		0x21, 0
	.dw 0xe540, 0xc80d,	0xe57f, 0xc80d,		0x21, 0
	.dw 0xe5c0, 0xc80d,	0xe5ff, 0xc80d,		0x21, 0
	.dw 0xe640, 0xc80d,	0xe67f, 0xc80d,		0x21, 0
	.dw 0xe6c0, 0xc80d,	0xe6ff, 0xc80d,		0x21, 0
	.dw 0xe740, 0xc80d,	0xe77f, 0xc80d,		0x21, 0
	.dw 0xe7c0, 0xc80d,	0xe7ff, 0xc80d,		0x21, 0
	.dw 0xe840, 0xc80d,	0xe87f, 0xc80d,		0x21, 0
	.dw 0xe8c0, 0xc80d,	0xe8ff, 0xc80d,		0x21, 0
	.dw 0xe940, 0xc80d,	0xe97f, 0xc80d,		0x21, 0
	.dw 0xe9c0, 0xc80d,	0xe9ff, 0xc80d,		0x21, 0
	.dw 0xea40, 0xc80d,	0xea7f, 0xc80d,		0x21, 0
	.dw 0xeac0, 0xc80d,	0xeaff, 0xc80d,		0x21, 0
	.dw 0xeb40, 0xc80d,	0xeb7f, 0xc80d,		0x21, 0
	.dw 0xebc0, 0xc80d,	0xebff, 0xc80d,		0x21, 0
	.dw 0xec40, 0xc80d,	0xec7f, 0xc80d,		0x21, 0
	.dw 0xecc0, 0xc80d,	0xecff, 0xc80d,		0x21, 0
	.dw 0xed40, 0xc80d,	0xed7f, 0xc80d,		0x21, 0
	.dw 0xedc0, 0xc80d,	0xedff, 0xc80d,		0x21, 0
	.dw 0xee40, 0xc80d,	0xee7f, 0xc80d,		0x21, 0
	.dw 0xeec0, 0xc80d,	0xeeff, 0xc80d,		0x21, 0
	.dw 0xef40, 0xc80d,	0xef7f, 0xc80d,		0x21, 0
	.dw 0xefc0, 0xc80d,	0xefff, 0xc80d,		0x21, 0
	.dw 0xf040, 0xc80d,	0xf07f, 0xc80d,		0x21, 0
	.dw 0xf0c0, 0xc80d,	0xf0ff, 0xc80d,		0x21, 0
	.dw 0xf140, 0xc80d,	0xf17f, 0xc80d,		0x21, 0
	.dw 0xf1c0, 0xc80d,	0xf1ff, 0xc80d,		0x21, 0
	.dw 0xf240, 0xc80d,	0xf27f, 0xc80d,		0x21, 0
	.dw 0xf2c0, 0xc80d,	0xf2ff, 0xc80d,		0x21, 0
	.dw 0xf340, 0xc80d,	0xf37f, 0xc80d,		0x21, 0
	.dw 0xf3c0, 0xc80d,	0xf3ff, 0xc80d,		0x21, 0
	.dw 0xf440, 0xc80d,	0xf47f, 0xc80d,		0x21, 0
	.dw 0xf4c0, 0xc80d,	0xf4ff, 0xc80d,		0x21, 0
	.dw 0xf540, 0xc80d,	0xf57f, 0xc80d,		0x21, 0
	.dw 0xf5c0, 0xc80d,	0xf5ff, 0xc80d,		0x21, 0
	.dw 0xf640, 0xc80d,	0xf67f, 0xc80d,		0x21, 0
	.dw 0xf6c0, 0xc80d,	0xf6ff, 0xc80d,		0x21, 0
	.dw 0xf740, 0xc80d,	0xf77f, 0xc80d,		0x21, 0
	.dw 0xf7c0, 0xc80d,	0xf7ff, 0xc80d,		0x21, 0
	.dw 0xf840, 0xc80d,	0xf87f, 0xc80d,		0x21, 0
	.dw 0xf8c0, 0xc80d,	0xf8ff, 0xc80d,		0x21, 0
	.dw 0xf940, 0xc80d,	0xf97f, 0xc80d,		0x21, 0
	.dw 0xf9c0, 0xc80d,	0xffff, 0xc80d,		0x21, 0
	.dw 0x0040, 0xc80e,	0x007f, 0xc80e,		0x21, 0
	.dw 0x00c0, 0xc80e,	0x00ff, 0xc80e,		0x21, 0
	.dw 0x0140, 0xc80e,	0x017f, 0xc80e,		0x21, 0
	.dw 0x01c0, 0xc80e,	0x01ff, 0xc80e,		0x21, 0
	.dw 0x0240, 0xc80e,	0x027f, 0xc80e,		0x21, 0
	.dw 0x02c0, 0xc80e,	0x02ff, 0xc80e,		0x21, 0
	.dw 0x0340, 0xc80e,	0x037f, 0xc80e,		0x21, 0
	.dw 0x03c0, 0xc80e,	0x03ff, 0xc80e,		0x21, 0
	.dw 0x0440, 0xc80e,	0x047f, 0xc80e,		0x21, 0
	.dw 0x04c0, 0xc80e,	0x04ff, 0xc80e,		0x21, 0
	.dw 0x0540, 0xc80e,	0x057f, 0xc80e,		0x21, 0
	.dw 0x05c0, 0xc80e,	0x05ff, 0xc80e,		0x21, 0
	.dw 0x0640, 0xc80e,	0x067f, 0xc80e,		0x21, 0
	.dw 0x06c0, 0xc80e,	0x06ff, 0xc80e,		0x21, 0
	.dw 0x0740, 0xc80e,	0x077f, 0xc80e,		0x21, 0
	.dw 0x07c0, 0xc80e,	0x07ff, 0xc80e,		0x21, 0
	.dw 0x0840, 0xc80e,	0x087f, 0xc80e,		0x21, 0
	.dw 0x08c0, 0xc80e,	0x08ff, 0xc80e,		0x21, 0
	.dw 0x0940, 0xc80e,	0x097f, 0xc80e,		0x21, 0
	.dw 0x09c0, 0xc80e,	0x09ff, 0xc80e,		0x21, 0
	.dw 0x0a40, 0xc80e,	0x0a7f, 0xc80e,		0x21, 0
	.dw 0x0ac0, 0xc80e,	0x0aff, 0xc80e,		0x21, 0
	.dw 0x0b40, 0xc80e,	0x0b7f, 0xc80e,		0x21, 0
	.dw 0x0bc0, 0xc80e,	0x0bff, 0xc80e,		0x21, 0
	.dw 0x0c40, 0xc80e,	0x0c7f, 0xc80e,		0x21, 0
	.dw 0x0cc0, 0xc80e,	0x0cff, 0xc80e,		0x21, 0
	.dw 0x0d40, 0xc80e,	0x0d7f, 0xc80e,		0x21, 0
	.dw 0x0dc0, 0xc80e,	0x0dff, 0xc80e,		0x21, 0
	.dw 0x0e40, 0xc80e,	0x0e7f, 0xc80e,		0x21, 0
	.dw 0x0ec0, 0xc80e,	0x0eff, 0xc80e,		0x21, 0
	.dw 0x0f40, 0xc80e,	0x0f7f, 0xc80e,		0x21, 0
	.dw 0x0fc0, 0xc80e,	0x0fff, 0xc80e,		0x21, 0
	.dw 0x1040, 0xc80e,	0x107f, 0xc80e,		0x21, 0
	.dw 0x10c0, 0xc80e,	0x10ff, 0xc80e,		0x21, 0
	.dw 0x1140, 0xc80e,	0x117f, 0xc80e,		0x21, 0
	.dw 0x11c0, 0xc80e,	0x11ff, 0xc80e,		0x21, 0
	.dw 0x1240, 0xc80e,	0x127f, 0xc80e,		0x21, 0
	.dw 0x12c0, 0xc80e,	0x12ff, 0xc80e,		0x21, 0
	.dw 0x1340, 0xc80e,	0x137f, 0xc80e,		0x21, 0
	.dw 0x13c0, 0xc80e,	0x13ff, 0xc80e,		0x21, 0
	.dw 0x1440, 0xc80e,	0x147f, 0xc80e,		0x21, 0
	.dw 0x14c0, 0xc80e,	0x14ff, 0xc80e,		0x21, 0
	.dw 0x1540, 0xc80e,	0x157f, 0xc80e,		0x21, 0
	.dw 0x15c0, 0xc80e,	0x15ff, 0xc80e,		0x21, 0
	.dw 0x1640, 0xc80e,	0x167f, 0xc80e,		0x21, 0
	.dw 0x16c0, 0xc80e,	0x16ff, 0xc80e,		0x21, 0
	.dw 0x1740, 0xc80e,	0x177f, 0xc80e,		0x21, 0
	.dw 0x17c0, 0xc80e,	0x17ff, 0xc80e,		0x21, 0
	.dw 0x1840, 0xc80e,	0x187f, 0xc80e,		0x21, 0
	.dw 0x18c0, 0xc80e,	0x18ff, 0xc80e,		0x21, 0
	.dw 0x1940, 0xc80e,	0x197f, 0xc80e,		0x21, 0
	.dw 0x19c0, 0xc80e,	0x1fff, 0xc80e,		0x21, 0
	.dw 0x2040, 0xc80e,	0x207f, 0xc80e,		0x21, 0
	.dw 0x20c0, 0xc80e,	0x20ff, 0xc80e,		0x21, 0
	.dw 0x2140, 0xc80e,	0x217f, 0xc80e,		0x21, 0
	.dw 0x21c0, 0xc80e,	0x21ff, 0xc80e,		0x21, 0
	.dw 0x2240, 0xc80e,	0x227f, 0xc80e,		0x21, 0
	.dw 0x22c0, 0xc80e,	0x22ff, 0xc80e,		0x21, 0
	.dw 0x2340, 0xc80e,	0x237f, 0xc80e,		0x21, 0
	.dw 0x23c0, 0xc80e,	0x23ff, 0xc80e,		0x21, 0
	.dw 0x2440, 0xc80e,	0x247f, 0xc80e,		0x21, 0
	.dw 0x24c0, 0xc80e,	0x24ff, 0xc80e,		0x21, 0
	.dw 0x2540, 0xc80e,	0x257f, 0xc80e,		0x21, 0
	.dw 0x25c0, 0xc80e,	0x25ff, 0xc80e,		0x21, 0
	.dw 0x2640, 0xc80e,	0x267f, 0xc80e,		0x21, 0
	.dw 0x26c0, 0xc80e,	0x26ff, 0xc80e,		0x21, 0
	.dw 0x2740, 0xc80e,	0x277f, 0xc80e,		0x21, 0
	.dw 0x27c0, 0xc80e,	0x27ff, 0xc80e,		0x21, 0
	.dw 0x2840, 0xc80e,	0x287f, 0xc80e,		0x21, 0
	.dw 0x28c0, 0xc80e,	0x28ff, 0xc80e,		0x21, 0
	.dw 0x2940, 0xc80e,	0x297f, 0xc80e,		0x21, 0
	.dw 0x29c0, 0xc80e,	0x29ff, 0xc80e,		0x21, 0
	.dw 0x2a40, 0xc80e,	0x2a7f, 0xc80e,		0x21, 0
	.dw 0x2ac0, 0xc80e,	0x2aff, 0xc80e,		0x21, 0
	.dw 0x2b40, 0xc80e,	0x2b7f, 0xc80e,		0x21, 0
	.dw 0x2bc0, 0xc80e,	0x2bff, 0xc80e,		0x21, 0
	.dw 0x2c40, 0xc80e,	0x2c7f, 0xc80e,		0x21, 0
	.dw 0x2cc0, 0xc80e,	0x2cff, 0xc80e,		0x21, 0
	.dw 0x2d40, 0xc80e,	0x2d7f, 0xc80e,		0x21, 0
	.dw 0x2dc0, 0xc80e,	0x2dff, 0xc80e,		0x21, 0
	.dw 0x2e40, 0xc80e,	0x2e7f, 0xc80e,		0x21, 0
	.dw 0x2ec0, 0xc80e,	0x2eff, 0xc80e,		0x21, 0
	.dw 0x2f40, 0xc80e,	0x2f7f, 0xc80e,		0x21, 0
	.dw 0x2fc0, 0xc80e,	0x2fff, 0xc80e,		0x21, 0
	.dw 0x3040, 0xc80e,	0x307f, 0xc80e,		0x21, 0
	.dw 0x30c0, 0xc80e,	0x30ff, 0xc80e,		0x21, 0
	.dw 0x3140, 0xc80e,	0x317f, 0xc80e,		0x21, 0
	.dw 0x31c0, 0xc80e,	0x31ff, 0xc80e,		0x21, 0
	.dw 0x3240, 0xc80e,	0x327f, 0xc80e,		0x21, 0
	.dw 0x32c0, 0xc80e,	0x32ff, 0xc80e,		0x21, 0
	.dw 0x3340, 0xc80e,	0x337f, 0xc80e,		0x21, 0
	.dw 0x33c0, 0xc80e,	0x33ff, 0xc80e,		0x21, 0
	.dw 0x3440, 0xc80e,	0x347f, 0xc80e,		0x21, 0
	.dw 0x34c0, 0xc80e,	0x34ff, 0xc80e,		0x21, 0
	.dw 0x3540, 0xc80e,	0x357f, 0xc80e,		0x21, 0
	.dw 0x35c0, 0xc80e,	0x35ff, 0xc80e,		0x21, 0
	.dw 0x3640, 0xc80e,	0x367f, 0xc80e,		0x21, 0
	.dw 0x36c0, 0xc80e,	0x36ff, 0xc80e,		0x21, 0
	.dw 0x3740, 0xc80e,	0x377f, 0xc80e,		0x21, 0
	.dw 0x37c0, 0xc80e,	0x37ff, 0xc80e,		0x21, 0
	.dw 0x3840, 0xc80e,	0x387f, 0xc80e,		0x21, 0
	.dw 0x38c0, 0xc80e,	0x38ff, 0xc80e,		0x21, 0
	.dw 0x3940, 0xc80e,	0x397f, 0xc80e,		0x21, 0
	.dw 0x39c0, 0xc80e,	0x3fff, 0xc80e,		0x21, 0
	.dw 0x4040, 0xc80e,	0x407f, 0xc80e,		0x21, 0
	.dw 0x40c0, 0xc80e,	0x40ff, 0xc80e,		0x21, 0
	.dw 0x4140, 0xc80e,	0x417f, 0xc80e,		0x21, 0
	.dw 0x41c0, 0xc80e,	0x41ff, 0xc80e,		0x21, 0
	.dw 0x4240, 0xc80e,	0x427f, 0xc80e,		0x21, 0
	.dw 0x42c0, 0xc80e,	0x42ff, 0xc80e,		0x21, 0
	.dw 0x4340, 0xc80e,	0x437f, 0xc80e,		0x21, 0
	.dw 0x43c0, 0xc80e,	0x43ff, 0xc80e,		0x21, 0
	.dw 0x4440, 0xc80e,	0x447f, 0xc80e,		0x21, 0
	.dw 0x44c0, 0xc80e,	0x44ff, 0xc80e,		0x21, 0
	.dw 0x4540, 0xc80e,	0x457f, 0xc80e,		0x21, 0
	.dw 0x45c0, 0xc80e,	0x45ff, 0xc80e,		0x21, 0
	.dw 0x4640, 0xc80e,	0x467f, 0xc80e,		0x21, 0
	.dw 0x46c0, 0xc80e,	0x46ff, 0xc80e,		0x21, 0
	.dw 0x4740, 0xc80e,	0x477f, 0xc80e,		0x21, 0
	.dw 0x47c0, 0xc80e,	0x47ff, 0xc80e,		0x21, 0
	.dw 0x4840, 0xc80e,	0x487f, 0xc80e,		0x21, 0
	.dw 0x48c0, 0xc80e,	0x48ff, 0xc80e,		0x21, 0
	.dw 0x4940, 0xc80e,	0x497f, 0xc80e,		0x21, 0
	.dw 0x49c0, 0xc80e,	0x49ff, 0xc80e,		0x21, 0
	.dw 0x4a40, 0xc80e,	0x4a7f, 0xc80e,		0x21, 0
	.dw 0x4ac0, 0xc80e,	0x4aff, 0xc80e,		0x21, 0
	.dw 0x4b40, 0xc80e,	0x4b7f, 0xc80e,		0x21, 0
	.dw 0x4bc0, 0xc80e,	0x4bff, 0xc80e,		0x21, 0
	.dw 0x4c40, 0xc80e,	0x4c7f, 0xc80e,		0x21, 0
	.dw 0x4cc0, 0xc80e,	0x4cff, 0xc80e,		0x21, 0
	.dw 0x4d40, 0xc80e,	0x4d7f, 0xc80e,		0x21, 0
	.dw 0x4dc0, 0xc80e,	0x4dff, 0xc80e,		0x21, 0
	.dw 0x4e40, 0xc80e,	0x4e7f, 0xc80e,		0x21, 0
	.dw 0x4ec0, 0xc80e,	0x4eff, 0xc80e,		0x21, 0
	.dw 0x4f40, 0xc80e,	0x4f7f, 0xc80e,		0x21, 0
	.dw 0x4fc0, 0xc80e,	0x4fff, 0xc80e,		0x21, 0
	.dw 0x5040, 0xc80e,	0x507f, 0xc80e,		0x21, 0
	.dw 0x50c0, 0xc80e,	0x50ff, 0xc80e,		0x21, 0
	.dw 0x5140, 0xc80e,	0x517f, 0xc80e,		0x21, 0
	.dw 0x51c0, 0xc80e,	0x51ff, 0xc80e,		0x21, 0
	.dw 0x5240, 0xc80e,	0x527f, 0xc80e,		0x21, 0
	.dw 0x52c0, 0xc80e,	0x52ff, 0xc80e,		0x21, 0
	.dw 0x5340, 0xc80e,	0x537f, 0xc80e,		0x21, 0
	.dw 0x53c0, 0xc80e,	0x53ff, 0xc80e,		0x21, 0
	.dw 0x5440, 0xc80e,	0x547f, 0xc80e,		0x21, 0
	.dw 0x54c0, 0xc80e,	0x54ff, 0xc80e,		0x21, 0
	.dw 0x5540, 0xc80e,	0x557f, 0xc80e,		0x21, 0
	.dw 0x55c0, 0xc80e,	0x55ff, 0xc80e,		0x21, 0
	.dw 0x5640, 0xc80e,	0x567f, 0xc80e,		0x21, 0
	.dw 0x56c0, 0xc80e,	0x56ff, 0xc80e,		0x21, 0
	.dw 0x5740, 0xc80e,	0x577f, 0xc80e,		0x21, 0
	.dw 0x57c0, 0xc80e,	0x57ff, 0xc80e,		0x21, 0
	.dw 0x5840, 0xc80e,	0x587f, 0xc80e,		0x21, 0
	.dw 0x58c0, 0xc80e,	0x58ff, 0xc80e,		0x21, 0
	.dw 0x5940, 0xc80e,	0x597f, 0xc80e,		0x21, 0
	.dw 0x59c0, 0xc80e,	0x5fff, 0xc80e,		0x21, 0
	.dw 0x6040, 0xc80e,	0x607f, 0xc80e,		0x21, 0
	.dw 0x60c0, 0xc80e,	0x60ff, 0xc80e,		0x21, 0
	.dw 0x6140, 0xc80e,	0x617f, 0xc80e,		0x21, 0
	.dw 0x61c0, 0xc80e,	0x61ff, 0xc80e,		0x21, 0
	.dw 0x6240, 0xc80e,	0x627f, 0xc80e,		0x21, 0
	.dw 0x62c0, 0xc80e,	0x62ff, 0xc80e,		0x21, 0
	.dw 0x6340, 0xc80e,	0x637f, 0xc80e,		0x21, 0
	.dw 0x63c0, 0xc80e,	0x63ff, 0xc80e,		0x21, 0
	.dw 0x6440, 0xc80e,	0x647f, 0xc80e,		0x21, 0
	.dw 0x64c0, 0xc80e,	0x64ff, 0xc80e,		0x21, 0
	.dw 0x6540, 0xc80e,	0x657f, 0xc80e,		0x21, 0
	.dw 0x65c0, 0xc80e,	0x65ff, 0xc80e,		0x21, 0
	.dw 0x6640, 0xc80e,	0x667f, 0xc80e,		0x21, 0
	.dw 0x66c0, 0xc80e,	0x66ff, 0xc80e,		0x21, 0
	.dw 0x6740, 0xc80e,	0x677f, 0xc80e,		0x21, 0
	.dw 0x67c0, 0xc80e,	0x67ff, 0xc80e,		0x21, 0
	.dw 0x6840, 0xc80e,	0x687f, 0xc80e,		0x21, 0
	.dw 0x68c0, 0xc80e,	0x68ff, 0xc80e,		0x21, 0
	.dw 0x6940, 0xc80e,	0x697f, 0xc80e,		0x21, 0
	.dw 0x69c0, 0xc80e,	0x69ff, 0xc80e,		0x21, 0
	.dw 0x6a40, 0xc80e,	0x6a7f, 0xc80e,		0x21, 0
	.dw 0x6ac0, 0xc80e,	0x6aff, 0xc80e,		0x21, 0
	.dw 0x6b40, 0xc80e,	0x6b7f, 0xc80e,		0x21, 0
	.dw 0x6bc0, 0xc80e,	0x6bff, 0xc80e,		0x21, 0
	.dw 0x6c40, 0xc80e,	0x6c7f, 0xc80e,		0x21, 0
	.dw 0x6cc0, 0xc80e,	0x6cff, 0xc80e,		0x21, 0
	.dw 0x6d40, 0xc80e,	0x6d7f, 0xc80e,		0x21, 0
	.dw 0x6dc0, 0xc80e,	0x6dff, 0xc80e,		0x21, 0
	.dw 0x6e40, 0xc80e,	0x6e7f, 0xc80e,		0x21, 0
	.dw 0x6ec0, 0xc80e,	0x6eff, 0xc80e,		0x21, 0
	.dw 0x6f40, 0xc80e,	0x6f7f, 0xc80e,		0x21, 0
	.dw 0x6fc0, 0xc80e,	0x6fff, 0xc80e,		0x21, 0
	.dw 0x7040, 0xc80e,	0x707f, 0xc80e,		0x21, 0
	.dw 0x70c0, 0xc80e,	0x70ff, 0xc80e,		0x21, 0
	.dw 0x7140, 0xc80e,	0x717f, 0xc80e,		0x21, 0
	.dw 0x71c0, 0xc80e,	0x71ff, 0xc80e,		0x21, 0
	.dw 0x7240, 0xc80e,	0x727f, 0xc80e,		0x21, 0
	.dw 0x72c0, 0xc80e,	0x72ff, 0xc80e,		0x21, 0
	.dw 0x7340, 0xc80e,	0x737f, 0xc80e,		0x21, 0
	.dw 0x73c0, 0xc80e,	0x73ff, 0xc80e,		0x21, 0
	.dw 0x7440, 0xc80e,	0x747f, 0xc80e,		0x21, 0
	.dw 0x74c0, 0xc80e,	0x74ff, 0xc80e,		0x21, 0
	.dw 0x7540, 0xc80e,	0x757f, 0xc80e,		0x21, 0
	.dw 0x75c0, 0xc80e,	0x75ff, 0xc80e,		0x21, 0
	.dw 0x7640, 0xc80e,	0x767f, 0xc80e,		0x21, 0
	.dw 0x76c0, 0xc80e,	0x76ff, 0xc80e,		0x21, 0
	.dw 0x7740, 0xc80e,	0x777f, 0xc80e,		0x21, 0
	.dw 0x77c0, 0xc80e,	0x77ff, 0xc80e,		0x21, 0
	.dw 0x7840, 0xc80e,	0x787f, 0xc80e,		0x21, 0
	.dw 0x78c0, 0xc80e,	0x78ff, 0xc80e,		0x21, 0
	.dw 0x7940, 0xc80e,	0x797f, 0xc80e,		0x21, 0
	.dw 0x79c0, 0xc80e,	0x7fff, 0xc80e,		0x21, 0
	.dw 0x8040, 0xc80e,	0x807f, 0xc80e,		0x21, 0
	.dw 0x80c0, 0xc80e,	0x80ff, 0xc80e,		0x21, 0
	.dw 0x8140, 0xc80e,	0x817f, 0xc80e,		0x21, 0
	.dw 0x81c0, 0xc80e,	0x81ff, 0xc80e,		0x21, 0
	.dw 0x8240, 0xc80e,	0x827f, 0xc80e,		0x21, 0
	.dw 0x82c0, 0xc80e,	0x82ff, 0xc80e,		0x21, 0
	.dw 0x8340, 0xc80e,	0x837f, 0xc80e,		0x21, 0
	.dw 0x83c0, 0xc80e,	0x83ff, 0xc80e,		0x21, 0
	.dw 0x8440, 0xc80e,	0x847f, 0xc80e,		0x21, 0
	.dw 0x84c0, 0xc80e,	0x84ff, 0xc80e,		0x21, 0
	.dw 0x8540, 0xc80e,	0x857f, 0xc80e,		0x21, 0
	.dw 0x85c0, 0xc80e,	0x85ff, 0xc80e,		0x21, 0
	.dw 0x8640, 0xc80e,	0x867f, 0xc80e,		0x21, 0
	.dw 0x86c0, 0xc80e,	0x86ff, 0xc80e,		0x21, 0
	.dw 0x8740, 0xc80e,	0x877f, 0xc80e,		0x21, 0
	.dw 0x87c0, 0xc80e,	0x87ff, 0xc80e,		0x21, 0
	.dw 0x8840, 0xc80e,	0x887f, 0xc80e,		0x21, 0
	.dw 0x88c0, 0xc80e,	0x88ff, 0xc80e,		0x21, 0
	.dw 0x8940, 0xc80e,	0x897f, 0xc80e,		0x21, 0
	.dw 0x89c0, 0xc80e,	0x89ff, 0xc80e,		0x21, 0
	.dw 0x8a40, 0xc80e,	0x8a7f, 0xc80e,		0x21, 0
	.dw 0x8ac0, 0xc80e,	0x8aff, 0xc80e,		0x21, 0
	.dw 0x8b40, 0xc80e,	0x8b7f, 0xc80e,		0x21, 0
	.dw 0x8bc0, 0xc80e,	0x8bff, 0xc80e,		0x21, 0
	.dw 0x8c40, 0xc80e,	0x8c7f, 0xc80e,		0x21, 0
	.dw 0x8cc0, 0xc80e,	0x8cff, 0xc80e,		0x21, 0
	.dw 0x8d40, 0xc80e,	0x8d7f, 0xc80e,		0x21, 0
	.dw 0x8dc0, 0xc80e,	0x8dff, 0xc80e,		0x21, 0
	.dw 0x8e40, 0xc80e,	0x8e7f, 0xc80e,		0x21, 0
	.dw 0x8ec0, 0xc80e,	0x8eff, 0xc80e,		0x21, 0
	.dw 0x8f40, 0xc80e,	0x8f7f, 0xc80e,		0x21, 0
	.dw 0x8fc0, 0xc80e,	0x8fff, 0xc80e,		0x21, 0
	.dw 0x9040, 0xc80e,	0x907f, 0xc80e,		0x21, 0
	.dw 0x90c0, 0xc80e,	0x90ff, 0xc80e,		0x21, 0
	.dw 0x9140, 0xc80e,	0x917f, 0xc80e,		0x21, 0
	.dw 0x91c0, 0xc80e,	0x91ff, 0xc80e,		0x21, 0
	.dw 0x9240, 0xc80e,	0x927f, 0xc80e,		0x21, 0
	.dw 0x92c0, 0xc80e,	0x92ff, 0xc80e,		0x21, 0
	.dw 0x9340, 0xc80e,	0x937f, 0xc80e,		0x21, 0
	.dw 0x93c0, 0xc80e,	0x93ff, 0xc80e,		0x21, 0
	.dw 0x9440, 0xc80e,	0x947f, 0xc80e,		0x21, 0
	.dw 0x94c0, 0xc80e,	0x94ff, 0xc80e,		0x21, 0
	.dw 0x9540, 0xc80e,	0x957f, 0xc80e,		0x21, 0
	.dw 0x95c0, 0xc80e,	0x95ff, 0xc80e,		0x21, 0
	.dw 0x9640, 0xc80e,	0x967f, 0xc80e,		0x21, 0
	.dw 0x96c0, 0xc80e,	0x96ff, 0xc80e,		0x21, 0
	.dw 0x9740, 0xc80e,	0x977f, 0xc80e,		0x21, 0
	.dw 0x97c0, 0xc80e,	0x97ff, 0xc80e,		0x21, 0
	.dw 0x9840, 0xc80e,	0x987f, 0xc80e,		0x21, 0
	.dw 0x98c0, 0xc80e,	0x98ff, 0xc80e,		0x21, 0
	.dw 0x9940, 0xc80e,	0x997f, 0xc80e,		0x21, 0
	.dw 0x99c0, 0xc80e,	0x9fff, 0xc80e,		0x21, 0
	.dw 0xa040, 0xc80e,	0xa07f, 0xc80e,		0x21, 0
	.dw 0xa0c0, 0xc80e,	0xa0ff, 0xc80e,		0x21, 0
	.dw 0xa140, 0xc80e,	0xa17f, 0xc80e,		0x21, 0
	.dw 0xa1c0, 0xc80e,	0xa1ff, 0xc80e,		0x21, 0
	.dw 0xa240, 0xc80e,	0xa27f, 0xc80e,		0x21, 0
	.dw 0xa2c0, 0xc80e,	0xa2ff, 0xc80e,		0x21, 0
	.dw 0xa340, 0xc80e,	0xa37f, 0xc80e,		0x21, 0
	.dw 0xa3c0, 0xc80e,	0xa3ff, 0xc80e,		0x21, 0
	.dw 0xa440, 0xc80e,	0xa47f, 0xc80e,		0x21, 0
	.dw 0xa4c0, 0xc80e,	0xa4ff, 0xc80e,		0x21, 0
	.dw 0xa540, 0xc80e,	0xa57f, 0xc80e,		0x21, 0
	.dw 0xa5c0, 0xc80e,	0xa5ff, 0xc80e,		0x21, 0
	.dw 0xa640, 0xc80e,	0xa67f, 0xc80e,		0x21, 0
	.dw 0xa6c0, 0xc80e,	0xa6ff, 0xc80e,		0x21, 0
	.dw 0xa740, 0xc80e,	0xa77f, 0xc80e,		0x21, 0
	.dw 0xa7c0, 0xc80e,	0xa7ff, 0xc80e,		0x21, 0
	.dw 0xa840, 0xc80e,	0xa87f, 0xc80e,		0x21, 0
	.dw 0xa8c0, 0xc80e,	0xa8ff, 0xc80e,		0x21, 0
	.dw 0xa940, 0xc80e,	0xa97f, 0xc80e,		0x21, 0
	.dw 0xa9c0, 0xc80e,	0xa9ff, 0xc80e,		0x21, 0
	.dw 0xaa40, 0xc80e,	0xaa7f, 0xc80e,		0x21, 0
	.dw 0xaac0, 0xc80e,	0xaaff, 0xc80e,		0x21, 0
	.dw 0xab40, 0xc80e,	0xab7f, 0xc80e,		0x21, 0
	.dw 0xabc0, 0xc80e,	0xabff, 0xc80e,		0x21, 0
	.dw 0xac40, 0xc80e,	0xac7f, 0xc80e,		0x21, 0
	.dw 0xacc0, 0xc80e,	0xacff, 0xc80e,		0x21, 0
	.dw 0xad40, 0xc80e,	0xad7f, 0xc80e,		0x21, 0
	.dw 0xadc0, 0xc80e,	0xadff, 0xc80e,		0x21, 0
	.dw 0xae40, 0xc80e,	0xae7f, 0xc80e,		0x21, 0
	.dw 0xaec0, 0xc80e,	0xaeff, 0xc80e,		0x21, 0
	.dw 0xaf40, 0xc80e,	0xaf7f, 0xc80e,		0x21, 0
	.dw 0xafc0, 0xc80e,	0xafff, 0xc80e,		0x21, 0
	.dw 0xb040, 0xc80e,	0xb07f, 0xc80e,		0x21, 0
	.dw 0xb0c0, 0xc80e,	0xb0ff, 0xc80e,		0x21, 0
	.dw 0xb140, 0xc80e,	0xb17f, 0xc80e,		0x21, 0
	.dw 0xb1c0, 0xc80e,	0xb1ff, 0xc80e,		0x21, 0
	.dw 0xb240, 0xc80e,	0xb27f, 0xc80e,		0x21, 0
	.dw 0xb2c0, 0xc80e,	0xb2ff, 0xc80e,		0x21, 0
	.dw 0xb340, 0xc80e,	0xb37f, 0xc80e,		0x21, 0
	.dw 0xb3c0, 0xc80e,	0xb3ff, 0xc80e,		0x21, 0
	.dw 0xb440, 0xc80e,	0xb47f, 0xc80e,		0x21, 0
	.dw 0xb4c0, 0xc80e,	0xb4ff, 0xc80e,		0x21, 0
	.dw 0xb540, 0xc80e,	0xb57f, 0xc80e,		0x21, 0
	.dw 0xb5c0, 0xc80e,	0xb5ff, 0xc80e,		0x21, 0
	.dw 0xb640, 0xc80e,	0xb67f, 0xc80e,		0x21, 0
	.dw 0xb6c0, 0xc80e,	0xb6ff, 0xc80e,		0x21, 0
	.dw 0xb740, 0xc80e,	0xb77f, 0xc80e,		0x21, 0
	.dw 0xb7c0, 0xc80e,	0xb7ff, 0xc80e,		0x21, 0
	.dw 0xb840, 0xc80e,	0xb87f, 0xc80e,		0x21, 0
	.dw 0xb8c0, 0xc80e,	0xb8ff, 0xc80e,		0x21, 0
	.dw 0xb940, 0xc80e,	0xb97f, 0xc80e,		0x21, 0
	.dw 0xb9c0, 0xc80e,	0xbfff, 0xc80e,		0x21, 0
	.dw 0xc040, 0xc80e,	0xc07f, 0xc80e,		0x21, 0
	.dw 0xc0c0, 0xc80e,	0xc0ff, 0xc80e,		0x21, 0
	.dw 0xc140, 0xc80e,	0xc17f, 0xc80e,		0x21, 0
	.dw 0xc1c0, 0xc80e,	0xc1ff, 0xc80e,		0x21, 0
	.dw 0xc240, 0xc80e,	0xc27f, 0xc80e,		0x21, 0
	.dw 0xc2c0, 0xc80e,	0xc2ff, 0xc80e,		0x21, 0
	.dw 0xc340, 0xc80e,	0xc37f, 0xc80e,		0x21, 0
	.dw 0xc3c0, 0xc80e,	0xc3ff, 0xc80e,		0x21, 0
	.dw 0xc440, 0xc80e,	0xc47f, 0xc80e,		0x21, 0
	.dw 0xc4c0, 0xc80e,	0xc4ff, 0xc80e,		0x21, 0
	.dw 0xc540, 0xc80e,	0xc57f, 0xc80e,		0x21, 0
	.dw 0xc5c0, 0xc80e,	0xc5ff, 0xc80e,		0x21, 0
	.dw 0xc640, 0xc80e,	0xc67f, 0xc80e,		0x21, 0
	.dw 0xc6c0, 0xc80e,	0xc6ff, 0xc80e,		0x21, 0
	.dw 0xc740, 0xc80e,	0xc77f, 0xc80e,		0x21, 0
	.dw 0xc7c0, 0xc80e,	0xc7ff, 0xc80e,		0x21, 0
	.dw 0xc840, 0xc80e,	0xc87f, 0xc80e,		0x21, 0
	.dw 0xc8c0, 0xc80e,	0xc8ff, 0xc80e,		0x21, 0
	.dw 0xc940, 0xc80e,	0xc97f, 0xc80e,		0x21, 0
	.dw 0xc9c0, 0xc80e,	0xc9ff, 0xc80e,		0x21, 0
	.dw 0xca40, 0xc80e,	0xca7f, 0xc80e,		0x21, 0
	.dw 0xcac0, 0xc80e,	0xcaff, 0xc80e,		0x21, 0
	.dw 0xcb40, 0xc80e,	0xcb7f, 0xc80e,		0x21, 0
	.dw 0xcbc0, 0xc80e,	0xcbff, 0xc80e,		0x21, 0
	.dw 0xcc40, 0xc80e,	0xcc7f, 0xc80e,		0x21, 0
	.dw 0xccc0, 0xc80e,	0xccff, 0xc80e,		0x21, 0
	.dw 0xcd40, 0xc80e,	0xcd7f, 0xc80e,		0x21, 0
	.dw 0xcdc0, 0xc80e,	0xcdff, 0xc80e,		0x21, 0
	.dw 0xce40, 0xc80e,	0xce7f, 0xc80e,		0x21, 0
	.dw 0xcec0, 0xc80e,	0xceff, 0xc80e,		0x21, 0
	.dw 0xcf40, 0xc80e,	0xcf7f, 0xc80e,		0x21, 0
	.dw 0xcfc0, 0xc80e,	0xcfff, 0xc80e,		0x21, 0
	.dw 0xd040, 0xc80e,	0xd07f, 0xc80e,		0x21, 0
	.dw 0xd0c0, 0xc80e,	0xd0ff, 0xc80e,		0x21, 0
	.dw 0xd140, 0xc80e,	0xd17f, 0xc80e,		0x21, 0
	.dw 0xd1c0, 0xc80e,	0xd1ff, 0xc80e,		0x21, 0
	.dw 0xd240, 0xc80e,	0xd27f, 0xc80e,		0x21, 0
	.dw 0xd2c0, 0xc80e,	0xd2ff, 0xc80e,		0x21, 0
	.dw 0xd340, 0xc80e,	0xd37f, 0xc80e,		0x21, 0
	.dw 0xd3c0, 0xc80e,	0xd3ff, 0xc80e,		0x21, 0
	.dw 0xd440, 0xc80e,	0xd47f, 0xc80e,		0x21, 0
	.dw 0xd4c0, 0xc80e,	0xd4ff, 0xc80e,		0x21, 0
	.dw 0xd540, 0xc80e,	0xd57f, 0xc80e,		0x21, 0
	.dw 0xd5c0, 0xc80e,	0xd5ff, 0xc80e,		0x21, 0
	.dw 0xd640, 0xc80e,	0xd67f, 0xc80e,		0x21, 0
	.dw 0xd6c0, 0xc80e,	0xd6ff, 0xc80e,		0x21, 0
	.dw 0xd740, 0xc80e,	0xd77f, 0xc80e,		0x21, 0
	.dw 0xd7c0, 0xc80e,	0xd7ff, 0xc80e,		0x21, 0
	.dw 0xd840, 0xc80e,	0xd87f, 0xc80e,		0x21, 0
	.dw 0xd8c0, 0xc80e,	0xd8ff, 0xc80e,		0x21, 0
	.dw 0xd940, 0xc80e,	0xd97f, 0xc80e,		0x21, 0
	.dw 0xd9c0, 0xc80e,	0xdfff, 0xc80e,		0x21, 0
	.dw 0xe040, 0xc80e,	0xe07f, 0xc80e,		0x21, 0
	.dw 0xe0c0, 0xc80e,	0xe0ff, 0xc80e,		0x21, 0
	.dw 0xe140, 0xc80e,	0xe17f, 0xc80e,		0x21, 0
	.dw 0xe1c0, 0xc80e,	0xe1ff, 0xc80e,		0x21, 0
	.dw 0xe240, 0xc80e,	0xe27f, 0xc80e,		0x21, 0
	.dw 0xe2c0, 0xc80e,	0xe2ff, 0xc80e,		0x21, 0
	.dw 0xe340, 0xc80e,	0xe37f, 0xc80e,		0x21, 0
	.dw 0xe3c0, 0xc80e,	0xe3ff, 0xc80e,		0x21, 0
	.dw 0xe440, 0xc80e,	0xe47f, 0xc80e,		0x21, 0
	.dw 0xe4c0, 0xc80e,	0xe4ff, 0xc80e,		0x21, 0
	.dw 0xe540, 0xc80e,	0xe57f, 0xc80e,		0x21, 0
	.dw 0xe5c0, 0xc80e,	0xe5ff, 0xc80e,		0x21, 0
	.dw 0xe640, 0xc80e,	0xe67f, 0xc80e,		0x21, 0
	.dw 0xe6c0, 0xc80e,	0xe6ff, 0xc80e,		0x21, 0
	.dw 0xe740, 0xc80e,	0xe77f, 0xc80e,		0x21, 0
	.dw 0xe7c0, 0xc80e,	0xe7ff, 0xc80e,		0x21, 0
	.dw 0xe840, 0xc80e,	0xe87f, 0xc80e,		0x21, 0
	.dw 0xe8c0, 0xc80e,	0xe8ff, 0xc80e,		0x21, 0
	.dw 0xe940, 0xc80e,	0xe97f, 0xc80e,		0x21, 0
	.dw 0xe9c0, 0xc80e,	0xe9ff, 0xc80e,		0x21, 0
	.dw 0xea40, 0xc80e,	0xea7f, 0xc80e,		0x21, 0
	.dw 0xeac0, 0xc80e,	0xeaff, 0xc80e,		0x21, 0
	.dw 0xeb40, 0xc80e,	0xeb7f, 0xc80e,		0x21, 0
	.dw 0xebc0, 0xc80e,	0xebff, 0xc80e,		0x21, 0
	.dw 0xec40, 0xc80e,	0xec7f, 0xc80e,		0x21, 0
	.dw 0xecc0, 0xc80e,	0xecff, 0xc80e,		0x21, 0
	.dw 0xed40, 0xc80e,	0xed7f, 0xc80e,		0x21, 0
	.dw 0xedc0, 0xc80e,	0xedff, 0xc80e,		0x21, 0
	.dw 0xee40, 0xc80e,	0xee7f, 0xc80e,		0x21, 0
	.dw 0xeec0, 0xc80e,	0xeeff, 0xc80e,		0x21, 0
	.dw 0xef40, 0xc80e,	0xef7f, 0xc80e,		0x21, 0
	.dw 0xefc0, 0xc80e,	0xefff, 0xc80e,		0x21, 0
	.dw 0xf040, 0xc80e,	0xf07f, 0xc80e,		0x21, 0
	.dw 0xf0c0, 0xc80e,	0xf0ff, 0xc80e,		0x21, 0
	.dw 0xf140, 0xc80e,	0xf17f, 0xc80e,		0x21, 0
	.dw 0xf1c0, 0xc80e,	0xf1ff, 0xc80e,		0x21, 0
	.dw 0xf240, 0xc80e,	0xf27f, 0xc80e,		0x21, 0
	.dw 0xf2c0, 0xc80e,	0xf2ff, 0xc80e,		0x21, 0
	.dw 0xf340, 0xc80e,	0xf37f, 0xc80e,		0x21, 0
	.dw 0xf3c0, 0xc80e,	0xf3ff, 0xc80e,		0x21, 0
	.dw 0xf440, 0xc80e,	0xf47f, 0xc80e,		0x21, 0
	.dw 0xf4c0, 0xc80e,	0xf4ff, 0xc80e,		0x21, 0
	.dw 0xf540, 0xc80e,	0xf57f, 0xc80e,		0x21, 0
	.dw 0xf5c0, 0xc80e,	0xf5ff, 0xc80e,		0x21, 0
	.dw 0xf640, 0xc80e,	0xf67f, 0xc80e,		0x21, 0
	.dw 0xf6c0, 0xc80e,	0xf6ff, 0xc80e,		0x21, 0
	.dw 0xf740, 0xc80e,	0xf77f, 0xc80e,		0x21, 0
	.dw 0xf7c0, 0xc80e,	0xf7ff, 0xc80e,		0x21, 0
	.dw 0xf840, 0xc80e,	0xf87f, 0xc80e,		0x21, 0
	.dw 0xf8c0, 0xc80e,	0xf8ff, 0xc80e,		0x21, 0
	.dw 0xf940, 0xc80e,	0xf97f, 0xc80e,		0x21, 0
	.dw 0xf9c0, 0xc80e,	0xffff, 0xc80e,		0x21, 0
	.dw 0x0040, 0xc80f,	0x007f, 0xc80f,		0x21, 0
	.dw 0x00c0, 0xc80f,	0x00ff, 0xc80f,		0x21, 0
	.dw 0x0140, 0xc80f,	0x017f, 0xc80f,		0x21, 0
	.dw 0x01c0, 0xc80f,	0x01ff, 0xc80f,		0x21, 0
	.dw 0x0240, 0xc80f,	0x027f, 0xc80f,		0x21, 0
	.dw 0x02c0, 0xc80f,	0x02ff, 0xc80f,		0x21, 0
	.dw 0x0340, 0xc80f,	0x037f, 0xc80f,		0x21, 0
	.dw 0x03c0, 0xc80f,	0x03ff, 0xc80f,		0x21, 0
	.dw 0x0440, 0xc80f,	0x047f, 0xc80f,		0x21, 0
	.dw 0x04c0, 0xc80f,	0x04ff, 0xc80f,		0x21, 0
	.dw 0x0540, 0xc80f,	0x057f, 0xc80f,		0x21, 0
	.dw 0x05c0, 0xc80f,	0x05ff, 0xc80f,		0x21, 0
	.dw 0x0640, 0xc80f,	0x067f, 0xc80f,		0x21, 0
	.dw 0x06c0, 0xc80f,	0x06ff, 0xc80f,		0x21, 0
	.dw 0x0740, 0xc80f,	0x077f, 0xc80f,		0x21, 0
	.dw 0x07c0, 0xc80f,	0x07ff, 0xc80f,		0x21, 0
	.dw 0x0840, 0xc80f,	0x087f, 0xc80f,		0x21, 0
	.dw 0x08c0, 0xc80f,	0x08ff, 0xc80f,		0x21, 0
	.dw 0x0940, 0xc80f,	0x097f, 0xc80f,		0x21, 0
	.dw 0x09c0, 0xc80f,	0x09ff, 0xc80f,		0x21, 0
	.dw 0x0a40, 0xc80f,	0x0a7f, 0xc80f,		0x21, 0
	.dw 0x0ac0, 0xc80f,	0x0aff, 0xc80f,		0x21, 0
	.dw 0x0b40, 0xc80f,	0x0b7f, 0xc80f,		0x21, 0
	.dw 0x0bc0, 0xc80f,	0x0bff, 0xc80f,		0x21, 0
	.dw 0x0c40, 0xc80f,	0x0c7f, 0xc80f,		0x21, 0
	.dw 0x0cc0, 0xc80f,	0x0cff, 0xc80f,		0x21, 0
	.dw 0x0d40, 0xc80f,	0x0d7f, 0xc80f,		0x21, 0
	.dw 0x0dc0, 0xc80f,	0x0dff, 0xc80f,		0x21, 0
	.dw 0x0e40, 0xc80f,	0x0e7f, 0xc80f,		0x21, 0
	.dw 0x0ec0, 0xc80f,	0x0eff, 0xc80f,		0x21, 0
	.dw 0x0f40, 0xc80f,	0x0f7f, 0xc80f,		0x21, 0
	.dw 0x0fc0, 0xc80f,	0x0fff, 0xc80f,		0x21, 0
	.dw 0x1040, 0xc80f,	0x107f, 0xc80f,		0x21, 0
	.dw 0x10c0, 0xc80f,	0x10ff, 0xc80f,		0x21, 0
	.dw 0x1140, 0xc80f,	0x117f, 0xc80f,		0x21, 0
	.dw 0x11c0, 0xc80f,	0x11ff, 0xc80f,		0x21, 0
	.dw 0x1240, 0xc80f,	0x127f, 0xc80f,		0x21, 0
	.dw 0x12c0, 0xc80f,	0x12ff, 0xc80f,		0x21, 0
	.dw 0x1340, 0xc80f,	0x137f, 0xc80f,		0x21, 0
	.dw 0x13c0, 0xc80f,	0x13ff, 0xc80f,		0x21, 0
	.dw 0x1440, 0xc80f,	0x147f, 0xc80f,		0x21, 0
	.dw 0x14c0, 0xc80f,	0x14ff, 0xc80f,		0x21, 0
	.dw 0x1540, 0xc80f,	0x157f, 0xc80f,		0x21, 0
	.dw 0x15c0, 0xc80f,	0x15ff, 0xc80f,		0x21, 0
	.dw 0x1640, 0xc80f,	0x167f, 0xc80f,		0x21, 0
	.dw 0x16c0, 0xc80f,	0x16ff, 0xc80f,		0x21, 0
	.dw 0x1740, 0xc80f,	0x177f, 0xc80f,		0x21, 0
	.dw 0x17c0, 0xc80f,	0x17ff, 0xc80f,		0x21, 0
	.dw 0x1840, 0xc80f,	0x187f, 0xc80f,		0x21, 0
	.dw 0x18c0, 0xc80f,	0x18ff, 0xc80f,		0x21, 0
	.dw 0x1940, 0xc80f,	0x197f, 0xc80f,		0x21, 0
	.dw 0x19c0, 0xc80f,	0x1fff, 0xc80f,		0x21, 0
	.dw 0x2040, 0xc80f,	0x207f, 0xc80f,		0x21, 0
	.dw 0x20c0, 0xc80f,	0x20ff, 0xc80f,		0x21, 0
	.dw 0x2140, 0xc80f,	0x217f, 0xc80f,		0x21, 0
	.dw 0x21c0, 0xc80f,	0x21ff, 0xc80f,		0x21, 0
	.dw 0x2240, 0xc80f,	0x227f, 0xc80f,		0x21, 0
	.dw 0x22c0, 0xc80f,	0x22ff, 0xc80f,		0x21, 0
	.dw 0x2340, 0xc80f,	0x237f, 0xc80f,		0x21, 0
	.dw 0x23c0, 0xc80f,	0x23ff, 0xc80f,		0x21, 0
	.dw 0x2440, 0xc80f,	0x247f, 0xc80f,		0x21, 0
	.dw 0x24c0, 0xc80f,	0x24ff, 0xc80f,		0x21, 0
	.dw 0x2540, 0xc80f,	0x257f, 0xc80f,		0x21, 0
	.dw 0x25c0, 0xc80f,	0x25ff, 0xc80f,		0x21, 0
	.dw 0x2640, 0xc80f,	0x267f, 0xc80f,		0x21, 0
	.dw 0x26c0, 0xc80f,	0x26ff, 0xc80f,		0x21, 0
	.dw 0x2740, 0xc80f,	0x277f, 0xc80f,		0x21, 0
	.dw 0x27c0, 0xc80f,	0x27ff, 0xc80f,		0x21, 0
	.dw 0x2840, 0xc80f,	0x287f, 0xc80f,		0x21, 0
	.dw 0x28c0, 0xc80f,	0x28ff, 0xc80f,		0x21, 0
	.dw 0x2940, 0xc80f,	0x297f, 0xc80f,		0x21, 0
	.dw 0x29c0, 0xc80f,	0x29ff, 0xc80f,		0x21, 0
	.dw 0x2a40, 0xc80f,	0x2a7f, 0xc80f,		0x21, 0
	.dw 0x2ac0, 0xc80f,	0x2aff, 0xc80f,		0x21, 0
	.dw 0x2b40, 0xc80f,	0x2b7f, 0xc80f,		0x21, 0
	.dw 0x2bc0, 0xc80f,	0x2bff, 0xc80f,		0x21, 0
	.dw 0x2c40, 0xc80f,	0x2c7f, 0xc80f,		0x21, 0
	.dw 0x2cc0, 0xc80f,	0x2cff, 0xc80f,		0x21, 0
	.dw 0x2d40, 0xc80f,	0x2d7f, 0xc80f,		0x21, 0
	.dw 0x2dc0, 0xc80f,	0x2dff, 0xc80f,		0x21, 0
	.dw 0x2e40, 0xc80f,	0x2e7f, 0xc80f,		0x21, 0
	.dw 0x2ec0, 0xc80f,	0x2eff, 0xc80f,		0x21, 0
	.dw 0x2f40, 0xc80f,	0x2f7f, 0xc80f,		0x21, 0
	.dw 0x2fc0, 0xc80f,	0x2fff, 0xc80f,		0x21, 0
	.dw 0x3040, 0xc80f,	0x307f, 0xc80f,		0x21, 0
	.dw 0x30c0, 0xc80f,	0x30ff, 0xc80f,		0x21, 0
	.dw 0x3140, 0xc80f,	0x317f, 0xc80f,		0x21, 0
	.dw 0x31c0, 0xc80f,	0x31ff, 0xc80f,		0x21, 0
	.dw 0x3240, 0xc80f,	0x327f, 0xc80f,		0x21, 0
	.dw 0x32c0, 0xc80f,	0x32ff, 0xc80f,		0x21, 0
	.dw 0x3340, 0xc80f,	0x337f, 0xc80f,		0x21, 0
	.dw 0x33c0, 0xc80f,	0x33ff, 0xc80f,		0x21, 0
	.dw 0x3440, 0xc80f,	0x347f, 0xc80f,		0x21, 0
	.dw 0x34c0, 0xc80f,	0x34ff, 0xc80f,		0x21, 0
	.dw 0x3540, 0xc80f,	0x357f, 0xc80f,		0x21, 0
	.dw 0x35c0, 0xc80f,	0x35ff, 0xc80f,		0x21, 0
	.dw 0x3640, 0xc80f,	0x367f, 0xc80f,		0x21, 0
	.dw 0x36c0, 0xc80f,	0x36ff, 0xc80f,		0x21, 0
	.dw 0x3740, 0xc80f,	0x377f, 0xc80f,		0x21, 0
	.dw 0x37c0, 0xc80f,	0x37ff, 0xc80f,		0x21, 0
	.dw 0x3840, 0xc80f,	0x387f, 0xc80f,		0x21, 0
	.dw 0x38c0, 0xc80f,	0x38ff, 0xc80f,		0x21, 0
	.dw 0x3940, 0xc80f,	0x397f, 0xc80f,		0x21, 0
	.dw 0x39c0, 0xc80f,	0xffff, 0xc80f,		0x21, 0
	.dw 0x1a00, 0xc810,	0x1fff, 0xc810,		0x21, 0
	.dw 0x3a00, 0xc810,	0x3fff, 0xc810,		0x21, 0
	.dw 0x5a00, 0xc810,	0x5fff, 0xc810,		0x21, 0
	.dw 0x7a00, 0xc810,	0x7fff, 0xc810,		0x21, 0
	.dw 0x9a00, 0xc810,	0x9fff, 0xc810,		0x21, 0
	.dw 0xba00, 0xc810,	0xbfff, 0xc810,		0x21, 0
	.dw 0xda00, 0xc810,	0xdfff, 0xc810,		0x21, 0
	.dw 0xfa00, 0xc810,	0xffff, 0xc810,		0x21, 0
	.dw 0x1a00, 0xc811,	0x1fff, 0xc811,		0x21, 0
	.dw 0x3a00, 0xc811,	0x3fff, 0xc811,		0x21, 0
	.dw 0x5a00, 0xc811,	0x5fff, 0xc811,		0x21, 0
	.dw 0x7a00, 0xc811,	0x7fff, 0xc811,		0x21, 0
	.dw 0x9a00, 0xc811,	0x9fff, 0xc811,		0x21, 0
	.dw 0xba00, 0xc811,	0xbfff, 0xc811,		0x21, 0
	.dw 0xda00, 0xc811,	0xdfff, 0xc811,		0x21, 0
	.dw 0xfa00, 0xc811,	0xffff, 0xc811,		0x21, 0
	.dw 0x1a00, 0xc812,	0x1fff, 0xc812,		0x21, 0
	.dw 0x3a00, 0xc812,	0x3fff, 0xc812,		0x21, 0
	.dw 0x5a00, 0xc812,	0x5fff, 0xc812,		0x21, 0
	.dw 0x7a00, 0xc812,	0x7fff, 0xc812,		0x21, 0
	.dw 0x9a00, 0xc812,	0x9fff, 0xc812,		0x21, 0
	.dw 0xba00, 0xc812,	0xbfff, 0xc812,		0x21, 0
	.dw 0xda00, 0xc812,	0xdfff, 0xc812,		0x21, 0
	.dw 0xfa00, 0xc812,	0xffff, 0xc813,		0x21, 0
	.dw 0x1a00, 0xc814,	0x1fff, 0xc814,		0x21, 0
	.dw 0x3a00, 0xc814,	0x3fff, 0xc814,		0x21, 0
	.dw 0x5a00, 0xc814,	0x5fff, 0xc814,		0x21, 0
	.dw 0x7a00, 0xc814,	0x7fff, 0xc814,		0x21, 0
	.dw 0x9a00, 0xc814,	0x9fff, 0xc814,		0x21, 0
	.dw 0xba00, 0xc814,	0xbfff, 0xc814,		0x21, 0
	.dw 0xda00, 0xc814,	0xdfff, 0xc814,		0x21, 0
	.dw 0xfa00, 0xc814,	0xffff, 0xc814,		0x21, 0
	.dw 0x1a00, 0xc815,	0x1fff, 0xc815,		0x21, 0
	.dw 0x3a00, 0xc815,	0x3fff, 0xc815,		0x21, 0
	.dw 0x5a00, 0xc815,	0x5fff, 0xc815,		0x21, 0
	.dw 0x7a00, 0xc815,	0x7fff, 0xc815,		0x21, 0
	.dw 0x9a00, 0xc815,	0x9fff, 0xc815,		0x21, 0
	.dw 0xba00, 0xc815,	0xbfff, 0xc815,		0x21, 0
	.dw 0xda00, 0xc815,	0xdfff, 0xc815,		0x21, 0
	.dw 0xfa00, 0xc815,	0xffff, 0xc815,		0x21, 0
	.dw 0x1a00, 0xc816,	0x1fff, 0xc816,		0x21, 0
	.dw 0x3a00, 0xc816,	0x3fff, 0xc816,		0x21, 0
	.dw 0x5a00, 0xc816,	0x5fff, 0xc816,		0x21, 0
	.dw 0x7a00, 0xc816,	0x7fff, 0xc816,		0x21, 0
	.dw 0x9a00, 0xc816,	0x9fff, 0xc816,		0x21, 0
	.dw 0xba00, 0xc816,	0xbfff, 0xc816,		0x21, 0
	.dw 0xda00, 0xc816,	0xdfff, 0xc816,		0x21, 0
	.dw 0xfa00, 0xc816,	0xffff, 0xc816,		0x21, 0
	.dw 0x1a00, 0xc817,	0x1fff, 0xc817,		0x21, 0
	.dw 0x3a00, 0xc817,	0x1fff, 0xc818,		0x21, 0
	.dw 0x2040, 0xc818,	0x207f, 0xc818,		0x21, 0
	.dw 0x20c0, 0xc818,	0x20ff, 0xc818,		0x21, 0
	.dw 0x2140, 0xc818,	0x217f, 0xc818,		0x21, 0
	.dw 0x21c0, 0xc818,	0x21ff, 0xc818,		0x21, 0
	.dw 0x2240, 0xc818,	0x227f, 0xc818,		0x21, 0
	.dw 0x22c0, 0xc818,	0x22ff, 0xc818,		0x21, 0
	.dw 0x2340, 0xc818,	0x237f, 0xc818,		0x21, 0
	.dw 0x23c0, 0xc818,	0x23ff, 0xc818,		0x21, 0
	.dw 0x2440, 0xc818,	0x247f, 0xc818,		0x21, 0
	.dw 0x24c0, 0xc818,	0x24ff, 0xc818,		0x21, 0
	.dw 0x2540, 0xc818,	0x257f, 0xc818,		0x21, 0
	.dw 0x25c0, 0xc818,	0x25ff, 0xc818,		0x21, 0
	.dw 0x2640, 0xc818,	0x267f, 0xc818,		0x21, 0
	.dw 0x26c0, 0xc818,	0x26ff, 0xc818,		0x21, 0
	.dw 0x2740, 0xc818,	0x277f, 0xc818,		0x21, 0
	.dw 0x27c0, 0xc818,	0x27ff, 0xc818,		0x21, 0
	.dw 0x2840, 0xc818,	0x287f, 0xc818,		0x21, 0
	.dw 0x28c0, 0xc818,	0x28ff, 0xc818,		0x21, 0
	.dw 0x2940, 0xc818,	0x297f, 0xc818,		0x21, 0
	.dw 0x29c0, 0xc818,	0x29ff, 0xc818,		0x21, 0
	.dw 0x2a40, 0xc818,	0x2a7f, 0xc818,		0x21, 0
	.dw 0x2ac0, 0xc818,	0x2aff, 0xc818,		0x21, 0
	.dw 0x2b40, 0xc818,	0x2b7f, 0xc818,		0x21, 0
	.dw 0x2bc0, 0xc818,	0x2bff, 0xc818,		0x21, 0
	.dw 0x2c40, 0xc818,	0x2c7f, 0xc818,		0x21, 0
	.dw 0x2cc0, 0xc818,	0x2cff, 0xc818,		0x21, 0
	.dw 0x2d40, 0xc818,	0x2d7f, 0xc818,		0x21, 0
	.dw 0x2dc0, 0xc818,	0x2dff, 0xc818,		0x21, 0
	.dw 0x2e40, 0xc818,	0x2e7f, 0xc818,		0x21, 0
	.dw 0x2ec0, 0xc818,	0x2eff, 0xc818,		0x21, 0
	.dw 0x2f40, 0xc818,	0x2f7f, 0xc818,		0x21, 0
	.dw 0x2fc0, 0xc818,	0x2fff, 0xc818,		0x21, 0
	.dw 0x3040, 0xc818,	0x307f, 0xc818,		0x21, 0
	.dw 0x30c0, 0xc818,	0x30ff, 0xc818,		0x21, 0
	.dw 0x3140, 0xc818,	0x317f, 0xc818,		0x21, 0
	.dw 0x31c0, 0xc818,	0x31ff, 0xc818,		0x21, 0
	.dw 0x3240, 0xc818,	0x327f, 0xc818,		0x21, 0
	.dw 0x32c0, 0xc818,	0x32ff, 0xc818,		0x21, 0
	.dw 0x3340, 0xc818,	0x337f, 0xc818,		0x21, 0
	.dw 0x33c0, 0xc818,	0x33ff, 0xc818,		0x21, 0
	.dw 0x3440, 0xc818,	0x347f, 0xc818,		0x21, 0
	.dw 0x34c0, 0xc818,	0x34ff, 0xc818,		0x21, 0
	.dw 0x3540, 0xc818,	0x357f, 0xc818,		0x21, 0
	.dw 0x35c0, 0xc818,	0x35ff, 0xc818,		0x21, 0
	.dw 0x3640, 0xc818,	0x367f, 0xc818,		0x21, 0
	.dw 0x36c0, 0xc818,	0x36ff, 0xc818,		0x21, 0
	.dw 0x3740, 0xc818,	0x377f, 0xc818,		0x21, 0
	.dw 0x37c0, 0xc818,	0x37ff, 0xc818,		0x21, 0
	.dw 0x3840, 0xc818,	0x387f, 0xc818,		0x21, 0
	.dw 0x38c0, 0xc818,	0x38ff, 0xc818,		0x21, 0
	.dw 0x3940, 0xc818,	0x397f, 0xc818,		0x21, 0
	.dw 0x39c0, 0xc818,	0x5fff, 0xc818,		0x21, 0
	.dw 0x6040, 0xc818,	0x607f, 0xc818,		0x21, 0
	.dw 0x60c0, 0xc818,	0x60ff, 0xc818,		0x21, 0
	.dw 0x6140, 0xc818,	0x617f, 0xc818,		0x21, 0
	.dw 0x61c0, 0xc818,	0x61ff, 0xc818,		0x21, 0
	.dw 0x6240, 0xc818,	0x627f, 0xc818,		0x21, 0
	.dw 0x62c0, 0xc818,	0x62ff, 0xc818,		0x21, 0
	.dw 0x6340, 0xc818,	0x637f, 0xc818,		0x21, 0
	.dw 0x63c0, 0xc818,	0x63ff, 0xc818,		0x21, 0
	.dw 0x6440, 0xc818,	0x647f, 0xc818,		0x21, 0
	.dw 0x64c0, 0xc818,	0x64ff, 0xc818,		0x21, 0
	.dw 0x6540, 0xc818,	0x657f, 0xc818,		0x21, 0
	.dw 0x65c0, 0xc818,	0x65ff, 0xc818,		0x21, 0
	.dw 0x6640, 0xc818,	0x667f, 0xc818,		0x21, 0
	.dw 0x66c0, 0xc818,	0x66ff, 0xc818,		0x21, 0
	.dw 0x6740, 0xc818,	0x677f, 0xc818,		0x21, 0
	.dw 0x67c0, 0xc818,	0x67ff, 0xc818,		0x21, 0
	.dw 0x6840, 0xc818,	0x687f, 0xc818,		0x21, 0
	.dw 0x68c0, 0xc818,	0x68ff, 0xc818,		0x21, 0
	.dw 0x6940, 0xc818,	0x697f, 0xc818,		0x21, 0
	.dw 0x69c0, 0xc818,	0x69ff, 0xc818,		0x21, 0
	.dw 0x6a40, 0xc818,	0x6a7f, 0xc818,		0x21, 0
	.dw 0x6ac0, 0xc818,	0x6aff, 0xc818,		0x21, 0
	.dw 0x6b40, 0xc818,	0x6b7f, 0xc818,		0x21, 0
	.dw 0x6bc0, 0xc818,	0x6bff, 0xc818,		0x21, 0
	.dw 0x6c40, 0xc818,	0x6c7f, 0xc818,		0x21, 0
	.dw 0x6cc0, 0xc818,	0x6cff, 0xc818,		0x21, 0
	.dw 0x6d40, 0xc818,	0x6d7f, 0xc818,		0x21, 0
	.dw 0x6dc0, 0xc818,	0x6dff, 0xc818,		0x21, 0
	.dw 0x6e40, 0xc818,	0x6e7f, 0xc818,		0x21, 0
	.dw 0x6ec0, 0xc818,	0x6eff, 0xc818,		0x21, 0
	.dw 0x6f40, 0xc818,	0x6f7f, 0xc818,		0x21, 0
	.dw 0x6fc0, 0xc818,	0x6fff, 0xc818,		0x21, 0
	.dw 0x7040, 0xc818,	0x707f, 0xc818,		0x21, 0
	.dw 0x70c0, 0xc818,	0x70ff, 0xc818,		0x21, 0
	.dw 0x7140, 0xc818,	0x717f, 0xc818,		0x21, 0
	.dw 0x71c0, 0xc818,	0x71ff, 0xc818,		0x21, 0
	.dw 0x7240, 0xc818,	0x727f, 0xc818,		0x21, 0
	.dw 0x72c0, 0xc818,	0x72ff, 0xc818,		0x21, 0
	.dw 0x7340, 0xc818,	0x737f, 0xc818,		0x21, 0
	.dw 0x73c0, 0xc818,	0x73ff, 0xc818,		0x21, 0
	.dw 0x7440, 0xc818,	0x747f, 0xc818,		0x21, 0
	.dw 0x74c0, 0xc818,	0x74ff, 0xc818,		0x21, 0
	.dw 0x7540, 0xc818,	0x757f, 0xc818,		0x21, 0
	.dw 0x75c0, 0xc818,	0x75ff, 0xc818,		0x21, 0
	.dw 0x7640, 0xc818,	0x767f, 0xc818,		0x21, 0
	.dw 0x76c0, 0xc818,	0x76ff, 0xc818,		0x21, 0
	.dw 0x7740, 0xc818,	0x777f, 0xc818,		0x21, 0
	.dw 0x77c0, 0xc818,	0x77ff, 0xc818,		0x21, 0
	.dw 0x7840, 0xc818,	0x787f, 0xc818,		0x21, 0
	.dw 0x78c0, 0xc818,	0x78ff, 0xc818,		0x21, 0
	.dw 0x7940, 0xc818,	0x797f, 0xc818,		0x21, 0
	.dw 0x79c0, 0xc818,	0x9fff, 0xc818,		0x21, 0
	.dw 0xa040, 0xc818,	0xa07f, 0xc818,		0x21, 0
	.dw 0xa0c0, 0xc818,	0xa0ff, 0xc818,		0x21, 0
	.dw 0xa140, 0xc818,	0xa17f, 0xc818,		0x21, 0
	.dw 0xa1c0, 0xc818,	0xa1ff, 0xc818,		0x21, 0
	.dw 0xa240, 0xc818,	0xa27f, 0xc818,		0x21, 0
	.dw 0xa2c0, 0xc818,	0xa2ff, 0xc818,		0x21, 0
	.dw 0xa340, 0xc818,	0xa37f, 0xc818,		0x21, 0
	.dw 0xa3c0, 0xc818,	0xa3ff, 0xc818,		0x21, 0
	.dw 0xa440, 0xc818,	0xa47f, 0xc818,		0x21, 0
	.dw 0xa4c0, 0xc818,	0xa4ff, 0xc818,		0x21, 0
	.dw 0xa540, 0xc818,	0xa57f, 0xc818,		0x21, 0
	.dw 0xa5c0, 0xc818,	0xa5ff, 0xc818,		0x21, 0
	.dw 0xa640, 0xc818,	0xa67f, 0xc818,		0x21, 0
	.dw 0xa6c0, 0xc818,	0xa6ff, 0xc818,		0x21, 0
	.dw 0xa740, 0xc818,	0xa77f, 0xc818,		0x21, 0
	.dw 0xa7c0, 0xc818,	0xa7ff, 0xc818,		0x21, 0
	.dw 0xa840, 0xc818,	0xa87f, 0xc818,		0x21, 0
	.dw 0xa8c0, 0xc818,	0xa8ff, 0xc818,		0x21, 0
	.dw 0xa940, 0xc818,	0xa97f, 0xc818,		0x21, 0
	.dw 0xa9c0, 0xc818,	0xa9ff, 0xc818,		0x21, 0
	.dw 0xaa40, 0xc818,	0xaa7f, 0xc818,		0x21, 0
	.dw 0xaac0, 0xc818,	0xaaff, 0xc818,		0x21, 0
	.dw 0xab40, 0xc818,	0xab7f, 0xc818,		0x21, 0
	.dw 0xabc0, 0xc818,	0xabff, 0xc818,		0x21, 0
	.dw 0xac40, 0xc818,	0xac7f, 0xc818,		0x21, 0
	.dw 0xacc0, 0xc818,	0xacff, 0xc818,		0x21, 0
	.dw 0xad40, 0xc818,	0xad7f, 0xc818,		0x21, 0
	.dw 0xadc0, 0xc818,	0xadff, 0xc818,		0x21, 0
	.dw 0xae40, 0xc818,	0xae7f, 0xc818,		0x21, 0
	.dw 0xaec0, 0xc818,	0xaeff, 0xc818,		0x21, 0
	.dw 0xaf40, 0xc818,	0xaf7f, 0xc818,		0x21, 0
	.dw 0xafc0, 0xc818,	0xafff, 0xc818,		0x21, 0
	.dw 0xb040, 0xc818,	0xb07f, 0xc818,		0x21, 0
	.dw 0xb0c0, 0xc818,	0xb0ff, 0xc818,		0x21, 0
	.dw 0xb140, 0xc818,	0xb17f, 0xc818,		0x21, 0
	.dw 0xb1c0, 0xc818,	0xb1ff, 0xc818,		0x21, 0
	.dw 0xb240, 0xc818,	0xb27f, 0xc818,		0x21, 0
	.dw 0xb2c0, 0xc818,	0xb2ff, 0xc818,		0x21, 0
	.dw 0xb340, 0xc818,	0xb37f, 0xc818,		0x21, 0
	.dw 0xb3c0, 0xc818,	0xb3ff, 0xc818,		0x21, 0
	.dw 0xb440, 0xc818,	0xb47f, 0xc818,		0x21, 0
	.dw 0xb4c0, 0xc818,	0xb4ff, 0xc818,		0x21, 0
	.dw 0xb540, 0xc818,	0xb57f, 0xc818,		0x21, 0
	.dw 0xb5c0, 0xc818,	0xb5ff, 0xc818,		0x21, 0
	.dw 0xb640, 0xc818,	0xb67f, 0xc818,		0x21, 0
	.dw 0xb6c0, 0xc818,	0xb6ff, 0xc818,		0x21, 0
	.dw 0xb740, 0xc818,	0xb77f, 0xc818,		0x21, 0
	.dw 0xb7c0, 0xc818,	0xb7ff, 0xc818,		0x21, 0
	.dw 0xb840, 0xc818,	0xb87f, 0xc818,		0x21, 0
	.dw 0xb8c0, 0xc818,	0xb8ff, 0xc818,		0x21, 0
	.dw 0xb940, 0xc818,	0xb97f, 0xc818,		0x21, 0
	.dw 0xb9c0, 0xc818,	0xdfff, 0xc818,		0x21, 0
	.dw 0xe040, 0xc818,	0xe07f, 0xc818,		0x21, 0
	.dw 0xe0c0, 0xc818,	0xe0ff, 0xc818,		0x21, 0
	.dw 0xe140, 0xc818,	0xe17f, 0xc818,		0x21, 0
	.dw 0xe1c0, 0xc818,	0xe1ff, 0xc818,		0x21, 0
	.dw 0xe240, 0xc818,	0xe27f, 0xc818,		0x21, 0
	.dw 0xe2c0, 0xc818,	0xe2ff, 0xc818,		0x21, 0
	.dw 0xe340, 0xc818,	0xe37f, 0xc818,		0x21, 0
	.dw 0xe3c0, 0xc818,	0xe3ff, 0xc818,		0x21, 0
	.dw 0xe440, 0xc818,	0xe47f, 0xc818,		0x21, 0
	.dw 0xe4c0, 0xc818,	0xe4ff, 0xc818,		0x21, 0
	.dw 0xe540, 0xc818,	0xe57f, 0xc818,		0x21, 0
	.dw 0xe5c0, 0xc818,	0xe5ff, 0xc818,		0x21, 0
	.dw 0xe640, 0xc818,	0xe67f, 0xc818,		0x21, 0
	.dw 0xe6c0, 0xc818,	0xe6ff, 0xc818,		0x21, 0
	.dw 0xe740, 0xc818,	0xe77f, 0xc818,		0x21, 0
	.dw 0xe7c0, 0xc818,	0xe7ff, 0xc818,		0x21, 0
	.dw 0xe840, 0xc818,	0xe87f, 0xc818,		0x21, 0
	.dw 0xe8c0, 0xc818,	0xe8ff, 0xc818,		0x21, 0
	.dw 0xe940, 0xc818,	0xe97f, 0xc818,		0x21, 0
	.dw 0xe9c0, 0xc818,	0xe9ff, 0xc818,		0x21, 0
	.dw 0xea40, 0xc818,	0xea7f, 0xc818,		0x21, 0
	.dw 0xeac0, 0xc818,	0xeaff, 0xc818,		0x21, 0
	.dw 0xeb40, 0xc818,	0xeb7f, 0xc818,		0x21, 0
	.dw 0xebc0, 0xc818,	0xebff, 0xc818,		0x21, 0
	.dw 0xec40, 0xc818,	0xec7f, 0xc818,		0x21, 0
	.dw 0xecc0, 0xc818,	0xecff, 0xc818,		0x21, 0
	.dw 0xed40, 0xc818,	0xed7f, 0xc818,		0x21, 0
	.dw 0xedc0, 0xc818,	0xedff, 0xc818,		0x21, 0
	.dw 0xee40, 0xc818,	0xee7f, 0xc818,		0x21, 0
	.dw 0xeec0, 0xc818,	0xeeff, 0xc818,		0x21, 0
	.dw 0xef40, 0xc818,	0xef7f, 0xc818,		0x21, 0
	.dw 0xefc0, 0xc818,	0xefff, 0xc818,		0x21, 0
	.dw 0xf040, 0xc818,	0xf07f, 0xc818,		0x21, 0
	.dw 0xf0c0, 0xc818,	0xf0ff, 0xc818,		0x21, 0
	.dw 0xf140, 0xc818,	0xf17f, 0xc818,		0x21, 0
	.dw 0xf1c0, 0xc818,	0xf1ff, 0xc818,		0x21, 0
	.dw 0xf240, 0xc818,	0xf27f, 0xc818,		0x21, 0
	.dw 0xf2c0, 0xc818,	0xf2ff, 0xc818,		0x21, 0
	.dw 0xf340, 0xc818,	0xf37f, 0xc818,		0x21, 0
	.dw 0xf3c0, 0xc818,	0xf3ff, 0xc818,		0x21, 0
	.dw 0xf440, 0xc818,	0xf47f, 0xc818,		0x21, 0
	.dw 0xf4c0, 0xc818,	0xf4ff, 0xc818,		0x21, 0
	.dw 0xf540, 0xc818,	0xf57f, 0xc818,		0x21, 0
	.dw 0xf5c0, 0xc818,	0xf5ff, 0xc818,		0x21, 0
	.dw 0xf640, 0xc818,	0xf67f, 0xc818,		0x21, 0
	.dw 0xf6c0, 0xc818,	0xf6ff, 0xc818,		0x21, 0
	.dw 0xf740, 0xc818,	0xf77f, 0xc818,		0x21, 0
	.dw 0xf7c0, 0xc818,	0xf7ff, 0xc818,		0x21, 0
	.dw 0xf840, 0xc818,	0xf87f, 0xc818,		0x21, 0
	.dw 0xf8c0, 0xc818,	0xf8ff, 0xc818,		0x21, 0
	.dw 0xf940, 0xc818,	0xf97f, 0xc818,		0x21, 0
	.dw 0xf9c0, 0xc818,	0x1fff, 0xc819,		0x21, 0
	.dw 0x2040, 0xc819,	0x207f, 0xc819,		0x21, 0
	.dw 0x20c0, 0xc819,	0x20ff, 0xc819,		0x21, 0
	.dw 0x2140, 0xc819,	0x217f, 0xc819,		0x21, 0
	.dw 0x21c0, 0xc819,	0x21ff, 0xc819,		0x21, 0
	.dw 0x2240, 0xc819,	0x227f, 0xc819,		0x21, 0
	.dw 0x22c0, 0xc819,	0x22ff, 0xc819,		0x21, 0
	.dw 0x2340, 0xc819,	0x237f, 0xc819,		0x21, 0
	.dw 0x23c0, 0xc819,	0x23ff, 0xc819,		0x21, 0
	.dw 0x2440, 0xc819,	0x247f, 0xc819,		0x21, 0
	.dw 0x24c0, 0xc819,	0x24ff, 0xc819,		0x21, 0
	.dw 0x2540, 0xc819,	0x257f, 0xc819,		0x21, 0
	.dw 0x25c0, 0xc819,	0x25ff, 0xc819,		0x21, 0
	.dw 0x2640, 0xc819,	0x267f, 0xc819,		0x21, 0
	.dw 0x26c0, 0xc819,	0x26ff, 0xc819,		0x21, 0
	.dw 0x2740, 0xc819,	0x277f, 0xc819,		0x21, 0
	.dw 0x27c0, 0xc819,	0x27ff, 0xc819,		0x21, 0
	.dw 0x2840, 0xc819,	0x287f, 0xc819,		0x21, 0
	.dw 0x28c0, 0xc819,	0x28ff, 0xc819,		0x21, 0
	.dw 0x2940, 0xc819,	0x297f, 0xc819,		0x21, 0
	.dw 0x29c0, 0xc819,	0x29ff, 0xc819,		0x21, 0
	.dw 0x2a40, 0xc819,	0x2a7f, 0xc819,		0x21, 0
	.dw 0x2ac0, 0xc819,	0x2aff, 0xc819,		0x21, 0
	.dw 0x2b40, 0xc819,	0x2b7f, 0xc819,		0x21, 0
	.dw 0x2bc0, 0xc819,	0x2bff, 0xc819,		0x21, 0
	.dw 0x2c40, 0xc819,	0x2c7f, 0xc819,		0x21, 0
	.dw 0x2cc0, 0xc819,	0x2cff, 0xc819,		0x21, 0
	.dw 0x2d40, 0xc819,	0x2d7f, 0xc819,		0x21, 0
	.dw 0x2dc0, 0xc819,	0x2dff, 0xc819,		0x21, 0
	.dw 0x2e40, 0xc819,	0x2e7f, 0xc819,		0x21, 0
	.dw 0x2ec0, 0xc819,	0x2eff, 0xc819,		0x21, 0
	.dw 0x2f40, 0xc819,	0x2f7f, 0xc819,		0x21, 0
	.dw 0x2fc0, 0xc819,	0x2fff, 0xc819,		0x21, 0
	.dw 0x3040, 0xc819,	0x307f, 0xc819,		0x21, 0
	.dw 0x30c0, 0xc819,	0x30ff, 0xc819,		0x21, 0
	.dw 0x3140, 0xc819,	0x317f, 0xc819,		0x21, 0
	.dw 0x31c0, 0xc819,	0x31ff, 0xc819,		0x21, 0
	.dw 0x3240, 0xc819,	0x327f, 0xc819,		0x21, 0
	.dw 0x32c0, 0xc819,	0x32ff, 0xc819,		0x21, 0
	.dw 0x3340, 0xc819,	0x337f, 0xc819,		0x21, 0
	.dw 0x33c0, 0xc819,	0x33ff, 0xc819,		0x21, 0
	.dw 0x3440, 0xc819,	0x347f, 0xc819,		0x21, 0
	.dw 0x34c0, 0xc819,	0x34ff, 0xc819,		0x21, 0
	.dw 0x3540, 0xc819,	0x357f, 0xc819,		0x21, 0
	.dw 0x35c0, 0xc819,	0x35ff, 0xc819,		0x21, 0
	.dw 0x3640, 0xc819,	0x367f, 0xc819,		0x21, 0
	.dw 0x36c0, 0xc819,	0x36ff, 0xc819,		0x21, 0
	.dw 0x3740, 0xc819,	0x377f, 0xc819,		0x21, 0
	.dw 0x37c0, 0xc819,	0x37ff, 0xc819,		0x21, 0
	.dw 0x3840, 0xc819,	0x387f, 0xc819,		0x21, 0
	.dw 0x38c0, 0xc819,	0x38ff, 0xc819,		0x21, 0
	.dw 0x3940, 0xc819,	0x397f, 0xc819,		0x21, 0
	.dw 0x39c0, 0xc819,	0x5fff, 0xc819,		0x21, 0
	.dw 0x6040, 0xc819,	0x607f, 0xc819,		0x21, 0
	.dw 0x60c0, 0xc819,	0x60ff, 0xc819,		0x21, 0
	.dw 0x6140, 0xc819,	0x617f, 0xc819,		0x21, 0
	.dw 0x61c0, 0xc819,	0x61ff, 0xc819,		0x21, 0
	.dw 0x6240, 0xc819,	0x627f, 0xc819,		0x21, 0
	.dw 0x62c0, 0xc819,	0x62ff, 0xc819,		0x21, 0
	.dw 0x6340, 0xc819,	0x637f, 0xc819,		0x21, 0
	.dw 0x63c0, 0xc819,	0x63ff, 0xc819,		0x21, 0
	.dw 0x6440, 0xc819,	0x647f, 0xc819,		0x21, 0
	.dw 0x64c0, 0xc819,	0x64ff, 0xc819,		0x21, 0
	.dw 0x6540, 0xc819,	0x657f, 0xc819,		0x21, 0
	.dw 0x65c0, 0xc819,	0x65ff, 0xc819,		0x21, 0
	.dw 0x6640, 0xc819,	0x667f, 0xc819,		0x21, 0
	.dw 0x66c0, 0xc819,	0x66ff, 0xc819,		0x21, 0
	.dw 0x6740, 0xc819,	0x677f, 0xc819,		0x21, 0
	.dw 0x67c0, 0xc819,	0x67ff, 0xc819,		0x21, 0
	.dw 0x6840, 0xc819,	0x687f, 0xc819,		0x21, 0
	.dw 0x68c0, 0xc819,	0x68ff, 0xc819,		0x21, 0
	.dw 0x6940, 0xc819,	0x697f, 0xc819,		0x21, 0
	.dw 0x69c0, 0xc819,	0x69ff, 0xc819,		0x21, 0
	.dw 0x6a40, 0xc819,	0x6a7f, 0xc819,		0x21, 0
	.dw 0x6ac0, 0xc819,	0x6aff, 0xc819,		0x21, 0
	.dw 0x6b40, 0xc819,	0x6b7f, 0xc819,		0x21, 0
	.dw 0x6bc0, 0xc819,	0x6bff, 0xc819,		0x21, 0
	.dw 0x6c40, 0xc819,	0x6c7f, 0xc819,		0x21, 0
	.dw 0x6cc0, 0xc819,	0x6cff, 0xc819,		0x21, 0
	.dw 0x6d40, 0xc819,	0x6d7f, 0xc819,		0x21, 0
	.dw 0x6dc0, 0xc819,	0x6dff, 0xc819,		0x21, 0
	.dw 0x6e40, 0xc819,	0x6e7f, 0xc819,		0x21, 0
	.dw 0x6ec0, 0xc819,	0x6eff, 0xc819,		0x21, 0
	.dw 0x6f40, 0xc819,	0x6f7f, 0xc819,		0x21, 0
	.dw 0x6fc0, 0xc819,	0x6fff, 0xc819,		0x21, 0
	.dw 0x7040, 0xc819,	0x707f, 0xc819,		0x21, 0
	.dw 0x70c0, 0xc819,	0x70ff, 0xc819,		0x21, 0
	.dw 0x7140, 0xc819,	0x717f, 0xc819,		0x21, 0
	.dw 0x71c0, 0xc819,	0x71ff, 0xc819,		0x21, 0
	.dw 0x7240, 0xc819,	0x727f, 0xc819,		0x21, 0
	.dw 0x72c0, 0xc819,	0x72ff, 0xc819,		0x21, 0
	.dw 0x7340, 0xc819,	0x737f, 0xc819,		0x21, 0
	.dw 0x73c0, 0xc819,	0x73ff, 0xc819,		0x21, 0
	.dw 0x7440, 0xc819,	0x747f, 0xc819,		0x21, 0
	.dw 0x74c0, 0xc819,	0x74ff, 0xc819,		0x21, 0
	.dw 0x7540, 0xc819,	0x757f, 0xc819,		0x21, 0
	.dw 0x75c0, 0xc819,	0x75ff, 0xc819,		0x21, 0
	.dw 0x7640, 0xc819,	0x767f, 0xc819,		0x21, 0
	.dw 0x76c0, 0xc819,	0x76ff, 0xc819,		0x21, 0
	.dw 0x7740, 0xc819,	0x777f, 0xc819,		0x21, 0
	.dw 0x77c0, 0xc819,	0x77ff, 0xc819,		0x21, 0
	.dw 0x7840, 0xc819,	0x787f, 0xc819,		0x21, 0
	.dw 0x78c0, 0xc819,	0x78ff, 0xc819,		0x21, 0
	.dw 0x7940, 0xc819,	0x797f, 0xc819,		0x21, 0
	.dw 0x79c0, 0xc819,	0x9fff, 0xc819,		0x21, 0
	.dw 0xa040, 0xc819,	0xa07f, 0xc819,		0x21, 0
	.dw 0xa0c0, 0xc819,	0xa0ff, 0xc819,		0x21, 0
	.dw 0xa140, 0xc819,	0xa17f, 0xc819,		0x21, 0
	.dw 0xa1c0, 0xc819,	0xa1ff, 0xc819,		0x21, 0
	.dw 0xa240, 0xc819,	0xa27f, 0xc819,		0x21, 0
	.dw 0xa2c0, 0xc819,	0xa2ff, 0xc819,		0x21, 0
	.dw 0xa340, 0xc819,	0xa37f, 0xc819,		0x21, 0
	.dw 0xa3c0, 0xc819,	0xa3ff, 0xc819,		0x21, 0
	.dw 0xa440, 0xc819,	0xa47f, 0xc819,		0x21, 0
	.dw 0xa4c0, 0xc819,	0xa4ff, 0xc819,		0x21, 0
	.dw 0xa540, 0xc819,	0xa57f, 0xc819,		0x21, 0
	.dw 0xa5c0, 0xc819,	0xa5ff, 0xc819,		0x21, 0
	.dw 0xa640, 0xc819,	0xa67f, 0xc819,		0x21, 0
	.dw 0xa6c0, 0xc819,	0xa6ff, 0xc819,		0x21, 0
	.dw 0xa740, 0xc819,	0xa77f, 0xc819,		0x21, 0
	.dw 0xa7c0, 0xc819,	0xa7ff, 0xc819,		0x21, 0
	.dw 0xa840, 0xc819,	0xa87f, 0xc819,		0x21, 0
	.dw 0xa8c0, 0xc819,	0xa8ff, 0xc819,		0x21, 0
	.dw 0xa940, 0xc819,	0xa97f, 0xc819,		0x21, 0
	.dw 0xa9c0, 0xc819,	0xa9ff, 0xc819,		0x21, 0
	.dw 0xaa40, 0xc819,	0xaa7f, 0xc819,		0x21, 0
	.dw 0xaac0, 0xc819,	0xaaff, 0xc819,		0x21, 0
	.dw 0xab40, 0xc819,	0xab7f, 0xc819,		0x21, 0
	.dw 0xabc0, 0xc819,	0xabff, 0xc819,		0x21, 0
	.dw 0xac40, 0xc819,	0xac7f, 0xc819,		0x21, 0
	.dw 0xacc0, 0xc819,	0xacff, 0xc819,		0x21, 0
	.dw 0xad40, 0xc819,	0xad7f, 0xc819,		0x21, 0
	.dw 0xadc0, 0xc819,	0xadff, 0xc819,		0x21, 0
	.dw 0xae40, 0xc819,	0xae7f, 0xc819,		0x21, 0
	.dw 0xaec0, 0xc819,	0xaeff, 0xc819,		0x21, 0
	.dw 0xaf40, 0xc819,	0xaf7f, 0xc819,		0x21, 0
	.dw 0xafc0, 0xc819,	0xafff, 0xc819,		0x21, 0
	.dw 0xb040, 0xc819,	0xb07f, 0xc819,		0x21, 0
	.dw 0xb0c0, 0xc819,	0xb0ff, 0xc819,		0x21, 0
	.dw 0xb140, 0xc819,	0xb17f, 0xc819,		0x21, 0
	.dw 0xb1c0, 0xc819,	0xb1ff, 0xc819,		0x21, 0
	.dw 0xb240, 0xc819,	0xb27f, 0xc819,		0x21, 0
	.dw 0xb2c0, 0xc819,	0xb2ff, 0xc819,		0x21, 0
	.dw 0xb340, 0xc819,	0xb37f, 0xc819,		0x21, 0
	.dw 0xb3c0, 0xc819,	0xb3ff, 0xc819,		0x21, 0
	.dw 0xb440, 0xc819,	0xb47f, 0xc819,		0x21, 0
	.dw 0xb4c0, 0xc819,	0xb4ff, 0xc819,		0x21, 0
	.dw 0xb540, 0xc819,	0xb57f, 0xc819,		0x21, 0
	.dw 0xb5c0, 0xc819,	0xb5ff, 0xc819,		0x21, 0
	.dw 0xb640, 0xc819,	0xb67f, 0xc819,		0x21, 0
	.dw 0xb6c0, 0xc819,	0xb6ff, 0xc819,		0x21, 0
	.dw 0xb740, 0xc819,	0xb77f, 0xc819,		0x21, 0
	.dw 0xb7c0, 0xc819,	0xb7ff, 0xc819,		0x21, 0
	.dw 0xb840, 0xc819,	0xb87f, 0xc819,		0x21, 0
	.dw 0xb8c0, 0xc819,	0xb8ff, 0xc819,		0x21, 0
	.dw 0xb940, 0xc819,	0xb97f, 0xc819,		0x21, 0
	.dw 0xb9c0, 0xc819,	0xdfff, 0xc819,		0x21, 0
	.dw 0xe040, 0xc819,	0xe07f, 0xc819,		0x21, 0
	.dw 0xe0c0, 0xc819,	0xe0ff, 0xc819,		0x21, 0
	.dw 0xe140, 0xc819,	0xe17f, 0xc819,		0x21, 0
	.dw 0xe1c0, 0xc819,	0xe1ff, 0xc819,		0x21, 0
	.dw 0xe240, 0xc819,	0xe27f, 0xc819,		0x21, 0
	.dw 0xe2c0, 0xc819,	0xe2ff, 0xc819,		0x21, 0
	.dw 0xe340, 0xc819,	0xe37f, 0xc819,		0x21, 0
	.dw 0xe3c0, 0xc819,	0xe3ff, 0xc819,		0x21, 0
	.dw 0xe440, 0xc819,	0xe47f, 0xc819,		0x21, 0
	.dw 0xe4c0, 0xc819,	0xe4ff, 0xc819,		0x21, 0
	.dw 0xe540, 0xc819,	0xe57f, 0xc819,		0x21, 0
	.dw 0xe5c0, 0xc819,	0xe5ff, 0xc819,		0x21, 0
	.dw 0xe640, 0xc819,	0xe67f, 0xc819,		0x21, 0
	.dw 0xe6c0, 0xc819,	0xe6ff, 0xc819,		0x21, 0
	.dw 0xe740, 0xc819,	0xe77f, 0xc819,		0x21, 0
	.dw 0xe7c0, 0xc819,	0xe7ff, 0xc819,		0x21, 0
	.dw 0xe840, 0xc819,	0xe87f, 0xc819,		0x21, 0
	.dw 0xe8c0, 0xc819,	0xe8ff, 0xc819,		0x21, 0
	.dw 0xe940, 0xc819,	0xe97f, 0xc819,		0x21, 0
	.dw 0xe9c0, 0xc819,	0xe9ff, 0xc819,		0x21, 0
	.dw 0xea40, 0xc819,	0xea7f, 0xc819,		0x21, 0
	.dw 0xeac0, 0xc819,	0xeaff, 0xc819,		0x21, 0
	.dw 0xeb40, 0xc819,	0xeb7f, 0xc819,		0x21, 0
	.dw 0xebc0, 0xc819,	0xebff, 0xc819,		0x21, 0
	.dw 0xec40, 0xc819,	0xec7f, 0xc819,		0x21, 0
	.dw 0xecc0, 0xc819,	0xecff, 0xc819,		0x21, 0
	.dw 0xed40, 0xc819,	0xed7f, 0xc819,		0x21, 0
	.dw 0xedc0, 0xc819,	0xedff, 0xc819,		0x21, 0
	.dw 0xee40, 0xc819,	0xee7f, 0xc819,		0x21, 0
	.dw 0xeec0, 0xc819,	0xeeff, 0xc819,		0x21, 0
	.dw 0xef40, 0xc819,	0xef7f, 0xc819,		0x21, 0
	.dw 0xefc0, 0xc819,	0xefff, 0xc819,		0x21, 0
	.dw 0xf040, 0xc819,	0xf07f, 0xc819,		0x21, 0
	.dw 0xf0c0, 0xc819,	0xf0ff, 0xc819,		0x21, 0
	.dw 0xf140, 0xc819,	0xf17f, 0xc819,		0x21, 0
	.dw 0xf1c0, 0xc819,	0xf1ff, 0xc819,		0x21, 0
	.dw 0xf240, 0xc819,	0xf27f, 0xc819,		0x21, 0
	.dw 0xf2c0, 0xc819,	0xf2ff, 0xc819,		0x21, 0
	.dw 0xf340, 0xc819,	0xf37f, 0xc819,		0x21, 0
	.dw 0xf3c0, 0xc819,	0xf3ff, 0xc819,		0x21, 0
	.dw 0xf440, 0xc819,	0xf47f, 0xc819,		0x21, 0
	.dw 0xf4c0, 0xc819,	0xf4ff, 0xc819,		0x21, 0
	.dw 0xf540, 0xc819,	0xf57f, 0xc819,		0x21, 0
	.dw 0xf5c0, 0xc819,	0xf5ff, 0xc819,		0x21, 0
	.dw 0xf640, 0xc819,	0xf67f, 0xc819,		0x21, 0
	.dw 0xf6c0, 0xc819,	0xf6ff, 0xc819,		0x21, 0
	.dw 0xf740, 0xc819,	0xf77f, 0xc819,		0x21, 0
	.dw 0xf7c0, 0xc819,	0xf7ff, 0xc819,		0x21, 0
	.dw 0xf840, 0xc819,	0xf87f, 0xc819,		0x21, 0
	.dw 0xf8c0, 0xc819,	0xf8ff, 0xc819,		0x21, 0
	.dw 0xf940, 0xc819,	0xf97f, 0xc819,		0x21, 0
	.dw 0xf9c0, 0xc819,	0x1fff, 0xc81a,		0x21, 0
	.dw 0x2040, 0xc81a,	0x207f, 0xc81a,		0x21, 0
	.dw 0x20c0, 0xc81a,	0x20ff, 0xc81a,		0x21, 0
	.dw 0x2140, 0xc81a,	0x217f, 0xc81a,		0x21, 0
	.dw 0x21c0, 0xc81a,	0x21ff, 0xc81a,		0x21, 0
	.dw 0x2240, 0xc81a,	0x227f, 0xc81a,		0x21, 0
	.dw 0x22c0, 0xc81a,	0x22ff, 0xc81a,		0x21, 0
	.dw 0x2340, 0xc81a,	0x237f, 0xc81a,		0x21, 0
	.dw 0x23c0, 0xc81a,	0x23ff, 0xc81a,		0x21, 0
	.dw 0x2440, 0xc81a,	0x247f, 0xc81a,		0x21, 0
	.dw 0x24c0, 0xc81a,	0x24ff, 0xc81a,		0x21, 0
	.dw 0x2540, 0xc81a,	0x257f, 0xc81a,		0x21, 0
	.dw 0x25c0, 0xc81a,	0x25ff, 0xc81a,		0x21, 0
	.dw 0x2640, 0xc81a,	0x267f, 0xc81a,		0x21, 0
	.dw 0x26c0, 0xc81a,	0x26ff, 0xc81a,		0x21, 0
	.dw 0x2740, 0xc81a,	0x277f, 0xc81a,		0x21, 0
	.dw 0x27c0, 0xc81a,	0x27ff, 0xc81a,		0x21, 0
	.dw 0x2840, 0xc81a,	0x287f, 0xc81a,		0x21, 0
	.dw 0x28c0, 0xc81a,	0x28ff, 0xc81a,		0x21, 0
	.dw 0x2940, 0xc81a,	0x297f, 0xc81a,		0x21, 0
	.dw 0x29c0, 0xc81a,	0x29ff, 0xc81a,		0x21, 0
	.dw 0x2a40, 0xc81a,	0x2a7f, 0xc81a,		0x21, 0
	.dw 0x2ac0, 0xc81a,	0x2aff, 0xc81a,		0x21, 0
	.dw 0x2b40, 0xc81a,	0x2b7f, 0xc81a,		0x21, 0
	.dw 0x2bc0, 0xc81a,	0x2bff, 0xc81a,		0x21, 0
	.dw 0x2c40, 0xc81a,	0x2c7f, 0xc81a,		0x21, 0
	.dw 0x2cc0, 0xc81a,	0x2cff, 0xc81a,		0x21, 0
	.dw 0x2d40, 0xc81a,	0x2d7f, 0xc81a,		0x21, 0
	.dw 0x2dc0, 0xc81a,	0x2dff, 0xc81a,		0x21, 0
	.dw 0x2e40, 0xc81a,	0x2e7f, 0xc81a,		0x21, 0
	.dw 0x2ec0, 0xc81a,	0x2eff, 0xc81a,		0x21, 0
	.dw 0x2f40, 0xc81a,	0x2f7f, 0xc81a,		0x21, 0
	.dw 0x2fc0, 0xc81a,	0x2fff, 0xc81a,		0x21, 0
	.dw 0x3040, 0xc81a,	0x307f, 0xc81a,		0x21, 0
	.dw 0x30c0, 0xc81a,	0x30ff, 0xc81a,		0x21, 0
	.dw 0x3140, 0xc81a,	0x317f, 0xc81a,		0x21, 0
	.dw 0x31c0, 0xc81a,	0x31ff, 0xc81a,		0x21, 0
	.dw 0x3240, 0xc81a,	0x327f, 0xc81a,		0x21, 0
	.dw 0x32c0, 0xc81a,	0x32ff, 0xc81a,		0x21, 0
	.dw 0x3340, 0xc81a,	0x337f, 0xc81a,		0x21, 0
	.dw 0x33c0, 0xc81a,	0x33ff, 0xc81a,		0x21, 0
	.dw 0x3440, 0xc81a,	0x347f, 0xc81a,		0x21, 0
	.dw 0x34c0, 0xc81a,	0x34ff, 0xc81a,		0x21, 0
	.dw 0x3540, 0xc81a,	0x357f, 0xc81a,		0x21, 0
	.dw 0x35c0, 0xc81a,	0x35ff, 0xc81a,		0x21, 0
	.dw 0x3640, 0xc81a,	0x367f, 0xc81a,		0x21, 0
	.dw 0x36c0, 0xc81a,	0x36ff, 0xc81a,		0x21, 0
	.dw 0x3740, 0xc81a,	0x377f, 0xc81a,		0x21, 0
	.dw 0x37c0, 0xc81a,	0x37ff, 0xc81a,		0x21, 0
	.dw 0x3840, 0xc81a,	0x387f, 0xc81a,		0x21, 0
	.dw 0x38c0, 0xc81a,	0x38ff, 0xc81a,		0x21, 0
	.dw 0x3940, 0xc81a,	0x397f, 0xc81a,		0x21, 0
	.dw 0x39c0, 0xc81a,	0x5fff, 0xc81a,		0x21, 0
	.dw 0x6040, 0xc81a,	0x607f, 0xc81a,		0x21, 0
	.dw 0x60c0, 0xc81a,	0x60ff, 0xc81a,		0x21, 0
	.dw 0x6140, 0xc81a,	0x617f, 0xc81a,		0x21, 0
	.dw 0x61c0, 0xc81a,	0x61ff, 0xc81a,		0x21, 0
	.dw 0x6240, 0xc81a,	0x627f, 0xc81a,		0x21, 0
	.dw 0x62c0, 0xc81a,	0x62ff, 0xc81a,		0x21, 0
	.dw 0x6340, 0xc81a,	0x637f, 0xc81a,		0x21, 0
	.dw 0x63c0, 0xc81a,	0x63ff, 0xc81a,		0x21, 0
	.dw 0x6440, 0xc81a,	0x647f, 0xc81a,		0x21, 0
	.dw 0x64c0, 0xc81a,	0x64ff, 0xc81a,		0x21, 0
	.dw 0x6540, 0xc81a,	0x657f, 0xc81a,		0x21, 0
	.dw 0x65c0, 0xc81a,	0x65ff, 0xc81a,		0x21, 0
	.dw 0x6640, 0xc81a,	0x667f, 0xc81a,		0x21, 0
	.dw 0x66c0, 0xc81a,	0x66ff, 0xc81a,		0x21, 0
	.dw 0x6740, 0xc81a,	0x677f, 0xc81a,		0x21, 0
	.dw 0x67c0, 0xc81a,	0x67ff, 0xc81a,		0x21, 0
	.dw 0x6840, 0xc81a,	0x687f, 0xc81a,		0x21, 0
	.dw 0x68c0, 0xc81a,	0x68ff, 0xc81a,		0x21, 0
	.dw 0x6940, 0xc81a,	0x697f, 0xc81a,		0x21, 0
	.dw 0x69c0, 0xc81a,	0x69ff, 0xc81a,		0x21, 0
	.dw 0x6a40, 0xc81a,	0x6a7f, 0xc81a,		0x21, 0
	.dw 0x6ac0, 0xc81a,	0x6aff, 0xc81a,		0x21, 0
	.dw 0x6b40, 0xc81a,	0x6b7f, 0xc81a,		0x21, 0
	.dw 0x6bc0, 0xc81a,	0x6bff, 0xc81a,		0x21, 0
	.dw 0x6c40, 0xc81a,	0x6c7f, 0xc81a,		0x21, 0
	.dw 0x6cc0, 0xc81a,	0x6cff, 0xc81a,		0x21, 0
	.dw 0x6d40, 0xc81a,	0x6d7f, 0xc81a,		0x21, 0
	.dw 0x6dc0, 0xc81a,	0x6dff, 0xc81a,		0x21, 0
	.dw 0x6e40, 0xc81a,	0x6e7f, 0xc81a,		0x21, 0
	.dw 0x6ec0, 0xc81a,	0x6eff, 0xc81a,		0x21, 0
	.dw 0x6f40, 0xc81a,	0x6f7f, 0xc81a,		0x21, 0
	.dw 0x6fc0, 0xc81a,	0x6fff, 0xc81a,		0x21, 0
	.dw 0x7040, 0xc81a,	0x707f, 0xc81a,		0x21, 0
	.dw 0x70c0, 0xc81a,	0x70ff, 0xc81a,		0x21, 0
	.dw 0x7140, 0xc81a,	0x717f, 0xc81a,		0x21, 0
	.dw 0x71c0, 0xc81a,	0x71ff, 0xc81a,		0x21, 0
	.dw 0x7240, 0xc81a,	0x727f, 0xc81a,		0x21, 0
	.dw 0x72c0, 0xc81a,	0x72ff, 0xc81a,		0x21, 0
	.dw 0x7340, 0xc81a,	0x737f, 0xc81a,		0x21, 0
	.dw 0x73c0, 0xc81a,	0x73ff, 0xc81a,		0x21, 0
	.dw 0x7440, 0xc81a,	0x747f, 0xc81a,		0x21, 0
	.dw 0x74c0, 0xc81a,	0x74ff, 0xc81a,		0x21, 0
	.dw 0x7540, 0xc81a,	0x757f, 0xc81a,		0x21, 0
	.dw 0x75c0, 0xc81a,	0x75ff, 0xc81a,		0x21, 0
	.dw 0x7640, 0xc81a,	0x767f, 0xc81a,		0x21, 0
	.dw 0x76c0, 0xc81a,	0x76ff, 0xc81a,		0x21, 0
	.dw 0x7740, 0xc81a,	0x777f, 0xc81a,		0x21, 0
	.dw 0x77c0, 0xc81a,	0x77ff, 0xc81a,		0x21, 0
	.dw 0x7840, 0xc81a,	0x787f, 0xc81a,		0x21, 0
	.dw 0x78c0, 0xc81a,	0x78ff, 0xc81a,		0x21, 0
	.dw 0x7940, 0xc81a,	0x797f, 0xc81a,		0x21, 0
	.dw 0x79c0, 0xc81a,	0x9fff, 0xc81a,		0x21, 0
	.dw 0xa040, 0xc81a,	0xa07f, 0xc81a,		0x21, 0
	.dw 0xa0c0, 0xc81a,	0xa0ff, 0xc81a,		0x21, 0
	.dw 0xa140, 0xc81a,	0xa17f, 0xc81a,		0x21, 0
	.dw 0xa1c0, 0xc81a,	0xa1ff, 0xc81a,		0x21, 0
	.dw 0xa240, 0xc81a,	0xa27f, 0xc81a,		0x21, 0
	.dw 0xa2c0, 0xc81a,	0xa2ff, 0xc81a,		0x21, 0
	.dw 0xa340, 0xc81a,	0xa37f, 0xc81a,		0x21, 0
	.dw 0xa3c0, 0xc81a,	0xa3ff, 0xc81a,		0x21, 0
	.dw 0xa440, 0xc81a,	0xa47f, 0xc81a,		0x21, 0
	.dw 0xa4c0, 0xc81a,	0xa4ff, 0xc81a,		0x21, 0
	.dw 0xa540, 0xc81a,	0xa57f, 0xc81a,		0x21, 0
	.dw 0xa5c0, 0xc81a,	0xa5ff, 0xc81a,		0x21, 0
	.dw 0xa640, 0xc81a,	0xa67f, 0xc81a,		0x21, 0
	.dw 0xa6c0, 0xc81a,	0xa6ff, 0xc81a,		0x21, 0
	.dw 0xa740, 0xc81a,	0xa77f, 0xc81a,		0x21, 0
	.dw 0xa7c0, 0xc81a,	0xa7ff, 0xc81a,		0x21, 0
	.dw 0xa840, 0xc81a,	0xa87f, 0xc81a,		0x21, 0
	.dw 0xa8c0, 0xc81a,	0xa8ff, 0xc81a,		0x21, 0
	.dw 0xa940, 0xc81a,	0xa97f, 0xc81a,		0x21, 0
	.dw 0xa9c0, 0xc81a,	0xa9ff, 0xc81a,		0x21, 0
	.dw 0xaa40, 0xc81a,	0xaa7f, 0xc81a,		0x21, 0
	.dw 0xaac0, 0xc81a,	0xaaff, 0xc81a,		0x21, 0
	.dw 0xab40, 0xc81a,	0xab7f, 0xc81a,		0x21, 0
	.dw 0xabc0, 0xc81a,	0xabff, 0xc81a,		0x21, 0
	.dw 0xac40, 0xc81a,	0xac7f, 0xc81a,		0x21, 0
	.dw 0xacc0, 0xc81a,	0xacff, 0xc81a,		0x21, 0
	.dw 0xad40, 0xc81a,	0xad7f, 0xc81a,		0x21, 0
	.dw 0xadc0, 0xc81a,	0xadff, 0xc81a,		0x21, 0
	.dw 0xae40, 0xc81a,	0xae7f, 0xc81a,		0x21, 0
	.dw 0xaec0, 0xc81a,	0xaeff, 0xc81a,		0x21, 0
	.dw 0xaf40, 0xc81a,	0xaf7f, 0xc81a,		0x21, 0
	.dw 0xafc0, 0xc81a,	0xafff, 0xc81a,		0x21, 0
	.dw 0xb040, 0xc81a,	0xb07f, 0xc81a,		0x21, 0
	.dw 0xb0c0, 0xc81a,	0xb0ff, 0xc81a,		0x21, 0
	.dw 0xb140, 0xc81a,	0xb17f, 0xc81a,		0x21, 0
	.dw 0xb1c0, 0xc81a,	0xb1ff, 0xc81a,		0x21, 0
	.dw 0xb240, 0xc81a,	0xb27f, 0xc81a,		0x21, 0
	.dw 0xb2c0, 0xc81a,	0xb2ff, 0xc81a,		0x21, 0
	.dw 0xb340, 0xc81a,	0xb37f, 0xc81a,		0x21, 0
	.dw 0xb3c0, 0xc81a,	0xb3ff, 0xc81a,		0x21, 0
	.dw 0xb440, 0xc81a,	0xb47f, 0xc81a,		0x21, 0
	.dw 0xb4c0, 0xc81a,	0xb4ff, 0xc81a,		0x21, 0
	.dw 0xb540, 0xc81a,	0xb57f, 0xc81a,		0x21, 0
	.dw 0xb5c0, 0xc81a,	0xb5ff, 0xc81a,		0x21, 0
	.dw 0xb640, 0xc81a,	0xb67f, 0xc81a,		0x21, 0
	.dw 0xb6c0, 0xc81a,	0xb6ff, 0xc81a,		0x21, 0
	.dw 0xb740, 0xc81a,	0xb77f, 0xc81a,		0x21, 0
	.dw 0xb7c0, 0xc81a,	0xb7ff, 0xc81a,		0x21, 0
	.dw 0xb840, 0xc81a,	0xb87f, 0xc81a,		0x21, 0
	.dw 0xb8c0, 0xc81a,	0xb8ff, 0xc81a,		0x21, 0
	.dw 0xb940, 0xc81a,	0xb97f, 0xc81a,		0x21, 0
	.dw 0xb9c0, 0xc81a,	0xdfff, 0xc81a,		0x21, 0
	.dw 0xe040, 0xc81a,	0xe07f, 0xc81a,		0x21, 0
	.dw 0xe0c0, 0xc81a,	0xe0ff, 0xc81a,		0x21, 0
	.dw 0xe140, 0xc81a,	0xe17f, 0xc81a,		0x21, 0
	.dw 0xe1c0, 0xc81a,	0xe1ff, 0xc81a,		0x21, 0
	.dw 0xe240, 0xc81a,	0xe27f, 0xc81a,		0x21, 0
	.dw 0xe2c0, 0xc81a,	0xe2ff, 0xc81a,		0x21, 0
	.dw 0xe340, 0xc81a,	0xe37f, 0xc81a,		0x21, 0
	.dw 0xe3c0, 0xc81a,	0xe3ff, 0xc81a,		0x21, 0
	.dw 0xe440, 0xc81a,	0xe47f, 0xc81a,		0x21, 0
	.dw 0xe4c0, 0xc81a,	0xe4ff, 0xc81a,		0x21, 0
	.dw 0xe540, 0xc81a,	0xe57f, 0xc81a,		0x21, 0
	.dw 0xe5c0, 0xc81a,	0xe5ff, 0xc81a,		0x21, 0
	.dw 0xe640, 0xc81a,	0xe67f, 0xc81a,		0x21, 0
	.dw 0xe6c0, 0xc81a,	0xe6ff, 0xc81a,		0x21, 0
	.dw 0xe740, 0xc81a,	0xe77f, 0xc81a,		0x21, 0
	.dw 0xe7c0, 0xc81a,	0xe7ff, 0xc81a,		0x21, 0
	.dw 0xe840, 0xc81a,	0xe87f, 0xc81a,		0x21, 0
	.dw 0xe8c0, 0xc81a,	0xe8ff, 0xc81a,		0x21, 0
	.dw 0xe940, 0xc81a,	0xe97f, 0xc81a,		0x21, 0
	.dw 0xe9c0, 0xc81a,	0xe9ff, 0xc81a,		0x21, 0
	.dw 0xea40, 0xc81a,	0xea7f, 0xc81a,		0x21, 0
	.dw 0xeac0, 0xc81a,	0xeaff, 0xc81a,		0x21, 0
	.dw 0xeb40, 0xc81a,	0xeb7f, 0xc81a,		0x21, 0
	.dw 0xebc0, 0xc81a,	0xebff, 0xc81a,		0x21, 0
	.dw 0xec40, 0xc81a,	0xec7f, 0xc81a,		0x21, 0
	.dw 0xecc0, 0xc81a,	0xecff, 0xc81a,		0x21, 0
	.dw 0xed40, 0xc81a,	0xed7f, 0xc81a,		0x21, 0
	.dw 0xedc0, 0xc81a,	0xedff, 0xc81a,		0x21, 0
	.dw 0xee40, 0xc81a,	0xee7f, 0xc81a,		0x21, 0
	.dw 0xeec0, 0xc81a,	0xeeff, 0xc81a,		0x21, 0
	.dw 0xef40, 0xc81a,	0xef7f, 0xc81a,		0x21, 0
	.dw 0xefc0, 0xc81a,	0xefff, 0xc81a,		0x21, 0
	.dw 0xf040, 0xc81a,	0xf07f, 0xc81a,		0x21, 0
	.dw 0xf0c0, 0xc81a,	0xf0ff, 0xc81a,		0x21, 0
	.dw 0xf140, 0xc81a,	0xf17f, 0xc81a,		0x21, 0
	.dw 0xf1c0, 0xc81a,	0xf1ff, 0xc81a,		0x21, 0
	.dw 0xf240, 0xc81a,	0xf27f, 0xc81a,		0x21, 0
	.dw 0xf2c0, 0xc81a,	0xf2ff, 0xc81a,		0x21, 0
	.dw 0xf340, 0xc81a,	0xf37f, 0xc81a,		0x21, 0
	.dw 0xf3c0, 0xc81a,	0xf3ff, 0xc81a,		0x21, 0
	.dw 0xf440, 0xc81a,	0xf47f, 0xc81a,		0x21, 0
	.dw 0xf4c0, 0xc81a,	0xf4ff, 0xc81a,		0x21, 0
	.dw 0xf540, 0xc81a,	0xf57f, 0xc81a,		0x21, 0
	.dw 0xf5c0, 0xc81a,	0xf5ff, 0xc81a,		0x21, 0
	.dw 0xf640, 0xc81a,	0xf67f, 0xc81a,		0x21, 0
	.dw 0xf6c0, 0xc81a,	0xf6ff, 0xc81a,		0x21, 0
	.dw 0xf740, 0xc81a,	0xf77f, 0xc81a,		0x21, 0
	.dw 0xf7c0, 0xc81a,	0xf7ff, 0xc81a,		0x21, 0
	.dw 0xf840, 0xc81a,	0xf87f, 0xc81a,		0x21, 0
	.dw 0xf8c0, 0xc81a,	0xf8ff, 0xc81a,		0x21, 0
	.dw 0xf940, 0xc81a,	0xf97f, 0xc81a,		0x21, 0
	.dw 0xf9c0, 0xc81a,	0xffff, 0xc81b,		0x21, 0
	.dw 0x0040, 0xc81c,	0x007f, 0xc81c,		0x21, 0
	.dw 0x00c0, 0xc81c,	0x00ff, 0xc81c,		0x21, 0
	.dw 0x0140, 0xc81c,	0x017f, 0xc81c,		0x21, 0
	.dw 0x01c0, 0xc81c,	0x01ff, 0xc81c,		0x21, 0
	.dw 0x0240, 0xc81c,	0x027f, 0xc81c,		0x21, 0
	.dw 0x02c0, 0xc81c,	0x02ff, 0xc81c,		0x21, 0
	.dw 0x0340, 0xc81c,	0x037f, 0xc81c,		0x21, 0
	.dw 0x03c0, 0xc81c,	0x03ff, 0xc81c,		0x21, 0
	.dw 0x0440, 0xc81c,	0x047f, 0xc81c,		0x21, 0
	.dw 0x04c0, 0xc81c,	0x04ff, 0xc81c,		0x21, 0
	.dw 0x0540, 0xc81c,	0x057f, 0xc81c,		0x21, 0
	.dw 0x05c0, 0xc81c,	0x05ff, 0xc81c,		0x21, 0
	.dw 0x0640, 0xc81c,	0x067f, 0xc81c,		0x21, 0
	.dw 0x06c0, 0xc81c,	0x06ff, 0xc81c,		0x21, 0
	.dw 0x0740, 0xc81c,	0x077f, 0xc81c,		0x21, 0
	.dw 0x07c0, 0xc81c,	0x07ff, 0xc81c,		0x21, 0
	.dw 0x0840, 0xc81c,	0x087f, 0xc81c,		0x21, 0
	.dw 0x08c0, 0xc81c,	0x08ff, 0xc81c,		0x21, 0
	.dw 0x0940, 0xc81c,	0x097f, 0xc81c,		0x21, 0
	.dw 0x09c0, 0xc81c,	0x09ff, 0xc81c,		0x21, 0
	.dw 0x0a40, 0xc81c,	0x0a7f, 0xc81c,		0x21, 0
	.dw 0x0ac0, 0xc81c,	0x0aff, 0xc81c,		0x21, 0
	.dw 0x0b40, 0xc81c,	0x0b7f, 0xc81c,		0x21, 0
	.dw 0x0bc0, 0xc81c,	0x0bff, 0xc81c,		0x21, 0
	.dw 0x0c40, 0xc81c,	0x0c7f, 0xc81c,		0x21, 0
	.dw 0x0cc0, 0xc81c,	0x0cff, 0xc81c,		0x21, 0
	.dw 0x0d40, 0xc81c,	0x0d7f, 0xc81c,		0x21, 0
	.dw 0x0dc0, 0xc81c,	0x0dff, 0xc81c,		0x21, 0
	.dw 0x0e40, 0xc81c,	0x0e7f, 0xc81c,		0x21, 0
	.dw 0x0ec0, 0xc81c,	0x0eff, 0xc81c,		0x21, 0
	.dw 0x0f40, 0xc81c,	0x0f7f, 0xc81c,		0x21, 0
	.dw 0x0fc0, 0xc81c,	0x0fff, 0xc81c,		0x21, 0
	.dw 0x1040, 0xc81c,	0x107f, 0xc81c,		0x21, 0
	.dw 0x10c0, 0xc81c,	0x10ff, 0xc81c,		0x21, 0
	.dw 0x1140, 0xc81c,	0x117f, 0xc81c,		0x21, 0
	.dw 0x11c0, 0xc81c,	0x11ff, 0xc81c,		0x21, 0
	.dw 0x1240, 0xc81c,	0x127f, 0xc81c,		0x21, 0
	.dw 0x12c0, 0xc81c,	0x12ff, 0xc81c,		0x21, 0
	.dw 0x1340, 0xc81c,	0x137f, 0xc81c,		0x21, 0
	.dw 0x13c0, 0xc81c,	0x13ff, 0xc81c,		0x21, 0
	.dw 0x1440, 0xc81c,	0x147f, 0xc81c,		0x21, 0
	.dw 0x14c0, 0xc81c,	0x14ff, 0xc81c,		0x21, 0
	.dw 0x1540, 0xc81c,	0x157f, 0xc81c,		0x21, 0
	.dw 0x15c0, 0xc81c,	0x15ff, 0xc81c,		0x21, 0
	.dw 0x1640, 0xc81c,	0x167f, 0xc81c,		0x21, 0
	.dw 0x16c0, 0xc81c,	0x16ff, 0xc81c,		0x21, 0
	.dw 0x1740, 0xc81c,	0x177f, 0xc81c,		0x21, 0
	.dw 0x17c0, 0xc81c,	0x17ff, 0xc81c,		0x21, 0
	.dw 0x1840, 0xc81c,	0x187f, 0xc81c,		0x21, 0
	.dw 0x18c0, 0xc81c,	0x18ff, 0xc81c,		0x21, 0
	.dw 0x1940, 0xc81c,	0x197f, 0xc81c,		0x21, 0
	.dw 0x19c0, 0xc81c,	0x1fff, 0xc81c,		0x21, 0
	.dw 0x2040, 0xc81c,	0x207f, 0xc81c,		0x21, 0
	.dw 0x20c0, 0xc81c,	0x20ff, 0xc81c,		0x21, 0
	.dw 0x2140, 0xc81c,	0x217f, 0xc81c,		0x21, 0
	.dw 0x21c0, 0xc81c,	0x21ff, 0xc81c,		0x21, 0
	.dw 0x2240, 0xc81c,	0x227f, 0xc81c,		0x21, 0
	.dw 0x22c0, 0xc81c,	0x22ff, 0xc81c,		0x21, 0
	.dw 0x2340, 0xc81c,	0x237f, 0xc81c,		0x21, 0
	.dw 0x23c0, 0xc81c,	0x23ff, 0xc81c,		0x21, 0
	.dw 0x2440, 0xc81c,	0x247f, 0xc81c,		0x21, 0
	.dw 0x24c0, 0xc81c,	0x24ff, 0xc81c,		0x21, 0
	.dw 0x2540, 0xc81c,	0x257f, 0xc81c,		0x21, 0
	.dw 0x25c0, 0xc81c,	0x25ff, 0xc81c,		0x21, 0
	.dw 0x2640, 0xc81c,	0x267f, 0xc81c,		0x21, 0
	.dw 0x26c0, 0xc81c,	0x26ff, 0xc81c,		0x21, 0
	.dw 0x2740, 0xc81c,	0x277f, 0xc81c,		0x21, 0
	.dw 0x27c0, 0xc81c,	0x27ff, 0xc81c,		0x21, 0
	.dw 0x2840, 0xc81c,	0x287f, 0xc81c,		0x21, 0
	.dw 0x28c0, 0xc81c,	0x28ff, 0xc81c,		0x21, 0
	.dw 0x2940, 0xc81c,	0x297f, 0xc81c,		0x21, 0
	.dw 0x29c0, 0xc81c,	0x29ff, 0xc81c,		0x21, 0
	.dw 0x2a40, 0xc81c,	0x2a7f, 0xc81c,		0x21, 0
	.dw 0x2ac0, 0xc81c,	0x2aff, 0xc81c,		0x21, 0
	.dw 0x2b40, 0xc81c,	0x2b7f, 0xc81c,		0x21, 0
	.dw 0x2bc0, 0xc81c,	0x2bff, 0xc81c,		0x21, 0
	.dw 0x2c40, 0xc81c,	0x2c7f, 0xc81c,		0x21, 0
	.dw 0x2cc0, 0xc81c,	0x2cff, 0xc81c,		0x21, 0
	.dw 0x2d40, 0xc81c,	0x2d7f, 0xc81c,		0x21, 0
	.dw 0x2dc0, 0xc81c,	0x2dff, 0xc81c,		0x21, 0
	.dw 0x2e40, 0xc81c,	0x2e7f, 0xc81c,		0x21, 0
	.dw 0x2ec0, 0xc81c,	0x2eff, 0xc81c,		0x21, 0
	.dw 0x2f40, 0xc81c,	0x2f7f, 0xc81c,		0x21, 0
	.dw 0x2fc0, 0xc81c,	0x2fff, 0xc81c,		0x21, 0
	.dw 0x3040, 0xc81c,	0x307f, 0xc81c,		0x21, 0
	.dw 0x30c0, 0xc81c,	0x30ff, 0xc81c,		0x21, 0
	.dw 0x3140, 0xc81c,	0x317f, 0xc81c,		0x21, 0
	.dw 0x31c0, 0xc81c,	0x31ff, 0xc81c,		0x21, 0
	.dw 0x3240, 0xc81c,	0x327f, 0xc81c,		0x21, 0
	.dw 0x32c0, 0xc81c,	0x32ff, 0xc81c,		0x21, 0
	.dw 0x3340, 0xc81c,	0x337f, 0xc81c,		0x21, 0
	.dw 0x33c0, 0xc81c,	0x33ff, 0xc81c,		0x21, 0
	.dw 0x3440, 0xc81c,	0x347f, 0xc81c,		0x21, 0
	.dw 0x34c0, 0xc81c,	0x34ff, 0xc81c,		0x21, 0
	.dw 0x3540, 0xc81c,	0x357f, 0xc81c,		0x21, 0
	.dw 0x35c0, 0xc81c,	0x35ff, 0xc81c,		0x21, 0
	.dw 0x3640, 0xc81c,	0x367f, 0xc81c,		0x21, 0
	.dw 0x36c0, 0xc81c,	0x36ff, 0xc81c,		0x21, 0
	.dw 0x3740, 0xc81c,	0x377f, 0xc81c,		0x21, 0
	.dw 0x37c0, 0xc81c,	0x37ff, 0xc81c,		0x21, 0
	.dw 0x3840, 0xc81c,	0x387f, 0xc81c,		0x21, 0
	.dw 0x38c0, 0xc81c,	0x38ff, 0xc81c,		0x21, 0
	.dw 0x3940, 0xc81c,	0x397f, 0xc81c,		0x21, 0
	.dw 0x39c0, 0xc81c,	0x3fff, 0xc81c,		0x21, 0
	.dw 0x4040, 0xc81c,	0x407f, 0xc81c,		0x21, 0
	.dw 0x40c0, 0xc81c,	0x40ff, 0xc81c,		0x21, 0
	.dw 0x4140, 0xc81c,	0x417f, 0xc81c,		0x21, 0
	.dw 0x41c0, 0xc81c,	0x41ff, 0xc81c,		0x21, 0
	.dw 0x4240, 0xc81c,	0x427f, 0xc81c,		0x21, 0
	.dw 0x42c0, 0xc81c,	0x42ff, 0xc81c,		0x21, 0
	.dw 0x4340, 0xc81c,	0x437f, 0xc81c,		0x21, 0
	.dw 0x43c0, 0xc81c,	0x43ff, 0xc81c,		0x21, 0
	.dw 0x4440, 0xc81c,	0x447f, 0xc81c,		0x21, 0
	.dw 0x44c0, 0xc81c,	0x44ff, 0xc81c,		0x21, 0
	.dw 0x4540, 0xc81c,	0x457f, 0xc81c,		0x21, 0
	.dw 0x45c0, 0xc81c,	0x45ff, 0xc81c,		0x21, 0
	.dw 0x4640, 0xc81c,	0x467f, 0xc81c,		0x21, 0
	.dw 0x46c0, 0xc81c,	0x46ff, 0xc81c,		0x21, 0
	.dw 0x4740, 0xc81c,	0x477f, 0xc81c,		0x21, 0
	.dw 0x47c0, 0xc81c,	0x47ff, 0xc81c,		0x21, 0
	.dw 0x4840, 0xc81c,	0x487f, 0xc81c,		0x21, 0
	.dw 0x48c0, 0xc81c,	0x48ff, 0xc81c,		0x21, 0
	.dw 0x4940, 0xc81c,	0x497f, 0xc81c,		0x21, 0
	.dw 0x49c0, 0xc81c,	0x49ff, 0xc81c,		0x21, 0
	.dw 0x4a40, 0xc81c,	0x4a7f, 0xc81c,		0x21, 0
	.dw 0x4ac0, 0xc81c,	0x4aff, 0xc81c,		0x21, 0
	.dw 0x4b40, 0xc81c,	0x4b7f, 0xc81c,		0x21, 0
	.dw 0x4bc0, 0xc81c,	0x4bff, 0xc81c,		0x21, 0
	.dw 0x4c40, 0xc81c,	0x4c7f, 0xc81c,		0x21, 0
	.dw 0x4cc0, 0xc81c,	0x4cff, 0xc81c,		0x21, 0
	.dw 0x4d40, 0xc81c,	0x4d7f, 0xc81c,		0x21, 0
	.dw 0x4dc0, 0xc81c,	0x4dff, 0xc81c,		0x21, 0
	.dw 0x4e40, 0xc81c,	0x4e7f, 0xc81c,		0x21, 0
	.dw 0x4ec0, 0xc81c,	0x4eff, 0xc81c,		0x21, 0
	.dw 0x4f40, 0xc81c,	0x4f7f, 0xc81c,		0x21, 0
	.dw 0x4fc0, 0xc81c,	0x4fff, 0xc81c,		0x21, 0
	.dw 0x5040, 0xc81c,	0x507f, 0xc81c,		0x21, 0
	.dw 0x50c0, 0xc81c,	0x50ff, 0xc81c,		0x21, 0
	.dw 0x5140, 0xc81c,	0x517f, 0xc81c,		0x21, 0
	.dw 0x51c0, 0xc81c,	0x51ff, 0xc81c,		0x21, 0
	.dw 0x5240, 0xc81c,	0x527f, 0xc81c,		0x21, 0
	.dw 0x52c0, 0xc81c,	0x52ff, 0xc81c,		0x21, 0
	.dw 0x5340, 0xc81c,	0x537f, 0xc81c,		0x21, 0
	.dw 0x53c0, 0xc81c,	0x53ff, 0xc81c,		0x21, 0
	.dw 0x5440, 0xc81c,	0x547f, 0xc81c,		0x21, 0
	.dw 0x54c0, 0xc81c,	0x54ff, 0xc81c,		0x21, 0
	.dw 0x5540, 0xc81c,	0x557f, 0xc81c,		0x21, 0
	.dw 0x55c0, 0xc81c,	0x55ff, 0xc81c,		0x21, 0
	.dw 0x5640, 0xc81c,	0x567f, 0xc81c,		0x21, 0
	.dw 0x56c0, 0xc81c,	0x56ff, 0xc81c,		0x21, 0
	.dw 0x5740, 0xc81c,	0x577f, 0xc81c,		0x21, 0
	.dw 0x57c0, 0xc81c,	0x57ff, 0xc81c,		0x21, 0
	.dw 0x5840, 0xc81c,	0x587f, 0xc81c,		0x21, 0
	.dw 0x58c0, 0xc81c,	0x58ff, 0xc81c,		0x21, 0
	.dw 0x5940, 0xc81c,	0x597f, 0xc81c,		0x21, 0
	.dw 0x59c0, 0xc81c,	0x5fff, 0xc81c,		0x21, 0
	.dw 0x6040, 0xc81c,	0x607f, 0xc81c,		0x21, 0
	.dw 0x60c0, 0xc81c,	0x60ff, 0xc81c,		0x21, 0
	.dw 0x6140, 0xc81c,	0x617f, 0xc81c,		0x21, 0
	.dw 0x61c0, 0xc81c,	0x61ff, 0xc81c,		0x21, 0
	.dw 0x6240, 0xc81c,	0x627f, 0xc81c,		0x21, 0
	.dw 0x62c0, 0xc81c,	0x62ff, 0xc81c,		0x21, 0
	.dw 0x6340, 0xc81c,	0x637f, 0xc81c,		0x21, 0
	.dw 0x63c0, 0xc81c,	0x63ff, 0xc81c,		0x21, 0
	.dw 0x6440, 0xc81c,	0x647f, 0xc81c,		0x21, 0
	.dw 0x64c0, 0xc81c,	0x64ff, 0xc81c,		0x21, 0
	.dw 0x6540, 0xc81c,	0x657f, 0xc81c,		0x21, 0
	.dw 0x65c0, 0xc81c,	0x65ff, 0xc81c,		0x21, 0
	.dw 0x6640, 0xc81c,	0x667f, 0xc81c,		0x21, 0
	.dw 0x66c0, 0xc81c,	0x66ff, 0xc81c,		0x21, 0
	.dw 0x6740, 0xc81c,	0x677f, 0xc81c,		0x21, 0
	.dw 0x67c0, 0xc81c,	0x67ff, 0xc81c,		0x21, 0
	.dw 0x6840, 0xc81c,	0x687f, 0xc81c,		0x21, 0
	.dw 0x68c0, 0xc81c,	0x68ff, 0xc81c,		0x21, 0
	.dw 0x6940, 0xc81c,	0x697f, 0xc81c,		0x21, 0
	.dw 0x69c0, 0xc81c,	0x69ff, 0xc81c,		0x21, 0
	.dw 0x6a40, 0xc81c,	0x6a7f, 0xc81c,		0x21, 0
	.dw 0x6ac0, 0xc81c,	0x6aff, 0xc81c,		0x21, 0
	.dw 0x6b40, 0xc81c,	0x6b7f, 0xc81c,		0x21, 0
	.dw 0x6bc0, 0xc81c,	0x6bff, 0xc81c,		0x21, 0
	.dw 0x6c40, 0xc81c,	0x6c7f, 0xc81c,		0x21, 0
	.dw 0x6cc0, 0xc81c,	0x6cff, 0xc81c,		0x21, 0
	.dw 0x6d40, 0xc81c,	0x6d7f, 0xc81c,		0x21, 0
	.dw 0x6dc0, 0xc81c,	0x6dff, 0xc81c,		0x21, 0
	.dw 0x6e40, 0xc81c,	0x6e7f, 0xc81c,		0x21, 0
	.dw 0x6ec0, 0xc81c,	0x6eff, 0xc81c,		0x21, 0
	.dw 0x6f40, 0xc81c,	0x6f7f, 0xc81c,		0x21, 0
	.dw 0x6fc0, 0xc81c,	0x6fff, 0xc81c,		0x21, 0
	.dw 0x7040, 0xc81c,	0x707f, 0xc81c,		0x21, 0
	.dw 0x70c0, 0xc81c,	0x70ff, 0xc81c,		0x21, 0
	.dw 0x7140, 0xc81c,	0x717f, 0xc81c,		0x21, 0
	.dw 0x71c0, 0xc81c,	0x71ff, 0xc81c,		0x21, 0
	.dw 0x7240, 0xc81c,	0x727f, 0xc81c,		0x21, 0
	.dw 0x72c0, 0xc81c,	0x72ff, 0xc81c,		0x21, 0
	.dw 0x7340, 0xc81c,	0x737f, 0xc81c,		0x21, 0
	.dw 0x73c0, 0xc81c,	0x73ff, 0xc81c,		0x21, 0
	.dw 0x7440, 0xc81c,	0x747f, 0xc81c,		0x21, 0
	.dw 0x74c0, 0xc81c,	0x74ff, 0xc81c,		0x21, 0
	.dw 0x7540, 0xc81c,	0x757f, 0xc81c,		0x21, 0
	.dw 0x75c0, 0xc81c,	0x75ff, 0xc81c,		0x21, 0
	.dw 0x7640, 0xc81c,	0x767f, 0xc81c,		0x21, 0
	.dw 0x76c0, 0xc81c,	0x76ff, 0xc81c,		0x21, 0
	.dw 0x7740, 0xc81c,	0x777f, 0xc81c,		0x21, 0
	.dw 0x77c0, 0xc81c,	0x77ff, 0xc81c,		0x21, 0
	.dw 0x7840, 0xc81c,	0x787f, 0xc81c,		0x21, 0
	.dw 0x78c0, 0xc81c,	0x78ff, 0xc81c,		0x21, 0
	.dw 0x7940, 0xc81c,	0x797f, 0xc81c,		0x21, 0
	.dw 0x79c0, 0xc81c,	0x7fff, 0xc81c,		0x21, 0
	.dw 0x8040, 0xc81c,	0x807f, 0xc81c,		0x21, 0
	.dw 0x80c0, 0xc81c,	0x80ff, 0xc81c,		0x21, 0
	.dw 0x8140, 0xc81c,	0x817f, 0xc81c,		0x21, 0
	.dw 0x81c0, 0xc81c,	0x81ff, 0xc81c,		0x21, 0
	.dw 0x8240, 0xc81c,	0x827f, 0xc81c,		0x21, 0
	.dw 0x82c0, 0xc81c,	0x82ff, 0xc81c,		0x21, 0
	.dw 0x8340, 0xc81c,	0x837f, 0xc81c,		0x21, 0
	.dw 0x83c0, 0xc81c,	0x83ff, 0xc81c,		0x21, 0
	.dw 0x8440, 0xc81c,	0x847f, 0xc81c,		0x21, 0
	.dw 0x84c0, 0xc81c,	0x84ff, 0xc81c,		0x21, 0
	.dw 0x8540, 0xc81c,	0x857f, 0xc81c,		0x21, 0
	.dw 0x85c0, 0xc81c,	0x85ff, 0xc81c,		0x21, 0
	.dw 0x8640, 0xc81c,	0x867f, 0xc81c,		0x21, 0
	.dw 0x86c0, 0xc81c,	0x86ff, 0xc81c,		0x21, 0
	.dw 0x8740, 0xc81c,	0x877f, 0xc81c,		0x21, 0
	.dw 0x87c0, 0xc81c,	0x87ff, 0xc81c,		0x21, 0
	.dw 0x8840, 0xc81c,	0x887f, 0xc81c,		0x21, 0
	.dw 0x88c0, 0xc81c,	0x88ff, 0xc81c,		0x21, 0
	.dw 0x8940, 0xc81c,	0x897f, 0xc81c,		0x21, 0
	.dw 0x89c0, 0xc81c,	0x89ff, 0xc81c,		0x21, 0
	.dw 0x8a40, 0xc81c,	0x8a7f, 0xc81c,		0x21, 0
	.dw 0x8ac0, 0xc81c,	0x8aff, 0xc81c,		0x21, 0
	.dw 0x8b40, 0xc81c,	0x8b7f, 0xc81c,		0x21, 0
	.dw 0x8bc0, 0xc81c,	0x8bff, 0xc81c,		0x21, 0
	.dw 0x8c40, 0xc81c,	0x8c7f, 0xc81c,		0x21, 0
	.dw 0x8cc0, 0xc81c,	0x8cff, 0xc81c,		0x21, 0
	.dw 0x8d40, 0xc81c,	0x8d7f, 0xc81c,		0x21, 0
	.dw 0x8dc0, 0xc81c,	0x8dff, 0xc81c,		0x21, 0
	.dw 0x8e40, 0xc81c,	0x8e7f, 0xc81c,		0x21, 0
	.dw 0x8ec0, 0xc81c,	0x8eff, 0xc81c,		0x21, 0
	.dw 0x8f40, 0xc81c,	0x8f7f, 0xc81c,		0x21, 0
	.dw 0x8fc0, 0xc81c,	0x8fff, 0xc81c,		0x21, 0
	.dw 0x9040, 0xc81c,	0x907f, 0xc81c,		0x21, 0
	.dw 0x90c0, 0xc81c,	0x90ff, 0xc81c,		0x21, 0
	.dw 0x9140, 0xc81c,	0x917f, 0xc81c,		0x21, 0
	.dw 0x91c0, 0xc81c,	0x91ff, 0xc81c,		0x21, 0
	.dw 0x9240, 0xc81c,	0x927f, 0xc81c,		0x21, 0
	.dw 0x92c0, 0xc81c,	0x92ff, 0xc81c,		0x21, 0
	.dw 0x9340, 0xc81c,	0x937f, 0xc81c,		0x21, 0
	.dw 0x93c0, 0xc81c,	0x93ff, 0xc81c,		0x21, 0
	.dw 0x9440, 0xc81c,	0x947f, 0xc81c,		0x21, 0
	.dw 0x94c0, 0xc81c,	0x94ff, 0xc81c,		0x21, 0
	.dw 0x9540, 0xc81c,	0x957f, 0xc81c,		0x21, 0
	.dw 0x95c0, 0xc81c,	0x95ff, 0xc81c,		0x21, 0
	.dw 0x9640, 0xc81c,	0x967f, 0xc81c,		0x21, 0
	.dw 0x96c0, 0xc81c,	0x96ff, 0xc81c,		0x21, 0
	.dw 0x9740, 0xc81c,	0x977f, 0xc81c,		0x21, 0
	.dw 0x97c0, 0xc81c,	0x97ff, 0xc81c,		0x21, 0
	.dw 0x9840, 0xc81c,	0x987f, 0xc81c,		0x21, 0
	.dw 0x98c0, 0xc81c,	0x98ff, 0xc81c,		0x21, 0
	.dw 0x9940, 0xc81c,	0x997f, 0xc81c,		0x21, 0
	.dw 0x99c0, 0xc81c,	0x9fff, 0xc81c,		0x21, 0
	.dw 0xa040, 0xc81c,	0xa07f, 0xc81c,		0x21, 0
	.dw 0xa0c0, 0xc81c,	0xa0ff, 0xc81c,		0x21, 0
	.dw 0xa140, 0xc81c,	0xa17f, 0xc81c,		0x21, 0
	.dw 0xa1c0, 0xc81c,	0xa1ff, 0xc81c,		0x21, 0
	.dw 0xa240, 0xc81c,	0xa27f, 0xc81c,		0x21, 0
	.dw 0xa2c0, 0xc81c,	0xa2ff, 0xc81c,		0x21, 0
	.dw 0xa340, 0xc81c,	0xa37f, 0xc81c,		0x21, 0
	.dw 0xa3c0, 0xc81c,	0xa3ff, 0xc81c,		0x21, 0
	.dw 0xa440, 0xc81c,	0xa47f, 0xc81c,		0x21, 0
	.dw 0xa4c0, 0xc81c,	0xa4ff, 0xc81c,		0x21, 0
	.dw 0xa540, 0xc81c,	0xa57f, 0xc81c,		0x21, 0
	.dw 0xa5c0, 0xc81c,	0xa5ff, 0xc81c,		0x21, 0
	.dw 0xa640, 0xc81c,	0xa67f, 0xc81c,		0x21, 0
	.dw 0xa6c0, 0xc81c,	0xa6ff, 0xc81c,		0x21, 0
	.dw 0xa740, 0xc81c,	0xa77f, 0xc81c,		0x21, 0
	.dw 0xa7c0, 0xc81c,	0xa7ff, 0xc81c,		0x21, 0
	.dw 0xa840, 0xc81c,	0xa87f, 0xc81c,		0x21, 0
	.dw 0xa8c0, 0xc81c,	0xa8ff, 0xc81c,		0x21, 0
	.dw 0xa940, 0xc81c,	0xa97f, 0xc81c,		0x21, 0
	.dw 0xa9c0, 0xc81c,	0xa9ff, 0xc81c,		0x21, 0
	.dw 0xaa40, 0xc81c,	0xaa7f, 0xc81c,		0x21, 0
	.dw 0xaac0, 0xc81c,	0xaaff, 0xc81c,		0x21, 0
	.dw 0xab40, 0xc81c,	0xab7f, 0xc81c,		0x21, 0
	.dw 0xabc0, 0xc81c,	0xabff, 0xc81c,		0x21, 0
	.dw 0xac40, 0xc81c,	0xac7f, 0xc81c,		0x21, 0
	.dw 0xacc0, 0xc81c,	0xacff, 0xc81c,		0x21, 0
	.dw 0xad40, 0xc81c,	0xad7f, 0xc81c,		0x21, 0
	.dw 0xadc0, 0xc81c,	0xadff, 0xc81c,		0x21, 0
	.dw 0xae40, 0xc81c,	0xae7f, 0xc81c,		0x21, 0
	.dw 0xaec0, 0xc81c,	0xaeff, 0xc81c,		0x21, 0
	.dw 0xaf40, 0xc81c,	0xaf7f, 0xc81c,		0x21, 0
	.dw 0xafc0, 0xc81c,	0xafff, 0xc81c,		0x21, 0
	.dw 0xb040, 0xc81c,	0xb07f, 0xc81c,		0x21, 0
	.dw 0xb0c0, 0xc81c,	0xb0ff, 0xc81c,		0x21, 0
	.dw 0xb140, 0xc81c,	0xb17f, 0xc81c,		0x21, 0
	.dw 0xb1c0, 0xc81c,	0xb1ff, 0xc81c,		0x21, 0
	.dw 0xb240, 0xc81c,	0xb27f, 0xc81c,		0x21, 0
	.dw 0xb2c0, 0xc81c,	0xb2ff, 0xc81c,		0x21, 0
	.dw 0xb340, 0xc81c,	0xb37f, 0xc81c,		0x21, 0
	.dw 0xb3c0, 0xc81c,	0xb3ff, 0xc81c,		0x21, 0
	.dw 0xb440, 0xc81c,	0xb47f, 0xc81c,		0x21, 0
	.dw 0xb4c0, 0xc81c,	0xb4ff, 0xc81c,		0x21, 0
	.dw 0xb540, 0xc81c,	0xb57f, 0xc81c,		0x21, 0
	.dw 0xb5c0, 0xc81c,	0xb5ff, 0xc81c,		0x21, 0
	.dw 0xb640, 0xc81c,	0xb67f, 0xc81c,		0x21, 0
	.dw 0xb6c0, 0xc81c,	0xb6ff, 0xc81c,		0x21, 0
	.dw 0xb740, 0xc81c,	0xb77f, 0xc81c,		0x21, 0
	.dw 0xb7c0, 0xc81c,	0xb7ff, 0xc81c,		0x21, 0
	.dw 0xb840, 0xc81c,	0xb87f, 0xc81c,		0x21, 0
	.dw 0xb8c0, 0xc81c,	0xb8ff, 0xc81c,		0x21, 0
	.dw 0xb940, 0xc81c,	0xb97f, 0xc81c,		0x21, 0
	.dw 0xb9c0, 0xc81c,	0xbfff, 0xc81c,		0x21, 0
	.dw 0xc040, 0xc81c,	0xc07f, 0xc81c,		0x21, 0
	.dw 0xc0c0, 0xc81c,	0xc0ff, 0xc81c,		0x21, 0
	.dw 0xc140, 0xc81c,	0xc17f, 0xc81c,		0x21, 0
	.dw 0xc1c0, 0xc81c,	0xc1ff, 0xc81c,		0x21, 0
	.dw 0xc240, 0xc81c,	0xc27f, 0xc81c,		0x21, 0
	.dw 0xc2c0, 0xc81c,	0xc2ff, 0xc81c,		0x21, 0
	.dw 0xc340, 0xc81c,	0xc37f, 0xc81c,		0x21, 0
	.dw 0xc3c0, 0xc81c,	0xc3ff, 0xc81c,		0x21, 0
	.dw 0xc440, 0xc81c,	0xc47f, 0xc81c,		0x21, 0
	.dw 0xc4c0, 0xc81c,	0xc4ff, 0xc81c,		0x21, 0
	.dw 0xc540, 0xc81c,	0xc57f, 0xc81c,		0x21, 0
	.dw 0xc5c0, 0xc81c,	0xc5ff, 0xc81c,		0x21, 0
	.dw 0xc640, 0xc81c,	0xc67f, 0xc81c,		0x21, 0
	.dw 0xc6c0, 0xc81c,	0xc6ff, 0xc81c,		0x21, 0
	.dw 0xc740, 0xc81c,	0xc77f, 0xc81c,		0x21, 0
	.dw 0xc7c0, 0xc81c,	0xc7ff, 0xc81c,		0x21, 0
	.dw 0xc840, 0xc81c,	0xc87f, 0xc81c,		0x21, 0
	.dw 0xc8c0, 0xc81c,	0xc8ff, 0xc81c,		0x21, 0
	.dw 0xc940, 0xc81c,	0xc97f, 0xc81c,		0x21, 0
	.dw 0xc9c0, 0xc81c,	0xc9ff, 0xc81c,		0x21, 0
	.dw 0xca40, 0xc81c,	0xca7f, 0xc81c,		0x21, 0
	.dw 0xcac0, 0xc81c,	0xcaff, 0xc81c,		0x21, 0
	.dw 0xcb40, 0xc81c,	0xcb7f, 0xc81c,		0x21, 0
	.dw 0xcbc0, 0xc81c,	0xcbff, 0xc81c,		0x21, 0
	.dw 0xcc40, 0xc81c,	0xcc7f, 0xc81c,		0x21, 0
	.dw 0xccc0, 0xc81c,	0xccff, 0xc81c,		0x21, 0
	.dw 0xcd40, 0xc81c,	0xcd7f, 0xc81c,		0x21, 0
	.dw 0xcdc0, 0xc81c,	0xcdff, 0xc81c,		0x21, 0
	.dw 0xce40, 0xc81c,	0xce7f, 0xc81c,		0x21, 0
	.dw 0xcec0, 0xc81c,	0xceff, 0xc81c,		0x21, 0
	.dw 0xcf40, 0xc81c,	0xcf7f, 0xc81c,		0x21, 0
	.dw 0xcfc0, 0xc81c,	0xcfff, 0xc81c,		0x21, 0
	.dw 0xd040, 0xc81c,	0xd07f, 0xc81c,		0x21, 0
	.dw 0xd0c0, 0xc81c,	0xd0ff, 0xc81c,		0x21, 0
	.dw 0xd140, 0xc81c,	0xd17f, 0xc81c,		0x21, 0
	.dw 0xd1c0, 0xc81c,	0xd1ff, 0xc81c,		0x21, 0
	.dw 0xd240, 0xc81c,	0xd27f, 0xc81c,		0x21, 0
	.dw 0xd2c0, 0xc81c,	0xd2ff, 0xc81c,		0x21, 0
	.dw 0xd340, 0xc81c,	0xd37f, 0xc81c,		0x21, 0
	.dw 0xd3c0, 0xc81c,	0xd3ff, 0xc81c,		0x21, 0
	.dw 0xd440, 0xc81c,	0xd47f, 0xc81c,		0x21, 0
	.dw 0xd4c0, 0xc81c,	0xd4ff, 0xc81c,		0x21, 0
	.dw 0xd540, 0xc81c,	0xd57f, 0xc81c,		0x21, 0
	.dw 0xd5c0, 0xc81c,	0xd5ff, 0xc81c,		0x21, 0
	.dw 0xd640, 0xc81c,	0xd67f, 0xc81c,		0x21, 0
	.dw 0xd6c0, 0xc81c,	0xd6ff, 0xc81c,		0x21, 0
	.dw 0xd740, 0xc81c,	0xd77f, 0xc81c,		0x21, 0
	.dw 0xd7c0, 0xc81c,	0xd7ff, 0xc81c,		0x21, 0
	.dw 0xd840, 0xc81c,	0xd87f, 0xc81c,		0x21, 0
	.dw 0xd8c0, 0xc81c,	0xd8ff, 0xc81c,		0x21, 0
	.dw 0xd940, 0xc81c,	0xd97f, 0xc81c,		0x21, 0
	.dw 0xd9c0, 0xc81c,	0xdfff, 0xc81c,		0x21, 0
	.dw 0xe040, 0xc81c,	0xe07f, 0xc81c,		0x21, 0
	.dw 0xe0c0, 0xc81c,	0xe0ff, 0xc81c,		0x21, 0
	.dw 0xe140, 0xc81c,	0xe17f, 0xc81c,		0x21, 0
	.dw 0xe1c0, 0xc81c,	0xe1ff, 0xc81c,		0x21, 0
	.dw 0xe240, 0xc81c,	0xe27f, 0xc81c,		0x21, 0
	.dw 0xe2c0, 0xc81c,	0xe2ff, 0xc81c,		0x21, 0
	.dw 0xe340, 0xc81c,	0xe37f, 0xc81c,		0x21, 0
	.dw 0xe3c0, 0xc81c,	0xe3ff, 0xc81c,		0x21, 0
	.dw 0xe440, 0xc81c,	0xe47f, 0xc81c,		0x21, 0
	.dw 0xe4c0, 0xc81c,	0xe4ff, 0xc81c,		0x21, 0
	.dw 0xe540, 0xc81c,	0xe57f, 0xc81c,		0x21, 0
	.dw 0xe5c0, 0xc81c,	0xe5ff, 0xc81c,		0x21, 0
	.dw 0xe640, 0xc81c,	0xe67f, 0xc81c,		0x21, 0
	.dw 0xe6c0, 0xc81c,	0xe6ff, 0xc81c,		0x21, 0
	.dw 0xe740, 0xc81c,	0xe77f, 0xc81c,		0x21, 0
	.dw 0xe7c0, 0xc81c,	0xe7ff, 0xc81c,		0x21, 0
	.dw 0xe840, 0xc81c,	0xe87f, 0xc81c,		0x21, 0
	.dw 0xe8c0, 0xc81c,	0xe8ff, 0xc81c,		0x21, 0
	.dw 0xe940, 0xc81c,	0xe97f, 0xc81c,		0x21, 0
	.dw 0xe9c0, 0xc81c,	0xe9ff, 0xc81c,		0x21, 0
	.dw 0xea40, 0xc81c,	0xea7f, 0xc81c,		0x21, 0
	.dw 0xeac0, 0xc81c,	0xeaff, 0xc81c,		0x21, 0
	.dw 0xeb40, 0xc81c,	0xeb7f, 0xc81c,		0x21, 0
	.dw 0xebc0, 0xc81c,	0xebff, 0xc81c,		0x21, 0
	.dw 0xec40, 0xc81c,	0xec7f, 0xc81c,		0x21, 0
	.dw 0xecc0, 0xc81c,	0xecff, 0xc81c,		0x21, 0
	.dw 0xed40, 0xc81c,	0xed7f, 0xc81c,		0x21, 0
	.dw 0xedc0, 0xc81c,	0xedff, 0xc81c,		0x21, 0
	.dw 0xee40, 0xc81c,	0xee7f, 0xc81c,		0x21, 0
	.dw 0xeec0, 0xc81c,	0xeeff, 0xc81c,		0x21, 0
	.dw 0xef40, 0xc81c,	0xef7f, 0xc81c,		0x21, 0
	.dw 0xefc0, 0xc81c,	0xefff, 0xc81c,		0x21, 0
	.dw 0xf040, 0xc81c,	0xf07f, 0xc81c,		0x21, 0
	.dw 0xf0c0, 0xc81c,	0xf0ff, 0xc81c,		0x21, 0
	.dw 0xf140, 0xc81c,	0xf17f, 0xc81c,		0x21, 0
	.dw 0xf1c0, 0xc81c,	0xf1ff, 0xc81c,		0x21, 0
	.dw 0xf240, 0xc81c,	0xf27f, 0xc81c,		0x21, 0
	.dw 0xf2c0, 0xc81c,	0xf2ff, 0xc81c,		0x21, 0
	.dw 0xf340, 0xc81c,	0xf37f, 0xc81c,		0x21, 0
	.dw 0xf3c0, 0xc81c,	0xf3ff, 0xc81c,		0x21, 0
	.dw 0xf440, 0xc81c,	0xf47f, 0xc81c,		0x21, 0
	.dw 0xf4c0, 0xc81c,	0xf4ff, 0xc81c,		0x21, 0
	.dw 0xf540, 0xc81c,	0xf57f, 0xc81c,		0x21, 0
	.dw 0xf5c0, 0xc81c,	0xf5ff, 0xc81c,		0x21, 0
	.dw 0xf640, 0xc81c,	0xf67f, 0xc81c,		0x21, 0
	.dw 0xf6c0, 0xc81c,	0xf6ff, 0xc81c,		0x21, 0
	.dw 0xf740, 0xc81c,	0xf77f, 0xc81c,		0x21, 0
	.dw 0xf7c0, 0xc81c,	0xf7ff, 0xc81c,		0x21, 0
	.dw 0xf840, 0xc81c,	0xf87f, 0xc81c,		0x21, 0
	.dw 0xf8c0, 0xc81c,	0xf8ff, 0xc81c,		0x21, 0
	.dw 0xf940, 0xc81c,	0xf97f, 0xc81c,		0x21, 0
	.dw 0xf9c0, 0xc81c,	0xffff, 0xc81c,		0x21, 0
	.dw 0x0040, 0xc81d,	0x007f, 0xc81d,		0x21, 0
	.dw 0x00c0, 0xc81d,	0x00ff, 0xc81d,		0x21, 0
	.dw 0x0140, 0xc81d,	0x017f, 0xc81d,		0x21, 0
	.dw 0x01c0, 0xc81d,	0x01ff, 0xc81d,		0x21, 0
	.dw 0x0240, 0xc81d,	0x027f, 0xc81d,		0x21, 0
	.dw 0x02c0, 0xc81d,	0x02ff, 0xc81d,		0x21, 0
	.dw 0x0340, 0xc81d,	0x037f, 0xc81d,		0x21, 0
	.dw 0x03c0, 0xc81d,	0x03ff, 0xc81d,		0x21, 0
	.dw 0x0440, 0xc81d,	0x047f, 0xc81d,		0x21, 0
	.dw 0x04c0, 0xc81d,	0x04ff, 0xc81d,		0x21, 0
	.dw 0x0540, 0xc81d,	0x057f, 0xc81d,		0x21, 0
	.dw 0x05c0, 0xc81d,	0x05ff, 0xc81d,		0x21, 0
	.dw 0x0640, 0xc81d,	0x067f, 0xc81d,		0x21, 0
	.dw 0x06c0, 0xc81d,	0x06ff, 0xc81d,		0x21, 0
	.dw 0x0740, 0xc81d,	0x077f, 0xc81d,		0x21, 0
	.dw 0x07c0, 0xc81d,	0x07ff, 0xc81d,		0x21, 0
	.dw 0x0840, 0xc81d,	0x087f, 0xc81d,		0x21, 0
	.dw 0x08c0, 0xc81d,	0x08ff, 0xc81d,		0x21, 0
	.dw 0x0940, 0xc81d,	0x097f, 0xc81d,		0x21, 0
	.dw 0x09c0, 0xc81d,	0x09ff, 0xc81d,		0x21, 0
	.dw 0x0a40, 0xc81d,	0x0a7f, 0xc81d,		0x21, 0
	.dw 0x0ac0, 0xc81d,	0x0aff, 0xc81d,		0x21, 0
	.dw 0x0b40, 0xc81d,	0x0b7f, 0xc81d,		0x21, 0
	.dw 0x0bc0, 0xc81d,	0x0bff, 0xc81d,		0x21, 0
	.dw 0x0c40, 0xc81d,	0x0c7f, 0xc81d,		0x21, 0
	.dw 0x0cc0, 0xc81d,	0x0cff, 0xc81d,		0x21, 0
	.dw 0x0d40, 0xc81d,	0x0d7f, 0xc81d,		0x21, 0
	.dw 0x0dc0, 0xc81d,	0x0dff, 0xc81d,		0x21, 0
	.dw 0x0e40, 0xc81d,	0x0e7f, 0xc81d,		0x21, 0
	.dw 0x0ec0, 0xc81d,	0x0eff, 0xc81d,		0x21, 0
	.dw 0x0f40, 0xc81d,	0x0f7f, 0xc81d,		0x21, 0
	.dw 0x0fc0, 0xc81d,	0x0fff, 0xc81d,		0x21, 0
	.dw 0x1040, 0xc81d,	0x107f, 0xc81d,		0x21, 0
	.dw 0x10c0, 0xc81d,	0x10ff, 0xc81d,		0x21, 0
	.dw 0x1140, 0xc81d,	0x117f, 0xc81d,		0x21, 0
	.dw 0x11c0, 0xc81d,	0x11ff, 0xc81d,		0x21, 0
	.dw 0x1240, 0xc81d,	0x127f, 0xc81d,		0x21, 0
	.dw 0x12c0, 0xc81d,	0x12ff, 0xc81d,		0x21, 0
	.dw 0x1340, 0xc81d,	0x137f, 0xc81d,		0x21, 0
	.dw 0x13c0, 0xc81d,	0x13ff, 0xc81d,		0x21, 0
	.dw 0x1440, 0xc81d,	0x147f, 0xc81d,		0x21, 0
	.dw 0x14c0, 0xc81d,	0x14ff, 0xc81d,		0x21, 0
	.dw 0x1540, 0xc81d,	0x157f, 0xc81d,		0x21, 0
	.dw 0x15c0, 0xc81d,	0x15ff, 0xc81d,		0x21, 0
	.dw 0x1640, 0xc81d,	0x167f, 0xc81d,		0x21, 0
	.dw 0x16c0, 0xc81d,	0x16ff, 0xc81d,		0x21, 0
	.dw 0x1740, 0xc81d,	0x177f, 0xc81d,		0x21, 0
	.dw 0x17c0, 0xc81d,	0x17ff, 0xc81d,		0x21, 0
	.dw 0x1840, 0xc81d,	0x187f, 0xc81d,		0x21, 0
	.dw 0x18c0, 0xc81d,	0x18ff, 0xc81d,		0x21, 0
	.dw 0x1940, 0xc81d,	0x197f, 0xc81d,		0x21, 0
	.dw 0x19c0, 0xc81d,	0x1fff, 0xc81d,		0x21, 0
	.dw 0x2040, 0xc81d,	0x207f, 0xc81d,		0x21, 0
	.dw 0x20c0, 0xc81d,	0x20ff, 0xc81d,		0x21, 0
	.dw 0x2140, 0xc81d,	0x217f, 0xc81d,		0x21, 0
	.dw 0x21c0, 0xc81d,	0x21ff, 0xc81d,		0x21, 0
	.dw 0x2240, 0xc81d,	0x227f, 0xc81d,		0x21, 0
	.dw 0x22c0, 0xc81d,	0x22ff, 0xc81d,		0x21, 0
	.dw 0x2340, 0xc81d,	0x237f, 0xc81d,		0x21, 0
	.dw 0x23c0, 0xc81d,	0x23ff, 0xc81d,		0x21, 0
	.dw 0x2440, 0xc81d,	0x247f, 0xc81d,		0x21, 0
	.dw 0x24c0, 0xc81d,	0x24ff, 0xc81d,		0x21, 0
	.dw 0x2540, 0xc81d,	0x257f, 0xc81d,		0x21, 0
	.dw 0x25c0, 0xc81d,	0x25ff, 0xc81d,		0x21, 0
	.dw 0x2640, 0xc81d,	0x267f, 0xc81d,		0x21, 0
	.dw 0x26c0, 0xc81d,	0x26ff, 0xc81d,		0x21, 0
	.dw 0x2740, 0xc81d,	0x277f, 0xc81d,		0x21, 0
	.dw 0x27c0, 0xc81d,	0x27ff, 0xc81d,		0x21, 0
	.dw 0x2840, 0xc81d,	0x287f, 0xc81d,		0x21, 0
	.dw 0x28c0, 0xc81d,	0x28ff, 0xc81d,		0x21, 0
	.dw 0x2940, 0xc81d,	0x297f, 0xc81d,		0x21, 0
	.dw 0x29c0, 0xc81d,	0x29ff, 0xc81d,		0x21, 0
	.dw 0x2a40, 0xc81d,	0x2a7f, 0xc81d,		0x21, 0
	.dw 0x2ac0, 0xc81d,	0x2aff, 0xc81d,		0x21, 0
	.dw 0x2b40, 0xc81d,	0x2b7f, 0xc81d,		0x21, 0
	.dw 0x2bc0, 0xc81d,	0x2bff, 0xc81d,		0x21, 0
	.dw 0x2c40, 0xc81d,	0x2c7f, 0xc81d,		0x21, 0
	.dw 0x2cc0, 0xc81d,	0x2cff, 0xc81d,		0x21, 0
	.dw 0x2d40, 0xc81d,	0x2d7f, 0xc81d,		0x21, 0
	.dw 0x2dc0, 0xc81d,	0x2dff, 0xc81d,		0x21, 0
	.dw 0x2e40, 0xc81d,	0x2e7f, 0xc81d,		0x21, 0
	.dw 0x2ec0, 0xc81d,	0x2eff, 0xc81d,		0x21, 0
	.dw 0x2f40, 0xc81d,	0x2f7f, 0xc81d,		0x21, 0
	.dw 0x2fc0, 0xc81d,	0x2fff, 0xc81d,		0x21, 0
	.dw 0x3040, 0xc81d,	0x307f, 0xc81d,		0x21, 0
	.dw 0x30c0, 0xc81d,	0x30ff, 0xc81d,		0x21, 0
	.dw 0x3140, 0xc81d,	0x317f, 0xc81d,		0x21, 0
	.dw 0x31c0, 0xc81d,	0x31ff, 0xc81d,		0x21, 0
	.dw 0x3240, 0xc81d,	0x327f, 0xc81d,		0x21, 0
	.dw 0x32c0, 0xc81d,	0x32ff, 0xc81d,		0x21, 0
	.dw 0x3340, 0xc81d,	0x337f, 0xc81d,		0x21, 0
	.dw 0x33c0, 0xc81d,	0x33ff, 0xc81d,		0x21, 0
	.dw 0x3440, 0xc81d,	0x347f, 0xc81d,		0x21, 0
	.dw 0x34c0, 0xc81d,	0x34ff, 0xc81d,		0x21, 0
	.dw 0x3540, 0xc81d,	0x357f, 0xc81d,		0x21, 0
	.dw 0x35c0, 0xc81d,	0x35ff, 0xc81d,		0x21, 0
	.dw 0x3640, 0xc81d,	0x367f, 0xc81d,		0x21, 0
	.dw 0x36c0, 0xc81d,	0x36ff, 0xc81d,		0x21, 0
	.dw 0x3740, 0xc81d,	0x377f, 0xc81d,		0x21, 0
	.dw 0x37c0, 0xc81d,	0x37ff, 0xc81d,		0x21, 0
	.dw 0x3840, 0xc81d,	0x387f, 0xc81d,		0x21, 0
	.dw 0x38c0, 0xc81d,	0x38ff, 0xc81d,		0x21, 0
	.dw 0x3940, 0xc81d,	0x397f, 0xc81d,		0x21, 0
	.dw 0x39c0, 0xc81d,	0x3fff, 0xc81d,		0x21, 0
	.dw 0x4040, 0xc81d,	0x407f, 0xc81d,		0x21, 0
	.dw 0x40c0, 0xc81d,	0x40ff, 0xc81d,		0x21, 0
	.dw 0x4140, 0xc81d,	0x417f, 0xc81d,		0x21, 0
	.dw 0x41c0, 0xc81d,	0x41ff, 0xc81d,		0x21, 0
	.dw 0x4240, 0xc81d,	0x427f, 0xc81d,		0x21, 0
	.dw 0x42c0, 0xc81d,	0x42ff, 0xc81d,		0x21, 0
	.dw 0x4340, 0xc81d,	0x437f, 0xc81d,		0x21, 0
	.dw 0x43c0, 0xc81d,	0x43ff, 0xc81d,		0x21, 0
	.dw 0x4440, 0xc81d,	0x447f, 0xc81d,		0x21, 0
	.dw 0x44c0, 0xc81d,	0x44ff, 0xc81d,		0x21, 0
	.dw 0x4540, 0xc81d,	0x457f, 0xc81d,		0x21, 0
	.dw 0x45c0, 0xc81d,	0x45ff, 0xc81d,		0x21, 0
	.dw 0x4640, 0xc81d,	0x467f, 0xc81d,		0x21, 0
	.dw 0x46c0, 0xc81d,	0x46ff, 0xc81d,		0x21, 0
	.dw 0x4740, 0xc81d,	0x477f, 0xc81d,		0x21, 0
	.dw 0x47c0, 0xc81d,	0x47ff, 0xc81d,		0x21, 0
	.dw 0x4840, 0xc81d,	0x487f, 0xc81d,		0x21, 0
	.dw 0x48c0, 0xc81d,	0x48ff, 0xc81d,		0x21, 0
	.dw 0x4940, 0xc81d,	0x497f, 0xc81d,		0x21, 0
	.dw 0x49c0, 0xc81d,	0x49ff, 0xc81d,		0x21, 0
	.dw 0x4a40, 0xc81d,	0x4a7f, 0xc81d,		0x21, 0
	.dw 0x4ac0, 0xc81d,	0x4aff, 0xc81d,		0x21, 0
	.dw 0x4b40, 0xc81d,	0x4b7f, 0xc81d,		0x21, 0
	.dw 0x4bc0, 0xc81d,	0x4bff, 0xc81d,		0x21, 0
	.dw 0x4c40, 0xc81d,	0x4c7f, 0xc81d,		0x21, 0
	.dw 0x4cc0, 0xc81d,	0x4cff, 0xc81d,		0x21, 0
	.dw 0x4d40, 0xc81d,	0x4d7f, 0xc81d,		0x21, 0
	.dw 0x4dc0, 0xc81d,	0x4dff, 0xc81d,		0x21, 0
	.dw 0x4e40, 0xc81d,	0x4e7f, 0xc81d,		0x21, 0
	.dw 0x4ec0, 0xc81d,	0x4eff, 0xc81d,		0x21, 0
	.dw 0x4f40, 0xc81d,	0x4f7f, 0xc81d,		0x21, 0
	.dw 0x4fc0, 0xc81d,	0x4fff, 0xc81d,		0x21, 0
	.dw 0x5040, 0xc81d,	0x507f, 0xc81d,		0x21, 0
	.dw 0x50c0, 0xc81d,	0x50ff, 0xc81d,		0x21, 0
	.dw 0x5140, 0xc81d,	0x517f, 0xc81d,		0x21, 0
	.dw 0x51c0, 0xc81d,	0x51ff, 0xc81d,		0x21, 0
	.dw 0x5240, 0xc81d,	0x527f, 0xc81d,		0x21, 0
	.dw 0x52c0, 0xc81d,	0x52ff, 0xc81d,		0x21, 0
	.dw 0x5340, 0xc81d,	0x537f, 0xc81d,		0x21, 0
	.dw 0x53c0, 0xc81d,	0x53ff, 0xc81d,		0x21, 0
	.dw 0x5440, 0xc81d,	0x547f, 0xc81d,		0x21, 0
	.dw 0x54c0, 0xc81d,	0x54ff, 0xc81d,		0x21, 0
	.dw 0x5540, 0xc81d,	0x557f, 0xc81d,		0x21, 0
	.dw 0x55c0, 0xc81d,	0x55ff, 0xc81d,		0x21, 0
	.dw 0x5640, 0xc81d,	0x567f, 0xc81d,		0x21, 0
	.dw 0x56c0, 0xc81d,	0x56ff, 0xc81d,		0x21, 0
	.dw 0x5740, 0xc81d,	0x577f, 0xc81d,		0x21, 0
	.dw 0x57c0, 0xc81d,	0x57ff, 0xc81d,		0x21, 0
	.dw 0x5840, 0xc81d,	0x587f, 0xc81d,		0x21, 0
	.dw 0x58c0, 0xc81d,	0x58ff, 0xc81d,		0x21, 0
	.dw 0x5940, 0xc81d,	0x597f, 0xc81d,		0x21, 0
	.dw 0x59c0, 0xc81d,	0x5fff, 0xc81d,		0x21, 0
	.dw 0x6040, 0xc81d,	0x607f, 0xc81d,		0x21, 0
	.dw 0x60c0, 0xc81d,	0x60ff, 0xc81d,		0x21, 0
	.dw 0x6140, 0xc81d,	0x617f, 0xc81d,		0x21, 0
	.dw 0x61c0, 0xc81d,	0x61ff, 0xc81d,		0x21, 0
	.dw 0x6240, 0xc81d,	0x627f, 0xc81d,		0x21, 0
	.dw 0x62c0, 0xc81d,	0x62ff, 0xc81d,		0x21, 0
	.dw 0x6340, 0xc81d,	0x637f, 0xc81d,		0x21, 0
	.dw 0x63c0, 0xc81d,	0x63ff, 0xc81d,		0x21, 0
	.dw 0x6440, 0xc81d,	0x647f, 0xc81d,		0x21, 0
	.dw 0x64c0, 0xc81d,	0x64ff, 0xc81d,		0x21, 0
	.dw 0x6540, 0xc81d,	0x657f, 0xc81d,		0x21, 0
	.dw 0x65c0, 0xc81d,	0x65ff, 0xc81d,		0x21, 0
	.dw 0x6640, 0xc81d,	0x667f, 0xc81d,		0x21, 0
	.dw 0x66c0, 0xc81d,	0x66ff, 0xc81d,		0x21, 0
	.dw 0x6740, 0xc81d,	0x677f, 0xc81d,		0x21, 0
	.dw 0x67c0, 0xc81d,	0x67ff, 0xc81d,		0x21, 0
	.dw 0x6840, 0xc81d,	0x687f, 0xc81d,		0x21, 0
	.dw 0x68c0, 0xc81d,	0x68ff, 0xc81d,		0x21, 0
	.dw 0x6940, 0xc81d,	0x697f, 0xc81d,		0x21, 0
	.dw 0x69c0, 0xc81d,	0x69ff, 0xc81d,		0x21, 0
	.dw 0x6a40, 0xc81d,	0x6a7f, 0xc81d,		0x21, 0
	.dw 0x6ac0, 0xc81d,	0x6aff, 0xc81d,		0x21, 0
	.dw 0x6b40, 0xc81d,	0x6b7f, 0xc81d,		0x21, 0
	.dw 0x6bc0, 0xc81d,	0x6bff, 0xc81d,		0x21, 0
	.dw 0x6c40, 0xc81d,	0x6c7f, 0xc81d,		0x21, 0
	.dw 0x6cc0, 0xc81d,	0x6cff, 0xc81d,		0x21, 0
	.dw 0x6d40, 0xc81d,	0x6d7f, 0xc81d,		0x21, 0
	.dw 0x6dc0, 0xc81d,	0x6dff, 0xc81d,		0x21, 0
	.dw 0x6e40, 0xc81d,	0x6e7f, 0xc81d,		0x21, 0
	.dw 0x6ec0, 0xc81d,	0x6eff, 0xc81d,		0x21, 0
	.dw 0x6f40, 0xc81d,	0x6f7f, 0xc81d,		0x21, 0
	.dw 0x6fc0, 0xc81d,	0x6fff, 0xc81d,		0x21, 0
	.dw 0x7040, 0xc81d,	0x707f, 0xc81d,		0x21, 0
	.dw 0x70c0, 0xc81d,	0x70ff, 0xc81d,		0x21, 0
	.dw 0x7140, 0xc81d,	0x717f, 0xc81d,		0x21, 0
	.dw 0x71c0, 0xc81d,	0x71ff, 0xc81d,		0x21, 0
	.dw 0x7240, 0xc81d,	0x727f, 0xc81d,		0x21, 0
	.dw 0x72c0, 0xc81d,	0x72ff, 0xc81d,		0x21, 0
	.dw 0x7340, 0xc81d,	0x737f, 0xc81d,		0x21, 0
	.dw 0x73c0, 0xc81d,	0x73ff, 0xc81d,		0x21, 0
	.dw 0x7440, 0xc81d,	0x747f, 0xc81d,		0x21, 0
	.dw 0x74c0, 0xc81d,	0x74ff, 0xc81d,		0x21, 0
	.dw 0x7540, 0xc81d,	0x757f, 0xc81d,		0x21, 0
	.dw 0x75c0, 0xc81d,	0x75ff, 0xc81d,		0x21, 0
	.dw 0x7640, 0xc81d,	0x767f, 0xc81d,		0x21, 0
	.dw 0x76c0, 0xc81d,	0x76ff, 0xc81d,		0x21, 0
	.dw 0x7740, 0xc81d,	0x777f, 0xc81d,		0x21, 0
	.dw 0x77c0, 0xc81d,	0x77ff, 0xc81d,		0x21, 0
	.dw 0x7840, 0xc81d,	0x787f, 0xc81d,		0x21, 0
	.dw 0x78c0, 0xc81d,	0x78ff, 0xc81d,		0x21, 0
	.dw 0x7940, 0xc81d,	0x797f, 0xc81d,		0x21, 0
	.dw 0x79c0, 0xc81d,	0x7fff, 0xc81d,		0x21, 0
	.dw 0x8040, 0xc81d,	0x807f, 0xc81d,		0x21, 0
	.dw 0x80c0, 0xc81d,	0x80ff, 0xc81d,		0x21, 0
	.dw 0x8140, 0xc81d,	0x817f, 0xc81d,		0x21, 0
	.dw 0x81c0, 0xc81d,	0x81ff, 0xc81d,		0x21, 0
	.dw 0x8240, 0xc81d,	0x827f, 0xc81d,		0x21, 0
	.dw 0x82c0, 0xc81d,	0x82ff, 0xc81d,		0x21, 0
	.dw 0x8340, 0xc81d,	0x837f, 0xc81d,		0x21, 0
	.dw 0x83c0, 0xc81d,	0x83ff, 0xc81d,		0x21, 0
	.dw 0x8440, 0xc81d,	0x847f, 0xc81d,		0x21, 0
	.dw 0x84c0, 0xc81d,	0x84ff, 0xc81d,		0x21, 0
	.dw 0x8540, 0xc81d,	0x857f, 0xc81d,		0x21, 0
	.dw 0x85c0, 0xc81d,	0x85ff, 0xc81d,		0x21, 0
	.dw 0x8640, 0xc81d,	0x867f, 0xc81d,		0x21, 0
	.dw 0x86c0, 0xc81d,	0x86ff, 0xc81d,		0x21, 0
	.dw 0x8740, 0xc81d,	0x877f, 0xc81d,		0x21, 0
	.dw 0x87c0, 0xc81d,	0x87ff, 0xc81d,		0x21, 0
	.dw 0x8840, 0xc81d,	0x887f, 0xc81d,		0x21, 0
	.dw 0x88c0, 0xc81d,	0x88ff, 0xc81d,		0x21, 0
	.dw 0x8940, 0xc81d,	0x897f, 0xc81d,		0x21, 0
	.dw 0x89c0, 0xc81d,	0x89ff, 0xc81d,		0x21, 0
	.dw 0x8a40, 0xc81d,	0x8a7f, 0xc81d,		0x21, 0
	.dw 0x8ac0, 0xc81d,	0x8aff, 0xc81d,		0x21, 0
	.dw 0x8b40, 0xc81d,	0x8b7f, 0xc81d,		0x21, 0
	.dw 0x8bc0, 0xc81d,	0x8bff, 0xc81d,		0x21, 0
	.dw 0x8c40, 0xc81d,	0x8c7f, 0xc81d,		0x21, 0
	.dw 0x8cc0, 0xc81d,	0x8cff, 0xc81d,		0x21, 0
	.dw 0x8d40, 0xc81d,	0x8d7f, 0xc81d,		0x21, 0
	.dw 0x8dc0, 0xc81d,	0x8dff, 0xc81d,		0x21, 0
	.dw 0x8e40, 0xc81d,	0x8e7f, 0xc81d,		0x21, 0
	.dw 0x8ec0, 0xc81d,	0x8eff, 0xc81d,		0x21, 0
	.dw 0x8f40, 0xc81d,	0x8f7f, 0xc81d,		0x21, 0
	.dw 0x8fc0, 0xc81d,	0x8fff, 0xc81d,		0x21, 0
	.dw 0x9040, 0xc81d,	0x907f, 0xc81d,		0x21, 0
	.dw 0x90c0, 0xc81d,	0x90ff, 0xc81d,		0x21, 0
	.dw 0x9140, 0xc81d,	0x917f, 0xc81d,		0x21, 0
	.dw 0x91c0, 0xc81d,	0x91ff, 0xc81d,		0x21, 0
	.dw 0x9240, 0xc81d,	0x927f, 0xc81d,		0x21, 0
	.dw 0x92c0, 0xc81d,	0x92ff, 0xc81d,		0x21, 0
	.dw 0x9340, 0xc81d,	0x937f, 0xc81d,		0x21, 0
	.dw 0x93c0, 0xc81d,	0x93ff, 0xc81d,		0x21, 0
	.dw 0x9440, 0xc81d,	0x947f, 0xc81d,		0x21, 0
	.dw 0x94c0, 0xc81d,	0x94ff, 0xc81d,		0x21, 0
	.dw 0x9540, 0xc81d,	0x957f, 0xc81d,		0x21, 0
	.dw 0x95c0, 0xc81d,	0x95ff, 0xc81d,		0x21, 0
	.dw 0x9640, 0xc81d,	0x967f, 0xc81d,		0x21, 0
	.dw 0x96c0, 0xc81d,	0x96ff, 0xc81d,		0x21, 0
	.dw 0x9740, 0xc81d,	0x977f, 0xc81d,		0x21, 0
	.dw 0x97c0, 0xc81d,	0x97ff, 0xc81d,		0x21, 0
	.dw 0x9840, 0xc81d,	0x987f, 0xc81d,		0x21, 0
	.dw 0x98c0, 0xc81d,	0x98ff, 0xc81d,		0x21, 0
	.dw 0x9940, 0xc81d,	0x997f, 0xc81d,		0x21, 0
	.dw 0x99c0, 0xc81d,	0x9fff, 0xc81d,		0x21, 0
	.dw 0xa040, 0xc81d,	0xa07f, 0xc81d,		0x21, 0
	.dw 0xa0c0, 0xc81d,	0xa0ff, 0xc81d,		0x21, 0
	.dw 0xa140, 0xc81d,	0xa17f, 0xc81d,		0x21, 0
	.dw 0xa1c0, 0xc81d,	0xa1ff, 0xc81d,		0x21, 0
	.dw 0xa240, 0xc81d,	0xa27f, 0xc81d,		0x21, 0
	.dw 0xa2c0, 0xc81d,	0xa2ff, 0xc81d,		0x21, 0
	.dw 0xa340, 0xc81d,	0xa37f, 0xc81d,		0x21, 0
	.dw 0xa3c0, 0xc81d,	0xa3ff, 0xc81d,		0x21, 0
	.dw 0xa440, 0xc81d,	0xa47f, 0xc81d,		0x21, 0
	.dw 0xa4c0, 0xc81d,	0xa4ff, 0xc81d,		0x21, 0
	.dw 0xa540, 0xc81d,	0xa57f, 0xc81d,		0x21, 0
	.dw 0xa5c0, 0xc81d,	0xa5ff, 0xc81d,		0x21, 0
	.dw 0xa640, 0xc81d,	0xa67f, 0xc81d,		0x21, 0
	.dw 0xa6c0, 0xc81d,	0xa6ff, 0xc81d,		0x21, 0
	.dw 0xa740, 0xc81d,	0xa77f, 0xc81d,		0x21, 0
	.dw 0xa7c0, 0xc81d,	0xa7ff, 0xc81d,		0x21, 0
	.dw 0xa840, 0xc81d,	0xa87f, 0xc81d,		0x21, 0
	.dw 0xa8c0, 0xc81d,	0xa8ff, 0xc81d,		0x21, 0
	.dw 0xa940, 0xc81d,	0xa97f, 0xc81d,		0x21, 0
	.dw 0xa9c0, 0xc81d,	0xa9ff, 0xc81d,		0x21, 0
	.dw 0xaa40, 0xc81d,	0xaa7f, 0xc81d,		0x21, 0
	.dw 0xaac0, 0xc81d,	0xaaff, 0xc81d,		0x21, 0
	.dw 0xab40, 0xc81d,	0xab7f, 0xc81d,		0x21, 0
	.dw 0xabc0, 0xc81d,	0xabff, 0xc81d,		0x21, 0
	.dw 0xac40, 0xc81d,	0xac7f, 0xc81d,		0x21, 0
	.dw 0xacc0, 0xc81d,	0xacff, 0xc81d,		0x21, 0
	.dw 0xad40, 0xc81d,	0xad7f, 0xc81d,		0x21, 0
	.dw 0xadc0, 0xc81d,	0xadff, 0xc81d,		0x21, 0
	.dw 0xae40, 0xc81d,	0xae7f, 0xc81d,		0x21, 0
	.dw 0xaec0, 0xc81d,	0xaeff, 0xc81d,		0x21, 0
	.dw 0xaf40, 0xc81d,	0xaf7f, 0xc81d,		0x21, 0
	.dw 0xafc0, 0xc81d,	0xafff, 0xc81d,		0x21, 0
	.dw 0xb040, 0xc81d,	0xb07f, 0xc81d,		0x21, 0
	.dw 0xb0c0, 0xc81d,	0xb0ff, 0xc81d,		0x21, 0
	.dw 0xb140, 0xc81d,	0xb17f, 0xc81d,		0x21, 0
	.dw 0xb1c0, 0xc81d,	0xb1ff, 0xc81d,		0x21, 0
	.dw 0xb240, 0xc81d,	0xb27f, 0xc81d,		0x21, 0
	.dw 0xb2c0, 0xc81d,	0xb2ff, 0xc81d,		0x21, 0
	.dw 0xb340, 0xc81d,	0xb37f, 0xc81d,		0x21, 0
	.dw 0xb3c0, 0xc81d,	0xb3ff, 0xc81d,		0x21, 0
	.dw 0xb440, 0xc81d,	0xb47f, 0xc81d,		0x21, 0
	.dw 0xb4c0, 0xc81d,	0xb4ff, 0xc81d,		0x21, 0
	.dw 0xb540, 0xc81d,	0xb57f, 0xc81d,		0x21, 0
	.dw 0xb5c0, 0xc81d,	0xb5ff, 0xc81d,		0x21, 0
	.dw 0xb640, 0xc81d,	0xb67f, 0xc81d,		0x21, 0
	.dw 0xb6c0, 0xc81d,	0xb6ff, 0xc81d,		0x21, 0
	.dw 0xb740, 0xc81d,	0xb77f, 0xc81d,		0x21, 0
	.dw 0xb7c0, 0xc81d,	0xb7ff, 0xc81d,		0x21, 0
	.dw 0xb840, 0xc81d,	0xb87f, 0xc81d,		0x21, 0
	.dw 0xb8c0, 0xc81d,	0xb8ff, 0xc81d,		0x21, 0
	.dw 0xb940, 0xc81d,	0xb97f, 0xc81d,		0x21, 0
	.dw 0xb9c0, 0xc81d,	0xbfff, 0xc81d,		0x21, 0
	.dw 0xc040, 0xc81d,	0xc07f, 0xc81d,		0x21, 0
	.dw 0xc0c0, 0xc81d,	0xc0ff, 0xc81d,		0x21, 0
	.dw 0xc140, 0xc81d,	0xc17f, 0xc81d,		0x21, 0
	.dw 0xc1c0, 0xc81d,	0xc1ff, 0xc81d,		0x21, 0
	.dw 0xc240, 0xc81d,	0xc27f, 0xc81d,		0x21, 0
	.dw 0xc2c0, 0xc81d,	0xc2ff, 0xc81d,		0x21, 0
	.dw 0xc340, 0xc81d,	0xc37f, 0xc81d,		0x21, 0
	.dw 0xc3c0, 0xc81d,	0xc3ff, 0xc81d,		0x21, 0
	.dw 0xc440, 0xc81d,	0xc47f, 0xc81d,		0x21, 0
	.dw 0xc4c0, 0xc81d,	0xc4ff, 0xc81d,		0x21, 0
	.dw 0xc540, 0xc81d,	0xc57f, 0xc81d,		0x21, 0
	.dw 0xc5c0, 0xc81d,	0xc5ff, 0xc81d,		0x21, 0
	.dw 0xc640, 0xc81d,	0xc67f, 0xc81d,		0x21, 0
	.dw 0xc6c0, 0xc81d,	0xc6ff, 0xc81d,		0x21, 0
	.dw 0xc740, 0xc81d,	0xc77f, 0xc81d,		0x21, 0
	.dw 0xc7c0, 0xc81d,	0xc7ff, 0xc81d,		0x21, 0
	.dw 0xc840, 0xc81d,	0xc87f, 0xc81d,		0x21, 0
	.dw 0xc8c0, 0xc81d,	0xc8ff, 0xc81d,		0x21, 0
	.dw 0xc940, 0xc81d,	0xc97f, 0xc81d,		0x21, 0
	.dw 0xc9c0, 0xc81d,	0xc9ff, 0xc81d,		0x21, 0
	.dw 0xca40, 0xc81d,	0xca7f, 0xc81d,		0x21, 0
	.dw 0xcac0, 0xc81d,	0xcaff, 0xc81d,		0x21, 0
	.dw 0xcb40, 0xc81d,	0xcb7f, 0xc81d,		0x21, 0
	.dw 0xcbc0, 0xc81d,	0xcbff, 0xc81d,		0x21, 0
	.dw 0xcc40, 0xc81d,	0xcc7f, 0xc81d,		0x21, 0
	.dw 0xccc0, 0xc81d,	0xccff, 0xc81d,		0x21, 0
	.dw 0xcd40, 0xc81d,	0xcd7f, 0xc81d,		0x21, 0
	.dw 0xcdc0, 0xc81d,	0xcdff, 0xc81d,		0x21, 0
	.dw 0xce40, 0xc81d,	0xce7f, 0xc81d,		0x21, 0
	.dw 0xcec0, 0xc81d,	0xceff, 0xc81d,		0x21, 0
	.dw 0xcf40, 0xc81d,	0xcf7f, 0xc81d,		0x21, 0
	.dw 0xcfc0, 0xc81d,	0xcfff, 0xc81d,		0x21, 0
	.dw 0xd040, 0xc81d,	0xd07f, 0xc81d,		0x21, 0
	.dw 0xd0c0, 0xc81d,	0xd0ff, 0xc81d,		0x21, 0
	.dw 0xd140, 0xc81d,	0xd17f, 0xc81d,		0x21, 0
	.dw 0xd1c0, 0xc81d,	0xd1ff, 0xc81d,		0x21, 0
	.dw 0xd240, 0xc81d,	0xd27f, 0xc81d,		0x21, 0
	.dw 0xd2c0, 0xc81d,	0xd2ff, 0xc81d,		0x21, 0
	.dw 0xd340, 0xc81d,	0xd37f, 0xc81d,		0x21, 0
	.dw 0xd3c0, 0xc81d,	0xd3ff, 0xc81d,		0x21, 0
	.dw 0xd440, 0xc81d,	0xd47f, 0xc81d,		0x21, 0
	.dw 0xd4c0, 0xc81d,	0xd4ff, 0xc81d,		0x21, 0
	.dw 0xd540, 0xc81d,	0xd57f, 0xc81d,		0x21, 0
	.dw 0xd5c0, 0xc81d,	0xd5ff, 0xc81d,		0x21, 0
	.dw 0xd640, 0xc81d,	0xd67f, 0xc81d,		0x21, 0
	.dw 0xd6c0, 0xc81d,	0xd6ff, 0xc81d,		0x21, 0
	.dw 0xd740, 0xc81d,	0xd77f, 0xc81d,		0x21, 0
	.dw 0xd7c0, 0xc81d,	0xd7ff, 0xc81d,		0x21, 0
	.dw 0xd840, 0xc81d,	0xd87f, 0xc81d,		0x21, 0
	.dw 0xd8c0, 0xc81d,	0xd8ff, 0xc81d,		0x21, 0
	.dw 0xd940, 0xc81d,	0xd97f, 0xc81d,		0x21, 0
	.dw 0xd9c0, 0xc81d,	0xdfff, 0xc81d,		0x21, 0
	.dw 0xe040, 0xc81d,	0xe07f, 0xc81d,		0x21, 0
	.dw 0xe0c0, 0xc81d,	0xe0ff, 0xc81d,		0x21, 0
	.dw 0xe140, 0xc81d,	0xe17f, 0xc81d,		0x21, 0
	.dw 0xe1c0, 0xc81d,	0xe1ff, 0xc81d,		0x21, 0
	.dw 0xe240, 0xc81d,	0xe27f, 0xc81d,		0x21, 0
	.dw 0xe2c0, 0xc81d,	0xe2ff, 0xc81d,		0x21, 0
	.dw 0xe340, 0xc81d,	0xe37f, 0xc81d,		0x21, 0
	.dw 0xe3c0, 0xc81d,	0xe3ff, 0xc81d,		0x21, 0
	.dw 0xe440, 0xc81d,	0xe47f, 0xc81d,		0x21, 0
	.dw 0xe4c0, 0xc81d,	0xe4ff, 0xc81d,		0x21, 0
	.dw 0xe540, 0xc81d,	0xe57f, 0xc81d,		0x21, 0
	.dw 0xe5c0, 0xc81d,	0xe5ff, 0xc81d,		0x21, 0
	.dw 0xe640, 0xc81d,	0xe67f, 0xc81d,		0x21, 0
	.dw 0xe6c0, 0xc81d,	0xe6ff, 0xc81d,		0x21, 0
	.dw 0xe740, 0xc81d,	0xe77f, 0xc81d,		0x21, 0
	.dw 0xe7c0, 0xc81d,	0xe7ff, 0xc81d,		0x21, 0
	.dw 0xe840, 0xc81d,	0xe87f, 0xc81d,		0x21, 0
	.dw 0xe8c0, 0xc81d,	0xe8ff, 0xc81d,		0x21, 0
	.dw 0xe940, 0xc81d,	0xe97f, 0xc81d,		0x21, 0
	.dw 0xe9c0, 0xc81d,	0xe9ff, 0xc81d,		0x21, 0
	.dw 0xea40, 0xc81d,	0xea7f, 0xc81d,		0x21, 0
	.dw 0xeac0, 0xc81d,	0xeaff, 0xc81d,		0x21, 0
	.dw 0xeb40, 0xc81d,	0xeb7f, 0xc81d,		0x21, 0
	.dw 0xebc0, 0xc81d,	0xebff, 0xc81d,		0x21, 0
	.dw 0xec40, 0xc81d,	0xec7f, 0xc81d,		0x21, 0
	.dw 0xecc0, 0xc81d,	0xecff, 0xc81d,		0x21, 0
	.dw 0xed40, 0xc81d,	0xed7f, 0xc81d,		0x21, 0
	.dw 0xedc0, 0xc81d,	0xedff, 0xc81d,		0x21, 0
	.dw 0xee40, 0xc81d,	0xee7f, 0xc81d,		0x21, 0
	.dw 0xeec0, 0xc81d,	0xeeff, 0xc81d,		0x21, 0
	.dw 0xef40, 0xc81d,	0xef7f, 0xc81d,		0x21, 0
	.dw 0xefc0, 0xc81d,	0xefff, 0xc81d,		0x21, 0
	.dw 0xf040, 0xc81d,	0xf07f, 0xc81d,		0x21, 0
	.dw 0xf0c0, 0xc81d,	0xf0ff, 0xc81d,		0x21, 0
	.dw 0xf140, 0xc81d,	0xf17f, 0xc81d,		0x21, 0
	.dw 0xf1c0, 0xc81d,	0xf1ff, 0xc81d,		0x21, 0
	.dw 0xf240, 0xc81d,	0xf27f, 0xc81d,		0x21, 0
	.dw 0xf2c0, 0xc81d,	0xf2ff, 0xc81d,		0x21, 0
	.dw 0xf340, 0xc81d,	0xf37f, 0xc81d,		0x21, 0
	.dw 0xf3c0, 0xc81d,	0xf3ff, 0xc81d,		0x21, 0
	.dw 0xf440, 0xc81d,	0xf47f, 0xc81d,		0x21, 0
	.dw 0xf4c0, 0xc81d,	0xf4ff, 0xc81d,		0x21, 0
	.dw 0xf540, 0xc81d,	0xf57f, 0xc81d,		0x21, 0
	.dw 0xf5c0, 0xc81d,	0xf5ff, 0xc81d,		0x21, 0
	.dw 0xf640, 0xc81d,	0xf67f, 0xc81d,		0x21, 0
	.dw 0xf6c0, 0xc81d,	0xf6ff, 0xc81d,		0x21, 0
	.dw 0xf740, 0xc81d,	0xf77f, 0xc81d,		0x21, 0
	.dw 0xf7c0, 0xc81d,	0xf7ff, 0xc81d,		0x21, 0
	.dw 0xf840, 0xc81d,	0xf87f, 0xc81d,		0x21, 0
	.dw 0xf8c0, 0xc81d,	0xf8ff, 0xc81d,		0x21, 0
	.dw 0xf940, 0xc81d,	0xf97f, 0xc81d,		0x21, 0
	.dw 0xf9c0, 0xc81d,	0xffff, 0xc81d,		0x21, 0
	.dw 0x0040, 0xc81e,	0x007f, 0xc81e,		0x21, 0
	.dw 0x00c0, 0xc81e,	0x00ff, 0xc81e,		0x21, 0
	.dw 0x0140, 0xc81e,	0x017f, 0xc81e,		0x21, 0
	.dw 0x01c0, 0xc81e,	0x01ff, 0xc81e,		0x21, 0
	.dw 0x0240, 0xc81e,	0x027f, 0xc81e,		0x21, 0
	.dw 0x02c0, 0xc81e,	0x02ff, 0xc81e,		0x21, 0
	.dw 0x0340, 0xc81e,	0x037f, 0xc81e,		0x21, 0
	.dw 0x03c0, 0xc81e,	0x03ff, 0xc81e,		0x21, 0
	.dw 0x0440, 0xc81e,	0x047f, 0xc81e,		0x21, 0
	.dw 0x04c0, 0xc81e,	0x04ff, 0xc81e,		0x21, 0
	.dw 0x0540, 0xc81e,	0x057f, 0xc81e,		0x21, 0
	.dw 0x05c0, 0xc81e,	0x05ff, 0xc81e,		0x21, 0
	.dw 0x0640, 0xc81e,	0x067f, 0xc81e,		0x21, 0
	.dw 0x06c0, 0xc81e,	0x06ff, 0xc81e,		0x21, 0
	.dw 0x0740, 0xc81e,	0x077f, 0xc81e,		0x21, 0
	.dw 0x07c0, 0xc81e,	0x07ff, 0xc81e,		0x21, 0
	.dw 0x0840, 0xc81e,	0x087f, 0xc81e,		0x21, 0
	.dw 0x08c0, 0xc81e,	0x08ff, 0xc81e,		0x21, 0
	.dw 0x0940, 0xc81e,	0x097f, 0xc81e,		0x21, 0
	.dw 0x09c0, 0xc81e,	0x09ff, 0xc81e,		0x21, 0
	.dw 0x0a40, 0xc81e,	0x0a7f, 0xc81e,		0x21, 0
	.dw 0x0ac0, 0xc81e,	0x0aff, 0xc81e,		0x21, 0
	.dw 0x0b40, 0xc81e,	0x0b7f, 0xc81e,		0x21, 0
	.dw 0x0bc0, 0xc81e,	0x0bff, 0xc81e,		0x21, 0
	.dw 0x0c40, 0xc81e,	0x0c7f, 0xc81e,		0x21, 0
	.dw 0x0cc0, 0xc81e,	0x0cff, 0xc81e,		0x21, 0
	.dw 0x0d40, 0xc81e,	0x0d7f, 0xc81e,		0x21, 0
	.dw 0x0dc0, 0xc81e,	0x0dff, 0xc81e,		0x21, 0
	.dw 0x0e40, 0xc81e,	0x0e7f, 0xc81e,		0x21, 0
	.dw 0x0ec0, 0xc81e,	0x0eff, 0xc81e,		0x21, 0
	.dw 0x0f40, 0xc81e,	0x0f7f, 0xc81e,		0x21, 0
	.dw 0x0fc0, 0xc81e,	0x0fff, 0xc81e,		0x21, 0
	.dw 0x1040, 0xc81e,	0x107f, 0xc81e,		0x21, 0
	.dw 0x10c0, 0xc81e,	0x10ff, 0xc81e,		0x21, 0
	.dw 0x1140, 0xc81e,	0x117f, 0xc81e,		0x21, 0
	.dw 0x11c0, 0xc81e,	0x11ff, 0xc81e,		0x21, 0
	.dw 0x1240, 0xc81e,	0x127f, 0xc81e,		0x21, 0
	.dw 0x12c0, 0xc81e,	0x12ff, 0xc81e,		0x21, 0
	.dw 0x1340, 0xc81e,	0x137f, 0xc81e,		0x21, 0
	.dw 0x13c0, 0xc81e,	0x13ff, 0xc81e,		0x21, 0
	.dw 0x1440, 0xc81e,	0x147f, 0xc81e,		0x21, 0
	.dw 0x14c0, 0xc81e,	0x14ff, 0xc81e,		0x21, 0
	.dw 0x1540, 0xc81e,	0x157f, 0xc81e,		0x21, 0
	.dw 0x15c0, 0xc81e,	0x15ff, 0xc81e,		0x21, 0
	.dw 0x1640, 0xc81e,	0x167f, 0xc81e,		0x21, 0
	.dw 0x16c0, 0xc81e,	0x16ff, 0xc81e,		0x21, 0
	.dw 0x1740, 0xc81e,	0x177f, 0xc81e,		0x21, 0
	.dw 0x17c0, 0xc81e,	0x17ff, 0xc81e,		0x21, 0
	.dw 0x1840, 0xc81e,	0x187f, 0xc81e,		0x21, 0
	.dw 0x18c0, 0xc81e,	0x18ff, 0xc81e,		0x21, 0
	.dw 0x1940, 0xc81e,	0x197f, 0xc81e,		0x21, 0
	.dw 0x19c0, 0xc81e,	0x1fff, 0xc81e,		0x21, 0
	.dw 0x2040, 0xc81e,	0x207f, 0xc81e,		0x21, 0
	.dw 0x20c0, 0xc81e,	0x20ff, 0xc81e,		0x21, 0
	.dw 0x2140, 0xc81e,	0x217f, 0xc81e,		0x21, 0
	.dw 0x21c0, 0xc81e,	0x21ff, 0xc81e,		0x21, 0
	.dw 0x2240, 0xc81e,	0x227f, 0xc81e,		0x21, 0
	.dw 0x22c0, 0xc81e,	0x22ff, 0xc81e,		0x21, 0
	.dw 0x2340, 0xc81e,	0x237f, 0xc81e,		0x21, 0
	.dw 0x23c0, 0xc81e,	0x23ff, 0xc81e,		0x21, 0
	.dw 0x2440, 0xc81e,	0x247f, 0xc81e,		0x21, 0
	.dw 0x24c0, 0xc81e,	0x24ff, 0xc81e,		0x21, 0
	.dw 0x2540, 0xc81e,	0x257f, 0xc81e,		0x21, 0
	.dw 0x25c0, 0xc81e,	0x25ff, 0xc81e,		0x21, 0
	.dw 0x2640, 0xc81e,	0x267f, 0xc81e,		0x21, 0
	.dw 0x26c0, 0xc81e,	0x26ff, 0xc81e,		0x21, 0
	.dw 0x2740, 0xc81e,	0x277f, 0xc81e,		0x21, 0
	.dw 0x27c0, 0xc81e,	0x27ff, 0xc81e,		0x21, 0
	.dw 0x2840, 0xc81e,	0x287f, 0xc81e,		0x21, 0
	.dw 0x28c0, 0xc81e,	0x28ff, 0xc81e,		0x21, 0
	.dw 0x2940, 0xc81e,	0x297f, 0xc81e,		0x21, 0
	.dw 0x29c0, 0xc81e,	0x29ff, 0xc81e,		0x21, 0
	.dw 0x2a40, 0xc81e,	0x2a7f, 0xc81e,		0x21, 0
	.dw 0x2ac0, 0xc81e,	0x2aff, 0xc81e,		0x21, 0
	.dw 0x2b40, 0xc81e,	0x2b7f, 0xc81e,		0x21, 0
	.dw 0x2bc0, 0xc81e,	0x2bff, 0xc81e,		0x21, 0
	.dw 0x2c40, 0xc81e,	0x2c7f, 0xc81e,		0x21, 0
	.dw 0x2cc0, 0xc81e,	0x2cff, 0xc81e,		0x21, 0
	.dw 0x2d40, 0xc81e,	0x2d7f, 0xc81e,		0x21, 0
	.dw 0x2dc0, 0xc81e,	0x2dff, 0xc81e,		0x21, 0
	.dw 0x2e40, 0xc81e,	0x2e7f, 0xc81e,		0x21, 0
	.dw 0x2ec0, 0xc81e,	0x2eff, 0xc81e,		0x21, 0
	.dw 0x2f40, 0xc81e,	0x2f7f, 0xc81e,		0x21, 0
	.dw 0x2fc0, 0xc81e,	0x2fff, 0xc81e,		0x21, 0
	.dw 0x3040, 0xc81e,	0x307f, 0xc81e,		0x21, 0
	.dw 0x30c0, 0xc81e,	0x30ff, 0xc81e,		0x21, 0
	.dw 0x3140, 0xc81e,	0x317f, 0xc81e,		0x21, 0
	.dw 0x31c0, 0xc81e,	0x31ff, 0xc81e,		0x21, 0
	.dw 0x3240, 0xc81e,	0x327f, 0xc81e,		0x21, 0
	.dw 0x32c0, 0xc81e,	0x32ff, 0xc81e,		0x21, 0
	.dw 0x3340, 0xc81e,	0x337f, 0xc81e,		0x21, 0
	.dw 0x33c0, 0xc81e,	0x33ff, 0xc81e,		0x21, 0
	.dw 0x3440, 0xc81e,	0x347f, 0xc81e,		0x21, 0
	.dw 0x34c0, 0xc81e,	0x34ff, 0xc81e,		0x21, 0
	.dw 0x3540, 0xc81e,	0x357f, 0xc81e,		0x21, 0
	.dw 0x35c0, 0xc81e,	0x35ff, 0xc81e,		0x21, 0
	.dw 0x3640, 0xc81e,	0x367f, 0xc81e,		0x21, 0
	.dw 0x36c0, 0xc81e,	0x36ff, 0xc81e,		0x21, 0
	.dw 0x3740, 0xc81e,	0x377f, 0xc81e,		0x21, 0
	.dw 0x37c0, 0xc81e,	0x37ff, 0xc81e,		0x21, 0
	.dw 0x3840, 0xc81e,	0x387f, 0xc81e,		0x21, 0
	.dw 0x38c0, 0xc81e,	0x38ff, 0xc81e,		0x21, 0
	.dw 0x3940, 0xc81e,	0x397f, 0xc81e,		0x21, 0
	.dw 0x39c0, 0xc81e,	0x3fff, 0xc81e,		0x21, 0
	.dw 0x4040, 0xc81e,	0x407f, 0xc81e,		0x21, 0
	.dw 0x40c0, 0xc81e,	0x40ff, 0xc81e,		0x21, 0
	.dw 0x4140, 0xc81e,	0x417f, 0xc81e,		0x21, 0
	.dw 0x41c0, 0xc81e,	0x41ff, 0xc81e,		0x21, 0
	.dw 0x4240, 0xc81e,	0x427f, 0xc81e,		0x21, 0
	.dw 0x42c0, 0xc81e,	0x42ff, 0xc81e,		0x21, 0
	.dw 0x4340, 0xc81e,	0x437f, 0xc81e,		0x21, 0
	.dw 0x43c0, 0xc81e,	0x43ff, 0xc81e,		0x21, 0
	.dw 0x4440, 0xc81e,	0x447f, 0xc81e,		0x21, 0
	.dw 0x44c0, 0xc81e,	0x44ff, 0xc81e,		0x21, 0
	.dw 0x4540, 0xc81e,	0x457f, 0xc81e,		0x21, 0
	.dw 0x45c0, 0xc81e,	0x45ff, 0xc81e,		0x21, 0
	.dw 0x4640, 0xc81e,	0x467f, 0xc81e,		0x21, 0
	.dw 0x46c0, 0xc81e,	0x46ff, 0xc81e,		0x21, 0
	.dw 0x4740, 0xc81e,	0x477f, 0xc81e,		0x21, 0
	.dw 0x47c0, 0xc81e,	0x47ff, 0xc81e,		0x21, 0
	.dw 0x4840, 0xc81e,	0x487f, 0xc81e,		0x21, 0
	.dw 0x48c0, 0xc81e,	0x48ff, 0xc81e,		0x21, 0
	.dw 0x4940, 0xc81e,	0x497f, 0xc81e,		0x21, 0
	.dw 0x49c0, 0xc81e,	0x49ff, 0xc81e,		0x21, 0
	.dw 0x4a40, 0xc81e,	0x4a7f, 0xc81e,		0x21, 0
	.dw 0x4ac0, 0xc81e,	0x4aff, 0xc81e,		0x21, 0
	.dw 0x4b40, 0xc81e,	0x4b7f, 0xc81e,		0x21, 0
	.dw 0x4bc0, 0xc81e,	0x4bff, 0xc81e,		0x21, 0
	.dw 0x4c40, 0xc81e,	0x4c7f, 0xc81e,		0x21, 0
	.dw 0x4cc0, 0xc81e,	0x4cff, 0xc81e,		0x21, 0
	.dw 0x4d40, 0xc81e,	0x4d7f, 0xc81e,		0x21, 0
	.dw 0x4dc0, 0xc81e,	0x4dff, 0xc81e,		0x21, 0
	.dw 0x4e40, 0xc81e,	0x4e7f, 0xc81e,		0x21, 0
	.dw 0x4ec0, 0xc81e,	0x4eff, 0xc81e,		0x21, 0
	.dw 0x4f40, 0xc81e,	0x4f7f, 0xc81e,		0x21, 0
	.dw 0x4fc0, 0xc81e,	0x4fff, 0xc81e,		0x21, 0
	.dw 0x5040, 0xc81e,	0x507f, 0xc81e,		0x21, 0
	.dw 0x50c0, 0xc81e,	0x50ff, 0xc81e,		0x21, 0
	.dw 0x5140, 0xc81e,	0x517f, 0xc81e,		0x21, 0
	.dw 0x51c0, 0xc81e,	0x51ff, 0xc81e,		0x21, 0
	.dw 0x5240, 0xc81e,	0x527f, 0xc81e,		0x21, 0
	.dw 0x52c0, 0xc81e,	0x52ff, 0xc81e,		0x21, 0
	.dw 0x5340, 0xc81e,	0x537f, 0xc81e,		0x21, 0
	.dw 0x53c0, 0xc81e,	0x53ff, 0xc81e,		0x21, 0
	.dw 0x5440, 0xc81e,	0x547f, 0xc81e,		0x21, 0
	.dw 0x54c0, 0xc81e,	0x54ff, 0xc81e,		0x21, 0
	.dw 0x5540, 0xc81e,	0x557f, 0xc81e,		0x21, 0
	.dw 0x55c0, 0xc81e,	0x55ff, 0xc81e,		0x21, 0
	.dw 0x5640, 0xc81e,	0x567f, 0xc81e,		0x21, 0
	.dw 0x56c0, 0xc81e,	0x56ff, 0xc81e,		0x21, 0
	.dw 0x5740, 0xc81e,	0x577f, 0xc81e,		0x21, 0
	.dw 0x57c0, 0xc81e,	0x57ff, 0xc81e,		0x21, 0
	.dw 0x5840, 0xc81e,	0x587f, 0xc81e,		0x21, 0
	.dw 0x58c0, 0xc81e,	0x58ff, 0xc81e,		0x21, 0
	.dw 0x5940, 0xc81e,	0x597f, 0xc81e,		0x21, 0
	.dw 0x59c0, 0xc81e,	0x5fff, 0xc81e,		0x21, 0
	.dw 0x6040, 0xc81e,	0x607f, 0xc81e,		0x21, 0
	.dw 0x60c0, 0xc81e,	0x60ff, 0xc81e,		0x21, 0
	.dw 0x6140, 0xc81e,	0x617f, 0xc81e,		0x21, 0
	.dw 0x61c0, 0xc81e,	0x61ff, 0xc81e,		0x21, 0
	.dw 0x6240, 0xc81e,	0x627f, 0xc81e,		0x21, 0
	.dw 0x62c0, 0xc81e,	0x62ff, 0xc81e,		0x21, 0
	.dw 0x6340, 0xc81e,	0x637f, 0xc81e,		0x21, 0
	.dw 0x63c0, 0xc81e,	0x63ff, 0xc81e,		0x21, 0
	.dw 0x6440, 0xc81e,	0x647f, 0xc81e,		0x21, 0
	.dw 0x64c0, 0xc81e,	0x64ff, 0xc81e,		0x21, 0
	.dw 0x6540, 0xc81e,	0x657f, 0xc81e,		0x21, 0
	.dw 0x65c0, 0xc81e,	0x65ff, 0xc81e,		0x21, 0
	.dw 0x6640, 0xc81e,	0x667f, 0xc81e,		0x21, 0
	.dw 0x66c0, 0xc81e,	0x66ff, 0xc81e,		0x21, 0
	.dw 0x6740, 0xc81e,	0x677f, 0xc81e,		0x21, 0
	.dw 0x67c0, 0xc81e,	0x67ff, 0xc81e,		0x21, 0
	.dw 0x6840, 0xc81e,	0x687f, 0xc81e,		0x21, 0
	.dw 0x68c0, 0xc81e,	0x68ff, 0xc81e,		0x21, 0
	.dw 0x6940, 0xc81e,	0x697f, 0xc81e,		0x21, 0
	.dw 0x69c0, 0xc81e,	0x69ff, 0xc81e,		0x21, 0
	.dw 0x6a40, 0xc81e,	0x6a7f, 0xc81e,		0x21, 0
	.dw 0x6ac0, 0xc81e,	0x6aff, 0xc81e,		0x21, 0
	.dw 0x6b40, 0xc81e,	0x6b7f, 0xc81e,		0x21, 0
	.dw 0x6bc0, 0xc81e,	0x6bff, 0xc81e,		0x21, 0
	.dw 0x6c40, 0xc81e,	0x6c7f, 0xc81e,		0x21, 0
	.dw 0x6cc0, 0xc81e,	0x6cff, 0xc81e,		0x21, 0
	.dw 0x6d40, 0xc81e,	0x6d7f, 0xc81e,		0x21, 0
	.dw 0x6dc0, 0xc81e,	0x6dff, 0xc81e,		0x21, 0
	.dw 0x6e40, 0xc81e,	0x6e7f, 0xc81e,		0x21, 0
	.dw 0x6ec0, 0xc81e,	0x6eff, 0xc81e,		0x21, 0
	.dw 0x6f40, 0xc81e,	0x6f7f, 0xc81e,		0x21, 0
	.dw 0x6fc0, 0xc81e,	0x6fff, 0xc81e,		0x21, 0
	.dw 0x7040, 0xc81e,	0x707f, 0xc81e,		0x21, 0
	.dw 0x70c0, 0xc81e,	0x70ff, 0xc81e,		0x21, 0
	.dw 0x7140, 0xc81e,	0x717f, 0xc81e,		0x21, 0
	.dw 0x71c0, 0xc81e,	0x71ff, 0xc81e,		0x21, 0
	.dw 0x7240, 0xc81e,	0x727f, 0xc81e,		0x21, 0
	.dw 0x72c0, 0xc81e,	0x72ff, 0xc81e,		0x21, 0
	.dw 0x7340, 0xc81e,	0x737f, 0xc81e,		0x21, 0
	.dw 0x73c0, 0xc81e,	0x73ff, 0xc81e,		0x21, 0
	.dw 0x7440, 0xc81e,	0x747f, 0xc81e,		0x21, 0
	.dw 0x74c0, 0xc81e,	0x74ff, 0xc81e,		0x21, 0
	.dw 0x7540, 0xc81e,	0x757f, 0xc81e,		0x21, 0
	.dw 0x75c0, 0xc81e,	0x75ff, 0xc81e,		0x21, 0
	.dw 0x7640, 0xc81e,	0x767f, 0xc81e,		0x21, 0
	.dw 0x76c0, 0xc81e,	0x76ff, 0xc81e,		0x21, 0
	.dw 0x7740, 0xc81e,	0x777f, 0xc81e,		0x21, 0
	.dw 0x77c0, 0xc81e,	0x77ff, 0xc81e,		0x21, 0
	.dw 0x7840, 0xc81e,	0x787f, 0xc81e,		0x21, 0
	.dw 0x78c0, 0xc81e,	0x78ff, 0xc81e,		0x21, 0
	.dw 0x7940, 0xc81e,	0x797f, 0xc81e,		0x21, 0
	.dw 0x79c0, 0xc81e,	0x7fff, 0xc81e,		0x21, 0
	.dw 0x8040, 0xc81e,	0x807f, 0xc81e,		0x21, 0
	.dw 0x80c0, 0xc81e,	0x80ff, 0xc81e,		0x21, 0
	.dw 0x8140, 0xc81e,	0x817f, 0xc81e,		0x21, 0
	.dw 0x81c0, 0xc81e,	0x81ff, 0xc81e,		0x21, 0
	.dw 0x8240, 0xc81e,	0x827f, 0xc81e,		0x21, 0
	.dw 0x82c0, 0xc81e,	0x82ff, 0xc81e,		0x21, 0
	.dw 0x8340, 0xc81e,	0x837f, 0xc81e,		0x21, 0
	.dw 0x83c0, 0xc81e,	0x83ff, 0xc81e,		0x21, 0
	.dw 0x8440, 0xc81e,	0x847f, 0xc81e,		0x21, 0
	.dw 0x84c0, 0xc81e,	0x84ff, 0xc81e,		0x21, 0
	.dw 0x8540, 0xc81e,	0x857f, 0xc81e,		0x21, 0
	.dw 0x85c0, 0xc81e,	0x85ff, 0xc81e,		0x21, 0
	.dw 0x8640, 0xc81e,	0x867f, 0xc81e,		0x21, 0
	.dw 0x86c0, 0xc81e,	0x86ff, 0xc81e,		0x21, 0
	.dw 0x8740, 0xc81e,	0x877f, 0xc81e,		0x21, 0
	.dw 0x87c0, 0xc81e,	0x87ff, 0xc81e,		0x21, 0
	.dw 0x8840, 0xc81e,	0x887f, 0xc81e,		0x21, 0
	.dw 0x88c0, 0xc81e,	0x88ff, 0xc81e,		0x21, 0
	.dw 0x8940, 0xc81e,	0x897f, 0xc81e,		0x21, 0
	.dw 0x89c0, 0xc81e,	0x89ff, 0xc81e,		0x21, 0
	.dw 0x8a40, 0xc81e,	0x8a7f, 0xc81e,		0x21, 0
	.dw 0x8ac0, 0xc81e,	0x8aff, 0xc81e,		0x21, 0
	.dw 0x8b40, 0xc81e,	0x8b7f, 0xc81e,		0x21, 0
	.dw 0x8bc0, 0xc81e,	0x8bff, 0xc81e,		0x21, 0
	.dw 0x8c40, 0xc81e,	0x8c7f, 0xc81e,		0x21, 0
	.dw 0x8cc0, 0xc81e,	0x8cff, 0xc81e,		0x21, 0
	.dw 0x8d40, 0xc81e,	0x8d7f, 0xc81e,		0x21, 0
	.dw 0x8dc0, 0xc81e,	0x8dff, 0xc81e,		0x21, 0
	.dw 0x8e40, 0xc81e,	0x8e7f, 0xc81e,		0x21, 0
	.dw 0x8ec0, 0xc81e,	0x8eff, 0xc81e,		0x21, 0
	.dw 0x8f40, 0xc81e,	0x8f7f, 0xc81e,		0x21, 0
	.dw 0x8fc0, 0xc81e,	0x8fff, 0xc81e,		0x21, 0
	.dw 0x9040, 0xc81e,	0x907f, 0xc81e,		0x21, 0
	.dw 0x90c0, 0xc81e,	0x90ff, 0xc81e,		0x21, 0
	.dw 0x9140, 0xc81e,	0x917f, 0xc81e,		0x21, 0
	.dw 0x91c0, 0xc81e,	0x91ff, 0xc81e,		0x21, 0
	.dw 0x9240, 0xc81e,	0x927f, 0xc81e,		0x21, 0
	.dw 0x92c0, 0xc81e,	0x92ff, 0xc81e,		0x21, 0
	.dw 0x9340, 0xc81e,	0x937f, 0xc81e,		0x21, 0
	.dw 0x93c0, 0xc81e,	0x93ff, 0xc81e,		0x21, 0
	.dw 0x9440, 0xc81e,	0x947f, 0xc81e,		0x21, 0
	.dw 0x94c0, 0xc81e,	0x94ff, 0xc81e,		0x21, 0
	.dw 0x9540, 0xc81e,	0x957f, 0xc81e,		0x21, 0
	.dw 0x95c0, 0xc81e,	0x95ff, 0xc81e,		0x21, 0
	.dw 0x9640, 0xc81e,	0x967f, 0xc81e,		0x21, 0
	.dw 0x96c0, 0xc81e,	0x96ff, 0xc81e,		0x21, 0
	.dw 0x9740, 0xc81e,	0x977f, 0xc81e,		0x21, 0
	.dw 0x97c0, 0xc81e,	0x97ff, 0xc81e,		0x21, 0
	.dw 0x9840, 0xc81e,	0x987f, 0xc81e,		0x21, 0
	.dw 0x98c0, 0xc81e,	0x98ff, 0xc81e,		0x21, 0
	.dw 0x9940, 0xc81e,	0x997f, 0xc81e,		0x21, 0
	.dw 0x99c0, 0xc81e,	0x9fff, 0xc81e,		0x21, 0
	.dw 0xa040, 0xc81e,	0xa07f, 0xc81e,		0x21, 0
	.dw 0xa0c0, 0xc81e,	0xa0ff, 0xc81e,		0x21, 0
	.dw 0xa140, 0xc81e,	0xa17f, 0xc81e,		0x21, 0
	.dw 0xa1c0, 0xc81e,	0xa1ff, 0xc81e,		0x21, 0
	.dw 0xa240, 0xc81e,	0xa27f, 0xc81e,		0x21, 0
	.dw 0xa2c0, 0xc81e,	0xa2ff, 0xc81e,		0x21, 0
	.dw 0xa340, 0xc81e,	0xa37f, 0xc81e,		0x21, 0
	.dw 0xa3c0, 0xc81e,	0xa3ff, 0xc81e,		0x21, 0
	.dw 0xa440, 0xc81e,	0xa47f, 0xc81e,		0x21, 0
	.dw 0xa4c0, 0xc81e,	0xa4ff, 0xc81e,		0x21, 0
	.dw 0xa540, 0xc81e,	0xa57f, 0xc81e,		0x21, 0
	.dw 0xa5c0, 0xc81e,	0xa5ff, 0xc81e,		0x21, 0
	.dw 0xa640, 0xc81e,	0xa67f, 0xc81e,		0x21, 0
	.dw 0xa6c0, 0xc81e,	0xa6ff, 0xc81e,		0x21, 0
	.dw 0xa740, 0xc81e,	0xa77f, 0xc81e,		0x21, 0
	.dw 0xa7c0, 0xc81e,	0xa7ff, 0xc81e,		0x21, 0
	.dw 0xa840, 0xc81e,	0xa87f, 0xc81e,		0x21, 0
	.dw 0xa8c0, 0xc81e,	0xa8ff, 0xc81e,		0x21, 0
	.dw 0xa940, 0xc81e,	0xa97f, 0xc81e,		0x21, 0
	.dw 0xa9c0, 0xc81e,	0xa9ff, 0xc81e,		0x21, 0
	.dw 0xaa40, 0xc81e,	0xaa7f, 0xc81e,		0x21, 0
	.dw 0xaac0, 0xc81e,	0xaaff, 0xc81e,		0x21, 0
	.dw 0xab40, 0xc81e,	0xab7f, 0xc81e,		0x21, 0
	.dw 0xabc0, 0xc81e,	0xabff, 0xc81e,		0x21, 0
	.dw 0xac40, 0xc81e,	0xac7f, 0xc81e,		0x21, 0
	.dw 0xacc0, 0xc81e,	0xacff, 0xc81e,		0x21, 0
	.dw 0xad40, 0xc81e,	0xad7f, 0xc81e,		0x21, 0
	.dw 0xadc0, 0xc81e,	0xadff, 0xc81e,		0x21, 0
	.dw 0xae40, 0xc81e,	0xae7f, 0xc81e,		0x21, 0
	.dw 0xaec0, 0xc81e,	0xaeff, 0xc81e,		0x21, 0
	.dw 0xaf40, 0xc81e,	0xaf7f, 0xc81e,		0x21, 0
	.dw 0xafc0, 0xc81e,	0xafff, 0xc81e,		0x21, 0
	.dw 0xb040, 0xc81e,	0xb07f, 0xc81e,		0x21, 0
	.dw 0xb0c0, 0xc81e,	0xb0ff, 0xc81e,		0x21, 0
	.dw 0xb140, 0xc81e,	0xb17f, 0xc81e,		0x21, 0
	.dw 0xb1c0, 0xc81e,	0xb1ff, 0xc81e,		0x21, 0
	.dw 0xb240, 0xc81e,	0xb27f, 0xc81e,		0x21, 0
	.dw 0xb2c0, 0xc81e,	0xb2ff, 0xc81e,		0x21, 0
	.dw 0xb340, 0xc81e,	0xb37f, 0xc81e,		0x21, 0
	.dw 0xb3c0, 0xc81e,	0xb3ff, 0xc81e,		0x21, 0
	.dw 0xb440, 0xc81e,	0xb47f, 0xc81e,		0x21, 0
	.dw 0xb4c0, 0xc81e,	0xb4ff, 0xc81e,		0x21, 0
	.dw 0xb540, 0xc81e,	0xb57f, 0xc81e,		0x21, 0
	.dw 0xb5c0, 0xc81e,	0xb5ff, 0xc81e,		0x21, 0
	.dw 0xb640, 0xc81e,	0xb67f, 0xc81e,		0x21, 0
	.dw 0xb6c0, 0xc81e,	0xb6ff, 0xc81e,		0x21, 0
	.dw 0xb740, 0xc81e,	0xb77f, 0xc81e,		0x21, 0
	.dw 0xb7c0, 0xc81e,	0xb7ff, 0xc81e,		0x21, 0
	.dw 0xb840, 0xc81e,	0xb87f, 0xc81e,		0x21, 0
	.dw 0xb8c0, 0xc81e,	0xb8ff, 0xc81e,		0x21, 0
	.dw 0xb940, 0xc81e,	0xb97f, 0xc81e,		0x21, 0
	.dw 0xb9c0, 0xc81e,	0xbfff, 0xc81e,		0x21, 0
	.dw 0xc040, 0xc81e,	0xc07f, 0xc81e,		0x21, 0
	.dw 0xc0c0, 0xc81e,	0xc0ff, 0xc81e,		0x21, 0
	.dw 0xc140, 0xc81e,	0xc17f, 0xc81e,		0x21, 0
	.dw 0xc1c0, 0xc81e,	0xc1ff, 0xc81e,		0x21, 0
	.dw 0xc240, 0xc81e,	0xc27f, 0xc81e,		0x21, 0
	.dw 0xc2c0, 0xc81e,	0xc2ff, 0xc81e,		0x21, 0
	.dw 0xc340, 0xc81e,	0xc37f, 0xc81e,		0x21, 0
	.dw 0xc3c0, 0xc81e,	0xc3ff, 0xc81e,		0x21, 0
	.dw 0xc440, 0xc81e,	0xc47f, 0xc81e,		0x21, 0
	.dw 0xc4c0, 0xc81e,	0xc4ff, 0xc81e,		0x21, 0
	.dw 0xc540, 0xc81e,	0xc57f, 0xc81e,		0x21, 0
	.dw 0xc5c0, 0xc81e,	0xc5ff, 0xc81e,		0x21, 0
	.dw 0xc640, 0xc81e,	0xc67f, 0xc81e,		0x21, 0
	.dw 0xc6c0, 0xc81e,	0xc6ff, 0xc81e,		0x21, 0
	.dw 0xc740, 0xc81e,	0xc77f, 0xc81e,		0x21, 0
	.dw 0xc7c0, 0xc81e,	0xc7ff, 0xc81e,		0x21, 0
	.dw 0xc840, 0xc81e,	0xc87f, 0xc81e,		0x21, 0
	.dw 0xc8c0, 0xc81e,	0xc8ff, 0xc81e,		0x21, 0
	.dw 0xc940, 0xc81e,	0xc97f, 0xc81e,		0x21, 0
	.dw 0xc9c0, 0xc81e,	0xc9ff, 0xc81e,		0x21, 0
	.dw 0xca40, 0xc81e,	0xca7f, 0xc81e,		0x21, 0
	.dw 0xcac0, 0xc81e,	0xcaff, 0xc81e,		0x21, 0
	.dw 0xcb40, 0xc81e,	0xcb7f, 0xc81e,		0x21, 0
	.dw 0xcbc0, 0xc81e,	0xcbff, 0xc81e,		0x21, 0
	.dw 0xcc40, 0xc81e,	0xcc7f, 0xc81e,		0x21, 0
	.dw 0xccc0, 0xc81e,	0xccff, 0xc81e,		0x21, 0
	.dw 0xcd40, 0xc81e,	0xcd7f, 0xc81e,		0x21, 0
	.dw 0xcdc0, 0xc81e,	0xcdff, 0xc81e,		0x21, 0
	.dw 0xce40, 0xc81e,	0xce7f, 0xc81e,		0x21, 0
	.dw 0xcec0, 0xc81e,	0xceff, 0xc81e,		0x21, 0
	.dw 0xcf40, 0xc81e,	0xcf7f, 0xc81e,		0x21, 0
	.dw 0xcfc0, 0xc81e,	0xcfff, 0xc81e,		0x21, 0
	.dw 0xd040, 0xc81e,	0xd07f, 0xc81e,		0x21, 0
	.dw 0xd0c0, 0xc81e,	0xd0ff, 0xc81e,		0x21, 0
	.dw 0xd140, 0xc81e,	0xd17f, 0xc81e,		0x21, 0
	.dw 0xd1c0, 0xc81e,	0xd1ff, 0xc81e,		0x21, 0
	.dw 0xd240, 0xc81e,	0xd27f, 0xc81e,		0x21, 0
	.dw 0xd2c0, 0xc81e,	0xd2ff, 0xc81e,		0x21, 0
	.dw 0xd340, 0xc81e,	0xd37f, 0xc81e,		0x21, 0
	.dw 0xd3c0, 0xc81e,	0xd3ff, 0xc81e,		0x21, 0
	.dw 0xd440, 0xc81e,	0xd47f, 0xc81e,		0x21, 0
	.dw 0xd4c0, 0xc81e,	0xd4ff, 0xc81e,		0x21, 0
	.dw 0xd540, 0xc81e,	0xd57f, 0xc81e,		0x21, 0
	.dw 0xd5c0, 0xc81e,	0xd5ff, 0xc81e,		0x21, 0
	.dw 0xd640, 0xc81e,	0xd67f, 0xc81e,		0x21, 0
	.dw 0xd6c0, 0xc81e,	0xd6ff, 0xc81e,		0x21, 0
	.dw 0xd740, 0xc81e,	0xd77f, 0xc81e,		0x21, 0
	.dw 0xd7c0, 0xc81e,	0xd7ff, 0xc81e,		0x21, 0
	.dw 0xd840, 0xc81e,	0xd87f, 0xc81e,		0x21, 0
	.dw 0xd8c0, 0xc81e,	0xd8ff, 0xc81e,		0x21, 0
	.dw 0xd940, 0xc81e,	0xd97f, 0xc81e,		0x21, 0
	.dw 0xd9c0, 0xc81e,	0xdfff, 0xc81e,		0x21, 0
	.dw 0xe040, 0xc81e,	0xe07f, 0xc81e,		0x21, 0
	.dw 0xe0c0, 0xc81e,	0xe0ff, 0xc81e,		0x21, 0
	.dw 0xe140, 0xc81e,	0xe17f, 0xc81e,		0x21, 0
	.dw 0xe1c0, 0xc81e,	0xe1ff, 0xc81e,		0x21, 0
	.dw 0xe240, 0xc81e,	0xe27f, 0xc81e,		0x21, 0
	.dw 0xe2c0, 0xc81e,	0xe2ff, 0xc81e,		0x21, 0
	.dw 0xe340, 0xc81e,	0xe37f, 0xc81e,		0x21, 0
	.dw 0xe3c0, 0xc81e,	0xe3ff, 0xc81e,		0x21, 0
	.dw 0xe440, 0xc81e,	0xe47f, 0xc81e,		0x21, 0
	.dw 0xe4c0, 0xc81e,	0xe4ff, 0xc81e,		0x21, 0
	.dw 0xe540, 0xc81e,	0xe57f, 0xc81e,		0x21, 0
	.dw 0xe5c0, 0xc81e,	0xe5ff, 0xc81e,		0x21, 0
	.dw 0xe640, 0xc81e,	0xe67f, 0xc81e,		0x21, 0
	.dw 0xe6c0, 0xc81e,	0xe6ff, 0xc81e,		0x21, 0
	.dw 0xe740, 0xc81e,	0xe77f, 0xc81e,		0x21, 0
	.dw 0xe7c0, 0xc81e,	0xe7ff, 0xc81e,		0x21, 0
	.dw 0xe840, 0xc81e,	0xe87f, 0xc81e,		0x21, 0
	.dw 0xe8c0, 0xc81e,	0xe8ff, 0xc81e,		0x21, 0
	.dw 0xe940, 0xc81e,	0xe97f, 0xc81e,		0x21, 0
	.dw 0xe9c0, 0xc81e,	0xe9ff, 0xc81e,		0x21, 0
	.dw 0xea40, 0xc81e,	0xea7f, 0xc81e,		0x21, 0
	.dw 0xeac0, 0xc81e,	0xeaff, 0xc81e,		0x21, 0
	.dw 0xeb40, 0xc81e,	0xeb7f, 0xc81e,		0x21, 0
	.dw 0xebc0, 0xc81e,	0xebff, 0xc81e,		0x21, 0
	.dw 0xec40, 0xc81e,	0xec7f, 0xc81e,		0x21, 0
	.dw 0xecc0, 0xc81e,	0xecff, 0xc81e,		0x21, 0
	.dw 0xed40, 0xc81e,	0xed7f, 0xc81e,		0x21, 0
	.dw 0xedc0, 0xc81e,	0xedff, 0xc81e,		0x21, 0
	.dw 0xee40, 0xc81e,	0xee7f, 0xc81e,		0x21, 0
	.dw 0xeec0, 0xc81e,	0xeeff, 0xc81e,		0x21, 0
	.dw 0xef40, 0xc81e,	0xef7f, 0xc81e,		0x21, 0
	.dw 0xefc0, 0xc81e,	0xefff, 0xc81e,		0x21, 0
	.dw 0xf040, 0xc81e,	0xf07f, 0xc81e,		0x21, 0
	.dw 0xf0c0, 0xc81e,	0xf0ff, 0xc81e,		0x21, 0
	.dw 0xf140, 0xc81e,	0xf17f, 0xc81e,		0x21, 0
	.dw 0xf1c0, 0xc81e,	0xf1ff, 0xc81e,		0x21, 0
	.dw 0xf240, 0xc81e,	0xf27f, 0xc81e,		0x21, 0
	.dw 0xf2c0, 0xc81e,	0xf2ff, 0xc81e,		0x21, 0
	.dw 0xf340, 0xc81e,	0xf37f, 0xc81e,		0x21, 0
	.dw 0xf3c0, 0xc81e,	0xf3ff, 0xc81e,		0x21, 0
	.dw 0xf440, 0xc81e,	0xf47f, 0xc81e,		0x21, 0
	.dw 0xf4c0, 0xc81e,	0xf4ff, 0xc81e,		0x21, 0
	.dw 0xf540, 0xc81e,	0xf57f, 0xc81e,		0x21, 0
	.dw 0xf5c0, 0xc81e,	0xf5ff, 0xc81e,		0x21, 0
	.dw 0xf640, 0xc81e,	0xf67f, 0xc81e,		0x21, 0
	.dw 0xf6c0, 0xc81e,	0xf6ff, 0xc81e,		0x21, 0
	.dw 0xf740, 0xc81e,	0xf77f, 0xc81e,		0x21, 0
	.dw 0xf7c0, 0xc81e,	0xf7ff, 0xc81e,		0x21, 0
	.dw 0xf840, 0xc81e,	0xf87f, 0xc81e,		0x21, 0
	.dw 0xf8c0, 0xc81e,	0xf8ff, 0xc81e,		0x21, 0
	.dw 0xf940, 0xc81e,	0xf97f, 0xc81e,		0x21, 0
	.dw 0xf9c0, 0xc81e,	0xffff, 0xc81e,		0x21, 0
	.dw 0x0040, 0xc81f,	0x007f, 0xc81f,		0x21, 0
	.dw 0x00c0, 0xc81f,	0x00ff, 0xc81f,		0x21, 0
	.dw 0x0140, 0xc81f,	0x017f, 0xc81f,		0x21, 0
	.dw 0x01c0, 0xc81f,	0x01ff, 0xc81f,		0x21, 0
	.dw 0x0240, 0xc81f,	0x027f, 0xc81f,		0x21, 0
	.dw 0x02c0, 0xc81f,	0x02ff, 0xc81f,		0x21, 0
	.dw 0x0340, 0xc81f,	0x037f, 0xc81f,		0x21, 0
	.dw 0x03c0, 0xc81f,	0x03ff, 0xc81f,		0x21, 0
	.dw 0x0440, 0xc81f,	0x047f, 0xc81f,		0x21, 0
	.dw 0x04c0, 0xc81f,	0x04ff, 0xc81f,		0x21, 0
	.dw 0x0540, 0xc81f,	0x057f, 0xc81f,		0x21, 0
	.dw 0x05c0, 0xc81f,	0x05ff, 0xc81f,		0x21, 0
	.dw 0x0640, 0xc81f,	0x067f, 0xc81f,		0x21, 0
	.dw 0x06c0, 0xc81f,	0x06ff, 0xc81f,		0x21, 0
	.dw 0x0740, 0xc81f,	0x077f, 0xc81f,		0x21, 0
	.dw 0x07c0, 0xc81f,	0x07ff, 0xc81f,		0x21, 0
	.dw 0x0840, 0xc81f,	0x087f, 0xc81f,		0x21, 0
	.dw 0x08c0, 0xc81f,	0x08ff, 0xc81f,		0x21, 0
	.dw 0x0940, 0xc81f,	0x097f, 0xc81f,		0x21, 0
	.dw 0x09c0, 0xc81f,	0x09ff, 0xc81f,		0x21, 0
	.dw 0x0a40, 0xc81f,	0x0a7f, 0xc81f,		0x21, 0
	.dw 0x0ac0, 0xc81f,	0x0aff, 0xc81f,		0x21, 0
	.dw 0x0b40, 0xc81f,	0x0b7f, 0xc81f,		0x21, 0
	.dw 0x0bc0, 0xc81f,	0x0bff, 0xc81f,		0x21, 0
	.dw 0x0c40, 0xc81f,	0x0c7f, 0xc81f,		0x21, 0
	.dw 0x0cc0, 0xc81f,	0x0cff, 0xc81f,		0x21, 0
	.dw 0x0d40, 0xc81f,	0x0d7f, 0xc81f,		0x21, 0
	.dw 0x0dc0, 0xc81f,	0x0dff, 0xc81f,		0x21, 0
	.dw 0x0e40, 0xc81f,	0x0e7f, 0xc81f,		0x21, 0
	.dw 0x0ec0, 0xc81f,	0x0eff, 0xc81f,		0x21, 0
	.dw 0x0f40, 0xc81f,	0x0f7f, 0xc81f,		0x21, 0
	.dw 0x0fc0, 0xc81f,	0x0fff, 0xc81f,		0x21, 0
	.dw 0x1040, 0xc81f,	0x107f, 0xc81f,		0x21, 0
	.dw 0x10c0, 0xc81f,	0x10ff, 0xc81f,		0x21, 0
	.dw 0x1140, 0xc81f,	0x117f, 0xc81f,		0x21, 0
	.dw 0x11c0, 0xc81f,	0x11ff, 0xc81f,		0x21, 0
	.dw 0x1240, 0xc81f,	0x127f, 0xc81f,		0x21, 0
	.dw 0x12c0, 0xc81f,	0x12ff, 0xc81f,		0x21, 0
	.dw 0x1340, 0xc81f,	0x137f, 0xc81f,		0x21, 0
	.dw 0x13c0, 0xc81f,	0x13ff, 0xc81f,		0x21, 0
	.dw 0x1440, 0xc81f,	0x147f, 0xc81f,		0x21, 0
	.dw 0x14c0, 0xc81f,	0x14ff, 0xc81f,		0x21, 0
	.dw 0x1540, 0xc81f,	0x157f, 0xc81f,		0x21, 0
	.dw 0x15c0, 0xc81f,	0x15ff, 0xc81f,		0x21, 0
	.dw 0x1640, 0xc81f,	0x167f, 0xc81f,		0x21, 0
	.dw 0x16c0, 0xc81f,	0x16ff, 0xc81f,		0x21, 0
	.dw 0x1740, 0xc81f,	0x177f, 0xc81f,		0x21, 0
	.dw 0x17c0, 0xc81f,	0x17ff, 0xc81f,		0x21, 0
	.dw 0x1840, 0xc81f,	0x187f, 0xc81f,		0x21, 0
	.dw 0x18c0, 0xc81f,	0x18ff, 0xc81f,		0x21, 0
	.dw 0x1940, 0xc81f,	0x197f, 0xc81f,		0x21, 0
	.dw 0x19c0, 0xc81f,	0x1fff, 0xc81f,		0x21, 0
	.dw 0x2040, 0xc81f,	0x207f, 0xc81f,		0x21, 0
	.dw 0x20c0, 0xc81f,	0x20ff, 0xc81f,		0x21, 0
	.dw 0x2140, 0xc81f,	0x217f, 0xc81f,		0x21, 0
	.dw 0x21c0, 0xc81f,	0x21ff, 0xc81f,		0x21, 0
	.dw 0x2240, 0xc81f,	0x227f, 0xc81f,		0x21, 0
	.dw 0x22c0, 0xc81f,	0x22ff, 0xc81f,		0x21, 0
	.dw 0x2340, 0xc81f,	0x237f, 0xc81f,		0x21, 0
	.dw 0x23c0, 0xc81f,	0x23ff, 0xc81f,		0x21, 0
	.dw 0x2440, 0xc81f,	0x247f, 0xc81f,		0x21, 0
	.dw 0x24c0, 0xc81f,	0x24ff, 0xc81f,		0x21, 0
	.dw 0x2540, 0xc81f,	0x257f, 0xc81f,		0x21, 0
	.dw 0x25c0, 0xc81f,	0x25ff, 0xc81f,		0x21, 0
	.dw 0x2640, 0xc81f,	0x267f, 0xc81f,		0x21, 0
	.dw 0x26c0, 0xc81f,	0x26ff, 0xc81f,		0x21, 0
	.dw 0x2740, 0xc81f,	0x277f, 0xc81f,		0x21, 0
	.dw 0x27c0, 0xc81f,	0x27ff, 0xc81f,		0x21, 0
	.dw 0x2840, 0xc81f,	0x287f, 0xc81f,		0x21, 0
	.dw 0x28c0, 0xc81f,	0x28ff, 0xc81f,		0x21, 0
	.dw 0x2940, 0xc81f,	0x297f, 0xc81f,		0x21, 0
	.dw 0x29c0, 0xc81f,	0x29ff, 0xc81f,		0x21, 0
	.dw 0x2a40, 0xc81f,	0x2a7f, 0xc81f,		0x21, 0
	.dw 0x2ac0, 0xc81f,	0x2aff, 0xc81f,		0x21, 0
	.dw 0x2b40, 0xc81f,	0x2b7f, 0xc81f,		0x21, 0
	.dw 0x2bc0, 0xc81f,	0x2bff, 0xc81f,		0x21, 0
	.dw 0x2c40, 0xc81f,	0x2c7f, 0xc81f,		0x21, 0
	.dw 0x2cc0, 0xc81f,	0x2cff, 0xc81f,		0x21, 0
	.dw 0x2d40, 0xc81f,	0x2d7f, 0xc81f,		0x21, 0
	.dw 0x2dc0, 0xc81f,	0x2dff, 0xc81f,		0x21, 0
	.dw 0x2e40, 0xc81f,	0x2e7f, 0xc81f,		0x21, 0
	.dw 0x2ec0, 0xc81f,	0x2eff, 0xc81f,		0x21, 0
	.dw 0x2f40, 0xc81f,	0x2f7f, 0xc81f,		0x21, 0
	.dw 0x2fc0, 0xc81f,	0x2fff, 0xc81f,		0x21, 0
	.dw 0x3040, 0xc81f,	0x307f, 0xc81f,		0x21, 0
	.dw 0x30c0, 0xc81f,	0x30ff, 0xc81f,		0x21, 0
	.dw 0x3140, 0xc81f,	0x317f, 0xc81f,		0x21, 0
	.dw 0x31c0, 0xc81f,	0x31ff, 0xc81f,		0x21, 0
	.dw 0x3240, 0xc81f,	0x327f, 0xc81f,		0x21, 0
	.dw 0x32c0, 0xc81f,	0x32ff, 0xc81f,		0x21, 0
	.dw 0x3340, 0xc81f,	0x337f, 0xc81f,		0x21, 0
	.dw 0x33c0, 0xc81f,	0x33ff, 0xc81f,		0x21, 0
	.dw 0x3440, 0xc81f,	0x347f, 0xc81f,		0x21, 0
	.dw 0x34c0, 0xc81f,	0x34ff, 0xc81f,		0x21, 0
	.dw 0x3540, 0xc81f,	0x357f, 0xc81f,		0x21, 0
	.dw 0x35c0, 0xc81f,	0x35ff, 0xc81f,		0x21, 0
	.dw 0x3640, 0xc81f,	0x367f, 0xc81f,		0x21, 0
	.dw 0x36c0, 0xc81f,	0x36ff, 0xc81f,		0x21, 0
	.dw 0x3740, 0xc81f,	0x377f, 0xc81f,		0x21, 0
	.dw 0x37c0, 0xc81f,	0x37ff, 0xc81f,		0x21, 0
	.dw 0x3840, 0xc81f,	0x387f, 0xc81f,		0x21, 0
	.dw 0x38c0, 0xc81f,	0x38ff, 0xc81f,		0x21, 0
	.dw 0x3940, 0xc81f,	0x397f, 0xc81f,		0x21, 0
	.dw 0x39c0, 0xc81f,	0x1fff, 0xc820,		0x21, 0
	.dw 0x3a00, 0xc820,	0x5fff, 0xc820,		0x21, 0
	.dw 0x7a00, 0xc820,	0x9fff, 0xc820,		0x21, 0
	.dw 0xba00, 0xc820,	0xdfff, 0xc820,		0x21, 0
	.dw 0xfa00, 0xc820,	0x1fff, 0xc821,		0x21, 0
	.dw 0x3a00, 0xc821,	0x5fff, 0xc821,		0x21, 0
	.dw 0x7a00, 0xc821,	0x9fff, 0xc821,		0x21, 0
	.dw 0xba00, 0xc821,	0xdfff, 0xc821,		0x21, 0
	.dw 0xfa00, 0xc821,	0x1fff, 0xc822,		0x21, 0
	.dw 0x3a00, 0xc822,	0x5fff, 0xc822,		0x21, 0
	.dw 0x7a00, 0xc822,	0x9fff, 0xc822,		0x21, 0
	.dw 0xba00, 0xc822,	0xdfff, 0xc822,		0x21, 0
	.dw 0xfa00, 0xc822,	0x1fff, 0xc823,		0x21, 0
	.dw 0x3a00, 0xc823,	0xffff, 0xc823,		0x21, 0
	.dw 0x1a00, 0xc824,	0x1fff, 0xc824,		0x21, 0
	.dw 0x3a00, 0xc824,	0x3fff, 0xc824,		0x21, 0
	.dw 0x5a00, 0xc824,	0x5fff, 0xc824,		0x21, 0
	.dw 0x7a00, 0xc824,	0x7fff, 0xc824,		0x21, 0
	.dw 0x9a00, 0xc824,	0x9fff, 0xc824,		0x21, 0
	.dw 0xba00, 0xc824,	0xbfff, 0xc824,		0x21, 0
	.dw 0xda00, 0xc824,	0xdfff, 0xc824,		0x21, 0
	.dw 0xfa00, 0xc824,	0xffff, 0xc824,		0x21, 0
	.dw 0x1a00, 0xc825,	0x1fff, 0xc825,		0x21, 0
	.dw 0x3a00, 0xc825,	0x3fff, 0xc825,		0x21, 0
	.dw 0x5a00, 0xc825,	0x5fff, 0xc825,		0x21, 0
	.dw 0x7a00, 0xc825,	0x7fff, 0xc825,		0x21, 0
	.dw 0x9a00, 0xc825,	0x9fff, 0xc825,		0x21, 0
	.dw 0xba00, 0xc825,	0xbfff, 0xc825,		0x21, 0
	.dw 0xda00, 0xc825,	0xdfff, 0xc825,		0x21, 0
	.dw 0xfa00, 0xc825,	0xffff, 0xc825,		0x21, 0
	.dw 0x1a00, 0xc826,	0x1fff, 0xc826,		0x21, 0
	.dw 0x3a00, 0xc826,	0x3fff, 0xc826,		0x21, 0
	.dw 0x5a00, 0xc826,	0x5fff, 0xc826,		0x21, 0
	.dw 0x7a00, 0xc826,	0x7fff, 0xc826,		0x21, 0
	.dw 0x9a00, 0xc826,	0x9fff, 0xc826,		0x21, 0
	.dw 0xba00, 0xc826,	0xbfff, 0xc826,		0x21, 0
	.dw 0xda00, 0xc826,	0xdfff, 0xc826,		0x21, 0
	.dw 0xfa00, 0xc826,	0xffff, 0xc826,		0x21, 0
	.dw 0x1a00, 0xc827,	0x1fff, 0xc827,		0x21, 0
	.dw 0x3a00, 0xc827,	0x1fff, 0xc828,		0x21, 0
	.dw 0x2040, 0xc828,	0x207f, 0xc828,		0x21, 0
	.dw 0x20c0, 0xc828,	0x20ff, 0xc828,		0x21, 0
	.dw 0x2140, 0xc828,	0x217f, 0xc828,		0x21, 0
	.dw 0x21c0, 0xc828,	0x21ff, 0xc828,		0x21, 0
	.dw 0x2240, 0xc828,	0x227f, 0xc828,		0x21, 0
	.dw 0x22c0, 0xc828,	0x22ff, 0xc828,		0x21, 0
	.dw 0x2340, 0xc828,	0x237f, 0xc828,		0x21, 0
	.dw 0x23c0, 0xc828,	0x23ff, 0xc828,		0x21, 0
	.dw 0x2440, 0xc828,	0x247f, 0xc828,		0x21, 0
	.dw 0x24c0, 0xc828,	0x24ff, 0xc828,		0x21, 0
	.dw 0x2540, 0xc828,	0x257f, 0xc828,		0x21, 0
	.dw 0x25c0, 0xc828,	0x25ff, 0xc828,		0x21, 0
	.dw 0x2640, 0xc828,	0x267f, 0xc828,		0x21, 0
	.dw 0x26c0, 0xc828,	0x26ff, 0xc828,		0x21, 0
	.dw 0x2740, 0xc828,	0x277f, 0xc828,		0x21, 0
	.dw 0x27c0, 0xc828,	0x27ff, 0xc828,		0x21, 0
	.dw 0x2840, 0xc828,	0x287f, 0xc828,		0x21, 0
	.dw 0x28c0, 0xc828,	0x28ff, 0xc828,		0x21, 0
	.dw 0x2940, 0xc828,	0x297f, 0xc828,		0x21, 0
	.dw 0x29c0, 0xc828,	0x29ff, 0xc828,		0x21, 0
	.dw 0x2a40, 0xc828,	0x2a7f, 0xc828,		0x21, 0
	.dw 0x2ac0, 0xc828,	0x2aff, 0xc828,		0x21, 0
	.dw 0x2b40, 0xc828,	0x2b7f, 0xc828,		0x21, 0
	.dw 0x2bc0, 0xc828,	0x2bff, 0xc828,		0x21, 0
	.dw 0x2c40, 0xc828,	0x2c7f, 0xc828,		0x21, 0
	.dw 0x2cc0, 0xc828,	0x2cff, 0xc828,		0x21, 0
	.dw 0x2d40, 0xc828,	0x2d7f, 0xc828,		0x21, 0
	.dw 0x2dc0, 0xc828,	0x2dff, 0xc828,		0x21, 0
	.dw 0x2e40, 0xc828,	0x2e7f, 0xc828,		0x21, 0
	.dw 0x2ec0, 0xc828,	0x2eff, 0xc828,		0x21, 0
	.dw 0x2f40, 0xc828,	0x2f7f, 0xc828,		0x21, 0
	.dw 0x2fc0, 0xc828,	0x2fff, 0xc828,		0x21, 0
	.dw 0x3040, 0xc828,	0x307f, 0xc828,		0x21, 0
	.dw 0x30c0, 0xc828,	0x30ff, 0xc828,		0x21, 0
	.dw 0x3140, 0xc828,	0x317f, 0xc828,		0x21, 0
	.dw 0x31c0, 0xc828,	0x31ff, 0xc828,		0x21, 0
	.dw 0x3240, 0xc828,	0x327f, 0xc828,		0x21, 0
	.dw 0x32c0, 0xc828,	0x32ff, 0xc828,		0x21, 0
	.dw 0x3340, 0xc828,	0x337f, 0xc828,		0x21, 0
	.dw 0x33c0, 0xc828,	0x33ff, 0xc828,		0x21, 0
	.dw 0x3440, 0xc828,	0x347f, 0xc828,		0x21, 0
	.dw 0x34c0, 0xc828,	0x34ff, 0xc828,		0x21, 0
	.dw 0x3540, 0xc828,	0x357f, 0xc828,		0x21, 0
	.dw 0x35c0, 0xc828,	0x35ff, 0xc828,		0x21, 0
	.dw 0x3640, 0xc828,	0x367f, 0xc828,		0x21, 0
	.dw 0x36c0, 0xc828,	0x36ff, 0xc828,		0x21, 0
	.dw 0x3740, 0xc828,	0x377f, 0xc828,		0x21, 0
	.dw 0x37c0, 0xc828,	0x37ff, 0xc828,		0x21, 0
	.dw 0x3840, 0xc828,	0x387f, 0xc828,		0x21, 0
	.dw 0x38c0, 0xc828,	0x38ff, 0xc828,		0x21, 0
	.dw 0x3940, 0xc828,	0x397f, 0xc828,		0x21, 0
	.dw 0x39c0, 0xc828,	0x5fff, 0xc828,		0x21, 0
	.dw 0x6040, 0xc828,	0x607f, 0xc828,		0x21, 0
	.dw 0x60c0, 0xc828,	0x60ff, 0xc828,		0x21, 0
	.dw 0x6140, 0xc828,	0x617f, 0xc828,		0x21, 0
	.dw 0x61c0, 0xc828,	0x61ff, 0xc828,		0x21, 0
	.dw 0x6240, 0xc828,	0x627f, 0xc828,		0x21, 0
	.dw 0x62c0, 0xc828,	0x62ff, 0xc828,		0x21, 0
	.dw 0x6340, 0xc828,	0x637f, 0xc828,		0x21, 0
	.dw 0x63c0, 0xc828,	0x63ff, 0xc828,		0x21, 0
	.dw 0x6440, 0xc828,	0x647f, 0xc828,		0x21, 0
	.dw 0x64c0, 0xc828,	0x64ff, 0xc828,		0x21, 0
	.dw 0x6540, 0xc828,	0x657f, 0xc828,		0x21, 0
	.dw 0x65c0, 0xc828,	0x65ff, 0xc828,		0x21, 0
	.dw 0x6640, 0xc828,	0x667f, 0xc828,		0x21, 0
	.dw 0x66c0, 0xc828,	0x66ff, 0xc828,		0x21, 0
	.dw 0x6740, 0xc828,	0x677f, 0xc828,		0x21, 0
	.dw 0x67c0, 0xc828,	0x67ff, 0xc828,		0x21, 0
	.dw 0x6840, 0xc828,	0x687f, 0xc828,		0x21, 0
	.dw 0x68c0, 0xc828,	0x68ff, 0xc828,		0x21, 0
	.dw 0x6940, 0xc828,	0x697f, 0xc828,		0x21, 0
	.dw 0x69c0, 0xc828,	0x69ff, 0xc828,		0x21, 0
	.dw 0x6a40, 0xc828,	0x6a7f, 0xc828,		0x21, 0
	.dw 0x6ac0, 0xc828,	0x6aff, 0xc828,		0x21, 0
	.dw 0x6b40, 0xc828,	0x6b7f, 0xc828,		0x21, 0
	.dw 0x6bc0, 0xc828,	0x6bff, 0xc828,		0x21, 0
	.dw 0x6c40, 0xc828,	0x6c7f, 0xc828,		0x21, 0
	.dw 0x6cc0, 0xc828,	0x6cff, 0xc828,		0x21, 0
	.dw 0x6d40, 0xc828,	0x6d7f, 0xc828,		0x21, 0
	.dw 0x6dc0, 0xc828,	0x6dff, 0xc828,		0x21, 0
	.dw 0x6e40, 0xc828,	0x6e7f, 0xc828,		0x21, 0
	.dw 0x6ec0, 0xc828,	0x6eff, 0xc828,		0x21, 0
	.dw 0x6f40, 0xc828,	0x6f7f, 0xc828,		0x21, 0
	.dw 0x6fc0, 0xc828,	0x6fff, 0xc828,		0x21, 0
	.dw 0x7040, 0xc828,	0x707f, 0xc828,		0x21, 0
	.dw 0x70c0, 0xc828,	0x70ff, 0xc828,		0x21, 0
	.dw 0x7140, 0xc828,	0x717f, 0xc828,		0x21, 0
	.dw 0x71c0, 0xc828,	0x71ff, 0xc828,		0x21, 0
	.dw 0x7240, 0xc828,	0x727f, 0xc828,		0x21, 0
	.dw 0x72c0, 0xc828,	0x72ff, 0xc828,		0x21, 0
	.dw 0x7340, 0xc828,	0x737f, 0xc828,		0x21, 0
	.dw 0x73c0, 0xc828,	0x73ff, 0xc828,		0x21, 0
	.dw 0x7440, 0xc828,	0x747f, 0xc828,		0x21, 0
	.dw 0x74c0, 0xc828,	0x74ff, 0xc828,		0x21, 0
	.dw 0x7540, 0xc828,	0x757f, 0xc828,		0x21, 0
	.dw 0x75c0, 0xc828,	0x75ff, 0xc828,		0x21, 0
	.dw 0x7640, 0xc828,	0x767f, 0xc828,		0x21, 0
	.dw 0x76c0, 0xc828,	0x76ff, 0xc828,		0x21, 0
	.dw 0x7740, 0xc828,	0x777f, 0xc828,		0x21, 0
	.dw 0x77c0, 0xc828,	0x77ff, 0xc828,		0x21, 0
	.dw 0x7840, 0xc828,	0x787f, 0xc828,		0x21, 0
	.dw 0x78c0, 0xc828,	0x78ff, 0xc828,		0x21, 0
	.dw 0x7940, 0xc828,	0x797f, 0xc828,		0x21, 0
	.dw 0x79c0, 0xc828,	0x9fff, 0xc828,		0x21, 0
	.dw 0xa040, 0xc828,	0xa07f, 0xc828,		0x21, 0
	.dw 0xa0c0, 0xc828,	0xa0ff, 0xc828,		0x21, 0
	.dw 0xa140, 0xc828,	0xa17f, 0xc828,		0x21, 0
	.dw 0xa1c0, 0xc828,	0xa1ff, 0xc828,		0x21, 0
	.dw 0xa240, 0xc828,	0xa27f, 0xc828,		0x21, 0
	.dw 0xa2c0, 0xc828,	0xa2ff, 0xc828,		0x21, 0
	.dw 0xa340, 0xc828,	0xa37f, 0xc828,		0x21, 0
	.dw 0xa3c0, 0xc828,	0xa3ff, 0xc828,		0x21, 0
	.dw 0xa440, 0xc828,	0xa47f, 0xc828,		0x21, 0
	.dw 0xa4c0, 0xc828,	0xa4ff, 0xc828,		0x21, 0
	.dw 0xa540, 0xc828,	0xa57f, 0xc828,		0x21, 0
	.dw 0xa5c0, 0xc828,	0xa5ff, 0xc828,		0x21, 0
	.dw 0xa640, 0xc828,	0xa67f, 0xc828,		0x21, 0
	.dw 0xa6c0, 0xc828,	0xa6ff, 0xc828,		0x21, 0
	.dw 0xa740, 0xc828,	0xa77f, 0xc828,		0x21, 0
	.dw 0xa7c0, 0xc828,	0xa7ff, 0xc828,		0x21, 0
	.dw 0xa840, 0xc828,	0xa87f, 0xc828,		0x21, 0
	.dw 0xa8c0, 0xc828,	0xa8ff, 0xc828,		0x21, 0
	.dw 0xa940, 0xc828,	0xa97f, 0xc828,		0x21, 0
	.dw 0xa9c0, 0xc828,	0xa9ff, 0xc828,		0x21, 0
	.dw 0xaa40, 0xc828,	0xaa7f, 0xc828,		0x21, 0
	.dw 0xaac0, 0xc828,	0xaaff, 0xc828,		0x21, 0
	.dw 0xab40, 0xc828,	0xab7f, 0xc828,		0x21, 0
	.dw 0xabc0, 0xc828,	0xabff, 0xc828,		0x21, 0
	.dw 0xac40, 0xc828,	0xac7f, 0xc828,		0x21, 0
	.dw 0xacc0, 0xc828,	0xacff, 0xc828,		0x21, 0
	.dw 0xad40, 0xc828,	0xad7f, 0xc828,		0x21, 0
	.dw 0xadc0, 0xc828,	0xadff, 0xc828,		0x21, 0
	.dw 0xae40, 0xc828,	0xae7f, 0xc828,		0x21, 0
	.dw 0xaec0, 0xc828,	0xaeff, 0xc828,		0x21, 0
	.dw 0xaf40, 0xc828,	0xaf7f, 0xc828,		0x21, 0
	.dw 0xafc0, 0xc828,	0xafff, 0xc828,		0x21, 0
	.dw 0xb040, 0xc828,	0xb07f, 0xc828,		0x21, 0
	.dw 0xb0c0, 0xc828,	0xb0ff, 0xc828,		0x21, 0
	.dw 0xb140, 0xc828,	0xb17f, 0xc828,		0x21, 0
	.dw 0xb1c0, 0xc828,	0xb1ff, 0xc828,		0x21, 0
	.dw 0xb240, 0xc828,	0xb27f, 0xc828,		0x21, 0
	.dw 0xb2c0, 0xc828,	0xb2ff, 0xc828,		0x21, 0
	.dw 0xb340, 0xc828,	0xb37f, 0xc828,		0x21, 0
	.dw 0xb3c0, 0xc828,	0xb3ff, 0xc828,		0x21, 0
	.dw 0xb440, 0xc828,	0xb47f, 0xc828,		0x21, 0
	.dw 0xb4c0, 0xc828,	0xb4ff, 0xc828,		0x21, 0
	.dw 0xb540, 0xc828,	0xb57f, 0xc828,		0x21, 0
	.dw 0xb5c0, 0xc828,	0xb5ff, 0xc828,		0x21, 0
	.dw 0xb640, 0xc828,	0xb67f, 0xc828,		0x21, 0
	.dw 0xb6c0, 0xc828,	0xb6ff, 0xc828,		0x21, 0
	.dw 0xb740, 0xc828,	0xb77f, 0xc828,		0x21, 0
	.dw 0xb7c0, 0xc828,	0xb7ff, 0xc828,		0x21, 0
	.dw 0xb840, 0xc828,	0xb87f, 0xc828,		0x21, 0
	.dw 0xb8c0, 0xc828,	0xb8ff, 0xc828,		0x21, 0
	.dw 0xb940, 0xc828,	0xb97f, 0xc828,		0x21, 0
	.dw 0xb9c0, 0xc828,	0xdfff, 0xc828,		0x21, 0
	.dw 0xe040, 0xc828,	0xe07f, 0xc828,		0x21, 0
	.dw 0xe0c0, 0xc828,	0xe0ff, 0xc828,		0x21, 0
	.dw 0xe140, 0xc828,	0xe17f, 0xc828,		0x21, 0
	.dw 0xe1c0, 0xc828,	0xe1ff, 0xc828,		0x21, 0
	.dw 0xe240, 0xc828,	0xe27f, 0xc828,		0x21, 0
	.dw 0xe2c0, 0xc828,	0xe2ff, 0xc828,		0x21, 0
	.dw 0xe340, 0xc828,	0xe37f, 0xc828,		0x21, 0
	.dw 0xe3c0, 0xc828,	0xe3ff, 0xc828,		0x21, 0
	.dw 0xe440, 0xc828,	0xe47f, 0xc828,		0x21, 0
	.dw 0xe4c0, 0xc828,	0xe4ff, 0xc828,		0x21, 0
	.dw 0xe540, 0xc828,	0xe57f, 0xc828,		0x21, 0
	.dw 0xe5c0, 0xc828,	0xe5ff, 0xc828,		0x21, 0
	.dw 0xe640, 0xc828,	0xe67f, 0xc828,		0x21, 0
	.dw 0xe6c0, 0xc828,	0xe6ff, 0xc828,		0x21, 0
	.dw 0xe740, 0xc828,	0xe77f, 0xc828,		0x21, 0
	.dw 0xe7c0, 0xc828,	0xe7ff, 0xc828,		0x21, 0
	.dw 0xe840, 0xc828,	0xe87f, 0xc828,		0x21, 0
	.dw 0xe8c0, 0xc828,	0xe8ff, 0xc828,		0x21, 0
	.dw 0xe940, 0xc828,	0xe97f, 0xc828,		0x21, 0
	.dw 0xe9c0, 0xc828,	0xe9ff, 0xc828,		0x21, 0
	.dw 0xea40, 0xc828,	0xea7f, 0xc828,		0x21, 0
	.dw 0xeac0, 0xc828,	0xeaff, 0xc828,		0x21, 0
	.dw 0xeb40, 0xc828,	0xeb7f, 0xc828,		0x21, 0
	.dw 0xebc0, 0xc828,	0xebff, 0xc828,		0x21, 0
	.dw 0xec40, 0xc828,	0xec7f, 0xc828,		0x21, 0
	.dw 0xecc0, 0xc828,	0xecff, 0xc828,		0x21, 0
	.dw 0xed40, 0xc828,	0xed7f, 0xc828,		0x21, 0
	.dw 0xedc0, 0xc828,	0xedff, 0xc828,		0x21, 0
	.dw 0xee40, 0xc828,	0xee7f, 0xc828,		0x21, 0
	.dw 0xeec0, 0xc828,	0xeeff, 0xc828,		0x21, 0
	.dw 0xef40, 0xc828,	0xef7f, 0xc828,		0x21, 0
	.dw 0xefc0, 0xc828,	0xefff, 0xc828,		0x21, 0
	.dw 0xf040, 0xc828,	0xf07f, 0xc828,		0x21, 0
	.dw 0xf0c0, 0xc828,	0xf0ff, 0xc828,		0x21, 0
	.dw 0xf140, 0xc828,	0xf17f, 0xc828,		0x21, 0
	.dw 0xf1c0, 0xc828,	0xf1ff, 0xc828,		0x21, 0
	.dw 0xf240, 0xc828,	0xf27f, 0xc828,		0x21, 0
	.dw 0xf2c0, 0xc828,	0xf2ff, 0xc828,		0x21, 0
	.dw 0xf340, 0xc828,	0xf37f, 0xc828,		0x21, 0
	.dw 0xf3c0, 0xc828,	0xf3ff, 0xc828,		0x21, 0
	.dw 0xf440, 0xc828,	0xf47f, 0xc828,		0x21, 0
	.dw 0xf4c0, 0xc828,	0xf4ff, 0xc828,		0x21, 0
	.dw 0xf540, 0xc828,	0xf57f, 0xc828,		0x21, 0
	.dw 0xf5c0, 0xc828,	0xf5ff, 0xc828,		0x21, 0
	.dw 0xf640, 0xc828,	0xf67f, 0xc828,		0x21, 0
	.dw 0xf6c0, 0xc828,	0xf6ff, 0xc828,		0x21, 0
	.dw 0xf740, 0xc828,	0xf77f, 0xc828,		0x21, 0
	.dw 0xf7c0, 0xc828,	0xf7ff, 0xc828,		0x21, 0
	.dw 0xf840, 0xc828,	0xf87f, 0xc828,		0x21, 0
	.dw 0xf8c0, 0xc828,	0xf8ff, 0xc828,		0x21, 0
	.dw 0xf940, 0xc828,	0xf97f, 0xc828,		0x21, 0
	.dw 0xf9c0, 0xc828,	0x1fff, 0xc829,		0x21, 0
	.dw 0x2040, 0xc829,	0x207f, 0xc829,		0x21, 0
	.dw 0x20c0, 0xc829,	0x20ff, 0xc829,		0x21, 0
	.dw 0x2140, 0xc829,	0x217f, 0xc829,		0x21, 0
	.dw 0x21c0, 0xc829,	0x21ff, 0xc829,		0x21, 0
	.dw 0x2240, 0xc829,	0x227f, 0xc829,		0x21, 0
	.dw 0x22c0, 0xc829,	0x22ff, 0xc829,		0x21, 0
	.dw 0x2340, 0xc829,	0x237f, 0xc829,		0x21, 0
	.dw 0x23c0, 0xc829,	0x23ff, 0xc829,		0x21, 0
	.dw 0x2440, 0xc829,	0x247f, 0xc829,		0x21, 0
	.dw 0x24c0, 0xc829,	0x24ff, 0xc829,		0x21, 0
	.dw 0x2540, 0xc829,	0x257f, 0xc829,		0x21, 0
	.dw 0x25c0, 0xc829,	0x25ff, 0xc829,		0x21, 0
	.dw 0x2640, 0xc829,	0x267f, 0xc829,		0x21, 0
	.dw 0x26c0, 0xc829,	0x26ff, 0xc829,		0x21, 0
	.dw 0x2740, 0xc829,	0x277f, 0xc829,		0x21, 0
	.dw 0x27c0, 0xc829,	0x27ff, 0xc829,		0x21, 0
	.dw 0x2840, 0xc829,	0x287f, 0xc829,		0x21, 0
	.dw 0x28c0, 0xc829,	0x28ff, 0xc829,		0x21, 0
	.dw 0x2940, 0xc829,	0x297f, 0xc829,		0x21, 0
	.dw 0x29c0, 0xc829,	0x29ff, 0xc829,		0x21, 0
	.dw 0x2a40, 0xc829,	0x2a7f, 0xc829,		0x21, 0
	.dw 0x2ac0, 0xc829,	0x2aff, 0xc829,		0x21, 0
	.dw 0x2b40, 0xc829,	0x2b7f, 0xc829,		0x21, 0
	.dw 0x2bc0, 0xc829,	0x2bff, 0xc829,		0x21, 0
	.dw 0x2c40, 0xc829,	0x2c7f, 0xc829,		0x21, 0
	.dw 0x2cc0, 0xc829,	0x2cff, 0xc829,		0x21, 0
	.dw 0x2d40, 0xc829,	0x2d7f, 0xc829,		0x21, 0
	.dw 0x2dc0, 0xc829,	0x2dff, 0xc829,		0x21, 0
	.dw 0x2e40, 0xc829,	0x2e7f, 0xc829,		0x21, 0
	.dw 0x2ec0, 0xc829,	0x2eff, 0xc829,		0x21, 0
	.dw 0x2f40, 0xc829,	0x2f7f, 0xc829,		0x21, 0
	.dw 0x2fc0, 0xc829,	0x2fff, 0xc829,		0x21, 0
	.dw 0x3040, 0xc829,	0x307f, 0xc829,		0x21, 0
	.dw 0x30c0, 0xc829,	0x30ff, 0xc829,		0x21, 0
	.dw 0x3140, 0xc829,	0x317f, 0xc829,		0x21, 0
	.dw 0x31c0, 0xc829,	0x31ff, 0xc829,		0x21, 0
	.dw 0x3240, 0xc829,	0x327f, 0xc829,		0x21, 0
	.dw 0x32c0, 0xc829,	0x32ff, 0xc829,		0x21, 0
	.dw 0x3340, 0xc829,	0x337f, 0xc829,		0x21, 0
	.dw 0x33c0, 0xc829,	0x33ff, 0xc829,		0x21, 0
	.dw 0x3440, 0xc829,	0x347f, 0xc829,		0x21, 0
	.dw 0x34c0, 0xc829,	0x34ff, 0xc829,		0x21, 0
	.dw 0x3540, 0xc829,	0x357f, 0xc829,		0x21, 0
	.dw 0x35c0, 0xc829,	0x35ff, 0xc829,		0x21, 0
	.dw 0x3640, 0xc829,	0x367f, 0xc829,		0x21, 0
	.dw 0x36c0, 0xc829,	0x36ff, 0xc829,		0x21, 0
	.dw 0x3740, 0xc829,	0x377f, 0xc829,		0x21, 0
	.dw 0x37c0, 0xc829,	0x37ff, 0xc829,		0x21, 0
	.dw 0x3840, 0xc829,	0x387f, 0xc829,		0x21, 0
	.dw 0x38c0, 0xc829,	0x38ff, 0xc829,		0x21, 0
	.dw 0x3940, 0xc829,	0x397f, 0xc829,		0x21, 0
	.dw 0x39c0, 0xc829,	0x5fff, 0xc829,		0x21, 0
	.dw 0x6040, 0xc829,	0x607f, 0xc829,		0x21, 0
	.dw 0x60c0, 0xc829,	0x60ff, 0xc829,		0x21, 0
	.dw 0x6140, 0xc829,	0x617f, 0xc829,		0x21, 0
	.dw 0x61c0, 0xc829,	0x61ff, 0xc829,		0x21, 0
	.dw 0x6240, 0xc829,	0x627f, 0xc829,		0x21, 0
	.dw 0x62c0, 0xc829,	0x62ff, 0xc829,		0x21, 0
	.dw 0x6340, 0xc829,	0x637f, 0xc829,		0x21, 0
	.dw 0x63c0, 0xc829,	0x63ff, 0xc829,		0x21, 0
	.dw 0x6440, 0xc829,	0x647f, 0xc829,		0x21, 0
	.dw 0x64c0, 0xc829,	0x64ff, 0xc829,		0x21, 0
	.dw 0x6540, 0xc829,	0x657f, 0xc829,		0x21, 0
	.dw 0x65c0, 0xc829,	0x65ff, 0xc829,		0x21, 0
	.dw 0x6640, 0xc829,	0x667f, 0xc829,		0x21, 0
	.dw 0x66c0, 0xc829,	0x66ff, 0xc829,		0x21, 0
	.dw 0x6740, 0xc829,	0x677f, 0xc829,		0x21, 0
	.dw 0x67c0, 0xc829,	0x67ff, 0xc829,		0x21, 0
	.dw 0x6840, 0xc829,	0x687f, 0xc829,		0x21, 0
	.dw 0x68c0, 0xc829,	0x68ff, 0xc829,		0x21, 0
	.dw 0x6940, 0xc829,	0x697f, 0xc829,		0x21, 0
	.dw 0x69c0, 0xc829,	0x69ff, 0xc829,		0x21, 0
	.dw 0x6a40, 0xc829,	0x6a7f, 0xc829,		0x21, 0
	.dw 0x6ac0, 0xc829,	0x6aff, 0xc829,		0x21, 0
	.dw 0x6b40, 0xc829,	0x6b7f, 0xc829,		0x21, 0
	.dw 0x6bc0, 0xc829,	0x6bff, 0xc829,		0x21, 0
	.dw 0x6c40, 0xc829,	0x6c7f, 0xc829,		0x21, 0
	.dw 0x6cc0, 0xc829,	0x6cff, 0xc829,		0x21, 0
	.dw 0x6d40, 0xc829,	0x6d7f, 0xc829,		0x21, 0
	.dw 0x6dc0, 0xc829,	0x6dff, 0xc829,		0x21, 0
	.dw 0x6e40, 0xc829,	0x6e7f, 0xc829,		0x21, 0
	.dw 0x6ec0, 0xc829,	0x6eff, 0xc829,		0x21, 0
	.dw 0x6f40, 0xc829,	0x6f7f, 0xc829,		0x21, 0
	.dw 0x6fc0, 0xc829,	0x6fff, 0xc829,		0x21, 0
	.dw 0x7040, 0xc829,	0x707f, 0xc829,		0x21, 0
	.dw 0x70c0, 0xc829,	0x70ff, 0xc829,		0x21, 0
	.dw 0x7140, 0xc829,	0x717f, 0xc829,		0x21, 0
	.dw 0x71c0, 0xc829,	0x71ff, 0xc829,		0x21, 0
	.dw 0x7240, 0xc829,	0x727f, 0xc829,		0x21, 0
	.dw 0x72c0, 0xc829,	0x72ff, 0xc829,		0x21, 0
	.dw 0x7340, 0xc829,	0x737f, 0xc829,		0x21, 0
	.dw 0x73c0, 0xc829,	0x73ff, 0xc829,		0x21, 0
	.dw 0x7440, 0xc829,	0x747f, 0xc829,		0x21, 0
	.dw 0x74c0, 0xc829,	0x74ff, 0xc829,		0x21, 0
	.dw 0x7540, 0xc829,	0x757f, 0xc829,		0x21, 0
	.dw 0x75c0, 0xc829,	0x75ff, 0xc829,		0x21, 0
	.dw 0x7640, 0xc829,	0x767f, 0xc829,		0x21, 0
	.dw 0x76c0, 0xc829,	0x76ff, 0xc829,		0x21, 0
	.dw 0x7740, 0xc829,	0x777f, 0xc829,		0x21, 0
	.dw 0x77c0, 0xc829,	0x77ff, 0xc829,		0x21, 0
	.dw 0x7840, 0xc829,	0x787f, 0xc829,		0x21, 0
	.dw 0x78c0, 0xc829,	0x78ff, 0xc829,		0x21, 0
	.dw 0x7940, 0xc829,	0x797f, 0xc829,		0x21, 0
	.dw 0x79c0, 0xc829,	0x9fff, 0xc829,		0x21, 0
	.dw 0xa040, 0xc829,	0xa07f, 0xc829,		0x21, 0
	.dw 0xa0c0, 0xc829,	0xa0ff, 0xc829,		0x21, 0
	.dw 0xa140, 0xc829,	0xa17f, 0xc829,		0x21, 0
	.dw 0xa1c0, 0xc829,	0xa1ff, 0xc829,		0x21, 0
	.dw 0xa240, 0xc829,	0xa27f, 0xc829,		0x21, 0
	.dw 0xa2c0, 0xc829,	0xa2ff, 0xc829,		0x21, 0
	.dw 0xa340, 0xc829,	0xa37f, 0xc829,		0x21, 0
	.dw 0xa3c0, 0xc829,	0xa3ff, 0xc829,		0x21, 0
	.dw 0xa440, 0xc829,	0xa47f, 0xc829,		0x21, 0
	.dw 0xa4c0, 0xc829,	0xa4ff, 0xc829,		0x21, 0
	.dw 0xa540, 0xc829,	0xa57f, 0xc829,		0x21, 0
	.dw 0xa5c0, 0xc829,	0xa5ff, 0xc829,		0x21, 0
	.dw 0xa640, 0xc829,	0xa67f, 0xc829,		0x21, 0
	.dw 0xa6c0, 0xc829,	0xa6ff, 0xc829,		0x21, 0
	.dw 0xa740, 0xc829,	0xa77f, 0xc829,		0x21, 0
	.dw 0xa7c0, 0xc829,	0xa7ff, 0xc829,		0x21, 0
	.dw 0xa840, 0xc829,	0xa87f, 0xc829,		0x21, 0
	.dw 0xa8c0, 0xc829,	0xa8ff, 0xc829,		0x21, 0
	.dw 0xa940, 0xc829,	0xa97f, 0xc829,		0x21, 0
	.dw 0xa9c0, 0xc829,	0xa9ff, 0xc829,		0x21, 0
	.dw 0xaa40, 0xc829,	0xaa7f, 0xc829,		0x21, 0
	.dw 0xaac0, 0xc829,	0xaaff, 0xc829,		0x21, 0
	.dw 0xab40, 0xc829,	0xab7f, 0xc829,		0x21, 0
	.dw 0xabc0, 0xc829,	0xabff, 0xc829,		0x21, 0
	.dw 0xac40, 0xc829,	0xac7f, 0xc829,		0x21, 0
	.dw 0xacc0, 0xc829,	0xacff, 0xc829,		0x21, 0
	.dw 0xad40, 0xc829,	0xad7f, 0xc829,		0x21, 0
	.dw 0xadc0, 0xc829,	0xadff, 0xc829,		0x21, 0
	.dw 0xae40, 0xc829,	0xae7f, 0xc829,		0x21, 0
	.dw 0xaec0, 0xc829,	0xaeff, 0xc829,		0x21, 0
	.dw 0xaf40, 0xc829,	0xaf7f, 0xc829,		0x21, 0
	.dw 0xafc0, 0xc829,	0xafff, 0xc829,		0x21, 0
	.dw 0xb040, 0xc829,	0xb07f, 0xc829,		0x21, 0
	.dw 0xb0c0, 0xc829,	0xb0ff, 0xc829,		0x21, 0
	.dw 0xb140, 0xc829,	0xb17f, 0xc829,		0x21, 0
	.dw 0xb1c0, 0xc829,	0xb1ff, 0xc829,		0x21, 0
	.dw 0xb240, 0xc829,	0xb27f, 0xc829,		0x21, 0
	.dw 0xb2c0, 0xc829,	0xb2ff, 0xc829,		0x21, 0
	.dw 0xb340, 0xc829,	0xb37f, 0xc829,		0x21, 0
	.dw 0xb3c0, 0xc829,	0xb3ff, 0xc829,		0x21, 0
	.dw 0xb440, 0xc829,	0xb47f, 0xc829,		0x21, 0
	.dw 0xb4c0, 0xc829,	0xb4ff, 0xc829,		0x21, 0
	.dw 0xb540, 0xc829,	0xb57f, 0xc829,		0x21, 0
	.dw 0xb5c0, 0xc829,	0xb5ff, 0xc829,		0x21, 0
	.dw 0xb640, 0xc829,	0xb67f, 0xc829,		0x21, 0
	.dw 0xb6c0, 0xc829,	0xb6ff, 0xc829,		0x21, 0
	.dw 0xb740, 0xc829,	0xb77f, 0xc829,		0x21, 0
	.dw 0xb7c0, 0xc829,	0xb7ff, 0xc829,		0x21, 0
	.dw 0xb840, 0xc829,	0xb87f, 0xc829,		0x21, 0
	.dw 0xb8c0, 0xc829,	0xb8ff, 0xc829,		0x21, 0
	.dw 0xb940, 0xc829,	0xb97f, 0xc829,		0x21, 0
	.dw 0xb9c0, 0xc829,	0xdfff, 0xc829,		0x21, 0
	.dw 0xe040, 0xc829,	0xe07f, 0xc829,		0x21, 0
	.dw 0xe0c0, 0xc829,	0xe0ff, 0xc829,		0x21, 0
	.dw 0xe140, 0xc829,	0xe17f, 0xc829,		0x21, 0
	.dw 0xe1c0, 0xc829,	0xe1ff, 0xc829,		0x21, 0
	.dw 0xe240, 0xc829,	0xe27f, 0xc829,		0x21, 0
	.dw 0xe2c0, 0xc829,	0xe2ff, 0xc829,		0x21, 0
	.dw 0xe340, 0xc829,	0xe37f, 0xc829,		0x21, 0
	.dw 0xe3c0, 0xc829,	0xe3ff, 0xc829,		0x21, 0
	.dw 0xe440, 0xc829,	0xe47f, 0xc829,		0x21, 0
	.dw 0xe4c0, 0xc829,	0xe4ff, 0xc829,		0x21, 0
	.dw 0xe540, 0xc829,	0xe57f, 0xc829,		0x21, 0
	.dw 0xe5c0, 0xc829,	0xe5ff, 0xc829,		0x21, 0
	.dw 0xe640, 0xc829,	0xe67f, 0xc829,		0x21, 0
	.dw 0xe6c0, 0xc829,	0xe6ff, 0xc829,		0x21, 0
	.dw 0xe740, 0xc829,	0xe77f, 0xc829,		0x21, 0
	.dw 0xe7c0, 0xc829,	0xe7ff, 0xc829,		0x21, 0
	.dw 0xe840, 0xc829,	0xe87f, 0xc829,		0x21, 0
	.dw 0xe8c0, 0xc829,	0xe8ff, 0xc829,		0x21, 0
	.dw 0xe940, 0xc829,	0xe97f, 0xc829,		0x21, 0
	.dw 0xe9c0, 0xc829,	0xe9ff, 0xc829,		0x21, 0
	.dw 0xea40, 0xc829,	0xea7f, 0xc829,		0x21, 0
	.dw 0xeac0, 0xc829,	0xeaff, 0xc829,		0x21, 0
	.dw 0xeb40, 0xc829,	0xeb7f, 0xc829,		0x21, 0
	.dw 0xebc0, 0xc829,	0xebff, 0xc829,		0x21, 0
	.dw 0xec40, 0xc829,	0xec7f, 0xc829,		0x21, 0
	.dw 0xecc0, 0xc829,	0xecff, 0xc829,		0x21, 0
	.dw 0xed40, 0xc829,	0xed7f, 0xc829,		0x21, 0
	.dw 0xedc0, 0xc829,	0xedff, 0xc829,		0x21, 0
	.dw 0xee40, 0xc829,	0xee7f, 0xc829,		0x21, 0
	.dw 0xeec0, 0xc829,	0xeeff, 0xc829,		0x21, 0
	.dw 0xef40, 0xc829,	0xef7f, 0xc829,		0x21, 0
	.dw 0xefc0, 0xc829,	0xefff, 0xc829,		0x21, 0
	.dw 0xf040, 0xc829,	0xf07f, 0xc829,		0x21, 0
	.dw 0xf0c0, 0xc829,	0xf0ff, 0xc829,		0x21, 0
	.dw 0xf140, 0xc829,	0xf17f, 0xc829,		0x21, 0
	.dw 0xf1c0, 0xc829,	0xf1ff, 0xc829,		0x21, 0
	.dw 0xf240, 0xc829,	0xf27f, 0xc829,		0x21, 0
	.dw 0xf2c0, 0xc829,	0xf2ff, 0xc829,		0x21, 0
	.dw 0xf340, 0xc829,	0xf37f, 0xc829,		0x21, 0
	.dw 0xf3c0, 0xc829,	0xf3ff, 0xc829,		0x21, 0
	.dw 0xf440, 0xc829,	0xf47f, 0xc829,		0x21, 0
	.dw 0xf4c0, 0xc829,	0xf4ff, 0xc829,		0x21, 0
	.dw 0xf540, 0xc829,	0xf57f, 0xc829,		0x21, 0
	.dw 0xf5c0, 0xc829,	0xf5ff, 0xc829,		0x21, 0
	.dw 0xf640, 0xc829,	0xf67f, 0xc829,		0x21, 0
	.dw 0xf6c0, 0xc829,	0xf6ff, 0xc829,		0x21, 0
	.dw 0xf740, 0xc829,	0xf77f, 0xc829,		0x21, 0
	.dw 0xf7c0, 0xc829,	0xf7ff, 0xc829,		0x21, 0
	.dw 0xf840, 0xc829,	0xf87f, 0xc829,		0x21, 0
	.dw 0xf8c0, 0xc829,	0xf8ff, 0xc829,		0x21, 0
	.dw 0xf940, 0xc829,	0xf97f, 0xc829,		0x21, 0
	.dw 0xf9c0, 0xc829,	0x1fff, 0xc82a,		0x21, 0
	.dw 0x2040, 0xc82a,	0x207f, 0xc82a,		0x21, 0
	.dw 0x20c0, 0xc82a,	0x20ff, 0xc82a,		0x21, 0
	.dw 0x2140, 0xc82a,	0x217f, 0xc82a,		0x21, 0
	.dw 0x21c0, 0xc82a,	0x21ff, 0xc82a,		0x21, 0
	.dw 0x2240, 0xc82a,	0x227f, 0xc82a,		0x21, 0
	.dw 0x22c0, 0xc82a,	0x22ff, 0xc82a,		0x21, 0
	.dw 0x2340, 0xc82a,	0x237f, 0xc82a,		0x21, 0
	.dw 0x23c0, 0xc82a,	0x23ff, 0xc82a,		0x21, 0
	.dw 0x2440, 0xc82a,	0x247f, 0xc82a,		0x21, 0
	.dw 0x24c0, 0xc82a,	0x24ff, 0xc82a,		0x21, 0
	.dw 0x2540, 0xc82a,	0x257f, 0xc82a,		0x21, 0
	.dw 0x25c0, 0xc82a,	0x25ff, 0xc82a,		0x21, 0
	.dw 0x2640, 0xc82a,	0x267f, 0xc82a,		0x21, 0
	.dw 0x26c0, 0xc82a,	0x26ff, 0xc82a,		0x21, 0
	.dw 0x2740, 0xc82a,	0x277f, 0xc82a,		0x21, 0
	.dw 0x27c0, 0xc82a,	0x27ff, 0xc82a,		0x21, 0
	.dw 0x2840, 0xc82a,	0x287f, 0xc82a,		0x21, 0
	.dw 0x28c0, 0xc82a,	0x28ff, 0xc82a,		0x21, 0
	.dw 0x2940, 0xc82a,	0x297f, 0xc82a,		0x21, 0
	.dw 0x29c0, 0xc82a,	0x29ff, 0xc82a,		0x21, 0
	.dw 0x2a40, 0xc82a,	0x2a7f, 0xc82a,		0x21, 0
	.dw 0x2ac0, 0xc82a,	0x2aff, 0xc82a,		0x21, 0
	.dw 0x2b40, 0xc82a,	0x2b7f, 0xc82a,		0x21, 0
	.dw 0x2bc0, 0xc82a,	0x2bff, 0xc82a,		0x21, 0
	.dw 0x2c40, 0xc82a,	0x2c7f, 0xc82a,		0x21, 0
	.dw 0x2cc0, 0xc82a,	0x2cff, 0xc82a,		0x21, 0
	.dw 0x2d40, 0xc82a,	0x2d7f, 0xc82a,		0x21, 0
	.dw 0x2dc0, 0xc82a,	0x2dff, 0xc82a,		0x21, 0
	.dw 0x2e40, 0xc82a,	0x2e7f, 0xc82a,		0x21, 0
	.dw 0x2ec0, 0xc82a,	0x2eff, 0xc82a,		0x21, 0
	.dw 0x2f40, 0xc82a,	0x2f7f, 0xc82a,		0x21, 0
	.dw 0x2fc0, 0xc82a,	0x2fff, 0xc82a,		0x21, 0
	.dw 0x3040, 0xc82a,	0x307f, 0xc82a,		0x21, 0
	.dw 0x30c0, 0xc82a,	0x30ff, 0xc82a,		0x21, 0
	.dw 0x3140, 0xc82a,	0x317f, 0xc82a,		0x21, 0
	.dw 0x31c0, 0xc82a,	0x31ff, 0xc82a,		0x21, 0
	.dw 0x3240, 0xc82a,	0x327f, 0xc82a,		0x21, 0
	.dw 0x32c0, 0xc82a,	0x32ff, 0xc82a,		0x21, 0
	.dw 0x3340, 0xc82a,	0x337f, 0xc82a,		0x21, 0
	.dw 0x33c0, 0xc82a,	0x33ff, 0xc82a,		0x21, 0
	.dw 0x3440, 0xc82a,	0x347f, 0xc82a,		0x21, 0
	.dw 0x34c0, 0xc82a,	0x34ff, 0xc82a,		0x21, 0
	.dw 0x3540, 0xc82a,	0x357f, 0xc82a,		0x21, 0
	.dw 0x35c0, 0xc82a,	0x35ff, 0xc82a,		0x21, 0
	.dw 0x3640, 0xc82a,	0x367f, 0xc82a,		0x21, 0
	.dw 0x36c0, 0xc82a,	0x36ff, 0xc82a,		0x21, 0
	.dw 0x3740, 0xc82a,	0x377f, 0xc82a,		0x21, 0
	.dw 0x37c0, 0xc82a,	0x37ff, 0xc82a,		0x21, 0
	.dw 0x3840, 0xc82a,	0x387f, 0xc82a,		0x21, 0
	.dw 0x38c0, 0xc82a,	0x38ff, 0xc82a,		0x21, 0
	.dw 0x3940, 0xc82a,	0x397f, 0xc82a,		0x21, 0
	.dw 0x39c0, 0xc82a,	0x5fff, 0xc82a,		0x21, 0
	.dw 0x6040, 0xc82a,	0x607f, 0xc82a,		0x21, 0
	.dw 0x60c0, 0xc82a,	0x60ff, 0xc82a,		0x21, 0
	.dw 0x6140, 0xc82a,	0x617f, 0xc82a,		0x21, 0
	.dw 0x61c0, 0xc82a,	0x61ff, 0xc82a,		0x21, 0
	.dw 0x6240, 0xc82a,	0x627f, 0xc82a,		0x21, 0
	.dw 0x62c0, 0xc82a,	0x62ff, 0xc82a,		0x21, 0
	.dw 0x6340, 0xc82a,	0x637f, 0xc82a,		0x21, 0
	.dw 0x63c0, 0xc82a,	0x63ff, 0xc82a,		0x21, 0
	.dw 0x6440, 0xc82a,	0x647f, 0xc82a,		0x21, 0
	.dw 0x64c0, 0xc82a,	0x64ff, 0xc82a,		0x21, 0
	.dw 0x6540, 0xc82a,	0x657f, 0xc82a,		0x21, 0
	.dw 0x65c0, 0xc82a,	0x65ff, 0xc82a,		0x21, 0
	.dw 0x6640, 0xc82a,	0x667f, 0xc82a,		0x21, 0
	.dw 0x66c0, 0xc82a,	0x66ff, 0xc82a,		0x21, 0
	.dw 0x6740, 0xc82a,	0x677f, 0xc82a,		0x21, 0
	.dw 0x67c0, 0xc82a,	0x67ff, 0xc82a,		0x21, 0
	.dw 0x6840, 0xc82a,	0x687f, 0xc82a,		0x21, 0
	.dw 0x68c0, 0xc82a,	0x68ff, 0xc82a,		0x21, 0
	.dw 0x6940, 0xc82a,	0x697f, 0xc82a,		0x21, 0
	.dw 0x69c0, 0xc82a,	0x69ff, 0xc82a,		0x21, 0
	.dw 0x6a40, 0xc82a,	0x6a7f, 0xc82a,		0x21, 0
	.dw 0x6ac0, 0xc82a,	0x6aff, 0xc82a,		0x21, 0
	.dw 0x6b40, 0xc82a,	0x6b7f, 0xc82a,		0x21, 0
	.dw 0x6bc0, 0xc82a,	0x6bff, 0xc82a,		0x21, 0
	.dw 0x6c40, 0xc82a,	0x6c7f, 0xc82a,		0x21, 0
	.dw 0x6cc0, 0xc82a,	0x6cff, 0xc82a,		0x21, 0
	.dw 0x6d40, 0xc82a,	0x6d7f, 0xc82a,		0x21, 0
	.dw 0x6dc0, 0xc82a,	0x6dff, 0xc82a,		0x21, 0
	.dw 0x6e40, 0xc82a,	0x6e7f, 0xc82a,		0x21, 0
	.dw 0x6ec0, 0xc82a,	0x6eff, 0xc82a,		0x21, 0
	.dw 0x6f40, 0xc82a,	0x6f7f, 0xc82a,		0x21, 0
	.dw 0x6fc0, 0xc82a,	0x6fff, 0xc82a,		0x21, 0
	.dw 0x7040, 0xc82a,	0x707f, 0xc82a,		0x21, 0
	.dw 0x70c0, 0xc82a,	0x70ff, 0xc82a,		0x21, 0
	.dw 0x7140, 0xc82a,	0x717f, 0xc82a,		0x21, 0
	.dw 0x71c0, 0xc82a,	0x71ff, 0xc82a,		0x21, 0
	.dw 0x7240, 0xc82a,	0x727f, 0xc82a,		0x21, 0
	.dw 0x72c0, 0xc82a,	0x72ff, 0xc82a,		0x21, 0
	.dw 0x7340, 0xc82a,	0x737f, 0xc82a,		0x21, 0
	.dw 0x73c0, 0xc82a,	0x73ff, 0xc82a,		0x21, 0
	.dw 0x7440, 0xc82a,	0x747f, 0xc82a,		0x21, 0
	.dw 0x74c0, 0xc82a,	0x74ff, 0xc82a,		0x21, 0
	.dw 0x7540, 0xc82a,	0x757f, 0xc82a,		0x21, 0
	.dw 0x75c0, 0xc82a,	0x75ff, 0xc82a,		0x21, 0
	.dw 0x7640, 0xc82a,	0x767f, 0xc82a,		0x21, 0
	.dw 0x76c0, 0xc82a,	0x76ff, 0xc82a,		0x21, 0
	.dw 0x7740, 0xc82a,	0x777f, 0xc82a,		0x21, 0
	.dw 0x77c0, 0xc82a,	0x77ff, 0xc82a,		0x21, 0
	.dw 0x7840, 0xc82a,	0x787f, 0xc82a,		0x21, 0
	.dw 0x78c0, 0xc82a,	0x78ff, 0xc82a,		0x21, 0
	.dw 0x7940, 0xc82a,	0x797f, 0xc82a,		0x21, 0
	.dw 0x79c0, 0xc82a,	0x9fff, 0xc82a,		0x21, 0
	.dw 0xa040, 0xc82a,	0xa07f, 0xc82a,		0x21, 0
	.dw 0xa0c0, 0xc82a,	0xa0ff, 0xc82a,		0x21, 0
	.dw 0xa140, 0xc82a,	0xa17f, 0xc82a,		0x21, 0
	.dw 0xa1c0, 0xc82a,	0xa1ff, 0xc82a,		0x21, 0
	.dw 0xa240, 0xc82a,	0xa27f, 0xc82a,		0x21, 0
	.dw 0xa2c0, 0xc82a,	0xa2ff, 0xc82a,		0x21, 0
	.dw 0xa340, 0xc82a,	0xa37f, 0xc82a,		0x21, 0
	.dw 0xa3c0, 0xc82a,	0xa3ff, 0xc82a,		0x21, 0
	.dw 0xa440, 0xc82a,	0xa47f, 0xc82a,		0x21, 0
	.dw 0xa4c0, 0xc82a,	0xa4ff, 0xc82a,		0x21, 0
	.dw 0xa540, 0xc82a,	0xa57f, 0xc82a,		0x21, 0
	.dw 0xa5c0, 0xc82a,	0xa5ff, 0xc82a,		0x21, 0
	.dw 0xa640, 0xc82a,	0xa67f, 0xc82a,		0x21, 0
	.dw 0xa6c0, 0xc82a,	0xa6ff, 0xc82a,		0x21, 0
	.dw 0xa740, 0xc82a,	0xa77f, 0xc82a,		0x21, 0
	.dw 0xa7c0, 0xc82a,	0xa7ff, 0xc82a,		0x21, 0
	.dw 0xa840, 0xc82a,	0xa87f, 0xc82a,		0x21, 0
	.dw 0xa8c0, 0xc82a,	0xa8ff, 0xc82a,		0x21, 0
	.dw 0xa940, 0xc82a,	0xa97f, 0xc82a,		0x21, 0
	.dw 0xa9c0, 0xc82a,	0xa9ff, 0xc82a,		0x21, 0
	.dw 0xaa40, 0xc82a,	0xaa7f, 0xc82a,		0x21, 0
	.dw 0xaac0, 0xc82a,	0xaaff, 0xc82a,		0x21, 0
	.dw 0xab40, 0xc82a,	0xab7f, 0xc82a,		0x21, 0
	.dw 0xabc0, 0xc82a,	0xabff, 0xc82a,		0x21, 0
	.dw 0xac40, 0xc82a,	0xac7f, 0xc82a,		0x21, 0
	.dw 0xacc0, 0xc82a,	0xacff, 0xc82a,		0x21, 0
	.dw 0xad40, 0xc82a,	0xad7f, 0xc82a,		0x21, 0
	.dw 0xadc0, 0xc82a,	0xadff, 0xc82a,		0x21, 0
	.dw 0xae40, 0xc82a,	0xae7f, 0xc82a,		0x21, 0
	.dw 0xaec0, 0xc82a,	0xaeff, 0xc82a,		0x21, 0
	.dw 0xaf40, 0xc82a,	0xaf7f, 0xc82a,		0x21, 0
	.dw 0xafc0, 0xc82a,	0xafff, 0xc82a,		0x21, 0
	.dw 0xb040, 0xc82a,	0xb07f, 0xc82a,		0x21, 0
	.dw 0xb0c0, 0xc82a,	0xb0ff, 0xc82a,		0x21, 0
	.dw 0xb140, 0xc82a,	0xb17f, 0xc82a,		0x21, 0
	.dw 0xb1c0, 0xc82a,	0xb1ff, 0xc82a,		0x21, 0
	.dw 0xb240, 0xc82a,	0xb27f, 0xc82a,		0x21, 0
	.dw 0xb2c0, 0xc82a,	0xb2ff, 0xc82a,		0x21, 0
	.dw 0xb340, 0xc82a,	0xb37f, 0xc82a,		0x21, 0
	.dw 0xb3c0, 0xc82a,	0xb3ff, 0xc82a,		0x21, 0
	.dw 0xb440, 0xc82a,	0xb47f, 0xc82a,		0x21, 0
	.dw 0xb4c0, 0xc82a,	0xb4ff, 0xc82a,		0x21, 0
	.dw 0xb540, 0xc82a,	0xb57f, 0xc82a,		0x21, 0
	.dw 0xb5c0, 0xc82a,	0xb5ff, 0xc82a,		0x21, 0
	.dw 0xb640, 0xc82a,	0xb67f, 0xc82a,		0x21, 0
	.dw 0xb6c0, 0xc82a,	0xb6ff, 0xc82a,		0x21, 0
	.dw 0xb740, 0xc82a,	0xb77f, 0xc82a,		0x21, 0
	.dw 0xb7c0, 0xc82a,	0xb7ff, 0xc82a,		0x21, 0
	.dw 0xb840, 0xc82a,	0xb87f, 0xc82a,		0x21, 0
	.dw 0xb8c0, 0xc82a,	0xb8ff, 0xc82a,		0x21, 0
	.dw 0xb940, 0xc82a,	0xb97f, 0xc82a,		0x21, 0
	.dw 0xb9c0, 0xc82a,	0xdfff, 0xc82a,		0x21, 0
	.dw 0xe040, 0xc82a,	0xe07f, 0xc82a,		0x21, 0
	.dw 0xe0c0, 0xc82a,	0xe0ff, 0xc82a,		0x21, 0
	.dw 0xe140, 0xc82a,	0xe17f, 0xc82a,		0x21, 0
	.dw 0xe1c0, 0xc82a,	0xe1ff, 0xc82a,		0x21, 0
	.dw 0xe240, 0xc82a,	0xe27f, 0xc82a,		0x21, 0
	.dw 0xe2c0, 0xc82a,	0xe2ff, 0xc82a,		0x21, 0
	.dw 0xe340, 0xc82a,	0xe37f, 0xc82a,		0x21, 0
	.dw 0xe3c0, 0xc82a,	0xe3ff, 0xc82a,		0x21, 0
	.dw 0xe440, 0xc82a,	0xe47f, 0xc82a,		0x21, 0
	.dw 0xe4c0, 0xc82a,	0xe4ff, 0xc82a,		0x21, 0
	.dw 0xe540, 0xc82a,	0xe57f, 0xc82a,		0x21, 0
	.dw 0xe5c0, 0xc82a,	0xe5ff, 0xc82a,		0x21, 0
	.dw 0xe640, 0xc82a,	0xe67f, 0xc82a,		0x21, 0
	.dw 0xe6c0, 0xc82a,	0xe6ff, 0xc82a,		0x21, 0
	.dw 0xe740, 0xc82a,	0xe77f, 0xc82a,		0x21, 0
	.dw 0xe7c0, 0xc82a,	0xe7ff, 0xc82a,		0x21, 0
	.dw 0xe840, 0xc82a,	0xe87f, 0xc82a,		0x21, 0
	.dw 0xe8c0, 0xc82a,	0xe8ff, 0xc82a,		0x21, 0
	.dw 0xe940, 0xc82a,	0xe97f, 0xc82a,		0x21, 0
	.dw 0xe9c0, 0xc82a,	0xe9ff, 0xc82a,		0x21, 0
	.dw 0xea40, 0xc82a,	0xea7f, 0xc82a,		0x21, 0
	.dw 0xeac0, 0xc82a,	0xeaff, 0xc82a,		0x21, 0
	.dw 0xeb40, 0xc82a,	0xeb7f, 0xc82a,		0x21, 0
	.dw 0xebc0, 0xc82a,	0xebff, 0xc82a,		0x21, 0
	.dw 0xec40, 0xc82a,	0xec7f, 0xc82a,		0x21, 0
	.dw 0xecc0, 0xc82a,	0xecff, 0xc82a,		0x21, 0
	.dw 0xed40, 0xc82a,	0xed7f, 0xc82a,		0x21, 0
	.dw 0xedc0, 0xc82a,	0xedff, 0xc82a,		0x21, 0
	.dw 0xee40, 0xc82a,	0xee7f, 0xc82a,		0x21, 0
	.dw 0xeec0, 0xc82a,	0xeeff, 0xc82a,		0x21, 0
	.dw 0xef40, 0xc82a,	0xef7f, 0xc82a,		0x21, 0
	.dw 0xefc0, 0xc82a,	0xefff, 0xc82a,		0x21, 0
	.dw 0xf040, 0xc82a,	0xf07f, 0xc82a,		0x21, 0
	.dw 0xf0c0, 0xc82a,	0xf0ff, 0xc82a,		0x21, 0
	.dw 0xf140, 0xc82a,	0xf17f, 0xc82a,		0x21, 0
	.dw 0xf1c0, 0xc82a,	0xf1ff, 0xc82a,		0x21, 0
	.dw 0xf240, 0xc82a,	0xf27f, 0xc82a,		0x21, 0
	.dw 0xf2c0, 0xc82a,	0xf2ff, 0xc82a,		0x21, 0
	.dw 0xf340, 0xc82a,	0xf37f, 0xc82a,		0x21, 0
	.dw 0xf3c0, 0xc82a,	0xf3ff, 0xc82a,		0x21, 0
	.dw 0xf440, 0xc82a,	0xf47f, 0xc82a,		0x21, 0
	.dw 0xf4c0, 0xc82a,	0xf4ff, 0xc82a,		0x21, 0
	.dw 0xf540, 0xc82a,	0xf57f, 0xc82a,		0x21, 0
	.dw 0xf5c0, 0xc82a,	0xf5ff, 0xc82a,		0x21, 0
	.dw 0xf640, 0xc82a,	0xf67f, 0xc82a,		0x21, 0
	.dw 0xf6c0, 0xc82a,	0xf6ff, 0xc82a,		0x21, 0
	.dw 0xf740, 0xc82a,	0xf77f, 0xc82a,		0x21, 0
	.dw 0xf7c0, 0xc82a,	0xf7ff, 0xc82a,		0x21, 0
	.dw 0xf840, 0xc82a,	0xf87f, 0xc82a,		0x21, 0
	.dw 0xf8c0, 0xc82a,	0xf8ff, 0xc82a,		0x21, 0
	.dw 0xf940, 0xc82a,	0xf97f, 0xc82a,		0x21, 0
	.dw 0xf9c0, 0xc82a,	0x1fff, 0xc82b,		0x21, 0
	.dw 0x2040, 0xc82b,	0x207f, 0xc82b,		0x21, 0
	.dw 0x20c0, 0xc82b,	0x20ff, 0xc82b,		0x21, 0
	.dw 0x2140, 0xc82b,	0x217f, 0xc82b,		0x21, 0
	.dw 0x21c0, 0xc82b,	0x21ff, 0xc82b,		0x21, 0
	.dw 0x2240, 0xc82b,	0x227f, 0xc82b,		0x21, 0
	.dw 0x22c0, 0xc82b,	0x22ff, 0xc82b,		0x21, 0
	.dw 0x2340, 0xc82b,	0x237f, 0xc82b,		0x21, 0
	.dw 0x23c0, 0xc82b,	0x23ff, 0xc82b,		0x21, 0
	.dw 0x2440, 0xc82b,	0x247f, 0xc82b,		0x21, 0
	.dw 0x24c0, 0xc82b,	0x24ff, 0xc82b,		0x21, 0
	.dw 0x2540, 0xc82b,	0x257f, 0xc82b,		0x21, 0
	.dw 0x25c0, 0xc82b,	0x25ff, 0xc82b,		0x21, 0
	.dw 0x2640, 0xc82b,	0x267f, 0xc82b,		0x21, 0
	.dw 0x26c0, 0xc82b,	0x26ff, 0xc82b,		0x21, 0
	.dw 0x2740, 0xc82b,	0x277f, 0xc82b,		0x21, 0
	.dw 0x27c0, 0xc82b,	0x27ff, 0xc82b,		0x21, 0
	.dw 0x2840, 0xc82b,	0x287f, 0xc82b,		0x21, 0
	.dw 0x28c0, 0xc82b,	0x28ff, 0xc82b,		0x21, 0
	.dw 0x2940, 0xc82b,	0x297f, 0xc82b,		0x21, 0
	.dw 0x29c0, 0xc82b,	0x29ff, 0xc82b,		0x21, 0
	.dw 0x2a40, 0xc82b,	0x2a7f, 0xc82b,		0x21, 0
	.dw 0x2ac0, 0xc82b,	0x2aff, 0xc82b,		0x21, 0
	.dw 0x2b40, 0xc82b,	0x2b7f, 0xc82b,		0x21, 0
	.dw 0x2bc0, 0xc82b,	0x2bff, 0xc82b,		0x21, 0
	.dw 0x2c40, 0xc82b,	0x2c7f, 0xc82b,		0x21, 0
	.dw 0x2cc0, 0xc82b,	0x2cff, 0xc82b,		0x21, 0
	.dw 0x2d40, 0xc82b,	0x2d7f, 0xc82b,		0x21, 0
	.dw 0x2dc0, 0xc82b,	0x2dff, 0xc82b,		0x21, 0
	.dw 0x2e40, 0xc82b,	0x2e7f, 0xc82b,		0x21, 0
	.dw 0x2ec0, 0xc82b,	0x2eff, 0xc82b,		0x21, 0
	.dw 0x2f40, 0xc82b,	0x2f7f, 0xc82b,		0x21, 0
	.dw 0x2fc0, 0xc82b,	0x2fff, 0xc82b,		0x21, 0
	.dw 0x3040, 0xc82b,	0x307f, 0xc82b,		0x21, 0
	.dw 0x30c0, 0xc82b,	0x30ff, 0xc82b,		0x21, 0
	.dw 0x3140, 0xc82b,	0x317f, 0xc82b,		0x21, 0
	.dw 0x31c0, 0xc82b,	0x31ff, 0xc82b,		0x21, 0
	.dw 0x3240, 0xc82b,	0x327f, 0xc82b,		0x21, 0
	.dw 0x32c0, 0xc82b,	0x32ff, 0xc82b,		0x21, 0
	.dw 0x3340, 0xc82b,	0x337f, 0xc82b,		0x21, 0
	.dw 0x33c0, 0xc82b,	0x33ff, 0xc82b,		0x21, 0
	.dw 0x3440, 0xc82b,	0x347f, 0xc82b,		0x21, 0
	.dw 0x34c0, 0xc82b,	0x34ff, 0xc82b,		0x21, 0
	.dw 0x3540, 0xc82b,	0x357f, 0xc82b,		0x21, 0
	.dw 0x35c0, 0xc82b,	0x35ff, 0xc82b,		0x21, 0
	.dw 0x3640, 0xc82b,	0x367f, 0xc82b,		0x21, 0
	.dw 0x36c0, 0xc82b,	0x36ff, 0xc82b,		0x21, 0
	.dw 0x3740, 0xc82b,	0x377f, 0xc82b,		0x21, 0
	.dw 0x37c0, 0xc82b,	0x37ff, 0xc82b,		0x21, 0
	.dw 0x3840, 0xc82b,	0x387f, 0xc82b,		0x21, 0
	.dw 0x38c0, 0xc82b,	0x38ff, 0xc82b,		0x21, 0
	.dw 0x3940, 0xc82b,	0x397f, 0xc82b,		0x21, 0
	.dw 0x39c0, 0xc82b,	0xffff, 0xc82b,		0x21, 0
	.dw 0x0040, 0xc82c,	0x007f, 0xc82c,		0x21, 0
	.dw 0x00c0, 0xc82c,	0x00ff, 0xc82c,		0x21, 0
	.dw 0x0140, 0xc82c,	0x017f, 0xc82c,		0x21, 0
	.dw 0x01c0, 0xc82c,	0x01ff, 0xc82c,		0x21, 0
	.dw 0x0240, 0xc82c,	0x027f, 0xc82c,		0x21, 0
	.dw 0x02c0, 0xc82c,	0x02ff, 0xc82c,		0x21, 0
	.dw 0x0340, 0xc82c,	0x037f, 0xc82c,		0x21, 0
	.dw 0x03c0, 0xc82c,	0x03ff, 0xc82c,		0x21, 0
	.dw 0x0440, 0xc82c,	0x047f, 0xc82c,		0x21, 0
	.dw 0x04c0, 0xc82c,	0x04ff, 0xc82c,		0x21, 0
	.dw 0x0540, 0xc82c,	0x057f, 0xc82c,		0x21, 0
	.dw 0x05c0, 0xc82c,	0x05ff, 0xc82c,		0x21, 0
	.dw 0x0640, 0xc82c,	0x067f, 0xc82c,		0x21, 0
	.dw 0x06c0, 0xc82c,	0x06ff, 0xc82c,		0x21, 0
	.dw 0x0740, 0xc82c,	0x077f, 0xc82c,		0x21, 0
	.dw 0x07c0, 0xc82c,	0x07ff, 0xc82c,		0x21, 0
	.dw 0x0840, 0xc82c,	0x087f, 0xc82c,		0x21, 0
	.dw 0x08c0, 0xc82c,	0x08ff, 0xc82c,		0x21, 0
	.dw 0x0940, 0xc82c,	0x097f, 0xc82c,		0x21, 0
	.dw 0x09c0, 0xc82c,	0x09ff, 0xc82c,		0x21, 0
	.dw 0x0a40, 0xc82c,	0x0a7f, 0xc82c,		0x21, 0
	.dw 0x0ac0, 0xc82c,	0x0aff, 0xc82c,		0x21, 0
	.dw 0x0b40, 0xc82c,	0x0b7f, 0xc82c,		0x21, 0
	.dw 0x0bc0, 0xc82c,	0x0bff, 0xc82c,		0x21, 0
	.dw 0x0c40, 0xc82c,	0x0c7f, 0xc82c,		0x21, 0
	.dw 0x0cc0, 0xc82c,	0x0cff, 0xc82c,		0x21, 0
	.dw 0x0d40, 0xc82c,	0x0d7f, 0xc82c,		0x21, 0
	.dw 0x0dc0, 0xc82c,	0x0dff, 0xc82c,		0x21, 0
	.dw 0x0e40, 0xc82c,	0x0e7f, 0xc82c,		0x21, 0
	.dw 0x0ec0, 0xc82c,	0x0eff, 0xc82c,		0x21, 0
	.dw 0x0f40, 0xc82c,	0x0f7f, 0xc82c,		0x21, 0
	.dw 0x0fc0, 0xc82c,	0x0fff, 0xc82c,		0x21, 0
	.dw 0x1040, 0xc82c,	0x107f, 0xc82c,		0x21, 0
	.dw 0x10c0, 0xc82c,	0x10ff, 0xc82c,		0x21, 0
	.dw 0x1140, 0xc82c,	0x117f, 0xc82c,		0x21, 0
	.dw 0x11c0, 0xc82c,	0x11ff, 0xc82c,		0x21, 0
	.dw 0x1240, 0xc82c,	0x127f, 0xc82c,		0x21, 0
	.dw 0x12c0, 0xc82c,	0x12ff, 0xc82c,		0x21, 0
	.dw 0x1340, 0xc82c,	0x137f, 0xc82c,		0x21, 0
	.dw 0x13c0, 0xc82c,	0x13ff, 0xc82c,		0x21, 0
	.dw 0x1440, 0xc82c,	0x147f, 0xc82c,		0x21, 0
	.dw 0x14c0, 0xc82c,	0x14ff, 0xc82c,		0x21, 0
	.dw 0x1540, 0xc82c,	0x157f, 0xc82c,		0x21, 0
	.dw 0x15c0, 0xc82c,	0x15ff, 0xc82c,		0x21, 0
	.dw 0x1640, 0xc82c,	0x167f, 0xc82c,		0x21, 0
	.dw 0x16c0, 0xc82c,	0x16ff, 0xc82c,		0x21, 0
	.dw 0x1740, 0xc82c,	0x177f, 0xc82c,		0x21, 0
	.dw 0x17c0, 0xc82c,	0x17ff, 0xc82c,		0x21, 0
	.dw 0x1840, 0xc82c,	0x187f, 0xc82c,		0x21, 0
	.dw 0x18c0, 0xc82c,	0x18ff, 0xc82c,		0x21, 0
	.dw 0x1940, 0xc82c,	0x197f, 0xc82c,		0x21, 0
	.dw 0x19c0, 0xc82c,	0x1fff, 0xc82c,		0x21, 0
	.dw 0x2040, 0xc82c,	0x207f, 0xc82c,		0x21, 0
	.dw 0x20c0, 0xc82c,	0x20ff, 0xc82c,		0x21, 0
	.dw 0x2140, 0xc82c,	0x217f, 0xc82c,		0x21, 0
	.dw 0x21c0, 0xc82c,	0x21ff, 0xc82c,		0x21, 0
	.dw 0x2240, 0xc82c,	0x227f, 0xc82c,		0x21, 0
	.dw 0x22c0, 0xc82c,	0x22ff, 0xc82c,		0x21, 0
	.dw 0x2340, 0xc82c,	0x237f, 0xc82c,		0x21, 0
	.dw 0x23c0, 0xc82c,	0x23ff, 0xc82c,		0x21, 0
	.dw 0x2440, 0xc82c,	0x247f, 0xc82c,		0x21, 0
	.dw 0x24c0, 0xc82c,	0x24ff, 0xc82c,		0x21, 0
	.dw 0x2540, 0xc82c,	0x257f, 0xc82c,		0x21, 0
	.dw 0x25c0, 0xc82c,	0x25ff, 0xc82c,		0x21, 0
	.dw 0x2640, 0xc82c,	0x267f, 0xc82c,		0x21, 0
	.dw 0x26c0, 0xc82c,	0x26ff, 0xc82c,		0x21, 0
	.dw 0x2740, 0xc82c,	0x277f, 0xc82c,		0x21, 0
	.dw 0x27c0, 0xc82c,	0x27ff, 0xc82c,		0x21, 0
	.dw 0x2840, 0xc82c,	0x287f, 0xc82c,		0x21, 0
	.dw 0x28c0, 0xc82c,	0x28ff, 0xc82c,		0x21, 0
	.dw 0x2940, 0xc82c,	0x297f, 0xc82c,		0x21, 0
	.dw 0x29c0, 0xc82c,	0x29ff, 0xc82c,		0x21, 0
	.dw 0x2a40, 0xc82c,	0x2a7f, 0xc82c,		0x21, 0
	.dw 0x2ac0, 0xc82c,	0x2aff, 0xc82c,		0x21, 0
	.dw 0x2b40, 0xc82c,	0x2b7f, 0xc82c,		0x21, 0
	.dw 0x2bc0, 0xc82c,	0x2bff, 0xc82c,		0x21, 0
	.dw 0x2c40, 0xc82c,	0x2c7f, 0xc82c,		0x21, 0
	.dw 0x2cc0, 0xc82c,	0x2cff, 0xc82c,		0x21, 0
	.dw 0x2d40, 0xc82c,	0x2d7f, 0xc82c,		0x21, 0
	.dw 0x2dc0, 0xc82c,	0x2dff, 0xc82c,		0x21, 0
	.dw 0x2e40, 0xc82c,	0x2e7f, 0xc82c,		0x21, 0
	.dw 0x2ec0, 0xc82c,	0x2eff, 0xc82c,		0x21, 0
	.dw 0x2f40, 0xc82c,	0x2f7f, 0xc82c,		0x21, 0
	.dw 0x2fc0, 0xc82c,	0x2fff, 0xc82c,		0x21, 0
	.dw 0x3040, 0xc82c,	0x307f, 0xc82c,		0x21, 0
	.dw 0x30c0, 0xc82c,	0x30ff, 0xc82c,		0x21, 0
	.dw 0x3140, 0xc82c,	0x317f, 0xc82c,		0x21, 0
	.dw 0x31c0, 0xc82c,	0x31ff, 0xc82c,		0x21, 0
	.dw 0x3240, 0xc82c,	0x327f, 0xc82c,		0x21, 0
	.dw 0x32c0, 0xc82c,	0x32ff, 0xc82c,		0x21, 0
	.dw 0x3340, 0xc82c,	0x337f, 0xc82c,		0x21, 0
	.dw 0x33c0, 0xc82c,	0x33ff, 0xc82c,		0x21, 0
	.dw 0x3440, 0xc82c,	0x347f, 0xc82c,		0x21, 0
	.dw 0x34c0, 0xc82c,	0x34ff, 0xc82c,		0x21, 0
	.dw 0x3540, 0xc82c,	0x357f, 0xc82c,		0x21, 0
	.dw 0x35c0, 0xc82c,	0x35ff, 0xc82c,		0x21, 0
	.dw 0x3640, 0xc82c,	0x367f, 0xc82c,		0x21, 0
	.dw 0x36c0, 0xc82c,	0x36ff, 0xc82c,		0x21, 0
	.dw 0x3740, 0xc82c,	0x377f, 0xc82c,		0x21, 0
	.dw 0x37c0, 0xc82c,	0x37ff, 0xc82c,		0x21, 0
	.dw 0x3840, 0xc82c,	0x387f, 0xc82c,		0x21, 0
	.dw 0x38c0, 0xc82c,	0x38ff, 0xc82c,		0x21, 0
	.dw 0x3940, 0xc82c,	0x397f, 0xc82c,		0x21, 0
	.dw 0x39c0, 0xc82c,	0x3fff, 0xc82c,		0x21, 0
	.dw 0x4040, 0xc82c,	0x407f, 0xc82c,		0x21, 0
	.dw 0x40c0, 0xc82c,	0x40ff, 0xc82c,		0x21, 0
	.dw 0x4140, 0xc82c,	0x417f, 0xc82c,		0x21, 0
	.dw 0x41c0, 0xc82c,	0x41ff, 0xc82c,		0x21, 0
	.dw 0x4240, 0xc82c,	0x427f, 0xc82c,		0x21, 0
	.dw 0x42c0, 0xc82c,	0x42ff, 0xc82c,		0x21, 0
	.dw 0x4340, 0xc82c,	0x437f, 0xc82c,		0x21, 0
	.dw 0x43c0, 0xc82c,	0x43ff, 0xc82c,		0x21, 0
	.dw 0x4440, 0xc82c,	0x447f, 0xc82c,		0x21, 0
	.dw 0x44c0, 0xc82c,	0x44ff, 0xc82c,		0x21, 0
	.dw 0x4540, 0xc82c,	0x457f, 0xc82c,		0x21, 0
	.dw 0x45c0, 0xc82c,	0x45ff, 0xc82c,		0x21, 0
	.dw 0x4640, 0xc82c,	0x467f, 0xc82c,		0x21, 0
	.dw 0x46c0, 0xc82c,	0x46ff, 0xc82c,		0x21, 0
	.dw 0x4740, 0xc82c,	0x477f, 0xc82c,		0x21, 0
	.dw 0x47c0, 0xc82c,	0x47ff, 0xc82c,		0x21, 0
	.dw 0x4840, 0xc82c,	0x487f, 0xc82c,		0x21, 0
	.dw 0x48c0, 0xc82c,	0x48ff, 0xc82c,		0x21, 0
	.dw 0x4940, 0xc82c,	0x497f, 0xc82c,		0x21, 0
	.dw 0x49c0, 0xc82c,	0x49ff, 0xc82c,		0x21, 0
	.dw 0x4a40, 0xc82c,	0x4a7f, 0xc82c,		0x21, 0
	.dw 0x4ac0, 0xc82c,	0x4aff, 0xc82c,		0x21, 0
	.dw 0x4b40, 0xc82c,	0x4b7f, 0xc82c,		0x21, 0
	.dw 0x4bc0, 0xc82c,	0x4bff, 0xc82c,		0x21, 0
	.dw 0x4c40, 0xc82c,	0x4c7f, 0xc82c,		0x21, 0
	.dw 0x4cc0, 0xc82c,	0x4cff, 0xc82c,		0x21, 0
	.dw 0x4d40, 0xc82c,	0x4d7f, 0xc82c,		0x21, 0
	.dw 0x4dc0, 0xc82c,	0x4dff, 0xc82c,		0x21, 0
	.dw 0x4e40, 0xc82c,	0x4e7f, 0xc82c,		0x21, 0
	.dw 0x4ec0, 0xc82c,	0x4eff, 0xc82c,		0x21, 0
	.dw 0x4f40, 0xc82c,	0x4f7f, 0xc82c,		0x21, 0
	.dw 0x4fc0, 0xc82c,	0x4fff, 0xc82c,		0x21, 0
	.dw 0x5040, 0xc82c,	0x507f, 0xc82c,		0x21, 0
	.dw 0x50c0, 0xc82c,	0x50ff, 0xc82c,		0x21, 0
	.dw 0x5140, 0xc82c,	0x517f, 0xc82c,		0x21, 0
	.dw 0x51c0, 0xc82c,	0x51ff, 0xc82c,		0x21, 0
	.dw 0x5240, 0xc82c,	0x527f, 0xc82c,		0x21, 0
	.dw 0x52c0, 0xc82c,	0x52ff, 0xc82c,		0x21, 0
	.dw 0x5340, 0xc82c,	0x537f, 0xc82c,		0x21, 0
	.dw 0x53c0, 0xc82c,	0x53ff, 0xc82c,		0x21, 0
	.dw 0x5440, 0xc82c,	0x547f, 0xc82c,		0x21, 0
	.dw 0x54c0, 0xc82c,	0x54ff, 0xc82c,		0x21, 0
	.dw 0x5540, 0xc82c,	0x557f, 0xc82c,		0x21, 0
	.dw 0x55c0, 0xc82c,	0x55ff, 0xc82c,		0x21, 0
	.dw 0x5640, 0xc82c,	0x567f, 0xc82c,		0x21, 0
	.dw 0x56c0, 0xc82c,	0x56ff, 0xc82c,		0x21, 0
	.dw 0x5740, 0xc82c,	0x577f, 0xc82c,		0x21, 0
	.dw 0x57c0, 0xc82c,	0x57ff, 0xc82c,		0x21, 0
	.dw 0x5840, 0xc82c,	0x587f, 0xc82c,		0x21, 0
	.dw 0x58c0, 0xc82c,	0x58ff, 0xc82c,		0x21, 0
	.dw 0x5940, 0xc82c,	0x597f, 0xc82c,		0x21, 0
	.dw 0x59c0, 0xc82c,	0x5fff, 0xc82c,		0x21, 0
	.dw 0x6040, 0xc82c,	0x607f, 0xc82c,		0x21, 0
	.dw 0x60c0, 0xc82c,	0x60ff, 0xc82c,		0x21, 0
	.dw 0x6140, 0xc82c,	0x617f, 0xc82c,		0x21, 0
	.dw 0x61c0, 0xc82c,	0x61ff, 0xc82c,		0x21, 0
	.dw 0x6240, 0xc82c,	0x627f, 0xc82c,		0x21, 0
	.dw 0x62c0, 0xc82c,	0x62ff, 0xc82c,		0x21, 0
	.dw 0x6340, 0xc82c,	0x637f, 0xc82c,		0x21, 0
	.dw 0x63c0, 0xc82c,	0x63ff, 0xc82c,		0x21, 0
	.dw 0x6440, 0xc82c,	0x647f, 0xc82c,		0x21, 0
	.dw 0x64c0, 0xc82c,	0x64ff, 0xc82c,		0x21, 0
	.dw 0x6540, 0xc82c,	0x657f, 0xc82c,		0x21, 0
	.dw 0x65c0, 0xc82c,	0x65ff, 0xc82c,		0x21, 0
	.dw 0x6640, 0xc82c,	0x667f, 0xc82c,		0x21, 0
	.dw 0x66c0, 0xc82c,	0x66ff, 0xc82c,		0x21, 0
	.dw 0x6740, 0xc82c,	0x677f, 0xc82c,		0x21, 0
	.dw 0x67c0, 0xc82c,	0x67ff, 0xc82c,		0x21, 0
	.dw 0x6840, 0xc82c,	0x687f, 0xc82c,		0x21, 0
	.dw 0x68c0, 0xc82c,	0x68ff, 0xc82c,		0x21, 0
	.dw 0x6940, 0xc82c,	0x697f, 0xc82c,		0x21, 0
	.dw 0x69c0, 0xc82c,	0x69ff, 0xc82c,		0x21, 0
	.dw 0x6a40, 0xc82c,	0x6a7f, 0xc82c,		0x21, 0
	.dw 0x6ac0, 0xc82c,	0x6aff, 0xc82c,		0x21, 0
	.dw 0x6b40, 0xc82c,	0x6b7f, 0xc82c,		0x21, 0
	.dw 0x6bc0, 0xc82c,	0x6bff, 0xc82c,		0x21, 0
	.dw 0x6c40, 0xc82c,	0x6c7f, 0xc82c,		0x21, 0
	.dw 0x6cc0, 0xc82c,	0x6cff, 0xc82c,		0x21, 0
	.dw 0x6d40, 0xc82c,	0x6d7f, 0xc82c,		0x21, 0
	.dw 0x6dc0, 0xc82c,	0x6dff, 0xc82c,		0x21, 0
	.dw 0x6e40, 0xc82c,	0x6e7f, 0xc82c,		0x21, 0
	.dw 0x6ec0, 0xc82c,	0x6eff, 0xc82c,		0x21, 0
	.dw 0x6f40, 0xc82c,	0x6f7f, 0xc82c,		0x21, 0
	.dw 0x6fc0, 0xc82c,	0x6fff, 0xc82c,		0x21, 0
	.dw 0x7040, 0xc82c,	0x707f, 0xc82c,		0x21, 0
	.dw 0x70c0, 0xc82c,	0x70ff, 0xc82c,		0x21, 0
	.dw 0x7140, 0xc82c,	0x717f, 0xc82c,		0x21, 0
	.dw 0x71c0, 0xc82c,	0x71ff, 0xc82c,		0x21, 0
	.dw 0x7240, 0xc82c,	0x727f, 0xc82c,		0x21, 0
	.dw 0x72c0, 0xc82c,	0x72ff, 0xc82c,		0x21, 0
	.dw 0x7340, 0xc82c,	0x737f, 0xc82c,		0x21, 0
	.dw 0x73c0, 0xc82c,	0x73ff, 0xc82c,		0x21, 0
	.dw 0x7440, 0xc82c,	0x747f, 0xc82c,		0x21, 0
	.dw 0x74c0, 0xc82c,	0x74ff, 0xc82c,		0x21, 0
	.dw 0x7540, 0xc82c,	0x757f, 0xc82c,		0x21, 0
	.dw 0x75c0, 0xc82c,	0x75ff, 0xc82c,		0x21, 0
	.dw 0x7640, 0xc82c,	0x767f, 0xc82c,		0x21, 0
	.dw 0x76c0, 0xc82c,	0x76ff, 0xc82c,		0x21, 0
	.dw 0x7740, 0xc82c,	0x777f, 0xc82c,		0x21, 0
	.dw 0x77c0, 0xc82c,	0x77ff, 0xc82c,		0x21, 0
	.dw 0x7840, 0xc82c,	0x787f, 0xc82c,		0x21, 0
	.dw 0x78c0, 0xc82c,	0x78ff, 0xc82c,		0x21, 0
	.dw 0x7940, 0xc82c,	0x797f, 0xc82c,		0x21, 0
	.dw 0x79c0, 0xc82c,	0x7fff, 0xc82c,		0x21, 0
	.dw 0x8040, 0xc82c,	0x807f, 0xc82c,		0x21, 0
	.dw 0x80c0, 0xc82c,	0x80ff, 0xc82c,		0x21, 0
	.dw 0x8140, 0xc82c,	0x817f, 0xc82c,		0x21, 0
	.dw 0x81c0, 0xc82c,	0x81ff, 0xc82c,		0x21, 0
	.dw 0x8240, 0xc82c,	0x827f, 0xc82c,		0x21, 0
	.dw 0x82c0, 0xc82c,	0x82ff, 0xc82c,		0x21, 0
	.dw 0x8340, 0xc82c,	0x837f, 0xc82c,		0x21, 0
	.dw 0x83c0, 0xc82c,	0x83ff, 0xc82c,		0x21, 0
	.dw 0x8440, 0xc82c,	0x847f, 0xc82c,		0x21, 0
	.dw 0x84c0, 0xc82c,	0x84ff, 0xc82c,		0x21, 0
	.dw 0x8540, 0xc82c,	0x857f, 0xc82c,		0x21, 0
	.dw 0x85c0, 0xc82c,	0x85ff, 0xc82c,		0x21, 0
	.dw 0x8640, 0xc82c,	0x867f, 0xc82c,		0x21, 0
	.dw 0x86c0, 0xc82c,	0x86ff, 0xc82c,		0x21, 0
	.dw 0x8740, 0xc82c,	0x877f, 0xc82c,		0x21, 0
	.dw 0x87c0, 0xc82c,	0x87ff, 0xc82c,		0x21, 0
	.dw 0x8840, 0xc82c,	0x887f, 0xc82c,		0x21, 0
	.dw 0x88c0, 0xc82c,	0x88ff, 0xc82c,		0x21, 0
	.dw 0x8940, 0xc82c,	0x897f, 0xc82c,		0x21, 0
	.dw 0x89c0, 0xc82c,	0x89ff, 0xc82c,		0x21, 0
	.dw 0x8a40, 0xc82c,	0x8a7f, 0xc82c,		0x21, 0
	.dw 0x8ac0, 0xc82c,	0x8aff, 0xc82c,		0x21, 0
	.dw 0x8b40, 0xc82c,	0x8b7f, 0xc82c,		0x21, 0
	.dw 0x8bc0, 0xc82c,	0x8bff, 0xc82c,		0x21, 0
	.dw 0x8c40, 0xc82c,	0x8c7f, 0xc82c,		0x21, 0
	.dw 0x8cc0, 0xc82c,	0x8cff, 0xc82c,		0x21, 0
	.dw 0x8d40, 0xc82c,	0x8d7f, 0xc82c,		0x21, 0
	.dw 0x8dc0, 0xc82c,	0x8dff, 0xc82c,		0x21, 0
	.dw 0x8e40, 0xc82c,	0x8e7f, 0xc82c,		0x21, 0
	.dw 0x8ec0, 0xc82c,	0x8eff, 0xc82c,		0x21, 0
	.dw 0x8f40, 0xc82c,	0x8f7f, 0xc82c,		0x21, 0
	.dw 0x8fc0, 0xc82c,	0x8fff, 0xc82c,		0x21, 0
	.dw 0x9040, 0xc82c,	0x907f, 0xc82c,		0x21, 0
	.dw 0x90c0, 0xc82c,	0x90ff, 0xc82c,		0x21, 0
	.dw 0x9140, 0xc82c,	0x917f, 0xc82c,		0x21, 0
	.dw 0x91c0, 0xc82c,	0x91ff, 0xc82c,		0x21, 0
	.dw 0x9240, 0xc82c,	0x927f, 0xc82c,		0x21, 0
	.dw 0x92c0, 0xc82c,	0x92ff, 0xc82c,		0x21, 0
	.dw 0x9340, 0xc82c,	0x937f, 0xc82c,		0x21, 0
	.dw 0x93c0, 0xc82c,	0x93ff, 0xc82c,		0x21, 0
	.dw 0x9440, 0xc82c,	0x947f, 0xc82c,		0x21, 0
	.dw 0x94c0, 0xc82c,	0x94ff, 0xc82c,		0x21, 0
	.dw 0x9540, 0xc82c,	0x957f, 0xc82c,		0x21, 0
	.dw 0x95c0, 0xc82c,	0x95ff, 0xc82c,		0x21, 0
	.dw 0x9640, 0xc82c,	0x967f, 0xc82c,		0x21, 0
	.dw 0x96c0, 0xc82c,	0x96ff, 0xc82c,		0x21, 0
	.dw 0x9740, 0xc82c,	0x977f, 0xc82c,		0x21, 0
	.dw 0x97c0, 0xc82c,	0x97ff, 0xc82c,		0x21, 0
	.dw 0x9840, 0xc82c,	0x987f, 0xc82c,		0x21, 0
	.dw 0x98c0, 0xc82c,	0x98ff, 0xc82c,		0x21, 0
	.dw 0x9940, 0xc82c,	0x997f, 0xc82c,		0x21, 0
	.dw 0x99c0, 0xc82c,	0x9fff, 0xc82c,		0x21, 0
	.dw 0xa040, 0xc82c,	0xa07f, 0xc82c,		0x21, 0
	.dw 0xa0c0, 0xc82c,	0xa0ff, 0xc82c,		0x21, 0
	.dw 0xa140, 0xc82c,	0xa17f, 0xc82c,		0x21, 0
	.dw 0xa1c0, 0xc82c,	0xa1ff, 0xc82c,		0x21, 0
	.dw 0xa240, 0xc82c,	0xa27f, 0xc82c,		0x21, 0
	.dw 0xa2c0, 0xc82c,	0xa2ff, 0xc82c,		0x21, 0
	.dw 0xa340, 0xc82c,	0xa37f, 0xc82c,		0x21, 0
	.dw 0xa3c0, 0xc82c,	0xa3ff, 0xc82c,		0x21, 0
	.dw 0xa440, 0xc82c,	0xa47f, 0xc82c,		0x21, 0
	.dw 0xa4c0, 0xc82c,	0xa4ff, 0xc82c,		0x21, 0
	.dw 0xa540, 0xc82c,	0xa57f, 0xc82c,		0x21, 0
	.dw 0xa5c0, 0xc82c,	0xa5ff, 0xc82c,		0x21, 0
	.dw 0xa640, 0xc82c,	0xa67f, 0xc82c,		0x21, 0
	.dw 0xa6c0, 0xc82c,	0xa6ff, 0xc82c,		0x21, 0
	.dw 0xa740, 0xc82c,	0xa77f, 0xc82c,		0x21, 0
	.dw 0xa7c0, 0xc82c,	0xa7ff, 0xc82c,		0x21, 0
	.dw 0xa840, 0xc82c,	0xa87f, 0xc82c,		0x21, 0
	.dw 0xa8c0, 0xc82c,	0xa8ff, 0xc82c,		0x21, 0
	.dw 0xa940, 0xc82c,	0xa97f, 0xc82c,		0x21, 0
	.dw 0xa9c0, 0xc82c,	0xa9ff, 0xc82c,		0x21, 0
	.dw 0xaa40, 0xc82c,	0xaa7f, 0xc82c,		0x21, 0
	.dw 0xaac0, 0xc82c,	0xaaff, 0xc82c,		0x21, 0
	.dw 0xab40, 0xc82c,	0xab7f, 0xc82c,		0x21, 0
	.dw 0xabc0, 0xc82c,	0xabff, 0xc82c,		0x21, 0
	.dw 0xac40, 0xc82c,	0xac7f, 0xc82c,		0x21, 0
	.dw 0xacc0, 0xc82c,	0xacff, 0xc82c,		0x21, 0
	.dw 0xad40, 0xc82c,	0xad7f, 0xc82c,		0x21, 0
	.dw 0xadc0, 0xc82c,	0xadff, 0xc82c,		0x21, 0
	.dw 0xae40, 0xc82c,	0xae7f, 0xc82c,		0x21, 0
	.dw 0xaec0, 0xc82c,	0xaeff, 0xc82c,		0x21, 0
	.dw 0xaf40, 0xc82c,	0xaf7f, 0xc82c,		0x21, 0
	.dw 0xafc0, 0xc82c,	0xafff, 0xc82c,		0x21, 0
	.dw 0xb040, 0xc82c,	0xb07f, 0xc82c,		0x21, 0
	.dw 0xb0c0, 0xc82c,	0xb0ff, 0xc82c,		0x21, 0
	.dw 0xb140, 0xc82c,	0xb17f, 0xc82c,		0x21, 0
	.dw 0xb1c0, 0xc82c,	0xb1ff, 0xc82c,		0x21, 0
	.dw 0xb240, 0xc82c,	0xb27f, 0xc82c,		0x21, 0
	.dw 0xb2c0, 0xc82c,	0xb2ff, 0xc82c,		0x21, 0
	.dw 0xb340, 0xc82c,	0xb37f, 0xc82c,		0x21, 0
	.dw 0xb3c0, 0xc82c,	0xb3ff, 0xc82c,		0x21, 0
	.dw 0xb440, 0xc82c,	0xb47f, 0xc82c,		0x21, 0
	.dw 0xb4c0, 0xc82c,	0xb4ff, 0xc82c,		0x21, 0
	.dw 0xb540, 0xc82c,	0xb57f, 0xc82c,		0x21, 0
	.dw 0xb5c0, 0xc82c,	0xb5ff, 0xc82c,		0x21, 0
	.dw 0xb640, 0xc82c,	0xb67f, 0xc82c,		0x21, 0
	.dw 0xb6c0, 0xc82c,	0xb6ff, 0xc82c,		0x21, 0
	.dw 0xb740, 0xc82c,	0xb77f, 0xc82c,		0x21, 0
	.dw 0xb7c0, 0xc82c,	0xb7ff, 0xc82c,		0x21, 0
	.dw 0xb840, 0xc82c,	0xb87f, 0xc82c,		0x21, 0
	.dw 0xb8c0, 0xc82c,	0xb8ff, 0xc82c,		0x21, 0
	.dw 0xb940, 0xc82c,	0xb97f, 0xc82c,		0x21, 0
	.dw 0xb9c0, 0xc82c,	0xbfff, 0xc82c,		0x21, 0
	.dw 0xc040, 0xc82c,	0xc07f, 0xc82c,		0x21, 0
	.dw 0xc0c0, 0xc82c,	0xc0ff, 0xc82c,		0x21, 0
	.dw 0xc140, 0xc82c,	0xc17f, 0xc82c,		0x21, 0
	.dw 0xc1c0, 0xc82c,	0xc1ff, 0xc82c,		0x21, 0
	.dw 0xc240, 0xc82c,	0xc27f, 0xc82c,		0x21, 0
	.dw 0xc2c0, 0xc82c,	0xc2ff, 0xc82c,		0x21, 0
	.dw 0xc340, 0xc82c,	0xc37f, 0xc82c,		0x21, 0
	.dw 0xc3c0, 0xc82c,	0xc3ff, 0xc82c,		0x21, 0
	.dw 0xc440, 0xc82c,	0xc47f, 0xc82c,		0x21, 0
	.dw 0xc4c0, 0xc82c,	0xc4ff, 0xc82c,		0x21, 0
	.dw 0xc540, 0xc82c,	0xc57f, 0xc82c,		0x21, 0
	.dw 0xc5c0, 0xc82c,	0xc5ff, 0xc82c,		0x21, 0
	.dw 0xc640, 0xc82c,	0xc67f, 0xc82c,		0x21, 0
	.dw 0xc6c0, 0xc82c,	0xc6ff, 0xc82c,		0x21, 0
	.dw 0xc740, 0xc82c,	0xc77f, 0xc82c,		0x21, 0
	.dw 0xc7c0, 0xc82c,	0xc7ff, 0xc82c,		0x21, 0
	.dw 0xc840, 0xc82c,	0xc87f, 0xc82c,		0x21, 0
	.dw 0xc8c0, 0xc82c,	0xc8ff, 0xc82c,		0x21, 0
	.dw 0xc940, 0xc82c,	0xc97f, 0xc82c,		0x21, 0
	.dw 0xc9c0, 0xc82c,	0xc9ff, 0xc82c,		0x21, 0
	.dw 0xca40, 0xc82c,	0xca7f, 0xc82c,		0x21, 0
	.dw 0xcac0, 0xc82c,	0xcaff, 0xc82c,		0x21, 0
	.dw 0xcb40, 0xc82c,	0xcb7f, 0xc82c,		0x21, 0
	.dw 0xcbc0, 0xc82c,	0xcbff, 0xc82c,		0x21, 0
	.dw 0xcc40, 0xc82c,	0xcc7f, 0xc82c,		0x21, 0
	.dw 0xccc0, 0xc82c,	0xccff, 0xc82c,		0x21, 0
	.dw 0xcd40, 0xc82c,	0xcd7f, 0xc82c,		0x21, 0
	.dw 0xcdc0, 0xc82c,	0xcdff, 0xc82c,		0x21, 0
	.dw 0xce40, 0xc82c,	0xce7f, 0xc82c,		0x21, 0
	.dw 0xcec0, 0xc82c,	0xceff, 0xc82c,		0x21, 0
	.dw 0xcf40, 0xc82c,	0xcf7f, 0xc82c,		0x21, 0
	.dw 0xcfc0, 0xc82c,	0xcfff, 0xc82c,		0x21, 0
	.dw 0xd040, 0xc82c,	0xd07f, 0xc82c,		0x21, 0
	.dw 0xd0c0, 0xc82c,	0xd0ff, 0xc82c,		0x21, 0
	.dw 0xd140, 0xc82c,	0xd17f, 0xc82c,		0x21, 0
	.dw 0xd1c0, 0xc82c,	0xd1ff, 0xc82c,		0x21, 0
	.dw 0xd240, 0xc82c,	0xd27f, 0xc82c,		0x21, 0
	.dw 0xd2c0, 0xc82c,	0xd2ff, 0xc82c,		0x21, 0
	.dw 0xd340, 0xc82c,	0xd37f, 0xc82c,		0x21, 0
	.dw 0xd3c0, 0xc82c,	0xd3ff, 0xc82c,		0x21, 0
	.dw 0xd440, 0xc82c,	0xd47f, 0xc82c,		0x21, 0
	.dw 0xd4c0, 0xc82c,	0xd4ff, 0xc82c,		0x21, 0
	.dw 0xd540, 0xc82c,	0xd57f, 0xc82c,		0x21, 0
	.dw 0xd5c0, 0xc82c,	0xd5ff, 0xc82c,		0x21, 0
	.dw 0xd640, 0xc82c,	0xd67f, 0xc82c,		0x21, 0
	.dw 0xd6c0, 0xc82c,	0xd6ff, 0xc82c,		0x21, 0
	.dw 0xd740, 0xc82c,	0xd77f, 0xc82c,		0x21, 0
	.dw 0xd7c0, 0xc82c,	0xd7ff, 0xc82c,		0x21, 0
	.dw 0xd840, 0xc82c,	0xd87f, 0xc82c,		0x21, 0
	.dw 0xd8c0, 0xc82c,	0xd8ff, 0xc82c,		0x21, 0
	.dw 0xd940, 0xc82c,	0xd97f, 0xc82c,		0x21, 0
	.dw 0xd9c0, 0xc82c,	0xdfff, 0xc82c,		0x21, 0
	.dw 0xe040, 0xc82c,	0xe07f, 0xc82c,		0x21, 0
	.dw 0xe0c0, 0xc82c,	0xe0ff, 0xc82c,		0x21, 0
	.dw 0xe140, 0xc82c,	0xe17f, 0xc82c,		0x21, 0
	.dw 0xe1c0, 0xc82c,	0xe1ff, 0xc82c,		0x21, 0
	.dw 0xe240, 0xc82c,	0xe27f, 0xc82c,		0x21, 0
	.dw 0xe2c0, 0xc82c,	0xe2ff, 0xc82c,		0x21, 0
	.dw 0xe340, 0xc82c,	0xe37f, 0xc82c,		0x21, 0
	.dw 0xe3c0, 0xc82c,	0xe3ff, 0xc82c,		0x21, 0
	.dw 0xe440, 0xc82c,	0xe47f, 0xc82c,		0x21, 0
	.dw 0xe4c0, 0xc82c,	0xe4ff, 0xc82c,		0x21, 0
	.dw 0xe540, 0xc82c,	0xe57f, 0xc82c,		0x21, 0
	.dw 0xe5c0, 0xc82c,	0xe5ff, 0xc82c,		0x21, 0
	.dw 0xe640, 0xc82c,	0xe67f, 0xc82c,		0x21, 0
	.dw 0xe6c0, 0xc82c,	0xe6ff, 0xc82c,		0x21, 0
	.dw 0xe740, 0xc82c,	0xe77f, 0xc82c,		0x21, 0
	.dw 0xe7c0, 0xc82c,	0xe7ff, 0xc82c,		0x21, 0
	.dw 0xe840, 0xc82c,	0xe87f, 0xc82c,		0x21, 0
	.dw 0xe8c0, 0xc82c,	0xe8ff, 0xc82c,		0x21, 0
	.dw 0xe940, 0xc82c,	0xe97f, 0xc82c,		0x21, 0
	.dw 0xe9c0, 0xc82c,	0xe9ff, 0xc82c,		0x21, 0
	.dw 0xea40, 0xc82c,	0xea7f, 0xc82c,		0x21, 0
	.dw 0xeac0, 0xc82c,	0xeaff, 0xc82c,		0x21, 0
	.dw 0xeb40, 0xc82c,	0xeb7f, 0xc82c,		0x21, 0
	.dw 0xebc0, 0xc82c,	0xebff, 0xc82c,		0x21, 0
	.dw 0xec40, 0xc82c,	0xec7f, 0xc82c,		0x21, 0
	.dw 0xecc0, 0xc82c,	0xecff, 0xc82c,		0x21, 0
	.dw 0xed40, 0xc82c,	0xed7f, 0xc82c,		0x21, 0
	.dw 0xedc0, 0xc82c,	0xedff, 0xc82c,		0x21, 0
	.dw 0xee40, 0xc82c,	0xee7f, 0xc82c,		0x21, 0
	.dw 0xeec0, 0xc82c,	0xeeff, 0xc82c,		0x21, 0
	.dw 0xef40, 0xc82c,	0xef7f, 0xc82c,		0x21, 0
	.dw 0xefc0, 0xc82c,	0xefff, 0xc82c,		0x21, 0
	.dw 0xf040, 0xc82c,	0xf07f, 0xc82c,		0x21, 0
	.dw 0xf0c0, 0xc82c,	0xf0ff, 0xc82c,		0x21, 0
	.dw 0xf140, 0xc82c,	0xf17f, 0xc82c,		0x21, 0
	.dw 0xf1c0, 0xc82c,	0xf1ff, 0xc82c,		0x21, 0
	.dw 0xf240, 0xc82c,	0xf27f, 0xc82c,		0x21, 0
	.dw 0xf2c0, 0xc82c,	0xf2ff, 0xc82c,		0x21, 0
	.dw 0xf340, 0xc82c,	0xf37f, 0xc82c,		0x21, 0
	.dw 0xf3c0, 0xc82c,	0xf3ff, 0xc82c,		0x21, 0
	.dw 0xf440, 0xc82c,	0xf47f, 0xc82c,		0x21, 0
	.dw 0xf4c0, 0xc82c,	0xf4ff, 0xc82c,		0x21, 0
	.dw 0xf540, 0xc82c,	0xf57f, 0xc82c,		0x21, 0
	.dw 0xf5c0, 0xc82c,	0xf5ff, 0xc82c,		0x21, 0
	.dw 0xf640, 0xc82c,	0xf67f, 0xc82c,		0x21, 0
	.dw 0xf6c0, 0xc82c,	0xf6ff, 0xc82c,		0x21, 0
	.dw 0xf740, 0xc82c,	0xf77f, 0xc82c,		0x21, 0
	.dw 0xf7c0, 0xc82c,	0xf7ff, 0xc82c,		0x21, 0
	.dw 0xf840, 0xc82c,	0xf87f, 0xc82c,		0x21, 0
	.dw 0xf8c0, 0xc82c,	0xf8ff, 0xc82c,		0x21, 0
	.dw 0xf940, 0xc82c,	0xf97f, 0xc82c,		0x21, 0
	.dw 0xf9c0, 0xc82c,	0xffff, 0xc82c,		0x21, 0
	.dw 0x0040, 0xc82d,	0x007f, 0xc82d,		0x21, 0
	.dw 0x00c0, 0xc82d,	0x00ff, 0xc82d,		0x21, 0
	.dw 0x0140, 0xc82d,	0x017f, 0xc82d,		0x21, 0
	.dw 0x01c0, 0xc82d,	0x01ff, 0xc82d,		0x21, 0
	.dw 0x0240, 0xc82d,	0x027f, 0xc82d,		0x21, 0
	.dw 0x02c0, 0xc82d,	0x02ff, 0xc82d,		0x21, 0
	.dw 0x0340, 0xc82d,	0x037f, 0xc82d,		0x21, 0
	.dw 0x03c0, 0xc82d,	0x03ff, 0xc82d,		0x21, 0
	.dw 0x0440, 0xc82d,	0x047f, 0xc82d,		0x21, 0
	.dw 0x04c0, 0xc82d,	0x04ff, 0xc82d,		0x21, 0
	.dw 0x0540, 0xc82d,	0x057f, 0xc82d,		0x21, 0
	.dw 0x05c0, 0xc82d,	0x05ff, 0xc82d,		0x21, 0
	.dw 0x0640, 0xc82d,	0x067f, 0xc82d,		0x21, 0
	.dw 0x06c0, 0xc82d,	0x06ff, 0xc82d,		0x21, 0
	.dw 0x0740, 0xc82d,	0x077f, 0xc82d,		0x21, 0
	.dw 0x07c0, 0xc82d,	0x07ff, 0xc82d,		0x21, 0
	.dw 0x0840, 0xc82d,	0x087f, 0xc82d,		0x21, 0
	.dw 0x08c0, 0xc82d,	0x08ff, 0xc82d,		0x21, 0
	.dw 0x0940, 0xc82d,	0x097f, 0xc82d,		0x21, 0
	.dw 0x09c0, 0xc82d,	0x09ff, 0xc82d,		0x21, 0
	.dw 0x0a40, 0xc82d,	0x0a7f, 0xc82d,		0x21, 0
	.dw 0x0ac0, 0xc82d,	0x0aff, 0xc82d,		0x21, 0
	.dw 0x0b40, 0xc82d,	0x0b7f, 0xc82d,		0x21, 0
	.dw 0x0bc0, 0xc82d,	0x0bff, 0xc82d,		0x21, 0
	.dw 0x0c40, 0xc82d,	0x0c7f, 0xc82d,		0x21, 0
	.dw 0x0cc0, 0xc82d,	0x0cff, 0xc82d,		0x21, 0
	.dw 0x0d40, 0xc82d,	0x0d7f, 0xc82d,		0x21, 0
	.dw 0x0dc0, 0xc82d,	0x0dff, 0xc82d,		0x21, 0
	.dw 0x0e40, 0xc82d,	0x0e7f, 0xc82d,		0x21, 0
	.dw 0x0ec0, 0xc82d,	0x0eff, 0xc82d,		0x21, 0
	.dw 0x0f40, 0xc82d,	0x0f7f, 0xc82d,		0x21, 0
	.dw 0x0fc0, 0xc82d,	0x0fff, 0xc82d,		0x21, 0
	.dw 0x1040, 0xc82d,	0x107f, 0xc82d,		0x21, 0
	.dw 0x10c0, 0xc82d,	0x10ff, 0xc82d,		0x21, 0
	.dw 0x1140, 0xc82d,	0x117f, 0xc82d,		0x21, 0
	.dw 0x11c0, 0xc82d,	0x11ff, 0xc82d,		0x21, 0
	.dw 0x1240, 0xc82d,	0x127f, 0xc82d,		0x21, 0
	.dw 0x12c0, 0xc82d,	0x12ff, 0xc82d,		0x21, 0
	.dw 0x1340, 0xc82d,	0x137f, 0xc82d,		0x21, 0
	.dw 0x13c0, 0xc82d,	0x13ff, 0xc82d,		0x21, 0
	.dw 0x1440, 0xc82d,	0x147f, 0xc82d,		0x21, 0
	.dw 0x14c0, 0xc82d,	0x14ff, 0xc82d,		0x21, 0
	.dw 0x1540, 0xc82d,	0x157f, 0xc82d,		0x21, 0
	.dw 0x15c0, 0xc82d,	0x15ff, 0xc82d,		0x21, 0
	.dw 0x1640, 0xc82d,	0x167f, 0xc82d,		0x21, 0
	.dw 0x16c0, 0xc82d,	0x16ff, 0xc82d,		0x21, 0
	.dw 0x1740, 0xc82d,	0x177f, 0xc82d,		0x21, 0
	.dw 0x17c0, 0xc82d,	0x17ff, 0xc82d,		0x21, 0
	.dw 0x1840, 0xc82d,	0x187f, 0xc82d,		0x21, 0
	.dw 0x18c0, 0xc82d,	0x18ff, 0xc82d,		0x21, 0
	.dw 0x1940, 0xc82d,	0x197f, 0xc82d,		0x21, 0
	.dw 0x19c0, 0xc82d,	0x1fff, 0xc82d,		0x21, 0
	.dw 0x2040, 0xc82d,	0x207f, 0xc82d,		0x21, 0
	.dw 0x20c0, 0xc82d,	0x20ff, 0xc82d,		0x21, 0
	.dw 0x2140, 0xc82d,	0x217f, 0xc82d,		0x21, 0
	.dw 0x21c0, 0xc82d,	0x21ff, 0xc82d,		0x21, 0
	.dw 0x2240, 0xc82d,	0x227f, 0xc82d,		0x21, 0
	.dw 0x22c0, 0xc82d,	0x22ff, 0xc82d,		0x21, 0
	.dw 0x2340, 0xc82d,	0x237f, 0xc82d,		0x21, 0
	.dw 0x23c0, 0xc82d,	0x23ff, 0xc82d,		0x21, 0
	.dw 0x2440, 0xc82d,	0x247f, 0xc82d,		0x21, 0
	.dw 0x24c0, 0xc82d,	0x24ff, 0xc82d,		0x21, 0
	.dw 0x2540, 0xc82d,	0x257f, 0xc82d,		0x21, 0
	.dw 0x25c0, 0xc82d,	0x25ff, 0xc82d,		0x21, 0
	.dw 0x2640, 0xc82d,	0x267f, 0xc82d,		0x21, 0
	.dw 0x26c0, 0xc82d,	0x26ff, 0xc82d,		0x21, 0
	.dw 0x2740, 0xc82d,	0x277f, 0xc82d,		0x21, 0
	.dw 0x27c0, 0xc82d,	0x27ff, 0xc82d,		0x21, 0
	.dw 0x2840, 0xc82d,	0x287f, 0xc82d,		0x21, 0
	.dw 0x28c0, 0xc82d,	0x28ff, 0xc82d,		0x21, 0
	.dw 0x2940, 0xc82d,	0x297f, 0xc82d,		0x21, 0
	.dw 0x29c0, 0xc82d,	0x29ff, 0xc82d,		0x21, 0
	.dw 0x2a40, 0xc82d,	0x2a7f, 0xc82d,		0x21, 0
	.dw 0x2ac0, 0xc82d,	0x2aff, 0xc82d,		0x21, 0
	.dw 0x2b40, 0xc82d,	0x2b7f, 0xc82d,		0x21, 0
	.dw 0x2bc0, 0xc82d,	0x2bff, 0xc82d,		0x21, 0
	.dw 0x2c40, 0xc82d,	0x2c7f, 0xc82d,		0x21, 0
	.dw 0x2cc0, 0xc82d,	0x2cff, 0xc82d,		0x21, 0
	.dw 0x2d40, 0xc82d,	0x2d7f, 0xc82d,		0x21, 0
	.dw 0x2dc0, 0xc82d,	0x2dff, 0xc82d,		0x21, 0
	.dw 0x2e40, 0xc82d,	0x2e7f, 0xc82d,		0x21, 0
	.dw 0x2ec0, 0xc82d,	0x2eff, 0xc82d,		0x21, 0
	.dw 0x2f40, 0xc82d,	0x2f7f, 0xc82d,		0x21, 0
	.dw 0x2fc0, 0xc82d,	0x2fff, 0xc82d,		0x21, 0
	.dw 0x3040, 0xc82d,	0x307f, 0xc82d,		0x21, 0
	.dw 0x30c0, 0xc82d,	0x30ff, 0xc82d,		0x21, 0
	.dw 0x3140, 0xc82d,	0x317f, 0xc82d,		0x21, 0
	.dw 0x31c0, 0xc82d,	0x31ff, 0xc82d,		0x21, 0
	.dw 0x3240, 0xc82d,	0x327f, 0xc82d,		0x21, 0
	.dw 0x32c0, 0xc82d,	0x32ff, 0xc82d,		0x21, 0
	.dw 0x3340, 0xc82d,	0x337f, 0xc82d,		0x21, 0
	.dw 0x33c0, 0xc82d,	0x33ff, 0xc82d,		0x21, 0
	.dw 0x3440, 0xc82d,	0x347f, 0xc82d,		0x21, 0
	.dw 0x34c0, 0xc82d,	0x34ff, 0xc82d,		0x21, 0
	.dw 0x3540, 0xc82d,	0x357f, 0xc82d,		0x21, 0
	.dw 0x35c0, 0xc82d,	0x35ff, 0xc82d,		0x21, 0
	.dw 0x3640, 0xc82d,	0x367f, 0xc82d,		0x21, 0
	.dw 0x36c0, 0xc82d,	0x36ff, 0xc82d,		0x21, 0
	.dw 0x3740, 0xc82d,	0x377f, 0xc82d,		0x21, 0
	.dw 0x37c0, 0xc82d,	0x37ff, 0xc82d,		0x21, 0
	.dw 0x3840, 0xc82d,	0x387f, 0xc82d,		0x21, 0
	.dw 0x38c0, 0xc82d,	0x38ff, 0xc82d,		0x21, 0
	.dw 0x3940, 0xc82d,	0x397f, 0xc82d,		0x21, 0
	.dw 0x39c0, 0xc82d,	0x3fff, 0xc82d,		0x21, 0
	.dw 0x4040, 0xc82d,	0x407f, 0xc82d,		0x21, 0
	.dw 0x40c0, 0xc82d,	0x40ff, 0xc82d,		0x21, 0
	.dw 0x4140, 0xc82d,	0x417f, 0xc82d,		0x21, 0
	.dw 0x41c0, 0xc82d,	0x41ff, 0xc82d,		0x21, 0
	.dw 0x4240, 0xc82d,	0x427f, 0xc82d,		0x21, 0
	.dw 0x42c0, 0xc82d,	0x42ff, 0xc82d,		0x21, 0
	.dw 0x4340, 0xc82d,	0x437f, 0xc82d,		0x21, 0
	.dw 0x43c0, 0xc82d,	0x43ff, 0xc82d,		0x21, 0
	.dw 0x4440, 0xc82d,	0x447f, 0xc82d,		0x21, 0
	.dw 0x44c0, 0xc82d,	0x44ff, 0xc82d,		0x21, 0
	.dw 0x4540, 0xc82d,	0x457f, 0xc82d,		0x21, 0
	.dw 0x45c0, 0xc82d,	0x45ff, 0xc82d,		0x21, 0
	.dw 0x4640, 0xc82d,	0x467f, 0xc82d,		0x21, 0
	.dw 0x46c0, 0xc82d,	0x46ff, 0xc82d,		0x21, 0
	.dw 0x4740, 0xc82d,	0x477f, 0xc82d,		0x21, 0
	.dw 0x47c0, 0xc82d,	0x47ff, 0xc82d,		0x21, 0
	.dw 0x4840, 0xc82d,	0x487f, 0xc82d,		0x21, 0
	.dw 0x48c0, 0xc82d,	0x48ff, 0xc82d,		0x21, 0
	.dw 0x4940, 0xc82d,	0x497f, 0xc82d,		0x21, 0
	.dw 0x49c0, 0xc82d,	0x49ff, 0xc82d,		0x21, 0
	.dw 0x4a40, 0xc82d,	0x4a7f, 0xc82d,		0x21, 0
	.dw 0x4ac0, 0xc82d,	0x4aff, 0xc82d,		0x21, 0
	.dw 0x4b40, 0xc82d,	0x4b7f, 0xc82d,		0x21, 0
	.dw 0x4bc0, 0xc82d,	0x4bff, 0xc82d,		0x21, 0
	.dw 0x4c40, 0xc82d,	0x4c7f, 0xc82d,		0x21, 0
	.dw 0x4cc0, 0xc82d,	0x4cff, 0xc82d,		0x21, 0
	.dw 0x4d40, 0xc82d,	0x4d7f, 0xc82d,		0x21, 0
	.dw 0x4dc0, 0xc82d,	0x4dff, 0xc82d,		0x21, 0
	.dw 0x4e40, 0xc82d,	0x4e7f, 0xc82d,		0x21, 0
	.dw 0x4ec0, 0xc82d,	0x4eff, 0xc82d,		0x21, 0
	.dw 0x4f40, 0xc82d,	0x4f7f, 0xc82d,		0x21, 0
	.dw 0x4fc0, 0xc82d,	0x4fff, 0xc82d,		0x21, 0
	.dw 0x5040, 0xc82d,	0x507f, 0xc82d,		0x21, 0
	.dw 0x50c0, 0xc82d,	0x50ff, 0xc82d,		0x21, 0
	.dw 0x5140, 0xc82d,	0x517f, 0xc82d,		0x21, 0
	.dw 0x51c0, 0xc82d,	0x51ff, 0xc82d,		0x21, 0
	.dw 0x5240, 0xc82d,	0x527f, 0xc82d,		0x21, 0
	.dw 0x52c0, 0xc82d,	0x52ff, 0xc82d,		0x21, 0
	.dw 0x5340, 0xc82d,	0x537f, 0xc82d,		0x21, 0
	.dw 0x53c0, 0xc82d,	0x53ff, 0xc82d,		0x21, 0
	.dw 0x5440, 0xc82d,	0x547f, 0xc82d,		0x21, 0
	.dw 0x54c0, 0xc82d,	0x54ff, 0xc82d,		0x21, 0
	.dw 0x5540, 0xc82d,	0x557f, 0xc82d,		0x21, 0
	.dw 0x55c0, 0xc82d,	0x55ff, 0xc82d,		0x21, 0
	.dw 0x5640, 0xc82d,	0x567f, 0xc82d,		0x21, 0
	.dw 0x56c0, 0xc82d,	0x56ff, 0xc82d,		0x21, 0
	.dw 0x5740, 0xc82d,	0x577f, 0xc82d,		0x21, 0
	.dw 0x57c0, 0xc82d,	0x57ff, 0xc82d,		0x21, 0
	.dw 0x5840, 0xc82d,	0x587f, 0xc82d,		0x21, 0
	.dw 0x58c0, 0xc82d,	0x58ff, 0xc82d,		0x21, 0
	.dw 0x5940, 0xc82d,	0x597f, 0xc82d,		0x21, 0
	.dw 0x59c0, 0xc82d,	0x5fff, 0xc82d,		0x21, 0
	.dw 0x6040, 0xc82d,	0x607f, 0xc82d,		0x21, 0
	.dw 0x60c0, 0xc82d,	0x60ff, 0xc82d,		0x21, 0
	.dw 0x6140, 0xc82d,	0x617f, 0xc82d,		0x21, 0
	.dw 0x61c0, 0xc82d,	0x61ff, 0xc82d,		0x21, 0
	.dw 0x6240, 0xc82d,	0x627f, 0xc82d,		0x21, 0
	.dw 0x62c0, 0xc82d,	0x62ff, 0xc82d,		0x21, 0
	.dw 0x6340, 0xc82d,	0x637f, 0xc82d,		0x21, 0
	.dw 0x63c0, 0xc82d,	0x63ff, 0xc82d,		0x21, 0
	.dw 0x6440, 0xc82d,	0x647f, 0xc82d,		0x21, 0
	.dw 0x64c0, 0xc82d,	0x64ff, 0xc82d,		0x21, 0
	.dw 0x6540, 0xc82d,	0x657f, 0xc82d,		0x21, 0
	.dw 0x65c0, 0xc82d,	0x65ff, 0xc82d,		0x21, 0
	.dw 0x6640, 0xc82d,	0x667f, 0xc82d,		0x21, 0
	.dw 0x66c0, 0xc82d,	0x66ff, 0xc82d,		0x21, 0
	.dw 0x6740, 0xc82d,	0x677f, 0xc82d,		0x21, 0
	.dw 0x67c0, 0xc82d,	0x67ff, 0xc82d,		0x21, 0
	.dw 0x6840, 0xc82d,	0x687f, 0xc82d,		0x21, 0
	.dw 0x68c0, 0xc82d,	0x68ff, 0xc82d,		0x21, 0
	.dw 0x6940, 0xc82d,	0x697f, 0xc82d,		0x21, 0
	.dw 0x69c0, 0xc82d,	0x69ff, 0xc82d,		0x21, 0
	.dw 0x6a40, 0xc82d,	0x6a7f, 0xc82d,		0x21, 0
	.dw 0x6ac0, 0xc82d,	0x6aff, 0xc82d,		0x21, 0
	.dw 0x6b40, 0xc82d,	0x6b7f, 0xc82d,		0x21, 0
	.dw 0x6bc0, 0xc82d,	0x6bff, 0xc82d,		0x21, 0
	.dw 0x6c40, 0xc82d,	0x6c7f, 0xc82d,		0x21, 0
	.dw 0x6cc0, 0xc82d,	0x6cff, 0xc82d,		0x21, 0
	.dw 0x6d40, 0xc82d,	0x6d7f, 0xc82d,		0x21, 0
	.dw 0x6dc0, 0xc82d,	0x6dff, 0xc82d,		0x21, 0
	.dw 0x6e40, 0xc82d,	0x6e7f, 0xc82d,		0x21, 0
	.dw 0x6ec0, 0xc82d,	0x6eff, 0xc82d,		0x21, 0
	.dw 0x6f40, 0xc82d,	0x6f7f, 0xc82d,		0x21, 0
	.dw 0x6fc0, 0xc82d,	0x6fff, 0xc82d,		0x21, 0
	.dw 0x7040, 0xc82d,	0x707f, 0xc82d,		0x21, 0
	.dw 0x70c0, 0xc82d,	0x70ff, 0xc82d,		0x21, 0
	.dw 0x7140, 0xc82d,	0x717f, 0xc82d,		0x21, 0
	.dw 0x71c0, 0xc82d,	0x71ff, 0xc82d,		0x21, 0
	.dw 0x7240, 0xc82d,	0x727f, 0xc82d,		0x21, 0
	.dw 0x72c0, 0xc82d,	0x72ff, 0xc82d,		0x21, 0
	.dw 0x7340, 0xc82d,	0x737f, 0xc82d,		0x21, 0
	.dw 0x73c0, 0xc82d,	0x73ff, 0xc82d,		0x21, 0
	.dw 0x7440, 0xc82d,	0x747f, 0xc82d,		0x21, 0
	.dw 0x74c0, 0xc82d,	0x74ff, 0xc82d,		0x21, 0
	.dw 0x7540, 0xc82d,	0x757f, 0xc82d,		0x21, 0
	.dw 0x75c0, 0xc82d,	0x75ff, 0xc82d,		0x21, 0
	.dw 0x7640, 0xc82d,	0x767f, 0xc82d,		0x21, 0
	.dw 0x76c0, 0xc82d,	0x76ff, 0xc82d,		0x21, 0
	.dw 0x7740, 0xc82d,	0x777f, 0xc82d,		0x21, 0
	.dw 0x77c0, 0xc82d,	0x77ff, 0xc82d,		0x21, 0
	.dw 0x7840, 0xc82d,	0x787f, 0xc82d,		0x21, 0
	.dw 0x78c0, 0xc82d,	0x78ff, 0xc82d,		0x21, 0
	.dw 0x7940, 0xc82d,	0x797f, 0xc82d,		0x21, 0
	.dw 0x79c0, 0xc82d,	0x7fff, 0xc82d,		0x21, 0
	.dw 0x8040, 0xc82d,	0x807f, 0xc82d,		0x21, 0
	.dw 0x80c0, 0xc82d,	0x80ff, 0xc82d,		0x21, 0
	.dw 0x8140, 0xc82d,	0x817f, 0xc82d,		0x21, 0
	.dw 0x81c0, 0xc82d,	0x81ff, 0xc82d,		0x21, 0
	.dw 0x8240, 0xc82d,	0x827f, 0xc82d,		0x21, 0
	.dw 0x82c0, 0xc82d,	0x82ff, 0xc82d,		0x21, 0
	.dw 0x8340, 0xc82d,	0x837f, 0xc82d,		0x21, 0
	.dw 0x83c0, 0xc82d,	0x83ff, 0xc82d,		0x21, 0
	.dw 0x8440, 0xc82d,	0x847f, 0xc82d,		0x21, 0
	.dw 0x84c0, 0xc82d,	0x84ff, 0xc82d,		0x21, 0
	.dw 0x8540, 0xc82d,	0x857f, 0xc82d,		0x21, 0
	.dw 0x85c0, 0xc82d,	0x85ff, 0xc82d,		0x21, 0
	.dw 0x8640, 0xc82d,	0x867f, 0xc82d,		0x21, 0
	.dw 0x86c0, 0xc82d,	0x86ff, 0xc82d,		0x21, 0
	.dw 0x8740, 0xc82d,	0x877f, 0xc82d,		0x21, 0
	.dw 0x87c0, 0xc82d,	0x87ff, 0xc82d,		0x21, 0
	.dw 0x8840, 0xc82d,	0x887f, 0xc82d,		0x21, 0
	.dw 0x88c0, 0xc82d,	0x88ff, 0xc82d,		0x21, 0
	.dw 0x8940, 0xc82d,	0x897f, 0xc82d,		0x21, 0
	.dw 0x89c0, 0xc82d,	0x89ff, 0xc82d,		0x21, 0
	.dw 0x8a40, 0xc82d,	0x8a7f, 0xc82d,		0x21, 0
	.dw 0x8ac0, 0xc82d,	0x8aff, 0xc82d,		0x21, 0
	.dw 0x8b40, 0xc82d,	0x8b7f, 0xc82d,		0x21, 0
	.dw 0x8bc0, 0xc82d,	0x8bff, 0xc82d,		0x21, 0
	.dw 0x8c40, 0xc82d,	0x8c7f, 0xc82d,		0x21, 0
	.dw 0x8cc0, 0xc82d,	0x8cff, 0xc82d,		0x21, 0
	.dw 0x8d40, 0xc82d,	0x8d7f, 0xc82d,		0x21, 0
	.dw 0x8dc0, 0xc82d,	0x8dff, 0xc82d,		0x21, 0
	.dw 0x8e40, 0xc82d,	0x8e7f, 0xc82d,		0x21, 0
	.dw 0x8ec0, 0xc82d,	0x8eff, 0xc82d,		0x21, 0
	.dw 0x8f40, 0xc82d,	0x8f7f, 0xc82d,		0x21, 0
	.dw 0x8fc0, 0xc82d,	0x8fff, 0xc82d,		0x21, 0
	.dw 0x9040, 0xc82d,	0x907f, 0xc82d,		0x21, 0
	.dw 0x90c0, 0xc82d,	0x90ff, 0xc82d,		0x21, 0
	.dw 0x9140, 0xc82d,	0x917f, 0xc82d,		0x21, 0
	.dw 0x91c0, 0xc82d,	0x91ff, 0xc82d,		0x21, 0
	.dw 0x9240, 0xc82d,	0x927f, 0xc82d,		0x21, 0
	.dw 0x92c0, 0xc82d,	0x92ff, 0xc82d,		0x21, 0
	.dw 0x9340, 0xc82d,	0x937f, 0xc82d,		0x21, 0
	.dw 0x93c0, 0xc82d,	0x93ff, 0xc82d,		0x21, 0
	.dw 0x9440, 0xc82d,	0x947f, 0xc82d,		0x21, 0
	.dw 0x94c0, 0xc82d,	0x94ff, 0xc82d,		0x21, 0
	.dw 0x9540, 0xc82d,	0x957f, 0xc82d,		0x21, 0
	.dw 0x95c0, 0xc82d,	0x95ff, 0xc82d,		0x21, 0
	.dw 0x9640, 0xc82d,	0x967f, 0xc82d,		0x21, 0
	.dw 0x96c0, 0xc82d,	0x96ff, 0xc82d,		0x21, 0
	.dw 0x9740, 0xc82d,	0x977f, 0xc82d,		0x21, 0
	.dw 0x97c0, 0xc82d,	0x97ff, 0xc82d,		0x21, 0
	.dw 0x9840, 0xc82d,	0x987f, 0xc82d,		0x21, 0
	.dw 0x98c0, 0xc82d,	0x98ff, 0xc82d,		0x21, 0
	.dw 0x9940, 0xc82d,	0x997f, 0xc82d,		0x21, 0
	.dw 0x99c0, 0xc82d,	0x9fff, 0xc82d,		0x21, 0
	.dw 0xa040, 0xc82d,	0xa07f, 0xc82d,		0x21, 0
	.dw 0xa0c0, 0xc82d,	0xa0ff, 0xc82d,		0x21, 0
	.dw 0xa140, 0xc82d,	0xa17f, 0xc82d,		0x21, 0
	.dw 0xa1c0, 0xc82d,	0xa1ff, 0xc82d,		0x21, 0
	.dw 0xa240, 0xc82d,	0xa27f, 0xc82d,		0x21, 0
	.dw 0xa2c0, 0xc82d,	0xa2ff, 0xc82d,		0x21, 0
	.dw 0xa340, 0xc82d,	0xa37f, 0xc82d,		0x21, 0
	.dw 0xa3c0, 0xc82d,	0xa3ff, 0xc82d,		0x21, 0
	.dw 0xa440, 0xc82d,	0xa47f, 0xc82d,		0x21, 0
	.dw 0xa4c0, 0xc82d,	0xa4ff, 0xc82d,		0x21, 0
	.dw 0xa540, 0xc82d,	0xa57f, 0xc82d,		0x21, 0
	.dw 0xa5c0, 0xc82d,	0xa5ff, 0xc82d,		0x21, 0
	.dw 0xa640, 0xc82d,	0xa67f, 0xc82d,		0x21, 0
	.dw 0xa6c0, 0xc82d,	0xa6ff, 0xc82d,		0x21, 0
	.dw 0xa740, 0xc82d,	0xa77f, 0xc82d,		0x21, 0
	.dw 0xa7c0, 0xc82d,	0xa7ff, 0xc82d,		0x21, 0
	.dw 0xa840, 0xc82d,	0xa87f, 0xc82d,		0x21, 0
	.dw 0xa8c0, 0xc82d,	0xa8ff, 0xc82d,		0x21, 0
	.dw 0xa940, 0xc82d,	0xa97f, 0xc82d,		0x21, 0
	.dw 0xa9c0, 0xc82d,	0xa9ff, 0xc82d,		0x21, 0
	.dw 0xaa40, 0xc82d,	0xaa7f, 0xc82d,		0x21, 0
	.dw 0xaac0, 0xc82d,	0xaaff, 0xc82d,		0x21, 0
	.dw 0xab40, 0xc82d,	0xab7f, 0xc82d,		0x21, 0
	.dw 0xabc0, 0xc82d,	0xabff, 0xc82d,		0x21, 0
	.dw 0xac40, 0xc82d,	0xac7f, 0xc82d,		0x21, 0
	.dw 0xacc0, 0xc82d,	0xacff, 0xc82d,		0x21, 0
	.dw 0xad40, 0xc82d,	0xad7f, 0xc82d,		0x21, 0
	.dw 0xadc0, 0xc82d,	0xadff, 0xc82d,		0x21, 0
	.dw 0xae40, 0xc82d,	0xae7f, 0xc82d,		0x21, 0
	.dw 0xaec0, 0xc82d,	0xaeff, 0xc82d,		0x21, 0
	.dw 0xaf40, 0xc82d,	0xaf7f, 0xc82d,		0x21, 0
	.dw 0xafc0, 0xc82d,	0xafff, 0xc82d,		0x21, 0
	.dw 0xb040, 0xc82d,	0xb07f, 0xc82d,		0x21, 0
	.dw 0xb0c0, 0xc82d,	0xb0ff, 0xc82d,		0x21, 0
	.dw 0xb140, 0xc82d,	0xb17f, 0xc82d,		0x21, 0
	.dw 0xb1c0, 0xc82d,	0xb1ff, 0xc82d,		0x21, 0
	.dw 0xb240, 0xc82d,	0xb27f, 0xc82d,		0x21, 0
	.dw 0xb2c0, 0xc82d,	0xb2ff, 0xc82d,		0x21, 0
	.dw 0xb340, 0xc82d,	0xb37f, 0xc82d,		0x21, 0
	.dw 0xb3c0, 0xc82d,	0xb3ff, 0xc82d,		0x21, 0
	.dw 0xb440, 0xc82d,	0xb47f, 0xc82d,		0x21, 0
	.dw 0xb4c0, 0xc82d,	0xb4ff, 0xc82d,		0x21, 0
	.dw 0xb540, 0xc82d,	0xb57f, 0xc82d,		0x21, 0
	.dw 0xb5c0, 0xc82d,	0xb5ff, 0xc82d,		0x21, 0
	.dw 0xb640, 0xc82d,	0xb67f, 0xc82d,		0x21, 0
	.dw 0xb6c0, 0xc82d,	0xb6ff, 0xc82d,		0x21, 0
	.dw 0xb740, 0xc82d,	0xb77f, 0xc82d,		0x21, 0
	.dw 0xb7c0, 0xc82d,	0xb7ff, 0xc82d,		0x21, 0
	.dw 0xb840, 0xc82d,	0xb87f, 0xc82d,		0x21, 0
	.dw 0xb8c0, 0xc82d,	0xb8ff, 0xc82d,		0x21, 0
	.dw 0xb940, 0xc82d,	0xb97f, 0xc82d,		0x21, 0
	.dw 0xb9c0, 0xc82d,	0xbfff, 0xc82d,		0x21, 0
	.dw 0xc040, 0xc82d,	0xc07f, 0xc82d,		0x21, 0
	.dw 0xc0c0, 0xc82d,	0xc0ff, 0xc82d,		0x21, 0
	.dw 0xc140, 0xc82d,	0xc17f, 0xc82d,		0x21, 0
	.dw 0xc1c0, 0xc82d,	0xc1ff, 0xc82d,		0x21, 0
	.dw 0xc240, 0xc82d,	0xc27f, 0xc82d,		0x21, 0
	.dw 0xc2c0, 0xc82d,	0xc2ff, 0xc82d,		0x21, 0
	.dw 0xc340, 0xc82d,	0xc37f, 0xc82d,		0x21, 0
	.dw 0xc3c0, 0xc82d,	0xc3ff, 0xc82d,		0x21, 0
	.dw 0xc440, 0xc82d,	0xc47f, 0xc82d,		0x21, 0
	.dw 0xc4c0, 0xc82d,	0xc4ff, 0xc82d,		0x21, 0
	.dw 0xc540, 0xc82d,	0xc57f, 0xc82d,		0x21, 0
	.dw 0xc5c0, 0xc82d,	0xc5ff, 0xc82d,		0x21, 0
	.dw 0xc640, 0xc82d,	0xc67f, 0xc82d,		0x21, 0
	.dw 0xc6c0, 0xc82d,	0xc6ff, 0xc82d,		0x21, 0
	.dw 0xc740, 0xc82d,	0xc77f, 0xc82d,		0x21, 0
	.dw 0xc7c0, 0xc82d,	0xc7ff, 0xc82d,		0x21, 0
	.dw 0xc840, 0xc82d,	0xc87f, 0xc82d,		0x21, 0
	.dw 0xc8c0, 0xc82d,	0xc8ff, 0xc82d,		0x21, 0
	.dw 0xc940, 0xc82d,	0xc97f, 0xc82d,		0x21, 0
	.dw 0xc9c0, 0xc82d,	0xc9ff, 0xc82d,		0x21, 0
	.dw 0xca40, 0xc82d,	0xca7f, 0xc82d,		0x21, 0
	.dw 0xcac0, 0xc82d,	0xcaff, 0xc82d,		0x21, 0
	.dw 0xcb40, 0xc82d,	0xcb7f, 0xc82d,		0x21, 0
	.dw 0xcbc0, 0xc82d,	0xcbff, 0xc82d,		0x21, 0
	.dw 0xcc40, 0xc82d,	0xcc7f, 0xc82d,		0x21, 0
	.dw 0xccc0, 0xc82d,	0xccff, 0xc82d,		0x21, 0
	.dw 0xcd40, 0xc82d,	0xcd7f, 0xc82d,		0x21, 0
	.dw 0xcdc0, 0xc82d,	0xcdff, 0xc82d,		0x21, 0
	.dw 0xce40, 0xc82d,	0xce7f, 0xc82d,		0x21, 0
	.dw 0xcec0, 0xc82d,	0xceff, 0xc82d,		0x21, 0
	.dw 0xcf40, 0xc82d,	0xcf7f, 0xc82d,		0x21, 0
	.dw 0xcfc0, 0xc82d,	0xcfff, 0xc82d,		0x21, 0
	.dw 0xd040, 0xc82d,	0xd07f, 0xc82d,		0x21, 0
	.dw 0xd0c0, 0xc82d,	0xd0ff, 0xc82d,		0x21, 0
	.dw 0xd140, 0xc82d,	0xd17f, 0xc82d,		0x21, 0
	.dw 0xd1c0, 0xc82d,	0xd1ff, 0xc82d,		0x21, 0
	.dw 0xd240, 0xc82d,	0xd27f, 0xc82d,		0x21, 0
	.dw 0xd2c0, 0xc82d,	0xd2ff, 0xc82d,		0x21, 0
	.dw 0xd340, 0xc82d,	0xd37f, 0xc82d,		0x21, 0
	.dw 0xd3c0, 0xc82d,	0xd3ff, 0xc82d,		0x21, 0
	.dw 0xd440, 0xc82d,	0xd47f, 0xc82d,		0x21, 0
	.dw 0xd4c0, 0xc82d,	0xd4ff, 0xc82d,		0x21, 0
	.dw 0xd540, 0xc82d,	0xd57f, 0xc82d,		0x21, 0
	.dw 0xd5c0, 0xc82d,	0xd5ff, 0xc82d,		0x21, 0
	.dw 0xd640, 0xc82d,	0xd67f, 0xc82d,		0x21, 0
	.dw 0xd6c0, 0xc82d,	0xd6ff, 0xc82d,		0x21, 0
	.dw 0xd740, 0xc82d,	0xd77f, 0xc82d,		0x21, 0
	.dw 0xd7c0, 0xc82d,	0xd7ff, 0xc82d,		0x21, 0
	.dw 0xd840, 0xc82d,	0xd87f, 0xc82d,		0x21, 0
	.dw 0xd8c0, 0xc82d,	0xd8ff, 0xc82d,		0x21, 0
	.dw 0xd940, 0xc82d,	0xd97f, 0xc82d,		0x21, 0
	.dw 0xd9c0, 0xc82d,	0xdfff, 0xc82d,		0x21, 0
	.dw 0xe040, 0xc82d,	0xe07f, 0xc82d,		0x21, 0
	.dw 0xe0c0, 0xc82d,	0xe0ff, 0xc82d,		0x21, 0
	.dw 0xe140, 0xc82d,	0xe17f, 0xc82d,		0x21, 0
	.dw 0xe1c0, 0xc82d,	0xe1ff, 0xc82d,		0x21, 0
	.dw 0xe240, 0xc82d,	0xe27f, 0xc82d,		0x21, 0
	.dw 0xe2c0, 0xc82d,	0xe2ff, 0xc82d,		0x21, 0
	.dw 0xe340, 0xc82d,	0xe37f, 0xc82d,		0x21, 0
	.dw 0xe3c0, 0xc82d,	0xe3ff, 0xc82d,		0x21, 0
	.dw 0xe440, 0xc82d,	0xe47f, 0xc82d,		0x21, 0
	.dw 0xe4c0, 0xc82d,	0xe4ff, 0xc82d,		0x21, 0
	.dw 0xe540, 0xc82d,	0xe57f, 0xc82d,		0x21, 0
	.dw 0xe5c0, 0xc82d,	0xe5ff, 0xc82d,		0x21, 0
	.dw 0xe640, 0xc82d,	0xe67f, 0xc82d,		0x21, 0
	.dw 0xe6c0, 0xc82d,	0xe6ff, 0xc82d,		0x21, 0
	.dw 0xe740, 0xc82d,	0xe77f, 0xc82d,		0x21, 0
	.dw 0xe7c0, 0xc82d,	0xe7ff, 0xc82d,		0x21, 0
	.dw 0xe840, 0xc82d,	0xe87f, 0xc82d,		0x21, 0
	.dw 0xe8c0, 0xc82d,	0xe8ff, 0xc82d,		0x21, 0
	.dw 0xe940, 0xc82d,	0xe97f, 0xc82d,		0x21, 0
	.dw 0xe9c0, 0xc82d,	0xe9ff, 0xc82d,		0x21, 0
	.dw 0xea40, 0xc82d,	0xea7f, 0xc82d,		0x21, 0
	.dw 0xeac0, 0xc82d,	0xeaff, 0xc82d,		0x21, 0
	.dw 0xeb40, 0xc82d,	0xeb7f, 0xc82d,		0x21, 0
	.dw 0xebc0, 0xc82d,	0xebff, 0xc82d,		0x21, 0
	.dw 0xec40, 0xc82d,	0xec7f, 0xc82d,		0x21, 0
	.dw 0xecc0, 0xc82d,	0xecff, 0xc82d,		0x21, 0
	.dw 0xed40, 0xc82d,	0xed7f, 0xc82d,		0x21, 0
	.dw 0xedc0, 0xc82d,	0xedff, 0xc82d,		0x21, 0
	.dw 0xee40, 0xc82d,	0xee7f, 0xc82d,		0x21, 0
	.dw 0xeec0, 0xc82d,	0xeeff, 0xc82d,		0x21, 0
	.dw 0xef40, 0xc82d,	0xef7f, 0xc82d,		0x21, 0
	.dw 0xefc0, 0xc82d,	0xefff, 0xc82d,		0x21, 0
	.dw 0xf040, 0xc82d,	0xf07f, 0xc82d,		0x21, 0
	.dw 0xf0c0, 0xc82d,	0xf0ff, 0xc82d,		0x21, 0
	.dw 0xf140, 0xc82d,	0xf17f, 0xc82d,		0x21, 0
	.dw 0xf1c0, 0xc82d,	0xf1ff, 0xc82d,		0x21, 0
	.dw 0xf240, 0xc82d,	0xf27f, 0xc82d,		0x21, 0
	.dw 0xf2c0, 0xc82d,	0xf2ff, 0xc82d,		0x21, 0
	.dw 0xf340, 0xc82d,	0xf37f, 0xc82d,		0x21, 0
	.dw 0xf3c0, 0xc82d,	0xf3ff, 0xc82d,		0x21, 0
	.dw 0xf440, 0xc82d,	0xf47f, 0xc82d,		0x21, 0
	.dw 0xf4c0, 0xc82d,	0xf4ff, 0xc82d,		0x21, 0
	.dw 0xf540, 0xc82d,	0xf57f, 0xc82d,		0x21, 0
	.dw 0xf5c0, 0xc82d,	0xf5ff, 0xc82d,		0x21, 0
	.dw 0xf640, 0xc82d,	0xf67f, 0xc82d,		0x21, 0
	.dw 0xf6c0, 0xc82d,	0xf6ff, 0xc82d,		0x21, 0
	.dw 0xf740, 0xc82d,	0xf77f, 0xc82d,		0x21, 0
	.dw 0xf7c0, 0xc82d,	0xf7ff, 0xc82d,		0x21, 0
	.dw 0xf840, 0xc82d,	0xf87f, 0xc82d,		0x21, 0
	.dw 0xf8c0, 0xc82d,	0xf8ff, 0xc82d,		0x21, 0
	.dw 0xf940, 0xc82d,	0xf97f, 0xc82d,		0x21, 0
	.dw 0xf9c0, 0xc82d,	0xffff, 0xc82d,		0x21, 0
	.dw 0x0040, 0xc82e,	0x007f, 0xc82e,		0x21, 0
	.dw 0x00c0, 0xc82e,	0x00ff, 0xc82e,		0x21, 0
	.dw 0x0140, 0xc82e,	0x017f, 0xc82e,		0x21, 0
	.dw 0x01c0, 0xc82e,	0x01ff, 0xc82e,		0x21, 0
	.dw 0x0240, 0xc82e,	0x027f, 0xc82e,		0x21, 0
	.dw 0x02c0, 0xc82e,	0x02ff, 0xc82e,		0x21, 0
	.dw 0x0340, 0xc82e,	0x037f, 0xc82e,		0x21, 0
	.dw 0x03c0, 0xc82e,	0x03ff, 0xc82e,		0x21, 0
	.dw 0x0440, 0xc82e,	0x047f, 0xc82e,		0x21, 0
	.dw 0x04c0, 0xc82e,	0x04ff, 0xc82e,		0x21, 0
	.dw 0x0540, 0xc82e,	0x057f, 0xc82e,		0x21, 0
	.dw 0x05c0, 0xc82e,	0x05ff, 0xc82e,		0x21, 0
	.dw 0x0640, 0xc82e,	0x067f, 0xc82e,		0x21, 0
	.dw 0x06c0, 0xc82e,	0x06ff, 0xc82e,		0x21, 0
	.dw 0x0740, 0xc82e,	0x077f, 0xc82e,		0x21, 0
	.dw 0x07c0, 0xc82e,	0x07ff, 0xc82e,		0x21, 0
	.dw 0x0840, 0xc82e,	0x087f, 0xc82e,		0x21, 0
	.dw 0x08c0, 0xc82e,	0x08ff, 0xc82e,		0x21, 0
	.dw 0x0940, 0xc82e,	0x097f, 0xc82e,		0x21, 0
	.dw 0x09c0, 0xc82e,	0x09ff, 0xc82e,		0x21, 0
	.dw 0x0a40, 0xc82e,	0x0a7f, 0xc82e,		0x21, 0
	.dw 0x0ac0, 0xc82e,	0x0aff, 0xc82e,		0x21, 0
	.dw 0x0b40, 0xc82e,	0x0b7f, 0xc82e,		0x21, 0
	.dw 0x0bc0, 0xc82e,	0x0bff, 0xc82e,		0x21, 0
	.dw 0x0c40, 0xc82e,	0x0c7f, 0xc82e,		0x21, 0
	.dw 0x0cc0, 0xc82e,	0x0cff, 0xc82e,		0x21, 0
	.dw 0x0d40, 0xc82e,	0x0d7f, 0xc82e,		0x21, 0
	.dw 0x0dc0, 0xc82e,	0x0dff, 0xc82e,		0x21, 0
	.dw 0x0e40, 0xc82e,	0x0e7f, 0xc82e,		0x21, 0
	.dw 0x0ec0, 0xc82e,	0x0eff, 0xc82e,		0x21, 0
	.dw 0x0f40, 0xc82e,	0x0f7f, 0xc82e,		0x21, 0
	.dw 0x0fc0, 0xc82e,	0x0fff, 0xc82e,		0x21, 0
	.dw 0x1040, 0xc82e,	0x107f, 0xc82e,		0x21, 0
	.dw 0x10c0, 0xc82e,	0x10ff, 0xc82e,		0x21, 0
	.dw 0x1140, 0xc82e,	0x117f, 0xc82e,		0x21, 0
	.dw 0x11c0, 0xc82e,	0x11ff, 0xc82e,		0x21, 0
	.dw 0x1240, 0xc82e,	0x127f, 0xc82e,		0x21, 0
	.dw 0x12c0, 0xc82e,	0x12ff, 0xc82e,		0x21, 0
	.dw 0x1340, 0xc82e,	0x137f, 0xc82e,		0x21, 0
	.dw 0x13c0, 0xc82e,	0x13ff, 0xc82e,		0x21, 0
	.dw 0x1440, 0xc82e,	0x147f, 0xc82e,		0x21, 0
	.dw 0x14c0, 0xc82e,	0x14ff, 0xc82e,		0x21, 0
	.dw 0x1540, 0xc82e,	0x157f, 0xc82e,		0x21, 0
	.dw 0x15c0, 0xc82e,	0x15ff, 0xc82e,		0x21, 0
	.dw 0x1640, 0xc82e,	0x167f, 0xc82e,		0x21, 0
	.dw 0x16c0, 0xc82e,	0x16ff, 0xc82e,		0x21, 0
	.dw 0x1740, 0xc82e,	0x177f, 0xc82e,		0x21, 0
	.dw 0x17c0, 0xc82e,	0x17ff, 0xc82e,		0x21, 0
	.dw 0x1840, 0xc82e,	0x187f, 0xc82e,		0x21, 0
	.dw 0x18c0, 0xc82e,	0x18ff, 0xc82e,		0x21, 0
	.dw 0x1940, 0xc82e,	0x197f, 0xc82e,		0x21, 0
	.dw 0x19c0, 0xc82e,	0x1fff, 0xc82e,		0x21, 0
	.dw 0x2040, 0xc82e,	0x207f, 0xc82e,		0x21, 0
	.dw 0x20c0, 0xc82e,	0x20ff, 0xc82e,		0x21, 0
	.dw 0x2140, 0xc82e,	0x217f, 0xc82e,		0x21, 0
	.dw 0x21c0, 0xc82e,	0x21ff, 0xc82e,		0x21, 0
	.dw 0x2240, 0xc82e,	0x227f, 0xc82e,		0x21, 0
	.dw 0x22c0, 0xc82e,	0x22ff, 0xc82e,		0x21, 0
	.dw 0x2340, 0xc82e,	0x237f, 0xc82e,		0x21, 0
	.dw 0x23c0, 0xc82e,	0x23ff, 0xc82e,		0x21, 0
	.dw 0x2440, 0xc82e,	0x247f, 0xc82e,		0x21, 0
	.dw 0x24c0, 0xc82e,	0x24ff, 0xc82e,		0x21, 0
	.dw 0x2540, 0xc82e,	0x257f, 0xc82e,		0x21, 0
	.dw 0x25c0, 0xc82e,	0x25ff, 0xc82e,		0x21, 0
	.dw 0x2640, 0xc82e,	0x267f, 0xc82e,		0x21, 0
	.dw 0x26c0, 0xc82e,	0x26ff, 0xc82e,		0x21, 0
	.dw 0x2740, 0xc82e,	0x277f, 0xc82e,		0x21, 0
	.dw 0x27c0, 0xc82e,	0x27ff, 0xc82e,		0x21, 0
	.dw 0x2840, 0xc82e,	0x287f, 0xc82e,		0x21, 0
	.dw 0x28c0, 0xc82e,	0x28ff, 0xc82e,		0x21, 0
	.dw 0x2940, 0xc82e,	0x297f, 0xc82e,		0x21, 0
	.dw 0x29c0, 0xc82e,	0x29ff, 0xc82e,		0x21, 0
	.dw 0x2a40, 0xc82e,	0x2a7f, 0xc82e,		0x21, 0
	.dw 0x2ac0, 0xc82e,	0x2aff, 0xc82e,		0x21, 0
	.dw 0x2b40, 0xc82e,	0x2b7f, 0xc82e,		0x21, 0
	.dw 0x2bc0, 0xc82e,	0x2bff, 0xc82e,		0x21, 0
	.dw 0x2c40, 0xc82e,	0x2c7f, 0xc82e,		0x21, 0
	.dw 0x2cc0, 0xc82e,	0x2cff, 0xc82e,		0x21, 0
	.dw 0x2d40, 0xc82e,	0x2d7f, 0xc82e,		0x21, 0
	.dw 0x2dc0, 0xc82e,	0x2dff, 0xc82e,		0x21, 0
	.dw 0x2e40, 0xc82e,	0x2e7f, 0xc82e,		0x21, 0
	.dw 0x2ec0, 0xc82e,	0x2eff, 0xc82e,		0x21, 0
	.dw 0x2f40, 0xc82e,	0x2f7f, 0xc82e,		0x21, 0
	.dw 0x2fc0, 0xc82e,	0x2fff, 0xc82e,		0x21, 0
	.dw 0x3040, 0xc82e,	0x307f, 0xc82e,		0x21, 0
	.dw 0x30c0, 0xc82e,	0x30ff, 0xc82e,		0x21, 0
	.dw 0x3140, 0xc82e,	0x317f, 0xc82e,		0x21, 0
	.dw 0x31c0, 0xc82e,	0x31ff, 0xc82e,		0x21, 0
	.dw 0x3240, 0xc82e,	0x327f, 0xc82e,		0x21, 0
	.dw 0x32c0, 0xc82e,	0x32ff, 0xc82e,		0x21, 0
	.dw 0x3340, 0xc82e,	0x337f, 0xc82e,		0x21, 0
	.dw 0x33c0, 0xc82e,	0x33ff, 0xc82e,		0x21, 0
	.dw 0x3440, 0xc82e,	0x347f, 0xc82e,		0x21, 0
	.dw 0x34c0, 0xc82e,	0x34ff, 0xc82e,		0x21, 0
	.dw 0x3540, 0xc82e,	0x357f, 0xc82e,		0x21, 0
	.dw 0x35c0, 0xc82e,	0x35ff, 0xc82e,		0x21, 0
	.dw 0x3640, 0xc82e,	0x367f, 0xc82e,		0x21, 0
	.dw 0x36c0, 0xc82e,	0x36ff, 0xc82e,		0x21, 0
	.dw 0x3740, 0xc82e,	0x377f, 0xc82e,		0x21, 0
	.dw 0x37c0, 0xc82e,	0x37ff, 0xc82e,		0x21, 0
	.dw 0x3840, 0xc82e,	0x387f, 0xc82e,		0x21, 0
	.dw 0x38c0, 0xc82e,	0x38ff, 0xc82e,		0x21, 0
	.dw 0x3940, 0xc82e,	0x397f, 0xc82e,		0x21, 0
	.dw 0x39c0, 0xc82e,	0x3fff, 0xc82e,		0x21, 0
	.dw 0x4040, 0xc82e,	0x407f, 0xc82e,		0x21, 0
	.dw 0x40c0, 0xc82e,	0x40ff, 0xc82e,		0x21, 0
	.dw 0x4140, 0xc82e,	0x417f, 0xc82e,		0x21, 0
	.dw 0x41c0, 0xc82e,	0x41ff, 0xc82e,		0x21, 0
	.dw 0x4240, 0xc82e,	0x427f, 0xc82e,		0x21, 0
	.dw 0x42c0, 0xc82e,	0x42ff, 0xc82e,		0x21, 0
	.dw 0x4340, 0xc82e,	0x437f, 0xc82e,		0x21, 0
	.dw 0x43c0, 0xc82e,	0x43ff, 0xc82e,		0x21, 0
	.dw 0x4440, 0xc82e,	0x447f, 0xc82e,		0x21, 0
	.dw 0x44c0, 0xc82e,	0x44ff, 0xc82e,		0x21, 0
	.dw 0x4540, 0xc82e,	0x457f, 0xc82e,		0x21, 0
	.dw 0x45c0, 0xc82e,	0x45ff, 0xc82e,		0x21, 0
	.dw 0x4640, 0xc82e,	0x467f, 0xc82e,		0x21, 0
	.dw 0x46c0, 0xc82e,	0x46ff, 0xc82e,		0x21, 0
	.dw 0x4740, 0xc82e,	0x477f, 0xc82e,		0x21, 0
	.dw 0x47c0, 0xc82e,	0x47ff, 0xc82e,		0x21, 0
	.dw 0x4840, 0xc82e,	0x487f, 0xc82e,		0x21, 0
	.dw 0x48c0, 0xc82e,	0x48ff, 0xc82e,		0x21, 0
	.dw 0x4940, 0xc82e,	0x497f, 0xc82e,		0x21, 0
	.dw 0x49c0, 0xc82e,	0x49ff, 0xc82e,		0x21, 0
	.dw 0x4a40, 0xc82e,	0x4a7f, 0xc82e,		0x21, 0
	.dw 0x4ac0, 0xc82e,	0x4aff, 0xc82e,		0x21, 0
	.dw 0x4b40, 0xc82e,	0x4b7f, 0xc82e,		0x21, 0
	.dw 0x4bc0, 0xc82e,	0x4bff, 0xc82e,		0x21, 0
	.dw 0x4c40, 0xc82e,	0x4c7f, 0xc82e,		0x21, 0
	.dw 0x4cc0, 0xc82e,	0x4cff, 0xc82e,		0x21, 0
	.dw 0x4d40, 0xc82e,	0x4d7f, 0xc82e,		0x21, 0
	.dw 0x4dc0, 0xc82e,	0x4dff, 0xc82e,		0x21, 0
	.dw 0x4e40, 0xc82e,	0x4e7f, 0xc82e,		0x21, 0
	.dw 0x4ec0, 0xc82e,	0x4eff, 0xc82e,		0x21, 0
	.dw 0x4f40, 0xc82e,	0x4f7f, 0xc82e,		0x21, 0
	.dw 0x4fc0, 0xc82e,	0x4fff, 0xc82e,		0x21, 0
	.dw 0x5040, 0xc82e,	0x507f, 0xc82e,		0x21, 0
	.dw 0x50c0, 0xc82e,	0x50ff, 0xc82e,		0x21, 0
	.dw 0x5140, 0xc82e,	0x517f, 0xc82e,		0x21, 0
	.dw 0x51c0, 0xc82e,	0x51ff, 0xc82e,		0x21, 0
	.dw 0x5240, 0xc82e,	0x527f, 0xc82e,		0x21, 0
	.dw 0x52c0, 0xc82e,	0x52ff, 0xc82e,		0x21, 0
	.dw 0x5340, 0xc82e,	0x537f, 0xc82e,		0x21, 0
	.dw 0x53c0, 0xc82e,	0x53ff, 0xc82e,		0x21, 0
	.dw 0x5440, 0xc82e,	0x547f, 0xc82e,		0x21, 0
	.dw 0x54c0, 0xc82e,	0x54ff, 0xc82e,		0x21, 0
	.dw 0x5540, 0xc82e,	0x557f, 0xc82e,		0x21, 0
	.dw 0x55c0, 0xc82e,	0x55ff, 0xc82e,		0x21, 0
	.dw 0x5640, 0xc82e,	0x567f, 0xc82e,		0x21, 0
	.dw 0x56c0, 0xc82e,	0x56ff, 0xc82e,		0x21, 0
	.dw 0x5740, 0xc82e,	0x577f, 0xc82e,		0x21, 0
	.dw 0x57c0, 0xc82e,	0x57ff, 0xc82e,		0x21, 0
	.dw 0x5840, 0xc82e,	0x587f, 0xc82e,		0x21, 0
	.dw 0x58c0, 0xc82e,	0x58ff, 0xc82e,		0x21, 0
	.dw 0x5940, 0xc82e,	0x597f, 0xc82e,		0x21, 0
	.dw 0x59c0, 0xc82e,	0x5fff, 0xc82e,		0x21, 0
	.dw 0x6040, 0xc82e,	0x607f, 0xc82e,		0x21, 0
	.dw 0x60c0, 0xc82e,	0x60ff, 0xc82e,		0x21, 0
	.dw 0x6140, 0xc82e,	0x617f, 0xc82e,		0x21, 0
	.dw 0x61c0, 0xc82e,	0x61ff, 0xc82e,		0x21, 0
	.dw 0x6240, 0xc82e,	0x627f, 0xc82e,		0x21, 0
	.dw 0x62c0, 0xc82e,	0x62ff, 0xc82e,		0x21, 0
	.dw 0x6340, 0xc82e,	0x637f, 0xc82e,		0x21, 0
	.dw 0x63c0, 0xc82e,	0x63ff, 0xc82e,		0x21, 0
	.dw 0x6440, 0xc82e,	0x647f, 0xc82e,		0x21, 0
	.dw 0x64c0, 0xc82e,	0x64ff, 0xc82e,		0x21, 0
	.dw 0x6540, 0xc82e,	0x657f, 0xc82e,		0x21, 0
	.dw 0x65c0, 0xc82e,	0x65ff, 0xc82e,		0x21, 0
	.dw 0x6640, 0xc82e,	0x667f, 0xc82e,		0x21, 0
	.dw 0x66c0, 0xc82e,	0x66ff, 0xc82e,		0x21, 0
	.dw 0x6740, 0xc82e,	0x677f, 0xc82e,		0x21, 0
	.dw 0x67c0, 0xc82e,	0x67ff, 0xc82e,		0x21, 0
	.dw 0x6840, 0xc82e,	0x687f, 0xc82e,		0x21, 0
	.dw 0x68c0, 0xc82e,	0x68ff, 0xc82e,		0x21, 0
	.dw 0x6940, 0xc82e,	0x697f, 0xc82e,		0x21, 0
	.dw 0x69c0, 0xc82e,	0x69ff, 0xc82e,		0x21, 0
	.dw 0x6a40, 0xc82e,	0x6a7f, 0xc82e,		0x21, 0
	.dw 0x6ac0, 0xc82e,	0x6aff, 0xc82e,		0x21, 0
	.dw 0x6b40, 0xc82e,	0x6b7f, 0xc82e,		0x21, 0
	.dw 0x6bc0, 0xc82e,	0x6bff, 0xc82e,		0x21, 0
	.dw 0x6c40, 0xc82e,	0x6c7f, 0xc82e,		0x21, 0
	.dw 0x6cc0, 0xc82e,	0x6cff, 0xc82e,		0x21, 0
	.dw 0x6d40, 0xc82e,	0x6d7f, 0xc82e,		0x21, 0
	.dw 0x6dc0, 0xc82e,	0x6dff, 0xc82e,		0x21, 0
	.dw 0x6e40, 0xc82e,	0x6e7f, 0xc82e,		0x21, 0
	.dw 0x6ec0, 0xc82e,	0x6eff, 0xc82e,		0x21, 0
	.dw 0x6f40, 0xc82e,	0x6f7f, 0xc82e,		0x21, 0
	.dw 0x6fc0, 0xc82e,	0x6fff, 0xc82e,		0x21, 0
	.dw 0x7040, 0xc82e,	0x707f, 0xc82e,		0x21, 0
	.dw 0x70c0, 0xc82e,	0x70ff, 0xc82e,		0x21, 0
	.dw 0x7140, 0xc82e,	0x717f, 0xc82e,		0x21, 0
	.dw 0x71c0, 0xc82e,	0x71ff, 0xc82e,		0x21, 0
	.dw 0x7240, 0xc82e,	0x727f, 0xc82e,		0x21, 0
	.dw 0x72c0, 0xc82e,	0x72ff, 0xc82e,		0x21, 0
	.dw 0x7340, 0xc82e,	0x737f, 0xc82e,		0x21, 0
	.dw 0x73c0, 0xc82e,	0x73ff, 0xc82e,		0x21, 0
	.dw 0x7440, 0xc82e,	0x747f, 0xc82e,		0x21, 0
	.dw 0x74c0, 0xc82e,	0x74ff, 0xc82e,		0x21, 0
	.dw 0x7540, 0xc82e,	0x757f, 0xc82e,		0x21, 0
	.dw 0x75c0, 0xc82e,	0x75ff, 0xc82e,		0x21, 0
	.dw 0x7640, 0xc82e,	0x767f, 0xc82e,		0x21, 0
	.dw 0x76c0, 0xc82e,	0x76ff, 0xc82e,		0x21, 0
	.dw 0x7740, 0xc82e,	0x777f, 0xc82e,		0x21, 0
	.dw 0x77c0, 0xc82e,	0x77ff, 0xc82e,		0x21, 0
	.dw 0x7840, 0xc82e,	0x787f, 0xc82e,		0x21, 0
	.dw 0x78c0, 0xc82e,	0x78ff, 0xc82e,		0x21, 0
	.dw 0x7940, 0xc82e,	0x797f, 0xc82e,		0x21, 0
	.dw 0x79c0, 0xc82e,	0x7fff, 0xc82e,		0x21, 0
	.dw 0x8040, 0xc82e,	0x807f, 0xc82e,		0x21, 0
	.dw 0x80c0, 0xc82e,	0x80ff, 0xc82e,		0x21, 0
	.dw 0x8140, 0xc82e,	0x817f, 0xc82e,		0x21, 0
	.dw 0x81c0, 0xc82e,	0x81ff, 0xc82e,		0x21, 0
	.dw 0x8240, 0xc82e,	0x827f, 0xc82e,		0x21, 0
	.dw 0x82c0, 0xc82e,	0x82ff, 0xc82e,		0x21, 0
	.dw 0x8340, 0xc82e,	0x837f, 0xc82e,		0x21, 0
	.dw 0x83c0, 0xc82e,	0x83ff, 0xc82e,		0x21, 0
	.dw 0x8440, 0xc82e,	0x847f, 0xc82e,		0x21, 0
	.dw 0x84c0, 0xc82e,	0x84ff, 0xc82e,		0x21, 0
	.dw 0x8540, 0xc82e,	0x857f, 0xc82e,		0x21, 0
	.dw 0x85c0, 0xc82e,	0x85ff, 0xc82e,		0x21, 0
	.dw 0x8640, 0xc82e,	0x867f, 0xc82e,		0x21, 0
	.dw 0x86c0, 0xc82e,	0x86ff, 0xc82e,		0x21, 0
	.dw 0x8740, 0xc82e,	0x877f, 0xc82e,		0x21, 0
	.dw 0x87c0, 0xc82e,	0x87ff, 0xc82e,		0x21, 0
	.dw 0x8840, 0xc82e,	0x887f, 0xc82e,		0x21, 0
	.dw 0x88c0, 0xc82e,	0x88ff, 0xc82e,		0x21, 0
	.dw 0x8940, 0xc82e,	0x897f, 0xc82e,		0x21, 0
	.dw 0x89c0, 0xc82e,	0x89ff, 0xc82e,		0x21, 0
	.dw 0x8a40, 0xc82e,	0x8a7f, 0xc82e,		0x21, 0
	.dw 0x8ac0, 0xc82e,	0x8aff, 0xc82e,		0x21, 0
	.dw 0x8b40, 0xc82e,	0x8b7f, 0xc82e,		0x21, 0
	.dw 0x8bc0, 0xc82e,	0x8bff, 0xc82e,		0x21, 0
	.dw 0x8c40, 0xc82e,	0x8c7f, 0xc82e,		0x21, 0
	.dw 0x8cc0, 0xc82e,	0x8cff, 0xc82e,		0x21, 0
	.dw 0x8d40, 0xc82e,	0x8d7f, 0xc82e,		0x21, 0
	.dw 0x8dc0, 0xc82e,	0x8dff, 0xc82e,		0x21, 0
	.dw 0x8e40, 0xc82e,	0x8e7f, 0xc82e,		0x21, 0
	.dw 0x8ec0, 0xc82e,	0x8eff, 0xc82e,		0x21, 0
	.dw 0x8f40, 0xc82e,	0x8f7f, 0xc82e,		0x21, 0
	.dw 0x8fc0, 0xc82e,	0x8fff, 0xc82e,		0x21, 0
	.dw 0x9040, 0xc82e,	0x907f, 0xc82e,		0x21, 0
	.dw 0x90c0, 0xc82e,	0x90ff, 0xc82e,		0x21, 0
	.dw 0x9140, 0xc82e,	0x917f, 0xc82e,		0x21, 0
	.dw 0x91c0, 0xc82e,	0x91ff, 0xc82e,		0x21, 0
	.dw 0x9240, 0xc82e,	0x927f, 0xc82e,		0x21, 0
	.dw 0x92c0, 0xc82e,	0x92ff, 0xc82e,		0x21, 0
	.dw 0x9340, 0xc82e,	0x937f, 0xc82e,		0x21, 0
	.dw 0x93c0, 0xc82e,	0x93ff, 0xc82e,		0x21, 0
	.dw 0x9440, 0xc82e,	0x947f, 0xc82e,		0x21, 0
	.dw 0x94c0, 0xc82e,	0x94ff, 0xc82e,		0x21, 0
	.dw 0x9540, 0xc82e,	0x957f, 0xc82e,		0x21, 0
	.dw 0x95c0, 0xc82e,	0x95ff, 0xc82e,		0x21, 0
	.dw 0x9640, 0xc82e,	0x967f, 0xc82e,		0x21, 0
	.dw 0x96c0, 0xc82e,	0x96ff, 0xc82e,		0x21, 0
	.dw 0x9740, 0xc82e,	0x977f, 0xc82e,		0x21, 0
	.dw 0x97c0, 0xc82e,	0x97ff, 0xc82e,		0x21, 0
	.dw 0x9840, 0xc82e,	0x987f, 0xc82e,		0x21, 0
	.dw 0x98c0, 0xc82e,	0x98ff, 0xc82e,		0x21, 0
	.dw 0x9940, 0xc82e,	0x997f, 0xc82e,		0x21, 0
	.dw 0x99c0, 0xc82e,	0x9fff, 0xc82e,		0x21, 0
	.dw 0xa040, 0xc82e,	0xa07f, 0xc82e,		0x21, 0
	.dw 0xa0c0, 0xc82e,	0xa0ff, 0xc82e,		0x21, 0
	.dw 0xa140, 0xc82e,	0xa17f, 0xc82e,		0x21, 0
	.dw 0xa1c0, 0xc82e,	0xa1ff, 0xc82e,		0x21, 0
	.dw 0xa240, 0xc82e,	0xa27f, 0xc82e,		0x21, 0
	.dw 0xa2c0, 0xc82e,	0xa2ff, 0xc82e,		0x21, 0
	.dw 0xa340, 0xc82e,	0xa37f, 0xc82e,		0x21, 0
	.dw 0xa3c0, 0xc82e,	0xa3ff, 0xc82e,		0x21, 0
	.dw 0xa440, 0xc82e,	0xa47f, 0xc82e,		0x21, 0
	.dw 0xa4c0, 0xc82e,	0xa4ff, 0xc82e,		0x21, 0
	.dw 0xa540, 0xc82e,	0xa57f, 0xc82e,		0x21, 0
	.dw 0xa5c0, 0xc82e,	0xa5ff, 0xc82e,		0x21, 0
	.dw 0xa640, 0xc82e,	0xa67f, 0xc82e,		0x21, 0
	.dw 0xa6c0, 0xc82e,	0xa6ff, 0xc82e,		0x21, 0
	.dw 0xa740, 0xc82e,	0xa77f, 0xc82e,		0x21, 0
	.dw 0xa7c0, 0xc82e,	0xa7ff, 0xc82e,		0x21, 0
	.dw 0xa840, 0xc82e,	0xa87f, 0xc82e,		0x21, 0
	.dw 0xa8c0, 0xc82e,	0xa8ff, 0xc82e,		0x21, 0
	.dw 0xa940, 0xc82e,	0xa97f, 0xc82e,		0x21, 0
	.dw 0xa9c0, 0xc82e,	0xa9ff, 0xc82e,		0x21, 0
	.dw 0xaa40, 0xc82e,	0xaa7f, 0xc82e,		0x21, 0
	.dw 0xaac0, 0xc82e,	0xaaff, 0xc82e,		0x21, 0
	.dw 0xab40, 0xc82e,	0xab7f, 0xc82e,		0x21, 0
	.dw 0xabc0, 0xc82e,	0xabff, 0xc82e,		0x21, 0
	.dw 0xac40, 0xc82e,	0xac7f, 0xc82e,		0x21, 0
	.dw 0xacc0, 0xc82e,	0xacff, 0xc82e,		0x21, 0
	.dw 0xad40, 0xc82e,	0xad7f, 0xc82e,		0x21, 0
	.dw 0xadc0, 0xc82e,	0xadff, 0xc82e,		0x21, 0
	.dw 0xae40, 0xc82e,	0xae7f, 0xc82e,		0x21, 0
	.dw 0xaec0, 0xc82e,	0xaeff, 0xc82e,		0x21, 0
	.dw 0xaf40, 0xc82e,	0xaf7f, 0xc82e,		0x21, 0
	.dw 0xafc0, 0xc82e,	0xafff, 0xc82e,		0x21, 0
	.dw 0xb040, 0xc82e,	0xb07f, 0xc82e,		0x21, 0
	.dw 0xb0c0, 0xc82e,	0xb0ff, 0xc82e,		0x21, 0
	.dw 0xb140, 0xc82e,	0xb17f, 0xc82e,		0x21, 0
	.dw 0xb1c0, 0xc82e,	0xb1ff, 0xc82e,		0x21, 0
	.dw 0xb240, 0xc82e,	0xb27f, 0xc82e,		0x21, 0
	.dw 0xb2c0, 0xc82e,	0xb2ff, 0xc82e,		0x21, 0
	.dw 0xb340, 0xc82e,	0xb37f, 0xc82e,		0x21, 0
	.dw 0xb3c0, 0xc82e,	0xb3ff, 0xc82e,		0x21, 0
	.dw 0xb440, 0xc82e,	0xb47f, 0xc82e,		0x21, 0
	.dw 0xb4c0, 0xc82e,	0xb4ff, 0xc82e,		0x21, 0
	.dw 0xb540, 0xc82e,	0xb57f, 0xc82e,		0x21, 0
	.dw 0xb5c0, 0xc82e,	0xb5ff, 0xc82e,		0x21, 0
	.dw 0xb640, 0xc82e,	0xb67f, 0xc82e,		0x21, 0
	.dw 0xb6c0, 0xc82e,	0xb6ff, 0xc82e,		0x21, 0
	.dw 0xb740, 0xc82e,	0xb77f, 0xc82e,		0x21, 0
	.dw 0xb7c0, 0xc82e,	0xb7ff, 0xc82e,		0x21, 0
	.dw 0xb840, 0xc82e,	0xb87f, 0xc82e,		0x21, 0
	.dw 0xb8c0, 0xc82e,	0xb8ff, 0xc82e,		0x21, 0
	.dw 0xb940, 0xc82e,	0xb97f, 0xc82e,		0x21, 0
	.dw 0xb9c0, 0xc82e,	0xbfff, 0xc82e,		0x21, 0
	.dw 0xc040, 0xc82e,	0xc07f, 0xc82e,		0x21, 0
	.dw 0xc0c0, 0xc82e,	0xc0ff, 0xc82e,		0x21, 0
	.dw 0xc140, 0xc82e,	0xc17f, 0xc82e,		0x21, 0
	.dw 0xc1c0, 0xc82e,	0xc1ff, 0xc82e,		0x21, 0
	.dw 0xc240, 0xc82e,	0xc27f, 0xc82e,		0x21, 0
	.dw 0xc2c0, 0xc82e,	0xc2ff, 0xc82e,		0x21, 0
	.dw 0xc340, 0xc82e,	0xc37f, 0xc82e,		0x21, 0
	.dw 0xc3c0, 0xc82e,	0xc3ff, 0xc82e,		0x21, 0
	.dw 0xc440, 0xc82e,	0xc47f, 0xc82e,		0x21, 0
	.dw 0xc4c0, 0xc82e,	0xc4ff, 0xc82e,		0x21, 0
	.dw 0xc540, 0xc82e,	0xc57f, 0xc82e,		0x21, 0
	.dw 0xc5c0, 0xc82e,	0xc5ff, 0xc82e,		0x21, 0
	.dw 0xc640, 0xc82e,	0xc67f, 0xc82e,		0x21, 0
	.dw 0xc6c0, 0xc82e,	0xc6ff, 0xc82e,		0x21, 0
	.dw 0xc740, 0xc82e,	0xc77f, 0xc82e,		0x21, 0
	.dw 0xc7c0, 0xc82e,	0xc7ff, 0xc82e,		0x21, 0
	.dw 0xc840, 0xc82e,	0xc87f, 0xc82e,		0x21, 0
	.dw 0xc8c0, 0xc82e,	0xc8ff, 0xc82e,		0x21, 0
	.dw 0xc940, 0xc82e,	0xc97f, 0xc82e,		0x21, 0
	.dw 0xc9c0, 0xc82e,	0xc9ff, 0xc82e,		0x21, 0
	.dw 0xca40, 0xc82e,	0xca7f, 0xc82e,		0x21, 0
	.dw 0xcac0, 0xc82e,	0xcaff, 0xc82e,		0x21, 0
	.dw 0xcb40, 0xc82e,	0xcb7f, 0xc82e,		0x21, 0
	.dw 0xcbc0, 0xc82e,	0xcbff, 0xc82e,		0x21, 0
	.dw 0xcc40, 0xc82e,	0xcc7f, 0xc82e,		0x21, 0
	.dw 0xccc0, 0xc82e,	0xccff, 0xc82e,		0x21, 0
	.dw 0xcd40, 0xc82e,	0xcd7f, 0xc82e,		0x21, 0
	.dw 0xcdc0, 0xc82e,	0xcdff, 0xc82e,		0x21, 0
	.dw 0xce40, 0xc82e,	0xce7f, 0xc82e,		0x21, 0
	.dw 0xcec0, 0xc82e,	0xceff, 0xc82e,		0x21, 0
	.dw 0xcf40, 0xc82e,	0xcf7f, 0xc82e,		0x21, 0
	.dw 0xcfc0, 0xc82e,	0xcfff, 0xc82e,		0x21, 0
	.dw 0xd040, 0xc82e,	0xd07f, 0xc82e,		0x21, 0
	.dw 0xd0c0, 0xc82e,	0xd0ff, 0xc82e,		0x21, 0
	.dw 0xd140, 0xc82e,	0xd17f, 0xc82e,		0x21, 0
	.dw 0xd1c0, 0xc82e,	0xd1ff, 0xc82e,		0x21, 0
	.dw 0xd240, 0xc82e,	0xd27f, 0xc82e,		0x21, 0
	.dw 0xd2c0, 0xc82e,	0xd2ff, 0xc82e,		0x21, 0
	.dw 0xd340, 0xc82e,	0xd37f, 0xc82e,		0x21, 0
	.dw 0xd3c0, 0xc82e,	0xd3ff, 0xc82e,		0x21, 0
	.dw 0xd440, 0xc82e,	0xd47f, 0xc82e,		0x21, 0
	.dw 0xd4c0, 0xc82e,	0xd4ff, 0xc82e,		0x21, 0
	.dw 0xd540, 0xc82e,	0xd57f, 0xc82e,		0x21, 0
	.dw 0xd5c0, 0xc82e,	0xd5ff, 0xc82e,		0x21, 0
	.dw 0xd640, 0xc82e,	0xd67f, 0xc82e,		0x21, 0
	.dw 0xd6c0, 0xc82e,	0xd6ff, 0xc82e,		0x21, 0
	.dw 0xd740, 0xc82e,	0xd77f, 0xc82e,		0x21, 0
	.dw 0xd7c0, 0xc82e,	0xd7ff, 0xc82e,		0x21, 0
	.dw 0xd840, 0xc82e,	0xd87f, 0xc82e,		0x21, 0
	.dw 0xd8c0, 0xc82e,	0xd8ff, 0xc82e,		0x21, 0
	.dw 0xd940, 0xc82e,	0xd97f, 0xc82e,		0x21, 0
	.dw 0xd9c0, 0xc82e,	0xdfff, 0xc82e,		0x21, 0
	.dw 0xe040, 0xc82e,	0xe07f, 0xc82e,		0x21, 0
	.dw 0xe0c0, 0xc82e,	0xe0ff, 0xc82e,		0x21, 0
	.dw 0xe140, 0xc82e,	0xe17f, 0xc82e,		0x21, 0
	.dw 0xe1c0, 0xc82e,	0xe1ff, 0xc82e,		0x21, 0
	.dw 0xe240, 0xc82e,	0xe27f, 0xc82e,		0x21, 0
	.dw 0xe2c0, 0xc82e,	0xe2ff, 0xc82e,		0x21, 0
	.dw 0xe340, 0xc82e,	0xe37f, 0xc82e,		0x21, 0
	.dw 0xe3c0, 0xc82e,	0xe3ff, 0xc82e,		0x21, 0
	.dw 0xe440, 0xc82e,	0xe47f, 0xc82e,		0x21, 0
	.dw 0xe4c0, 0xc82e,	0xe4ff, 0xc82e,		0x21, 0
	.dw 0xe540, 0xc82e,	0xe57f, 0xc82e,		0x21, 0
	.dw 0xe5c0, 0xc82e,	0xe5ff, 0xc82e,		0x21, 0
	.dw 0xe640, 0xc82e,	0xe67f, 0xc82e,		0x21, 0
	.dw 0xe6c0, 0xc82e,	0xe6ff, 0xc82e,		0x21, 0
	.dw 0xe740, 0xc82e,	0xe77f, 0xc82e,		0x21, 0
	.dw 0xe7c0, 0xc82e,	0xe7ff, 0xc82e,		0x21, 0
	.dw 0xe840, 0xc82e,	0xe87f, 0xc82e,		0x21, 0
	.dw 0xe8c0, 0xc82e,	0xe8ff, 0xc82e,		0x21, 0
	.dw 0xe940, 0xc82e,	0xe97f, 0xc82e,		0x21, 0
	.dw 0xe9c0, 0xc82e,	0xe9ff, 0xc82e,		0x21, 0
	.dw 0xea40, 0xc82e,	0xea7f, 0xc82e,		0x21, 0
	.dw 0xeac0, 0xc82e,	0xeaff, 0xc82e,		0x21, 0
	.dw 0xeb40, 0xc82e,	0xeb7f, 0xc82e,		0x21, 0
	.dw 0xebc0, 0xc82e,	0xebff, 0xc82e,		0x21, 0
	.dw 0xec40, 0xc82e,	0xec7f, 0xc82e,		0x21, 0
	.dw 0xecc0, 0xc82e,	0xecff, 0xc82e,		0x21, 0
	.dw 0xed40, 0xc82e,	0xed7f, 0xc82e,		0x21, 0
	.dw 0xedc0, 0xc82e,	0xedff, 0xc82e,		0x21, 0
	.dw 0xee40, 0xc82e,	0xee7f, 0xc82e,		0x21, 0
	.dw 0xeec0, 0xc82e,	0xeeff, 0xc82e,		0x21, 0
	.dw 0xef40, 0xc82e,	0xef7f, 0xc82e,		0x21, 0
	.dw 0xefc0, 0xc82e,	0xefff, 0xc82e,		0x21, 0
	.dw 0xf040, 0xc82e,	0xf07f, 0xc82e,		0x21, 0
	.dw 0xf0c0, 0xc82e,	0xf0ff, 0xc82e,		0x21, 0
	.dw 0xf140, 0xc82e,	0xf17f, 0xc82e,		0x21, 0
	.dw 0xf1c0, 0xc82e,	0xf1ff, 0xc82e,		0x21, 0
	.dw 0xf240, 0xc82e,	0xf27f, 0xc82e,		0x21, 0
	.dw 0xf2c0, 0xc82e,	0xf2ff, 0xc82e,		0x21, 0
	.dw 0xf340, 0xc82e,	0xf37f, 0xc82e,		0x21, 0
	.dw 0xf3c0, 0xc82e,	0xf3ff, 0xc82e,		0x21, 0
	.dw 0xf440, 0xc82e,	0xf47f, 0xc82e,		0x21, 0
	.dw 0xf4c0, 0xc82e,	0xf4ff, 0xc82e,		0x21, 0
	.dw 0xf540, 0xc82e,	0xf57f, 0xc82e,		0x21, 0
	.dw 0xf5c0, 0xc82e,	0xf5ff, 0xc82e,		0x21, 0
	.dw 0xf640, 0xc82e,	0xf67f, 0xc82e,		0x21, 0
	.dw 0xf6c0, 0xc82e,	0xf6ff, 0xc82e,		0x21, 0
	.dw 0xf740, 0xc82e,	0xf77f, 0xc82e,		0x21, 0
	.dw 0xf7c0, 0xc82e,	0xf7ff, 0xc82e,		0x21, 0
	.dw 0xf840, 0xc82e,	0xf87f, 0xc82e,		0x21, 0
	.dw 0xf8c0, 0xc82e,	0xf8ff, 0xc82e,		0x21, 0
	.dw 0xf940, 0xc82e,	0xf97f, 0xc82e,		0x21, 0
	.dw 0xf9c0, 0xc82e,	0xffff, 0xc82e,		0x21, 0
	.dw 0x0040, 0xc82f,	0x007f, 0xc82f,		0x21, 0
	.dw 0x00c0, 0xc82f,	0x00ff, 0xc82f,		0x21, 0
	.dw 0x0140, 0xc82f,	0x017f, 0xc82f,		0x21, 0
	.dw 0x01c0, 0xc82f,	0x01ff, 0xc82f,		0x21, 0
	.dw 0x0240, 0xc82f,	0x027f, 0xc82f,		0x21, 0
	.dw 0x02c0, 0xc82f,	0x02ff, 0xc82f,		0x21, 0
	.dw 0x0340, 0xc82f,	0x037f, 0xc82f,		0x21, 0
	.dw 0x03c0, 0xc82f,	0x03ff, 0xc82f,		0x21, 0
	.dw 0x0440, 0xc82f,	0x047f, 0xc82f,		0x21, 0
	.dw 0x04c0, 0xc82f,	0x04ff, 0xc82f,		0x21, 0
	.dw 0x0540, 0xc82f,	0x057f, 0xc82f,		0x21, 0
	.dw 0x05c0, 0xc82f,	0x05ff, 0xc82f,		0x21, 0
	.dw 0x0640, 0xc82f,	0x067f, 0xc82f,		0x21, 0
	.dw 0x06c0, 0xc82f,	0x06ff, 0xc82f,		0x21, 0
	.dw 0x0740, 0xc82f,	0x077f, 0xc82f,		0x21, 0
	.dw 0x07c0, 0xc82f,	0x07ff, 0xc82f,		0x21, 0
	.dw 0x0840, 0xc82f,	0x087f, 0xc82f,		0x21, 0
	.dw 0x08c0, 0xc82f,	0x08ff, 0xc82f,		0x21, 0
	.dw 0x0940, 0xc82f,	0x097f, 0xc82f,		0x21, 0
	.dw 0x09c0, 0xc82f,	0x09ff, 0xc82f,		0x21, 0
	.dw 0x0a40, 0xc82f,	0x0a7f, 0xc82f,		0x21, 0
	.dw 0x0ac0, 0xc82f,	0x0aff, 0xc82f,		0x21, 0
	.dw 0x0b40, 0xc82f,	0x0b7f, 0xc82f,		0x21, 0
	.dw 0x0bc0, 0xc82f,	0x0bff, 0xc82f,		0x21, 0
	.dw 0x0c40, 0xc82f,	0x0c7f, 0xc82f,		0x21, 0
	.dw 0x0cc0, 0xc82f,	0x0cff, 0xc82f,		0x21, 0
	.dw 0x0d40, 0xc82f,	0x0d7f, 0xc82f,		0x21, 0
	.dw 0x0dc0, 0xc82f,	0x0dff, 0xc82f,		0x21, 0
	.dw 0x0e40, 0xc82f,	0x0e7f, 0xc82f,		0x21, 0
	.dw 0x0ec0, 0xc82f,	0x0eff, 0xc82f,		0x21, 0
	.dw 0x0f40, 0xc82f,	0x0f7f, 0xc82f,		0x21, 0
	.dw 0x0fc0, 0xc82f,	0x0fff, 0xc82f,		0x21, 0
	.dw 0x1040, 0xc82f,	0x107f, 0xc82f,		0x21, 0
	.dw 0x10c0, 0xc82f,	0x10ff, 0xc82f,		0x21, 0
	.dw 0x1140, 0xc82f,	0x117f, 0xc82f,		0x21, 0
	.dw 0x11c0, 0xc82f,	0x11ff, 0xc82f,		0x21, 0
	.dw 0x1240, 0xc82f,	0x127f, 0xc82f,		0x21, 0
	.dw 0x12c0, 0xc82f,	0x12ff, 0xc82f,		0x21, 0
	.dw 0x1340, 0xc82f,	0x137f, 0xc82f,		0x21, 0
	.dw 0x13c0, 0xc82f,	0x13ff, 0xc82f,		0x21, 0
	.dw 0x1440, 0xc82f,	0x147f, 0xc82f,		0x21, 0
	.dw 0x14c0, 0xc82f,	0x14ff, 0xc82f,		0x21, 0
	.dw 0x1540, 0xc82f,	0x157f, 0xc82f,		0x21, 0
	.dw 0x15c0, 0xc82f,	0x15ff, 0xc82f,		0x21, 0
	.dw 0x1640, 0xc82f,	0x167f, 0xc82f,		0x21, 0
	.dw 0x16c0, 0xc82f,	0x16ff, 0xc82f,		0x21, 0
	.dw 0x1740, 0xc82f,	0x177f, 0xc82f,		0x21, 0
	.dw 0x17c0, 0xc82f,	0x17ff, 0xc82f,		0x21, 0
	.dw 0x1840, 0xc82f,	0x187f, 0xc82f,		0x21, 0
	.dw 0x18c0, 0xc82f,	0x18ff, 0xc82f,		0x21, 0
	.dw 0x1940, 0xc82f,	0x197f, 0xc82f,		0x21, 0
	.dw 0x19c0, 0xc82f,	0x1fff, 0xc82f,		0x21, 0
	.dw 0x2040, 0xc82f,	0x207f, 0xc82f,		0x21, 0
	.dw 0x20c0, 0xc82f,	0x20ff, 0xc82f,		0x21, 0
	.dw 0x2140, 0xc82f,	0x217f, 0xc82f,		0x21, 0
	.dw 0x21c0, 0xc82f,	0x21ff, 0xc82f,		0x21, 0
	.dw 0x2240, 0xc82f,	0x227f, 0xc82f,		0x21, 0
	.dw 0x22c0, 0xc82f,	0x22ff, 0xc82f,		0x21, 0
	.dw 0x2340, 0xc82f,	0x237f, 0xc82f,		0x21, 0
	.dw 0x23c0, 0xc82f,	0x23ff, 0xc82f,		0x21, 0
	.dw 0x2440, 0xc82f,	0x247f, 0xc82f,		0x21, 0
	.dw 0x24c0, 0xc82f,	0x24ff, 0xc82f,		0x21, 0
	.dw 0x2540, 0xc82f,	0x257f, 0xc82f,		0x21, 0
	.dw 0x25c0, 0xc82f,	0x25ff, 0xc82f,		0x21, 0
	.dw 0x2640, 0xc82f,	0x267f, 0xc82f,		0x21, 0
	.dw 0x26c0, 0xc82f,	0x26ff, 0xc82f,		0x21, 0
	.dw 0x2740, 0xc82f,	0x277f, 0xc82f,		0x21, 0
	.dw 0x27c0, 0xc82f,	0x27ff, 0xc82f,		0x21, 0
	.dw 0x2840, 0xc82f,	0x287f, 0xc82f,		0x21, 0
	.dw 0x28c0, 0xc82f,	0x28ff, 0xc82f,		0x21, 0
	.dw 0x2940, 0xc82f,	0x297f, 0xc82f,		0x21, 0
	.dw 0x29c0, 0xc82f,	0x29ff, 0xc82f,		0x21, 0
	.dw 0x2a40, 0xc82f,	0x2a7f, 0xc82f,		0x21, 0
	.dw 0x2ac0, 0xc82f,	0x2aff, 0xc82f,		0x21, 0
	.dw 0x2b40, 0xc82f,	0x2b7f, 0xc82f,		0x21, 0
	.dw 0x2bc0, 0xc82f,	0x2bff, 0xc82f,		0x21, 0
	.dw 0x2c40, 0xc82f,	0x2c7f, 0xc82f,		0x21, 0
	.dw 0x2cc0, 0xc82f,	0x2cff, 0xc82f,		0x21, 0
	.dw 0x2d40, 0xc82f,	0x2d7f, 0xc82f,		0x21, 0
	.dw 0x2dc0, 0xc82f,	0x2dff, 0xc82f,		0x21, 0
	.dw 0x2e40, 0xc82f,	0x2e7f, 0xc82f,		0x21, 0
	.dw 0x2ec0, 0xc82f,	0x2eff, 0xc82f,		0x21, 0
	.dw 0x2f40, 0xc82f,	0x2f7f, 0xc82f,		0x21, 0
	.dw 0x2fc0, 0xc82f,	0x2fff, 0xc82f,		0x21, 0
	.dw 0x3040, 0xc82f,	0x307f, 0xc82f,		0x21, 0
	.dw 0x30c0, 0xc82f,	0x30ff, 0xc82f,		0x21, 0
	.dw 0x3140, 0xc82f,	0x317f, 0xc82f,		0x21, 0
	.dw 0x31c0, 0xc82f,	0x31ff, 0xc82f,		0x21, 0
	.dw 0x3240, 0xc82f,	0x327f, 0xc82f,		0x21, 0
	.dw 0x32c0, 0xc82f,	0x32ff, 0xc82f,		0x21, 0
	.dw 0x3340, 0xc82f,	0x337f, 0xc82f,		0x21, 0
	.dw 0x33c0, 0xc82f,	0x33ff, 0xc82f,		0x21, 0
	.dw 0x3440, 0xc82f,	0x347f, 0xc82f,		0x21, 0
	.dw 0x34c0, 0xc82f,	0x34ff, 0xc82f,		0x21, 0
	.dw 0x3540, 0xc82f,	0x357f, 0xc82f,		0x21, 0
	.dw 0x35c0, 0xc82f,	0x35ff, 0xc82f,		0x21, 0
	.dw 0x3640, 0xc82f,	0x367f, 0xc82f,		0x21, 0
	.dw 0x36c0, 0xc82f,	0x36ff, 0xc82f,		0x21, 0
	.dw 0x3740, 0xc82f,	0x377f, 0xc82f,		0x21, 0
	.dw 0x37c0, 0xc82f,	0x37ff, 0xc82f,		0x21, 0
	.dw 0x3840, 0xc82f,	0x387f, 0xc82f,		0x21, 0
	.dw 0x38c0, 0xc82f,	0x38ff, 0xc82f,		0x21, 0
	.dw 0x3940, 0xc82f,	0x397f, 0xc82f,		0x21, 0
	.dw 0x39c0, 0xc82f,	0x1fff, 0xc830,		0x21, 0
	.dw 0x3a00, 0xc830,	0x5fff, 0xc830,		0x21, 0
	.dw 0x7a00, 0xc830,	0x9fff, 0xc830,		0x21, 0
	.dw 0xba00, 0xc830,	0xdfff, 0xc830,		0x21, 0
	.dw 0xfa00, 0xc830,	0x1fff, 0xc831,		0x21, 0
	.dw 0x3a00, 0xc831,	0x5fff, 0xc831,		0x21, 0
	.dw 0x7a00, 0xc831,	0x9fff, 0xc831,		0x21, 0
	.dw 0xba00, 0xc831,	0xdfff, 0xc831,		0x21, 0
	.dw 0xfa00, 0xc831,	0x1fff, 0xc832,		0x21, 0
	.dw 0x3a00, 0xc832,	0x5fff, 0xc832,		0x21, 0
	.dw 0x7a00, 0xc832,	0x9fff, 0xc832,		0x21, 0
	.dw 0xba00, 0xc832,	0xdfff, 0xc832,		0x21, 0
	.dw 0xfa00, 0xc832,	0xffff, 0xc833,		0x21, 0
	.dw 0x1a00, 0xc834,	0x1fff, 0xc834,		0x21, 0
	.dw 0x3a00, 0xc834,	0x3fff, 0xc834,		0x21, 0
	.dw 0x5a00, 0xc834,	0x5fff, 0xc834,		0x21, 0
	.dw 0x7a00, 0xc834,	0x7fff, 0xc834,		0x21, 0
	.dw 0x9a00, 0xc834,	0x9fff, 0xc834,		0x21, 0
	.dw 0xba00, 0xc834,	0xbfff, 0xc834,		0x21, 0
	.dw 0xda00, 0xc834,	0xdfff, 0xc834,		0x21, 0
	.dw 0xfa00, 0xc834,	0xffff, 0xc834,		0x21, 0
	.dw 0x1a00, 0xc835,	0x1fff, 0xc835,		0x21, 0
	.dw 0x3a00, 0xc835,	0x3fff, 0xc835,		0x21, 0
	.dw 0x5a00, 0xc835,	0x5fff, 0xc835,		0x21, 0
	.dw 0x7a00, 0xc835,	0x7fff, 0xc835,		0x21, 0
	.dw 0x9a00, 0xc835,	0x9fff, 0xc835,		0x21, 0
	.dw 0xba00, 0xc835,	0xbfff, 0xc835,		0x21, 0
	.dw 0xda00, 0xc835,	0xdfff, 0xc835,		0x21, 0
	.dw 0xfa00, 0xc835,	0xffff, 0xc835,		0x21, 0
	.dw 0x1a00, 0xc836,	0x1fff, 0xc836,		0x21, 0
	.dw 0x3a00, 0xc836,	0x3fff, 0xc836,		0x21, 0
	.dw 0x5a00, 0xc836,	0x5fff, 0xc836,		0x21, 0
	.dw 0x7a00, 0xc836,	0x7fff, 0xc836,		0x21, 0
	.dw 0x9a00, 0xc836,	0x9fff, 0xc836,		0x21, 0
	.dw 0xba00, 0xc836,	0xbfff, 0xc836,		0x21, 0
	.dw 0xda00, 0xc836,	0xdfff, 0xc836,		0x21, 0
	.dw 0xfa00, 0xc836,	0xffff, 0xc836,		0x21, 0
	.dw 0x1a00, 0xc837,	0x1fff, 0xc837,		0x21, 0
	.dw 0x3a00, 0xc837,	0x1fff, 0xc838,		0x21, 0
	.dw 0x2040, 0xc838,	0x207f, 0xc838,		0x21, 0
	.dw 0x20c0, 0xc838,	0x20ff, 0xc838,		0x21, 0
	.dw 0x2140, 0xc838,	0x217f, 0xc838,		0x21, 0
	.dw 0x21c0, 0xc838,	0x21ff, 0xc838,		0x21, 0
	.dw 0x2240, 0xc838,	0x227f, 0xc838,		0x21, 0
	.dw 0x22c0, 0xc838,	0x22ff, 0xc838,		0x21, 0
	.dw 0x2340, 0xc838,	0x237f, 0xc838,		0x21, 0
	.dw 0x23c0, 0xc838,	0x23ff, 0xc838,		0x21, 0
	.dw 0x2440, 0xc838,	0x247f, 0xc838,		0x21, 0
	.dw 0x24c0, 0xc838,	0x24ff, 0xc838,		0x21, 0
	.dw 0x2540, 0xc838,	0x257f, 0xc838,		0x21, 0
	.dw 0x25c0, 0xc838,	0x25ff, 0xc838,		0x21, 0
	.dw 0x2640, 0xc838,	0x267f, 0xc838,		0x21, 0
	.dw 0x26c0, 0xc838,	0x26ff, 0xc838,		0x21, 0
	.dw 0x2740, 0xc838,	0x277f, 0xc838,		0x21, 0
	.dw 0x27c0, 0xc838,	0x27ff, 0xc838,		0x21, 0
	.dw 0x2840, 0xc838,	0x287f, 0xc838,		0x21, 0
	.dw 0x28c0, 0xc838,	0x28ff, 0xc838,		0x21, 0
	.dw 0x2940, 0xc838,	0x297f, 0xc838,		0x21, 0
	.dw 0x29c0, 0xc838,	0x29ff, 0xc838,		0x21, 0
	.dw 0x2a40, 0xc838,	0x2a7f, 0xc838,		0x21, 0
	.dw 0x2ac0, 0xc838,	0x2aff, 0xc838,		0x21, 0
	.dw 0x2b40, 0xc838,	0x2b7f, 0xc838,		0x21, 0
	.dw 0x2bc0, 0xc838,	0x2bff, 0xc838,		0x21, 0
	.dw 0x2c40, 0xc838,	0x2c7f, 0xc838,		0x21, 0
	.dw 0x2cc0, 0xc838,	0x2cff, 0xc838,		0x21, 0
	.dw 0x2d40, 0xc838,	0x2d7f, 0xc838,		0x21, 0
	.dw 0x2dc0, 0xc838,	0x2dff, 0xc838,		0x21, 0
	.dw 0x2e40, 0xc838,	0x2e7f, 0xc838,		0x21, 0
	.dw 0x2ec0, 0xc838,	0x2eff, 0xc838,		0x21, 0
	.dw 0x2f40, 0xc838,	0x2f7f, 0xc838,		0x21, 0
	.dw 0x2fc0, 0xc838,	0x2fff, 0xc838,		0x21, 0
	.dw 0x3040, 0xc838,	0x307f, 0xc838,		0x21, 0
	.dw 0x30c0, 0xc838,	0x30ff, 0xc838,		0x21, 0
	.dw 0x3140, 0xc838,	0x317f, 0xc838,		0x21, 0
	.dw 0x31c0, 0xc838,	0x31ff, 0xc838,		0x21, 0
	.dw 0x3240, 0xc838,	0x327f, 0xc838,		0x21, 0
	.dw 0x32c0, 0xc838,	0x32ff, 0xc838,		0x21, 0
	.dw 0x3340, 0xc838,	0x337f, 0xc838,		0x21, 0
	.dw 0x33c0, 0xc838,	0x33ff, 0xc838,		0x21, 0
	.dw 0x3440, 0xc838,	0x347f, 0xc838,		0x21, 0
	.dw 0x34c0, 0xc838,	0x34ff, 0xc838,		0x21, 0
	.dw 0x3540, 0xc838,	0x357f, 0xc838,		0x21, 0
	.dw 0x35c0, 0xc838,	0x35ff, 0xc838,		0x21, 0
	.dw 0x3640, 0xc838,	0x367f, 0xc838,		0x21, 0
	.dw 0x36c0, 0xc838,	0x36ff, 0xc838,		0x21, 0
	.dw 0x3740, 0xc838,	0x377f, 0xc838,		0x21, 0
	.dw 0x37c0, 0xc838,	0x37ff, 0xc838,		0x21, 0
	.dw 0x3840, 0xc838,	0x387f, 0xc838,		0x21, 0
	.dw 0x38c0, 0xc838,	0x38ff, 0xc838,		0x21, 0
	.dw 0x3940, 0xc838,	0x397f, 0xc838,		0x21, 0
	.dw 0x39c0, 0xc838,	0x5fff, 0xc838,		0x21, 0
	.dw 0x6040, 0xc838,	0x607f, 0xc838,		0x21, 0
	.dw 0x60c0, 0xc838,	0x60ff, 0xc838,		0x21, 0
	.dw 0x6140, 0xc838,	0x617f, 0xc838,		0x21, 0
	.dw 0x61c0, 0xc838,	0x61ff, 0xc838,		0x21, 0
	.dw 0x6240, 0xc838,	0x627f, 0xc838,		0x21, 0
	.dw 0x62c0, 0xc838,	0x62ff, 0xc838,		0x21, 0
	.dw 0x6340, 0xc838,	0x637f, 0xc838,		0x21, 0
	.dw 0x63c0, 0xc838,	0x63ff, 0xc838,		0x21, 0
	.dw 0x6440, 0xc838,	0x647f, 0xc838,		0x21, 0
	.dw 0x64c0, 0xc838,	0x64ff, 0xc838,		0x21, 0
	.dw 0x6540, 0xc838,	0x657f, 0xc838,		0x21, 0
	.dw 0x65c0, 0xc838,	0x65ff, 0xc838,		0x21, 0
	.dw 0x6640, 0xc838,	0x667f, 0xc838,		0x21, 0
	.dw 0x66c0, 0xc838,	0x66ff, 0xc838,		0x21, 0
	.dw 0x6740, 0xc838,	0x677f, 0xc838,		0x21, 0
	.dw 0x67c0, 0xc838,	0x67ff, 0xc838,		0x21, 0
	.dw 0x6840, 0xc838,	0x687f, 0xc838,		0x21, 0
	.dw 0x68c0, 0xc838,	0x68ff, 0xc838,		0x21, 0
	.dw 0x6940, 0xc838,	0x697f, 0xc838,		0x21, 0
	.dw 0x69c0, 0xc838,	0x69ff, 0xc838,		0x21, 0
	.dw 0x6a40, 0xc838,	0x6a7f, 0xc838,		0x21, 0
	.dw 0x6ac0, 0xc838,	0x6aff, 0xc838,		0x21, 0
	.dw 0x6b40, 0xc838,	0x6b7f, 0xc838,		0x21, 0
	.dw 0x6bc0, 0xc838,	0x6bff, 0xc838,		0x21, 0
	.dw 0x6c40, 0xc838,	0x6c7f, 0xc838,		0x21, 0
	.dw 0x6cc0, 0xc838,	0x6cff, 0xc838,		0x21, 0
	.dw 0x6d40, 0xc838,	0x6d7f, 0xc838,		0x21, 0
	.dw 0x6dc0, 0xc838,	0x6dff, 0xc838,		0x21, 0
	.dw 0x6e40, 0xc838,	0x6e7f, 0xc838,		0x21, 0
	.dw 0x6ec0, 0xc838,	0x6eff, 0xc838,		0x21, 0
	.dw 0x6f40, 0xc838,	0x6f7f, 0xc838,		0x21, 0
	.dw 0x6fc0, 0xc838,	0x6fff, 0xc838,		0x21, 0
	.dw 0x7040, 0xc838,	0x707f, 0xc838,		0x21, 0
	.dw 0x70c0, 0xc838,	0x70ff, 0xc838,		0x21, 0
	.dw 0x7140, 0xc838,	0x717f, 0xc838,		0x21, 0
	.dw 0x71c0, 0xc838,	0x71ff, 0xc838,		0x21, 0
	.dw 0x7240, 0xc838,	0x727f, 0xc838,		0x21, 0
	.dw 0x72c0, 0xc838,	0x72ff, 0xc838,		0x21, 0
	.dw 0x7340, 0xc838,	0x737f, 0xc838,		0x21, 0
	.dw 0x73c0, 0xc838,	0x73ff, 0xc838,		0x21, 0
	.dw 0x7440, 0xc838,	0x747f, 0xc838,		0x21, 0
	.dw 0x74c0, 0xc838,	0x74ff, 0xc838,		0x21, 0
	.dw 0x7540, 0xc838,	0x757f, 0xc838,		0x21, 0
	.dw 0x75c0, 0xc838,	0x75ff, 0xc838,		0x21, 0
	.dw 0x7640, 0xc838,	0x767f, 0xc838,		0x21, 0
	.dw 0x76c0, 0xc838,	0x76ff, 0xc838,		0x21, 0
	.dw 0x7740, 0xc838,	0x777f, 0xc838,		0x21, 0
	.dw 0x77c0, 0xc838,	0x77ff, 0xc838,		0x21, 0
	.dw 0x7840, 0xc838,	0x787f, 0xc838,		0x21, 0
	.dw 0x78c0, 0xc838,	0x78ff, 0xc838,		0x21, 0
	.dw 0x7940, 0xc838,	0x797f, 0xc838,		0x21, 0
	.dw 0x79c0, 0xc838,	0x9fff, 0xc838,		0x21, 0
	.dw 0xa040, 0xc838,	0xa07f, 0xc838,		0x21, 0
	.dw 0xa0c0, 0xc838,	0xa0ff, 0xc838,		0x21, 0
	.dw 0xa140, 0xc838,	0xa17f, 0xc838,		0x21, 0
	.dw 0xa1c0, 0xc838,	0xa1ff, 0xc838,		0x21, 0
	.dw 0xa240, 0xc838,	0xa27f, 0xc838,		0x21, 0
	.dw 0xa2c0, 0xc838,	0xa2ff, 0xc838,		0x21, 0
	.dw 0xa340, 0xc838,	0xa37f, 0xc838,		0x21, 0
	.dw 0xa3c0, 0xc838,	0xa3ff, 0xc838,		0x21, 0
	.dw 0xa440, 0xc838,	0xa47f, 0xc838,		0x21, 0
	.dw 0xa4c0, 0xc838,	0xa4ff, 0xc838,		0x21, 0
	.dw 0xa540, 0xc838,	0xa57f, 0xc838,		0x21, 0
	.dw 0xa5c0, 0xc838,	0xa5ff, 0xc838,		0x21, 0
	.dw 0xa640, 0xc838,	0xa67f, 0xc838,		0x21, 0
	.dw 0xa6c0, 0xc838,	0xa6ff, 0xc838,		0x21, 0
	.dw 0xa740, 0xc838,	0xa77f, 0xc838,		0x21, 0
	.dw 0xa7c0, 0xc838,	0xa7ff, 0xc838,		0x21, 0
	.dw 0xa840, 0xc838,	0xa87f, 0xc838,		0x21, 0
	.dw 0xa8c0, 0xc838,	0xa8ff, 0xc838,		0x21, 0
	.dw 0xa940, 0xc838,	0xa97f, 0xc838,		0x21, 0
	.dw 0xa9c0, 0xc838,	0xa9ff, 0xc838,		0x21, 0
	.dw 0xaa40, 0xc838,	0xaa7f, 0xc838,		0x21, 0
	.dw 0xaac0, 0xc838,	0xaaff, 0xc838,		0x21, 0
	.dw 0xab40, 0xc838,	0xab7f, 0xc838,		0x21, 0
	.dw 0xabc0, 0xc838,	0xabff, 0xc838,		0x21, 0
	.dw 0xac40, 0xc838,	0xac7f, 0xc838,		0x21, 0
	.dw 0xacc0, 0xc838,	0xacff, 0xc838,		0x21, 0
	.dw 0xad40, 0xc838,	0xad7f, 0xc838,		0x21, 0
	.dw 0xadc0, 0xc838,	0xadff, 0xc838,		0x21, 0
	.dw 0xae40, 0xc838,	0xae7f, 0xc838,		0x21, 0
	.dw 0xaec0, 0xc838,	0xaeff, 0xc838,		0x21, 0
	.dw 0xaf40, 0xc838,	0xaf7f, 0xc838,		0x21, 0
	.dw 0xafc0, 0xc838,	0xafff, 0xc838,		0x21, 0
	.dw 0xb040, 0xc838,	0xb07f, 0xc838,		0x21, 0
	.dw 0xb0c0, 0xc838,	0xb0ff, 0xc838,		0x21, 0
	.dw 0xb140, 0xc838,	0xb17f, 0xc838,		0x21, 0
	.dw 0xb1c0, 0xc838,	0xb1ff, 0xc838,		0x21, 0
	.dw 0xb240, 0xc838,	0xb27f, 0xc838,		0x21, 0
	.dw 0xb2c0, 0xc838,	0xb2ff, 0xc838,		0x21, 0
	.dw 0xb340, 0xc838,	0xb37f, 0xc838,		0x21, 0
	.dw 0xb3c0, 0xc838,	0xb3ff, 0xc838,		0x21, 0
	.dw 0xb440, 0xc838,	0xb47f, 0xc838,		0x21, 0
	.dw 0xb4c0, 0xc838,	0xb4ff, 0xc838,		0x21, 0
	.dw 0xb540, 0xc838,	0xb57f, 0xc838,		0x21, 0
	.dw 0xb5c0, 0xc838,	0xb5ff, 0xc838,		0x21, 0
	.dw 0xb640, 0xc838,	0xb67f, 0xc838,		0x21, 0
	.dw 0xb6c0, 0xc838,	0xb6ff, 0xc838,		0x21, 0
	.dw 0xb740, 0xc838,	0xb77f, 0xc838,		0x21, 0
	.dw 0xb7c0, 0xc838,	0xb7ff, 0xc838,		0x21, 0
	.dw 0xb840, 0xc838,	0xb87f, 0xc838,		0x21, 0
	.dw 0xb8c0, 0xc838,	0xb8ff, 0xc838,		0x21, 0
	.dw 0xb940, 0xc838,	0xb97f, 0xc838,		0x21, 0
	.dw 0xb9c0, 0xc838,	0xdfff, 0xc838,		0x21, 0
	.dw 0xe040, 0xc838,	0xe07f, 0xc838,		0x21, 0
	.dw 0xe0c0, 0xc838,	0xe0ff, 0xc838,		0x21, 0
	.dw 0xe140, 0xc838,	0xe17f, 0xc838,		0x21, 0
	.dw 0xe1c0, 0xc838,	0xe1ff, 0xc838,		0x21, 0
	.dw 0xe240, 0xc838,	0xe27f, 0xc838,		0x21, 0
	.dw 0xe2c0, 0xc838,	0xe2ff, 0xc838,		0x21, 0
	.dw 0xe340, 0xc838,	0xe37f, 0xc838,		0x21, 0
	.dw 0xe3c0, 0xc838,	0xe3ff, 0xc838,		0x21, 0
	.dw 0xe440, 0xc838,	0xe47f, 0xc838,		0x21, 0
	.dw 0xe4c0, 0xc838,	0xe4ff, 0xc838,		0x21, 0
	.dw 0xe540, 0xc838,	0xe57f, 0xc838,		0x21, 0
	.dw 0xe5c0, 0xc838,	0xe5ff, 0xc838,		0x21, 0
	.dw 0xe640, 0xc838,	0xe67f, 0xc838,		0x21, 0
	.dw 0xe6c0, 0xc838,	0xe6ff, 0xc838,		0x21, 0
	.dw 0xe740, 0xc838,	0xe77f, 0xc838,		0x21, 0
	.dw 0xe7c0, 0xc838,	0xe7ff, 0xc838,		0x21, 0
	.dw 0xe840, 0xc838,	0xe87f, 0xc838,		0x21, 0
	.dw 0xe8c0, 0xc838,	0xe8ff, 0xc838,		0x21, 0
	.dw 0xe940, 0xc838,	0xe97f, 0xc838,		0x21, 0
	.dw 0xe9c0, 0xc838,	0xe9ff, 0xc838,		0x21, 0
	.dw 0xea40, 0xc838,	0xea7f, 0xc838,		0x21, 0
	.dw 0xeac0, 0xc838,	0xeaff, 0xc838,		0x21, 0
	.dw 0xeb40, 0xc838,	0xeb7f, 0xc838,		0x21, 0
	.dw 0xebc0, 0xc838,	0xebff, 0xc838,		0x21, 0
	.dw 0xec40, 0xc838,	0xec7f, 0xc838,		0x21, 0
	.dw 0xecc0, 0xc838,	0xecff, 0xc838,		0x21, 0
	.dw 0xed40, 0xc838,	0xed7f, 0xc838,		0x21, 0
	.dw 0xedc0, 0xc838,	0xedff, 0xc838,		0x21, 0
	.dw 0xee40, 0xc838,	0xee7f, 0xc838,		0x21, 0
	.dw 0xeec0, 0xc838,	0xeeff, 0xc838,		0x21, 0
	.dw 0xef40, 0xc838,	0xef7f, 0xc838,		0x21, 0
	.dw 0xefc0, 0xc838,	0xefff, 0xc838,		0x21, 0
	.dw 0xf040, 0xc838,	0xf07f, 0xc838,		0x21, 0
	.dw 0xf0c0, 0xc838,	0xf0ff, 0xc838,		0x21, 0
	.dw 0xf140, 0xc838,	0xf17f, 0xc838,		0x21, 0
	.dw 0xf1c0, 0xc838,	0xf1ff, 0xc838,		0x21, 0
	.dw 0xf240, 0xc838,	0xf27f, 0xc838,		0x21, 0
	.dw 0xf2c0, 0xc838,	0xf2ff, 0xc838,		0x21, 0
	.dw 0xf340, 0xc838,	0xf37f, 0xc838,		0x21, 0
	.dw 0xf3c0, 0xc838,	0xf3ff, 0xc838,		0x21, 0
	.dw 0xf440, 0xc838,	0xf47f, 0xc838,		0x21, 0
	.dw 0xf4c0, 0xc838,	0xf4ff, 0xc838,		0x21, 0
	.dw 0xf540, 0xc838,	0xf57f, 0xc838,		0x21, 0
	.dw 0xf5c0, 0xc838,	0xf5ff, 0xc838,		0x21, 0
	.dw 0xf640, 0xc838,	0xf67f, 0xc838,		0x21, 0
	.dw 0xf6c0, 0xc838,	0xf6ff, 0xc838,		0x21, 0
	.dw 0xf740, 0xc838,	0xf77f, 0xc838,		0x21, 0
	.dw 0xf7c0, 0xc838,	0xf7ff, 0xc838,		0x21, 0
	.dw 0xf840, 0xc838,	0xf87f, 0xc838,		0x21, 0
	.dw 0xf8c0, 0xc838,	0xf8ff, 0xc838,		0x21, 0
	.dw 0xf940, 0xc838,	0xf97f, 0xc838,		0x21, 0
	.dw 0xf9c0, 0xc838,	0x1fff, 0xc839,		0x21, 0
	.dw 0x2040, 0xc839,	0x207f, 0xc839,		0x21, 0
	.dw 0x20c0, 0xc839,	0x20ff, 0xc839,		0x21, 0
	.dw 0x2140, 0xc839,	0x217f, 0xc839,		0x21, 0
	.dw 0x21c0, 0xc839,	0x21ff, 0xc839,		0x21, 0
	.dw 0x2240, 0xc839,	0x227f, 0xc839,		0x21, 0
	.dw 0x22c0, 0xc839,	0x22ff, 0xc839,		0x21, 0
	.dw 0x2340, 0xc839,	0x237f, 0xc839,		0x21, 0
	.dw 0x23c0, 0xc839,	0x23ff, 0xc839,		0x21, 0
	.dw 0x2440, 0xc839,	0x247f, 0xc839,		0x21, 0
	.dw 0x24c0, 0xc839,	0x24ff, 0xc839,		0x21, 0
	.dw 0x2540, 0xc839,	0x257f, 0xc839,		0x21, 0
	.dw 0x25c0, 0xc839,	0x25ff, 0xc839,		0x21, 0
	.dw 0x2640, 0xc839,	0x267f, 0xc839,		0x21, 0
	.dw 0x26c0, 0xc839,	0x26ff, 0xc839,		0x21, 0
	.dw 0x2740, 0xc839,	0x277f, 0xc839,		0x21, 0
	.dw 0x27c0, 0xc839,	0x27ff, 0xc839,		0x21, 0
	.dw 0x2840, 0xc839,	0x287f, 0xc839,		0x21, 0
	.dw 0x28c0, 0xc839,	0x28ff, 0xc839,		0x21, 0
	.dw 0x2940, 0xc839,	0x297f, 0xc839,		0x21, 0
	.dw 0x29c0, 0xc839,	0x29ff, 0xc839,		0x21, 0
	.dw 0x2a40, 0xc839,	0x2a7f, 0xc839,		0x21, 0
	.dw 0x2ac0, 0xc839,	0x2aff, 0xc839,		0x21, 0
	.dw 0x2b40, 0xc839,	0x2b7f, 0xc839,		0x21, 0
	.dw 0x2bc0, 0xc839,	0x2bff, 0xc839,		0x21, 0
	.dw 0x2c40, 0xc839,	0x2c7f, 0xc839,		0x21, 0
	.dw 0x2cc0, 0xc839,	0x2cff, 0xc839,		0x21, 0
	.dw 0x2d40, 0xc839,	0x2d7f, 0xc839,		0x21, 0
	.dw 0x2dc0, 0xc839,	0x2dff, 0xc839,		0x21, 0
	.dw 0x2e40, 0xc839,	0x2e7f, 0xc839,		0x21, 0
	.dw 0x2ec0, 0xc839,	0x2eff, 0xc839,		0x21, 0
	.dw 0x2f40, 0xc839,	0x2f7f, 0xc839,		0x21, 0
	.dw 0x2fc0, 0xc839,	0x2fff, 0xc839,		0x21, 0
	.dw 0x3040, 0xc839,	0x307f, 0xc839,		0x21, 0
	.dw 0x30c0, 0xc839,	0x30ff, 0xc839,		0x21, 0
	.dw 0x3140, 0xc839,	0x317f, 0xc839,		0x21, 0
	.dw 0x31c0, 0xc839,	0x31ff, 0xc839,		0x21, 0
	.dw 0x3240, 0xc839,	0x327f, 0xc839,		0x21, 0
	.dw 0x32c0, 0xc839,	0x32ff, 0xc839,		0x21, 0
	.dw 0x3340, 0xc839,	0x337f, 0xc839,		0x21, 0
	.dw 0x33c0, 0xc839,	0x33ff, 0xc839,		0x21, 0
	.dw 0x3440, 0xc839,	0x347f, 0xc839,		0x21, 0
	.dw 0x34c0, 0xc839,	0x34ff, 0xc839,		0x21, 0
	.dw 0x3540, 0xc839,	0x357f, 0xc839,		0x21, 0
	.dw 0x35c0, 0xc839,	0x35ff, 0xc839,		0x21, 0
	.dw 0x3640, 0xc839,	0x367f, 0xc839,		0x21, 0
	.dw 0x36c0, 0xc839,	0x36ff, 0xc839,		0x21, 0
	.dw 0x3740, 0xc839,	0x377f, 0xc839,		0x21, 0
	.dw 0x37c0, 0xc839,	0x37ff, 0xc839,		0x21, 0
	.dw 0x3840, 0xc839,	0x387f, 0xc839,		0x21, 0
	.dw 0x38c0, 0xc839,	0x38ff, 0xc839,		0x21, 0
	.dw 0x3940, 0xc839,	0x397f, 0xc839,		0x21, 0
	.dw 0x39c0, 0xc839,	0x5fff, 0xc839,		0x21, 0
	.dw 0x6040, 0xc839,	0x607f, 0xc839,		0x21, 0
	.dw 0x60c0, 0xc839,	0x60ff, 0xc839,		0x21, 0
	.dw 0x6140, 0xc839,	0x617f, 0xc839,		0x21, 0
	.dw 0x61c0, 0xc839,	0x61ff, 0xc839,		0x21, 0
	.dw 0x6240, 0xc839,	0x627f, 0xc839,		0x21, 0
	.dw 0x62c0, 0xc839,	0x62ff, 0xc839,		0x21, 0
	.dw 0x6340, 0xc839,	0x637f, 0xc839,		0x21, 0
	.dw 0x63c0, 0xc839,	0x63ff, 0xc839,		0x21, 0
	.dw 0x6440, 0xc839,	0x647f, 0xc839,		0x21, 0
	.dw 0x64c0, 0xc839,	0x64ff, 0xc839,		0x21, 0
	.dw 0x6540, 0xc839,	0x657f, 0xc839,		0x21, 0
	.dw 0x65c0, 0xc839,	0x65ff, 0xc839,		0x21, 0
	.dw 0x6640, 0xc839,	0x667f, 0xc839,		0x21, 0
	.dw 0x66c0, 0xc839,	0x66ff, 0xc839,		0x21, 0
	.dw 0x6740, 0xc839,	0x677f, 0xc839,		0x21, 0
	.dw 0x67c0, 0xc839,	0x67ff, 0xc839,		0x21, 0
	.dw 0x6840, 0xc839,	0x687f, 0xc839,		0x21, 0
	.dw 0x68c0, 0xc839,	0x68ff, 0xc839,		0x21, 0
	.dw 0x6940, 0xc839,	0x697f, 0xc839,		0x21, 0
	.dw 0x69c0, 0xc839,	0x69ff, 0xc839,		0x21, 0
	.dw 0x6a40, 0xc839,	0x6a7f, 0xc839,		0x21, 0
	.dw 0x6ac0, 0xc839,	0x6aff, 0xc839,		0x21, 0
	.dw 0x6b40, 0xc839,	0x6b7f, 0xc839,		0x21, 0
	.dw 0x6bc0, 0xc839,	0x6bff, 0xc839,		0x21, 0
	.dw 0x6c40, 0xc839,	0x6c7f, 0xc839,		0x21, 0
	.dw 0x6cc0, 0xc839,	0x6cff, 0xc839,		0x21, 0
	.dw 0x6d40, 0xc839,	0x6d7f, 0xc839,		0x21, 0
	.dw 0x6dc0, 0xc839,	0x6dff, 0xc839,		0x21, 0
	.dw 0x6e40, 0xc839,	0x6e7f, 0xc839,		0x21, 0
	.dw 0x6ec0, 0xc839,	0x6eff, 0xc839,		0x21, 0
	.dw 0x6f40, 0xc839,	0x6f7f, 0xc839,		0x21, 0
	.dw 0x6fc0, 0xc839,	0x6fff, 0xc839,		0x21, 0
	.dw 0x7040, 0xc839,	0x707f, 0xc839,		0x21, 0
	.dw 0x70c0, 0xc839,	0x70ff, 0xc839,		0x21, 0
	.dw 0x7140, 0xc839,	0x717f, 0xc839,		0x21, 0
	.dw 0x71c0, 0xc839,	0x71ff, 0xc839,		0x21, 0
	.dw 0x7240, 0xc839,	0x727f, 0xc839,		0x21, 0
	.dw 0x72c0, 0xc839,	0x72ff, 0xc839,		0x21, 0
	.dw 0x7340, 0xc839,	0x737f, 0xc839,		0x21, 0
	.dw 0x73c0, 0xc839,	0x73ff, 0xc839,		0x21, 0
	.dw 0x7440, 0xc839,	0x747f, 0xc839,		0x21, 0
	.dw 0x74c0, 0xc839,	0x74ff, 0xc839,		0x21, 0
	.dw 0x7540, 0xc839,	0x757f, 0xc839,		0x21, 0
	.dw 0x75c0, 0xc839,	0x75ff, 0xc839,		0x21, 0
	.dw 0x7640, 0xc839,	0x767f, 0xc839,		0x21, 0
	.dw 0x76c0, 0xc839,	0x76ff, 0xc839,		0x21, 0
	.dw 0x7740, 0xc839,	0x777f, 0xc839,		0x21, 0
	.dw 0x77c0, 0xc839,	0x77ff, 0xc839,		0x21, 0
	.dw 0x7840, 0xc839,	0x787f, 0xc839,		0x21, 0
	.dw 0x78c0, 0xc839,	0x78ff, 0xc839,		0x21, 0
	.dw 0x7940, 0xc839,	0x797f, 0xc839,		0x21, 0
	.dw 0x79c0, 0xc839,	0x9fff, 0xc839,		0x21, 0
	.dw 0xa040, 0xc839,	0xa07f, 0xc839,		0x21, 0
	.dw 0xa0c0, 0xc839,	0xa0ff, 0xc839,		0x21, 0
	.dw 0xa140, 0xc839,	0xa17f, 0xc839,		0x21, 0
	.dw 0xa1c0, 0xc839,	0xa1ff, 0xc839,		0x21, 0
	.dw 0xa240, 0xc839,	0xa27f, 0xc839,		0x21, 0
	.dw 0xa2c0, 0xc839,	0xa2ff, 0xc839,		0x21, 0
	.dw 0xa340, 0xc839,	0xa37f, 0xc839,		0x21, 0
	.dw 0xa3c0, 0xc839,	0xa3ff, 0xc839,		0x21, 0
	.dw 0xa440, 0xc839,	0xa47f, 0xc839,		0x21, 0
	.dw 0xa4c0, 0xc839,	0xa4ff, 0xc839,		0x21, 0
	.dw 0xa540, 0xc839,	0xa57f, 0xc839,		0x21, 0
	.dw 0xa5c0, 0xc839,	0xa5ff, 0xc839,		0x21, 0
	.dw 0xa640, 0xc839,	0xa67f, 0xc839,		0x21, 0
	.dw 0xa6c0, 0xc839,	0xa6ff, 0xc839,		0x21, 0
	.dw 0xa740, 0xc839,	0xa77f, 0xc839,		0x21, 0
	.dw 0xa7c0, 0xc839,	0xa7ff, 0xc839,		0x21, 0
	.dw 0xa840, 0xc839,	0xa87f, 0xc839,		0x21, 0
	.dw 0xa8c0, 0xc839,	0xa8ff, 0xc839,		0x21, 0
	.dw 0xa940, 0xc839,	0xa97f, 0xc839,		0x21, 0
	.dw 0xa9c0, 0xc839,	0xa9ff, 0xc839,		0x21, 0
	.dw 0xaa40, 0xc839,	0xaa7f, 0xc839,		0x21, 0
	.dw 0xaac0, 0xc839,	0xaaff, 0xc839,		0x21, 0
	.dw 0xab40, 0xc839,	0xab7f, 0xc839,		0x21, 0
	.dw 0xabc0, 0xc839,	0xabff, 0xc839,		0x21, 0
	.dw 0xac40, 0xc839,	0xac7f, 0xc839,		0x21, 0
	.dw 0xacc0, 0xc839,	0xacff, 0xc839,		0x21, 0
	.dw 0xad40, 0xc839,	0xad7f, 0xc839,		0x21, 0
	.dw 0xadc0, 0xc839,	0xadff, 0xc839,		0x21, 0
	.dw 0xae40, 0xc839,	0xae7f, 0xc839,		0x21, 0
	.dw 0xaec0, 0xc839,	0xaeff, 0xc839,		0x21, 0
	.dw 0xaf40, 0xc839,	0xaf7f, 0xc839,		0x21, 0
	.dw 0xafc0, 0xc839,	0xafff, 0xc839,		0x21, 0
	.dw 0xb040, 0xc839,	0xb07f, 0xc839,		0x21, 0
	.dw 0xb0c0, 0xc839,	0xb0ff, 0xc839,		0x21, 0
	.dw 0xb140, 0xc839,	0xb17f, 0xc839,		0x21, 0
	.dw 0xb1c0, 0xc839,	0xb1ff, 0xc839,		0x21, 0
	.dw 0xb240, 0xc839,	0xb27f, 0xc839,		0x21, 0
	.dw 0xb2c0, 0xc839,	0xb2ff, 0xc839,		0x21, 0
	.dw 0xb340, 0xc839,	0xb37f, 0xc839,		0x21, 0
	.dw 0xb3c0, 0xc839,	0xb3ff, 0xc839,		0x21, 0
	.dw 0xb440, 0xc839,	0xb47f, 0xc839,		0x21, 0
	.dw 0xb4c0, 0xc839,	0xb4ff, 0xc839,		0x21, 0
	.dw 0xb540, 0xc839,	0xb57f, 0xc839,		0x21, 0
	.dw 0xb5c0, 0xc839,	0xb5ff, 0xc839,		0x21, 0
	.dw 0xb640, 0xc839,	0xb67f, 0xc839,		0x21, 0
	.dw 0xb6c0, 0xc839,	0xb6ff, 0xc839,		0x21, 0
	.dw 0xb740, 0xc839,	0xb77f, 0xc839,		0x21, 0
	.dw 0xb7c0, 0xc839,	0xb7ff, 0xc839,		0x21, 0
	.dw 0xb840, 0xc839,	0xb87f, 0xc839,		0x21, 0
	.dw 0xb8c0, 0xc839,	0xb8ff, 0xc839,		0x21, 0
	.dw 0xb940, 0xc839,	0xb97f, 0xc839,		0x21, 0
	.dw 0xb9c0, 0xc839,	0xdfff, 0xc839,		0x21, 0
	.dw 0xe040, 0xc839,	0xe07f, 0xc839,		0x21, 0
	.dw 0xe0c0, 0xc839,	0xe0ff, 0xc839,		0x21, 0
	.dw 0xe140, 0xc839,	0xe17f, 0xc839,		0x21, 0
	.dw 0xe1c0, 0xc839,	0xe1ff, 0xc839,		0x21, 0
	.dw 0xe240, 0xc839,	0xe27f, 0xc839,		0x21, 0
	.dw 0xe2c0, 0xc839,	0xe2ff, 0xc839,		0x21, 0
	.dw 0xe340, 0xc839,	0xe37f, 0xc839,		0x21, 0
	.dw 0xe3c0, 0xc839,	0xe3ff, 0xc839,		0x21, 0
	.dw 0xe440, 0xc839,	0xe47f, 0xc839,		0x21, 0
	.dw 0xe4c0, 0xc839,	0xe4ff, 0xc839,		0x21, 0
	.dw 0xe540, 0xc839,	0xe57f, 0xc839,		0x21, 0
	.dw 0xe5c0, 0xc839,	0xe5ff, 0xc839,		0x21, 0
	.dw 0xe640, 0xc839,	0xe67f, 0xc839,		0x21, 0
	.dw 0xe6c0, 0xc839,	0xe6ff, 0xc839,		0x21, 0
	.dw 0xe740, 0xc839,	0xe77f, 0xc839,		0x21, 0
	.dw 0xe7c0, 0xc839,	0xe7ff, 0xc839,		0x21, 0
	.dw 0xe840, 0xc839,	0xe87f, 0xc839,		0x21, 0
	.dw 0xe8c0, 0xc839,	0xe8ff, 0xc839,		0x21, 0
	.dw 0xe940, 0xc839,	0xe97f, 0xc839,		0x21, 0
	.dw 0xe9c0, 0xc839,	0xe9ff, 0xc839,		0x21, 0
	.dw 0xea40, 0xc839,	0xea7f, 0xc839,		0x21, 0
	.dw 0xeac0, 0xc839,	0xeaff, 0xc839,		0x21, 0
	.dw 0xeb40, 0xc839,	0xeb7f, 0xc839,		0x21, 0
	.dw 0xebc0, 0xc839,	0xebff, 0xc839,		0x21, 0
	.dw 0xec40, 0xc839,	0xec7f, 0xc839,		0x21, 0
	.dw 0xecc0, 0xc839,	0xecff, 0xc839,		0x21, 0
	.dw 0xed40, 0xc839,	0xed7f, 0xc839,		0x21, 0
	.dw 0xedc0, 0xc839,	0xedff, 0xc839,		0x21, 0
	.dw 0xee40, 0xc839,	0xee7f, 0xc839,		0x21, 0
	.dw 0xeec0, 0xc839,	0xeeff, 0xc839,		0x21, 0
	.dw 0xef40, 0xc839,	0xef7f, 0xc839,		0x21, 0
	.dw 0xefc0, 0xc839,	0xefff, 0xc839,		0x21, 0
	.dw 0xf040, 0xc839,	0xf07f, 0xc839,		0x21, 0
	.dw 0xf0c0, 0xc839,	0xf0ff, 0xc839,		0x21, 0
	.dw 0xf140, 0xc839,	0xf17f, 0xc839,		0x21, 0
	.dw 0xf1c0, 0xc839,	0xf1ff, 0xc839,		0x21, 0
	.dw 0xf240, 0xc839,	0xf27f, 0xc839,		0x21, 0
	.dw 0xf2c0, 0xc839,	0xf2ff, 0xc839,		0x21, 0
	.dw 0xf340, 0xc839,	0xf37f, 0xc839,		0x21, 0
	.dw 0xf3c0, 0xc839,	0xf3ff, 0xc839,		0x21, 0
	.dw 0xf440, 0xc839,	0xf47f, 0xc839,		0x21, 0
	.dw 0xf4c0, 0xc839,	0xf4ff, 0xc839,		0x21, 0
	.dw 0xf540, 0xc839,	0xf57f, 0xc839,		0x21, 0
	.dw 0xf5c0, 0xc839,	0xf5ff, 0xc839,		0x21, 0
	.dw 0xf640, 0xc839,	0xf67f, 0xc839,		0x21, 0
	.dw 0xf6c0, 0xc839,	0xf6ff, 0xc839,		0x21, 0
	.dw 0xf740, 0xc839,	0xf77f, 0xc839,		0x21, 0
	.dw 0xf7c0, 0xc839,	0xf7ff, 0xc839,		0x21, 0
	.dw 0xf840, 0xc839,	0xf87f, 0xc839,		0x21, 0
	.dw 0xf8c0, 0xc839,	0xf8ff, 0xc839,		0x21, 0
	.dw 0xf940, 0xc839,	0xf97f, 0xc839,		0x21, 0
	.dw 0xf9c0, 0xc839,	0x1fff, 0xc83a,		0x21, 0
	.dw 0x2040, 0xc83a,	0x207f, 0xc83a,		0x21, 0
	.dw 0x20c0, 0xc83a,	0x20ff, 0xc83a,		0x21, 0
	.dw 0x2140, 0xc83a,	0x217f, 0xc83a,		0x21, 0
	.dw 0x21c0, 0xc83a,	0x21ff, 0xc83a,		0x21, 0
	.dw 0x2240, 0xc83a,	0x227f, 0xc83a,		0x21, 0
	.dw 0x22c0, 0xc83a,	0x22ff, 0xc83a,		0x21, 0
	.dw 0x2340, 0xc83a,	0x237f, 0xc83a,		0x21, 0
	.dw 0x23c0, 0xc83a,	0x23ff, 0xc83a,		0x21, 0
	.dw 0x2440, 0xc83a,	0x247f, 0xc83a,		0x21, 0
	.dw 0x24c0, 0xc83a,	0x24ff, 0xc83a,		0x21, 0
	.dw 0x2540, 0xc83a,	0x257f, 0xc83a,		0x21, 0
	.dw 0x25c0, 0xc83a,	0x25ff, 0xc83a,		0x21, 0
	.dw 0x2640, 0xc83a,	0x267f, 0xc83a,		0x21, 0
	.dw 0x26c0, 0xc83a,	0x26ff, 0xc83a,		0x21, 0
	.dw 0x2740, 0xc83a,	0x277f, 0xc83a,		0x21, 0
	.dw 0x27c0, 0xc83a,	0x27ff, 0xc83a,		0x21, 0
	.dw 0x2840, 0xc83a,	0x287f, 0xc83a,		0x21, 0
	.dw 0x28c0, 0xc83a,	0x28ff, 0xc83a,		0x21, 0
	.dw 0x2940, 0xc83a,	0x297f, 0xc83a,		0x21, 0
	.dw 0x29c0, 0xc83a,	0x29ff, 0xc83a,		0x21, 0
	.dw 0x2a40, 0xc83a,	0x2a7f, 0xc83a,		0x21, 0
	.dw 0x2ac0, 0xc83a,	0x2aff, 0xc83a,		0x21, 0
	.dw 0x2b40, 0xc83a,	0x2b7f, 0xc83a,		0x21, 0
	.dw 0x2bc0, 0xc83a,	0x2bff, 0xc83a,		0x21, 0
	.dw 0x2c40, 0xc83a,	0x2c7f, 0xc83a,		0x21, 0
	.dw 0x2cc0, 0xc83a,	0x2cff, 0xc83a,		0x21, 0
	.dw 0x2d40, 0xc83a,	0x2d7f, 0xc83a,		0x21, 0
	.dw 0x2dc0, 0xc83a,	0x2dff, 0xc83a,		0x21, 0
	.dw 0x2e40, 0xc83a,	0x2e7f, 0xc83a,		0x21, 0
	.dw 0x2ec0, 0xc83a,	0x2eff, 0xc83a,		0x21, 0
	.dw 0x2f40, 0xc83a,	0x2f7f, 0xc83a,		0x21, 0
	.dw 0x2fc0, 0xc83a,	0x2fff, 0xc83a,		0x21, 0
	.dw 0x3040, 0xc83a,	0x307f, 0xc83a,		0x21, 0
	.dw 0x30c0, 0xc83a,	0x30ff, 0xc83a,		0x21, 0
	.dw 0x3140, 0xc83a,	0x317f, 0xc83a,		0x21, 0
	.dw 0x31c0, 0xc83a,	0x31ff, 0xc83a,		0x21, 0
	.dw 0x3240, 0xc83a,	0x327f, 0xc83a,		0x21, 0
	.dw 0x32c0, 0xc83a,	0x32ff, 0xc83a,		0x21, 0
	.dw 0x3340, 0xc83a,	0x337f, 0xc83a,		0x21, 0
	.dw 0x33c0, 0xc83a,	0x33ff, 0xc83a,		0x21, 0
	.dw 0x3440, 0xc83a,	0x347f, 0xc83a,		0x21, 0
	.dw 0x34c0, 0xc83a,	0x34ff, 0xc83a,		0x21, 0
	.dw 0x3540, 0xc83a,	0x357f, 0xc83a,		0x21, 0
	.dw 0x35c0, 0xc83a,	0x35ff, 0xc83a,		0x21, 0
	.dw 0x3640, 0xc83a,	0x367f, 0xc83a,		0x21, 0
	.dw 0x36c0, 0xc83a,	0x36ff, 0xc83a,		0x21, 0
	.dw 0x3740, 0xc83a,	0x377f, 0xc83a,		0x21, 0
	.dw 0x37c0, 0xc83a,	0x37ff, 0xc83a,		0x21, 0
	.dw 0x3840, 0xc83a,	0x387f, 0xc83a,		0x21, 0
	.dw 0x38c0, 0xc83a,	0x38ff, 0xc83a,		0x21, 0
	.dw 0x3940, 0xc83a,	0x397f, 0xc83a,		0x21, 0
	.dw 0x39c0, 0xc83a,	0x5fff, 0xc83a,		0x21, 0
	.dw 0x6040, 0xc83a,	0x607f, 0xc83a,		0x21, 0
	.dw 0x60c0, 0xc83a,	0x60ff, 0xc83a,		0x21, 0
	.dw 0x6140, 0xc83a,	0x617f, 0xc83a,		0x21, 0
	.dw 0x61c0, 0xc83a,	0x61ff, 0xc83a,		0x21, 0
	.dw 0x6240, 0xc83a,	0x627f, 0xc83a,		0x21, 0
	.dw 0x62c0, 0xc83a,	0x62ff, 0xc83a,		0x21, 0
	.dw 0x6340, 0xc83a,	0x637f, 0xc83a,		0x21, 0
	.dw 0x63c0, 0xc83a,	0x63ff, 0xc83a,		0x21, 0
	.dw 0x6440, 0xc83a,	0x647f, 0xc83a,		0x21, 0
	.dw 0x64c0, 0xc83a,	0x64ff, 0xc83a,		0x21, 0
	.dw 0x6540, 0xc83a,	0x657f, 0xc83a,		0x21, 0
	.dw 0x65c0, 0xc83a,	0x65ff, 0xc83a,		0x21, 0
	.dw 0x6640, 0xc83a,	0x667f, 0xc83a,		0x21, 0
	.dw 0x66c0, 0xc83a,	0x66ff, 0xc83a,		0x21, 0
	.dw 0x6740, 0xc83a,	0x677f, 0xc83a,		0x21, 0
	.dw 0x67c0, 0xc83a,	0x67ff, 0xc83a,		0x21, 0
	.dw 0x6840, 0xc83a,	0x687f, 0xc83a,		0x21, 0
	.dw 0x68c0, 0xc83a,	0x68ff, 0xc83a,		0x21, 0
	.dw 0x6940, 0xc83a,	0x697f, 0xc83a,		0x21, 0
	.dw 0x69c0, 0xc83a,	0x69ff, 0xc83a,		0x21, 0
	.dw 0x6a40, 0xc83a,	0x6a7f, 0xc83a,		0x21, 0
	.dw 0x6ac0, 0xc83a,	0x6aff, 0xc83a,		0x21, 0
	.dw 0x6b40, 0xc83a,	0x6b7f, 0xc83a,		0x21, 0
	.dw 0x6bc0, 0xc83a,	0x6bff, 0xc83a,		0x21, 0
	.dw 0x6c40, 0xc83a,	0x6c7f, 0xc83a,		0x21, 0
	.dw 0x6cc0, 0xc83a,	0x6cff, 0xc83a,		0x21, 0
	.dw 0x6d40, 0xc83a,	0x6d7f, 0xc83a,		0x21, 0
	.dw 0x6dc0, 0xc83a,	0x6dff, 0xc83a,		0x21, 0
	.dw 0x6e40, 0xc83a,	0x6e7f, 0xc83a,		0x21, 0
	.dw 0x6ec0, 0xc83a,	0x6eff, 0xc83a,		0x21, 0
	.dw 0x6f40, 0xc83a,	0x6f7f, 0xc83a,		0x21, 0
	.dw 0x6fc0, 0xc83a,	0x6fff, 0xc83a,		0x21, 0
	.dw 0x7040, 0xc83a,	0x707f, 0xc83a,		0x21, 0
	.dw 0x70c0, 0xc83a,	0x70ff, 0xc83a,		0x21, 0
	.dw 0x7140, 0xc83a,	0x717f, 0xc83a,		0x21, 0
	.dw 0x71c0, 0xc83a,	0x71ff, 0xc83a,		0x21, 0
	.dw 0x7240, 0xc83a,	0x727f, 0xc83a,		0x21, 0
	.dw 0x72c0, 0xc83a,	0x72ff, 0xc83a,		0x21, 0
	.dw 0x7340, 0xc83a,	0x737f, 0xc83a,		0x21, 0
	.dw 0x73c0, 0xc83a,	0x73ff, 0xc83a,		0x21, 0
	.dw 0x7440, 0xc83a,	0x747f, 0xc83a,		0x21, 0
	.dw 0x74c0, 0xc83a,	0x74ff, 0xc83a,		0x21, 0
	.dw 0x7540, 0xc83a,	0x757f, 0xc83a,		0x21, 0
	.dw 0x75c0, 0xc83a,	0x75ff, 0xc83a,		0x21, 0
	.dw 0x7640, 0xc83a,	0x767f, 0xc83a,		0x21, 0
	.dw 0x76c0, 0xc83a,	0x76ff, 0xc83a,		0x21, 0
	.dw 0x7740, 0xc83a,	0x777f, 0xc83a,		0x21, 0
	.dw 0x77c0, 0xc83a,	0x77ff, 0xc83a,		0x21, 0
	.dw 0x7840, 0xc83a,	0x787f, 0xc83a,		0x21, 0
	.dw 0x78c0, 0xc83a,	0x78ff, 0xc83a,		0x21, 0
	.dw 0x7940, 0xc83a,	0x797f, 0xc83a,		0x21, 0
	.dw 0x79c0, 0xc83a,	0x9fff, 0xc83a,		0x21, 0
	.dw 0xa040, 0xc83a,	0xa07f, 0xc83a,		0x21, 0
	.dw 0xa0c0, 0xc83a,	0xa0ff, 0xc83a,		0x21, 0
	.dw 0xa140, 0xc83a,	0xa17f, 0xc83a,		0x21, 0
	.dw 0xa1c0, 0xc83a,	0xa1ff, 0xc83a,		0x21, 0
	.dw 0xa240, 0xc83a,	0xa27f, 0xc83a,		0x21, 0
	.dw 0xa2c0, 0xc83a,	0xa2ff, 0xc83a,		0x21, 0
	.dw 0xa340, 0xc83a,	0xa37f, 0xc83a,		0x21, 0
	.dw 0xa3c0, 0xc83a,	0xa3ff, 0xc83a,		0x21, 0
	.dw 0xa440, 0xc83a,	0xa47f, 0xc83a,		0x21, 0
	.dw 0xa4c0, 0xc83a,	0xa4ff, 0xc83a,		0x21, 0
	.dw 0xa540, 0xc83a,	0xa57f, 0xc83a,		0x21, 0
	.dw 0xa5c0, 0xc83a,	0xa5ff, 0xc83a,		0x21, 0
	.dw 0xa640, 0xc83a,	0xa67f, 0xc83a,		0x21, 0
	.dw 0xa6c0, 0xc83a,	0xa6ff, 0xc83a,		0x21, 0
	.dw 0xa740, 0xc83a,	0xa77f, 0xc83a,		0x21, 0
	.dw 0xa7c0, 0xc83a,	0xa7ff, 0xc83a,		0x21, 0
	.dw 0xa840, 0xc83a,	0xa87f, 0xc83a,		0x21, 0
	.dw 0xa8c0, 0xc83a,	0xa8ff, 0xc83a,		0x21, 0
	.dw 0xa940, 0xc83a,	0xa97f, 0xc83a,		0x21, 0
	.dw 0xa9c0, 0xc83a,	0xa9ff, 0xc83a,		0x21, 0
	.dw 0xaa40, 0xc83a,	0xaa7f, 0xc83a,		0x21, 0
	.dw 0xaac0, 0xc83a,	0xaaff, 0xc83a,		0x21, 0
	.dw 0xab40, 0xc83a,	0xab7f, 0xc83a,		0x21, 0
	.dw 0xabc0, 0xc83a,	0xabff, 0xc83a,		0x21, 0
	.dw 0xac40, 0xc83a,	0xac7f, 0xc83a,		0x21, 0
	.dw 0xacc0, 0xc83a,	0xacff, 0xc83a,		0x21, 0
	.dw 0xad40, 0xc83a,	0xad7f, 0xc83a,		0x21, 0
	.dw 0xadc0, 0xc83a,	0xadff, 0xc83a,		0x21, 0
	.dw 0xae40, 0xc83a,	0xae7f, 0xc83a,		0x21, 0
	.dw 0xaec0, 0xc83a,	0xaeff, 0xc83a,		0x21, 0
	.dw 0xaf40, 0xc83a,	0xaf7f, 0xc83a,		0x21, 0
	.dw 0xafc0, 0xc83a,	0xafff, 0xc83a,		0x21, 0
	.dw 0xb040, 0xc83a,	0xb07f, 0xc83a,		0x21, 0
	.dw 0xb0c0, 0xc83a,	0xb0ff, 0xc83a,		0x21, 0
	.dw 0xb140, 0xc83a,	0xb17f, 0xc83a,		0x21, 0
	.dw 0xb1c0, 0xc83a,	0xb1ff, 0xc83a,		0x21, 0
	.dw 0xb240, 0xc83a,	0xb27f, 0xc83a,		0x21, 0
	.dw 0xb2c0, 0xc83a,	0xb2ff, 0xc83a,		0x21, 0
	.dw 0xb340, 0xc83a,	0xb37f, 0xc83a,		0x21, 0
	.dw 0xb3c0, 0xc83a,	0xb3ff, 0xc83a,		0x21, 0
	.dw 0xb440, 0xc83a,	0xb47f, 0xc83a,		0x21, 0
	.dw 0xb4c0, 0xc83a,	0xb4ff, 0xc83a,		0x21, 0
	.dw 0xb540, 0xc83a,	0xb57f, 0xc83a,		0x21, 0
	.dw 0xb5c0, 0xc83a,	0xb5ff, 0xc83a,		0x21, 0
	.dw 0xb640, 0xc83a,	0xb67f, 0xc83a,		0x21, 0
	.dw 0xb6c0, 0xc83a,	0xb6ff, 0xc83a,		0x21, 0
	.dw 0xb740, 0xc83a,	0xb77f, 0xc83a,		0x21, 0
	.dw 0xb7c0, 0xc83a,	0xb7ff, 0xc83a,		0x21, 0
	.dw 0xb840, 0xc83a,	0xb87f, 0xc83a,		0x21, 0
	.dw 0xb8c0, 0xc83a,	0xb8ff, 0xc83a,		0x21, 0
	.dw 0xb940, 0xc83a,	0xb97f, 0xc83a,		0x21, 0
	.dw 0xb9c0, 0xc83a,	0xdfff, 0xc83a,		0x21, 0
	.dw 0xe040, 0xc83a,	0xe07f, 0xc83a,		0x21, 0
	.dw 0xe0c0, 0xc83a,	0xe0ff, 0xc83a,		0x21, 0
	.dw 0xe140, 0xc83a,	0xe17f, 0xc83a,		0x21, 0
	.dw 0xe1c0, 0xc83a,	0xe1ff, 0xc83a,		0x21, 0
	.dw 0xe240, 0xc83a,	0xe27f, 0xc83a,		0x21, 0
	.dw 0xe2c0, 0xc83a,	0xe2ff, 0xc83a,		0x21, 0
	.dw 0xe340, 0xc83a,	0xe37f, 0xc83a,		0x21, 0
	.dw 0xe3c0, 0xc83a,	0xe3ff, 0xc83a,		0x21, 0
	.dw 0xe440, 0xc83a,	0xe47f, 0xc83a,		0x21, 0
	.dw 0xe4c0, 0xc83a,	0xe4ff, 0xc83a,		0x21, 0
	.dw 0xe540, 0xc83a,	0xe57f, 0xc83a,		0x21, 0
	.dw 0xe5c0, 0xc83a,	0xe5ff, 0xc83a,		0x21, 0
	.dw 0xe640, 0xc83a,	0xe67f, 0xc83a,		0x21, 0
	.dw 0xe6c0, 0xc83a,	0xe6ff, 0xc83a,		0x21, 0
	.dw 0xe740, 0xc83a,	0xe77f, 0xc83a,		0x21, 0
	.dw 0xe7c0, 0xc83a,	0xe7ff, 0xc83a,		0x21, 0
	.dw 0xe840, 0xc83a,	0xe87f, 0xc83a,		0x21, 0
	.dw 0xe8c0, 0xc83a,	0xe8ff, 0xc83a,		0x21, 0
	.dw 0xe940, 0xc83a,	0xe97f, 0xc83a,		0x21, 0
	.dw 0xe9c0, 0xc83a,	0xe9ff, 0xc83a,		0x21, 0
	.dw 0xea40, 0xc83a,	0xea7f, 0xc83a,		0x21, 0
	.dw 0xeac0, 0xc83a,	0xeaff, 0xc83a,		0x21, 0
	.dw 0xeb40, 0xc83a,	0xeb7f, 0xc83a,		0x21, 0
	.dw 0xebc0, 0xc83a,	0xebff, 0xc83a,		0x21, 0
	.dw 0xec40, 0xc83a,	0xec7f, 0xc83a,		0x21, 0
	.dw 0xecc0, 0xc83a,	0xecff, 0xc83a,		0x21, 0
	.dw 0xed40, 0xc83a,	0xed7f, 0xc83a,		0x21, 0
	.dw 0xedc0, 0xc83a,	0xedff, 0xc83a,		0x21, 0
	.dw 0xee40, 0xc83a,	0xee7f, 0xc83a,		0x21, 0
	.dw 0xeec0, 0xc83a,	0xeeff, 0xc83a,		0x21, 0
	.dw 0xef40, 0xc83a,	0xef7f, 0xc83a,		0x21, 0
	.dw 0xefc0, 0xc83a,	0xefff, 0xc83a,		0x21, 0
	.dw 0xf040, 0xc83a,	0xf07f, 0xc83a,		0x21, 0
	.dw 0xf0c0, 0xc83a,	0xf0ff, 0xc83a,		0x21, 0
	.dw 0xf140, 0xc83a,	0xf17f, 0xc83a,		0x21, 0
	.dw 0xf1c0, 0xc83a,	0xf1ff, 0xc83a,		0x21, 0
	.dw 0xf240, 0xc83a,	0xf27f, 0xc83a,		0x21, 0
	.dw 0xf2c0, 0xc83a,	0xf2ff, 0xc83a,		0x21, 0
	.dw 0xf340, 0xc83a,	0xf37f, 0xc83a,		0x21, 0
	.dw 0xf3c0, 0xc83a,	0xf3ff, 0xc83a,		0x21, 0
	.dw 0xf440, 0xc83a,	0xf47f, 0xc83a,		0x21, 0
	.dw 0xf4c0, 0xc83a,	0xf4ff, 0xc83a,		0x21, 0
	.dw 0xf540, 0xc83a,	0xf57f, 0xc83a,		0x21, 0
	.dw 0xf5c0, 0xc83a,	0xf5ff, 0xc83a,		0x21, 0
	.dw 0xf640, 0xc83a,	0xf67f, 0xc83a,		0x21, 0
	.dw 0xf6c0, 0xc83a,	0xf6ff, 0xc83a,		0x21, 0
	.dw 0xf740, 0xc83a,	0xf77f, 0xc83a,		0x21, 0
	.dw 0xf7c0, 0xc83a,	0xf7ff, 0xc83a,		0x21, 0
	.dw 0xf840, 0xc83a,	0xf87f, 0xc83a,		0x21, 0
	.dw 0xf8c0, 0xc83a,	0xf8ff, 0xc83a,		0x21, 0
	.dw 0xf940, 0xc83a,	0xf97f, 0xc83a,		0x21, 0
	.dw 0xf9c0, 0xc83a,	0xffff, 0xc83b,		0x21, 0
	.dw 0x0040, 0xc83c,	0x007f, 0xc83c,		0x21, 0
	.dw 0x00c0, 0xc83c,	0x00ff, 0xc83c,		0x21, 0
	.dw 0x0140, 0xc83c,	0x017f, 0xc83c,		0x21, 0
	.dw 0x01c0, 0xc83c,	0x01ff, 0xc83c,		0x21, 0
	.dw 0x0240, 0xc83c,	0x027f, 0xc83c,		0x21, 0
	.dw 0x02c0, 0xc83c,	0x02ff, 0xc83c,		0x21, 0
	.dw 0x0340, 0xc83c,	0x037f, 0xc83c,		0x21, 0
	.dw 0x03c0, 0xc83c,	0x03ff, 0xc83c,		0x21, 0
	.dw 0x0440, 0xc83c,	0x047f, 0xc83c,		0x21, 0
	.dw 0x04c0, 0xc83c,	0x04ff, 0xc83c,		0x21, 0
	.dw 0x0540, 0xc83c,	0x057f, 0xc83c,		0x21, 0
	.dw 0x05c0, 0xc83c,	0x05ff, 0xc83c,		0x21, 0
	.dw 0x0640, 0xc83c,	0x067f, 0xc83c,		0x21, 0
	.dw 0x06c0, 0xc83c,	0x06ff, 0xc83c,		0x21, 0
	.dw 0x0740, 0xc83c,	0x077f, 0xc83c,		0x21, 0
	.dw 0x07c0, 0xc83c,	0x07ff, 0xc83c,		0x21, 0
	.dw 0x0840, 0xc83c,	0x087f, 0xc83c,		0x21, 0
	.dw 0x08c0, 0xc83c,	0x08ff, 0xc83c,		0x21, 0
	.dw 0x0940, 0xc83c,	0x097f, 0xc83c,		0x21, 0
	.dw 0x09c0, 0xc83c,	0x09ff, 0xc83c,		0x21, 0
	.dw 0x0a40, 0xc83c,	0x0a7f, 0xc83c,		0x21, 0
	.dw 0x0ac0, 0xc83c,	0x0aff, 0xc83c,		0x21, 0
	.dw 0x0b40, 0xc83c,	0x0b7f, 0xc83c,		0x21, 0
	.dw 0x0bc0, 0xc83c,	0x0bff, 0xc83c,		0x21, 0
	.dw 0x0c40, 0xc83c,	0x0c7f, 0xc83c,		0x21, 0
	.dw 0x0cc0, 0xc83c,	0x0cff, 0xc83c,		0x21, 0
	.dw 0x0d40, 0xc83c,	0x0d7f, 0xc83c,		0x21, 0
	.dw 0x0dc0, 0xc83c,	0x0dff, 0xc83c,		0x21, 0
	.dw 0x0e40, 0xc83c,	0x0e7f, 0xc83c,		0x21, 0
	.dw 0x0ec0, 0xc83c,	0x0eff, 0xc83c,		0x21, 0
	.dw 0x0f40, 0xc83c,	0x0f7f, 0xc83c,		0x21, 0
	.dw 0x0fc0, 0xc83c,	0x0fff, 0xc83c,		0x21, 0
	.dw 0x1040, 0xc83c,	0x107f, 0xc83c,		0x21, 0
	.dw 0x10c0, 0xc83c,	0x10ff, 0xc83c,		0x21, 0
	.dw 0x1140, 0xc83c,	0x117f, 0xc83c,		0x21, 0
	.dw 0x11c0, 0xc83c,	0x11ff, 0xc83c,		0x21, 0
	.dw 0x1240, 0xc83c,	0x127f, 0xc83c,		0x21, 0
	.dw 0x12c0, 0xc83c,	0x12ff, 0xc83c,		0x21, 0
	.dw 0x1340, 0xc83c,	0x137f, 0xc83c,		0x21, 0
	.dw 0x13c0, 0xc83c,	0x13ff, 0xc83c,		0x21, 0
	.dw 0x1440, 0xc83c,	0x147f, 0xc83c,		0x21, 0
	.dw 0x14c0, 0xc83c,	0x14ff, 0xc83c,		0x21, 0
	.dw 0x1540, 0xc83c,	0x157f, 0xc83c,		0x21, 0
	.dw 0x15c0, 0xc83c,	0x15ff, 0xc83c,		0x21, 0
	.dw 0x1640, 0xc83c,	0x167f, 0xc83c,		0x21, 0
	.dw 0x16c0, 0xc83c,	0x16ff, 0xc83c,		0x21, 0
	.dw 0x1740, 0xc83c,	0x177f, 0xc83c,		0x21, 0
	.dw 0x17c0, 0xc83c,	0x17ff, 0xc83c,		0x21, 0
	.dw 0x1840, 0xc83c,	0x187f, 0xc83c,		0x21, 0
	.dw 0x18c0, 0xc83c,	0x18ff, 0xc83c,		0x21, 0
	.dw 0x1940, 0xc83c,	0x197f, 0xc83c,		0x21, 0
	.dw 0x19c0, 0xc83c,	0x1fff, 0xc83c,		0x21, 0
	.dw 0x2040, 0xc83c,	0x207f, 0xc83c,		0x21, 0
	.dw 0x20c0, 0xc83c,	0x20ff, 0xc83c,		0x21, 0
	.dw 0x2140, 0xc83c,	0x217f, 0xc83c,		0x21, 0
	.dw 0x21c0, 0xc83c,	0x21ff, 0xc83c,		0x21, 0
	.dw 0x2240, 0xc83c,	0x227f, 0xc83c,		0x21, 0
	.dw 0x22c0, 0xc83c,	0x22ff, 0xc83c,		0x21, 0
	.dw 0x2340, 0xc83c,	0x237f, 0xc83c,		0x21, 0
	.dw 0x23c0, 0xc83c,	0x23ff, 0xc83c,		0x21, 0
	.dw 0x2440, 0xc83c,	0x247f, 0xc83c,		0x21, 0
	.dw 0x24c0, 0xc83c,	0x24ff, 0xc83c,		0x21, 0
	.dw 0x2540, 0xc83c,	0x257f, 0xc83c,		0x21, 0
	.dw 0x25c0, 0xc83c,	0x25ff, 0xc83c,		0x21, 0
	.dw 0x2640, 0xc83c,	0x267f, 0xc83c,		0x21, 0
	.dw 0x26c0, 0xc83c,	0x26ff, 0xc83c,		0x21, 0
	.dw 0x2740, 0xc83c,	0x277f, 0xc83c,		0x21, 0
	.dw 0x27c0, 0xc83c,	0x27ff, 0xc83c,		0x21, 0
	.dw 0x2840, 0xc83c,	0x287f, 0xc83c,		0x21, 0
	.dw 0x28c0, 0xc83c,	0x28ff, 0xc83c,		0x21, 0
	.dw 0x2940, 0xc83c,	0x297f, 0xc83c,		0x21, 0
	.dw 0x29c0, 0xc83c,	0x29ff, 0xc83c,		0x21, 0
	.dw 0x2a40, 0xc83c,	0x2a7f, 0xc83c,		0x21, 0
	.dw 0x2ac0, 0xc83c,	0x2aff, 0xc83c,		0x21, 0
	.dw 0x2b40, 0xc83c,	0x2b7f, 0xc83c,		0x21, 0
	.dw 0x2bc0, 0xc83c,	0x2bff, 0xc83c,		0x21, 0
	.dw 0x2c40, 0xc83c,	0x2c7f, 0xc83c,		0x21, 0
	.dw 0x2cc0, 0xc83c,	0x2cff, 0xc83c,		0x21, 0
	.dw 0x2d40, 0xc83c,	0x2d7f, 0xc83c,		0x21, 0
	.dw 0x2dc0, 0xc83c,	0x2dff, 0xc83c,		0x21, 0
	.dw 0x2e40, 0xc83c,	0x2e7f, 0xc83c,		0x21, 0
	.dw 0x2ec0, 0xc83c,	0x2eff, 0xc83c,		0x21, 0
	.dw 0x2f40, 0xc83c,	0x2f7f, 0xc83c,		0x21, 0
	.dw 0x2fc0, 0xc83c,	0x2fff, 0xc83c,		0x21, 0
	.dw 0x3040, 0xc83c,	0x307f, 0xc83c,		0x21, 0
	.dw 0x30c0, 0xc83c,	0x30ff, 0xc83c,		0x21, 0
	.dw 0x3140, 0xc83c,	0x317f, 0xc83c,		0x21, 0
	.dw 0x31c0, 0xc83c,	0x31ff, 0xc83c,		0x21, 0
	.dw 0x3240, 0xc83c,	0x327f, 0xc83c,		0x21, 0
	.dw 0x32c0, 0xc83c,	0x32ff, 0xc83c,		0x21, 0
	.dw 0x3340, 0xc83c,	0x337f, 0xc83c,		0x21, 0
	.dw 0x33c0, 0xc83c,	0x33ff, 0xc83c,		0x21, 0
	.dw 0x3440, 0xc83c,	0x347f, 0xc83c,		0x21, 0
	.dw 0x34c0, 0xc83c,	0x34ff, 0xc83c,		0x21, 0
	.dw 0x3540, 0xc83c,	0x357f, 0xc83c,		0x21, 0
	.dw 0x35c0, 0xc83c,	0x35ff, 0xc83c,		0x21, 0
	.dw 0x3640, 0xc83c,	0x367f, 0xc83c,		0x21, 0
	.dw 0x36c0, 0xc83c,	0x36ff, 0xc83c,		0x21, 0
	.dw 0x3740, 0xc83c,	0x377f, 0xc83c,		0x21, 0
	.dw 0x37c0, 0xc83c,	0x37ff, 0xc83c,		0x21, 0
	.dw 0x3840, 0xc83c,	0x387f, 0xc83c,		0x21, 0
	.dw 0x38c0, 0xc83c,	0x38ff, 0xc83c,		0x21, 0
	.dw 0x3940, 0xc83c,	0x397f, 0xc83c,		0x21, 0
	.dw 0x39c0, 0xc83c,	0x3fff, 0xc83c,		0x21, 0
	.dw 0x4040, 0xc83c,	0x407f, 0xc83c,		0x21, 0
	.dw 0x40c0, 0xc83c,	0x40ff, 0xc83c,		0x21, 0
	.dw 0x4140, 0xc83c,	0x417f, 0xc83c,		0x21, 0
	.dw 0x41c0, 0xc83c,	0x41ff, 0xc83c,		0x21, 0
	.dw 0x4240, 0xc83c,	0x427f, 0xc83c,		0x21, 0
	.dw 0x42c0, 0xc83c,	0x42ff, 0xc83c,		0x21, 0
	.dw 0x4340, 0xc83c,	0x437f, 0xc83c,		0x21, 0
	.dw 0x43c0, 0xc83c,	0x43ff, 0xc83c,		0x21, 0
	.dw 0x4440, 0xc83c,	0x447f, 0xc83c,		0x21, 0
	.dw 0x44c0, 0xc83c,	0x44ff, 0xc83c,		0x21, 0
	.dw 0x4540, 0xc83c,	0x457f, 0xc83c,		0x21, 0
	.dw 0x45c0, 0xc83c,	0x45ff, 0xc83c,		0x21, 0
	.dw 0x4640, 0xc83c,	0x467f, 0xc83c,		0x21, 0
	.dw 0x46c0, 0xc83c,	0x46ff, 0xc83c,		0x21, 0
	.dw 0x4740, 0xc83c,	0x477f, 0xc83c,		0x21, 0
	.dw 0x47c0, 0xc83c,	0x47ff, 0xc83c,		0x21, 0
	.dw 0x4840, 0xc83c,	0x487f, 0xc83c,		0x21, 0
	.dw 0x48c0, 0xc83c,	0x48ff, 0xc83c,		0x21, 0
	.dw 0x4940, 0xc83c,	0x497f, 0xc83c,		0x21, 0
	.dw 0x49c0, 0xc83c,	0x49ff, 0xc83c,		0x21, 0
	.dw 0x4a40, 0xc83c,	0x4a7f, 0xc83c,		0x21, 0
	.dw 0x4ac0, 0xc83c,	0x4aff, 0xc83c,		0x21, 0
	.dw 0x4b40, 0xc83c,	0x4b7f, 0xc83c,		0x21, 0
	.dw 0x4bc0, 0xc83c,	0x4bff, 0xc83c,		0x21, 0
	.dw 0x4c40, 0xc83c,	0x4c7f, 0xc83c,		0x21, 0
	.dw 0x4cc0, 0xc83c,	0x4cff, 0xc83c,		0x21, 0
	.dw 0x4d40, 0xc83c,	0x4d7f, 0xc83c,		0x21, 0
	.dw 0x4dc0, 0xc83c,	0x4dff, 0xc83c,		0x21, 0
	.dw 0x4e40, 0xc83c,	0x4e7f, 0xc83c,		0x21, 0
	.dw 0x4ec0, 0xc83c,	0x4eff, 0xc83c,		0x21, 0
	.dw 0x4f40, 0xc83c,	0x4f7f, 0xc83c,		0x21, 0
	.dw 0x4fc0, 0xc83c,	0x4fff, 0xc83c,		0x21, 0
	.dw 0x5040, 0xc83c,	0x507f, 0xc83c,		0x21, 0
	.dw 0x50c0, 0xc83c,	0x50ff, 0xc83c,		0x21, 0
	.dw 0x5140, 0xc83c,	0x517f, 0xc83c,		0x21, 0
	.dw 0x51c0, 0xc83c,	0x51ff, 0xc83c,		0x21, 0
	.dw 0x5240, 0xc83c,	0x527f, 0xc83c,		0x21, 0
	.dw 0x52c0, 0xc83c,	0x52ff, 0xc83c,		0x21, 0
	.dw 0x5340, 0xc83c,	0x537f, 0xc83c,		0x21, 0
	.dw 0x53c0, 0xc83c,	0x53ff, 0xc83c,		0x21, 0
	.dw 0x5440, 0xc83c,	0x547f, 0xc83c,		0x21, 0
	.dw 0x54c0, 0xc83c,	0x54ff, 0xc83c,		0x21, 0
	.dw 0x5540, 0xc83c,	0x557f, 0xc83c,		0x21, 0
	.dw 0x55c0, 0xc83c,	0x55ff, 0xc83c,		0x21, 0
	.dw 0x5640, 0xc83c,	0x567f, 0xc83c,		0x21, 0
	.dw 0x56c0, 0xc83c,	0x56ff, 0xc83c,		0x21, 0
	.dw 0x5740, 0xc83c,	0x577f, 0xc83c,		0x21, 0
	.dw 0x57c0, 0xc83c,	0x57ff, 0xc83c,		0x21, 0
	.dw 0x5840, 0xc83c,	0x587f, 0xc83c,		0x21, 0
	.dw 0x58c0, 0xc83c,	0x58ff, 0xc83c,		0x21, 0
	.dw 0x5940, 0xc83c,	0x597f, 0xc83c,		0x21, 0
	.dw 0x59c0, 0xc83c,	0x5fff, 0xc83c,		0x21, 0
	.dw 0x6040, 0xc83c,	0x607f, 0xc83c,		0x21, 0
	.dw 0x60c0, 0xc83c,	0x60ff, 0xc83c,		0x21, 0
	.dw 0x6140, 0xc83c,	0x617f, 0xc83c,		0x21, 0
	.dw 0x61c0, 0xc83c,	0x61ff, 0xc83c,		0x21, 0
	.dw 0x6240, 0xc83c,	0x627f, 0xc83c,		0x21, 0
	.dw 0x62c0, 0xc83c,	0x62ff, 0xc83c,		0x21, 0
	.dw 0x6340, 0xc83c,	0x637f, 0xc83c,		0x21, 0
	.dw 0x63c0, 0xc83c,	0x63ff, 0xc83c,		0x21, 0
	.dw 0x6440, 0xc83c,	0x647f, 0xc83c,		0x21, 0
	.dw 0x64c0, 0xc83c,	0x64ff, 0xc83c,		0x21, 0
	.dw 0x6540, 0xc83c,	0x657f, 0xc83c,		0x21, 0
	.dw 0x65c0, 0xc83c,	0x65ff, 0xc83c,		0x21, 0
	.dw 0x6640, 0xc83c,	0x667f, 0xc83c,		0x21, 0
	.dw 0x66c0, 0xc83c,	0x66ff, 0xc83c,		0x21, 0
	.dw 0x6740, 0xc83c,	0x677f, 0xc83c,		0x21, 0
	.dw 0x67c0, 0xc83c,	0x67ff, 0xc83c,		0x21, 0
	.dw 0x6840, 0xc83c,	0x687f, 0xc83c,		0x21, 0
	.dw 0x68c0, 0xc83c,	0x68ff, 0xc83c,		0x21, 0
	.dw 0x6940, 0xc83c,	0x697f, 0xc83c,		0x21, 0
	.dw 0x69c0, 0xc83c,	0x69ff, 0xc83c,		0x21, 0
	.dw 0x6a40, 0xc83c,	0x6a7f, 0xc83c,		0x21, 0
	.dw 0x6ac0, 0xc83c,	0x6aff, 0xc83c,		0x21, 0
	.dw 0x6b40, 0xc83c,	0x6b7f, 0xc83c,		0x21, 0
	.dw 0x6bc0, 0xc83c,	0x6bff, 0xc83c,		0x21, 0
	.dw 0x6c40, 0xc83c,	0x6c7f, 0xc83c,		0x21, 0
	.dw 0x6cc0, 0xc83c,	0x6cff, 0xc83c,		0x21, 0
	.dw 0x6d40, 0xc83c,	0x6d7f, 0xc83c,		0x21, 0
	.dw 0x6dc0, 0xc83c,	0x6dff, 0xc83c,		0x21, 0
	.dw 0x6e40, 0xc83c,	0x6e7f, 0xc83c,		0x21, 0
	.dw 0x6ec0, 0xc83c,	0x6eff, 0xc83c,		0x21, 0
	.dw 0x6f40, 0xc83c,	0x6f7f, 0xc83c,		0x21, 0
	.dw 0x6fc0, 0xc83c,	0x6fff, 0xc83c,		0x21, 0
	.dw 0x7040, 0xc83c,	0x707f, 0xc83c,		0x21, 0
	.dw 0x70c0, 0xc83c,	0x70ff, 0xc83c,		0x21, 0
	.dw 0x7140, 0xc83c,	0x717f, 0xc83c,		0x21, 0
	.dw 0x71c0, 0xc83c,	0x71ff, 0xc83c,		0x21, 0
	.dw 0x7240, 0xc83c,	0x727f, 0xc83c,		0x21, 0
	.dw 0x72c0, 0xc83c,	0x72ff, 0xc83c,		0x21, 0
	.dw 0x7340, 0xc83c,	0x737f, 0xc83c,		0x21, 0
	.dw 0x73c0, 0xc83c,	0x73ff, 0xc83c,		0x21, 0
	.dw 0x7440, 0xc83c,	0x747f, 0xc83c,		0x21, 0
	.dw 0x74c0, 0xc83c,	0x74ff, 0xc83c,		0x21, 0
	.dw 0x7540, 0xc83c,	0x757f, 0xc83c,		0x21, 0
	.dw 0x75c0, 0xc83c,	0x75ff, 0xc83c,		0x21, 0
	.dw 0x7640, 0xc83c,	0x767f, 0xc83c,		0x21, 0
	.dw 0x76c0, 0xc83c,	0x76ff, 0xc83c,		0x21, 0
	.dw 0x7740, 0xc83c,	0x777f, 0xc83c,		0x21, 0
	.dw 0x77c0, 0xc83c,	0x77ff, 0xc83c,		0x21, 0
	.dw 0x7840, 0xc83c,	0x787f, 0xc83c,		0x21, 0
	.dw 0x78c0, 0xc83c,	0x78ff, 0xc83c,		0x21, 0
	.dw 0x7940, 0xc83c,	0x797f, 0xc83c,		0x21, 0
	.dw 0x79c0, 0xc83c,	0x7fff, 0xc83c,		0x21, 0
	.dw 0x8040, 0xc83c,	0x807f, 0xc83c,		0x21, 0
	.dw 0x80c0, 0xc83c,	0x80ff, 0xc83c,		0x21, 0
	.dw 0x8140, 0xc83c,	0x817f, 0xc83c,		0x21, 0
	.dw 0x81c0, 0xc83c,	0x81ff, 0xc83c,		0x21, 0
	.dw 0x8240, 0xc83c,	0x827f, 0xc83c,		0x21, 0
	.dw 0x82c0, 0xc83c,	0x82ff, 0xc83c,		0x21, 0
	.dw 0x8340, 0xc83c,	0x837f, 0xc83c,		0x21, 0
	.dw 0x83c0, 0xc83c,	0x83ff, 0xc83c,		0x21, 0
	.dw 0x8440, 0xc83c,	0x847f, 0xc83c,		0x21, 0
	.dw 0x84c0, 0xc83c,	0x84ff, 0xc83c,		0x21, 0
	.dw 0x8540, 0xc83c,	0x857f, 0xc83c,		0x21, 0
	.dw 0x85c0, 0xc83c,	0x85ff, 0xc83c,		0x21, 0
	.dw 0x8640, 0xc83c,	0x867f, 0xc83c,		0x21, 0
	.dw 0x86c0, 0xc83c,	0x86ff, 0xc83c,		0x21, 0
	.dw 0x8740, 0xc83c,	0x877f, 0xc83c,		0x21, 0
	.dw 0x87c0, 0xc83c,	0x87ff, 0xc83c,		0x21, 0
	.dw 0x8840, 0xc83c,	0x887f, 0xc83c,		0x21, 0
	.dw 0x88c0, 0xc83c,	0x88ff, 0xc83c,		0x21, 0
	.dw 0x8940, 0xc83c,	0x897f, 0xc83c,		0x21, 0
	.dw 0x89c0, 0xc83c,	0x89ff, 0xc83c,		0x21, 0
	.dw 0x8a40, 0xc83c,	0x8a7f, 0xc83c,		0x21, 0
	.dw 0x8ac0, 0xc83c,	0x8aff, 0xc83c,		0x21, 0
	.dw 0x8b40, 0xc83c,	0x8b7f, 0xc83c,		0x21, 0
	.dw 0x8bc0, 0xc83c,	0x8bff, 0xc83c,		0x21, 0
	.dw 0x8c40, 0xc83c,	0x8c7f, 0xc83c,		0x21, 0
	.dw 0x8cc0, 0xc83c,	0x8cff, 0xc83c,		0x21, 0
	.dw 0x8d40, 0xc83c,	0x8d7f, 0xc83c,		0x21, 0
	.dw 0x8dc0, 0xc83c,	0x8dff, 0xc83c,		0x21, 0
	.dw 0x8e40, 0xc83c,	0x8e7f, 0xc83c,		0x21, 0
	.dw 0x8ec0, 0xc83c,	0x8eff, 0xc83c,		0x21, 0
	.dw 0x8f40, 0xc83c,	0x8f7f, 0xc83c,		0x21, 0
	.dw 0x8fc0, 0xc83c,	0x8fff, 0xc83c,		0x21, 0
	.dw 0x9040, 0xc83c,	0x907f, 0xc83c,		0x21, 0
	.dw 0x90c0, 0xc83c,	0x90ff, 0xc83c,		0x21, 0
	.dw 0x9140, 0xc83c,	0x917f, 0xc83c,		0x21, 0
	.dw 0x91c0, 0xc83c,	0x91ff, 0xc83c,		0x21, 0
	.dw 0x9240, 0xc83c,	0x927f, 0xc83c,		0x21, 0
	.dw 0x92c0, 0xc83c,	0x92ff, 0xc83c,		0x21, 0
	.dw 0x9340, 0xc83c,	0x937f, 0xc83c,		0x21, 0
	.dw 0x93c0, 0xc83c,	0x93ff, 0xc83c,		0x21, 0
	.dw 0x9440, 0xc83c,	0x947f, 0xc83c,		0x21, 0
	.dw 0x94c0, 0xc83c,	0x94ff, 0xc83c,		0x21, 0
	.dw 0x9540, 0xc83c,	0x957f, 0xc83c,		0x21, 0
	.dw 0x95c0, 0xc83c,	0x95ff, 0xc83c,		0x21, 0
	.dw 0x9640, 0xc83c,	0x967f, 0xc83c,		0x21, 0
	.dw 0x96c0, 0xc83c,	0x96ff, 0xc83c,		0x21, 0
	.dw 0x9740, 0xc83c,	0x977f, 0xc83c,		0x21, 0
	.dw 0x97c0, 0xc83c,	0x97ff, 0xc83c,		0x21, 0
	.dw 0x9840, 0xc83c,	0x987f, 0xc83c,		0x21, 0
	.dw 0x98c0, 0xc83c,	0x98ff, 0xc83c,		0x21, 0
	.dw 0x9940, 0xc83c,	0x997f, 0xc83c,		0x21, 0
	.dw 0x99c0, 0xc83c,	0x9fff, 0xc83c,		0x21, 0
	.dw 0xa040, 0xc83c,	0xa07f, 0xc83c,		0x21, 0
	.dw 0xa0c0, 0xc83c,	0xa0ff, 0xc83c,		0x21, 0
	.dw 0xa140, 0xc83c,	0xa17f, 0xc83c,		0x21, 0
	.dw 0xa1c0, 0xc83c,	0xa1ff, 0xc83c,		0x21, 0
	.dw 0xa240, 0xc83c,	0xa27f, 0xc83c,		0x21, 0
	.dw 0xa2c0, 0xc83c,	0xa2ff, 0xc83c,		0x21, 0
	.dw 0xa340, 0xc83c,	0xa37f, 0xc83c,		0x21, 0
	.dw 0xa3c0, 0xc83c,	0xa3ff, 0xc83c,		0x21, 0
	.dw 0xa440, 0xc83c,	0xa47f, 0xc83c,		0x21, 0
	.dw 0xa4c0, 0xc83c,	0xa4ff, 0xc83c,		0x21, 0
	.dw 0xa540, 0xc83c,	0xa57f, 0xc83c,		0x21, 0
	.dw 0xa5c0, 0xc83c,	0xa5ff, 0xc83c,		0x21, 0
	.dw 0xa640, 0xc83c,	0xa67f, 0xc83c,		0x21, 0
	.dw 0xa6c0, 0xc83c,	0xa6ff, 0xc83c,		0x21, 0
	.dw 0xa740, 0xc83c,	0xa77f, 0xc83c,		0x21, 0
	.dw 0xa7c0, 0xc83c,	0xa7ff, 0xc83c,		0x21, 0
	.dw 0xa840, 0xc83c,	0xa87f, 0xc83c,		0x21, 0
	.dw 0xa8c0, 0xc83c,	0xa8ff, 0xc83c,		0x21, 0
	.dw 0xa940, 0xc83c,	0xa97f, 0xc83c,		0x21, 0
	.dw 0xa9c0, 0xc83c,	0xa9ff, 0xc83c,		0x21, 0
	.dw 0xaa40, 0xc83c,	0xaa7f, 0xc83c,		0x21, 0
	.dw 0xaac0, 0xc83c,	0xaaff, 0xc83c,		0x21, 0
	.dw 0xab40, 0xc83c,	0xab7f, 0xc83c,		0x21, 0
	.dw 0xabc0, 0xc83c,	0xabff, 0xc83c,		0x21, 0
	.dw 0xac40, 0xc83c,	0xac7f, 0xc83c,		0x21, 0
	.dw 0xacc0, 0xc83c,	0xacff, 0xc83c,		0x21, 0
	.dw 0xad40, 0xc83c,	0xad7f, 0xc83c,		0x21, 0
	.dw 0xadc0, 0xc83c,	0xadff, 0xc83c,		0x21, 0
	.dw 0xae40, 0xc83c,	0xae7f, 0xc83c,		0x21, 0
	.dw 0xaec0, 0xc83c,	0xaeff, 0xc83c,		0x21, 0
	.dw 0xaf40, 0xc83c,	0xaf7f, 0xc83c,		0x21, 0
	.dw 0xafc0, 0xc83c,	0xafff, 0xc83c,		0x21, 0
	.dw 0xb040, 0xc83c,	0xb07f, 0xc83c,		0x21, 0
	.dw 0xb0c0, 0xc83c,	0xb0ff, 0xc83c,		0x21, 0
	.dw 0xb140, 0xc83c,	0xb17f, 0xc83c,		0x21, 0
	.dw 0xb1c0, 0xc83c,	0xb1ff, 0xc83c,		0x21, 0
	.dw 0xb240, 0xc83c,	0xb27f, 0xc83c,		0x21, 0
	.dw 0xb2c0, 0xc83c,	0xb2ff, 0xc83c,		0x21, 0
	.dw 0xb340, 0xc83c,	0xb37f, 0xc83c,		0x21, 0
	.dw 0xb3c0, 0xc83c,	0xb3ff, 0xc83c,		0x21, 0
	.dw 0xb440, 0xc83c,	0xb47f, 0xc83c,		0x21, 0
	.dw 0xb4c0, 0xc83c,	0xb4ff, 0xc83c,		0x21, 0
	.dw 0xb540, 0xc83c,	0xb57f, 0xc83c,		0x21, 0
	.dw 0xb5c0, 0xc83c,	0xb5ff, 0xc83c,		0x21, 0
	.dw 0xb640, 0xc83c,	0xb67f, 0xc83c,		0x21, 0
	.dw 0xb6c0, 0xc83c,	0xb6ff, 0xc83c,		0x21, 0
	.dw 0xb740, 0xc83c,	0xb77f, 0xc83c,		0x21, 0
	.dw 0xb7c0, 0xc83c,	0xb7ff, 0xc83c,		0x21, 0
	.dw 0xb840, 0xc83c,	0xb87f, 0xc83c,		0x21, 0
	.dw 0xb8c0, 0xc83c,	0xb8ff, 0xc83c,		0x21, 0
	.dw 0xb940, 0xc83c,	0xb97f, 0xc83c,		0x21, 0
	.dw 0xb9c0, 0xc83c,	0xbfff, 0xc83c,		0x21, 0
	.dw 0xc040, 0xc83c,	0xc07f, 0xc83c,		0x21, 0
	.dw 0xc0c0, 0xc83c,	0xc0ff, 0xc83c,		0x21, 0
	.dw 0xc140, 0xc83c,	0xc17f, 0xc83c,		0x21, 0
	.dw 0xc1c0, 0xc83c,	0xc1ff, 0xc83c,		0x21, 0
	.dw 0xc240, 0xc83c,	0xc27f, 0xc83c,		0x21, 0
	.dw 0xc2c0, 0xc83c,	0xc2ff, 0xc83c,		0x21, 0
	.dw 0xc340, 0xc83c,	0xc37f, 0xc83c,		0x21, 0
	.dw 0xc3c0, 0xc83c,	0xc3ff, 0xc83c,		0x21, 0
	.dw 0xc440, 0xc83c,	0xc47f, 0xc83c,		0x21, 0
	.dw 0xc4c0, 0xc83c,	0xc4ff, 0xc83c,		0x21, 0
	.dw 0xc540, 0xc83c,	0xc57f, 0xc83c,		0x21, 0
	.dw 0xc5c0, 0xc83c,	0xc5ff, 0xc83c,		0x21, 0
	.dw 0xc640, 0xc83c,	0xc67f, 0xc83c,		0x21, 0
	.dw 0xc6c0, 0xc83c,	0xc6ff, 0xc83c,		0x21, 0
	.dw 0xc740, 0xc83c,	0xc77f, 0xc83c,		0x21, 0
	.dw 0xc7c0, 0xc83c,	0xc7ff, 0xc83c,		0x21, 0
	.dw 0xc840, 0xc83c,	0xc87f, 0xc83c,		0x21, 0
	.dw 0xc8c0, 0xc83c,	0xc8ff, 0xc83c,		0x21, 0
	.dw 0xc940, 0xc83c,	0xc97f, 0xc83c,		0x21, 0
	.dw 0xc9c0, 0xc83c,	0xc9ff, 0xc83c,		0x21, 0
	.dw 0xca40, 0xc83c,	0xca7f, 0xc83c,		0x21, 0
	.dw 0xcac0, 0xc83c,	0xcaff, 0xc83c,		0x21, 0
	.dw 0xcb40, 0xc83c,	0xcb7f, 0xc83c,		0x21, 0
	.dw 0xcbc0, 0xc83c,	0xcbff, 0xc83c,		0x21, 0
	.dw 0xcc40, 0xc83c,	0xcc7f, 0xc83c,		0x21, 0
	.dw 0xccc0, 0xc83c,	0xccff, 0xc83c,		0x21, 0
	.dw 0xcd40, 0xc83c,	0xcd7f, 0xc83c,		0x21, 0
	.dw 0xcdc0, 0xc83c,	0xcdff, 0xc83c,		0x21, 0
	.dw 0xce40, 0xc83c,	0xce7f, 0xc83c,		0x21, 0
	.dw 0xcec0, 0xc83c,	0xceff, 0xc83c,		0x21, 0
	.dw 0xcf40, 0xc83c,	0xcf7f, 0xc83c,		0x21, 0
	.dw 0xcfc0, 0xc83c,	0xcfff, 0xc83c,		0x21, 0
	.dw 0xd040, 0xc83c,	0xd07f, 0xc83c,		0x21, 0
	.dw 0xd0c0, 0xc83c,	0xd0ff, 0xc83c,		0x21, 0
	.dw 0xd140, 0xc83c,	0xd17f, 0xc83c,		0x21, 0
	.dw 0xd1c0, 0xc83c,	0xd1ff, 0xc83c,		0x21, 0
	.dw 0xd240, 0xc83c,	0xd27f, 0xc83c,		0x21, 0
	.dw 0xd2c0, 0xc83c,	0xd2ff, 0xc83c,		0x21, 0
	.dw 0xd340, 0xc83c,	0xd37f, 0xc83c,		0x21, 0
	.dw 0xd3c0, 0xc83c,	0xd3ff, 0xc83c,		0x21, 0
	.dw 0xd440, 0xc83c,	0xd47f, 0xc83c,		0x21, 0
	.dw 0xd4c0, 0xc83c,	0xd4ff, 0xc83c,		0x21, 0
	.dw 0xd540, 0xc83c,	0xd57f, 0xc83c,		0x21, 0
	.dw 0xd5c0, 0xc83c,	0xd5ff, 0xc83c,		0x21, 0
	.dw 0xd640, 0xc83c,	0xd67f, 0xc83c,		0x21, 0
	.dw 0xd6c0, 0xc83c,	0xd6ff, 0xc83c,		0x21, 0
	.dw 0xd740, 0xc83c,	0xd77f, 0xc83c,		0x21, 0
	.dw 0xd7c0, 0xc83c,	0xd7ff, 0xc83c,		0x21, 0
	.dw 0xd840, 0xc83c,	0xd87f, 0xc83c,		0x21, 0
	.dw 0xd8c0, 0xc83c,	0xd8ff, 0xc83c,		0x21, 0
	.dw 0xd940, 0xc83c,	0xd97f, 0xc83c,		0x21, 0
	.dw 0xd9c0, 0xc83c,	0xdfff, 0xc83c,		0x21, 0
	.dw 0xe040, 0xc83c,	0xe07f, 0xc83c,		0x21, 0
	.dw 0xe0c0, 0xc83c,	0xe0ff, 0xc83c,		0x21, 0
	.dw 0xe140, 0xc83c,	0xe17f, 0xc83c,		0x21, 0
	.dw 0xe1c0, 0xc83c,	0xe1ff, 0xc83c,		0x21, 0
	.dw 0xe240, 0xc83c,	0xe27f, 0xc83c,		0x21, 0
	.dw 0xe2c0, 0xc83c,	0xe2ff, 0xc83c,		0x21, 0
	.dw 0xe340, 0xc83c,	0xe37f, 0xc83c,		0x21, 0
	.dw 0xe3c0, 0xc83c,	0xe3ff, 0xc83c,		0x21, 0
	.dw 0xe440, 0xc83c,	0xe47f, 0xc83c,		0x21, 0
	.dw 0xe4c0, 0xc83c,	0xe4ff, 0xc83c,		0x21, 0
	.dw 0xe540, 0xc83c,	0xe57f, 0xc83c,		0x21, 0
	.dw 0xe5c0, 0xc83c,	0xe5ff, 0xc83c,		0x21, 0
	.dw 0xe640, 0xc83c,	0xe67f, 0xc83c,		0x21, 0
	.dw 0xe6c0, 0xc83c,	0xe6ff, 0xc83c,		0x21, 0
	.dw 0xe740, 0xc83c,	0xe77f, 0xc83c,		0x21, 0
	.dw 0xe7c0, 0xc83c,	0xe7ff, 0xc83c,		0x21, 0
	.dw 0xe840, 0xc83c,	0xe87f, 0xc83c,		0x21, 0
	.dw 0xe8c0, 0xc83c,	0xe8ff, 0xc83c,		0x21, 0
	.dw 0xe940, 0xc83c,	0xe97f, 0xc83c,		0x21, 0
	.dw 0xe9c0, 0xc83c,	0xe9ff, 0xc83c,		0x21, 0
	.dw 0xea40, 0xc83c,	0xea7f, 0xc83c,		0x21, 0
	.dw 0xeac0, 0xc83c,	0xeaff, 0xc83c,		0x21, 0
	.dw 0xeb40, 0xc83c,	0xeb7f, 0xc83c,		0x21, 0
	.dw 0xebc0, 0xc83c,	0xebff, 0xc83c,		0x21, 0
	.dw 0xec40, 0xc83c,	0xec7f, 0xc83c,		0x21, 0
	.dw 0xecc0, 0xc83c,	0xecff, 0xc83c,		0x21, 0
	.dw 0xed40, 0xc83c,	0xed7f, 0xc83c,		0x21, 0
	.dw 0xedc0, 0xc83c,	0xedff, 0xc83c,		0x21, 0
	.dw 0xee40, 0xc83c,	0xee7f, 0xc83c,		0x21, 0
	.dw 0xeec0, 0xc83c,	0xeeff, 0xc83c,		0x21, 0
	.dw 0xef40, 0xc83c,	0xef7f, 0xc83c,		0x21, 0
	.dw 0xefc0, 0xc83c,	0xefff, 0xc83c,		0x21, 0
	.dw 0xf040, 0xc83c,	0xf07f, 0xc83c,		0x21, 0
	.dw 0xf0c0, 0xc83c,	0xf0ff, 0xc83c,		0x21, 0
	.dw 0xf140, 0xc83c,	0xf17f, 0xc83c,		0x21, 0
	.dw 0xf1c0, 0xc83c,	0xf1ff, 0xc83c,		0x21, 0
	.dw 0xf240, 0xc83c,	0xf27f, 0xc83c,		0x21, 0
	.dw 0xf2c0, 0xc83c,	0xf2ff, 0xc83c,		0x21, 0
	.dw 0xf340, 0xc83c,	0xf37f, 0xc83c,		0x21, 0
	.dw 0xf3c0, 0xc83c,	0xf3ff, 0xc83c,		0x21, 0
	.dw 0xf440, 0xc83c,	0xf47f, 0xc83c,		0x21, 0
	.dw 0xf4c0, 0xc83c,	0xf4ff, 0xc83c,		0x21, 0
	.dw 0xf540, 0xc83c,	0xf57f, 0xc83c,		0x21, 0
	.dw 0xf5c0, 0xc83c,	0xf5ff, 0xc83c,		0x21, 0
	.dw 0xf640, 0xc83c,	0xf67f, 0xc83c,		0x21, 0
	.dw 0xf6c0, 0xc83c,	0xf6ff, 0xc83c,		0x21, 0
	.dw 0xf740, 0xc83c,	0xf77f, 0xc83c,		0x21, 0
	.dw 0xf7c0, 0xc83c,	0xf7ff, 0xc83c,		0x21, 0
	.dw 0xf840, 0xc83c,	0xf87f, 0xc83c,		0x21, 0
	.dw 0xf8c0, 0xc83c,	0xf8ff, 0xc83c,		0x21, 0
	.dw 0xf940, 0xc83c,	0xf97f, 0xc83c,		0x21, 0
	.dw 0xf9c0, 0xc83c,	0xffff, 0xc83c,		0x21, 0
	.dw 0x0040, 0xc83d,	0x007f, 0xc83d,		0x21, 0
	.dw 0x00c0, 0xc83d,	0x00ff, 0xc83d,		0x21, 0
	.dw 0x0140, 0xc83d,	0x017f, 0xc83d,		0x21, 0
	.dw 0x01c0, 0xc83d,	0x01ff, 0xc83d,		0x21, 0
	.dw 0x0240, 0xc83d,	0x027f, 0xc83d,		0x21, 0
	.dw 0x02c0, 0xc83d,	0x02ff, 0xc83d,		0x21, 0
	.dw 0x0340, 0xc83d,	0x037f, 0xc83d,		0x21, 0
	.dw 0x03c0, 0xc83d,	0x03ff, 0xc83d,		0x21, 0
	.dw 0x0440, 0xc83d,	0x047f, 0xc83d,		0x21, 0
	.dw 0x04c0, 0xc83d,	0x04ff, 0xc83d,		0x21, 0
	.dw 0x0540, 0xc83d,	0x057f, 0xc83d,		0x21, 0
	.dw 0x05c0, 0xc83d,	0x05ff, 0xc83d,		0x21, 0
	.dw 0x0640, 0xc83d,	0x067f, 0xc83d,		0x21, 0
	.dw 0x06c0, 0xc83d,	0x06ff, 0xc83d,		0x21, 0
	.dw 0x0740, 0xc83d,	0x077f, 0xc83d,		0x21, 0
	.dw 0x07c0, 0xc83d,	0x07ff, 0xc83d,		0x21, 0
	.dw 0x0840, 0xc83d,	0x087f, 0xc83d,		0x21, 0
	.dw 0x08c0, 0xc83d,	0x08ff, 0xc83d,		0x21, 0
	.dw 0x0940, 0xc83d,	0x097f, 0xc83d,		0x21, 0
	.dw 0x09c0, 0xc83d,	0x09ff, 0xc83d,		0x21, 0
	.dw 0x0a40, 0xc83d,	0x0a7f, 0xc83d,		0x21, 0
	.dw 0x0ac0, 0xc83d,	0x0aff, 0xc83d,		0x21, 0
	.dw 0x0b40, 0xc83d,	0x0b7f, 0xc83d,		0x21, 0
	.dw 0x0bc0, 0xc83d,	0x0bff, 0xc83d,		0x21, 0
	.dw 0x0c40, 0xc83d,	0x0c7f, 0xc83d,		0x21, 0
	.dw 0x0cc0, 0xc83d,	0x0cff, 0xc83d,		0x21, 0
	.dw 0x0d40, 0xc83d,	0x0d7f, 0xc83d,		0x21, 0
	.dw 0x0dc0, 0xc83d,	0x0dff, 0xc83d,		0x21, 0
	.dw 0x0e40, 0xc83d,	0x0e7f, 0xc83d,		0x21, 0
	.dw 0x0ec0, 0xc83d,	0x0eff, 0xc83d,		0x21, 0
	.dw 0x0f40, 0xc83d,	0x0f7f, 0xc83d,		0x21, 0
	.dw 0x0fc0, 0xc83d,	0x0fff, 0xc83d,		0x21, 0
	.dw 0x1040, 0xc83d,	0x107f, 0xc83d,		0x21, 0
	.dw 0x10c0, 0xc83d,	0x10ff, 0xc83d,		0x21, 0
	.dw 0x1140, 0xc83d,	0x117f, 0xc83d,		0x21, 0
	.dw 0x11c0, 0xc83d,	0x11ff, 0xc83d,		0x21, 0
	.dw 0x1240, 0xc83d,	0x127f, 0xc83d,		0x21, 0
	.dw 0x12c0, 0xc83d,	0x12ff, 0xc83d,		0x21, 0
	.dw 0x1340, 0xc83d,	0x137f, 0xc83d,		0x21, 0
	.dw 0x13c0, 0xc83d,	0x13ff, 0xc83d,		0x21, 0
	.dw 0x1440, 0xc83d,	0x147f, 0xc83d,		0x21, 0
	.dw 0x14c0, 0xc83d,	0x14ff, 0xc83d,		0x21, 0
	.dw 0x1540, 0xc83d,	0x157f, 0xc83d,		0x21, 0
	.dw 0x15c0, 0xc83d,	0x15ff, 0xc83d,		0x21, 0
	.dw 0x1640, 0xc83d,	0x167f, 0xc83d,		0x21, 0
	.dw 0x16c0, 0xc83d,	0x16ff, 0xc83d,		0x21, 0
	.dw 0x1740, 0xc83d,	0x177f, 0xc83d,		0x21, 0
	.dw 0x17c0, 0xc83d,	0x17ff, 0xc83d,		0x21, 0
	.dw 0x1840, 0xc83d,	0x187f, 0xc83d,		0x21, 0
	.dw 0x18c0, 0xc83d,	0x18ff, 0xc83d,		0x21, 0
	.dw 0x1940, 0xc83d,	0x197f, 0xc83d,		0x21, 0
	.dw 0x19c0, 0xc83d,	0x1fff, 0xc83d,		0x21, 0
	.dw 0x2040, 0xc83d,	0x207f, 0xc83d,		0x21, 0
	.dw 0x20c0, 0xc83d,	0x20ff, 0xc83d,		0x21, 0
	.dw 0x2140, 0xc83d,	0x217f, 0xc83d,		0x21, 0
	.dw 0x21c0, 0xc83d,	0x21ff, 0xc83d,		0x21, 0
	.dw 0x2240, 0xc83d,	0x227f, 0xc83d,		0x21, 0
	.dw 0x22c0, 0xc83d,	0x22ff, 0xc83d,		0x21, 0
	.dw 0x2340, 0xc83d,	0x237f, 0xc83d,		0x21, 0
	.dw 0x23c0, 0xc83d,	0x23ff, 0xc83d,		0x21, 0
	.dw 0x2440, 0xc83d,	0x247f, 0xc83d,		0x21, 0
	.dw 0x24c0, 0xc83d,	0x24ff, 0xc83d,		0x21, 0
	.dw 0x2540, 0xc83d,	0x257f, 0xc83d,		0x21, 0
	.dw 0x25c0, 0xc83d,	0x25ff, 0xc83d,		0x21, 0
	.dw 0x2640, 0xc83d,	0x267f, 0xc83d,		0x21, 0
	.dw 0x26c0, 0xc83d,	0x26ff, 0xc83d,		0x21, 0
	.dw 0x2740, 0xc83d,	0x277f, 0xc83d,		0x21, 0
	.dw 0x27c0, 0xc83d,	0x27ff, 0xc83d,		0x21, 0
	.dw 0x2840, 0xc83d,	0x287f, 0xc83d,		0x21, 0
	.dw 0x28c0, 0xc83d,	0x28ff, 0xc83d,		0x21, 0
	.dw 0x2940, 0xc83d,	0x297f, 0xc83d,		0x21, 0
	.dw 0x29c0, 0xc83d,	0x29ff, 0xc83d,		0x21, 0
	.dw 0x2a40, 0xc83d,	0x2a7f, 0xc83d,		0x21, 0
	.dw 0x2ac0, 0xc83d,	0x2aff, 0xc83d,		0x21, 0
	.dw 0x2b40, 0xc83d,	0x2b7f, 0xc83d,		0x21, 0
	.dw 0x2bc0, 0xc83d,	0x2bff, 0xc83d,		0x21, 0
	.dw 0x2c40, 0xc83d,	0x2c7f, 0xc83d,		0x21, 0
	.dw 0x2cc0, 0xc83d,	0x2cff, 0xc83d,		0x21, 0
	.dw 0x2d40, 0xc83d,	0x2d7f, 0xc83d,		0x21, 0
	.dw 0x2dc0, 0xc83d,	0x2dff, 0xc83d,		0x21, 0
	.dw 0x2e40, 0xc83d,	0x2e7f, 0xc83d,		0x21, 0
	.dw 0x2ec0, 0xc83d,	0x2eff, 0xc83d,		0x21, 0
	.dw 0x2f40, 0xc83d,	0x2f7f, 0xc83d,		0x21, 0
	.dw 0x2fc0, 0xc83d,	0x2fff, 0xc83d,		0x21, 0
	.dw 0x3040, 0xc83d,	0x307f, 0xc83d,		0x21, 0
	.dw 0x30c0, 0xc83d,	0x30ff, 0xc83d,		0x21, 0
	.dw 0x3140, 0xc83d,	0x317f, 0xc83d,		0x21, 0
	.dw 0x31c0, 0xc83d,	0x31ff, 0xc83d,		0x21, 0
	.dw 0x3240, 0xc83d,	0x327f, 0xc83d,		0x21, 0
	.dw 0x32c0, 0xc83d,	0x32ff, 0xc83d,		0x21, 0
	.dw 0x3340, 0xc83d,	0x337f, 0xc83d,		0x21, 0
	.dw 0x33c0, 0xc83d,	0x33ff, 0xc83d,		0x21, 0
	.dw 0x3440, 0xc83d,	0x347f, 0xc83d,		0x21, 0
	.dw 0x34c0, 0xc83d,	0x34ff, 0xc83d,		0x21, 0
	.dw 0x3540, 0xc83d,	0x357f, 0xc83d,		0x21, 0
	.dw 0x35c0, 0xc83d,	0x35ff, 0xc83d,		0x21, 0
	.dw 0x3640, 0xc83d,	0x367f, 0xc83d,		0x21, 0
	.dw 0x36c0, 0xc83d,	0x36ff, 0xc83d,		0x21, 0
	.dw 0x3740, 0xc83d,	0x377f, 0xc83d,		0x21, 0
	.dw 0x37c0, 0xc83d,	0x37ff, 0xc83d,		0x21, 0
	.dw 0x3840, 0xc83d,	0x387f, 0xc83d,		0x21, 0
	.dw 0x38c0, 0xc83d,	0x38ff, 0xc83d,		0x21, 0
	.dw 0x3940, 0xc83d,	0x397f, 0xc83d,		0x21, 0
	.dw 0x39c0, 0xc83d,	0x3fff, 0xc83d,		0x21, 0
	.dw 0x4040, 0xc83d,	0x407f, 0xc83d,		0x21, 0
	.dw 0x40c0, 0xc83d,	0x40ff, 0xc83d,		0x21, 0
	.dw 0x4140, 0xc83d,	0x417f, 0xc83d,		0x21, 0
	.dw 0x41c0, 0xc83d,	0x41ff, 0xc83d,		0x21, 0
	.dw 0x4240, 0xc83d,	0x427f, 0xc83d,		0x21, 0
	.dw 0x42c0, 0xc83d,	0x42ff, 0xc83d,		0x21, 0
	.dw 0x4340, 0xc83d,	0x437f, 0xc83d,		0x21, 0
	.dw 0x43c0, 0xc83d,	0x43ff, 0xc83d,		0x21, 0
	.dw 0x4440, 0xc83d,	0x447f, 0xc83d,		0x21, 0
	.dw 0x44c0, 0xc83d,	0x44ff, 0xc83d,		0x21, 0
	.dw 0x4540, 0xc83d,	0x457f, 0xc83d,		0x21, 0
	.dw 0x45c0, 0xc83d,	0x45ff, 0xc83d,		0x21, 0
	.dw 0x4640, 0xc83d,	0x467f, 0xc83d,		0x21, 0
	.dw 0x46c0, 0xc83d,	0x46ff, 0xc83d,		0x21, 0
	.dw 0x4740, 0xc83d,	0x477f, 0xc83d,		0x21, 0
	.dw 0x47c0, 0xc83d,	0x47ff, 0xc83d,		0x21, 0
	.dw 0x4840, 0xc83d,	0x487f, 0xc83d,		0x21, 0
	.dw 0x48c0, 0xc83d,	0x48ff, 0xc83d,		0x21, 0
	.dw 0x4940, 0xc83d,	0x497f, 0xc83d,		0x21, 0
	.dw 0x49c0, 0xc83d,	0x49ff, 0xc83d,		0x21, 0
	.dw 0x4a40, 0xc83d,	0x4a7f, 0xc83d,		0x21, 0
	.dw 0x4ac0, 0xc83d,	0x4aff, 0xc83d,		0x21, 0
	.dw 0x4b40, 0xc83d,	0x4b7f, 0xc83d,		0x21, 0
	.dw 0x4bc0, 0xc83d,	0x4bff, 0xc83d,		0x21, 0
	.dw 0x4c40, 0xc83d,	0x4c7f, 0xc83d,		0x21, 0
	.dw 0x4cc0, 0xc83d,	0x4cff, 0xc83d,		0x21, 0
	.dw 0x4d40, 0xc83d,	0x4d7f, 0xc83d,		0x21, 0
	.dw 0x4dc0, 0xc83d,	0x4dff, 0xc83d,		0x21, 0
	.dw 0x4e40, 0xc83d,	0x4e7f, 0xc83d,		0x21, 0
	.dw 0x4ec0, 0xc83d,	0x4eff, 0xc83d,		0x21, 0
	.dw 0x4f40, 0xc83d,	0x4f7f, 0xc83d,		0x21, 0
	.dw 0x4fc0, 0xc83d,	0x4fff, 0xc83d,		0x21, 0
	.dw 0x5040, 0xc83d,	0x507f, 0xc83d,		0x21, 0
	.dw 0x50c0, 0xc83d,	0x50ff, 0xc83d,		0x21, 0
	.dw 0x5140, 0xc83d,	0x517f, 0xc83d,		0x21, 0
	.dw 0x51c0, 0xc83d,	0x51ff, 0xc83d,		0x21, 0
	.dw 0x5240, 0xc83d,	0x527f, 0xc83d,		0x21, 0
	.dw 0x52c0, 0xc83d,	0x52ff, 0xc83d,		0x21, 0
	.dw 0x5340, 0xc83d,	0x537f, 0xc83d,		0x21, 0
	.dw 0x53c0, 0xc83d,	0x53ff, 0xc83d,		0x21, 0
	.dw 0x5440, 0xc83d,	0x547f, 0xc83d,		0x21, 0
	.dw 0x54c0, 0xc83d,	0x54ff, 0xc83d,		0x21, 0
	.dw 0x5540, 0xc83d,	0x557f, 0xc83d,		0x21, 0
	.dw 0x55c0, 0xc83d,	0x55ff, 0xc83d,		0x21, 0
	.dw 0x5640, 0xc83d,	0x567f, 0xc83d,		0x21, 0
	.dw 0x56c0, 0xc83d,	0x56ff, 0xc83d,		0x21, 0
	.dw 0x5740, 0xc83d,	0x577f, 0xc83d,		0x21, 0
	.dw 0x57c0, 0xc83d,	0x57ff, 0xc83d,		0x21, 0
	.dw 0x5840, 0xc83d,	0x587f, 0xc83d,		0x21, 0
	.dw 0x58c0, 0xc83d,	0x58ff, 0xc83d,		0x21, 0
	.dw 0x5940, 0xc83d,	0x597f, 0xc83d,		0x21, 0
	.dw 0x59c0, 0xc83d,	0x5fff, 0xc83d,		0x21, 0
	.dw 0x6040, 0xc83d,	0x607f, 0xc83d,		0x21, 0
	.dw 0x60c0, 0xc83d,	0x60ff, 0xc83d,		0x21, 0
	.dw 0x6140, 0xc83d,	0x617f, 0xc83d,		0x21, 0
	.dw 0x61c0, 0xc83d,	0x61ff, 0xc83d,		0x21, 0
	.dw 0x6240, 0xc83d,	0x627f, 0xc83d,		0x21, 0
	.dw 0x62c0, 0xc83d,	0x62ff, 0xc83d,		0x21, 0
	.dw 0x6340, 0xc83d,	0x637f, 0xc83d,		0x21, 0
	.dw 0x63c0, 0xc83d,	0x63ff, 0xc83d,		0x21, 0
	.dw 0x6440, 0xc83d,	0x647f, 0xc83d,		0x21, 0
	.dw 0x64c0, 0xc83d,	0x64ff, 0xc83d,		0x21, 0
	.dw 0x6540, 0xc83d,	0x657f, 0xc83d,		0x21, 0
	.dw 0x65c0, 0xc83d,	0x65ff, 0xc83d,		0x21, 0
	.dw 0x6640, 0xc83d,	0x667f, 0xc83d,		0x21, 0
	.dw 0x66c0, 0xc83d,	0x66ff, 0xc83d,		0x21, 0
	.dw 0x6740, 0xc83d,	0x677f, 0xc83d,		0x21, 0
	.dw 0x67c0, 0xc83d,	0x67ff, 0xc83d,		0x21, 0
	.dw 0x6840, 0xc83d,	0x687f, 0xc83d,		0x21, 0
	.dw 0x68c0, 0xc83d,	0x68ff, 0xc83d,		0x21, 0
	.dw 0x6940, 0xc83d,	0x697f, 0xc83d,		0x21, 0
	.dw 0x69c0, 0xc83d,	0x69ff, 0xc83d,		0x21, 0
	.dw 0x6a40, 0xc83d,	0x6a7f, 0xc83d,		0x21, 0
	.dw 0x6ac0, 0xc83d,	0x6aff, 0xc83d,		0x21, 0
	.dw 0x6b40, 0xc83d,	0x6b7f, 0xc83d,		0x21, 0
	.dw 0x6bc0, 0xc83d,	0x6bff, 0xc83d,		0x21, 0
	.dw 0x6c40, 0xc83d,	0x6c7f, 0xc83d,		0x21, 0
	.dw 0x6cc0, 0xc83d,	0x6cff, 0xc83d,		0x21, 0
	.dw 0x6d40, 0xc83d,	0x6d7f, 0xc83d,		0x21, 0
	.dw 0x6dc0, 0xc83d,	0x6dff, 0xc83d,		0x21, 0
	.dw 0x6e40, 0xc83d,	0x6e7f, 0xc83d,		0x21, 0
	.dw 0x6ec0, 0xc83d,	0x6eff, 0xc83d,		0x21, 0
	.dw 0x6f40, 0xc83d,	0x6f7f, 0xc83d,		0x21, 0
	.dw 0x6fc0, 0xc83d,	0x6fff, 0xc83d,		0x21, 0
	.dw 0x7040, 0xc83d,	0x707f, 0xc83d,		0x21, 0
	.dw 0x70c0, 0xc83d,	0x70ff, 0xc83d,		0x21, 0
	.dw 0x7140, 0xc83d,	0x717f, 0xc83d,		0x21, 0
	.dw 0x71c0, 0xc83d,	0x71ff, 0xc83d,		0x21, 0
	.dw 0x7240, 0xc83d,	0x727f, 0xc83d,		0x21, 0
	.dw 0x72c0, 0xc83d,	0x72ff, 0xc83d,		0x21, 0
	.dw 0x7340, 0xc83d,	0x737f, 0xc83d,		0x21, 0
	.dw 0x73c0, 0xc83d,	0x73ff, 0xc83d,		0x21, 0
	.dw 0x7440, 0xc83d,	0x747f, 0xc83d,		0x21, 0
	.dw 0x74c0, 0xc83d,	0x74ff, 0xc83d,		0x21, 0
	.dw 0x7540, 0xc83d,	0x757f, 0xc83d,		0x21, 0
	.dw 0x75c0, 0xc83d,	0x75ff, 0xc83d,		0x21, 0
	.dw 0x7640, 0xc83d,	0x767f, 0xc83d,		0x21, 0
	.dw 0x76c0, 0xc83d,	0x76ff, 0xc83d,		0x21, 0
	.dw 0x7740, 0xc83d,	0x777f, 0xc83d,		0x21, 0
	.dw 0x77c0, 0xc83d,	0x77ff, 0xc83d,		0x21, 0
	.dw 0x7840, 0xc83d,	0x787f, 0xc83d,		0x21, 0
	.dw 0x78c0, 0xc83d,	0x78ff, 0xc83d,		0x21, 0
	.dw 0x7940, 0xc83d,	0x797f, 0xc83d,		0x21, 0
	.dw 0x79c0, 0xc83d,	0x7fff, 0xc83d,		0x21, 0
	.dw 0x8040, 0xc83d,	0x807f, 0xc83d,		0x21, 0
	.dw 0x80c0, 0xc83d,	0x80ff, 0xc83d,		0x21, 0
	.dw 0x8140, 0xc83d,	0x817f, 0xc83d,		0x21, 0
	.dw 0x81c0, 0xc83d,	0x81ff, 0xc83d,		0x21, 0
	.dw 0x8240, 0xc83d,	0x827f, 0xc83d,		0x21, 0
	.dw 0x82c0, 0xc83d,	0x82ff, 0xc83d,		0x21, 0
	.dw 0x8340, 0xc83d,	0x837f, 0xc83d,		0x21, 0
	.dw 0x83c0, 0xc83d,	0x83ff, 0xc83d,		0x21, 0
	.dw 0x8440, 0xc83d,	0x847f, 0xc83d,		0x21, 0
	.dw 0x84c0, 0xc83d,	0x84ff, 0xc83d,		0x21, 0
	.dw 0x8540, 0xc83d,	0x857f, 0xc83d,		0x21, 0
	.dw 0x85c0, 0xc83d,	0x85ff, 0xc83d,		0x21, 0
	.dw 0x8640, 0xc83d,	0x867f, 0xc83d,		0x21, 0
	.dw 0x86c0, 0xc83d,	0x86ff, 0xc83d,		0x21, 0
	.dw 0x8740, 0xc83d,	0x877f, 0xc83d,		0x21, 0
	.dw 0x87c0, 0xc83d,	0x87ff, 0xc83d,		0x21, 0
	.dw 0x8840, 0xc83d,	0x887f, 0xc83d,		0x21, 0
	.dw 0x88c0, 0xc83d,	0x88ff, 0xc83d,		0x21, 0
	.dw 0x8940, 0xc83d,	0x897f, 0xc83d,		0x21, 0
	.dw 0x89c0, 0xc83d,	0x89ff, 0xc83d,		0x21, 0
	.dw 0x8a40, 0xc83d,	0x8a7f, 0xc83d,		0x21, 0
	.dw 0x8ac0, 0xc83d,	0x8aff, 0xc83d,		0x21, 0
	.dw 0x8b40, 0xc83d,	0x8b7f, 0xc83d,		0x21, 0
	.dw 0x8bc0, 0xc83d,	0x8bff, 0xc83d,		0x21, 0
	.dw 0x8c40, 0xc83d,	0x8c7f, 0xc83d,		0x21, 0
	.dw 0x8cc0, 0xc83d,	0x8cff, 0xc83d,		0x21, 0
	.dw 0x8d40, 0xc83d,	0x8d7f, 0xc83d,		0x21, 0
	.dw 0x8dc0, 0xc83d,	0x8dff, 0xc83d,		0x21, 0
	.dw 0x8e40, 0xc83d,	0x8e7f, 0xc83d,		0x21, 0
	.dw 0x8ec0, 0xc83d,	0x8eff, 0xc83d,		0x21, 0
	.dw 0x8f40, 0xc83d,	0x8f7f, 0xc83d,		0x21, 0
	.dw 0x8fc0, 0xc83d,	0x8fff, 0xc83d,		0x21, 0
	.dw 0x9040, 0xc83d,	0x907f, 0xc83d,		0x21, 0
	.dw 0x90c0, 0xc83d,	0x90ff, 0xc83d,		0x21, 0
	.dw 0x9140, 0xc83d,	0x917f, 0xc83d,		0x21, 0
	.dw 0x91c0, 0xc83d,	0x91ff, 0xc83d,		0x21, 0
	.dw 0x9240, 0xc83d,	0x927f, 0xc83d,		0x21, 0
	.dw 0x92c0, 0xc83d,	0x92ff, 0xc83d,		0x21, 0
	.dw 0x9340, 0xc83d,	0x937f, 0xc83d,		0x21, 0
	.dw 0x93c0, 0xc83d,	0x93ff, 0xc83d,		0x21, 0
	.dw 0x9440, 0xc83d,	0x947f, 0xc83d,		0x21, 0
	.dw 0x94c0, 0xc83d,	0x94ff, 0xc83d,		0x21, 0
	.dw 0x9540, 0xc83d,	0x957f, 0xc83d,		0x21, 0
	.dw 0x95c0, 0xc83d,	0x95ff, 0xc83d,		0x21, 0
	.dw 0x9640, 0xc83d,	0x967f, 0xc83d,		0x21, 0
	.dw 0x96c0, 0xc83d,	0x96ff, 0xc83d,		0x21, 0
	.dw 0x9740, 0xc83d,	0x977f, 0xc83d,		0x21, 0
	.dw 0x97c0, 0xc83d,	0x97ff, 0xc83d,		0x21, 0
	.dw 0x9840, 0xc83d,	0x987f, 0xc83d,		0x21, 0
	.dw 0x98c0, 0xc83d,	0x98ff, 0xc83d,		0x21, 0
	.dw 0x9940, 0xc83d,	0x997f, 0xc83d,		0x21, 0
	.dw 0x99c0, 0xc83d,	0x9fff, 0xc83d,		0x21, 0
	.dw 0xa040, 0xc83d,	0xa07f, 0xc83d,		0x21, 0
	.dw 0xa0c0, 0xc83d,	0xa0ff, 0xc83d,		0x21, 0
	.dw 0xa140, 0xc83d,	0xa17f, 0xc83d,		0x21, 0
	.dw 0xa1c0, 0xc83d,	0xa1ff, 0xc83d,		0x21, 0
	.dw 0xa240, 0xc83d,	0xa27f, 0xc83d,		0x21, 0
	.dw 0xa2c0, 0xc83d,	0xa2ff, 0xc83d,		0x21, 0
	.dw 0xa340, 0xc83d,	0xa37f, 0xc83d,		0x21, 0
	.dw 0xa3c0, 0xc83d,	0xa3ff, 0xc83d,		0x21, 0
	.dw 0xa440, 0xc83d,	0xa47f, 0xc83d,		0x21, 0
	.dw 0xa4c0, 0xc83d,	0xa4ff, 0xc83d,		0x21, 0
	.dw 0xa540, 0xc83d,	0xa57f, 0xc83d,		0x21, 0
	.dw 0xa5c0, 0xc83d,	0xa5ff, 0xc83d,		0x21, 0
	.dw 0xa640, 0xc83d,	0xa67f, 0xc83d,		0x21, 0
	.dw 0xa6c0, 0xc83d,	0xa6ff, 0xc83d,		0x21, 0
	.dw 0xa740, 0xc83d,	0xa77f, 0xc83d,		0x21, 0
	.dw 0xa7c0, 0xc83d,	0xa7ff, 0xc83d,		0x21, 0
	.dw 0xa840, 0xc83d,	0xa87f, 0xc83d,		0x21, 0
	.dw 0xa8c0, 0xc83d,	0xa8ff, 0xc83d,		0x21, 0
	.dw 0xa940, 0xc83d,	0xa97f, 0xc83d,		0x21, 0
	.dw 0xa9c0, 0xc83d,	0xa9ff, 0xc83d,		0x21, 0
	.dw 0xaa40, 0xc83d,	0xaa7f, 0xc83d,		0x21, 0
	.dw 0xaac0, 0xc83d,	0xaaff, 0xc83d,		0x21, 0
	.dw 0xab40, 0xc83d,	0xab7f, 0xc83d,		0x21, 0
	.dw 0xabc0, 0xc83d,	0xabff, 0xc83d,		0x21, 0
	.dw 0xac40, 0xc83d,	0xac7f, 0xc83d,		0x21, 0
	.dw 0xacc0, 0xc83d,	0xacff, 0xc83d,		0x21, 0
	.dw 0xad40, 0xc83d,	0xad7f, 0xc83d,		0x21, 0
	.dw 0xadc0, 0xc83d,	0xadff, 0xc83d,		0x21, 0
	.dw 0xae40, 0xc83d,	0xae7f, 0xc83d,		0x21, 0
	.dw 0xaec0, 0xc83d,	0xaeff, 0xc83d,		0x21, 0
	.dw 0xaf40, 0xc83d,	0xaf7f, 0xc83d,		0x21, 0
	.dw 0xafc0, 0xc83d,	0xafff, 0xc83d,		0x21, 0
	.dw 0xb040, 0xc83d,	0xb07f, 0xc83d,		0x21, 0
	.dw 0xb0c0, 0xc83d,	0xb0ff, 0xc83d,		0x21, 0
	.dw 0xb140, 0xc83d,	0xb17f, 0xc83d,		0x21, 0
	.dw 0xb1c0, 0xc83d,	0xb1ff, 0xc83d,		0x21, 0
	.dw 0xb240, 0xc83d,	0xb27f, 0xc83d,		0x21, 0
	.dw 0xb2c0, 0xc83d,	0xb2ff, 0xc83d,		0x21, 0
	.dw 0xb340, 0xc83d,	0xb37f, 0xc83d,		0x21, 0
	.dw 0xb3c0, 0xc83d,	0xb3ff, 0xc83d,		0x21, 0
	.dw 0xb440, 0xc83d,	0xb47f, 0xc83d,		0x21, 0
	.dw 0xb4c0, 0xc83d,	0xb4ff, 0xc83d,		0x21, 0
	.dw 0xb540, 0xc83d,	0xb57f, 0xc83d,		0x21, 0
	.dw 0xb5c0, 0xc83d,	0xb5ff, 0xc83d,		0x21, 0
	.dw 0xb640, 0xc83d,	0xb67f, 0xc83d,		0x21, 0
	.dw 0xb6c0, 0xc83d,	0xb6ff, 0xc83d,		0x21, 0
	.dw 0xb740, 0xc83d,	0xb77f, 0xc83d,		0x21, 0
	.dw 0xb7c0, 0xc83d,	0xb7ff, 0xc83d,		0x21, 0
	.dw 0xb840, 0xc83d,	0xb87f, 0xc83d,		0x21, 0
	.dw 0xb8c0, 0xc83d,	0xb8ff, 0xc83d,		0x21, 0
	.dw 0xb940, 0xc83d,	0xb97f, 0xc83d,		0x21, 0
	.dw 0xb9c0, 0xc83d,	0xbfff, 0xc83d,		0x21, 0
	.dw 0xc040, 0xc83d,	0xc07f, 0xc83d,		0x21, 0
	.dw 0xc0c0, 0xc83d,	0xc0ff, 0xc83d,		0x21, 0
	.dw 0xc140, 0xc83d,	0xc17f, 0xc83d,		0x21, 0
	.dw 0xc1c0, 0xc83d,	0xc1ff, 0xc83d,		0x21, 0
	.dw 0xc240, 0xc83d,	0xc27f, 0xc83d,		0x21, 0
	.dw 0xc2c0, 0xc83d,	0xc2ff, 0xc83d,		0x21, 0
	.dw 0xc340, 0xc83d,	0xc37f, 0xc83d,		0x21, 0
	.dw 0xc3c0, 0xc83d,	0xc3ff, 0xc83d,		0x21, 0
	.dw 0xc440, 0xc83d,	0xc47f, 0xc83d,		0x21, 0
	.dw 0xc4c0, 0xc83d,	0xc4ff, 0xc83d,		0x21, 0
	.dw 0xc540, 0xc83d,	0xc57f, 0xc83d,		0x21, 0
	.dw 0xc5c0, 0xc83d,	0xc5ff, 0xc83d,		0x21, 0
	.dw 0xc640, 0xc83d,	0xc67f, 0xc83d,		0x21, 0
	.dw 0xc6c0, 0xc83d,	0xc6ff, 0xc83d,		0x21, 0
	.dw 0xc740, 0xc83d,	0xc77f, 0xc83d,		0x21, 0
	.dw 0xc7c0, 0xc83d,	0xc7ff, 0xc83d,		0x21, 0
	.dw 0xc840, 0xc83d,	0xc87f, 0xc83d,		0x21, 0
	.dw 0xc8c0, 0xc83d,	0xc8ff, 0xc83d,		0x21, 0
	.dw 0xc940, 0xc83d,	0xc97f, 0xc83d,		0x21, 0
	.dw 0xc9c0, 0xc83d,	0xc9ff, 0xc83d,		0x21, 0
	.dw 0xca40, 0xc83d,	0xca7f, 0xc83d,		0x21, 0
	.dw 0xcac0, 0xc83d,	0xcaff, 0xc83d,		0x21, 0
	.dw 0xcb40, 0xc83d,	0xcb7f, 0xc83d,		0x21, 0
	.dw 0xcbc0, 0xc83d,	0xcbff, 0xc83d,		0x21, 0
	.dw 0xcc40, 0xc83d,	0xcc7f, 0xc83d,		0x21, 0
	.dw 0xccc0, 0xc83d,	0xccff, 0xc83d,		0x21, 0
	.dw 0xcd40, 0xc83d,	0xcd7f, 0xc83d,		0x21, 0
	.dw 0xcdc0, 0xc83d,	0xcdff, 0xc83d,		0x21, 0
	.dw 0xce40, 0xc83d,	0xce7f, 0xc83d,		0x21, 0
	.dw 0xcec0, 0xc83d,	0xceff, 0xc83d,		0x21, 0
	.dw 0xcf40, 0xc83d,	0xcf7f, 0xc83d,		0x21, 0
	.dw 0xcfc0, 0xc83d,	0xcfff, 0xc83d,		0x21, 0
	.dw 0xd040, 0xc83d,	0xd07f, 0xc83d,		0x21, 0
	.dw 0xd0c0, 0xc83d,	0xd0ff, 0xc83d,		0x21, 0
	.dw 0xd140, 0xc83d,	0xd17f, 0xc83d,		0x21, 0
	.dw 0xd1c0, 0xc83d,	0xd1ff, 0xc83d,		0x21, 0
	.dw 0xd240, 0xc83d,	0xd27f, 0xc83d,		0x21, 0
	.dw 0xd2c0, 0xc83d,	0xd2ff, 0xc83d,		0x21, 0
	.dw 0xd340, 0xc83d,	0xd37f, 0xc83d,		0x21, 0
	.dw 0xd3c0, 0xc83d,	0xd3ff, 0xc83d,		0x21, 0
	.dw 0xd440, 0xc83d,	0xd47f, 0xc83d,		0x21, 0
	.dw 0xd4c0, 0xc83d,	0xd4ff, 0xc83d,		0x21, 0
	.dw 0xd540, 0xc83d,	0xd57f, 0xc83d,		0x21, 0
	.dw 0xd5c0, 0xc83d,	0xd5ff, 0xc83d,		0x21, 0
	.dw 0xd640, 0xc83d,	0xd67f, 0xc83d,		0x21, 0
	.dw 0xd6c0, 0xc83d,	0xd6ff, 0xc83d,		0x21, 0
	.dw 0xd740, 0xc83d,	0xd77f, 0xc83d,		0x21, 0
	.dw 0xd7c0, 0xc83d,	0xd7ff, 0xc83d,		0x21, 0
	.dw 0xd840, 0xc83d,	0xd87f, 0xc83d,		0x21, 0
	.dw 0xd8c0, 0xc83d,	0xd8ff, 0xc83d,		0x21, 0
	.dw 0xd940, 0xc83d,	0xd97f, 0xc83d,		0x21, 0
	.dw 0xd9c0, 0xc83d,	0xdfff, 0xc83d,		0x21, 0
	.dw 0xe040, 0xc83d,	0xe07f, 0xc83d,		0x21, 0
	.dw 0xe0c0, 0xc83d,	0xe0ff, 0xc83d,		0x21, 0
	.dw 0xe140, 0xc83d,	0xe17f, 0xc83d,		0x21, 0
	.dw 0xe1c0, 0xc83d,	0xe1ff, 0xc83d,		0x21, 0
	.dw 0xe240, 0xc83d,	0xe27f, 0xc83d,		0x21, 0
	.dw 0xe2c0, 0xc83d,	0xe2ff, 0xc83d,		0x21, 0
	.dw 0xe340, 0xc83d,	0xe37f, 0xc83d,		0x21, 0
	.dw 0xe3c0, 0xc83d,	0xe3ff, 0xc83d,		0x21, 0
	.dw 0xe440, 0xc83d,	0xe47f, 0xc83d,		0x21, 0
	.dw 0xe4c0, 0xc83d,	0xe4ff, 0xc83d,		0x21, 0
	.dw 0xe540, 0xc83d,	0xe57f, 0xc83d,		0x21, 0
	.dw 0xe5c0, 0xc83d,	0xe5ff, 0xc83d,		0x21, 0
	.dw 0xe640, 0xc83d,	0xe67f, 0xc83d,		0x21, 0
	.dw 0xe6c0, 0xc83d,	0xe6ff, 0xc83d,		0x21, 0
	.dw 0xe740, 0xc83d,	0xe77f, 0xc83d,		0x21, 0
	.dw 0xe7c0, 0xc83d,	0xe7ff, 0xc83d,		0x21, 0
	.dw 0xe840, 0xc83d,	0xe87f, 0xc83d,		0x21, 0
	.dw 0xe8c0, 0xc83d,	0xe8ff, 0xc83d,		0x21, 0
	.dw 0xe940, 0xc83d,	0xe97f, 0xc83d,		0x21, 0
	.dw 0xe9c0, 0xc83d,	0xe9ff, 0xc83d,		0x21, 0
	.dw 0xea40, 0xc83d,	0xea7f, 0xc83d,		0x21, 0
	.dw 0xeac0, 0xc83d,	0xeaff, 0xc83d,		0x21, 0
	.dw 0xeb40, 0xc83d,	0xeb7f, 0xc83d,		0x21, 0
	.dw 0xebc0, 0xc83d,	0xebff, 0xc83d,		0x21, 0
	.dw 0xec40, 0xc83d,	0xec7f, 0xc83d,		0x21, 0
	.dw 0xecc0, 0xc83d,	0xecff, 0xc83d,		0x21, 0
	.dw 0xed40, 0xc83d,	0xed7f, 0xc83d,		0x21, 0
	.dw 0xedc0, 0xc83d,	0xedff, 0xc83d,		0x21, 0
	.dw 0xee40, 0xc83d,	0xee7f, 0xc83d,		0x21, 0
	.dw 0xeec0, 0xc83d,	0xeeff, 0xc83d,		0x21, 0
	.dw 0xef40, 0xc83d,	0xef7f, 0xc83d,		0x21, 0
	.dw 0xefc0, 0xc83d,	0xefff, 0xc83d,		0x21, 0
	.dw 0xf040, 0xc83d,	0xf07f, 0xc83d,		0x21, 0
	.dw 0xf0c0, 0xc83d,	0xf0ff, 0xc83d,		0x21, 0
	.dw 0xf140, 0xc83d,	0xf17f, 0xc83d,		0x21, 0
	.dw 0xf1c0, 0xc83d,	0xf1ff, 0xc83d,		0x21, 0
	.dw 0xf240, 0xc83d,	0xf27f, 0xc83d,		0x21, 0
	.dw 0xf2c0, 0xc83d,	0xf2ff, 0xc83d,		0x21, 0
	.dw 0xf340, 0xc83d,	0xf37f, 0xc83d,		0x21, 0
	.dw 0xf3c0, 0xc83d,	0xf3ff, 0xc83d,		0x21, 0
	.dw 0xf440, 0xc83d,	0xf47f, 0xc83d,		0x21, 0
	.dw 0xf4c0, 0xc83d,	0xf4ff, 0xc83d,		0x21, 0
	.dw 0xf540, 0xc83d,	0xf57f, 0xc83d,		0x21, 0
	.dw 0xf5c0, 0xc83d,	0xf5ff, 0xc83d,		0x21, 0
	.dw 0xf640, 0xc83d,	0xf67f, 0xc83d,		0x21, 0
	.dw 0xf6c0, 0xc83d,	0xf6ff, 0xc83d,		0x21, 0
	.dw 0xf740, 0xc83d,	0xf77f, 0xc83d,		0x21, 0
	.dw 0xf7c0, 0xc83d,	0xf7ff, 0xc83d,		0x21, 0
	.dw 0xf840, 0xc83d,	0xf87f, 0xc83d,		0x21, 0
	.dw 0xf8c0, 0xc83d,	0xf8ff, 0xc83d,		0x21, 0
	.dw 0xf940, 0xc83d,	0xf97f, 0xc83d,		0x21, 0
	.dw 0xf9c0, 0xc83d,	0xffff, 0xc83d,		0x21, 0
	.dw 0x0040, 0xc83e,	0x007f, 0xc83e,		0x21, 0
	.dw 0x00c0, 0xc83e,	0x00ff, 0xc83e,		0x21, 0
	.dw 0x0140, 0xc83e,	0x017f, 0xc83e,		0x21, 0
	.dw 0x01c0, 0xc83e,	0x01ff, 0xc83e,		0x21, 0
	.dw 0x0240, 0xc83e,	0x027f, 0xc83e,		0x21, 0
	.dw 0x02c0, 0xc83e,	0x02ff, 0xc83e,		0x21, 0
	.dw 0x0340, 0xc83e,	0x037f, 0xc83e,		0x21, 0
	.dw 0x03c0, 0xc83e,	0x03ff, 0xc83e,		0x21, 0
	.dw 0x0440, 0xc83e,	0x047f, 0xc83e,		0x21, 0
	.dw 0x04c0, 0xc83e,	0x04ff, 0xc83e,		0x21, 0
	.dw 0x0540, 0xc83e,	0x057f, 0xc83e,		0x21, 0
	.dw 0x05c0, 0xc83e,	0x05ff, 0xc83e,		0x21, 0
	.dw 0x0640, 0xc83e,	0x067f, 0xc83e,		0x21, 0
	.dw 0x06c0, 0xc83e,	0x06ff, 0xc83e,		0x21, 0
	.dw 0x0740, 0xc83e,	0x077f, 0xc83e,		0x21, 0
	.dw 0x07c0, 0xc83e,	0x07ff, 0xc83e,		0x21, 0
	.dw 0x0840, 0xc83e,	0x087f, 0xc83e,		0x21, 0
	.dw 0x08c0, 0xc83e,	0x08ff, 0xc83e,		0x21, 0
	.dw 0x0940, 0xc83e,	0x097f, 0xc83e,		0x21, 0
	.dw 0x09c0, 0xc83e,	0x09ff, 0xc83e,		0x21, 0
	.dw 0x0a40, 0xc83e,	0x0a7f, 0xc83e,		0x21, 0
	.dw 0x0ac0, 0xc83e,	0x0aff, 0xc83e,		0x21, 0
	.dw 0x0b40, 0xc83e,	0x0b7f, 0xc83e,		0x21, 0
	.dw 0x0bc0, 0xc83e,	0x0bff, 0xc83e,		0x21, 0
	.dw 0x0c40, 0xc83e,	0x0c7f, 0xc83e,		0x21, 0
	.dw 0x0cc0, 0xc83e,	0x0cff, 0xc83e,		0x21, 0
	.dw 0x0d40, 0xc83e,	0x0d7f, 0xc83e,		0x21, 0
	.dw 0x0dc0, 0xc83e,	0x0dff, 0xc83e,		0x21, 0
	.dw 0x0e40, 0xc83e,	0x0e7f, 0xc83e,		0x21, 0
	.dw 0x0ec0, 0xc83e,	0x0eff, 0xc83e,		0x21, 0
	.dw 0x0f40, 0xc83e,	0x0f7f, 0xc83e,		0x21, 0
	.dw 0x0fc0, 0xc83e,	0x0fff, 0xc83e,		0x21, 0
	.dw 0x1040, 0xc83e,	0x107f, 0xc83e,		0x21, 0
	.dw 0x10c0, 0xc83e,	0x10ff, 0xc83e,		0x21, 0
	.dw 0x1140, 0xc83e,	0x117f, 0xc83e,		0x21, 0
	.dw 0x11c0, 0xc83e,	0x11ff, 0xc83e,		0x21, 0
	.dw 0x1240, 0xc83e,	0x127f, 0xc83e,		0x21, 0
	.dw 0x12c0, 0xc83e,	0x12ff, 0xc83e,		0x21, 0
	.dw 0x1340, 0xc83e,	0x137f, 0xc83e,		0x21, 0
	.dw 0x13c0, 0xc83e,	0x13ff, 0xc83e,		0x21, 0
	.dw 0x1440, 0xc83e,	0x147f, 0xc83e,		0x21, 0
	.dw 0x14c0, 0xc83e,	0x14ff, 0xc83e,		0x21, 0
	.dw 0x1540, 0xc83e,	0x157f, 0xc83e,		0x21, 0
	.dw 0x15c0, 0xc83e,	0x15ff, 0xc83e,		0x21, 0
	.dw 0x1640, 0xc83e,	0x167f, 0xc83e,		0x21, 0
	.dw 0x16c0, 0xc83e,	0x16ff, 0xc83e,		0x21, 0
	.dw 0x1740, 0xc83e,	0x177f, 0xc83e,		0x21, 0
	.dw 0x17c0, 0xc83e,	0x17ff, 0xc83e,		0x21, 0
	.dw 0x1840, 0xc83e,	0x187f, 0xc83e,		0x21, 0
	.dw 0x18c0, 0xc83e,	0x18ff, 0xc83e,		0x21, 0
	.dw 0x1940, 0xc83e,	0x197f, 0xc83e,		0x21, 0
	.dw 0x19c0, 0xc83e,	0x1fff, 0xc83e,		0x21, 0
	.dw 0x2040, 0xc83e,	0x207f, 0xc83e,		0x21, 0
	.dw 0x20c0, 0xc83e,	0x20ff, 0xc83e,		0x21, 0
	.dw 0x2140, 0xc83e,	0x217f, 0xc83e,		0x21, 0
	.dw 0x21c0, 0xc83e,	0x21ff, 0xc83e,		0x21, 0
	.dw 0x2240, 0xc83e,	0x227f, 0xc83e,		0x21, 0
	.dw 0x22c0, 0xc83e,	0x22ff, 0xc83e,		0x21, 0
	.dw 0x2340, 0xc83e,	0x237f, 0xc83e,		0x21, 0
	.dw 0x23c0, 0xc83e,	0x23ff, 0xc83e,		0x21, 0
	.dw 0x2440, 0xc83e,	0x247f, 0xc83e,		0x21, 0
	.dw 0x24c0, 0xc83e,	0x24ff, 0xc83e,		0x21, 0
	.dw 0x2540, 0xc83e,	0x257f, 0xc83e,		0x21, 0
	.dw 0x25c0, 0xc83e,	0x25ff, 0xc83e,		0x21, 0
	.dw 0x2640, 0xc83e,	0x267f, 0xc83e,		0x21, 0
	.dw 0x26c0, 0xc83e,	0x26ff, 0xc83e,		0x21, 0
	.dw 0x2740, 0xc83e,	0x277f, 0xc83e,		0x21, 0
	.dw 0x27c0, 0xc83e,	0x27ff, 0xc83e,		0x21, 0
	.dw 0x2840, 0xc83e,	0x287f, 0xc83e,		0x21, 0
	.dw 0x28c0, 0xc83e,	0x28ff, 0xc83e,		0x21, 0
	.dw 0x2940, 0xc83e,	0x297f, 0xc83e,		0x21, 0
	.dw 0x29c0, 0xc83e,	0x29ff, 0xc83e,		0x21, 0
	.dw 0x2a40, 0xc83e,	0x2a7f, 0xc83e,		0x21, 0
	.dw 0x2ac0, 0xc83e,	0x2aff, 0xc83e,		0x21, 0
	.dw 0x2b40, 0xc83e,	0x2b7f, 0xc83e,		0x21, 0
	.dw 0x2bc0, 0xc83e,	0x2bff, 0xc83e,		0x21, 0
	.dw 0x2c40, 0xc83e,	0x2c7f, 0xc83e,		0x21, 0
	.dw 0x2cc0, 0xc83e,	0x2cff, 0xc83e,		0x21, 0
	.dw 0x2d40, 0xc83e,	0x2d7f, 0xc83e,		0x21, 0
	.dw 0x2dc0, 0xc83e,	0x2dff, 0xc83e,		0x21, 0
	.dw 0x2e40, 0xc83e,	0x2e7f, 0xc83e,		0x21, 0
	.dw 0x2ec0, 0xc83e,	0x2eff, 0xc83e,		0x21, 0
	.dw 0x2f40, 0xc83e,	0x2f7f, 0xc83e,		0x21, 0
	.dw 0x2fc0, 0xc83e,	0x2fff, 0xc83e,		0x21, 0
	.dw 0x3040, 0xc83e,	0x307f, 0xc83e,		0x21, 0
	.dw 0x30c0, 0xc83e,	0x30ff, 0xc83e,		0x21, 0
	.dw 0x3140, 0xc83e,	0x317f, 0xc83e,		0x21, 0
	.dw 0x31c0, 0xc83e,	0x31ff, 0xc83e,		0x21, 0
	.dw 0x3240, 0xc83e,	0x327f, 0xc83e,		0x21, 0
	.dw 0x32c0, 0xc83e,	0x32ff, 0xc83e,		0x21, 0
	.dw 0x3340, 0xc83e,	0x337f, 0xc83e,		0x21, 0
	.dw 0x33c0, 0xc83e,	0x33ff, 0xc83e,		0x21, 0
	.dw 0x3440, 0xc83e,	0x347f, 0xc83e,		0x21, 0
	.dw 0x34c0, 0xc83e,	0x34ff, 0xc83e,		0x21, 0
	.dw 0x3540, 0xc83e,	0x357f, 0xc83e,		0x21, 0
	.dw 0x35c0, 0xc83e,	0x35ff, 0xc83e,		0x21, 0
	.dw 0x3640, 0xc83e,	0x367f, 0xc83e,		0x21, 0
	.dw 0x36c0, 0xc83e,	0x36ff, 0xc83e,		0x21, 0
	.dw 0x3740, 0xc83e,	0x377f, 0xc83e,		0x21, 0
	.dw 0x37c0, 0xc83e,	0x37ff, 0xc83e,		0x21, 0
	.dw 0x3840, 0xc83e,	0x387f, 0xc83e,		0x21, 0
	.dw 0x38c0, 0xc83e,	0x38ff, 0xc83e,		0x21, 0
	.dw 0x3940, 0xc83e,	0x397f, 0xc83e,		0x21, 0
	.dw 0x39c0, 0xc83e,	0x3fff, 0xc83e,		0x21, 0
	.dw 0x4040, 0xc83e,	0x407f, 0xc83e,		0x21, 0
	.dw 0x40c0, 0xc83e,	0x40ff, 0xc83e,		0x21, 0
	.dw 0x4140, 0xc83e,	0x417f, 0xc83e,		0x21, 0
	.dw 0x41c0, 0xc83e,	0x41ff, 0xc83e,		0x21, 0
	.dw 0x4240, 0xc83e,	0x427f, 0xc83e,		0x21, 0
	.dw 0x42c0, 0xc83e,	0x42ff, 0xc83e,		0x21, 0
	.dw 0x4340, 0xc83e,	0x437f, 0xc83e,		0x21, 0
	.dw 0x43c0, 0xc83e,	0x43ff, 0xc83e,		0x21, 0
	.dw 0x4440, 0xc83e,	0x447f, 0xc83e,		0x21, 0
	.dw 0x44c0, 0xc83e,	0x44ff, 0xc83e,		0x21, 0
	.dw 0x4540, 0xc83e,	0x457f, 0xc83e,		0x21, 0
	.dw 0x45c0, 0xc83e,	0x45ff, 0xc83e,		0x21, 0
	.dw 0x4640, 0xc83e,	0x467f, 0xc83e,		0x21, 0
	.dw 0x46c0, 0xc83e,	0x46ff, 0xc83e,		0x21, 0
	.dw 0x4740, 0xc83e,	0x477f, 0xc83e,		0x21, 0
	.dw 0x47c0, 0xc83e,	0x47ff, 0xc83e,		0x21, 0
	.dw 0x4840, 0xc83e,	0x487f, 0xc83e,		0x21, 0
	.dw 0x48c0, 0xc83e,	0x48ff, 0xc83e,		0x21, 0
	.dw 0x4940, 0xc83e,	0x497f, 0xc83e,		0x21, 0
	.dw 0x49c0, 0xc83e,	0x49ff, 0xc83e,		0x21, 0
	.dw 0x4a40, 0xc83e,	0x4a7f, 0xc83e,		0x21, 0
	.dw 0x4ac0, 0xc83e,	0x4aff, 0xc83e,		0x21, 0
	.dw 0x4b40, 0xc83e,	0x4b7f, 0xc83e,		0x21, 0
	.dw 0x4bc0, 0xc83e,	0x4bff, 0xc83e,		0x21, 0
	.dw 0x4c40, 0xc83e,	0x4c7f, 0xc83e,		0x21, 0
	.dw 0x4cc0, 0xc83e,	0x4cff, 0xc83e,		0x21, 0
	.dw 0x4d40, 0xc83e,	0x4d7f, 0xc83e,		0x21, 0
	.dw 0x4dc0, 0xc83e,	0x4dff, 0xc83e,		0x21, 0
	.dw 0x4e40, 0xc83e,	0x4e7f, 0xc83e,		0x21, 0
	.dw 0x4ec0, 0xc83e,	0x4eff, 0xc83e,		0x21, 0
	.dw 0x4f40, 0xc83e,	0x4f7f, 0xc83e,		0x21, 0
	.dw 0x4fc0, 0xc83e,	0x4fff, 0xc83e,		0x21, 0
	.dw 0x5040, 0xc83e,	0x507f, 0xc83e,		0x21, 0
	.dw 0x50c0, 0xc83e,	0x50ff, 0xc83e,		0x21, 0
	.dw 0x5140, 0xc83e,	0x517f, 0xc83e,		0x21, 0
	.dw 0x51c0, 0xc83e,	0x51ff, 0xc83e,		0x21, 0
	.dw 0x5240, 0xc83e,	0x527f, 0xc83e,		0x21, 0
	.dw 0x52c0, 0xc83e,	0x52ff, 0xc83e,		0x21, 0
	.dw 0x5340, 0xc83e,	0x537f, 0xc83e,		0x21, 0
	.dw 0x53c0, 0xc83e,	0x53ff, 0xc83e,		0x21, 0
	.dw 0x5440, 0xc83e,	0x547f, 0xc83e,		0x21, 0
	.dw 0x54c0, 0xc83e,	0x54ff, 0xc83e,		0x21, 0
	.dw 0x5540, 0xc83e,	0x557f, 0xc83e,		0x21, 0
	.dw 0x55c0, 0xc83e,	0x55ff, 0xc83e,		0x21, 0
	.dw 0x5640, 0xc83e,	0x567f, 0xc83e,		0x21, 0
	.dw 0x56c0, 0xc83e,	0x56ff, 0xc83e,		0x21, 0
	.dw 0x5740, 0xc83e,	0x577f, 0xc83e,		0x21, 0
	.dw 0x57c0, 0xc83e,	0x57ff, 0xc83e,		0x21, 0
	.dw 0x5840, 0xc83e,	0x587f, 0xc83e,		0x21, 0
	.dw 0x58c0, 0xc83e,	0x58ff, 0xc83e,		0x21, 0
	.dw 0x5940, 0xc83e,	0x597f, 0xc83e,		0x21, 0
	.dw 0x59c0, 0xc83e,	0x5fff, 0xc83e,		0x21, 0
	.dw 0x6040, 0xc83e,	0x607f, 0xc83e,		0x21, 0
	.dw 0x60c0, 0xc83e,	0x60ff, 0xc83e,		0x21, 0
	.dw 0x6140, 0xc83e,	0x617f, 0xc83e,		0x21, 0
	.dw 0x61c0, 0xc83e,	0x61ff, 0xc83e,		0x21, 0
	.dw 0x6240, 0xc83e,	0x627f, 0xc83e,		0x21, 0
	.dw 0x62c0, 0xc83e,	0x62ff, 0xc83e,		0x21, 0
	.dw 0x6340, 0xc83e,	0x637f, 0xc83e,		0x21, 0
	.dw 0x63c0, 0xc83e,	0x63ff, 0xc83e,		0x21, 0
	.dw 0x6440, 0xc83e,	0x647f, 0xc83e,		0x21, 0
	.dw 0x64c0, 0xc83e,	0x64ff, 0xc83e,		0x21, 0
	.dw 0x6540, 0xc83e,	0x657f, 0xc83e,		0x21, 0
	.dw 0x65c0, 0xc83e,	0x65ff, 0xc83e,		0x21, 0
	.dw 0x6640, 0xc83e,	0x667f, 0xc83e,		0x21, 0
	.dw 0x66c0, 0xc83e,	0x66ff, 0xc83e,		0x21, 0
	.dw 0x6740, 0xc83e,	0x677f, 0xc83e,		0x21, 0
	.dw 0x67c0, 0xc83e,	0x67ff, 0xc83e,		0x21, 0
	.dw 0x6840, 0xc83e,	0x687f, 0xc83e,		0x21, 0
	.dw 0x68c0, 0xc83e,	0x68ff, 0xc83e,		0x21, 0
	.dw 0x6940, 0xc83e,	0x697f, 0xc83e,		0x21, 0
	.dw 0x69c0, 0xc83e,	0x69ff, 0xc83e,		0x21, 0
	.dw 0x6a40, 0xc83e,	0x6a7f, 0xc83e,		0x21, 0
	.dw 0x6ac0, 0xc83e,	0x6aff, 0xc83e,		0x21, 0
	.dw 0x6b40, 0xc83e,	0x6b7f, 0xc83e,		0x21, 0
	.dw 0x6bc0, 0xc83e,	0x6bff, 0xc83e,		0x21, 0
	.dw 0x6c40, 0xc83e,	0x6c7f, 0xc83e,		0x21, 0
	.dw 0x6cc0, 0xc83e,	0x6cff, 0xc83e,		0x21, 0
	.dw 0x6d40, 0xc83e,	0x6d7f, 0xc83e,		0x21, 0
	.dw 0x6dc0, 0xc83e,	0x6dff, 0xc83e,		0x21, 0
	.dw 0x6e40, 0xc83e,	0x6e7f, 0xc83e,		0x21, 0
	.dw 0x6ec0, 0xc83e,	0x6eff, 0xc83e,		0x21, 0
	.dw 0x6f40, 0xc83e,	0x6f7f, 0xc83e,		0x21, 0
	.dw 0x6fc0, 0xc83e,	0x6fff, 0xc83e,		0x21, 0
	.dw 0x7040, 0xc83e,	0x707f, 0xc83e,		0x21, 0
	.dw 0x70c0, 0xc83e,	0x70ff, 0xc83e,		0x21, 0
	.dw 0x7140, 0xc83e,	0x717f, 0xc83e,		0x21, 0
	.dw 0x71c0, 0xc83e,	0x71ff, 0xc83e,		0x21, 0
	.dw 0x7240, 0xc83e,	0x727f, 0xc83e,		0x21, 0
	.dw 0x72c0, 0xc83e,	0x72ff, 0xc83e,		0x21, 0
	.dw 0x7340, 0xc83e,	0x737f, 0xc83e,		0x21, 0
	.dw 0x73c0, 0xc83e,	0x73ff, 0xc83e,		0x21, 0
	.dw 0x7440, 0xc83e,	0x747f, 0xc83e,		0x21, 0
	.dw 0x74c0, 0xc83e,	0x74ff, 0xc83e,		0x21, 0
	.dw 0x7540, 0xc83e,	0x757f, 0xc83e,		0x21, 0
	.dw 0x75c0, 0xc83e,	0x75ff, 0xc83e,		0x21, 0
	.dw 0x7640, 0xc83e,	0x767f, 0xc83e,		0x21, 0
	.dw 0x76c0, 0xc83e,	0x76ff, 0xc83e,		0x21, 0
	.dw 0x7740, 0xc83e,	0x777f, 0xc83e,		0x21, 0
	.dw 0x77c0, 0xc83e,	0x77ff, 0xc83e,		0x21, 0
	.dw 0x7840, 0xc83e,	0x787f, 0xc83e,		0x21, 0
	.dw 0x78c0, 0xc83e,	0x78ff, 0xc83e,		0x21, 0
	.dw 0x7940, 0xc83e,	0x797f, 0xc83e,		0x21, 0
	.dw 0x79c0, 0xc83e,	0x7fff, 0xc83e,		0x21, 0
	.dw 0x8040, 0xc83e,	0x807f, 0xc83e,		0x21, 0
	.dw 0x80c0, 0xc83e,	0x80ff, 0xc83e,		0x21, 0
	.dw 0x8140, 0xc83e,	0x817f, 0xc83e,		0x21, 0
	.dw 0x81c0, 0xc83e,	0x81ff, 0xc83e,		0x21, 0
	.dw 0x8240, 0xc83e,	0x827f, 0xc83e,		0x21, 0
	.dw 0x82c0, 0xc83e,	0x82ff, 0xc83e,		0x21, 0
	.dw 0x8340, 0xc83e,	0x837f, 0xc83e,		0x21, 0
	.dw 0x83c0, 0xc83e,	0x83ff, 0xc83e,		0x21, 0
	.dw 0x8440, 0xc83e,	0x847f, 0xc83e,		0x21, 0
	.dw 0x84c0, 0xc83e,	0x84ff, 0xc83e,		0x21, 0
	.dw 0x8540, 0xc83e,	0x857f, 0xc83e,		0x21, 0
	.dw 0x85c0, 0xc83e,	0x85ff, 0xc83e,		0x21, 0
	.dw 0x8640, 0xc83e,	0x867f, 0xc83e,		0x21, 0
	.dw 0x86c0, 0xc83e,	0x86ff, 0xc83e,		0x21, 0
	.dw 0x8740, 0xc83e,	0x877f, 0xc83e,		0x21, 0
	.dw 0x87c0, 0xc83e,	0x87ff, 0xc83e,		0x21, 0
	.dw 0x8840, 0xc83e,	0x887f, 0xc83e,		0x21, 0
	.dw 0x88c0, 0xc83e,	0x88ff, 0xc83e,		0x21, 0
	.dw 0x8940, 0xc83e,	0x897f, 0xc83e,		0x21, 0
	.dw 0x89c0, 0xc83e,	0x89ff, 0xc83e,		0x21, 0
	.dw 0x8a40, 0xc83e,	0x8a7f, 0xc83e,		0x21, 0
	.dw 0x8ac0, 0xc83e,	0x8aff, 0xc83e,		0x21, 0
	.dw 0x8b40, 0xc83e,	0x8b7f, 0xc83e,		0x21, 0
	.dw 0x8bc0, 0xc83e,	0x8bff, 0xc83e,		0x21, 0
	.dw 0x8c40, 0xc83e,	0x8c7f, 0xc83e,		0x21, 0
	.dw 0x8cc0, 0xc83e,	0x8cff, 0xc83e,		0x21, 0
	.dw 0x8d40, 0xc83e,	0x8d7f, 0xc83e,		0x21, 0
	.dw 0x8dc0, 0xc83e,	0x8dff, 0xc83e,		0x21, 0
	.dw 0x8e40, 0xc83e,	0x8e7f, 0xc83e,		0x21, 0
	.dw 0x8ec0, 0xc83e,	0x8eff, 0xc83e,		0x21, 0
	.dw 0x8f40, 0xc83e,	0x8f7f, 0xc83e,		0x21, 0
	.dw 0x8fc0, 0xc83e,	0x8fff, 0xc83e,		0x21, 0
	.dw 0x9040, 0xc83e,	0x907f, 0xc83e,		0x21, 0
	.dw 0x90c0, 0xc83e,	0x90ff, 0xc83e,		0x21, 0
	.dw 0x9140, 0xc83e,	0x917f, 0xc83e,		0x21, 0
	.dw 0x91c0, 0xc83e,	0x91ff, 0xc83e,		0x21, 0
	.dw 0x9240, 0xc83e,	0x927f, 0xc83e,		0x21, 0
	.dw 0x92c0, 0xc83e,	0x92ff, 0xc83e,		0x21, 0
	.dw 0x9340, 0xc83e,	0x937f, 0xc83e,		0x21, 0
	.dw 0x93c0, 0xc83e,	0x93ff, 0xc83e,		0x21, 0
	.dw 0x9440, 0xc83e,	0x947f, 0xc83e,		0x21, 0
	.dw 0x94c0, 0xc83e,	0x94ff, 0xc83e,		0x21, 0
	.dw 0x9540, 0xc83e,	0x957f, 0xc83e,		0x21, 0
	.dw 0x95c0, 0xc83e,	0x95ff, 0xc83e,		0x21, 0
	.dw 0x9640, 0xc83e,	0x967f, 0xc83e,		0x21, 0
	.dw 0x96c0, 0xc83e,	0x96ff, 0xc83e,		0x21, 0
	.dw 0x9740, 0xc83e,	0x977f, 0xc83e,		0x21, 0
	.dw 0x97c0, 0xc83e,	0x97ff, 0xc83e,		0x21, 0
	.dw 0x9840, 0xc83e,	0x987f, 0xc83e,		0x21, 0
	.dw 0x98c0, 0xc83e,	0x98ff, 0xc83e,		0x21, 0
	.dw 0x9940, 0xc83e,	0x997f, 0xc83e,		0x21, 0
	.dw 0x99c0, 0xc83e,	0x9fff, 0xc83e,		0x21, 0
	.dw 0xa040, 0xc83e,	0xa07f, 0xc83e,		0x21, 0
	.dw 0xa0c0, 0xc83e,	0xa0ff, 0xc83e,		0x21, 0
	.dw 0xa140, 0xc83e,	0xa17f, 0xc83e,		0x21, 0
	.dw 0xa1c0, 0xc83e,	0xa1ff, 0xc83e,		0x21, 0
	.dw 0xa240, 0xc83e,	0xa27f, 0xc83e,		0x21, 0
	.dw 0xa2c0, 0xc83e,	0xa2ff, 0xc83e,		0x21, 0
	.dw 0xa340, 0xc83e,	0xa37f, 0xc83e,		0x21, 0
	.dw 0xa3c0, 0xc83e,	0xa3ff, 0xc83e,		0x21, 0
	.dw 0xa440, 0xc83e,	0xa47f, 0xc83e,		0x21, 0
	.dw 0xa4c0, 0xc83e,	0xa4ff, 0xc83e,		0x21, 0
	.dw 0xa540, 0xc83e,	0xa57f, 0xc83e,		0x21, 0
	.dw 0xa5c0, 0xc83e,	0xa5ff, 0xc83e,		0x21, 0
	.dw 0xa640, 0xc83e,	0xa67f, 0xc83e,		0x21, 0
	.dw 0xa6c0, 0xc83e,	0xa6ff, 0xc83e,		0x21, 0
	.dw 0xa740, 0xc83e,	0xa77f, 0xc83e,		0x21, 0
	.dw 0xa7c0, 0xc83e,	0xa7ff, 0xc83e,		0x21, 0
	.dw 0xa840, 0xc83e,	0xa87f, 0xc83e,		0x21, 0
	.dw 0xa8c0, 0xc83e,	0xa8ff, 0xc83e,		0x21, 0
	.dw 0xa940, 0xc83e,	0xa97f, 0xc83e,		0x21, 0
	.dw 0xa9c0, 0xc83e,	0xa9ff, 0xc83e,		0x21, 0
	.dw 0xaa40, 0xc83e,	0xaa7f, 0xc83e,		0x21, 0
	.dw 0xaac0, 0xc83e,	0xaaff, 0xc83e,		0x21, 0
	.dw 0xab40, 0xc83e,	0xab7f, 0xc83e,		0x21, 0
	.dw 0xabc0, 0xc83e,	0xabff, 0xc83e,		0x21, 0
	.dw 0xac40, 0xc83e,	0xac7f, 0xc83e,		0x21, 0
	.dw 0xacc0, 0xc83e,	0xacff, 0xc83e,		0x21, 0
	.dw 0xad40, 0xc83e,	0xad7f, 0xc83e,		0x21, 0
	.dw 0xadc0, 0xc83e,	0xadff, 0xc83e,		0x21, 0
	.dw 0xae40, 0xc83e,	0xae7f, 0xc83e,		0x21, 0
	.dw 0xaec0, 0xc83e,	0xaeff, 0xc83e,		0x21, 0
	.dw 0xaf40, 0xc83e,	0xaf7f, 0xc83e,		0x21, 0
	.dw 0xafc0, 0xc83e,	0xafff, 0xc83e,		0x21, 0
	.dw 0xb040, 0xc83e,	0xb07f, 0xc83e,		0x21, 0
	.dw 0xb0c0, 0xc83e,	0xb0ff, 0xc83e,		0x21, 0
	.dw 0xb140, 0xc83e,	0xb17f, 0xc83e,		0x21, 0
	.dw 0xb1c0, 0xc83e,	0xb1ff, 0xc83e,		0x21, 0
	.dw 0xb240, 0xc83e,	0xb27f, 0xc83e,		0x21, 0
	.dw 0xb2c0, 0xc83e,	0xb2ff, 0xc83e,		0x21, 0
	.dw 0xb340, 0xc83e,	0xb37f, 0xc83e,		0x21, 0
	.dw 0xb3c0, 0xc83e,	0xb3ff, 0xc83e,		0x21, 0
	.dw 0xb440, 0xc83e,	0xb47f, 0xc83e,		0x21, 0
	.dw 0xb4c0, 0xc83e,	0xb4ff, 0xc83e,		0x21, 0
	.dw 0xb540, 0xc83e,	0xb57f, 0xc83e,		0x21, 0
	.dw 0xb5c0, 0xc83e,	0xb5ff, 0xc83e,		0x21, 0
	.dw 0xb640, 0xc83e,	0xb67f, 0xc83e,		0x21, 0
	.dw 0xb6c0, 0xc83e,	0xb6ff, 0xc83e,		0x21, 0
	.dw 0xb740, 0xc83e,	0xb77f, 0xc83e,		0x21, 0
	.dw 0xb7c0, 0xc83e,	0xb7ff, 0xc83e,		0x21, 0
	.dw 0xb840, 0xc83e,	0xb87f, 0xc83e,		0x21, 0
	.dw 0xb8c0, 0xc83e,	0xb8ff, 0xc83e,		0x21, 0
	.dw 0xb940, 0xc83e,	0xb97f, 0xc83e,		0x21, 0
	.dw 0xb9c0, 0xc83e,	0xbfff, 0xc83e,		0x21, 0
	.dw 0xc040, 0xc83e,	0xc07f, 0xc83e,		0x21, 0
	.dw 0xc0c0, 0xc83e,	0xc0ff, 0xc83e,		0x21, 0
	.dw 0xc140, 0xc83e,	0xc17f, 0xc83e,		0x21, 0
	.dw 0xc1c0, 0xc83e,	0xc1ff, 0xc83e,		0x21, 0
	.dw 0xc240, 0xc83e,	0xc27f, 0xc83e,		0x21, 0
	.dw 0xc2c0, 0xc83e,	0xc2ff, 0xc83e,		0x21, 0
	.dw 0xc340, 0xc83e,	0xc37f, 0xc83e,		0x21, 0
	.dw 0xc3c0, 0xc83e,	0xc3ff, 0xc83e,		0x21, 0
	.dw 0xc440, 0xc83e,	0xc47f, 0xc83e,		0x21, 0
	.dw 0xc4c0, 0xc83e,	0xc4ff, 0xc83e,		0x21, 0
	.dw 0xc540, 0xc83e,	0xc57f, 0xc83e,		0x21, 0
	.dw 0xc5c0, 0xc83e,	0xc5ff, 0xc83e,		0x21, 0
	.dw 0xc640, 0xc83e,	0xc67f, 0xc83e,		0x21, 0
	.dw 0xc6c0, 0xc83e,	0xc6ff, 0xc83e,		0x21, 0
	.dw 0xc740, 0xc83e,	0xc77f, 0xc83e,		0x21, 0
	.dw 0xc7c0, 0xc83e,	0xc7ff, 0xc83e,		0x21, 0
	.dw 0xc840, 0xc83e,	0xc87f, 0xc83e,		0x21, 0
	.dw 0xc8c0, 0xc83e,	0xc8ff, 0xc83e,		0x21, 0
	.dw 0xc940, 0xc83e,	0xc97f, 0xc83e,		0x21, 0
	.dw 0xc9c0, 0xc83e,	0xc9ff, 0xc83e,		0x21, 0
	.dw 0xca40, 0xc83e,	0xca7f, 0xc83e,		0x21, 0
	.dw 0xcac0, 0xc83e,	0xcaff, 0xc83e,		0x21, 0
	.dw 0xcb40, 0xc83e,	0xcb7f, 0xc83e,		0x21, 0
	.dw 0xcbc0, 0xc83e,	0xcbff, 0xc83e,		0x21, 0
	.dw 0xcc40, 0xc83e,	0xcc7f, 0xc83e,		0x21, 0
	.dw 0xccc0, 0xc83e,	0xccff, 0xc83e,		0x21, 0
	.dw 0xcd40, 0xc83e,	0xcd7f, 0xc83e,		0x21, 0
	.dw 0xcdc0, 0xc83e,	0xcdff, 0xc83e,		0x21, 0
	.dw 0xce40, 0xc83e,	0xce7f, 0xc83e,		0x21, 0
	.dw 0xcec0, 0xc83e,	0xceff, 0xc83e,		0x21, 0
	.dw 0xcf40, 0xc83e,	0xcf7f, 0xc83e,		0x21, 0
	.dw 0xcfc0, 0xc83e,	0xcfff, 0xc83e,		0x21, 0
	.dw 0xd040, 0xc83e,	0xd07f, 0xc83e,		0x21, 0
	.dw 0xd0c0, 0xc83e,	0xd0ff, 0xc83e,		0x21, 0
	.dw 0xd140, 0xc83e,	0xd17f, 0xc83e,		0x21, 0
	.dw 0xd1c0, 0xc83e,	0xd1ff, 0xc83e,		0x21, 0
	.dw 0xd240, 0xc83e,	0xd27f, 0xc83e,		0x21, 0
	.dw 0xd2c0, 0xc83e,	0xd2ff, 0xc83e,		0x21, 0
	.dw 0xd340, 0xc83e,	0xd37f, 0xc83e,		0x21, 0
	.dw 0xd3c0, 0xc83e,	0xd3ff, 0xc83e,		0x21, 0
	.dw 0xd440, 0xc83e,	0xd47f, 0xc83e,		0x21, 0
	.dw 0xd4c0, 0xc83e,	0xd4ff, 0xc83e,		0x21, 0
	.dw 0xd540, 0xc83e,	0xd57f, 0xc83e,		0x21, 0
	.dw 0xd5c0, 0xc83e,	0xd5ff, 0xc83e,		0x21, 0
	.dw 0xd640, 0xc83e,	0xd67f, 0xc83e,		0x21, 0
	.dw 0xd6c0, 0xc83e,	0xd6ff, 0xc83e,		0x21, 0
	.dw 0xd740, 0xc83e,	0xd77f, 0xc83e,		0x21, 0
	.dw 0xd7c0, 0xc83e,	0xd7ff, 0xc83e,		0x21, 0
	.dw 0xd840, 0xc83e,	0xd87f, 0xc83e,		0x21, 0
	.dw 0xd8c0, 0xc83e,	0xd8ff, 0xc83e,		0x21, 0
	.dw 0xd940, 0xc83e,	0xd97f, 0xc83e,		0x21, 0
	.dw 0xd9c0, 0xc83e,	0xdfff, 0xc83e,		0x21, 0
	.dw 0xe040, 0xc83e,	0xe07f, 0xc83e,		0x21, 0
	.dw 0xe0c0, 0xc83e,	0xe0ff, 0xc83e,		0x21, 0
	.dw 0xe140, 0xc83e,	0xe17f, 0xc83e,		0x21, 0
	.dw 0xe1c0, 0xc83e,	0xe1ff, 0xc83e,		0x21, 0
	.dw 0xe240, 0xc83e,	0xe27f, 0xc83e,		0x21, 0
	.dw 0xe2c0, 0xc83e,	0xe2ff, 0xc83e,		0x21, 0
	.dw 0xe340, 0xc83e,	0xe37f, 0xc83e,		0x21, 0
	.dw 0xe3c0, 0xc83e,	0xe3ff, 0xc83e,		0x21, 0
	.dw 0xe440, 0xc83e,	0xe47f, 0xc83e,		0x21, 0
	.dw 0xe4c0, 0xc83e,	0xe4ff, 0xc83e,		0x21, 0
	.dw 0xe540, 0xc83e,	0xe57f, 0xc83e,		0x21, 0
	.dw 0xe5c0, 0xc83e,	0xe5ff, 0xc83e,		0x21, 0
	.dw 0xe640, 0xc83e,	0xe67f, 0xc83e,		0x21, 0
	.dw 0xe6c0, 0xc83e,	0xe6ff, 0xc83e,		0x21, 0
	.dw 0xe740, 0xc83e,	0xe77f, 0xc83e,		0x21, 0
	.dw 0xe7c0, 0xc83e,	0xe7ff, 0xc83e,		0x21, 0
	.dw 0xe840, 0xc83e,	0xe87f, 0xc83e,		0x21, 0
	.dw 0xe8c0, 0xc83e,	0xe8ff, 0xc83e,		0x21, 0
	.dw 0xe940, 0xc83e,	0xe97f, 0xc83e,		0x21, 0
	.dw 0xe9c0, 0xc83e,	0xe9ff, 0xc83e,		0x21, 0
	.dw 0xea40, 0xc83e,	0xea7f, 0xc83e,		0x21, 0
	.dw 0xeac0, 0xc83e,	0xeaff, 0xc83e,		0x21, 0
	.dw 0xeb40, 0xc83e,	0xeb7f, 0xc83e,		0x21, 0
	.dw 0xebc0, 0xc83e,	0xebff, 0xc83e,		0x21, 0
	.dw 0xec40, 0xc83e,	0xec7f, 0xc83e,		0x21, 0
	.dw 0xecc0, 0xc83e,	0xecff, 0xc83e,		0x21, 0
	.dw 0xed40, 0xc83e,	0xed7f, 0xc83e,		0x21, 0
	.dw 0xedc0, 0xc83e,	0xedff, 0xc83e,		0x21, 0
	.dw 0xee40, 0xc83e,	0xee7f, 0xc83e,		0x21, 0
	.dw 0xeec0, 0xc83e,	0xeeff, 0xc83e,		0x21, 0
	.dw 0xef40, 0xc83e,	0xef7f, 0xc83e,		0x21, 0
	.dw 0xefc0, 0xc83e,	0xefff, 0xc83e,		0x21, 0
	.dw 0xf040, 0xc83e,	0xf07f, 0xc83e,		0x21, 0
	.dw 0xf0c0, 0xc83e,	0xf0ff, 0xc83e,		0x21, 0
	.dw 0xf140, 0xc83e,	0xf17f, 0xc83e,		0x21, 0
	.dw 0xf1c0, 0xc83e,	0xf1ff, 0xc83e,		0x21, 0
	.dw 0xf240, 0xc83e,	0xf27f, 0xc83e,		0x21, 0
	.dw 0xf2c0, 0xc83e,	0xf2ff, 0xc83e,		0x21, 0
	.dw 0xf340, 0xc83e,	0xf37f, 0xc83e,		0x21, 0
	.dw 0xf3c0, 0xc83e,	0xf3ff, 0xc83e,		0x21, 0
	.dw 0xf440, 0xc83e,	0xf47f, 0xc83e,		0x21, 0
	.dw 0xf4c0, 0xc83e,	0xf4ff, 0xc83e,		0x21, 0
	.dw 0xf540, 0xc83e,	0xf57f, 0xc83e,		0x21, 0
	.dw 0xf5c0, 0xc83e,	0xf5ff, 0xc83e,		0x21, 0
	.dw 0xf640, 0xc83e,	0xf67f, 0xc83e,		0x21, 0
	.dw 0xf6c0, 0xc83e,	0xf6ff, 0xc83e,		0x21, 0
	.dw 0xf740, 0xc83e,	0xf77f, 0xc83e,		0x21, 0
	.dw 0xf7c0, 0xc83e,	0xf7ff, 0xc83e,		0x21, 0
	.dw 0xf840, 0xc83e,	0xf87f, 0xc83e,		0x21, 0
	.dw 0xf8c0, 0xc83e,	0xf8ff, 0xc83e,		0x21, 0
	.dw 0xf940, 0xc83e,	0xf97f, 0xc83e,		0x21, 0
	.dw 0xf9c0, 0xc83e,	0xffff, 0xc83e,		0x21, 0
	.dw 0x0040, 0xc83f,	0x007f, 0xc83f,		0x21, 0
	.dw 0x00c0, 0xc83f,	0x00ff, 0xc83f,		0x21, 0
	.dw 0x0140, 0xc83f,	0x017f, 0xc83f,		0x21, 0
	.dw 0x01c0, 0xc83f,	0x01ff, 0xc83f,		0x21, 0
	.dw 0x0240, 0xc83f,	0x027f, 0xc83f,		0x21, 0
	.dw 0x02c0, 0xc83f,	0x02ff, 0xc83f,		0x21, 0
	.dw 0x0340, 0xc83f,	0x037f, 0xc83f,		0x21, 0
	.dw 0x03c0, 0xc83f,	0x03ff, 0xc83f,		0x21, 0
	.dw 0x0440, 0xc83f,	0x047f, 0xc83f,		0x21, 0
	.dw 0x04c0, 0xc83f,	0x04ff, 0xc83f,		0x21, 0
	.dw 0x0540, 0xc83f,	0x057f, 0xc83f,		0x21, 0
	.dw 0x05c0, 0xc83f,	0x05ff, 0xc83f,		0x21, 0
	.dw 0x0640, 0xc83f,	0x067f, 0xc83f,		0x21, 0
	.dw 0x06c0, 0xc83f,	0x06ff, 0xc83f,		0x21, 0
	.dw 0x0740, 0xc83f,	0x077f, 0xc83f,		0x21, 0
	.dw 0x07c0, 0xc83f,	0x07ff, 0xc83f,		0x21, 0
	.dw 0x0840, 0xc83f,	0x087f, 0xc83f,		0x21, 0
	.dw 0x08c0, 0xc83f,	0x08ff, 0xc83f,		0x21, 0
	.dw 0x0940, 0xc83f,	0x097f, 0xc83f,		0x21, 0
	.dw 0x09c0, 0xc83f,	0x09ff, 0xc83f,		0x21, 0
	.dw 0x0a40, 0xc83f,	0x0a7f, 0xc83f,		0x21, 0
	.dw 0x0ac0, 0xc83f,	0x0aff, 0xc83f,		0x21, 0
	.dw 0x0b40, 0xc83f,	0x0b7f, 0xc83f,		0x21, 0
	.dw 0x0bc0, 0xc83f,	0x0bff, 0xc83f,		0x21, 0
	.dw 0x0c40, 0xc83f,	0x0c7f, 0xc83f,		0x21, 0
	.dw 0x0cc0, 0xc83f,	0x0cff, 0xc83f,		0x21, 0
	.dw 0x0d40, 0xc83f,	0x0d7f, 0xc83f,		0x21, 0
	.dw 0x0dc0, 0xc83f,	0x0dff, 0xc83f,		0x21, 0
	.dw 0x0e40, 0xc83f,	0x0e7f, 0xc83f,		0x21, 0
	.dw 0x0ec0, 0xc83f,	0x0eff, 0xc83f,		0x21, 0
	.dw 0x0f40, 0xc83f,	0x0f7f, 0xc83f,		0x21, 0
	.dw 0x0fc0, 0xc83f,	0x0fff, 0xc83f,		0x21, 0
	.dw 0x1040, 0xc83f,	0x107f, 0xc83f,		0x21, 0
	.dw 0x10c0, 0xc83f,	0x10ff, 0xc83f,		0x21, 0
	.dw 0x1140, 0xc83f,	0x117f, 0xc83f,		0x21, 0
	.dw 0x11c0, 0xc83f,	0x11ff, 0xc83f,		0x21, 0
	.dw 0x1240, 0xc83f,	0x127f, 0xc83f,		0x21, 0
	.dw 0x12c0, 0xc83f,	0x12ff, 0xc83f,		0x21, 0
	.dw 0x1340, 0xc83f,	0x137f, 0xc83f,		0x21, 0
	.dw 0x13c0, 0xc83f,	0x13ff, 0xc83f,		0x21, 0
	.dw 0x1440, 0xc83f,	0x147f, 0xc83f,		0x21, 0
	.dw 0x14c0, 0xc83f,	0x14ff, 0xc83f,		0x21, 0
	.dw 0x1540, 0xc83f,	0x157f, 0xc83f,		0x21, 0
	.dw 0x15c0, 0xc83f,	0x15ff, 0xc83f,		0x21, 0
	.dw 0x1640, 0xc83f,	0x167f, 0xc83f,		0x21, 0
	.dw 0x16c0, 0xc83f,	0x16ff, 0xc83f,		0x21, 0
	.dw 0x1740, 0xc83f,	0x177f, 0xc83f,		0x21, 0
	.dw 0x17c0, 0xc83f,	0x17ff, 0xc83f,		0x21, 0
	.dw 0x1840, 0xc83f,	0x187f, 0xc83f,		0x21, 0
	.dw 0x18c0, 0xc83f,	0x18ff, 0xc83f,		0x21, 0
	.dw 0x1940, 0xc83f,	0x197f, 0xc83f,		0x21, 0
	.dw 0x19c0, 0xc83f,	0x1fff, 0xc83f,		0x21, 0
	.dw 0x2040, 0xc83f,	0x207f, 0xc83f,		0x21, 0
	.dw 0x20c0, 0xc83f,	0x20ff, 0xc83f,		0x21, 0
	.dw 0x2140, 0xc83f,	0x217f, 0xc83f,		0x21, 0
	.dw 0x21c0, 0xc83f,	0x21ff, 0xc83f,		0x21, 0
	.dw 0x2240, 0xc83f,	0x227f, 0xc83f,		0x21, 0
	.dw 0x22c0, 0xc83f,	0x22ff, 0xc83f,		0x21, 0
	.dw 0x2340, 0xc83f,	0x237f, 0xc83f,		0x21, 0
	.dw 0x23c0, 0xc83f,	0x23ff, 0xc83f,		0x21, 0
	.dw 0x2440, 0xc83f,	0x247f, 0xc83f,		0x21, 0
	.dw 0x24c0, 0xc83f,	0x24ff, 0xc83f,		0x21, 0
	.dw 0x2540, 0xc83f,	0x257f, 0xc83f,		0x21, 0
	.dw 0x25c0, 0xc83f,	0x25ff, 0xc83f,		0x21, 0
	.dw 0x2640, 0xc83f,	0x267f, 0xc83f,		0x21, 0
	.dw 0x26c0, 0xc83f,	0x26ff, 0xc83f,		0x21, 0
	.dw 0x2740, 0xc83f,	0x277f, 0xc83f,		0x21, 0
	.dw 0x27c0, 0xc83f,	0x27ff, 0xc83f,		0x21, 0
	.dw 0x2840, 0xc83f,	0x287f, 0xc83f,		0x21, 0
	.dw 0x28c0, 0xc83f,	0x28ff, 0xc83f,		0x21, 0
	.dw 0x2940, 0xc83f,	0x297f, 0xc83f,		0x21, 0
	.dw 0x29c0, 0xc83f,	0x29ff, 0xc83f,		0x21, 0
	.dw 0x2a40, 0xc83f,	0x2a7f, 0xc83f,		0x21, 0
	.dw 0x2ac0, 0xc83f,	0x2aff, 0xc83f,		0x21, 0
	.dw 0x2b40, 0xc83f,	0x2b7f, 0xc83f,		0x21, 0
	.dw 0x2bc0, 0xc83f,	0x2bff, 0xc83f,		0x21, 0
	.dw 0x2c40, 0xc83f,	0x2c7f, 0xc83f,		0x21, 0
	.dw 0x2cc0, 0xc83f,	0x2cff, 0xc83f,		0x21, 0
	.dw 0x2d40, 0xc83f,	0x2d7f, 0xc83f,		0x21, 0
	.dw 0x2dc0, 0xc83f,	0x2dff, 0xc83f,		0x21, 0
	.dw 0x2e40, 0xc83f,	0x2e7f, 0xc83f,		0x21, 0
	.dw 0x2ec0, 0xc83f,	0x2eff, 0xc83f,		0x21, 0
	.dw 0x2f40, 0xc83f,	0x2f7f, 0xc83f,		0x21, 0
	.dw 0x2fc0, 0xc83f,	0x2fff, 0xc83f,		0x21, 0
	.dw 0x3040, 0xc83f,	0x307f, 0xc83f,		0x21, 0
	.dw 0x30c0, 0xc83f,	0x30ff, 0xc83f,		0x21, 0
	.dw 0x3140, 0xc83f,	0x317f, 0xc83f,		0x21, 0
	.dw 0x31c0, 0xc83f,	0x31ff, 0xc83f,		0x21, 0
	.dw 0x3240, 0xc83f,	0x327f, 0xc83f,		0x21, 0
	.dw 0x32c0, 0xc83f,	0x32ff, 0xc83f,		0x21, 0
	.dw 0x3340, 0xc83f,	0x337f, 0xc83f,		0x21, 0
	.dw 0x33c0, 0xc83f,	0x33ff, 0xc83f,		0x21, 0
	.dw 0x3440, 0xc83f,	0x347f, 0xc83f,		0x21, 0
	.dw 0x34c0, 0xc83f,	0x34ff, 0xc83f,		0x21, 0
	.dw 0x3540, 0xc83f,	0x357f, 0xc83f,		0x21, 0
	.dw 0x35c0, 0xc83f,	0x35ff, 0xc83f,		0x21, 0
	.dw 0x3640, 0xc83f,	0x367f, 0xc83f,		0x21, 0
	.dw 0x36c0, 0xc83f,	0x36ff, 0xc83f,		0x21, 0
	.dw 0x3740, 0xc83f,	0x377f, 0xc83f,		0x21, 0
	.dw 0x37c0, 0xc83f,	0x37ff, 0xc83f,		0x21, 0
	.dw 0x3840, 0xc83f,	0x387f, 0xc83f,		0x21, 0
	.dw 0x38c0, 0xc83f,	0x38ff, 0xc83f,		0x21, 0
	.dw 0x3940, 0xc83f,	0x397f, 0xc83f,		0x21, 0
	.dw 0x39c0, 0xc83f,	0x1fff, 0xc840,		0x21, 0
	.dw 0x3a00, 0xc840,	0x5fff, 0xc840,		0x21, 0
	.dw 0x7a00, 0xc840,	0x9fff, 0xc840,		0x21, 0
	.dw 0xba00, 0xc840,	0xdfff, 0xc840,		0x21, 0
	.dw 0xfa00, 0xc840,	0x1fff, 0xc841,		0x21, 0
	.dw 0x3a00, 0xc841,	0x5fff, 0xc841,		0x21, 0
	.dw 0x7a00, 0xc841,	0x9fff, 0xc841,		0x21, 0
	.dw 0xba00, 0xc841,	0xdfff, 0xc841,		0x21, 0
	.dw 0xfa00, 0xc841,	0x1fff, 0xc842,		0x21, 0
	.dw 0x3a00, 0xc842,	0x5fff, 0xc842,		0x21, 0
	.dw 0x7a00, 0xc842,	0x9fff, 0xc842,		0x21, 0
	.dw 0xba00, 0xc842,	0xdfff, 0xc842,		0x21, 0
	.dw 0xfa00, 0xc842,	0x1fff, 0xc843,		0x21, 0
	.dw 0x3a00, 0xc843,	0xffff, 0xc843,		0x21, 0
	.dw 0x1a00, 0xc844,	0x1fff, 0xc844,		0x21, 0
	.dw 0x3a00, 0xc844,	0x3fff, 0xc844,		0x21, 0
	.dw 0x5a00, 0xc844,	0x5fff, 0xc844,		0x21, 0
	.dw 0x7a00, 0xc844,	0x7fff, 0xc844,		0x21, 0
	.dw 0x9a00, 0xc844,	0x9fff, 0xc844,		0x21, 0
	.dw 0xba00, 0xc844,	0xbfff, 0xc844,		0x21, 0
	.dw 0xda00, 0xc844,	0xdfff, 0xc844,		0x21, 0
	.dw 0xfa00, 0xc844,	0xffff, 0xc844,		0x21, 0
	.dw 0x1a00, 0xc845,	0x1fff, 0xc845,		0x21, 0
	.dw 0x3a00, 0xc845,	0x3fff, 0xc845,		0x21, 0
	.dw 0x5a00, 0xc845,	0x5fff, 0xc845,		0x21, 0
	.dw 0x7a00, 0xc845,	0x7fff, 0xc845,		0x21, 0
	.dw 0x9a00, 0xc845,	0x9fff, 0xc845,		0x21, 0
	.dw 0xba00, 0xc845,	0xbfff, 0xc845,		0x21, 0
	.dw 0xda00, 0xc845,	0xdfff, 0xc845,		0x21, 0
	.dw 0xfa00, 0xc845,	0xffff, 0xc845,		0x21, 0
	.dw 0x1a00, 0xc846,	0x1fff, 0xc846,		0x21, 0
	.dw 0x3a00, 0xc846,	0x3fff, 0xc846,		0x21, 0
	.dw 0x5a00, 0xc846,	0x5fff, 0xc846,		0x21, 0
	.dw 0x7a00, 0xc846,	0x7fff, 0xc846,		0x21, 0
	.dw 0x9a00, 0xc846,	0x9fff, 0xc846,		0x21, 0
	.dw 0xba00, 0xc846,	0xbfff, 0xc846,		0x21, 0
	.dw 0xda00, 0xc846,	0xdfff, 0xc846,		0x21, 0
	.dw 0xfa00, 0xc846,	0xffff, 0xc846,		0x21, 0
	.dw 0x1a00, 0xc847,	0x1fff, 0xc847,		0x21, 0
	.dw 0x3a00, 0xc847,	0x1fff, 0xc850,		0x21, 0
	.dw 0x3a00, 0xc850,	0x5fff, 0xc850,		0x21, 0
	.dw 0x7a00, 0xc850,	0x9fff, 0xc850,		0x21, 0
	.dw 0xba00, 0xc850,	0xdfff, 0xc850,		0x21, 0
	.dw 0xfa00, 0xc850,	0x1fff, 0xc851,		0x21, 0
	.dw 0x3a00, 0xc851,	0x5fff, 0xc851,		0x21, 0
	.dw 0x7a00, 0xc851,	0x9fff, 0xc851,		0x21, 0
	.dw 0xba00, 0xc851,	0xdfff, 0xc851,		0x21, 0
	.dw 0xfa00, 0xc851,	0x1fff, 0xc852,		0x21, 0
	.dw 0x3a00, 0xc852,	0x5fff, 0xc852,		0x21, 0
	.dw 0x7a00, 0xc852,	0x9fff, 0xc852,		0x21, 0
	.dw 0xba00, 0xc852,	0xdfff, 0xc852,		0x21, 0
	.dw 0xfa00, 0xc852,	0xffff, 0xc853,		0x21, 0
	.dw 0x1a00, 0xc854,	0x1fff, 0xc854,		0x21, 0
	.dw 0x3a00, 0xc854,	0x3fff, 0xc854,		0x21, 0
	.dw 0x5a00, 0xc854,	0x5fff, 0xc854,		0x21, 0
	.dw 0x7a00, 0xc854,	0x7fff, 0xc854,		0x21, 0
	.dw 0x9a00, 0xc854,	0x9fff, 0xc854,		0x21, 0
	.dw 0xba00, 0xc854,	0xbfff, 0xc854,		0x21, 0
	.dw 0xda00, 0xc854,	0xdfff, 0xc854,		0x21, 0
	.dw 0xfa00, 0xc854,	0xffff, 0xc854,		0x21, 0
	.dw 0x1a00, 0xc855,	0x1fff, 0xc855,		0x21, 0
	.dw 0x3a00, 0xc855,	0x3fff, 0xc855,		0x21, 0
	.dw 0x5a00, 0xc855,	0x5fff, 0xc855,		0x21, 0
	.dw 0x7a00, 0xc855,	0x7fff, 0xc855,		0x21, 0
	.dw 0x9a00, 0xc855,	0x9fff, 0xc855,		0x21, 0
	.dw 0xba00, 0xc855,	0xbfff, 0xc855,		0x21, 0
	.dw 0xda00, 0xc855,	0xdfff, 0xc855,		0x21, 0
	.dw 0xfa00, 0xc855,	0xffff, 0xc855,		0x21, 0
	.dw 0x1a00, 0xc856,	0x1fff, 0xc856,		0x21, 0
	.dw 0x3a00, 0xc856,	0x3fff, 0xc856,		0x21, 0
	.dw 0x5a00, 0xc856,	0x5fff, 0xc856,		0x21, 0
	.dw 0x7a00, 0xc856,	0x7fff, 0xc856,		0x21, 0
	.dw 0x9a00, 0xc856,	0x9fff, 0xc856,		0x21, 0
	.dw 0xba00, 0xc856,	0xbfff, 0xc856,		0x21, 0
	.dw 0xda00, 0xc856,	0xdfff, 0xc856,		0x21, 0
	.dw 0xfa00, 0xc856,	0xffff, 0xc856,		0x21, 0
	.dw 0x1a00, 0xc857,	0x1fff, 0xc857,		0x21, 0
	.dw 0x3a00, 0xc857,	0xffff, 0xc85f,		0x21, 0
	.dw 0x1a00, 0xc860,	0x3fff, 0xc860,		0x21, 0
	.dw 0x5a00, 0xc860,	0x7fff, 0xc860,		0x21, 0
	.dw 0x9a00, 0xc860,	0xbfff, 0xc860,		0x21, 0
	.dw 0xda00, 0xc860,	0xffff, 0xc860,		0x21, 0
	.dw 0x1a00, 0xc861,	0x3fff, 0xc861,		0x21, 0
	.dw 0x5a00, 0xc861,	0x7fff, 0xc861,		0x21, 0
	.dw 0x9a00, 0xc861,	0xbfff, 0xc861,		0x21, 0
	.dw 0xda00, 0xc861,	0xffff, 0xc861,		0x21, 0
	.dw 0x1a00, 0xc862,	0x3fff, 0xc862,		0x21, 0
	.dw 0x5a00, 0xc862,	0x7fff, 0xc862,		0x21, 0
	.dw 0x9a00, 0xc862,	0xbfff, 0xc862,		0x21, 0
	.dw 0xda00, 0xc862,	0xffff, 0xc862,		0x21, 0
	.dw 0x1a00, 0xc863,	0xffff, 0xc86f,		0x21, 0
	.dw 0x1a00, 0xc870,	0x3fff, 0xc870,		0x21, 0
	.dw 0x5a00, 0xc870,	0x7fff, 0xc870,		0x21, 0
	.dw 0x9a00, 0xc870,	0xbfff, 0xc870,		0x21, 0
	.dw 0xda00, 0xc870,	0xffff, 0xc870,		0x21, 0
	.dw 0x1a00, 0xc871,	0x3fff, 0xc871,		0x21, 0
	.dw 0x5a00, 0xc871,	0x7fff, 0xc871,		0x21, 0
	.dw 0x9a00, 0xc871,	0xbfff, 0xc871,		0x21, 0
	.dw 0xda00, 0xc871,	0xffff, 0xc871,		0x21, 0
	.dw 0x1a00, 0xc872,	0x3fff, 0xc872,		0x21, 0
	.dw 0x5a00, 0xc872,	0x7fff, 0xc872,		0x21, 0
	.dw 0x9a00, 0xc872,	0xbfff, 0xc872,		0x21, 0
	.dw 0xda00, 0xc872,	0xffff, 0xc87f,		0x21, 0
	.dw 0x1a00, 0xc880,	0x1fff, 0xc880,		0x21, 0
	.dw 0x3a00, 0xc880,	0x3fff, 0xc880,		0x21, 0
	.dw 0x5a00, 0xc880,	0x5fff, 0xc880,		0x21, 0
	.dw 0x7a00, 0xc880,	0x7fff, 0xc880,		0x21, 0
	.dw 0x9a00, 0xc880,	0x9fff, 0xc880,		0x21, 0
	.dw 0xba00, 0xc880,	0xbfff, 0xc880,		0x21, 0
	.dw 0xda00, 0xc880,	0xdfff, 0xc880,		0x21, 0
	.dw 0xfa00, 0xc880,	0xffff, 0xc880,		0x21, 0
	.dw 0x1a00, 0xc881,	0x1fff, 0xc881,		0x21, 0
	.dw 0x3a00, 0xc881,	0x3fff, 0xc881,		0x21, 0
	.dw 0x5a00, 0xc881,	0x5fff, 0xc881,		0x21, 0
	.dw 0x7a00, 0xc881,	0x7fff, 0xc881,		0x21, 0
	.dw 0x9a00, 0xc881,	0x9fff, 0xc881,		0x21, 0
	.dw 0xba00, 0xc881,	0xbfff, 0xc881,		0x21, 0
	.dw 0xda00, 0xc881,	0xdfff, 0xc881,		0x21, 0
	.dw 0xfa00, 0xc881,	0xffff, 0xc881,		0x21, 0
	.dw 0x1a00, 0xc882,	0x1fff, 0xc882,		0x21, 0
	.dw 0x3a00, 0xc882,	0x3fff, 0xc882,		0x21, 0
	.dw 0x5a00, 0xc882,	0x5fff, 0xc882,		0x21, 0
	.dw 0x7a00, 0xc882,	0x7fff, 0xc882,		0x21, 0
	.dw 0x9a00, 0xc882,	0x9fff, 0xc882,		0x21, 0
	.dw 0xba00, 0xc882,	0xbfff, 0xc882,		0x21, 0
	.dw 0xda00, 0xc882,	0xdfff, 0xc882,		0x21, 0
	.dw 0xfa00, 0xc882,	0xffff, 0xc882,		0x21, 0
	.dw 0x1a00, 0xc883,	0x1fff, 0xc883,		0x21, 0
	.dw 0x3a00, 0xc883,	0xffff, 0xc883,		0x21, 0
	.dw 0x1a00, 0xc884,	0x1fff, 0xc884,		0x21, 0
	.dw 0x3a00, 0xc884,	0x3fff, 0xc884,		0x21, 0
	.dw 0x5a00, 0xc884,	0x5fff, 0xc884,		0x21, 0
	.dw 0x7a00, 0xc884,	0x7fff, 0xc884,		0x21, 0
	.dw 0x9a00, 0xc884,	0x9fff, 0xc884,		0x21, 0
	.dw 0xba00, 0xc884,	0xbfff, 0xc884,		0x21, 0
	.dw 0xda00, 0xc884,	0xdfff, 0xc884,		0x21, 0
	.dw 0xfa00, 0xc884,	0xffff, 0xc884,		0x21, 0
	.dw 0x1a00, 0xc885,	0x1fff, 0xc885,		0x21, 0
	.dw 0x3a00, 0xc885,	0x3fff, 0xc885,		0x21, 0
	.dw 0x5a00, 0xc885,	0x5fff, 0xc885,		0x21, 0
	.dw 0x7a00, 0xc885,	0x7fff, 0xc885,		0x21, 0
	.dw 0x9a00, 0xc885,	0x9fff, 0xc885,		0x21, 0
	.dw 0xba00, 0xc885,	0xbfff, 0xc885,		0x21, 0
	.dw 0xda00, 0xc885,	0xdfff, 0xc885,		0x21, 0
	.dw 0xfa00, 0xc885,	0xffff, 0xc885,		0x21, 0
	.dw 0x1a00, 0xc886,	0x1fff, 0xc886,		0x21, 0
	.dw 0x3a00, 0xc886,	0x3fff, 0xc886,		0x21, 0
	.dw 0x5a00, 0xc886,	0x5fff, 0xc886,		0x21, 0
	.dw 0x7a00, 0xc886,	0x7fff, 0xc886,		0x21, 0
	.dw 0x9a00, 0xc886,	0x9fff, 0xc886,		0x21, 0
	.dw 0xba00, 0xc886,	0xbfff, 0xc886,		0x21, 0
	.dw 0xda00, 0xc886,	0xdfff, 0xc886,		0x21, 0
	.dw 0xfa00, 0xc886,	0xffff, 0xc886,		0x21, 0
	.dw 0x1a00, 0xc887,	0x1fff, 0xc887,		0x21, 0
	.dw 0x3a00, 0xc887,	0x1fff, 0xc888,		0x21, 0
	.dw 0x2040, 0xc888,	0x207f, 0xc888,		0x21, 0
	.dw 0x20c0, 0xc888,	0x20ff, 0xc888,		0x21, 0
	.dw 0x2140, 0xc888,	0x217f, 0xc888,		0x21, 0
	.dw 0x21c0, 0xc888,	0x21ff, 0xc888,		0x21, 0
	.dw 0x2240, 0xc888,	0x227f, 0xc888,		0x21, 0
	.dw 0x22c0, 0xc888,	0x22ff, 0xc888,		0x21, 0
	.dw 0x2340, 0xc888,	0x237f, 0xc888,		0x21, 0
	.dw 0x23c0, 0xc888,	0x23ff, 0xc888,		0x21, 0
	.dw 0x2440, 0xc888,	0x247f, 0xc888,		0x21, 0
	.dw 0x24c0, 0xc888,	0x24ff, 0xc888,		0x21, 0
	.dw 0x2540, 0xc888,	0x257f, 0xc888,		0x21, 0
	.dw 0x25c0, 0xc888,	0x25ff, 0xc888,		0x21, 0
	.dw 0x2640, 0xc888,	0x267f, 0xc888,		0x21, 0
	.dw 0x26c0, 0xc888,	0x26ff, 0xc888,		0x21, 0
	.dw 0x2740, 0xc888,	0x277f, 0xc888,		0x21, 0
	.dw 0x27c0, 0xc888,	0x27ff, 0xc888,		0x21, 0
	.dw 0x2840, 0xc888,	0x287f, 0xc888,		0x21, 0
	.dw 0x28c0, 0xc888,	0x28ff, 0xc888,		0x21, 0
	.dw 0x2940, 0xc888,	0x297f, 0xc888,		0x21, 0
	.dw 0x29c0, 0xc888,	0x29ff, 0xc888,		0x21, 0
	.dw 0x2a40, 0xc888,	0x2a7f, 0xc888,		0x21, 0
	.dw 0x2ac0, 0xc888,	0x2aff, 0xc888,		0x21, 0
	.dw 0x2b40, 0xc888,	0x2b7f, 0xc888,		0x21, 0
	.dw 0x2bc0, 0xc888,	0x2bff, 0xc888,		0x21, 0
	.dw 0x2c40, 0xc888,	0x2c7f, 0xc888,		0x21, 0
	.dw 0x2cc0, 0xc888,	0x2cff, 0xc888,		0x21, 0
	.dw 0x2d40, 0xc888,	0x2d7f, 0xc888,		0x21, 0
	.dw 0x2dc0, 0xc888,	0x2dff, 0xc888,		0x21, 0
	.dw 0x2e40, 0xc888,	0x2e7f, 0xc888,		0x21, 0
	.dw 0x2ec0, 0xc888,	0x2eff, 0xc888,		0x21, 0
	.dw 0x2f40, 0xc888,	0x2f7f, 0xc888,		0x21, 0
	.dw 0x2fc0, 0xc888,	0x2fff, 0xc888,		0x21, 0
	.dw 0x3040, 0xc888,	0x307f, 0xc888,		0x21, 0
	.dw 0x30c0, 0xc888,	0x30ff, 0xc888,		0x21, 0
	.dw 0x3140, 0xc888,	0x317f, 0xc888,		0x21, 0
	.dw 0x31c0, 0xc888,	0x31ff, 0xc888,		0x21, 0
	.dw 0x3240, 0xc888,	0x327f, 0xc888,		0x21, 0
	.dw 0x32c0, 0xc888,	0x32ff, 0xc888,		0x21, 0
	.dw 0x3340, 0xc888,	0x337f, 0xc888,		0x21, 0
	.dw 0x33c0, 0xc888,	0x33ff, 0xc888,		0x21, 0
	.dw 0x3440, 0xc888,	0x347f, 0xc888,		0x21, 0
	.dw 0x34c0, 0xc888,	0x34ff, 0xc888,		0x21, 0
	.dw 0x3540, 0xc888,	0x357f, 0xc888,		0x21, 0
	.dw 0x35c0, 0xc888,	0x35ff, 0xc888,		0x21, 0
	.dw 0x3640, 0xc888,	0x367f, 0xc888,		0x21, 0
	.dw 0x36c0, 0xc888,	0x36ff, 0xc888,		0x21, 0
	.dw 0x3740, 0xc888,	0x377f, 0xc888,		0x21, 0
	.dw 0x37c0, 0xc888,	0x37ff, 0xc888,		0x21, 0
	.dw 0x3840, 0xc888,	0x387f, 0xc888,		0x21, 0
	.dw 0x38c0, 0xc888,	0x38ff, 0xc888,		0x21, 0
	.dw 0x3940, 0xc888,	0x397f, 0xc888,		0x21, 0
	.dw 0x39c0, 0xc888,	0x5fff, 0xc888,		0x21, 0
	.dw 0x6040, 0xc888,	0x607f, 0xc888,		0x21, 0
	.dw 0x60c0, 0xc888,	0x60ff, 0xc888,		0x21, 0
	.dw 0x6140, 0xc888,	0x617f, 0xc888,		0x21, 0
	.dw 0x61c0, 0xc888,	0x61ff, 0xc888,		0x21, 0
	.dw 0x6240, 0xc888,	0x627f, 0xc888,		0x21, 0
	.dw 0x62c0, 0xc888,	0x62ff, 0xc888,		0x21, 0
	.dw 0x6340, 0xc888,	0x637f, 0xc888,		0x21, 0
	.dw 0x63c0, 0xc888,	0x63ff, 0xc888,		0x21, 0
	.dw 0x6440, 0xc888,	0x647f, 0xc888,		0x21, 0
	.dw 0x64c0, 0xc888,	0x64ff, 0xc888,		0x21, 0
	.dw 0x6540, 0xc888,	0x657f, 0xc888,		0x21, 0
	.dw 0x65c0, 0xc888,	0x65ff, 0xc888,		0x21, 0
	.dw 0x6640, 0xc888,	0x667f, 0xc888,		0x21, 0
	.dw 0x66c0, 0xc888,	0x66ff, 0xc888,		0x21, 0
	.dw 0x6740, 0xc888,	0x677f, 0xc888,		0x21, 0
	.dw 0x67c0, 0xc888,	0x67ff, 0xc888,		0x21, 0
	.dw 0x6840, 0xc888,	0x687f, 0xc888,		0x21, 0
	.dw 0x68c0, 0xc888,	0x68ff, 0xc888,		0x21, 0
	.dw 0x6940, 0xc888,	0x697f, 0xc888,		0x21, 0
	.dw 0x69c0, 0xc888,	0x69ff, 0xc888,		0x21, 0
	.dw 0x6a40, 0xc888,	0x6a7f, 0xc888,		0x21, 0
	.dw 0x6ac0, 0xc888,	0x6aff, 0xc888,		0x21, 0
	.dw 0x6b40, 0xc888,	0x6b7f, 0xc888,		0x21, 0
	.dw 0x6bc0, 0xc888,	0x6bff, 0xc888,		0x21, 0
	.dw 0x6c40, 0xc888,	0x6c7f, 0xc888,		0x21, 0
	.dw 0x6cc0, 0xc888,	0x6cff, 0xc888,		0x21, 0
	.dw 0x6d40, 0xc888,	0x6d7f, 0xc888,		0x21, 0
	.dw 0x6dc0, 0xc888,	0x6dff, 0xc888,		0x21, 0
	.dw 0x6e40, 0xc888,	0x6e7f, 0xc888,		0x21, 0
	.dw 0x6ec0, 0xc888,	0x6eff, 0xc888,		0x21, 0
	.dw 0x6f40, 0xc888,	0x6f7f, 0xc888,		0x21, 0
	.dw 0x6fc0, 0xc888,	0x6fff, 0xc888,		0x21, 0
	.dw 0x7040, 0xc888,	0x707f, 0xc888,		0x21, 0
	.dw 0x70c0, 0xc888,	0x70ff, 0xc888,		0x21, 0
	.dw 0x7140, 0xc888,	0x717f, 0xc888,		0x21, 0
	.dw 0x71c0, 0xc888,	0x71ff, 0xc888,		0x21, 0
	.dw 0x7240, 0xc888,	0x727f, 0xc888,		0x21, 0
	.dw 0x72c0, 0xc888,	0x72ff, 0xc888,		0x21, 0
	.dw 0x7340, 0xc888,	0x737f, 0xc888,		0x21, 0
	.dw 0x73c0, 0xc888,	0x73ff, 0xc888,		0x21, 0
	.dw 0x7440, 0xc888,	0x747f, 0xc888,		0x21, 0
	.dw 0x74c0, 0xc888,	0x74ff, 0xc888,		0x21, 0
	.dw 0x7540, 0xc888,	0x757f, 0xc888,		0x21, 0
	.dw 0x75c0, 0xc888,	0x75ff, 0xc888,		0x21, 0
	.dw 0x7640, 0xc888,	0x767f, 0xc888,		0x21, 0
	.dw 0x76c0, 0xc888,	0x76ff, 0xc888,		0x21, 0
	.dw 0x7740, 0xc888,	0x777f, 0xc888,		0x21, 0
	.dw 0x77c0, 0xc888,	0x77ff, 0xc888,		0x21, 0
	.dw 0x7840, 0xc888,	0x787f, 0xc888,		0x21, 0
	.dw 0x78c0, 0xc888,	0x78ff, 0xc888,		0x21, 0
	.dw 0x7940, 0xc888,	0x797f, 0xc888,		0x21, 0
	.dw 0x79c0, 0xc888,	0x9fff, 0xc888,		0x21, 0
	.dw 0xa040, 0xc888,	0xa07f, 0xc888,		0x21, 0
	.dw 0xa0c0, 0xc888,	0xa0ff, 0xc888,		0x21, 0
	.dw 0xa140, 0xc888,	0xa17f, 0xc888,		0x21, 0
	.dw 0xa1c0, 0xc888,	0xa1ff, 0xc888,		0x21, 0
	.dw 0xa240, 0xc888,	0xa27f, 0xc888,		0x21, 0
	.dw 0xa2c0, 0xc888,	0xa2ff, 0xc888,		0x21, 0
	.dw 0xa340, 0xc888,	0xa37f, 0xc888,		0x21, 0
	.dw 0xa3c0, 0xc888,	0xa3ff, 0xc888,		0x21, 0
	.dw 0xa440, 0xc888,	0xa47f, 0xc888,		0x21, 0
	.dw 0xa4c0, 0xc888,	0xa4ff, 0xc888,		0x21, 0
	.dw 0xa540, 0xc888,	0xa57f, 0xc888,		0x21, 0
	.dw 0xa5c0, 0xc888,	0xa5ff, 0xc888,		0x21, 0
	.dw 0xa640, 0xc888,	0xa67f, 0xc888,		0x21, 0
	.dw 0xa6c0, 0xc888,	0xa6ff, 0xc888,		0x21, 0
	.dw 0xa740, 0xc888,	0xa77f, 0xc888,		0x21, 0
	.dw 0xa7c0, 0xc888,	0xa7ff, 0xc888,		0x21, 0
	.dw 0xa840, 0xc888,	0xa87f, 0xc888,		0x21, 0
	.dw 0xa8c0, 0xc888,	0xa8ff, 0xc888,		0x21, 0
	.dw 0xa940, 0xc888,	0xa97f, 0xc888,		0x21, 0
	.dw 0xa9c0, 0xc888,	0xa9ff, 0xc888,		0x21, 0
	.dw 0xaa40, 0xc888,	0xaa7f, 0xc888,		0x21, 0
	.dw 0xaac0, 0xc888,	0xaaff, 0xc888,		0x21, 0
	.dw 0xab40, 0xc888,	0xab7f, 0xc888,		0x21, 0
	.dw 0xabc0, 0xc888,	0xabff, 0xc888,		0x21, 0
	.dw 0xac40, 0xc888,	0xac7f, 0xc888,		0x21, 0
	.dw 0xacc0, 0xc888,	0xacff, 0xc888,		0x21, 0
	.dw 0xad40, 0xc888,	0xad7f, 0xc888,		0x21, 0
	.dw 0xadc0, 0xc888,	0xadff, 0xc888,		0x21, 0
	.dw 0xae40, 0xc888,	0xae7f, 0xc888,		0x21, 0
	.dw 0xaec0, 0xc888,	0xaeff, 0xc888,		0x21, 0
	.dw 0xaf40, 0xc888,	0xaf7f, 0xc888,		0x21, 0
	.dw 0xafc0, 0xc888,	0xafff, 0xc888,		0x21, 0
	.dw 0xb040, 0xc888,	0xb07f, 0xc888,		0x21, 0
	.dw 0xb0c0, 0xc888,	0xb0ff, 0xc888,		0x21, 0
	.dw 0xb140, 0xc888,	0xb17f, 0xc888,		0x21, 0
	.dw 0xb1c0, 0xc888,	0xb1ff, 0xc888,		0x21, 0
	.dw 0xb240, 0xc888,	0xb27f, 0xc888,		0x21, 0
	.dw 0xb2c0, 0xc888,	0xb2ff, 0xc888,		0x21, 0
	.dw 0xb340, 0xc888,	0xb37f, 0xc888,		0x21, 0
	.dw 0xb3c0, 0xc888,	0xb3ff, 0xc888,		0x21, 0
	.dw 0xb440, 0xc888,	0xb47f, 0xc888,		0x21, 0
	.dw 0xb4c0, 0xc888,	0xb4ff, 0xc888,		0x21, 0
	.dw 0xb540, 0xc888,	0xb57f, 0xc888,		0x21, 0
	.dw 0xb5c0, 0xc888,	0xb5ff, 0xc888,		0x21, 0
	.dw 0xb640, 0xc888,	0xb67f, 0xc888,		0x21, 0
	.dw 0xb6c0, 0xc888,	0xb6ff, 0xc888,		0x21, 0
	.dw 0xb740, 0xc888,	0xb77f, 0xc888,		0x21, 0
	.dw 0xb7c0, 0xc888,	0xb7ff, 0xc888,		0x21, 0
	.dw 0xb840, 0xc888,	0xb87f, 0xc888,		0x21, 0
	.dw 0xb8c0, 0xc888,	0xb8ff, 0xc888,		0x21, 0
	.dw 0xb940, 0xc888,	0xb97f, 0xc888,		0x21, 0
	.dw 0xb9c0, 0xc888,	0xdfff, 0xc888,		0x21, 0
	.dw 0xe040, 0xc888,	0xe07f, 0xc888,		0x21, 0
	.dw 0xe0c0, 0xc888,	0xe0ff, 0xc888,		0x21, 0
	.dw 0xe140, 0xc888,	0xe17f, 0xc888,		0x21, 0
	.dw 0xe1c0, 0xc888,	0xe1ff, 0xc888,		0x21, 0
	.dw 0xe240, 0xc888,	0xe27f, 0xc888,		0x21, 0
	.dw 0xe2c0, 0xc888,	0xe2ff, 0xc888,		0x21, 0
	.dw 0xe340, 0xc888,	0xe37f, 0xc888,		0x21, 0
	.dw 0xe3c0, 0xc888,	0xe3ff, 0xc888,		0x21, 0
	.dw 0xe440, 0xc888,	0xe47f, 0xc888,		0x21, 0
	.dw 0xe4c0, 0xc888,	0xe4ff, 0xc888,		0x21, 0
	.dw 0xe540, 0xc888,	0xe57f, 0xc888,		0x21, 0
	.dw 0xe5c0, 0xc888,	0xe5ff, 0xc888,		0x21, 0
	.dw 0xe640, 0xc888,	0xe67f, 0xc888,		0x21, 0
	.dw 0xe6c0, 0xc888,	0xe6ff, 0xc888,		0x21, 0
	.dw 0xe740, 0xc888,	0xe77f, 0xc888,		0x21, 0
	.dw 0xe7c0, 0xc888,	0xe7ff, 0xc888,		0x21, 0
	.dw 0xe840, 0xc888,	0xe87f, 0xc888,		0x21, 0
	.dw 0xe8c0, 0xc888,	0xe8ff, 0xc888,		0x21, 0
	.dw 0xe940, 0xc888,	0xe97f, 0xc888,		0x21, 0
	.dw 0xe9c0, 0xc888,	0xe9ff, 0xc888,		0x21, 0
	.dw 0xea40, 0xc888,	0xea7f, 0xc888,		0x21, 0
	.dw 0xeac0, 0xc888,	0xeaff, 0xc888,		0x21, 0
	.dw 0xeb40, 0xc888,	0xeb7f, 0xc888,		0x21, 0
	.dw 0xebc0, 0xc888,	0xebff, 0xc888,		0x21, 0
	.dw 0xec40, 0xc888,	0xec7f, 0xc888,		0x21, 0
	.dw 0xecc0, 0xc888,	0xecff, 0xc888,		0x21, 0
	.dw 0xed40, 0xc888,	0xed7f, 0xc888,		0x21, 0
	.dw 0xedc0, 0xc888,	0xedff, 0xc888,		0x21, 0
	.dw 0xee40, 0xc888,	0xee7f, 0xc888,		0x21, 0
	.dw 0xeec0, 0xc888,	0xeeff, 0xc888,		0x21, 0
	.dw 0xef40, 0xc888,	0xef7f, 0xc888,		0x21, 0
	.dw 0xefc0, 0xc888,	0xefff, 0xc888,		0x21, 0
	.dw 0xf040, 0xc888,	0xf07f, 0xc888,		0x21, 0
	.dw 0xf0c0, 0xc888,	0xf0ff, 0xc888,		0x21, 0
	.dw 0xf140, 0xc888,	0xf17f, 0xc888,		0x21, 0
	.dw 0xf1c0, 0xc888,	0xf1ff, 0xc888,		0x21, 0
	.dw 0xf240, 0xc888,	0xf27f, 0xc888,		0x21, 0
	.dw 0xf2c0, 0xc888,	0xf2ff, 0xc888,		0x21, 0
	.dw 0xf340, 0xc888,	0xf37f, 0xc888,		0x21, 0
	.dw 0xf3c0, 0xc888,	0xf3ff, 0xc888,		0x21, 0
	.dw 0xf440, 0xc888,	0xf47f, 0xc888,		0x21, 0
	.dw 0xf4c0, 0xc888,	0xf4ff, 0xc888,		0x21, 0
	.dw 0xf540, 0xc888,	0xf57f, 0xc888,		0x21, 0
	.dw 0xf5c0, 0xc888,	0xf5ff, 0xc888,		0x21, 0
	.dw 0xf640, 0xc888,	0xf67f, 0xc888,		0x21, 0
	.dw 0xf6c0, 0xc888,	0xf6ff, 0xc888,		0x21, 0
	.dw 0xf740, 0xc888,	0xf77f, 0xc888,		0x21, 0
	.dw 0xf7c0, 0xc888,	0xf7ff, 0xc888,		0x21, 0
	.dw 0xf840, 0xc888,	0xf87f, 0xc888,		0x21, 0
	.dw 0xf8c0, 0xc888,	0xf8ff, 0xc888,		0x21, 0
	.dw 0xf940, 0xc888,	0xf97f, 0xc888,		0x21, 0
	.dw 0xf9c0, 0xc888,	0x1fff, 0xc889,		0x21, 0
	.dw 0x2040, 0xc889,	0x207f, 0xc889,		0x21, 0
	.dw 0x20c0, 0xc889,	0x20ff, 0xc889,		0x21, 0
	.dw 0x2140, 0xc889,	0x217f, 0xc889,		0x21, 0
	.dw 0x21c0, 0xc889,	0x21ff, 0xc889,		0x21, 0
	.dw 0x2240, 0xc889,	0x227f, 0xc889,		0x21, 0
	.dw 0x22c0, 0xc889,	0x22ff, 0xc889,		0x21, 0
	.dw 0x2340, 0xc889,	0x237f, 0xc889,		0x21, 0
	.dw 0x23c0, 0xc889,	0x23ff, 0xc889,		0x21, 0
	.dw 0x2440, 0xc889,	0x247f, 0xc889,		0x21, 0
	.dw 0x24c0, 0xc889,	0x24ff, 0xc889,		0x21, 0
	.dw 0x2540, 0xc889,	0x257f, 0xc889,		0x21, 0
	.dw 0x25c0, 0xc889,	0x25ff, 0xc889,		0x21, 0
	.dw 0x2640, 0xc889,	0x267f, 0xc889,		0x21, 0
	.dw 0x26c0, 0xc889,	0x26ff, 0xc889,		0x21, 0
	.dw 0x2740, 0xc889,	0x277f, 0xc889,		0x21, 0
	.dw 0x27c0, 0xc889,	0x27ff, 0xc889,		0x21, 0
	.dw 0x2840, 0xc889,	0x287f, 0xc889,		0x21, 0
	.dw 0x28c0, 0xc889,	0x28ff, 0xc889,		0x21, 0
	.dw 0x2940, 0xc889,	0x297f, 0xc889,		0x21, 0
	.dw 0x29c0, 0xc889,	0x29ff, 0xc889,		0x21, 0
	.dw 0x2a40, 0xc889,	0x2a7f, 0xc889,		0x21, 0
	.dw 0x2ac0, 0xc889,	0x2aff, 0xc889,		0x21, 0
	.dw 0x2b40, 0xc889,	0x2b7f, 0xc889,		0x21, 0
	.dw 0x2bc0, 0xc889,	0x2bff, 0xc889,		0x21, 0
	.dw 0x2c40, 0xc889,	0x2c7f, 0xc889,		0x21, 0
	.dw 0x2cc0, 0xc889,	0x2cff, 0xc889,		0x21, 0
	.dw 0x2d40, 0xc889,	0x2d7f, 0xc889,		0x21, 0
	.dw 0x2dc0, 0xc889,	0x2dff, 0xc889,		0x21, 0
	.dw 0x2e40, 0xc889,	0x2e7f, 0xc889,		0x21, 0
	.dw 0x2ec0, 0xc889,	0x2eff, 0xc889,		0x21, 0
	.dw 0x2f40, 0xc889,	0x2f7f, 0xc889,		0x21, 0
	.dw 0x2fc0, 0xc889,	0x2fff, 0xc889,		0x21, 0
	.dw 0x3040, 0xc889,	0x307f, 0xc889,		0x21, 0
	.dw 0x30c0, 0xc889,	0x30ff, 0xc889,		0x21, 0
	.dw 0x3140, 0xc889,	0x317f, 0xc889,		0x21, 0
	.dw 0x31c0, 0xc889,	0x31ff, 0xc889,		0x21, 0
	.dw 0x3240, 0xc889,	0x327f, 0xc889,		0x21, 0
	.dw 0x32c0, 0xc889,	0x32ff, 0xc889,		0x21, 0
	.dw 0x3340, 0xc889,	0x337f, 0xc889,		0x21, 0
	.dw 0x33c0, 0xc889,	0x33ff, 0xc889,		0x21, 0
	.dw 0x3440, 0xc889,	0x347f, 0xc889,		0x21, 0
	.dw 0x34c0, 0xc889,	0x34ff, 0xc889,		0x21, 0
	.dw 0x3540, 0xc889,	0x357f, 0xc889,		0x21, 0
	.dw 0x35c0, 0xc889,	0x35ff, 0xc889,		0x21, 0
	.dw 0x3640, 0xc889,	0x367f, 0xc889,		0x21, 0
	.dw 0x36c0, 0xc889,	0x36ff, 0xc889,		0x21, 0
	.dw 0x3740, 0xc889,	0x377f, 0xc889,		0x21, 0
	.dw 0x37c0, 0xc889,	0x37ff, 0xc889,		0x21, 0
	.dw 0x3840, 0xc889,	0x387f, 0xc889,		0x21, 0
	.dw 0x38c0, 0xc889,	0x38ff, 0xc889,		0x21, 0
	.dw 0x3940, 0xc889,	0x397f, 0xc889,		0x21, 0
	.dw 0x39c0, 0xc889,	0x5fff, 0xc889,		0x21, 0
	.dw 0x6040, 0xc889,	0x607f, 0xc889,		0x21, 0
	.dw 0x60c0, 0xc889,	0x60ff, 0xc889,		0x21, 0
	.dw 0x6140, 0xc889,	0x617f, 0xc889,		0x21, 0
	.dw 0x61c0, 0xc889,	0x61ff, 0xc889,		0x21, 0
	.dw 0x6240, 0xc889,	0x627f, 0xc889,		0x21, 0
	.dw 0x62c0, 0xc889,	0x62ff, 0xc889,		0x21, 0
	.dw 0x6340, 0xc889,	0x637f, 0xc889,		0x21, 0
	.dw 0x63c0, 0xc889,	0x63ff, 0xc889,		0x21, 0
	.dw 0x6440, 0xc889,	0x647f, 0xc889,		0x21, 0
	.dw 0x64c0, 0xc889,	0x64ff, 0xc889,		0x21, 0
	.dw 0x6540, 0xc889,	0x657f, 0xc889,		0x21, 0
	.dw 0x65c0, 0xc889,	0x65ff, 0xc889,		0x21, 0
	.dw 0x6640, 0xc889,	0x667f, 0xc889,		0x21, 0
	.dw 0x66c0, 0xc889,	0x66ff, 0xc889,		0x21, 0
	.dw 0x6740, 0xc889,	0x677f, 0xc889,		0x21, 0
	.dw 0x67c0, 0xc889,	0x67ff, 0xc889,		0x21, 0
	.dw 0x6840, 0xc889,	0x687f, 0xc889,		0x21, 0
	.dw 0x68c0, 0xc889,	0x68ff, 0xc889,		0x21, 0
	.dw 0x6940, 0xc889,	0x697f, 0xc889,		0x21, 0
	.dw 0x69c0, 0xc889,	0x69ff, 0xc889,		0x21, 0
	.dw 0x6a40, 0xc889,	0x6a7f, 0xc889,		0x21, 0
	.dw 0x6ac0, 0xc889,	0x6aff, 0xc889,		0x21, 0
	.dw 0x6b40, 0xc889,	0x6b7f, 0xc889,		0x21, 0
	.dw 0x6bc0, 0xc889,	0x6bff, 0xc889,		0x21, 0
	.dw 0x6c40, 0xc889,	0x6c7f, 0xc889,		0x21, 0
	.dw 0x6cc0, 0xc889,	0x6cff, 0xc889,		0x21, 0
	.dw 0x6d40, 0xc889,	0x6d7f, 0xc889,		0x21, 0
	.dw 0x6dc0, 0xc889,	0x6dff, 0xc889,		0x21, 0
	.dw 0x6e40, 0xc889,	0x6e7f, 0xc889,		0x21, 0
	.dw 0x6ec0, 0xc889,	0x6eff, 0xc889,		0x21, 0
	.dw 0x6f40, 0xc889,	0x6f7f, 0xc889,		0x21, 0
	.dw 0x6fc0, 0xc889,	0x6fff, 0xc889,		0x21, 0
	.dw 0x7040, 0xc889,	0x707f, 0xc889,		0x21, 0
	.dw 0x70c0, 0xc889,	0x70ff, 0xc889,		0x21, 0
	.dw 0x7140, 0xc889,	0x717f, 0xc889,		0x21, 0
	.dw 0x71c0, 0xc889,	0x71ff, 0xc889,		0x21, 0
	.dw 0x7240, 0xc889,	0x727f, 0xc889,		0x21, 0
	.dw 0x72c0, 0xc889,	0x72ff, 0xc889,		0x21, 0
	.dw 0x7340, 0xc889,	0x737f, 0xc889,		0x21, 0
	.dw 0x73c0, 0xc889,	0x73ff, 0xc889,		0x21, 0
	.dw 0x7440, 0xc889,	0x747f, 0xc889,		0x21, 0
	.dw 0x74c0, 0xc889,	0x74ff, 0xc889,		0x21, 0
	.dw 0x7540, 0xc889,	0x757f, 0xc889,		0x21, 0
	.dw 0x75c0, 0xc889,	0x75ff, 0xc889,		0x21, 0
	.dw 0x7640, 0xc889,	0x767f, 0xc889,		0x21, 0
	.dw 0x76c0, 0xc889,	0x76ff, 0xc889,		0x21, 0
	.dw 0x7740, 0xc889,	0x777f, 0xc889,		0x21, 0
	.dw 0x77c0, 0xc889,	0x77ff, 0xc889,		0x21, 0
	.dw 0x7840, 0xc889,	0x787f, 0xc889,		0x21, 0
	.dw 0x78c0, 0xc889,	0x78ff, 0xc889,		0x21, 0
	.dw 0x7940, 0xc889,	0x797f, 0xc889,		0x21, 0
	.dw 0x79c0, 0xc889,	0x9fff, 0xc889,		0x21, 0
	.dw 0xa040, 0xc889,	0xa07f, 0xc889,		0x21, 0
	.dw 0xa0c0, 0xc889,	0xa0ff, 0xc889,		0x21, 0
	.dw 0xa140, 0xc889,	0xa17f, 0xc889,		0x21, 0
	.dw 0xa1c0, 0xc889,	0xa1ff, 0xc889,		0x21, 0
	.dw 0xa240, 0xc889,	0xa27f, 0xc889,		0x21, 0
	.dw 0xa2c0, 0xc889,	0xa2ff, 0xc889,		0x21, 0
	.dw 0xa340, 0xc889,	0xa37f, 0xc889,		0x21, 0
	.dw 0xa3c0, 0xc889,	0xa3ff, 0xc889,		0x21, 0
	.dw 0xa440, 0xc889,	0xa47f, 0xc889,		0x21, 0
	.dw 0xa4c0, 0xc889,	0xa4ff, 0xc889,		0x21, 0
	.dw 0xa540, 0xc889,	0xa57f, 0xc889,		0x21, 0
	.dw 0xa5c0, 0xc889,	0xa5ff, 0xc889,		0x21, 0
	.dw 0xa640, 0xc889,	0xa67f, 0xc889,		0x21, 0
	.dw 0xa6c0, 0xc889,	0xa6ff, 0xc889,		0x21, 0
	.dw 0xa740, 0xc889,	0xa77f, 0xc889,		0x21, 0
	.dw 0xa7c0, 0xc889,	0xa7ff, 0xc889,		0x21, 0
	.dw 0xa840, 0xc889,	0xa87f, 0xc889,		0x21, 0
	.dw 0xa8c0, 0xc889,	0xa8ff, 0xc889,		0x21, 0
	.dw 0xa940, 0xc889,	0xa97f, 0xc889,		0x21, 0
	.dw 0xa9c0, 0xc889,	0xa9ff, 0xc889,		0x21, 0
	.dw 0xaa40, 0xc889,	0xaa7f, 0xc889,		0x21, 0
	.dw 0xaac0, 0xc889,	0xaaff, 0xc889,		0x21, 0
	.dw 0xab40, 0xc889,	0xab7f, 0xc889,		0x21, 0
	.dw 0xabc0, 0xc889,	0xabff, 0xc889,		0x21, 0
	.dw 0xac40, 0xc889,	0xac7f, 0xc889,		0x21, 0
	.dw 0xacc0, 0xc889,	0xacff, 0xc889,		0x21, 0
	.dw 0xad40, 0xc889,	0xad7f, 0xc889,		0x21, 0
	.dw 0xadc0, 0xc889,	0xadff, 0xc889,		0x21, 0
	.dw 0xae40, 0xc889,	0xae7f, 0xc889,		0x21, 0
	.dw 0xaec0, 0xc889,	0xaeff, 0xc889,		0x21, 0
	.dw 0xaf40, 0xc889,	0xaf7f, 0xc889,		0x21, 0
	.dw 0xafc0, 0xc889,	0xafff, 0xc889,		0x21, 0
	.dw 0xb040, 0xc889,	0xb07f, 0xc889,		0x21, 0
	.dw 0xb0c0, 0xc889,	0xb0ff, 0xc889,		0x21, 0
	.dw 0xb140, 0xc889,	0xb17f, 0xc889,		0x21, 0
	.dw 0xb1c0, 0xc889,	0xb1ff, 0xc889,		0x21, 0
	.dw 0xb240, 0xc889,	0xb27f, 0xc889,		0x21, 0
	.dw 0xb2c0, 0xc889,	0xb2ff, 0xc889,		0x21, 0
	.dw 0xb340, 0xc889,	0xb37f, 0xc889,		0x21, 0
	.dw 0xb3c0, 0xc889,	0xb3ff, 0xc889,		0x21, 0
	.dw 0xb440, 0xc889,	0xb47f, 0xc889,		0x21, 0
	.dw 0xb4c0, 0xc889,	0xb4ff, 0xc889,		0x21, 0
	.dw 0xb540, 0xc889,	0xb57f, 0xc889,		0x21, 0
	.dw 0xb5c0, 0xc889,	0xb5ff, 0xc889,		0x21, 0
	.dw 0xb640, 0xc889,	0xb67f, 0xc889,		0x21, 0
	.dw 0xb6c0, 0xc889,	0xb6ff, 0xc889,		0x21, 0
	.dw 0xb740, 0xc889,	0xb77f, 0xc889,		0x21, 0
	.dw 0xb7c0, 0xc889,	0xb7ff, 0xc889,		0x21, 0
	.dw 0xb840, 0xc889,	0xb87f, 0xc889,		0x21, 0
	.dw 0xb8c0, 0xc889,	0xb8ff, 0xc889,		0x21, 0
	.dw 0xb940, 0xc889,	0xb97f, 0xc889,		0x21, 0
	.dw 0xb9c0, 0xc889,	0xdfff, 0xc889,		0x21, 0
	.dw 0xe040, 0xc889,	0xe07f, 0xc889,		0x21, 0
	.dw 0xe0c0, 0xc889,	0xe0ff, 0xc889,		0x21, 0
	.dw 0xe140, 0xc889,	0xe17f, 0xc889,		0x21, 0
	.dw 0xe1c0, 0xc889,	0xe1ff, 0xc889,		0x21, 0
	.dw 0xe240, 0xc889,	0xe27f, 0xc889,		0x21, 0
	.dw 0xe2c0, 0xc889,	0xe2ff, 0xc889,		0x21, 0
	.dw 0xe340, 0xc889,	0xe37f, 0xc889,		0x21, 0
	.dw 0xe3c0, 0xc889,	0xe3ff, 0xc889,		0x21, 0
	.dw 0xe440, 0xc889,	0xe47f, 0xc889,		0x21, 0
	.dw 0xe4c0, 0xc889,	0xe4ff, 0xc889,		0x21, 0
	.dw 0xe540, 0xc889,	0xe57f, 0xc889,		0x21, 0
	.dw 0xe5c0, 0xc889,	0xe5ff, 0xc889,		0x21, 0
	.dw 0xe640, 0xc889,	0xe67f, 0xc889,		0x21, 0
	.dw 0xe6c0, 0xc889,	0xe6ff, 0xc889,		0x21, 0
	.dw 0xe740, 0xc889,	0xe77f, 0xc889,		0x21, 0
	.dw 0xe7c0, 0xc889,	0xe7ff, 0xc889,		0x21, 0
	.dw 0xe840, 0xc889,	0xe87f, 0xc889,		0x21, 0
	.dw 0xe8c0, 0xc889,	0xe8ff, 0xc889,		0x21, 0
	.dw 0xe940, 0xc889,	0xe97f, 0xc889,		0x21, 0
	.dw 0xe9c0, 0xc889,	0xe9ff, 0xc889,		0x21, 0
	.dw 0xea40, 0xc889,	0xea7f, 0xc889,		0x21, 0
	.dw 0xeac0, 0xc889,	0xeaff, 0xc889,		0x21, 0
	.dw 0xeb40, 0xc889,	0xeb7f, 0xc889,		0x21, 0
	.dw 0xebc0, 0xc889,	0xebff, 0xc889,		0x21, 0
	.dw 0xec40, 0xc889,	0xec7f, 0xc889,		0x21, 0
	.dw 0xecc0, 0xc889,	0xecff, 0xc889,		0x21, 0
	.dw 0xed40, 0xc889,	0xed7f, 0xc889,		0x21, 0
	.dw 0xedc0, 0xc889,	0xedff, 0xc889,		0x21, 0
	.dw 0xee40, 0xc889,	0xee7f, 0xc889,		0x21, 0
	.dw 0xeec0, 0xc889,	0xeeff, 0xc889,		0x21, 0
	.dw 0xef40, 0xc889,	0xef7f, 0xc889,		0x21, 0
	.dw 0xefc0, 0xc889,	0xefff, 0xc889,		0x21, 0
	.dw 0xf040, 0xc889,	0xf07f, 0xc889,		0x21, 0
	.dw 0xf0c0, 0xc889,	0xf0ff, 0xc889,		0x21, 0
	.dw 0xf140, 0xc889,	0xf17f, 0xc889,		0x21, 0
	.dw 0xf1c0, 0xc889,	0xf1ff, 0xc889,		0x21, 0
	.dw 0xf240, 0xc889,	0xf27f, 0xc889,		0x21, 0
	.dw 0xf2c0, 0xc889,	0xf2ff, 0xc889,		0x21, 0
	.dw 0xf340, 0xc889,	0xf37f, 0xc889,		0x21, 0
	.dw 0xf3c0, 0xc889,	0xf3ff, 0xc889,		0x21, 0
	.dw 0xf440, 0xc889,	0xf47f, 0xc889,		0x21, 0
	.dw 0xf4c0, 0xc889,	0xf4ff, 0xc889,		0x21, 0
	.dw 0xf540, 0xc889,	0xf57f, 0xc889,		0x21, 0
	.dw 0xf5c0, 0xc889,	0xf5ff, 0xc889,		0x21, 0
	.dw 0xf640, 0xc889,	0xf67f, 0xc889,		0x21, 0
	.dw 0xf6c0, 0xc889,	0xf6ff, 0xc889,		0x21, 0
	.dw 0xf740, 0xc889,	0xf77f, 0xc889,		0x21, 0
	.dw 0xf7c0, 0xc889,	0xf7ff, 0xc889,		0x21, 0
	.dw 0xf840, 0xc889,	0xf87f, 0xc889,		0x21, 0
	.dw 0xf8c0, 0xc889,	0xf8ff, 0xc889,		0x21, 0
	.dw 0xf940, 0xc889,	0xf97f, 0xc889,		0x21, 0
	.dw 0xf9c0, 0xc889,	0x1fff, 0xc88a,		0x21, 0
	.dw 0x2040, 0xc88a,	0x207f, 0xc88a,		0x21, 0
	.dw 0x20c0, 0xc88a,	0x20ff, 0xc88a,		0x21, 0
	.dw 0x2140, 0xc88a,	0x217f, 0xc88a,		0x21, 0
	.dw 0x21c0, 0xc88a,	0x21ff, 0xc88a,		0x21, 0
	.dw 0x2240, 0xc88a,	0x227f, 0xc88a,		0x21, 0
	.dw 0x22c0, 0xc88a,	0x22ff, 0xc88a,		0x21, 0
	.dw 0x2340, 0xc88a,	0x237f, 0xc88a,		0x21, 0
	.dw 0x23c0, 0xc88a,	0x23ff, 0xc88a,		0x21, 0
	.dw 0x2440, 0xc88a,	0x247f, 0xc88a,		0x21, 0
	.dw 0x24c0, 0xc88a,	0x24ff, 0xc88a,		0x21, 0
	.dw 0x2540, 0xc88a,	0x257f, 0xc88a,		0x21, 0
	.dw 0x25c0, 0xc88a,	0x25ff, 0xc88a,		0x21, 0
	.dw 0x2640, 0xc88a,	0x267f, 0xc88a,		0x21, 0
	.dw 0x26c0, 0xc88a,	0x26ff, 0xc88a,		0x21, 0
	.dw 0x2740, 0xc88a,	0x277f, 0xc88a,		0x21, 0
	.dw 0x27c0, 0xc88a,	0x27ff, 0xc88a,		0x21, 0
	.dw 0x2840, 0xc88a,	0x287f, 0xc88a,		0x21, 0
	.dw 0x28c0, 0xc88a,	0x28ff, 0xc88a,		0x21, 0
	.dw 0x2940, 0xc88a,	0x297f, 0xc88a,		0x21, 0
	.dw 0x29c0, 0xc88a,	0x29ff, 0xc88a,		0x21, 0
	.dw 0x2a40, 0xc88a,	0x2a7f, 0xc88a,		0x21, 0
	.dw 0x2ac0, 0xc88a,	0x2aff, 0xc88a,		0x21, 0
	.dw 0x2b40, 0xc88a,	0x2b7f, 0xc88a,		0x21, 0
	.dw 0x2bc0, 0xc88a,	0x2bff, 0xc88a,		0x21, 0
	.dw 0x2c40, 0xc88a,	0x2c7f, 0xc88a,		0x21, 0
	.dw 0x2cc0, 0xc88a,	0x2cff, 0xc88a,		0x21, 0
	.dw 0x2d40, 0xc88a,	0x2d7f, 0xc88a,		0x21, 0
	.dw 0x2dc0, 0xc88a,	0x2dff, 0xc88a,		0x21, 0
	.dw 0x2e40, 0xc88a,	0x2e7f, 0xc88a,		0x21, 0
	.dw 0x2ec0, 0xc88a,	0x2eff, 0xc88a,		0x21, 0
	.dw 0x2f40, 0xc88a,	0x2f7f, 0xc88a,		0x21, 0
	.dw 0x2fc0, 0xc88a,	0x2fff, 0xc88a,		0x21, 0
	.dw 0x3040, 0xc88a,	0x307f, 0xc88a,		0x21, 0
	.dw 0x30c0, 0xc88a,	0x30ff, 0xc88a,		0x21, 0
	.dw 0x3140, 0xc88a,	0x317f, 0xc88a,		0x21, 0
	.dw 0x31c0, 0xc88a,	0x31ff, 0xc88a,		0x21, 0
	.dw 0x3240, 0xc88a,	0x327f, 0xc88a,		0x21, 0
	.dw 0x32c0, 0xc88a,	0x32ff, 0xc88a,		0x21, 0
	.dw 0x3340, 0xc88a,	0x337f, 0xc88a,		0x21, 0
	.dw 0x33c0, 0xc88a,	0x33ff, 0xc88a,		0x21, 0
	.dw 0x3440, 0xc88a,	0x347f, 0xc88a,		0x21, 0
	.dw 0x34c0, 0xc88a,	0x34ff, 0xc88a,		0x21, 0
	.dw 0x3540, 0xc88a,	0x357f, 0xc88a,		0x21, 0
	.dw 0x35c0, 0xc88a,	0x35ff, 0xc88a,		0x21, 0
	.dw 0x3640, 0xc88a,	0x367f, 0xc88a,		0x21, 0
	.dw 0x36c0, 0xc88a,	0x36ff, 0xc88a,		0x21, 0
	.dw 0x3740, 0xc88a,	0x377f, 0xc88a,		0x21, 0
	.dw 0x37c0, 0xc88a,	0x37ff, 0xc88a,		0x21, 0
	.dw 0x3840, 0xc88a,	0x387f, 0xc88a,		0x21, 0
	.dw 0x38c0, 0xc88a,	0x38ff, 0xc88a,		0x21, 0
	.dw 0x3940, 0xc88a,	0x397f, 0xc88a,		0x21, 0
	.dw 0x39c0, 0xc88a,	0x5fff, 0xc88a,		0x21, 0
	.dw 0x6040, 0xc88a,	0x607f, 0xc88a,		0x21, 0
	.dw 0x60c0, 0xc88a,	0x60ff, 0xc88a,		0x21, 0
	.dw 0x6140, 0xc88a,	0x617f, 0xc88a,		0x21, 0
	.dw 0x61c0, 0xc88a,	0x61ff, 0xc88a,		0x21, 0
	.dw 0x6240, 0xc88a,	0x627f, 0xc88a,		0x21, 0
	.dw 0x62c0, 0xc88a,	0x62ff, 0xc88a,		0x21, 0
	.dw 0x6340, 0xc88a,	0x637f, 0xc88a,		0x21, 0
	.dw 0x63c0, 0xc88a,	0x63ff, 0xc88a,		0x21, 0
	.dw 0x6440, 0xc88a,	0x647f, 0xc88a,		0x21, 0
	.dw 0x64c0, 0xc88a,	0x64ff, 0xc88a,		0x21, 0
	.dw 0x6540, 0xc88a,	0x657f, 0xc88a,		0x21, 0
	.dw 0x65c0, 0xc88a,	0x65ff, 0xc88a,		0x21, 0
	.dw 0x6640, 0xc88a,	0x667f, 0xc88a,		0x21, 0
	.dw 0x66c0, 0xc88a,	0x66ff, 0xc88a,		0x21, 0
	.dw 0x6740, 0xc88a,	0x677f, 0xc88a,		0x21, 0
	.dw 0x67c0, 0xc88a,	0x67ff, 0xc88a,		0x21, 0
	.dw 0x6840, 0xc88a,	0x687f, 0xc88a,		0x21, 0
	.dw 0x68c0, 0xc88a,	0x68ff, 0xc88a,		0x21, 0
	.dw 0x6940, 0xc88a,	0x697f, 0xc88a,		0x21, 0
	.dw 0x69c0, 0xc88a,	0x69ff, 0xc88a,		0x21, 0
	.dw 0x6a40, 0xc88a,	0x6a7f, 0xc88a,		0x21, 0
	.dw 0x6ac0, 0xc88a,	0x6aff, 0xc88a,		0x21, 0
	.dw 0x6b40, 0xc88a,	0x6b7f, 0xc88a,		0x21, 0
	.dw 0x6bc0, 0xc88a,	0x6bff, 0xc88a,		0x21, 0
	.dw 0x6c40, 0xc88a,	0x6c7f, 0xc88a,		0x21, 0
	.dw 0x6cc0, 0xc88a,	0x6cff, 0xc88a,		0x21, 0
	.dw 0x6d40, 0xc88a,	0x6d7f, 0xc88a,		0x21, 0
	.dw 0x6dc0, 0xc88a,	0x6dff, 0xc88a,		0x21, 0
	.dw 0x6e40, 0xc88a,	0x6e7f, 0xc88a,		0x21, 0
	.dw 0x6ec0, 0xc88a,	0x6eff, 0xc88a,		0x21, 0
	.dw 0x6f40, 0xc88a,	0x6f7f, 0xc88a,		0x21, 0
	.dw 0x6fc0, 0xc88a,	0x6fff, 0xc88a,		0x21, 0
	.dw 0x7040, 0xc88a,	0x707f, 0xc88a,		0x21, 0
	.dw 0x70c0, 0xc88a,	0x70ff, 0xc88a,		0x21, 0
	.dw 0x7140, 0xc88a,	0x717f, 0xc88a,		0x21, 0
	.dw 0x71c0, 0xc88a,	0x71ff, 0xc88a,		0x21, 0
	.dw 0x7240, 0xc88a,	0x727f, 0xc88a,		0x21, 0
	.dw 0x72c0, 0xc88a,	0x72ff, 0xc88a,		0x21, 0
	.dw 0x7340, 0xc88a,	0x737f, 0xc88a,		0x21, 0
	.dw 0x73c0, 0xc88a,	0x73ff, 0xc88a,		0x21, 0
	.dw 0x7440, 0xc88a,	0x747f, 0xc88a,		0x21, 0
	.dw 0x74c0, 0xc88a,	0x74ff, 0xc88a,		0x21, 0
	.dw 0x7540, 0xc88a,	0x757f, 0xc88a,		0x21, 0
	.dw 0x75c0, 0xc88a,	0x75ff, 0xc88a,		0x21, 0
	.dw 0x7640, 0xc88a,	0x767f, 0xc88a,		0x21, 0
	.dw 0x76c0, 0xc88a,	0x76ff, 0xc88a,		0x21, 0
	.dw 0x7740, 0xc88a,	0x777f, 0xc88a,		0x21, 0
	.dw 0x77c0, 0xc88a,	0x77ff, 0xc88a,		0x21, 0
	.dw 0x7840, 0xc88a,	0x787f, 0xc88a,		0x21, 0
	.dw 0x78c0, 0xc88a,	0x78ff, 0xc88a,		0x21, 0
	.dw 0x7940, 0xc88a,	0x797f, 0xc88a,		0x21, 0
	.dw 0x79c0, 0xc88a,	0x9fff, 0xc88a,		0x21, 0
	.dw 0xa040, 0xc88a,	0xa07f, 0xc88a,		0x21, 0
	.dw 0xa0c0, 0xc88a,	0xa0ff, 0xc88a,		0x21, 0
	.dw 0xa140, 0xc88a,	0xa17f, 0xc88a,		0x21, 0
	.dw 0xa1c0, 0xc88a,	0xa1ff, 0xc88a,		0x21, 0
	.dw 0xa240, 0xc88a,	0xa27f, 0xc88a,		0x21, 0
	.dw 0xa2c0, 0xc88a,	0xa2ff, 0xc88a,		0x21, 0
	.dw 0xa340, 0xc88a,	0xa37f, 0xc88a,		0x21, 0
	.dw 0xa3c0, 0xc88a,	0xa3ff, 0xc88a,		0x21, 0
	.dw 0xa440, 0xc88a,	0xa47f, 0xc88a,		0x21, 0
	.dw 0xa4c0, 0xc88a,	0xa4ff, 0xc88a,		0x21, 0
	.dw 0xa540, 0xc88a,	0xa57f, 0xc88a,		0x21, 0
	.dw 0xa5c0, 0xc88a,	0xa5ff, 0xc88a,		0x21, 0
	.dw 0xa640, 0xc88a,	0xa67f, 0xc88a,		0x21, 0
	.dw 0xa6c0, 0xc88a,	0xa6ff, 0xc88a,		0x21, 0
	.dw 0xa740, 0xc88a,	0xa77f, 0xc88a,		0x21, 0
	.dw 0xa7c0, 0xc88a,	0xa7ff, 0xc88a,		0x21, 0
	.dw 0xa840, 0xc88a,	0xa87f, 0xc88a,		0x21, 0
	.dw 0xa8c0, 0xc88a,	0xa8ff, 0xc88a,		0x21, 0
	.dw 0xa940, 0xc88a,	0xa97f, 0xc88a,		0x21, 0
	.dw 0xa9c0, 0xc88a,	0xa9ff, 0xc88a,		0x21, 0
	.dw 0xaa40, 0xc88a,	0xaa7f, 0xc88a,		0x21, 0
	.dw 0xaac0, 0xc88a,	0xaaff, 0xc88a,		0x21, 0
	.dw 0xab40, 0xc88a,	0xab7f, 0xc88a,		0x21, 0
	.dw 0xabc0, 0xc88a,	0xabff, 0xc88a,		0x21, 0
	.dw 0xac40, 0xc88a,	0xac7f, 0xc88a,		0x21, 0
	.dw 0xacc0, 0xc88a,	0xacff, 0xc88a,		0x21, 0
	.dw 0xad40, 0xc88a,	0xad7f, 0xc88a,		0x21, 0
	.dw 0xadc0, 0xc88a,	0xadff, 0xc88a,		0x21, 0
	.dw 0xae40, 0xc88a,	0xae7f, 0xc88a,		0x21, 0
	.dw 0xaec0, 0xc88a,	0xaeff, 0xc88a,		0x21, 0
	.dw 0xaf40, 0xc88a,	0xaf7f, 0xc88a,		0x21, 0
	.dw 0xafc0, 0xc88a,	0xafff, 0xc88a,		0x21, 0
	.dw 0xb040, 0xc88a,	0xb07f, 0xc88a,		0x21, 0
	.dw 0xb0c0, 0xc88a,	0xb0ff, 0xc88a,		0x21, 0
	.dw 0xb140, 0xc88a,	0xb17f, 0xc88a,		0x21, 0
	.dw 0xb1c0, 0xc88a,	0xb1ff, 0xc88a,		0x21, 0
	.dw 0xb240, 0xc88a,	0xb27f, 0xc88a,		0x21, 0
	.dw 0xb2c0, 0xc88a,	0xb2ff, 0xc88a,		0x21, 0
	.dw 0xb340, 0xc88a,	0xb37f, 0xc88a,		0x21, 0
	.dw 0xb3c0, 0xc88a,	0xb3ff, 0xc88a,		0x21, 0
	.dw 0xb440, 0xc88a,	0xb47f, 0xc88a,		0x21, 0
	.dw 0xb4c0, 0xc88a,	0xb4ff, 0xc88a,		0x21, 0
	.dw 0xb540, 0xc88a,	0xb57f, 0xc88a,		0x21, 0
	.dw 0xb5c0, 0xc88a,	0xb5ff, 0xc88a,		0x21, 0
	.dw 0xb640, 0xc88a,	0xb67f, 0xc88a,		0x21, 0
	.dw 0xb6c0, 0xc88a,	0xb6ff, 0xc88a,		0x21, 0
	.dw 0xb740, 0xc88a,	0xb77f, 0xc88a,		0x21, 0
	.dw 0xb7c0, 0xc88a,	0xb7ff, 0xc88a,		0x21, 0
	.dw 0xb840, 0xc88a,	0xb87f, 0xc88a,		0x21, 0
	.dw 0xb8c0, 0xc88a,	0xb8ff, 0xc88a,		0x21, 0
	.dw 0xb940, 0xc88a,	0xb97f, 0xc88a,		0x21, 0
	.dw 0xb9c0, 0xc88a,	0xdfff, 0xc88a,		0x21, 0
	.dw 0xe040, 0xc88a,	0xe07f, 0xc88a,		0x21, 0
	.dw 0xe0c0, 0xc88a,	0xe0ff, 0xc88a,		0x21, 0
	.dw 0xe140, 0xc88a,	0xe17f, 0xc88a,		0x21, 0
	.dw 0xe1c0, 0xc88a,	0xe1ff, 0xc88a,		0x21, 0
	.dw 0xe240, 0xc88a,	0xe27f, 0xc88a,		0x21, 0
	.dw 0xe2c0, 0xc88a,	0xe2ff, 0xc88a,		0x21, 0
	.dw 0xe340, 0xc88a,	0xe37f, 0xc88a,		0x21, 0
	.dw 0xe3c0, 0xc88a,	0xe3ff, 0xc88a,		0x21, 0
	.dw 0xe440, 0xc88a,	0xe47f, 0xc88a,		0x21, 0
	.dw 0xe4c0, 0xc88a,	0xe4ff, 0xc88a,		0x21, 0
	.dw 0xe540, 0xc88a,	0xe57f, 0xc88a,		0x21, 0
	.dw 0xe5c0, 0xc88a,	0xe5ff, 0xc88a,		0x21, 0
	.dw 0xe640, 0xc88a,	0xe67f, 0xc88a,		0x21, 0
	.dw 0xe6c0, 0xc88a,	0xe6ff, 0xc88a,		0x21, 0
	.dw 0xe740, 0xc88a,	0xe77f, 0xc88a,		0x21, 0
	.dw 0xe7c0, 0xc88a,	0xe7ff, 0xc88a,		0x21, 0
	.dw 0xe840, 0xc88a,	0xe87f, 0xc88a,		0x21, 0
	.dw 0xe8c0, 0xc88a,	0xe8ff, 0xc88a,		0x21, 0
	.dw 0xe940, 0xc88a,	0xe97f, 0xc88a,		0x21, 0
	.dw 0xe9c0, 0xc88a,	0xe9ff, 0xc88a,		0x21, 0
	.dw 0xea40, 0xc88a,	0xea7f, 0xc88a,		0x21, 0
	.dw 0xeac0, 0xc88a,	0xeaff, 0xc88a,		0x21, 0
	.dw 0xeb40, 0xc88a,	0xeb7f, 0xc88a,		0x21, 0
	.dw 0xebc0, 0xc88a,	0xebff, 0xc88a,		0x21, 0
	.dw 0xec40, 0xc88a,	0xec7f, 0xc88a,		0x21, 0
	.dw 0xecc0, 0xc88a,	0xecff, 0xc88a,		0x21, 0
	.dw 0xed40, 0xc88a,	0xed7f, 0xc88a,		0x21, 0
	.dw 0xedc0, 0xc88a,	0xedff, 0xc88a,		0x21, 0
	.dw 0xee40, 0xc88a,	0xee7f, 0xc88a,		0x21, 0
	.dw 0xeec0, 0xc88a,	0xeeff, 0xc88a,		0x21, 0
	.dw 0xef40, 0xc88a,	0xef7f, 0xc88a,		0x21, 0
	.dw 0xefc0, 0xc88a,	0xefff, 0xc88a,		0x21, 0
	.dw 0xf040, 0xc88a,	0xf07f, 0xc88a,		0x21, 0
	.dw 0xf0c0, 0xc88a,	0xf0ff, 0xc88a,		0x21, 0
	.dw 0xf140, 0xc88a,	0xf17f, 0xc88a,		0x21, 0
	.dw 0xf1c0, 0xc88a,	0xf1ff, 0xc88a,		0x21, 0
	.dw 0xf240, 0xc88a,	0xf27f, 0xc88a,		0x21, 0
	.dw 0xf2c0, 0xc88a,	0xf2ff, 0xc88a,		0x21, 0
	.dw 0xf340, 0xc88a,	0xf37f, 0xc88a,		0x21, 0
	.dw 0xf3c0, 0xc88a,	0xf3ff, 0xc88a,		0x21, 0
	.dw 0xf440, 0xc88a,	0xf47f, 0xc88a,		0x21, 0
	.dw 0xf4c0, 0xc88a,	0xf4ff, 0xc88a,		0x21, 0
	.dw 0xf540, 0xc88a,	0xf57f, 0xc88a,		0x21, 0
	.dw 0xf5c0, 0xc88a,	0xf5ff, 0xc88a,		0x21, 0
	.dw 0xf640, 0xc88a,	0xf67f, 0xc88a,		0x21, 0
	.dw 0xf6c0, 0xc88a,	0xf6ff, 0xc88a,		0x21, 0
	.dw 0xf740, 0xc88a,	0xf77f, 0xc88a,		0x21, 0
	.dw 0xf7c0, 0xc88a,	0xf7ff, 0xc88a,		0x21, 0
	.dw 0xf840, 0xc88a,	0xf87f, 0xc88a,		0x21, 0
	.dw 0xf8c0, 0xc88a,	0xf8ff, 0xc88a,		0x21, 0
	.dw 0xf940, 0xc88a,	0xf97f, 0xc88a,		0x21, 0
	.dw 0xf9c0, 0xc88a,	0x1fff, 0xc88b,		0x21, 0
	.dw 0x2040, 0xc88b,	0x207f, 0xc88b,		0x21, 0
	.dw 0x20c0, 0xc88b,	0x20ff, 0xc88b,		0x21, 0
	.dw 0x2140, 0xc88b,	0x217f, 0xc88b,		0x21, 0
	.dw 0x21c0, 0xc88b,	0x21ff, 0xc88b,		0x21, 0
	.dw 0x2240, 0xc88b,	0x227f, 0xc88b,		0x21, 0
	.dw 0x22c0, 0xc88b,	0x22ff, 0xc88b,		0x21, 0
	.dw 0x2340, 0xc88b,	0x237f, 0xc88b,		0x21, 0
	.dw 0x23c0, 0xc88b,	0x23ff, 0xc88b,		0x21, 0
	.dw 0x2440, 0xc88b,	0x247f, 0xc88b,		0x21, 0
	.dw 0x24c0, 0xc88b,	0x24ff, 0xc88b,		0x21, 0
	.dw 0x2540, 0xc88b,	0x257f, 0xc88b,		0x21, 0
	.dw 0x25c0, 0xc88b,	0x25ff, 0xc88b,		0x21, 0
	.dw 0x2640, 0xc88b,	0x267f, 0xc88b,		0x21, 0
	.dw 0x26c0, 0xc88b,	0x26ff, 0xc88b,		0x21, 0
	.dw 0x2740, 0xc88b,	0x277f, 0xc88b,		0x21, 0
	.dw 0x27c0, 0xc88b,	0x27ff, 0xc88b,		0x21, 0
	.dw 0x2840, 0xc88b,	0x287f, 0xc88b,		0x21, 0
	.dw 0x28c0, 0xc88b,	0x28ff, 0xc88b,		0x21, 0
	.dw 0x2940, 0xc88b,	0x297f, 0xc88b,		0x21, 0
	.dw 0x29c0, 0xc88b,	0x29ff, 0xc88b,		0x21, 0
	.dw 0x2a40, 0xc88b,	0x2a7f, 0xc88b,		0x21, 0
	.dw 0x2ac0, 0xc88b,	0x2aff, 0xc88b,		0x21, 0
	.dw 0x2b40, 0xc88b,	0x2b7f, 0xc88b,		0x21, 0
	.dw 0x2bc0, 0xc88b,	0x2bff, 0xc88b,		0x21, 0
	.dw 0x2c40, 0xc88b,	0x2c7f, 0xc88b,		0x21, 0
	.dw 0x2cc0, 0xc88b,	0x2cff, 0xc88b,		0x21, 0
	.dw 0x2d40, 0xc88b,	0x2d7f, 0xc88b,		0x21, 0
	.dw 0x2dc0, 0xc88b,	0x2dff, 0xc88b,		0x21, 0
	.dw 0x2e40, 0xc88b,	0x2e7f, 0xc88b,		0x21, 0
	.dw 0x2ec0, 0xc88b,	0x2eff, 0xc88b,		0x21, 0
	.dw 0x2f40, 0xc88b,	0x2f7f, 0xc88b,		0x21, 0
	.dw 0x2fc0, 0xc88b,	0x2fff, 0xc88b,		0x21, 0
	.dw 0x3040, 0xc88b,	0x307f, 0xc88b,		0x21, 0
	.dw 0x30c0, 0xc88b,	0x30ff, 0xc88b,		0x21, 0
	.dw 0x3140, 0xc88b,	0x317f, 0xc88b,		0x21, 0
	.dw 0x31c0, 0xc88b,	0x31ff, 0xc88b,		0x21, 0
	.dw 0x3240, 0xc88b,	0x327f, 0xc88b,		0x21, 0
	.dw 0x32c0, 0xc88b,	0x32ff, 0xc88b,		0x21, 0
	.dw 0x3340, 0xc88b,	0x337f, 0xc88b,		0x21, 0
	.dw 0x33c0, 0xc88b,	0x33ff, 0xc88b,		0x21, 0
	.dw 0x3440, 0xc88b,	0x347f, 0xc88b,		0x21, 0
	.dw 0x34c0, 0xc88b,	0x34ff, 0xc88b,		0x21, 0
	.dw 0x3540, 0xc88b,	0x357f, 0xc88b,		0x21, 0
	.dw 0x35c0, 0xc88b,	0x35ff, 0xc88b,		0x21, 0
	.dw 0x3640, 0xc88b,	0x367f, 0xc88b,		0x21, 0
	.dw 0x36c0, 0xc88b,	0x36ff, 0xc88b,		0x21, 0
	.dw 0x3740, 0xc88b,	0x377f, 0xc88b,		0x21, 0
	.dw 0x37c0, 0xc88b,	0x37ff, 0xc88b,		0x21, 0
	.dw 0x3840, 0xc88b,	0x387f, 0xc88b,		0x21, 0
	.dw 0x38c0, 0xc88b,	0x38ff, 0xc88b,		0x21, 0
	.dw 0x3940, 0xc88b,	0x397f, 0xc88b,		0x21, 0
	.dw 0x39c0, 0xc88b,	0xffff, 0xc88b,		0x21, 0
	.dw 0x0040, 0xc88c,	0x007f, 0xc88c,		0x21, 0
	.dw 0x00c0, 0xc88c,	0x00ff, 0xc88c,		0x21, 0
	.dw 0x0140, 0xc88c,	0x017f, 0xc88c,		0x21, 0
	.dw 0x01c0, 0xc88c,	0x01ff, 0xc88c,		0x21, 0
	.dw 0x0240, 0xc88c,	0x027f, 0xc88c,		0x21, 0
	.dw 0x02c0, 0xc88c,	0x02ff, 0xc88c,		0x21, 0
	.dw 0x0340, 0xc88c,	0x037f, 0xc88c,		0x21, 0
	.dw 0x03c0, 0xc88c,	0x03ff, 0xc88c,		0x21, 0
	.dw 0x0440, 0xc88c,	0x047f, 0xc88c,		0x21, 0
	.dw 0x04c0, 0xc88c,	0x04ff, 0xc88c,		0x21, 0
	.dw 0x0540, 0xc88c,	0x057f, 0xc88c,		0x21, 0
	.dw 0x05c0, 0xc88c,	0x05ff, 0xc88c,		0x21, 0
	.dw 0x0640, 0xc88c,	0x067f, 0xc88c,		0x21, 0
	.dw 0x06c0, 0xc88c,	0x06ff, 0xc88c,		0x21, 0
	.dw 0x0740, 0xc88c,	0x077f, 0xc88c,		0x21, 0
	.dw 0x07c0, 0xc88c,	0x07ff, 0xc88c,		0x21, 0
	.dw 0x0840, 0xc88c,	0x087f, 0xc88c,		0x21, 0
	.dw 0x08c0, 0xc88c,	0x08ff, 0xc88c,		0x21, 0
	.dw 0x0940, 0xc88c,	0x097f, 0xc88c,		0x21, 0
	.dw 0x09c0, 0xc88c,	0x09ff, 0xc88c,		0x21, 0
	.dw 0x0a40, 0xc88c,	0x0a7f, 0xc88c,		0x21, 0
	.dw 0x0ac0, 0xc88c,	0x0aff, 0xc88c,		0x21, 0
	.dw 0x0b40, 0xc88c,	0x0b7f, 0xc88c,		0x21, 0
	.dw 0x0bc0, 0xc88c,	0x0bff, 0xc88c,		0x21, 0
	.dw 0x0c40, 0xc88c,	0x0c7f, 0xc88c,		0x21, 0
	.dw 0x0cc0, 0xc88c,	0x0cff, 0xc88c,		0x21, 0
	.dw 0x0d40, 0xc88c,	0x0d7f, 0xc88c,		0x21, 0
	.dw 0x0dc0, 0xc88c,	0x0dff, 0xc88c,		0x21, 0
	.dw 0x0e40, 0xc88c,	0x0e7f, 0xc88c,		0x21, 0
	.dw 0x0ec0, 0xc88c,	0x0eff, 0xc88c,		0x21, 0
	.dw 0x0f40, 0xc88c,	0x0f7f, 0xc88c,		0x21, 0
	.dw 0x0fc0, 0xc88c,	0x0fff, 0xc88c,		0x21, 0
	.dw 0x1040, 0xc88c,	0x107f, 0xc88c,		0x21, 0
	.dw 0x10c0, 0xc88c,	0x10ff, 0xc88c,		0x21, 0
	.dw 0x1140, 0xc88c,	0x117f, 0xc88c,		0x21, 0
	.dw 0x11c0, 0xc88c,	0x11ff, 0xc88c,		0x21, 0
	.dw 0x1240, 0xc88c,	0x127f, 0xc88c,		0x21, 0
	.dw 0x12c0, 0xc88c,	0x12ff, 0xc88c,		0x21, 0
	.dw 0x1340, 0xc88c,	0x137f, 0xc88c,		0x21, 0
	.dw 0x13c0, 0xc88c,	0x13ff, 0xc88c,		0x21, 0
	.dw 0x1440, 0xc88c,	0x147f, 0xc88c,		0x21, 0
	.dw 0x14c0, 0xc88c,	0x14ff, 0xc88c,		0x21, 0
	.dw 0x1540, 0xc88c,	0x157f, 0xc88c,		0x21, 0
	.dw 0x15c0, 0xc88c,	0x15ff, 0xc88c,		0x21, 0
	.dw 0x1640, 0xc88c,	0x167f, 0xc88c,		0x21, 0
	.dw 0x16c0, 0xc88c,	0x16ff, 0xc88c,		0x21, 0
	.dw 0x1740, 0xc88c,	0x177f, 0xc88c,		0x21, 0
	.dw 0x17c0, 0xc88c,	0x17ff, 0xc88c,		0x21, 0
	.dw 0x1840, 0xc88c,	0x187f, 0xc88c,		0x21, 0
	.dw 0x18c0, 0xc88c,	0x18ff, 0xc88c,		0x21, 0
	.dw 0x1940, 0xc88c,	0x197f, 0xc88c,		0x21, 0
	.dw 0x19c0, 0xc88c,	0x1fff, 0xc88c,		0x21, 0
	.dw 0x2040, 0xc88c,	0x207f, 0xc88c,		0x21, 0
	.dw 0x20c0, 0xc88c,	0x20ff, 0xc88c,		0x21, 0
	.dw 0x2140, 0xc88c,	0x217f, 0xc88c,		0x21, 0
	.dw 0x21c0, 0xc88c,	0x21ff, 0xc88c,		0x21, 0
	.dw 0x2240, 0xc88c,	0x227f, 0xc88c,		0x21, 0
	.dw 0x22c0, 0xc88c,	0x22ff, 0xc88c,		0x21, 0
	.dw 0x2340, 0xc88c,	0x237f, 0xc88c,		0x21, 0
	.dw 0x23c0, 0xc88c,	0x23ff, 0xc88c,		0x21, 0
	.dw 0x2440, 0xc88c,	0x247f, 0xc88c,		0x21, 0
	.dw 0x24c0, 0xc88c,	0x24ff, 0xc88c,		0x21, 0
	.dw 0x2540, 0xc88c,	0x257f, 0xc88c,		0x21, 0
	.dw 0x25c0, 0xc88c,	0x25ff, 0xc88c,		0x21, 0
	.dw 0x2640, 0xc88c,	0x267f, 0xc88c,		0x21, 0
	.dw 0x26c0, 0xc88c,	0x26ff, 0xc88c,		0x21, 0
	.dw 0x2740, 0xc88c,	0x277f, 0xc88c,		0x21, 0
	.dw 0x27c0, 0xc88c,	0x27ff, 0xc88c,		0x21, 0
	.dw 0x2840, 0xc88c,	0x287f, 0xc88c,		0x21, 0
	.dw 0x28c0, 0xc88c,	0x28ff, 0xc88c,		0x21, 0
	.dw 0x2940, 0xc88c,	0x297f, 0xc88c,		0x21, 0
	.dw 0x29c0, 0xc88c,	0x29ff, 0xc88c,		0x21, 0
	.dw 0x2a40, 0xc88c,	0x2a7f, 0xc88c,		0x21, 0
	.dw 0x2ac0, 0xc88c,	0x2aff, 0xc88c,		0x21, 0
	.dw 0x2b40, 0xc88c,	0x2b7f, 0xc88c,		0x21, 0
	.dw 0x2bc0, 0xc88c,	0x2bff, 0xc88c,		0x21, 0
	.dw 0x2c40, 0xc88c,	0x2c7f, 0xc88c,		0x21, 0
	.dw 0x2cc0, 0xc88c,	0x2cff, 0xc88c,		0x21, 0
	.dw 0x2d40, 0xc88c,	0x2d7f, 0xc88c,		0x21, 0
	.dw 0x2dc0, 0xc88c,	0x2dff, 0xc88c,		0x21, 0
	.dw 0x2e40, 0xc88c,	0x2e7f, 0xc88c,		0x21, 0
	.dw 0x2ec0, 0xc88c,	0x2eff, 0xc88c,		0x21, 0
	.dw 0x2f40, 0xc88c,	0x2f7f, 0xc88c,		0x21, 0
	.dw 0x2fc0, 0xc88c,	0x2fff, 0xc88c,		0x21, 0
	.dw 0x3040, 0xc88c,	0x307f, 0xc88c,		0x21, 0
	.dw 0x30c0, 0xc88c,	0x30ff, 0xc88c,		0x21, 0
	.dw 0x3140, 0xc88c,	0x317f, 0xc88c,		0x21, 0
	.dw 0x31c0, 0xc88c,	0x31ff, 0xc88c,		0x21, 0
	.dw 0x3240, 0xc88c,	0x327f, 0xc88c,		0x21, 0
	.dw 0x32c0, 0xc88c,	0x32ff, 0xc88c,		0x21, 0
	.dw 0x3340, 0xc88c,	0x337f, 0xc88c,		0x21, 0
	.dw 0x33c0, 0xc88c,	0x33ff, 0xc88c,		0x21, 0
	.dw 0x3440, 0xc88c,	0x347f, 0xc88c,		0x21, 0
	.dw 0x34c0, 0xc88c,	0x34ff, 0xc88c,		0x21, 0
	.dw 0x3540, 0xc88c,	0x357f, 0xc88c,		0x21, 0
	.dw 0x35c0, 0xc88c,	0x35ff, 0xc88c,		0x21, 0
	.dw 0x3640, 0xc88c,	0x367f, 0xc88c,		0x21, 0
	.dw 0x36c0, 0xc88c,	0x36ff, 0xc88c,		0x21, 0
	.dw 0x3740, 0xc88c,	0x377f, 0xc88c,		0x21, 0
	.dw 0x37c0, 0xc88c,	0x37ff, 0xc88c,		0x21, 0
	.dw 0x3840, 0xc88c,	0x387f, 0xc88c,		0x21, 0
	.dw 0x38c0, 0xc88c,	0x38ff, 0xc88c,		0x21, 0
	.dw 0x3940, 0xc88c,	0x397f, 0xc88c,		0x21, 0
	.dw 0x39c0, 0xc88c,	0x3fff, 0xc88c,		0x21, 0
	.dw 0x4040, 0xc88c,	0x407f, 0xc88c,		0x21, 0
	.dw 0x40c0, 0xc88c,	0x40ff, 0xc88c,		0x21, 0
	.dw 0x4140, 0xc88c,	0x417f, 0xc88c,		0x21, 0
	.dw 0x41c0, 0xc88c,	0x41ff, 0xc88c,		0x21, 0
	.dw 0x4240, 0xc88c,	0x427f, 0xc88c,		0x21, 0
	.dw 0x42c0, 0xc88c,	0x42ff, 0xc88c,		0x21, 0
	.dw 0x4340, 0xc88c,	0x437f, 0xc88c,		0x21, 0
	.dw 0x43c0, 0xc88c,	0x43ff, 0xc88c,		0x21, 0
	.dw 0x4440, 0xc88c,	0x447f, 0xc88c,		0x21, 0
	.dw 0x44c0, 0xc88c,	0x44ff, 0xc88c,		0x21, 0
	.dw 0x4540, 0xc88c,	0x457f, 0xc88c,		0x21, 0
	.dw 0x45c0, 0xc88c,	0x45ff, 0xc88c,		0x21, 0
	.dw 0x4640, 0xc88c,	0x467f, 0xc88c,		0x21, 0
	.dw 0x46c0, 0xc88c,	0x46ff, 0xc88c,		0x21, 0
	.dw 0x4740, 0xc88c,	0x477f, 0xc88c,		0x21, 0
	.dw 0x47c0, 0xc88c,	0x47ff, 0xc88c,		0x21, 0
	.dw 0x4840, 0xc88c,	0x487f, 0xc88c,		0x21, 0
	.dw 0x48c0, 0xc88c,	0x48ff, 0xc88c,		0x21, 0
	.dw 0x4940, 0xc88c,	0x497f, 0xc88c,		0x21, 0
	.dw 0x49c0, 0xc88c,	0x49ff, 0xc88c,		0x21, 0
	.dw 0x4a40, 0xc88c,	0x4a7f, 0xc88c,		0x21, 0
	.dw 0x4ac0, 0xc88c,	0x4aff, 0xc88c,		0x21, 0
	.dw 0x4b40, 0xc88c,	0x4b7f, 0xc88c,		0x21, 0
	.dw 0x4bc0, 0xc88c,	0x4bff, 0xc88c,		0x21, 0
	.dw 0x4c40, 0xc88c,	0x4c7f, 0xc88c,		0x21, 0
	.dw 0x4cc0, 0xc88c,	0x4cff, 0xc88c,		0x21, 0
	.dw 0x4d40, 0xc88c,	0x4d7f, 0xc88c,		0x21, 0
	.dw 0x4dc0, 0xc88c,	0x4dff, 0xc88c,		0x21, 0
	.dw 0x4e40, 0xc88c,	0x4e7f, 0xc88c,		0x21, 0
	.dw 0x4ec0, 0xc88c,	0x4eff, 0xc88c,		0x21, 0
	.dw 0x4f40, 0xc88c,	0x4f7f, 0xc88c,		0x21, 0
	.dw 0x4fc0, 0xc88c,	0x4fff, 0xc88c,		0x21, 0
	.dw 0x5040, 0xc88c,	0x507f, 0xc88c,		0x21, 0
	.dw 0x50c0, 0xc88c,	0x50ff, 0xc88c,		0x21, 0
	.dw 0x5140, 0xc88c,	0x517f, 0xc88c,		0x21, 0
	.dw 0x51c0, 0xc88c,	0x51ff, 0xc88c,		0x21, 0
	.dw 0x5240, 0xc88c,	0x527f, 0xc88c,		0x21, 0
	.dw 0x52c0, 0xc88c,	0x52ff, 0xc88c,		0x21, 0
	.dw 0x5340, 0xc88c,	0x537f, 0xc88c,		0x21, 0
	.dw 0x53c0, 0xc88c,	0x53ff, 0xc88c,		0x21, 0
	.dw 0x5440, 0xc88c,	0x547f, 0xc88c,		0x21, 0
	.dw 0x54c0, 0xc88c,	0x54ff, 0xc88c,		0x21, 0
	.dw 0x5540, 0xc88c,	0x557f, 0xc88c,		0x21, 0
	.dw 0x55c0, 0xc88c,	0x55ff, 0xc88c,		0x21, 0
	.dw 0x5640, 0xc88c,	0x567f, 0xc88c,		0x21, 0
	.dw 0x56c0, 0xc88c,	0x56ff, 0xc88c,		0x21, 0
	.dw 0x5740, 0xc88c,	0x577f, 0xc88c,		0x21, 0
	.dw 0x57c0, 0xc88c,	0x57ff, 0xc88c,		0x21, 0
	.dw 0x5840, 0xc88c,	0x587f, 0xc88c,		0x21, 0
	.dw 0x58c0, 0xc88c,	0x58ff, 0xc88c,		0x21, 0
	.dw 0x5940, 0xc88c,	0x597f, 0xc88c,		0x21, 0
	.dw 0x59c0, 0xc88c,	0x5fff, 0xc88c,		0x21, 0
	.dw 0x6040, 0xc88c,	0x607f, 0xc88c,		0x21, 0
	.dw 0x60c0, 0xc88c,	0x60ff, 0xc88c,		0x21, 0
	.dw 0x6140, 0xc88c,	0x617f, 0xc88c,		0x21, 0
	.dw 0x61c0, 0xc88c,	0x61ff, 0xc88c,		0x21, 0
	.dw 0x6240, 0xc88c,	0x627f, 0xc88c,		0x21, 0
	.dw 0x62c0, 0xc88c,	0x62ff, 0xc88c,		0x21, 0
	.dw 0x6340, 0xc88c,	0x637f, 0xc88c,		0x21, 0
	.dw 0x63c0, 0xc88c,	0x63ff, 0xc88c,		0x21, 0
	.dw 0x6440, 0xc88c,	0x647f, 0xc88c,		0x21, 0
	.dw 0x64c0, 0xc88c,	0x64ff, 0xc88c,		0x21, 0
	.dw 0x6540, 0xc88c,	0x657f, 0xc88c,		0x21, 0
	.dw 0x65c0, 0xc88c,	0x65ff, 0xc88c,		0x21, 0
	.dw 0x6640, 0xc88c,	0x667f, 0xc88c,		0x21, 0
	.dw 0x66c0, 0xc88c,	0x66ff, 0xc88c,		0x21, 0
	.dw 0x6740, 0xc88c,	0x677f, 0xc88c,		0x21, 0
	.dw 0x67c0, 0xc88c,	0x67ff, 0xc88c,		0x21, 0
	.dw 0x6840, 0xc88c,	0x687f, 0xc88c,		0x21, 0
	.dw 0x68c0, 0xc88c,	0x68ff, 0xc88c,		0x21, 0
	.dw 0x6940, 0xc88c,	0x697f, 0xc88c,		0x21, 0
	.dw 0x69c0, 0xc88c,	0x69ff, 0xc88c,		0x21, 0
	.dw 0x6a40, 0xc88c,	0x6a7f, 0xc88c,		0x21, 0
	.dw 0x6ac0, 0xc88c,	0x6aff, 0xc88c,		0x21, 0
	.dw 0x6b40, 0xc88c,	0x6b7f, 0xc88c,		0x21, 0
	.dw 0x6bc0, 0xc88c,	0x6bff, 0xc88c,		0x21, 0
	.dw 0x6c40, 0xc88c,	0x6c7f, 0xc88c,		0x21, 0
	.dw 0x6cc0, 0xc88c,	0x6cff, 0xc88c,		0x21, 0
	.dw 0x6d40, 0xc88c,	0x6d7f, 0xc88c,		0x21, 0
	.dw 0x6dc0, 0xc88c,	0x6dff, 0xc88c,		0x21, 0
	.dw 0x6e40, 0xc88c,	0x6e7f, 0xc88c,		0x21, 0
	.dw 0x6ec0, 0xc88c,	0x6eff, 0xc88c,		0x21, 0
	.dw 0x6f40, 0xc88c,	0x6f7f, 0xc88c,		0x21, 0
	.dw 0x6fc0, 0xc88c,	0x6fff, 0xc88c,		0x21, 0
	.dw 0x7040, 0xc88c,	0x707f, 0xc88c,		0x21, 0
	.dw 0x70c0, 0xc88c,	0x70ff, 0xc88c,		0x21, 0
	.dw 0x7140, 0xc88c,	0x717f, 0xc88c,		0x21, 0
	.dw 0x71c0, 0xc88c,	0x71ff, 0xc88c,		0x21, 0
	.dw 0x7240, 0xc88c,	0x727f, 0xc88c,		0x21, 0
	.dw 0x72c0, 0xc88c,	0x72ff, 0xc88c,		0x21, 0
	.dw 0x7340, 0xc88c,	0x737f, 0xc88c,		0x21, 0
	.dw 0x73c0, 0xc88c,	0x73ff, 0xc88c,		0x21, 0
	.dw 0x7440, 0xc88c,	0x747f, 0xc88c,		0x21, 0
	.dw 0x74c0, 0xc88c,	0x74ff, 0xc88c,		0x21, 0
	.dw 0x7540, 0xc88c,	0x757f, 0xc88c,		0x21, 0
	.dw 0x75c0, 0xc88c,	0x75ff, 0xc88c,		0x21, 0
	.dw 0x7640, 0xc88c,	0x767f, 0xc88c,		0x21, 0
	.dw 0x76c0, 0xc88c,	0x76ff, 0xc88c,		0x21, 0
	.dw 0x7740, 0xc88c,	0x777f, 0xc88c,		0x21, 0
	.dw 0x77c0, 0xc88c,	0x77ff, 0xc88c,		0x21, 0
	.dw 0x7840, 0xc88c,	0x787f, 0xc88c,		0x21, 0
	.dw 0x78c0, 0xc88c,	0x78ff, 0xc88c,		0x21, 0
	.dw 0x7940, 0xc88c,	0x797f, 0xc88c,		0x21, 0
	.dw 0x79c0, 0xc88c,	0x7fff, 0xc88c,		0x21, 0
	.dw 0x8040, 0xc88c,	0x807f, 0xc88c,		0x21, 0
	.dw 0x80c0, 0xc88c,	0x80ff, 0xc88c,		0x21, 0
	.dw 0x8140, 0xc88c,	0x817f, 0xc88c,		0x21, 0
	.dw 0x81c0, 0xc88c,	0x81ff, 0xc88c,		0x21, 0
	.dw 0x8240, 0xc88c,	0x827f, 0xc88c,		0x21, 0
	.dw 0x82c0, 0xc88c,	0x82ff, 0xc88c,		0x21, 0
	.dw 0x8340, 0xc88c,	0x837f, 0xc88c,		0x21, 0
	.dw 0x83c0, 0xc88c,	0x83ff, 0xc88c,		0x21, 0
	.dw 0x8440, 0xc88c,	0x847f, 0xc88c,		0x21, 0
	.dw 0x84c0, 0xc88c,	0x84ff, 0xc88c,		0x21, 0
	.dw 0x8540, 0xc88c,	0x857f, 0xc88c,		0x21, 0
	.dw 0x85c0, 0xc88c,	0x85ff, 0xc88c,		0x21, 0
	.dw 0x8640, 0xc88c,	0x867f, 0xc88c,		0x21, 0
	.dw 0x86c0, 0xc88c,	0x86ff, 0xc88c,		0x21, 0
	.dw 0x8740, 0xc88c,	0x877f, 0xc88c,		0x21, 0
	.dw 0x87c0, 0xc88c,	0x87ff, 0xc88c,		0x21, 0
	.dw 0x8840, 0xc88c,	0x887f, 0xc88c,		0x21, 0
	.dw 0x88c0, 0xc88c,	0x88ff, 0xc88c,		0x21, 0
	.dw 0x8940, 0xc88c,	0x897f, 0xc88c,		0x21, 0
	.dw 0x89c0, 0xc88c,	0x89ff, 0xc88c,		0x21, 0
	.dw 0x8a40, 0xc88c,	0x8a7f, 0xc88c,		0x21, 0
	.dw 0x8ac0, 0xc88c,	0x8aff, 0xc88c,		0x21, 0
	.dw 0x8b40, 0xc88c,	0x8b7f, 0xc88c,		0x21, 0
	.dw 0x8bc0, 0xc88c,	0x8bff, 0xc88c,		0x21, 0
	.dw 0x8c40, 0xc88c,	0x8c7f, 0xc88c,		0x21, 0
	.dw 0x8cc0, 0xc88c,	0x8cff, 0xc88c,		0x21, 0
	.dw 0x8d40, 0xc88c,	0x8d7f, 0xc88c,		0x21, 0
	.dw 0x8dc0, 0xc88c,	0x8dff, 0xc88c,		0x21, 0
	.dw 0x8e40, 0xc88c,	0x8e7f, 0xc88c,		0x21, 0
	.dw 0x8ec0, 0xc88c,	0x8eff, 0xc88c,		0x21, 0
	.dw 0x8f40, 0xc88c,	0x8f7f, 0xc88c,		0x21, 0
	.dw 0x8fc0, 0xc88c,	0x8fff, 0xc88c,		0x21, 0
	.dw 0x9040, 0xc88c,	0x907f, 0xc88c,		0x21, 0
	.dw 0x90c0, 0xc88c,	0x90ff, 0xc88c,		0x21, 0
	.dw 0x9140, 0xc88c,	0x917f, 0xc88c,		0x21, 0
	.dw 0x91c0, 0xc88c,	0x91ff, 0xc88c,		0x21, 0
	.dw 0x9240, 0xc88c,	0x927f, 0xc88c,		0x21, 0
	.dw 0x92c0, 0xc88c,	0x92ff, 0xc88c,		0x21, 0
	.dw 0x9340, 0xc88c,	0x937f, 0xc88c,		0x21, 0
	.dw 0x93c0, 0xc88c,	0x93ff, 0xc88c,		0x21, 0
	.dw 0x9440, 0xc88c,	0x947f, 0xc88c,		0x21, 0
	.dw 0x94c0, 0xc88c,	0x94ff, 0xc88c,		0x21, 0
	.dw 0x9540, 0xc88c,	0x957f, 0xc88c,		0x21, 0
	.dw 0x95c0, 0xc88c,	0x95ff, 0xc88c,		0x21, 0
	.dw 0x9640, 0xc88c,	0x967f, 0xc88c,		0x21, 0
	.dw 0x96c0, 0xc88c,	0x96ff, 0xc88c,		0x21, 0
	.dw 0x9740, 0xc88c,	0x977f, 0xc88c,		0x21, 0
	.dw 0x97c0, 0xc88c,	0x97ff, 0xc88c,		0x21, 0
	.dw 0x9840, 0xc88c,	0x987f, 0xc88c,		0x21, 0
	.dw 0x98c0, 0xc88c,	0x98ff, 0xc88c,		0x21, 0
	.dw 0x9940, 0xc88c,	0x997f, 0xc88c,		0x21, 0
	.dw 0x99c0, 0xc88c,	0x9fff, 0xc88c,		0x21, 0
	.dw 0xa040, 0xc88c,	0xa07f, 0xc88c,		0x21, 0
	.dw 0xa0c0, 0xc88c,	0xa0ff, 0xc88c,		0x21, 0
	.dw 0xa140, 0xc88c,	0xa17f, 0xc88c,		0x21, 0
	.dw 0xa1c0, 0xc88c,	0xa1ff, 0xc88c,		0x21, 0
	.dw 0xa240, 0xc88c,	0xa27f, 0xc88c,		0x21, 0
	.dw 0xa2c0, 0xc88c,	0xa2ff, 0xc88c,		0x21, 0
	.dw 0xa340, 0xc88c,	0xa37f, 0xc88c,		0x21, 0
	.dw 0xa3c0, 0xc88c,	0xa3ff, 0xc88c,		0x21, 0
	.dw 0xa440, 0xc88c,	0xa47f, 0xc88c,		0x21, 0
	.dw 0xa4c0, 0xc88c,	0xa4ff, 0xc88c,		0x21, 0
	.dw 0xa540, 0xc88c,	0xa57f, 0xc88c,		0x21, 0
	.dw 0xa5c0, 0xc88c,	0xa5ff, 0xc88c,		0x21, 0
	.dw 0xa640, 0xc88c,	0xa67f, 0xc88c,		0x21, 0
	.dw 0xa6c0, 0xc88c,	0xa6ff, 0xc88c,		0x21, 0
	.dw 0xa740, 0xc88c,	0xa77f, 0xc88c,		0x21, 0
	.dw 0xa7c0, 0xc88c,	0xa7ff, 0xc88c,		0x21, 0
	.dw 0xa840, 0xc88c,	0xa87f, 0xc88c,		0x21, 0
	.dw 0xa8c0, 0xc88c,	0xa8ff, 0xc88c,		0x21, 0
	.dw 0xa940, 0xc88c,	0xa97f, 0xc88c,		0x21, 0
	.dw 0xa9c0, 0xc88c,	0xa9ff, 0xc88c,		0x21, 0
	.dw 0xaa40, 0xc88c,	0xaa7f, 0xc88c,		0x21, 0
	.dw 0xaac0, 0xc88c,	0xaaff, 0xc88c,		0x21, 0
	.dw 0xab40, 0xc88c,	0xab7f, 0xc88c,		0x21, 0
	.dw 0xabc0, 0xc88c,	0xabff, 0xc88c,		0x21, 0
	.dw 0xac40, 0xc88c,	0xac7f, 0xc88c,		0x21, 0
	.dw 0xacc0, 0xc88c,	0xacff, 0xc88c,		0x21, 0
	.dw 0xad40, 0xc88c,	0xad7f, 0xc88c,		0x21, 0
	.dw 0xadc0, 0xc88c,	0xadff, 0xc88c,		0x21, 0
	.dw 0xae40, 0xc88c,	0xae7f, 0xc88c,		0x21, 0
	.dw 0xaec0, 0xc88c,	0xaeff, 0xc88c,		0x21, 0
	.dw 0xaf40, 0xc88c,	0xaf7f, 0xc88c,		0x21, 0
	.dw 0xafc0, 0xc88c,	0xafff, 0xc88c,		0x21, 0
	.dw 0xb040, 0xc88c,	0xb07f, 0xc88c,		0x21, 0
	.dw 0xb0c0, 0xc88c,	0xb0ff, 0xc88c,		0x21, 0
	.dw 0xb140, 0xc88c,	0xb17f, 0xc88c,		0x21, 0
	.dw 0xb1c0, 0xc88c,	0xb1ff, 0xc88c,		0x21, 0
	.dw 0xb240, 0xc88c,	0xb27f, 0xc88c,		0x21, 0
	.dw 0xb2c0, 0xc88c,	0xb2ff, 0xc88c,		0x21, 0
	.dw 0xb340, 0xc88c,	0xb37f, 0xc88c,		0x21, 0
	.dw 0xb3c0, 0xc88c,	0xb3ff, 0xc88c,		0x21, 0
	.dw 0xb440, 0xc88c,	0xb47f, 0xc88c,		0x21, 0
	.dw 0xb4c0, 0xc88c,	0xb4ff, 0xc88c,		0x21, 0
	.dw 0xb540, 0xc88c,	0xb57f, 0xc88c,		0x21, 0
	.dw 0xb5c0, 0xc88c,	0xb5ff, 0xc88c,		0x21, 0
	.dw 0xb640, 0xc88c,	0xb67f, 0xc88c,		0x21, 0
	.dw 0xb6c0, 0xc88c,	0xb6ff, 0xc88c,		0x21, 0
	.dw 0xb740, 0xc88c,	0xb77f, 0xc88c,		0x21, 0
	.dw 0xb7c0, 0xc88c,	0xb7ff, 0xc88c,		0x21, 0
	.dw 0xb840, 0xc88c,	0xb87f, 0xc88c,		0x21, 0
	.dw 0xb8c0, 0xc88c,	0xb8ff, 0xc88c,		0x21, 0
	.dw 0xb940, 0xc88c,	0xb97f, 0xc88c,		0x21, 0
	.dw 0xb9c0, 0xc88c,	0xbfff, 0xc88c,		0x21, 0
	.dw 0xc040, 0xc88c,	0xc07f, 0xc88c,		0x21, 0
	.dw 0xc0c0, 0xc88c,	0xc0ff, 0xc88c,		0x21, 0
	.dw 0xc140, 0xc88c,	0xc17f, 0xc88c,		0x21, 0
	.dw 0xc1c0, 0xc88c,	0xc1ff, 0xc88c,		0x21, 0
	.dw 0xc240, 0xc88c,	0xc27f, 0xc88c,		0x21, 0
	.dw 0xc2c0, 0xc88c,	0xc2ff, 0xc88c,		0x21, 0
	.dw 0xc340, 0xc88c,	0xc37f, 0xc88c,		0x21, 0
	.dw 0xc3c0, 0xc88c,	0xc3ff, 0xc88c,		0x21, 0
	.dw 0xc440, 0xc88c,	0xc47f, 0xc88c,		0x21, 0
	.dw 0xc4c0, 0xc88c,	0xc4ff, 0xc88c,		0x21, 0
	.dw 0xc540, 0xc88c,	0xc57f, 0xc88c,		0x21, 0
	.dw 0xc5c0, 0xc88c,	0xc5ff, 0xc88c,		0x21, 0
	.dw 0xc640, 0xc88c,	0xc67f, 0xc88c,		0x21, 0
	.dw 0xc6c0, 0xc88c,	0xc6ff, 0xc88c,		0x21, 0
	.dw 0xc740, 0xc88c,	0xc77f, 0xc88c,		0x21, 0
	.dw 0xc7c0, 0xc88c,	0xc7ff, 0xc88c,		0x21, 0
	.dw 0xc840, 0xc88c,	0xc87f, 0xc88c,		0x21, 0
	.dw 0xc8c0, 0xc88c,	0xc8ff, 0xc88c,		0x21, 0
	.dw 0xc940, 0xc88c,	0xc97f, 0xc88c,		0x21, 0
	.dw 0xc9c0, 0xc88c,	0xc9ff, 0xc88c,		0x21, 0
	.dw 0xca40, 0xc88c,	0xca7f, 0xc88c,		0x21, 0
	.dw 0xcac0, 0xc88c,	0xcaff, 0xc88c,		0x21, 0
	.dw 0xcb40, 0xc88c,	0xcb7f, 0xc88c,		0x21, 0
	.dw 0xcbc0, 0xc88c,	0xcbff, 0xc88c,		0x21, 0
	.dw 0xcc40, 0xc88c,	0xcc7f, 0xc88c,		0x21, 0
	.dw 0xccc0, 0xc88c,	0xccff, 0xc88c,		0x21, 0
	.dw 0xcd40, 0xc88c,	0xcd7f, 0xc88c,		0x21, 0
	.dw 0xcdc0, 0xc88c,	0xcdff, 0xc88c,		0x21, 0
	.dw 0xce40, 0xc88c,	0xce7f, 0xc88c,		0x21, 0
	.dw 0xcec0, 0xc88c,	0xceff, 0xc88c,		0x21, 0
	.dw 0xcf40, 0xc88c,	0xcf7f, 0xc88c,		0x21, 0
	.dw 0xcfc0, 0xc88c,	0xcfff, 0xc88c,		0x21, 0
	.dw 0xd040, 0xc88c,	0xd07f, 0xc88c,		0x21, 0
	.dw 0xd0c0, 0xc88c,	0xd0ff, 0xc88c,		0x21, 0
	.dw 0xd140, 0xc88c,	0xd17f, 0xc88c,		0x21, 0
	.dw 0xd1c0, 0xc88c,	0xd1ff, 0xc88c,		0x21, 0
	.dw 0xd240, 0xc88c,	0xd27f, 0xc88c,		0x21, 0
	.dw 0xd2c0, 0xc88c,	0xd2ff, 0xc88c,		0x21, 0
	.dw 0xd340, 0xc88c,	0xd37f, 0xc88c,		0x21, 0
	.dw 0xd3c0, 0xc88c,	0xd3ff, 0xc88c,		0x21, 0
	.dw 0xd440, 0xc88c,	0xd47f, 0xc88c,		0x21, 0
	.dw 0xd4c0, 0xc88c,	0xd4ff, 0xc88c,		0x21, 0
	.dw 0xd540, 0xc88c,	0xd57f, 0xc88c,		0x21, 0
	.dw 0xd5c0, 0xc88c,	0xd5ff, 0xc88c,		0x21, 0
	.dw 0xd640, 0xc88c,	0xd67f, 0xc88c,		0x21, 0
	.dw 0xd6c0, 0xc88c,	0xd6ff, 0xc88c,		0x21, 0
	.dw 0xd740, 0xc88c,	0xd77f, 0xc88c,		0x21, 0
	.dw 0xd7c0, 0xc88c,	0xd7ff, 0xc88c,		0x21, 0
	.dw 0xd840, 0xc88c,	0xd87f, 0xc88c,		0x21, 0
	.dw 0xd8c0, 0xc88c,	0xd8ff, 0xc88c,		0x21, 0
	.dw 0xd940, 0xc88c,	0xd97f, 0xc88c,		0x21, 0
	.dw 0xd9c0, 0xc88c,	0xdfff, 0xc88c,		0x21, 0
	.dw 0xe040, 0xc88c,	0xe07f, 0xc88c,		0x21, 0
	.dw 0xe0c0, 0xc88c,	0xe0ff, 0xc88c,		0x21, 0
	.dw 0xe140, 0xc88c,	0xe17f, 0xc88c,		0x21, 0
	.dw 0xe1c0, 0xc88c,	0xe1ff, 0xc88c,		0x21, 0
	.dw 0xe240, 0xc88c,	0xe27f, 0xc88c,		0x21, 0
	.dw 0xe2c0, 0xc88c,	0xe2ff, 0xc88c,		0x21, 0
	.dw 0xe340, 0xc88c,	0xe37f, 0xc88c,		0x21, 0
	.dw 0xe3c0, 0xc88c,	0xe3ff, 0xc88c,		0x21, 0
	.dw 0xe440, 0xc88c,	0xe47f, 0xc88c,		0x21, 0
	.dw 0xe4c0, 0xc88c,	0xe4ff, 0xc88c,		0x21, 0
	.dw 0xe540, 0xc88c,	0xe57f, 0xc88c,		0x21, 0
	.dw 0xe5c0, 0xc88c,	0xe5ff, 0xc88c,		0x21, 0
	.dw 0xe640, 0xc88c,	0xe67f, 0xc88c,		0x21, 0
	.dw 0xe6c0, 0xc88c,	0xe6ff, 0xc88c,		0x21, 0
	.dw 0xe740, 0xc88c,	0xe77f, 0xc88c,		0x21, 0
	.dw 0xe7c0, 0xc88c,	0xe7ff, 0xc88c,		0x21, 0
	.dw 0xe840, 0xc88c,	0xe87f, 0xc88c,		0x21, 0
	.dw 0xe8c0, 0xc88c,	0xe8ff, 0xc88c,		0x21, 0
	.dw 0xe940, 0xc88c,	0xe97f, 0xc88c,		0x21, 0
	.dw 0xe9c0, 0xc88c,	0xe9ff, 0xc88c,		0x21, 0
	.dw 0xea40, 0xc88c,	0xea7f, 0xc88c,		0x21, 0
	.dw 0xeac0, 0xc88c,	0xeaff, 0xc88c,		0x21, 0
	.dw 0xeb40, 0xc88c,	0xeb7f, 0xc88c,		0x21, 0
	.dw 0xebc0, 0xc88c,	0xebff, 0xc88c,		0x21, 0
	.dw 0xec40, 0xc88c,	0xec7f, 0xc88c,		0x21, 0
	.dw 0xecc0, 0xc88c,	0xecff, 0xc88c,		0x21, 0
	.dw 0xed40, 0xc88c,	0xed7f, 0xc88c,		0x21, 0
	.dw 0xedc0, 0xc88c,	0xedff, 0xc88c,		0x21, 0
	.dw 0xee40, 0xc88c,	0xee7f, 0xc88c,		0x21, 0
	.dw 0xeec0, 0xc88c,	0xeeff, 0xc88c,		0x21, 0
	.dw 0xef40, 0xc88c,	0xef7f, 0xc88c,		0x21, 0
	.dw 0xefc0, 0xc88c,	0xefff, 0xc88c,		0x21, 0
	.dw 0xf040, 0xc88c,	0xf07f, 0xc88c,		0x21, 0
	.dw 0xf0c0, 0xc88c,	0xf0ff, 0xc88c,		0x21, 0
	.dw 0xf140, 0xc88c,	0xf17f, 0xc88c,		0x21, 0
	.dw 0xf1c0, 0xc88c,	0xf1ff, 0xc88c,		0x21, 0
	.dw 0xf240, 0xc88c,	0xf27f, 0xc88c,		0x21, 0
	.dw 0xf2c0, 0xc88c,	0xf2ff, 0xc88c,		0x21, 0
	.dw 0xf340, 0xc88c,	0xf37f, 0xc88c,		0x21, 0
	.dw 0xf3c0, 0xc88c,	0xf3ff, 0xc88c,		0x21, 0
	.dw 0xf440, 0xc88c,	0xf47f, 0xc88c,		0x21, 0
	.dw 0xf4c0, 0xc88c,	0xf4ff, 0xc88c,		0x21, 0
	.dw 0xf540, 0xc88c,	0xf57f, 0xc88c,		0x21, 0
	.dw 0xf5c0, 0xc88c,	0xf5ff, 0xc88c,		0x21, 0
	.dw 0xf640, 0xc88c,	0xf67f, 0xc88c,		0x21, 0
	.dw 0xf6c0, 0xc88c,	0xf6ff, 0xc88c,		0x21, 0
	.dw 0xf740, 0xc88c,	0xf77f, 0xc88c,		0x21, 0
	.dw 0xf7c0, 0xc88c,	0xf7ff, 0xc88c,		0x21, 0
	.dw 0xf840, 0xc88c,	0xf87f, 0xc88c,		0x21, 0
	.dw 0xf8c0, 0xc88c,	0xf8ff, 0xc88c,		0x21, 0
	.dw 0xf940, 0xc88c,	0xf97f, 0xc88c,		0x21, 0
	.dw 0xf9c0, 0xc88c,	0xffff, 0xc88c,		0x21, 0
	.dw 0x0040, 0xc88d,	0x007f, 0xc88d,		0x21, 0
	.dw 0x00c0, 0xc88d,	0x00ff, 0xc88d,		0x21, 0
	.dw 0x0140, 0xc88d,	0x017f, 0xc88d,		0x21, 0
	.dw 0x01c0, 0xc88d,	0x01ff, 0xc88d,		0x21, 0
	.dw 0x0240, 0xc88d,	0x027f, 0xc88d,		0x21, 0
	.dw 0x02c0, 0xc88d,	0x02ff, 0xc88d,		0x21, 0
	.dw 0x0340, 0xc88d,	0x037f, 0xc88d,		0x21, 0
	.dw 0x03c0, 0xc88d,	0x03ff, 0xc88d,		0x21, 0
	.dw 0x0440, 0xc88d,	0x047f, 0xc88d,		0x21, 0
	.dw 0x04c0, 0xc88d,	0x04ff, 0xc88d,		0x21, 0
	.dw 0x0540, 0xc88d,	0x057f, 0xc88d,		0x21, 0
	.dw 0x05c0, 0xc88d,	0x05ff, 0xc88d,		0x21, 0
	.dw 0x0640, 0xc88d,	0x067f, 0xc88d,		0x21, 0
	.dw 0x06c0, 0xc88d,	0x06ff, 0xc88d,		0x21, 0
	.dw 0x0740, 0xc88d,	0x077f, 0xc88d,		0x21, 0
	.dw 0x07c0, 0xc88d,	0x07ff, 0xc88d,		0x21, 0
	.dw 0x0840, 0xc88d,	0x087f, 0xc88d,		0x21, 0
	.dw 0x08c0, 0xc88d,	0x08ff, 0xc88d,		0x21, 0
	.dw 0x0940, 0xc88d,	0x097f, 0xc88d,		0x21, 0
	.dw 0x09c0, 0xc88d,	0x09ff, 0xc88d,		0x21, 0
	.dw 0x0a40, 0xc88d,	0x0a7f, 0xc88d,		0x21, 0
	.dw 0x0ac0, 0xc88d,	0x0aff, 0xc88d,		0x21, 0
	.dw 0x0b40, 0xc88d,	0x0b7f, 0xc88d,		0x21, 0
	.dw 0x0bc0, 0xc88d,	0x0bff, 0xc88d,		0x21, 0
	.dw 0x0c40, 0xc88d,	0x0c7f, 0xc88d,		0x21, 0
	.dw 0x0cc0, 0xc88d,	0x0cff, 0xc88d,		0x21, 0
	.dw 0x0d40, 0xc88d,	0x0d7f, 0xc88d,		0x21, 0
	.dw 0x0dc0, 0xc88d,	0x0dff, 0xc88d,		0x21, 0
	.dw 0x0e40, 0xc88d,	0x0e7f, 0xc88d,		0x21, 0
	.dw 0x0ec0, 0xc88d,	0x0eff, 0xc88d,		0x21, 0
	.dw 0x0f40, 0xc88d,	0x0f7f, 0xc88d,		0x21, 0
	.dw 0x0fc0, 0xc88d,	0x0fff, 0xc88d,		0x21, 0
	.dw 0x1040, 0xc88d,	0x107f, 0xc88d,		0x21, 0
	.dw 0x10c0, 0xc88d,	0x10ff, 0xc88d,		0x21, 0
	.dw 0x1140, 0xc88d,	0x117f, 0xc88d,		0x21, 0
	.dw 0x11c0, 0xc88d,	0x11ff, 0xc88d,		0x21, 0
	.dw 0x1240, 0xc88d,	0x127f, 0xc88d,		0x21, 0
	.dw 0x12c0, 0xc88d,	0x12ff, 0xc88d,		0x21, 0
	.dw 0x1340, 0xc88d,	0x137f, 0xc88d,		0x21, 0
	.dw 0x13c0, 0xc88d,	0x13ff, 0xc88d,		0x21, 0
	.dw 0x1440, 0xc88d,	0x147f, 0xc88d,		0x21, 0
	.dw 0x14c0, 0xc88d,	0x14ff, 0xc88d,		0x21, 0
	.dw 0x1540, 0xc88d,	0x157f, 0xc88d,		0x21, 0
	.dw 0x15c0, 0xc88d,	0x15ff, 0xc88d,		0x21, 0
	.dw 0x1640, 0xc88d,	0x167f, 0xc88d,		0x21, 0
	.dw 0x16c0, 0xc88d,	0x16ff, 0xc88d,		0x21, 0
	.dw 0x1740, 0xc88d,	0x177f, 0xc88d,		0x21, 0
	.dw 0x17c0, 0xc88d,	0x17ff, 0xc88d,		0x21, 0
	.dw 0x1840, 0xc88d,	0x187f, 0xc88d,		0x21, 0
	.dw 0x18c0, 0xc88d,	0x18ff, 0xc88d,		0x21, 0
	.dw 0x1940, 0xc88d,	0x197f, 0xc88d,		0x21, 0
	.dw 0x19c0, 0xc88d,	0x1fff, 0xc88d,		0x21, 0
	.dw 0x2040, 0xc88d,	0x207f, 0xc88d,		0x21, 0
	.dw 0x20c0, 0xc88d,	0x20ff, 0xc88d,		0x21, 0
	.dw 0x2140, 0xc88d,	0x217f, 0xc88d,		0x21, 0
	.dw 0x21c0, 0xc88d,	0x21ff, 0xc88d,		0x21, 0
	.dw 0x2240, 0xc88d,	0x227f, 0xc88d,		0x21, 0
	.dw 0x22c0, 0xc88d,	0x22ff, 0xc88d,		0x21, 0
	.dw 0x2340, 0xc88d,	0x237f, 0xc88d,		0x21, 0
	.dw 0x23c0, 0xc88d,	0x23ff, 0xc88d,		0x21, 0
	.dw 0x2440, 0xc88d,	0x247f, 0xc88d,		0x21, 0
	.dw 0x24c0, 0xc88d,	0x24ff, 0xc88d,		0x21, 0
	.dw 0x2540, 0xc88d,	0x257f, 0xc88d,		0x21, 0
	.dw 0x25c0, 0xc88d,	0x25ff, 0xc88d,		0x21, 0
	.dw 0x2640, 0xc88d,	0x267f, 0xc88d,		0x21, 0
	.dw 0x26c0, 0xc88d,	0x26ff, 0xc88d,		0x21, 0
	.dw 0x2740, 0xc88d,	0x277f, 0xc88d,		0x21, 0
	.dw 0x27c0, 0xc88d,	0x27ff, 0xc88d,		0x21, 0
	.dw 0x2840, 0xc88d,	0x287f, 0xc88d,		0x21, 0
	.dw 0x28c0, 0xc88d,	0x28ff, 0xc88d,		0x21, 0
	.dw 0x2940, 0xc88d,	0x297f, 0xc88d,		0x21, 0
	.dw 0x29c0, 0xc88d,	0x29ff, 0xc88d,		0x21, 0
	.dw 0x2a40, 0xc88d,	0x2a7f, 0xc88d,		0x21, 0
	.dw 0x2ac0, 0xc88d,	0x2aff, 0xc88d,		0x21, 0
	.dw 0x2b40, 0xc88d,	0x2b7f, 0xc88d,		0x21, 0
	.dw 0x2bc0, 0xc88d,	0x2bff, 0xc88d,		0x21, 0
	.dw 0x2c40, 0xc88d,	0x2c7f, 0xc88d,		0x21, 0
	.dw 0x2cc0, 0xc88d,	0x2cff, 0xc88d,		0x21, 0
	.dw 0x2d40, 0xc88d,	0x2d7f, 0xc88d,		0x21, 0
	.dw 0x2dc0, 0xc88d,	0x2dff, 0xc88d,		0x21, 0
	.dw 0x2e40, 0xc88d,	0x2e7f, 0xc88d,		0x21, 0
	.dw 0x2ec0, 0xc88d,	0x2eff, 0xc88d,		0x21, 0
	.dw 0x2f40, 0xc88d,	0x2f7f, 0xc88d,		0x21, 0
	.dw 0x2fc0, 0xc88d,	0x2fff, 0xc88d,		0x21, 0
	.dw 0x3040, 0xc88d,	0x307f, 0xc88d,		0x21, 0
	.dw 0x30c0, 0xc88d,	0x30ff, 0xc88d,		0x21, 0
	.dw 0x3140, 0xc88d,	0x317f, 0xc88d,		0x21, 0
	.dw 0x31c0, 0xc88d,	0x31ff, 0xc88d,		0x21, 0
	.dw 0x3240, 0xc88d,	0x327f, 0xc88d,		0x21, 0
	.dw 0x32c0, 0xc88d,	0x32ff, 0xc88d,		0x21, 0
	.dw 0x3340, 0xc88d,	0x337f, 0xc88d,		0x21, 0
	.dw 0x33c0, 0xc88d,	0x33ff, 0xc88d,		0x21, 0
	.dw 0x3440, 0xc88d,	0x347f, 0xc88d,		0x21, 0
	.dw 0x34c0, 0xc88d,	0x34ff, 0xc88d,		0x21, 0
	.dw 0x3540, 0xc88d,	0x357f, 0xc88d,		0x21, 0
	.dw 0x35c0, 0xc88d,	0x35ff, 0xc88d,		0x21, 0
	.dw 0x3640, 0xc88d,	0x367f, 0xc88d,		0x21, 0
	.dw 0x36c0, 0xc88d,	0x36ff, 0xc88d,		0x21, 0
	.dw 0x3740, 0xc88d,	0x377f, 0xc88d,		0x21, 0
	.dw 0x37c0, 0xc88d,	0x37ff, 0xc88d,		0x21, 0
	.dw 0x3840, 0xc88d,	0x387f, 0xc88d,		0x21, 0
	.dw 0x38c0, 0xc88d,	0x38ff, 0xc88d,		0x21, 0
	.dw 0x3940, 0xc88d,	0x397f, 0xc88d,		0x21, 0
	.dw 0x39c0, 0xc88d,	0x3fff, 0xc88d,		0x21, 0
	.dw 0x4040, 0xc88d,	0x407f, 0xc88d,		0x21, 0
	.dw 0x40c0, 0xc88d,	0x40ff, 0xc88d,		0x21, 0
	.dw 0x4140, 0xc88d,	0x417f, 0xc88d,		0x21, 0
	.dw 0x41c0, 0xc88d,	0x41ff, 0xc88d,		0x21, 0
	.dw 0x4240, 0xc88d,	0x427f, 0xc88d,		0x21, 0
	.dw 0x42c0, 0xc88d,	0x42ff, 0xc88d,		0x21, 0
	.dw 0x4340, 0xc88d,	0x437f, 0xc88d,		0x21, 0
	.dw 0x43c0, 0xc88d,	0x43ff, 0xc88d,		0x21, 0
	.dw 0x4440, 0xc88d,	0x447f, 0xc88d,		0x21, 0
	.dw 0x44c0, 0xc88d,	0x44ff, 0xc88d,		0x21, 0
	.dw 0x4540, 0xc88d,	0x457f, 0xc88d,		0x21, 0
	.dw 0x45c0, 0xc88d,	0x45ff, 0xc88d,		0x21, 0
	.dw 0x4640, 0xc88d,	0x467f, 0xc88d,		0x21, 0
	.dw 0x46c0, 0xc88d,	0x46ff, 0xc88d,		0x21, 0
	.dw 0x4740, 0xc88d,	0x477f, 0xc88d,		0x21, 0
	.dw 0x47c0, 0xc88d,	0x47ff, 0xc88d,		0x21, 0
	.dw 0x4840, 0xc88d,	0x487f, 0xc88d,		0x21, 0
	.dw 0x48c0, 0xc88d,	0x48ff, 0xc88d,		0x21, 0
	.dw 0x4940, 0xc88d,	0x497f, 0xc88d,		0x21, 0
	.dw 0x49c0, 0xc88d,	0x49ff, 0xc88d,		0x21, 0
	.dw 0x4a40, 0xc88d,	0x4a7f, 0xc88d,		0x21, 0
	.dw 0x4ac0, 0xc88d,	0x4aff, 0xc88d,		0x21, 0
	.dw 0x4b40, 0xc88d,	0x4b7f, 0xc88d,		0x21, 0
	.dw 0x4bc0, 0xc88d,	0x4bff, 0xc88d,		0x21, 0
	.dw 0x4c40, 0xc88d,	0x4c7f, 0xc88d,		0x21, 0
	.dw 0x4cc0, 0xc88d,	0x4cff, 0xc88d,		0x21, 0
	.dw 0x4d40, 0xc88d,	0x4d7f, 0xc88d,		0x21, 0
	.dw 0x4dc0, 0xc88d,	0x4dff, 0xc88d,		0x21, 0
	.dw 0x4e40, 0xc88d,	0x4e7f, 0xc88d,		0x21, 0
	.dw 0x4ec0, 0xc88d,	0x4eff, 0xc88d,		0x21, 0
	.dw 0x4f40, 0xc88d,	0x4f7f, 0xc88d,		0x21, 0
	.dw 0x4fc0, 0xc88d,	0x4fff, 0xc88d,		0x21, 0
	.dw 0x5040, 0xc88d,	0x507f, 0xc88d,		0x21, 0
	.dw 0x50c0, 0xc88d,	0x50ff, 0xc88d,		0x21, 0
	.dw 0x5140, 0xc88d,	0x517f, 0xc88d,		0x21, 0
	.dw 0x51c0, 0xc88d,	0x51ff, 0xc88d,		0x21, 0
	.dw 0x5240, 0xc88d,	0x527f, 0xc88d,		0x21, 0
	.dw 0x52c0, 0xc88d,	0x52ff, 0xc88d,		0x21, 0
	.dw 0x5340, 0xc88d,	0x537f, 0xc88d,		0x21, 0
	.dw 0x53c0, 0xc88d,	0x53ff, 0xc88d,		0x21, 0
	.dw 0x5440, 0xc88d,	0x547f, 0xc88d,		0x21, 0
	.dw 0x54c0, 0xc88d,	0x54ff, 0xc88d,		0x21, 0
	.dw 0x5540, 0xc88d,	0x557f, 0xc88d,		0x21, 0
	.dw 0x55c0, 0xc88d,	0x55ff, 0xc88d,		0x21, 0
	.dw 0x5640, 0xc88d,	0x567f, 0xc88d,		0x21, 0
	.dw 0x56c0, 0xc88d,	0x56ff, 0xc88d,		0x21, 0
	.dw 0x5740, 0xc88d,	0x577f, 0xc88d,		0x21, 0
	.dw 0x57c0, 0xc88d,	0x57ff, 0xc88d,		0x21, 0
	.dw 0x5840, 0xc88d,	0x587f, 0xc88d,		0x21, 0
	.dw 0x58c0, 0xc88d,	0x58ff, 0xc88d,		0x21, 0
	.dw 0x5940, 0xc88d,	0x597f, 0xc88d,		0x21, 0
	.dw 0x59c0, 0xc88d,	0x5fff, 0xc88d,		0x21, 0
	.dw 0x6040, 0xc88d,	0x607f, 0xc88d,		0x21, 0
	.dw 0x60c0, 0xc88d,	0x60ff, 0xc88d,		0x21, 0
	.dw 0x6140, 0xc88d,	0x617f, 0xc88d,		0x21, 0
	.dw 0x61c0, 0xc88d,	0x61ff, 0xc88d,		0x21, 0
	.dw 0x6240, 0xc88d,	0x627f, 0xc88d,		0x21, 0
	.dw 0x62c0, 0xc88d,	0x62ff, 0xc88d,		0x21, 0
	.dw 0x6340, 0xc88d,	0x637f, 0xc88d,		0x21, 0
	.dw 0x63c0, 0xc88d,	0x63ff, 0xc88d,		0x21, 0
	.dw 0x6440, 0xc88d,	0x647f, 0xc88d,		0x21, 0
	.dw 0x64c0, 0xc88d,	0x64ff, 0xc88d,		0x21, 0
	.dw 0x6540, 0xc88d,	0x657f, 0xc88d,		0x21, 0
	.dw 0x65c0, 0xc88d,	0x65ff, 0xc88d,		0x21, 0
	.dw 0x6640, 0xc88d,	0x667f, 0xc88d,		0x21, 0
	.dw 0x66c0, 0xc88d,	0x66ff, 0xc88d,		0x21, 0
	.dw 0x6740, 0xc88d,	0x677f, 0xc88d,		0x21, 0
	.dw 0x67c0, 0xc88d,	0x67ff, 0xc88d,		0x21, 0
	.dw 0x6840, 0xc88d,	0x687f, 0xc88d,		0x21, 0
	.dw 0x68c0, 0xc88d,	0x68ff, 0xc88d,		0x21, 0
	.dw 0x6940, 0xc88d,	0x697f, 0xc88d,		0x21, 0
	.dw 0x69c0, 0xc88d,	0x69ff, 0xc88d,		0x21, 0
	.dw 0x6a40, 0xc88d,	0x6a7f, 0xc88d,		0x21, 0
	.dw 0x6ac0, 0xc88d,	0x6aff, 0xc88d,		0x21, 0
	.dw 0x6b40, 0xc88d,	0x6b7f, 0xc88d,		0x21, 0
	.dw 0x6bc0, 0xc88d,	0x6bff, 0xc88d,		0x21, 0
	.dw 0x6c40, 0xc88d,	0x6c7f, 0xc88d,		0x21, 0
	.dw 0x6cc0, 0xc88d,	0x6cff, 0xc88d,		0x21, 0
	.dw 0x6d40, 0xc88d,	0x6d7f, 0xc88d,		0x21, 0
	.dw 0x6dc0, 0xc88d,	0x6dff, 0xc88d,		0x21, 0
	.dw 0x6e40, 0xc88d,	0x6e7f, 0xc88d,		0x21, 0
	.dw 0x6ec0, 0xc88d,	0x6eff, 0xc88d,		0x21, 0
	.dw 0x6f40, 0xc88d,	0x6f7f, 0xc88d,		0x21, 0
	.dw 0x6fc0, 0xc88d,	0x6fff, 0xc88d,		0x21, 0
	.dw 0x7040, 0xc88d,	0x707f, 0xc88d,		0x21, 0
	.dw 0x70c0, 0xc88d,	0x70ff, 0xc88d,		0x21, 0
	.dw 0x7140, 0xc88d,	0x717f, 0xc88d,		0x21, 0
	.dw 0x71c0, 0xc88d,	0x71ff, 0xc88d,		0x21, 0
	.dw 0x7240, 0xc88d,	0x727f, 0xc88d,		0x21, 0
	.dw 0x72c0, 0xc88d,	0x72ff, 0xc88d,		0x21, 0
	.dw 0x7340, 0xc88d,	0x737f, 0xc88d,		0x21, 0
	.dw 0x73c0, 0xc88d,	0x73ff, 0xc88d,		0x21, 0
	.dw 0x7440, 0xc88d,	0x747f, 0xc88d,		0x21, 0
	.dw 0x74c0, 0xc88d,	0x74ff, 0xc88d,		0x21, 0
	.dw 0x7540, 0xc88d,	0x757f, 0xc88d,		0x21, 0
	.dw 0x75c0, 0xc88d,	0x75ff, 0xc88d,		0x21, 0
	.dw 0x7640, 0xc88d,	0x767f, 0xc88d,		0x21, 0
	.dw 0x76c0, 0xc88d,	0x76ff, 0xc88d,		0x21, 0
	.dw 0x7740, 0xc88d,	0x777f, 0xc88d,		0x21, 0
	.dw 0x77c0, 0xc88d,	0x77ff, 0xc88d,		0x21, 0
	.dw 0x7840, 0xc88d,	0x787f, 0xc88d,		0x21, 0
	.dw 0x78c0, 0xc88d,	0x78ff, 0xc88d,		0x21, 0
	.dw 0x7940, 0xc88d,	0x797f, 0xc88d,		0x21, 0
	.dw 0x79c0, 0xc88d,	0x7fff, 0xc88d,		0x21, 0
	.dw 0x8040, 0xc88d,	0x807f, 0xc88d,		0x21, 0
	.dw 0x80c0, 0xc88d,	0x80ff, 0xc88d,		0x21, 0
	.dw 0x8140, 0xc88d,	0x817f, 0xc88d,		0x21, 0
	.dw 0x81c0, 0xc88d,	0x81ff, 0xc88d,		0x21, 0
	.dw 0x8240, 0xc88d,	0x827f, 0xc88d,		0x21, 0
	.dw 0x82c0, 0xc88d,	0x82ff, 0xc88d,		0x21, 0
	.dw 0x8340, 0xc88d,	0x837f, 0xc88d,		0x21, 0
	.dw 0x83c0, 0xc88d,	0x83ff, 0xc88d,		0x21, 0
	.dw 0x8440, 0xc88d,	0x847f, 0xc88d,		0x21, 0
	.dw 0x84c0, 0xc88d,	0x84ff, 0xc88d,		0x21, 0
	.dw 0x8540, 0xc88d,	0x857f, 0xc88d,		0x21, 0
	.dw 0x85c0, 0xc88d,	0x85ff, 0xc88d,		0x21, 0
	.dw 0x8640, 0xc88d,	0x867f, 0xc88d,		0x21, 0
	.dw 0x86c0, 0xc88d,	0x86ff, 0xc88d,		0x21, 0
	.dw 0x8740, 0xc88d,	0x877f, 0xc88d,		0x21, 0
	.dw 0x87c0, 0xc88d,	0x87ff, 0xc88d,		0x21, 0
	.dw 0x8840, 0xc88d,	0x887f, 0xc88d,		0x21, 0
	.dw 0x88c0, 0xc88d,	0x88ff, 0xc88d,		0x21, 0
	.dw 0x8940, 0xc88d,	0x897f, 0xc88d,		0x21, 0
	.dw 0x89c0, 0xc88d,	0x89ff, 0xc88d,		0x21, 0
	.dw 0x8a40, 0xc88d,	0x8a7f, 0xc88d,		0x21, 0
	.dw 0x8ac0, 0xc88d,	0x8aff, 0xc88d,		0x21, 0
	.dw 0x8b40, 0xc88d,	0x8b7f, 0xc88d,		0x21, 0
	.dw 0x8bc0, 0xc88d,	0x8bff, 0xc88d,		0x21, 0
	.dw 0x8c40, 0xc88d,	0x8c7f, 0xc88d,		0x21, 0
	.dw 0x8cc0, 0xc88d,	0x8cff, 0xc88d,		0x21, 0
	.dw 0x8d40, 0xc88d,	0x8d7f, 0xc88d,		0x21, 0
	.dw 0x8dc0, 0xc88d,	0x8dff, 0xc88d,		0x21, 0
	.dw 0x8e40, 0xc88d,	0x8e7f, 0xc88d,		0x21, 0
	.dw 0x8ec0, 0xc88d,	0x8eff, 0xc88d,		0x21, 0
	.dw 0x8f40, 0xc88d,	0x8f7f, 0xc88d,		0x21, 0
	.dw 0x8fc0, 0xc88d,	0x8fff, 0xc88d,		0x21, 0
	.dw 0x9040, 0xc88d,	0x907f, 0xc88d,		0x21, 0
	.dw 0x90c0, 0xc88d,	0x90ff, 0xc88d,		0x21, 0
	.dw 0x9140, 0xc88d,	0x917f, 0xc88d,		0x21, 0
	.dw 0x91c0, 0xc88d,	0x91ff, 0xc88d,		0x21, 0
	.dw 0x9240, 0xc88d,	0x927f, 0xc88d,		0x21, 0
	.dw 0x92c0, 0xc88d,	0x92ff, 0xc88d,		0x21, 0
	.dw 0x9340, 0xc88d,	0x937f, 0xc88d,		0x21, 0
	.dw 0x93c0, 0xc88d,	0x93ff, 0xc88d,		0x21, 0
	.dw 0x9440, 0xc88d,	0x947f, 0xc88d,		0x21, 0
	.dw 0x94c0, 0xc88d,	0x94ff, 0xc88d,		0x21, 0
	.dw 0x9540, 0xc88d,	0x957f, 0xc88d,		0x21, 0
	.dw 0x95c0, 0xc88d,	0x95ff, 0xc88d,		0x21, 0
	.dw 0x9640, 0xc88d,	0x967f, 0xc88d,		0x21, 0
	.dw 0x96c0, 0xc88d,	0x96ff, 0xc88d,		0x21, 0
	.dw 0x9740, 0xc88d,	0x977f, 0xc88d,		0x21, 0
	.dw 0x97c0, 0xc88d,	0x97ff, 0xc88d,		0x21, 0
	.dw 0x9840, 0xc88d,	0x987f, 0xc88d,		0x21, 0
	.dw 0x98c0, 0xc88d,	0x98ff, 0xc88d,		0x21, 0
	.dw 0x9940, 0xc88d,	0x997f, 0xc88d,		0x21, 0
	.dw 0x99c0, 0xc88d,	0x9fff, 0xc88d,		0x21, 0
	.dw 0xa040, 0xc88d,	0xa07f, 0xc88d,		0x21, 0
	.dw 0xa0c0, 0xc88d,	0xa0ff, 0xc88d,		0x21, 0
	.dw 0xa140, 0xc88d,	0xa17f, 0xc88d,		0x21, 0
	.dw 0xa1c0, 0xc88d,	0xa1ff, 0xc88d,		0x21, 0
	.dw 0xa240, 0xc88d,	0xa27f, 0xc88d,		0x21, 0
	.dw 0xa2c0, 0xc88d,	0xa2ff, 0xc88d,		0x21, 0
	.dw 0xa340, 0xc88d,	0xa37f, 0xc88d,		0x21, 0
	.dw 0xa3c0, 0xc88d,	0xa3ff, 0xc88d,		0x21, 0
	.dw 0xa440, 0xc88d,	0xa47f, 0xc88d,		0x21, 0
	.dw 0xa4c0, 0xc88d,	0xa4ff, 0xc88d,		0x21, 0
	.dw 0xa540, 0xc88d,	0xa57f, 0xc88d,		0x21, 0
	.dw 0xa5c0, 0xc88d,	0xa5ff, 0xc88d,		0x21, 0
	.dw 0xa640, 0xc88d,	0xa67f, 0xc88d,		0x21, 0
	.dw 0xa6c0, 0xc88d,	0xa6ff, 0xc88d,		0x21, 0
	.dw 0xa740, 0xc88d,	0xa77f, 0xc88d,		0x21, 0
	.dw 0xa7c0, 0xc88d,	0xa7ff, 0xc88d,		0x21, 0
	.dw 0xa840, 0xc88d,	0xa87f, 0xc88d,		0x21, 0
	.dw 0xa8c0, 0xc88d,	0xa8ff, 0xc88d,		0x21, 0
	.dw 0xa940, 0xc88d,	0xa97f, 0xc88d,		0x21, 0
	.dw 0xa9c0, 0xc88d,	0xa9ff, 0xc88d,		0x21, 0
	.dw 0xaa40, 0xc88d,	0xaa7f, 0xc88d,		0x21, 0
	.dw 0xaac0, 0xc88d,	0xaaff, 0xc88d,		0x21, 0
	.dw 0xab40, 0xc88d,	0xab7f, 0xc88d,		0x21, 0
	.dw 0xabc0, 0xc88d,	0xabff, 0xc88d,		0x21, 0
	.dw 0xac40, 0xc88d,	0xac7f, 0xc88d,		0x21, 0
	.dw 0xacc0, 0xc88d,	0xacff, 0xc88d,		0x21, 0
	.dw 0xad40, 0xc88d,	0xad7f, 0xc88d,		0x21, 0
	.dw 0xadc0, 0xc88d,	0xadff, 0xc88d,		0x21, 0
	.dw 0xae40, 0xc88d,	0xae7f, 0xc88d,		0x21, 0
	.dw 0xaec0, 0xc88d,	0xaeff, 0xc88d,		0x21, 0
	.dw 0xaf40, 0xc88d,	0xaf7f, 0xc88d,		0x21, 0
	.dw 0xafc0, 0xc88d,	0xafff, 0xc88d,		0x21, 0
	.dw 0xb040, 0xc88d,	0xb07f, 0xc88d,		0x21, 0
	.dw 0xb0c0, 0xc88d,	0xb0ff, 0xc88d,		0x21, 0
	.dw 0xb140, 0xc88d,	0xb17f, 0xc88d,		0x21, 0
	.dw 0xb1c0, 0xc88d,	0xb1ff, 0xc88d,		0x21, 0
	.dw 0xb240, 0xc88d,	0xb27f, 0xc88d,		0x21, 0
	.dw 0xb2c0, 0xc88d,	0xb2ff, 0xc88d,		0x21, 0
	.dw 0xb340, 0xc88d,	0xb37f, 0xc88d,		0x21, 0
	.dw 0xb3c0, 0xc88d,	0xb3ff, 0xc88d,		0x21, 0
	.dw 0xb440, 0xc88d,	0xb47f, 0xc88d,		0x21, 0
	.dw 0xb4c0, 0xc88d,	0xb4ff, 0xc88d,		0x21, 0
	.dw 0xb540, 0xc88d,	0xb57f, 0xc88d,		0x21, 0
	.dw 0xb5c0, 0xc88d,	0xb5ff, 0xc88d,		0x21, 0
	.dw 0xb640, 0xc88d,	0xb67f, 0xc88d,		0x21, 0
	.dw 0xb6c0, 0xc88d,	0xb6ff, 0xc88d,		0x21, 0
	.dw 0xb740, 0xc88d,	0xb77f, 0xc88d,		0x21, 0
	.dw 0xb7c0, 0xc88d,	0xb7ff, 0xc88d,		0x21, 0
	.dw 0xb840, 0xc88d,	0xb87f, 0xc88d,		0x21, 0
	.dw 0xb8c0, 0xc88d,	0xb8ff, 0xc88d,		0x21, 0
	.dw 0xb940, 0xc88d,	0xb97f, 0xc88d,		0x21, 0
	.dw 0xb9c0, 0xc88d,	0xbfff, 0xc88d,		0x21, 0
	.dw 0xc040, 0xc88d,	0xc07f, 0xc88d,		0x21, 0
	.dw 0xc0c0, 0xc88d,	0xc0ff, 0xc88d,		0x21, 0
	.dw 0xc140, 0xc88d,	0xc17f, 0xc88d,		0x21, 0
	.dw 0xc1c0, 0xc88d,	0xc1ff, 0xc88d,		0x21, 0
	.dw 0xc240, 0xc88d,	0xc27f, 0xc88d,		0x21, 0
	.dw 0xc2c0, 0xc88d,	0xc2ff, 0xc88d,		0x21, 0
	.dw 0xc340, 0xc88d,	0xc37f, 0xc88d,		0x21, 0
	.dw 0xc3c0, 0xc88d,	0xc3ff, 0xc88d,		0x21, 0
	.dw 0xc440, 0xc88d,	0xc47f, 0xc88d,		0x21, 0
	.dw 0xc4c0, 0xc88d,	0xc4ff, 0xc88d,		0x21, 0
	.dw 0xc540, 0xc88d,	0xc57f, 0xc88d,		0x21, 0
	.dw 0xc5c0, 0xc88d,	0xc5ff, 0xc88d,		0x21, 0
	.dw 0xc640, 0xc88d,	0xc67f, 0xc88d,		0x21, 0
	.dw 0xc6c0, 0xc88d,	0xc6ff, 0xc88d,		0x21, 0
	.dw 0xc740, 0xc88d,	0xc77f, 0xc88d,		0x21, 0
	.dw 0xc7c0, 0xc88d,	0xc7ff, 0xc88d,		0x21, 0
	.dw 0xc840, 0xc88d,	0xc87f, 0xc88d,		0x21, 0
	.dw 0xc8c0, 0xc88d,	0xc8ff, 0xc88d,		0x21, 0
	.dw 0xc940, 0xc88d,	0xc97f, 0xc88d,		0x21, 0
	.dw 0xc9c0, 0xc88d,	0xc9ff, 0xc88d,		0x21, 0
	.dw 0xca40, 0xc88d,	0xca7f, 0xc88d,		0x21, 0
	.dw 0xcac0, 0xc88d,	0xcaff, 0xc88d,		0x21, 0
	.dw 0xcb40, 0xc88d,	0xcb7f, 0xc88d,		0x21, 0
	.dw 0xcbc0, 0xc88d,	0xcbff, 0xc88d,		0x21, 0
	.dw 0xcc40, 0xc88d,	0xcc7f, 0xc88d,		0x21, 0
	.dw 0xccc0, 0xc88d,	0xccff, 0xc88d,		0x21, 0
	.dw 0xcd40, 0xc88d,	0xcd7f, 0xc88d,		0x21, 0
	.dw 0xcdc0, 0xc88d,	0xcdff, 0xc88d,		0x21, 0
	.dw 0xce40, 0xc88d,	0xce7f, 0xc88d,		0x21, 0
	.dw 0xcec0, 0xc88d,	0xceff, 0xc88d,		0x21, 0
	.dw 0xcf40, 0xc88d,	0xcf7f, 0xc88d,		0x21, 0
	.dw 0xcfc0, 0xc88d,	0xcfff, 0xc88d,		0x21, 0
	.dw 0xd040, 0xc88d,	0xd07f, 0xc88d,		0x21, 0
	.dw 0xd0c0, 0xc88d,	0xd0ff, 0xc88d,		0x21, 0
	.dw 0xd140, 0xc88d,	0xd17f, 0xc88d,		0x21, 0
	.dw 0xd1c0, 0xc88d,	0xd1ff, 0xc88d,		0x21, 0
	.dw 0xd240, 0xc88d,	0xd27f, 0xc88d,		0x21, 0
	.dw 0xd2c0, 0xc88d,	0xd2ff, 0xc88d,		0x21, 0
	.dw 0xd340, 0xc88d,	0xd37f, 0xc88d,		0x21, 0
	.dw 0xd3c0, 0xc88d,	0xd3ff, 0xc88d,		0x21, 0
	.dw 0xd440, 0xc88d,	0xd47f, 0xc88d,		0x21, 0
	.dw 0xd4c0, 0xc88d,	0xd4ff, 0xc88d,		0x21, 0
	.dw 0xd540, 0xc88d,	0xd57f, 0xc88d,		0x21, 0
	.dw 0xd5c0, 0xc88d,	0xd5ff, 0xc88d,		0x21, 0
	.dw 0xd640, 0xc88d,	0xd67f, 0xc88d,		0x21, 0
	.dw 0xd6c0, 0xc88d,	0xd6ff, 0xc88d,		0x21, 0
	.dw 0xd740, 0xc88d,	0xd77f, 0xc88d,		0x21, 0
	.dw 0xd7c0, 0xc88d,	0xd7ff, 0xc88d,		0x21, 0
	.dw 0xd840, 0xc88d,	0xd87f, 0xc88d,		0x21, 0
	.dw 0xd8c0, 0xc88d,	0xd8ff, 0xc88d,		0x21, 0
	.dw 0xd940, 0xc88d,	0xd97f, 0xc88d,		0x21, 0
	.dw 0xd9c0, 0xc88d,	0xdfff, 0xc88d,		0x21, 0
	.dw 0xe040, 0xc88d,	0xe07f, 0xc88d,		0x21, 0
	.dw 0xe0c0, 0xc88d,	0xe0ff, 0xc88d,		0x21, 0
	.dw 0xe140, 0xc88d,	0xe17f, 0xc88d,		0x21, 0
	.dw 0xe1c0, 0xc88d,	0xe1ff, 0xc88d,		0x21, 0
	.dw 0xe240, 0xc88d,	0xe27f, 0xc88d,		0x21, 0
	.dw 0xe2c0, 0xc88d,	0xe2ff, 0xc88d,		0x21, 0
	.dw 0xe340, 0xc88d,	0xe37f, 0xc88d,		0x21, 0
	.dw 0xe3c0, 0xc88d,	0xe3ff, 0xc88d,		0x21, 0
	.dw 0xe440, 0xc88d,	0xe47f, 0xc88d,		0x21, 0
	.dw 0xe4c0, 0xc88d,	0xe4ff, 0xc88d,		0x21, 0
	.dw 0xe540, 0xc88d,	0xe57f, 0xc88d,		0x21, 0
	.dw 0xe5c0, 0xc88d,	0xe5ff, 0xc88d,		0x21, 0
	.dw 0xe640, 0xc88d,	0xe67f, 0xc88d,		0x21, 0
	.dw 0xe6c0, 0xc88d,	0xe6ff, 0xc88d,		0x21, 0
	.dw 0xe740, 0xc88d,	0xe77f, 0xc88d,		0x21, 0
	.dw 0xe7c0, 0xc88d,	0xe7ff, 0xc88d,		0x21, 0
	.dw 0xe840, 0xc88d,	0xe87f, 0xc88d,		0x21, 0
	.dw 0xe8c0, 0xc88d,	0xe8ff, 0xc88d,		0x21, 0
	.dw 0xe940, 0xc88d,	0xe97f, 0xc88d,		0x21, 0
	.dw 0xe9c0, 0xc88d,	0xe9ff, 0xc88d,		0x21, 0
	.dw 0xea40, 0xc88d,	0xea7f, 0xc88d,		0x21, 0
	.dw 0xeac0, 0xc88d,	0xeaff, 0xc88d,		0x21, 0
	.dw 0xeb40, 0xc88d,	0xeb7f, 0xc88d,		0x21, 0
	.dw 0xebc0, 0xc88d,	0xebff, 0xc88d,		0x21, 0
	.dw 0xec40, 0xc88d,	0xec7f, 0xc88d,		0x21, 0
	.dw 0xecc0, 0xc88d,	0xecff, 0xc88d,		0x21, 0
	.dw 0xed40, 0xc88d,	0xed7f, 0xc88d,		0x21, 0
	.dw 0xedc0, 0xc88d,	0xedff, 0xc88d,		0x21, 0
	.dw 0xee40, 0xc88d,	0xee7f, 0xc88d,		0x21, 0
	.dw 0xeec0, 0xc88d,	0xeeff, 0xc88d,		0x21, 0
	.dw 0xef40, 0xc88d,	0xef7f, 0xc88d,		0x21, 0
	.dw 0xefc0, 0xc88d,	0xefff, 0xc88d,		0x21, 0
	.dw 0xf040, 0xc88d,	0xf07f, 0xc88d,		0x21, 0
	.dw 0xf0c0, 0xc88d,	0xf0ff, 0xc88d,		0x21, 0
	.dw 0xf140, 0xc88d,	0xf17f, 0xc88d,		0x21, 0
	.dw 0xf1c0, 0xc88d,	0xf1ff, 0xc88d,		0x21, 0
	.dw 0xf240, 0xc88d,	0xf27f, 0xc88d,		0x21, 0
	.dw 0xf2c0, 0xc88d,	0xf2ff, 0xc88d,		0x21, 0
	.dw 0xf340, 0xc88d,	0xf37f, 0xc88d,		0x21, 0
	.dw 0xf3c0, 0xc88d,	0xf3ff, 0xc88d,		0x21, 0
	.dw 0xf440, 0xc88d,	0xf47f, 0xc88d,		0x21, 0
	.dw 0xf4c0, 0xc88d,	0xf4ff, 0xc88d,		0x21, 0
	.dw 0xf540, 0xc88d,	0xf57f, 0xc88d,		0x21, 0
	.dw 0xf5c0, 0xc88d,	0xf5ff, 0xc88d,		0x21, 0
	.dw 0xf640, 0xc88d,	0xf67f, 0xc88d,		0x21, 0
	.dw 0xf6c0, 0xc88d,	0xf6ff, 0xc88d,		0x21, 0
	.dw 0xf740, 0xc88d,	0xf77f, 0xc88d,		0x21, 0
	.dw 0xf7c0, 0xc88d,	0xf7ff, 0xc88d,		0x21, 0
	.dw 0xf840, 0xc88d,	0xf87f, 0xc88d,		0x21, 0
	.dw 0xf8c0, 0xc88d,	0xf8ff, 0xc88d,		0x21, 0
	.dw 0xf940, 0xc88d,	0xf97f, 0xc88d,		0x21, 0
	.dw 0xf9c0, 0xc88d,	0xffff, 0xc88d,		0x21, 0
	.dw 0x0040, 0xc88e,	0x007f, 0xc88e,		0x21, 0
	.dw 0x00c0, 0xc88e,	0x00ff, 0xc88e,		0x21, 0
	.dw 0x0140, 0xc88e,	0x017f, 0xc88e,		0x21, 0
	.dw 0x01c0, 0xc88e,	0x01ff, 0xc88e,		0x21, 0
	.dw 0x0240, 0xc88e,	0x027f, 0xc88e,		0x21, 0
	.dw 0x02c0, 0xc88e,	0x02ff, 0xc88e,		0x21, 0
	.dw 0x0340, 0xc88e,	0x037f, 0xc88e,		0x21, 0
	.dw 0x03c0, 0xc88e,	0x03ff, 0xc88e,		0x21, 0
	.dw 0x0440, 0xc88e,	0x047f, 0xc88e,		0x21, 0
	.dw 0x04c0, 0xc88e,	0x04ff, 0xc88e,		0x21, 0
	.dw 0x0540, 0xc88e,	0x057f, 0xc88e,		0x21, 0
	.dw 0x05c0, 0xc88e,	0x05ff, 0xc88e,		0x21, 0
	.dw 0x0640, 0xc88e,	0x067f, 0xc88e,		0x21, 0
	.dw 0x06c0, 0xc88e,	0x06ff, 0xc88e,		0x21, 0
	.dw 0x0740, 0xc88e,	0x077f, 0xc88e,		0x21, 0
	.dw 0x07c0, 0xc88e,	0x07ff, 0xc88e,		0x21, 0
	.dw 0x0840, 0xc88e,	0x087f, 0xc88e,		0x21, 0
	.dw 0x08c0, 0xc88e,	0x08ff, 0xc88e,		0x21, 0
	.dw 0x0940, 0xc88e,	0x097f, 0xc88e,		0x21, 0
	.dw 0x09c0, 0xc88e,	0x09ff, 0xc88e,		0x21, 0
	.dw 0x0a40, 0xc88e,	0x0a7f, 0xc88e,		0x21, 0
	.dw 0x0ac0, 0xc88e,	0x0aff, 0xc88e,		0x21, 0
	.dw 0x0b40, 0xc88e,	0x0b7f, 0xc88e,		0x21, 0
	.dw 0x0bc0, 0xc88e,	0x0bff, 0xc88e,		0x21, 0
	.dw 0x0c40, 0xc88e,	0x0c7f, 0xc88e,		0x21, 0
	.dw 0x0cc0, 0xc88e,	0x0cff, 0xc88e,		0x21, 0
	.dw 0x0d40, 0xc88e,	0x0d7f, 0xc88e,		0x21, 0
	.dw 0x0dc0, 0xc88e,	0x0dff, 0xc88e,		0x21, 0
	.dw 0x0e40, 0xc88e,	0x0e7f, 0xc88e,		0x21, 0
	.dw 0x0ec0, 0xc88e,	0x0eff, 0xc88e,		0x21, 0
	.dw 0x0f40, 0xc88e,	0x0f7f, 0xc88e,		0x21, 0
	.dw 0x0fc0, 0xc88e,	0x0fff, 0xc88e,		0x21, 0
	.dw 0x1040, 0xc88e,	0x107f, 0xc88e,		0x21, 0
	.dw 0x10c0, 0xc88e,	0x10ff, 0xc88e,		0x21, 0
	.dw 0x1140, 0xc88e,	0x117f, 0xc88e,		0x21, 0
	.dw 0x11c0, 0xc88e,	0x11ff, 0xc88e,		0x21, 0
	.dw 0x1240, 0xc88e,	0x127f, 0xc88e,		0x21, 0
	.dw 0x12c0, 0xc88e,	0x12ff, 0xc88e,		0x21, 0
	.dw 0x1340, 0xc88e,	0x137f, 0xc88e,		0x21, 0
	.dw 0x13c0, 0xc88e,	0x13ff, 0xc88e,		0x21, 0
	.dw 0x1440, 0xc88e,	0x147f, 0xc88e,		0x21, 0
	.dw 0x14c0, 0xc88e,	0x14ff, 0xc88e,		0x21, 0
	.dw 0x1540, 0xc88e,	0x157f, 0xc88e,		0x21, 0
	.dw 0x15c0, 0xc88e,	0x15ff, 0xc88e,		0x21, 0
	.dw 0x1640, 0xc88e,	0x167f, 0xc88e,		0x21, 0
	.dw 0x16c0, 0xc88e,	0x16ff, 0xc88e,		0x21, 0
	.dw 0x1740, 0xc88e,	0x177f, 0xc88e,		0x21, 0
	.dw 0x17c0, 0xc88e,	0x17ff, 0xc88e,		0x21, 0
	.dw 0x1840, 0xc88e,	0x187f, 0xc88e,		0x21, 0
	.dw 0x18c0, 0xc88e,	0x18ff, 0xc88e,		0x21, 0
	.dw 0x1940, 0xc88e,	0x197f, 0xc88e,		0x21, 0
	.dw 0x19c0, 0xc88e,	0x1fff, 0xc88e,		0x21, 0
	.dw 0x2040, 0xc88e,	0x207f, 0xc88e,		0x21, 0
	.dw 0x20c0, 0xc88e,	0x20ff, 0xc88e,		0x21, 0
	.dw 0x2140, 0xc88e,	0x217f, 0xc88e,		0x21, 0
	.dw 0x21c0, 0xc88e,	0x21ff, 0xc88e,		0x21, 0
	.dw 0x2240, 0xc88e,	0x227f, 0xc88e,		0x21, 0
	.dw 0x22c0, 0xc88e,	0x22ff, 0xc88e,		0x21, 0
	.dw 0x2340, 0xc88e,	0x237f, 0xc88e,		0x21, 0
	.dw 0x23c0, 0xc88e,	0x23ff, 0xc88e,		0x21, 0
	.dw 0x2440, 0xc88e,	0x247f, 0xc88e,		0x21, 0
	.dw 0x24c0, 0xc88e,	0x24ff, 0xc88e,		0x21, 0
	.dw 0x2540, 0xc88e,	0x257f, 0xc88e,		0x21, 0
	.dw 0x25c0, 0xc88e,	0x25ff, 0xc88e,		0x21, 0
	.dw 0x2640, 0xc88e,	0x267f, 0xc88e,		0x21, 0
	.dw 0x26c0, 0xc88e,	0x26ff, 0xc88e,		0x21, 0
	.dw 0x2740, 0xc88e,	0x277f, 0xc88e,		0x21, 0
	.dw 0x27c0, 0xc88e,	0x27ff, 0xc88e,		0x21, 0
	.dw 0x2840, 0xc88e,	0x287f, 0xc88e,		0x21, 0
	.dw 0x28c0, 0xc88e,	0x28ff, 0xc88e,		0x21, 0
	.dw 0x2940, 0xc88e,	0x297f, 0xc88e,		0x21, 0
	.dw 0x29c0, 0xc88e,	0x29ff, 0xc88e,		0x21, 0
	.dw 0x2a40, 0xc88e,	0x2a7f, 0xc88e,		0x21, 0
	.dw 0x2ac0, 0xc88e,	0x2aff, 0xc88e,		0x21, 0
	.dw 0x2b40, 0xc88e,	0x2b7f, 0xc88e,		0x21, 0
	.dw 0x2bc0, 0xc88e,	0x2bff, 0xc88e,		0x21, 0
	.dw 0x2c40, 0xc88e,	0x2c7f, 0xc88e,		0x21, 0
	.dw 0x2cc0, 0xc88e,	0x2cff, 0xc88e,		0x21, 0
	.dw 0x2d40, 0xc88e,	0x2d7f, 0xc88e,		0x21, 0
	.dw 0x2dc0, 0xc88e,	0x2dff, 0xc88e,		0x21, 0
	.dw 0x2e40, 0xc88e,	0x2e7f, 0xc88e,		0x21, 0
	.dw 0x2ec0, 0xc88e,	0x2eff, 0xc88e,		0x21, 0
	.dw 0x2f40, 0xc88e,	0x2f7f, 0xc88e,		0x21, 0
	.dw 0x2fc0, 0xc88e,	0x2fff, 0xc88e,		0x21, 0
	.dw 0x3040, 0xc88e,	0x307f, 0xc88e,		0x21, 0
	.dw 0x30c0, 0xc88e,	0x30ff, 0xc88e,		0x21, 0
	.dw 0x3140, 0xc88e,	0x317f, 0xc88e,		0x21, 0
	.dw 0x31c0, 0xc88e,	0x31ff, 0xc88e,		0x21, 0
	.dw 0x3240, 0xc88e,	0x327f, 0xc88e,		0x21, 0
	.dw 0x32c0, 0xc88e,	0x32ff, 0xc88e,		0x21, 0
	.dw 0x3340, 0xc88e,	0x337f, 0xc88e,		0x21, 0
	.dw 0x33c0, 0xc88e,	0x33ff, 0xc88e,		0x21, 0
	.dw 0x3440, 0xc88e,	0x347f, 0xc88e,		0x21, 0
	.dw 0x34c0, 0xc88e,	0x34ff, 0xc88e,		0x21, 0
	.dw 0x3540, 0xc88e,	0x357f, 0xc88e,		0x21, 0
	.dw 0x35c0, 0xc88e,	0x35ff, 0xc88e,		0x21, 0
	.dw 0x3640, 0xc88e,	0x367f, 0xc88e,		0x21, 0
	.dw 0x36c0, 0xc88e,	0x36ff, 0xc88e,		0x21, 0
	.dw 0x3740, 0xc88e,	0x377f, 0xc88e,		0x21, 0
	.dw 0x37c0, 0xc88e,	0x37ff, 0xc88e,		0x21, 0
	.dw 0x3840, 0xc88e,	0x387f, 0xc88e,		0x21, 0
	.dw 0x38c0, 0xc88e,	0x38ff, 0xc88e,		0x21, 0
	.dw 0x3940, 0xc88e,	0x397f, 0xc88e,		0x21, 0
	.dw 0x39c0, 0xc88e,	0x3fff, 0xc88e,		0x21, 0
	.dw 0x4040, 0xc88e,	0x407f, 0xc88e,		0x21, 0
	.dw 0x40c0, 0xc88e,	0x40ff, 0xc88e,		0x21, 0
	.dw 0x4140, 0xc88e,	0x417f, 0xc88e,		0x21, 0
	.dw 0x41c0, 0xc88e,	0x41ff, 0xc88e,		0x21, 0
	.dw 0x4240, 0xc88e,	0x427f, 0xc88e,		0x21, 0
	.dw 0x42c0, 0xc88e,	0x42ff, 0xc88e,		0x21, 0
	.dw 0x4340, 0xc88e,	0x437f, 0xc88e,		0x21, 0
	.dw 0x43c0, 0xc88e,	0x43ff, 0xc88e,		0x21, 0
	.dw 0x4440, 0xc88e,	0x447f, 0xc88e,		0x21, 0
	.dw 0x44c0, 0xc88e,	0x44ff, 0xc88e,		0x21, 0
	.dw 0x4540, 0xc88e,	0x457f, 0xc88e,		0x21, 0
	.dw 0x45c0, 0xc88e,	0x45ff, 0xc88e,		0x21, 0
	.dw 0x4640, 0xc88e,	0x467f, 0xc88e,		0x21, 0
	.dw 0x46c0, 0xc88e,	0x46ff, 0xc88e,		0x21, 0
	.dw 0x4740, 0xc88e,	0x477f, 0xc88e,		0x21, 0
	.dw 0x47c0, 0xc88e,	0x47ff, 0xc88e,		0x21, 0
	.dw 0x4840, 0xc88e,	0x487f, 0xc88e,		0x21, 0
	.dw 0x48c0, 0xc88e,	0x48ff, 0xc88e,		0x21, 0
	.dw 0x4940, 0xc88e,	0x497f, 0xc88e,		0x21, 0
	.dw 0x49c0, 0xc88e,	0x49ff, 0xc88e,		0x21, 0
	.dw 0x4a40, 0xc88e,	0x4a7f, 0xc88e,		0x21, 0
	.dw 0x4ac0, 0xc88e,	0x4aff, 0xc88e,		0x21, 0
	.dw 0x4b40, 0xc88e,	0x4b7f, 0xc88e,		0x21, 0
	.dw 0x4bc0, 0xc88e,	0x4bff, 0xc88e,		0x21, 0
	.dw 0x4c40, 0xc88e,	0x4c7f, 0xc88e,		0x21, 0
	.dw 0x4cc0, 0xc88e,	0x4cff, 0xc88e,		0x21, 0
	.dw 0x4d40, 0xc88e,	0x4d7f, 0xc88e,		0x21, 0
	.dw 0x4dc0, 0xc88e,	0x4dff, 0xc88e,		0x21, 0
	.dw 0x4e40, 0xc88e,	0x4e7f, 0xc88e,		0x21, 0
	.dw 0x4ec0, 0xc88e,	0x4eff, 0xc88e,		0x21, 0
	.dw 0x4f40, 0xc88e,	0x4f7f, 0xc88e,		0x21, 0
	.dw 0x4fc0, 0xc88e,	0x4fff, 0xc88e,		0x21, 0
	.dw 0x5040, 0xc88e,	0x507f, 0xc88e,		0x21, 0
	.dw 0x50c0, 0xc88e,	0x50ff, 0xc88e,		0x21, 0
	.dw 0x5140, 0xc88e,	0x517f, 0xc88e,		0x21, 0
	.dw 0x51c0, 0xc88e,	0x51ff, 0xc88e,		0x21, 0
	.dw 0x5240, 0xc88e,	0x527f, 0xc88e,		0x21, 0
	.dw 0x52c0, 0xc88e,	0x52ff, 0xc88e,		0x21, 0
	.dw 0x5340, 0xc88e,	0x537f, 0xc88e,		0x21, 0
	.dw 0x53c0, 0xc88e,	0x53ff, 0xc88e,		0x21, 0
	.dw 0x5440, 0xc88e,	0x547f, 0xc88e,		0x21, 0
	.dw 0x54c0, 0xc88e,	0x54ff, 0xc88e,		0x21, 0
	.dw 0x5540, 0xc88e,	0x557f, 0xc88e,		0x21, 0
	.dw 0x55c0, 0xc88e,	0x55ff, 0xc88e,		0x21, 0
	.dw 0x5640, 0xc88e,	0x567f, 0xc88e,		0x21, 0
	.dw 0x56c0, 0xc88e,	0x56ff, 0xc88e,		0x21, 0
	.dw 0x5740, 0xc88e,	0x577f, 0xc88e,		0x21, 0
	.dw 0x57c0, 0xc88e,	0x57ff, 0xc88e,		0x21, 0
	.dw 0x5840, 0xc88e,	0x587f, 0xc88e,		0x21, 0
	.dw 0x58c0, 0xc88e,	0x58ff, 0xc88e,		0x21, 0
	.dw 0x5940, 0xc88e,	0x597f, 0xc88e,		0x21, 0
	.dw 0x59c0, 0xc88e,	0x5fff, 0xc88e,		0x21, 0
	.dw 0x6040, 0xc88e,	0x607f, 0xc88e,		0x21, 0
	.dw 0x60c0, 0xc88e,	0x60ff, 0xc88e,		0x21, 0
	.dw 0x6140, 0xc88e,	0x617f, 0xc88e,		0x21, 0
	.dw 0x61c0, 0xc88e,	0x61ff, 0xc88e,		0x21, 0
	.dw 0x6240, 0xc88e,	0x627f, 0xc88e,		0x21, 0
	.dw 0x62c0, 0xc88e,	0x62ff, 0xc88e,		0x21, 0
	.dw 0x6340, 0xc88e,	0x637f, 0xc88e,		0x21, 0
	.dw 0x63c0, 0xc88e,	0x63ff, 0xc88e,		0x21, 0
	.dw 0x6440, 0xc88e,	0x647f, 0xc88e,		0x21, 0
	.dw 0x64c0, 0xc88e,	0x64ff, 0xc88e,		0x21, 0
	.dw 0x6540, 0xc88e,	0x657f, 0xc88e,		0x21, 0
	.dw 0x65c0, 0xc88e,	0x65ff, 0xc88e,		0x21, 0
	.dw 0x6640, 0xc88e,	0x667f, 0xc88e,		0x21, 0
	.dw 0x66c0, 0xc88e,	0x66ff, 0xc88e,		0x21, 0
	.dw 0x6740, 0xc88e,	0x677f, 0xc88e,		0x21, 0
	.dw 0x67c0, 0xc88e,	0x67ff, 0xc88e,		0x21, 0
	.dw 0x6840, 0xc88e,	0x687f, 0xc88e,		0x21, 0
	.dw 0x68c0, 0xc88e,	0x68ff, 0xc88e,		0x21, 0
	.dw 0x6940, 0xc88e,	0x697f, 0xc88e,		0x21, 0
	.dw 0x69c0, 0xc88e,	0x69ff, 0xc88e,		0x21, 0
	.dw 0x6a40, 0xc88e,	0x6a7f, 0xc88e,		0x21, 0
	.dw 0x6ac0, 0xc88e,	0x6aff, 0xc88e,		0x21, 0
	.dw 0x6b40, 0xc88e,	0x6b7f, 0xc88e,		0x21, 0
	.dw 0x6bc0, 0xc88e,	0x6bff, 0xc88e,		0x21, 0
	.dw 0x6c40, 0xc88e,	0x6c7f, 0xc88e,		0x21, 0
	.dw 0x6cc0, 0xc88e,	0x6cff, 0xc88e,		0x21, 0
	.dw 0x6d40, 0xc88e,	0x6d7f, 0xc88e,		0x21, 0
	.dw 0x6dc0, 0xc88e,	0x6dff, 0xc88e,		0x21, 0
	.dw 0x6e40, 0xc88e,	0x6e7f, 0xc88e,		0x21, 0
	.dw 0x6ec0, 0xc88e,	0x6eff, 0xc88e,		0x21, 0
	.dw 0x6f40, 0xc88e,	0x6f7f, 0xc88e,		0x21, 0
	.dw 0x6fc0, 0xc88e,	0x6fff, 0xc88e,		0x21, 0
	.dw 0x7040, 0xc88e,	0x707f, 0xc88e,		0x21, 0
	.dw 0x70c0, 0xc88e,	0x70ff, 0xc88e,		0x21, 0
	.dw 0x7140, 0xc88e,	0x717f, 0xc88e,		0x21, 0
	.dw 0x71c0, 0xc88e,	0x71ff, 0xc88e,		0x21, 0
	.dw 0x7240, 0xc88e,	0x727f, 0xc88e,		0x21, 0
	.dw 0x72c0, 0xc88e,	0x72ff, 0xc88e,		0x21, 0
	.dw 0x7340, 0xc88e,	0x737f, 0xc88e,		0x21, 0
	.dw 0x73c0, 0xc88e,	0x73ff, 0xc88e,		0x21, 0
	.dw 0x7440, 0xc88e,	0x747f, 0xc88e,		0x21, 0
	.dw 0x74c0, 0xc88e,	0x74ff, 0xc88e,		0x21, 0
	.dw 0x7540, 0xc88e,	0x757f, 0xc88e,		0x21, 0
	.dw 0x75c0, 0xc88e,	0x75ff, 0xc88e,		0x21, 0
	.dw 0x7640, 0xc88e,	0x767f, 0xc88e,		0x21, 0
	.dw 0x76c0, 0xc88e,	0x76ff, 0xc88e,		0x21, 0
	.dw 0x7740, 0xc88e,	0x777f, 0xc88e,		0x21, 0
	.dw 0x77c0, 0xc88e,	0x77ff, 0xc88e,		0x21, 0
	.dw 0x7840, 0xc88e,	0x787f, 0xc88e,		0x21, 0
	.dw 0x78c0, 0xc88e,	0x78ff, 0xc88e,		0x21, 0
	.dw 0x7940, 0xc88e,	0x797f, 0xc88e,		0x21, 0
	.dw 0x79c0, 0xc88e,	0x7fff, 0xc88e,		0x21, 0
	.dw 0x8040, 0xc88e,	0x807f, 0xc88e,		0x21, 0
	.dw 0x80c0, 0xc88e,	0x80ff, 0xc88e,		0x21, 0
	.dw 0x8140, 0xc88e,	0x817f, 0xc88e,		0x21, 0
	.dw 0x81c0, 0xc88e,	0x81ff, 0xc88e,		0x21, 0
	.dw 0x8240, 0xc88e,	0x827f, 0xc88e,		0x21, 0
	.dw 0x82c0, 0xc88e,	0x82ff, 0xc88e,		0x21, 0
	.dw 0x8340, 0xc88e,	0x837f, 0xc88e,		0x21, 0
	.dw 0x83c0, 0xc88e,	0x83ff, 0xc88e,		0x21, 0
	.dw 0x8440, 0xc88e,	0x847f, 0xc88e,		0x21, 0
	.dw 0x84c0, 0xc88e,	0x84ff, 0xc88e,		0x21, 0
	.dw 0x8540, 0xc88e,	0x857f, 0xc88e,		0x21, 0
	.dw 0x85c0, 0xc88e,	0x85ff, 0xc88e,		0x21, 0
	.dw 0x8640, 0xc88e,	0x867f, 0xc88e,		0x21, 0
	.dw 0x86c0, 0xc88e,	0x86ff, 0xc88e,		0x21, 0
	.dw 0x8740, 0xc88e,	0x877f, 0xc88e,		0x21, 0
	.dw 0x87c0, 0xc88e,	0x87ff, 0xc88e,		0x21, 0
	.dw 0x8840, 0xc88e,	0x887f, 0xc88e,		0x21, 0
	.dw 0x88c0, 0xc88e,	0x88ff, 0xc88e,		0x21, 0
	.dw 0x8940, 0xc88e,	0x897f, 0xc88e,		0x21, 0
	.dw 0x89c0, 0xc88e,	0x89ff, 0xc88e,		0x21, 0
	.dw 0x8a40, 0xc88e,	0x8a7f, 0xc88e,		0x21, 0
	.dw 0x8ac0, 0xc88e,	0x8aff, 0xc88e,		0x21, 0
	.dw 0x8b40, 0xc88e,	0x8b7f, 0xc88e,		0x21, 0
	.dw 0x8bc0, 0xc88e,	0x8bff, 0xc88e,		0x21, 0
	.dw 0x8c40, 0xc88e,	0x8c7f, 0xc88e,		0x21, 0
	.dw 0x8cc0, 0xc88e,	0x8cff, 0xc88e,		0x21, 0
	.dw 0x8d40, 0xc88e,	0x8d7f, 0xc88e,		0x21, 0
	.dw 0x8dc0, 0xc88e,	0x8dff, 0xc88e,		0x21, 0
	.dw 0x8e40, 0xc88e,	0x8e7f, 0xc88e,		0x21, 0
	.dw 0x8ec0, 0xc88e,	0x8eff, 0xc88e,		0x21, 0
	.dw 0x8f40, 0xc88e,	0x8f7f, 0xc88e,		0x21, 0
	.dw 0x8fc0, 0xc88e,	0x8fff, 0xc88e,		0x21, 0
	.dw 0x9040, 0xc88e,	0x907f, 0xc88e,		0x21, 0
	.dw 0x90c0, 0xc88e,	0x90ff, 0xc88e,		0x21, 0
	.dw 0x9140, 0xc88e,	0x917f, 0xc88e,		0x21, 0
	.dw 0x91c0, 0xc88e,	0x91ff, 0xc88e,		0x21, 0
	.dw 0x9240, 0xc88e,	0x927f, 0xc88e,		0x21, 0
	.dw 0x92c0, 0xc88e,	0x92ff, 0xc88e,		0x21, 0
	.dw 0x9340, 0xc88e,	0x937f, 0xc88e,		0x21, 0
	.dw 0x93c0, 0xc88e,	0x93ff, 0xc88e,		0x21, 0
	.dw 0x9440, 0xc88e,	0x947f, 0xc88e,		0x21, 0
	.dw 0x94c0, 0xc88e,	0x94ff, 0xc88e,		0x21, 0
	.dw 0x9540, 0xc88e,	0x957f, 0xc88e,		0x21, 0
	.dw 0x95c0, 0xc88e,	0x95ff, 0xc88e,		0x21, 0
	.dw 0x9640, 0xc88e,	0x967f, 0xc88e,		0x21, 0
	.dw 0x96c0, 0xc88e,	0x96ff, 0xc88e,		0x21, 0
	.dw 0x9740, 0xc88e,	0x977f, 0xc88e,		0x21, 0
	.dw 0x97c0, 0xc88e,	0x97ff, 0xc88e,		0x21, 0
	.dw 0x9840, 0xc88e,	0x987f, 0xc88e,		0x21, 0
	.dw 0x98c0, 0xc88e,	0x98ff, 0xc88e,		0x21, 0
	.dw 0x9940, 0xc88e,	0x997f, 0xc88e,		0x21, 0
	.dw 0x99c0, 0xc88e,	0x9fff, 0xc88e,		0x21, 0
	.dw 0xa040, 0xc88e,	0xa07f, 0xc88e,		0x21, 0
	.dw 0xa0c0, 0xc88e,	0xa0ff, 0xc88e,		0x21, 0
	.dw 0xa140, 0xc88e,	0xa17f, 0xc88e,		0x21, 0
	.dw 0xa1c0, 0xc88e,	0xa1ff, 0xc88e,		0x21, 0
	.dw 0xa240, 0xc88e,	0xa27f, 0xc88e,		0x21, 0
	.dw 0xa2c0, 0xc88e,	0xa2ff, 0xc88e,		0x21, 0
	.dw 0xa340, 0xc88e,	0xa37f, 0xc88e,		0x21, 0
	.dw 0xa3c0, 0xc88e,	0xa3ff, 0xc88e,		0x21, 0
	.dw 0xa440, 0xc88e,	0xa47f, 0xc88e,		0x21, 0
	.dw 0xa4c0, 0xc88e,	0xa4ff, 0xc88e,		0x21, 0
	.dw 0xa540, 0xc88e,	0xa57f, 0xc88e,		0x21, 0
	.dw 0xa5c0, 0xc88e,	0xa5ff, 0xc88e,		0x21, 0
	.dw 0xa640, 0xc88e,	0xa67f, 0xc88e,		0x21, 0
	.dw 0xa6c0, 0xc88e,	0xa6ff, 0xc88e,		0x21, 0
	.dw 0xa740, 0xc88e,	0xa77f, 0xc88e,		0x21, 0
	.dw 0xa7c0, 0xc88e,	0xa7ff, 0xc88e,		0x21, 0
	.dw 0xa840, 0xc88e,	0xa87f, 0xc88e,		0x21, 0
	.dw 0xa8c0, 0xc88e,	0xa8ff, 0xc88e,		0x21, 0
	.dw 0xa940, 0xc88e,	0xa97f, 0xc88e,		0x21, 0
	.dw 0xa9c0, 0xc88e,	0xa9ff, 0xc88e,		0x21, 0
	.dw 0xaa40, 0xc88e,	0xaa7f, 0xc88e,		0x21, 0
	.dw 0xaac0, 0xc88e,	0xaaff, 0xc88e,		0x21, 0
	.dw 0xab40, 0xc88e,	0xab7f, 0xc88e,		0x21, 0
	.dw 0xabc0, 0xc88e,	0xabff, 0xc88e,		0x21, 0
	.dw 0xac40, 0xc88e,	0xac7f, 0xc88e,		0x21, 0
	.dw 0xacc0, 0xc88e,	0xacff, 0xc88e,		0x21, 0
	.dw 0xad40, 0xc88e,	0xad7f, 0xc88e,		0x21, 0
	.dw 0xadc0, 0xc88e,	0xadff, 0xc88e,		0x21, 0
	.dw 0xae40, 0xc88e,	0xae7f, 0xc88e,		0x21, 0
	.dw 0xaec0, 0xc88e,	0xaeff, 0xc88e,		0x21, 0
	.dw 0xaf40, 0xc88e,	0xaf7f, 0xc88e,		0x21, 0
	.dw 0xafc0, 0xc88e,	0xafff, 0xc88e,		0x21, 0
	.dw 0xb040, 0xc88e,	0xb07f, 0xc88e,		0x21, 0
	.dw 0xb0c0, 0xc88e,	0xb0ff, 0xc88e,		0x21, 0
	.dw 0xb140, 0xc88e,	0xb17f, 0xc88e,		0x21, 0
	.dw 0xb1c0, 0xc88e,	0xb1ff, 0xc88e,		0x21, 0
	.dw 0xb240, 0xc88e,	0xb27f, 0xc88e,		0x21, 0
	.dw 0xb2c0, 0xc88e,	0xb2ff, 0xc88e,		0x21, 0
	.dw 0xb340, 0xc88e,	0xb37f, 0xc88e,		0x21, 0
	.dw 0xb3c0, 0xc88e,	0xb3ff, 0xc88e,		0x21, 0
	.dw 0xb440, 0xc88e,	0xb47f, 0xc88e,		0x21, 0
	.dw 0xb4c0, 0xc88e,	0xb4ff, 0xc88e,		0x21, 0
	.dw 0xb540, 0xc88e,	0xb57f, 0xc88e,		0x21, 0
	.dw 0xb5c0, 0xc88e,	0xb5ff, 0xc88e,		0x21, 0
	.dw 0xb640, 0xc88e,	0xb67f, 0xc88e,		0x21, 0
	.dw 0xb6c0, 0xc88e,	0xb6ff, 0xc88e,		0x21, 0
	.dw 0xb740, 0xc88e,	0xb77f, 0xc88e,		0x21, 0
	.dw 0xb7c0, 0xc88e,	0xb7ff, 0xc88e,		0x21, 0
	.dw 0xb840, 0xc88e,	0xb87f, 0xc88e,		0x21, 0
	.dw 0xb8c0, 0xc88e,	0xb8ff, 0xc88e,		0x21, 0
	.dw 0xb940, 0xc88e,	0xb97f, 0xc88e,		0x21, 0
	.dw 0xb9c0, 0xc88e,	0xbfff, 0xc88e,		0x21, 0
	.dw 0xc040, 0xc88e,	0xc07f, 0xc88e,		0x21, 0
	.dw 0xc0c0, 0xc88e,	0xc0ff, 0xc88e,		0x21, 0
	.dw 0xc140, 0xc88e,	0xc17f, 0xc88e,		0x21, 0
	.dw 0xc1c0, 0xc88e,	0xc1ff, 0xc88e,		0x21, 0
	.dw 0xc240, 0xc88e,	0xc27f, 0xc88e,		0x21, 0
	.dw 0xc2c0, 0xc88e,	0xc2ff, 0xc88e,		0x21, 0
	.dw 0xc340, 0xc88e,	0xc37f, 0xc88e,		0x21, 0
	.dw 0xc3c0, 0xc88e,	0xc3ff, 0xc88e,		0x21, 0
	.dw 0xc440, 0xc88e,	0xc47f, 0xc88e,		0x21, 0
	.dw 0xc4c0, 0xc88e,	0xc4ff, 0xc88e,		0x21, 0
	.dw 0xc540, 0xc88e,	0xc57f, 0xc88e,		0x21, 0
	.dw 0xc5c0, 0xc88e,	0xc5ff, 0xc88e,		0x21, 0
	.dw 0xc640, 0xc88e,	0xc67f, 0xc88e,		0x21, 0
	.dw 0xc6c0, 0xc88e,	0xc6ff, 0xc88e,		0x21, 0
	.dw 0xc740, 0xc88e,	0xc77f, 0xc88e,		0x21, 0
	.dw 0xc7c0, 0xc88e,	0xc7ff, 0xc88e,		0x21, 0
	.dw 0xc840, 0xc88e,	0xc87f, 0xc88e,		0x21, 0
	.dw 0xc8c0, 0xc88e,	0xc8ff, 0xc88e,		0x21, 0
	.dw 0xc940, 0xc88e,	0xc97f, 0xc88e,		0x21, 0
	.dw 0xc9c0, 0xc88e,	0xc9ff, 0xc88e,		0x21, 0
	.dw 0xca40, 0xc88e,	0xca7f, 0xc88e,		0x21, 0
	.dw 0xcac0, 0xc88e,	0xcaff, 0xc88e,		0x21, 0
	.dw 0xcb40, 0xc88e,	0xcb7f, 0xc88e,		0x21, 0
	.dw 0xcbc0, 0xc88e,	0xcbff, 0xc88e,		0x21, 0
	.dw 0xcc40, 0xc88e,	0xcc7f, 0xc88e,		0x21, 0
	.dw 0xccc0, 0xc88e,	0xccff, 0xc88e,		0x21, 0
	.dw 0xcd40, 0xc88e,	0xcd7f, 0xc88e,		0x21, 0
	.dw 0xcdc0, 0xc88e,	0xcdff, 0xc88e,		0x21, 0
	.dw 0xce40, 0xc88e,	0xce7f, 0xc88e,		0x21, 0
	.dw 0xcec0, 0xc88e,	0xceff, 0xc88e,		0x21, 0
	.dw 0xcf40, 0xc88e,	0xcf7f, 0xc88e,		0x21, 0
	.dw 0xcfc0, 0xc88e,	0xcfff, 0xc88e,		0x21, 0
	.dw 0xd040, 0xc88e,	0xd07f, 0xc88e,		0x21, 0
	.dw 0xd0c0, 0xc88e,	0xd0ff, 0xc88e,		0x21, 0
	.dw 0xd140, 0xc88e,	0xd17f, 0xc88e,		0x21, 0
	.dw 0xd1c0, 0xc88e,	0xd1ff, 0xc88e,		0x21, 0
	.dw 0xd240, 0xc88e,	0xd27f, 0xc88e,		0x21, 0
	.dw 0xd2c0, 0xc88e,	0xd2ff, 0xc88e,		0x21, 0
	.dw 0xd340, 0xc88e,	0xd37f, 0xc88e,		0x21, 0
	.dw 0xd3c0, 0xc88e,	0xd3ff, 0xc88e,		0x21, 0
	.dw 0xd440, 0xc88e,	0xd47f, 0xc88e,		0x21, 0
	.dw 0xd4c0, 0xc88e,	0xd4ff, 0xc88e,		0x21, 0
	.dw 0xd540, 0xc88e,	0xd57f, 0xc88e,		0x21, 0
	.dw 0xd5c0, 0xc88e,	0xd5ff, 0xc88e,		0x21, 0
	.dw 0xd640, 0xc88e,	0xd67f, 0xc88e,		0x21, 0
	.dw 0xd6c0, 0xc88e,	0xd6ff, 0xc88e,		0x21, 0
	.dw 0xd740, 0xc88e,	0xd77f, 0xc88e,		0x21, 0
	.dw 0xd7c0, 0xc88e,	0xd7ff, 0xc88e,		0x21, 0
	.dw 0xd840, 0xc88e,	0xd87f, 0xc88e,		0x21, 0
	.dw 0xd8c0, 0xc88e,	0xd8ff, 0xc88e,		0x21, 0
	.dw 0xd940, 0xc88e,	0xd97f, 0xc88e,		0x21, 0
	.dw 0xd9c0, 0xc88e,	0xdfff, 0xc88e,		0x21, 0
	.dw 0xe040, 0xc88e,	0xe07f, 0xc88e,		0x21, 0
	.dw 0xe0c0, 0xc88e,	0xe0ff, 0xc88e,		0x21, 0
	.dw 0xe140, 0xc88e,	0xe17f, 0xc88e,		0x21, 0
	.dw 0xe1c0, 0xc88e,	0xe1ff, 0xc88e,		0x21, 0
	.dw 0xe240, 0xc88e,	0xe27f, 0xc88e,		0x21, 0
	.dw 0xe2c0, 0xc88e,	0xe2ff, 0xc88e,		0x21, 0
	.dw 0xe340, 0xc88e,	0xe37f, 0xc88e,		0x21, 0
	.dw 0xe3c0, 0xc88e,	0xe3ff, 0xc88e,		0x21, 0
	.dw 0xe440, 0xc88e,	0xe47f, 0xc88e,		0x21, 0
	.dw 0xe4c0, 0xc88e,	0xe4ff, 0xc88e,		0x21, 0
	.dw 0xe540, 0xc88e,	0xe57f, 0xc88e,		0x21, 0
	.dw 0xe5c0, 0xc88e,	0xe5ff, 0xc88e,		0x21, 0
	.dw 0xe640, 0xc88e,	0xe67f, 0xc88e,		0x21, 0
	.dw 0xe6c0, 0xc88e,	0xe6ff, 0xc88e,		0x21, 0
	.dw 0xe740, 0xc88e,	0xe77f, 0xc88e,		0x21, 0
	.dw 0xe7c0, 0xc88e,	0xe7ff, 0xc88e,		0x21, 0
	.dw 0xe840, 0xc88e,	0xe87f, 0xc88e,		0x21, 0
	.dw 0xe8c0, 0xc88e,	0xe8ff, 0xc88e,		0x21, 0
	.dw 0xe940, 0xc88e,	0xe97f, 0xc88e,		0x21, 0
	.dw 0xe9c0, 0xc88e,	0xe9ff, 0xc88e,		0x21, 0
	.dw 0xea40, 0xc88e,	0xea7f, 0xc88e,		0x21, 0
	.dw 0xeac0, 0xc88e,	0xeaff, 0xc88e,		0x21, 0
	.dw 0xeb40, 0xc88e,	0xeb7f, 0xc88e,		0x21, 0
	.dw 0xebc0, 0xc88e,	0xebff, 0xc88e,		0x21, 0
	.dw 0xec40, 0xc88e,	0xec7f, 0xc88e,		0x21, 0
	.dw 0xecc0, 0xc88e,	0xecff, 0xc88e,		0x21, 0
	.dw 0xed40, 0xc88e,	0xed7f, 0xc88e,		0x21, 0
	.dw 0xedc0, 0xc88e,	0xedff, 0xc88e,		0x21, 0
	.dw 0xee40, 0xc88e,	0xee7f, 0xc88e,		0x21, 0
	.dw 0xeec0, 0xc88e,	0xeeff, 0xc88e,		0x21, 0
	.dw 0xef40, 0xc88e,	0xef7f, 0xc88e,		0x21, 0
	.dw 0xefc0, 0xc88e,	0xefff, 0xc88e,		0x21, 0
	.dw 0xf040, 0xc88e,	0xf07f, 0xc88e,		0x21, 0
	.dw 0xf0c0, 0xc88e,	0xf0ff, 0xc88e,		0x21, 0
	.dw 0xf140, 0xc88e,	0xf17f, 0xc88e,		0x21, 0
	.dw 0xf1c0, 0xc88e,	0xf1ff, 0xc88e,		0x21, 0
	.dw 0xf240, 0xc88e,	0xf27f, 0xc88e,		0x21, 0
	.dw 0xf2c0, 0xc88e,	0xf2ff, 0xc88e,		0x21, 0
	.dw 0xf340, 0xc88e,	0xf37f, 0xc88e,		0x21, 0
	.dw 0xf3c0, 0xc88e,	0xf3ff, 0xc88e,		0x21, 0
	.dw 0xf440, 0xc88e,	0xf47f, 0xc88e,		0x21, 0
	.dw 0xf4c0, 0xc88e,	0xf4ff, 0xc88e,		0x21, 0
	.dw 0xf540, 0xc88e,	0xf57f, 0xc88e,		0x21, 0
	.dw 0xf5c0, 0xc88e,	0xf5ff, 0xc88e,		0x21, 0
	.dw 0xf640, 0xc88e,	0xf67f, 0xc88e,		0x21, 0
	.dw 0xf6c0, 0xc88e,	0xf6ff, 0xc88e,		0x21, 0
	.dw 0xf740, 0xc88e,	0xf77f, 0xc88e,		0x21, 0
	.dw 0xf7c0, 0xc88e,	0xf7ff, 0xc88e,		0x21, 0
	.dw 0xf840, 0xc88e,	0xf87f, 0xc88e,		0x21, 0
	.dw 0xf8c0, 0xc88e,	0xf8ff, 0xc88e,		0x21, 0
	.dw 0xf940, 0xc88e,	0xf97f, 0xc88e,		0x21, 0
	.dw 0xf9c0, 0xc88e,	0xffff, 0xc88e,		0x21, 0
	.dw 0x0040, 0xc88f,	0x007f, 0xc88f,		0x21, 0
	.dw 0x00c0, 0xc88f,	0x00ff, 0xc88f,		0x21, 0
	.dw 0x0140, 0xc88f,	0x017f, 0xc88f,		0x21, 0
	.dw 0x01c0, 0xc88f,	0x01ff, 0xc88f,		0x21, 0
	.dw 0x0240, 0xc88f,	0x027f, 0xc88f,		0x21, 0
	.dw 0x02c0, 0xc88f,	0x02ff, 0xc88f,		0x21, 0
	.dw 0x0340, 0xc88f,	0x037f, 0xc88f,		0x21, 0
	.dw 0x03c0, 0xc88f,	0x03ff, 0xc88f,		0x21, 0
	.dw 0x0440, 0xc88f,	0x047f, 0xc88f,		0x21, 0
	.dw 0x04c0, 0xc88f,	0x04ff, 0xc88f,		0x21, 0
	.dw 0x0540, 0xc88f,	0x057f, 0xc88f,		0x21, 0
	.dw 0x05c0, 0xc88f,	0x05ff, 0xc88f,		0x21, 0
	.dw 0x0640, 0xc88f,	0x067f, 0xc88f,		0x21, 0
	.dw 0x06c0, 0xc88f,	0x06ff, 0xc88f,		0x21, 0
	.dw 0x0740, 0xc88f,	0x077f, 0xc88f,		0x21, 0
	.dw 0x07c0, 0xc88f,	0x07ff, 0xc88f,		0x21, 0
	.dw 0x0840, 0xc88f,	0x087f, 0xc88f,		0x21, 0
	.dw 0x08c0, 0xc88f,	0x08ff, 0xc88f,		0x21, 0
	.dw 0x0940, 0xc88f,	0x097f, 0xc88f,		0x21, 0
	.dw 0x09c0, 0xc88f,	0x09ff, 0xc88f,		0x21, 0
	.dw 0x0a40, 0xc88f,	0x0a7f, 0xc88f,		0x21, 0
	.dw 0x0ac0, 0xc88f,	0x0aff, 0xc88f,		0x21, 0
	.dw 0x0b40, 0xc88f,	0x0b7f, 0xc88f,		0x21, 0
	.dw 0x0bc0, 0xc88f,	0x0bff, 0xc88f,		0x21, 0
	.dw 0x0c40, 0xc88f,	0x0c7f, 0xc88f,		0x21, 0
	.dw 0x0cc0, 0xc88f,	0x0cff, 0xc88f,		0x21, 0
	.dw 0x0d40, 0xc88f,	0x0d7f, 0xc88f,		0x21, 0
	.dw 0x0dc0, 0xc88f,	0x0dff, 0xc88f,		0x21, 0
	.dw 0x0e40, 0xc88f,	0x0e7f, 0xc88f,		0x21, 0
	.dw 0x0ec0, 0xc88f,	0x0eff, 0xc88f,		0x21, 0
	.dw 0x0f40, 0xc88f,	0x0f7f, 0xc88f,		0x21, 0
	.dw 0x0fc0, 0xc88f,	0x0fff, 0xc88f,		0x21, 0
	.dw 0x1040, 0xc88f,	0x107f, 0xc88f,		0x21, 0
	.dw 0x10c0, 0xc88f,	0x10ff, 0xc88f,		0x21, 0
	.dw 0x1140, 0xc88f,	0x117f, 0xc88f,		0x21, 0
	.dw 0x11c0, 0xc88f,	0x11ff, 0xc88f,		0x21, 0
	.dw 0x1240, 0xc88f,	0x127f, 0xc88f,		0x21, 0
	.dw 0x12c0, 0xc88f,	0x12ff, 0xc88f,		0x21, 0
	.dw 0x1340, 0xc88f,	0x137f, 0xc88f,		0x21, 0
	.dw 0x13c0, 0xc88f,	0x13ff, 0xc88f,		0x21, 0
	.dw 0x1440, 0xc88f,	0x147f, 0xc88f,		0x21, 0
	.dw 0x14c0, 0xc88f,	0x14ff, 0xc88f,		0x21, 0
	.dw 0x1540, 0xc88f,	0x157f, 0xc88f,		0x21, 0
	.dw 0x15c0, 0xc88f,	0x15ff, 0xc88f,		0x21, 0
	.dw 0x1640, 0xc88f,	0x167f, 0xc88f,		0x21, 0
	.dw 0x16c0, 0xc88f,	0x16ff, 0xc88f,		0x21, 0
	.dw 0x1740, 0xc88f,	0x177f, 0xc88f,		0x21, 0
	.dw 0x17c0, 0xc88f,	0x17ff, 0xc88f,		0x21, 0
	.dw 0x1840, 0xc88f,	0x187f, 0xc88f,		0x21, 0
	.dw 0x18c0, 0xc88f,	0x18ff, 0xc88f,		0x21, 0
	.dw 0x1940, 0xc88f,	0x197f, 0xc88f,		0x21, 0
	.dw 0x19c0, 0xc88f,	0x1fff, 0xc88f,		0x21, 0
	.dw 0x2040, 0xc88f,	0x207f, 0xc88f,		0x21, 0
	.dw 0x20c0, 0xc88f,	0x20ff, 0xc88f,		0x21, 0
	.dw 0x2140, 0xc88f,	0x217f, 0xc88f,		0x21, 0
	.dw 0x21c0, 0xc88f,	0x21ff, 0xc88f,		0x21, 0
	.dw 0x2240, 0xc88f,	0x227f, 0xc88f,		0x21, 0
	.dw 0x22c0, 0xc88f,	0x22ff, 0xc88f,		0x21, 0
	.dw 0x2340, 0xc88f,	0x237f, 0xc88f,		0x21, 0
	.dw 0x23c0, 0xc88f,	0x23ff, 0xc88f,		0x21, 0
	.dw 0x2440, 0xc88f,	0x247f, 0xc88f,		0x21, 0
	.dw 0x24c0, 0xc88f,	0x24ff, 0xc88f,		0x21, 0
	.dw 0x2540, 0xc88f,	0x257f, 0xc88f,		0x21, 0
	.dw 0x25c0, 0xc88f,	0x25ff, 0xc88f,		0x21, 0
	.dw 0x2640, 0xc88f,	0x267f, 0xc88f,		0x21, 0
	.dw 0x26c0, 0xc88f,	0x26ff, 0xc88f,		0x21, 0
	.dw 0x2740, 0xc88f,	0x277f, 0xc88f,		0x21, 0
	.dw 0x27c0, 0xc88f,	0x27ff, 0xc88f,		0x21, 0
	.dw 0x2840, 0xc88f,	0x287f, 0xc88f,		0x21, 0
	.dw 0x28c0, 0xc88f,	0x28ff, 0xc88f,		0x21, 0
	.dw 0x2940, 0xc88f,	0x297f, 0xc88f,		0x21, 0
	.dw 0x29c0, 0xc88f,	0x29ff, 0xc88f,		0x21, 0
	.dw 0x2a40, 0xc88f,	0x2a7f, 0xc88f,		0x21, 0
	.dw 0x2ac0, 0xc88f,	0x2aff, 0xc88f,		0x21, 0
	.dw 0x2b40, 0xc88f,	0x2b7f, 0xc88f,		0x21, 0
	.dw 0x2bc0, 0xc88f,	0x2bff, 0xc88f,		0x21, 0
	.dw 0x2c40, 0xc88f,	0x2c7f, 0xc88f,		0x21, 0
	.dw 0x2cc0, 0xc88f,	0x2cff, 0xc88f,		0x21, 0
	.dw 0x2d40, 0xc88f,	0x2d7f, 0xc88f,		0x21, 0
	.dw 0x2dc0, 0xc88f,	0x2dff, 0xc88f,		0x21, 0
	.dw 0x2e40, 0xc88f,	0x2e7f, 0xc88f,		0x21, 0
	.dw 0x2ec0, 0xc88f,	0x2eff, 0xc88f,		0x21, 0
	.dw 0x2f40, 0xc88f,	0x2f7f, 0xc88f,		0x21, 0
	.dw 0x2fc0, 0xc88f,	0x2fff, 0xc88f,		0x21, 0
	.dw 0x3040, 0xc88f,	0x307f, 0xc88f,		0x21, 0
	.dw 0x30c0, 0xc88f,	0x30ff, 0xc88f,		0x21, 0
	.dw 0x3140, 0xc88f,	0x317f, 0xc88f,		0x21, 0
	.dw 0x31c0, 0xc88f,	0x31ff, 0xc88f,		0x21, 0
	.dw 0x3240, 0xc88f,	0x327f, 0xc88f,		0x21, 0
	.dw 0x32c0, 0xc88f,	0x32ff, 0xc88f,		0x21, 0
	.dw 0x3340, 0xc88f,	0x337f, 0xc88f,		0x21, 0
	.dw 0x33c0, 0xc88f,	0x33ff, 0xc88f,		0x21, 0
	.dw 0x3440, 0xc88f,	0x347f, 0xc88f,		0x21, 0
	.dw 0x34c0, 0xc88f,	0x34ff, 0xc88f,		0x21, 0
	.dw 0x3540, 0xc88f,	0x357f, 0xc88f,		0x21, 0
	.dw 0x35c0, 0xc88f,	0x35ff, 0xc88f,		0x21, 0
	.dw 0x3640, 0xc88f,	0x367f, 0xc88f,		0x21, 0
	.dw 0x36c0, 0xc88f,	0x36ff, 0xc88f,		0x21, 0
	.dw 0x3740, 0xc88f,	0x377f, 0xc88f,		0x21, 0
	.dw 0x37c0, 0xc88f,	0x37ff, 0xc88f,		0x21, 0
	.dw 0x3840, 0xc88f,	0x387f, 0xc88f,		0x21, 0
	.dw 0x38c0, 0xc88f,	0x38ff, 0xc88f,		0x21, 0
	.dw 0x3940, 0xc88f,	0x397f, 0xc88f,		0x21, 0
	.dw 0x39c0, 0xc88f,	0xffff, 0xc88f,		0x21, 0
	.dw 0x1a00, 0xc890,	0x1fff, 0xc890,		0x21, 0
	.dw 0x3a00, 0xc890,	0x3fff, 0xc890,		0x21, 0
	.dw 0x5a00, 0xc890,	0x5fff, 0xc890,		0x21, 0
	.dw 0x7a00, 0xc890,	0x7fff, 0xc890,		0x21, 0
	.dw 0x9a00, 0xc890,	0x9fff, 0xc890,		0x21, 0
	.dw 0xba00, 0xc890,	0xbfff, 0xc890,		0x21, 0
	.dw 0xda00, 0xc890,	0xdfff, 0xc890,		0x21, 0
	.dw 0xfa00, 0xc890,	0xffff, 0xc890,		0x21, 0
	.dw 0x1a00, 0xc891,	0x1fff, 0xc891,		0x21, 0
	.dw 0x3a00, 0xc891,	0x3fff, 0xc891,		0x21, 0
	.dw 0x5a00, 0xc891,	0x5fff, 0xc891,		0x21, 0
	.dw 0x7a00, 0xc891,	0x7fff, 0xc891,		0x21, 0
	.dw 0x9a00, 0xc891,	0x9fff, 0xc891,		0x21, 0
	.dw 0xba00, 0xc891,	0xbfff, 0xc891,		0x21, 0
	.dw 0xda00, 0xc891,	0xdfff, 0xc891,		0x21, 0
	.dw 0xfa00, 0xc891,	0xffff, 0xc891,		0x21, 0
	.dw 0x1a00, 0xc892,	0x1fff, 0xc892,		0x21, 0
	.dw 0x3a00, 0xc892,	0x3fff, 0xc892,		0x21, 0
	.dw 0x5a00, 0xc892,	0x5fff, 0xc892,		0x21, 0
	.dw 0x7a00, 0xc892,	0x7fff, 0xc892,		0x21, 0
	.dw 0x9a00, 0xc892,	0x9fff, 0xc892,		0x21, 0
	.dw 0xba00, 0xc892,	0xbfff, 0xc892,		0x21, 0
	.dw 0xda00, 0xc892,	0xdfff, 0xc892,		0x21, 0
	.dw 0xfa00, 0xc892,	0xffff, 0xc893,		0x21, 0
	.dw 0x1a00, 0xc894,	0x1fff, 0xc894,		0x21, 0
	.dw 0x3a00, 0xc894,	0x3fff, 0xc894,		0x21, 0
	.dw 0x5a00, 0xc894,	0x5fff, 0xc894,		0x21, 0
	.dw 0x7a00, 0xc894,	0x7fff, 0xc894,		0x21, 0
	.dw 0x9a00, 0xc894,	0x9fff, 0xc894,		0x21, 0
	.dw 0xba00, 0xc894,	0xbfff, 0xc894,		0x21, 0
	.dw 0xda00, 0xc894,	0xdfff, 0xc894,		0x21, 0
	.dw 0xfa00, 0xc894,	0xffff, 0xc894,		0x21, 0
	.dw 0x1a00, 0xc895,	0x1fff, 0xc895,		0x21, 0
	.dw 0x3a00, 0xc895,	0x3fff, 0xc895,		0x21, 0
	.dw 0x5a00, 0xc895,	0x5fff, 0xc895,		0x21, 0
	.dw 0x7a00, 0xc895,	0x7fff, 0xc895,		0x21, 0
	.dw 0x9a00, 0xc895,	0x9fff, 0xc895,		0x21, 0
	.dw 0xba00, 0xc895,	0xbfff, 0xc895,		0x21, 0
	.dw 0xda00, 0xc895,	0xdfff, 0xc895,		0x21, 0
	.dw 0xfa00, 0xc895,	0xffff, 0xc895,		0x21, 0
	.dw 0x1a00, 0xc896,	0x1fff, 0xc896,		0x21, 0
	.dw 0x3a00, 0xc896,	0x3fff, 0xc896,		0x21, 0
	.dw 0x5a00, 0xc896,	0x5fff, 0xc896,		0x21, 0
	.dw 0x7a00, 0xc896,	0x7fff, 0xc896,		0x21, 0
	.dw 0x9a00, 0xc896,	0x9fff, 0xc896,		0x21, 0
	.dw 0xba00, 0xc896,	0xbfff, 0xc896,		0x21, 0
	.dw 0xda00, 0xc896,	0xdfff, 0xc896,		0x21, 0
	.dw 0xfa00, 0xc896,	0xffff, 0xc896,		0x21, 0
	.dw 0x1a00, 0xc897,	0x1fff, 0xc897,		0x21, 0
	.dw 0x3a00, 0xc897,	0x1fff, 0xc898,		0x21, 0
	.dw 0x2040, 0xc898,	0x207f, 0xc898,		0x21, 0
	.dw 0x20c0, 0xc898,	0x20ff, 0xc898,		0x21, 0
	.dw 0x2140, 0xc898,	0x217f, 0xc898,		0x21, 0
	.dw 0x21c0, 0xc898,	0x21ff, 0xc898,		0x21, 0
	.dw 0x2240, 0xc898,	0x227f, 0xc898,		0x21, 0
	.dw 0x22c0, 0xc898,	0x22ff, 0xc898,		0x21, 0
	.dw 0x2340, 0xc898,	0x237f, 0xc898,		0x21, 0
	.dw 0x23c0, 0xc898,	0x23ff, 0xc898,		0x21, 0
	.dw 0x2440, 0xc898,	0x247f, 0xc898,		0x21, 0
	.dw 0x24c0, 0xc898,	0x24ff, 0xc898,		0x21, 0
	.dw 0x2540, 0xc898,	0x257f, 0xc898,		0x21, 0
	.dw 0x25c0, 0xc898,	0x25ff, 0xc898,		0x21, 0
	.dw 0x2640, 0xc898,	0x267f, 0xc898,		0x21, 0
	.dw 0x26c0, 0xc898,	0x26ff, 0xc898,		0x21, 0
	.dw 0x2740, 0xc898,	0x277f, 0xc898,		0x21, 0
	.dw 0x27c0, 0xc898,	0x27ff, 0xc898,		0x21, 0
	.dw 0x2840, 0xc898,	0x287f, 0xc898,		0x21, 0
	.dw 0x28c0, 0xc898,	0x28ff, 0xc898,		0x21, 0
	.dw 0x2940, 0xc898,	0x297f, 0xc898,		0x21, 0
	.dw 0x29c0, 0xc898,	0x29ff, 0xc898,		0x21, 0
	.dw 0x2a40, 0xc898,	0x2a7f, 0xc898,		0x21, 0
	.dw 0x2ac0, 0xc898,	0x2aff, 0xc898,		0x21, 0
	.dw 0x2b40, 0xc898,	0x2b7f, 0xc898,		0x21, 0
	.dw 0x2bc0, 0xc898,	0x2bff, 0xc898,		0x21, 0
	.dw 0x2c40, 0xc898,	0x2c7f, 0xc898,		0x21, 0
	.dw 0x2cc0, 0xc898,	0x2cff, 0xc898,		0x21, 0
	.dw 0x2d40, 0xc898,	0x2d7f, 0xc898,		0x21, 0
	.dw 0x2dc0, 0xc898,	0x2dff, 0xc898,		0x21, 0
	.dw 0x2e40, 0xc898,	0x2e7f, 0xc898,		0x21, 0
	.dw 0x2ec0, 0xc898,	0x2eff, 0xc898,		0x21, 0
	.dw 0x2f40, 0xc898,	0x2f7f, 0xc898,		0x21, 0
	.dw 0x2fc0, 0xc898,	0x2fff, 0xc898,		0x21, 0
	.dw 0x3040, 0xc898,	0x307f, 0xc898,		0x21, 0
	.dw 0x30c0, 0xc898,	0x30ff, 0xc898,		0x21, 0
	.dw 0x3140, 0xc898,	0x317f, 0xc898,		0x21, 0
	.dw 0x31c0, 0xc898,	0x31ff, 0xc898,		0x21, 0
	.dw 0x3240, 0xc898,	0x327f, 0xc898,		0x21, 0
	.dw 0x32c0, 0xc898,	0x32ff, 0xc898,		0x21, 0
	.dw 0x3340, 0xc898,	0x337f, 0xc898,		0x21, 0
	.dw 0x33c0, 0xc898,	0x33ff, 0xc898,		0x21, 0
	.dw 0x3440, 0xc898,	0x347f, 0xc898,		0x21, 0
	.dw 0x34c0, 0xc898,	0x34ff, 0xc898,		0x21, 0
	.dw 0x3540, 0xc898,	0x357f, 0xc898,		0x21, 0
	.dw 0x35c0, 0xc898,	0x35ff, 0xc898,		0x21, 0
	.dw 0x3640, 0xc898,	0x367f, 0xc898,		0x21, 0
	.dw 0x36c0, 0xc898,	0x36ff, 0xc898,		0x21, 0
	.dw 0x3740, 0xc898,	0x377f, 0xc898,		0x21, 0
	.dw 0x37c0, 0xc898,	0x37ff, 0xc898,		0x21, 0
	.dw 0x3840, 0xc898,	0x387f, 0xc898,		0x21, 0
	.dw 0x38c0, 0xc898,	0x38ff, 0xc898,		0x21, 0
	.dw 0x3940, 0xc898,	0x397f, 0xc898,		0x21, 0
	.dw 0x39c0, 0xc898,	0x5fff, 0xc898,		0x21, 0
	.dw 0x6040, 0xc898,	0x607f, 0xc898,		0x21, 0
	.dw 0x60c0, 0xc898,	0x60ff, 0xc898,		0x21, 0
	.dw 0x6140, 0xc898,	0x617f, 0xc898,		0x21, 0
	.dw 0x61c0, 0xc898,	0x61ff, 0xc898,		0x21, 0
	.dw 0x6240, 0xc898,	0x627f, 0xc898,		0x21, 0
	.dw 0x62c0, 0xc898,	0x62ff, 0xc898,		0x21, 0
	.dw 0x6340, 0xc898,	0x637f, 0xc898,		0x21, 0
	.dw 0x63c0, 0xc898,	0x63ff, 0xc898,		0x21, 0
	.dw 0x6440, 0xc898,	0x647f, 0xc898,		0x21, 0
	.dw 0x64c0, 0xc898,	0x64ff, 0xc898,		0x21, 0
	.dw 0x6540, 0xc898,	0x657f, 0xc898,		0x21, 0
	.dw 0x65c0, 0xc898,	0x65ff, 0xc898,		0x21, 0
	.dw 0x6640, 0xc898,	0x667f, 0xc898,		0x21, 0
	.dw 0x66c0, 0xc898,	0x66ff, 0xc898,		0x21, 0
	.dw 0x6740, 0xc898,	0x677f, 0xc898,		0x21, 0
	.dw 0x67c0, 0xc898,	0x67ff, 0xc898,		0x21, 0
	.dw 0x6840, 0xc898,	0x687f, 0xc898,		0x21, 0
	.dw 0x68c0, 0xc898,	0x68ff, 0xc898,		0x21, 0
	.dw 0x6940, 0xc898,	0x697f, 0xc898,		0x21, 0
	.dw 0x69c0, 0xc898,	0x69ff, 0xc898,		0x21, 0
	.dw 0x6a40, 0xc898,	0x6a7f, 0xc898,		0x21, 0
	.dw 0x6ac0, 0xc898,	0x6aff, 0xc898,		0x21, 0
	.dw 0x6b40, 0xc898,	0x6b7f, 0xc898,		0x21, 0
	.dw 0x6bc0, 0xc898,	0x6bff, 0xc898,		0x21, 0
	.dw 0x6c40, 0xc898,	0x6c7f, 0xc898,		0x21, 0
	.dw 0x6cc0, 0xc898,	0x6cff, 0xc898,		0x21, 0
	.dw 0x6d40, 0xc898,	0x6d7f, 0xc898,		0x21, 0
	.dw 0x6dc0, 0xc898,	0x6dff, 0xc898,		0x21, 0
	.dw 0x6e40, 0xc898,	0x6e7f, 0xc898,		0x21, 0
	.dw 0x6ec0, 0xc898,	0x6eff, 0xc898,		0x21, 0
	.dw 0x6f40, 0xc898,	0x6f7f, 0xc898,		0x21, 0
	.dw 0x6fc0, 0xc898,	0x6fff, 0xc898,		0x21, 0
	.dw 0x7040, 0xc898,	0x707f, 0xc898,		0x21, 0
	.dw 0x70c0, 0xc898,	0x70ff, 0xc898,		0x21, 0
	.dw 0x7140, 0xc898,	0x717f, 0xc898,		0x21, 0
	.dw 0x71c0, 0xc898,	0x71ff, 0xc898,		0x21, 0
	.dw 0x7240, 0xc898,	0x727f, 0xc898,		0x21, 0
	.dw 0x72c0, 0xc898,	0x72ff, 0xc898,		0x21, 0
	.dw 0x7340, 0xc898,	0x737f, 0xc898,		0x21, 0
	.dw 0x73c0, 0xc898,	0x73ff, 0xc898,		0x21, 0
	.dw 0x7440, 0xc898,	0x747f, 0xc898,		0x21, 0
	.dw 0x74c0, 0xc898,	0x74ff, 0xc898,		0x21, 0
	.dw 0x7540, 0xc898,	0x757f, 0xc898,		0x21, 0
	.dw 0x75c0, 0xc898,	0x75ff, 0xc898,		0x21, 0
	.dw 0x7640, 0xc898,	0x767f, 0xc898,		0x21, 0
	.dw 0x76c0, 0xc898,	0x76ff, 0xc898,		0x21, 0
	.dw 0x7740, 0xc898,	0x777f, 0xc898,		0x21, 0
	.dw 0x77c0, 0xc898,	0x77ff, 0xc898,		0x21, 0
	.dw 0x7840, 0xc898,	0x787f, 0xc898,		0x21, 0
	.dw 0x78c0, 0xc898,	0x78ff, 0xc898,		0x21, 0
	.dw 0x7940, 0xc898,	0x797f, 0xc898,		0x21, 0
	.dw 0x79c0, 0xc898,	0x9fff, 0xc898,		0x21, 0
	.dw 0xa040, 0xc898,	0xa07f, 0xc898,		0x21, 0
	.dw 0xa0c0, 0xc898,	0xa0ff, 0xc898,		0x21, 0
	.dw 0xa140, 0xc898,	0xa17f, 0xc898,		0x21, 0
	.dw 0xa1c0, 0xc898,	0xa1ff, 0xc898,		0x21, 0
	.dw 0xa240, 0xc898,	0xa27f, 0xc898,		0x21, 0
	.dw 0xa2c0, 0xc898,	0xa2ff, 0xc898,		0x21, 0
	.dw 0xa340, 0xc898,	0xa37f, 0xc898,		0x21, 0
	.dw 0xa3c0, 0xc898,	0xa3ff, 0xc898,		0x21, 0
	.dw 0xa440, 0xc898,	0xa47f, 0xc898,		0x21, 0
	.dw 0xa4c0, 0xc898,	0xa4ff, 0xc898,		0x21, 0
	.dw 0xa540, 0xc898,	0xa57f, 0xc898,		0x21, 0
	.dw 0xa5c0, 0xc898,	0xa5ff, 0xc898,		0x21, 0
	.dw 0xa640, 0xc898,	0xa67f, 0xc898,		0x21, 0
	.dw 0xa6c0, 0xc898,	0xa6ff, 0xc898,		0x21, 0
	.dw 0xa740, 0xc898,	0xa77f, 0xc898,		0x21, 0
	.dw 0xa7c0, 0xc898,	0xa7ff, 0xc898,		0x21, 0
	.dw 0xa840, 0xc898,	0xa87f, 0xc898,		0x21, 0
	.dw 0xa8c0, 0xc898,	0xa8ff, 0xc898,		0x21, 0
	.dw 0xa940, 0xc898,	0xa97f, 0xc898,		0x21, 0
	.dw 0xa9c0, 0xc898,	0xa9ff, 0xc898,		0x21, 0
	.dw 0xaa40, 0xc898,	0xaa7f, 0xc898,		0x21, 0
	.dw 0xaac0, 0xc898,	0xaaff, 0xc898,		0x21, 0
	.dw 0xab40, 0xc898,	0xab7f, 0xc898,		0x21, 0
	.dw 0xabc0, 0xc898,	0xabff, 0xc898,		0x21, 0
	.dw 0xac40, 0xc898,	0xac7f, 0xc898,		0x21, 0
	.dw 0xacc0, 0xc898,	0xacff, 0xc898,		0x21, 0
	.dw 0xad40, 0xc898,	0xad7f, 0xc898,		0x21, 0
	.dw 0xadc0, 0xc898,	0xadff, 0xc898,		0x21, 0
	.dw 0xae40, 0xc898,	0xae7f, 0xc898,		0x21, 0
	.dw 0xaec0, 0xc898,	0xaeff, 0xc898,		0x21, 0
	.dw 0xaf40, 0xc898,	0xaf7f, 0xc898,		0x21, 0
	.dw 0xafc0, 0xc898,	0xafff, 0xc898,		0x21, 0
	.dw 0xb040, 0xc898,	0xb07f, 0xc898,		0x21, 0
	.dw 0xb0c0, 0xc898,	0xb0ff, 0xc898,		0x21, 0
	.dw 0xb140, 0xc898,	0xb17f, 0xc898,		0x21, 0
	.dw 0xb1c0, 0xc898,	0xb1ff, 0xc898,		0x21, 0
	.dw 0xb240, 0xc898,	0xb27f, 0xc898,		0x21, 0
	.dw 0xb2c0, 0xc898,	0xb2ff, 0xc898,		0x21, 0
	.dw 0xb340, 0xc898,	0xb37f, 0xc898,		0x21, 0
	.dw 0xb3c0, 0xc898,	0xb3ff, 0xc898,		0x21, 0
	.dw 0xb440, 0xc898,	0xb47f, 0xc898,		0x21, 0
	.dw 0xb4c0, 0xc898,	0xb4ff, 0xc898,		0x21, 0
	.dw 0xb540, 0xc898,	0xb57f, 0xc898,		0x21, 0
	.dw 0xb5c0, 0xc898,	0xb5ff, 0xc898,		0x21, 0
	.dw 0xb640, 0xc898,	0xb67f, 0xc898,		0x21, 0
	.dw 0xb6c0, 0xc898,	0xb6ff, 0xc898,		0x21, 0
	.dw 0xb740, 0xc898,	0xb77f, 0xc898,		0x21, 0
	.dw 0xb7c0, 0xc898,	0xb7ff, 0xc898,		0x21, 0
	.dw 0xb840, 0xc898,	0xb87f, 0xc898,		0x21, 0
	.dw 0xb8c0, 0xc898,	0xb8ff, 0xc898,		0x21, 0
	.dw 0xb940, 0xc898,	0xb97f, 0xc898,		0x21, 0
	.dw 0xb9c0, 0xc898,	0xdfff, 0xc898,		0x21, 0
	.dw 0xe040, 0xc898,	0xe07f, 0xc898,		0x21, 0
	.dw 0xe0c0, 0xc898,	0xe0ff, 0xc898,		0x21, 0
	.dw 0xe140, 0xc898,	0xe17f, 0xc898,		0x21, 0
	.dw 0xe1c0, 0xc898,	0xe1ff, 0xc898,		0x21, 0
	.dw 0xe240, 0xc898,	0xe27f, 0xc898,		0x21, 0
	.dw 0xe2c0, 0xc898,	0xe2ff, 0xc898,		0x21, 0
	.dw 0xe340, 0xc898,	0xe37f, 0xc898,		0x21, 0
	.dw 0xe3c0, 0xc898,	0xe3ff, 0xc898,		0x21, 0
	.dw 0xe440, 0xc898,	0xe47f, 0xc898,		0x21, 0
	.dw 0xe4c0, 0xc898,	0xe4ff, 0xc898,		0x21, 0
	.dw 0xe540, 0xc898,	0xe57f, 0xc898,		0x21, 0
	.dw 0xe5c0, 0xc898,	0xe5ff, 0xc898,		0x21, 0
	.dw 0xe640, 0xc898,	0xe67f, 0xc898,		0x21, 0
	.dw 0xe6c0, 0xc898,	0xe6ff, 0xc898,		0x21, 0
	.dw 0xe740, 0xc898,	0xe77f, 0xc898,		0x21, 0
	.dw 0xe7c0, 0xc898,	0xe7ff, 0xc898,		0x21, 0
	.dw 0xe840, 0xc898,	0xe87f, 0xc898,		0x21, 0
	.dw 0xe8c0, 0xc898,	0xe8ff, 0xc898,		0x21, 0
	.dw 0xe940, 0xc898,	0xe97f, 0xc898,		0x21, 0
	.dw 0xe9c0, 0xc898,	0xe9ff, 0xc898,		0x21, 0
	.dw 0xea40, 0xc898,	0xea7f, 0xc898,		0x21, 0
	.dw 0xeac0, 0xc898,	0xeaff, 0xc898,		0x21, 0
	.dw 0xeb40, 0xc898,	0xeb7f, 0xc898,		0x21, 0
	.dw 0xebc0, 0xc898,	0xebff, 0xc898,		0x21, 0
	.dw 0xec40, 0xc898,	0xec7f, 0xc898,		0x21, 0
	.dw 0xecc0, 0xc898,	0xecff, 0xc898,		0x21, 0
	.dw 0xed40, 0xc898,	0xed7f, 0xc898,		0x21, 0
	.dw 0xedc0, 0xc898,	0xedff, 0xc898,		0x21, 0
	.dw 0xee40, 0xc898,	0xee7f, 0xc898,		0x21, 0
	.dw 0xeec0, 0xc898,	0xeeff, 0xc898,		0x21, 0
	.dw 0xef40, 0xc898,	0xef7f, 0xc898,		0x21, 0
	.dw 0xefc0, 0xc898,	0xefff, 0xc898,		0x21, 0
	.dw 0xf040, 0xc898,	0xf07f, 0xc898,		0x21, 0
	.dw 0xf0c0, 0xc898,	0xf0ff, 0xc898,		0x21, 0
	.dw 0xf140, 0xc898,	0xf17f, 0xc898,		0x21, 0
	.dw 0xf1c0, 0xc898,	0xf1ff, 0xc898,		0x21, 0
	.dw 0xf240, 0xc898,	0xf27f, 0xc898,		0x21, 0
	.dw 0xf2c0, 0xc898,	0xf2ff, 0xc898,		0x21, 0
	.dw 0xf340, 0xc898,	0xf37f, 0xc898,		0x21, 0
	.dw 0xf3c0, 0xc898,	0xf3ff, 0xc898,		0x21, 0
	.dw 0xf440, 0xc898,	0xf47f, 0xc898,		0x21, 0
	.dw 0xf4c0, 0xc898,	0xf4ff, 0xc898,		0x21, 0
	.dw 0xf540, 0xc898,	0xf57f, 0xc898,		0x21, 0
	.dw 0xf5c0, 0xc898,	0xf5ff, 0xc898,		0x21, 0
	.dw 0xf640, 0xc898,	0xf67f, 0xc898,		0x21, 0
	.dw 0xf6c0, 0xc898,	0xf6ff, 0xc898,		0x21, 0
	.dw 0xf740, 0xc898,	0xf77f, 0xc898,		0x21, 0
	.dw 0xf7c0, 0xc898,	0xf7ff, 0xc898,		0x21, 0
	.dw 0xf840, 0xc898,	0xf87f, 0xc898,		0x21, 0
	.dw 0xf8c0, 0xc898,	0xf8ff, 0xc898,		0x21, 0
	.dw 0xf940, 0xc898,	0xf97f, 0xc898,		0x21, 0
	.dw 0xf9c0, 0xc898,	0x1fff, 0xc899,		0x21, 0
	.dw 0x2040, 0xc899,	0x207f, 0xc899,		0x21, 0
	.dw 0x20c0, 0xc899,	0x20ff, 0xc899,		0x21, 0
	.dw 0x2140, 0xc899,	0x217f, 0xc899,		0x21, 0
	.dw 0x21c0, 0xc899,	0x21ff, 0xc899,		0x21, 0
	.dw 0x2240, 0xc899,	0x227f, 0xc899,		0x21, 0
	.dw 0x22c0, 0xc899,	0x22ff, 0xc899,		0x21, 0
	.dw 0x2340, 0xc899,	0x237f, 0xc899,		0x21, 0
	.dw 0x23c0, 0xc899,	0x23ff, 0xc899,		0x21, 0
	.dw 0x2440, 0xc899,	0x247f, 0xc899,		0x21, 0
	.dw 0x24c0, 0xc899,	0x24ff, 0xc899,		0x21, 0
	.dw 0x2540, 0xc899,	0x257f, 0xc899,		0x21, 0
	.dw 0x25c0, 0xc899,	0x25ff, 0xc899,		0x21, 0
	.dw 0x2640, 0xc899,	0x267f, 0xc899,		0x21, 0
	.dw 0x26c0, 0xc899,	0x26ff, 0xc899,		0x21, 0
	.dw 0x2740, 0xc899,	0x277f, 0xc899,		0x21, 0
	.dw 0x27c0, 0xc899,	0x27ff, 0xc899,		0x21, 0
	.dw 0x2840, 0xc899,	0x287f, 0xc899,		0x21, 0
	.dw 0x28c0, 0xc899,	0x28ff, 0xc899,		0x21, 0
	.dw 0x2940, 0xc899,	0x297f, 0xc899,		0x21, 0
	.dw 0x29c0, 0xc899,	0x29ff, 0xc899,		0x21, 0
	.dw 0x2a40, 0xc899,	0x2a7f, 0xc899,		0x21, 0
	.dw 0x2ac0, 0xc899,	0x2aff, 0xc899,		0x21, 0
	.dw 0x2b40, 0xc899,	0x2b7f, 0xc899,		0x21, 0
	.dw 0x2bc0, 0xc899,	0x2bff, 0xc899,		0x21, 0
	.dw 0x2c40, 0xc899,	0x2c7f, 0xc899,		0x21, 0
	.dw 0x2cc0, 0xc899,	0x2cff, 0xc899,		0x21, 0
	.dw 0x2d40, 0xc899,	0x2d7f, 0xc899,		0x21, 0
	.dw 0x2dc0, 0xc899,	0x2dff, 0xc899,		0x21, 0
	.dw 0x2e40, 0xc899,	0x2e7f, 0xc899,		0x21, 0
	.dw 0x2ec0, 0xc899,	0x2eff, 0xc899,		0x21, 0
	.dw 0x2f40, 0xc899,	0x2f7f, 0xc899,		0x21, 0
	.dw 0x2fc0, 0xc899,	0x2fff, 0xc899,		0x21, 0
	.dw 0x3040, 0xc899,	0x307f, 0xc899,		0x21, 0
	.dw 0x30c0, 0xc899,	0x30ff, 0xc899,		0x21, 0
	.dw 0x3140, 0xc899,	0x317f, 0xc899,		0x21, 0
	.dw 0x31c0, 0xc899,	0x31ff, 0xc899,		0x21, 0
	.dw 0x3240, 0xc899,	0x327f, 0xc899,		0x21, 0
	.dw 0x32c0, 0xc899,	0x32ff, 0xc899,		0x21, 0
	.dw 0x3340, 0xc899,	0x337f, 0xc899,		0x21, 0
	.dw 0x33c0, 0xc899,	0x33ff, 0xc899,		0x21, 0
	.dw 0x3440, 0xc899,	0x347f, 0xc899,		0x21, 0
	.dw 0x34c0, 0xc899,	0x34ff, 0xc899,		0x21, 0
	.dw 0x3540, 0xc899,	0x357f, 0xc899,		0x21, 0
	.dw 0x35c0, 0xc899,	0x35ff, 0xc899,		0x21, 0
	.dw 0x3640, 0xc899,	0x367f, 0xc899,		0x21, 0
	.dw 0x36c0, 0xc899,	0x36ff, 0xc899,		0x21, 0
	.dw 0x3740, 0xc899,	0x377f, 0xc899,		0x21, 0
	.dw 0x37c0, 0xc899,	0x37ff, 0xc899,		0x21, 0
	.dw 0x3840, 0xc899,	0x387f, 0xc899,		0x21, 0
	.dw 0x38c0, 0xc899,	0x38ff, 0xc899,		0x21, 0
	.dw 0x3940, 0xc899,	0x397f, 0xc899,		0x21, 0
	.dw 0x39c0, 0xc899,	0x5fff, 0xc899,		0x21, 0
	.dw 0x6040, 0xc899,	0x607f, 0xc899,		0x21, 0
	.dw 0x60c0, 0xc899,	0x60ff, 0xc899,		0x21, 0
	.dw 0x6140, 0xc899,	0x617f, 0xc899,		0x21, 0
	.dw 0x61c0, 0xc899,	0x61ff, 0xc899,		0x21, 0
	.dw 0x6240, 0xc899,	0x627f, 0xc899,		0x21, 0
	.dw 0x62c0, 0xc899,	0x62ff, 0xc899,		0x21, 0
	.dw 0x6340, 0xc899,	0x637f, 0xc899,		0x21, 0
	.dw 0x63c0, 0xc899,	0x63ff, 0xc899,		0x21, 0
	.dw 0x6440, 0xc899,	0x647f, 0xc899,		0x21, 0
	.dw 0x64c0, 0xc899,	0x64ff, 0xc899,		0x21, 0
	.dw 0x6540, 0xc899,	0x657f, 0xc899,		0x21, 0
	.dw 0x65c0, 0xc899,	0x65ff, 0xc899,		0x21, 0
	.dw 0x6640, 0xc899,	0x667f, 0xc899,		0x21, 0
	.dw 0x66c0, 0xc899,	0x66ff, 0xc899,		0x21, 0
	.dw 0x6740, 0xc899,	0x677f, 0xc899,		0x21, 0
	.dw 0x67c0, 0xc899,	0x67ff, 0xc899,		0x21, 0
	.dw 0x6840, 0xc899,	0x687f, 0xc899,		0x21, 0
	.dw 0x68c0, 0xc899,	0x68ff, 0xc899,		0x21, 0
	.dw 0x6940, 0xc899,	0x697f, 0xc899,		0x21, 0
	.dw 0x69c0, 0xc899,	0x69ff, 0xc899,		0x21, 0
	.dw 0x6a40, 0xc899,	0x6a7f, 0xc899,		0x21, 0
	.dw 0x6ac0, 0xc899,	0x6aff, 0xc899,		0x21, 0
	.dw 0x6b40, 0xc899,	0x6b7f, 0xc899,		0x21, 0
	.dw 0x6bc0, 0xc899,	0x6bff, 0xc899,		0x21, 0
	.dw 0x6c40, 0xc899,	0x6c7f, 0xc899,		0x21, 0
	.dw 0x6cc0, 0xc899,	0x6cff, 0xc899,		0x21, 0
	.dw 0x6d40, 0xc899,	0x6d7f, 0xc899,		0x21, 0
	.dw 0x6dc0, 0xc899,	0x6dff, 0xc899,		0x21, 0
	.dw 0x6e40, 0xc899,	0x6e7f, 0xc899,		0x21, 0
	.dw 0x6ec0, 0xc899,	0x6eff, 0xc899,		0x21, 0
	.dw 0x6f40, 0xc899,	0x6f7f, 0xc899,		0x21, 0
	.dw 0x6fc0, 0xc899,	0x6fff, 0xc899,		0x21, 0
	.dw 0x7040, 0xc899,	0x707f, 0xc899,		0x21, 0
	.dw 0x70c0, 0xc899,	0x70ff, 0xc899,		0x21, 0
	.dw 0x7140, 0xc899,	0x717f, 0xc899,		0x21, 0
	.dw 0x71c0, 0xc899,	0x71ff, 0xc899,		0x21, 0
	.dw 0x7240, 0xc899,	0x727f, 0xc899,		0x21, 0
	.dw 0x72c0, 0xc899,	0x72ff, 0xc899,		0x21, 0
	.dw 0x7340, 0xc899,	0x737f, 0xc899,		0x21, 0
	.dw 0x73c0, 0xc899,	0x73ff, 0xc899,		0x21, 0
	.dw 0x7440, 0xc899,	0x747f, 0xc899,		0x21, 0
	.dw 0x74c0, 0xc899,	0x74ff, 0xc899,		0x21, 0
	.dw 0x7540, 0xc899,	0x757f, 0xc899,		0x21, 0
	.dw 0x75c0, 0xc899,	0x75ff, 0xc899,		0x21, 0
	.dw 0x7640, 0xc899,	0x767f, 0xc899,		0x21, 0
	.dw 0x76c0, 0xc899,	0x76ff, 0xc899,		0x21, 0
	.dw 0x7740, 0xc899,	0x777f, 0xc899,		0x21, 0
	.dw 0x77c0, 0xc899,	0x77ff, 0xc899,		0x21, 0
	.dw 0x7840, 0xc899,	0x787f, 0xc899,		0x21, 0
	.dw 0x78c0, 0xc899,	0x78ff, 0xc899,		0x21, 0
	.dw 0x7940, 0xc899,	0x797f, 0xc899,		0x21, 0
	.dw 0x79c0, 0xc899,	0x9fff, 0xc899,		0x21, 0
	.dw 0xa040, 0xc899,	0xa07f, 0xc899,		0x21, 0
	.dw 0xa0c0, 0xc899,	0xa0ff, 0xc899,		0x21, 0
	.dw 0xa140, 0xc899,	0xa17f, 0xc899,		0x21, 0
	.dw 0xa1c0, 0xc899,	0xa1ff, 0xc899,		0x21, 0
	.dw 0xa240, 0xc899,	0xa27f, 0xc899,		0x21, 0
	.dw 0xa2c0, 0xc899,	0xa2ff, 0xc899,		0x21, 0
	.dw 0xa340, 0xc899,	0xa37f, 0xc899,		0x21, 0
	.dw 0xa3c0, 0xc899,	0xa3ff, 0xc899,		0x21, 0
	.dw 0xa440, 0xc899,	0xa47f, 0xc899,		0x21, 0
	.dw 0xa4c0, 0xc899,	0xa4ff, 0xc899,		0x21, 0
	.dw 0xa540, 0xc899,	0xa57f, 0xc899,		0x21, 0
	.dw 0xa5c0, 0xc899,	0xa5ff, 0xc899,		0x21, 0
	.dw 0xa640, 0xc899,	0xa67f, 0xc899,		0x21, 0
	.dw 0xa6c0, 0xc899,	0xa6ff, 0xc899,		0x21, 0
	.dw 0xa740, 0xc899,	0xa77f, 0xc899,		0x21, 0
	.dw 0xa7c0, 0xc899,	0xa7ff, 0xc899,		0x21, 0
	.dw 0xa840, 0xc899,	0xa87f, 0xc899,		0x21, 0
	.dw 0xa8c0, 0xc899,	0xa8ff, 0xc899,		0x21, 0
	.dw 0xa940, 0xc899,	0xa97f, 0xc899,		0x21, 0
	.dw 0xa9c0, 0xc899,	0xa9ff, 0xc899,		0x21, 0
	.dw 0xaa40, 0xc899,	0xaa7f, 0xc899,		0x21, 0
	.dw 0xaac0, 0xc899,	0xaaff, 0xc899,		0x21, 0
	.dw 0xab40, 0xc899,	0xab7f, 0xc899,		0x21, 0
	.dw 0xabc0, 0xc899,	0xabff, 0xc899,		0x21, 0
	.dw 0xac40, 0xc899,	0xac7f, 0xc899,		0x21, 0
	.dw 0xacc0, 0xc899,	0xacff, 0xc899,		0x21, 0
	.dw 0xad40, 0xc899,	0xad7f, 0xc899,		0x21, 0
	.dw 0xadc0, 0xc899,	0xadff, 0xc899,		0x21, 0
	.dw 0xae40, 0xc899,	0xae7f, 0xc899,		0x21, 0
	.dw 0xaec0, 0xc899,	0xaeff, 0xc899,		0x21, 0
	.dw 0xaf40, 0xc899,	0xaf7f, 0xc899,		0x21, 0
	.dw 0xafc0, 0xc899,	0xafff, 0xc899,		0x21, 0
	.dw 0xb040, 0xc899,	0xb07f, 0xc899,		0x21, 0
	.dw 0xb0c0, 0xc899,	0xb0ff, 0xc899,		0x21, 0
	.dw 0xb140, 0xc899,	0xb17f, 0xc899,		0x21, 0
	.dw 0xb1c0, 0xc899,	0xb1ff, 0xc899,		0x21, 0
	.dw 0xb240, 0xc899,	0xb27f, 0xc899,		0x21, 0
	.dw 0xb2c0, 0xc899,	0xb2ff, 0xc899,		0x21, 0
	.dw 0xb340, 0xc899,	0xb37f, 0xc899,		0x21, 0
	.dw 0xb3c0, 0xc899,	0xb3ff, 0xc899,		0x21, 0
	.dw 0xb440, 0xc899,	0xb47f, 0xc899,		0x21, 0
	.dw 0xb4c0, 0xc899,	0xb4ff, 0xc899,		0x21, 0
	.dw 0xb540, 0xc899,	0xb57f, 0xc899,		0x21, 0
	.dw 0xb5c0, 0xc899,	0xb5ff, 0xc899,		0x21, 0
	.dw 0xb640, 0xc899,	0xb67f, 0xc899,		0x21, 0
	.dw 0xb6c0, 0xc899,	0xb6ff, 0xc899,		0x21, 0
	.dw 0xb740, 0xc899,	0xb77f, 0xc899,		0x21, 0
	.dw 0xb7c0, 0xc899,	0xb7ff, 0xc899,		0x21, 0
	.dw 0xb840, 0xc899,	0xb87f, 0xc899,		0x21, 0
	.dw 0xb8c0, 0xc899,	0xb8ff, 0xc899,		0x21, 0
	.dw 0xb940, 0xc899,	0xb97f, 0xc899,		0x21, 0
	.dw 0xb9c0, 0xc899,	0xdfff, 0xc899,		0x21, 0
	.dw 0xe040, 0xc899,	0xe07f, 0xc899,		0x21, 0
	.dw 0xe0c0, 0xc899,	0xe0ff, 0xc899,		0x21, 0
	.dw 0xe140, 0xc899,	0xe17f, 0xc899,		0x21, 0
	.dw 0xe1c0, 0xc899,	0xe1ff, 0xc899,		0x21, 0
	.dw 0xe240, 0xc899,	0xe27f, 0xc899,		0x21, 0
	.dw 0xe2c0, 0xc899,	0xe2ff, 0xc899,		0x21, 0
	.dw 0xe340, 0xc899,	0xe37f, 0xc899,		0x21, 0
	.dw 0xe3c0, 0xc899,	0xe3ff, 0xc899,		0x21, 0
	.dw 0xe440, 0xc899,	0xe47f, 0xc899,		0x21, 0
	.dw 0xe4c0, 0xc899,	0xe4ff, 0xc899,		0x21, 0
	.dw 0xe540, 0xc899,	0xe57f, 0xc899,		0x21, 0
	.dw 0xe5c0, 0xc899,	0xe5ff, 0xc899,		0x21, 0
	.dw 0xe640, 0xc899,	0xe67f, 0xc899,		0x21, 0
	.dw 0xe6c0, 0xc899,	0xe6ff, 0xc899,		0x21, 0
	.dw 0xe740, 0xc899,	0xe77f, 0xc899,		0x21, 0
	.dw 0xe7c0, 0xc899,	0xe7ff, 0xc899,		0x21, 0
	.dw 0xe840, 0xc899,	0xe87f, 0xc899,		0x21, 0
	.dw 0xe8c0, 0xc899,	0xe8ff, 0xc899,		0x21, 0
	.dw 0xe940, 0xc899,	0xe97f, 0xc899,		0x21, 0
	.dw 0xe9c0, 0xc899,	0xe9ff, 0xc899,		0x21, 0
	.dw 0xea40, 0xc899,	0xea7f, 0xc899,		0x21, 0
	.dw 0xeac0, 0xc899,	0xeaff, 0xc899,		0x21, 0
	.dw 0xeb40, 0xc899,	0xeb7f, 0xc899,		0x21, 0
	.dw 0xebc0, 0xc899,	0xebff, 0xc899,		0x21, 0
	.dw 0xec40, 0xc899,	0xec7f, 0xc899,		0x21, 0
	.dw 0xecc0, 0xc899,	0xecff, 0xc899,		0x21, 0
	.dw 0xed40, 0xc899,	0xed7f, 0xc899,		0x21, 0
	.dw 0xedc0, 0xc899,	0xedff, 0xc899,		0x21, 0
	.dw 0xee40, 0xc899,	0xee7f, 0xc899,		0x21, 0
	.dw 0xeec0, 0xc899,	0xeeff, 0xc899,		0x21, 0
	.dw 0xef40, 0xc899,	0xef7f, 0xc899,		0x21, 0
	.dw 0xefc0, 0xc899,	0xefff, 0xc899,		0x21, 0
	.dw 0xf040, 0xc899,	0xf07f, 0xc899,		0x21, 0
	.dw 0xf0c0, 0xc899,	0xf0ff, 0xc899,		0x21, 0
	.dw 0xf140, 0xc899,	0xf17f, 0xc899,		0x21, 0
	.dw 0xf1c0, 0xc899,	0xf1ff, 0xc899,		0x21, 0
	.dw 0xf240, 0xc899,	0xf27f, 0xc899,		0x21, 0
	.dw 0xf2c0, 0xc899,	0xf2ff, 0xc899,		0x21, 0
	.dw 0xf340, 0xc899,	0xf37f, 0xc899,		0x21, 0
	.dw 0xf3c0, 0xc899,	0xf3ff, 0xc899,		0x21, 0
	.dw 0xf440, 0xc899,	0xf47f, 0xc899,		0x21, 0
	.dw 0xf4c0, 0xc899,	0xf4ff, 0xc899,		0x21, 0
	.dw 0xf540, 0xc899,	0xf57f, 0xc899,		0x21, 0
	.dw 0xf5c0, 0xc899,	0xf5ff, 0xc899,		0x21, 0
	.dw 0xf640, 0xc899,	0xf67f, 0xc899,		0x21, 0
	.dw 0xf6c0, 0xc899,	0xf6ff, 0xc899,		0x21, 0
	.dw 0xf740, 0xc899,	0xf77f, 0xc899,		0x21, 0
	.dw 0xf7c0, 0xc899,	0xf7ff, 0xc899,		0x21, 0
	.dw 0xf840, 0xc899,	0xf87f, 0xc899,		0x21, 0
	.dw 0xf8c0, 0xc899,	0xf8ff, 0xc899,		0x21, 0
	.dw 0xf940, 0xc899,	0xf97f, 0xc899,		0x21, 0
	.dw 0xf9c0, 0xc899,	0x1fff, 0xc89a,		0x21, 0
	.dw 0x2040, 0xc89a,	0x207f, 0xc89a,		0x21, 0
	.dw 0x20c0, 0xc89a,	0x20ff, 0xc89a,		0x21, 0
	.dw 0x2140, 0xc89a,	0x217f, 0xc89a,		0x21, 0
	.dw 0x21c0, 0xc89a,	0x21ff, 0xc89a,		0x21, 0
	.dw 0x2240, 0xc89a,	0x227f, 0xc89a,		0x21, 0
	.dw 0x22c0, 0xc89a,	0x22ff, 0xc89a,		0x21, 0
	.dw 0x2340, 0xc89a,	0x237f, 0xc89a,		0x21, 0
	.dw 0x23c0, 0xc89a,	0x23ff, 0xc89a,		0x21, 0
	.dw 0x2440, 0xc89a,	0x247f, 0xc89a,		0x21, 0
	.dw 0x24c0, 0xc89a,	0x24ff, 0xc89a,		0x21, 0
	.dw 0x2540, 0xc89a,	0x257f, 0xc89a,		0x21, 0
	.dw 0x25c0, 0xc89a,	0x25ff, 0xc89a,		0x21, 0
	.dw 0x2640, 0xc89a,	0x267f, 0xc89a,		0x21, 0
	.dw 0x26c0, 0xc89a,	0x26ff, 0xc89a,		0x21, 0
	.dw 0x2740, 0xc89a,	0x277f, 0xc89a,		0x21, 0
	.dw 0x27c0, 0xc89a,	0x27ff, 0xc89a,		0x21, 0
	.dw 0x2840, 0xc89a,	0x287f, 0xc89a,		0x21, 0
	.dw 0x28c0, 0xc89a,	0x28ff, 0xc89a,		0x21, 0
	.dw 0x2940, 0xc89a,	0x297f, 0xc89a,		0x21, 0
	.dw 0x29c0, 0xc89a,	0x29ff, 0xc89a,		0x21, 0
	.dw 0x2a40, 0xc89a,	0x2a7f, 0xc89a,		0x21, 0
	.dw 0x2ac0, 0xc89a,	0x2aff, 0xc89a,		0x21, 0
	.dw 0x2b40, 0xc89a,	0x2b7f, 0xc89a,		0x21, 0
	.dw 0x2bc0, 0xc89a,	0x2bff, 0xc89a,		0x21, 0
	.dw 0x2c40, 0xc89a,	0x2c7f, 0xc89a,		0x21, 0
	.dw 0x2cc0, 0xc89a,	0x2cff, 0xc89a,		0x21, 0
	.dw 0x2d40, 0xc89a,	0x2d7f, 0xc89a,		0x21, 0
	.dw 0x2dc0, 0xc89a,	0x2dff, 0xc89a,		0x21, 0
	.dw 0x2e40, 0xc89a,	0x2e7f, 0xc89a,		0x21, 0
	.dw 0x2ec0, 0xc89a,	0x2eff, 0xc89a,		0x21, 0
	.dw 0x2f40, 0xc89a,	0x2f7f, 0xc89a,		0x21, 0
	.dw 0x2fc0, 0xc89a,	0x2fff, 0xc89a,		0x21, 0
	.dw 0x3040, 0xc89a,	0x307f, 0xc89a,		0x21, 0
	.dw 0x30c0, 0xc89a,	0x30ff, 0xc89a,		0x21, 0
	.dw 0x3140, 0xc89a,	0x317f, 0xc89a,		0x21, 0
	.dw 0x31c0, 0xc89a,	0x31ff, 0xc89a,		0x21, 0
	.dw 0x3240, 0xc89a,	0x327f, 0xc89a,		0x21, 0
	.dw 0x32c0, 0xc89a,	0x32ff, 0xc89a,		0x21, 0
	.dw 0x3340, 0xc89a,	0x337f, 0xc89a,		0x21, 0
	.dw 0x33c0, 0xc89a,	0x33ff, 0xc89a,		0x21, 0
	.dw 0x3440, 0xc89a,	0x347f, 0xc89a,		0x21, 0
	.dw 0x34c0, 0xc89a,	0x34ff, 0xc89a,		0x21, 0
	.dw 0x3540, 0xc89a,	0x357f, 0xc89a,		0x21, 0
	.dw 0x35c0, 0xc89a,	0x35ff, 0xc89a,		0x21, 0
	.dw 0x3640, 0xc89a,	0x367f, 0xc89a,		0x21, 0
	.dw 0x36c0, 0xc89a,	0x36ff, 0xc89a,		0x21, 0
	.dw 0x3740, 0xc89a,	0x377f, 0xc89a,		0x21, 0
	.dw 0x37c0, 0xc89a,	0x37ff, 0xc89a,		0x21, 0
	.dw 0x3840, 0xc89a,	0x387f, 0xc89a,		0x21, 0
	.dw 0x38c0, 0xc89a,	0x38ff, 0xc89a,		0x21, 0
	.dw 0x3940, 0xc89a,	0x397f, 0xc89a,		0x21, 0
	.dw 0x39c0, 0xc89a,	0x5fff, 0xc89a,		0x21, 0
	.dw 0x6040, 0xc89a,	0x607f, 0xc89a,		0x21, 0
	.dw 0x60c0, 0xc89a,	0x60ff, 0xc89a,		0x21, 0
	.dw 0x6140, 0xc89a,	0x617f, 0xc89a,		0x21, 0
	.dw 0x61c0, 0xc89a,	0x61ff, 0xc89a,		0x21, 0
	.dw 0x6240, 0xc89a,	0x627f, 0xc89a,		0x21, 0
	.dw 0x62c0, 0xc89a,	0x62ff, 0xc89a,		0x21, 0
	.dw 0x6340, 0xc89a,	0x637f, 0xc89a,		0x21, 0
	.dw 0x63c0, 0xc89a,	0x63ff, 0xc89a,		0x21, 0
	.dw 0x6440, 0xc89a,	0x647f, 0xc89a,		0x21, 0
	.dw 0x64c0, 0xc89a,	0x64ff, 0xc89a,		0x21, 0
	.dw 0x6540, 0xc89a,	0x657f, 0xc89a,		0x21, 0
	.dw 0x65c0, 0xc89a,	0x65ff, 0xc89a,		0x21, 0
	.dw 0x6640, 0xc89a,	0x667f, 0xc89a,		0x21, 0
	.dw 0x66c0, 0xc89a,	0x66ff, 0xc89a,		0x21, 0
	.dw 0x6740, 0xc89a,	0x677f, 0xc89a,		0x21, 0
	.dw 0x67c0, 0xc89a,	0x67ff, 0xc89a,		0x21, 0
	.dw 0x6840, 0xc89a,	0x687f, 0xc89a,		0x21, 0
	.dw 0x68c0, 0xc89a,	0x68ff, 0xc89a,		0x21, 0
	.dw 0x6940, 0xc89a,	0x697f, 0xc89a,		0x21, 0
	.dw 0x69c0, 0xc89a,	0x69ff, 0xc89a,		0x21, 0
	.dw 0x6a40, 0xc89a,	0x6a7f, 0xc89a,		0x21, 0
	.dw 0x6ac0, 0xc89a,	0x6aff, 0xc89a,		0x21, 0
	.dw 0x6b40, 0xc89a,	0x6b7f, 0xc89a,		0x21, 0
	.dw 0x6bc0, 0xc89a,	0x6bff, 0xc89a,		0x21, 0
	.dw 0x6c40, 0xc89a,	0x6c7f, 0xc89a,		0x21, 0
	.dw 0x6cc0, 0xc89a,	0x6cff, 0xc89a,		0x21, 0
	.dw 0x6d40, 0xc89a,	0x6d7f, 0xc89a,		0x21, 0
	.dw 0x6dc0, 0xc89a,	0x6dff, 0xc89a,		0x21, 0
	.dw 0x6e40, 0xc89a,	0x6e7f, 0xc89a,		0x21, 0
	.dw 0x6ec0, 0xc89a,	0x6eff, 0xc89a,		0x21, 0
	.dw 0x6f40, 0xc89a,	0x6f7f, 0xc89a,		0x21, 0
	.dw 0x6fc0, 0xc89a,	0x6fff, 0xc89a,		0x21, 0
	.dw 0x7040, 0xc89a,	0x707f, 0xc89a,		0x21, 0
	.dw 0x70c0, 0xc89a,	0x70ff, 0xc89a,		0x21, 0
	.dw 0x7140, 0xc89a,	0x717f, 0xc89a,		0x21, 0
	.dw 0x71c0, 0xc89a,	0x71ff, 0xc89a,		0x21, 0
	.dw 0x7240, 0xc89a,	0x727f, 0xc89a,		0x21, 0
	.dw 0x72c0, 0xc89a,	0x72ff, 0xc89a,		0x21, 0
	.dw 0x7340, 0xc89a,	0x737f, 0xc89a,		0x21, 0
	.dw 0x73c0, 0xc89a,	0x73ff, 0xc89a,		0x21, 0
	.dw 0x7440, 0xc89a,	0x747f, 0xc89a,		0x21, 0
	.dw 0x74c0, 0xc89a,	0x74ff, 0xc89a,		0x21, 0
	.dw 0x7540, 0xc89a,	0x757f, 0xc89a,		0x21, 0
	.dw 0x75c0, 0xc89a,	0x75ff, 0xc89a,		0x21, 0
	.dw 0x7640, 0xc89a,	0x767f, 0xc89a,		0x21, 0
	.dw 0x76c0, 0xc89a,	0x76ff, 0xc89a,		0x21, 0
	.dw 0x7740, 0xc89a,	0x777f, 0xc89a,		0x21, 0
	.dw 0x77c0, 0xc89a,	0x77ff, 0xc89a,		0x21, 0
	.dw 0x7840, 0xc89a,	0x787f, 0xc89a,		0x21, 0
	.dw 0x78c0, 0xc89a,	0x78ff, 0xc89a,		0x21, 0
	.dw 0x7940, 0xc89a,	0x797f, 0xc89a,		0x21, 0
	.dw 0x79c0, 0xc89a,	0x9fff, 0xc89a,		0x21, 0
	.dw 0xa040, 0xc89a,	0xa07f, 0xc89a,		0x21, 0
	.dw 0xa0c0, 0xc89a,	0xa0ff, 0xc89a,		0x21, 0
	.dw 0xa140, 0xc89a,	0xa17f, 0xc89a,		0x21, 0
	.dw 0xa1c0, 0xc89a,	0xa1ff, 0xc89a,		0x21, 0
	.dw 0xa240, 0xc89a,	0xa27f, 0xc89a,		0x21, 0
	.dw 0xa2c0, 0xc89a,	0xa2ff, 0xc89a,		0x21, 0
	.dw 0xa340, 0xc89a,	0xa37f, 0xc89a,		0x21, 0
	.dw 0xa3c0, 0xc89a,	0xa3ff, 0xc89a,		0x21, 0
	.dw 0xa440, 0xc89a,	0xa47f, 0xc89a,		0x21, 0
	.dw 0xa4c0, 0xc89a,	0xa4ff, 0xc89a,		0x21, 0
	.dw 0xa540, 0xc89a,	0xa57f, 0xc89a,		0x21, 0
	.dw 0xa5c0, 0xc89a,	0xa5ff, 0xc89a,		0x21, 0
	.dw 0xa640, 0xc89a,	0xa67f, 0xc89a,		0x21, 0
	.dw 0xa6c0, 0xc89a,	0xa6ff, 0xc89a,		0x21, 0
	.dw 0xa740, 0xc89a,	0xa77f, 0xc89a,		0x21, 0
	.dw 0xa7c0, 0xc89a,	0xa7ff, 0xc89a,		0x21, 0
	.dw 0xa840, 0xc89a,	0xa87f, 0xc89a,		0x21, 0
	.dw 0xa8c0, 0xc89a,	0xa8ff, 0xc89a,		0x21, 0
	.dw 0xa940, 0xc89a,	0xa97f, 0xc89a,		0x21, 0
	.dw 0xa9c0, 0xc89a,	0xa9ff, 0xc89a,		0x21, 0
	.dw 0xaa40, 0xc89a,	0xaa7f, 0xc89a,		0x21, 0
	.dw 0xaac0, 0xc89a,	0xaaff, 0xc89a,		0x21, 0
	.dw 0xab40, 0xc89a,	0xab7f, 0xc89a,		0x21, 0
	.dw 0xabc0, 0xc89a,	0xabff, 0xc89a,		0x21, 0
	.dw 0xac40, 0xc89a,	0xac7f, 0xc89a,		0x21, 0
	.dw 0xacc0, 0xc89a,	0xacff, 0xc89a,		0x21, 0
	.dw 0xad40, 0xc89a,	0xad7f, 0xc89a,		0x21, 0
	.dw 0xadc0, 0xc89a,	0xadff, 0xc89a,		0x21, 0
	.dw 0xae40, 0xc89a,	0xae7f, 0xc89a,		0x21, 0
	.dw 0xaec0, 0xc89a,	0xaeff, 0xc89a,		0x21, 0
	.dw 0xaf40, 0xc89a,	0xaf7f, 0xc89a,		0x21, 0
	.dw 0xafc0, 0xc89a,	0xafff, 0xc89a,		0x21, 0
	.dw 0xb040, 0xc89a,	0xb07f, 0xc89a,		0x21, 0
	.dw 0xb0c0, 0xc89a,	0xb0ff, 0xc89a,		0x21, 0
	.dw 0xb140, 0xc89a,	0xb17f, 0xc89a,		0x21, 0
	.dw 0xb1c0, 0xc89a,	0xb1ff, 0xc89a,		0x21, 0
	.dw 0xb240, 0xc89a,	0xb27f, 0xc89a,		0x21, 0
	.dw 0xb2c0, 0xc89a,	0xb2ff, 0xc89a,		0x21, 0
	.dw 0xb340, 0xc89a,	0xb37f, 0xc89a,		0x21, 0
	.dw 0xb3c0, 0xc89a,	0xb3ff, 0xc89a,		0x21, 0
	.dw 0xb440, 0xc89a,	0xb47f, 0xc89a,		0x21, 0
	.dw 0xb4c0, 0xc89a,	0xb4ff, 0xc89a,		0x21, 0
	.dw 0xb540, 0xc89a,	0xb57f, 0xc89a,		0x21, 0
	.dw 0xb5c0, 0xc89a,	0xb5ff, 0xc89a,		0x21, 0
	.dw 0xb640, 0xc89a,	0xb67f, 0xc89a,		0x21, 0
	.dw 0xb6c0, 0xc89a,	0xb6ff, 0xc89a,		0x21, 0
	.dw 0xb740, 0xc89a,	0xb77f, 0xc89a,		0x21, 0
	.dw 0xb7c0, 0xc89a,	0xb7ff, 0xc89a,		0x21, 0
	.dw 0xb840, 0xc89a,	0xb87f, 0xc89a,		0x21, 0
	.dw 0xb8c0, 0xc89a,	0xb8ff, 0xc89a,		0x21, 0
	.dw 0xb940, 0xc89a,	0xb97f, 0xc89a,		0x21, 0
	.dw 0xb9c0, 0xc89a,	0xdfff, 0xc89a,		0x21, 0
	.dw 0xe040, 0xc89a,	0xe07f, 0xc89a,		0x21, 0
	.dw 0xe0c0, 0xc89a,	0xe0ff, 0xc89a,		0x21, 0
	.dw 0xe140, 0xc89a,	0xe17f, 0xc89a,		0x21, 0
	.dw 0xe1c0, 0xc89a,	0xe1ff, 0xc89a,		0x21, 0
	.dw 0xe240, 0xc89a,	0xe27f, 0xc89a,		0x21, 0
	.dw 0xe2c0, 0xc89a,	0xe2ff, 0xc89a,		0x21, 0
	.dw 0xe340, 0xc89a,	0xe37f, 0xc89a,		0x21, 0
	.dw 0xe3c0, 0xc89a,	0xe3ff, 0xc89a,		0x21, 0
	.dw 0xe440, 0xc89a,	0xe47f, 0xc89a,		0x21, 0
	.dw 0xe4c0, 0xc89a,	0xe4ff, 0xc89a,		0x21, 0
	.dw 0xe540, 0xc89a,	0xe57f, 0xc89a,		0x21, 0
	.dw 0xe5c0, 0xc89a,	0xe5ff, 0xc89a,		0x21, 0
	.dw 0xe640, 0xc89a,	0xe67f, 0xc89a,		0x21, 0
	.dw 0xe6c0, 0xc89a,	0xe6ff, 0xc89a,		0x21, 0
	.dw 0xe740, 0xc89a,	0xe77f, 0xc89a,		0x21, 0
	.dw 0xe7c0, 0xc89a,	0xe7ff, 0xc89a,		0x21, 0
	.dw 0xe840, 0xc89a,	0xe87f, 0xc89a,		0x21, 0
	.dw 0xe8c0, 0xc89a,	0xe8ff, 0xc89a,		0x21, 0
	.dw 0xe940, 0xc89a,	0xe97f, 0xc89a,		0x21, 0
	.dw 0xe9c0, 0xc89a,	0xe9ff, 0xc89a,		0x21, 0
	.dw 0xea40, 0xc89a,	0xea7f, 0xc89a,		0x21, 0
	.dw 0xeac0, 0xc89a,	0xeaff, 0xc89a,		0x21, 0
	.dw 0xeb40, 0xc89a,	0xeb7f, 0xc89a,		0x21, 0
	.dw 0xebc0, 0xc89a,	0xebff, 0xc89a,		0x21, 0
	.dw 0xec40, 0xc89a,	0xec7f, 0xc89a,		0x21, 0
	.dw 0xecc0, 0xc89a,	0xecff, 0xc89a,		0x21, 0
	.dw 0xed40, 0xc89a,	0xed7f, 0xc89a,		0x21, 0
	.dw 0xedc0, 0xc89a,	0xedff, 0xc89a,		0x21, 0
	.dw 0xee40, 0xc89a,	0xee7f, 0xc89a,		0x21, 0
	.dw 0xeec0, 0xc89a,	0xeeff, 0xc89a,		0x21, 0
	.dw 0xef40, 0xc89a,	0xef7f, 0xc89a,		0x21, 0
	.dw 0xefc0, 0xc89a,	0xefff, 0xc89a,		0x21, 0
	.dw 0xf040, 0xc89a,	0xf07f, 0xc89a,		0x21, 0
	.dw 0xf0c0, 0xc89a,	0xf0ff, 0xc89a,		0x21, 0
	.dw 0xf140, 0xc89a,	0xf17f, 0xc89a,		0x21, 0
	.dw 0xf1c0, 0xc89a,	0xf1ff, 0xc89a,		0x21, 0
	.dw 0xf240, 0xc89a,	0xf27f, 0xc89a,		0x21, 0
	.dw 0xf2c0, 0xc89a,	0xf2ff, 0xc89a,		0x21, 0
	.dw 0xf340, 0xc89a,	0xf37f, 0xc89a,		0x21, 0
	.dw 0xf3c0, 0xc89a,	0xf3ff, 0xc89a,		0x21, 0
	.dw 0xf440, 0xc89a,	0xf47f, 0xc89a,		0x21, 0
	.dw 0xf4c0, 0xc89a,	0xf4ff, 0xc89a,		0x21, 0
	.dw 0xf540, 0xc89a,	0xf57f, 0xc89a,		0x21, 0
	.dw 0xf5c0, 0xc89a,	0xf5ff, 0xc89a,		0x21, 0
	.dw 0xf640, 0xc89a,	0xf67f, 0xc89a,		0x21, 0
	.dw 0xf6c0, 0xc89a,	0xf6ff, 0xc89a,		0x21, 0
	.dw 0xf740, 0xc89a,	0xf77f, 0xc89a,		0x21, 0
	.dw 0xf7c0, 0xc89a,	0xf7ff, 0xc89a,		0x21, 0
	.dw 0xf840, 0xc89a,	0xf87f, 0xc89a,		0x21, 0
	.dw 0xf8c0, 0xc89a,	0xf8ff, 0xc89a,		0x21, 0
	.dw 0xf940, 0xc89a,	0xf97f, 0xc89a,		0x21, 0
	.dw 0xf9c0, 0xc89a,	0xffff, 0xc89b,		0x21, 0
	.dw 0x0040, 0xc89c,	0x007f, 0xc89c,		0x21, 0
	.dw 0x00c0, 0xc89c,	0x00ff, 0xc89c,		0x21, 0
	.dw 0x0140, 0xc89c,	0x017f, 0xc89c,		0x21, 0
	.dw 0x01c0, 0xc89c,	0x01ff, 0xc89c,		0x21, 0
	.dw 0x0240, 0xc89c,	0x027f, 0xc89c,		0x21, 0
	.dw 0x02c0, 0xc89c,	0x02ff, 0xc89c,		0x21, 0
	.dw 0x0340, 0xc89c,	0x037f, 0xc89c,		0x21, 0
	.dw 0x03c0, 0xc89c,	0x03ff, 0xc89c,		0x21, 0
	.dw 0x0440, 0xc89c,	0x047f, 0xc89c,		0x21, 0
	.dw 0x04c0, 0xc89c,	0x04ff, 0xc89c,		0x21, 0
	.dw 0x0540, 0xc89c,	0x057f, 0xc89c,		0x21, 0
	.dw 0x05c0, 0xc89c,	0x05ff, 0xc89c,		0x21, 0
	.dw 0x0640, 0xc89c,	0x067f, 0xc89c,		0x21, 0
	.dw 0x06c0, 0xc89c,	0x06ff, 0xc89c,		0x21, 0
	.dw 0x0740, 0xc89c,	0x077f, 0xc89c,		0x21, 0
	.dw 0x07c0, 0xc89c,	0x07ff, 0xc89c,		0x21, 0
	.dw 0x0840, 0xc89c,	0x087f, 0xc89c,		0x21, 0
	.dw 0x08c0, 0xc89c,	0x08ff, 0xc89c,		0x21, 0
	.dw 0x0940, 0xc89c,	0x097f, 0xc89c,		0x21, 0
	.dw 0x09c0, 0xc89c,	0x09ff, 0xc89c,		0x21, 0
	.dw 0x0a40, 0xc89c,	0x0a7f, 0xc89c,		0x21, 0
	.dw 0x0ac0, 0xc89c,	0x0aff, 0xc89c,		0x21, 0
	.dw 0x0b40, 0xc89c,	0x0b7f, 0xc89c,		0x21, 0
	.dw 0x0bc0, 0xc89c,	0x0bff, 0xc89c,		0x21, 0
	.dw 0x0c40, 0xc89c,	0x0c7f, 0xc89c,		0x21, 0
	.dw 0x0cc0, 0xc89c,	0x0cff, 0xc89c,		0x21, 0
	.dw 0x0d40, 0xc89c,	0x0d7f, 0xc89c,		0x21, 0
	.dw 0x0dc0, 0xc89c,	0x0dff, 0xc89c,		0x21, 0
	.dw 0x0e40, 0xc89c,	0x0e7f, 0xc89c,		0x21, 0
	.dw 0x0ec0, 0xc89c,	0x0eff, 0xc89c,		0x21, 0
	.dw 0x0f40, 0xc89c,	0x0f7f, 0xc89c,		0x21, 0
	.dw 0x0fc0, 0xc89c,	0x0fff, 0xc89c,		0x21, 0
	.dw 0x1040, 0xc89c,	0x107f, 0xc89c,		0x21, 0
	.dw 0x10c0, 0xc89c,	0x10ff, 0xc89c,		0x21, 0
	.dw 0x1140, 0xc89c,	0x117f, 0xc89c,		0x21, 0
	.dw 0x11c0, 0xc89c,	0x11ff, 0xc89c,		0x21, 0
	.dw 0x1240, 0xc89c,	0x127f, 0xc89c,		0x21, 0
	.dw 0x12c0, 0xc89c,	0x12ff, 0xc89c,		0x21, 0
	.dw 0x1340, 0xc89c,	0x137f, 0xc89c,		0x21, 0
	.dw 0x13c0, 0xc89c,	0x13ff, 0xc89c,		0x21, 0
	.dw 0x1440, 0xc89c,	0x147f, 0xc89c,		0x21, 0
	.dw 0x14c0, 0xc89c,	0x14ff, 0xc89c,		0x21, 0
	.dw 0x1540, 0xc89c,	0x157f, 0xc89c,		0x21, 0
	.dw 0x15c0, 0xc89c,	0x15ff, 0xc89c,		0x21, 0
	.dw 0x1640, 0xc89c,	0x167f, 0xc89c,		0x21, 0
	.dw 0x16c0, 0xc89c,	0x16ff, 0xc89c,		0x21, 0
	.dw 0x1740, 0xc89c,	0x177f, 0xc89c,		0x21, 0
	.dw 0x17c0, 0xc89c,	0x17ff, 0xc89c,		0x21, 0
	.dw 0x1840, 0xc89c,	0x187f, 0xc89c,		0x21, 0
	.dw 0x18c0, 0xc89c,	0x18ff, 0xc89c,		0x21, 0
	.dw 0x1940, 0xc89c,	0x197f, 0xc89c,		0x21, 0
	.dw 0x19c0, 0xc89c,	0x1fff, 0xc89c,		0x21, 0
	.dw 0x2040, 0xc89c,	0x207f, 0xc89c,		0x21, 0
	.dw 0x20c0, 0xc89c,	0x20ff, 0xc89c,		0x21, 0
	.dw 0x2140, 0xc89c,	0x217f, 0xc89c,		0x21, 0
	.dw 0x21c0, 0xc89c,	0x21ff, 0xc89c,		0x21, 0
	.dw 0x2240, 0xc89c,	0x227f, 0xc89c,		0x21, 0
	.dw 0x22c0, 0xc89c,	0x22ff, 0xc89c,		0x21, 0
	.dw 0x2340, 0xc89c,	0x237f, 0xc89c,		0x21, 0
	.dw 0x23c0, 0xc89c,	0x23ff, 0xc89c,		0x21, 0
	.dw 0x2440, 0xc89c,	0x247f, 0xc89c,		0x21, 0
	.dw 0x24c0, 0xc89c,	0x24ff, 0xc89c,		0x21, 0
	.dw 0x2540, 0xc89c,	0x257f, 0xc89c,		0x21, 0
	.dw 0x25c0, 0xc89c,	0x25ff, 0xc89c,		0x21, 0
	.dw 0x2640, 0xc89c,	0x267f, 0xc89c,		0x21, 0
	.dw 0x26c0, 0xc89c,	0x26ff, 0xc89c,		0x21, 0
	.dw 0x2740, 0xc89c,	0x277f, 0xc89c,		0x21, 0
	.dw 0x27c0, 0xc89c,	0x27ff, 0xc89c,		0x21, 0
	.dw 0x2840, 0xc89c,	0x287f, 0xc89c,		0x21, 0
	.dw 0x28c0, 0xc89c,	0x28ff, 0xc89c,		0x21, 0
	.dw 0x2940, 0xc89c,	0x297f, 0xc89c,		0x21, 0
	.dw 0x29c0, 0xc89c,	0x29ff, 0xc89c,		0x21, 0
	.dw 0x2a40, 0xc89c,	0x2a7f, 0xc89c,		0x21, 0
	.dw 0x2ac0, 0xc89c,	0x2aff, 0xc89c,		0x21, 0
	.dw 0x2b40, 0xc89c,	0x2b7f, 0xc89c,		0x21, 0
	.dw 0x2bc0, 0xc89c,	0x2bff, 0xc89c,		0x21, 0
	.dw 0x2c40, 0xc89c,	0x2c7f, 0xc89c,		0x21, 0
	.dw 0x2cc0, 0xc89c,	0x2cff, 0xc89c,		0x21, 0
	.dw 0x2d40, 0xc89c,	0x2d7f, 0xc89c,		0x21, 0
	.dw 0x2dc0, 0xc89c,	0x2dff, 0xc89c,		0x21, 0
	.dw 0x2e40, 0xc89c,	0x2e7f, 0xc89c,		0x21, 0
	.dw 0x2ec0, 0xc89c,	0x2eff, 0xc89c,		0x21, 0
	.dw 0x2f40, 0xc89c,	0x2f7f, 0xc89c,		0x21, 0
	.dw 0x2fc0, 0xc89c,	0x2fff, 0xc89c,		0x21, 0
	.dw 0x3040, 0xc89c,	0x307f, 0xc89c,		0x21, 0
	.dw 0x30c0, 0xc89c,	0x30ff, 0xc89c,		0x21, 0
	.dw 0x3140, 0xc89c,	0x317f, 0xc89c,		0x21, 0
	.dw 0x31c0, 0xc89c,	0x31ff, 0xc89c,		0x21, 0
	.dw 0x3240, 0xc89c,	0x327f, 0xc89c,		0x21, 0
	.dw 0x32c0, 0xc89c,	0x32ff, 0xc89c,		0x21, 0
	.dw 0x3340, 0xc89c,	0x337f, 0xc89c,		0x21, 0
	.dw 0x33c0, 0xc89c,	0x33ff, 0xc89c,		0x21, 0
	.dw 0x3440, 0xc89c,	0x347f, 0xc89c,		0x21, 0
	.dw 0x34c0, 0xc89c,	0x34ff, 0xc89c,		0x21, 0
	.dw 0x3540, 0xc89c,	0x357f, 0xc89c,		0x21, 0
	.dw 0x35c0, 0xc89c,	0x35ff, 0xc89c,		0x21, 0
	.dw 0x3640, 0xc89c,	0x367f, 0xc89c,		0x21, 0
	.dw 0x36c0, 0xc89c,	0x36ff, 0xc89c,		0x21, 0
	.dw 0x3740, 0xc89c,	0x377f, 0xc89c,		0x21, 0
	.dw 0x37c0, 0xc89c,	0x37ff, 0xc89c,		0x21, 0
	.dw 0x3840, 0xc89c,	0x387f, 0xc89c,		0x21, 0
	.dw 0x38c0, 0xc89c,	0x38ff, 0xc89c,		0x21, 0
	.dw 0x3940, 0xc89c,	0x397f, 0xc89c,		0x21, 0
	.dw 0x39c0, 0xc89c,	0x3fff, 0xc89c,		0x21, 0
	.dw 0x4040, 0xc89c,	0x407f, 0xc89c,		0x21, 0
	.dw 0x40c0, 0xc89c,	0x40ff, 0xc89c,		0x21, 0
	.dw 0x4140, 0xc89c,	0x417f, 0xc89c,		0x21, 0
	.dw 0x41c0, 0xc89c,	0x41ff, 0xc89c,		0x21, 0
	.dw 0x4240, 0xc89c,	0x427f, 0xc89c,		0x21, 0
	.dw 0x42c0, 0xc89c,	0x42ff, 0xc89c,		0x21, 0
	.dw 0x4340, 0xc89c,	0x437f, 0xc89c,		0x21, 0
	.dw 0x43c0, 0xc89c,	0x43ff, 0xc89c,		0x21, 0
	.dw 0x4440, 0xc89c,	0x447f, 0xc89c,		0x21, 0
	.dw 0x44c0, 0xc89c,	0x44ff, 0xc89c,		0x21, 0
	.dw 0x4540, 0xc89c,	0x457f, 0xc89c,		0x21, 0
	.dw 0x45c0, 0xc89c,	0x45ff, 0xc89c,		0x21, 0
	.dw 0x4640, 0xc89c,	0x467f, 0xc89c,		0x21, 0
	.dw 0x46c0, 0xc89c,	0x46ff, 0xc89c,		0x21, 0
	.dw 0x4740, 0xc89c,	0x477f, 0xc89c,		0x21, 0
	.dw 0x47c0, 0xc89c,	0x47ff, 0xc89c,		0x21, 0
	.dw 0x4840, 0xc89c,	0x487f, 0xc89c,		0x21, 0
	.dw 0x48c0, 0xc89c,	0x48ff, 0xc89c,		0x21, 0
	.dw 0x4940, 0xc89c,	0x497f, 0xc89c,		0x21, 0
	.dw 0x49c0, 0xc89c,	0x49ff, 0xc89c,		0x21, 0
	.dw 0x4a40, 0xc89c,	0x4a7f, 0xc89c,		0x21, 0
	.dw 0x4ac0, 0xc89c,	0x4aff, 0xc89c,		0x21, 0
	.dw 0x4b40, 0xc89c,	0x4b7f, 0xc89c,		0x21, 0
	.dw 0x4bc0, 0xc89c,	0x4bff, 0xc89c,		0x21, 0
	.dw 0x4c40, 0xc89c,	0x4c7f, 0xc89c,		0x21, 0
	.dw 0x4cc0, 0xc89c,	0x4cff, 0xc89c,		0x21, 0
	.dw 0x4d40, 0xc89c,	0x4d7f, 0xc89c,		0x21, 0
	.dw 0x4dc0, 0xc89c,	0x4dff, 0xc89c,		0x21, 0
	.dw 0x4e40, 0xc89c,	0x4e7f, 0xc89c,		0x21, 0
	.dw 0x4ec0, 0xc89c,	0x4eff, 0xc89c,		0x21, 0
	.dw 0x4f40, 0xc89c,	0x4f7f, 0xc89c,		0x21, 0
	.dw 0x4fc0, 0xc89c,	0x4fff, 0xc89c,		0x21, 0
	.dw 0x5040, 0xc89c,	0x507f, 0xc89c,		0x21, 0
	.dw 0x50c0, 0xc89c,	0x50ff, 0xc89c,		0x21, 0
	.dw 0x5140, 0xc89c,	0x517f, 0xc89c,		0x21, 0
	.dw 0x51c0, 0xc89c,	0x51ff, 0xc89c,		0x21, 0
	.dw 0x5240, 0xc89c,	0x527f, 0xc89c,		0x21, 0
	.dw 0x52c0, 0xc89c,	0x52ff, 0xc89c,		0x21, 0
	.dw 0x5340, 0xc89c,	0x537f, 0xc89c,		0x21, 0
	.dw 0x53c0, 0xc89c,	0x53ff, 0xc89c,		0x21, 0
	.dw 0x5440, 0xc89c,	0x547f, 0xc89c,		0x21, 0
	.dw 0x54c0, 0xc89c,	0x54ff, 0xc89c,		0x21, 0
	.dw 0x5540, 0xc89c,	0x557f, 0xc89c,		0x21, 0
	.dw 0x55c0, 0xc89c,	0x55ff, 0xc89c,		0x21, 0
	.dw 0x5640, 0xc89c,	0x567f, 0xc89c,		0x21, 0
	.dw 0x56c0, 0xc89c,	0x56ff, 0xc89c,		0x21, 0
	.dw 0x5740, 0xc89c,	0x577f, 0xc89c,		0x21, 0
	.dw 0x57c0, 0xc89c,	0x57ff, 0xc89c,		0x21, 0
	.dw 0x5840, 0xc89c,	0x587f, 0xc89c,		0x21, 0
	.dw 0x58c0, 0xc89c,	0x58ff, 0xc89c,		0x21, 0
	.dw 0x5940, 0xc89c,	0x597f, 0xc89c,		0x21, 0
	.dw 0x59c0, 0xc89c,	0x5fff, 0xc89c,		0x21, 0
	.dw 0x6040, 0xc89c,	0x607f, 0xc89c,		0x21, 0
	.dw 0x60c0, 0xc89c,	0x60ff, 0xc89c,		0x21, 0
	.dw 0x6140, 0xc89c,	0x617f, 0xc89c,		0x21, 0
	.dw 0x61c0, 0xc89c,	0x61ff, 0xc89c,		0x21, 0
	.dw 0x6240, 0xc89c,	0x627f, 0xc89c,		0x21, 0
	.dw 0x62c0, 0xc89c,	0x62ff, 0xc89c,		0x21, 0
	.dw 0x6340, 0xc89c,	0x637f, 0xc89c,		0x21, 0
	.dw 0x63c0, 0xc89c,	0x63ff, 0xc89c,		0x21, 0
	.dw 0x6440, 0xc89c,	0x647f, 0xc89c,		0x21, 0
	.dw 0x64c0, 0xc89c,	0x64ff, 0xc89c,		0x21, 0
	.dw 0x6540, 0xc89c,	0x657f, 0xc89c,		0x21, 0
	.dw 0x65c0, 0xc89c,	0x65ff, 0xc89c,		0x21, 0
	.dw 0x6640, 0xc89c,	0x667f, 0xc89c,		0x21, 0
	.dw 0x66c0, 0xc89c,	0x66ff, 0xc89c,		0x21, 0
	.dw 0x6740, 0xc89c,	0x677f, 0xc89c,		0x21, 0
	.dw 0x67c0, 0xc89c,	0x67ff, 0xc89c,		0x21, 0
	.dw 0x6840, 0xc89c,	0x687f, 0xc89c,		0x21, 0
	.dw 0x68c0, 0xc89c,	0x68ff, 0xc89c,		0x21, 0
	.dw 0x6940, 0xc89c,	0x697f, 0xc89c,		0x21, 0
	.dw 0x69c0, 0xc89c,	0x69ff, 0xc89c,		0x21, 0
	.dw 0x6a40, 0xc89c,	0x6a7f, 0xc89c,		0x21, 0
	.dw 0x6ac0, 0xc89c,	0x6aff, 0xc89c,		0x21, 0
	.dw 0x6b40, 0xc89c,	0x6b7f, 0xc89c,		0x21, 0
	.dw 0x6bc0, 0xc89c,	0x6bff, 0xc89c,		0x21, 0
	.dw 0x6c40, 0xc89c,	0x6c7f, 0xc89c,		0x21, 0
	.dw 0x6cc0, 0xc89c,	0x6cff, 0xc89c,		0x21, 0
	.dw 0x6d40, 0xc89c,	0x6d7f, 0xc89c,		0x21, 0
	.dw 0x6dc0, 0xc89c,	0x6dff, 0xc89c,		0x21, 0
	.dw 0x6e40, 0xc89c,	0x6e7f, 0xc89c,		0x21, 0
	.dw 0x6ec0, 0xc89c,	0x6eff, 0xc89c,		0x21, 0
	.dw 0x6f40, 0xc89c,	0x6f7f, 0xc89c,		0x21, 0
	.dw 0x6fc0, 0xc89c,	0x6fff, 0xc89c,		0x21, 0
	.dw 0x7040, 0xc89c,	0x707f, 0xc89c,		0x21, 0
	.dw 0x70c0, 0xc89c,	0x70ff, 0xc89c,		0x21, 0
	.dw 0x7140, 0xc89c,	0x717f, 0xc89c,		0x21, 0
	.dw 0x71c0, 0xc89c,	0x71ff, 0xc89c,		0x21, 0
	.dw 0x7240, 0xc89c,	0x727f, 0xc89c,		0x21, 0
	.dw 0x72c0, 0xc89c,	0x72ff, 0xc89c,		0x21, 0
	.dw 0x7340, 0xc89c,	0x737f, 0xc89c,		0x21, 0
	.dw 0x73c0, 0xc89c,	0x73ff, 0xc89c,		0x21, 0
	.dw 0x7440, 0xc89c,	0x747f, 0xc89c,		0x21, 0
	.dw 0x74c0, 0xc89c,	0x74ff, 0xc89c,		0x21, 0
	.dw 0x7540, 0xc89c,	0x757f, 0xc89c,		0x21, 0
	.dw 0x75c0, 0xc89c,	0x75ff, 0xc89c,		0x21, 0
	.dw 0x7640, 0xc89c,	0x767f, 0xc89c,		0x21, 0
	.dw 0x76c0, 0xc89c,	0x76ff, 0xc89c,		0x21, 0
	.dw 0x7740, 0xc89c,	0x777f, 0xc89c,		0x21, 0
	.dw 0x77c0, 0xc89c,	0x77ff, 0xc89c,		0x21, 0
	.dw 0x7840, 0xc89c,	0x787f, 0xc89c,		0x21, 0
	.dw 0x78c0, 0xc89c,	0x78ff, 0xc89c,		0x21, 0
	.dw 0x7940, 0xc89c,	0x797f, 0xc89c,		0x21, 0
	.dw 0x79c0, 0xc89c,	0x7fff, 0xc89c,		0x21, 0
	.dw 0x8040, 0xc89c,	0x807f, 0xc89c,		0x21, 0
	.dw 0x80c0, 0xc89c,	0x80ff, 0xc89c,		0x21, 0
	.dw 0x8140, 0xc89c,	0x817f, 0xc89c,		0x21, 0
	.dw 0x81c0, 0xc89c,	0x81ff, 0xc89c,		0x21, 0
	.dw 0x8240, 0xc89c,	0x827f, 0xc89c,		0x21, 0
	.dw 0x82c0, 0xc89c,	0x82ff, 0xc89c,		0x21, 0
	.dw 0x8340, 0xc89c,	0x837f, 0xc89c,		0x21, 0
	.dw 0x83c0, 0xc89c,	0x83ff, 0xc89c,		0x21, 0
	.dw 0x8440, 0xc89c,	0x847f, 0xc89c,		0x21, 0
	.dw 0x84c0, 0xc89c,	0x84ff, 0xc89c,		0x21, 0
	.dw 0x8540, 0xc89c,	0x857f, 0xc89c,		0x21, 0
	.dw 0x85c0, 0xc89c,	0x85ff, 0xc89c,		0x21, 0
	.dw 0x8640, 0xc89c,	0x867f, 0xc89c,		0x21, 0
	.dw 0x86c0, 0xc89c,	0x86ff, 0xc89c,		0x21, 0
	.dw 0x8740, 0xc89c,	0x877f, 0xc89c,		0x21, 0
	.dw 0x87c0, 0xc89c,	0x87ff, 0xc89c,		0x21, 0
	.dw 0x8840, 0xc89c,	0x887f, 0xc89c,		0x21, 0
	.dw 0x88c0, 0xc89c,	0x88ff, 0xc89c,		0x21, 0
	.dw 0x8940, 0xc89c,	0x897f, 0xc89c,		0x21, 0
	.dw 0x89c0, 0xc89c,	0x89ff, 0xc89c,		0x21, 0
	.dw 0x8a40, 0xc89c,	0x8a7f, 0xc89c,		0x21, 0
	.dw 0x8ac0, 0xc89c,	0x8aff, 0xc89c,		0x21, 0
	.dw 0x8b40, 0xc89c,	0x8b7f, 0xc89c,		0x21, 0
	.dw 0x8bc0, 0xc89c,	0x8bff, 0xc89c,		0x21, 0
	.dw 0x8c40, 0xc89c,	0x8c7f, 0xc89c,		0x21, 0
	.dw 0x8cc0, 0xc89c,	0x8cff, 0xc89c,		0x21, 0
	.dw 0x8d40, 0xc89c,	0x8d7f, 0xc89c,		0x21, 0
	.dw 0x8dc0, 0xc89c,	0x8dff, 0xc89c,		0x21, 0
	.dw 0x8e40, 0xc89c,	0x8e7f, 0xc89c,		0x21, 0
	.dw 0x8ec0, 0xc89c,	0x8eff, 0xc89c,		0x21, 0
	.dw 0x8f40, 0xc89c,	0x8f7f, 0xc89c,		0x21, 0
	.dw 0x8fc0, 0xc89c,	0x8fff, 0xc89c,		0x21, 0
	.dw 0x9040, 0xc89c,	0x907f, 0xc89c,		0x21, 0
	.dw 0x90c0, 0xc89c,	0x90ff, 0xc89c,		0x21, 0
	.dw 0x9140, 0xc89c,	0x917f, 0xc89c,		0x21, 0
	.dw 0x91c0, 0xc89c,	0x91ff, 0xc89c,		0x21, 0
	.dw 0x9240, 0xc89c,	0x927f, 0xc89c,		0x21, 0
	.dw 0x92c0, 0xc89c,	0x92ff, 0xc89c,		0x21, 0
	.dw 0x9340, 0xc89c,	0x937f, 0xc89c,		0x21, 0
	.dw 0x93c0, 0xc89c,	0x93ff, 0xc89c,		0x21, 0
	.dw 0x9440, 0xc89c,	0x947f, 0xc89c,		0x21, 0
	.dw 0x94c0, 0xc89c,	0x94ff, 0xc89c,		0x21, 0
	.dw 0x9540, 0xc89c,	0x957f, 0xc89c,		0x21, 0
	.dw 0x95c0, 0xc89c,	0x95ff, 0xc89c,		0x21, 0
	.dw 0x9640, 0xc89c,	0x967f, 0xc89c,		0x21, 0
	.dw 0x96c0, 0xc89c,	0x96ff, 0xc89c,		0x21, 0
	.dw 0x9740, 0xc89c,	0x977f, 0xc89c,		0x21, 0
	.dw 0x97c0, 0xc89c,	0x97ff, 0xc89c,		0x21, 0
	.dw 0x9840, 0xc89c,	0x987f, 0xc89c,		0x21, 0
	.dw 0x98c0, 0xc89c,	0x98ff, 0xc89c,		0x21, 0
	.dw 0x9940, 0xc89c,	0x997f, 0xc89c,		0x21, 0
	.dw 0x99c0, 0xc89c,	0x9fff, 0xc89c,		0x21, 0
	.dw 0xa040, 0xc89c,	0xa07f, 0xc89c,		0x21, 0
	.dw 0xa0c0, 0xc89c,	0xa0ff, 0xc89c,		0x21, 0
	.dw 0xa140, 0xc89c,	0xa17f, 0xc89c,		0x21, 0
	.dw 0xa1c0, 0xc89c,	0xa1ff, 0xc89c,		0x21, 0
	.dw 0xa240, 0xc89c,	0xa27f, 0xc89c,		0x21, 0
	.dw 0xa2c0, 0xc89c,	0xa2ff, 0xc89c,		0x21, 0
	.dw 0xa340, 0xc89c,	0xa37f, 0xc89c,		0x21, 0
	.dw 0xa3c0, 0xc89c,	0xa3ff, 0xc89c,		0x21, 0
	.dw 0xa440, 0xc89c,	0xa47f, 0xc89c,		0x21, 0
	.dw 0xa4c0, 0xc89c,	0xa4ff, 0xc89c,		0x21, 0
	.dw 0xa540, 0xc89c,	0xa57f, 0xc89c,		0x21, 0
	.dw 0xa5c0, 0xc89c,	0xa5ff, 0xc89c,		0x21, 0
	.dw 0xa640, 0xc89c,	0xa67f, 0xc89c,		0x21, 0
	.dw 0xa6c0, 0xc89c,	0xa6ff, 0xc89c,		0x21, 0
	.dw 0xa740, 0xc89c,	0xa77f, 0xc89c,		0x21, 0
	.dw 0xa7c0, 0xc89c,	0xa7ff, 0xc89c,		0x21, 0
	.dw 0xa840, 0xc89c,	0xa87f, 0xc89c,		0x21, 0
	.dw 0xa8c0, 0xc89c,	0xa8ff, 0xc89c,		0x21, 0
	.dw 0xa940, 0xc89c,	0xa97f, 0xc89c,		0x21, 0
	.dw 0xa9c0, 0xc89c,	0xa9ff, 0xc89c,		0x21, 0
	.dw 0xaa40, 0xc89c,	0xaa7f, 0xc89c,		0x21, 0
	.dw 0xaac0, 0xc89c,	0xaaff, 0xc89c,		0x21, 0
	.dw 0xab40, 0xc89c,	0xab7f, 0xc89c,		0x21, 0
	.dw 0xabc0, 0xc89c,	0xabff, 0xc89c,		0x21, 0
	.dw 0xac40, 0xc89c,	0xac7f, 0xc89c,		0x21, 0
	.dw 0xacc0, 0xc89c,	0xacff, 0xc89c,		0x21, 0
	.dw 0xad40, 0xc89c,	0xad7f, 0xc89c,		0x21, 0
	.dw 0xadc0, 0xc89c,	0xadff, 0xc89c,		0x21, 0
	.dw 0xae40, 0xc89c,	0xae7f, 0xc89c,		0x21, 0
	.dw 0xaec0, 0xc89c,	0xaeff, 0xc89c,		0x21, 0
	.dw 0xaf40, 0xc89c,	0xaf7f, 0xc89c,		0x21, 0
	.dw 0xafc0, 0xc89c,	0xafff, 0xc89c,		0x21, 0
	.dw 0xb040, 0xc89c,	0xb07f, 0xc89c,		0x21, 0
	.dw 0xb0c0, 0xc89c,	0xb0ff, 0xc89c,		0x21, 0
	.dw 0xb140, 0xc89c,	0xb17f, 0xc89c,		0x21, 0
	.dw 0xb1c0, 0xc89c,	0xb1ff, 0xc89c,		0x21, 0
	.dw 0xb240, 0xc89c,	0xb27f, 0xc89c,		0x21, 0
	.dw 0xb2c0, 0xc89c,	0xb2ff, 0xc89c,		0x21, 0
	.dw 0xb340, 0xc89c,	0xb37f, 0xc89c,		0x21, 0
	.dw 0xb3c0, 0xc89c,	0xb3ff, 0xc89c,		0x21, 0
	.dw 0xb440, 0xc89c,	0xb47f, 0xc89c,		0x21, 0
	.dw 0xb4c0, 0xc89c,	0xb4ff, 0xc89c,		0x21, 0
	.dw 0xb540, 0xc89c,	0xb57f, 0xc89c,		0x21, 0
	.dw 0xb5c0, 0xc89c,	0xb5ff, 0xc89c,		0x21, 0
	.dw 0xb640, 0xc89c,	0xb67f, 0xc89c,		0x21, 0
	.dw 0xb6c0, 0xc89c,	0xb6ff, 0xc89c,		0x21, 0
	.dw 0xb740, 0xc89c,	0xb77f, 0xc89c,		0x21, 0
	.dw 0xb7c0, 0xc89c,	0xb7ff, 0xc89c,		0x21, 0
	.dw 0xb840, 0xc89c,	0xb87f, 0xc89c,		0x21, 0
	.dw 0xb8c0, 0xc89c,	0xb8ff, 0xc89c,		0x21, 0
	.dw 0xb940, 0xc89c,	0xb97f, 0xc89c,		0x21, 0
	.dw 0xb9c0, 0xc89c,	0xbfff, 0xc89c,		0x21, 0
	.dw 0xc040, 0xc89c,	0xc07f, 0xc89c,		0x21, 0
	.dw 0xc0c0, 0xc89c,	0xc0ff, 0xc89c,		0x21, 0
	.dw 0xc140, 0xc89c,	0xc17f, 0xc89c,		0x21, 0
	.dw 0xc1c0, 0xc89c,	0xc1ff, 0xc89c,		0x21, 0
	.dw 0xc240, 0xc89c,	0xc27f, 0xc89c,		0x21, 0
	.dw 0xc2c0, 0xc89c,	0xc2ff, 0xc89c,		0x21, 0
	.dw 0xc340, 0xc89c,	0xc37f, 0xc89c,		0x21, 0
	.dw 0xc3c0, 0xc89c,	0xc3ff, 0xc89c,		0x21, 0
	.dw 0xc440, 0xc89c,	0xc47f, 0xc89c,		0x21, 0
	.dw 0xc4c0, 0xc89c,	0xc4ff, 0xc89c,		0x21, 0
	.dw 0xc540, 0xc89c,	0xc57f, 0xc89c,		0x21, 0
	.dw 0xc5c0, 0xc89c,	0xc5ff, 0xc89c,		0x21, 0
	.dw 0xc640, 0xc89c,	0xc67f, 0xc89c,		0x21, 0
	.dw 0xc6c0, 0xc89c,	0xc6ff, 0xc89c,		0x21, 0
	.dw 0xc740, 0xc89c,	0xc77f, 0xc89c,		0x21, 0
	.dw 0xc7c0, 0xc89c,	0xc7ff, 0xc89c,		0x21, 0
	.dw 0xc840, 0xc89c,	0xc87f, 0xc89c,		0x21, 0
	.dw 0xc8c0, 0xc89c,	0xc8ff, 0xc89c,		0x21, 0
	.dw 0xc940, 0xc89c,	0xc97f, 0xc89c,		0x21, 0
	.dw 0xc9c0, 0xc89c,	0xc9ff, 0xc89c,		0x21, 0
	.dw 0xca40, 0xc89c,	0xca7f, 0xc89c,		0x21, 0
	.dw 0xcac0, 0xc89c,	0xcaff, 0xc89c,		0x21, 0
	.dw 0xcb40, 0xc89c,	0xcb7f, 0xc89c,		0x21, 0
	.dw 0xcbc0, 0xc89c,	0xcbff, 0xc89c,		0x21, 0
	.dw 0xcc40, 0xc89c,	0xcc7f, 0xc89c,		0x21, 0
	.dw 0xccc0, 0xc89c,	0xccff, 0xc89c,		0x21, 0
	.dw 0xcd40, 0xc89c,	0xcd7f, 0xc89c,		0x21, 0
	.dw 0xcdc0, 0xc89c,	0xcdff, 0xc89c,		0x21, 0
	.dw 0xce40, 0xc89c,	0xce7f, 0xc89c,		0x21, 0
	.dw 0xcec0, 0xc89c,	0xceff, 0xc89c,		0x21, 0
	.dw 0xcf40, 0xc89c,	0xcf7f, 0xc89c,		0x21, 0
	.dw 0xcfc0, 0xc89c,	0xcfff, 0xc89c,		0x21, 0
	.dw 0xd040, 0xc89c,	0xd07f, 0xc89c,		0x21, 0
	.dw 0xd0c0, 0xc89c,	0xd0ff, 0xc89c,		0x21, 0
	.dw 0xd140, 0xc89c,	0xd17f, 0xc89c,		0x21, 0
	.dw 0xd1c0, 0xc89c,	0xd1ff, 0xc89c,		0x21, 0
	.dw 0xd240, 0xc89c,	0xd27f, 0xc89c,		0x21, 0
	.dw 0xd2c0, 0xc89c,	0xd2ff, 0xc89c,		0x21, 0
	.dw 0xd340, 0xc89c,	0xd37f, 0xc89c,		0x21, 0
	.dw 0xd3c0, 0xc89c,	0xd3ff, 0xc89c,		0x21, 0
	.dw 0xd440, 0xc89c,	0xd47f, 0xc89c,		0x21, 0
	.dw 0xd4c0, 0xc89c,	0xd4ff, 0xc89c,		0x21, 0
	.dw 0xd540, 0xc89c,	0xd57f, 0xc89c,		0x21, 0
	.dw 0xd5c0, 0xc89c,	0xd5ff, 0xc89c,		0x21, 0
	.dw 0xd640, 0xc89c,	0xd67f, 0xc89c,		0x21, 0
	.dw 0xd6c0, 0xc89c,	0xd6ff, 0xc89c,		0x21, 0
	.dw 0xd740, 0xc89c,	0xd77f, 0xc89c,		0x21, 0
	.dw 0xd7c0, 0xc89c,	0xd7ff, 0xc89c,		0x21, 0
	.dw 0xd840, 0xc89c,	0xd87f, 0xc89c,		0x21, 0
	.dw 0xd8c0, 0xc89c,	0xd8ff, 0xc89c,		0x21, 0
	.dw 0xd940, 0xc89c,	0xd97f, 0xc89c,		0x21, 0
	.dw 0xd9c0, 0xc89c,	0xdfff, 0xc89c,		0x21, 0
	.dw 0xe040, 0xc89c,	0xe07f, 0xc89c,		0x21, 0
	.dw 0xe0c0, 0xc89c,	0xe0ff, 0xc89c,		0x21, 0
	.dw 0xe140, 0xc89c,	0xe17f, 0xc89c,		0x21, 0
	.dw 0xe1c0, 0xc89c,	0xe1ff, 0xc89c,		0x21, 0
	.dw 0xe240, 0xc89c,	0xe27f, 0xc89c,		0x21, 0
	.dw 0xe2c0, 0xc89c,	0xe2ff, 0xc89c,		0x21, 0
	.dw 0xe340, 0xc89c,	0xe37f, 0xc89c,		0x21, 0
	.dw 0xe3c0, 0xc89c,	0xe3ff, 0xc89c,		0x21, 0
	.dw 0xe440, 0xc89c,	0xe47f, 0xc89c,		0x21, 0
	.dw 0xe4c0, 0xc89c,	0xe4ff, 0xc89c,		0x21, 0
	.dw 0xe540, 0xc89c,	0xe57f, 0xc89c,		0x21, 0
	.dw 0xe5c0, 0xc89c,	0xe5ff, 0xc89c,		0x21, 0
	.dw 0xe640, 0xc89c,	0xe67f, 0xc89c,		0x21, 0
	.dw 0xe6c0, 0xc89c,	0xe6ff, 0xc89c,		0x21, 0
	.dw 0xe740, 0xc89c,	0xe77f, 0xc89c,		0x21, 0
	.dw 0xe7c0, 0xc89c,	0xe7ff, 0xc89c,		0x21, 0
	.dw 0xe840, 0xc89c,	0xe87f, 0xc89c,		0x21, 0
	.dw 0xe8c0, 0xc89c,	0xe8ff, 0xc89c,		0x21, 0
	.dw 0xe940, 0xc89c,	0xe97f, 0xc89c,		0x21, 0
	.dw 0xe9c0, 0xc89c,	0xe9ff, 0xc89c,		0x21, 0
	.dw 0xea40, 0xc89c,	0xea7f, 0xc89c,		0x21, 0
	.dw 0xeac0, 0xc89c,	0xeaff, 0xc89c,		0x21, 0
	.dw 0xeb40, 0xc89c,	0xeb7f, 0xc89c,		0x21, 0
	.dw 0xebc0, 0xc89c,	0xebff, 0xc89c,		0x21, 0
	.dw 0xec40, 0xc89c,	0xec7f, 0xc89c,		0x21, 0
	.dw 0xecc0, 0xc89c,	0xecff, 0xc89c,		0x21, 0
	.dw 0xed40, 0xc89c,	0xed7f, 0xc89c,		0x21, 0
	.dw 0xedc0, 0xc89c,	0xedff, 0xc89c,		0x21, 0
	.dw 0xee40, 0xc89c,	0xee7f, 0xc89c,		0x21, 0
	.dw 0xeec0, 0xc89c,	0xeeff, 0xc89c,		0x21, 0
	.dw 0xef40, 0xc89c,	0xef7f, 0xc89c,		0x21, 0
	.dw 0xefc0, 0xc89c,	0xefff, 0xc89c,		0x21, 0
	.dw 0xf040, 0xc89c,	0xf07f, 0xc89c,		0x21, 0
	.dw 0xf0c0, 0xc89c,	0xf0ff, 0xc89c,		0x21, 0
	.dw 0xf140, 0xc89c,	0xf17f, 0xc89c,		0x21, 0
	.dw 0xf1c0, 0xc89c,	0xf1ff, 0xc89c,		0x21, 0
	.dw 0xf240, 0xc89c,	0xf27f, 0xc89c,		0x21, 0
	.dw 0xf2c0, 0xc89c,	0xf2ff, 0xc89c,		0x21, 0
	.dw 0xf340, 0xc89c,	0xf37f, 0xc89c,		0x21, 0
	.dw 0xf3c0, 0xc89c,	0xf3ff, 0xc89c,		0x21, 0
	.dw 0xf440, 0xc89c,	0xf47f, 0xc89c,		0x21, 0
	.dw 0xf4c0, 0xc89c,	0xf4ff, 0xc89c,		0x21, 0
	.dw 0xf540, 0xc89c,	0xf57f, 0xc89c,		0x21, 0
	.dw 0xf5c0, 0xc89c,	0xf5ff, 0xc89c,		0x21, 0
	.dw 0xf640, 0xc89c,	0xf67f, 0xc89c,		0x21, 0
	.dw 0xf6c0, 0xc89c,	0xf6ff, 0xc89c,		0x21, 0
	.dw 0xf740, 0xc89c,	0xf77f, 0xc89c,		0x21, 0
	.dw 0xf7c0, 0xc89c,	0xf7ff, 0xc89c,		0x21, 0
	.dw 0xf840, 0xc89c,	0xf87f, 0xc89c,		0x21, 0
	.dw 0xf8c0, 0xc89c,	0xf8ff, 0xc89c,		0x21, 0
	.dw 0xf940, 0xc89c,	0xf97f, 0xc89c,		0x21, 0
	.dw 0xf9c0, 0xc89c,	0xffff, 0xc89c,		0x21, 0
	.dw 0x0040, 0xc89d,	0x007f, 0xc89d,		0x21, 0
	.dw 0x00c0, 0xc89d,	0x00ff, 0xc89d,		0x21, 0
	.dw 0x0140, 0xc89d,	0x017f, 0xc89d,		0x21, 0
	.dw 0x01c0, 0xc89d,	0x01ff, 0xc89d,		0x21, 0
	.dw 0x0240, 0xc89d,	0x027f, 0xc89d,		0x21, 0
	.dw 0x02c0, 0xc89d,	0x02ff, 0xc89d,		0x21, 0
	.dw 0x0340, 0xc89d,	0x037f, 0xc89d,		0x21, 0
	.dw 0x03c0, 0xc89d,	0x03ff, 0xc89d,		0x21, 0
	.dw 0x0440, 0xc89d,	0x047f, 0xc89d,		0x21, 0
	.dw 0x04c0, 0xc89d,	0x04ff, 0xc89d,		0x21, 0
	.dw 0x0540, 0xc89d,	0x057f, 0xc89d,		0x21, 0
	.dw 0x05c0, 0xc89d,	0x05ff, 0xc89d,		0x21, 0
	.dw 0x0640, 0xc89d,	0x067f, 0xc89d,		0x21, 0
	.dw 0x06c0, 0xc89d,	0x06ff, 0xc89d,		0x21, 0
	.dw 0x0740, 0xc89d,	0x077f, 0xc89d,		0x21, 0
	.dw 0x07c0, 0xc89d,	0x07ff, 0xc89d,		0x21, 0
	.dw 0x0840, 0xc89d,	0x087f, 0xc89d,		0x21, 0
	.dw 0x08c0, 0xc89d,	0x08ff, 0xc89d,		0x21, 0
	.dw 0x0940, 0xc89d,	0x097f, 0xc89d,		0x21, 0
	.dw 0x09c0, 0xc89d,	0x09ff, 0xc89d,		0x21, 0
	.dw 0x0a40, 0xc89d,	0x0a7f, 0xc89d,		0x21, 0
	.dw 0x0ac0, 0xc89d,	0x0aff, 0xc89d,		0x21, 0
	.dw 0x0b40, 0xc89d,	0x0b7f, 0xc89d,		0x21, 0
	.dw 0x0bc0, 0xc89d,	0x0bff, 0xc89d,		0x21, 0
	.dw 0x0c40, 0xc89d,	0x0c7f, 0xc89d,		0x21, 0
	.dw 0x0cc0, 0xc89d,	0x0cff, 0xc89d,		0x21, 0
	.dw 0x0d40, 0xc89d,	0x0d7f, 0xc89d,		0x21, 0
	.dw 0x0dc0, 0xc89d,	0x0dff, 0xc89d,		0x21, 0
	.dw 0x0e40, 0xc89d,	0x0e7f, 0xc89d,		0x21, 0
	.dw 0x0ec0, 0xc89d,	0x0eff, 0xc89d,		0x21, 0
	.dw 0x0f40, 0xc89d,	0x0f7f, 0xc89d,		0x21, 0
	.dw 0x0fc0, 0xc89d,	0x0fff, 0xc89d,		0x21, 0
	.dw 0x1040, 0xc89d,	0x107f, 0xc89d,		0x21, 0
	.dw 0x10c0, 0xc89d,	0x10ff, 0xc89d,		0x21, 0
	.dw 0x1140, 0xc89d,	0x117f, 0xc89d,		0x21, 0
	.dw 0x11c0, 0xc89d,	0x11ff, 0xc89d,		0x21, 0
	.dw 0x1240, 0xc89d,	0x127f, 0xc89d,		0x21, 0
	.dw 0x12c0, 0xc89d,	0x12ff, 0xc89d,		0x21, 0
	.dw 0x1340, 0xc89d,	0x137f, 0xc89d,		0x21, 0
	.dw 0x13c0, 0xc89d,	0x13ff, 0xc89d,		0x21, 0
	.dw 0x1440, 0xc89d,	0x147f, 0xc89d,		0x21, 0
	.dw 0x14c0, 0xc89d,	0x14ff, 0xc89d,		0x21, 0
	.dw 0x1540, 0xc89d,	0x157f, 0xc89d,		0x21, 0
	.dw 0x15c0, 0xc89d,	0x15ff, 0xc89d,		0x21, 0
	.dw 0x1640, 0xc89d,	0x167f, 0xc89d,		0x21, 0
	.dw 0x16c0, 0xc89d,	0x16ff, 0xc89d,		0x21, 0
	.dw 0x1740, 0xc89d,	0x177f, 0xc89d,		0x21, 0
	.dw 0x17c0, 0xc89d,	0x17ff, 0xc89d,		0x21, 0
	.dw 0x1840, 0xc89d,	0x187f, 0xc89d,		0x21, 0
	.dw 0x18c0, 0xc89d,	0x18ff, 0xc89d,		0x21, 0
	.dw 0x1940, 0xc89d,	0x197f, 0xc89d,		0x21, 0
	.dw 0x19c0, 0xc89d,	0x1fff, 0xc89d,		0x21, 0
	.dw 0x2040, 0xc89d,	0x207f, 0xc89d,		0x21, 0
	.dw 0x20c0, 0xc89d,	0x20ff, 0xc89d,		0x21, 0
	.dw 0x2140, 0xc89d,	0x217f, 0xc89d,		0x21, 0
	.dw 0x21c0, 0xc89d,	0x21ff, 0xc89d,		0x21, 0
	.dw 0x2240, 0xc89d,	0x227f, 0xc89d,		0x21, 0
	.dw 0x22c0, 0xc89d,	0x22ff, 0xc89d,		0x21, 0
	.dw 0x2340, 0xc89d,	0x237f, 0xc89d,		0x21, 0
	.dw 0x23c0, 0xc89d,	0x23ff, 0xc89d,		0x21, 0
	.dw 0x2440, 0xc89d,	0x247f, 0xc89d,		0x21, 0
	.dw 0x24c0, 0xc89d,	0x24ff, 0xc89d,		0x21, 0
	.dw 0x2540, 0xc89d,	0x257f, 0xc89d,		0x21, 0
	.dw 0x25c0, 0xc89d,	0x25ff, 0xc89d,		0x21, 0
	.dw 0x2640, 0xc89d,	0x267f, 0xc89d,		0x21, 0
	.dw 0x26c0, 0xc89d,	0x26ff, 0xc89d,		0x21, 0
	.dw 0x2740, 0xc89d,	0x277f, 0xc89d,		0x21, 0
	.dw 0x27c0, 0xc89d,	0x27ff, 0xc89d,		0x21, 0
	.dw 0x2840, 0xc89d,	0x287f, 0xc89d,		0x21, 0
	.dw 0x28c0, 0xc89d,	0x28ff, 0xc89d,		0x21, 0
	.dw 0x2940, 0xc89d,	0x297f, 0xc89d,		0x21, 0
	.dw 0x29c0, 0xc89d,	0x29ff, 0xc89d,		0x21, 0
	.dw 0x2a40, 0xc89d,	0x2a7f, 0xc89d,		0x21, 0
	.dw 0x2ac0, 0xc89d,	0x2aff, 0xc89d,		0x21, 0
	.dw 0x2b40, 0xc89d,	0x2b7f, 0xc89d,		0x21, 0
	.dw 0x2bc0, 0xc89d,	0x2bff, 0xc89d,		0x21, 0
	.dw 0x2c40, 0xc89d,	0x2c7f, 0xc89d,		0x21, 0
	.dw 0x2cc0, 0xc89d,	0x2cff, 0xc89d,		0x21, 0
	.dw 0x2d40, 0xc89d,	0x2d7f, 0xc89d,		0x21, 0
	.dw 0x2dc0, 0xc89d,	0x2dff, 0xc89d,		0x21, 0
	.dw 0x2e40, 0xc89d,	0x2e7f, 0xc89d,		0x21, 0
	.dw 0x2ec0, 0xc89d,	0x2eff, 0xc89d,		0x21, 0
	.dw 0x2f40, 0xc89d,	0x2f7f, 0xc89d,		0x21, 0
	.dw 0x2fc0, 0xc89d,	0x2fff, 0xc89d,		0x21, 0
	.dw 0x3040, 0xc89d,	0x307f, 0xc89d,		0x21, 0
	.dw 0x30c0, 0xc89d,	0x30ff, 0xc89d,		0x21, 0
	.dw 0x3140, 0xc89d,	0x317f, 0xc89d,		0x21, 0
	.dw 0x31c0, 0xc89d,	0x31ff, 0xc89d,		0x21, 0
	.dw 0x3240, 0xc89d,	0x327f, 0xc89d,		0x21, 0
	.dw 0x32c0, 0xc89d,	0x32ff, 0xc89d,		0x21, 0
	.dw 0x3340, 0xc89d,	0x337f, 0xc89d,		0x21, 0
	.dw 0x33c0, 0xc89d,	0x33ff, 0xc89d,		0x21, 0
	.dw 0x3440, 0xc89d,	0x347f, 0xc89d,		0x21, 0
	.dw 0x34c0, 0xc89d,	0x34ff, 0xc89d,		0x21, 0
	.dw 0x3540, 0xc89d,	0x357f, 0xc89d,		0x21, 0
	.dw 0x35c0, 0xc89d,	0x35ff, 0xc89d,		0x21, 0
	.dw 0x3640, 0xc89d,	0x367f, 0xc89d,		0x21, 0
	.dw 0x36c0, 0xc89d,	0x36ff, 0xc89d,		0x21, 0
	.dw 0x3740, 0xc89d,	0x377f, 0xc89d,		0x21, 0
	.dw 0x37c0, 0xc89d,	0x37ff, 0xc89d,		0x21, 0
	.dw 0x3840, 0xc89d,	0x387f, 0xc89d,		0x21, 0
	.dw 0x38c0, 0xc89d,	0x38ff, 0xc89d,		0x21, 0
	.dw 0x3940, 0xc89d,	0x397f, 0xc89d,		0x21, 0
	.dw 0x39c0, 0xc89d,	0x3fff, 0xc89d,		0x21, 0
	.dw 0x4040, 0xc89d,	0x407f, 0xc89d,		0x21, 0
	.dw 0x40c0, 0xc89d,	0x40ff, 0xc89d,		0x21, 0
	.dw 0x4140, 0xc89d,	0x417f, 0xc89d,		0x21, 0
	.dw 0x41c0, 0xc89d,	0x41ff, 0xc89d,		0x21, 0
	.dw 0x4240, 0xc89d,	0x427f, 0xc89d,		0x21, 0
	.dw 0x42c0, 0xc89d,	0x42ff, 0xc89d,		0x21, 0
	.dw 0x4340, 0xc89d,	0x437f, 0xc89d,		0x21, 0
	.dw 0x43c0, 0xc89d,	0x43ff, 0xc89d,		0x21, 0
	.dw 0x4440, 0xc89d,	0x447f, 0xc89d,		0x21, 0
	.dw 0x44c0, 0xc89d,	0x44ff, 0xc89d,		0x21, 0
	.dw 0x4540, 0xc89d,	0x457f, 0xc89d,		0x21, 0
	.dw 0x45c0, 0xc89d,	0x45ff, 0xc89d,		0x21, 0
	.dw 0x4640, 0xc89d,	0x467f, 0xc89d,		0x21, 0
	.dw 0x46c0, 0xc89d,	0x46ff, 0xc89d,		0x21, 0
	.dw 0x4740, 0xc89d,	0x477f, 0xc89d,		0x21, 0
	.dw 0x47c0, 0xc89d,	0x47ff, 0xc89d,		0x21, 0
	.dw 0x4840, 0xc89d,	0x487f, 0xc89d,		0x21, 0
	.dw 0x48c0, 0xc89d,	0x48ff, 0xc89d,		0x21, 0
	.dw 0x4940, 0xc89d,	0x497f, 0xc89d,		0x21, 0
	.dw 0x49c0, 0xc89d,	0x49ff, 0xc89d,		0x21, 0
	.dw 0x4a40, 0xc89d,	0x4a7f, 0xc89d,		0x21, 0
	.dw 0x4ac0, 0xc89d,	0x4aff, 0xc89d,		0x21, 0
	.dw 0x4b40, 0xc89d,	0x4b7f, 0xc89d,		0x21, 0
	.dw 0x4bc0, 0xc89d,	0x4bff, 0xc89d,		0x21, 0
	.dw 0x4c40, 0xc89d,	0x4c7f, 0xc89d,		0x21, 0
	.dw 0x4cc0, 0xc89d,	0x4cff, 0xc89d,		0x21, 0
	.dw 0x4d40, 0xc89d,	0x4d7f, 0xc89d,		0x21, 0
	.dw 0x4dc0, 0xc89d,	0x4dff, 0xc89d,		0x21, 0
	.dw 0x4e40, 0xc89d,	0x4e7f, 0xc89d,		0x21, 0
	.dw 0x4ec0, 0xc89d,	0x4eff, 0xc89d,		0x21, 0
	.dw 0x4f40, 0xc89d,	0x4f7f, 0xc89d,		0x21, 0
	.dw 0x4fc0, 0xc89d,	0x4fff, 0xc89d,		0x21, 0
	.dw 0x5040, 0xc89d,	0x507f, 0xc89d,		0x21, 0
	.dw 0x50c0, 0xc89d,	0x50ff, 0xc89d,		0x21, 0
	.dw 0x5140, 0xc89d,	0x517f, 0xc89d,		0x21, 0
	.dw 0x51c0, 0xc89d,	0x51ff, 0xc89d,		0x21, 0
	.dw 0x5240, 0xc89d,	0x527f, 0xc89d,		0x21, 0
	.dw 0x52c0, 0xc89d,	0x52ff, 0xc89d,		0x21, 0
	.dw 0x5340, 0xc89d,	0x537f, 0xc89d,		0x21, 0
	.dw 0x53c0, 0xc89d,	0x53ff, 0xc89d,		0x21, 0
	.dw 0x5440, 0xc89d,	0x547f, 0xc89d,		0x21, 0
	.dw 0x54c0, 0xc89d,	0x54ff, 0xc89d,		0x21, 0
	.dw 0x5540, 0xc89d,	0x557f, 0xc89d,		0x21, 0
	.dw 0x55c0, 0xc89d,	0x55ff, 0xc89d,		0x21, 0
	.dw 0x5640, 0xc89d,	0x567f, 0xc89d,		0x21, 0
	.dw 0x56c0, 0xc89d,	0x56ff, 0xc89d,		0x21, 0
	.dw 0x5740, 0xc89d,	0x577f, 0xc89d,		0x21, 0
	.dw 0x57c0, 0xc89d,	0x57ff, 0xc89d,		0x21, 0
	.dw 0x5840, 0xc89d,	0x587f, 0xc89d,		0x21, 0
	.dw 0x58c0, 0xc89d,	0x58ff, 0xc89d,		0x21, 0
	.dw 0x5940, 0xc89d,	0x597f, 0xc89d,		0x21, 0
	.dw 0x59c0, 0xc89d,	0x5fff, 0xc89d,		0x21, 0
	.dw 0x6040, 0xc89d,	0x607f, 0xc89d,		0x21, 0
	.dw 0x60c0, 0xc89d,	0x60ff, 0xc89d,		0x21, 0
	.dw 0x6140, 0xc89d,	0x617f, 0xc89d,		0x21, 0
	.dw 0x61c0, 0xc89d,	0x61ff, 0xc89d,		0x21, 0
	.dw 0x6240, 0xc89d,	0x627f, 0xc89d,		0x21, 0
	.dw 0x62c0, 0xc89d,	0x62ff, 0xc89d,		0x21, 0
	.dw 0x6340, 0xc89d,	0x637f, 0xc89d,		0x21, 0
	.dw 0x63c0, 0xc89d,	0x63ff, 0xc89d,		0x21, 0
	.dw 0x6440, 0xc89d,	0x647f, 0xc89d,		0x21, 0
	.dw 0x64c0, 0xc89d,	0x64ff, 0xc89d,		0x21, 0
	.dw 0x6540, 0xc89d,	0x657f, 0xc89d,		0x21, 0
	.dw 0x65c0, 0xc89d,	0x65ff, 0xc89d,		0x21, 0
	.dw 0x6640, 0xc89d,	0x667f, 0xc89d,		0x21, 0
	.dw 0x66c0, 0xc89d,	0x66ff, 0xc89d,		0x21, 0
	.dw 0x6740, 0xc89d,	0x677f, 0xc89d,		0x21, 0
	.dw 0x67c0, 0xc89d,	0x67ff, 0xc89d,		0x21, 0
	.dw 0x6840, 0xc89d,	0x687f, 0xc89d,		0x21, 0
	.dw 0x68c0, 0xc89d,	0x68ff, 0xc89d,		0x21, 0
	.dw 0x6940, 0xc89d,	0x697f, 0xc89d,		0x21, 0
	.dw 0x69c0, 0xc89d,	0x69ff, 0xc89d,		0x21, 0
	.dw 0x6a40, 0xc89d,	0x6a7f, 0xc89d,		0x21, 0
	.dw 0x6ac0, 0xc89d,	0x6aff, 0xc89d,		0x21, 0
	.dw 0x6b40, 0xc89d,	0x6b7f, 0xc89d,		0x21, 0
	.dw 0x6bc0, 0xc89d,	0x6bff, 0xc89d,		0x21, 0
	.dw 0x6c40, 0xc89d,	0x6c7f, 0xc89d,		0x21, 0
	.dw 0x6cc0, 0xc89d,	0x6cff, 0xc89d,		0x21, 0
	.dw 0x6d40, 0xc89d,	0x6d7f, 0xc89d,		0x21, 0
	.dw 0x6dc0, 0xc89d,	0x6dff, 0xc89d,		0x21, 0
	.dw 0x6e40, 0xc89d,	0x6e7f, 0xc89d,		0x21, 0
	.dw 0x6ec0, 0xc89d,	0x6eff, 0xc89d,		0x21, 0
	.dw 0x6f40, 0xc89d,	0x6f7f, 0xc89d,		0x21, 0
	.dw 0x6fc0, 0xc89d,	0x6fff, 0xc89d,		0x21, 0
	.dw 0x7040, 0xc89d,	0x707f, 0xc89d,		0x21, 0
	.dw 0x70c0, 0xc89d,	0x70ff, 0xc89d,		0x21, 0
	.dw 0x7140, 0xc89d,	0x717f, 0xc89d,		0x21, 0
	.dw 0x71c0, 0xc89d,	0x71ff, 0xc89d,		0x21, 0
	.dw 0x7240, 0xc89d,	0x727f, 0xc89d,		0x21, 0
	.dw 0x72c0, 0xc89d,	0x72ff, 0xc89d,		0x21, 0
	.dw 0x7340, 0xc89d,	0x737f, 0xc89d,		0x21, 0
	.dw 0x73c0, 0xc89d,	0x73ff, 0xc89d,		0x21, 0
	.dw 0x7440, 0xc89d,	0x747f, 0xc89d,		0x21, 0
	.dw 0x74c0, 0xc89d,	0x74ff, 0xc89d,		0x21, 0
	.dw 0x7540, 0xc89d,	0x757f, 0xc89d,		0x21, 0
	.dw 0x75c0, 0xc89d,	0x75ff, 0xc89d,		0x21, 0
	.dw 0x7640, 0xc89d,	0x767f, 0xc89d,		0x21, 0
	.dw 0x76c0, 0xc89d,	0x76ff, 0xc89d,		0x21, 0
	.dw 0x7740, 0xc89d,	0x777f, 0xc89d,		0x21, 0
	.dw 0x77c0, 0xc89d,	0x77ff, 0xc89d,		0x21, 0
	.dw 0x7840, 0xc89d,	0x787f, 0xc89d,		0x21, 0
	.dw 0x78c0, 0xc89d,	0x78ff, 0xc89d,		0x21, 0
	.dw 0x7940, 0xc89d,	0x797f, 0xc89d,		0x21, 0
	.dw 0x79c0, 0xc89d,	0x7fff, 0xc89d,		0x21, 0
	.dw 0x8040, 0xc89d,	0x807f, 0xc89d,		0x21, 0
	.dw 0x80c0, 0xc89d,	0x80ff, 0xc89d,		0x21, 0
	.dw 0x8140, 0xc89d,	0x817f, 0xc89d,		0x21, 0
	.dw 0x81c0, 0xc89d,	0x81ff, 0xc89d,		0x21, 0
	.dw 0x8240, 0xc89d,	0x827f, 0xc89d,		0x21, 0
	.dw 0x82c0, 0xc89d,	0x82ff, 0xc89d,		0x21, 0
	.dw 0x8340, 0xc89d,	0x837f, 0xc89d,		0x21, 0
	.dw 0x83c0, 0xc89d,	0x83ff, 0xc89d,		0x21, 0
	.dw 0x8440, 0xc89d,	0x847f, 0xc89d,		0x21, 0
	.dw 0x84c0, 0xc89d,	0x84ff, 0xc89d,		0x21, 0
	.dw 0x8540, 0xc89d,	0x857f, 0xc89d,		0x21, 0
	.dw 0x85c0, 0xc89d,	0x85ff, 0xc89d,		0x21, 0
	.dw 0x8640, 0xc89d,	0x867f, 0xc89d,		0x21, 0
	.dw 0x86c0, 0xc89d,	0x86ff, 0xc89d,		0x21, 0
	.dw 0x8740, 0xc89d,	0x877f, 0xc89d,		0x21, 0
	.dw 0x87c0, 0xc89d,	0x87ff, 0xc89d,		0x21, 0
	.dw 0x8840, 0xc89d,	0x887f, 0xc89d,		0x21, 0
	.dw 0x88c0, 0xc89d,	0x88ff, 0xc89d,		0x21, 0
	.dw 0x8940, 0xc89d,	0x897f, 0xc89d,		0x21, 0
	.dw 0x89c0, 0xc89d,	0x89ff, 0xc89d,		0x21, 0
	.dw 0x8a40, 0xc89d,	0x8a7f, 0xc89d,		0x21, 0
	.dw 0x8ac0, 0xc89d,	0x8aff, 0xc89d,		0x21, 0
	.dw 0x8b40, 0xc89d,	0x8b7f, 0xc89d,		0x21, 0
	.dw 0x8bc0, 0xc89d,	0x8bff, 0xc89d,		0x21, 0
	.dw 0x8c40, 0xc89d,	0x8c7f, 0xc89d,		0x21, 0
	.dw 0x8cc0, 0xc89d,	0x8cff, 0xc89d,		0x21, 0
	.dw 0x8d40, 0xc89d,	0x8d7f, 0xc89d,		0x21, 0
	.dw 0x8dc0, 0xc89d,	0x8dff, 0xc89d,		0x21, 0
	.dw 0x8e40, 0xc89d,	0x8e7f, 0xc89d,		0x21, 0
	.dw 0x8ec0, 0xc89d,	0x8eff, 0xc89d,		0x21, 0
	.dw 0x8f40, 0xc89d,	0x8f7f, 0xc89d,		0x21, 0
	.dw 0x8fc0, 0xc89d,	0x8fff, 0xc89d,		0x21, 0
	.dw 0x9040, 0xc89d,	0x907f, 0xc89d,		0x21, 0
	.dw 0x90c0, 0xc89d,	0x90ff, 0xc89d,		0x21, 0
	.dw 0x9140, 0xc89d,	0x917f, 0xc89d,		0x21, 0
	.dw 0x91c0, 0xc89d,	0x91ff, 0xc89d,		0x21, 0
	.dw 0x9240, 0xc89d,	0x927f, 0xc89d,		0x21, 0
	.dw 0x92c0, 0xc89d,	0x92ff, 0xc89d,		0x21, 0
	.dw 0x9340, 0xc89d,	0x937f, 0xc89d,		0x21, 0
	.dw 0x93c0, 0xc89d,	0x93ff, 0xc89d,		0x21, 0
	.dw 0x9440, 0xc89d,	0x947f, 0xc89d,		0x21, 0
	.dw 0x94c0, 0xc89d,	0x94ff, 0xc89d,		0x21, 0
	.dw 0x9540, 0xc89d,	0x957f, 0xc89d,		0x21, 0
	.dw 0x95c0, 0xc89d,	0x95ff, 0xc89d,		0x21, 0
	.dw 0x9640, 0xc89d,	0x967f, 0xc89d,		0x21, 0
	.dw 0x96c0, 0xc89d,	0x96ff, 0xc89d,		0x21, 0
	.dw 0x9740, 0xc89d,	0x977f, 0xc89d,		0x21, 0
	.dw 0x97c0, 0xc89d,	0x97ff, 0xc89d,		0x21, 0
	.dw 0x9840, 0xc89d,	0x987f, 0xc89d,		0x21, 0
	.dw 0x98c0, 0xc89d,	0x98ff, 0xc89d,		0x21, 0
	.dw 0x9940, 0xc89d,	0x997f, 0xc89d,		0x21, 0
	.dw 0x99c0, 0xc89d,	0x9fff, 0xc89d,		0x21, 0
	.dw 0xa040, 0xc89d,	0xa07f, 0xc89d,		0x21, 0
	.dw 0xa0c0, 0xc89d,	0xa0ff, 0xc89d,		0x21, 0
	.dw 0xa140, 0xc89d,	0xa17f, 0xc89d,		0x21, 0
	.dw 0xa1c0, 0xc89d,	0xa1ff, 0xc89d,		0x21, 0
	.dw 0xa240, 0xc89d,	0xa27f, 0xc89d,		0x21, 0
	.dw 0xa2c0, 0xc89d,	0xa2ff, 0xc89d,		0x21, 0
	.dw 0xa340, 0xc89d,	0xa37f, 0xc89d,		0x21, 0
	.dw 0xa3c0, 0xc89d,	0xa3ff, 0xc89d,		0x21, 0
	.dw 0xa440, 0xc89d,	0xa47f, 0xc89d,		0x21, 0
	.dw 0xa4c0, 0xc89d,	0xa4ff, 0xc89d,		0x21, 0
	.dw 0xa540, 0xc89d,	0xa57f, 0xc89d,		0x21, 0
	.dw 0xa5c0, 0xc89d,	0xa5ff, 0xc89d,		0x21, 0
	.dw 0xa640, 0xc89d,	0xa67f, 0xc89d,		0x21, 0
	.dw 0xa6c0, 0xc89d,	0xa6ff, 0xc89d,		0x21, 0
	.dw 0xa740, 0xc89d,	0xa77f, 0xc89d,		0x21, 0
	.dw 0xa7c0, 0xc89d,	0xa7ff, 0xc89d,		0x21, 0
	.dw 0xa840, 0xc89d,	0xa87f, 0xc89d,		0x21, 0
	.dw 0xa8c0, 0xc89d,	0xa8ff, 0xc89d,		0x21, 0
	.dw 0xa940, 0xc89d,	0xa97f, 0xc89d,		0x21, 0
	.dw 0xa9c0, 0xc89d,	0xa9ff, 0xc89d,		0x21, 0
	.dw 0xaa40, 0xc89d,	0xaa7f, 0xc89d,		0x21, 0
	.dw 0xaac0, 0xc89d,	0xaaff, 0xc89d,		0x21, 0
	.dw 0xab40, 0xc89d,	0xab7f, 0xc89d,		0x21, 0
	.dw 0xabc0, 0xc89d,	0xabff, 0xc89d,		0x21, 0
	.dw 0xac40, 0xc89d,	0xac7f, 0xc89d,		0x21, 0
	.dw 0xacc0, 0xc89d,	0xacff, 0xc89d,		0x21, 0
	.dw 0xad40, 0xc89d,	0xad7f, 0xc89d,		0x21, 0
	.dw 0xadc0, 0xc89d,	0xadff, 0xc89d,		0x21, 0
	.dw 0xae40, 0xc89d,	0xae7f, 0xc89d,		0x21, 0
	.dw 0xaec0, 0xc89d,	0xaeff, 0xc89d,		0x21, 0
	.dw 0xaf40, 0xc89d,	0xaf7f, 0xc89d,		0x21, 0
	.dw 0xafc0, 0xc89d,	0xafff, 0xc89d,		0x21, 0
	.dw 0xb040, 0xc89d,	0xb07f, 0xc89d,		0x21, 0
	.dw 0xb0c0, 0xc89d,	0xb0ff, 0xc89d,		0x21, 0
	.dw 0xb140, 0xc89d,	0xb17f, 0xc89d,		0x21, 0
	.dw 0xb1c0, 0xc89d,	0xb1ff, 0xc89d,		0x21, 0
	.dw 0xb240, 0xc89d,	0xb27f, 0xc89d,		0x21, 0
	.dw 0xb2c0, 0xc89d,	0xb2ff, 0xc89d,		0x21, 0
	.dw 0xb340, 0xc89d,	0xb37f, 0xc89d,		0x21, 0
	.dw 0xb3c0, 0xc89d,	0xb3ff, 0xc89d,		0x21, 0
	.dw 0xb440, 0xc89d,	0xb47f, 0xc89d,		0x21, 0
	.dw 0xb4c0, 0xc89d,	0xb4ff, 0xc89d,		0x21, 0
	.dw 0xb540, 0xc89d,	0xb57f, 0xc89d,		0x21, 0
	.dw 0xb5c0, 0xc89d,	0xb5ff, 0xc89d,		0x21, 0
	.dw 0xb640, 0xc89d,	0xb67f, 0xc89d,		0x21, 0
	.dw 0xb6c0, 0xc89d,	0xb6ff, 0xc89d,		0x21, 0
	.dw 0xb740, 0xc89d,	0xb77f, 0xc89d,		0x21, 0
	.dw 0xb7c0, 0xc89d,	0xb7ff, 0xc89d,		0x21, 0
	.dw 0xb840, 0xc89d,	0xb87f, 0xc89d,		0x21, 0
	.dw 0xb8c0, 0xc89d,	0xb8ff, 0xc89d,		0x21, 0
	.dw 0xb940, 0xc89d,	0xb97f, 0xc89d,		0x21, 0
	.dw 0xb9c0, 0xc89d,	0xbfff, 0xc89d,		0x21, 0
	.dw 0xc040, 0xc89d,	0xc07f, 0xc89d,		0x21, 0
	.dw 0xc0c0, 0xc89d,	0xc0ff, 0xc89d,		0x21, 0
	.dw 0xc140, 0xc89d,	0xc17f, 0xc89d,		0x21, 0
	.dw 0xc1c0, 0xc89d,	0xc1ff, 0xc89d,		0x21, 0
	.dw 0xc240, 0xc89d,	0xc27f, 0xc89d,		0x21, 0
	.dw 0xc2c0, 0xc89d,	0xc2ff, 0xc89d,		0x21, 0
	.dw 0xc340, 0xc89d,	0xc37f, 0xc89d,		0x21, 0
	.dw 0xc3c0, 0xc89d,	0xc3ff, 0xc89d,		0x21, 0
	.dw 0xc440, 0xc89d,	0xc47f, 0xc89d,		0x21, 0
	.dw 0xc4c0, 0xc89d,	0xc4ff, 0xc89d,		0x21, 0
	.dw 0xc540, 0xc89d,	0xc57f, 0xc89d,		0x21, 0
	.dw 0xc5c0, 0xc89d,	0xc5ff, 0xc89d,		0x21, 0
	.dw 0xc640, 0xc89d,	0xc67f, 0xc89d,		0x21, 0
	.dw 0xc6c0, 0xc89d,	0xc6ff, 0xc89d,		0x21, 0
	.dw 0xc740, 0xc89d,	0xc77f, 0xc89d,		0x21, 0
	.dw 0xc7c0, 0xc89d,	0xc7ff, 0xc89d,		0x21, 0
	.dw 0xc840, 0xc89d,	0xc87f, 0xc89d,		0x21, 0
	.dw 0xc8c0, 0xc89d,	0xc8ff, 0xc89d,		0x21, 0
	.dw 0xc940, 0xc89d,	0xc97f, 0xc89d,		0x21, 0
	.dw 0xc9c0, 0xc89d,	0xc9ff, 0xc89d,		0x21, 0
	.dw 0xca40, 0xc89d,	0xca7f, 0xc89d,		0x21, 0
	.dw 0xcac0, 0xc89d,	0xcaff, 0xc89d,		0x21, 0
	.dw 0xcb40, 0xc89d,	0xcb7f, 0xc89d,		0x21, 0
	.dw 0xcbc0, 0xc89d,	0xcbff, 0xc89d,		0x21, 0
	.dw 0xcc40, 0xc89d,	0xcc7f, 0xc89d,		0x21, 0
	.dw 0xccc0, 0xc89d,	0xccff, 0xc89d,		0x21, 0
	.dw 0xcd40, 0xc89d,	0xcd7f, 0xc89d,		0x21, 0
	.dw 0xcdc0, 0xc89d,	0xcdff, 0xc89d,		0x21, 0
	.dw 0xce40, 0xc89d,	0xce7f, 0xc89d,		0x21, 0
	.dw 0xcec0, 0xc89d,	0xceff, 0xc89d,		0x21, 0
	.dw 0xcf40, 0xc89d,	0xcf7f, 0xc89d,		0x21, 0
	.dw 0xcfc0, 0xc89d,	0xcfff, 0xc89d,		0x21, 0
	.dw 0xd040, 0xc89d,	0xd07f, 0xc89d,		0x21, 0
	.dw 0xd0c0, 0xc89d,	0xd0ff, 0xc89d,		0x21, 0
	.dw 0xd140, 0xc89d,	0xd17f, 0xc89d,		0x21, 0
	.dw 0xd1c0, 0xc89d,	0xd1ff, 0xc89d,		0x21, 0
	.dw 0xd240, 0xc89d,	0xd27f, 0xc89d,		0x21, 0
	.dw 0xd2c0, 0xc89d,	0xd2ff, 0xc89d,		0x21, 0
	.dw 0xd340, 0xc89d,	0xd37f, 0xc89d,		0x21, 0
	.dw 0xd3c0, 0xc89d,	0xd3ff, 0xc89d,		0x21, 0
	.dw 0xd440, 0xc89d,	0xd47f, 0xc89d,		0x21, 0
	.dw 0xd4c0, 0xc89d,	0xd4ff, 0xc89d,		0x21, 0
	.dw 0xd540, 0xc89d,	0xd57f, 0xc89d,		0x21, 0
	.dw 0xd5c0, 0xc89d,	0xd5ff, 0xc89d,		0x21, 0
	.dw 0xd640, 0xc89d,	0xd67f, 0xc89d,		0x21, 0
	.dw 0xd6c0, 0xc89d,	0xd6ff, 0xc89d,		0x21, 0
	.dw 0xd740, 0xc89d,	0xd77f, 0xc89d,		0x21, 0
	.dw 0xd7c0, 0xc89d,	0xd7ff, 0xc89d,		0x21, 0
	.dw 0xd840, 0xc89d,	0xd87f, 0xc89d,		0x21, 0
	.dw 0xd8c0, 0xc89d,	0xd8ff, 0xc89d,		0x21, 0
	.dw 0xd940, 0xc89d,	0xd97f, 0xc89d,		0x21, 0
	.dw 0xd9c0, 0xc89d,	0xdfff, 0xc89d,		0x21, 0
	.dw 0xe040, 0xc89d,	0xe07f, 0xc89d,		0x21, 0
	.dw 0xe0c0, 0xc89d,	0xe0ff, 0xc89d,		0x21, 0
	.dw 0xe140, 0xc89d,	0xe17f, 0xc89d,		0x21, 0
	.dw 0xe1c0, 0xc89d,	0xe1ff, 0xc89d,		0x21, 0
	.dw 0xe240, 0xc89d,	0xe27f, 0xc89d,		0x21, 0
	.dw 0xe2c0, 0xc89d,	0xe2ff, 0xc89d,		0x21, 0
	.dw 0xe340, 0xc89d,	0xe37f, 0xc89d,		0x21, 0
	.dw 0xe3c0, 0xc89d,	0xe3ff, 0xc89d,		0x21, 0
	.dw 0xe440, 0xc89d,	0xe47f, 0xc89d,		0x21, 0
	.dw 0xe4c0, 0xc89d,	0xe4ff, 0xc89d,		0x21, 0
	.dw 0xe540, 0xc89d,	0xe57f, 0xc89d,		0x21, 0
	.dw 0xe5c0, 0xc89d,	0xe5ff, 0xc89d,		0x21, 0
	.dw 0xe640, 0xc89d,	0xe67f, 0xc89d,		0x21, 0
	.dw 0xe6c0, 0xc89d,	0xe6ff, 0xc89d,		0x21, 0
	.dw 0xe740, 0xc89d,	0xe77f, 0xc89d,		0x21, 0
	.dw 0xe7c0, 0xc89d,	0xe7ff, 0xc89d,		0x21, 0
	.dw 0xe840, 0xc89d,	0xe87f, 0xc89d,		0x21, 0
	.dw 0xe8c0, 0xc89d,	0xe8ff, 0xc89d,		0x21, 0
	.dw 0xe940, 0xc89d,	0xe97f, 0xc89d,		0x21, 0
	.dw 0xe9c0, 0xc89d,	0xe9ff, 0xc89d,		0x21, 0
	.dw 0xea40, 0xc89d,	0xea7f, 0xc89d,		0x21, 0
	.dw 0xeac0, 0xc89d,	0xeaff, 0xc89d,		0x21, 0
	.dw 0xeb40, 0xc89d,	0xeb7f, 0xc89d,		0x21, 0
	.dw 0xebc0, 0xc89d,	0xebff, 0xc89d,		0x21, 0
	.dw 0xec40, 0xc89d,	0xec7f, 0xc89d,		0x21, 0
	.dw 0xecc0, 0xc89d,	0xecff, 0xc89d,		0x21, 0
	.dw 0xed40, 0xc89d,	0xed7f, 0xc89d,		0x21, 0
	.dw 0xedc0, 0xc89d,	0xedff, 0xc89d,		0x21, 0
	.dw 0xee40, 0xc89d,	0xee7f, 0xc89d,		0x21, 0
	.dw 0xeec0, 0xc89d,	0xeeff, 0xc89d,		0x21, 0
	.dw 0xef40, 0xc89d,	0xef7f, 0xc89d,		0x21, 0
	.dw 0xefc0, 0xc89d,	0xefff, 0xc89d,		0x21, 0
	.dw 0xf040, 0xc89d,	0xf07f, 0xc89d,		0x21, 0
	.dw 0xf0c0, 0xc89d,	0xf0ff, 0xc89d,		0x21, 0
	.dw 0xf140, 0xc89d,	0xf17f, 0xc89d,		0x21, 0
	.dw 0xf1c0, 0xc89d,	0xf1ff, 0xc89d,		0x21, 0
	.dw 0xf240, 0xc89d,	0xf27f, 0xc89d,		0x21, 0
	.dw 0xf2c0, 0xc89d,	0xf2ff, 0xc89d,		0x21, 0
	.dw 0xf340, 0xc89d,	0xf37f, 0xc89d,		0x21, 0
	.dw 0xf3c0, 0xc89d,	0xf3ff, 0xc89d,		0x21, 0
	.dw 0xf440, 0xc89d,	0xf47f, 0xc89d,		0x21, 0
	.dw 0xf4c0, 0xc89d,	0xf4ff, 0xc89d,		0x21, 0
	.dw 0xf540, 0xc89d,	0xf57f, 0xc89d,		0x21, 0
	.dw 0xf5c0, 0xc89d,	0xf5ff, 0xc89d,		0x21, 0
	.dw 0xf640, 0xc89d,	0xf67f, 0xc89d,		0x21, 0
	.dw 0xf6c0, 0xc89d,	0xf6ff, 0xc89d,		0x21, 0
	.dw 0xf740, 0xc89d,	0xf77f, 0xc89d,		0x21, 0
	.dw 0xf7c0, 0xc89d,	0xf7ff, 0xc89d,		0x21, 0
	.dw 0xf840, 0xc89d,	0xf87f, 0xc89d,		0x21, 0
	.dw 0xf8c0, 0xc89d,	0xf8ff, 0xc89d,		0x21, 0
	.dw 0xf940, 0xc89d,	0xf97f, 0xc89d,		0x21, 0
	.dw 0xf9c0, 0xc89d,	0xffff, 0xc89d,		0x21, 0
	.dw 0x0040, 0xc89e,	0x007f, 0xc89e,		0x21, 0
	.dw 0x00c0, 0xc89e,	0x00ff, 0xc89e,		0x21, 0
	.dw 0x0140, 0xc89e,	0x017f, 0xc89e,		0x21, 0
	.dw 0x01c0, 0xc89e,	0x01ff, 0xc89e,		0x21, 0
	.dw 0x0240, 0xc89e,	0x027f, 0xc89e,		0x21, 0
	.dw 0x02c0, 0xc89e,	0x02ff, 0xc89e,		0x21, 0
	.dw 0x0340, 0xc89e,	0x037f, 0xc89e,		0x21, 0
	.dw 0x03c0, 0xc89e,	0x03ff, 0xc89e,		0x21, 0
	.dw 0x0440, 0xc89e,	0x047f, 0xc89e,		0x21, 0
	.dw 0x04c0, 0xc89e,	0x04ff, 0xc89e,		0x21, 0
	.dw 0x0540, 0xc89e,	0x057f, 0xc89e,		0x21, 0
	.dw 0x05c0, 0xc89e,	0x05ff, 0xc89e,		0x21, 0
	.dw 0x0640, 0xc89e,	0x067f, 0xc89e,		0x21, 0
	.dw 0x06c0, 0xc89e,	0x06ff, 0xc89e,		0x21, 0
	.dw 0x0740, 0xc89e,	0x077f, 0xc89e,		0x21, 0
	.dw 0x07c0, 0xc89e,	0x07ff, 0xc89e,		0x21, 0
	.dw 0x0840, 0xc89e,	0x087f, 0xc89e,		0x21, 0
	.dw 0x08c0, 0xc89e,	0x08ff, 0xc89e,		0x21, 0
	.dw 0x0940, 0xc89e,	0x097f, 0xc89e,		0x21, 0
	.dw 0x09c0, 0xc89e,	0x09ff, 0xc89e,		0x21, 0
	.dw 0x0a40, 0xc89e,	0x0a7f, 0xc89e,		0x21, 0
	.dw 0x0ac0, 0xc89e,	0x0aff, 0xc89e,		0x21, 0
	.dw 0x0b40, 0xc89e,	0x0b7f, 0xc89e,		0x21, 0
	.dw 0x0bc0, 0xc89e,	0x0bff, 0xc89e,		0x21, 0
	.dw 0x0c40, 0xc89e,	0x0c7f, 0xc89e,		0x21, 0
	.dw 0x0cc0, 0xc89e,	0x0cff, 0xc89e,		0x21, 0
	.dw 0x0d40, 0xc89e,	0x0d7f, 0xc89e,		0x21, 0
	.dw 0x0dc0, 0xc89e,	0x0dff, 0xc89e,		0x21, 0
	.dw 0x0e40, 0xc89e,	0x0e7f, 0xc89e,		0x21, 0
	.dw 0x0ec0, 0xc89e,	0x0eff, 0xc89e,		0x21, 0
	.dw 0x0f40, 0xc89e,	0x0f7f, 0xc89e,		0x21, 0
	.dw 0x0fc0, 0xc89e,	0x0fff, 0xc89e,		0x21, 0
	.dw 0x1040, 0xc89e,	0x107f, 0xc89e,		0x21, 0
	.dw 0x10c0, 0xc89e,	0x10ff, 0xc89e,		0x21, 0
	.dw 0x1140, 0xc89e,	0x117f, 0xc89e,		0x21, 0
	.dw 0x11c0, 0xc89e,	0x11ff, 0xc89e,		0x21, 0
	.dw 0x1240, 0xc89e,	0x127f, 0xc89e,		0x21, 0
	.dw 0x12c0, 0xc89e,	0x12ff, 0xc89e,		0x21, 0
	.dw 0x1340, 0xc89e,	0x137f, 0xc89e,		0x21, 0
	.dw 0x13c0, 0xc89e,	0x13ff, 0xc89e,		0x21, 0
	.dw 0x1440, 0xc89e,	0x147f, 0xc89e,		0x21, 0
	.dw 0x14c0, 0xc89e,	0x14ff, 0xc89e,		0x21, 0
	.dw 0x1540, 0xc89e,	0x157f, 0xc89e,		0x21, 0
	.dw 0x15c0, 0xc89e,	0x15ff, 0xc89e,		0x21, 0
	.dw 0x1640, 0xc89e,	0x167f, 0xc89e,		0x21, 0
	.dw 0x16c0, 0xc89e,	0x16ff, 0xc89e,		0x21, 0
	.dw 0x1740, 0xc89e,	0x177f, 0xc89e,		0x21, 0
	.dw 0x17c0, 0xc89e,	0x17ff, 0xc89e,		0x21, 0
	.dw 0x1840, 0xc89e,	0x187f, 0xc89e,		0x21, 0
	.dw 0x18c0, 0xc89e,	0x18ff, 0xc89e,		0x21, 0
	.dw 0x1940, 0xc89e,	0x197f, 0xc89e,		0x21, 0
	.dw 0x19c0, 0xc89e,	0x1fff, 0xc89e,		0x21, 0
	.dw 0x2040, 0xc89e,	0x207f, 0xc89e,		0x21, 0
	.dw 0x20c0, 0xc89e,	0x20ff, 0xc89e,		0x21, 0
	.dw 0x2140, 0xc89e,	0x217f, 0xc89e,		0x21, 0
	.dw 0x21c0, 0xc89e,	0x21ff, 0xc89e,		0x21, 0
	.dw 0x2240, 0xc89e,	0x227f, 0xc89e,		0x21, 0
	.dw 0x22c0, 0xc89e,	0x22ff, 0xc89e,		0x21, 0
	.dw 0x2340, 0xc89e,	0x237f, 0xc89e,		0x21, 0
	.dw 0x23c0, 0xc89e,	0x23ff, 0xc89e,		0x21, 0
	.dw 0x2440, 0xc89e,	0x247f, 0xc89e,		0x21, 0
	.dw 0x24c0, 0xc89e,	0x24ff, 0xc89e,		0x21, 0
	.dw 0x2540, 0xc89e,	0x257f, 0xc89e,		0x21, 0
	.dw 0x25c0, 0xc89e,	0x25ff, 0xc89e,		0x21, 0
	.dw 0x2640, 0xc89e,	0x267f, 0xc89e,		0x21, 0
	.dw 0x26c0, 0xc89e,	0x26ff, 0xc89e,		0x21, 0
	.dw 0x2740, 0xc89e,	0x277f, 0xc89e,		0x21, 0
	.dw 0x27c0, 0xc89e,	0x27ff, 0xc89e,		0x21, 0
	.dw 0x2840, 0xc89e,	0x287f, 0xc89e,		0x21, 0
	.dw 0x28c0, 0xc89e,	0x28ff, 0xc89e,		0x21, 0
	.dw 0x2940, 0xc89e,	0x297f, 0xc89e,		0x21, 0
	.dw 0x29c0, 0xc89e,	0x29ff, 0xc89e,		0x21, 0
	.dw 0x2a40, 0xc89e,	0x2a7f, 0xc89e,		0x21, 0
	.dw 0x2ac0, 0xc89e,	0x2aff, 0xc89e,		0x21, 0
	.dw 0x2b40, 0xc89e,	0x2b7f, 0xc89e,		0x21, 0
	.dw 0x2bc0, 0xc89e,	0x2bff, 0xc89e,		0x21, 0
	.dw 0x2c40, 0xc89e,	0x2c7f, 0xc89e,		0x21, 0
	.dw 0x2cc0, 0xc89e,	0x2cff, 0xc89e,		0x21, 0
	.dw 0x2d40, 0xc89e,	0x2d7f, 0xc89e,		0x21, 0
	.dw 0x2dc0, 0xc89e,	0x2dff, 0xc89e,		0x21, 0
	.dw 0x2e40, 0xc89e,	0x2e7f, 0xc89e,		0x21, 0
	.dw 0x2ec0, 0xc89e,	0x2eff, 0xc89e,		0x21, 0
	.dw 0x2f40, 0xc89e,	0x2f7f, 0xc89e,		0x21, 0
	.dw 0x2fc0, 0xc89e,	0x2fff, 0xc89e,		0x21, 0
	.dw 0x3040, 0xc89e,	0x307f, 0xc89e,		0x21, 0
	.dw 0x30c0, 0xc89e,	0x30ff, 0xc89e,		0x21, 0
	.dw 0x3140, 0xc89e,	0x317f, 0xc89e,		0x21, 0
	.dw 0x31c0, 0xc89e,	0x31ff, 0xc89e,		0x21, 0
	.dw 0x3240, 0xc89e,	0x327f, 0xc89e,		0x21, 0
	.dw 0x32c0, 0xc89e,	0x32ff, 0xc89e,		0x21, 0
	.dw 0x3340, 0xc89e,	0x337f, 0xc89e,		0x21, 0
	.dw 0x33c0, 0xc89e,	0x33ff, 0xc89e,		0x21, 0
	.dw 0x3440, 0xc89e,	0x347f, 0xc89e,		0x21, 0
	.dw 0x34c0, 0xc89e,	0x34ff, 0xc89e,		0x21, 0
	.dw 0x3540, 0xc89e,	0x357f, 0xc89e,		0x21, 0
	.dw 0x35c0, 0xc89e,	0x35ff, 0xc89e,		0x21, 0
	.dw 0x3640, 0xc89e,	0x367f, 0xc89e,		0x21, 0
	.dw 0x36c0, 0xc89e,	0x36ff, 0xc89e,		0x21, 0
	.dw 0x3740, 0xc89e,	0x377f, 0xc89e,		0x21, 0
	.dw 0x37c0, 0xc89e,	0x37ff, 0xc89e,		0x21, 0
	.dw 0x3840, 0xc89e,	0x387f, 0xc89e,		0x21, 0
	.dw 0x38c0, 0xc89e,	0x38ff, 0xc89e,		0x21, 0
	.dw 0x3940, 0xc89e,	0x397f, 0xc89e,		0x21, 0
	.dw 0x39c0, 0xc89e,	0x3fff, 0xc89e,		0x21, 0
	.dw 0x4040, 0xc89e,	0x407f, 0xc89e,		0x21, 0
	.dw 0x40c0, 0xc89e,	0x40ff, 0xc89e,		0x21, 0
	.dw 0x4140, 0xc89e,	0x417f, 0xc89e,		0x21, 0
	.dw 0x41c0, 0xc89e,	0x41ff, 0xc89e,		0x21, 0
	.dw 0x4240, 0xc89e,	0x427f, 0xc89e,		0x21, 0
	.dw 0x42c0, 0xc89e,	0x42ff, 0xc89e,		0x21, 0
	.dw 0x4340, 0xc89e,	0x437f, 0xc89e,		0x21, 0
	.dw 0x43c0, 0xc89e,	0x43ff, 0xc89e,		0x21, 0
	.dw 0x4440, 0xc89e,	0x447f, 0xc89e,		0x21, 0
	.dw 0x44c0, 0xc89e,	0x44ff, 0xc89e,		0x21, 0
	.dw 0x4540, 0xc89e,	0x457f, 0xc89e,		0x21, 0
	.dw 0x45c0, 0xc89e,	0x45ff, 0xc89e,		0x21, 0
	.dw 0x4640, 0xc89e,	0x467f, 0xc89e,		0x21, 0
	.dw 0x46c0, 0xc89e,	0x46ff, 0xc89e,		0x21, 0
	.dw 0x4740, 0xc89e,	0x477f, 0xc89e,		0x21, 0
	.dw 0x47c0, 0xc89e,	0x47ff, 0xc89e,		0x21, 0
	.dw 0x4840, 0xc89e,	0x487f, 0xc89e,		0x21, 0
	.dw 0x48c0, 0xc89e,	0x48ff, 0xc89e,		0x21, 0
	.dw 0x4940, 0xc89e,	0x497f, 0xc89e,		0x21, 0
	.dw 0x49c0, 0xc89e,	0x49ff, 0xc89e,		0x21, 0
	.dw 0x4a40, 0xc89e,	0x4a7f, 0xc89e,		0x21, 0
	.dw 0x4ac0, 0xc89e,	0x4aff, 0xc89e,		0x21, 0
	.dw 0x4b40, 0xc89e,	0x4b7f, 0xc89e,		0x21, 0
	.dw 0x4bc0, 0xc89e,	0x4bff, 0xc89e,		0x21, 0
	.dw 0x4c40, 0xc89e,	0x4c7f, 0xc89e,		0x21, 0
	.dw 0x4cc0, 0xc89e,	0x4cff, 0xc89e,		0x21, 0
	.dw 0x4d40, 0xc89e,	0x4d7f, 0xc89e,		0x21, 0
	.dw 0x4dc0, 0xc89e,	0x4dff, 0xc89e,		0x21, 0
	.dw 0x4e40, 0xc89e,	0x4e7f, 0xc89e,		0x21, 0
	.dw 0x4ec0, 0xc89e,	0x4eff, 0xc89e,		0x21, 0
	.dw 0x4f40, 0xc89e,	0x4f7f, 0xc89e,		0x21, 0
	.dw 0x4fc0, 0xc89e,	0x4fff, 0xc89e,		0x21, 0
	.dw 0x5040, 0xc89e,	0x507f, 0xc89e,		0x21, 0
	.dw 0x50c0, 0xc89e,	0x50ff, 0xc89e,		0x21, 0
	.dw 0x5140, 0xc89e,	0x517f, 0xc89e,		0x21, 0
	.dw 0x51c0, 0xc89e,	0x51ff, 0xc89e,		0x21, 0
	.dw 0x5240, 0xc89e,	0x527f, 0xc89e,		0x21, 0
	.dw 0x52c0, 0xc89e,	0x52ff, 0xc89e,		0x21, 0
	.dw 0x5340, 0xc89e,	0x537f, 0xc89e,		0x21, 0
	.dw 0x53c0, 0xc89e,	0x53ff, 0xc89e,		0x21, 0
	.dw 0x5440, 0xc89e,	0x547f, 0xc89e,		0x21, 0
	.dw 0x54c0, 0xc89e,	0x54ff, 0xc89e,		0x21, 0
	.dw 0x5540, 0xc89e,	0x557f, 0xc89e,		0x21, 0
	.dw 0x55c0, 0xc89e,	0x55ff, 0xc89e,		0x21, 0
	.dw 0x5640, 0xc89e,	0x567f, 0xc89e,		0x21, 0
	.dw 0x56c0, 0xc89e,	0x56ff, 0xc89e,		0x21, 0
	.dw 0x5740, 0xc89e,	0x577f, 0xc89e,		0x21, 0
	.dw 0x57c0, 0xc89e,	0x57ff, 0xc89e,		0x21, 0
	.dw 0x5840, 0xc89e,	0x587f, 0xc89e,		0x21, 0
	.dw 0x58c0, 0xc89e,	0x58ff, 0xc89e,		0x21, 0
	.dw 0x5940, 0xc89e,	0x597f, 0xc89e,		0x21, 0
	.dw 0x59c0, 0xc89e,	0x5fff, 0xc89e,		0x21, 0
	.dw 0x6040, 0xc89e,	0x607f, 0xc89e,		0x21, 0
	.dw 0x60c0, 0xc89e,	0x60ff, 0xc89e,		0x21, 0
	.dw 0x6140, 0xc89e,	0x617f, 0xc89e,		0x21, 0
	.dw 0x61c0, 0xc89e,	0x61ff, 0xc89e,		0x21, 0
	.dw 0x6240, 0xc89e,	0x627f, 0xc89e,		0x21, 0
	.dw 0x62c0, 0xc89e,	0x62ff, 0xc89e,		0x21, 0
	.dw 0x6340, 0xc89e,	0x637f, 0xc89e,		0x21, 0
	.dw 0x63c0, 0xc89e,	0x63ff, 0xc89e,		0x21, 0
	.dw 0x6440, 0xc89e,	0x647f, 0xc89e,		0x21, 0
	.dw 0x64c0, 0xc89e,	0x64ff, 0xc89e,		0x21, 0
	.dw 0x6540, 0xc89e,	0x657f, 0xc89e,		0x21, 0
	.dw 0x65c0, 0xc89e,	0x65ff, 0xc89e,		0x21, 0
	.dw 0x6640, 0xc89e,	0x667f, 0xc89e,		0x21, 0
	.dw 0x66c0, 0xc89e,	0x66ff, 0xc89e,		0x21, 0
	.dw 0x6740, 0xc89e,	0x677f, 0xc89e,		0x21, 0
	.dw 0x67c0, 0xc89e,	0x67ff, 0xc89e,		0x21, 0
	.dw 0x6840, 0xc89e,	0x687f, 0xc89e,		0x21, 0
	.dw 0x68c0, 0xc89e,	0x68ff, 0xc89e,		0x21, 0
	.dw 0x6940, 0xc89e,	0x697f, 0xc89e,		0x21, 0
	.dw 0x69c0, 0xc89e,	0x69ff, 0xc89e,		0x21, 0
	.dw 0x6a40, 0xc89e,	0x6a7f, 0xc89e,		0x21, 0
	.dw 0x6ac0, 0xc89e,	0x6aff, 0xc89e,		0x21, 0
	.dw 0x6b40, 0xc89e,	0x6b7f, 0xc89e,		0x21, 0
	.dw 0x6bc0, 0xc89e,	0x6bff, 0xc89e,		0x21, 0
	.dw 0x6c40, 0xc89e,	0x6c7f, 0xc89e,		0x21, 0
	.dw 0x6cc0, 0xc89e,	0x6cff, 0xc89e,		0x21, 0
	.dw 0x6d40, 0xc89e,	0x6d7f, 0xc89e,		0x21, 0
	.dw 0x6dc0, 0xc89e,	0x6dff, 0xc89e,		0x21, 0
	.dw 0x6e40, 0xc89e,	0x6e7f, 0xc89e,		0x21, 0
	.dw 0x6ec0, 0xc89e,	0x6eff, 0xc89e,		0x21, 0
	.dw 0x6f40, 0xc89e,	0x6f7f, 0xc89e,		0x21, 0
	.dw 0x6fc0, 0xc89e,	0x6fff, 0xc89e,		0x21, 0
	.dw 0x7040, 0xc89e,	0x707f, 0xc89e,		0x21, 0
	.dw 0x70c0, 0xc89e,	0x70ff, 0xc89e,		0x21, 0
	.dw 0x7140, 0xc89e,	0x717f, 0xc89e,		0x21, 0
	.dw 0x71c0, 0xc89e,	0x71ff, 0xc89e,		0x21, 0
	.dw 0x7240, 0xc89e,	0x727f, 0xc89e,		0x21, 0
	.dw 0x72c0, 0xc89e,	0x72ff, 0xc89e,		0x21, 0
	.dw 0x7340, 0xc89e,	0x737f, 0xc89e,		0x21, 0
	.dw 0x73c0, 0xc89e,	0x73ff, 0xc89e,		0x21, 0
	.dw 0x7440, 0xc89e,	0x747f, 0xc89e,		0x21, 0
	.dw 0x74c0, 0xc89e,	0x74ff, 0xc89e,		0x21, 0
	.dw 0x7540, 0xc89e,	0x757f, 0xc89e,		0x21, 0
	.dw 0x75c0, 0xc89e,	0x75ff, 0xc89e,		0x21, 0
	.dw 0x7640, 0xc89e,	0x767f, 0xc89e,		0x21, 0
	.dw 0x76c0, 0xc89e,	0x76ff, 0xc89e,		0x21, 0
	.dw 0x7740, 0xc89e,	0x777f, 0xc89e,		0x21, 0
	.dw 0x77c0, 0xc89e,	0x77ff, 0xc89e,		0x21, 0
	.dw 0x7840, 0xc89e,	0x787f, 0xc89e,		0x21, 0
	.dw 0x78c0, 0xc89e,	0x78ff, 0xc89e,		0x21, 0
	.dw 0x7940, 0xc89e,	0x797f, 0xc89e,		0x21, 0
	.dw 0x79c0, 0xc89e,	0x7fff, 0xc89e,		0x21, 0
	.dw 0x8040, 0xc89e,	0x807f, 0xc89e,		0x21, 0
	.dw 0x80c0, 0xc89e,	0x80ff, 0xc89e,		0x21, 0
	.dw 0x8140, 0xc89e,	0x817f, 0xc89e,		0x21, 0
	.dw 0x81c0, 0xc89e,	0x81ff, 0xc89e,		0x21, 0
	.dw 0x8240, 0xc89e,	0x827f, 0xc89e,		0x21, 0
	.dw 0x82c0, 0xc89e,	0x82ff, 0xc89e,		0x21, 0
	.dw 0x8340, 0xc89e,	0x837f, 0xc89e,		0x21, 0
	.dw 0x83c0, 0xc89e,	0x83ff, 0xc89e,		0x21, 0
	.dw 0x8440, 0xc89e,	0x847f, 0xc89e,		0x21, 0
	.dw 0x84c0, 0xc89e,	0x84ff, 0xc89e,		0x21, 0
	.dw 0x8540, 0xc89e,	0x857f, 0xc89e,		0x21, 0
	.dw 0x85c0, 0xc89e,	0x85ff, 0xc89e,		0x21, 0
	.dw 0x8640, 0xc89e,	0x867f, 0xc89e,		0x21, 0
	.dw 0x86c0, 0xc89e,	0x86ff, 0xc89e,		0x21, 0
	.dw 0x8740, 0xc89e,	0x877f, 0xc89e,		0x21, 0
	.dw 0x87c0, 0xc89e,	0x87ff, 0xc89e,		0x21, 0
	.dw 0x8840, 0xc89e,	0x887f, 0xc89e,		0x21, 0
	.dw 0x88c0, 0xc89e,	0x88ff, 0xc89e,		0x21, 0
	.dw 0x8940, 0xc89e,	0x897f, 0xc89e,		0x21, 0
	.dw 0x89c0, 0xc89e,	0x89ff, 0xc89e,		0x21, 0
	.dw 0x8a40, 0xc89e,	0x8a7f, 0xc89e,		0x21, 0
	.dw 0x8ac0, 0xc89e,	0x8aff, 0xc89e,		0x21, 0
	.dw 0x8b40, 0xc89e,	0x8b7f, 0xc89e,		0x21, 0
	.dw 0x8bc0, 0xc89e,	0x8bff, 0xc89e,		0x21, 0
	.dw 0x8c40, 0xc89e,	0x8c7f, 0xc89e,		0x21, 0
	.dw 0x8cc0, 0xc89e,	0x8cff, 0xc89e,		0x21, 0
	.dw 0x8d40, 0xc89e,	0x8d7f, 0xc89e,		0x21, 0
	.dw 0x8dc0, 0xc89e,	0x8dff, 0xc89e,		0x21, 0
	.dw 0x8e40, 0xc89e,	0x8e7f, 0xc89e,		0x21, 0
	.dw 0x8ec0, 0xc89e,	0x8eff, 0xc89e,		0x21, 0
	.dw 0x8f40, 0xc89e,	0x8f7f, 0xc89e,		0x21, 0
	.dw 0x8fc0, 0xc89e,	0x8fff, 0xc89e,		0x21, 0
	.dw 0x9040, 0xc89e,	0x907f, 0xc89e,		0x21, 0
	.dw 0x90c0, 0xc89e,	0x90ff, 0xc89e,		0x21, 0
	.dw 0x9140, 0xc89e,	0x917f, 0xc89e,		0x21, 0
	.dw 0x91c0, 0xc89e,	0x91ff, 0xc89e,		0x21, 0
	.dw 0x9240, 0xc89e,	0x927f, 0xc89e,		0x21, 0
	.dw 0x92c0, 0xc89e,	0x92ff, 0xc89e,		0x21, 0
	.dw 0x9340, 0xc89e,	0x937f, 0xc89e,		0x21, 0
	.dw 0x93c0, 0xc89e,	0x93ff, 0xc89e,		0x21, 0
	.dw 0x9440, 0xc89e,	0x947f, 0xc89e,		0x21, 0
	.dw 0x94c0, 0xc89e,	0x94ff, 0xc89e,		0x21, 0
	.dw 0x9540, 0xc89e,	0x957f, 0xc89e,		0x21, 0
	.dw 0x95c0, 0xc89e,	0x95ff, 0xc89e,		0x21, 0
	.dw 0x9640, 0xc89e,	0x967f, 0xc89e,		0x21, 0
	.dw 0x96c0, 0xc89e,	0x96ff, 0xc89e,		0x21, 0
	.dw 0x9740, 0xc89e,	0x977f, 0xc89e,		0x21, 0
	.dw 0x97c0, 0xc89e,	0x97ff, 0xc89e,		0x21, 0
	.dw 0x9840, 0xc89e,	0x987f, 0xc89e,		0x21, 0
	.dw 0x98c0, 0xc89e,	0x98ff, 0xc89e,		0x21, 0
	.dw 0x9940, 0xc89e,	0x997f, 0xc89e,		0x21, 0
	.dw 0x99c0, 0xc89e,	0x9fff, 0xc89e,		0x21, 0
	.dw 0xa040, 0xc89e,	0xa07f, 0xc89e,		0x21, 0
	.dw 0xa0c0, 0xc89e,	0xa0ff, 0xc89e,		0x21, 0
	.dw 0xa140, 0xc89e,	0xa17f, 0xc89e,		0x21, 0
	.dw 0xa1c0, 0xc89e,	0xa1ff, 0xc89e,		0x21, 0
	.dw 0xa240, 0xc89e,	0xa27f, 0xc89e,		0x21, 0
	.dw 0xa2c0, 0xc89e,	0xa2ff, 0xc89e,		0x21, 0
	.dw 0xa340, 0xc89e,	0xa37f, 0xc89e,		0x21, 0
	.dw 0xa3c0, 0xc89e,	0xa3ff, 0xc89e,		0x21, 0
	.dw 0xa440, 0xc89e,	0xa47f, 0xc89e,		0x21, 0
	.dw 0xa4c0, 0xc89e,	0xa4ff, 0xc89e,		0x21, 0
	.dw 0xa540, 0xc89e,	0xa57f, 0xc89e,		0x21, 0
	.dw 0xa5c0, 0xc89e,	0xa5ff, 0xc89e,		0x21, 0
	.dw 0xa640, 0xc89e,	0xa67f, 0xc89e,		0x21, 0
	.dw 0xa6c0, 0xc89e,	0xa6ff, 0xc89e,		0x21, 0
	.dw 0xa740, 0xc89e,	0xa77f, 0xc89e,		0x21, 0
	.dw 0xa7c0, 0xc89e,	0xa7ff, 0xc89e,		0x21, 0
	.dw 0xa840, 0xc89e,	0xa87f, 0xc89e,		0x21, 0
	.dw 0xa8c0, 0xc89e,	0xa8ff, 0xc89e,		0x21, 0
	.dw 0xa940, 0xc89e,	0xa97f, 0xc89e,		0x21, 0
	.dw 0xa9c0, 0xc89e,	0xa9ff, 0xc89e,		0x21, 0
	.dw 0xaa40, 0xc89e,	0xaa7f, 0xc89e,		0x21, 0
	.dw 0xaac0, 0xc89e,	0xaaff, 0xc89e,		0x21, 0
	.dw 0xab40, 0xc89e,	0xab7f, 0xc89e,		0x21, 0
	.dw 0xabc0, 0xc89e,	0xabff, 0xc89e,		0x21, 0
	.dw 0xac40, 0xc89e,	0xac7f, 0xc89e,		0x21, 0
	.dw 0xacc0, 0xc89e,	0xacff, 0xc89e,		0x21, 0
	.dw 0xad40, 0xc89e,	0xad7f, 0xc89e,		0x21, 0
	.dw 0xadc0, 0xc89e,	0xadff, 0xc89e,		0x21, 0
	.dw 0xae40, 0xc89e,	0xae7f, 0xc89e,		0x21, 0
	.dw 0xaec0, 0xc89e,	0xaeff, 0xc89e,		0x21, 0
	.dw 0xaf40, 0xc89e,	0xaf7f, 0xc89e,		0x21, 0
	.dw 0xafc0, 0xc89e,	0xafff, 0xc89e,		0x21, 0
	.dw 0xb040, 0xc89e,	0xb07f, 0xc89e,		0x21, 0
	.dw 0xb0c0, 0xc89e,	0xb0ff, 0xc89e,		0x21, 0
	.dw 0xb140, 0xc89e,	0xb17f, 0xc89e,		0x21, 0
	.dw 0xb1c0, 0xc89e,	0xb1ff, 0xc89e,		0x21, 0
	.dw 0xb240, 0xc89e,	0xb27f, 0xc89e,		0x21, 0
	.dw 0xb2c0, 0xc89e,	0xb2ff, 0xc89e,		0x21, 0
	.dw 0xb340, 0xc89e,	0xb37f, 0xc89e,		0x21, 0
	.dw 0xb3c0, 0xc89e,	0xb3ff, 0xc89e,		0x21, 0
	.dw 0xb440, 0xc89e,	0xb47f, 0xc89e,		0x21, 0
	.dw 0xb4c0, 0xc89e,	0xb4ff, 0xc89e,		0x21, 0
	.dw 0xb540, 0xc89e,	0xb57f, 0xc89e,		0x21, 0
	.dw 0xb5c0, 0xc89e,	0xb5ff, 0xc89e,		0x21, 0
	.dw 0xb640, 0xc89e,	0xb67f, 0xc89e,		0x21, 0
	.dw 0xb6c0, 0xc89e,	0xb6ff, 0xc89e,		0x21, 0
	.dw 0xb740, 0xc89e,	0xb77f, 0xc89e,		0x21, 0
	.dw 0xb7c0, 0xc89e,	0xb7ff, 0xc89e,		0x21, 0
	.dw 0xb840, 0xc89e,	0xb87f, 0xc89e,		0x21, 0
	.dw 0xb8c0, 0xc89e,	0xb8ff, 0xc89e,		0x21, 0
	.dw 0xb940, 0xc89e,	0xb97f, 0xc89e,		0x21, 0
	.dw 0xb9c0, 0xc89e,	0xbfff, 0xc89e,		0x21, 0
	.dw 0xc040, 0xc89e,	0xc07f, 0xc89e,		0x21, 0
	.dw 0xc0c0, 0xc89e,	0xc0ff, 0xc89e,		0x21, 0
	.dw 0xc140, 0xc89e,	0xc17f, 0xc89e,		0x21, 0
	.dw 0xc1c0, 0xc89e,	0xc1ff, 0xc89e,		0x21, 0
	.dw 0xc240, 0xc89e,	0xc27f, 0xc89e,		0x21, 0
	.dw 0xc2c0, 0xc89e,	0xc2ff, 0xc89e,		0x21, 0
	.dw 0xc340, 0xc89e,	0xc37f, 0xc89e,		0x21, 0
	.dw 0xc3c0, 0xc89e,	0xc3ff, 0xc89e,		0x21, 0
	.dw 0xc440, 0xc89e,	0xc47f, 0xc89e,		0x21, 0
	.dw 0xc4c0, 0xc89e,	0xc4ff, 0xc89e,		0x21, 0
	.dw 0xc540, 0xc89e,	0xc57f, 0xc89e,		0x21, 0
	.dw 0xc5c0, 0xc89e,	0xc5ff, 0xc89e,		0x21, 0
	.dw 0xc640, 0xc89e,	0xc67f, 0xc89e,		0x21, 0
	.dw 0xc6c0, 0xc89e,	0xc6ff, 0xc89e,		0x21, 0
	.dw 0xc740, 0xc89e,	0xc77f, 0xc89e,		0x21, 0
	.dw 0xc7c0, 0xc89e,	0xc7ff, 0xc89e,		0x21, 0
	.dw 0xc840, 0xc89e,	0xc87f, 0xc89e,		0x21, 0
	.dw 0xc8c0, 0xc89e,	0xc8ff, 0xc89e,		0x21, 0
	.dw 0xc940, 0xc89e,	0xc97f, 0xc89e,		0x21, 0
	.dw 0xc9c0, 0xc89e,	0xc9ff, 0xc89e,		0x21, 0
	.dw 0xca40, 0xc89e,	0xca7f, 0xc89e,		0x21, 0
	.dw 0xcac0, 0xc89e,	0xcaff, 0xc89e,		0x21, 0
	.dw 0xcb40, 0xc89e,	0xcb7f, 0xc89e,		0x21, 0
	.dw 0xcbc0, 0xc89e,	0xcbff, 0xc89e,		0x21, 0
	.dw 0xcc40, 0xc89e,	0xcc7f, 0xc89e,		0x21, 0
	.dw 0xccc0, 0xc89e,	0xccff, 0xc89e,		0x21, 0
	.dw 0xcd40, 0xc89e,	0xcd7f, 0xc89e,		0x21, 0
	.dw 0xcdc0, 0xc89e,	0xcdff, 0xc89e,		0x21, 0
	.dw 0xce40, 0xc89e,	0xce7f, 0xc89e,		0x21, 0
	.dw 0xcec0, 0xc89e,	0xceff, 0xc89e,		0x21, 0
	.dw 0xcf40, 0xc89e,	0xcf7f, 0xc89e,		0x21, 0
	.dw 0xcfc0, 0xc89e,	0xcfff, 0xc89e,		0x21, 0
	.dw 0xd040, 0xc89e,	0xd07f, 0xc89e,		0x21, 0
	.dw 0xd0c0, 0xc89e,	0xd0ff, 0xc89e,		0x21, 0
	.dw 0xd140, 0xc89e,	0xd17f, 0xc89e,		0x21, 0
	.dw 0xd1c0, 0xc89e,	0xd1ff, 0xc89e,		0x21, 0
	.dw 0xd240, 0xc89e,	0xd27f, 0xc89e,		0x21, 0
	.dw 0xd2c0, 0xc89e,	0xd2ff, 0xc89e,		0x21, 0
	.dw 0xd340, 0xc89e,	0xd37f, 0xc89e,		0x21, 0
	.dw 0xd3c0, 0xc89e,	0xd3ff, 0xc89e,		0x21, 0
	.dw 0xd440, 0xc89e,	0xd47f, 0xc89e,		0x21, 0
	.dw 0xd4c0, 0xc89e,	0xd4ff, 0xc89e,		0x21, 0
	.dw 0xd540, 0xc89e,	0xd57f, 0xc89e,		0x21, 0
	.dw 0xd5c0, 0xc89e,	0xd5ff, 0xc89e,		0x21, 0
	.dw 0xd640, 0xc89e,	0xd67f, 0xc89e,		0x21, 0
	.dw 0xd6c0, 0xc89e,	0xd6ff, 0xc89e,		0x21, 0
	.dw 0xd740, 0xc89e,	0xd77f, 0xc89e,		0x21, 0
	.dw 0xd7c0, 0xc89e,	0xd7ff, 0xc89e,		0x21, 0
	.dw 0xd840, 0xc89e,	0xd87f, 0xc89e,		0x21, 0
	.dw 0xd8c0, 0xc89e,	0xd8ff, 0xc89e,		0x21, 0
	.dw 0xd940, 0xc89e,	0xd97f, 0xc89e,		0x21, 0
	.dw 0xd9c0, 0xc89e,	0xdfff, 0xc89e,		0x21, 0
	.dw 0xe040, 0xc89e,	0xe07f, 0xc89e,		0x21, 0
	.dw 0xe0c0, 0xc89e,	0xe0ff, 0xc89e,		0x21, 0
	.dw 0xe140, 0xc89e,	0xe17f, 0xc89e,		0x21, 0
	.dw 0xe1c0, 0xc89e,	0xe1ff, 0xc89e,		0x21, 0
	.dw 0xe240, 0xc89e,	0xe27f, 0xc89e,		0x21, 0
	.dw 0xe2c0, 0xc89e,	0xe2ff, 0xc89e,		0x21, 0
	.dw 0xe340, 0xc89e,	0xe37f, 0xc89e,		0x21, 0
	.dw 0xe3c0, 0xc89e,	0xe3ff, 0xc89e,		0x21, 0
	.dw 0xe440, 0xc89e,	0xe47f, 0xc89e,		0x21, 0
	.dw 0xe4c0, 0xc89e,	0xe4ff, 0xc89e,		0x21, 0
	.dw 0xe540, 0xc89e,	0xe57f, 0xc89e,		0x21, 0
	.dw 0xe5c0, 0xc89e,	0xe5ff, 0xc89e,		0x21, 0
	.dw 0xe640, 0xc89e,	0xe67f, 0xc89e,		0x21, 0
	.dw 0xe6c0, 0xc89e,	0xe6ff, 0xc89e,		0x21, 0
	.dw 0xe740, 0xc89e,	0xe77f, 0xc89e,		0x21, 0
	.dw 0xe7c0, 0xc89e,	0xe7ff, 0xc89e,		0x21, 0
	.dw 0xe840, 0xc89e,	0xe87f, 0xc89e,		0x21, 0
	.dw 0xe8c0, 0xc89e,	0xe8ff, 0xc89e,		0x21, 0
	.dw 0xe940, 0xc89e,	0xe97f, 0xc89e,		0x21, 0
	.dw 0xe9c0, 0xc89e,	0xe9ff, 0xc89e,		0x21, 0
	.dw 0xea40, 0xc89e,	0xea7f, 0xc89e,		0x21, 0
	.dw 0xeac0, 0xc89e,	0xeaff, 0xc89e,		0x21, 0
	.dw 0xeb40, 0xc89e,	0xeb7f, 0xc89e,		0x21, 0
	.dw 0xebc0, 0xc89e,	0xebff, 0xc89e,		0x21, 0
	.dw 0xec40, 0xc89e,	0xec7f, 0xc89e,		0x21, 0
	.dw 0xecc0, 0xc89e,	0xecff, 0xc89e,		0x21, 0
	.dw 0xed40, 0xc89e,	0xed7f, 0xc89e,		0x21, 0
	.dw 0xedc0, 0xc89e,	0xedff, 0xc89e,		0x21, 0
	.dw 0xee40, 0xc89e,	0xee7f, 0xc89e,		0x21, 0
	.dw 0xeec0, 0xc89e,	0xeeff, 0xc89e,		0x21, 0
	.dw 0xef40, 0xc89e,	0xef7f, 0xc89e,		0x21, 0
	.dw 0xefc0, 0xc89e,	0xefff, 0xc89e,		0x21, 0
	.dw 0xf040, 0xc89e,	0xf07f, 0xc89e,		0x21, 0
	.dw 0xf0c0, 0xc89e,	0xf0ff, 0xc89e,		0x21, 0
	.dw 0xf140, 0xc89e,	0xf17f, 0xc89e,		0x21, 0
	.dw 0xf1c0, 0xc89e,	0xf1ff, 0xc89e,		0x21, 0
	.dw 0xf240, 0xc89e,	0xf27f, 0xc89e,		0x21, 0
	.dw 0xf2c0, 0xc89e,	0xf2ff, 0xc89e,		0x21, 0
	.dw 0xf340, 0xc89e,	0xf37f, 0xc89e,		0x21, 0
	.dw 0xf3c0, 0xc89e,	0xf3ff, 0xc89e,		0x21, 0
	.dw 0xf440, 0xc89e,	0xf47f, 0xc89e,		0x21, 0
	.dw 0xf4c0, 0xc89e,	0xf4ff, 0xc89e,		0x21, 0
	.dw 0xf540, 0xc89e,	0xf57f, 0xc89e,		0x21, 0
	.dw 0xf5c0, 0xc89e,	0xf5ff, 0xc89e,		0x21, 0
	.dw 0xf640, 0xc89e,	0xf67f, 0xc89e,		0x21, 0
	.dw 0xf6c0, 0xc89e,	0xf6ff, 0xc89e,		0x21, 0
	.dw 0xf740, 0xc89e,	0xf77f, 0xc89e,		0x21, 0
	.dw 0xf7c0, 0xc89e,	0xf7ff, 0xc89e,		0x21, 0
	.dw 0xf840, 0xc89e,	0xf87f, 0xc89e,		0x21, 0
	.dw 0xf8c0, 0xc89e,	0xf8ff, 0xc89e,		0x21, 0
	.dw 0xf940, 0xc89e,	0xf97f, 0xc89e,		0x21, 0
	.dw 0xf9c0, 0xc89e,	0xffff, 0xc89e,		0x21, 0
	.dw 0x0040, 0xc89f,	0x007f, 0xc89f,		0x21, 0
	.dw 0x00c0, 0xc89f,	0x00ff, 0xc89f,		0x21, 0
	.dw 0x0140, 0xc89f,	0x017f, 0xc89f,		0x21, 0
	.dw 0x01c0, 0xc89f,	0x01ff, 0xc89f,		0x21, 0
	.dw 0x0240, 0xc89f,	0x027f, 0xc89f,		0x21, 0
	.dw 0x02c0, 0xc89f,	0x02ff, 0xc89f,		0x21, 0
	.dw 0x0340, 0xc89f,	0x037f, 0xc89f,		0x21, 0
	.dw 0x03c0, 0xc89f,	0x03ff, 0xc89f,		0x21, 0
	.dw 0x0440, 0xc89f,	0x047f, 0xc89f,		0x21, 0
	.dw 0x04c0, 0xc89f,	0x04ff, 0xc89f,		0x21, 0
	.dw 0x0540, 0xc89f,	0x057f, 0xc89f,		0x21, 0
	.dw 0x05c0, 0xc89f,	0x05ff, 0xc89f,		0x21, 0
	.dw 0x0640, 0xc89f,	0x067f, 0xc89f,		0x21, 0
	.dw 0x06c0, 0xc89f,	0x06ff, 0xc89f,		0x21, 0
	.dw 0x0740, 0xc89f,	0x077f, 0xc89f,		0x21, 0
	.dw 0x07c0, 0xc89f,	0x07ff, 0xc89f,		0x21, 0
	.dw 0x0840, 0xc89f,	0x087f, 0xc89f,		0x21, 0
	.dw 0x08c0, 0xc89f,	0x08ff, 0xc89f,		0x21, 0
	.dw 0x0940, 0xc89f,	0x097f, 0xc89f,		0x21, 0
	.dw 0x09c0, 0xc89f,	0x09ff, 0xc89f,		0x21, 0
	.dw 0x0a40, 0xc89f,	0x0a7f, 0xc89f,		0x21, 0
	.dw 0x0ac0, 0xc89f,	0x0aff, 0xc89f,		0x21, 0
	.dw 0x0b40, 0xc89f,	0x0b7f, 0xc89f,		0x21, 0
	.dw 0x0bc0, 0xc89f,	0x0bff, 0xc89f,		0x21, 0
	.dw 0x0c40, 0xc89f,	0x0c7f, 0xc89f,		0x21, 0
	.dw 0x0cc0, 0xc89f,	0x0cff, 0xc89f,		0x21, 0
	.dw 0x0d40, 0xc89f,	0x0d7f, 0xc89f,		0x21, 0
	.dw 0x0dc0, 0xc89f,	0x0dff, 0xc89f,		0x21, 0
	.dw 0x0e40, 0xc89f,	0x0e7f, 0xc89f,		0x21, 0
	.dw 0x0ec0, 0xc89f,	0x0eff, 0xc89f,		0x21, 0
	.dw 0x0f40, 0xc89f,	0x0f7f, 0xc89f,		0x21, 0
	.dw 0x0fc0, 0xc89f,	0x0fff, 0xc89f,		0x21, 0
	.dw 0x1040, 0xc89f,	0x107f, 0xc89f,		0x21, 0
	.dw 0x10c0, 0xc89f,	0x10ff, 0xc89f,		0x21, 0
	.dw 0x1140, 0xc89f,	0x117f, 0xc89f,		0x21, 0
	.dw 0x11c0, 0xc89f,	0x11ff, 0xc89f,		0x21, 0
	.dw 0x1240, 0xc89f,	0x127f, 0xc89f,		0x21, 0
	.dw 0x12c0, 0xc89f,	0x12ff, 0xc89f,		0x21, 0
	.dw 0x1340, 0xc89f,	0x137f, 0xc89f,		0x21, 0
	.dw 0x13c0, 0xc89f,	0x13ff, 0xc89f,		0x21, 0
	.dw 0x1440, 0xc89f,	0x147f, 0xc89f,		0x21, 0
	.dw 0x14c0, 0xc89f,	0x14ff, 0xc89f,		0x21, 0
	.dw 0x1540, 0xc89f,	0x157f, 0xc89f,		0x21, 0
	.dw 0x15c0, 0xc89f,	0x15ff, 0xc89f,		0x21, 0
	.dw 0x1640, 0xc89f,	0x167f, 0xc89f,		0x21, 0
	.dw 0x16c0, 0xc89f,	0x16ff, 0xc89f,		0x21, 0
	.dw 0x1740, 0xc89f,	0x177f, 0xc89f,		0x21, 0
	.dw 0x17c0, 0xc89f,	0x17ff, 0xc89f,		0x21, 0
	.dw 0x1840, 0xc89f,	0x187f, 0xc89f,		0x21, 0
	.dw 0x18c0, 0xc89f,	0x18ff, 0xc89f,		0x21, 0
	.dw 0x1940, 0xc89f,	0x197f, 0xc89f,		0x21, 0
	.dw 0x19c0, 0xc89f,	0x1fff, 0xc89f,		0x21, 0
	.dw 0x2040, 0xc89f,	0x207f, 0xc89f,		0x21, 0
	.dw 0x20c0, 0xc89f,	0x20ff, 0xc89f,		0x21, 0
	.dw 0x2140, 0xc89f,	0x217f, 0xc89f,		0x21, 0
	.dw 0x21c0, 0xc89f,	0x21ff, 0xc89f,		0x21, 0
	.dw 0x2240, 0xc89f,	0x227f, 0xc89f,		0x21, 0
	.dw 0x22c0, 0xc89f,	0x22ff, 0xc89f,		0x21, 0
	.dw 0x2340, 0xc89f,	0x237f, 0xc89f,		0x21, 0
	.dw 0x23c0, 0xc89f,	0x23ff, 0xc89f,		0x21, 0
	.dw 0x2440, 0xc89f,	0x247f, 0xc89f,		0x21, 0
	.dw 0x24c0, 0xc89f,	0x24ff, 0xc89f,		0x21, 0
	.dw 0x2540, 0xc89f,	0x257f, 0xc89f,		0x21, 0
	.dw 0x25c0, 0xc89f,	0x25ff, 0xc89f,		0x21, 0
	.dw 0x2640, 0xc89f,	0x267f, 0xc89f,		0x21, 0
	.dw 0x26c0, 0xc89f,	0x26ff, 0xc89f,		0x21, 0
	.dw 0x2740, 0xc89f,	0x277f, 0xc89f,		0x21, 0
	.dw 0x27c0, 0xc89f,	0x27ff, 0xc89f,		0x21, 0
	.dw 0x2840, 0xc89f,	0x287f, 0xc89f,		0x21, 0
	.dw 0x28c0, 0xc89f,	0x28ff, 0xc89f,		0x21, 0
	.dw 0x2940, 0xc89f,	0x297f, 0xc89f,		0x21, 0
	.dw 0x29c0, 0xc89f,	0x29ff, 0xc89f,		0x21, 0
	.dw 0x2a40, 0xc89f,	0x2a7f, 0xc89f,		0x21, 0
	.dw 0x2ac0, 0xc89f,	0x2aff, 0xc89f,		0x21, 0
	.dw 0x2b40, 0xc89f,	0x2b7f, 0xc89f,		0x21, 0
	.dw 0x2bc0, 0xc89f,	0x2bff, 0xc89f,		0x21, 0
	.dw 0x2c40, 0xc89f,	0x2c7f, 0xc89f,		0x21, 0
	.dw 0x2cc0, 0xc89f,	0x2cff, 0xc89f,		0x21, 0
	.dw 0x2d40, 0xc89f,	0x2d7f, 0xc89f,		0x21, 0
	.dw 0x2dc0, 0xc89f,	0x2dff, 0xc89f,		0x21, 0
	.dw 0x2e40, 0xc89f,	0x2e7f, 0xc89f,		0x21, 0
	.dw 0x2ec0, 0xc89f,	0x2eff, 0xc89f,		0x21, 0
	.dw 0x2f40, 0xc89f,	0x2f7f, 0xc89f,		0x21, 0
	.dw 0x2fc0, 0xc89f,	0x2fff, 0xc89f,		0x21, 0
	.dw 0x3040, 0xc89f,	0x307f, 0xc89f,		0x21, 0
	.dw 0x30c0, 0xc89f,	0x30ff, 0xc89f,		0x21, 0
	.dw 0x3140, 0xc89f,	0x317f, 0xc89f,		0x21, 0
	.dw 0x31c0, 0xc89f,	0x31ff, 0xc89f,		0x21, 0
	.dw 0x3240, 0xc89f,	0x327f, 0xc89f,		0x21, 0
	.dw 0x32c0, 0xc89f,	0x32ff, 0xc89f,		0x21, 0
	.dw 0x3340, 0xc89f,	0x337f, 0xc89f,		0x21, 0
	.dw 0x33c0, 0xc89f,	0x33ff, 0xc89f,		0x21, 0
	.dw 0x3440, 0xc89f,	0x347f, 0xc89f,		0x21, 0
	.dw 0x34c0, 0xc89f,	0x34ff, 0xc89f,		0x21, 0
	.dw 0x3540, 0xc89f,	0x357f, 0xc89f,		0x21, 0
	.dw 0x35c0, 0xc89f,	0x35ff, 0xc89f,		0x21, 0
	.dw 0x3640, 0xc89f,	0x367f, 0xc89f,		0x21, 0
	.dw 0x36c0, 0xc89f,	0x36ff, 0xc89f,		0x21, 0
	.dw 0x3740, 0xc89f,	0x377f, 0xc89f,		0x21, 0
	.dw 0x37c0, 0xc89f,	0x37ff, 0xc89f,		0x21, 0
	.dw 0x3840, 0xc89f,	0x387f, 0xc89f,		0x21, 0
	.dw 0x38c0, 0xc89f,	0x38ff, 0xc89f,		0x21, 0
	.dw 0x3940, 0xc89f,	0x397f, 0xc89f,		0x21, 0
	.dw 0x39c0, 0xc89f,	0x1fff, 0xc8c0,		0x21, 0
	.dw 0x3a00, 0xc8c0,	0x5fff, 0xc8c0,		0x21, 0
	.dw 0x7a00, 0xc8c0,	0x9fff, 0xc8c0,		0x21, 0
	.dw 0xba00, 0xc8c0,	0xdfff, 0xc8c0,		0x21, 0
	.dw 0xfa00, 0xc8c0,	0x1fff, 0xc8c1,		0x21, 0
	.dw 0x3a00, 0xc8c1,	0x5fff, 0xc8c1,		0x21, 0
	.dw 0x7a00, 0xc8c1,	0x9fff, 0xc8c1,		0x21, 0
	.dw 0xba00, 0xc8c1,	0xdfff, 0xc8c1,		0x21, 0
	.dw 0xfa00, 0xc8c1,	0x1fff, 0xc8c2,		0x21, 0
	.dw 0x3a00, 0xc8c2,	0x5fff, 0xc8c2,		0x21, 0
	.dw 0x7a00, 0xc8c2,	0x9fff, 0xc8c2,		0x21, 0
	.dw 0xba00, 0xc8c2,	0xdfff, 0xc8c2,		0x21, 0
	.dw 0xfa00, 0xc8c2,	0x1fff, 0xc8c3,		0x21, 0
	.dw 0x3a00, 0xc8c3,	0xffff, 0xc8c3,		0x21, 0
	.dw 0x1a00, 0xc8c4,	0x1fff, 0xc8c4,		0x21, 0
	.dw 0x3a00, 0xc8c4,	0x3fff, 0xc8c4,		0x21, 0
	.dw 0x5a00, 0xc8c4,	0x5fff, 0xc8c4,		0x21, 0
	.dw 0x7a00, 0xc8c4,	0x7fff, 0xc8c4,		0x21, 0
	.dw 0x9a00, 0xc8c4,	0x9fff, 0xc8c4,		0x21, 0
	.dw 0xba00, 0xc8c4,	0xbfff, 0xc8c4,		0x21, 0
	.dw 0xda00, 0xc8c4,	0xdfff, 0xc8c4,		0x21, 0
	.dw 0xfa00, 0xc8c4,	0xffff, 0xc8c4,		0x21, 0
	.dw 0x1a00, 0xc8c5,	0x1fff, 0xc8c5,		0x21, 0
	.dw 0x3a00, 0xc8c5,	0x3fff, 0xc8c5,		0x21, 0
	.dw 0x5a00, 0xc8c5,	0x5fff, 0xc8c5,		0x21, 0
	.dw 0x7a00, 0xc8c5,	0x7fff, 0xc8c5,		0x21, 0
	.dw 0x9a00, 0xc8c5,	0x9fff, 0xc8c5,		0x21, 0
	.dw 0xba00, 0xc8c5,	0xbfff, 0xc8c5,		0x21, 0
	.dw 0xda00, 0xc8c5,	0xdfff, 0xc8c5,		0x21, 0
	.dw 0xfa00, 0xc8c5,	0xffff, 0xc8c5,		0x21, 0
	.dw 0x1a00, 0xc8c6,	0x1fff, 0xc8c6,		0x21, 0
	.dw 0x3a00, 0xc8c6,	0x3fff, 0xc8c6,		0x21, 0
	.dw 0x5a00, 0xc8c6,	0x5fff, 0xc8c6,		0x21, 0
	.dw 0x7a00, 0xc8c6,	0x7fff, 0xc8c6,		0x21, 0
	.dw 0x9a00, 0xc8c6,	0x9fff, 0xc8c6,		0x21, 0
	.dw 0xba00, 0xc8c6,	0xbfff, 0xc8c6,		0x21, 0
	.dw 0xda00, 0xc8c6,	0xdfff, 0xc8c6,		0x21, 0
	.dw 0xfa00, 0xc8c6,	0xffff, 0xc8c6,		0x21, 0
	.dw 0x1a00, 0xc8c7,	0x1fff, 0xc8c7,		0x21, 0
	.dw 0x3a00, 0xc8c7,	0x1fff, 0xc8d0,		0x21, 0
	.dw 0x3a00, 0xc8d0,	0x5fff, 0xc8d0,		0x21, 0
	.dw 0x7a00, 0xc8d0,	0x9fff, 0xc8d0,		0x21, 0
	.dw 0xba00, 0xc8d0,	0xdfff, 0xc8d0,		0x21, 0
	.dw 0xfa00, 0xc8d0,	0x1fff, 0xc8d1,		0x21, 0
	.dw 0x3a00, 0xc8d1,	0x5fff, 0xc8d1,		0x21, 0
	.dw 0x7a00, 0xc8d1,	0x9fff, 0xc8d1,		0x21, 0
	.dw 0xba00, 0xc8d1,	0xdfff, 0xc8d1,		0x21, 0
	.dw 0xfa00, 0xc8d1,	0x1fff, 0xc8d2,		0x21, 0
	.dw 0x3a00, 0xc8d2,	0x5fff, 0xc8d2,		0x21, 0
	.dw 0x7a00, 0xc8d2,	0x9fff, 0xc8d2,		0x21, 0
	.dw 0xba00, 0xc8d2,	0xdfff, 0xc8d2,		0x21, 0
	.dw 0xfa00, 0xc8d2,	0xffff, 0xc8d3,		0x21, 0
	.dw 0x1a00, 0xc8d4,	0x1fff, 0xc8d4,		0x21, 0
	.dw 0x3a00, 0xc8d4,	0x3fff, 0xc8d4,		0x21, 0
	.dw 0x5a00, 0xc8d4,	0x5fff, 0xc8d4,		0x21, 0
	.dw 0x7a00, 0xc8d4,	0x7fff, 0xc8d4,		0x21, 0
	.dw 0x9a00, 0xc8d4,	0x9fff, 0xc8d4,		0x21, 0
	.dw 0xba00, 0xc8d4,	0xbfff, 0xc8d4,		0x21, 0
	.dw 0xda00, 0xc8d4,	0xdfff, 0xc8d4,		0x21, 0
	.dw 0xfa00, 0xc8d4,	0xffff, 0xc8d4,		0x21, 0
	.dw 0x1a00, 0xc8d5,	0x1fff, 0xc8d5,		0x21, 0
	.dw 0x3a00, 0xc8d5,	0x3fff, 0xc8d5,		0x21, 0
	.dw 0x5a00, 0xc8d5,	0x5fff, 0xc8d5,		0x21, 0
	.dw 0x7a00, 0xc8d5,	0x7fff, 0xc8d5,		0x21, 0
	.dw 0x9a00, 0xc8d5,	0x9fff, 0xc8d5,		0x21, 0
	.dw 0xba00, 0xc8d5,	0xbfff, 0xc8d5,		0x21, 0
	.dw 0xda00, 0xc8d5,	0xdfff, 0xc8d5,		0x21, 0
	.dw 0xfa00, 0xc8d5,	0xffff, 0xc8d5,		0x21, 0
	.dw 0x1a00, 0xc8d6,	0x1fff, 0xc8d6,		0x21, 0
	.dw 0x3a00, 0xc8d6,	0x3fff, 0xc8d6,		0x21, 0
	.dw 0x5a00, 0xc8d6,	0x5fff, 0xc8d6,		0x21, 0
	.dw 0x7a00, 0xc8d6,	0x7fff, 0xc8d6,		0x21, 0
	.dw 0x9a00, 0xc8d6,	0x9fff, 0xc8d6,		0x21, 0
	.dw 0xba00, 0xc8d6,	0xbfff, 0xc8d6,		0x21, 0
	.dw 0xda00, 0xc8d6,	0xdfff, 0xc8d6,		0x21, 0
	.dw 0xfa00, 0xc8d6,	0xffff, 0xc8d6,		0x21, 0
	.dw 0x1a00, 0xc8d7,	0x1fff, 0xc8d7,		0x21, 0
	.dw 0x3a00, 0xc8d7,	0xffff, 0xc8ff,		0x21, 0
	.dw 0x1a00, 0xc900,	0x1fff, 0xc900,		0x21, 0
	.dw 0x3a00, 0xc900,	0x3fff, 0xc900,		0x21, 0
	.dw 0x5a00, 0xc900,	0x5fff, 0xc900,		0x21, 0
	.dw 0x7a00, 0xc900,	0x7fff, 0xc900,		0x21, 0
	.dw 0x9a00, 0xc900,	0x9fff, 0xc900,		0x21, 0
	.dw 0xba00, 0xc900,	0xbfff, 0xc900,		0x21, 0
	.dw 0xda00, 0xc900,	0xdfff, 0xc900,		0x21, 0
	.dw 0xfa00, 0xc900,	0xffff, 0xc900,		0x21, 0
	.dw 0x1a00, 0xc901,	0x1fff, 0xc901,		0x21, 0
	.dw 0x3a00, 0xc901,	0x3fff, 0xc901,		0x21, 0
	.dw 0x5a00, 0xc901,	0x5fff, 0xc901,		0x21, 0
	.dw 0x7a00, 0xc901,	0x7fff, 0xc901,		0x21, 0
	.dw 0x9a00, 0xc901,	0x9fff, 0xc901,		0x21, 0
	.dw 0xba00, 0xc901,	0xbfff, 0xc901,		0x21, 0
	.dw 0xda00, 0xc901,	0xdfff, 0xc901,		0x21, 0
	.dw 0xfa00, 0xc901,	0xffff, 0xc901,		0x21, 0
	.dw 0x1a00, 0xc902,	0x1fff, 0xc902,		0x21, 0
	.dw 0x3a00, 0xc902,	0x3fff, 0xc902,		0x21, 0
	.dw 0x5a00, 0xc902,	0x5fff, 0xc902,		0x21, 0
	.dw 0x7a00, 0xc902,	0x7fff, 0xc902,		0x21, 0
	.dw 0x9a00, 0xc902,	0x9fff, 0xc902,		0x21, 0
	.dw 0xba00, 0xc902,	0xbfff, 0xc902,		0x21, 0
	.dw 0xda00, 0xc902,	0xdfff, 0xc902,		0x21, 0
	.dw 0xfa00, 0xc902,	0xffff, 0xc902,		0x21, 0
	.dw 0x1a00, 0xc903,	0x1fff, 0xc903,		0x21, 0
	.dw 0x3a00, 0xc903,	0xffff, 0xc903,		0x21, 0
	.dw 0x1a00, 0xc904,	0x1fff, 0xc904,		0x21, 0
	.dw 0x3a00, 0xc904,	0x3fff, 0xc904,		0x21, 0
	.dw 0x5a00, 0xc904,	0x5fff, 0xc904,		0x21, 0
	.dw 0x7a00, 0xc904,	0x7fff, 0xc904,		0x21, 0
	.dw 0x9a00, 0xc904,	0x9fff, 0xc904,		0x21, 0
	.dw 0xba00, 0xc904,	0xbfff, 0xc904,		0x21, 0
	.dw 0xda00, 0xc904,	0xdfff, 0xc904,		0x21, 0
	.dw 0xfa00, 0xc904,	0xffff, 0xc904,		0x21, 0
	.dw 0x1a00, 0xc905,	0x1fff, 0xc905,		0x21, 0
	.dw 0x3a00, 0xc905,	0x3fff, 0xc905,		0x21, 0
	.dw 0x5a00, 0xc905,	0x5fff, 0xc905,		0x21, 0
	.dw 0x7a00, 0xc905,	0x7fff, 0xc905,		0x21, 0
	.dw 0x9a00, 0xc905,	0x9fff, 0xc905,		0x21, 0
	.dw 0xba00, 0xc905,	0xbfff, 0xc905,		0x21, 0
	.dw 0xda00, 0xc905,	0xdfff, 0xc905,		0x21, 0
	.dw 0xfa00, 0xc905,	0xffff, 0xc905,		0x21, 0
	.dw 0x1a00, 0xc906,	0x1fff, 0xc906,		0x21, 0
	.dw 0x3a00, 0xc906,	0x3fff, 0xc906,		0x21, 0
	.dw 0x5a00, 0xc906,	0x5fff, 0xc906,		0x21, 0
	.dw 0x7a00, 0xc906,	0x7fff, 0xc906,		0x21, 0
	.dw 0x9a00, 0xc906,	0x9fff, 0xc906,		0x21, 0
	.dw 0xba00, 0xc906,	0xbfff, 0xc906,		0x21, 0
	.dw 0xda00, 0xc906,	0xdfff, 0xc906,		0x21, 0
	.dw 0xfa00, 0xc906,	0xffff, 0xc906,		0x21, 0
	.dw 0x1a00, 0xc907,	0x1fff, 0xc907,		0x21, 0
	.dw 0x3a00, 0xc907,	0x1fff, 0xc908,		0x21, 0
	.dw 0x2040, 0xc908,	0x207f, 0xc908,		0x21, 0
	.dw 0x20c0, 0xc908,	0x20ff, 0xc908,		0x21, 0
	.dw 0x2140, 0xc908,	0x217f, 0xc908,		0x21, 0
	.dw 0x21c0, 0xc908,	0x21ff, 0xc908,		0x21, 0
	.dw 0x2240, 0xc908,	0x227f, 0xc908,		0x21, 0
	.dw 0x22c0, 0xc908,	0x22ff, 0xc908,		0x21, 0
	.dw 0x2340, 0xc908,	0x237f, 0xc908,		0x21, 0
	.dw 0x23c0, 0xc908,	0x23ff, 0xc908,		0x21, 0
	.dw 0x2440, 0xc908,	0x247f, 0xc908,		0x21, 0
	.dw 0x24c0, 0xc908,	0x24ff, 0xc908,		0x21, 0
	.dw 0x2540, 0xc908,	0x257f, 0xc908,		0x21, 0
	.dw 0x25c0, 0xc908,	0x25ff, 0xc908,		0x21, 0
	.dw 0x2640, 0xc908,	0x267f, 0xc908,		0x21, 0
	.dw 0x26c0, 0xc908,	0x26ff, 0xc908,		0x21, 0
	.dw 0x2740, 0xc908,	0x277f, 0xc908,		0x21, 0
	.dw 0x27c0, 0xc908,	0x27ff, 0xc908,		0x21, 0
	.dw 0x2840, 0xc908,	0x287f, 0xc908,		0x21, 0
	.dw 0x28c0, 0xc908,	0x28ff, 0xc908,		0x21, 0
	.dw 0x2940, 0xc908,	0x297f, 0xc908,		0x21, 0
	.dw 0x29c0, 0xc908,	0x29ff, 0xc908,		0x21, 0
	.dw 0x2a40, 0xc908,	0x2a7f, 0xc908,		0x21, 0
	.dw 0x2ac0, 0xc908,	0x2aff, 0xc908,		0x21, 0
	.dw 0x2b40, 0xc908,	0x2b7f, 0xc908,		0x21, 0
	.dw 0x2bc0, 0xc908,	0x2bff, 0xc908,		0x21, 0
	.dw 0x2c40, 0xc908,	0x2c7f, 0xc908,		0x21, 0
	.dw 0x2cc0, 0xc908,	0x2cff, 0xc908,		0x21, 0
	.dw 0x2d40, 0xc908,	0x2d7f, 0xc908,		0x21, 0
	.dw 0x2dc0, 0xc908,	0x2dff, 0xc908,		0x21, 0
	.dw 0x2e40, 0xc908,	0x2e7f, 0xc908,		0x21, 0
	.dw 0x2ec0, 0xc908,	0x2eff, 0xc908,		0x21, 0
	.dw 0x2f40, 0xc908,	0x2f7f, 0xc908,		0x21, 0
	.dw 0x2fc0, 0xc908,	0x2fff, 0xc908,		0x21, 0
	.dw 0x3040, 0xc908,	0x307f, 0xc908,		0x21, 0
	.dw 0x30c0, 0xc908,	0x30ff, 0xc908,		0x21, 0
	.dw 0x3140, 0xc908,	0x317f, 0xc908,		0x21, 0
	.dw 0x31c0, 0xc908,	0x31ff, 0xc908,		0x21, 0
	.dw 0x3240, 0xc908,	0x327f, 0xc908,		0x21, 0
	.dw 0x32c0, 0xc908,	0x32ff, 0xc908,		0x21, 0
	.dw 0x3340, 0xc908,	0x337f, 0xc908,		0x21, 0
	.dw 0x33c0, 0xc908,	0x33ff, 0xc908,		0x21, 0
	.dw 0x3440, 0xc908,	0x347f, 0xc908,		0x21, 0
	.dw 0x34c0, 0xc908,	0x34ff, 0xc908,		0x21, 0
	.dw 0x3540, 0xc908,	0x357f, 0xc908,		0x21, 0
	.dw 0x35c0, 0xc908,	0x35ff, 0xc908,		0x21, 0
	.dw 0x3640, 0xc908,	0x367f, 0xc908,		0x21, 0
	.dw 0x36c0, 0xc908,	0x36ff, 0xc908,		0x21, 0
	.dw 0x3740, 0xc908,	0x377f, 0xc908,		0x21, 0
	.dw 0x37c0, 0xc908,	0x37ff, 0xc908,		0x21, 0
	.dw 0x3840, 0xc908,	0x387f, 0xc908,		0x21, 0
	.dw 0x38c0, 0xc908,	0x38ff, 0xc908,		0x21, 0
	.dw 0x3940, 0xc908,	0x397f, 0xc908,		0x21, 0
	.dw 0x39c0, 0xc908,	0x5fff, 0xc908,		0x21, 0
	.dw 0x6040, 0xc908,	0x607f, 0xc908,		0x21, 0
	.dw 0x60c0, 0xc908,	0x60ff, 0xc908,		0x21, 0
	.dw 0x6140, 0xc908,	0x617f, 0xc908,		0x21, 0
	.dw 0x61c0, 0xc908,	0x61ff, 0xc908,		0x21, 0
	.dw 0x6240, 0xc908,	0x627f, 0xc908,		0x21, 0
	.dw 0x62c0, 0xc908,	0x62ff, 0xc908,		0x21, 0
	.dw 0x6340, 0xc908,	0x637f, 0xc908,		0x21, 0
	.dw 0x63c0, 0xc908,	0x63ff, 0xc908,		0x21, 0
	.dw 0x6440, 0xc908,	0x647f, 0xc908,		0x21, 0
	.dw 0x64c0, 0xc908,	0x64ff, 0xc908,		0x21, 0
	.dw 0x6540, 0xc908,	0x657f, 0xc908,		0x21, 0
	.dw 0x65c0, 0xc908,	0x65ff, 0xc908,		0x21, 0
	.dw 0x6640, 0xc908,	0x667f, 0xc908,		0x21, 0
	.dw 0x66c0, 0xc908,	0x66ff, 0xc908,		0x21, 0
	.dw 0x6740, 0xc908,	0x677f, 0xc908,		0x21, 0
	.dw 0x67c0, 0xc908,	0x67ff, 0xc908,		0x21, 0
	.dw 0x6840, 0xc908,	0x687f, 0xc908,		0x21, 0
	.dw 0x68c0, 0xc908,	0x68ff, 0xc908,		0x21, 0
	.dw 0x6940, 0xc908,	0x697f, 0xc908,		0x21, 0
	.dw 0x69c0, 0xc908,	0x69ff, 0xc908,		0x21, 0
	.dw 0x6a40, 0xc908,	0x6a7f, 0xc908,		0x21, 0
	.dw 0x6ac0, 0xc908,	0x6aff, 0xc908,		0x21, 0
	.dw 0x6b40, 0xc908,	0x6b7f, 0xc908,		0x21, 0
	.dw 0x6bc0, 0xc908,	0x6bff, 0xc908,		0x21, 0
	.dw 0x6c40, 0xc908,	0x6c7f, 0xc908,		0x21, 0
	.dw 0x6cc0, 0xc908,	0x6cff, 0xc908,		0x21, 0
	.dw 0x6d40, 0xc908,	0x6d7f, 0xc908,		0x21, 0
	.dw 0x6dc0, 0xc908,	0x6dff, 0xc908,		0x21, 0
	.dw 0x6e40, 0xc908,	0x6e7f, 0xc908,		0x21, 0
	.dw 0x6ec0, 0xc908,	0x6eff, 0xc908,		0x21, 0
	.dw 0x6f40, 0xc908,	0x6f7f, 0xc908,		0x21, 0
	.dw 0x6fc0, 0xc908,	0x6fff, 0xc908,		0x21, 0
	.dw 0x7040, 0xc908,	0x707f, 0xc908,		0x21, 0
	.dw 0x70c0, 0xc908,	0x70ff, 0xc908,		0x21, 0
	.dw 0x7140, 0xc908,	0x717f, 0xc908,		0x21, 0
	.dw 0x71c0, 0xc908,	0x71ff, 0xc908,		0x21, 0
	.dw 0x7240, 0xc908,	0x727f, 0xc908,		0x21, 0
	.dw 0x72c0, 0xc908,	0x72ff, 0xc908,		0x21, 0
	.dw 0x7340, 0xc908,	0x737f, 0xc908,		0x21, 0
	.dw 0x73c0, 0xc908,	0x73ff, 0xc908,		0x21, 0
	.dw 0x7440, 0xc908,	0x747f, 0xc908,		0x21, 0
	.dw 0x74c0, 0xc908,	0x74ff, 0xc908,		0x21, 0
	.dw 0x7540, 0xc908,	0x757f, 0xc908,		0x21, 0
	.dw 0x75c0, 0xc908,	0x75ff, 0xc908,		0x21, 0
	.dw 0x7640, 0xc908,	0x767f, 0xc908,		0x21, 0
	.dw 0x76c0, 0xc908,	0x76ff, 0xc908,		0x21, 0
	.dw 0x7740, 0xc908,	0x777f, 0xc908,		0x21, 0
	.dw 0x77c0, 0xc908,	0x77ff, 0xc908,		0x21, 0
	.dw 0x7840, 0xc908,	0x787f, 0xc908,		0x21, 0
	.dw 0x78c0, 0xc908,	0x78ff, 0xc908,		0x21, 0
	.dw 0x7940, 0xc908,	0x797f, 0xc908,		0x21, 0
	.dw 0x79c0, 0xc908,	0x9fff, 0xc908,		0x21, 0
	.dw 0xa040, 0xc908,	0xa07f, 0xc908,		0x21, 0
	.dw 0xa0c0, 0xc908,	0xa0ff, 0xc908,		0x21, 0
	.dw 0xa140, 0xc908,	0xa17f, 0xc908,		0x21, 0
	.dw 0xa1c0, 0xc908,	0xa1ff, 0xc908,		0x21, 0
	.dw 0xa240, 0xc908,	0xa27f, 0xc908,		0x21, 0
	.dw 0xa2c0, 0xc908,	0xa2ff, 0xc908,		0x21, 0
	.dw 0xa340, 0xc908,	0xa37f, 0xc908,		0x21, 0
	.dw 0xa3c0, 0xc908,	0xa3ff, 0xc908,		0x21, 0
	.dw 0xa440, 0xc908,	0xa47f, 0xc908,		0x21, 0
	.dw 0xa4c0, 0xc908,	0xa4ff, 0xc908,		0x21, 0
	.dw 0xa540, 0xc908,	0xa57f, 0xc908,		0x21, 0
	.dw 0xa5c0, 0xc908,	0xa5ff, 0xc908,		0x21, 0
	.dw 0xa640, 0xc908,	0xa67f, 0xc908,		0x21, 0
	.dw 0xa6c0, 0xc908,	0xa6ff, 0xc908,		0x21, 0
	.dw 0xa740, 0xc908,	0xa77f, 0xc908,		0x21, 0
	.dw 0xa7c0, 0xc908,	0xa7ff, 0xc908,		0x21, 0
	.dw 0xa840, 0xc908,	0xa87f, 0xc908,		0x21, 0
	.dw 0xa8c0, 0xc908,	0xa8ff, 0xc908,		0x21, 0
	.dw 0xa940, 0xc908,	0xa97f, 0xc908,		0x21, 0
	.dw 0xa9c0, 0xc908,	0xa9ff, 0xc908,		0x21, 0
	.dw 0xaa40, 0xc908,	0xaa7f, 0xc908,		0x21, 0
	.dw 0xaac0, 0xc908,	0xaaff, 0xc908,		0x21, 0
	.dw 0xab40, 0xc908,	0xab7f, 0xc908,		0x21, 0
	.dw 0xabc0, 0xc908,	0xabff, 0xc908,		0x21, 0
	.dw 0xac40, 0xc908,	0xac7f, 0xc908,		0x21, 0
	.dw 0xacc0, 0xc908,	0xacff, 0xc908,		0x21, 0
	.dw 0xad40, 0xc908,	0xad7f, 0xc908,		0x21, 0
	.dw 0xadc0, 0xc908,	0xadff, 0xc908,		0x21, 0
	.dw 0xae40, 0xc908,	0xae7f, 0xc908,		0x21, 0
	.dw 0xaec0, 0xc908,	0xaeff, 0xc908,		0x21, 0
	.dw 0xaf40, 0xc908,	0xaf7f, 0xc908,		0x21, 0
	.dw 0xafc0, 0xc908,	0xafff, 0xc908,		0x21, 0
	.dw 0xb040, 0xc908,	0xb07f, 0xc908,		0x21, 0
	.dw 0xb0c0, 0xc908,	0xb0ff, 0xc908,		0x21, 0
	.dw 0xb140, 0xc908,	0xb17f, 0xc908,		0x21, 0
	.dw 0xb1c0, 0xc908,	0xb1ff, 0xc908,		0x21, 0
	.dw 0xb240, 0xc908,	0xb27f, 0xc908,		0x21, 0
	.dw 0xb2c0, 0xc908,	0xb2ff, 0xc908,		0x21, 0
	.dw 0xb340, 0xc908,	0xb37f, 0xc908,		0x21, 0
	.dw 0xb3c0, 0xc908,	0xb3ff, 0xc908,		0x21, 0
	.dw 0xb440, 0xc908,	0xb47f, 0xc908,		0x21, 0
	.dw 0xb4c0, 0xc908,	0xb4ff, 0xc908,		0x21, 0
	.dw 0xb540, 0xc908,	0xb57f, 0xc908,		0x21, 0
	.dw 0xb5c0, 0xc908,	0xb5ff, 0xc908,		0x21, 0
	.dw 0xb640, 0xc908,	0xb67f, 0xc908,		0x21, 0
	.dw 0xb6c0, 0xc908,	0xb6ff, 0xc908,		0x21, 0
	.dw 0xb740, 0xc908,	0xb77f, 0xc908,		0x21, 0
	.dw 0xb7c0, 0xc908,	0xb7ff, 0xc908,		0x21, 0
	.dw 0xb840, 0xc908,	0xb87f, 0xc908,		0x21, 0
	.dw 0xb8c0, 0xc908,	0xb8ff, 0xc908,		0x21, 0
	.dw 0xb940, 0xc908,	0xb97f, 0xc908,		0x21, 0
	.dw 0xb9c0, 0xc908,	0xdfff, 0xc908,		0x21, 0
	.dw 0xe040, 0xc908,	0xe07f, 0xc908,		0x21, 0
	.dw 0xe0c0, 0xc908,	0xe0ff, 0xc908,		0x21, 0
	.dw 0xe140, 0xc908,	0xe17f, 0xc908,		0x21, 0
	.dw 0xe1c0, 0xc908,	0xe1ff, 0xc908,		0x21, 0
	.dw 0xe240, 0xc908,	0xe27f, 0xc908,		0x21, 0
	.dw 0xe2c0, 0xc908,	0xe2ff, 0xc908,		0x21, 0
	.dw 0xe340, 0xc908,	0xe37f, 0xc908,		0x21, 0
	.dw 0xe3c0, 0xc908,	0xe3ff, 0xc908,		0x21, 0
	.dw 0xe440, 0xc908,	0xe47f, 0xc908,		0x21, 0
	.dw 0xe4c0, 0xc908,	0xe4ff, 0xc908,		0x21, 0
	.dw 0xe540, 0xc908,	0xe57f, 0xc908,		0x21, 0
	.dw 0xe5c0, 0xc908,	0xe5ff, 0xc908,		0x21, 0
	.dw 0xe640, 0xc908,	0xe67f, 0xc908,		0x21, 0
	.dw 0xe6c0, 0xc908,	0xe6ff, 0xc908,		0x21, 0
	.dw 0xe740, 0xc908,	0xe77f, 0xc908,		0x21, 0
	.dw 0xe7c0, 0xc908,	0xe7ff, 0xc908,		0x21, 0
	.dw 0xe840, 0xc908,	0xe87f, 0xc908,		0x21, 0
	.dw 0xe8c0, 0xc908,	0xe8ff, 0xc908,		0x21, 0
	.dw 0xe940, 0xc908,	0xe97f, 0xc908,		0x21, 0
	.dw 0xe9c0, 0xc908,	0xe9ff, 0xc908,		0x21, 0
	.dw 0xea40, 0xc908,	0xea7f, 0xc908,		0x21, 0
	.dw 0xeac0, 0xc908,	0xeaff, 0xc908,		0x21, 0
	.dw 0xeb40, 0xc908,	0xeb7f, 0xc908,		0x21, 0
	.dw 0xebc0, 0xc908,	0xebff, 0xc908,		0x21, 0
	.dw 0xec40, 0xc908,	0xec7f, 0xc908,		0x21, 0
	.dw 0xecc0, 0xc908,	0xecff, 0xc908,		0x21, 0
	.dw 0xed40, 0xc908,	0xed7f, 0xc908,		0x21, 0
	.dw 0xedc0, 0xc908,	0xedff, 0xc908,		0x21, 0
	.dw 0xee40, 0xc908,	0xee7f, 0xc908,		0x21, 0
	.dw 0xeec0, 0xc908,	0xeeff, 0xc908,		0x21, 0
	.dw 0xef40, 0xc908,	0xef7f, 0xc908,		0x21, 0
	.dw 0xefc0, 0xc908,	0xefff, 0xc908,		0x21, 0
	.dw 0xf040, 0xc908,	0xf07f, 0xc908,		0x21, 0
	.dw 0xf0c0, 0xc908,	0xf0ff, 0xc908,		0x21, 0
	.dw 0xf140, 0xc908,	0xf17f, 0xc908,		0x21, 0
	.dw 0xf1c0, 0xc908,	0xf1ff, 0xc908,		0x21, 0
	.dw 0xf240, 0xc908,	0xf27f, 0xc908,		0x21, 0
	.dw 0xf2c0, 0xc908,	0xf2ff, 0xc908,		0x21, 0
	.dw 0xf340, 0xc908,	0xf37f, 0xc908,		0x21, 0
	.dw 0xf3c0, 0xc908,	0xf3ff, 0xc908,		0x21, 0
	.dw 0xf440, 0xc908,	0xf47f, 0xc908,		0x21, 0
	.dw 0xf4c0, 0xc908,	0xf4ff, 0xc908,		0x21, 0
	.dw 0xf540, 0xc908,	0xf57f, 0xc908,		0x21, 0
	.dw 0xf5c0, 0xc908,	0xf5ff, 0xc908,		0x21, 0
	.dw 0xf640, 0xc908,	0xf67f, 0xc908,		0x21, 0
	.dw 0xf6c0, 0xc908,	0xf6ff, 0xc908,		0x21, 0
	.dw 0xf740, 0xc908,	0xf77f, 0xc908,		0x21, 0
	.dw 0xf7c0, 0xc908,	0xf7ff, 0xc908,		0x21, 0
	.dw 0xf840, 0xc908,	0xf87f, 0xc908,		0x21, 0
	.dw 0xf8c0, 0xc908,	0xf8ff, 0xc908,		0x21, 0
	.dw 0xf940, 0xc908,	0xf97f, 0xc908,		0x21, 0
	.dw 0xf9c0, 0xc908,	0x1fff, 0xc909,		0x21, 0
	.dw 0x2040, 0xc909,	0x207f, 0xc909,		0x21, 0
	.dw 0x20c0, 0xc909,	0x20ff, 0xc909,		0x21, 0
	.dw 0x2140, 0xc909,	0x217f, 0xc909,		0x21, 0
	.dw 0x21c0, 0xc909,	0x21ff, 0xc909,		0x21, 0
	.dw 0x2240, 0xc909,	0x227f, 0xc909,		0x21, 0
	.dw 0x22c0, 0xc909,	0x22ff, 0xc909,		0x21, 0
	.dw 0x2340, 0xc909,	0x237f, 0xc909,		0x21, 0
	.dw 0x23c0, 0xc909,	0x23ff, 0xc909,		0x21, 0
	.dw 0x2440, 0xc909,	0x247f, 0xc909,		0x21, 0
	.dw 0x24c0, 0xc909,	0x24ff, 0xc909,		0x21, 0
	.dw 0x2540, 0xc909,	0x257f, 0xc909,		0x21, 0
	.dw 0x25c0, 0xc909,	0x25ff, 0xc909,		0x21, 0
	.dw 0x2640, 0xc909,	0x267f, 0xc909,		0x21, 0
	.dw 0x26c0, 0xc909,	0x26ff, 0xc909,		0x21, 0
	.dw 0x2740, 0xc909,	0x277f, 0xc909,		0x21, 0
	.dw 0x27c0, 0xc909,	0x27ff, 0xc909,		0x21, 0
	.dw 0x2840, 0xc909,	0x287f, 0xc909,		0x21, 0
	.dw 0x28c0, 0xc909,	0x28ff, 0xc909,		0x21, 0
	.dw 0x2940, 0xc909,	0x297f, 0xc909,		0x21, 0
	.dw 0x29c0, 0xc909,	0x29ff, 0xc909,		0x21, 0
	.dw 0x2a40, 0xc909,	0x2a7f, 0xc909,		0x21, 0
	.dw 0x2ac0, 0xc909,	0x2aff, 0xc909,		0x21, 0
	.dw 0x2b40, 0xc909,	0x2b7f, 0xc909,		0x21, 0
	.dw 0x2bc0, 0xc909,	0x2bff, 0xc909,		0x21, 0
	.dw 0x2c40, 0xc909,	0x2c7f, 0xc909,		0x21, 0
	.dw 0x2cc0, 0xc909,	0x2cff, 0xc909,		0x21, 0
	.dw 0x2d40, 0xc909,	0x2d7f, 0xc909,		0x21, 0
	.dw 0x2dc0, 0xc909,	0x2dff, 0xc909,		0x21, 0
	.dw 0x2e40, 0xc909,	0x2e7f, 0xc909,		0x21, 0
	.dw 0x2ec0, 0xc909,	0x2eff, 0xc909,		0x21, 0
	.dw 0x2f40, 0xc909,	0x2f7f, 0xc909,		0x21, 0
	.dw 0x2fc0, 0xc909,	0x2fff, 0xc909,		0x21, 0
	.dw 0x3040, 0xc909,	0x307f, 0xc909,		0x21, 0
	.dw 0x30c0, 0xc909,	0x30ff, 0xc909,		0x21, 0
	.dw 0x3140, 0xc909,	0x317f, 0xc909,		0x21, 0
	.dw 0x31c0, 0xc909,	0x31ff, 0xc909,		0x21, 0
	.dw 0x3240, 0xc909,	0x327f, 0xc909,		0x21, 0
	.dw 0x32c0, 0xc909,	0x32ff, 0xc909,		0x21, 0
	.dw 0x3340, 0xc909,	0x337f, 0xc909,		0x21, 0
	.dw 0x33c0, 0xc909,	0x33ff, 0xc909,		0x21, 0
	.dw 0x3440, 0xc909,	0x347f, 0xc909,		0x21, 0
	.dw 0x34c0, 0xc909,	0x34ff, 0xc909,		0x21, 0
	.dw 0x3540, 0xc909,	0x357f, 0xc909,		0x21, 0
	.dw 0x35c0, 0xc909,	0x35ff, 0xc909,		0x21, 0
	.dw 0x3640, 0xc909,	0x367f, 0xc909,		0x21, 0
	.dw 0x36c0, 0xc909,	0x36ff, 0xc909,		0x21, 0
	.dw 0x3740, 0xc909,	0x377f, 0xc909,		0x21, 0
	.dw 0x37c0, 0xc909,	0x37ff, 0xc909,		0x21, 0
	.dw 0x3840, 0xc909,	0x387f, 0xc909,		0x21, 0
	.dw 0x38c0, 0xc909,	0x38ff, 0xc909,		0x21, 0
	.dw 0x3940, 0xc909,	0x397f, 0xc909,		0x21, 0
	.dw 0x39c0, 0xc909,	0x5fff, 0xc909,		0x21, 0
	.dw 0x6040, 0xc909,	0x607f, 0xc909,		0x21, 0
	.dw 0x60c0, 0xc909,	0x60ff, 0xc909,		0x21, 0
	.dw 0x6140, 0xc909,	0x617f, 0xc909,		0x21, 0
	.dw 0x61c0, 0xc909,	0x61ff, 0xc909,		0x21, 0
	.dw 0x6240, 0xc909,	0x627f, 0xc909,		0x21, 0
	.dw 0x62c0, 0xc909,	0x62ff, 0xc909,		0x21, 0
	.dw 0x6340, 0xc909,	0x637f, 0xc909,		0x21, 0
	.dw 0x63c0, 0xc909,	0x63ff, 0xc909,		0x21, 0
	.dw 0x6440, 0xc909,	0x647f, 0xc909,		0x21, 0
	.dw 0x64c0, 0xc909,	0x64ff, 0xc909,		0x21, 0
	.dw 0x6540, 0xc909,	0x657f, 0xc909,		0x21, 0
	.dw 0x65c0, 0xc909,	0x65ff, 0xc909,		0x21, 0
	.dw 0x6640, 0xc909,	0x667f, 0xc909,		0x21, 0
	.dw 0x66c0, 0xc909,	0x66ff, 0xc909,		0x21, 0
	.dw 0x6740, 0xc909,	0x677f, 0xc909,		0x21, 0
	.dw 0x67c0, 0xc909,	0x67ff, 0xc909,		0x21, 0
	.dw 0x6840, 0xc909,	0x687f, 0xc909,		0x21, 0
	.dw 0x68c0, 0xc909,	0x68ff, 0xc909,		0x21, 0
	.dw 0x6940, 0xc909,	0x697f, 0xc909,		0x21, 0
	.dw 0x69c0, 0xc909,	0x69ff, 0xc909,		0x21, 0
	.dw 0x6a40, 0xc909,	0x6a7f, 0xc909,		0x21, 0
	.dw 0x6ac0, 0xc909,	0x6aff, 0xc909,		0x21, 0
	.dw 0x6b40, 0xc909,	0x6b7f, 0xc909,		0x21, 0
	.dw 0x6bc0, 0xc909,	0x6bff, 0xc909,		0x21, 0
	.dw 0x6c40, 0xc909,	0x6c7f, 0xc909,		0x21, 0
	.dw 0x6cc0, 0xc909,	0x6cff, 0xc909,		0x21, 0
	.dw 0x6d40, 0xc909,	0x6d7f, 0xc909,		0x21, 0
	.dw 0x6dc0, 0xc909,	0x6dff, 0xc909,		0x21, 0
	.dw 0x6e40, 0xc909,	0x6e7f, 0xc909,		0x21, 0
	.dw 0x6ec0, 0xc909,	0x6eff, 0xc909,		0x21, 0
	.dw 0x6f40, 0xc909,	0x6f7f, 0xc909,		0x21, 0
	.dw 0x6fc0, 0xc909,	0x6fff, 0xc909,		0x21, 0
	.dw 0x7040, 0xc909,	0x707f, 0xc909,		0x21, 0
	.dw 0x70c0, 0xc909,	0x70ff, 0xc909,		0x21, 0
	.dw 0x7140, 0xc909,	0x717f, 0xc909,		0x21, 0
	.dw 0x71c0, 0xc909,	0x71ff, 0xc909,		0x21, 0
	.dw 0x7240, 0xc909,	0x727f, 0xc909,		0x21, 0
	.dw 0x72c0, 0xc909,	0x72ff, 0xc909,		0x21, 0
	.dw 0x7340, 0xc909,	0x737f, 0xc909,		0x21, 0
	.dw 0x73c0, 0xc909,	0x73ff, 0xc909,		0x21, 0
	.dw 0x7440, 0xc909,	0x747f, 0xc909,		0x21, 0
	.dw 0x74c0, 0xc909,	0x74ff, 0xc909,		0x21, 0
	.dw 0x7540, 0xc909,	0x757f, 0xc909,		0x21, 0
	.dw 0x75c0, 0xc909,	0x75ff, 0xc909,		0x21, 0
	.dw 0x7640, 0xc909,	0x767f, 0xc909,		0x21, 0
	.dw 0x76c0, 0xc909,	0x76ff, 0xc909,		0x21, 0
	.dw 0x7740, 0xc909,	0x777f, 0xc909,		0x21, 0
	.dw 0x77c0, 0xc909,	0x77ff, 0xc909,		0x21, 0
	.dw 0x7840, 0xc909,	0x787f, 0xc909,		0x21, 0
	.dw 0x78c0, 0xc909,	0x78ff, 0xc909,		0x21, 0
	.dw 0x7940, 0xc909,	0x797f, 0xc909,		0x21, 0
	.dw 0x79c0, 0xc909,	0x9fff, 0xc909,		0x21, 0
	.dw 0xa040, 0xc909,	0xa07f, 0xc909,		0x21, 0
	.dw 0xa0c0, 0xc909,	0xa0ff, 0xc909,		0x21, 0
	.dw 0xa140, 0xc909,	0xa17f, 0xc909,		0x21, 0
	.dw 0xa1c0, 0xc909,	0xa1ff, 0xc909,		0x21, 0
	.dw 0xa240, 0xc909,	0xa27f, 0xc909,		0x21, 0
	.dw 0xa2c0, 0xc909,	0xa2ff, 0xc909,		0x21, 0
	.dw 0xa340, 0xc909,	0xa37f, 0xc909,		0x21, 0
	.dw 0xa3c0, 0xc909,	0xa3ff, 0xc909,		0x21, 0
	.dw 0xa440, 0xc909,	0xa47f, 0xc909,		0x21, 0
	.dw 0xa4c0, 0xc909,	0xa4ff, 0xc909,		0x21, 0
	.dw 0xa540, 0xc909,	0xa57f, 0xc909,		0x21, 0
	.dw 0xa5c0, 0xc909,	0xa5ff, 0xc909,		0x21, 0
	.dw 0xa640, 0xc909,	0xa67f, 0xc909,		0x21, 0
	.dw 0xa6c0, 0xc909,	0xa6ff, 0xc909,		0x21, 0
	.dw 0xa740, 0xc909,	0xa77f, 0xc909,		0x21, 0
	.dw 0xa7c0, 0xc909,	0xa7ff, 0xc909,		0x21, 0
	.dw 0xa840, 0xc909,	0xa87f, 0xc909,		0x21, 0
	.dw 0xa8c0, 0xc909,	0xa8ff, 0xc909,		0x21, 0
	.dw 0xa940, 0xc909,	0xa97f, 0xc909,		0x21, 0
	.dw 0xa9c0, 0xc909,	0xa9ff, 0xc909,		0x21, 0
	.dw 0xaa40, 0xc909,	0xaa7f, 0xc909,		0x21, 0
	.dw 0xaac0, 0xc909,	0xaaff, 0xc909,		0x21, 0
	.dw 0xab40, 0xc909,	0xab7f, 0xc909,		0x21, 0
	.dw 0xabc0, 0xc909,	0xabff, 0xc909,		0x21, 0
	.dw 0xac40, 0xc909,	0xac7f, 0xc909,		0x21, 0
	.dw 0xacc0, 0xc909,	0xacff, 0xc909,		0x21, 0
	.dw 0xad40, 0xc909,	0xad7f, 0xc909,		0x21, 0
	.dw 0xadc0, 0xc909,	0xadff, 0xc909,		0x21, 0
	.dw 0xae40, 0xc909,	0xae7f, 0xc909,		0x21, 0
	.dw 0xaec0, 0xc909,	0xaeff, 0xc909,		0x21, 0
	.dw 0xaf40, 0xc909,	0xaf7f, 0xc909,		0x21, 0
	.dw 0xafc0, 0xc909,	0xafff, 0xc909,		0x21, 0
	.dw 0xb040, 0xc909,	0xb07f, 0xc909,		0x21, 0
	.dw 0xb0c0, 0xc909,	0xb0ff, 0xc909,		0x21, 0
	.dw 0xb140, 0xc909,	0xb17f, 0xc909,		0x21, 0
	.dw 0xb1c0, 0xc909,	0xb1ff, 0xc909,		0x21, 0
	.dw 0xb240, 0xc909,	0xb27f, 0xc909,		0x21, 0
	.dw 0xb2c0, 0xc909,	0xb2ff, 0xc909,		0x21, 0
	.dw 0xb340, 0xc909,	0xb37f, 0xc909,		0x21, 0
	.dw 0xb3c0, 0xc909,	0xb3ff, 0xc909,		0x21, 0
	.dw 0xb440, 0xc909,	0xb47f, 0xc909,		0x21, 0
	.dw 0xb4c0, 0xc909,	0xb4ff, 0xc909,		0x21, 0
	.dw 0xb540, 0xc909,	0xb57f, 0xc909,		0x21, 0
	.dw 0xb5c0, 0xc909,	0xb5ff, 0xc909,		0x21, 0
	.dw 0xb640, 0xc909,	0xb67f, 0xc909,		0x21, 0
	.dw 0xb6c0, 0xc909,	0xb6ff, 0xc909,		0x21, 0
	.dw 0xb740, 0xc909,	0xb77f, 0xc909,		0x21, 0
	.dw 0xb7c0, 0xc909,	0xb7ff, 0xc909,		0x21, 0
	.dw 0xb840, 0xc909,	0xb87f, 0xc909,		0x21, 0
	.dw 0xb8c0, 0xc909,	0xb8ff, 0xc909,		0x21, 0
	.dw 0xb940, 0xc909,	0xb97f, 0xc909,		0x21, 0
	.dw 0xb9c0, 0xc909,	0xdfff, 0xc909,		0x21, 0
	.dw 0xe040, 0xc909,	0xe07f, 0xc909,		0x21, 0
	.dw 0xe0c0, 0xc909,	0xe0ff, 0xc909,		0x21, 0
	.dw 0xe140, 0xc909,	0xe17f, 0xc909,		0x21, 0
	.dw 0xe1c0, 0xc909,	0xe1ff, 0xc909,		0x21, 0
	.dw 0xe240, 0xc909,	0xe27f, 0xc909,		0x21, 0
	.dw 0xe2c0, 0xc909,	0xe2ff, 0xc909,		0x21, 0
	.dw 0xe340, 0xc909,	0xe37f, 0xc909,		0x21, 0
	.dw 0xe3c0, 0xc909,	0xe3ff, 0xc909,		0x21, 0
	.dw 0xe440, 0xc909,	0xe47f, 0xc909,		0x21, 0
	.dw 0xe4c0, 0xc909,	0xe4ff, 0xc909,		0x21, 0
	.dw 0xe540, 0xc909,	0xe57f, 0xc909,		0x21, 0
	.dw 0xe5c0, 0xc909,	0xe5ff, 0xc909,		0x21, 0
	.dw 0xe640, 0xc909,	0xe67f, 0xc909,		0x21, 0
	.dw 0xe6c0, 0xc909,	0xe6ff, 0xc909,		0x21, 0
	.dw 0xe740, 0xc909,	0xe77f, 0xc909,		0x21, 0
	.dw 0xe7c0, 0xc909,	0xe7ff, 0xc909,		0x21, 0
	.dw 0xe840, 0xc909,	0xe87f, 0xc909,		0x21, 0
	.dw 0xe8c0, 0xc909,	0xe8ff, 0xc909,		0x21, 0
	.dw 0xe940, 0xc909,	0xe97f, 0xc909,		0x21, 0
	.dw 0xe9c0, 0xc909,	0xe9ff, 0xc909,		0x21, 0
	.dw 0xea40, 0xc909,	0xea7f, 0xc909,		0x21, 0
	.dw 0xeac0, 0xc909,	0xeaff, 0xc909,		0x21, 0
	.dw 0xeb40, 0xc909,	0xeb7f, 0xc909,		0x21, 0
	.dw 0xebc0, 0xc909,	0xebff, 0xc909,		0x21, 0
	.dw 0xec40, 0xc909,	0xec7f, 0xc909,		0x21, 0
	.dw 0xecc0, 0xc909,	0xecff, 0xc909,		0x21, 0
	.dw 0xed40, 0xc909,	0xed7f, 0xc909,		0x21, 0
	.dw 0xedc0, 0xc909,	0xedff, 0xc909,		0x21, 0
	.dw 0xee40, 0xc909,	0xee7f, 0xc909,		0x21, 0
	.dw 0xeec0, 0xc909,	0xeeff, 0xc909,		0x21, 0
	.dw 0xef40, 0xc909,	0xef7f, 0xc909,		0x21, 0
	.dw 0xefc0, 0xc909,	0xefff, 0xc909,		0x21, 0
	.dw 0xf040, 0xc909,	0xf07f, 0xc909,		0x21, 0
	.dw 0xf0c0, 0xc909,	0xf0ff, 0xc909,		0x21, 0
	.dw 0xf140, 0xc909,	0xf17f, 0xc909,		0x21, 0
	.dw 0xf1c0, 0xc909,	0xf1ff, 0xc909,		0x21, 0
	.dw 0xf240, 0xc909,	0xf27f, 0xc909,		0x21, 0
	.dw 0xf2c0, 0xc909,	0xf2ff, 0xc909,		0x21, 0
	.dw 0xf340, 0xc909,	0xf37f, 0xc909,		0x21, 0
	.dw 0xf3c0, 0xc909,	0xf3ff, 0xc909,		0x21, 0
	.dw 0xf440, 0xc909,	0xf47f, 0xc909,		0x21, 0
	.dw 0xf4c0, 0xc909,	0xf4ff, 0xc909,		0x21, 0
	.dw 0xf540, 0xc909,	0xf57f, 0xc909,		0x21, 0
	.dw 0xf5c0, 0xc909,	0xf5ff, 0xc909,		0x21, 0
	.dw 0xf640, 0xc909,	0xf67f, 0xc909,		0x21, 0
	.dw 0xf6c0, 0xc909,	0xf6ff, 0xc909,		0x21, 0
	.dw 0xf740, 0xc909,	0xf77f, 0xc909,		0x21, 0
	.dw 0xf7c0, 0xc909,	0xf7ff, 0xc909,		0x21, 0
	.dw 0xf840, 0xc909,	0xf87f, 0xc909,		0x21, 0
	.dw 0xf8c0, 0xc909,	0xf8ff, 0xc909,		0x21, 0
	.dw 0xf940, 0xc909,	0xf97f, 0xc909,		0x21, 0
	.dw 0xf9c0, 0xc909,	0x1fff, 0xc90a,		0x21, 0
	.dw 0x2040, 0xc90a,	0x207f, 0xc90a,		0x21, 0
	.dw 0x20c0, 0xc90a,	0x20ff, 0xc90a,		0x21, 0
	.dw 0x2140, 0xc90a,	0x217f, 0xc90a,		0x21, 0
	.dw 0x21c0, 0xc90a,	0x21ff, 0xc90a,		0x21, 0
	.dw 0x2240, 0xc90a,	0x227f, 0xc90a,		0x21, 0
	.dw 0x22c0, 0xc90a,	0x22ff, 0xc90a,		0x21, 0
	.dw 0x2340, 0xc90a,	0x237f, 0xc90a,		0x21, 0
	.dw 0x23c0, 0xc90a,	0x23ff, 0xc90a,		0x21, 0
	.dw 0x2440, 0xc90a,	0x247f, 0xc90a,		0x21, 0
	.dw 0x24c0, 0xc90a,	0x24ff, 0xc90a,		0x21, 0
	.dw 0x2540, 0xc90a,	0x257f, 0xc90a,		0x21, 0
	.dw 0x25c0, 0xc90a,	0x25ff, 0xc90a,		0x21, 0
	.dw 0x2640, 0xc90a,	0x267f, 0xc90a,		0x21, 0
	.dw 0x26c0, 0xc90a,	0x26ff, 0xc90a,		0x21, 0
	.dw 0x2740, 0xc90a,	0x277f, 0xc90a,		0x21, 0
	.dw 0x27c0, 0xc90a,	0x27ff, 0xc90a,		0x21, 0
	.dw 0x2840, 0xc90a,	0x287f, 0xc90a,		0x21, 0
	.dw 0x28c0, 0xc90a,	0x28ff, 0xc90a,		0x21, 0
	.dw 0x2940, 0xc90a,	0x297f, 0xc90a,		0x21, 0
	.dw 0x29c0, 0xc90a,	0x29ff, 0xc90a,		0x21, 0
	.dw 0x2a40, 0xc90a,	0x2a7f, 0xc90a,		0x21, 0
	.dw 0x2ac0, 0xc90a,	0x2aff, 0xc90a,		0x21, 0
	.dw 0x2b40, 0xc90a,	0x2b7f, 0xc90a,		0x21, 0
	.dw 0x2bc0, 0xc90a,	0x2bff, 0xc90a,		0x21, 0
	.dw 0x2c40, 0xc90a,	0x2c7f, 0xc90a,		0x21, 0
	.dw 0x2cc0, 0xc90a,	0x2cff, 0xc90a,		0x21, 0
	.dw 0x2d40, 0xc90a,	0x2d7f, 0xc90a,		0x21, 0
	.dw 0x2dc0, 0xc90a,	0x2dff, 0xc90a,		0x21, 0
	.dw 0x2e40, 0xc90a,	0x2e7f, 0xc90a,		0x21, 0
	.dw 0x2ec0, 0xc90a,	0x2eff, 0xc90a,		0x21, 0
	.dw 0x2f40, 0xc90a,	0x2f7f, 0xc90a,		0x21, 0
	.dw 0x2fc0, 0xc90a,	0x2fff, 0xc90a,		0x21, 0
	.dw 0x3040, 0xc90a,	0x307f, 0xc90a,		0x21, 0
	.dw 0x30c0, 0xc90a,	0x30ff, 0xc90a,		0x21, 0
	.dw 0x3140, 0xc90a,	0x317f, 0xc90a,		0x21, 0
	.dw 0x31c0, 0xc90a,	0x31ff, 0xc90a,		0x21, 0
	.dw 0x3240, 0xc90a,	0x327f, 0xc90a,		0x21, 0
	.dw 0x32c0, 0xc90a,	0x32ff, 0xc90a,		0x21, 0
	.dw 0x3340, 0xc90a,	0x337f, 0xc90a,		0x21, 0
	.dw 0x33c0, 0xc90a,	0x33ff, 0xc90a,		0x21, 0
	.dw 0x3440, 0xc90a,	0x347f, 0xc90a,		0x21, 0
	.dw 0x34c0, 0xc90a,	0x34ff, 0xc90a,		0x21, 0
	.dw 0x3540, 0xc90a,	0x357f, 0xc90a,		0x21, 0
	.dw 0x35c0, 0xc90a,	0x35ff, 0xc90a,		0x21, 0
	.dw 0x3640, 0xc90a,	0x367f, 0xc90a,		0x21, 0
	.dw 0x36c0, 0xc90a,	0x36ff, 0xc90a,		0x21, 0
	.dw 0x3740, 0xc90a,	0x377f, 0xc90a,		0x21, 0
	.dw 0x37c0, 0xc90a,	0x37ff, 0xc90a,		0x21, 0
	.dw 0x3840, 0xc90a,	0x387f, 0xc90a,		0x21, 0
	.dw 0x38c0, 0xc90a,	0x38ff, 0xc90a,		0x21, 0
	.dw 0x3940, 0xc90a,	0x397f, 0xc90a,		0x21, 0
	.dw 0x39c0, 0xc90a,	0x5fff, 0xc90a,		0x21, 0
	.dw 0x6040, 0xc90a,	0x607f, 0xc90a,		0x21, 0
	.dw 0x60c0, 0xc90a,	0x60ff, 0xc90a,		0x21, 0
	.dw 0x6140, 0xc90a,	0x617f, 0xc90a,		0x21, 0
	.dw 0x61c0, 0xc90a,	0x61ff, 0xc90a,		0x21, 0
	.dw 0x6240, 0xc90a,	0x627f, 0xc90a,		0x21, 0
	.dw 0x62c0, 0xc90a,	0x62ff, 0xc90a,		0x21, 0
	.dw 0x6340, 0xc90a,	0x637f, 0xc90a,		0x21, 0
	.dw 0x63c0, 0xc90a,	0x63ff, 0xc90a,		0x21, 0
	.dw 0x6440, 0xc90a,	0x647f, 0xc90a,		0x21, 0
	.dw 0x64c0, 0xc90a,	0x64ff, 0xc90a,		0x21, 0
	.dw 0x6540, 0xc90a,	0x657f, 0xc90a,		0x21, 0
	.dw 0x65c0, 0xc90a,	0x65ff, 0xc90a,		0x21, 0
	.dw 0x6640, 0xc90a,	0x667f, 0xc90a,		0x21, 0
	.dw 0x66c0, 0xc90a,	0x66ff, 0xc90a,		0x21, 0
	.dw 0x6740, 0xc90a,	0x677f, 0xc90a,		0x21, 0
	.dw 0x67c0, 0xc90a,	0x67ff, 0xc90a,		0x21, 0
	.dw 0x6840, 0xc90a,	0x687f, 0xc90a,		0x21, 0
	.dw 0x68c0, 0xc90a,	0x68ff, 0xc90a,		0x21, 0
	.dw 0x6940, 0xc90a,	0x697f, 0xc90a,		0x21, 0
	.dw 0x69c0, 0xc90a,	0x69ff, 0xc90a,		0x21, 0
	.dw 0x6a40, 0xc90a,	0x6a7f, 0xc90a,		0x21, 0
	.dw 0x6ac0, 0xc90a,	0x6aff, 0xc90a,		0x21, 0
	.dw 0x6b40, 0xc90a,	0x6b7f, 0xc90a,		0x21, 0
	.dw 0x6bc0, 0xc90a,	0x6bff, 0xc90a,		0x21, 0
	.dw 0x6c40, 0xc90a,	0x6c7f, 0xc90a,		0x21, 0
	.dw 0x6cc0, 0xc90a,	0x6cff, 0xc90a,		0x21, 0
	.dw 0x6d40, 0xc90a,	0x6d7f, 0xc90a,		0x21, 0
	.dw 0x6dc0, 0xc90a,	0x6dff, 0xc90a,		0x21, 0
	.dw 0x6e40, 0xc90a,	0x6e7f, 0xc90a,		0x21, 0
	.dw 0x6ec0, 0xc90a,	0x6eff, 0xc90a,		0x21, 0
	.dw 0x6f40, 0xc90a,	0x6f7f, 0xc90a,		0x21, 0
	.dw 0x6fc0, 0xc90a,	0x6fff, 0xc90a,		0x21, 0
	.dw 0x7040, 0xc90a,	0x707f, 0xc90a,		0x21, 0
	.dw 0x70c0, 0xc90a,	0x70ff, 0xc90a,		0x21, 0
	.dw 0x7140, 0xc90a,	0x717f, 0xc90a,		0x21, 0
	.dw 0x71c0, 0xc90a,	0x71ff, 0xc90a,		0x21, 0
	.dw 0x7240, 0xc90a,	0x727f, 0xc90a,		0x21, 0
	.dw 0x72c0, 0xc90a,	0x72ff, 0xc90a,		0x21, 0
	.dw 0x7340, 0xc90a,	0x737f, 0xc90a,		0x21, 0
	.dw 0x73c0, 0xc90a,	0x73ff, 0xc90a,		0x21, 0
	.dw 0x7440, 0xc90a,	0x747f, 0xc90a,		0x21, 0
	.dw 0x74c0, 0xc90a,	0x74ff, 0xc90a,		0x21, 0
	.dw 0x7540, 0xc90a,	0x757f, 0xc90a,		0x21, 0
	.dw 0x75c0, 0xc90a,	0x75ff, 0xc90a,		0x21, 0
	.dw 0x7640, 0xc90a,	0x767f, 0xc90a,		0x21, 0
	.dw 0x76c0, 0xc90a,	0x76ff, 0xc90a,		0x21, 0
	.dw 0x7740, 0xc90a,	0x777f, 0xc90a,		0x21, 0
	.dw 0x77c0, 0xc90a,	0x77ff, 0xc90a,		0x21, 0
	.dw 0x7840, 0xc90a,	0x787f, 0xc90a,		0x21, 0
	.dw 0x78c0, 0xc90a,	0x78ff, 0xc90a,		0x21, 0
	.dw 0x7940, 0xc90a,	0x797f, 0xc90a,		0x21, 0
	.dw 0x79c0, 0xc90a,	0x9fff, 0xc90a,		0x21, 0
	.dw 0xa040, 0xc90a,	0xa07f, 0xc90a,		0x21, 0
	.dw 0xa0c0, 0xc90a,	0xa0ff, 0xc90a,		0x21, 0
	.dw 0xa140, 0xc90a,	0xa17f, 0xc90a,		0x21, 0
	.dw 0xa1c0, 0xc90a,	0xa1ff, 0xc90a,		0x21, 0
	.dw 0xa240, 0xc90a,	0xa27f, 0xc90a,		0x21, 0
	.dw 0xa2c0, 0xc90a,	0xa2ff, 0xc90a,		0x21, 0
	.dw 0xa340, 0xc90a,	0xa37f, 0xc90a,		0x21, 0
	.dw 0xa3c0, 0xc90a,	0xa3ff, 0xc90a,		0x21, 0
	.dw 0xa440, 0xc90a,	0xa47f, 0xc90a,		0x21, 0
	.dw 0xa4c0, 0xc90a,	0xa4ff, 0xc90a,		0x21, 0
	.dw 0xa540, 0xc90a,	0xa57f, 0xc90a,		0x21, 0
	.dw 0xa5c0, 0xc90a,	0xa5ff, 0xc90a,		0x21, 0
	.dw 0xa640, 0xc90a,	0xa67f, 0xc90a,		0x21, 0
	.dw 0xa6c0, 0xc90a,	0xa6ff, 0xc90a,		0x21, 0
	.dw 0xa740, 0xc90a,	0xa77f, 0xc90a,		0x21, 0
	.dw 0xa7c0, 0xc90a,	0xa7ff, 0xc90a,		0x21, 0
	.dw 0xa840, 0xc90a,	0xa87f, 0xc90a,		0x21, 0
	.dw 0xa8c0, 0xc90a,	0xa8ff, 0xc90a,		0x21, 0
	.dw 0xa940, 0xc90a,	0xa97f, 0xc90a,		0x21, 0
	.dw 0xa9c0, 0xc90a,	0xa9ff, 0xc90a,		0x21, 0
	.dw 0xaa40, 0xc90a,	0xaa7f, 0xc90a,		0x21, 0
	.dw 0xaac0, 0xc90a,	0xaaff, 0xc90a,		0x21, 0
	.dw 0xab40, 0xc90a,	0xab7f, 0xc90a,		0x21, 0
	.dw 0xabc0, 0xc90a,	0xabff, 0xc90a,		0x21, 0
	.dw 0xac40, 0xc90a,	0xac7f, 0xc90a,		0x21, 0
	.dw 0xacc0, 0xc90a,	0xacff, 0xc90a,		0x21, 0
	.dw 0xad40, 0xc90a,	0xad7f, 0xc90a,		0x21, 0
	.dw 0xadc0, 0xc90a,	0xadff, 0xc90a,		0x21, 0
	.dw 0xae40, 0xc90a,	0xae7f, 0xc90a,		0x21, 0
	.dw 0xaec0, 0xc90a,	0xaeff, 0xc90a,		0x21, 0
	.dw 0xaf40, 0xc90a,	0xaf7f, 0xc90a,		0x21, 0
	.dw 0xafc0, 0xc90a,	0xafff, 0xc90a,		0x21, 0
	.dw 0xb040, 0xc90a,	0xb07f, 0xc90a,		0x21, 0
	.dw 0xb0c0, 0xc90a,	0xb0ff, 0xc90a,		0x21, 0
	.dw 0xb140, 0xc90a,	0xb17f, 0xc90a,		0x21, 0
	.dw 0xb1c0, 0xc90a,	0xb1ff, 0xc90a,		0x21, 0
	.dw 0xb240, 0xc90a,	0xb27f, 0xc90a,		0x21, 0
	.dw 0xb2c0, 0xc90a,	0xb2ff, 0xc90a,		0x21, 0
	.dw 0xb340, 0xc90a,	0xb37f, 0xc90a,		0x21, 0
	.dw 0xb3c0, 0xc90a,	0xb3ff, 0xc90a,		0x21, 0
	.dw 0xb440, 0xc90a,	0xb47f, 0xc90a,		0x21, 0
	.dw 0xb4c0, 0xc90a,	0xb4ff, 0xc90a,		0x21, 0
	.dw 0xb540, 0xc90a,	0xb57f, 0xc90a,		0x21, 0
	.dw 0xb5c0, 0xc90a,	0xb5ff, 0xc90a,		0x21, 0
	.dw 0xb640, 0xc90a,	0xb67f, 0xc90a,		0x21, 0
	.dw 0xb6c0, 0xc90a,	0xb6ff, 0xc90a,		0x21, 0
	.dw 0xb740, 0xc90a,	0xb77f, 0xc90a,		0x21, 0
	.dw 0xb7c0, 0xc90a,	0xb7ff, 0xc90a,		0x21, 0
	.dw 0xb840, 0xc90a,	0xb87f, 0xc90a,		0x21, 0
	.dw 0xb8c0, 0xc90a,	0xb8ff, 0xc90a,		0x21, 0
	.dw 0xb940, 0xc90a,	0xb97f, 0xc90a,		0x21, 0
	.dw 0xb9c0, 0xc90a,	0xdfff, 0xc90a,		0x21, 0
	.dw 0xe040, 0xc90a,	0xe07f, 0xc90a,		0x21, 0
	.dw 0xe0c0, 0xc90a,	0xe0ff, 0xc90a,		0x21, 0
	.dw 0xe140, 0xc90a,	0xe17f, 0xc90a,		0x21, 0
	.dw 0xe1c0, 0xc90a,	0xe1ff, 0xc90a,		0x21, 0
	.dw 0xe240, 0xc90a,	0xe27f, 0xc90a,		0x21, 0
	.dw 0xe2c0, 0xc90a,	0xe2ff, 0xc90a,		0x21, 0
	.dw 0xe340, 0xc90a,	0xe37f, 0xc90a,		0x21, 0
	.dw 0xe3c0, 0xc90a,	0xe3ff, 0xc90a,		0x21, 0
	.dw 0xe440, 0xc90a,	0xe47f, 0xc90a,		0x21, 0
	.dw 0xe4c0, 0xc90a,	0xe4ff, 0xc90a,		0x21, 0
	.dw 0xe540, 0xc90a,	0xe57f, 0xc90a,		0x21, 0
	.dw 0xe5c0, 0xc90a,	0xe5ff, 0xc90a,		0x21, 0
	.dw 0xe640, 0xc90a,	0xe67f, 0xc90a,		0x21, 0
	.dw 0xe6c0, 0xc90a,	0xe6ff, 0xc90a,		0x21, 0
	.dw 0xe740, 0xc90a,	0xe77f, 0xc90a,		0x21, 0
	.dw 0xe7c0, 0xc90a,	0xe7ff, 0xc90a,		0x21, 0
	.dw 0xe840, 0xc90a,	0xe87f, 0xc90a,		0x21, 0
	.dw 0xe8c0, 0xc90a,	0xe8ff, 0xc90a,		0x21, 0
	.dw 0xe940, 0xc90a,	0xe97f, 0xc90a,		0x21, 0
	.dw 0xe9c0, 0xc90a,	0xe9ff, 0xc90a,		0x21, 0
	.dw 0xea40, 0xc90a,	0xea7f, 0xc90a,		0x21, 0
	.dw 0xeac0, 0xc90a,	0xeaff, 0xc90a,		0x21, 0
	.dw 0xeb40, 0xc90a,	0xeb7f, 0xc90a,		0x21, 0
	.dw 0xebc0, 0xc90a,	0xebff, 0xc90a,		0x21, 0
	.dw 0xec40, 0xc90a,	0xec7f, 0xc90a,		0x21, 0
	.dw 0xecc0, 0xc90a,	0xecff, 0xc90a,		0x21, 0
	.dw 0xed40, 0xc90a,	0xed7f, 0xc90a,		0x21, 0
	.dw 0xedc0, 0xc90a,	0xedff, 0xc90a,		0x21, 0
	.dw 0xee40, 0xc90a,	0xee7f, 0xc90a,		0x21, 0
	.dw 0xeec0, 0xc90a,	0xeeff, 0xc90a,		0x21, 0
	.dw 0xef40, 0xc90a,	0xef7f, 0xc90a,		0x21, 0
	.dw 0xefc0, 0xc90a,	0xefff, 0xc90a,		0x21, 0
	.dw 0xf040, 0xc90a,	0xf07f, 0xc90a,		0x21, 0
	.dw 0xf0c0, 0xc90a,	0xf0ff, 0xc90a,		0x21, 0
	.dw 0xf140, 0xc90a,	0xf17f, 0xc90a,		0x21, 0
	.dw 0xf1c0, 0xc90a,	0xf1ff, 0xc90a,		0x21, 0
	.dw 0xf240, 0xc90a,	0xf27f, 0xc90a,		0x21, 0
	.dw 0xf2c0, 0xc90a,	0xf2ff, 0xc90a,		0x21, 0
	.dw 0xf340, 0xc90a,	0xf37f, 0xc90a,		0x21, 0
	.dw 0xf3c0, 0xc90a,	0xf3ff, 0xc90a,		0x21, 0
	.dw 0xf440, 0xc90a,	0xf47f, 0xc90a,		0x21, 0
	.dw 0xf4c0, 0xc90a,	0xf4ff, 0xc90a,		0x21, 0
	.dw 0xf540, 0xc90a,	0xf57f, 0xc90a,		0x21, 0
	.dw 0xf5c0, 0xc90a,	0xf5ff, 0xc90a,		0x21, 0
	.dw 0xf640, 0xc90a,	0xf67f, 0xc90a,		0x21, 0
	.dw 0xf6c0, 0xc90a,	0xf6ff, 0xc90a,		0x21, 0
	.dw 0xf740, 0xc90a,	0xf77f, 0xc90a,		0x21, 0
	.dw 0xf7c0, 0xc90a,	0xf7ff, 0xc90a,		0x21, 0
	.dw 0xf840, 0xc90a,	0xf87f, 0xc90a,		0x21, 0
	.dw 0xf8c0, 0xc90a,	0xf8ff, 0xc90a,		0x21, 0
	.dw 0xf940, 0xc90a,	0xf97f, 0xc90a,		0x21, 0
	.dw 0xf9c0, 0xc90a,	0x1fff, 0xc90b,		0x21, 0
	.dw 0x2040, 0xc90b,	0x207f, 0xc90b,		0x21, 0
	.dw 0x20c0, 0xc90b,	0x20ff, 0xc90b,		0x21, 0
	.dw 0x2140, 0xc90b,	0x217f, 0xc90b,		0x21, 0
	.dw 0x21c0, 0xc90b,	0x21ff, 0xc90b,		0x21, 0
	.dw 0x2240, 0xc90b,	0x227f, 0xc90b,		0x21, 0
	.dw 0x22c0, 0xc90b,	0x22ff, 0xc90b,		0x21, 0
	.dw 0x2340, 0xc90b,	0x237f, 0xc90b,		0x21, 0
	.dw 0x23c0, 0xc90b,	0x23ff, 0xc90b,		0x21, 0
	.dw 0x2440, 0xc90b,	0x247f, 0xc90b,		0x21, 0
	.dw 0x24c0, 0xc90b,	0x24ff, 0xc90b,		0x21, 0
	.dw 0x2540, 0xc90b,	0x257f, 0xc90b,		0x21, 0
	.dw 0x25c0, 0xc90b,	0x25ff, 0xc90b,		0x21, 0
	.dw 0x2640, 0xc90b,	0x267f, 0xc90b,		0x21, 0
	.dw 0x26c0, 0xc90b,	0x26ff, 0xc90b,		0x21, 0
	.dw 0x2740, 0xc90b,	0x277f, 0xc90b,		0x21, 0
	.dw 0x27c0, 0xc90b,	0x27ff, 0xc90b,		0x21, 0
	.dw 0x2840, 0xc90b,	0x287f, 0xc90b,		0x21, 0
	.dw 0x28c0, 0xc90b,	0x28ff, 0xc90b,		0x21, 0
	.dw 0x2940, 0xc90b,	0x297f, 0xc90b,		0x21, 0
	.dw 0x29c0, 0xc90b,	0x29ff, 0xc90b,		0x21, 0
	.dw 0x2a40, 0xc90b,	0x2a7f, 0xc90b,		0x21, 0
	.dw 0x2ac0, 0xc90b,	0x2aff, 0xc90b,		0x21, 0
	.dw 0x2b40, 0xc90b,	0x2b7f, 0xc90b,		0x21, 0
	.dw 0x2bc0, 0xc90b,	0x2bff, 0xc90b,		0x21, 0
	.dw 0x2c40, 0xc90b,	0x2c7f, 0xc90b,		0x21, 0
	.dw 0x2cc0, 0xc90b,	0x2cff, 0xc90b,		0x21, 0
	.dw 0x2d40, 0xc90b,	0x2d7f, 0xc90b,		0x21, 0
	.dw 0x2dc0, 0xc90b,	0x2dff, 0xc90b,		0x21, 0
	.dw 0x2e40, 0xc90b,	0x2e7f, 0xc90b,		0x21, 0
	.dw 0x2ec0, 0xc90b,	0x2eff, 0xc90b,		0x21, 0
	.dw 0x2f40, 0xc90b,	0x2f7f, 0xc90b,		0x21, 0
	.dw 0x2fc0, 0xc90b,	0x2fff, 0xc90b,		0x21, 0
	.dw 0x3040, 0xc90b,	0x307f, 0xc90b,		0x21, 0
	.dw 0x30c0, 0xc90b,	0x30ff, 0xc90b,		0x21, 0
	.dw 0x3140, 0xc90b,	0x317f, 0xc90b,		0x21, 0
	.dw 0x31c0, 0xc90b,	0x31ff, 0xc90b,		0x21, 0
	.dw 0x3240, 0xc90b,	0x327f, 0xc90b,		0x21, 0
	.dw 0x32c0, 0xc90b,	0x32ff, 0xc90b,		0x21, 0
	.dw 0x3340, 0xc90b,	0x337f, 0xc90b,		0x21, 0
	.dw 0x33c0, 0xc90b,	0x33ff, 0xc90b,		0x21, 0
	.dw 0x3440, 0xc90b,	0x347f, 0xc90b,		0x21, 0
	.dw 0x34c0, 0xc90b,	0x34ff, 0xc90b,		0x21, 0
	.dw 0x3540, 0xc90b,	0x357f, 0xc90b,		0x21, 0
	.dw 0x35c0, 0xc90b,	0x35ff, 0xc90b,		0x21, 0
	.dw 0x3640, 0xc90b,	0x367f, 0xc90b,		0x21, 0
	.dw 0x36c0, 0xc90b,	0x36ff, 0xc90b,		0x21, 0
	.dw 0x3740, 0xc90b,	0x377f, 0xc90b,		0x21, 0
	.dw 0x37c0, 0xc90b,	0x37ff, 0xc90b,		0x21, 0
	.dw 0x3840, 0xc90b,	0x387f, 0xc90b,		0x21, 0
	.dw 0x38c0, 0xc90b,	0x38ff, 0xc90b,		0x21, 0
	.dw 0x3940, 0xc90b,	0x397f, 0xc90b,		0x21, 0
	.dw 0x39c0, 0xc90b,	0xffff, 0xc90b,		0x21, 0
	.dw 0x0040, 0xc90c,	0x007f, 0xc90c,		0x21, 0
	.dw 0x00c0, 0xc90c,	0x00ff, 0xc90c,		0x21, 0
	.dw 0x0140, 0xc90c,	0x017f, 0xc90c,		0x21, 0
	.dw 0x01c0, 0xc90c,	0x01ff, 0xc90c,		0x21, 0
	.dw 0x0240, 0xc90c,	0x027f, 0xc90c,		0x21, 0
	.dw 0x02c0, 0xc90c,	0x02ff, 0xc90c,		0x21, 0
	.dw 0x0340, 0xc90c,	0x037f, 0xc90c,		0x21, 0
	.dw 0x03c0, 0xc90c,	0x03ff, 0xc90c,		0x21, 0
	.dw 0x0440, 0xc90c,	0x047f, 0xc90c,		0x21, 0
	.dw 0x04c0, 0xc90c,	0x04ff, 0xc90c,		0x21, 0
	.dw 0x0540, 0xc90c,	0x057f, 0xc90c,		0x21, 0
	.dw 0x05c0, 0xc90c,	0x05ff, 0xc90c,		0x21, 0
	.dw 0x0640, 0xc90c,	0x067f, 0xc90c,		0x21, 0
	.dw 0x06c0, 0xc90c,	0x06ff, 0xc90c,		0x21, 0
	.dw 0x0740, 0xc90c,	0x077f, 0xc90c,		0x21, 0
	.dw 0x07c0, 0xc90c,	0x07ff, 0xc90c,		0x21, 0
	.dw 0x0840, 0xc90c,	0x087f, 0xc90c,		0x21, 0
	.dw 0x08c0, 0xc90c,	0x08ff, 0xc90c,		0x21, 0
	.dw 0x0940, 0xc90c,	0x097f, 0xc90c,		0x21, 0
	.dw 0x09c0, 0xc90c,	0x09ff, 0xc90c,		0x21, 0
	.dw 0x0a40, 0xc90c,	0x0a7f, 0xc90c,		0x21, 0
	.dw 0x0ac0, 0xc90c,	0x0aff, 0xc90c,		0x21, 0
	.dw 0x0b40, 0xc90c,	0x0b7f, 0xc90c,		0x21, 0
	.dw 0x0bc0, 0xc90c,	0x0bff, 0xc90c,		0x21, 0
	.dw 0x0c40, 0xc90c,	0x0c7f, 0xc90c,		0x21, 0
	.dw 0x0cc0, 0xc90c,	0x0cff, 0xc90c,		0x21, 0
	.dw 0x0d40, 0xc90c,	0x0d7f, 0xc90c,		0x21, 0
	.dw 0x0dc0, 0xc90c,	0x0dff, 0xc90c,		0x21, 0
	.dw 0x0e40, 0xc90c,	0x0e7f, 0xc90c,		0x21, 0
	.dw 0x0ec0, 0xc90c,	0x0eff, 0xc90c,		0x21, 0
	.dw 0x0f40, 0xc90c,	0x0f7f, 0xc90c,		0x21, 0
	.dw 0x0fc0, 0xc90c,	0x0fff, 0xc90c,		0x21, 0
	.dw 0x1040, 0xc90c,	0x107f, 0xc90c,		0x21, 0
	.dw 0x10c0, 0xc90c,	0x10ff, 0xc90c,		0x21, 0
	.dw 0x1140, 0xc90c,	0x117f, 0xc90c,		0x21, 0
	.dw 0x11c0, 0xc90c,	0x11ff, 0xc90c,		0x21, 0
	.dw 0x1240, 0xc90c,	0x127f, 0xc90c,		0x21, 0
	.dw 0x12c0, 0xc90c,	0x12ff, 0xc90c,		0x21, 0
	.dw 0x1340, 0xc90c,	0x137f, 0xc90c,		0x21, 0
	.dw 0x13c0, 0xc90c,	0x13ff, 0xc90c,		0x21, 0
	.dw 0x1440, 0xc90c,	0x147f, 0xc90c,		0x21, 0
	.dw 0x14c0, 0xc90c,	0x14ff, 0xc90c,		0x21, 0
	.dw 0x1540, 0xc90c,	0x157f, 0xc90c,		0x21, 0
	.dw 0x15c0, 0xc90c,	0x15ff, 0xc90c,		0x21, 0
	.dw 0x1640, 0xc90c,	0x167f, 0xc90c,		0x21, 0
	.dw 0x16c0, 0xc90c,	0x16ff, 0xc90c,		0x21, 0
	.dw 0x1740, 0xc90c,	0x177f, 0xc90c,		0x21, 0
	.dw 0x17c0, 0xc90c,	0x17ff, 0xc90c,		0x21, 0
	.dw 0x1840, 0xc90c,	0x187f, 0xc90c,		0x21, 0
	.dw 0x18c0, 0xc90c,	0x18ff, 0xc90c,		0x21, 0
	.dw 0x1940, 0xc90c,	0x197f, 0xc90c,		0x21, 0
	.dw 0x19c0, 0xc90c,	0x1fff, 0xc90c,		0x21, 0
	.dw 0x2040, 0xc90c,	0x207f, 0xc90c,		0x21, 0
	.dw 0x20c0, 0xc90c,	0x20ff, 0xc90c,		0x21, 0
	.dw 0x2140, 0xc90c,	0x217f, 0xc90c,		0x21, 0
	.dw 0x21c0, 0xc90c,	0x21ff, 0xc90c,		0x21, 0
	.dw 0x2240, 0xc90c,	0x227f, 0xc90c,		0x21, 0
	.dw 0x22c0, 0xc90c,	0x22ff, 0xc90c,		0x21, 0
	.dw 0x2340, 0xc90c,	0x237f, 0xc90c,		0x21, 0
	.dw 0x23c0, 0xc90c,	0x23ff, 0xc90c,		0x21, 0
	.dw 0x2440, 0xc90c,	0x247f, 0xc90c,		0x21, 0
	.dw 0x24c0, 0xc90c,	0x24ff, 0xc90c,		0x21, 0
	.dw 0x2540, 0xc90c,	0x257f, 0xc90c,		0x21, 0
	.dw 0x25c0, 0xc90c,	0x25ff, 0xc90c,		0x21, 0
	.dw 0x2640, 0xc90c,	0x267f, 0xc90c,		0x21, 0
	.dw 0x26c0, 0xc90c,	0x26ff, 0xc90c,		0x21, 0
	.dw 0x2740, 0xc90c,	0x277f, 0xc90c,		0x21, 0
	.dw 0x27c0, 0xc90c,	0x27ff, 0xc90c,		0x21, 0
	.dw 0x2840, 0xc90c,	0x287f, 0xc90c,		0x21, 0
	.dw 0x28c0, 0xc90c,	0x28ff, 0xc90c,		0x21, 0
	.dw 0x2940, 0xc90c,	0x297f, 0xc90c,		0x21, 0
	.dw 0x29c0, 0xc90c,	0x29ff, 0xc90c,		0x21, 0
	.dw 0x2a40, 0xc90c,	0x2a7f, 0xc90c,		0x21, 0
	.dw 0x2ac0, 0xc90c,	0x2aff, 0xc90c,		0x21, 0
	.dw 0x2b40, 0xc90c,	0x2b7f, 0xc90c,		0x21, 0
	.dw 0x2bc0, 0xc90c,	0x2bff, 0xc90c,		0x21, 0
	.dw 0x2c40, 0xc90c,	0x2c7f, 0xc90c,		0x21, 0
	.dw 0x2cc0, 0xc90c,	0x2cff, 0xc90c,		0x21, 0
	.dw 0x2d40, 0xc90c,	0x2d7f, 0xc90c,		0x21, 0
	.dw 0x2dc0, 0xc90c,	0x2dff, 0xc90c,		0x21, 0
	.dw 0x2e40, 0xc90c,	0x2e7f, 0xc90c,		0x21, 0
	.dw 0x2ec0, 0xc90c,	0x2eff, 0xc90c,		0x21, 0
	.dw 0x2f40, 0xc90c,	0x2f7f, 0xc90c,		0x21, 0
	.dw 0x2fc0, 0xc90c,	0x2fff, 0xc90c,		0x21, 0
	.dw 0x3040, 0xc90c,	0x307f, 0xc90c,		0x21, 0
	.dw 0x30c0, 0xc90c,	0x30ff, 0xc90c,		0x21, 0
	.dw 0x3140, 0xc90c,	0x317f, 0xc90c,		0x21, 0
	.dw 0x31c0, 0xc90c,	0x31ff, 0xc90c,		0x21, 0
	.dw 0x3240, 0xc90c,	0x327f, 0xc90c,		0x21, 0
	.dw 0x32c0, 0xc90c,	0x32ff, 0xc90c,		0x21, 0
	.dw 0x3340, 0xc90c,	0x337f, 0xc90c,		0x21, 0
	.dw 0x33c0, 0xc90c,	0x33ff, 0xc90c,		0x21, 0
	.dw 0x3440, 0xc90c,	0x347f, 0xc90c,		0x21, 0
	.dw 0x34c0, 0xc90c,	0x34ff, 0xc90c,		0x21, 0
	.dw 0x3540, 0xc90c,	0x357f, 0xc90c,		0x21, 0
	.dw 0x35c0, 0xc90c,	0x35ff, 0xc90c,		0x21, 0
	.dw 0x3640, 0xc90c,	0x367f, 0xc90c,		0x21, 0
	.dw 0x36c0, 0xc90c,	0x36ff, 0xc90c,		0x21, 0
	.dw 0x3740, 0xc90c,	0x377f, 0xc90c,		0x21, 0
	.dw 0x37c0, 0xc90c,	0x37ff, 0xc90c,		0x21, 0
	.dw 0x3840, 0xc90c,	0x387f, 0xc90c,		0x21, 0
	.dw 0x38c0, 0xc90c,	0x38ff, 0xc90c,		0x21, 0
	.dw 0x3940, 0xc90c,	0x397f, 0xc90c,		0x21, 0
	.dw 0x39c0, 0xc90c,	0x3fff, 0xc90c,		0x21, 0
	.dw 0x4040, 0xc90c,	0x407f, 0xc90c,		0x21, 0
	.dw 0x40c0, 0xc90c,	0x40ff, 0xc90c,		0x21, 0
	.dw 0x4140, 0xc90c,	0x417f, 0xc90c,		0x21, 0
	.dw 0x41c0, 0xc90c,	0x41ff, 0xc90c,		0x21, 0
	.dw 0x4240, 0xc90c,	0x427f, 0xc90c,		0x21, 0
	.dw 0x42c0, 0xc90c,	0x42ff, 0xc90c,		0x21, 0
	.dw 0x4340, 0xc90c,	0x437f, 0xc90c,		0x21, 0
	.dw 0x43c0, 0xc90c,	0x43ff, 0xc90c,		0x21, 0
	.dw 0x4440, 0xc90c,	0x447f, 0xc90c,		0x21, 0
	.dw 0x44c0, 0xc90c,	0x44ff, 0xc90c,		0x21, 0
	.dw 0x4540, 0xc90c,	0x457f, 0xc90c,		0x21, 0
	.dw 0x45c0, 0xc90c,	0x45ff, 0xc90c,		0x21, 0
	.dw 0x4640, 0xc90c,	0x467f, 0xc90c,		0x21, 0
	.dw 0x46c0, 0xc90c,	0x46ff, 0xc90c,		0x21, 0
	.dw 0x4740, 0xc90c,	0x477f, 0xc90c,		0x21, 0
	.dw 0x47c0, 0xc90c,	0x47ff, 0xc90c,		0x21, 0
	.dw 0x4840, 0xc90c,	0x487f, 0xc90c,		0x21, 0
	.dw 0x48c0, 0xc90c,	0x48ff, 0xc90c,		0x21, 0
	.dw 0x4940, 0xc90c,	0x497f, 0xc90c,		0x21, 0
	.dw 0x49c0, 0xc90c,	0x49ff, 0xc90c,		0x21, 0
	.dw 0x4a40, 0xc90c,	0x4a7f, 0xc90c,		0x21, 0
	.dw 0x4ac0, 0xc90c,	0x4aff, 0xc90c,		0x21, 0
	.dw 0x4b40, 0xc90c,	0x4b7f, 0xc90c,		0x21, 0
	.dw 0x4bc0, 0xc90c,	0x4bff, 0xc90c,		0x21, 0
	.dw 0x4c40, 0xc90c,	0x4c7f, 0xc90c,		0x21, 0
	.dw 0x4cc0, 0xc90c,	0x4cff, 0xc90c,		0x21, 0
	.dw 0x4d40, 0xc90c,	0x4d7f, 0xc90c,		0x21, 0
	.dw 0x4dc0, 0xc90c,	0x4dff, 0xc90c,		0x21, 0
	.dw 0x4e40, 0xc90c,	0x4e7f, 0xc90c,		0x21, 0
	.dw 0x4ec0, 0xc90c,	0x4eff, 0xc90c,		0x21, 0
	.dw 0x4f40, 0xc90c,	0x4f7f, 0xc90c,		0x21, 0
	.dw 0x4fc0, 0xc90c,	0x4fff, 0xc90c,		0x21, 0
	.dw 0x5040, 0xc90c,	0x507f, 0xc90c,		0x21, 0
	.dw 0x50c0, 0xc90c,	0x50ff, 0xc90c,		0x21, 0
	.dw 0x5140, 0xc90c,	0x517f, 0xc90c,		0x21, 0
	.dw 0x51c0, 0xc90c,	0x51ff, 0xc90c,		0x21, 0
	.dw 0x5240, 0xc90c,	0x527f, 0xc90c,		0x21, 0
	.dw 0x52c0, 0xc90c,	0x52ff, 0xc90c,		0x21, 0
	.dw 0x5340, 0xc90c,	0x537f, 0xc90c,		0x21, 0
	.dw 0x53c0, 0xc90c,	0x53ff, 0xc90c,		0x21, 0
	.dw 0x5440, 0xc90c,	0x547f, 0xc90c,		0x21, 0
	.dw 0x54c0, 0xc90c,	0x54ff, 0xc90c,		0x21, 0
	.dw 0x5540, 0xc90c,	0x557f, 0xc90c,		0x21, 0
	.dw 0x55c0, 0xc90c,	0x55ff, 0xc90c,		0x21, 0
	.dw 0x5640, 0xc90c,	0x567f, 0xc90c,		0x21, 0
	.dw 0x56c0, 0xc90c,	0x56ff, 0xc90c,		0x21, 0
	.dw 0x5740, 0xc90c,	0x577f, 0xc90c,		0x21, 0
	.dw 0x57c0, 0xc90c,	0x57ff, 0xc90c,		0x21, 0
	.dw 0x5840, 0xc90c,	0x587f, 0xc90c,		0x21, 0
	.dw 0x58c0, 0xc90c,	0x58ff, 0xc90c,		0x21, 0
	.dw 0x5940, 0xc90c,	0x597f, 0xc90c,		0x21, 0
	.dw 0x59c0, 0xc90c,	0x5fff, 0xc90c,		0x21, 0
	.dw 0x6040, 0xc90c,	0x607f, 0xc90c,		0x21, 0
	.dw 0x60c0, 0xc90c,	0x60ff, 0xc90c,		0x21, 0
	.dw 0x6140, 0xc90c,	0x617f, 0xc90c,		0x21, 0
	.dw 0x61c0, 0xc90c,	0x61ff, 0xc90c,		0x21, 0
	.dw 0x6240, 0xc90c,	0x627f, 0xc90c,		0x21, 0
	.dw 0x62c0, 0xc90c,	0x62ff, 0xc90c,		0x21, 0
	.dw 0x6340, 0xc90c,	0x637f, 0xc90c,		0x21, 0
	.dw 0x63c0, 0xc90c,	0x63ff, 0xc90c,		0x21, 0
	.dw 0x6440, 0xc90c,	0x647f, 0xc90c,		0x21, 0
	.dw 0x64c0, 0xc90c,	0x64ff, 0xc90c,		0x21, 0
	.dw 0x6540, 0xc90c,	0x657f, 0xc90c,		0x21, 0
	.dw 0x65c0, 0xc90c,	0x65ff, 0xc90c,		0x21, 0
	.dw 0x6640, 0xc90c,	0x667f, 0xc90c,		0x21, 0
	.dw 0x66c0, 0xc90c,	0x66ff, 0xc90c,		0x21, 0
	.dw 0x6740, 0xc90c,	0x677f, 0xc90c,		0x21, 0
	.dw 0x67c0, 0xc90c,	0x67ff, 0xc90c,		0x21, 0
	.dw 0x6840, 0xc90c,	0x687f, 0xc90c,		0x21, 0
	.dw 0x68c0, 0xc90c,	0x68ff, 0xc90c,		0x21, 0
	.dw 0x6940, 0xc90c,	0x697f, 0xc90c,		0x21, 0
	.dw 0x69c0, 0xc90c,	0x69ff, 0xc90c,		0x21, 0
	.dw 0x6a40, 0xc90c,	0x6a7f, 0xc90c,		0x21, 0
	.dw 0x6ac0, 0xc90c,	0x6aff, 0xc90c,		0x21, 0
	.dw 0x6b40, 0xc90c,	0x6b7f, 0xc90c,		0x21, 0
	.dw 0x6bc0, 0xc90c,	0x6bff, 0xc90c,		0x21, 0
	.dw 0x6c40, 0xc90c,	0x6c7f, 0xc90c,		0x21, 0
	.dw 0x6cc0, 0xc90c,	0x6cff, 0xc90c,		0x21, 0
	.dw 0x6d40, 0xc90c,	0x6d7f, 0xc90c,		0x21, 0
	.dw 0x6dc0, 0xc90c,	0x6dff, 0xc90c,		0x21, 0
	.dw 0x6e40, 0xc90c,	0x6e7f, 0xc90c,		0x21, 0
	.dw 0x6ec0, 0xc90c,	0x6eff, 0xc90c,		0x21, 0
	.dw 0x6f40, 0xc90c,	0x6f7f, 0xc90c,		0x21, 0
	.dw 0x6fc0, 0xc90c,	0x6fff, 0xc90c,		0x21, 0
	.dw 0x7040, 0xc90c,	0x707f, 0xc90c,		0x21, 0
	.dw 0x70c0, 0xc90c,	0x70ff, 0xc90c,		0x21, 0
	.dw 0x7140, 0xc90c,	0x717f, 0xc90c,		0x21, 0
	.dw 0x71c0, 0xc90c,	0x71ff, 0xc90c,		0x21, 0
	.dw 0x7240, 0xc90c,	0x727f, 0xc90c,		0x21, 0
	.dw 0x72c0, 0xc90c,	0x72ff, 0xc90c,		0x21, 0
	.dw 0x7340, 0xc90c,	0x737f, 0xc90c,		0x21, 0
	.dw 0x73c0, 0xc90c,	0x73ff, 0xc90c,		0x21, 0
	.dw 0x7440, 0xc90c,	0x747f, 0xc90c,		0x21, 0
	.dw 0x74c0, 0xc90c,	0x74ff, 0xc90c,		0x21, 0
	.dw 0x7540, 0xc90c,	0x757f, 0xc90c,		0x21, 0
	.dw 0x75c0, 0xc90c,	0x75ff, 0xc90c,		0x21, 0
	.dw 0x7640, 0xc90c,	0x767f, 0xc90c,		0x21, 0
	.dw 0x76c0, 0xc90c,	0x76ff, 0xc90c,		0x21, 0
	.dw 0x7740, 0xc90c,	0x777f, 0xc90c,		0x21, 0
	.dw 0x77c0, 0xc90c,	0x77ff, 0xc90c,		0x21, 0
	.dw 0x7840, 0xc90c,	0x787f, 0xc90c,		0x21, 0
	.dw 0x78c0, 0xc90c,	0x78ff, 0xc90c,		0x21, 0
	.dw 0x7940, 0xc90c,	0x797f, 0xc90c,		0x21, 0
	.dw 0x79c0, 0xc90c,	0x7fff, 0xc90c,		0x21, 0
	.dw 0x8040, 0xc90c,	0x807f, 0xc90c,		0x21, 0
	.dw 0x80c0, 0xc90c,	0x80ff, 0xc90c,		0x21, 0
	.dw 0x8140, 0xc90c,	0x817f, 0xc90c,		0x21, 0
	.dw 0x81c0, 0xc90c,	0x81ff, 0xc90c,		0x21, 0
	.dw 0x8240, 0xc90c,	0x827f, 0xc90c,		0x21, 0
	.dw 0x82c0, 0xc90c,	0x82ff, 0xc90c,		0x21, 0
	.dw 0x8340, 0xc90c,	0x837f, 0xc90c,		0x21, 0
	.dw 0x83c0, 0xc90c,	0x83ff, 0xc90c,		0x21, 0
	.dw 0x8440, 0xc90c,	0x847f, 0xc90c,		0x21, 0
	.dw 0x84c0, 0xc90c,	0x84ff, 0xc90c,		0x21, 0
	.dw 0x8540, 0xc90c,	0x857f, 0xc90c,		0x21, 0
	.dw 0x85c0, 0xc90c,	0x85ff, 0xc90c,		0x21, 0
	.dw 0x8640, 0xc90c,	0x867f, 0xc90c,		0x21, 0
	.dw 0x86c0, 0xc90c,	0x86ff, 0xc90c,		0x21, 0
	.dw 0x8740, 0xc90c,	0x877f, 0xc90c,		0x21, 0
	.dw 0x87c0, 0xc90c,	0x87ff, 0xc90c,		0x21, 0
	.dw 0x8840, 0xc90c,	0x887f, 0xc90c,		0x21, 0
	.dw 0x88c0, 0xc90c,	0x88ff, 0xc90c,		0x21, 0
	.dw 0x8940, 0xc90c,	0x897f, 0xc90c,		0x21, 0
	.dw 0x89c0, 0xc90c,	0x89ff, 0xc90c,		0x21, 0
	.dw 0x8a40, 0xc90c,	0x8a7f, 0xc90c,		0x21, 0
	.dw 0x8ac0, 0xc90c,	0x8aff, 0xc90c,		0x21, 0
	.dw 0x8b40, 0xc90c,	0x8b7f, 0xc90c,		0x21, 0
	.dw 0x8bc0, 0xc90c,	0x8bff, 0xc90c,		0x21, 0
	.dw 0x8c40, 0xc90c,	0x8c7f, 0xc90c,		0x21, 0
	.dw 0x8cc0, 0xc90c,	0x8cff, 0xc90c,		0x21, 0
	.dw 0x8d40, 0xc90c,	0x8d7f, 0xc90c,		0x21, 0
	.dw 0x8dc0, 0xc90c,	0x8dff, 0xc90c,		0x21, 0
	.dw 0x8e40, 0xc90c,	0x8e7f, 0xc90c,		0x21, 0
	.dw 0x8ec0, 0xc90c,	0x8eff, 0xc90c,		0x21, 0
	.dw 0x8f40, 0xc90c,	0x8f7f, 0xc90c,		0x21, 0
	.dw 0x8fc0, 0xc90c,	0x8fff, 0xc90c,		0x21, 0
	.dw 0x9040, 0xc90c,	0x907f, 0xc90c,		0x21, 0
	.dw 0x90c0, 0xc90c,	0x90ff, 0xc90c,		0x21, 0
	.dw 0x9140, 0xc90c,	0x917f, 0xc90c,		0x21, 0
	.dw 0x91c0, 0xc90c,	0x91ff, 0xc90c,		0x21, 0
	.dw 0x9240, 0xc90c,	0x927f, 0xc90c,		0x21, 0
	.dw 0x92c0, 0xc90c,	0x92ff, 0xc90c,		0x21, 0
	.dw 0x9340, 0xc90c,	0x937f, 0xc90c,		0x21, 0
	.dw 0x93c0, 0xc90c,	0x93ff, 0xc90c,		0x21, 0
	.dw 0x9440, 0xc90c,	0x947f, 0xc90c,		0x21, 0
	.dw 0x94c0, 0xc90c,	0x94ff, 0xc90c,		0x21, 0
	.dw 0x9540, 0xc90c,	0x957f, 0xc90c,		0x21, 0
	.dw 0x95c0, 0xc90c,	0x95ff, 0xc90c,		0x21, 0
	.dw 0x9640, 0xc90c,	0x967f, 0xc90c,		0x21, 0
	.dw 0x96c0, 0xc90c,	0x96ff, 0xc90c,		0x21, 0
	.dw 0x9740, 0xc90c,	0x977f, 0xc90c,		0x21, 0
	.dw 0x97c0, 0xc90c,	0x97ff, 0xc90c,		0x21, 0
	.dw 0x9840, 0xc90c,	0x987f, 0xc90c,		0x21, 0
	.dw 0x98c0, 0xc90c,	0x98ff, 0xc90c,		0x21, 0
	.dw 0x9940, 0xc90c,	0x997f, 0xc90c,		0x21, 0
	.dw 0x99c0, 0xc90c,	0x9fff, 0xc90c,		0x21, 0
	.dw 0xa040, 0xc90c,	0xa07f, 0xc90c,		0x21, 0
	.dw 0xa0c0, 0xc90c,	0xa0ff, 0xc90c,		0x21, 0
	.dw 0xa140, 0xc90c,	0xa17f, 0xc90c,		0x21, 0
	.dw 0xa1c0, 0xc90c,	0xa1ff, 0xc90c,		0x21, 0
	.dw 0xa240, 0xc90c,	0xa27f, 0xc90c,		0x21, 0
	.dw 0xa2c0, 0xc90c,	0xa2ff, 0xc90c,		0x21, 0
	.dw 0xa340, 0xc90c,	0xa37f, 0xc90c,		0x21, 0
	.dw 0xa3c0, 0xc90c,	0xa3ff, 0xc90c,		0x21, 0
	.dw 0xa440, 0xc90c,	0xa47f, 0xc90c,		0x21, 0
	.dw 0xa4c0, 0xc90c,	0xa4ff, 0xc90c,		0x21, 0
	.dw 0xa540, 0xc90c,	0xa57f, 0xc90c,		0x21, 0
	.dw 0xa5c0, 0xc90c,	0xa5ff, 0xc90c,		0x21, 0
	.dw 0xa640, 0xc90c,	0xa67f, 0xc90c,		0x21, 0
	.dw 0xa6c0, 0xc90c,	0xa6ff, 0xc90c,		0x21, 0
	.dw 0xa740, 0xc90c,	0xa77f, 0xc90c,		0x21, 0
	.dw 0xa7c0, 0xc90c,	0xa7ff, 0xc90c,		0x21, 0
	.dw 0xa840, 0xc90c,	0xa87f, 0xc90c,		0x21, 0
	.dw 0xa8c0, 0xc90c,	0xa8ff, 0xc90c,		0x21, 0
	.dw 0xa940, 0xc90c,	0xa97f, 0xc90c,		0x21, 0
	.dw 0xa9c0, 0xc90c,	0xa9ff, 0xc90c,		0x21, 0
	.dw 0xaa40, 0xc90c,	0xaa7f, 0xc90c,		0x21, 0
	.dw 0xaac0, 0xc90c,	0xaaff, 0xc90c,		0x21, 0
	.dw 0xab40, 0xc90c,	0xab7f, 0xc90c,		0x21, 0
	.dw 0xabc0, 0xc90c,	0xabff, 0xc90c,		0x21, 0
	.dw 0xac40, 0xc90c,	0xac7f, 0xc90c,		0x21, 0
	.dw 0xacc0, 0xc90c,	0xacff, 0xc90c,		0x21, 0
	.dw 0xad40, 0xc90c,	0xad7f, 0xc90c,		0x21, 0
	.dw 0xadc0, 0xc90c,	0xadff, 0xc90c,		0x21, 0
	.dw 0xae40, 0xc90c,	0xae7f, 0xc90c,		0x21, 0
	.dw 0xaec0, 0xc90c,	0xaeff, 0xc90c,		0x21, 0
	.dw 0xaf40, 0xc90c,	0xaf7f, 0xc90c,		0x21, 0
	.dw 0xafc0, 0xc90c,	0xafff, 0xc90c,		0x21, 0
	.dw 0xb040, 0xc90c,	0xb07f, 0xc90c,		0x21, 0
	.dw 0xb0c0, 0xc90c,	0xb0ff, 0xc90c,		0x21, 0
	.dw 0xb140, 0xc90c,	0xb17f, 0xc90c,		0x21, 0
	.dw 0xb1c0, 0xc90c,	0xb1ff, 0xc90c,		0x21, 0
	.dw 0xb240, 0xc90c,	0xb27f, 0xc90c,		0x21, 0
	.dw 0xb2c0, 0xc90c,	0xb2ff, 0xc90c,		0x21, 0
	.dw 0xb340, 0xc90c,	0xb37f, 0xc90c,		0x21, 0
	.dw 0xb3c0, 0xc90c,	0xb3ff, 0xc90c,		0x21, 0
	.dw 0xb440, 0xc90c,	0xb47f, 0xc90c,		0x21, 0
	.dw 0xb4c0, 0xc90c,	0xb4ff, 0xc90c,		0x21, 0
	.dw 0xb540, 0xc90c,	0xb57f, 0xc90c,		0x21, 0
	.dw 0xb5c0, 0xc90c,	0xb5ff, 0xc90c,		0x21, 0
	.dw 0xb640, 0xc90c,	0xb67f, 0xc90c,		0x21, 0
	.dw 0xb6c0, 0xc90c,	0xb6ff, 0xc90c,		0x21, 0
	.dw 0xb740, 0xc90c,	0xb77f, 0xc90c,		0x21, 0
	.dw 0xb7c0, 0xc90c,	0xb7ff, 0xc90c,		0x21, 0
	.dw 0xb840, 0xc90c,	0xb87f, 0xc90c,		0x21, 0
	.dw 0xb8c0, 0xc90c,	0xb8ff, 0xc90c,		0x21, 0
	.dw 0xb940, 0xc90c,	0xb97f, 0xc90c,		0x21, 0
	.dw 0xb9c0, 0xc90c,	0xbfff, 0xc90c,		0x21, 0
	.dw 0xc040, 0xc90c,	0xc07f, 0xc90c,		0x21, 0
	.dw 0xc0c0, 0xc90c,	0xc0ff, 0xc90c,		0x21, 0
	.dw 0xc140, 0xc90c,	0xc17f, 0xc90c,		0x21, 0
	.dw 0xc1c0, 0xc90c,	0xc1ff, 0xc90c,		0x21, 0
	.dw 0xc240, 0xc90c,	0xc27f, 0xc90c,		0x21, 0
	.dw 0xc2c0, 0xc90c,	0xc2ff, 0xc90c,		0x21, 0
	.dw 0xc340, 0xc90c,	0xc37f, 0xc90c,		0x21, 0
	.dw 0xc3c0, 0xc90c,	0xc3ff, 0xc90c,		0x21, 0
	.dw 0xc440, 0xc90c,	0xc47f, 0xc90c,		0x21, 0
	.dw 0xc4c0, 0xc90c,	0xc4ff, 0xc90c,		0x21, 0
	.dw 0xc540, 0xc90c,	0xc57f, 0xc90c,		0x21, 0
	.dw 0xc5c0, 0xc90c,	0xc5ff, 0xc90c,		0x21, 0
	.dw 0xc640, 0xc90c,	0xc67f, 0xc90c,		0x21, 0
	.dw 0xc6c0, 0xc90c,	0xc6ff, 0xc90c,		0x21, 0
	.dw 0xc740, 0xc90c,	0xc77f, 0xc90c,		0x21, 0
	.dw 0xc7c0, 0xc90c,	0xc7ff, 0xc90c,		0x21, 0
	.dw 0xc840, 0xc90c,	0xc87f, 0xc90c,		0x21, 0
	.dw 0xc8c0, 0xc90c,	0xc8ff, 0xc90c,		0x21, 0
	.dw 0xc940, 0xc90c,	0xc97f, 0xc90c,		0x21, 0
	.dw 0xc9c0, 0xc90c,	0xc9ff, 0xc90c,		0x21, 0
	.dw 0xca40, 0xc90c,	0xca7f, 0xc90c,		0x21, 0
	.dw 0xcac0, 0xc90c,	0xcaff, 0xc90c,		0x21, 0
	.dw 0xcb40, 0xc90c,	0xcb7f, 0xc90c,		0x21, 0
	.dw 0xcbc0, 0xc90c,	0xcbff, 0xc90c,		0x21, 0
	.dw 0xcc40, 0xc90c,	0xcc7f, 0xc90c,		0x21, 0
	.dw 0xccc0, 0xc90c,	0xccff, 0xc90c,		0x21, 0
	.dw 0xcd40, 0xc90c,	0xcd7f, 0xc90c,		0x21, 0
	.dw 0xcdc0, 0xc90c,	0xcdff, 0xc90c,		0x21, 0
	.dw 0xce40, 0xc90c,	0xce7f, 0xc90c,		0x21, 0
	.dw 0xcec0, 0xc90c,	0xceff, 0xc90c,		0x21, 0
	.dw 0xcf40, 0xc90c,	0xcf7f, 0xc90c,		0x21, 0
	.dw 0xcfc0, 0xc90c,	0xcfff, 0xc90c,		0x21, 0
	.dw 0xd040, 0xc90c,	0xd07f, 0xc90c,		0x21, 0
	.dw 0xd0c0, 0xc90c,	0xd0ff, 0xc90c,		0x21, 0
	.dw 0xd140, 0xc90c,	0xd17f, 0xc90c,		0x21, 0
	.dw 0xd1c0, 0xc90c,	0xd1ff, 0xc90c,		0x21, 0
	.dw 0xd240, 0xc90c,	0xd27f, 0xc90c,		0x21, 0
	.dw 0xd2c0, 0xc90c,	0xd2ff, 0xc90c,		0x21, 0
	.dw 0xd340, 0xc90c,	0xd37f, 0xc90c,		0x21, 0
	.dw 0xd3c0, 0xc90c,	0xd3ff, 0xc90c,		0x21, 0
	.dw 0xd440, 0xc90c,	0xd47f, 0xc90c,		0x21, 0
	.dw 0xd4c0, 0xc90c,	0xd4ff, 0xc90c,		0x21, 0
	.dw 0xd540, 0xc90c,	0xd57f, 0xc90c,		0x21, 0
	.dw 0xd5c0, 0xc90c,	0xd5ff, 0xc90c,		0x21, 0
	.dw 0xd640, 0xc90c,	0xd67f, 0xc90c,		0x21, 0
	.dw 0xd6c0, 0xc90c,	0xd6ff, 0xc90c,		0x21, 0
	.dw 0xd740, 0xc90c,	0xd77f, 0xc90c,		0x21, 0
	.dw 0xd7c0, 0xc90c,	0xd7ff, 0xc90c,		0x21, 0
	.dw 0xd840, 0xc90c,	0xd87f, 0xc90c,		0x21, 0
	.dw 0xd8c0, 0xc90c,	0xd8ff, 0xc90c,		0x21, 0
	.dw 0xd940, 0xc90c,	0xd97f, 0xc90c,		0x21, 0
	.dw 0xd9c0, 0xc90c,	0xdfff, 0xc90c,		0x21, 0
	.dw 0xe040, 0xc90c,	0xe07f, 0xc90c,		0x21, 0
	.dw 0xe0c0, 0xc90c,	0xe0ff, 0xc90c,		0x21, 0
	.dw 0xe140, 0xc90c,	0xe17f, 0xc90c,		0x21, 0
	.dw 0xe1c0, 0xc90c,	0xe1ff, 0xc90c,		0x21, 0
	.dw 0xe240, 0xc90c,	0xe27f, 0xc90c,		0x21, 0
	.dw 0xe2c0, 0xc90c,	0xe2ff, 0xc90c,		0x21, 0
	.dw 0xe340, 0xc90c,	0xe37f, 0xc90c,		0x21, 0
	.dw 0xe3c0, 0xc90c,	0xe3ff, 0xc90c,		0x21, 0
	.dw 0xe440, 0xc90c,	0xe47f, 0xc90c,		0x21, 0
	.dw 0xe4c0, 0xc90c,	0xe4ff, 0xc90c,		0x21, 0
	.dw 0xe540, 0xc90c,	0xe57f, 0xc90c,		0x21, 0
	.dw 0xe5c0, 0xc90c,	0xe5ff, 0xc90c,		0x21, 0
	.dw 0xe640, 0xc90c,	0xe67f, 0xc90c,		0x21, 0
	.dw 0xe6c0, 0xc90c,	0xe6ff, 0xc90c,		0x21, 0
	.dw 0xe740, 0xc90c,	0xe77f, 0xc90c,		0x21, 0
	.dw 0xe7c0, 0xc90c,	0xe7ff, 0xc90c,		0x21, 0
	.dw 0xe840, 0xc90c,	0xe87f, 0xc90c,		0x21, 0
	.dw 0xe8c0, 0xc90c,	0xe8ff, 0xc90c,		0x21, 0
	.dw 0xe940, 0xc90c,	0xe97f, 0xc90c,		0x21, 0
	.dw 0xe9c0, 0xc90c,	0xe9ff, 0xc90c,		0x21, 0
	.dw 0xea40, 0xc90c,	0xea7f, 0xc90c,		0x21, 0
	.dw 0xeac0, 0xc90c,	0xeaff, 0xc90c,		0x21, 0
	.dw 0xeb40, 0xc90c,	0xeb7f, 0xc90c,		0x21, 0
	.dw 0xebc0, 0xc90c,	0xebff, 0xc90c,		0x21, 0
	.dw 0xec40, 0xc90c,	0xec7f, 0xc90c,		0x21, 0
	.dw 0xecc0, 0xc90c,	0xecff, 0xc90c,		0x21, 0
	.dw 0xed40, 0xc90c,	0xed7f, 0xc90c,		0x21, 0
	.dw 0xedc0, 0xc90c,	0xedff, 0xc90c,		0x21, 0
	.dw 0xee40, 0xc90c,	0xee7f, 0xc90c,		0x21, 0
	.dw 0xeec0, 0xc90c,	0xeeff, 0xc90c,		0x21, 0
	.dw 0xef40, 0xc90c,	0xef7f, 0xc90c,		0x21, 0
	.dw 0xefc0, 0xc90c,	0xefff, 0xc90c,		0x21, 0
	.dw 0xf040, 0xc90c,	0xf07f, 0xc90c,		0x21, 0
	.dw 0xf0c0, 0xc90c,	0xf0ff, 0xc90c,		0x21, 0
	.dw 0xf140, 0xc90c,	0xf17f, 0xc90c,		0x21, 0
	.dw 0xf1c0, 0xc90c,	0xf1ff, 0xc90c,		0x21, 0
	.dw 0xf240, 0xc90c,	0xf27f, 0xc90c,		0x21, 0
	.dw 0xf2c0, 0xc90c,	0xf2ff, 0xc90c,		0x21, 0
	.dw 0xf340, 0xc90c,	0xf37f, 0xc90c,		0x21, 0
	.dw 0xf3c0, 0xc90c,	0xf3ff, 0xc90c,		0x21, 0
	.dw 0xf440, 0xc90c,	0xf47f, 0xc90c,		0x21, 0
	.dw 0xf4c0, 0xc90c,	0xf4ff, 0xc90c,		0x21, 0
	.dw 0xf540, 0xc90c,	0xf57f, 0xc90c,		0x21, 0
	.dw 0xf5c0, 0xc90c,	0xf5ff, 0xc90c,		0x21, 0
	.dw 0xf640, 0xc90c,	0xf67f, 0xc90c,		0x21, 0
	.dw 0xf6c0, 0xc90c,	0xf6ff, 0xc90c,		0x21, 0
	.dw 0xf740, 0xc90c,	0xf77f, 0xc90c,		0x21, 0
	.dw 0xf7c0, 0xc90c,	0xf7ff, 0xc90c,		0x21, 0
	.dw 0xf840, 0xc90c,	0xf87f, 0xc90c,		0x21, 0
	.dw 0xf8c0, 0xc90c,	0xf8ff, 0xc90c,		0x21, 0
	.dw 0xf940, 0xc90c,	0xf97f, 0xc90c,		0x21, 0
	.dw 0xf9c0, 0xc90c,	0xffff, 0xc90c,		0x21, 0
	.dw 0x0040, 0xc90d,	0x007f, 0xc90d,		0x21, 0
	.dw 0x00c0, 0xc90d,	0x00ff, 0xc90d,		0x21, 0
	.dw 0x0140, 0xc90d,	0x017f, 0xc90d,		0x21, 0
	.dw 0x01c0, 0xc90d,	0x01ff, 0xc90d,		0x21, 0
	.dw 0x0240, 0xc90d,	0x027f, 0xc90d,		0x21, 0
	.dw 0x02c0, 0xc90d,	0x02ff, 0xc90d,		0x21, 0
	.dw 0x0340, 0xc90d,	0x037f, 0xc90d,		0x21, 0
	.dw 0x03c0, 0xc90d,	0x03ff, 0xc90d,		0x21, 0
	.dw 0x0440, 0xc90d,	0x047f, 0xc90d,		0x21, 0
	.dw 0x04c0, 0xc90d,	0x04ff, 0xc90d,		0x21, 0
	.dw 0x0540, 0xc90d,	0x057f, 0xc90d,		0x21, 0
	.dw 0x05c0, 0xc90d,	0x05ff, 0xc90d,		0x21, 0
	.dw 0x0640, 0xc90d,	0x067f, 0xc90d,		0x21, 0
	.dw 0x06c0, 0xc90d,	0x06ff, 0xc90d,		0x21, 0
	.dw 0x0740, 0xc90d,	0x077f, 0xc90d,		0x21, 0
	.dw 0x07c0, 0xc90d,	0x07ff, 0xc90d,		0x21, 0
	.dw 0x0840, 0xc90d,	0x087f, 0xc90d,		0x21, 0
	.dw 0x08c0, 0xc90d,	0x08ff, 0xc90d,		0x21, 0
	.dw 0x0940, 0xc90d,	0x097f, 0xc90d,		0x21, 0
	.dw 0x09c0, 0xc90d,	0x09ff, 0xc90d,		0x21, 0
	.dw 0x0a40, 0xc90d,	0x0a7f, 0xc90d,		0x21, 0
	.dw 0x0ac0, 0xc90d,	0x0aff, 0xc90d,		0x21, 0
	.dw 0x0b40, 0xc90d,	0x0b7f, 0xc90d,		0x21, 0
	.dw 0x0bc0, 0xc90d,	0x0bff, 0xc90d,		0x21, 0
	.dw 0x0c40, 0xc90d,	0x0c7f, 0xc90d,		0x21, 0
	.dw 0x0cc0, 0xc90d,	0x0cff, 0xc90d,		0x21, 0
	.dw 0x0d40, 0xc90d,	0x0d7f, 0xc90d,		0x21, 0
	.dw 0x0dc0, 0xc90d,	0x0dff, 0xc90d,		0x21, 0
	.dw 0x0e40, 0xc90d,	0x0e7f, 0xc90d,		0x21, 0
	.dw 0x0ec0, 0xc90d,	0x0eff, 0xc90d,		0x21, 0
	.dw 0x0f40, 0xc90d,	0x0f7f, 0xc90d,		0x21, 0
	.dw 0x0fc0, 0xc90d,	0x0fff, 0xc90d,		0x21, 0
	.dw 0x1040, 0xc90d,	0x107f, 0xc90d,		0x21, 0
	.dw 0x10c0, 0xc90d,	0x10ff, 0xc90d,		0x21, 0
	.dw 0x1140, 0xc90d,	0x117f, 0xc90d,		0x21, 0
	.dw 0x11c0, 0xc90d,	0x11ff, 0xc90d,		0x21, 0
	.dw 0x1240, 0xc90d,	0x127f, 0xc90d,		0x21, 0
	.dw 0x12c0, 0xc90d,	0x12ff, 0xc90d,		0x21, 0
	.dw 0x1340, 0xc90d,	0x137f, 0xc90d,		0x21, 0
	.dw 0x13c0, 0xc90d,	0x13ff, 0xc90d,		0x21, 0
	.dw 0x1440, 0xc90d,	0x147f, 0xc90d,		0x21, 0
	.dw 0x14c0, 0xc90d,	0x14ff, 0xc90d,		0x21, 0
	.dw 0x1540, 0xc90d,	0x157f, 0xc90d,		0x21, 0
	.dw 0x15c0, 0xc90d,	0x15ff, 0xc90d,		0x21, 0
	.dw 0x1640, 0xc90d,	0x167f, 0xc90d,		0x21, 0
	.dw 0x16c0, 0xc90d,	0x16ff, 0xc90d,		0x21, 0
	.dw 0x1740, 0xc90d,	0x177f, 0xc90d,		0x21, 0
	.dw 0x17c0, 0xc90d,	0x17ff, 0xc90d,		0x21, 0
	.dw 0x1840, 0xc90d,	0x187f, 0xc90d,		0x21, 0
	.dw 0x18c0, 0xc90d,	0x18ff, 0xc90d,		0x21, 0
	.dw 0x1940, 0xc90d,	0x197f, 0xc90d,		0x21, 0
	.dw 0x19c0, 0xc90d,	0x1fff, 0xc90d,		0x21, 0
	.dw 0x2040, 0xc90d,	0x207f, 0xc90d,		0x21, 0
	.dw 0x20c0, 0xc90d,	0x20ff, 0xc90d,		0x21, 0
	.dw 0x2140, 0xc90d,	0x217f, 0xc90d,		0x21, 0
	.dw 0x21c0, 0xc90d,	0x21ff, 0xc90d,		0x21, 0
	.dw 0x2240, 0xc90d,	0x227f, 0xc90d,		0x21, 0
	.dw 0x22c0, 0xc90d,	0x22ff, 0xc90d,		0x21, 0
	.dw 0x2340, 0xc90d,	0x237f, 0xc90d,		0x21, 0
	.dw 0x23c0, 0xc90d,	0x23ff, 0xc90d,		0x21, 0
	.dw 0x2440, 0xc90d,	0x247f, 0xc90d,		0x21, 0
	.dw 0x24c0, 0xc90d,	0x24ff, 0xc90d,		0x21, 0
	.dw 0x2540, 0xc90d,	0x257f, 0xc90d,		0x21, 0
	.dw 0x25c0, 0xc90d,	0x25ff, 0xc90d,		0x21, 0
	.dw 0x2640, 0xc90d,	0x267f, 0xc90d,		0x21, 0
	.dw 0x26c0, 0xc90d,	0x26ff, 0xc90d,		0x21, 0
	.dw 0x2740, 0xc90d,	0x277f, 0xc90d,		0x21, 0
	.dw 0x27c0, 0xc90d,	0x27ff, 0xc90d,		0x21, 0
	.dw 0x2840, 0xc90d,	0x287f, 0xc90d,		0x21, 0
	.dw 0x28c0, 0xc90d,	0x28ff, 0xc90d,		0x21, 0
	.dw 0x2940, 0xc90d,	0x297f, 0xc90d,		0x21, 0
	.dw 0x29c0, 0xc90d,	0x29ff, 0xc90d,		0x21, 0
	.dw 0x2a40, 0xc90d,	0x2a7f, 0xc90d,		0x21, 0
	.dw 0x2ac0, 0xc90d,	0x2aff, 0xc90d,		0x21, 0
	.dw 0x2b40, 0xc90d,	0x2b7f, 0xc90d,		0x21, 0
	.dw 0x2bc0, 0xc90d,	0x2bff, 0xc90d,		0x21, 0
	.dw 0x2c40, 0xc90d,	0x2c7f, 0xc90d,		0x21, 0
	.dw 0x2cc0, 0xc90d,	0x2cff, 0xc90d,		0x21, 0
	.dw 0x2d40, 0xc90d,	0x2d7f, 0xc90d,		0x21, 0
	.dw 0x2dc0, 0xc90d,	0x2dff, 0xc90d,		0x21, 0
	.dw 0x2e40, 0xc90d,	0x2e7f, 0xc90d,		0x21, 0
	.dw 0x2ec0, 0xc90d,	0x2eff, 0xc90d,		0x21, 0
	.dw 0x2f40, 0xc90d,	0x2f7f, 0xc90d,		0x21, 0
	.dw 0x2fc0, 0xc90d,	0x2fff, 0xc90d,		0x21, 0
	.dw 0x3040, 0xc90d,	0x307f, 0xc90d,		0x21, 0
	.dw 0x30c0, 0xc90d,	0x30ff, 0xc90d,		0x21, 0
	.dw 0x3140, 0xc90d,	0x317f, 0xc90d,		0x21, 0
	.dw 0x31c0, 0xc90d,	0x31ff, 0xc90d,		0x21, 0
	.dw 0x3240, 0xc90d,	0x327f, 0xc90d,		0x21, 0
	.dw 0x32c0, 0xc90d,	0x32ff, 0xc90d,		0x21, 0
	.dw 0x3340, 0xc90d,	0x337f, 0xc90d,		0x21, 0
	.dw 0x33c0, 0xc90d,	0x33ff, 0xc90d,		0x21, 0
	.dw 0x3440, 0xc90d,	0x347f, 0xc90d,		0x21, 0
	.dw 0x34c0, 0xc90d,	0x34ff, 0xc90d,		0x21, 0
	.dw 0x3540, 0xc90d,	0x357f, 0xc90d,		0x21, 0
	.dw 0x35c0, 0xc90d,	0x35ff, 0xc90d,		0x21, 0
	.dw 0x3640, 0xc90d,	0x367f, 0xc90d,		0x21, 0
	.dw 0x36c0, 0xc90d,	0x36ff, 0xc90d,		0x21, 0
	.dw 0x3740, 0xc90d,	0x377f, 0xc90d,		0x21, 0
	.dw 0x37c0, 0xc90d,	0x37ff, 0xc90d,		0x21, 0
	.dw 0x3840, 0xc90d,	0x387f, 0xc90d,		0x21, 0
	.dw 0x38c0, 0xc90d,	0x38ff, 0xc90d,		0x21, 0
	.dw 0x3940, 0xc90d,	0x397f, 0xc90d,		0x21, 0
	.dw 0x39c0, 0xc90d,	0x3fff, 0xc90d,		0x21, 0
	.dw 0x4040, 0xc90d,	0x407f, 0xc90d,		0x21, 0
	.dw 0x40c0, 0xc90d,	0x40ff, 0xc90d,		0x21, 0
	.dw 0x4140, 0xc90d,	0x417f, 0xc90d,		0x21, 0
	.dw 0x41c0, 0xc90d,	0x41ff, 0xc90d,		0x21, 0
	.dw 0x4240, 0xc90d,	0x427f, 0xc90d,		0x21, 0
	.dw 0x42c0, 0xc90d,	0x42ff, 0xc90d,		0x21, 0
	.dw 0x4340, 0xc90d,	0x437f, 0xc90d,		0x21, 0
	.dw 0x43c0, 0xc90d,	0x43ff, 0xc90d,		0x21, 0
	.dw 0x4440, 0xc90d,	0x447f, 0xc90d,		0x21, 0
	.dw 0x44c0, 0xc90d,	0x44ff, 0xc90d,		0x21, 0
	.dw 0x4540, 0xc90d,	0x457f, 0xc90d,		0x21, 0
	.dw 0x45c0, 0xc90d,	0x45ff, 0xc90d,		0x21, 0
	.dw 0x4640, 0xc90d,	0x467f, 0xc90d,		0x21, 0
	.dw 0x46c0, 0xc90d,	0x46ff, 0xc90d,		0x21, 0
	.dw 0x4740, 0xc90d,	0x477f, 0xc90d,		0x21, 0
	.dw 0x47c0, 0xc90d,	0x47ff, 0xc90d,		0x21, 0
	.dw 0x4840, 0xc90d,	0x487f, 0xc90d,		0x21, 0
	.dw 0x48c0, 0xc90d,	0x48ff, 0xc90d,		0x21, 0
	.dw 0x4940, 0xc90d,	0x497f, 0xc90d,		0x21, 0
	.dw 0x49c0, 0xc90d,	0x49ff, 0xc90d,		0x21, 0
	.dw 0x4a40, 0xc90d,	0x4a7f, 0xc90d,		0x21, 0
	.dw 0x4ac0, 0xc90d,	0x4aff, 0xc90d,		0x21, 0
	.dw 0x4b40, 0xc90d,	0x4b7f, 0xc90d,		0x21, 0
	.dw 0x4bc0, 0xc90d,	0x4bff, 0xc90d,		0x21, 0
	.dw 0x4c40, 0xc90d,	0x4c7f, 0xc90d,		0x21, 0
	.dw 0x4cc0, 0xc90d,	0x4cff, 0xc90d,		0x21, 0
	.dw 0x4d40, 0xc90d,	0x4d7f, 0xc90d,		0x21, 0
	.dw 0x4dc0, 0xc90d,	0x4dff, 0xc90d,		0x21, 0
	.dw 0x4e40, 0xc90d,	0x4e7f, 0xc90d,		0x21, 0
	.dw 0x4ec0, 0xc90d,	0x4eff, 0xc90d,		0x21, 0
	.dw 0x4f40, 0xc90d,	0x4f7f, 0xc90d,		0x21, 0
	.dw 0x4fc0, 0xc90d,	0x4fff, 0xc90d,		0x21, 0
	.dw 0x5040, 0xc90d,	0x507f, 0xc90d,		0x21, 0
	.dw 0x50c0, 0xc90d,	0x50ff, 0xc90d,		0x21, 0
	.dw 0x5140, 0xc90d,	0x517f, 0xc90d,		0x21, 0
	.dw 0x51c0, 0xc90d,	0x51ff, 0xc90d,		0x21, 0
	.dw 0x5240, 0xc90d,	0x527f, 0xc90d,		0x21, 0
	.dw 0x52c0, 0xc90d,	0x52ff, 0xc90d,		0x21, 0
	.dw 0x5340, 0xc90d,	0x537f, 0xc90d,		0x21, 0
	.dw 0x53c0, 0xc90d,	0x53ff, 0xc90d,		0x21, 0
	.dw 0x5440, 0xc90d,	0x547f, 0xc90d,		0x21, 0
	.dw 0x54c0, 0xc90d,	0x54ff, 0xc90d,		0x21, 0
	.dw 0x5540, 0xc90d,	0x557f, 0xc90d,		0x21, 0
	.dw 0x55c0, 0xc90d,	0x55ff, 0xc90d,		0x21, 0
	.dw 0x5640, 0xc90d,	0x567f, 0xc90d,		0x21, 0
	.dw 0x56c0, 0xc90d,	0x56ff, 0xc90d,		0x21, 0
	.dw 0x5740, 0xc90d,	0x577f, 0xc90d,		0x21, 0
	.dw 0x57c0, 0xc90d,	0x57ff, 0xc90d,		0x21, 0
	.dw 0x5840, 0xc90d,	0x587f, 0xc90d,		0x21, 0
	.dw 0x58c0, 0xc90d,	0x58ff, 0xc90d,		0x21, 0
	.dw 0x5940, 0xc90d,	0x597f, 0xc90d,		0x21, 0
	.dw 0x59c0, 0xc90d,	0x5fff, 0xc90d,		0x21, 0
	.dw 0x6040, 0xc90d,	0x607f, 0xc90d,		0x21, 0
	.dw 0x60c0, 0xc90d,	0x60ff, 0xc90d,		0x21, 0
	.dw 0x6140, 0xc90d,	0x617f, 0xc90d,		0x21, 0
	.dw 0x61c0, 0xc90d,	0x61ff, 0xc90d,		0x21, 0
	.dw 0x6240, 0xc90d,	0x627f, 0xc90d,		0x21, 0
	.dw 0x62c0, 0xc90d,	0x62ff, 0xc90d,		0x21, 0
	.dw 0x6340, 0xc90d,	0x637f, 0xc90d,		0x21, 0
	.dw 0x63c0, 0xc90d,	0x63ff, 0xc90d,		0x21, 0
	.dw 0x6440, 0xc90d,	0x647f, 0xc90d,		0x21, 0
	.dw 0x64c0, 0xc90d,	0x64ff, 0xc90d,		0x21, 0
	.dw 0x6540, 0xc90d,	0x657f, 0xc90d,		0x21, 0
	.dw 0x65c0, 0xc90d,	0x65ff, 0xc90d,		0x21, 0
	.dw 0x6640, 0xc90d,	0x667f, 0xc90d,		0x21, 0
	.dw 0x66c0, 0xc90d,	0x66ff, 0xc90d,		0x21, 0
	.dw 0x6740, 0xc90d,	0x677f, 0xc90d,		0x21, 0
	.dw 0x67c0, 0xc90d,	0x67ff, 0xc90d,		0x21, 0
	.dw 0x6840, 0xc90d,	0x687f, 0xc90d,		0x21, 0
	.dw 0x68c0, 0xc90d,	0x68ff, 0xc90d,		0x21, 0
	.dw 0x6940, 0xc90d,	0x697f, 0xc90d,		0x21, 0
	.dw 0x69c0, 0xc90d,	0x69ff, 0xc90d,		0x21, 0
	.dw 0x6a40, 0xc90d,	0x6a7f, 0xc90d,		0x21, 0
	.dw 0x6ac0, 0xc90d,	0x6aff, 0xc90d,		0x21, 0
	.dw 0x6b40, 0xc90d,	0x6b7f, 0xc90d,		0x21, 0
	.dw 0x6bc0, 0xc90d,	0x6bff, 0xc90d,		0x21, 0
	.dw 0x6c40, 0xc90d,	0x6c7f, 0xc90d,		0x21, 0
	.dw 0x6cc0, 0xc90d,	0x6cff, 0xc90d,		0x21, 0
	.dw 0x6d40, 0xc90d,	0x6d7f, 0xc90d,		0x21, 0
	.dw 0x6dc0, 0xc90d,	0x6dff, 0xc90d,		0x21, 0
	.dw 0x6e40, 0xc90d,	0x6e7f, 0xc90d,		0x21, 0
	.dw 0x6ec0, 0xc90d,	0x6eff, 0xc90d,		0x21, 0
	.dw 0x6f40, 0xc90d,	0x6f7f, 0xc90d,		0x21, 0
	.dw 0x6fc0, 0xc90d,	0x6fff, 0xc90d,		0x21, 0
	.dw 0x7040, 0xc90d,	0x707f, 0xc90d,		0x21, 0
	.dw 0x70c0, 0xc90d,	0x70ff, 0xc90d,		0x21, 0
	.dw 0x7140, 0xc90d,	0x717f, 0xc90d,		0x21, 0
	.dw 0x71c0, 0xc90d,	0x71ff, 0xc90d,		0x21, 0
	.dw 0x7240, 0xc90d,	0x727f, 0xc90d,		0x21, 0
	.dw 0x72c0, 0xc90d,	0x72ff, 0xc90d,		0x21, 0
	.dw 0x7340, 0xc90d,	0x737f, 0xc90d,		0x21, 0
	.dw 0x73c0, 0xc90d,	0x73ff, 0xc90d,		0x21, 0
	.dw 0x7440, 0xc90d,	0x747f, 0xc90d,		0x21, 0
	.dw 0x74c0, 0xc90d,	0x74ff, 0xc90d,		0x21, 0
	.dw 0x7540, 0xc90d,	0x757f, 0xc90d,		0x21, 0
	.dw 0x75c0, 0xc90d,	0x75ff, 0xc90d,		0x21, 0
	.dw 0x7640, 0xc90d,	0x767f, 0xc90d,		0x21, 0
	.dw 0x76c0, 0xc90d,	0x76ff, 0xc90d,		0x21, 0
	.dw 0x7740, 0xc90d,	0x777f, 0xc90d,		0x21, 0
	.dw 0x77c0, 0xc90d,	0x77ff, 0xc90d,		0x21, 0
	.dw 0x7840, 0xc90d,	0x787f, 0xc90d,		0x21, 0
	.dw 0x78c0, 0xc90d,	0x78ff, 0xc90d,		0x21, 0
	.dw 0x7940, 0xc90d,	0x797f, 0xc90d,		0x21, 0
	.dw 0x79c0, 0xc90d,	0x7fff, 0xc90d,		0x21, 0
	.dw 0x8040, 0xc90d,	0x807f, 0xc90d,		0x21, 0
	.dw 0x80c0, 0xc90d,	0x80ff, 0xc90d,		0x21, 0
	.dw 0x8140, 0xc90d,	0x817f, 0xc90d,		0x21, 0
	.dw 0x81c0, 0xc90d,	0x81ff, 0xc90d,		0x21, 0
	.dw 0x8240, 0xc90d,	0x827f, 0xc90d,		0x21, 0
	.dw 0x82c0, 0xc90d,	0x82ff, 0xc90d,		0x21, 0
	.dw 0x8340, 0xc90d,	0x837f, 0xc90d,		0x21, 0
	.dw 0x83c0, 0xc90d,	0x83ff, 0xc90d,		0x21, 0
	.dw 0x8440, 0xc90d,	0x847f, 0xc90d,		0x21, 0
	.dw 0x84c0, 0xc90d,	0x84ff, 0xc90d,		0x21, 0
	.dw 0x8540, 0xc90d,	0x857f, 0xc90d,		0x21, 0
	.dw 0x85c0, 0xc90d,	0x85ff, 0xc90d,		0x21, 0
	.dw 0x8640, 0xc90d,	0x867f, 0xc90d,		0x21, 0
	.dw 0x86c0, 0xc90d,	0x86ff, 0xc90d,		0x21, 0
	.dw 0x8740, 0xc90d,	0x877f, 0xc90d,		0x21, 0
	.dw 0x87c0, 0xc90d,	0x87ff, 0xc90d,		0x21, 0
	.dw 0x8840, 0xc90d,	0x887f, 0xc90d,		0x21, 0
	.dw 0x88c0, 0xc90d,	0x88ff, 0xc90d,		0x21, 0
	.dw 0x8940, 0xc90d,	0x897f, 0xc90d,		0x21, 0
	.dw 0x89c0, 0xc90d,	0x89ff, 0xc90d,		0x21, 0
	.dw 0x8a40, 0xc90d,	0x8a7f, 0xc90d,		0x21, 0
	.dw 0x8ac0, 0xc90d,	0x8aff, 0xc90d,		0x21, 0
	.dw 0x8b40, 0xc90d,	0x8b7f, 0xc90d,		0x21, 0
	.dw 0x8bc0, 0xc90d,	0x8bff, 0xc90d,		0x21, 0
	.dw 0x8c40, 0xc90d,	0x8c7f, 0xc90d,		0x21, 0
	.dw 0x8cc0, 0xc90d,	0x8cff, 0xc90d,		0x21, 0
	.dw 0x8d40, 0xc90d,	0x8d7f, 0xc90d,		0x21, 0
	.dw 0x8dc0, 0xc90d,	0x8dff, 0xc90d,		0x21, 0
	.dw 0x8e40, 0xc90d,	0x8e7f, 0xc90d,		0x21, 0
	.dw 0x8ec0, 0xc90d,	0x8eff, 0xc90d,		0x21, 0
	.dw 0x8f40, 0xc90d,	0x8f7f, 0xc90d,		0x21, 0
	.dw 0x8fc0, 0xc90d,	0x8fff, 0xc90d,		0x21, 0
	.dw 0x9040, 0xc90d,	0x907f, 0xc90d,		0x21, 0
	.dw 0x90c0, 0xc90d,	0x90ff, 0xc90d,		0x21, 0
	.dw 0x9140, 0xc90d,	0x917f, 0xc90d,		0x21, 0
	.dw 0x91c0, 0xc90d,	0x91ff, 0xc90d,		0x21, 0
	.dw 0x9240, 0xc90d,	0x927f, 0xc90d,		0x21, 0
	.dw 0x92c0, 0xc90d,	0x92ff, 0xc90d,		0x21, 0
	.dw 0x9340, 0xc90d,	0x937f, 0xc90d,		0x21, 0
	.dw 0x93c0, 0xc90d,	0x93ff, 0xc90d,		0x21, 0
	.dw 0x9440, 0xc90d,	0x947f, 0xc90d,		0x21, 0
	.dw 0x94c0, 0xc90d,	0x94ff, 0xc90d,		0x21, 0
	.dw 0x9540, 0xc90d,	0x957f, 0xc90d,		0x21, 0
	.dw 0x95c0, 0xc90d,	0x95ff, 0xc90d,		0x21, 0
	.dw 0x9640, 0xc90d,	0x967f, 0xc90d,		0x21, 0
	.dw 0x96c0, 0xc90d,	0x96ff, 0xc90d,		0x21, 0
	.dw 0x9740, 0xc90d,	0x977f, 0xc90d,		0x21, 0
	.dw 0x97c0, 0xc90d,	0x97ff, 0xc90d,		0x21, 0
	.dw 0x9840, 0xc90d,	0x987f, 0xc90d,		0x21, 0
	.dw 0x98c0, 0xc90d,	0x98ff, 0xc90d,		0x21, 0
	.dw 0x9940, 0xc90d,	0x997f, 0xc90d,		0x21, 0
	.dw 0x99c0, 0xc90d,	0x9fff, 0xc90d,		0x21, 0
	.dw 0xa040, 0xc90d,	0xa07f, 0xc90d,		0x21, 0
	.dw 0xa0c0, 0xc90d,	0xa0ff, 0xc90d,		0x21, 0
	.dw 0xa140, 0xc90d,	0xa17f, 0xc90d,		0x21, 0
	.dw 0xa1c0, 0xc90d,	0xa1ff, 0xc90d,		0x21, 0
	.dw 0xa240, 0xc90d,	0xa27f, 0xc90d,		0x21, 0
	.dw 0xa2c0, 0xc90d,	0xa2ff, 0xc90d,		0x21, 0
	.dw 0xa340, 0xc90d,	0xa37f, 0xc90d,		0x21, 0
	.dw 0xa3c0, 0xc90d,	0xa3ff, 0xc90d,		0x21, 0
	.dw 0xa440, 0xc90d,	0xa47f, 0xc90d,		0x21, 0
	.dw 0xa4c0, 0xc90d,	0xa4ff, 0xc90d,		0x21, 0
	.dw 0xa540, 0xc90d,	0xa57f, 0xc90d,		0x21, 0
	.dw 0xa5c0, 0xc90d,	0xa5ff, 0xc90d,		0x21, 0
	.dw 0xa640, 0xc90d,	0xa67f, 0xc90d,		0x21, 0
	.dw 0xa6c0, 0xc90d,	0xa6ff, 0xc90d,		0x21, 0
	.dw 0xa740, 0xc90d,	0xa77f, 0xc90d,		0x21, 0
	.dw 0xa7c0, 0xc90d,	0xa7ff, 0xc90d,		0x21, 0
	.dw 0xa840, 0xc90d,	0xa87f, 0xc90d,		0x21, 0
	.dw 0xa8c0, 0xc90d,	0xa8ff, 0xc90d,		0x21, 0
	.dw 0xa940, 0xc90d,	0xa97f, 0xc90d,		0x21, 0
	.dw 0xa9c0, 0xc90d,	0xa9ff, 0xc90d,		0x21, 0
	.dw 0xaa40, 0xc90d,	0xaa7f, 0xc90d,		0x21, 0
	.dw 0xaac0, 0xc90d,	0xaaff, 0xc90d,		0x21, 0
	.dw 0xab40, 0xc90d,	0xab7f, 0xc90d,		0x21, 0
	.dw 0xabc0, 0xc90d,	0xabff, 0xc90d,		0x21, 0
	.dw 0xac40, 0xc90d,	0xac7f, 0xc90d,		0x21, 0
	.dw 0xacc0, 0xc90d,	0xacff, 0xc90d,		0x21, 0
	.dw 0xad40, 0xc90d,	0xad7f, 0xc90d,		0x21, 0
	.dw 0xadc0, 0xc90d,	0xadff, 0xc90d,		0x21, 0
	.dw 0xae40, 0xc90d,	0xae7f, 0xc90d,		0x21, 0
	.dw 0xaec0, 0xc90d,	0xaeff, 0xc90d,		0x21, 0
	.dw 0xaf40, 0xc90d,	0xaf7f, 0xc90d,		0x21, 0
	.dw 0xafc0, 0xc90d,	0xafff, 0xc90d,		0x21, 0
	.dw 0xb040, 0xc90d,	0xb07f, 0xc90d,		0x21, 0
	.dw 0xb0c0, 0xc90d,	0xb0ff, 0xc90d,		0x21, 0
	.dw 0xb140, 0xc90d,	0xb17f, 0xc90d,		0x21, 0
	.dw 0xb1c0, 0xc90d,	0xb1ff, 0xc90d,		0x21, 0
	.dw 0xb240, 0xc90d,	0xb27f, 0xc90d,		0x21, 0
	.dw 0xb2c0, 0xc90d,	0xb2ff, 0xc90d,		0x21, 0
	.dw 0xb340, 0xc90d,	0xb37f, 0xc90d,		0x21, 0
	.dw 0xb3c0, 0xc90d,	0xb3ff, 0xc90d,		0x21, 0
	.dw 0xb440, 0xc90d,	0xb47f, 0xc90d,		0x21, 0
	.dw 0xb4c0, 0xc90d,	0xb4ff, 0xc90d,		0x21, 0
	.dw 0xb540, 0xc90d,	0xb57f, 0xc90d,		0x21, 0
	.dw 0xb5c0, 0xc90d,	0xb5ff, 0xc90d,		0x21, 0
	.dw 0xb640, 0xc90d,	0xb67f, 0xc90d,		0x21, 0
	.dw 0xb6c0, 0xc90d,	0xb6ff, 0xc90d,		0x21, 0
	.dw 0xb740, 0xc90d,	0xb77f, 0xc90d,		0x21, 0
	.dw 0xb7c0, 0xc90d,	0xb7ff, 0xc90d,		0x21, 0
	.dw 0xb840, 0xc90d,	0xb87f, 0xc90d,		0x21, 0
	.dw 0xb8c0, 0xc90d,	0xb8ff, 0xc90d,		0x21, 0
	.dw 0xb940, 0xc90d,	0xb97f, 0xc90d,		0x21, 0
	.dw 0xb9c0, 0xc90d,	0xbfff, 0xc90d,		0x21, 0
	.dw 0xc040, 0xc90d,	0xc07f, 0xc90d,		0x21, 0
	.dw 0xc0c0, 0xc90d,	0xc0ff, 0xc90d,		0x21, 0
	.dw 0xc140, 0xc90d,	0xc17f, 0xc90d,		0x21, 0
	.dw 0xc1c0, 0xc90d,	0xc1ff, 0xc90d,		0x21, 0
	.dw 0xc240, 0xc90d,	0xc27f, 0xc90d,		0x21, 0
	.dw 0xc2c0, 0xc90d,	0xc2ff, 0xc90d,		0x21, 0
	.dw 0xc340, 0xc90d,	0xc37f, 0xc90d,		0x21, 0
	.dw 0xc3c0, 0xc90d,	0xc3ff, 0xc90d,		0x21, 0
	.dw 0xc440, 0xc90d,	0xc47f, 0xc90d,		0x21, 0
	.dw 0xc4c0, 0xc90d,	0xc4ff, 0xc90d,		0x21, 0
	.dw 0xc540, 0xc90d,	0xc57f, 0xc90d,		0x21, 0
	.dw 0xc5c0, 0xc90d,	0xc5ff, 0xc90d,		0x21, 0
	.dw 0xc640, 0xc90d,	0xc67f, 0xc90d,		0x21, 0
	.dw 0xc6c0, 0xc90d,	0xc6ff, 0xc90d,		0x21, 0
	.dw 0xc740, 0xc90d,	0xc77f, 0xc90d,		0x21, 0
	.dw 0xc7c0, 0xc90d,	0xc7ff, 0xc90d,		0x21, 0
	.dw 0xc840, 0xc90d,	0xc87f, 0xc90d,		0x21, 0
	.dw 0xc8c0, 0xc90d,	0xc8ff, 0xc90d,		0x21, 0
	.dw 0xc940, 0xc90d,	0xc97f, 0xc90d,		0x21, 0
	.dw 0xc9c0, 0xc90d,	0xc9ff, 0xc90d,		0x21, 0
	.dw 0xca40, 0xc90d,	0xca7f, 0xc90d,		0x21, 0
	.dw 0xcac0, 0xc90d,	0xcaff, 0xc90d,		0x21, 0
	.dw 0xcb40, 0xc90d,	0xcb7f, 0xc90d,		0x21, 0
	.dw 0xcbc0, 0xc90d,	0xcbff, 0xc90d,		0x21, 0
	.dw 0xcc40, 0xc90d,	0xcc7f, 0xc90d,		0x21, 0
	.dw 0xccc0, 0xc90d,	0xccff, 0xc90d,		0x21, 0
	.dw 0xcd40, 0xc90d,	0xcd7f, 0xc90d,		0x21, 0
	.dw 0xcdc0, 0xc90d,	0xcdff, 0xc90d,		0x21, 0
	.dw 0xce40, 0xc90d,	0xce7f, 0xc90d,		0x21, 0
	.dw 0xcec0, 0xc90d,	0xceff, 0xc90d,		0x21, 0
	.dw 0xcf40, 0xc90d,	0xcf7f, 0xc90d,		0x21, 0
	.dw 0xcfc0, 0xc90d,	0xcfff, 0xc90d,		0x21, 0
	.dw 0xd040, 0xc90d,	0xd07f, 0xc90d,		0x21, 0
	.dw 0xd0c0, 0xc90d,	0xd0ff, 0xc90d,		0x21, 0
	.dw 0xd140, 0xc90d,	0xd17f, 0xc90d,		0x21, 0
	.dw 0xd1c0, 0xc90d,	0xd1ff, 0xc90d,		0x21, 0
	.dw 0xd240, 0xc90d,	0xd27f, 0xc90d,		0x21, 0
	.dw 0xd2c0, 0xc90d,	0xd2ff, 0xc90d,		0x21, 0
	.dw 0xd340, 0xc90d,	0xd37f, 0xc90d,		0x21, 0
	.dw 0xd3c0, 0xc90d,	0xd3ff, 0xc90d,		0x21, 0
	.dw 0xd440, 0xc90d,	0xd47f, 0xc90d,		0x21, 0
	.dw 0xd4c0, 0xc90d,	0xd4ff, 0xc90d,		0x21, 0
	.dw 0xd540, 0xc90d,	0xd57f, 0xc90d,		0x21, 0
	.dw 0xd5c0, 0xc90d,	0xd5ff, 0xc90d,		0x21, 0
	.dw 0xd640, 0xc90d,	0xd67f, 0xc90d,		0x21, 0
	.dw 0xd6c0, 0xc90d,	0xd6ff, 0xc90d,		0x21, 0
	.dw 0xd740, 0xc90d,	0xd77f, 0xc90d,		0x21, 0
	.dw 0xd7c0, 0xc90d,	0xd7ff, 0xc90d,		0x21, 0
	.dw 0xd840, 0xc90d,	0xd87f, 0xc90d,		0x21, 0
	.dw 0xd8c0, 0xc90d,	0xd8ff, 0xc90d,		0x21, 0
	.dw 0xd940, 0xc90d,	0xd97f, 0xc90d,		0x21, 0
	.dw 0xd9c0, 0xc90d,	0xdfff, 0xc90d,		0x21, 0
	.dw 0xe040, 0xc90d,	0xe07f, 0xc90d,		0x21, 0
	.dw 0xe0c0, 0xc90d,	0xe0ff, 0xc90d,		0x21, 0
	.dw 0xe140, 0xc90d,	0xe17f, 0xc90d,		0x21, 0
	.dw 0xe1c0, 0xc90d,	0xe1ff, 0xc90d,		0x21, 0
	.dw 0xe240, 0xc90d,	0xe27f, 0xc90d,		0x21, 0
	.dw 0xe2c0, 0xc90d,	0xe2ff, 0xc90d,		0x21, 0
	.dw 0xe340, 0xc90d,	0xe37f, 0xc90d,		0x21, 0
	.dw 0xe3c0, 0xc90d,	0xe3ff, 0xc90d,		0x21, 0
	.dw 0xe440, 0xc90d,	0xe47f, 0xc90d,		0x21, 0
	.dw 0xe4c0, 0xc90d,	0xe4ff, 0xc90d,		0x21, 0
	.dw 0xe540, 0xc90d,	0xe57f, 0xc90d,		0x21, 0
	.dw 0xe5c0, 0xc90d,	0xe5ff, 0xc90d,		0x21, 0
	.dw 0xe640, 0xc90d,	0xe67f, 0xc90d,		0x21, 0
	.dw 0xe6c0, 0xc90d,	0xe6ff, 0xc90d,		0x21, 0
	.dw 0xe740, 0xc90d,	0xe77f, 0xc90d,		0x21, 0
	.dw 0xe7c0, 0xc90d,	0xe7ff, 0xc90d,		0x21, 0
	.dw 0xe840, 0xc90d,	0xe87f, 0xc90d,		0x21, 0
	.dw 0xe8c0, 0xc90d,	0xe8ff, 0xc90d,		0x21, 0
	.dw 0xe940, 0xc90d,	0xe97f, 0xc90d,		0x21, 0
	.dw 0xe9c0, 0xc90d,	0xe9ff, 0xc90d,		0x21, 0
	.dw 0xea40, 0xc90d,	0xea7f, 0xc90d,		0x21, 0
	.dw 0xeac0, 0xc90d,	0xeaff, 0xc90d,		0x21, 0
	.dw 0xeb40, 0xc90d,	0xeb7f, 0xc90d,		0x21, 0
	.dw 0xebc0, 0xc90d,	0xebff, 0xc90d,		0x21, 0
	.dw 0xec40, 0xc90d,	0xec7f, 0xc90d,		0x21, 0
	.dw 0xecc0, 0xc90d,	0xecff, 0xc90d,		0x21, 0
	.dw 0xed40, 0xc90d,	0xed7f, 0xc90d,		0x21, 0
	.dw 0xedc0, 0xc90d,	0xedff, 0xc90d,		0x21, 0
	.dw 0xee40, 0xc90d,	0xee7f, 0xc90d,		0x21, 0
	.dw 0xeec0, 0xc90d,	0xeeff, 0xc90d,		0x21, 0
	.dw 0xef40, 0xc90d,	0xef7f, 0xc90d,		0x21, 0
	.dw 0xefc0, 0xc90d,	0xefff, 0xc90d,		0x21, 0
	.dw 0xf040, 0xc90d,	0xf07f, 0xc90d,		0x21, 0
	.dw 0xf0c0, 0xc90d,	0xf0ff, 0xc90d,		0x21, 0
	.dw 0xf140, 0xc90d,	0xf17f, 0xc90d,		0x21, 0
	.dw 0xf1c0, 0xc90d,	0xf1ff, 0xc90d,		0x21, 0
	.dw 0xf240, 0xc90d,	0xf27f, 0xc90d,		0x21, 0
	.dw 0xf2c0, 0xc90d,	0xf2ff, 0xc90d,		0x21, 0
	.dw 0xf340, 0xc90d,	0xf37f, 0xc90d,		0x21, 0
	.dw 0xf3c0, 0xc90d,	0xf3ff, 0xc90d,		0x21, 0
	.dw 0xf440, 0xc90d,	0xf47f, 0xc90d,		0x21, 0
	.dw 0xf4c0, 0xc90d,	0xf4ff, 0xc90d,		0x21, 0
	.dw 0xf540, 0xc90d,	0xf57f, 0xc90d,		0x21, 0
	.dw 0xf5c0, 0xc90d,	0xf5ff, 0xc90d,		0x21, 0
	.dw 0xf640, 0xc90d,	0xf67f, 0xc90d,		0x21, 0
	.dw 0xf6c0, 0xc90d,	0xf6ff, 0xc90d,		0x21, 0
	.dw 0xf740, 0xc90d,	0xf77f, 0xc90d,		0x21, 0
	.dw 0xf7c0, 0xc90d,	0xf7ff, 0xc90d,		0x21, 0
	.dw 0xf840, 0xc90d,	0xf87f, 0xc90d,		0x21, 0
	.dw 0xf8c0, 0xc90d,	0xf8ff, 0xc90d,		0x21, 0
	.dw 0xf940, 0xc90d,	0xf97f, 0xc90d,		0x21, 0
	.dw 0xf9c0, 0xc90d,	0xffff, 0xc90d,		0x21, 0
	.dw 0x0040, 0xc90e,	0x007f, 0xc90e,		0x21, 0
	.dw 0x00c0, 0xc90e,	0x00ff, 0xc90e,		0x21, 0
	.dw 0x0140, 0xc90e,	0x017f, 0xc90e,		0x21, 0
	.dw 0x01c0, 0xc90e,	0x01ff, 0xc90e,		0x21, 0
	.dw 0x0240, 0xc90e,	0x027f, 0xc90e,		0x21, 0
	.dw 0x02c0, 0xc90e,	0x02ff, 0xc90e,		0x21, 0
	.dw 0x0340, 0xc90e,	0x037f, 0xc90e,		0x21, 0
	.dw 0x03c0, 0xc90e,	0x03ff, 0xc90e,		0x21, 0
	.dw 0x0440, 0xc90e,	0x047f, 0xc90e,		0x21, 0
	.dw 0x04c0, 0xc90e,	0x04ff, 0xc90e,		0x21, 0
	.dw 0x0540, 0xc90e,	0x057f, 0xc90e,		0x21, 0
	.dw 0x05c0, 0xc90e,	0x05ff, 0xc90e,		0x21, 0
	.dw 0x0640, 0xc90e,	0x067f, 0xc90e,		0x21, 0
	.dw 0x06c0, 0xc90e,	0x06ff, 0xc90e,		0x21, 0
	.dw 0x0740, 0xc90e,	0x077f, 0xc90e,		0x21, 0
	.dw 0x07c0, 0xc90e,	0x07ff, 0xc90e,		0x21, 0
	.dw 0x0840, 0xc90e,	0x087f, 0xc90e,		0x21, 0
	.dw 0x08c0, 0xc90e,	0x08ff, 0xc90e,		0x21, 0
	.dw 0x0940, 0xc90e,	0x097f, 0xc90e,		0x21, 0
	.dw 0x09c0, 0xc90e,	0x09ff, 0xc90e,		0x21, 0
	.dw 0x0a40, 0xc90e,	0x0a7f, 0xc90e,		0x21, 0
	.dw 0x0ac0, 0xc90e,	0x0aff, 0xc90e,		0x21, 0
	.dw 0x0b40, 0xc90e,	0x0b7f, 0xc90e,		0x21, 0
	.dw 0x0bc0, 0xc90e,	0x0bff, 0xc90e,		0x21, 0
	.dw 0x0c40, 0xc90e,	0x0c7f, 0xc90e,		0x21, 0
	.dw 0x0cc0, 0xc90e,	0x0cff, 0xc90e,		0x21, 0
	.dw 0x0d40, 0xc90e,	0x0d7f, 0xc90e,		0x21, 0
	.dw 0x0dc0, 0xc90e,	0x0dff, 0xc90e,		0x21, 0
	.dw 0x0e40, 0xc90e,	0x0e7f, 0xc90e,		0x21, 0
	.dw 0x0ec0, 0xc90e,	0x0eff, 0xc90e,		0x21, 0
	.dw 0x0f40, 0xc90e,	0x0f7f, 0xc90e,		0x21, 0
	.dw 0x0fc0, 0xc90e,	0x0fff, 0xc90e,		0x21, 0
	.dw 0x1040, 0xc90e,	0x107f, 0xc90e,		0x21, 0
	.dw 0x10c0, 0xc90e,	0x10ff, 0xc90e,		0x21, 0
	.dw 0x1140, 0xc90e,	0x117f, 0xc90e,		0x21, 0
	.dw 0x11c0, 0xc90e,	0x11ff, 0xc90e,		0x21, 0
	.dw 0x1240, 0xc90e,	0x127f, 0xc90e,		0x21, 0
	.dw 0x12c0, 0xc90e,	0x12ff, 0xc90e,		0x21, 0
	.dw 0x1340, 0xc90e,	0x137f, 0xc90e,		0x21, 0
	.dw 0x13c0, 0xc90e,	0x13ff, 0xc90e,		0x21, 0
	.dw 0x1440, 0xc90e,	0x147f, 0xc90e,		0x21, 0
	.dw 0x14c0, 0xc90e,	0x14ff, 0xc90e,		0x21, 0
	.dw 0x1540, 0xc90e,	0x157f, 0xc90e,		0x21, 0
	.dw 0x15c0, 0xc90e,	0x15ff, 0xc90e,		0x21, 0
	.dw 0x1640, 0xc90e,	0x167f, 0xc90e,		0x21, 0
	.dw 0x16c0, 0xc90e,	0x16ff, 0xc90e,		0x21, 0
	.dw 0x1740, 0xc90e,	0x177f, 0xc90e,		0x21, 0
	.dw 0x17c0, 0xc90e,	0x17ff, 0xc90e,		0x21, 0
	.dw 0x1840, 0xc90e,	0x187f, 0xc90e,		0x21, 0
	.dw 0x18c0, 0xc90e,	0x18ff, 0xc90e,		0x21, 0
	.dw 0x1940, 0xc90e,	0x197f, 0xc90e,		0x21, 0
	.dw 0x19c0, 0xc90e,	0x1fff, 0xc90e,		0x21, 0
	.dw 0x2040, 0xc90e,	0x207f, 0xc90e,		0x21, 0
	.dw 0x20c0, 0xc90e,	0x20ff, 0xc90e,		0x21, 0
	.dw 0x2140, 0xc90e,	0x217f, 0xc90e,		0x21, 0
	.dw 0x21c0, 0xc90e,	0x21ff, 0xc90e,		0x21, 0
	.dw 0x2240, 0xc90e,	0x227f, 0xc90e,		0x21, 0
	.dw 0x22c0, 0xc90e,	0x22ff, 0xc90e,		0x21, 0
	.dw 0x2340, 0xc90e,	0x237f, 0xc90e,		0x21, 0
	.dw 0x23c0, 0xc90e,	0x23ff, 0xc90e,		0x21, 0
	.dw 0x2440, 0xc90e,	0x247f, 0xc90e,		0x21, 0
	.dw 0x24c0, 0xc90e,	0x24ff, 0xc90e,		0x21, 0
	.dw 0x2540, 0xc90e,	0x257f, 0xc90e,		0x21, 0
	.dw 0x25c0, 0xc90e,	0x25ff, 0xc90e,		0x21, 0
	.dw 0x2640, 0xc90e,	0x267f, 0xc90e,		0x21, 0
	.dw 0x26c0, 0xc90e,	0x26ff, 0xc90e,		0x21, 0
	.dw 0x2740, 0xc90e,	0x277f, 0xc90e,		0x21, 0
	.dw 0x27c0, 0xc90e,	0x27ff, 0xc90e,		0x21, 0
	.dw 0x2840, 0xc90e,	0x287f, 0xc90e,		0x21, 0
	.dw 0x28c0, 0xc90e,	0x28ff, 0xc90e,		0x21, 0
	.dw 0x2940, 0xc90e,	0x297f, 0xc90e,		0x21, 0
	.dw 0x29c0, 0xc90e,	0x29ff, 0xc90e,		0x21, 0
	.dw 0x2a40, 0xc90e,	0x2a7f, 0xc90e,		0x21, 0
	.dw 0x2ac0, 0xc90e,	0x2aff, 0xc90e,		0x21, 0
	.dw 0x2b40, 0xc90e,	0x2b7f, 0xc90e,		0x21, 0
	.dw 0x2bc0, 0xc90e,	0x2bff, 0xc90e,		0x21, 0
	.dw 0x2c40, 0xc90e,	0x2c7f, 0xc90e,		0x21, 0
	.dw 0x2cc0, 0xc90e,	0x2cff, 0xc90e,		0x21, 0
	.dw 0x2d40, 0xc90e,	0x2d7f, 0xc90e,		0x21, 0
	.dw 0x2dc0, 0xc90e,	0x2dff, 0xc90e,		0x21, 0
	.dw 0x2e40, 0xc90e,	0x2e7f, 0xc90e,		0x21, 0
	.dw 0x2ec0, 0xc90e,	0x2eff, 0xc90e,		0x21, 0
	.dw 0x2f40, 0xc90e,	0x2f7f, 0xc90e,		0x21, 0
	.dw 0x2fc0, 0xc90e,	0x2fff, 0xc90e,		0x21, 0
	.dw 0x3040, 0xc90e,	0x307f, 0xc90e,		0x21, 0
	.dw 0x30c0, 0xc90e,	0x30ff, 0xc90e,		0x21, 0
	.dw 0x3140, 0xc90e,	0x317f, 0xc90e,		0x21, 0
	.dw 0x31c0, 0xc90e,	0x31ff, 0xc90e,		0x21, 0
	.dw 0x3240, 0xc90e,	0x327f, 0xc90e,		0x21, 0
	.dw 0x32c0, 0xc90e,	0x32ff, 0xc90e,		0x21, 0
	.dw 0x3340, 0xc90e,	0x337f, 0xc90e,		0x21, 0
	.dw 0x33c0, 0xc90e,	0x33ff, 0xc90e,		0x21, 0
	.dw 0x3440, 0xc90e,	0x347f, 0xc90e,		0x21, 0
	.dw 0x34c0, 0xc90e,	0x34ff, 0xc90e,		0x21, 0
	.dw 0x3540, 0xc90e,	0x357f, 0xc90e,		0x21, 0
	.dw 0x35c0, 0xc90e,	0x35ff, 0xc90e,		0x21, 0
	.dw 0x3640, 0xc90e,	0x367f, 0xc90e,		0x21, 0
	.dw 0x36c0, 0xc90e,	0x36ff, 0xc90e,		0x21, 0
	.dw 0x3740, 0xc90e,	0x377f, 0xc90e,		0x21, 0
	.dw 0x37c0, 0xc90e,	0x37ff, 0xc90e,		0x21, 0
	.dw 0x3840, 0xc90e,	0x387f, 0xc90e,		0x21, 0
	.dw 0x38c0, 0xc90e,	0x38ff, 0xc90e,		0x21, 0
	.dw 0x3940, 0xc90e,	0x397f, 0xc90e,		0x21, 0
	.dw 0x39c0, 0xc90e,	0x3fff, 0xc90e,		0x21, 0
	.dw 0x4040, 0xc90e,	0x407f, 0xc90e,		0x21, 0
	.dw 0x40c0, 0xc90e,	0x40ff, 0xc90e,		0x21, 0
	.dw 0x4140, 0xc90e,	0x417f, 0xc90e,		0x21, 0
	.dw 0x41c0, 0xc90e,	0x41ff, 0xc90e,		0x21, 0
	.dw 0x4240, 0xc90e,	0x427f, 0xc90e,		0x21, 0
	.dw 0x42c0, 0xc90e,	0x42ff, 0xc90e,		0x21, 0
	.dw 0x4340, 0xc90e,	0x437f, 0xc90e,		0x21, 0
	.dw 0x43c0, 0xc90e,	0x43ff, 0xc90e,		0x21, 0
	.dw 0x4440, 0xc90e,	0x447f, 0xc90e,		0x21, 0
	.dw 0x44c0, 0xc90e,	0x44ff, 0xc90e,		0x21, 0
	.dw 0x4540, 0xc90e,	0x457f, 0xc90e,		0x21, 0
	.dw 0x45c0, 0xc90e,	0x45ff, 0xc90e,		0x21, 0
	.dw 0x4640, 0xc90e,	0x467f, 0xc90e,		0x21, 0
	.dw 0x46c0, 0xc90e,	0x46ff, 0xc90e,		0x21, 0
	.dw 0x4740, 0xc90e,	0x477f, 0xc90e,		0x21, 0
	.dw 0x47c0, 0xc90e,	0x47ff, 0xc90e,		0x21, 0
	.dw 0x4840, 0xc90e,	0x487f, 0xc90e,		0x21, 0
	.dw 0x48c0, 0xc90e,	0x48ff, 0xc90e,		0x21, 0
	.dw 0x4940, 0xc90e,	0x497f, 0xc90e,		0x21, 0
	.dw 0x49c0, 0xc90e,	0x49ff, 0xc90e,		0x21, 0
	.dw 0x4a40, 0xc90e,	0x4a7f, 0xc90e,		0x21, 0
	.dw 0x4ac0, 0xc90e,	0x4aff, 0xc90e,		0x21, 0
	.dw 0x4b40, 0xc90e,	0x4b7f, 0xc90e,		0x21, 0
	.dw 0x4bc0, 0xc90e,	0x4bff, 0xc90e,		0x21, 0
	.dw 0x4c40, 0xc90e,	0x4c7f, 0xc90e,		0x21, 0
	.dw 0x4cc0, 0xc90e,	0x4cff, 0xc90e,		0x21, 0
	.dw 0x4d40, 0xc90e,	0x4d7f, 0xc90e,		0x21, 0
	.dw 0x4dc0, 0xc90e,	0x4dff, 0xc90e,		0x21, 0
	.dw 0x4e40, 0xc90e,	0x4e7f, 0xc90e,		0x21, 0
	.dw 0x4ec0, 0xc90e,	0x4eff, 0xc90e,		0x21, 0
	.dw 0x4f40, 0xc90e,	0x4f7f, 0xc90e,		0x21, 0
	.dw 0x4fc0, 0xc90e,	0x4fff, 0xc90e,		0x21, 0
	.dw 0x5040, 0xc90e,	0x507f, 0xc90e,		0x21, 0
	.dw 0x50c0, 0xc90e,	0x50ff, 0xc90e,		0x21, 0
	.dw 0x5140, 0xc90e,	0x517f, 0xc90e,		0x21, 0
	.dw 0x51c0, 0xc90e,	0x51ff, 0xc90e,		0x21, 0
	.dw 0x5240, 0xc90e,	0x527f, 0xc90e,		0x21, 0
	.dw 0x52c0, 0xc90e,	0x52ff, 0xc90e,		0x21, 0
	.dw 0x5340, 0xc90e,	0x537f, 0xc90e,		0x21, 0
	.dw 0x53c0, 0xc90e,	0x53ff, 0xc90e,		0x21, 0
	.dw 0x5440, 0xc90e,	0x547f, 0xc90e,		0x21, 0
	.dw 0x54c0, 0xc90e,	0x54ff, 0xc90e,		0x21, 0
	.dw 0x5540, 0xc90e,	0x557f, 0xc90e,		0x21, 0
	.dw 0x55c0, 0xc90e,	0x55ff, 0xc90e,		0x21, 0
	.dw 0x5640, 0xc90e,	0x567f, 0xc90e,		0x21, 0
	.dw 0x56c0, 0xc90e,	0x56ff, 0xc90e,		0x21, 0
	.dw 0x5740, 0xc90e,	0x577f, 0xc90e,		0x21, 0
	.dw 0x57c0, 0xc90e,	0x57ff, 0xc90e,		0x21, 0
	.dw 0x5840, 0xc90e,	0x587f, 0xc90e,		0x21, 0
	.dw 0x58c0, 0xc90e,	0x58ff, 0xc90e,		0x21, 0
	.dw 0x5940, 0xc90e,	0x597f, 0xc90e,		0x21, 0
	.dw 0x59c0, 0xc90e,	0x5fff, 0xc90e,		0x21, 0
	.dw 0x6040, 0xc90e,	0x607f, 0xc90e,		0x21, 0
	.dw 0x60c0, 0xc90e,	0x60ff, 0xc90e,		0x21, 0
	.dw 0x6140, 0xc90e,	0x617f, 0xc90e,		0x21, 0
	.dw 0x61c0, 0xc90e,	0x61ff, 0xc90e,		0x21, 0
	.dw 0x6240, 0xc90e,	0x627f, 0xc90e,		0x21, 0
	.dw 0x62c0, 0xc90e,	0x62ff, 0xc90e,		0x21, 0
	.dw 0x6340, 0xc90e,	0x637f, 0xc90e,		0x21, 0
	.dw 0x63c0, 0xc90e,	0x63ff, 0xc90e,		0x21, 0
	.dw 0x6440, 0xc90e,	0x647f, 0xc90e,		0x21, 0
	.dw 0x64c0, 0xc90e,	0x64ff, 0xc90e,		0x21, 0
	.dw 0x6540, 0xc90e,	0x657f, 0xc90e,		0x21, 0
	.dw 0x65c0, 0xc90e,	0x65ff, 0xc90e,		0x21, 0
	.dw 0x6640, 0xc90e,	0x667f, 0xc90e,		0x21, 0
	.dw 0x66c0, 0xc90e,	0x66ff, 0xc90e,		0x21, 0
	.dw 0x6740, 0xc90e,	0x677f, 0xc90e,		0x21, 0
	.dw 0x67c0, 0xc90e,	0x67ff, 0xc90e,		0x21, 0
	.dw 0x6840, 0xc90e,	0x687f, 0xc90e,		0x21, 0
	.dw 0x68c0, 0xc90e,	0x68ff, 0xc90e,		0x21, 0
	.dw 0x6940, 0xc90e,	0x697f, 0xc90e,		0x21, 0
	.dw 0x69c0, 0xc90e,	0x69ff, 0xc90e,		0x21, 0
	.dw 0x6a40, 0xc90e,	0x6a7f, 0xc90e,		0x21, 0
	.dw 0x6ac0, 0xc90e,	0x6aff, 0xc90e,		0x21, 0
	.dw 0x6b40, 0xc90e,	0x6b7f, 0xc90e,		0x21, 0
	.dw 0x6bc0, 0xc90e,	0x6bff, 0xc90e,		0x21, 0
	.dw 0x6c40, 0xc90e,	0x6c7f, 0xc90e,		0x21, 0
	.dw 0x6cc0, 0xc90e,	0x6cff, 0xc90e,		0x21, 0
	.dw 0x6d40, 0xc90e,	0x6d7f, 0xc90e,		0x21, 0
	.dw 0x6dc0, 0xc90e,	0x6dff, 0xc90e,		0x21, 0
	.dw 0x6e40, 0xc90e,	0x6e7f, 0xc90e,		0x21, 0
	.dw 0x6ec0, 0xc90e,	0x6eff, 0xc90e,		0x21, 0
	.dw 0x6f40, 0xc90e,	0x6f7f, 0xc90e,		0x21, 0
	.dw 0x6fc0, 0xc90e,	0x6fff, 0xc90e,		0x21, 0
	.dw 0x7040, 0xc90e,	0x707f, 0xc90e,		0x21, 0
	.dw 0x70c0, 0xc90e,	0x70ff, 0xc90e,		0x21, 0
	.dw 0x7140, 0xc90e,	0x717f, 0xc90e,		0x21, 0
	.dw 0x71c0, 0xc90e,	0x71ff, 0xc90e,		0x21, 0
	.dw 0x7240, 0xc90e,	0x727f, 0xc90e,		0x21, 0
	.dw 0x72c0, 0xc90e,	0x72ff, 0xc90e,		0x21, 0
	.dw 0x7340, 0xc90e,	0x737f, 0xc90e,		0x21, 0
	.dw 0x73c0, 0xc90e,	0x73ff, 0xc90e,		0x21, 0
	.dw 0x7440, 0xc90e,	0x747f, 0xc90e,		0x21, 0
	.dw 0x74c0, 0xc90e,	0x74ff, 0xc90e,		0x21, 0
	.dw 0x7540, 0xc90e,	0x757f, 0xc90e,		0x21, 0
	.dw 0x75c0, 0xc90e,	0x75ff, 0xc90e,		0x21, 0
	.dw 0x7640, 0xc90e,	0x767f, 0xc90e,		0x21, 0
	.dw 0x76c0, 0xc90e,	0x76ff, 0xc90e,		0x21, 0
	.dw 0x7740, 0xc90e,	0x777f, 0xc90e,		0x21, 0
	.dw 0x77c0, 0xc90e,	0x77ff, 0xc90e,		0x21, 0
	.dw 0x7840, 0xc90e,	0x787f, 0xc90e,		0x21, 0
	.dw 0x78c0, 0xc90e,	0x78ff, 0xc90e,		0x21, 0
	.dw 0x7940, 0xc90e,	0x797f, 0xc90e,		0x21, 0
	.dw 0x79c0, 0xc90e,	0x7fff, 0xc90e,		0x21, 0
	.dw 0x8040, 0xc90e,	0x807f, 0xc90e,		0x21, 0
	.dw 0x80c0, 0xc90e,	0x80ff, 0xc90e,		0x21, 0
	.dw 0x8140, 0xc90e,	0x817f, 0xc90e,		0x21, 0
	.dw 0x81c0, 0xc90e,	0x81ff, 0xc90e,		0x21, 0
	.dw 0x8240, 0xc90e,	0x827f, 0xc90e,		0x21, 0
	.dw 0x82c0, 0xc90e,	0x82ff, 0xc90e,		0x21, 0
	.dw 0x8340, 0xc90e,	0x837f, 0xc90e,		0x21, 0
	.dw 0x83c0, 0xc90e,	0x83ff, 0xc90e,		0x21, 0
	.dw 0x8440, 0xc90e,	0x847f, 0xc90e,		0x21, 0
	.dw 0x84c0, 0xc90e,	0x84ff, 0xc90e,		0x21, 0
	.dw 0x8540, 0xc90e,	0x857f, 0xc90e,		0x21, 0
	.dw 0x85c0, 0xc90e,	0x85ff, 0xc90e,		0x21, 0
	.dw 0x8640, 0xc90e,	0x867f, 0xc90e,		0x21, 0
	.dw 0x86c0, 0xc90e,	0x86ff, 0xc90e,		0x21, 0
	.dw 0x8740, 0xc90e,	0x877f, 0xc90e,		0x21, 0
	.dw 0x87c0, 0xc90e,	0x87ff, 0xc90e,		0x21, 0
	.dw 0x8840, 0xc90e,	0x887f, 0xc90e,		0x21, 0
	.dw 0x88c0, 0xc90e,	0x88ff, 0xc90e,		0x21, 0
	.dw 0x8940, 0xc90e,	0x897f, 0xc90e,		0x21, 0
	.dw 0x89c0, 0xc90e,	0x89ff, 0xc90e,		0x21, 0
	.dw 0x8a40, 0xc90e,	0x8a7f, 0xc90e,		0x21, 0
	.dw 0x8ac0, 0xc90e,	0x8aff, 0xc90e,		0x21, 0
	.dw 0x8b40, 0xc90e,	0x8b7f, 0xc90e,		0x21, 0
	.dw 0x8bc0, 0xc90e,	0x8bff, 0xc90e,		0x21, 0
	.dw 0x8c40, 0xc90e,	0x8c7f, 0xc90e,		0x21, 0
	.dw 0x8cc0, 0xc90e,	0x8cff, 0xc90e,		0x21, 0
	.dw 0x8d40, 0xc90e,	0x8d7f, 0xc90e,		0x21, 0
	.dw 0x8dc0, 0xc90e,	0x8dff, 0xc90e,		0x21, 0
	.dw 0x8e40, 0xc90e,	0x8e7f, 0xc90e,		0x21, 0
	.dw 0x8ec0, 0xc90e,	0x8eff, 0xc90e,		0x21, 0
	.dw 0x8f40, 0xc90e,	0x8f7f, 0xc90e,		0x21, 0
	.dw 0x8fc0, 0xc90e,	0x8fff, 0xc90e,		0x21, 0
	.dw 0x9040, 0xc90e,	0x907f, 0xc90e,		0x21, 0
	.dw 0x90c0, 0xc90e,	0x90ff, 0xc90e,		0x21, 0
	.dw 0x9140, 0xc90e,	0x917f, 0xc90e,		0x21, 0
	.dw 0x91c0, 0xc90e,	0x91ff, 0xc90e,		0x21, 0
	.dw 0x9240, 0xc90e,	0x927f, 0xc90e,		0x21, 0
	.dw 0x92c0, 0xc90e,	0x92ff, 0xc90e,		0x21, 0
	.dw 0x9340, 0xc90e,	0x937f, 0xc90e,		0x21, 0
	.dw 0x93c0, 0xc90e,	0x93ff, 0xc90e,		0x21, 0
	.dw 0x9440, 0xc90e,	0x947f, 0xc90e,		0x21, 0
	.dw 0x94c0, 0xc90e,	0x94ff, 0xc90e,		0x21, 0
	.dw 0x9540, 0xc90e,	0x957f, 0xc90e,		0x21, 0
	.dw 0x95c0, 0xc90e,	0x95ff, 0xc90e,		0x21, 0
	.dw 0x9640, 0xc90e,	0x967f, 0xc90e,		0x21, 0
	.dw 0x96c0, 0xc90e,	0x96ff, 0xc90e,		0x21, 0
	.dw 0x9740, 0xc90e,	0x977f, 0xc90e,		0x21, 0
	.dw 0x97c0, 0xc90e,	0x97ff, 0xc90e,		0x21, 0
	.dw 0x9840, 0xc90e,	0x987f, 0xc90e,		0x21, 0
	.dw 0x98c0, 0xc90e,	0x98ff, 0xc90e,		0x21, 0
	.dw 0x9940, 0xc90e,	0x997f, 0xc90e,		0x21, 0
	.dw 0x99c0, 0xc90e,	0x9fff, 0xc90e,		0x21, 0
	.dw 0xa040, 0xc90e,	0xa07f, 0xc90e,		0x21, 0
	.dw 0xa0c0, 0xc90e,	0xa0ff, 0xc90e,		0x21, 0
	.dw 0xa140, 0xc90e,	0xa17f, 0xc90e,		0x21, 0
	.dw 0xa1c0, 0xc90e,	0xa1ff, 0xc90e,		0x21, 0
	.dw 0xa240, 0xc90e,	0xa27f, 0xc90e,		0x21, 0
	.dw 0xa2c0, 0xc90e,	0xa2ff, 0xc90e,		0x21, 0
	.dw 0xa340, 0xc90e,	0xa37f, 0xc90e,		0x21, 0
	.dw 0xa3c0, 0xc90e,	0xa3ff, 0xc90e,		0x21, 0
	.dw 0xa440, 0xc90e,	0xa47f, 0xc90e,		0x21, 0
	.dw 0xa4c0, 0xc90e,	0xa4ff, 0xc90e,		0x21, 0
	.dw 0xa540, 0xc90e,	0xa57f, 0xc90e,		0x21, 0
	.dw 0xa5c0, 0xc90e,	0xa5ff, 0xc90e,		0x21, 0
	.dw 0xa640, 0xc90e,	0xa67f, 0xc90e,		0x21, 0
	.dw 0xa6c0, 0xc90e,	0xa6ff, 0xc90e,		0x21, 0
	.dw 0xa740, 0xc90e,	0xa77f, 0xc90e,		0x21, 0
	.dw 0xa7c0, 0xc90e,	0xa7ff, 0xc90e,		0x21, 0
	.dw 0xa840, 0xc90e,	0xa87f, 0xc90e,		0x21, 0
	.dw 0xa8c0, 0xc90e,	0xa8ff, 0xc90e,		0x21, 0
	.dw 0xa940, 0xc90e,	0xa97f, 0xc90e,		0x21, 0
	.dw 0xa9c0, 0xc90e,	0xa9ff, 0xc90e,		0x21, 0
	.dw 0xaa40, 0xc90e,	0xaa7f, 0xc90e,		0x21, 0
	.dw 0xaac0, 0xc90e,	0xaaff, 0xc90e,		0x21, 0
	.dw 0xab40, 0xc90e,	0xab7f, 0xc90e,		0x21, 0
	.dw 0xabc0, 0xc90e,	0xabff, 0xc90e,		0x21, 0
	.dw 0xac40, 0xc90e,	0xac7f, 0xc90e,		0x21, 0
	.dw 0xacc0, 0xc90e,	0xacff, 0xc90e,		0x21, 0
	.dw 0xad40, 0xc90e,	0xad7f, 0xc90e,		0x21, 0
	.dw 0xadc0, 0xc90e,	0xadff, 0xc90e,		0x21, 0
	.dw 0xae40, 0xc90e,	0xae7f, 0xc90e,		0x21, 0
	.dw 0xaec0, 0xc90e,	0xaeff, 0xc90e,		0x21, 0
	.dw 0xaf40, 0xc90e,	0xaf7f, 0xc90e,		0x21, 0
	.dw 0xafc0, 0xc90e,	0xafff, 0xc90e,		0x21, 0
	.dw 0xb040, 0xc90e,	0xb07f, 0xc90e,		0x21, 0
	.dw 0xb0c0, 0xc90e,	0xb0ff, 0xc90e,		0x21, 0
	.dw 0xb140, 0xc90e,	0xb17f, 0xc90e,		0x21, 0
	.dw 0xb1c0, 0xc90e,	0xb1ff, 0xc90e,		0x21, 0
	.dw 0xb240, 0xc90e,	0xb27f, 0xc90e,		0x21, 0
	.dw 0xb2c0, 0xc90e,	0xb2ff, 0xc90e,		0x21, 0
	.dw 0xb340, 0xc90e,	0xb37f, 0xc90e,		0x21, 0
	.dw 0xb3c0, 0xc90e,	0xb3ff, 0xc90e,		0x21, 0
	.dw 0xb440, 0xc90e,	0xb47f, 0xc90e,		0x21, 0
	.dw 0xb4c0, 0xc90e,	0xb4ff, 0xc90e,		0x21, 0
	.dw 0xb540, 0xc90e,	0xb57f, 0xc90e,		0x21, 0
	.dw 0xb5c0, 0xc90e,	0xb5ff, 0xc90e,		0x21, 0
	.dw 0xb640, 0xc90e,	0xb67f, 0xc90e,		0x21, 0
	.dw 0xb6c0, 0xc90e,	0xb6ff, 0xc90e,		0x21, 0
	.dw 0xb740, 0xc90e,	0xb77f, 0xc90e,		0x21, 0
	.dw 0xb7c0, 0xc90e,	0xb7ff, 0xc90e,		0x21, 0
	.dw 0xb840, 0xc90e,	0xb87f, 0xc90e,		0x21, 0
	.dw 0xb8c0, 0xc90e,	0xb8ff, 0xc90e,		0x21, 0
	.dw 0xb940, 0xc90e,	0xb97f, 0xc90e,		0x21, 0
	.dw 0xb9c0, 0xc90e,	0xbfff, 0xc90e,		0x21, 0
	.dw 0xc040, 0xc90e,	0xc07f, 0xc90e,		0x21, 0
	.dw 0xc0c0, 0xc90e,	0xc0ff, 0xc90e,		0x21, 0
	.dw 0xc140, 0xc90e,	0xc17f, 0xc90e,		0x21, 0
	.dw 0xc1c0, 0xc90e,	0xc1ff, 0xc90e,		0x21, 0
	.dw 0xc240, 0xc90e,	0xc27f, 0xc90e,		0x21, 0
	.dw 0xc2c0, 0xc90e,	0xc2ff, 0xc90e,		0x21, 0
	.dw 0xc340, 0xc90e,	0xc37f, 0xc90e,		0x21, 0
	.dw 0xc3c0, 0xc90e,	0xc3ff, 0xc90e,		0x21, 0
	.dw 0xc440, 0xc90e,	0xc47f, 0xc90e,		0x21, 0
	.dw 0xc4c0, 0xc90e,	0xc4ff, 0xc90e,		0x21, 0
	.dw 0xc540, 0xc90e,	0xc57f, 0xc90e,		0x21, 0
	.dw 0xc5c0, 0xc90e,	0xc5ff, 0xc90e,		0x21, 0
	.dw 0xc640, 0xc90e,	0xc67f, 0xc90e,		0x21, 0
	.dw 0xc6c0, 0xc90e,	0xc6ff, 0xc90e,		0x21, 0
	.dw 0xc740, 0xc90e,	0xc77f, 0xc90e,		0x21, 0
	.dw 0xc7c0, 0xc90e,	0xc7ff, 0xc90e,		0x21, 0
	.dw 0xc840, 0xc90e,	0xc87f, 0xc90e,		0x21, 0
	.dw 0xc8c0, 0xc90e,	0xc8ff, 0xc90e,		0x21, 0
	.dw 0xc940, 0xc90e,	0xc97f, 0xc90e,		0x21, 0
	.dw 0xc9c0, 0xc90e,	0xc9ff, 0xc90e,		0x21, 0
	.dw 0xca40, 0xc90e,	0xca7f, 0xc90e,		0x21, 0
	.dw 0xcac0, 0xc90e,	0xcaff, 0xc90e,		0x21, 0
	.dw 0xcb40, 0xc90e,	0xcb7f, 0xc90e,		0x21, 0
	.dw 0xcbc0, 0xc90e,	0xcbff, 0xc90e,		0x21, 0
	.dw 0xcc40, 0xc90e,	0xcc7f, 0xc90e,		0x21, 0
	.dw 0xccc0, 0xc90e,	0xccff, 0xc90e,		0x21, 0
	.dw 0xcd40, 0xc90e,	0xcd7f, 0xc90e,		0x21, 0
	.dw 0xcdc0, 0xc90e,	0xcdff, 0xc90e,		0x21, 0
	.dw 0xce40, 0xc90e,	0xce7f, 0xc90e,		0x21, 0
	.dw 0xcec0, 0xc90e,	0xceff, 0xc90e,		0x21, 0
	.dw 0xcf40, 0xc90e,	0xcf7f, 0xc90e,		0x21, 0
	.dw 0xcfc0, 0xc90e,	0xcfff, 0xc90e,		0x21, 0
	.dw 0xd040, 0xc90e,	0xd07f, 0xc90e,		0x21, 0
	.dw 0xd0c0, 0xc90e,	0xd0ff, 0xc90e,		0x21, 0
	.dw 0xd140, 0xc90e,	0xd17f, 0xc90e,		0x21, 0
	.dw 0xd1c0, 0xc90e,	0xd1ff, 0xc90e,		0x21, 0
	.dw 0xd240, 0xc90e,	0xd27f, 0xc90e,		0x21, 0
	.dw 0xd2c0, 0xc90e,	0xd2ff, 0xc90e,		0x21, 0
	.dw 0xd340, 0xc90e,	0xd37f, 0xc90e,		0x21, 0
	.dw 0xd3c0, 0xc90e,	0xd3ff, 0xc90e,		0x21, 0
	.dw 0xd440, 0xc90e,	0xd47f, 0xc90e,		0x21, 0
	.dw 0xd4c0, 0xc90e,	0xd4ff, 0xc90e,		0x21, 0
	.dw 0xd540, 0xc90e,	0xd57f, 0xc90e,		0x21, 0
	.dw 0xd5c0, 0xc90e,	0xd5ff, 0xc90e,		0x21, 0
	.dw 0xd640, 0xc90e,	0xd67f, 0xc90e,		0x21, 0
	.dw 0xd6c0, 0xc90e,	0xd6ff, 0xc90e,		0x21, 0
	.dw 0xd740, 0xc90e,	0xd77f, 0xc90e,		0x21, 0
	.dw 0xd7c0, 0xc90e,	0xd7ff, 0xc90e,		0x21, 0
	.dw 0xd840, 0xc90e,	0xd87f, 0xc90e,		0x21, 0
	.dw 0xd8c0, 0xc90e,	0xd8ff, 0xc90e,		0x21, 0
	.dw 0xd940, 0xc90e,	0xd97f, 0xc90e,		0x21, 0
	.dw 0xd9c0, 0xc90e,	0xdfff, 0xc90e,		0x21, 0
	.dw 0xe040, 0xc90e,	0xe07f, 0xc90e,		0x21, 0
	.dw 0xe0c0, 0xc90e,	0xe0ff, 0xc90e,		0x21, 0
	.dw 0xe140, 0xc90e,	0xe17f, 0xc90e,		0x21, 0
	.dw 0xe1c0, 0xc90e,	0xe1ff, 0xc90e,		0x21, 0
	.dw 0xe240, 0xc90e,	0xe27f, 0xc90e,		0x21, 0
	.dw 0xe2c0, 0xc90e,	0xe2ff, 0xc90e,		0x21, 0
	.dw 0xe340, 0xc90e,	0xe37f, 0xc90e,		0x21, 0
	.dw 0xe3c0, 0xc90e,	0xe3ff, 0xc90e,		0x21, 0
	.dw 0xe440, 0xc90e,	0xe47f, 0xc90e,		0x21, 0
	.dw 0xe4c0, 0xc90e,	0xe4ff, 0xc90e,		0x21, 0
	.dw 0xe540, 0xc90e,	0xe57f, 0xc90e,		0x21, 0
	.dw 0xe5c0, 0xc90e,	0xe5ff, 0xc90e,		0x21, 0
	.dw 0xe640, 0xc90e,	0xe67f, 0xc90e,		0x21, 0
	.dw 0xe6c0, 0xc90e,	0xe6ff, 0xc90e,		0x21, 0
	.dw 0xe740, 0xc90e,	0xe77f, 0xc90e,		0x21, 0
	.dw 0xe7c0, 0xc90e,	0xe7ff, 0xc90e,		0x21, 0
	.dw 0xe840, 0xc90e,	0xe87f, 0xc90e,		0x21, 0
	.dw 0xe8c0, 0xc90e,	0xe8ff, 0xc90e,		0x21, 0
	.dw 0xe940, 0xc90e,	0xe97f, 0xc90e,		0x21, 0
	.dw 0xe9c0, 0xc90e,	0xe9ff, 0xc90e,		0x21, 0
	.dw 0xea40, 0xc90e,	0xea7f, 0xc90e,		0x21, 0
	.dw 0xeac0, 0xc90e,	0xeaff, 0xc90e,		0x21, 0
	.dw 0xeb40, 0xc90e,	0xeb7f, 0xc90e,		0x21, 0
	.dw 0xebc0, 0xc90e,	0xebff, 0xc90e,		0x21, 0
	.dw 0xec40, 0xc90e,	0xec7f, 0xc90e,		0x21, 0
	.dw 0xecc0, 0xc90e,	0xecff, 0xc90e,		0x21, 0
	.dw 0xed40, 0xc90e,	0xed7f, 0xc90e,		0x21, 0
	.dw 0xedc0, 0xc90e,	0xedff, 0xc90e,		0x21, 0
	.dw 0xee40, 0xc90e,	0xee7f, 0xc90e,		0x21, 0
	.dw 0xeec0, 0xc90e,	0xeeff, 0xc90e,		0x21, 0
	.dw 0xef40, 0xc90e,	0xef7f, 0xc90e,		0x21, 0
	.dw 0xefc0, 0xc90e,	0xefff, 0xc90e,		0x21, 0
	.dw 0xf040, 0xc90e,	0xf07f, 0xc90e,		0x21, 0
	.dw 0xf0c0, 0xc90e,	0xf0ff, 0xc90e,		0x21, 0
	.dw 0xf140, 0xc90e,	0xf17f, 0xc90e,		0x21, 0
	.dw 0xf1c0, 0xc90e,	0xf1ff, 0xc90e,		0x21, 0
	.dw 0xf240, 0xc90e,	0xf27f, 0xc90e,		0x21, 0
	.dw 0xf2c0, 0xc90e,	0xf2ff, 0xc90e,		0x21, 0
	.dw 0xf340, 0xc90e,	0xf37f, 0xc90e,		0x21, 0
	.dw 0xf3c0, 0xc90e,	0xf3ff, 0xc90e,		0x21, 0
	.dw 0xf440, 0xc90e,	0xf47f, 0xc90e,		0x21, 0
	.dw 0xf4c0, 0xc90e,	0xf4ff, 0xc90e,		0x21, 0
	.dw 0xf540, 0xc90e,	0xf57f, 0xc90e,		0x21, 0
	.dw 0xf5c0, 0xc90e,	0xf5ff, 0xc90e,		0x21, 0
	.dw 0xf640, 0xc90e,	0xf67f, 0xc90e,		0x21, 0
	.dw 0xf6c0, 0xc90e,	0xf6ff, 0xc90e,		0x21, 0
	.dw 0xf740, 0xc90e,	0xf77f, 0xc90e,		0x21, 0
	.dw 0xf7c0, 0xc90e,	0xf7ff, 0xc90e,		0x21, 0
	.dw 0xf840, 0xc90e,	0xf87f, 0xc90e,		0x21, 0
	.dw 0xf8c0, 0xc90e,	0xf8ff, 0xc90e,		0x21, 0
	.dw 0xf940, 0xc90e,	0xf97f, 0xc90e,		0x21, 0
	.dw 0xf9c0, 0xc90e,	0xffff, 0xc90e,		0x21, 0
	.dw 0x0040, 0xc90f,	0x007f, 0xc90f,		0x21, 0
	.dw 0x00c0, 0xc90f,	0x00ff, 0xc90f,		0x21, 0
	.dw 0x0140, 0xc90f,	0x017f, 0xc90f,		0x21, 0
	.dw 0x01c0, 0xc90f,	0x01ff, 0xc90f,		0x21, 0
	.dw 0x0240, 0xc90f,	0x027f, 0xc90f,		0x21, 0
	.dw 0x02c0, 0xc90f,	0x02ff, 0xc90f,		0x21, 0
	.dw 0x0340, 0xc90f,	0x037f, 0xc90f,		0x21, 0
	.dw 0x03c0, 0xc90f,	0x03ff, 0xc90f,		0x21, 0
	.dw 0x0440, 0xc90f,	0x047f, 0xc90f,		0x21, 0
	.dw 0x04c0, 0xc90f,	0x04ff, 0xc90f,		0x21, 0
	.dw 0x0540, 0xc90f,	0x057f, 0xc90f,		0x21, 0
	.dw 0x05c0, 0xc90f,	0x05ff, 0xc90f,		0x21, 0
	.dw 0x0640, 0xc90f,	0x067f, 0xc90f,		0x21, 0
	.dw 0x06c0, 0xc90f,	0x06ff, 0xc90f,		0x21, 0
	.dw 0x0740, 0xc90f,	0x077f, 0xc90f,		0x21, 0
	.dw 0x07c0, 0xc90f,	0x07ff, 0xc90f,		0x21, 0
	.dw 0x0840, 0xc90f,	0x087f, 0xc90f,		0x21, 0
	.dw 0x08c0, 0xc90f,	0x08ff, 0xc90f,		0x21, 0
	.dw 0x0940, 0xc90f,	0x097f, 0xc90f,		0x21, 0
	.dw 0x09c0, 0xc90f,	0x09ff, 0xc90f,		0x21, 0
	.dw 0x0a40, 0xc90f,	0x0a7f, 0xc90f,		0x21, 0
	.dw 0x0ac0, 0xc90f,	0x0aff, 0xc90f,		0x21, 0
	.dw 0x0b40, 0xc90f,	0x0b7f, 0xc90f,		0x21, 0
	.dw 0x0bc0, 0xc90f,	0x0bff, 0xc90f,		0x21, 0
	.dw 0x0c40, 0xc90f,	0x0c7f, 0xc90f,		0x21, 0
	.dw 0x0cc0, 0xc90f,	0x0cff, 0xc90f,		0x21, 0
	.dw 0x0d40, 0xc90f,	0x0d7f, 0xc90f,		0x21, 0
	.dw 0x0dc0, 0xc90f,	0x0dff, 0xc90f,		0x21, 0
	.dw 0x0e40, 0xc90f,	0x0e7f, 0xc90f,		0x21, 0
	.dw 0x0ec0, 0xc90f,	0x0eff, 0xc90f,		0x21, 0
	.dw 0x0f40, 0xc90f,	0x0f7f, 0xc90f,		0x21, 0
	.dw 0x0fc0, 0xc90f,	0x0fff, 0xc90f,		0x21, 0
	.dw 0x1040, 0xc90f,	0x107f, 0xc90f,		0x21, 0
	.dw 0x10c0, 0xc90f,	0x10ff, 0xc90f,		0x21, 0
	.dw 0x1140, 0xc90f,	0x117f, 0xc90f,		0x21, 0
	.dw 0x11c0, 0xc90f,	0x11ff, 0xc90f,		0x21, 0
	.dw 0x1240, 0xc90f,	0x127f, 0xc90f,		0x21, 0
	.dw 0x12c0, 0xc90f,	0x12ff, 0xc90f,		0x21, 0
	.dw 0x1340, 0xc90f,	0x137f, 0xc90f,		0x21, 0
	.dw 0x13c0, 0xc90f,	0x13ff, 0xc90f,		0x21, 0
	.dw 0x1440, 0xc90f,	0x147f, 0xc90f,		0x21, 0
	.dw 0x14c0, 0xc90f,	0x14ff, 0xc90f,		0x21, 0
	.dw 0x1540, 0xc90f,	0x157f, 0xc90f,		0x21, 0
	.dw 0x15c0, 0xc90f,	0x15ff, 0xc90f,		0x21, 0
	.dw 0x1640, 0xc90f,	0x167f, 0xc90f,		0x21, 0
	.dw 0x16c0, 0xc90f,	0x16ff, 0xc90f,		0x21, 0
	.dw 0x1740, 0xc90f,	0x177f, 0xc90f,		0x21, 0
	.dw 0x17c0, 0xc90f,	0x17ff, 0xc90f,		0x21, 0
	.dw 0x1840, 0xc90f,	0x187f, 0xc90f,		0x21, 0
	.dw 0x18c0, 0xc90f,	0x18ff, 0xc90f,		0x21, 0
	.dw 0x1940, 0xc90f,	0x197f, 0xc90f,		0x21, 0
	.dw 0x19c0, 0xc90f,	0x1fff, 0xc90f,		0x21, 0
	.dw 0x2040, 0xc90f,	0x207f, 0xc90f,		0x21, 0
	.dw 0x20c0, 0xc90f,	0x20ff, 0xc90f,		0x21, 0
	.dw 0x2140, 0xc90f,	0x217f, 0xc90f,		0x21, 0
	.dw 0x21c0, 0xc90f,	0x21ff, 0xc90f,		0x21, 0
	.dw 0x2240, 0xc90f,	0x227f, 0xc90f,		0x21, 0
	.dw 0x22c0, 0xc90f,	0x22ff, 0xc90f,		0x21, 0
	.dw 0x2340, 0xc90f,	0x237f, 0xc90f,		0x21, 0
	.dw 0x23c0, 0xc90f,	0x23ff, 0xc90f,		0x21, 0
	.dw 0x2440, 0xc90f,	0x247f, 0xc90f,		0x21, 0
	.dw 0x24c0, 0xc90f,	0x24ff, 0xc90f,		0x21, 0
	.dw 0x2540, 0xc90f,	0x257f, 0xc90f,		0x21, 0
	.dw 0x25c0, 0xc90f,	0x25ff, 0xc90f,		0x21, 0
	.dw 0x2640, 0xc90f,	0x267f, 0xc90f,		0x21, 0
	.dw 0x26c0, 0xc90f,	0x26ff, 0xc90f,		0x21, 0
	.dw 0x2740, 0xc90f,	0x277f, 0xc90f,		0x21, 0
	.dw 0x27c0, 0xc90f,	0x27ff, 0xc90f,		0x21, 0
	.dw 0x2840, 0xc90f,	0x287f, 0xc90f,		0x21, 0
	.dw 0x28c0, 0xc90f,	0x28ff, 0xc90f,		0x21, 0
	.dw 0x2940, 0xc90f,	0x297f, 0xc90f,		0x21, 0
	.dw 0x29c0, 0xc90f,	0x29ff, 0xc90f,		0x21, 0
	.dw 0x2a40, 0xc90f,	0x2a7f, 0xc90f,		0x21, 0
	.dw 0x2ac0, 0xc90f,	0x2aff, 0xc90f,		0x21, 0
	.dw 0x2b40, 0xc90f,	0x2b7f, 0xc90f,		0x21, 0
	.dw 0x2bc0, 0xc90f,	0x2bff, 0xc90f,		0x21, 0
	.dw 0x2c40, 0xc90f,	0x2c7f, 0xc90f,		0x21, 0
	.dw 0x2cc0, 0xc90f,	0x2cff, 0xc90f,		0x21, 0
	.dw 0x2d40, 0xc90f,	0x2d7f, 0xc90f,		0x21, 0
	.dw 0x2dc0, 0xc90f,	0x2dff, 0xc90f,		0x21, 0
	.dw 0x2e40, 0xc90f,	0x2e7f, 0xc90f,		0x21, 0
	.dw 0x2ec0, 0xc90f,	0x2eff, 0xc90f,		0x21, 0
	.dw 0x2f40, 0xc90f,	0x2f7f, 0xc90f,		0x21, 0
	.dw 0x2fc0, 0xc90f,	0x2fff, 0xc90f,		0x21, 0
	.dw 0x3040, 0xc90f,	0x307f, 0xc90f,		0x21, 0
	.dw 0x30c0, 0xc90f,	0x30ff, 0xc90f,		0x21, 0
	.dw 0x3140, 0xc90f,	0x317f, 0xc90f,		0x21, 0
	.dw 0x31c0, 0xc90f,	0x31ff, 0xc90f,		0x21, 0
	.dw 0x3240, 0xc90f,	0x327f, 0xc90f,		0x21, 0
	.dw 0x32c0, 0xc90f,	0x32ff, 0xc90f,		0x21, 0
	.dw 0x3340, 0xc90f,	0x337f, 0xc90f,		0x21, 0
	.dw 0x33c0, 0xc90f,	0x33ff, 0xc90f,		0x21, 0
	.dw 0x3440, 0xc90f,	0x347f, 0xc90f,		0x21, 0
	.dw 0x34c0, 0xc90f,	0x34ff, 0xc90f,		0x21, 0
	.dw 0x3540, 0xc90f,	0x357f, 0xc90f,		0x21, 0
	.dw 0x35c0, 0xc90f,	0x35ff, 0xc90f,		0x21, 0
	.dw 0x3640, 0xc90f,	0x367f, 0xc90f,		0x21, 0
	.dw 0x36c0, 0xc90f,	0x36ff, 0xc90f,		0x21, 0
	.dw 0x3740, 0xc90f,	0x377f, 0xc90f,		0x21, 0
	.dw 0x37c0, 0xc90f,	0x37ff, 0xc90f,		0x21, 0
	.dw 0x3840, 0xc90f,	0x387f, 0xc90f,		0x21, 0
	.dw 0x38c0, 0xc90f,	0x38ff, 0xc90f,		0x21, 0
	.dw 0x3940, 0xc90f,	0x397f, 0xc90f,		0x21, 0
	.dw 0x39c0, 0xc90f,	0xffff, 0xc90f,		0x21, 0
	.dw 0x1a00, 0xc910,	0x1fff, 0xc910,		0x21, 0
	.dw 0x3a00, 0xc910,	0x3fff, 0xc910,		0x21, 0
	.dw 0x5a00, 0xc910,	0x5fff, 0xc910,		0x21, 0
	.dw 0x7a00, 0xc910,	0x7fff, 0xc910,		0x21, 0
	.dw 0x9a00, 0xc910,	0x9fff, 0xc910,		0x21, 0
	.dw 0xba00, 0xc910,	0xbfff, 0xc910,		0x21, 0
	.dw 0xda00, 0xc910,	0xdfff, 0xc910,		0x21, 0
	.dw 0xfa00, 0xc910,	0xffff, 0xc910,		0x21, 0
	.dw 0x1a00, 0xc911,	0x1fff, 0xc911,		0x21, 0
	.dw 0x3a00, 0xc911,	0x3fff, 0xc911,		0x21, 0
	.dw 0x5a00, 0xc911,	0x5fff, 0xc911,		0x21, 0
	.dw 0x7a00, 0xc911,	0x7fff, 0xc911,		0x21, 0
	.dw 0x9a00, 0xc911,	0x9fff, 0xc911,		0x21, 0
	.dw 0xba00, 0xc911,	0xbfff, 0xc911,		0x21, 0
	.dw 0xda00, 0xc911,	0xdfff, 0xc911,		0x21, 0
	.dw 0xfa00, 0xc911,	0xffff, 0xc911,		0x21, 0
	.dw 0x1a00, 0xc912,	0x1fff, 0xc912,		0x21, 0
	.dw 0x3a00, 0xc912,	0x3fff, 0xc912,		0x21, 0
	.dw 0x5a00, 0xc912,	0x5fff, 0xc912,		0x21, 0
	.dw 0x7a00, 0xc912,	0x7fff, 0xc912,		0x21, 0
	.dw 0x9a00, 0xc912,	0x9fff, 0xc912,		0x21, 0
	.dw 0xba00, 0xc912,	0xbfff, 0xc912,		0x21, 0
	.dw 0xda00, 0xc912,	0xdfff, 0xc912,		0x21, 0
	.dw 0xfa00, 0xc912,	0xffff, 0xc913,		0x21, 0
	.dw 0x1a00, 0xc914,	0x1fff, 0xc914,		0x21, 0
	.dw 0x3a00, 0xc914,	0x3fff, 0xc914,		0x21, 0
	.dw 0x5a00, 0xc914,	0x5fff, 0xc914,		0x21, 0
	.dw 0x7a00, 0xc914,	0x7fff, 0xc914,		0x21, 0
	.dw 0x9a00, 0xc914,	0x9fff, 0xc914,		0x21, 0
	.dw 0xba00, 0xc914,	0xbfff, 0xc914,		0x21, 0
	.dw 0xda00, 0xc914,	0xdfff, 0xc914,		0x21, 0
	.dw 0xfa00, 0xc914,	0xffff, 0xc914,		0x21, 0
	.dw 0x1a00, 0xc915,	0x1fff, 0xc915,		0x21, 0
	.dw 0x3a00, 0xc915,	0x3fff, 0xc915,		0x21, 0
	.dw 0x5a00, 0xc915,	0x5fff, 0xc915,		0x21, 0
	.dw 0x7a00, 0xc915,	0x7fff, 0xc915,		0x21, 0
	.dw 0x9a00, 0xc915,	0x9fff, 0xc915,		0x21, 0
	.dw 0xba00, 0xc915,	0xbfff, 0xc915,		0x21, 0
	.dw 0xda00, 0xc915,	0xdfff, 0xc915,		0x21, 0
	.dw 0xfa00, 0xc915,	0xffff, 0xc915,		0x21, 0
	.dw 0x1a00, 0xc916,	0x1fff, 0xc916,		0x21, 0
	.dw 0x3a00, 0xc916,	0x3fff, 0xc916,		0x21, 0
	.dw 0x5a00, 0xc916,	0x5fff, 0xc916,		0x21, 0
	.dw 0x7a00, 0xc916,	0x7fff, 0xc916,		0x21, 0
	.dw 0x9a00, 0xc916,	0x9fff, 0xc916,		0x21, 0
	.dw 0xba00, 0xc916,	0xbfff, 0xc916,		0x21, 0
	.dw 0xda00, 0xc916,	0xdfff, 0xc916,		0x21, 0
	.dw 0xfa00, 0xc916,	0xffff, 0xc916,		0x21, 0
	.dw 0x1a00, 0xc917,	0x1fff, 0xc917,		0x21, 0
	.dw 0x3a00, 0xc917,	0x1fff, 0xc918,		0x21, 0
	.dw 0x2040, 0xc918,	0x207f, 0xc918,		0x21, 0
	.dw 0x20c0, 0xc918,	0x20ff, 0xc918,		0x21, 0
	.dw 0x2140, 0xc918,	0x217f, 0xc918,		0x21, 0
	.dw 0x21c0, 0xc918,	0x21ff, 0xc918,		0x21, 0
	.dw 0x2240, 0xc918,	0x227f, 0xc918,		0x21, 0
	.dw 0x22c0, 0xc918,	0x22ff, 0xc918,		0x21, 0
	.dw 0x2340, 0xc918,	0x237f, 0xc918,		0x21, 0
	.dw 0x23c0, 0xc918,	0x23ff, 0xc918,		0x21, 0
	.dw 0x2440, 0xc918,	0x247f, 0xc918,		0x21, 0
	.dw 0x24c0, 0xc918,	0x24ff, 0xc918,		0x21, 0
	.dw 0x2540, 0xc918,	0x257f, 0xc918,		0x21, 0
	.dw 0x25c0, 0xc918,	0x25ff, 0xc918,		0x21, 0
	.dw 0x2640, 0xc918,	0x267f, 0xc918,		0x21, 0
	.dw 0x26c0, 0xc918,	0x26ff, 0xc918,		0x21, 0
	.dw 0x2740, 0xc918,	0x277f, 0xc918,		0x21, 0
	.dw 0x27c0, 0xc918,	0x27ff, 0xc918,		0x21, 0
	.dw 0x2840, 0xc918,	0x287f, 0xc918,		0x21, 0
	.dw 0x28c0, 0xc918,	0x28ff, 0xc918,		0x21, 0
	.dw 0x2940, 0xc918,	0x297f, 0xc918,		0x21, 0
	.dw 0x29c0, 0xc918,	0x29ff, 0xc918,		0x21, 0
	.dw 0x2a40, 0xc918,	0x2a7f, 0xc918,		0x21, 0
	.dw 0x2ac0, 0xc918,	0x2aff, 0xc918,		0x21, 0
	.dw 0x2b40, 0xc918,	0x2b7f, 0xc918,		0x21, 0
	.dw 0x2bc0, 0xc918,	0x2bff, 0xc918,		0x21, 0
	.dw 0x2c40, 0xc918,	0x2c7f, 0xc918,		0x21, 0
	.dw 0x2cc0, 0xc918,	0x2cff, 0xc918,		0x21, 0
	.dw 0x2d40, 0xc918,	0x2d7f, 0xc918,		0x21, 0
	.dw 0x2dc0, 0xc918,	0x2dff, 0xc918,		0x21, 0
	.dw 0x2e40, 0xc918,	0x2e7f, 0xc918,		0x21, 0
	.dw 0x2ec0, 0xc918,	0x2eff, 0xc918,		0x21, 0
	.dw 0x2f40, 0xc918,	0x2f7f, 0xc918,		0x21, 0
	.dw 0x2fc0, 0xc918,	0x2fff, 0xc918,		0x21, 0
	.dw 0x3040, 0xc918,	0x307f, 0xc918,		0x21, 0
	.dw 0x30c0, 0xc918,	0x30ff, 0xc918,		0x21, 0
	.dw 0x3140, 0xc918,	0x317f, 0xc918,		0x21, 0
	.dw 0x31c0, 0xc918,	0x31ff, 0xc918,		0x21, 0
	.dw 0x3240, 0xc918,	0x327f, 0xc918,		0x21, 0
	.dw 0x32c0, 0xc918,	0x32ff, 0xc918,		0x21, 0
	.dw 0x3340, 0xc918,	0x337f, 0xc918,		0x21, 0
	.dw 0x33c0, 0xc918,	0x33ff, 0xc918,		0x21, 0
	.dw 0x3440, 0xc918,	0x347f, 0xc918,		0x21, 0
	.dw 0x34c0, 0xc918,	0x34ff, 0xc918,		0x21, 0
	.dw 0x3540, 0xc918,	0x357f, 0xc918,		0x21, 0
	.dw 0x35c0, 0xc918,	0x35ff, 0xc918,		0x21, 0
	.dw 0x3640, 0xc918,	0x367f, 0xc918,		0x21, 0
	.dw 0x36c0, 0xc918,	0x36ff, 0xc918,		0x21, 0
	.dw 0x3740, 0xc918,	0x377f, 0xc918,		0x21, 0
	.dw 0x37c0, 0xc918,	0x37ff, 0xc918,		0x21, 0
	.dw 0x3840, 0xc918,	0x387f, 0xc918,		0x21, 0
	.dw 0x38c0, 0xc918,	0x38ff, 0xc918,		0x21, 0
	.dw 0x3940, 0xc918,	0x397f, 0xc918,		0x21, 0
	.dw 0x39c0, 0xc918,	0x5fff, 0xc918,		0x21, 0
	.dw 0x6040, 0xc918,	0x607f, 0xc918,		0x21, 0
	.dw 0x60c0, 0xc918,	0x60ff, 0xc918,		0x21, 0
	.dw 0x6140, 0xc918,	0x617f, 0xc918,		0x21, 0
	.dw 0x61c0, 0xc918,	0x61ff, 0xc918,		0x21, 0
	.dw 0x6240, 0xc918,	0x627f, 0xc918,		0x21, 0
	.dw 0x62c0, 0xc918,	0x62ff, 0xc918,		0x21, 0
	.dw 0x6340, 0xc918,	0x637f, 0xc918,		0x21, 0
	.dw 0x63c0, 0xc918,	0x63ff, 0xc918,		0x21, 0
	.dw 0x6440, 0xc918,	0x647f, 0xc918,		0x21, 0
	.dw 0x64c0, 0xc918,	0x64ff, 0xc918,		0x21, 0
	.dw 0x6540, 0xc918,	0x657f, 0xc918,		0x21, 0
	.dw 0x65c0, 0xc918,	0x65ff, 0xc918,		0x21, 0
	.dw 0x6640, 0xc918,	0x667f, 0xc918,		0x21, 0
	.dw 0x66c0, 0xc918,	0x66ff, 0xc918,		0x21, 0
	.dw 0x6740, 0xc918,	0x677f, 0xc918,		0x21, 0
	.dw 0x67c0, 0xc918,	0x67ff, 0xc918,		0x21, 0
	.dw 0x6840, 0xc918,	0x687f, 0xc918,		0x21, 0
	.dw 0x68c0, 0xc918,	0x68ff, 0xc918,		0x21, 0
	.dw 0x6940, 0xc918,	0x697f, 0xc918,		0x21, 0
	.dw 0x69c0, 0xc918,	0x69ff, 0xc918,		0x21, 0
	.dw 0x6a40, 0xc918,	0x6a7f, 0xc918,		0x21, 0
	.dw 0x6ac0, 0xc918,	0x6aff, 0xc918,		0x21, 0
	.dw 0x6b40, 0xc918,	0x6b7f, 0xc918,		0x21, 0
	.dw 0x6bc0, 0xc918,	0x6bff, 0xc918,		0x21, 0
	.dw 0x6c40, 0xc918,	0x6c7f, 0xc918,		0x21, 0
	.dw 0x6cc0, 0xc918,	0x6cff, 0xc918,		0x21, 0
	.dw 0x6d40, 0xc918,	0x6d7f, 0xc918,		0x21, 0
	.dw 0x6dc0, 0xc918,	0x6dff, 0xc918,		0x21, 0
	.dw 0x6e40, 0xc918,	0x6e7f, 0xc918,		0x21, 0
	.dw 0x6ec0, 0xc918,	0x6eff, 0xc918,		0x21, 0
	.dw 0x6f40, 0xc918,	0x6f7f, 0xc918,		0x21, 0
	.dw 0x6fc0, 0xc918,	0x6fff, 0xc918,		0x21, 0
	.dw 0x7040, 0xc918,	0x707f, 0xc918,		0x21, 0
	.dw 0x70c0, 0xc918,	0x70ff, 0xc918,		0x21, 0
	.dw 0x7140, 0xc918,	0x717f, 0xc918,		0x21, 0
	.dw 0x71c0, 0xc918,	0x71ff, 0xc918,		0x21, 0
	.dw 0x7240, 0xc918,	0x727f, 0xc918,		0x21, 0
	.dw 0x72c0, 0xc918,	0x72ff, 0xc918,		0x21, 0
	.dw 0x7340, 0xc918,	0x737f, 0xc918,		0x21, 0
	.dw 0x73c0, 0xc918,	0x73ff, 0xc918,		0x21, 0
	.dw 0x7440, 0xc918,	0x747f, 0xc918,		0x21, 0
	.dw 0x74c0, 0xc918,	0x74ff, 0xc918,		0x21, 0
	.dw 0x7540, 0xc918,	0x757f, 0xc918,		0x21, 0
	.dw 0x75c0, 0xc918,	0x75ff, 0xc918,		0x21, 0
	.dw 0x7640, 0xc918,	0x767f, 0xc918,		0x21, 0
	.dw 0x76c0, 0xc918,	0x76ff, 0xc918,		0x21, 0
	.dw 0x7740, 0xc918,	0x777f, 0xc918,		0x21, 0
	.dw 0x77c0, 0xc918,	0x77ff, 0xc918,		0x21, 0
	.dw 0x7840, 0xc918,	0x787f, 0xc918,		0x21, 0
	.dw 0x78c0, 0xc918,	0x78ff, 0xc918,		0x21, 0
	.dw 0x7940, 0xc918,	0x797f, 0xc918,		0x21, 0
	.dw 0x79c0, 0xc918,	0x9fff, 0xc918,		0x21, 0
	.dw 0xa040, 0xc918,	0xa07f, 0xc918,		0x21, 0
	.dw 0xa0c0, 0xc918,	0xa0ff, 0xc918,		0x21, 0
	.dw 0xa140, 0xc918,	0xa17f, 0xc918,		0x21, 0
	.dw 0xa1c0, 0xc918,	0xa1ff, 0xc918,		0x21, 0
	.dw 0xa240, 0xc918,	0xa27f, 0xc918,		0x21, 0
	.dw 0xa2c0, 0xc918,	0xa2ff, 0xc918,		0x21, 0
	.dw 0xa340, 0xc918,	0xa37f, 0xc918,		0x21, 0
	.dw 0xa3c0, 0xc918,	0xa3ff, 0xc918,		0x21, 0
	.dw 0xa440, 0xc918,	0xa47f, 0xc918,		0x21, 0
	.dw 0xa4c0, 0xc918,	0xa4ff, 0xc918,		0x21, 0
	.dw 0xa540, 0xc918,	0xa57f, 0xc918,		0x21, 0
	.dw 0xa5c0, 0xc918,	0xa5ff, 0xc918,		0x21, 0
	.dw 0xa640, 0xc918,	0xa67f, 0xc918,		0x21, 0
	.dw 0xa6c0, 0xc918,	0xa6ff, 0xc918,		0x21, 0
	.dw 0xa740, 0xc918,	0xa77f, 0xc918,		0x21, 0
	.dw 0xa7c0, 0xc918,	0xa7ff, 0xc918,		0x21, 0
	.dw 0xa840, 0xc918,	0xa87f, 0xc918,		0x21, 0
	.dw 0xa8c0, 0xc918,	0xa8ff, 0xc918,		0x21, 0
	.dw 0xa940, 0xc918,	0xa97f, 0xc918,		0x21, 0
	.dw 0xa9c0, 0xc918,	0xa9ff, 0xc918,		0x21, 0
	.dw 0xaa40, 0xc918,	0xaa7f, 0xc918,		0x21, 0
	.dw 0xaac0, 0xc918,	0xaaff, 0xc918,		0x21, 0
	.dw 0xab40, 0xc918,	0xab7f, 0xc918,		0x21, 0
	.dw 0xabc0, 0xc918,	0xabff, 0xc918,		0x21, 0
	.dw 0xac40, 0xc918,	0xac7f, 0xc918,		0x21, 0
	.dw 0xacc0, 0xc918,	0xacff, 0xc918,		0x21, 0
	.dw 0xad40, 0xc918,	0xad7f, 0xc918,		0x21, 0
	.dw 0xadc0, 0xc918,	0xadff, 0xc918,		0x21, 0
	.dw 0xae40, 0xc918,	0xae7f, 0xc918,		0x21, 0
	.dw 0xaec0, 0xc918,	0xaeff, 0xc918,		0x21, 0
	.dw 0xaf40, 0xc918,	0xaf7f, 0xc918,		0x21, 0
	.dw 0xafc0, 0xc918,	0xafff, 0xc918,		0x21, 0
	.dw 0xb040, 0xc918,	0xb07f, 0xc918,		0x21, 0
	.dw 0xb0c0, 0xc918,	0xb0ff, 0xc918,		0x21, 0
	.dw 0xb140, 0xc918,	0xb17f, 0xc918,		0x21, 0
	.dw 0xb1c0, 0xc918,	0xb1ff, 0xc918,		0x21, 0
	.dw 0xb240, 0xc918,	0xb27f, 0xc918,		0x21, 0
	.dw 0xb2c0, 0xc918,	0xb2ff, 0xc918,		0x21, 0
	.dw 0xb340, 0xc918,	0xb37f, 0xc918,		0x21, 0
	.dw 0xb3c0, 0xc918,	0xb3ff, 0xc918,		0x21, 0
	.dw 0xb440, 0xc918,	0xb47f, 0xc918,		0x21, 0
	.dw 0xb4c0, 0xc918,	0xb4ff, 0xc918,		0x21, 0
	.dw 0xb540, 0xc918,	0xb57f, 0xc918,		0x21, 0
	.dw 0xb5c0, 0xc918,	0xb5ff, 0xc918,		0x21, 0
	.dw 0xb640, 0xc918,	0xb67f, 0xc918,		0x21, 0
	.dw 0xb6c0, 0xc918,	0xb6ff, 0xc918,		0x21, 0
	.dw 0xb740, 0xc918,	0xb77f, 0xc918,		0x21, 0
	.dw 0xb7c0, 0xc918,	0xb7ff, 0xc918,		0x21, 0
	.dw 0xb840, 0xc918,	0xb87f, 0xc918,		0x21, 0
	.dw 0xb8c0, 0xc918,	0xb8ff, 0xc918,		0x21, 0
	.dw 0xb940, 0xc918,	0xb97f, 0xc918,		0x21, 0
	.dw 0xb9c0, 0xc918,	0xdfff, 0xc918,		0x21, 0
	.dw 0xe040, 0xc918,	0xe07f, 0xc918,		0x21, 0
	.dw 0xe0c0, 0xc918,	0xe0ff, 0xc918,		0x21, 0
	.dw 0xe140, 0xc918,	0xe17f, 0xc918,		0x21, 0
	.dw 0xe1c0, 0xc918,	0xe1ff, 0xc918,		0x21, 0
	.dw 0xe240, 0xc918,	0xe27f, 0xc918,		0x21, 0
	.dw 0xe2c0, 0xc918,	0xe2ff, 0xc918,		0x21, 0
	.dw 0xe340, 0xc918,	0xe37f, 0xc918,		0x21, 0
	.dw 0xe3c0, 0xc918,	0xe3ff, 0xc918,		0x21, 0
	.dw 0xe440, 0xc918,	0xe47f, 0xc918,		0x21, 0
	.dw 0xe4c0, 0xc918,	0xe4ff, 0xc918,		0x21, 0
	.dw 0xe540, 0xc918,	0xe57f, 0xc918,		0x21, 0
	.dw 0xe5c0, 0xc918,	0xe5ff, 0xc918,		0x21, 0
	.dw 0xe640, 0xc918,	0xe67f, 0xc918,		0x21, 0
	.dw 0xe6c0, 0xc918,	0xe6ff, 0xc918,		0x21, 0
	.dw 0xe740, 0xc918,	0xe77f, 0xc918,		0x21, 0
	.dw 0xe7c0, 0xc918,	0xe7ff, 0xc918,		0x21, 0
	.dw 0xe840, 0xc918,	0xe87f, 0xc918,		0x21, 0
	.dw 0xe8c0, 0xc918,	0xe8ff, 0xc918,		0x21, 0
	.dw 0xe940, 0xc918,	0xe97f, 0xc918,		0x21, 0
	.dw 0xe9c0, 0xc918,	0xe9ff, 0xc918,		0x21, 0
	.dw 0xea40, 0xc918,	0xea7f, 0xc918,		0x21, 0
	.dw 0xeac0, 0xc918,	0xeaff, 0xc918,		0x21, 0
	.dw 0xeb40, 0xc918,	0xeb7f, 0xc918,		0x21, 0
	.dw 0xebc0, 0xc918,	0xebff, 0xc918,		0x21, 0
	.dw 0xec40, 0xc918,	0xec7f, 0xc918,		0x21, 0
	.dw 0xecc0, 0xc918,	0xecff, 0xc918,		0x21, 0
	.dw 0xed40, 0xc918,	0xed7f, 0xc918,		0x21, 0
	.dw 0xedc0, 0xc918,	0xedff, 0xc918,		0x21, 0
	.dw 0xee40, 0xc918,	0xee7f, 0xc918,		0x21, 0
	.dw 0xeec0, 0xc918,	0xeeff, 0xc918,		0x21, 0
	.dw 0xef40, 0xc918,	0xef7f, 0xc918,		0x21, 0
	.dw 0xefc0, 0xc918,	0xefff, 0xc918,		0x21, 0
	.dw 0xf040, 0xc918,	0xf07f, 0xc918,		0x21, 0
	.dw 0xf0c0, 0xc918,	0xf0ff, 0xc918,		0x21, 0
	.dw 0xf140, 0xc918,	0xf17f, 0xc918,		0x21, 0
	.dw 0xf1c0, 0xc918,	0xf1ff, 0xc918,		0x21, 0
	.dw 0xf240, 0xc918,	0xf27f, 0xc918,		0x21, 0
	.dw 0xf2c0, 0xc918,	0xf2ff, 0xc918,		0x21, 0
	.dw 0xf340, 0xc918,	0xf37f, 0xc918,		0x21, 0
	.dw 0xf3c0, 0xc918,	0xf3ff, 0xc918,		0x21, 0
	.dw 0xf440, 0xc918,	0xf47f, 0xc918,		0x21, 0
	.dw 0xf4c0, 0xc918,	0xf4ff, 0xc918,		0x21, 0
	.dw 0xf540, 0xc918,	0xf57f, 0xc918,		0x21, 0
	.dw 0xf5c0, 0xc918,	0xf5ff, 0xc918,		0x21, 0
	.dw 0xf640, 0xc918,	0xf67f, 0xc918,		0x21, 0
	.dw 0xf6c0, 0xc918,	0xf6ff, 0xc918,		0x21, 0
	.dw 0xf740, 0xc918,	0xf77f, 0xc918,		0x21, 0
	.dw 0xf7c0, 0xc918,	0xf7ff, 0xc918,		0x21, 0
	.dw 0xf840, 0xc918,	0xf87f, 0xc918,		0x21, 0
	.dw 0xf8c0, 0xc918,	0xf8ff, 0xc918,		0x21, 0
	.dw 0xf940, 0xc918,	0xf97f, 0xc918,		0x21, 0
	.dw 0xf9c0, 0xc918,	0x1fff, 0xc919,		0x21, 0
	.dw 0x2040, 0xc919,	0x207f, 0xc919,		0x21, 0
	.dw 0x20c0, 0xc919,	0x20ff, 0xc919,		0x21, 0
	.dw 0x2140, 0xc919,	0x217f, 0xc919,		0x21, 0
	.dw 0x21c0, 0xc919,	0x21ff, 0xc919,		0x21, 0
	.dw 0x2240, 0xc919,	0x227f, 0xc919,		0x21, 0
	.dw 0x22c0, 0xc919,	0x22ff, 0xc919,		0x21, 0
	.dw 0x2340, 0xc919,	0x237f, 0xc919,		0x21, 0
	.dw 0x23c0, 0xc919,	0x23ff, 0xc919,		0x21, 0
	.dw 0x2440, 0xc919,	0x247f, 0xc919,		0x21, 0
	.dw 0x24c0, 0xc919,	0x24ff, 0xc919,		0x21, 0
	.dw 0x2540, 0xc919,	0x257f, 0xc919,		0x21, 0
	.dw 0x25c0, 0xc919,	0x25ff, 0xc919,		0x21, 0
	.dw 0x2640, 0xc919,	0x267f, 0xc919,		0x21, 0
	.dw 0x26c0, 0xc919,	0x26ff, 0xc919,		0x21, 0
	.dw 0x2740, 0xc919,	0x277f, 0xc919,		0x21, 0
	.dw 0x27c0, 0xc919,	0x27ff, 0xc919,		0x21, 0
	.dw 0x2840, 0xc919,	0x287f, 0xc919,		0x21, 0
	.dw 0x28c0, 0xc919,	0x28ff, 0xc919,		0x21, 0
	.dw 0x2940, 0xc919,	0x297f, 0xc919,		0x21, 0
	.dw 0x29c0, 0xc919,	0x29ff, 0xc919,		0x21, 0
	.dw 0x2a40, 0xc919,	0x2a7f, 0xc919,		0x21, 0
	.dw 0x2ac0, 0xc919,	0x2aff, 0xc919,		0x21, 0
	.dw 0x2b40, 0xc919,	0x2b7f, 0xc919,		0x21, 0
	.dw 0x2bc0, 0xc919,	0x2bff, 0xc919,		0x21, 0
	.dw 0x2c40, 0xc919,	0x2c7f, 0xc919,		0x21, 0
	.dw 0x2cc0, 0xc919,	0x2cff, 0xc919,		0x21, 0
	.dw 0x2d40, 0xc919,	0x2d7f, 0xc919,		0x21, 0
	.dw 0x2dc0, 0xc919,	0x2dff, 0xc919,		0x21, 0
	.dw 0x2e40, 0xc919,	0x2e7f, 0xc919,		0x21, 0
	.dw 0x2ec0, 0xc919,	0x2eff, 0xc919,		0x21, 0
	.dw 0x2f40, 0xc919,	0x2f7f, 0xc919,		0x21, 0
	.dw 0x2fc0, 0xc919,	0x2fff, 0xc919,		0x21, 0
	.dw 0x3040, 0xc919,	0x307f, 0xc919,		0x21, 0
	.dw 0x30c0, 0xc919,	0x30ff, 0xc919,		0x21, 0
	.dw 0x3140, 0xc919,	0x317f, 0xc919,		0x21, 0
	.dw 0x31c0, 0xc919,	0x31ff, 0xc919,		0x21, 0
	.dw 0x3240, 0xc919,	0x327f, 0xc919,		0x21, 0
	.dw 0x32c0, 0xc919,	0x32ff, 0xc919,		0x21, 0
	.dw 0x3340, 0xc919,	0x337f, 0xc919,		0x21, 0
	.dw 0x33c0, 0xc919,	0x33ff, 0xc919,		0x21, 0
	.dw 0x3440, 0xc919,	0x347f, 0xc919,		0x21, 0
	.dw 0x34c0, 0xc919,	0x34ff, 0xc919,		0x21, 0
	.dw 0x3540, 0xc919,	0x357f, 0xc919,		0x21, 0
	.dw 0x35c0, 0xc919,	0x35ff, 0xc919,		0x21, 0
	.dw 0x3640, 0xc919,	0x367f, 0xc919,		0x21, 0
	.dw 0x36c0, 0xc919,	0x36ff, 0xc919,		0x21, 0
	.dw 0x3740, 0xc919,	0x377f, 0xc919,		0x21, 0
	.dw 0x37c0, 0xc919,	0x37ff, 0xc919,		0x21, 0
	.dw 0x3840, 0xc919,	0x387f, 0xc919,		0x21, 0
	.dw 0x38c0, 0xc919,	0x38ff, 0xc919,		0x21, 0
	.dw 0x3940, 0xc919,	0x397f, 0xc919,		0x21, 0
	.dw 0x39c0, 0xc919,	0x5fff, 0xc919,		0x21, 0
	.dw 0x6040, 0xc919,	0x607f, 0xc919,		0x21, 0
	.dw 0x60c0, 0xc919,	0x60ff, 0xc919,		0x21, 0
	.dw 0x6140, 0xc919,	0x617f, 0xc919,		0x21, 0
	.dw 0x61c0, 0xc919,	0x61ff, 0xc919,		0x21, 0
	.dw 0x6240, 0xc919,	0x627f, 0xc919,		0x21, 0
	.dw 0x62c0, 0xc919,	0x62ff, 0xc919,		0x21, 0
	.dw 0x6340, 0xc919,	0x637f, 0xc919,		0x21, 0
	.dw 0x63c0, 0xc919,	0x63ff, 0xc919,		0x21, 0
	.dw 0x6440, 0xc919,	0x647f, 0xc919,		0x21, 0
	.dw 0x64c0, 0xc919,	0x64ff, 0xc919,		0x21, 0
	.dw 0x6540, 0xc919,	0x657f, 0xc919,		0x21, 0
	.dw 0x65c0, 0xc919,	0x65ff, 0xc919,		0x21, 0
	.dw 0x6640, 0xc919,	0x667f, 0xc919,		0x21, 0
	.dw 0x66c0, 0xc919,	0x66ff, 0xc919,		0x21, 0
	.dw 0x6740, 0xc919,	0x677f, 0xc919,		0x21, 0
	.dw 0x67c0, 0xc919,	0x67ff, 0xc919,		0x21, 0
	.dw 0x6840, 0xc919,	0x687f, 0xc919,		0x21, 0
	.dw 0x68c0, 0xc919,	0x68ff, 0xc919,		0x21, 0
	.dw 0x6940, 0xc919,	0x697f, 0xc919,		0x21, 0
	.dw 0x69c0, 0xc919,	0x69ff, 0xc919,		0x21, 0
	.dw 0x6a40, 0xc919,	0x6a7f, 0xc919,		0x21, 0
	.dw 0x6ac0, 0xc919,	0x6aff, 0xc919,		0x21, 0
	.dw 0x6b40, 0xc919,	0x6b7f, 0xc919,		0x21, 0
	.dw 0x6bc0, 0xc919,	0x6bff, 0xc919,		0x21, 0
	.dw 0x6c40, 0xc919,	0x6c7f, 0xc919,		0x21, 0
	.dw 0x6cc0, 0xc919,	0x6cff, 0xc919,		0x21, 0
	.dw 0x6d40, 0xc919,	0x6d7f, 0xc919,		0x21, 0
	.dw 0x6dc0, 0xc919,	0x6dff, 0xc919,		0x21, 0
	.dw 0x6e40, 0xc919,	0x6e7f, 0xc919,		0x21, 0
	.dw 0x6ec0, 0xc919,	0x6eff, 0xc919,		0x21, 0
	.dw 0x6f40, 0xc919,	0x6f7f, 0xc919,		0x21, 0
	.dw 0x6fc0, 0xc919,	0x6fff, 0xc919,		0x21, 0
	.dw 0x7040, 0xc919,	0x707f, 0xc919,		0x21, 0
	.dw 0x70c0, 0xc919,	0x70ff, 0xc919,		0x21, 0
	.dw 0x7140, 0xc919,	0x717f, 0xc919,		0x21, 0
	.dw 0x71c0, 0xc919,	0x71ff, 0xc919,		0x21, 0
	.dw 0x7240, 0xc919,	0x727f, 0xc919,		0x21, 0
	.dw 0x72c0, 0xc919,	0x72ff, 0xc919,		0x21, 0
	.dw 0x7340, 0xc919,	0x737f, 0xc919,		0x21, 0
	.dw 0x73c0, 0xc919,	0x73ff, 0xc919,		0x21, 0
	.dw 0x7440, 0xc919,	0x747f, 0xc919,		0x21, 0
	.dw 0x74c0, 0xc919,	0x74ff, 0xc919,		0x21, 0
	.dw 0x7540, 0xc919,	0x757f, 0xc919,		0x21, 0
	.dw 0x75c0, 0xc919,	0x75ff, 0xc919,		0x21, 0
	.dw 0x7640, 0xc919,	0x767f, 0xc919,		0x21, 0
	.dw 0x76c0, 0xc919,	0x76ff, 0xc919,		0x21, 0
	.dw 0x7740, 0xc919,	0x777f, 0xc919,		0x21, 0
	.dw 0x77c0, 0xc919,	0x77ff, 0xc919,		0x21, 0
	.dw 0x7840, 0xc919,	0x787f, 0xc919,		0x21, 0
	.dw 0x78c0, 0xc919,	0x78ff, 0xc919,		0x21, 0
	.dw 0x7940, 0xc919,	0x797f, 0xc919,		0x21, 0
	.dw 0x79c0, 0xc919,	0x9fff, 0xc919,		0x21, 0
	.dw 0xa040, 0xc919,	0xa07f, 0xc919,		0x21, 0
	.dw 0xa0c0, 0xc919,	0xa0ff, 0xc919,		0x21, 0
	.dw 0xa140, 0xc919,	0xa17f, 0xc919,		0x21, 0
	.dw 0xa1c0, 0xc919,	0xa1ff, 0xc919,		0x21, 0
	.dw 0xa240, 0xc919,	0xa27f, 0xc919,		0x21, 0
	.dw 0xa2c0, 0xc919,	0xa2ff, 0xc919,		0x21, 0
	.dw 0xa340, 0xc919,	0xa37f, 0xc919,		0x21, 0
	.dw 0xa3c0, 0xc919,	0xa3ff, 0xc919,		0x21, 0
	.dw 0xa440, 0xc919,	0xa47f, 0xc919,		0x21, 0
	.dw 0xa4c0, 0xc919,	0xa4ff, 0xc919,		0x21, 0
	.dw 0xa540, 0xc919,	0xa57f, 0xc919,		0x21, 0
	.dw 0xa5c0, 0xc919,	0xa5ff, 0xc919,		0x21, 0
	.dw 0xa640, 0xc919,	0xa67f, 0xc919,		0x21, 0
	.dw 0xa6c0, 0xc919,	0xa6ff, 0xc919,		0x21, 0
	.dw 0xa740, 0xc919,	0xa77f, 0xc919,		0x21, 0
	.dw 0xa7c0, 0xc919,	0xa7ff, 0xc919,		0x21, 0
	.dw 0xa840, 0xc919,	0xa87f, 0xc919,		0x21, 0
	.dw 0xa8c0, 0xc919,	0xa8ff, 0xc919,		0x21, 0
	.dw 0xa940, 0xc919,	0xa97f, 0xc919,		0x21, 0
	.dw 0xa9c0, 0xc919,	0xa9ff, 0xc919,		0x21, 0
	.dw 0xaa40, 0xc919,	0xaa7f, 0xc919,		0x21, 0
	.dw 0xaac0, 0xc919,	0xaaff, 0xc919,		0x21, 0
	.dw 0xab40, 0xc919,	0xab7f, 0xc919,		0x21, 0
	.dw 0xabc0, 0xc919,	0xabff, 0xc919,		0x21, 0
	.dw 0xac40, 0xc919,	0xac7f, 0xc919,		0x21, 0
	.dw 0xacc0, 0xc919,	0xacff, 0xc919,		0x21, 0
	.dw 0xad40, 0xc919,	0xad7f, 0xc919,		0x21, 0
	.dw 0xadc0, 0xc919,	0xadff, 0xc919,		0x21, 0
	.dw 0xae40, 0xc919,	0xae7f, 0xc919,		0x21, 0
	.dw 0xaec0, 0xc919,	0xaeff, 0xc919,		0x21, 0
	.dw 0xaf40, 0xc919,	0xaf7f, 0xc919,		0x21, 0
	.dw 0xafc0, 0xc919,	0xafff, 0xc919,		0x21, 0
	.dw 0xb040, 0xc919,	0xb07f, 0xc919,		0x21, 0
	.dw 0xb0c0, 0xc919,	0xb0ff, 0xc919,		0x21, 0
	.dw 0xb140, 0xc919,	0xb17f, 0xc919,		0x21, 0
	.dw 0xb1c0, 0xc919,	0xb1ff, 0xc919,		0x21, 0
	.dw 0xb240, 0xc919,	0xb27f, 0xc919,		0x21, 0
	.dw 0xb2c0, 0xc919,	0xb2ff, 0xc919,		0x21, 0
	.dw 0xb340, 0xc919,	0xb37f, 0xc919,		0x21, 0
	.dw 0xb3c0, 0xc919,	0xb3ff, 0xc919,		0x21, 0
	.dw 0xb440, 0xc919,	0xb47f, 0xc919,		0x21, 0
	.dw 0xb4c0, 0xc919,	0xb4ff, 0xc919,		0x21, 0
	.dw 0xb540, 0xc919,	0xb57f, 0xc919,		0x21, 0
	.dw 0xb5c0, 0xc919,	0xb5ff, 0xc919,		0x21, 0
	.dw 0xb640, 0xc919,	0xb67f, 0xc919,		0x21, 0
	.dw 0xb6c0, 0xc919,	0xb6ff, 0xc919,		0x21, 0
	.dw 0xb740, 0xc919,	0xb77f, 0xc919,		0x21, 0
	.dw 0xb7c0, 0xc919,	0xb7ff, 0xc919,		0x21, 0
	.dw 0xb840, 0xc919,	0xb87f, 0xc919,		0x21, 0
	.dw 0xb8c0, 0xc919,	0xb8ff, 0xc919,		0x21, 0
	.dw 0xb940, 0xc919,	0xb97f, 0xc919,		0x21, 0
	.dw 0xb9c0, 0xc919,	0xdfff, 0xc919,		0x21, 0
	.dw 0xe040, 0xc919,	0xe07f, 0xc919,		0x21, 0
	.dw 0xe0c0, 0xc919,	0xe0ff, 0xc919,		0x21, 0
	.dw 0xe140, 0xc919,	0xe17f, 0xc919,		0x21, 0
	.dw 0xe1c0, 0xc919,	0xe1ff, 0xc919,		0x21, 0
	.dw 0xe240, 0xc919,	0xe27f, 0xc919,		0x21, 0
	.dw 0xe2c0, 0xc919,	0xe2ff, 0xc919,		0x21, 0
	.dw 0xe340, 0xc919,	0xe37f, 0xc919,		0x21, 0
	.dw 0xe3c0, 0xc919,	0xe3ff, 0xc919,		0x21, 0
	.dw 0xe440, 0xc919,	0xe47f, 0xc919,		0x21, 0
	.dw 0xe4c0, 0xc919,	0xe4ff, 0xc919,		0x21, 0
	.dw 0xe540, 0xc919,	0xe57f, 0xc919,		0x21, 0
	.dw 0xe5c0, 0xc919,	0xe5ff, 0xc919,		0x21, 0
	.dw 0xe640, 0xc919,	0xe67f, 0xc919,		0x21, 0
	.dw 0xe6c0, 0xc919,	0xe6ff, 0xc919,		0x21, 0
	.dw 0xe740, 0xc919,	0xe77f, 0xc919,		0x21, 0
	.dw 0xe7c0, 0xc919,	0xe7ff, 0xc919,		0x21, 0
	.dw 0xe840, 0xc919,	0xe87f, 0xc919,		0x21, 0
	.dw 0xe8c0, 0xc919,	0xe8ff, 0xc919,		0x21, 0
	.dw 0xe940, 0xc919,	0xe97f, 0xc919,		0x21, 0
	.dw 0xe9c0, 0xc919,	0xe9ff, 0xc919,		0x21, 0
	.dw 0xea40, 0xc919,	0xea7f, 0xc919,		0x21, 0
	.dw 0xeac0, 0xc919,	0xeaff, 0xc919,		0x21, 0
	.dw 0xeb40, 0xc919,	0xeb7f, 0xc919,		0x21, 0
	.dw 0xebc0, 0xc919,	0xebff, 0xc919,		0x21, 0
	.dw 0xec40, 0xc919,	0xec7f, 0xc919,		0x21, 0
	.dw 0xecc0, 0xc919,	0xecff, 0xc919,		0x21, 0
	.dw 0xed40, 0xc919,	0xed7f, 0xc919,		0x21, 0
	.dw 0xedc0, 0xc919,	0xedff, 0xc919,		0x21, 0
	.dw 0xee40, 0xc919,	0xee7f, 0xc919,		0x21, 0
	.dw 0xeec0, 0xc919,	0xeeff, 0xc919,		0x21, 0
	.dw 0xef40, 0xc919,	0xef7f, 0xc919,		0x21, 0
	.dw 0xefc0, 0xc919,	0xefff, 0xc919,		0x21, 0
	.dw 0xf040, 0xc919,	0xf07f, 0xc919,		0x21, 0
	.dw 0xf0c0, 0xc919,	0xf0ff, 0xc919,		0x21, 0
	.dw 0xf140, 0xc919,	0xf17f, 0xc919,		0x21, 0
	.dw 0xf1c0, 0xc919,	0xf1ff, 0xc919,		0x21, 0
	.dw 0xf240, 0xc919,	0xf27f, 0xc919,		0x21, 0
	.dw 0xf2c0, 0xc919,	0xf2ff, 0xc919,		0x21, 0
	.dw 0xf340, 0xc919,	0xf37f, 0xc919,		0x21, 0
	.dw 0xf3c0, 0xc919,	0xf3ff, 0xc919,		0x21, 0
	.dw 0xf440, 0xc919,	0xf47f, 0xc919,		0x21, 0
	.dw 0xf4c0, 0xc919,	0xf4ff, 0xc919,		0x21, 0
	.dw 0xf540, 0xc919,	0xf57f, 0xc919,		0x21, 0
	.dw 0xf5c0, 0xc919,	0xf5ff, 0xc919,		0x21, 0
	.dw 0xf640, 0xc919,	0xf67f, 0xc919,		0x21, 0
	.dw 0xf6c0, 0xc919,	0xf6ff, 0xc919,		0x21, 0
	.dw 0xf740, 0xc919,	0xf77f, 0xc919,		0x21, 0
	.dw 0xf7c0, 0xc919,	0xf7ff, 0xc919,		0x21, 0
	.dw 0xf840, 0xc919,	0xf87f, 0xc919,		0x21, 0
	.dw 0xf8c0, 0xc919,	0xf8ff, 0xc919,		0x21, 0
	.dw 0xf940, 0xc919,	0xf97f, 0xc919,		0x21, 0
	.dw 0xf9c0, 0xc919,	0x1fff, 0xc91a,		0x21, 0
	.dw 0x2040, 0xc91a,	0x207f, 0xc91a,		0x21, 0
	.dw 0x20c0, 0xc91a,	0x20ff, 0xc91a,		0x21, 0
	.dw 0x2140, 0xc91a,	0x217f, 0xc91a,		0x21, 0
	.dw 0x21c0, 0xc91a,	0x21ff, 0xc91a,		0x21, 0
	.dw 0x2240, 0xc91a,	0x227f, 0xc91a,		0x21, 0
	.dw 0x22c0, 0xc91a,	0x22ff, 0xc91a,		0x21, 0
	.dw 0x2340, 0xc91a,	0x237f, 0xc91a,		0x21, 0
	.dw 0x23c0, 0xc91a,	0x23ff, 0xc91a,		0x21, 0
	.dw 0x2440, 0xc91a,	0x247f, 0xc91a,		0x21, 0
	.dw 0x24c0, 0xc91a,	0x24ff, 0xc91a,		0x21, 0
	.dw 0x2540, 0xc91a,	0x257f, 0xc91a,		0x21, 0
	.dw 0x25c0, 0xc91a,	0x25ff, 0xc91a,		0x21, 0
	.dw 0x2640, 0xc91a,	0x267f, 0xc91a,		0x21, 0
	.dw 0x26c0, 0xc91a,	0x26ff, 0xc91a,		0x21, 0
	.dw 0x2740, 0xc91a,	0x277f, 0xc91a,		0x21, 0
	.dw 0x27c0, 0xc91a,	0x27ff, 0xc91a,		0x21, 0
	.dw 0x2840, 0xc91a,	0x287f, 0xc91a,		0x21, 0
	.dw 0x28c0, 0xc91a,	0x28ff, 0xc91a,		0x21, 0
	.dw 0x2940, 0xc91a,	0x297f, 0xc91a,		0x21, 0
	.dw 0x29c0, 0xc91a,	0x29ff, 0xc91a,		0x21, 0
	.dw 0x2a40, 0xc91a,	0x2a7f, 0xc91a,		0x21, 0
	.dw 0x2ac0, 0xc91a,	0x2aff, 0xc91a,		0x21, 0
	.dw 0x2b40, 0xc91a,	0x2b7f, 0xc91a,		0x21, 0
	.dw 0x2bc0, 0xc91a,	0x2bff, 0xc91a,		0x21, 0
	.dw 0x2c40, 0xc91a,	0x2c7f, 0xc91a,		0x21, 0
	.dw 0x2cc0, 0xc91a,	0x2cff, 0xc91a,		0x21, 0
	.dw 0x2d40, 0xc91a,	0x2d7f, 0xc91a,		0x21, 0
	.dw 0x2dc0, 0xc91a,	0x2dff, 0xc91a,		0x21, 0
	.dw 0x2e40, 0xc91a,	0x2e7f, 0xc91a,		0x21, 0
	.dw 0x2ec0, 0xc91a,	0x2eff, 0xc91a,		0x21, 0
	.dw 0x2f40, 0xc91a,	0x2f7f, 0xc91a,		0x21, 0
	.dw 0x2fc0, 0xc91a,	0x2fff, 0xc91a,		0x21, 0
	.dw 0x3040, 0xc91a,	0x307f, 0xc91a,		0x21, 0
	.dw 0x30c0, 0xc91a,	0x30ff, 0xc91a,		0x21, 0
	.dw 0x3140, 0xc91a,	0x317f, 0xc91a,		0x21, 0
	.dw 0x31c0, 0xc91a,	0x31ff, 0xc91a,		0x21, 0
	.dw 0x3240, 0xc91a,	0x327f, 0xc91a,		0x21, 0
	.dw 0x32c0, 0xc91a,	0x32ff, 0xc91a,		0x21, 0
	.dw 0x3340, 0xc91a,	0x337f, 0xc91a,		0x21, 0
	.dw 0x33c0, 0xc91a,	0x33ff, 0xc91a,		0x21, 0
	.dw 0x3440, 0xc91a,	0x347f, 0xc91a,		0x21, 0
	.dw 0x34c0, 0xc91a,	0x34ff, 0xc91a,		0x21, 0
	.dw 0x3540, 0xc91a,	0x357f, 0xc91a,		0x21, 0
	.dw 0x35c0, 0xc91a,	0x35ff, 0xc91a,		0x21, 0
	.dw 0x3640, 0xc91a,	0x367f, 0xc91a,		0x21, 0
	.dw 0x36c0, 0xc91a,	0x36ff, 0xc91a,		0x21, 0
	.dw 0x3740, 0xc91a,	0x377f, 0xc91a,		0x21, 0
	.dw 0x37c0, 0xc91a,	0x37ff, 0xc91a,		0x21, 0
	.dw 0x3840, 0xc91a,	0x387f, 0xc91a,		0x21, 0
	.dw 0x38c0, 0xc91a,	0x38ff, 0xc91a,		0x21, 0
	.dw 0x3940, 0xc91a,	0x397f, 0xc91a,		0x21, 0
	.dw 0x39c0, 0xc91a,	0x5fff, 0xc91a,		0x21, 0
	.dw 0x6040, 0xc91a,	0x607f, 0xc91a,		0x21, 0
	.dw 0x60c0, 0xc91a,	0x60ff, 0xc91a,		0x21, 0
	.dw 0x6140, 0xc91a,	0x617f, 0xc91a,		0x21, 0
	.dw 0x61c0, 0xc91a,	0x61ff, 0xc91a,		0x21, 0
	.dw 0x6240, 0xc91a,	0x627f, 0xc91a,		0x21, 0
	.dw 0x62c0, 0xc91a,	0x62ff, 0xc91a,		0x21, 0
	.dw 0x6340, 0xc91a,	0x637f, 0xc91a,		0x21, 0
	.dw 0x63c0, 0xc91a,	0x63ff, 0xc91a,		0x21, 0
	.dw 0x6440, 0xc91a,	0x647f, 0xc91a,		0x21, 0
	.dw 0x64c0, 0xc91a,	0x64ff, 0xc91a,		0x21, 0
	.dw 0x6540, 0xc91a,	0x657f, 0xc91a,		0x21, 0
	.dw 0x65c0, 0xc91a,	0x65ff, 0xc91a,		0x21, 0
	.dw 0x6640, 0xc91a,	0x667f, 0xc91a,		0x21, 0
	.dw 0x66c0, 0xc91a,	0x66ff, 0xc91a,		0x21, 0
	.dw 0x6740, 0xc91a,	0x677f, 0xc91a,		0x21, 0
	.dw 0x67c0, 0xc91a,	0x67ff, 0xc91a,		0x21, 0
	.dw 0x6840, 0xc91a,	0x687f, 0xc91a,		0x21, 0
	.dw 0x68c0, 0xc91a,	0x68ff, 0xc91a,		0x21, 0
	.dw 0x6940, 0xc91a,	0x697f, 0xc91a,		0x21, 0
	.dw 0x69c0, 0xc91a,	0x69ff, 0xc91a,		0x21, 0
	.dw 0x6a40, 0xc91a,	0x6a7f, 0xc91a,		0x21, 0
	.dw 0x6ac0, 0xc91a,	0x6aff, 0xc91a,		0x21, 0
	.dw 0x6b40, 0xc91a,	0x6b7f, 0xc91a,		0x21, 0
	.dw 0x6bc0, 0xc91a,	0x6bff, 0xc91a,		0x21, 0
	.dw 0x6c40, 0xc91a,	0x6c7f, 0xc91a,		0x21, 0
	.dw 0x6cc0, 0xc91a,	0x6cff, 0xc91a,		0x21, 0
	.dw 0x6d40, 0xc91a,	0x6d7f, 0xc91a,		0x21, 0
	.dw 0x6dc0, 0xc91a,	0x6dff, 0xc91a,		0x21, 0
	.dw 0x6e40, 0xc91a,	0x6e7f, 0xc91a,		0x21, 0
	.dw 0x6ec0, 0xc91a,	0x6eff, 0xc91a,		0x21, 0
	.dw 0x6f40, 0xc91a,	0x6f7f, 0xc91a,		0x21, 0
	.dw 0x6fc0, 0xc91a,	0x6fff, 0xc91a,		0x21, 0
	.dw 0x7040, 0xc91a,	0x707f, 0xc91a,		0x21, 0
	.dw 0x70c0, 0xc91a,	0x70ff, 0xc91a,		0x21, 0
	.dw 0x7140, 0xc91a,	0x717f, 0xc91a,		0x21, 0
	.dw 0x71c0, 0xc91a,	0x71ff, 0xc91a,		0x21, 0
	.dw 0x7240, 0xc91a,	0x727f, 0xc91a,		0x21, 0
	.dw 0x72c0, 0xc91a,	0x72ff, 0xc91a,		0x21, 0
	.dw 0x7340, 0xc91a,	0x737f, 0xc91a,		0x21, 0
	.dw 0x73c0, 0xc91a,	0x73ff, 0xc91a,		0x21, 0
	.dw 0x7440, 0xc91a,	0x747f, 0xc91a,		0x21, 0
	.dw 0x74c0, 0xc91a,	0x74ff, 0xc91a,		0x21, 0
	.dw 0x7540, 0xc91a,	0x757f, 0xc91a,		0x21, 0
	.dw 0x75c0, 0xc91a,	0x75ff, 0xc91a,		0x21, 0
	.dw 0x7640, 0xc91a,	0x767f, 0xc91a,		0x21, 0
	.dw 0x76c0, 0xc91a,	0x76ff, 0xc91a,		0x21, 0
	.dw 0x7740, 0xc91a,	0x777f, 0xc91a,		0x21, 0
	.dw 0x77c0, 0xc91a,	0x77ff, 0xc91a,		0x21, 0
	.dw 0x7840, 0xc91a,	0x787f, 0xc91a,		0x21, 0
	.dw 0x78c0, 0xc91a,	0x78ff, 0xc91a,		0x21, 0
	.dw 0x7940, 0xc91a,	0x797f, 0xc91a,		0x21, 0
	.dw 0x79c0, 0xc91a,	0x9fff, 0xc91a,		0x21, 0
	.dw 0xa040, 0xc91a,	0xa07f, 0xc91a,		0x21, 0
	.dw 0xa0c0, 0xc91a,	0xa0ff, 0xc91a,		0x21, 0
	.dw 0xa140, 0xc91a,	0xa17f, 0xc91a,		0x21, 0
	.dw 0xa1c0, 0xc91a,	0xa1ff, 0xc91a,		0x21, 0
	.dw 0xa240, 0xc91a,	0xa27f, 0xc91a,		0x21, 0
	.dw 0xa2c0, 0xc91a,	0xa2ff, 0xc91a,		0x21, 0
	.dw 0xa340, 0xc91a,	0xa37f, 0xc91a,		0x21, 0
	.dw 0xa3c0, 0xc91a,	0xa3ff, 0xc91a,		0x21, 0
	.dw 0xa440, 0xc91a,	0xa47f, 0xc91a,		0x21, 0
	.dw 0xa4c0, 0xc91a,	0xa4ff, 0xc91a,		0x21, 0
	.dw 0xa540, 0xc91a,	0xa57f, 0xc91a,		0x21, 0
	.dw 0xa5c0, 0xc91a,	0xa5ff, 0xc91a,		0x21, 0
	.dw 0xa640, 0xc91a,	0xa67f, 0xc91a,		0x21, 0
	.dw 0xa6c0, 0xc91a,	0xa6ff, 0xc91a,		0x21, 0
	.dw 0xa740, 0xc91a,	0xa77f, 0xc91a,		0x21, 0
	.dw 0xa7c0, 0xc91a,	0xa7ff, 0xc91a,		0x21, 0
	.dw 0xa840, 0xc91a,	0xa87f, 0xc91a,		0x21, 0
	.dw 0xa8c0, 0xc91a,	0xa8ff, 0xc91a,		0x21, 0
	.dw 0xa940, 0xc91a,	0xa97f, 0xc91a,		0x21, 0
	.dw 0xa9c0, 0xc91a,	0xa9ff, 0xc91a,		0x21, 0
	.dw 0xaa40, 0xc91a,	0xaa7f, 0xc91a,		0x21, 0
	.dw 0xaac0, 0xc91a,	0xaaff, 0xc91a,		0x21, 0
	.dw 0xab40, 0xc91a,	0xab7f, 0xc91a,		0x21, 0
	.dw 0xabc0, 0xc91a,	0xabff, 0xc91a,		0x21, 0
	.dw 0xac40, 0xc91a,	0xac7f, 0xc91a,		0x21, 0
	.dw 0xacc0, 0xc91a,	0xacff, 0xc91a,		0x21, 0
	.dw 0xad40, 0xc91a,	0xad7f, 0xc91a,		0x21, 0
	.dw 0xadc0, 0xc91a,	0xadff, 0xc91a,		0x21, 0
	.dw 0xae40, 0xc91a,	0xae7f, 0xc91a,		0x21, 0
	.dw 0xaec0, 0xc91a,	0xaeff, 0xc91a,		0x21, 0
	.dw 0xaf40, 0xc91a,	0xaf7f, 0xc91a,		0x21, 0
	.dw 0xafc0, 0xc91a,	0xafff, 0xc91a,		0x21, 0
	.dw 0xb040, 0xc91a,	0xb07f, 0xc91a,		0x21, 0
	.dw 0xb0c0, 0xc91a,	0xb0ff, 0xc91a,		0x21, 0
	.dw 0xb140, 0xc91a,	0xb17f, 0xc91a,		0x21, 0
	.dw 0xb1c0, 0xc91a,	0xb1ff, 0xc91a,		0x21, 0
	.dw 0xb240, 0xc91a,	0xb27f, 0xc91a,		0x21, 0
	.dw 0xb2c0, 0xc91a,	0xb2ff, 0xc91a,		0x21, 0
	.dw 0xb340, 0xc91a,	0xb37f, 0xc91a,		0x21, 0
	.dw 0xb3c0, 0xc91a,	0xb3ff, 0xc91a,		0x21, 0
	.dw 0xb440, 0xc91a,	0xb47f, 0xc91a,		0x21, 0
	.dw 0xb4c0, 0xc91a,	0xb4ff, 0xc91a,		0x21, 0
	.dw 0xb540, 0xc91a,	0xb57f, 0xc91a,		0x21, 0
	.dw 0xb5c0, 0xc91a,	0xb5ff, 0xc91a,		0x21, 0
	.dw 0xb640, 0xc91a,	0xb67f, 0xc91a,		0x21, 0
	.dw 0xb6c0, 0xc91a,	0xb6ff, 0xc91a,		0x21, 0
	.dw 0xb740, 0xc91a,	0xb77f, 0xc91a,		0x21, 0
	.dw 0xb7c0, 0xc91a,	0xb7ff, 0xc91a,		0x21, 0
	.dw 0xb840, 0xc91a,	0xb87f, 0xc91a,		0x21, 0
	.dw 0xb8c0, 0xc91a,	0xb8ff, 0xc91a,		0x21, 0
	.dw 0xb940, 0xc91a,	0xb97f, 0xc91a,		0x21, 0
	.dw 0xb9c0, 0xc91a,	0xdfff, 0xc91a,		0x21, 0
	.dw 0xe040, 0xc91a,	0xe07f, 0xc91a,		0x21, 0
	.dw 0xe0c0, 0xc91a,	0xe0ff, 0xc91a,		0x21, 0
	.dw 0xe140, 0xc91a,	0xe17f, 0xc91a,		0x21, 0
	.dw 0xe1c0, 0xc91a,	0xe1ff, 0xc91a,		0x21, 0
	.dw 0xe240, 0xc91a,	0xe27f, 0xc91a,		0x21, 0
	.dw 0xe2c0, 0xc91a,	0xe2ff, 0xc91a,		0x21, 0
	.dw 0xe340, 0xc91a,	0xe37f, 0xc91a,		0x21, 0
	.dw 0xe3c0, 0xc91a,	0xe3ff, 0xc91a,		0x21, 0
	.dw 0xe440, 0xc91a,	0xe47f, 0xc91a,		0x21, 0
	.dw 0xe4c0, 0xc91a,	0xe4ff, 0xc91a,		0x21, 0
	.dw 0xe540, 0xc91a,	0xe57f, 0xc91a,		0x21, 0
	.dw 0xe5c0, 0xc91a,	0xe5ff, 0xc91a,		0x21, 0
	.dw 0xe640, 0xc91a,	0xe67f, 0xc91a,		0x21, 0
	.dw 0xe6c0, 0xc91a,	0xe6ff, 0xc91a,		0x21, 0
	.dw 0xe740, 0xc91a,	0xe77f, 0xc91a,		0x21, 0
	.dw 0xe7c0, 0xc91a,	0xe7ff, 0xc91a,		0x21, 0
	.dw 0xe840, 0xc91a,	0xe87f, 0xc91a,		0x21, 0
	.dw 0xe8c0, 0xc91a,	0xe8ff, 0xc91a,		0x21, 0
	.dw 0xe940, 0xc91a,	0xe97f, 0xc91a,		0x21, 0
	.dw 0xe9c0, 0xc91a,	0xe9ff, 0xc91a,		0x21, 0
	.dw 0xea40, 0xc91a,	0xea7f, 0xc91a,		0x21, 0
	.dw 0xeac0, 0xc91a,	0xeaff, 0xc91a,		0x21, 0
	.dw 0xeb40, 0xc91a,	0xeb7f, 0xc91a,		0x21, 0
	.dw 0xebc0, 0xc91a,	0xebff, 0xc91a,		0x21, 0
	.dw 0xec40, 0xc91a,	0xec7f, 0xc91a,		0x21, 0
	.dw 0xecc0, 0xc91a,	0xecff, 0xc91a,		0x21, 0
	.dw 0xed40, 0xc91a,	0xed7f, 0xc91a,		0x21, 0
	.dw 0xedc0, 0xc91a,	0xedff, 0xc91a,		0x21, 0
	.dw 0xee40, 0xc91a,	0xee7f, 0xc91a,		0x21, 0
	.dw 0xeec0, 0xc91a,	0xeeff, 0xc91a,		0x21, 0
	.dw 0xef40, 0xc91a,	0xef7f, 0xc91a,		0x21, 0
	.dw 0xefc0, 0xc91a,	0xefff, 0xc91a,		0x21, 0
	.dw 0xf040, 0xc91a,	0xf07f, 0xc91a,		0x21, 0
	.dw 0xf0c0, 0xc91a,	0xf0ff, 0xc91a,		0x21, 0
	.dw 0xf140, 0xc91a,	0xf17f, 0xc91a,		0x21, 0
	.dw 0xf1c0, 0xc91a,	0xf1ff, 0xc91a,		0x21, 0
	.dw 0xf240, 0xc91a,	0xf27f, 0xc91a,		0x21, 0
	.dw 0xf2c0, 0xc91a,	0xf2ff, 0xc91a,		0x21, 0
	.dw 0xf340, 0xc91a,	0xf37f, 0xc91a,		0x21, 0
	.dw 0xf3c0, 0xc91a,	0xf3ff, 0xc91a,		0x21, 0
	.dw 0xf440, 0xc91a,	0xf47f, 0xc91a,		0x21, 0
	.dw 0xf4c0, 0xc91a,	0xf4ff, 0xc91a,		0x21, 0
	.dw 0xf540, 0xc91a,	0xf57f, 0xc91a,		0x21, 0
	.dw 0xf5c0, 0xc91a,	0xf5ff, 0xc91a,		0x21, 0
	.dw 0xf640, 0xc91a,	0xf67f, 0xc91a,		0x21, 0
	.dw 0xf6c0, 0xc91a,	0xf6ff, 0xc91a,		0x21, 0
	.dw 0xf740, 0xc91a,	0xf77f, 0xc91a,		0x21, 0
	.dw 0xf7c0, 0xc91a,	0xf7ff, 0xc91a,		0x21, 0
	.dw 0xf840, 0xc91a,	0xf87f, 0xc91a,		0x21, 0
	.dw 0xf8c0, 0xc91a,	0xf8ff, 0xc91a,		0x21, 0
	.dw 0xf940, 0xc91a,	0xf97f, 0xc91a,		0x21, 0
	.dw 0xf9c0, 0xc91a,	0xffff, 0xc91b,		0x21, 0
	.dw 0x0040, 0xc91c,	0x007f, 0xc91c,		0x21, 0
	.dw 0x00c0, 0xc91c,	0x00ff, 0xc91c,		0x21, 0
	.dw 0x0140, 0xc91c,	0x017f, 0xc91c,		0x21, 0
	.dw 0x01c0, 0xc91c,	0x01ff, 0xc91c,		0x21, 0
	.dw 0x0240, 0xc91c,	0x027f, 0xc91c,		0x21, 0
	.dw 0x02c0, 0xc91c,	0x02ff, 0xc91c,		0x21, 0
	.dw 0x0340, 0xc91c,	0x037f, 0xc91c,		0x21, 0
	.dw 0x03c0, 0xc91c,	0x03ff, 0xc91c,		0x21, 0
	.dw 0x0440, 0xc91c,	0x047f, 0xc91c,		0x21, 0
	.dw 0x04c0, 0xc91c,	0x04ff, 0xc91c,		0x21, 0
	.dw 0x0540, 0xc91c,	0x057f, 0xc91c,		0x21, 0
	.dw 0x05c0, 0xc91c,	0x05ff, 0xc91c,		0x21, 0
	.dw 0x0640, 0xc91c,	0x067f, 0xc91c,		0x21, 0
	.dw 0x06c0, 0xc91c,	0x06ff, 0xc91c,		0x21, 0
	.dw 0x0740, 0xc91c,	0x077f, 0xc91c,		0x21, 0
	.dw 0x07c0, 0xc91c,	0x07ff, 0xc91c,		0x21, 0
	.dw 0x0840, 0xc91c,	0x087f, 0xc91c,		0x21, 0
	.dw 0x08c0, 0xc91c,	0x08ff, 0xc91c,		0x21, 0
	.dw 0x0940, 0xc91c,	0x097f, 0xc91c,		0x21, 0
	.dw 0x09c0, 0xc91c,	0x09ff, 0xc91c,		0x21, 0
	.dw 0x0a40, 0xc91c,	0x0a7f, 0xc91c,		0x21, 0
	.dw 0x0ac0, 0xc91c,	0x0aff, 0xc91c,		0x21, 0
	.dw 0x0b40, 0xc91c,	0x0b7f, 0xc91c,		0x21, 0
	.dw 0x0bc0, 0xc91c,	0x0bff, 0xc91c,		0x21, 0
	.dw 0x0c40, 0xc91c,	0x0c7f, 0xc91c,		0x21, 0
	.dw 0x0cc0, 0xc91c,	0x0cff, 0xc91c,		0x21, 0
	.dw 0x0d40, 0xc91c,	0x0d7f, 0xc91c,		0x21, 0
	.dw 0x0dc0, 0xc91c,	0x0dff, 0xc91c,		0x21, 0
	.dw 0x0e40, 0xc91c,	0x0e7f, 0xc91c,		0x21, 0
	.dw 0x0ec0, 0xc91c,	0x0eff, 0xc91c,		0x21, 0
	.dw 0x0f40, 0xc91c,	0x0f7f, 0xc91c,		0x21, 0
	.dw 0x0fc0, 0xc91c,	0x0fff, 0xc91c,		0x21, 0
	.dw 0x1040, 0xc91c,	0x107f, 0xc91c,		0x21, 0
	.dw 0x10c0, 0xc91c,	0x10ff, 0xc91c,		0x21, 0
	.dw 0x1140, 0xc91c,	0x117f, 0xc91c,		0x21, 0
	.dw 0x11c0, 0xc91c,	0x11ff, 0xc91c,		0x21, 0
	.dw 0x1240, 0xc91c,	0x127f, 0xc91c,		0x21, 0
	.dw 0x12c0, 0xc91c,	0x12ff, 0xc91c,		0x21, 0
	.dw 0x1340, 0xc91c,	0x137f, 0xc91c,		0x21, 0
	.dw 0x13c0, 0xc91c,	0x13ff, 0xc91c,		0x21, 0
	.dw 0x1440, 0xc91c,	0x147f, 0xc91c,		0x21, 0
	.dw 0x14c0, 0xc91c,	0x14ff, 0xc91c,		0x21, 0
	.dw 0x1540, 0xc91c,	0x157f, 0xc91c,		0x21, 0
	.dw 0x15c0, 0xc91c,	0x15ff, 0xc91c,		0x21, 0
	.dw 0x1640, 0xc91c,	0x167f, 0xc91c,		0x21, 0
	.dw 0x16c0, 0xc91c,	0x16ff, 0xc91c,		0x21, 0
	.dw 0x1740, 0xc91c,	0x177f, 0xc91c,		0x21, 0
	.dw 0x17c0, 0xc91c,	0x17ff, 0xc91c,		0x21, 0
	.dw 0x1840, 0xc91c,	0x187f, 0xc91c,		0x21, 0
	.dw 0x18c0, 0xc91c,	0x18ff, 0xc91c,		0x21, 0
	.dw 0x1940, 0xc91c,	0x197f, 0xc91c,		0x21, 0
	.dw 0x19c0, 0xc91c,	0x1fff, 0xc91c,		0x21, 0
	.dw 0x2040, 0xc91c,	0x207f, 0xc91c,		0x21, 0
	.dw 0x20c0, 0xc91c,	0x20ff, 0xc91c,		0x21, 0
	.dw 0x2140, 0xc91c,	0x217f, 0xc91c,		0x21, 0
	.dw 0x21c0, 0xc91c,	0x21ff, 0xc91c,		0x21, 0
	.dw 0x2240, 0xc91c,	0x227f, 0xc91c,		0x21, 0
	.dw 0x22c0, 0xc91c,	0x22ff, 0xc91c,		0x21, 0
	.dw 0x2340, 0xc91c,	0x237f, 0xc91c,		0x21, 0
	.dw 0x23c0, 0xc91c,	0x23ff, 0xc91c,		0x21, 0
	.dw 0x2440, 0xc91c,	0x247f, 0xc91c,		0x21, 0
	.dw 0x24c0, 0xc91c,	0x24ff, 0xc91c,		0x21, 0
	.dw 0x2540, 0xc91c,	0x257f, 0xc91c,		0x21, 0
	.dw 0x25c0, 0xc91c,	0x25ff, 0xc91c,		0x21, 0
	.dw 0x2640, 0xc91c,	0x267f, 0xc91c,		0x21, 0
	.dw 0x26c0, 0xc91c,	0x26ff, 0xc91c,		0x21, 0
	.dw 0x2740, 0xc91c,	0x277f, 0xc91c,		0x21, 0
	.dw 0x27c0, 0xc91c,	0x27ff, 0xc91c,		0x21, 0
	.dw 0x2840, 0xc91c,	0x287f, 0xc91c,		0x21, 0
	.dw 0x28c0, 0xc91c,	0x28ff, 0xc91c,		0x21, 0
	.dw 0x2940, 0xc91c,	0x297f, 0xc91c,		0x21, 0
	.dw 0x29c0, 0xc91c,	0x29ff, 0xc91c,		0x21, 0
	.dw 0x2a40, 0xc91c,	0x2a7f, 0xc91c,		0x21, 0
	.dw 0x2ac0, 0xc91c,	0x2aff, 0xc91c,		0x21, 0
	.dw 0x2b40, 0xc91c,	0x2b7f, 0xc91c,		0x21, 0
	.dw 0x2bc0, 0xc91c,	0x2bff, 0xc91c,		0x21, 0
	.dw 0x2c40, 0xc91c,	0x2c7f, 0xc91c,		0x21, 0
	.dw 0x2cc0, 0xc91c,	0x2cff, 0xc91c,		0x21, 0
	.dw 0x2d40, 0xc91c,	0x2d7f, 0xc91c,		0x21, 0
	.dw 0x2dc0, 0xc91c,	0x2dff, 0xc91c,		0x21, 0
	.dw 0x2e40, 0xc91c,	0x2e7f, 0xc91c,		0x21, 0
	.dw 0x2ec0, 0xc91c,	0x2eff, 0xc91c,		0x21, 0
	.dw 0x2f40, 0xc91c,	0x2f7f, 0xc91c,		0x21, 0
	.dw 0x2fc0, 0xc91c,	0x2fff, 0xc91c,		0x21, 0
	.dw 0x3040, 0xc91c,	0x307f, 0xc91c,		0x21, 0
	.dw 0x30c0, 0xc91c,	0x30ff, 0xc91c,		0x21, 0
	.dw 0x3140, 0xc91c,	0x317f, 0xc91c,		0x21, 0
	.dw 0x31c0, 0xc91c,	0x31ff, 0xc91c,		0x21, 0
	.dw 0x3240, 0xc91c,	0x327f, 0xc91c,		0x21, 0
	.dw 0x32c0, 0xc91c,	0x32ff, 0xc91c,		0x21, 0
	.dw 0x3340, 0xc91c,	0x337f, 0xc91c,		0x21, 0
	.dw 0x33c0, 0xc91c,	0x33ff, 0xc91c,		0x21, 0
	.dw 0x3440, 0xc91c,	0x347f, 0xc91c,		0x21, 0
	.dw 0x34c0, 0xc91c,	0x34ff, 0xc91c,		0x21, 0
	.dw 0x3540, 0xc91c,	0x357f, 0xc91c,		0x21, 0
	.dw 0x35c0, 0xc91c,	0x35ff, 0xc91c,		0x21, 0
	.dw 0x3640, 0xc91c,	0x367f, 0xc91c,		0x21, 0
	.dw 0x36c0, 0xc91c,	0x36ff, 0xc91c,		0x21, 0
	.dw 0x3740, 0xc91c,	0x377f, 0xc91c,		0x21, 0
	.dw 0x37c0, 0xc91c,	0x37ff, 0xc91c,		0x21, 0
	.dw 0x3840, 0xc91c,	0x387f, 0xc91c,		0x21, 0
	.dw 0x38c0, 0xc91c,	0x38ff, 0xc91c,		0x21, 0
	.dw 0x3940, 0xc91c,	0x397f, 0xc91c,		0x21, 0
	.dw 0x39c0, 0xc91c,	0x3fff, 0xc91c,		0x21, 0
	.dw 0x4040, 0xc91c,	0x407f, 0xc91c,		0x21, 0
	.dw 0x40c0, 0xc91c,	0x40ff, 0xc91c,		0x21, 0
	.dw 0x4140, 0xc91c,	0x417f, 0xc91c,		0x21, 0
	.dw 0x41c0, 0xc91c,	0x41ff, 0xc91c,		0x21, 0
	.dw 0x4240, 0xc91c,	0x427f, 0xc91c,		0x21, 0
	.dw 0x42c0, 0xc91c,	0x42ff, 0xc91c,		0x21, 0
	.dw 0x4340, 0xc91c,	0x437f, 0xc91c,		0x21, 0
	.dw 0x43c0, 0xc91c,	0x43ff, 0xc91c,		0x21, 0
	.dw 0x4440, 0xc91c,	0x447f, 0xc91c,		0x21, 0
	.dw 0x44c0, 0xc91c,	0x44ff, 0xc91c,		0x21, 0
	.dw 0x4540, 0xc91c,	0x457f, 0xc91c,		0x21, 0
	.dw 0x45c0, 0xc91c,	0x45ff, 0xc91c,		0x21, 0
	.dw 0x4640, 0xc91c,	0x467f, 0xc91c,		0x21, 0
	.dw 0x46c0, 0xc91c,	0x46ff, 0xc91c,		0x21, 0
	.dw 0x4740, 0xc91c,	0x477f, 0xc91c,		0x21, 0
	.dw 0x47c0, 0xc91c,	0x47ff, 0xc91c,		0x21, 0
	.dw 0x4840, 0xc91c,	0x487f, 0xc91c,		0x21, 0
	.dw 0x48c0, 0xc91c,	0x48ff, 0xc91c,		0x21, 0
	.dw 0x4940, 0xc91c,	0x497f, 0xc91c,		0x21, 0
	.dw 0x49c0, 0xc91c,	0x49ff, 0xc91c,		0x21, 0
	.dw 0x4a40, 0xc91c,	0x4a7f, 0xc91c,		0x21, 0
	.dw 0x4ac0, 0xc91c,	0x4aff, 0xc91c,		0x21, 0
	.dw 0x4b40, 0xc91c,	0x4b7f, 0xc91c,		0x21, 0
	.dw 0x4bc0, 0xc91c,	0x4bff, 0xc91c,		0x21, 0
	.dw 0x4c40, 0xc91c,	0x4c7f, 0xc91c,		0x21, 0
	.dw 0x4cc0, 0xc91c,	0x4cff, 0xc91c,		0x21, 0
	.dw 0x4d40, 0xc91c,	0x4d7f, 0xc91c,		0x21, 0
	.dw 0x4dc0, 0xc91c,	0x4dff, 0xc91c,		0x21, 0
	.dw 0x4e40, 0xc91c,	0x4e7f, 0xc91c,		0x21, 0
	.dw 0x4ec0, 0xc91c,	0x4eff, 0xc91c,		0x21, 0
	.dw 0x4f40, 0xc91c,	0x4f7f, 0xc91c,		0x21, 0
	.dw 0x4fc0, 0xc91c,	0x4fff, 0xc91c,		0x21, 0
	.dw 0x5040, 0xc91c,	0x507f, 0xc91c,		0x21, 0
	.dw 0x50c0, 0xc91c,	0x50ff, 0xc91c,		0x21, 0
	.dw 0x5140, 0xc91c,	0x517f, 0xc91c,		0x21, 0
	.dw 0x51c0, 0xc91c,	0x51ff, 0xc91c,		0x21, 0
	.dw 0x5240, 0xc91c,	0x527f, 0xc91c,		0x21, 0
	.dw 0x52c0, 0xc91c,	0x52ff, 0xc91c,		0x21, 0
	.dw 0x5340, 0xc91c,	0x537f, 0xc91c,		0x21, 0
	.dw 0x53c0, 0xc91c,	0x53ff, 0xc91c,		0x21, 0
	.dw 0x5440, 0xc91c,	0x547f, 0xc91c,		0x21, 0
	.dw 0x54c0, 0xc91c,	0x54ff, 0xc91c,		0x21, 0
	.dw 0x5540, 0xc91c,	0x557f, 0xc91c,		0x21, 0
	.dw 0x55c0, 0xc91c,	0x55ff, 0xc91c,		0x21, 0
	.dw 0x5640, 0xc91c,	0x567f, 0xc91c,		0x21, 0
	.dw 0x56c0, 0xc91c,	0x56ff, 0xc91c,		0x21, 0
	.dw 0x5740, 0xc91c,	0x577f, 0xc91c,		0x21, 0
	.dw 0x57c0, 0xc91c,	0x57ff, 0xc91c,		0x21, 0
	.dw 0x5840, 0xc91c,	0x587f, 0xc91c,		0x21, 0
	.dw 0x58c0, 0xc91c,	0x58ff, 0xc91c,		0x21, 0
	.dw 0x5940, 0xc91c,	0x597f, 0xc91c,		0x21, 0
	.dw 0x59c0, 0xc91c,	0x5fff, 0xc91c,		0x21, 0
	.dw 0x6040, 0xc91c,	0x607f, 0xc91c,		0x21, 0
	.dw 0x60c0, 0xc91c,	0x60ff, 0xc91c,		0x21, 0
	.dw 0x6140, 0xc91c,	0x617f, 0xc91c,		0x21, 0
	.dw 0x61c0, 0xc91c,	0x61ff, 0xc91c,		0x21, 0
	.dw 0x6240, 0xc91c,	0x627f, 0xc91c,		0x21, 0
	.dw 0x62c0, 0xc91c,	0x62ff, 0xc91c,		0x21, 0
	.dw 0x6340, 0xc91c,	0x637f, 0xc91c,		0x21, 0
	.dw 0x63c0, 0xc91c,	0x63ff, 0xc91c,		0x21, 0
	.dw 0x6440, 0xc91c,	0x647f, 0xc91c,		0x21, 0
	.dw 0x64c0, 0xc91c,	0x64ff, 0xc91c,		0x21, 0
	.dw 0x6540, 0xc91c,	0x657f, 0xc91c,		0x21, 0
	.dw 0x65c0, 0xc91c,	0x65ff, 0xc91c,		0x21, 0
	.dw 0x6640, 0xc91c,	0x667f, 0xc91c,		0x21, 0
	.dw 0x66c0, 0xc91c,	0x66ff, 0xc91c,		0x21, 0
	.dw 0x6740, 0xc91c,	0x677f, 0xc91c,		0x21, 0
	.dw 0x67c0, 0xc91c,	0x67ff, 0xc91c,		0x21, 0
	.dw 0x6840, 0xc91c,	0x687f, 0xc91c,		0x21, 0
	.dw 0x68c0, 0xc91c,	0x68ff, 0xc91c,		0x21, 0
	.dw 0x6940, 0xc91c,	0x697f, 0xc91c,		0x21, 0
	.dw 0x69c0, 0xc91c,	0x69ff, 0xc91c,		0x21, 0
	.dw 0x6a40, 0xc91c,	0x6a7f, 0xc91c,		0x21, 0
	.dw 0x6ac0, 0xc91c,	0x6aff, 0xc91c,		0x21, 0
	.dw 0x6b40, 0xc91c,	0x6b7f, 0xc91c,		0x21, 0
	.dw 0x6bc0, 0xc91c,	0x6bff, 0xc91c,		0x21, 0
	.dw 0x6c40, 0xc91c,	0x6c7f, 0xc91c,		0x21, 0
	.dw 0x6cc0, 0xc91c,	0x6cff, 0xc91c,		0x21, 0
	.dw 0x6d40, 0xc91c,	0x6d7f, 0xc91c,		0x21, 0
	.dw 0x6dc0, 0xc91c,	0x6dff, 0xc91c,		0x21, 0
	.dw 0x6e40, 0xc91c,	0x6e7f, 0xc91c,		0x21, 0
	.dw 0x6ec0, 0xc91c,	0x6eff, 0xc91c,		0x21, 0
	.dw 0x6f40, 0xc91c,	0x6f7f, 0xc91c,		0x21, 0
	.dw 0x6fc0, 0xc91c,	0x6fff, 0xc91c,		0x21, 0
	.dw 0x7040, 0xc91c,	0x707f, 0xc91c,		0x21, 0
	.dw 0x70c0, 0xc91c,	0x70ff, 0xc91c,		0x21, 0
	.dw 0x7140, 0xc91c,	0x717f, 0xc91c,		0x21, 0
	.dw 0x71c0, 0xc91c,	0x71ff, 0xc91c,		0x21, 0
	.dw 0x7240, 0xc91c,	0x727f, 0xc91c,		0x21, 0
	.dw 0x72c0, 0xc91c,	0x72ff, 0xc91c,		0x21, 0
	.dw 0x7340, 0xc91c,	0x737f, 0xc91c,		0x21, 0
	.dw 0x73c0, 0xc91c,	0x73ff, 0xc91c,		0x21, 0
	.dw 0x7440, 0xc91c,	0x747f, 0xc91c,		0x21, 0
	.dw 0x74c0, 0xc91c,	0x74ff, 0xc91c,		0x21, 0
	.dw 0x7540, 0xc91c,	0x757f, 0xc91c,		0x21, 0
	.dw 0x75c0, 0xc91c,	0x75ff, 0xc91c,		0x21, 0
	.dw 0x7640, 0xc91c,	0x767f, 0xc91c,		0x21, 0
	.dw 0x76c0, 0xc91c,	0x76ff, 0xc91c,		0x21, 0
	.dw 0x7740, 0xc91c,	0x777f, 0xc91c,		0x21, 0
	.dw 0x77c0, 0xc91c,	0x77ff, 0xc91c,		0x21, 0
	.dw 0x7840, 0xc91c,	0x787f, 0xc91c,		0x21, 0
	.dw 0x78c0, 0xc91c,	0x78ff, 0xc91c,		0x21, 0
	.dw 0x7940, 0xc91c,	0x797f, 0xc91c,		0x21, 0
	.dw 0x79c0, 0xc91c,	0x7fff, 0xc91c,		0x21, 0
	.dw 0x8040, 0xc91c,	0x807f, 0xc91c,		0x21, 0
	.dw 0x80c0, 0xc91c,	0x80ff, 0xc91c,		0x21, 0
	.dw 0x8140, 0xc91c,	0x817f, 0xc91c,		0x21, 0
	.dw 0x81c0, 0xc91c,	0x81ff, 0xc91c,		0x21, 0
	.dw 0x8240, 0xc91c,	0x827f, 0xc91c,		0x21, 0
	.dw 0x82c0, 0xc91c,	0x82ff, 0xc91c,		0x21, 0
	.dw 0x8340, 0xc91c,	0x837f, 0xc91c,		0x21, 0
	.dw 0x83c0, 0xc91c,	0x83ff, 0xc91c,		0x21, 0
	.dw 0x8440, 0xc91c,	0x847f, 0xc91c,		0x21, 0
	.dw 0x84c0, 0xc91c,	0x84ff, 0xc91c,		0x21, 0
	.dw 0x8540, 0xc91c,	0x857f, 0xc91c,		0x21, 0
	.dw 0x85c0, 0xc91c,	0x85ff, 0xc91c,		0x21, 0
	.dw 0x8640, 0xc91c,	0x867f, 0xc91c,		0x21, 0
	.dw 0x86c0, 0xc91c,	0x86ff, 0xc91c,		0x21, 0
	.dw 0x8740, 0xc91c,	0x877f, 0xc91c,		0x21, 0
	.dw 0x87c0, 0xc91c,	0x87ff, 0xc91c,		0x21, 0
	.dw 0x8840, 0xc91c,	0x887f, 0xc91c,		0x21, 0
	.dw 0x88c0, 0xc91c,	0x88ff, 0xc91c,		0x21, 0
	.dw 0x8940, 0xc91c,	0x897f, 0xc91c,		0x21, 0
	.dw 0x89c0, 0xc91c,	0x89ff, 0xc91c,		0x21, 0
	.dw 0x8a40, 0xc91c,	0x8a7f, 0xc91c,		0x21, 0
	.dw 0x8ac0, 0xc91c,	0x8aff, 0xc91c,		0x21, 0
	.dw 0x8b40, 0xc91c,	0x8b7f, 0xc91c,		0x21, 0
	.dw 0x8bc0, 0xc91c,	0x8bff, 0xc91c,		0x21, 0
	.dw 0x8c40, 0xc91c,	0x8c7f, 0xc91c,		0x21, 0
	.dw 0x8cc0, 0xc91c,	0x8cff, 0xc91c,		0x21, 0
	.dw 0x8d40, 0xc91c,	0x8d7f, 0xc91c,		0x21, 0
	.dw 0x8dc0, 0xc91c,	0x8dff, 0xc91c,		0x21, 0
	.dw 0x8e40, 0xc91c,	0x8e7f, 0xc91c,		0x21, 0
	.dw 0x8ec0, 0xc91c,	0x8eff, 0xc91c,		0x21, 0
	.dw 0x8f40, 0xc91c,	0x8f7f, 0xc91c,		0x21, 0
	.dw 0x8fc0, 0xc91c,	0x8fff, 0xc91c,		0x21, 0
	.dw 0x9040, 0xc91c,	0x907f, 0xc91c,		0x21, 0
	.dw 0x90c0, 0xc91c,	0x90ff, 0xc91c,		0x21, 0
	.dw 0x9140, 0xc91c,	0x917f, 0xc91c,		0x21, 0
	.dw 0x91c0, 0xc91c,	0x91ff, 0xc91c,		0x21, 0
	.dw 0x9240, 0xc91c,	0x927f, 0xc91c,		0x21, 0
	.dw 0x92c0, 0xc91c,	0x92ff, 0xc91c,		0x21, 0
	.dw 0x9340, 0xc91c,	0x937f, 0xc91c,		0x21, 0
	.dw 0x93c0, 0xc91c,	0x93ff, 0xc91c,		0x21, 0
	.dw 0x9440, 0xc91c,	0x947f, 0xc91c,		0x21, 0
	.dw 0x94c0, 0xc91c,	0x94ff, 0xc91c,		0x21, 0
	.dw 0x9540, 0xc91c,	0x957f, 0xc91c,		0x21, 0
	.dw 0x95c0, 0xc91c,	0x95ff, 0xc91c,		0x21, 0
	.dw 0x9640, 0xc91c,	0x967f, 0xc91c,		0x21, 0
	.dw 0x96c0, 0xc91c,	0x96ff, 0xc91c,		0x21, 0
	.dw 0x9740, 0xc91c,	0x977f, 0xc91c,		0x21, 0
	.dw 0x97c0, 0xc91c,	0x97ff, 0xc91c,		0x21, 0
	.dw 0x9840, 0xc91c,	0x987f, 0xc91c,		0x21, 0
	.dw 0x98c0, 0xc91c,	0x98ff, 0xc91c,		0x21, 0
	.dw 0x9940, 0xc91c,	0x997f, 0xc91c,		0x21, 0
	.dw 0x99c0, 0xc91c,	0x9fff, 0xc91c,		0x21, 0
	.dw 0xa040, 0xc91c,	0xa07f, 0xc91c,		0x21, 0
	.dw 0xa0c0, 0xc91c,	0xa0ff, 0xc91c,		0x21, 0
	.dw 0xa140, 0xc91c,	0xa17f, 0xc91c,		0x21, 0
	.dw 0xa1c0, 0xc91c,	0xa1ff, 0xc91c,		0x21, 0
	.dw 0xa240, 0xc91c,	0xa27f, 0xc91c,		0x21, 0
	.dw 0xa2c0, 0xc91c,	0xa2ff, 0xc91c,		0x21, 0
	.dw 0xa340, 0xc91c,	0xa37f, 0xc91c,		0x21, 0
	.dw 0xa3c0, 0xc91c,	0xa3ff, 0xc91c,		0x21, 0
	.dw 0xa440, 0xc91c,	0xa47f, 0xc91c,		0x21, 0
	.dw 0xa4c0, 0xc91c,	0xa4ff, 0xc91c,		0x21, 0
	.dw 0xa540, 0xc91c,	0xa57f, 0xc91c,		0x21, 0
	.dw 0xa5c0, 0xc91c,	0xa5ff, 0xc91c,		0x21, 0
	.dw 0xa640, 0xc91c,	0xa67f, 0xc91c,		0x21, 0
	.dw 0xa6c0, 0xc91c,	0xa6ff, 0xc91c,		0x21, 0
	.dw 0xa740, 0xc91c,	0xa77f, 0xc91c,		0x21, 0
	.dw 0xa7c0, 0xc91c,	0xa7ff, 0xc91c,		0x21, 0
	.dw 0xa840, 0xc91c,	0xa87f, 0xc91c,		0x21, 0
	.dw 0xa8c0, 0xc91c,	0xa8ff, 0xc91c,		0x21, 0
	.dw 0xa940, 0xc91c,	0xa97f, 0xc91c,		0x21, 0
	.dw 0xa9c0, 0xc91c,	0xa9ff, 0xc91c,		0x21, 0
	.dw 0xaa40, 0xc91c,	0xaa7f, 0xc91c,		0x21, 0
	.dw 0xaac0, 0xc91c,	0xaaff, 0xc91c,		0x21, 0
	.dw 0xab40, 0xc91c,	0xab7f, 0xc91c,		0x21, 0
	.dw 0xabc0, 0xc91c,	0xabff, 0xc91c,		0x21, 0
	.dw 0xac40, 0xc91c,	0xac7f, 0xc91c,		0x21, 0
	.dw 0xacc0, 0xc91c,	0xacff, 0xc91c,		0x21, 0
	.dw 0xad40, 0xc91c,	0xad7f, 0xc91c,		0x21, 0
	.dw 0xadc0, 0xc91c,	0xadff, 0xc91c,		0x21, 0
	.dw 0xae40, 0xc91c,	0xae7f, 0xc91c,		0x21, 0
	.dw 0xaec0, 0xc91c,	0xaeff, 0xc91c,		0x21, 0
	.dw 0xaf40, 0xc91c,	0xaf7f, 0xc91c,		0x21, 0
	.dw 0xafc0, 0xc91c,	0xafff, 0xc91c,		0x21, 0
	.dw 0xb040, 0xc91c,	0xb07f, 0xc91c,		0x21, 0
	.dw 0xb0c0, 0xc91c,	0xb0ff, 0xc91c,		0x21, 0
	.dw 0xb140, 0xc91c,	0xb17f, 0xc91c,		0x21, 0
	.dw 0xb1c0, 0xc91c,	0xb1ff, 0xc91c,		0x21, 0
	.dw 0xb240, 0xc91c,	0xb27f, 0xc91c,		0x21, 0
	.dw 0xb2c0, 0xc91c,	0xb2ff, 0xc91c,		0x21, 0
	.dw 0xb340, 0xc91c,	0xb37f, 0xc91c,		0x21, 0
	.dw 0xb3c0, 0xc91c,	0xb3ff, 0xc91c,		0x21, 0
	.dw 0xb440, 0xc91c,	0xb47f, 0xc91c,		0x21, 0
	.dw 0xb4c0, 0xc91c,	0xb4ff, 0xc91c,		0x21, 0
	.dw 0xb540, 0xc91c,	0xb57f, 0xc91c,		0x21, 0
	.dw 0xb5c0, 0xc91c,	0xb5ff, 0xc91c,		0x21, 0
	.dw 0xb640, 0xc91c,	0xb67f, 0xc91c,		0x21, 0
	.dw 0xb6c0, 0xc91c,	0xb6ff, 0xc91c,		0x21, 0
	.dw 0xb740, 0xc91c,	0xb77f, 0xc91c,		0x21, 0
	.dw 0xb7c0, 0xc91c,	0xb7ff, 0xc91c,		0x21, 0
	.dw 0xb840, 0xc91c,	0xb87f, 0xc91c,		0x21, 0
	.dw 0xb8c0, 0xc91c,	0xb8ff, 0xc91c,		0x21, 0
	.dw 0xb940, 0xc91c,	0xb97f, 0xc91c,		0x21, 0
	.dw 0xb9c0, 0xc91c,	0xbfff, 0xc91c,		0x21, 0
	.dw 0xc040, 0xc91c,	0xc07f, 0xc91c,		0x21, 0
	.dw 0xc0c0, 0xc91c,	0xc0ff, 0xc91c,		0x21, 0
	.dw 0xc140, 0xc91c,	0xc17f, 0xc91c,		0x21, 0
	.dw 0xc1c0, 0xc91c,	0xc1ff, 0xc91c,		0x21, 0
	.dw 0xc240, 0xc91c,	0xc27f, 0xc91c,		0x21, 0
	.dw 0xc2c0, 0xc91c,	0xc2ff, 0xc91c,		0x21, 0
	.dw 0xc340, 0xc91c,	0xc37f, 0xc91c,		0x21, 0
	.dw 0xc3c0, 0xc91c,	0xc3ff, 0xc91c,		0x21, 0
	.dw 0xc440, 0xc91c,	0xc47f, 0xc91c,		0x21, 0
	.dw 0xc4c0, 0xc91c,	0xc4ff, 0xc91c,		0x21, 0
	.dw 0xc540, 0xc91c,	0xc57f, 0xc91c,		0x21, 0
	.dw 0xc5c0, 0xc91c,	0xc5ff, 0xc91c,		0x21, 0
	.dw 0xc640, 0xc91c,	0xc67f, 0xc91c,		0x21, 0
	.dw 0xc6c0, 0xc91c,	0xc6ff, 0xc91c,		0x21, 0
	.dw 0xc740, 0xc91c,	0xc77f, 0xc91c,		0x21, 0
	.dw 0xc7c0, 0xc91c,	0xc7ff, 0xc91c,		0x21, 0
	.dw 0xc840, 0xc91c,	0xc87f, 0xc91c,		0x21, 0
	.dw 0xc8c0, 0xc91c,	0xc8ff, 0xc91c,		0x21, 0
	.dw 0xc940, 0xc91c,	0xc97f, 0xc91c,		0x21, 0
	.dw 0xc9c0, 0xc91c,	0xc9ff, 0xc91c,		0x21, 0
	.dw 0xca40, 0xc91c,	0xca7f, 0xc91c,		0x21, 0
	.dw 0xcac0, 0xc91c,	0xcaff, 0xc91c,		0x21, 0
	.dw 0xcb40, 0xc91c,	0xcb7f, 0xc91c,		0x21, 0
	.dw 0xcbc0, 0xc91c,	0xcbff, 0xc91c,		0x21, 0
	.dw 0xcc40, 0xc91c,	0xcc7f, 0xc91c,		0x21, 0
	.dw 0xccc0, 0xc91c,	0xccff, 0xc91c,		0x21, 0
	.dw 0xcd40, 0xc91c,	0xcd7f, 0xc91c,		0x21, 0
	.dw 0xcdc0, 0xc91c,	0xcdff, 0xc91c,		0x21, 0
	.dw 0xce40, 0xc91c,	0xce7f, 0xc91c,		0x21, 0
	.dw 0xcec0, 0xc91c,	0xceff, 0xc91c,		0x21, 0
	.dw 0xcf40, 0xc91c,	0xcf7f, 0xc91c,		0x21, 0
	.dw 0xcfc0, 0xc91c,	0xcfff, 0xc91c,		0x21, 0
	.dw 0xd040, 0xc91c,	0xd07f, 0xc91c,		0x21, 0
	.dw 0xd0c0, 0xc91c,	0xd0ff, 0xc91c,		0x21, 0
	.dw 0xd140, 0xc91c,	0xd17f, 0xc91c,		0x21, 0
	.dw 0xd1c0, 0xc91c,	0xd1ff, 0xc91c,		0x21, 0
	.dw 0xd240, 0xc91c,	0xd27f, 0xc91c,		0x21, 0
	.dw 0xd2c0, 0xc91c,	0xd2ff, 0xc91c,		0x21, 0
	.dw 0xd340, 0xc91c,	0xd37f, 0xc91c,		0x21, 0
	.dw 0xd3c0, 0xc91c,	0xd3ff, 0xc91c,		0x21, 0
	.dw 0xd440, 0xc91c,	0xd47f, 0xc91c,		0x21, 0
	.dw 0xd4c0, 0xc91c,	0xd4ff, 0xc91c,		0x21, 0
	.dw 0xd540, 0xc91c,	0xd57f, 0xc91c,		0x21, 0
	.dw 0xd5c0, 0xc91c,	0xd5ff, 0xc91c,		0x21, 0
	.dw 0xd640, 0xc91c,	0xd67f, 0xc91c,		0x21, 0
	.dw 0xd6c0, 0xc91c,	0xd6ff, 0xc91c,		0x21, 0
	.dw 0xd740, 0xc91c,	0xd77f, 0xc91c,		0x21, 0
	.dw 0xd7c0, 0xc91c,	0xd7ff, 0xc91c,		0x21, 0
	.dw 0xd840, 0xc91c,	0xd87f, 0xc91c,		0x21, 0
	.dw 0xd8c0, 0xc91c,	0xd8ff, 0xc91c,		0x21, 0
	.dw 0xd940, 0xc91c,	0xd97f, 0xc91c,		0x21, 0
	.dw 0xd9c0, 0xc91c,	0xdfff, 0xc91c,		0x21, 0
	.dw 0xe040, 0xc91c,	0xe07f, 0xc91c,		0x21, 0
	.dw 0xe0c0, 0xc91c,	0xe0ff, 0xc91c,		0x21, 0
	.dw 0xe140, 0xc91c,	0xe17f, 0xc91c,		0x21, 0
	.dw 0xe1c0, 0xc91c,	0xe1ff, 0xc91c,		0x21, 0
	.dw 0xe240, 0xc91c,	0xe27f, 0xc91c,		0x21, 0
	.dw 0xe2c0, 0xc91c,	0xe2ff, 0xc91c,		0x21, 0
	.dw 0xe340, 0xc91c,	0xe37f, 0xc91c,		0x21, 0
	.dw 0xe3c0, 0xc91c,	0xe3ff, 0xc91c,		0x21, 0
	.dw 0xe440, 0xc91c,	0xe47f, 0xc91c,		0x21, 0
	.dw 0xe4c0, 0xc91c,	0xe4ff, 0xc91c,		0x21, 0
	.dw 0xe540, 0xc91c,	0xe57f, 0xc91c,		0x21, 0
	.dw 0xe5c0, 0xc91c,	0xe5ff, 0xc91c,		0x21, 0
	.dw 0xe640, 0xc91c,	0xe67f, 0xc91c,		0x21, 0
	.dw 0xe6c0, 0xc91c,	0xe6ff, 0xc91c,		0x21, 0
	.dw 0xe740, 0xc91c,	0xe77f, 0xc91c,		0x21, 0
	.dw 0xe7c0, 0xc91c,	0xe7ff, 0xc91c,		0x21, 0
	.dw 0xe840, 0xc91c,	0xe87f, 0xc91c,		0x21, 0
	.dw 0xe8c0, 0xc91c,	0xe8ff, 0xc91c,		0x21, 0
	.dw 0xe940, 0xc91c,	0xe97f, 0xc91c,		0x21, 0
	.dw 0xe9c0, 0xc91c,	0xe9ff, 0xc91c,		0x21, 0
	.dw 0xea40, 0xc91c,	0xea7f, 0xc91c,		0x21, 0
	.dw 0xeac0, 0xc91c,	0xeaff, 0xc91c,		0x21, 0
	.dw 0xeb40, 0xc91c,	0xeb7f, 0xc91c,		0x21, 0
	.dw 0xebc0, 0xc91c,	0xebff, 0xc91c,		0x21, 0
	.dw 0xec40, 0xc91c,	0xec7f, 0xc91c,		0x21, 0
	.dw 0xecc0, 0xc91c,	0xecff, 0xc91c,		0x21, 0
	.dw 0xed40, 0xc91c,	0xed7f, 0xc91c,		0x21, 0
	.dw 0xedc0, 0xc91c,	0xedff, 0xc91c,		0x21, 0
	.dw 0xee40, 0xc91c,	0xee7f, 0xc91c,		0x21, 0
	.dw 0xeec0, 0xc91c,	0xeeff, 0xc91c,		0x21, 0
	.dw 0xef40, 0xc91c,	0xef7f, 0xc91c,		0x21, 0
	.dw 0xefc0, 0xc91c,	0xefff, 0xc91c,		0x21, 0
	.dw 0xf040, 0xc91c,	0xf07f, 0xc91c,		0x21, 0
	.dw 0xf0c0, 0xc91c,	0xf0ff, 0xc91c,		0x21, 0
	.dw 0xf140, 0xc91c,	0xf17f, 0xc91c,		0x21, 0
	.dw 0xf1c0, 0xc91c,	0xf1ff, 0xc91c,		0x21, 0
	.dw 0xf240, 0xc91c,	0xf27f, 0xc91c,		0x21, 0
	.dw 0xf2c0, 0xc91c,	0xf2ff, 0xc91c,		0x21, 0
	.dw 0xf340, 0xc91c,	0xf37f, 0xc91c,		0x21, 0
	.dw 0xf3c0, 0xc91c,	0xf3ff, 0xc91c,		0x21, 0
	.dw 0xf440, 0xc91c,	0xf47f, 0xc91c,		0x21, 0
	.dw 0xf4c0, 0xc91c,	0xf4ff, 0xc91c,		0x21, 0
	.dw 0xf540, 0xc91c,	0xf57f, 0xc91c,		0x21, 0
	.dw 0xf5c0, 0xc91c,	0xf5ff, 0xc91c,		0x21, 0
	.dw 0xf640, 0xc91c,	0xf67f, 0xc91c,		0x21, 0
	.dw 0xf6c0, 0xc91c,	0xf6ff, 0xc91c,		0x21, 0
	.dw 0xf740, 0xc91c,	0xf77f, 0xc91c,		0x21, 0
	.dw 0xf7c0, 0xc91c,	0xf7ff, 0xc91c,		0x21, 0
	.dw 0xf840, 0xc91c,	0xf87f, 0xc91c,		0x21, 0
	.dw 0xf8c0, 0xc91c,	0xf8ff, 0xc91c,		0x21, 0
	.dw 0xf940, 0xc91c,	0xf97f, 0xc91c,		0x21, 0
	.dw 0xf9c0, 0xc91c,	0xffff, 0xc91c,		0x21, 0
	.dw 0x0040, 0xc91d,	0x007f, 0xc91d,		0x21, 0
	.dw 0x00c0, 0xc91d,	0x00ff, 0xc91d,		0x21, 0
	.dw 0x0140, 0xc91d,	0x017f, 0xc91d,		0x21, 0
	.dw 0x01c0, 0xc91d,	0x01ff, 0xc91d,		0x21, 0
	.dw 0x0240, 0xc91d,	0x027f, 0xc91d,		0x21, 0
	.dw 0x02c0, 0xc91d,	0x02ff, 0xc91d,		0x21, 0
	.dw 0x0340, 0xc91d,	0x037f, 0xc91d,		0x21, 0
	.dw 0x03c0, 0xc91d,	0x03ff, 0xc91d,		0x21, 0
	.dw 0x0440, 0xc91d,	0x047f, 0xc91d,		0x21, 0
	.dw 0x04c0, 0xc91d,	0x04ff, 0xc91d,		0x21, 0
	.dw 0x0540, 0xc91d,	0x057f, 0xc91d,		0x21, 0
	.dw 0x05c0, 0xc91d,	0x05ff, 0xc91d,		0x21, 0
	.dw 0x0640, 0xc91d,	0x067f, 0xc91d,		0x21, 0
	.dw 0x06c0, 0xc91d,	0x06ff, 0xc91d,		0x21, 0
	.dw 0x0740, 0xc91d,	0x077f, 0xc91d,		0x21, 0
	.dw 0x07c0, 0xc91d,	0x07ff, 0xc91d,		0x21, 0
	.dw 0x0840, 0xc91d,	0x087f, 0xc91d,		0x21, 0
	.dw 0x08c0, 0xc91d,	0x08ff, 0xc91d,		0x21, 0
	.dw 0x0940, 0xc91d,	0x097f, 0xc91d,		0x21, 0
	.dw 0x09c0, 0xc91d,	0x09ff, 0xc91d,		0x21, 0
	.dw 0x0a40, 0xc91d,	0x0a7f, 0xc91d,		0x21, 0
	.dw 0x0ac0, 0xc91d,	0x0aff, 0xc91d,		0x21, 0
	.dw 0x0b40, 0xc91d,	0x0b7f, 0xc91d,		0x21, 0
	.dw 0x0bc0, 0xc91d,	0x0bff, 0xc91d,		0x21, 0
	.dw 0x0c40, 0xc91d,	0x0c7f, 0xc91d,		0x21, 0
	.dw 0x0cc0, 0xc91d,	0x0cff, 0xc91d,		0x21, 0
	.dw 0x0d40, 0xc91d,	0x0d7f, 0xc91d,		0x21, 0
	.dw 0x0dc0, 0xc91d,	0x0dff, 0xc91d,		0x21, 0
	.dw 0x0e40, 0xc91d,	0x0e7f, 0xc91d,		0x21, 0
	.dw 0x0ec0, 0xc91d,	0x0eff, 0xc91d,		0x21, 0
	.dw 0x0f40, 0xc91d,	0x0f7f, 0xc91d,		0x21, 0
	.dw 0x0fc0, 0xc91d,	0x0fff, 0xc91d,		0x21, 0
	.dw 0x1040, 0xc91d,	0x107f, 0xc91d,		0x21, 0
	.dw 0x10c0, 0xc91d,	0x10ff, 0xc91d,		0x21, 0
	.dw 0x1140, 0xc91d,	0x117f, 0xc91d,		0x21, 0
	.dw 0x11c0, 0xc91d,	0x11ff, 0xc91d,		0x21, 0
	.dw 0x1240, 0xc91d,	0x127f, 0xc91d,		0x21, 0
	.dw 0x12c0, 0xc91d,	0x12ff, 0xc91d,		0x21, 0
	.dw 0x1340, 0xc91d,	0x137f, 0xc91d,		0x21, 0
	.dw 0x13c0, 0xc91d,	0x13ff, 0xc91d,		0x21, 0
	.dw 0x1440, 0xc91d,	0x147f, 0xc91d,		0x21, 0
	.dw 0x14c0, 0xc91d,	0x14ff, 0xc91d,		0x21, 0
	.dw 0x1540, 0xc91d,	0x157f, 0xc91d,		0x21, 0
	.dw 0x15c0, 0xc91d,	0x15ff, 0xc91d,		0x21, 0
	.dw 0x1640, 0xc91d,	0x167f, 0xc91d,		0x21, 0
	.dw 0x16c0, 0xc91d,	0x16ff, 0xc91d,		0x21, 0
	.dw 0x1740, 0xc91d,	0x177f, 0xc91d,		0x21, 0
	.dw 0x17c0, 0xc91d,	0x17ff, 0xc91d,		0x21, 0
	.dw 0x1840, 0xc91d,	0x187f, 0xc91d,		0x21, 0
	.dw 0x18c0, 0xc91d,	0x18ff, 0xc91d,		0x21, 0
	.dw 0x1940, 0xc91d,	0x197f, 0xc91d,		0x21, 0
	.dw 0x19c0, 0xc91d,	0x1fff, 0xc91d,		0x21, 0
	.dw 0x2040, 0xc91d,	0x207f, 0xc91d,		0x21, 0
	.dw 0x20c0, 0xc91d,	0x20ff, 0xc91d,		0x21, 0
	.dw 0x2140, 0xc91d,	0x217f, 0xc91d,		0x21, 0
	.dw 0x21c0, 0xc91d,	0x21ff, 0xc91d,		0x21, 0
	.dw 0x2240, 0xc91d,	0x227f, 0xc91d,		0x21, 0
	.dw 0x22c0, 0xc91d,	0x22ff, 0xc91d,		0x21, 0
	.dw 0x2340, 0xc91d,	0x237f, 0xc91d,		0x21, 0
	.dw 0x23c0, 0xc91d,	0x23ff, 0xc91d,		0x21, 0
	.dw 0x2440, 0xc91d,	0x247f, 0xc91d,		0x21, 0
	.dw 0x24c0, 0xc91d,	0x24ff, 0xc91d,		0x21, 0
	.dw 0x2540, 0xc91d,	0x257f, 0xc91d,		0x21, 0
	.dw 0x25c0, 0xc91d,	0x25ff, 0xc91d,		0x21, 0
	.dw 0x2640, 0xc91d,	0x267f, 0xc91d,		0x21, 0
	.dw 0x26c0, 0xc91d,	0x26ff, 0xc91d,		0x21, 0
	.dw 0x2740, 0xc91d,	0x277f, 0xc91d,		0x21, 0
	.dw 0x27c0, 0xc91d,	0x27ff, 0xc91d,		0x21, 0
	.dw 0x2840, 0xc91d,	0x287f, 0xc91d,		0x21, 0
	.dw 0x28c0, 0xc91d,	0x28ff, 0xc91d,		0x21, 0
	.dw 0x2940, 0xc91d,	0x297f, 0xc91d,		0x21, 0
	.dw 0x29c0, 0xc91d,	0x29ff, 0xc91d,		0x21, 0
	.dw 0x2a40, 0xc91d,	0x2a7f, 0xc91d,		0x21, 0
	.dw 0x2ac0, 0xc91d,	0x2aff, 0xc91d,		0x21, 0
	.dw 0x2b40, 0xc91d,	0x2b7f, 0xc91d,		0x21, 0
	.dw 0x2bc0, 0xc91d,	0x2bff, 0xc91d,		0x21, 0
	.dw 0x2c40, 0xc91d,	0x2c7f, 0xc91d,		0x21, 0
	.dw 0x2cc0, 0xc91d,	0x2cff, 0xc91d,		0x21, 0
	.dw 0x2d40, 0xc91d,	0x2d7f, 0xc91d,		0x21, 0
	.dw 0x2dc0, 0xc91d,	0x2dff, 0xc91d,		0x21, 0
	.dw 0x2e40, 0xc91d,	0x2e7f, 0xc91d,		0x21, 0
	.dw 0x2ec0, 0xc91d,	0x2eff, 0xc91d,		0x21, 0
	.dw 0x2f40, 0xc91d,	0x2f7f, 0xc91d,		0x21, 0
	.dw 0x2fc0, 0xc91d,	0x2fff, 0xc91d,		0x21, 0
	.dw 0x3040, 0xc91d,	0x307f, 0xc91d,		0x21, 0
	.dw 0x30c0, 0xc91d,	0x30ff, 0xc91d,		0x21, 0
	.dw 0x3140, 0xc91d,	0x317f, 0xc91d,		0x21, 0
	.dw 0x31c0, 0xc91d,	0x31ff, 0xc91d,		0x21, 0
	.dw 0x3240, 0xc91d,	0x327f, 0xc91d,		0x21, 0
	.dw 0x32c0, 0xc91d,	0x32ff, 0xc91d,		0x21, 0
	.dw 0x3340, 0xc91d,	0x337f, 0xc91d,		0x21, 0
	.dw 0x33c0, 0xc91d,	0x33ff, 0xc91d,		0x21, 0
	.dw 0x3440, 0xc91d,	0x347f, 0xc91d,		0x21, 0
	.dw 0x34c0, 0xc91d,	0x34ff, 0xc91d,		0x21, 0
	.dw 0x3540, 0xc91d,	0x357f, 0xc91d,		0x21, 0
	.dw 0x35c0, 0xc91d,	0x35ff, 0xc91d,		0x21, 0
	.dw 0x3640, 0xc91d,	0x367f, 0xc91d,		0x21, 0
	.dw 0x36c0, 0xc91d,	0x36ff, 0xc91d,		0x21, 0
	.dw 0x3740, 0xc91d,	0x377f, 0xc91d,		0x21, 0
	.dw 0x37c0, 0xc91d,	0x37ff, 0xc91d,		0x21, 0
	.dw 0x3840, 0xc91d,	0x387f, 0xc91d,		0x21, 0
	.dw 0x38c0, 0xc91d,	0x38ff, 0xc91d,		0x21, 0
	.dw 0x3940, 0xc91d,	0x397f, 0xc91d,		0x21, 0
	.dw 0x39c0, 0xc91d,	0x3fff, 0xc91d,		0x21, 0
	.dw 0x4040, 0xc91d,	0x407f, 0xc91d,		0x21, 0
	.dw 0x40c0, 0xc91d,	0x40ff, 0xc91d,		0x21, 0
	.dw 0x4140, 0xc91d,	0x417f, 0xc91d,		0x21, 0
	.dw 0x41c0, 0xc91d,	0x41ff, 0xc91d,		0x21, 0
	.dw 0x4240, 0xc91d,	0x427f, 0xc91d,		0x21, 0
	.dw 0x42c0, 0xc91d,	0x42ff, 0xc91d,		0x21, 0
	.dw 0x4340, 0xc91d,	0x437f, 0xc91d,		0x21, 0
	.dw 0x43c0, 0xc91d,	0x43ff, 0xc91d,		0x21, 0
	.dw 0x4440, 0xc91d,	0x447f, 0xc91d,		0x21, 0
	.dw 0x44c0, 0xc91d,	0x44ff, 0xc91d,		0x21, 0
	.dw 0x4540, 0xc91d,	0x457f, 0xc91d,		0x21, 0
	.dw 0x45c0, 0xc91d,	0x45ff, 0xc91d,		0x21, 0
	.dw 0x4640, 0xc91d,	0x467f, 0xc91d,		0x21, 0
	.dw 0x46c0, 0xc91d,	0x46ff, 0xc91d,		0x21, 0
	.dw 0x4740, 0xc91d,	0x477f, 0xc91d,		0x21, 0
	.dw 0x47c0, 0xc91d,	0x47ff, 0xc91d,		0x21, 0
	.dw 0x4840, 0xc91d,	0x487f, 0xc91d,		0x21, 0
	.dw 0x48c0, 0xc91d,	0x48ff, 0xc91d,		0x21, 0
	.dw 0x4940, 0xc91d,	0x497f, 0xc91d,		0x21, 0
	.dw 0x49c0, 0xc91d,	0x49ff, 0xc91d,		0x21, 0
	.dw 0x4a40, 0xc91d,	0x4a7f, 0xc91d,		0x21, 0
	.dw 0x4ac0, 0xc91d,	0x4aff, 0xc91d,		0x21, 0
	.dw 0x4b40, 0xc91d,	0x4b7f, 0xc91d,		0x21, 0
	.dw 0x4bc0, 0xc91d,	0x4bff, 0xc91d,		0x21, 0
	.dw 0x4c40, 0xc91d,	0x4c7f, 0xc91d,		0x21, 0
	.dw 0x4cc0, 0xc91d,	0x4cff, 0xc91d,		0x21, 0
	.dw 0x4d40, 0xc91d,	0x4d7f, 0xc91d,		0x21, 0
	.dw 0x4dc0, 0xc91d,	0x4dff, 0xc91d,		0x21, 0
	.dw 0x4e40, 0xc91d,	0x4e7f, 0xc91d,		0x21, 0
	.dw 0x4ec0, 0xc91d,	0x4eff, 0xc91d,		0x21, 0
	.dw 0x4f40, 0xc91d,	0x4f7f, 0xc91d,		0x21, 0
	.dw 0x4fc0, 0xc91d,	0x4fff, 0xc91d,		0x21, 0
	.dw 0x5040, 0xc91d,	0x507f, 0xc91d,		0x21, 0
	.dw 0x50c0, 0xc91d,	0x50ff, 0xc91d,		0x21, 0
	.dw 0x5140, 0xc91d,	0x517f, 0xc91d,		0x21, 0
	.dw 0x51c0, 0xc91d,	0x51ff, 0xc91d,		0x21, 0
	.dw 0x5240, 0xc91d,	0x527f, 0xc91d,		0x21, 0
	.dw 0x52c0, 0xc91d,	0x52ff, 0xc91d,		0x21, 0
	.dw 0x5340, 0xc91d,	0x537f, 0xc91d,		0x21, 0
	.dw 0x53c0, 0xc91d,	0x53ff, 0xc91d,		0x21, 0
	.dw 0x5440, 0xc91d,	0x547f, 0xc91d,		0x21, 0
	.dw 0x54c0, 0xc91d,	0x54ff, 0xc91d,		0x21, 0
	.dw 0x5540, 0xc91d,	0x557f, 0xc91d,		0x21, 0
	.dw 0x55c0, 0xc91d,	0x55ff, 0xc91d,		0x21, 0
	.dw 0x5640, 0xc91d,	0x567f, 0xc91d,		0x21, 0
	.dw 0x56c0, 0xc91d,	0x56ff, 0xc91d,		0x21, 0
	.dw 0x5740, 0xc91d,	0x577f, 0xc91d,		0x21, 0
	.dw 0x57c0, 0xc91d,	0x57ff, 0xc91d,		0x21, 0
	.dw 0x5840, 0xc91d,	0x587f, 0xc91d,		0x21, 0
	.dw 0x58c0, 0xc91d,	0x58ff, 0xc91d,		0x21, 0
	.dw 0x5940, 0xc91d,	0x597f, 0xc91d,		0x21, 0
	.dw 0x59c0, 0xc91d,	0x5fff, 0xc91d,		0x21, 0
	.dw 0x6040, 0xc91d,	0x607f, 0xc91d,		0x21, 0
	.dw 0x60c0, 0xc91d,	0x60ff, 0xc91d,		0x21, 0
	.dw 0x6140, 0xc91d,	0x617f, 0xc91d,		0x21, 0
	.dw 0x61c0, 0xc91d,	0x61ff, 0xc91d,		0x21, 0
	.dw 0x6240, 0xc91d,	0x627f, 0xc91d,		0x21, 0
	.dw 0x62c0, 0xc91d,	0x62ff, 0xc91d,		0x21, 0
	.dw 0x6340, 0xc91d,	0x637f, 0xc91d,		0x21, 0
	.dw 0x63c0, 0xc91d,	0x63ff, 0xc91d,		0x21, 0
	.dw 0x6440, 0xc91d,	0x647f, 0xc91d,		0x21, 0
	.dw 0x64c0, 0xc91d,	0x64ff, 0xc91d,		0x21, 0
	.dw 0x6540, 0xc91d,	0x657f, 0xc91d,		0x21, 0
	.dw 0x65c0, 0xc91d,	0x65ff, 0xc91d,		0x21, 0
	.dw 0x6640, 0xc91d,	0x667f, 0xc91d,		0x21, 0
	.dw 0x66c0, 0xc91d,	0x66ff, 0xc91d,		0x21, 0
	.dw 0x6740, 0xc91d,	0x677f, 0xc91d,		0x21, 0
	.dw 0x67c0, 0xc91d,	0x67ff, 0xc91d,		0x21, 0
	.dw 0x6840, 0xc91d,	0x687f, 0xc91d,		0x21, 0
	.dw 0x68c0, 0xc91d,	0x68ff, 0xc91d,		0x21, 0
	.dw 0x6940, 0xc91d,	0x697f, 0xc91d,		0x21, 0
	.dw 0x69c0, 0xc91d,	0x69ff, 0xc91d,		0x21, 0
	.dw 0x6a40, 0xc91d,	0x6a7f, 0xc91d,		0x21, 0
	.dw 0x6ac0, 0xc91d,	0x6aff, 0xc91d,		0x21, 0
	.dw 0x6b40, 0xc91d,	0x6b7f, 0xc91d,		0x21, 0
	.dw 0x6bc0, 0xc91d,	0x6bff, 0xc91d,		0x21, 0
	.dw 0x6c40, 0xc91d,	0x6c7f, 0xc91d,		0x21, 0
	.dw 0x6cc0, 0xc91d,	0x6cff, 0xc91d,		0x21, 0
	.dw 0x6d40, 0xc91d,	0x6d7f, 0xc91d,		0x21, 0
	.dw 0x6dc0, 0xc91d,	0x6dff, 0xc91d,		0x21, 0
	.dw 0x6e40, 0xc91d,	0x6e7f, 0xc91d,		0x21, 0
	.dw 0x6ec0, 0xc91d,	0x6eff, 0xc91d,		0x21, 0
	.dw 0x6f40, 0xc91d,	0x6f7f, 0xc91d,		0x21, 0
	.dw 0x6fc0, 0xc91d,	0x6fff, 0xc91d,		0x21, 0
	.dw 0x7040, 0xc91d,	0x707f, 0xc91d,		0x21, 0
	.dw 0x70c0, 0xc91d,	0x70ff, 0xc91d,		0x21, 0
	.dw 0x7140, 0xc91d,	0x717f, 0xc91d,		0x21, 0
	.dw 0x71c0, 0xc91d,	0x71ff, 0xc91d,		0x21, 0
	.dw 0x7240, 0xc91d,	0x727f, 0xc91d,		0x21, 0
	.dw 0x72c0, 0xc91d,	0x72ff, 0xc91d,		0x21, 0
	.dw 0x7340, 0xc91d,	0x737f, 0xc91d,		0x21, 0
	.dw 0x73c0, 0xc91d,	0x73ff, 0xc91d,		0x21, 0
	.dw 0x7440, 0xc91d,	0x747f, 0xc91d,		0x21, 0
	.dw 0x74c0, 0xc91d,	0x74ff, 0xc91d,		0x21, 0
	.dw 0x7540, 0xc91d,	0x757f, 0xc91d,		0x21, 0
	.dw 0x75c0, 0xc91d,	0x75ff, 0xc91d,		0x21, 0
	.dw 0x7640, 0xc91d,	0x767f, 0xc91d,		0x21, 0
	.dw 0x76c0, 0xc91d,	0x76ff, 0xc91d,		0x21, 0
	.dw 0x7740, 0xc91d,	0x777f, 0xc91d,		0x21, 0
	.dw 0x77c0, 0xc91d,	0x77ff, 0xc91d,		0x21, 0
	.dw 0x7840, 0xc91d,	0x787f, 0xc91d,		0x21, 0
	.dw 0x78c0, 0xc91d,	0x78ff, 0xc91d,		0x21, 0
	.dw 0x7940, 0xc91d,	0x797f, 0xc91d,		0x21, 0
	.dw 0x79c0, 0xc91d,	0x7fff, 0xc91d,		0x21, 0
	.dw 0x8040, 0xc91d,	0x807f, 0xc91d,		0x21, 0
	.dw 0x80c0, 0xc91d,	0x80ff, 0xc91d,		0x21, 0
	.dw 0x8140, 0xc91d,	0x817f, 0xc91d,		0x21, 0
	.dw 0x81c0, 0xc91d,	0x81ff, 0xc91d,		0x21, 0
	.dw 0x8240, 0xc91d,	0x827f, 0xc91d,		0x21, 0
	.dw 0x82c0, 0xc91d,	0x82ff, 0xc91d,		0x21, 0
	.dw 0x8340, 0xc91d,	0x837f, 0xc91d,		0x21, 0
	.dw 0x83c0, 0xc91d,	0x83ff, 0xc91d,		0x21, 0
	.dw 0x8440, 0xc91d,	0x847f, 0xc91d,		0x21, 0
	.dw 0x84c0, 0xc91d,	0x84ff, 0xc91d,		0x21, 0
	.dw 0x8540, 0xc91d,	0x857f, 0xc91d,		0x21, 0
	.dw 0x85c0, 0xc91d,	0x85ff, 0xc91d,		0x21, 0
	.dw 0x8640, 0xc91d,	0x867f, 0xc91d,		0x21, 0
	.dw 0x86c0, 0xc91d,	0x86ff, 0xc91d,		0x21, 0
	.dw 0x8740, 0xc91d,	0x877f, 0xc91d,		0x21, 0
	.dw 0x87c0, 0xc91d,	0x87ff, 0xc91d,		0x21, 0
	.dw 0x8840, 0xc91d,	0x887f, 0xc91d,		0x21, 0
	.dw 0x88c0, 0xc91d,	0x88ff, 0xc91d,		0x21, 0
	.dw 0x8940, 0xc91d,	0x897f, 0xc91d,		0x21, 0
	.dw 0x89c0, 0xc91d,	0x89ff, 0xc91d,		0x21, 0
	.dw 0x8a40, 0xc91d,	0x8a7f, 0xc91d,		0x21, 0
	.dw 0x8ac0, 0xc91d,	0x8aff, 0xc91d,		0x21, 0
	.dw 0x8b40, 0xc91d,	0x8b7f, 0xc91d,		0x21, 0
	.dw 0x8bc0, 0xc91d,	0x8bff, 0xc91d,		0x21, 0
	.dw 0x8c40, 0xc91d,	0x8c7f, 0xc91d,		0x21, 0
	.dw 0x8cc0, 0xc91d,	0x8cff, 0xc91d,		0x21, 0
	.dw 0x8d40, 0xc91d,	0x8d7f, 0xc91d,		0x21, 0
	.dw 0x8dc0, 0xc91d,	0x8dff, 0xc91d,		0x21, 0
	.dw 0x8e40, 0xc91d,	0x8e7f, 0xc91d,		0x21, 0
	.dw 0x8ec0, 0xc91d,	0x8eff, 0xc91d,		0x21, 0
	.dw 0x8f40, 0xc91d,	0x8f7f, 0xc91d,		0x21, 0
	.dw 0x8fc0, 0xc91d,	0x8fff, 0xc91d,		0x21, 0
	.dw 0x9040, 0xc91d,	0x907f, 0xc91d,		0x21, 0
	.dw 0x90c0, 0xc91d,	0x90ff, 0xc91d,		0x21, 0
	.dw 0x9140, 0xc91d,	0x917f, 0xc91d,		0x21, 0
	.dw 0x91c0, 0xc91d,	0x91ff, 0xc91d,		0x21, 0
	.dw 0x9240, 0xc91d,	0x927f, 0xc91d,		0x21, 0
	.dw 0x92c0, 0xc91d,	0x92ff, 0xc91d,		0x21, 0
	.dw 0x9340, 0xc91d,	0x937f, 0xc91d,		0x21, 0
	.dw 0x93c0, 0xc91d,	0x93ff, 0xc91d,		0x21, 0
	.dw 0x9440, 0xc91d,	0x947f, 0xc91d,		0x21, 0
	.dw 0x94c0, 0xc91d,	0x94ff, 0xc91d,		0x21, 0
	.dw 0x9540, 0xc91d,	0x957f, 0xc91d,		0x21, 0
	.dw 0x95c0, 0xc91d,	0x95ff, 0xc91d,		0x21, 0
	.dw 0x9640, 0xc91d,	0x967f, 0xc91d,		0x21, 0
	.dw 0x96c0, 0xc91d,	0x96ff, 0xc91d,		0x21, 0
	.dw 0x9740, 0xc91d,	0x977f, 0xc91d,		0x21, 0
	.dw 0x97c0, 0xc91d,	0x97ff, 0xc91d,		0x21, 0
	.dw 0x9840, 0xc91d,	0x987f, 0xc91d,		0x21, 0
	.dw 0x98c0, 0xc91d,	0x98ff, 0xc91d,		0x21, 0
	.dw 0x9940, 0xc91d,	0x997f, 0xc91d,		0x21, 0
	.dw 0x99c0, 0xc91d,	0x9fff, 0xc91d,		0x21, 0
	.dw 0xa040, 0xc91d,	0xa07f, 0xc91d,		0x21, 0
	.dw 0xa0c0, 0xc91d,	0xa0ff, 0xc91d,		0x21, 0
	.dw 0xa140, 0xc91d,	0xa17f, 0xc91d,		0x21, 0
	.dw 0xa1c0, 0xc91d,	0xa1ff, 0xc91d,		0x21, 0
	.dw 0xa240, 0xc91d,	0xa27f, 0xc91d,		0x21, 0
	.dw 0xa2c0, 0xc91d,	0xa2ff, 0xc91d,		0x21, 0
	.dw 0xa340, 0xc91d,	0xa37f, 0xc91d,		0x21, 0
	.dw 0xa3c0, 0xc91d,	0xa3ff, 0xc91d,		0x21, 0
	.dw 0xa440, 0xc91d,	0xa47f, 0xc91d,		0x21, 0
	.dw 0xa4c0, 0xc91d,	0xa4ff, 0xc91d,		0x21, 0
	.dw 0xa540, 0xc91d,	0xa57f, 0xc91d,		0x21, 0
	.dw 0xa5c0, 0xc91d,	0xa5ff, 0xc91d,		0x21, 0
	.dw 0xa640, 0xc91d,	0xa67f, 0xc91d,		0x21, 0
	.dw 0xa6c0, 0xc91d,	0xa6ff, 0xc91d,		0x21, 0
	.dw 0xa740, 0xc91d,	0xa77f, 0xc91d,		0x21, 0
	.dw 0xa7c0, 0xc91d,	0xa7ff, 0xc91d,		0x21, 0
	.dw 0xa840, 0xc91d,	0xa87f, 0xc91d,		0x21, 0
	.dw 0xa8c0, 0xc91d,	0xa8ff, 0xc91d,		0x21, 0
	.dw 0xa940, 0xc91d,	0xa97f, 0xc91d,		0x21, 0
	.dw 0xa9c0, 0xc91d,	0xa9ff, 0xc91d,		0x21, 0
	.dw 0xaa40, 0xc91d,	0xaa7f, 0xc91d,		0x21, 0
	.dw 0xaac0, 0xc91d,	0xaaff, 0xc91d,		0x21, 0
	.dw 0xab40, 0xc91d,	0xab7f, 0xc91d,		0x21, 0
	.dw 0xabc0, 0xc91d,	0xabff, 0xc91d,		0x21, 0
	.dw 0xac40, 0xc91d,	0xac7f, 0xc91d,		0x21, 0
	.dw 0xacc0, 0xc91d,	0xacff, 0xc91d,		0x21, 0
	.dw 0xad40, 0xc91d,	0xad7f, 0xc91d,		0x21, 0
	.dw 0xadc0, 0xc91d,	0xadff, 0xc91d,		0x21, 0
	.dw 0xae40, 0xc91d,	0xae7f, 0xc91d,		0x21, 0
	.dw 0xaec0, 0xc91d,	0xaeff, 0xc91d,		0x21, 0
	.dw 0xaf40, 0xc91d,	0xaf7f, 0xc91d,		0x21, 0
	.dw 0xafc0, 0xc91d,	0xafff, 0xc91d,		0x21, 0
	.dw 0xb040, 0xc91d,	0xb07f, 0xc91d,		0x21, 0
	.dw 0xb0c0, 0xc91d,	0xb0ff, 0xc91d,		0x21, 0
	.dw 0xb140, 0xc91d,	0xb17f, 0xc91d,		0x21, 0
	.dw 0xb1c0, 0xc91d,	0xb1ff, 0xc91d,		0x21, 0
	.dw 0xb240, 0xc91d,	0xb27f, 0xc91d,		0x21, 0
	.dw 0xb2c0, 0xc91d,	0xb2ff, 0xc91d,		0x21, 0
	.dw 0xb340, 0xc91d,	0xb37f, 0xc91d,		0x21, 0
	.dw 0xb3c0, 0xc91d,	0xb3ff, 0xc91d,		0x21, 0
	.dw 0xb440, 0xc91d,	0xb47f, 0xc91d,		0x21, 0
	.dw 0xb4c0, 0xc91d,	0xb4ff, 0xc91d,		0x21, 0
	.dw 0xb540, 0xc91d,	0xb57f, 0xc91d,		0x21, 0
	.dw 0xb5c0, 0xc91d,	0xb5ff, 0xc91d,		0x21, 0
	.dw 0xb640, 0xc91d,	0xb67f, 0xc91d,		0x21, 0
	.dw 0xb6c0, 0xc91d,	0xb6ff, 0xc91d,		0x21, 0
	.dw 0xb740, 0xc91d,	0xb77f, 0xc91d,		0x21, 0
	.dw 0xb7c0, 0xc91d,	0xb7ff, 0xc91d,		0x21, 0
	.dw 0xb840, 0xc91d,	0xb87f, 0xc91d,		0x21, 0
	.dw 0xb8c0, 0xc91d,	0xb8ff, 0xc91d,		0x21, 0
	.dw 0xb940, 0xc91d,	0xb97f, 0xc91d,		0x21, 0
	.dw 0xb9c0, 0xc91d,	0xbfff, 0xc91d,		0x21, 0
	.dw 0xc040, 0xc91d,	0xc07f, 0xc91d,		0x21, 0
	.dw 0xc0c0, 0xc91d,	0xc0ff, 0xc91d,		0x21, 0
	.dw 0xc140, 0xc91d,	0xc17f, 0xc91d,		0x21, 0
	.dw 0xc1c0, 0xc91d,	0xc1ff, 0xc91d,		0x21, 0
	.dw 0xc240, 0xc91d,	0xc27f, 0xc91d,		0x21, 0
	.dw 0xc2c0, 0xc91d,	0xc2ff, 0xc91d,		0x21, 0
	.dw 0xc340, 0xc91d,	0xc37f, 0xc91d,		0x21, 0
	.dw 0xc3c0, 0xc91d,	0xc3ff, 0xc91d,		0x21, 0
	.dw 0xc440, 0xc91d,	0xc47f, 0xc91d,		0x21, 0
	.dw 0xc4c0, 0xc91d,	0xc4ff, 0xc91d,		0x21, 0
	.dw 0xc540, 0xc91d,	0xc57f, 0xc91d,		0x21, 0
	.dw 0xc5c0, 0xc91d,	0xc5ff, 0xc91d,		0x21, 0
	.dw 0xc640, 0xc91d,	0xc67f, 0xc91d,		0x21, 0
	.dw 0xc6c0, 0xc91d,	0xc6ff, 0xc91d,		0x21, 0
	.dw 0xc740, 0xc91d,	0xc77f, 0xc91d,		0x21, 0
	.dw 0xc7c0, 0xc91d,	0xc7ff, 0xc91d,		0x21, 0
	.dw 0xc840, 0xc91d,	0xc87f, 0xc91d,		0x21, 0
	.dw 0xc8c0, 0xc91d,	0xc8ff, 0xc91d,		0x21, 0
	.dw 0xc940, 0xc91d,	0xc97f, 0xc91d,		0x21, 0
	.dw 0xc9c0, 0xc91d,	0xc9ff, 0xc91d,		0x21, 0
	.dw 0xca40, 0xc91d,	0xca7f, 0xc91d,		0x21, 0
	.dw 0xcac0, 0xc91d,	0xcaff, 0xc91d,		0x21, 0
	.dw 0xcb40, 0xc91d,	0xcb7f, 0xc91d,		0x21, 0
	.dw 0xcbc0, 0xc91d,	0xcbff, 0xc91d,		0x21, 0
	.dw 0xcc40, 0xc91d,	0xcc7f, 0xc91d,		0x21, 0
	.dw 0xccc0, 0xc91d,	0xccff, 0xc91d,		0x21, 0
	.dw 0xcd40, 0xc91d,	0xcd7f, 0xc91d,		0x21, 0
	.dw 0xcdc0, 0xc91d,	0xcdff, 0xc91d,		0x21, 0
	.dw 0xce40, 0xc91d,	0xce7f, 0xc91d,		0x21, 0
	.dw 0xcec0, 0xc91d,	0xceff, 0xc91d,		0x21, 0
	.dw 0xcf40, 0xc91d,	0xcf7f, 0xc91d,		0x21, 0
	.dw 0xcfc0, 0xc91d,	0xcfff, 0xc91d,		0x21, 0
	.dw 0xd040, 0xc91d,	0xd07f, 0xc91d,		0x21, 0
	.dw 0xd0c0, 0xc91d,	0xd0ff, 0xc91d,		0x21, 0
	.dw 0xd140, 0xc91d,	0xd17f, 0xc91d,		0x21, 0
	.dw 0xd1c0, 0xc91d,	0xd1ff, 0xc91d,		0x21, 0
	.dw 0xd240, 0xc91d,	0xd27f, 0xc91d,		0x21, 0
	.dw 0xd2c0, 0xc91d,	0xd2ff, 0xc91d,		0x21, 0
	.dw 0xd340, 0xc91d,	0xd37f, 0xc91d,		0x21, 0
	.dw 0xd3c0, 0xc91d,	0xd3ff, 0xc91d,		0x21, 0
	.dw 0xd440, 0xc91d,	0xd47f, 0xc91d,		0x21, 0
	.dw 0xd4c0, 0xc91d,	0xd4ff, 0xc91d,		0x21, 0
	.dw 0xd540, 0xc91d,	0xd57f, 0xc91d,		0x21, 0
	.dw 0xd5c0, 0xc91d,	0xd5ff, 0xc91d,		0x21, 0
	.dw 0xd640, 0xc91d,	0xd67f, 0xc91d,		0x21, 0
	.dw 0xd6c0, 0xc91d,	0xd6ff, 0xc91d,		0x21, 0
	.dw 0xd740, 0xc91d,	0xd77f, 0xc91d,		0x21, 0
	.dw 0xd7c0, 0xc91d,	0xd7ff, 0xc91d,		0x21, 0
	.dw 0xd840, 0xc91d,	0xd87f, 0xc91d,		0x21, 0
	.dw 0xd8c0, 0xc91d,	0xd8ff, 0xc91d,		0x21, 0
	.dw 0xd940, 0xc91d,	0xd97f, 0xc91d,		0x21, 0
	.dw 0xd9c0, 0xc91d,	0xdfff, 0xc91d,		0x21, 0
	.dw 0xe040, 0xc91d,	0xe07f, 0xc91d,		0x21, 0
	.dw 0xe0c0, 0xc91d,	0xe0ff, 0xc91d,		0x21, 0
	.dw 0xe140, 0xc91d,	0xe17f, 0xc91d,		0x21, 0
	.dw 0xe1c0, 0xc91d,	0xe1ff, 0xc91d,		0x21, 0
	.dw 0xe240, 0xc91d,	0xe27f, 0xc91d,		0x21, 0
	.dw 0xe2c0, 0xc91d,	0xe2ff, 0xc91d,		0x21, 0
	.dw 0xe340, 0xc91d,	0xe37f, 0xc91d,		0x21, 0
	.dw 0xe3c0, 0xc91d,	0xe3ff, 0xc91d,		0x21, 0
	.dw 0xe440, 0xc91d,	0xe47f, 0xc91d,		0x21, 0
	.dw 0xe4c0, 0xc91d,	0xe4ff, 0xc91d,		0x21, 0
	.dw 0xe540, 0xc91d,	0xe57f, 0xc91d,		0x21, 0
	.dw 0xe5c0, 0xc91d,	0xe5ff, 0xc91d,		0x21, 0
	.dw 0xe640, 0xc91d,	0xe67f, 0xc91d,		0x21, 0
	.dw 0xe6c0, 0xc91d,	0xe6ff, 0xc91d,		0x21, 0
	.dw 0xe740, 0xc91d,	0xe77f, 0xc91d,		0x21, 0
	.dw 0xe7c0, 0xc91d,	0xe7ff, 0xc91d,		0x21, 0
	.dw 0xe840, 0xc91d,	0xe87f, 0xc91d,		0x21, 0
	.dw 0xe8c0, 0xc91d,	0xe8ff, 0xc91d,		0x21, 0
	.dw 0xe940, 0xc91d,	0xe97f, 0xc91d,		0x21, 0
	.dw 0xe9c0, 0xc91d,	0xe9ff, 0xc91d,		0x21, 0
	.dw 0xea40, 0xc91d,	0xea7f, 0xc91d,		0x21, 0
	.dw 0xeac0, 0xc91d,	0xeaff, 0xc91d,		0x21, 0
	.dw 0xeb40, 0xc91d,	0xeb7f, 0xc91d,		0x21, 0
	.dw 0xebc0, 0xc91d,	0xebff, 0xc91d,		0x21, 0
	.dw 0xec40, 0xc91d,	0xec7f, 0xc91d,		0x21, 0
	.dw 0xecc0, 0xc91d,	0xecff, 0xc91d,		0x21, 0
	.dw 0xed40, 0xc91d,	0xed7f, 0xc91d,		0x21, 0
	.dw 0xedc0, 0xc91d,	0xedff, 0xc91d,		0x21, 0
	.dw 0xee40, 0xc91d,	0xee7f, 0xc91d,		0x21, 0
	.dw 0xeec0, 0xc91d,	0xeeff, 0xc91d,		0x21, 0
	.dw 0xef40, 0xc91d,	0xef7f, 0xc91d,		0x21, 0
	.dw 0xefc0, 0xc91d,	0xefff, 0xc91d,		0x21, 0
	.dw 0xf040, 0xc91d,	0xf07f, 0xc91d,		0x21, 0
	.dw 0xf0c0, 0xc91d,	0xf0ff, 0xc91d,		0x21, 0
	.dw 0xf140, 0xc91d,	0xf17f, 0xc91d,		0x21, 0
	.dw 0xf1c0, 0xc91d,	0xf1ff, 0xc91d,		0x21, 0
	.dw 0xf240, 0xc91d,	0xf27f, 0xc91d,		0x21, 0
	.dw 0xf2c0, 0xc91d,	0xf2ff, 0xc91d,		0x21, 0
	.dw 0xf340, 0xc91d,	0xf37f, 0xc91d,		0x21, 0
	.dw 0xf3c0, 0xc91d,	0xf3ff, 0xc91d,		0x21, 0
	.dw 0xf440, 0xc91d,	0xf47f, 0xc91d,		0x21, 0
	.dw 0xf4c0, 0xc91d,	0xf4ff, 0xc91d,		0x21, 0
	.dw 0xf540, 0xc91d,	0xf57f, 0xc91d,		0x21, 0
	.dw 0xf5c0, 0xc91d,	0xf5ff, 0xc91d,		0x21, 0
	.dw 0xf640, 0xc91d,	0xf67f, 0xc91d,		0x21, 0
	.dw 0xf6c0, 0xc91d,	0xf6ff, 0xc91d,		0x21, 0
	.dw 0xf740, 0xc91d,	0xf77f, 0xc91d,		0x21, 0
	.dw 0xf7c0, 0xc91d,	0xf7ff, 0xc91d,		0x21, 0
	.dw 0xf840, 0xc91d,	0xf87f, 0xc91d,		0x21, 0
	.dw 0xf8c0, 0xc91d,	0xf8ff, 0xc91d,		0x21, 0
	.dw 0xf940, 0xc91d,	0xf97f, 0xc91d,		0x21, 0
	.dw 0xf9c0, 0xc91d,	0xffff, 0xc91d,		0x21, 0
	.dw 0x0040, 0xc91e,	0x007f, 0xc91e,		0x21, 0
	.dw 0x00c0, 0xc91e,	0x00ff, 0xc91e,		0x21, 0
	.dw 0x0140, 0xc91e,	0x017f, 0xc91e,		0x21, 0
	.dw 0x01c0, 0xc91e,	0x01ff, 0xc91e,		0x21, 0
	.dw 0x0240, 0xc91e,	0x027f, 0xc91e,		0x21, 0
	.dw 0x02c0, 0xc91e,	0x02ff, 0xc91e,		0x21, 0
	.dw 0x0340, 0xc91e,	0x037f, 0xc91e,		0x21, 0
	.dw 0x03c0, 0xc91e,	0x03ff, 0xc91e,		0x21, 0
	.dw 0x0440, 0xc91e,	0x047f, 0xc91e,		0x21, 0
	.dw 0x04c0, 0xc91e,	0x04ff, 0xc91e,		0x21, 0
	.dw 0x0540, 0xc91e,	0x057f, 0xc91e,		0x21, 0
	.dw 0x05c0, 0xc91e,	0x05ff, 0xc91e,		0x21, 0
	.dw 0x0640, 0xc91e,	0x067f, 0xc91e,		0x21, 0
	.dw 0x06c0, 0xc91e,	0x06ff, 0xc91e,		0x21, 0
	.dw 0x0740, 0xc91e,	0x077f, 0xc91e,		0x21, 0
	.dw 0x07c0, 0xc91e,	0x07ff, 0xc91e,		0x21, 0
	.dw 0x0840, 0xc91e,	0x087f, 0xc91e,		0x21, 0
	.dw 0x08c0, 0xc91e,	0x08ff, 0xc91e,		0x21, 0
	.dw 0x0940, 0xc91e,	0x097f, 0xc91e,		0x21, 0
	.dw 0x09c0, 0xc91e,	0x09ff, 0xc91e,		0x21, 0
	.dw 0x0a40, 0xc91e,	0x0a7f, 0xc91e,		0x21, 0
	.dw 0x0ac0, 0xc91e,	0x0aff, 0xc91e,		0x21, 0
	.dw 0x0b40, 0xc91e,	0x0b7f, 0xc91e,		0x21, 0
	.dw 0x0bc0, 0xc91e,	0x0bff, 0xc91e,		0x21, 0
	.dw 0x0c40, 0xc91e,	0x0c7f, 0xc91e,		0x21, 0
	.dw 0x0cc0, 0xc91e,	0x0cff, 0xc91e,		0x21, 0
	.dw 0x0d40, 0xc91e,	0x0d7f, 0xc91e,		0x21, 0
	.dw 0x0dc0, 0xc91e,	0x0dff, 0xc91e,		0x21, 0
	.dw 0x0e40, 0xc91e,	0x0e7f, 0xc91e,		0x21, 0
	.dw 0x0ec0, 0xc91e,	0x0eff, 0xc91e,		0x21, 0
	.dw 0x0f40, 0xc91e,	0x0f7f, 0xc91e,		0x21, 0
	.dw 0x0fc0, 0xc91e,	0x0fff, 0xc91e,		0x21, 0
	.dw 0x1040, 0xc91e,	0x107f, 0xc91e,		0x21, 0
	.dw 0x10c0, 0xc91e,	0x10ff, 0xc91e,		0x21, 0
	.dw 0x1140, 0xc91e,	0x117f, 0xc91e,		0x21, 0
	.dw 0x11c0, 0xc91e,	0x11ff, 0xc91e,		0x21, 0
	.dw 0x1240, 0xc91e,	0x127f, 0xc91e,		0x21, 0
	.dw 0x12c0, 0xc91e,	0x12ff, 0xc91e,		0x21, 0
	.dw 0x1340, 0xc91e,	0x137f, 0xc91e,		0x21, 0
	.dw 0x13c0, 0xc91e,	0x13ff, 0xc91e,		0x21, 0
	.dw 0x1440, 0xc91e,	0x147f, 0xc91e,		0x21, 0
	.dw 0x14c0, 0xc91e,	0x14ff, 0xc91e,		0x21, 0
	.dw 0x1540, 0xc91e,	0x157f, 0xc91e,		0x21, 0
	.dw 0x15c0, 0xc91e,	0x15ff, 0xc91e,		0x21, 0
	.dw 0x1640, 0xc91e,	0x167f, 0xc91e,		0x21, 0
	.dw 0x16c0, 0xc91e,	0x16ff, 0xc91e,		0x21, 0
	.dw 0x1740, 0xc91e,	0x177f, 0xc91e,		0x21, 0
	.dw 0x17c0, 0xc91e,	0x17ff, 0xc91e,		0x21, 0
	.dw 0x1840, 0xc91e,	0x187f, 0xc91e,		0x21, 0
	.dw 0x18c0, 0xc91e,	0x18ff, 0xc91e,		0x21, 0
	.dw 0x1940, 0xc91e,	0x197f, 0xc91e,		0x21, 0
	.dw 0x19c0, 0xc91e,	0x1fff, 0xc91e,		0x21, 0
	.dw 0x2040, 0xc91e,	0x207f, 0xc91e,		0x21, 0
	.dw 0x20c0, 0xc91e,	0x20ff, 0xc91e,		0x21, 0
	.dw 0x2140, 0xc91e,	0x217f, 0xc91e,		0x21, 0
	.dw 0x21c0, 0xc91e,	0x21ff, 0xc91e,		0x21, 0
	.dw 0x2240, 0xc91e,	0x227f, 0xc91e,		0x21, 0
	.dw 0x22c0, 0xc91e,	0x22ff, 0xc91e,		0x21, 0
	.dw 0x2340, 0xc91e,	0x237f, 0xc91e,		0x21, 0
	.dw 0x23c0, 0xc91e,	0x23ff, 0xc91e,		0x21, 0
	.dw 0x2440, 0xc91e,	0x247f, 0xc91e,		0x21, 0
	.dw 0x24c0, 0xc91e,	0x24ff, 0xc91e,		0x21, 0
	.dw 0x2540, 0xc91e,	0x257f, 0xc91e,		0x21, 0
	.dw 0x25c0, 0xc91e,	0x25ff, 0xc91e,		0x21, 0
	.dw 0x2640, 0xc91e,	0x267f, 0xc91e,		0x21, 0
	.dw 0x26c0, 0xc91e,	0x26ff, 0xc91e,		0x21, 0
	.dw 0x2740, 0xc91e,	0x277f, 0xc91e,		0x21, 0
	.dw 0x27c0, 0xc91e,	0x27ff, 0xc91e,		0x21, 0
	.dw 0x2840, 0xc91e,	0x287f, 0xc91e,		0x21, 0
	.dw 0x28c0, 0xc91e,	0x28ff, 0xc91e,		0x21, 0
	.dw 0x2940, 0xc91e,	0x297f, 0xc91e,		0x21, 0
	.dw 0x29c0, 0xc91e,	0x29ff, 0xc91e,		0x21, 0
	.dw 0x2a40, 0xc91e,	0x2a7f, 0xc91e,		0x21, 0
	.dw 0x2ac0, 0xc91e,	0x2aff, 0xc91e,		0x21, 0
	.dw 0x2b40, 0xc91e,	0x2b7f, 0xc91e,		0x21, 0
	.dw 0x2bc0, 0xc91e,	0x2bff, 0xc91e,		0x21, 0
	.dw 0x2c40, 0xc91e,	0x2c7f, 0xc91e,		0x21, 0
	.dw 0x2cc0, 0xc91e,	0x2cff, 0xc91e,		0x21, 0
	.dw 0x2d40, 0xc91e,	0x2d7f, 0xc91e,		0x21, 0
	.dw 0x2dc0, 0xc91e,	0x2dff, 0xc91e,		0x21, 0
	.dw 0x2e40, 0xc91e,	0x2e7f, 0xc91e,		0x21, 0
	.dw 0x2ec0, 0xc91e,	0x2eff, 0xc91e,		0x21, 0
	.dw 0x2f40, 0xc91e,	0x2f7f, 0xc91e,		0x21, 0
	.dw 0x2fc0, 0xc91e,	0x2fff, 0xc91e,		0x21, 0
	.dw 0x3040, 0xc91e,	0x307f, 0xc91e,		0x21, 0
	.dw 0x30c0, 0xc91e,	0x30ff, 0xc91e,		0x21, 0
	.dw 0x3140, 0xc91e,	0x317f, 0xc91e,		0x21, 0
	.dw 0x31c0, 0xc91e,	0x31ff, 0xc91e,		0x21, 0
	.dw 0x3240, 0xc91e,	0x327f, 0xc91e,		0x21, 0
	.dw 0x32c0, 0xc91e,	0x32ff, 0xc91e,		0x21, 0
	.dw 0x3340, 0xc91e,	0x337f, 0xc91e,		0x21, 0
	.dw 0x33c0, 0xc91e,	0x33ff, 0xc91e,		0x21, 0
	.dw 0x3440, 0xc91e,	0x347f, 0xc91e,		0x21, 0
	.dw 0x34c0, 0xc91e,	0x34ff, 0xc91e,		0x21, 0
	.dw 0x3540, 0xc91e,	0x357f, 0xc91e,		0x21, 0
	.dw 0x35c0, 0xc91e,	0x35ff, 0xc91e,		0x21, 0
	.dw 0x3640, 0xc91e,	0x367f, 0xc91e,		0x21, 0
	.dw 0x36c0, 0xc91e,	0x36ff, 0xc91e,		0x21, 0
	.dw 0x3740, 0xc91e,	0x377f, 0xc91e,		0x21, 0
	.dw 0x37c0, 0xc91e,	0x37ff, 0xc91e,		0x21, 0
	.dw 0x3840, 0xc91e,	0x387f, 0xc91e,		0x21, 0
	.dw 0x38c0, 0xc91e,	0x38ff, 0xc91e,		0x21, 0
	.dw 0x3940, 0xc91e,	0x397f, 0xc91e,		0x21, 0
	.dw 0x39c0, 0xc91e,	0x3fff, 0xc91e,		0x21, 0
	.dw 0x4040, 0xc91e,	0x407f, 0xc91e,		0x21, 0
	.dw 0x40c0, 0xc91e,	0x40ff, 0xc91e,		0x21, 0
	.dw 0x4140, 0xc91e,	0x417f, 0xc91e,		0x21, 0
	.dw 0x41c0, 0xc91e,	0x41ff, 0xc91e,		0x21, 0
	.dw 0x4240, 0xc91e,	0x427f, 0xc91e,		0x21, 0
	.dw 0x42c0, 0xc91e,	0x42ff, 0xc91e,		0x21, 0
	.dw 0x4340, 0xc91e,	0x437f, 0xc91e,		0x21, 0
	.dw 0x43c0, 0xc91e,	0x43ff, 0xc91e,		0x21, 0
	.dw 0x4440, 0xc91e,	0x447f, 0xc91e,		0x21, 0
	.dw 0x44c0, 0xc91e,	0x44ff, 0xc91e,		0x21, 0
	.dw 0x4540, 0xc91e,	0x457f, 0xc91e,		0x21, 0
	.dw 0x45c0, 0xc91e,	0x45ff, 0xc91e,		0x21, 0
	.dw 0x4640, 0xc91e,	0x467f, 0xc91e,		0x21, 0
	.dw 0x46c0, 0xc91e,	0x46ff, 0xc91e,		0x21, 0
	.dw 0x4740, 0xc91e,	0x477f, 0xc91e,		0x21, 0
	.dw 0x47c0, 0xc91e,	0x47ff, 0xc91e,		0x21, 0
	.dw 0x4840, 0xc91e,	0x487f, 0xc91e,		0x21, 0
	.dw 0x48c0, 0xc91e,	0x48ff, 0xc91e,		0x21, 0
	.dw 0x4940, 0xc91e,	0x497f, 0xc91e,		0x21, 0
	.dw 0x49c0, 0xc91e,	0x49ff, 0xc91e,		0x21, 0
	.dw 0x4a40, 0xc91e,	0x4a7f, 0xc91e,		0x21, 0
	.dw 0x4ac0, 0xc91e,	0x4aff, 0xc91e,		0x21, 0
	.dw 0x4b40, 0xc91e,	0x4b7f, 0xc91e,		0x21, 0
	.dw 0x4bc0, 0xc91e,	0x4bff, 0xc91e,		0x21, 0
	.dw 0x4c40, 0xc91e,	0x4c7f, 0xc91e,		0x21, 0
	.dw 0x4cc0, 0xc91e,	0x4cff, 0xc91e,		0x21, 0
	.dw 0x4d40, 0xc91e,	0x4d7f, 0xc91e,		0x21, 0
	.dw 0x4dc0, 0xc91e,	0x4dff, 0xc91e,		0x21, 0
	.dw 0x4e40, 0xc91e,	0x4e7f, 0xc91e,		0x21, 0
	.dw 0x4ec0, 0xc91e,	0x4eff, 0xc91e,		0x21, 0
	.dw 0x4f40, 0xc91e,	0x4f7f, 0xc91e,		0x21, 0
	.dw 0x4fc0, 0xc91e,	0x4fff, 0xc91e,		0x21, 0
	.dw 0x5040, 0xc91e,	0x507f, 0xc91e,		0x21, 0
	.dw 0x50c0, 0xc91e,	0x50ff, 0xc91e,		0x21, 0
	.dw 0x5140, 0xc91e,	0x517f, 0xc91e,		0x21, 0
	.dw 0x51c0, 0xc91e,	0x51ff, 0xc91e,		0x21, 0
	.dw 0x5240, 0xc91e,	0x527f, 0xc91e,		0x21, 0
	.dw 0x52c0, 0xc91e,	0x52ff, 0xc91e,		0x21, 0
	.dw 0x5340, 0xc91e,	0x537f, 0xc91e,		0x21, 0
	.dw 0x53c0, 0xc91e,	0x53ff, 0xc91e,		0x21, 0
	.dw 0x5440, 0xc91e,	0x547f, 0xc91e,		0x21, 0
	.dw 0x54c0, 0xc91e,	0x54ff, 0xc91e,		0x21, 0
	.dw 0x5540, 0xc91e,	0x557f, 0xc91e,		0x21, 0
	.dw 0x55c0, 0xc91e,	0x55ff, 0xc91e,		0x21, 0
	.dw 0x5640, 0xc91e,	0x567f, 0xc91e,		0x21, 0
	.dw 0x56c0, 0xc91e,	0x56ff, 0xc91e,		0x21, 0
	.dw 0x5740, 0xc91e,	0x577f, 0xc91e,		0x21, 0
	.dw 0x57c0, 0xc91e,	0x57ff, 0xc91e,		0x21, 0
	.dw 0x5840, 0xc91e,	0x587f, 0xc91e,		0x21, 0
	.dw 0x58c0, 0xc91e,	0x58ff, 0xc91e,		0x21, 0
	.dw 0x5940, 0xc91e,	0x597f, 0xc91e,		0x21, 0
	.dw 0x59c0, 0xc91e,	0x5fff, 0xc91e,		0x21, 0
	.dw 0x6040, 0xc91e,	0x607f, 0xc91e,		0x21, 0
	.dw 0x60c0, 0xc91e,	0x60ff, 0xc91e,		0x21, 0
	.dw 0x6140, 0xc91e,	0x617f, 0xc91e,		0x21, 0
	.dw 0x61c0, 0xc91e,	0x61ff, 0xc91e,		0x21, 0
	.dw 0x6240, 0xc91e,	0x627f, 0xc91e,		0x21, 0
	.dw 0x62c0, 0xc91e,	0x62ff, 0xc91e,		0x21, 0
	.dw 0x6340, 0xc91e,	0x637f, 0xc91e,		0x21, 0
	.dw 0x63c0, 0xc91e,	0x63ff, 0xc91e,		0x21, 0
	.dw 0x6440, 0xc91e,	0x647f, 0xc91e,		0x21, 0
	.dw 0x64c0, 0xc91e,	0x64ff, 0xc91e,		0x21, 0
	.dw 0x6540, 0xc91e,	0x657f, 0xc91e,		0x21, 0
	.dw 0x65c0, 0xc91e,	0x65ff, 0xc91e,		0x21, 0
	.dw 0x6640, 0xc91e,	0x667f, 0xc91e,		0x21, 0
	.dw 0x66c0, 0xc91e,	0x66ff, 0xc91e,		0x21, 0
	.dw 0x6740, 0xc91e,	0x677f, 0xc91e,		0x21, 0
	.dw 0x67c0, 0xc91e,	0x67ff, 0xc91e,		0x21, 0
	.dw 0x6840, 0xc91e,	0x687f, 0xc91e,		0x21, 0
	.dw 0x68c0, 0xc91e,	0x68ff, 0xc91e,		0x21, 0
	.dw 0x6940, 0xc91e,	0x697f, 0xc91e,		0x21, 0
	.dw 0x69c0, 0xc91e,	0x69ff, 0xc91e,		0x21, 0
	.dw 0x6a40, 0xc91e,	0x6a7f, 0xc91e,		0x21, 0
	.dw 0x6ac0, 0xc91e,	0x6aff, 0xc91e,		0x21, 0
	.dw 0x6b40, 0xc91e,	0x6b7f, 0xc91e,		0x21, 0
	.dw 0x6bc0, 0xc91e,	0x6bff, 0xc91e,		0x21, 0
	.dw 0x6c40, 0xc91e,	0x6c7f, 0xc91e,		0x21, 0
	.dw 0x6cc0, 0xc91e,	0x6cff, 0xc91e,		0x21, 0
	.dw 0x6d40, 0xc91e,	0x6d7f, 0xc91e,		0x21, 0
	.dw 0x6dc0, 0xc91e,	0x6dff, 0xc91e,		0x21, 0
	.dw 0x6e40, 0xc91e,	0x6e7f, 0xc91e,		0x21, 0
	.dw 0x6ec0, 0xc91e,	0x6eff, 0xc91e,		0x21, 0
	.dw 0x6f40, 0xc91e,	0x6f7f, 0xc91e,		0x21, 0
	.dw 0x6fc0, 0xc91e,	0x6fff, 0xc91e,		0x21, 0
	.dw 0x7040, 0xc91e,	0x707f, 0xc91e,		0x21, 0
	.dw 0x70c0, 0xc91e,	0x70ff, 0xc91e,		0x21, 0
	.dw 0x7140, 0xc91e,	0x717f, 0xc91e,		0x21, 0
	.dw 0x71c0, 0xc91e,	0x71ff, 0xc91e,		0x21, 0
	.dw 0x7240, 0xc91e,	0x727f, 0xc91e,		0x21, 0
	.dw 0x72c0, 0xc91e,	0x72ff, 0xc91e,		0x21, 0
	.dw 0x7340, 0xc91e,	0x737f, 0xc91e,		0x21, 0
	.dw 0x73c0, 0xc91e,	0x73ff, 0xc91e,		0x21, 0
	.dw 0x7440, 0xc91e,	0x747f, 0xc91e,		0x21, 0
	.dw 0x74c0, 0xc91e,	0x74ff, 0xc91e,		0x21, 0
	.dw 0x7540, 0xc91e,	0x757f, 0xc91e,		0x21, 0
	.dw 0x75c0, 0xc91e,	0x75ff, 0xc91e,		0x21, 0
	.dw 0x7640, 0xc91e,	0x767f, 0xc91e,		0x21, 0
	.dw 0x76c0, 0xc91e,	0x76ff, 0xc91e,		0x21, 0
	.dw 0x7740, 0xc91e,	0x777f, 0xc91e,		0x21, 0
	.dw 0x77c0, 0xc91e,	0x77ff, 0xc91e,		0x21, 0
	.dw 0x7840, 0xc91e,	0x787f, 0xc91e,		0x21, 0
	.dw 0x78c0, 0xc91e,	0x78ff, 0xc91e,		0x21, 0
	.dw 0x7940, 0xc91e,	0x797f, 0xc91e,		0x21, 0
	.dw 0x79c0, 0xc91e,	0x7fff, 0xc91e,		0x21, 0
	.dw 0x8040, 0xc91e,	0x807f, 0xc91e,		0x21, 0
	.dw 0x80c0, 0xc91e,	0x80ff, 0xc91e,		0x21, 0
	.dw 0x8140, 0xc91e,	0x817f, 0xc91e,		0x21, 0
	.dw 0x81c0, 0xc91e,	0x81ff, 0xc91e,		0x21, 0
	.dw 0x8240, 0xc91e,	0x827f, 0xc91e,		0x21, 0
	.dw 0x82c0, 0xc91e,	0x82ff, 0xc91e,		0x21, 0
	.dw 0x8340, 0xc91e,	0x837f, 0xc91e,		0x21, 0
	.dw 0x83c0, 0xc91e,	0x83ff, 0xc91e,		0x21, 0
	.dw 0x8440, 0xc91e,	0x847f, 0xc91e,		0x21, 0
	.dw 0x84c0, 0xc91e,	0x84ff, 0xc91e,		0x21, 0
	.dw 0x8540, 0xc91e,	0x857f, 0xc91e,		0x21, 0
	.dw 0x85c0, 0xc91e,	0x85ff, 0xc91e,		0x21, 0
	.dw 0x8640, 0xc91e,	0x867f, 0xc91e,		0x21, 0
	.dw 0x86c0, 0xc91e,	0x86ff, 0xc91e,		0x21, 0
	.dw 0x8740, 0xc91e,	0x877f, 0xc91e,		0x21, 0
	.dw 0x87c0, 0xc91e,	0x87ff, 0xc91e,		0x21, 0
	.dw 0x8840, 0xc91e,	0x887f, 0xc91e,		0x21, 0
	.dw 0x88c0, 0xc91e,	0x88ff, 0xc91e,		0x21, 0
	.dw 0x8940, 0xc91e,	0x897f, 0xc91e,		0x21, 0
	.dw 0x89c0, 0xc91e,	0x89ff, 0xc91e,		0x21, 0
	.dw 0x8a40, 0xc91e,	0x8a7f, 0xc91e,		0x21, 0
	.dw 0x8ac0, 0xc91e,	0x8aff, 0xc91e,		0x21, 0
	.dw 0x8b40, 0xc91e,	0x8b7f, 0xc91e,		0x21, 0
	.dw 0x8bc0, 0xc91e,	0x8bff, 0xc91e,		0x21, 0
	.dw 0x8c40, 0xc91e,	0x8c7f, 0xc91e,		0x21, 0
	.dw 0x8cc0, 0xc91e,	0x8cff, 0xc91e,		0x21, 0
	.dw 0x8d40, 0xc91e,	0x8d7f, 0xc91e,		0x21, 0
	.dw 0x8dc0, 0xc91e,	0x8dff, 0xc91e,		0x21, 0
	.dw 0x8e40, 0xc91e,	0x8e7f, 0xc91e,		0x21, 0
	.dw 0x8ec0, 0xc91e,	0x8eff, 0xc91e,		0x21, 0
	.dw 0x8f40, 0xc91e,	0x8f7f, 0xc91e,		0x21, 0
	.dw 0x8fc0, 0xc91e,	0x8fff, 0xc91e,		0x21, 0
	.dw 0x9040, 0xc91e,	0x907f, 0xc91e,		0x21, 0
	.dw 0x90c0, 0xc91e,	0x90ff, 0xc91e,		0x21, 0
	.dw 0x9140, 0xc91e,	0x917f, 0xc91e,		0x21, 0
	.dw 0x91c0, 0xc91e,	0x91ff, 0xc91e,		0x21, 0
	.dw 0x9240, 0xc91e,	0x927f, 0xc91e,		0x21, 0
	.dw 0x92c0, 0xc91e,	0x92ff, 0xc91e,		0x21, 0
	.dw 0x9340, 0xc91e,	0x937f, 0xc91e,		0x21, 0
	.dw 0x93c0, 0xc91e,	0x93ff, 0xc91e,		0x21, 0
	.dw 0x9440, 0xc91e,	0x947f, 0xc91e,		0x21, 0
	.dw 0x94c0, 0xc91e,	0x94ff, 0xc91e,		0x21, 0
	.dw 0x9540, 0xc91e,	0x957f, 0xc91e,		0x21, 0
	.dw 0x95c0, 0xc91e,	0x95ff, 0xc91e,		0x21, 0
	.dw 0x9640, 0xc91e,	0x967f, 0xc91e,		0x21, 0
	.dw 0x96c0, 0xc91e,	0x96ff, 0xc91e,		0x21, 0
	.dw 0x9740, 0xc91e,	0x977f, 0xc91e,		0x21, 0
	.dw 0x97c0, 0xc91e,	0x97ff, 0xc91e,		0x21, 0
	.dw 0x9840, 0xc91e,	0x987f, 0xc91e,		0x21, 0
	.dw 0x98c0, 0xc91e,	0x98ff, 0xc91e,		0x21, 0
	.dw 0x9940, 0xc91e,	0x997f, 0xc91e,		0x21, 0
	.dw 0x99c0, 0xc91e,	0x9fff, 0xc91e,		0x21, 0
	.dw 0xa040, 0xc91e,	0xa07f, 0xc91e,		0x21, 0
	.dw 0xa0c0, 0xc91e,	0xa0ff, 0xc91e,		0x21, 0
	.dw 0xa140, 0xc91e,	0xa17f, 0xc91e,		0x21, 0
	.dw 0xa1c0, 0xc91e,	0xa1ff, 0xc91e,		0x21, 0
	.dw 0xa240, 0xc91e,	0xa27f, 0xc91e,		0x21, 0
	.dw 0xa2c0, 0xc91e,	0xa2ff, 0xc91e,		0x21, 0
	.dw 0xa340, 0xc91e,	0xa37f, 0xc91e,		0x21, 0
	.dw 0xa3c0, 0xc91e,	0xa3ff, 0xc91e,		0x21, 0
	.dw 0xa440, 0xc91e,	0xa47f, 0xc91e,		0x21, 0
	.dw 0xa4c0, 0xc91e,	0xa4ff, 0xc91e,		0x21, 0
	.dw 0xa540, 0xc91e,	0xa57f, 0xc91e,		0x21, 0
	.dw 0xa5c0, 0xc91e,	0xa5ff, 0xc91e,		0x21, 0
	.dw 0xa640, 0xc91e,	0xa67f, 0xc91e,		0x21, 0
	.dw 0xa6c0, 0xc91e,	0xa6ff, 0xc91e,		0x21, 0
	.dw 0xa740, 0xc91e,	0xa77f, 0xc91e,		0x21, 0
	.dw 0xa7c0, 0xc91e,	0xa7ff, 0xc91e,		0x21, 0
	.dw 0xa840, 0xc91e,	0xa87f, 0xc91e,		0x21, 0
	.dw 0xa8c0, 0xc91e,	0xa8ff, 0xc91e,		0x21, 0
	.dw 0xa940, 0xc91e,	0xa97f, 0xc91e,		0x21, 0
	.dw 0xa9c0, 0xc91e,	0xa9ff, 0xc91e,		0x21, 0
	.dw 0xaa40, 0xc91e,	0xaa7f, 0xc91e,		0x21, 0
	.dw 0xaac0, 0xc91e,	0xaaff, 0xc91e,		0x21, 0
	.dw 0xab40, 0xc91e,	0xab7f, 0xc91e,		0x21, 0
	.dw 0xabc0, 0xc91e,	0xabff, 0xc91e,		0x21, 0
	.dw 0xac40, 0xc91e,	0xac7f, 0xc91e,		0x21, 0
	.dw 0xacc0, 0xc91e,	0xacff, 0xc91e,		0x21, 0
	.dw 0xad40, 0xc91e,	0xad7f, 0xc91e,		0x21, 0
	.dw 0xadc0, 0xc91e,	0xadff, 0xc91e,		0x21, 0
	.dw 0xae40, 0xc91e,	0xae7f, 0xc91e,		0x21, 0
	.dw 0xaec0, 0xc91e,	0xaeff, 0xc91e,		0x21, 0
	.dw 0xaf40, 0xc91e,	0xaf7f, 0xc91e,		0x21, 0
	.dw 0xafc0, 0xc91e,	0xafff, 0xc91e,		0x21, 0
	.dw 0xb040, 0xc91e,	0xb07f, 0xc91e,		0x21, 0
	.dw 0xb0c0, 0xc91e,	0xb0ff, 0xc91e,		0x21, 0
	.dw 0xb140, 0xc91e,	0xb17f, 0xc91e,		0x21, 0
	.dw 0xb1c0, 0xc91e,	0xb1ff, 0xc91e,		0x21, 0
	.dw 0xb240, 0xc91e,	0xb27f, 0xc91e,		0x21, 0
	.dw 0xb2c0, 0xc91e,	0xb2ff, 0xc91e,		0x21, 0
	.dw 0xb340, 0xc91e,	0xb37f, 0xc91e,		0x21, 0
	.dw 0xb3c0, 0xc91e,	0xb3ff, 0xc91e,		0x21, 0
	.dw 0xb440, 0xc91e,	0xb47f, 0xc91e,		0x21, 0
	.dw 0xb4c0, 0xc91e,	0xb4ff, 0xc91e,		0x21, 0
	.dw 0xb540, 0xc91e,	0xb57f, 0xc91e,		0x21, 0
	.dw 0xb5c0, 0xc91e,	0xb5ff, 0xc91e,		0x21, 0
	.dw 0xb640, 0xc91e,	0xb67f, 0xc91e,		0x21, 0
	.dw 0xb6c0, 0xc91e,	0xb6ff, 0xc91e,		0x21, 0
	.dw 0xb740, 0xc91e,	0xb77f, 0xc91e,		0x21, 0
	.dw 0xb7c0, 0xc91e,	0xb7ff, 0xc91e,		0x21, 0
	.dw 0xb840, 0xc91e,	0xb87f, 0xc91e,		0x21, 0
	.dw 0xb8c0, 0xc91e,	0xb8ff, 0xc91e,		0x21, 0
	.dw 0xb940, 0xc91e,	0xb97f, 0xc91e,		0x21, 0
	.dw 0xb9c0, 0xc91e,	0xbfff, 0xc91e,		0x21, 0
	.dw 0xc040, 0xc91e,	0xc07f, 0xc91e,		0x21, 0
	.dw 0xc0c0, 0xc91e,	0xc0ff, 0xc91e,		0x21, 0
	.dw 0xc140, 0xc91e,	0xc17f, 0xc91e,		0x21, 0
	.dw 0xc1c0, 0xc91e,	0xc1ff, 0xc91e,		0x21, 0
	.dw 0xc240, 0xc91e,	0xc27f, 0xc91e,		0x21, 0
	.dw 0xc2c0, 0xc91e,	0xc2ff, 0xc91e,		0x21, 0
	.dw 0xc340, 0xc91e,	0xc37f, 0xc91e,		0x21, 0
	.dw 0xc3c0, 0xc91e,	0xc3ff, 0xc91e,		0x21, 0
	.dw 0xc440, 0xc91e,	0xc47f, 0xc91e,		0x21, 0
	.dw 0xc4c0, 0xc91e,	0xc4ff, 0xc91e,		0x21, 0
	.dw 0xc540, 0xc91e,	0xc57f, 0xc91e,		0x21, 0
	.dw 0xc5c0, 0xc91e,	0xc5ff, 0xc91e,		0x21, 0
	.dw 0xc640, 0xc91e,	0xc67f, 0xc91e,		0x21, 0
	.dw 0xc6c0, 0xc91e,	0xc6ff, 0xc91e,		0x21, 0
	.dw 0xc740, 0xc91e,	0xc77f, 0xc91e,		0x21, 0
	.dw 0xc7c0, 0xc91e,	0xc7ff, 0xc91e,		0x21, 0
	.dw 0xc840, 0xc91e,	0xc87f, 0xc91e,		0x21, 0
	.dw 0xc8c0, 0xc91e,	0xc8ff, 0xc91e,		0x21, 0
	.dw 0xc940, 0xc91e,	0xc97f, 0xc91e,		0x21, 0
	.dw 0xc9c0, 0xc91e,	0xc9ff, 0xc91e,		0x21, 0
	.dw 0xca40, 0xc91e,	0xca7f, 0xc91e,		0x21, 0
	.dw 0xcac0, 0xc91e,	0xcaff, 0xc91e,		0x21, 0
	.dw 0xcb40, 0xc91e,	0xcb7f, 0xc91e,		0x21, 0
	.dw 0xcbc0, 0xc91e,	0xcbff, 0xc91e,		0x21, 0
	.dw 0xcc40, 0xc91e,	0xcc7f, 0xc91e,		0x21, 0
	.dw 0xccc0, 0xc91e,	0xccff, 0xc91e,		0x21, 0
	.dw 0xcd40, 0xc91e,	0xcd7f, 0xc91e,		0x21, 0
	.dw 0xcdc0, 0xc91e,	0xcdff, 0xc91e,		0x21, 0
	.dw 0xce40, 0xc91e,	0xce7f, 0xc91e,		0x21, 0
	.dw 0xcec0, 0xc91e,	0xceff, 0xc91e,		0x21, 0
	.dw 0xcf40, 0xc91e,	0xcf7f, 0xc91e,		0x21, 0
	.dw 0xcfc0, 0xc91e,	0xcfff, 0xc91e,		0x21, 0
	.dw 0xd040, 0xc91e,	0xd07f, 0xc91e,		0x21, 0
	.dw 0xd0c0, 0xc91e,	0xd0ff, 0xc91e,		0x21, 0
	.dw 0xd140, 0xc91e,	0xd17f, 0xc91e,		0x21, 0
	.dw 0xd1c0, 0xc91e,	0xd1ff, 0xc91e,		0x21, 0
	.dw 0xd240, 0xc91e,	0xd27f, 0xc91e,		0x21, 0
	.dw 0xd2c0, 0xc91e,	0xd2ff, 0xc91e,		0x21, 0
	.dw 0xd340, 0xc91e,	0xd37f, 0xc91e,		0x21, 0
	.dw 0xd3c0, 0xc91e,	0xd3ff, 0xc91e,		0x21, 0
	.dw 0xd440, 0xc91e,	0xd47f, 0xc91e,		0x21, 0
	.dw 0xd4c0, 0xc91e,	0xd4ff, 0xc91e,		0x21, 0
	.dw 0xd540, 0xc91e,	0xd57f, 0xc91e,		0x21, 0
	.dw 0xd5c0, 0xc91e,	0xd5ff, 0xc91e,		0x21, 0
	.dw 0xd640, 0xc91e,	0xd67f, 0xc91e,		0x21, 0
	.dw 0xd6c0, 0xc91e,	0xd6ff, 0xc91e,		0x21, 0
	.dw 0xd740, 0xc91e,	0xd77f, 0xc91e,		0x21, 0
	.dw 0xd7c0, 0xc91e,	0xd7ff, 0xc91e,		0x21, 0
	.dw 0xd840, 0xc91e,	0xd87f, 0xc91e,		0x21, 0
	.dw 0xd8c0, 0xc91e,	0xd8ff, 0xc91e,		0x21, 0
	.dw 0xd940, 0xc91e,	0xd97f, 0xc91e,		0x21, 0
	.dw 0xd9c0, 0xc91e,	0xdfff, 0xc91e,		0x21, 0
	.dw 0xe040, 0xc91e,	0xe07f, 0xc91e,		0x21, 0
	.dw 0xe0c0, 0xc91e,	0xe0ff, 0xc91e,		0x21, 0
	.dw 0xe140, 0xc91e,	0xe17f, 0xc91e,		0x21, 0
	.dw 0xe1c0, 0xc91e,	0xe1ff, 0xc91e,		0x21, 0
	.dw 0xe240, 0xc91e,	0xe27f, 0xc91e,		0x21, 0
	.dw 0xe2c0, 0xc91e,	0xe2ff, 0xc91e,		0x21, 0
	.dw 0xe340, 0xc91e,	0xe37f, 0xc91e,		0x21, 0
	.dw 0xe3c0, 0xc91e,	0xe3ff, 0xc91e,		0x21, 0
	.dw 0xe440, 0xc91e,	0xe47f, 0xc91e,		0x21, 0
	.dw 0xe4c0, 0xc91e,	0xe4ff, 0xc91e,		0x21, 0
	.dw 0xe540, 0xc91e,	0xe57f, 0xc91e,		0x21, 0
	.dw 0xe5c0, 0xc91e,	0xe5ff, 0xc91e,		0x21, 0
	.dw 0xe640, 0xc91e,	0xe67f, 0xc91e,		0x21, 0
	.dw 0xe6c0, 0xc91e,	0xe6ff, 0xc91e,		0x21, 0
	.dw 0xe740, 0xc91e,	0xe77f, 0xc91e,		0x21, 0
	.dw 0xe7c0, 0xc91e,	0xe7ff, 0xc91e,		0x21, 0
	.dw 0xe840, 0xc91e,	0xe87f, 0xc91e,		0x21, 0
	.dw 0xe8c0, 0xc91e,	0xe8ff, 0xc91e,		0x21, 0
	.dw 0xe940, 0xc91e,	0xe97f, 0xc91e,		0x21, 0
	.dw 0xe9c0, 0xc91e,	0xe9ff, 0xc91e,		0x21, 0
	.dw 0xea40, 0xc91e,	0xea7f, 0xc91e,		0x21, 0
	.dw 0xeac0, 0xc91e,	0xeaff, 0xc91e,		0x21, 0
	.dw 0xeb40, 0xc91e,	0xeb7f, 0xc91e,		0x21, 0
	.dw 0xebc0, 0xc91e,	0xebff, 0xc91e,		0x21, 0
	.dw 0xec40, 0xc91e,	0xec7f, 0xc91e,		0x21, 0
	.dw 0xecc0, 0xc91e,	0xecff, 0xc91e,		0x21, 0
	.dw 0xed40, 0xc91e,	0xed7f, 0xc91e,		0x21, 0
	.dw 0xedc0, 0xc91e,	0xedff, 0xc91e,		0x21, 0
	.dw 0xee40, 0xc91e,	0xee7f, 0xc91e,		0x21, 0
	.dw 0xeec0, 0xc91e,	0xeeff, 0xc91e,		0x21, 0
	.dw 0xef40, 0xc91e,	0xef7f, 0xc91e,		0x21, 0
	.dw 0xefc0, 0xc91e,	0xefff, 0xc91e,		0x21, 0
	.dw 0xf040, 0xc91e,	0xf07f, 0xc91e,		0x21, 0
	.dw 0xf0c0, 0xc91e,	0xf0ff, 0xc91e,		0x21, 0
	.dw 0xf140, 0xc91e,	0xf17f, 0xc91e,		0x21, 0
	.dw 0xf1c0, 0xc91e,	0xf1ff, 0xc91e,		0x21, 0
	.dw 0xf240, 0xc91e,	0xf27f, 0xc91e,		0x21, 0
	.dw 0xf2c0, 0xc91e,	0xf2ff, 0xc91e,		0x21, 0
	.dw 0xf340, 0xc91e,	0xf37f, 0xc91e,		0x21, 0
	.dw 0xf3c0, 0xc91e,	0xf3ff, 0xc91e,		0x21, 0
	.dw 0xf440, 0xc91e,	0xf47f, 0xc91e,		0x21, 0
	.dw 0xf4c0, 0xc91e,	0xf4ff, 0xc91e,		0x21, 0
	.dw 0xf540, 0xc91e,	0xf57f, 0xc91e,		0x21, 0
	.dw 0xf5c0, 0xc91e,	0xf5ff, 0xc91e,		0x21, 0
	.dw 0xf640, 0xc91e,	0xf67f, 0xc91e,		0x21, 0
	.dw 0xf6c0, 0xc91e,	0xf6ff, 0xc91e,		0x21, 0
	.dw 0xf740, 0xc91e,	0xf77f, 0xc91e,		0x21, 0
	.dw 0xf7c0, 0xc91e,	0xf7ff, 0xc91e,		0x21, 0
	.dw 0xf840, 0xc91e,	0xf87f, 0xc91e,		0x21, 0
	.dw 0xf8c0, 0xc91e,	0xf8ff, 0xc91e,		0x21, 0
	.dw 0xf940, 0xc91e,	0xf97f, 0xc91e,		0x21, 0
	.dw 0xf9c0, 0xc91e,	0xffff, 0xc91e,		0x21, 0
	.dw 0x0040, 0xc91f,	0x007f, 0xc91f,		0x21, 0
	.dw 0x00c0, 0xc91f,	0x00ff, 0xc91f,		0x21, 0
	.dw 0x0140, 0xc91f,	0x017f, 0xc91f,		0x21, 0
	.dw 0x01c0, 0xc91f,	0x01ff, 0xc91f,		0x21, 0
	.dw 0x0240, 0xc91f,	0x027f, 0xc91f,		0x21, 0
	.dw 0x02c0, 0xc91f,	0x02ff, 0xc91f,		0x21, 0
	.dw 0x0340, 0xc91f,	0x037f, 0xc91f,		0x21, 0
	.dw 0x03c0, 0xc91f,	0x03ff, 0xc91f,		0x21, 0
	.dw 0x0440, 0xc91f,	0x047f, 0xc91f,		0x21, 0
	.dw 0x04c0, 0xc91f,	0x04ff, 0xc91f,		0x21, 0
	.dw 0x0540, 0xc91f,	0x057f, 0xc91f,		0x21, 0
	.dw 0x05c0, 0xc91f,	0x05ff, 0xc91f,		0x21, 0
	.dw 0x0640, 0xc91f,	0x067f, 0xc91f,		0x21, 0
	.dw 0x06c0, 0xc91f,	0x06ff, 0xc91f,		0x21, 0
	.dw 0x0740, 0xc91f,	0x077f, 0xc91f,		0x21, 0
	.dw 0x07c0, 0xc91f,	0x07ff, 0xc91f,		0x21, 0
	.dw 0x0840, 0xc91f,	0x087f, 0xc91f,		0x21, 0
	.dw 0x08c0, 0xc91f,	0x08ff, 0xc91f,		0x21, 0
	.dw 0x0940, 0xc91f,	0x097f, 0xc91f,		0x21, 0
	.dw 0x09c0, 0xc91f,	0x09ff, 0xc91f,		0x21, 0
	.dw 0x0a40, 0xc91f,	0x0a7f, 0xc91f,		0x21, 0
	.dw 0x0ac0, 0xc91f,	0x0aff, 0xc91f,		0x21, 0
	.dw 0x0b40, 0xc91f,	0x0b7f, 0xc91f,		0x21, 0
	.dw 0x0bc0, 0xc91f,	0x0bff, 0xc91f,		0x21, 0
	.dw 0x0c40, 0xc91f,	0x0c7f, 0xc91f,		0x21, 0
	.dw 0x0cc0, 0xc91f,	0x0cff, 0xc91f,		0x21, 0
	.dw 0x0d40, 0xc91f,	0x0d7f, 0xc91f,		0x21, 0
	.dw 0x0dc0, 0xc91f,	0x0dff, 0xc91f,		0x21, 0
	.dw 0x0e40, 0xc91f,	0x0e7f, 0xc91f,		0x21, 0
	.dw 0x0ec0, 0xc91f,	0x0eff, 0xc91f,		0x21, 0
	.dw 0x0f40, 0xc91f,	0x0f7f, 0xc91f,		0x21, 0
	.dw 0x0fc0, 0xc91f,	0x0fff, 0xc91f,		0x21, 0
	.dw 0x1040, 0xc91f,	0x107f, 0xc91f,		0x21, 0
	.dw 0x10c0, 0xc91f,	0x10ff, 0xc91f,		0x21, 0
	.dw 0x1140, 0xc91f,	0x117f, 0xc91f,		0x21, 0
	.dw 0x11c0, 0xc91f,	0x11ff, 0xc91f,		0x21, 0
	.dw 0x1240, 0xc91f,	0x127f, 0xc91f,		0x21, 0
	.dw 0x12c0, 0xc91f,	0x12ff, 0xc91f,		0x21, 0
	.dw 0x1340, 0xc91f,	0x137f, 0xc91f,		0x21, 0
	.dw 0x13c0, 0xc91f,	0x13ff, 0xc91f,		0x21, 0
	.dw 0x1440, 0xc91f,	0x147f, 0xc91f,		0x21, 0
	.dw 0x14c0, 0xc91f,	0x14ff, 0xc91f,		0x21, 0
	.dw 0x1540, 0xc91f,	0x157f, 0xc91f,		0x21, 0
	.dw 0x15c0, 0xc91f,	0x15ff, 0xc91f,		0x21, 0
	.dw 0x1640, 0xc91f,	0x167f, 0xc91f,		0x21, 0
	.dw 0x16c0, 0xc91f,	0x16ff, 0xc91f,		0x21, 0
	.dw 0x1740, 0xc91f,	0x177f, 0xc91f,		0x21, 0
	.dw 0x17c0, 0xc91f,	0x17ff, 0xc91f,		0x21, 0
	.dw 0x1840, 0xc91f,	0x187f, 0xc91f,		0x21, 0
	.dw 0x18c0, 0xc91f,	0x18ff, 0xc91f,		0x21, 0
	.dw 0x1940, 0xc91f,	0x197f, 0xc91f,		0x21, 0
	.dw 0x19c0, 0xc91f,	0x1fff, 0xc91f,		0x21, 0
	.dw 0x2040, 0xc91f,	0x207f, 0xc91f,		0x21, 0
	.dw 0x20c0, 0xc91f,	0x20ff, 0xc91f,		0x21, 0
	.dw 0x2140, 0xc91f,	0x217f, 0xc91f,		0x21, 0
	.dw 0x21c0, 0xc91f,	0x21ff, 0xc91f,		0x21, 0
	.dw 0x2240, 0xc91f,	0x227f, 0xc91f,		0x21, 0
	.dw 0x22c0, 0xc91f,	0x22ff, 0xc91f,		0x21, 0
	.dw 0x2340, 0xc91f,	0x237f, 0xc91f,		0x21, 0
	.dw 0x23c0, 0xc91f,	0x23ff, 0xc91f,		0x21, 0
	.dw 0x2440, 0xc91f,	0x247f, 0xc91f,		0x21, 0
	.dw 0x24c0, 0xc91f,	0x24ff, 0xc91f,		0x21, 0
	.dw 0x2540, 0xc91f,	0x257f, 0xc91f,		0x21, 0
	.dw 0x25c0, 0xc91f,	0x25ff, 0xc91f,		0x21, 0
	.dw 0x2640, 0xc91f,	0x267f, 0xc91f,		0x21, 0
	.dw 0x26c0, 0xc91f,	0x26ff, 0xc91f,		0x21, 0
	.dw 0x2740, 0xc91f,	0x277f, 0xc91f,		0x21, 0
	.dw 0x27c0, 0xc91f,	0x27ff, 0xc91f,		0x21, 0
	.dw 0x2840, 0xc91f,	0x287f, 0xc91f,		0x21, 0
	.dw 0x28c0, 0xc91f,	0x28ff, 0xc91f,		0x21, 0
	.dw 0x2940, 0xc91f,	0x297f, 0xc91f,		0x21, 0
	.dw 0x29c0, 0xc91f,	0x29ff, 0xc91f,		0x21, 0
	.dw 0x2a40, 0xc91f,	0x2a7f, 0xc91f,		0x21, 0
	.dw 0x2ac0, 0xc91f,	0x2aff, 0xc91f,		0x21, 0
	.dw 0x2b40, 0xc91f,	0x2b7f, 0xc91f,		0x21, 0
	.dw 0x2bc0, 0xc91f,	0x2bff, 0xc91f,		0x21, 0
	.dw 0x2c40, 0xc91f,	0x2c7f, 0xc91f,		0x21, 0
	.dw 0x2cc0, 0xc91f,	0x2cff, 0xc91f,		0x21, 0
	.dw 0x2d40, 0xc91f,	0x2d7f, 0xc91f,		0x21, 0
	.dw 0x2dc0, 0xc91f,	0x2dff, 0xc91f,		0x21, 0
	.dw 0x2e40, 0xc91f,	0x2e7f, 0xc91f,		0x21, 0
	.dw 0x2ec0, 0xc91f,	0x2eff, 0xc91f,		0x21, 0
	.dw 0x2f40, 0xc91f,	0x2f7f, 0xc91f,		0x21, 0
	.dw 0x2fc0, 0xc91f,	0x2fff, 0xc91f,		0x21, 0
	.dw 0x3040, 0xc91f,	0x307f, 0xc91f,		0x21, 0
	.dw 0x30c0, 0xc91f,	0x30ff, 0xc91f,		0x21, 0
	.dw 0x3140, 0xc91f,	0x317f, 0xc91f,		0x21, 0
	.dw 0x31c0, 0xc91f,	0x31ff, 0xc91f,		0x21, 0
	.dw 0x3240, 0xc91f,	0x327f, 0xc91f,		0x21, 0
	.dw 0x32c0, 0xc91f,	0x32ff, 0xc91f,		0x21, 0
	.dw 0x3340, 0xc91f,	0x337f, 0xc91f,		0x21, 0
	.dw 0x33c0, 0xc91f,	0x33ff, 0xc91f,		0x21, 0
	.dw 0x3440, 0xc91f,	0x347f, 0xc91f,		0x21, 0
	.dw 0x34c0, 0xc91f,	0x34ff, 0xc91f,		0x21, 0
	.dw 0x3540, 0xc91f,	0x357f, 0xc91f,		0x21, 0
	.dw 0x35c0, 0xc91f,	0x35ff, 0xc91f,		0x21, 0
	.dw 0x3640, 0xc91f,	0x367f, 0xc91f,		0x21, 0
	.dw 0x36c0, 0xc91f,	0x36ff, 0xc91f,		0x21, 0
	.dw 0x3740, 0xc91f,	0x377f, 0xc91f,		0x21, 0
	.dw 0x37c0, 0xc91f,	0x37ff, 0xc91f,		0x21, 0
	.dw 0x3840, 0xc91f,	0x387f, 0xc91f,		0x21, 0
	.dw 0x38c0, 0xc91f,	0x38ff, 0xc91f,		0x21, 0
	.dw 0x3940, 0xc91f,	0x397f, 0xc91f,		0x21, 0
	.dw 0x39c0, 0xc91f,	0x1fff, 0xc920,		0x21, 0
	.dw 0x3a00, 0xc920,	0x5fff, 0xc920,		0x21, 0
	.dw 0x7a00, 0xc920,	0x9fff, 0xc920,		0x21, 0
	.dw 0xba00, 0xc920,	0xdfff, 0xc920,		0x21, 0
	.dw 0xfa00, 0xc920,	0x1fff, 0xc921,		0x21, 0
	.dw 0x3a00, 0xc921,	0x5fff, 0xc921,		0x21, 0
	.dw 0x7a00, 0xc921,	0x9fff, 0xc921,		0x21, 0
	.dw 0xba00, 0xc921,	0xdfff, 0xc921,		0x21, 0
	.dw 0xfa00, 0xc921,	0x1fff, 0xc922,		0x21, 0
	.dw 0x3a00, 0xc922,	0x5fff, 0xc922,		0x21, 0
	.dw 0x7a00, 0xc922,	0x9fff, 0xc922,		0x21, 0
	.dw 0xba00, 0xc922,	0xdfff, 0xc922,		0x21, 0
	.dw 0xfa00, 0xc922,	0x1fff, 0xc923,		0x21, 0
	.dw 0x3a00, 0xc923,	0xffff, 0xc923,		0x21, 0
	.dw 0x1a00, 0xc924,	0x1fff, 0xc924,		0x21, 0
	.dw 0x3a00, 0xc924,	0x3fff, 0xc924,		0x21, 0
	.dw 0x5a00, 0xc924,	0x5fff, 0xc924,		0x21, 0
	.dw 0x7a00, 0xc924,	0x7fff, 0xc924,		0x21, 0
	.dw 0x9a00, 0xc924,	0x9fff, 0xc924,		0x21, 0
	.dw 0xba00, 0xc924,	0xbfff, 0xc924,		0x21, 0
	.dw 0xda00, 0xc924,	0xdfff, 0xc924,		0x21, 0
	.dw 0xfa00, 0xc924,	0xffff, 0xc924,		0x21, 0
	.dw 0x1a00, 0xc925,	0x1fff, 0xc925,		0x21, 0
	.dw 0x3a00, 0xc925,	0x3fff, 0xc925,		0x21, 0
	.dw 0x5a00, 0xc925,	0x5fff, 0xc925,		0x21, 0
	.dw 0x7a00, 0xc925,	0x7fff, 0xc925,		0x21, 0
	.dw 0x9a00, 0xc925,	0x9fff, 0xc925,		0x21, 0
	.dw 0xba00, 0xc925,	0xbfff, 0xc925,		0x21, 0
	.dw 0xda00, 0xc925,	0xdfff, 0xc925,		0x21, 0
	.dw 0xfa00, 0xc925,	0xffff, 0xc925,		0x21, 0
	.dw 0x1a00, 0xc926,	0x1fff, 0xc926,		0x21, 0
	.dw 0x3a00, 0xc926,	0x3fff, 0xc926,		0x21, 0
	.dw 0x5a00, 0xc926,	0x5fff, 0xc926,		0x21, 0
	.dw 0x7a00, 0xc926,	0x7fff, 0xc926,		0x21, 0
	.dw 0x9a00, 0xc926,	0x9fff, 0xc926,		0x21, 0
	.dw 0xba00, 0xc926,	0xbfff, 0xc926,		0x21, 0
	.dw 0xda00, 0xc926,	0xdfff, 0xc926,		0x21, 0
	.dw 0xfa00, 0xc926,	0xffff, 0xc926,		0x21, 0
	.dw 0x1a00, 0xc927,	0x1fff, 0xc927,		0x21, 0
	.dw 0x3a00, 0xc927,	0x1fff, 0xc928,		0x21, 0
	.dw 0x2040, 0xc928,	0x207f, 0xc928,		0x21, 0
	.dw 0x20c0, 0xc928,	0x20ff, 0xc928,		0x21, 0
	.dw 0x2140, 0xc928,	0x217f, 0xc928,		0x21, 0
	.dw 0x21c0, 0xc928,	0x21ff, 0xc928,		0x21, 0
	.dw 0x2240, 0xc928,	0x227f, 0xc928,		0x21, 0
	.dw 0x22c0, 0xc928,	0x22ff, 0xc928,		0x21, 0
	.dw 0x2340, 0xc928,	0x237f, 0xc928,		0x21, 0
	.dw 0x23c0, 0xc928,	0x23ff, 0xc928,		0x21, 0
	.dw 0x2440, 0xc928,	0x247f, 0xc928,		0x21, 0
	.dw 0x24c0, 0xc928,	0x24ff, 0xc928,		0x21, 0
	.dw 0x2540, 0xc928,	0x257f, 0xc928,		0x21, 0
	.dw 0x25c0, 0xc928,	0x25ff, 0xc928,		0x21, 0
	.dw 0x2640, 0xc928,	0x267f, 0xc928,		0x21, 0
	.dw 0x26c0, 0xc928,	0x26ff, 0xc928,		0x21, 0
	.dw 0x2740, 0xc928,	0x277f, 0xc928,		0x21, 0
	.dw 0x27c0, 0xc928,	0x27ff, 0xc928,		0x21, 0
	.dw 0x2840, 0xc928,	0x287f, 0xc928,		0x21, 0
	.dw 0x28c0, 0xc928,	0x28ff, 0xc928,		0x21, 0
	.dw 0x2940, 0xc928,	0x297f, 0xc928,		0x21, 0
	.dw 0x29c0, 0xc928,	0x29ff, 0xc928,		0x21, 0
	.dw 0x2a40, 0xc928,	0x2a7f, 0xc928,		0x21, 0
	.dw 0x2ac0, 0xc928,	0x2aff, 0xc928,		0x21, 0
	.dw 0x2b40, 0xc928,	0x2b7f, 0xc928,		0x21, 0
	.dw 0x2bc0, 0xc928,	0x2bff, 0xc928,		0x21, 0
	.dw 0x2c40, 0xc928,	0x2c7f, 0xc928,		0x21, 0
	.dw 0x2cc0, 0xc928,	0x2cff, 0xc928,		0x21, 0
	.dw 0x2d40, 0xc928,	0x2d7f, 0xc928,		0x21, 0
	.dw 0x2dc0, 0xc928,	0x2dff, 0xc928,		0x21, 0
	.dw 0x2e40, 0xc928,	0x2e7f, 0xc928,		0x21, 0
	.dw 0x2ec0, 0xc928,	0x2eff, 0xc928,		0x21, 0
	.dw 0x2f40, 0xc928,	0x2f7f, 0xc928,		0x21, 0
	.dw 0x2fc0, 0xc928,	0x2fff, 0xc928,		0x21, 0
	.dw 0x3040, 0xc928,	0x307f, 0xc928,		0x21, 0
	.dw 0x30c0, 0xc928,	0x30ff, 0xc928,		0x21, 0
	.dw 0x3140, 0xc928,	0x317f, 0xc928,		0x21, 0
	.dw 0x31c0, 0xc928,	0x31ff, 0xc928,		0x21, 0
	.dw 0x3240, 0xc928,	0x327f, 0xc928,		0x21, 0
	.dw 0x32c0, 0xc928,	0x32ff, 0xc928,		0x21, 0
	.dw 0x3340, 0xc928,	0x337f, 0xc928,		0x21, 0
	.dw 0x33c0, 0xc928,	0x33ff, 0xc928,		0x21, 0
	.dw 0x3440, 0xc928,	0x347f, 0xc928,		0x21, 0
	.dw 0x34c0, 0xc928,	0x34ff, 0xc928,		0x21, 0
	.dw 0x3540, 0xc928,	0x357f, 0xc928,		0x21, 0
	.dw 0x35c0, 0xc928,	0x35ff, 0xc928,		0x21, 0
	.dw 0x3640, 0xc928,	0x367f, 0xc928,		0x21, 0
	.dw 0x36c0, 0xc928,	0x36ff, 0xc928,		0x21, 0
	.dw 0x3740, 0xc928,	0x377f, 0xc928,		0x21, 0
	.dw 0x37c0, 0xc928,	0x37ff, 0xc928,		0x21, 0
	.dw 0x3840, 0xc928,	0x387f, 0xc928,		0x21, 0
	.dw 0x38c0, 0xc928,	0x38ff, 0xc928,		0x21, 0
	.dw 0x3940, 0xc928,	0x397f, 0xc928,		0x21, 0
	.dw 0x39c0, 0xc928,	0x5fff, 0xc928,		0x21, 0
	.dw 0x6040, 0xc928,	0x607f, 0xc928,		0x21, 0
	.dw 0x60c0, 0xc928,	0x60ff, 0xc928,		0x21, 0
	.dw 0x6140, 0xc928,	0x617f, 0xc928,		0x21, 0
	.dw 0x61c0, 0xc928,	0x61ff, 0xc928,		0x21, 0
	.dw 0x6240, 0xc928,	0x627f, 0xc928,		0x21, 0
	.dw 0x62c0, 0xc928,	0x62ff, 0xc928,		0x21, 0
	.dw 0x6340, 0xc928,	0x637f, 0xc928,		0x21, 0
	.dw 0x63c0, 0xc928,	0x63ff, 0xc928,		0x21, 0
	.dw 0x6440, 0xc928,	0x647f, 0xc928,		0x21, 0
	.dw 0x64c0, 0xc928,	0x64ff, 0xc928,		0x21, 0
	.dw 0x6540, 0xc928,	0x657f, 0xc928,		0x21, 0
	.dw 0x65c0, 0xc928,	0x65ff, 0xc928,		0x21, 0
	.dw 0x6640, 0xc928,	0x667f, 0xc928,		0x21, 0
	.dw 0x66c0, 0xc928,	0x66ff, 0xc928,		0x21, 0
	.dw 0x6740, 0xc928,	0x677f, 0xc928,		0x21, 0
	.dw 0x67c0, 0xc928,	0x67ff, 0xc928,		0x21, 0
	.dw 0x6840, 0xc928,	0x687f, 0xc928,		0x21, 0
	.dw 0x68c0, 0xc928,	0x68ff, 0xc928,		0x21, 0
	.dw 0x6940, 0xc928,	0x697f, 0xc928,		0x21, 0
	.dw 0x69c0, 0xc928,	0x69ff, 0xc928,		0x21, 0
	.dw 0x6a40, 0xc928,	0x6a7f, 0xc928,		0x21, 0
	.dw 0x6ac0, 0xc928,	0x6aff, 0xc928,		0x21, 0
	.dw 0x6b40, 0xc928,	0x6b7f, 0xc928,		0x21, 0
	.dw 0x6bc0, 0xc928,	0x6bff, 0xc928,		0x21, 0
	.dw 0x6c40, 0xc928,	0x6c7f, 0xc928,		0x21, 0
	.dw 0x6cc0, 0xc928,	0x6cff, 0xc928,		0x21, 0
	.dw 0x6d40, 0xc928,	0x6d7f, 0xc928,		0x21, 0
	.dw 0x6dc0, 0xc928,	0x6dff, 0xc928,		0x21, 0
	.dw 0x6e40, 0xc928,	0x6e7f, 0xc928,		0x21, 0
	.dw 0x6ec0, 0xc928,	0x6eff, 0xc928,		0x21, 0
	.dw 0x6f40, 0xc928,	0x6f7f, 0xc928,		0x21, 0
	.dw 0x6fc0, 0xc928,	0x6fff, 0xc928,		0x21, 0
	.dw 0x7040, 0xc928,	0x707f, 0xc928,		0x21, 0
	.dw 0x70c0, 0xc928,	0x70ff, 0xc928,		0x21, 0
	.dw 0x7140, 0xc928,	0x717f, 0xc928,		0x21, 0
	.dw 0x71c0, 0xc928,	0x71ff, 0xc928,		0x21, 0
	.dw 0x7240, 0xc928,	0x727f, 0xc928,		0x21, 0
	.dw 0x72c0, 0xc928,	0x72ff, 0xc928,		0x21, 0
	.dw 0x7340, 0xc928,	0x737f, 0xc928,		0x21, 0
	.dw 0x73c0, 0xc928,	0x73ff, 0xc928,		0x21, 0
	.dw 0x7440, 0xc928,	0x747f, 0xc928,		0x21, 0
	.dw 0x74c0, 0xc928,	0x74ff, 0xc928,		0x21, 0
	.dw 0x7540, 0xc928,	0x757f, 0xc928,		0x21, 0
	.dw 0x75c0, 0xc928,	0x75ff, 0xc928,		0x21, 0
	.dw 0x7640, 0xc928,	0x767f, 0xc928,		0x21, 0
	.dw 0x76c0, 0xc928,	0x76ff, 0xc928,		0x21, 0
	.dw 0x7740, 0xc928,	0x777f, 0xc928,		0x21, 0
	.dw 0x77c0, 0xc928,	0x77ff, 0xc928,		0x21, 0
	.dw 0x7840, 0xc928,	0x787f, 0xc928,		0x21, 0
	.dw 0x78c0, 0xc928,	0x78ff, 0xc928,		0x21, 0
	.dw 0x7940, 0xc928,	0x797f, 0xc928,		0x21, 0
	.dw 0x79c0, 0xc928,	0x9fff, 0xc928,		0x21, 0
	.dw 0xa040, 0xc928,	0xa07f, 0xc928,		0x21, 0
	.dw 0xa0c0, 0xc928,	0xa0ff, 0xc928,		0x21, 0
	.dw 0xa140, 0xc928,	0xa17f, 0xc928,		0x21, 0
	.dw 0xa1c0, 0xc928,	0xa1ff, 0xc928,		0x21, 0
	.dw 0xa240, 0xc928,	0xa27f, 0xc928,		0x21, 0
	.dw 0xa2c0, 0xc928,	0xa2ff, 0xc928,		0x21, 0
	.dw 0xa340, 0xc928,	0xa37f, 0xc928,		0x21, 0
	.dw 0xa3c0, 0xc928,	0xa3ff, 0xc928,		0x21, 0
	.dw 0xa440, 0xc928,	0xa47f, 0xc928,		0x21, 0
	.dw 0xa4c0, 0xc928,	0xa4ff, 0xc928,		0x21, 0
	.dw 0xa540, 0xc928,	0xa57f, 0xc928,		0x21, 0
	.dw 0xa5c0, 0xc928,	0xa5ff, 0xc928,		0x21, 0
	.dw 0xa640, 0xc928,	0xa67f, 0xc928,		0x21, 0
	.dw 0xa6c0, 0xc928,	0xa6ff, 0xc928,		0x21, 0
	.dw 0xa740, 0xc928,	0xa77f, 0xc928,		0x21, 0
	.dw 0xa7c0, 0xc928,	0xa7ff, 0xc928,		0x21, 0
	.dw 0xa840, 0xc928,	0xa87f, 0xc928,		0x21, 0
	.dw 0xa8c0, 0xc928,	0xa8ff, 0xc928,		0x21, 0
	.dw 0xa940, 0xc928,	0xa97f, 0xc928,		0x21, 0
	.dw 0xa9c0, 0xc928,	0xa9ff, 0xc928,		0x21, 0
	.dw 0xaa40, 0xc928,	0xaa7f, 0xc928,		0x21, 0
	.dw 0xaac0, 0xc928,	0xaaff, 0xc928,		0x21, 0
	.dw 0xab40, 0xc928,	0xab7f, 0xc928,		0x21, 0
	.dw 0xabc0, 0xc928,	0xabff, 0xc928,		0x21, 0
	.dw 0xac40, 0xc928,	0xac7f, 0xc928,		0x21, 0
	.dw 0xacc0, 0xc928,	0xacff, 0xc928,		0x21, 0
	.dw 0xad40, 0xc928,	0xad7f, 0xc928,		0x21, 0
	.dw 0xadc0, 0xc928,	0xadff, 0xc928,		0x21, 0
	.dw 0xae40, 0xc928,	0xae7f, 0xc928,		0x21, 0
	.dw 0xaec0, 0xc928,	0xaeff, 0xc928,		0x21, 0
	.dw 0xaf40, 0xc928,	0xaf7f, 0xc928,		0x21, 0
	.dw 0xafc0, 0xc928,	0xafff, 0xc928,		0x21, 0
	.dw 0xb040, 0xc928,	0xb07f, 0xc928,		0x21, 0
	.dw 0xb0c0, 0xc928,	0xb0ff, 0xc928,		0x21, 0
	.dw 0xb140, 0xc928,	0xb17f, 0xc928,		0x21, 0
	.dw 0xb1c0, 0xc928,	0xb1ff, 0xc928,		0x21, 0
	.dw 0xb240, 0xc928,	0xb27f, 0xc928,		0x21, 0
	.dw 0xb2c0, 0xc928,	0xb2ff, 0xc928,		0x21, 0
	.dw 0xb340, 0xc928,	0xb37f, 0xc928,		0x21, 0
	.dw 0xb3c0, 0xc928,	0xb3ff, 0xc928,		0x21, 0
	.dw 0xb440, 0xc928,	0xb47f, 0xc928,		0x21, 0
	.dw 0xb4c0, 0xc928,	0xb4ff, 0xc928,		0x21, 0
	.dw 0xb540, 0xc928,	0xb57f, 0xc928,		0x21, 0
	.dw 0xb5c0, 0xc928,	0xb5ff, 0xc928,		0x21, 0
	.dw 0xb640, 0xc928,	0xb67f, 0xc928,		0x21, 0
	.dw 0xb6c0, 0xc928,	0xb6ff, 0xc928,		0x21, 0
	.dw 0xb740, 0xc928,	0xb77f, 0xc928,		0x21, 0
	.dw 0xb7c0, 0xc928,	0xb7ff, 0xc928,		0x21, 0
	.dw 0xb840, 0xc928,	0xb87f, 0xc928,		0x21, 0
	.dw 0xb8c0, 0xc928,	0xb8ff, 0xc928,		0x21, 0
	.dw 0xb940, 0xc928,	0xb97f, 0xc928,		0x21, 0
	.dw 0xb9c0, 0xc928,	0xdfff, 0xc928,		0x21, 0
	.dw 0xe040, 0xc928,	0xe07f, 0xc928,		0x21, 0
	.dw 0xe0c0, 0xc928,	0xe0ff, 0xc928,		0x21, 0
	.dw 0xe140, 0xc928,	0xe17f, 0xc928,		0x21, 0
	.dw 0xe1c0, 0xc928,	0xe1ff, 0xc928,		0x21, 0
	.dw 0xe240, 0xc928,	0xe27f, 0xc928,		0x21, 0
	.dw 0xe2c0, 0xc928,	0xe2ff, 0xc928,		0x21, 0
	.dw 0xe340, 0xc928,	0xe37f, 0xc928,		0x21, 0
	.dw 0xe3c0, 0xc928,	0xe3ff, 0xc928,		0x21, 0
	.dw 0xe440, 0xc928,	0xe47f, 0xc928,		0x21, 0
	.dw 0xe4c0, 0xc928,	0xe4ff, 0xc928,		0x21, 0
	.dw 0xe540, 0xc928,	0xe57f, 0xc928,		0x21, 0
	.dw 0xe5c0, 0xc928,	0xe5ff, 0xc928,		0x21, 0
	.dw 0xe640, 0xc928,	0xe67f, 0xc928,		0x21, 0
	.dw 0xe6c0, 0xc928,	0xe6ff, 0xc928,		0x21, 0
	.dw 0xe740, 0xc928,	0xe77f, 0xc928,		0x21, 0
	.dw 0xe7c0, 0xc928,	0xe7ff, 0xc928,		0x21, 0
	.dw 0xe840, 0xc928,	0xe87f, 0xc928,		0x21, 0
	.dw 0xe8c0, 0xc928,	0xe8ff, 0xc928,		0x21, 0
	.dw 0xe940, 0xc928,	0xe97f, 0xc928,		0x21, 0
	.dw 0xe9c0, 0xc928,	0xe9ff, 0xc928,		0x21, 0
	.dw 0xea40, 0xc928,	0xea7f, 0xc928,		0x21, 0
	.dw 0xeac0, 0xc928,	0xeaff, 0xc928,		0x21, 0
	.dw 0xeb40, 0xc928,	0xeb7f, 0xc928,		0x21, 0
	.dw 0xebc0, 0xc928,	0xebff, 0xc928,		0x21, 0
	.dw 0xec40, 0xc928,	0xec7f, 0xc928,		0x21, 0
	.dw 0xecc0, 0xc928,	0xecff, 0xc928,		0x21, 0
	.dw 0xed40, 0xc928,	0xed7f, 0xc928,		0x21, 0
	.dw 0xedc0, 0xc928,	0xedff, 0xc928,		0x21, 0
	.dw 0xee40, 0xc928,	0xee7f, 0xc928,		0x21, 0
	.dw 0xeec0, 0xc928,	0xeeff, 0xc928,		0x21, 0
	.dw 0xef40, 0xc928,	0xef7f, 0xc928,		0x21, 0
	.dw 0xefc0, 0xc928,	0xefff, 0xc928,		0x21, 0
	.dw 0xf040, 0xc928,	0xf07f, 0xc928,		0x21, 0
	.dw 0xf0c0, 0xc928,	0xf0ff, 0xc928,		0x21, 0
	.dw 0xf140, 0xc928,	0xf17f, 0xc928,		0x21, 0
	.dw 0xf1c0, 0xc928,	0xf1ff, 0xc928,		0x21, 0
	.dw 0xf240, 0xc928,	0xf27f, 0xc928,		0x21, 0
	.dw 0xf2c0, 0xc928,	0xf2ff, 0xc928,		0x21, 0
	.dw 0xf340, 0xc928,	0xf37f, 0xc928,		0x21, 0
	.dw 0xf3c0, 0xc928,	0xf3ff, 0xc928,		0x21, 0
	.dw 0xf440, 0xc928,	0xf47f, 0xc928,		0x21, 0
	.dw 0xf4c0, 0xc928,	0xf4ff, 0xc928,		0x21, 0
	.dw 0xf540, 0xc928,	0xf57f, 0xc928,		0x21, 0
	.dw 0xf5c0, 0xc928,	0xf5ff, 0xc928,		0x21, 0
	.dw 0xf640, 0xc928,	0xf67f, 0xc928,		0x21, 0
	.dw 0xf6c0, 0xc928,	0xf6ff, 0xc928,		0x21, 0
	.dw 0xf740, 0xc928,	0xf77f, 0xc928,		0x21, 0
	.dw 0xf7c0, 0xc928,	0xf7ff, 0xc928,		0x21, 0
	.dw 0xf840, 0xc928,	0xf87f, 0xc928,		0x21, 0
	.dw 0xf8c0, 0xc928,	0xf8ff, 0xc928,		0x21, 0
	.dw 0xf940, 0xc928,	0xf97f, 0xc928,		0x21, 0
	.dw 0xf9c0, 0xc928,	0x1fff, 0xc929,		0x21, 0
	.dw 0x2040, 0xc929,	0x207f, 0xc929,		0x21, 0
	.dw 0x20c0, 0xc929,	0x20ff, 0xc929,		0x21, 0
	.dw 0x2140, 0xc929,	0x217f, 0xc929,		0x21, 0
	.dw 0x21c0, 0xc929,	0x21ff, 0xc929,		0x21, 0
	.dw 0x2240, 0xc929,	0x227f, 0xc929,		0x21, 0
	.dw 0x22c0, 0xc929,	0x22ff, 0xc929,		0x21, 0
	.dw 0x2340, 0xc929,	0x237f, 0xc929,		0x21, 0
	.dw 0x23c0, 0xc929,	0x23ff, 0xc929,		0x21, 0
	.dw 0x2440, 0xc929,	0x247f, 0xc929,		0x21, 0
	.dw 0x24c0, 0xc929,	0x24ff, 0xc929,		0x21, 0
	.dw 0x2540, 0xc929,	0x257f, 0xc929,		0x21, 0
	.dw 0x25c0, 0xc929,	0x25ff, 0xc929,		0x21, 0
	.dw 0x2640, 0xc929,	0x267f, 0xc929,		0x21, 0
	.dw 0x26c0, 0xc929,	0x26ff, 0xc929,		0x21, 0
	.dw 0x2740, 0xc929,	0x277f, 0xc929,		0x21, 0
	.dw 0x27c0, 0xc929,	0x27ff, 0xc929,		0x21, 0
	.dw 0x2840, 0xc929,	0x287f, 0xc929,		0x21, 0
	.dw 0x28c0, 0xc929,	0x28ff, 0xc929,		0x21, 0
	.dw 0x2940, 0xc929,	0x297f, 0xc929,		0x21, 0
	.dw 0x29c0, 0xc929,	0x29ff, 0xc929,		0x21, 0
	.dw 0x2a40, 0xc929,	0x2a7f, 0xc929,		0x21, 0
	.dw 0x2ac0, 0xc929,	0x2aff, 0xc929,		0x21, 0
	.dw 0x2b40, 0xc929,	0x2b7f, 0xc929,		0x21, 0
	.dw 0x2bc0, 0xc929,	0x2bff, 0xc929,		0x21, 0
	.dw 0x2c40, 0xc929,	0x2c7f, 0xc929,		0x21, 0
	.dw 0x2cc0, 0xc929,	0x2cff, 0xc929,		0x21, 0
	.dw 0x2d40, 0xc929,	0x2d7f, 0xc929,		0x21, 0
	.dw 0x2dc0, 0xc929,	0x2dff, 0xc929,		0x21, 0
	.dw 0x2e40, 0xc929,	0x2e7f, 0xc929,		0x21, 0
	.dw 0x2ec0, 0xc929,	0x2eff, 0xc929,		0x21, 0
	.dw 0x2f40, 0xc929,	0x2f7f, 0xc929,		0x21, 0
	.dw 0x2fc0, 0xc929,	0x2fff, 0xc929,		0x21, 0
	.dw 0x3040, 0xc929,	0x307f, 0xc929,		0x21, 0
	.dw 0x30c0, 0xc929,	0x30ff, 0xc929,		0x21, 0
	.dw 0x3140, 0xc929,	0x317f, 0xc929,		0x21, 0
	.dw 0x31c0, 0xc929,	0x31ff, 0xc929,		0x21, 0
	.dw 0x3240, 0xc929,	0x327f, 0xc929,		0x21, 0
	.dw 0x32c0, 0xc929,	0x32ff, 0xc929,		0x21, 0
	.dw 0x3340, 0xc929,	0x337f, 0xc929,		0x21, 0
	.dw 0x33c0, 0xc929,	0x33ff, 0xc929,		0x21, 0
	.dw 0x3440, 0xc929,	0x347f, 0xc929,		0x21, 0
	.dw 0x34c0, 0xc929,	0x34ff, 0xc929,		0x21, 0
	.dw 0x3540, 0xc929,	0x357f, 0xc929,		0x21, 0
	.dw 0x35c0, 0xc929,	0x35ff, 0xc929,		0x21, 0
	.dw 0x3640, 0xc929,	0x367f, 0xc929,		0x21, 0
	.dw 0x36c0, 0xc929,	0x36ff, 0xc929,		0x21, 0
	.dw 0x3740, 0xc929,	0x377f, 0xc929,		0x21, 0
	.dw 0x37c0, 0xc929,	0x37ff, 0xc929,		0x21, 0
	.dw 0x3840, 0xc929,	0x387f, 0xc929,		0x21, 0
	.dw 0x38c0, 0xc929,	0x38ff, 0xc929,		0x21, 0
	.dw 0x3940, 0xc929,	0x397f, 0xc929,		0x21, 0
	.dw 0x39c0, 0xc929,	0x5fff, 0xc929,		0x21, 0
	.dw 0x6040, 0xc929,	0x607f, 0xc929,		0x21, 0
	.dw 0x60c0, 0xc929,	0x60ff, 0xc929,		0x21, 0
	.dw 0x6140, 0xc929,	0x617f, 0xc929,		0x21, 0
	.dw 0x61c0, 0xc929,	0x61ff, 0xc929,		0x21, 0
	.dw 0x6240, 0xc929,	0x627f, 0xc929,		0x21, 0
	.dw 0x62c0, 0xc929,	0x62ff, 0xc929,		0x21, 0
	.dw 0x6340, 0xc929,	0x637f, 0xc929,		0x21, 0
	.dw 0x63c0, 0xc929,	0x63ff, 0xc929,		0x21, 0
	.dw 0x6440, 0xc929,	0x647f, 0xc929,		0x21, 0
	.dw 0x64c0, 0xc929,	0x64ff, 0xc929,		0x21, 0
	.dw 0x6540, 0xc929,	0x657f, 0xc929,		0x21, 0
	.dw 0x65c0, 0xc929,	0x65ff, 0xc929,		0x21, 0
	.dw 0x6640, 0xc929,	0x667f, 0xc929,		0x21, 0
	.dw 0x66c0, 0xc929,	0x66ff, 0xc929,		0x21, 0
	.dw 0x6740, 0xc929,	0x677f, 0xc929,		0x21, 0
	.dw 0x67c0, 0xc929,	0x67ff, 0xc929,		0x21, 0
	.dw 0x6840, 0xc929,	0x687f, 0xc929,		0x21, 0
	.dw 0x68c0, 0xc929,	0x68ff, 0xc929,		0x21, 0
	.dw 0x6940, 0xc929,	0x697f, 0xc929,		0x21, 0
	.dw 0x69c0, 0xc929,	0x69ff, 0xc929,		0x21, 0
	.dw 0x6a40, 0xc929,	0x6a7f, 0xc929,		0x21, 0
	.dw 0x6ac0, 0xc929,	0x6aff, 0xc929,		0x21, 0
	.dw 0x6b40, 0xc929,	0x6b7f, 0xc929,		0x21, 0
	.dw 0x6bc0, 0xc929,	0x6bff, 0xc929,		0x21, 0
	.dw 0x6c40, 0xc929,	0x6c7f, 0xc929,		0x21, 0
	.dw 0x6cc0, 0xc929,	0x6cff, 0xc929,		0x21, 0
	.dw 0x6d40, 0xc929,	0x6d7f, 0xc929,		0x21, 0
	.dw 0x6dc0, 0xc929,	0x6dff, 0xc929,		0x21, 0
	.dw 0x6e40, 0xc929,	0x6e7f, 0xc929,		0x21, 0
	.dw 0x6ec0, 0xc929,	0x6eff, 0xc929,		0x21, 0
	.dw 0x6f40, 0xc929,	0x6f7f, 0xc929,		0x21, 0
	.dw 0x6fc0, 0xc929,	0x6fff, 0xc929,		0x21, 0
	.dw 0x7040, 0xc929,	0x707f, 0xc929,		0x21, 0
	.dw 0x70c0, 0xc929,	0x70ff, 0xc929,		0x21, 0
	.dw 0x7140, 0xc929,	0x717f, 0xc929,		0x21, 0
	.dw 0x71c0, 0xc929,	0x71ff, 0xc929,		0x21, 0
	.dw 0x7240, 0xc929,	0x727f, 0xc929,		0x21, 0
	.dw 0x72c0, 0xc929,	0x72ff, 0xc929,		0x21, 0
	.dw 0x7340, 0xc929,	0x737f, 0xc929,		0x21, 0
	.dw 0x73c0, 0xc929,	0x73ff, 0xc929,		0x21, 0
	.dw 0x7440, 0xc929,	0x747f, 0xc929,		0x21, 0
	.dw 0x74c0, 0xc929,	0x74ff, 0xc929,		0x21, 0
	.dw 0x7540, 0xc929,	0x757f, 0xc929,		0x21, 0
	.dw 0x75c0, 0xc929,	0x75ff, 0xc929,		0x21, 0
	.dw 0x7640, 0xc929,	0x767f, 0xc929,		0x21, 0
	.dw 0x76c0, 0xc929,	0x76ff, 0xc929,		0x21, 0
	.dw 0x7740, 0xc929,	0x777f, 0xc929,		0x21, 0
	.dw 0x77c0, 0xc929,	0x77ff, 0xc929,		0x21, 0
	.dw 0x7840, 0xc929,	0x787f, 0xc929,		0x21, 0
	.dw 0x78c0, 0xc929,	0x78ff, 0xc929,		0x21, 0
	.dw 0x7940, 0xc929,	0x797f, 0xc929,		0x21, 0
	.dw 0x79c0, 0xc929,	0x9fff, 0xc929,		0x21, 0
	.dw 0xa040, 0xc929,	0xa07f, 0xc929,		0x21, 0
	.dw 0xa0c0, 0xc929,	0xa0ff, 0xc929,		0x21, 0
	.dw 0xa140, 0xc929,	0xa17f, 0xc929,		0x21, 0
	.dw 0xa1c0, 0xc929,	0xa1ff, 0xc929,		0x21, 0
	.dw 0xa240, 0xc929,	0xa27f, 0xc929,		0x21, 0
	.dw 0xa2c0, 0xc929,	0xa2ff, 0xc929,		0x21, 0
	.dw 0xa340, 0xc929,	0xa37f, 0xc929,		0x21, 0
	.dw 0xa3c0, 0xc929,	0xa3ff, 0xc929,		0x21, 0
	.dw 0xa440, 0xc929,	0xa47f, 0xc929,		0x21, 0
	.dw 0xa4c0, 0xc929,	0xa4ff, 0xc929,		0x21, 0
	.dw 0xa540, 0xc929,	0xa57f, 0xc929,		0x21, 0
	.dw 0xa5c0, 0xc929,	0xa5ff, 0xc929,		0x21, 0
	.dw 0xa640, 0xc929,	0xa67f, 0xc929,		0x21, 0
	.dw 0xa6c0, 0xc929,	0xa6ff, 0xc929,		0x21, 0
	.dw 0xa740, 0xc929,	0xa77f, 0xc929,		0x21, 0
	.dw 0xa7c0, 0xc929,	0xa7ff, 0xc929,		0x21, 0
	.dw 0xa840, 0xc929,	0xa87f, 0xc929,		0x21, 0
	.dw 0xa8c0, 0xc929,	0xa8ff, 0xc929,		0x21, 0
	.dw 0xa940, 0xc929,	0xa97f, 0xc929,		0x21, 0
	.dw 0xa9c0, 0xc929,	0xa9ff, 0xc929,		0x21, 0
	.dw 0xaa40, 0xc929,	0xaa7f, 0xc929,		0x21, 0
	.dw 0xaac0, 0xc929,	0xaaff, 0xc929,		0x21, 0
	.dw 0xab40, 0xc929,	0xab7f, 0xc929,		0x21, 0
	.dw 0xabc0, 0xc929,	0xabff, 0xc929,		0x21, 0
	.dw 0xac40, 0xc929,	0xac7f, 0xc929,		0x21, 0
	.dw 0xacc0, 0xc929,	0xacff, 0xc929,		0x21, 0
	.dw 0xad40, 0xc929,	0xad7f, 0xc929,		0x21, 0
	.dw 0xadc0, 0xc929,	0xadff, 0xc929,		0x21, 0
	.dw 0xae40, 0xc929,	0xae7f, 0xc929,		0x21, 0
	.dw 0xaec0, 0xc929,	0xaeff, 0xc929,		0x21, 0
	.dw 0xaf40, 0xc929,	0xaf7f, 0xc929,		0x21, 0
	.dw 0xafc0, 0xc929,	0xafff, 0xc929,		0x21, 0
	.dw 0xb040, 0xc929,	0xb07f, 0xc929,		0x21, 0
	.dw 0xb0c0, 0xc929,	0xb0ff, 0xc929,		0x21, 0
	.dw 0xb140, 0xc929,	0xb17f, 0xc929,		0x21, 0
	.dw 0xb1c0, 0xc929,	0xb1ff, 0xc929,		0x21, 0
	.dw 0xb240, 0xc929,	0xb27f, 0xc929,		0x21, 0
	.dw 0xb2c0, 0xc929,	0xb2ff, 0xc929,		0x21, 0
	.dw 0xb340, 0xc929,	0xb37f, 0xc929,		0x21, 0
	.dw 0xb3c0, 0xc929,	0xb3ff, 0xc929,		0x21, 0
	.dw 0xb440, 0xc929,	0xb47f, 0xc929,		0x21, 0
	.dw 0xb4c0, 0xc929,	0xb4ff, 0xc929,		0x21, 0
	.dw 0xb540, 0xc929,	0xb57f, 0xc929,		0x21, 0
	.dw 0xb5c0, 0xc929,	0xb5ff, 0xc929,		0x21, 0
	.dw 0xb640, 0xc929,	0xb67f, 0xc929,		0x21, 0
	.dw 0xb6c0, 0xc929,	0xb6ff, 0xc929,		0x21, 0
	.dw 0xb740, 0xc929,	0xb77f, 0xc929,		0x21, 0
	.dw 0xb7c0, 0xc929,	0xb7ff, 0xc929,		0x21, 0
	.dw 0xb840, 0xc929,	0xb87f, 0xc929,		0x21, 0
	.dw 0xb8c0, 0xc929,	0xb8ff, 0xc929,		0x21, 0
	.dw 0xb940, 0xc929,	0xb97f, 0xc929,		0x21, 0
	.dw 0xb9c0, 0xc929,	0xdfff, 0xc929,		0x21, 0
	.dw 0xe040, 0xc929,	0xe07f, 0xc929,		0x21, 0
	.dw 0xe0c0, 0xc929,	0xe0ff, 0xc929,		0x21, 0
	.dw 0xe140, 0xc929,	0xe17f, 0xc929,		0x21, 0
	.dw 0xe1c0, 0xc929,	0xe1ff, 0xc929,		0x21, 0
	.dw 0xe240, 0xc929,	0xe27f, 0xc929,		0x21, 0
	.dw 0xe2c0, 0xc929,	0xe2ff, 0xc929,		0x21, 0
	.dw 0xe340, 0xc929,	0xe37f, 0xc929,		0x21, 0
	.dw 0xe3c0, 0xc929,	0xe3ff, 0xc929,		0x21, 0
	.dw 0xe440, 0xc929,	0xe47f, 0xc929,		0x21, 0
	.dw 0xe4c0, 0xc929,	0xe4ff, 0xc929,		0x21, 0
	.dw 0xe540, 0xc929,	0xe57f, 0xc929,		0x21, 0
	.dw 0xe5c0, 0xc929,	0xe5ff, 0xc929,		0x21, 0
	.dw 0xe640, 0xc929,	0xe67f, 0xc929,		0x21, 0
	.dw 0xe6c0, 0xc929,	0xe6ff, 0xc929,		0x21, 0
	.dw 0xe740, 0xc929,	0xe77f, 0xc929,		0x21, 0
	.dw 0xe7c0, 0xc929,	0xe7ff, 0xc929,		0x21, 0
	.dw 0xe840, 0xc929,	0xe87f, 0xc929,		0x21, 0
	.dw 0xe8c0, 0xc929,	0xe8ff, 0xc929,		0x21, 0
	.dw 0xe940, 0xc929,	0xe97f, 0xc929,		0x21, 0
	.dw 0xe9c0, 0xc929,	0xe9ff, 0xc929,		0x21, 0
	.dw 0xea40, 0xc929,	0xea7f, 0xc929,		0x21, 0
	.dw 0xeac0, 0xc929,	0xeaff, 0xc929,		0x21, 0
	.dw 0xeb40, 0xc929,	0xeb7f, 0xc929,		0x21, 0
	.dw 0xebc0, 0xc929,	0xebff, 0xc929,		0x21, 0
	.dw 0xec40, 0xc929,	0xec7f, 0xc929,		0x21, 0
	.dw 0xecc0, 0xc929,	0xecff, 0xc929,		0x21, 0
	.dw 0xed40, 0xc929,	0xed7f, 0xc929,		0x21, 0
	.dw 0xedc0, 0xc929,	0xedff, 0xc929,		0x21, 0
	.dw 0xee40, 0xc929,	0xee7f, 0xc929,		0x21, 0
	.dw 0xeec0, 0xc929,	0xeeff, 0xc929,		0x21, 0
	.dw 0xef40, 0xc929,	0xef7f, 0xc929,		0x21, 0
	.dw 0xefc0, 0xc929,	0xefff, 0xc929,		0x21, 0
	.dw 0xf040, 0xc929,	0xf07f, 0xc929,		0x21, 0
	.dw 0xf0c0, 0xc929,	0xf0ff, 0xc929,		0x21, 0
	.dw 0xf140, 0xc929,	0xf17f, 0xc929,		0x21, 0
	.dw 0xf1c0, 0xc929,	0xf1ff, 0xc929,		0x21, 0
	.dw 0xf240, 0xc929,	0xf27f, 0xc929,		0x21, 0
	.dw 0xf2c0, 0xc929,	0xf2ff, 0xc929,		0x21, 0
	.dw 0xf340, 0xc929,	0xf37f, 0xc929,		0x21, 0
	.dw 0xf3c0, 0xc929,	0xf3ff, 0xc929,		0x21, 0
	.dw 0xf440, 0xc929,	0xf47f, 0xc929,		0x21, 0
	.dw 0xf4c0, 0xc929,	0xf4ff, 0xc929,		0x21, 0
	.dw 0xf540, 0xc929,	0xf57f, 0xc929,		0x21, 0
	.dw 0xf5c0, 0xc929,	0xf5ff, 0xc929,		0x21, 0
	.dw 0xf640, 0xc929,	0xf67f, 0xc929,		0x21, 0
	.dw 0xf6c0, 0xc929,	0xf6ff, 0xc929,		0x21, 0
	.dw 0xf740, 0xc929,	0xf77f, 0xc929,		0x21, 0
	.dw 0xf7c0, 0xc929,	0xf7ff, 0xc929,		0x21, 0
	.dw 0xf840, 0xc929,	0xf87f, 0xc929,		0x21, 0
	.dw 0xf8c0, 0xc929,	0xf8ff, 0xc929,		0x21, 0
	.dw 0xf940, 0xc929,	0xf97f, 0xc929,		0x21, 0
	.dw 0xf9c0, 0xc929,	0x1fff, 0xc92a,		0x21, 0
	.dw 0x2040, 0xc92a,	0x207f, 0xc92a,		0x21, 0
	.dw 0x20c0, 0xc92a,	0x20ff, 0xc92a,		0x21, 0
	.dw 0x2140, 0xc92a,	0x217f, 0xc92a,		0x21, 0
	.dw 0x21c0, 0xc92a,	0x21ff, 0xc92a,		0x21, 0
	.dw 0x2240, 0xc92a,	0x227f, 0xc92a,		0x21, 0
	.dw 0x22c0, 0xc92a,	0x22ff, 0xc92a,		0x21, 0
	.dw 0x2340, 0xc92a,	0x237f, 0xc92a,		0x21, 0
	.dw 0x23c0, 0xc92a,	0x23ff, 0xc92a,		0x21, 0
	.dw 0x2440, 0xc92a,	0x247f, 0xc92a,		0x21, 0
	.dw 0x24c0, 0xc92a,	0x24ff, 0xc92a,		0x21, 0
	.dw 0x2540, 0xc92a,	0x257f, 0xc92a,		0x21, 0
	.dw 0x25c0, 0xc92a,	0x25ff, 0xc92a,		0x21, 0
	.dw 0x2640, 0xc92a,	0x267f, 0xc92a,		0x21, 0
	.dw 0x26c0, 0xc92a,	0x26ff, 0xc92a,		0x21, 0
	.dw 0x2740, 0xc92a,	0x277f, 0xc92a,		0x21, 0
	.dw 0x27c0, 0xc92a,	0x27ff, 0xc92a,		0x21, 0
	.dw 0x2840, 0xc92a,	0x287f, 0xc92a,		0x21, 0
	.dw 0x28c0, 0xc92a,	0x28ff, 0xc92a,		0x21, 0
	.dw 0x2940, 0xc92a,	0x297f, 0xc92a,		0x21, 0
	.dw 0x29c0, 0xc92a,	0x29ff, 0xc92a,		0x21, 0
	.dw 0x2a40, 0xc92a,	0x2a7f, 0xc92a,		0x21, 0
	.dw 0x2ac0, 0xc92a,	0x2aff, 0xc92a,		0x21, 0
	.dw 0x2b40, 0xc92a,	0x2b7f, 0xc92a,		0x21, 0
	.dw 0x2bc0, 0xc92a,	0x2bff, 0xc92a,		0x21, 0
	.dw 0x2c40, 0xc92a,	0x2c7f, 0xc92a,		0x21, 0
	.dw 0x2cc0, 0xc92a,	0x2cff, 0xc92a,		0x21, 0
	.dw 0x2d40, 0xc92a,	0x2d7f, 0xc92a,		0x21, 0
	.dw 0x2dc0, 0xc92a,	0x2dff, 0xc92a,		0x21, 0
	.dw 0x2e40, 0xc92a,	0x2e7f, 0xc92a,		0x21, 0
	.dw 0x2ec0, 0xc92a,	0x2eff, 0xc92a,		0x21, 0
	.dw 0x2f40, 0xc92a,	0x2f7f, 0xc92a,		0x21, 0
	.dw 0x2fc0, 0xc92a,	0x2fff, 0xc92a,		0x21, 0
	.dw 0x3040, 0xc92a,	0x307f, 0xc92a,		0x21, 0
	.dw 0x30c0, 0xc92a,	0x30ff, 0xc92a,		0x21, 0
	.dw 0x3140, 0xc92a,	0x317f, 0xc92a,		0x21, 0
	.dw 0x31c0, 0xc92a,	0x31ff, 0xc92a,		0x21, 0
	.dw 0x3240, 0xc92a,	0x327f, 0xc92a,		0x21, 0
	.dw 0x32c0, 0xc92a,	0x32ff, 0xc92a,		0x21, 0
	.dw 0x3340, 0xc92a,	0x337f, 0xc92a,		0x21, 0
	.dw 0x33c0, 0xc92a,	0x33ff, 0xc92a,		0x21, 0
	.dw 0x3440, 0xc92a,	0x347f, 0xc92a,		0x21, 0
	.dw 0x34c0, 0xc92a,	0x34ff, 0xc92a,		0x21, 0
	.dw 0x3540, 0xc92a,	0x357f, 0xc92a,		0x21, 0
	.dw 0x35c0, 0xc92a,	0x35ff, 0xc92a,		0x21, 0
	.dw 0x3640, 0xc92a,	0x367f, 0xc92a,		0x21, 0
	.dw 0x36c0, 0xc92a,	0x36ff, 0xc92a,		0x21, 0
	.dw 0x3740, 0xc92a,	0x377f, 0xc92a,		0x21, 0
	.dw 0x37c0, 0xc92a,	0x37ff, 0xc92a,		0x21, 0
	.dw 0x3840, 0xc92a,	0x387f, 0xc92a,		0x21, 0
	.dw 0x38c0, 0xc92a,	0x38ff, 0xc92a,		0x21, 0
	.dw 0x3940, 0xc92a,	0x397f, 0xc92a,		0x21, 0
	.dw 0x39c0, 0xc92a,	0x5fff, 0xc92a,		0x21, 0
	.dw 0x6040, 0xc92a,	0x607f, 0xc92a,		0x21, 0
	.dw 0x60c0, 0xc92a,	0x60ff, 0xc92a,		0x21, 0
	.dw 0x6140, 0xc92a,	0x617f, 0xc92a,		0x21, 0
	.dw 0x61c0, 0xc92a,	0x61ff, 0xc92a,		0x21, 0
	.dw 0x6240, 0xc92a,	0x627f, 0xc92a,		0x21, 0
	.dw 0x62c0, 0xc92a,	0x62ff, 0xc92a,		0x21, 0
	.dw 0x6340, 0xc92a,	0x637f, 0xc92a,		0x21, 0
	.dw 0x63c0, 0xc92a,	0x63ff, 0xc92a,		0x21, 0
	.dw 0x6440, 0xc92a,	0x647f, 0xc92a,		0x21, 0
	.dw 0x64c0, 0xc92a,	0x64ff, 0xc92a,		0x21, 0
	.dw 0x6540, 0xc92a,	0x657f, 0xc92a,		0x21, 0
	.dw 0x65c0, 0xc92a,	0x65ff, 0xc92a,		0x21, 0
	.dw 0x6640, 0xc92a,	0x667f, 0xc92a,		0x21, 0
	.dw 0x66c0, 0xc92a,	0x66ff, 0xc92a,		0x21, 0
	.dw 0x6740, 0xc92a,	0x677f, 0xc92a,		0x21, 0
	.dw 0x67c0, 0xc92a,	0x67ff, 0xc92a,		0x21, 0
	.dw 0x6840, 0xc92a,	0x687f, 0xc92a,		0x21, 0
	.dw 0x68c0, 0xc92a,	0x68ff, 0xc92a,		0x21, 0
	.dw 0x6940, 0xc92a,	0x697f, 0xc92a,		0x21, 0
	.dw 0x69c0, 0xc92a,	0x69ff, 0xc92a,		0x21, 0
	.dw 0x6a40, 0xc92a,	0x6a7f, 0xc92a,		0x21, 0
	.dw 0x6ac0, 0xc92a,	0x6aff, 0xc92a,		0x21, 0
	.dw 0x6b40, 0xc92a,	0x6b7f, 0xc92a,		0x21, 0
	.dw 0x6bc0, 0xc92a,	0x6bff, 0xc92a,		0x21, 0
	.dw 0x6c40, 0xc92a,	0x6c7f, 0xc92a,		0x21, 0
	.dw 0x6cc0, 0xc92a,	0x6cff, 0xc92a,		0x21, 0
	.dw 0x6d40, 0xc92a,	0x6d7f, 0xc92a,		0x21, 0
	.dw 0x6dc0, 0xc92a,	0x6dff, 0xc92a,		0x21, 0
	.dw 0x6e40, 0xc92a,	0x6e7f, 0xc92a,		0x21, 0
	.dw 0x6ec0, 0xc92a,	0x6eff, 0xc92a,		0x21, 0
	.dw 0x6f40, 0xc92a,	0x6f7f, 0xc92a,		0x21, 0
	.dw 0x6fc0, 0xc92a,	0x6fff, 0xc92a,		0x21, 0
	.dw 0x7040, 0xc92a,	0x707f, 0xc92a,		0x21, 0
	.dw 0x70c0, 0xc92a,	0x70ff, 0xc92a,		0x21, 0
	.dw 0x7140, 0xc92a,	0x717f, 0xc92a,		0x21, 0
	.dw 0x71c0, 0xc92a,	0x71ff, 0xc92a,		0x21, 0
	.dw 0x7240, 0xc92a,	0x727f, 0xc92a,		0x21, 0
	.dw 0x72c0, 0xc92a,	0x72ff, 0xc92a,		0x21, 0
	.dw 0x7340, 0xc92a,	0x737f, 0xc92a,		0x21, 0
	.dw 0x73c0, 0xc92a,	0x73ff, 0xc92a,		0x21, 0
	.dw 0x7440, 0xc92a,	0x747f, 0xc92a,		0x21, 0
	.dw 0x74c0, 0xc92a,	0x74ff, 0xc92a,		0x21, 0
	.dw 0x7540, 0xc92a,	0x757f, 0xc92a,		0x21, 0
	.dw 0x75c0, 0xc92a,	0x75ff, 0xc92a,		0x21, 0
	.dw 0x7640, 0xc92a,	0x767f, 0xc92a,		0x21, 0
	.dw 0x76c0, 0xc92a,	0x76ff, 0xc92a,		0x21, 0
	.dw 0x7740, 0xc92a,	0x777f, 0xc92a,		0x21, 0
	.dw 0x77c0, 0xc92a,	0x77ff, 0xc92a,		0x21, 0
	.dw 0x7840, 0xc92a,	0x787f, 0xc92a,		0x21, 0
	.dw 0x78c0, 0xc92a,	0x78ff, 0xc92a,		0x21, 0
	.dw 0x7940, 0xc92a,	0x797f, 0xc92a,		0x21, 0
	.dw 0x79c0, 0xc92a,	0x9fff, 0xc92a,		0x21, 0
	.dw 0xa040, 0xc92a,	0xa07f, 0xc92a,		0x21, 0
	.dw 0xa0c0, 0xc92a,	0xa0ff, 0xc92a,		0x21, 0
	.dw 0xa140, 0xc92a,	0xa17f, 0xc92a,		0x21, 0
	.dw 0xa1c0, 0xc92a,	0xa1ff, 0xc92a,		0x21, 0
	.dw 0xa240, 0xc92a,	0xa27f, 0xc92a,		0x21, 0
	.dw 0xa2c0, 0xc92a,	0xa2ff, 0xc92a,		0x21, 0
	.dw 0xa340, 0xc92a,	0xa37f, 0xc92a,		0x21, 0
	.dw 0xa3c0, 0xc92a,	0xa3ff, 0xc92a,		0x21, 0
	.dw 0xa440, 0xc92a,	0xa47f, 0xc92a,		0x21, 0
	.dw 0xa4c0, 0xc92a,	0xa4ff, 0xc92a,		0x21, 0
	.dw 0xa540, 0xc92a,	0xa57f, 0xc92a,		0x21, 0
	.dw 0xa5c0, 0xc92a,	0xa5ff, 0xc92a,		0x21, 0
	.dw 0xa640, 0xc92a,	0xa67f, 0xc92a,		0x21, 0
	.dw 0xa6c0, 0xc92a,	0xa6ff, 0xc92a,		0x21, 0
	.dw 0xa740, 0xc92a,	0xa77f, 0xc92a,		0x21, 0
	.dw 0xa7c0, 0xc92a,	0xa7ff, 0xc92a,		0x21, 0
	.dw 0xa840, 0xc92a,	0xa87f, 0xc92a,		0x21, 0
	.dw 0xa8c0, 0xc92a,	0xa8ff, 0xc92a,		0x21, 0
	.dw 0xa940, 0xc92a,	0xa97f, 0xc92a,		0x21, 0
	.dw 0xa9c0, 0xc92a,	0xa9ff, 0xc92a,		0x21, 0
	.dw 0xaa40, 0xc92a,	0xaa7f, 0xc92a,		0x21, 0
	.dw 0xaac0, 0xc92a,	0xaaff, 0xc92a,		0x21, 0
	.dw 0xab40, 0xc92a,	0xab7f, 0xc92a,		0x21, 0
	.dw 0xabc0, 0xc92a,	0xabff, 0xc92a,		0x21, 0
	.dw 0xac40, 0xc92a,	0xac7f, 0xc92a,		0x21, 0
	.dw 0xacc0, 0xc92a,	0xacff, 0xc92a,		0x21, 0
	.dw 0xad40, 0xc92a,	0xad7f, 0xc92a,		0x21, 0
	.dw 0xadc0, 0xc92a,	0xadff, 0xc92a,		0x21, 0
	.dw 0xae40, 0xc92a,	0xae7f, 0xc92a,		0x21, 0
	.dw 0xaec0, 0xc92a,	0xaeff, 0xc92a,		0x21, 0
	.dw 0xaf40, 0xc92a,	0xaf7f, 0xc92a,		0x21, 0
	.dw 0xafc0, 0xc92a,	0xafff, 0xc92a,		0x21, 0
	.dw 0xb040, 0xc92a,	0xb07f, 0xc92a,		0x21, 0
	.dw 0xb0c0, 0xc92a,	0xb0ff, 0xc92a,		0x21, 0
	.dw 0xb140, 0xc92a,	0xb17f, 0xc92a,		0x21, 0
	.dw 0xb1c0, 0xc92a,	0xb1ff, 0xc92a,		0x21, 0
	.dw 0xb240, 0xc92a,	0xb27f, 0xc92a,		0x21, 0
	.dw 0xb2c0, 0xc92a,	0xb2ff, 0xc92a,		0x21, 0
	.dw 0xb340, 0xc92a,	0xb37f, 0xc92a,		0x21, 0
	.dw 0xb3c0, 0xc92a,	0xb3ff, 0xc92a,		0x21, 0
	.dw 0xb440, 0xc92a,	0xb47f, 0xc92a,		0x21, 0
	.dw 0xb4c0, 0xc92a,	0xb4ff, 0xc92a,		0x21, 0
	.dw 0xb540, 0xc92a,	0xb57f, 0xc92a,		0x21, 0
	.dw 0xb5c0, 0xc92a,	0xb5ff, 0xc92a,		0x21, 0
	.dw 0xb640, 0xc92a,	0xb67f, 0xc92a,		0x21, 0
	.dw 0xb6c0, 0xc92a,	0xb6ff, 0xc92a,		0x21, 0
	.dw 0xb740, 0xc92a,	0xb77f, 0xc92a,		0x21, 0
	.dw 0xb7c0, 0xc92a,	0xb7ff, 0xc92a,		0x21, 0
	.dw 0xb840, 0xc92a,	0xb87f, 0xc92a,		0x21, 0
	.dw 0xb8c0, 0xc92a,	0xb8ff, 0xc92a,		0x21, 0
	.dw 0xb940, 0xc92a,	0xb97f, 0xc92a,		0x21, 0
	.dw 0xb9c0, 0xc92a,	0xdfff, 0xc92a,		0x21, 0
	.dw 0xe040, 0xc92a,	0xe07f, 0xc92a,		0x21, 0
	.dw 0xe0c0, 0xc92a,	0xe0ff, 0xc92a,		0x21, 0
	.dw 0xe140, 0xc92a,	0xe17f, 0xc92a,		0x21, 0
	.dw 0xe1c0, 0xc92a,	0xe1ff, 0xc92a,		0x21, 0
	.dw 0xe240, 0xc92a,	0xe27f, 0xc92a,		0x21, 0
	.dw 0xe2c0, 0xc92a,	0xe2ff, 0xc92a,		0x21, 0
	.dw 0xe340, 0xc92a,	0xe37f, 0xc92a,		0x21, 0
	.dw 0xe3c0, 0xc92a,	0xe3ff, 0xc92a,		0x21, 0
	.dw 0xe440, 0xc92a,	0xe47f, 0xc92a,		0x21, 0
	.dw 0xe4c0, 0xc92a,	0xe4ff, 0xc92a,		0x21, 0
	.dw 0xe540, 0xc92a,	0xe57f, 0xc92a,		0x21, 0
	.dw 0xe5c0, 0xc92a,	0xe5ff, 0xc92a,		0x21, 0
	.dw 0xe640, 0xc92a,	0xe67f, 0xc92a,		0x21, 0
	.dw 0xe6c0, 0xc92a,	0xe6ff, 0xc92a,		0x21, 0
	.dw 0xe740, 0xc92a,	0xe77f, 0xc92a,		0x21, 0
	.dw 0xe7c0, 0xc92a,	0xe7ff, 0xc92a,		0x21, 0
	.dw 0xe840, 0xc92a,	0xe87f, 0xc92a,		0x21, 0
	.dw 0xe8c0, 0xc92a,	0xe8ff, 0xc92a,		0x21, 0
	.dw 0xe940, 0xc92a,	0xe97f, 0xc92a,		0x21, 0
	.dw 0xe9c0, 0xc92a,	0xe9ff, 0xc92a,		0x21, 0
	.dw 0xea40, 0xc92a,	0xea7f, 0xc92a,		0x21, 0
	.dw 0xeac0, 0xc92a,	0xeaff, 0xc92a,		0x21, 0
	.dw 0xeb40, 0xc92a,	0xeb7f, 0xc92a,		0x21, 0
	.dw 0xebc0, 0xc92a,	0xebff, 0xc92a,		0x21, 0
	.dw 0xec40, 0xc92a,	0xec7f, 0xc92a,		0x21, 0
	.dw 0xecc0, 0xc92a,	0xecff, 0xc92a,		0x21, 0
	.dw 0xed40, 0xc92a,	0xed7f, 0xc92a,		0x21, 0
	.dw 0xedc0, 0xc92a,	0xedff, 0xc92a,		0x21, 0
	.dw 0xee40, 0xc92a,	0xee7f, 0xc92a,		0x21, 0
	.dw 0xeec0, 0xc92a,	0xeeff, 0xc92a,		0x21, 0
	.dw 0xef40, 0xc92a,	0xef7f, 0xc92a,		0x21, 0
	.dw 0xefc0, 0xc92a,	0xefff, 0xc92a,		0x21, 0
	.dw 0xf040, 0xc92a,	0xf07f, 0xc92a,		0x21, 0
	.dw 0xf0c0, 0xc92a,	0xf0ff, 0xc92a,		0x21, 0
	.dw 0xf140, 0xc92a,	0xf17f, 0xc92a,		0x21, 0
	.dw 0xf1c0, 0xc92a,	0xf1ff, 0xc92a,		0x21, 0
	.dw 0xf240, 0xc92a,	0xf27f, 0xc92a,		0x21, 0
	.dw 0xf2c0, 0xc92a,	0xf2ff, 0xc92a,		0x21, 0
	.dw 0xf340, 0xc92a,	0xf37f, 0xc92a,		0x21, 0
	.dw 0xf3c0, 0xc92a,	0xf3ff, 0xc92a,		0x21, 0
	.dw 0xf440, 0xc92a,	0xf47f, 0xc92a,		0x21, 0
	.dw 0xf4c0, 0xc92a,	0xf4ff, 0xc92a,		0x21, 0
	.dw 0xf540, 0xc92a,	0xf57f, 0xc92a,		0x21, 0
	.dw 0xf5c0, 0xc92a,	0xf5ff, 0xc92a,		0x21, 0
	.dw 0xf640, 0xc92a,	0xf67f, 0xc92a,		0x21, 0
	.dw 0xf6c0, 0xc92a,	0xf6ff, 0xc92a,		0x21, 0
	.dw 0xf740, 0xc92a,	0xf77f, 0xc92a,		0x21, 0
	.dw 0xf7c0, 0xc92a,	0xf7ff, 0xc92a,		0x21, 0
	.dw 0xf840, 0xc92a,	0xf87f, 0xc92a,		0x21, 0
	.dw 0xf8c0, 0xc92a,	0xf8ff, 0xc92a,		0x21, 0
	.dw 0xf940, 0xc92a,	0xf97f, 0xc92a,		0x21, 0
	.dw 0xf9c0, 0xc92a,	0x1fff, 0xc92b,		0x21, 0
	.dw 0x2040, 0xc92b,	0x207f, 0xc92b,		0x21, 0
	.dw 0x20c0, 0xc92b,	0x20ff, 0xc92b,		0x21, 0
	.dw 0x2140, 0xc92b,	0x217f, 0xc92b,		0x21, 0
	.dw 0x21c0, 0xc92b,	0x21ff, 0xc92b,		0x21, 0
	.dw 0x2240, 0xc92b,	0x227f, 0xc92b,		0x21, 0
	.dw 0x22c0, 0xc92b,	0x22ff, 0xc92b,		0x21, 0
	.dw 0x2340, 0xc92b,	0x237f, 0xc92b,		0x21, 0
	.dw 0x23c0, 0xc92b,	0x23ff, 0xc92b,		0x21, 0
	.dw 0x2440, 0xc92b,	0x247f, 0xc92b,		0x21, 0
	.dw 0x24c0, 0xc92b,	0x24ff, 0xc92b,		0x21, 0
	.dw 0x2540, 0xc92b,	0x257f, 0xc92b,		0x21, 0
	.dw 0x25c0, 0xc92b,	0x25ff, 0xc92b,		0x21, 0
	.dw 0x2640, 0xc92b,	0x267f, 0xc92b,		0x21, 0
	.dw 0x26c0, 0xc92b,	0x26ff, 0xc92b,		0x21, 0
	.dw 0x2740, 0xc92b,	0x277f, 0xc92b,		0x21, 0
	.dw 0x27c0, 0xc92b,	0x27ff, 0xc92b,		0x21, 0
	.dw 0x2840, 0xc92b,	0x287f, 0xc92b,		0x21, 0
	.dw 0x28c0, 0xc92b,	0x28ff, 0xc92b,		0x21, 0
	.dw 0x2940, 0xc92b,	0x297f, 0xc92b,		0x21, 0
	.dw 0x29c0, 0xc92b,	0x29ff, 0xc92b,		0x21, 0
	.dw 0x2a40, 0xc92b,	0x2a7f, 0xc92b,		0x21, 0
	.dw 0x2ac0, 0xc92b,	0x2aff, 0xc92b,		0x21, 0
	.dw 0x2b40, 0xc92b,	0x2b7f, 0xc92b,		0x21, 0
	.dw 0x2bc0, 0xc92b,	0x2bff, 0xc92b,		0x21, 0
	.dw 0x2c40, 0xc92b,	0x2c7f, 0xc92b,		0x21, 0
	.dw 0x2cc0, 0xc92b,	0x2cff, 0xc92b,		0x21, 0
	.dw 0x2d40, 0xc92b,	0x2d7f, 0xc92b,		0x21, 0
	.dw 0x2dc0, 0xc92b,	0x2dff, 0xc92b,		0x21, 0
	.dw 0x2e40, 0xc92b,	0x2e7f, 0xc92b,		0x21, 0
	.dw 0x2ec0, 0xc92b,	0x2eff, 0xc92b,		0x21, 0
	.dw 0x2f40, 0xc92b,	0x2f7f, 0xc92b,		0x21, 0
	.dw 0x2fc0, 0xc92b,	0x2fff, 0xc92b,		0x21, 0
	.dw 0x3040, 0xc92b,	0x307f, 0xc92b,		0x21, 0
	.dw 0x30c0, 0xc92b,	0x30ff, 0xc92b,		0x21, 0
	.dw 0x3140, 0xc92b,	0x317f, 0xc92b,		0x21, 0
	.dw 0x31c0, 0xc92b,	0x31ff, 0xc92b,		0x21, 0
	.dw 0x3240, 0xc92b,	0x327f, 0xc92b,		0x21, 0
	.dw 0x32c0, 0xc92b,	0x32ff, 0xc92b,		0x21, 0
	.dw 0x3340, 0xc92b,	0x337f, 0xc92b,		0x21, 0
	.dw 0x33c0, 0xc92b,	0x33ff, 0xc92b,		0x21, 0
	.dw 0x3440, 0xc92b,	0x347f, 0xc92b,		0x21, 0
	.dw 0x34c0, 0xc92b,	0x34ff, 0xc92b,		0x21, 0
	.dw 0x3540, 0xc92b,	0x357f, 0xc92b,		0x21, 0
	.dw 0x35c0, 0xc92b,	0x35ff, 0xc92b,		0x21, 0
	.dw 0x3640, 0xc92b,	0x367f, 0xc92b,		0x21, 0
	.dw 0x36c0, 0xc92b,	0x36ff, 0xc92b,		0x21, 0
	.dw 0x3740, 0xc92b,	0x377f, 0xc92b,		0x21, 0
	.dw 0x37c0, 0xc92b,	0x37ff, 0xc92b,		0x21, 0
	.dw 0x3840, 0xc92b,	0x387f, 0xc92b,		0x21, 0
	.dw 0x38c0, 0xc92b,	0x38ff, 0xc92b,		0x21, 0
	.dw 0x3940, 0xc92b,	0x397f, 0xc92b,		0x21, 0
	.dw 0x39c0, 0xc92b,	0xffff, 0xc92b,		0x21, 0
	.dw 0x0040, 0xc92c,	0x007f, 0xc92c,		0x21, 0
	.dw 0x00c0, 0xc92c,	0x00ff, 0xc92c,		0x21, 0
	.dw 0x0140, 0xc92c,	0x017f, 0xc92c,		0x21, 0
	.dw 0x01c0, 0xc92c,	0x01ff, 0xc92c,		0x21, 0
	.dw 0x0240, 0xc92c,	0x027f, 0xc92c,		0x21, 0
	.dw 0x02c0, 0xc92c,	0x02ff, 0xc92c,		0x21, 0
	.dw 0x0340, 0xc92c,	0x037f, 0xc92c,		0x21, 0
	.dw 0x03c0, 0xc92c,	0x03ff, 0xc92c,		0x21, 0
	.dw 0x0440, 0xc92c,	0x047f, 0xc92c,		0x21, 0
	.dw 0x04c0, 0xc92c,	0x04ff, 0xc92c,		0x21, 0
	.dw 0x0540, 0xc92c,	0x057f, 0xc92c,		0x21, 0
	.dw 0x05c0, 0xc92c,	0x05ff, 0xc92c,		0x21, 0
	.dw 0x0640, 0xc92c,	0x067f, 0xc92c,		0x21, 0
	.dw 0x06c0, 0xc92c,	0x06ff, 0xc92c,		0x21, 0
	.dw 0x0740, 0xc92c,	0x077f, 0xc92c,		0x21, 0
	.dw 0x07c0, 0xc92c,	0x07ff, 0xc92c,		0x21, 0
	.dw 0x0840, 0xc92c,	0x087f, 0xc92c,		0x21, 0
	.dw 0x08c0, 0xc92c,	0x08ff, 0xc92c,		0x21, 0
	.dw 0x0940, 0xc92c,	0x097f, 0xc92c,		0x21, 0
	.dw 0x09c0, 0xc92c,	0x09ff, 0xc92c,		0x21, 0
	.dw 0x0a40, 0xc92c,	0x0a7f, 0xc92c,		0x21, 0
	.dw 0x0ac0, 0xc92c,	0x0aff, 0xc92c,		0x21, 0
	.dw 0x0b40, 0xc92c,	0x0b7f, 0xc92c,		0x21, 0
	.dw 0x0bc0, 0xc92c,	0x0bff, 0xc92c,		0x21, 0
	.dw 0x0c40, 0xc92c,	0x0c7f, 0xc92c,		0x21, 0
	.dw 0x0cc0, 0xc92c,	0x0cff, 0xc92c,		0x21, 0
	.dw 0x0d40, 0xc92c,	0x0d7f, 0xc92c,		0x21, 0
	.dw 0x0dc0, 0xc92c,	0x0dff, 0xc92c,		0x21, 0
	.dw 0x0e40, 0xc92c,	0x0e7f, 0xc92c,		0x21, 0
	.dw 0x0ec0, 0xc92c,	0x0eff, 0xc92c,		0x21, 0
	.dw 0x0f40, 0xc92c,	0x0f7f, 0xc92c,		0x21, 0
	.dw 0x0fc0, 0xc92c,	0x0fff, 0xc92c,		0x21, 0
	.dw 0x1040, 0xc92c,	0x107f, 0xc92c,		0x21, 0
	.dw 0x10c0, 0xc92c,	0x10ff, 0xc92c,		0x21, 0
	.dw 0x1140, 0xc92c,	0x117f, 0xc92c,		0x21, 0
	.dw 0x11c0, 0xc92c,	0x11ff, 0xc92c,		0x21, 0
	.dw 0x1240, 0xc92c,	0x127f, 0xc92c,		0x21, 0
	.dw 0x12c0, 0xc92c,	0x12ff, 0xc92c,		0x21, 0
	.dw 0x1340, 0xc92c,	0x137f, 0xc92c,		0x21, 0
	.dw 0x13c0, 0xc92c,	0x13ff, 0xc92c,		0x21, 0
	.dw 0x1440, 0xc92c,	0x147f, 0xc92c,		0x21, 0
	.dw 0x14c0, 0xc92c,	0x14ff, 0xc92c,		0x21, 0
	.dw 0x1540, 0xc92c,	0x157f, 0xc92c,		0x21, 0
	.dw 0x15c0, 0xc92c,	0x15ff, 0xc92c,		0x21, 0
	.dw 0x1640, 0xc92c,	0x167f, 0xc92c,		0x21, 0
	.dw 0x16c0, 0xc92c,	0x16ff, 0xc92c,		0x21, 0
	.dw 0x1740, 0xc92c,	0x177f, 0xc92c,		0x21, 0
	.dw 0x17c0, 0xc92c,	0x17ff, 0xc92c,		0x21, 0
	.dw 0x1840, 0xc92c,	0x187f, 0xc92c,		0x21, 0
	.dw 0x18c0, 0xc92c,	0x18ff, 0xc92c,		0x21, 0
	.dw 0x1940, 0xc92c,	0x197f, 0xc92c,		0x21, 0
	.dw 0x19c0, 0xc92c,	0x1fff, 0xc92c,		0x21, 0
	.dw 0x2040, 0xc92c,	0x207f, 0xc92c,		0x21, 0
	.dw 0x20c0, 0xc92c,	0x20ff, 0xc92c,		0x21, 0
	.dw 0x2140, 0xc92c,	0x217f, 0xc92c,		0x21, 0
	.dw 0x21c0, 0xc92c,	0x21ff, 0xc92c,		0x21, 0
	.dw 0x2240, 0xc92c,	0x227f, 0xc92c,		0x21, 0
	.dw 0x22c0, 0xc92c,	0x22ff, 0xc92c,		0x21, 0
	.dw 0x2340, 0xc92c,	0x237f, 0xc92c,		0x21, 0
	.dw 0x23c0, 0xc92c,	0x23ff, 0xc92c,		0x21, 0
	.dw 0x2440, 0xc92c,	0x247f, 0xc92c,		0x21, 0
	.dw 0x24c0, 0xc92c,	0x24ff, 0xc92c,		0x21, 0
	.dw 0x2540, 0xc92c,	0x257f, 0xc92c,		0x21, 0
	.dw 0x25c0, 0xc92c,	0x25ff, 0xc92c,		0x21, 0
	.dw 0x2640, 0xc92c,	0x267f, 0xc92c,		0x21, 0
	.dw 0x26c0, 0xc92c,	0x26ff, 0xc92c,		0x21, 0
	.dw 0x2740, 0xc92c,	0x277f, 0xc92c,		0x21, 0
	.dw 0x27c0, 0xc92c,	0x27ff, 0xc92c,		0x21, 0
	.dw 0x2840, 0xc92c,	0x287f, 0xc92c,		0x21, 0
	.dw 0x28c0, 0xc92c,	0x28ff, 0xc92c,		0x21, 0
	.dw 0x2940, 0xc92c,	0x297f, 0xc92c,		0x21, 0
	.dw 0x29c0, 0xc92c,	0x29ff, 0xc92c,		0x21, 0
	.dw 0x2a40, 0xc92c,	0x2a7f, 0xc92c,		0x21, 0
	.dw 0x2ac0, 0xc92c,	0x2aff, 0xc92c,		0x21, 0
	.dw 0x2b40, 0xc92c,	0x2b7f, 0xc92c,		0x21, 0
	.dw 0x2bc0, 0xc92c,	0x2bff, 0xc92c,		0x21, 0
	.dw 0x2c40, 0xc92c,	0x2c7f, 0xc92c,		0x21, 0
	.dw 0x2cc0, 0xc92c,	0x2cff, 0xc92c,		0x21, 0
	.dw 0x2d40, 0xc92c,	0x2d7f, 0xc92c,		0x21, 0
	.dw 0x2dc0, 0xc92c,	0x2dff, 0xc92c,		0x21, 0
	.dw 0x2e40, 0xc92c,	0x2e7f, 0xc92c,		0x21, 0
	.dw 0x2ec0, 0xc92c,	0x2eff, 0xc92c,		0x21, 0
	.dw 0x2f40, 0xc92c,	0x2f7f, 0xc92c,		0x21, 0
	.dw 0x2fc0, 0xc92c,	0x2fff, 0xc92c,		0x21, 0
	.dw 0x3040, 0xc92c,	0x307f, 0xc92c,		0x21, 0
	.dw 0x30c0, 0xc92c,	0x30ff, 0xc92c,		0x21, 0
	.dw 0x3140, 0xc92c,	0x317f, 0xc92c,		0x21, 0
	.dw 0x31c0, 0xc92c,	0x31ff, 0xc92c,		0x21, 0
	.dw 0x3240, 0xc92c,	0x327f, 0xc92c,		0x21, 0
	.dw 0x32c0, 0xc92c,	0x32ff, 0xc92c,		0x21, 0
	.dw 0x3340, 0xc92c,	0x337f, 0xc92c,		0x21, 0
	.dw 0x33c0, 0xc92c,	0x33ff, 0xc92c,		0x21, 0
	.dw 0x3440, 0xc92c,	0x347f, 0xc92c,		0x21, 0
	.dw 0x34c0, 0xc92c,	0x34ff, 0xc92c,		0x21, 0
	.dw 0x3540, 0xc92c,	0x357f, 0xc92c,		0x21, 0
	.dw 0x35c0, 0xc92c,	0x35ff, 0xc92c,		0x21, 0
	.dw 0x3640, 0xc92c,	0x367f, 0xc92c,		0x21, 0
	.dw 0x36c0, 0xc92c,	0x36ff, 0xc92c,		0x21, 0
	.dw 0x3740, 0xc92c,	0x377f, 0xc92c,		0x21, 0
	.dw 0x37c0, 0xc92c,	0x37ff, 0xc92c,		0x21, 0
	.dw 0x3840, 0xc92c,	0x387f, 0xc92c,		0x21, 0
	.dw 0x38c0, 0xc92c,	0x38ff, 0xc92c,		0x21, 0
	.dw 0x3940, 0xc92c,	0x397f, 0xc92c,		0x21, 0
	.dw 0x39c0, 0xc92c,	0x3fff, 0xc92c,		0x21, 0
	.dw 0x4040, 0xc92c,	0x407f, 0xc92c,		0x21, 0
	.dw 0x40c0, 0xc92c,	0x40ff, 0xc92c,		0x21, 0
	.dw 0x4140, 0xc92c,	0x417f, 0xc92c,		0x21, 0
	.dw 0x41c0, 0xc92c,	0x41ff, 0xc92c,		0x21, 0
	.dw 0x4240, 0xc92c,	0x427f, 0xc92c,		0x21, 0
	.dw 0x42c0, 0xc92c,	0x42ff, 0xc92c,		0x21, 0
	.dw 0x4340, 0xc92c,	0x437f, 0xc92c,		0x21, 0
	.dw 0x43c0, 0xc92c,	0x43ff, 0xc92c,		0x21, 0
	.dw 0x4440, 0xc92c,	0x447f, 0xc92c,		0x21, 0
	.dw 0x44c0, 0xc92c,	0x44ff, 0xc92c,		0x21, 0
	.dw 0x4540, 0xc92c,	0x457f, 0xc92c,		0x21, 0
	.dw 0x45c0, 0xc92c,	0x45ff, 0xc92c,		0x21, 0
	.dw 0x4640, 0xc92c,	0x467f, 0xc92c,		0x21, 0
	.dw 0x46c0, 0xc92c,	0x46ff, 0xc92c,		0x21, 0
	.dw 0x4740, 0xc92c,	0x477f, 0xc92c,		0x21, 0
	.dw 0x47c0, 0xc92c,	0x47ff, 0xc92c,		0x21, 0
	.dw 0x4840, 0xc92c,	0x487f, 0xc92c,		0x21, 0
	.dw 0x48c0, 0xc92c,	0x48ff, 0xc92c,		0x21, 0
	.dw 0x4940, 0xc92c,	0x497f, 0xc92c,		0x21, 0
	.dw 0x49c0, 0xc92c,	0x49ff, 0xc92c,		0x21, 0
	.dw 0x4a40, 0xc92c,	0x4a7f, 0xc92c,		0x21, 0
	.dw 0x4ac0, 0xc92c,	0x4aff, 0xc92c,		0x21, 0
	.dw 0x4b40, 0xc92c,	0x4b7f, 0xc92c,		0x21, 0
	.dw 0x4bc0, 0xc92c,	0x4bff, 0xc92c,		0x21, 0
	.dw 0x4c40, 0xc92c,	0x4c7f, 0xc92c,		0x21, 0
	.dw 0x4cc0, 0xc92c,	0x4cff, 0xc92c,		0x21, 0
	.dw 0x4d40, 0xc92c,	0x4d7f, 0xc92c,		0x21, 0
	.dw 0x4dc0, 0xc92c,	0x4dff, 0xc92c,		0x21, 0
	.dw 0x4e40, 0xc92c,	0x4e7f, 0xc92c,		0x21, 0
	.dw 0x4ec0, 0xc92c,	0x4eff, 0xc92c,		0x21, 0
	.dw 0x4f40, 0xc92c,	0x4f7f, 0xc92c,		0x21, 0
	.dw 0x4fc0, 0xc92c,	0x4fff, 0xc92c,		0x21, 0
	.dw 0x5040, 0xc92c,	0x507f, 0xc92c,		0x21, 0
	.dw 0x50c0, 0xc92c,	0x50ff, 0xc92c,		0x21, 0
	.dw 0x5140, 0xc92c,	0x517f, 0xc92c,		0x21, 0
	.dw 0x51c0, 0xc92c,	0x51ff, 0xc92c,		0x21, 0
	.dw 0x5240, 0xc92c,	0x527f, 0xc92c,		0x21, 0
	.dw 0x52c0, 0xc92c,	0x52ff, 0xc92c,		0x21, 0
	.dw 0x5340, 0xc92c,	0x537f, 0xc92c,		0x21, 0
	.dw 0x53c0, 0xc92c,	0x53ff, 0xc92c,		0x21, 0
	.dw 0x5440, 0xc92c,	0x547f, 0xc92c,		0x21, 0
	.dw 0x54c0, 0xc92c,	0x54ff, 0xc92c,		0x21, 0
	.dw 0x5540, 0xc92c,	0x557f, 0xc92c,		0x21, 0
	.dw 0x55c0, 0xc92c,	0x55ff, 0xc92c,		0x21, 0
	.dw 0x5640, 0xc92c,	0x567f, 0xc92c,		0x21, 0
	.dw 0x56c0, 0xc92c,	0x56ff, 0xc92c,		0x21, 0
	.dw 0x5740, 0xc92c,	0x577f, 0xc92c,		0x21, 0
	.dw 0x57c0, 0xc92c,	0x57ff, 0xc92c,		0x21, 0
	.dw 0x5840, 0xc92c,	0x587f, 0xc92c,		0x21, 0
	.dw 0x58c0, 0xc92c,	0x58ff, 0xc92c,		0x21, 0
	.dw 0x5940, 0xc92c,	0x597f, 0xc92c,		0x21, 0
	.dw 0x59c0, 0xc92c,	0x5fff, 0xc92c,		0x21, 0
	.dw 0x6040, 0xc92c,	0x607f, 0xc92c,		0x21, 0
	.dw 0x60c0, 0xc92c,	0x60ff, 0xc92c,		0x21, 0
	.dw 0x6140, 0xc92c,	0x617f, 0xc92c,		0x21, 0
	.dw 0x61c0, 0xc92c,	0x61ff, 0xc92c,		0x21, 0
	.dw 0x6240, 0xc92c,	0x627f, 0xc92c,		0x21, 0
	.dw 0x62c0, 0xc92c,	0x62ff, 0xc92c,		0x21, 0
	.dw 0x6340, 0xc92c,	0x637f, 0xc92c,		0x21, 0
	.dw 0x63c0, 0xc92c,	0x63ff, 0xc92c,		0x21, 0
	.dw 0x6440, 0xc92c,	0x647f, 0xc92c,		0x21, 0
	.dw 0x64c0, 0xc92c,	0x64ff, 0xc92c,		0x21, 0
	.dw 0x6540, 0xc92c,	0x657f, 0xc92c,		0x21, 0
	.dw 0x65c0, 0xc92c,	0x65ff, 0xc92c,		0x21, 0
	.dw 0x6640, 0xc92c,	0x667f, 0xc92c,		0x21, 0
	.dw 0x66c0, 0xc92c,	0x66ff, 0xc92c,		0x21, 0
	.dw 0x6740, 0xc92c,	0x677f, 0xc92c,		0x21, 0
	.dw 0x67c0, 0xc92c,	0x67ff, 0xc92c,		0x21, 0
	.dw 0x6840, 0xc92c,	0x687f, 0xc92c,		0x21, 0
	.dw 0x68c0, 0xc92c,	0x68ff, 0xc92c,		0x21, 0
	.dw 0x6940, 0xc92c,	0x697f, 0xc92c,		0x21, 0
	.dw 0x69c0, 0xc92c,	0x69ff, 0xc92c,		0x21, 0
	.dw 0x6a40, 0xc92c,	0x6a7f, 0xc92c,		0x21, 0
	.dw 0x6ac0, 0xc92c,	0x6aff, 0xc92c,		0x21, 0
	.dw 0x6b40, 0xc92c,	0x6b7f, 0xc92c,		0x21, 0
	.dw 0x6bc0, 0xc92c,	0x6bff, 0xc92c,		0x21, 0
	.dw 0x6c40, 0xc92c,	0x6c7f, 0xc92c,		0x21, 0
	.dw 0x6cc0, 0xc92c,	0x6cff, 0xc92c,		0x21, 0
	.dw 0x6d40, 0xc92c,	0x6d7f, 0xc92c,		0x21, 0
	.dw 0x6dc0, 0xc92c,	0x6dff, 0xc92c,		0x21, 0
	.dw 0x6e40, 0xc92c,	0x6e7f, 0xc92c,		0x21, 0
	.dw 0x6ec0, 0xc92c,	0x6eff, 0xc92c,		0x21, 0
	.dw 0x6f40, 0xc92c,	0x6f7f, 0xc92c,		0x21, 0
	.dw 0x6fc0, 0xc92c,	0x6fff, 0xc92c,		0x21, 0
	.dw 0x7040, 0xc92c,	0x707f, 0xc92c,		0x21, 0
	.dw 0x70c0, 0xc92c,	0x70ff, 0xc92c,		0x21, 0
	.dw 0x7140, 0xc92c,	0x717f, 0xc92c,		0x21, 0
	.dw 0x71c0, 0xc92c,	0x71ff, 0xc92c,		0x21, 0
	.dw 0x7240, 0xc92c,	0x727f, 0xc92c,		0x21, 0
	.dw 0x72c0, 0xc92c,	0x72ff, 0xc92c,		0x21, 0
	.dw 0x7340, 0xc92c,	0x737f, 0xc92c,		0x21, 0
	.dw 0x73c0, 0xc92c,	0x73ff, 0xc92c,		0x21, 0
	.dw 0x7440, 0xc92c,	0x747f, 0xc92c,		0x21, 0
	.dw 0x74c0, 0xc92c,	0x74ff, 0xc92c,		0x21, 0
	.dw 0x7540, 0xc92c,	0x757f, 0xc92c,		0x21, 0
	.dw 0x75c0, 0xc92c,	0x75ff, 0xc92c,		0x21, 0
	.dw 0x7640, 0xc92c,	0x767f, 0xc92c,		0x21, 0
	.dw 0x76c0, 0xc92c,	0x76ff, 0xc92c,		0x21, 0
	.dw 0x7740, 0xc92c,	0x777f, 0xc92c,		0x21, 0
	.dw 0x77c0, 0xc92c,	0x77ff, 0xc92c,		0x21, 0
	.dw 0x7840, 0xc92c,	0x787f, 0xc92c,		0x21, 0
	.dw 0x78c0, 0xc92c,	0x78ff, 0xc92c,		0x21, 0
	.dw 0x7940, 0xc92c,	0x797f, 0xc92c,		0x21, 0
	.dw 0x79c0, 0xc92c,	0x7fff, 0xc92c,		0x21, 0
	.dw 0x8040, 0xc92c,	0x807f, 0xc92c,		0x21, 0
	.dw 0x80c0, 0xc92c,	0x80ff, 0xc92c,		0x21, 0
	.dw 0x8140, 0xc92c,	0x817f, 0xc92c,		0x21, 0
	.dw 0x81c0, 0xc92c,	0x81ff, 0xc92c,		0x21, 0
	.dw 0x8240, 0xc92c,	0x827f, 0xc92c,		0x21, 0
	.dw 0x82c0, 0xc92c,	0x82ff, 0xc92c,		0x21, 0
	.dw 0x8340, 0xc92c,	0x837f, 0xc92c,		0x21, 0
	.dw 0x83c0, 0xc92c,	0x83ff, 0xc92c,		0x21, 0
	.dw 0x8440, 0xc92c,	0x847f, 0xc92c,		0x21, 0
	.dw 0x84c0, 0xc92c,	0x84ff, 0xc92c,		0x21, 0
	.dw 0x8540, 0xc92c,	0x857f, 0xc92c,		0x21, 0
	.dw 0x85c0, 0xc92c,	0x85ff, 0xc92c,		0x21, 0
	.dw 0x8640, 0xc92c,	0x867f, 0xc92c,		0x21, 0
	.dw 0x86c0, 0xc92c,	0x86ff, 0xc92c,		0x21, 0
	.dw 0x8740, 0xc92c,	0x877f, 0xc92c,		0x21, 0
	.dw 0x87c0, 0xc92c,	0x87ff, 0xc92c,		0x21, 0
	.dw 0x8840, 0xc92c,	0x887f, 0xc92c,		0x21, 0
	.dw 0x88c0, 0xc92c,	0x88ff, 0xc92c,		0x21, 0
	.dw 0x8940, 0xc92c,	0x897f, 0xc92c,		0x21, 0
	.dw 0x89c0, 0xc92c,	0x89ff, 0xc92c,		0x21, 0
	.dw 0x8a40, 0xc92c,	0x8a7f, 0xc92c,		0x21, 0
	.dw 0x8ac0, 0xc92c,	0x8aff, 0xc92c,		0x21, 0
	.dw 0x8b40, 0xc92c,	0x8b7f, 0xc92c,		0x21, 0
	.dw 0x8bc0, 0xc92c,	0x8bff, 0xc92c,		0x21, 0
	.dw 0x8c40, 0xc92c,	0x8c7f, 0xc92c,		0x21, 0
	.dw 0x8cc0, 0xc92c,	0x8cff, 0xc92c,		0x21, 0
	.dw 0x8d40, 0xc92c,	0x8d7f, 0xc92c,		0x21, 0
	.dw 0x8dc0, 0xc92c,	0x8dff, 0xc92c,		0x21, 0
	.dw 0x8e40, 0xc92c,	0x8e7f, 0xc92c,		0x21, 0
	.dw 0x8ec0, 0xc92c,	0x8eff, 0xc92c,		0x21, 0
	.dw 0x8f40, 0xc92c,	0x8f7f, 0xc92c,		0x21, 0
	.dw 0x8fc0, 0xc92c,	0x8fff, 0xc92c,		0x21, 0
	.dw 0x9040, 0xc92c,	0x907f, 0xc92c,		0x21, 0
	.dw 0x90c0, 0xc92c,	0x90ff, 0xc92c,		0x21, 0
	.dw 0x9140, 0xc92c,	0x917f, 0xc92c,		0x21, 0
	.dw 0x91c0, 0xc92c,	0x91ff, 0xc92c,		0x21, 0
	.dw 0x9240, 0xc92c,	0x927f, 0xc92c,		0x21, 0
	.dw 0x92c0, 0xc92c,	0x92ff, 0xc92c,		0x21, 0
	.dw 0x9340, 0xc92c,	0x937f, 0xc92c,		0x21, 0
	.dw 0x93c0, 0xc92c,	0x93ff, 0xc92c,		0x21, 0
	.dw 0x9440, 0xc92c,	0x947f, 0xc92c,		0x21, 0
	.dw 0x94c0, 0xc92c,	0x94ff, 0xc92c,		0x21, 0
	.dw 0x9540, 0xc92c,	0x957f, 0xc92c,		0x21, 0
	.dw 0x95c0, 0xc92c,	0x95ff, 0xc92c,		0x21, 0
	.dw 0x9640, 0xc92c,	0x967f, 0xc92c,		0x21, 0
	.dw 0x96c0, 0xc92c,	0x96ff, 0xc92c,		0x21, 0
	.dw 0x9740, 0xc92c,	0x977f, 0xc92c,		0x21, 0
	.dw 0x97c0, 0xc92c,	0x97ff, 0xc92c,		0x21, 0
	.dw 0x9840, 0xc92c,	0x987f, 0xc92c,		0x21, 0
	.dw 0x98c0, 0xc92c,	0x98ff, 0xc92c,		0x21, 0
	.dw 0x9940, 0xc92c,	0x997f, 0xc92c,		0x21, 0
	.dw 0x99c0, 0xc92c,	0x9fff, 0xc92c,		0x21, 0
	.dw 0xa040, 0xc92c,	0xa07f, 0xc92c,		0x21, 0
	.dw 0xa0c0, 0xc92c,	0xa0ff, 0xc92c,		0x21, 0
	.dw 0xa140, 0xc92c,	0xa17f, 0xc92c,		0x21, 0
	.dw 0xa1c0, 0xc92c,	0xa1ff, 0xc92c,		0x21, 0
	.dw 0xa240, 0xc92c,	0xa27f, 0xc92c,		0x21, 0
	.dw 0xa2c0, 0xc92c,	0xa2ff, 0xc92c,		0x21, 0
	.dw 0xa340, 0xc92c,	0xa37f, 0xc92c,		0x21, 0
	.dw 0xa3c0, 0xc92c,	0xa3ff, 0xc92c,		0x21, 0
	.dw 0xa440, 0xc92c,	0xa47f, 0xc92c,		0x21, 0
	.dw 0xa4c0, 0xc92c,	0xa4ff, 0xc92c,		0x21, 0
	.dw 0xa540, 0xc92c,	0xa57f, 0xc92c,		0x21, 0
	.dw 0xa5c0, 0xc92c,	0xa5ff, 0xc92c,		0x21, 0
	.dw 0xa640, 0xc92c,	0xa67f, 0xc92c,		0x21, 0
	.dw 0xa6c0, 0xc92c,	0xa6ff, 0xc92c,		0x21, 0
	.dw 0xa740, 0xc92c,	0xa77f, 0xc92c,		0x21, 0
	.dw 0xa7c0, 0xc92c,	0xa7ff, 0xc92c,		0x21, 0
	.dw 0xa840, 0xc92c,	0xa87f, 0xc92c,		0x21, 0
	.dw 0xa8c0, 0xc92c,	0xa8ff, 0xc92c,		0x21, 0
	.dw 0xa940, 0xc92c,	0xa97f, 0xc92c,		0x21, 0
	.dw 0xa9c0, 0xc92c,	0xa9ff, 0xc92c,		0x21, 0
	.dw 0xaa40, 0xc92c,	0xaa7f, 0xc92c,		0x21, 0
	.dw 0xaac0, 0xc92c,	0xaaff, 0xc92c,		0x21, 0
	.dw 0xab40, 0xc92c,	0xab7f, 0xc92c,		0x21, 0
	.dw 0xabc0, 0xc92c,	0xabff, 0xc92c,		0x21, 0
	.dw 0xac40, 0xc92c,	0xac7f, 0xc92c,		0x21, 0
	.dw 0xacc0, 0xc92c,	0xacff, 0xc92c,		0x21, 0
	.dw 0xad40, 0xc92c,	0xad7f, 0xc92c,		0x21, 0
	.dw 0xadc0, 0xc92c,	0xadff, 0xc92c,		0x21, 0
	.dw 0xae40, 0xc92c,	0xae7f, 0xc92c,		0x21, 0
	.dw 0xaec0, 0xc92c,	0xaeff, 0xc92c,		0x21, 0
	.dw 0xaf40, 0xc92c,	0xaf7f, 0xc92c,		0x21, 0
	.dw 0xafc0, 0xc92c,	0xafff, 0xc92c,		0x21, 0
	.dw 0xb040, 0xc92c,	0xb07f, 0xc92c,		0x21, 0
	.dw 0xb0c0, 0xc92c,	0xb0ff, 0xc92c,		0x21, 0
	.dw 0xb140, 0xc92c,	0xb17f, 0xc92c,		0x21, 0
	.dw 0xb1c0, 0xc92c,	0xb1ff, 0xc92c,		0x21, 0
	.dw 0xb240, 0xc92c,	0xb27f, 0xc92c,		0x21, 0
	.dw 0xb2c0, 0xc92c,	0xb2ff, 0xc92c,		0x21, 0
	.dw 0xb340, 0xc92c,	0xb37f, 0xc92c,		0x21, 0
	.dw 0xb3c0, 0xc92c,	0xb3ff, 0xc92c,		0x21, 0
	.dw 0xb440, 0xc92c,	0xb47f, 0xc92c,		0x21, 0
	.dw 0xb4c0, 0xc92c,	0xb4ff, 0xc92c,		0x21, 0
	.dw 0xb540, 0xc92c,	0xb57f, 0xc92c,		0x21, 0
	.dw 0xb5c0, 0xc92c,	0xb5ff, 0xc92c,		0x21, 0
	.dw 0xb640, 0xc92c,	0xb67f, 0xc92c,		0x21, 0
	.dw 0xb6c0, 0xc92c,	0xb6ff, 0xc92c,		0x21, 0
	.dw 0xb740, 0xc92c,	0xb77f, 0xc92c,		0x21, 0
	.dw 0xb7c0, 0xc92c,	0xb7ff, 0xc92c,		0x21, 0
	.dw 0xb840, 0xc92c,	0xb87f, 0xc92c,		0x21, 0
	.dw 0xb8c0, 0xc92c,	0xb8ff, 0xc92c,		0x21, 0
	.dw 0xb940, 0xc92c,	0xb97f, 0xc92c,		0x21, 0
	.dw 0xb9c0, 0xc92c,	0xbfff, 0xc92c,		0x21, 0
	.dw 0xc040, 0xc92c,	0xc07f, 0xc92c,		0x21, 0
	.dw 0xc0c0, 0xc92c,	0xc0ff, 0xc92c,		0x21, 0
	.dw 0xc140, 0xc92c,	0xc17f, 0xc92c,		0x21, 0
	.dw 0xc1c0, 0xc92c,	0xc1ff, 0xc92c,		0x21, 0
	.dw 0xc240, 0xc92c,	0xc27f, 0xc92c,		0x21, 0
	.dw 0xc2c0, 0xc92c,	0xc2ff, 0xc92c,		0x21, 0
	.dw 0xc340, 0xc92c,	0xc37f, 0xc92c,		0x21, 0
	.dw 0xc3c0, 0xc92c,	0xc3ff, 0xc92c,		0x21, 0
	.dw 0xc440, 0xc92c,	0xc47f, 0xc92c,		0x21, 0
	.dw 0xc4c0, 0xc92c,	0xc4ff, 0xc92c,		0x21, 0
	.dw 0xc540, 0xc92c,	0xc57f, 0xc92c,		0x21, 0
	.dw 0xc5c0, 0xc92c,	0xc5ff, 0xc92c,		0x21, 0
	.dw 0xc640, 0xc92c,	0xc67f, 0xc92c,		0x21, 0
	.dw 0xc6c0, 0xc92c,	0xc6ff, 0xc92c,		0x21, 0
	.dw 0xc740, 0xc92c,	0xc77f, 0xc92c,		0x21, 0
	.dw 0xc7c0, 0xc92c,	0xc7ff, 0xc92c,		0x21, 0
	.dw 0xc840, 0xc92c,	0xc87f, 0xc92c,		0x21, 0
	.dw 0xc8c0, 0xc92c,	0xc8ff, 0xc92c,		0x21, 0
	.dw 0xc940, 0xc92c,	0xc97f, 0xc92c,		0x21, 0
	.dw 0xc9c0, 0xc92c,	0xc9ff, 0xc92c,		0x21, 0
	.dw 0xca40, 0xc92c,	0xca7f, 0xc92c,		0x21, 0
	.dw 0xcac0, 0xc92c,	0xcaff, 0xc92c,		0x21, 0
	.dw 0xcb40, 0xc92c,	0xcb7f, 0xc92c,		0x21, 0
	.dw 0xcbc0, 0xc92c,	0xcbff, 0xc92c,		0x21, 0
	.dw 0xcc40, 0xc92c,	0xcc7f, 0xc92c,		0x21, 0
	.dw 0xccc0, 0xc92c,	0xccff, 0xc92c,		0x21, 0
	.dw 0xcd40, 0xc92c,	0xcd7f, 0xc92c,		0x21, 0
	.dw 0xcdc0, 0xc92c,	0xcdff, 0xc92c,		0x21, 0
	.dw 0xce40, 0xc92c,	0xce7f, 0xc92c,		0x21, 0
	.dw 0xcec0, 0xc92c,	0xceff, 0xc92c,		0x21, 0
	.dw 0xcf40, 0xc92c,	0xcf7f, 0xc92c,		0x21, 0
	.dw 0xcfc0, 0xc92c,	0xcfff, 0xc92c,		0x21, 0
	.dw 0xd040, 0xc92c,	0xd07f, 0xc92c,		0x21, 0
	.dw 0xd0c0, 0xc92c,	0xd0ff, 0xc92c,		0x21, 0
	.dw 0xd140, 0xc92c,	0xd17f, 0xc92c,		0x21, 0
	.dw 0xd1c0, 0xc92c,	0xd1ff, 0xc92c,		0x21, 0
	.dw 0xd240, 0xc92c,	0xd27f, 0xc92c,		0x21, 0
	.dw 0xd2c0, 0xc92c,	0xd2ff, 0xc92c,		0x21, 0
	.dw 0xd340, 0xc92c,	0xd37f, 0xc92c,		0x21, 0
	.dw 0xd3c0, 0xc92c,	0xd3ff, 0xc92c,		0x21, 0
	.dw 0xd440, 0xc92c,	0xd47f, 0xc92c,		0x21, 0
	.dw 0xd4c0, 0xc92c,	0xd4ff, 0xc92c,		0x21, 0
	.dw 0xd540, 0xc92c,	0xd57f, 0xc92c,		0x21, 0
	.dw 0xd5c0, 0xc92c,	0xd5ff, 0xc92c,		0x21, 0
	.dw 0xd640, 0xc92c,	0xd67f, 0xc92c,		0x21, 0
	.dw 0xd6c0, 0xc92c,	0xd6ff, 0xc92c,		0x21, 0
	.dw 0xd740, 0xc92c,	0xd77f, 0xc92c,		0x21, 0
	.dw 0xd7c0, 0xc92c,	0xd7ff, 0xc92c,		0x21, 0
	.dw 0xd840, 0xc92c,	0xd87f, 0xc92c,		0x21, 0
	.dw 0xd8c0, 0xc92c,	0xd8ff, 0xc92c,		0x21, 0
	.dw 0xd940, 0xc92c,	0xd97f, 0xc92c,		0x21, 0
	.dw 0xd9c0, 0xc92c,	0xdfff, 0xc92c,		0x21, 0
	.dw 0xe040, 0xc92c,	0xe07f, 0xc92c,		0x21, 0
	.dw 0xe0c0, 0xc92c,	0xe0ff, 0xc92c,		0x21, 0
	.dw 0xe140, 0xc92c,	0xe17f, 0xc92c,		0x21, 0
	.dw 0xe1c0, 0xc92c,	0xe1ff, 0xc92c,		0x21, 0
	.dw 0xe240, 0xc92c,	0xe27f, 0xc92c,		0x21, 0
	.dw 0xe2c0, 0xc92c,	0xe2ff, 0xc92c,		0x21, 0
	.dw 0xe340, 0xc92c,	0xe37f, 0xc92c,		0x21, 0
	.dw 0xe3c0, 0xc92c,	0xe3ff, 0xc92c,		0x21, 0
	.dw 0xe440, 0xc92c,	0xe47f, 0xc92c,		0x21, 0
	.dw 0xe4c0, 0xc92c,	0xe4ff, 0xc92c,		0x21, 0
	.dw 0xe540, 0xc92c,	0xe57f, 0xc92c,		0x21, 0
	.dw 0xe5c0, 0xc92c,	0xe5ff, 0xc92c,		0x21, 0
	.dw 0xe640, 0xc92c,	0xe67f, 0xc92c,		0x21, 0
	.dw 0xe6c0, 0xc92c,	0xe6ff, 0xc92c,		0x21, 0
	.dw 0xe740, 0xc92c,	0xe77f, 0xc92c,		0x21, 0
	.dw 0xe7c0, 0xc92c,	0xe7ff, 0xc92c,		0x21, 0
	.dw 0xe840, 0xc92c,	0xe87f, 0xc92c,		0x21, 0
	.dw 0xe8c0, 0xc92c,	0xe8ff, 0xc92c,		0x21, 0
	.dw 0xe940, 0xc92c,	0xe97f, 0xc92c,		0x21, 0
	.dw 0xe9c0, 0xc92c,	0xe9ff, 0xc92c,		0x21, 0
	.dw 0xea40, 0xc92c,	0xea7f, 0xc92c,		0x21, 0
	.dw 0xeac0, 0xc92c,	0xeaff, 0xc92c,		0x21, 0
	.dw 0xeb40, 0xc92c,	0xeb7f, 0xc92c,		0x21, 0
	.dw 0xebc0, 0xc92c,	0xebff, 0xc92c,		0x21, 0
	.dw 0xec40, 0xc92c,	0xec7f, 0xc92c,		0x21, 0
	.dw 0xecc0, 0xc92c,	0xecff, 0xc92c,		0x21, 0
	.dw 0xed40, 0xc92c,	0xed7f, 0xc92c,		0x21, 0
	.dw 0xedc0, 0xc92c,	0xedff, 0xc92c,		0x21, 0
	.dw 0xee40, 0xc92c,	0xee7f, 0xc92c,		0x21, 0
	.dw 0xeec0, 0xc92c,	0xeeff, 0xc92c,		0x21, 0
	.dw 0xef40, 0xc92c,	0xef7f, 0xc92c,		0x21, 0
	.dw 0xefc0, 0xc92c,	0xefff, 0xc92c,		0x21, 0
	.dw 0xf040, 0xc92c,	0xf07f, 0xc92c,		0x21, 0
	.dw 0xf0c0, 0xc92c,	0xf0ff, 0xc92c,		0x21, 0
	.dw 0xf140, 0xc92c,	0xf17f, 0xc92c,		0x21, 0
	.dw 0xf1c0, 0xc92c,	0xf1ff, 0xc92c,		0x21, 0
	.dw 0xf240, 0xc92c,	0xf27f, 0xc92c,		0x21, 0
	.dw 0xf2c0, 0xc92c,	0xf2ff, 0xc92c,		0x21, 0
	.dw 0xf340, 0xc92c,	0xf37f, 0xc92c,		0x21, 0
	.dw 0xf3c0, 0xc92c,	0xf3ff, 0xc92c,		0x21, 0
	.dw 0xf440, 0xc92c,	0xf47f, 0xc92c,		0x21, 0
	.dw 0xf4c0, 0xc92c,	0xf4ff, 0xc92c,		0x21, 0
	.dw 0xf540, 0xc92c,	0xf57f, 0xc92c,		0x21, 0
	.dw 0xf5c0, 0xc92c,	0xf5ff, 0xc92c,		0x21, 0
	.dw 0xf640, 0xc92c,	0xf67f, 0xc92c,		0x21, 0
	.dw 0xf6c0, 0xc92c,	0xf6ff, 0xc92c,		0x21, 0
	.dw 0xf740, 0xc92c,	0xf77f, 0xc92c,		0x21, 0
	.dw 0xf7c0, 0xc92c,	0xf7ff, 0xc92c,		0x21, 0
	.dw 0xf840, 0xc92c,	0xf87f, 0xc92c,		0x21, 0
	.dw 0xf8c0, 0xc92c,	0xf8ff, 0xc92c,		0x21, 0
	.dw 0xf940, 0xc92c,	0xf97f, 0xc92c,		0x21, 0
	.dw 0xf9c0, 0xc92c,	0xffff, 0xc92c,		0x21, 0
	.dw 0x0040, 0xc92d,	0x007f, 0xc92d,		0x21, 0
	.dw 0x00c0, 0xc92d,	0x00ff, 0xc92d,		0x21, 0
	.dw 0x0140, 0xc92d,	0x017f, 0xc92d,		0x21, 0
	.dw 0x01c0, 0xc92d,	0x01ff, 0xc92d,		0x21, 0
	.dw 0x0240, 0xc92d,	0x027f, 0xc92d,		0x21, 0
	.dw 0x02c0, 0xc92d,	0x02ff, 0xc92d,		0x21, 0
	.dw 0x0340, 0xc92d,	0x037f, 0xc92d,		0x21, 0
	.dw 0x03c0, 0xc92d,	0x03ff, 0xc92d,		0x21, 0
	.dw 0x0440, 0xc92d,	0x047f, 0xc92d,		0x21, 0
	.dw 0x04c0, 0xc92d,	0x04ff, 0xc92d,		0x21, 0
	.dw 0x0540, 0xc92d,	0x057f, 0xc92d,		0x21, 0
	.dw 0x05c0, 0xc92d,	0x05ff, 0xc92d,		0x21, 0
	.dw 0x0640, 0xc92d,	0x067f, 0xc92d,		0x21, 0
	.dw 0x06c0, 0xc92d,	0x06ff, 0xc92d,		0x21, 0
	.dw 0x0740, 0xc92d,	0x077f, 0xc92d,		0x21, 0
	.dw 0x07c0, 0xc92d,	0x07ff, 0xc92d,		0x21, 0
	.dw 0x0840, 0xc92d,	0x087f, 0xc92d,		0x21, 0
	.dw 0x08c0, 0xc92d,	0x08ff, 0xc92d,		0x21, 0
	.dw 0x0940, 0xc92d,	0x097f, 0xc92d,		0x21, 0
	.dw 0x09c0, 0xc92d,	0x09ff, 0xc92d,		0x21, 0
	.dw 0x0a40, 0xc92d,	0x0a7f, 0xc92d,		0x21, 0
	.dw 0x0ac0, 0xc92d,	0x0aff, 0xc92d,		0x21, 0
	.dw 0x0b40, 0xc92d,	0x0b7f, 0xc92d,		0x21, 0
	.dw 0x0bc0, 0xc92d,	0x0bff, 0xc92d,		0x21, 0
	.dw 0x0c40, 0xc92d,	0x0c7f, 0xc92d,		0x21, 0
	.dw 0x0cc0, 0xc92d,	0x0cff, 0xc92d,		0x21, 0
	.dw 0x0d40, 0xc92d,	0x0d7f, 0xc92d,		0x21, 0
	.dw 0x0dc0, 0xc92d,	0x0dff, 0xc92d,		0x21, 0
	.dw 0x0e40, 0xc92d,	0x0e7f, 0xc92d,		0x21, 0
	.dw 0x0ec0, 0xc92d,	0x0eff, 0xc92d,		0x21, 0
	.dw 0x0f40, 0xc92d,	0x0f7f, 0xc92d,		0x21, 0
	.dw 0x0fc0, 0xc92d,	0x0fff, 0xc92d,		0x21, 0
	.dw 0x1040, 0xc92d,	0x107f, 0xc92d,		0x21, 0
	.dw 0x10c0, 0xc92d,	0x10ff, 0xc92d,		0x21, 0
	.dw 0x1140, 0xc92d,	0x117f, 0xc92d,		0x21, 0
	.dw 0x11c0, 0xc92d,	0x11ff, 0xc92d,		0x21, 0
	.dw 0x1240, 0xc92d,	0x127f, 0xc92d,		0x21, 0
	.dw 0x12c0, 0xc92d,	0x12ff, 0xc92d,		0x21, 0
	.dw 0x1340, 0xc92d,	0x137f, 0xc92d,		0x21, 0
	.dw 0x13c0, 0xc92d,	0x13ff, 0xc92d,		0x21, 0
	.dw 0x1440, 0xc92d,	0x147f, 0xc92d,		0x21, 0
	.dw 0x14c0, 0xc92d,	0x14ff, 0xc92d,		0x21, 0
	.dw 0x1540, 0xc92d,	0x157f, 0xc92d,		0x21, 0
	.dw 0x15c0, 0xc92d,	0x15ff, 0xc92d,		0x21, 0
	.dw 0x1640, 0xc92d,	0x167f, 0xc92d,		0x21, 0
	.dw 0x16c0, 0xc92d,	0x16ff, 0xc92d,		0x21, 0
	.dw 0x1740, 0xc92d,	0x177f, 0xc92d,		0x21, 0
	.dw 0x17c0, 0xc92d,	0x17ff, 0xc92d,		0x21, 0
	.dw 0x1840, 0xc92d,	0x187f, 0xc92d,		0x21, 0
	.dw 0x18c0, 0xc92d,	0x18ff, 0xc92d,		0x21, 0
	.dw 0x1940, 0xc92d,	0x197f, 0xc92d,		0x21, 0
	.dw 0x19c0, 0xc92d,	0x1fff, 0xc92d,		0x21, 0
	.dw 0x2040, 0xc92d,	0x207f, 0xc92d,		0x21, 0
	.dw 0x20c0, 0xc92d,	0x20ff, 0xc92d,		0x21, 0
	.dw 0x2140, 0xc92d,	0x217f, 0xc92d,		0x21, 0
	.dw 0x21c0, 0xc92d,	0x21ff, 0xc92d,		0x21, 0
	.dw 0x2240, 0xc92d,	0x227f, 0xc92d,		0x21, 0
	.dw 0x22c0, 0xc92d,	0x22ff, 0xc92d,		0x21, 0
	.dw 0x2340, 0xc92d,	0x237f, 0xc92d,		0x21, 0
	.dw 0x23c0, 0xc92d,	0x23ff, 0xc92d,		0x21, 0
	.dw 0x2440, 0xc92d,	0x247f, 0xc92d,		0x21, 0
	.dw 0x24c0, 0xc92d,	0x24ff, 0xc92d,		0x21, 0
	.dw 0x2540, 0xc92d,	0x257f, 0xc92d,		0x21, 0
	.dw 0x25c0, 0xc92d,	0x25ff, 0xc92d,		0x21, 0
	.dw 0x2640, 0xc92d,	0x267f, 0xc92d,		0x21, 0
	.dw 0x26c0, 0xc92d,	0x26ff, 0xc92d,		0x21, 0
	.dw 0x2740, 0xc92d,	0x277f, 0xc92d,		0x21, 0
	.dw 0x27c0, 0xc92d,	0x27ff, 0xc92d,		0x21, 0
	.dw 0x2840, 0xc92d,	0x287f, 0xc92d,		0x21, 0
	.dw 0x28c0, 0xc92d,	0x28ff, 0xc92d,		0x21, 0
	.dw 0x2940, 0xc92d,	0x297f, 0xc92d,		0x21, 0
	.dw 0x29c0, 0xc92d,	0x29ff, 0xc92d,		0x21, 0
	.dw 0x2a40, 0xc92d,	0x2a7f, 0xc92d,		0x21, 0
	.dw 0x2ac0, 0xc92d,	0x2aff, 0xc92d,		0x21, 0
	.dw 0x2b40, 0xc92d,	0x2b7f, 0xc92d,		0x21, 0
	.dw 0x2bc0, 0xc92d,	0x2bff, 0xc92d,		0x21, 0
	.dw 0x2c40, 0xc92d,	0x2c7f, 0xc92d,		0x21, 0
	.dw 0x2cc0, 0xc92d,	0x2cff, 0xc92d,		0x21, 0
	.dw 0x2d40, 0xc92d,	0x2d7f, 0xc92d,		0x21, 0
	.dw 0x2dc0, 0xc92d,	0x2dff, 0xc92d,		0x21, 0
	.dw 0x2e40, 0xc92d,	0x2e7f, 0xc92d,		0x21, 0
	.dw 0x2ec0, 0xc92d,	0x2eff, 0xc92d,		0x21, 0
	.dw 0x2f40, 0xc92d,	0x2f7f, 0xc92d,		0x21, 0
	.dw 0x2fc0, 0xc92d,	0x2fff, 0xc92d,		0x21, 0
	.dw 0x3040, 0xc92d,	0x307f, 0xc92d,		0x21, 0
	.dw 0x30c0, 0xc92d,	0x30ff, 0xc92d,		0x21, 0
	.dw 0x3140, 0xc92d,	0x317f, 0xc92d,		0x21, 0
	.dw 0x31c0, 0xc92d,	0x31ff, 0xc92d,		0x21, 0
	.dw 0x3240, 0xc92d,	0x327f, 0xc92d,		0x21, 0
	.dw 0x32c0, 0xc92d,	0x32ff, 0xc92d,		0x21, 0
	.dw 0x3340, 0xc92d,	0x337f, 0xc92d,		0x21, 0
	.dw 0x33c0, 0xc92d,	0x33ff, 0xc92d,		0x21, 0
	.dw 0x3440, 0xc92d,	0x347f, 0xc92d,		0x21, 0
	.dw 0x34c0, 0xc92d,	0x34ff, 0xc92d,		0x21, 0
	.dw 0x3540, 0xc92d,	0x357f, 0xc92d,		0x21, 0
	.dw 0x35c0, 0xc92d,	0x35ff, 0xc92d,		0x21, 0
	.dw 0x3640, 0xc92d,	0x367f, 0xc92d,		0x21, 0
	.dw 0x36c0, 0xc92d,	0x36ff, 0xc92d,		0x21, 0
	.dw 0x3740, 0xc92d,	0x377f, 0xc92d,		0x21, 0
	.dw 0x37c0, 0xc92d,	0x37ff, 0xc92d,		0x21, 0
	.dw 0x3840, 0xc92d,	0x387f, 0xc92d,		0x21, 0
	.dw 0x38c0, 0xc92d,	0x38ff, 0xc92d,		0x21, 0
	.dw 0x3940, 0xc92d,	0x397f, 0xc92d,		0x21, 0
	.dw 0x39c0, 0xc92d,	0x3fff, 0xc92d,		0x21, 0
	.dw 0x4040, 0xc92d,	0x407f, 0xc92d,		0x21, 0
	.dw 0x40c0, 0xc92d,	0x40ff, 0xc92d,		0x21, 0
	.dw 0x4140, 0xc92d,	0x417f, 0xc92d,		0x21, 0
	.dw 0x41c0, 0xc92d,	0x41ff, 0xc92d,		0x21, 0
	.dw 0x4240, 0xc92d,	0x427f, 0xc92d,		0x21, 0
	.dw 0x42c0, 0xc92d,	0x42ff, 0xc92d,		0x21, 0
	.dw 0x4340, 0xc92d,	0x437f, 0xc92d,		0x21, 0
	.dw 0x43c0, 0xc92d,	0x43ff, 0xc92d,		0x21, 0
	.dw 0x4440, 0xc92d,	0x447f, 0xc92d,		0x21, 0
	.dw 0x44c0, 0xc92d,	0x44ff, 0xc92d,		0x21, 0
	.dw 0x4540, 0xc92d,	0x457f, 0xc92d,		0x21, 0
	.dw 0x45c0, 0xc92d,	0x45ff, 0xc92d,		0x21, 0
	.dw 0x4640, 0xc92d,	0x467f, 0xc92d,		0x21, 0
	.dw 0x46c0, 0xc92d,	0x46ff, 0xc92d,		0x21, 0
	.dw 0x4740, 0xc92d,	0x477f, 0xc92d,		0x21, 0
	.dw 0x47c0, 0xc92d,	0x47ff, 0xc92d,		0x21, 0
	.dw 0x4840, 0xc92d,	0x487f, 0xc92d,		0x21, 0
	.dw 0x48c0, 0xc92d,	0x48ff, 0xc92d,		0x21, 0
	.dw 0x4940, 0xc92d,	0x497f, 0xc92d,		0x21, 0
	.dw 0x49c0, 0xc92d,	0x49ff, 0xc92d,		0x21, 0
	.dw 0x4a40, 0xc92d,	0x4a7f, 0xc92d,		0x21, 0
	.dw 0x4ac0, 0xc92d,	0x4aff, 0xc92d,		0x21, 0
	.dw 0x4b40, 0xc92d,	0x4b7f, 0xc92d,		0x21, 0
	.dw 0x4bc0, 0xc92d,	0x4bff, 0xc92d,		0x21, 0
	.dw 0x4c40, 0xc92d,	0x4c7f, 0xc92d,		0x21, 0
	.dw 0x4cc0, 0xc92d,	0x4cff, 0xc92d,		0x21, 0
	.dw 0x4d40, 0xc92d,	0x4d7f, 0xc92d,		0x21, 0
	.dw 0x4dc0, 0xc92d,	0x4dff, 0xc92d,		0x21, 0
	.dw 0x4e40, 0xc92d,	0x4e7f, 0xc92d,		0x21, 0
	.dw 0x4ec0, 0xc92d,	0x4eff, 0xc92d,		0x21, 0
	.dw 0x4f40, 0xc92d,	0x4f7f, 0xc92d,		0x21, 0
	.dw 0x4fc0, 0xc92d,	0x4fff, 0xc92d,		0x21, 0
	.dw 0x5040, 0xc92d,	0x507f, 0xc92d,		0x21, 0
	.dw 0x50c0, 0xc92d,	0x50ff, 0xc92d,		0x21, 0
	.dw 0x5140, 0xc92d,	0x517f, 0xc92d,		0x21, 0
	.dw 0x51c0, 0xc92d,	0x51ff, 0xc92d,		0x21, 0
	.dw 0x5240, 0xc92d,	0x527f, 0xc92d,		0x21, 0
	.dw 0x52c0, 0xc92d,	0x52ff, 0xc92d,		0x21, 0
	.dw 0x5340, 0xc92d,	0x537f, 0xc92d,		0x21, 0
	.dw 0x53c0, 0xc92d,	0x53ff, 0xc92d,		0x21, 0
	.dw 0x5440, 0xc92d,	0x547f, 0xc92d,		0x21, 0
	.dw 0x54c0, 0xc92d,	0x54ff, 0xc92d,		0x21, 0
	.dw 0x5540, 0xc92d,	0x557f, 0xc92d,		0x21, 0
	.dw 0x55c0, 0xc92d,	0x55ff, 0xc92d,		0x21, 0
	.dw 0x5640, 0xc92d,	0x567f, 0xc92d,		0x21, 0
	.dw 0x56c0, 0xc92d,	0x56ff, 0xc92d,		0x21, 0
	.dw 0x5740, 0xc92d,	0x577f, 0xc92d,		0x21, 0
	.dw 0x57c0, 0xc92d,	0x57ff, 0xc92d,		0x21, 0
	.dw 0x5840, 0xc92d,	0x587f, 0xc92d,		0x21, 0
	.dw 0x58c0, 0xc92d,	0x58ff, 0xc92d,		0x21, 0
	.dw 0x5940, 0xc92d,	0x597f, 0xc92d,		0x21, 0
	.dw 0x59c0, 0xc92d,	0x5fff, 0xc92d,		0x21, 0
	.dw 0x6040, 0xc92d,	0x607f, 0xc92d,		0x21, 0
	.dw 0x60c0, 0xc92d,	0x60ff, 0xc92d,		0x21, 0
	.dw 0x6140, 0xc92d,	0x617f, 0xc92d,		0x21, 0
	.dw 0x61c0, 0xc92d,	0x61ff, 0xc92d,		0x21, 0
	.dw 0x6240, 0xc92d,	0x627f, 0xc92d,		0x21, 0
	.dw 0x62c0, 0xc92d,	0x62ff, 0xc92d,		0x21, 0
	.dw 0x6340, 0xc92d,	0x637f, 0xc92d,		0x21, 0
	.dw 0x63c0, 0xc92d,	0x63ff, 0xc92d,		0x21, 0
	.dw 0x6440, 0xc92d,	0x647f, 0xc92d,		0x21, 0
	.dw 0x64c0, 0xc92d,	0x64ff, 0xc92d,		0x21, 0
	.dw 0x6540, 0xc92d,	0x657f, 0xc92d,		0x21, 0
	.dw 0x65c0, 0xc92d,	0x65ff, 0xc92d,		0x21, 0
	.dw 0x6640, 0xc92d,	0x667f, 0xc92d,		0x21, 0
	.dw 0x66c0, 0xc92d,	0x66ff, 0xc92d,		0x21, 0
	.dw 0x6740, 0xc92d,	0x677f, 0xc92d,		0x21, 0
	.dw 0x67c0, 0xc92d,	0x67ff, 0xc92d,		0x21, 0
	.dw 0x6840, 0xc92d,	0x687f, 0xc92d,		0x21, 0
	.dw 0x68c0, 0xc92d,	0x68ff, 0xc92d,		0x21, 0
	.dw 0x6940, 0xc92d,	0x697f, 0xc92d,		0x21, 0
	.dw 0x69c0, 0xc92d,	0x69ff, 0xc92d,		0x21, 0
	.dw 0x6a40, 0xc92d,	0x6a7f, 0xc92d,		0x21, 0
	.dw 0x6ac0, 0xc92d,	0x6aff, 0xc92d,		0x21, 0
	.dw 0x6b40, 0xc92d,	0x6b7f, 0xc92d,		0x21, 0
	.dw 0x6bc0, 0xc92d,	0x6bff, 0xc92d,		0x21, 0
	.dw 0x6c40, 0xc92d,	0x6c7f, 0xc92d,		0x21, 0
	.dw 0x6cc0, 0xc92d,	0x6cff, 0xc92d,		0x21, 0
	.dw 0x6d40, 0xc92d,	0x6d7f, 0xc92d,		0x21, 0
	.dw 0x6dc0, 0xc92d,	0x6dff, 0xc92d,		0x21, 0
	.dw 0x6e40, 0xc92d,	0x6e7f, 0xc92d,		0x21, 0
	.dw 0x6ec0, 0xc92d,	0x6eff, 0xc92d,		0x21, 0
	.dw 0x6f40, 0xc92d,	0x6f7f, 0xc92d,		0x21, 0
	.dw 0x6fc0, 0xc92d,	0x6fff, 0xc92d,		0x21, 0
	.dw 0x7040, 0xc92d,	0x707f, 0xc92d,		0x21, 0
	.dw 0x70c0, 0xc92d,	0x70ff, 0xc92d,		0x21, 0
	.dw 0x7140, 0xc92d,	0x717f, 0xc92d,		0x21, 0
	.dw 0x71c0, 0xc92d,	0x71ff, 0xc92d,		0x21, 0
	.dw 0x7240, 0xc92d,	0x727f, 0xc92d,		0x21, 0
	.dw 0x72c0, 0xc92d,	0x72ff, 0xc92d,		0x21, 0
	.dw 0x7340, 0xc92d,	0x737f, 0xc92d,		0x21, 0
	.dw 0x73c0, 0xc92d,	0x73ff, 0xc92d,		0x21, 0
	.dw 0x7440, 0xc92d,	0x747f, 0xc92d,		0x21, 0
	.dw 0x74c0, 0xc92d,	0x74ff, 0xc92d,		0x21, 0
	.dw 0x7540, 0xc92d,	0x757f, 0xc92d,		0x21, 0
	.dw 0x75c0, 0xc92d,	0x75ff, 0xc92d,		0x21, 0
	.dw 0x7640, 0xc92d,	0x767f, 0xc92d,		0x21, 0
	.dw 0x76c0, 0xc92d,	0x76ff, 0xc92d,		0x21, 0
	.dw 0x7740, 0xc92d,	0x777f, 0xc92d,		0x21, 0
	.dw 0x77c0, 0xc92d,	0x77ff, 0xc92d,		0x21, 0
	.dw 0x7840, 0xc92d,	0x787f, 0xc92d,		0x21, 0
	.dw 0x78c0, 0xc92d,	0x78ff, 0xc92d,		0x21, 0
	.dw 0x7940, 0xc92d,	0x797f, 0xc92d,		0x21, 0
	.dw 0x79c0, 0xc92d,	0x7fff, 0xc92d,		0x21, 0
	.dw 0x8040, 0xc92d,	0x807f, 0xc92d,		0x21, 0
	.dw 0x80c0, 0xc92d,	0x80ff, 0xc92d,		0x21, 0
	.dw 0x8140, 0xc92d,	0x817f, 0xc92d,		0x21, 0
	.dw 0x81c0, 0xc92d,	0x81ff, 0xc92d,		0x21, 0
	.dw 0x8240, 0xc92d,	0x827f, 0xc92d,		0x21, 0
	.dw 0x82c0, 0xc92d,	0x82ff, 0xc92d,		0x21, 0
	.dw 0x8340, 0xc92d,	0x837f, 0xc92d,		0x21, 0
	.dw 0x83c0, 0xc92d,	0x83ff, 0xc92d,		0x21, 0
	.dw 0x8440, 0xc92d,	0x847f, 0xc92d,		0x21, 0
	.dw 0x84c0, 0xc92d,	0x84ff, 0xc92d,		0x21, 0
	.dw 0x8540, 0xc92d,	0x857f, 0xc92d,		0x21, 0
	.dw 0x85c0, 0xc92d,	0x85ff, 0xc92d,		0x21, 0
	.dw 0x8640, 0xc92d,	0x867f, 0xc92d,		0x21, 0
	.dw 0x86c0, 0xc92d,	0x86ff, 0xc92d,		0x21, 0
	.dw 0x8740, 0xc92d,	0x877f, 0xc92d,		0x21, 0
	.dw 0x87c0, 0xc92d,	0x87ff, 0xc92d,		0x21, 0
	.dw 0x8840, 0xc92d,	0x887f, 0xc92d,		0x21, 0
	.dw 0x88c0, 0xc92d,	0x88ff, 0xc92d,		0x21, 0
	.dw 0x8940, 0xc92d,	0x897f, 0xc92d,		0x21, 0
	.dw 0x89c0, 0xc92d,	0x89ff, 0xc92d,		0x21, 0
	.dw 0x8a40, 0xc92d,	0x8a7f, 0xc92d,		0x21, 0
	.dw 0x8ac0, 0xc92d,	0x8aff, 0xc92d,		0x21, 0
	.dw 0x8b40, 0xc92d,	0x8b7f, 0xc92d,		0x21, 0
	.dw 0x8bc0, 0xc92d,	0x8bff, 0xc92d,		0x21, 0
	.dw 0x8c40, 0xc92d,	0x8c7f, 0xc92d,		0x21, 0
	.dw 0x8cc0, 0xc92d,	0x8cff, 0xc92d,		0x21, 0
	.dw 0x8d40, 0xc92d,	0x8d7f, 0xc92d,		0x21, 0
	.dw 0x8dc0, 0xc92d,	0x8dff, 0xc92d,		0x21, 0
	.dw 0x8e40, 0xc92d,	0x8e7f, 0xc92d,		0x21, 0
	.dw 0x8ec0, 0xc92d,	0x8eff, 0xc92d,		0x21, 0
	.dw 0x8f40, 0xc92d,	0x8f7f, 0xc92d,		0x21, 0
	.dw 0x8fc0, 0xc92d,	0x8fff, 0xc92d,		0x21, 0
	.dw 0x9040, 0xc92d,	0x907f, 0xc92d,		0x21, 0
	.dw 0x90c0, 0xc92d,	0x90ff, 0xc92d,		0x21, 0
	.dw 0x9140, 0xc92d,	0x917f, 0xc92d,		0x21, 0
	.dw 0x91c0, 0xc92d,	0x91ff, 0xc92d,		0x21, 0
	.dw 0x9240, 0xc92d,	0x927f, 0xc92d,		0x21, 0
	.dw 0x92c0, 0xc92d,	0x92ff, 0xc92d,		0x21, 0
	.dw 0x9340, 0xc92d,	0x937f, 0xc92d,		0x21, 0
	.dw 0x93c0, 0xc92d,	0x93ff, 0xc92d,		0x21, 0
	.dw 0x9440, 0xc92d,	0x947f, 0xc92d,		0x21, 0
	.dw 0x94c0, 0xc92d,	0x94ff, 0xc92d,		0x21, 0
	.dw 0x9540, 0xc92d,	0x957f, 0xc92d,		0x21, 0
	.dw 0x95c0, 0xc92d,	0x95ff, 0xc92d,		0x21, 0
	.dw 0x9640, 0xc92d,	0x967f, 0xc92d,		0x21, 0
	.dw 0x96c0, 0xc92d,	0x96ff, 0xc92d,		0x21, 0
	.dw 0x9740, 0xc92d,	0x977f, 0xc92d,		0x21, 0
	.dw 0x97c0, 0xc92d,	0x97ff, 0xc92d,		0x21, 0
	.dw 0x9840, 0xc92d,	0x987f, 0xc92d,		0x21, 0
	.dw 0x98c0, 0xc92d,	0x98ff, 0xc92d,		0x21, 0
	.dw 0x9940, 0xc92d,	0x997f, 0xc92d,		0x21, 0
	.dw 0x99c0, 0xc92d,	0x9fff, 0xc92d,		0x21, 0
	.dw 0xa040, 0xc92d,	0xa07f, 0xc92d,		0x21, 0
	.dw 0xa0c0, 0xc92d,	0xa0ff, 0xc92d,		0x21, 0
	.dw 0xa140, 0xc92d,	0xa17f, 0xc92d,		0x21, 0
	.dw 0xa1c0, 0xc92d,	0xa1ff, 0xc92d,		0x21, 0
	.dw 0xa240, 0xc92d,	0xa27f, 0xc92d,		0x21, 0
	.dw 0xa2c0, 0xc92d,	0xa2ff, 0xc92d,		0x21, 0
	.dw 0xa340, 0xc92d,	0xa37f, 0xc92d,		0x21, 0
	.dw 0xa3c0, 0xc92d,	0xa3ff, 0xc92d,		0x21, 0
	.dw 0xa440, 0xc92d,	0xa47f, 0xc92d,		0x21, 0
	.dw 0xa4c0, 0xc92d,	0xa4ff, 0xc92d,		0x21, 0
	.dw 0xa540, 0xc92d,	0xa57f, 0xc92d,		0x21, 0
	.dw 0xa5c0, 0xc92d,	0xa5ff, 0xc92d,		0x21, 0
	.dw 0xa640, 0xc92d,	0xa67f, 0xc92d,		0x21, 0
	.dw 0xa6c0, 0xc92d,	0xa6ff, 0xc92d,		0x21, 0
	.dw 0xa740, 0xc92d,	0xa77f, 0xc92d,		0x21, 0
	.dw 0xa7c0, 0xc92d,	0xa7ff, 0xc92d,		0x21, 0
	.dw 0xa840, 0xc92d,	0xa87f, 0xc92d,		0x21, 0
	.dw 0xa8c0, 0xc92d,	0xa8ff, 0xc92d,		0x21, 0
	.dw 0xa940, 0xc92d,	0xa97f, 0xc92d,		0x21, 0
	.dw 0xa9c0, 0xc92d,	0xa9ff, 0xc92d,		0x21, 0
	.dw 0xaa40, 0xc92d,	0xaa7f, 0xc92d,		0x21, 0
	.dw 0xaac0, 0xc92d,	0xaaff, 0xc92d,		0x21, 0
	.dw 0xab40, 0xc92d,	0xab7f, 0xc92d,		0x21, 0
	.dw 0xabc0, 0xc92d,	0xabff, 0xc92d,		0x21, 0
	.dw 0xac40, 0xc92d,	0xac7f, 0xc92d,		0x21, 0
	.dw 0xacc0, 0xc92d,	0xacff, 0xc92d,		0x21, 0
	.dw 0xad40, 0xc92d,	0xad7f, 0xc92d,		0x21, 0
	.dw 0xadc0, 0xc92d,	0xadff, 0xc92d,		0x21, 0
	.dw 0xae40, 0xc92d,	0xae7f, 0xc92d,		0x21, 0
	.dw 0xaec0, 0xc92d,	0xaeff, 0xc92d,		0x21, 0
	.dw 0xaf40, 0xc92d,	0xaf7f, 0xc92d,		0x21, 0
	.dw 0xafc0, 0xc92d,	0xafff, 0xc92d,		0x21, 0
	.dw 0xb040, 0xc92d,	0xb07f, 0xc92d,		0x21, 0
	.dw 0xb0c0, 0xc92d,	0xb0ff, 0xc92d,		0x21, 0
	.dw 0xb140, 0xc92d,	0xb17f, 0xc92d,		0x21, 0
	.dw 0xb1c0, 0xc92d,	0xb1ff, 0xc92d,		0x21, 0
	.dw 0xb240, 0xc92d,	0xb27f, 0xc92d,		0x21, 0
	.dw 0xb2c0, 0xc92d,	0xb2ff, 0xc92d,		0x21, 0
	.dw 0xb340, 0xc92d,	0xb37f, 0xc92d,		0x21, 0
	.dw 0xb3c0, 0xc92d,	0xb3ff, 0xc92d,		0x21, 0
	.dw 0xb440, 0xc92d,	0xb47f, 0xc92d,		0x21, 0
	.dw 0xb4c0, 0xc92d,	0xb4ff, 0xc92d,		0x21, 0
	.dw 0xb540, 0xc92d,	0xb57f, 0xc92d,		0x21, 0
	.dw 0xb5c0, 0xc92d,	0xb5ff, 0xc92d,		0x21, 0
	.dw 0xb640, 0xc92d,	0xb67f, 0xc92d,		0x21, 0
	.dw 0xb6c0, 0xc92d,	0xb6ff, 0xc92d,		0x21, 0
	.dw 0xb740, 0xc92d,	0xb77f, 0xc92d,		0x21, 0
	.dw 0xb7c0, 0xc92d,	0xb7ff, 0xc92d,		0x21, 0
	.dw 0xb840, 0xc92d,	0xb87f, 0xc92d,		0x21, 0
	.dw 0xb8c0, 0xc92d,	0xb8ff, 0xc92d,		0x21, 0
	.dw 0xb940, 0xc92d,	0xb97f, 0xc92d,		0x21, 0
	.dw 0xb9c0, 0xc92d,	0xbfff, 0xc92d,		0x21, 0
	.dw 0xc040, 0xc92d,	0xc07f, 0xc92d,		0x21, 0
	.dw 0xc0c0, 0xc92d,	0xc0ff, 0xc92d,		0x21, 0
	.dw 0xc140, 0xc92d,	0xc17f, 0xc92d,		0x21, 0
	.dw 0xc1c0, 0xc92d,	0xc1ff, 0xc92d,		0x21, 0
	.dw 0xc240, 0xc92d,	0xc27f, 0xc92d,		0x21, 0
	.dw 0xc2c0, 0xc92d,	0xc2ff, 0xc92d,		0x21, 0
	.dw 0xc340, 0xc92d,	0xc37f, 0xc92d,		0x21, 0
	.dw 0xc3c0, 0xc92d,	0xc3ff, 0xc92d,		0x21, 0
	.dw 0xc440, 0xc92d,	0xc47f, 0xc92d,		0x21, 0
	.dw 0xc4c0, 0xc92d,	0xc4ff, 0xc92d,		0x21, 0
	.dw 0xc540, 0xc92d,	0xc57f, 0xc92d,		0x21, 0
	.dw 0xc5c0, 0xc92d,	0xc5ff, 0xc92d,		0x21, 0
	.dw 0xc640, 0xc92d,	0xc67f, 0xc92d,		0x21, 0
	.dw 0xc6c0, 0xc92d,	0xc6ff, 0xc92d,		0x21, 0
	.dw 0xc740, 0xc92d,	0xc77f, 0xc92d,		0x21, 0
	.dw 0xc7c0, 0xc92d,	0xc7ff, 0xc92d,		0x21, 0
	.dw 0xc840, 0xc92d,	0xc87f, 0xc92d,		0x21, 0
	.dw 0xc8c0, 0xc92d,	0xc8ff, 0xc92d,		0x21, 0
	.dw 0xc940, 0xc92d,	0xc97f, 0xc92d,		0x21, 0
	.dw 0xc9c0, 0xc92d,	0xc9ff, 0xc92d,		0x21, 0
	.dw 0xca40, 0xc92d,	0xca7f, 0xc92d,		0x21, 0
	.dw 0xcac0, 0xc92d,	0xcaff, 0xc92d,		0x21, 0
	.dw 0xcb40, 0xc92d,	0xcb7f, 0xc92d,		0x21, 0
	.dw 0xcbc0, 0xc92d,	0xcbff, 0xc92d,		0x21, 0
	.dw 0xcc40, 0xc92d,	0xcc7f, 0xc92d,		0x21, 0
	.dw 0xccc0, 0xc92d,	0xccff, 0xc92d,		0x21, 0
	.dw 0xcd40, 0xc92d,	0xcd7f, 0xc92d,		0x21, 0
	.dw 0xcdc0, 0xc92d,	0xcdff, 0xc92d,		0x21, 0
	.dw 0xce40, 0xc92d,	0xce7f, 0xc92d,		0x21, 0
	.dw 0xcec0, 0xc92d,	0xceff, 0xc92d,		0x21, 0
	.dw 0xcf40, 0xc92d,	0xcf7f, 0xc92d,		0x21, 0
	.dw 0xcfc0, 0xc92d,	0xcfff, 0xc92d,		0x21, 0
	.dw 0xd040, 0xc92d,	0xd07f, 0xc92d,		0x21, 0
	.dw 0xd0c0, 0xc92d,	0xd0ff, 0xc92d,		0x21, 0
	.dw 0xd140, 0xc92d,	0xd17f, 0xc92d,		0x21, 0
	.dw 0xd1c0, 0xc92d,	0xd1ff, 0xc92d,		0x21, 0
	.dw 0xd240, 0xc92d,	0xd27f, 0xc92d,		0x21, 0
	.dw 0xd2c0, 0xc92d,	0xd2ff, 0xc92d,		0x21, 0
	.dw 0xd340, 0xc92d,	0xd37f, 0xc92d,		0x21, 0
	.dw 0xd3c0, 0xc92d,	0xd3ff, 0xc92d,		0x21, 0
	.dw 0xd440, 0xc92d,	0xd47f, 0xc92d,		0x21, 0
	.dw 0xd4c0, 0xc92d,	0xd4ff, 0xc92d,		0x21, 0
	.dw 0xd540, 0xc92d,	0xd57f, 0xc92d,		0x21, 0
	.dw 0xd5c0, 0xc92d,	0xd5ff, 0xc92d,		0x21, 0
	.dw 0xd640, 0xc92d,	0xd67f, 0xc92d,		0x21, 0
	.dw 0xd6c0, 0xc92d,	0xd6ff, 0xc92d,		0x21, 0
	.dw 0xd740, 0xc92d,	0xd77f, 0xc92d,		0x21, 0
	.dw 0xd7c0, 0xc92d,	0xd7ff, 0xc92d,		0x21, 0
	.dw 0xd840, 0xc92d,	0xd87f, 0xc92d,		0x21, 0
	.dw 0xd8c0, 0xc92d,	0xd8ff, 0xc92d,		0x21, 0
	.dw 0xd940, 0xc92d,	0xd97f, 0xc92d,		0x21, 0
	.dw 0xd9c0, 0xc92d,	0xdfff, 0xc92d,		0x21, 0
	.dw 0xe040, 0xc92d,	0xe07f, 0xc92d,		0x21, 0
	.dw 0xe0c0, 0xc92d,	0xe0ff, 0xc92d,		0x21, 0
	.dw 0xe140, 0xc92d,	0xe17f, 0xc92d,		0x21, 0
	.dw 0xe1c0, 0xc92d,	0xe1ff, 0xc92d,		0x21, 0
	.dw 0xe240, 0xc92d,	0xe27f, 0xc92d,		0x21, 0
	.dw 0xe2c0, 0xc92d,	0xe2ff, 0xc92d,		0x21, 0
	.dw 0xe340, 0xc92d,	0xe37f, 0xc92d,		0x21, 0
	.dw 0xe3c0, 0xc92d,	0xe3ff, 0xc92d,		0x21, 0
	.dw 0xe440, 0xc92d,	0xe47f, 0xc92d,		0x21, 0
	.dw 0xe4c0, 0xc92d,	0xe4ff, 0xc92d,		0x21, 0
	.dw 0xe540, 0xc92d,	0xe57f, 0xc92d,		0x21, 0
	.dw 0xe5c0, 0xc92d,	0xe5ff, 0xc92d,		0x21, 0
	.dw 0xe640, 0xc92d,	0xe67f, 0xc92d,		0x21, 0
	.dw 0xe6c0, 0xc92d,	0xe6ff, 0xc92d,		0x21, 0
	.dw 0xe740, 0xc92d,	0xe77f, 0xc92d,		0x21, 0
	.dw 0xe7c0, 0xc92d,	0xe7ff, 0xc92d,		0x21, 0
	.dw 0xe840, 0xc92d,	0xe87f, 0xc92d,		0x21, 0
	.dw 0xe8c0, 0xc92d,	0xe8ff, 0xc92d,		0x21, 0
	.dw 0xe940, 0xc92d,	0xe97f, 0xc92d,		0x21, 0
	.dw 0xe9c0, 0xc92d,	0xe9ff, 0xc92d,		0x21, 0
	.dw 0xea40, 0xc92d,	0xea7f, 0xc92d,		0x21, 0
	.dw 0xeac0, 0xc92d,	0xeaff, 0xc92d,		0x21, 0
	.dw 0xeb40, 0xc92d,	0xeb7f, 0xc92d,		0x21, 0
	.dw 0xebc0, 0xc92d,	0xebff, 0xc92d,		0x21, 0
	.dw 0xec40, 0xc92d,	0xec7f, 0xc92d,		0x21, 0
	.dw 0xecc0, 0xc92d,	0xecff, 0xc92d,		0x21, 0
	.dw 0xed40, 0xc92d,	0xed7f, 0xc92d,		0x21, 0
	.dw 0xedc0, 0xc92d,	0xedff, 0xc92d,		0x21, 0
	.dw 0xee40, 0xc92d,	0xee7f, 0xc92d,		0x21, 0
	.dw 0xeec0, 0xc92d,	0xeeff, 0xc92d,		0x21, 0
	.dw 0xef40, 0xc92d,	0xef7f, 0xc92d,		0x21, 0
	.dw 0xefc0, 0xc92d,	0xefff, 0xc92d,		0x21, 0
	.dw 0xf040, 0xc92d,	0xf07f, 0xc92d,		0x21, 0
	.dw 0xf0c0, 0xc92d,	0xf0ff, 0xc92d,		0x21, 0
	.dw 0xf140, 0xc92d,	0xf17f, 0xc92d,		0x21, 0
	.dw 0xf1c0, 0xc92d,	0xf1ff, 0xc92d,		0x21, 0
	.dw 0xf240, 0xc92d,	0xf27f, 0xc92d,		0x21, 0
	.dw 0xf2c0, 0xc92d,	0xf2ff, 0xc92d,		0x21, 0
	.dw 0xf340, 0xc92d,	0xf37f, 0xc92d,		0x21, 0
	.dw 0xf3c0, 0xc92d,	0xf3ff, 0xc92d,		0x21, 0
	.dw 0xf440, 0xc92d,	0xf47f, 0xc92d,		0x21, 0
	.dw 0xf4c0, 0xc92d,	0xf4ff, 0xc92d,		0x21, 0
	.dw 0xf540, 0xc92d,	0xf57f, 0xc92d,		0x21, 0
	.dw 0xf5c0, 0xc92d,	0xf5ff, 0xc92d,		0x21, 0
	.dw 0xf640, 0xc92d,	0xf67f, 0xc92d,		0x21, 0
	.dw 0xf6c0, 0xc92d,	0xf6ff, 0xc92d,		0x21, 0
	.dw 0xf740, 0xc92d,	0xf77f, 0xc92d,		0x21, 0
	.dw 0xf7c0, 0xc92d,	0xf7ff, 0xc92d,		0x21, 0
	.dw 0xf840, 0xc92d,	0xf87f, 0xc92d,		0x21, 0
	.dw 0xf8c0, 0xc92d,	0xf8ff, 0xc92d,		0x21, 0
	.dw 0xf940, 0xc92d,	0xf97f, 0xc92d,		0x21, 0
	.dw 0xf9c0, 0xc92d,	0xffff, 0xc92d,		0x21, 0
	.dw 0x0040, 0xc92e,	0x007f, 0xc92e,		0x21, 0
	.dw 0x00c0, 0xc92e,	0x00ff, 0xc92e,		0x21, 0
	.dw 0x0140, 0xc92e,	0x017f, 0xc92e,		0x21, 0
	.dw 0x01c0, 0xc92e,	0x01ff, 0xc92e,		0x21, 0
	.dw 0x0240, 0xc92e,	0x027f, 0xc92e,		0x21, 0
	.dw 0x02c0, 0xc92e,	0x02ff, 0xc92e,		0x21, 0
	.dw 0x0340, 0xc92e,	0x037f, 0xc92e,		0x21, 0
	.dw 0x03c0, 0xc92e,	0x03ff, 0xc92e,		0x21, 0
	.dw 0x0440, 0xc92e,	0x047f, 0xc92e,		0x21, 0
	.dw 0x04c0, 0xc92e,	0x04ff, 0xc92e,		0x21, 0
	.dw 0x0540, 0xc92e,	0x057f, 0xc92e,		0x21, 0
	.dw 0x05c0, 0xc92e,	0x05ff, 0xc92e,		0x21, 0
	.dw 0x0640, 0xc92e,	0x067f, 0xc92e,		0x21, 0
	.dw 0x06c0, 0xc92e,	0x06ff, 0xc92e,		0x21, 0
	.dw 0x0740, 0xc92e,	0x077f, 0xc92e,		0x21, 0
	.dw 0x07c0, 0xc92e,	0x07ff, 0xc92e,		0x21, 0
	.dw 0x0840, 0xc92e,	0x087f, 0xc92e,		0x21, 0
	.dw 0x08c0, 0xc92e,	0x08ff, 0xc92e,		0x21, 0
	.dw 0x0940, 0xc92e,	0x097f, 0xc92e,		0x21, 0
	.dw 0x09c0, 0xc92e,	0x09ff, 0xc92e,		0x21, 0
	.dw 0x0a40, 0xc92e,	0x0a7f, 0xc92e,		0x21, 0
	.dw 0x0ac0, 0xc92e,	0x0aff, 0xc92e,		0x21, 0
	.dw 0x0b40, 0xc92e,	0x0b7f, 0xc92e,		0x21, 0
	.dw 0x0bc0, 0xc92e,	0x0bff, 0xc92e,		0x21, 0
	.dw 0x0c40, 0xc92e,	0x0c7f, 0xc92e,		0x21, 0
	.dw 0x0cc0, 0xc92e,	0x0cff, 0xc92e,		0x21, 0
	.dw 0x0d40, 0xc92e,	0x0d7f, 0xc92e,		0x21, 0
	.dw 0x0dc0, 0xc92e,	0x0dff, 0xc92e,		0x21, 0
	.dw 0x0e40, 0xc92e,	0x0e7f, 0xc92e,		0x21, 0
	.dw 0x0ec0, 0xc92e,	0x0eff, 0xc92e,		0x21, 0
	.dw 0x0f40, 0xc92e,	0x0f7f, 0xc92e,		0x21, 0
	.dw 0x0fc0, 0xc92e,	0x0fff, 0xc92e,		0x21, 0
	.dw 0x1040, 0xc92e,	0x107f, 0xc92e,		0x21, 0
	.dw 0x10c0, 0xc92e,	0x10ff, 0xc92e,		0x21, 0
	.dw 0x1140, 0xc92e,	0x117f, 0xc92e,		0x21, 0
	.dw 0x11c0, 0xc92e,	0x11ff, 0xc92e,		0x21, 0
	.dw 0x1240, 0xc92e,	0x127f, 0xc92e,		0x21, 0
	.dw 0x12c0, 0xc92e,	0x12ff, 0xc92e,		0x21, 0
	.dw 0x1340, 0xc92e,	0x137f, 0xc92e,		0x21, 0
	.dw 0x13c0, 0xc92e,	0x13ff, 0xc92e,		0x21, 0
	.dw 0x1440, 0xc92e,	0x147f, 0xc92e,		0x21, 0
	.dw 0x14c0, 0xc92e,	0x14ff, 0xc92e,		0x21, 0
	.dw 0x1540, 0xc92e,	0x157f, 0xc92e,		0x21, 0
	.dw 0x15c0, 0xc92e,	0x15ff, 0xc92e,		0x21, 0
	.dw 0x1640, 0xc92e,	0x167f, 0xc92e,		0x21, 0
	.dw 0x16c0, 0xc92e,	0x16ff, 0xc92e,		0x21, 0
	.dw 0x1740, 0xc92e,	0x177f, 0xc92e,		0x21, 0
	.dw 0x17c0, 0xc92e,	0x17ff, 0xc92e,		0x21, 0
	.dw 0x1840, 0xc92e,	0x187f, 0xc92e,		0x21, 0
	.dw 0x18c0, 0xc92e,	0x18ff, 0xc92e,		0x21, 0
	.dw 0x1940, 0xc92e,	0x197f, 0xc92e,		0x21, 0
	.dw 0x19c0, 0xc92e,	0x1fff, 0xc92e,		0x21, 0
	.dw 0x2040, 0xc92e,	0x207f, 0xc92e,		0x21, 0
	.dw 0x20c0, 0xc92e,	0x20ff, 0xc92e,		0x21, 0
	.dw 0x2140, 0xc92e,	0x217f, 0xc92e,		0x21, 0
	.dw 0x21c0, 0xc92e,	0x21ff, 0xc92e,		0x21, 0
	.dw 0x2240, 0xc92e,	0x227f, 0xc92e,		0x21, 0
	.dw 0x22c0, 0xc92e,	0x22ff, 0xc92e,		0x21, 0
	.dw 0x2340, 0xc92e,	0x237f, 0xc92e,		0x21, 0
	.dw 0x23c0, 0xc92e,	0x23ff, 0xc92e,		0x21, 0
	.dw 0x2440, 0xc92e,	0x247f, 0xc92e,		0x21, 0
	.dw 0x24c0, 0xc92e,	0x24ff, 0xc92e,		0x21, 0
	.dw 0x2540, 0xc92e,	0x257f, 0xc92e,		0x21, 0
	.dw 0x25c0, 0xc92e,	0x25ff, 0xc92e,		0x21, 0
	.dw 0x2640, 0xc92e,	0x267f, 0xc92e,		0x21, 0
	.dw 0x26c0, 0xc92e,	0x26ff, 0xc92e,		0x21, 0
	.dw 0x2740, 0xc92e,	0x277f, 0xc92e,		0x21, 0
	.dw 0x27c0, 0xc92e,	0x27ff, 0xc92e,		0x21, 0
	.dw 0x2840, 0xc92e,	0x287f, 0xc92e,		0x21, 0
	.dw 0x28c0, 0xc92e,	0x28ff, 0xc92e,		0x21, 0
	.dw 0x2940, 0xc92e,	0x297f, 0xc92e,		0x21, 0
	.dw 0x29c0, 0xc92e,	0x29ff, 0xc92e,		0x21, 0
	.dw 0x2a40, 0xc92e,	0x2a7f, 0xc92e,		0x21, 0
	.dw 0x2ac0, 0xc92e,	0x2aff, 0xc92e,		0x21, 0
	.dw 0x2b40, 0xc92e,	0x2b7f, 0xc92e,		0x21, 0
	.dw 0x2bc0, 0xc92e,	0x2bff, 0xc92e,		0x21, 0
	.dw 0x2c40, 0xc92e,	0x2c7f, 0xc92e,		0x21, 0
	.dw 0x2cc0, 0xc92e,	0x2cff, 0xc92e,		0x21, 0
	.dw 0x2d40, 0xc92e,	0x2d7f, 0xc92e,		0x21, 0
	.dw 0x2dc0, 0xc92e,	0x2dff, 0xc92e,		0x21, 0
	.dw 0x2e40, 0xc92e,	0x2e7f, 0xc92e,		0x21, 0
	.dw 0x2ec0, 0xc92e,	0x2eff, 0xc92e,		0x21, 0
	.dw 0x2f40, 0xc92e,	0x2f7f, 0xc92e,		0x21, 0
	.dw 0x2fc0, 0xc92e,	0x2fff, 0xc92e,		0x21, 0
	.dw 0x3040, 0xc92e,	0x307f, 0xc92e,		0x21, 0
	.dw 0x30c0, 0xc92e,	0x30ff, 0xc92e,		0x21, 0
	.dw 0x3140, 0xc92e,	0x317f, 0xc92e,		0x21, 0
	.dw 0x31c0, 0xc92e,	0x31ff, 0xc92e,		0x21, 0
	.dw 0x3240, 0xc92e,	0x327f, 0xc92e,		0x21, 0
	.dw 0x32c0, 0xc92e,	0x32ff, 0xc92e,		0x21, 0
	.dw 0x3340, 0xc92e,	0x337f, 0xc92e,		0x21, 0
	.dw 0x33c0, 0xc92e,	0x33ff, 0xc92e,		0x21, 0
	.dw 0x3440, 0xc92e,	0x347f, 0xc92e,		0x21, 0
	.dw 0x34c0, 0xc92e,	0x34ff, 0xc92e,		0x21, 0
	.dw 0x3540, 0xc92e,	0x357f, 0xc92e,		0x21, 0
	.dw 0x35c0, 0xc92e,	0x35ff, 0xc92e,		0x21, 0
	.dw 0x3640, 0xc92e,	0x367f, 0xc92e,		0x21, 0
	.dw 0x36c0, 0xc92e,	0x36ff, 0xc92e,		0x21, 0
	.dw 0x3740, 0xc92e,	0x377f, 0xc92e,		0x21, 0
	.dw 0x37c0, 0xc92e,	0x37ff, 0xc92e,		0x21, 0
	.dw 0x3840, 0xc92e,	0x387f, 0xc92e,		0x21, 0
	.dw 0x38c0, 0xc92e,	0x38ff, 0xc92e,		0x21, 0
	.dw 0x3940, 0xc92e,	0x397f, 0xc92e,		0x21, 0
	.dw 0x39c0, 0xc92e,	0x3fff, 0xc92e,		0x21, 0
	.dw 0x4040, 0xc92e,	0x407f, 0xc92e,		0x21, 0
	.dw 0x40c0, 0xc92e,	0x40ff, 0xc92e,		0x21, 0
	.dw 0x4140, 0xc92e,	0x417f, 0xc92e,		0x21, 0
	.dw 0x41c0, 0xc92e,	0x41ff, 0xc92e,		0x21, 0
	.dw 0x4240, 0xc92e,	0x427f, 0xc92e,		0x21, 0
	.dw 0x42c0, 0xc92e,	0x42ff, 0xc92e,		0x21, 0
	.dw 0x4340, 0xc92e,	0x437f, 0xc92e,		0x21, 0
	.dw 0x43c0, 0xc92e,	0x43ff, 0xc92e,		0x21, 0
	.dw 0x4440, 0xc92e,	0x447f, 0xc92e,		0x21, 0
	.dw 0x44c0, 0xc92e,	0x44ff, 0xc92e,		0x21, 0
	.dw 0x4540, 0xc92e,	0x457f, 0xc92e,		0x21, 0
	.dw 0x45c0, 0xc92e,	0x45ff, 0xc92e,		0x21, 0
	.dw 0x4640, 0xc92e,	0x467f, 0xc92e,		0x21, 0
	.dw 0x46c0, 0xc92e,	0x46ff, 0xc92e,		0x21, 0
	.dw 0x4740, 0xc92e,	0x477f, 0xc92e,		0x21, 0
	.dw 0x47c0, 0xc92e,	0x47ff, 0xc92e,		0x21, 0
	.dw 0x4840, 0xc92e,	0x487f, 0xc92e,		0x21, 0
	.dw 0x48c0, 0xc92e,	0x48ff, 0xc92e,		0x21, 0
	.dw 0x4940, 0xc92e,	0x497f, 0xc92e,		0x21, 0
	.dw 0x49c0, 0xc92e,	0x49ff, 0xc92e,		0x21, 0
	.dw 0x4a40, 0xc92e,	0x4a7f, 0xc92e,		0x21, 0
	.dw 0x4ac0, 0xc92e,	0x4aff, 0xc92e,		0x21, 0
	.dw 0x4b40, 0xc92e,	0x4b7f, 0xc92e,		0x21, 0
	.dw 0x4bc0, 0xc92e,	0x4bff, 0xc92e,		0x21, 0
	.dw 0x4c40, 0xc92e,	0x4c7f, 0xc92e,		0x21, 0
	.dw 0x4cc0, 0xc92e,	0x4cff, 0xc92e,		0x21, 0
	.dw 0x4d40, 0xc92e,	0x4d7f, 0xc92e,		0x21, 0
	.dw 0x4dc0, 0xc92e,	0x4dff, 0xc92e,		0x21, 0
	.dw 0x4e40, 0xc92e,	0x4e7f, 0xc92e,		0x21, 0
	.dw 0x4ec0, 0xc92e,	0x4eff, 0xc92e,		0x21, 0
	.dw 0x4f40, 0xc92e,	0x4f7f, 0xc92e,		0x21, 0
	.dw 0x4fc0, 0xc92e,	0x4fff, 0xc92e,		0x21, 0
	.dw 0x5040, 0xc92e,	0x507f, 0xc92e,		0x21, 0
	.dw 0x50c0, 0xc92e,	0x50ff, 0xc92e,		0x21, 0
	.dw 0x5140, 0xc92e,	0x517f, 0xc92e,		0x21, 0
	.dw 0x51c0, 0xc92e,	0x51ff, 0xc92e,		0x21, 0
	.dw 0x5240, 0xc92e,	0x527f, 0xc92e,		0x21, 0
	.dw 0x52c0, 0xc92e,	0x52ff, 0xc92e,		0x21, 0
	.dw 0x5340, 0xc92e,	0x537f, 0xc92e,		0x21, 0
	.dw 0x53c0, 0xc92e,	0x53ff, 0xc92e,		0x21, 0
	.dw 0x5440, 0xc92e,	0x547f, 0xc92e,		0x21, 0
	.dw 0x54c0, 0xc92e,	0x54ff, 0xc92e,		0x21, 0
	.dw 0x5540, 0xc92e,	0x557f, 0xc92e,		0x21, 0
	.dw 0x55c0, 0xc92e,	0x55ff, 0xc92e,		0x21, 0
	.dw 0x5640, 0xc92e,	0x567f, 0xc92e,		0x21, 0
	.dw 0x56c0, 0xc92e,	0x56ff, 0xc92e,		0x21, 0
	.dw 0x5740, 0xc92e,	0x577f, 0xc92e,		0x21, 0
	.dw 0x57c0, 0xc92e,	0x57ff, 0xc92e,		0x21, 0
	.dw 0x5840, 0xc92e,	0x587f, 0xc92e,		0x21, 0
	.dw 0x58c0, 0xc92e,	0x58ff, 0xc92e,		0x21, 0
	.dw 0x5940, 0xc92e,	0x597f, 0xc92e,		0x21, 0
	.dw 0x59c0, 0xc92e,	0x5fff, 0xc92e,		0x21, 0
	.dw 0x6040, 0xc92e,	0x607f, 0xc92e,		0x21, 0
	.dw 0x60c0, 0xc92e,	0x60ff, 0xc92e,		0x21, 0
	.dw 0x6140, 0xc92e,	0x617f, 0xc92e,		0x21, 0
	.dw 0x61c0, 0xc92e,	0x61ff, 0xc92e,		0x21, 0
	.dw 0x6240, 0xc92e,	0x627f, 0xc92e,		0x21, 0
	.dw 0x62c0, 0xc92e,	0x62ff, 0xc92e,		0x21, 0
	.dw 0x6340, 0xc92e,	0x637f, 0xc92e,		0x21, 0
	.dw 0x63c0, 0xc92e,	0x63ff, 0xc92e,		0x21, 0
	.dw 0x6440, 0xc92e,	0x647f, 0xc92e,		0x21, 0
	.dw 0x64c0, 0xc92e,	0x64ff, 0xc92e,		0x21, 0
	.dw 0x6540, 0xc92e,	0x657f, 0xc92e,		0x21, 0
	.dw 0x65c0, 0xc92e,	0x65ff, 0xc92e,		0x21, 0
	.dw 0x6640, 0xc92e,	0x667f, 0xc92e,		0x21, 0
	.dw 0x66c0, 0xc92e,	0x66ff, 0xc92e,		0x21, 0
	.dw 0x6740, 0xc92e,	0x677f, 0xc92e,		0x21, 0
	.dw 0x67c0, 0xc92e,	0x67ff, 0xc92e,		0x21, 0
	.dw 0x6840, 0xc92e,	0x687f, 0xc92e,		0x21, 0
	.dw 0x68c0, 0xc92e,	0x68ff, 0xc92e,		0x21, 0
	.dw 0x6940, 0xc92e,	0x697f, 0xc92e,		0x21, 0
	.dw 0x69c0, 0xc92e,	0x69ff, 0xc92e,		0x21, 0
	.dw 0x6a40, 0xc92e,	0x6a7f, 0xc92e,		0x21, 0
	.dw 0x6ac0, 0xc92e,	0x6aff, 0xc92e,		0x21, 0
	.dw 0x6b40, 0xc92e,	0x6b7f, 0xc92e,		0x21, 0
	.dw 0x6bc0, 0xc92e,	0x6bff, 0xc92e,		0x21, 0
	.dw 0x6c40, 0xc92e,	0x6c7f, 0xc92e,		0x21, 0
	.dw 0x6cc0, 0xc92e,	0x6cff, 0xc92e,		0x21, 0
	.dw 0x6d40, 0xc92e,	0x6d7f, 0xc92e,		0x21, 0
	.dw 0x6dc0, 0xc92e,	0x6dff, 0xc92e,		0x21, 0
	.dw 0x6e40, 0xc92e,	0x6e7f, 0xc92e,		0x21, 0
	.dw 0x6ec0, 0xc92e,	0x6eff, 0xc92e,		0x21, 0
	.dw 0x6f40, 0xc92e,	0x6f7f, 0xc92e,		0x21, 0
	.dw 0x6fc0, 0xc92e,	0x6fff, 0xc92e,		0x21, 0
	.dw 0x7040, 0xc92e,	0x707f, 0xc92e,		0x21, 0
	.dw 0x70c0, 0xc92e,	0x70ff, 0xc92e,		0x21, 0
	.dw 0x7140, 0xc92e,	0x717f, 0xc92e,		0x21, 0
	.dw 0x71c0, 0xc92e,	0x71ff, 0xc92e,		0x21, 0
	.dw 0x7240, 0xc92e,	0x727f, 0xc92e,		0x21, 0
	.dw 0x72c0, 0xc92e,	0x72ff, 0xc92e,		0x21, 0
	.dw 0x7340, 0xc92e,	0x737f, 0xc92e,		0x21, 0
	.dw 0x73c0, 0xc92e,	0x73ff, 0xc92e,		0x21, 0
	.dw 0x7440, 0xc92e,	0x747f, 0xc92e,		0x21, 0
	.dw 0x74c0, 0xc92e,	0x74ff, 0xc92e,		0x21, 0
	.dw 0x7540, 0xc92e,	0x757f, 0xc92e,		0x21, 0
	.dw 0x75c0, 0xc92e,	0x75ff, 0xc92e,		0x21, 0
	.dw 0x7640, 0xc92e,	0x767f, 0xc92e,		0x21, 0
	.dw 0x76c0, 0xc92e,	0x76ff, 0xc92e,		0x21, 0
	.dw 0x7740, 0xc92e,	0x777f, 0xc92e,		0x21, 0
	.dw 0x77c0, 0xc92e,	0x77ff, 0xc92e,		0x21, 0
	.dw 0x7840, 0xc92e,	0x787f, 0xc92e,		0x21, 0
	.dw 0x78c0, 0xc92e,	0x78ff, 0xc92e,		0x21, 0
	.dw 0x7940, 0xc92e,	0x797f, 0xc92e,		0x21, 0
	.dw 0x79c0, 0xc92e,	0x7fff, 0xc92e,		0x21, 0
	.dw 0x8040, 0xc92e,	0x807f, 0xc92e,		0x21, 0
	.dw 0x80c0, 0xc92e,	0x80ff, 0xc92e,		0x21, 0
	.dw 0x8140, 0xc92e,	0x817f, 0xc92e,		0x21, 0
	.dw 0x81c0, 0xc92e,	0x81ff, 0xc92e,		0x21, 0
	.dw 0x8240, 0xc92e,	0x827f, 0xc92e,		0x21, 0
	.dw 0x82c0, 0xc92e,	0x82ff, 0xc92e,		0x21, 0
	.dw 0x8340, 0xc92e,	0x837f, 0xc92e,		0x21, 0
	.dw 0x83c0, 0xc92e,	0x83ff, 0xc92e,		0x21, 0
	.dw 0x8440, 0xc92e,	0x847f, 0xc92e,		0x21, 0
	.dw 0x84c0, 0xc92e,	0x84ff, 0xc92e,		0x21, 0
	.dw 0x8540, 0xc92e,	0x857f, 0xc92e,		0x21, 0
	.dw 0x85c0, 0xc92e,	0x85ff, 0xc92e,		0x21, 0
	.dw 0x8640, 0xc92e,	0x867f, 0xc92e,		0x21, 0
	.dw 0x86c0, 0xc92e,	0x86ff, 0xc92e,		0x21, 0
	.dw 0x8740, 0xc92e,	0x877f, 0xc92e,		0x21, 0
	.dw 0x87c0, 0xc92e,	0x87ff, 0xc92e,		0x21, 0
	.dw 0x8840, 0xc92e,	0x887f, 0xc92e,		0x21, 0
	.dw 0x88c0, 0xc92e,	0x88ff, 0xc92e,		0x21, 0
	.dw 0x8940, 0xc92e,	0x897f, 0xc92e,		0x21, 0
	.dw 0x89c0, 0xc92e,	0x89ff, 0xc92e,		0x21, 0
	.dw 0x8a40, 0xc92e,	0x8a7f, 0xc92e,		0x21, 0
	.dw 0x8ac0, 0xc92e,	0x8aff, 0xc92e,		0x21, 0
	.dw 0x8b40, 0xc92e,	0x8b7f, 0xc92e,		0x21, 0
	.dw 0x8bc0, 0xc92e,	0x8bff, 0xc92e,		0x21, 0
	.dw 0x8c40, 0xc92e,	0x8c7f, 0xc92e,		0x21, 0
	.dw 0x8cc0, 0xc92e,	0x8cff, 0xc92e,		0x21, 0
	.dw 0x8d40, 0xc92e,	0x8d7f, 0xc92e,		0x21, 0
	.dw 0x8dc0, 0xc92e,	0x8dff, 0xc92e,		0x21, 0
	.dw 0x8e40, 0xc92e,	0x8e7f, 0xc92e,		0x21, 0
	.dw 0x8ec0, 0xc92e,	0x8eff, 0xc92e,		0x21, 0
	.dw 0x8f40, 0xc92e,	0x8f7f, 0xc92e,		0x21, 0
	.dw 0x8fc0, 0xc92e,	0x8fff, 0xc92e,		0x21, 0
	.dw 0x9040, 0xc92e,	0x907f, 0xc92e,		0x21, 0
	.dw 0x90c0, 0xc92e,	0x90ff, 0xc92e,		0x21, 0
	.dw 0x9140, 0xc92e,	0x917f, 0xc92e,		0x21, 0
	.dw 0x91c0, 0xc92e,	0x91ff, 0xc92e,		0x21, 0
	.dw 0x9240, 0xc92e,	0x927f, 0xc92e,		0x21, 0
	.dw 0x92c0, 0xc92e,	0x92ff, 0xc92e,		0x21, 0
	.dw 0x9340, 0xc92e,	0x937f, 0xc92e,		0x21, 0
	.dw 0x93c0, 0xc92e,	0x93ff, 0xc92e,		0x21, 0
	.dw 0x9440, 0xc92e,	0x947f, 0xc92e,		0x21, 0
	.dw 0x94c0, 0xc92e,	0x94ff, 0xc92e,		0x21, 0
	.dw 0x9540, 0xc92e,	0x957f, 0xc92e,		0x21, 0
	.dw 0x95c0, 0xc92e,	0x95ff, 0xc92e,		0x21, 0
	.dw 0x9640, 0xc92e,	0x967f, 0xc92e,		0x21, 0
	.dw 0x96c0, 0xc92e,	0x96ff, 0xc92e,		0x21, 0
	.dw 0x9740, 0xc92e,	0x977f, 0xc92e,		0x21, 0
	.dw 0x97c0, 0xc92e,	0x97ff, 0xc92e,		0x21, 0
	.dw 0x9840, 0xc92e,	0x987f, 0xc92e,		0x21, 0
	.dw 0x98c0, 0xc92e,	0x98ff, 0xc92e,		0x21, 0
	.dw 0x9940, 0xc92e,	0x997f, 0xc92e,		0x21, 0
	.dw 0x99c0, 0xc92e,	0x9fff, 0xc92e,		0x21, 0
	.dw 0xa040, 0xc92e,	0xa07f, 0xc92e,		0x21, 0
	.dw 0xa0c0, 0xc92e,	0xa0ff, 0xc92e,		0x21, 0
	.dw 0xa140, 0xc92e,	0xa17f, 0xc92e,		0x21, 0
	.dw 0xa1c0, 0xc92e,	0xa1ff, 0xc92e,		0x21, 0
	.dw 0xa240, 0xc92e,	0xa27f, 0xc92e,		0x21, 0
	.dw 0xa2c0, 0xc92e,	0xa2ff, 0xc92e,		0x21, 0
	.dw 0xa340, 0xc92e,	0xa37f, 0xc92e,		0x21, 0
	.dw 0xa3c0, 0xc92e,	0xa3ff, 0xc92e,		0x21, 0
	.dw 0xa440, 0xc92e,	0xa47f, 0xc92e,		0x21, 0
	.dw 0xa4c0, 0xc92e,	0xa4ff, 0xc92e,		0x21, 0
	.dw 0xa540, 0xc92e,	0xa57f, 0xc92e,		0x21, 0
	.dw 0xa5c0, 0xc92e,	0xa5ff, 0xc92e,		0x21, 0
	.dw 0xa640, 0xc92e,	0xa67f, 0xc92e,		0x21, 0
	.dw 0xa6c0, 0xc92e,	0xa6ff, 0xc92e,		0x21, 0
	.dw 0xa740, 0xc92e,	0xa77f, 0xc92e,		0x21, 0
	.dw 0xa7c0, 0xc92e,	0xa7ff, 0xc92e,		0x21, 0
	.dw 0xa840, 0xc92e,	0xa87f, 0xc92e,		0x21, 0
	.dw 0xa8c0, 0xc92e,	0xa8ff, 0xc92e,		0x21, 0
	.dw 0xa940, 0xc92e,	0xa97f, 0xc92e,		0x21, 0
	.dw 0xa9c0, 0xc92e,	0xa9ff, 0xc92e,		0x21, 0
	.dw 0xaa40, 0xc92e,	0xaa7f, 0xc92e,		0x21, 0
	.dw 0xaac0, 0xc92e,	0xaaff, 0xc92e,		0x21, 0
	.dw 0xab40, 0xc92e,	0xab7f, 0xc92e,		0x21, 0
	.dw 0xabc0, 0xc92e,	0xabff, 0xc92e,		0x21, 0
	.dw 0xac40, 0xc92e,	0xac7f, 0xc92e,		0x21, 0
	.dw 0xacc0, 0xc92e,	0xacff, 0xc92e,		0x21, 0
	.dw 0xad40, 0xc92e,	0xad7f, 0xc92e,		0x21, 0
	.dw 0xadc0, 0xc92e,	0xadff, 0xc92e,		0x21, 0
	.dw 0xae40, 0xc92e,	0xae7f, 0xc92e,		0x21, 0
	.dw 0xaec0, 0xc92e,	0xaeff, 0xc92e,		0x21, 0
	.dw 0xaf40, 0xc92e,	0xaf7f, 0xc92e,		0x21, 0
	.dw 0xafc0, 0xc92e,	0xafff, 0xc92e,		0x21, 0
	.dw 0xb040, 0xc92e,	0xb07f, 0xc92e,		0x21, 0
	.dw 0xb0c0, 0xc92e,	0xb0ff, 0xc92e,		0x21, 0
	.dw 0xb140, 0xc92e,	0xb17f, 0xc92e,		0x21, 0
	.dw 0xb1c0, 0xc92e,	0xb1ff, 0xc92e,		0x21, 0
	.dw 0xb240, 0xc92e,	0xb27f, 0xc92e,		0x21, 0
	.dw 0xb2c0, 0xc92e,	0xb2ff, 0xc92e,		0x21, 0
	.dw 0xb340, 0xc92e,	0xb37f, 0xc92e,		0x21, 0
	.dw 0xb3c0, 0xc92e,	0xb3ff, 0xc92e,		0x21, 0
	.dw 0xb440, 0xc92e,	0xb47f, 0xc92e,		0x21, 0
	.dw 0xb4c0, 0xc92e,	0xb4ff, 0xc92e,		0x21, 0
	.dw 0xb540, 0xc92e,	0xb57f, 0xc92e,		0x21, 0
	.dw 0xb5c0, 0xc92e,	0xb5ff, 0xc92e,		0x21, 0
	.dw 0xb640, 0xc92e,	0xb67f, 0xc92e,		0x21, 0
	.dw 0xb6c0, 0xc92e,	0xb6ff, 0xc92e,		0x21, 0
	.dw 0xb740, 0xc92e,	0xb77f, 0xc92e,		0x21, 0
	.dw 0xb7c0, 0xc92e,	0xb7ff, 0xc92e,		0x21, 0
	.dw 0xb840, 0xc92e,	0xb87f, 0xc92e,		0x21, 0
	.dw 0xb8c0, 0xc92e,	0xb8ff, 0xc92e,		0x21, 0
	.dw 0xb940, 0xc92e,	0xb97f, 0xc92e,		0x21, 0
	.dw 0xb9c0, 0xc92e,	0xbfff, 0xc92e,		0x21, 0
	.dw 0xc040, 0xc92e,	0xc07f, 0xc92e,		0x21, 0
	.dw 0xc0c0, 0xc92e,	0xc0ff, 0xc92e,		0x21, 0
	.dw 0xc140, 0xc92e,	0xc17f, 0xc92e,		0x21, 0
	.dw 0xc1c0, 0xc92e,	0xc1ff, 0xc92e,		0x21, 0
	.dw 0xc240, 0xc92e,	0xc27f, 0xc92e,		0x21, 0
	.dw 0xc2c0, 0xc92e,	0xc2ff, 0xc92e,		0x21, 0
	.dw 0xc340, 0xc92e,	0xc37f, 0xc92e,		0x21, 0
	.dw 0xc3c0, 0xc92e,	0xc3ff, 0xc92e,		0x21, 0
	.dw 0xc440, 0xc92e,	0xc47f, 0xc92e,		0x21, 0
	.dw 0xc4c0, 0xc92e,	0xc4ff, 0xc92e,		0x21, 0
	.dw 0xc540, 0xc92e,	0xc57f, 0xc92e,		0x21, 0
	.dw 0xc5c0, 0xc92e,	0xc5ff, 0xc92e,		0x21, 0
	.dw 0xc640, 0xc92e,	0xc67f, 0xc92e,		0x21, 0
	.dw 0xc6c0, 0xc92e,	0xc6ff, 0xc92e,		0x21, 0
	.dw 0xc740, 0xc92e,	0xc77f, 0xc92e,		0x21, 0
	.dw 0xc7c0, 0xc92e,	0xc7ff, 0xc92e,		0x21, 0
	.dw 0xc840, 0xc92e,	0xc87f, 0xc92e,		0x21, 0
	.dw 0xc8c0, 0xc92e,	0xc8ff, 0xc92e,		0x21, 0
	.dw 0xc940, 0xc92e,	0xc97f, 0xc92e,		0x21, 0
	.dw 0xc9c0, 0xc92e,	0xc9ff, 0xc92e,		0x21, 0
	.dw 0xca40, 0xc92e,	0xca7f, 0xc92e,		0x21, 0
	.dw 0xcac0, 0xc92e,	0xcaff, 0xc92e,		0x21, 0
	.dw 0xcb40, 0xc92e,	0xcb7f, 0xc92e,		0x21, 0
	.dw 0xcbc0, 0xc92e,	0xcbff, 0xc92e,		0x21, 0
	.dw 0xcc40, 0xc92e,	0xcc7f, 0xc92e,		0x21, 0
	.dw 0xccc0, 0xc92e,	0xccff, 0xc92e,		0x21, 0
	.dw 0xcd40, 0xc92e,	0xcd7f, 0xc92e,		0x21, 0
	.dw 0xcdc0, 0xc92e,	0xcdff, 0xc92e,		0x21, 0
	.dw 0xce40, 0xc92e,	0xce7f, 0xc92e,		0x21, 0
	.dw 0xcec0, 0xc92e,	0xceff, 0xc92e,		0x21, 0
	.dw 0xcf40, 0xc92e,	0xcf7f, 0xc92e,		0x21, 0
	.dw 0xcfc0, 0xc92e,	0xcfff, 0xc92e,		0x21, 0
	.dw 0xd040, 0xc92e,	0xd07f, 0xc92e,		0x21, 0
	.dw 0xd0c0, 0xc92e,	0xd0ff, 0xc92e,		0x21, 0
	.dw 0xd140, 0xc92e,	0xd17f, 0xc92e,		0x21, 0
	.dw 0xd1c0, 0xc92e,	0xd1ff, 0xc92e,		0x21, 0
	.dw 0xd240, 0xc92e,	0xd27f, 0xc92e,		0x21, 0
	.dw 0xd2c0, 0xc92e,	0xd2ff, 0xc92e,		0x21, 0
	.dw 0xd340, 0xc92e,	0xd37f, 0xc92e,		0x21, 0
	.dw 0xd3c0, 0xc92e,	0xd3ff, 0xc92e,		0x21, 0
	.dw 0xd440, 0xc92e,	0xd47f, 0xc92e,		0x21, 0
	.dw 0xd4c0, 0xc92e,	0xd4ff, 0xc92e,		0x21, 0
	.dw 0xd540, 0xc92e,	0xd57f, 0xc92e,		0x21, 0
	.dw 0xd5c0, 0xc92e,	0xd5ff, 0xc92e,		0x21, 0
	.dw 0xd640, 0xc92e,	0xd67f, 0xc92e,		0x21, 0
	.dw 0xd6c0, 0xc92e,	0xd6ff, 0xc92e,		0x21, 0
	.dw 0xd740, 0xc92e,	0xd77f, 0xc92e,		0x21, 0
	.dw 0xd7c0, 0xc92e,	0xd7ff, 0xc92e,		0x21, 0
	.dw 0xd840, 0xc92e,	0xd87f, 0xc92e,		0x21, 0
	.dw 0xd8c0, 0xc92e,	0xd8ff, 0xc92e,		0x21, 0
	.dw 0xd940, 0xc92e,	0xd97f, 0xc92e,		0x21, 0
	.dw 0xd9c0, 0xc92e,	0xdfff, 0xc92e,		0x21, 0
	.dw 0xe040, 0xc92e,	0xe07f, 0xc92e,		0x21, 0
	.dw 0xe0c0, 0xc92e,	0xe0ff, 0xc92e,		0x21, 0
	.dw 0xe140, 0xc92e,	0xe17f, 0xc92e,		0x21, 0
	.dw 0xe1c0, 0xc92e,	0xe1ff, 0xc92e,		0x21, 0
	.dw 0xe240, 0xc92e,	0xe27f, 0xc92e,		0x21, 0
	.dw 0xe2c0, 0xc92e,	0xe2ff, 0xc92e,		0x21, 0
	.dw 0xe340, 0xc92e,	0xe37f, 0xc92e,		0x21, 0
	.dw 0xe3c0, 0xc92e,	0xe3ff, 0xc92e,		0x21, 0
	.dw 0xe440, 0xc92e,	0xe47f, 0xc92e,		0x21, 0
	.dw 0xe4c0, 0xc92e,	0xe4ff, 0xc92e,		0x21, 0
	.dw 0xe540, 0xc92e,	0xe57f, 0xc92e,		0x21, 0
	.dw 0xe5c0, 0xc92e,	0xe5ff, 0xc92e,		0x21, 0
	.dw 0xe640, 0xc92e,	0xe67f, 0xc92e,		0x21, 0
	.dw 0xe6c0, 0xc92e,	0xe6ff, 0xc92e,		0x21, 0
	.dw 0xe740, 0xc92e,	0xe77f, 0xc92e,		0x21, 0
	.dw 0xe7c0, 0xc92e,	0xe7ff, 0xc92e,		0x21, 0
	.dw 0xe840, 0xc92e,	0xe87f, 0xc92e,		0x21, 0
	.dw 0xe8c0, 0xc92e,	0xe8ff, 0xc92e,		0x21, 0
	.dw 0xe940, 0xc92e,	0xe97f, 0xc92e,		0x21, 0
	.dw 0xe9c0, 0xc92e,	0xe9ff, 0xc92e,		0x21, 0
	.dw 0xea40, 0xc92e,	0xea7f, 0xc92e,		0x21, 0
	.dw 0xeac0, 0xc92e,	0xeaff, 0xc92e,		0x21, 0
	.dw 0xeb40, 0xc92e,	0xeb7f, 0xc92e,		0x21, 0
	.dw 0xebc0, 0xc92e,	0xebff, 0xc92e,		0x21, 0
	.dw 0xec40, 0xc92e,	0xec7f, 0xc92e,		0x21, 0
	.dw 0xecc0, 0xc92e,	0xecff, 0xc92e,		0x21, 0
	.dw 0xed40, 0xc92e,	0xed7f, 0xc92e,		0x21, 0
	.dw 0xedc0, 0xc92e,	0xedff, 0xc92e,		0x21, 0
	.dw 0xee40, 0xc92e,	0xee7f, 0xc92e,		0x21, 0
	.dw 0xeec0, 0xc92e,	0xeeff, 0xc92e,		0x21, 0
	.dw 0xef40, 0xc92e,	0xef7f, 0xc92e,		0x21, 0
	.dw 0xefc0, 0xc92e,	0xefff, 0xc92e,		0x21, 0
	.dw 0xf040, 0xc92e,	0xf07f, 0xc92e,		0x21, 0
	.dw 0xf0c0, 0xc92e,	0xf0ff, 0xc92e,		0x21, 0
	.dw 0xf140, 0xc92e,	0xf17f, 0xc92e,		0x21, 0
	.dw 0xf1c0, 0xc92e,	0xf1ff, 0xc92e,		0x21, 0
	.dw 0xf240, 0xc92e,	0xf27f, 0xc92e,		0x21, 0
	.dw 0xf2c0, 0xc92e,	0xf2ff, 0xc92e,		0x21, 0
	.dw 0xf340, 0xc92e,	0xf37f, 0xc92e,		0x21, 0
	.dw 0xf3c0, 0xc92e,	0xf3ff, 0xc92e,		0x21, 0
	.dw 0xf440, 0xc92e,	0xf47f, 0xc92e,		0x21, 0
	.dw 0xf4c0, 0xc92e,	0xf4ff, 0xc92e,		0x21, 0
	.dw 0xf540, 0xc92e,	0xf57f, 0xc92e,		0x21, 0
	.dw 0xf5c0, 0xc92e,	0xf5ff, 0xc92e,		0x21, 0
	.dw 0xf640, 0xc92e,	0xf67f, 0xc92e,		0x21, 0
	.dw 0xf6c0, 0xc92e,	0xf6ff, 0xc92e,		0x21, 0
	.dw 0xf740, 0xc92e,	0xf77f, 0xc92e,		0x21, 0
	.dw 0xf7c0, 0xc92e,	0xf7ff, 0xc92e,		0x21, 0
	.dw 0xf840, 0xc92e,	0xf87f, 0xc92e,		0x21, 0
	.dw 0xf8c0, 0xc92e,	0xf8ff, 0xc92e,		0x21, 0
	.dw 0xf940, 0xc92e,	0xf97f, 0xc92e,		0x21, 0
	.dw 0xf9c0, 0xc92e,	0xffff, 0xc92e,		0x21, 0
	.dw 0x0040, 0xc92f,	0x007f, 0xc92f,		0x21, 0
	.dw 0x00c0, 0xc92f,	0x00ff, 0xc92f,		0x21, 0
	.dw 0x0140, 0xc92f,	0x017f, 0xc92f,		0x21, 0
	.dw 0x01c0, 0xc92f,	0x01ff, 0xc92f,		0x21, 0
	.dw 0x0240, 0xc92f,	0x027f, 0xc92f,		0x21, 0
	.dw 0x02c0, 0xc92f,	0x02ff, 0xc92f,		0x21, 0
	.dw 0x0340, 0xc92f,	0x037f, 0xc92f,		0x21, 0
	.dw 0x03c0, 0xc92f,	0x03ff, 0xc92f,		0x21, 0
	.dw 0x0440, 0xc92f,	0x047f, 0xc92f,		0x21, 0
	.dw 0x04c0, 0xc92f,	0x04ff, 0xc92f,		0x21, 0
	.dw 0x0540, 0xc92f,	0x057f, 0xc92f,		0x21, 0
	.dw 0x05c0, 0xc92f,	0x05ff, 0xc92f,		0x21, 0
	.dw 0x0640, 0xc92f,	0x067f, 0xc92f,		0x21, 0
	.dw 0x06c0, 0xc92f,	0x06ff, 0xc92f,		0x21, 0
	.dw 0x0740, 0xc92f,	0x077f, 0xc92f,		0x21, 0
	.dw 0x07c0, 0xc92f,	0x07ff, 0xc92f,		0x21, 0
	.dw 0x0840, 0xc92f,	0x087f, 0xc92f,		0x21, 0
	.dw 0x08c0, 0xc92f,	0x08ff, 0xc92f,		0x21, 0
	.dw 0x0940, 0xc92f,	0x097f, 0xc92f,		0x21, 0
	.dw 0x09c0, 0xc92f,	0x09ff, 0xc92f,		0x21, 0
	.dw 0x0a40, 0xc92f,	0x0a7f, 0xc92f,		0x21, 0
	.dw 0x0ac0, 0xc92f,	0x0aff, 0xc92f,		0x21, 0
	.dw 0x0b40, 0xc92f,	0x0b7f, 0xc92f,		0x21, 0
	.dw 0x0bc0, 0xc92f,	0x0bff, 0xc92f,		0x21, 0
	.dw 0x0c40, 0xc92f,	0x0c7f, 0xc92f,		0x21, 0
	.dw 0x0cc0, 0xc92f,	0x0cff, 0xc92f,		0x21, 0
	.dw 0x0d40, 0xc92f,	0x0d7f, 0xc92f,		0x21, 0
	.dw 0x0dc0, 0xc92f,	0x0dff, 0xc92f,		0x21, 0
	.dw 0x0e40, 0xc92f,	0x0e7f, 0xc92f,		0x21, 0
	.dw 0x0ec0, 0xc92f,	0x0eff, 0xc92f,		0x21, 0
	.dw 0x0f40, 0xc92f,	0x0f7f, 0xc92f,		0x21, 0
	.dw 0x0fc0, 0xc92f,	0x0fff, 0xc92f,		0x21, 0
	.dw 0x1040, 0xc92f,	0x107f, 0xc92f,		0x21, 0
	.dw 0x10c0, 0xc92f,	0x10ff, 0xc92f,		0x21, 0
	.dw 0x1140, 0xc92f,	0x117f, 0xc92f,		0x21, 0
	.dw 0x11c0, 0xc92f,	0x11ff, 0xc92f,		0x21, 0
	.dw 0x1240, 0xc92f,	0x127f, 0xc92f,		0x21, 0
	.dw 0x12c0, 0xc92f,	0x12ff, 0xc92f,		0x21, 0
	.dw 0x1340, 0xc92f,	0x137f, 0xc92f,		0x21, 0
	.dw 0x13c0, 0xc92f,	0x13ff, 0xc92f,		0x21, 0
	.dw 0x1440, 0xc92f,	0x147f, 0xc92f,		0x21, 0
	.dw 0x14c0, 0xc92f,	0x14ff, 0xc92f,		0x21, 0
	.dw 0x1540, 0xc92f,	0x157f, 0xc92f,		0x21, 0
	.dw 0x15c0, 0xc92f,	0x15ff, 0xc92f,		0x21, 0
	.dw 0x1640, 0xc92f,	0x167f, 0xc92f,		0x21, 0
	.dw 0x16c0, 0xc92f,	0x16ff, 0xc92f,		0x21, 0
	.dw 0x1740, 0xc92f,	0x177f, 0xc92f,		0x21, 0
	.dw 0x17c0, 0xc92f,	0x17ff, 0xc92f,		0x21, 0
	.dw 0x1840, 0xc92f,	0x187f, 0xc92f,		0x21, 0
	.dw 0x18c0, 0xc92f,	0x18ff, 0xc92f,		0x21, 0
	.dw 0x1940, 0xc92f,	0x197f, 0xc92f,		0x21, 0
	.dw 0x19c0, 0xc92f,	0x1fff, 0xc92f,		0x21, 0
	.dw 0x2040, 0xc92f,	0x207f, 0xc92f,		0x21, 0
	.dw 0x20c0, 0xc92f,	0x20ff, 0xc92f,		0x21, 0
	.dw 0x2140, 0xc92f,	0x217f, 0xc92f,		0x21, 0
	.dw 0x21c0, 0xc92f,	0x21ff, 0xc92f,		0x21, 0
	.dw 0x2240, 0xc92f,	0x227f, 0xc92f,		0x21, 0
	.dw 0x22c0, 0xc92f,	0x22ff, 0xc92f,		0x21, 0
	.dw 0x2340, 0xc92f,	0x237f, 0xc92f,		0x21, 0
	.dw 0x23c0, 0xc92f,	0x23ff, 0xc92f,		0x21, 0
	.dw 0x2440, 0xc92f,	0x247f, 0xc92f,		0x21, 0
	.dw 0x24c0, 0xc92f,	0x24ff, 0xc92f,		0x21, 0
	.dw 0x2540, 0xc92f,	0x257f, 0xc92f,		0x21, 0
	.dw 0x25c0, 0xc92f,	0x25ff, 0xc92f,		0x21, 0
	.dw 0x2640, 0xc92f,	0x267f, 0xc92f,		0x21, 0
	.dw 0x26c0, 0xc92f,	0x26ff, 0xc92f,		0x21, 0
	.dw 0x2740, 0xc92f,	0x277f, 0xc92f,		0x21, 0
	.dw 0x27c0, 0xc92f,	0x27ff, 0xc92f,		0x21, 0
	.dw 0x2840, 0xc92f,	0x287f, 0xc92f,		0x21, 0
	.dw 0x28c0, 0xc92f,	0x28ff, 0xc92f,		0x21, 0
	.dw 0x2940, 0xc92f,	0x297f, 0xc92f,		0x21, 0
	.dw 0x29c0, 0xc92f,	0x29ff, 0xc92f,		0x21, 0
	.dw 0x2a40, 0xc92f,	0x2a7f, 0xc92f,		0x21, 0
	.dw 0x2ac0, 0xc92f,	0x2aff, 0xc92f,		0x21, 0
	.dw 0x2b40, 0xc92f,	0x2b7f, 0xc92f,		0x21, 0
	.dw 0x2bc0, 0xc92f,	0x2bff, 0xc92f,		0x21, 0
	.dw 0x2c40, 0xc92f,	0x2c7f, 0xc92f,		0x21, 0
	.dw 0x2cc0, 0xc92f,	0x2cff, 0xc92f,		0x21, 0
	.dw 0x2d40, 0xc92f,	0x2d7f, 0xc92f,		0x21, 0
	.dw 0x2dc0, 0xc92f,	0x2dff, 0xc92f,		0x21, 0
	.dw 0x2e40, 0xc92f,	0x2e7f, 0xc92f,		0x21, 0
	.dw 0x2ec0, 0xc92f,	0x2eff, 0xc92f,		0x21, 0
	.dw 0x2f40, 0xc92f,	0x2f7f, 0xc92f,		0x21, 0
	.dw 0x2fc0, 0xc92f,	0x2fff, 0xc92f,		0x21, 0
	.dw 0x3040, 0xc92f,	0x307f, 0xc92f,		0x21, 0
	.dw 0x30c0, 0xc92f,	0x30ff, 0xc92f,		0x21, 0
	.dw 0x3140, 0xc92f,	0x317f, 0xc92f,		0x21, 0
	.dw 0x31c0, 0xc92f,	0x31ff, 0xc92f,		0x21, 0
	.dw 0x3240, 0xc92f,	0x327f, 0xc92f,		0x21, 0
	.dw 0x32c0, 0xc92f,	0x32ff, 0xc92f,		0x21, 0
	.dw 0x3340, 0xc92f,	0x337f, 0xc92f,		0x21, 0
	.dw 0x33c0, 0xc92f,	0x33ff, 0xc92f,		0x21, 0
	.dw 0x3440, 0xc92f,	0x347f, 0xc92f,		0x21, 0
	.dw 0x34c0, 0xc92f,	0x34ff, 0xc92f,		0x21, 0
	.dw 0x3540, 0xc92f,	0x357f, 0xc92f,		0x21, 0
	.dw 0x35c0, 0xc92f,	0x35ff, 0xc92f,		0x21, 0
	.dw 0x3640, 0xc92f,	0x367f, 0xc92f,		0x21, 0
	.dw 0x36c0, 0xc92f,	0x36ff, 0xc92f,		0x21, 0
	.dw 0x3740, 0xc92f,	0x377f, 0xc92f,		0x21, 0
	.dw 0x37c0, 0xc92f,	0x37ff, 0xc92f,		0x21, 0
	.dw 0x3840, 0xc92f,	0x387f, 0xc92f,		0x21, 0
	.dw 0x38c0, 0xc92f,	0x38ff, 0xc92f,		0x21, 0
	.dw 0x3940, 0xc92f,	0x397f, 0xc92f,		0x21, 0
	.dw 0x39c0, 0xc92f,	0x1fff, 0xc930,		0x21, 0
	.dw 0x3a00, 0xc930,	0x5fff, 0xc930,		0x21, 0
	.dw 0x7a00, 0xc930,	0x9fff, 0xc930,		0x21, 0
	.dw 0xba00, 0xc930,	0xdfff, 0xc930,		0x21, 0
	.dw 0xfa00, 0xc930,	0x1fff, 0xc931,		0x21, 0
	.dw 0x3a00, 0xc931,	0x5fff, 0xc931,		0x21, 0
	.dw 0x7a00, 0xc931,	0x9fff, 0xc931,		0x21, 0
	.dw 0xba00, 0xc931,	0xdfff, 0xc931,		0x21, 0
	.dw 0xfa00, 0xc931,	0x1fff, 0xc932,		0x21, 0
	.dw 0x3a00, 0xc932,	0x5fff, 0xc932,		0x21, 0
	.dw 0x7a00, 0xc932,	0x9fff, 0xc932,		0x21, 0
	.dw 0xba00, 0xc932,	0xdfff, 0xc932,		0x21, 0
	.dw 0xfa00, 0xc932,	0xffff, 0xc933,		0x21, 0
	.dw 0x1a00, 0xc934,	0x1fff, 0xc934,		0x21, 0
	.dw 0x3a00, 0xc934,	0x3fff, 0xc934,		0x21, 0
	.dw 0x5a00, 0xc934,	0x5fff, 0xc934,		0x21, 0
	.dw 0x7a00, 0xc934,	0x7fff, 0xc934,		0x21, 0
	.dw 0x9a00, 0xc934,	0x9fff, 0xc934,		0x21, 0
	.dw 0xba00, 0xc934,	0xbfff, 0xc934,		0x21, 0
	.dw 0xda00, 0xc934,	0xdfff, 0xc934,		0x21, 0
	.dw 0xfa00, 0xc934,	0xffff, 0xc934,		0x21, 0
	.dw 0x1a00, 0xc935,	0x1fff, 0xc935,		0x21, 0
	.dw 0x3a00, 0xc935,	0x3fff, 0xc935,		0x21, 0
	.dw 0x5a00, 0xc935,	0x5fff, 0xc935,		0x21, 0
	.dw 0x7a00, 0xc935,	0x7fff, 0xc935,		0x21, 0
	.dw 0x9a00, 0xc935,	0x9fff, 0xc935,		0x21, 0
	.dw 0xba00, 0xc935,	0xbfff, 0xc935,		0x21, 0
	.dw 0xda00, 0xc935,	0xdfff, 0xc935,		0x21, 0
	.dw 0xfa00, 0xc935,	0xffff, 0xc935,		0x21, 0
	.dw 0x1a00, 0xc936,	0x1fff, 0xc936,		0x21, 0
	.dw 0x3a00, 0xc936,	0x3fff, 0xc936,		0x21, 0
	.dw 0x5a00, 0xc936,	0x5fff, 0xc936,		0x21, 0
	.dw 0x7a00, 0xc936,	0x7fff, 0xc936,		0x21, 0
	.dw 0x9a00, 0xc936,	0x9fff, 0xc936,		0x21, 0
	.dw 0xba00, 0xc936,	0xbfff, 0xc936,		0x21, 0
	.dw 0xda00, 0xc936,	0xdfff, 0xc936,		0x21, 0
	.dw 0xfa00, 0xc936,	0xffff, 0xc936,		0x21, 0
	.dw 0x1a00, 0xc937,	0x1fff, 0xc937,		0x21, 0
	.dw 0x3a00, 0xc937,	0x1fff, 0xc938,		0x21, 0
	.dw 0x2040, 0xc938,	0x207f, 0xc938,		0x21, 0
	.dw 0x20c0, 0xc938,	0x20ff, 0xc938,		0x21, 0
	.dw 0x2140, 0xc938,	0x217f, 0xc938,		0x21, 0
	.dw 0x21c0, 0xc938,	0x21ff, 0xc938,		0x21, 0
	.dw 0x2240, 0xc938,	0x227f, 0xc938,		0x21, 0
	.dw 0x22c0, 0xc938,	0x22ff, 0xc938,		0x21, 0
	.dw 0x2340, 0xc938,	0x237f, 0xc938,		0x21, 0
	.dw 0x23c0, 0xc938,	0x23ff, 0xc938,		0x21, 0
	.dw 0x2440, 0xc938,	0x247f, 0xc938,		0x21, 0
	.dw 0x24c0, 0xc938,	0x24ff, 0xc938,		0x21, 0
	.dw 0x2540, 0xc938,	0x257f, 0xc938,		0x21, 0
	.dw 0x25c0, 0xc938,	0x25ff, 0xc938,		0x21, 0
	.dw 0x2640, 0xc938,	0x267f, 0xc938,		0x21, 0
	.dw 0x26c0, 0xc938,	0x26ff, 0xc938,		0x21, 0
	.dw 0x2740, 0xc938,	0x277f, 0xc938,		0x21, 0
	.dw 0x27c0, 0xc938,	0x27ff, 0xc938,		0x21, 0
	.dw 0x2840, 0xc938,	0x287f, 0xc938,		0x21, 0
	.dw 0x28c0, 0xc938,	0x28ff, 0xc938,		0x21, 0
	.dw 0x2940, 0xc938,	0x297f, 0xc938,		0x21, 0
	.dw 0x29c0, 0xc938,	0x29ff, 0xc938,		0x21, 0
	.dw 0x2a40, 0xc938,	0x2a7f, 0xc938,		0x21, 0
	.dw 0x2ac0, 0xc938,	0x2aff, 0xc938,		0x21, 0
	.dw 0x2b40, 0xc938,	0x2b7f, 0xc938,		0x21, 0
	.dw 0x2bc0, 0xc938,	0x2bff, 0xc938,		0x21, 0
	.dw 0x2c40, 0xc938,	0x2c7f, 0xc938,		0x21, 0
	.dw 0x2cc0, 0xc938,	0x2cff, 0xc938,		0x21, 0
	.dw 0x2d40, 0xc938,	0x2d7f, 0xc938,		0x21, 0
	.dw 0x2dc0, 0xc938,	0x2dff, 0xc938,		0x21, 0
	.dw 0x2e40, 0xc938,	0x2e7f, 0xc938,		0x21, 0
	.dw 0x2ec0, 0xc938,	0x2eff, 0xc938,		0x21, 0
	.dw 0x2f40, 0xc938,	0x2f7f, 0xc938,		0x21, 0
	.dw 0x2fc0, 0xc938,	0x2fff, 0xc938,		0x21, 0
	.dw 0x3040, 0xc938,	0x307f, 0xc938,		0x21, 0
	.dw 0x30c0, 0xc938,	0x30ff, 0xc938,		0x21, 0
	.dw 0x3140, 0xc938,	0x317f, 0xc938,		0x21, 0
	.dw 0x31c0, 0xc938,	0x31ff, 0xc938,		0x21, 0
	.dw 0x3240, 0xc938,	0x327f, 0xc938,		0x21, 0
	.dw 0x32c0, 0xc938,	0x32ff, 0xc938,		0x21, 0
	.dw 0x3340, 0xc938,	0x337f, 0xc938,		0x21, 0
	.dw 0x33c0, 0xc938,	0x33ff, 0xc938,		0x21, 0
	.dw 0x3440, 0xc938,	0x347f, 0xc938,		0x21, 0
	.dw 0x34c0, 0xc938,	0x34ff, 0xc938,		0x21, 0
	.dw 0x3540, 0xc938,	0x357f, 0xc938,		0x21, 0
	.dw 0x35c0, 0xc938,	0x35ff, 0xc938,		0x21, 0
	.dw 0x3640, 0xc938,	0x367f, 0xc938,		0x21, 0
	.dw 0x36c0, 0xc938,	0x36ff, 0xc938,		0x21, 0
	.dw 0x3740, 0xc938,	0x377f, 0xc938,		0x21, 0
	.dw 0x37c0, 0xc938,	0x37ff, 0xc938,		0x21, 0
	.dw 0x3840, 0xc938,	0x387f, 0xc938,		0x21, 0
	.dw 0x38c0, 0xc938,	0x38ff, 0xc938,		0x21, 0
	.dw 0x3940, 0xc938,	0x397f, 0xc938,		0x21, 0
	.dw 0x39c0, 0xc938,	0x5fff, 0xc938,		0x21, 0
	.dw 0x6040, 0xc938,	0x607f, 0xc938,		0x21, 0
	.dw 0x60c0, 0xc938,	0x60ff, 0xc938,		0x21, 0
	.dw 0x6140, 0xc938,	0x617f, 0xc938,		0x21, 0
	.dw 0x61c0, 0xc938,	0x61ff, 0xc938,		0x21, 0
	.dw 0x6240, 0xc938,	0x627f, 0xc938,		0x21, 0
	.dw 0x62c0, 0xc938,	0x62ff, 0xc938,		0x21, 0
	.dw 0x6340, 0xc938,	0x637f, 0xc938,		0x21, 0
	.dw 0x63c0, 0xc938,	0x63ff, 0xc938,		0x21, 0
	.dw 0x6440, 0xc938,	0x647f, 0xc938,		0x21, 0
	.dw 0x64c0, 0xc938,	0x64ff, 0xc938,		0x21, 0
	.dw 0x6540, 0xc938,	0x657f, 0xc938,		0x21, 0
	.dw 0x65c0, 0xc938,	0x65ff, 0xc938,		0x21, 0
	.dw 0x6640, 0xc938,	0x667f, 0xc938,		0x21, 0
	.dw 0x66c0, 0xc938,	0x66ff, 0xc938,		0x21, 0
	.dw 0x6740, 0xc938,	0x677f, 0xc938,		0x21, 0
	.dw 0x67c0, 0xc938,	0x67ff, 0xc938,		0x21, 0
	.dw 0x6840, 0xc938,	0x687f, 0xc938,		0x21, 0
	.dw 0x68c0, 0xc938,	0x68ff, 0xc938,		0x21, 0
	.dw 0x6940, 0xc938,	0x697f, 0xc938,		0x21, 0
	.dw 0x69c0, 0xc938,	0x69ff, 0xc938,		0x21, 0
	.dw 0x6a40, 0xc938,	0x6a7f, 0xc938,		0x21, 0
	.dw 0x6ac0, 0xc938,	0x6aff, 0xc938,		0x21, 0
	.dw 0x6b40, 0xc938,	0x6b7f, 0xc938,		0x21, 0
	.dw 0x6bc0, 0xc938,	0x6bff, 0xc938,		0x21, 0
	.dw 0x6c40, 0xc938,	0x6c7f, 0xc938,		0x21, 0
	.dw 0x6cc0, 0xc938,	0x6cff, 0xc938,		0x21, 0
	.dw 0x6d40, 0xc938,	0x6d7f, 0xc938,		0x21, 0
	.dw 0x6dc0, 0xc938,	0x6dff, 0xc938,		0x21, 0
	.dw 0x6e40, 0xc938,	0x6e7f, 0xc938,		0x21, 0
	.dw 0x6ec0, 0xc938,	0x6eff, 0xc938,		0x21, 0
	.dw 0x6f40, 0xc938,	0x6f7f, 0xc938,		0x21, 0
	.dw 0x6fc0, 0xc938,	0x6fff, 0xc938,		0x21, 0
	.dw 0x7040, 0xc938,	0x707f, 0xc938,		0x21, 0
	.dw 0x70c0, 0xc938,	0x70ff, 0xc938,		0x21, 0
	.dw 0x7140, 0xc938,	0x717f, 0xc938,		0x21, 0
	.dw 0x71c0, 0xc938,	0x71ff, 0xc938,		0x21, 0
	.dw 0x7240, 0xc938,	0x727f, 0xc938,		0x21, 0
	.dw 0x72c0, 0xc938,	0x72ff, 0xc938,		0x21, 0
	.dw 0x7340, 0xc938,	0x737f, 0xc938,		0x21, 0
	.dw 0x73c0, 0xc938,	0x73ff, 0xc938,		0x21, 0
	.dw 0x7440, 0xc938,	0x747f, 0xc938,		0x21, 0
	.dw 0x74c0, 0xc938,	0x74ff, 0xc938,		0x21, 0
	.dw 0x7540, 0xc938,	0x757f, 0xc938,		0x21, 0
	.dw 0x75c0, 0xc938,	0x75ff, 0xc938,		0x21, 0
	.dw 0x7640, 0xc938,	0x767f, 0xc938,		0x21, 0
	.dw 0x76c0, 0xc938,	0x76ff, 0xc938,		0x21, 0
	.dw 0x7740, 0xc938,	0x777f, 0xc938,		0x21, 0
	.dw 0x77c0, 0xc938,	0x77ff, 0xc938,		0x21, 0
	.dw 0x7840, 0xc938,	0x787f, 0xc938,		0x21, 0
	.dw 0x78c0, 0xc938,	0x78ff, 0xc938,		0x21, 0
	.dw 0x7940, 0xc938,	0x797f, 0xc938,		0x21, 0
	.dw 0x79c0, 0xc938,	0x9fff, 0xc938,		0x21, 0
	.dw 0xa040, 0xc938,	0xa07f, 0xc938,		0x21, 0
	.dw 0xa0c0, 0xc938,	0xa0ff, 0xc938,		0x21, 0
	.dw 0xa140, 0xc938,	0xa17f, 0xc938,		0x21, 0
	.dw 0xa1c0, 0xc938,	0xa1ff, 0xc938,		0x21, 0
	.dw 0xa240, 0xc938,	0xa27f, 0xc938,		0x21, 0
	.dw 0xa2c0, 0xc938,	0xa2ff, 0xc938,		0x21, 0
	.dw 0xa340, 0xc938,	0xa37f, 0xc938,		0x21, 0
	.dw 0xa3c0, 0xc938,	0xa3ff, 0xc938,		0x21, 0
	.dw 0xa440, 0xc938,	0xa47f, 0xc938,		0x21, 0
	.dw 0xa4c0, 0xc938,	0xa4ff, 0xc938,		0x21, 0
	.dw 0xa540, 0xc938,	0xa57f, 0xc938,		0x21, 0
	.dw 0xa5c0, 0xc938,	0xa5ff, 0xc938,		0x21, 0
	.dw 0xa640, 0xc938,	0xa67f, 0xc938,		0x21, 0
	.dw 0xa6c0, 0xc938,	0xa6ff, 0xc938,		0x21, 0
	.dw 0xa740, 0xc938,	0xa77f, 0xc938,		0x21, 0
	.dw 0xa7c0, 0xc938,	0xa7ff, 0xc938,		0x21, 0
	.dw 0xa840, 0xc938,	0xa87f, 0xc938,		0x21, 0
	.dw 0xa8c0, 0xc938,	0xa8ff, 0xc938,		0x21, 0
	.dw 0xa940, 0xc938,	0xa97f, 0xc938,		0x21, 0
	.dw 0xa9c0, 0xc938,	0xa9ff, 0xc938,		0x21, 0
	.dw 0xaa40, 0xc938,	0xaa7f, 0xc938,		0x21, 0
	.dw 0xaac0, 0xc938,	0xaaff, 0xc938,		0x21, 0
	.dw 0xab40, 0xc938,	0xab7f, 0xc938,		0x21, 0
	.dw 0xabc0, 0xc938,	0xabff, 0xc938,		0x21, 0
	.dw 0xac40, 0xc938,	0xac7f, 0xc938,		0x21, 0
	.dw 0xacc0, 0xc938,	0xacff, 0xc938,		0x21, 0
	.dw 0xad40, 0xc938,	0xad7f, 0xc938,		0x21, 0
	.dw 0xadc0, 0xc938,	0xadff, 0xc938,		0x21, 0
	.dw 0xae40, 0xc938,	0xae7f, 0xc938,		0x21, 0
	.dw 0xaec0, 0xc938,	0xaeff, 0xc938,		0x21, 0
	.dw 0xaf40, 0xc938,	0xaf7f, 0xc938,		0x21, 0
	.dw 0xafc0, 0xc938,	0xafff, 0xc938,		0x21, 0
	.dw 0xb040, 0xc938,	0xb07f, 0xc938,		0x21, 0
	.dw 0xb0c0, 0xc938,	0xb0ff, 0xc938,		0x21, 0
	.dw 0xb140, 0xc938,	0xb17f, 0xc938,		0x21, 0
	.dw 0xb1c0, 0xc938,	0xb1ff, 0xc938,		0x21, 0
	.dw 0xb240, 0xc938,	0xb27f, 0xc938,		0x21, 0
	.dw 0xb2c0, 0xc938,	0xb2ff, 0xc938,		0x21, 0
	.dw 0xb340, 0xc938,	0xb37f, 0xc938,		0x21, 0
	.dw 0xb3c0, 0xc938,	0xb3ff, 0xc938,		0x21, 0
	.dw 0xb440, 0xc938,	0xb47f, 0xc938,		0x21, 0
	.dw 0xb4c0, 0xc938,	0xb4ff, 0xc938,		0x21, 0
	.dw 0xb540, 0xc938,	0xb57f, 0xc938,		0x21, 0
	.dw 0xb5c0, 0xc938,	0xb5ff, 0xc938,		0x21, 0
	.dw 0xb640, 0xc938,	0xb67f, 0xc938,		0x21, 0
	.dw 0xb6c0, 0xc938,	0xb6ff, 0xc938,		0x21, 0
	.dw 0xb740, 0xc938,	0xb77f, 0xc938,		0x21, 0
	.dw 0xb7c0, 0xc938,	0xb7ff, 0xc938,		0x21, 0
	.dw 0xb840, 0xc938,	0xb87f, 0xc938,		0x21, 0
	.dw 0xb8c0, 0xc938,	0xb8ff, 0xc938,		0x21, 0
	.dw 0xb940, 0xc938,	0xb97f, 0xc938,		0x21, 0
	.dw 0xb9c0, 0xc938,	0xdfff, 0xc938,		0x21, 0
	.dw 0xe040, 0xc938,	0xe07f, 0xc938,		0x21, 0
	.dw 0xe0c0, 0xc938,	0xe0ff, 0xc938,		0x21, 0
	.dw 0xe140, 0xc938,	0xe17f, 0xc938,		0x21, 0
	.dw 0xe1c0, 0xc938,	0xe1ff, 0xc938,		0x21, 0
	.dw 0xe240, 0xc938,	0xe27f, 0xc938,		0x21, 0
	.dw 0xe2c0, 0xc938,	0xe2ff, 0xc938,		0x21, 0
	.dw 0xe340, 0xc938,	0xe37f, 0xc938,		0x21, 0
	.dw 0xe3c0, 0xc938,	0xe3ff, 0xc938,		0x21, 0
	.dw 0xe440, 0xc938,	0xe47f, 0xc938,		0x21, 0
	.dw 0xe4c0, 0xc938,	0xe4ff, 0xc938,		0x21, 0
	.dw 0xe540, 0xc938,	0xe57f, 0xc938,		0x21, 0
	.dw 0xe5c0, 0xc938,	0xe5ff, 0xc938,		0x21, 0
	.dw 0xe640, 0xc938,	0xe67f, 0xc938,		0x21, 0
	.dw 0xe6c0, 0xc938,	0xe6ff, 0xc938,		0x21, 0
	.dw 0xe740, 0xc938,	0xe77f, 0xc938,		0x21, 0
	.dw 0xe7c0, 0xc938,	0xe7ff, 0xc938,		0x21, 0
	.dw 0xe840, 0xc938,	0xe87f, 0xc938,		0x21, 0
	.dw 0xe8c0, 0xc938,	0xe8ff, 0xc938,		0x21, 0
	.dw 0xe940, 0xc938,	0xe97f, 0xc938,		0x21, 0
	.dw 0xe9c0, 0xc938,	0xe9ff, 0xc938,		0x21, 0
	.dw 0xea40, 0xc938,	0xea7f, 0xc938,		0x21, 0
	.dw 0xeac0, 0xc938,	0xeaff, 0xc938,		0x21, 0
	.dw 0xeb40, 0xc938,	0xeb7f, 0xc938,		0x21, 0
	.dw 0xebc0, 0xc938,	0xebff, 0xc938,		0x21, 0
	.dw 0xec40, 0xc938,	0xec7f, 0xc938,		0x21, 0
	.dw 0xecc0, 0xc938,	0xecff, 0xc938,		0x21, 0
	.dw 0xed40, 0xc938,	0xed7f, 0xc938,		0x21, 0
	.dw 0xedc0, 0xc938,	0xedff, 0xc938,		0x21, 0
	.dw 0xee40, 0xc938,	0xee7f, 0xc938,		0x21, 0
	.dw 0xeec0, 0xc938,	0xeeff, 0xc938,		0x21, 0
	.dw 0xef40, 0xc938,	0xef7f, 0xc938,		0x21, 0
	.dw 0xefc0, 0xc938,	0xefff, 0xc938,		0x21, 0
	.dw 0xf040, 0xc938,	0xf07f, 0xc938,		0x21, 0
	.dw 0xf0c0, 0xc938,	0xf0ff, 0xc938,		0x21, 0
	.dw 0xf140, 0xc938,	0xf17f, 0xc938,		0x21, 0
	.dw 0xf1c0, 0xc938,	0xf1ff, 0xc938,		0x21, 0
	.dw 0xf240, 0xc938,	0xf27f, 0xc938,		0x21, 0
	.dw 0xf2c0, 0xc938,	0xf2ff, 0xc938,		0x21, 0
	.dw 0xf340, 0xc938,	0xf37f, 0xc938,		0x21, 0
	.dw 0xf3c0, 0xc938,	0xf3ff, 0xc938,		0x21, 0
	.dw 0xf440, 0xc938,	0xf47f, 0xc938,		0x21, 0
	.dw 0xf4c0, 0xc938,	0xf4ff, 0xc938,		0x21, 0
	.dw 0xf540, 0xc938,	0xf57f, 0xc938,		0x21, 0
	.dw 0xf5c0, 0xc938,	0xf5ff, 0xc938,		0x21, 0
	.dw 0xf640, 0xc938,	0xf67f, 0xc938,		0x21, 0
	.dw 0xf6c0, 0xc938,	0xf6ff, 0xc938,		0x21, 0
	.dw 0xf740, 0xc938,	0xf77f, 0xc938,		0x21, 0
	.dw 0xf7c0, 0xc938,	0xf7ff, 0xc938,		0x21, 0
	.dw 0xf840, 0xc938,	0xf87f, 0xc938,		0x21, 0
	.dw 0xf8c0, 0xc938,	0xf8ff, 0xc938,		0x21, 0
	.dw 0xf940, 0xc938,	0xf97f, 0xc938,		0x21, 0
	.dw 0xf9c0, 0xc938,	0x1fff, 0xc939,		0x21, 0
	.dw 0x2040, 0xc939,	0x207f, 0xc939,		0x21, 0
	.dw 0x20c0, 0xc939,	0x20ff, 0xc939,		0x21, 0
	.dw 0x2140, 0xc939,	0x217f, 0xc939,		0x21, 0
	.dw 0x21c0, 0xc939,	0x21ff, 0xc939,		0x21, 0
	.dw 0x2240, 0xc939,	0x227f, 0xc939,		0x21, 0
	.dw 0x22c0, 0xc939,	0x22ff, 0xc939,		0x21, 0
	.dw 0x2340, 0xc939,	0x237f, 0xc939,		0x21, 0
	.dw 0x23c0, 0xc939,	0x23ff, 0xc939,		0x21, 0
	.dw 0x2440, 0xc939,	0x247f, 0xc939,		0x21, 0
	.dw 0x24c0, 0xc939,	0x24ff, 0xc939,		0x21, 0
	.dw 0x2540, 0xc939,	0x257f, 0xc939,		0x21, 0
	.dw 0x25c0, 0xc939,	0x25ff, 0xc939,		0x21, 0
	.dw 0x2640, 0xc939,	0x267f, 0xc939,		0x21, 0
	.dw 0x26c0, 0xc939,	0x26ff, 0xc939,		0x21, 0
	.dw 0x2740, 0xc939,	0x277f, 0xc939,		0x21, 0
	.dw 0x27c0, 0xc939,	0x27ff, 0xc939,		0x21, 0
	.dw 0x2840, 0xc939,	0x287f, 0xc939,		0x21, 0
	.dw 0x28c0, 0xc939,	0x28ff, 0xc939,		0x21, 0
	.dw 0x2940, 0xc939,	0x297f, 0xc939,		0x21, 0
	.dw 0x29c0, 0xc939,	0x29ff, 0xc939,		0x21, 0
	.dw 0x2a40, 0xc939,	0x2a7f, 0xc939,		0x21, 0
	.dw 0x2ac0, 0xc939,	0x2aff, 0xc939,		0x21, 0
	.dw 0x2b40, 0xc939,	0x2b7f, 0xc939,		0x21, 0
	.dw 0x2bc0, 0xc939,	0x2bff, 0xc939,		0x21, 0
	.dw 0x2c40, 0xc939,	0x2c7f, 0xc939,		0x21, 0
	.dw 0x2cc0, 0xc939,	0x2cff, 0xc939,		0x21, 0
	.dw 0x2d40, 0xc939,	0x2d7f, 0xc939,		0x21, 0
	.dw 0x2dc0, 0xc939,	0x2dff, 0xc939,		0x21, 0
	.dw 0x2e40, 0xc939,	0x2e7f, 0xc939,		0x21, 0
	.dw 0x2ec0, 0xc939,	0x2eff, 0xc939,		0x21, 0
	.dw 0x2f40, 0xc939,	0x2f7f, 0xc939,		0x21, 0
	.dw 0x2fc0, 0xc939,	0x2fff, 0xc939,		0x21, 0
	.dw 0x3040, 0xc939,	0x307f, 0xc939,		0x21, 0
	.dw 0x30c0, 0xc939,	0x30ff, 0xc939,		0x21, 0
	.dw 0x3140, 0xc939,	0x317f, 0xc939,		0x21, 0
	.dw 0x31c0, 0xc939,	0x31ff, 0xc939,		0x21, 0
	.dw 0x3240, 0xc939,	0x327f, 0xc939,		0x21, 0
	.dw 0x32c0, 0xc939,	0x32ff, 0xc939,		0x21, 0
	.dw 0x3340, 0xc939,	0x337f, 0xc939,		0x21, 0
	.dw 0x33c0, 0xc939,	0x33ff, 0xc939,		0x21, 0
	.dw 0x3440, 0xc939,	0x347f, 0xc939,		0x21, 0
	.dw 0x34c0, 0xc939,	0x34ff, 0xc939,		0x21, 0
	.dw 0x3540, 0xc939,	0x357f, 0xc939,		0x21, 0
	.dw 0x35c0, 0xc939,	0x35ff, 0xc939,		0x21, 0
	.dw 0x3640, 0xc939,	0x367f, 0xc939,		0x21, 0
	.dw 0x36c0, 0xc939,	0x36ff, 0xc939,		0x21, 0
	.dw 0x3740, 0xc939,	0x377f, 0xc939,		0x21, 0
	.dw 0x37c0, 0xc939,	0x37ff, 0xc939,		0x21, 0
	.dw 0x3840, 0xc939,	0x387f, 0xc939,		0x21, 0
	.dw 0x38c0, 0xc939,	0x38ff, 0xc939,		0x21, 0
	.dw 0x3940, 0xc939,	0x397f, 0xc939,		0x21, 0
	.dw 0x39c0, 0xc939,	0x5fff, 0xc939,		0x21, 0
	.dw 0x6040, 0xc939,	0x607f, 0xc939,		0x21, 0
	.dw 0x60c0, 0xc939,	0x60ff, 0xc939,		0x21, 0
	.dw 0x6140, 0xc939,	0x617f, 0xc939,		0x21, 0
	.dw 0x61c0, 0xc939,	0x61ff, 0xc939,		0x21, 0
	.dw 0x6240, 0xc939,	0x627f, 0xc939,		0x21, 0
	.dw 0x62c0, 0xc939,	0x62ff, 0xc939,		0x21, 0
	.dw 0x6340, 0xc939,	0x637f, 0xc939,		0x21, 0
	.dw 0x63c0, 0xc939,	0x63ff, 0xc939,		0x21, 0
	.dw 0x6440, 0xc939,	0x647f, 0xc939,		0x21, 0
	.dw 0x64c0, 0xc939,	0x64ff, 0xc939,		0x21, 0
	.dw 0x6540, 0xc939,	0x657f, 0xc939,		0x21, 0
	.dw 0x65c0, 0xc939,	0x65ff, 0xc939,		0x21, 0
	.dw 0x6640, 0xc939,	0x667f, 0xc939,		0x21, 0
	.dw 0x66c0, 0xc939,	0x66ff, 0xc939,		0x21, 0
	.dw 0x6740, 0xc939,	0x677f, 0xc939,		0x21, 0
	.dw 0x67c0, 0xc939,	0x67ff, 0xc939,		0x21, 0
	.dw 0x6840, 0xc939,	0x687f, 0xc939,		0x21, 0
	.dw 0x68c0, 0xc939,	0x68ff, 0xc939,		0x21, 0
	.dw 0x6940, 0xc939,	0x697f, 0xc939,		0x21, 0
	.dw 0x69c0, 0xc939,	0x69ff, 0xc939,		0x21, 0
	.dw 0x6a40, 0xc939,	0x6a7f, 0xc939,		0x21, 0
	.dw 0x6ac0, 0xc939,	0x6aff, 0xc939,		0x21, 0
	.dw 0x6b40, 0xc939,	0x6b7f, 0xc939,		0x21, 0
	.dw 0x6bc0, 0xc939,	0x6bff, 0xc939,		0x21, 0
	.dw 0x6c40, 0xc939,	0x6c7f, 0xc939,		0x21, 0
	.dw 0x6cc0, 0xc939,	0x6cff, 0xc939,		0x21, 0
	.dw 0x6d40, 0xc939,	0x6d7f, 0xc939,		0x21, 0
	.dw 0x6dc0, 0xc939,	0x6dff, 0xc939,		0x21, 0
	.dw 0x6e40, 0xc939,	0x6e7f, 0xc939,		0x21, 0
	.dw 0x6ec0, 0xc939,	0x6eff, 0xc939,		0x21, 0
	.dw 0x6f40, 0xc939,	0x6f7f, 0xc939,		0x21, 0
	.dw 0x6fc0, 0xc939,	0x6fff, 0xc939,		0x21, 0
	.dw 0x7040, 0xc939,	0x707f, 0xc939,		0x21, 0
	.dw 0x70c0, 0xc939,	0x70ff, 0xc939,		0x21, 0
	.dw 0x7140, 0xc939,	0x717f, 0xc939,		0x21, 0
	.dw 0x71c0, 0xc939,	0x71ff, 0xc939,		0x21, 0
	.dw 0x7240, 0xc939,	0x727f, 0xc939,		0x21, 0
	.dw 0x72c0, 0xc939,	0x72ff, 0xc939,		0x21, 0
	.dw 0x7340, 0xc939,	0x737f, 0xc939,		0x21, 0
	.dw 0x73c0, 0xc939,	0x73ff, 0xc939,		0x21, 0
	.dw 0x7440, 0xc939,	0x747f, 0xc939,		0x21, 0
	.dw 0x74c0, 0xc939,	0x74ff, 0xc939,		0x21, 0
	.dw 0x7540, 0xc939,	0x757f, 0xc939,		0x21, 0
	.dw 0x75c0, 0xc939,	0x75ff, 0xc939,		0x21, 0
	.dw 0x7640, 0xc939,	0x767f, 0xc939,		0x21, 0
	.dw 0x76c0, 0xc939,	0x76ff, 0xc939,		0x21, 0
	.dw 0x7740, 0xc939,	0x777f, 0xc939,		0x21, 0
	.dw 0x77c0, 0xc939,	0x77ff, 0xc939,		0x21, 0
	.dw 0x7840, 0xc939,	0x787f, 0xc939,		0x21, 0
	.dw 0x78c0, 0xc939,	0x78ff, 0xc939,		0x21, 0
	.dw 0x7940, 0xc939,	0x797f, 0xc939,		0x21, 0
	.dw 0x79c0, 0xc939,	0x9fff, 0xc939,		0x21, 0
	.dw 0xa040, 0xc939,	0xa07f, 0xc939,		0x21, 0
	.dw 0xa0c0, 0xc939,	0xa0ff, 0xc939,		0x21, 0
	.dw 0xa140, 0xc939,	0xa17f, 0xc939,		0x21, 0
	.dw 0xa1c0, 0xc939,	0xa1ff, 0xc939,		0x21, 0
	.dw 0xa240, 0xc939,	0xa27f, 0xc939,		0x21, 0
	.dw 0xa2c0, 0xc939,	0xa2ff, 0xc939,		0x21, 0
	.dw 0xa340, 0xc939,	0xa37f, 0xc939,		0x21, 0
	.dw 0xa3c0, 0xc939,	0xa3ff, 0xc939,		0x21, 0
	.dw 0xa440, 0xc939,	0xa47f, 0xc939,		0x21, 0
	.dw 0xa4c0, 0xc939,	0xa4ff, 0xc939,		0x21, 0
	.dw 0xa540, 0xc939,	0xa57f, 0xc939,		0x21, 0
	.dw 0xa5c0, 0xc939,	0xa5ff, 0xc939,		0x21, 0
	.dw 0xa640, 0xc939,	0xa67f, 0xc939,		0x21, 0
	.dw 0xa6c0, 0xc939,	0xa6ff, 0xc939,		0x21, 0
	.dw 0xa740, 0xc939,	0xa77f, 0xc939,		0x21, 0
	.dw 0xa7c0, 0xc939,	0xa7ff, 0xc939,		0x21, 0
	.dw 0xa840, 0xc939,	0xa87f, 0xc939,		0x21, 0
	.dw 0xa8c0, 0xc939,	0xa8ff, 0xc939,		0x21, 0
	.dw 0xa940, 0xc939,	0xa97f, 0xc939,		0x21, 0
	.dw 0xa9c0, 0xc939,	0xa9ff, 0xc939,		0x21, 0
	.dw 0xaa40, 0xc939,	0xaa7f, 0xc939,		0x21, 0
	.dw 0xaac0, 0xc939,	0xaaff, 0xc939,		0x21, 0
	.dw 0xab40, 0xc939,	0xab7f, 0xc939,		0x21, 0
	.dw 0xabc0, 0xc939,	0xabff, 0xc939,		0x21, 0
	.dw 0xac40, 0xc939,	0xac7f, 0xc939,		0x21, 0
	.dw 0xacc0, 0xc939,	0xacff, 0xc939,		0x21, 0
	.dw 0xad40, 0xc939,	0xad7f, 0xc939,		0x21, 0
	.dw 0xadc0, 0xc939,	0xadff, 0xc939,		0x21, 0
	.dw 0xae40, 0xc939,	0xae7f, 0xc939,		0x21, 0
	.dw 0xaec0, 0xc939,	0xaeff, 0xc939,		0x21, 0
	.dw 0xaf40, 0xc939,	0xaf7f, 0xc939,		0x21, 0
	.dw 0xafc0, 0xc939,	0xafff, 0xc939,		0x21, 0
	.dw 0xb040, 0xc939,	0xb07f, 0xc939,		0x21, 0
	.dw 0xb0c0, 0xc939,	0xb0ff, 0xc939,		0x21, 0
	.dw 0xb140, 0xc939,	0xb17f, 0xc939,		0x21, 0
	.dw 0xb1c0, 0xc939,	0xb1ff, 0xc939,		0x21, 0
	.dw 0xb240, 0xc939,	0xb27f, 0xc939,		0x21, 0
	.dw 0xb2c0, 0xc939,	0xb2ff, 0xc939,		0x21, 0
	.dw 0xb340, 0xc939,	0xb37f, 0xc939,		0x21, 0
	.dw 0xb3c0, 0xc939,	0xb3ff, 0xc939,		0x21, 0
	.dw 0xb440, 0xc939,	0xb47f, 0xc939,		0x21, 0
	.dw 0xb4c0, 0xc939,	0xb4ff, 0xc939,		0x21, 0
	.dw 0xb540, 0xc939,	0xb57f, 0xc939,		0x21, 0
	.dw 0xb5c0, 0xc939,	0xb5ff, 0xc939,		0x21, 0
	.dw 0xb640, 0xc939,	0xb67f, 0xc939,		0x21, 0
	.dw 0xb6c0, 0xc939,	0xb6ff, 0xc939,		0x21, 0
	.dw 0xb740, 0xc939,	0xb77f, 0xc939,		0x21, 0
	.dw 0xb7c0, 0xc939,	0xb7ff, 0xc939,		0x21, 0
	.dw 0xb840, 0xc939,	0xb87f, 0xc939,		0x21, 0
	.dw 0xb8c0, 0xc939,	0xb8ff, 0xc939,		0x21, 0
	.dw 0xb940, 0xc939,	0xb97f, 0xc939,		0x21, 0
	.dw 0xb9c0, 0xc939,	0xdfff, 0xc939,		0x21, 0
	.dw 0xe040, 0xc939,	0xe07f, 0xc939,		0x21, 0
	.dw 0xe0c0, 0xc939,	0xe0ff, 0xc939,		0x21, 0
	.dw 0xe140, 0xc939,	0xe17f, 0xc939,		0x21, 0
	.dw 0xe1c0, 0xc939,	0xe1ff, 0xc939,		0x21, 0
	.dw 0xe240, 0xc939,	0xe27f, 0xc939,		0x21, 0
	.dw 0xe2c0, 0xc939,	0xe2ff, 0xc939,		0x21, 0
	.dw 0xe340, 0xc939,	0xe37f, 0xc939,		0x21, 0
	.dw 0xe3c0, 0xc939,	0xe3ff, 0xc939,		0x21, 0
	.dw 0xe440, 0xc939,	0xe47f, 0xc939,		0x21, 0
	.dw 0xe4c0, 0xc939,	0xe4ff, 0xc939,		0x21, 0
	.dw 0xe540, 0xc939,	0xe57f, 0xc939,		0x21, 0
	.dw 0xe5c0, 0xc939,	0xe5ff, 0xc939,		0x21, 0
	.dw 0xe640, 0xc939,	0xe67f, 0xc939,		0x21, 0
	.dw 0xe6c0, 0xc939,	0xe6ff, 0xc939,		0x21, 0
	.dw 0xe740, 0xc939,	0xe77f, 0xc939,		0x21, 0
	.dw 0xe7c0, 0xc939,	0xe7ff, 0xc939,		0x21, 0
	.dw 0xe840, 0xc939,	0xe87f, 0xc939,		0x21, 0
	.dw 0xe8c0, 0xc939,	0xe8ff, 0xc939,		0x21, 0
	.dw 0xe940, 0xc939,	0xe97f, 0xc939,		0x21, 0
	.dw 0xe9c0, 0xc939,	0xe9ff, 0xc939,		0x21, 0
	.dw 0xea40, 0xc939,	0xea7f, 0xc939,		0x21, 0
	.dw 0xeac0, 0xc939,	0xeaff, 0xc939,		0x21, 0
	.dw 0xeb40, 0xc939,	0xeb7f, 0xc939,		0x21, 0
	.dw 0xebc0, 0xc939,	0xebff, 0xc939,		0x21, 0
	.dw 0xec40, 0xc939,	0xec7f, 0xc939,		0x21, 0
	.dw 0xecc0, 0xc939,	0xecff, 0xc939,		0x21, 0
	.dw 0xed40, 0xc939,	0xed7f, 0xc939,		0x21, 0
	.dw 0xedc0, 0xc939,	0xedff, 0xc939,		0x21, 0
	.dw 0xee40, 0xc939,	0xee7f, 0xc939,		0x21, 0
	.dw 0xeec0, 0xc939,	0xeeff, 0xc939,		0x21, 0
	.dw 0xef40, 0xc939,	0xef7f, 0xc939,		0x21, 0
	.dw 0xefc0, 0xc939,	0xefff, 0xc939,		0x21, 0
	.dw 0xf040, 0xc939,	0xf07f, 0xc939,		0x21, 0
	.dw 0xf0c0, 0xc939,	0xf0ff, 0xc939,		0x21, 0
	.dw 0xf140, 0xc939,	0xf17f, 0xc939,		0x21, 0
	.dw 0xf1c0, 0xc939,	0xf1ff, 0xc939,		0x21, 0
	.dw 0xf240, 0xc939,	0xf27f, 0xc939,		0x21, 0
	.dw 0xf2c0, 0xc939,	0xf2ff, 0xc939,		0x21, 0
	.dw 0xf340, 0xc939,	0xf37f, 0xc939,		0x21, 0
	.dw 0xf3c0, 0xc939,	0xf3ff, 0xc939,		0x21, 0
	.dw 0xf440, 0xc939,	0xf47f, 0xc939,		0x21, 0
	.dw 0xf4c0, 0xc939,	0xf4ff, 0xc939,		0x21, 0
	.dw 0xf540, 0xc939,	0xf57f, 0xc939,		0x21, 0
	.dw 0xf5c0, 0xc939,	0xf5ff, 0xc939,		0x21, 0
	.dw 0xf640, 0xc939,	0xf67f, 0xc939,		0x21, 0
	.dw 0xf6c0, 0xc939,	0xf6ff, 0xc939,		0x21, 0
	.dw 0xf740, 0xc939,	0xf77f, 0xc939,		0x21, 0
	.dw 0xf7c0, 0xc939,	0xf7ff, 0xc939,		0x21, 0
	.dw 0xf840, 0xc939,	0xf87f, 0xc939,		0x21, 0
	.dw 0xf8c0, 0xc939,	0xf8ff, 0xc939,		0x21, 0
	.dw 0xf940, 0xc939,	0xf97f, 0xc939,		0x21, 0
	.dw 0xf9c0, 0xc939,	0x1fff, 0xc93a,		0x21, 0
	.dw 0x2040, 0xc93a,	0x207f, 0xc93a,		0x21, 0
	.dw 0x20c0, 0xc93a,	0x20ff, 0xc93a,		0x21, 0
	.dw 0x2140, 0xc93a,	0x217f, 0xc93a,		0x21, 0
	.dw 0x21c0, 0xc93a,	0x21ff, 0xc93a,		0x21, 0
	.dw 0x2240, 0xc93a,	0x227f, 0xc93a,		0x21, 0
	.dw 0x22c0, 0xc93a,	0x22ff, 0xc93a,		0x21, 0
	.dw 0x2340, 0xc93a,	0x237f, 0xc93a,		0x21, 0
	.dw 0x23c0, 0xc93a,	0x23ff, 0xc93a,		0x21, 0
	.dw 0x2440, 0xc93a,	0x247f, 0xc93a,		0x21, 0
	.dw 0x24c0, 0xc93a,	0x24ff, 0xc93a,		0x21, 0
	.dw 0x2540, 0xc93a,	0x257f, 0xc93a,		0x21, 0
	.dw 0x25c0, 0xc93a,	0x25ff, 0xc93a,		0x21, 0
	.dw 0x2640, 0xc93a,	0x267f, 0xc93a,		0x21, 0
	.dw 0x26c0, 0xc93a,	0x26ff, 0xc93a,		0x21, 0
	.dw 0x2740, 0xc93a,	0x277f, 0xc93a,		0x21, 0
	.dw 0x27c0, 0xc93a,	0x27ff, 0xc93a,		0x21, 0
	.dw 0x2840, 0xc93a,	0x287f, 0xc93a,		0x21, 0
	.dw 0x28c0, 0xc93a,	0x28ff, 0xc93a,		0x21, 0
	.dw 0x2940, 0xc93a,	0x297f, 0xc93a,		0x21, 0
	.dw 0x29c0, 0xc93a,	0x29ff, 0xc93a,		0x21, 0
	.dw 0x2a40, 0xc93a,	0x2a7f, 0xc93a,		0x21, 0
	.dw 0x2ac0, 0xc93a,	0x2aff, 0xc93a,		0x21, 0
	.dw 0x2b40, 0xc93a,	0x2b7f, 0xc93a,		0x21, 0
	.dw 0x2bc0, 0xc93a,	0x2bff, 0xc93a,		0x21, 0
	.dw 0x2c40, 0xc93a,	0x2c7f, 0xc93a,		0x21, 0
	.dw 0x2cc0, 0xc93a,	0x2cff, 0xc93a,		0x21, 0
	.dw 0x2d40, 0xc93a,	0x2d7f, 0xc93a,		0x21, 0
	.dw 0x2dc0, 0xc93a,	0x2dff, 0xc93a,		0x21, 0
	.dw 0x2e40, 0xc93a,	0x2e7f, 0xc93a,		0x21, 0
	.dw 0x2ec0, 0xc93a,	0x2eff, 0xc93a,		0x21, 0
	.dw 0x2f40, 0xc93a,	0x2f7f, 0xc93a,		0x21, 0
	.dw 0x2fc0, 0xc93a,	0x2fff, 0xc93a,		0x21, 0
	.dw 0x3040, 0xc93a,	0x307f, 0xc93a,		0x21, 0
	.dw 0x30c0, 0xc93a,	0x30ff, 0xc93a,		0x21, 0
	.dw 0x3140, 0xc93a,	0x317f, 0xc93a,		0x21, 0
	.dw 0x31c0, 0xc93a,	0x31ff, 0xc93a,		0x21, 0
	.dw 0x3240, 0xc93a,	0x327f, 0xc93a,		0x21, 0
	.dw 0x32c0, 0xc93a,	0x32ff, 0xc93a,		0x21, 0
	.dw 0x3340, 0xc93a,	0x337f, 0xc93a,		0x21, 0
	.dw 0x33c0, 0xc93a,	0x33ff, 0xc93a,		0x21, 0
	.dw 0x3440, 0xc93a,	0x347f, 0xc93a,		0x21, 0
	.dw 0x34c0, 0xc93a,	0x34ff, 0xc93a,		0x21, 0
	.dw 0x3540, 0xc93a,	0x357f, 0xc93a,		0x21, 0
	.dw 0x35c0, 0xc93a,	0x35ff, 0xc93a,		0x21, 0
	.dw 0x3640, 0xc93a,	0x367f, 0xc93a,		0x21, 0
	.dw 0x36c0, 0xc93a,	0x36ff, 0xc93a,		0x21, 0
	.dw 0x3740, 0xc93a,	0x377f, 0xc93a,		0x21, 0
	.dw 0x37c0, 0xc93a,	0x37ff, 0xc93a,		0x21, 0
	.dw 0x3840, 0xc93a,	0x387f, 0xc93a,		0x21, 0
	.dw 0x38c0, 0xc93a,	0x38ff, 0xc93a,		0x21, 0
	.dw 0x3940, 0xc93a,	0x397f, 0xc93a,		0x21, 0
	.dw 0x39c0, 0xc93a,	0x5fff, 0xc93a,		0x21, 0
	.dw 0x6040, 0xc93a,	0x607f, 0xc93a,		0x21, 0
	.dw 0x60c0, 0xc93a,	0x60ff, 0xc93a,		0x21, 0
	.dw 0x6140, 0xc93a,	0x617f, 0xc93a,		0x21, 0
	.dw 0x61c0, 0xc93a,	0x61ff, 0xc93a,		0x21, 0
	.dw 0x6240, 0xc93a,	0x627f, 0xc93a,		0x21, 0
	.dw 0x62c0, 0xc93a,	0x62ff, 0xc93a,		0x21, 0
	.dw 0x6340, 0xc93a,	0x637f, 0xc93a,		0x21, 0
	.dw 0x63c0, 0xc93a,	0x63ff, 0xc93a,		0x21, 0
	.dw 0x6440, 0xc93a,	0x647f, 0xc93a,		0x21, 0
	.dw 0x64c0, 0xc93a,	0x64ff, 0xc93a,		0x21, 0
	.dw 0x6540, 0xc93a,	0x657f, 0xc93a,		0x21, 0
	.dw 0x65c0, 0xc93a,	0x65ff, 0xc93a,		0x21, 0
	.dw 0x6640, 0xc93a,	0x667f, 0xc93a,		0x21, 0
	.dw 0x66c0, 0xc93a,	0x66ff, 0xc93a,		0x21, 0
	.dw 0x6740, 0xc93a,	0x677f, 0xc93a,		0x21, 0
	.dw 0x67c0, 0xc93a,	0x67ff, 0xc93a,		0x21, 0
	.dw 0x6840, 0xc93a,	0x687f, 0xc93a,		0x21, 0
	.dw 0x68c0, 0xc93a,	0x68ff, 0xc93a,		0x21, 0
	.dw 0x6940, 0xc93a,	0x697f, 0xc93a,		0x21, 0
	.dw 0x69c0, 0xc93a,	0x69ff, 0xc93a,		0x21, 0
	.dw 0x6a40, 0xc93a,	0x6a7f, 0xc93a,		0x21, 0
	.dw 0x6ac0, 0xc93a,	0x6aff, 0xc93a,		0x21, 0
	.dw 0x6b40, 0xc93a,	0x6b7f, 0xc93a,		0x21, 0
	.dw 0x6bc0, 0xc93a,	0x6bff, 0xc93a,		0x21, 0
	.dw 0x6c40, 0xc93a,	0x6c7f, 0xc93a,		0x21, 0
	.dw 0x6cc0, 0xc93a,	0x6cff, 0xc93a,		0x21, 0
	.dw 0x6d40, 0xc93a,	0x6d7f, 0xc93a,		0x21, 0
	.dw 0x6dc0, 0xc93a,	0x6dff, 0xc93a,		0x21, 0
	.dw 0x6e40, 0xc93a,	0x6e7f, 0xc93a,		0x21, 0
	.dw 0x6ec0, 0xc93a,	0x6eff, 0xc93a,		0x21, 0
	.dw 0x6f40, 0xc93a,	0x6f7f, 0xc93a,		0x21, 0
	.dw 0x6fc0, 0xc93a,	0x6fff, 0xc93a,		0x21, 0
	.dw 0x7040, 0xc93a,	0x707f, 0xc93a,		0x21, 0
	.dw 0x70c0, 0xc93a,	0x70ff, 0xc93a,		0x21, 0
	.dw 0x7140, 0xc93a,	0x717f, 0xc93a,		0x21, 0
	.dw 0x71c0, 0xc93a,	0x71ff, 0xc93a,		0x21, 0
	.dw 0x7240, 0xc93a,	0x727f, 0xc93a,		0x21, 0
	.dw 0x72c0, 0xc93a,	0x72ff, 0xc93a,		0x21, 0
	.dw 0x7340, 0xc93a,	0x737f, 0xc93a,		0x21, 0
	.dw 0x73c0, 0xc93a,	0x73ff, 0xc93a,		0x21, 0
	.dw 0x7440, 0xc93a,	0x747f, 0xc93a,		0x21, 0
	.dw 0x74c0, 0xc93a,	0x74ff, 0xc93a,		0x21, 0
	.dw 0x7540, 0xc93a,	0x757f, 0xc93a,		0x21, 0
	.dw 0x75c0, 0xc93a,	0x75ff, 0xc93a,		0x21, 0
	.dw 0x7640, 0xc93a,	0x767f, 0xc93a,		0x21, 0
	.dw 0x76c0, 0xc93a,	0x76ff, 0xc93a,		0x21, 0
	.dw 0x7740, 0xc93a,	0x777f, 0xc93a,		0x21, 0
	.dw 0x77c0, 0xc93a,	0x77ff, 0xc93a,		0x21, 0
	.dw 0x7840, 0xc93a,	0x787f, 0xc93a,		0x21, 0
	.dw 0x78c0, 0xc93a,	0x78ff, 0xc93a,		0x21, 0
	.dw 0x7940, 0xc93a,	0x797f, 0xc93a,		0x21, 0
	.dw 0x79c0, 0xc93a,	0x9fff, 0xc93a,		0x21, 0
	.dw 0xa040, 0xc93a,	0xa07f, 0xc93a,		0x21, 0
	.dw 0xa0c0, 0xc93a,	0xa0ff, 0xc93a,		0x21, 0
	.dw 0xa140, 0xc93a,	0xa17f, 0xc93a,		0x21, 0
	.dw 0xa1c0, 0xc93a,	0xa1ff, 0xc93a,		0x21, 0
	.dw 0xa240, 0xc93a,	0xa27f, 0xc93a,		0x21, 0
	.dw 0xa2c0, 0xc93a,	0xa2ff, 0xc93a,		0x21, 0
	.dw 0xa340, 0xc93a,	0xa37f, 0xc93a,		0x21, 0
	.dw 0xa3c0, 0xc93a,	0xa3ff, 0xc93a,		0x21, 0
	.dw 0xa440, 0xc93a,	0xa47f, 0xc93a,		0x21, 0
	.dw 0xa4c0, 0xc93a,	0xa4ff, 0xc93a,		0x21, 0
	.dw 0xa540, 0xc93a,	0xa57f, 0xc93a,		0x21, 0
	.dw 0xa5c0, 0xc93a,	0xa5ff, 0xc93a,		0x21, 0
	.dw 0xa640, 0xc93a,	0xa67f, 0xc93a,		0x21, 0
	.dw 0xa6c0, 0xc93a,	0xa6ff, 0xc93a,		0x21, 0
	.dw 0xa740, 0xc93a,	0xa77f, 0xc93a,		0x21, 0
	.dw 0xa7c0, 0xc93a,	0xa7ff, 0xc93a,		0x21, 0
	.dw 0xa840, 0xc93a,	0xa87f, 0xc93a,		0x21, 0
	.dw 0xa8c0, 0xc93a,	0xa8ff, 0xc93a,		0x21, 0
	.dw 0xa940, 0xc93a,	0xa97f, 0xc93a,		0x21, 0
	.dw 0xa9c0, 0xc93a,	0xa9ff, 0xc93a,		0x21, 0
	.dw 0xaa40, 0xc93a,	0xaa7f, 0xc93a,		0x21, 0
	.dw 0xaac0, 0xc93a,	0xaaff, 0xc93a,		0x21, 0
	.dw 0xab40, 0xc93a,	0xab7f, 0xc93a,		0x21, 0
	.dw 0xabc0, 0xc93a,	0xabff, 0xc93a,		0x21, 0
	.dw 0xac40, 0xc93a,	0xac7f, 0xc93a,		0x21, 0
	.dw 0xacc0, 0xc93a,	0xacff, 0xc93a,		0x21, 0
	.dw 0xad40, 0xc93a,	0xad7f, 0xc93a,		0x21, 0
	.dw 0xadc0, 0xc93a,	0xadff, 0xc93a,		0x21, 0
	.dw 0xae40, 0xc93a,	0xae7f, 0xc93a,		0x21, 0
	.dw 0xaec0, 0xc93a,	0xaeff, 0xc93a,		0x21, 0
	.dw 0xaf40, 0xc93a,	0xaf7f, 0xc93a,		0x21, 0
	.dw 0xafc0, 0xc93a,	0xafff, 0xc93a,		0x21, 0
	.dw 0xb040, 0xc93a,	0xb07f, 0xc93a,		0x21, 0
	.dw 0xb0c0, 0xc93a,	0xb0ff, 0xc93a,		0x21, 0
	.dw 0xb140, 0xc93a,	0xb17f, 0xc93a,		0x21, 0
	.dw 0xb1c0, 0xc93a,	0xb1ff, 0xc93a,		0x21, 0
	.dw 0xb240, 0xc93a,	0xb27f, 0xc93a,		0x21, 0
	.dw 0xb2c0, 0xc93a,	0xb2ff, 0xc93a,		0x21, 0
	.dw 0xb340, 0xc93a,	0xb37f, 0xc93a,		0x21, 0
	.dw 0xb3c0, 0xc93a,	0xb3ff, 0xc93a,		0x21, 0
	.dw 0xb440, 0xc93a,	0xb47f, 0xc93a,		0x21, 0
	.dw 0xb4c0, 0xc93a,	0xb4ff, 0xc93a,		0x21, 0
	.dw 0xb540, 0xc93a,	0xb57f, 0xc93a,		0x21, 0
	.dw 0xb5c0, 0xc93a,	0xb5ff, 0xc93a,		0x21, 0
	.dw 0xb640, 0xc93a,	0xb67f, 0xc93a,		0x21, 0
	.dw 0xb6c0, 0xc93a,	0xb6ff, 0xc93a,		0x21, 0
	.dw 0xb740, 0xc93a,	0xb77f, 0xc93a,		0x21, 0
	.dw 0xb7c0, 0xc93a,	0xb7ff, 0xc93a,		0x21, 0
	.dw 0xb840, 0xc93a,	0xb87f, 0xc93a,		0x21, 0
	.dw 0xb8c0, 0xc93a,	0xb8ff, 0xc93a,		0x21, 0
	.dw 0xb940, 0xc93a,	0xb97f, 0xc93a,		0x21, 0
	.dw 0xb9c0, 0xc93a,	0xdfff, 0xc93a,		0x21, 0
	.dw 0xe040, 0xc93a,	0xe07f, 0xc93a,		0x21, 0
	.dw 0xe0c0, 0xc93a,	0xe0ff, 0xc93a,		0x21, 0
	.dw 0xe140, 0xc93a,	0xe17f, 0xc93a,		0x21, 0
	.dw 0xe1c0, 0xc93a,	0xe1ff, 0xc93a,		0x21, 0
	.dw 0xe240, 0xc93a,	0xe27f, 0xc93a,		0x21, 0
	.dw 0xe2c0, 0xc93a,	0xe2ff, 0xc93a,		0x21, 0
	.dw 0xe340, 0xc93a,	0xe37f, 0xc93a,		0x21, 0
	.dw 0xe3c0, 0xc93a,	0xe3ff, 0xc93a,		0x21, 0
	.dw 0xe440, 0xc93a,	0xe47f, 0xc93a,		0x21, 0
	.dw 0xe4c0, 0xc93a,	0xe4ff, 0xc93a,		0x21, 0
	.dw 0xe540, 0xc93a,	0xe57f, 0xc93a,		0x21, 0
	.dw 0xe5c0, 0xc93a,	0xe5ff, 0xc93a,		0x21, 0
	.dw 0xe640, 0xc93a,	0xe67f, 0xc93a,		0x21, 0
	.dw 0xe6c0, 0xc93a,	0xe6ff, 0xc93a,		0x21, 0
	.dw 0xe740, 0xc93a,	0xe77f, 0xc93a,		0x21, 0
	.dw 0xe7c0, 0xc93a,	0xe7ff, 0xc93a,		0x21, 0
	.dw 0xe840, 0xc93a,	0xe87f, 0xc93a,		0x21, 0
	.dw 0xe8c0, 0xc93a,	0xe8ff, 0xc93a,		0x21, 0
	.dw 0xe940, 0xc93a,	0xe97f, 0xc93a,		0x21, 0
	.dw 0xe9c0, 0xc93a,	0xe9ff, 0xc93a,		0x21, 0
	.dw 0xea40, 0xc93a,	0xea7f, 0xc93a,		0x21, 0
	.dw 0xeac0, 0xc93a,	0xeaff, 0xc93a,		0x21, 0
	.dw 0xeb40, 0xc93a,	0xeb7f, 0xc93a,		0x21, 0
	.dw 0xebc0, 0xc93a,	0xebff, 0xc93a,		0x21, 0
	.dw 0xec40, 0xc93a,	0xec7f, 0xc93a,		0x21, 0
	.dw 0xecc0, 0xc93a,	0xecff, 0xc93a,		0x21, 0
	.dw 0xed40, 0xc93a,	0xed7f, 0xc93a,		0x21, 0
	.dw 0xedc0, 0xc93a,	0xedff, 0xc93a,		0x21, 0
	.dw 0xee40, 0xc93a,	0xee7f, 0xc93a,		0x21, 0
	.dw 0xeec0, 0xc93a,	0xeeff, 0xc93a,		0x21, 0
	.dw 0xef40, 0xc93a,	0xef7f, 0xc93a,		0x21, 0
	.dw 0xefc0, 0xc93a,	0xefff, 0xc93a,		0x21, 0
	.dw 0xf040, 0xc93a,	0xf07f, 0xc93a,		0x21, 0
	.dw 0xf0c0, 0xc93a,	0xf0ff, 0xc93a,		0x21, 0
	.dw 0xf140, 0xc93a,	0xf17f, 0xc93a,		0x21, 0
	.dw 0xf1c0, 0xc93a,	0xf1ff, 0xc93a,		0x21, 0
	.dw 0xf240, 0xc93a,	0xf27f, 0xc93a,		0x21, 0
	.dw 0xf2c0, 0xc93a,	0xf2ff, 0xc93a,		0x21, 0
	.dw 0xf340, 0xc93a,	0xf37f, 0xc93a,		0x21, 0
	.dw 0xf3c0, 0xc93a,	0xf3ff, 0xc93a,		0x21, 0
	.dw 0xf440, 0xc93a,	0xf47f, 0xc93a,		0x21, 0
	.dw 0xf4c0, 0xc93a,	0xf4ff, 0xc93a,		0x21, 0
	.dw 0xf540, 0xc93a,	0xf57f, 0xc93a,		0x21, 0
	.dw 0xf5c0, 0xc93a,	0xf5ff, 0xc93a,		0x21, 0
	.dw 0xf640, 0xc93a,	0xf67f, 0xc93a,		0x21, 0
	.dw 0xf6c0, 0xc93a,	0xf6ff, 0xc93a,		0x21, 0
	.dw 0xf740, 0xc93a,	0xf77f, 0xc93a,		0x21, 0
	.dw 0xf7c0, 0xc93a,	0xf7ff, 0xc93a,		0x21, 0
	.dw 0xf840, 0xc93a,	0xf87f, 0xc93a,		0x21, 0
	.dw 0xf8c0, 0xc93a,	0xf8ff, 0xc93a,		0x21, 0
	.dw 0xf940, 0xc93a,	0xf97f, 0xc93a,		0x21, 0
	.dw 0xf9c0, 0xc93a,	0xffff, 0xc93b,		0x21, 0
	.dw 0x0040, 0xc93c,	0x007f, 0xc93c,		0x21, 0
	.dw 0x00c0, 0xc93c,	0x00ff, 0xc93c,		0x21, 0
	.dw 0x0140, 0xc93c,	0x017f, 0xc93c,		0x21, 0
	.dw 0x01c0, 0xc93c,	0x01ff, 0xc93c,		0x21, 0
	.dw 0x0240, 0xc93c,	0x027f, 0xc93c,		0x21, 0
	.dw 0x02c0, 0xc93c,	0x02ff, 0xc93c,		0x21, 0
	.dw 0x0340, 0xc93c,	0x037f, 0xc93c,		0x21, 0
	.dw 0x03c0, 0xc93c,	0x03ff, 0xc93c,		0x21, 0
	.dw 0x0440, 0xc93c,	0x047f, 0xc93c,		0x21, 0
	.dw 0x04c0, 0xc93c,	0x04ff, 0xc93c,		0x21, 0
	.dw 0x0540, 0xc93c,	0x057f, 0xc93c,		0x21, 0
	.dw 0x05c0, 0xc93c,	0x05ff, 0xc93c,		0x21, 0
	.dw 0x0640, 0xc93c,	0x067f, 0xc93c,		0x21, 0
	.dw 0x06c0, 0xc93c,	0x06ff, 0xc93c,		0x21, 0
	.dw 0x0740, 0xc93c,	0x077f, 0xc93c,		0x21, 0
	.dw 0x07c0, 0xc93c,	0x07ff, 0xc93c,		0x21, 0
	.dw 0x0840, 0xc93c,	0x087f, 0xc93c,		0x21, 0
	.dw 0x08c0, 0xc93c,	0x08ff, 0xc93c,		0x21, 0
	.dw 0x0940, 0xc93c,	0x097f, 0xc93c,		0x21, 0
	.dw 0x09c0, 0xc93c,	0x09ff, 0xc93c,		0x21, 0
	.dw 0x0a40, 0xc93c,	0x0a7f, 0xc93c,		0x21, 0
	.dw 0x0ac0, 0xc93c,	0x0aff, 0xc93c,		0x21, 0
	.dw 0x0b40, 0xc93c,	0x0b7f, 0xc93c,		0x21, 0
	.dw 0x0bc0, 0xc93c,	0x0bff, 0xc93c,		0x21, 0
	.dw 0x0c40, 0xc93c,	0x0c7f, 0xc93c,		0x21, 0
	.dw 0x0cc0, 0xc93c,	0x0cff, 0xc93c,		0x21, 0
	.dw 0x0d40, 0xc93c,	0x0d7f, 0xc93c,		0x21, 0
	.dw 0x0dc0, 0xc93c,	0x0dff, 0xc93c,		0x21, 0
	.dw 0x0e40, 0xc93c,	0x0e7f, 0xc93c,		0x21, 0
	.dw 0x0ec0, 0xc93c,	0x0eff, 0xc93c,		0x21, 0
	.dw 0x0f40, 0xc93c,	0x0f7f, 0xc93c,		0x21, 0
	.dw 0x0fc0, 0xc93c,	0x0fff, 0xc93c,		0x21, 0
	.dw 0x1040, 0xc93c,	0x107f, 0xc93c,		0x21, 0
	.dw 0x10c0, 0xc93c,	0x10ff, 0xc93c,		0x21, 0
	.dw 0x1140, 0xc93c,	0x117f, 0xc93c,		0x21, 0
	.dw 0x11c0, 0xc93c,	0x11ff, 0xc93c,		0x21, 0
	.dw 0x1240, 0xc93c,	0x127f, 0xc93c,		0x21, 0
	.dw 0x12c0, 0xc93c,	0x12ff, 0xc93c,		0x21, 0
	.dw 0x1340, 0xc93c,	0x137f, 0xc93c,		0x21, 0
	.dw 0x13c0, 0xc93c,	0x13ff, 0xc93c,		0x21, 0
	.dw 0x1440, 0xc93c,	0x147f, 0xc93c,		0x21, 0
	.dw 0x14c0, 0xc93c,	0x14ff, 0xc93c,		0x21, 0
	.dw 0x1540, 0xc93c,	0x157f, 0xc93c,		0x21, 0
	.dw 0x15c0, 0xc93c,	0x15ff, 0xc93c,		0x21, 0
	.dw 0x1640, 0xc93c,	0x167f, 0xc93c,		0x21, 0
	.dw 0x16c0, 0xc93c,	0x16ff, 0xc93c,		0x21, 0
	.dw 0x1740, 0xc93c,	0x177f, 0xc93c,		0x21, 0
	.dw 0x17c0, 0xc93c,	0x17ff, 0xc93c,		0x21, 0
	.dw 0x1840, 0xc93c,	0x187f, 0xc93c,		0x21, 0
	.dw 0x18c0, 0xc93c,	0x18ff, 0xc93c,		0x21, 0
	.dw 0x1940, 0xc93c,	0x197f, 0xc93c,		0x21, 0
	.dw 0x19c0, 0xc93c,	0x1fff, 0xc93c,		0x21, 0
	.dw 0x2040, 0xc93c,	0x207f, 0xc93c,		0x21, 0
	.dw 0x20c0, 0xc93c,	0x20ff, 0xc93c,		0x21, 0
	.dw 0x2140, 0xc93c,	0x217f, 0xc93c,		0x21, 0
	.dw 0x21c0, 0xc93c,	0x21ff, 0xc93c,		0x21, 0
	.dw 0x2240, 0xc93c,	0x227f, 0xc93c,		0x21, 0
	.dw 0x22c0, 0xc93c,	0x22ff, 0xc93c,		0x21, 0
	.dw 0x2340, 0xc93c,	0x237f, 0xc93c,		0x21, 0
	.dw 0x23c0, 0xc93c,	0x23ff, 0xc93c,		0x21, 0
	.dw 0x2440, 0xc93c,	0x247f, 0xc93c,		0x21, 0
	.dw 0x24c0, 0xc93c,	0x24ff, 0xc93c,		0x21, 0
	.dw 0x2540, 0xc93c,	0x257f, 0xc93c,		0x21, 0
	.dw 0x25c0, 0xc93c,	0x25ff, 0xc93c,		0x21, 0
	.dw 0x2640, 0xc93c,	0x267f, 0xc93c,		0x21, 0
	.dw 0x26c0, 0xc93c,	0x26ff, 0xc93c,		0x21, 0
	.dw 0x2740, 0xc93c,	0x277f, 0xc93c,		0x21, 0
	.dw 0x27c0, 0xc93c,	0x27ff, 0xc93c,		0x21, 0
	.dw 0x2840, 0xc93c,	0x287f, 0xc93c,		0x21, 0
	.dw 0x28c0, 0xc93c,	0x28ff, 0xc93c,		0x21, 0
	.dw 0x2940, 0xc93c,	0x297f, 0xc93c,		0x21, 0
	.dw 0x29c0, 0xc93c,	0x29ff, 0xc93c,		0x21, 0
	.dw 0x2a40, 0xc93c,	0x2a7f, 0xc93c,		0x21, 0
	.dw 0x2ac0, 0xc93c,	0x2aff, 0xc93c,		0x21, 0
	.dw 0x2b40, 0xc93c,	0x2b7f, 0xc93c,		0x21, 0
	.dw 0x2bc0, 0xc93c,	0x2bff, 0xc93c,		0x21, 0
	.dw 0x2c40, 0xc93c,	0x2c7f, 0xc93c,		0x21, 0
	.dw 0x2cc0, 0xc93c,	0x2cff, 0xc93c,		0x21, 0
	.dw 0x2d40, 0xc93c,	0x2d7f, 0xc93c,		0x21, 0
	.dw 0x2dc0, 0xc93c,	0x2dff, 0xc93c,		0x21, 0
	.dw 0x2e40, 0xc93c,	0x2e7f, 0xc93c,		0x21, 0
	.dw 0x2ec0, 0xc93c,	0x2eff, 0xc93c,		0x21, 0
	.dw 0x2f40, 0xc93c,	0x2f7f, 0xc93c,		0x21, 0
	.dw 0x2fc0, 0xc93c,	0x2fff, 0xc93c,		0x21, 0
	.dw 0x3040, 0xc93c,	0x307f, 0xc93c,		0x21, 0
	.dw 0x30c0, 0xc93c,	0x30ff, 0xc93c,		0x21, 0
	.dw 0x3140, 0xc93c,	0x317f, 0xc93c,		0x21, 0
	.dw 0x31c0, 0xc93c,	0x31ff, 0xc93c,		0x21, 0
	.dw 0x3240, 0xc93c,	0x327f, 0xc93c,		0x21, 0
	.dw 0x32c0, 0xc93c,	0x32ff, 0xc93c,		0x21, 0
	.dw 0x3340, 0xc93c,	0x337f, 0xc93c,		0x21, 0
	.dw 0x33c0, 0xc93c,	0x33ff, 0xc93c,		0x21, 0
	.dw 0x3440, 0xc93c,	0x347f, 0xc93c,		0x21, 0
	.dw 0x34c0, 0xc93c,	0x34ff, 0xc93c,		0x21, 0
	.dw 0x3540, 0xc93c,	0x357f, 0xc93c,		0x21, 0
	.dw 0x35c0, 0xc93c,	0x35ff, 0xc93c,		0x21, 0
	.dw 0x3640, 0xc93c,	0x367f, 0xc93c,		0x21, 0
	.dw 0x36c0, 0xc93c,	0x36ff, 0xc93c,		0x21, 0
	.dw 0x3740, 0xc93c,	0x377f, 0xc93c,		0x21, 0
	.dw 0x37c0, 0xc93c,	0x37ff, 0xc93c,		0x21, 0
	.dw 0x3840, 0xc93c,	0x387f, 0xc93c,		0x21, 0
	.dw 0x38c0, 0xc93c,	0x38ff, 0xc93c,		0x21, 0
	.dw 0x3940, 0xc93c,	0x397f, 0xc93c,		0x21, 0
	.dw 0x39c0, 0xc93c,	0x3fff, 0xc93c,		0x21, 0
	.dw 0x4040, 0xc93c,	0x407f, 0xc93c,		0x21, 0
	.dw 0x40c0, 0xc93c,	0x40ff, 0xc93c,		0x21, 0
	.dw 0x4140, 0xc93c,	0x417f, 0xc93c,		0x21, 0
	.dw 0x41c0, 0xc93c,	0x41ff, 0xc93c,		0x21, 0
	.dw 0x4240, 0xc93c,	0x427f, 0xc93c,		0x21, 0
	.dw 0x42c0, 0xc93c,	0x42ff, 0xc93c,		0x21, 0
	.dw 0x4340, 0xc93c,	0x437f, 0xc93c,		0x21, 0
	.dw 0x43c0, 0xc93c,	0x43ff, 0xc93c,		0x21, 0
	.dw 0x4440, 0xc93c,	0x447f, 0xc93c,		0x21, 0
	.dw 0x44c0, 0xc93c,	0x44ff, 0xc93c,		0x21, 0
	.dw 0x4540, 0xc93c,	0x457f, 0xc93c,		0x21, 0
	.dw 0x45c0, 0xc93c,	0x45ff, 0xc93c,		0x21, 0
	.dw 0x4640, 0xc93c,	0x467f, 0xc93c,		0x21, 0
	.dw 0x46c0, 0xc93c,	0x46ff, 0xc93c,		0x21, 0
	.dw 0x4740, 0xc93c,	0x477f, 0xc93c,		0x21, 0
	.dw 0x47c0, 0xc93c,	0x47ff, 0xc93c,		0x21, 0
	.dw 0x4840, 0xc93c,	0x487f, 0xc93c,		0x21, 0
	.dw 0x48c0, 0xc93c,	0x48ff, 0xc93c,		0x21, 0
	.dw 0x4940, 0xc93c,	0x497f, 0xc93c,		0x21, 0
	.dw 0x49c0, 0xc93c,	0x49ff, 0xc93c,		0x21, 0
	.dw 0x4a40, 0xc93c,	0x4a7f, 0xc93c,		0x21, 0
	.dw 0x4ac0, 0xc93c,	0x4aff, 0xc93c,		0x21, 0
	.dw 0x4b40, 0xc93c,	0x4b7f, 0xc93c,		0x21, 0
	.dw 0x4bc0, 0xc93c,	0x4bff, 0xc93c,		0x21, 0
	.dw 0x4c40, 0xc93c,	0x4c7f, 0xc93c,		0x21, 0
	.dw 0x4cc0, 0xc93c,	0x4cff, 0xc93c,		0x21, 0
	.dw 0x4d40, 0xc93c,	0x4d7f, 0xc93c,		0x21, 0
	.dw 0x4dc0, 0xc93c,	0x4dff, 0xc93c,		0x21, 0
	.dw 0x4e40, 0xc93c,	0x4e7f, 0xc93c,		0x21, 0
	.dw 0x4ec0, 0xc93c,	0x4eff, 0xc93c,		0x21, 0
	.dw 0x4f40, 0xc93c,	0x4f7f, 0xc93c,		0x21, 0
	.dw 0x4fc0, 0xc93c,	0x4fff, 0xc93c,		0x21, 0
	.dw 0x5040, 0xc93c,	0x507f, 0xc93c,		0x21, 0
	.dw 0x50c0, 0xc93c,	0x50ff, 0xc93c,		0x21, 0
	.dw 0x5140, 0xc93c,	0x517f, 0xc93c,		0x21, 0
	.dw 0x51c0, 0xc93c,	0x51ff, 0xc93c,		0x21, 0
	.dw 0x5240, 0xc93c,	0x527f, 0xc93c,		0x21, 0
	.dw 0x52c0, 0xc93c,	0x52ff, 0xc93c,		0x21, 0
	.dw 0x5340, 0xc93c,	0x537f, 0xc93c,		0x21, 0
	.dw 0x53c0, 0xc93c,	0x53ff, 0xc93c,		0x21, 0
	.dw 0x5440, 0xc93c,	0x547f, 0xc93c,		0x21, 0
	.dw 0x54c0, 0xc93c,	0x54ff, 0xc93c,		0x21, 0
	.dw 0x5540, 0xc93c,	0x557f, 0xc93c,		0x21, 0
	.dw 0x55c0, 0xc93c,	0x55ff, 0xc93c,		0x21, 0
	.dw 0x5640, 0xc93c,	0x567f, 0xc93c,		0x21, 0
	.dw 0x56c0, 0xc93c,	0x56ff, 0xc93c,		0x21, 0
	.dw 0x5740, 0xc93c,	0x577f, 0xc93c,		0x21, 0
	.dw 0x57c0, 0xc93c,	0x57ff, 0xc93c,		0x21, 0
	.dw 0x5840, 0xc93c,	0x587f, 0xc93c,		0x21, 0
	.dw 0x58c0, 0xc93c,	0x58ff, 0xc93c,		0x21, 0
	.dw 0x5940, 0xc93c,	0x597f, 0xc93c,		0x21, 0
	.dw 0x59c0, 0xc93c,	0x5fff, 0xc93c,		0x21, 0
	.dw 0x6040, 0xc93c,	0x607f, 0xc93c,		0x21, 0
	.dw 0x60c0, 0xc93c,	0x60ff, 0xc93c,		0x21, 0
	.dw 0x6140, 0xc93c,	0x617f, 0xc93c,		0x21, 0
	.dw 0x61c0, 0xc93c,	0x61ff, 0xc93c,		0x21, 0
	.dw 0x6240, 0xc93c,	0x627f, 0xc93c,		0x21, 0
	.dw 0x62c0, 0xc93c,	0x62ff, 0xc93c,		0x21, 0
	.dw 0x6340, 0xc93c,	0x637f, 0xc93c,		0x21, 0
	.dw 0x63c0, 0xc93c,	0x63ff, 0xc93c,		0x21, 0
	.dw 0x6440, 0xc93c,	0x647f, 0xc93c,		0x21, 0
	.dw 0x64c0, 0xc93c,	0x64ff, 0xc93c,		0x21, 0
	.dw 0x6540, 0xc93c,	0x657f, 0xc93c,		0x21, 0
	.dw 0x65c0, 0xc93c,	0x65ff, 0xc93c,		0x21, 0
	.dw 0x6640, 0xc93c,	0x667f, 0xc93c,		0x21, 0
	.dw 0x66c0, 0xc93c,	0x66ff, 0xc93c,		0x21, 0
	.dw 0x6740, 0xc93c,	0x677f, 0xc93c,		0x21, 0
	.dw 0x67c0, 0xc93c,	0x67ff, 0xc93c,		0x21, 0
	.dw 0x6840, 0xc93c,	0x687f, 0xc93c,		0x21, 0
	.dw 0x68c0, 0xc93c,	0x68ff, 0xc93c,		0x21, 0
	.dw 0x6940, 0xc93c,	0x697f, 0xc93c,		0x21, 0
	.dw 0x69c0, 0xc93c,	0x69ff, 0xc93c,		0x21, 0
	.dw 0x6a40, 0xc93c,	0x6a7f, 0xc93c,		0x21, 0
	.dw 0x6ac0, 0xc93c,	0x6aff, 0xc93c,		0x21, 0
	.dw 0x6b40, 0xc93c,	0x6b7f, 0xc93c,		0x21, 0
	.dw 0x6bc0, 0xc93c,	0x6bff, 0xc93c,		0x21, 0
	.dw 0x6c40, 0xc93c,	0x6c7f, 0xc93c,		0x21, 0
	.dw 0x6cc0, 0xc93c,	0x6cff, 0xc93c,		0x21, 0
	.dw 0x6d40, 0xc93c,	0x6d7f, 0xc93c,		0x21, 0
	.dw 0x6dc0, 0xc93c,	0x6dff, 0xc93c,		0x21, 0
	.dw 0x6e40, 0xc93c,	0x6e7f, 0xc93c,		0x21, 0
	.dw 0x6ec0, 0xc93c,	0x6eff, 0xc93c,		0x21, 0
	.dw 0x6f40, 0xc93c,	0x6f7f, 0xc93c,		0x21, 0
	.dw 0x6fc0, 0xc93c,	0x6fff, 0xc93c,		0x21, 0
	.dw 0x7040, 0xc93c,	0x707f, 0xc93c,		0x21, 0
	.dw 0x70c0, 0xc93c,	0x70ff, 0xc93c,		0x21, 0
	.dw 0x7140, 0xc93c,	0x717f, 0xc93c,		0x21, 0
	.dw 0x71c0, 0xc93c,	0x71ff, 0xc93c,		0x21, 0
	.dw 0x7240, 0xc93c,	0x727f, 0xc93c,		0x21, 0
	.dw 0x72c0, 0xc93c,	0x72ff, 0xc93c,		0x21, 0
	.dw 0x7340, 0xc93c,	0x737f, 0xc93c,		0x21, 0
	.dw 0x73c0, 0xc93c,	0x73ff, 0xc93c,		0x21, 0
	.dw 0x7440, 0xc93c,	0x747f, 0xc93c,		0x21, 0
	.dw 0x74c0, 0xc93c,	0x74ff, 0xc93c,		0x21, 0
	.dw 0x7540, 0xc93c,	0x757f, 0xc93c,		0x21, 0
	.dw 0x75c0, 0xc93c,	0x75ff, 0xc93c,		0x21, 0
	.dw 0x7640, 0xc93c,	0x767f, 0xc93c,		0x21, 0
	.dw 0x76c0, 0xc93c,	0x76ff, 0xc93c,		0x21, 0
	.dw 0x7740, 0xc93c,	0x777f, 0xc93c,		0x21, 0
	.dw 0x77c0, 0xc93c,	0x77ff, 0xc93c,		0x21, 0
	.dw 0x7840, 0xc93c,	0x787f, 0xc93c,		0x21, 0
	.dw 0x78c0, 0xc93c,	0x78ff, 0xc93c,		0x21, 0
	.dw 0x7940, 0xc93c,	0x797f, 0xc93c,		0x21, 0
	.dw 0x79c0, 0xc93c,	0x7fff, 0xc93c,		0x21, 0
	.dw 0x8040, 0xc93c,	0x807f, 0xc93c,		0x21, 0
	.dw 0x80c0, 0xc93c,	0x80ff, 0xc93c,		0x21, 0
	.dw 0x8140, 0xc93c,	0x817f, 0xc93c,		0x21, 0
	.dw 0x81c0, 0xc93c,	0x81ff, 0xc93c,		0x21, 0
	.dw 0x8240, 0xc93c,	0x827f, 0xc93c,		0x21, 0
	.dw 0x82c0, 0xc93c,	0x82ff, 0xc93c,		0x21, 0
	.dw 0x8340, 0xc93c,	0x837f, 0xc93c,		0x21, 0
	.dw 0x83c0, 0xc93c,	0x83ff, 0xc93c,		0x21, 0
	.dw 0x8440, 0xc93c,	0x847f, 0xc93c,		0x21, 0
	.dw 0x84c0, 0xc93c,	0x84ff, 0xc93c,		0x21, 0
	.dw 0x8540, 0xc93c,	0x857f, 0xc93c,		0x21, 0
	.dw 0x85c0, 0xc93c,	0x85ff, 0xc93c,		0x21, 0
	.dw 0x8640, 0xc93c,	0x867f, 0xc93c,		0x21, 0
	.dw 0x86c0, 0xc93c,	0x86ff, 0xc93c,		0x21, 0
	.dw 0x8740, 0xc93c,	0x877f, 0xc93c,		0x21, 0
	.dw 0x87c0, 0xc93c,	0x87ff, 0xc93c,		0x21, 0
	.dw 0x8840, 0xc93c,	0x887f, 0xc93c,		0x21, 0
	.dw 0x88c0, 0xc93c,	0x88ff, 0xc93c,		0x21, 0
	.dw 0x8940, 0xc93c,	0x897f, 0xc93c,		0x21, 0
	.dw 0x89c0, 0xc93c,	0x89ff, 0xc93c,		0x21, 0
	.dw 0x8a40, 0xc93c,	0x8a7f, 0xc93c,		0x21, 0
	.dw 0x8ac0, 0xc93c,	0x8aff, 0xc93c,		0x21, 0
	.dw 0x8b40, 0xc93c,	0x8b7f, 0xc93c,		0x21, 0
	.dw 0x8bc0, 0xc93c,	0x8bff, 0xc93c,		0x21, 0
	.dw 0x8c40, 0xc93c,	0x8c7f, 0xc93c,		0x21, 0
	.dw 0x8cc0, 0xc93c,	0x8cff, 0xc93c,		0x21, 0
	.dw 0x8d40, 0xc93c,	0x8d7f, 0xc93c,		0x21, 0
	.dw 0x8dc0, 0xc93c,	0x8dff, 0xc93c,		0x21, 0
	.dw 0x8e40, 0xc93c,	0x8e7f, 0xc93c,		0x21, 0
	.dw 0x8ec0, 0xc93c,	0x8eff, 0xc93c,		0x21, 0
	.dw 0x8f40, 0xc93c,	0x8f7f, 0xc93c,		0x21, 0
	.dw 0x8fc0, 0xc93c,	0x8fff, 0xc93c,		0x21, 0
	.dw 0x9040, 0xc93c,	0x907f, 0xc93c,		0x21, 0
	.dw 0x90c0, 0xc93c,	0x90ff, 0xc93c,		0x21, 0
	.dw 0x9140, 0xc93c,	0x917f, 0xc93c,		0x21, 0
	.dw 0x91c0, 0xc93c,	0x91ff, 0xc93c,		0x21, 0
	.dw 0x9240, 0xc93c,	0x927f, 0xc93c,		0x21, 0
	.dw 0x92c0, 0xc93c,	0x92ff, 0xc93c,		0x21, 0
	.dw 0x9340, 0xc93c,	0x937f, 0xc93c,		0x21, 0
	.dw 0x93c0, 0xc93c,	0x93ff, 0xc93c,		0x21, 0
	.dw 0x9440, 0xc93c,	0x947f, 0xc93c,		0x21, 0
	.dw 0x94c0, 0xc93c,	0x94ff, 0xc93c,		0x21, 0
	.dw 0x9540, 0xc93c,	0x957f, 0xc93c,		0x21, 0
	.dw 0x95c0, 0xc93c,	0x95ff, 0xc93c,		0x21, 0
	.dw 0x9640, 0xc93c,	0x967f, 0xc93c,		0x21, 0
	.dw 0x96c0, 0xc93c,	0x96ff, 0xc93c,		0x21, 0
	.dw 0x9740, 0xc93c,	0x977f, 0xc93c,		0x21, 0
	.dw 0x97c0, 0xc93c,	0x97ff, 0xc93c,		0x21, 0
	.dw 0x9840, 0xc93c,	0x987f, 0xc93c,		0x21, 0
	.dw 0x98c0, 0xc93c,	0x98ff, 0xc93c,		0x21, 0
	.dw 0x9940, 0xc93c,	0x997f, 0xc93c,		0x21, 0
	.dw 0x99c0, 0xc93c,	0x9fff, 0xc93c,		0x21, 0
	.dw 0xa040, 0xc93c,	0xa07f, 0xc93c,		0x21, 0
	.dw 0xa0c0, 0xc93c,	0xa0ff, 0xc93c,		0x21, 0
	.dw 0xa140, 0xc93c,	0xa17f, 0xc93c,		0x21, 0
	.dw 0xa1c0, 0xc93c,	0xa1ff, 0xc93c,		0x21, 0
	.dw 0xa240, 0xc93c,	0xa27f, 0xc93c,		0x21, 0
	.dw 0xa2c0, 0xc93c,	0xa2ff, 0xc93c,		0x21, 0
	.dw 0xa340, 0xc93c,	0xa37f, 0xc93c,		0x21, 0
	.dw 0xa3c0, 0xc93c,	0xa3ff, 0xc93c,		0x21, 0
	.dw 0xa440, 0xc93c,	0xa47f, 0xc93c,		0x21, 0
	.dw 0xa4c0, 0xc93c,	0xa4ff, 0xc93c,		0x21, 0
	.dw 0xa540, 0xc93c,	0xa57f, 0xc93c,		0x21, 0
	.dw 0xa5c0, 0xc93c,	0xa5ff, 0xc93c,		0x21, 0
	.dw 0xa640, 0xc93c,	0xa67f, 0xc93c,		0x21, 0
	.dw 0xa6c0, 0xc93c,	0xa6ff, 0xc93c,		0x21, 0
	.dw 0xa740, 0xc93c,	0xa77f, 0xc93c,		0x21, 0
	.dw 0xa7c0, 0xc93c,	0xa7ff, 0xc93c,		0x21, 0
	.dw 0xa840, 0xc93c,	0xa87f, 0xc93c,		0x21, 0
	.dw 0xa8c0, 0xc93c,	0xa8ff, 0xc93c,		0x21, 0
	.dw 0xa940, 0xc93c,	0xa97f, 0xc93c,		0x21, 0
	.dw 0xa9c0, 0xc93c,	0xa9ff, 0xc93c,		0x21, 0
	.dw 0xaa40, 0xc93c,	0xaa7f, 0xc93c,		0x21, 0
	.dw 0xaac0, 0xc93c,	0xaaff, 0xc93c,		0x21, 0
	.dw 0xab40, 0xc93c,	0xab7f, 0xc93c,		0x21, 0
	.dw 0xabc0, 0xc93c,	0xabff, 0xc93c,		0x21, 0
	.dw 0xac40, 0xc93c,	0xac7f, 0xc93c,		0x21, 0
	.dw 0xacc0, 0xc93c,	0xacff, 0xc93c,		0x21, 0
	.dw 0xad40, 0xc93c,	0xad7f, 0xc93c,		0x21, 0
	.dw 0xadc0, 0xc93c,	0xadff, 0xc93c,		0x21, 0
	.dw 0xae40, 0xc93c,	0xae7f, 0xc93c,		0x21, 0
	.dw 0xaec0, 0xc93c,	0xaeff, 0xc93c,		0x21, 0
	.dw 0xaf40, 0xc93c,	0xaf7f, 0xc93c,		0x21, 0
	.dw 0xafc0, 0xc93c,	0xafff, 0xc93c,		0x21, 0
	.dw 0xb040, 0xc93c,	0xb07f, 0xc93c,		0x21, 0
	.dw 0xb0c0, 0xc93c,	0xb0ff, 0xc93c,		0x21, 0
	.dw 0xb140, 0xc93c,	0xb17f, 0xc93c,		0x21, 0
	.dw 0xb1c0, 0xc93c,	0xb1ff, 0xc93c,		0x21, 0
	.dw 0xb240, 0xc93c,	0xb27f, 0xc93c,		0x21, 0
	.dw 0xb2c0, 0xc93c,	0xb2ff, 0xc93c,		0x21, 0
	.dw 0xb340, 0xc93c,	0xb37f, 0xc93c,		0x21, 0
	.dw 0xb3c0, 0xc93c,	0xb3ff, 0xc93c,		0x21, 0
	.dw 0xb440, 0xc93c,	0xb47f, 0xc93c,		0x21, 0
	.dw 0xb4c0, 0xc93c,	0xb4ff, 0xc93c,		0x21, 0
	.dw 0xb540, 0xc93c,	0xb57f, 0xc93c,		0x21, 0
	.dw 0xb5c0, 0xc93c,	0xb5ff, 0xc93c,		0x21, 0
	.dw 0xb640, 0xc93c,	0xb67f, 0xc93c,		0x21, 0
	.dw 0xb6c0, 0xc93c,	0xb6ff, 0xc93c,		0x21, 0
	.dw 0xb740, 0xc93c,	0xb77f, 0xc93c,		0x21, 0
	.dw 0xb7c0, 0xc93c,	0xb7ff, 0xc93c,		0x21, 0
	.dw 0xb840, 0xc93c,	0xb87f, 0xc93c,		0x21, 0
	.dw 0xb8c0, 0xc93c,	0xb8ff, 0xc93c,		0x21, 0
	.dw 0xb940, 0xc93c,	0xb97f, 0xc93c,		0x21, 0
	.dw 0xb9c0, 0xc93c,	0xbfff, 0xc93c,		0x21, 0
	.dw 0xc040, 0xc93c,	0xc07f, 0xc93c,		0x21, 0
	.dw 0xc0c0, 0xc93c,	0xc0ff, 0xc93c,		0x21, 0
	.dw 0xc140, 0xc93c,	0xc17f, 0xc93c,		0x21, 0
	.dw 0xc1c0, 0xc93c,	0xc1ff, 0xc93c,		0x21, 0
	.dw 0xc240, 0xc93c,	0xc27f, 0xc93c,		0x21, 0
	.dw 0xc2c0, 0xc93c,	0xc2ff, 0xc93c,		0x21, 0
	.dw 0xc340, 0xc93c,	0xc37f, 0xc93c,		0x21, 0
	.dw 0xc3c0, 0xc93c,	0xc3ff, 0xc93c,		0x21, 0
	.dw 0xc440, 0xc93c,	0xc47f, 0xc93c,		0x21, 0
	.dw 0xc4c0, 0xc93c,	0xc4ff, 0xc93c,		0x21, 0
	.dw 0xc540, 0xc93c,	0xc57f, 0xc93c,		0x21, 0
	.dw 0xc5c0, 0xc93c,	0xc5ff, 0xc93c,		0x21, 0
	.dw 0xc640, 0xc93c,	0xc67f, 0xc93c,		0x21, 0
	.dw 0xc6c0, 0xc93c,	0xc6ff, 0xc93c,		0x21, 0
	.dw 0xc740, 0xc93c,	0xc77f, 0xc93c,		0x21, 0
	.dw 0xc7c0, 0xc93c,	0xc7ff, 0xc93c,		0x21, 0
	.dw 0xc840, 0xc93c,	0xc87f, 0xc93c,		0x21, 0
	.dw 0xc8c0, 0xc93c,	0xc8ff, 0xc93c,		0x21, 0
	.dw 0xc940, 0xc93c,	0xc97f, 0xc93c,		0x21, 0
	.dw 0xc9c0, 0xc93c,	0xc9ff, 0xc93c,		0x21, 0
	.dw 0xca40, 0xc93c,	0xca7f, 0xc93c,		0x21, 0
	.dw 0xcac0, 0xc93c,	0xcaff, 0xc93c,		0x21, 0
	.dw 0xcb40, 0xc93c,	0xcb7f, 0xc93c,		0x21, 0
	.dw 0xcbc0, 0xc93c,	0xcbff, 0xc93c,		0x21, 0
	.dw 0xcc40, 0xc93c,	0xcc7f, 0xc93c,		0x21, 0
	.dw 0xccc0, 0xc93c,	0xccff, 0xc93c,		0x21, 0
	.dw 0xcd40, 0xc93c,	0xcd7f, 0xc93c,		0x21, 0
	.dw 0xcdc0, 0xc93c,	0xcdff, 0xc93c,		0x21, 0
	.dw 0xce40, 0xc93c,	0xce7f, 0xc93c,		0x21, 0
	.dw 0xcec0, 0xc93c,	0xceff, 0xc93c,		0x21, 0
	.dw 0xcf40, 0xc93c,	0xcf7f, 0xc93c,		0x21, 0
	.dw 0xcfc0, 0xc93c,	0xcfff, 0xc93c,		0x21, 0
	.dw 0xd040, 0xc93c,	0xd07f, 0xc93c,		0x21, 0
	.dw 0xd0c0, 0xc93c,	0xd0ff, 0xc93c,		0x21, 0
	.dw 0xd140, 0xc93c,	0xd17f, 0xc93c,		0x21, 0
	.dw 0xd1c0, 0xc93c,	0xd1ff, 0xc93c,		0x21, 0
	.dw 0xd240, 0xc93c,	0xd27f, 0xc93c,		0x21, 0
	.dw 0xd2c0, 0xc93c,	0xd2ff, 0xc93c,		0x21, 0
	.dw 0xd340, 0xc93c,	0xd37f, 0xc93c,		0x21, 0
	.dw 0xd3c0, 0xc93c,	0xd3ff, 0xc93c,		0x21, 0
	.dw 0xd440, 0xc93c,	0xd47f, 0xc93c,		0x21, 0
	.dw 0xd4c0, 0xc93c,	0xd4ff, 0xc93c,		0x21, 0
	.dw 0xd540, 0xc93c,	0xd57f, 0xc93c,		0x21, 0
	.dw 0xd5c0, 0xc93c,	0xd5ff, 0xc93c,		0x21, 0
	.dw 0xd640, 0xc93c,	0xd67f, 0xc93c,		0x21, 0
	.dw 0xd6c0, 0xc93c,	0xd6ff, 0xc93c,		0x21, 0
	.dw 0xd740, 0xc93c,	0xd77f, 0xc93c,		0x21, 0
	.dw 0xd7c0, 0xc93c,	0xd7ff, 0xc93c,		0x21, 0
	.dw 0xd840, 0xc93c,	0xd87f, 0xc93c,		0x21, 0
	.dw 0xd8c0, 0xc93c,	0xd8ff, 0xc93c,		0x21, 0
	.dw 0xd940, 0xc93c,	0xd97f, 0xc93c,		0x21, 0
	.dw 0xd9c0, 0xc93c,	0xdfff, 0xc93c,		0x21, 0
	.dw 0xe040, 0xc93c,	0xe07f, 0xc93c,		0x21, 0
	.dw 0xe0c0, 0xc93c,	0xe0ff, 0xc93c,		0x21, 0
	.dw 0xe140, 0xc93c,	0xe17f, 0xc93c,		0x21, 0
	.dw 0xe1c0, 0xc93c,	0xe1ff, 0xc93c,		0x21, 0
	.dw 0xe240, 0xc93c,	0xe27f, 0xc93c,		0x21, 0
	.dw 0xe2c0, 0xc93c,	0xe2ff, 0xc93c,		0x21, 0
	.dw 0xe340, 0xc93c,	0xe37f, 0xc93c,		0x21, 0
	.dw 0xe3c0, 0xc93c,	0xe3ff, 0xc93c,		0x21, 0
	.dw 0xe440, 0xc93c,	0xe47f, 0xc93c,		0x21, 0
	.dw 0xe4c0, 0xc93c,	0xe4ff, 0xc93c,		0x21, 0
	.dw 0xe540, 0xc93c,	0xe57f, 0xc93c,		0x21, 0
	.dw 0xe5c0, 0xc93c,	0xe5ff, 0xc93c,		0x21, 0
	.dw 0xe640, 0xc93c,	0xe67f, 0xc93c,		0x21, 0
	.dw 0xe6c0, 0xc93c,	0xe6ff, 0xc93c,		0x21, 0
	.dw 0xe740, 0xc93c,	0xe77f, 0xc93c,		0x21, 0
	.dw 0xe7c0, 0xc93c,	0xe7ff, 0xc93c,		0x21, 0
	.dw 0xe840, 0xc93c,	0xe87f, 0xc93c,		0x21, 0
	.dw 0xe8c0, 0xc93c,	0xe8ff, 0xc93c,		0x21, 0
	.dw 0xe940, 0xc93c,	0xe97f, 0xc93c,		0x21, 0
	.dw 0xe9c0, 0xc93c,	0xe9ff, 0xc93c,		0x21, 0
	.dw 0xea40, 0xc93c,	0xea7f, 0xc93c,		0x21, 0
	.dw 0xeac0, 0xc93c,	0xeaff, 0xc93c,		0x21, 0
	.dw 0xeb40, 0xc93c,	0xeb7f, 0xc93c,		0x21, 0
	.dw 0xebc0, 0xc93c,	0xebff, 0xc93c,		0x21, 0
	.dw 0xec40, 0xc93c,	0xec7f, 0xc93c,		0x21, 0
	.dw 0xecc0, 0xc93c,	0xecff, 0xc93c,		0x21, 0
	.dw 0xed40, 0xc93c,	0xed7f, 0xc93c,		0x21, 0
	.dw 0xedc0, 0xc93c,	0xedff, 0xc93c,		0x21, 0
	.dw 0xee40, 0xc93c,	0xee7f, 0xc93c,		0x21, 0
	.dw 0xeec0, 0xc93c,	0xeeff, 0xc93c,		0x21, 0
	.dw 0xef40, 0xc93c,	0xef7f, 0xc93c,		0x21, 0
	.dw 0xefc0, 0xc93c,	0xefff, 0xc93c,		0x21, 0
	.dw 0xf040, 0xc93c,	0xf07f, 0xc93c,		0x21, 0
	.dw 0xf0c0, 0xc93c,	0xf0ff, 0xc93c,		0x21, 0
	.dw 0xf140, 0xc93c,	0xf17f, 0xc93c,		0x21, 0
	.dw 0xf1c0, 0xc93c,	0xf1ff, 0xc93c,		0x21, 0
	.dw 0xf240, 0xc93c,	0xf27f, 0xc93c,		0x21, 0
	.dw 0xf2c0, 0xc93c,	0xf2ff, 0xc93c,		0x21, 0
	.dw 0xf340, 0xc93c,	0xf37f, 0xc93c,		0x21, 0
	.dw 0xf3c0, 0xc93c,	0xf3ff, 0xc93c,		0x21, 0
	.dw 0xf440, 0xc93c,	0xf47f, 0xc93c,		0x21, 0
	.dw 0xf4c0, 0xc93c,	0xf4ff, 0xc93c,		0x21, 0
	.dw 0xf540, 0xc93c,	0xf57f, 0xc93c,		0x21, 0
	.dw 0xf5c0, 0xc93c,	0xf5ff, 0xc93c,		0x21, 0
	.dw 0xf640, 0xc93c,	0xf67f, 0xc93c,		0x21, 0
	.dw 0xf6c0, 0xc93c,	0xf6ff, 0xc93c,		0x21, 0
	.dw 0xf740, 0xc93c,	0xf77f, 0xc93c,		0x21, 0
	.dw 0xf7c0, 0xc93c,	0xf7ff, 0xc93c,		0x21, 0
	.dw 0xf840, 0xc93c,	0xf87f, 0xc93c,		0x21, 0
	.dw 0xf8c0, 0xc93c,	0xf8ff, 0xc93c,		0x21, 0
	.dw 0xf940, 0xc93c,	0xf97f, 0xc93c,		0x21, 0
	.dw 0xf9c0, 0xc93c,	0xffff, 0xc93c,		0x21, 0
	.dw 0x0040, 0xc93d,	0x007f, 0xc93d,		0x21, 0
	.dw 0x00c0, 0xc93d,	0x00ff, 0xc93d,		0x21, 0
	.dw 0x0140, 0xc93d,	0x017f, 0xc93d,		0x21, 0
	.dw 0x01c0, 0xc93d,	0x01ff, 0xc93d,		0x21, 0
	.dw 0x0240, 0xc93d,	0x027f, 0xc93d,		0x21, 0
	.dw 0x02c0, 0xc93d,	0x02ff, 0xc93d,		0x21, 0
	.dw 0x0340, 0xc93d,	0x037f, 0xc93d,		0x21, 0
	.dw 0x03c0, 0xc93d,	0x03ff, 0xc93d,		0x21, 0
	.dw 0x0440, 0xc93d,	0x047f, 0xc93d,		0x21, 0
	.dw 0x04c0, 0xc93d,	0x04ff, 0xc93d,		0x21, 0
	.dw 0x0540, 0xc93d,	0x057f, 0xc93d,		0x21, 0
	.dw 0x05c0, 0xc93d,	0x05ff, 0xc93d,		0x21, 0
	.dw 0x0640, 0xc93d,	0x067f, 0xc93d,		0x21, 0
	.dw 0x06c0, 0xc93d,	0x06ff, 0xc93d,		0x21, 0
	.dw 0x0740, 0xc93d,	0x077f, 0xc93d,		0x21, 0
	.dw 0x07c0, 0xc93d,	0x07ff, 0xc93d,		0x21, 0
	.dw 0x0840, 0xc93d,	0x087f, 0xc93d,		0x21, 0
	.dw 0x08c0, 0xc93d,	0x08ff, 0xc93d,		0x21, 0
	.dw 0x0940, 0xc93d,	0x097f, 0xc93d,		0x21, 0
	.dw 0x09c0, 0xc93d,	0x09ff, 0xc93d,		0x21, 0
	.dw 0x0a40, 0xc93d,	0x0a7f, 0xc93d,		0x21, 0
	.dw 0x0ac0, 0xc93d,	0x0aff, 0xc93d,		0x21, 0
	.dw 0x0b40, 0xc93d,	0x0b7f, 0xc93d,		0x21, 0
	.dw 0x0bc0, 0xc93d,	0x0bff, 0xc93d,		0x21, 0
	.dw 0x0c40, 0xc93d,	0x0c7f, 0xc93d,		0x21, 0
	.dw 0x0cc0, 0xc93d,	0x0cff, 0xc93d,		0x21, 0
	.dw 0x0d40, 0xc93d,	0x0d7f, 0xc93d,		0x21, 0
	.dw 0x0dc0, 0xc93d,	0x0dff, 0xc93d,		0x21, 0
	.dw 0x0e40, 0xc93d,	0x0e7f, 0xc93d,		0x21, 0
	.dw 0x0ec0, 0xc93d,	0x0eff, 0xc93d,		0x21, 0
	.dw 0x0f40, 0xc93d,	0x0f7f, 0xc93d,		0x21, 0
	.dw 0x0fc0, 0xc93d,	0x0fff, 0xc93d,		0x21, 0
	.dw 0x1040, 0xc93d,	0x107f, 0xc93d,		0x21, 0
	.dw 0x10c0, 0xc93d,	0x10ff, 0xc93d,		0x21, 0
	.dw 0x1140, 0xc93d,	0x117f, 0xc93d,		0x21, 0
	.dw 0x11c0, 0xc93d,	0x11ff, 0xc93d,		0x21, 0
	.dw 0x1240, 0xc93d,	0x127f, 0xc93d,		0x21, 0
	.dw 0x12c0, 0xc93d,	0x12ff, 0xc93d,		0x21, 0
	.dw 0x1340, 0xc93d,	0x137f, 0xc93d,		0x21, 0
	.dw 0x13c0, 0xc93d,	0x13ff, 0xc93d,		0x21, 0
	.dw 0x1440, 0xc93d,	0x147f, 0xc93d,		0x21, 0
	.dw 0x14c0, 0xc93d,	0x14ff, 0xc93d,		0x21, 0
	.dw 0x1540, 0xc93d,	0x157f, 0xc93d,		0x21, 0
	.dw 0x15c0, 0xc93d,	0x15ff, 0xc93d,		0x21, 0
	.dw 0x1640, 0xc93d,	0x167f, 0xc93d,		0x21, 0
	.dw 0x16c0, 0xc93d,	0x16ff, 0xc93d,		0x21, 0
	.dw 0x1740, 0xc93d,	0x177f, 0xc93d,		0x21, 0
	.dw 0x17c0, 0xc93d,	0x17ff, 0xc93d,		0x21, 0
	.dw 0x1840, 0xc93d,	0x187f, 0xc93d,		0x21, 0
	.dw 0x18c0, 0xc93d,	0x18ff, 0xc93d,		0x21, 0
	.dw 0x1940, 0xc93d,	0x197f, 0xc93d,		0x21, 0
	.dw 0x19c0, 0xc93d,	0x1fff, 0xc93d,		0x21, 0
	.dw 0x2040, 0xc93d,	0x207f, 0xc93d,		0x21, 0
	.dw 0x20c0, 0xc93d,	0x20ff, 0xc93d,		0x21, 0
	.dw 0x2140, 0xc93d,	0x217f, 0xc93d,		0x21, 0
	.dw 0x21c0, 0xc93d,	0x21ff, 0xc93d,		0x21, 0
	.dw 0x2240, 0xc93d,	0x227f, 0xc93d,		0x21, 0
	.dw 0x22c0, 0xc93d,	0x22ff, 0xc93d,		0x21, 0
	.dw 0x2340, 0xc93d,	0x237f, 0xc93d,		0x21, 0
	.dw 0x23c0, 0xc93d,	0x23ff, 0xc93d,		0x21, 0
	.dw 0x2440, 0xc93d,	0x247f, 0xc93d,		0x21, 0
	.dw 0x24c0, 0xc93d,	0x24ff, 0xc93d,		0x21, 0
	.dw 0x2540, 0xc93d,	0x257f, 0xc93d,		0x21, 0
	.dw 0x25c0, 0xc93d,	0x25ff, 0xc93d,		0x21, 0
	.dw 0x2640, 0xc93d,	0x267f, 0xc93d,		0x21, 0
	.dw 0x26c0, 0xc93d,	0x26ff, 0xc93d,		0x21, 0
	.dw 0x2740, 0xc93d,	0x277f, 0xc93d,		0x21, 0
	.dw 0x27c0, 0xc93d,	0x27ff, 0xc93d,		0x21, 0
	.dw 0x2840, 0xc93d,	0x287f, 0xc93d,		0x21, 0
	.dw 0x28c0, 0xc93d,	0x28ff, 0xc93d,		0x21, 0
	.dw 0x2940, 0xc93d,	0x297f, 0xc93d,		0x21, 0
	.dw 0x29c0, 0xc93d,	0x29ff, 0xc93d,		0x21, 0
	.dw 0x2a40, 0xc93d,	0x2a7f, 0xc93d,		0x21, 0
	.dw 0x2ac0, 0xc93d,	0x2aff, 0xc93d,		0x21, 0
	.dw 0x2b40, 0xc93d,	0x2b7f, 0xc93d,		0x21, 0
	.dw 0x2bc0, 0xc93d,	0x2bff, 0xc93d,		0x21, 0
	.dw 0x2c40, 0xc93d,	0x2c7f, 0xc93d,		0x21, 0
	.dw 0x2cc0, 0xc93d,	0x2cff, 0xc93d,		0x21, 0
	.dw 0x2d40, 0xc93d,	0x2d7f, 0xc93d,		0x21, 0
	.dw 0x2dc0, 0xc93d,	0x2dff, 0xc93d,		0x21, 0
	.dw 0x2e40, 0xc93d,	0x2e7f, 0xc93d,		0x21, 0
	.dw 0x2ec0, 0xc93d,	0x2eff, 0xc93d,		0x21, 0
	.dw 0x2f40, 0xc93d,	0x2f7f, 0xc93d,		0x21, 0
	.dw 0x2fc0, 0xc93d,	0x2fff, 0xc93d,		0x21, 0
	.dw 0x3040, 0xc93d,	0x307f, 0xc93d,		0x21, 0
	.dw 0x30c0, 0xc93d,	0x30ff, 0xc93d,		0x21, 0
	.dw 0x3140, 0xc93d,	0x317f, 0xc93d,		0x21, 0
	.dw 0x31c0, 0xc93d,	0x31ff, 0xc93d,		0x21, 0
	.dw 0x3240, 0xc93d,	0x327f, 0xc93d,		0x21, 0
	.dw 0x32c0, 0xc93d,	0x32ff, 0xc93d,		0x21, 0
	.dw 0x3340, 0xc93d,	0x337f, 0xc93d,		0x21, 0
	.dw 0x33c0, 0xc93d,	0x33ff, 0xc93d,		0x21, 0
	.dw 0x3440, 0xc93d,	0x347f, 0xc93d,		0x21, 0
	.dw 0x34c0, 0xc93d,	0x34ff, 0xc93d,		0x21, 0
	.dw 0x3540, 0xc93d,	0x357f, 0xc93d,		0x21, 0
	.dw 0x35c0, 0xc93d,	0x35ff, 0xc93d,		0x21, 0
	.dw 0x3640, 0xc93d,	0x367f, 0xc93d,		0x21, 0
	.dw 0x36c0, 0xc93d,	0x36ff, 0xc93d,		0x21, 0
	.dw 0x3740, 0xc93d,	0x377f, 0xc93d,		0x21, 0
	.dw 0x37c0, 0xc93d,	0x37ff, 0xc93d,		0x21, 0
	.dw 0x3840, 0xc93d,	0x387f, 0xc93d,		0x21, 0
	.dw 0x38c0, 0xc93d,	0x38ff, 0xc93d,		0x21, 0
	.dw 0x3940, 0xc93d,	0x397f, 0xc93d,		0x21, 0
	.dw 0x39c0, 0xc93d,	0x3fff, 0xc93d,		0x21, 0
	.dw 0x4040, 0xc93d,	0x407f, 0xc93d,		0x21, 0
	.dw 0x40c0, 0xc93d,	0x40ff, 0xc93d,		0x21, 0
	.dw 0x4140, 0xc93d,	0x417f, 0xc93d,		0x21, 0
	.dw 0x41c0, 0xc93d,	0x41ff, 0xc93d,		0x21, 0
	.dw 0x4240, 0xc93d,	0x427f, 0xc93d,		0x21, 0
	.dw 0x42c0, 0xc93d,	0x42ff, 0xc93d,		0x21, 0
	.dw 0x4340, 0xc93d,	0x437f, 0xc93d,		0x21, 0
	.dw 0x43c0, 0xc93d,	0x43ff, 0xc93d,		0x21, 0
	.dw 0x4440, 0xc93d,	0x447f, 0xc93d,		0x21, 0
	.dw 0x44c0, 0xc93d,	0x44ff, 0xc93d,		0x21, 0
	.dw 0x4540, 0xc93d,	0x457f, 0xc93d,		0x21, 0
	.dw 0x45c0, 0xc93d,	0x45ff, 0xc93d,		0x21, 0
	.dw 0x4640, 0xc93d,	0x467f, 0xc93d,		0x21, 0
	.dw 0x46c0, 0xc93d,	0x46ff, 0xc93d,		0x21, 0
	.dw 0x4740, 0xc93d,	0x477f, 0xc93d,		0x21, 0
	.dw 0x47c0, 0xc93d,	0x47ff, 0xc93d,		0x21, 0
	.dw 0x4840, 0xc93d,	0x487f, 0xc93d,		0x21, 0
	.dw 0x48c0, 0xc93d,	0x48ff, 0xc93d,		0x21, 0
	.dw 0x4940, 0xc93d,	0x497f, 0xc93d,		0x21, 0
	.dw 0x49c0, 0xc93d,	0x49ff, 0xc93d,		0x21, 0
	.dw 0x4a40, 0xc93d,	0x4a7f, 0xc93d,		0x21, 0
	.dw 0x4ac0, 0xc93d,	0x4aff, 0xc93d,		0x21, 0
	.dw 0x4b40, 0xc93d,	0x4b7f, 0xc93d,		0x21, 0
	.dw 0x4bc0, 0xc93d,	0x4bff, 0xc93d,		0x21, 0
	.dw 0x4c40, 0xc93d,	0x4c7f, 0xc93d,		0x21, 0
	.dw 0x4cc0, 0xc93d,	0x4cff, 0xc93d,		0x21, 0
	.dw 0x4d40, 0xc93d,	0x4d7f, 0xc93d,		0x21, 0
	.dw 0x4dc0, 0xc93d,	0x4dff, 0xc93d,		0x21, 0
	.dw 0x4e40, 0xc93d,	0x4e7f, 0xc93d,		0x21, 0
	.dw 0x4ec0, 0xc93d,	0x4eff, 0xc93d,		0x21, 0
	.dw 0x4f40, 0xc93d,	0x4f7f, 0xc93d,		0x21, 0
	.dw 0x4fc0, 0xc93d,	0x4fff, 0xc93d,		0x21, 0
	.dw 0x5040, 0xc93d,	0x507f, 0xc93d,		0x21, 0
	.dw 0x50c0, 0xc93d,	0x50ff, 0xc93d,		0x21, 0
	.dw 0x5140, 0xc93d,	0x517f, 0xc93d,		0x21, 0
	.dw 0x51c0, 0xc93d,	0x51ff, 0xc93d,		0x21, 0
	.dw 0x5240, 0xc93d,	0x527f, 0xc93d,		0x21, 0
	.dw 0x52c0, 0xc93d,	0x52ff, 0xc93d,		0x21, 0
	.dw 0x5340, 0xc93d,	0x537f, 0xc93d,		0x21, 0
	.dw 0x53c0, 0xc93d,	0x53ff, 0xc93d,		0x21, 0
	.dw 0x5440, 0xc93d,	0x547f, 0xc93d,		0x21, 0
	.dw 0x54c0, 0xc93d,	0x54ff, 0xc93d,		0x21, 0
	.dw 0x5540, 0xc93d,	0x557f, 0xc93d,		0x21, 0
	.dw 0x55c0, 0xc93d,	0x55ff, 0xc93d,		0x21, 0
	.dw 0x5640, 0xc93d,	0x567f, 0xc93d,		0x21, 0
	.dw 0x56c0, 0xc93d,	0x56ff, 0xc93d,		0x21, 0
	.dw 0x5740, 0xc93d,	0x577f, 0xc93d,		0x21, 0
	.dw 0x57c0, 0xc93d,	0x57ff, 0xc93d,		0x21, 0
	.dw 0x5840, 0xc93d,	0x587f, 0xc93d,		0x21, 0
	.dw 0x58c0, 0xc93d,	0x58ff, 0xc93d,		0x21, 0
	.dw 0x5940, 0xc93d,	0x597f, 0xc93d,		0x21, 0
	.dw 0x59c0, 0xc93d,	0x5fff, 0xc93d,		0x21, 0
	.dw 0x6040, 0xc93d,	0x607f, 0xc93d,		0x21, 0
	.dw 0x60c0, 0xc93d,	0x60ff, 0xc93d,		0x21, 0
	.dw 0x6140, 0xc93d,	0x617f, 0xc93d,		0x21, 0
	.dw 0x61c0, 0xc93d,	0x61ff, 0xc93d,		0x21, 0
	.dw 0x6240, 0xc93d,	0x627f, 0xc93d,		0x21, 0
	.dw 0x62c0, 0xc93d,	0x62ff, 0xc93d,		0x21, 0
	.dw 0x6340, 0xc93d,	0x637f, 0xc93d,		0x21, 0
	.dw 0x63c0, 0xc93d,	0x63ff, 0xc93d,		0x21, 0
	.dw 0x6440, 0xc93d,	0x647f, 0xc93d,		0x21, 0
	.dw 0x64c0, 0xc93d,	0x64ff, 0xc93d,		0x21, 0
	.dw 0x6540, 0xc93d,	0x657f, 0xc93d,		0x21, 0
	.dw 0x65c0, 0xc93d,	0x65ff, 0xc93d,		0x21, 0
	.dw 0x6640, 0xc93d,	0x667f, 0xc93d,		0x21, 0
	.dw 0x66c0, 0xc93d,	0x66ff, 0xc93d,		0x21, 0
	.dw 0x6740, 0xc93d,	0x677f, 0xc93d,		0x21, 0
	.dw 0x67c0, 0xc93d,	0x67ff, 0xc93d,		0x21, 0
	.dw 0x6840, 0xc93d,	0x687f, 0xc93d,		0x21, 0
	.dw 0x68c0, 0xc93d,	0x68ff, 0xc93d,		0x21, 0
	.dw 0x6940, 0xc93d,	0x697f, 0xc93d,		0x21, 0
	.dw 0x69c0, 0xc93d,	0x69ff, 0xc93d,		0x21, 0
	.dw 0x6a40, 0xc93d,	0x6a7f, 0xc93d,		0x21, 0
	.dw 0x6ac0, 0xc93d,	0x6aff, 0xc93d,		0x21, 0
	.dw 0x6b40, 0xc93d,	0x6b7f, 0xc93d,		0x21, 0
	.dw 0x6bc0, 0xc93d,	0x6bff, 0xc93d,		0x21, 0
	.dw 0x6c40, 0xc93d,	0x6c7f, 0xc93d,		0x21, 0
	.dw 0x6cc0, 0xc93d,	0x6cff, 0xc93d,		0x21, 0
	.dw 0x6d40, 0xc93d,	0x6d7f, 0xc93d,		0x21, 0
	.dw 0x6dc0, 0xc93d,	0x6dff, 0xc93d,		0x21, 0
	.dw 0x6e40, 0xc93d,	0x6e7f, 0xc93d,		0x21, 0
	.dw 0x6ec0, 0xc93d,	0x6eff, 0xc93d,		0x21, 0
	.dw 0x6f40, 0xc93d,	0x6f7f, 0xc93d,		0x21, 0
	.dw 0x6fc0, 0xc93d,	0x6fff, 0xc93d,		0x21, 0
	.dw 0x7040, 0xc93d,	0x707f, 0xc93d,		0x21, 0
	.dw 0x70c0, 0xc93d,	0x70ff, 0xc93d,		0x21, 0
	.dw 0x7140, 0xc93d,	0x717f, 0xc93d,		0x21, 0
	.dw 0x71c0, 0xc93d,	0x71ff, 0xc93d,		0x21, 0
	.dw 0x7240, 0xc93d,	0x727f, 0xc93d,		0x21, 0
	.dw 0x72c0, 0xc93d,	0x72ff, 0xc93d,		0x21, 0
	.dw 0x7340, 0xc93d,	0x737f, 0xc93d,		0x21, 0
	.dw 0x73c0, 0xc93d,	0x73ff, 0xc93d,		0x21, 0
	.dw 0x7440, 0xc93d,	0x747f, 0xc93d,		0x21, 0
	.dw 0x74c0, 0xc93d,	0x74ff, 0xc93d,		0x21, 0
	.dw 0x7540, 0xc93d,	0x757f, 0xc93d,		0x21, 0
	.dw 0x75c0, 0xc93d,	0x75ff, 0xc93d,		0x21, 0
	.dw 0x7640, 0xc93d,	0x767f, 0xc93d,		0x21, 0
	.dw 0x76c0, 0xc93d,	0x76ff, 0xc93d,		0x21, 0
	.dw 0x7740, 0xc93d,	0x777f, 0xc93d,		0x21, 0
	.dw 0x77c0, 0xc93d,	0x77ff, 0xc93d,		0x21, 0
	.dw 0x7840, 0xc93d,	0x787f, 0xc93d,		0x21, 0
	.dw 0x78c0, 0xc93d,	0x78ff, 0xc93d,		0x21, 0
	.dw 0x7940, 0xc93d,	0x797f, 0xc93d,		0x21, 0
	.dw 0x79c0, 0xc93d,	0x7fff, 0xc93d,		0x21, 0
	.dw 0x8040, 0xc93d,	0x807f, 0xc93d,		0x21, 0
	.dw 0x80c0, 0xc93d,	0x80ff, 0xc93d,		0x21, 0
	.dw 0x8140, 0xc93d,	0x817f, 0xc93d,		0x21, 0
	.dw 0x81c0, 0xc93d,	0x81ff, 0xc93d,		0x21, 0
	.dw 0x8240, 0xc93d,	0x827f, 0xc93d,		0x21, 0
	.dw 0x82c0, 0xc93d,	0x82ff, 0xc93d,		0x21, 0
	.dw 0x8340, 0xc93d,	0x837f, 0xc93d,		0x21, 0
	.dw 0x83c0, 0xc93d,	0x83ff, 0xc93d,		0x21, 0
	.dw 0x8440, 0xc93d,	0x847f, 0xc93d,		0x21, 0
	.dw 0x84c0, 0xc93d,	0x84ff, 0xc93d,		0x21, 0
	.dw 0x8540, 0xc93d,	0x857f, 0xc93d,		0x21, 0
	.dw 0x85c0, 0xc93d,	0x85ff, 0xc93d,		0x21, 0
	.dw 0x8640, 0xc93d,	0x867f, 0xc93d,		0x21, 0
	.dw 0x86c0, 0xc93d,	0x86ff, 0xc93d,		0x21, 0
	.dw 0x8740, 0xc93d,	0x877f, 0xc93d,		0x21, 0
	.dw 0x87c0, 0xc93d,	0x87ff, 0xc93d,		0x21, 0
	.dw 0x8840, 0xc93d,	0x887f, 0xc93d,		0x21, 0
	.dw 0x88c0, 0xc93d,	0x88ff, 0xc93d,		0x21, 0
	.dw 0x8940, 0xc93d,	0x897f, 0xc93d,		0x21, 0
	.dw 0x89c0, 0xc93d,	0x89ff, 0xc93d,		0x21, 0
	.dw 0x8a40, 0xc93d,	0x8a7f, 0xc93d,		0x21, 0
	.dw 0x8ac0, 0xc93d,	0x8aff, 0xc93d,		0x21, 0
	.dw 0x8b40, 0xc93d,	0x8b7f, 0xc93d,		0x21, 0
	.dw 0x8bc0, 0xc93d,	0x8bff, 0xc93d,		0x21, 0
	.dw 0x8c40, 0xc93d,	0x8c7f, 0xc93d,		0x21, 0
	.dw 0x8cc0, 0xc93d,	0x8cff, 0xc93d,		0x21, 0
	.dw 0x8d40, 0xc93d,	0x8d7f, 0xc93d,		0x21, 0
	.dw 0x8dc0, 0xc93d,	0x8dff, 0xc93d,		0x21, 0
	.dw 0x8e40, 0xc93d,	0x8e7f, 0xc93d,		0x21, 0
	.dw 0x8ec0, 0xc93d,	0x8eff, 0xc93d,		0x21, 0
	.dw 0x8f40, 0xc93d,	0x8f7f, 0xc93d,		0x21, 0
	.dw 0x8fc0, 0xc93d,	0x8fff, 0xc93d,		0x21, 0
	.dw 0x9040, 0xc93d,	0x907f, 0xc93d,		0x21, 0
	.dw 0x90c0, 0xc93d,	0x90ff, 0xc93d,		0x21, 0
	.dw 0x9140, 0xc93d,	0x917f, 0xc93d,		0x21, 0
	.dw 0x91c0, 0xc93d,	0x91ff, 0xc93d,		0x21, 0
	.dw 0x9240, 0xc93d,	0x927f, 0xc93d,		0x21, 0
	.dw 0x92c0, 0xc93d,	0x92ff, 0xc93d,		0x21, 0
	.dw 0x9340, 0xc93d,	0x937f, 0xc93d,		0x21, 0
	.dw 0x93c0, 0xc93d,	0x93ff, 0xc93d,		0x21, 0
	.dw 0x9440, 0xc93d,	0x947f, 0xc93d,		0x21, 0
	.dw 0x94c0, 0xc93d,	0x94ff, 0xc93d,		0x21, 0
	.dw 0x9540, 0xc93d,	0x957f, 0xc93d,		0x21, 0
	.dw 0x95c0, 0xc93d,	0x95ff, 0xc93d,		0x21, 0
	.dw 0x9640, 0xc93d,	0x967f, 0xc93d,		0x21, 0
	.dw 0x96c0, 0xc93d,	0x96ff, 0xc93d,		0x21, 0
	.dw 0x9740, 0xc93d,	0x977f, 0xc93d,		0x21, 0
	.dw 0x97c0, 0xc93d,	0x97ff, 0xc93d,		0x21, 0
	.dw 0x9840, 0xc93d,	0x987f, 0xc93d,		0x21, 0
	.dw 0x98c0, 0xc93d,	0x98ff, 0xc93d,		0x21, 0
	.dw 0x9940, 0xc93d,	0x997f, 0xc93d,		0x21, 0
	.dw 0x99c0, 0xc93d,	0x9fff, 0xc93d,		0x21, 0
	.dw 0xa040, 0xc93d,	0xa07f, 0xc93d,		0x21, 0
	.dw 0xa0c0, 0xc93d,	0xa0ff, 0xc93d,		0x21, 0
	.dw 0xa140, 0xc93d,	0xa17f, 0xc93d,		0x21, 0
	.dw 0xa1c0, 0xc93d,	0xa1ff, 0xc93d,		0x21, 0
	.dw 0xa240, 0xc93d,	0xa27f, 0xc93d,		0x21, 0
	.dw 0xa2c0, 0xc93d,	0xa2ff, 0xc93d,		0x21, 0
	.dw 0xa340, 0xc93d,	0xa37f, 0xc93d,		0x21, 0
	.dw 0xa3c0, 0xc93d,	0xa3ff, 0xc93d,		0x21, 0
	.dw 0xa440, 0xc93d,	0xa47f, 0xc93d,		0x21, 0
	.dw 0xa4c0, 0xc93d,	0xa4ff, 0xc93d,		0x21, 0
	.dw 0xa540, 0xc93d,	0xa57f, 0xc93d,		0x21, 0
	.dw 0xa5c0, 0xc93d,	0xa5ff, 0xc93d,		0x21, 0
	.dw 0xa640, 0xc93d,	0xa67f, 0xc93d,		0x21, 0
	.dw 0xa6c0, 0xc93d,	0xa6ff, 0xc93d,		0x21, 0
	.dw 0xa740, 0xc93d,	0xa77f, 0xc93d,		0x21, 0
	.dw 0xa7c0, 0xc93d,	0xa7ff, 0xc93d,		0x21, 0
	.dw 0xa840, 0xc93d,	0xa87f, 0xc93d,		0x21, 0
	.dw 0xa8c0, 0xc93d,	0xa8ff, 0xc93d,		0x21, 0
	.dw 0xa940, 0xc93d,	0xa97f, 0xc93d,		0x21, 0
	.dw 0xa9c0, 0xc93d,	0xa9ff, 0xc93d,		0x21, 0
	.dw 0xaa40, 0xc93d,	0xaa7f, 0xc93d,		0x21, 0
	.dw 0xaac0, 0xc93d,	0xaaff, 0xc93d,		0x21, 0
	.dw 0xab40, 0xc93d,	0xab7f, 0xc93d,		0x21, 0
	.dw 0xabc0, 0xc93d,	0xabff, 0xc93d,		0x21, 0
	.dw 0xac40, 0xc93d,	0xac7f, 0xc93d,		0x21, 0
	.dw 0xacc0, 0xc93d,	0xacff, 0xc93d,		0x21, 0
	.dw 0xad40, 0xc93d,	0xad7f, 0xc93d,		0x21, 0
	.dw 0xadc0, 0xc93d,	0xadff, 0xc93d,		0x21, 0
	.dw 0xae40, 0xc93d,	0xae7f, 0xc93d,		0x21, 0
	.dw 0xaec0, 0xc93d,	0xaeff, 0xc93d,		0x21, 0
	.dw 0xaf40, 0xc93d,	0xaf7f, 0xc93d,		0x21, 0
	.dw 0xafc0, 0xc93d,	0xafff, 0xc93d,		0x21, 0
	.dw 0xb040, 0xc93d,	0xb07f, 0xc93d,		0x21, 0
	.dw 0xb0c0, 0xc93d,	0xb0ff, 0xc93d,		0x21, 0
	.dw 0xb140, 0xc93d,	0xb17f, 0xc93d,		0x21, 0
	.dw 0xb1c0, 0xc93d,	0xb1ff, 0xc93d,		0x21, 0
	.dw 0xb240, 0xc93d,	0xb27f, 0xc93d,		0x21, 0
	.dw 0xb2c0, 0xc93d,	0xb2ff, 0xc93d,		0x21, 0
	.dw 0xb340, 0xc93d,	0xb37f, 0xc93d,		0x21, 0
	.dw 0xb3c0, 0xc93d,	0xb3ff, 0xc93d,		0x21, 0
	.dw 0xb440, 0xc93d,	0xb47f, 0xc93d,		0x21, 0
	.dw 0xb4c0, 0xc93d,	0xb4ff, 0xc93d,		0x21, 0
	.dw 0xb540, 0xc93d,	0xb57f, 0xc93d,		0x21, 0
	.dw 0xb5c0, 0xc93d,	0xb5ff, 0xc93d,		0x21, 0
	.dw 0xb640, 0xc93d,	0xb67f, 0xc93d,		0x21, 0
	.dw 0xb6c0, 0xc93d,	0xb6ff, 0xc93d,		0x21, 0
	.dw 0xb740, 0xc93d,	0xb77f, 0xc93d,		0x21, 0
	.dw 0xb7c0, 0xc93d,	0xb7ff, 0xc93d,		0x21, 0
	.dw 0xb840, 0xc93d,	0xb87f, 0xc93d,		0x21, 0
	.dw 0xb8c0, 0xc93d,	0xb8ff, 0xc93d,		0x21, 0
	.dw 0xb940, 0xc93d,	0xb97f, 0xc93d,		0x21, 0
	.dw 0xb9c0, 0xc93d,	0xbfff, 0xc93d,		0x21, 0
	.dw 0xc040, 0xc93d,	0xc07f, 0xc93d,		0x21, 0
	.dw 0xc0c0, 0xc93d,	0xc0ff, 0xc93d,		0x21, 0
	.dw 0xc140, 0xc93d,	0xc17f, 0xc93d,		0x21, 0
	.dw 0xc1c0, 0xc93d,	0xc1ff, 0xc93d,		0x21, 0
	.dw 0xc240, 0xc93d,	0xc27f, 0xc93d,		0x21, 0
	.dw 0xc2c0, 0xc93d,	0xc2ff, 0xc93d,		0x21, 0
	.dw 0xc340, 0xc93d,	0xc37f, 0xc93d,		0x21, 0
	.dw 0xc3c0, 0xc93d,	0xc3ff, 0xc93d,		0x21, 0
	.dw 0xc440, 0xc93d,	0xc47f, 0xc93d,		0x21, 0
	.dw 0xc4c0, 0xc93d,	0xc4ff, 0xc93d,		0x21, 0
	.dw 0xc540, 0xc93d,	0xc57f, 0xc93d,		0x21, 0
	.dw 0xc5c0, 0xc93d,	0xc5ff, 0xc93d,		0x21, 0
	.dw 0xc640, 0xc93d,	0xc67f, 0xc93d,		0x21, 0
	.dw 0xc6c0, 0xc93d,	0xc6ff, 0xc93d,		0x21, 0
	.dw 0xc740, 0xc93d,	0xc77f, 0xc93d,		0x21, 0
	.dw 0xc7c0, 0xc93d,	0xc7ff, 0xc93d,		0x21, 0
	.dw 0xc840, 0xc93d,	0xc87f, 0xc93d,		0x21, 0
	.dw 0xc8c0, 0xc93d,	0xc8ff, 0xc93d,		0x21, 0
	.dw 0xc940, 0xc93d,	0xc97f, 0xc93d,		0x21, 0
	.dw 0xc9c0, 0xc93d,	0xc9ff, 0xc93d,		0x21, 0
	.dw 0xca40, 0xc93d,	0xca7f, 0xc93d,		0x21, 0
	.dw 0xcac0, 0xc93d,	0xcaff, 0xc93d,		0x21, 0
	.dw 0xcb40, 0xc93d,	0xcb7f, 0xc93d,		0x21, 0
	.dw 0xcbc0, 0xc93d,	0xcbff, 0xc93d,		0x21, 0
	.dw 0xcc40, 0xc93d,	0xcc7f, 0xc93d,		0x21, 0
	.dw 0xccc0, 0xc93d,	0xccff, 0xc93d,		0x21, 0
	.dw 0xcd40, 0xc93d,	0xcd7f, 0xc93d,		0x21, 0
	.dw 0xcdc0, 0xc93d,	0xcdff, 0xc93d,		0x21, 0
	.dw 0xce40, 0xc93d,	0xce7f, 0xc93d,		0x21, 0
	.dw 0xcec0, 0xc93d,	0xceff, 0xc93d,		0x21, 0
	.dw 0xcf40, 0xc93d,	0xcf7f, 0xc93d,		0x21, 0
	.dw 0xcfc0, 0xc93d,	0xcfff, 0xc93d,		0x21, 0
	.dw 0xd040, 0xc93d,	0xd07f, 0xc93d,		0x21, 0
	.dw 0xd0c0, 0xc93d,	0xd0ff, 0xc93d,		0x21, 0
	.dw 0xd140, 0xc93d,	0xd17f, 0xc93d,		0x21, 0
	.dw 0xd1c0, 0xc93d,	0xd1ff, 0xc93d,		0x21, 0
	.dw 0xd240, 0xc93d,	0xd27f, 0xc93d,		0x21, 0
	.dw 0xd2c0, 0xc93d,	0xd2ff, 0xc93d,		0x21, 0
	.dw 0xd340, 0xc93d,	0xd37f, 0xc93d,		0x21, 0
	.dw 0xd3c0, 0xc93d,	0xd3ff, 0xc93d,		0x21, 0
	.dw 0xd440, 0xc93d,	0xd47f, 0xc93d,		0x21, 0
	.dw 0xd4c0, 0xc93d,	0xd4ff, 0xc93d,		0x21, 0
	.dw 0xd540, 0xc93d,	0xd57f, 0xc93d,		0x21, 0
	.dw 0xd5c0, 0xc93d,	0xd5ff, 0xc93d,		0x21, 0
	.dw 0xd640, 0xc93d,	0xd67f, 0xc93d,		0x21, 0
	.dw 0xd6c0, 0xc93d,	0xd6ff, 0xc93d,		0x21, 0
	.dw 0xd740, 0xc93d,	0xd77f, 0xc93d,		0x21, 0
	.dw 0xd7c0, 0xc93d,	0xd7ff, 0xc93d,		0x21, 0
	.dw 0xd840, 0xc93d,	0xd87f, 0xc93d,		0x21, 0
	.dw 0xd8c0, 0xc93d,	0xd8ff, 0xc93d,		0x21, 0
	.dw 0xd940, 0xc93d,	0xd97f, 0xc93d,		0x21, 0
	.dw 0xd9c0, 0xc93d,	0xdfff, 0xc93d,		0x21, 0
	.dw 0xe040, 0xc93d,	0xe07f, 0xc93d,		0x21, 0
	.dw 0xe0c0, 0xc93d,	0xe0ff, 0xc93d,		0x21, 0
	.dw 0xe140, 0xc93d,	0xe17f, 0xc93d,		0x21, 0
	.dw 0xe1c0, 0xc93d,	0xe1ff, 0xc93d,		0x21, 0
	.dw 0xe240, 0xc93d,	0xe27f, 0xc93d,		0x21, 0
	.dw 0xe2c0, 0xc93d,	0xe2ff, 0xc93d,		0x21, 0
	.dw 0xe340, 0xc93d,	0xe37f, 0xc93d,		0x21, 0
	.dw 0xe3c0, 0xc93d,	0xe3ff, 0xc93d,		0x21, 0
	.dw 0xe440, 0xc93d,	0xe47f, 0xc93d,		0x21, 0
	.dw 0xe4c0, 0xc93d,	0xe4ff, 0xc93d,		0x21, 0
	.dw 0xe540, 0xc93d,	0xe57f, 0xc93d,		0x21, 0
	.dw 0xe5c0, 0xc93d,	0xe5ff, 0xc93d,		0x21, 0
	.dw 0xe640, 0xc93d,	0xe67f, 0xc93d,		0x21, 0
	.dw 0xe6c0, 0xc93d,	0xe6ff, 0xc93d,		0x21, 0
	.dw 0xe740, 0xc93d,	0xe77f, 0xc93d,		0x21, 0
	.dw 0xe7c0, 0xc93d,	0xe7ff, 0xc93d,		0x21, 0
	.dw 0xe840, 0xc93d,	0xe87f, 0xc93d,		0x21, 0
	.dw 0xe8c0, 0xc93d,	0xe8ff, 0xc93d,		0x21, 0
	.dw 0xe940, 0xc93d,	0xe97f, 0xc93d,		0x21, 0
	.dw 0xe9c0, 0xc93d,	0xe9ff, 0xc93d,		0x21, 0
	.dw 0xea40, 0xc93d,	0xea7f, 0xc93d,		0x21, 0
	.dw 0xeac0, 0xc93d,	0xeaff, 0xc93d,		0x21, 0
	.dw 0xeb40, 0xc93d,	0xeb7f, 0xc93d,		0x21, 0
	.dw 0xebc0, 0xc93d,	0xebff, 0xc93d,		0x21, 0
	.dw 0xec40, 0xc93d,	0xec7f, 0xc93d,		0x21, 0
	.dw 0xecc0, 0xc93d,	0xecff, 0xc93d,		0x21, 0
	.dw 0xed40, 0xc93d,	0xed7f, 0xc93d,		0x21, 0
	.dw 0xedc0, 0xc93d,	0xedff, 0xc93d,		0x21, 0
	.dw 0xee40, 0xc93d,	0xee7f, 0xc93d,		0x21, 0
	.dw 0xeec0, 0xc93d,	0xeeff, 0xc93d,		0x21, 0
	.dw 0xef40, 0xc93d,	0xef7f, 0xc93d,		0x21, 0
	.dw 0xefc0, 0xc93d,	0xefff, 0xc93d,		0x21, 0
	.dw 0xf040, 0xc93d,	0xf07f, 0xc93d,		0x21, 0
	.dw 0xf0c0, 0xc93d,	0xf0ff, 0xc93d,		0x21, 0
	.dw 0xf140, 0xc93d,	0xf17f, 0xc93d,		0x21, 0
	.dw 0xf1c0, 0xc93d,	0xf1ff, 0xc93d,		0x21, 0
	.dw 0xf240, 0xc93d,	0xf27f, 0xc93d,		0x21, 0
	.dw 0xf2c0, 0xc93d,	0xf2ff, 0xc93d,		0x21, 0
	.dw 0xf340, 0xc93d,	0xf37f, 0xc93d,		0x21, 0
	.dw 0xf3c0, 0xc93d,	0xf3ff, 0xc93d,		0x21, 0
	.dw 0xf440, 0xc93d,	0xf47f, 0xc93d,		0x21, 0
	.dw 0xf4c0, 0xc93d,	0xf4ff, 0xc93d,		0x21, 0
	.dw 0xf540, 0xc93d,	0xf57f, 0xc93d,		0x21, 0
	.dw 0xf5c0, 0xc93d,	0xf5ff, 0xc93d,		0x21, 0
	.dw 0xf640, 0xc93d,	0xf67f, 0xc93d,		0x21, 0
	.dw 0xf6c0, 0xc93d,	0xf6ff, 0xc93d,		0x21, 0
	.dw 0xf740, 0xc93d,	0xf77f, 0xc93d,		0x21, 0
	.dw 0xf7c0, 0xc93d,	0xf7ff, 0xc93d,		0x21, 0
	.dw 0xf840, 0xc93d,	0xf87f, 0xc93d,		0x21, 0
	.dw 0xf8c0, 0xc93d,	0xf8ff, 0xc93d,		0x21, 0
	.dw 0xf940, 0xc93d,	0xf97f, 0xc93d,		0x21, 0
	.dw 0xf9c0, 0xc93d,	0xffff, 0xc93d,		0x21, 0
	.dw 0x0040, 0xc93e,	0x007f, 0xc93e,		0x21, 0
	.dw 0x00c0, 0xc93e,	0x00ff, 0xc93e,		0x21, 0
	.dw 0x0140, 0xc93e,	0x017f, 0xc93e,		0x21, 0
	.dw 0x01c0, 0xc93e,	0x01ff, 0xc93e,		0x21, 0
	.dw 0x0240, 0xc93e,	0x027f, 0xc93e,		0x21, 0
	.dw 0x02c0, 0xc93e,	0x02ff, 0xc93e,		0x21, 0
	.dw 0x0340, 0xc93e,	0x037f, 0xc93e,		0x21, 0
	.dw 0x03c0, 0xc93e,	0x03ff, 0xc93e,		0x21, 0
	.dw 0x0440, 0xc93e,	0x047f, 0xc93e,		0x21, 0
	.dw 0x04c0, 0xc93e,	0x04ff, 0xc93e,		0x21, 0
	.dw 0x0540, 0xc93e,	0x057f, 0xc93e,		0x21, 0
	.dw 0x05c0, 0xc93e,	0x05ff, 0xc93e,		0x21, 0
	.dw 0x0640, 0xc93e,	0x067f, 0xc93e,		0x21, 0
	.dw 0x06c0, 0xc93e,	0x06ff, 0xc93e,		0x21, 0
	.dw 0x0740, 0xc93e,	0x077f, 0xc93e,		0x21, 0
	.dw 0x07c0, 0xc93e,	0x07ff, 0xc93e,		0x21, 0
	.dw 0x0840, 0xc93e,	0x087f, 0xc93e,		0x21, 0
	.dw 0x08c0, 0xc93e,	0x08ff, 0xc93e,		0x21, 0
	.dw 0x0940, 0xc93e,	0x097f, 0xc93e,		0x21, 0
	.dw 0x09c0, 0xc93e,	0x09ff, 0xc93e,		0x21, 0
	.dw 0x0a40, 0xc93e,	0x0a7f, 0xc93e,		0x21, 0
	.dw 0x0ac0, 0xc93e,	0x0aff, 0xc93e,		0x21, 0
	.dw 0x0b40, 0xc93e,	0x0b7f, 0xc93e,		0x21, 0
	.dw 0x0bc0, 0xc93e,	0x0bff, 0xc93e,		0x21, 0
	.dw 0x0c40, 0xc93e,	0x0c7f, 0xc93e,		0x21, 0
	.dw 0x0cc0, 0xc93e,	0x0cff, 0xc93e,		0x21, 0
	.dw 0x0d40, 0xc93e,	0x0d7f, 0xc93e,		0x21, 0
	.dw 0x0dc0, 0xc93e,	0x0dff, 0xc93e,		0x21, 0
	.dw 0x0e40, 0xc93e,	0x0e7f, 0xc93e,		0x21, 0
	.dw 0x0ec0, 0xc93e,	0x0eff, 0xc93e,		0x21, 0
	.dw 0x0f40, 0xc93e,	0x0f7f, 0xc93e,		0x21, 0
	.dw 0x0fc0, 0xc93e,	0x0fff, 0xc93e,		0x21, 0
	.dw 0x1040, 0xc93e,	0x107f, 0xc93e,		0x21, 0
	.dw 0x10c0, 0xc93e,	0x10ff, 0xc93e,		0x21, 0
	.dw 0x1140, 0xc93e,	0x117f, 0xc93e,		0x21, 0
	.dw 0x11c0, 0xc93e,	0x11ff, 0xc93e,		0x21, 0
	.dw 0x1240, 0xc93e,	0x127f, 0xc93e,		0x21, 0
	.dw 0x12c0, 0xc93e,	0x12ff, 0xc93e,		0x21, 0
	.dw 0x1340, 0xc93e,	0x137f, 0xc93e,		0x21, 0
	.dw 0x13c0, 0xc93e,	0x13ff, 0xc93e,		0x21, 0
	.dw 0x1440, 0xc93e,	0x147f, 0xc93e,		0x21, 0
	.dw 0x14c0, 0xc93e,	0x14ff, 0xc93e,		0x21, 0
	.dw 0x1540, 0xc93e,	0x157f, 0xc93e,		0x21, 0
	.dw 0x15c0, 0xc93e,	0x15ff, 0xc93e,		0x21, 0
	.dw 0x1640, 0xc93e,	0x167f, 0xc93e,		0x21, 0
	.dw 0x16c0, 0xc93e,	0x16ff, 0xc93e,		0x21, 0
	.dw 0x1740, 0xc93e,	0x177f, 0xc93e,		0x21, 0
	.dw 0x17c0, 0xc93e,	0x17ff, 0xc93e,		0x21, 0
	.dw 0x1840, 0xc93e,	0x187f, 0xc93e,		0x21, 0
	.dw 0x18c0, 0xc93e,	0x18ff, 0xc93e,		0x21, 0
	.dw 0x1940, 0xc93e,	0x197f, 0xc93e,		0x21, 0
	.dw 0x19c0, 0xc93e,	0x1fff, 0xc93e,		0x21, 0
	.dw 0x2040, 0xc93e,	0x207f, 0xc93e,		0x21, 0
	.dw 0x20c0, 0xc93e,	0x20ff, 0xc93e,		0x21, 0
	.dw 0x2140, 0xc93e,	0x217f, 0xc93e,		0x21, 0
	.dw 0x21c0, 0xc93e,	0x21ff, 0xc93e,		0x21, 0
	.dw 0x2240, 0xc93e,	0x227f, 0xc93e,		0x21, 0
	.dw 0x22c0, 0xc93e,	0x22ff, 0xc93e,		0x21, 0
	.dw 0x2340, 0xc93e,	0x237f, 0xc93e,		0x21, 0
	.dw 0x23c0, 0xc93e,	0x23ff, 0xc93e,		0x21, 0
	.dw 0x2440, 0xc93e,	0x247f, 0xc93e,		0x21, 0
	.dw 0x24c0, 0xc93e,	0x24ff, 0xc93e,		0x21, 0
	.dw 0x2540, 0xc93e,	0x257f, 0xc93e,		0x21, 0
	.dw 0x25c0, 0xc93e,	0x25ff, 0xc93e,		0x21, 0
	.dw 0x2640, 0xc93e,	0x267f, 0xc93e,		0x21, 0
	.dw 0x26c0, 0xc93e,	0x26ff, 0xc93e,		0x21, 0
	.dw 0x2740, 0xc93e,	0x277f, 0xc93e,		0x21, 0
	.dw 0x27c0, 0xc93e,	0x27ff, 0xc93e,		0x21, 0
	.dw 0x2840, 0xc93e,	0x287f, 0xc93e,		0x21, 0
	.dw 0x28c0, 0xc93e,	0x28ff, 0xc93e,		0x21, 0
	.dw 0x2940, 0xc93e,	0x297f, 0xc93e,		0x21, 0
	.dw 0x29c0, 0xc93e,	0x29ff, 0xc93e,		0x21, 0
	.dw 0x2a40, 0xc93e,	0x2a7f, 0xc93e,		0x21, 0
	.dw 0x2ac0, 0xc93e,	0x2aff, 0xc93e,		0x21, 0
	.dw 0x2b40, 0xc93e,	0x2b7f, 0xc93e,		0x21, 0
	.dw 0x2bc0, 0xc93e,	0x2bff, 0xc93e,		0x21, 0
	.dw 0x2c40, 0xc93e,	0x2c7f, 0xc93e,		0x21, 0
	.dw 0x2cc0, 0xc93e,	0x2cff, 0xc93e,		0x21, 0
	.dw 0x2d40, 0xc93e,	0x2d7f, 0xc93e,		0x21, 0
	.dw 0x2dc0, 0xc93e,	0x2dff, 0xc93e,		0x21, 0
	.dw 0x2e40, 0xc93e,	0x2e7f, 0xc93e,		0x21, 0
	.dw 0x2ec0, 0xc93e,	0x2eff, 0xc93e,		0x21, 0
	.dw 0x2f40, 0xc93e,	0x2f7f, 0xc93e,		0x21, 0
	.dw 0x2fc0, 0xc93e,	0x2fff, 0xc93e,		0x21, 0
	.dw 0x3040, 0xc93e,	0x307f, 0xc93e,		0x21, 0
	.dw 0x30c0, 0xc93e,	0x30ff, 0xc93e,		0x21, 0
	.dw 0x3140, 0xc93e,	0x317f, 0xc93e,		0x21, 0
	.dw 0x31c0, 0xc93e,	0x31ff, 0xc93e,		0x21, 0
	.dw 0x3240, 0xc93e,	0x327f, 0xc93e,		0x21, 0
	.dw 0x32c0, 0xc93e,	0x32ff, 0xc93e,		0x21, 0
	.dw 0x3340, 0xc93e,	0x337f, 0xc93e,		0x21, 0
	.dw 0x33c0, 0xc93e,	0x33ff, 0xc93e,		0x21, 0
	.dw 0x3440, 0xc93e,	0x347f, 0xc93e,		0x21, 0
	.dw 0x34c0, 0xc93e,	0x34ff, 0xc93e,		0x21, 0
	.dw 0x3540, 0xc93e,	0x357f, 0xc93e,		0x21, 0
	.dw 0x35c0, 0xc93e,	0x35ff, 0xc93e,		0x21, 0
	.dw 0x3640, 0xc93e,	0x367f, 0xc93e,		0x21, 0
	.dw 0x36c0, 0xc93e,	0x36ff, 0xc93e,		0x21, 0
	.dw 0x3740, 0xc93e,	0x377f, 0xc93e,		0x21, 0
	.dw 0x37c0, 0xc93e,	0x37ff, 0xc93e,		0x21, 0
	.dw 0x3840, 0xc93e,	0x387f, 0xc93e,		0x21, 0
	.dw 0x38c0, 0xc93e,	0x38ff, 0xc93e,		0x21, 0
	.dw 0x3940, 0xc93e,	0x397f, 0xc93e,		0x21, 0
	.dw 0x39c0, 0xc93e,	0x3fff, 0xc93e,		0x21, 0
	.dw 0x4040, 0xc93e,	0x407f, 0xc93e,		0x21, 0
	.dw 0x40c0, 0xc93e,	0x40ff, 0xc93e,		0x21, 0
	.dw 0x4140, 0xc93e,	0x417f, 0xc93e,		0x21, 0
	.dw 0x41c0, 0xc93e,	0x41ff, 0xc93e,		0x21, 0
	.dw 0x4240, 0xc93e,	0x427f, 0xc93e,		0x21, 0
	.dw 0x42c0, 0xc93e,	0x42ff, 0xc93e,		0x21, 0
	.dw 0x4340, 0xc93e,	0x437f, 0xc93e,		0x21, 0
	.dw 0x43c0, 0xc93e,	0x43ff, 0xc93e,		0x21, 0
	.dw 0x4440, 0xc93e,	0x447f, 0xc93e,		0x21, 0
	.dw 0x44c0, 0xc93e,	0x44ff, 0xc93e,		0x21, 0
	.dw 0x4540, 0xc93e,	0x457f, 0xc93e,		0x21, 0
	.dw 0x45c0, 0xc93e,	0x45ff, 0xc93e,		0x21, 0
	.dw 0x4640, 0xc93e,	0x467f, 0xc93e,		0x21, 0
	.dw 0x46c0, 0xc93e,	0x46ff, 0xc93e,		0x21, 0
	.dw 0x4740, 0xc93e,	0x477f, 0xc93e,		0x21, 0
	.dw 0x47c0, 0xc93e,	0x47ff, 0xc93e,		0x21, 0
	.dw 0x4840, 0xc93e,	0x487f, 0xc93e,		0x21, 0
	.dw 0x48c0, 0xc93e,	0x48ff, 0xc93e,		0x21, 0
	.dw 0x4940, 0xc93e,	0x497f, 0xc93e,		0x21, 0
	.dw 0x49c0, 0xc93e,	0x49ff, 0xc93e,		0x21, 0
	.dw 0x4a40, 0xc93e,	0x4a7f, 0xc93e,		0x21, 0
	.dw 0x4ac0, 0xc93e,	0x4aff, 0xc93e,		0x21, 0
	.dw 0x4b40, 0xc93e,	0x4b7f, 0xc93e,		0x21, 0
	.dw 0x4bc0, 0xc93e,	0x4bff, 0xc93e,		0x21, 0
	.dw 0x4c40, 0xc93e,	0x4c7f, 0xc93e,		0x21, 0
	.dw 0x4cc0, 0xc93e,	0x4cff, 0xc93e,		0x21, 0
	.dw 0x4d40, 0xc93e,	0x4d7f, 0xc93e,		0x21, 0
	.dw 0x4dc0, 0xc93e,	0x4dff, 0xc93e,		0x21, 0
	.dw 0x4e40, 0xc93e,	0x4e7f, 0xc93e,		0x21, 0
	.dw 0x4ec0, 0xc93e,	0x4eff, 0xc93e,		0x21, 0
	.dw 0x4f40, 0xc93e,	0x4f7f, 0xc93e,		0x21, 0
	.dw 0x4fc0, 0xc93e,	0x4fff, 0xc93e,		0x21, 0
	.dw 0x5040, 0xc93e,	0x507f, 0xc93e,		0x21, 0
	.dw 0x50c0, 0xc93e,	0x50ff, 0xc93e,		0x21, 0
	.dw 0x5140, 0xc93e,	0x517f, 0xc93e,		0x21, 0
	.dw 0x51c0, 0xc93e,	0x51ff, 0xc93e,		0x21, 0
	.dw 0x5240, 0xc93e,	0x527f, 0xc93e,		0x21, 0
	.dw 0x52c0, 0xc93e,	0x52ff, 0xc93e,		0x21, 0
	.dw 0x5340, 0xc93e,	0x537f, 0xc93e,		0x21, 0
	.dw 0x53c0, 0xc93e,	0x53ff, 0xc93e,		0x21, 0
	.dw 0x5440, 0xc93e,	0x547f, 0xc93e,		0x21, 0
	.dw 0x54c0, 0xc93e,	0x54ff, 0xc93e,		0x21, 0
	.dw 0x5540, 0xc93e,	0x557f, 0xc93e,		0x21, 0
	.dw 0x55c0, 0xc93e,	0x55ff, 0xc93e,		0x21, 0
	.dw 0x5640, 0xc93e,	0x567f, 0xc93e,		0x21, 0
	.dw 0x56c0, 0xc93e,	0x56ff, 0xc93e,		0x21, 0
	.dw 0x5740, 0xc93e,	0x577f, 0xc93e,		0x21, 0
	.dw 0x57c0, 0xc93e,	0x57ff, 0xc93e,		0x21, 0
	.dw 0x5840, 0xc93e,	0x587f, 0xc93e,		0x21, 0
	.dw 0x58c0, 0xc93e,	0x58ff, 0xc93e,		0x21, 0
	.dw 0x5940, 0xc93e,	0x597f, 0xc93e,		0x21, 0
	.dw 0x59c0, 0xc93e,	0x5fff, 0xc93e,		0x21, 0
	.dw 0x6040, 0xc93e,	0x607f, 0xc93e,		0x21, 0
	.dw 0x60c0, 0xc93e,	0x60ff, 0xc93e,		0x21, 0
	.dw 0x6140, 0xc93e,	0x617f, 0xc93e,		0x21, 0
	.dw 0x61c0, 0xc93e,	0x61ff, 0xc93e,		0x21, 0
	.dw 0x6240, 0xc93e,	0x627f, 0xc93e,		0x21, 0
	.dw 0x62c0, 0xc93e,	0x62ff, 0xc93e,		0x21, 0
	.dw 0x6340, 0xc93e,	0x637f, 0xc93e,		0x21, 0
	.dw 0x63c0, 0xc93e,	0x63ff, 0xc93e,		0x21, 0
	.dw 0x6440, 0xc93e,	0x647f, 0xc93e,		0x21, 0
	.dw 0x64c0, 0xc93e,	0x64ff, 0xc93e,		0x21, 0
	.dw 0x6540, 0xc93e,	0x657f, 0xc93e,		0x21, 0
	.dw 0x65c0, 0xc93e,	0x65ff, 0xc93e,		0x21, 0
	.dw 0x6640, 0xc93e,	0x667f, 0xc93e,		0x21, 0
	.dw 0x66c0, 0xc93e,	0x66ff, 0xc93e,		0x21, 0
	.dw 0x6740, 0xc93e,	0x677f, 0xc93e,		0x21, 0
	.dw 0x67c0, 0xc93e,	0x67ff, 0xc93e,		0x21, 0
	.dw 0x6840, 0xc93e,	0x687f, 0xc93e,		0x21, 0
	.dw 0x68c0, 0xc93e,	0x68ff, 0xc93e,		0x21, 0
	.dw 0x6940, 0xc93e,	0x697f, 0xc93e,		0x21, 0
	.dw 0x69c0, 0xc93e,	0x69ff, 0xc93e,		0x21, 0
	.dw 0x6a40, 0xc93e,	0x6a7f, 0xc93e,		0x21, 0
	.dw 0x6ac0, 0xc93e,	0x6aff, 0xc93e,		0x21, 0
	.dw 0x6b40, 0xc93e,	0x6b7f, 0xc93e,		0x21, 0
	.dw 0x6bc0, 0xc93e,	0x6bff, 0xc93e,		0x21, 0
	.dw 0x6c40, 0xc93e,	0x6c7f, 0xc93e,		0x21, 0
	.dw 0x6cc0, 0xc93e,	0x6cff, 0xc93e,		0x21, 0
	.dw 0x6d40, 0xc93e,	0x6d7f, 0xc93e,		0x21, 0
	.dw 0x6dc0, 0xc93e,	0x6dff, 0xc93e,		0x21, 0
	.dw 0x6e40, 0xc93e,	0x6e7f, 0xc93e,		0x21, 0
	.dw 0x6ec0, 0xc93e,	0x6eff, 0xc93e,		0x21, 0
	.dw 0x6f40, 0xc93e,	0x6f7f, 0xc93e,		0x21, 0
	.dw 0x6fc0, 0xc93e,	0x6fff, 0xc93e,		0x21, 0
	.dw 0x7040, 0xc93e,	0x707f, 0xc93e,		0x21, 0
	.dw 0x70c0, 0xc93e,	0x70ff, 0xc93e,		0x21, 0
	.dw 0x7140, 0xc93e,	0x717f, 0xc93e,		0x21, 0
	.dw 0x71c0, 0xc93e,	0x71ff, 0xc93e,		0x21, 0
	.dw 0x7240, 0xc93e,	0x727f, 0xc93e,		0x21, 0
	.dw 0x72c0, 0xc93e,	0x72ff, 0xc93e,		0x21, 0
	.dw 0x7340, 0xc93e,	0x737f, 0xc93e,		0x21, 0
	.dw 0x73c0, 0xc93e,	0x73ff, 0xc93e,		0x21, 0
	.dw 0x7440, 0xc93e,	0x747f, 0xc93e,		0x21, 0
	.dw 0x74c0, 0xc93e,	0x74ff, 0xc93e,		0x21, 0
	.dw 0x7540, 0xc93e,	0x757f, 0xc93e,		0x21, 0
	.dw 0x75c0, 0xc93e,	0x75ff, 0xc93e,		0x21, 0
	.dw 0x7640, 0xc93e,	0x767f, 0xc93e,		0x21, 0
	.dw 0x76c0, 0xc93e,	0x76ff, 0xc93e,		0x21, 0
	.dw 0x7740, 0xc93e,	0x777f, 0xc93e,		0x21, 0
	.dw 0x77c0, 0xc93e,	0x77ff, 0xc93e,		0x21, 0
	.dw 0x7840, 0xc93e,	0x787f, 0xc93e,		0x21, 0
	.dw 0x78c0, 0xc93e,	0x78ff, 0xc93e,		0x21, 0
	.dw 0x7940, 0xc93e,	0x797f, 0xc93e,		0x21, 0
	.dw 0x79c0, 0xc93e,	0x7fff, 0xc93e,		0x21, 0
	.dw 0x8040, 0xc93e,	0x807f, 0xc93e,		0x21, 0
	.dw 0x80c0, 0xc93e,	0x80ff, 0xc93e,		0x21, 0
	.dw 0x8140, 0xc93e,	0x817f, 0xc93e,		0x21, 0
	.dw 0x81c0, 0xc93e,	0x81ff, 0xc93e,		0x21, 0
	.dw 0x8240, 0xc93e,	0x827f, 0xc93e,		0x21, 0
	.dw 0x82c0, 0xc93e,	0x82ff, 0xc93e,		0x21, 0
	.dw 0x8340, 0xc93e,	0x837f, 0xc93e,		0x21, 0
	.dw 0x83c0, 0xc93e,	0x83ff, 0xc93e,		0x21, 0
	.dw 0x8440, 0xc93e,	0x847f, 0xc93e,		0x21, 0
	.dw 0x84c0, 0xc93e,	0x84ff, 0xc93e,		0x21, 0
	.dw 0x8540, 0xc93e,	0x857f, 0xc93e,		0x21, 0
	.dw 0x85c0, 0xc93e,	0x85ff, 0xc93e,		0x21, 0
	.dw 0x8640, 0xc93e,	0x867f, 0xc93e,		0x21, 0
	.dw 0x86c0, 0xc93e,	0x86ff, 0xc93e,		0x21, 0
	.dw 0x8740, 0xc93e,	0x877f, 0xc93e,		0x21, 0
	.dw 0x87c0, 0xc93e,	0x87ff, 0xc93e,		0x21, 0
	.dw 0x8840, 0xc93e,	0x887f, 0xc93e,		0x21, 0
	.dw 0x88c0, 0xc93e,	0x88ff, 0xc93e,		0x21, 0
	.dw 0x8940, 0xc93e,	0x897f, 0xc93e,		0x21, 0
	.dw 0x89c0, 0xc93e,	0x89ff, 0xc93e,		0x21, 0
	.dw 0x8a40, 0xc93e,	0x8a7f, 0xc93e,		0x21, 0
	.dw 0x8ac0, 0xc93e,	0x8aff, 0xc93e,		0x21, 0
	.dw 0x8b40, 0xc93e,	0x8b7f, 0xc93e,		0x21, 0
	.dw 0x8bc0, 0xc93e,	0x8bff, 0xc93e,		0x21, 0
	.dw 0x8c40, 0xc93e,	0x8c7f, 0xc93e,		0x21, 0
	.dw 0x8cc0, 0xc93e,	0x8cff, 0xc93e,		0x21, 0
	.dw 0x8d40, 0xc93e,	0x8d7f, 0xc93e,		0x21, 0
	.dw 0x8dc0, 0xc93e,	0x8dff, 0xc93e,		0x21, 0
	.dw 0x8e40, 0xc93e,	0x8e7f, 0xc93e,		0x21, 0
	.dw 0x8ec0, 0xc93e,	0x8eff, 0xc93e,		0x21, 0
	.dw 0x8f40, 0xc93e,	0x8f7f, 0xc93e,		0x21, 0
	.dw 0x8fc0, 0xc93e,	0x8fff, 0xc93e,		0x21, 0
	.dw 0x9040, 0xc93e,	0x907f, 0xc93e,		0x21, 0
	.dw 0x90c0, 0xc93e,	0x90ff, 0xc93e,		0x21, 0
	.dw 0x9140, 0xc93e,	0x917f, 0xc93e,		0x21, 0
	.dw 0x91c0, 0xc93e,	0x91ff, 0xc93e,		0x21, 0
	.dw 0x9240, 0xc93e,	0x927f, 0xc93e,		0x21, 0
	.dw 0x92c0, 0xc93e,	0x92ff, 0xc93e,		0x21, 0
	.dw 0x9340, 0xc93e,	0x937f, 0xc93e,		0x21, 0
	.dw 0x93c0, 0xc93e,	0x93ff, 0xc93e,		0x21, 0
	.dw 0x9440, 0xc93e,	0x947f, 0xc93e,		0x21, 0
	.dw 0x94c0, 0xc93e,	0x94ff, 0xc93e,		0x21, 0
	.dw 0x9540, 0xc93e,	0x957f, 0xc93e,		0x21, 0
	.dw 0x95c0, 0xc93e,	0x95ff, 0xc93e,		0x21, 0
	.dw 0x9640, 0xc93e,	0x967f, 0xc93e,		0x21, 0
	.dw 0x96c0, 0xc93e,	0x96ff, 0xc93e,		0x21, 0
	.dw 0x9740, 0xc93e,	0x977f, 0xc93e,		0x21, 0
	.dw 0x97c0, 0xc93e,	0x97ff, 0xc93e,		0x21, 0
	.dw 0x9840, 0xc93e,	0x987f, 0xc93e,		0x21, 0
	.dw 0x98c0, 0xc93e,	0x98ff, 0xc93e,		0x21, 0
	.dw 0x9940, 0xc93e,	0x997f, 0xc93e,		0x21, 0
	.dw 0x99c0, 0xc93e,	0x9fff, 0xc93e,		0x21, 0
	.dw 0xa040, 0xc93e,	0xa07f, 0xc93e,		0x21, 0
	.dw 0xa0c0, 0xc93e,	0xa0ff, 0xc93e,		0x21, 0
	.dw 0xa140, 0xc93e,	0xa17f, 0xc93e,		0x21, 0
	.dw 0xa1c0, 0xc93e,	0xa1ff, 0xc93e,		0x21, 0
	.dw 0xa240, 0xc93e,	0xa27f, 0xc93e,		0x21, 0
	.dw 0xa2c0, 0xc93e,	0xa2ff, 0xc93e,		0x21, 0
	.dw 0xa340, 0xc93e,	0xa37f, 0xc93e,		0x21, 0
	.dw 0xa3c0, 0xc93e,	0xa3ff, 0xc93e,		0x21, 0
	.dw 0xa440, 0xc93e,	0xa47f, 0xc93e,		0x21, 0
	.dw 0xa4c0, 0xc93e,	0xa4ff, 0xc93e,		0x21, 0
	.dw 0xa540, 0xc93e,	0xa57f, 0xc93e,		0x21, 0
	.dw 0xa5c0, 0xc93e,	0xa5ff, 0xc93e,		0x21, 0
	.dw 0xa640, 0xc93e,	0xa67f, 0xc93e,		0x21, 0
	.dw 0xa6c0, 0xc93e,	0xa6ff, 0xc93e,		0x21, 0
	.dw 0xa740, 0xc93e,	0xa77f, 0xc93e,		0x21, 0
	.dw 0xa7c0, 0xc93e,	0xa7ff, 0xc93e,		0x21, 0
	.dw 0xa840, 0xc93e,	0xa87f, 0xc93e,		0x21, 0
	.dw 0xa8c0, 0xc93e,	0xa8ff, 0xc93e,		0x21, 0
	.dw 0xa940, 0xc93e,	0xa97f, 0xc93e,		0x21, 0
	.dw 0xa9c0, 0xc93e,	0xa9ff, 0xc93e,		0x21, 0
	.dw 0xaa40, 0xc93e,	0xaa7f, 0xc93e,		0x21, 0
	.dw 0xaac0, 0xc93e,	0xaaff, 0xc93e,		0x21, 0
	.dw 0xab40, 0xc93e,	0xab7f, 0xc93e,		0x21, 0
	.dw 0xabc0, 0xc93e,	0xabff, 0xc93e,		0x21, 0
	.dw 0xac40, 0xc93e,	0xac7f, 0xc93e,		0x21, 0
	.dw 0xacc0, 0xc93e,	0xacff, 0xc93e,		0x21, 0
	.dw 0xad40, 0xc93e,	0xad7f, 0xc93e,		0x21, 0
	.dw 0xadc0, 0xc93e,	0xadff, 0xc93e,		0x21, 0
	.dw 0xae40, 0xc93e,	0xae7f, 0xc93e,		0x21, 0
	.dw 0xaec0, 0xc93e,	0xaeff, 0xc93e,		0x21, 0
	.dw 0xaf40, 0xc93e,	0xaf7f, 0xc93e,		0x21, 0
	.dw 0xafc0, 0xc93e,	0xafff, 0xc93e,		0x21, 0
	.dw 0xb040, 0xc93e,	0xb07f, 0xc93e,		0x21, 0
	.dw 0xb0c0, 0xc93e,	0xb0ff, 0xc93e,		0x21, 0
	.dw 0xb140, 0xc93e,	0xb17f, 0xc93e,		0x21, 0
	.dw 0xb1c0, 0xc93e,	0xb1ff, 0xc93e,		0x21, 0
	.dw 0xb240, 0xc93e,	0xb27f, 0xc93e,		0x21, 0
	.dw 0xb2c0, 0xc93e,	0xb2ff, 0xc93e,		0x21, 0
	.dw 0xb340, 0xc93e,	0xb37f, 0xc93e,		0x21, 0
	.dw 0xb3c0, 0xc93e,	0xb3ff, 0xc93e,		0x21, 0
	.dw 0xb440, 0xc93e,	0xb47f, 0xc93e,		0x21, 0
	.dw 0xb4c0, 0xc93e,	0xb4ff, 0xc93e,		0x21, 0
	.dw 0xb540, 0xc93e,	0xb57f, 0xc93e,		0x21, 0
	.dw 0xb5c0, 0xc93e,	0xb5ff, 0xc93e,		0x21, 0
	.dw 0xb640, 0xc93e,	0xb67f, 0xc93e,		0x21, 0
	.dw 0xb6c0, 0xc93e,	0xb6ff, 0xc93e,		0x21, 0
	.dw 0xb740, 0xc93e,	0xb77f, 0xc93e,		0x21, 0
	.dw 0xb7c0, 0xc93e,	0xb7ff, 0xc93e,		0x21, 0
	.dw 0xb840, 0xc93e,	0xb87f, 0xc93e,		0x21, 0
	.dw 0xb8c0, 0xc93e,	0xb8ff, 0xc93e,		0x21, 0
	.dw 0xb940, 0xc93e,	0xb97f, 0xc93e,		0x21, 0
	.dw 0xb9c0, 0xc93e,	0xbfff, 0xc93e,		0x21, 0
	.dw 0xc040, 0xc93e,	0xc07f, 0xc93e,		0x21, 0
	.dw 0xc0c0, 0xc93e,	0xc0ff, 0xc93e,		0x21, 0
	.dw 0xc140, 0xc93e,	0xc17f, 0xc93e,		0x21, 0
	.dw 0xc1c0, 0xc93e,	0xc1ff, 0xc93e,		0x21, 0
	.dw 0xc240, 0xc93e,	0xc27f, 0xc93e,		0x21, 0
	.dw 0xc2c0, 0xc93e,	0xc2ff, 0xc93e,		0x21, 0
	.dw 0xc340, 0xc93e,	0xc37f, 0xc93e,		0x21, 0
	.dw 0xc3c0, 0xc93e,	0xc3ff, 0xc93e,		0x21, 0
	.dw 0xc440, 0xc93e,	0xc47f, 0xc93e,		0x21, 0
	.dw 0xc4c0, 0xc93e,	0xc4ff, 0xc93e,		0x21, 0
	.dw 0xc540, 0xc93e,	0xc57f, 0xc93e,		0x21, 0
	.dw 0xc5c0, 0xc93e,	0xc5ff, 0xc93e,		0x21, 0
	.dw 0xc640, 0xc93e,	0xc67f, 0xc93e,		0x21, 0
	.dw 0xc6c0, 0xc93e,	0xc6ff, 0xc93e,		0x21, 0
	.dw 0xc740, 0xc93e,	0xc77f, 0xc93e,		0x21, 0
	.dw 0xc7c0, 0xc93e,	0xc7ff, 0xc93e,		0x21, 0
	.dw 0xc840, 0xc93e,	0xc87f, 0xc93e,		0x21, 0
	.dw 0xc8c0, 0xc93e,	0xc8ff, 0xc93e,		0x21, 0
	.dw 0xc940, 0xc93e,	0xc97f, 0xc93e,		0x21, 0
	.dw 0xc9c0, 0xc93e,	0xc9ff, 0xc93e,		0x21, 0
	.dw 0xca40, 0xc93e,	0xca7f, 0xc93e,		0x21, 0
	.dw 0xcac0, 0xc93e,	0xcaff, 0xc93e,		0x21, 0
	.dw 0xcb40, 0xc93e,	0xcb7f, 0xc93e,		0x21, 0
	.dw 0xcbc0, 0xc93e,	0xcbff, 0xc93e,		0x21, 0
	.dw 0xcc40, 0xc93e,	0xcc7f, 0xc93e,		0x21, 0
	.dw 0xccc0, 0xc93e,	0xccff, 0xc93e,		0x21, 0
	.dw 0xcd40, 0xc93e,	0xcd7f, 0xc93e,		0x21, 0
	.dw 0xcdc0, 0xc93e,	0xcdff, 0xc93e,		0x21, 0
	.dw 0xce40, 0xc93e,	0xce7f, 0xc93e,		0x21, 0
	.dw 0xcec0, 0xc93e,	0xceff, 0xc93e,		0x21, 0
	.dw 0xcf40, 0xc93e,	0xcf7f, 0xc93e,		0x21, 0
	.dw 0xcfc0, 0xc93e,	0xcfff, 0xc93e,		0x21, 0
	.dw 0xd040, 0xc93e,	0xd07f, 0xc93e,		0x21, 0
	.dw 0xd0c0, 0xc93e,	0xd0ff, 0xc93e,		0x21, 0
	.dw 0xd140, 0xc93e,	0xd17f, 0xc93e,		0x21, 0
	.dw 0xd1c0, 0xc93e,	0xd1ff, 0xc93e,		0x21, 0
	.dw 0xd240, 0xc93e,	0xd27f, 0xc93e,		0x21, 0
	.dw 0xd2c0, 0xc93e,	0xd2ff, 0xc93e,		0x21, 0
	.dw 0xd340, 0xc93e,	0xd37f, 0xc93e,		0x21, 0
	.dw 0xd3c0, 0xc93e,	0xd3ff, 0xc93e,		0x21, 0
	.dw 0xd440, 0xc93e,	0xd47f, 0xc93e,		0x21, 0
	.dw 0xd4c0, 0xc93e,	0xd4ff, 0xc93e,		0x21, 0
	.dw 0xd540, 0xc93e,	0xd57f, 0xc93e,		0x21, 0
	.dw 0xd5c0, 0xc93e,	0xd5ff, 0xc93e,		0x21, 0
	.dw 0xd640, 0xc93e,	0xd67f, 0xc93e,		0x21, 0
	.dw 0xd6c0, 0xc93e,	0xd6ff, 0xc93e,		0x21, 0
	.dw 0xd740, 0xc93e,	0xd77f, 0xc93e,		0x21, 0
	.dw 0xd7c0, 0xc93e,	0xd7ff, 0xc93e,		0x21, 0
	.dw 0xd840, 0xc93e,	0xd87f, 0xc93e,		0x21, 0
	.dw 0xd8c0, 0xc93e,	0xd8ff, 0xc93e,		0x21, 0
	.dw 0xd940, 0xc93e,	0xd97f, 0xc93e,		0x21, 0
	.dw 0xd9c0, 0xc93e,	0xdfff, 0xc93e,		0x21, 0
	.dw 0xe040, 0xc93e,	0xe07f, 0xc93e,		0x21, 0
	.dw 0xe0c0, 0xc93e,	0xe0ff, 0xc93e,		0x21, 0
	.dw 0xe140, 0xc93e,	0xe17f, 0xc93e,		0x21, 0
	.dw 0xe1c0, 0xc93e,	0xe1ff, 0xc93e,		0x21, 0
	.dw 0xe240, 0xc93e,	0xe27f, 0xc93e,		0x21, 0
	.dw 0xe2c0, 0xc93e,	0xe2ff, 0xc93e,		0x21, 0
	.dw 0xe340, 0xc93e,	0xe37f, 0xc93e,		0x21, 0
	.dw 0xe3c0, 0xc93e,	0xe3ff, 0xc93e,		0x21, 0
	.dw 0xe440, 0xc93e,	0xe47f, 0xc93e,		0x21, 0
	.dw 0xe4c0, 0xc93e,	0xe4ff, 0xc93e,		0x21, 0
	.dw 0xe540, 0xc93e,	0xe57f, 0xc93e,		0x21, 0
	.dw 0xe5c0, 0xc93e,	0xe5ff, 0xc93e,		0x21, 0
	.dw 0xe640, 0xc93e,	0xe67f, 0xc93e,		0x21, 0
	.dw 0xe6c0, 0xc93e,	0xe6ff, 0xc93e,		0x21, 0
	.dw 0xe740, 0xc93e,	0xe77f, 0xc93e,		0x21, 0
	.dw 0xe7c0, 0xc93e,	0xe7ff, 0xc93e,		0x21, 0
	.dw 0xe840, 0xc93e,	0xe87f, 0xc93e,		0x21, 0
	.dw 0xe8c0, 0xc93e,	0xe8ff, 0xc93e,		0x21, 0
	.dw 0xe940, 0xc93e,	0xe97f, 0xc93e,		0x21, 0
	.dw 0xe9c0, 0xc93e,	0xe9ff, 0xc93e,		0x21, 0
	.dw 0xea40, 0xc93e,	0xea7f, 0xc93e,		0x21, 0
	.dw 0xeac0, 0xc93e,	0xeaff, 0xc93e,		0x21, 0
	.dw 0xeb40, 0xc93e,	0xeb7f, 0xc93e,		0x21, 0
	.dw 0xebc0, 0xc93e,	0xebff, 0xc93e,		0x21, 0
	.dw 0xec40, 0xc93e,	0xec7f, 0xc93e,		0x21, 0
	.dw 0xecc0, 0xc93e,	0xecff, 0xc93e,		0x21, 0
	.dw 0xed40, 0xc93e,	0xed7f, 0xc93e,		0x21, 0
	.dw 0xedc0, 0xc93e,	0xedff, 0xc93e,		0x21, 0
	.dw 0xee40, 0xc93e,	0xee7f, 0xc93e,		0x21, 0
	.dw 0xeec0, 0xc93e,	0xeeff, 0xc93e,		0x21, 0
	.dw 0xef40, 0xc93e,	0xef7f, 0xc93e,		0x21, 0
	.dw 0xefc0, 0xc93e,	0xefff, 0xc93e,		0x21, 0
	.dw 0xf040, 0xc93e,	0xf07f, 0xc93e,		0x21, 0
	.dw 0xf0c0, 0xc93e,	0xf0ff, 0xc93e,		0x21, 0
	.dw 0xf140, 0xc93e,	0xf17f, 0xc93e,		0x21, 0
	.dw 0xf1c0, 0xc93e,	0xf1ff, 0xc93e,		0x21, 0
	.dw 0xf240, 0xc93e,	0xf27f, 0xc93e,		0x21, 0
	.dw 0xf2c0, 0xc93e,	0xf2ff, 0xc93e,		0x21, 0
	.dw 0xf340, 0xc93e,	0xf37f, 0xc93e,		0x21, 0
	.dw 0xf3c0, 0xc93e,	0xf3ff, 0xc93e,		0x21, 0
	.dw 0xf440, 0xc93e,	0xf47f, 0xc93e,		0x21, 0
	.dw 0xf4c0, 0xc93e,	0xf4ff, 0xc93e,		0x21, 0
	.dw 0xf540, 0xc93e,	0xf57f, 0xc93e,		0x21, 0
	.dw 0xf5c0, 0xc93e,	0xf5ff, 0xc93e,		0x21, 0
	.dw 0xf640, 0xc93e,	0xf67f, 0xc93e,		0x21, 0
	.dw 0xf6c0, 0xc93e,	0xf6ff, 0xc93e,		0x21, 0
	.dw 0xf740, 0xc93e,	0xf77f, 0xc93e,		0x21, 0
	.dw 0xf7c0, 0xc93e,	0xf7ff, 0xc93e,		0x21, 0
	.dw 0xf840, 0xc93e,	0xf87f, 0xc93e,		0x21, 0
	.dw 0xf8c0, 0xc93e,	0xf8ff, 0xc93e,		0x21, 0
	.dw 0xf940, 0xc93e,	0xf97f, 0xc93e,		0x21, 0
	.dw 0xf9c0, 0xc93e,	0xffff, 0xc93e,		0x21, 0
	.dw 0x0040, 0xc93f,	0x007f, 0xc93f,		0x21, 0
	.dw 0x00c0, 0xc93f,	0x00ff, 0xc93f,		0x21, 0
	.dw 0x0140, 0xc93f,	0x017f, 0xc93f,		0x21, 0
	.dw 0x01c0, 0xc93f,	0x01ff, 0xc93f,		0x21, 0
	.dw 0x0240, 0xc93f,	0x027f, 0xc93f,		0x21, 0
	.dw 0x02c0, 0xc93f,	0x02ff, 0xc93f,		0x21, 0
	.dw 0x0340, 0xc93f,	0x037f, 0xc93f,		0x21, 0
	.dw 0x03c0, 0xc93f,	0x03ff, 0xc93f,		0x21, 0
	.dw 0x0440, 0xc93f,	0x047f, 0xc93f,		0x21, 0
	.dw 0x04c0, 0xc93f,	0x04ff, 0xc93f,		0x21, 0
	.dw 0x0540, 0xc93f,	0x057f, 0xc93f,		0x21, 0
	.dw 0x05c0, 0xc93f,	0x05ff, 0xc93f,		0x21, 0
	.dw 0x0640, 0xc93f,	0x067f, 0xc93f,		0x21, 0
	.dw 0x06c0, 0xc93f,	0x06ff, 0xc93f,		0x21, 0
	.dw 0x0740, 0xc93f,	0x077f, 0xc93f,		0x21, 0
	.dw 0x07c0, 0xc93f,	0x07ff, 0xc93f,		0x21, 0
	.dw 0x0840, 0xc93f,	0x087f, 0xc93f,		0x21, 0
	.dw 0x08c0, 0xc93f,	0x08ff, 0xc93f,		0x21, 0
	.dw 0x0940, 0xc93f,	0x097f, 0xc93f,		0x21, 0
	.dw 0x09c0, 0xc93f,	0x09ff, 0xc93f,		0x21, 0
	.dw 0x0a40, 0xc93f,	0x0a7f, 0xc93f,		0x21, 0
	.dw 0x0ac0, 0xc93f,	0x0aff, 0xc93f,		0x21, 0
	.dw 0x0b40, 0xc93f,	0x0b7f, 0xc93f,		0x21, 0
	.dw 0x0bc0, 0xc93f,	0x0bff, 0xc93f,		0x21, 0
	.dw 0x0c40, 0xc93f,	0x0c7f, 0xc93f,		0x21, 0
	.dw 0x0cc0, 0xc93f,	0x0cff, 0xc93f,		0x21, 0
	.dw 0x0d40, 0xc93f,	0x0d7f, 0xc93f,		0x21, 0
	.dw 0x0dc0, 0xc93f,	0x0dff, 0xc93f,		0x21, 0
	.dw 0x0e40, 0xc93f,	0x0e7f, 0xc93f,		0x21, 0
	.dw 0x0ec0, 0xc93f,	0x0eff, 0xc93f,		0x21, 0
	.dw 0x0f40, 0xc93f,	0x0f7f, 0xc93f,		0x21, 0
	.dw 0x0fc0, 0xc93f,	0x0fff, 0xc93f,		0x21, 0
	.dw 0x1040, 0xc93f,	0x107f, 0xc93f,		0x21, 0
	.dw 0x10c0, 0xc93f,	0x10ff, 0xc93f,		0x21, 0
	.dw 0x1140, 0xc93f,	0x117f, 0xc93f,		0x21, 0
	.dw 0x11c0, 0xc93f,	0x11ff, 0xc93f,		0x21, 0
	.dw 0x1240, 0xc93f,	0x127f, 0xc93f,		0x21, 0
	.dw 0x12c0, 0xc93f,	0x12ff, 0xc93f,		0x21, 0
	.dw 0x1340, 0xc93f,	0x137f, 0xc93f,		0x21, 0
	.dw 0x13c0, 0xc93f,	0x13ff, 0xc93f,		0x21, 0
	.dw 0x1440, 0xc93f,	0x147f, 0xc93f,		0x21, 0
	.dw 0x14c0, 0xc93f,	0x14ff, 0xc93f,		0x21, 0
	.dw 0x1540, 0xc93f,	0x157f, 0xc93f,		0x21, 0
	.dw 0x15c0, 0xc93f,	0x15ff, 0xc93f,		0x21, 0
	.dw 0x1640, 0xc93f,	0x167f, 0xc93f,		0x21, 0
	.dw 0x16c0, 0xc93f,	0x16ff, 0xc93f,		0x21, 0
	.dw 0x1740, 0xc93f,	0x177f, 0xc93f,		0x21, 0
	.dw 0x17c0, 0xc93f,	0x17ff, 0xc93f,		0x21, 0
	.dw 0x1840, 0xc93f,	0x187f, 0xc93f,		0x21, 0
	.dw 0x18c0, 0xc93f,	0x18ff, 0xc93f,		0x21, 0
	.dw 0x1940, 0xc93f,	0x197f, 0xc93f,		0x21, 0
	.dw 0x19c0, 0xc93f,	0x1fff, 0xc93f,		0x21, 0
	.dw 0x2040, 0xc93f,	0x207f, 0xc93f,		0x21, 0
	.dw 0x20c0, 0xc93f,	0x20ff, 0xc93f,		0x21, 0
	.dw 0x2140, 0xc93f,	0x217f, 0xc93f,		0x21, 0
	.dw 0x21c0, 0xc93f,	0x21ff, 0xc93f,		0x21, 0
	.dw 0x2240, 0xc93f,	0x227f, 0xc93f,		0x21, 0
	.dw 0x22c0, 0xc93f,	0x22ff, 0xc93f,		0x21, 0
	.dw 0x2340, 0xc93f,	0x237f, 0xc93f,		0x21, 0
	.dw 0x23c0, 0xc93f,	0x23ff, 0xc93f,		0x21, 0
	.dw 0x2440, 0xc93f,	0x247f, 0xc93f,		0x21, 0
	.dw 0x24c0, 0xc93f,	0x24ff, 0xc93f,		0x21, 0
	.dw 0x2540, 0xc93f,	0x257f, 0xc93f,		0x21, 0
	.dw 0x25c0, 0xc93f,	0x25ff, 0xc93f,		0x21, 0
	.dw 0x2640, 0xc93f,	0x267f, 0xc93f,		0x21, 0
	.dw 0x26c0, 0xc93f,	0x26ff, 0xc93f,		0x21, 0
	.dw 0x2740, 0xc93f,	0x277f, 0xc93f,		0x21, 0
	.dw 0x27c0, 0xc93f,	0x27ff, 0xc93f,		0x21, 0
	.dw 0x2840, 0xc93f,	0x287f, 0xc93f,		0x21, 0
	.dw 0x28c0, 0xc93f,	0x28ff, 0xc93f,		0x21, 0
	.dw 0x2940, 0xc93f,	0x297f, 0xc93f,		0x21, 0
	.dw 0x29c0, 0xc93f,	0x29ff, 0xc93f,		0x21, 0
	.dw 0x2a40, 0xc93f,	0x2a7f, 0xc93f,		0x21, 0
	.dw 0x2ac0, 0xc93f,	0x2aff, 0xc93f,		0x21, 0
	.dw 0x2b40, 0xc93f,	0x2b7f, 0xc93f,		0x21, 0
	.dw 0x2bc0, 0xc93f,	0x2bff, 0xc93f,		0x21, 0
	.dw 0x2c40, 0xc93f,	0x2c7f, 0xc93f,		0x21, 0
	.dw 0x2cc0, 0xc93f,	0x2cff, 0xc93f,		0x21, 0
	.dw 0x2d40, 0xc93f,	0x2d7f, 0xc93f,		0x21, 0
	.dw 0x2dc0, 0xc93f,	0x2dff, 0xc93f,		0x21, 0
	.dw 0x2e40, 0xc93f,	0x2e7f, 0xc93f,		0x21, 0
	.dw 0x2ec0, 0xc93f,	0x2eff, 0xc93f,		0x21, 0
	.dw 0x2f40, 0xc93f,	0x2f7f, 0xc93f,		0x21, 0
	.dw 0x2fc0, 0xc93f,	0x2fff, 0xc93f,		0x21, 0
	.dw 0x3040, 0xc93f,	0x307f, 0xc93f,		0x21, 0
	.dw 0x30c0, 0xc93f,	0x30ff, 0xc93f,		0x21, 0
	.dw 0x3140, 0xc93f,	0x317f, 0xc93f,		0x21, 0
	.dw 0x31c0, 0xc93f,	0x31ff, 0xc93f,		0x21, 0
	.dw 0x3240, 0xc93f,	0x327f, 0xc93f,		0x21, 0
	.dw 0x32c0, 0xc93f,	0x32ff, 0xc93f,		0x21, 0
	.dw 0x3340, 0xc93f,	0x337f, 0xc93f,		0x21, 0
	.dw 0x33c0, 0xc93f,	0x33ff, 0xc93f,		0x21, 0
	.dw 0x3440, 0xc93f,	0x347f, 0xc93f,		0x21, 0
	.dw 0x34c0, 0xc93f,	0x34ff, 0xc93f,		0x21, 0
	.dw 0x3540, 0xc93f,	0x357f, 0xc93f,		0x21, 0
	.dw 0x35c0, 0xc93f,	0x35ff, 0xc93f,		0x21, 0
	.dw 0x3640, 0xc93f,	0x367f, 0xc93f,		0x21, 0
	.dw 0x36c0, 0xc93f,	0x36ff, 0xc93f,		0x21, 0
	.dw 0x3740, 0xc93f,	0x377f, 0xc93f,		0x21, 0
	.dw 0x37c0, 0xc93f,	0x37ff, 0xc93f,		0x21, 0
	.dw 0x3840, 0xc93f,	0x387f, 0xc93f,		0x21, 0
	.dw 0x38c0, 0xc93f,	0x38ff, 0xc93f,		0x21, 0
	.dw 0x3940, 0xc93f,	0x397f, 0xc93f,		0x21, 0
	.dw 0x39c0, 0xc93f,	0x1fff, 0xc960,		0x21, 0
	.dw 0x3a00, 0xc960,	0x5fff, 0xc960,		0x21, 0
	.dw 0x7a00, 0xc960,	0x9fff, 0xc960,		0x21, 0
	.dw 0xba00, 0xc960,	0xdfff, 0xc960,		0x21, 0
	.dw 0xfa00, 0xc960,	0x1fff, 0xc961,		0x21, 0
	.dw 0x3a00, 0xc961,	0x5fff, 0xc961,		0x21, 0
	.dw 0x7a00, 0xc961,	0x9fff, 0xc961,		0x21, 0
	.dw 0xba00, 0xc961,	0xdfff, 0xc961,		0x21, 0
	.dw 0xfa00, 0xc961,	0x1fff, 0xc962,		0x21, 0
	.dw 0x3a00, 0xc962,	0x5fff, 0xc962,		0x21, 0
	.dw 0x7a00, 0xc962,	0x9fff, 0xc962,		0x21, 0
	.dw 0xba00, 0xc962,	0xdfff, 0xc962,		0x21, 0
	.dw 0xfa00, 0xc962,	0x1fff, 0xc963,		0x21, 0
	.dw 0x3a00, 0xc963,	0xffff, 0xc963,		0x21, 0
	.dw 0x1a00, 0xc964,	0x1fff, 0xc964,		0x21, 0
	.dw 0x3a00, 0xc964,	0x3fff, 0xc964,		0x21, 0
	.dw 0x5a00, 0xc964,	0x5fff, 0xc964,		0x21, 0
	.dw 0x7a00, 0xc964,	0x7fff, 0xc964,		0x21, 0
	.dw 0x9a00, 0xc964,	0x9fff, 0xc964,		0x21, 0
	.dw 0xba00, 0xc964,	0xbfff, 0xc964,		0x21, 0
	.dw 0xda00, 0xc964,	0xdfff, 0xc964,		0x21, 0
	.dw 0xfa00, 0xc964,	0xffff, 0xc964,		0x21, 0
	.dw 0x1a00, 0xc965,	0x1fff, 0xc965,		0x21, 0
	.dw 0x3a00, 0xc965,	0x3fff, 0xc965,		0x21, 0
	.dw 0x5a00, 0xc965,	0x5fff, 0xc965,		0x21, 0
	.dw 0x7a00, 0xc965,	0x7fff, 0xc965,		0x21, 0
	.dw 0x9a00, 0xc965,	0x9fff, 0xc965,		0x21, 0
	.dw 0xba00, 0xc965,	0xbfff, 0xc965,		0x21, 0
	.dw 0xda00, 0xc965,	0xdfff, 0xc965,		0x21, 0
	.dw 0xfa00, 0xc965,	0xffff, 0xc965,		0x21, 0
	.dw 0x1a00, 0xc966,	0x1fff, 0xc966,		0x21, 0
	.dw 0x3a00, 0xc966,	0x3fff, 0xc966,		0x21, 0
	.dw 0x5a00, 0xc966,	0x5fff, 0xc966,		0x21, 0
	.dw 0x7a00, 0xc966,	0x7fff, 0xc966,		0x21, 0
	.dw 0x9a00, 0xc966,	0x9fff, 0xc966,		0x21, 0
	.dw 0xba00, 0xc966,	0xbfff, 0xc966,		0x21, 0
	.dw 0xda00, 0xc966,	0xdfff, 0xc966,		0x21, 0
	.dw 0xfa00, 0xc966,	0xffff, 0xc966,		0x21, 0
	.dw 0x1a00, 0xc967,	0x1fff, 0xc967,		0x21, 0
	.dw 0x3a00, 0xc967,	0x1fff, 0xc970,		0x21, 0
	.dw 0x3a00, 0xc970,	0x5fff, 0xc970,		0x21, 0
	.dw 0x7a00, 0xc970,	0x9fff, 0xc970,		0x21, 0
	.dw 0xba00, 0xc970,	0xdfff, 0xc970,		0x21, 0
	.dw 0xfa00, 0xc970,	0x1fff, 0xc971,		0x21, 0
	.dw 0x3a00, 0xc971,	0x5fff, 0xc971,		0x21, 0
	.dw 0x7a00, 0xc971,	0x9fff, 0xc971,		0x21, 0
	.dw 0xba00, 0xc971,	0xdfff, 0xc971,		0x21, 0
	.dw 0xfa00, 0xc971,	0x1fff, 0xc972,		0x21, 0
	.dw 0x3a00, 0xc972,	0x5fff, 0xc972,		0x21, 0
	.dw 0x7a00, 0xc972,	0x9fff, 0xc972,		0x21, 0
	.dw 0xba00, 0xc972,	0xdfff, 0xc972,		0x21, 0
	.dw 0xfa00, 0xc972,	0xffff, 0xc973,		0x21, 0
	.dw 0x1a00, 0xc974,	0x1fff, 0xc974,		0x21, 0
	.dw 0x3a00, 0xc974,	0x3fff, 0xc974,		0x21, 0
	.dw 0x5a00, 0xc974,	0x5fff, 0xc974,		0x21, 0
	.dw 0x7a00, 0xc974,	0x7fff, 0xc974,		0x21, 0
	.dw 0x9a00, 0xc974,	0x9fff, 0xc974,		0x21, 0
	.dw 0xba00, 0xc974,	0xbfff, 0xc974,		0x21, 0
	.dw 0xda00, 0xc974,	0xdfff, 0xc974,		0x21, 0
	.dw 0xfa00, 0xc974,	0xffff, 0xc974,		0x21, 0
	.dw 0x1a00, 0xc975,	0x1fff, 0xc975,		0x21, 0
	.dw 0x3a00, 0xc975,	0x3fff, 0xc975,		0x21, 0
	.dw 0x5a00, 0xc975,	0x5fff, 0xc975,		0x21, 0
	.dw 0x7a00, 0xc975,	0x7fff, 0xc975,		0x21, 0
	.dw 0x9a00, 0xc975,	0x9fff, 0xc975,		0x21, 0
	.dw 0xba00, 0xc975,	0xbfff, 0xc975,		0x21, 0
	.dw 0xda00, 0xc975,	0xdfff, 0xc975,		0x21, 0
	.dw 0xfa00, 0xc975,	0xffff, 0xc975,		0x21, 0
	.dw 0x1a00, 0xc976,	0x1fff, 0xc976,		0x21, 0
	.dw 0x3a00, 0xc976,	0x3fff, 0xc976,		0x21, 0
	.dw 0x5a00, 0xc976,	0x5fff, 0xc976,		0x21, 0
	.dw 0x7a00, 0xc976,	0x7fff, 0xc976,		0x21, 0
	.dw 0x9a00, 0xc976,	0x9fff, 0xc976,		0x21, 0
	.dw 0xba00, 0xc976,	0xbfff, 0xc976,		0x21, 0
	.dw 0xda00, 0xc976,	0xdfff, 0xc976,		0x21, 0
	.dw 0xfa00, 0xc976,	0xffff, 0xc976,		0x21, 0
	.dw 0x1a00, 0xc977,	0x1fff, 0xc977,		0x21, 0
	.dw 0x3a00, 0xc977,	0x1fff, 0xc980,		0x21, 0
	.dw 0x3a00, 0xc980,	0x5fff, 0xc980,		0x21, 0
	.dw 0x7a00, 0xc980,	0x9fff, 0xc980,		0x21, 0
	.dw 0xba00, 0xc980,	0xdfff, 0xc980,		0x21, 0
	.dw 0xfa00, 0xc980,	0x1fff, 0xc981,		0x21, 0
	.dw 0x3a00, 0xc981,	0x5fff, 0xc981,		0x21, 0
	.dw 0x7a00, 0xc981,	0x9fff, 0xc981,		0x21, 0
	.dw 0xba00, 0xc981,	0xdfff, 0xc981,		0x21, 0
	.dw 0xfa00, 0xc981,	0x1fff, 0xc982,		0x21, 0
	.dw 0x3a00, 0xc982,	0x5fff, 0xc982,		0x21, 0
	.dw 0x7a00, 0xc982,	0x9fff, 0xc982,		0x21, 0
	.dw 0xba00, 0xc982,	0xdfff, 0xc982,		0x21, 0
	.dw 0xfa00, 0xc982,	0x1fff, 0xc983,		0x21, 0
	.dw 0x3a00, 0xc983,	0xffff, 0xc983,		0x21, 0
	.dw 0x1a00, 0xc984,	0x1fff, 0xc984,		0x21, 0
	.dw 0x3a00, 0xc984,	0x3fff, 0xc984,		0x21, 0
	.dw 0x5a00, 0xc984,	0x5fff, 0xc984,		0x21, 0
	.dw 0x7a00, 0xc984,	0x7fff, 0xc984,		0x21, 0
	.dw 0x9a00, 0xc984,	0x9fff, 0xc984,		0x21, 0
	.dw 0xba00, 0xc984,	0xbfff, 0xc984,		0x21, 0
	.dw 0xda00, 0xc984,	0xdfff, 0xc984,		0x21, 0
	.dw 0xfa00, 0xc984,	0xffff, 0xc984,		0x21, 0
	.dw 0x1a00, 0xc985,	0x1fff, 0xc985,		0x21, 0
	.dw 0x3a00, 0xc985,	0x3fff, 0xc985,		0x21, 0
	.dw 0x5a00, 0xc985,	0x5fff, 0xc985,		0x21, 0
	.dw 0x7a00, 0xc985,	0x7fff, 0xc985,		0x21, 0
	.dw 0x9a00, 0xc985,	0x9fff, 0xc985,		0x21, 0
	.dw 0xba00, 0xc985,	0xbfff, 0xc985,		0x21, 0
	.dw 0xda00, 0xc985,	0xdfff, 0xc985,		0x21, 0
	.dw 0xfa00, 0xc985,	0xffff, 0xc985,		0x21, 0
	.dw 0x1a00, 0xc986,	0x1fff, 0xc986,		0x21, 0
	.dw 0x3a00, 0xc986,	0x3fff, 0xc986,		0x21, 0
	.dw 0x5a00, 0xc986,	0x5fff, 0xc986,		0x21, 0
	.dw 0x7a00, 0xc986,	0x7fff, 0xc986,		0x21, 0
	.dw 0x9a00, 0xc986,	0x9fff, 0xc986,		0x21, 0
	.dw 0xba00, 0xc986,	0xbfff, 0xc986,		0x21, 0
	.dw 0xda00, 0xc986,	0xdfff, 0xc986,		0x21, 0
	.dw 0xfa00, 0xc986,	0xffff, 0xc986,		0x21, 0
	.dw 0x1a00, 0xc987,	0x1fff, 0xc987,		0x21, 0
	.dw 0x3a00, 0xc987,	0x1fff, 0xc988,		0x21, 0
	.dw 0x2040, 0xc988,	0x207f, 0xc988,		0x21, 0
	.dw 0x20c0, 0xc988,	0x20ff, 0xc988,		0x21, 0
	.dw 0x2140, 0xc988,	0x217f, 0xc988,		0x21, 0
	.dw 0x21c0, 0xc988,	0x21ff, 0xc988,		0x21, 0
	.dw 0x2240, 0xc988,	0x227f, 0xc988,		0x21, 0
	.dw 0x22c0, 0xc988,	0x22ff, 0xc988,		0x21, 0
	.dw 0x2340, 0xc988,	0x237f, 0xc988,		0x21, 0
	.dw 0x23c0, 0xc988,	0x23ff, 0xc988,		0x21, 0
	.dw 0x2440, 0xc988,	0x247f, 0xc988,		0x21, 0
	.dw 0x24c0, 0xc988,	0x24ff, 0xc988,		0x21, 0
	.dw 0x2540, 0xc988,	0x257f, 0xc988,		0x21, 0
	.dw 0x25c0, 0xc988,	0x25ff, 0xc988,		0x21, 0
	.dw 0x2640, 0xc988,	0x267f, 0xc988,		0x21, 0
	.dw 0x26c0, 0xc988,	0x26ff, 0xc988,		0x21, 0
	.dw 0x2740, 0xc988,	0x277f, 0xc988,		0x21, 0
	.dw 0x27c0, 0xc988,	0x27ff, 0xc988,		0x21, 0
	.dw 0x2840, 0xc988,	0x287f, 0xc988,		0x21, 0
	.dw 0x28c0, 0xc988,	0x28ff, 0xc988,		0x21, 0
	.dw 0x2940, 0xc988,	0x297f, 0xc988,		0x21, 0
	.dw 0x29c0, 0xc988,	0x29ff, 0xc988,		0x21, 0
	.dw 0x2a40, 0xc988,	0x2a7f, 0xc988,		0x21, 0
	.dw 0x2ac0, 0xc988,	0x2aff, 0xc988,		0x21, 0
	.dw 0x2b40, 0xc988,	0x2b7f, 0xc988,		0x21, 0
	.dw 0x2bc0, 0xc988,	0x2bff, 0xc988,		0x21, 0
	.dw 0x2c40, 0xc988,	0x2c7f, 0xc988,		0x21, 0
	.dw 0x2cc0, 0xc988,	0x2cff, 0xc988,		0x21, 0
	.dw 0x2d40, 0xc988,	0x2d7f, 0xc988,		0x21, 0
	.dw 0x2dc0, 0xc988,	0x2dff, 0xc988,		0x21, 0
	.dw 0x2e40, 0xc988,	0x2e7f, 0xc988,		0x21, 0
	.dw 0x2ec0, 0xc988,	0x2eff, 0xc988,		0x21, 0
	.dw 0x2f40, 0xc988,	0x2f7f, 0xc988,		0x21, 0
	.dw 0x2fc0, 0xc988,	0x2fff, 0xc988,		0x21, 0
	.dw 0x3040, 0xc988,	0x307f, 0xc988,		0x21, 0
	.dw 0x30c0, 0xc988,	0x30ff, 0xc988,		0x21, 0
	.dw 0x3140, 0xc988,	0x317f, 0xc988,		0x21, 0
	.dw 0x31c0, 0xc988,	0x31ff, 0xc988,		0x21, 0
	.dw 0x3240, 0xc988,	0x327f, 0xc988,		0x21, 0
	.dw 0x32c0, 0xc988,	0x32ff, 0xc988,		0x21, 0
	.dw 0x3340, 0xc988,	0x337f, 0xc988,		0x21, 0
	.dw 0x33c0, 0xc988,	0x33ff, 0xc988,		0x21, 0
	.dw 0x3440, 0xc988,	0x347f, 0xc988,		0x21, 0
	.dw 0x34c0, 0xc988,	0x34ff, 0xc988,		0x21, 0
	.dw 0x3540, 0xc988,	0x357f, 0xc988,		0x21, 0
	.dw 0x35c0, 0xc988,	0x35ff, 0xc988,		0x21, 0
	.dw 0x3640, 0xc988,	0x367f, 0xc988,		0x21, 0
	.dw 0x36c0, 0xc988,	0x36ff, 0xc988,		0x21, 0
	.dw 0x3740, 0xc988,	0x377f, 0xc988,		0x21, 0
	.dw 0x37c0, 0xc988,	0x37ff, 0xc988,		0x21, 0
	.dw 0x3840, 0xc988,	0x387f, 0xc988,		0x21, 0
	.dw 0x38c0, 0xc988,	0x38ff, 0xc988,		0x21, 0
	.dw 0x3940, 0xc988,	0x397f, 0xc988,		0x21, 0
	.dw 0x39c0, 0xc988,	0x5fff, 0xc988,		0x21, 0
	.dw 0x6040, 0xc988,	0x607f, 0xc988,		0x21, 0
	.dw 0x60c0, 0xc988,	0x60ff, 0xc988,		0x21, 0
	.dw 0x6140, 0xc988,	0x617f, 0xc988,		0x21, 0
	.dw 0x61c0, 0xc988,	0x61ff, 0xc988,		0x21, 0
	.dw 0x6240, 0xc988,	0x627f, 0xc988,		0x21, 0
	.dw 0x62c0, 0xc988,	0x62ff, 0xc988,		0x21, 0
	.dw 0x6340, 0xc988,	0x637f, 0xc988,		0x21, 0
	.dw 0x63c0, 0xc988,	0x63ff, 0xc988,		0x21, 0
	.dw 0x6440, 0xc988,	0x647f, 0xc988,		0x21, 0
	.dw 0x64c0, 0xc988,	0x64ff, 0xc988,		0x21, 0
	.dw 0x6540, 0xc988,	0x657f, 0xc988,		0x21, 0
	.dw 0x65c0, 0xc988,	0x65ff, 0xc988,		0x21, 0
	.dw 0x6640, 0xc988,	0x667f, 0xc988,		0x21, 0
	.dw 0x66c0, 0xc988,	0x66ff, 0xc988,		0x21, 0
	.dw 0x6740, 0xc988,	0x677f, 0xc988,		0x21, 0
	.dw 0x67c0, 0xc988,	0x67ff, 0xc988,		0x21, 0
	.dw 0x6840, 0xc988,	0x687f, 0xc988,		0x21, 0
	.dw 0x68c0, 0xc988,	0x68ff, 0xc988,		0x21, 0
	.dw 0x6940, 0xc988,	0x697f, 0xc988,		0x21, 0
	.dw 0x69c0, 0xc988,	0x69ff, 0xc988,		0x21, 0
	.dw 0x6a40, 0xc988,	0x6a7f, 0xc988,		0x21, 0
	.dw 0x6ac0, 0xc988,	0x6aff, 0xc988,		0x21, 0
	.dw 0x6b40, 0xc988,	0x6b7f, 0xc988,		0x21, 0
	.dw 0x6bc0, 0xc988,	0x6bff, 0xc988,		0x21, 0
	.dw 0x6c40, 0xc988,	0x6c7f, 0xc988,		0x21, 0
	.dw 0x6cc0, 0xc988,	0x6cff, 0xc988,		0x21, 0
	.dw 0x6d40, 0xc988,	0x6d7f, 0xc988,		0x21, 0
	.dw 0x6dc0, 0xc988,	0x6dff, 0xc988,		0x21, 0
	.dw 0x6e40, 0xc988,	0x6e7f, 0xc988,		0x21, 0
	.dw 0x6ec0, 0xc988,	0x6eff, 0xc988,		0x21, 0
	.dw 0x6f40, 0xc988,	0x6f7f, 0xc988,		0x21, 0
	.dw 0x6fc0, 0xc988,	0x6fff, 0xc988,		0x21, 0
	.dw 0x7040, 0xc988,	0x707f, 0xc988,		0x21, 0
	.dw 0x70c0, 0xc988,	0x70ff, 0xc988,		0x21, 0
	.dw 0x7140, 0xc988,	0x717f, 0xc988,		0x21, 0
	.dw 0x71c0, 0xc988,	0x71ff, 0xc988,		0x21, 0
	.dw 0x7240, 0xc988,	0x727f, 0xc988,		0x21, 0
	.dw 0x72c0, 0xc988,	0x72ff, 0xc988,		0x21, 0
	.dw 0x7340, 0xc988,	0x737f, 0xc988,		0x21, 0
	.dw 0x73c0, 0xc988,	0x73ff, 0xc988,		0x21, 0
	.dw 0x7440, 0xc988,	0x747f, 0xc988,		0x21, 0
	.dw 0x74c0, 0xc988,	0x74ff, 0xc988,		0x21, 0
	.dw 0x7540, 0xc988,	0x757f, 0xc988,		0x21, 0
	.dw 0x75c0, 0xc988,	0x75ff, 0xc988,		0x21, 0
	.dw 0x7640, 0xc988,	0x767f, 0xc988,		0x21, 0
	.dw 0x76c0, 0xc988,	0x76ff, 0xc988,		0x21, 0
	.dw 0x7740, 0xc988,	0x777f, 0xc988,		0x21, 0
	.dw 0x77c0, 0xc988,	0x77ff, 0xc988,		0x21, 0
	.dw 0x7840, 0xc988,	0x787f, 0xc988,		0x21, 0
	.dw 0x78c0, 0xc988,	0x78ff, 0xc988,		0x21, 0
	.dw 0x7940, 0xc988,	0x797f, 0xc988,		0x21, 0
	.dw 0x79c0, 0xc988,	0x9fff, 0xc988,		0x21, 0
	.dw 0xa040, 0xc988,	0xa07f, 0xc988,		0x21, 0
	.dw 0xa0c0, 0xc988,	0xa0ff, 0xc988,		0x21, 0
	.dw 0xa140, 0xc988,	0xa17f, 0xc988,		0x21, 0
	.dw 0xa1c0, 0xc988,	0xa1ff, 0xc988,		0x21, 0
	.dw 0xa240, 0xc988,	0xa27f, 0xc988,		0x21, 0
	.dw 0xa2c0, 0xc988,	0xa2ff, 0xc988,		0x21, 0
	.dw 0xa340, 0xc988,	0xa37f, 0xc988,		0x21, 0
	.dw 0xa3c0, 0xc988,	0xa3ff, 0xc988,		0x21, 0
	.dw 0xa440, 0xc988,	0xa47f, 0xc988,		0x21, 0
	.dw 0xa4c0, 0xc988,	0xa4ff, 0xc988,		0x21, 0
	.dw 0xa540, 0xc988,	0xa57f, 0xc988,		0x21, 0
	.dw 0xa5c0, 0xc988,	0xa5ff, 0xc988,		0x21, 0
	.dw 0xa640, 0xc988,	0xa67f, 0xc988,		0x21, 0
	.dw 0xa6c0, 0xc988,	0xa6ff, 0xc988,		0x21, 0
	.dw 0xa740, 0xc988,	0xa77f, 0xc988,		0x21, 0
	.dw 0xa7c0, 0xc988,	0xa7ff, 0xc988,		0x21, 0
	.dw 0xa840, 0xc988,	0xa87f, 0xc988,		0x21, 0
	.dw 0xa8c0, 0xc988,	0xa8ff, 0xc988,		0x21, 0
	.dw 0xa940, 0xc988,	0xa97f, 0xc988,		0x21, 0
	.dw 0xa9c0, 0xc988,	0xa9ff, 0xc988,		0x21, 0
	.dw 0xaa40, 0xc988,	0xaa7f, 0xc988,		0x21, 0
	.dw 0xaac0, 0xc988,	0xaaff, 0xc988,		0x21, 0
	.dw 0xab40, 0xc988,	0xab7f, 0xc988,		0x21, 0
	.dw 0xabc0, 0xc988,	0xabff, 0xc988,		0x21, 0
	.dw 0xac40, 0xc988,	0xac7f, 0xc988,		0x21, 0
	.dw 0xacc0, 0xc988,	0xacff, 0xc988,		0x21, 0
	.dw 0xad40, 0xc988,	0xad7f, 0xc988,		0x21, 0
	.dw 0xadc0, 0xc988,	0xadff, 0xc988,		0x21, 0
	.dw 0xae40, 0xc988,	0xae7f, 0xc988,		0x21, 0
	.dw 0xaec0, 0xc988,	0xaeff, 0xc988,		0x21, 0
	.dw 0xaf40, 0xc988,	0xaf7f, 0xc988,		0x21, 0
	.dw 0xafc0, 0xc988,	0xafff, 0xc988,		0x21, 0
	.dw 0xb040, 0xc988,	0xb07f, 0xc988,		0x21, 0
	.dw 0xb0c0, 0xc988,	0xb0ff, 0xc988,		0x21, 0
	.dw 0xb140, 0xc988,	0xb17f, 0xc988,		0x21, 0
	.dw 0xb1c0, 0xc988,	0xb1ff, 0xc988,		0x21, 0
	.dw 0xb240, 0xc988,	0xb27f, 0xc988,		0x21, 0
	.dw 0xb2c0, 0xc988,	0xb2ff, 0xc988,		0x21, 0
	.dw 0xb340, 0xc988,	0xb37f, 0xc988,		0x21, 0
	.dw 0xb3c0, 0xc988,	0xb3ff, 0xc988,		0x21, 0
	.dw 0xb440, 0xc988,	0xb47f, 0xc988,		0x21, 0
	.dw 0xb4c0, 0xc988,	0xb4ff, 0xc988,		0x21, 0
	.dw 0xb540, 0xc988,	0xb57f, 0xc988,		0x21, 0
	.dw 0xb5c0, 0xc988,	0xb5ff, 0xc988,		0x21, 0
	.dw 0xb640, 0xc988,	0xb67f, 0xc988,		0x21, 0
	.dw 0xb6c0, 0xc988,	0xb6ff, 0xc988,		0x21, 0
	.dw 0xb740, 0xc988,	0xb77f, 0xc988,		0x21, 0
	.dw 0xb7c0, 0xc988,	0xb7ff, 0xc988,		0x21, 0
	.dw 0xb840, 0xc988,	0xb87f, 0xc988,		0x21, 0
	.dw 0xb8c0, 0xc988,	0xb8ff, 0xc988,		0x21, 0
	.dw 0xb940, 0xc988,	0xb97f, 0xc988,		0x21, 0
	.dw 0xb9c0, 0xc988,	0xdfff, 0xc988,		0x21, 0
	.dw 0xe040, 0xc988,	0xe07f, 0xc988,		0x21, 0
	.dw 0xe0c0, 0xc988,	0xe0ff, 0xc988,		0x21, 0
	.dw 0xe140, 0xc988,	0xe17f, 0xc988,		0x21, 0
	.dw 0xe1c0, 0xc988,	0xe1ff, 0xc988,		0x21, 0
	.dw 0xe240, 0xc988,	0xe27f, 0xc988,		0x21, 0
	.dw 0xe2c0, 0xc988,	0xe2ff, 0xc988,		0x21, 0
	.dw 0xe340, 0xc988,	0xe37f, 0xc988,		0x21, 0
	.dw 0xe3c0, 0xc988,	0xe3ff, 0xc988,		0x21, 0
	.dw 0xe440, 0xc988,	0xe47f, 0xc988,		0x21, 0
	.dw 0xe4c0, 0xc988,	0xe4ff, 0xc988,		0x21, 0
	.dw 0xe540, 0xc988,	0xe57f, 0xc988,		0x21, 0
	.dw 0xe5c0, 0xc988,	0xe5ff, 0xc988,		0x21, 0
	.dw 0xe640, 0xc988,	0xe67f, 0xc988,		0x21, 0
	.dw 0xe6c0, 0xc988,	0xe6ff, 0xc988,		0x21, 0
	.dw 0xe740, 0xc988,	0xe77f, 0xc988,		0x21, 0
	.dw 0xe7c0, 0xc988,	0xe7ff, 0xc988,		0x21, 0
	.dw 0xe840, 0xc988,	0xe87f, 0xc988,		0x21, 0
	.dw 0xe8c0, 0xc988,	0xe8ff, 0xc988,		0x21, 0
	.dw 0xe940, 0xc988,	0xe97f, 0xc988,		0x21, 0
	.dw 0xe9c0, 0xc988,	0xe9ff, 0xc988,		0x21, 0
	.dw 0xea40, 0xc988,	0xea7f, 0xc988,		0x21, 0
	.dw 0xeac0, 0xc988,	0xeaff, 0xc988,		0x21, 0
	.dw 0xeb40, 0xc988,	0xeb7f, 0xc988,		0x21, 0
	.dw 0xebc0, 0xc988,	0xebff, 0xc988,		0x21, 0
	.dw 0xec40, 0xc988,	0xec7f, 0xc988,		0x21, 0
	.dw 0xecc0, 0xc988,	0xecff, 0xc988,		0x21, 0
	.dw 0xed40, 0xc988,	0xed7f, 0xc988,		0x21, 0
	.dw 0xedc0, 0xc988,	0xedff, 0xc988,		0x21, 0
	.dw 0xee40, 0xc988,	0xee7f, 0xc988,		0x21, 0
	.dw 0xeec0, 0xc988,	0xeeff, 0xc988,		0x21, 0
	.dw 0xef40, 0xc988,	0xef7f, 0xc988,		0x21, 0
	.dw 0xefc0, 0xc988,	0xefff, 0xc988,		0x21, 0
	.dw 0xf040, 0xc988,	0xf07f, 0xc988,		0x21, 0
	.dw 0xf0c0, 0xc988,	0xf0ff, 0xc988,		0x21, 0
	.dw 0xf140, 0xc988,	0xf17f, 0xc988,		0x21, 0
	.dw 0xf1c0, 0xc988,	0xf1ff, 0xc988,		0x21, 0
	.dw 0xf240, 0xc988,	0xf27f, 0xc988,		0x21, 0
	.dw 0xf2c0, 0xc988,	0xf2ff, 0xc988,		0x21, 0
	.dw 0xf340, 0xc988,	0xf37f, 0xc988,		0x21, 0
	.dw 0xf3c0, 0xc988,	0xf3ff, 0xc988,		0x21, 0
	.dw 0xf440, 0xc988,	0xf47f, 0xc988,		0x21, 0
	.dw 0xf4c0, 0xc988,	0xf4ff, 0xc988,		0x21, 0
	.dw 0xf540, 0xc988,	0xf57f, 0xc988,		0x21, 0
	.dw 0xf5c0, 0xc988,	0xf5ff, 0xc988,		0x21, 0
	.dw 0xf640, 0xc988,	0xf67f, 0xc988,		0x21, 0
	.dw 0xf6c0, 0xc988,	0xf6ff, 0xc988,		0x21, 0
	.dw 0xf740, 0xc988,	0xf77f, 0xc988,		0x21, 0
	.dw 0xf7c0, 0xc988,	0xf7ff, 0xc988,		0x21, 0
	.dw 0xf840, 0xc988,	0xf87f, 0xc988,		0x21, 0
	.dw 0xf8c0, 0xc988,	0xf8ff, 0xc988,		0x21, 0
	.dw 0xf940, 0xc988,	0xf97f, 0xc988,		0x21, 0
	.dw 0xf9c0, 0xc988,	0x1fff, 0xc989,		0x21, 0
	.dw 0x2040, 0xc989,	0x207f, 0xc989,		0x21, 0
	.dw 0x20c0, 0xc989,	0x20ff, 0xc989,		0x21, 0
	.dw 0x2140, 0xc989,	0x217f, 0xc989,		0x21, 0
	.dw 0x21c0, 0xc989,	0x21ff, 0xc989,		0x21, 0
	.dw 0x2240, 0xc989,	0x227f, 0xc989,		0x21, 0
	.dw 0x22c0, 0xc989,	0x22ff, 0xc989,		0x21, 0
	.dw 0x2340, 0xc989,	0x237f, 0xc989,		0x21, 0
	.dw 0x23c0, 0xc989,	0x23ff, 0xc989,		0x21, 0
	.dw 0x2440, 0xc989,	0x247f, 0xc989,		0x21, 0
	.dw 0x24c0, 0xc989,	0x24ff, 0xc989,		0x21, 0
	.dw 0x2540, 0xc989,	0x257f, 0xc989,		0x21, 0
	.dw 0x25c0, 0xc989,	0x25ff, 0xc989,		0x21, 0
	.dw 0x2640, 0xc989,	0x267f, 0xc989,		0x21, 0
	.dw 0x26c0, 0xc989,	0x26ff, 0xc989,		0x21, 0
	.dw 0x2740, 0xc989,	0x277f, 0xc989,		0x21, 0
	.dw 0x27c0, 0xc989,	0x27ff, 0xc989,		0x21, 0
	.dw 0x2840, 0xc989,	0x287f, 0xc989,		0x21, 0
	.dw 0x28c0, 0xc989,	0x28ff, 0xc989,		0x21, 0
	.dw 0x2940, 0xc989,	0x297f, 0xc989,		0x21, 0
	.dw 0x29c0, 0xc989,	0x29ff, 0xc989,		0x21, 0
	.dw 0x2a40, 0xc989,	0x2a7f, 0xc989,		0x21, 0
	.dw 0x2ac0, 0xc989,	0x2aff, 0xc989,		0x21, 0
	.dw 0x2b40, 0xc989,	0x2b7f, 0xc989,		0x21, 0
	.dw 0x2bc0, 0xc989,	0x2bff, 0xc989,		0x21, 0
	.dw 0x2c40, 0xc989,	0x2c7f, 0xc989,		0x21, 0
	.dw 0x2cc0, 0xc989,	0x2cff, 0xc989,		0x21, 0
	.dw 0x2d40, 0xc989,	0x2d7f, 0xc989,		0x21, 0
	.dw 0x2dc0, 0xc989,	0x2dff, 0xc989,		0x21, 0
	.dw 0x2e40, 0xc989,	0x2e7f, 0xc989,		0x21, 0
	.dw 0x2ec0, 0xc989,	0x2eff, 0xc989,		0x21, 0
	.dw 0x2f40, 0xc989,	0x2f7f, 0xc989,		0x21, 0
	.dw 0x2fc0, 0xc989,	0x2fff, 0xc989,		0x21, 0
	.dw 0x3040, 0xc989,	0x307f, 0xc989,		0x21, 0
	.dw 0x30c0, 0xc989,	0x30ff, 0xc989,		0x21, 0
	.dw 0x3140, 0xc989,	0x317f, 0xc989,		0x21, 0
	.dw 0x31c0, 0xc989,	0x31ff, 0xc989,		0x21, 0
	.dw 0x3240, 0xc989,	0x327f, 0xc989,		0x21, 0
	.dw 0x32c0, 0xc989,	0x32ff, 0xc989,		0x21, 0
	.dw 0x3340, 0xc989,	0x337f, 0xc989,		0x21, 0
	.dw 0x33c0, 0xc989,	0x33ff, 0xc989,		0x21, 0
	.dw 0x3440, 0xc989,	0x347f, 0xc989,		0x21, 0
	.dw 0x34c0, 0xc989,	0x34ff, 0xc989,		0x21, 0
	.dw 0x3540, 0xc989,	0x357f, 0xc989,		0x21, 0
	.dw 0x35c0, 0xc989,	0x35ff, 0xc989,		0x21, 0
	.dw 0x3640, 0xc989,	0x367f, 0xc989,		0x21, 0
	.dw 0x36c0, 0xc989,	0x36ff, 0xc989,		0x21, 0
	.dw 0x3740, 0xc989,	0x377f, 0xc989,		0x21, 0
	.dw 0x37c0, 0xc989,	0x37ff, 0xc989,		0x21, 0
	.dw 0x3840, 0xc989,	0x387f, 0xc989,		0x21, 0
	.dw 0x38c0, 0xc989,	0x38ff, 0xc989,		0x21, 0
	.dw 0x3940, 0xc989,	0x397f, 0xc989,		0x21, 0
	.dw 0x39c0, 0xc989,	0x5fff, 0xc989,		0x21, 0
	.dw 0x6040, 0xc989,	0x607f, 0xc989,		0x21, 0
	.dw 0x60c0, 0xc989,	0x60ff, 0xc989,		0x21, 0
	.dw 0x6140, 0xc989,	0x617f, 0xc989,		0x21, 0
	.dw 0x61c0, 0xc989,	0x61ff, 0xc989,		0x21, 0
	.dw 0x6240, 0xc989,	0x627f, 0xc989,		0x21, 0
	.dw 0x62c0, 0xc989,	0x62ff, 0xc989,		0x21, 0
	.dw 0x6340, 0xc989,	0x637f, 0xc989,		0x21, 0
	.dw 0x63c0, 0xc989,	0x63ff, 0xc989,		0x21, 0
	.dw 0x6440, 0xc989,	0x647f, 0xc989,		0x21, 0
	.dw 0x64c0, 0xc989,	0x64ff, 0xc989,		0x21, 0
	.dw 0x6540, 0xc989,	0x657f, 0xc989,		0x21, 0
	.dw 0x65c0, 0xc989,	0x65ff, 0xc989,		0x21, 0
	.dw 0x6640, 0xc989,	0x667f, 0xc989,		0x21, 0
	.dw 0x66c0, 0xc989,	0x66ff, 0xc989,		0x21, 0
	.dw 0x6740, 0xc989,	0x677f, 0xc989,		0x21, 0
	.dw 0x67c0, 0xc989,	0x67ff, 0xc989,		0x21, 0
	.dw 0x6840, 0xc989,	0x687f, 0xc989,		0x21, 0
	.dw 0x68c0, 0xc989,	0x68ff, 0xc989,		0x21, 0
	.dw 0x6940, 0xc989,	0x697f, 0xc989,		0x21, 0
	.dw 0x69c0, 0xc989,	0x69ff, 0xc989,		0x21, 0
	.dw 0x6a40, 0xc989,	0x6a7f, 0xc989,		0x21, 0
	.dw 0x6ac0, 0xc989,	0x6aff, 0xc989,		0x21, 0
	.dw 0x6b40, 0xc989,	0x6b7f, 0xc989,		0x21, 0
	.dw 0x6bc0, 0xc989,	0x6bff, 0xc989,		0x21, 0
	.dw 0x6c40, 0xc989,	0x6c7f, 0xc989,		0x21, 0
	.dw 0x6cc0, 0xc989,	0x6cff, 0xc989,		0x21, 0
	.dw 0x6d40, 0xc989,	0x6d7f, 0xc989,		0x21, 0
	.dw 0x6dc0, 0xc989,	0x6dff, 0xc989,		0x21, 0
	.dw 0x6e40, 0xc989,	0x6e7f, 0xc989,		0x21, 0
	.dw 0x6ec0, 0xc989,	0x6eff, 0xc989,		0x21, 0
	.dw 0x6f40, 0xc989,	0x6f7f, 0xc989,		0x21, 0
	.dw 0x6fc0, 0xc989,	0x6fff, 0xc989,		0x21, 0
	.dw 0x7040, 0xc989,	0x707f, 0xc989,		0x21, 0
	.dw 0x70c0, 0xc989,	0x70ff, 0xc989,		0x21, 0
	.dw 0x7140, 0xc989,	0x717f, 0xc989,		0x21, 0
	.dw 0x71c0, 0xc989,	0x71ff, 0xc989,		0x21, 0
	.dw 0x7240, 0xc989,	0x727f, 0xc989,		0x21, 0
	.dw 0x72c0, 0xc989,	0x72ff, 0xc989,		0x21, 0
	.dw 0x7340, 0xc989,	0x737f, 0xc989,		0x21, 0
	.dw 0x73c0, 0xc989,	0x73ff, 0xc989,		0x21, 0
	.dw 0x7440, 0xc989,	0x747f, 0xc989,		0x21, 0
	.dw 0x74c0, 0xc989,	0x74ff, 0xc989,		0x21, 0
	.dw 0x7540, 0xc989,	0x757f, 0xc989,		0x21, 0
	.dw 0x75c0, 0xc989,	0x75ff, 0xc989,		0x21, 0
	.dw 0x7640, 0xc989,	0x767f, 0xc989,		0x21, 0
	.dw 0x76c0, 0xc989,	0x76ff, 0xc989,		0x21, 0
	.dw 0x7740, 0xc989,	0x777f, 0xc989,		0x21, 0
	.dw 0x77c0, 0xc989,	0x77ff, 0xc989,		0x21, 0
	.dw 0x7840, 0xc989,	0x787f, 0xc989,		0x21, 0
	.dw 0x78c0, 0xc989,	0x78ff, 0xc989,		0x21, 0
	.dw 0x7940, 0xc989,	0x797f, 0xc989,		0x21, 0
	.dw 0x79c0, 0xc989,	0x9fff, 0xc989,		0x21, 0
	.dw 0xa040, 0xc989,	0xa07f, 0xc989,		0x21, 0
	.dw 0xa0c0, 0xc989,	0xa0ff, 0xc989,		0x21, 0
	.dw 0xa140, 0xc989,	0xa17f, 0xc989,		0x21, 0
	.dw 0xa1c0, 0xc989,	0xa1ff, 0xc989,		0x21, 0
	.dw 0xa240, 0xc989,	0xa27f, 0xc989,		0x21, 0
	.dw 0xa2c0, 0xc989,	0xa2ff, 0xc989,		0x21, 0
	.dw 0xa340, 0xc989,	0xa37f, 0xc989,		0x21, 0
	.dw 0xa3c0, 0xc989,	0xa3ff, 0xc989,		0x21, 0
	.dw 0xa440, 0xc989,	0xa47f, 0xc989,		0x21, 0
	.dw 0xa4c0, 0xc989,	0xa4ff, 0xc989,		0x21, 0
	.dw 0xa540, 0xc989,	0xa57f, 0xc989,		0x21, 0
	.dw 0xa5c0, 0xc989,	0xa5ff, 0xc989,		0x21, 0
	.dw 0xa640, 0xc989,	0xa67f, 0xc989,		0x21, 0
	.dw 0xa6c0, 0xc989,	0xa6ff, 0xc989,		0x21, 0
	.dw 0xa740, 0xc989,	0xa77f, 0xc989,		0x21, 0
	.dw 0xa7c0, 0xc989,	0xa7ff, 0xc989,		0x21, 0
	.dw 0xa840, 0xc989,	0xa87f, 0xc989,		0x21, 0
	.dw 0xa8c0, 0xc989,	0xa8ff, 0xc989,		0x21, 0
	.dw 0xa940, 0xc989,	0xa97f, 0xc989,		0x21, 0
	.dw 0xa9c0, 0xc989,	0xa9ff, 0xc989,		0x21, 0
	.dw 0xaa40, 0xc989,	0xaa7f, 0xc989,		0x21, 0
	.dw 0xaac0, 0xc989,	0xaaff, 0xc989,		0x21, 0
	.dw 0xab40, 0xc989,	0xab7f, 0xc989,		0x21, 0
	.dw 0xabc0, 0xc989,	0xabff, 0xc989,		0x21, 0
	.dw 0xac40, 0xc989,	0xac7f, 0xc989,		0x21, 0
	.dw 0xacc0, 0xc989,	0xacff, 0xc989,		0x21, 0
	.dw 0xad40, 0xc989,	0xad7f, 0xc989,		0x21, 0
	.dw 0xadc0, 0xc989,	0xadff, 0xc989,		0x21, 0
	.dw 0xae40, 0xc989,	0xae7f, 0xc989,		0x21, 0
	.dw 0xaec0, 0xc989,	0xaeff, 0xc989,		0x21, 0
	.dw 0xaf40, 0xc989,	0xaf7f, 0xc989,		0x21, 0
	.dw 0xafc0, 0xc989,	0xafff, 0xc989,		0x21, 0
	.dw 0xb040, 0xc989,	0xb07f, 0xc989,		0x21, 0
	.dw 0xb0c0, 0xc989,	0xb0ff, 0xc989,		0x21, 0
	.dw 0xb140, 0xc989,	0xb17f, 0xc989,		0x21, 0
	.dw 0xb1c0, 0xc989,	0xb1ff, 0xc989,		0x21, 0
	.dw 0xb240, 0xc989,	0xb27f, 0xc989,		0x21, 0
	.dw 0xb2c0, 0xc989,	0xb2ff, 0xc989,		0x21, 0
	.dw 0xb340, 0xc989,	0xb37f, 0xc989,		0x21, 0
	.dw 0xb3c0, 0xc989,	0xb3ff, 0xc989,		0x21, 0
	.dw 0xb440, 0xc989,	0xb47f, 0xc989,		0x21, 0
	.dw 0xb4c0, 0xc989,	0xb4ff, 0xc989,		0x21, 0
	.dw 0xb540, 0xc989,	0xb57f, 0xc989,		0x21, 0
	.dw 0xb5c0, 0xc989,	0xb5ff, 0xc989,		0x21, 0
	.dw 0xb640, 0xc989,	0xb67f, 0xc989,		0x21, 0
	.dw 0xb6c0, 0xc989,	0xb6ff, 0xc989,		0x21, 0
	.dw 0xb740, 0xc989,	0xb77f, 0xc989,		0x21, 0
	.dw 0xb7c0, 0xc989,	0xb7ff, 0xc989,		0x21, 0
	.dw 0xb840, 0xc989,	0xb87f, 0xc989,		0x21, 0
	.dw 0xb8c0, 0xc989,	0xb8ff, 0xc989,		0x21, 0
	.dw 0xb940, 0xc989,	0xb97f, 0xc989,		0x21, 0
	.dw 0xb9c0, 0xc989,	0xdfff, 0xc989,		0x21, 0
	.dw 0xe040, 0xc989,	0xe07f, 0xc989,		0x21, 0
	.dw 0xe0c0, 0xc989,	0xe0ff, 0xc989,		0x21, 0
	.dw 0xe140, 0xc989,	0xe17f, 0xc989,		0x21, 0
	.dw 0xe1c0, 0xc989,	0xe1ff, 0xc989,		0x21, 0
	.dw 0xe240, 0xc989,	0xe27f, 0xc989,		0x21, 0
	.dw 0xe2c0, 0xc989,	0xe2ff, 0xc989,		0x21, 0
	.dw 0xe340, 0xc989,	0xe37f, 0xc989,		0x21, 0
	.dw 0xe3c0, 0xc989,	0xe3ff, 0xc989,		0x21, 0
	.dw 0xe440, 0xc989,	0xe47f, 0xc989,		0x21, 0
	.dw 0xe4c0, 0xc989,	0xe4ff, 0xc989,		0x21, 0
	.dw 0xe540, 0xc989,	0xe57f, 0xc989,		0x21, 0
	.dw 0xe5c0, 0xc989,	0xe5ff, 0xc989,		0x21, 0
	.dw 0xe640, 0xc989,	0xe67f, 0xc989,		0x21, 0
	.dw 0xe6c0, 0xc989,	0xe6ff, 0xc989,		0x21, 0
	.dw 0xe740, 0xc989,	0xe77f, 0xc989,		0x21, 0
	.dw 0xe7c0, 0xc989,	0xe7ff, 0xc989,		0x21, 0
	.dw 0xe840, 0xc989,	0xe87f, 0xc989,		0x21, 0
	.dw 0xe8c0, 0xc989,	0xe8ff, 0xc989,		0x21, 0
	.dw 0xe940, 0xc989,	0xe97f, 0xc989,		0x21, 0
	.dw 0xe9c0, 0xc989,	0xe9ff, 0xc989,		0x21, 0
	.dw 0xea40, 0xc989,	0xea7f, 0xc989,		0x21, 0
	.dw 0xeac0, 0xc989,	0xeaff, 0xc989,		0x21, 0
	.dw 0xeb40, 0xc989,	0xeb7f, 0xc989,		0x21, 0
	.dw 0xebc0, 0xc989,	0xebff, 0xc989,		0x21, 0
	.dw 0xec40, 0xc989,	0xec7f, 0xc989,		0x21, 0
	.dw 0xecc0, 0xc989,	0xecff, 0xc989,		0x21, 0
	.dw 0xed40, 0xc989,	0xed7f, 0xc989,		0x21, 0
	.dw 0xedc0, 0xc989,	0xedff, 0xc989,		0x21, 0
	.dw 0xee40, 0xc989,	0xee7f, 0xc989,		0x21, 0
	.dw 0xeec0, 0xc989,	0xeeff, 0xc989,		0x21, 0
	.dw 0xef40, 0xc989,	0xef7f, 0xc989,		0x21, 0
	.dw 0xefc0, 0xc989,	0xefff, 0xc989,		0x21, 0
	.dw 0xf040, 0xc989,	0xf07f, 0xc989,		0x21, 0
	.dw 0xf0c0, 0xc989,	0xf0ff, 0xc989,		0x21, 0
	.dw 0xf140, 0xc989,	0xf17f, 0xc989,		0x21, 0
	.dw 0xf1c0, 0xc989,	0xf1ff, 0xc989,		0x21, 0
	.dw 0xf240, 0xc989,	0xf27f, 0xc989,		0x21, 0
	.dw 0xf2c0, 0xc989,	0xf2ff, 0xc989,		0x21, 0
	.dw 0xf340, 0xc989,	0xf37f, 0xc989,		0x21, 0
	.dw 0xf3c0, 0xc989,	0xf3ff, 0xc989,		0x21, 0
	.dw 0xf440, 0xc989,	0xf47f, 0xc989,		0x21, 0
	.dw 0xf4c0, 0xc989,	0xf4ff, 0xc989,		0x21, 0
	.dw 0xf540, 0xc989,	0xf57f, 0xc989,		0x21, 0
	.dw 0xf5c0, 0xc989,	0xf5ff, 0xc989,		0x21, 0
	.dw 0xf640, 0xc989,	0xf67f, 0xc989,		0x21, 0
	.dw 0xf6c0, 0xc989,	0xf6ff, 0xc989,		0x21, 0
	.dw 0xf740, 0xc989,	0xf77f, 0xc989,		0x21, 0
	.dw 0xf7c0, 0xc989,	0xf7ff, 0xc989,		0x21, 0
	.dw 0xf840, 0xc989,	0xf87f, 0xc989,		0x21, 0
	.dw 0xf8c0, 0xc989,	0xf8ff, 0xc989,		0x21, 0
	.dw 0xf940, 0xc989,	0xf97f, 0xc989,		0x21, 0
	.dw 0xf9c0, 0xc989,	0x1fff, 0xc98a,		0x21, 0
	.dw 0x2040, 0xc98a,	0x207f, 0xc98a,		0x21, 0
	.dw 0x20c0, 0xc98a,	0x20ff, 0xc98a,		0x21, 0
	.dw 0x2140, 0xc98a,	0x217f, 0xc98a,		0x21, 0
	.dw 0x21c0, 0xc98a,	0x21ff, 0xc98a,		0x21, 0
	.dw 0x2240, 0xc98a,	0x227f, 0xc98a,		0x21, 0
	.dw 0x22c0, 0xc98a,	0x22ff, 0xc98a,		0x21, 0
	.dw 0x2340, 0xc98a,	0x237f, 0xc98a,		0x21, 0
	.dw 0x23c0, 0xc98a,	0x23ff, 0xc98a,		0x21, 0
	.dw 0x2440, 0xc98a,	0x247f, 0xc98a,		0x21, 0
	.dw 0x24c0, 0xc98a,	0x24ff, 0xc98a,		0x21, 0
	.dw 0x2540, 0xc98a,	0x257f, 0xc98a,		0x21, 0
	.dw 0x25c0, 0xc98a,	0x25ff, 0xc98a,		0x21, 0
	.dw 0x2640, 0xc98a,	0x267f, 0xc98a,		0x21, 0
	.dw 0x26c0, 0xc98a,	0x26ff, 0xc98a,		0x21, 0
	.dw 0x2740, 0xc98a,	0x277f, 0xc98a,		0x21, 0
	.dw 0x27c0, 0xc98a,	0x27ff, 0xc98a,		0x21, 0
	.dw 0x2840, 0xc98a,	0x287f, 0xc98a,		0x21, 0
	.dw 0x28c0, 0xc98a,	0x28ff, 0xc98a,		0x21, 0
	.dw 0x2940, 0xc98a,	0x297f, 0xc98a,		0x21, 0
	.dw 0x29c0, 0xc98a,	0x29ff, 0xc98a,		0x21, 0
	.dw 0x2a40, 0xc98a,	0x2a7f, 0xc98a,		0x21, 0
	.dw 0x2ac0, 0xc98a,	0x2aff, 0xc98a,		0x21, 0
	.dw 0x2b40, 0xc98a,	0x2b7f, 0xc98a,		0x21, 0
	.dw 0x2bc0, 0xc98a,	0x2bff, 0xc98a,		0x21, 0
	.dw 0x2c40, 0xc98a,	0x2c7f, 0xc98a,		0x21, 0
	.dw 0x2cc0, 0xc98a,	0x2cff, 0xc98a,		0x21, 0
	.dw 0x2d40, 0xc98a,	0x2d7f, 0xc98a,		0x21, 0
	.dw 0x2dc0, 0xc98a,	0x2dff, 0xc98a,		0x21, 0
	.dw 0x2e40, 0xc98a,	0x2e7f, 0xc98a,		0x21, 0
	.dw 0x2ec0, 0xc98a,	0x2eff, 0xc98a,		0x21, 0
	.dw 0x2f40, 0xc98a,	0x2f7f, 0xc98a,		0x21, 0
	.dw 0x2fc0, 0xc98a,	0x2fff, 0xc98a,		0x21, 0
	.dw 0x3040, 0xc98a,	0x307f, 0xc98a,		0x21, 0
	.dw 0x30c0, 0xc98a,	0x30ff, 0xc98a,		0x21, 0
	.dw 0x3140, 0xc98a,	0x317f, 0xc98a,		0x21, 0
	.dw 0x31c0, 0xc98a,	0x31ff, 0xc98a,		0x21, 0
	.dw 0x3240, 0xc98a,	0x327f, 0xc98a,		0x21, 0
	.dw 0x32c0, 0xc98a,	0x32ff, 0xc98a,		0x21, 0
	.dw 0x3340, 0xc98a,	0x337f, 0xc98a,		0x21, 0
	.dw 0x33c0, 0xc98a,	0x33ff, 0xc98a,		0x21, 0
	.dw 0x3440, 0xc98a,	0x347f, 0xc98a,		0x21, 0
	.dw 0x34c0, 0xc98a,	0x34ff, 0xc98a,		0x21, 0
	.dw 0x3540, 0xc98a,	0x357f, 0xc98a,		0x21, 0
	.dw 0x35c0, 0xc98a,	0x35ff, 0xc98a,		0x21, 0
	.dw 0x3640, 0xc98a,	0x367f, 0xc98a,		0x21, 0
	.dw 0x36c0, 0xc98a,	0x36ff, 0xc98a,		0x21, 0
	.dw 0x3740, 0xc98a,	0x377f, 0xc98a,		0x21, 0
	.dw 0x37c0, 0xc98a,	0x37ff, 0xc98a,		0x21, 0
	.dw 0x3840, 0xc98a,	0x387f, 0xc98a,		0x21, 0
	.dw 0x38c0, 0xc98a,	0x38ff, 0xc98a,		0x21, 0
	.dw 0x3940, 0xc98a,	0x397f, 0xc98a,		0x21, 0
	.dw 0x39c0, 0xc98a,	0x5fff, 0xc98a,		0x21, 0
	.dw 0x6040, 0xc98a,	0x607f, 0xc98a,		0x21, 0
	.dw 0x60c0, 0xc98a,	0x60ff, 0xc98a,		0x21, 0
	.dw 0x6140, 0xc98a,	0x617f, 0xc98a,		0x21, 0
	.dw 0x61c0, 0xc98a,	0x61ff, 0xc98a,		0x21, 0
	.dw 0x6240, 0xc98a,	0x627f, 0xc98a,		0x21, 0
	.dw 0x62c0, 0xc98a,	0x62ff, 0xc98a,		0x21, 0
	.dw 0x6340, 0xc98a,	0x637f, 0xc98a,		0x21, 0
	.dw 0x63c0, 0xc98a,	0x63ff, 0xc98a,		0x21, 0
	.dw 0x6440, 0xc98a,	0x647f, 0xc98a,		0x21, 0
	.dw 0x64c0, 0xc98a,	0x64ff, 0xc98a,		0x21, 0
	.dw 0x6540, 0xc98a,	0x657f, 0xc98a,		0x21, 0
	.dw 0x65c0, 0xc98a,	0x65ff, 0xc98a,		0x21, 0
	.dw 0x6640, 0xc98a,	0x667f, 0xc98a,		0x21, 0
	.dw 0x66c0, 0xc98a,	0x66ff, 0xc98a,		0x21, 0
	.dw 0x6740, 0xc98a,	0x677f, 0xc98a,		0x21, 0
	.dw 0x67c0, 0xc98a,	0x67ff, 0xc98a,		0x21, 0
	.dw 0x6840, 0xc98a,	0x687f, 0xc98a,		0x21, 0
	.dw 0x68c0, 0xc98a,	0x68ff, 0xc98a,		0x21, 0
	.dw 0x6940, 0xc98a,	0x697f, 0xc98a,		0x21, 0
	.dw 0x69c0, 0xc98a,	0x69ff, 0xc98a,		0x21, 0
	.dw 0x6a40, 0xc98a,	0x6a7f, 0xc98a,		0x21, 0
	.dw 0x6ac0, 0xc98a,	0x6aff, 0xc98a,		0x21, 0
	.dw 0x6b40, 0xc98a,	0x6b7f, 0xc98a,		0x21, 0
	.dw 0x6bc0, 0xc98a,	0x6bff, 0xc98a,		0x21, 0
	.dw 0x6c40, 0xc98a,	0x6c7f, 0xc98a,		0x21, 0
	.dw 0x6cc0, 0xc98a,	0x6cff, 0xc98a,		0x21, 0
	.dw 0x6d40, 0xc98a,	0x6d7f, 0xc98a,		0x21, 0
	.dw 0x6dc0, 0xc98a,	0x6dff, 0xc98a,		0x21, 0
	.dw 0x6e40, 0xc98a,	0x6e7f, 0xc98a,		0x21, 0
	.dw 0x6ec0, 0xc98a,	0x6eff, 0xc98a,		0x21, 0
	.dw 0x6f40, 0xc98a,	0x6f7f, 0xc98a,		0x21, 0
	.dw 0x6fc0, 0xc98a,	0x6fff, 0xc98a,		0x21, 0
	.dw 0x7040, 0xc98a,	0x707f, 0xc98a,		0x21, 0
	.dw 0x70c0, 0xc98a,	0x70ff, 0xc98a,		0x21, 0
	.dw 0x7140, 0xc98a,	0x717f, 0xc98a,		0x21, 0
	.dw 0x71c0, 0xc98a,	0x71ff, 0xc98a,		0x21, 0
	.dw 0x7240, 0xc98a,	0x727f, 0xc98a,		0x21, 0
	.dw 0x72c0, 0xc98a,	0x72ff, 0xc98a,		0x21, 0
	.dw 0x7340, 0xc98a,	0x737f, 0xc98a,		0x21, 0
	.dw 0x73c0, 0xc98a,	0x73ff, 0xc98a,		0x21, 0
	.dw 0x7440, 0xc98a,	0x747f, 0xc98a,		0x21, 0
	.dw 0x74c0, 0xc98a,	0x74ff, 0xc98a,		0x21, 0
	.dw 0x7540, 0xc98a,	0x757f, 0xc98a,		0x21, 0
	.dw 0x75c0, 0xc98a,	0x75ff, 0xc98a,		0x21, 0
	.dw 0x7640, 0xc98a,	0x767f, 0xc98a,		0x21, 0
	.dw 0x76c0, 0xc98a,	0x76ff, 0xc98a,		0x21, 0
	.dw 0x7740, 0xc98a,	0x777f, 0xc98a,		0x21, 0
	.dw 0x77c0, 0xc98a,	0x77ff, 0xc98a,		0x21, 0
	.dw 0x7840, 0xc98a,	0x787f, 0xc98a,		0x21, 0
	.dw 0x78c0, 0xc98a,	0x78ff, 0xc98a,		0x21, 0
	.dw 0x7940, 0xc98a,	0x797f, 0xc98a,		0x21, 0
	.dw 0x79c0, 0xc98a,	0x9fff, 0xc98a,		0x21, 0
	.dw 0xa040, 0xc98a,	0xa07f, 0xc98a,		0x21, 0
	.dw 0xa0c0, 0xc98a,	0xa0ff, 0xc98a,		0x21, 0
	.dw 0xa140, 0xc98a,	0xa17f, 0xc98a,		0x21, 0
	.dw 0xa1c0, 0xc98a,	0xa1ff, 0xc98a,		0x21, 0
	.dw 0xa240, 0xc98a,	0xa27f, 0xc98a,		0x21, 0
	.dw 0xa2c0, 0xc98a,	0xa2ff, 0xc98a,		0x21, 0
	.dw 0xa340, 0xc98a,	0xa37f, 0xc98a,		0x21, 0
	.dw 0xa3c0, 0xc98a,	0xa3ff, 0xc98a,		0x21, 0
	.dw 0xa440, 0xc98a,	0xa47f, 0xc98a,		0x21, 0
	.dw 0xa4c0, 0xc98a,	0xa4ff, 0xc98a,		0x21, 0
	.dw 0xa540, 0xc98a,	0xa57f, 0xc98a,		0x21, 0
	.dw 0xa5c0, 0xc98a,	0xa5ff, 0xc98a,		0x21, 0
	.dw 0xa640, 0xc98a,	0xa67f, 0xc98a,		0x21, 0
	.dw 0xa6c0, 0xc98a,	0xa6ff, 0xc98a,		0x21, 0
	.dw 0xa740, 0xc98a,	0xa77f, 0xc98a,		0x21, 0
	.dw 0xa7c0, 0xc98a,	0xa7ff, 0xc98a,		0x21, 0
	.dw 0xa840, 0xc98a,	0xa87f, 0xc98a,		0x21, 0
	.dw 0xa8c0, 0xc98a,	0xa8ff, 0xc98a,		0x21, 0
	.dw 0xa940, 0xc98a,	0xa97f, 0xc98a,		0x21, 0
	.dw 0xa9c0, 0xc98a,	0xa9ff, 0xc98a,		0x21, 0
	.dw 0xaa40, 0xc98a,	0xaa7f, 0xc98a,		0x21, 0
	.dw 0xaac0, 0xc98a,	0xaaff, 0xc98a,		0x21, 0
	.dw 0xab40, 0xc98a,	0xab7f, 0xc98a,		0x21, 0
	.dw 0xabc0, 0xc98a,	0xabff, 0xc98a,		0x21, 0
	.dw 0xac40, 0xc98a,	0xac7f, 0xc98a,		0x21, 0
	.dw 0xacc0, 0xc98a,	0xacff, 0xc98a,		0x21, 0
	.dw 0xad40, 0xc98a,	0xad7f, 0xc98a,		0x21, 0
	.dw 0xadc0, 0xc98a,	0xadff, 0xc98a,		0x21, 0
	.dw 0xae40, 0xc98a,	0xae7f, 0xc98a,		0x21, 0
	.dw 0xaec0, 0xc98a,	0xaeff, 0xc98a,		0x21, 0
	.dw 0xaf40, 0xc98a,	0xaf7f, 0xc98a,		0x21, 0
	.dw 0xafc0, 0xc98a,	0xafff, 0xc98a,		0x21, 0
	.dw 0xb040, 0xc98a,	0xb07f, 0xc98a,		0x21, 0
	.dw 0xb0c0, 0xc98a,	0xb0ff, 0xc98a,		0x21, 0
	.dw 0xb140, 0xc98a,	0xb17f, 0xc98a,		0x21, 0
	.dw 0xb1c0, 0xc98a,	0xb1ff, 0xc98a,		0x21, 0
	.dw 0xb240, 0xc98a,	0xb27f, 0xc98a,		0x21, 0
	.dw 0xb2c0, 0xc98a,	0xb2ff, 0xc98a,		0x21, 0
	.dw 0xb340, 0xc98a,	0xb37f, 0xc98a,		0x21, 0
	.dw 0xb3c0, 0xc98a,	0xb3ff, 0xc98a,		0x21, 0
	.dw 0xb440, 0xc98a,	0xb47f, 0xc98a,		0x21, 0
	.dw 0xb4c0, 0xc98a,	0xb4ff, 0xc98a,		0x21, 0
	.dw 0xb540, 0xc98a,	0xb57f, 0xc98a,		0x21, 0
	.dw 0xb5c0, 0xc98a,	0xb5ff, 0xc98a,		0x21, 0
	.dw 0xb640, 0xc98a,	0xb67f, 0xc98a,		0x21, 0
	.dw 0xb6c0, 0xc98a,	0xb6ff, 0xc98a,		0x21, 0
	.dw 0xb740, 0xc98a,	0xb77f, 0xc98a,		0x21, 0
	.dw 0xb7c0, 0xc98a,	0xb7ff, 0xc98a,		0x21, 0
	.dw 0xb840, 0xc98a,	0xb87f, 0xc98a,		0x21, 0
	.dw 0xb8c0, 0xc98a,	0xb8ff, 0xc98a,		0x21, 0
	.dw 0xb940, 0xc98a,	0xb97f, 0xc98a,		0x21, 0
	.dw 0xb9c0, 0xc98a,	0xdfff, 0xc98a,		0x21, 0
	.dw 0xe040, 0xc98a,	0xe07f, 0xc98a,		0x21, 0
	.dw 0xe0c0, 0xc98a,	0xe0ff, 0xc98a,		0x21, 0
	.dw 0xe140, 0xc98a,	0xe17f, 0xc98a,		0x21, 0
	.dw 0xe1c0, 0xc98a,	0xe1ff, 0xc98a,		0x21, 0
	.dw 0xe240, 0xc98a,	0xe27f, 0xc98a,		0x21, 0
	.dw 0xe2c0, 0xc98a,	0xe2ff, 0xc98a,		0x21, 0
	.dw 0xe340, 0xc98a,	0xe37f, 0xc98a,		0x21, 0
	.dw 0xe3c0, 0xc98a,	0xe3ff, 0xc98a,		0x21, 0
	.dw 0xe440, 0xc98a,	0xe47f, 0xc98a,		0x21, 0
	.dw 0xe4c0, 0xc98a,	0xe4ff, 0xc98a,		0x21, 0
	.dw 0xe540, 0xc98a,	0xe57f, 0xc98a,		0x21, 0
	.dw 0xe5c0, 0xc98a,	0xe5ff, 0xc98a,		0x21, 0
	.dw 0xe640, 0xc98a,	0xe67f, 0xc98a,		0x21, 0
	.dw 0xe6c0, 0xc98a,	0xe6ff, 0xc98a,		0x21, 0
	.dw 0xe740, 0xc98a,	0xe77f, 0xc98a,		0x21, 0
	.dw 0xe7c0, 0xc98a,	0xe7ff, 0xc98a,		0x21, 0
	.dw 0xe840, 0xc98a,	0xe87f, 0xc98a,		0x21, 0
	.dw 0xe8c0, 0xc98a,	0xe8ff, 0xc98a,		0x21, 0
	.dw 0xe940, 0xc98a,	0xe97f, 0xc98a,		0x21, 0
	.dw 0xe9c0, 0xc98a,	0xe9ff, 0xc98a,		0x21, 0
	.dw 0xea40, 0xc98a,	0xea7f, 0xc98a,		0x21, 0
	.dw 0xeac0, 0xc98a,	0xeaff, 0xc98a,		0x21, 0
	.dw 0xeb40, 0xc98a,	0xeb7f, 0xc98a,		0x21, 0
	.dw 0xebc0, 0xc98a,	0xebff, 0xc98a,		0x21, 0
	.dw 0xec40, 0xc98a,	0xec7f, 0xc98a,		0x21, 0
	.dw 0xecc0, 0xc98a,	0xecff, 0xc98a,		0x21, 0
	.dw 0xed40, 0xc98a,	0xed7f, 0xc98a,		0x21, 0
	.dw 0xedc0, 0xc98a,	0xedff, 0xc98a,		0x21, 0
	.dw 0xee40, 0xc98a,	0xee7f, 0xc98a,		0x21, 0
	.dw 0xeec0, 0xc98a,	0xeeff, 0xc98a,		0x21, 0
	.dw 0xef40, 0xc98a,	0xef7f, 0xc98a,		0x21, 0
	.dw 0xefc0, 0xc98a,	0xefff, 0xc98a,		0x21, 0
	.dw 0xf040, 0xc98a,	0xf07f, 0xc98a,		0x21, 0
	.dw 0xf0c0, 0xc98a,	0xf0ff, 0xc98a,		0x21, 0
	.dw 0xf140, 0xc98a,	0xf17f, 0xc98a,		0x21, 0
	.dw 0xf1c0, 0xc98a,	0xf1ff, 0xc98a,		0x21, 0
	.dw 0xf240, 0xc98a,	0xf27f, 0xc98a,		0x21, 0
	.dw 0xf2c0, 0xc98a,	0xf2ff, 0xc98a,		0x21, 0
	.dw 0xf340, 0xc98a,	0xf37f, 0xc98a,		0x21, 0
	.dw 0xf3c0, 0xc98a,	0xf3ff, 0xc98a,		0x21, 0
	.dw 0xf440, 0xc98a,	0xf47f, 0xc98a,		0x21, 0
	.dw 0xf4c0, 0xc98a,	0xf4ff, 0xc98a,		0x21, 0
	.dw 0xf540, 0xc98a,	0xf57f, 0xc98a,		0x21, 0
	.dw 0xf5c0, 0xc98a,	0xf5ff, 0xc98a,		0x21, 0
	.dw 0xf640, 0xc98a,	0xf67f, 0xc98a,		0x21, 0
	.dw 0xf6c0, 0xc98a,	0xf6ff, 0xc98a,		0x21, 0
	.dw 0xf740, 0xc98a,	0xf77f, 0xc98a,		0x21, 0
	.dw 0xf7c0, 0xc98a,	0xf7ff, 0xc98a,		0x21, 0
	.dw 0xf840, 0xc98a,	0xf87f, 0xc98a,		0x21, 0
	.dw 0xf8c0, 0xc98a,	0xf8ff, 0xc98a,		0x21, 0
	.dw 0xf940, 0xc98a,	0xf97f, 0xc98a,		0x21, 0
	.dw 0xf9c0, 0xc98a,	0x1fff, 0xc98b,		0x21, 0
	.dw 0x2040, 0xc98b,	0x207f, 0xc98b,		0x21, 0
	.dw 0x20c0, 0xc98b,	0x20ff, 0xc98b,		0x21, 0
	.dw 0x2140, 0xc98b,	0x217f, 0xc98b,		0x21, 0
	.dw 0x21c0, 0xc98b,	0x21ff, 0xc98b,		0x21, 0
	.dw 0x2240, 0xc98b,	0x227f, 0xc98b,		0x21, 0
	.dw 0x22c0, 0xc98b,	0x22ff, 0xc98b,		0x21, 0
	.dw 0x2340, 0xc98b,	0x237f, 0xc98b,		0x21, 0
	.dw 0x23c0, 0xc98b,	0x23ff, 0xc98b,		0x21, 0
	.dw 0x2440, 0xc98b,	0x247f, 0xc98b,		0x21, 0
	.dw 0x24c0, 0xc98b,	0x24ff, 0xc98b,		0x21, 0
	.dw 0x2540, 0xc98b,	0x257f, 0xc98b,		0x21, 0
	.dw 0x25c0, 0xc98b,	0x25ff, 0xc98b,		0x21, 0
	.dw 0x2640, 0xc98b,	0x267f, 0xc98b,		0x21, 0
	.dw 0x26c0, 0xc98b,	0x26ff, 0xc98b,		0x21, 0
	.dw 0x2740, 0xc98b,	0x277f, 0xc98b,		0x21, 0
	.dw 0x27c0, 0xc98b,	0x27ff, 0xc98b,		0x21, 0
	.dw 0x2840, 0xc98b,	0x287f, 0xc98b,		0x21, 0
	.dw 0x28c0, 0xc98b,	0x28ff, 0xc98b,		0x21, 0
	.dw 0x2940, 0xc98b,	0x297f, 0xc98b,		0x21, 0
	.dw 0x29c0, 0xc98b,	0x29ff, 0xc98b,		0x21, 0
	.dw 0x2a40, 0xc98b,	0x2a7f, 0xc98b,		0x21, 0
	.dw 0x2ac0, 0xc98b,	0x2aff, 0xc98b,		0x21, 0
	.dw 0x2b40, 0xc98b,	0x2b7f, 0xc98b,		0x21, 0
	.dw 0x2bc0, 0xc98b,	0x2bff, 0xc98b,		0x21, 0
	.dw 0x2c40, 0xc98b,	0x2c7f, 0xc98b,		0x21, 0
	.dw 0x2cc0, 0xc98b,	0x2cff, 0xc98b,		0x21, 0
	.dw 0x2d40, 0xc98b,	0x2d7f, 0xc98b,		0x21, 0
	.dw 0x2dc0, 0xc98b,	0x2dff, 0xc98b,		0x21, 0
	.dw 0x2e40, 0xc98b,	0x2e7f, 0xc98b,		0x21, 0
	.dw 0x2ec0, 0xc98b,	0x2eff, 0xc98b,		0x21, 0
	.dw 0x2f40, 0xc98b,	0x2f7f, 0xc98b,		0x21, 0
	.dw 0x2fc0, 0xc98b,	0x2fff, 0xc98b,		0x21, 0
	.dw 0x3040, 0xc98b,	0x307f, 0xc98b,		0x21, 0
	.dw 0x30c0, 0xc98b,	0x30ff, 0xc98b,		0x21, 0
	.dw 0x3140, 0xc98b,	0x317f, 0xc98b,		0x21, 0
	.dw 0x31c0, 0xc98b,	0x31ff, 0xc98b,		0x21, 0
	.dw 0x3240, 0xc98b,	0x327f, 0xc98b,		0x21, 0
	.dw 0x32c0, 0xc98b,	0x32ff, 0xc98b,		0x21, 0
	.dw 0x3340, 0xc98b,	0x337f, 0xc98b,		0x21, 0
	.dw 0x33c0, 0xc98b,	0x33ff, 0xc98b,		0x21, 0
	.dw 0x3440, 0xc98b,	0x347f, 0xc98b,		0x21, 0
	.dw 0x34c0, 0xc98b,	0x34ff, 0xc98b,		0x21, 0
	.dw 0x3540, 0xc98b,	0x357f, 0xc98b,		0x21, 0
	.dw 0x35c0, 0xc98b,	0x35ff, 0xc98b,		0x21, 0
	.dw 0x3640, 0xc98b,	0x367f, 0xc98b,		0x21, 0
	.dw 0x36c0, 0xc98b,	0x36ff, 0xc98b,		0x21, 0
	.dw 0x3740, 0xc98b,	0x377f, 0xc98b,		0x21, 0
	.dw 0x37c0, 0xc98b,	0x37ff, 0xc98b,		0x21, 0
	.dw 0x3840, 0xc98b,	0x387f, 0xc98b,		0x21, 0
	.dw 0x38c0, 0xc98b,	0x38ff, 0xc98b,		0x21, 0
	.dw 0x3940, 0xc98b,	0x397f, 0xc98b,		0x21, 0
	.dw 0x39c0, 0xc98b,	0xffff, 0xc98b,		0x21, 0
	.dw 0x0040, 0xc98c,	0x007f, 0xc98c,		0x21, 0
	.dw 0x00c0, 0xc98c,	0x00ff, 0xc98c,		0x21, 0
	.dw 0x0140, 0xc98c,	0x017f, 0xc98c,		0x21, 0
	.dw 0x01c0, 0xc98c,	0x01ff, 0xc98c,		0x21, 0
	.dw 0x0240, 0xc98c,	0x027f, 0xc98c,		0x21, 0
	.dw 0x02c0, 0xc98c,	0x02ff, 0xc98c,		0x21, 0
	.dw 0x0340, 0xc98c,	0x037f, 0xc98c,		0x21, 0
	.dw 0x03c0, 0xc98c,	0x03ff, 0xc98c,		0x21, 0
	.dw 0x0440, 0xc98c,	0x047f, 0xc98c,		0x21, 0
	.dw 0x04c0, 0xc98c,	0x04ff, 0xc98c,		0x21, 0
	.dw 0x0540, 0xc98c,	0x057f, 0xc98c,		0x21, 0
	.dw 0x05c0, 0xc98c,	0x05ff, 0xc98c,		0x21, 0
	.dw 0x0640, 0xc98c,	0x067f, 0xc98c,		0x21, 0
	.dw 0x06c0, 0xc98c,	0x06ff, 0xc98c,		0x21, 0
	.dw 0x0740, 0xc98c,	0x077f, 0xc98c,		0x21, 0
	.dw 0x07c0, 0xc98c,	0x07ff, 0xc98c,		0x21, 0
	.dw 0x0840, 0xc98c,	0x087f, 0xc98c,		0x21, 0
	.dw 0x08c0, 0xc98c,	0x08ff, 0xc98c,		0x21, 0
	.dw 0x0940, 0xc98c,	0x097f, 0xc98c,		0x21, 0
	.dw 0x09c0, 0xc98c,	0x09ff, 0xc98c,		0x21, 0
	.dw 0x0a40, 0xc98c,	0x0a7f, 0xc98c,		0x21, 0
	.dw 0x0ac0, 0xc98c,	0x0aff, 0xc98c,		0x21, 0
	.dw 0x0b40, 0xc98c,	0x0b7f, 0xc98c,		0x21, 0
	.dw 0x0bc0, 0xc98c,	0x0bff, 0xc98c,		0x21, 0
	.dw 0x0c40, 0xc98c,	0x0c7f, 0xc98c,		0x21, 0
	.dw 0x0cc0, 0xc98c,	0x0cff, 0xc98c,		0x21, 0
	.dw 0x0d40, 0xc98c,	0x0d7f, 0xc98c,		0x21, 0
	.dw 0x0dc0, 0xc98c,	0x0dff, 0xc98c,		0x21, 0
	.dw 0x0e40, 0xc98c,	0x0e7f, 0xc98c,		0x21, 0
	.dw 0x0ec0, 0xc98c,	0x0eff, 0xc98c,		0x21, 0
	.dw 0x0f40, 0xc98c,	0x0f7f, 0xc98c,		0x21, 0
	.dw 0x0fc0, 0xc98c,	0x0fff, 0xc98c,		0x21, 0
	.dw 0x1040, 0xc98c,	0x107f, 0xc98c,		0x21, 0
	.dw 0x10c0, 0xc98c,	0x10ff, 0xc98c,		0x21, 0
	.dw 0x1140, 0xc98c,	0x117f, 0xc98c,		0x21, 0
	.dw 0x11c0, 0xc98c,	0x11ff, 0xc98c,		0x21, 0
	.dw 0x1240, 0xc98c,	0x127f, 0xc98c,		0x21, 0
	.dw 0x12c0, 0xc98c,	0x12ff, 0xc98c,		0x21, 0
	.dw 0x1340, 0xc98c,	0x137f, 0xc98c,		0x21, 0
	.dw 0x13c0, 0xc98c,	0x13ff, 0xc98c,		0x21, 0
	.dw 0x1440, 0xc98c,	0x147f, 0xc98c,		0x21, 0
	.dw 0x14c0, 0xc98c,	0x14ff, 0xc98c,		0x21, 0
	.dw 0x1540, 0xc98c,	0x157f, 0xc98c,		0x21, 0
	.dw 0x15c0, 0xc98c,	0x15ff, 0xc98c,		0x21, 0
	.dw 0x1640, 0xc98c,	0x167f, 0xc98c,		0x21, 0
	.dw 0x16c0, 0xc98c,	0x16ff, 0xc98c,		0x21, 0
	.dw 0x1740, 0xc98c,	0x177f, 0xc98c,		0x21, 0
	.dw 0x17c0, 0xc98c,	0x17ff, 0xc98c,		0x21, 0
	.dw 0x1840, 0xc98c,	0x187f, 0xc98c,		0x21, 0
	.dw 0x18c0, 0xc98c,	0x18ff, 0xc98c,		0x21, 0
	.dw 0x1940, 0xc98c,	0x197f, 0xc98c,		0x21, 0
	.dw 0x19c0, 0xc98c,	0x1fff, 0xc98c,		0x21, 0
	.dw 0x2040, 0xc98c,	0x207f, 0xc98c,		0x21, 0
	.dw 0x20c0, 0xc98c,	0x20ff, 0xc98c,		0x21, 0
	.dw 0x2140, 0xc98c,	0x217f, 0xc98c,		0x21, 0
	.dw 0x21c0, 0xc98c,	0x21ff, 0xc98c,		0x21, 0
	.dw 0x2240, 0xc98c,	0x227f, 0xc98c,		0x21, 0
	.dw 0x22c0, 0xc98c,	0x22ff, 0xc98c,		0x21, 0
	.dw 0x2340, 0xc98c,	0x237f, 0xc98c,		0x21, 0
	.dw 0x23c0, 0xc98c,	0x23ff, 0xc98c,		0x21, 0
	.dw 0x2440, 0xc98c,	0x247f, 0xc98c,		0x21, 0
	.dw 0x24c0, 0xc98c,	0x24ff, 0xc98c,		0x21, 0
	.dw 0x2540, 0xc98c,	0x257f, 0xc98c,		0x21, 0
	.dw 0x25c0, 0xc98c,	0x25ff, 0xc98c,		0x21, 0
	.dw 0x2640, 0xc98c,	0x267f, 0xc98c,		0x21, 0
	.dw 0x26c0, 0xc98c,	0x26ff, 0xc98c,		0x21, 0
	.dw 0x2740, 0xc98c,	0x277f, 0xc98c,		0x21, 0
	.dw 0x27c0, 0xc98c,	0x27ff, 0xc98c,		0x21, 0
	.dw 0x2840, 0xc98c,	0x287f, 0xc98c,		0x21, 0
	.dw 0x28c0, 0xc98c,	0x28ff, 0xc98c,		0x21, 0
	.dw 0x2940, 0xc98c,	0x297f, 0xc98c,		0x21, 0
	.dw 0x29c0, 0xc98c,	0x29ff, 0xc98c,		0x21, 0
	.dw 0x2a40, 0xc98c,	0x2a7f, 0xc98c,		0x21, 0
	.dw 0x2ac0, 0xc98c,	0x2aff, 0xc98c,		0x21, 0
	.dw 0x2b40, 0xc98c,	0x2b7f, 0xc98c,		0x21, 0
	.dw 0x2bc0, 0xc98c,	0x2bff, 0xc98c,		0x21, 0
	.dw 0x2c40, 0xc98c,	0x2c7f, 0xc98c,		0x21, 0
	.dw 0x2cc0, 0xc98c,	0x2cff, 0xc98c,		0x21, 0
	.dw 0x2d40, 0xc98c,	0x2d7f, 0xc98c,		0x21, 0
	.dw 0x2dc0, 0xc98c,	0x2dff, 0xc98c,		0x21, 0
	.dw 0x2e40, 0xc98c,	0x2e7f, 0xc98c,		0x21, 0
	.dw 0x2ec0, 0xc98c,	0x2eff, 0xc98c,		0x21, 0
	.dw 0x2f40, 0xc98c,	0x2f7f, 0xc98c,		0x21, 0
	.dw 0x2fc0, 0xc98c,	0x2fff, 0xc98c,		0x21, 0
	.dw 0x3040, 0xc98c,	0x307f, 0xc98c,		0x21, 0
	.dw 0x30c0, 0xc98c,	0x30ff, 0xc98c,		0x21, 0
	.dw 0x3140, 0xc98c,	0x317f, 0xc98c,		0x21, 0
	.dw 0x31c0, 0xc98c,	0x31ff, 0xc98c,		0x21, 0
	.dw 0x3240, 0xc98c,	0x327f, 0xc98c,		0x21, 0
	.dw 0x32c0, 0xc98c,	0x32ff, 0xc98c,		0x21, 0
	.dw 0x3340, 0xc98c,	0x337f, 0xc98c,		0x21, 0
	.dw 0x33c0, 0xc98c,	0x33ff, 0xc98c,		0x21, 0
	.dw 0x3440, 0xc98c,	0x347f, 0xc98c,		0x21, 0
	.dw 0x34c0, 0xc98c,	0x34ff, 0xc98c,		0x21, 0
	.dw 0x3540, 0xc98c,	0x357f, 0xc98c,		0x21, 0
	.dw 0x35c0, 0xc98c,	0x35ff, 0xc98c,		0x21, 0
	.dw 0x3640, 0xc98c,	0x367f, 0xc98c,		0x21, 0
	.dw 0x36c0, 0xc98c,	0x36ff, 0xc98c,		0x21, 0
	.dw 0x3740, 0xc98c,	0x377f, 0xc98c,		0x21, 0
	.dw 0x37c0, 0xc98c,	0x37ff, 0xc98c,		0x21, 0
	.dw 0x3840, 0xc98c,	0x387f, 0xc98c,		0x21, 0
	.dw 0x38c0, 0xc98c,	0x38ff, 0xc98c,		0x21, 0
	.dw 0x3940, 0xc98c,	0x397f, 0xc98c,		0x21, 0
	.dw 0x39c0, 0xc98c,	0x3fff, 0xc98c,		0x21, 0
	.dw 0x4040, 0xc98c,	0x407f, 0xc98c,		0x21, 0
	.dw 0x40c0, 0xc98c,	0x40ff, 0xc98c,		0x21, 0
	.dw 0x4140, 0xc98c,	0x417f, 0xc98c,		0x21, 0
	.dw 0x41c0, 0xc98c,	0x41ff, 0xc98c,		0x21, 0
	.dw 0x4240, 0xc98c,	0x427f, 0xc98c,		0x21, 0
	.dw 0x42c0, 0xc98c,	0x42ff, 0xc98c,		0x21, 0
	.dw 0x4340, 0xc98c,	0x437f, 0xc98c,		0x21, 0
	.dw 0x43c0, 0xc98c,	0x43ff, 0xc98c,		0x21, 0
	.dw 0x4440, 0xc98c,	0x447f, 0xc98c,		0x21, 0
	.dw 0x44c0, 0xc98c,	0x44ff, 0xc98c,		0x21, 0
	.dw 0x4540, 0xc98c,	0x457f, 0xc98c,		0x21, 0
	.dw 0x45c0, 0xc98c,	0x45ff, 0xc98c,		0x21, 0
	.dw 0x4640, 0xc98c,	0x467f, 0xc98c,		0x21, 0
	.dw 0x46c0, 0xc98c,	0x46ff, 0xc98c,		0x21, 0
	.dw 0x4740, 0xc98c,	0x477f, 0xc98c,		0x21, 0
	.dw 0x47c0, 0xc98c,	0x47ff, 0xc98c,		0x21, 0
	.dw 0x4840, 0xc98c,	0x487f, 0xc98c,		0x21, 0
	.dw 0x48c0, 0xc98c,	0x48ff, 0xc98c,		0x21, 0
	.dw 0x4940, 0xc98c,	0x497f, 0xc98c,		0x21, 0
	.dw 0x49c0, 0xc98c,	0x49ff, 0xc98c,		0x21, 0
	.dw 0x4a40, 0xc98c,	0x4a7f, 0xc98c,		0x21, 0
	.dw 0x4ac0, 0xc98c,	0x4aff, 0xc98c,		0x21, 0
	.dw 0x4b40, 0xc98c,	0x4b7f, 0xc98c,		0x21, 0
	.dw 0x4bc0, 0xc98c,	0x4bff, 0xc98c,		0x21, 0
	.dw 0x4c40, 0xc98c,	0x4c7f, 0xc98c,		0x21, 0
	.dw 0x4cc0, 0xc98c,	0x4cff, 0xc98c,		0x21, 0
	.dw 0x4d40, 0xc98c,	0x4d7f, 0xc98c,		0x21, 0
	.dw 0x4dc0, 0xc98c,	0x4dff, 0xc98c,		0x21, 0
	.dw 0x4e40, 0xc98c,	0x4e7f, 0xc98c,		0x21, 0
	.dw 0x4ec0, 0xc98c,	0x4eff, 0xc98c,		0x21, 0
	.dw 0x4f40, 0xc98c,	0x4f7f, 0xc98c,		0x21, 0
	.dw 0x4fc0, 0xc98c,	0x4fff, 0xc98c,		0x21, 0
	.dw 0x5040, 0xc98c,	0x507f, 0xc98c,		0x21, 0
	.dw 0x50c0, 0xc98c,	0x50ff, 0xc98c,		0x21, 0
	.dw 0x5140, 0xc98c,	0x517f, 0xc98c,		0x21, 0
	.dw 0x51c0, 0xc98c,	0x51ff, 0xc98c,		0x21, 0
	.dw 0x5240, 0xc98c,	0x527f, 0xc98c,		0x21, 0
	.dw 0x52c0, 0xc98c,	0x52ff, 0xc98c,		0x21, 0
	.dw 0x5340, 0xc98c,	0x537f, 0xc98c,		0x21, 0
	.dw 0x53c0, 0xc98c,	0x53ff, 0xc98c,		0x21, 0
	.dw 0x5440, 0xc98c,	0x547f, 0xc98c,		0x21, 0
	.dw 0x54c0, 0xc98c,	0x54ff, 0xc98c,		0x21, 0
	.dw 0x5540, 0xc98c,	0x557f, 0xc98c,		0x21, 0
	.dw 0x55c0, 0xc98c,	0x55ff, 0xc98c,		0x21, 0
	.dw 0x5640, 0xc98c,	0x567f, 0xc98c,		0x21, 0
	.dw 0x56c0, 0xc98c,	0x56ff, 0xc98c,		0x21, 0
	.dw 0x5740, 0xc98c,	0x577f, 0xc98c,		0x21, 0
	.dw 0x57c0, 0xc98c,	0x57ff, 0xc98c,		0x21, 0
	.dw 0x5840, 0xc98c,	0x587f, 0xc98c,		0x21, 0
	.dw 0x58c0, 0xc98c,	0x58ff, 0xc98c,		0x21, 0
	.dw 0x5940, 0xc98c,	0x597f, 0xc98c,		0x21, 0
	.dw 0x59c0, 0xc98c,	0x5fff, 0xc98c,		0x21, 0
	.dw 0x6040, 0xc98c,	0x607f, 0xc98c,		0x21, 0
	.dw 0x60c0, 0xc98c,	0x60ff, 0xc98c,		0x21, 0
	.dw 0x6140, 0xc98c,	0x617f, 0xc98c,		0x21, 0
	.dw 0x61c0, 0xc98c,	0x61ff, 0xc98c,		0x21, 0
	.dw 0x6240, 0xc98c,	0x627f, 0xc98c,		0x21, 0
	.dw 0x62c0, 0xc98c,	0x62ff, 0xc98c,		0x21, 0
	.dw 0x6340, 0xc98c,	0x637f, 0xc98c,		0x21, 0
	.dw 0x63c0, 0xc98c,	0x63ff, 0xc98c,		0x21, 0
	.dw 0x6440, 0xc98c,	0x647f, 0xc98c,		0x21, 0
	.dw 0x64c0, 0xc98c,	0x64ff, 0xc98c,		0x21, 0
	.dw 0x6540, 0xc98c,	0x657f, 0xc98c,		0x21, 0
	.dw 0x65c0, 0xc98c,	0x65ff, 0xc98c,		0x21, 0
	.dw 0x6640, 0xc98c,	0x667f, 0xc98c,		0x21, 0
	.dw 0x66c0, 0xc98c,	0x66ff, 0xc98c,		0x21, 0
	.dw 0x6740, 0xc98c,	0x677f, 0xc98c,		0x21, 0
	.dw 0x67c0, 0xc98c,	0x67ff, 0xc98c,		0x21, 0
	.dw 0x6840, 0xc98c,	0x687f, 0xc98c,		0x21, 0
	.dw 0x68c0, 0xc98c,	0x68ff, 0xc98c,		0x21, 0
	.dw 0x6940, 0xc98c,	0x697f, 0xc98c,		0x21, 0
	.dw 0x69c0, 0xc98c,	0x69ff, 0xc98c,		0x21, 0
	.dw 0x6a40, 0xc98c,	0x6a7f, 0xc98c,		0x21, 0
	.dw 0x6ac0, 0xc98c,	0x6aff, 0xc98c,		0x21, 0
	.dw 0x6b40, 0xc98c,	0x6b7f, 0xc98c,		0x21, 0
	.dw 0x6bc0, 0xc98c,	0x6bff, 0xc98c,		0x21, 0
	.dw 0x6c40, 0xc98c,	0x6c7f, 0xc98c,		0x21, 0
	.dw 0x6cc0, 0xc98c,	0x6cff, 0xc98c,		0x21, 0
	.dw 0x6d40, 0xc98c,	0x6d7f, 0xc98c,		0x21, 0
	.dw 0x6dc0, 0xc98c,	0x6dff, 0xc98c,		0x21, 0
	.dw 0x6e40, 0xc98c,	0x6e7f, 0xc98c,		0x21, 0
	.dw 0x6ec0, 0xc98c,	0x6eff, 0xc98c,		0x21, 0
	.dw 0x6f40, 0xc98c,	0x6f7f, 0xc98c,		0x21, 0
	.dw 0x6fc0, 0xc98c,	0x6fff, 0xc98c,		0x21, 0
	.dw 0x7040, 0xc98c,	0x707f, 0xc98c,		0x21, 0
	.dw 0x70c0, 0xc98c,	0x70ff, 0xc98c,		0x21, 0
	.dw 0x7140, 0xc98c,	0x717f, 0xc98c,		0x21, 0
	.dw 0x71c0, 0xc98c,	0x71ff, 0xc98c,		0x21, 0
	.dw 0x7240, 0xc98c,	0x727f, 0xc98c,		0x21, 0
	.dw 0x72c0, 0xc98c,	0x72ff, 0xc98c,		0x21, 0
	.dw 0x7340, 0xc98c,	0x737f, 0xc98c,		0x21, 0
	.dw 0x73c0, 0xc98c,	0x73ff, 0xc98c,		0x21, 0
	.dw 0x7440, 0xc98c,	0x747f, 0xc98c,		0x21, 0
	.dw 0x74c0, 0xc98c,	0x74ff, 0xc98c,		0x21, 0
	.dw 0x7540, 0xc98c,	0x757f, 0xc98c,		0x21, 0
	.dw 0x75c0, 0xc98c,	0x75ff, 0xc98c,		0x21, 0
	.dw 0x7640, 0xc98c,	0x767f, 0xc98c,		0x21, 0
	.dw 0x76c0, 0xc98c,	0x76ff, 0xc98c,		0x21, 0
	.dw 0x7740, 0xc98c,	0x777f, 0xc98c,		0x21, 0
	.dw 0x77c0, 0xc98c,	0x77ff, 0xc98c,		0x21, 0
	.dw 0x7840, 0xc98c,	0x787f, 0xc98c,		0x21, 0
	.dw 0x78c0, 0xc98c,	0x78ff, 0xc98c,		0x21, 0
	.dw 0x7940, 0xc98c,	0x797f, 0xc98c,		0x21, 0
	.dw 0x79c0, 0xc98c,	0x7fff, 0xc98c,		0x21, 0
	.dw 0x8040, 0xc98c,	0x807f, 0xc98c,		0x21, 0
	.dw 0x80c0, 0xc98c,	0x80ff, 0xc98c,		0x21, 0
	.dw 0x8140, 0xc98c,	0x817f, 0xc98c,		0x21, 0
	.dw 0x81c0, 0xc98c,	0x81ff, 0xc98c,		0x21, 0
	.dw 0x8240, 0xc98c,	0x827f, 0xc98c,		0x21, 0
	.dw 0x82c0, 0xc98c,	0x82ff, 0xc98c,		0x21, 0
	.dw 0x8340, 0xc98c,	0x837f, 0xc98c,		0x21, 0
	.dw 0x83c0, 0xc98c,	0x83ff, 0xc98c,		0x21, 0
	.dw 0x8440, 0xc98c,	0x847f, 0xc98c,		0x21, 0
	.dw 0x84c0, 0xc98c,	0x84ff, 0xc98c,		0x21, 0
	.dw 0x8540, 0xc98c,	0x857f, 0xc98c,		0x21, 0
	.dw 0x85c0, 0xc98c,	0x85ff, 0xc98c,		0x21, 0
	.dw 0x8640, 0xc98c,	0x867f, 0xc98c,		0x21, 0
	.dw 0x86c0, 0xc98c,	0x86ff, 0xc98c,		0x21, 0
	.dw 0x8740, 0xc98c,	0x877f, 0xc98c,		0x21, 0
	.dw 0x87c0, 0xc98c,	0x87ff, 0xc98c,		0x21, 0
	.dw 0x8840, 0xc98c,	0x887f, 0xc98c,		0x21, 0
	.dw 0x88c0, 0xc98c,	0x88ff, 0xc98c,		0x21, 0
	.dw 0x8940, 0xc98c,	0x897f, 0xc98c,		0x21, 0
	.dw 0x89c0, 0xc98c,	0x89ff, 0xc98c,		0x21, 0
	.dw 0x8a40, 0xc98c,	0x8a7f, 0xc98c,		0x21, 0
	.dw 0x8ac0, 0xc98c,	0x8aff, 0xc98c,		0x21, 0
	.dw 0x8b40, 0xc98c,	0x8b7f, 0xc98c,		0x21, 0
	.dw 0x8bc0, 0xc98c,	0x8bff, 0xc98c,		0x21, 0
	.dw 0x8c40, 0xc98c,	0x8c7f, 0xc98c,		0x21, 0
	.dw 0x8cc0, 0xc98c,	0x8cff, 0xc98c,		0x21, 0
	.dw 0x8d40, 0xc98c,	0x8d7f, 0xc98c,		0x21, 0
	.dw 0x8dc0, 0xc98c,	0x8dff, 0xc98c,		0x21, 0
	.dw 0x8e40, 0xc98c,	0x8e7f, 0xc98c,		0x21, 0
	.dw 0x8ec0, 0xc98c,	0x8eff, 0xc98c,		0x21, 0
	.dw 0x8f40, 0xc98c,	0x8f7f, 0xc98c,		0x21, 0
	.dw 0x8fc0, 0xc98c,	0x8fff, 0xc98c,		0x21, 0
	.dw 0x9040, 0xc98c,	0x907f, 0xc98c,		0x21, 0
	.dw 0x90c0, 0xc98c,	0x90ff, 0xc98c,		0x21, 0
	.dw 0x9140, 0xc98c,	0x917f, 0xc98c,		0x21, 0
	.dw 0x91c0, 0xc98c,	0x91ff, 0xc98c,		0x21, 0
	.dw 0x9240, 0xc98c,	0x927f, 0xc98c,		0x21, 0
	.dw 0x92c0, 0xc98c,	0x92ff, 0xc98c,		0x21, 0
	.dw 0x9340, 0xc98c,	0x937f, 0xc98c,		0x21, 0
	.dw 0x93c0, 0xc98c,	0x93ff, 0xc98c,		0x21, 0
	.dw 0x9440, 0xc98c,	0x947f, 0xc98c,		0x21, 0
	.dw 0x94c0, 0xc98c,	0x94ff,