dnl Check for libusb
dnl Copyright (C) 2004, 2005 Free Software Foundation, Inc.
dnl
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl Defines HAVE_LIBUSB to 1 if a working libusb setup is found, and sets
dnl @LIBUSB@ to the necessary libraries.  HAVE_USB_GET_BUSSES is set if
dnl usb_get_busses() exists.

AC_DEFUN([GNUPG_CHECK_LIBUSB],
[
  AC_ARG_WITH(libusb,
     AC_HELP_STRING([--with-libusb=DIR],
	[look for the libusb library in DIR]),
     [_do_libusb=$withval],[_do_libusb=yes])

  if test "$_do_libusb" != "no" ; then
     if test -d "$withval" ; then
        CPPFLAGS="${CPPFLAGS} -I$withval/include"
        LDFLAGS="${LDFLAGS} -L$withval/lib"
        AC_PATH_PROG([_usb_config],["$_do_libusb/bin/libusb-config"])
     else
        AC_PATH_PROG([_usb_config],[libusb-config])
     fi

     _libusb_save_libs=$LIBS
     _libusb_save_cflags=$CFLAGS

     if test x$_usb_config != "x" ; then
        _libusb_try_libs=`$LIBS $_usb_config --libs`
        _libusb_try_cflags=`$LIBS $_usb_config --cflags`
     else
        _libusb_try_libs="-lusb"
        _libusb_try_cflags=""
     fi

     LIBS="$LIBS $_libusb_try_libs"
     CFLAGS="$CFLAGS $_libusb_try_cflags"

     AC_MSG_CHECKING([whether libusb is present and sane])

     AC_LINK_IFELSE(AC_LANG_PROGRAM([#include <usb.h>],[
usb_bulk_write(NULL,0,NULL,0,0);
]),_found_libusb=yes,_found_libusb=no)

     AC_MSG_RESULT([$_found_libusb])

     if test $_found_libusb = yes ; then
        AC_DEFINE(HAVE_LIBUSB,1,
	   [Define to 1 if you have a fully functional libusb library.])
        AC_SUBST(LIBUSB_CPPFLAGS,$_libusb_try_cflags)
        AC_SUBST(LIBUSB,$_libusb_try_libs)
        AC_CHECK_FUNCS(usb_get_busses)
     fi

     LIBS=$_libusb_save_libs
     CFLAGS=$_libusb_save_cflags

     unset _libusb_save_libs
     unset _libusb_save_cflags
     unset _libusb_try_libs
     unset _libusb_try_cflags
     unset _found_libusb
  fi
])dnl
