package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// SitesClient is the use these APIs to manage Azure Websites resources
// through the Azure Resource Manager. All task operations conform to the
// HTTP/1.1 protocol specification and each operation returns an
// x-ms-request-id header that can be used to obtain information about the
// request. You must make sure that requests made to these resources are
// secure. For more information, see <a
// href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
// Azure Resource Manager requests.</a>
type SitesClient struct {
	ManagementClient
}

// NewSitesClient creates an instance of the SitesClient client.
func NewSitesClient(subscriptionID string) SitesClient {
	return NewSitesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSitesClientWithBaseURI creates an instance of the SitesClient client.
func NewSitesClientWithBaseURI(baseURI string, subscriptionID string) SitesClient {
	return SitesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddSitePremierAddOn sends the add site premier add on request.
//
func (client SitesClient) AddSitePremierAddOn(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest) (result SetObject, err error) {
	req, err := client.AddSitePremierAddOnPreparer(resourceGroupName, name, premierAddOnName, premierAddOn)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", nil, "Failure preparing request")
	}

	resp, err := client.AddSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", resp, "Failure sending request")
	}

	result, err = client.AddSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// AddSitePremierAddOnPreparer prepares the AddSitePremierAddOn request.
func (client SitesClient) AddSitePremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddSitePremierAddOnSender sends the AddSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) AddSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AddSitePremierAddOnResponder handles the response to the AddSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) AddSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddSitePremierAddOnSlot sends the add site premier add on slot request.
//
func (client SitesClient) AddSitePremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest, slot string) (result SetObject, err error) {
	req, err := client.AddSitePremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, premierAddOn, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", nil, "Failure preparing request")
	}

	resp, err := client.AddSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", resp, "Failure sending request")
	}

	result, err = client.AddSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// AddSitePremierAddOnSlotPreparer prepares the AddSitePremierAddOnSlot request.
func (client SitesClient) AddSitePremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddSitePremierAddOnSlotSender sends the AddSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) AddSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AddSitePremierAddOnSlotResponder handles the response to the AddSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) AddSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigSlot sends the apply slot config slot request.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name.
// Settings from that slot will be applied on the source slot slot is name of
// the source slot. Settings from the target slot will be applied onto this
// slot
func (client SitesClient) ApplySlotConfigSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SetObject, err error) {
	req, err := client.ApplySlotConfigSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.ApplySlotConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", resp, "Failure sending request")
	}

	result, err = client.ApplySlotConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigSlotPreparer prepares the ApplySlotConfigSlot request.
func (client SitesClient) ApplySlotConfigSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigSlotSender sends the ApplySlotConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ApplySlotConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ApplySlotConfigSlotResponder handles the response to the ApplySlotConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ApplySlotConfigSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigToProduction sends the apply slot config to production
// request.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name.
// Settings from that slot will be applied on the source slot
func (client SitesClient) ApplySlotConfigToProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SetObject, err error) {
	req, err := client.ApplySlotConfigToProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", nil, "Failure preparing request")
	}

	resp, err := client.ApplySlotConfigToProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", resp, "Failure sending request")
	}

	result, err = client.ApplySlotConfigToProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigToProductionPreparer prepares the ApplySlotConfigToProduction request.
func (client SitesClient) ApplySlotConfigToProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigToProductionSender sends the ApplySlotConfigToProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ApplySlotConfigToProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ApplySlotConfigToProductionResponder handles the response to the ApplySlotConfigToProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) ApplySlotConfigToProductionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSite sends the backup site request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on backup request
func (client SitesClient) BackupSite(resourceGroupName string, name string, request BackupRequest) (result BackupItem, err error) {
	req, err := client.BackupSitePreparer(resourceGroupName, name, request)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", nil, "Failure preparing request")
	}

	resp, err := client.BackupSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", resp, "Failure sending request")
	}

	result, err = client.BackupSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", resp, "Failure responding to request")
	}

	return
}

// BackupSitePreparer prepares the BackupSite request.
func (client SitesClient) BackupSitePreparer(resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSiteSender sends the BackupSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) BackupSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// BackupSiteResponder handles the response to the BackupSite request. The method always
// closes the http.Response Body.
func (client SitesClient) BackupSiteResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSiteSlot sends the backup site slot request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on backup request slot is name of web app slot. If not
// specified then will default to production slot.
func (client SitesClient) BackupSiteSlot(resourceGroupName string, name string, request BackupRequest, slot string) (result BackupItem, err error) {
	req, err := client.BackupSiteSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.BackupSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", resp, "Failure sending request")
	}

	result, err = client.BackupSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", resp, "Failure responding to request")
	}

	return
}

// BackupSiteSlotPreparer prepares the BackupSiteSlot request.
func (client SitesClient) BackupSiteSlotPreparer(resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSiteSlotSender sends the BackupSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) BackupSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// BackupSiteSlotResponder handles the response to the BackupSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) BackupSiteSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeployment sends the create deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment deployment is details of deployment
func (client SitesClient) CreateDeployment(resourceGroupName string, name string, id string, deployment Deployment) (result Deployment, err error) {
	req, err := client.CreateDeploymentPreparer(resourceGroupName, name, id, deployment)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", nil, "Failure preparing request")
	}

	resp, err := client.CreateDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", resp, "Failure sending request")
	}

	result, err = client.CreateDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentPreparer prepares the CreateDeployment request.
func (client SitesClient) CreateDeploymentPreparer(resourceGroupName string, name string, id string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSender sends the CreateDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateDeploymentResponder handles the response to the CreateDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeploymentSlot sends the create deployment slot request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot. deployment is details of deployment
func (client SitesClient) CreateDeploymentSlot(resourceGroupName string, name string, id string, slot string, deployment Deployment) (result Deployment, err error) {
	req, err := client.CreateDeploymentSlotPreparer(resourceGroupName, name, id, slot, deployment)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.CreateDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentSlotPreparer prepares the CreateDeploymentSlot request.
func (client SitesClient) CreateDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSlotSender sends the CreateDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateDeploymentSlotResponder handles the response to the CreateDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeployment sends the create instance deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment instanceID is id of web app instance deployment is
// details of deployment
func (client SitesClient) CreateInstanceDeployment(resourceGroupName string, name string, id string, instanceID string, deployment Deployment) (result Deployment, err error) {
	req, err := client.CreateInstanceDeploymentPreparer(resourceGroupName, name, id, instanceID, deployment)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", nil, "Failure preparing request")
	}

	resp, err := client.CreateInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", resp, "Failure sending request")
	}

	result, err = client.CreateInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateInstanceDeploymentPreparer prepares the CreateInstanceDeployment request.
func (client SitesClient) CreateInstanceDeploymentPreparer(resourceGroupName string, name string, id string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateInstanceDeploymentSender sends the CreateInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateInstanceDeploymentResponder handles the response to the CreateInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeploymentSlot sends the create instance deployment slot
// request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot. instanceID is id of web app instance
// deployment is details of deployment
func (client SitesClient) CreateInstanceDeploymentSlot(resourceGroupName string, name string, id string, slot string, instanceID string, deployment Deployment) (result Deployment, err error) {
	req, err := client.CreateInstanceDeploymentSlotPreparer(resourceGroupName, name, id, slot, instanceID, deployment)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.CreateInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateInstanceDeploymentSlotPreparer prepares the CreateInstanceDeploymentSlot request.
func (client SitesClient) CreateInstanceDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateInstanceDeploymentSlotSender sends the CreateInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateInstanceDeploymentSlotResponder handles the response to the CreateInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSite sends the create or update site request. This method may
// poll for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group name is name of the web app
// siteEnvelope is details of web app if it exists already
// skipDNSRegistration is if true web app hostname is not registered with DNS
// on creation. This parameter is
// only used for app creation skipCustomDomainVerification is if
// true, custom (non *.azurewebsites.net) domains associated with web app are
// not verified. forceDNSRegistration is if true, web app hostname is force
// registered with DNS ttlInSeconds is time to live in seconds for web app's
// default domain name
func (client SitesClient) CreateOrUpdateSite(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, ttlInSeconds string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateSitePreparer(resourceGroupName, name, siteEnvelope, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, ttlInSeconds, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSite", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSite", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSite", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSitePreparer prepares the CreateOrUpdateSite request.
func (client SitesClient) CreateOrUpdateSitePreparer(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, ttlInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(skipCustomDomainVerification) > 0 {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", skipCustomDomainVerification)
	}
	if len(forceDNSRegistration) > 0 {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", forceDNSRegistration)
	}
	if len(ttlInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", ttlInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSiteSender sends the CreateOrUpdateSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSiteResponder handles the response to the CreateOrUpdateSite request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateSiteConfig sends the create or update site config request.
//
// resourceGroupName is name of resource group name is name of web app
// siteConfig is request body that contains the configuraiton setting for the
// web app
func (client SitesClient) CreateOrUpdateSiteConfig(resourceGroupName string, name string, siteConfig SiteConfig) (result SiteConfig, err error) {
	req, err := client.CreateOrUpdateSiteConfigPreparer(resourceGroupName, name, siteConfig)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteConfigPreparer prepares the CreateOrUpdateSiteConfig request.
func (client SitesClient) CreateOrUpdateSiteConfigPreparer(resourceGroupName string, name string, siteConfig SiteConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteConfigSender sends the CreateOrUpdateSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteConfigResponder handles the response to the CreateOrUpdateSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteConfigSlot sends the create or update site config slot
// request.
//
// resourceGroupName is name of resource group name is name of web app
// siteConfig is request body that contains the configuraiton setting for the
// web app slot is name of web app slot. If not specified then will default
// to production slot.
func (client SitesClient) CreateOrUpdateSiteConfigSlot(resourceGroupName string, name string, siteConfig SiteConfig, slot string) (result SiteConfig, err error) {
	req, err := client.CreateOrUpdateSiteConfigSlotPreparer(resourceGroupName, name, siteConfig, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteConfigSlotPreparer prepares the CreateOrUpdateSiteConfigSlot request.
func (client SitesClient) CreateOrUpdateSiteConfigSlotPreparer(resourceGroupName string, name string, siteConfig SiteConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteConfigSlotSender sends the CreateOrUpdateSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteConfigSlotResponder handles the response to the CreateOrUpdateSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteHostNameBinding sends the create or update site host name
// binding request.
//
// resourceGroupName is name of resource group name is name of web app
// hostName is name of host hostNameBinding is host name binding information
func (client SitesClient) CreateOrUpdateSiteHostNameBinding(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (result HostNameBinding, err error) {
	req, err := client.CreateOrUpdateSiteHostNameBindingPreparer(resourceGroupName, name, hostName, hostNameBinding)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteHostNameBindingPreparer prepares the CreateOrUpdateSiteHostNameBinding request.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteHostNameBindingSender sends the CreateOrUpdateSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteHostNameBindingResponder handles the response to the CreateOrUpdateSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteHostNameBindingSlot sends the create or update site host
// name binding slot request.
//
// resourceGroupName is name of resource group name is name of web app
// hostName is name of host hostNameBinding is host name binding information
// slot is name of web app slot. If not specified then will default to
// production slot.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlot(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (result HostNameBinding, err error) {
	req, err := client.CreateOrUpdateSiteHostNameBindingSlotPreparer(resourceGroupName, name, hostName, hostNameBinding, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteHostNameBindingSlotPreparer prepares the CreateOrUpdateSiteHostNameBindingSlot request.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteHostNameBindingSlotSender sends the CreateOrUpdateSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteHostNameBindingSlotResponder handles the response to the CreateOrUpdateSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteRelayServiceConnection sends the create or update site
// relay service connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// connectionEnvelope is the details of the Hybrid Connection
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnection(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	req, err := client.CreateOrUpdateSiteRelayServiceConnectionPreparer(resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteRelayServiceConnectionPreparer prepares the CreateOrUpdateSiteRelayServiceConnection request.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteRelayServiceConnectionSender sends the CreateOrUpdateSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteRelayServiceConnectionResponder handles the response to the CreateOrUpdateSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteRelayServiceConnectionSlot sends the create or update
// site relay service connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// connectionEnvelope is the details of the Hybrid Connection slot is the
// name of the slot for the web app.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.CreateOrUpdateSiteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteRelayServiceConnectionSlotPreparer prepares the CreateOrUpdateSiteRelayServiceConnectionSlot request.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteRelayServiceConnectionSlotSender sends the CreateOrUpdateSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteRelayServiceConnectionSlotResponder handles the response to the CreateOrUpdateSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteSlot sends the create or update site slot request. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group name is name of the web app
// siteEnvelope is details of web app if it exists already slot is name of
// web app slot. If not specified then will default to production slot.
// skipDNSRegistration is if true web app hostname is not registered with DNS
// on creation. This parameter is
// only used for app creation skipCustomDomainVerification is if
// true, custom (non *.azurewebsites.net) domains associated with web app are
// not verified. forceDNSRegistration is if true, web app hostname is force
// registered with DNS ttlInSeconds is time to live in seconds for web app's
// default domain name
func (client SitesClient) CreateOrUpdateSiteSlot(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, ttlInSeconds string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateSiteSlotPreparer(resourceGroupName, name, siteEnvelope, slot, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, ttlInSeconds, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteSlotSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteSlotPreparer prepares the CreateOrUpdateSiteSlot request.
func (client SitesClient) CreateOrUpdateSiteSlotPreparer(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, ttlInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(skipCustomDomainVerification) > 0 {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", skipCustomDomainVerification)
	}
	if len(forceDNSRegistration) > 0 {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", forceDNSRegistration)
	}
	if len(ttlInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", ttlInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSiteSlotSender sends the CreateOrUpdateSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSiteSlotResponder handles the response to the CreateOrUpdateSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateSiteSourceControl sends the create or update site source
// control request.
//
// resourceGroupName is name of resource group name is name of web app
// siteSourceControl is request body that contains the source control
// parameters
func (client SitesClient) CreateOrUpdateSiteSourceControl(resourceGroupName string, name string, siteSourceControl SiteSourceControl) (result SiteSourceControl, err error) {
	req, err := client.CreateOrUpdateSiteSourceControlPreparer(resourceGroupName, name, siteSourceControl)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteSourceControlPreparer prepares the CreateOrUpdateSiteSourceControl request.
func (client SitesClient) CreateOrUpdateSiteSourceControlPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteSourceControlSender sends the CreateOrUpdateSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteSourceControlResponder handles the response to the CreateOrUpdateSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteSourceControlSlot sends the create or update site source
// control slot request.
//
// resourceGroupName is name of resource group name is name of web app
// siteSourceControl is request body that contains the source control
// parameters slot is name of web app slot. If not specified then will
// default to production slot.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlot(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (result SiteSourceControl, err error) {
	req, err := client.CreateOrUpdateSiteSourceControlSlotPreparer(resourceGroupName, name, siteSourceControl, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteSourceControlSlotPreparer prepares the CreateOrUpdateSiteSourceControlSlot request.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteSourceControlSlotSender sends the CreateOrUpdateSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteSourceControlSlotResponder handles the response to the CreateOrUpdateSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnection sends the create or update site vnet
// connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network connectionEnvelope is the
// properties of this Virtual Network Connection
func (client SitesClient) CreateOrUpdateSiteVNETConnection(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	req, err := client.CreateOrUpdateSiteVNETConnectionPreparer(resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteVNETConnectionPreparer prepares the CreateOrUpdateSiteVNETConnection request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteVNETConnectionSender sends the CreateOrUpdateSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteVNETConnectionResponder handles the response to the CreateOrUpdateSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionGateway sends the create or update site
// vnet connection gateway request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope is the properties to update this gateway with.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	req, err := client.CreateOrUpdateSiteVNETConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteVNETConnectionGatewayPreparer prepares the CreateOrUpdateSiteVNETConnectionGateway request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteVNETConnectionGatewaySender sends the CreateOrUpdateSiteVNETConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteVNETConnectionGatewayResponder handles the response to the CreateOrUpdateSiteVNETConnectionGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionGatewaySlot sends the create or update site
// vnet connection gateway slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope is the properties to update this gateway with. slot is
// the name of the slot for this web app.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	req, err := client.CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer prepares the CreateOrUpdateSiteVNETConnectionGatewaySlot request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotSender sends the CreateOrUpdateSiteVNETConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotResponder handles the response to the CreateOrUpdateSiteVNETConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionSlot sends the create or update site vnet
// connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network connectionEnvelope is the
// properties of this Virtual Network Connection slot is the name of the slot
// for this web app.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlot(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	req, err := client.CreateOrUpdateSiteVNETConnectionSlotPreparer(resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateSiteVNETConnectionSlotPreparer prepares the CreateOrUpdateSiteVNETConnectionSlot request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateSiteVNETConnectionSlotSender sends the CreateOrUpdateSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateSiteVNETConnectionSlotResponder handles the response to the CreateOrUpdateSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteBackup sends the delete backup request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup
func (client SitesClient) DeleteBackup(resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	req, err := client.DeleteBackupPreparer(resourceGroupName, name, backupID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", nil, "Failure preparing request")
	}

	resp, err := client.DeleteBackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", resp, "Failure sending request")
	}

	result, err = client.DeleteBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupPreparer prepares the DeleteBackup request.
func (client SitesClient) DeleteBackupPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSender sends the DeleteBackup request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteBackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupResponder handles the response to the DeleteBackup request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteBackupResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteBackupSlot sends the delete backup slot request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup slot is name of web app slot. If not specified
// then will default to production slot.
func (client SitesClient) DeleteBackupSlot(resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	req, err := client.DeleteBackupSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteBackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupSlotPreparer prepares the DeleteBackupSlot request.
func (client SitesClient) DeleteBackupSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSlotSender sends the DeleteBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteBackupSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupSlotResponder handles the response to the DeleteBackupSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteBackupSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDeployment sends the delete deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment
func (client SitesClient) DeleteDeployment(resourceGroupName string, name string, id string) (result SetObject, err error) {
	req, err := client.DeleteDeploymentPreparer(resourceGroupName, name, id)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", nil, "Failure preparing request")
	}

	resp, err := client.DeleteDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", resp, "Failure sending request")
	}

	result, err = client.DeleteDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentPreparer prepares the DeleteDeployment request.
func (client SitesClient) DeleteDeploymentPreparer(resourceGroupName string, name string, id string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSender sends the DeleteDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDeploymentResponder handles the response to the DeleteDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteDeploymentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDeploymentSlot sends the delete deployment slot request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot.
func (client SitesClient) DeleteDeploymentSlot(resourceGroupName string, name string, id string, slot string) (result SetObject, err error) {
	req, err := client.DeleteDeploymentSlotPreparer(resourceGroupName, name, id, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentSlotPreparer prepares the DeleteDeploymentSlot request.
func (client SitesClient) DeleteDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSlotSender sends the DeleteDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDeploymentSlotResponder handles the response to the DeleteDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteDeploymentSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteInstanceDeployment sends the delete instance deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment instanceID is id of web app instance
func (client SitesClient) DeleteInstanceDeployment(resourceGroupName string, name string, id string, instanceID string) (result SetObject, err error) {
	req, err := client.DeleteInstanceDeploymentPreparer(resourceGroupName, name, id, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", nil, "Failure preparing request")
	}

	resp, err := client.DeleteInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", resp, "Failure sending request")
	}

	result, err = client.DeleteInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceDeploymentPreparer prepares the DeleteInstanceDeployment request.
func (client SitesClient) DeleteInstanceDeploymentPreparer(resourceGroupName string, name string, id string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceDeploymentSender sends the DeleteInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteInstanceDeploymentResponder handles the response to the DeleteInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteInstanceDeploymentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteInstanceDeploymentSlot sends the delete instance deployment slot
// request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot. instanceID is id of web app instance
func (client SitesClient) DeleteInstanceDeploymentSlot(resourceGroupName string, name string, id string, slot string, instanceID string) (result SetObject, err error) {
	req, err := client.DeleteInstanceDeploymentSlotPreparer(resourceGroupName, name, id, slot, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceDeploymentSlotPreparer prepares the DeleteInstanceDeploymentSlot request.
func (client SitesClient) DeleteInstanceDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceDeploymentSlotSender sends the DeleteInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteInstanceDeploymentSlotResponder handles the response to the DeleteInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteInstanceDeploymentSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSite sends the delete site request.
//
// resourceGroupName is name of resource group name is name of web app
// deleteMetrics is if true, web app metrics are also deleted
// deleteEmptyServerFarm is if true and App Service Plan is empty after web
// app deletion, App Service Plan is also deleted skipDNSRegistration is if
// true, DNS registration is skipped deleteAllSlots is if true, all slots
// associated with web app are also deleted
func (client SitesClient) DeleteSite(resourceGroupName string, name string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result SetObject, err error) {
	req, err := client.DeleteSitePreparer(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration, deleteAllSlots)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", resp, "Failure responding to request")
	}

	return
}

// DeleteSitePreparer prepares the DeleteSite request.
func (client SitesClient) DeleteSitePreparer(resourceGroupName string, name string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(deleteMetrics) > 0 {
		queryParameters["deleteMetrics"] = autorest.Encode("query", deleteMetrics)
	}
	if len(deleteEmptyServerFarm) > 0 {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", deleteEmptyServerFarm)
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(deleteAllSlots) > 0 {
		queryParameters["deleteAllSlots"] = autorest.Encode("query", deleteAllSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteSender sends the DeleteSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteResponder handles the response to the DeleteSite request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteHostNameBinding sends the delete site host name binding request.
//
// resourceGroupName is name of resource group name is name of web app
// hostName is name of host
func (client SitesClient) DeleteSiteHostNameBinding(resourceGroupName string, name string, hostName string) (result SetObject, err error) {
	req, err := client.DeleteSiteHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteHostNameBindingPreparer prepares the DeleteSiteHostNameBinding request.
func (client SitesClient) DeleteSiteHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteHostNameBindingSender sends the DeleteSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteHostNameBindingResponder handles the response to the DeleteSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteHostNameBindingResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteHostNameBindingSlot sends the delete site host name binding slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. hostName is name of host
func (client SitesClient) DeleteSiteHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result SetObject, err error) {
	req, err := client.DeleteSiteHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteHostNameBindingSlotPreparer prepares the DeleteSiteHostNameBindingSlot request.
func (client SitesClient) DeleteSiteHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteHostNameBindingSlotSender sends the DeleteSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteHostNameBindingSlotResponder handles the response to the DeleteSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteHostNameBindingSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSitePremierAddOn sends the delete site premier add on request.
//
func (client SitesClient) DeleteSitePremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result SetObject, err error) {
	req, err := client.DeleteSitePremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", resp, "Failure sending request")
	}

	result, err = client.DeleteSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// DeleteSitePremierAddOnPreparer prepares the DeleteSitePremierAddOn request.
func (client SitesClient) DeleteSitePremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSitePremierAddOnSender sends the DeleteSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSitePremierAddOnResponder handles the response to the DeleteSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSitePremierAddOnSlot sends the delete site premier add on slot
// request.
//
func (client SitesClient) DeleteSitePremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result SetObject, err error) {
	req, err := client.DeleteSitePremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSitePremierAddOnSlotPreparer prepares the DeleteSitePremierAddOnSlot request.
func (client SitesClient) DeleteSitePremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSitePremierAddOnSlotSender sends the DeleteSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSitePremierAddOnSlotResponder handles the response to the DeleteSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteRelayServiceConnection sends the delete site relay service
// connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
func (client SitesClient) DeleteSiteRelayServiceConnection(resourceGroupName string, name string, entityName string) (result SetObject, err error) {
	req, err := client.DeleteSiteRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteRelayServiceConnectionPreparer prepares the DeleteSiteRelayServiceConnection request.
func (client SitesClient) DeleteSiteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteRelayServiceConnectionSender sends the DeleteSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteRelayServiceConnectionResponder handles the response to the DeleteSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteRelayServiceConnectionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteRelayServiceConnectionSlot sends the delete site relay service
// connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// slot is the name of the slot for the web app.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result SetObject, err error) {
	req, err := client.DeleteSiteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteRelayServiceConnectionSlotPreparer prepares the DeleteSiteRelayServiceConnectionSlot request.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteRelayServiceConnectionSlotSender sends the DeleteSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteRelayServiceConnectionSlotResponder handles the response to the DeleteSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSlot sends the delete site slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. deleteMetrics is if true, web app metrics are also deleted
// deleteEmptyServerFarm is if true and App Service Plan is empty after web
// app deletion, App Service Plan is also deleted skipDNSRegistration is if
// true, DNS registration is skipped deleteAllSlots is if true, all slots
// associated with web app are also deleted
func (client SitesClient) DeleteSiteSlot(resourceGroupName string, name string, slot string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result SetObject, err error) {
	req, err := client.DeleteSiteSlotPreparer(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration, deleteAllSlots)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteSlotPreparer prepares the DeleteSiteSlot request.
func (client SitesClient) DeleteSiteSlotPreparer(resourceGroupName string, name string, slot string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(deleteMetrics) > 0 {
		queryParameters["deleteMetrics"] = autorest.Encode("query", deleteMetrics)
	}
	if len(deleteEmptyServerFarm) > 0 {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", deleteEmptyServerFarm)
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(deleteAllSlots) > 0 {
		queryParameters["deleteAllSlots"] = autorest.Encode("query", deleteAllSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteSlotSender sends the DeleteSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteSlotResponder handles the response to the DeleteSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSourceControl sends the delete site source control request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) DeleteSiteSourceControl(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.DeleteSiteSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteSourceControlPreparer prepares the DeleteSiteSourceControl request.
func (client SitesClient) DeleteSiteSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteSourceControlSender sends the DeleteSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteSourceControlResponder handles the response to the DeleteSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSourceControlResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSourceControlSlot sends the delete site source control slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) DeleteSiteSourceControlSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.DeleteSiteSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteSourceControlSlotPreparer prepares the DeleteSiteSourceControlSlot request.
func (client SitesClient) DeleteSiteSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteSourceControlSlotSender sends the DeleteSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteSourceControlSlotResponder handles the response to the DeleteSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSourceControlSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteVNETConnection sends the delete site vnet connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network
func (client SitesClient) DeleteSiteVNETConnection(resourceGroupName string, name string, vnetName string) (result SetObject, err error) {
	req, err := client.DeleteSiteVNETConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteVNETConnectionPreparer prepares the DeleteSiteVNETConnection request.
func (client SitesClient) DeleteSiteVNETConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteVNETConnectionSender sends the DeleteSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteVNETConnectionResponder handles the response to the DeleteSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteVNETConnectionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteVNETConnectionSlot sends the delete site vnet connection slot
// request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network slot is the name of the
// slot for this web app.
func (client SitesClient) DeleteSiteVNETConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result SetObject, err error) {
	req, err := client.DeleteSiteVNETConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.DeleteSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteVNETConnectionSlotPreparer prepares the DeleteSiteVNETConnectionSlot request.
func (client SitesClient) DeleteSiteVNETConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteVNETConnectionSlotSender sends the DeleteSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSiteVNETConnectionSlotResponder handles the response to the DeleteSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteVNETConnectionSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverSiteRestore sends the discover site restore request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on restore request
func (client SitesClient) DiscoverSiteRestore(resourceGroupName string, name string, request RestoreRequest) (result RestoreRequest, err error) {
	req, err := client.DiscoverSiteRestorePreparer(resourceGroupName, name, request)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", nil, "Failure preparing request")
	}

	resp, err := client.DiscoverSiteRestoreSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", resp, "Failure sending request")
	}

	result, err = client.DiscoverSiteRestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", resp, "Failure responding to request")
	}

	return
}

// DiscoverSiteRestorePreparer prepares the DiscoverSiteRestore request.
func (client SitesClient) DiscoverSiteRestorePreparer(resourceGroupName string, name string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverSiteRestoreSender sends the DiscoverSiteRestore request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DiscoverSiteRestoreSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DiscoverSiteRestoreResponder handles the response to the DiscoverSiteRestore request. The method always
// closes the http.Response Body.
func (client SitesClient) DiscoverSiteRestoreResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverSiteRestoreSlot sends the discover site restore slot request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on restore request slot is name of web app slot. If not
// specified then will default to production slot.
func (client SitesClient) DiscoverSiteRestoreSlot(resourceGroupName string, name string, request RestoreRequest, slot string) (result RestoreRequest, err error) {
	req, err := client.DiscoverSiteRestoreSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", nil, "Failure preparing request")
	}

	resp, err := client.DiscoverSiteRestoreSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", resp, "Failure sending request")
	}

	result, err = client.DiscoverSiteRestoreSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", resp, "Failure responding to request")
	}

	return
}

// DiscoverSiteRestoreSlotPreparer prepares the DiscoverSiteRestoreSlot request.
func (client SitesClient) DiscoverSiteRestoreSlotPreparer(resourceGroupName string, name string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverSiteRestoreSlotSender sends the DiscoverSiteRestoreSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DiscoverSiteRestoreSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DiscoverSiteRestoreSlotResponder handles the response to the DiscoverSiteRestoreSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DiscoverSiteRestoreSlotResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPassword sends the generate new site publishing
// password request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GenerateNewSitePublishingPassword(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.GenerateNewSitePublishingPasswordPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", nil, "Failure preparing request")
	}

	resp, err := client.GenerateNewSitePublishingPasswordSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", resp, "Failure sending request")
	}

	result, err = client.GenerateNewSitePublishingPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordPreparer prepares the GenerateNewSitePublishingPassword request.
func (client SitesClient) GenerateNewSitePublishingPasswordPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSender sends the GenerateNewSitePublishingPassword request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GenerateNewSitePublishingPasswordSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GenerateNewSitePublishingPasswordResponder handles the response to the GenerateNewSitePublishingPassword request. The method always
// closes the http.Response Body.
func (client SitesClient) GenerateNewSitePublishingPasswordResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPasswordSlot sends the generate new site
// publishing password slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GenerateNewSitePublishingPasswordSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", nil, "Failure preparing request")
	}

	resp, err := client.GenerateNewSitePublishingPasswordSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure sending request")
	}

	result, err = client.GenerateNewSitePublishingPasswordSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordSlotPreparer prepares the GenerateNewSitePublishingPasswordSlot request.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSlotSender sends the GenerateNewSitePublishingPasswordSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GenerateNewSitePublishingPasswordSlotResponder handles the response to the GenerateNewSitePublishingPasswordSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeletedSites sends the get deleted sites request.
//
// resourceGroupName is name of resource group propertiesToInclude is
// additional web app properties included in the response includeSiteTypes is
// types of apps included in the response
func (client SitesClient) GetDeletedSites(resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (result DeletedSiteCollection, err error) {
	req, err := client.GetDeletedSitesPreparer(resourceGroupName, propertiesToInclude, includeSiteTypes)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", nil, "Failure preparing request")
	}

	resp, err := client.GetDeletedSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", resp, "Failure sending request")
	}

	result, err = client.GetDeletedSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", resp, "Failure responding to request")
	}

	return
}

// GetDeletedSitesPreparer prepares the GetDeletedSites request.
func (client SitesClient) GetDeletedSitesPreparer(resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}
	if len(includeSiteTypes) > 0 {
		queryParameters["includeSiteTypes"] = autorest.Encode("query", includeSiteTypes)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/deletedSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeletedSitesSender sends the GetDeletedSites request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeletedSitesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeletedSitesResponder handles the response to the GetDeletedSites request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeletedSitesResponder(resp *http.Response) (result DeletedSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployment sends the get deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment
func (client SitesClient) GetDeployment(resourceGroupName string, name string, id string) (result Deployment, err error) {
	req, err := client.GetDeploymentPreparer(resourceGroupName, name, id)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", nil, "Failure preparing request")
	}

	resp, err := client.GetDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", resp, "Failure sending request")
	}

	result, err = client.GetDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentPreparer prepares the GetDeployment request.
func (client SitesClient) GetDeploymentPreparer(resourceGroupName string, name string, id string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSender sends the GetDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentResponder handles the response to the GetDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployments sends the get deployments request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetDeployments(resourceGroupName string, name string) (result DeploymentCollection, err error) {
	req, err := client.GetDeploymentsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", nil, "Failure preparing request")
	}

	resp, err := client.GetDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", resp, "Failure sending request")
	}

	result, err = client.GetDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentsPreparer prepares the GetDeployments request.
func (client SitesClient) GetDeploymentsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentsSender sends the GetDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentsResponder handles the response to the GetDeployments request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentSlot sends the get deployment slot request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot.
func (client SitesClient) GetDeploymentSlot(resourceGroupName string, name string, id string, slot string) (result Deployment, err error) {
	req, err := client.GetDeploymentSlotPreparer(resourceGroupName, name, id, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.GetDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentSlotPreparer prepares the GetDeploymentSlot request.
func (client SitesClient) GetDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSlotSender sends the GetDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentSlotResponder handles the response to the GetDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentsSlot sends the get deployments slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetDeploymentsSlot(resourceGroupName string, name string, slot string) (result DeploymentCollection, err error) {
	req, err := client.GetDeploymentsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", resp, "Failure sending request")
	}

	result, err = client.GetDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentsSlotPreparer prepares the GetDeploymentsSlot request.
func (client SitesClient) GetDeploymentsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentsSlotSender sends the GetDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentsSlotResponder handles the response to the GetDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeployment sends the get instance deployment request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment instanceID is id of web app instance
func (client SitesClient) GetInstanceDeployment(resourceGroupName string, name string, id string, instanceID string) (result Deployment, err error) {
	req, err := client.GetInstanceDeploymentPreparer(resourceGroupName, name, id, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", nil, "Failure preparing request")
	}

	resp, err := client.GetInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", resp, "Failure sending request")
	}

	result, err = client.GetInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentPreparer prepares the GetInstanceDeployment request.
func (client SitesClient) GetInstanceDeploymentPreparer(resourceGroupName string, name string, id string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentSender sends the GetInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentResponder handles the response to the GetInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeployments sends the get instance deployments request.
//
// resourceGroupName is name of resource group name is name of web app
// instanceID is id of web app instance
func (client SitesClient) GetInstanceDeployments(resourceGroupName string, name string, instanceID string) (result DeploymentCollection, err error) {
	req, err := client.GetInstanceDeploymentsPreparer(resourceGroupName, name, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", nil, "Failure preparing request")
	}

	resp, err := client.GetInstanceDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", resp, "Failure sending request")
	}

	result, err = client.GetInstanceDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentsPreparer prepares the GetInstanceDeployments request.
func (client SitesClient) GetInstanceDeploymentsPreparer(resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentsSender sends the GetInstanceDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentsResponder handles the response to the GetInstanceDeployments request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeploymentSlot sends the get instance deployment slot request.
//
// resourceGroupName is name of resource group name is name of web app id is
// id of the deployment slot is name of web app slot. If not specified then
// will default to production slot. instanceID is id of web app instance
func (client SitesClient) GetInstanceDeploymentSlot(resourceGroupName string, name string, id string, slot string, instanceID string) (result Deployment, err error) {
	req, err := client.GetInstanceDeploymentSlotPreparer(resourceGroupName, name, id, slot, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", resp, "Failure sending request")
	}

	result, err = client.GetInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentSlotPreparer prepares the GetInstanceDeploymentSlot request.
func (client SitesClient) GetInstanceDeploymentSlotPreparer(resourceGroupName string, name string, id string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", id),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentSlotSender sends the GetInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentSlotResponder handles the response to the GetInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeploymentsSlot sends the get instance deployments slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. instanceID is id of web app instance
func (client SitesClient) GetInstanceDeploymentsSlot(resourceGroupName string, name string, slot string, instanceID string) (result DeploymentCollection, err error) {
	req, err := client.GetInstanceDeploymentsSlotPreparer(resourceGroupName, name, slot, instanceID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetInstanceDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", resp, "Failure sending request")
	}

	result, err = client.GetInstanceDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentsSlotPreparer prepares the GetInstanceDeploymentsSlot request.
func (client SitesClient) GetInstanceDeploymentsSlotPreparer(resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentsSlotSender sends the GetInstanceDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentsSlotResponder handles the response to the GetInstanceDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSite sends the get site request.
//
// resourceGroupName is name of resource group name is name of web app
// propertiesToInclude is additional web app properties included in the
// response
func (client SitesClient) GetSite(resourceGroupName string, name string, propertiesToInclude string) (result Site, err error) {
	req, err := client.GetSitePreparer(resourceGroupName, name, propertiesToInclude)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", resp, "Failure sending request")
	}

	result, err = client.GetSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", resp, "Failure responding to request")
	}

	return
}

// GetSitePreparer prepares the GetSite request.
func (client SitesClient) GetSitePreparer(resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSender sends the GetSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteResponder handles the response to the GetSite request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupConfiguration sends the get site backup configuration request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteBackupConfiguration(resourceGroupName string, name string) (result BackupRequest, err error) {
	req, err := client.GetSiteBackupConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupConfigurationPreparer prepares the GetSiteBackupConfiguration request.
func (client SitesClient) GetSiteBackupConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupConfigurationSender sends the GetSiteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupConfigurationResponder handles the response to the GetSiteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupConfigurationSlot sends the get site backup configuration slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteBackupConfigurationSlot(resourceGroupName string, name string, slot string) (result BackupRequest, err error) {
	req, err := client.GetSiteBackupConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupConfigurationSlotPreparer prepares the GetSiteBackupConfigurationSlot request.
func (client SitesClient) GetSiteBackupConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupConfigurationSlotSender sends the GetSiteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupConfigurationSlotResponder handles the response to the GetSiteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatus sends the get site backup status request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup
func (client SitesClient) GetSiteBackupStatus(resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	req, err := client.GetSiteBackupStatusPreparer(resourceGroupName, name, backupID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupStatusPreparer prepares the GetSiteBackupStatus request.
func (client SitesClient) GetSiteBackupStatusPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupStatusSender sends the GetSiteBackupStatus request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupStatusResponder handles the response to the GetSiteBackupStatus request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSecrets sends the get site backup status secrets request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup request is information on backup request
func (client SitesClient) GetSiteBackupStatusSecrets(resourceGroupName string, name string, backupID string, request BackupRequest) (result BackupItem, err error) {
	req, err := client.GetSiteBackupStatusSecretsPreparer(resourceGroupName, name, backupID, request)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupStatusSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupStatusSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupStatusSecretsPreparer prepares the GetSiteBackupStatusSecrets request.
func (client SitesClient) GetSiteBackupStatusSecretsPreparer(resourceGroupName string, name string, backupID string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupStatusSecretsSender sends the GetSiteBackupStatusSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupStatusSecretsResponder handles the response to the GetSiteBackupStatusSecrets request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSecretsResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSecretsSlot sends the get site backup status secrets
// slot request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup request is information on backup request slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteBackupStatusSecretsSlot(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (result BackupItem, err error) {
	req, err := client.GetSiteBackupStatusSecretsSlotPreparer(resourceGroupName, name, backupID, request, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupStatusSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupStatusSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupStatusSecretsSlotPreparer prepares the GetSiteBackupStatusSecretsSlot request.
func (client SitesClient) GetSiteBackupStatusSecretsSlotPreparer(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupStatusSecretsSlotSender sends the GetSiteBackupStatusSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupStatusSecretsSlotResponder handles the response to the GetSiteBackupStatusSecretsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSecretsSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSlot sends the get site backup status slot request.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup slot is name of web app slot. If not specified
// then will default to production slot.
func (client SitesClient) GetSiteBackupStatusSlot(resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	req, err := client.GetSiteBackupStatusSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteBackupStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteBackupStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteBackupStatusSlotPreparer prepares the GetSiteBackupStatusSlot request.
func (client SitesClient) GetSiteBackupStatusSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteBackupStatusSlotSender sends the GetSiteBackupStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteBackupStatusSlotResponder handles the response to the GetSiteBackupStatusSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteConfig sends the get site config request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteConfig(resourceGroupName string, name string) (result SiteConfig, err error) {
	req, err := client.GetSiteConfigPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", resp, "Failure sending request")
	}

	result, err = client.GetSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", resp, "Failure responding to request")
	}

	return
}

// GetSiteConfigPreparer prepares the GetSiteConfig request.
func (client SitesClient) GetSiteConfigPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteConfigSender sends the GetSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteConfigResponder handles the response to the GetSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteConfigSlot sends the get site config slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteConfigSlot(resourceGroupName string, name string, slot string) (result SiteConfig, err error) {
	req, err := client.GetSiteConfigSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteConfigSlotPreparer prepares the GetSiteConfigSlot request.
func (client SitesClient) GetSiteConfigSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteConfigSlotSender sends the GetSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteConfigSlotResponder handles the response to the GetSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBinding sends the get site host name binding request.
//
// resourceGroupName is name of resource group name is name of web app
// hostName is name of host
func (client SitesClient) GetSiteHostNameBinding(resourceGroupName string, name string, hostName string) (result HostNameBinding, err error) {
	req, err := client.GetSiteHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", resp, "Failure sending request")
	}

	result, err = client.GetSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// GetSiteHostNameBindingPreparer prepares the GetSiteHostNameBinding request.
func (client SitesClient) GetSiteHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteHostNameBindingSender sends the GetSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteHostNameBindingResponder handles the response to the GetSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBindings sends the get site host name bindings request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteHostNameBindings(resourceGroupName string, name string) (result HostNameBindingCollection, err error) {
	req, err := client.GetSiteHostNameBindingsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", resp, "Failure sending request")
	}

	result, err = client.GetSiteHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", resp, "Failure responding to request")
	}

	return
}

// GetSiteHostNameBindingsPreparer prepares the GetSiteHostNameBindings request.
func (client SitesClient) GetSiteHostNameBindingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteHostNameBindingsSender sends the GetSiteHostNameBindings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteHostNameBindingsResponder handles the response to the GetSiteHostNameBindings request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingsResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBindingSlot sends the get site host name binding slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. hostName is name of host
func (client SitesClient) GetSiteHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result HostNameBinding, err error) {
	req, err := client.GetSiteHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteHostNameBindingSlotPreparer prepares the GetSiteHostNameBindingSlot request.
func (client SitesClient) GetSiteHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteHostNameBindingSlotSender sends the GetSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteHostNameBindingSlotResponder handles the response to the GetSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBindingsSlot sends the get site host name bindings slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteHostNameBindingsSlot(resourceGroupName string, name string, slot string) (result HostNameBindingCollection, err error) {
	req, err := client.GetSiteHostNameBindingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteHostNameBindingsSlotPreparer prepares the GetSiteHostNameBindingsSlot request.
func (client SitesClient) GetSiteHostNameBindingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteHostNameBindingsSlotSender sends the GetSiteHostNameBindingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteHostNameBindingsSlotResponder handles the response to the GetSiteHostNameBindingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingsSlotResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteInstanceIdentifiers sends the get site instance identifiers request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteInstanceIdentifiers(resourceGroupName string, name string) (result SiteInstanceCollection, err error) {
	req, err := client.GetSiteInstanceIdentifiersPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", resp, "Failure sending request")
	}

	result, err = client.GetSiteInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", resp, "Failure responding to request")
	}

	return
}

// GetSiteInstanceIdentifiersPreparer prepares the GetSiteInstanceIdentifiers request.
func (client SitesClient) GetSiteInstanceIdentifiersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteInstanceIdentifiersSender sends the GetSiteInstanceIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteInstanceIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteInstanceIdentifiersResponder handles the response to the GetSiteInstanceIdentifiers request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteInstanceIdentifiersResponder(resp *http.Response) (result SiteInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteInstanceIdentifiersSlot sends the get site instance identifiers slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteInstanceIdentifiersSlot(resourceGroupName string, name string, slot string) (result SiteInstanceCollection, err error) {
	req, err := client.GetSiteInstanceIdentifiersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteInstanceIdentifiersSlotPreparer prepares the GetSiteInstanceIdentifiersSlot request.
func (client SitesClient) GetSiteInstanceIdentifiersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteInstanceIdentifiersSlotSender sends the GetSiteInstanceIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteInstanceIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteInstanceIdentifiersSlotResponder handles the response to the GetSiteInstanceIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteInstanceIdentifiersSlotResponder(resp *http.Response) (result SiteInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteLogsConfig sends the get site logs config request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteLogsConfig(resourceGroupName string, name string) (result SiteLogsConfig, err error) {
	req, err := client.GetSiteLogsConfigPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteLogsConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", resp, "Failure sending request")
	}

	result, err = client.GetSiteLogsConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", resp, "Failure responding to request")
	}

	return
}

// GetSiteLogsConfigPreparer prepares the GetSiteLogsConfig request.
func (client SitesClient) GetSiteLogsConfigPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteLogsConfigSender sends the GetSiteLogsConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteLogsConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteLogsConfigResponder handles the response to the GetSiteLogsConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteLogsConfigResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteLogsConfigSlot sends the get site logs config slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteLogsConfigSlot(resourceGroupName string, name string, slot string) (result SiteLogsConfig, err error) {
	req, err := client.GetSiteLogsConfigSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteLogsConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteLogsConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteLogsConfigSlotPreparer prepares the GetSiteLogsConfigSlot request.
func (client SitesClient) GetSiteLogsConfigSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteLogsConfigSlotSender sends the GetSiteLogsConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteLogsConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteLogsConfigSlotResponder handles the response to the GetSiteLogsConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteLogsConfigSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteMetricDefinitions sends the get site metric definitions request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteMetricDefinitions(resourceGroupName string, name string) (result MetricDefinitionCollection, err error) {
	req, err := client.GetSiteMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", resp, "Failure sending request")
	}

	result, err = client.GetSiteMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetSiteMetricDefinitionsPreparer prepares the GetSiteMetricDefinitions request.
func (client SitesClient) GetSiteMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteMetricDefinitionsSender sends the GetSiteMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteMetricDefinitionsResponder handles the response to the GetSiteMetricDefinitions request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteMetricDefinitionsSlot sends the get site metric definitions slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteMetricDefinitionsSlot(resourceGroupName string, name string, slot string) (result MetricDefinitionCollection, err error) {
	req, err := client.GetSiteMetricDefinitionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteMetricDefinitionsSlotPreparer prepares the GetSiteMetricDefinitionsSlot request.
func (client SitesClient) GetSiteMetricDefinitionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteMetricDefinitionsSlotSender sends the GetSiteMetricDefinitionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricDefinitionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteMetricDefinitionsSlotResponder handles the response to the GetSiteMetricDefinitionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricDefinitionsSlotResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteMetrics sends the get site metrics request.
//
// resourceGroupName is name of resource group name is name of web app details
// is if true, metric details are included in response filter is return only
// usages/metrics specified in the filter. Filter conforms to odata syntax.
// Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and
// startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetSiteMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", resp, "Failure sending request")
	}

	result, err = client.GetSiteMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", resp, "Failure responding to request")
	}

	return
}

// GetSiteMetricsPreparer prepares the GetSiteMetrics request.
func (client SitesClient) GetSiteMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteMetricsSender sends the GetSiteMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteMetricsResponder handles the response to the GetSiteMetrics request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteMetricsSlot sends the get site metrics slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. details is if true, metric details are included in response filter
// is return only usages/metrics specified in the filter. Filter conforms to
// odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq
// 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
// '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteMetricsSlot(resourceGroupName string, name string, slot string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetSiteMetricsSlotPreparer(resourceGroupName, name, slot, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteMetricsSlotPreparer prepares the GetSiteMetricsSlot request.
func (client SitesClient) GetSiteMetricsSlotPreparer(resourceGroupName string, name string, slot string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteMetricsSlotSender sends the GetSiteMetricsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteMetricsSlotResponder handles the response to the GetSiteMetricsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricsSlotResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteNetworkFeatures sends the get site network features request.
//
// resourceGroupName is the resource group name name is the name of the web
// app view is the type of view. This can either be "summary" or "detailed".
func (client SitesClient) GetSiteNetworkFeatures(resourceGroupName string, name string, view string) (result NetworkFeatures, err error) {
	req, err := client.GetSiteNetworkFeaturesPreparer(resourceGroupName, name, view)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteNetworkFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", resp, "Failure sending request")
	}

	result, err = client.GetSiteNetworkFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", resp, "Failure responding to request")
	}

	return
}

// GetSiteNetworkFeaturesPreparer prepares the GetSiteNetworkFeatures request.
func (client SitesClient) GetSiteNetworkFeaturesPreparer(resourceGroupName string, name string, view string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteNetworkFeaturesSender sends the GetSiteNetworkFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteNetworkFeaturesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteNetworkFeaturesResponder handles the response to the GetSiteNetworkFeatures request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteNetworkFeaturesResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteNetworkFeaturesSlot sends the get site network features slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app view is the type of view. This can either be "summary" or "detailed".
// slot is the name of the slot for this web app.
func (client SitesClient) GetSiteNetworkFeaturesSlot(resourceGroupName string, name string, view string, slot string) (result NetworkFeatures, err error) {
	req, err := client.GetSiteNetworkFeaturesSlotPreparer(resourceGroupName, name, view, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteNetworkFeaturesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteNetworkFeaturesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteNetworkFeaturesSlotPreparer prepares the GetSiteNetworkFeaturesSlot request.
func (client SitesClient) GetSiteNetworkFeaturesSlotPreparer(resourceGroupName string, name string, view string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteNetworkFeaturesSlotSender sends the GetSiteNetworkFeaturesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteNetworkFeaturesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteNetworkFeaturesSlotResponder handles the response to the GetSiteNetworkFeaturesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteNetworkFeaturesSlotResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteOperation sends the get site operation request.
//
// resourceGroupName is name of resource group name is name of web app
// operationID is id of an operation
func (client SitesClient) GetSiteOperation(resourceGroupName string, name string, operationID string) (result SetObject, err error) {
	req, err := client.GetSiteOperationPreparer(resourceGroupName, name, operationID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", resp, "Failure sending request")
	}

	result, err = client.GetSiteOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", resp, "Failure responding to request")
	}

	return
}

// GetSiteOperationPreparer prepares the GetSiteOperation request.
func (client SitesClient) GetSiteOperationPreparer(resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteOperationSender sends the GetSiteOperation request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteOperationResponder handles the response to the GetSiteOperation request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteOperationResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteOperationSlot sends the get site operation slot request.
//
// resourceGroupName is name of resource group name is name of web app
// operationID is id of an operation slot is name of web app slot. If not
// specified then will default to production slot.
func (client SitesClient) GetSiteOperationSlot(resourceGroupName string, name string, operationID string, slot string) (result SetObject, err error) {
	req, err := client.GetSiteOperationSlotPreparer(resourceGroupName, name, operationID, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteOperationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteOperationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteOperationSlotPreparer prepares the GetSiteOperationSlot request.
func (client SitesClient) GetSiteOperationSlotPreparer(resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteOperationSlotSender sends the GetSiteOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteOperationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteOperationSlotResponder handles the response to the GetSiteOperationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteOperationSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePremierAddOn sends the get site premier add on request.
//
func (client SitesClient) GetSitePremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result SetObject, err error) {
	req, err := client.GetSitePremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", nil, "Failure preparing request")
	}

	resp, err := client.GetSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", resp, "Failure sending request")
	}

	result, err = client.GetSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// GetSitePremierAddOnPreparer prepares the GetSitePremierAddOn request.
func (client SitesClient) GetSitePremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePremierAddOnSender sends the GetSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSitePremierAddOnResponder handles the response to the GetSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePremierAddOnSlot sends the get site premier add on slot request.
//
func (client SitesClient) GetSitePremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result SetObject, err error) {
	req, err := client.GetSitePremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", resp, "Failure sending request")
	}

	result, err = client.GetSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// GetSitePremierAddOnSlotPreparer prepares the GetSitePremierAddOnSlot request.
func (client SitesClient) GetSitePremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePremierAddOnSlotSender sends the GetSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSitePremierAddOnSlotResponder handles the response to the GetSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteRelayServiceConnection sends the get site relay service connection
// request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
func (client SitesClient) GetSiteRelayServiceConnection(resourceGroupName string, name string, entityName string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.GetSiteRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", resp, "Failure sending request")
	}

	result, err = client.GetSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// GetSiteRelayServiceConnectionPreparer prepares the GetSiteRelayServiceConnection request.
func (client SitesClient) GetSiteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteRelayServiceConnectionSender sends the GetSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteRelayServiceConnectionResponder handles the response to the GetSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteRelayServiceConnectionSlot sends the get site relay service
// connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// slot is the name of the slot for the web app.
func (client SitesClient) GetSiteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.GetSiteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteRelayServiceConnectionSlotPreparer prepares the GetSiteRelayServiceConnectionSlot request.
func (client SitesClient) GetSiteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteRelayServiceConnectionSlotSender sends the GetSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteRelayServiceConnectionSlotResponder handles the response to the GetSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSites sends the get sites request.
//
// resourceGroupName is name of resource group propertiesToInclude is
// additional web app properties included in the response includeSiteTypes is
// types of apps included in the response includeSlots is whether or not to
// include deployments slots in results
func (client SitesClient) GetSites(resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (result SiteCollection, err error) {
	req, err := client.GetSitesPreparer(resourceGroupName, propertiesToInclude, includeSiteTypes, includeSlots)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", nil, "Failure preparing request")
	}

	resp, err := client.GetSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", resp, "Failure sending request")
	}

	result, err = client.GetSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", resp, "Failure responding to request")
	}

	return
}

// GetSitesPreparer prepares the GetSites request.
func (client SitesClient) GetSitesPreparer(resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}
	if len(includeSiteTypes) > 0 {
		queryParameters["includeSiteTypes"] = autorest.Encode("query", includeSiteTypes)
	}
	if includeSlots != nil {
		queryParameters["includeSlots"] = autorest.Encode("query", *includeSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitesSender sends the GetSites request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSitesResponder handles the response to the GetSites request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSlot sends the get site slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. propertiesToInclude is additional web app properties included in the
// response
func (client SitesClient) GetSiteSlot(resourceGroupName string, name string, slot string, propertiesToInclude string) (result Site, err error) {
	req, err := client.GetSiteSlotPreparer(resourceGroupName, name, slot, propertiesToInclude)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteSlotPreparer prepares the GetSiteSlot request.
func (client SitesClient) GetSiteSlotPreparer(resourceGroupName string, name string, slot string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSlotSender sends the GetSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSlotResponder handles the response to the GetSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSlots sends the get site slots request.
//
// resourceGroupName is name of resource group name is name of web app
// propertiesToInclude is list of app properties to include in the response
func (client SitesClient) GetSiteSlots(resourceGroupName string, name string, propertiesToInclude string) (result SiteCollection, err error) {
	req, err := client.GetSiteSlotsPreparer(resourceGroupName, name, propertiesToInclude)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", resp, "Failure sending request")
	}

	result, err = client.GetSiteSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", resp, "Failure responding to request")
	}

	return
}

// GetSiteSlotsPreparer prepares the GetSiteSlots request.
func (client SitesClient) GetSiteSlotsPreparer(resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSlotsSender sends the GetSiteSlots request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSlotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSlotsResponder handles the response to the GetSiteSlots request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSlotsResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSnapshots sends the get site snapshots request.
//
// resourceGroupName is webspace name is website Name
func (client SitesClient) GetSiteSnapshots(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.GetSiteSnapshotsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", resp, "Failure sending request")
	}

	result, err = client.GetSiteSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", resp, "Failure responding to request")
	}

	return
}

// GetSiteSnapshotsPreparer prepares the GetSiteSnapshots request.
func (client SitesClient) GetSiteSnapshotsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSnapshotsSender sends the GetSiteSnapshots request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSnapshotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSnapshotsResponder handles the response to the GetSiteSnapshots request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSnapshotsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSnapshotsSlot sends the get site snapshots slot request.
//
// resourceGroupName is webspace name is website Name slot is website Slot
func (client SitesClient) GetSiteSnapshotsSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.GetSiteSnapshotsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteSnapshotsSlotPreparer prepares the GetSiteSnapshotsSlot request.
func (client SitesClient) GetSiteSnapshotsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSnapshotsSlotSender sends the GetSiteSnapshotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSnapshotsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSnapshotsSlotResponder handles the response to the GetSiteSnapshotsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSnapshotsSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSourceControl sends the get site source control request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSiteSourceControl(resourceGroupName string, name string) (result SiteSourceControl, err error) {
	req, err := client.GetSiteSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", resp, "Failure sending request")
	}

	result, err = client.GetSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", resp, "Failure responding to request")
	}

	return
}

// GetSiteSourceControlPreparer prepares the GetSiteSourceControl request.
func (client SitesClient) GetSiteSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSourceControlSender sends the GetSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSourceControlResponder handles the response to the GetSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSourceControlSlot sends the get site source control slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) GetSiteSourceControlSlot(resourceGroupName string, name string, slot string) (result SiteSourceControl, err error) {
	req, err := client.GetSiteSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteSourceControlSlotPreparer prepares the GetSiteSourceControlSlot request.
func (client SitesClient) GetSiteSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteSourceControlSlotSender sends the GetSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteSourceControlSlotResponder handles the response to the GetSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteUsages sends the get site usages request.
//
// resourceGroupName is name of resource group name is name of web app filter
// is return only usages specified in the filter. Filter is specified by
// using OData syntax. Example: $filter=(name.value eq 'Metric1' or
// name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteUsages(resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollection, err error) {
	req, err := client.GetSiteUsagesPreparer(resourceGroupName, name, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", resp, "Failure sending request")
	}

	result, err = client.GetSiteUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", resp, "Failure responding to request")
	}

	return
}

// GetSiteUsagesPreparer prepares the GetSiteUsages request.
func (client SitesClient) GetSiteUsagesPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteUsagesSender sends the GetSiteUsages request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteUsagesResponder handles the response to the GetSiteUsages request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteUsagesSlot sends the get site usages slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. filter is return only usages specified in the filter. Filter is
// specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
// or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteUsagesSlot(resourceGroupName string, name string, slot string, filter string) (result CsmUsageQuotaCollection, err error) {
	req, err := client.GetSiteUsagesSlotPreparer(resourceGroupName, name, slot, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteUsagesSlotPreparer prepares the GetSiteUsagesSlot request.
func (client SitesClient) GetSiteUsagesSlotPreparer(resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteUsagesSlotSender sends the GetSiteUsagesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteUsagesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteUsagesSlotResponder handles the response to the GetSiteUsagesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteUsagesSlotResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnection sends the get site vnet connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network
func (client SitesClient) GetSiteVNETConnection(resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	req, err := client.GetSiteVNETConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", resp, "Failure sending request")
	}

	result, err = client.GetSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", resp, "Failure responding to request")
	}

	return
}

// GetSiteVNETConnectionPreparer prepares the GetSiteVNETConnection request.
func (client SitesClient) GetSiteVNETConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVNETConnectionSender sends the GetSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVNETConnectionResponder handles the response to the GetSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnections sends the get site vnet connections request.
//
// resourceGroupName is the resource group name name is the name of the web
// app
func (client SitesClient) GetSiteVNETConnections(resourceGroupName string, name string) (result ListVnetInfo, err error) {
	req, err := client.GetSiteVNETConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVNETConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", resp, "Failure sending request")
	}

	result, err = client.GetSiteVNETConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", resp, "Failure responding to request")
	}

	return
}

// GetSiteVNETConnectionsPreparer prepares the GetSiteVNETConnections request.
func (client SitesClient) GetSiteVNETConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVNETConnectionsSender sends the GetSiteVNETConnections request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVNETConnectionsResponder handles the response to the GetSiteVNETConnections request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnectionSlot sends the get site vnet connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network slot is the name of the
// slot for this web app.
func (client SitesClient) GetSiteVNETConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result VnetInfo, err error) {
	req, err := client.GetSiteVNETConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteVNETConnectionSlotPreparer prepares the GetSiteVNETConnectionSlot request.
func (client SitesClient) GetSiteVNETConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVNETConnectionSlotSender sends the GetSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVNETConnectionSlotResponder handles the response to the GetSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnectionsSlot sends the get site vnet connections slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app slot is the name of the slot for this web app.
func (client SitesClient) GetSiteVNETConnectionsSlot(resourceGroupName string, name string, slot string) (result ListVnetInfo, err error) {
	req, err := client.GetSiteVNETConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVNETConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteVNETConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteVNETConnectionsSlotPreparer prepares the GetSiteVNETConnectionsSlot request.
func (client SitesClient) GetSiteVNETConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVNETConnectionsSlotSender sends the GetSiteVNETConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVNETConnectionsSlotResponder handles the response to the GetSiteVNETConnectionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionsSlotResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVnetGateway sends the get site vnet gateway request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary"
func (client SitesClient) GetSiteVnetGateway(resourceGroupName string, name string, vnetName string, gatewayName string) (result SetObject, err error) {
	req, err := client.GetSiteVnetGatewayPreparer(resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", resp, "Failure sending request")
	}

	result, err = client.GetSiteVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", resp, "Failure responding to request")
	}

	return
}

// GetSiteVnetGatewayPreparer prepares the GetSiteVnetGateway request.
func (client SitesClient) GetSiteVnetGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVnetGatewaySender sends the GetSiteVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVnetGatewayResponder handles the response to the GetSiteVnetGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVnetGatewayResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVnetGatewaySlot sends the get site vnet gateway slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary" slot is
// the name of the slot for this web app.
func (client SitesClient) GetSiteVnetGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result SetObject, err error) {
	req, err := client.GetSiteVnetGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSiteVnetGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", resp, "Failure sending request")
	}

	result, err = client.GetSiteVnetGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteVnetGatewaySlotPreparer prepares the GetSiteVnetGatewaySlot request.
func (client SitesClient) GetSiteVnetGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteVnetGatewaySlotSender sends the GetSiteVnetGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVnetGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSiteVnetGatewaySlotResponder handles the response to the GetSiteVnetGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVnetGatewaySlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlotConfigNames sends the get slot config names request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) GetSlotConfigNames(resourceGroupName string, name string) (result SlotConfigNamesResource, err error) {
	req, err := client.GetSlotConfigNamesPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", nil, "Failure preparing request")
	}

	resp, err := client.GetSlotConfigNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", resp, "Failure sending request")
	}

	result, err = client.GetSlotConfigNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", resp, "Failure responding to request")
	}

	return
}

// GetSlotConfigNamesPreparer prepares the GetSlotConfigNames request.
func (client SitesClient) GetSlotConfigNamesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSlotConfigNamesSender sends the GetSlotConfigNames request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotConfigNamesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSlotConfigNamesResponder handles the response to the GetSlotConfigNames request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotConfigNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlotsDifferencesFromProduction sends the get slots differences from
// production request.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name
func (client SitesClient) GetSlotsDifferencesFromProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SlotDifferenceCollection, err error) {
	req, err := client.GetSlotsDifferencesFromProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", nil, "Failure preparing request")
	}

	resp, err := client.GetSlotsDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", resp, "Failure sending request")
	}

	result, err = client.GetSlotsDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", resp, "Failure responding to request")
	}

	return
}

// GetSlotsDifferencesFromProductionPreparer prepares the GetSlotsDifferencesFromProduction request.
func (client SitesClient) GetSlotsDifferencesFromProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSlotsDifferencesFromProductionSender sends the GetSlotsDifferencesFromProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotsDifferencesFromProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSlotsDifferencesFromProductionResponder handles the response to the GetSlotsDifferencesFromProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotsDifferencesFromProductionResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlotsDifferencesSlot sends the get slots differences slot request.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name slot is
// name of the source slot
func (client SitesClient) GetSlotsDifferencesSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SlotDifferenceCollection, err error) {
	req, err := client.GetSlotsDifferencesSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", nil, "Failure preparing request")
	}

	resp, err := client.GetSlotsDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", resp, "Failure sending request")
	}

	result, err = client.GetSlotsDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", resp, "Failure responding to request")
	}

	return
}

// GetSlotsDifferencesSlotPreparer prepares the GetSlotsDifferencesSlot request.
func (client SitesClient) GetSlotsDifferencesSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSlotsDifferencesSlotSender sends the GetSlotsDifferencesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotsDifferencesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSlotsDifferencesSlotResponder handles the response to the GetSlotsDifferencesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotsDifferencesSlotResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsSiteCloneable sends the is site cloneable request.
//
// resourceGroupName is name of the resource group name is name of the web app
func (client SitesClient) IsSiteCloneable(resourceGroupName string, name string) (result SiteCloneability, err error) {
	req, err := client.IsSiteCloneablePreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", nil, "Failure preparing request")
	}

	resp, err := client.IsSiteCloneableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", resp, "Failure sending request")
	}

	result, err = client.IsSiteCloneableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", resp, "Failure responding to request")
	}

	return
}

// IsSiteCloneablePreparer prepares the IsSiteCloneable request.
func (client SitesClient) IsSiteCloneablePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsSiteCloneableSender sends the IsSiteCloneable request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) IsSiteCloneableSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// IsSiteCloneableResponder handles the response to the IsSiteCloneable request. The method always
// closes the http.Response Body.
func (client SitesClient) IsSiteCloneableResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsSiteCloneableSlot sends the is site cloneable slot request.
//
// resourceGroupName is name of the resource group name is name of the web app
// slot is name of web app slot. If not specified then will default to
// production slot.
func (client SitesClient) IsSiteCloneableSlot(resourceGroupName string, name string, slot string) (result SiteCloneability, err error) {
	req, err := client.IsSiteCloneableSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", nil, "Failure preparing request")
	}

	resp, err := client.IsSiteCloneableSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", resp, "Failure sending request")
	}

	result, err = client.IsSiteCloneableSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", resp, "Failure responding to request")
	}

	return
}

// IsSiteCloneableSlotPreparer prepares the IsSiteCloneableSlot request.
func (client SitesClient) IsSiteCloneableSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsSiteCloneableSlotSender sends the IsSiteCloneableSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) IsSiteCloneableSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// IsSiteCloneableSlotResponder handles the response to the IsSiteCloneableSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) IsSiteCloneableSlotResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAppSettings sends the list site app settings request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSiteAppSettings(resourceGroupName string, name string) (result StringDictionary, err error) {
	req, err := client.ListSiteAppSettingsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", resp, "Failure sending request")
	}

	result, err = client.ListSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", resp, "Failure responding to request")
	}

	return
}

// ListSiteAppSettingsPreparer prepares the ListSiteAppSettings request.
func (client SitesClient) ListSiteAppSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteAppSettingsSender sends the ListSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteAppSettingsResponder handles the response to the ListSiteAppSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAppSettingsSlot sends the list site app settings slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSiteAppSettingsSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	req, err := client.ListSiteAppSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteAppSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteAppSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteAppSettingsSlotPreparer prepares the ListSiteAppSettingsSlot request.
func (client SitesClient) ListSiteAppSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteAppSettingsSlotSender sends the ListSiteAppSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAppSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteAppSettingsSlotResponder handles the response to the ListSiteAppSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAppSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAuthSettings sends the list site auth settings request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSiteAuthSettings(resourceGroupName string, name string) (result SiteAuthSettings, err error) {
	req, err := client.ListSiteAuthSettingsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", resp, "Failure sending request")
	}

	result, err = client.ListSiteAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", resp, "Failure responding to request")
	}

	return
}

// ListSiteAuthSettingsPreparer prepares the ListSiteAuthSettings request.
func (client SitesClient) ListSiteAuthSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteAuthSettingsSender sends the ListSiteAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteAuthSettingsResponder handles the response to the ListSiteAuthSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAuthSettingsSlot sends the list site auth settings slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSiteAuthSettingsSlot(resourceGroupName string, name string, slot string) (result SiteAuthSettings, err error) {
	req, err := client.ListSiteAuthSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteAuthSettingsSlotPreparer prepares the ListSiteAuthSettingsSlot request.
func (client SitesClient) ListSiteAuthSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteAuthSettingsSlotSender sends the ListSiteAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteAuthSettingsSlotResponder handles the response to the ListSiteAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteBackups sends the list site backups request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSiteBackups(resourceGroupName string, name string) (result BackupItemCollection, err error) {
	req, err := client.ListSiteBackupsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", resp, "Failure sending request")
	}

	result, err = client.ListSiteBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", resp, "Failure responding to request")
	}

	return
}

// ListSiteBackupsPreparer prepares the ListSiteBackups request.
func (client SitesClient) ListSiteBackupsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteBackupsSender sends the ListSiteBackups request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteBackupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteBackupsResponder handles the response to the ListSiteBackups request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteBackupsResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteBackupsSlot sends the list site backups slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSiteBackupsSlot(resourceGroupName string, name string, slot string) (result BackupItemCollection, err error) {
	req, err := client.ListSiteBackupsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteBackupsSlotPreparer prepares the ListSiteBackupsSlot request.
func (client SitesClient) ListSiteBackupsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteBackupsSlotSender sends the ListSiteBackupsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteBackupsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteBackupsSlotResponder handles the response to the ListSiteBackupsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteBackupsSlotResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteConnectionStrings sends the list site connection strings request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSiteConnectionStrings(resourceGroupName string, name string) (result ConnectionStringDictionary, err error) {
	req, err := client.ListSiteConnectionStringsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", resp, "Failure sending request")
	}

	result, err = client.ListSiteConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// ListSiteConnectionStringsPreparer prepares the ListSiteConnectionStrings request.
func (client SitesClient) ListSiteConnectionStringsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteConnectionStringsSender sends the ListSiteConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteConnectionStringsResponder handles the response to the ListSiteConnectionStrings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteConnectionStringsSlot sends the list site connection strings slot
// request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSiteConnectionStringsSlot(resourceGroupName string, name string, slot string) (result ConnectionStringDictionary, err error) {
	req, err := client.ListSiteConnectionStringsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteConnectionStringsSlotPreparer prepares the ListSiteConnectionStringsSlot request.
func (client SitesClient) ListSiteConnectionStringsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteConnectionStringsSlotSender sends the ListSiteConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteConnectionStringsSlotResponder handles the response to the ListSiteConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteMetadata sends the list site metadata request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSiteMetadata(resourceGroupName string, name string) (result StringDictionary, err error) {
	req, err := client.ListSiteMetadataPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", resp, "Failure sending request")
	}

	result, err = client.ListSiteMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", resp, "Failure responding to request")
	}

	return
}

// ListSiteMetadataPreparer prepares the ListSiteMetadata request.
func (client SitesClient) ListSiteMetadataPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteMetadataSender sends the ListSiteMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteMetadataResponder handles the response to the ListSiteMetadata request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteMetadataSlot sends the list site metadata slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSiteMetadataSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	req, err := client.ListSiteMetadataSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteMetadataSlotPreparer prepares the ListSiteMetadataSlot request.
func (client SitesClient) ListSiteMetadataSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteMetadataSlotSender sends the ListSiteMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteMetadataSlotResponder handles the response to the ListSiteMetadataSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePremierAddOns sends the list site premier add ons request.
//
func (client SitesClient) ListSitePremierAddOns(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.ListSitePremierAddOnsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePremierAddOnsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", resp, "Failure sending request")
	}

	result, err = client.ListSitePremierAddOnsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", resp, "Failure responding to request")
	}

	return
}

// ListSitePremierAddOnsPreparer prepares the ListSitePremierAddOns request.
func (client SitesClient) ListSitePremierAddOnsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePremierAddOnsSender sends the ListSitePremierAddOns request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePremierAddOnsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePremierAddOnsResponder handles the response to the ListSitePremierAddOns request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePremierAddOnsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePremierAddOnsSlot sends the list site premier add ons slot request.
//
func (client SitesClient) ListSitePremierAddOnsSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.ListSitePremierAddOnsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePremierAddOnsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSitePremierAddOnsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSitePremierAddOnsSlotPreparer prepares the ListSitePremierAddOnsSlot request.
func (client SitesClient) ListSitePremierAddOnsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePremierAddOnsSlotSender sends the ListSitePremierAddOnsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePremierAddOnsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePremierAddOnsSlotResponder handles the response to the ListSitePremierAddOnsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePremierAddOnsSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingCredentials sends the list site publishing credentials
// request. This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ListSitePublishingCredentials(resourceGroupName string, name string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.ListSitePublishingCredentialsPreparer(resourceGroupName, name, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentials", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePublishingCredentialsSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentials", resp, "Failure sending request")
	}

	result, err = client.ListSitePublishingCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentials", resp, "Failure responding to request")
	}

	return
}

// ListSitePublishingCredentialsPreparer prepares the ListSitePublishingCredentials request.
func (client SitesClient) ListSitePublishingCredentialsPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListSitePublishingCredentialsSender sends the ListSitePublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingCredentialsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListSitePublishingCredentialsResponder handles the response to the ListSitePublishingCredentials request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingCredentialsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ListSitePublishingCredentialsSlot sends the list site publishing
// credentials slot request. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be
// used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ListSitePublishingCredentialsSlot(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.ListSitePublishingCredentialsSlotPreparer(resourceGroupName, name, slot, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentialsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePublishingCredentialsSlotSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentialsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSitePublishingCredentialsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentialsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSitePublishingCredentialsSlotPreparer prepares the ListSitePublishingCredentialsSlot request.
func (client SitesClient) ListSitePublishingCredentialsSlotPreparer(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListSitePublishingCredentialsSlotSender sends the ListSitePublishingCredentialsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingCredentialsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListSitePublishingCredentialsSlotResponder handles the response to the ListSitePublishingCredentialsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingCredentialsSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ListSitePublishingProfileXML sends the list site publishing profile xml
// request.
//
// resourceGroupName is name of resource group name is name of web app options
// is specifies options for publishing profile. Pass
// CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP format.
func (client SitesClient) ListSitePublishingProfileXML(resourceGroupName string, name string, options CsmPublishingProfileOptions) (result ReadCloser, err error) {
	req, err := client.ListSitePublishingProfileXMLPreparer(resourceGroupName, name, options)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePublishingProfileXMLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", resp, "Failure sending request")
	}

	result, err = client.ListSitePublishingProfileXMLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", resp, "Failure responding to request")
	}

	return
}

// ListSitePublishingProfileXMLPreparer prepares the ListSitePublishingProfileXML request.
func (client SitesClient) ListSitePublishingProfileXMLPreparer(resourceGroupName string, name string, options CsmPublishingProfileOptions) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml", pathParameters),
		autorest.WithJSON(options),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePublishingProfileXMLSender sends the ListSitePublishingProfileXML request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingProfileXMLSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePublishingProfileXMLResponder handles the response to the ListSitePublishingProfileXML request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingProfileXMLResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingProfileXMLSlot sends the list site publishing profile xml
// slot request.
//
// resourceGroupName is name of resource group name is name of web app options
// is specifies options for publishing profile. Pass
// CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP format.
// slot is name of web app slot. If not specified then will default to
// production slot.
func (client SitesClient) ListSitePublishingProfileXMLSlot(resourceGroupName string, name string, options CsmPublishingProfileOptions, slot string) (result ReadCloser, err error) {
	req, err := client.ListSitePublishingProfileXMLSlotPreparer(resourceGroupName, name, options, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSitePublishingProfileXMLSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", resp, "Failure sending request")
	}

	result, err = client.ListSitePublishingProfileXMLSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", resp, "Failure responding to request")
	}

	return
}

// ListSitePublishingProfileXMLSlotPreparer prepares the ListSitePublishingProfileXMLSlot request.
func (client SitesClient) ListSitePublishingProfileXMLSlotPreparer(resourceGroupName string, name string, options CsmPublishingProfileOptions, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml", pathParameters),
		autorest.WithJSON(options),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePublishingProfileXMLSlotSender sends the ListSitePublishingProfileXMLSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingProfileXMLSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePublishingProfileXMLSlotResponder handles the response to the ListSitePublishingProfileXMLSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingProfileXMLSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteRelayServiceConnections sends the list site relay service
// connections request.
//
// resourceGroupName is the resource group name name is the name of the web
// app
func (client SitesClient) ListSiteRelayServiceConnections(resourceGroupName string, name string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.ListSiteRelayServiceConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteRelayServiceConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", resp, "Failure sending request")
	}

	result, err = client.ListSiteRelayServiceConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", resp, "Failure responding to request")
	}

	return
}

// ListSiteRelayServiceConnectionsPreparer prepares the ListSiteRelayServiceConnections request.
func (client SitesClient) ListSiteRelayServiceConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteRelayServiceConnectionsSender sends the ListSiteRelayServiceConnections request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteRelayServiceConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteRelayServiceConnectionsResponder handles the response to the ListSiteRelayServiceConnections request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteRelayServiceConnectionsResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteRelayServiceConnectionsSlot sends the list site relay service
// connections slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app slot is the name of the slot for the web app.
func (client SitesClient) ListSiteRelayServiceConnectionsSlot(resourceGroupName string, name string, slot string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.ListSiteRelayServiceConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", nil, "Failure preparing request")
	}

	resp, err := client.ListSiteRelayServiceConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", resp, "Failure sending request")
	}

	result, err = client.ListSiteRelayServiceConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteRelayServiceConnectionsSlotPreparer prepares the ListSiteRelayServiceConnectionsSlot request.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteRelayServiceConnectionsSlotSender sends the ListSiteRelayServiceConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSiteRelayServiceConnectionsSlotResponder handles the response to the ListSiteRelayServiceConnectionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RecoverSite sends the recover site request. This method may poll for
// completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// recoveryEntity is snapshot data used for web app recovery. Snapshot
// information can be obtained by calling GetDeletedSites or GetSiteSnapshots
// API.
func (client SitesClient) RecoverSite(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.RecoverSitePreparer(resourceGroupName, name, recoveryEntity, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSite", nil, "Failure preparing request")
	}

	resp, err := client.RecoverSiteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSite", resp, "Failure sending request")
	}

	result, err = client.RecoverSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSite", resp, "Failure responding to request")
	}

	return
}

// RecoverSitePreparer prepares the RecoverSite request.
func (client SitesClient) RecoverSitePreparer(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RecoverSiteSender sends the RecoverSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RecoverSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RecoverSiteResponder handles the response to the RecoverSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RecoverSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RecoverSiteSlot sends the recover site slot request. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// recoveryEntity is snapshot data used for web app recovery. Snapshot
// information can be obtained by calling GetDeletedSites or GetSiteSnapshots
// API. slot is name of web app slot. If not specified then will default to
// production slot.
func (client SitesClient) RecoverSiteSlot(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.RecoverSiteSlotPreparer(resourceGroupName, name, recoveryEntity, slot, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.RecoverSiteSlotSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSiteSlot", resp, "Failure sending request")
	}

	result, err = client.RecoverSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSiteSlot", resp, "Failure responding to request")
	}

	return
}

// RecoverSiteSlotPreparer prepares the RecoverSiteSlot request.
func (client SitesClient) RecoverSiteSlotPreparer(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RecoverSiteSlotSender sends the RecoverSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RecoverSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RecoverSiteSlotResponder handles the response to the RecoverSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RecoverSiteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResetProductionSlotConfig sends the reset production slot config request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) ResetProductionSlotConfig(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.ResetProductionSlotConfigPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", nil, "Failure preparing request")
	}

	resp, err := client.ResetProductionSlotConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", resp, "Failure sending request")
	}

	result, err = client.ResetProductionSlotConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", resp, "Failure responding to request")
	}

	return
}

// ResetProductionSlotConfigPreparer prepares the ResetProductionSlotConfig request.
func (client SitesClient) ResetProductionSlotConfigPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ResetProductionSlotConfigSender sends the ResetProductionSlotConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ResetProductionSlotConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ResetProductionSlotConfigResponder handles the response to the ResetProductionSlotConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) ResetProductionSlotConfigResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResetSlotConfigSlot sends the reset slot config slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) ResetSlotConfigSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.ResetSlotConfigSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.ResetSlotConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", resp, "Failure sending request")
	}

	result, err = client.ResetSlotConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", resp, "Failure responding to request")
	}

	return
}

// ResetSlotConfigSlotPreparer prepares the ResetSlotConfigSlot request.
func (client SitesClient) ResetSlotConfigSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ResetSlotConfigSlotSender sends the ResetSlotConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ResetSlotConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ResetSlotConfigSlotResponder handles the response to the ResetSlotConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ResetSlotConfigSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSite sends the restart site request.
//
// resourceGroupName is name of resource group name is name of web app
// softRestart is soft restart applies the configuration settings and
// restarts the app if necessary. Hard restart always restarts and
// reprovisions the app synchronous is if true then the API will block until
// the app has been restarted
func (client SitesClient) RestartSite(resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result SetObject, err error) {
	req, err := client.RestartSitePreparer(resourceGroupName, name, softRestart, synchronous)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", nil, "Failure preparing request")
	}

	resp, err := client.RestartSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", resp, "Failure sending request")
	}

	result, err = client.RestartSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", resp, "Failure responding to request")
	}

	return
}

// RestartSitePreparer prepares the RestartSite request.
func (client SitesClient) RestartSitePreparer(resourceGroupName string, name string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RestartSiteSender sends the RestartSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestartSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RestartSiteResponder handles the response to the RestartSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RestartSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSiteSlot sends the restart site slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot. softRestart is soft restart applies the configuration settings and
// restarts the app if necessary. Hard restart always restarts and
// reprovisions the app synchronous is if true then the API will block until
// the app has been restarted
func (client SitesClient) RestartSiteSlot(resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result SetObject, err error) {
	req, err := client.RestartSiteSlotPreparer(resourceGroupName, name, slot, softRestart, synchronous)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.RestartSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", resp, "Failure sending request")
	}

	result, err = client.RestartSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", resp, "Failure responding to request")
	}

	return
}

// RestartSiteSlotPreparer prepares the RestartSiteSlot request.
func (client SitesClient) RestartSiteSlotPreparer(resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RestartSiteSlotSender sends the RestartSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestartSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RestartSiteSlotResponder handles the response to the RestartSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RestartSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestoreSite sends the restore site request. This method may poll for
// completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup to restore request is information on restore
// request
func (client SitesClient) RestoreSite(resourceGroupName string, name string, backupID string, request RestoreRequest, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.RestoreSitePreparer(resourceGroupName, name, backupID, request, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSite", nil, "Failure preparing request")
	}

	resp, err := client.RestoreSiteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSite", resp, "Failure sending request")
	}

	result, err = client.RestoreSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSite", resp, "Failure responding to request")
	}

	return
}

// RestoreSitePreparer prepares the RestoreSite request.
func (client SitesClient) RestoreSitePreparer(resourceGroupName string, name string, backupID string, request RestoreRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RestoreSiteSender sends the RestoreSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestoreSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RestoreSiteResponder handles the response to the RestoreSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RestoreSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RestoreSiteSlot sends the restore site slot request. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// backupID is id of backup to restore request is information on restore
// request slot is name of web app slot. If not specified then will default
// to production slot.
func (client SitesClient) RestoreSiteSlot(resourceGroupName string, name string, backupID string, request RestoreRequest, slot string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.RestoreSiteSlotPreparer(resourceGroupName, name, backupID, request, slot, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.RestoreSiteSlotSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSiteSlot", resp, "Failure sending request")
	}

	result, err = client.RestoreSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSiteSlot", resp, "Failure responding to request")
	}

	return
}

// RestoreSiteSlotPreparer prepares the RestoreSiteSlot request.
func (client SitesClient) RestoreSiteSlotPreparer(resourceGroupName string, name string, backupID string, request RestoreRequest, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RestoreSiteSlotSender sends the RestoreSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestoreSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RestoreSiteSlotResponder handles the response to the RestoreSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RestoreSiteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StartSite sends the start site request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) StartSite(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.StartSitePreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", nil, "Failure preparing request")
	}

	resp, err := client.StartSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", resp, "Failure sending request")
	}

	result, err = client.StartSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", resp, "Failure responding to request")
	}

	return
}

// StartSitePreparer prepares the StartSite request.
func (client SitesClient) StartSitePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartSiteSender sends the StartSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StartSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartSiteResponder handles the response to the StartSite request. The method always
// closes the http.Response Body.
func (client SitesClient) StartSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StartSiteSlot sends the start site slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) StartSiteSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.StartSiteSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.StartSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", resp, "Failure sending request")
	}

	result, err = client.StartSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", resp, "Failure responding to request")
	}

	return
}

// StartSiteSlotPreparer prepares the StartSiteSlot request.
func (client SitesClient) StartSiteSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartSiteSlotSender sends the StartSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StartSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartSiteSlotResponder handles the response to the StartSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) StartSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopSite sends the stop site request.
//
// resourceGroupName is name of resource group name is name of web app
func (client SitesClient) StopSite(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.StopSitePreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", nil, "Failure preparing request")
	}

	resp, err := client.StopSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", resp, "Failure sending request")
	}

	result, err = client.StopSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", resp, "Failure responding to request")
	}

	return
}

// StopSitePreparer prepares the StopSite request.
func (client SitesClient) StopSitePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopSiteSender sends the StopSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StopSiteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopSiteResponder handles the response to the StopSite request. The method always
// closes the http.Response Body.
func (client SitesClient) StopSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopSiteSlot sends the stop site slot request.
//
// resourceGroupName is name of resource group name is name of web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) StopSiteSlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.StopSiteSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", nil, "Failure preparing request")
	}

	resp, err := client.StopSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", resp, "Failure sending request")
	}

	result, err = client.StopSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", resp, "Failure responding to request")
	}

	return
}

// StopSiteSlotPreparer prepares the StopSiteSlot request.
func (client SitesClient) StopSiteSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopSiteSlotSender sends the StopSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StopSiteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopSiteSlotResponder handles the response to the StopSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) StopSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SwapSlotsSlot sends the swap slots slot request. This method may poll for
// completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name slot is
// name of source slot for the swap
func (client SitesClient) SwapSlotsSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.SwapSlotsSlotPreparer(resourceGroupName, name, slotSwapEntity, slot, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotsSlot", nil, "Failure preparing request")
	}

	resp, err := client.SwapSlotsSlotSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotsSlot", resp, "Failure sending request")
	}

	result, err = client.SwapSlotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotsSlot", resp, "Failure responding to request")
	}

	return
}

// SwapSlotsSlotPreparer prepares the SwapSlotsSlot request.
func (client SitesClient) SwapSlotsSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SwapSlotsSlotSender sends the SwapSlotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SwapSlotsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SwapSlotsSlotResponder handles the response to the SwapSlotsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) SwapSlotsSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SwapSlotWithProduction sends the swap slot with production request. This
// method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of web app
// slotSwapEntity is request body that contains the target slot name
func (client SitesClient) SwapSlotWithProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.SwapSlotWithProductionPreparer(resourceGroupName, name, slotSwapEntity, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotWithProduction", nil, "Failure preparing request")
	}

	resp, err := client.SwapSlotWithProductionSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotWithProduction", resp, "Failure sending request")
	}

	result, err = client.SwapSlotWithProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotWithProduction", resp, "Failure responding to request")
	}

	return
}

// SwapSlotWithProductionPreparer prepares the SwapSlotWithProduction request.
func (client SitesClient) SwapSlotWithProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SwapSlotWithProductionSender sends the SwapSlotWithProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SwapSlotWithProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SwapSlotWithProductionResponder handles the response to the SwapSlotWithProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) SwapSlotWithProductionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SyncSiteRepository sends the sync site repository request.
//
func (client SitesClient) SyncSiteRepository(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.SyncSiteRepositoryPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", nil, "Failure preparing request")
	}

	resp, err := client.SyncSiteRepositorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", resp, "Failure sending request")
	}

	result, err = client.SyncSiteRepositoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", resp, "Failure responding to request")
	}

	return
}

// SyncSiteRepositoryPreparer prepares the SyncSiteRepository request.
func (client SitesClient) SyncSiteRepositoryPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncSiteRepositorySender sends the SyncSiteRepository request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SyncSiteRepositorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncSiteRepositoryResponder handles the response to the SyncSiteRepository request. The method always
// closes the http.Response Body.
func (client SitesClient) SyncSiteRepositoryResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SyncSiteRepositorySlot sends the sync site repository slot request.
//
func (client SitesClient) SyncSiteRepositorySlot(resourceGroupName string, name string, slot string) (result SetObject, err error) {
	req, err := client.SyncSiteRepositorySlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", nil, "Failure preparing request")
	}

	resp, err := client.SyncSiteRepositorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", resp, "Failure sending request")
	}

	result, err = client.SyncSiteRepositorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", resp, "Failure responding to request")
	}

	return
}

// SyncSiteRepositorySlotPreparer prepares the SyncSiteRepositorySlot request.
func (client SitesClient) SyncSiteRepositorySlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncSiteRepositorySlotSender sends the SyncSiteRepositorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SyncSiteRepositorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncSiteRepositorySlotResponder handles the response to the SyncSiteRepositorySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) SyncSiteRepositorySlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAppSettings sends the update site app settings request.
//
// resourceGroupName is name of resource group name is name of web app
// appSettings is application settings of web app
func (client SitesClient) UpdateSiteAppSettings(resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	req, err := client.UpdateSiteAppSettingsPreparer(resourceGroupName, name, appSettings)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteAppSettingsPreparer prepares the UpdateSiteAppSettings request.
func (client SitesClient) UpdateSiteAppSettingsPreparer(resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteAppSettingsSender sends the UpdateSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteAppSettingsResponder handles the response to the UpdateSiteAppSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAppSettingsSlot sends the update site app settings slot request.
//
// resourceGroupName is name of resource group name is name of web app
// appSettings is application settings of web app slot is name of web app
// slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteAppSettingsSlot(resourceGroupName string, name string, appSettings StringDictionary, slot string) (result StringDictionary, err error) {
	req, err := client.UpdateSiteAppSettingsSlotPreparer(resourceGroupName, name, appSettings, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteAppSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteAppSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteAppSettingsSlotPreparer prepares the UpdateSiteAppSettingsSlot request.
func (client SitesClient) UpdateSiteAppSettingsSlotPreparer(resourceGroupName string, name string, appSettings StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteAppSettingsSlotSender sends the UpdateSiteAppSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAppSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteAppSettingsSlotResponder handles the response to the UpdateSiteAppSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAppSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAuthSettings sends the update site auth settings request.
//
// resourceGroupName is name of resource group name is name of web app
// siteAuthSettings is auth settings associated with web app
func (client SitesClient) UpdateSiteAuthSettings(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (result SiteAuthSettings, err error) {
	req, err := client.UpdateSiteAuthSettingsPreparer(resourceGroupName, name, siteAuthSettings)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteAuthSettingsPreparer prepares the UpdateSiteAuthSettings request.
func (client SitesClient) UpdateSiteAuthSettingsPreparer(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteAuthSettingsSender sends the UpdateSiteAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteAuthSettingsResponder handles the response to the UpdateSiteAuthSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAuthSettingsSlot sends the update site auth settings slot request.
//
// resourceGroupName is name of resource group name is name of web app
// siteAuthSettings is auth settings associated with web app slot is name of
// web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteAuthSettingsSlot(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (result SiteAuthSettings, err error) {
	req, err := client.UpdateSiteAuthSettingsSlotPreparer(resourceGroupName, name, siteAuthSettings, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteAuthSettingsSlotPreparer prepares the UpdateSiteAuthSettingsSlot request.
func (client SitesClient) UpdateSiteAuthSettingsSlotPreparer(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteAuthSettingsSlotSender sends the UpdateSiteAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteAuthSettingsSlotResponder handles the response to the UpdateSiteAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteBackupConfiguration sends the update site backup configuration
// request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on backup request
func (client SitesClient) UpdateSiteBackupConfiguration(resourceGroupName string, name string, request BackupRequest) (result BackupRequest, err error) {
	req, err := client.UpdateSiteBackupConfigurationPreparer(resourceGroupName, name, request)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteBackupConfigurationPreparer prepares the UpdateSiteBackupConfiguration request.
func (client SitesClient) UpdateSiteBackupConfigurationPreparer(resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteBackupConfigurationSender sends the UpdateSiteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteBackupConfigurationResponder handles the response to the UpdateSiteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteBackupConfigurationSlot sends the update site backup
// configuration slot request.
//
// resourceGroupName is name of resource group name is name of web app request
// is information on backup request slot is name of web app slot. If not
// specified then will default to production slot.
func (client SitesClient) UpdateSiteBackupConfigurationSlot(resourceGroupName string, name string, request BackupRequest, slot string) (result BackupRequest, err error) {
	req, err := client.UpdateSiteBackupConfigurationSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteBackupConfigurationSlotPreparer prepares the UpdateSiteBackupConfigurationSlot request.
func (client SitesClient) UpdateSiteBackupConfigurationSlotPreparer(resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteBackupConfigurationSlotSender sends the UpdateSiteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteBackupConfigurationSlotResponder handles the response to the UpdateSiteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConfig sends the update site config request.
//
// resourceGroupName is name of resource group name is name of web app
// siteConfig is request body that contains the configuraiton setting for the
// web app
func (client SitesClient) UpdateSiteConfig(resourceGroupName string, name string, siteConfig SiteConfig) (result SiteConfig, err error) {
	req, err := client.UpdateSiteConfigPreparer(resourceGroupName, name, siteConfig)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteConfigPreparer prepares the UpdateSiteConfig request.
func (client SitesClient) UpdateSiteConfigPreparer(resourceGroupName string, name string, siteConfig SiteConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteConfigSender sends the UpdateSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteConfigResponder handles the response to the UpdateSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConfigSlot sends the update site config slot request.
//
// resourceGroupName is name of resource group name is name of web app
// siteConfig is request body that contains the configuraiton setting for the
// web app slot is name of web app slot. If not specified then will default
// to production slot.
func (client SitesClient) UpdateSiteConfigSlot(resourceGroupName string, name string, siteConfig SiteConfig, slot string) (result SiteConfig, err error) {
	req, err := client.UpdateSiteConfigSlotPreparer(resourceGroupName, name, siteConfig, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteConfigSlotPreparer prepares the UpdateSiteConfigSlot request.
func (client SitesClient) UpdateSiteConfigSlotPreparer(resourceGroupName string, name string, siteConfig SiteConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteConfigSlotSender sends the UpdateSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteConfigSlotResponder handles the response to the UpdateSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConnectionStrings sends the update site connection strings
// request.
//
// resourceGroupName is name of resource group name is name of web app
// connectionStrings is connection strings associated with web app
func (client SitesClient) UpdateSiteConnectionStrings(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (result ConnectionStringDictionary, err error) {
	req, err := client.UpdateSiteConnectionStringsPreparer(resourceGroupName, name, connectionStrings)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteConnectionStringsPreparer prepares the UpdateSiteConnectionStrings request.
func (client SitesClient) UpdateSiteConnectionStringsPreparer(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteConnectionStringsSender sends the UpdateSiteConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteConnectionStringsResponder handles the response to the UpdateSiteConnectionStrings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConnectionStringsSlot sends the update site connection strings
// slot request.
//
// resourceGroupName is name of resource group name is name of web app
// connectionStrings is connection strings associated with web app slot is
// name of web app slot. If not specified then will default to production
// slot.
func (client SitesClient) UpdateSiteConnectionStringsSlot(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (result ConnectionStringDictionary, err error) {
	req, err := client.UpdateSiteConnectionStringsSlotPreparer(resourceGroupName, name, connectionStrings, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteConnectionStringsSlotPreparer prepares the UpdateSiteConnectionStringsSlot request.
func (client SitesClient) UpdateSiteConnectionStringsSlotPreparer(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteConnectionStringsSlotSender sends the UpdateSiteConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteConnectionStringsSlotResponder handles the response to the UpdateSiteConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteLogsConfig sends the update site logs config request.
//
// resourceGroupName is name of resource group name is name of web app
// siteLogsConfig is site logs configuration
func (client SitesClient) UpdateSiteLogsConfig(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (result SiteLogsConfig, err error) {
	req, err := client.UpdateSiteLogsConfigPreparer(resourceGroupName, name, siteLogsConfig)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteLogsConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteLogsConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteLogsConfigPreparer prepares the UpdateSiteLogsConfig request.
func (client SitesClient) UpdateSiteLogsConfigPreparer(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteLogsConfigSender sends the UpdateSiteLogsConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteLogsConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteLogsConfigResponder handles the response to the UpdateSiteLogsConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteLogsConfigResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteLogsConfigSlot sends the update site logs config slot request.
//
// resourceGroupName is name of resource group name is name of web app
// siteLogsConfig is site logs configuration slot is name of web app slot. If
// not specified then will default to production slot.
func (client SitesClient) UpdateSiteLogsConfigSlot(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (result SiteLogsConfig, err error) {
	req, err := client.UpdateSiteLogsConfigSlotPreparer(resourceGroupName, name, siteLogsConfig, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteLogsConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteLogsConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteLogsConfigSlotPreparer prepares the UpdateSiteLogsConfigSlot request.
func (client SitesClient) UpdateSiteLogsConfigSlotPreparer(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteLogsConfigSlotSender sends the UpdateSiteLogsConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteLogsConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteLogsConfigSlotResponder handles the response to the UpdateSiteLogsConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteLogsConfigSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteMetadata sends the update site metadata request.
//
// resourceGroupName is name of resource group name is name of web app
// metadata is meta data of web app
func (client SitesClient) UpdateSiteMetadata(resourceGroupName string, name string, metadata StringDictionary) (result StringDictionary, err error) {
	req, err := client.UpdateSiteMetadataPreparer(resourceGroupName, name, metadata)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteMetadataPreparer prepares the UpdateSiteMetadata request.
func (client SitesClient) UpdateSiteMetadataPreparer(resourceGroupName string, name string, metadata StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteMetadataSender sends the UpdateSiteMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteMetadataResponder handles the response to the UpdateSiteMetadata request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteMetadataSlot sends the update site metadata slot request.
//
// resourceGroupName is name of resource group name is name of web app
// metadata is meta data of web app slot is name of web app slot. If not
// specified then will default to production slot.
func (client SitesClient) UpdateSiteMetadataSlot(resourceGroupName string, name string, metadata StringDictionary, slot string) (result StringDictionary, err error) {
	req, err := client.UpdateSiteMetadataSlotPreparer(resourceGroupName, name, metadata, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteMetadataSlotPreparer prepares the UpdateSiteMetadataSlot request.
func (client SitesClient) UpdateSiteMetadataSlotPreparer(resourceGroupName string, name string, metadata StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteMetadataSlotSender sends the UpdateSiteMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteMetadataSlotResponder handles the response to the UpdateSiteMetadataSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteRelayServiceConnection sends the update site relay service
// connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// connectionEnvelope is the details of the Hybrid Connection
func (client SitesClient) UpdateSiteRelayServiceConnection(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	req, err := client.UpdateSiteRelayServiceConnectionPreparer(resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteRelayServiceConnectionPreparer prepares the UpdateSiteRelayServiceConnection request.
func (client SitesClient) UpdateSiteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteRelayServiceConnectionSender sends the UpdateSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteRelayServiceConnectionResponder handles the response to the UpdateSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteRelayServiceConnectionSlot sends the update site relay service
// connection slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app entityName is the name by which the Hybrid Connection is identified
// connectionEnvelope is the details of the Hybrid Connection slot is the
// name of the slot for the web app.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	req, err := client.UpdateSiteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteRelayServiceConnectionSlotPreparer prepares the UpdateSiteRelayServiceConnectionSlot request.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteRelayServiceConnectionSlotSender sends the UpdateSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteRelayServiceConnectionSlotResponder handles the response to the UpdateSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteSourceControl sends the update site source control request.
//
// resourceGroupName is name of resource group name is name of web app
// siteSourceControl is request body that contains the source control
// parameters
func (client SitesClient) UpdateSiteSourceControl(resourceGroupName string, name string, siteSourceControl SiteSourceControl) (result SiteSourceControl, err error) {
	req, err := client.UpdateSiteSourceControlPreparer(resourceGroupName, name, siteSourceControl)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteSourceControlPreparer prepares the UpdateSiteSourceControl request.
func (client SitesClient) UpdateSiteSourceControlPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteSourceControlSender sends the UpdateSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteSourceControlResponder handles the response to the UpdateSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteSourceControlSlot sends the update site source control slot
// request.
//
// resourceGroupName is name of resource group name is name of web app
// siteSourceControl is request body that contains the source control
// parameters slot is name of web app slot. If not specified then will
// default to production slot.
func (client SitesClient) UpdateSiteSourceControlSlot(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (result SiteSourceControl, err error) {
	req, err := client.UpdateSiteSourceControlSlotPreparer(resourceGroupName, name, siteSourceControl, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteSourceControlSlotPreparer prepares the UpdateSiteSourceControlSlot request.
func (client SitesClient) UpdateSiteSourceControlSlotPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteSourceControlSlotSender sends the UpdateSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteSourceControlSlotResponder handles the response to the UpdateSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnection sends the update site vnet connection request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network connectionEnvelope is the
// properties of this Virtual Network Connection
func (client SitesClient) UpdateSiteVNETConnection(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	req, err := client.UpdateSiteVNETConnectionPreparer(resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteVNETConnectionPreparer prepares the UpdateSiteVNETConnection request.
func (client SitesClient) UpdateSiteVNETConnectionPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteVNETConnectionSender sends the UpdateSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteVNETConnectionResponder handles the response to the UpdateSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionGateway sends the update site vnet connection
// gateway request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope is the properties to update this gateway with.
func (client SitesClient) UpdateSiteVNETConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	req, err := client.UpdateSiteVNETConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteVNETConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteVNETConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteVNETConnectionGatewayPreparer prepares the UpdateSiteVNETConnectionGateway request.
func (client SitesClient) UpdateSiteVNETConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteVNETConnectionGatewaySender sends the UpdateSiteVNETConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteVNETConnectionGatewayResponder handles the response to the UpdateSiteVNETConnectionGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionGatewaySlot sends the update site vnet connection
// gateway slot request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network gatewayName is the name of
// the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope is the properties to update this gateway with. slot is
// the name of the slot for this web app.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	req, err := client.UpdateSiteVNETConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteVNETConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteVNETConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteVNETConnectionGatewaySlotPreparer prepares the UpdateSiteVNETConnectionGatewaySlot request.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteVNETConnectionGatewaySlotSender sends the UpdateSiteVNETConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteVNETConnectionGatewaySlotResponder handles the response to the UpdateSiteVNETConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionSlot sends the update site vnet connection slot
// request.
//
// resourceGroupName is the resource group name name is the name of the web
// app vnetName is the name of the Virtual Network connectionEnvelope is the
// properties of this Virtual Network Connection slot is the name of the slot
// for this web app.
func (client SitesClient) UpdateSiteVNETConnectionSlot(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	req, err := client.UpdateSiteVNETConnectionSlotPreparer(resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", resp, "Failure sending request")
	}

	result, err = client.UpdateSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSiteVNETConnectionSlotPreparer prepares the UpdateSiteVNETConnectionSlot request.
func (client SitesClient) UpdateSiteVNETConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSiteVNETConnectionSlotSender sends the UpdateSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSiteVNETConnectionSlotResponder handles the response to the UpdateSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSlotConfigNames sends the update slot config names request.
//
// resourceGroupName is name of resource group name is name of web app
// slotConfigNames is request body containing the names of application
// settings and connection strings
func (client SitesClient) UpdateSlotConfigNames(resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (result SlotConfigNamesResource, err error) {
	req, err := client.UpdateSlotConfigNamesPreparer(resourceGroupName, name, slotConfigNames)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", nil, "Failure preparing request")
	}

	resp, err := client.UpdateSlotConfigNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", resp, "Failure sending request")
	}

	result, err = client.UpdateSlotConfigNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", resp, "Failure responding to request")
	}

	return
}

// UpdateSlotConfigNamesPreparer prepares the UpdateSlotConfigNames request.
func (client SitesClient) UpdateSlotConfigNamesPreparer(resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithJSON(slotConfigNames),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSlotConfigNamesSender sends the UpdateSlotConfigNames request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSlotConfigNamesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSlotConfigNamesResponder handles the response to the UpdateSlotConfigNames request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSlotConfigNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
