/* SPDX-License-Identifier: GPL-2.0 */

#ifndef DRM_KUNIT_EDID_H_
#define DRM_KUNIT_EDID_H_

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 0a 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ab
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     RGB color display
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II: none
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 * Checksum: 0xab
 */
static const unsigned char test_edid_dvi_1080p[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x1e, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xab
};

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 02 00 00 00 00 00 00 00
 * 00 00 00 20 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 92
 *
 * 02 03 1b 81 e3 05 00 20 41 10 e2 00 4a 6d 03 0c
 * 00 12 34 00 14 20 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 e4
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     Monochrome or grayscale display
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II:
 *     DMT 0x04:   640x480    59.940476 Hz   4:3     31.469 kHz     25.175000 MHz
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 *   Extension blocks: 1
 * Checksum: 0x92
 *
 * ----------------
 *
 * Block 1, CTA-861 Extension Block:
 *   Revision: 3
 *   Underscans IT Video Formats by default
 *   Native detailed modes: 1
 *   Colorimetry Data Block:
 *     sRGB
 *   Video Data Block:
 *     VIC  16:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz
 *   Video Capability Data Block:
 *     YCbCr quantization: No Data
 *     RGB quantization: Selectable (via AVI Q)
 *     PT scan behavior: No Data
 *     IT scan behavior: Always Underscanned
 *     CE scan behavior: Always Underscanned
 *   Vendor-Specific Data Block (HDMI), OUI 00-0C-03:
 *     Source physical address: 1.2.3.4
 *     Maximum TMDS clock: 100 MHz
 *     Extended HDMI video details:
 * Checksum: 0xe4  Unused space in Extension Block: 100 bytes
 */
static const unsigned char test_edid_hdmi_1080p_rgb_max_100mhz[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x00, 0x00, 0xc4, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x41, 0x02, 0x03, 0x1b, 0x81,
	0xe3, 0x05, 0x00, 0x20, 0x41, 0x10, 0xe2, 0x00, 0x4a, 0x6d, 0x03, 0x0c,
	0x00, 0x12, 0x34, 0x00, 0x14, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe4
};

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 02 00 00 00 00 00 00 00
 * 00 00 00 20 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 92
 *
 * 02 03 1b 81 e3 05 00 20 41 10 e2 00 4a 6d 03 0c
 * 00 12 34 00 28 20 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 d0
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     Monochrome or grayscale display
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II:
 *     DMT 0x04:   640x480    59.940476 Hz   4:3     31.469 kHz     25.175000 MHz
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 *   Extension blocks: 1
 * Checksum: 0x92
 *
 * ----------------
 *
 * Block 1, CTA-861 Extension Block:
 *   Revision: 3
 *   Underscans IT Video Formats by default
 *   Native detailed modes: 1
 *   Colorimetry Data Block:
 *     sRGB
 *   Video Data Block:
 *     VIC  16:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz
 *   Video Capability Data Block:
 *     YCbCr quantization: No Data
 *     RGB quantization: Selectable (via AVI Q)
 *     PT scan behavior: No Data
 *     IT scan behavior: Always Underscanned
 *     CE scan behavior: Always Underscanned
 *   Vendor-Specific Data Block (HDMI), OUI 00-0C-03:
 *     Source physical address: 1.2.3.4
 *     Maximum TMDS clock: 200 MHz
 *     Extended HDMI video details:
 * Checksum: 0xd0  Unused space in Extension Block: 100 bytes
 */
static const unsigned char test_edid_hdmi_1080p_rgb_max_200mhz[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x00, 0x00, 0xc4, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x41, 0x02, 0x03, 0x1b, 0x81,
	0xe3, 0x05, 0x00, 0x20, 0x41, 0x10, 0xe2, 0x00, 0x4a, 0x6d, 0x03, 0x0c,
	0x00, 0x12, 0x34, 0x00, 0x28, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xd0
};

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 02 00 00 00 00 00 00 00
 * 00 00 00 20 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 92
 *
 * 02 03 1b 81 e3 05 00 20 41 10 e2 00 4a 6d 03 0c
 * 00 12 34 00 28 20 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 d0
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     Monochrome or grayscale display
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II:
 *     DMT 0x04:   640x480    59.940476 Hz   4:3     31.469 kHz     25.175000 MHz
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 *   Extension blocks: 1
 * Checksum: 0x92
 *
 * ----------------
 *
 * Block 1, CTA-861 Extension Block:
 *   Revision: 3
 *   Underscans IT Video Formats by default
 *   Native detailed modes: 1
 *   Colorimetry Data Block:
 *     sRGB
 *   Video Data Block:
 *     VIC  16:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz
 *   Video Capability Data Block:
 *     YCbCr quantization: No Data
 *     RGB quantization: Selectable (via AVI Q)
 *     PT scan behavior: No Data
 *     IT scan behavior: Always Underscanned
 *     CE scan behavior: Always Underscanned
 *   Vendor-Specific Data Block (HDMI), OUI 00-0C-03:
 *     Source physical address: 1.2.3.4
 *     Maximum TMDS clock: 340 MHz
 *     Extended HDMI video details:
 * Checksum: 0xd0  Unused space in Extension Block: 100 bytes
 */
static const unsigned char test_edid_hdmi_1080p_rgb_max_340mhz[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x00, 0x00, 0xc4, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x41, 0x02, 0x03, 0x1b, 0x81,
	0xe3, 0x05, 0x00, 0x20, 0x41, 0x10, 0xe2, 0x00, 0x4a, 0x6d, 0x03, 0x0c,
	0x00, 0x12, 0x34, 0x00, 0x44, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xd0
};

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 1a 00 00 00 00 00 00 00
 * 00 00 00 20 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 7a
 *
 * 02 03 1b b1 e3 05 00 20 41 10 e2 00 ca 6d 03 0c
 * 00 12 34 78 28 20 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 a8
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     Undefined display color type
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II:
 *     DMT 0x04:   640x480    59.940476 Hz   4:3     31.469 kHz     25.175000 MHz
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 *   Extension blocks: 1
 * Checksum: 0x7a
 *
 * ----------------
 *
 * Block 1, CTA-861 Extension Block:
 *   Revision: 3
 *   Underscans IT Video Formats by default
 *   Supports YCbCr 4:4:4
 *   Supports YCbCr 4:2:2
 *   Native detailed modes: 1
 *   Colorimetry Data Block:
 *     sRGB
 *   Video Data Block:
 *     VIC  16:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz
 *   Video Capability Data Block:
 *     YCbCr quantization: Selectable (via AVI YQ)
 *     RGB quantization: Selectable (via AVI Q)
 *     PT scan behavior: No Data
 *     IT scan behavior: Always Underscanned
 *     CE scan behavior: Always Underscanned
 *   Vendor-Specific Data Block (HDMI), OUI 00-0C-03:
 *     Source physical address: 1.2.3.4
 *     DC_48bit
 *     DC_36bit
 *     DC_30bit
 *     DC_Y444
 *     Maximum TMDS clock: 200 MHz
 *     Extended HDMI video details:
 * Checksum: 0xa8  Unused space in Extension Block: 100 bytes
 */
static const unsigned char test_edid_hdmi_1080p_rgb_yuv_dc_max_200mhz[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x1e, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x7a, 0x02, 0x03, 0x1b, 0xb1,
	0xe3, 0x05, 0x00, 0x20, 0x41, 0x10, 0xe2, 0x00, 0xca, 0x6d, 0x03, 0x0c,
	0x00, 0x12, 0x34, 0x78, 0x28, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa8
};

/*
 * edid-decode (hex):
 *
 * 00 ff ff ff ff ff ff 00 31 d8 2a 00 00 00 00 00
 * 00 21 01 03 81 a0 5a 78 0a 00 00 00 00 00 00 00
 * 00 00 00 20 00 00 01 01 01 01 01 01 01 01 01 01
 * 01 01 01 01 01 01 02 3a 80 18 71 38 2d 40 58 2c
 * 45 00 40 84 63 00 00 1e 00 00 00 fc 00 54 65 73
 * 74 20 45 44 49 44 0a 20 20 20 00 00 00 fd 00 32
 * 46 1e 46 0f 00 0a 20 20 20 20 20 20 00 00 00 10
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 8a
 *
 * 02 03 1b b1 e3 05 00 20 41 10 e2 00 ca 6d 03 0c
 * 00 12 34 78 44 20 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 8c
 *
 * ----------------
 *
 * Block 0, Base EDID:
 *   EDID Structure Version & Revision: 1.3
 *   Vendor & Product Identification:
 *     Manufacturer: LNX
 *     Model: 42
 *     Made in: 2023
 *   Basic Display Parameters & Features:
 *     Digital display
 *     DFP 1.x compatible TMDS
 *     Maximum image size: 160 cm x 90 cm
 *     Gamma: 2.20
 *     RGB color display
 *     First detailed timing is the preferred timing
 *   Color Characteristics:
 *     Red  : 0.0000, 0.0000
 *     Green: 0.0000, 0.0000
 *     Blue : 0.0000, 0.0000
 *     White: 0.0000, 0.0000
 *   Established Timings I & II:
 *     DMT 0x04:   640x480    59.940476 Hz   4:3     31.469 kHz     25.175000 MHz
 *   Standard Timings: none
 *   Detailed Timing Descriptors:
 *     DTD 1:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz (1600 mm x 900 mm)
 *                  Hfront   88 Hsync  44 Hback  148 Hpol P
 *                  Vfront    4 Vsync   5 Vback   36 Vpol P
 *     Display Product Name: 'Test EDID'
 *     Display Range Limits:
 *       Monitor ranges (GTF): 50-70 Hz V, 30-70 kHz H, max dotclock 150 MHz
 *     Dummy Descriptor:
 *   Extension blocks: 1
 * Checksum: 0x8a
 *
 * ----------------
 *
 * Block 1, CTA-861 Extension Block:
 *   Revision: 3
 *   Underscans IT Video Formats by default
 *   Supports YCbCr 4:4:4
 *   Supports YCbCr 4:2:2
 *   Native detailed modes: 1
 *   Colorimetry Data Block:
 *     sRGB
 *   Video Data Block:
 *     VIC  16:  1920x1080   60.000000 Hz  16:9     67.500 kHz    148.500000 MHz
 *   Video Capability Data Block:
 *     YCbCr quantization: Selectable (via AVI YQ)
 *     RGB quantization: Selectable (via AVI Q)
 *     PT scan behavior: No Data
 *     IT scan behavior: Always Underscanned
 *     CE scan behavior: Always Underscanned
 *   Vendor-Specific Data Block (HDMI), OUI 00-0C-03:
 *     Source physical address: 1.2.3.4
 *     DC_48bit
 *     DC_36bit
 *     DC_30bit
 *     DC_Y444
 *     Maximum TMDS clock: 340 MHz
 *     Extended HDMI video details:
 * Checksum: 0x8c  Unused space in Extension Block: 100 bytes
 */
static const unsigned char test_edid_hdmi_1080p_rgb_yuv_dc_max_340mhz[] = {
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x31, 0xd8, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x01, 0x03, 0x81, 0xa0, 0x5a, 0x78,
	0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38,
	0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
	0x00, 0x00, 0x00, 0xfc, 0x00, 0x54, 0x65, 0x73, 0x74, 0x20, 0x45, 0x44,
	0x49, 0x44, 0x0a, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x32,
	0x46, 0x1e, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8a, 0x02, 0x03, 0x1b, 0xb1,
	0xe3, 0x05, 0x00, 0x20, 0x41, 0x10, 0xe2, 0x00, 0xca, 0x6d, 0x03, 0x0c,
	0x00, 0x12, 0x34, 0x78, 0x44, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x8c
};

#endif // DRM_KUNIT_EDID_H_
