/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _nbif_6_3_1_OFFSET_HEADER
#define _nbif_6_3_1_OFFSET_HEADER


// addressBlock: nbif_bif_cfg_dev0_rc_bifcfgdecp
// base address: 0x0
#define cfgIRQ_BRIDGE_CNTL                                                                              0x003e


// addressBlock: nbif_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VENDOR_ID                                                                  0x0000
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_ID                                                                  0x0002
#define cfgBIF_CFG_DEV0_EPF0_COMMAND                                                                    0x0004
#define cfgBIF_CFG_DEV0_EPF0_STATUS                                                                     0x0006
#define cfgBIF_CFG_DEV0_EPF0_REVISION_ID                                                                0x0008
#define cfgBIF_CFG_DEV0_EPF0_PROG_INTERFACE                                                             0x0009
#define cfgBIF_CFG_DEV0_EPF0_SUB_CLASS                                                                  0x000a
#define cfgBIF_CFG_DEV0_EPF0_BASE_CLASS                                                                 0x000b
#define cfgBIF_CFG_DEV0_EPF0_CACHE_LINE                                                                 0x000c
#define cfgBIF_CFG_DEV0_EPF0_LATENCY                                                                    0x000d
#define cfgBIF_CFG_DEV0_EPF0_HEADER                                                                     0x000e
#define cfgBIF_CFG_DEV0_EPF0_BIST                                                                       0x000f
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_1                                                                0x0010
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_2                                                                0x0014
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_3                                                                0x0018
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_4                                                                0x001c
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_5                                                                0x0020
#define cfgBIF_CFG_DEV0_EPF0_BASE_ADDR_6                                                                0x0024
#define cfgBIF_CFG_DEV0_EPF0_CARDBUS_CIS_PTR                                                            0x0028
#define cfgBIF_CFG_DEV0_EPF0_ADAPTER_ID                                                                 0x002c
#define cfgBIF_CFG_DEV0_EPF0_ROM_BASE_ADDR                                                              0x0030
#define cfgBIF_CFG_DEV0_EPF0_CAP_PTR                                                                    0x0034
#define cfgBIF_CFG_DEV0_EPF0_INTERRUPT_LINE                                                             0x003c
#define cfgBIF_CFG_DEV0_EPF0_INTERRUPT_PIN                                                              0x003d
#define cfgBIF_CFG_DEV0_EPF0_MIN_GRANT                                                                  0x003e
#define cfgBIF_CFG_DEV0_EPF0_MAX_LATENCY                                                                0x003f
#define cfgBIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST                                                            0x0048
#define cfgBIF_CFG_DEV0_EPF0_ADAPTER_ID_W                                                               0x004c
#define cfgBIF_CFG_DEV0_EPF0_PMI_CAP_LIST                                                               0x0050
#define cfgBIF_CFG_DEV0_EPF0_PMI_CAP                                                                    0x0052
#define cfgBIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL                                                            0x0054
#define cfgBIF_CFG_DEV0_EPF0_PCIE_CAP_LIST                                                              0x0064
#define cfgBIF_CFG_DEV0_EPF0_PCIE_CAP                                                                   0x0066
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_CAP                                                                 0x0068
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_CNTL                                                                0x006c
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_STATUS                                                              0x006e
#define cfgBIF_CFG_DEV0_EPF0_LINK_CAP                                                                   0x0070
#define cfgBIF_CFG_DEV0_EPF0_LINK_CNTL                                                                  0x0074
#define cfgBIF_CFG_DEV0_EPF0_LINK_STATUS                                                                0x0076
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_CAP2                                                                0x0088
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_CNTL2                                                               0x008c
#define cfgBIF_CFG_DEV0_EPF0_DEVICE_STATUS2                                                             0x008e
#define cfgBIF_CFG_DEV0_EPF0_LINK_CAP2                                                                  0x0090
#define cfgBIF_CFG_DEV0_EPF0_LINK_CNTL2                                                                 0x0094
#define cfgBIF_CFG_DEV0_EPF0_LINK_STATUS2                                                               0x0096
#define cfgBIF_CFG_DEV0_EPF0_MSI_CAP_LIST                                                               0x00a0
#define cfgBIF_CFG_DEV0_EPF0_MSI_MSG_CNTL                                                               0x00a2
#define cfgBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO                                                            0x00a4
#define cfgBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI                                                            0x00a8
#define cfgBIF_CFG_DEV0_EPF0_MSI_MSG_DATA                                                               0x00a8
#define cfgBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA                                                           0x00aa
#define cfgBIF_CFG_DEV0_EPF0_MSI_MASK                                                                   0x00ac
#define cfgBIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64                                                        0x00ae
#define cfgBIF_CFG_DEV0_EPF0_MSI_MASK_64                                                                0x00b0
#define cfgBIF_CFG_DEV0_EPF0_MSI_PENDING                                                                0x00b0
#define cfgBIF_CFG_DEV0_EPF0_MSI_PENDING_64                                                             0x00b4
#define cfgBIF_CFG_DEV0_EPF0_MSIX_CAP_LIST                                                              0x00c0
#define cfgBIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL                                                              0x00c2
#define cfgBIF_CFG_DEV0_EPF0_MSIX_TABLE                                                                 0x00c4
#define cfgBIF_CFG_DEV0_EPF0_MSIX_PBA                                                                   0x00c8
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x0100
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR                                                   0x0104
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1                                                      0x0108
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2                                                      0x010c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST                                                       0x0110
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1                                                      0x0114
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2                                                      0x0118
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL                                                          0x011c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS                                                        0x011e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP                                                      0x0120
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL                                                     0x0124
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS                                                   0x012a
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP                                                      0x012c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL                                                     0x0130
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS                                                   0x0136
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                           0x0140
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1                                                    0x0144
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2                                                    0x0148
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x0150
#define cfgBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS                                                     0x0154
#define cfgBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK                                                       0x0158
#define cfgBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY                                                   0x015c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS                                                       0x0160
#define cfgBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK                                                         0x0164
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL                                                      0x0168
#define cfgBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0                                                              0x016c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1                                                              0x0170
#define cfgBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2                                                              0x0174
#define cfgBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3                                                              0x0178
#define cfgBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0                                                       0x0188
#define cfgBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1                                                       0x018c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2                                                       0x0190
#define cfgBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3                                                       0x0194
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST                                                      0x0200
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP                                                              0x0204
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL                                                             0x0208
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP                                                              0x020c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL                                                             0x0210
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP                                                              0x0214
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL                                                             0x0218
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP                                                              0x021c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL                                                             0x0220
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP                                                              0x0224
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL                                                             0x0228
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP                                                              0x022c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL                                                             0x0230
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x0240
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT                                                0x0244
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA                                                       0x0248
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP                                                        0x024c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST                                                      0x0250
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_CAP                                                               0x0254
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR                                                 0x0258
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS                                                            0x025c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL                                                              0x025e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x0260
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x0261
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x0262
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x0263
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x0264
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x0265
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x0266
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x0267
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST                                                0x0270
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3                                                            0x0274
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS                                                     0x0278
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL                                              0x027c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL                                              0x027e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL                                              0x0280
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL                                              0x0282
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL                                              0x0284
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL                                              0x0286
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL                                              0x0288
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL                                              0x028a
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL                                              0x028c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL                                              0x028e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL                                             0x0290
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL                                             0x0292
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL                                             0x0294
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL                                             0x0296
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL                                             0x0298
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL                                             0x029a
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST                                                      0x02a0
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ACS_CAP                                                               0x02a4
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL                                                              0x02a6
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST                                                    0x02d0
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PASID_CAP                                                             0x02d4
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL                                                            0x02d6
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST                                                      0x0320
#define cfgBIF_CFG_DEV0_EPF0_PCIE_LTR_CAP                                                               0x0324
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST                                                      0x0328
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ARI_CAP                                                               0x032c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL                                                              0x032e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST                                                    0x0330
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP                                                             0x0334
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL                                                         0x0338
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_STATUS                                                          0x033a
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS                                                     0x033c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS                                                       0x033e
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS                                                         0x0340
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK                                                   0x0342
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET                                                 0x0344
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE                                                       0x0346
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID                                                    0x034a
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                             0x034c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                                0x0350
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0                                                  0x0354
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1                                                  0x0358
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2                                                  0x035c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3                                                  0x0360
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4                                                  0x0364
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5                                                  0x0368
#define cfgBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                                 0x036c
#define cfgBIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST                                                      0x0400
#define cfgBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP                                                      0x0404
#define cfgBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS                                                   0x0408
#define cfgBIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST                                                 0x0410
#define cfgBIF_CFG_DEV0_EPF0_LINK_CAP_16GT                                                              0x0414
#define cfgBIF_CFG_DEV0_EPF0_LINK_CNTL_16GT                                                             0x0418
#define cfgBIF_CFG_DEV0_EPF0_LINK_STATUS_16GT                                                           0x041c
#define cfgBIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                          0x0420
#define cfgBIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT                                           0x0424
#define cfgBIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT                                           0x0428
#define cfgBIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT                                              0x0430
#define cfgBIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT                                              0x0431
#define cfgBIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT                                              0x0432
#define cfgBIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT                                              0x0433
#define cfgBIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT                                              0x0434
#define cfgBIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT                                              0x0435
#define cfgBIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT                                              0x0436
#define cfgBIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT                                              0x0437
#define cfgBIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT                                              0x0438
#define cfgBIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT                                              0x0439
#define cfgBIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT                                             0x043a
#define cfgBIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT                                             0x043b
#define cfgBIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT                                             0x043c
#define cfgBIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT                                             0x043d
#define cfgBIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT                                             0x043e
#define cfgBIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT                                             0x043f
#define cfgBIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST                                                0x0450
#define cfgBIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP                                                         0x0454
#define cfgBIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS                                                      0x0456
#define cfgBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL                                                 0x0458
#define cfgBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS                                               0x045a
#define cfgBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL                                                 0x045c
#define cfgBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS                                               0x045e
#define cfgBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL                                                 0x0460
#define cfgBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS                                               0x0462
#define cfgBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL                                                 0x0464
#define cfgBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS                                               0x0466
#define cfgBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL                                                 0x0468
#define cfgBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS                                               0x046a
#define cfgBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL                                                 0x046c
#define cfgBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS                                               0x046e
#define cfgBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL                                                 0x0470
#define cfgBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS                                               0x0472
#define cfgBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL                                                 0x0474
#define cfgBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS                                               0x0476
#define cfgBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL                                                 0x0478
#define cfgBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS                                               0x047a
#define cfgBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL                                                 0x047c
#define cfgBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS                                               0x047e
#define cfgBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL                                                0x0480
#define cfgBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS                                              0x0482
#define cfgBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL                                                0x0484
#define cfgBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS                                              0x0486
#define cfgBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL                                                0x0488
#define cfgBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS                                              0x048a
#define cfgBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL                                                0x048c
#define cfgBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS                                              0x048e
#define cfgBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL                                                0x0490
#define cfgBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS                                              0x0492
#define cfgBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL                                                0x0494
#define cfgBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS                                              0x0496
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                            0x04c0
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP                                                    0x04c4
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL                                                   0x04c8
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP                                                    0x04cc
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL                                                   0x04d0
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP                                                    0x04d4
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL                                                   0x04d8
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP                                                    0x04dc
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL                                                   0x04e0
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP                                                    0x04e4
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL                                                   0x04e8
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP                                                    0x04ec
#define cfgBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL                                                   0x04f0
#define cfgBIF_CFG_DEV0_EPF0_LINK_CAP_32GT                                                              0x0504
#define cfgBIF_CFG_DEV0_EPF0_LINK_CNTL_32GT                                                             0x0508
#define cfgBIF_CFG_DEV0_EPF0_LINK_STATUS_32GT                                                           0x050c


// addressBlock: nbif_bif_cfg_dev0_epf0_vf0_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF0_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF0_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF0_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF0_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF0_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF0_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF0_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF0_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF0_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF0_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF0_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF0_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF0_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF0_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF0_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF0_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF0_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf1_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF1_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF1_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF1_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF1_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF1_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF1_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF1_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF1_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF1_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF1_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF1_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF1_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF1_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF1_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF1_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF1_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF1_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf2_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF2_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF2_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF2_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF2_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF2_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF2_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF2_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF2_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF2_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF2_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF2_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF2_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF2_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF2_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF2_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF2_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF2_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf3_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF3_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF3_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF3_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF3_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF3_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF3_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF3_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF3_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF3_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF3_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF3_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF3_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF3_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF3_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF3_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF3_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF3_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf4_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF4_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF4_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF4_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF4_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF4_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF4_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF4_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF4_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF4_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF4_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF4_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF4_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF4_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF4_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF4_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF4_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF4_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf5_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF5_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF5_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF5_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF5_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF5_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF5_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF5_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF5_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF5_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF5_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF5_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF5_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF5_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF5_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF5_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF5_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF5_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf6_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF6_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF6_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF6_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF6_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF6_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF6_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF6_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF6_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF6_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF6_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF6_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF6_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF6_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF6_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF6_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF6_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF6_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf0_vf7_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF0_VF7_VENDOR_ID                                                              0x0000
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_ID                                                              0x0002
#define cfgBIF_CFG_DEV0_EPF0_VF7_COMMAND                                                                0x0004
#define cfgBIF_CFG_DEV0_EPF0_VF7_STATUS                                                                 0x0006
#define cfgBIF_CFG_DEV0_EPF0_VF7_REVISION_ID                                                            0x0008
#define cfgBIF_CFG_DEV0_EPF0_VF7_PROG_INTERFACE                                                         0x0009
#define cfgBIF_CFG_DEV0_EPF0_VF7_SUB_CLASS                                                              0x000a
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_CLASS                                                             0x000b
#define cfgBIF_CFG_DEV0_EPF0_VF7_CACHE_LINE                                                             0x000c
#define cfgBIF_CFG_DEV0_EPF0_VF7_LATENCY                                                                0x000d
#define cfgBIF_CFG_DEV0_EPF0_VF7_HEADER                                                                 0x000e
#define cfgBIF_CFG_DEV0_EPF0_VF7_BIST                                                                   0x000f
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_1                                                            0x0010
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_2                                                            0x0014
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_3                                                            0x0018
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_4                                                            0x001c
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_5                                                            0x0020
#define cfgBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_6                                                            0x0024
#define cfgBIF_CFG_DEV0_EPF0_VF7_CARDBUS_CIS_PTR                                                        0x0028
#define cfgBIF_CFG_DEV0_EPF0_VF7_ADAPTER_ID                                                             0x002c
#define cfgBIF_CFG_DEV0_EPF0_VF7_ROM_BASE_ADDR                                                          0x0030
#define cfgBIF_CFG_DEV0_EPF0_VF7_CAP_PTR                                                                0x0034
#define cfgBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_LINE                                                         0x003c
#define cfgBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_PIN                                                          0x003d
#define cfgBIF_CFG_DEV0_EPF0_VF7_MIN_GRANT                                                              0x003e
#define cfgBIF_CFG_DEV0_EPF0_VF7_MAX_LATENCY                                                            0x003f
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP_LIST                                                          0x0064
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP                                                               0x0066
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP                                                             0x0068
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL                                                            0x006c
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS                                                          0x006e
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_CAP                                                               0x0070
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL                                                              0x0074
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS                                                            0x0076
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP2                                                            0x0088
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL2                                                           0x008c
#define cfgBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS2                                                         0x008e
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_CAP2                                                              0x0090
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL2                                                             0x0094
#define cfgBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS2                                                           0x0096
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_CAP_LIST                                                           0x00a0
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_CNTL                                                           0x00a2
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_LO                                                        0x00a4
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_HI                                                        0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA                                                           0x00a8
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA                                                       0x00aa
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MASK                                                               0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA_64                                                        0x00ac
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA_64                                                    0x00ae
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_MASK_64                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING                                                            0x00b0
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING_64                                                         0x00b4
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSIX_CAP_LIST                                                          0x00c0
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSIX_MSG_CNTL                                                          0x00c2
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSIX_TABLE                                                             0x00c4
#define cfgBIF_CFG_DEV0_EPF0_VF7_MSIX_PBA                                                               0x00c8
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x0100
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_HDR                                               0x0104
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC1                                                  0x0108
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC2                                                  0x010c
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x0150
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_STATUS                                                 0x0154
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_MASK                                                   0x0158
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_SEVERITY                                               0x015c
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_STATUS                                                   0x0160
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_MASK                                                     0x0164
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_CAP_CNTL                                                  0x0168
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG0                                                          0x016c
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG1                                                          0x0170
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG2                                                          0x0174
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG3                                                          0x0178
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG0                                                   0x0188
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG1                                                   0x018c
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG2                                                   0x0190
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG3                                                   0x0194
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_ENH_CAP_LIST                                                  0x0328
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CAP                                                           0x032c
#define cfgBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CNTL                                                          0x032e


// addressBlock: nbif_bif_cfg_dev0_epf1_bifcfgdecp
// base address: 0x0
#define cfgBIF_CFG_DEV0_EPF1_VENDOR_ID                                                                  0x0000
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_ID                                                                  0x0002
#define cfgBIF_CFG_DEV0_EPF1_COMMAND                                                                    0x0004
#define cfgBIF_CFG_DEV0_EPF1_STATUS                                                                     0x0006
#define cfgBIF_CFG_DEV0_EPF1_REVISION_ID                                                                0x0008
#define cfgBIF_CFG_DEV0_EPF1_PROG_INTERFACE                                                             0x0009
#define cfgBIF_CFG_DEV0_EPF1_SUB_CLASS                                                                  0x000a
#define cfgBIF_CFG_DEV0_EPF1_BASE_CLASS                                                                 0x000b
#define cfgBIF_CFG_DEV0_EPF1_CACHE_LINE                                                                 0x000c
#define cfgBIF_CFG_DEV0_EPF1_LATENCY                                                                    0x000d
#define cfgBIF_CFG_DEV0_EPF1_HEADER                                                                     0x000e
#define cfgBIF_CFG_DEV0_EPF1_BIST                                                                       0x000f
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_1                                                                0x0010
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_2                                                                0x0014
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_3                                                                0x0018
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_4                                                                0x001c
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_5                                                                0x0020
#define cfgBIF_CFG_DEV0_EPF1_BASE_ADDR_6                                                                0x0024
#define cfgBIF_CFG_DEV0_EPF1_CARDBUS_CIS_PTR                                                            0x0028
#define cfgBIF_CFG_DEV0_EPF1_ADAPTER_ID                                                                 0x002c
#define cfgBIF_CFG_DEV0_EPF1_ROM_BASE_ADDR                                                              0x0030
#define cfgBIF_CFG_DEV0_EPF1_CAP_PTR                                                                    0x0034
#define cfgBIF_CFG_DEV0_EPF1_INTERRUPT_LINE                                                             0x003c
#define cfgBIF_CFG_DEV0_EPF1_INTERRUPT_PIN                                                              0x003d
#define cfgBIF_CFG_DEV0_EPF1_MIN_GRANT                                                                  0x003e
#define cfgBIF_CFG_DEV0_EPF1_MAX_LATENCY                                                                0x003f
#define cfgBIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST                                                            0x0048
#define cfgBIF_CFG_DEV0_EPF1_ADAPTER_ID_W                                                               0x004c
#define cfgBIF_CFG_DEV0_EPF1_PMI_CAP_LIST                                                               0x0050
#define cfgBIF_CFG_DEV0_EPF1_PMI_CAP                                                                    0x0052
#define cfgBIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL                                                            0x0054
#define cfgBIF_CFG_DEV0_EPF1_PCIE_CAP_LIST                                                              0x0064
#define cfgBIF_CFG_DEV0_EPF1_PCIE_CAP                                                                   0x0066
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_CAP                                                                 0x0068
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_CNTL                                                                0x006c
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_STATUS                                                              0x006e
#define cfgBIF_CFG_DEV0_EPF1_LINK_CAP                                                                   0x0070
#define cfgBIF_CFG_DEV0_EPF1_LINK_CNTL                                                                  0x0074
#define cfgBIF_CFG_DEV0_EPF1_LINK_STATUS                                                                0x0076
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_CAP2                                                                0x0088
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_CNTL2                                                               0x008c
#define cfgBIF_CFG_DEV0_EPF1_DEVICE_STATUS2                                                             0x008e
#define cfgBIF_CFG_DEV0_EPF1_LINK_CAP2                                                                  0x0090
#define cfgBIF_CFG_DEV0_EPF1_LINK_CNTL2                                                                 0x0094
#define cfgBIF_CFG_DEV0_EPF1_LINK_STATUS2                                                               0x0096
#define cfgBIF_CFG_DEV0_EPF1_MSI_CAP_LIST                                                               0x00a0
#define cfgBIF_CFG_DEV0_EPF1_MSI_MSG_CNTL                                                               0x00a2
#define cfgBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO                                                            0x00a4
#define cfgBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI                                                            0x00a8
#define cfgBIF_CFG_DEV0_EPF1_MSI_MSG_DATA                                                               0x00a8
#define cfgBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA                                                           0x00aa
#define cfgBIF_CFG_DEV0_EPF1_MSI_MASK                                                                   0x00ac
#define cfgBIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64                                                            0x00ac
#define cfgBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64                                                        0x00ae
#define cfgBIF_CFG_DEV0_EPF1_MSI_MASK_64                                                                0x00b0
#define cfgBIF_CFG_DEV0_EPF1_MSI_PENDING                                                                0x00b0
#define cfgBIF_CFG_DEV0_EPF1_MSI_PENDING_64                                                             0x00b4
#define cfgBIF_CFG_DEV0_EPF1_MSIX_CAP_LIST                                                              0x00c0
#define cfgBIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL                                                              0x00c2
#define cfgBIF_CFG_DEV0_EPF1_MSIX_TABLE                                                                 0x00c4
#define cfgBIF_CFG_DEV0_EPF1_MSIX_PBA                                                                   0x00c8
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x0100
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR                                                   0x0104
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1                                                      0x0108
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2                                                      0x010c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                           0x0140
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1                                                    0x0144
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2                                                    0x0148
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x0150
#define cfgBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS                                                     0x0154
#define cfgBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK                                                       0x0158
#define cfgBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY                                                   0x015c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS                                                       0x0160
#define cfgBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK                                                         0x0164
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL                                                      0x0168
#define cfgBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0                                                              0x016c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1                                                              0x0170
#define cfgBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2                                                              0x0174
#define cfgBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3                                                              0x0178
#define cfgBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0                                                       0x0188
#define cfgBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1                                                       0x018c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2                                                       0x0190
#define cfgBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3                                                       0x0194
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST                                                      0x0200
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP                                                              0x0204
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL                                                             0x0208
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP                                                              0x020c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL                                                             0x0210
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP                                                              0x0214
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL                                                             0x0218
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP                                                              0x021c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL                                                             0x0220
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP                                                              0x0224
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL                                                             0x0228
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP                                                              0x022c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL                                                             0x0230
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x0240
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT                                                0x0244
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA                                                       0x0248
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP                                                        0x024c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST                                                      0x0250
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_CAP                                                               0x0254
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR                                                 0x0258
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS                                                            0x025c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL                                                              0x025e
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x0260
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x0261
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x0262
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x0263
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x0264
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x0265
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x0266
#define cfgBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x0267
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST                                                0x0270
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3                                                            0x0274
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS                                                     0x0278
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL                                              0x027c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL                                              0x027e
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL                                              0x0280
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL                                              0x0282
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL                                              0x0284
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL                                              0x0286
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL                                              0x0288
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL                                              0x028a
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL                                              0x028c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL                                              0x028e
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL                                             0x0290
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL                                             0x0292
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL                                             0x0294
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL                                             0x0296
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL                                             0x0298
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL                                             0x029a
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST                                                      0x02a0
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ACS_CAP                                                               0x02a4
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL                                                              0x02a6
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST                                                    0x02d0
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PASID_CAP                                                             0x02d4
#define cfgBIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL                                                            0x02d6
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST                                                      0x0320
#define cfgBIF_CFG_DEV0_EPF1_PCIE_LTR_CAP                                                               0x0324
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST                                                      0x0328
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ARI_CAP                                                               0x032c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL                                                              0x032e
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST                                                    0x0330
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP                                                             0x0334
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL                                                         0x0338
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_STATUS                                                          0x033a
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS                                                     0x033c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS                                                       0x033e
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS                                                         0x0340
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK                                                   0x0342
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET                                                 0x0344
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE                                                       0x0346
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID                                                    0x034a
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                             0x034c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                                0x0350
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0                                                  0x0354
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1                                                  0x0358
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2                                                  0x035c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3                                                  0x0360
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4                                                  0x0364
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5                                                  0x0368
#define cfgBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                                 0x036c
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                            0x04c0
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP                                                    0x04c4
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL                                                   0x04c8
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP                                                    0x04cc
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL                                                   0x04d0
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP                                                    0x04d4
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL                                                   0x04d8
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP                                                    0x04dc
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL                                                   0x04e0
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP                                                    0x04e4
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL                                                   0x04e8
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP                                                    0x04ec
#define cfgBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL                                                   0x04f0


// addressBlock: nbif_bif_bx_pf_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_PF0_MM_INDEX                                                                          0x0000
#define regBIF_BX_PF0_MM_INDEX_BASE_IDX                                                                 0
#define regBIF_BX_PF0_MM_DATA                                                                           0x0001
#define regBIF_BX_PF0_MM_DATA_BASE_IDX                                                                  0
#define regBIF_BX_PF0_MM_INDEX_HI                                                                       0x0006
#define regBIF_BX_PF0_MM_INDEX_HI_BASE_IDX                                                              0
#define regBIF_BX_PF0_RSMU_INDEX                                                                        0x0000
#define regBIF_BX_PF0_RSMU_INDEX_BASE_IDX                                                               1
#define regBIF_BX_PF0_RSMU_DATA                                                                         0x0001
#define regBIF_BX_PF0_RSMU_DATA_BASE_IDX                                                                1
#define regBIF_BX_PF0_RSMU_INDEX_HI                                                                     0x0002
#define regBIF_BX_PF0_RSMU_INDEX_HI_BASE_IDX                                                            1


// addressBlock: nbif_bif_bx_SYSDEC
// base address: 0x0
#define regBIF_BX0_PCIE_INDEX                                                                           0x000c
#define regBIF_BX0_PCIE_INDEX_BASE_IDX                                                                  0
#define regBIF_BX0_PCIE_DATA                                                                            0x000d
#define regBIF_BX0_PCIE_DATA_BASE_IDX                                                                   0
#define regBIF_BX0_PCIE_INDEX2                                                                          0x000e
#define regBIF_BX0_PCIE_INDEX2_BASE_IDX                                                                 0
#define regBIF_BX0_PCIE_DATA2                                                                           0x000f
#define regBIF_BX0_PCIE_DATA2_BASE_IDX                                                                  0
#define regBIF_BX0_PCIE_INDEX_HI                                                                        0x0010
#define regBIF_BX0_PCIE_INDEX_HI_BASE_IDX                                                               0
#define regBIF_BX0_PCIE_INDEX2_HI                                                                       0x0011
#define regBIF_BX0_PCIE_INDEX2_HI_BASE_IDX                                                              0
#define regBIF_BX0_SBIOS_SCRATCH_0                                                                      0x0034
#define regBIF_BX0_SBIOS_SCRATCH_0_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_1                                                                      0x0035
#define regBIF_BX0_SBIOS_SCRATCH_1_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_2                                                                      0x0036
#define regBIF_BX0_SBIOS_SCRATCH_2_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_3                                                                      0x0037
#define regBIF_BX0_SBIOS_SCRATCH_3_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_0                                                                       0x0038
#define regBIF_BX0_BIOS_SCRATCH_0_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_1                                                                       0x0039
#define regBIF_BX0_BIOS_SCRATCH_1_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_2                                                                       0x003a
#define regBIF_BX0_BIOS_SCRATCH_2_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_3                                                                       0x003b
#define regBIF_BX0_BIOS_SCRATCH_3_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_4                                                                       0x003c
#define regBIF_BX0_BIOS_SCRATCH_4_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_5                                                                       0x003d
#define regBIF_BX0_BIOS_SCRATCH_5_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_6                                                                       0x003e
#define regBIF_BX0_BIOS_SCRATCH_6_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_7                                                                       0x003f
#define regBIF_BX0_BIOS_SCRATCH_7_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_8                                                                       0x0040
#define regBIF_BX0_BIOS_SCRATCH_8_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_9                                                                       0x0041
#define regBIF_BX0_BIOS_SCRATCH_9_BASE_IDX                                                              1
#define regBIF_BX0_BIOS_SCRATCH_10                                                                      0x0042
#define regBIF_BX0_BIOS_SCRATCH_10_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_11                                                                      0x0043
#define regBIF_BX0_BIOS_SCRATCH_11_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_12                                                                      0x0044
#define regBIF_BX0_BIOS_SCRATCH_12_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_13                                                                      0x0045
#define regBIF_BX0_BIOS_SCRATCH_13_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_14                                                                      0x0046
#define regBIF_BX0_BIOS_SCRATCH_14_BASE_IDX                                                             1
#define regBIF_BX0_BIOS_SCRATCH_15                                                                      0x0047
#define regBIF_BX0_BIOS_SCRATCH_15_BASE_IDX                                                             1
#define regBIF_BX0_BIF_RLC_INTR_CNTL                                                                    0x004c
#define regBIF_BX0_BIF_RLC_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX0_BIF_VCE_INTR_CNTL                                                                    0x004d
#define regBIF_BX0_BIF_VCE_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX0_BIF_UVD_INTR_CNTL                                                                    0x004e
#define regBIF_BX0_BIF_UVD_INTR_CNTL_BASE_IDX                                                           1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR0                                                                0x006c
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR0                                                          0x006d
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR1                                                                0x006e
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR1                                                          0x006f
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR2                                                                0x0070
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR2                                                          0x0071
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR3                                                                0x0072
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR3                                                          0x0073
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR4                                                                0x0074
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR4                                                          0x0075
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR5                                                                0x0076
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR5                                                          0x0077
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR6                                                                0x0078
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR6                                                          0x0079
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR7                                                                0x007a
#define regBIF_BX0_GFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                       1
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR7                                                          0x007b
#define regBIF_BX0_GFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                 1
#define regBIF_BX0_GFX_MMIOREG_CAM_CNTL                                                                 0x007c
#define regBIF_BX0_GFX_MMIOREG_CAM_CNTL_BASE_IDX                                                        1
#define regBIF_BX0_GFX_MMIOREG_CAM_ZERO_CPL                                                             0x007d
#define regBIF_BX0_GFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                    1
#define regBIF_BX0_GFX_MMIOREG_CAM_ONE_CPL                                                              0x007e
#define regBIF_BX0_GFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                     1
#define regBIF_BX0_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                     0x007f
#define regBIF_BX0_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                            1
#define regBIF_BX0_DRIVER_SCRATCH_0                                                                     0x0080
#define regBIF_BX0_DRIVER_SCRATCH_0_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_1                                                                     0x0081
#define regBIF_BX0_DRIVER_SCRATCH_1_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_2                                                                     0x0082
#define regBIF_BX0_DRIVER_SCRATCH_2_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_3                                                                     0x0083
#define regBIF_BX0_DRIVER_SCRATCH_3_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_4                                                                     0x0084
#define regBIF_BX0_DRIVER_SCRATCH_4_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_5                                                                     0x0085
#define regBIF_BX0_DRIVER_SCRATCH_5_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_6                                                                     0x0086
#define regBIF_BX0_DRIVER_SCRATCH_6_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_7                                                                     0x0087
#define regBIF_BX0_DRIVER_SCRATCH_7_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_8                                                                     0x0088
#define regBIF_BX0_DRIVER_SCRATCH_8_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_9                                                                     0x0089
#define regBIF_BX0_DRIVER_SCRATCH_9_BASE_IDX                                                            1
#define regBIF_BX0_DRIVER_SCRATCH_10                                                                    0x008a
#define regBIF_BX0_DRIVER_SCRATCH_10_BASE_IDX                                                           1
#define regBIF_BX0_DRIVER_SCRATCH_11                                                                    0x008b
#define regBIF_BX0_DRIVER_SCRATCH_11_BASE_IDX                                                           1
#define regBIF_BX0_DRIVER_SCRATCH_12                                                                    0x008c
#define regBIF_BX0_DRIVER_SCRATCH_12_BASE_IDX                                                           1
#define regBIF_BX0_DRIVER_SCRATCH_13                                                                    0x008d
#define regBIF_BX0_DRIVER_SCRATCH_13_BASE_IDX                                                           1
#define regBIF_BX0_DRIVER_SCRATCH_14                                                                    0x008e
#define regBIF_BX0_DRIVER_SCRATCH_14_BASE_IDX                                                           1
#define regBIF_BX0_DRIVER_SCRATCH_15                                                                    0x008f
#define regBIF_BX0_DRIVER_SCRATCH_15_BASE_IDX                                                           1
#define regBIF_BX0_FW_SCRATCH_0                                                                         0x0090
#define regBIF_BX0_FW_SCRATCH_0_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_1                                                                         0x0091
#define regBIF_BX0_FW_SCRATCH_1_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_2                                                                         0x0092
#define regBIF_BX0_FW_SCRATCH_2_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_3                                                                         0x0093
#define regBIF_BX0_FW_SCRATCH_3_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_4                                                                         0x0094
#define regBIF_BX0_FW_SCRATCH_4_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_5                                                                         0x0095
#define regBIF_BX0_FW_SCRATCH_5_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_6                                                                         0x0096
#define regBIF_BX0_FW_SCRATCH_6_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_7                                                                         0x0097
#define regBIF_BX0_FW_SCRATCH_7_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_8                                                                         0x0098
#define regBIF_BX0_FW_SCRATCH_8_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_9                                                                         0x0099
#define regBIF_BX0_FW_SCRATCH_9_BASE_IDX                                                                1
#define regBIF_BX0_FW_SCRATCH_10                                                                        0x009a
#define regBIF_BX0_FW_SCRATCH_10_BASE_IDX                                                               1
#define regBIF_BX0_FW_SCRATCH_11                                                                        0x009b
#define regBIF_BX0_FW_SCRATCH_11_BASE_IDX                                                               1
#define regBIF_BX0_FW_SCRATCH_12                                                                        0x009c
#define regBIF_BX0_FW_SCRATCH_12_BASE_IDX                                                               1
#define regBIF_BX0_FW_SCRATCH_13                                                                        0x009d
#define regBIF_BX0_FW_SCRATCH_13_BASE_IDX                                                               1
#define regBIF_BX0_FW_SCRATCH_14                                                                        0x009e
#define regBIF_BX0_FW_SCRATCH_14_BASE_IDX                                                               1
#define regBIF_BX0_FW_SCRATCH_15                                                                        0x009f
#define regBIF_BX0_FW_SCRATCH_15_BASE_IDX                                                               1
#define regBIF_BX0_SBIOS_SCRATCH_4                                                                      0x00a0
#define regBIF_BX0_SBIOS_SCRATCH_4_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_5                                                                      0x00a1
#define regBIF_BX0_SBIOS_SCRATCH_5_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_6                                                                      0x00a2
#define regBIF_BX0_SBIOS_SCRATCH_6_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_7                                                                      0x00a3
#define regBIF_BX0_SBIOS_SCRATCH_7_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_8                                                                      0x00a4
#define regBIF_BX0_SBIOS_SCRATCH_8_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_9                                                                      0x00a5
#define regBIF_BX0_SBIOS_SCRATCH_9_BASE_IDX                                                             1
#define regBIF_BX0_SBIOS_SCRATCH_10                                                                     0x00a6
#define regBIF_BX0_SBIOS_SCRATCH_10_BASE_IDX                                                            1
#define regBIF_BX0_SBIOS_SCRATCH_11                                                                     0x00a7
#define regBIF_BX0_SBIOS_SCRATCH_11_BASE_IDX                                                            1
#define regBIF_BX0_SBIOS_SCRATCH_12                                                                     0x00a8
#define regBIF_BX0_SBIOS_SCRATCH_12_BASE_IDX                                                            1
#define regBIF_BX0_SBIOS_SCRATCH_13                                                                     0x00a9
#define regBIF_BX0_SBIOS_SCRATCH_13_BASE_IDX                                                            1
#define regBIF_BX0_SBIOS_SCRATCH_14                                                                     0x00aa
#define regBIF_BX0_SBIOS_SCRATCH_14_BASE_IDX                                                            1
#define regBIF_BX0_SBIOS_SCRATCH_15                                                                     0x00ab
#define regBIF_BX0_SBIOS_SCRATCH_15_BASE_IDX                                                            1


// addressBlock: nbif_rcc_dwn_dev0_BIFDEC1
// base address: 0x0
#define regRCC_DWN_DEV0_0_DN_PCIE_RESERVED                                                              0x0060
#define regRCC_DWN_DEV0_0_DN_PCIE_RESERVED_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_0_DN_PCIE_SCRATCH                                                               0x0061
#define regRCC_DWN_DEV0_0_DN_PCIE_SCRATCH_BASE_IDX                                                      2
#define regRCC_DWN_DEV0_0_DN_PCIE_CNTL                                                                  0x0063
#define regRCC_DWN_DEV0_0_DN_PCIE_CNTL_BASE_IDX                                                         2
#define regRCC_DWN_DEV0_0_DN_PCIE_CONFIG_CNTL                                                           0x0064
#define regRCC_DWN_DEV0_0_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  2
#define regRCC_DWN_DEV0_0_DN_PCIE_RX_CNTL2                                                              0x0065
#define regRCC_DWN_DEV0_0_DN_PCIE_RX_CNTL2_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_0_DN_PCIE_BUS_CNTL                                                              0x0066
#define regRCC_DWN_DEV0_0_DN_PCIE_BUS_CNTL_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_0_DN_PCIE_CFG_CNTL                                                              0x0067
#define regRCC_DWN_DEV0_0_DN_PCIE_CFG_CNTL_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_F0                                                              0x0068
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_F0_BASE_IDX                                                     2
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_MISC                                                            0x0069
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_MISC_BASE_IDX                                                   2
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_MISC2                                                           0x006a
#define regRCC_DWN_DEV0_0_DN_PCIE_STRAP_MISC2_BASE_IDX                                                  2


// addressBlock: nbif_rcc_dwnp_dev0_BIFDEC1
// base address: 0x0
#define regRCC_DWNP_DEV0_0_PCIE_ERR_CNTL                                                                0x006c
#define regRCC_DWNP_DEV0_0_PCIE_ERR_CNTL_BASE_IDX                                                       2
#define regRCC_DWNP_DEV0_0_PCIE_RX_CNTL                                                                 0x006d
#define regRCC_DWNP_DEV0_0_PCIE_RX_CNTL_BASE_IDX                                                        2
#define regRCC_DWNP_DEV0_0_PCIE_LC_SPEED_CNTL                                                           0x006e
#define regRCC_DWNP_DEV0_0_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  2
#define regRCC_DWNP_DEV0_0_PCIE_LC_CNTL2                                                                0x006f
#define regRCC_DWNP_DEV0_0_PCIE_LC_CNTL2_BASE_IDX                                                       2
#define regRCC_DWNP_DEV0_0_PCIEP_STRAP_MISC                                                             0x0070
#define regRCC_DWNP_DEV0_0_PCIEP_STRAP_MISC_BASE_IDX                                                    2
#define regRCC_DWNP_DEV0_0_LTR_MSG_INFO_FROM_EP                                                         0x0071
#define regRCC_DWNP_DEV0_0_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                2


// addressBlock: nbif_rcc_ep_dev0_BIFDEC1
// base address: 0x0
#define regRCC_EP_DEV0_0_EP_PCIE_SCRATCH                                                                0x0041
#define regRCC_EP_DEV0_0_EP_PCIE_SCRATCH_BASE_IDX                                                       2
#define regRCC_EP_DEV0_0_EP_PCIE_CNTL                                                                   0x0043
#define regRCC_EP_DEV0_0_EP_PCIE_CNTL_BASE_IDX                                                          2
#define regRCC_EP_DEV0_0_EP_PCIE_INT_CNTL                                                               0x0044
#define regRCC_EP_DEV0_0_EP_PCIE_INT_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_INT_STATUS                                                             0x0045
#define regRCC_EP_DEV0_0_EP_PCIE_INT_STATUS_BASE_IDX                                                    2
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL2                                                               0x0046
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL2_BASE_IDX                                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_BUS_CNTL                                                               0x0047
#define regRCC_EP_DEV0_0_EP_PCIE_BUS_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_CFG_CNTL                                                               0x0048
#define regRCC_EP_DEV0_0_EP_PCIE_CFG_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_TX_LTR_CNTL                                                            0x004a
#define regRCC_EP_DEV0_0_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                               0x004b
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                               0x004b
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                               0x004b
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                               0x004b
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                               0x004c
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                               0x004c
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                               0x004c
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                               0x004c
#define regRCC_EP_DEV0_0_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_STRAP_MISC                                                             0x004d
#define regRCC_EP_DEV0_0_EP_PCIE_STRAP_MISC_BASE_IDX                                                    2
#define regRCC_EP_DEV0_0_EP_PCIE_STRAP_MISC2                                                            0x004e
#define regRCC_EP_DEV0_0_EP_PCIE_STRAP_MISC2_BASE_IDX                                                   2
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CAP                                                             0x0050
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    2
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0x0051
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CNTL                                                            0x0051
#define regRCC_EP_DEV0_0_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0x0051
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0x0052
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0x0052
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0x0052
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0x0052
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0x0053
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0x0053
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0x0053
#define regRCC_EP_DEV0_0_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_PME_CONTROL                                                            0x0053
#define regRCC_EP_DEV0_0_EP_PCIE_PME_CONTROL_BASE_IDX                                                   2
#define regRCC_EP_DEV0_0_EP_PCIEP_RESERVED                                                              0x0054
#define regRCC_EP_DEV0_0_EP_PCIEP_RESERVED_BASE_IDX                                                     2
#define regRCC_EP_DEV0_0_EP_PCIE_TX_CNTL                                                                0x0056
#define regRCC_EP_DEV0_0_EP_PCIE_TX_CNTL_BASE_IDX                                                       2
#define regRCC_EP_DEV0_0_EP_PCIE_TX_REQUESTER_ID                                                        0x0057
#define regRCC_EP_DEV0_0_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               2
#define regRCC_EP_DEV0_0_EP_PCIE_ERR_CNTL                                                               0x0058
#define regRCC_EP_DEV0_0_EP_PCIE_ERR_CNTL_BASE_IDX                                                      2
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL                                                                0x0059
#define regRCC_EP_DEV0_0_EP_PCIE_RX_CNTL_BASE_IDX                                                       2
#define regRCC_EP_DEV0_0_EP_PCIE_LC_SPEED_CNTL                                                          0x005a
#define regRCC_EP_DEV0_0_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 2


// addressBlock: nbif_bif_bx_BIFDEC1
// base address: 0x0
#define regBIF_BX0_CC_BIF_BX_STRAP0                                                                     0x00e2
#define regBIF_BX0_CC_BIF_BX_STRAP0_BASE_IDX                                                            2
#define regBIF_BX0_CC_BIF_BX_PINSTRAP0                                                                  0x00e4
#define regBIF_BX0_CC_BIF_BX_PINSTRAP0_BASE_IDX                                                         2
#define regBIF_BX0_BIF_MM_INDACCESS_CNTL                                                                0x00e6
#define regBIF_BX0_BIF_MM_INDACCESS_CNTL_BASE_IDX                                                       2
#define regBIF_BX0_BUS_CNTL                                                                             0x00e7
#define regBIF_BX0_BUS_CNTL_BASE_IDX                                                                    2
#define regBIF_BX0_BIF_SCRATCH0                                                                         0x00e8
#define regBIF_BX0_BIF_SCRATCH0_BASE_IDX                                                                2
#define regBIF_BX0_BIF_SCRATCH1                                                                         0x00e9
#define regBIF_BX0_BIF_SCRATCH1_BASE_IDX                                                                2
#define regBIF_BX0_BX_RESET_EN                                                                          0x00ed
#define regBIF_BX0_BX_RESET_EN_BASE_IDX                                                                 2
#define regBIF_BX0_MM_CFGREGS_CNTL                                                                      0x00ee
#define regBIF_BX0_MM_CFGREGS_CNTL_BASE_IDX                                                             2
#define regBIF_BX0_BX_RESET_CNTL                                                                        0x00f0
#define regBIF_BX0_BX_RESET_CNTL_BASE_IDX                                                               2
#define regBIF_BX0_INTERRUPT_CNTL                                                                       0x00f1
#define regBIF_BX0_INTERRUPT_CNTL_BASE_IDX                                                              2
#define regBIF_BX0_INTERRUPT_CNTL2                                                                      0x00f2
#define regBIF_BX0_INTERRUPT_CNTL2_BASE_IDX                                                             2
#define regBIF_BX0_CLKREQB_PAD_CNTL                                                                     0x00f8
#define regBIF_BX0_CLKREQB_PAD_CNTL_BASE_IDX                                                            2
#define regBIF_BX0_BIF_FEATURES_CONTROL_MISC                                                            0x00fb
#define regBIF_BX0_BIF_FEATURES_CONTROL_MISC_BASE_IDX                                                   2
#define regBIF_BX0_HDP_ATOMIC_CONTROL_MISC                                                              0x00fc
#define regBIF_BX0_HDP_ATOMIC_CONTROL_MISC_BASE_IDX                                                     2
#define regBIF_BX0_BIF_DOORBELL_CNTL                                                                    0x00fd
#define regBIF_BX0_BIF_DOORBELL_CNTL_BASE_IDX                                                           2
#define regBIF_BX0_BIF_DOORBELL_INT_CNTL                                                                0x00fe
#define regBIF_BX0_BIF_DOORBELL_INT_CNTL_BASE_IDX                                                       2
#define regBIF_BX0_BIF_FB_EN                                                                            0x0100
#define regBIF_BX0_BIF_FB_EN_BASE_IDX                                                                   2
#define regBIF_BX0_BIF_INTR_CNTL                                                                        0x0101
#define regBIF_BX0_BIF_INTR_CNTL_BASE_IDX                                                               2
#define regBIF_BX0_BIF_MST_TRANS_PENDING_VF                                                             0x0109
#define regBIF_BX0_BIF_MST_TRANS_PENDING_VF_BASE_IDX                                                    2
#define regBIF_BX0_BIF_SLV_TRANS_PENDING_VF                                                             0x010a
#define regBIF_BX0_BIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                    2
#define regBIF_BX0_BACO_CNTL                                                                            0x010b
#define regBIF_BX0_BACO_CNTL_BASE_IDX                                                                   2
#define regBIF_BX0_BIF_BACO_EXIT_TIME0                                                                  0x010c
#define regBIF_BX0_BIF_BACO_EXIT_TIME0_BASE_IDX                                                         2
#define regBIF_BX0_BIF_BACO_EXIT_TIMER1                                                                 0x010d
#define regBIF_BX0_BIF_BACO_EXIT_TIMER1_BASE_IDX                                                        2
#define regBIF_BX0_BIF_BACO_EXIT_TIMER2                                                                 0x010e
#define regBIF_BX0_BIF_BACO_EXIT_TIMER2_BASE_IDX                                                        2
#define regBIF_BX0_BIF_BACO_EXIT_TIMER3                                                                 0x010f
#define regBIF_BX0_BIF_BACO_EXIT_TIMER3_BASE_IDX                                                        2
#define regBIF_BX0_BIF_BACO_EXIT_TIMER4                                                                 0x0110
#define regBIF_BX0_BIF_BACO_EXIT_TIMER4_BASE_IDX                                                        2
#define regBIF_BX0_MEM_TYPE_CNTL                                                                        0x0111
#define regBIF_BX0_MEM_TYPE_CNTL_BASE_IDX                                                               2
#define regBIF_BX0_REMAP_HDP_MEM_FLUSH_CNTL                                                             0x012d
#define regBIF_BX0_REMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                    2
#define regBIF_BX0_REMAP_HDP_REG_FLUSH_CNTL                                                             0x012e
#define regBIF_BX0_REMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                    2
#define regBIF_BX0_BIF_RB_CNTL                                                                          0x012f
#define regBIF_BX0_BIF_RB_CNTL_BASE_IDX                                                                 2
#define regBIF_BX0_BIF_RB_BASE                                                                          0x0130
#define regBIF_BX0_BIF_RB_BASE_BASE_IDX                                                                 2
#define regBIF_BX0_BIF_RB_RPTR                                                                          0x0131
#define regBIF_BX0_BIF_RB_RPTR_BASE_IDX                                                                 2
#define regBIF_BX0_BIF_RB_WPTR                                                                          0x0132
#define regBIF_BX0_BIF_RB_WPTR_BASE_IDX                                                                 2
#define regBIF_BX0_BIF_RB_WPTR_ADDR_HI                                                                  0x0133
#define regBIF_BX0_BIF_RB_WPTR_ADDR_HI_BASE_IDX                                                         2
#define regBIF_BX0_BIF_RB_WPTR_ADDR_LO                                                                  0x0134
#define regBIF_BX0_BIF_RB_WPTR_ADDR_LO_BASE_IDX                                                         2
#define regBIF_BX0_MAILBOX_INDEX                                                                        0x0135
#define regBIF_BX0_MAILBOX_INDEX_BASE_IDX                                                               2
#define regBIF_BX0_BIF_MP1_INTR_CTRL                                                                    0x0142
#define regBIF_BX0_BIF_MP1_INTR_CTRL_BASE_IDX                                                           2
#define regBIF_BX0_BIF_PERSTB_PAD_CNTL                                                                  0x0145
#define regBIF_BX0_BIF_PERSTB_PAD_CNTL_BASE_IDX                                                         2
#define regBIF_BX0_BIF_PX_EN_PAD_CNTL                                                                   0x0146
#define regBIF_BX0_BIF_PX_EN_PAD_CNTL_BASE_IDX                                                          2
#define regBIF_BX0_BIF_REFPADKIN_PAD_CNTL                                                               0x0147
#define regBIF_BX0_BIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                      2
#define regBIF_BX0_BIF_CLKREQB_PAD_CNTL                                                                 0x0148
#define regBIF_BX0_BIF_CLKREQB_PAD_CNTL_BASE_IDX                                                        2
#define regBIF_BX0_BIF_PWRBRK_PAD_CNTL                                                                  0x0149
#define regBIF_BX0_BIF_PWRBRK_PAD_CNTL_BASE_IDX                                                         2


// addressBlock: nbif_rcc_dev0_BIFDEC1
// base address: 0x0
#define regRCC_DEV0_0_RCC_ERR_INT_CNTL                                                                  0x0086
#define regRCC_DEV0_0_RCC_ERR_INT_CNTL_BASE_IDX                                                         2
#define regRCC_DEV0_0_RCC_BACO_CNTL_MISC                                                                0x0087
#define regRCC_DEV0_0_RCC_BACO_CNTL_MISC_BASE_IDX                                                       2
#define regRCC_DEV0_0_RCC_RESET_EN                                                                      0x0088
#define regRCC_DEV0_0_RCC_RESET_EN_BASE_IDX                                                             2
#define regRCC_DEV0_0_RCC_VDM_SUPPORT                                                                   0x0089
#define regRCC_DEV0_0_RCC_VDM_SUPPORT_BASE_IDX                                                          2
#define regRCC_DEV0_0_RCC_MARGIN_PARAM_CNTL0                                                            0x008a
#define regRCC_DEV0_0_RCC_MARGIN_PARAM_CNTL0_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_MARGIN_PARAM_CNTL1                                                            0x008b
#define regRCC_DEV0_0_RCC_MARGIN_PARAM_CNTL1_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_GPUIOV_REGION                                                                 0x008c
#define regRCC_DEV0_0_RCC_GPUIOV_REGION_BASE_IDX                                                        2
#define regRCC_DEV0_0_RCC_GPU_HOSTVM_EN                                                                 0x008d
#define regRCC_DEV0_0_RCC_GPU_HOSTVM_EN_BASE_IDX                                                        2
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_MODE_CNTL                                                         0x008e
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_MODE_CNTL_BASE_IDX                                                2
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_FIRST_VF_OFFSET                                                   0x008f
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_FIRST_VF_OFFSET_BASE_IDX                                          2
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_VF_STRIDE                                                         0x008f
#define regRCC_DEV0_0_RCC_CONSOLE_IOV_VF_STRIDE_BASE_IDX                                                2
#define regRCC_DEV0_0_RCC_PEER_REG_RANGE0                                                               0x00be
#define regRCC_DEV0_0_RCC_PEER_REG_RANGE0_BASE_IDX                                                      2
#define regRCC_DEV0_0_RCC_PEER_REG_RANGE1                                                               0x00bf
#define regRCC_DEV0_0_RCC_PEER_REG_RANGE1_BASE_IDX                                                      2
#define regRCC_DEV0_0_RCC_BUS_CNTL                                                                      0x00c1
#define regRCC_DEV0_0_RCC_BUS_CNTL_BASE_IDX                                                             2
#define regRCC_DEV0_0_RCC_CONFIG_CNTL                                                                   0x00c2
#define regRCC_DEV0_0_RCC_CONFIG_CNTL_BASE_IDX                                                          2
#define regRCC_DEV0_0_RCC_CONFIG_F0_BASE                                                                0x00c6
#define regRCC_DEV0_0_RCC_CONFIG_F0_BASE_BASE_IDX                                                       2
#define regRCC_DEV0_0_RCC_CONFIG_APER_SIZE                                                              0x00c7
#define regRCC_DEV0_0_RCC_CONFIG_APER_SIZE_BASE_IDX                                                     2
#define regRCC_DEV0_0_RCC_CONFIG_REG_APER_SIZE                                                          0x00c8
#define regRCC_DEV0_0_RCC_CONFIG_REG_APER_SIZE_BASE_IDX                                                 2
#define regRCC_DEV0_0_RCC_XDMA_LO                                                                       0x00c9
#define regRCC_DEV0_0_RCC_XDMA_LO_BASE_IDX                                                              2
#define regRCC_DEV0_0_RCC_XDMA_HI                                                                       0x00ca
#define regRCC_DEV0_0_RCC_XDMA_HI_BASE_IDX                                                              2
#define regRCC_DEV0_0_RCC_FEATURES_CONTROL_MISC                                                         0x00cb
#define regRCC_DEV0_0_RCC_FEATURES_CONTROL_MISC_BASE_IDX                                                2
#define regRCC_DEV0_0_RCC_BUSNUM_CNTL1                                                                  0x00cc
#define regRCC_DEV0_0_RCC_BUSNUM_CNTL1_BASE_IDX                                                         2
#define regRCC_DEV0_0_RCC_BUSNUM_LIST0                                                                  0x00cd
#define regRCC_DEV0_0_RCC_BUSNUM_LIST0_BASE_IDX                                                         2
#define regRCC_DEV0_0_RCC_BUSNUM_LIST1                                                                  0x00ce
#define regRCC_DEV0_0_RCC_BUSNUM_LIST1_BASE_IDX                                                         2
#define regRCC_DEV0_0_RCC_BUSNUM_CNTL2                                                                  0x00cf
#define regRCC_DEV0_0_RCC_BUSNUM_CNTL2_BASE_IDX                                                         2
#define regRCC_DEV0_0_RCC_CAPTURE_HOST_BUSNUM                                                           0x00d0
#define regRCC_DEV0_0_RCC_CAPTURE_HOST_BUSNUM_BASE_IDX                                                  2
#define regRCC_DEV0_0_RCC_HOST_BUSNUM                                                                   0x00d1
#define regRCC_DEV0_0_RCC_HOST_BUSNUM_BASE_IDX                                                          2
#define regRCC_DEV0_0_RCC_PEER0_FB_OFFSET_HI                                                            0x00d2
#define regRCC_DEV0_0_RCC_PEER0_FB_OFFSET_HI_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER0_FB_OFFSET_LO                                                            0x00d3
#define regRCC_DEV0_0_RCC_PEER0_FB_OFFSET_LO_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER1_FB_OFFSET_HI                                                            0x00d4
#define regRCC_DEV0_0_RCC_PEER1_FB_OFFSET_HI_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER1_FB_OFFSET_LO                                                            0x00d5
#define regRCC_DEV0_0_RCC_PEER1_FB_OFFSET_LO_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER2_FB_OFFSET_HI                                                            0x00d6
#define regRCC_DEV0_0_RCC_PEER2_FB_OFFSET_HI_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER2_FB_OFFSET_LO                                                            0x00d7
#define regRCC_DEV0_0_RCC_PEER2_FB_OFFSET_LO_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER3_FB_OFFSET_HI                                                            0x00d8
#define regRCC_DEV0_0_RCC_PEER3_FB_OFFSET_HI_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_PEER3_FB_OFFSET_LO                                                            0x00d9
#define regRCC_DEV0_0_RCC_PEER3_FB_OFFSET_LO_BASE_IDX                                                   2
#define regRCC_DEV0_0_RCC_DEVFUNCNUM_LIST0                                                              0x00da
#define regRCC_DEV0_0_RCC_DEVFUNCNUM_LIST0_BASE_IDX                                                     2
#define regRCC_DEV0_0_RCC_DEVFUNCNUM_LIST1                                                              0x00db
#define regRCC_DEV0_0_RCC_DEVFUNCNUM_LIST1_BASE_IDX                                                     2
#define regRCC_DEV0_0_RCC_DEV0_LINK_CNTL                                                                0x00dd
#define regRCC_DEV0_0_RCC_DEV0_LINK_CNTL_BASE_IDX                                                       2
#define regRCC_DEV0_0_RCC_CMN_LINK_CNTL                                                                 0x00de
#define regRCC_DEV0_0_RCC_CMN_LINK_CNTL_BASE_IDX                                                        2
#define regRCC_DEV0_0_RCC_EP_REQUESTERID_RESTORE                                                        0x00df
#define regRCC_DEV0_0_RCC_EP_REQUESTERID_RESTORE_BASE_IDX                                               2
#define regRCC_DEV0_0_RCC_LTR_LSWITCH_CNTL                                                              0x00e0
#define regRCC_DEV0_0_RCC_LTR_LSWITCH_CNTL_BASE_IDX                                                     2
#define regRCC_DEV0_0_RCC_MH_ARB_CNTL                                                                   0x00e1
#define regRCC_DEV0_0_RCC_MH_ARB_CNTL_BASE_IDX                                                          2


// addressBlock: nbif_rcc_dev0_epf0_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_ADDR_LO                                                          0x0400
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_ADDR_HI                                                          0x0401
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_MSG_DATA                                                         0x0402
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                                3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_CONTROL                                                          0x0403
#define regRCC_DEV0_EPF0_GFXMSIX_VECT0_CONTROL_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_ADDR_LO                                                          0x0404
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_ADDR_HI                                                          0x0405
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_MSG_DATA                                                         0x0406
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                                3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_CONTROL                                                          0x0407
#define regRCC_DEV0_EPF0_GFXMSIX_VECT1_CONTROL_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_ADDR_LO                                                          0x0408
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_ADDR_HI                                                          0x0409
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_MSG_DATA                                                         0x040a
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                                3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_CONTROL                                                          0x040b
#define regRCC_DEV0_EPF0_GFXMSIX_VECT2_CONTROL_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_ADDR_LO                                                          0x040c
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_ADDR_HI                                                          0x040d
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_MSG_DATA                                                         0x040e
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                                3
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_CONTROL                                                          0x040f
#define regRCC_DEV0_EPF0_GFXMSIX_VECT3_CONTROL_BASE_IDX                                                 3
#define regRCC_DEV0_EPF0_GFXMSIX_PBA                                                                    0x0800
#define regRCC_DEV0_EPF0_GFXMSIX_PBA_BASE_IDX                                                           3


// addressBlock: nbif_rcc_strap_BIFDEC1
// base address: 0x0
#define regRCC_STRAP0_RCC_BIF_STRAP0                                                                    0x0000
#define regRCC_STRAP0_RCC_BIF_STRAP0_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP1                                                                    0x0001
#define regRCC_STRAP0_RCC_BIF_STRAP1_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP2                                                                    0x0005
#define regRCC_STRAP0_RCC_BIF_STRAP2_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP3                                                                    0x0006
#define regRCC_STRAP0_RCC_BIF_STRAP3_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP4                                                                    0x0007
#define regRCC_STRAP0_RCC_BIF_STRAP4_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP5                                                                    0x0008
#define regRCC_STRAP0_RCC_BIF_STRAP5_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_BIF_STRAP6                                                                    0x0009
#define regRCC_STRAP0_RCC_BIF_STRAP6_BASE_IDX                                                           2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP0                                                              0x000d
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP0_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP1                                                              0x000e
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP1_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP10                                                             0x000f
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP10_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP11                                                             0x0010
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP11_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP12                                                             0x0011
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP12_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP13                                                             0x0012
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP13_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP14                                                             0x0013
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP14_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP2                                                              0x0014
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP2_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP3                                                              0x0015
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP3_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP4                                                              0x0016
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP4_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP5                                                              0x0017
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP5_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP6                                                              0x0018
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP6_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP7                                                              0x0019
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP7_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP8                                                              0x001a
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP8_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP9                                                              0x001b
#define regRCC_STRAP0_RCC_DEV0_PORT_STRAP9_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP0                                                              0x001c
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP1                                                              0x001d
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP1_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP13                                                             0x001e
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP13_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP14                                                             0x001f
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP14_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP15                                                             0x0020
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP15_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP16                                                             0x0021
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP16_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP17                                                             0x0022
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP17_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP18                                                             0x0023
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP18_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP2                                                              0x0024
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP2_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP3                                                              0x0026
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP3_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP4                                                              0x0027
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP4_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP5                                                              0x0028
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP5_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP8                                                              0x0029
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP8_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP9                                                              0x002a
#define regRCC_STRAP0_RCC_DEV0_EPF0_STRAP9_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP0                                                              0x002b
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP0_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP2                                                              0x0036
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP2_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP20                                                             0x0037
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP20_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP21                                                             0x0038
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP21_BASE_IDX                                                    2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP3                                                              0x0039
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP3_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP4                                                              0x003a
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP4_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP5                                                              0x003b
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP5_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP6                                                              0x003c
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP6_BASE_IDX                                                     2
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP7                                                              0x003d
#define regRCC_STRAP0_RCC_DEV0_EPF1_STRAP7_BASE_IDX                                                     2


// addressBlock: nbif_bif_bx_pf_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_PF0_BIF_BME_STATUS                                                                    0x00eb
#define regBIF_BX_PF0_BIF_BME_STATUS_BASE_IDX                                                           2
#define regBIF_BX_PF0_BIF_ATOMIC_ERR_LOG                                                                0x00ec
#define regBIF_BX_PF0_BIF_ATOMIC_ERR_LOG_BASE_IDX                                                       2
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x00f3
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     2
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x00f4
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      2
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x00f5
#define regBIF_BX_PF0_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          2
#define regBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x00f6
#define regBIF_BX_PF0_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x00f7
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             2
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                                 0x00f9
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                                        2
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                            0x00fa
#define regBIF_BX_PF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                                   2
#define regBIF_BX_PF0_GPU_HDP_FLUSH_REQ                                                                 0x0106
#define regBIF_BX_PF0_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        2
#define regBIF_BX_PF0_GPU_HDP_FLUSH_DONE                                                                0x0107
#define regBIF_BX_PF0_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       2
#define regBIF_BX_PF0_BIF_TRANS_PENDING                                                                 0x0108
#define regBIF_BX_PF0_BIF_TRANS_PENDING_BASE_IDX                                                        2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0                                                            0x0136
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1                                                            0x0137
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2                                                            0x0138
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3                                                            0x0139
#define regBIF_BX_PF0_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0                                                            0x013a
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1                                                            0x013b
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2                                                            0x013c
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3                                                            0x013d
#define regBIF_BX_PF0_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   2
#define regBIF_BX_PF0_MAILBOX_CONTROL                                                                   0x013e
#define regBIF_BX_PF0_MAILBOX_CONTROL_BASE_IDX                                                          2
#define regBIF_BX_PF0_MAILBOX_INT_CNTL                                                                  0x013f
#define regBIF_BX_PF0_MAILBOX_INT_CNTL_BASE_IDX                                                         2
#define regBIF_BX_PF0_BIF_VMHV_MAILBOX                                                                  0x0140
#define regBIF_BX_PF0_BIF_VMHV_MAILBOX_BASE_IDX                                                         2


// addressBlock: nbif_rcc_dev0_epf0_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_RCC_ERR_LOG                                                                    0x0085
#define regRCC_DEV0_EPF0_RCC_ERR_LOG_BASE_IDX                                                           2
#define regRCC_DEV0_EPF0_RCC_DOORBELL_APER_EN                                                           0x00c0
#define regRCC_DEV0_EPF0_RCC_DOORBELL_APER_EN_BASE_IDX                                                  2
#define regRCC_DEV0_EPF0_RCC_CONFIG_MEMSIZE                                                             0x00c3
#define regRCC_DEV0_EPF0_RCC_CONFIG_MEMSIZE_BASE_IDX                                                    2
#define regRCC_DEV0_EPF0_RCC_CONFIG_RESERVED                                                            0x00c4
#define regRCC_DEV0_EPF0_RCC_CONFIG_RESERVED_BASE_IDX                                                   2
#define regRCC_DEV0_EPF0_RCC_IOV_FUNC_IDENTIFIER                                                        0x00c5
#define regRCC_DEV0_EPF0_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                               2


// addressBlock: nbif_gdc_GDCDEC
// base address: 0x0
#define regGDC0_SHUB_REGS_IF_CTL                                                                        0x0181
#define regGDC0_SHUB_REGS_IF_CTL_BASE_IDX                                                               2
#define regGDC0_A2S_QUEUE_FIFO_ARB_CNTL                                                                 0x0182
#define regGDC0_A2S_QUEUE_FIFO_ARB_CNTL_BASE_IDX                                                        2
#define regGDC0_NGDC_MGCG_CTRL                                                                          0x0187
#define regGDC0_NGDC_MGCG_CTRL_BASE_IDX                                                                 2
#define regGDC0_S2A_MISC_CNTL                                                                           0x0188
#define regGDC0_S2A_MISC_CNTL_BASE_IDX                                                                  2
#define regGDC0_NGDC_PG_MISC_CTRL                                                                       0x0190
#define regGDC0_NGDC_PG_MISC_CTRL_BASE_IDX                                                              2
#define regGDC0_NGDC_PGMST_CTRL                                                                         0x0191
#define regGDC0_NGDC_PGMST_CTRL_BASE_IDX                                                                2
#define regGDC0_NGDC_PGSLV_CTRL                                                                         0x0192
#define regGDC0_NGDC_PGSLV_CTRL_BASE_IDX                                                                2
#define regGDC0_ATDMA_MISC_CNTL                                                                         0x01e1
#define regGDC0_ATDMA_MISC_CNTL_BASE_IDX                                                                2


// addressBlock: nbif_gdc_s2a_GDCS2A_DEC
// base address: 0x0
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_0_CTRL                                                           0x01cb
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_0_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_1_CTRL                                                           0x01cc
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_1_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_2_CTRL                                                           0x01cd
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_2_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_3_CTRL                                                           0x01ce
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_3_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_4_CTRL                                                           0x01cf
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_4_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_5_CTRL                                                           0x01d0
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_5_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_6_CTRL                                                           0x01d1
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_6_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_7_CTRL                                                           0x01d2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_7_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_8_CTRL                                                           0x01d3
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_8_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_9_CTRL                                                           0x01d4
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_9_CTRL_BASE_IDX                                                  2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_10_CTRL                                                          0x01d5
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_10_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_11_CTRL                                                          0x01d6
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_11_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_12_CTRL                                                          0x01d7
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_12_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_13_CTRL                                                          0x01d8
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_13_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_14_CTRL                                                          0x01d9
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_14_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_15_CTRL                                                          0x01da
#define regGDC_S2A0_S2A_DOORBELL_ENTRY_15_CTRL_BASE_IDX                                                 2
#define regGDC_S2A0_S2A_DOORBELL_COMMON_CTRL_REG                                                        0x01db
#define regGDC_S2A0_S2A_DOORBELL_COMMON_CTRL_REG_BASE_IDX                                               2
#define regGDC_S2A0_NBIF_GFX_DOORBELL_STATUS                                                            0x01dc
#define regGDC_S2A0_NBIF_GFX_DOORBELL_STATUS_BASE_IDX                                                   2


// addressBlock: nbif_bif_cfg_dev0_rc_bifcfgdecp
// base address: 0x10100000
#define regIRQ_BRIDGE_CNTL                                                                              0x000f
#define regIRQ_BRIDGE_CNTL_BASE_IDX                                                                     5


// addressBlock: nbif_bif_cfg_dev0_epf0_bifcfgdecp
// base address: 0x10140000
#define regBIF_CFG_DEV0_EPF0_VENDOR_ID                                                                  0x10000
#define regBIF_CFG_DEV0_EPF0_VENDOR_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_DEVICE_ID                                                                  0x10000
#define regBIF_CFG_DEV0_EPF0_DEVICE_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_COMMAND                                                                    0x10001
#define regBIF_CFG_DEV0_EPF0_COMMAND_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF0_STATUS                                                                     0x10001
#define regBIF_CFG_DEV0_EPF0_STATUS_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF0_REVISION_ID                                                                0x10002
#define regBIF_CFG_DEV0_EPF0_REVISION_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_PROG_INTERFACE                                                             0x10002
#define regBIF_CFG_DEV0_EPF0_PROG_INTERFACE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_SUB_CLASS                                                                  0x10002
#define regBIF_CFG_DEV0_EPF0_SUB_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_BASE_CLASS                                                                 0x10002
#define regBIF_CFG_DEV0_EPF0_BASE_CLASS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_CACHE_LINE                                                                 0x10003
#define regBIF_CFG_DEV0_EPF0_CACHE_LINE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_LATENCY                                                                    0x10003
#define regBIF_CFG_DEV0_EPF0_LATENCY_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF0_HEADER                                                                     0x10003
#define regBIF_CFG_DEV0_EPF0_HEADER_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF0_BIST                                                                       0x10003
#define regBIF_CFG_DEV0_EPF0_BIST_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_1                                                                0x10004
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_2                                                                0x10005
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_3                                                                0x10006
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_3_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_4                                                                0x10007
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_4_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_5                                                                0x10008
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_5_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_6                                                                0x10009
#define regBIF_CFG_DEV0_EPF0_BASE_ADDR_6_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_CARDBUS_CIS_PTR                                                            0x1000a
#define regBIF_CFG_DEV0_EPF0_CARDBUS_CIS_PTR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_ADAPTER_ID                                                                 0x1000b
#define regBIF_CFG_DEV0_EPF0_ADAPTER_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_ROM_BASE_ADDR                                                              0x1000c
#define regBIF_CFG_DEV0_EPF0_ROM_BASE_ADDR_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_CAP_PTR                                                                    0x1000d
#define regBIF_CFG_DEV0_EPF0_CAP_PTR_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF0_INTERRUPT_LINE                                                             0x1000f
#define regBIF_CFG_DEV0_EPF0_INTERRUPT_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_INTERRUPT_PIN                                                              0x1000f
#define regBIF_CFG_DEV0_EPF0_INTERRUPT_PIN_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_MIN_GRANT                                                                  0x1000f
#define regBIF_CFG_DEV0_EPF0_MIN_GRANT_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_MAX_LATENCY                                                                0x1000f
#define regBIF_CFG_DEV0_EPF0_MAX_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST                                                            0x10012
#define regBIF_CFG_DEV0_EPF0_VENDOR_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_ADAPTER_ID_W                                                               0x10013
#define regBIF_CFG_DEV0_EPF0_ADAPTER_ID_W_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PMI_CAP_LIST                                                               0x10014
#define regBIF_CFG_DEV0_EPF0_PMI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PMI_CAP                                                                    0x10014
#define regBIF_CFG_DEV0_EPF0_PMI_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL                                                            0x10015
#define regBIF_CFG_DEV0_EPF0_PMI_STATUS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_PCIE_CAP_LIST                                                              0x10019
#define regBIF_CFG_DEV0_EPF0_PCIE_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_CAP                                                                   0x10019
#define regBIF_CFG_DEV0_EPF0_PCIE_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_DEVICE_CAP                                                                 0x1001a
#define regBIF_CFG_DEV0_EPF0_DEVICE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_DEVICE_CNTL                                                                0x1001b
#define regBIF_CFG_DEV0_EPF0_DEVICE_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_DEVICE_STATUS                                                              0x1001b
#define regBIF_CFG_DEV0_EPF0_DEVICE_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_LINK_CAP                                                                   0x1001c
#define regBIF_CFG_DEV0_EPF0_LINK_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL                                                                  0x1001d
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS                                                                0x1001d
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_DEVICE_CAP2                                                                0x10022
#define regBIF_CFG_DEV0_EPF0_DEVICE_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_DEVICE_CNTL2                                                               0x10023
#define regBIF_CFG_DEV0_EPF0_DEVICE_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_DEVICE_STATUS2                                                             0x10023
#define regBIF_CFG_DEV0_EPF0_DEVICE_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_LINK_CAP2                                                                  0x10024
#define regBIF_CFG_DEV0_EPF0_LINK_CAP2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL2                                                                 0x10025
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS2                                                               0x10025
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_MSI_CAP_LIST                                                               0x10028
#define regBIF_CFG_DEV0_EPF0_MSI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_CNTL                                                               0x10028
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO                                                            0x10029
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_LO_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI                                                            0x1002a
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_ADDR_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_DATA                                                               0x1002a
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_DATA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA                                                           0x1002a
#define regBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_MSI_MASK                                                                   0x1002b
#define regBIF_CFG_DEV0_EPF0_MSI_MASK_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64                                                            0x1002b
#define regBIF_CFG_DEV0_EPF0_MSI_MSG_DATA_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64                                                        0x1002b
#define regBIF_CFG_DEV0_EPF0_MSI_EXT_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_MSI_MASK_64                                                                0x1002c
#define regBIF_CFG_DEV0_EPF0_MSI_MASK_64_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_MSI_PENDING                                                                0x1002c
#define regBIF_CFG_DEV0_EPF0_MSI_PENDING_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_MSI_PENDING_64                                                             0x1002d
#define regBIF_CFG_DEV0_EPF0_MSI_PENDING_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_MSIX_CAP_LIST                                                              0x10030
#define regBIF_CFG_DEV0_EPF0_MSIX_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL                                                              0x10030
#define regBIF_CFG_DEV0_EPF0_MSIX_MSG_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_MSIX_TABLE                                                                 0x10031
#define regBIF_CFG_DEV0_EPF0_MSIX_TABLE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_MSIX_PBA                                                                   0x10032
#define regBIF_CFG_DEV0_EPF0_MSIX_PBA_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x10040
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR                                                   0x10041
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1                                                      0x10042
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2                                                      0x10043
#define regBIF_CFG_DEV0_EPF0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST                                                       0x10044
#define regBIF_CFG_DEV0_EPF0_PCIE_VC_ENH_CAP_LIST_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1                                                      0x10045
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG1_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2                                                      0x10046
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CAP_REG2_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL                                                          0x10047
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS                                                        0x10047
#define regBIF_CFG_DEV0_EPF0_PCIE_PORT_VC_STATUS_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP                                                      0x10048
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL                                                     0x10049
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_CNTL_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS                                                   0x1004a
#define regBIF_CFG_DEV0_EPF0_PCIE_VC0_RESOURCE_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP                                                      0x1004b
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL                                                     0x1004c
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_CNTL_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS                                                   0x1004d
#define regBIF_CFG_DEV0_EPF0_PCIE_VC1_RESOURCE_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                           0x10050
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1                                                    0x10051
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2                                                    0x10052
#define regBIF_CFG_DEV0_EPF0_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x10054
#define regBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS                                                     0x10055
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK                                                       0x10056
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY                                                   0x10057
#define regBIF_CFG_DEV0_EPF0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS                                                       0x10058
#define regBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK                                                         0x10059
#define regBIF_CFG_DEV0_EPF0_PCIE_CORR_ERR_MASK_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL                                                      0x1005a
#define regBIF_CFG_DEV0_EPF0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0                                                              0x1005b
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG0_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1                                                              0x1005c
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2                                                              0x1005d
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3                                                              0x1005e
#define regBIF_CFG_DEV0_EPF0_PCIE_HDR_LOG3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0                                                       0x10062
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1                                                       0x10063
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2                                                       0x10064
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3                                                       0x10065
#define regBIF_CFG_DEV0_EPF0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST                                                      0x10080
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP                                                              0x10081
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR1_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL                                                             0x10082
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR1_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP                                                              0x10083
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR2_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL                                                             0x10084
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR2_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP                                                              0x10085
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR3_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL                                                             0x10086
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR3_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP                                                              0x10087
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR4_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL                                                             0x10088
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR4_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP                                                              0x10089
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR5_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL                                                             0x1008a
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR5_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP                                                              0x1008b
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR6_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL                                                             0x1008c
#define regBIF_CFG_DEV0_EPF0_PCIE_BAR6_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x10090
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT                                                0x10091
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA                                                       0x10092
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP                                                        0x10093
#define regBIF_CFG_DEV0_EPF0_PCIE_PWR_BUDGET_CAP_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST                                                      0x10094
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_CAP                                                               0x10095
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR                                                 0x10096
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS                                                            0x10097
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL                                                              0x10097
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x10098
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x10098
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x10098
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x10098
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x10099
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x10099
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x10099
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x10099
#define regBIF_CFG_DEV0_EPF0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST                                                0x1009c
#define regBIF_CFG_DEV0_EPF0_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3                                                            0x1009d
#define regBIF_CFG_DEV0_EPF0_PCIE_LINK_CNTL3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS                                                     0x1009e
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_ERROR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL                                              0x1009f
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL                                              0x1009f
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL                                              0x100a0
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL                                              0x100a0
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL                                              0x100a1
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL                                              0x100a1
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL                                              0x100a2
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL                                              0x100a2
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL                                              0x100a3
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL                                              0x100a3
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL                                             0x100a4
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL                                             0x100a4
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL                                             0x100a5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL                                             0x100a5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL                                             0x100a6
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL                                             0x100a6
#define regBIF_CFG_DEV0_EPF0_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST                                                      0x100a8
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_CAP                                                               0x100a9
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL                                                              0x100a9
#define regBIF_CFG_DEV0_EPF0_PCIE_ACS_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST                                                    0x100b4
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_CAP                                                             0x100b5
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL                                                            0x100b5
#define regBIF_CFG_DEV0_EPF0_PCIE_PASID_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST                                                      0x100c8
#define regBIF_CFG_DEV0_EPF0_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_LTR_CAP                                                               0x100c9
#define regBIF_CFG_DEV0_EPF0_PCIE_LTR_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST                                                      0x100ca
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_CAP                                                               0x100cb
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL                                                              0x100cb
#define regBIF_CFG_DEV0_EPF0_PCIE_ARI_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST                                                    0x100cc
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP                                                             0x100cd
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL                                                         0x100ce
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_CONTROL_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_STATUS                                                          0x100ce
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS                                                     0x100cf
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_INITIAL_VFS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS                                                       0x100cf
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_TOTAL_VFS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS                                                         0x100d0
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_NUM_VFS_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK                                                   0x100d0
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FUNC_DEP_LINK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET                                                 0x100d1
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_FIRST_VF_OFFSET_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE                                                       0x100d1
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_STRIDE_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID                                                    0x100d2
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_DEVICE_ID_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                             0x100d3
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                                0x100d4
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_SYSTEM_PAGE_SIZE_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0                                                  0x100d5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_0_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1                                                  0x100d6
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2                                                  0x100d7
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3                                                  0x100d8
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_3_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4                                                  0x100d9
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_4_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5                                                  0x100da
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_BASE_ADDR_5_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                                 0x100db
#define regBIF_CFG_DEV0_EPF0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET_BASE_IDX                        5
#define regBIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST                                                      0x10100
#define regBIF_CFG_DEV0_EPF0_PCIE_DLF_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP                                                      0x10101
#define regBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_CAP_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS                                                   0x10102
#define regBIF_CFG_DEV0_EPF0_DATA_LINK_FEATURE_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST                                                 0x10104
#define regBIF_CFG_DEV0_EPF0_PCIE_PHY_16GT_ENH_CAP_LIST_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LINK_CAP_16GT                                                              0x10105
#define regBIF_CFG_DEV0_EPF0_LINK_CAP_16GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL_16GT                                                             0x10106
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL_16GT_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS_16GT                                                           0x10107
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS_16GT_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT                                          0x10108
#define regBIF_CFG_DEV0_EPF0_LOCAL_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT                                           0x10109
#define regBIF_CFG_DEV0_EPF0_RTM1_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT                                           0x1010a
#define regBIF_CFG_DEV0_EPF0_RTM2_PARITY_MISMATCH_STATUS_16GT_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT                                              0x1010c
#define regBIF_CFG_DEV0_EPF0_LANE_0_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT                                              0x1010c
#define regBIF_CFG_DEV0_EPF0_LANE_1_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT                                              0x1010c
#define regBIF_CFG_DEV0_EPF0_LANE_2_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT                                              0x1010c
#define regBIF_CFG_DEV0_EPF0_LANE_3_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT                                              0x1010d
#define regBIF_CFG_DEV0_EPF0_LANE_4_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT                                              0x1010d
#define regBIF_CFG_DEV0_EPF0_LANE_5_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT                                              0x1010d
#define regBIF_CFG_DEV0_EPF0_LANE_6_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT                                              0x1010d
#define regBIF_CFG_DEV0_EPF0_LANE_7_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT                                              0x1010e
#define regBIF_CFG_DEV0_EPF0_LANE_8_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT                                              0x1010e
#define regBIF_CFG_DEV0_EPF0_LANE_9_EQUALIZATION_CNTL_16GT_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT                                             0x1010e
#define regBIF_CFG_DEV0_EPF0_LANE_10_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT                                             0x1010e
#define regBIF_CFG_DEV0_EPF0_LANE_11_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT                                             0x1010f
#define regBIF_CFG_DEV0_EPF0_LANE_12_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT                                             0x1010f
#define regBIF_CFG_DEV0_EPF0_LANE_13_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT                                             0x1010f
#define regBIF_CFG_DEV0_EPF0_LANE_14_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT                                             0x1010f
#define regBIF_CFG_DEV0_EPF0_LANE_15_EQUALIZATION_CNTL_16GT_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST                                                0x10114
#define regBIF_CFG_DEV0_EPF0_PCIE_MARGINING_ENH_CAP_LIST_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP                                                         0x10115
#define regBIF_CFG_DEV0_EPF0_MARGINING_PORT_CAP_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS                                                      0x10115
#define regBIF_CFG_DEV0_EPF0_MARGINING_PORT_STATUS_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL                                                 0x10116
#define regBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS                                               0x10116
#define regBIF_CFG_DEV0_EPF0_LANE_0_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL                                                 0x10117
#define regBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS                                               0x10117
#define regBIF_CFG_DEV0_EPF0_LANE_1_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL                                                 0x10118
#define regBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS                                               0x10118
#define regBIF_CFG_DEV0_EPF0_LANE_2_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL                                                 0x10119
#define regBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS                                               0x10119
#define regBIF_CFG_DEV0_EPF0_LANE_3_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL                                                 0x1011a
#define regBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS                                               0x1011a
#define regBIF_CFG_DEV0_EPF0_LANE_4_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL                                                 0x1011b
#define regBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS                                               0x1011b
#define regBIF_CFG_DEV0_EPF0_LANE_5_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL                                                 0x1011c
#define regBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS                                               0x1011c
#define regBIF_CFG_DEV0_EPF0_LANE_6_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL                                                 0x1011d
#define regBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS                                               0x1011d
#define regBIF_CFG_DEV0_EPF0_LANE_7_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL                                                 0x1011e
#define regBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS                                               0x1011e
#define regBIF_CFG_DEV0_EPF0_LANE_8_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL                                                 0x1011f
#define regBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_CNTL_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS                                               0x1011f
#define regBIF_CFG_DEV0_EPF0_LANE_9_MARGINING_LANE_STATUS_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL                                                0x10120
#define regBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS                                              0x10120
#define regBIF_CFG_DEV0_EPF0_LANE_10_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL                                                0x10121
#define regBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS                                              0x10121
#define regBIF_CFG_DEV0_EPF0_LANE_11_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL                                                0x10122
#define regBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS                                              0x10122
#define regBIF_CFG_DEV0_EPF0_LANE_12_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL                                                0x10123
#define regBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS                                              0x10123
#define regBIF_CFG_DEV0_EPF0_LANE_13_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL                                                0x10124
#define regBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS                                              0x10124
#define regBIF_CFG_DEV0_EPF0_LANE_14_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL                                                0x10125
#define regBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_CNTL_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS                                              0x10125
#define regBIF_CFG_DEV0_EPF0_LANE_15_MARGINING_LANE_STATUS_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                            0x10130
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP                                                    0x10131
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL                                                   0x10132
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR1_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP                                                    0x10133
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL                                                   0x10134
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR2_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP                                                    0x10135
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL                                                   0x10136
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR3_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP                                                    0x10137
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL                                                   0x10138
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR4_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP                                                    0x10139
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL                                                   0x1013a
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR5_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP                                                    0x1013b
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL                                                   0x1013c
#define regBIF_CFG_DEV0_EPF0_PCIE_VF_RESIZE_BAR6_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_LINK_CAP_32GT                                                              0x10141
#define regBIF_CFG_DEV0_EPF0_LINK_CAP_32GT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL_32GT                                                             0x10142
#define regBIF_CFG_DEV0_EPF0_LINK_CNTL_32GT_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS_32GT                                                           0x10143
#define regBIF_CFG_DEV0_EPF0_LINK_STATUS_32GT_BASE_IDX                                                  5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf0_bifcfgdecp
// base address: 0x10160000
#define regBIF_CFG_DEV0_EPF0_VF0_VENDOR_ID                                                              0x18000
#define regBIF_CFG_DEV0_EPF0_VF0_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_ID                                                              0x18000
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_COMMAND                                                                0x18001
#define regBIF_CFG_DEV0_EPF0_VF0_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF0_STATUS                                                                 0x18001
#define regBIF_CFG_DEV0_EPF0_VF0_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF0_REVISION_ID                                                            0x18002
#define regBIF_CFG_DEV0_EPF0_VF0_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_PROG_INTERFACE                                                         0x18002
#define regBIF_CFG_DEV0_EPF0_VF0_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF0_SUB_CLASS                                                              0x18002
#define regBIF_CFG_DEV0_EPF0_VF0_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_CLASS                                                             0x18002
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_CACHE_LINE                                                             0x18003
#define regBIF_CFG_DEV0_EPF0_VF0_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_LATENCY                                                                0x18003
#define regBIF_CFG_DEV0_EPF0_VF0_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF0_HEADER                                                                 0x18003
#define regBIF_CFG_DEV0_EPF0_VF0_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF0_BIST                                                                   0x18003
#define regBIF_CFG_DEV0_EPF0_VF0_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_1                                                            0x18004
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_2                                                            0x18005
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_3                                                            0x18006
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_4                                                            0x18007
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_5                                                            0x18008
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_6                                                            0x18009
#define regBIF_CFG_DEV0_EPF0_VF0_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_CARDBUS_CIS_PTR                                                        0x1800a
#define regBIF_CFG_DEV0_EPF0_VF0_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF0_ADAPTER_ID                                                             0x1800b
#define regBIF_CFG_DEV0_EPF0_VF0_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_ROM_BASE_ADDR                                                          0x1800c
#define regBIF_CFG_DEV0_EPF0_VF0_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_CAP_PTR                                                                0x1800d
#define regBIF_CFG_DEV0_EPF0_VF0_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_LINE                                                         0x1800f
#define regBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_PIN                                                          0x1800f
#define regBIF_CFG_DEV0_EPF0_VF0_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_MIN_GRANT                                                              0x1800f
#define regBIF_CFG_DEV0_EPF0_VF0_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_MAX_LATENCY                                                            0x1800f
#define regBIF_CFG_DEV0_EPF0_VF0_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP_LIST                                                          0x18019
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP                                                               0x18019
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP                                                             0x1801a
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL                                                            0x1801b
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS                                                          0x1801b
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CAP                                                               0x1801c
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL                                                              0x1801d
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS                                                            0x1801d
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP2                                                            0x18022
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL2                                                           0x18023
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS2                                                         0x18023
#define regBIF_CFG_DEV0_EPF0_VF0_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CAP2                                                              0x18024
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL2                                                             0x18025
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS2                                                           0x18025
#define regBIF_CFG_DEV0_EPF0_VF0_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_CAP_LIST                                                           0x18028
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_CNTL                                                           0x18028
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_LO                                                        0x18029
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_HI                                                        0x1802a
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA                                                           0x1802a
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA                                                       0x1802a
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MASK                                                               0x1802b
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA_64                                                        0x1802b
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA_64                                                    0x1802b
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MASK_64                                                            0x1802c
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING                                                            0x1802c
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING_64                                                         0x1802d
#define regBIF_CFG_DEV0_EPF0_VF0_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_CAP_LIST                                                          0x18030
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_MSG_CNTL                                                          0x18030
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_TABLE                                                             0x18031
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_PBA                                                               0x18032
#define regBIF_CFG_DEV0_EPF0_VF0_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x18040
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_HDR                                               0x18041
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC1                                                  0x18042
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC2                                                  0x18043
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x18054
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_STATUS                                                 0x18055
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_MASK                                                   0x18056
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_SEVERITY                                               0x18057
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_STATUS                                                   0x18058
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_MASK                                                     0x18059
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_CAP_CNTL                                                  0x1805a
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG0                                                          0x1805b
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG1                                                          0x1805c
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG2                                                          0x1805d
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG3                                                          0x1805e
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG0                                                   0x18062
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG1                                                   0x18063
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG2                                                   0x18064
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG3                                                   0x18065
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_ENH_CAP_LIST                                                  0x180ca
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CAP                                                           0x180cb
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CNTL                                                          0x180cb
#define regBIF_CFG_DEV0_EPF0_VF0_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf1_bifcfgdecp
// base address: 0x10161000
#define regBIF_CFG_DEV0_EPF0_VF1_VENDOR_ID                                                              0x18400
#define regBIF_CFG_DEV0_EPF0_VF1_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_ID                                                              0x18400
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_COMMAND                                                                0x18401
#define regBIF_CFG_DEV0_EPF0_VF1_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF1_STATUS                                                                 0x18401
#define regBIF_CFG_DEV0_EPF0_VF1_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF1_REVISION_ID                                                            0x18402
#define regBIF_CFG_DEV0_EPF0_VF1_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_PROG_INTERFACE                                                         0x18402
#define regBIF_CFG_DEV0_EPF0_VF1_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF1_SUB_CLASS                                                              0x18402
#define regBIF_CFG_DEV0_EPF0_VF1_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_CLASS                                                             0x18402
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_CACHE_LINE                                                             0x18403
#define regBIF_CFG_DEV0_EPF0_VF1_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_LATENCY                                                                0x18403
#define regBIF_CFG_DEV0_EPF0_VF1_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF1_HEADER                                                                 0x18403
#define regBIF_CFG_DEV0_EPF0_VF1_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF1_BIST                                                                   0x18403
#define regBIF_CFG_DEV0_EPF0_VF1_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_1                                                            0x18404
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_2                                                            0x18405
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_3                                                            0x18406
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_4                                                            0x18407
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_5                                                            0x18408
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_6                                                            0x18409
#define regBIF_CFG_DEV0_EPF0_VF1_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_CARDBUS_CIS_PTR                                                        0x1840a
#define regBIF_CFG_DEV0_EPF0_VF1_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF1_ADAPTER_ID                                                             0x1840b
#define regBIF_CFG_DEV0_EPF0_VF1_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_ROM_BASE_ADDR                                                          0x1840c
#define regBIF_CFG_DEV0_EPF0_VF1_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_CAP_PTR                                                                0x1840d
#define regBIF_CFG_DEV0_EPF0_VF1_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_LINE                                                         0x1840f
#define regBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_PIN                                                          0x1840f
#define regBIF_CFG_DEV0_EPF0_VF1_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_MIN_GRANT                                                              0x1840f
#define regBIF_CFG_DEV0_EPF0_VF1_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_MAX_LATENCY                                                            0x1840f
#define regBIF_CFG_DEV0_EPF0_VF1_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP_LIST                                                          0x18419
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP                                                               0x18419
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP                                                             0x1841a
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL                                                            0x1841b
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS                                                          0x1841b
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CAP                                                               0x1841c
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL                                                              0x1841d
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS                                                            0x1841d
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP2                                                            0x18422
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL2                                                           0x18423
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS2                                                         0x18423
#define regBIF_CFG_DEV0_EPF0_VF1_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CAP2                                                              0x18424
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL2                                                             0x18425
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS2                                                           0x18425
#define regBIF_CFG_DEV0_EPF0_VF1_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_CAP_LIST                                                           0x18428
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_CNTL                                                           0x18428
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_LO                                                        0x18429
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_HI                                                        0x1842a
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA                                                           0x1842a
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA                                                       0x1842a
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MASK                                                               0x1842b
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA_64                                                        0x1842b
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA_64                                                    0x1842b
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MASK_64                                                            0x1842c
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING                                                            0x1842c
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING_64                                                         0x1842d
#define regBIF_CFG_DEV0_EPF0_VF1_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_CAP_LIST                                                          0x18430
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_MSG_CNTL                                                          0x18430
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_TABLE                                                             0x18431
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_PBA                                                               0x18432
#define regBIF_CFG_DEV0_EPF0_VF1_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x18440
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_HDR                                               0x18441
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC1                                                  0x18442
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC2                                                  0x18443
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x18454
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_STATUS                                                 0x18455
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_MASK                                                   0x18456
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_SEVERITY                                               0x18457
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_STATUS                                                   0x18458
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_MASK                                                     0x18459
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_CAP_CNTL                                                  0x1845a
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG0                                                          0x1845b
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG1                                                          0x1845c
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG2                                                          0x1845d
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG3                                                          0x1845e
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG0                                                   0x18462
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG1                                                   0x18463
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG2                                                   0x18464
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG3                                                   0x18465
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_ENH_CAP_LIST                                                  0x184ca
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CAP                                                           0x184cb
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CNTL                                                          0x184cb
#define regBIF_CFG_DEV0_EPF0_VF1_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf2_bifcfgdecp
// base address: 0x10162000
#define regBIF_CFG_DEV0_EPF0_VF2_VENDOR_ID                                                              0x18800
#define regBIF_CFG_DEV0_EPF0_VF2_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_ID                                                              0x18800
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_COMMAND                                                                0x18801
#define regBIF_CFG_DEV0_EPF0_VF2_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF2_STATUS                                                                 0x18801
#define regBIF_CFG_DEV0_EPF0_VF2_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF2_REVISION_ID                                                            0x18802
#define regBIF_CFG_DEV0_EPF0_VF2_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_PROG_INTERFACE                                                         0x18802
#define regBIF_CFG_DEV0_EPF0_VF2_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF2_SUB_CLASS                                                              0x18802
#define regBIF_CFG_DEV0_EPF0_VF2_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_CLASS                                                             0x18802
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_CACHE_LINE                                                             0x18803
#define regBIF_CFG_DEV0_EPF0_VF2_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_LATENCY                                                                0x18803
#define regBIF_CFG_DEV0_EPF0_VF2_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF2_HEADER                                                                 0x18803
#define regBIF_CFG_DEV0_EPF0_VF2_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF2_BIST                                                                   0x18803
#define regBIF_CFG_DEV0_EPF0_VF2_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_1                                                            0x18804
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_2                                                            0x18805
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_3                                                            0x18806
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_4                                                            0x18807
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_5                                                            0x18808
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_6                                                            0x18809
#define regBIF_CFG_DEV0_EPF0_VF2_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_CARDBUS_CIS_PTR                                                        0x1880a
#define regBIF_CFG_DEV0_EPF0_VF2_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF2_ADAPTER_ID                                                             0x1880b
#define regBIF_CFG_DEV0_EPF0_VF2_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_ROM_BASE_ADDR                                                          0x1880c
#define regBIF_CFG_DEV0_EPF0_VF2_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_CAP_PTR                                                                0x1880d
#define regBIF_CFG_DEV0_EPF0_VF2_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_LINE                                                         0x1880f
#define regBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_PIN                                                          0x1880f
#define regBIF_CFG_DEV0_EPF0_VF2_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_MIN_GRANT                                                              0x1880f
#define regBIF_CFG_DEV0_EPF0_VF2_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_MAX_LATENCY                                                            0x1880f
#define regBIF_CFG_DEV0_EPF0_VF2_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP_LIST                                                          0x18819
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP                                                               0x18819
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP                                                             0x1881a
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL                                                            0x1881b
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS                                                          0x1881b
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CAP                                                               0x1881c
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL                                                              0x1881d
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS                                                            0x1881d
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP2                                                            0x18822
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL2                                                           0x18823
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS2                                                         0x18823
#define regBIF_CFG_DEV0_EPF0_VF2_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CAP2                                                              0x18824
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL2                                                             0x18825
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS2                                                           0x18825
#define regBIF_CFG_DEV0_EPF0_VF2_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_CAP_LIST                                                           0x18828
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_CNTL                                                           0x18828
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_LO                                                        0x18829
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_HI                                                        0x1882a
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA                                                           0x1882a
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA                                                       0x1882a
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MASK                                                               0x1882b
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA_64                                                        0x1882b
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA_64                                                    0x1882b
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MASK_64                                                            0x1882c
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING                                                            0x1882c
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING_64                                                         0x1882d
#define regBIF_CFG_DEV0_EPF0_VF2_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_CAP_LIST                                                          0x18830
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_MSG_CNTL                                                          0x18830
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_TABLE                                                             0x18831
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_PBA                                                               0x18832
#define regBIF_CFG_DEV0_EPF0_VF2_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x18840
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_HDR                                               0x18841
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC1                                                  0x18842
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC2                                                  0x18843
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x18854
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_STATUS                                                 0x18855
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_MASK                                                   0x18856
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_SEVERITY                                               0x18857
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_STATUS                                                   0x18858
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_MASK                                                     0x18859
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_CAP_CNTL                                                  0x1885a
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG0                                                          0x1885b
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG1                                                          0x1885c
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG2                                                          0x1885d
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG3                                                          0x1885e
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG0                                                   0x18862
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG1                                                   0x18863
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG2                                                   0x18864
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG3                                                   0x18865
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_ENH_CAP_LIST                                                  0x188ca
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CAP                                                           0x188cb
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CNTL                                                          0x188cb
#define regBIF_CFG_DEV0_EPF0_VF2_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf3_bifcfgdecp
// base address: 0x10163000
#define regBIF_CFG_DEV0_EPF0_VF3_VENDOR_ID                                                              0x18c00
#define regBIF_CFG_DEV0_EPF0_VF3_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_ID                                                              0x18c00
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_COMMAND                                                                0x18c01
#define regBIF_CFG_DEV0_EPF0_VF3_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF3_STATUS                                                                 0x18c01
#define regBIF_CFG_DEV0_EPF0_VF3_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF3_REVISION_ID                                                            0x18c02
#define regBIF_CFG_DEV0_EPF0_VF3_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_PROG_INTERFACE                                                         0x18c02
#define regBIF_CFG_DEV0_EPF0_VF3_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF3_SUB_CLASS                                                              0x18c02
#define regBIF_CFG_DEV0_EPF0_VF3_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_CLASS                                                             0x18c02
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_CACHE_LINE                                                             0x18c03
#define regBIF_CFG_DEV0_EPF0_VF3_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_LATENCY                                                                0x18c03
#define regBIF_CFG_DEV0_EPF0_VF3_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF3_HEADER                                                                 0x18c03
#define regBIF_CFG_DEV0_EPF0_VF3_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF3_BIST                                                                   0x18c03
#define regBIF_CFG_DEV0_EPF0_VF3_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_1                                                            0x18c04
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_2                                                            0x18c05
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_3                                                            0x18c06
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_4                                                            0x18c07
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_5                                                            0x18c08
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_6                                                            0x18c09
#define regBIF_CFG_DEV0_EPF0_VF3_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_CARDBUS_CIS_PTR                                                        0x18c0a
#define regBIF_CFG_DEV0_EPF0_VF3_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF3_ADAPTER_ID                                                             0x18c0b
#define regBIF_CFG_DEV0_EPF0_VF3_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_ROM_BASE_ADDR                                                          0x18c0c
#define regBIF_CFG_DEV0_EPF0_VF3_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_CAP_PTR                                                                0x18c0d
#define regBIF_CFG_DEV0_EPF0_VF3_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_LINE                                                         0x18c0f
#define regBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_PIN                                                          0x18c0f
#define regBIF_CFG_DEV0_EPF0_VF3_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_MIN_GRANT                                                              0x18c0f
#define regBIF_CFG_DEV0_EPF0_VF3_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_MAX_LATENCY                                                            0x18c0f
#define regBIF_CFG_DEV0_EPF0_VF3_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP_LIST                                                          0x18c19
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP                                                               0x18c19
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP                                                             0x18c1a
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL                                                            0x18c1b
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS                                                          0x18c1b
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CAP                                                               0x18c1c
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL                                                              0x18c1d
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS                                                            0x18c1d
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP2                                                            0x18c22
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL2                                                           0x18c23
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS2                                                         0x18c23
#define regBIF_CFG_DEV0_EPF0_VF3_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CAP2                                                              0x18c24
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL2                                                             0x18c25
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS2                                                           0x18c25
#define regBIF_CFG_DEV0_EPF0_VF3_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_CAP_LIST                                                           0x18c28
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_CNTL                                                           0x18c28
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_LO                                                        0x18c29
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_HI                                                        0x18c2a
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA                                                           0x18c2a
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA                                                       0x18c2a
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MASK                                                               0x18c2b
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA_64                                                        0x18c2b
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA_64                                                    0x18c2b
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MASK_64                                                            0x18c2c
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING                                                            0x18c2c
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING_64                                                         0x18c2d
#define regBIF_CFG_DEV0_EPF0_VF3_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_CAP_LIST                                                          0x18c30
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_MSG_CNTL                                                          0x18c30
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_TABLE                                                             0x18c31
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_PBA                                                               0x18c32
#define regBIF_CFG_DEV0_EPF0_VF3_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x18c40
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_HDR                                               0x18c41
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC1                                                  0x18c42
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC2                                                  0x18c43
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x18c54
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_STATUS                                                 0x18c55
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_MASK                                                   0x18c56
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_SEVERITY                                               0x18c57
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_STATUS                                                   0x18c58
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_MASK                                                     0x18c59
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_CAP_CNTL                                                  0x18c5a
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG0                                                          0x18c5b
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG1                                                          0x18c5c
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG2                                                          0x18c5d
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG3                                                          0x18c5e
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG0                                                   0x18c62
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG1                                                   0x18c63
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG2                                                   0x18c64
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG3                                                   0x18c65
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_ENH_CAP_LIST                                                  0x18cca
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CAP                                                           0x18ccb
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CNTL                                                          0x18ccb
#define regBIF_CFG_DEV0_EPF0_VF3_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf4_bifcfgdecp
// base address: 0x10164000
#define regBIF_CFG_DEV0_EPF0_VF4_VENDOR_ID                                                              0x19000
#define regBIF_CFG_DEV0_EPF0_VF4_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_ID                                                              0x19000
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_COMMAND                                                                0x19001
#define regBIF_CFG_DEV0_EPF0_VF4_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF4_STATUS                                                                 0x19001
#define regBIF_CFG_DEV0_EPF0_VF4_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF4_REVISION_ID                                                            0x19002
#define regBIF_CFG_DEV0_EPF0_VF4_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_PROG_INTERFACE                                                         0x19002
#define regBIF_CFG_DEV0_EPF0_VF4_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF4_SUB_CLASS                                                              0x19002
#define regBIF_CFG_DEV0_EPF0_VF4_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_CLASS                                                             0x19002
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_CACHE_LINE                                                             0x19003
#define regBIF_CFG_DEV0_EPF0_VF4_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_LATENCY                                                                0x19003
#define regBIF_CFG_DEV0_EPF0_VF4_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF4_HEADER                                                                 0x19003
#define regBIF_CFG_DEV0_EPF0_VF4_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF4_BIST                                                                   0x19003
#define regBIF_CFG_DEV0_EPF0_VF4_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_1                                                            0x19004
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_2                                                            0x19005
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_3                                                            0x19006
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_4                                                            0x19007
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_5                                                            0x19008
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_6                                                            0x19009
#define regBIF_CFG_DEV0_EPF0_VF4_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_CARDBUS_CIS_PTR                                                        0x1900a
#define regBIF_CFG_DEV0_EPF0_VF4_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF4_ADAPTER_ID                                                             0x1900b
#define regBIF_CFG_DEV0_EPF0_VF4_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_ROM_BASE_ADDR                                                          0x1900c
#define regBIF_CFG_DEV0_EPF0_VF4_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_CAP_PTR                                                                0x1900d
#define regBIF_CFG_DEV0_EPF0_VF4_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_LINE                                                         0x1900f
#define regBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_PIN                                                          0x1900f
#define regBIF_CFG_DEV0_EPF0_VF4_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_MIN_GRANT                                                              0x1900f
#define regBIF_CFG_DEV0_EPF0_VF4_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_MAX_LATENCY                                                            0x1900f
#define regBIF_CFG_DEV0_EPF0_VF4_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP_LIST                                                          0x19019
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP                                                               0x19019
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP                                                             0x1901a
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL                                                            0x1901b
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS                                                          0x1901b
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CAP                                                               0x1901c
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL                                                              0x1901d
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS                                                            0x1901d
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP2                                                            0x19022
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL2                                                           0x19023
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS2                                                         0x19023
#define regBIF_CFG_DEV0_EPF0_VF4_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CAP2                                                              0x19024
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL2                                                             0x19025
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS2                                                           0x19025
#define regBIF_CFG_DEV0_EPF0_VF4_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_CAP_LIST                                                           0x19028
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_CNTL                                                           0x19028
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_LO                                                        0x19029
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_HI                                                        0x1902a
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA                                                           0x1902a
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA                                                       0x1902a
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MASK                                                               0x1902b
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA_64                                                        0x1902b
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA_64                                                    0x1902b
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MASK_64                                                            0x1902c
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING                                                            0x1902c
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING_64                                                         0x1902d
#define regBIF_CFG_DEV0_EPF0_VF4_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_CAP_LIST                                                          0x19030
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_MSG_CNTL                                                          0x19030
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_TABLE                                                             0x19031
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_PBA                                                               0x19032
#define regBIF_CFG_DEV0_EPF0_VF4_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x19040
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_HDR                                               0x19041
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC1                                                  0x19042
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC2                                                  0x19043
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x19054
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_STATUS                                                 0x19055
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_MASK                                                   0x19056
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_SEVERITY                                               0x19057
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_STATUS                                                   0x19058
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_MASK                                                     0x19059
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_CAP_CNTL                                                  0x1905a
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG0                                                          0x1905b
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG1                                                          0x1905c
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG2                                                          0x1905d
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG3                                                          0x1905e
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG0                                                   0x19062
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG1                                                   0x19063
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG2                                                   0x19064
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG3                                                   0x19065
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_ENH_CAP_LIST                                                  0x190ca
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CAP                                                           0x190cb
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CNTL                                                          0x190cb
#define regBIF_CFG_DEV0_EPF0_VF4_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf5_bifcfgdecp
// base address: 0x10165000
#define regBIF_CFG_DEV0_EPF0_VF5_VENDOR_ID                                                              0x19400
#define regBIF_CFG_DEV0_EPF0_VF5_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_ID                                                              0x19400
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_COMMAND                                                                0x19401
#define regBIF_CFG_DEV0_EPF0_VF5_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF5_STATUS                                                                 0x19401
#define regBIF_CFG_DEV0_EPF0_VF5_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF5_REVISION_ID                                                            0x19402
#define regBIF_CFG_DEV0_EPF0_VF5_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_PROG_INTERFACE                                                         0x19402
#define regBIF_CFG_DEV0_EPF0_VF5_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF5_SUB_CLASS                                                              0x19402
#define regBIF_CFG_DEV0_EPF0_VF5_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_CLASS                                                             0x19402
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_CACHE_LINE                                                             0x19403
#define regBIF_CFG_DEV0_EPF0_VF5_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_LATENCY                                                                0x19403
#define regBIF_CFG_DEV0_EPF0_VF5_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF5_HEADER                                                                 0x19403
#define regBIF_CFG_DEV0_EPF0_VF5_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF5_BIST                                                                   0x19403
#define regBIF_CFG_DEV0_EPF0_VF5_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_1                                                            0x19404
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_2                                                            0x19405
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_3                                                            0x19406
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_4                                                            0x19407
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_5                                                            0x19408
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_6                                                            0x19409
#define regBIF_CFG_DEV0_EPF0_VF5_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_CARDBUS_CIS_PTR                                                        0x1940a
#define regBIF_CFG_DEV0_EPF0_VF5_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF5_ADAPTER_ID                                                             0x1940b
#define regBIF_CFG_DEV0_EPF0_VF5_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_ROM_BASE_ADDR                                                          0x1940c
#define regBIF_CFG_DEV0_EPF0_VF5_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_CAP_PTR                                                                0x1940d
#define regBIF_CFG_DEV0_EPF0_VF5_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_LINE                                                         0x1940f
#define regBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_PIN                                                          0x1940f
#define regBIF_CFG_DEV0_EPF0_VF5_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_MIN_GRANT                                                              0x1940f
#define regBIF_CFG_DEV0_EPF0_VF5_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_MAX_LATENCY                                                            0x1940f
#define regBIF_CFG_DEV0_EPF0_VF5_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP_LIST                                                          0x19419
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP                                                               0x19419
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP                                                             0x1941a
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL                                                            0x1941b
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS                                                          0x1941b
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CAP                                                               0x1941c
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL                                                              0x1941d
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS                                                            0x1941d
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP2                                                            0x19422
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL2                                                           0x19423
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS2                                                         0x19423
#define regBIF_CFG_DEV0_EPF0_VF5_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CAP2                                                              0x19424
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL2                                                             0x19425
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS2                                                           0x19425
#define regBIF_CFG_DEV0_EPF0_VF5_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_CAP_LIST                                                           0x19428
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_CNTL                                                           0x19428
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_LO                                                        0x19429
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_HI                                                        0x1942a
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA                                                           0x1942a
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA                                                       0x1942a
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MASK                                                               0x1942b
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA_64                                                        0x1942b
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA_64                                                    0x1942b
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MASK_64                                                            0x1942c
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING                                                            0x1942c
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING_64                                                         0x1942d
#define regBIF_CFG_DEV0_EPF0_VF5_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_CAP_LIST                                                          0x19430
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_MSG_CNTL                                                          0x19430
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_TABLE                                                             0x19431
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_PBA                                                               0x19432
#define regBIF_CFG_DEV0_EPF0_VF5_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x19440
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_HDR                                               0x19441
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC1                                                  0x19442
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC2                                                  0x19443
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x19454
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_STATUS                                                 0x19455
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_MASK                                                   0x19456
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_SEVERITY                                               0x19457
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_STATUS                                                   0x19458
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_MASK                                                     0x19459
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_CAP_CNTL                                                  0x1945a
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG0                                                          0x1945b
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG1                                                          0x1945c
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG2                                                          0x1945d
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG3                                                          0x1945e
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG0                                                   0x19462
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG1                                                   0x19463
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG2                                                   0x19464
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG3                                                   0x19465
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_ENH_CAP_LIST                                                  0x194ca
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CAP                                                           0x194cb
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CNTL                                                          0x194cb
#define regBIF_CFG_DEV0_EPF0_VF5_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf6_bifcfgdecp
// base address: 0x10166000
#define regBIF_CFG_DEV0_EPF0_VF6_VENDOR_ID                                                              0x19800
#define regBIF_CFG_DEV0_EPF0_VF6_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_ID                                                              0x19800
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_COMMAND                                                                0x19801
#define regBIF_CFG_DEV0_EPF0_VF6_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF6_STATUS                                                                 0x19801
#define regBIF_CFG_DEV0_EPF0_VF6_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF6_REVISION_ID                                                            0x19802
#define regBIF_CFG_DEV0_EPF0_VF6_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_PROG_INTERFACE                                                         0x19802
#define regBIF_CFG_DEV0_EPF0_VF6_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF6_SUB_CLASS                                                              0x19802
#define regBIF_CFG_DEV0_EPF0_VF6_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_CLASS                                                             0x19802
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_CACHE_LINE                                                             0x19803
#define regBIF_CFG_DEV0_EPF0_VF6_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_LATENCY                                                                0x19803
#define regBIF_CFG_DEV0_EPF0_VF6_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF6_HEADER                                                                 0x19803
#define regBIF_CFG_DEV0_EPF0_VF6_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF6_BIST                                                                   0x19803
#define regBIF_CFG_DEV0_EPF0_VF6_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_1                                                            0x19804
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_2                                                            0x19805
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_3                                                            0x19806
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_4                                                            0x19807
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_5                                                            0x19808
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_6                                                            0x19809
#define regBIF_CFG_DEV0_EPF0_VF6_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_CARDBUS_CIS_PTR                                                        0x1980a
#define regBIF_CFG_DEV0_EPF0_VF6_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF6_ADAPTER_ID                                                             0x1980b
#define regBIF_CFG_DEV0_EPF0_VF6_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_ROM_BASE_ADDR                                                          0x1980c
#define regBIF_CFG_DEV0_EPF0_VF6_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_CAP_PTR                                                                0x1980d
#define regBIF_CFG_DEV0_EPF0_VF6_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_LINE                                                         0x1980f
#define regBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_PIN                                                          0x1980f
#define regBIF_CFG_DEV0_EPF0_VF6_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_MIN_GRANT                                                              0x1980f
#define regBIF_CFG_DEV0_EPF0_VF6_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_MAX_LATENCY                                                            0x1980f
#define regBIF_CFG_DEV0_EPF0_VF6_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP_LIST                                                          0x19819
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP                                                               0x19819
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP                                                             0x1981a
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL                                                            0x1981b
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS                                                          0x1981b
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CAP                                                               0x1981c
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL                                                              0x1981d
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS                                                            0x1981d
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP2                                                            0x19822
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL2                                                           0x19823
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS2                                                         0x19823
#define regBIF_CFG_DEV0_EPF0_VF6_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CAP2                                                              0x19824
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL2                                                             0x19825
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS2                                                           0x19825
#define regBIF_CFG_DEV0_EPF0_VF6_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_CAP_LIST                                                           0x19828
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_CNTL                                                           0x19828
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_LO                                                        0x19829
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_HI                                                        0x1982a
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA                                                           0x1982a
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA                                                       0x1982a
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MASK                                                               0x1982b
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA_64                                                        0x1982b
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA_64                                                    0x1982b
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MASK_64                                                            0x1982c
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING                                                            0x1982c
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING_64                                                         0x1982d
#define regBIF_CFG_DEV0_EPF0_VF6_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_CAP_LIST                                                          0x19830
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_MSG_CNTL                                                          0x19830
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_TABLE                                                             0x19831
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_PBA                                                               0x19832
#define regBIF_CFG_DEV0_EPF0_VF6_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x19840
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_HDR                                               0x19841
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC1                                                  0x19842
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC2                                                  0x19843
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x19854
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_STATUS                                                 0x19855
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_MASK                                                   0x19856
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_SEVERITY                                               0x19857
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_STATUS                                                   0x19858
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_MASK                                                     0x19859
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_CAP_CNTL                                                  0x1985a
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG0                                                          0x1985b
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG1                                                          0x1985c
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG2                                                          0x1985d
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG3                                                          0x1985e
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG0                                                   0x19862
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG1                                                   0x19863
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG2                                                   0x19864
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG3                                                   0x19865
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_ENH_CAP_LIST                                                  0x198ca
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CAP                                                           0x198cb
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CNTL                                                          0x198cb
#define regBIF_CFG_DEV0_EPF0_VF6_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf0_vf7_bifcfgdecp
// base address: 0x10167000
#define regBIF_CFG_DEV0_EPF0_VF7_VENDOR_ID                                                              0x19c00
#define regBIF_CFG_DEV0_EPF0_VF7_VENDOR_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_ID                                                              0x19c00
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_ID_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_COMMAND                                                                0x19c01
#define regBIF_CFG_DEV0_EPF0_VF7_COMMAND_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF7_STATUS                                                                 0x19c01
#define regBIF_CFG_DEV0_EPF0_VF7_STATUS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF7_REVISION_ID                                                            0x19c02
#define regBIF_CFG_DEV0_EPF0_VF7_REVISION_ID_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_PROG_INTERFACE                                                         0x19c02
#define regBIF_CFG_DEV0_EPF0_VF7_PROG_INTERFACE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF7_SUB_CLASS                                                              0x19c02
#define regBIF_CFG_DEV0_EPF0_VF7_SUB_CLASS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_CLASS                                                             0x19c02
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_CLASS_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_CACHE_LINE                                                             0x19c03
#define regBIF_CFG_DEV0_EPF0_VF7_CACHE_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_LATENCY                                                                0x19c03
#define regBIF_CFG_DEV0_EPF0_VF7_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF7_HEADER                                                                 0x19c03
#define regBIF_CFG_DEV0_EPF0_VF7_HEADER_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF0_VF7_BIST                                                                   0x19c03
#define regBIF_CFG_DEV0_EPF0_VF7_BIST_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_1                                                            0x19c04
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_1_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_2                                                            0x19c05
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_3                                                            0x19c06
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_4                                                            0x19c07
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_4_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_5                                                            0x19c08
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_5_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_6                                                            0x19c09
#define regBIF_CFG_DEV0_EPF0_VF7_BASE_ADDR_6_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_CARDBUS_CIS_PTR                                                        0x19c0a
#define regBIF_CFG_DEV0_EPF0_VF7_CARDBUS_CIS_PTR_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF7_ADAPTER_ID                                                             0x19c0b
#define regBIF_CFG_DEV0_EPF0_VF7_ADAPTER_ID_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_ROM_BASE_ADDR                                                          0x19c0c
#define regBIF_CFG_DEV0_EPF0_VF7_ROM_BASE_ADDR_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_CAP_PTR                                                                0x19c0d
#define regBIF_CFG_DEV0_EPF0_VF7_CAP_PTR_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_LINE                                                         0x19c0f
#define regBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_LINE_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_PIN                                                          0x19c0f
#define regBIF_CFG_DEV0_EPF0_VF7_INTERRUPT_PIN_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_MIN_GRANT                                                              0x19c0f
#define regBIF_CFG_DEV0_EPF0_VF7_MIN_GRANT_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_MAX_LATENCY                                                            0x19c0f
#define regBIF_CFG_DEV0_EPF0_VF7_MAX_LATENCY_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP_LIST                                                          0x19c19
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP                                                               0x19c19
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP                                                             0x19c1a
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL                                                            0x19c1b
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS                                                          0x19c1b
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CAP                                                               0x19c1c
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL                                                              0x19c1d
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS                                                            0x19c1d
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP2                                                            0x19c22
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CAP2_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL2                                                           0x19c23
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_CNTL2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS2                                                         0x19c23
#define regBIF_CFG_DEV0_EPF0_VF7_DEVICE_STATUS2_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CAP2                                                              0x19c24
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CAP2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL2                                                             0x19c25
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_CNTL2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS2                                                           0x19c25
#define regBIF_CFG_DEV0_EPF0_VF7_LINK_STATUS2_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_CAP_LIST                                                           0x19c28
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_CAP_LIST_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_CNTL                                                           0x19c28
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_CNTL_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_LO                                                        0x19c29
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_LO_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_HI                                                        0x19c2a
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_ADDR_HI_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA                                                           0x19c2a
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA                                                       0x19c2a
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MASK                                                               0x19c2b
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MASK_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA_64                                                        0x19c2b
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA_64                                                    0x19c2b
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_EXT_MSG_DATA_64_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MASK_64                                                            0x19c2c
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_MASK_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING                                                            0x19c2c
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING_64                                                         0x19c2d
#define regBIF_CFG_DEV0_EPF0_VF7_MSI_PENDING_64_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_CAP_LIST                                                          0x19c30
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_CAP_LIST_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_MSG_CNTL                                                          0x19c30
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_MSG_CNTL_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_TABLE                                                             0x19c31
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_TABLE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_PBA                                                               0x19c32
#define regBIF_CFG_DEV0_EPF0_VF7_MSIX_PBA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                      0x19c40
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                             5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_HDR                                               0x19c41
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC1                                                  0x19c42
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC2                                                  0x19c43
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                          0x19c54
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_STATUS                                                 0x19c55
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_MASK                                                   0x19c56
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_MASK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_SEVERITY                                               0x19c57
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_STATUS                                                   0x19c58
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_STATUS_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_MASK                                                     0x19c59
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_CORR_ERR_MASK_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_CAP_CNTL                                                  0x19c5a
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG0                                                          0x19c5b
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG0_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG1                                                          0x19c5c
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG1_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG2                                                          0x19c5d
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG2_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG3                                                          0x19c5e
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_HDR_LOG3_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG0                                                   0x19c62
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG1                                                   0x19c63
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG2                                                   0x19c64
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG3                                                   0x19c65
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_ENH_CAP_LIST                                                  0x19cca
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CAP                                                           0x19ccb
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CAP_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CNTL                                                          0x19ccb
#define regBIF_CFG_DEV0_EPF0_VF7_PCIE_ARI_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_bif_cfg_dev0_epf1_bifcfgdecp
// base address: 0x10141000
#define regBIF_CFG_DEV0_EPF1_VENDOR_ID                                                                  0x10400
#define regBIF_CFG_DEV0_EPF1_VENDOR_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_DEVICE_ID                                                                  0x10400
#define regBIF_CFG_DEV0_EPF1_DEVICE_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_COMMAND                                                                    0x10401
#define regBIF_CFG_DEV0_EPF1_COMMAND_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF1_STATUS                                                                     0x10401
#define regBIF_CFG_DEV0_EPF1_STATUS_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF1_REVISION_ID                                                                0x10402
#define regBIF_CFG_DEV0_EPF1_REVISION_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_PROG_INTERFACE                                                             0x10402
#define regBIF_CFG_DEV0_EPF1_PROG_INTERFACE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_SUB_CLASS                                                                  0x10402
#define regBIF_CFG_DEV0_EPF1_SUB_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_BASE_CLASS                                                                 0x10402
#define regBIF_CFG_DEV0_EPF1_BASE_CLASS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_CACHE_LINE                                                                 0x10403
#define regBIF_CFG_DEV0_EPF1_CACHE_LINE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_LATENCY                                                                    0x10403
#define regBIF_CFG_DEV0_EPF1_LATENCY_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF1_HEADER                                                                     0x10403
#define regBIF_CFG_DEV0_EPF1_HEADER_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF1_BIST                                                                       0x10403
#define regBIF_CFG_DEV0_EPF1_BIST_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_1                                                                0x10404
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_2                                                                0x10405
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_3                                                                0x10406
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_3_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_4                                                                0x10407
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_4_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_5                                                                0x10408
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_5_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_6                                                                0x10409
#define regBIF_CFG_DEV0_EPF1_BASE_ADDR_6_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_CARDBUS_CIS_PTR                                                            0x1040a
#define regBIF_CFG_DEV0_EPF1_CARDBUS_CIS_PTR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_ADAPTER_ID                                                                 0x1040b
#define regBIF_CFG_DEV0_EPF1_ADAPTER_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_ROM_BASE_ADDR                                                              0x1040c
#define regBIF_CFG_DEV0_EPF1_ROM_BASE_ADDR_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_CAP_PTR                                                                    0x1040d
#define regBIF_CFG_DEV0_EPF1_CAP_PTR_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF1_INTERRUPT_LINE                                                             0x1040f
#define regBIF_CFG_DEV0_EPF1_INTERRUPT_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_INTERRUPT_PIN                                                              0x1040f
#define regBIF_CFG_DEV0_EPF1_INTERRUPT_PIN_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_MIN_GRANT                                                                  0x1040f
#define regBIF_CFG_DEV0_EPF1_MIN_GRANT_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_MAX_LATENCY                                                                0x1040f
#define regBIF_CFG_DEV0_EPF1_MAX_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST                                                            0x10412
#define regBIF_CFG_DEV0_EPF1_VENDOR_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_ADAPTER_ID_W                                                               0x10413
#define regBIF_CFG_DEV0_EPF1_ADAPTER_ID_W_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PMI_CAP_LIST                                                               0x10414
#define regBIF_CFG_DEV0_EPF1_PMI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PMI_CAP                                                                    0x10414
#define regBIF_CFG_DEV0_EPF1_PMI_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL                                                            0x10415
#define regBIF_CFG_DEV0_EPF1_PMI_STATUS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_PCIE_CAP_LIST                                                              0x10419
#define regBIF_CFG_DEV0_EPF1_PCIE_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_CAP                                                                   0x10419
#define regBIF_CFG_DEV0_EPF1_PCIE_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_DEVICE_CAP                                                                 0x1041a
#define regBIF_CFG_DEV0_EPF1_DEVICE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_DEVICE_CNTL                                                                0x1041b
#define regBIF_CFG_DEV0_EPF1_DEVICE_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_DEVICE_STATUS                                                              0x1041b
#define regBIF_CFG_DEV0_EPF1_DEVICE_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_LINK_CAP                                                                   0x1041c
#define regBIF_CFG_DEV0_EPF1_LINK_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_LINK_CNTL                                                                  0x1041d
#define regBIF_CFG_DEV0_EPF1_LINK_CNTL_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_LINK_STATUS                                                                0x1041d
#define regBIF_CFG_DEV0_EPF1_LINK_STATUS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_DEVICE_CAP2                                                                0x10422
#define regBIF_CFG_DEV0_EPF1_DEVICE_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_DEVICE_CNTL2                                                               0x10423
#define regBIF_CFG_DEV0_EPF1_DEVICE_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_DEVICE_STATUS2                                                             0x10423
#define regBIF_CFG_DEV0_EPF1_DEVICE_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_LINK_CAP2                                                                  0x10424
#define regBIF_CFG_DEV0_EPF1_LINK_CAP2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF1_LINK_CNTL2                                                                 0x10425
#define regBIF_CFG_DEV0_EPF1_LINK_CNTL2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_LINK_STATUS2                                                               0x10425
#define regBIF_CFG_DEV0_EPF1_LINK_STATUS2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_MSI_CAP_LIST                                                               0x10428
#define regBIF_CFG_DEV0_EPF1_MSI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_CNTL                                                               0x10428
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO                                                            0x10429
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_LO_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI                                                            0x1042a
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_ADDR_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_DATA                                                               0x1042a
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_DATA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA                                                           0x1042a
#define regBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF1_MSI_MASK                                                                   0x1042b
#define regBIF_CFG_DEV0_EPF1_MSI_MASK_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64                                                            0x1042b
#define regBIF_CFG_DEV0_EPF1_MSI_MSG_DATA_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64                                                        0x1042b
#define regBIF_CFG_DEV0_EPF1_MSI_EXT_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF1_MSI_MASK_64                                                                0x1042c
#define regBIF_CFG_DEV0_EPF1_MSI_MASK_64_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_MSI_PENDING                                                                0x1042c
#define regBIF_CFG_DEV0_EPF1_MSI_PENDING_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF1_MSI_PENDING_64                                                             0x1042d
#define regBIF_CFG_DEV0_EPF1_MSI_PENDING_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_MSIX_CAP_LIST                                                              0x10430
#define regBIF_CFG_DEV0_EPF1_MSIX_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL                                                              0x10430
#define regBIF_CFG_DEV0_EPF1_MSIX_MSG_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_MSIX_TABLE                                                                 0x10431
#define regBIF_CFG_DEV0_EPF1_MSIX_TABLE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF1_MSIX_PBA                                                                   0x10432
#define regBIF_CFG_DEV0_EPF1_MSIX_PBA_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x10440
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR                                                   0x10441
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1                                                      0x10442
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2                                                      0x10443
#define regBIF_CFG_DEV0_EPF1_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST                                           0x10450
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST_BASE_IDX                                  5
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1                                                    0x10451
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW1_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2                                                    0x10452
#define regBIF_CFG_DEV0_EPF1_PCIE_DEV_SERIAL_NUM_DW2_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x10454
#define regBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS                                                     0x10455
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK                                                       0x10456
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY                                                   0x10457
#define regBIF_CFG_DEV0_EPF1_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS                                                       0x10458
#define regBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK                                                         0x10459
#define regBIF_CFG_DEV0_EPF1_PCIE_CORR_ERR_MASK_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL                                                      0x1045a
#define regBIF_CFG_DEV0_EPF1_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0                                                              0x1045b
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG0_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1                                                              0x1045c
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2                                                              0x1045d
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3                                                              0x1045e
#define regBIF_CFG_DEV0_EPF1_PCIE_HDR_LOG3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0                                                       0x10462
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1                                                       0x10463
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2                                                       0x10464
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3                                                       0x10465
#define regBIF_CFG_DEV0_EPF1_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST                                                      0x10480
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP                                                              0x10481
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR1_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL                                                             0x10482
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR1_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP                                                              0x10483
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR2_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL                                                             0x10484
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR2_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP                                                              0x10485
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR3_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL                                                             0x10486
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR3_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP                                                              0x10487
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR4_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL                                                             0x10488
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR4_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP                                                              0x10489
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR5_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL                                                             0x1048a
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR5_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP                                                              0x1048b
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR6_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL                                                             0x1048c
#define regBIF_CFG_DEV0_EPF1_PCIE_BAR6_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x10490
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT                                                0x10491
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA                                                       0x10492
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP                                                        0x10493
#define regBIF_CFG_DEV0_EPF1_PCIE_PWR_BUDGET_CAP_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST                                                      0x10494
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_CAP                                                               0x10495
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR                                                 0x10496
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS                                                            0x10497
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL                                                              0x10497
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x10498
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x10498
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x10498
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x10498
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x10499
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x10499
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x10499
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x10499
#define regBIF_CFG_DEV0_EPF1_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST                                                0x1049c
#define regBIF_CFG_DEV0_EPF1_PCIE_SECONDARY_ENH_CAP_LIST_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3                                                            0x1049d
#define regBIF_CFG_DEV0_EPF1_PCIE_LINK_CNTL3_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS                                                     0x1049e
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_ERROR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL                                              0x1049f
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_0_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL                                              0x1049f
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_1_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL                                              0x104a0
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_2_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL                                              0x104a0
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_3_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL                                              0x104a1
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_4_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL                                              0x104a1
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_5_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL                                              0x104a2
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_6_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL                                              0x104a2
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_7_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL                                              0x104a3
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_8_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL                                              0x104a3
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_9_EQUALIZATION_CNTL_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL                                             0x104a4
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_10_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL                                             0x104a4
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_11_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL                                             0x104a5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_12_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL                                             0x104a5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_13_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL                                             0x104a6
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_14_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL                                             0x104a6
#define regBIF_CFG_DEV0_EPF1_PCIE_LANE_15_EQUALIZATION_CNTL_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST                                                      0x104a8
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_CAP                                                               0x104a9
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL                                                              0x104a9
#define regBIF_CFG_DEV0_EPF1_PCIE_ACS_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST                                                    0x104b4
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_CAP                                                             0x104b5
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL                                                            0x104b5
#define regBIF_CFG_DEV0_EPF1_PCIE_PASID_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST                                                      0x104c8
#define regBIF_CFG_DEV0_EPF1_PCIE_LTR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_LTR_CAP                                                               0x104c9
#define regBIF_CFG_DEV0_EPF1_PCIE_LTR_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST                                                      0x104ca
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_CAP                                                               0x104cb
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL                                                              0x104cb
#define regBIF_CFG_DEV0_EPF1_PCIE_ARI_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST                                                    0x104cc
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP                                                             0x104cd
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL                                                         0x104ce
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_CONTROL_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_STATUS                                                          0x104ce
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_STATUS_BASE_IDX                                                 5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS                                                     0x104cf
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_INITIAL_VFS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS                                                       0x104cf
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_TOTAL_VFS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS                                                         0x104d0
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_NUM_VFS_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK                                                   0x104d0
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FUNC_DEP_LINK_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET                                                 0x104d1
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_FIRST_VF_OFFSET_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE                                                       0x104d1
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_STRIDE_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID                                                    0x104d2
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_DEVICE_ID_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE                                             0x104d3
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SUPPORTED_PAGE_SIZE_BASE_IDX                                    5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE                                                0x104d4
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_SYSTEM_PAGE_SIZE_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0                                                  0x104d5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_0_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1                                                  0x104d6
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_1_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2                                                  0x104d7
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_2_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3                                                  0x104d8
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_3_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4                                                  0x104d9
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_4_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5                                                  0x104da
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_BASE_ADDR_5_BASE_IDX                                         5
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET                                 0x104db
#define regBIF_CFG_DEV0_EPF1_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET_BASE_IDX                        5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST                                            0x10530
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR_ENH_CAP_LIST_BASE_IDX                                   5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP                                                    0x10531
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL                                                   0x10532
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR1_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP                                                    0x10533
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL                                                   0x10534
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR2_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP                                                    0x10535
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL                                                   0x10536
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR3_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP                                                    0x10537
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL                                                   0x10538
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR4_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP                                                    0x10539
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL                                                   0x1053a
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR5_CNTL_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP                                                    0x1053b
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CAP_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL                                                   0x1053c
#define regBIF_CFG_DEV0_EPF1_PCIE_VF_RESIZE_BAR6_CNTL_BASE_IDX                                          5


// addressBlock: nbif_bif_cfg_dev0_epf2_bifcfgdecp
// base address: 0x10142000
#define regBIF_CFG_DEV0_EPF2_VENDOR_ID                                                                  0x10800
#define regBIF_CFG_DEV0_EPF2_VENDOR_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_DEVICE_ID                                                                  0x10800
#define regBIF_CFG_DEV0_EPF2_DEVICE_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_COMMAND                                                                    0x10801
#define regBIF_CFG_DEV0_EPF2_COMMAND_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF2_STATUS                                                                     0x10801
#define regBIF_CFG_DEV0_EPF2_STATUS_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF2_REVISION_ID                                                                0x10802
#define regBIF_CFG_DEV0_EPF2_REVISION_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_PROG_INTERFACE                                                             0x10802
#define regBIF_CFG_DEV0_EPF2_PROG_INTERFACE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_SUB_CLASS                                                                  0x10802
#define regBIF_CFG_DEV0_EPF2_SUB_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_BASE_CLASS                                                                 0x10802
#define regBIF_CFG_DEV0_EPF2_BASE_CLASS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_CACHE_LINE                                                                 0x10803
#define regBIF_CFG_DEV0_EPF2_CACHE_LINE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_LATENCY                                                                    0x10803
#define regBIF_CFG_DEV0_EPF2_LATENCY_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF2_HEADER                                                                     0x10803
#define regBIF_CFG_DEV0_EPF2_HEADER_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF2_BIST                                                                       0x10803
#define regBIF_CFG_DEV0_EPF2_BIST_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_1                                                                0x10804
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_2                                                                0x10805
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_3                                                                0x10806
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_3_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_4                                                                0x10807
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_4_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_5                                                                0x10808
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_5_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_6                                                                0x10809
#define regBIF_CFG_DEV0_EPF2_BASE_ADDR_6_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_CARDBUS_CIS_PTR                                                            0x1080a
#define regBIF_CFG_DEV0_EPF2_CARDBUS_CIS_PTR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_ADAPTER_ID                                                                 0x1080b
#define regBIF_CFG_DEV0_EPF2_ADAPTER_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_ROM_BASE_ADDR                                                              0x1080c
#define regBIF_CFG_DEV0_EPF2_ROM_BASE_ADDR_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_CAP_PTR                                                                    0x1080d
#define regBIF_CFG_DEV0_EPF2_CAP_PTR_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF2_INTERRUPT_LINE                                                             0x1080f
#define regBIF_CFG_DEV0_EPF2_INTERRUPT_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_INTERRUPT_PIN                                                              0x1080f
#define regBIF_CFG_DEV0_EPF2_INTERRUPT_PIN_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_MIN_GRANT                                                                  0x1080f
#define regBIF_CFG_DEV0_EPF2_MIN_GRANT_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_MAX_LATENCY                                                                0x1080f
#define regBIF_CFG_DEV0_EPF2_MAX_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST                                                            0x10812
#define regBIF_CFG_DEV0_EPF2_VENDOR_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_ADAPTER_ID_W                                                               0x10813
#define regBIF_CFG_DEV0_EPF2_ADAPTER_ID_W_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PMI_CAP_LIST                                                               0x10814
#define regBIF_CFG_DEV0_EPF2_PMI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PMI_CAP                                                                    0x10814
#define regBIF_CFG_DEV0_EPF2_PMI_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL                                                            0x10815
#define regBIF_CFG_DEV0_EPF2_PMI_STATUS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_SBRN                                                                       0x10818
#define regBIF_CFG_DEV0_EPF2_SBRN_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF2_FLADJ                                                                      0x10818
#define regBIF_CFG_DEV0_EPF2_FLADJ_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_EPF2_DBESL_DBESLD                                                               0x10818
#define regBIF_CFG_DEV0_EPF2_DBESL_DBESLD_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PCIE_CAP_LIST                                                              0x10819
#define regBIF_CFG_DEV0_EPF2_PCIE_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_CAP                                                                   0x10819
#define regBIF_CFG_DEV0_EPF2_PCIE_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_DEVICE_CAP                                                                 0x1081a
#define regBIF_CFG_DEV0_EPF2_DEVICE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_DEVICE_CNTL                                                                0x1081b
#define regBIF_CFG_DEV0_EPF2_DEVICE_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_DEVICE_STATUS                                                              0x1081b
#define regBIF_CFG_DEV0_EPF2_DEVICE_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_LINK_CAP                                                                   0x1081c
#define regBIF_CFG_DEV0_EPF2_LINK_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_LINK_CNTL                                                                  0x1081d
#define regBIF_CFG_DEV0_EPF2_LINK_CNTL_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_LINK_STATUS                                                                0x1081d
#define regBIF_CFG_DEV0_EPF2_LINK_STATUS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_DEVICE_CAP2                                                                0x10822
#define regBIF_CFG_DEV0_EPF2_DEVICE_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_DEVICE_CNTL2                                                               0x10823
#define regBIF_CFG_DEV0_EPF2_DEVICE_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_DEVICE_STATUS2                                                             0x10823
#define regBIF_CFG_DEV0_EPF2_DEVICE_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_LINK_CAP2                                                                  0x10824
#define regBIF_CFG_DEV0_EPF2_LINK_CAP2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF2_LINK_CNTL2                                                                 0x10825
#define regBIF_CFG_DEV0_EPF2_LINK_CNTL2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_LINK_STATUS2                                                               0x10825
#define regBIF_CFG_DEV0_EPF2_LINK_STATUS2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_MSI_CAP_LIST                                                               0x10828
#define regBIF_CFG_DEV0_EPF2_MSI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_CNTL                                                               0x10828
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_LO                                                            0x10829
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_LO_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_HI                                                            0x1082a
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_ADDR_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_DATA                                                               0x1082a
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_DATA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA                                                           0x1082a
#define regBIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF2_MSI_MASK                                                                   0x1082b
#define regBIF_CFG_DEV0_EPF2_MSI_MASK_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_DATA_64                                                            0x1082b
#define regBIF_CFG_DEV0_EPF2_MSI_MSG_DATA_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_64                                                        0x1082b
#define regBIF_CFG_DEV0_EPF2_MSI_EXT_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF2_MSI_MASK_64                                                                0x1082c
#define regBIF_CFG_DEV0_EPF2_MSI_MASK_64_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_MSI_PENDING                                                                0x1082c
#define regBIF_CFG_DEV0_EPF2_MSI_PENDING_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF2_MSI_PENDING_64                                                             0x1082d
#define regBIF_CFG_DEV0_EPF2_MSI_PENDING_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_MSIX_CAP_LIST                                                              0x10830
#define regBIF_CFG_DEV0_EPF2_MSIX_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL                                                              0x10830
#define regBIF_CFG_DEV0_EPF2_MSIX_MSG_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_MSIX_TABLE                                                                 0x10831
#define regBIF_CFG_DEV0_EPF2_MSIX_TABLE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF2_MSIX_PBA                                                                   0x10832
#define regBIF_CFG_DEV0_EPF2_MSIX_PBA_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x10840
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR                                                   0x10841
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC1                                                      0x10842
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC2                                                      0x10843
#define regBIF_CFG_DEV0_EPF2_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x10854
#define regBIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS                                                     0x10855
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK                                                       0x10856
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_SEVERITY                                                   0x10857
#define regBIF_CFG_DEV0_EPF2_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF2_PCIE_CORR_ERR_STATUS                                                       0x10858
#define regBIF_CFG_DEV0_EPF2_PCIE_CORR_ERR_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_CORR_ERR_MASK                                                         0x10859
#define regBIF_CFG_DEV0_EPF2_PCIE_CORR_ERR_MASK_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_CAP_CNTL                                                      0x1085a
#define regBIF_CFG_DEV0_EPF2_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG0                                                              0x1085b
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG0_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG1                                                              0x1085c
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG2                                                              0x1085d
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG3                                                              0x1085e
#define regBIF_CFG_DEV0_EPF2_PCIE_HDR_LOG3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG0                                                       0x10862
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG1                                                       0x10863
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG2                                                       0x10864
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG3                                                       0x10865
#define regBIF_CFG_DEV0_EPF2_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR_ENH_CAP_LIST                                                      0x10880
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR1_CAP                                                              0x10881
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR1_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR1_CNTL                                                             0x10882
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR1_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR2_CAP                                                              0x10883
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR2_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR2_CNTL                                                             0x10884
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR2_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR3_CAP                                                              0x10885
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR3_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR3_CNTL                                                             0x10886
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR3_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR4_CAP                                                              0x10887
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR4_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR4_CNTL                                                             0x10888
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR4_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR5_CAP                                                              0x10889
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR5_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR5_CNTL                                                             0x1088a
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR5_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR6_CAP                                                              0x1088b
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR6_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR6_CNTL                                                             0x1088c
#define regBIF_CFG_DEV0_EPF2_PCIE_BAR6_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x10890
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_DATA_SELECT                                                0x10891
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_DATA                                                       0x10892
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_CAP                                                        0x10893
#define regBIF_CFG_DEV0_EPF2_PCIE_PWR_BUDGET_CAP_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_ENH_CAP_LIST                                                      0x10894
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_CAP                                                               0x10895
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_LATENCY_INDICATOR                                                 0x10896
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_STATUS                                                            0x10897
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_CNTL                                                              0x10897
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x10898
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x10898
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x10898
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x10898
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x10899
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x10899
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x10899
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x10899
#define regBIF_CFG_DEV0_EPF2_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_ENH_CAP_LIST                                                      0x108a8
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_CAP                                                               0x108a9
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_CNTL                                                              0x108a9
#define regBIF_CFG_DEV0_EPF2_PCIE_ACS_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_ENH_CAP_LIST                                                    0x108b4
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_CAP                                                             0x108b5
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_CNTL                                                            0x108b5
#define regBIF_CFG_DEV0_EPF2_PCIE_PASID_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_ENH_CAP_LIST                                                      0x108ca
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_CAP                                                               0x108cb
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_CNTL                                                              0x108cb
#define regBIF_CFG_DEV0_EPF2_PCIE_ARI_CNTL_BASE_IDX                                                     5


// addressBlock: nbif_bif_cfg_dev0_epf3_bifcfgdecp
// base address: 0x10143000
#define regBIF_CFG_DEV0_EPF3_VENDOR_ID                                                                  0x10c00
#define regBIF_CFG_DEV0_EPF3_VENDOR_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_DEVICE_ID                                                                  0x10c00
#define regBIF_CFG_DEV0_EPF3_DEVICE_ID_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_COMMAND                                                                    0x10c01
#define regBIF_CFG_DEV0_EPF3_COMMAND_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF3_STATUS                                                                     0x10c01
#define regBIF_CFG_DEV0_EPF3_STATUS_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF3_REVISION_ID                                                                0x10c02
#define regBIF_CFG_DEV0_EPF3_REVISION_ID_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_PROG_INTERFACE                                                             0x10c02
#define regBIF_CFG_DEV0_EPF3_PROG_INTERFACE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_SUB_CLASS                                                                  0x10c02
#define regBIF_CFG_DEV0_EPF3_SUB_CLASS_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_BASE_CLASS                                                                 0x10c02
#define regBIF_CFG_DEV0_EPF3_BASE_CLASS_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_CACHE_LINE                                                                 0x10c03
#define regBIF_CFG_DEV0_EPF3_CACHE_LINE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_LATENCY                                                                    0x10c03
#define regBIF_CFG_DEV0_EPF3_LATENCY_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF3_HEADER                                                                     0x10c03
#define regBIF_CFG_DEV0_EPF3_HEADER_BASE_IDX                                                            5
#define regBIF_CFG_DEV0_EPF3_BIST                                                                       0x10c03
#define regBIF_CFG_DEV0_EPF3_BIST_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_1                                                                0x10c04
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_1_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_2                                                                0x10c05
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_3                                                                0x10c06
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_3_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_4                                                                0x10c07
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_4_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_5                                                                0x10c08
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_5_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_6                                                                0x10c09
#define regBIF_CFG_DEV0_EPF3_BASE_ADDR_6_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_CARDBUS_CIS_PTR                                                            0x10c0a
#define regBIF_CFG_DEV0_EPF3_CARDBUS_CIS_PTR_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_ADAPTER_ID                                                                 0x10c0b
#define regBIF_CFG_DEV0_EPF3_ADAPTER_ID_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_ROM_BASE_ADDR                                                              0x10c0c
#define regBIF_CFG_DEV0_EPF3_ROM_BASE_ADDR_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_CAP_PTR                                                                    0x10c0d
#define regBIF_CFG_DEV0_EPF3_CAP_PTR_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF3_INTERRUPT_LINE                                                             0x10c0f
#define regBIF_CFG_DEV0_EPF3_INTERRUPT_LINE_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_INTERRUPT_PIN                                                              0x10c0f
#define regBIF_CFG_DEV0_EPF3_INTERRUPT_PIN_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_MIN_GRANT                                                                  0x10c0f
#define regBIF_CFG_DEV0_EPF3_MIN_GRANT_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_MAX_LATENCY                                                                0x10c0f
#define regBIF_CFG_DEV0_EPF3_MAX_LATENCY_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_VENDOR_CAP_LIST                                                            0x10c12
#define regBIF_CFG_DEV0_EPF3_VENDOR_CAP_LIST_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_ADAPTER_ID_W                                                               0x10c13
#define regBIF_CFG_DEV0_EPF3_ADAPTER_ID_W_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PMI_CAP_LIST                                                               0x10c14
#define regBIF_CFG_DEV0_EPF3_PMI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PMI_CAP                                                                    0x10c14
#define regBIF_CFG_DEV0_EPF3_PMI_CAP_BASE_IDX                                                           5
#define regBIF_CFG_DEV0_EPF3_PMI_STATUS_CNTL                                                            0x10c15
#define regBIF_CFG_DEV0_EPF3_PMI_STATUS_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_SBRN                                                                       0x10c18
#define regBIF_CFG_DEV0_EPF3_SBRN_BASE_IDX                                                              5
#define regBIF_CFG_DEV0_EPF3_FLADJ                                                                      0x10c18
#define regBIF_CFG_DEV0_EPF3_FLADJ_BASE_IDX                                                             5
#define regBIF_CFG_DEV0_EPF3_DBESL_DBESLD                                                               0x10c18
#define regBIF_CFG_DEV0_EPF3_DBESL_DBESLD_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PCIE_CAP_LIST                                                              0x10c19
#define regBIF_CFG_DEV0_EPF3_PCIE_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_CAP                                                                   0x10c19
#define regBIF_CFG_DEV0_EPF3_PCIE_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_DEVICE_CAP                                                                 0x10c1a
#define regBIF_CFG_DEV0_EPF3_DEVICE_CAP_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_DEVICE_CNTL                                                                0x10c1b
#define regBIF_CFG_DEV0_EPF3_DEVICE_CNTL_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_DEVICE_STATUS                                                              0x10c1b
#define regBIF_CFG_DEV0_EPF3_DEVICE_STATUS_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_LINK_CAP                                                                   0x10c1c
#define regBIF_CFG_DEV0_EPF3_LINK_CAP_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_LINK_CNTL                                                                  0x10c1d
#define regBIF_CFG_DEV0_EPF3_LINK_CNTL_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_LINK_STATUS                                                                0x10c1d
#define regBIF_CFG_DEV0_EPF3_LINK_STATUS_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_DEVICE_CAP2                                                                0x10c22
#define regBIF_CFG_DEV0_EPF3_DEVICE_CAP2_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_DEVICE_CNTL2                                                               0x10c23
#define regBIF_CFG_DEV0_EPF3_DEVICE_CNTL2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_DEVICE_STATUS2                                                             0x10c23
#define regBIF_CFG_DEV0_EPF3_DEVICE_STATUS2_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_LINK_CAP2                                                                  0x10c24
#define regBIF_CFG_DEV0_EPF3_LINK_CAP2_BASE_IDX                                                         5
#define regBIF_CFG_DEV0_EPF3_LINK_CNTL2                                                                 0x10c25
#define regBIF_CFG_DEV0_EPF3_LINK_CNTL2_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_LINK_STATUS2                                                               0x10c25
#define regBIF_CFG_DEV0_EPF3_LINK_STATUS2_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_MSI_CAP_LIST                                                               0x10c28
#define regBIF_CFG_DEV0_EPF3_MSI_CAP_LIST_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_CNTL                                                               0x10c28
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_CNTL_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_ADDR_LO                                                            0x10c29
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_ADDR_LO_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_ADDR_HI                                                            0x10c2a
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_ADDR_HI_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_DATA                                                               0x10c2a
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_DATA_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_MSI_EXT_MSG_DATA                                                           0x10c2a
#define regBIF_CFG_DEV0_EPF3_MSI_EXT_MSG_DATA_BASE_IDX                                                  5
#define regBIF_CFG_DEV0_EPF3_MSI_MASK                                                                   0x10c2b
#define regBIF_CFG_DEV0_EPF3_MSI_MASK_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_DATA_64                                                            0x10c2b
#define regBIF_CFG_DEV0_EPF3_MSI_MSG_DATA_64_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_MSI_EXT_MSG_DATA_64                                                        0x10c2b
#define regBIF_CFG_DEV0_EPF3_MSI_EXT_MSG_DATA_64_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF3_MSI_MASK_64                                                                0x10c2c
#define regBIF_CFG_DEV0_EPF3_MSI_MASK_64_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_MSI_PENDING                                                                0x10c2c
#define regBIF_CFG_DEV0_EPF3_MSI_PENDING_BASE_IDX                                                       5
#define regBIF_CFG_DEV0_EPF3_MSI_PENDING_64                                                             0x10c2d
#define regBIF_CFG_DEV0_EPF3_MSI_PENDING_64_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_MSIX_CAP_LIST                                                              0x10c30
#define regBIF_CFG_DEV0_EPF3_MSIX_CAP_LIST_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_MSIX_MSG_CNTL                                                              0x10c30
#define regBIF_CFG_DEV0_EPF3_MSIX_MSG_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_MSIX_TABLE                                                                 0x10c31
#define regBIF_CFG_DEV0_EPF3_MSIX_TABLE_BASE_IDX                                                        5
#define regBIF_CFG_DEV0_EPF3_MSIX_PBA                                                                   0x10c32
#define regBIF_CFG_DEV0_EPF3_MSIX_PBA_BASE_IDX                                                          5
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST                                          0x10c40
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_BASE_IDX                                 5
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC_HDR                                                   0x10c41
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC_HDR_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC1                                                      0x10c42
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC1_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC2                                                      0x10c43
#define regBIF_CFG_DEV0_EPF3_PCIE_VENDOR_SPECIFIC2_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST                                              0x10c54
#define regBIF_CFG_DEV0_EPF3_PCIE_ADV_ERR_RPT_ENH_CAP_LIST_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_STATUS                                                     0x10c55
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_STATUS_BASE_IDX                                            5
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_MASK                                                       0x10c56
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_MASK_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_SEVERITY                                                   0x10c57
#define regBIF_CFG_DEV0_EPF3_PCIE_UNCORR_ERR_SEVERITY_BASE_IDX                                          5
#define regBIF_CFG_DEV0_EPF3_PCIE_CORR_ERR_STATUS                                                       0x10c58
#define regBIF_CFG_DEV0_EPF3_PCIE_CORR_ERR_STATUS_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_CORR_ERR_MASK                                                         0x10c59
#define regBIF_CFG_DEV0_EPF3_PCIE_CORR_ERR_MASK_BASE_IDX                                                5
#define regBIF_CFG_DEV0_EPF3_PCIE_ADV_ERR_CAP_CNTL                                                      0x10c5a
#define regBIF_CFG_DEV0_EPF3_PCIE_ADV_ERR_CAP_CNTL_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG0                                                              0x10c5b
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG0_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG1                                                              0x10c5c
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG1_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG2                                                              0x10c5d
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG2_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG3                                                              0x10c5e
#define regBIF_CFG_DEV0_EPF3_PCIE_HDR_LOG3_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG0                                                       0x10c62
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG0_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG1                                                       0x10c63
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG1_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG2                                                       0x10c64
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG2_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG3                                                       0x10c65
#define regBIF_CFG_DEV0_EPF3_PCIE_TLP_PREFIX_LOG3_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR_ENH_CAP_LIST                                                      0x10c80
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR1_CAP                                                              0x10c81
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR1_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR1_CNTL                                                             0x10c82
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR1_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR2_CAP                                                              0x10c83
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR2_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR2_CNTL                                                             0x10c84
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR2_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR3_CAP                                                              0x10c85
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR3_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR3_CNTL                                                             0x10c86
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR3_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR4_CAP                                                              0x10c87
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR4_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR4_CNTL                                                             0x10c88
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR4_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR5_CAP                                                              0x10c89
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR5_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR5_CNTL                                                             0x10c8a
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR5_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR6_CAP                                                              0x10c8b
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR6_CAP_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR6_CNTL                                                             0x10c8c
#define regBIF_CFG_DEV0_EPF3_PCIE_BAR6_CNTL_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_ENH_CAP_LIST                                               0x10c90
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_ENH_CAP_LIST_BASE_IDX                                      5
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_DATA_SELECT                                                0x10c91
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_DATA_SELECT_BASE_IDX                                       5
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_DATA                                                       0x10c92
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_DATA_BASE_IDX                                              5
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_CAP                                                        0x10c93
#define regBIF_CFG_DEV0_EPF3_PCIE_PWR_BUDGET_CAP_BASE_IDX                                               5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_ENH_CAP_LIST                                                      0x10c94
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_CAP                                                               0x10c95
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_LATENCY_INDICATOR                                                 0x10c96
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_LATENCY_INDICATOR_BASE_IDX                                        5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_STATUS                                                            0x10c97
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_STATUS_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_CNTL                                                              0x10c97
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_0                                              0x10c98
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_1                                              0x10c98
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_2                                              0x10c98
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_3                                              0x10c98
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_4                                              0x10c99
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_5                                              0x10c99
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_6                                              0x10c99
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_7                                              0x10c99
#define regBIF_CFG_DEV0_EPF3_PCIE_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_ENH_CAP_LIST                                                      0x10ca8
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_CAP                                                               0x10ca9
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_CNTL                                                              0x10ca9
#define regBIF_CFG_DEV0_EPF3_PCIE_ACS_CNTL_BASE_IDX                                                     5
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_ENH_CAP_LIST                                                    0x10cb4
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_ENH_CAP_LIST_BASE_IDX                                           5
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_CAP                                                             0x10cb5
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_CAP_BASE_IDX                                                    5
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_CNTL                                                            0x10cb5
#define regBIF_CFG_DEV0_EPF3_PCIE_PASID_CNTL_BASE_IDX                                                   5
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_ENH_CAP_LIST                                                      0x10cca
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_ENH_CAP_LIST_BASE_IDX                                             5
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_CAP                                                               0x10ccb
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_CAP_BASE_IDX                                                      5
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_CNTL                                                              0x10ccb
#define regBIF_CFG_DEV0_EPF3_PCIE_ARI_CNTL_BASE_IDX                                                     5


// addressBlock: nbif_rcc_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_DEV0_1_RCC_VDM_SUPPORT                                                                   0xc440
#define regRCC_DEV0_1_RCC_VDM_SUPPORT_BASE_IDX                                                          5
#define regRCC_DEV0_1_RCC_BUS_CNTL                                                                      0xc441
#define regRCC_DEV0_1_RCC_BUS_CNTL_BASE_IDX                                                             5
#define regRCC_DEV0_1_RCC_FEATURES_CONTROL_MISC                                                         0xc442
#define regRCC_DEV0_1_RCC_FEATURES_CONTROL_MISC_BASE_IDX                                                5
#define regRCC_DEV0_1_RCC_DEV0_LINK_CNTL                                                                0xc443
#define regRCC_DEV0_1_RCC_DEV0_LINK_CNTL_BASE_IDX                                                       5
#define regRCC_DEV0_1_RCC_CMN_LINK_CNTL                                                                 0xc444
#define regRCC_DEV0_1_RCC_CMN_LINK_CNTL_BASE_IDX                                                        5
#define regRCC_DEV0_1_RCC_EP_REQUESTERID_RESTORE                                                        0xc445
#define regRCC_DEV0_1_RCC_EP_REQUESTERID_RESTORE_BASE_IDX                                               5
#define regRCC_DEV0_1_RCC_LTR_LSWITCH_CNTL                                                              0xc446
#define regRCC_DEV0_1_RCC_LTR_LSWITCH_CNTL_BASE_IDX                                                     5
#define regRCC_DEV0_1_RCC_MH_ARB_CNTL                                                                   0xc447
#define regRCC_DEV0_1_RCC_MH_ARB_CNTL_BASE_IDX                                                          5
#define regRCC_DEV0_1_RCC_MARGIN_PARAM_CNTL0                                                            0xc448
#define regRCC_DEV0_1_RCC_MARGIN_PARAM_CNTL0_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_MARGIN_PARAM_CNTL1                                                            0xc449
#define regRCC_DEV0_1_RCC_MARGIN_PARAM_CNTL1_BASE_IDX                                                   5


// addressBlock: nbif_rcc_ep_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_EP_DEV0_1_EP_PCIE_SCRATCH                                                                0xc44c
#define regRCC_EP_DEV0_1_EP_PCIE_SCRATCH_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_CNTL                                                                   0xc44e
#define regRCC_EP_DEV0_1_EP_PCIE_CNTL_BASE_IDX                                                          5
#define regRCC_EP_DEV0_1_EP_PCIE_INT_CNTL                                                               0xc44f
#define regRCC_EP_DEV0_1_EP_PCIE_INT_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_INT_STATUS                                                             0xc450
#define regRCC_EP_DEV0_1_EP_PCIE_INT_STATUS_BASE_IDX                                                    5
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL2                                                               0xc451
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL2_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_BUS_CNTL                                                               0xc452
#define regRCC_EP_DEV0_1_EP_PCIE_BUS_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_CFG_CNTL                                                               0xc453
#define regRCC_EP_DEV0_1_EP_PCIE_CFG_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_LTR_CNTL                                                            0xc454
#define regRCC_EP_DEV0_1_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_EP_PCIE_STRAP_MISC                                                             0xc455
#define regRCC_EP_DEV0_1_EP_PCIE_STRAP_MISC_BASE_IDX                                                    5
#define regRCC_EP_DEV0_1_EP_PCIE_STRAP_MISC2                                                            0xc456
#define regRCC_EP_DEV0_1_EP_PCIE_STRAP_MISC2_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CAP                                                             0xc457
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0xc458
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CNTL                                                            0xc458
#define regRCC_EP_DEV0_1_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0xc458
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0xc459
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0xc459
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0xc459
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0xc459
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0xc45a
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0xc45a
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0xc45a
#define regRCC_EP_DEV0_1_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_PME_CONTROL                                                            0xc45c
#define regRCC_EP_DEV0_1_EP_PCIE_PME_CONTROL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_EP_PCIEP_RESERVED                                                              0xc45d
#define regRCC_EP_DEV0_1_EP_PCIEP_RESERVED_BASE_IDX                                                     5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_CNTL                                                                0xc45f
#define regRCC_EP_DEV0_1_EP_PCIE_TX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_TX_REQUESTER_ID                                                        0xc460
#define regRCC_EP_DEV0_1_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               5
#define regRCC_EP_DEV0_1_EP_PCIE_ERR_CNTL                                                               0xc461
#define regRCC_EP_DEV0_1_EP_PCIE_ERR_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL                                                                0xc462
#define regRCC_EP_DEV0_1_EP_PCIE_RX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_1_EP_PCIE_LC_SPEED_CNTL                                                          0xc463
#define regRCC_EP_DEV0_1_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_rcc_dwn_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_DWN_DEV0_1_DN_PCIE_RESERVED                                                              0xc468
#define regRCC_DWN_DEV0_1_DN_PCIE_RESERVED_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_SCRATCH                                                               0xc469
#define regRCC_DWN_DEV0_1_DN_PCIE_SCRATCH_BASE_IDX                                                      5
#define regRCC_DWN_DEV0_1_DN_PCIE_CNTL                                                                  0xc46b
#define regRCC_DWN_DEV0_1_DN_PCIE_CNTL_BASE_IDX                                                         5
#define regRCC_DWN_DEV0_1_DN_PCIE_CONFIG_CNTL                                                           0xc46c
#define regRCC_DWN_DEV0_1_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  5
#define regRCC_DWN_DEV0_1_DN_PCIE_RX_CNTL2                                                              0xc46d
#define regRCC_DWN_DEV0_1_DN_PCIE_RX_CNTL2_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_BUS_CNTL                                                              0xc46e
#define regRCC_DWN_DEV0_1_DN_PCIE_BUS_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_CFG_CNTL                                                              0xc46f
#define regRCC_DWN_DEV0_1_DN_PCIE_CFG_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_F0                                                              0xc470
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_F0_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_MISC                                                            0xc471
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_MISC_BASE_IDX                                                   5
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_MISC2                                                           0xc472
#define regRCC_DWN_DEV0_1_DN_PCIE_STRAP_MISC2_BASE_IDX                                                  5


// addressBlock: nbif_rcc_dwnp_dev0_RCCPORTDEC
// base address: 0x10131000
#define regRCC_DWNP_DEV0_1_PCIE_ERR_CNTL                                                                0xc475
#define regRCC_DWNP_DEV0_1_PCIE_ERR_CNTL_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_1_PCIE_RX_CNTL                                                                 0xc476
#define regRCC_DWNP_DEV0_1_PCIE_RX_CNTL_BASE_IDX                                                        5
#define regRCC_DWNP_DEV0_1_PCIE_LC_SPEED_CNTL                                                           0xc477
#define regRCC_DWNP_DEV0_1_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  5
#define regRCC_DWNP_DEV0_1_PCIE_LC_CNTL2                                                                0xc478
#define regRCC_DWNP_DEV0_1_PCIE_LC_CNTL2_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_1_PCIEP_STRAP_MISC                                                             0xc479
#define regRCC_DWNP_DEV0_1_PCIEP_STRAP_MISC_BASE_IDX                                                    5
#define regRCC_DWNP_DEV0_1_LTR_MSG_INFO_FROM_EP                                                         0xc47a
#define regRCC_DWNP_DEV0_1_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                5


// addressBlock: nbif_rcc_pfc_amdgfx_RCCPFCDEC
// base address: 0x10134000
#define regRCC_PFC_AMDGFX_RCC_PFC_LTR_CNTL                                                              0xd040
#define regRCC_PFC_AMDGFX_RCC_PFC_LTR_CNTL_BASE_IDX                                                     5
#define regRCC_PFC_AMDGFX_RCC_PFC_PME_RESTORE                                                           0xd041
#define regRCC_PFC_AMDGFX_RCC_PFC_PME_RESTORE_BASE_IDX                                                  5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_0                                                      0xd042
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_0_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_1                                                      0xd043
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_1_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_2                                                      0xd044
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_2_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_3                                                      0xd045
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_3_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_4                                                      0xd046
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_4_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_5                                                      0xd047
#define regRCC_PFC_AMDGFX_RCC_PFC_STICKY_RESTORE_5_BASE_IDX                                             5
#define regRCC_PFC_AMDGFX_RCC_PFC_AUXPWR_CNTL                                                           0xd048
#define regRCC_PFC_AMDGFX_RCC_PFC_AUXPWR_CNTL_BASE_IDX                                                  5


// addressBlock: nbif_rcc_pfc_amdgfxaz_RCCPFCDEC
// base address: 0x10134200
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_LTR_CNTL                                                            0xd0c0
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_PME_RESTORE                                                         0xd0c1
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_PME_RESTORE_BASE_IDX                                                5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_0                                                    0xd0c2
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_0_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_1                                                    0xd0c3
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_1_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_2                                                    0xd0c4
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_2_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_3                                                    0xd0c5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_3_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_4                                                    0xd0c6
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_4_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_5                                                    0xd0c7
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_STICKY_RESTORE_5_BASE_IDX                                           5
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_AUXPWR_CNTL                                                         0xd0c8
#define regRCC_PFC_AMDGFXAZ_RCC_PFC_AUXPWR_CNTL_BASE_IDX                                                5


// addressBlock: nbif_pciemsix_0_usb_MSIXTDEC
// base address: 0x10178000
#define regPCIEMSIX_VECT0_ADDR_LO                                                                       0x1e000
#define regPCIEMSIX_VECT0_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT0_ADDR_HI                                                                       0x1e001
#define regPCIEMSIX_VECT0_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT0_MSG_DATA                                                                      0x1e002
#define regPCIEMSIX_VECT0_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT0_CONTROL                                                                       0x1e003
#define regPCIEMSIX_VECT0_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT1_ADDR_LO                                                                       0x1e004
#define regPCIEMSIX_VECT1_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT1_ADDR_HI                                                                       0x1e005
#define regPCIEMSIX_VECT1_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT1_MSG_DATA                                                                      0x1e006
#define regPCIEMSIX_VECT1_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT1_CONTROL                                                                       0x1e007
#define regPCIEMSIX_VECT1_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT2_ADDR_LO                                                                       0x1e008
#define regPCIEMSIX_VECT2_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT2_ADDR_HI                                                                       0x1e009
#define regPCIEMSIX_VECT2_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT2_MSG_DATA                                                                      0x1e00a
#define regPCIEMSIX_VECT2_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT2_CONTROL                                                                       0x1e00b
#define regPCIEMSIX_VECT2_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT3_ADDR_LO                                                                       0x1e00c
#define regPCIEMSIX_VECT3_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT3_ADDR_HI                                                                       0x1e00d
#define regPCIEMSIX_VECT3_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT3_MSG_DATA                                                                      0x1e00e
#define regPCIEMSIX_VECT3_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT3_CONTROL                                                                       0x1e00f
#define regPCIEMSIX_VECT3_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT4_ADDR_LO                                                                       0x1e010
#define regPCIEMSIX_VECT4_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT4_ADDR_HI                                                                       0x1e011
#define regPCIEMSIX_VECT4_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT4_MSG_DATA                                                                      0x1e012
#define regPCIEMSIX_VECT4_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT4_CONTROL                                                                       0x1e013
#define regPCIEMSIX_VECT4_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT5_ADDR_LO                                                                       0x1e014
#define regPCIEMSIX_VECT5_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT5_ADDR_HI                                                                       0x1e015
#define regPCIEMSIX_VECT5_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT5_MSG_DATA                                                                      0x1e016
#define regPCIEMSIX_VECT5_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT5_CONTROL                                                                       0x1e017
#define regPCIEMSIX_VECT5_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT6_ADDR_LO                                                                       0x1e018
#define regPCIEMSIX_VECT6_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT6_ADDR_HI                                                                       0x1e019
#define regPCIEMSIX_VECT6_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT6_MSG_DATA                                                                      0x1e01a
#define regPCIEMSIX_VECT6_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT6_CONTROL                                                                       0x1e01b
#define regPCIEMSIX_VECT6_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT7_ADDR_LO                                                                       0x1e01c
#define regPCIEMSIX_VECT7_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT7_ADDR_HI                                                                       0x1e01d
#define regPCIEMSIX_VECT7_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT7_MSG_DATA                                                                      0x1e01e
#define regPCIEMSIX_VECT7_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT7_CONTROL                                                                       0x1e01f
#define regPCIEMSIX_VECT7_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT8_ADDR_LO                                                                       0x1e020
#define regPCIEMSIX_VECT8_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT8_ADDR_HI                                                                       0x1e021
#define regPCIEMSIX_VECT8_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT8_MSG_DATA                                                                      0x1e022
#define regPCIEMSIX_VECT8_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT8_CONTROL                                                                       0x1e023
#define regPCIEMSIX_VECT8_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT9_ADDR_LO                                                                       0x1e024
#define regPCIEMSIX_VECT9_ADDR_LO_BASE_IDX                                                              5
#define regPCIEMSIX_VECT9_ADDR_HI                                                                       0x1e025
#define regPCIEMSIX_VECT9_ADDR_HI_BASE_IDX                                                              5
#define regPCIEMSIX_VECT9_MSG_DATA                                                                      0x1e026
#define regPCIEMSIX_VECT9_MSG_DATA_BASE_IDX                                                             5
#define regPCIEMSIX_VECT9_CONTROL                                                                       0x1e027
#define regPCIEMSIX_VECT9_CONTROL_BASE_IDX                                                              5
#define regPCIEMSIX_VECT10_ADDR_LO                                                                      0x1e028
#define regPCIEMSIX_VECT10_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT10_ADDR_HI                                                                      0x1e029
#define regPCIEMSIX_VECT10_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT10_MSG_DATA                                                                     0x1e02a
#define regPCIEMSIX_VECT10_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT10_CONTROL                                                                      0x1e02b
#define regPCIEMSIX_VECT10_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT11_ADDR_LO                                                                      0x1e02c
#define regPCIEMSIX_VECT11_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT11_ADDR_HI                                                                      0x1e02d
#define regPCIEMSIX_VECT11_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT11_MSG_DATA                                                                     0x1e02e
#define regPCIEMSIX_VECT11_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT11_CONTROL                                                                      0x1e02f
#define regPCIEMSIX_VECT11_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT12_ADDR_LO                                                                      0x1e030
#define regPCIEMSIX_VECT12_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT12_ADDR_HI                                                                      0x1e031
#define regPCIEMSIX_VECT12_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT12_MSG_DATA                                                                     0x1e032
#define regPCIEMSIX_VECT12_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT12_CONTROL                                                                      0x1e033
#define regPCIEMSIX_VECT12_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT13_ADDR_LO                                                                      0x1e034
#define regPCIEMSIX_VECT13_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT13_ADDR_HI                                                                      0x1e035
#define regPCIEMSIX_VECT13_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT13_MSG_DATA                                                                     0x1e036
#define regPCIEMSIX_VECT13_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT13_CONTROL                                                                      0x1e037
#define regPCIEMSIX_VECT13_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT14_ADDR_LO                                                                      0x1e038
#define regPCIEMSIX_VECT14_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT14_ADDR_HI                                                                      0x1e039
#define regPCIEMSIX_VECT14_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT14_MSG_DATA                                                                     0x1e03a
#define regPCIEMSIX_VECT14_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT14_CONTROL                                                                      0x1e03b
#define regPCIEMSIX_VECT14_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT15_ADDR_LO                                                                      0x1e03c
#define regPCIEMSIX_VECT15_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT15_ADDR_HI                                                                      0x1e03d
#define regPCIEMSIX_VECT15_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT15_MSG_DATA                                                                     0x1e03e
#define regPCIEMSIX_VECT15_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT15_CONTROL                                                                      0x1e03f
#define regPCIEMSIX_VECT15_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT16_ADDR_LO                                                                      0x1e040
#define regPCIEMSIX_VECT16_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT16_ADDR_HI                                                                      0x1e041
#define regPCIEMSIX_VECT16_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT16_MSG_DATA                                                                     0x1e042
#define regPCIEMSIX_VECT16_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT16_CONTROL                                                                      0x1e043
#define regPCIEMSIX_VECT16_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT17_ADDR_LO                                                                      0x1e044
#define regPCIEMSIX_VECT17_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT17_ADDR_HI                                                                      0x1e045
#define regPCIEMSIX_VECT17_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT17_MSG_DATA                                                                     0x1e046
#define regPCIEMSIX_VECT17_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT17_CONTROL                                                                      0x1e047
#define regPCIEMSIX_VECT17_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT18_ADDR_LO                                                                      0x1e048
#define regPCIEMSIX_VECT18_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT18_ADDR_HI                                                                      0x1e049
#define regPCIEMSIX_VECT18_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT18_MSG_DATA                                                                     0x1e04a
#define regPCIEMSIX_VECT18_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT18_CONTROL                                                                      0x1e04b
#define regPCIEMSIX_VECT18_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT19_ADDR_LO                                                                      0x1e04c
#define regPCIEMSIX_VECT19_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT19_ADDR_HI                                                                      0x1e04d
#define regPCIEMSIX_VECT19_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT19_MSG_DATA                                                                     0x1e04e
#define regPCIEMSIX_VECT19_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT19_CONTROL                                                                      0x1e04f
#define regPCIEMSIX_VECT19_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT20_ADDR_LO                                                                      0x1e050
#define regPCIEMSIX_VECT20_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT20_ADDR_HI                                                                      0x1e051
#define regPCIEMSIX_VECT20_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT20_MSG_DATA                                                                     0x1e052
#define regPCIEMSIX_VECT20_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT20_CONTROL                                                                      0x1e053
#define regPCIEMSIX_VECT20_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT21_ADDR_LO                                                                      0x1e054
#define regPCIEMSIX_VECT21_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT21_ADDR_HI                                                                      0x1e055
#define regPCIEMSIX_VECT21_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT21_MSG_DATA                                                                     0x1e056
#define regPCIEMSIX_VECT21_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT21_CONTROL                                                                      0x1e057
#define regPCIEMSIX_VECT21_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT22_ADDR_LO                                                                      0x1e058
#define regPCIEMSIX_VECT22_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT22_ADDR_HI                                                                      0x1e059
#define regPCIEMSIX_VECT22_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT22_MSG_DATA                                                                     0x1e05a
#define regPCIEMSIX_VECT22_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT22_CONTROL                                                                      0x1e05b
#define regPCIEMSIX_VECT22_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT23_ADDR_LO                                                                      0x1e05c
#define regPCIEMSIX_VECT23_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT23_ADDR_HI                                                                      0x1e05d
#define regPCIEMSIX_VECT23_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT23_MSG_DATA                                                                     0x1e05e
#define regPCIEMSIX_VECT23_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT23_CONTROL                                                                      0x1e05f
#define regPCIEMSIX_VECT23_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT24_ADDR_LO                                                                      0x1e060
#define regPCIEMSIX_VECT24_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT24_ADDR_HI                                                                      0x1e061
#define regPCIEMSIX_VECT24_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT24_MSG_DATA                                                                     0x1e062
#define regPCIEMSIX_VECT24_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT24_CONTROL                                                                      0x1e063
#define regPCIEMSIX_VECT24_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT25_ADDR_LO                                                                      0x1e064
#define regPCIEMSIX_VECT25_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT25_ADDR_HI                                                                      0x1e065
#define regPCIEMSIX_VECT25_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT25_MSG_DATA                                                                     0x1e066
#define regPCIEMSIX_VECT25_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT25_CONTROL                                                                      0x1e067
#define regPCIEMSIX_VECT25_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT26_ADDR_LO                                                                      0x1e068
#define regPCIEMSIX_VECT26_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT26_ADDR_HI                                                                      0x1e069
#define regPCIEMSIX_VECT26_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT26_MSG_DATA                                                                     0x1e06a
#define regPCIEMSIX_VECT26_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT26_CONTROL                                                                      0x1e06b
#define regPCIEMSIX_VECT26_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT27_ADDR_LO                                                                      0x1e06c
#define regPCIEMSIX_VECT27_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT27_ADDR_HI                                                                      0x1e06d
#define regPCIEMSIX_VECT27_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT27_MSG_DATA                                                                     0x1e06e
#define regPCIEMSIX_VECT27_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT27_CONTROL                                                                      0x1e06f
#define regPCIEMSIX_VECT27_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT28_ADDR_LO                                                                      0x1e070
#define regPCIEMSIX_VECT28_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT28_ADDR_HI                                                                      0x1e071
#define regPCIEMSIX_VECT28_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT28_MSG_DATA                                                                     0x1e072
#define regPCIEMSIX_VECT28_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT28_CONTROL                                                                      0x1e073
#define regPCIEMSIX_VECT28_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT29_ADDR_LO                                                                      0x1e074
#define regPCIEMSIX_VECT29_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT29_ADDR_HI                                                                      0x1e075
#define regPCIEMSIX_VECT29_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT29_MSG_DATA                                                                     0x1e076
#define regPCIEMSIX_VECT29_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT29_CONTROL                                                                      0x1e077
#define regPCIEMSIX_VECT29_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT30_ADDR_LO                                                                      0x1e078
#define regPCIEMSIX_VECT30_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT30_ADDR_HI                                                                      0x1e079
#define regPCIEMSIX_VECT30_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT30_MSG_DATA                                                                     0x1e07a
#define regPCIEMSIX_VECT30_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT30_CONTROL                                                                      0x1e07b
#define regPCIEMSIX_VECT30_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT31_ADDR_LO                                                                      0x1e07c
#define regPCIEMSIX_VECT31_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT31_ADDR_HI                                                                      0x1e07d
#define regPCIEMSIX_VECT31_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT31_MSG_DATA                                                                     0x1e07e
#define regPCIEMSIX_VECT31_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT31_CONTROL                                                                      0x1e07f
#define regPCIEMSIX_VECT31_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT32_ADDR_LO                                                                      0x1e080
#define regPCIEMSIX_VECT32_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT32_ADDR_HI                                                                      0x1e081
#define regPCIEMSIX_VECT32_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT32_MSG_DATA                                                                     0x1e082
#define regPCIEMSIX_VECT32_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT32_CONTROL                                                                      0x1e083
#define regPCIEMSIX_VECT32_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT33_ADDR_LO                                                                      0x1e084
#define regPCIEMSIX_VECT33_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT33_ADDR_HI                                                                      0x1e085
#define regPCIEMSIX_VECT33_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT33_MSG_DATA                                                                     0x1e086
#define regPCIEMSIX_VECT33_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT33_CONTROL                                                                      0x1e087
#define regPCIEMSIX_VECT33_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT34_ADDR_LO                                                                      0x1e088
#define regPCIEMSIX_VECT34_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT34_ADDR_HI                                                                      0x1e089
#define regPCIEMSIX_VECT34_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT34_MSG_DATA                                                                     0x1e08a
#define regPCIEMSIX_VECT34_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT34_CONTROL                                                                      0x1e08b
#define regPCIEMSIX_VECT34_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT35_ADDR_LO                                                                      0x1e08c
#define regPCIEMSIX_VECT35_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT35_ADDR_HI                                                                      0x1e08d
#define regPCIEMSIX_VECT35_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT35_MSG_DATA                                                                     0x1e08e
#define regPCIEMSIX_VECT35_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT35_CONTROL                                                                      0x1e08f
#define regPCIEMSIX_VECT35_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT36_ADDR_LO                                                                      0x1e090
#define regPCIEMSIX_VECT36_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT36_ADDR_HI                                                                      0x1e091
#define regPCIEMSIX_VECT36_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT36_MSG_DATA                                                                     0x1e092
#define regPCIEMSIX_VECT36_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT36_CONTROL                                                                      0x1e093
#define regPCIEMSIX_VECT36_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT37_ADDR_LO                                                                      0x1e094
#define regPCIEMSIX_VECT37_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT37_ADDR_HI                                                                      0x1e095
#define regPCIEMSIX_VECT37_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT37_MSG_DATA                                                                     0x1e096
#define regPCIEMSIX_VECT37_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT37_CONTROL                                                                      0x1e097
#define regPCIEMSIX_VECT37_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT38_ADDR_LO                                                                      0x1e098
#define regPCIEMSIX_VECT38_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT38_ADDR_HI                                                                      0x1e099
#define regPCIEMSIX_VECT38_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT38_MSG_DATA                                                                     0x1e09a
#define regPCIEMSIX_VECT38_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT38_CONTROL                                                                      0x1e09b
#define regPCIEMSIX_VECT38_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT39_ADDR_LO                                                                      0x1e09c
#define regPCIEMSIX_VECT39_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT39_ADDR_HI                                                                      0x1e09d
#define regPCIEMSIX_VECT39_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT39_MSG_DATA                                                                     0x1e09e
#define regPCIEMSIX_VECT39_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT39_CONTROL                                                                      0x1e09f
#define regPCIEMSIX_VECT39_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT40_ADDR_LO                                                                      0x1e0a0
#define regPCIEMSIX_VECT40_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT40_ADDR_HI                                                                      0x1e0a1
#define regPCIEMSIX_VECT40_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT40_MSG_DATA                                                                     0x1e0a2
#define regPCIEMSIX_VECT40_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT40_CONTROL                                                                      0x1e0a3
#define regPCIEMSIX_VECT40_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT41_ADDR_LO                                                                      0x1e0a4
#define regPCIEMSIX_VECT41_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT41_ADDR_HI                                                                      0x1e0a5
#define regPCIEMSIX_VECT41_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT41_MSG_DATA                                                                     0x1e0a6
#define regPCIEMSIX_VECT41_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT41_CONTROL                                                                      0x1e0a7
#define regPCIEMSIX_VECT41_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT42_ADDR_LO                                                                      0x1e0a8
#define regPCIEMSIX_VECT42_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT42_ADDR_HI                                                                      0x1e0a9
#define regPCIEMSIX_VECT42_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT42_MSG_DATA                                                                     0x1e0aa
#define regPCIEMSIX_VECT42_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT42_CONTROL                                                                      0x1e0ab
#define regPCIEMSIX_VECT42_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT43_ADDR_LO                                                                      0x1e0ac
#define regPCIEMSIX_VECT43_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT43_ADDR_HI                                                                      0x1e0ad
#define regPCIEMSIX_VECT43_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT43_MSG_DATA                                                                     0x1e0ae
#define regPCIEMSIX_VECT43_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT43_CONTROL                                                                      0x1e0af
#define regPCIEMSIX_VECT43_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT44_ADDR_LO                                                                      0x1e0b0
#define regPCIEMSIX_VECT44_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT44_ADDR_HI                                                                      0x1e0b1
#define regPCIEMSIX_VECT44_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT44_MSG_DATA                                                                     0x1e0b2
#define regPCIEMSIX_VECT44_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT44_CONTROL                                                                      0x1e0b3
#define regPCIEMSIX_VECT44_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT45_ADDR_LO                                                                      0x1e0b4
#define regPCIEMSIX_VECT45_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT45_ADDR_HI                                                                      0x1e0b5
#define regPCIEMSIX_VECT45_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT45_MSG_DATA                                                                     0x1e0b6
#define regPCIEMSIX_VECT45_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT45_CONTROL                                                                      0x1e0b7
#define regPCIEMSIX_VECT45_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT46_ADDR_LO                                                                      0x1e0b8
#define regPCIEMSIX_VECT46_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT46_ADDR_HI                                                                      0x1e0b9
#define regPCIEMSIX_VECT46_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT46_MSG_DATA                                                                     0x1e0ba
#define regPCIEMSIX_VECT46_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT46_CONTROL                                                                      0x1e0bb
#define regPCIEMSIX_VECT46_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT47_ADDR_LO                                                                      0x1e0bc
#define regPCIEMSIX_VECT47_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT47_ADDR_HI                                                                      0x1e0bd
#define regPCIEMSIX_VECT47_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT47_MSG_DATA                                                                     0x1e0be
#define regPCIEMSIX_VECT47_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT47_CONTROL                                                                      0x1e0bf
#define regPCIEMSIX_VECT47_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT48_ADDR_LO                                                                      0x1e0c0
#define regPCIEMSIX_VECT48_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT48_ADDR_HI                                                                      0x1e0c1
#define regPCIEMSIX_VECT48_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT48_MSG_DATA                                                                     0x1e0c2
#define regPCIEMSIX_VECT48_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT48_CONTROL                                                                      0x1e0c3
#define regPCIEMSIX_VECT48_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT49_ADDR_LO                                                                      0x1e0c4
#define regPCIEMSIX_VECT49_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT49_ADDR_HI                                                                      0x1e0c5
#define regPCIEMSIX_VECT49_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT49_MSG_DATA                                                                     0x1e0c6
#define regPCIEMSIX_VECT49_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT49_CONTROL                                                                      0x1e0c7
#define regPCIEMSIX_VECT49_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT50_ADDR_LO                                                                      0x1e0c8
#define regPCIEMSIX_VECT50_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT50_ADDR_HI                                                                      0x1e0c9
#define regPCIEMSIX_VECT50_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT50_MSG_DATA                                                                     0x1e0ca
#define regPCIEMSIX_VECT50_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT50_CONTROL                                                                      0x1e0cb
#define regPCIEMSIX_VECT50_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT51_ADDR_LO                                                                      0x1e0cc
#define regPCIEMSIX_VECT51_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT51_ADDR_HI                                                                      0x1e0cd
#define regPCIEMSIX_VECT51_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT51_MSG_DATA                                                                     0x1e0ce
#define regPCIEMSIX_VECT51_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT51_CONTROL                                                                      0x1e0cf
#define regPCIEMSIX_VECT51_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT52_ADDR_LO                                                                      0x1e0d0
#define regPCIEMSIX_VECT52_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT52_ADDR_HI                                                                      0x1e0d1
#define regPCIEMSIX_VECT52_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT52_MSG_DATA                                                                     0x1e0d2
#define regPCIEMSIX_VECT52_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT52_CONTROL                                                                      0x1e0d3
#define regPCIEMSIX_VECT52_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT53_ADDR_LO                                                                      0x1e0d4
#define regPCIEMSIX_VECT53_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT53_ADDR_HI                                                                      0x1e0d5
#define regPCIEMSIX_VECT53_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT53_MSG_DATA                                                                     0x1e0d6
#define regPCIEMSIX_VECT53_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT53_CONTROL                                                                      0x1e0d7
#define regPCIEMSIX_VECT53_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT54_ADDR_LO                                                                      0x1e0d8
#define regPCIEMSIX_VECT54_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT54_ADDR_HI                                                                      0x1e0d9
#define regPCIEMSIX_VECT54_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT54_MSG_DATA                                                                     0x1e0da
#define regPCIEMSIX_VECT54_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT54_CONTROL                                                                      0x1e0db
#define regPCIEMSIX_VECT54_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT55_ADDR_LO                                                                      0x1e0dc
#define regPCIEMSIX_VECT55_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT55_ADDR_HI                                                                      0x1e0dd
#define regPCIEMSIX_VECT55_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT55_MSG_DATA                                                                     0x1e0de
#define regPCIEMSIX_VECT55_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT55_CONTROL                                                                      0x1e0df
#define regPCIEMSIX_VECT55_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT56_ADDR_LO                                                                      0x1e0e0
#define regPCIEMSIX_VECT56_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT56_ADDR_HI                                                                      0x1e0e1
#define regPCIEMSIX_VECT56_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT56_MSG_DATA                                                                     0x1e0e2
#define regPCIEMSIX_VECT56_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT56_CONTROL                                                                      0x1e0e3
#define regPCIEMSIX_VECT56_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT57_ADDR_LO                                                                      0x1e0e4
#define regPCIEMSIX_VECT57_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT57_ADDR_HI                                                                      0x1e0e5
#define regPCIEMSIX_VECT57_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT57_MSG_DATA                                                                     0x1e0e6
#define regPCIEMSIX_VECT57_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT57_CONTROL                                                                      0x1e0e7
#define regPCIEMSIX_VECT57_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT58_ADDR_LO                                                                      0x1e0e8
#define regPCIEMSIX_VECT58_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT58_ADDR_HI                                                                      0x1e0e9
#define regPCIEMSIX_VECT58_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT58_MSG_DATA                                                                     0x1e0ea
#define regPCIEMSIX_VECT58_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT58_CONTROL                                                                      0x1e0eb
#define regPCIEMSIX_VECT58_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT59_ADDR_LO                                                                      0x1e0ec
#define regPCIEMSIX_VECT59_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT59_ADDR_HI                                                                      0x1e0ed
#define regPCIEMSIX_VECT59_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT59_MSG_DATA                                                                     0x1e0ee
#define regPCIEMSIX_VECT59_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT59_CONTROL                                                                      0x1e0ef
#define regPCIEMSIX_VECT59_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT60_ADDR_LO                                                                      0x1e0f0
#define regPCIEMSIX_VECT60_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT60_ADDR_HI                                                                      0x1e0f1
#define regPCIEMSIX_VECT60_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT60_MSG_DATA                                                                     0x1e0f2
#define regPCIEMSIX_VECT60_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT60_CONTROL                                                                      0x1e0f3
#define regPCIEMSIX_VECT60_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT61_ADDR_LO                                                                      0x1e0f4
#define regPCIEMSIX_VECT61_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT61_ADDR_HI                                                                      0x1e0f5
#define regPCIEMSIX_VECT61_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT61_MSG_DATA                                                                     0x1e0f6
#define regPCIEMSIX_VECT61_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT61_CONTROL                                                                      0x1e0f7
#define regPCIEMSIX_VECT61_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT62_ADDR_LO                                                                      0x1e0f8
#define regPCIEMSIX_VECT62_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT62_ADDR_HI                                                                      0x1e0f9
#define regPCIEMSIX_VECT62_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT62_MSG_DATA                                                                     0x1e0fa
#define regPCIEMSIX_VECT62_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT62_CONTROL                                                                      0x1e0fb
#define regPCIEMSIX_VECT62_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT63_ADDR_LO                                                                      0x1e0fc
#define regPCIEMSIX_VECT63_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT63_ADDR_HI                                                                      0x1e0fd
#define regPCIEMSIX_VECT63_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT63_MSG_DATA                                                                     0x1e0fe
#define regPCIEMSIX_VECT63_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT63_CONTROL                                                                      0x1e0ff
#define regPCIEMSIX_VECT63_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT64_ADDR_LO                                                                      0x1e100
#define regPCIEMSIX_VECT64_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT64_ADDR_HI                                                                      0x1e101
#define regPCIEMSIX_VECT64_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT64_MSG_DATA                                                                     0x1e102
#define regPCIEMSIX_VECT64_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT64_CONTROL                                                                      0x1e103
#define regPCIEMSIX_VECT64_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT65_ADDR_LO                                                                      0x1e104
#define regPCIEMSIX_VECT65_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT65_ADDR_HI                                                                      0x1e105
#define regPCIEMSIX_VECT65_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT65_MSG_DATA                                                                     0x1e106
#define regPCIEMSIX_VECT65_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT65_CONTROL                                                                      0x1e107
#define regPCIEMSIX_VECT65_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT66_ADDR_LO                                                                      0x1e108
#define regPCIEMSIX_VECT66_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT66_ADDR_HI                                                                      0x1e109
#define regPCIEMSIX_VECT66_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT66_MSG_DATA                                                                     0x1e10a
#define regPCIEMSIX_VECT66_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT66_CONTROL                                                                      0x1e10b
#define regPCIEMSIX_VECT66_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT67_ADDR_LO                                                                      0x1e10c
#define regPCIEMSIX_VECT67_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT67_ADDR_HI                                                                      0x1e10d
#define regPCIEMSIX_VECT67_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT67_MSG_DATA                                                                     0x1e10e
#define regPCIEMSIX_VECT67_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT67_CONTROL                                                                      0x1e10f
#define regPCIEMSIX_VECT67_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT68_ADDR_LO                                                                      0x1e110
#define regPCIEMSIX_VECT68_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT68_ADDR_HI                                                                      0x1e111
#define regPCIEMSIX_VECT68_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT68_MSG_DATA                                                                     0x1e112
#define regPCIEMSIX_VECT68_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT68_CONTROL                                                                      0x1e113
#define regPCIEMSIX_VECT68_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT69_ADDR_LO                                                                      0x1e114
#define regPCIEMSIX_VECT69_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT69_ADDR_HI                                                                      0x1e115
#define regPCIEMSIX_VECT69_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT69_MSG_DATA                                                                     0x1e116
#define regPCIEMSIX_VECT69_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT69_CONTROL                                                                      0x1e117
#define regPCIEMSIX_VECT69_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT70_ADDR_LO                                                                      0x1e118
#define regPCIEMSIX_VECT70_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT70_ADDR_HI                                                                      0x1e119
#define regPCIEMSIX_VECT70_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT70_MSG_DATA                                                                     0x1e11a
#define regPCIEMSIX_VECT70_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT70_CONTROL                                                                      0x1e11b
#define regPCIEMSIX_VECT70_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT71_ADDR_LO                                                                      0x1e11c
#define regPCIEMSIX_VECT71_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT71_ADDR_HI                                                                      0x1e11d
#define regPCIEMSIX_VECT71_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT71_MSG_DATA                                                                     0x1e11e
#define regPCIEMSIX_VECT71_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT71_CONTROL                                                                      0x1e11f
#define regPCIEMSIX_VECT71_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT72_ADDR_LO                                                                      0x1e120
#define regPCIEMSIX_VECT72_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT72_ADDR_HI                                                                      0x1e121
#define regPCIEMSIX_VECT72_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT72_MSG_DATA                                                                     0x1e122
#define regPCIEMSIX_VECT72_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT72_CONTROL                                                                      0x1e123
#define regPCIEMSIX_VECT72_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT73_ADDR_LO                                                                      0x1e124
#define regPCIEMSIX_VECT73_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT73_ADDR_HI                                                                      0x1e125
#define regPCIEMSIX_VECT73_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT73_MSG_DATA                                                                     0x1e126
#define regPCIEMSIX_VECT73_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT73_CONTROL                                                                      0x1e127
#define regPCIEMSIX_VECT73_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT74_ADDR_LO                                                                      0x1e128
#define regPCIEMSIX_VECT74_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT74_ADDR_HI                                                                      0x1e129
#define regPCIEMSIX_VECT74_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT74_MSG_DATA                                                                     0x1e12a
#define regPCIEMSIX_VECT74_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT74_CONTROL                                                                      0x1e12b
#define regPCIEMSIX_VECT74_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT75_ADDR_LO                                                                      0x1e12c
#define regPCIEMSIX_VECT75_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT75_ADDR_HI                                                                      0x1e12d
#define regPCIEMSIX_VECT75_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT75_MSG_DATA                                                                     0x1e12e
#define regPCIEMSIX_VECT75_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT75_CONTROL                                                                      0x1e12f
#define regPCIEMSIX_VECT75_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT76_ADDR_LO                                                                      0x1e130
#define regPCIEMSIX_VECT76_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT76_ADDR_HI                                                                      0x1e131
#define regPCIEMSIX_VECT76_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT76_MSG_DATA                                                                     0x1e132
#define regPCIEMSIX_VECT76_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT76_CONTROL                                                                      0x1e133
#define regPCIEMSIX_VECT76_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT77_ADDR_LO                                                                      0x1e134
#define regPCIEMSIX_VECT77_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT77_ADDR_HI                                                                      0x1e135
#define regPCIEMSIX_VECT77_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT77_MSG_DATA                                                                     0x1e136
#define regPCIEMSIX_VECT77_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT77_CONTROL                                                                      0x1e137
#define regPCIEMSIX_VECT77_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT78_ADDR_LO                                                                      0x1e138
#define regPCIEMSIX_VECT78_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT78_ADDR_HI                                                                      0x1e139
#define regPCIEMSIX_VECT78_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT78_MSG_DATA                                                                     0x1e13a
#define regPCIEMSIX_VECT78_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT78_CONTROL                                                                      0x1e13b
#define regPCIEMSIX_VECT78_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT79_ADDR_LO                                                                      0x1e13c
#define regPCIEMSIX_VECT79_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT79_ADDR_HI                                                                      0x1e13d
#define regPCIEMSIX_VECT79_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT79_MSG_DATA                                                                     0x1e13e
#define regPCIEMSIX_VECT79_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT79_CONTROL                                                                      0x1e13f
#define regPCIEMSIX_VECT79_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT80_ADDR_LO                                                                      0x1e140
#define regPCIEMSIX_VECT80_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT80_ADDR_HI                                                                      0x1e141
#define regPCIEMSIX_VECT80_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT80_MSG_DATA                                                                     0x1e142
#define regPCIEMSIX_VECT80_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT80_CONTROL                                                                      0x1e143
#define regPCIEMSIX_VECT80_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT81_ADDR_LO                                                                      0x1e144
#define regPCIEMSIX_VECT81_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT81_ADDR_HI                                                                      0x1e145
#define regPCIEMSIX_VECT81_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT81_MSG_DATA                                                                     0x1e146
#define regPCIEMSIX_VECT81_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT81_CONTROL                                                                      0x1e147
#define regPCIEMSIX_VECT81_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT82_ADDR_LO                                                                      0x1e148
#define regPCIEMSIX_VECT82_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT82_ADDR_HI                                                                      0x1e149
#define regPCIEMSIX_VECT82_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT82_MSG_DATA                                                                     0x1e14a
#define regPCIEMSIX_VECT82_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT82_CONTROL                                                                      0x1e14b
#define regPCIEMSIX_VECT82_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT83_ADDR_LO                                                                      0x1e14c
#define regPCIEMSIX_VECT83_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT83_ADDR_HI                                                                      0x1e14d
#define regPCIEMSIX_VECT83_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT83_MSG_DATA                                                                     0x1e14e
#define regPCIEMSIX_VECT83_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT83_CONTROL                                                                      0x1e14f
#define regPCIEMSIX_VECT83_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT84_ADDR_LO                                                                      0x1e150
#define regPCIEMSIX_VECT84_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT84_ADDR_HI                                                                      0x1e151
#define regPCIEMSIX_VECT84_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT84_MSG_DATA                                                                     0x1e152
#define regPCIEMSIX_VECT84_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT84_CONTROL                                                                      0x1e153
#define regPCIEMSIX_VECT84_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT85_ADDR_LO                                                                      0x1e154
#define regPCIEMSIX_VECT85_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT85_ADDR_HI                                                                      0x1e155
#define regPCIEMSIX_VECT85_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT85_MSG_DATA                                                                     0x1e156
#define regPCIEMSIX_VECT85_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT85_CONTROL                                                                      0x1e157
#define regPCIEMSIX_VECT85_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT86_ADDR_LO                                                                      0x1e158
#define regPCIEMSIX_VECT86_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT86_ADDR_HI                                                                      0x1e159
#define regPCIEMSIX_VECT86_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT86_MSG_DATA                                                                     0x1e15a
#define regPCIEMSIX_VECT86_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT86_CONTROL                                                                      0x1e15b
#define regPCIEMSIX_VECT86_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT87_ADDR_LO                                                                      0x1e15c
#define regPCIEMSIX_VECT87_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT87_ADDR_HI                                                                      0x1e15d
#define regPCIEMSIX_VECT87_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT87_MSG_DATA                                                                     0x1e15e
#define regPCIEMSIX_VECT87_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT87_CONTROL                                                                      0x1e15f
#define regPCIEMSIX_VECT87_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT88_ADDR_LO                                                                      0x1e160
#define regPCIEMSIX_VECT88_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT88_ADDR_HI                                                                      0x1e161
#define regPCIEMSIX_VECT88_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT88_MSG_DATA                                                                     0x1e162
#define regPCIEMSIX_VECT88_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT88_CONTROL                                                                      0x1e163
#define regPCIEMSIX_VECT88_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT89_ADDR_LO                                                                      0x1e164
#define regPCIEMSIX_VECT89_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT89_ADDR_HI                                                                      0x1e165
#define regPCIEMSIX_VECT89_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT89_MSG_DATA                                                                     0x1e166
#define regPCIEMSIX_VECT89_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT89_CONTROL                                                                      0x1e167
#define regPCIEMSIX_VECT89_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT90_ADDR_LO                                                                      0x1e168
#define regPCIEMSIX_VECT90_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT90_ADDR_HI                                                                      0x1e169
#define regPCIEMSIX_VECT90_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT90_MSG_DATA                                                                     0x1e16a
#define regPCIEMSIX_VECT90_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT90_CONTROL                                                                      0x1e16b
#define regPCIEMSIX_VECT90_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT91_ADDR_LO                                                                      0x1e16c
#define regPCIEMSIX_VECT91_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT91_ADDR_HI                                                                      0x1e16d
#define regPCIEMSIX_VECT91_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT91_MSG_DATA                                                                     0x1e16e
#define regPCIEMSIX_VECT91_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT91_CONTROL                                                                      0x1e16f
#define regPCIEMSIX_VECT91_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT92_ADDR_LO                                                                      0x1e170
#define regPCIEMSIX_VECT92_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT92_ADDR_HI                                                                      0x1e171
#define regPCIEMSIX_VECT92_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT92_MSG_DATA                                                                     0x1e172
#define regPCIEMSIX_VECT92_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT92_CONTROL                                                                      0x1e173
#define regPCIEMSIX_VECT92_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT93_ADDR_LO                                                                      0x1e174
#define regPCIEMSIX_VECT93_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT93_ADDR_HI                                                                      0x1e175
#define regPCIEMSIX_VECT93_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT93_MSG_DATA                                                                     0x1e176
#define regPCIEMSIX_VECT93_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT93_CONTROL                                                                      0x1e177
#define regPCIEMSIX_VECT93_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT94_ADDR_LO                                                                      0x1e178
#define regPCIEMSIX_VECT94_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT94_ADDR_HI                                                                      0x1e179
#define regPCIEMSIX_VECT94_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT94_MSG_DATA                                                                     0x1e17a
#define regPCIEMSIX_VECT94_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT94_CONTROL                                                                      0x1e17b
#define regPCIEMSIX_VECT94_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT95_ADDR_LO                                                                      0x1e17c
#define regPCIEMSIX_VECT95_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT95_ADDR_HI                                                                      0x1e17d
#define regPCIEMSIX_VECT95_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT95_MSG_DATA                                                                     0x1e17e
#define regPCIEMSIX_VECT95_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT95_CONTROL                                                                      0x1e17f
#define regPCIEMSIX_VECT95_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT96_ADDR_LO                                                                      0x1e180
#define regPCIEMSIX_VECT96_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT96_ADDR_HI                                                                      0x1e181
#define regPCIEMSIX_VECT96_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT96_MSG_DATA                                                                     0x1e182
#define regPCIEMSIX_VECT96_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT96_CONTROL                                                                      0x1e183
#define regPCIEMSIX_VECT96_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT97_ADDR_LO                                                                      0x1e184
#define regPCIEMSIX_VECT97_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT97_ADDR_HI                                                                      0x1e185
#define regPCIEMSIX_VECT97_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT97_MSG_DATA                                                                     0x1e186
#define regPCIEMSIX_VECT97_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT97_CONTROL                                                                      0x1e187
#define regPCIEMSIX_VECT97_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT98_ADDR_LO                                                                      0x1e188
#define regPCIEMSIX_VECT98_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT98_ADDR_HI                                                                      0x1e189
#define regPCIEMSIX_VECT98_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT98_MSG_DATA                                                                     0x1e18a
#define regPCIEMSIX_VECT98_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT98_CONTROL                                                                      0x1e18b
#define regPCIEMSIX_VECT98_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT99_ADDR_LO                                                                      0x1e18c
#define regPCIEMSIX_VECT99_ADDR_LO_BASE_IDX                                                             5
#define regPCIEMSIX_VECT99_ADDR_HI                                                                      0x1e18d
#define regPCIEMSIX_VECT99_ADDR_HI_BASE_IDX                                                             5
#define regPCIEMSIX_VECT99_MSG_DATA                                                                     0x1e18e
#define regPCIEMSIX_VECT99_MSG_DATA_BASE_IDX                                                            5
#define regPCIEMSIX_VECT99_CONTROL                                                                      0x1e18f
#define regPCIEMSIX_VECT99_CONTROL_BASE_IDX                                                             5
#define regPCIEMSIX_VECT100_ADDR_LO                                                                     0x1e190
#define regPCIEMSIX_VECT100_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT100_ADDR_HI                                                                     0x1e191
#define regPCIEMSIX_VECT100_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT100_MSG_DATA                                                                    0x1e192
#define regPCIEMSIX_VECT100_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT100_CONTROL                                                                     0x1e193
#define regPCIEMSIX_VECT100_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT101_ADDR_LO                                                                     0x1e194
#define regPCIEMSIX_VECT101_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT101_ADDR_HI                                                                     0x1e195
#define regPCIEMSIX_VECT101_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT101_MSG_DATA                                                                    0x1e196
#define regPCIEMSIX_VECT101_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT101_CONTROL                                                                     0x1e197
#define regPCIEMSIX_VECT101_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT102_ADDR_LO                                                                     0x1e198
#define regPCIEMSIX_VECT102_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT102_ADDR_HI                                                                     0x1e199
#define regPCIEMSIX_VECT102_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT102_MSG_DATA                                                                    0x1e19a
#define regPCIEMSIX_VECT102_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT102_CONTROL                                                                     0x1e19b
#define regPCIEMSIX_VECT102_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT103_ADDR_LO                                                                     0x1e19c
#define regPCIEMSIX_VECT103_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT103_ADDR_HI                                                                     0x1e19d
#define regPCIEMSIX_VECT103_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT103_MSG_DATA                                                                    0x1e19e
#define regPCIEMSIX_VECT103_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT103_CONTROL                                                                     0x1e19f
#define regPCIEMSIX_VECT103_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT104_ADDR_LO                                                                     0x1e1a0
#define regPCIEMSIX_VECT104_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT104_ADDR_HI                                                                     0x1e1a1
#define regPCIEMSIX_VECT104_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT104_MSG_DATA                                                                    0x1e1a2
#define regPCIEMSIX_VECT104_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT104_CONTROL                                                                     0x1e1a3
#define regPCIEMSIX_VECT104_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT105_ADDR_LO                                                                     0x1e1a4
#define regPCIEMSIX_VECT105_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT105_ADDR_HI                                                                     0x1e1a5
#define regPCIEMSIX_VECT105_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT105_MSG_DATA                                                                    0x1e1a6
#define regPCIEMSIX_VECT105_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT105_CONTROL                                                                     0x1e1a7
#define regPCIEMSIX_VECT105_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT106_ADDR_LO                                                                     0x1e1a8
#define regPCIEMSIX_VECT106_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT106_ADDR_HI                                                                     0x1e1a9
#define regPCIEMSIX_VECT106_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT106_MSG_DATA                                                                    0x1e1aa
#define regPCIEMSIX_VECT106_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT106_CONTROL                                                                     0x1e1ab
#define regPCIEMSIX_VECT106_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT107_ADDR_LO                                                                     0x1e1ac
#define regPCIEMSIX_VECT107_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT107_ADDR_HI                                                                     0x1e1ad
#define regPCIEMSIX_VECT107_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT107_MSG_DATA                                                                    0x1e1ae
#define regPCIEMSIX_VECT107_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT107_CONTROL                                                                     0x1e1af
#define regPCIEMSIX_VECT107_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT108_ADDR_LO                                                                     0x1e1b0
#define regPCIEMSIX_VECT108_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT108_ADDR_HI                                                                     0x1e1b1
#define regPCIEMSIX_VECT108_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT108_MSG_DATA                                                                    0x1e1b2
#define regPCIEMSIX_VECT108_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT108_CONTROL                                                                     0x1e1b3
#define regPCIEMSIX_VECT108_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT109_ADDR_LO                                                                     0x1e1b4
#define regPCIEMSIX_VECT109_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT109_ADDR_HI                                                                     0x1e1b5
#define regPCIEMSIX_VECT109_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT109_MSG_DATA                                                                    0x1e1b6
#define regPCIEMSIX_VECT109_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT109_CONTROL                                                                     0x1e1b7
#define regPCIEMSIX_VECT109_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT110_ADDR_LO                                                                     0x1e1b8
#define regPCIEMSIX_VECT110_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT110_ADDR_HI                                                                     0x1e1b9
#define regPCIEMSIX_VECT110_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT110_MSG_DATA                                                                    0x1e1ba
#define regPCIEMSIX_VECT110_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT110_CONTROL                                                                     0x1e1bb
#define regPCIEMSIX_VECT110_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT111_ADDR_LO                                                                     0x1e1bc
#define regPCIEMSIX_VECT111_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT111_ADDR_HI                                                                     0x1e1bd
#define regPCIEMSIX_VECT111_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT111_MSG_DATA                                                                    0x1e1be
#define regPCIEMSIX_VECT111_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT111_CONTROL                                                                     0x1e1bf
#define regPCIEMSIX_VECT111_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT112_ADDR_LO                                                                     0x1e1c0
#define regPCIEMSIX_VECT112_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT112_ADDR_HI                                                                     0x1e1c1
#define regPCIEMSIX_VECT112_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT112_MSG_DATA                                                                    0x1e1c2
#define regPCIEMSIX_VECT112_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT112_CONTROL                                                                     0x1e1c3
#define regPCIEMSIX_VECT112_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT113_ADDR_LO                                                                     0x1e1c4
#define regPCIEMSIX_VECT113_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT113_ADDR_HI                                                                     0x1e1c5
#define regPCIEMSIX_VECT113_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT113_MSG_DATA                                                                    0x1e1c6
#define regPCIEMSIX_VECT113_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT113_CONTROL                                                                     0x1e1c7
#define regPCIEMSIX_VECT113_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT114_ADDR_LO                                                                     0x1e1c8
#define regPCIEMSIX_VECT114_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT114_ADDR_HI                                                                     0x1e1c9
#define regPCIEMSIX_VECT114_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT114_MSG_DATA                                                                    0x1e1ca
#define regPCIEMSIX_VECT114_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT114_CONTROL                                                                     0x1e1cb
#define regPCIEMSIX_VECT114_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT115_ADDR_LO                                                                     0x1e1cc
#define regPCIEMSIX_VECT115_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT115_ADDR_HI                                                                     0x1e1cd
#define regPCIEMSIX_VECT115_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT115_MSG_DATA                                                                    0x1e1ce
#define regPCIEMSIX_VECT115_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT115_CONTROL                                                                     0x1e1cf
#define regPCIEMSIX_VECT115_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT116_ADDR_LO                                                                     0x1e1d0
#define regPCIEMSIX_VECT116_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT116_ADDR_HI                                                                     0x1e1d1
#define regPCIEMSIX_VECT116_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT116_MSG_DATA                                                                    0x1e1d2
#define regPCIEMSIX_VECT116_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT116_CONTROL                                                                     0x1e1d3
#define regPCIEMSIX_VECT116_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT117_ADDR_LO                                                                     0x1e1d4
#define regPCIEMSIX_VECT117_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT117_ADDR_HI                                                                     0x1e1d5
#define regPCIEMSIX_VECT117_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT117_MSG_DATA                                                                    0x1e1d6
#define regPCIEMSIX_VECT117_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT117_CONTROL                                                                     0x1e1d7
#define regPCIEMSIX_VECT117_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT118_ADDR_LO                                                                     0x1e1d8
#define regPCIEMSIX_VECT118_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT118_ADDR_HI                                                                     0x1e1d9
#define regPCIEMSIX_VECT118_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT118_MSG_DATA                                                                    0x1e1da
#define regPCIEMSIX_VECT118_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT118_CONTROL                                                                     0x1e1db
#define regPCIEMSIX_VECT118_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT119_ADDR_LO                                                                     0x1e1dc
#define regPCIEMSIX_VECT119_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT119_ADDR_HI                                                                     0x1e1dd
#define regPCIEMSIX_VECT119_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT119_MSG_DATA                                                                    0x1e1de
#define regPCIEMSIX_VECT119_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT119_CONTROL                                                                     0x1e1df
#define regPCIEMSIX_VECT119_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT120_ADDR_LO                                                                     0x1e1e0
#define regPCIEMSIX_VECT120_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT120_ADDR_HI                                                                     0x1e1e1
#define regPCIEMSIX_VECT120_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT120_MSG_DATA                                                                    0x1e1e2
#define regPCIEMSIX_VECT120_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT120_CONTROL                                                                     0x1e1e3
#define regPCIEMSIX_VECT120_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT121_ADDR_LO                                                                     0x1e1e4
#define regPCIEMSIX_VECT121_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT121_ADDR_HI                                                                     0x1e1e5
#define regPCIEMSIX_VECT121_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT121_MSG_DATA                                                                    0x1e1e6
#define regPCIEMSIX_VECT121_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT121_CONTROL                                                                     0x1e1e7
#define regPCIEMSIX_VECT121_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT122_ADDR_LO                                                                     0x1e1e8
#define regPCIEMSIX_VECT122_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT122_ADDR_HI                                                                     0x1e1e9
#define regPCIEMSIX_VECT122_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT122_MSG_DATA                                                                    0x1e1ea
#define regPCIEMSIX_VECT122_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT122_CONTROL                                                                     0x1e1eb
#define regPCIEMSIX_VECT122_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT123_ADDR_LO                                                                     0x1e1ec
#define regPCIEMSIX_VECT123_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT123_ADDR_HI                                                                     0x1e1ed
#define regPCIEMSIX_VECT123_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT123_MSG_DATA                                                                    0x1e1ee
#define regPCIEMSIX_VECT123_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT123_CONTROL                                                                     0x1e1ef
#define regPCIEMSIX_VECT123_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT124_ADDR_LO                                                                     0x1e1f0
#define regPCIEMSIX_VECT124_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT124_ADDR_HI                                                                     0x1e1f1
#define regPCIEMSIX_VECT124_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT124_MSG_DATA                                                                    0x1e1f2
#define regPCIEMSIX_VECT124_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT124_CONTROL                                                                     0x1e1f3
#define regPCIEMSIX_VECT124_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT125_ADDR_LO                                                                     0x1e1f4
#define regPCIEMSIX_VECT125_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT125_ADDR_HI                                                                     0x1e1f5
#define regPCIEMSIX_VECT125_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT125_MSG_DATA                                                                    0x1e1f6
#define regPCIEMSIX_VECT125_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT125_CONTROL                                                                     0x1e1f7
#define regPCIEMSIX_VECT125_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT126_ADDR_LO                                                                     0x1e1f8
#define regPCIEMSIX_VECT126_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT126_ADDR_HI                                                                     0x1e1f9
#define regPCIEMSIX_VECT126_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT126_MSG_DATA                                                                    0x1e1fa
#define regPCIEMSIX_VECT126_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT126_CONTROL                                                                     0x1e1fb
#define regPCIEMSIX_VECT126_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT127_ADDR_LO                                                                     0x1e1fc
#define regPCIEMSIX_VECT127_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT127_ADDR_HI                                                                     0x1e1fd
#define regPCIEMSIX_VECT127_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT127_MSG_DATA                                                                    0x1e1fe
#define regPCIEMSIX_VECT127_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT127_CONTROL                                                                     0x1e1ff
#define regPCIEMSIX_VECT127_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT128_ADDR_LO                                                                     0x1e200
#define regPCIEMSIX_VECT128_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT128_ADDR_HI                                                                     0x1e201
#define regPCIEMSIX_VECT128_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT128_MSG_DATA                                                                    0x1e202
#define regPCIEMSIX_VECT128_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT128_CONTROL                                                                     0x1e203
#define regPCIEMSIX_VECT128_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT129_ADDR_LO                                                                     0x1e204
#define regPCIEMSIX_VECT129_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT129_ADDR_HI                                                                     0x1e205
#define regPCIEMSIX_VECT129_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT129_MSG_DATA                                                                    0x1e206
#define regPCIEMSIX_VECT129_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT129_CONTROL                                                                     0x1e207
#define regPCIEMSIX_VECT129_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT130_ADDR_LO                                                                     0x1e208
#define regPCIEMSIX_VECT130_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT130_ADDR_HI                                                                     0x1e209
#define regPCIEMSIX_VECT130_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT130_MSG_DATA                                                                    0x1e20a
#define regPCIEMSIX_VECT130_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT130_CONTROL                                                                     0x1e20b
#define regPCIEMSIX_VECT130_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT131_ADDR_LO                                                                     0x1e20c
#define regPCIEMSIX_VECT131_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT131_ADDR_HI                                                                     0x1e20d
#define regPCIEMSIX_VECT131_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT131_MSG_DATA                                                                    0x1e20e
#define regPCIEMSIX_VECT131_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT131_CONTROL                                                                     0x1e20f
#define regPCIEMSIX_VECT131_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT132_ADDR_LO                                                                     0x1e210
#define regPCIEMSIX_VECT132_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT132_ADDR_HI                                                                     0x1e211
#define regPCIEMSIX_VECT132_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT132_MSG_DATA                                                                    0x1e212
#define regPCIEMSIX_VECT132_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT132_CONTROL                                                                     0x1e213
#define regPCIEMSIX_VECT132_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT133_ADDR_LO                                                                     0x1e214
#define regPCIEMSIX_VECT133_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT133_ADDR_HI                                                                     0x1e215
#define regPCIEMSIX_VECT133_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT133_MSG_DATA                                                                    0x1e216
#define regPCIEMSIX_VECT133_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT133_CONTROL                                                                     0x1e217
#define regPCIEMSIX_VECT133_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT134_ADDR_LO                                                                     0x1e218
#define regPCIEMSIX_VECT134_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT134_ADDR_HI                                                                     0x1e219
#define regPCIEMSIX_VECT134_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT134_MSG_DATA                                                                    0x1e21a
#define regPCIEMSIX_VECT134_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT134_CONTROL                                                                     0x1e21b
#define regPCIEMSIX_VECT134_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT135_ADDR_LO                                                                     0x1e21c
#define regPCIEMSIX_VECT135_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT135_ADDR_HI                                                                     0x1e21d
#define regPCIEMSIX_VECT135_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT135_MSG_DATA                                                                    0x1e21e
#define regPCIEMSIX_VECT135_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT135_CONTROL                                                                     0x1e21f
#define regPCIEMSIX_VECT135_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT136_ADDR_LO                                                                     0x1e220
#define regPCIEMSIX_VECT136_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT136_ADDR_HI                                                                     0x1e221
#define regPCIEMSIX_VECT136_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT136_MSG_DATA                                                                    0x1e222
#define regPCIEMSIX_VECT136_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT136_CONTROL                                                                     0x1e223
#define regPCIEMSIX_VECT136_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT137_ADDR_LO                                                                     0x1e224
#define regPCIEMSIX_VECT137_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT137_ADDR_HI                                                                     0x1e225
#define regPCIEMSIX_VECT137_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT137_MSG_DATA                                                                    0x1e226
#define regPCIEMSIX_VECT137_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT137_CONTROL                                                                     0x1e227
#define regPCIEMSIX_VECT137_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT138_ADDR_LO                                                                     0x1e228
#define regPCIEMSIX_VECT138_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT138_ADDR_HI                                                                     0x1e229
#define regPCIEMSIX_VECT138_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT138_MSG_DATA                                                                    0x1e22a
#define regPCIEMSIX_VECT138_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT138_CONTROL                                                                     0x1e22b
#define regPCIEMSIX_VECT138_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT139_ADDR_LO                                                                     0x1e22c
#define regPCIEMSIX_VECT139_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT139_ADDR_HI                                                                     0x1e22d
#define regPCIEMSIX_VECT139_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT139_MSG_DATA                                                                    0x1e22e
#define regPCIEMSIX_VECT139_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT139_CONTROL                                                                     0x1e22f
#define regPCIEMSIX_VECT139_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT140_ADDR_LO                                                                     0x1e230
#define regPCIEMSIX_VECT140_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT140_ADDR_HI                                                                     0x1e231
#define regPCIEMSIX_VECT140_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT140_MSG_DATA                                                                    0x1e232
#define regPCIEMSIX_VECT140_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT140_CONTROL                                                                     0x1e233
#define regPCIEMSIX_VECT140_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT141_ADDR_LO                                                                     0x1e234
#define regPCIEMSIX_VECT141_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT141_ADDR_HI                                                                     0x1e235
#define regPCIEMSIX_VECT141_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT141_MSG_DATA                                                                    0x1e236
#define regPCIEMSIX_VECT141_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT141_CONTROL                                                                     0x1e237
#define regPCIEMSIX_VECT141_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT142_ADDR_LO                                                                     0x1e238
#define regPCIEMSIX_VECT142_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT142_ADDR_HI                                                                     0x1e239
#define regPCIEMSIX_VECT142_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT142_MSG_DATA                                                                    0x1e23a
#define regPCIEMSIX_VECT142_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT142_CONTROL                                                                     0x1e23b
#define regPCIEMSIX_VECT142_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT143_ADDR_LO                                                                     0x1e23c
#define regPCIEMSIX_VECT143_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT143_ADDR_HI                                                                     0x1e23d
#define regPCIEMSIX_VECT143_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT143_MSG_DATA                                                                    0x1e23e
#define regPCIEMSIX_VECT143_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT143_CONTROL                                                                     0x1e23f
#define regPCIEMSIX_VECT143_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT144_ADDR_LO                                                                     0x1e240
#define regPCIEMSIX_VECT144_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT144_ADDR_HI                                                                     0x1e241
#define regPCIEMSIX_VECT144_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT144_MSG_DATA                                                                    0x1e242
#define regPCIEMSIX_VECT144_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT144_CONTROL                                                                     0x1e243
#define regPCIEMSIX_VECT144_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT145_ADDR_LO                                                                     0x1e244
#define regPCIEMSIX_VECT145_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT145_ADDR_HI                                                                     0x1e245
#define regPCIEMSIX_VECT145_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT145_MSG_DATA                                                                    0x1e246
#define regPCIEMSIX_VECT145_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT145_CONTROL                                                                     0x1e247
#define regPCIEMSIX_VECT145_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT146_ADDR_LO                                                                     0x1e248
#define regPCIEMSIX_VECT146_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT146_ADDR_HI                                                                     0x1e249
#define regPCIEMSIX_VECT146_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT146_MSG_DATA                                                                    0x1e24a
#define regPCIEMSIX_VECT146_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT146_CONTROL                                                                     0x1e24b
#define regPCIEMSIX_VECT146_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT147_ADDR_LO                                                                     0x1e24c
#define regPCIEMSIX_VECT147_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT147_ADDR_HI                                                                     0x1e24d
#define regPCIEMSIX_VECT147_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT147_MSG_DATA                                                                    0x1e24e
#define regPCIEMSIX_VECT147_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT147_CONTROL                                                                     0x1e24f
#define regPCIEMSIX_VECT147_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT148_ADDR_LO                                                                     0x1e250
#define regPCIEMSIX_VECT148_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT148_ADDR_HI                                                                     0x1e251
#define regPCIEMSIX_VECT148_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT148_MSG_DATA                                                                    0x1e252
#define regPCIEMSIX_VECT148_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT148_CONTROL                                                                     0x1e253
#define regPCIEMSIX_VECT148_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT149_ADDR_LO                                                                     0x1e254
#define regPCIEMSIX_VECT149_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT149_ADDR_HI                                                                     0x1e255
#define regPCIEMSIX_VECT149_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT149_MSG_DATA                                                                    0x1e256
#define regPCIEMSIX_VECT149_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT149_CONTROL                                                                     0x1e257
#define regPCIEMSIX_VECT149_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT150_ADDR_LO                                                                     0x1e258
#define regPCIEMSIX_VECT150_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT150_ADDR_HI                                                                     0x1e259
#define regPCIEMSIX_VECT150_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT150_MSG_DATA                                                                    0x1e25a
#define regPCIEMSIX_VECT150_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT150_CONTROL                                                                     0x1e25b
#define regPCIEMSIX_VECT150_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT151_ADDR_LO                                                                     0x1e25c
#define regPCIEMSIX_VECT151_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT151_ADDR_HI                                                                     0x1e25d
#define regPCIEMSIX_VECT151_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT151_MSG_DATA                                                                    0x1e25e
#define regPCIEMSIX_VECT151_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT151_CONTROL                                                                     0x1e25f
#define regPCIEMSIX_VECT151_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT152_ADDR_LO                                                                     0x1e260
#define regPCIEMSIX_VECT152_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT152_ADDR_HI                                                                     0x1e261
#define regPCIEMSIX_VECT152_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT152_MSG_DATA                                                                    0x1e262
#define regPCIEMSIX_VECT152_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT152_CONTROL                                                                     0x1e263
#define regPCIEMSIX_VECT152_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT153_ADDR_LO                                                                     0x1e264
#define regPCIEMSIX_VECT153_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT153_ADDR_HI                                                                     0x1e265
#define regPCIEMSIX_VECT153_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT153_MSG_DATA                                                                    0x1e266
#define regPCIEMSIX_VECT153_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT153_CONTROL                                                                     0x1e267
#define regPCIEMSIX_VECT153_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT154_ADDR_LO                                                                     0x1e268
#define regPCIEMSIX_VECT154_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT154_ADDR_HI                                                                     0x1e269
#define regPCIEMSIX_VECT154_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT154_MSG_DATA                                                                    0x1e26a
#define regPCIEMSIX_VECT154_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT154_CONTROL                                                                     0x1e26b
#define regPCIEMSIX_VECT154_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT155_ADDR_LO                                                                     0x1e26c
#define regPCIEMSIX_VECT155_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT155_ADDR_HI                                                                     0x1e26d
#define regPCIEMSIX_VECT155_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT155_MSG_DATA                                                                    0x1e26e
#define regPCIEMSIX_VECT155_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT155_CONTROL                                                                     0x1e26f
#define regPCIEMSIX_VECT155_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT156_ADDR_LO                                                                     0x1e270
#define regPCIEMSIX_VECT156_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT156_ADDR_HI                                                                     0x1e271
#define regPCIEMSIX_VECT156_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT156_MSG_DATA                                                                    0x1e272
#define regPCIEMSIX_VECT156_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT156_CONTROL                                                                     0x1e273
#define regPCIEMSIX_VECT156_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT157_ADDR_LO                                                                     0x1e274
#define regPCIEMSIX_VECT157_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT157_ADDR_HI                                                                     0x1e275
#define regPCIEMSIX_VECT157_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT157_MSG_DATA                                                                    0x1e276
#define regPCIEMSIX_VECT157_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT157_CONTROL                                                                     0x1e277
#define regPCIEMSIX_VECT157_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT158_ADDR_LO                                                                     0x1e278
#define regPCIEMSIX_VECT158_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT158_ADDR_HI                                                                     0x1e279
#define regPCIEMSIX_VECT158_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT158_MSG_DATA                                                                    0x1e27a
#define regPCIEMSIX_VECT158_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT158_CONTROL                                                                     0x1e27b
#define regPCIEMSIX_VECT158_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT159_ADDR_LO                                                                     0x1e27c
#define regPCIEMSIX_VECT159_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT159_ADDR_HI                                                                     0x1e27d
#define regPCIEMSIX_VECT159_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT159_MSG_DATA                                                                    0x1e27e
#define regPCIEMSIX_VECT159_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT159_CONTROL                                                                     0x1e27f
#define regPCIEMSIX_VECT159_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT160_ADDR_LO                                                                     0x1e280
#define regPCIEMSIX_VECT160_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT160_ADDR_HI                                                                     0x1e281
#define regPCIEMSIX_VECT160_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT160_MSG_DATA                                                                    0x1e282
#define regPCIEMSIX_VECT160_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT160_CONTROL                                                                     0x1e283
#define regPCIEMSIX_VECT160_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT161_ADDR_LO                                                                     0x1e284
#define regPCIEMSIX_VECT161_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT161_ADDR_HI                                                                     0x1e285
#define regPCIEMSIX_VECT161_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT161_MSG_DATA                                                                    0x1e286
#define regPCIEMSIX_VECT161_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT161_CONTROL                                                                     0x1e287
#define regPCIEMSIX_VECT161_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT162_ADDR_LO                                                                     0x1e288
#define regPCIEMSIX_VECT162_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT162_ADDR_HI                                                                     0x1e289
#define regPCIEMSIX_VECT162_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT162_MSG_DATA                                                                    0x1e28a
#define regPCIEMSIX_VECT162_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT162_CONTROL                                                                     0x1e28b
#define regPCIEMSIX_VECT162_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT163_ADDR_LO                                                                     0x1e28c
#define regPCIEMSIX_VECT163_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT163_ADDR_HI                                                                     0x1e28d
#define regPCIEMSIX_VECT163_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT163_MSG_DATA                                                                    0x1e28e
#define regPCIEMSIX_VECT163_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT163_CONTROL                                                                     0x1e28f
#define regPCIEMSIX_VECT163_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT164_ADDR_LO                                                                     0x1e290
#define regPCIEMSIX_VECT164_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT164_ADDR_HI                                                                     0x1e291
#define regPCIEMSIX_VECT164_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT164_MSG_DATA                                                                    0x1e292
#define regPCIEMSIX_VECT164_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT164_CONTROL                                                                     0x1e293
#define regPCIEMSIX_VECT164_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT165_ADDR_LO                                                                     0x1e294
#define regPCIEMSIX_VECT165_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT165_ADDR_HI                                                                     0x1e295
#define regPCIEMSIX_VECT165_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT165_MSG_DATA                                                                    0x1e296
#define regPCIEMSIX_VECT165_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT165_CONTROL                                                                     0x1e297
#define regPCIEMSIX_VECT165_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT166_ADDR_LO                                                                     0x1e298
#define regPCIEMSIX_VECT166_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT166_ADDR_HI                                                                     0x1e299
#define regPCIEMSIX_VECT166_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT166_MSG_DATA                                                                    0x1e29a
#define regPCIEMSIX_VECT166_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT166_CONTROL                                                                     0x1e29b
#define regPCIEMSIX_VECT166_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT167_ADDR_LO                                                                     0x1e29c
#define regPCIEMSIX_VECT167_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT167_ADDR_HI                                                                     0x1e29d
#define regPCIEMSIX_VECT167_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT167_MSG_DATA                                                                    0x1e29e
#define regPCIEMSIX_VECT167_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT167_CONTROL                                                                     0x1e29f
#define regPCIEMSIX_VECT167_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT168_ADDR_LO                                                                     0x1e2a0
#define regPCIEMSIX_VECT168_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT168_ADDR_HI                                                                     0x1e2a1
#define regPCIEMSIX_VECT168_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT168_MSG_DATA                                                                    0x1e2a2
#define regPCIEMSIX_VECT168_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT168_CONTROL                                                                     0x1e2a3
#define regPCIEMSIX_VECT168_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT169_ADDR_LO                                                                     0x1e2a4
#define regPCIEMSIX_VECT169_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT169_ADDR_HI                                                                     0x1e2a5
#define regPCIEMSIX_VECT169_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT169_MSG_DATA                                                                    0x1e2a6
#define regPCIEMSIX_VECT169_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT169_CONTROL                                                                     0x1e2a7
#define regPCIEMSIX_VECT169_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT170_ADDR_LO                                                                     0x1e2a8
#define regPCIEMSIX_VECT170_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT170_ADDR_HI                                                                     0x1e2a9
#define regPCIEMSIX_VECT170_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT170_MSG_DATA                                                                    0x1e2aa
#define regPCIEMSIX_VECT170_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT170_CONTROL                                                                     0x1e2ab
#define regPCIEMSIX_VECT170_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT171_ADDR_LO                                                                     0x1e2ac
#define regPCIEMSIX_VECT171_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT171_ADDR_HI                                                                     0x1e2ad
#define regPCIEMSIX_VECT171_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT171_MSG_DATA                                                                    0x1e2ae
#define regPCIEMSIX_VECT171_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT171_CONTROL                                                                     0x1e2af
#define regPCIEMSIX_VECT171_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT172_ADDR_LO                                                                     0x1e2b0
#define regPCIEMSIX_VECT172_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT172_ADDR_HI                                                                     0x1e2b1
#define regPCIEMSIX_VECT172_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT172_MSG_DATA                                                                    0x1e2b2
#define regPCIEMSIX_VECT172_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT172_CONTROL                                                                     0x1e2b3
#define regPCIEMSIX_VECT172_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT173_ADDR_LO                                                                     0x1e2b4
#define regPCIEMSIX_VECT173_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT173_ADDR_HI                                                                     0x1e2b5
#define regPCIEMSIX_VECT173_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT173_MSG_DATA                                                                    0x1e2b6
#define regPCIEMSIX_VECT173_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT173_CONTROL                                                                     0x1e2b7
#define regPCIEMSIX_VECT173_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT174_ADDR_LO                                                                     0x1e2b8
#define regPCIEMSIX_VECT174_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT174_ADDR_HI                                                                     0x1e2b9
#define regPCIEMSIX_VECT174_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT174_MSG_DATA                                                                    0x1e2ba
#define regPCIEMSIX_VECT174_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT174_CONTROL                                                                     0x1e2bb
#define regPCIEMSIX_VECT174_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT175_ADDR_LO                                                                     0x1e2bc
#define regPCIEMSIX_VECT175_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT175_ADDR_HI                                                                     0x1e2bd
#define regPCIEMSIX_VECT175_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT175_MSG_DATA                                                                    0x1e2be
#define regPCIEMSIX_VECT175_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT175_CONTROL                                                                     0x1e2bf
#define regPCIEMSIX_VECT175_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT176_ADDR_LO                                                                     0x1e2c0
#define regPCIEMSIX_VECT176_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT176_ADDR_HI                                                                     0x1e2c1
#define regPCIEMSIX_VECT176_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT176_MSG_DATA                                                                    0x1e2c2
#define regPCIEMSIX_VECT176_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT176_CONTROL                                                                     0x1e2c3
#define regPCIEMSIX_VECT176_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT177_ADDR_LO                                                                     0x1e2c4
#define regPCIEMSIX_VECT177_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT177_ADDR_HI                                                                     0x1e2c5
#define regPCIEMSIX_VECT177_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT177_MSG_DATA                                                                    0x1e2c6
#define regPCIEMSIX_VECT177_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT177_CONTROL                                                                     0x1e2c7
#define regPCIEMSIX_VECT177_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT178_ADDR_LO                                                                     0x1e2c8
#define regPCIEMSIX_VECT178_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT178_ADDR_HI                                                                     0x1e2c9
#define regPCIEMSIX_VECT178_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT178_MSG_DATA                                                                    0x1e2ca
#define regPCIEMSIX_VECT178_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT178_CONTROL                                                                     0x1e2cb
#define regPCIEMSIX_VECT178_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT179_ADDR_LO                                                                     0x1e2cc
#define regPCIEMSIX_VECT179_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT179_ADDR_HI                                                                     0x1e2cd
#define regPCIEMSIX_VECT179_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT179_MSG_DATA                                                                    0x1e2ce
#define regPCIEMSIX_VECT179_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT179_CONTROL                                                                     0x1e2cf
#define regPCIEMSIX_VECT179_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT180_ADDR_LO                                                                     0x1e2d0
#define regPCIEMSIX_VECT180_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT180_ADDR_HI                                                                     0x1e2d1
#define regPCIEMSIX_VECT180_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT180_MSG_DATA                                                                    0x1e2d2
#define regPCIEMSIX_VECT180_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT180_CONTROL                                                                     0x1e2d3
#define regPCIEMSIX_VECT180_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT181_ADDR_LO                                                                     0x1e2d4
#define regPCIEMSIX_VECT181_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT181_ADDR_HI                                                                     0x1e2d5
#define regPCIEMSIX_VECT181_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT181_MSG_DATA                                                                    0x1e2d6
#define regPCIEMSIX_VECT181_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT181_CONTROL                                                                     0x1e2d7
#define regPCIEMSIX_VECT181_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT182_ADDR_LO                                                                     0x1e2d8
#define regPCIEMSIX_VECT182_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT182_ADDR_HI                                                                     0x1e2d9
#define regPCIEMSIX_VECT182_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT182_MSG_DATA                                                                    0x1e2da
#define regPCIEMSIX_VECT182_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT182_CONTROL                                                                     0x1e2db
#define regPCIEMSIX_VECT182_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT183_ADDR_LO                                                                     0x1e2dc
#define regPCIEMSIX_VECT183_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT183_ADDR_HI                                                                     0x1e2dd
#define regPCIEMSIX_VECT183_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT183_MSG_DATA                                                                    0x1e2de
#define regPCIEMSIX_VECT183_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT183_CONTROL                                                                     0x1e2df
#define regPCIEMSIX_VECT183_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT184_ADDR_LO                                                                     0x1e2e0
#define regPCIEMSIX_VECT184_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT184_ADDR_HI                                                                     0x1e2e1
#define regPCIEMSIX_VECT184_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT184_MSG_DATA                                                                    0x1e2e2
#define regPCIEMSIX_VECT184_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT184_CONTROL                                                                     0x1e2e3
#define regPCIEMSIX_VECT184_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT185_ADDR_LO                                                                     0x1e2e4
#define regPCIEMSIX_VECT185_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT185_ADDR_HI                                                                     0x1e2e5
#define regPCIEMSIX_VECT185_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT185_MSG_DATA                                                                    0x1e2e6
#define regPCIEMSIX_VECT185_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT185_CONTROL                                                                     0x1e2e7
#define regPCIEMSIX_VECT185_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT186_ADDR_LO                                                                     0x1e2e8
#define regPCIEMSIX_VECT186_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT186_ADDR_HI                                                                     0x1e2e9
#define regPCIEMSIX_VECT186_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT186_MSG_DATA                                                                    0x1e2ea
#define regPCIEMSIX_VECT186_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT186_CONTROL                                                                     0x1e2eb
#define regPCIEMSIX_VECT186_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT187_ADDR_LO                                                                     0x1e2ec
#define regPCIEMSIX_VECT187_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT187_ADDR_HI                                                                     0x1e2ed
#define regPCIEMSIX_VECT187_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT187_MSG_DATA                                                                    0x1e2ee
#define regPCIEMSIX_VECT187_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT187_CONTROL                                                                     0x1e2ef
#define regPCIEMSIX_VECT187_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT188_ADDR_LO                                                                     0x1e2f0
#define regPCIEMSIX_VECT188_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT188_ADDR_HI                                                                     0x1e2f1
#define regPCIEMSIX_VECT188_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT188_MSG_DATA                                                                    0x1e2f2
#define regPCIEMSIX_VECT188_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT188_CONTROL                                                                     0x1e2f3
#define regPCIEMSIX_VECT188_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT189_ADDR_LO                                                                     0x1e2f4
#define regPCIEMSIX_VECT189_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT189_ADDR_HI                                                                     0x1e2f5
#define regPCIEMSIX_VECT189_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT189_MSG_DATA                                                                    0x1e2f6
#define regPCIEMSIX_VECT189_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT189_CONTROL                                                                     0x1e2f7
#define regPCIEMSIX_VECT189_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT190_ADDR_LO                                                                     0x1e2f8
#define regPCIEMSIX_VECT190_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT190_ADDR_HI                                                                     0x1e2f9
#define regPCIEMSIX_VECT190_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT190_MSG_DATA                                                                    0x1e2fa
#define regPCIEMSIX_VECT190_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT190_CONTROL                                                                     0x1e2fb
#define regPCIEMSIX_VECT190_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT191_ADDR_LO                                                                     0x1e2fc
#define regPCIEMSIX_VECT191_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT191_ADDR_HI                                                                     0x1e2fd
#define regPCIEMSIX_VECT191_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT191_MSG_DATA                                                                    0x1e2fe
#define regPCIEMSIX_VECT191_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT191_CONTROL                                                                     0x1e2ff
#define regPCIEMSIX_VECT191_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT192_ADDR_LO                                                                     0x1e300
#define regPCIEMSIX_VECT192_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT192_ADDR_HI                                                                     0x1e301
#define regPCIEMSIX_VECT192_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT192_MSG_DATA                                                                    0x1e302
#define regPCIEMSIX_VECT192_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT192_CONTROL                                                                     0x1e303
#define regPCIEMSIX_VECT192_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT193_ADDR_LO                                                                     0x1e304
#define regPCIEMSIX_VECT193_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT193_ADDR_HI                                                                     0x1e305
#define regPCIEMSIX_VECT193_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT193_MSG_DATA                                                                    0x1e306
#define regPCIEMSIX_VECT193_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT193_CONTROL                                                                     0x1e307
#define regPCIEMSIX_VECT193_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT194_ADDR_LO                                                                     0x1e308
#define regPCIEMSIX_VECT194_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT194_ADDR_HI                                                                     0x1e309
#define regPCIEMSIX_VECT194_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT194_MSG_DATA                                                                    0x1e30a
#define regPCIEMSIX_VECT194_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT194_CONTROL                                                                     0x1e30b
#define regPCIEMSIX_VECT194_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT195_ADDR_LO                                                                     0x1e30c
#define regPCIEMSIX_VECT195_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT195_ADDR_HI                                                                     0x1e30d
#define regPCIEMSIX_VECT195_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT195_MSG_DATA                                                                    0x1e30e
#define regPCIEMSIX_VECT195_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT195_CONTROL                                                                     0x1e30f
#define regPCIEMSIX_VECT195_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT196_ADDR_LO                                                                     0x1e310
#define regPCIEMSIX_VECT196_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT196_ADDR_HI                                                                     0x1e311
#define regPCIEMSIX_VECT196_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT196_MSG_DATA                                                                    0x1e312
#define regPCIEMSIX_VECT196_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT196_CONTROL                                                                     0x1e313
#define regPCIEMSIX_VECT196_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT197_ADDR_LO                                                                     0x1e314
#define regPCIEMSIX_VECT197_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT197_ADDR_HI                                                                     0x1e315
#define regPCIEMSIX_VECT197_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT197_MSG_DATA                                                                    0x1e316
#define regPCIEMSIX_VECT197_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT197_CONTROL                                                                     0x1e317
#define regPCIEMSIX_VECT197_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT198_ADDR_LO                                                                     0x1e318
#define regPCIEMSIX_VECT198_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT198_ADDR_HI                                                                     0x1e319
#define regPCIEMSIX_VECT198_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT198_MSG_DATA                                                                    0x1e31a
#define regPCIEMSIX_VECT198_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT198_CONTROL                                                                     0x1e31b
#define regPCIEMSIX_VECT198_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT199_ADDR_LO                                                                     0x1e31c
#define regPCIEMSIX_VECT199_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT199_ADDR_HI                                                                     0x1e31d
#define regPCIEMSIX_VECT199_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT199_MSG_DATA                                                                    0x1e31e
#define regPCIEMSIX_VECT199_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT199_CONTROL                                                                     0x1e31f
#define regPCIEMSIX_VECT199_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT200_ADDR_LO                                                                     0x1e320
#define regPCIEMSIX_VECT200_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT200_ADDR_HI                                                                     0x1e321
#define regPCIEMSIX_VECT200_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT200_MSG_DATA                                                                    0x1e322
#define regPCIEMSIX_VECT200_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT200_CONTROL                                                                     0x1e323
#define regPCIEMSIX_VECT200_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT201_ADDR_LO                                                                     0x1e324
#define regPCIEMSIX_VECT201_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT201_ADDR_HI                                                                     0x1e325
#define regPCIEMSIX_VECT201_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT201_MSG_DATA                                                                    0x1e326
#define regPCIEMSIX_VECT201_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT201_CONTROL                                                                     0x1e327
#define regPCIEMSIX_VECT201_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT202_ADDR_LO                                                                     0x1e328
#define regPCIEMSIX_VECT202_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT202_ADDR_HI                                                                     0x1e329
#define regPCIEMSIX_VECT202_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT202_MSG_DATA                                                                    0x1e32a
#define regPCIEMSIX_VECT202_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT202_CONTROL                                                                     0x1e32b
#define regPCIEMSIX_VECT202_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT203_ADDR_LO                                                                     0x1e32c
#define regPCIEMSIX_VECT203_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT203_ADDR_HI                                                                     0x1e32d
#define regPCIEMSIX_VECT203_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT203_MSG_DATA                                                                    0x1e32e
#define regPCIEMSIX_VECT203_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT203_CONTROL                                                                     0x1e32f
#define regPCIEMSIX_VECT203_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT204_ADDR_LO                                                                     0x1e330
#define regPCIEMSIX_VECT204_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT204_ADDR_HI                                                                     0x1e331
#define regPCIEMSIX_VECT204_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT204_MSG_DATA                                                                    0x1e332
#define regPCIEMSIX_VECT204_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT204_CONTROL                                                                     0x1e333
#define regPCIEMSIX_VECT204_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT205_ADDR_LO                                                                     0x1e334
#define regPCIEMSIX_VECT205_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT205_ADDR_HI                                                                     0x1e335
#define regPCIEMSIX_VECT205_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT205_MSG_DATA                                                                    0x1e336
#define regPCIEMSIX_VECT205_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT205_CONTROL                                                                     0x1e337
#define regPCIEMSIX_VECT205_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT206_ADDR_LO                                                                     0x1e338
#define regPCIEMSIX_VECT206_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT206_ADDR_HI                                                                     0x1e339
#define regPCIEMSIX_VECT206_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT206_MSG_DATA                                                                    0x1e33a
#define regPCIEMSIX_VECT206_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT206_CONTROL                                                                     0x1e33b
#define regPCIEMSIX_VECT206_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT207_ADDR_LO                                                                     0x1e33c
#define regPCIEMSIX_VECT207_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT207_ADDR_HI                                                                     0x1e33d
#define regPCIEMSIX_VECT207_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT207_MSG_DATA                                                                    0x1e33e
#define regPCIEMSIX_VECT207_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT207_CONTROL                                                                     0x1e33f
#define regPCIEMSIX_VECT207_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT208_ADDR_LO                                                                     0x1e340
#define regPCIEMSIX_VECT208_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT208_ADDR_HI                                                                     0x1e341
#define regPCIEMSIX_VECT208_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT208_MSG_DATA                                                                    0x1e342
#define regPCIEMSIX_VECT208_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT208_CONTROL                                                                     0x1e343
#define regPCIEMSIX_VECT208_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT209_ADDR_LO                                                                     0x1e344
#define regPCIEMSIX_VECT209_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT209_ADDR_HI                                                                     0x1e345
#define regPCIEMSIX_VECT209_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT209_MSG_DATA                                                                    0x1e346
#define regPCIEMSIX_VECT209_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT209_CONTROL                                                                     0x1e347
#define regPCIEMSIX_VECT209_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT210_ADDR_LO                                                                     0x1e348
#define regPCIEMSIX_VECT210_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT210_ADDR_HI                                                                     0x1e349
#define regPCIEMSIX_VECT210_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT210_MSG_DATA                                                                    0x1e34a
#define regPCIEMSIX_VECT210_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT210_CONTROL                                                                     0x1e34b
#define regPCIEMSIX_VECT210_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT211_ADDR_LO                                                                     0x1e34c
#define regPCIEMSIX_VECT211_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT211_ADDR_HI                                                                     0x1e34d
#define regPCIEMSIX_VECT211_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT211_MSG_DATA                                                                    0x1e34e
#define regPCIEMSIX_VECT211_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT211_CONTROL                                                                     0x1e34f
#define regPCIEMSIX_VECT211_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT212_ADDR_LO                                                                     0x1e350
#define regPCIEMSIX_VECT212_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT212_ADDR_HI                                                                     0x1e351
#define regPCIEMSIX_VECT212_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT212_MSG_DATA                                                                    0x1e352
#define regPCIEMSIX_VECT212_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT212_CONTROL                                                                     0x1e353
#define regPCIEMSIX_VECT212_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT213_ADDR_LO                                                                     0x1e354
#define regPCIEMSIX_VECT213_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT213_ADDR_HI                                                                     0x1e355
#define regPCIEMSIX_VECT213_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT213_MSG_DATA                                                                    0x1e356
#define regPCIEMSIX_VECT213_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT213_CONTROL                                                                     0x1e357
#define regPCIEMSIX_VECT213_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT214_ADDR_LO                                                                     0x1e358
#define regPCIEMSIX_VECT214_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT214_ADDR_HI                                                                     0x1e359
#define regPCIEMSIX_VECT214_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT214_MSG_DATA                                                                    0x1e35a
#define regPCIEMSIX_VECT214_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT214_CONTROL                                                                     0x1e35b
#define regPCIEMSIX_VECT214_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT215_ADDR_LO                                                                     0x1e35c
#define regPCIEMSIX_VECT215_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT215_ADDR_HI                                                                     0x1e35d
#define regPCIEMSIX_VECT215_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT215_MSG_DATA                                                                    0x1e35e
#define regPCIEMSIX_VECT215_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT215_CONTROL                                                                     0x1e35f
#define regPCIEMSIX_VECT215_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT216_ADDR_LO                                                                     0x1e360
#define regPCIEMSIX_VECT216_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT216_ADDR_HI                                                                     0x1e361
#define regPCIEMSIX_VECT216_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT216_MSG_DATA                                                                    0x1e362
#define regPCIEMSIX_VECT216_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT216_CONTROL                                                                     0x1e363
#define regPCIEMSIX_VECT216_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT217_ADDR_LO                                                                     0x1e364
#define regPCIEMSIX_VECT217_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT217_ADDR_HI                                                                     0x1e365
#define regPCIEMSIX_VECT217_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT217_MSG_DATA                                                                    0x1e366
#define regPCIEMSIX_VECT217_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT217_CONTROL                                                                     0x1e367
#define regPCIEMSIX_VECT217_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT218_ADDR_LO                                                                     0x1e368
#define regPCIEMSIX_VECT218_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT218_ADDR_HI                                                                     0x1e369
#define regPCIEMSIX_VECT218_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT218_MSG_DATA                                                                    0x1e36a
#define regPCIEMSIX_VECT218_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT218_CONTROL                                                                     0x1e36b
#define regPCIEMSIX_VECT218_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT219_ADDR_LO                                                                     0x1e36c
#define regPCIEMSIX_VECT219_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT219_ADDR_HI                                                                     0x1e36d
#define regPCIEMSIX_VECT219_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT219_MSG_DATA                                                                    0x1e36e
#define regPCIEMSIX_VECT219_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT219_CONTROL                                                                     0x1e36f
#define regPCIEMSIX_VECT219_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT220_ADDR_LO                                                                     0x1e370
#define regPCIEMSIX_VECT220_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT220_ADDR_HI                                                                     0x1e371
#define regPCIEMSIX_VECT220_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT220_MSG_DATA                                                                    0x1e372
#define regPCIEMSIX_VECT220_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT220_CONTROL                                                                     0x1e373
#define regPCIEMSIX_VECT220_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT221_ADDR_LO                                                                     0x1e374
#define regPCIEMSIX_VECT221_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT221_ADDR_HI                                                                     0x1e375
#define regPCIEMSIX_VECT221_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT221_MSG_DATA                                                                    0x1e376
#define regPCIEMSIX_VECT221_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT221_CONTROL                                                                     0x1e377
#define regPCIEMSIX_VECT221_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT222_ADDR_LO                                                                     0x1e378
#define regPCIEMSIX_VECT222_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT222_ADDR_HI                                                                     0x1e379
#define regPCIEMSIX_VECT222_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT222_MSG_DATA                                                                    0x1e37a
#define regPCIEMSIX_VECT222_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT222_CONTROL                                                                     0x1e37b
#define regPCIEMSIX_VECT222_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT223_ADDR_LO                                                                     0x1e37c
#define regPCIEMSIX_VECT223_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT223_ADDR_HI                                                                     0x1e37d
#define regPCIEMSIX_VECT223_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT223_MSG_DATA                                                                    0x1e37e
#define regPCIEMSIX_VECT223_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT223_CONTROL                                                                     0x1e37f
#define regPCIEMSIX_VECT223_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT224_ADDR_LO                                                                     0x1e380
#define regPCIEMSIX_VECT224_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT224_ADDR_HI                                                                     0x1e381
#define regPCIEMSIX_VECT224_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT224_MSG_DATA                                                                    0x1e382
#define regPCIEMSIX_VECT224_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT224_CONTROL                                                                     0x1e383
#define regPCIEMSIX_VECT224_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT225_ADDR_LO                                                                     0x1e384
#define regPCIEMSIX_VECT225_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT225_ADDR_HI                                                                     0x1e385
#define regPCIEMSIX_VECT225_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT225_MSG_DATA                                                                    0x1e386
#define regPCIEMSIX_VECT225_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT225_CONTROL                                                                     0x1e387
#define regPCIEMSIX_VECT225_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT226_ADDR_LO                                                                     0x1e388
#define regPCIEMSIX_VECT226_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT226_ADDR_HI                                                                     0x1e389
#define regPCIEMSIX_VECT226_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT226_MSG_DATA                                                                    0x1e38a
#define regPCIEMSIX_VECT226_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT226_CONTROL                                                                     0x1e38b
#define regPCIEMSIX_VECT226_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT227_ADDR_LO                                                                     0x1e38c
#define regPCIEMSIX_VECT227_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT227_ADDR_HI                                                                     0x1e38d
#define regPCIEMSIX_VECT227_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT227_MSG_DATA                                                                    0x1e38e
#define regPCIEMSIX_VECT227_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT227_CONTROL                                                                     0x1e38f
#define regPCIEMSIX_VECT227_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT228_ADDR_LO                                                                     0x1e390
#define regPCIEMSIX_VECT228_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT228_ADDR_HI                                                                     0x1e391
#define regPCIEMSIX_VECT228_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT228_MSG_DATA                                                                    0x1e392
#define regPCIEMSIX_VECT228_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT228_CONTROL                                                                     0x1e393
#define regPCIEMSIX_VECT228_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT229_ADDR_LO                                                                     0x1e394
#define regPCIEMSIX_VECT229_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT229_ADDR_HI                                                                     0x1e395
#define regPCIEMSIX_VECT229_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT229_MSG_DATA                                                                    0x1e396
#define regPCIEMSIX_VECT229_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT229_CONTROL                                                                     0x1e397
#define regPCIEMSIX_VECT229_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT230_ADDR_LO                                                                     0x1e398
#define regPCIEMSIX_VECT230_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT230_ADDR_HI                                                                     0x1e399
#define regPCIEMSIX_VECT230_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT230_MSG_DATA                                                                    0x1e39a
#define regPCIEMSIX_VECT230_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT230_CONTROL                                                                     0x1e39b
#define regPCIEMSIX_VECT230_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT231_ADDR_LO                                                                     0x1e39c
#define regPCIEMSIX_VECT231_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT231_ADDR_HI                                                                     0x1e39d
#define regPCIEMSIX_VECT231_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT231_MSG_DATA                                                                    0x1e39e
#define regPCIEMSIX_VECT231_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT231_CONTROL                                                                     0x1e39f
#define regPCIEMSIX_VECT231_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT232_ADDR_LO                                                                     0x1e3a0
#define regPCIEMSIX_VECT232_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT232_ADDR_HI                                                                     0x1e3a1
#define regPCIEMSIX_VECT232_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT232_MSG_DATA                                                                    0x1e3a2
#define regPCIEMSIX_VECT232_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT232_CONTROL                                                                     0x1e3a3
#define regPCIEMSIX_VECT232_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT233_ADDR_LO                                                                     0x1e3a4
#define regPCIEMSIX_VECT233_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT233_ADDR_HI                                                                     0x1e3a5
#define regPCIEMSIX_VECT233_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT233_MSG_DATA                                                                    0x1e3a6
#define regPCIEMSIX_VECT233_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT233_CONTROL                                                                     0x1e3a7
#define regPCIEMSIX_VECT233_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT234_ADDR_LO                                                                     0x1e3a8
#define regPCIEMSIX_VECT234_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT234_ADDR_HI                                                                     0x1e3a9
#define regPCIEMSIX_VECT234_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT234_MSG_DATA                                                                    0x1e3aa
#define regPCIEMSIX_VECT234_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT234_CONTROL                                                                     0x1e3ab
#define regPCIEMSIX_VECT234_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT235_ADDR_LO                                                                     0x1e3ac
#define regPCIEMSIX_VECT235_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT235_ADDR_HI                                                                     0x1e3ad
#define regPCIEMSIX_VECT235_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT235_MSG_DATA                                                                    0x1e3ae
#define regPCIEMSIX_VECT235_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT235_CONTROL                                                                     0x1e3af
#define regPCIEMSIX_VECT235_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT236_ADDR_LO                                                                     0x1e3b0
#define regPCIEMSIX_VECT236_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT236_ADDR_HI                                                                     0x1e3b1
#define regPCIEMSIX_VECT236_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT236_MSG_DATA                                                                    0x1e3b2
#define regPCIEMSIX_VECT236_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT236_CONTROL                                                                     0x1e3b3
#define regPCIEMSIX_VECT236_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT237_ADDR_LO                                                                     0x1e3b4
#define regPCIEMSIX_VECT237_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT237_ADDR_HI                                                                     0x1e3b5
#define regPCIEMSIX_VECT237_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT237_MSG_DATA                                                                    0x1e3b6
#define regPCIEMSIX_VECT237_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT237_CONTROL                                                                     0x1e3b7
#define regPCIEMSIX_VECT237_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT238_ADDR_LO                                                                     0x1e3b8
#define regPCIEMSIX_VECT238_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT238_ADDR_HI                                                                     0x1e3b9
#define regPCIEMSIX_VECT238_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT238_MSG_DATA                                                                    0x1e3ba
#define regPCIEMSIX_VECT238_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT238_CONTROL                                                                     0x1e3bb
#define regPCIEMSIX_VECT238_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT239_ADDR_LO                                                                     0x1e3bc
#define regPCIEMSIX_VECT239_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT239_ADDR_HI                                                                     0x1e3bd
#define regPCIEMSIX_VECT239_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT239_MSG_DATA                                                                    0x1e3be
#define regPCIEMSIX_VECT239_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT239_CONTROL                                                                     0x1e3bf
#define regPCIEMSIX_VECT239_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT240_ADDR_LO                                                                     0x1e3c0
#define regPCIEMSIX_VECT240_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT240_ADDR_HI                                                                     0x1e3c1
#define regPCIEMSIX_VECT240_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT240_MSG_DATA                                                                    0x1e3c2
#define regPCIEMSIX_VECT240_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT240_CONTROL                                                                     0x1e3c3
#define regPCIEMSIX_VECT240_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT241_ADDR_LO                                                                     0x1e3c4
#define regPCIEMSIX_VECT241_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT241_ADDR_HI                                                                     0x1e3c5
#define regPCIEMSIX_VECT241_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT241_MSG_DATA                                                                    0x1e3c6
#define regPCIEMSIX_VECT241_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT241_CONTROL                                                                     0x1e3c7
#define regPCIEMSIX_VECT241_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT242_ADDR_LO                                                                     0x1e3c8
#define regPCIEMSIX_VECT242_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT242_ADDR_HI                                                                     0x1e3c9
#define regPCIEMSIX_VECT242_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT242_MSG_DATA                                                                    0x1e3ca
#define regPCIEMSIX_VECT242_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT242_CONTROL                                                                     0x1e3cb
#define regPCIEMSIX_VECT242_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT243_ADDR_LO                                                                     0x1e3cc
#define regPCIEMSIX_VECT243_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT243_ADDR_HI                                                                     0x1e3cd
#define regPCIEMSIX_VECT243_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT243_MSG_DATA                                                                    0x1e3ce
#define regPCIEMSIX_VECT243_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT243_CONTROL                                                                     0x1e3cf
#define regPCIEMSIX_VECT243_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT244_ADDR_LO                                                                     0x1e3d0
#define regPCIEMSIX_VECT244_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT244_ADDR_HI                                                                     0x1e3d1
#define regPCIEMSIX_VECT244_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT244_MSG_DATA                                                                    0x1e3d2
#define regPCIEMSIX_VECT244_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT244_CONTROL                                                                     0x1e3d3
#define regPCIEMSIX_VECT244_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT245_ADDR_LO                                                                     0x1e3d4
#define regPCIEMSIX_VECT245_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT245_ADDR_HI                                                                     0x1e3d5
#define regPCIEMSIX_VECT245_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT245_MSG_DATA                                                                    0x1e3d6
#define regPCIEMSIX_VECT245_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT245_CONTROL                                                                     0x1e3d7
#define regPCIEMSIX_VECT245_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT246_ADDR_LO                                                                     0x1e3d8
#define regPCIEMSIX_VECT246_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT246_ADDR_HI                                                                     0x1e3d9
#define regPCIEMSIX_VECT246_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT246_MSG_DATA                                                                    0x1e3da
#define regPCIEMSIX_VECT246_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT246_CONTROL                                                                     0x1e3db
#define regPCIEMSIX_VECT246_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT247_ADDR_LO                                                                     0x1e3dc
#define regPCIEMSIX_VECT247_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT247_ADDR_HI                                                                     0x1e3dd
#define regPCIEMSIX_VECT247_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT247_MSG_DATA                                                                    0x1e3de
#define regPCIEMSIX_VECT247_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT247_CONTROL                                                                     0x1e3df
#define regPCIEMSIX_VECT247_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT248_ADDR_LO                                                                     0x1e3e0
#define regPCIEMSIX_VECT248_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT248_ADDR_HI                                                                     0x1e3e1
#define regPCIEMSIX_VECT248_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT248_MSG_DATA                                                                    0x1e3e2
#define regPCIEMSIX_VECT248_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT248_CONTROL                                                                     0x1e3e3
#define regPCIEMSIX_VECT248_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT249_ADDR_LO                                                                     0x1e3e4
#define regPCIEMSIX_VECT249_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT249_ADDR_HI                                                                     0x1e3e5
#define regPCIEMSIX_VECT249_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT249_MSG_DATA                                                                    0x1e3e6
#define regPCIEMSIX_VECT249_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT249_CONTROL                                                                     0x1e3e7
#define regPCIEMSIX_VECT249_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT250_ADDR_LO                                                                     0x1e3e8
#define regPCIEMSIX_VECT250_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT250_ADDR_HI                                                                     0x1e3e9
#define regPCIEMSIX_VECT250_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT250_MSG_DATA                                                                    0x1e3ea
#define regPCIEMSIX_VECT250_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT250_CONTROL                                                                     0x1e3eb
#define regPCIEMSIX_VECT250_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT251_ADDR_LO                                                                     0x1e3ec
#define regPCIEMSIX_VECT251_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT251_ADDR_HI                                                                     0x1e3ed
#define regPCIEMSIX_VECT251_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT251_MSG_DATA                                                                    0x1e3ee
#define regPCIEMSIX_VECT251_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT251_CONTROL                                                                     0x1e3ef
#define regPCIEMSIX_VECT251_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT252_ADDR_LO                                                                     0x1e3f0
#define regPCIEMSIX_VECT252_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT252_ADDR_HI                                                                     0x1e3f1
#define regPCIEMSIX_VECT252_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT252_MSG_DATA                                                                    0x1e3f2
#define regPCIEMSIX_VECT252_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT252_CONTROL                                                                     0x1e3f3
#define regPCIEMSIX_VECT252_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT253_ADDR_LO                                                                     0x1e3f4
#define regPCIEMSIX_VECT253_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT253_ADDR_HI                                                                     0x1e3f5
#define regPCIEMSIX_VECT253_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT253_MSG_DATA                                                                    0x1e3f6
#define regPCIEMSIX_VECT253_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT253_CONTROL                                                                     0x1e3f7
#define regPCIEMSIX_VECT253_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT254_ADDR_LO                                                                     0x1e3f8
#define regPCIEMSIX_VECT254_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT254_ADDR_HI                                                                     0x1e3f9
#define regPCIEMSIX_VECT254_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT254_MSG_DATA                                                                    0x1e3fa
#define regPCIEMSIX_VECT254_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT254_CONTROL                                                                     0x1e3fb
#define regPCIEMSIX_VECT254_CONTROL_BASE_IDX                                                            5
#define regPCIEMSIX_VECT255_ADDR_LO                                                                     0x1e3fc
#define regPCIEMSIX_VECT255_ADDR_LO_BASE_IDX                                                            5
#define regPCIEMSIX_VECT255_ADDR_HI                                                                     0x1e3fd
#define regPCIEMSIX_VECT255_ADDR_HI_BASE_IDX                                                            5
#define regPCIEMSIX_VECT255_MSG_DATA                                                                    0x1e3fe
#define regPCIEMSIX_VECT255_MSG_DATA_BASE_IDX                                                           5
#define regPCIEMSIX_VECT255_CONTROL                                                                     0x1e3ff
#define regPCIEMSIX_VECT255_CONTROL_BASE_IDX                                                            5


// addressBlock: nbif_rcc_pfc_usb_RCCPFCDEC
// base address: 0x10134400
#define regRCC_PFC_USB_RCC_PFC_LTR_CNTL                                                                 0xd140
#define regRCC_PFC_USB_RCC_PFC_LTR_CNTL_BASE_IDX                                                        5
#define regRCC_PFC_USB_RCC_PFC_PME_RESTORE                                                              0xd141
#define regRCC_PFC_USB_RCC_PFC_PME_RESTORE_BASE_IDX                                                     5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_0                                                         0xd142
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_0_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_1                                                         0xd143
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_1_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_2                                                         0xd144
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_2_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_3                                                         0xd145
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_3_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_4                                                         0xd146
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_4_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_5                                                         0xd147
#define regRCC_PFC_USB_RCC_PFC_STICKY_RESTORE_5_BASE_IDX                                                5
#define regRCC_PFC_USB_RCC_PFC_AUXPWR_CNTL                                                              0xd148
#define regRCC_PFC_USB_RCC_PFC_AUXPWR_CNTL_BASE_IDX                                                     5


// addressBlock: nbif_rcc_pfc_pd_controller_RCCPFCDEC
// base address: 0x10134600
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_LTR_CNTL                                                       0xd1c0
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_LTR_CNTL_BASE_IDX                                              5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_PME_RESTORE                                                    0xd1c1
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_PME_RESTORE_BASE_IDX                                           5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_0                                               0xd1c2
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_0_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_1                                               0xd1c3
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_1_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_2                                               0xd1c4
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_2_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_3                                               0xd1c5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_3_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_4                                               0xd1c6
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_4_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_5                                               0xd1c7
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_STICKY_RESTORE_5_BASE_IDX                                      5
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_AUXPWR_CNTL                                                    0xd1c8
#define regRCC_PFC_PD_CONTROLLER_RCC_PFC_AUXPWR_CNTL_BASE_IDX                                           5


// addressBlock: nbif_pciemsix_0_usb_MSIXPDEC
// base address: 0x10179000
#define regPCIEMSIX_PBA_0                                                                               0x1e400
#define regPCIEMSIX_PBA_0_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_1                                                                               0x1e401
#define regPCIEMSIX_PBA_1_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_2                                                                               0x1e402
#define regPCIEMSIX_PBA_2_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_3                                                                               0x1e403
#define regPCIEMSIX_PBA_3_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_4                                                                               0x1e404
#define regPCIEMSIX_PBA_4_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_5                                                                               0x1e405
#define regPCIEMSIX_PBA_5_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_6                                                                               0x1e406
#define regPCIEMSIX_PBA_6_BASE_IDX                                                                      5
#define regPCIEMSIX_PBA_7                                                                               0x1e407
#define regPCIEMSIX_PBA_7_BASE_IDX                                                                      5


// addressBlock: nbif_rcc_shadow_reg_shadowdec
// base address: 0x10130000
#define regSHADOW_COMMAND                                                                               0xc001
#define regSHADOW_COMMAND_BASE_IDX                                                                      5
#define regSHADOW_BASE_ADDR_1                                                                           0xc004
#define regSHADOW_BASE_ADDR_1_BASE_IDX                                                                  5
#define regSHADOW_BASE_ADDR_2                                                                           0xc005
#define regSHADOW_BASE_ADDR_2_BASE_IDX                                                                  5
#define regSHADOW_IRQ_BRIDGE_CNTL                                                                       0xc00f
#define regSHADOW_IRQ_BRIDGE_CNTL_BASE_IDX                                                              5
#define regSUC_INDEX                                                                                    0xc038
#define regSUC_INDEX_BASE_IDX                                                                           5
#define regSUC_DATA                                                                                     0xc039
#define regSUC_DATA_BASE_IDX                                                                            5


// addressBlock: nbif_bif_swus_SUMDEC
// base address: 0x1013b000
#define regSUM_INDEX                                                                                    0xec38
#define regSUM_INDEX_BASE_IDX                                                                           5
#define regSUM_DATA                                                                                     0xec39
#define regSUM_DATA_BASE_IDX                                                                            5
#define regSUM_INDEX_HI                                                                                 0xec3b
#define regSUM_INDEX_HI_BASE_IDX                                                                        5


// addressBlock: nbif_rcc_strap_rcc_strap_internal
// base address: 0x10100000
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP0                                                              0xc400
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP1                                                              0xc401
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP1_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP2                                                              0xc402
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP3                                                              0xc403
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP4                                                              0xc404
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP5                                                              0xc405
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP6                                                              0xc406
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP6_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP7                                                              0xc407
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP7_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP8                                                              0xc408
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP8_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP9                                                              0xc409
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP9_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP10                                                             0xc40a
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP10_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP11                                                             0xc40b
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP11_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP12                                                             0xc40c
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP12_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP13                                                             0xc40d
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP13_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP14                                                             0xc40e
#define regRCC_STRAP1_RCC_DEV0_PORT_STRAP14_BASE_IDX                                                    5
#define regRCC_DEV1_PORT_STRAP0                                                                         0xc480
#define regRCC_DEV1_PORT_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP1                                                                         0xc481
#define regRCC_DEV1_PORT_STRAP1_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP2                                                                         0xc482
#define regRCC_DEV1_PORT_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP3                                                                         0xc483
#define regRCC_DEV1_PORT_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP4                                                                         0xc484
#define regRCC_DEV1_PORT_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP5                                                                         0xc485
#define regRCC_DEV1_PORT_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP6                                                                         0xc486
#define regRCC_DEV1_PORT_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP7                                                                         0xc487
#define regRCC_DEV1_PORT_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP8                                                                         0xc488
#define regRCC_DEV1_PORT_STRAP8_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP9                                                                         0xc489
#define regRCC_DEV1_PORT_STRAP9_BASE_IDX                                                                5
#define regRCC_DEV1_PORT_STRAP10                                                                        0xc48a
#define regRCC_DEV1_PORT_STRAP10_BASE_IDX                                                               5
#define regRCC_DEV1_PORT_STRAP11                                                                        0xc48b
#define regRCC_DEV1_PORT_STRAP11_BASE_IDX                                                               5
#define regRCC_DEV1_PORT_STRAP12                                                                        0xc48c
#define regRCC_DEV1_PORT_STRAP12_BASE_IDX                                                               5
#define regRCC_DEV1_PORT_STRAP13                                                                        0xc48d
#define regRCC_DEV1_PORT_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_PORT_STRAP14                                                                        0xc48e
#define regRCC_DEV1_PORT_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV2_PORT_STRAP0                                                                         0xc500
#define regRCC_DEV2_PORT_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP1                                                                         0xc501
#define regRCC_DEV2_PORT_STRAP1_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP2                                                                         0xc502
#define regRCC_DEV2_PORT_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP3                                                                         0xc503
#define regRCC_DEV2_PORT_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP4                                                                         0xc504
#define regRCC_DEV2_PORT_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP5                                                                         0xc505
#define regRCC_DEV2_PORT_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP6                                                                         0xc506
#define regRCC_DEV2_PORT_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP7                                                                         0xc507
#define regRCC_DEV2_PORT_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP8                                                                         0xc508
#define regRCC_DEV2_PORT_STRAP8_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP9                                                                         0xc509
#define regRCC_DEV2_PORT_STRAP9_BASE_IDX                                                                5
#define regRCC_DEV2_PORT_STRAP10                                                                        0xc50a
#define regRCC_DEV2_PORT_STRAP10_BASE_IDX                                                               5
#define regRCC_DEV2_PORT_STRAP11                                                                        0xc50b
#define regRCC_DEV2_PORT_STRAP11_BASE_IDX                                                               5
#define regRCC_DEV2_PORT_STRAP12                                                                        0xc50c
#define regRCC_DEV2_PORT_STRAP12_BASE_IDX                                                               5
#define regRCC_DEV2_PORT_STRAP13                                                                        0xc50d
#define regRCC_DEV2_PORT_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV2_PORT_STRAP14                                                                        0xc50e
#define regRCC_DEV2_PORT_STRAP14_BASE_IDX                                                               5
#define regRCC_STRAP1_RCC_BIF_STRAP0                                                                    0xc600
#define regRCC_STRAP1_RCC_BIF_STRAP0_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP1                                                                    0xc601
#define regRCC_STRAP1_RCC_BIF_STRAP1_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP2                                                                    0xc602
#define regRCC_STRAP1_RCC_BIF_STRAP2_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP3                                                                    0xc603
#define regRCC_STRAP1_RCC_BIF_STRAP3_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP4                                                                    0xc604
#define regRCC_STRAP1_RCC_BIF_STRAP4_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP5                                                                    0xc605
#define regRCC_STRAP1_RCC_BIF_STRAP5_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_BIF_STRAP6                                                                    0xc606
#define regRCC_STRAP1_RCC_BIF_STRAP6_BASE_IDX                                                           5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP0                                                              0xd000
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP1                                                              0xd001
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP1_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP2                                                              0xd002
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP3                                                              0xd003
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP4                                                              0xd004
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP5                                                              0xd005
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP8                                                              0xd008
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP8_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP9                                                              0xd009
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP9_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP13                                                             0xd00d
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP13_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP14                                                             0xd00e
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP14_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP15                                                             0xd00f
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP15_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP16                                                             0xd010
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP16_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP17                                                             0xd011
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP17_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP18                                                             0xd012
#define regRCC_STRAP1_RCC_DEV0_EPF0_STRAP18_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP0                                                              0xd080
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP2                                                              0xd082
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP3                                                              0xd083
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP4                                                              0xd084
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP5                                                              0xd085
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP6                                                              0xd086
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP6_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP7                                                              0xd087
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP7_BASE_IDX                                                     5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP20                                                             0xd094
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP20_BASE_IDX                                                    5
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP21                                                             0xd095
#define regRCC_STRAP1_RCC_DEV0_EPF1_STRAP21_BASE_IDX                                                    5
#define regRCC_DEV0_EPF2_STRAP0                                                                         0xd100
#define regRCC_DEV0_EPF2_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP2                                                                         0xd102
#define regRCC_DEV0_EPF2_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP3                                                                         0xd103
#define regRCC_DEV0_EPF2_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP4                                                                         0xd104
#define regRCC_DEV0_EPF2_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP5                                                                         0xd105
#define regRCC_DEV0_EPF2_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP6                                                                         0xd106
#define regRCC_DEV0_EPF2_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP7                                                                         0xd107
#define regRCC_DEV0_EPF2_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV0_EPF2_STRAP10                                                                        0xd10a
#define regRCC_DEV0_EPF2_STRAP10_BASE_IDX                                                               5
#define regRCC_DEV0_EPF2_STRAP11                                                                        0xd10b
#define regRCC_DEV0_EPF2_STRAP11_BASE_IDX                                                               5
#define regRCC_DEV0_EPF2_STRAP12                                                                        0xd10c
#define regRCC_DEV0_EPF2_STRAP12_BASE_IDX                                                               5
#define regRCC_DEV0_EPF2_STRAP13                                                                        0xd10d
#define regRCC_DEV0_EPF2_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF2_STRAP14                                                                        0xd10e
#define regRCC_DEV0_EPF2_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV0_EPF2_STRAP20                                                                        0xd114
#define regRCC_DEV0_EPF2_STRAP20_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP0                                                                         0xd180
#define regRCC_DEV0_EPF3_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP2                                                                         0xd182
#define regRCC_DEV0_EPF3_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP3                                                                         0xd183
#define regRCC_DEV0_EPF3_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP4                                                                         0xd184
#define regRCC_DEV0_EPF3_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP5                                                                         0xd185
#define regRCC_DEV0_EPF3_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP6                                                                         0xd186
#define regRCC_DEV0_EPF3_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP7                                                                         0xd187
#define regRCC_DEV0_EPF3_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV0_EPF3_STRAP10                                                                        0xd18a
#define regRCC_DEV0_EPF3_STRAP10_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP11                                                                        0xd18b
#define regRCC_DEV0_EPF3_STRAP11_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP12                                                                        0xd18c
#define regRCC_DEV0_EPF3_STRAP12_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP13                                                                        0xd18d
#define regRCC_DEV0_EPF3_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP14                                                                        0xd18e
#define regRCC_DEV0_EPF3_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV0_EPF3_STRAP20                                                                        0xd194
#define regRCC_DEV0_EPF3_STRAP20_BASE_IDX                                                               5
#define regRCC_DEV0_EPF4_STRAP0                                                                         0xd200
#define regRCC_DEV0_EPF4_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP2                                                                         0xd202
#define regRCC_DEV0_EPF4_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP3                                                                         0xd203
#define regRCC_DEV0_EPF4_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP4                                                                         0xd204
#define regRCC_DEV0_EPF4_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP5                                                                         0xd205
#define regRCC_DEV0_EPF4_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP6                                                                         0xd206
#define regRCC_DEV0_EPF4_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP7                                                                         0xd207
#define regRCC_DEV0_EPF4_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV0_EPF4_STRAP13                                                                        0xd20d
#define regRCC_DEV0_EPF4_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF4_STRAP14                                                                        0xd20e
#define regRCC_DEV0_EPF4_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV0_EPF5_STRAP0                                                                         0xd280
#define regRCC_DEV0_EPF5_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP2                                                                         0xd282
#define regRCC_DEV0_EPF5_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP3                                                                         0xd283
#define regRCC_DEV0_EPF5_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP4                                                                         0xd284
#define regRCC_DEV0_EPF5_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP5                                                                         0xd285
#define regRCC_DEV0_EPF5_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP6                                                                         0xd286
#define regRCC_DEV0_EPF5_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP7                                                                         0xd287
#define regRCC_DEV0_EPF5_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV0_EPF5_STRAP13                                                                        0xd28d
#define regRCC_DEV0_EPF5_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF5_STRAP14                                                                        0xd28e
#define regRCC_DEV0_EPF5_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV0_EPF6_STRAP0                                                                         0xd300
#define regRCC_DEV0_EPF6_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP2                                                                         0xd302
#define regRCC_DEV0_EPF6_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP3                                                                         0xd303
#define regRCC_DEV0_EPF6_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP4                                                                         0xd304
#define regRCC_DEV0_EPF6_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP5                                                                         0xd305
#define regRCC_DEV0_EPF6_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP6                                                                         0xd306
#define regRCC_DEV0_EPF6_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF6_STRAP13                                                                        0xd30d
#define regRCC_DEV0_EPF6_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF6_STRAP14                                                                        0xd30e
#define regRCC_DEV0_EPF6_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV0_EPF7_STRAP0                                                                         0xd380
#define regRCC_DEV0_EPF7_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP2                                                                         0xd382
#define regRCC_DEV0_EPF7_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP3                                                                         0xd383
#define regRCC_DEV0_EPF7_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP4                                                                         0xd384
#define regRCC_DEV0_EPF7_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP5                                                                         0xd385
#define regRCC_DEV0_EPF7_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP6                                                                         0xd386
#define regRCC_DEV0_EPF7_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV0_EPF7_STRAP13                                                                        0xd38d
#define regRCC_DEV0_EPF7_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV0_EPF7_STRAP14                                                                        0xd38e
#define regRCC_DEV0_EPF7_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF0_STRAP0                                                                         0xd400
#define regRCC_DEV1_EPF0_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP2                                                                         0xd402
#define regRCC_DEV1_EPF0_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP3                                                                         0xd403
#define regRCC_DEV1_EPF0_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP4                                                                         0xd404
#define regRCC_DEV1_EPF0_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP5                                                                         0xd405
#define regRCC_DEV1_EPF0_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP6                                                                         0xd406
#define regRCC_DEV1_EPF0_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV1_EPF0_STRAP13                                                                        0xd40d
#define regRCC_DEV1_EPF0_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF0_STRAP14                                                                        0xd40e
#define regRCC_DEV1_EPF0_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF1_STRAP0                                                                         0xd480
#define regRCC_DEV1_EPF1_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP2                                                                         0xd482
#define regRCC_DEV1_EPF1_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP3                                                                         0xd483
#define regRCC_DEV1_EPF1_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP4                                                                         0xd484
#define regRCC_DEV1_EPF1_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP5                                                                         0xd485
#define regRCC_DEV1_EPF1_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP6                                                                         0xd486
#define regRCC_DEV1_EPF1_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV1_EPF1_STRAP13                                                                        0xd48d
#define regRCC_DEV1_EPF1_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF1_STRAP14                                                                        0xd48e
#define regRCC_DEV1_EPF1_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF2_STRAP0                                                                         0xd500
#define regRCC_DEV1_EPF2_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF2_STRAP2                                                                         0xd502
#define regRCC_DEV1_EPF2_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF2_STRAP3                                                                         0xd503
#define regRCC_DEV1_EPF2_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF2_STRAP4                                                                         0xd504
#define regRCC_DEV1_EPF2_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF2_STRAP5                                                                         0xd505
#define regRCC_DEV1_EPF2_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF2_STRAP13                                                                        0xd50d
#define regRCC_DEV1_EPF2_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF2_STRAP14                                                                        0xd50e
#define regRCC_DEV1_EPF2_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF3_STRAP0                                                                         0xd580
#define regRCC_DEV1_EPF3_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF3_STRAP2                                                                         0xd582
#define regRCC_DEV1_EPF3_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF3_STRAP3                                                                         0xd583
#define regRCC_DEV1_EPF3_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF3_STRAP4                                                                         0xd584
#define regRCC_DEV1_EPF3_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF3_STRAP5                                                                         0xd585
#define regRCC_DEV1_EPF3_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF3_STRAP13                                                                        0xd58d
#define regRCC_DEV1_EPF3_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF3_STRAP14                                                                        0xd58e
#define regRCC_DEV1_EPF3_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF4_STRAP0                                                                         0xd600
#define regRCC_DEV1_EPF4_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF4_STRAP2                                                                         0xd602
#define regRCC_DEV1_EPF4_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF4_STRAP3                                                                         0xd603
#define regRCC_DEV1_EPF4_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF4_STRAP4                                                                         0xd604
#define regRCC_DEV1_EPF4_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF4_STRAP5                                                                         0xd605
#define regRCC_DEV1_EPF4_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF4_STRAP13                                                                        0xd60d
#define regRCC_DEV1_EPF4_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF4_STRAP14                                                                        0xd60e
#define regRCC_DEV1_EPF4_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV1_EPF5_STRAP0                                                                         0xd680
#define regRCC_DEV1_EPF5_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV1_EPF5_STRAP2                                                                         0xd682
#define regRCC_DEV1_EPF5_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV1_EPF5_STRAP3                                                                         0xd683
#define regRCC_DEV1_EPF5_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV1_EPF5_STRAP4                                                                         0xd684
#define regRCC_DEV1_EPF5_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV1_EPF5_STRAP5                                                                         0xd685
#define regRCC_DEV1_EPF5_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV1_EPF5_STRAP13                                                                        0xd68d
#define regRCC_DEV1_EPF5_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV1_EPF5_STRAP14                                                                        0xd68e
#define regRCC_DEV1_EPF5_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV2_EPF0_STRAP0                                                                         0xd800
#define regRCC_DEV2_EPF0_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP2                                                                         0xd802
#define regRCC_DEV2_EPF0_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP3                                                                         0xd803
#define regRCC_DEV2_EPF0_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP4                                                                         0xd804
#define regRCC_DEV2_EPF0_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP5                                                                         0xd805
#define regRCC_DEV2_EPF0_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP6                                                                         0xd806
#define regRCC_DEV2_EPF0_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP7                                                                         0xd807
#define regRCC_DEV2_EPF0_STRAP7_BASE_IDX                                                                5
#define regRCC_DEV2_EPF0_STRAP13                                                                        0xd80d
#define regRCC_DEV2_EPF0_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV2_EPF0_STRAP14                                                                        0xd80e
#define regRCC_DEV2_EPF0_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV2_EPF1_STRAP0                                                                         0xd880
#define regRCC_DEV2_EPF1_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP2                                                                         0xd882
#define regRCC_DEV2_EPF1_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP3                                                                         0xd883
#define regRCC_DEV2_EPF1_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP4                                                                         0xd884
#define regRCC_DEV2_EPF1_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP5                                                                         0xd885
#define regRCC_DEV2_EPF1_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP6                                                                         0xd886
#define regRCC_DEV2_EPF1_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV2_EPF1_STRAP13                                                                        0xd88d
#define regRCC_DEV2_EPF1_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV2_EPF1_STRAP14                                                                        0xd88e
#define regRCC_DEV2_EPF1_STRAP14_BASE_IDX                                                               5
#define regRCC_DEV2_EPF2_STRAP0                                                                         0xd900
#define regRCC_DEV2_EPF2_STRAP0_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP2                                                                         0xd902
#define regRCC_DEV2_EPF2_STRAP2_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP3                                                                         0xd903
#define regRCC_DEV2_EPF2_STRAP3_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP4                                                                         0xd904
#define regRCC_DEV2_EPF2_STRAP4_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP5                                                                         0xd905
#define regRCC_DEV2_EPF2_STRAP5_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP6                                                                         0xd906
#define regRCC_DEV2_EPF2_STRAP6_BASE_IDX                                                                5
#define regRCC_DEV2_EPF2_STRAP13                                                                        0xd90d
#define regRCC_DEV2_EPF2_STRAP13_BASE_IDX                                                               5
#define regRCC_DEV2_EPF2_STRAP14                                                                        0xd90e
#define regRCC_DEV2_EPF2_STRAP14_BASE_IDX                                                               5


// addressBlock: nbif_bif_rst_bif_rst_regblk
// base address: 0x10100000
#define regHARD_RST_CTRL                                                                                0xe000
#define regHARD_RST_CTRL_BASE_IDX                                                                       5
#define regRSMU_SOFT_RST_CTRL                                                                           0xe001
#define regRSMU_SOFT_RST_CTRL_BASE_IDX                                                                  5
#define regSELF_SOFT_RST                                                                                0xe002
#define regSELF_SOFT_RST_BASE_IDX                                                                       5
#define regBIF_GFX_DRV_VPU_RST                                                                          0xe003
#define regBIF_GFX_DRV_VPU_RST_BASE_IDX                                                                 5
#define regBIF_RST_MISC_CTRL                                                                            0xe004
#define regBIF_RST_MISC_CTRL_BASE_IDX                                                                   5
#define regBIF_RST_MISC_CTRL2                                                                           0xe005
#define regBIF_RST_MISC_CTRL2_BASE_IDX                                                                  5
#define regBIF_RST_MISC_CTRL3                                                                           0xe006
#define regBIF_RST_MISC_CTRL3_BASE_IDX                                                                  5
#define regDEV0_PF0_FLR_RST_CTRL                                                                        0xe008
#define regDEV0_PF0_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF1_FLR_RST_CTRL                                                                        0xe009
#define regDEV0_PF1_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF2_FLR_RST_CTRL                                                                        0xe00a
#define regDEV0_PF2_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF3_FLR_RST_CTRL                                                                        0xe00b
#define regDEV0_PF3_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF4_FLR_RST_CTRL                                                                        0xe00c
#define regDEV0_PF4_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF5_FLR_RST_CTRL                                                                        0xe00d
#define regDEV0_PF5_FLR_RST_CTRL_BASE_IDX                                                               5
#define regDEV0_PF6_FLR_RST_CTRL                                                                        0xe00e
#define regDEV0_PF6_FLR_RST_CTRL_BASE_IDX                                                               5
#define regBIF_INST_RESET_INTR_STS                                                                      0xe010
#define regBIF_INST_RESET_INTR_STS_BASE_IDX                                                             5
#define regBIF_PF_FLR_INTR_STS                                                                          0xe011
#define regBIF_PF_FLR_INTR_STS_BASE_IDX                                                                 5
#define regBIF_D3HOTD0_INTR_STS                                                                         0xe012
#define regBIF_D3HOTD0_INTR_STS_BASE_IDX                                                                5
#define regBIF_POWER_INTR_STS                                                                           0xe014
#define regBIF_POWER_INTR_STS_BASE_IDX                                                                  5
#define regBIF_PF_DSTATE_INTR_STS                                                                       0xe015
#define regBIF_PF_DSTATE_INTR_STS_BASE_IDX                                                              5
#define regSELF_SOFT_RST_2                                                                              0xe016
#define regSELF_SOFT_RST_2_BASE_IDX                                                                     5
#define regBIF_INST_RESET_INTR_MASK                                                                     0xe020
#define regBIF_INST_RESET_INTR_MASK_BASE_IDX                                                            5
#define regBIF_PF_FLR_INTR_MASK                                                                         0xe021
#define regBIF_PF_FLR_INTR_MASK_BASE_IDX                                                                5
#define regBIF_D3HOTD0_INTR_MASK                                                                        0xe022
#define regBIF_D3HOTD0_INTR_MASK_BASE_IDX                                                               5
#define regBIF_POWER_INTR_MASK                                                                          0xe024
#define regBIF_POWER_INTR_MASK_BASE_IDX                                                                 5
#define regBIF_PF_DSTATE_INTR_MASK                                                                      0xe025
#define regBIF_PF_DSTATE_INTR_MASK_BASE_IDX                                                             5
#define regBIF_PF_FLR_RST                                                                               0xe040
#define regBIF_PF_FLR_RST_BASE_IDX                                                                      5
#define regBIF_DEV0_PF0_DSTATE_VALUE                                                                    0xe050
#define regBIF_DEV0_PF0_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF1_DSTATE_VALUE                                                                    0xe051
#define regBIF_DEV0_PF1_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF2_DSTATE_VALUE                                                                    0xe052
#define regBIF_DEV0_PF2_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF3_DSTATE_VALUE                                                                    0xe053
#define regBIF_DEV0_PF3_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF4_DSTATE_VALUE                                                                    0xe054
#define regBIF_DEV0_PF4_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF5_DSTATE_VALUE                                                                    0xe055
#define regBIF_DEV0_PF5_DSTATE_VALUE_BASE_IDX                                                           5
#define regBIF_DEV0_PF6_DSTATE_VALUE                                                                    0xe056
#define regBIF_DEV0_PF6_DSTATE_VALUE_BASE_IDX                                                           5
#define regDEV0_PF0_D3HOTD0_RST_CTRL                                                                    0xe078
#define regDEV0_PF0_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF1_D3HOTD0_RST_CTRL                                                                    0xe079
#define regDEV0_PF1_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF2_D3HOTD0_RST_CTRL                                                                    0xe07a
#define regDEV0_PF2_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF3_D3HOTD0_RST_CTRL                                                                    0xe07b
#define regDEV0_PF3_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF4_D3HOTD0_RST_CTRL                                                                    0xe07c
#define regDEV0_PF4_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF5_D3HOTD0_RST_CTRL                                                                    0xe07d
#define regDEV0_PF5_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regDEV0_PF6_D3HOTD0_RST_CTRL                                                                    0xe07e
#define regDEV0_PF6_D3HOTD0_RST_CTRL_BASE_IDX                                                           5
#define regBIF_PORT0_DSTATE_VALUE                                                                       0xe230
#define regBIF_PORT0_DSTATE_VALUE_BASE_IDX                                                              5
#define regBIF_USB_SHUB_RS_RESET_CNTL                                                                   0xe231
#define regBIF_USB_SHUB_RS_RESET_CNTL_BASE_IDX                                                          5


// addressBlock: nbif_bif_misc_bif_misc_regblk
// base address: 0x10100000
#define regREGS_ROM_OFFSET_CTRL                                                                         0xcc23
#define regREGS_ROM_OFFSET_CTRL_BASE_IDX                                                                5
#define regNBIF_STRAP_BIOS_CNTL                                                                         0xcc81
#define regNBIF_STRAP_BIOS_CNTL_BASE_IDX                                                                5
#define regMISC_SCRATCH                                                                                 0xe800
#define regMISC_SCRATCH_BASE_IDX                                                                        5
#define regINTR_LINE_POLARITY                                                                           0xe801
#define regINTR_LINE_POLARITY_BASE_IDX                                                                  5
#define regINTR_LINE_ENABLE                                                                             0xe802
#define regINTR_LINE_ENABLE_BASE_IDX                                                                    5
#define regOUTSTANDING_VC_ALLOC                                                                         0xe803
#define regOUTSTANDING_VC_ALLOC_BASE_IDX                                                                5
#define regBIFC_MISC_CTRL0                                                                              0xe804
#define regBIFC_MISC_CTRL0_BASE_IDX                                                                     5
#define regBIFC_MISC_CTRL1                                                                              0xe805
#define regBIFC_MISC_CTRL1_BASE_IDX                                                                     5
#define regBIFC_BME_ERR_LOG_LB                                                                          0xe806
#define regBIFC_BME_ERR_LOG_LB_BASE_IDX                                                                 5
#define regBIFC_LC_TIMER_CTRL                                                                           0xe807
#define regBIFC_LC_TIMER_CTRL_BASE_IDX                                                                  5
#define regBIFC_RCCBIH_BME_ERR_LOG0                                                                     0xe808
#define regBIFC_RCCBIH_BME_ERR_LOG0_BASE_IDX                                                            5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F0_F1                                                            0xe80a
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F0_F1_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F2_F3                                                            0xe80b
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F2_F3_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F4_F5                                                            0xe80c
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F4_F5_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F6_F7                                                            0xe80d
#define regBIFC_DMA_ATTR_OVERRIDE_DEV0_F6_F7_BASE_IDX                                                   5
#define regBIFC_DMA_ATTR_CNTL2_DEV0                                                                     0xe81a
#define regBIFC_DMA_ATTR_CNTL2_DEV0_BASE_IDX                                                            5
#define regBIFC_MISC_CTRL2                                                                              0xe822
#define regBIFC_MISC_CTRL2_BASE_IDX                                                                     5
#define regBME_DUMMY_CNTL_0                                                                             0xe825
#define regBME_DUMMY_CNTL_0_BASE_IDX                                                                    5
#define regBIFC_THT_CNTL                                                                                0xe827
#define regBIFC_THT_CNTL_BASE_IDX                                                                       5
#define regBIFC_HSTARB_CNTL                                                                             0xe828
#define regBIFC_HSTARB_CNTL_BASE_IDX                                                                    5
#define regBIFC_GSI_CNTL                                                                                0xe829
#define regBIFC_GSI_CNTL_BASE_IDX                                                                       5
#define regBIFC_PCIEFUNC_CNTL                                                                           0xe82a
#define regBIFC_PCIEFUNC_CNTL_BASE_IDX                                                                  5
#define regBIFC_PASID_CHECK_DIS                                                                         0xe82b
#define regBIFC_PASID_CHECK_DIS_BASE_IDX                                                                5
#define regBIFC_SDP_CNTL_0                                                                              0xe82c
#define regBIFC_SDP_CNTL_0_BASE_IDX                                                                     5
#define regBIFC_SDP_CNTL_1                                                                              0xe82d
#define regBIFC_SDP_CNTL_1_BASE_IDX                                                                     5
#define regBIFC_PASID_STS                                                                               0xe82e
#define regBIFC_PASID_STS_BASE_IDX                                                                      5
#define regBIFC_ATHUB_ACT_CNTL                                                                          0xe82f
#define regBIFC_ATHUB_ACT_CNTL_BASE_IDX                                                                 5
#define regBIFC_PERF_CNTL_0                                                                             0xe830
#define regBIFC_PERF_CNTL_0_BASE_IDX                                                                    5
#define regBIFC_PERF_CNTL_1                                                                             0xe831
#define regBIFC_PERF_CNTL_1_BASE_IDX                                                                    5
#define regBIFC_PERF_CNT_MMIO_RD_L32BIT                                                                 0xe832
#define regBIFC_PERF_CNT_MMIO_RD_L32BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_MMIO_WR_L32BIT                                                                 0xe833
#define regBIFC_PERF_CNT_MMIO_WR_L32BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_DMA_RD_L32BIT                                                                  0xe834
#define regBIFC_PERF_CNT_DMA_RD_L32BIT_BASE_IDX                                                         5
#define regBIFC_PERF_CNT_DMA_WR_L32BIT                                                                  0xe835
#define regBIFC_PERF_CNT_DMA_WR_L32BIT_BASE_IDX                                                         5
#define regNBIF_REGIF_ERRSET_CTRL                                                                       0xe836
#define regNBIF_REGIF_ERRSET_CTRL_BASE_IDX                                                              5
#define regBIFC_SDP_CNTL_2                                                                              0xe837
#define regBIFC_SDP_CNTL_2_BASE_IDX                                                                     5
#define regNBIF_PGMST_CTRL                                                                              0xe838
#define regNBIF_PGMST_CTRL_BASE_IDX                                                                     5
#define regNBIF_PGSLV_CTRL                                                                              0xe839
#define regNBIF_PGSLV_CTRL_BASE_IDX                                                                     5
#define regNBIF_PG_MISC_CTRL                                                                            0xe83a
#define regNBIF_PG_MISC_CTRL_BASE_IDX                                                                   5
#define regSMN_MST_EP_CNTL3                                                                             0xe83c
#define regSMN_MST_EP_CNTL3_BASE_IDX                                                                    5
#define regSMN_MST_EP_CNTL4                                                                             0xe83d
#define regSMN_MST_EP_CNTL4_BASE_IDX                                                                    5
#define regSMN_MST_CNTL1                                                                                0xe83e
#define regSMN_MST_CNTL1_BASE_IDX                                                                       5
#define regSMN_MST_EP_CNTL5                                                                             0xe83f
#define regSMN_MST_EP_CNTL5_BASE_IDX                                                                    5
#define regBIF_SELFRING_BUFFER_VID                                                                      0xe840
#define regBIF_SELFRING_BUFFER_VID_BASE_IDX                                                             5
#define regBIF_SELFRING_VECTOR_CNTL                                                                     0xe841
#define regBIF_SELFRING_VECTOR_CNTL_BASE_IDX                                                            5
#define regNBIF_STRAP_WRITE_CTRL                                                                        0xe845
#define regNBIF_STRAP_WRITE_CTRL_BASE_IDX                                                               5
#define regNBIF_INTX_DSTATE_MISC_CNTL                                                                   0xe846
#define regNBIF_INTX_DSTATE_MISC_CNTL_BASE_IDX                                                          5
#define regNBIF_PENDING_MISC_CNTL                                                                       0xe847
#define regNBIF_PENDING_MISC_CNTL_BASE_IDX                                                              5
#define regBIF_GMI_WRR_WEIGHT                                                                           0xe848
#define regBIF_GMI_WRR_WEIGHT_BASE_IDX                                                                  5
#define regBIF_GMI_WRR_WEIGHT2                                                                          0xe849
#define regBIF_GMI_WRR_WEIGHT2_BASE_IDX                                                                 5
#define regBIF_GMI_WRR_WEIGHT3                                                                          0xe84a
#define regBIF_GMI_WRR_WEIGHT3_BASE_IDX                                                                 5
#define regNBIF_PWRBRK_REQUEST                                                                          0xe84c
#define regNBIF_PWRBRK_REQUEST_BASE_IDX                                                                 5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F0                                                                   0xe850
#define regBIF_ATOMIC_ERR_LOG_DEV0_F0_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F1                                                                   0xe851
#define regBIF_ATOMIC_ERR_LOG_DEV0_F1_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F2                                                                   0xe852
#define regBIF_ATOMIC_ERR_LOG_DEV0_F2_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F3                                                                   0xe853
#define regBIF_ATOMIC_ERR_LOG_DEV0_F3_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F4                                                                   0xe854
#define regBIF_ATOMIC_ERR_LOG_DEV0_F4_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F5                                                                   0xe855
#define regBIF_ATOMIC_ERR_LOG_DEV0_F5_BASE_IDX                                                          5
#define regBIF_ATOMIC_ERR_LOG_DEV0_F6                                                                   0xe856
#define regBIF_ATOMIC_ERR_LOG_DEV0_F6_BASE_IDX                                                          5
#define regBIF_DMA_MP4_ERR_LOG                                                                          0xe870
#define regBIF_DMA_MP4_ERR_LOG_BASE_IDX                                                                 5
#define regBIF_PASID_ERR_LOG                                                                            0xe871
#define regBIF_PASID_ERR_LOG_BASE_IDX                                                                   5
#define regBIF_PASID_ERR_CLR                                                                            0xe872
#define regBIF_PASID_ERR_CLR_BASE_IDX                                                                   5
#define regNBIF_VWIRE_CTRL                                                                              0xe880
#define regNBIF_VWIRE_CTRL_BASE_IDX                                                                     5
#define regNBIF_SMN_VWR_VCHG_DIS_CTRL                                                                   0xe881
#define regNBIF_SMN_VWR_VCHG_DIS_CTRL_BASE_IDX                                                          5
#define regNBIF_SMN_VWR_VCHG_RST_CTRL0                                                                  0xe882
#define regNBIF_SMN_VWR_VCHG_RST_CTRL0_BASE_IDX                                                         5
#define regNBIF_SMN_VWR_VCHG_TRIG                                                                       0xe884
#define regNBIF_SMN_VWR_VCHG_TRIG_BASE_IDX                                                              5
#define regNBIF_SMN_VWR_WTRIG_CNTL                                                                      0xe885
#define regNBIF_SMN_VWR_WTRIG_CNTL_BASE_IDX                                                             5
#define regNBIF_SMN_VWR_VCHG_DIS_CTRL_1                                                                 0xe886
#define regNBIF_SMN_VWR_VCHG_DIS_CTRL_1_BASE_IDX                                                        5
#define regNBIF_MGCG_CTRL_LCLK                                                                          0xe887
#define regNBIF_MGCG_CTRL_LCLK_BASE_IDX                                                                 5
#define regNBIF_DS_CTRL_LCLK                                                                            0xe888
#define regNBIF_DS_CTRL_LCLK_BASE_IDX                                                                   5
#define regSMN_MST_CNTL0                                                                                0xe889
#define regSMN_MST_CNTL0_BASE_IDX                                                                       5
#define regSMN_MST_EP_CNTL1                                                                             0xe88a
#define regSMN_MST_EP_CNTL1_BASE_IDX                                                                    5
#define regSMN_MST_EP_CNTL2                                                                             0xe88b
#define regSMN_MST_EP_CNTL2_BASE_IDX                                                                    5
#define regNBIF_SDP_VWR_VCHG_DIS_CTRL                                                                   0xe88c
#define regNBIF_SDP_VWR_VCHG_DIS_CTRL_BASE_IDX                                                          5
#define regNBIF_SDP_VWR_VCHG_RST_CTRL0                                                                  0xe88d
#define regNBIF_SDP_VWR_VCHG_RST_CTRL0_BASE_IDX                                                         5
#define regNBIF_SDP_VWR_VCHG_RST_CTRL1                                                                  0xe88e
#define regNBIF_SDP_VWR_VCHG_RST_CTRL1_BASE_IDX                                                         5
#define regNBIF_SDP_VWR_VCHG_TRIG                                                                       0xe88f
#define regNBIF_SDP_VWR_VCHG_TRIG_BASE_IDX                                                              5
#define regNBIF_SHUB_TODET_CTRL                                                                         0xe898
#define regNBIF_SHUB_TODET_CTRL_BASE_IDX                                                                5
#define regNBIF_SHUB_TODET_CLIENT_CTRL                                                                  0xe899
#define regNBIF_SHUB_TODET_CLIENT_CTRL_BASE_IDX                                                         5
#define regNBIF_SHUB_TODET_CLIENT_STATUS                                                                0xe89a
#define regNBIF_SHUB_TODET_CLIENT_STATUS_BASE_IDX                                                       5
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL                                                               0xe89b
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL_BASE_IDX                                                      5
#define regNBIF_SHUB_TODET_CLIENT_CTRL2                                                                 0xe89c
#define regNBIF_SHUB_TODET_CLIENT_CTRL2_BASE_IDX                                                        5
#define regNBIF_SHUB_TODET_CLIENT_STATUS2                                                               0xe89d
#define regNBIF_SHUB_TODET_CLIENT_STATUS2_BASE_IDX                                                      5
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL2                                                              0xe89e
#define regNBIF_SHUB_TODET_SYNCFLOOD_CTRL2_BASE_IDX                                                     5
#define regBIFC_BME_ERR_LOG_HB                                                                          0xe8ab
#define regBIFC_BME_ERR_LOG_HB_BASE_IDX                                                                 5
#define regBIFC_HRP_SDP_WRRSP_POOLCRED_ALLOC                                                            0xe8c0
#define regBIFC_HRP_SDP_WRRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_HRP_SDP_RDRSP_POOLCRED_ALLOC                                                            0xe8c1
#define regBIFC_HRP_SDP_RDRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_GMI_SDP_REQ_POOLCRED_ALLOC                                                              0xe8c2
#define regBIFC_GMI_SDP_REQ_POOLCRED_ALLOC_BASE_IDX                                                     5
#define regBIFC_GMI_SDP_DAT_POOLCRED_ALLOC                                                              0xe8c3
#define regBIFC_GMI_SDP_DAT_POOLCRED_ALLOC_BASE_IDX                                                     5
#define regBIFC_GMI_SST_RDRSP_POOLCRED_ALLOC                                                            0xe8c4
#define regBIFC_GMI_SST_RDRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regBIFC_GMI_SST_WRRSP_POOLCRED_ALLOC                                                            0xe8c5
#define regBIFC_GMI_SST_WRRSP_POOLCRED_ALLOC_BASE_IDX                                                   5
#define regDISCON_HYSTERESIS_HEAD_CTRL                                                                  0xe8c6
#define regDISCON_HYSTERESIS_HEAD_CTRL_BASE_IDX                                                         5
#define regBIFC_EARLY_WAKEUP_CNTL                                                                       0xe8d2
#define regBIFC_EARLY_WAKEUP_CNTL_BASE_IDX                                                              5
#define regBIFC_PERF_CNT_MMIO_RD_H16BIT                                                                 0xe8f0
#define regBIFC_PERF_CNT_MMIO_RD_H16BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_MMIO_WR_H16BIT                                                                 0xe8f1
#define regBIFC_PERF_CNT_MMIO_WR_H16BIT_BASE_IDX                                                        5
#define regBIFC_PERF_CNT_DMA_RD_H16BIT                                                                  0xe8f2
#define regBIFC_PERF_CNT_DMA_RD_H16BIT_BASE_IDX                                                         5
#define regBIFC_PERF_CNT_DMA_WR_H16BIT                                                                  0xe8f3
#define regBIFC_PERF_CNT_DMA_WR_H16BIT_BASE_IDX                                                         5
#define regNBIF_PERF_COM_COUNT_ENABLE                                                                   0xe8f4
#define regNBIF_PERF_COM_COUNT_ENABLE_BASE_IDX                                                          5
#define regNBIF_BX_PERF_CNT_FSM                                                                         0xe8ff
#define regNBIF_BX_PERF_CNT_FSM_BASE_IDX                                                                5
#define regNBIF_COM_COUNT_VALUE                                                                         0xe908
#define regNBIF_COM_COUNT_VALUE_BASE_IDX                                                                5
#define regBIFC_A2S_SDP_PORT_CTRL                                                                       0xeb00
#define regBIFC_A2S_SDP_PORT_CTRL_BASE_IDX                                                              5
#define regBIFC_A2S_CNTL_SW0                                                                            0xeb01
#define regBIFC_A2S_CNTL_SW0_BASE_IDX                                                                   5
#define regBIFC_A2S_MISC_CNTL                                                                           0xeb02
#define regBIFC_A2S_MISC_CNTL_BASE_IDX                                                                  5
#define regBIFC_A2S_TAG_ALLOC_0                                                                         0xeb03
#define regBIFC_A2S_TAG_ALLOC_0_BASE_IDX                                                                5
#define regBIFC_A2S_TAG_ALLOC_1                                                                         0xeb04
#define regBIFC_A2S_TAG_ALLOC_1_BASE_IDX                                                                5


// addressBlock: nbif_bif_ras_bif_ras_regblk
// base address: 0x10100000
#define regBIFL_RAS_CENTRAL_CNTL                                                                        0xe400
#define regBIFL_RAS_CENTRAL_CNTL_BASE_IDX                                                               5
#define regBIFL_RAS_CENTRAL_STATUS                                                                      0xe410
#define regBIFL_RAS_CENTRAL_STATUS_BASE_IDX                                                             5
#define regBIFL_RAS_LEAF0_CTRL                                                                          0xe420
#define regBIFL_RAS_LEAF0_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF1_CTRL                                                                          0xe421
#define regBIFL_RAS_LEAF1_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF2_CTRL                                                                          0xe422
#define regBIFL_RAS_LEAF2_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF3_CTRL                                                                          0xe423
#define regBIFL_RAS_LEAF3_CTRL_BASE_IDX                                                                 5
#define regBIFL_RAS_LEAF0_STATUS                                                                        0xe430
#define regBIFL_RAS_LEAF0_STATUS_BASE_IDX                                                               5
#define regBIFL_RAS_LEAF1_STATUS                                                                        0xe431
#define regBIFL_RAS_LEAF1_STATUS_BASE_IDX                                                               5
#define regBIFL_RAS_LEAF2_STATUS                                                                        0xe432
#define regBIFL_RAS_LEAF2_STATUS_BASE_IDX                                                               5
#define regBIFL_RAS_LEAF3_STATUS                                                                        0xe433
#define regBIFL_RAS_LEAF3_STATUS_BASE_IDX                                                               5
#define regBIFL_IOHUB_RAS_IH_CNTL                                                                       0xe7fe
#define regBIFL_IOHUB_RAS_IH_CNTL_BASE_IDX                                                              5
#define regBIFL_RAS_VWR_FROM_IOHUB                                                                      0xe7ff
#define regBIFL_RAS_VWR_FROM_IOHUB_BASE_IDX                                                             5


// addressBlock: nbif_rcc_dwn_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_DWN_DEV0_2_DN_PCIE_RESERVED                                                              0x8d80
#define regRCC_DWN_DEV0_2_DN_PCIE_RESERVED_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_2_DN_PCIE_SCRATCH                                                               0x8d81
#define regRCC_DWN_DEV0_2_DN_PCIE_SCRATCH_BASE_IDX                                                      5
#define regRCC_DWN_DEV0_2_DN_PCIE_CNTL                                                                  0x8d83
#define regRCC_DWN_DEV0_2_DN_PCIE_CNTL_BASE_IDX                                                         5
#define regRCC_DWN_DEV0_2_DN_PCIE_CONFIG_CNTL                                                           0x8d84
#define regRCC_DWN_DEV0_2_DN_PCIE_CONFIG_CNTL_BASE_IDX                                                  5
#define regRCC_DWN_DEV0_2_DN_PCIE_RX_CNTL2                                                              0x8d85
#define regRCC_DWN_DEV0_2_DN_PCIE_RX_CNTL2_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_2_DN_PCIE_BUS_CNTL                                                              0x8d86
#define regRCC_DWN_DEV0_2_DN_PCIE_BUS_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_2_DN_PCIE_CFG_CNTL                                                              0x8d87
#define regRCC_DWN_DEV0_2_DN_PCIE_CFG_CNTL_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_F0                                                              0x8d88
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_F0_BASE_IDX                                                     5
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_MISC                                                            0x8d89
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_MISC_BASE_IDX                                                   5
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_MISC2                                                           0x8d8a
#define regRCC_DWN_DEV0_2_DN_PCIE_STRAP_MISC2_BASE_IDX                                                  5


// addressBlock: nbif_rcc_dwnp_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_DWNP_DEV0_2_PCIE_ERR_CNTL                                                                0x8d8c
#define regRCC_DWNP_DEV0_2_PCIE_ERR_CNTL_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_2_PCIE_RX_CNTL                                                                 0x8d8d
#define regRCC_DWNP_DEV0_2_PCIE_RX_CNTL_BASE_IDX                                                        5
#define regRCC_DWNP_DEV0_2_PCIE_LC_SPEED_CNTL                                                           0x8d8e
#define regRCC_DWNP_DEV0_2_PCIE_LC_SPEED_CNTL_BASE_IDX                                                  5
#define regRCC_DWNP_DEV0_2_PCIE_LC_CNTL2                                                                0x8d8f
#define regRCC_DWNP_DEV0_2_PCIE_LC_CNTL2_BASE_IDX                                                       5
#define regRCC_DWNP_DEV0_2_PCIEP_STRAP_MISC                                                             0x8d90
#define regRCC_DWNP_DEV0_2_PCIEP_STRAP_MISC_BASE_IDX                                                    5
#define regRCC_DWNP_DEV0_2_LTR_MSG_INFO_FROM_EP                                                         0x8d91
#define regRCC_DWNP_DEV0_2_LTR_MSG_INFO_FROM_EP_BASE_IDX                                                5


// addressBlock: nbif_rcc_ep_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_EP_DEV0_2_EP_PCIE_SCRATCH                                                                0x8d61
#define regRCC_EP_DEV0_2_EP_PCIE_SCRATCH_BASE_IDX                                                       5
#define regRCC_EP_DEV0_2_EP_PCIE_CNTL                                                                   0x8d63
#define regRCC_EP_DEV0_2_EP_PCIE_CNTL_BASE_IDX                                                          5
#define regRCC_EP_DEV0_2_EP_PCIE_INT_CNTL                                                               0x8d64
#define regRCC_EP_DEV0_2_EP_PCIE_INT_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_INT_STATUS                                                             0x8d65
#define regRCC_EP_DEV0_2_EP_PCIE_INT_STATUS_BASE_IDX                                                    5
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL2                                                               0x8d66
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL2_BASE_IDX                                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_BUS_CNTL                                                               0x8d67
#define regRCC_EP_DEV0_2_EP_PCIE_BUS_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_CFG_CNTL                                                               0x8d68
#define regRCC_EP_DEV0_2_EP_PCIE_CFG_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_TX_LTR_CNTL                                                            0x8d6a
#define regRCC_EP_DEV0_2_EP_PCIE_TX_LTR_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0                                               0x8d6b
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1                                               0x8d6b
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2                                               0x8d6b
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3                                               0x8d6b
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4                                               0x8d6c
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5                                               0x8d6c
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6                                               0x8d6c
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7                                               0x8d6c
#define regRCC_EP_DEV0_1_PCIE_F1_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_STRAP_MISC                                                             0x8d6d
#define regRCC_EP_DEV0_2_EP_PCIE_STRAP_MISC_BASE_IDX                                                    5
#define regRCC_EP_DEV0_2_EP_PCIE_STRAP_MISC2                                                            0x8d6e
#define regRCC_EP_DEV0_2_EP_PCIE_STRAP_MISC2_BASE_IDX                                                   5
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CAP                                                             0x8d70
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CAP_BASE_IDX                                                    5
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_LATENCY_INDICATOR                                               0x8d71
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_LATENCY_INDICATOR_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CNTL                                                            0x8d71
#define regRCC_EP_DEV0_2_EP_PCIE_F0_DPA_CNTL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0                                               0x8d71
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1                                               0x8d72
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2                                               0x8d72
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3                                               0x8d72
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4                                               0x8d72
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5                                               0x8d73
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6                                               0x8d73
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7                                               0x8d73
#define regRCC_EP_DEV0_2_PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7_BASE_IDX                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_PME_CONTROL                                                            0x8d73
#define regRCC_EP_DEV0_2_EP_PCIE_PME_CONTROL_BASE_IDX                                                   5
#define regRCC_EP_DEV0_2_EP_PCIEP_RESERVED                                                              0x8d74
#define regRCC_EP_DEV0_2_EP_PCIEP_RESERVED_BASE_IDX                                                     5
#define regRCC_EP_DEV0_2_EP_PCIE_TX_CNTL                                                                0x8d76
#define regRCC_EP_DEV0_2_EP_PCIE_TX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_2_EP_PCIE_TX_REQUESTER_ID                                                        0x8d77
#define regRCC_EP_DEV0_2_EP_PCIE_TX_REQUESTER_ID_BASE_IDX                                               5
#define regRCC_EP_DEV0_2_EP_PCIE_ERR_CNTL                                                               0x8d78
#define regRCC_EP_DEV0_2_EP_PCIE_ERR_CNTL_BASE_IDX                                                      5
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL                                                                0x8d79
#define regRCC_EP_DEV0_2_EP_PCIE_RX_CNTL_BASE_IDX                                                       5
#define regRCC_EP_DEV0_2_EP_PCIE_LC_SPEED_CNTL                                                          0x8d7a
#define regRCC_EP_DEV0_2_EP_PCIE_LC_SPEED_CNTL_BASE_IDX                                                 5


// addressBlock: nbif_rcc_dev0_BIFDEC1
// base address: 0x10120000
#define regRCC_DEV0_1_RCC_ERR_INT_CNTL                                                                  0x8da6
#define regRCC_DEV0_1_RCC_ERR_INT_CNTL_BASE_IDX                                                         5
#define regRCC_DEV0_1_RCC_BACO_CNTL_MISC                                                                0x8da7
#define regRCC_DEV0_1_RCC_BACO_CNTL_MISC_BASE_IDX                                                       5
#define regRCC_DEV0_1_RCC_RESET_EN                                                                      0x8da8
#define regRCC_DEV0_1_RCC_RESET_EN_BASE_IDX                                                             5
#define regRCC_DEV0_2_RCC_VDM_SUPPORT                                                                   0x8da9
#define regRCC_DEV0_2_RCC_VDM_SUPPORT_BASE_IDX                                                          5
#define regRCC_DEV0_2_RCC_MARGIN_PARAM_CNTL0                                                            0x8daa
#define regRCC_DEV0_2_RCC_MARGIN_PARAM_CNTL0_BASE_IDX                                                   5
#define regRCC_DEV0_2_RCC_MARGIN_PARAM_CNTL1                                                            0x8dab
#define regRCC_DEV0_2_RCC_MARGIN_PARAM_CNTL1_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_GPUIOV_REGION                                                                 0x8dac
#define regRCC_DEV0_1_RCC_GPUIOV_REGION_BASE_IDX                                                        5
#define regRCC_DEV0_1_RCC_GPU_HOSTVM_EN                                                                 0x8dad
#define regRCC_DEV0_1_RCC_GPU_HOSTVM_EN_BASE_IDX                                                        5
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_MODE_CNTL                                                         0x8dae
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_MODE_CNTL_BASE_IDX                                                5
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_FIRST_VF_OFFSET                                                   0x8daf
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_FIRST_VF_OFFSET_BASE_IDX                                          5
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_VF_STRIDE                                                         0x8daf
#define regRCC_DEV0_1_RCC_CONSOLE_IOV_VF_STRIDE_BASE_IDX                                                5
#define regRCC_DEV0_1_RCC_PEER_REG_RANGE0                                                               0x8dde
#define regRCC_DEV0_1_RCC_PEER_REG_RANGE0_BASE_IDX                                                      5
#define regRCC_DEV0_1_RCC_PEER_REG_RANGE1                                                               0x8ddf
#define regRCC_DEV0_1_RCC_PEER_REG_RANGE1_BASE_IDX                                                      5
#define regRCC_DEV0_2_RCC_BUS_CNTL                                                                      0x8de1
#define regRCC_DEV0_2_RCC_BUS_CNTL_BASE_IDX                                                             5
#define regRCC_DEV0_1_RCC_CONFIG_CNTL                                                                   0x8de2
#define regRCC_DEV0_1_RCC_CONFIG_CNTL_BASE_IDX                                                          5
#define regRCC_DEV0_1_RCC_CONFIG_F0_BASE                                                                0x8de6
#define regRCC_DEV0_1_RCC_CONFIG_F0_BASE_BASE_IDX                                                       5
#define regRCC_DEV0_1_RCC_CONFIG_APER_SIZE                                                              0x8de7
#define regRCC_DEV0_1_RCC_CONFIG_APER_SIZE_BASE_IDX                                                     5
#define regRCC_DEV0_1_RCC_CONFIG_REG_APER_SIZE                                                          0x8de8
#define regRCC_DEV0_1_RCC_CONFIG_REG_APER_SIZE_BASE_IDX                                                 5
#define regRCC_DEV0_1_RCC_XDMA_LO                                                                       0x8de9
#define regRCC_DEV0_1_RCC_XDMA_LO_BASE_IDX                                                              5
#define regRCC_DEV0_1_RCC_XDMA_HI                                                                       0x8dea
#define regRCC_DEV0_1_RCC_XDMA_HI_BASE_IDX                                                              5
#define regRCC_DEV0_2_RCC_FEATURES_CONTROL_MISC                                                         0x8deb
#define regRCC_DEV0_2_RCC_FEATURES_CONTROL_MISC_BASE_IDX                                                5
#define regRCC_DEV0_1_RCC_BUSNUM_CNTL1                                                                  0x8dec
#define regRCC_DEV0_1_RCC_BUSNUM_CNTL1_BASE_IDX                                                         5
#define regRCC_DEV0_1_RCC_BUSNUM_LIST0                                                                  0x8ded
#define regRCC_DEV0_1_RCC_BUSNUM_LIST0_BASE_IDX                                                         5
#define regRCC_DEV0_1_RCC_BUSNUM_LIST1                                                                  0x8dee
#define regRCC_DEV0_1_RCC_BUSNUM_LIST1_BASE_IDX                                                         5
#define regRCC_DEV0_1_RCC_BUSNUM_CNTL2                                                                  0x8def
#define regRCC_DEV0_1_RCC_BUSNUM_CNTL2_BASE_IDX                                                         5
#define regRCC_DEV0_1_RCC_CAPTURE_HOST_BUSNUM                                                           0x8df0
#define regRCC_DEV0_1_RCC_CAPTURE_HOST_BUSNUM_BASE_IDX                                                  5
#define regRCC_DEV0_1_RCC_HOST_BUSNUM                                                                   0x8df1
#define regRCC_DEV0_1_RCC_HOST_BUSNUM_BASE_IDX                                                          5
#define regRCC_DEV0_1_RCC_PEER0_FB_OFFSET_HI                                                            0x8df2
#define regRCC_DEV0_1_RCC_PEER0_FB_OFFSET_HI_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER0_FB_OFFSET_LO                                                            0x8df3
#define regRCC_DEV0_1_RCC_PEER0_FB_OFFSET_LO_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER1_FB_OFFSET_HI                                                            0x8df4
#define regRCC_DEV0_1_RCC_PEER1_FB_OFFSET_HI_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER1_FB_OFFSET_LO                                                            0x8df5
#define regRCC_DEV0_1_RCC_PEER1_FB_OFFSET_LO_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER2_FB_OFFSET_HI                                                            0x8df6
#define regRCC_DEV0_1_RCC_PEER2_FB_OFFSET_HI_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER2_FB_OFFSET_LO                                                            0x8df7
#define regRCC_DEV0_1_RCC_PEER2_FB_OFFSET_LO_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER3_FB_OFFSET_HI                                                            0x8df8
#define regRCC_DEV0_1_RCC_PEER3_FB_OFFSET_HI_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_PEER3_FB_OFFSET_LO                                                            0x8df9
#define regRCC_DEV0_1_RCC_PEER3_FB_OFFSET_LO_BASE_IDX                                                   5
#define regRCC_DEV0_1_RCC_DEVFUNCNUM_LIST0                                                              0x8dfa
#define regRCC_DEV0_1_RCC_DEVFUNCNUM_LIST0_BASE_IDX                                                     5
#define regRCC_DEV0_1_RCC_DEVFUNCNUM_LIST1                                                              0x8dfb
#define regRCC_DEV0_1_RCC_DEVFUNCNUM_LIST1_BASE_IDX                                                     5
#define regRCC_DEV0_2_RCC_DEV0_LINK_CNTL                                                                0x8dfd
#define regRCC_DEV0_2_RCC_DEV0_LINK_CNTL_BASE_IDX                                                       5
#define regRCC_DEV0_2_RCC_CMN_LINK_CNTL                                                                 0x8dfe
#define regRCC_DEV0_2_RCC_CMN_LINK_CNTL_BASE_IDX                                                        5
#define regRCC_DEV0_2_RCC_EP_REQUESTERID_RESTORE                                                        0x8dff
#define regRCC_DEV0_2_RCC_EP_REQUESTERID_RESTORE_BASE_IDX                                               5
#define regRCC_DEV0_2_RCC_LTR_LSWITCH_CNTL                                                              0x8e00
#define regRCC_DEV0_2_RCC_LTR_LSWITCH_CNTL_BASE_IDX                                                     5
#define regRCC_DEV0_2_RCC_MH_ARB_CNTL                                                                   0x8e01
#define regRCC_DEV0_2_RCC_MH_ARB_CNTL_BASE_IDX                                                          5


// addressBlock: nbif_bif_bx_SYSDEC
// base address: 0x10120000
#define regBIF_BX1_PCIE_INDEX                                                                           0x800c
#define regBIF_BX1_PCIE_INDEX_BASE_IDX                                                                  5
#define regBIF_BX1_PCIE_DATA                                                                            0x800d
#define regBIF_BX1_PCIE_DATA_BASE_IDX                                                                   5
#define regBIF_BX1_PCIE_INDEX2                                                                          0x800e
#define regBIF_BX1_PCIE_INDEX2_BASE_IDX                                                                 5
#define regBIF_BX1_PCIE_DATA2                                                                           0x800f
#define regBIF_BX1_PCIE_DATA2_BASE_IDX                                                                  5
#define regBIF_BX1_PCIE_INDEX_HI                                                                        0x8010
#define regBIF_BX1_PCIE_INDEX_HI_BASE_IDX                                                               5
#define regBIF_BX1_PCIE_INDEX2_HI                                                                       0x8011
#define regBIF_BX1_PCIE_INDEX2_HI_BASE_IDX                                                              5
#define regBIF_BX1_SBIOS_SCRATCH_0                                                                      0x8048
#define regBIF_BX1_SBIOS_SCRATCH_0_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_1                                                                      0x8049
#define regBIF_BX1_SBIOS_SCRATCH_1_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_2                                                                      0x804a
#define regBIF_BX1_SBIOS_SCRATCH_2_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_3                                                                      0x804b
#define regBIF_BX1_SBIOS_SCRATCH_3_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_0                                                                       0x804c
#define regBIF_BX1_BIOS_SCRATCH_0_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_1                                                                       0x804d
#define regBIF_BX1_BIOS_SCRATCH_1_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_2                                                                       0x804e
#define regBIF_BX1_BIOS_SCRATCH_2_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_3                                                                       0x804f
#define regBIF_BX1_BIOS_SCRATCH_3_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_4                                                                       0x8050
#define regBIF_BX1_BIOS_SCRATCH_4_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_5                                                                       0x8051
#define regBIF_BX1_BIOS_SCRATCH_5_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_6                                                                       0x8052
#define regBIF_BX1_BIOS_SCRATCH_6_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_7                                                                       0x8053
#define regBIF_BX1_BIOS_SCRATCH_7_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_8                                                                       0x8054
#define regBIF_BX1_BIOS_SCRATCH_8_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_9                                                                       0x8055
#define regBIF_BX1_BIOS_SCRATCH_9_BASE_IDX                                                              5
#define regBIF_BX1_BIOS_SCRATCH_10                                                                      0x8056
#define regBIF_BX1_BIOS_SCRATCH_10_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_11                                                                      0x8057
#define regBIF_BX1_BIOS_SCRATCH_11_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_12                                                                      0x8058
#define regBIF_BX1_BIOS_SCRATCH_12_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_13                                                                      0x8059
#define regBIF_BX1_BIOS_SCRATCH_13_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_14                                                                      0x805a
#define regBIF_BX1_BIOS_SCRATCH_14_BASE_IDX                                                             5
#define regBIF_BX1_BIOS_SCRATCH_15                                                                      0x805b
#define regBIF_BX1_BIOS_SCRATCH_15_BASE_IDX                                                             5
#define regBIF_BX1_BIF_RLC_INTR_CNTL                                                                    0x8060
#define regBIF_BX1_BIF_RLC_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX1_BIF_VCE_INTR_CNTL                                                                    0x8061
#define regBIF_BX1_BIF_VCE_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX1_BIF_UVD_INTR_CNTL                                                                    0x8062
#define regBIF_BX1_BIF_UVD_INTR_CNTL_BASE_IDX                                                           5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR0                                                                0x8080
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR0_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR0                                                          0x8081
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR0_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR1                                                                0x8082
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR1_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR1                                                          0x8083
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR1_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR2                                                                0x8084
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR2_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR2                                                          0x8085
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR2_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR3                                                                0x8086
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR3_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR3                                                          0x8087
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR3_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR4                                                                0x8088
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR4_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR4                                                          0x8089
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR4_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR5                                                                0x808a
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR5_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR5                                                          0x808b
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR5_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR6                                                                0x808c
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR6_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR6                                                          0x808d
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR6_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR7                                                                0x808e
#define regBIF_BX1_GFX_MMIOREG_CAM_ADDR7_BASE_IDX                                                       5
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR7                                                          0x808f
#define regBIF_BX1_GFX_MMIOREG_CAM_REMAP_ADDR7_BASE_IDX                                                 5
#define regBIF_BX1_GFX_MMIOREG_CAM_CNTL                                                                 0x8090
#define regBIF_BX1_GFX_MMIOREG_CAM_CNTL_BASE_IDX                                                        5
#define regBIF_BX1_GFX_MMIOREG_CAM_ZERO_CPL                                                             0x8091
#define regBIF_BX1_GFX_MMIOREG_CAM_ZERO_CPL_BASE_IDX                                                    5
#define regBIF_BX1_GFX_MMIOREG_CAM_ONE_CPL                                                              0x8092
#define regBIF_BX1_GFX_MMIOREG_CAM_ONE_CPL_BASE_IDX                                                     5
#define regBIF_BX1_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL                                                     0x8093
#define regBIF_BX1_GFX_MMIOREG_CAM_PROGRAMMABLE_CPL_BASE_IDX                                            5
#define regBIF_BX1_DRIVER_SCRATCH_0                                                                     0x8094
#define regBIF_BX1_DRIVER_SCRATCH_0_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_1                                                                     0x8095
#define regBIF_BX1_DRIVER_SCRATCH_1_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_2                                                                     0x8096
#define regBIF_BX1_DRIVER_SCRATCH_2_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_3                                                                     0x8097
#define regBIF_BX1_DRIVER_SCRATCH_3_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_4                                                                     0x8098
#define regBIF_BX1_DRIVER_SCRATCH_4_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_5                                                                     0x8099
#define regBIF_BX1_DRIVER_SCRATCH_5_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_6                                                                     0x809a
#define regBIF_BX1_DRIVER_SCRATCH_6_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_7                                                                     0x809b
#define regBIF_BX1_DRIVER_SCRATCH_7_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_8                                                                     0x809c
#define regBIF_BX1_DRIVER_SCRATCH_8_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_9                                                                     0x809d
#define regBIF_BX1_DRIVER_SCRATCH_9_BASE_IDX                                                            5
#define regBIF_BX1_DRIVER_SCRATCH_10                                                                    0x809e
#define regBIF_BX1_DRIVER_SCRATCH_10_BASE_IDX                                                           5
#define regBIF_BX1_DRIVER_SCRATCH_11                                                                    0x809f
#define regBIF_BX1_DRIVER_SCRATCH_11_BASE_IDX                                                           5
#define regBIF_BX1_DRIVER_SCRATCH_12                                                                    0x80a0
#define regBIF_BX1_DRIVER_SCRATCH_12_BASE_IDX                                                           5
#define regBIF_BX1_DRIVER_SCRATCH_13                                                                    0x80a1
#define regBIF_BX1_DRIVER_SCRATCH_13_BASE_IDX                                                           5
#define regBIF_BX1_DRIVER_SCRATCH_14                                                                    0x80a2
#define regBIF_BX1_DRIVER_SCRATCH_14_BASE_IDX                                                           5
#define regBIF_BX1_DRIVER_SCRATCH_15                                                                    0x80a3
#define regBIF_BX1_DRIVER_SCRATCH_15_BASE_IDX                                                           5
#define regBIF_BX1_FW_SCRATCH_0                                                                         0x80a4
#define regBIF_BX1_FW_SCRATCH_0_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_1                                                                         0x80a5
#define regBIF_BX1_FW_SCRATCH_1_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_2                                                                         0x80a6
#define regBIF_BX1_FW_SCRATCH_2_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_3                                                                         0x80a7
#define regBIF_BX1_FW_SCRATCH_3_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_4                                                                         0x80a8
#define regBIF_BX1_FW_SCRATCH_4_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_5                                                                         0x80a9
#define regBIF_BX1_FW_SCRATCH_5_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_6                                                                         0x80aa
#define regBIF_BX1_FW_SCRATCH_6_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_7                                                                         0x80ab
#define regBIF_BX1_FW_SCRATCH_7_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_8                                                                         0x80ac
#define regBIF_BX1_FW_SCRATCH_8_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_9                                                                         0x80ad
#define regBIF_BX1_FW_SCRATCH_9_BASE_IDX                                                                5
#define regBIF_BX1_FW_SCRATCH_10                                                                        0x80ae
#define regBIF_BX1_FW_SCRATCH_10_BASE_IDX                                                               5
#define regBIF_BX1_FW_SCRATCH_11                                                                        0x80af
#define regBIF_BX1_FW_SCRATCH_11_BASE_IDX                                                               5
#define regBIF_BX1_FW_SCRATCH_12                                                                        0x80b0
#define regBIF_BX1_FW_SCRATCH_12_BASE_IDX                                                               5
#define regBIF_BX1_FW_SCRATCH_13                                                                        0x80b1
#define regBIF_BX1_FW_SCRATCH_13_BASE_IDX                                                               5
#define regBIF_BX1_FW_SCRATCH_14                                                                        0x80b2
#define regBIF_BX1_FW_SCRATCH_14_BASE_IDX                                                               5
#define regBIF_BX1_FW_SCRATCH_15                                                                        0x80b3
#define regBIF_BX1_FW_SCRATCH_15_BASE_IDX                                                               5
#define regBIF_BX1_SBIOS_SCRATCH_4                                                                      0x80b4
#define regBIF_BX1_SBIOS_SCRATCH_4_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_5                                                                      0x80b5
#define regBIF_BX1_SBIOS_SCRATCH_5_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_6                                                                      0x80b6
#define regBIF_BX1_SBIOS_SCRATCH_6_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_7                                                                      0x80b7
#define regBIF_BX1_SBIOS_SCRATCH_7_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_8                                                                      0x80b8
#define regBIF_BX1_SBIOS_SCRATCH_8_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_9                                                                      0x80b9
#define regBIF_BX1_SBIOS_SCRATCH_9_BASE_IDX                                                             5
#define regBIF_BX1_SBIOS_SCRATCH_10                                                                     0x80ba
#define regBIF_BX1_SBIOS_SCRATCH_10_BASE_IDX                                                            5
#define regBIF_BX1_SBIOS_SCRATCH_11                                                                     0x80bb
#define regBIF_BX1_SBIOS_SCRATCH_11_BASE_IDX                                                            5
#define regBIF_BX1_SBIOS_SCRATCH_12                                                                     0x80bc
#define regBIF_BX1_SBIOS_SCRATCH_12_BASE_IDX                                                            5
#define regBIF_BX1_SBIOS_SCRATCH_13                                                                     0x80bd
#define regBIF_BX1_SBIOS_SCRATCH_13_BASE_IDX                                                            5
#define regBIF_BX1_SBIOS_SCRATCH_14                                                                     0x80be
#define regBIF_BX1_SBIOS_SCRATCH_14_BASE_IDX                                                            5
#define regBIF_BX1_SBIOS_SCRATCH_15                                                                     0x80bf
#define regBIF_BX1_SBIOS_SCRATCH_15_BASE_IDX                                                            5


// addressBlock: nbif_bif_bx_pf_SYSPFVFDEC
// base address: 0x10120000
#define regBIF_BX_PF1_MM_INDEX                                                                          0x8000
#define regBIF_BX_PF1_MM_INDEX_BASE_IDX                                                                 5
#define regBIF_BX_PF1_MM_DATA                                                                           0x8001
#define regBIF_BX_PF1_MM_DATA_BASE_IDX                                                                  5
#define regBIF_BX_PF1_MM_INDEX_HI                                                                       0x8006
#define regBIF_BX_PF1_MM_INDEX_HI_BASE_IDX                                                              5
#define regBIF_BX_PF1_RSMU_INDEX                                                                        0x8014
#define regBIF_BX_PF1_RSMU_INDEX_BASE_IDX                                                               5
#define regBIF_BX_PF1_RSMU_DATA                                                                         0x8015
#define regBIF_BX_PF1_RSMU_DATA_BASE_IDX                                                                5


// addressBlock: nbif_bif_bx_BIFDEC1
// base address: 0x10120000
#define regBIF_BX1_CC_BIF_BX_STRAP0                                                                     0x8e02
#define regBIF_BX1_CC_BIF_BX_STRAP0_BASE_IDX                                                            5
#define regBIF_BX1_CC_BIF_BX_PINSTRAP0                                                                  0x8e04
#define regBIF_BX1_CC_BIF_BX_PINSTRAP0_BASE_IDX                                                         5
#define regBIF_BX1_BIF_MM_INDACCESS_CNTL                                                                0x8e06
#define regBIF_BX1_BIF_MM_INDACCESS_CNTL_BASE_IDX                                                       5
#define regBIF_BX1_BUS_CNTL                                                                             0x8e07
#define regBIF_BX1_BUS_CNTL_BASE_IDX                                                                    5
#define regBIF_BX1_BIF_SCRATCH0                                                                         0x8e08
#define regBIF_BX1_BIF_SCRATCH0_BASE_IDX                                                                5
#define regBIF_BX1_BIF_SCRATCH1                                                                         0x8e09
#define regBIF_BX1_BIF_SCRATCH1_BASE_IDX                                                                5
#define regBIF_BX1_BX_RESET_EN                                                                          0x8e0d
#define regBIF_BX1_BX_RESET_EN_BASE_IDX                                                                 5
#define regBIF_BX1_MM_CFGREGS_CNTL                                                                      0x8e0e
#define regBIF_BX1_MM_CFGREGS_CNTL_BASE_IDX                                                             5
#define regBIF_BX1_BX_RESET_CNTL                                                                        0x8e10
#define regBIF_BX1_BX_RESET_CNTL_BASE_IDX                                                               5
#define regBIF_BX1_INTERRUPT_CNTL                                                                       0x8e11
#define regBIF_BX1_INTERRUPT_CNTL_BASE_IDX                                                              5
#define regBIF_BX1_INTERRUPT_CNTL2                                                                      0x8e12
#define regBIF_BX1_INTERRUPT_CNTL2_BASE_IDX                                                             5
#define regBIF_BX1_CLKREQB_PAD_CNTL                                                                     0x8e18
#define regBIF_BX1_CLKREQB_PAD_CNTL_BASE_IDX                                                            5
#define regBIF_BX1_BIF_FEATURES_CONTROL_MISC                                                            0x8e1b
#define regBIF_BX1_BIF_FEATURES_CONTROL_MISC_BASE_IDX                                                   5
#define regBIF_BX1_HDP_ATOMIC_CONTROL_MISC                                                              0x8e1c
#define regBIF_BX1_HDP_ATOMIC_CONTROL_MISC_BASE_IDX                                                     5
#define regBIF_BX1_BIF_DOORBELL_CNTL                                                                    0x8e1d
#define regBIF_BX1_BIF_DOORBELL_CNTL_BASE_IDX                                                           5
#define regBIF_BX1_BIF_DOORBELL_INT_CNTL                                                                0x8e1e
#define regBIF_BX1_BIF_DOORBELL_INT_CNTL_BASE_IDX                                                       5
#define regBIF_BX1_BIF_FB_EN                                                                            0x8e20
#define regBIF_BX1_BIF_FB_EN_BASE_IDX                                                                   5
#define regBIF_BX1_BIF_INTR_CNTL                                                                        0x8e21
#define regBIF_BX1_BIF_INTR_CNTL_BASE_IDX                                                               5
#define regBIF_BX1_BIF_MST_TRANS_PENDING_VF                                                             0x8e29
#define regBIF_BX1_BIF_MST_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX1_BIF_SLV_TRANS_PENDING_VF                                                             0x8e2a
#define regBIF_BX1_BIF_SLV_TRANS_PENDING_VF_BASE_IDX                                                    5
#define regBIF_BX1_BACO_CNTL                                                                            0x8e2b
#define regBIF_BX1_BACO_CNTL_BASE_IDX                                                                   5
#define regBIF_BX1_BIF_BACO_EXIT_TIME0                                                                  0x8e2c
#define regBIF_BX1_BIF_BACO_EXIT_TIME0_BASE_IDX                                                         5
#define regBIF_BX1_BIF_BACO_EXIT_TIMER1                                                                 0x8e2d
#define regBIF_BX1_BIF_BACO_EXIT_TIMER1_BASE_IDX                                                        5
#define regBIF_BX1_BIF_BACO_EXIT_TIMER2                                                                 0x8e2e
#define regBIF_BX1_BIF_BACO_EXIT_TIMER2_BASE_IDX                                                        5
#define regBIF_BX1_BIF_BACO_EXIT_TIMER3                                                                 0x8e2f
#define regBIF_BX1_BIF_BACO_EXIT_TIMER3_BASE_IDX                                                        5
#define regBIF_BX1_BIF_BACO_EXIT_TIMER4                                                                 0x8e30
#define regBIF_BX1_BIF_BACO_EXIT_TIMER4_BASE_IDX                                                        5
#define regBIF_BX1_MEM_TYPE_CNTL                                                                        0x8e31
#define regBIF_BX1_MEM_TYPE_CNTL_BASE_IDX                                                               5
#define regBIF_BX1_VF_REGWR_EN                                                                          0x8e44
#define regBIF_BX1_VF_REGWR_EN_BASE_IDX                                                                 5
#define regBIF_BX1_VF_DOORBELL_EN                                                                       0x8e45
#define regBIF_BX1_VF_DOORBELL_EN_BASE_IDX                                                              5
#define regBIF_BX1_VF_FB_EN                                                                             0x8e46
#define regBIF_BX1_VF_FB_EN_BASE_IDX                                                                    5
#define regBIF_BX1_VF_REGWR_STATUS                                                                      0x8e47
#define regBIF_BX1_VF_REGWR_STATUS_BASE_IDX                                                             5
#define regBIF_BX1_VF_DOORBELL_STATUS                                                                   0x8e48
#define regBIF_BX1_VF_DOORBELL_STATUS_BASE_IDX                                                          5
#define regBIF_BX1_VF_FB_STATUS                                                                         0x8e49
#define regBIF_BX1_VF_FB_STATUS_BASE_IDX                                                                5
#define regBIF_BX1_REMAP_HDP_MEM_FLUSH_CNTL                                                             0x8e4d
#define regBIF_BX1_REMAP_HDP_MEM_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX1_REMAP_HDP_REG_FLUSH_CNTL                                                             0x8e4e
#define regBIF_BX1_REMAP_HDP_REG_FLUSH_CNTL_BASE_IDX                                                    5
#define regBIF_BX1_BIF_RB_CNTL                                                                          0x8e4f
#define regBIF_BX1_BIF_RB_CNTL_BASE_IDX                                                                 5
#define regBIF_BX1_BIF_RB_BASE                                                                          0x8e50
#define regBIF_BX1_BIF_RB_BASE_BASE_IDX                                                                 5
#define regBIF_BX1_BIF_RB_RPTR                                                                          0x8e51
#define regBIF_BX1_BIF_RB_RPTR_BASE_IDX                                                                 5
#define regBIF_BX1_BIF_RB_WPTR                                                                          0x8e52
#define regBIF_BX1_BIF_RB_WPTR_BASE_IDX                                                                 5
#define regBIF_BX1_BIF_RB_WPTR_ADDR_HI                                                                  0x8e53
#define regBIF_BX1_BIF_RB_WPTR_ADDR_HI_BASE_IDX                                                         5
#define regBIF_BX1_BIF_RB_WPTR_ADDR_LO                                                                  0x8e54
#define regBIF_BX1_BIF_RB_WPTR_ADDR_LO_BASE_IDX                                                         5
#define regBIF_BX1_MAILBOX_INDEX                                                                        0x8e55
#define regBIF_BX1_MAILBOX_INDEX_BASE_IDX                                                               5
#define regBIF_BX1_BIF_MP1_INTR_CTRL                                                                    0x8e62
#define regBIF_BX1_BIF_MP1_INTR_CTRL_BASE_IDX                                                           5
#define regBIF_BX1_BIF_PERSTB_PAD_CNTL                                                                  0x8e65
#define regBIF_BX1_BIF_PERSTB_PAD_CNTL_BASE_IDX                                                         5
#define regBIF_BX1_BIF_PX_EN_PAD_CNTL                                                                   0x8e66
#define regBIF_BX1_BIF_PX_EN_PAD_CNTL_BASE_IDX                                                          5
#define regBIF_BX1_BIF_REFPADKIN_PAD_CNTL                                                               0x8e67
#define regBIF_BX1_BIF_REFPADKIN_PAD_CNTL_BASE_IDX                                                      5
#define regBIF_BX1_BIF_CLKREQB_PAD_CNTL                                                                 0x8e68
#define regBIF_BX1_BIF_CLKREQB_PAD_CNTL_BASE_IDX                                                        5
#define regBIF_BX1_BIF_PWRBRK_PAD_CNTL                                                                  0x8e69
#define regBIF_BX1_BIF_PWRBRK_PAD_CNTL_BASE_IDX                                                         5
#define regBIF_BX1_BIF_WAKEB_PAD_CNTL                                                                   0x8e6d
#define regBIF_BX1_BIF_WAKEB_PAD_CNTL_BASE_IDX                                                          5
#define regBIF_BX1_BIF_VAUX_PRESENT_PAD_CNTL                                                            0x8e6e
#define regBIF_BX1_BIF_VAUX_PRESENT_PAD_CNTL_BASE_IDX                                                   5
#define regBIF_BX1_PCIE_PAR_SAVE_RESTORE_CNTL                                                           0x8e70
#define regBIF_BX1_PCIE_PAR_SAVE_RESTORE_CNTL_BASE_IDX                                                  5
#define regBIF_BX1_BIF_S5_MEM_POWER_CTRL0                                                               0x8e71
#define regBIF_BX1_BIF_S5_MEM_POWER_CTRL0_BASE_IDX                                                      5
#define regBIF_BX1_BIF_S5_MEM_POWER_CTRL1                                                               0x8e72
#define regBIF_BX1_BIF_S5_MEM_POWER_CTRL1_BASE_IDX                                                      5
#define regBIF_BX1_BIF_S5_DUMMY_REGS                                                                    0x8e73
#define regBIF_BX1_BIF_S5_DUMMY_REGS_BASE_IDX                                                           5


// addressBlock: nbif_bif_bx_pf_BIFPFVFDEC1
// base address: 0x10120000
#define regBIF_BX_PF1_BIF_BME_STATUS                                                                    0x8e0b
#define regBIF_BX_PF1_BIF_BME_STATUS_BASE_IDX                                                           5
#define regBIF_BX_PF1_BIF_ATOMIC_ERR_LOG                                                                0x8e0c
#define regBIF_BX_PF1_BIF_ATOMIC_ERR_LOG_BASE_IDX                                                       5
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                              0x8e13
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                                     5
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                               0x8e14
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                                      5
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_CNTL                                                   0x8e15
#define regBIF_BX_PF1_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                          5
#define regBIF_BX_PF1_HDP_REG_COHERENCY_FLUSH_CNTL                                                      0x8e16
#define regBIF_BX_PF1_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_CNTL                                                      0x8e17
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                             5
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                                 0x8e19
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                                        5
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                            0x8e1a
#define regBIF_BX_PF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                                   5
#define regBIF_BX_PF1_GPU_HDP_FLUSH_REQ                                                                 0x8e26
#define regBIF_BX_PF1_GPU_HDP_FLUSH_REQ_BASE_IDX                                                        5
#define regBIF_BX_PF1_GPU_HDP_FLUSH_DONE                                                                0x8e27
#define regBIF_BX_PF1_GPU_HDP_FLUSH_DONE_BASE_IDX                                                       5
#define regBIF_BX_PF1_BIF_TRANS_PENDING                                                                 0x8e28
#define regBIF_BX_PF1_BIF_TRANS_PENDING_BASE_IDX                                                        5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW0                                                            0x8e56
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW1                                                            0x8e57
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW2                                                            0x8e58
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW3                                                            0x8e59
#define regBIF_BX_PF1_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW0                                                            0x8e5a
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW1                                                            0x8e5b
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW2                                                            0x8e5c
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW3                                                            0x8e5d
#define regBIF_BX_PF1_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                                   5
#define regBIF_BX_PF1_MAILBOX_CONTROL                                                                   0x8e5e
#define regBIF_BX_PF1_MAILBOX_CONTROL_BASE_IDX                                                          5
#define regBIF_BX_PF1_MAILBOX_INT_CNTL                                                                  0x8e5f
#define regBIF_BX_PF1_MAILBOX_INT_CNTL_BASE_IDX                                                         5
#define regBIF_BX_PF1_BIF_VMHV_MAILBOX                                                                  0x8e60
#define regBIF_BX_PF1_BIF_VMHV_MAILBOX_BASE_IDX                                                         5


// addressBlock: nbif_rcc_strap_BIFDEC1:1
// base address: 0x10120000
#define regRCC_STRAP2_RCC_BIF_STRAP0                                                                    0x8d20
#define regRCC_STRAP2_RCC_BIF_STRAP0_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP1                                                                    0x8d21
#define regRCC_STRAP2_RCC_BIF_STRAP1_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP2                                                                    0x8d25
#define regRCC_STRAP2_RCC_BIF_STRAP2_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP3                                                                    0x8d26
#define regRCC_STRAP2_RCC_BIF_STRAP3_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP4                                                                    0x8d27
#define regRCC_STRAP2_RCC_BIF_STRAP4_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP5                                                                    0x8d28
#define regRCC_STRAP2_RCC_BIF_STRAP5_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_BIF_STRAP6                                                                    0x8d29
#define regRCC_STRAP2_RCC_BIF_STRAP6_BASE_IDX                                                           5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP0                                                              0x8d2d
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP1                                                              0x8d2e
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP1_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP10                                                             0x8d2f
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP10_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP11                                                             0x8d30
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP11_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP12                                                             0x8d31
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP12_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP13                                                             0x8d32
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP13_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP14                                                             0x8d33
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP14_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP2                                                              0x8d34
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP3                                                              0x8d35
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP4                                                              0x8d36
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP5                                                              0x8d37
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP6                                                              0x8d38
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP6_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP7                                                              0x8d39
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP7_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP8                                                              0x8d3a
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP8_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP9                                                              0x8d3b
#define regRCC_STRAP2_RCC_DEV0_PORT_STRAP9_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP0                                                              0x8d3c
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP1                                                              0x8d3d
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP1_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP13                                                             0x8d3e
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP13_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP14                                                             0x8d3f
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP14_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP15                                                             0x8d40
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP15_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP16                                                             0x8d41
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP16_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP17                                                             0x8d42
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP17_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP18                                                             0x8d43
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP18_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP2                                                              0x8d44
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP3                                                              0x8d46
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP4                                                              0x8d47
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP5                                                              0x8d48
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP8                                                              0x8d49
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP8_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP9                                                              0x8d4a
#define regRCC_STRAP2_RCC_DEV0_EPF0_STRAP9_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP0                                                              0x8d4b
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP0_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP2                                                              0x8d56
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP2_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP20                                                             0x8d57
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP20_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP21                                                             0x8d58
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP21_BASE_IDX                                                    5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP3                                                              0x8d59
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP3_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP4                                                              0x8d5a
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP4_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP5                                                              0x8d5b
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP5_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP6                                                              0x8d5c
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP6_BASE_IDX                                                     5
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP7                                                              0x8d5d
#define regRCC_STRAP2_RCC_DEV0_EPF1_STRAP7_BASE_IDX                                                     5


// addressBlock: nbif_gdc_dma_sion_SIONDEC
// base address: 0x1400000
#define regGDC_DMA_SION_CL0_RdRsp_BurstTarget_REG0                                                      0x4f7400
#define regGDC_DMA_SION_CL0_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL0_RdRsp_BurstTarget_REG1                                                      0x4f7401
#define regGDC_DMA_SION_CL0_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL0_RdRsp_TimeSlot_REG0                                                         0x4f7402
#define regGDC_DMA_SION_CL0_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL0_RdRsp_TimeSlot_REG1                                                         0x4f7403
#define regGDC_DMA_SION_CL0_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL0_WrRsp_BurstTarget_REG0                                                      0x4f7404
#define regGDC_DMA_SION_CL0_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL0_WrRsp_BurstTarget_REG1                                                      0x4f7405
#define regGDC_DMA_SION_CL0_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL0_WrRsp_TimeSlot_REG0                                                         0x4f7406
#define regGDC_DMA_SION_CL0_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL0_WrRsp_TimeSlot_REG1                                                         0x4f7407
#define regGDC_DMA_SION_CL0_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL0_Req_BurstTarget_REG0                                                        0x4f7408
#define regGDC_DMA_SION_CL0_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_DMA_SION_CL0_Req_BurstTarget_REG1                                                        0x4f7409
#define regGDC_DMA_SION_CL0_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_DMA_SION_CL0_Req_TimeSlot_REG0                                                           0x4f740a
#define regGDC_DMA_SION_CL0_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL0_Req_TimeSlot_REG1                                                           0x4f740b
#define regGDC_DMA_SION_CL0_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL0_ReqPoolCredit_Alloc_REG0                                                    0x4f740c
#define regGDC_DMA_SION_CL0_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_DMA_SION_CL0_ReqPoolCredit_Alloc_REG1                                                    0x4f740d
#define regGDC_DMA_SION_CL0_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_DMA_SION_CL0_DataPoolCredit_Alloc_REG0                                                   0x4f740e
#define regGDC_DMA_SION_CL0_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_DMA_SION_CL0_DataPoolCredit_Alloc_REG1                                                   0x4f740f
#define regGDC_DMA_SION_CL0_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_DMA_SION_CL0_RdRspPoolCredit_Alloc_REG0                                                  0x4f7410
#define regGDC_DMA_SION_CL0_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL0_RdRspPoolCredit_Alloc_REG1                                                  0x4f7411
#define regGDC_DMA_SION_CL0_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL0_WrRspPoolCredit_Alloc_REG0                                                  0x4f7412
#define regGDC_DMA_SION_CL0_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL0_WrRspPoolCredit_Alloc_REG1                                                  0x4f7413
#define regGDC_DMA_SION_CL0_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL1_RdRsp_BurstTarget_REG0                                                      0x4f7414
#define regGDC_DMA_SION_CL1_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL1_RdRsp_BurstTarget_REG1                                                      0x4f7415
#define regGDC_DMA_SION_CL1_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL1_RdRsp_TimeSlot_REG0                                                         0x4f7416
#define regGDC_DMA_SION_CL1_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL1_RdRsp_TimeSlot_REG1                                                         0x4f7417
#define regGDC_DMA_SION_CL1_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL1_WrRsp_BurstTarget_REG0                                                      0x4f7418
#define regGDC_DMA_SION_CL1_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL1_WrRsp_BurstTarget_REG1                                                      0x4f7419
#define regGDC_DMA_SION_CL1_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL1_WrRsp_TimeSlot_REG0                                                         0x4f741a
#define regGDC_DMA_SION_CL1_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL1_WrRsp_TimeSlot_REG1                                                         0x4f741b
#define regGDC_DMA_SION_CL1_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL1_Req_BurstTarget_REG0                                                        0x4f741c
#define regGDC_DMA_SION_CL1_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_DMA_SION_CL1_Req_BurstTarget_REG1                                                        0x4f741d
#define regGDC_DMA_SION_CL1_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_DMA_SION_CL1_Req_TimeSlot_REG0                                                           0x4f741e
#define regGDC_DMA_SION_CL1_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL1_Req_TimeSlot_REG1                                                           0x4f741f
#define regGDC_DMA_SION_CL1_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL1_ReqPoolCredit_Alloc_REG0                                                    0x4f7420
#define regGDC_DMA_SION_CL1_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_DMA_SION_CL1_ReqPoolCredit_Alloc_REG1                                                    0x4f7421
#define regGDC_DMA_SION_CL1_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_DMA_SION_CL1_DataPoolCredit_Alloc_REG0                                                   0x4f7422
#define regGDC_DMA_SION_CL1_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_DMA_SION_CL1_DataPoolCredit_Alloc_REG1                                                   0x4f7423
#define regGDC_DMA_SION_CL1_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_DMA_SION_CL1_RdRspPoolCredit_Alloc_REG0                                                  0x4f7424
#define regGDC_DMA_SION_CL1_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL1_RdRspPoolCredit_Alloc_REG1                                                  0x4f7425
#define regGDC_DMA_SION_CL1_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL1_WrRspPoolCredit_Alloc_REG0                                                  0x4f7426
#define regGDC_DMA_SION_CL1_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL1_WrRspPoolCredit_Alloc_REG1                                                  0x4f7427
#define regGDC_DMA_SION_CL1_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL2_RdRsp_BurstTarget_REG0                                                      0x4f7428
#define regGDC_DMA_SION_CL2_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL2_RdRsp_BurstTarget_REG1                                                      0x4f7429
#define regGDC_DMA_SION_CL2_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL2_RdRsp_TimeSlot_REG0                                                         0x4f742a
#define regGDC_DMA_SION_CL2_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL2_RdRsp_TimeSlot_REG1                                                         0x4f742b
#define regGDC_DMA_SION_CL2_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL2_WrRsp_BurstTarget_REG0                                                      0x4f742c
#define regGDC_DMA_SION_CL2_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL2_WrRsp_BurstTarget_REG1                                                      0x4f742d
#define regGDC_DMA_SION_CL2_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL2_WrRsp_TimeSlot_REG0                                                         0x4f742e
#define regGDC_DMA_SION_CL2_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL2_WrRsp_TimeSlot_REG1                                                         0x4f742f
#define regGDC_DMA_SION_CL2_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL2_Req_BurstTarget_REG0                                                        0x4f7430
#define regGDC_DMA_SION_CL2_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_DMA_SION_CL2_Req_BurstTarget_REG1                                                        0x4f7431
#define regGDC_DMA_SION_CL2_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_DMA_SION_CL2_Req_TimeSlot_REG0                                                           0x4f7432
#define regGDC_DMA_SION_CL2_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL2_Req_TimeSlot_REG1                                                           0x4f7433
#define regGDC_DMA_SION_CL2_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL2_ReqPoolCredit_Alloc_REG0                                                    0x4f7434
#define regGDC_DMA_SION_CL2_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_DMA_SION_CL2_ReqPoolCredit_Alloc_REG1                                                    0x4f7435
#define regGDC_DMA_SION_CL2_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_DMA_SION_CL2_DataPoolCredit_Alloc_REG0                                                   0x4f7436
#define regGDC_DMA_SION_CL2_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_DMA_SION_CL2_DataPoolCredit_Alloc_REG1                                                   0x4f7437
#define regGDC_DMA_SION_CL2_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_DMA_SION_CL2_RdRspPoolCredit_Alloc_REG0                                                  0x4f7438
#define regGDC_DMA_SION_CL2_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL2_RdRspPoolCredit_Alloc_REG1                                                  0x4f7439
#define regGDC_DMA_SION_CL2_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL2_WrRspPoolCredit_Alloc_REG0                                                  0x4f743a
#define regGDC_DMA_SION_CL2_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL2_WrRspPoolCredit_Alloc_REG1                                                  0x4f743b
#define regGDC_DMA_SION_CL2_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL3_RdRsp_BurstTarget_REG0                                                      0x4f743c
#define regGDC_DMA_SION_CL3_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL3_RdRsp_BurstTarget_REG1                                                      0x4f743d
#define regGDC_DMA_SION_CL3_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL3_RdRsp_TimeSlot_REG0                                                         0x4f743e
#define regGDC_DMA_SION_CL3_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL3_RdRsp_TimeSlot_REG1                                                         0x4f743f
#define regGDC_DMA_SION_CL3_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL3_WrRsp_BurstTarget_REG0                                                      0x4f7440
#define regGDC_DMA_SION_CL3_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_DMA_SION_CL3_WrRsp_BurstTarget_REG1                                                      0x4f7441
#define regGDC_DMA_SION_CL3_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_DMA_SION_CL3_WrRsp_TimeSlot_REG0                                                         0x4f7442
#define regGDC_DMA_SION_CL3_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_DMA_SION_CL3_WrRsp_TimeSlot_REG1                                                         0x4f7443
#define regGDC_DMA_SION_CL3_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_DMA_SION_CL3_Req_BurstTarget_REG0                                                        0x4f7444
#define regGDC_DMA_SION_CL3_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_DMA_SION_CL3_Req_BurstTarget_REG1                                                        0x4f7445
#define regGDC_DMA_SION_CL3_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_DMA_SION_CL3_Req_TimeSlot_REG0                                                           0x4f7446
#define regGDC_DMA_SION_CL3_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL3_Req_TimeSlot_REG1                                                           0x4f7447
#define regGDC_DMA_SION_CL3_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_DMA_SION_CL3_ReqPoolCredit_Alloc_REG0                                                    0x4f7448
#define regGDC_DMA_SION_CL3_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_DMA_SION_CL3_ReqPoolCredit_Alloc_REG1                                                    0x4f7449
#define regGDC_DMA_SION_CL3_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_DMA_SION_CL3_DataPoolCredit_Alloc_REG0                                                   0x4f744a
#define regGDC_DMA_SION_CL3_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_DMA_SION_CL3_DataPoolCredit_Alloc_REG1                                                   0x4f744b
#define regGDC_DMA_SION_CL3_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_DMA_SION_CL3_RdRspPoolCredit_Alloc_REG0                                                  0x4f744c
#define regGDC_DMA_SION_CL3_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL3_RdRspPoolCredit_Alloc_REG1                                                  0x4f744d
#define regGDC_DMA_SION_CL3_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CL3_WrRspPoolCredit_Alloc_REG0                                                  0x4f744e
#define regGDC_DMA_SION_CL3_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_DMA_SION_CL3_WrRspPoolCredit_Alloc_REG1                                                  0x4f744f
#define regGDC_DMA_SION_CL3_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_DMA_SION_CNTL_REG0                                                                       0x4f7450
#define regGDC_DMA_SION_CNTL_REG0_BASE_IDX                                                              3
#define regGDC_DMA_SION_CNTL_REG1                                                                       0x4f7451
#define regGDC_DMA_SION_CNTL_REG1_BASE_IDX                                                              3


// addressBlock: nbif_gdc_hst_sion_SIONDEC
// base address: 0x1400000
#define regGDC_HST_SION_CL0_RdRsp_BurstTarget_REG0                                                      0x4f7600
#define regGDC_HST_SION_CL0_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_HST_SION_CL0_RdRsp_BurstTarget_REG1                                                      0x4f7601
#define regGDC_HST_SION_CL0_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_HST_SION_CL0_RdRsp_TimeSlot_REG0                                                         0x4f7602
#define regGDC_HST_SION_CL0_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_HST_SION_CL0_RdRsp_TimeSlot_REG1                                                         0x4f7603
#define regGDC_HST_SION_CL0_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_HST_SION_CL0_WrRsp_BurstTarget_REG0                                                      0x4f7604
#define regGDC_HST_SION_CL0_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_HST_SION_CL0_WrRsp_BurstTarget_REG1                                                      0x4f7605
#define regGDC_HST_SION_CL0_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_HST_SION_CL0_WrRsp_TimeSlot_REG0                                                         0x4f7606
#define regGDC_HST_SION_CL0_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_HST_SION_CL0_WrRsp_TimeSlot_REG1                                                         0x4f7607
#define regGDC_HST_SION_CL0_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_HST_SION_CL0_Req_BurstTarget_REG0                                                        0x4f7608
#define regGDC_HST_SION_CL0_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_HST_SION_CL0_Req_BurstTarget_REG1                                                        0x4f7609
#define regGDC_HST_SION_CL0_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_HST_SION_CL0_Req_TimeSlot_REG0                                                           0x4f760a
#define regGDC_HST_SION_CL0_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_HST_SION_CL0_Req_TimeSlot_REG1                                                           0x4f760b
#define regGDC_HST_SION_CL0_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_HST_SION_CL0_ReqPoolCredit_Alloc_REG0                                                    0x4f760c
#define regGDC_HST_SION_CL0_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_HST_SION_CL0_ReqPoolCredit_Alloc_REG1                                                    0x4f760d
#define regGDC_HST_SION_CL0_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_HST_SION_CL0_DataPoolCredit_Alloc_REG0                                                   0x4f760e
#define regGDC_HST_SION_CL0_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_HST_SION_CL0_DataPoolCredit_Alloc_REG1                                                   0x4f760f
#define regGDC_HST_SION_CL0_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_HST_SION_CL0_RdRspPoolCredit_Alloc_REG0                                                  0x4f7610
#define regGDC_HST_SION_CL0_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_HST_SION_CL0_RdRspPoolCredit_Alloc_REG1                                                  0x4f7611
#define regGDC_HST_SION_CL0_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_HST_SION_CL0_WrRspPoolCredit_Alloc_REG0                                                  0x4f7612
#define regGDC_HST_SION_CL0_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_HST_SION_CL0_WrRspPoolCredit_Alloc_REG1                                                  0x4f7613
#define regGDC_HST_SION_CL0_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_HST_SION_CL1_RdRsp_BurstTarget_REG0                                                      0x4f7614
#define regGDC_HST_SION_CL1_RdRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_HST_SION_CL1_RdRsp_BurstTarget_REG1                                                      0x4f7615
#define regGDC_HST_SION_CL1_RdRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_HST_SION_CL1_RdRsp_TimeSlot_REG0                                                         0x4f7616
#define regGDC_HST_SION_CL1_RdRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_HST_SION_CL1_RdRsp_TimeSlot_REG1                                                         0x4f7617
#define regGDC_HST_SION_CL1_RdRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_HST_SION_CL1_WrRsp_BurstTarget_REG0                                                      0x4f7618
#define regGDC_HST_SION_CL1_WrRsp_BurstTarget_REG0_BASE_IDX                                             3
#define regGDC_HST_SION_CL1_WrRsp_BurstTarget_REG1                                                      0x4f7619
#define regGDC_HST_SION_CL1_WrRsp_BurstTarget_REG1_BASE_IDX                                             3
#define regGDC_HST_SION_CL1_WrRsp_TimeSlot_REG0                                                         0x4f761a
#define regGDC_HST_SION_CL1_WrRsp_TimeSlot_REG0_BASE_IDX                                                3
#define regGDC_HST_SION_CL1_WrRsp_TimeSlot_REG1                                                         0x4f761b
#define regGDC_HST_SION_CL1_WrRsp_TimeSlot_REG1_BASE_IDX                                                3
#define regGDC_HST_SION_CL1_Req_BurstTarget_REG0                                                        0x4f761c
#define regGDC_HST_SION_CL1_Req_BurstTarget_REG0_BASE_IDX                                               3
#define regGDC_HST_SION_CL1_Req_BurstTarget_REG1                                                        0x4f761d
#define regGDC_HST_SION_CL1_Req_BurstTarget_REG1_BASE_IDX                                               3
#define regGDC_HST_SION_CL1_Req_TimeSlot_REG0                                                           0x4f761e
#define regGDC_HST_SION_CL1_Req_TimeSlot_REG0_BASE_IDX                                                  3
#define regGDC_HST_SION_CL1_Req_TimeSlot_REG1                                                           0x4f761f
#define regGDC_HST_SION_CL1_Req_TimeSlot_REG1_BASE_IDX                                                  3
#define regGDC_HST_SION_CL1_ReqPoolCredit_Alloc_REG0                                                    0x4f7620
#define regGDC_HST_SION_CL1_ReqPoolCredit_Alloc_REG0_BASE_IDX                                           3
#define regGDC_HST_SION_CL1_ReqPoolCredit_Alloc_REG1                                                    0x4f7621
#define regGDC_HST_SION_CL1_ReqPoolCredit_Alloc_REG1_BASE_IDX                                           3
#define regGDC_HST_SION_CL1_DataPoolCredit_Alloc_REG0                                                   0x4f7622
#define regGDC_HST_SION_CL1_DataPoolCredit_Alloc_REG0_BASE_IDX                                          3
#define regGDC_HST_SION_CL1_DataPoolCredit_Alloc_REG1                                                   0x4f7623
#define regGDC_HST_SION_CL1_DataPoolCredit_Alloc_REG1_BASE_IDX                                          3
#define regGDC_HST_SION_CL1_RdRspPoolCredit_Alloc_REG0                                                  0x4f7624
#define regGDC_HST_SION_CL1_RdRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_HST_SION_CL1_RdRspPoolCredit_Alloc_REG1                                                  0x4f7625
#define regGDC_HST_SION_CL1_RdRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_HST_SION_CL1_WrRspPoolCredit_Alloc_REG0                                                  0x4f7626
#define regGDC_HST_SION_CL1_WrRspPoolCredit_Alloc_REG0_BASE_IDX                                         3
#define regGDC_HST_SION_CL1_WrRspPoolCredit_Alloc_REG1                                                  0x4f7627
#define regGDC_HST_SION_CL1_WrRspPoolCredit_Alloc_REG1_BASE_IDX                                         3
#define regGDC_HST_SION_CNTL_REG0                                                                       0x4f7628
#define regGDC_HST_SION_CNTL_REG0_BASE_IDX                                                              3
#define regGDC_HST_SION_CNTL_REG1                                                                       0x4f7629
#define regGDC_HST_SION_CNTL_REG1_BASE_IDX                                                              3


// addressBlock: nbif_gdc_GDCDEC
// base address: 0x1400000
#define regGDC1_SHUB_REGS_IF_CTL                                                                        0x4f0aa1
#define regGDC1_SHUB_REGS_IF_CTL_BASE_IDX                                                               3
#define regGDC1_A2S_QUEUE_FIFO_ARB_CNTL                                                                 0x4f0aa2
#define regGDC1_A2S_QUEUE_FIFO_ARB_CNTL_BASE_IDX                                                        3
#define regGDC1_NGDC_MGCG_CTRL                                                                          0x4f0aa7
#define regGDC1_NGDC_MGCG_CTRL_BASE_IDX                                                                 3
#define regGDC1_S2A_MISC_CNTL                                                                           0x4f0aa8
#define regGDC1_S2A_MISC_CNTL_BASE_IDX                                                                  3
#define regGDC1_NGDC_EARLY_WAKEUP_CTRL                                                                  0x4f0aac
#define regGDC1_NGDC_EARLY_WAKEUP_CTRL_BASE_IDX                                                         3
#define regGDC1_NGDC_PG_MISC_CTRL                                                                       0x4f0ab0
#define regGDC1_NGDC_PG_MISC_CTRL_BASE_IDX                                                              3
#define regGDC1_NGDC_PGMST_CTRL                                                                         0x4f0ab1
#define regGDC1_NGDC_PGMST_CTRL_BASE_IDX                                                                3
#define regGDC1_NGDC_PGSLV_CTRL                                                                         0x4f0ab2
#define regGDC1_NGDC_PGSLV_CTRL_BASE_IDX                                                                3
#define regGDC1_ATDMA_MISC_CNTL                                                                         0x4f0b01
#define regGDC1_ATDMA_MISC_CNTL_BASE_IDX                                                                3


// addressBlock: nbif_gdc_ras_gdc_ras_regblk
// base address: 0x1400000
#define regGDCSOC_ERR_RSP_CNTL                                                                          0x4f5c00
#define regGDCSOC_ERR_RSP_CNTL_BASE_IDX                                                                 3
#define regGDCSOC_RAS_CENTRAL_STATUS                                                                    0x4f5c10
#define regGDCSOC_RAS_CENTRAL_STATUS_BASE_IDX                                                           3
#define regGDCSOC_RAS_LEAF0_CTRL                                                                        0x4f5c20
#define regGDCSOC_RAS_LEAF0_CTRL_BASE_IDX                                                               3
#define regGDCSOC_RAS_LEAF1_CTRL                                                                        0x4f5c21
#define regGDCSOC_RAS_LEAF1_CTRL_BASE_IDX                                                               3
#define regGDCSOC_RAS_LEAF2_CTRL                                                                        0x4f5c22
#define regGDCSOC_RAS_LEAF2_CTRL_BASE_IDX                                                               3
#define regGDCSOC_RAS_LEAF3_CTRL                                                                        0x4f5c23
#define regGDCSOC_RAS_LEAF3_CTRL_BASE_IDX                                                               3
#define regGDCSOC_RAS_LEAF4_CTRL                                                                        0x4f5c24
#define regGDCSOC_RAS_LEAF4_CTRL_BASE_IDX                                                               3
#define regGDCSOC_RAS_LEAF2_MISC_CTRL                                                                   0x4f5c2e
#define regGDCSOC_RAS_LEAF2_MISC_CTRL_BASE_IDX                                                          3
#define regGDCSOC_RAS_LEAF2_MISC_CTRL2                                                                  0x4f5c2f
#define regGDCSOC_RAS_LEAF2_MISC_CTRL2_BASE_IDX                                                         3
#define regGDCSOC_RAS_LEAF0_STATUS                                                                      0x4f5c30
#define regGDCSOC_RAS_LEAF0_STATUS_BASE_IDX                                                             3
#define regGDCSOC_RAS_LEAF1_STATUS                                                                      0x4f5c31
#define regGDCSOC_RAS_LEAF1_STATUS_BASE_IDX                                                             3
#define regGDCSOC_RAS_LEAF2_STATUS                                                                      0x4f5c32
#define regGDCSOC_RAS_LEAF2_STATUS_BASE_IDX                                                             3
#define regGDCSOC_RAS_LEAF3_STATUS                                                                      0x4f5c33
#define regGDCSOC_RAS_LEAF3_STATUS_BASE_IDX                                                             3
#define regGDCSOC_RAS_LEAF4_STATUS                                                                      0x4f5c34
#define regGDCSOC_RAS_LEAF4_STATUS_BASE_IDX                                                             3


// addressBlock: nbif_gdc_rst_GDCRST_DEC
// base address: 0x1400000
#define regSHUB_PF_FLR_RST                                                                              0x4f7800
#define regSHUB_PF_FLR_RST_BASE_IDX                                                                     3
#define regSHUB_GFX_DRV_VPU_RST                                                                         0x4f7801
#define regSHUB_GFX_DRV_VPU_RST_BASE_IDX                                                                3
#define regSHUB_LINK_RESET                                                                              0x4f7802
#define regSHUB_LINK_RESET_BASE_IDX                                                                     3
#define regSHUB_HARD_RST_CTRL                                                                           0x4f7810
#define regSHUB_HARD_RST_CTRL_BASE_IDX                                                                  3
#define regSHUB_SOFT_RST_CTRL                                                                           0x4f7811
#define regSHUB_SOFT_RST_CTRL_BASE_IDX                                                                  3
#define regSHUB_SDP_PORT_RST                                                                            0x4f7812
#define regSHUB_SDP_PORT_RST_BASE_IDX                                                                   3
#define regSHUB_RST_MISC_TRL                                                                            0x4f7813
#define regSHUB_RST_MISC_TRL_BASE_IDX                                                                   3


// addressBlock: nbif_gdc_s2a_GDCS2A_DEC
// base address: 0x1400000
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_0_CTRL                                                           0x4f0aeb
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_0_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_1_CTRL                                                           0x4f0aec
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_1_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_2_CTRL                                                           0x4f0aed
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_2_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_3_CTRL                                                           0x4f0aee
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_3_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_4_CTRL                                                           0x4f0aef
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_4_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_5_CTRL                                                           0x4f0af0
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_5_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_6_CTRL                                                           0x4f0af1
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_6_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_7_CTRL                                                           0x4f0af2
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_7_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_8_CTRL                                                           0x4f0af3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_8_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_9_CTRL                                                           0x4f0af4
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_9_CTRL_BASE_IDX                                                  3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_10_CTRL                                                          0x4f0af5
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_10_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_11_CTRL                                                          0x4f0af6
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_11_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_12_CTRL                                                          0x4f0af7
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_12_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_13_CTRL                                                          0x4f0af8
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_13_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_14_CTRL                                                          0x4f0af9
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_14_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_15_CTRL                                                          0x4f0afa
#define regGDC_S2A1_S2A_DOORBELL_ENTRY_15_CTRL_BASE_IDX                                                 3
#define regGDC_S2A1_S2A_DOORBELL_COMMON_CTRL_REG                                                        0x4f0afb
#define regGDC_S2A1_S2A_DOORBELL_COMMON_CTRL_REG_BASE_IDX                                               3
#define regGDC_S2A1_NBIF_GFX_DOORBELL_STATUS                                                            0x4f0afc
#define regGDC_S2A1_NBIF_GFX_DOORBELL_STATUS_BASE_IDX                                                   3


// addressBlock: nbif_gdc_a2s_GDCA2S_DEC
// base address: 0x1400000
#define regA2S_CNTL_SW0                                                                                 0x4f0c40
#define regA2S_CNTL_SW0_BASE_IDX                                                                        3
#define regA2S_CNTL_SW1                                                                                 0x4f0c41
#define regA2S_CNTL_SW1_BASE_IDX                                                                        3
#define regA2S_MISC_CNTL                                                                                0x4f0c72
#define regA2S_MISC_CNTL_BASE_IDX                                                                       3
#define regA2S_TAG_ALLOC_0                                                                              0x4f0c74
#define regA2S_TAG_ALLOC_0_BASE_IDX                                                                     3
#define regA2S_TAG_ALLOC_1                                                                              0x4f0c75
#define regA2S_TAG_ALLOC_1_BASE_IDX                                                                     3


// addressBlock: nbif_syshub_mmreg_syshubdirect
// base address: 0x1400000
#define regHST_CLK0_SW0_CL0_CNTL                                                                        0x4f3d40
#define regHST_CLK0_SW0_CL0_CNTL_BASE_IDX                                                               3
#define regHST_CLK0_SW1_CL0_CNTL                                                                        0x4f3d60
#define regHST_CLK0_SW1_CL0_CNTL_BASE_IDX                                                               3
#define regDMA_CLK0_SW0_CL0_CNTL                                                                        0x4f3e40
#define regDMA_CLK0_SW0_CL0_CNTL_BASE_IDX                                                               3
#define regNIC400_1_ASIB_0_FN_MOD                                                                       0x4fbc42
#define regNIC400_1_ASIB_0_FN_MOD_BASE_IDX                                                              3
#define regNIC400_1_IB_0_FN_MOD                                                                         0x4ff842
#define regNIC400_1_IB_0_FN_MOD_BASE_IDX                                                                3


// addressBlock: nbif_bif_bx_dev0_epf0_vf0_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF0_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF0_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF0_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF0_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF0_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF0_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF0_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF0_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF0_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF0_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF0_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF0_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF0_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF0_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf0_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF0_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF0_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF0_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF0_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF0_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF0_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf0_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF0_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF0_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF0_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF0_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF0_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF0_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF0_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF0_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF0_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF0_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf0_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF0_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf1_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF1_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF1_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF1_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF1_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF1_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF1_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF1_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF1_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF1_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF1_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF1_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF1_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF1_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF1_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf1_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF1_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF1_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF1_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF1_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF1_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF1_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf1_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF1_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF1_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF1_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF1_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF1_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF1_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF1_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF1_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF1_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF1_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf1_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF1_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf2_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF2_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF2_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF2_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF2_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF2_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF2_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF2_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF2_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF2_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF2_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF2_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF2_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF2_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF2_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf2_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF2_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF2_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF2_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF2_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF2_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF2_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf2_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF2_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF2_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF2_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF2_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF2_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF2_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF2_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF2_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF2_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF2_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf2_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF2_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf3_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF3_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF3_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF3_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF3_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF3_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF3_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF3_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF3_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF3_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF3_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF3_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF3_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF3_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF3_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf3_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF3_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF3_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF3_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF3_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF3_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF3_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf3_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF3_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF3_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF3_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF3_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF3_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF3_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF3_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF3_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF3_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF3_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf3_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF3_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf4_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF4_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF4_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF4_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF4_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF4_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF4_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF4_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF4_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF4_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF4_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF4_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF4_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF4_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF4_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf4_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF4_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF4_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF4_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF4_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF4_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF4_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf4_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF4_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF4_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF4_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF4_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF4_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF4_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF4_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF4_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF4_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF4_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf4_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF4_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf5_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF5_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF5_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF5_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF5_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF5_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF5_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF5_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF5_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF5_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF5_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF5_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF5_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF5_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF5_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf5_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF5_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF5_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF5_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF5_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF5_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF5_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf5_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF5_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF5_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF5_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF5_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF5_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF5_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF5_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF5_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF5_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF5_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf5_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF5_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf6_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF6_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF6_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF6_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF6_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF6_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF6_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF6_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF6_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF6_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF6_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF6_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF6_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF6_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF6_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf6_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF6_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF6_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF6_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF6_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF6_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF6_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf6_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF6_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF6_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF6_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF6_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF6_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF6_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF6_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF6_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF6_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF6_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf6_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_MSG_DATA                                                     0x040e
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_CONTROL                                                      0x040f
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_VECT3_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_PBA                                                                0x0800
#define regRCC_DEV0_EPF0_VF6_GFXMSIX_PBA_BASE_IDX                                                       3


// addressBlock: nbif_bif_bx_dev0_epf0_vf7_BIFPFVFDEC1
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF7_BIF_BME_STATUS                                                          0x00eb
#define regBIF_BX_DEV0_EPF0_VF7_BIF_BME_STATUS_BASE_IDX                                                 2
#define regBIF_BX_DEV0_EPF0_VF7_BIF_ATOMIC_ERR_LOG                                                      0x00ec
#define regBIF_BX_DEV0_EPF0_VF7_BIF_ATOMIC_ERR_LOG_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_HIGH                                    0x00f3
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_HIGH_BASE_IDX                           2
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_LOW                                     0x00f4
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_BASE_LOW_BASE_IDX                            2
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_CNTL                                         0x00f5
#define regBIF_BX_DEV0_EPF0_VF7_DOORBELL_SELFRING_GPA_APER_CNTL_BASE_IDX                                2
#define regBIF_BX_DEV0_EPF0_VF7_HDP_REG_COHERENCY_FLUSH_CNTL                                            0x00f6
#define regBIF_BX_DEV0_EPF0_VF7_HDP_REG_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_CNTL                                            0x00f7
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_CNTL_BASE_IDX                                   2
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL                                       0x00f9
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_FLUSH_ONLY_CNTL_BASE_IDX                              2
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL                                  0x00fa
#define regBIF_BX_DEV0_EPF0_VF7_HDP_MEM_COHERENCY_INVALIDATE_ONLY_CNTL_BASE_IDX                         2
#define regBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_REQ                                                       0x0106
#define regBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_REQ_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_DONE                                                      0x0107
#define regBIF_BX_DEV0_EPF0_VF7_GPU_HDP_FLUSH_DONE_BASE_IDX                                             2
#define regBIF_BX_DEV0_EPF0_VF7_BIF_TRANS_PENDING                                                       0x0108
#define regBIF_BX_DEV0_EPF0_VF7_BIF_TRANS_PENDING_BASE_IDX                                              2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW0                                                  0x0136
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW1                                                  0x0137
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW2                                                  0x0138
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW3                                                  0x0139
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_TRN_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW0                                                  0x013a
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW0_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW1                                                  0x013b
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW1_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW2                                                  0x013c
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW2_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW3                                                  0x013d
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_MSGBUF_RCV_DW3_BASE_IDX                                         2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_CONTROL                                                         0x013e
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_CONTROL_BASE_IDX                                                2
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_INT_CNTL                                                        0x013f
#define regBIF_BX_DEV0_EPF0_VF7_MAILBOX_INT_CNTL_BASE_IDX                                               2
#define regBIF_BX_DEV0_EPF0_VF7_BIF_VMHV_MAILBOX                                                        0x0140
#define regBIF_BX_DEV0_EPF0_VF7_BIF_VMHV_MAILBOX_BASE_IDX                                               2


// addressBlock: nbif_bif_bx_dev0_epf0_vf7_SYSPFVFDEC
// base address: 0x0
#define regBIF_BX_DEV0_EPF0_VF7_MM_INDEX                                                                0x0000
#define regBIF_BX_DEV0_EPF0_VF7_MM_INDEX_BASE_IDX                                                       0
#define regBIF_BX_DEV0_EPF0_VF7_MM_DATA                                                                 0x0001
#define regBIF_BX_DEV0_EPF0_VF7_MM_DATA_BASE_IDX                                                        0
#define regBIF_BX_DEV0_EPF0_VF7_MM_INDEX_HI                                                             0x0006
#define regBIF_BX_DEV0_EPF0_VF7_MM_INDEX_HI_BASE_IDX                                                    0


// addressBlock: nbif_rcc_dev0_epf0_vf7_BIFPFVFDEC1
// base address: 0x0
#define regRCC_DEV0_EPF0_VF7_RCC_ERR_LOG                                                                0x0085
#define regRCC_DEV0_EPF0_VF7_RCC_ERR_LOG_BASE_IDX                                                       2
#define regRCC_DEV0_EPF0_VF7_RCC_DOORBELL_APER_EN                                                       0x00c0
#define regRCC_DEV0_EPF0_VF7_RCC_DOORBELL_APER_EN_BASE_IDX                                              2
#define regRCC_DEV0_EPF0_VF7_RCC_CONFIG_MEMSIZE                                                         0x00c3
#define regRCC_DEV0_EPF0_VF7_RCC_CONFIG_MEMSIZE_BASE_IDX                                                2
#define regRCC_DEV0_EPF0_VF7_RCC_CONFIG_RESERVED                                                        0x00c4
#define regRCC_DEV0_EPF0_VF7_RCC_CONFIG_RESERVED_BASE_IDX                                               2
#define regRCC_DEV0_EPF0_VF7_RCC_IOV_FUNC_IDENTIFIER                                                    0x00c5
#define regRCC_DEV0_EPF0_VF7_RCC_IOV_FUNC_IDENTIFIER_BASE_IDX                                           2


// addressBlock: nbif_rcc_dev0_epf0_vf7_BIFDEC2
// base address: 0x0
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_ADDR_LO                                                      0x0400
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_ADDR_HI                                                      0x0401
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_MSG_DATA                                                     0x0402
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_CONTROL                                                      0x0403
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT0_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_ADDR_LO                                                      0x0404
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_ADDR_HI                                                      0x0405
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_MSG_DATA                                                     0x0406
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_CONTROL                                                      0x0407
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT1_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_ADDR_LO                                                      0x0408
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_ADDR_HI                                                      0x0409
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_MSG_DATA                                                     0x040a
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_MSG_DATA_BASE_IDX                                            3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_CONTROL                                                      0x040b
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT2_CONTROL_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT3_ADDR_LO                                                      0x040c
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT3_ADDR_LO_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT3_ADDR_HI                                                      0x040d
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT3_ADDR_HI_BASE_IDX                                             3
#define regRCC_DEV0_EPF0_VF7_GFXMSIX_VECT3_MSG_DA