/* SPDX-License-Identifier: GPL-2.0+ */
/* Copyright (c) 2024 Hisilicon Limited. */

#ifndef __HBG_REG_H
#define __HBG_REG_H

/* DEV SPEC */
#define HBG_REG_SPEC_VALID_ADDR			0x0000
#define HBG_REG_EVENT_REQ_ADDR			0x0004
#define HBG_REG_MAC_ID_ADDR			0x0008
#define HBG_REG_PHY_ID_ADDR			0x000C
#define HBG_REG_MAC_ADDR_ADDR			0x0010
#define HBG_REG_MAC_ADDR_HIGH_ADDR		0x0014
#define HBG_REG_UC_MAC_NUM_ADDR			0x0018
#define HBG_REG_MDIO_FREQ_ADDR			0x0024
#define HBG_REG_MAX_MTU_ADDR			0x0028
#define HBG_REG_MIN_MTU_ADDR			0x002C
#define HBG_REG_TX_FIFO_NUM_ADDR		0x0030
#define HBG_REG_RX_FIFO_NUM_ADDR		0x0034
#define HBG_REG_VLAN_LAYERS_ADDR		0x0038

/* MDIO */
#define HBG_REG_MDIO_BASE			0x8000
#define HBG_REG_MDIO_COMMAND_ADDR		(HBG_REG_MDIO_BASE + 0x0000)
#define HBG_REG_MDIO_COMMAND_CLK_SEL_EXP_B	BIT(17)
#define HBG_REG_MDIO_COMMAND_AUTO_SCAN_B	BIT(16)
#define HBG_REG_MDIO_COMMAND_CLK_SEL_B		BIT(15)
#define HBG_REG_MDIO_COMMAND_START_B		BIT(14)
#define HBG_REG_MDIO_COMMAND_ST_M		GENMASK(13, 12)
#define HBG_REG_MDIO_COMMAND_OP_M		GENMASK(11, 10)
#define HBG_REG_MDIO_COMMAND_PRTAD_M		GENMASK(9, 5)
#define HBG_REG_MDIO_COMMAND_DEVAD_M		GENMASK(4, 0)
#define HBG_REG_MDIO_ADDR_ADDR			(HBG_REG_MDIO_BASE + 0x0004)
#define HBG_REG_MDIO_WDATA_ADDR			(HBG_REG_MDIO_BASE + 0x0008)
#define HBG_REG_MDIO_WDATA_M			GENMASK(15, 0)
#define HBG_REG_MDIO_RDATA_ADDR			(HBG_REG_MDIO_BASE + 0x000C)
#define HBG_REG_MDIO_STA_ADDR			(HBG_REG_MDIO_BASE + 0x0010)

/* GMAC */
#define HBG_REG_SGMII_BASE			0x10000
#define HBG_REG_DUPLEX_TYPE_ADDR		(HBG_REG_SGMII_BASE + 0x0008)
#define HBG_REG_FD_FC_TYPE_ADDR			(HBG_REG_SGMII_BASE + 0x000C)
#define HBG_REG_FC_TX_TIMER_ADDR		(HBG_REG_SGMII_BASE + 0x001C)
#define HBG_REG_FD_FC_ADDR_LOW_ADDR		(HBG_REG_SGMII_BASE + 0x0020)
#define HBG_REG_FD_FC_ADDR_HIGH_ADDR		(HBG_REG_SGMII_BASE + 0x0024)
#define HBG_REG_DUPLEX_B			BIT(0)
#define HBG_REG_MAX_FRAME_SIZE_ADDR		(HBG_REG_SGMII_BASE + 0x003C)
#define HBG_REG_PORT_MODE_ADDR			(HBG_REG_SGMII_BASE + 0x0040)
#define HBG_REG_PORT_MODE_M			GENMASK(3, 0)
#define HBG_REG_PORT_ENABLE_ADDR		(HBG_REG_SGMII_BASE + 0x0044)
#define HBG_REG_PORT_ENABLE_RX_B		BIT(1)
#define HBG_REG_PORT_ENABLE_TX_B		BIT(2)
#define HBG_REG_PAUSE_ENABLE_ADDR		(HBG_REG_SGMII_BASE + 0x0048)
#define HBG_REG_PAUSE_ENABLE_RX_B		BIT(0)
#define HBG_REG_PAUSE_ENABLE_TX_B		BIT(1)
#define HBG_REG_AN_NEG_STATE_ADDR		(HBG_REG_SGMII_BASE + 0x0058)
#define HBG_REG_TRANSMIT_CTRL_ADDR		(HBG_REG_SGMII_BASE + 0x0060)
#define HBG_REG_TRANSMIT_CTRL_PAD_EN_B		BIT(7)
#define HBG_REG_TRANSMIT_CTRL_CRC_ADD_B		BIT(6)
#define HBG_REG_TRANSMIT_CTRL_AN_EN_B		BIT(5)
#define HBG_REG_REC_FILT_CTRL_ADDR		(HBG_REG_SGMII_BASE + 0x0064)
#define HBG_REG_REC_FILT_CTRL_UC_MATCH_EN_B	BIT(0)
#define HBG_REG_LINE_LOOP_BACK_ADDR		(HBG_REG_SGMII_BASE + 0x01A8)
#define HBG_REG_CF_CRC_STRIP_ADDR		(HBG_REG_SGMII_BASE + 0x01B0)
#define HBG_REG_CF_CRC_STRIP_B			BIT(0)
#define HBG_REG_MODE_CHANGE_EN_ADDR		(HBG_REG_SGMII_BASE + 0x01B4)
#define HBG_REG_MODE_CHANGE_EN_B		BIT(0)
#define HBG_REG_LOOP_REG_ADDR			(HBG_REG_SGMII_BASE + 0x01DC)
#define HBG_REG_RECV_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x01E0)
#define HBG_REG_RECV_CTRL_STRIP_PAD_EN_B	BIT(3)
#define HBG_REG_VLAN_CODE_ADDR			(HBG_REG_SGMII_BASE + 0x01E8)
#define HBG_REG_STATION_ADDR_LOW_0_ADDR		(HBG_REG_SGMII_BASE + 0x0200)
#define HBG_REG_STATION_ADDR_HIGH_0_ADDR	(HBG_REG_SGMII_BASE + 0x0204)
#define HBG_REG_STATION_ADDR_LOW_1_ADDR		(HBG_REG_SGMII_BASE + 0x0208)
#define HBG_REG_STATION_ADDR_HIGH_1_ADDR	(HBG_REG_SGMII_BASE + 0x020C)
#define HBG_REG_STATION_ADDR_LOW_2_ADDR		(HBG_REG_SGMII_BASE + 0x0210)
#define HBG_REG_STATION_ADDR_HIGH_2_ADDR	(HBG_REG_SGMII_BASE + 0x0214)
#define HBG_REG_STATION_ADDR_LOW_3_ADDR		(HBG_REG_SGMII_BASE + 0x0218)
#define HBG_REG_STATION_ADDR_HIGH_3_ADDR	(HBG_REG_SGMII_BASE + 0x021C)
#define HBG_REG_STATION_ADDR_LOW_4_ADDR		(HBG_REG_SGMII_BASE + 0x0220)
#define HBG_REG_STATION_ADDR_HIGH_4_ADDR	(HBG_REG_SGMII_BASE + 0x0224)
#define HBG_REG_STATION_ADDR_LOW_5_ADDR		(HBG_REG_SGMII_BASE + 0x0228)
#define HBG_REG_STATION_ADDR_HIGH_5_ADDR	(HBG_REG_SGMII_BASE + 0x022C)

/* PCU */
#define HBG_REG_TX_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0420)
#define HBG_REG_RX_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0424)
#define HBG_REG_CFG_FIFO_THRSLD_ADDR		(HBG_REG_SGMII_BASE + 0x0428)
#define HBG_REG_CF_INTRPT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x042C)
#define HBG_INT_MSK_WE_ERR_B			BIT(31)
#define HBG_INT_MSK_RBREQ_ERR_B			BIT(30)
#define HBG_INT_MSK_MAC_FIFO_ERR_B		BIT(29)
#define HBG_INT_MSK_RX_AHB_ERR_B		BIT(28)
#define HBG_INT_MSK_RX_DROP_B			BIT(26)
#define HBG_INT_MSK_TX_DROP_B			BIT(25)
#define HBG_INT_MSK_TXCFG_AVL_B			BIT(24)
#define HBG_INT_MSK_REL_BUF_ERR_B		BIT(23)
#define HBG_INT_MSK_RX_BUF_AVL_B		BIT(22)
#define HBG_INT_MSK_TX_AHB_ERR_B		BIT(21)
#define HBG_INT_MSK_SRAM_PARITY_ERR_B		BIT(20)
#define HBG_INT_MSK_MAC_APP_TX_FIFO_ERR_B	BIT(19)
#define HBG_INT_MSK_MAC_APP_RX_FIFO_ERR_B	BIT(18)
#define HBG_INT_MSK_MAC_PCS_TX_FIFO_ERR_B	BIT(17)
#define HBG_INT_MSK_MAC_PCS_RX_FIFO_ERR_B	BIT(16)
#define HBG_INT_MSK_MAC_MII_FIFO_ERR_B		BIT(15)
#define HBG_INT_MSK_TX_B			BIT(1) /* just used in driver */
#define HBG_INT_MSK_RX_B			BIT(0) /* just used in driver */
#define HBG_REG_CF_INTRPT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x0434)
#define HBG_REG_CF_INTRPT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x0438)
#define HBG_REG_TX_BUS_ERR_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x043C)
#define HBG_REG_RX_BUS_ERR_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x0440)
#define HBG_REG_MAX_FRAME_LEN_ADDR		(HBG_REG_SGMII_BASE + 0x0444)
#define HBG_REG_MAX_FRAME_LEN_M			GENMASK(15, 0)
#define HBG_REG_DEBUG_ST_MCH_ADDR		(HBG_REG_SGMII_BASE + 0x0450)
#define HBG_REG_FIFO_CURR_STATUS_ADDR		(HBG_REG_SGMII_BASE + 0x0454)
#define HBG_REG_FIFO_HIST_STATUS_ADDR		(HBG_REG_SGMII_BASE + 0x0458)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR		(HBG_REG_SGMII_BASE + 0x045C)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR_TX_M	GENMASK(8, 0)
#define HBG_REG_CF_CFF_DATA_NUM_ADDR_RX_M	GENMASK(24, 16)
#define HBG_REG_CF_TX_PAUSE_ADDR		(HBG_REG_SGMII_BASE + 0x0470)
#define HBG_REG_TX_CFF_ADDR_0_ADDR		(HBG_REG_SGMII_BASE + 0x0488)
#define HBG_REG_TX_CFF_ADDR_1_ADDR		(HBG_REG_SGMII_BASE + 0x048C)
#define HBG_REG_TX_CFF_ADDR_2_ADDR		(HBG_REG_SGMII_BASE + 0x0490)
#define HBG_REG_TX_CFF_ADDR_3_ADDR		(HBG_REG_SGMII_BASE + 0x0494)
#define HBG_REG_RX_CFF_ADDR_ADDR		(HBG_REG_SGMII_BASE + 0x04A0)
#define HBG_REG_RX_BUF_SIZE_ADDR		(HBG_REG_SGMII_BASE + 0x04E4)
#define HBG_REG_RX_BUF_SIZE_M			GENMASK(15, 0)
#define HBG_REG_BUS_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x04E8)
#define HBG_REG_BUS_CTRL_ENDIAN_M		GENMASK(2, 1)
#define HBG_REG_RX_CTRL_ADDR			(HBG_REG_SGMII_BASE + 0x04F0)
#define HBG_REG_RX_CTRL_RXBUF_1ST_SKIP_SIZE_M	GENMASK(31, 28)
#define HBG_REG_RX_CTRL_TIME_INF_EN_B		BIT(23)
#define HBG_REG_RX_CTRL_RX_ALIGN_NUM_M		GENMASK(18, 17)
#define HBG_REG_RX_CTRL_PORT_NUM		GENMASK(16, 13)
#define HBG_REG_RX_CTRL_RX_GET_ADDR_MODE_B	BIT(12)
#define HBG_REG_RX_CTRL_RXBUF_1ST_SKIP_SIZE2_M	GENMASK(3, 0)
#define HBG_REG_RX_PKT_MODE_ADDR		(HBG_REG_SGMII_BASE + 0x04F4)
#define HBG_REG_RX_PKT_MODE_PARSE_MODE_M	GENMASK(22, 21)
#define HBG_REG_DBG_ST0_ADDR			(HBG_REG_SGMII_BASE + 0x05E4)
#define HBG_REG_DBG_ST1_ADDR			(HBG_REG_SGMII_BASE + 0x05E8)
#define HBG_REG_DBG_ST2_ADDR			(HBG_REG_SGMII_BASE + 0x05EC)
#define HBG_REG_BUS_RST_EN_ADDR			(HBG_REG_SGMII_BASE + 0x0688)
#define HBG_REG_CF_IND_TXINT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x0694)
#define HBG_REG_IND_INTR_MASK_B			BIT(0)
#define HBG_REG_CF_IND_TXINT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x0698)
#define HBG_REG_CF_IND_TXINT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x069C)
#define HBG_REG_CF_IND_RXINT_MSK_ADDR		(HBG_REG_SGMII_BASE + 0x06a0)
#define HBG_REG_CF_IND_RXINT_STAT_ADDR		(HBG_REG_SGMII_BASE + 0x06a4)
#define HBG_REG_CF_IND_RXINT_CLR_ADDR		(HBG_REG_SGMII_BASE + 0x06a8)

enum hbg_port_mode {
	/* 0x0 ~ 0x5 are reserved */
	HBG_PORT_MODE_SGMII_10M = 0x6,
	HBG_PORT_MODE_SGMII_100M = 0x7,
	HBG_PORT_MODE_SGMII_1000M = 0x8,
};

struct hbg_tx_desc {
	u32 word0;
	u32 word1;
	u32 word2; /* pkt_addr */
	u32 word3; /* clear_addr */
};

#define HBG_TX_DESC_W0_IP_OFF_M		GENMASK(30, 26)
#define HBG_TX_DESC_W0_l3_CS_B		BIT(2)
#define HBG_TX_DESC_W0_WB_B		BIT(1)
#define HBG_TX_DESC_W0_l4_CS_B		BIT(0)
#define HBG_TX_DESC_W1_SEND_LEN_M	GENMASK(19, 4)

struct hbg_rx_desc {
	u32 word0;
	u32 word1; /* tag */
	u32 word2;
	u32 word3;
	u32 word4;
	u32 word5;
};

#define HBG_RX_DESC_W2_PKT_LEN_M	GENMASK(31, 16)

#endif
