/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Rockchip ISP1 Driver - Registers header
 *
 * Copyright (C) 2017 Rockchip Electronics Co., Ltd.
 */

#ifndef _RKISP1_REGS_H
#define _RKISP1_REGS_H

/* ISP_CTRL */
#define RKISP1_CIF_ISP_CTRL_ISP_ENABLE			BIT(0)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_RAW_PICT		(0 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_ITU656		BIT(1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_ITU601		(2 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_BAYER_ITU601	(3 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_DATA_MODE		(4 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_BAYER_ITU656	(5 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_MODE_RAW_PICT_ITU656	(6 << 1)
#define RKISP1_CIF_ISP_CTRL_ISP_INFORM_ENABLE		BIT(4)
#define RKISP1_CIF_ISP_CTRL_ISP_GAMMA_IN_ENA		BIT(6)
#define RKISP1_CIF_ISP_CTRL_ISP_AWB_ENA			BIT(7)
#define RKISP1_CIF_ISP_CTRL_ISP_CFG_UPD_PERMANENT	BIT(8)
#define RKISP1_CIF_ISP_CTRL_ISP_CFG_UPD			BIT(9)
#define RKISP1_CIF_ISP_CTRL_ISP_GEN_CFG_UPD		BIT(10)
#define RKISP1_CIF_ISP_CTRL_ISP_GAMMA_OUT_ENA		BIT(11)
#define RKISP1_CIF_ISP_CTRL_ISP_FLASH_MODE_ENA		BIT(12)
#define RKISP1_CIF_ISP_CTRL_ISP_CSM_Y_FULL_ENA		BIT(13)
#define RKISP1_CIF_ISP_CTRL_ISP_CSM_C_FULL_ENA		BIT(14)

/* ISP_ACQ_PROP */
#define RKISP1_CIF_ISP_ACQ_PROP_POS_EDGE		BIT(0)
#define RKISP1_CIF_ISP_ACQ_PROP_HSYNC_LOW		BIT(1)
#define RKISP1_CIF_ISP_ACQ_PROP_VSYNC_LOW		BIT(2)
#define RKISP1_CIF_ISP_ACQ_PROP_BAYER_PAT_RGGB		(0 << 3)
#define RKISP1_CIF_ISP_ACQ_PROP_BAYER_PAT_GRBG		BIT(3)
#define RKISP1_CIF_ISP_ACQ_PROP_BAYER_PAT_GBRG		(2 << 3)
#define RKISP1_CIF_ISP_ACQ_PROP_BAYER_PAT_BGGR		(3 << 3)
#define RKISP1_CIF_ISP_ACQ_PROP_BAYER_PAT(pat)		((pat) << 3)
#define RKISP1_CIF_ISP_ACQ_PROP_YCBYCR			(0 << 7)
#define RKISP1_CIF_ISP_ACQ_PROP_YCRYCB			BIT(7)
#define RKISP1_CIF_ISP_ACQ_PROP_CBYCRY			(2 << 7)
#define RKISP1_CIF_ISP_ACQ_PROP_CRYCBY			(3 << 7)
#define RKISP1_CIF_ISP_ACQ_PROP_FIELD_SEL_ALL		(0 << 9)
#define RKISP1_CIF_ISP_ACQ_PROP_FIELD_SEL_EVEN		BIT(9)
#define RKISP1_CIF_ISP_ACQ_PROP_FIELD_SEL_ODD		(2 << 9)
#define RKISP1_CIF_ISP_ACQ_PROP_IN_SEL_12B		(0 << 12)
#define RKISP1_CIF_ISP_ACQ_PROP_IN_SEL_10B_ZERO		BIT(12)
#define RKISP1_CIF_ISP_ACQ_PROP_IN_SEL_10B_MSB		(2 << 12)
#define RKISP1_CIF_ISP_ACQ_PROP_IN_SEL_8B_ZERO		(3 << 12)
#define RKISP1_CIF_ISP_ACQ_PROP_IN_SEL_8B_MSB		(4 << 12)

/* VI_DPCL */
#define RKISP1_CIF_VI_DPCL_DMA_JPEG			(0 << 0)
#define RKISP1_CIF_VI_DPCL_MP_MUX_MRSZ_MI		BIT(0)
#define RKISP1_CIF_VI_DPCL_MP_MUX_MRSZ_JPEG		(2 << 0)
#define RKISP1_CIF_VI_DPCL_CHAN_MODE_MP			BIT(2)
#define RKISP1_CIF_VI_DPCL_CHAN_MODE_SP			(2 << 2)
#define RKISP1_CIF_VI_DPCL_CHAN_MODE_MPSP		(3 << 2)
#define RKISP1_CIF_VI_DPCL_DMA_SW_SPMUX			(0 << 4)
#define RKISP1_CIF_VI_DPCL_DMA_SW_SI			BIT(4)
#define RKISP1_CIF_VI_DPCL_DMA_SW_IE			(2 << 4)
#define RKISP1_CIF_VI_DPCL_DMA_SW_JPEG			(3 << 4)
#define RKISP1_CIF_VI_DPCL_DMA_SW_ISP			(4 << 4)
#define RKISP1_CIF_VI_DPCL_IF_SEL_PARALLEL		(0 << 8)
#define RKISP1_CIF_VI_DPCL_IF_SEL_SMIA			BIT(8)
#define RKISP1_CIF_VI_DPCL_IF_SEL_MIPI			(2 << 8)
#define RKISP1_CIF_VI_DPCL_DMA_IE_MUX_DMA		BIT(10)
#define RKISP1_CIF_VI_DPCL_DMA_SP_MUX_DMA		BIT(11)

/* ISP_IMSC - ISP_MIS - ISP_RIS - ISP_ICR - ISP_ISR */
#define RKISP1_CIF_ISP_OFF				BIT(0)
#define RKISP1_CIF_ISP_FRAME				BIT(1)
#define RKISP1_CIF_ISP_DATA_LOSS			BIT(2)
#define RKISP1_CIF_ISP_PIC_SIZE_ERROR			BIT(3)
#define RKISP1_CIF_ISP_AWB_DONE				BIT(4)
#define RKISP1_CIF_ISP_FRAME_IN				BIT(5)
#define RKISP1_CIF_ISP_V_START				BIT(6)
#define RKISP1_CIF_ISP_H_START				BIT(7)
#define RKISP1_CIF_ISP_FLASH_ON				BIT(8)
#define RKISP1_CIF_ISP_FLASH_OFF			BIT(9)
#define RKISP1_CIF_ISP_SHUTTER_ON			BIT(10)
#define RKISP1_CIF_ISP_SHUTTER_OFF			BIT(11)
#define RKISP1_CIF_ISP_AFM_SUM_OF			BIT(12)
#define RKISP1_CIF_ISP_AFM_LUM_OF			BIT(13)
#define RKISP1_CIF_ISP_AFM_FIN				BIT(14)
#define RKISP1_CIF_ISP_HIST_MEASURE_RDY			BIT(15)
#define RKISP1_CIF_ISP_FLASH_CAP			BIT(17)
#define RKISP1_CIF_ISP_EXP_END				BIT(18)
#define RKISP1_CIF_ISP_VSM_END				BIT(19)

/* ISP_ERR */
#define RKISP1_CIF_ISP_ERR_INFORM_SIZE			BIT(0)
#define RKISP1_CIF_ISP_ERR_IS_SIZE			BIT(1)
#define RKISP1_CIF_ISP_ERR_OUTFORM_SIZE			BIT(2)

/* MI_CTRL */
#define RKISP1_CIF_MI_CTRL_MP_ENABLE			BIT(0)
#define RKISP1_CIF_MI_CTRL_SP_ENABLE			(2 << 0)
#define RKISP1_CIF_MI_CTRL_JPEG_ENABLE			(4 << 0)
#define RKISP1_CIF_MI_CTRL_RAW_ENABLE			(8 << 0)
#define RKISP1_CIF_MI_CTRL_HFLIP			BIT(4)
#define RKISP1_CIF_MI_CTRL_VFLIP			BIT(5)
#define RKISP1_CIF_MI_CTRL_ROT				BIT(6)
#define RKISP1_CIF_MI_BYTE_SWAP				BIT(7)
#define RKISP1_CIF_MI_SP_Y_FULL_YUV2RGB			BIT(8)
#define RKISP1_CIF_MI_SP_CBCR_FULL_YUV2RGB		BIT(9)
#define RKISP1_CIF_MI_SP_422NONCOSITEED			BIT(10)
#define RKISP1_CIF_MI_MP_PINGPONG_ENABLE		BIT(11)
#define RKISP1_CIF_MI_SP_PINGPONG_ENABLE		BIT(12)
#define RKISP1_CIF_MI_MP_AUTOUPDATE_ENABLE		BIT(13)
#define RKISP1_CIF_MI_SP_AUTOUPDATE_ENABLE		BIT(14)
#define RKISP1_CIF_MI_LAST_PIXEL_SIG_ENABLE		BIT(15)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_LUM_16		(0 << 16)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_LUM_32		BIT(16)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_LUM_64		(2 << 16)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_CHROM_16		(0 << 18)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_CHROM_32		BIT(18)
#define RKISP1_CIF_MI_CTRL_BURST_LEN_CHROM_64		(2 << 18)
#define RKISP1_CIF_MI_CTRL_INIT_BASE_EN			BIT(20)
#define RKISP1_CIF_MI_CTRL_INIT_OFFSET_EN		BIT(21)
#define RKISP1_MI_CTRL_MP_WRITE_YUV_PLA_OR_RAW8		(0 << 22)
#define RKISP1_MI_CTRL_MP_WRITE_YUV_SPLA		BIT(22)
#define RKISP1_MI_CTRL_MP_WRITE_YUVINT			(2 << 22)
#define RKISP1_MI_CTRL_MP_WRITE_RAW12			(2 << 22)
#define RKISP1_MI_CTRL_SP_WRITE_PLA			(0 << 24)
#define RKISP1_MI_CTRL_SP_WRITE_SPLA			BIT(24)
#define RKISP1_MI_CTRL_SP_WRITE_INT			(2 << 24)
#define RKISP1_MI_CTRL_SP_INPUT_YUV400			(0 << 26)
#define RKISP1_MI_CTRL_SP_INPUT_YUV420			BIT(26)
#define RKISP1_MI_CTRL_SP_INPUT_YUV422			(2 << 26)
#define RKISP1_MI_CTRL_SP_INPUT_YUV444			(3 << 26)
#define RKISP1_MI_CTRL_SP_OUTPUT_YUV400			(0 << 28)
#define RKISP1_MI_CTRL_SP_OUTPUT_YUV420			BIT(28)
#define RKISP1_MI_CTRL_SP_OUTPUT_YUV422			(2 << 28)
#define RKISP1_MI_CTRL_SP_OUTPUT_YUV444			(3 << 28)
#define RKISP1_MI_CTRL_SP_OUTPUT_RGB565			(4 << 28)
#define RKISP1_MI_CTRL_SP_OUTPUT_RGB666			(5 << 28)
#define RKISP1_MI_CTRL_SP_OUTPUT_RGB888			(6 << 28)

#define RKISP1_MI_CTRL_MP_FMT_MASK			GENMASK(23, 22)
#define RKISP1_MI_CTRL_SP_FMT_MASK			GENMASK(30, 24)

/* MI_INIT */
#define RKISP1_CIF_MI_INIT_SKIP				BIT(2)
#define RKISP1_CIF_MI_INIT_SOFT_UPD			BIT(4)

/* MI_CTRL_SHD */
#define RKISP1_CIF_MI_CTRL_SHD_MP_IN_ENABLED		BIT(0)
#define RKISP1_CIF_MI_CTRL_SHD_SP_IN_ENABLED		BIT(1)
#define RKISP1_CIF_MI_CTRL_SHD_JPEG_IN_ENABLED		BIT(2)
#define RKISP1_CIF_MI_CTRL_SHD_RAW_IN_ENABLED		BIT(3)
#define RKISP1_CIF_MI_CTRL_SHD_MP_OUT_ENABLED		BIT(16)
#define RKISP1_CIF_MI_CTRL_SHD_SP_OUT_ENABLED		BIT(17)
#define RKISP1_CIF_MI_CTRL_SHD_JPEG_OUT_ENABLED		BIT(18)
#define RKISP1_CIF_MI_CTRL_SHD_RAW_OUT_ENABLED		BIT(19)

/* RSZ_CTRL */
#define RKISP1_CIF_RSZ_CTRL_SCALE_HY_ENABLE		BIT(0)
#define RKISP1_CIF_RSZ_CTRL_SCALE_HC_ENABLE		BIT(1)
#define RKISP1_CIF_RSZ_CTRL_SCALE_VY_ENABLE		BIT(2)
#define RKISP1_CIF_RSZ_CTRL_SCALE_VC_ENABLE		BIT(3)
#define RKISP1_CIF_RSZ_CTRL_SCALE_HY_UP			BIT(4)
#define RKISP1_CIF_RSZ_CTRL_SCALE_HC_UP			BIT(5)
#define RKISP1_CIF_RSZ_CTRL_SCALE_VY_UP			BIT(6)
#define RKISP1_CIF_RSZ_CTRL_SCALE_VC_UP			BIT(7)
#define RKISP1_CIF_RSZ_CTRL_CFG_UPD			BIT(8)
#define RKISP1_CIF_RSZ_CTRL_CFG_UPD_AUTO		BIT(9)
#define RKISP1_CIF_RSZ_SCALER_FACTOR			BIT(16)

/* MI_IMSC - MI_MIS - MI_RIS - MI_ICR - MI_ISR */
#define RKISP1_CIF_MI_FRAME(stream)			BIT((stream)->id)
#define RKISP1_CIF_MI_MBLK_LINE				BIT(2)
#define RKISP1_CIF_MI_FILL_MP_Y				BIT(3)
#define RKISP1_CIF_MI_WRAP_MP_Y				BIT(4)
#define RKISP1_CIF_MI_WRAP_MP_CB			BIT(5)
#define RKISP1_CIF_MI_WRAP_MP_CR			BIT(6)
#define RKISP1_CIF_MI_WRAP_SP_Y				BIT(7)
#define RKISP1_CIF_MI_WRAP_SP_CB			BIT(8)
#define RKISP1_CIF_MI_WRAP_SP_CR			BIT(9)
#define RKISP1_CIF_MI_DMA_READY				BIT(11)

/* MI_STATUS */
#define RKISP1_CIF_MI_STATUS_MP_Y_FIFO_FULL		BIT(0)
#define RKISP1_CIF_MI_STATUS_SP_Y_FIFO_FULL		BIT(4)

/* MI_DMA_CTRL */
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_LUM_16		(0 << 0)
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_LUM_32		BIT(0)
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_LUM_64		(2 << 0)
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_CHROM_16	(0 << 2)
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_CHROM_32	BIT(2)
#define RKISP1_CIF_MI_DMA_CTRL_BURST_LEN_CHROM_64	(2 << 2)
#define RKISP1_CIF_MI_DMA_CTRL_READ_FMT_PLANAR		(0 << 4)
#define RKISP1_CIF_MI_DMA_CTRL_READ_FMT_SPLANAR		BIT(4)
#define RKISP1_CIF_MI_DMA_CTRL_FMT_YUV400		(0 << 6)
#define RKISP1_CIF_MI_DMA_CTRL_FMT_YUV420		BIT(6)
#define RKISP1_CIF_MI_DMA_CTRL_READ_FMT_PACKED		(2 << 4)
#define RKISP1_CIF_MI_DMA_CTRL_FMT_YUV422		(2 << 6)
#define RKISP1_CIF_MI_DMA_CTRL_FMT_YUV444		(3 << 6)
#define RKISP1_CIF_MI_DMA_CTRL_BYTE_SWAP		BIT(8)
#define RKISP1_CIF_MI_DMA_CTRL_CONTINUOUS_ENA		BIT(9)
#define RKISP1_CIF_MI_DMA_CTRL_RGB_BAYER_NO		(0 << 12)
#define RKISP1_CIF_MI_DMA_CTRL_RGB_BAYER_8BIT		BIT(12)
#define RKISP1_CIF_MI_DMA_CTRL_RGB_BAYER_16BIT		(2 << 12)
/* MI_DMA_START */
#define RKISP1_CIF_MI_DMA_START_ENABLE			BIT(0)
/* MI_XTD_FORMAT_CTRL  */
#define RKISP1_CIF_MI_XTD_FMT_CTRL_MP_CB_CR_SWAP	BIT(0)
#define RKISP1_CIF_MI_XTD_FMT_CTRL_SP_CB_CR_SWAP	BIT(1)
#define RKISP1_CIF_MI_XTD_FMT_CTRL_DMA_CB_CR_SWAP	BIT(2)

/* CCL */
#define RKISP1_CIF_CCL_CIF_CLK_DIS			BIT(2)
/* VI_ISP_CLK_CTRL */
#define RKISP1_CIF_CLK_CTRL_ISP_RAW			BIT(0)
#define RKISP1_CIF_CLK_CTRL_ISP_RGB			BIT(1)
#define RKISP1_CIF_CLK_CTRL_ISP_YUV			BIT(2)
#define RKISP1_CIF_CLK_CTRL_ISP_3A			BIT(3)
#define RKISP1_CIF_CLK_CTRL_MIPI_RAW			BIT(4)
#define RKISP1_CIF_CLK_CTRL_ISP_IE			BIT(5)
#define RKISP1_CIF_CLK_CTRL_RSZ_RAM			BIT(6)
#define RKISP1_CIF_CLK_CTRL_JPEG_RAM			BIT(7)
#define RKISP1_CIF_CLK_CTRL_ACLK_ISP			BIT(8)
#define RKISP1_CIF_CLK_CTRL_MI_IDC			BIT(9)
#define RKISP1_CIF_CLK_CTRL_MI_MP			BIT(10)
#define RKISP1_CIF_CLK_CTRL_MI_JPEG			BIT(11)
#define RKISP1_CIF_CLK_CTRL_MI_DP			BIT(12)
#define RKISP1_CIF_CLK_CTRL_MI_Y12			BIT(13)
#define RKISP1_CIF_CLK_CTRL_MI_SP			BIT(14)
#define RKISP1_CIF_CLK_CTRL_MI_RAW0			BIT(15)
#define RKISP1_CIF_CLK_CTRL_MI_RAW1			BIT(16)
#define RKISP1_CIF_CLK_CTRL_MI_READ			BIT(17)
#define RKISP1_CIF_CLK_CTRL_MI_RAWRD			BIT(18)
#define RKISP1_CIF_CLK_CTRL_CP				BIT(19)
#define RKISP1_CIF_CLK_CTRL_IE				BIT(20)
#define RKISP1_CIF_CLK_CTRL_SI				BIT(21)
#define RKISP1_CIF_CLK_CTRL_RSZM			BIT(22)
#define RKISP1_CIF_CLK_CTRL_DPMUX			BIT(23)
#define RKISP1_CIF_CLK_CTRL_JPEG			BIT(24)
#define RKISP1_CIF_CLK_CTRL_RSZS			BIT(25)
#define RKISP1_CIF_CLK_CTRL_MIPI			BIT(26)
#define RKISP1_CIF_CLK_CTRL_MARVINMI			BIT(27)
/* ICCL */
#define RKISP1_CIF_ICCL_ISP_CLK				BIT(0)
#define RKISP1_CIF_ICCL_CP_CLK				BIT(1)
#define RKISP1_CIF_ICCL_RES_2				BIT(2)
#define RKISP1_CIF_ICCL_MRSZ_CLK			BIT(3)
#define RKISP1_CIF_ICCL_SRSZ_CLK			BIT(4)
#define RKISP1_CIF_ICCL_JPEG_CLK			BIT(5)
#define RKISP1_CIF_ICCL_MI_CLK				BIT(6)
#define RKISP1_CIF_ICCL_RES_7				BIT(7)
#define RKISP1_CIF_ICCL_IE_CLK				BIT(8)
#define RKISP1_CIF_ICCL_SIMP_CLK			BIT(9)
#define RKISP1_CIF_ICCL_SMIA_CLK			BIT(10)
#define RKISP1_CIF_ICCL_MIPI_CLK			BIT(11)
#define RKISP1_CIF_ICCL_DCROP_CLK			BIT(12)
/* IRCL */
#define RKISP1_CIF_IRCL_ISP_SW_RST			BIT(0)
#define RKISP1_CIF_IRCL_CP_SW_RST			BIT(1)
#define RKISP1_CIF_IRCL_YCS_SW_RST			BIT(2)
#define RKISP1_CIF_IRCL_MRSZ_SW_RST			BIT(3)
#define RKISP1_CIF_IRCL_SRSZ_SW_RST			BIT(4)
#define RKISP1_CIF_IRCL_JPEG_SW_RST			BIT(5)
#define RKISP1_CIF_IRCL_MI_SW_RST			BIT(6)
#define RKISP1_CIF_IRCL_CIF_SW_RST			BIT(7)
#define RKISP1_CIF_IRCL_IE_SW_RST			BIT(8)
#define RKISP1_CIF_IRCL_SI_SW_RST			BIT(9)
#define RKISP1_CIF_IRCL_MIPI_SW_RST			BIT(11)

/* C_PROC_CTR */
#define RKISP1_CIF_C_PROC_CTR_ENABLE			BIT(0)
#define RKISP1_CIF_C_PROC_YOUT_FULL			BIT(1)
#define RKISP1_CIF_C_PROC_YIN_FULL			BIT(2)
#define RKISP1_CIF_C_PROC_COUT_FULL			BIT(3)
#define RKISP1_CIF_C_PROC_CTRL_RESERVED			0xFFFFFFFE
#define RKISP1_CIF_C_PROC_CONTRAST_RESERVED		0xFFFFFF00
#define RKISP1_CIF_C_PROC_BRIGHTNESS_RESERVED		0xFFFFFF00
#define RKISP1_CIF_C_PROC_HUE_RESERVED			0xFFFFFF00
#define RKISP1_CIF_C_PROC_SATURATION_RESERVED		0xFFFFFF00
#define RKISP1_CIF_C_PROC_MACC_RESERVED			0xE000E000
#define RKISP1_CIF_C_PROC_TONE_RESERVED			0xF000
/* DUAL_CROP_CTRL */
#define RKISP1_CIF_DUAL_CROP_MP_MODE_BYPASS		(0 << 0)
#define RKISP1_CIF_DUAL_CROP_MP_MODE_YUV		BIT(0)
#define RKISP1_CIF_DUAL_CROP_MP_MODE_RAW		(2 << 0)
#define RKISP1_CIF_DUAL_CROP_SP_MODE_BYPASS		(0 << 2)
#define RKISP1_CIF_DUAL_CROP_SP_MODE_YUV		BIT(2)
#define RKISP1_CIF_DUAL_CROP_SP_MODE_RAW		(2 << 2)
#define RKISP1_CIF_DUAL_CROP_CFG_UPD_PERMANENT		BIT(4)
#define RKISP1_CIF_DUAL_CROP_CFG_UPD			BIT(5)
#define RKISP1_CIF_DUAL_CROP_GEN_CFG_UPD		BIT(6)

/* IMG_EFF_CTRL */
#define RKISP1_CIF_IMG_EFF_CTRL_ENABLE			BIT(0)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_BLACKWHITE		(0 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_NEGATIVE		BIT(1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SEPIA		(2 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_COLOR_SEL		(3 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_EMBOSS		(4 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SKETCH		(5 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SHARPEN		(6 << 1)
#define RKISP1_CIF_IMG_EFF_CTRL_CFG_UPD			BIT(4)
#define RKISP1_CIF_IMG_EFF_CTRL_YCBCR_FULL		BIT(5)

#define RKISP1_CIF_IMG_EFF_CTRL_MODE_BLACKWHITE_SHIFT	0
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_NEGATIVE_SHIFT	1
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SEPIA_SHIFT	2
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_COLOR_SEL_SHIFT	3
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_EMBOSS_SHIFT	4
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SKETCH_SHIFT	5
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_SHARPEN_SHIFT	6
#define RKISP1_CIF_IMG_EFF_CTRL_MODE_MASK		0xE

/* IMG_EFF_COLOR_SEL */
#define RKISP1_CIF_IMG_EFF_COLOR_RGB			0
#define RKISP1_CIF_IMG_EFF_COLOR_B			BIT(0)
#define RKISP1_CIF_IMG_EFF_COLOR_G			(2 << 0)
#define RKISP1_CIF_IMG_EFF_COLOR_GB			(3 << 0)
#define RKISP1_CIF_IMG_EFF_COLOR_R			(4 << 0)
#define RKISP1_CIF_IMG_EFF_COLOR_RB			(5 << 0)
#define RKISP1_CIF_IMG_EFF_COLOR_RG			(6 << 0)
#define RKISP1_CIF_IMG_EFF_COLOR_RGB2			(7 << 0)

/* MIPI_CTRL */
#define RKISP1_CIF_MIPI_CTRL_OUTPUT_ENA			BIT(0)
#define RKISP1_CIF_MIPI_CTRL_SHUTDOWNLANES(a)		(((a) & 0xF) << 8)
#define RKISP1_CIF_MIPI_CTRL_NUM_LANES(a)		(((a) & 0x3) << 12)
#define RKISP1_CIF_MIPI_CTRL_ERR_SOT_HS_SKIP		BIT(16)
#define RKISP1_CIF_MIPI_CTRL_ERR_SOT_SYNC_HS_SKIP	BIT(17)
#define RKISP1_CIF_MIPI_CTRL_CLOCKLANE_ENA		BIT(18)

/* MIPI_DATA_SEL */
#define RKISP1_CIF_MIPI_DATA_SEL_VC(a)			(((a) & 0x3) << 6)
#define RKISP1_CIF_MIPI_DATA_SEL_DT(a)			(((a) & 0x3F) << 0)

/* MIPI_IMSC, MIPI_RIS, MIPI_MIS, MIPI_ICR, MIPI_ISR */
#define RKISP1_CIF_MIPI_SYNC_FIFO_OVFLW(a)		(((a) & 0xF) << 0)
#define RKISP1_CIF_MIPI_ERR_SOT(a)			(((a) & 0xF) << 4)
#define RKISP1_CIF_MIPI_ERR_SOT_SYNC(a)			(((a) & 0xF) << 8)
#define RKISP1_CIF_MIPI_ERR_EOT_SYNC(a)			(((a) & 0xF) << 12)
#define RKISP1_CIF_MIPI_ERR_CTRL(a)			(((a) & 0xF) << 16)
#define RKISP1_CIF_MIPI_ERR_PROTOCOL			BIT(20)
#define RKISP1_CIF_MIPI_ERR_ECC1			BIT(21)
#define RKISP1_CIF_MIPI_ERR_ECC2			BIT(22)
#define RKISP1_CIF_MIPI_ERR_CS				BIT(23)
#define RKISP1_CIF_MIPI_FRAME_END			BIT(24)
#define RKISP1_CIF_MIPI_ADD_DATA_OVFLW			BIT(25)
#define RKISP1_CIF_MIPI_ADD_DATA_WATER_MARK		BIT(26)

#define RKISP1_CIF_MIPI_ERR_CSI  (RKISP1_CIF_MIPI_ERR_PROTOCOL | \
	RKISP1_CIF_MIPI_ERR_ECC1 | \
	RKISP1_CIF_MIPI_ERR_ECC2 | \
	RKISP1_CIF_MIPI_ERR_CS)

#define RKISP1_CIF_MIPI_ERR_DPHY  (RKISP1_CIF_MIPI_ERR_SOT(3) | \
	RKISP1_CIF_MIPI_ERR_SOT_SYNC(3) | \
	RKISP1_CIF_MIPI_ERR_EOT_SYNC(3) | \
	RKISP1_CIF_MIPI_ERR_CTRL(3))

/* SUPER_IMPOSE */
#define RKISP1_CIF_SUPER_IMP_CTRL_NORMAL_MODE		BIT(0)
#define RKISP1_CIF_SUPER_IMP_CTRL_REF_IMG_MEM		BIT(1)
#define RKISP1_CIF_SUPER_IMP_CTRL_TRANSP_DIS		BIT(2)

/* ISP HISTOGRAM CALCULATION : ISP_HIST_PROP */
#define RKISP1_CIF_ISP_HIST_PROP_MODE_DIS_V10		(0 << 0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_RGB_V10		BIT(0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_RED_V10		(2 << 0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_GREEN_V10		(3 << 0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_BLUE_V10		(4 << 0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_LUM_V10		(5 << 0)
#define RKISP1_CIF_ISP_HIST_PROP_MODE_MASK_V10		0x7
#define RKISP1_CIF_ISP_HIST_PREDIV_SET_V10(x)		(((x) & 0x7F) << 3)
#define RKISP1_CIF_ISP_HIST_WEIGHT_SET_V10(v0, v1, v2, v3)	\
				     (((v0) & 0x1F) | (((v1) & 0x1F) << 8)  |\
				     (((v2) & 0x1F) << 16) | \
				     (((v3) & 0x1F) << 24))

#define RKISP1_CIF_ISP_HIST_WINDOW_OFFSET_RESERVED_V10	0xFFFFF000
#define RKISP1_CIF_ISP_HIST_WINDOW_SIZE_RESERVED_V10	0xFFFFF800
#define RKISP1_CIF_ISP_HIST_WEIGHT_RESERVED_V10		0xE0E0E0E0
#define RKISP1_CIF_ISP_MAX_HIST_PREDIVIDER_V10		0x0000007F
#define RKISP1_CIF_ISP_HIST_ROW_NUM_V10			5
#define RKISP1_CIF_ISP_HIST_COLUMN_NUM_V10		5
#define RKISP1_CIF_ISP_HIST_GET_BIN_V10(x)		((x) & 0x000FFFFF)

/* ISP HISTOGRAM CALCULATION : CIF_ISP_HIST */
#define RKISP1_CIF_ISP_HIST_CTRL_EN_SET_V12(x)		(((x) & 0x01) << 0)
#define RKISP1_CIF_ISP_HIST_CTRL_EN_MASK_V12		RKISP1_CIF_ISP_HIST_CTRL_EN_SET_V12(0x01)
#define RKISP1_CIF_ISP_HIST_CTRL_STEPSIZE_SET_V12(x)	(((x) & 0x7F) << 1)
#define RKISP1_CIF_ISP_HIST_CTRL_MODE_SET_V12(x)	(((x) & 0x07) << 8)
#define RKISP1_CIF_ISP_HIST_CTRL_MODE_MASK_V12		RKISP1_CIF_ISP_HIST_CTRL_MODE_SET_V12(0x07)
#define RKISP1_CIF_ISP_HIST_CTRL_AUTOSTOP_SET_V12(x)	(((x) & 0x01) << 11)
#define RKISP1_CIF_ISP_HIST_CTRL_WATERLINE_SET_V12(x)	(((x) & 0xFFF) << 12)
#define RKISP1_CIF_ISP_HIST_CTRL_DATASEL_SET_V12(x)	(((x) & 0x07) << 24)
#define RKISP1_CIF_ISP_HIST_CTRL_INTRSEL_SET_V12(x)	(((x) & 0x01) << 27)
#define RKISP1_CIF_ISP_HIST_CTRL_WNDNUM_SET_V12(x)	(((x) & 0x03) << 28)
#define RKISP1_CIF_ISP_HIST_CTRL_DBGEN_SET_V12(x)	(((x) & 0x01) << 30)
#define RKISP1_CIF_ISP_HIST_ROW_NUM_V12		15
#define RKISP1_CIF_ISP_HIST_COLUMN_NUM_V12		15
#define RKISP1_CIF_ISP_HIST_WEIGHT_REG_SIZE_V12	\
				(RKISP1_CIF_ISP_HIST_ROW_NUM_V12 * RKISP1_CIF_ISP_HIST_COLUMN_NUM_V12)

#define RKISP1_CIF_ISP_HIST_WEIGHT_SET_V12(v0, v1, v2, v3)	\
				(((v0) & 0x3F) | (((v1) & 0x3F) << 8) |\
				(((v2) & 0x3F) << 16) |\
				(((v3) & 0x3F) << 24))

#define RKISP1_CIF_ISP_HIST_OFFS_SET_V12(v0, v1)	\
				(((v0) & 0x1FFF) | (((v1) & 0x1FFF) << 16))
#define RKISP1_CIF_ISP_HIST_SIZE_SET_V12(v0, v1)	\
				(((v0) & 0x7FF) | (((v1) & 0x7FF) << 16))

#define RKISP1_CIF_ISP_HIST_GET_BIN0_V12(x)	\
				((x) & 0xFFFF)
#define RKISP1_CIF_ISP_HIST_GET_BIN1_V12(x)	\
				(((x) >> 16) & 0xFFFF)

/* AUTO FOCUS MEASUREMENT:  ISP_AFM_CTRL */
#define RKISP1_ISP_AFM_CTRL_ENABLE			BIT(0)

/* SHUTTER CONTROL */
#define RKISP1_CIF_ISP_SH_CTRL_SH_ENA			BIT(0)
#define RKISP1_CIF_ISP_SH_CTRL_REP_EN			BIT(1)
#define RKISP1_CIF_ISP_SH_CTRL_SRC_SH_TRIG		BIT(2)
#define RKISP1_CIF_ISP_SH_CTRL_EDGE_POS			BIT(3)
#define RKISP1_CIF_ISP_SH_CTRL_POL_LOW			BIT(4)

/* FLASH MODULE */
/* ISP_FLASH_CMD */
#define RKISP1_CIFFLASH_CMD_PRELIGHT_ON			BIT(0)
#define RKISP1_CIFFLASH_CMD_FLASH_ON			BIT(1)
#define RKISP1_CIFFLASH_CMD_PRE_FLASH_ON		BIT(2)
/* ISP_FLASH_CONFIG */
#define RKISP1_CIFFLASH_CONFIG_PRELIGHT_END		BIT(0)
#define RKISP1_CIFFLASH_CONFIG_VSYNC_POS		BIT(1)
#define RKISP1_CIFFLASH_CONFIG_PRELIGHT_LOW		BIT(2)
#define RKISP1_CIFFLASH_CONFIG_SRC_FL_TRIG		BIT(3)
#define RKISP1_CIFFLASH_CONFIG_DELAY(a)			(((a) & 0xF) << 4)

/* Demosaic:  ISP_DEMOSAIC */
#define RKISP1_CIF_ISP_DEMOSAIC_BYPASS			BIT(10)
#define RKISP1_CIF_ISP_DEMOSAIC_TH(x)			((x) & 0xFF)

/* AWB */
/* ISP_AWB_PROP */
#define RKISP1_CIF_ISP_AWB_YMAX_CMP_EN			BIT(2)
#define RKISP1_CIF_ISP_AWB_YMAX_READ(x)			(((x) >> 2) & 1)
#define RKISP1_CIF_ISP_AWB_MODE_RGB_EN			((1 << 31) | (0x2 << 0))
#define RKISP1_CIF_ISP_AWB_MODE_YCBCR_EN		((0 << 31) | (0x2 << 0))
#define RKISP1_CIF_ISP_AWB_MODE_MASK_NONE		0xFFFFFFFC
#define RKISP1_CIF_ISP_AWB_MODE_READ(x)			((x) & 3)
#define RKISP1_CIF_ISP_AWB_SET_FRAMES_V12(x)		(((x) & 0x07) << 28)
#define RKISP1_CIF_ISP_AWB_SET_FRAMES_MASK_V12		RKISP1_CIF_ISP_AWB_SET_FRAMES_V12(0x07)
/* ISP_AWB_GAIN_RB, ISP_AWB_GAIN_G  */
#define RKISP1_CIF_ISP_AWB_GAIN_R_SET(x)		(((x) & 0x3FF) << 16)
#define RKISP1_CIF_ISP_AWB_GAIN_R_READ(x)		(((x) >> 16) & 0x3FF)
#define RKISP1_CIF_ISP_AWB_GAIN_B_SET(x)		((x) & 0x3FFF)
#define RKISP1_CIF_ISP_AWB_GAIN_B_READ(x)		((x) & 0x3FFF)
/* ISP_AWB_REF */
#define RKISP1_CIF_ISP_AWB_REF_CR_SET(x)		(((x) & 0xFF) << 8)
#define RKISP1_CIF_ISP_AWB_REF_CR_READ(x)		(((x) >> 8) & 0xFF)
#define RKISP1_CIF_ISP_AWB_REF_CB_READ(x)		((x) & 0xFF)
/* ISP_AWB_THRESH */
#define RKISP1_CIF_ISP_AWB_MAX_CS_SET(x)		(((x) & 0xFF) << 8)
#define RKISP1_CIF_ISP_AWB_MAX_CS_READ(x)		(((x) >> 8) & 0xFF)
#define RKISP1_CIF_ISP_AWB_MIN_C_READ(x)		((x) & 0xFF)
#define RKISP1_CIF_ISP_AWB_MIN_Y_SET(x)			(((x) & 0xFF) << 16)
#define RKISP1_CIF_ISP_AWB_MIN_Y_READ(x)		(((x) >> 16) & 0xFF)
#define RKISP1_CIF_ISP_AWB_MAX_Y_SET(x)			(((x) & 0xFF) << 24)
#define RKISP1_CIF_ISP_AWB_MAX_Y_READ(x)			(((x) >> 24) & 0xFF)
/* ISP_AWB_MEAN */
#define RKISP1_CIF_ISP_AWB_GET_MEAN_CR_R(x)		((x) & 0xFF)
#define RKISP1_CIF_ISP_AWB_GET_MEAN_CB_B(x)		(((x) >> 8) & 0xFF)
#define RKISP1_CIF_ISP_AWB_GET_MEAN_Y_G(x)		(((x) >> 16) & 0xFF)
/* ISP_AWB_WHITE_CNT */
#define RKISP1_CIF_ISP_AWB_GET_PIXEL_CNT(x)		((x) & 0x3FFFFFF)

#define RKISP1_CIF_ISP_AWB_GAINS_MAX_VAL		0x000003FF
#define RKISP1_CIF_ISP_AWB_WINDOW_OFFSET_MAX		0x00000FFF
#define RKISP1_CIF_ISP_AWB_WINDOW_MAX_SIZE		0x00001FFF
#define RKISP1_CIF_ISP_AWB_CBCR_MAX_REF			0x000000FF
#define RKISP1_CIF_ISP_AWB_THRES_MAX_YC			0x000000FF

/* AE */
/* ISP_EXP_CTRL */
#define RKISP1_CIF_ISP_EXP_ENA				BIT(0)
#define RKISP1_CIF_ISP_EXP_CTRL_AUTOSTOP		BIT(1)
#define RKISP1_CIF_ISP_EXP_CTRL_WNDNUM_SET_V12(x)	(((x) & 0x03) << 2)
/*
 *'1' luminance calculation according to  Y=(R+G+B) x 0.332 (85/256)
 *'0' luminance calculation according to Y=16+0.25R+0.5G+0.1094B
 */
#define RKISP1_CIF_ISP_EXP_CTRL_MEASMODE_1		BIT(31)

/* ISP_EXP_H_SIZE */
#define RKISP1_CIF_ISP_EXP_H_SIZE_SET_V10(x)		((x) & 0x7FF)
#define RKISP1_CIF_ISP_EXP_HEIGHT_MASK_V10			0x000007FF
#define RKISP1_CIF_ISP_EXP_H_SIZE_SET_V12(x)		((x) & 0x7FF)
#define RKISP1_CIF_ISP_EXP_HEIGHT_MASK_V12		0x000007FF
/* ISP_EXP_V_SIZE : vertical size must be a multiple of 2). */
#define RKISP1_CIF_ISP_EXP_V_SIZE_SET_V10(x)		((x) & 0x7FE)
#define RKISP1_CIF_ISP_EXP_V_SIZE_SET_V12(x)		(((x) & 0x7FE) << 16)

/* ISP_EXP_H_OFFSET */
#define RKISP1_CIF_ISP_EXP_H_OFFSET_SET_V10(x)		((x) & 0x1FFF)
#define RKISP1_CIF_ISP_EXP_MAX_HOFFS_V10		2424
#define RKISP1_CIF_ISP_EXP_H_OFFSET_SET_V12(x)		((x) & 0x1FFF)
#define RKISP1_CIF_ISP_EXP_MAX_HOFFS_V12		0x1FFF
/* ISP_EXP_V_OFFSET */
#define RKISP1_CIF_ISP_EXP_V_OFFSET_SET_V10(x)		((x) & 0x1FFF)
#define RKISP1_CIF_ISP_EXP_MAX_VOFFS_V10		1806
#define RKISP1_CIF_ISP_EXP_V_OFFSET_SET_V12(x)		(((x) & 0x1FFF) << 16)
#define RKISP1_CIF_ISP_EXP_MAX_VOFFS_V12		0x1FFF

#define RKISP1_CIF_ISP_EXP_ROW_NUM_V10			5
#define RKISP1_CIF_ISP_EXP_COLUMN_NUM_V10			5
#define RKISP1_CIF_ISP_EXP_NUM_LUMA_REGS_V10 \
	(RKISP1_CIF_ISP_EXP_ROW_NUM_V10 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V10)
#define RKISP1_CIF_ISP_EXP_BLOCK_MAX_HSIZE_V10		516
#define RKISP1_CIF_ISP_EXP_BLOCK_MIN_HSIZE_V10		35
#define RKISP1_CIF_ISP_EXP_BLOCK_MAX_VSIZE_V10		390
#define RKISP1_CIF_ISP_EXP_BLOCK_MIN_VSIZE_V10		28
#define RKISP1_CIF_ISP_EXP_MAX_HSIZE_V10	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MAX_HSIZE_V10 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V10 + 1)
#define RKISP1_CIF_ISP_EXP_MIN_HSIZE_V10	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MIN_HSIZE_V10 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V10 + 1)
#define RKISP1_CIF_ISP_EXP_MAX_VSIZE_V10	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MAX_VSIZE_V10 * RKISP1_CIF_ISP_EXP_ROW_NUM_V10 + 1)
#define RKISP1_CIF_ISP_EXP_MIN_VSIZE_V10	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MIN_VSIZE_V10 * RKISP1_CIF_ISP_EXP_ROW_NUM_V10 + 1)

#define RKISP1_CIF_ISP_EXP_ROW_NUM_V12			15
#define RKISP1_CIF_ISP_EXP_COLUMN_NUM_V12		15
#define RKISP1_CIF_ISP_EXP_NUM_LUMA_REGS_V12 \
	(RKISP1_CIF_ISP_EXP_ROW_NUM_V12 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V12)

#define RKISP1_CIF_ISP_EXP_BLOCK_MAX_HSIZE_V12		0x7FF
#define RKISP1_CIF_ISP_EXP_BLOCK_MIN_HSIZE_V12		0xE
#define RKISP1_CIF_ISP_EXP_BLOCK_MAX_VSIZE_V12		0x7FE
#define RKISP1_CIF_ISP_EXP_BLOCK_MIN_VSIZE_V12		0xE
#define RKISP1_CIF_ISP_EXP_MAX_HSIZE_V12	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MAX_HSIZE_V12 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V12 + 1)
#define RKISP1_CIF_ISP_EXP_MIN_HSIZE_V12	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MIN_HSIZE_V12 * RKISP1_CIF_ISP_EXP_COLUMN_NUM_V12 + 1)
#define RKISP1_CIF_ISP_EXP_MAX_VSIZE_V12	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MAX_VSIZE_V12 * RKISP1_CIF_ISP_EXP_ROW_NUM_V12 + 1)
#define RKISP1_CIF_ISP_EXP_MIN_VSIZE_V12	\
	(RKISP1_CIF_ISP_EXP_BLOCK_MIN_VSIZE_V12 * RKISP1_CIF_ISP_EXP_ROW_NUM_V12 + 1)

#define RKISP1_CIF_ISP_EXP_GET_MEAN_xy0_V12(x)		((x) & 0xFF)
#define RKISP1_CIF_ISP_EXP_GET_MEAN_xy1_V12(x)		(((x) >> 8) & 0xFF)
#define RKISP1_CIF_ISP_EXP_GET_MEAN_xy2_V12(x)		(((x) >> 16) & 0xFF)
#define RKISP1_CIF_ISP_EXP_GET_MEAN_xy3_V12(x)		(((x) >> 24) & 0xFF)

/* LSC: ISP_LSC_CTRL */
#define RKISP1_CIF_ISP_LSC_CTRL_ENA			BIT(0)
#define RKISP1_CIF_ISP_LSC_SECT_SIZE_RESERVED		0xFC00FC00
#define RKISP1_CIF_ISP_LSC_GRAD_RESERVED_V10		0xF000F000
#define RKISP1_CIF_ISP_LSC_SAMPLE_RESERVED_V10		0xF000F000
#define RKISP1_CIF_ISP_LSC_GRAD_RESERVED_V12		0xE000E000
#define RKISP1_CIF_ISP_LSC_SAMPLE_RESERVED_V12		0xE000E000
#define RKISP1_CIF_ISP_LSC_TABLE_DATA_V10(v0, v1)     \
	(((v0) & 0xFFF) | (((v1) & 0xFFF) << 12))
#define RKISP1_CIF_ISP_LSC_TABLE_DATA_V12(v0, v1)     \
	(((v0) & 0x1FFF) | (((v1) & 0x1FFF) << 13))
#define RKISP1_CIF_ISP_LSC_SECT_SIZE(v0, v1)      \
	(((v0) & 0xFFF) | (((v1) & 0xFFF) << 16))
#define RKISP1_CIF_ISP_LSC_GRAD_SIZE(v0, v1)      \
	(((v0) & 0xFFF) | (((v1) & 0xFFF) << 16))

/* LSC: ISP_LSC_TABLE_SEL */
#define RKISP1_CIF_ISP_LSC_TABLE_0			0
#define RKISP1_CIF_ISP_LSC_TABLE_1			1

/* LSC: ISP_LSC_STATUS */
#define RKISP1_CIF_ISP_LSC_ACTIVE_TABLE			BIT(1)
#define RKISP1_CIF_ISP_LSC_TABLE_ADDRESS_0		0
#define RKISP1_CIF_ISP_LSC_TABLE_ADDRESS_153		153

/* FLT */
/* ISP_FILT_MODE */
#define RKISP1_CIF_ISP_FLT_ENA				BIT(0)

/*
 * 0: green filter static mode (active filter factor = FILT_FAC_MID)
 * 1: dynamic noise reduction/sharpen Default
 */
#define RKISP1_CIF_ISP_FLT_MODE_DNR			BIT(1)
#define RKISP1_CIF_ISP_FLT_MODE_MAX			1
#define RKISP1_CIF_ISP_FLT_CHROMA_V_MODE(x)		(((x) & 0x3) << 4)
#define RKISP1_CIF_ISP_FLT_CHROMA_H_MODE(x)		(((x) & 0x3) << 6)
#define RKISP1_CIF_ISP_FLT_CHROMA_MODE_MAX		3
#define RKISP1_CIF_ISP_FLT_GREEN_STAGE1(x)		(((x) & 0xF) << 8)
#define RKISP1_CIF_ISP_FLT_GREEN_STAGE1_MAX		8
#define RKISP1_CIF_ISP_FLT_THREAD_RESERVED		0xFFFFFC00
#define RKISP1_CIF_ISP_FLT_FAC_RESERVED			0xFFFFFFC0
#define RKISP1_CIF_ISP_FLT_LUM_WEIGHT_RESERVED		0xFFF80000

#define RKISP1_CIF_ISP_CTK_COEFF_RESERVED		0xFFFFF800
#define RKISP1_CIF_ISP_XTALK_OFFSET_RESERVED		0xFFFFF000

/* GOC */
#define RKISP1_CIF_ISP_GAMMA_OUT_MODE_EQU		BIT(0)
#define RKISP1_CIF_ISP_GOC_MODE_MAX			1
#define RKISP1_CIF_ISP_GOC_RESERVED			0xFFFFF800
/* ISP_CTRL BIT 11*/
#define RKISP1_CIF_ISP_CTRL_ISP_GAMMA_OUT_ENA_READ(x)	(((x) >> 11) & 1)

/* DPCC */
/* ISP_DPCC_MODE */
#define RKISP1_CIF_ISP_DPCC_ENA				BIT(0)
#define RKISP1_CIF_ISP_DPCC_MODE_MAX			0x07
#define RKISP1_CIF_ISP_DPCC_OUTPUTMODE_MAX		0x0F
#define RKISP1_CIF_ISP_DPCC_SETUSE_MAX			0x0F
#define RKISP1_CIF_ISP_DPCC_METHODS_SET_RESERVED	0xFFFFE000
#define RKISP1_CIF_ISP_DPCC_LINE_THRESH_RESERVED	0xFFFF0000
#define RKISP1_CIF_ISP_DPCC_LINE_MAD_FAC_RESERVED	0xFFFFC0C0
#define RKISP1_CIF_ISP_DPCC_PG_FAC_RESERVED		0xFFFFC0C0
#define RKISP1_CIF_ISP_DPCC_RND_THRESH_RESERVED		0xFFFF0000
#define RKISP1_CIF_ISP_DPCC_RG_FAC_RESERVED		0xFFFFC0C0
#define RKISP1_CIF_ISP_DPCC_RO_LIMIT_RESERVED		0xFFFFF000
#define RKISP1_CIF_ISP_DPCC_RND_OFFS_RESERVED		0xFFFFF000

/* BLS */
/* ISP_BLS_CTRL */
#define RKISP1_CIF_ISP_BLS_ENA				BIT(0)
#define RKISP1_CIF_ISP_BLS_MODE_MEASURED		BIT(1)
#define RKISP1_CIF_ISP_BLS_MODE_FIXED			0
#define RKISP1_CIF_ISP_BLS_WINDOW_1			BIT(2)
#define RKISP1_CIF_ISP_BLS_WINDOW_2			(2 << 2)

/* GAMMA-IN */
#define RKISP1_CIFISP_DEGAMMA_X_RESERVED	\
	((1 << 31) | (1 << 27) | (1 << 23) | (1 << 19) |\
	(1 << 15) | (1 << 11) | (1 << 7) | (1 << 3))
#define RKISP1_CIFISP_DEGAMMA_Y_RESERVED		0xFFFFF000

/* GAMMA-OUT */
#define RKISP1_CIF_ISP_GAMMA_VALUE_V12(x, y)	\
	(((x) & 0xFFF) << 16 | ((y) & 0xFFF) << 0)

/* AFM */
#define RKISP1_CIF_ISP_AFM_ENA				BIT(0)
#define RKISP1_CIF_ISP_AFM_THRES_RESERVED		0xFFFF0000
#define RKISP1_CIF_ISP_AFM_VAR_SHIFT_RESERVED		0xFFF8FFF8
#define RKISP1_CIF_ISP_AFM_WINDOW_X_RESERVED		0xE000
#define RKISP1_CIF_ISP_AFM_WINDOW_Y_RESERVED		0xF000
#define RKISP1_CIF_ISP_AFM_WINDOW_X_MIN			0x5
#define RKISP1_CIF_ISP_AFM_WINDOW_Y_MIN			0x2
#define RKISP1_CIF_ISP_AFM_WINDOW_X(x)			(((x) & 0x1FFF) << 16)
#define RKISP1_CIF_ISP_AFM_WINDOW_Y(x)			((x) & 0x1FFF)
#define RKISP1_CIF_ISP_AFM_SET_SHIFT_a_V12(x, y)	(((x) & 0x7) << 16 | ((y) & 0x7) << 0)
#define RKISP1_CIF_ISP_AFM_SET_SHIFT_b_V12(x, y)	(((x) & 0x7) << 20 | ((y) & 0x7) << 4)
#define RKISP1_CIF_ISP_AFM_SET_SHIFT_c_V12(x, y)	(((x) & 0x7) << 24 | ((y) & 0x7) << 8)
#define RKISP1_CIF_ISP_AFM_GET_LUM_SHIFT_a_V12(x)	(((x) & 0x70000) >> 16)
#define RKISP1_CIF_ISP_AFM_GET_AFM_SHIFT_a_V12(x)	((x) & 0x7)

/* DPF */
#define RKISP1_CIF_ISP_DPF_MODE_EN			BIT(0)
#define RKISP1_CIF_ISP_DPF_MODE_B_FLT_DIS		BIT(1)
#define RKISP1_CIF_ISP_DPF_MODE_GB_FLT_DIS		BIT(2)
#define RKISP1_CIF_ISP_DPF_MODE_GR_FLT_DIS		BIT(3)
#define RKISP1_CIF_ISP_DPF_MODE_R_FLT_DIS		BIT(4)
#define RKISP1_CIF_ISP_DPF_MODE_RB_FLTSIZE_9x9		BIT(5)
#define RKISP1_CIF_ISP_DPF_MODE_NLL_SEGMENTATION	BIT(6)
#define RKISP1_CIF_ISP_DPF_MODE_AWB_GAIN_COMP		BIT(7)
#define RKISP1_CIF_ISP_DPF_MODE_LSC_GAIN_COMP		BIT(8)
#define RKISP1_CIF_ISP_DPF_MODE_USE_NF_GAIN		BIT(9)
#define RKISP1_CIF_ISP_DPF_NF_GAIN_RESERVED		0xFFFFF000
#define RKISP1_CIF_ISP_DPF_SPATIAL_COEFF_MAX		0x1F
#define RKISP1_CIF_ISP_DPF_NLL_COEFF_N_MAX		0x3FF

/* =================================================================== */
/*                            CIF Registers                            */
/* =================================================================== */
#define RKISP1_CIF_CTRL_BASE			0x00000000
#define RKISP1_CIF_CCL				(RKISP1_CIF_CTRL_BASE + 0x00000000)
#define RKISP1_CIF_VI_ID			(RKISP1_CIF_CTRL_BASE + 0x00000008)
#define RKISP1_CIF_VI_ISP_CLK_CTRL_V12		(RKISP1_CIF_CTRL_BASE + 0x0000000C)
#define RKISP1_CIF_ICCL				(RKISP1_CIF_CTRL_BASE + 0x00000010)
#define RKISP1_CIF_IRCL				(RKISP1_CIF_CTRL_BASE + 0x00000014)
#define RKISP1_CIF_VI_DPCL			(RKISP1_CIF_CTRL_BASE + 0x00000018)

#define RKISP1_CIF_IMG_EFF_BASE			0x00000200
#define RKISP1_CIF_IMG_EFF_CTRL			(RKISP1_CIF_IMG_EFF_BASE + 0x00000000)
#define RKISP1_CIF_IMG_EFF_COLOR_SEL		(RKISP1_CIF_IMG_EFF_BASE + 0x00000004)
#define RKISP1_CIF_IMG_EFF_MAT_1		(RKISP1_CIF_IMG_EFF_BASE + 0x00000008)
#define RKISP1_CIF_IMG_EFF_MAT_2		(RKISP1_CIF_IMG_EFF_BASE + 0x0000000C)
#define RKISP1_CIF_IMG_EFF_MAT_3		(RKISP1_CIF_IMG_EFF_BASE + 0x00000010)
#define RKISP1_CIF_IMG_EFF_MAT_4		(RKISP1_CIF_IMG_EFF_BASE + 0x00000014)
#define RKISP1_CIF_IMG_EFF_MAT_5		(RKISP1_CIF_IMG_EFF_BASE + 0x00000018)
#define RKISP1_CIF_IMG_EFF_TINT			(RKISP1_CIF_IMG_EFF_BASE + 0x0000001C)
#define RKISP1_CIF_IMG_EFF_CTRL_SHD		(RKISP1_CIF_IMG_EFF_BASE + 0x00000020)
#define RKISP1_CIF_IMG_EFF_SHARPEN		(RKISP1_CIF_IMG_EFF_BASE + 0x00000024)

#define RKISP1_CIF_SUPER_IMP_BASE		0x00000300
#define RKISP1_CIF_SUPER_IMP_CTRL		(RKISP1_CIF_SUPER_IMP_BASE + 0x00000000)
#define RKISP1_CIF_SUPER_IMP_OFFSET_X		(RKISP1_CIF_SUPER_IMP_BASE + 0x00000004)
#define RKISP1_CIF_SUPER_IMP_OFFSET_Y		(RKISP1_CIF_SUPER_IMP_BASE + 0x00000008)
#define RKISP1_CIF_SUPER_IMP_COLOR_Y		(RKISP1_CIF_SUPER_IMP_BASE + 0x0000000C)
#define RKISP1_CIF_SUPER_IMP_COLOR_CB		(RKISP1_CIF_SUPER_IMP_BASE + 0x00000010)
#define RKISP1_CIF_SUPER_IMP_COLOR_CR		(RKISP1_CIF_SUPER_IMP_BASE + 0x00000014)

#define RKISP1_CIF_ISP_BASE			0x00000400
#define RKISP1_CIF_ISP_CTRL			(RKISP1_CIF_ISP_BASE + 0x00000000)
#define RKISP1_CIF_ISP_ACQ_PROP			(RKISP1_CIF_ISP_BASE + 0x00000004)
#define RKISP1_CIF_ISP_ACQ_H_OFFS		(RKISP1_CIF_ISP_BASE + 0x00000008)
#define RKISP1_CIF_ISP_ACQ_V_OFFS		(RKISP1_CIF_ISP_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_ACQ_H_SIZE		(RKISP1_CIF_ISP_BASE + 0x00000010)
#define RKISP1_CIF_ISP_ACQ_V_SIZE		(RKISP1_CIF_ISP_BASE + 0x00000014)
#define RKISP1_CIF_ISP_ACQ_NR_FRAMES		(RKISP1_CIF_ISP_BASE + 0x00000018)
#define RKISP1_CIF_ISP_GAMMA_DX_LO		(RKISP1_CIF_ISP_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_GAMMA_DX_HI		(RKISP1_CIF_ISP_BASE + 0x00000020)
#define RKISP1_CIF_ISP_GAMMA_R_Y0		(RKISP1_CIF_ISP_BASE + 0x00000024)
#define RKISP1_CIF_ISP_GAMMA_R_Y1		(RKISP1_CIF_ISP_BASE + 0x00000028)
#define RKISP1_CIF_ISP_GAMMA_R_Y2		(RKISP1_CIF_ISP_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_GAMMA_R_Y3		(RKISP1_CIF_ISP_BASE + 0x00000030)
#define RKISP1_CIF_ISP_GAMMA_R_Y4		(RKISP1_CIF_ISP_BASE + 0x00000034)
#define RKISP1_CIF_ISP_GAMMA_R_Y5		(RKISP1_CIF_ISP_BASE + 0x00000038)
#define RKISP1_CIF_ISP_GAMMA_R_Y6		(RKISP1_CIF_ISP_BASE + 0x0000003C)
#define RKISP1_CIF_ISP_GAMMA_R_Y7		(RKISP1_CIF_ISP_BASE + 0x00000040)
#define RKISP1_CIF_ISP_GAMMA_R_Y8		(RKISP1_CIF_ISP_BASE + 0x00000044)
#define RKISP1_CIF_ISP_GAMMA_R_Y9		(RKISP1_CIF_ISP_BASE + 0x00000048)
#define RKISP1_CIF_ISP_GAMMA_R_Y10		(RKISP1_CIF_ISP_BASE + 0x0000004C)
#define RKISP1_CIF_ISP_GAMMA_R_Y11		(RKISP1_CIF_ISP_BASE + 0x00000050)
#define RKISP1_CIF_ISP_GAMMA_R_Y12		(RKISP1_CIF_ISP_BASE + 0x00000054)
#define RKISP1_CIF_ISP_GAMMA_R_Y13		(RKISP1_CIF_ISP_BASE + 0x00000058)
#define RKISP1_CIF_ISP_GAMMA_R_Y14		(RKISP1_CIF_ISP_BASE + 0x0000005C)
#define RKISP1_CIF_ISP_GAMMA_R_Y15		(RKISP1_CIF_ISP_BASE + 0x00000060)
#define RKISP1_CIF_ISP_GAMMA_R_Y16		(RKISP1_CIF_ISP_BASE + 0x00000064)
#define RKISP1_CIF_ISP_GAMMA_G_Y0		(RKISP1_CIF_ISP_BASE + 0x00000068)
#define RKISP1_CIF_ISP_GAMMA_G_Y1		(RKISP1_CIF_ISP_BASE + 0x0000006C)
#define RKISP1_CIF_ISP_GAMMA_G_Y2		(RKISP1_CIF_ISP_BASE + 0x00000070)
#define RKISP1_CIF_ISP_GAMMA_G_Y3		(RKISP1_CIF_ISP_BASE + 0x00000074)
#define RKISP1_CIF_ISP_GAMMA_G_Y4		(RKISP1_CIF_ISP_BASE + 0x00000078)
#define RKISP1_CIF_ISP_GAMMA_G_Y5		(RKISP1_CIF_ISP_BASE + 0x0000007C)
#define RKISP1_CIF_ISP_GAMMA_G_Y6		(RKISP1_CIF_ISP_BASE + 0x00000080)
#define RKISP1_CIF_ISP_GAMMA_G_Y7		(RKISP1_CIF_ISP_BASE + 0x00000084)
#define RKISP1_CIF_ISP_GAMMA_G_Y8		(RKISP1_CIF_ISP_BASE + 0x00000088)
#define RKISP1_CIF_ISP_GAMMA_G_Y9		(RKISP1_CIF_ISP_BASE + 0x0000008C)
#define RKISP1_CIF_ISP_GAMMA_G_Y10		(RKISP1_CIF_ISP_BASE + 0x00000090)
#define RKISP1_CIF_ISP_GAMMA_G_Y11		(RKISP1_CIF_ISP_BASE + 0x00000094)
#define RKISP1_CIF_ISP_GAMMA_G_Y12		(RKISP1_CIF_ISP_BASE + 0x00000098)
#define RKISP1_CIF_ISP_GAMMA_G_Y13		(RKISP1_CIF_ISP_BASE + 0x0000009C)
#define RKISP1_CIF_ISP_GAMMA_G_Y14		(RKISP1_CIF_ISP_BASE + 0x000000A0)
#define RKISP1_CIF_ISP_GAMMA_G_Y15		(RKISP1_CIF_ISP_BASE + 0x000000A4)
#define RKISP1_CIF_ISP_GAMMA_G_Y16		(RKISP1_CIF_ISP_BASE + 0x000000A8)
#define RKISP1_CIF_ISP_GAMMA_B_Y0		(RKISP1_CIF_ISP_BASE + 0x000000AC)
#define RKISP1_CIF_ISP_GAMMA_B_Y1		(RKISP1_CIF_ISP_BASE + 0x000000B0)
#define RKISP1_CIF_ISP_GAMMA_B_Y2		(RKISP1_CIF_ISP_BASE + 0x000000B4)
#define RKISP1_CIF_ISP_GAMMA_B_Y3		(RKISP1_CIF_ISP_BASE + 0x000000B8)
#define RKISP1_CIF_ISP_GAMMA_B_Y4		(RKISP1_CIF_ISP_BASE + 0x000000BC)
#define RKISP1_CIF_ISP_GAMMA_B_Y5		(RKISP1_CIF_ISP_BASE + 0x000000C0)
#define RKISP1_CIF_ISP_GAMMA_B_Y6		(RKISP1_CIF_ISP_BASE + 0x000000C4)
#define RKISP1_CIF_ISP_GAMMA_B_Y7		(RKISP1_CIF_ISP_BASE + 0x000000C8)
#define RKISP1_CIF_ISP_GAMMA_B_Y8		(RKISP1_CIF_ISP_BASE + 0x000000CC)
#define RKISP1_CIF_ISP_GAMMA_B_Y9		(RKISP1_CIF_ISP_BASE + 0x000000D0)
#define RKISP1_CIF_ISP_GAMMA_B_Y10		(RKISP1_CIF_ISP_BASE + 0x000000D4)
#define RKISP1_CIF_ISP_GAMMA_B_Y11		(RKISP1_CIF_ISP_BASE + 0x000000D8)
#define RKISP1_CIF_ISP_GAMMA_B_Y12		(RKISP1_CIF_ISP_BASE + 0x000000DC)
#define RKISP1_CIF_ISP_GAMMA_B_Y13		(RKISP1_CIF_ISP_BASE + 0x000000E0)
#define RKISP1_CIF_ISP_GAMMA_B_Y14		(RKISP1_CIF_ISP_BASE + 0x000000E4)
#define RKISP1_CIF_ISP_GAMMA_B_Y15		(RKISP1_CIF_ISP_BASE + 0x000000E8)
#define RKISP1_CIF_ISP_GAMMA_B_Y16		(RKISP1_CIF_ISP_BASE + 0x000000EC)
#define RKISP1_CIF_ISP_AWB_PROP_V10		(RKISP1_CIF_ISP_BASE + 0x00000110)
#define RKISP1_CIF_ISP_AWB_WND_H_OFFS_V10	(RKISP1_CIF_ISP_BASE + 0x00000114)
#define RKISP1_CIF_ISP_AWB_WND_V_OFFS_V10	(RKISP1_CIF_ISP_BASE + 0x00000118)
#define RKISP1_CIF_ISP_AWB_WND_H_SIZE_V10	(RKISP1_CIF_ISP_BASE + 0x0000011C)
#define RKISP1_CIF_ISP_AWB_WND_V_SIZE_V10	(RKISP1_CIF_ISP_BASE + 0x00000120)
#define RKISP1_CIF_ISP_AWB_FRAMES_V10		(RKISP1_CIF_ISP_BASE + 0x00000124)
#define RKISP1_CIF_ISP_AWB_REF_V10		(RKISP1_CIF_ISP_BASE + 0x00000128)
#define RKISP1_CIF_ISP_AWB_THRESH_V10		(RKISP1_CIF_ISP_BASE + 0x0000012C)
#define RKISP1_CIF_ISP_AWB_GAIN_G_V10		(RKISP1_CIF_ISP_BASE + 0x00000138)
#define RKISP1_CIF_ISP_AWB_GAIN_RB_V10		(RKISP1_CIF_ISP_BASE + 0x0000013C)
#define RKISP1_CIF_ISP_AWB_WHITE_CNT_V10	(RKISP1_CIF_ISP_BASE + 0x00000140)
#define RKISP1_CIF_ISP_AWB_MEAN_V10		(RKISP1_CIF_ISP_BASE + 0x00000144)
#define RKISP1_CIF_ISP_AWB_PROP_V12		(RKISP1_CIF_ISP_BASE + 0x00000110)
#define RKISP1_CIF_ISP_AWB_SIZE_V12		(RKISP1_CIF_ISP_BASE + 0x00000114)
#define RKISP1_CIF_ISP_AWB_OFFS_V12		(RKISP1_CIF_ISP_BASE + 0x00000118)
#define RKISP1_CIF_ISP_AWB_REF_V12		(RKISP1_CIF_ISP_BASE + 0x0000011C)
#define RKISP1_CIF_ISP_AWB_THRESH_V12		(RKISP1_CIF_ISP_BASE + 0x00000120)
#define RKISP1_CIF_ISP_X_COOR12_V12		(RKISP1_CIF_ISP_BASE + 0x00000124)
#define RKISP1_CIF_ISP_X_COOR34_V12		(RKISP1_CIF_ISP_BASE + 0x00000128)
#define RKISP1_CIF_ISP_AWB_WHITE_CNT_V12	(RKISP1_CIF_ISP_BASE + 0x0000012C)
#define RKISP1_CIF_ISP_AWB_MEAN_V12		(RKISP1_CIF_ISP_BASE + 0x00000130)
#define RKISP1_CIF_ISP_DEGAIN_V12		(RKISP1_CIF_ISP_BASE + 0x00000134)
#define RKISP1_CIF_ISP_AWB_GAIN_G_V12		(RKISP1_CIF_ISP_BASE + 0x00000138)
#define RKISP1_CIF_ISP_AWB_GAIN_RB_V12		(RKISP1_CIF_ISP_BASE + 0x0000013C)
#define RKISP1_CIF_ISP_REGION_LINE_V12		(RKISP1_CIF_ISP_BASE + 0x00000140)
#define RKISP1_CIF_ISP_WP_CNT_REGION0_V12	(RKISP1_CIF_ISP_BASE + 0x00000160)
#define RKISP1_CIF_ISP_WP_CNT_REGION1_V12	(RKISP1_CIF_ISP_BASE + 0x00000164)
#define RKISP1_CIF_ISP_WP_CNT_REGION2_V12	(RKISP1_CIF_ISP_BASE + 0x00000168)
#define RKISP1_CIF_ISP_WP_CNT_REGION3_V12	(RKISP1_CIF_ISP_BASE + 0x0000016C)
#define RKISP1_CIF_ISP_CC_COEFF_0		(RKISP1_CIF_ISP_BASE + 0x00000170)
#define RKISP1_CIF_ISP_CC_COEFF_1		(RKISP1_CIF_ISP_BASE + 0x00000174)
#define RKISP1_CIF_ISP_CC_COEFF_2		(RKISP1_CIF_ISP_BASE + 0x00000178)
#define RKISP1_CIF_ISP_CC_COEFF_3		(RKISP1_CIF_ISP_BASE + 0x0000017C)
#define RKISP1_CIF_ISP_CC_COEFF_4		(RKISP1_CIF_ISP_BASE + 0x00000180)
#define RKISP1_CIF_ISP_CC_COEFF_5		(RKISP1_CIF_ISP_BASE + 0x00000184)
#define RKISP1_CIF_ISP_CC_COEFF_6		(RKISP1_CIF_ISP_BASE + 0x00000188)
#define RKISP1_CIF_ISP_CC_COEFF_7		(RKISP1_CIF_ISP_BASE + 0x0000018C)
#define RKISP1_CIF_ISP_CC_COEFF_8		(RKISP1_CIF_ISP_BASE + 0x00000190)
#define RKISP1_CIF_ISP_OUT_H_OFFS		(RKISP1_CIF_ISP_BASE + 0x00000194)
#define RKISP1_CIF_ISP_OUT_V_OFFS		(RKISP1_CIF_ISP_BASE + 0x00000198)
#define RKISP1_CIF_ISP_OUT_H_SIZE		(RKISP1_CIF_ISP_BASE + 0x0000019C)
#define RKISP1_CIF_ISP_OUT_V_SIZE		(RKISP1_CIF_ISP_BASE + 0x000001A0)
#define RKISP1_CIF_ISP_DEMOSAIC			(RKISP1_CIF_ISP_BASE + 0x000001A4)
#define RKISP1_CIF_ISP_FLAGS_SHD		(RKISP1_CIF_ISP_BASE + 0x000001A8)
#define RKISP1_CIF_ISP_OUT_H_OFFS_SHD		(RKISP1_CIF_ISP_BASE + 0x000001AC)
#define RKISP1_CIF_ISP_OUT_V_OFFS_SHD		(RKISP1_CIF_ISP_BASE + 0x000001B0)
#define RKISP1_CIF_ISP_OUT_H_SIZE_SHD		(RKISP1_CIF_ISP_BASE + 0x000001B4)
#define RKISP1_CIF_ISP_OUT_V_SIZE_SHD		(RKISP1_CIF_ISP_BASE + 0x000001B8)
#define RKISP1_CIF_ISP_IMSC			(RKISP1_CIF_ISP_BASE + 0x000001BC)
#define RKISP1_CIF_ISP_RIS			(RKISP1_CIF_ISP_BASE + 0x000001C0)
#define RKISP1_CIF_ISP_MIS			(RKISP1_CIF_ISP_BASE + 0x000001C4)
#define RKISP1_CIF_ISP_ICR			(RKISP1_CIF_ISP_BASE + 0x000001C8)
#define RKISP1_CIF_ISP_ISR			(RKISP1_CIF_ISP_BASE + 0x000001CC)
#define RKISP1_CIF_ISP_CT_COEFF_0		(RKISP1_CIF_ISP_BASE + 0x000001D0)
#define RKISP1_CIF_ISP_CT_COEFF_1		(RKISP1_CIF_ISP_BASE + 0x000001D4)
#define RKISP1_CIF_ISP_CT_COEFF_2		(RKISP1_CIF_ISP_BASE + 0x000001D8)
#define RKISP1_CIF_ISP_CT_COEFF_3		(RKISP1_CIF_ISP_BASE + 0x000001DC)
#define RKISP1_CIF_ISP_CT_COEFF_4		(RKISP1_CIF_ISP_BASE + 0x000001E0)
#define RKISP1_CIF_ISP_CT_COEFF_5		(RKISP1_CIF_ISP_BASE + 0x000001E4)
#define RKISP1_CIF_ISP_CT_COEFF_6		(RKISP1_CIF_ISP_BASE + 0x000001E8)
#define RKISP1_CIF_ISP_CT_COEFF_7		(RKISP1_CIF_ISP_BASE + 0x000001EC)
#define RKISP1_CIF_ISP_CT_COEFF_8		(RKISP1_CIF_ISP_BASE + 0x000001F0)
#define RKISP1_CIF_ISP_GAMMA_OUT_MODE_V10	(RKISP1_CIF_ISP_BASE + 0x000001F4)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_0_V10	(RKISP1_CIF_ISP_BASE + 0x000001F8)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_1_V10	(RKISP1_CIF_ISP_BASE + 0x000001FC)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_2_V10	(RKISP1_CIF_ISP_BASE + 0x00000200)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_3_V10	(RKISP1_CIF_ISP_BASE + 0x00000204)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_4_V10	(RKISP1_CIF_ISP_BASE + 0x00000208)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_5_V10	(RKISP1_CIF_ISP_BASE + 0x0000020C)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_6_V10	(RKISP1_CIF_ISP_BASE + 0x00000210)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_7_V10	(RKISP1_CIF_ISP_BASE + 0x00000214)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_8_V10	(RKISP1_CIF_ISP_BASE + 0x00000218)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_9_V10	(RKISP1_CIF_ISP_BASE + 0x0000021C)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_10_V10	(RKISP1_CIF_ISP_BASE + 0x00000220)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_11_V10	(RKISP1_CIF_ISP_BASE + 0x00000224)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_12_V10	(RKISP1_CIF_ISP_BASE + 0x00000228)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_13_V10	(RKISP1_CIF_ISP_BASE + 0x0000022C)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_14_V10	(RKISP1_CIF_ISP_BASE + 0x00000230)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_15_V10	(RKISP1_CIF_ISP_BASE + 0x00000234)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_16_V10	(RKISP1_CIF_ISP_BASE + 0x00000238)
#define RKISP1_CIF_ISP_ERR			(RKISP1_CIF_ISP_BASE + 0x0000023C)
#define RKISP1_CIF_ISP_ERR_CLR			(RKISP1_CIF_ISP_BASE + 0x00000240)
#define RKISP1_CIF_ISP_FRAME_COUNT		(RKISP1_CIF_ISP_BASE + 0x00000244)
#define RKISP1_CIF_ISP_CT_OFFSET_R		(RKISP1_CIF_ISP_BASE + 0x00000248)
#define RKISP1_CIF_ISP_CT_OFFSET_G		(RKISP1_CIF_ISP_BASE + 0x0000024C)
#define RKISP1_CIF_ISP_CT_OFFSET_B		(RKISP1_CIF_ISP_BASE + 0x00000250)
#define RKISP1_CIF_ISP_GAMMA_OUT_MODE_V12	(RKISP1_CIF_ISP_BASE + 0x00000300)
#define RKISP1_CIF_ISP_GAMMA_OUT_Y_0_V12	(RKISP1_CIF_ISP_BASE + 0x00000304)

#define RKISP1_CIF_ISP_FLASH_BASE		0x00000660
#define RKISP1_CIF_ISP_FLASH_CMD		(RKISP1_CIF_ISP_FLASH_BASE + 0x00000000)
#define RKISP1_CIF_ISP_FLASH_CONFIG		(RKISP1_CIF_ISP_FLASH_BASE + 0x00000004)
#define RKISP1_CIF_ISP_FLASH_PREDIV		(RKISP1_CIF_ISP_FLASH_BASE + 0x00000008)
#define RKISP1_CIF_ISP_FLASH_DELAY		(RKISP1_CIF_ISP_FLASH_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_FLASH_TIME		(RKISP1_CIF_ISP_FLASH_BASE + 0x00000010)
#define RKISP1_CIF_ISP_FLASH_MAXP		(RKISP1_CIF_ISP_FLASH_BASE + 0x00000014)

#define RKISP1_CIF_ISP_SH_BASE			0x00000680
#define RKISP1_CIF_ISP_SH_CTRL			(RKISP1_CIF_ISP_SH_BASE + 0x00000000)
#define RKISP1_CIF_ISP_SH_PREDIV		(RKISP1_CIF_ISP_SH_BASE + 0x00000004)
#define RKISP1_CIF_ISP_SH_DELAY			(RKISP1_CIF_ISP_SH_BASE + 0x00000008)
#define RKISP1_CIF_ISP_SH_TIME			(RKISP1_CIF_ISP_SH_BASE + 0x0000000C)

#define RKISP1_CIF_C_PROC_BASE			0x00000800
#define RKISP1_CIF_C_PROC_CTRL			(RKISP1_CIF_C_PROC_BASE + 0x00000000)
#define RKISP1_CIF_C_PROC_CONTRAST		(RKISP1_CIF_C_PROC_BASE + 0x00000004)
#define RKISP1_CIF_C_PROC_BRIGHTNESS		(RKISP1_CIF_C_PROC_BASE + 0x00000008)
#define RKISP1_CIF_C_PROC_SATURATION		(RKISP1_CIF_C_PROC_BASE + 0x0000000C)
#define RKISP1_CIF_C_PROC_HUE			(RKISP1_CIF_C_PROC_BASE + 0x00000010)

#define RKISP1_CIF_DUAL_CROP_BASE		0x00000880
#define RKISP1_CIF_DUAL_CROP_CTRL		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000000)
#define RKISP1_CIF_DUAL_CROP_M_H_OFFS		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000004)
#define RKISP1_CIF_DUAL_CROP_M_V_OFFS		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000008)
#define RKISP1_CIF_DUAL_CROP_M_H_SIZE		(RKISP1_CIF_DUAL_CROP_BASE + 0x0000000C)
#define RKISP1_CIF_DUAL_CROP_M_V_SIZE		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000010)
#define RKISP1_CIF_DUAL_CROP_S_H_OFFS		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000014)
#define RKISP1_CIF_DUAL_CROP_S_V_OFFS		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000018)
#define RKISP1_CIF_DUAL_CROP_S_H_SIZE		(RKISP1_CIF_DUAL_CROP_BASE + 0x0000001C)
#define RKISP1_CIF_DUAL_CROP_S_V_SIZE		(RKISP1_CIF_DUAL_CROP_BASE + 0x00000020)
#define RKISP1_CIF_DUAL_CROP_M_H_OFFS_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000024)
#define RKISP1_CIF_DUAL_CROP_M_V_OFFS_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000028)
#define RKISP1_CIF_DUAL_CROP_M_H_SIZE_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x0000002C)
#define RKISP1_CIF_DUAL_CROP_M_V_SIZE_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000030)
#define RKISP1_CIF_DUAL_CROP_S_H_OFFS_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000034)
#define RKISP1_CIF_DUAL_CROP_S_V_OFFS_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000038)
#define RKISP1_CIF_DUAL_CROP_S_H_SIZE_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x0000003C)
#define RKISP1_CIF_DUAL_CROP_S_V_SIZE_SHD	(RKISP1_CIF_DUAL_CROP_BASE + 0x00000040)

#define RKISP1_CIF_MRSZ_BASE			0x00000C00
#define RKISP1_CIF_MRSZ_CTRL			(RKISP1_CIF_MRSZ_BASE + 0x00000000)
#define RKISP1_CIF_MRSZ_SCALE_HY		(RKISP1_CIF_MRSZ_BASE + 0x00000004)
#define RKISP1_CIF_MRSZ_SCALE_HCB		(RKISP1_CIF_MRSZ_BASE + 0x00000008)
#define RKISP1_CIF_MRSZ_SCALE_HCR		(RKISP1_CIF_MRSZ_BASE + 0x0000000C)
#define RKISP1_CIF_MRSZ_SCALE_VY		(RKISP1_CIF_MRSZ_BASE + 0x00000010)
#define RKISP1_CIF_MRSZ_SCALE_VC		(RKISP1_CIF_MRSZ_BASE + 0x00000014)
#define RKISP1_CIF_MRSZ_PHASE_HY		(RKISP1_CIF_MRSZ_BASE + 0x00000018)
#define RKISP1_CIF_MRSZ_PHASE_HC		(RKISP1_CIF_MRSZ_BASE + 0x0000001C)
#define RKISP1_CIF_MRSZ_PHASE_VY		(RKISP1_CIF_MRSZ_BASE + 0x00000020)
#define RKISP1_CIF_MRSZ_PHASE_VC		(RKISP1_CIF_MRSZ_BASE + 0x00000024)
#define RKISP1_CIF_MRSZ_SCALE_LUT_ADDR		(RKISP1_CIF_MRSZ_BASE + 0x00000028)
#define RKISP1_CIF_MRSZ_SCALE_LUT		(RKISP1_CIF_MRSZ_BASE + 0x0000002C)
#define RKISP1_CIF_MRSZ_CTRL_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000030)
#define RKISP1_CIF_MRSZ_SCALE_HY_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000034)
#define RKISP1_CIF_MRSZ_SCALE_HCB_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000038)
#define RKISP1_CIF_MRSZ_SCALE_HCR_SHD		(RKISP1_CIF_MRSZ_BASE + 0x0000003C)
#define RKISP1_CIF_MRSZ_SCALE_VY_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000040)
#define RKISP1_CIF_MRSZ_SCALE_VC_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000044)
#define RKISP1_CIF_MRSZ_PHASE_HY_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000048)
#define RKISP1_CIF_MRSZ_PHASE_HC_SHD		(RKISP1_CIF_MRSZ_BASE + 0x0000004C)
#define RKISP1_CIF_MRSZ_PHASE_VY_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000050)
#define RKISP1_CIF_MRSZ_PHASE_VC_SHD		(RKISP1_CIF_MRSZ_BASE + 0x00000054)

#define RKISP1_CIF_SRSZ_BASE			0x00001000
#define RKISP1_CIF_SRSZ_CTRL			(RKISP1_CIF_SRSZ_BASE + 0x00000000)
#define RKISP1_CIF_SRSZ_SCALE_HY		(RKISP1_CIF_SRSZ_BASE + 0x00000004)
#define RKISP1_CIF_SRSZ_SCALE_HCB		(RKISP1_CIF_SRSZ_BASE + 0x00000008)
#define RKISP1_CIF_SRSZ_SCALE_HCR		(RKISP1_CIF_SRSZ_BASE + 0x0000000C)
#define RKISP1_CIF_SRSZ_SCALE_VY		(RKISP1_CIF_SRSZ_BASE + 0x00000010)
#define RKISP1_CIF_SRSZ_SCALE_VC		(RKISP1_CIF_SRSZ_BASE + 0x00000014)
#define RKISP1_CIF_SRSZ_PHASE_HY		(RKISP1_CIF_SRSZ_BASE + 0x00000018)
#define RKISP1_CIF_SRSZ_PHASE_HC		(RKISP1_CIF_SRSZ_BASE + 0x0000001C)
#define RKISP1_CIF_SRSZ_PHASE_VY		(RKISP1_CIF_SRSZ_BASE + 0x00000020)
#define RKISP1_CIF_SRSZ_PHASE_VC		(RKISP1_CIF_SRSZ_BASE + 0x00000024)
#define RKISP1_CIF_SRSZ_SCALE_LUT_ADDR		(RKISP1_CIF_SRSZ_BASE + 0x00000028)
#define RKISP1_CIF_SRSZ_SCALE_LUT		(RKISP1_CIF_SRSZ_BASE + 0x0000002C)
#define RKISP1_CIF_SRSZ_CTRL_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000030)
#define RKISP1_CIF_SRSZ_SCALE_HY_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000034)
#define RKISP1_CIF_SRSZ_SCALE_HCB_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000038)
#define RKISP1_CIF_SRSZ_SCALE_HCR_SHD		(RKISP1_CIF_SRSZ_BASE + 0x0000003C)
#define RKISP1_CIF_SRSZ_SCALE_VY_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000040)
#define RKISP1_CIF_SRSZ_SCALE_VC_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000044)
#define RKISP1_CIF_SRSZ_PHASE_HY_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000048)
#define RKISP1_CIF_SRSZ_PHASE_HC_SHD		(RKISP1_CIF_SRSZ_BASE + 0x0000004C)
#define RKISP1_CIF_SRSZ_PHASE_VY_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000050)
#define RKISP1_CIF_SRSZ_PHASE_VC_SHD		(RKISP1_CIF_SRSZ_BASE + 0x00000054)

#define RKISP1_CIF_MI_BASE			0x00001400
#define RKISP1_CIF_MI_CTRL			(RKISP1_CIF_MI_BASE + 0x00000000)
#define RKISP1_CIF_MI_INIT			(RKISP1_CIF_MI_BASE + 0x00000004)
#define RKISP1_CIF_MI_MP_Y_BASE_AD_INIT		(RKISP1_CIF_MI_BASE + 0x00000008)
#define RKISP1_CIF_MI_MP_Y_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x0000000C)
#define RKISP1_CIF_MI_MP_Y_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000010)
#define RKISP1_CIF_MI_MP_Y_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x00000014)
#define RKISP1_CIF_MI_MP_Y_IRQ_OFFS_INIT	(RKISP1_CIF_MI_BASE + 0x00000018)
#define RKISP1_CIF_MI_MP_CB_BASE_AD_INIT	(RKISP1_CIF_MI_BASE + 0x0000001C)
#define RKISP1_CIF_MI_MP_CB_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x00000020)
#define RKISP1_CIF_MI_MP_CB_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000024)
#define RKISP1_CIF_MI_MP_CB_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x00000028)
#define RKISP1_CIF_MI_MP_CR_BASE_AD_INIT	(RKISP1_CIF_MI_BASE + 0x0000002C)
#define RKISP1_CIF_MI_MP_CR_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x00000030)
#define RKISP1_CIF_MI_MP_CR_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000034)
#define RKISP1_CIF_MI_MP_CR_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x00000038)
#define RKISP1_CIF_MI_SP_Y_BASE_AD_INIT		(RKISP1_CIF_MI_BASE + 0x0000003C)
#define RKISP1_CIF_MI_SP_Y_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x00000040)
#define RKISP1_CIF_MI_SP_Y_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000044)
#define RKISP1_CIF_MI_SP_Y_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x00000048)
#define RKISP1_CIF_MI_SP_Y_LLENGTH		(RKISP1_CIF_MI_BASE + 0x0000004C)
#define RKISP1_CIF_MI_SP_CB_BASE_AD_INIT	(RKISP1_CIF_MI_BASE + 0x00000050)
#define RKISP1_CIF_MI_SP_CB_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x00000054)
#define RKISP1_CIF_MI_SP_CB_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000058)
#define RKISP1_CIF_MI_SP_CB_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x0000005C)
#define RKISP1_CIF_MI_SP_CR_BASE_AD_INIT	(RKISP1_CIF_MI_BASE + 0x00000060)
#define RKISP1_CIF_MI_SP_CR_SIZE_INIT		(RKISP1_CIF_MI_BASE + 0x00000064)
#define RKISP1_CIF_MI_SP_CR_OFFS_CNT_INIT	(RKISP1_CIF_MI_BASE + 0x00000068)
#define RKISP1_CIF_MI_SP_CR_OFFS_CNT_START	(RKISP1_CIF_MI_BASE + 0x0000006C)
#define RKISP1_CIF_MI_BYTE_CNT			(RKISP1_CIF_MI_BASE + 0x00000070)
#define RKISP1_CIF_MI_CTRL_SHD			(RKISP1_CIF_MI_BASE + 0x00000074)
#define RKISP1_CIF_MI_MP_Y_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x00000078)
#define RKISP1_CIF_MI_MP_Y_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x0000007C)
#define RKISP1_CIF_MI_MP_Y_OFFS_CNT_SHD		(RKISP1_CIF_MI_BASE + 0x00000080)
#define RKISP1_CIF_MI_MP_Y_IRQ_OFFS_SHD		(RKISP1_CIF_MI_BASE + 0x00000084)
#define RKISP1_CIF_MI_MP_CB_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x00000088)
#define RKISP1_CIF_MI_MP_CB_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x0000008C)
#define RKISP1_CIF_MI_MP_CB_OFFS_CNT_SHD	(RKISP1_CIF_MI_BASE + 0x00000090)
#define RKISP1_CIF_MI_MP_CR_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x00000094)
#define RKISP1_CIF_MI_MP_CR_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x00000098)
#define RKISP1_CIF_MI_MP_CR_OFFS_CNT_SHD	(RKISP1_CIF_MI_BASE + 0x0000009C)
#define RKISP1_CIF_MI_SP_Y_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x000000A0)
#define RKISP1_CIF_MI_SP_Y_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x000000A4)
#define RKISP1_CIF_MI_SP_Y_OFFS_CNT_SHD		(RKISP1_CIF_MI_BASE + 0x000000A8)
#define RKISP1_CIF_MI_SP_CB_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x000000B0)
#define RKISP1_CIF_MI_SP_CB_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x000000B4)
#define RKISP1_CIF_MI_SP_CB_OFFS_CNT_SHD	(RKISP1_CIF_MI_BASE + 0x000000B8)
#define RKISP1_CIF_MI_SP_CR_BASE_AD_SHD		(RKISP1_CIF_MI_BASE + 0x000000BC)
#define RKISP1_CIF_MI_SP_CR_SIZE_SHD		(RKISP1_CIF_MI_BASE + 0x000000C0)
#define RKISP1_CIF_MI_SP_CR_OFFS_CNT_SHD	(RKISP1_CIF_MI_BASE + 0x000000C4)
#define RKISP1_CIF_MI_DMA_Y_PIC_START_AD	(RKISP1_CIF_MI_BASE + 0x000000C8)
#define RKISP1_CIF_MI_DMA_Y_PIC_WIDTH		(RKISP1_CIF_MI_BASE + 0x000000CC)
#define RKISP1_CIF_MI_DMA_Y_LLENGTH		(RKISP1_CIF_MI_BASE + 0x000000D0)
#define RKISP1_CIF_MI_DMA_Y_PIC_SIZE		(RKISP1_CIF_MI_BASE + 0x000000D4)
#define RKISP1_CIF_MI_DMA_CB_PIC_START_AD	(RKISP1_CIF_MI_BASE + 0x000000D8)
#define RKISP1_CIF_MI_DMA_CR_PIC_START_AD	(RKISP1_CIF_MI_BASE + 0x000000E8)
#define RKISP1_CIF_MI_IMSC			(RKISP1_CIF_MI_BASE + 0x000000F8)
#define RKISP1_CIF_MI_RIS			(RKISP1_CIF_MI_BASE + 0x000000FC)
#define RKISP1_CIF_MI_MIS			(RKISP1_CIF_MI_BASE + 0x00000100)
#define RKISP1_CIF_MI_ICR			(RKISP1_CIF_MI_BASE + 0x00000104)
#define RKISP1_CIF_MI_ISR			(RKISP1_CIF_MI_BASE + 0x00000108)
#define RKISP1_CIF_MI_STATUS			(RKISP1_CIF_MI_BASE + 0x0000010C)
#define RKISP1_CIF_MI_STATUS_CLR		(RKISP1_CIF_MI_BASE + 0x00000110)
#define RKISP1_CIF_MI_SP_Y_PIC_WIDTH		(RKISP1_CIF_MI_BASE + 0x00000114)
#define RKISP1_CIF_MI_SP_Y_PIC_HEIGHT		(RKISP1_CIF_MI_BASE + 0x00000118)
#define RKISP1_CIF_MI_SP_Y_PIC_SIZE		(RKISP1_CIF_MI_BASE + 0x0000011C)
#define RKISP1_CIF_MI_DMA_CTRL			(RKISP1_CIF_MI_BASE + 0x00000120)
#define RKISP1_CIF_MI_DMA_START			(RKISP1_CIF_MI_BASE + 0x00000124)
#define RKISP1_CIF_MI_DMA_STATUS		(RKISP1_CIF_MI_BASE + 0x00000128)
#define RKISP1_CIF_MI_PIXEL_COUNT		(RKISP1_CIF_MI_BASE + 0x0000012C)
#define RKISP1_CIF_MI_MP_Y_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x00000130)
#define RKISP1_CIF_MI_MP_CB_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x00000134)
#define RKISP1_CIF_MI_MP_CR_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x00000138)
#define RKISP1_CIF_MI_SP_Y_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x0000013C)
#define RKISP1_CIF_MI_SP_CB_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x00000140)
#define RKISP1_CIF_MI_SP_CR_BASE_AD_INIT2	(RKISP1_CIF_MI_BASE + 0x00000144)
#define RKISP1_CIF_MI_XTD_FORMAT_CTRL		(RKISP1_CIF_MI_BASE + 0x00000148)

#define RKISP1_CIF_SMIA_BASE			0x00001A00
#define RKISP1_CIF_SMIA_CTRL			(RKISP1_CIF_SMIA_BASE + 0x00000000)
#define RKISP1_CIF_SMIA_STATUS			(RKISP1_CIF_SMIA_BASE + 0x00000004)
#define RKISP1_CIF_SMIA_IMSC			(RKISP1_CIF_SMIA_BASE + 0x00000008)
#define RKISP1_CIF_SMIA_RIS			(RKISP1_CIF_SMIA_BASE + 0x0000000C)
#define RKISP1_CIF_SMIA_MIS			(RKISP1_CIF_SMIA_BASE + 0x00000010)
#define RKISP1_CIF_SMIA_ICR			(RKISP1_CIF_SMIA_BASE + 0x00000014)
#define RKISP1_CIF_SMIA_ISR			(RKISP1_CIF_SMIA_BASE + 0x00000018)
#define RKISP1_CIF_SMIA_DATA_FORMAT_SEL		(RKISP1_CIF_SMIA_BASE + 0x0000001C)
#define RKISP1_CIF_SMIA_SOF_EMB_DATA_LINES	(RKISP1_CIF_SMIA_BASE + 0x00000020)
#define RKISP1_CIF_SMIA_EMB_HSTART		(RKISP1_CIF_SMIA_BASE + 0x00000024)
#define RKISP1_CIF_SMIA_EMB_HSIZE		(RKISP1_CIF_SMIA_BASE + 0x00000028)
#define RKISP1_CIF_SMIA_EMB_VSTART		(RKISP1_CIF_SMIA_BASE + 0x0000002c)
#define RKISP1_CIF_SMIA_NUM_LINES		(RKISP1_CIF_SMIA_BASE + 0x00000030)
#define RKISP1_CIF_SMIA_EMB_DATA_FIFO		(RKISP1_CIF_SMIA_BASE + 0x00000034)
#define RKISP1_CIF_SMIA_EMB_DATA_WATERMARK	(RKISP1_CIF_SMIA_BASE + 0x00000038)

#define RKISP1_CIF_MIPI_BASE			0x00001C00
#define RKISP1_CIF_MIPI_CTRL			(RKISP1_CIF_MIPI_BASE + 0x00000000)
#define RKISP1_CIF_MIPI_STATUS			(RKISP1_CIF_MIPI_BASE + 0x00000004)
#define RKISP1_CIF_MIPI_IMSC			(RKISP1_CIF_MIPI_BASE + 0x00000008)
#define RKISP1_CIF_MIPI_RIS			(RKISP1_CIF_MIPI_BASE + 0x0000000C)
#define RKISP1_CIF_MIPI_MIS			(RKISP1_CIF_MIPI_BASE + 0x00000010)
#define RKISP1_CIF_MIPI_ICR			(RKISP1_CIF_MIPI_BASE + 0x00000014)
#define RKISP1_CIF_MIPI_ISR			(RKISP1_CIF_MIPI_BASE + 0x00000018)
#define RKISP1_CIF_MIPI_CUR_DATA_ID		(RKISP1_CIF_MIPI_BASE + 0x0000001C)
#define RKISP1_CIF_MIPI_IMG_DATA_SEL		(RKISP1_CIF_MIPI_BASE + 0x00000020)
#define RKISP1_CIF_MIPI_ADD_DATA_SEL_1		(RKISP1_CIF_MIPI_BASE + 0x00000024)
#define RKISP1_CIF_MIPI_ADD_DATA_SEL_2		(RKISP1_CIF_MIPI_BASE + 0x00000028)
#define RKISP1_CIF_MIPI_ADD_DATA_SEL_3		(RKISP1_CIF_MIPI_BASE + 0x0000002C)
#define RKISP1_CIF_MIPI_ADD_DATA_SEL_4		(RKISP1_CIF_MIPI_BASE + 0x00000030)
#define RKISP1_CIF_MIPI_ADD_DATA_FIFO		(RKISP1_CIF_MIPI_BASE + 0x00000034)
#define RKISP1_CIF_MIPI_FIFO_FILL_LEVEL		(RKISP1_CIF_MIPI_BASE + 0x00000038)
#define RKISP1_CIF_MIPI_COMPRESSED_MODE		(RKISP1_CIF_MIPI_BASE + 0x0000003C)
#define RKISP1_CIF_MIPI_FRAME			(RKISP1_CIF_MIPI_BASE + 0x00000040)
#define RKISP1_CIF_MIPI_GEN_SHORT_DT		(RKISP1_CIF_MIPI_BASE + 0x00000044)
#define RKISP1_CIF_MIPI_GEN_SHORT_8_9		(RKISP1_CIF_MIPI_BASE + 0x00000048)
#define RKISP1_CIF_MIPI_GEN_SHORT_A_B		(RKISP1_CIF_MIPI_BASE + 0x0000004C)
#define RKISP1_CIF_MIPI_GEN_SHORT_C_D		(RKISP1_CIF_MIPI_BASE + 0x00000050)
#define RKISP1_CIF_MIPI_GEN_SHORT_E_F		(RKISP1_CIF_MIPI_BASE + 0x00000054)

#define RKISP1_CIF_ISP_AFM_BASE			0x00002000
#define RKISP1_CIF_ISP_AFM_CTRL			(RKISP1_CIF_ISP_AFM_BASE + 0x00000000)
#define RKISP1_CIF_ISP_AFM_LT_A			(RKISP1_CIF_ISP_AFM_BASE + 0x00000004)
#define RKISP1_CIF_ISP_AFM_RB_A			(RKISP1_CIF_ISP_AFM_BASE + 0x00000008)
#define RKISP1_CIF_ISP_AFM_LT_B			(RKISP1_CIF_ISP_AFM_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_AFM_RB_B			(RKISP1_CIF_ISP_AFM_BASE + 0x00000010)
#define RKISP1_CIF_ISP_AFM_LT_C			(RKISP1_CIF_ISP_AFM_BASE + 0x00000014)
#define RKISP1_CIF_ISP_AFM_RB_C			(RKISP1_CIF_ISP_AFM_BASE + 0x00000018)
#define RKISP1_CIF_ISP_AFM_THRES		(RKISP1_CIF_ISP_AFM_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_AFM_VAR_SHIFT		(RKISP1_CIF_ISP_AFM_BASE + 0x00000020)
#define RKISP1_CIF_ISP_AFM_SUM_A		(RKISP1_CIF_ISP_AFM_BASE + 0x00000024)
#define RKISP1_CIF_ISP_AFM_SUM_B		(RKISP1_CIF_ISP_AFM_BASE + 0x00000028)
#define RKISP1_CIF_ISP_AFM_SUM_C		(RKISP1_CIF_ISP_AFM_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_AFM_LUM_A		(RKISP1_CIF_ISP_AFM_BASE + 0x00000030)
#define RKISP1_CIF_ISP_AFM_LUM_B		(RKISP1_CIF_ISP_AFM_BASE + 0x00000034)
#define RKISP1_CIF_ISP_AFM_LUM_C		(RKISP1_CIF_ISP_AFM_BASE + 0x00000038)

#define RKISP1_CIF_ISP_LSC_BASE			0x00002200
#define RKISP1_CIF_ISP_LSC_CTRL			(RKISP1_CIF_ISP_LSC_BASE + 0x00000000)
#define RKISP1_CIF_ISP_LSC_R_TABLE_ADDR		(RKISP1_CIF_ISP_LSC_BASE + 0x00000004)
#define RKISP1_CIF_ISP_LSC_GR_TABLE_ADDR	(RKISP1_CIF_ISP_LSC_BASE + 0x00000008)
#define RKISP1_CIF_ISP_LSC_B_TABLE_ADDR		(RKISP1_CIF_ISP_LSC_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_LSC_GB_TABLE_ADDR	(RKISP1_CIF_ISP_LSC_BASE + 0x00000010)
#define RKISP1_CIF_ISP_LSC_R_TABLE_DATA		(RKISP1_CIF_ISP_LSC_BASE + 0x00000014)
#define RKISP1_CIF_ISP_LSC_GR_TABLE_DATA	(RKISP1_CIF_ISP_LSC_BASE + 0x00000018)
#define RKISP1_CIF_ISP_LSC_B_TABLE_DATA		(RKISP1_CIF_ISP_LSC_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_LSC_GB_TABLE_DATA	(RKISP1_CIF_ISP_LSC_BASE + 0x00000020)
#define RKISP1_CIF_ISP_LSC_XGRAD_01		(RKISP1_CIF_ISP_LSC_BASE + 0x00000024)
#define RKISP1_CIF_ISP_LSC_XGRAD_23		(RKISP1_CIF_ISP_LSC_BASE + 0x00000028)
#define RKISP1_CIF_ISP_LSC_XGRAD_45		(RKISP1_CIF_ISP_LSC_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_LSC_XGRAD_67		(RKISP1_CIF_ISP_LSC_BASE + 0x00000030)
#define RKISP1_CIF_ISP_LSC_YGRAD_01		(RKISP1_CIF_ISP_LSC_BASE + 0x00000034)
#define RKISP1_CIF_ISP_LSC_YGRAD_23		(RKISP1_CIF_ISP_LSC_BASE + 0x00000038)
#define RKISP1_CIF_ISP_LSC_YGRAD_45		(RKISP1_CIF_ISP_LSC_BASE + 0x0000003C)
#define RKISP1_CIF_ISP_LSC_YGRAD_67		(RKISP1_CIF_ISP_LSC_BASE + 0x00000040)
#define RKISP1_CIF_ISP_LSC_XSIZE_01		(RKISP1_CIF_ISP_LSC_BASE + 0x00000044)
#define RKISP1_CIF_ISP_LSC_XSIZE_23		(RKISP1_CIF_ISP_LSC_BASE + 0x00000048)
#define RKISP1_CIF_ISP_LSC_XSIZE_45		(RKISP1_CIF_ISP_LSC_BASE + 0x0000004C)
#define RKISP1_CIF_ISP_LSC_XSIZE_67		(RKISP1_CIF_ISP_LSC_BASE + 0x00000050)
#define RKISP1_CIF_ISP_LSC_YSIZE_01		(RKISP1_CIF_ISP_LSC_BASE + 0x00000054)
#define RKISP1_CIF_ISP_LSC_YSIZE_23		(RKISP1_CIF_ISP_LSC_BASE + 0x00000058)
#define RKISP1_CIF_ISP_LSC_YSIZE_45		(RKISP1_CIF_ISP_LSC_BASE + 0x0000005C)
#define RKISP1_CIF_ISP_LSC_YSIZE_67		(RKISP1_CIF_ISP_LSC_BASE + 0x00000060)
#define RKISP1_CIF_ISP_LSC_TABLE_SEL		(RKISP1_CIF_ISP_LSC_BASE + 0x00000064)
#define RKISP1_CIF_ISP_LSC_STATUS		(RKISP1_CIF_ISP_LSC_BASE + 0x00000068)

#define RKISP1_CIF_ISP_IS_BASE			0x00002300
#define RKISP1_CIF_ISP_IS_CTRL			(RKISP1_CIF_ISP_IS_BASE + 0x00000000)
#define RKISP1_CIF_ISP_IS_RECENTER		(RKISP1_CIF_ISP_IS_BASE + 0x00000004)
#define RKISP1_CIF_ISP_IS_H_OFFS		(RKISP1_CIF_ISP_IS_BASE + 0x00000008)
#define RKISP1_CIF_ISP_IS_V_OFFS		(RKISP1_CIF_ISP_IS_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_IS_H_SIZE		(RKISP1_CIF_ISP_IS_BASE + 0x00000010)
#define RKISP1_CIF_ISP_IS_V_SIZE		(RKISP1_CIF_ISP_IS_BASE + 0x00000014)
#define RKISP1_CIF_ISP_IS_MAX_DX		(RKISP1_CIF_ISP_IS_BASE + 0x00000018)
#define RKISP1_CIF_ISP_IS_MAX_DY		(RKISP1_CIF_ISP_IS_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_IS_DISPLACE		(RKISP1_CIF_ISP_IS_BASE + 0x00000020)
#define RKISP1_CIF_ISP_IS_H_OFFS_SHD		(RKISP1_CIF_ISP_IS_BASE + 0x00000024)
#define RKISP1_CIF_ISP_IS_V_OFFS_SHD		(RKISP1_CIF_ISP_IS_BASE + 0x00000028)
#define RKISP1_CIF_ISP_IS_H_SIZE_SHD		(RKISP1_CIF_ISP_IS_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_IS_V_SIZE_SHD		(RKISP1_CIF_ISP_IS_BASE + 0x00000030)

#define RKISP1_CIF_ISP_HIST_BASE_V10		0x00002400
#define RKISP1_CIF_ISP_HIST_PROP_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000000)
#define RKISP1_CIF_ISP_HIST_H_OFFS_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000004)
#define RKISP1_CIF_ISP_HIST_V_OFFS_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000008)
#define RKISP1_CIF_ISP_HIST_H_SIZE_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000000C)
#define RKISP1_CIF_ISP_HIST_V_SIZE_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000010)
#define RKISP1_CIF_ISP_HIST_BIN_0_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000014)
#define RKISP1_CIF_ISP_HIST_BIN_1_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000018)
#define RKISP1_CIF_ISP_HIST_BIN_2_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000001C)
#define RKISP1_CIF_ISP_HIST_BIN_3_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000020)
#define RKISP1_CIF_ISP_HIST_BIN_4_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000024)
#define RKISP1_CIF_ISP_HIST_BIN_5_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000028)
#define RKISP1_CIF_ISP_HIST_BIN_6_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000002C)
#define RKISP1_CIF_ISP_HIST_BIN_7_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000030)
#define RKISP1_CIF_ISP_HIST_BIN_8_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000034)
#define RKISP1_CIF_ISP_HIST_BIN_9_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000038)
#define RKISP1_CIF_ISP_HIST_BIN_10_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000003C)
#define RKISP1_CIF_ISP_HIST_BIN_11_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000040)
#define RKISP1_CIF_ISP_HIST_BIN_12_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000044)
#define RKISP1_CIF_ISP_HIST_BIN_13_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000048)
#define RKISP1_CIF_ISP_HIST_BIN_14_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000004C)
#define RKISP1_CIF_ISP_HIST_BIN_15_V10		(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000050)
#define RKISP1_CIF_ISP_HIST_WEIGHT_00TO30_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000054)
#define RKISP1_CIF_ISP_HIST_WEIGHT_40TO21_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000058)
#define RKISP1_CIF_ISP_HIST_WEIGHT_31TO12_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000005C)
#define RKISP1_CIF_ISP_HIST_WEIGHT_22TO03_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000060)
#define RKISP1_CIF_ISP_HIST_WEIGHT_13TO43_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000064)
#define RKISP1_CIF_ISP_HIST_WEIGHT_04TO34_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x00000068)
#define RKISP1_CIF_ISP_HIST_WEIGHT_44_V10	(RKISP1_CIF_ISP_HIST_BASE_V10 + 0x0000006C)

#define RKISP1_CIF_ISP_FILT_BASE		0x00002500
#define RKISP1_CIF_ISP_FILT_MODE		(RKISP1_CIF_ISP_FILT_BASE + 0x00000000)
#define RKISP1_CIF_ISP_FILT_THRESH_BL0		(RKISP1_CIF_ISP_FILT_BASE + 0x00000028)
#define RKISP1_CIF_ISP_FILT_THRESH_BL1		(RKISP1_CIF_ISP_FILT_BASE + 0x0000002c)
#define RKISP1_CIF_ISP_FILT_THRESH_SH0		(RKISP1_CIF_ISP_FILT_BASE + 0x00000030)
#define RKISP1_CIF_ISP_FILT_THRESH_SH1		(RKISP1_CIF_ISP_FILT_BASE + 0x00000034)
#define RKISP1_CIF_ISP_FILT_LUM_WEIGHT		(RKISP1_CIF_ISP_FILT_BASE + 0x00000038)
#define RKISP1_CIF_ISP_FILT_FAC_SH1		(RKISP1_CIF_ISP_FILT_BASE + 0x0000003c)
#define RKISP1_CIF_ISP_FILT_FAC_SH0		(RKISP1_CIF_ISP_FILT_BASE + 0x00000040)
#define RKISP1_CIF_ISP_FILT_FAC_MID		(RKISP1_CIF_ISP_FILT_BASE + 0x00000044)
#define RKISP1_CIF_ISP_FILT_FAC_BL0		(RKISP1_CIF_ISP_FILT_BASE + 0x00000048)
#define RKISP1_CIF_ISP_FILT_FAC_BL1		(RKISP1_CIF_ISP_FILT_BASE + 0x0000004C)

#define RKISP1_CIF_ISP_CAC_BASE			0x00002580
#define RKISP1_CIF_ISP_CAC_CTRL			(RKISP1_CIF_ISP_CAC_BASE + 0x00000000)
#define RKISP1_CIF_ISP_CAC_COUNT_START		(RKISP1_CIF_ISP_CAC_BASE + 0x00000004)
#define RKISP1_CIF_ISP_CAC_A			(RKISP1_CIF_ISP_CAC_BASE + 0x00000008)
#define RKISP1_CIF_ISP_CAC_B			(RKISP1_CIF_ISP_CAC_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_CAC_C			(RKISP1_CIF_ISP_CAC_BASE + 0x00000010)
#define RKISP1_CIF_ISP_X_NORM			(RKISP1_CIF_ISP_CAC_BASE + 0x00000014)
#define RKISP1_CIF_ISP_Y_NORM			(RKISP1_CIF_ISP_CAC_BASE + 0x00000018)

#define RKISP1_CIF_ISP_EXP_BASE			0x00002600
#define RKISP1_CIF_ISP_EXP_CTRL			(RKISP1_CIF_ISP_EXP_BASE + 0x00000000)
#define RKISP1_CIF_ISP_EXP_H_OFFSET_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000004)
#define RKISP1_CIF_ISP_EXP_V_OFFSET_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000008)
#define RKISP1_CIF_ISP_EXP_H_SIZE_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_EXP_V_SIZE_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000010)
#define RKISP1_CIF_ISP_EXP_MEAN_00_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000014)
#define RKISP1_CIF_ISP_EXP_MEAN_10_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000018)
#define RKISP1_CIF_ISP_EXP_MEAN_20_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000001c)
#define RKISP1_CIF_ISP_EXP_MEAN_30_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000020)
#define RKISP1_CIF_ISP_EXP_MEAN_40_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000024)
#define RKISP1_CIF_ISP_EXP_MEAN_01_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000028)
#define RKISP1_CIF_ISP_EXP_MEAN_11_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000002c)
#define RKISP1_CIF_ISP_EXP_MEAN_21_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000030)
#define RKISP1_CIF_ISP_EXP_MEAN_31_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000034)
#define RKISP1_CIF_ISP_EXP_MEAN_41_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000038)
#define RKISP1_CIF_ISP_EXP_MEAN_02_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000003c)
#define RKISP1_CIF_ISP_EXP_MEAN_12_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000040)
#define RKISP1_CIF_ISP_EXP_MEAN_22_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000044)
#define RKISP1_CIF_ISP_EXP_MEAN_32_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000048)
#define RKISP1_CIF_ISP_EXP_MEAN_42_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000004c)
#define RKISP1_CIF_ISP_EXP_MEAN_03_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000050)
#define RKISP1_CIF_ISP_EXP_MEAN_13_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000054)
#define RKISP1_CIF_ISP_EXP_MEAN_23_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000058)
#define RKISP1_CIF_ISP_EXP_MEAN_33_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000005c)
#define RKISP1_CIF_ISP_EXP_MEAN_43_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000060)
#define RKISP1_CIF_ISP_EXP_MEAN_04_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000064)
#define RKISP1_CIF_ISP_EXP_MEAN_14_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000068)
#define RKISP1_CIF_ISP_EXP_MEAN_24_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x0000006c)
#define RKISP1_CIF_ISP_EXP_MEAN_34_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000070)
#define RKISP1_CIF_ISP_EXP_MEAN_44_V10		(RKISP1_CIF_ISP_EXP_BASE + 0x00000074)
#define RKISP1_CIF_ISP_EXP_SIZE_V12		(RKISP1_CIF_ISP_EXP_BASE + 0x00000004)
#define RKISP1_CIF_ISP_EXP_OFFS_V12		(RKISP1_CIF_ISP_EXP_BASE + 0x00000008)
#define RKISP1_CIF_ISP_EXP_MEAN_V12		(RKISP1_CIF_ISP_EXP_BASE + 0x0000000c)

#define RKISP1_CIF_ISP_BLS_BASE			0x00002700
#define RKISP1_CIF_ISP_BLS_CTRL			(RKISP1_CIF_ISP_BLS_BASE + 0x00000000)
#define RKISP1_CIF_ISP_BLS_SAMPLES		(RKISP1_CIF_ISP_BLS_BASE + 0x00000004)
#define RKISP1_CIF_ISP_BLS_H1_START		(RKISP1_CIF_ISP_BLS_BASE + 0x00000008)
#define RKISP1_CIF_ISP_BLS_H1_STOP		(RKISP1_CIF_ISP_BLS_BASE + 0x0000000c)
#define RKISP1_CIF_ISP_BLS_V1_START		(RKISP1_CIF_ISP_BLS_BASE + 0x00000010)
#define RKISP1_CIF_ISP_BLS_V1_STOP		(RKISP1_CIF_ISP_BLS_BASE + 0x00000014)
#define RKISP1_CIF_ISP_BLS_H2_START		(RKISP1_CIF_ISP_BLS_BASE + 0x00000018)
#define RKISP1_CIF_ISP_BLS_H2_STOP		(RKISP1_CIF_ISP_BLS_BASE + 0x0000001c)
#define RKISP1_CIF_ISP_BLS_V2_START		(RKISP1_CIF_ISP_BLS_BASE + 0x00000020)
#define RKISP1_CIF_ISP_BLS_V2_STOP		(RKISP1_CIF_ISP_BLS_BASE + 0x00000024)
#define RKISP1_CIF_ISP_BLS_A_FIXED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000028)
#define RKISP1_CIF_ISP_BLS_B_FIXED		(RKISP1_CIF_ISP_BLS_BASE + 0x0000002c)
#define RKISP1_CIF_ISP_BLS_C_FIXED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000030)
#define RKISP1_CIF_ISP_BLS_D_FIXED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000034)
#define RKISP1_CIF_ISP_BLS_A_MEASURED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000038)
#define RKISP1_CIF_ISP_BLS_B_MEASURED		(RKISP1_CIF_ISP_BLS_BASE + 0x0000003c)
#define RKISP1_CIF_ISP_BLS_C_MEASURED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000040)
#define RKISP1_CIF_ISP_BLS_D_MEASURED		(RKISP1_CIF_ISP_BLS_BASE + 0x00000044)

#define RKISP1_CIF_ISP_DPF_BASE			0x00002800
#define RKISP1_CIF_ISP_DPF_MODE			(RKISP1_CIF_ISP_DPF_BASE + 0x00000000)
#define RKISP1_CIF_ISP_DPF_STRENGTH_R		(RKISP1_CIF_ISP_DPF_BASE + 0x00000004)
#define RKISP1_CIF_ISP_DPF_STRENGTH_G		(RKISP1_CIF_ISP_DPF_BASE + 0x00000008)
#define RKISP1_CIF_ISP_DPF_STRENGTH_B		(RKISP1_CIF_ISP_DPF_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_DPF_S_WEIGHT_G_1_4	(RKISP1_CIF_ISP_DPF_BASE + 0x00000010)
#define RKISP1_CIF_ISP_DPF_S_WEIGHT_G_5_6	(RKISP1_CIF_ISP_DPF_BASE + 0x00000014)
#define RKISP1_CIF_ISP_DPF_S_WEIGHT_RB_1_4	(RKISP1_CIF_ISP_DPF_BASE + 0x00000018)
#define RKISP1_CIF_ISP_DPF_S_WEIGHT_RB_5_6	(RKISP1_CIF_ISP_DPF_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_0		(RKISP1_CIF_ISP_DPF_BASE + 0x00000020)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_1		(RKISP1_CIF_ISP_DPF_BASE + 0x00000024)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_2		(RKISP1_CIF_ISP_DPF_BASE + 0x00000028)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_3		(RKISP1_CIF_ISP_DPF_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_4		(RKISP1_CIF_ISP_DPF_BASE + 0x00000030)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_5		(RKISP1_CIF_ISP_DPF_BASE + 0x00000034)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_6		(RKISP1_CIF_ISP_DPF_BASE + 0x00000038)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_7		(RKISP1_CIF_ISP_DPF_BASE + 0x0000003C)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_8		(RKISP1_CIF_ISP_DPF_BASE + 0x00000040)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_9		(RKISP1_CIF_ISP_DPF_BASE + 0x00000044)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_10	(RKISP1_CIF_ISP_DPF_BASE + 0x00000048)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_11	(RKISP1_CIF_ISP_DPF_BASE + 0x0000004C)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_12	(RKISP1_CIF_ISP_DPF_BASE + 0x00000050)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_13	(RKISP1_CIF_ISP_DPF_BASE + 0x00000054)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_14	(RKISP1_CIF_ISP_DPF_BASE + 0x00000058)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_15	(RKISP1_CIF_ISP_DPF_BASE + 0x0000005C)
#define RKISP1_CIF_ISP_DPF_NULL_COEFF_16	(RKISP1_CIF_ISP_DPF_BASE + 0x00000060)
#define RKISP1_CIF_ISP_DPF_NF_GAIN_R		(RKISP1_CIF_ISP_DPF_BASE + 0x00000064)
#define RKISP1_CIF_ISP_DPF_NF_GAIN_GR		(RKISP1_CIF_ISP_DPF_BASE + 0x00000068)
#define RKISP1_CIF_ISP_DPF_NF_GAIN_GB		(RKISP1_CIF_ISP_DPF_BASE + 0x0000006C)
#define RKISP1_CIF_ISP_DPF_NF_GAIN_B		(RKISP1_CIF_ISP_DPF_BASE + 0x00000070)

#define RKISP1_CIF_ISP_DPCC_BASE		0x00002900
#define RKISP1_CIF_ISP_DPCC_MODE		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000000)
#define RKISP1_CIF_ISP_DPCC_OUTPUT_MODE		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000004)
#define RKISP1_CIF_ISP_DPCC_SET_USE		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000008)
#define RKISP1_CIF_ISP_DPCC_METHODS_SET_1	(RKISP1_CIF_ISP_DPCC_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_DPCC_METHODS_SET_2	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000010)
#define RKISP1_CIF_ISP_DPCC_METHODS_SET_3	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000014)
#define RKISP1_CIF_ISP_DPCC_LINE_THRESH_1	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000018)
#define RKISP1_CIF_ISP_DPCC_LINE_MAD_FAC_1	(RKISP1_CIF_ISP_DPCC_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_DPCC_PG_FAC_1		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000020)
#define RKISP1_CIF_ISP_DPCC_RND_THRESH_1	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000024)
#define RKISP1_CIF_ISP_DPCC_RG_FAC_1		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000028)
#define RKISP1_CIF_ISP_DPCC_LINE_THRESH_2	(RKISP1_CIF_ISP_DPCC_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_DPCC_LINE_MAD_FAC_2	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000030)
#define RKISP1_CIF_ISP_DPCC_PG_FAC_2		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000034)
#define RKISP1_CIF_ISP_DPCC_RND_THRESH_2	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000038)
#define RKISP1_CIF_ISP_DPCC_RG_FAC_2		(RKISP1_CIF_ISP_DPCC_BASE + 0x0000003C)
#define RKISP1_CIF_ISP_DPCC_LINE_THRESH_3	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000040)
#define RKISP1_CIF_ISP_DPCC_LINE_MAD_FAC_3	(RKISP1_CIF_ISP_DPCC_BASE + 0x00000044)
#define RKISP1_CIF_ISP_DPCC_PG_FAC_3		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000048)
#define RKISP1_CIF_ISP_DPCC_RND_THRESH_3	(RKISP1_CIF_ISP_DPCC_BASE + 0x0000004C)
#define RKISP1_CIF_ISP_DPCC_RG_FAC_3		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000050)
#define RKISP1_CIF_ISP_DPCC_RO_LIMITS		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000054)
#define RKISP1_CIF_ISP_DPCC_RND_OFFS		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000058)
#define RKISP1_CIF_ISP_DPCC_BPT_CTRL		(RKISP1_CIF_ISP_DPCC_BASE + 0x0000005C)
#define RKISP1_CIF_ISP_DPCC_BPT_NUMBER		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000060)
#define RKISP1_CIF_ISP_DPCC_BPT_ADDR		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000064)
#define RKISP1_CIF_ISP_DPCC_BPT_DATA		(RKISP1_CIF_ISP_DPCC_BASE + 0x00000068)

#define RKISP1_CIF_ISP_WDR_BASE			0x00002A00
#define RKISP1_CIF_ISP_WDR_CTRL			(RKISP1_CIF_ISP_WDR_BASE + 0x00000000)
#define RKISP1_CIF_ISP_WDR_TONECURVE_1		(RKISP1_CIF_ISP_WDR_BASE + 0x00000004)
#define RKISP1_CIF_ISP_WDR_TONECURVE_2		(RKISP1_CIF_ISP_WDR_BASE + 0x00000008)
#define RKISP1_CIF_ISP_WDR_TONECURVE_3		(RKISP1_CIF_ISP_WDR_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_4		(RKISP1_CIF_ISP_WDR_BASE + 0x00000010)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_0	(RKISP1_CIF_ISP_WDR_BASE + 0x00000014)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_1	(RKISP1_CIF_ISP_WDR_BASE + 0x00000018)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_2	(RKISP1_CIF_ISP_WDR_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_3	(RKISP1_CIF_ISP_WDR_BASE + 0x00000020)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_4	(RKISP1_CIF_ISP_WDR_BASE + 0x00000024)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_5	(RKISP1_CIF_ISP_WDR_BASE + 0x00000028)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_6	(RKISP1_CIF_ISP_WDR_BASE + 0x0000002C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_7	(RKISP1_CIF_ISP_WDR_BASE + 0x00000030)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_8	(RKISP1_CIF_ISP_WDR_BASE + 0x00000034)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_9	(RKISP1_CIF_ISP_WDR_BASE + 0x00000038)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_10	(RKISP1_CIF_ISP_WDR_BASE + 0x0000003C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_11	(RKISP1_CIF_ISP_WDR_BASE + 0x00000040)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_12	(RKISP1_CIF_ISP_WDR_BASE + 0x00000044)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_13	(RKISP1_CIF_ISP_WDR_BASE + 0x00000048)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_14	(RKISP1_CIF_ISP_WDR_BASE + 0x0000004C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_15	(RKISP1_CIF_ISP_WDR_BASE + 0x00000050)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_16	(RKISP1_CIF_ISP_WDR_BASE + 0x00000054)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_17	(RKISP1_CIF_ISP_WDR_BASE + 0x00000058)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_18	(RKISP1_CIF_ISP_WDR_BASE + 0x0000005C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_19	(RKISP1_CIF_ISP_WDR_BASE + 0x00000060)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_20	(RKISP1_CIF_ISP_WDR_BASE + 0x00000064)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_21	(RKISP1_CIF_ISP_WDR_BASE + 0x00000068)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_22	(RKISP1_CIF_ISP_WDR_BASE + 0x0000006C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_23	(RKISP1_CIF_ISP_WDR_BASE + 0x00000070)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_24	(RKISP1_CIF_ISP_WDR_BASE + 0x00000074)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_25	(RKISP1_CIF_ISP_WDR_BASE + 0x00000078)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_26	(RKISP1_CIF_ISP_WDR_BASE + 0x0000007C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_27	(RKISP1_CIF_ISP_WDR_BASE + 0x00000080)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_28	(RKISP1_CIF_ISP_WDR_BASE + 0x00000084)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_29	(RKISP1_CIF_ISP_WDR_BASE + 0x00000088)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_30	(RKISP1_CIF_ISP_WDR_BASE + 0x0000008C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_31	(RKISP1_CIF_ISP_WDR_BASE + 0x00000090)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_32	(RKISP1_CIF_ISP_WDR_BASE + 0x00000094)
#define RKISP1_CIF_ISP_WDR_OFFSET		(RKISP1_CIF_ISP_WDR_BASE + 0x00000098)
#define RKISP1_CIF_ISP_WDR_DELTAMIN		(RKISP1_CIF_ISP_WDR_BASE + 0x0000009C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_1_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000A0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_2_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000A4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_3_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000A8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_4_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000AC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_0_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000B0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_1_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000B4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_2_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000B8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_3_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000BC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_4_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000C0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_5_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000C4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_6_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000C8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_7_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000CC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_8_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000D0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_9_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000D4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_10_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000D8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_11_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000DC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_12_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000E0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_13_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000E4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_14_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000E8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_15_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000EC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_16_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000F0)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_17_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000F4)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_18_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000F8)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_19_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x000000FC)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_20_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000100)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_21_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000104)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_22_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000108)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_23_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x0000010C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_24_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000110)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_25_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000114)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_26_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000118)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_27_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x0000011C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_28_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000120)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_29_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000124)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_30_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000128)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_31_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x0000012C)
#define RKISP1_CIF_ISP_WDR_TONECURVE_YM_32_SHD	(RKISP1_CIF_ISP_WDR_BASE + 0x00000130)

#define RKISP1_CIF_ISP_HIST_BASE_V12		0x00002C00
#define RKISP1_CIF_ISP_HIST_CTRL_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x00000000)
#define RKISP1_CIF_ISP_HIST_SIZE_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x00000004)
#define RKISP1_CIF_ISP_HIST_OFFS_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x00000008)
#define RKISP1_CIF_ISP_HIST_DBG1_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x0000000C)
#define RKISP1_CIF_ISP_HIST_DBG2_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x0000001C)
#define RKISP1_CIF_ISP_HIST_DBG3_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x0000002C)
#define RKISP1_CIF_ISP_HIST_WEIGHT_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x0000003C)
#define RKISP1_CIF_ISP_HIST_BIN_V12		(RKISP1_CIF_ISP_HIST_BASE_V12 + 0x00000120)

#define RKISP1_CIF_ISP_VSM_BASE			0x00002F00
#define RKISP1_CIF_ISP_VSM_MODE			(RKISP1_CIF_ISP_VSM_BASE + 0x00000000)
#define RKISP1_CIF_ISP_VSM_H_OFFS		(RKISP1_CIF_ISP_VSM_BASE + 0x00000004)
#define RKISP1_CIF_ISP_VSM_V_OFFS		(RKISP1_CIF_ISP_VSM_BASE + 0x00000008)
#define RKISP1_CIF_ISP_VSM_H_SIZE		(RKISP1_CIF_ISP_VSM_BASE + 0x0000000C)
#define RKISP1_CIF_ISP_VSM_V_SIZE		(RKISP1_CIF_ISP_VSM_BASE + 0x00000010)
#define RKISP1_CIF_ISP_VSM_H_SEGMENTS		(RKISP1_CIF_ISP_VSM_BASE + 0x00000014)
#define RKISP1_CIF_ISP_VSM_V_SEGMENTS		(RKISP1_CIF_ISP_VSM_BASE + 0x00000018)
#define RKISP1_CIF_ISP_VSM_DELTA_H		(RKISP1_CIF_ISP_VSM_BASE + 0x0000001C)
#define RKISP1_CIF_ISP_VSM_DELTA_V		(RKISP1_CIF_ISP_VSM_BASE + 0x00000020)

#define RKISP1_CIF_ISP_CSI0_BASE		0x00007000
#define RKISP1_CIF_ISP_CSI0_CTRL0		(RKISP1_CIF_ISP_CSI0_BASE + 0x00000000)

#endif /* _RKISP1_REGS_H */
