/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2022-2023 NVIDIA CORPORATION.  All rights reserved.
 */

#ifndef LINUX_TEGRA_ICC_H
#define LINUX_TEGRA_ICC_H

enum tegra_icc_client_type {
	TEGRA_ICC_NONE,
	TEGRA_ICC_NISO,
	TEGRA_ICC_ISO_DISPLAY,
	TEGRA_ICC_ISO_VI,
	TEGRA_ICC_ISO_AUDIO,
	TEGRA_ICC_ISO_VIFAL,
};

/* ICC ID's for MC client's used in BPMP */
#define TEGRA_ICC_BPMP_DEBUG		1
#define TEGRA_ICC_BPMP_CPU_CLUSTER0	2
#define TEGRA_ICC_BPMP_CPU_CLUSTER1	3
#define TEGRA_ICC_BPMP_CPU_CLUSTER2	4
#define TEGRA_ICC_BPMP_GPU		5
#define TEGRA_ICC_BPMP_CACTMON		6
#define TEGRA_ICC_BPMP_DISPLAY		7
#define TEGRA_ICC_BPMP_VI		8
#define TEGRA_ICC_BPMP_EQOS		9
#define TEGRA_ICC_BPMP_PCIE_0		10
#define TEGRA_ICC_BPMP_PCIE_1		11
#define TEGRA_ICC_BPMP_PCIE_2		12
#define TEGRA_ICC_BPMP_PCIE_3		13
#define TEGRA_ICC_BPMP_PCIE_4		14
#define TEGRA_ICC_BPMP_PCIE_5		15
#define TEGRA_ICC_BPMP_PCIE_6		16
#define TEGRA_ICC_BPMP_PCIE_7		17
#define TEGRA_ICC_BPMP_PCIE_8		18
#define TEGRA_ICC_BPMP_PCIE_9		19
#define TEGRA_ICC_BPMP_PCIE_10		20
#define TEGRA_ICC_BPMP_DLA_0		21
#define TEGRA_ICC_BPMP_DLA_1		22
#define TEGRA_ICC_BPMP_SDMMC_1		23
#define TEGRA_ICC_BPMP_SDMMC_2		24
#define TEGRA_ICC_BPMP_SDMMC_3		25
#define TEGRA_ICC_BPMP_SDMMC_4		26
#define TEGRA_ICC_BPMP_NVDEC		27
#define TEGRA_ICC_BPMP_NVENC		28
#define TEGRA_ICC_BPMP_NVJPG_0		29
#define TEGRA_ICC_BPMP_NVJPG_1		30
#define TEGRA_ICC_BPMP_OFAA		31
#define TEGRA_ICC_BPMP_XUSB_HOST	32
#define TEGRA_ICC_BPMP_XUSB_DEV		33
#define TEGRA_ICC_BPMP_TSEC		34
#define TEGRA_ICC_BPMP_VIC		35
#define TEGRA_ICC_BPMP_APE		36
#define TEGRA_ICC_BPMP_APEDMA		37
#define TEGRA_ICC_BPMP_SE		38
#define TEGRA_ICC_BPMP_ISP		39
#define TEGRA_ICC_BPMP_HDA		40
#define TEGRA_ICC_BPMP_VIFAL		41
#define TEGRA_ICC_BPMP_VI2FAL		42
#define TEGRA_ICC_BPMP_VI2		43
#define TEGRA_ICC_BPMP_RCE		44
#define TEGRA_ICC_BPMP_PVA		45

#endif /* LINUX_TEGRA_ICC_H */
