/* SPDX-License-Identifier: (BSD-3-Clause OR GPL-2.0-only) */
/* Copyright(c) 2022 Intel Corporation */
#ifndef ADF_GEN4_PM_H
#define ADF_GEN4_PM_H

#include <linux/bits.h>

struct adf_accel_dev;

enum qat_pm_host_msg {
	PM_NO_CHANGE = 0,
	PM_SET_MIN,
};

/* Power management registers */
#define ADF_GEN4_PM_HOST_MSG (0x50A01C)

/* Power management */
#define ADF_GEN4_PM_POLL_DELAY_US	20
#define ADF_GEN4_PM_POLL_TIMEOUT_US	USEC_PER_SEC
#define ADF_GEN4_PM_MSG_POLL_DELAY_US	(10 * USEC_PER_MSEC)
#define ADF_GEN4_PM_STATUS		(0x50A00C)
#define ADF_GEN4_PM_INTERRUPT		(0x50A028)

/* Power management source in ERRSOU2 and ERRMSK2 */
#define ADF_GEN4_PM_SOU			BIT(18)

#define ADF_GEN4_PM_IDLE_INT_EN		BIT(18)
#define ADF_GEN4_PM_THROTTLE_INT_EN	BIT(19)
#define ADF_GEN4_PM_DRV_ACTIVE		BIT(20)
#define ADF_GEN4_PM_INIT_STATE		BIT(21)
#define ADF_GEN4_PM_INT_EN_DEFAULT	(ADF_GEN4_PM_IDLE_INT_EN | \
					ADF_GEN4_PM_THROTTLE_INT_EN)

#define ADF_GEN4_PM_THR_STS	BIT(0)
#define ADF_GEN4_PM_IDLE_STS	BIT(1)
#define ADF_GEN4_PM_FW_INT_STS	BIT(2)
#define ADF_GEN4_PM_INT_STS_MASK (ADF_GEN4_PM_THR_STS | \
				 ADF_GEN4_PM_IDLE_STS | \
				 ADF_GEN4_PM_FW_INT_STS)

#define ADF_GEN4_PM_MSG_PENDING			BIT(0)
#define ADF_GEN4_PM_MSG_PAYLOAD_BIT_MASK	GENMASK(28, 1)

#define ADF_GEN4_PM_DEFAULT_IDLE_FILTER		(0x6)
#define ADF_GEN4_PM_MAX_IDLE_FILTER		(0x7)
#define ADF_GEN4_PM_DEFAULT_IDLE_SUPPORT	(0x1)

/* PM CSRs fields masks */
#define ADF_GEN4_PM_DOMAIN_POWER_GATED_MASK	GENMASK(15, 0)
#define ADF_GEN4_PM_SSM_PM_ENABLE_MASK		GENMASK(15, 0)
#define ADF_GEN4_PM_IDLE_FILTER_MASK		GENMASK(5, 3)
#define ADF_GEN4_PM_IDLE_ENABLE_MASK		BIT(2)
#define ADF_GEN4_PM_ENABLE_PM_MASK		BIT(21)
#define ADF_GEN4_PM_ENABLE_PM_IDLE_MASK		BIT(22)
#define ADF_GEN4_PM_ENABLE_DEEP_PM_IDLE_MASK	BIT(23)
#define ADF_GEN4_PM_CURRENT_WP_MASK		GENMASK(19, 11)
#define ADF_GEN4_PM_CPM_PM_STATE_MASK		GENMASK(22, 20)
#define ADF_GEN4_PM_PENDING_WP_MASK		GENMASK(31, 23)
#define ADF_GEN4_PM_THR_VALUE_MASK		GENMASK(6, 4)
#define ADF_GEN4_PM_MIN_PWR_ACK_MASK		BIT(7)
#define ADF_GEN4_PM_MIN_PWR_ACK_PENDING_MASK	BIT(17)
#define ADF_GEN4_PM_CPR_ACTIVE_COUNT_MASK	BIT(0)
#define ADF_GEN4_PM_CPR_MANAGED_COUNT_MASK	BIT(0)
#define ADF_GEN4_PM_XLT_ACTIVE_COUNT_MASK	BIT(1)
#define ADF_GEN4_PM_XLT_MANAGED_COUNT_MASK	BIT(1)
#define ADF_GEN4_PM_DCPR_ACTIVE_COUNT_MASK	GENMASK(3, 2)
#define ADF_GEN4_PM_DCPR_MANAGED_COUNT_MASK	GENMASK(3, 2)
#define ADF_GEN4_PM_PKE_ACTIVE_COUNT_MASK	GENMASK(8, 4)
#define ADF_GEN4_PM_PKE_MANAGED_COUNT_MASK	GENMASK(8, 4)
#define ADF_GEN4_PM_WAT_ACTIVE_COUNT_MASK	GENMASK(13, 9)
#define ADF_GEN4_PM_WAT_MANAGED_COUNT_MASK	GENMASK(13, 9)
#define ADF_GEN4_PM_WCP_ACTIVE_COUNT_MASK	GENMASK(18, 14)
#define ADF_GEN4_PM_WCP_MANAGED_COUNT_MASK	GENMASK(18, 14)
#define ADF_GEN4_PM_UCS_ACTIVE_COUNT_MASK	GENMASK(20, 19)
#define ADF_GEN4_PM_UCS_MANAGED_COUNT_MASK	GENMASK(20, 19)
#define ADF_GEN4_PM_CPH_ACTIVE_COUNT_MASK	GENMASK(24, 21)
#define ADF_GEN4_PM_CPH_MANAGED_COUNT_MASK	GENMASK(24, 21)
#define ADF_GEN4_PM_ATH_ACTIVE_COUNT_MASK	GENMASK(28, 25)
#define ADF_GEN4_PM_ATH_MANAGED_COUNT_MASK	GENMASK(28, 25)

int adf_gen4_enable_pm(struct adf_accel_dev *accel_dev);
bool adf_gen4_handle_pm_interrupt(struct adf_accel_dev *accel_dev);

#ifdef CONFIG_DEBUG_FS
void adf_gen4_init_dev_pm_data(struct adf_accel_dev *accel_dev);
#else
static inline void adf_gen4_init_dev_pm_data(struct adf_accel_dev *accel_dev)
{
}
#endif /* CONFIG_DEBUG_FS */

#endif
