#ifndef DEF_CHIP_REG
#define DEF_CHIP_REG

/*
 * Copyright(c) 2015, 2016 Intel Corporation.
 *
 * This file is provided under a dual BSD/GPLv2 license.  When using or
 * redistributing this file, you may do so under either license.
 *
 * GPL LICENSE SUMMARY
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * BSD LICENSE
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  - Neither the name of Intel Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#define CORE		0x000000000000
#define CCE			(CORE + 0x000000000000)
#define ASIC		(CORE + 0x000000400000)
#define MISC		(CORE + 0x000000500000)
#define DC_TOP_CSRS		(CORE + 0x000000600000)
#define CHIP_DEBUG		(CORE + 0x000000700000)
#define RXE			(CORE + 0x000001000000)
#define TXE			(CORE + 0x000001800000)
#define DCC_CSRS		(DC_TOP_CSRS + 0x000000000000)
#define DC_LCB_CSRS		(DC_TOP_CSRS + 0x000000001000)
#define DC_8051_CSRS		(DC_TOP_CSRS + 0x000000002000)
#define PCIE		0

#define ASIC_NUM_SCRATCH 4
#define CCE_ERR_INT_CNT 0
#define CCE_MISC_INT_CNT 2
#define CCE_NUM_32_BIT_COUNTERS 3
#define CCE_NUM_32_BIT_INT_COUNTERS 6
#define CCE_NUM_INT_CSRS 12
#define CCE_NUM_INT_MAP_CSRS 96
#define CCE_NUM_MSIX_PBAS 4
#define CCE_NUM_MSIX_VECTORS 256
#define CCE_NUM_SCRATCH 4
#define CCE_PCIE_POSTED_CRDT_STALL_CNT 2
#define CCE_PCIE_TRGT_STALL_CNT 0
#define CCE_PIO_WR_STALL_CNT 1
#define CCE_RCV_AVAIL_INT_CNT 3
#define CCE_RCV_URGENT_INT_CNT 4
#define CCE_SDMA_INT_CNT 1
#define CCE_SEND_CREDIT_INT_CNT 5
#define DCC_CFG_LED_CNTRL (DCC_CSRS + 0x000000000040)
#define DCC_CFG_LED_CNTRL_LED_CNTRL_SMASK 0x10ull
#define DCC_CFG_LED_CNTRL_LED_SW_BLINK_RATE_SHIFT 0
#define DCC_CFG_LED_CNTRL_LED_SW_BLINK_RATE_SMASK 0xFull
#define DCC_CFG_PORT_CONFIG (DCC_CSRS + 0x000000000008)
#define DCC_CFG_PORT_CONFIG1 (DCC_CSRS + 0x000000000010)
#define DCC_CFG_PORT_CONFIG1_DLID_MASK_MASK 0xFFFFull
#define DCC_CFG_PORT_CONFIG1_DLID_MASK_SHIFT 16
#define DCC_CFG_PORT_CONFIG1_DLID_MASK_SMASK 0xFFFF0000ull
#define DCC_CFG_PORT_CONFIG1_TARGET_DLID_MASK 0xFFFFull
#define DCC_CFG_PORT_CONFIG1_TARGET_DLID_SHIFT 0
#define DCC_CFG_PORT_CONFIG1_TARGET_DLID_SMASK 0xFFFFull
#define DCC_CFG_PORT_CONFIG_LINK_STATE_MASK 0x7ull
#define DCC_CFG_PORT_CONFIG_LINK_STATE_SHIFT 48
#define DCC_CFG_PORT_CONFIG_LINK_STATE_SMASK 0x7000000000000ull
#define DCC_CFG_PORT_CONFIG_MTU_CAP_MASK 0x7ull
#define DCC_CFG_PORT_CONFIG_MTU_CAP_SHIFT 32
#define DCC_CFG_PORT_CONFIG_MTU_CAP_SMASK 0x700000000ull
#define DCC_CFG_RESET (DCC_CSRS + 0x000000000000)
#define DCC_CFG_RESET_RESET_LCB_SHIFT 0
#define DCC_CFG_RESET_RESET_RX_FPE_SHIFT 2
#define DCC_CFG_SC_VL_TABLE_15_0 (DCC_CSRS + 0x000000000028)
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY0_SHIFT 0
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY10_SHIFT 40
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY11_SHIFT 44
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY12_SHIFT 48
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY13_SHIFT 52
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY14_SHIFT 56
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY15_SHIFT 60
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY1_SHIFT 4
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY2_SHIFT 8
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY3_SHIFT 12
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY4_SHIFT 16
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY5_SHIFT 20
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY6_SHIFT 24
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY7_SHIFT 28
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY8_SHIFT 32
#define DCC_CFG_SC_VL_TABLE_15_0_ENTRY9_SHIFT 36
#define DCC_CFG_SC_VL_TABLE_31_16 (DCC_CSRS + 0x000000000030)
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY16_SHIFT 0
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY17_SHIFT 4
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY18_SHIFT 8
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY19_SHIFT 12
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY20_SHIFT 16
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY21_SHIFT 20
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY22_SHIFT 24
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY23_SHIFT 28
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY24_SHIFT 32
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY25_SHIFT 36
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY26_SHIFT 40
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY27_SHIFT 44
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY28_SHIFT 48
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY29_SHIFT 52
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY30_SHIFT 56
#define DCC_CFG_SC_VL_TABLE_31_16_ENTRY31_SHIFT 60
#define DCC_ERR_DROPPED_PKT_CNT (DCC_CSRS + 0x000000000120)
#define DCC_ERR_FLG (DCC_CSRS + 0x000000000050)
#define DCC_ERR_FLG_BAD_CRDT_ACK_ERR_SMASK 0x4000ull
#define DCC_ERR_FLG_BAD_CTRL_DIST_ERR_SMASK 0x200000ull
#define DCC_ERR_FLG_BAD_CTRL_FLIT_ERR_SMASK 0x10000ull
#define DCC_ERR_FLG_BAD_DLID_TARGET_ERR_SMASK 0x200ull
#define DCC_ERR_FLG_BAD_HEAD_DIST_ERR_SMASK 0x800000ull
#define DCC_ERR_FLG_BAD_L2_ERR_SMASK 0x2ull
#define DCC_ERR_FLG_BAD_LVER_ERR_SMASK 0x400ull
#define DCC_ERR_FLG_BAD_MID_TAIL_ERR_SMASK 0x8ull
#define DCC_ERR_FLG_BAD_PKT_LENGTH_ERR_SMASK 0x4000000ull
#define DCC_ERR_FLG_BAD_PREEMPTION_ERR_SMASK 0x10ull
#define DCC_ERR_FLG_BAD_SC_ERR_SMASK 0x4ull
#define DCC_ERR_FLG_BAD_TAIL_DIST_ERR_SMASK 0x400000ull
#define DCC_ERR_FLG_BAD_VL_MARKER_ERR_SMASK 0x80ull
#define DCC_ERR_FLG_CLR (DCC_CSRS + 0x000000000060)
#define DCC_ERR_FLG_CSR_ACCESS_BLOCKED_HOST_SMASK 0x8000000000ull
#define DCC_ERR_FLG_CSR_ACCESS_BLOCKED_UC_SMASK 0x10000000000ull
#define DCC_ERR_FLG_CSR_INVAL_ADDR_SMASK 0x400000000000ull
#define DCC_ERR_FLG_CSR_PARITY_ERR_SMASK 0x200000000000ull
#define DCC_ERR_FLG_DLID_ZERO_ERR_SMASK 0x40000000ull
#define DCC_ERR_FLG_EN (DCC_CSRS + 0x000000000058)
#define DCC_ERR_FLG_EN_CSR_ACCESS_BLOCKED_HOST_SMASK 0x8000000000ull
#define DCC_ERR_FLG_EN_CSR_ACCESS_BLOCKED_UC_SMASK 0x10000000000ull
#define DCC_ERR_FLG_EVENT_CNTR_PARITY_ERR_SMASK 0x20000ull
#define DCC_ERR_FLG_EVENT_CNTR_ROLLOVER_ERR_SMASK 0x40000ull
#define DCC_ERR_FLG_FMCONFIG_ERR_SMASK 0x40000000000000ull
#define DCC_ERR_FLG_FPE_TX_FIFO_OVFLW_ERR_SMASK 0x2000000000ull
#define DCC_ERR_FLG_FPE_TX_FIFO_UNFLW_ERR_SMASK 0x4000000000ull
#define DCC_ERR_FLG_LATE_EBP_ERR_SMASK 0x1000000000ull
#define DCC_ERR_FLG_LATE_LONG_ERR_SMASK 0x800000000ull
#define DCC_ERR_FLG_LATE_SHORT_ERR_SMASK 0x400000000ull
#define DCC_ERR_FLG_LENGTH_MTU_ERR_SMASK 0x80000000ull
#define DCC_ERR_FLG_LINK_ERR_SMASK 0x80000ull
#define DCC_ERR_FLG_MISC_CNTR_ROLLOVER_ERR_SMASK 0x100000ull
#define DCC_ERR_FLG_NONVL15_STATE_ERR_SMASK 0x1000000ull
#define DCC_ERR_FLG_PERM_NVL15_ERR_SMASK 0x10000000ull
#define DCC_ERR_FLG_PREEMPTION_ERR_SMASK 0x20ull
#define DCC_ERR_FLG_PREEMPTIONVL15_ERR_SMASK 0x40ull
#define DCC_ERR_FLG_RCVPORT_ERR_SMASK 0x80000000000000ull
#define DCC_ERR_FLG_RX_BYTE_SHFT_PARITY_ERR_SMASK 0x1000000000000ull
#define DCC_ERR_FLG_RX_CTRL_PARITY_MBE_ERR_SMASK 0x100000000000ull
#define DCC_ERR_FLG_RX_EARLY_DROP_ERR_SMASK 0x200000000ull
#define DCC_ERR_FLG_SLID_ZERO_ERR_SMASK 0x20000000ull
#define DCC_ERR_FLG_TX_BYTE_SHFT_PARITY_ERR_SMASK 0x800000000000ull
#define DCC_ERR_FLG_TX_CTRL_PARITY_ERR_SMASK 0x20000000000ull
#define DCC_ERR_FLG_TX_CTRL_PARITY_MBE_ERR_SMASK 0x40000000000ull
#define DCC_ERR_FLG_TX_SC_PARITY_ERR_SMASK 0x80000000000ull
#define DCC_ERR_FLG_UNCORRECTABLE_ERR_SMASK 0x2000ull
#define DCC_ERR_FLG_UNSUP_PKT_TYPE_SMASK 0x8000ull
#define DCC_ERR_FLG_UNSUP_VL_ERR_SMASK 0x8000000ull
#define DCC_ERR_FLG_VL15_MULTI_ERR_SMASK 0x2000000ull
#define DCC_ERR_FMCONFIG_ERR_CNT (DCC_CSRS + 0x000000000110)
#define DCC_ERR_INFO_FMCONFIG (DCC_CSRS + 0x000000000090)
#define DCC_ERR_INFO_PORTRCV (DCC_CSRS + 0x000000000078)
#define DCC_ERR_INFO_PORTRCV_HDR0 (DCC_CSRS + 0x000000000080)
#define DCC_ERR_INFO_PORTRCV_HDR1 (DCC_CSRS + 0x000000000088)
#define DCC_ERR_INFO_UNCORRECTABLE (DCC_CSRS + 0x000000000098)
#define DCC_ERR_PORTRCV_ERR_CNT (DCC_CSRS + 0x000000000108)
#define DCC_ERR_RCVREMOTE_PHY_ERR_CNT (DCC_CSRS + 0x000000000118)
#define DCC_ERR_UNCORRECTABLE_CNT (DCC_CSRS + 0x000000000100)
#define DCC_PRF_PORT_MARK_FECN_CNT (DCC_CSRS + 0x000000000330)
#define DCC_PRF_PORT_RCV_BECN_CNT (DCC_CSRS + 0x000000000290)
#define DCC_PRF_PORT_RCV_BUBBLE_CNT (DCC_CSRS + 0x0000000002E0)
#define DCC_PRF_PORT_RCV_CORRECTABLE_CNT (DCC_CSRS + 0x000000000140)
#define DCC_PRF_PORT_RCV_DATA_CNT (DCC_CSRS + 0x000000000198)
#define DCC_PRF_PORT_RCV_FECN_CNT (DCC_CSRS + 0x000000000240)
#define DCC_PRF_PORT_RCV_MULTICAST_PKT_CNT (DCC_CSRS + 0x000000000130)
#define DCC_PRF_PORT_RCV_PKTS_CNT (DCC_CSRS + 0x0000000001A8)
#define DCC_PRF_PORT_VL_MARK_FECN_CNT (DCC_CSRS + 0x000000000338)
#define DCC_PRF_PORT_VL_RCV_BECN_CNT (DCC_CSRS + 0x000000000298)
#define DCC_PRF_PORT_VL_RCV_BUBBLE_CNT (DCC_CSRS + 0x0000000002E8)
#define DCC_PRF_PORT_VL_RCV_DATA_CNT (DCC_CSRS + 0x0000000001B0)
#define DCC_PRF_PORT_VL_RCV_FECN_CNT (DCC_CSRS + 0x000000000248)
#define DCC_PRF_PORT_VL_RCV_PKTS_CNT (DCC_CSRS + 0x0000000001F8)
#define DCC_PRF_PORT_XMIT_CORRECTABLE_CNT (DCC_CSRS + 0x000000000138)
#define DCC_PRF_PORT_XMIT_DATA_CNT (DCC_CSRS + 0x000000000190)
#define DCC_PRF_PORT_XMIT_MULTICAST_CNT (DCC_CSRS + 0x000000000128)
#define DCC_PRF_PORT_XMIT_PKTS_CNT (DCC_CSRS + 0x0000000001A0)
#define DCC_PRF_RX_FLOW_CRTL_CNT (DCC_CSRS + 0x000000000180)
#define DCC_PRF_TX_FLOW_CRTL_CNT (DCC_CSRS + 0x000000000188)
#define DC_DC8051_CFG_CSR_ACCESS_SEL (DC_8051_CSRS + 0x000000000110)
#define DC_DC8051_CFG_CSR_ACCESS_SEL_DCC_SMASK 0x2ull
#define DC_DC8051_CFG_CSR_ACCESS_SEL_LCB_SMASK 0x1ull
#define DC_DC8051_CFG_EXT_DEV_0 (DC_8051_CSRS + 0x000000000118)
#define DC_DC8051_CFG_EXT_DEV_0_COMPLETED_SMASK 0x1ull
#define DC_DC8051_CFG_EXT_DEV_0_RETURN_CODE_SHIFT 8
#define DC_DC8051_CFG_EXT_DEV_0_RSP_DATA_SHIFT 16
#define DC_DC8051_CFG_EXT_DEV_1 (DC_8051_CSRS + 0x000000000120)
#define DC_DC8051_CFG_EXT_DEV_1_REQ_DATA_MASK 0xFFFFull
#define DC_DC8051_CFG_EXT_DEV_1_REQ_DATA_SHIFT 16
#define DC_DC8051_CFG_EXT_DEV_1_REQ_DATA_SMASK 0xFFFF0000ull
#define DC_DC8051_CFG_EXT_DEV_1_REQ_NEW_SMASK 0x1ull
#define DC_DC8051_CFG_EXT_DEV_1_REQ_TYPE_MASK 0xFFull
#define DC_DC8051_CFG_EXT_DEV_1_REQ_TYPE_SHIFT 8
#define DC_DC8051_CFG_HOST_CMD_0 (DC_8051_CSRS + 0x000000000028)
#define DC_DC8051_CFG_HOST_CMD_0_REQ_DATA_MASK 0xFFFFFFFFFFFFull
#define DC_DC8051_CFG_HOST_CMD_0_REQ_DATA_SHIFT 16
#define DC_DC8051_CFG_HOST_CMD_0_REQ_NEW_SMASK 0x1ull
#define DC_DC8051_CFG_HOST_CMD_0_REQ_TYPE_MASK 0xFFull
#define DC_DC8051_CFG_HOST_CMD_0_REQ_TYPE_SHIFT 8
#define DC_DC8051_CFG_HOST_CMD_1 (DC_8051_CSRS + 0x000000000030)
#define DC_DC8051_CFG_HOST_CMD_1_COMPLETED_SMASK 0x1ull
#define DC_DC8051_CFG_HOST_CMD_1_RETURN_CODE_MASK 0xFFull
#define DC_DC8051_CFG_HOST_CMD_1_RETURN_CODE_SHIFT 8
#define DC_DC8051_CFG_HOST_CMD_1_RSP_DATA_MASK 0xFFFFFFFFFFFFull
#define DC_DC8051_CFG_HOST_CMD_1_RSP_DATA_SHIFT 16
#define DC_DC8051_CFG_LOCAL_GUID (DC_8051_CSRS + 0x000000000038)
#define DC_DC8051_CFG_MODE (DC_8051_CSRS + 0x000000000070)
#define DC_DC8051_CFG_RAM_ACCESS_CTRL (DC_8051_CSRS + 0x000000000008)
#define DC_DC8051_CFG_RAM_ACCESS_CTRL_ADDRESS_MASK 0x7FFFull
#define DC_DC8051_CFG_RAM_ACCESS_CTRL_ADDRESS_SHIFT 0
#define DC_DC8051_CFG_RAM_ACCESS_CTRL_WRITE_ENA_SMASK 0x1000000ull
#define DC_DC8051_CFG_RAM_ACCESS_CTRL_READ_ENA_SMASK 0x10000ull
#define DC_DC8051_CFG_RAM_ACCESS_SETUP (DC_8051_CSRS + 0x000000000000)
#define DC_DC8051_CFG_RAM_ACCESS_SETUP_AUTO_INCR_ADDR_SMASK 0x100ull
#define DC_DC8051_CFG_RAM_ACCESS_SETUP_RAM_SEL_SMASK 0x1ull
#define DC_DC8051_CFG_RAM_ACCESS_STATUS (DC_8051_CSRS + 0x000000000018)
#define DC_DC8051_CFG_RAM_ACCESS_STATUS_ACCESS_COMPLETED_SMASK 0x10000ull
#define DC_DC8051_CFG_RAM_ACCESS_WR_DATA (DC_8051_CSRS + 0x000000000010)
#define DC_DC8051_CFG_RAM_ACCESS_RD_DATA (DC_8051_CSRS + 0x000000000020)
#define DC_DC8051_CFG_RST (DC_8051_CSRS + 0x000000000068)
#define DC_DC8051_CFG_RST_CRAM_SMASK 0x2ull
#define DC_DC8051_CFG_RST_DRAM_SMASK 0x4ull
#define DC_DC8051_CFG_RST_IRAM_SMASK 0x8ull
#define DC_DC8051_CFG_RST_M8051W_SMASK 0x1ull
#define DC_DC8051_CFG_RST_SFR_SMASK 0x10ull
#define DC_DC8051_DBG_ERR_INFO_SET_BY_8051 (DC_8051_CSRS + 0x0000000000D8)
#define DC_DC8051_DBG_ERR_INFO_SET_BY_8051_ERROR_MASK 0xFFFFFFFFull
#define DC_DC8051_DBG_ERR_INFO_SET_BY_8051_ERROR_SHIFT 16
#define DC_DC8051_DBG_ERR_INFO_SET_BY_8051_HOST_MSG_MASK 0xFFFFull
#define DC_DC8051_DBG_ERR_INFO_SET_BY_8051_HOST_MSG_SHIFT 0
#define DC_DC8051_ERR_CLR (DC_8051_CSRS + 0x0000000000E8)
#define DC_DC8051_ERR_EN (DC_8051_CSRS + 0x0000000000F0)
#define DC_DC8051_ERR_EN_LOST_8051_HEART_BEAT_SMASK 0x2ull
#define DC_DC8051_ERR_FLG (DC_8051_CSRS + 0x0000000000E0)
#define DC_DC8051_ERR_FLG_CRAM_MBE_SMASK 0x4ull
#define DC_DC8051_ERR_FLG_CRAM_SBE_SMASK 0x8ull
#define DC_DC8051_ERR_FLG_DRAM_MBE_SMASK 0x10ull
#define DC_DC8051_ERR_FLG_DRAM_SBE_SMASK 0x20ull
#define DC_DC8051_ERR_FLG_INVALID_CSR_ADDR_SMASK 0x400ull
#define DC_DC8051_ERR_FLG_IRAM_MBE_SMASK 0x40ull
#define DC_DC8051_ERR_FLG_IRAM_SBE_SMASK 0x80ull
#define DC_DC8051_ERR_FLG_LOST_8051_HEART_BEAT_SMASK 0x2ull
#define DC_DC8051_ERR_FLG_SET_BY_8051_SMASK 0x1ull
#define DC_DC8051_ERR_FLG_UNMATCHED_SECURE_MSG_ACROSS_BCC_LANES_SMASK 0x100ull
#define DC_DC8051_STS_CUR_STATE (DC_8051_CSRS + 0x000000000060)
#define DC_DC8051_STS_CUR_STATE_FIRMWARE_MASK 0xFFull
#define DC_DC8051_STS_CUR_STATE_FIRMWARE_SHIFT 16
#define DC_DC8051_STS_CUR_STATE_PORT_MASK 0xFFull
#define DC_DC8051_STS_CUR_STATE_PORT_SHIFT 0
#define DC_DC8051_STS_LOCAL_FM_SECURITY (DC_8051_CSRS + 0x000000000050)
#define DC_DC8051_STS_LOCAL_FM_SECURITY_DISABLED_MASK 0x1ull
#define DC_DC8051_STS_REMOTE_FM_SECURITY (DC_8051_CSRS + 0x000000000058)
#define DC_DC8051_STS_REMOTE_GUID (DC_8051_CSRS + 0x000000000040)
#define DC_DC8051_STS_REMOTE_NODE_TYPE (DC_8051_CSRS + 0x000000000048)
#define DC_DC8051_STS_REMOTE_NODE_TYPE_VAL_MASK 0x3ull
#define DC_DC8051_STS_REMOTE_PORT_NO (DC_8051_CSRS + 0x000000000130)
#define DC_DC8051_STS_REMOTE_PORT_NO_VAL_SMASK 0xFFull
#define DC_LCB_CFG_ALLOW_LINK_UP (DC_LCB_CSRS + 0x000000000128)
#define DC_LCB_CFG_ALLOW_LINK_UP_VAL_SHIFT 0
#define DC_LCB_CFG_CRC_MODE (DC_LCB_CSRS + 0x000000000058)
#define DC_LCB_CFG_CRC_MODE_TX_VAL_SHIFT 0
#define DC_LCB_CFG_IGNORE_LOST_RCLK (DC_LCB_CSRS + 0x000000000020)
#define DC_LCB_CFG_IGNORE_LOST_RCLK_EN_SMASK 0x1ull
#define DC_LCB_CFG_LANE_WIDTH (DC_LCB_CSRS + 0x000000000100)
#define DC_LCB_CFG_LINK_KILL_EN (DC_LCB_CSRS + 0x000000000120)
#define DC_LCB_CFG_LINK_KILL_EN_FLIT_INPUT_BUF_MBE_SMASK 0x100000ull
#define DC_LCB_CFG_LINK_KILL_EN_REPLAY_BUF_MBE_SMASK 0x400000ull
#define DC_LCB_CFG_LN_DCLK (DC_LCB_CSRS + 0x000000000060)
#define DC_LCB_CFG_LOOPBACK (DC_LCB_CSRS + 0x0000000000F8)
#define DC_LCB_CFG_LOOPBACK_VAL_SHIFT 0
#define DC_LCB_CFG_RUN (DC_LCB_CSRS + 0x000000000000)
#define DC_LCB_CFG_RUN_EN_SHIFT 0
#define DC_LCB_CFG_RX_FIFOS_RADR (DC_LCB_CSRS + 0x000000000018)
#define DC_LCB_CFG_RX_FIFOS_RADR_DO_NOT_JUMP_VAL_SHIFT 8
#define DC_LCB_CFG_RX_FIFOS_RADR_OK_TO_JUMP_VAL_SHIFT 4
#define DC_LCB_CFG_RX_FIFOS_RADR_RST_VAL_SHIFT 0
#define DC_LCB_CFG_TX_FIFOS_RADR (DC_LCB_CSRS + 0x000000000010)
#define DC_LCB_CFG_TX_FIFOS_RADR_RST_VAL_SHIFT 0
#define DC_LCB_CFG_TX_FIFOS_RESET (DC_LCB_CSRS + 0x000000000008)
#define DC_LCB_CFG_TX_FIFOS_RESET_VAL_SHIFT 0
#define DC_LCB_CFG_REINIT_AS_SLAVE (DC_LCB_CSRS + 0x000000000030)
#define DC_LCB_CFG_CNT_FOR_SKIP_STALL (DC_LCB_CSRS + 0x000000000040)
#define DC_LCB_CFG_CLK_CNTR (DC_LCB_CSRS + 0x000000000110)
#define DC_LCB_ERR_CLR (DC_LCB_CSRS + 0x000000000308)
#define DC_LCB_ERR_EN (DC_LCB_CSRS + 0x000000000310)
#define DC_LCB_ERR_FLG (DC_LCB_CSRS + 0x000000000300)
#define DC_LCB_ERR_FLG_REDUNDANT_FLIT_PARITY_ERR_SMASK 0x20000000ull
#define DC_LCB_ERR_FLG_NEG_EDGE_LINK_TRANSFER_ACTIVE_SMASK 0x10000000ull
#define DC_LCB_ERR_FLG_HOLD_REINIT_SMASK 0x8000000ull
#define DC_LCB_ERR_FLG_RST_FOR_INCOMPLT_RND_TRIP_SMASK 0x4000000ull
#define DC_LCB_ERR_FLG_RST_FOR_LINK_TIMEOUT_SMASK 0x2000000ull
#define DC_LCB_ERR_FLG_CREDIT_RETURN_FLIT_MBE_SMASK 0x1000000ull
#define DC_LCB_ERR_FLG_REPLAY_BUF_SBE_SMASK 0x800000ull
#define DC_LCB_ERR_FLG_REPLAY_BUF_MBE_SMASK 0x400000ull
#define DC_LCB_ERR_FLG_FLIT_INPUT_BUF_SBE_SMASK 0x200000ull
#define DC_LCB_ERR_FLG_FLIT_INPUT_BUF_MBE_SMASK 0x100000ull
#define DC_LCB_ERR_FLG_VL_ACK_INPUT_WRONG_CRC_MODE_SMASK 0x80000ull
#define DC_LCB_ERR_FLG_VL_ACK_INPUT_PARITY_ERR_SMASK 0x40000ull
#define DC_LCB_ERR_FLG_VL_ACK_INPUT_BUF_OFLW_SMASK 0x20000ull
#define DC_LCB_ERR_FLG_FLIT_INPUT_BUF_OFLW_SMASK 0x10000ull
#define DC_LCB_ERR_FLG_ILLEGAL_FLIT_ENCODING_SMASK 0x8000ull
#define DC_LCB_ERR_FLG_ILLEGAL_NULL_LTP_SMASK 0x4000ull
#define DC_LCB_ERR_FLG_UNEXPECTED_ROUND_TRIP_MARKER_SMASK 0x2000ull
#define DC_LCB_ERR_FLG_UNEXPECTED_REPLAY_MARKER_SMASK 0x1000ull
#define DC_LCB_ERR_FLG_RCLK_STOPPED_SMASK 0x800ull
#define DC_LCB_ERR_FLG_CRC_ERR_CNT_HIT_LIMIT_SMASK 0x400ull
#define DC_LCB_ERR_FLG_REINIT_FOR_LN_DEGRADE_SMASK 0x200ull
#define DC_LCB_ERR_FLG_REINIT_FROM_PEER_SMASK 0x100ull
#define DC_LCB_ERR_FLG_SEQ_CRC_ERR_SMASK 0x80ull
#define DC_LCB_ERR_FLG_RX_LESS_THAN_FOUR_LNS_SMASK 0x40ull
#define DC_LCB_ERR_FLG_TX_LESS_THAN_FOUR_LNS_SMASK 0x20ull
#define DC_LCB_ERR_FLG_LOST_REINIT_STALL_OR_TOS_SMASK 0x10ull
#define DC_LCB_ERR_FLG_ALL_LNS_FAILED_REINIT_TEST_SMASK 0x8ull
#define DC_LCB_ERR_FLG_RST_FOR_FAILED_DESKEW_SMASK 0x4ull
#define DC_LCB_ERR_FLG_INVALID_CSR_ADDR_SMASK 0x2ull
#define DC_LCB_ERR_FLG_CSR_PARITY_ERR_SMASK 0x1ull
#define DC_LCB_ERR_INFO_CRC_ERR_LN0 (DC_LCB_CSRS + 0x000000000328)
#define DC_LCB_ERR_INFO_CRC_ERR_LN1 (DC_LCB_CSRS + 0x000000000330)
#define DC_LCB_ERR_INFO_CRC_ERR_LN2 (DC_LCB_CSRS + 0x000000000338)
#define DC_LCB_ERR_INFO_CRC_ERR_LN3 (DC_LCB_CSRS + 0x000000000340)
#define DC_LCB_ERR_INFO_CRC_ERR_MULTI_LN (DC_LCB_CSRS + 0x000000000348)
#define DC_LCB_ERR_INFO_ESCAPE_0_ONLY_CNT (DC_LCB_CSRS + 0x000000000368)
#define DC_LCB_ERR_INFO_ESCAPE_0_PLUS1_CNT (DC_LCB_CSRS + 0x000000000370)
#define DC_LCB_ERR_INFO_ESCAPE_0_PLUS2_CNT (DC_LCB_CSRS + 0x000000000378)
#define DC_LCB_ERR_INFO_MISC_FLG_CNT (DC_LCB_CSRS + 0x000000000390)
#define DC_LCB_ERR_INFO_REINIT_FROM_PEER_CNT (DC_LCB_CSRS + 0x000000000380)
#define DC_LCB_ERR_INFO_RX_REPLAY_CNT (DC_LCB_CSRS + 0x000000000358)
#define DC_LCB_ERR_INFO_SBE_CNT (DC_LCB_CSRS + 0x000000000388)
#define DC_LCB_ERR_INFO_SEQ_CRC_CNT (DC_LCB_CSRS + 0x000000000360)
#define DC_LCB_ERR_INFO_TOTAL_CRC_ERR (DC_LCB_CSRS + 0x000000000320)
#define DC_LCB_ERR_INFO_TX_REPLAY_CNT (DC_LCB_CSRS + 0x000000000350)
#define DC_LCB_PG_DBG_FLIT_CRDTS_CNT (DC_LCB_CSRS + 0x000000000580)
#define DC_LCB_PG_STS_PAUSE_COMPLETE_CNT (DC_LCB_CSRS + 0x0000000005F8)
#define DC_LCB_PG_STS_TX_MBE_CNT (DC_LCB_CSRS + 0x000000000608)
#define DC_LCB_PG_STS_TX_SBE_CNT (DC_LCB_CSRS + 0x000000000600)
#define DC_LCB_PRF_ACCEPTED_LTP_CNT (DC_LCB_CSRS + 0x000000000408)
#define DC_LCB_PRF_CLK_CNTR (DC_LCB_CSRS + 0x000000000420)
#define DC_LCB_PRF_GOOD_LTP_CNT (DC_LCB_CSRS + 0x000000000400)
#define DC_LCB_PRF_RX_FLIT_CNT (DC_LCB_CSRS + 0x000000000410)
#define DC_LCB_PRF_TX_FLIT_CNT (DC_LCB_CSRS + 0x000000000418)
#define DC_LCB_STS_LINK_TRANSFER_ACTIVE (DC_LCB_CSRS + 0x000000000468)
#define DC_LCB_STS_ROUND_TRIP_LTP_CNT (DC_LCB_CSRS + 0x0000000004B0)
#define RCV_BUF_OVFL_CNT 10
#define RCV_CONTEXT_EGR_STALL 22
#define RCV_DATA_PKT_CNT 0
#define RCV_DWORD_CNT 1
#define RCV_TID_FLOW_GEN_MISMATCH_CNT 20
#define RCV_TID_FLOW_SEQ_MISMATCH_CNT 23
#define RCV_TID_FULL_ERR_CNT 18
#define RCV_TID_VALID_ERR_CNT 19
#define RXE_NUM_32_BIT_COUNTERS 24
#define RXE_NUM_64_BIT_COUNTERS 2
#define RXE_NUM_RSM_INSTANCES 4
#define RXE_NUM_TID_FLOWS 32
#define RXE_PER_CONTEXT_OFFSET 0x0300000
#define SEND_DATA_PKT_CNT 0
#define SEND_DATA_PKT_VL0_CNT 12
#define SEND_DATA_VL0_CNT 3
#define SEND_DROPPED_PKT_CNT 5
#define SEND_DWORD_CNT 1
#define SEND_FLOW_STALL_CNT 4
#define SEND_HEADERS_ERR_CNT 6
#define SEND_LEN_ERR_CNT 1
#define SEND_MAX_MIN_LEN_ERR_CNT 2
#define SEND_UNDERRUN_CNT 3
#define SEND_UNSUP_VL_ERR_CNT 0
#define SEND_WAIT_CNT 2
#define SEND_WAIT_VL0_CNT 21
#define TXE_PIO_SEND_OFFSET 0x0800000
#define ASIC_CFG_DRV_STR (ASIC + 0x000000000048)
#define ASIC_CFG_MUTEX (ASIC + 0x000000000040)
#define ASIC_CFG_SBUS_EXECUTE (ASIC + 0x000000000008)
#define ASIC_CFG_SBUS_EXECUTE_EXECUTE_SMASK 0x1ull
#define ASIC_CFG_SBUS_EXECUTE_FAST_MODE_SMASK 0x2ull
#define ASIC_CFG_SBUS_REQUEST (ASIC + 0x000000000000)
#define ASIC_CFG_SBUS_REQUEST_COMMAND_SHIFT 16
#define ASIC_CFG_SBUS_REQUEST_DATA_ADDR_SHIFT 8
#define ASIC_CFG_SBUS_REQUEST_DATA_IN_SHIFT 32
#define ASIC_CFG_SBUS_REQUEST_RECEIVER_ADDR_SHIFT 0
#define ASIC_CFG_SCRATCH (ASIC + 0x000000000020)
#define ASIC_CFG_SCRATCH_1 (ASIC_CFG_SCRATCH + 0x08)
#define ASIC_CFG_SCRATCH_2 (ASIC_CFG_SCRATCH + 0x10)
#define ASIC_CFG_SCRATCH_3 (ASIC_CFG_SCRATCH + 0x18)
#define ASIC_CFG_THERM_POLL_EN (ASIC + 0x000000000050)
#define ASIC_EEP_ADDR_CMD (ASIC + 0x000000000308)
#define ASIC_EEP_ADDR_CMD_EP_ADDR_MASK 0xFFFFFFull
#define ASIC_EEP_CTL_STAT (ASIC + 0x000000000300)
#define ASIC_EEP_CTL_STAT_EP_RESET_SMASK 0x4ull
#define ASIC_EEP_CTL_STAT_RATE_SPI_SHIFT 8
#define ASIC_EEP_CTL_STAT_RESETCSR 0x0000000083818000ull
#define ASIC_EEP_DATA (ASIC + 0x000000000310)
#define ASIC_GPIO_CLEAR (ASIC + 0x000000000230)
#define ASIC_GPIO_FORCE (ASIC + 0x000000000238)
#define ASIC_GPIO_IN (ASIC + 0x000000000200)
#define ASIC_GPIO_INVERT (ASIC + 0x000000000210)
#define ASIC_GPIO_MASK (ASIC + 0x000000000220)
#define ASIC_GPIO_OE (ASIC + 0x000000000208)
#define ASIC_GPIO_OUT (ASIC + 0x000000000218)
#define ASIC_PCIE_SD_HOST_CMD (ASIC + 0x000000000100)
#define ASIC_PCIE_SD_HOST_CMD_INTRPT_CMD_SHIFT 0
#define ASIC_PCIE_SD_HOST_CMD_SBR_MODE_SMASK 0x400ull
#define ASIC_PCIE_SD_HOST_CMD_SBUS_RCVR_ADDR_SHIFT 2
#define ASIC_PCIE_SD_HOST_CMD_TIMER_MASK 0xFFFFFull
#define ASIC_PCIE_SD_HOST_CMD_TIMER_SHIFT 12
#define ASIC_PCIE_SD_HOST_STATUS (ASIC + 0x000000000108)
#define ASIC_PCIE_SD_HOST_STATUS_FW_DNLD_ERR_MASK 0x7ull
#define ASIC_PCIE_SD_HOST_STATUS_FW_DNLD_ERR_SHIFT 2
#define ASIC_PCIE_SD_HOST_STATUS_FW_DNLD_STS_MASK 0x3ull
#define ASIC_PCIE_SD_HOST_STATUS_FW_DNLD_STS_SHIFT 0
#define ASIC_PCIE_SD_INTRPT_DATA_CODE (ASIC + 0x000000000110)
#define ASIC_PCIE_SD_INTRPT_ENABLE (ASIC + 0x000000000118)
#define ASIC_PCIE_SD_INTRPT_LIST (ASIC + 0x000000000180)
#define ASIC_PCIE_SD_INTRPT_LIST_INTRPT_CODE_SHIFT 16
#define ASIC_PCIE_SD_INTRPT_LIST_INTRPT_DATA_SHIFT 0
#define ASIC_PCIE_SD_INTRPT_STATUS (ASIC + 0x000000000128)
#define ASIC_QSFP1_CLEAR (ASIC + 0x000000000270)
#define ASIC_QSFP1_FORCE (ASIC + 0x000000000278)
#define ASIC_QSFP1_IN (ASIC + 0x000000000240)
#define ASIC_QSFP1_INVERT (ASIC + 0x000000000250)
#define ASIC_QSFP1_MASK (ASIC + 0x000000000260)
#define ASIC_QSFP1_OE (ASIC + 0x000000000248)
#define ASIC_QSFP1_OUT (ASIC + 0x000000000258)
#define ASIC_QSFP1_STATUS (ASIC + 0x000000000268)
#define ASIC_QSFP2_CLEAR (ASIC + 0x0000000002B0)
#define ASIC_QSFP2_FORCE (ASIC + 0x0000000002B8)
#define ASIC_QSFP2_IN (ASIC + 0x000000000280)
#define ASIC_QSFP2_INVERT (ASIC + 0x000000000290)
#define ASIC_QSFP2_MASK (ASIC + 0x0000000002A0)
#define ASIC_QSFP2_OE (ASIC + 0x000000000288)
#define ASIC_QSFP2_OUT (ASIC + 0x000000000298)
#define ASIC_QSFP2_STATUS (ASIC + 0x0000000002A8)
#define ASIC_STS_SBUS_COUNTERS (ASIC + 0x000000000018)
#define ASIC_STS_SBUS_COUNTERS_EXECUTE_CNT_MASK 0xFFFFull
#define ASIC_STS_SBUS_COUNTERS_EXECUTE_CNT_SHIFT 0
#define ASIC_STS_SBUS_COUNTERS_RCV_DATA_VALID_CNT_MASK 0xFFFFull
#define ASIC_STS_SBUS_COUNTERS_RCV_DATA_VALID_CNT_SHIFT 16
#define ASIC_STS_SBUS_RESULT (ASIC + 0x000000000010)
#define ASIC_STS_SBUS_RESULT_DONE_SMASK 0x1ull
#define ASIC_STS_SBUS_RESULT_RCV_DATA_VALID_SMASK 0x2ull
#define ASIC_STS_SBUS_RESULT_RESULT_CODE_SHIFT 2
#define ASIC_STS_SBUS_RESULT_RESULT_CODE_MASK 0x7ull
#define ASIC_STS_SBUS_RESULT_DATA_OUT_SHIFT 32
#define ASIC_STS_SBUS_RESULT_DATA_OUT_MASK 0xFFFFFFFFull
#define ASIC_STS_THERM (ASIC + 0x000000000058)
#define ASIC_STS_THERM_CRIT_TEMP_MASK 0x7FFull
#define ASIC_STS_THERM_CRIT_TEMP_SHIFT 18
#define ASIC_STS_THERM_CURR_TEMP_MASK 0x7FFull
#define ASIC_STS_THERM_CURR_TEMP_SHIFT 2
#define ASIC_STS_THERM_HI_TEMP_MASK 0x7FFull
#define ASIC_STS_THERM_HI_TEMP_SHIFT 50
#define ASIC_STS_THERM_LO_TEMP_MASK 0x7FFull
#define ASIC_STS_THERM_LO_TEMP_SHIFT 34
#define ASIC_STS_THERM_LOW_SHIFT 13
#define CCE_COUNTER_ARRAY32 (CCE + 0x000000000060)
#define CCE_CTRL (CCE + 0x000000000010)
#define CCE_CTRL_RXE_RESUME_SMASK 0x800ull
#define CCE_CTRL_SPC_FREEZE_SMASK 0x100ull
#define CCE_CTRL_SPC_UNFREEZE_SMASK 0x200ull
#define CCE_CTRL_TXE_RESUME_SMASK 0x2000ull
#define CCE_DC_CTRL (CCE + 0x0000000000B8)
#define CCE_DC_CTRL_DC_RESET_SMASK 0x1ull
#define CCE_DC_CTRL_RESETCSR 0x0000000000000001ull
#define CCE_ERR_CLEAR (CCE + 0x000000000050)
#define CCE_ERR_MASK (CCE + 0x000000000048)
#define CCE_ERR_STATUS (CCE + 0x000000000040)
#define CCE_ERR_STATUS_CCE_CLI0_ASYNC_FIFO_PARITY_ERR_SMASK 0x40ull
#define CCE_ERR_STATUS_CCE_CLI1_ASYNC_FIFO_DBG_PARITY_ERROR_SMASK 0x1000ull
#define CCE_ERR_STATUS_CCE_CLI1_ASYNC_FIFO_PIO_CRDT_PARITY_ERR_SMASK \
		0x200ull
#define CCE_ERR_STATUS_CCE_CLI1_ASYNC_FIFO_RXDMA_PARITY_ERROR_SMASK \
		0x800ull
#define CCE_ERR_STATUS_CCE_CLI1_ASYNC_FIFO_SDMA_HD_PARITY_ERR_SMASK \
		0x400ull
#define CCE_ERR_STATUS_CCE_CLI2_ASYNC_FIFO_PARITY_ERR_SMASK 0x100ull
#define CCE_ERR_STATUS_CCE_CSR_CFG_BUS_PARITY_ERR_SMASK 0x80ull
#define CCE_ERR_STATUS_CCE_CSR_PARITY_ERR_SMASK 0x1ull
#define CCE_ERR_STATUS_CCE_CSR_READ_BAD_ADDR_ERR_SMASK 0x2ull
#define CCE_ERR_STATUS_CCE_CSR_WRITE_BAD_ADDR_ERR_SMASK 0x4ull
#define CCE_ERR_STATUS_CCE_INT_MAP_COR_ERR_SMASK 0x4000000000ull
#define CCE_ERR_STATUS_CCE_INT_MAP_UNC_ERR_SMASK 0x8000000000ull
#define CCE_ERR_STATUS_CCE_MSIX_CSR_PARITY_ERR_SMASK 0x10000000000ull
#define CCE_ERR_STATUS_CCE_MSIX_TABLE_COR_ERR_SMASK 0x1000000000ull
#define CCE_ERR_STATUS_CCE_MSIX_TABLE_UNC_ERR_SMASK 0x2000000000ull
#define CCE_ERR_STATUS_CCE_RCPL_ASYNC_FIFO_PARITY_ERR_SMASK 0x400000000ull
#define CCE_ERR_STATUS_CCE_RSPD_DATA_PARITY_ERR_SMASK 0x20ull
#define CCE_ERR_STATUS_CCE_RXDMA_CONV_FIFO_PARITY_ERR_SMASK 0x800000000ull
#define CCE_ERR_STATUS_CCE_SEG_READ_BAD_ADDR_ERR_SMASK 0x100000000ull
#define CCE_ERR_STATUS_CCE_SEG_WRITE_BAD_ADDR_ERR_SMASK 0x200000000ull
#define CCE_ERR_STATUS_CCE_TRGT_ACCESS_ERR_SMASK 0x10ull
#define CCE_ERR_STATUS_CCE_TRGT_ASYNC_FIFO_PARITY_ERR_SMASK 0x8ull
#define CCE_ERR_STATUS_CCE_TRGT_CPL_TIMEOUT_ERR_SMASK 0x40000000ull
#define CCE_ERR_STATUS_LA_TRIGGERED_SMASK 0x80000000ull
#define CCE_ERR_STATUS_PCIC_CPL_DAT_QCOR_ERR_SMASK 0x40000ull
#define CCE_ERR_STATUS_PCIC_CPL_DAT_QUNC_ERR_SMASK 0x4000000ull
#define CCE_ERR_STATUS_PCIC_CPL_HD_QCOR_ERR_SMASK 0x20000ull
#define CCE_ERR_STATUS_PCIC_CPL_HD_QUNC_ERR_SMASK 0x2000000ull
#define CCE_ERR_STATUS_PCIC_NPOST_DAT_QPARITY_ERR_SMASK 0x100000ull
#define CCE_ERR_STATUS_PCIC_NPOST_HQ_PARITY_ERR_SMASK 0x80000ull
#define CCE_ERR_STATUS_PCIC_POST_DAT_QCOR_ERR_SMASK 0x10000ull
#define CCE_ERR_STATUS_PCIC_POST_DAT_QUNC_ERR_SMASK 0x1000000ull
#define CCE_ERR_STATUS_PCIC_POST_HD_QCOR_ERR_SMASK 0x8000ull
#define CCE_ERR_STATUS_PCIC_POST_HD_QUNC_ERR_SMASK 0x800000ull
#define CCE_ERR_STATUS_PCIC_RECEIVE_PARITY_ERR_SMASK 0x20000000ull
#define CCE_ERR_STATUS_PCIC_RETRY_MEM_COR_ERR_SMASK 0x2000ull
#define CCE_ERR_STATUS_PCIC_RETRY_MEM_UNC_ERR_SMASK 0x200000ull
#define CCE_ERR_STATUS_PCIC_RETRY_SOT_MEM_COR_ERR_SMASK 0x4000ull
#define CCE_ERR_STATUS_PCIC_RETRY_SOT_MEM_UNC_ERR_SMASK 0x400000ull
#define CCE_ERR_STATUS_PCIC_TRANSMIT_BACK_PARITY_ERR_SMASK 0x10000000ull
#define CCE_ERR_STATUS_PCIC_TRANSMIT_FRONT_PARITY_ERR_SMASK 0x8000000ull
#define CCE_INT_CLEAR (CCE + 0x000000110A00)
#define CCE_INT_COUNTER_ARRAY32 (CCE + 0x000000110D00)
#define CCE_INT_FORCE (CCE + 0x000000110B00)
#define CCE_INT_MAP (CCE + 0x000000110500)
#define CCE_INT_MASK (CCE + 0x000000110900)
#define CCE_INT_STATUS (CCE + 0x000000110800)
#define CCE_MSIX_INT_GRANTED (CCE + 0x000000110200)
#define CCE_MSIX_TABLE_LOWER (CCE + 0x000000100000)
#define CCE_MSIX_TABLE_UPPER (CCE + 0x000000100008)
#define CCE_MSIX_TABLE_UPPER_RESETCSR 0x0000000100000000ull
#define CCE_MSIX_VEC_CLR_WITHOUT_INT (CCE + 0x000000110400)
#define CCE_PCIE_CTRL (CCE + 0x0000000000C0)
#define CCE_PCIE_CTRL_PCIE_LANE_BUNDLE_MASK 0x3ull
#define CCE_PCIE_CTRL_PCIE_LANE_BUNDLE_SHIFT 0
#define CCE_PCIE_CTRL_PCIE_LANE_DELAY_MASK 0xFull
#define CCE_PCIE_CTRL_PCIE_LANE_DELAY_SHIFT 2
#define CCE_PCIE_CTRL_XMT_MARGIN_OVERWRITE_ENABLE_SHIFT 8
#define CCE_PCIE_CTRL_XMT_MARGIN_SHIFT 9
#define CCE_PCIE_CTRL_XMT_MARGIN_GEN1_GEN2_OVERWRITE_ENABLE_MASK 0x1ull
#define CCE_PCIE_CTRL_XMT_MARGIN_GEN1_GEN2_OVERWRITE_ENABLE_SHIFT 12
#define CCE_PCIE_CTRL_XMT_MARGIN_GEN1_GEN2_MASK 0x7ull
#define CCE_PCIE_CTRL_XMT_MARGIN_GEN1_GEN2_SHIFT 13
#define CCE_REVISION (CCE + 0x000000000000)
#define CCE_REVISION2 (CCE + 0x000000000008)
#define CCE_REVISION2_HFI_ID_MASK 0x1ull
#define CCE_REVISION2_HFI_ID_SHIFT 0
#define CCE_REVISION2_IMPL_CODE_SHIFT 8
#define CCE_REVISION2_IMPL_REVISION_SHIFT 16
#define CCE_REVISION_BOARD_ID_LOWER_NIBBLE_MASK 0xFull
#define CCE_REVISION_BOARD_ID_LOWER_NIBBLE_SHIFT 32
#define CCE_REVISION_CHIP_REV_MAJOR_MASK 0xFFull
#define CCE_REVISION_CHIP_REV_MAJOR_SHIFT 8
#define CCE_REVISION_CHIP_REV_MINOR_MASK 0xFFull
#define CCE_REVISION_CHIP_REV_MINOR_SHIFT 0
#define CCE_REVISION_SW_MASK 0xFFull
#define CCE_REVISION_SW_SHIFT 24
#define CCE_SCRATCH (CCE + 0x000000000020)
#define CCE_STATUS (CCE + 0x000000000018)
#define CCE_STATUS_RXE_FROZE_SMASK 0x2ull
#define CCE_STATUS_RXE_PAUSED_SMASK 0x20ull
#define CCE_STATUS_SDMA_FROZE_SMASK 0x1ull
#define CCE_STATUS_SDMA_PAUSED_SMASK 0x10ull
#define CCE_STATUS_TXE_FROZE_SMASK 0x4ull
#define CCE_STATUS_TXE_PAUSED_SMASK 0x40ull
#define CCE_STATUS_TXE_PIO_FROZE_SMASK 0x8ull
#define CCE_STATUS_TXE_PIO_PAUSED_SMASK 0x80ull
#define MISC_CFG_FW_CTRL (MISC + 0x000000001000)
#define MISC_CFG_FW_CTRL_FW_8051_LOADED_SMASK 0x2ull
#define MISC_CFG_FW_CTRL_RSA_STATUS_SHIFT 2
#define MISC_CFG_FW_CTRL_RSA_STATUS_SMASK 0xCull
#define MISC_CFG_RSA_CMD (MISC + 0x000000000A08)
#define MISC_CFG_RSA_MODULUS (MISC + 0x000000000400)
#define MISC_CFG_RSA_MU (MISC + 0x000000000A10)
#define MISC_CFG_RSA_R2 (MISC + 0x000000000000)
#define MISC_CFG_RSA_SIGNATURE (MISC + 0x000000000200)
#define MISC_CFG_SHA_PRELOAD (MISC + 0x000000000A00)
#define MISC_ERR_CLEAR (MISC + 0x000000002010)
#define MISC_ERR_MASK (MISC + 0x000000002008)
#define MISC_ERR_STATUS (MISC + 0x000000002000)
#define MISC_ERR_STATUS_MISC_PLL_LOCK_FAIL_ERR_SMASK 0x1000ull
#define MISC_ERR_STATUS_MISC_MBIST_FAIL_ERR_SMASK 0x800ull
#define MISC_ERR_STATUS_MISC_INVALID_EEP_CMD_ERR_SMASK 0x400ull
#define MISC_ERR_STATUS_MISC_EFUSE_DONE_PARITY_ERR_SMASK 0x200ull
#define MISC_ERR_STATUS_MISC_EFUSE_WRITE_ERR_SMASK 0x100ull
#define MISC_ERR_STATUS_MISC_EFUSE_READ_BAD_ADDR_ERR_SMASK 0x80ull
#define MISC_ERR_STATUS_MISC_EFUSE_CSR_PARITY_ERR_SMASK 0x40ull
#define MISC_ERR_STATUS_MISC_FW_AUTH_FAILED_ERR_SMASK 0x20ull
#define MISC_ERR_STATUS_MISC_KEY_MISMATCH_ERR_SMASK 0x10ull
#define MISC_ERR_STATUS_MISC_SBUS_WRITE_FAILED_ERR_SMASK 0x8ull
#define MISC_ERR_STATUS_MISC_CSR_WRITE_BAD_ADDR_ERR_SMASK 0x4ull
#define MISC_ERR_STATUS_MISC_CSR_READ_BAD_ADDR_ERR_SMASK 0x2ull
#define MISC_ERR_STATUS_MISC_CSR_PARITY_ERR_SMASK 0x1ull
#define PCI_CFG_MSIX0 (PCIE + 0x0000000000B0)
#define PCI_CFG_REG1 (PCIE + 0x000000000004)
#define PCI_CFG_REG11 (PCIE + 0x00000000002C)
#define PCIE_CFG_SPCIE1 (PCIE + 0x00000000014C)
#define PCIE_CFG_SPCIE2 (PCIE + 0x000000000150)
#define PCIE_CFG_TPH2 (PCIE + 0x000000000180)
#define RCV_ARRAY (RXE + 0x000000200000)
#define RCV_ARRAY_CNT (RXE + 0x000000000018)
#define RCV_ARRAY_RT_ADDR_MASK 0xFFFFFFFFFull
#define RCV_ARRAY_RT_ADDR_SHIFT 0
#define RCV_ARRAY_RT_BUF_SIZE_SHIFT 36
#define RCV_ARRAY_RT_WRITE_ENABLE_SMASK 0x8000000000000000ull
#define RCV_AVAIL_TIME_OUT (RXE + 0x000000100050)
#define RCV_AVAIL_TIME_OUT_TIME_OUT_RELOAD_MASK 0xFFull
#define RCV_AVAIL_TIME_OUT_TIME_OUT_RELOAD_SHIFT 0
#define RCV_BTH_QP (RXE + 0x000000000028)
#define RCV_BTH_QP_KDETH_QP_MASK 0xFFull
#define RCV_BTH_QP_KDETH_QP_SHIFT 16
#define RCV_BYPASS (RXE + 0x000000000038)
#define RCV_CONTEXTS (RXE + 0x000000000010)
#define RCV_COUNTER_ARRAY32 (RXE + 0x000000000400)
#define RCV_COUNTER_ARRAY64 (RXE + 0x000000000500)
#define RCV_CTRL (RXE + 0x000000000000)
#define RCV_CTRL_RCV_BYPASS_ENABLE_SMASK 0x10ull
#define RCV_CTRL_RCV_EXTENDED_PSN_ENABLE_SMASK 0x40ull
#define RCV_CTRL_RCV_PARTITION_KEY_ENABLE_SMASK 0x4ull
#define RCV_CTRL_RCV_PORT_ENABLE_SMASK 0x1ull
#define RCV_CTRL_RCV_QP_MAP_ENABLE_SMASK 0x2ull
#define RCV_CTRL_RCV_RSM_ENABLE_SMASK 0x20ull
#define RCV_CTRL_RX_RBUF_INIT_SMASK 0x200ull
#define RCV_CTXT_CTRL (RXE + 0x000000100000)
#define RCV_CTXT_CTRL_DONT_DROP_EGR_FULL_SMASK 0x4ull
#define RCV_CTXT_CTRL_DONT_DROP_RHQ_FULL_SMASK 0x8ull
#define RCV_CTXT_CTRL_EGR_BUF_SIZE_MASK 0x7ull
#define RCV_CTXT_CTRL_EGR_BUF_SIZE_SHIFT 8
#define RCV_CTXT_CTRL_EGR_BUF_SIZE_SMASK 0x700ull
#define RCV_CTXT_CTRL_ENABLE_SMASK 0x1ull
#define RCV_CTXT_CTRL_INTR_AVAIL_SMASK 0x20ull
#define RCV_CTXT_CTRL_ONE_PACKET_PER_EGR_BUFFER_SMASK 0x2ull
#define RCV_CTXT_CTRL_TAIL_UPD_SMASK 0x40ull
#define RCV_CTXT_CTRL_TID_FLOW_ENABLE_SMASK 0x10ull
#define RCV_CTXT_STATUS (RXE + 0x000000100008)
#define RCV_EGR_CTRL (RXE + 0x000000100010)
#define RCV_EGR_CTRL_EGR_BASE_INDEX_MASK 0x1FFFull
#define RCV_EGR_CTRL_EGR_BASE_INDEX_SHIFT 0
#define RCV_EGR_CTRL_EGR_CNT_MASK 0x1FFull
#define RCV_EGR_CTRL_EGR_CNT_SHIFT 32
#define RCV_EGR_INDEX_HEAD (RXE + 0x000000300018)
#define RCV_EGR_INDEX_HEAD_HEAD_MASK 0x7FFull
#define RCV_EGR_INDEX_HEAD_HEAD_SHIFT 0
#define RCV_ERR_CLEAR (RXE + 0x000000000070)
#define RCV_ERR_INFO (RXE + 0x000000000050)
#define RCV_ERR_INFO_RCV_EXCESS_BUFFER_OVERRUN_SC_SMASK 0x1Full
#define RCV_ERR_INFO_RCV_EXCESS_BUFFER_OVERRUN_SMASK 0x20ull
#define RCV_ERR_MASK (RXE + 0x000000000068)
#define RCV_ERR_STATUS (RXE + 0x000000000060)
#define RCV_ERR_STATUS_RX_CSR_PARITY_ERR_SMASK 0x8000000000000000ull
#define RCV_ERR_STATUS_RX_CSR_READ_BAD_ADDR_ERR_SMASK 0x2000000000000000ull
#define RCV_ERR_STATUS_RX_CSR_WRITE_BAD_ADDR_ERR_SMASK \
		0x4000000000000000ull
#define RCV_ERR_STATUS_RX_DC_INTF_PARITY_ERR_SMASK 0x2ull
#define RCV_ERR_STATUS_RX_DC_SOP_EOP_PARITY_ERR_SMASK 0x200ull
#define RCV_ERR_STATUS_RX_DMA_CSR_COR_ERR_SMASK 0x1ull
#define RCV_ERR_STATUS_RX_DMA_CSR_PARITY_ERR_SMASK 0x200000000000000ull
#define RCV_ERR_STATUS_RX_DMA_CSR_UNC_ERR_SMASK 0x1000000000000000ull
#define RCV_ERR_STATUS_RX_DMA_DATA_FIFO_RD_COR_ERR_SMASK \
		0x40000000000000ull
#define RCV_ERR_STATUS_RX_DMA_DATA_FIFO_RD_UNC_ERR_SMASK \
		0x20000000000000ull
#define RCV_ERR_STATUS_RX_DMA_DQ_FSM_ENCODING_ERR_SMASK \
		0x800000000000000ull
#define RCV_ERR_STATUS_RX_DMA_EQ_FSM_ENCODING_ERR_SMASK \
		0x400000000000000ull
#define RCV_ERR_STATUS_RX_DMA_FLAG_COR_ERR_SMASK 0x800ull
#define RCV_ERR_STATUS_RX_DMA_FLAG_UNC_ERR_SMASK 0x400ull
#define RCV_ERR_STATUS_RX_DMA_HDR_FIFO_RD_COR_ERR_SMASK 0x10000000000000ull
#define RCV_ERR_STATUS_RX_DMA_HDR_FIFO_RD_UNC_ERR_SMASK 0x8000000000000ull
#define RCV_ERR_STATUS_RX_HQ_INTR_CSR_PARITY_ERR_SMASK 0x200000000000ull
#define RCV_ERR_STATUS_RX_HQ_INTR_FSM_ERR_SMASK 0x400000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_CSR_PARITY_ERR_SMASK 0x100000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_DES_PART1_UNC_COR_ERR_SMASK \
		0x10000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_DES_PART1_UNC_ERR_SMASK 0x8000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_DES_PART2_PARITY_ERR_SMASK \
		0x20000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_RCV_ARRAY_COR_ERR_SMASK 0x80000000000ull
#define RCV_ERR_STATUS_RX_LOOKUP_RCV_ARRAY_UNC_ERR_SMASK 0x40000000000ull
#define RCV_ERR_STATUS_RX_RBUF_BAD_LOOKUP_ERR_SMASK 0x40000000ull
#define RCV_ERR_STATUS_RX_RBUF_BLOCK_LIST_READ_COR_ERR_SMASK 0x100000ull
#define RCV_ERR_STATUS_RX_RBUF_BLOCK_LIST_READ_UNC_ERR_SMASK 0x80000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QENT_CNT_PARITY_ERR_SMASK 0x400000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QEOPDW_PARITY_ERR_SMASK 0x10000000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QHD_PTR_PARITY_ERR_SMASK 0x2000000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QHEAD_BUF_NUM_PARITY_ERR_SMASK \
		0x200000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QNEXT_BUF_PARITY_ERR_SMASK 0x800000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QNUM_OF_PKT_PARITY_ERR_SMASK \
		0x8000000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QTL_PTR_PARITY_ERR_SMASK 0x4000000ull
#define RCV_ERR_STATUS_RX_RBUF_CSR_QVLD_BIT_PARITY_ERR_SMASK 0x1000000ull
#define RCV_ERR_STATUS_RX_RBUF_CTX_ID_PARITY_ERR_SMASK 0x20000000ull
#define RCV_ERR_STATUS_RX_RBUF_DATA_COR_ERR_SMASK 0x100000000000000ull
#define RCV_ERR_STATUS_RX_RBUF_DATA_UNC_ERR_SMASK 0x80000000000000ull
#define RCV_ERR_STATUS_RX_RBUF_DESC_PART1_COR_ERR_SMASK 0x1000000000000ull
#define RCV_ERR_STATUS_RX_RBUF_DESC_PART1_UNC_ERR_SMASK 0x800000000000ull
#define RCV_ERR_STATUS_RX_RBUF_DESC_PART2_COR_ERR_SMASK 0x4000000000000ull
#define RCV_ERR_STATUS_RX_RBUF_DESC_PART2_UNC_ERR_SMASK 0x2000000000000ull
#define RCV_ERR_STATUS_RX_RBUF_EMPTY_ERR_SMASK 0x100000000ull
#define RCV_ERR_STATUS_RX_RBUF_FL_INITDONE_PARITY_ERR_SMASK 0x800000000ull
#define RCV_ERR_STATUS_RX_RBUF_FL_INIT_WR_ADDR_PARITY_ERR_SMASK \
		0x1000000000ull
#define RCV_ERR_STATUS_RX_RBUF_FL_RD_ADDR_PARITY_ERR_SMASK 0x200000000ull
#define RCV_ERR_STATUS_RX_RBUF_FL_WR_ADDR_PARITY_ERR_SMASK 0x400000000ull
#define RCV_ERR_STATUS_RX_RBUF_FREE_LIST_COR_ERR_SMASK 0x4000ull
#define RCV_ERR_STATUS_RX_RBUF_FREE_LIST_UNC_ERR_SMASK 0x2000ull
#define RCV_ERR_STATUS_RX_RBUF_FULL_ERR_SMASK 0x80000000ull
#define RCV_ERR_STATUS_RX_RBUF_LOOKUP_DES_COR_ERR_SMASK 0x40000ull
#define RCV_ERR_STATUS_RX_RBUF_LOOKUP_DES_REG_UNC_COR_ERR_SMASK 0x10000ull
#define RCV_ERR_STATUS_RX_RBUF_LOOKUP_DES_REG_UNC_ERR_SMASK 0x8000ull
#define RCV_ERR_STATUS_RX_RBUF_LOOKUP_DES_UNC_ERR_SMASK 0x20000ull
#define RCV_ERR_STATUS_RX_RBUF_NEXT_FREE_BUF_COR_ERR_SMASK 0x4000000000ull
#define RCV_ERR_STATUS_RX_RBUF_NEXT_FREE_BUF_UNC_ERR_SMASK 0x2000000000ull
#define RCV_ERR_STATUS_RX_RCV_CSR_PARITY_ERR_SMASK 0x100ull
#define RCV_ERR_STATUS_RX_RCV_DATA_COR_ERR_SMASK 0x20ull
#define RCV_ERR_STATUS_RX_RCV_DATA_UNC_ERR_SMASK 0x10ull
#define RCV_ERR_STATUS_RX_RCV_FSM_ENCODING_ERR_SMASK 0x1000ull
#define RCV_ERR_STATUS_RX_RCV_HDR_COR_ERR_SMASK 0x8ull
#define RCV_ERR_STATUS_RX_RCV_HDR_UNC_ERR_SMASK 0x4ull
#define RCV_ERR_STATUS_RX_RCV_QP_MAP_TABLE_COR_ERR_SMASK 0x80ull
#define RCV_ERR_STATUS_RX_RCV_QP_MAP_TABLE_UNC_ERR_SMASK 0x40ull
#define RCV_HDR_ADDR (RXE + 0x000000100028)
#define RCV_HDR_CNT (RXE + 0x000000100030)
#define RCV_HDR_CNT_CNT_MASK 0x1FFull
#define RCV_HDR_CNT_CNT_SHIFT 0
#define RCV_HDR_ENT_SIZE (RXE + 0x000000100038)
#define RCV_HDR_ENT_SIZE_ENT_SIZE_MASK 0x7ull
#define RCV_HDR_ENT_SIZE_ENT_SIZE_SHIFT 0
#define RCV_HDR_HEAD (RXE + 0x000000300008)
#define RCV_HDR_HEAD_COUNTER_MASK 0xFFull
#define RCV_HDR_HEAD_COUNTER_SHIFT 32
#define RCV_HDR_HEAD_HEAD_MASK 0x7FFFFull
#define RCV_HDR_HEAD_HEAD_SHIFT 0
#define RCV_HDR_HEAD_HEAD_SMASK 0x7FFFFull
#define RCV_HDR_OVFL_CNT (RXE + 0x000000100058)
#define RCV_HDR_SIZE (RXE + 0x000000100040)
#define RCV_HDR_SIZE_HDR_SIZE_MASK 0x1Full
#define RCV_HDR_SIZE_HDR_SIZE_SHIFT 0
#define RCV_HDR_TAIL (RXE + 0x000000300000)
#define RCV_HDR_TAIL_ADDR (RXE + 0x000000100048)
#define RCV_KEY_CTRL (RXE + 0x000000100020)
#define RCV_KEY_CTRL_JOB_KEY_ENABLE_SMASK 0x200000000ull
#define RCV_KEY_CTRL_JOB_KEY_VALUE_MASK 0xFFFFull
#define RCV_KEY_CTRL_JOB_KEY_VALUE_SHIFT 0
#define RCV_MULTICAST (RXE + 0x000000000030)
#define RCV_PARTITION_KEY (RXE + 0x000000000200)
#define RCV_PARTITION_KEY_PARTITION_KEY_A_MASK 0xFFFFull
#define RCV_PARTITION_KEY_PARTITION_KEY_B_SHIFT 16
#define RCV_QP_MAP_TABLE (RXE + 0x000000000100)
#define RCV_RSM_CFG (RXE + 0x000000000600)
#define RCV_RSM_CFG_ENABLE_OR_CHAIN_RSM0_MASK 0x1ull
#define RCV_RSM_CFG_ENABLE_OR_CHAIN_RSM0_SHIFT 0
#define RCV_RSM_CFG_PACKET_TYPE_SHIFT 60
#define RCV_RSM_CFG_OFFSET_SHIFT 32
#define RCV_RSM_MAP_TABLE (RXE + 0x000000000900)
#define RCV_RSM_MAP_TABLE_RCV_CONTEXT_A_MASK 0xFFull
#define RCV_RSM_MATCH (RXE + 0x000000000800)
#define RCV_RSM_MATCH_MASK1_SHIFT 0
#define RCV_RSM_MATCH_MASK2_SHIFT 16
#define RCV_RSM_MATCH_VALUE1_SHIFT 8
#define RCV_RSM_MATCH_VALUE2_SHIFT 24
#define RCV_RSM_SELECT (RXE + 0x000000000700)
#define RCV_RSM_SELECT_FIELD1_OFFSET_SHIFT 0
#define RCV_RSM_SELECT_FIELD2_OFFSET_SHIFT 16
#define RCV_RSM_SELECT_INDEX1_OFFSET_SHIFT 32
#define RCV_RSM_SELECT_INDEX1_WIDTH_SHIFT 44
#define RCV_RSM_SELECT_INDEX2_OFFSET_SHIFT 48
#define RCV_RSM_SELECT_INDEX2_WIDTH_SHIFT 60
#define RCV_STATUS (RXE + 0x000000000008)
#define RCV_STATUS_RX_PKT_IN_PROGRESS_SMASK 0x1ull
#define RCV_STATUS_RX_RBUF_INIT_DONE_SMASK 0x200ull
#define RCV_STATUS_RX_RBUF_PKT_PENDING_SMASK 0x40ull
#define RCV_TID_CTRL (RXE + 0x000000100018)
#define RCV_TID_CTRL_TID_BASE_INDEX_MASK 0x1FFFull
#define RCV_TID_CTRL_TID_BASE_INDEX_SHIFT 0
#define RCV_TID_CTRL_TID_PAIR_CNT_MASK 0x1FFull
#define RCV_TID_CTRL_TID_PAIR_CNT_SHIFT 32
#define RCV_TID_FLOW_TABLE (RXE + 0x000000300800)
#define RCV_VL15 (RXE + 0x000000000048)
#define SEND_BTH_QP (TXE + 0x0000000000A0)
#define SEND_BTH_QP_KDETH_QP_MASK 0xFFull
#define SEND_BTH_QP_KDETH_QP_SHIFT 16
#define SEND_CM_CREDIT_USED_STATUS (TXE + 0x000000000510)
#define SEND_CM_CREDIT_USED_STATUS_VL0_RETURN_CREDIT_STATUS_SMASK \
		0x1000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL15_RETURN_CREDIT_STATUS_SMASK \
		0x8000000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL1_RETURN_CREDIT_STATUS_SMASK \
		0x2000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL2_RETURN_CREDIT_STATUS_SMASK \
		0x4000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL3_RETURN_CREDIT_STATUS_SMASK \
		0x8000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL4_RETURN_CREDIT_STATUS_SMASK \
		0x10000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL5_RETURN_CREDIT_STATUS_SMASK \
		0x20000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL6_RETURN_CREDIT_STATUS_SMASK \
		0x40000000000000ull
#define SEND_CM_CREDIT_USED_STATUS_VL7_RETURN_CREDIT_STATUS_SMASK \
		0x80000000000000ull
#define SEND_CM_CREDIT_VL (TXE + 0x000000000600)
#define SEND_CM_CREDIT_VL15 (TXE + 0x000000000678)
#define SEND_CM_CREDIT_VL15_DEDICATED_LIMIT_VL_SHIFT 0
#define SEND_CM_CREDIT_VL_DEDICATED_LIMIT_VL_MASK 0xFFFFull
#define SEND_CM_CREDIT_VL_DEDICATED_LIMIT_VL_SHIFT 0
#define SEND_CM_CREDIT_VL_DEDICATED_LIMIT_VL_SMASK 0xFFFFull
#define SEND_CM_CREDIT_VL_SHARED_LIMIT_VL_MASK 0xFFFFull
#define SEND_CM_CREDIT_VL_SHARED_LIMIT_VL_SHIFT 16
#define SEND_CM_CREDIT_VL_SHARED_LIMIT_VL_SMASK 0xFFFF0000ull
#define SEND_CM_CTRL (TXE + 0x000000000500)
#define SEND_CM_CTRL_FORCE_CREDIT_MODE_SMASK 0x8ull
#define SEND_CM_CTRL_RESETCSR 0x0000000000000020ull
#define SEND_CM_GLOBAL_CREDIT (TXE + 0x000000000508)
#define SEND_CM_GLOBAL_CREDIT_AU_MASK 0x7ull
#define SEND_CM_GLOBAL_CREDIT_AU_SHIFT 16
#define SEND_CM_GLOBAL_CREDIT_AU_SMASK 0x70000ull
#define SEND_CM_GLOBAL_CREDIT_RESETCSR 0x0000094000030000ull
#define SEND_CM_GLOBAL_CREDIT_SHARED_LIMIT_MASK 0xFFFFull
#define SEND_CM_GLOBAL_CREDIT_SHARED_LIMIT_SHIFT 0
#define SEND_CM_GLOBAL_CREDIT_SHARED_LIMIT_SMASK 0xFFFFull
#define SEND_CM_GLOBAL_CREDIT_TOTAL_CREDIT_LIMIT_MASK 0xFFFFull
#define SEND_CM_GLOBAL_CREDIT_TOTAL_CREDIT_LIMIT_SHIFT 32
#define SEND_CM_GLOBAL_CREDIT_TOTAL_CREDIT_LIMIT_SMASK 0xFFFF00000000ull
#define SEND_CM_LOCAL_AU_TABLE0_TO3 (TXE + 0x000000000520)
#define SEND_CM_LOCAL_AU_TABLE0_TO3_LOCAL_AU_TABLE0_SHIFT 0
#define SEND_CM_LOCAL_AU_TABLE0_TO3_LOCAL_AU_TABLE1_SHIFT 16
#define SEND_CM_LOCAL_AU_TABLE0_TO3_LOCAL_AU_TABLE2_SHIFT 32
#define SEND_CM_LOCAL_AU_TABLE0_TO3_LOCAL_AU_TABLE3_SHIFT 48
#define SEND_CM_LOCAL_AU_TABLE4_TO7 (TXE + 0x000000000528)
#define SEND_CM_LOCAL_AU_TABLE4_TO7_LOCAL_AU_TABLE4_SHIFT 0
#define SEND_CM_LOCAL_AU_TABLE4_TO7_LOCAL_AU_TABLE5_SHIFT 16
#define SEND_CM_LOCAL_AU_TABLE4_TO7_LOCAL_AU_TABLE6_SHIFT 32
#define SEND_CM_LOCAL_AU_TABLE4_TO7_LOCAL_AU_TABLE7_SHIFT 48
#define SEND_CM_REMOTE_AU_TABLE0_TO3 (TXE + 0x000000000530)
#define SEND_CM_REMOTE_AU_TABLE4_TO7 (TXE + 0x000000000538)
#define SEND_CM_TIMER_CTRL (TXE + 0x000000000518)
#define SEND_CONTEXTS (TXE + 0x000000000010)
#define SEND_CONTEXT_SET_CTRL (TXE + 0x000000000200)
#define SEND_COUNTER_ARRAY32 (TXE + 0x000000000300)
#define SEND_COUNTER_ARRAY64 (TXE + 0x000000000400)
#define SEND_CTRL (TXE + 0x000000000000)
#define SEND_CTRL_CM_RESET_SMASK 0x4ull
#define SEND_CTRL_SEND_ENABLE_SMASK 0x1ull
#define SEND_CTRL_VL_ARBITER_ENABLE_SMASK 0x2ull
#define SEND_CTXT_CHECK_ENABLE (TXE + 0x000000100080)
#define SEND_CTXT_CHECK_ENABLE_CHECK_BYPASS_VL_MAPPING_SMASK 0x80ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_ENABLE_SMASK 0x1ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_JOB_KEY_SMASK 0x4ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_OPCODE_SMASK 0x20ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_PARTITION_KEY_SMASK 0x8ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_SLID_SMASK 0x10ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_VL_MAPPING_SMASK 0x40ull
#define SEND_CTXT_CHECK_ENABLE_CHECK_VL_SMASK 0x2ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_BAD_PKT_LEN_SMASK 0x20000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_BYPASS_BAD_PKT_LEN_SMASK \
		0x200000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_BYPASS_SMASK 0x800ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_GRH_SMASK 0x400ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_KDETH_PACKETS_SMASK 0x1000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_NON_KDETH_PACKETS_SMASK 0x2000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_PBC_STATIC_RATE_CONTROL_SMASK \
		0x100000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_PBC_TEST_SMASK 0x10000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_RAW_IPV6_SMASK 0x200ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_RAW_SMASK 0x100ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_TOO_LONG_BYPASS_PACKETS_SMASK \
		0x80000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_TOO_LONG_IB_PACKETS_SMASK \
		0x40000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_TOO_SMALL_BYPASS_PACKETS_SMASK \
		0x8000ull
#define SEND_CTXT_CHECK_ENABLE_DISALLOW_TOO_SMALL_IB_PACKETS_SMASK \
		0x4000ull
#define SEND_CTXT_CHECK_JOB_KEY (TXE + 0x000000100090)
#define SEND_CTXT_CHECK_JOB_KEY_ALLOW_PERMISSIVE_SMASK 0x100000000ull
#define SEND_CTXT_CHECK_JOB_KEY_MASK_SMASK 0xFFFF0000ull
#define SEND_CTXT_CHECK_JOB_KEY_VALUE_MASK 0xFFFFull
#define SEND_CTXT_CHECK_JOB_KEY_VALUE_SHIFT 0
#define SEND_CTXT_CHECK_OPCODE (TXE + 0x0000001000A8)
#define SEND_CTXT_CHECK_OPCODE_MASK_SHIFT 8
#define SEND_CTXT_CHECK_OPCODE_VALUE_SHIFT 0
#define SEND_CTXT_CHECK_PARTITION_KEY (TXE + 0x000000100098)
#define SEND_CTXT_CHECK_PARTITION_KEY_VALUE_MASK 0xFFFFull
#define SEND_CTXT_CHECK_PARTITION_KEY_VALUE_SHIFT 0
#define SEND_CTXT_CHECK_SLID (TXE + 0x0000001000A0)
#define SEND_CTXT_CHECK_SLID_MASK_MASK 0xFFFFull
#define SEND_CTXT_CHECK_SLID_MASK_SHIFT 16
#define SEND_CTXT_CHECK_SLID_VALUE_MASK 0xFFFFull
#define SEND_CTXT_CHECK_SLID_VALUE_SHIFT 0
#define SEND_CTXT_CHECK_VL (TXE + 0x000000100088)
#define SEND_CTXT_CREDIT_CTRL (TXE + 0x000000100010)
#define SEND_CTXT_CREDIT_CTRL_CREDIT_INTR_SMASK 0x20000ull
#define SEND_CTXT_CREDIT_CTRL_EARLY_RETURN_SMASK 0x10000ull
#define SEND_CTXT_CREDIT_CTRL_THRESHOLD_MASK 0x7FFull
#define SEND_CTXT_CREDIT_CTRL_THRESHOLD_SHIFT 0
#define SEND_CTXT_CREDIT_CTRL_THRESHOLD_SMASK 0x7FFull
#define SEND_CTXT_CREDIT_FORCE (TXE + 0x000000100028)
#define SEND_CTXT_CREDIT_FORCE_FORCE_RETURN_SMASK 0x1ull
#define SEND_CTXT_CREDIT_RETURN_ADDR (TXE + 0x000000100020)
#define SEND_CTXT_CREDIT_RETURN_ADDR_ADDRESS_SMASK 0xFFFFFFFFFFC0ull
#define SEND_CTXT_CTRL (TXE + 0x000000100000)
#define SEND_CTXT_CTRL_CTXT_BASE_MASK 0x3FFFull
#define SEND_CTXT_CTRL_CTXT_BASE_SHIFT 32
#define SEND_CTXT_CTRL_CTXT_DEPTH_MASK 0x7FFull
#define SEND_CTXT_CTRL_CTXT_DEPTH_SHIFT 48
#define SEND_CTXT_CTRL_CTXT_ENABLE_SMASK 0x1ull
#define SEND_CTXT_ERR_CLEAR (TXE + 0x000000100050)
#define SEND_CTXT_ERR_MASK (TXE + 0x000000100048)
#define SEND_CTXT_ERR_STATUS (TXE + 0x000000100040)
#define SEND_CTXT_ERR_STATUS_PIO_DISALLOWED_PACKET_ERR_SMASK 0x2ull
#define SEND_CTXT_ERR_STATUS_PIO_INCONSISTENT_SOP_ERR_SMASK 0x1ull
#define SEND_CTXT_ERR_STATUS_PIO_WRITE_CROSSES_BOUNDARY_ERR_SMASK 0x4ull
#define SEND_CTXT_ERR_STATUS_PIO_WRITE_OUT_OF_BOUNDS_ERR_SMASK 0x10ull
#define SEND_CTXT_ERR_STATUS_PIO_WRITE_OVERFLOW_ERR_SMASK 0x8ull
#define SEND_CTXT_STATUS (TXE + 0x000000100008)
#define SEND_CTXT_STATUS_CTXT_HALTED_SMASK 0x1ull
#define SEND_DMA_BASE_ADDR (TXE + 0x000000200010)
#define SEND_DMA_CHECK_ENABLE (TXE + 0x000000200080)
#define SEND_DMA_CHECK_ENABLE_CHECK_BYPASS_VL_MAPPING_SMASK 0x80ull
#define SEND_DMA_CHECK_ENABLE_CHECK_ENABLE_SMASK 0x1ull
#define SEND_DMA_CHECK_ENABLE_CHECK_JOB_KEY_SMASK 0x4ull
#define SEND_DMA_CHECK_ENABLE_CHECK_OPCODE_SMASK 0x20ull
#define SEND_DMA_CHECK_ENABLE_CHECK_PARTITION_KEY_SMASK 0x8ull
#define SEND_DMA_CHECK_ENABLE_CHECK_SLID_SMASK 0x10ull
#define SEND_DMA_CHECK_ENABLE_CHECK_VL_MAPPING_SMASK 0x40ull
#define SEND_DMA_CHECK_ENABLE_CHECK_VL_SMASK 0x2ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_BAD_PKT_LEN_SMASK 0x20000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_BYPASS_BAD_PKT_LEN_SMASK 0x200000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_PBC_STATIC_RATE_CONTROL_SMASK \
		0x100000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_RAW_IPV6_SMASK 0x200ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_RAW_SMASK 0x100ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_TOO_LONG_BYPASS_PACKETS_SMASK \
		0x80000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_TOO_LONG_IB_PACKETS_SMASK 0x40000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_TOO_SMALL_BYPASS_PACKETS_SMASK \
		0x8000ull
#define SEND_DMA_CHECK_ENABLE_DISALLOW_TOO_SMALL_IB_PACKETS_SMASK 0x4000ull
#define SEND_DMA_CHECK_JOB_KEY (TXE + 0x000000200090)
#define SEND_DMA_CHECK_OPCODE (TXE + 0x0000002000A8)
#define SEND_DMA_CHECK_PARTITION_KEY (TXE + 0x000000200098)
#define SEND_DMA_CHECK_SLID (TXE + 0x0000002000A0)
#define SEND_DMA_CHECK_SLID_MASK_MASK 0xFFFFull
#define SEND_DMA_CHECK_SLID_MASK_SHIFT 16
#define SEND_DMA_CHECK_SLID_VALUE_MASK 0xFFFFull
#define SEND_DMA_CHECK_SLID_VALUE_SHIFT 0
#define SEND_DMA_CHECK_VL (TXE + 0x000000200088)
#define SEND_DMA_CTRL (TXE + 0x000000200000)
#define SEND_DMA_CTRL_SDMA_CLEANUP_SMASK 0x4ull
#define SEND_DMA_CTRL_SDMA_ENABLE_SMASK 0x1ull
#define SEND_DMA_CTRL_SDMA_HALT_SMASK 0x2ull
#define SEND_DMA_CTRL_SDMA_INT_ENABLE_SMASK 0x8ull
#define SEND_DMA_DESC_CNT (TXE + 0x000000200050)
#define SEND_DMA_DESC_CNT_CNT_MASK 0xFFFFull
#define SEND_DMA_DESC_CNT_CNT_SHIFT 0
#define SEND_DMA_ENG_ERR_CLEAR (TXE + 0x000000200070)
#define SEND_DMA_ENG_ERR_CLEAR_SDMA_HEADER_REQUEST_FIFO_UNC_ERR_MASK 0x1ull
#define SEND_DMA_ENG_ERR_CLEAR_SDMA_HEADER_REQUEST_FIFO_UNC_ERR_SHIFT 18
#define SEND_DMA_ENG_ERR_MASK (TXE + 0x000000200068)
#define SEND_DMA_ENG_ERR_STATUS (TXE + 0x000000200060)
#define SEND_DMA_ENG_ERR_STATUS_SDMA_ASSEMBLY_UNC_ERR_SMASK 0x8000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_DESC_TABLE_UNC_ERR_SMASK 0x4000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_FIRST_DESC_ERR_SMASK 0x10ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_GEN_MISMATCH_ERR_SMASK 0x2ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HALT_ERR_SMASK 0x40ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HEADER_ADDRESS_ERR_SMASK 0x800ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HEADER_LENGTH_ERR_SMASK 0x1000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HEADER_REQUEST_FIFO_UNC_ERR_SMASK \
		0x40000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HEADER_SELECT_ERR_SMASK 0x400ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_HEADER_STORAGE_UNC_ERR_SMASK \
		0x20000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_LENGTH_MISMATCH_ERR_SMASK 0x80ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_MEM_READ_ERR_SMASK 0x20ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_PACKET_DESC_OVERFLOW_ERR_SMASK \
		0x100ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_PACKET_TRACKING_UNC_ERR_SMASK \
		0x10000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_TAIL_OUT_OF_BOUNDS_ERR_SMASK 0x8ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_TIMEOUT_ERR_SMASK 0x2000ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_TOO_LONG_ERR_SMASK 0x4ull
#define SEND_DMA_ENG_ERR_STATUS_SDMA_WRONG_DW_ERR_SMASK 0x1ull
#define SEND_DMA_ENGINES (TXE + 0x000000000018)
#define SEND_DMA_ERR_CLEAR (TXE + 0x000000000070)
#define SEND_DMA_ERR_MASK (TXE + 0x000000000068)
#define SEND_DMA_ERR_STATUS (TXE + 0x000000000060)
#define SEND_DMA_ERR_STATUS_SDMA_CSR_PARITY_ERR_SMASK 0x2ull
#define SEND_DMA_ERR_STATUS_SDMA_PCIE_REQ_TRACKING_COR_ERR_SMASK 0x8ull
#define SEND_DMA_ERR_STATUS_SDMA_PCIE_REQ_TRACKING_UNC_ERR_SMASK 0x4ull
#define SEND_DMA_ERR_STATUS_SDMA_RPY_TAG_ERR_SMASK 0x1ull
#define SEND_DMA_HEAD (TXE + 0x000000200028)
#define SEND_DMA_HEAD_ADDR (TXE + 0x000000200030)
#define SEND_DMA_LEN_GEN (TXE + 0x000000200018)
#define SEND_DMA_LEN_GEN_GENERATION_SHIFT 16
#define SEND_DMA_LEN_GEN_LENGTH_SHIFT 6
#define SEND_DMA_MEMORY (TXE + 0x0000002000B0)
#define SEND_DMA_MEMORY_SDMA_MEMORY_CNT_SHIFT 16
#define SEND_DMA_MEMORY_SDMA_MEMORY_INDEX_SHIFT 0
#define SEND_DMA_MEM_SIZE (TXE + 0x000000000028)
#define SEND_DMA_PRIORITY_THLD (TXE + 0x000000200038)
#define SEND_DMA_RELOAD_CNT (TXE + 0x000000200048)
#define SEND_DMA_STATUS (TXE + 0x000000200008)
#define SEND_DMA_STATUS_ENG_CLEANED_UP_SMASK 0x200000000000000ull
#define SEND_DMA_STATUS_ENG_HALTED_SMASK 0x100000000000000ull
#define SEND_DMA_TAIL (TXE + 0x000000200020)
#define SEND_EGRESS_CTXT_STATUS (TXE + 0x000000000800)
#define SEND_EGRESS_CTXT_STATUS_CTXT_EGRESS_HALT_STATUS_SMASK 0x10000ull
#define SEND_EGRESS_CTXT_STATUS_CTXT_EGRESS_PACKET_OCCUPANCY_SHIFT 0
#define SEND_EGRESS_CTXT_STATUS_CTXT_EGRESS_PACKET_OCCUPANCY_SMASK \
		0x3FFFull
#define SEND_EGRESS_ERR_CLEAR (TXE + 0x000000000090)
#define SEND_EGRESS_ERR_INFO (TXE + 0x000000000F00)
#define SEND_EGRESS_ERR_INFO_BAD_PKT_LEN_ERR_SMASK 0x20000ull
#define SEND_EGRESS_ERR_INFO_BYPASS_ERR_SMASK 0x800ull
#define SEND_EGRESS_ERR_INFO_GRH_ERR_SMASK 0x400ull
#define SEND_EGRESS_ERR_INFO_JOB_KEY_ERR_SMASK 0x4ull
#define SEND_EGRESS_ERR_INFO_KDETH_PACKETS_ERR_SMASK 0x1000ull
#define SEND_EGRESS_ERR_INFO_NON_KDETH_PACKETS_ERR_SMASK 0x2000ull
#define SEND_EGRESS_ERR_INFO_OPCODE_ERR_SMASK 0x20ull
#define SEND_EGRESS_ERR_INFO_PARTITION_KEY_ERR_SMASK 0x8ull
#define SEND_EGRESS_ERR_INFO_PBC_STATIC_RATE_CONTROL_ERR_SMASK 0x100000ull
#define SEND_EGRESS_ERR_INFO_PBC_TEST_ERR_SMASK 0x10000ull
#define SEND_EGRESS_ERR_INFO_RAW_ERR_SMASK 0x100ull
#define SEND_EGRESS_ERR_INFO_RAW_IPV6_ERR_SMASK 0x200ull
#define SEND_EGRESS_ERR_INFO_SLID_ERR_SMASK 0x10ull
#define SEND_EGRESS_ERR_INFO_TOO_LONG_BYPASS_PACKETS_ERR_SMASK 0x80000ull
#define SEND_EGRESS_ERR_INFO_TOO_LONG_IB_PACKET_ERR_SMASK 0x40000ull
#define SEND_EGRESS_ERR_INFO_TOO_SMALL_BYPASS_PACKETS_ERR_SMASK 0x8000ull
#define SEND_EGRESS_ERR_INFO_TOO_SMALL_IB_PACKETS_ERR_SMASK 0x4000ull
#define SEND_EGRESS_ERR_INFO_VL_ERR_SMASK 0x2ull
#define SEND_EGRESS_ERR_INFO_VL_MAPPING_ERR_SMASK 0x40ull
#define SEND_EGRESS_ERR_MASK (TXE + 0x000000000088)
#define SEND_EGRESS_ERR_SOURCE (TXE + 0x000000000F08)
#define SEND_EGRESS_ERR_STATUS (TXE + 0x000000000080)
#define SEND_EGRESS_ERR_STATUS_TX_CONFIG_PARITY_ERR_SMASK 0x8000ull
#define SEND_EGRESS_ERR_STATUS_TX_CREDIT_OVERRUN_ERR_SMASK \
		0x200000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_CREDIT_RETURN_PARITY_ERR_SMASK \
		0x20000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_CREDIT_RETURN_VL_ERR_SMASK \
		0x800000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_EGRESS_FIFO_COR_ERR_SMASK \
		0x2000000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_EGRESS_FIFO_UNC_ERR_SMASK \
		0x200000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_EGRESS_FIFO_UNDERRUN_OR_PARITY_ERR_SMASK \
		0x8ull
#define SEND_EGRESS_ERR_STATUS_TX_HCRC_INSERTION_ERR_SMASK \
		0x400000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_ILLEGAL_VL_ERR_SMASK 0x1000ull
#define SEND_EGRESS_ERR_STATUS_TX_INCORRECT_LINK_STATE_ERR_SMASK 0x20ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_CSR_PARITY_ERR_SMASK 0x2000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO0_COR_ERR_SMASK \
		0x1000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO0_UNC_OR_PARITY_ERR_SMASK \
		0x100000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO1_COR_ERR_SMASK \
		0x2000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO1_UNC_OR_PARITY_ERR_SMASK \
		0x200000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO2_COR_ERR_SMASK \
		0x4000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO2_UNC_OR_PARITY_ERR_SMASK \
		0x400000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO3_COR_ERR_SMASK \
		0x8000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO3_UNC_OR_PARITY_ERR_SMASK \
		0x800000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO4_COR_ERR_SMASK \
		0x10000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO4_UNC_OR_PARITY_ERR_SMASK \
		0x1000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO5_COR_ERR_SMASK \
		0x20000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO5_UNC_OR_PARITY_ERR_SMASK \
		0x2000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO6_COR_ERR_SMASK \
		0x40000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO6_UNC_OR_PARITY_ERR_SMASK \
		0x4000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO7_COR_ERR_SMASK \
		0x80000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO7_UNC_OR_PARITY_ERR_SMASK \
		0x8000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO8_COR_ERR_SMASK \
		0x100000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LAUNCH_FIFO8_UNC_OR_PARITY_ERR_SMASK \
		0x10000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_LINKDOWN_ERR_SMASK 0x10ull
#define SEND_EGRESS_ERR_STATUS_TX_PIO_LAUNCH_INTF_PARITY_ERR_SMASK 0x80ull
#define SEND_EGRESS_ERR_STATUS_TX_PKT_INTEGRITY_MEM_COR_ERR_SMASK 0x1ull
#define SEND_EGRESS_ERR_STATUS_TX_PKT_INTEGRITY_MEM_UNC_ERR_SMASK 0x2ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_PIO_MEMORY_COR_ERR_SMASK \
		0x1000000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_PIO_MEMORY_CSR_UNC_ERR_SMASK \
		0x8000000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_PIO_MEMORY_UNC_ERR_SMASK \
		0x100000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_SDMA_MEMORY_COR_ERR_SMASK \
		0x800000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_SDMA_MEMORY_CSR_UNC_ERR_SMASK \
		0x4000000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_READ_SDMA_MEMORY_UNC_ERR_SMASK \
		0x80000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SB_HDR_COR_ERR_SMASK 0x400000000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SB_HDR_UNC_ERR_SMASK 0x40000000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SBRD_CTL_CSR_PARITY_ERR_SMASK 0x4000ull
#define SEND_EGRESS_ERR_STATUS_TX_SBRD_CTL_STATE_MACHINE_PARITY_ERR_SMASK \
		0x800ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA0_DISALLOWED_PACKET_ERR_SMASK \
		0x10000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA10_DISALLOWED_PACKET_ERR_SMASK \
		0x4000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA11_DISALLOWED_PACKET_ERR_SMASK \
		0x8000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA12_DISALLOWED_PACKET_ERR_SMASK \
		0x10000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA13_DISALLOWED_PACKET_ERR_SMASK \
		0x20000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA14_DISALLOWED_PACKET_ERR_SMASK \
		0x40000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA15_DISALLOWED_PACKET_ERR_SMASK \
		0x80000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA1_DISALLOWED_PACKET_ERR_SMASK \
		0x20000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA2_DISALLOWED_PACKET_ERR_SMASK \
		0x40000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA3_DISALLOWED_PACKET_ERR_SMASK \
		0x80000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA4_DISALLOWED_PACKET_ERR_SMASK \
		0x100000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA5_DISALLOWED_PACKET_ERR_SMASK \
		0x200000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA6_DISALLOWED_PACKET_ERR_SMASK \
		0x400000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA7_DISALLOWED_PACKET_ERR_SMASK \
		0x800000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA8_DISALLOWED_PACKET_ERR_SMASK \
		0x1000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA9_DISALLOWED_PACKET_ERR_SMASK \
		0x2000000ull
#define SEND_EGRESS_ERR_STATUS_TX_SDMA_LAUNCH_INTF_PARITY_ERR_SMASK \
		0x100ull
#define SEND_EGRESS_SEND_DMA_STATUS (TXE + 0x000000000E00)
#define SEND_EGRESS_SEND_DMA_STATUS_SDMA_EGRESS_PACKET_OCCUPANCY_SHIFT 0
#define SEND_EGRESS_SEND_DMA_STATUS_SDMA_EGRESS_PACKET_OCCUPANCY_SMASK \
		0x3FFFull
#define SEND_ERR_CLEAR (TXE + 0x0000000000F0)
#define SEND_ERR_MASK (TXE + 0x0000000000E8)
#define SEND_ERR_STATUS (TXE + 0x0000000000E0)
#define SEND_ERR_STATUS_SEND_CSR_PARITY_ERR_SMASK 0x1ull
#define SEND_ERR_STATUS_SEND_CSR_READ_BAD_ADDR_ERR_SMASK 0x2ull
#define SEND_ERR_STATUS_SEND_CSR_WRITE_BAD_ADDR_ERR_SMASK 0x4ull
#define SEND_HIGH_PRIORITY_LIMIT (TXE + 0x000000000030)
#define SEND_HIGH_PRIORITY_LIMIT_LIMIT_MASK 0x3FFFull
#define SEND_HIGH_PRIORITY_LIMIT_LIMIT_SHIFT 0
#define SEND_HIGH_PRIORITY_LIST (TXE + 0x000000000180)
#define SEND_LEN_CHECK0 (TXE + 0x0000000000D0)
#define SEND_LEN_CHECK0_LEN_VL0_MASK 0xFFFull
#define SEND_LEN_CHECK0_LEN_VL1_SHIFT 12
#define SEND_LEN_CHECK1 (TXE + 0x0000000000D8)
#define SEND_LEN_CHECK1_LEN_VL15_MASK 0xFFFull
#define SEND_LEN_CHECK1_LEN_VL15_SHIFT 48
#define SEND_LEN_CHECK1_LEN_VL4_MASK 0xFFFull
#define SEND_LEN_CHECK1_LEN_VL5_SHIFT 12
#define SEND_LOW_PRIORITY_LIST (TXE + 0x000000000100)
#define SEND_LOW_PRIORITY_LIST_VL_MASK 0x7ull
#define SEND_LOW_PRIORITY_LIST_VL_SHIFT 16
#define SEND_LOW_PRIORITY_LIST_WEIGHT_MASK 0xFFull
#define SEND_LOW_PRIORITY_LIST_WEIGHT_SHIFT 0
#define SEND_PIO_ERR_CLEAR (TXE + 0x000000000050)
#define SEND_PIO_ERR_CLEAR_PIO_INIT_SM_IN_ERR_SMASK 0x20000ull
#define SEND_PIO_ERR_MASK (TXE + 0x000000000048)
#define SEND_PIO_ERR_STATUS (TXE + 0x000000000040)
#define SEND_PIO_ERR_STATUS_PIO_BLOCK_QW_COUNT_PARITY_ERR_SMASK \
		0x1000000ull
#define SEND_PIO_ERR_STATUS_PIO_CREDIT_RET_FIFO_PARITY_ERR_SMASK 0x8000ull
#define SEND_PIO_ERR_STATUS_PIO_CSR_PARITY_ERR_SMASK 0x4ull
#define SEND_PIO_ERR_STATUS_PIO_CURRENT_FREE_CNT_PARITY_ERR_SMASK \
		0x100000000ull
#define SEND_PIO_ERR_STATUS_PIO_HOST_ADDR_MEM_COR_ERR_SMASK 0x100000ull
#define SEND_PIO_ERR_STATUS_PIO_HOST_ADDR_MEM_UNC_ERR_SMASK 0x80000ull
#define SEND_PIO_ERR_STATUS_PIO_INIT_SM_IN_ERR_SMASK 0x20000ull
#define SEND_PIO_ERR_STATUS_PIO_LAST_RETURNED_CNT_PARITY_ERR_SMASK \
		0x200000000ull
#define SEND_PIO_ERR_STATUS_PIO_PCC_FIFO_PARITY_ERR_SMASK 0x20ull
#define SEND_PIO_ERR_STATUS_PIO_PCC_SOP_HEAD_PARITY_ERR_SMASK \
		0x400000000ull
#define SEND_PIO_ERR_STATUS_PIO_PEC_FIFO_PARITY_ERR_SMASK 0x40ull
#define SEND_PIO_ERR_STATUS_PIO_PEC_SOP_HEAD_PARITY_ERR_SMASK \
		0x800000000ull
#define SEND_PIO_ERR_STATUS_PIO_PKT_EVICT_FIFO_PARITY_ERR_SMASK 0x200ull
#define SEND_PIO_ERR_STATUS_PIO_PKT_EVICT_SM_OR_ARB_SM_ERR_SMASK 0x40000ull
#define SEND_PIO_ERR_STATUS_PIO_PPMC_BQC_MEM_PARITY_ERR_SMASK 0x10000000ull
#define SEND_PIO_ERR_STATUS_PIO_PPMC_PBL_FIFO_ERR_SMASK 0x10000ull
#define SEND_PIO_ERR_STATUS_PIO_PPMC_SOP_LEN_ERR_SMASK 0x20000000ull
#define SEND_PIO_ERR_STATUS_PIO_SB_MEM_FIFO0_ERR_SMASK 0x8ull
#define SEND_PIO_ERR_STATUS_PIO_SB_MEM_FIFO1_ERR_SMASK 0x10ull
#define SEND_PIO_ERR_STATUS_PIO_SBRDCTL_CRREL_PARITY_ERR_SMASK 0x80ull
#define SEND_PIO_ERR_STATUS_PIO_SBRDCTRL_CRREL_FIFO_PARITY_ERR_SMASK \
		0x100ull
#define SEND_PIO_ERR_STATUS_PIO_SM_PKT_RESET_PARITY_ERR_SMASK 0x400ull
#define SEND_PIO_ERR_STATUS_PIO_STATE_MACHINE_ERR_SMASK 0x400000ull
#define SEND_PIO_ERR_STATUS_PIO_VL_FIFO_PARITY_ERR_SMASK 0x8000000ull
#define SEND_PIO_ERR_STATUS_PIO_VLF_SOP_PARITY_ERR_SMASK 0x4000000ull
#define SEND_PIO_ERR_STATUS_PIO_VLF_VL_LEN_PARITY_ERR_SMASK 0x2000000ull
#define SEND_PIO_ERR_STATUS_PIO_VL_LEN_MEM_BANK0_COR_ERR_SMASK 0x2000ull
#define SEND_PIO_ERR_STATUS_PIO_VL_LEN_MEM_BANK0_UNC_ERR_SMASK 0x800ull
#define SEND_PIO_ERR_STATUS_PIO_VL_LEN_MEM_BANK1_COR_ERR_SMASK 0x4000ull
#define SEND_PIO_ERR_STATUS_PIO_VL_LEN_MEM_BANK1_UNC_ERR_SMASK 0x1000ull
#define SEND_PIO_ERR_STATUS_PIO_WRITE_ADDR_PARITY_ERR_SMASK 0x2ull
#define SEND_PIO_ERR_STATUS_PIO_WRITE_BAD_CTXT_ERR_SMASK 0x1ull
#define SEND_PIO_ERR_STATUS_PIO_WRITE_DATA_PARITY_ERR_SMASK 0x200000ull
#define SEND_PIO_ERR_STATUS_PIO_WRITE_QW_VALID_PARITY_ERR_SMASK 0x800000ull
#define SEND_PIO_INIT_CTXT (TXE + 0x000000000038)
#define SEND_PIO_INIT_CTXT_PIO_ALL_CTXT_INIT_SMASK 0x1ull
#define SEND_PIO_INIT_CTXT_PIO_CTXT_NUM_MASK 0xFFull
#define SEND_PIO_INIT_CTXT_PIO_CTXT_NUM_SHIFT 8
#define SEND_PIO_INIT_CTXT_PIO_INIT_ERR_SMASK 0x8ull
#define SEND_PIO_INIT_CTXT_PIO_INIT_IN_PROGRESS_SMASK 0x4ull
#define SEND_PIO_INIT_CTXT_PIO_SINGLE_CTXT_INIT_SMASK 0x2ull
#define SEND_PIO_MEM_SIZE (TXE + 0x000000000020)
#define SEND_SC2VLT0 (TXE + 0x0000000000B0)
#define SEND_SC2VLT0_SC0_SHIFT 0
#define SEND_SC2VLT0_SC1_SHIFT 8
#define SEND_SC2VLT0_SC2_SHIFT 16
#define SEND_SC2VLT0_SC3_SHIFT 24
#define SEND_SC2VLT0_SC4_SHIFT 32
#define SEND_SC2VLT0_SC5_SHIFT 40
#define SEND_SC2VLT0_SC6_SHIFT 48
#define SEND_SC2VLT0_SC7_SHIFT 56
#define SEND_SC2VLT1 (TXE + 0x0000000000B8)
#define SEND_SC2VLT1_SC10_SHIFT 16
#define SEND_SC2VLT1_SC11_SHIFT 24
#define SEND_SC2VLT1_SC12_SHIFT 32
#define SEND_SC2VLT1_SC13_SHIFT 40
#define SEND_SC2VLT1_SC14_SHIFT 48
#define SEND_SC2VLT1_SC15_SHIFT 56
#define SEND_SC2VLT1_SC8_SHIFT 0
#define SEND_SC2VLT1_SC9_SHIFT 8
#define SEND_SC2VLT2 (TXE + 0x0000000000C0)
#define SEND_SC2VLT2_SC16_SHIFT 0
#define SEND_SC2VLT2_SC17_SHIFT 8
#define SEND_SC2VLT2_SC18_SHIFT 16
#define SEND_SC2VLT2_SC19_SHIFT 24
#define SEND_SC2VLT2_SC20_SHIFT 32
#define SEND_SC2VLT2_SC21_SHIFT 40
#define SEND_SC2VLT2_SC22_SHIFT 48
#define SEND_SC2VLT2_SC23_SHIFT 56
#define SEND_SC2VLT3 (TXE + 0x0000000000C8)
#define SEND_SC2VLT3_SC24_SHIFT 0
#define SEND_SC2VLT3_SC25_SHIFT 8
#define SEND_SC2VLT3_SC26_SHIFT 16
#define SEND_SC2VLT3_SC27_SHIFT 24
#define SEND_SC2VLT3_SC28_SHIFT 32
#define SEND_SC2VLT3_SC29_SHIFT 40
#define SEND_SC2VLT3_SC30_SHIFT 48
#define SEND_SC2VLT3_SC31_SHIFT 56
#define SEND_STATIC_RATE_CONTROL (TXE + 0x0000000000A8)
#define SEND_STATIC_RATE_CONTROL_CSR_SRC_RELOAD_SHIFT 0
#define SEND_STATIC_RATE_CONTROL_CSR_SRC_RELOAD_SMASK 0xFFFFull
#define PCIE_CFG_REG_PL2 (PCIE + 0x000000000708)
#define PCIE_CFG_REG_PL3 (PCIE + 0x00000000070C)
#define PCIE_CFG_REG_PL3_L1_ENT_LATENCY_SHIFT 27
#define PCIE_CFG_REG_PL3_L1_ENT_LATENCY_SMASK 0x38000000
#define PCIE_CFG_REG_PL102 (PCIE + 0x000000000898)
#define PCIE_CFG_REG_PL102_GEN3_EQ_POST_CURSOR_PSET_SHIFT 12
#define PCIE_CFG_REG_PL102_GEN3_EQ_CURSOR_PSET_SHIFT 6
#define PCIE_CFG_REG_PL102_GEN3_EQ_PRE_CURSOR_PSET_SHIFT 0
#define PCIE_CFG_REG_PL103 (PCIE + 0x00000000089C)
#define PCIE_CFG_REG_PL105 (PCIE + 0x0000000008A4)
#define PCIE_CFG_REG_PL105_GEN3_EQ_VIOLATE_COEF_RULES_SMASK 0x1ull
#define PCIE_CFG_REG_PL2_LOW_PWR_ENT_CNT_SHIFT 24
#define PCIE_CFG_REG_PL100 (PCIE + 0x000000000890)
#define PCIE_CFG_REG_PL100_EQ_EIEOS_CNT_SMASK 0x400ull
#define PCIE_CFG_REG_PL101 (PCIE + 0x000000000894)
#define PCIE_CFG_REG_PL101_GEN3_EQ_LOCAL_FS_SHIFT 6
#define PCIE_CFG_REG_PL101_GEN3_EQ_LOCAL_LF_SHIFT 0
#define PCIE_CFG_REG_PL106 (PCIE + 0x0000000008A8)
#define PCIE_CFG_REG_PL106_GEN3_EQ_PSET_REQ_VEC_SHIFT 8
#define PCIE_CFG_REG_PL106_GEN3_EQ_EVAL2MS_DISABLE_SMASK 0x20ull
#define PCIE_CFG_REG_PL106_GEN3_EQ_PHASE23_EXIT_MODE_SMASK 0x10ull
#define CCE_INT_BLOCKED (CCE + 0x000000110C00)
#define SEND_DMA_IDLE_CNT (TXE + 0x000000200040)
#define SEND_DMA_DESC_FETCHED_CNT (TXE + 0x000000200058)
#define CCE_MSIX_PBA_OFFSET 0X0110000

#endif          /* DEF_CHIP_REG */
