; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -early-cse -opaque-pointers < %s | FileCheck %s

define i32 @different_types_load(ptr %p) {
; CHECK-LABEL: @different_types_load(
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[P]], align 4
; CHECK-NEXT:    [[V2_C:%.*]] = trunc i64 [[V2]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2_C]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %v1 = load i32, ptr %p
  %v2 = load i64, ptr %p
  %v2.c = trunc i64 %v2 to i32
  %sub = sub i32 %v1, %v2.c
  ret i32 %sub
}

define i32 @different_types_store(ptr %p, i32 %a) {
; CHECK-LABEL: @different_types_store(
; CHECK-NEXT:    store i32 [[A:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[P]], align 4
; CHECK-NEXT:    [[V2_C:%.*]] = trunc i64 [[V2]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[A]], [[V2_C]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  store i32 %a, ptr %p
  %v2 = load i64, ptr %p
  %v2.c = trunc i64 %v2 to i32
  %sub = sub i32 %a, %v2.c
  ret i32 %sub
}

define void @dse(ptr %p, i32 %i1, i8 %i2) {
; CHECK-LABEL: @dse(
; CHECK-NEXT:    store i32 [[I1:%.*]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    store i8 [[I2:%.*]], ptr [[P]], align 1
; CHECK-NEXT:    ret void
;
  store i32 %i1, ptr %p
  store i8 %i2, ptr %p
  ret void
}
