; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32I
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64I
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64f,+f -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32F
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64f,+f -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64F
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32D
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64D
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=8 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX8
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=8 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX8

define void @ctlz_v16i8(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: ctlz_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a1, 85
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a1, 51
; CHECK-NEXT:    vand.vx v9, v8, a1
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v16i8:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX8-NEXT:    vle8.v v8, (a0)
; LMULMAX8-NEXT:    vzext.vf2 v10, v8
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v10
; LMULMAX8-NEXT:    vnsrl.wi v8, v12, 23
; LMULMAX8-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; LMULMAX8-NEXT:    vnsrl.wi v10, v8, 0
; LMULMAX8-NEXT:    li a1, 134
; LMULMAX8-NEXT:    vrsub.vx v8, v10, a1
; LMULMAX8-NEXT:    li a1, 8
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse8.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <16 x i8>, ptr %x
  %b = load <16 x i8>, ptr %y
  %c = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
  store <16 x i8> %c, ptr %x
  ret void
}
declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>, i1)

define void @ctlz_v8i16(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: ctlz_v8i16:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 5
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 3
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 1
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    li a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV32I-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: ctlz_v8i16:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 5
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 3
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 1
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV64I-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctlz_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vnot.v v8, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vsub.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    lui a1, 3
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v9, v8, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    lui a1, 1
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    li a1, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctlz_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vnot.v v8, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    lui a1, 3
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v9, v8, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    lui a1, 1
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    li a1, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: ctlz_v8i16:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV32F-NEXT:    vnsrl.wi v8, v10, 23
; LMULMAX2-RV32F-NEXT:    li a1, 142
; LMULMAX2-RV32F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    li a1, 16
; LMULMAX2-RV32F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: ctlz_v8i16:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV64F-NEXT:    vnsrl.wi v8, v10, 23
; LMULMAX2-RV64F-NEXT:    li a1, 142
; LMULMAX2-RV64F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    li a1, 16
; LMULMAX2-RV64F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: ctlz_v8i16:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV32D-NEXT:    vnsrl.wi v8, v10, 23
; LMULMAX2-RV32D-NEXT:    li a1, 142
; LMULMAX2-RV32D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 16
; LMULMAX2-RV32D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: ctlz_v8i16:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV64D-NEXT:    vnsrl.wi v8, v10, 23
; LMULMAX2-RV64D-NEXT:    li a1, 142
; LMULMAX2-RV64D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 16
; LMULMAX2-RV64D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v8i16:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX8-NEXT:    vle16.v v8, (a0)
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX8-NEXT:    vnsrl.wi v8, v10, 23
; LMULMAX8-NEXT:    li a1, 142
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 16
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse16.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = load <8 x i16>, ptr %y
  %c = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
  store <8 x i16> %c, ptr %x
  ret void
}
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>, i1)

define void @ctlz_v4i32(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: ctlz_v4i32:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 16
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV32I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: ctlz_v4i32:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 16
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV64I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: ctlz_v4i32:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV32F-NEXT:    li a1, 158
; LMULMAX2-RV32F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    li a1, 32
; LMULMAX2-RV32F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: ctlz_v4i32:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV64F-NEXT:    li a1, 158
; LMULMAX2-RV64F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    li a1, 32
; LMULMAX2-RV64F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: ctlz_v4i32:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vnsrl.wx v8, v10, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1054
; LMULMAX2-RV32D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 32
; LMULMAX2-RV32D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: ctlz_v4i32:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vnsrl.wx v8, v10, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1054
; LMULMAX2-RV64D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 32
; LMULMAX2-RV64D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v4i32:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX8-NEXT:    vle32.v v8, (a0)
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v10, v8
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vnsrl.wx v8, v10, a1
; LMULMAX8-NEXT:    li a1, 1054
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse32.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = load <4 x i32>, ptr %y
  %c = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
  store <4 x i32> %c, ptr %x
  ret void
}
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)

define void @ctlz_v2i64(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: ctlz_v2i64:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 16
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    li a1, 32
; LMULMAX2-RV32I-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.i v9, -1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vxor.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v9, v9, v10
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v10, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmul.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    li a1, 56
; LMULMAX2-RV32I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: ctlz_v2i64:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 16
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    li a1, 32
; LMULMAX2-RV64I-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 56
; LMULMAX2-RV64I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: ctlz_v2i64:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    li a1, 190
; LMULMAX2-RV32F-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; LMULMAX2-RV32F-NEXT:    vfncvt.f.xu.w v10, v8
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v8, v10, 23
; LMULMAX2-RV32F-NEXT:    vwsubu.wv v9, v9, v8
; LMULMAX2-RV32F-NEXT:    li a1, 64
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vminu.vx v8, v9, a1
; LMULMAX2-RV32F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: ctlz_v2i64:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; LMULMAX2-RV64F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    li a1, 190
; LMULMAX2-RV64F-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfncvt.f.xu.w v10, v8
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v8, v10, 23
; LMULMAX2-RV64F-NEXT:    vwsubu.vv v10, v9, v8
; LMULMAX2-RV64F-NEXT:    li a1, 64
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vminu.vx v8, v10, a1
; LMULMAX2-RV64F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: ctlz_v2i64:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1086
; LMULMAX2-RV32D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 64
; LMULMAX2-RV32D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: ctlz_v2i64:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1086
; LMULMAX2-RV64D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 64
; LMULMAX2-RV64D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v2i64:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX8-NEXT:    vle64.v v8, (a0)
; LMULMAX8-NEXT:    fsrmi a1, 1
; LMULMAX8-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX8-NEXT:    fsrm a1
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 1086
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 64
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse64.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = load <2 x i64>, ptr %y
  %c = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
  store <2 x i64> %c, ptr %x
  ret void
}
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)

define void @ctlz_v32i8(ptr %x, ptr %y) nounwind {
; LMULMAX2-LABEL: ctlz_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    li a1, 32
; LMULMAX2-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; LMULMAX2-NEXT:    vle8.v v8, (a0)
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-NEXT:    vnot.v v8, v8
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-NEXT:    li a1, 85
; LMULMAX2-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-NEXT:    li a1, 51
; LMULMAX2-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-NEXT:    vand.vi v8, v8, 15
; LMULMAX2-NEXT:    vse8.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: ctlz_v32i8:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle8.v v8, (a1)
; LMULMAX1-NEXT:    vle8.v v9, (a0)
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-NEXT:    vnot.v v8, v8
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-NEXT:    li a2, 85
; LMULMAX1-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-NEXT:    li a3, 51
; LMULMAX1-NEXT:    vand.vx v10, v8, a3
; LMULMAX1-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-NEXT:    vand.vi v8, v8, 15
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-NEXT:    vnot.v v9, v9
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-NEXT:    vand.vx v10, v9, a3
; LMULMAX1-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-NEXT:    vand.vi v9, v9, 15
; LMULMAX1-NEXT:    vse8.v v9, (a0)
; LMULMAX1-NEXT:    vse8.v v8, (a1)
; LMULMAX1-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v32i8:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; LMULMAX8-NEXT:    vle8.v v8, (a0)
; LMULMAX8-NEXT:    vzext.vf2 v12, v8
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v16, v12
; LMULMAX8-NEXT:    vnsrl.wi v8, v16, 23
; LMULMAX8-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; LMULMAX8-NEXT:    vnsrl.wi v12, v8, 0
; LMULMAX8-NEXT:    li a1, 134
; LMULMAX8-NEXT:    vrsub.vx v8, v12, a1
; LMULMAX8-NEXT:    li a1, 8
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse8.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <32 x i8>, ptr %x
  %b = load <32 x i8>, ptr %y
  %c = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
  store <32 x i8> %c, ptr %x
  ret void
}
declare <32 x i8> @llvm.ctlz.v32i8(<32 x i8>, i1)

define void @ctlz_v16i16(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32-LABEL: ctlz_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    li a1, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctlz_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    li a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctlz_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vnot.v v8, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a2, 5
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    lui a3, 3
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v8, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    lui a4, 1
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    li a5, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v8, v8, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vnot.v v9, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vx v10, v9, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vmul.vx v9, v9, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctlz_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vnot.v v8, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a2, 5
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    lui a3, 3
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v8, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    lui a4, 1
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    li a5, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v8, v8, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vnot.v v9, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vand.vx v10, v9, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vmul.vx v9, v9, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v9, 8
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v16i16:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX8-NEXT:    vle16.v v8, (a0)
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v8
; LMULMAX8-NEXT:    vnsrl.wi v8, v12, 23
; LMULMAX8-NEXT:    li a1, 142
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 16
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse16.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <16 x i16>, ptr %x
  %b = load <16 x i16>, ptr %y
  %c = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
  store <16 x i16> %c, ptr %x
  ret void
}
declare <16 x i16> @llvm.ctlz.v16i16(<16 x i16>, i1)

define void @ctlz_v8i32(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: ctlz_v8i32:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 16
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV32I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: ctlz_v8i32:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 16
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV64I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: ctlz_v8i32:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV32F-NEXT:    li a1, 158
; LMULMAX2-RV32F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    li a1, 32
; LMULMAX2-RV32F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: ctlz_v8i32:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV64F-NEXT:    li a1, 158
; LMULMAX2-RV64F-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    li a1, 32
; LMULMAX2-RV64F-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: ctlz_v8i32:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV32D-NEXT:    li a1, 158
; LMULMAX2-RV32D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 32
; LMULMAX2-RV32D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: ctlz_v8i32:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    vsrl.vi v8, v8, 23
; LMULMAX2-RV64D-NEXT:    li a1, 158
; LMULMAX2-RV64D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 32
; LMULMAX2-RV64D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v8i32:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX8-NEXT:    vle32.v v8, (a0)
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v8
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vnsrl.wx v8, v12, a1
; LMULMAX8-NEXT:    li a1, 1054
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse32.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %b = load <8 x i32>, ptr %y
  %c = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
  store <8 x i32> %c, ptr %x
  ret void
}
declare <8 x i32> @llvm.ctlz.v8i32(<8 x i32>, i1)

define void @ctlz_v4i64(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: ctlz_v4i64:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 16
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    li a1, 32
; LMULMAX2-RV32I-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV32I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.i v10, -1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vxor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v12, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v12, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmul.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    li a1, 56
; LMULMAX2-RV32I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: ctlz_v4i64:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 16
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    li a1, 32
; LMULMAX2-RV64I-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 56
; LMULMAX2-RV64I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: ctlz_v4i64:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    li a1, 190
; LMULMAX2-RV32F-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vfncvt.f.xu.w v12, v8
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v8, v12, 23
; LMULMAX2-RV32F-NEXT:    vwsubu.wv v10, v10, v8
; LMULMAX2-RV32F-NEXT:    li a1, 64
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vminu.vx v8, v10, a1
; LMULMAX2-RV32F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: ctlz_v4i64:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    li a1, 190
; LMULMAX2-RV64F-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfncvt.f.xu.w v11, v8
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v8, v11, 23
; LMULMAX2-RV64F-NEXT:    vwsubu.vv v12, v10, v8
; LMULMAX2-RV64F-NEXT:    li a1, 64
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; LMULMAX2-RV64F-NEXT:    vminu.vx v8, v12, a1
; LMULMAX2-RV64F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: ctlz_v4i64:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1086
; LMULMAX2-RV32D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    li a1, 64
; LMULMAX2-RV32D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV32D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: ctlz_v4i64:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1086
; LMULMAX2-RV64D-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    li a1, 64
; LMULMAX2-RV64D-NEXT:    vminu.vx v8, v8, a1
; LMULMAX2-RV64D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: ctlz_v4i64:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX8-NEXT:    vle64.v v8, (a0)
; LMULMAX8-NEXT:    fsrmi a1, 1
; LMULMAX8-NEXT:    vfcvt.f.xu.v v8, v8
; LMULMAX8-NEXT:    fsrm a1
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 1086
; LMULMAX8-NEXT:    vrsub.vx v8, v8, a1
; LMULMAX8-NEXT:    li a1, 64
; LMULMAX8-NEXT:    vminu.vx v8, v8, a1
; LMULMAX8-NEXT:    vse64.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = load <4 x i64>, ptr %y
  %c = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
  store <4 x i64> %c, ptr %x
  ret void
}
declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1)
