// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s
// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s

v_bfrev_b32_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_bfrev_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_bfrev_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_bfrev_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_bfrev_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_bfrev_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_bfrev_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_bfrev_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_bfrev_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_bfrev_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_bfrev_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_bfrev_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_bfrev_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_bfrev_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x70,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_ceil_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ceil_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ceil_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ceil_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ceil_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ceil_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ceil_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ceil_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ceil_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ceil_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ceil_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ceil_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ceil_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xb8,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ceil_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xb8,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_ceil_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ceil_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ceil_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ceil_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ceil_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ceil_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ceil_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ceil_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ceil_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ceil_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ceil_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ceil_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ceil_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ceil_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x44,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cls_i32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cls_i32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cls_i32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cls_i32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cls_i32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cls_i32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cls_i32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cls_i32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cls_i32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cls_i32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cls_i32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cls_i32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cls_i32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cls_i32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x76,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_clz_i32_u32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_clz_i32_u32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_clz_i32_u32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_clz_i32_u32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_clz_i32_u32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_clz_i32_u32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_clz_i32_u32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_clz_i32_u32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_clz_i32_u32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_clz_i32_u32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_clz_i32_u32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_clz_i32_u32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_clz_i32_u32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_clz_i32_u32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x72,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cos_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cos_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cos_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cos_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cos_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cos_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cos_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cos_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cos_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cos_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cos_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cos_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cos_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xc2,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cos_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xc2,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_cos_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cos_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cos_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cos_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cos_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cos_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cos_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cos_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cos_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cos_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cos_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cos_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cos_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cos_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x6c,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_ctz_i32_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ctz_i32_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ctz_i32_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ctz_i32_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ctz_i32_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ctz_i32_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x74,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f16_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f16_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f16_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f16_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f16_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f16_f32 v127, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x14,0xfe,0x7e,0xff,0x6f,0x35,0x30]

v_cvt_f16_i16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f16_i16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f16_i16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f16_i16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f16_i16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xa2,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f16_i16 v127, v127 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xa2,0xfe,0x7e,0x7f,0x6f,0x05,0x30]

v_cvt_f16_u16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f16_u16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f16_u16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f16_u16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f16_u16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xa0,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f16_u16 v127, v127 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xa0,0xfe,0x7e,0x7f,0x6f,0x05,0x30]

v_cvt_f32_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_f16 v255, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x16,0xfe,0x7f,0x7f,0x6f,0x35,0x30]

v_cvt_f32_i32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_i32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_i32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_i32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_i32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_i32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x0a,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f32_u32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_u32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_u32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_u32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_u32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_u32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x0c,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte0 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte0 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte0 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte0 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte0 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte0 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x22,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte1 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte1 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte1 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte1 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte1 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte1 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x24,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte2 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte2 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte2 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte2 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte2 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte2 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x26,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte3 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte3 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte3 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte3 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte3 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte3 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x28,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_floor_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_floor_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_floor_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_floor_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_floor_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_floor_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x1a,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_flr_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_flr_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_flr_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_flr_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_flr_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_flr_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x1a,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_i16_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_i16_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_i16_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_i16_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_i16_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xa6,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_i16_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xa6,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_cvt_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x10,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_i32_i16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_i32_i16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_i32_i16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_i32_i16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_i32_i16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xd4,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_i32_i16 v255, v127 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xd4,0xfe,0x7f,0x7f,0x6f,0x05,0x30]

v_cvt_nearest_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_nearest_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_nearest_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_nearest_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_nearest_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x18,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_norm_i16_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_norm_i16_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_norm_i16_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_norm_i16_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_norm_i16_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xc6,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_norm_i16_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xc6,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_cvt_norm_u16_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_norm_u16_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_norm_u16_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_norm_u16_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_norm_u16_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xc8,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_norm_u16_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xc8,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_cvt_off_f32_i4 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_off_f32_i4 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_off_f32_i4 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_off_f32_i4 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_off_f32_i4 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_off_f32_i4 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x1c,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_cvt_rpi_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_rpi_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_rpi_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_rpi_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_rpi_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x18,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_u16_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_u16_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_u16_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_u16_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_u16_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xa4,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_u16_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xa4,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_cvt_u32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_u32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_u32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_u32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_u32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_u32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x0e,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_cvt_u32_u16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_cvt_u32_u16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_cvt_u32_u16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_cvt_u32_u16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_cvt_u32_u16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xd6,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_cvt_u32_u16 v255, v127 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xd6,0xfe,0x7f,0x7f,0x6f,0x05,0x30]

v_exp_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_exp_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_exp_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_exp_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_exp_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_exp_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_exp_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_exp_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_exp_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_exp_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_exp_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_exp_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_exp_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xb0,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_exp_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xb0,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_exp_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_exp_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_exp_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_exp_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_exp_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_exp_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_exp_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_exp_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_exp_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_exp_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_exp_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_exp_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_exp_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_exp_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x4a,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_ffbh_i32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ffbh_i32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ffbh_i32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ffbh_i32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ffbh_i32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ffbh_i32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ffbh_i32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ffbh_i32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ffbh_i32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ffbh_i32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ffbh_i32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ffbh_i32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ffbh_i32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x76,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ffbh_i32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x76,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_ffbh_u32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ffbh_u32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ffbh_u32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ffbh_u32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ffbh_u32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ffbh_u32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ffbh_u32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ffbh_u32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ffbh_u32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ffbh_u32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ffbh_u32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ffbh_u32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ffbh_u32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ffbh_u32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x72,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_ffbl_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_ffbl_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_ffbl_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_ffbl_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_ffbl_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_ffbl_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_ffbl_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_ffbl_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_ffbl_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_ffbl_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_ffbl_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_ffbl_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_ffbl_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_ffbl_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x74,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_floor_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_floor_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_floor_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_floor_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_floor_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_floor_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_floor_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_floor_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_floor_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_floor_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_floor_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_floor_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_floor_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xb6,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_floor_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xb6,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_floor_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_floor_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_floor_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_floor_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_floor_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_floor_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_floor_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_floor_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_floor_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_floor_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_floor_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_floor_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_floor_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_floor_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x48,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_fract_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_fract_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_fract_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_fract_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_fract_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_fract_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_fract_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_fract_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_fract_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_fract_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_fract_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_fract_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_fract_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xbe,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_fract_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xbe,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_fract_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_fract_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_fract_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_fract_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_fract_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_fract_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_fract_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_fract_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_fract_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_fract_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_fract_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_fract_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_fract_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_fract_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x40,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_frexp_exp_i16_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_frexp_exp_i16_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_frexp_exp_i16_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_frexp_exp_i16_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_frexp_exp_i16_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xb4,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_frexp_exp_i16_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xb4,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_frexp_exp_i32_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_frexp_exp_i32_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_frexp_exp_i32_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_frexp_exp_i32_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_frexp_exp_i32_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x7e,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_frexp_exp_i32_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x7e,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_frexp_mant_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_frexp_mant_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_frexp_mant_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_frexp_mant_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_frexp_mant_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xb2,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_frexp_mant_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xb2,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_frexp_mant_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_frexp_mant_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_frexp_mant_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_frexp_mant_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_frexp_mant_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x80,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_frexp_mant_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x80,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_log_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_log_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_log_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_log_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_log_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_log_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_log_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_log_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_log_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_log_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_log_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_log_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_log_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xae,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_log_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xae,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_log_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_log_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_log_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_log_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_log_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_log_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_log_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_log_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_log_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_log_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_log_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_log_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_log_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_log_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x4e,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_mov_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_mov_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_mov_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_mov_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_mov_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_mov_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_mov_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_mov_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_mov_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_mov_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_mov_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_mov_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_mov_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_mov_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x02,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_movreld_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_movreld_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_movreld_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_movreld_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_movreld_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_movreld_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_movreld_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_movreld_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_movreld_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_movreld_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_movreld_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_movreld_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_movreld_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x84,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_movreld_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x84,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_movrels_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_movrels_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_movrels_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_movrels_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_movrels_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_movrels_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_movrels_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_movrels_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_movrels_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_movrels_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_movrels_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_movrels_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_movrels_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x86,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_movrels_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x86,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_movrelsd_2_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_movrelsd_2_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_movrelsd_2_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_movrelsd_2_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_movrelsd_2_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x90,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_movrelsd_2_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x90,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_movrelsd_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_movrelsd_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_movrelsd_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_movrelsd_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_movrelsd_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_movrelsd_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_movrelsd_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_movrelsd_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_movrelsd_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_movrelsd_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_movrelsd_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_movrelsd_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_movrelsd_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x88,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_movrelsd_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x88,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_not_b16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_not_b16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_not_b16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_not_b16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_not_b16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_not_b16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_not_b16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_not_b16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_not_b16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_not_b16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_not_b16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_not_b16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_not_b16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xd2,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_not_b16 v127, v127 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xd2,0xfe,0x7e,0x7f,0x6f,0x05,0x30]

v_not_b32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_not_b32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_not_b32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_not_b32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_not_b32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_not_b32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_not_b32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_not_b32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_not_b32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_not_b32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_not_b32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_not_b32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_not_b32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_not_b32 v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x6e,0xfe,0x7f,0xff,0x6f,0x05,0x30]

v_rcp_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rcp_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rcp_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rcp_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rcp_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rcp_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rcp_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rcp_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rcp_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rcp_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rcp_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rcp_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rcp_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xa8,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rcp_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xa8,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_rcp_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rcp_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rcp_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rcp_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rcp_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rcp_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rcp_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rcp_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rcp_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rcp_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rcp_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rcp_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rcp_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rcp_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x54,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_rcp_iflag_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rcp_iflag_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rcp_iflag_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rcp_iflag_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rcp_iflag_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rcp_iflag_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x56,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_rndne_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rndne_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rndne_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rndne_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rndne_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rndne_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rndne_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rndne_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rndne_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rndne_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rndne_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rndne_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rndne_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xbc,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rndne_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xbc,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_rndne_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rndne_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rndne_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rndne_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rndne_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rndne_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rndne_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rndne_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rndne_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rndne_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rndne_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rndne_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rndne_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rndne_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x46,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_rsq_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rsq_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rsq_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rsq_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rsq_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rsq_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rsq_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rsq_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rsq_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rsq_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rsq_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rsq_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rsq_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xac,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rsq_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xac,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_rsq_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_rsq_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_rsq_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_rsq_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_rsq_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_rsq_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_rsq_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_rsq_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_rsq_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_rsq_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_rsq_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_rsq_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_rsq_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_rsq_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x5c,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_sat_pk_u8_i16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_sat_pk_u8_i16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_sat_pk_u8_i16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_sat_pk_u8_i16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_sat_pk_u8_i16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xc4,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_sat_pk_u8_i16 v127, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xc4,0xfe,0x7e,0xff,0x6f,0x05,0x30]

v_sin_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_sin_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_sin_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_sin_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_sin_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_sin_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_sin_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_sin_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_sin_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_sin_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_sin_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_sin_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_sin_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xc0,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_sin_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xc0,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_sin_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_sin_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_sin_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_sin_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_sin_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_sin_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_sin_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_sin_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_sin_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_sin_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_sin_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_sin_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_sin_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_sin_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x6a,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_sqrt_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_sqrt_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_sqrt_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_sqrt_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_sqrt_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_sqrt_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_sqrt_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_sqrt_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_sqrt_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_sqrt_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_sqrt_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_sqrt_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_sqrt_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xaa,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_sqrt_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xaa,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_sqrt_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_sqrt_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_sqrt_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_sqrt_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_sqrt_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_sqrt_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_sqrt_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_sqrt_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_sqrt_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_sqrt_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_sqrt_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_sqrt_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_sqrt_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_sqrt_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x66,0xfe,0x7f,0xff,0x6f,0x35,0x30]

v_trunc_f16 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_trunc_f16 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_trunc_f16 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_trunc_f16 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_trunc_f16 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_trunc_f16 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_trunc_f16 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_trunc_f16 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_trunc_f16 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_trunc_f16 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_trunc_f16 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_trunc_f16 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_trunc_f16 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0xba,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_trunc_f16 v127, -|v127| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0xba,0xfe,0x7e,0x7f,0x6f,0x35,0x30]

v_trunc_f32 v5, v1 quad_perm:[3,2,1,0]
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1b,0x00,0xff]

v_trunc_f32 v5, v1 quad_perm:[0,1,2,3]
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xff]

v_trunc_f32 v5, v1 row_mirror
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x40,0x01,0xff]

v_trunc_f32 v5, v1 row_half_mirror
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x41,0x01,0xff]

v_trunc_f32 v5, v1 row_shl:1
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x01,0x01,0xff]

v_trunc_f32 v5, v1 row_shl:15
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x0f,0x01,0xff]

v_trunc_f32 v5, v1 row_shr:1
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x11,0x01,0xff]

v_trunc_f32 v5, v1 row_shr:15
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1f,0x01,0xff]

v_trunc_f32 v5, v1 row_ror:1
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x21,0x01,0xff]

v_trunc_f32 v5, v1 row_ror:15
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x2f,0x01,0xff]

v_trunc_f32 v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x50,0x01,0xff]

v_trunc_f32 v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x5f,0x01,0x01]

v_trunc_f32 v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x60,0x09,0x13]

v_trunc_f32 v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: encoding: [0xfa,0x42,0xfe,0x7f,0xff,0x6f,0x35,0x30]
