; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; Test that the ffs library call simplifier works correctly even for
; targets with 16-bit int.
;
; RUN: opt < %s -mtriple=avr-linux -passes=instcombine -S | FileCheck %s
; RUN: opt < %s -mtriple=msp430-linux -passes=instcombine -S | FileCheck %s

declare i16 @ffs(i16)

declare void @sink(i16)


define void @fold_ffs(i16 %x) {
; CHECK-LABEL: @fold_ffs(
; CHECK-NEXT:    call void @sink(i16 0)
; CHECK-NEXT:    call void @sink(i16 1)
; CHECK-NEXT:    [[CTTZ:%.*]] = call i16 @llvm.cttz.i16(i16 [[X:%.*]], i1 true), !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw nsw i16 [[CTTZ]], 1
; CHECK-NEXT:    [[DOTNOT:%.*]] = icmp eq i16 [[X]], 0
; CHECK-NEXT:    [[NX:%.*]] = select i1 [[DOTNOT]], i16 0, i16 [[TMP1]]
; CHECK-NEXT:    call void @sink(i16 [[NX]])
; CHECK-NEXT:    ret void
;
  %n0 = call i16 @ffs(i16 0)
  call void @sink(i16 %n0)

  %n1 = call i16 @ffs(i16 1)
  call void @sink(i16 %n1)

  %nx = call i16 @ffs(i16 %x)
  call void @sink(i16 %nx)

  ret void
}
