; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=licm -verify-memoryssa < %s | FileCheck %s

; x - iv < 4 ==> iv > x - 4
define i32 @test_01(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_01
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4, !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[INVARIANT_OP:%.*]] = sub nsw i32 [[X]], 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp sgt i32 [[IV]], [[INVARIANT_OP]]
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %x = load i32, ptr %x_p, !range !0
  %length = load i32, ptr %length_p, !range !0
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = sub nsw i32 %x, %iv
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1
}

; TODO: x - iv < 4 ==> iv > x - 4
define i32 @test_01a(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_01a
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4
; CHECK-NEXT:    [[PRECOND_1:%.*]] = icmp sge i32 [[X]], 0
; CHECK-NEXT:    [[PRECOND_2:%.*]] = icmp sge i32 [[LENGTH]], 0
; CHECK-NEXT:    [[PRECOND:%.*]] = and i1 [[PRECOND_1]], [[PRECOND_2]]
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP_PREHEADER:%.*]], label [[FAILED:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[ARITH:%.*]] = sub nsw i32 [[X]], [[IV]]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[ARITH]], 4
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
; CHECK:       failed:
; CHECK-NEXT:    ret i32 -2
;
entry:
  %x = load i32, ptr %x_p
  %length = load i32, ptr %length_p
  %precond_1 = icmp sge i32 %x, 0
  %precond_2 = icmp sge i32 %length, 0
  %precond = and i1 %precond_1, %precond_2
  br i1 %precond, label %loop, label %failed

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = sub nsw i32 %x, %iv
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1

failed:
  ret i32 -2
}

; Range info is missing for x, cannot prove no-overflow. Should not hoist.
define i32 @test_01_neg(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_01_neg
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[ARITH:%.*]] = sub nsw i32 [[X]], [[IV]]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[ARITH]], 4
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %x = load i32, ptr %x_p
  %length = load i32, ptr %length_p, !range !0
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = sub nsw i32 %x, %iv
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1
}


; x + iv < 4 ==> iv < 4 - x
define i32 @test_02(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_02
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[INVARIANT_OP:%.*]] = sub nsw i32 4, [[X]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[IV]], [[INVARIANT_OP]]
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %x = load i32, ptr %x_p, !range !0
  %length = load i32, ptr %length_p, !range !0
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = add nsw i32 %x, %iv
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1
}

; TODO: x + iv < 4 ==> iv < 4 - x
define i32 @test_02a(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_02a
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4
; CHECK-NEXT:    [[PRECOND_1:%.*]] = icmp sge i32 [[X]], 0
; CHECK-NEXT:    [[PRECOND_2:%.*]] = icmp sge i32 [[LENGTH]], 0
; CHECK-NEXT:    [[PRECOND:%.*]] = and i1 [[PRECOND_1]], [[PRECOND_2]]
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP_PREHEADER:%.*]], label [[FAILED:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[ARITH:%.*]] = add nsw i32 [[X]], [[IV]]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[ARITH]], 4
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
; CHECK:       failed:
; CHECK-NEXT:    ret i32 -2
;
entry:
  %x = load i32, ptr %x_p
  %length = load i32, ptr %length_p
  %precond_1 = icmp sge i32 %x, 0
  %precond_2 = icmp sge i32 %length, 0
  %precond = and i1 %precond_1, %precond_2
  br i1 %precond, label %loop, label %failed

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = add nsw i32 %x, %iv
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1

failed:
  ret i32 -2
}

; iv - x < 4 ==> iv < 4 + x
define i32 @test_03(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_03
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4, !range [[RNG1:![0-9]+]]
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[INVARIANT_OP:%.*]] = add nsw i32 [[X]], 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[IV]], [[INVARIANT_OP]]
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %x = load i32, ptr %x_p, !range !1
  %length = load i32, ptr %length_p, !range !0
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = sub nsw i32 %iv, %x
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1
}

; TODO: iv - x < 4 ==> iv < 4 + x
define i32 @test_03a(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_03a
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4
; CHECK-NEXT:    [[PRECOND_1:%.*]] = icmp ult i32 [[X]], 2147483640
; CHECK-NEXT:    [[PRECOND_2:%.*]] = icmp sge i32 [[LENGTH]], 0
; CHECK-NEXT:    [[PRECOND:%.*]] = and i1 [[PRECOND_1]], [[PRECOND_2]]
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP_PREHEADER:%.*]], label [[FAILED:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[ARITH:%.*]] = sub nsw i32 [[IV]], [[X]]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[ARITH]], 4
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
; CHECK:       failed:
; CHECK-NEXT:    ret i32 -2
;
entry:
  %x = load i32, ptr %x_p
  %length = load i32, ptr %length_p
  %precond_1 = icmp ult i32 %x, 2147483640
  %precond_2 = icmp sge i32 %length, 0
  %precond = and i1 %precond_1, %precond_2
  br i1 %precond, label %loop, label %failed

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = sub nsw i32 %iv, %x
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1

failed:
  ret i32 -2
}

; iv + x < 4 ==> iv < 4 - x
define i32 @test_04(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_04
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4, !range [[RNG0]]
; CHECK-NEXT:    [[INVARIANT_OP:%.*]] = sub nsw i32 4, [[X]]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[IV]], [[INVARIANT_OP]]
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
;
entry:
  %x = load i32, ptr %x_p, !range !0
  %length = load i32, ptr %length_p, !range !0
  br label %loop

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = add nsw i32 %iv, %x
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1
}

; TODO: iv + x < 4 ==> iv < 4 - x
define i32 @test_04a(ptr %p, ptr %x_p, ptr %length_p) {
; CHECK-LABEL: define i32 @test_04a
; CHECK-SAME: (ptr [[P:%.*]], ptr [[X_P:%.*]], ptr [[LENGTH_P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = load i32, ptr [[X_P]], align 4
; CHECK-NEXT:    [[LENGTH:%.*]] = load i32, ptr [[LENGTH_P]], align 4
; CHECK-NEXT:    [[PRECOND_1:%.*]] = icmp sge i32 [[X]], 0
; CHECK-NEXT:    [[PRECOND_2:%.*]] = icmp sge i32 [[LENGTH]], 0
; CHECK-NEXT:    [[PRECOND:%.*]] = and i1 [[PRECOND_1]], [[PRECOND_2]]
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP_PREHEADER:%.*]], label [[FAILED:%.*]]
; CHECK:       loop.preheader:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ 0, [[LOOP_PREHEADER]] ]
; CHECK-NEXT:    [[ARITH:%.*]] = add nsw i32 [[IV]], [[X]]
; CHECK-NEXT:    [[X_CHECK:%.*]] = icmp slt i32 [[ARITH]], 4
; CHECK-NEXT:    br i1 [[X_CHECK]], label [[OUT_OF_BOUNDS:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[EL_PTR:%.*]] = getelementptr i32, ptr [[P]], i32 [[IV]]
; CHECK-NEXT:    store i32 1, ptr [[EL_PTR]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV_NEXT]], [[LENGTH]]
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ [[IV_NEXT]], [[BACKEDGE]] ]
; CHECK-NEXT:    ret i32 [[IV_NEXT_LCSSA]]
; CHECK:       out_of_bounds:
; CHECK-NEXT:    ret i32 -1
; CHECK:       failed:
; CHECK-NEXT:    ret i32 -2
;
entry:
  %x = load i32, ptr %x_p
  %length = load i32, ptr %length_p
  %precond_1 = icmp sge i32 %x, 0
  %precond_2 = icmp sge i32 %length, 0
  %precond = and i1 %precond_1, %precond_2
  br i1 %precond, label %loop, label %failed

loop:
  %iv = phi i32 [0, %entry], [%iv.next, %backedge]
  %arith = add nsw i32 %iv, %x
  %x_check = icmp slt i32 %arith, 4
  br i1 %x_check, label %out_of_bounds, label %backedge

backedge:
  %el.ptr = getelementptr i32, ptr %p, i32 %iv
  store i32 1, ptr %el.ptr
  %iv.next = add nuw nsw i32 %iv, 4
  %loop_cond = icmp slt i32 %iv.next, %length
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret i32 %iv.next

out_of_bounds:
  ret i32 -1

failed:
  ret i32 -2
}

!0 = !{i32 0, i32 2147483648}
!1 = !{i32 0, i32 2147483640}
