; This is an end-to-end test that checks that LSV succeeds at vectorizing a
; large program with many loads.
; RUN: opt -mtriple=nvptx64-nvidia-cuda -passes=load-store-vectorizer -S -o - %s > %t
; RUN: grep 'load i8' < %t | count 18
; RUN: grep 'load <2 x i8>' < %t | count 9
; RUN: grep 'load <4 x i8>' < %t | count 27

target datalayout = "e-i64:64-i128:128-v16:16-v32:32-n16:32:64"
target triple = "nvptx64-nvidia-cuda"

declare noundef i32 @llvm.nvvm.read.ptx.sreg.ctaid.x() #0
declare noundef i32 @llvm.nvvm.read.ptx.sreg.tid.x() #0
declare float @llvm.ceil.f32(float) #0
declare i32 @llvm.smax.i32(i32, i32) #0
declare i32 @llvm.umin.i32(i32, i32) #0

define void @many_loads(ptr noalias readonly align 128 dereferenceable(5111808) %arg0, ptr noalias nocapture readonly align 128 dereferenceable(29952) %arg1, ptr noalias nocapture readonly align 128 dereferenceable(2664) %arg2, ptr noalias nocapture readonly align 128 dereferenceable(888) %arg3, ptr noalias nocapture writeonly align 128 dereferenceable(17731584) %arg4) local_unnamed_addr #1 {
entry:
  %arg41104 = addrspacecast ptr %arg4 to ptr addrspace(1)
  %arg31102 = addrspacecast ptr %arg3 to ptr addrspace(1)
  %arg21100 = addrspacecast ptr %arg2 to ptr addrspace(1)
  %arg11098 = addrspacecast ptr %arg1 to ptr addrspace(1)
  %arg01096 = addrspacecast ptr %arg0 to ptr addrspace(1)
  %0 = tail call i32 @llvm.nvvm.read.ptx.sreg.ctaid.x(), !range !140
  %1 = tail call i32 @llvm.nvvm.read.ptx.sreg.tid.x(), !range !141
  %2 = shl nuw nsw i32 %0, 6
  %linear_index = or i32 %2, %1
  %linear_index_base = shl nuw nsw i32 %linear_index, 4
  %.urem = add nsw i32 %linear_index, -554112
  %.cmp = icmp ult i32 %linear_index, 554112
  %3 = select i1 %.cmp, i32 %linear_index, i32 %.urem
  %4 = urem i32 %linear_index, 2496
  %.lhs.trunc = trunc i32 %0 to i16
  %5 = udiv i16 %.lhs.trunc, 39
  %.zext = zext i16 %5 to i32
  %6 = mul nuw nsw i32 %.zext, 2496
  %7 = add nuw nsw i32 %6, %4
  %8 = udiv i32 %7, 222
  %9 = mul i32 %8, 222
  %.decomposed = sub i32 %7, %9
  %10 = mul nuw nsw i32 %8, 3
  %11 = mul nuw nsw i32 %.decomposed, 3
  %12 = uitofp i32 %8 to float
  %add.26 = fadd float %12, -1.000000e+00
  %13 = tail call float @llvm.ceil.f32(float %add.26)
  %14 = fcmp ole float %13, 0.000000e+00
  %15 = select i1 %14, float 0.000000e+00, float %13
  %16 = fcmp oge float %15, 2.493000e+03
  %17 = select i1 %16, float 2.493000e+03, float %15
  %.inv = fcmp ole float %17, 0xC1E0000000000000
  %18 = select i1 %.inv, float 0xC1E0000000000000, float %17
  %19 = fptosi float %18 to i32
  %20 = fcmp oge float %17, 0x41E0000000000000
  %21 = tail call i32 @llvm.smax.i32(i32 %19, i32 0)
  %22 = tail call i32 @llvm.umin.i32(i32 %21, i32 2493)
  %23 = select i1 %20, i32 2493, i32 %22
  %24 = uitofp i32 %.decomposed to float
  %add.3613 = fadd float %24, 5.000000e-01
  %multiply.3915 = fmul float %add.3613, 0x3FE27350C0000000
  %add.4217 = fadd float %multiply.3915, -1.500000e+00
  %25 = tail call float @llvm.ceil.f32(float %add.4217)
  %26 = fcmp ole float %25, 0.000000e+00
  %27 = select i1 %26, float 0.000000e+00, float %25
  %28 = fcmp oge float %27, 1.250000e+02
  %29 = select i1 %28, float 1.250000e+02, float %27
  %.inv821 = fcmp ole float %29, 0xC1E0000000000000
  %30 = select i1 %.inv821, float 0xC1E0000000000000, float %29
  %31 = fptosi float %30 to i32
  %32 = fcmp oge float %29, 0x41E0000000000000
  %33 = tail call i32 @llvm.smax.i32(i32 %31, i32 0)
  %34 = fcmp uno float %29, 0.000000e+00
  %35 = tail call i32 @llvm.umin.i32(i32 %33, i32 125)
  %36 = select i1 %32, i32 125, i32 %35
  %37 = select i1 %34, i32 0, i32 %36
  %.lhs.trunc1053 = trunc i32 %11 to i16
  %38 = udiv i16 %.lhs.trunc1053, 3
  %39 = mul i16 %38, 3
  %.decomposed1089 = sub i16 %.lhs.trunc1053, %39
  %40 = zext i16 %38 to i64
  %41 = zext i16 %.decomposed1089 to i64
  %42 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %40, i64 %41
  %43 = load float, ptr addrspace(1) %42, align 4, !invariant.load !142
  %44 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %40
  %45 = load float, ptr addrspace(1) %44, align 4, !invariant.load !142
  %divide.6 = fdiv float %43, %45
  %46 = zext i32 %10 to i64
  %47 = getelementptr inbounds [7488 x float], ptr addrspace(1) %arg11098, i64 0, i64 %46
  %48 = load float, ptr addrspace(1) %47, align 4, !invariant.load !142
  %multiply.10 = fmul float %divide.6, %48
  %49 = zext i32 %23 to i64
  %50 = zext i32 %37 to i64
  %51 = getelementptr inbounds [1 x [4 x [2496 x [128 x [4 x i8]]]]], ptr addrspace(1) %arg01096, i64 0, i64 0, i64 0, i64 %49, i64 %50, i64 0
  %52 = load i8, ptr addrspace(1) %51, align 4, !invariant.load !142
  %53 = sitofp i8 %52 to float
  %multiply.18 = fmul float %53, 0x3FC3BF2820000000
  %multiply.53 = fmul float %multiply.10, %multiply.18
  %add.57.i = fadd float %multiply.53, 0.000000e+00
  %.lhs.trunc1053.1 = add nuw nsw i16 %.lhs.trunc1053, 1
  %54 = udiv i16 %.lhs.trunc1053.1, 3
  %55 = mul i16 %54, 3
  %.decomposed1090 = sub i16 %.lhs.trunc1053.1, %55
  %56 = zext i16 %54 to i64
  %57 = zext i16 %.decomposed1090 to i64
  %58 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %56, i64 %57
  %59 = load float, ptr addrspace(1) %58, align 4, !invariant.load !142
  %60 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %56
  %61 = load float, ptr addrspace(1) %60, align 4, !invariant.load !142
  %divide.6.1 = fdiv float %59, %61
  %multiply.10.1 = fmul float %divide.6.1, %48
  %62 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 4
  %63 = load i8, ptr addrspace(1) %62, align 4, !invariant.load !142
  %64 = sitofp i8 %63 to float
  %multiply.18.1 = fmul float %64, 0x3FC3BF2820000000
  %multiply.53.1 = fmul float %multiply.10.1, %multiply.18.1
  %add.57.i.1 = fadd float %add.57.i, %multiply.53.1
  %.lhs.trunc1053.2 = add nuw nsw i16 %.lhs.trunc1053, 2
  %65 = udiv i16 %.lhs.trunc1053.2, 3
  %66 = mul i16 %65, 3
  %.decomposed1091 = sub i16 %.lhs.trunc1053.2, %66
  %67 = zext i16 %65 to i64
  %68 = zext i16 %.decomposed1091 to i64
  %69 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %67, i64 %68
  %70 = load float, ptr addrspace(1) %69, align 4, !invariant.load !142
  %71 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %67
  %72 = load float, ptr addrspace(1) %71, align 4, !invariant.load !142
  %divide.6.2 = fdiv float %70, %72
  %multiply.10.2 = fmul float %divide.6.2, %48
  %73 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 8
  %74 = load i8, ptr addrspace(1) %73, align 4, !invariant.load !142
  %75 = sitofp i8 %74 to float
  %multiply.18.2 = fmul float %75, 0x3FC3BF2820000000
  %multiply.53.2 = fmul float %multiply.10.2, %multiply.18.2
  %add.57.i.2 = fadd float %add.57.i.1, %multiply.53.2
  %76 = getelementptr inbounds float, ptr addrspace(1) %47, i64 1
  %77 = load float, ptr addrspace(1) %76, align 4, !invariant.load !142
  %multiply.10.3 = fmul float %divide.6, %77
  %78 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 512
  %79 = load i8, ptr addrspace(1) %78, align 4, !invariant.load !142
  %80 = sitofp i8 %79 to float
  %multiply.18.3 = fmul float %80, 0x3FC3BF2820000000
  %multiply.53.3 = fmul float %multiply.10.3, %multiply.18.3
  %add.57.i.3 = fadd float %add.57.i.2, %multiply.53.3
  %multiply.10.4 = fmul float %divide.6.1, %77
  %81 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 516
  %82 = load i8, ptr addrspace(1) %81, align 4, !invariant.load !142
  %83 = sitofp i8 %82 to float
  %multiply.18.4 = fmul float %83, 0x3FC3BF2820000000
  %multiply.53.4 = fmul float %multiply.10.4, %multiply.18.4
  %add.57.i.4 = fadd float %add.57.i.3, %multiply.53.4
  %multiply.10.5 = fmul float %divide.6.2, %77
  %84 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 520
  %85 = load i8, ptr addrspace(1) %84, align 4, !invariant.load !142
  %86 = sitofp i8 %85 to float
  %multiply.18.5 = fmul float %86, 0x3FC3BF2820000000
  %multiply.53.5 = fmul float %multiply.10.5, %multiply.18.5
  %add.57.i.5 = fadd float %add.57.i.4, %multiply.53.5
  %87 = getelementptr inbounds float, ptr addrspace(1) %47, i64 2
  %88 = load float, ptr addrspace(1) %87, align 4, !invariant.load !142
  %multiply.10.6 = fmul float %divide.6, %88
  %89 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 1024
  %90 = load i8, ptr addrspace(1) %89, align 4, !invariant.load !142
  %91 = sitofp i8 %90 to float
  %multiply.18.6 = fmul float %91, 0x3FC3BF2820000000
  %multiply.53.6 = fmul float %multiply.10.6, %multiply.18.6
  %add.57.i.6 = fadd float %add.57.i.5, %multiply.53.6
  %multiply.10.7 = fmul float %divide.6.1, %88
  %92 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 1028
  %93 = load i8, ptr addrspace(1) %92, align 4, !invariant.load !142
  %94 = sitofp i8 %93 to float
  %multiply.18.7 = fmul float %94, 0x3FC3BF2820000000
  %multiply.53.7 = fmul float %multiply.10.7, %multiply.18.7
  %add.57.i.7 = fadd float %add.57.i.6, %multiply.53.7
  %multiply.10.8 = fmul float %divide.6.2, %88
  %95 = getelementptr inbounds i8, ptr addrspace(1) %51, i64 1032
  %96 = load i8, ptr addrspace(1) %95, align 4, !invariant.load !142
  %97 = sitofp i8 %96 to float
  %multiply.18.8 = fmul float %97, 0x3FC3BF2820000000
  %multiply.53.8 = fmul float %multiply.10.8, %multiply.18.8
  %add.57.i.8 = fadd float %add.57.i.7, %multiply.53.8
  %98 = fptrunc float %add.57.i.8 to half
  %99 = zext i32 %linear_index_base to i64
  %100 = getelementptr half, ptr addrspace(1) %arg41104, i64 %99
  store half %98, ptr addrspace(1) %100, align 32
  %101 = udiv i32 %3, 222
  %102 = mul i32 %101, 222
  %.decomposed1092 = sub i32 %3, %102
  %103 = mul nuw nsw i32 %101, 3
  %104 = mul nuw nsw i32 %.decomposed1092, 3
  %105 = uitofp i32 %101 to float
  %add.2637 = fadd float %105, -1.000000e+00
  %106 = tail call float @llvm.ceil.f32(float %add.2637)
  %107 = fcmp ole float %106, 0.000000e+00
  %108 = select i1 %107, float 0.000000e+00, float %106
  %109 = fcmp oge float %108, 2.493000e+03
  %110 = select i1 %109, float 2.493000e+03, float %108
  %.inv824 = fcmp ole float %110, 0xC1E0000000000000
  %111 = select i1 %.inv824, float 0xC1E0000000000000, float %110
  %112 = fptosi float %111 to i32
  %113 = fcmp oge float %110, 0x41E0000000000000
  %114 = tail call i32 @llvm.smax.i32(i32 %112, i32 0)
  %115 = tail call i32 @llvm.umin.i32(i32 %114, i32 2493)
  %116 = select i1 %113, i32 2493, i32 %115
  %117 = uitofp i32 %.decomposed1092 to float
  %add.3660 = fadd float %117, 5.000000e-01
  %multiply.3962 = fmul float %add.3660, 0x3FE27350C0000000
  %add.4264 = fadd float %multiply.3962, -1.500000e+00
  %118 = tail call float @llvm.ceil.f32(float %add.4264)
  %119 = fcmp ole float %118, 0.000000e+00
  %120 = select i1 %119, float 0.000000e+00, float %118
  %121 = fcmp oge float %120, 1.250000e+02
  %122 = select i1 %121, float 1.250000e+02, float %120
  %.inv827 = fcmp ole float %122, 0xC1E0000000000000
  %123 = select i1 %.inv827, float 0xC1E0000000000000, float %122
  %124 = fptosi float %123 to i32
  %125 = fcmp oge float %122, 0x41E0000000000000
  %126 = tail call i32 @llvm.smax.i32(i32 %124, i32 0)
  %127 = fcmp uno float %122, 0.000000e+00
  %128 = tail call i32 @llvm.umin.i32(i32 %126, i32 125)
  %129 = select i1 %125, i32 125, i32 %128
  %130 = select i1 %127, i32 0, i32 %129
  %.lhs.trunc1045 = trunc i32 %104 to i16
  %131 = udiv i16 %.lhs.trunc1045, 3
  %132 = mul i16 %131, 3
  %.decomposed1093 = sub i16 %.lhs.trunc1045, %132
  %133 = zext i16 %131 to i64
  %134 = zext i16 %.decomposed1093 to i64
  %135 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %133, i64 %134
  %136 = load float, ptr addrspace(1) %135, align 4, !invariant.load !142
  %137 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %133
  %138 = load float, ptr addrspace(1) %137, align 4, !invariant.load !142
  %divide.631 = fdiv float %136, %138
  %139 = zext i32 %103 to i64
  %140 = getelementptr inbounds [7488 x float], ptr addrspace(1) %arg11098, i64 0, i64 %139
  %141 = load float, ptr addrspace(1) %140, align 4, !invariant.load !142
  %multiply.1032 = fmul float %divide.631, %141
  %142 = zext i32 %116 to i64
  %143 = zext i32 %130 to i64
  %144 = getelementptr [1 x [4 x [2496 x [128 x [4 x i8]]]]], ptr addrspace(1) %arg01096, i64 0, i64 0, i64 0, i64 %142, i64 %143, i64 0
  %145 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1
  %146 = load i8, ptr addrspace(1) %145, align 1, !invariant.load !142
  %147 = sitofp i8 %146 to float
  %multiply.1870 = fmul float %147, 0x3FC3BF2820000000
  %multiply.5371 = fmul float %multiply.1032, %multiply.1870
  %add.57.i914 = fadd float %multiply.5371, 0.000000e+00
  %.lhs.trunc1045.1 = add nuw nsw i16 %.lhs.trunc1045, 1
  %148 = udiv i16 %.lhs.trunc1045.1, 3
  %149 = mul i16 %148, 3
  %.decomposed1094 = sub i16 %.lhs.trunc1045.1, %149
  %150 = zext i16 %148 to i64
  %151 = zext i16 %.decomposed1094 to i64
  %152 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %150, i64 %151
  %153 = load float, ptr addrspace(1) %152, align 4, !invariant.load !142
  %154 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %150
  %155 = load float, ptr addrspace(1) %154, align 4, !invariant.load !142
  %divide.631.1 = fdiv float %153, %155
  %multiply.1032.1 = fmul float %divide.631.1, %141
  %156 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 5
  %157 = load i8, ptr addrspace(1) %156, align 1, !invariant.load !142
  %158 = sitofp i8 %157 to float
  %multiply.1870.1 = fmul float %158, 0x3FC3BF2820000000
  %multiply.5371.1 = fmul float %multiply.1032.1, %multiply.1870.1
  %add.57.i914.1 = fadd float %add.57.i914, %multiply.5371.1
  %.lhs.trunc1045.2 = add nuw nsw i16 %.lhs.trunc1045, 2
  %159 = udiv i16 %.lhs.trunc1045.2, 3
  %160 = mul i16 %159, 3
  %.decomposed1095 = sub i16 %.lhs.trunc1045.2, %160
  %161 = zext i16 %159 to i64
  %162 = zext i16 %.decomposed1095 to i64
  %163 = getelementptr inbounds [222 x [3 x float]], ptr addrspace(1) %arg21100, i64 0, i64 %161, i64 %162
  %164 = load float, ptr addrspace(1) %163, align 4, !invariant.load !142
  %165 = getelementptr inbounds [222 x float], ptr addrspace(1) %arg31102, i64 0, i64 %161
  %166 = load float, ptr addrspace(1) %165, align 4, !invariant.load !142
  %divide.631.2 = fdiv float %164, %166
  %multiply.1032.2 = fmul float %divide.631.2, %141
  %167 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 9
  %168 = load i8, ptr addrspace(1) %167, align 1, !invariant.load !142
  %169 = sitofp i8 %168 to float
  %multiply.1870.2 = fmul float %169, 0x3FC3BF2820000000
  %multiply.5371.2 = fmul float %multiply.1032.2, %multiply.1870.2
  %add.57.i914.2 = fadd float %add.57.i914.1, %multiply.5371.2
  %170 = getelementptr inbounds float, ptr addrspace(1) %140, i64 1
  %171 = load float, ptr addrspace(1) %170, align 4, !invariant.load !142
  %multiply.1032.3 = fmul float %divide.631, %171
  %172 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 513
  %173 = load i8, ptr addrspace(1) %172, align 1, !invariant.load !142
  %174 = sitofp i8 %173 to float
  %multiply.1870.3 = fmul float %174, 0x3FC3BF2820000000
  %multiply.5371.3 = fmul float %multiply.1032.3, %multiply.1870.3
  %add.57.i914.3 = fadd float %add.57.i914.2, %multiply.5371.3
  %multiply.1032.4 = fmul float %divide.631.1, %171
  %175 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 517
  %176 = load i8, ptr addrspace(1) %175, align 1, !invariant.load !142
  %177 = sitofp i8 %176 to float
  %multiply.1870.4 = fmul float %177, 0x3FC3BF2820000000
  %multiply.5371.4 = fmul float %multiply.1032.4, %multiply.1870.4
  %add.57.i914.4 = fadd float %add.57.i914.3, %multiply.5371.4
  %multiply.1032.5 = fmul float %divide.631.2, %171
  %178 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 521
  %179 = load i8, ptr addrspace(1) %178, align 1, !invariant.load !142
  %180 = sitofp i8 %179 to float
  %multiply.1870.5 = fmul float %180, 0x3FC3BF2820000000
  %multiply.5371.5 = fmul float %multiply.1032.5, %multiply.1870.5
  %add.57.i914.5 = fadd float %add.57.i914.4, %multiply.5371.5
  %181 = getelementptr inbounds float, ptr addrspace(1) %140, i64 2
  %182 = load float, ptr addrspace(1) %181, align 4, !invariant.load !142
  %multiply.1032.6 = fmul float %divide.631, %182
  %183 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1025
  %184 = load i8, ptr addrspace(1) %183, align 1, !invariant.load !142
  %185 = sitofp i8 %184 to float
  %multiply.1870.6 = fmul float %185, 0x3FC3BF2820000000
  %multiply.5371.6 = fmul float %multiply.1032.6, %multiply.1870.6
  %add.57.i914.6 = fadd float %add.57.i914.5, %multiply.5371.6
  %multiply.1032.7 = fmul float %divide.631.1, %182
  %186 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1029
  %187 = load i8, ptr addrspace(1) %186, align 1, !invariant.load !142
  %188 = sitofp i8 %187 to float
  %multiply.1870.7 = fmul float %188, 0x3FC3BF2820000000
  %multiply.5371.7 = fmul float %multiply.1032.7, %multiply.1870.7
  %add.57.i914.7 = fadd float %add.57.i914.6, %multiply.5371.7
  %multiply.1032.8 = fmul float %divide.631.2, %182
  %189 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1033
  %190 = load i8, ptr addrspace(1) %189, align 1, !invariant.load !142
  %191 = sitofp i8 %190 to float
  %multiply.1870.8 = fmul float %191, 0x3FC3BF2820000000
  %multiply.5371.8 = fmul float %multiply.1032.8, %multiply.1870.8
  %add.57.i914.8 = fadd float %add.57.i914.7, %multiply.5371.8
  %192 = fptrunc float %add.57.i914.8 to half
  %193 = getelementptr inbounds half, ptr addrspace(1) %100, i64 1
  store half %192, ptr addrspace(1) %193, align 2
  %194 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2
  %195 = load i8, ptr addrspace(1) %194, align 2, !invariant.load !142
  %196 = sitofp i8 %195 to float
  %multiply.18122 = fmul float %196, 0x3FC3BF2820000000
  %multiply.53123 = fmul float %multiply.1032, %multiply.18122
  %add.57.i915 = fadd float %multiply.53123, 0.000000e+00
  %197 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 6
  %198 = load i8, ptr addrspace(1) %197, align 2, !invariant.load !142
  %199 = sitofp i8 %198 to float
  %multiply.18122.1 = fmul float %199, 0x3FC3BF2820000000
  %multiply.53123.1 = fmul float %multiply.1032.1, %multiply.18122.1
  %add.57.i915.1 = fadd float %add.57.i915, %multiply.53123.1
  %200 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 10
  %201 = load i8, ptr addrspace(1) %200, align 2, !invariant.load !142
  %202 = sitofp i8 %201 to float
  %multiply.18122.2 = fmul float %202, 0x3FC3BF2820000000
  %multiply.53123.2 = fmul float %multiply.1032.2, %multiply.18122.2
  %add.57.i915.2 = fadd float %add.57.i915.1, %multiply.53123.2
  %203 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 514
  %204 = load i8, ptr addrspace(1) %203, align 2, !invariant.load !142
  %205 = sitofp i8 %204 to float
  %multiply.18122.3 = fmul float %205, 0x3FC3BF2820000000
  %multiply.53123.3 = fmul float %multiply.1032.3, %multiply.18122.3
  %add.57.i915.3 = fadd float %add.57.i915.2, %multiply.53123.3
  %206 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 518
  %207 = load i8, ptr addrspace(1) %206, align 2, !invariant.load !142
  %208 = sitofp i8 %207 to float
  %multiply.18122.4 = fmul float %208, 0x3FC3BF2820000000
  %multiply.53123.4 = fmul float %multiply.1032.4, %multiply.18122.4
  %add.57.i915.4 = fadd float %add.57.i915.3, %multiply.53123.4
  %209 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 522
  %210 = load i8, ptr addrspace(1) %209, align 2, !invariant.load !142
  %211 = sitofp i8 %210 to float
  %multiply.18122.5 = fmul float %211, 0x3FC3BF2820000000
  %multiply.53123.5 = fmul float %multiply.1032.5, %multiply.18122.5
  %add.57.i915.5 = fadd float %add.57.i915.4, %multiply.53123.5
  %212 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1026
  %213 = load i8, ptr addrspace(1) %212, align 2, !invariant.load !142
  %214 = sitofp i8 %213 to float
  %multiply.18122.6 = fmul float %214, 0x3FC3BF2820000000
  %multiply.53123.6 = fmul float %multiply.1032.6, %multiply.18122.6
  %add.57.i915.6 = fadd float %add.57.i915.5, %multiply.53123.6
  %215 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1030
  %216 = load i8, ptr addrspace(1) %215, align 2, !invariant.load !142
  %217 = sitofp i8 %216 to float
  %multiply.18122.7 = fmul float %217, 0x3FC3BF2820000000
  %multiply.53123.7 = fmul float %multiply.1032.7, %multiply.18122.7
  %add.57.i915.7 = fadd float %add.57.i915.6, %multiply.53123.7
  %218 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1034
  %219 = load i8, ptr addrspace(1) %218, align 2, !invariant.load !142
  %220 = sitofp i8 %219 to float
  %multiply.18122.8 = fmul float %220, 0x3FC3BF2820000000
  %multiply.53123.8 = fmul float %multiply.1032.8, %multiply.18122.8
  %add.57.i915.8 = fadd float %add.57.i915.7, %multiply.53123.8
  %221 = fptrunc float %add.57.i915.8 to half
  %222 = getelementptr inbounds half, ptr addrspace(1) %100, i64 2
  store half %221, ptr addrspace(1) %222, align 4
  %223 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3
  %224 = load i8, ptr addrspace(1) %223, align 1, !invariant.load !142
  %225 = sitofp i8 %224 to float
  %multiply.18174 = fmul float %225, 0x3FC3BF2820000000
  %multiply.53175 = fmul float %multiply.1032, %multiply.18174
  %add.57.i916 = fadd float %multiply.53175, 0.000000e+00
  %226 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 7
  %227 = load i8, ptr addrspace(1) %226, align 1, !invariant.load !142
  %228 = sitofp i8 %227 to float
  %multiply.18174.1 = fmul float %228, 0x3FC3BF2820000000
  %multiply.53175.1 = fmul float %multiply.1032.1, %multiply.18174.1
  %add.57.i916.1 = fadd float %add.57.i916, %multiply.53175.1
  %229 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 11
  %230 = load i8, ptr addrspace(1) %229, align 1, !invariant.load !142
  %231 = sitofp i8 %230 to float
  %multiply.18174.2 = fmul float %231, 0x3FC3BF2820000000
  %multiply.53175.2 = fmul float %multiply.1032.2, %multiply.18174.2
  %add.57.i916.2 = fadd float %add.57.i916.1, %multiply.53175.2
  %232 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 515
  %233 = load i8, ptr addrspace(1) %232, align 1, !invariant.load !142
  %234 = sitofp i8 %233 to float
  %multiply.18174.3 = fmul float %234, 0x3FC3BF2820000000
  %multiply.53175.3 = fmul float %multiply.1032.3, %multiply.18174.3
  %add.57.i916.3 = fadd float %add.57.i916.2, %multiply.53175.3
  %235 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 519
  %236 = load i8, ptr addrspace(1) %235, align 1, !invariant.load !142
  %237 = sitofp i8 %236 to float
  %multiply.18174.4 = fmul float %237, 0x3FC3BF2820000000
  %multiply.53175.4 = fmul float %multiply.1032.4, %multiply.18174.4
  %add.57.i916.4 = fadd float %add.57.i916.3, %multiply.53175.4
  %238 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 523
  %239 = load i8, ptr addrspace(1) %238, align 1, !invariant.load !142
  %240 = sitofp i8 %239 to float
  %multiply.18174.5 = fmul float %240, 0x3FC3BF2820000000
  %multiply.53175.5 = fmul float %multiply.1032.5, %multiply.18174.5
  %add.57.i916.5 = fadd float %add.57.i916.4, %multiply.53175.5
  %241 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1027
  %242 = load i8, ptr addrspace(1) %241, align 1, !invariant.load !142
  %243 = sitofp i8 %242 to float
  %multiply.18174.6 = fmul float %243, 0x3FC3BF2820000000
  %multiply.53175.6 = fmul float %multiply.1032.6, %multiply.18174.6
  %add.57.i916.6 = fadd float %add.57.i916.5, %multiply.53175.6
  %244 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1031
  %245 = load i8, ptr addrspace(1) %244, align 1, !invariant.load !142
  %246 = sitofp i8 %245 to float
  %multiply.18174.7 = fmul float %246, 0x3FC3BF2820000000
  %multiply.53175.7 = fmul float %multiply.1032.7, %multiply.18174.7
  %add.57.i916.7 = fadd float %add.57.i916.6, %multiply.53175.7
  %247 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1035
  %248 = load i8, ptr addrspace(1) %247, align 1, !invariant.load !142
  %249 = sitofp i8 %248 to float
  %multiply.18174.8 = fmul float %249, 0x3FC3BF2820000000
  %multiply.53175.8 = fmul float %multiply.1032.8, %multiply.18174.8
  %add.57.i916.8 = fadd float %add.57.i916.7, %multiply.53175.8
  %250 = fptrunc float %add.57.i916.8 to half
  %251 = getelementptr inbounds half, ptr addrspace(1) %100, i64 3
  store half %250, ptr addrspace(1) %251, align 2
  %252 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277952
  %253 = load i8, ptr addrspace(1) %252, align 4, !invariant.load !142
  %254 = sitofp i8 %253 to float
  %multiply.18226 = fmul float %254, 0x3FC3BF2820000000
  %multiply.53227 = fmul float %multiply.1032, %multiply.18226
  %add.57.i917 = fadd float %multiply.53227, 0.000000e+00
  %255 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277956
  %256 = load i8, ptr addrspace(1) %255, align 4, !invariant.load !142
  %257 = sitofp i8 %256 to float
  %multiply.18226.1 = fmul float %257, 0x3FC3BF2820000000
  %multiply.53227.1 = fmul float %multiply.1032.1, %multiply.18226.1
  %add.57.i917.1 = fadd float %add.57.i917, %multiply.53227.1
  %258 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277960
  %259 = load i8, ptr addrspace(1) %258, align 4, !invariant.load !142
  %260 = sitofp i8 %259 to float
  %multiply.18226.2 = fmul float %260, 0x3FC3BF2820000000
  %multiply.53227.2 = fmul float %multiply.1032.2, %multiply.18226.2
  %add.57.i917.2 = fadd float %add.57.i917.1, %multiply.53227.2
  %261 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278464
  %262 = load i8, ptr addrspace(1) %261, align 4, !invariant.load !142
  %263 = sitofp i8 %262 to float
  %multiply.18226.3 = fmul float %263, 0x3FC3BF2820000000
  %multiply.53227.3 = fmul float %multiply.1032.3, %multiply.18226.3
  %add.57.i917.3 = fadd float %add.57.i917.2, %multiply.53227.3
  %264 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278468
  %265 = load i8, ptr addrspace(1) %264, align 4, !invariant.load !142
  %266 = sitofp i8 %265 to float
  %multiply.18226.4 = fmul float %266, 0x3FC3BF2820000000
  %multiply.53227.4 = fmul float %multiply.1032.4, %multiply.18226.4
  %add.57.i917.4 = fadd float %add.57.i917.3, %multiply.53227.4
  %267 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278472
  %268 = load i8, ptr addrspace(1) %267, align 4, !invariant.load !142
  %269 = sitofp i8 %268 to float
  %multiply.18226.5 = fmul float %269, 0x3FC3BF2820000000
  %multiply.53227.5 = fmul float %multiply.1032.5, %multiply.18226.5
  %add.57.i917.5 = fadd float %add.57.i917.4, %multiply.53227.5
  %270 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278976
  %271 = load i8, ptr addrspace(1) %270, align 4, !invariant.load !142
  %272 = sitofp i8 %271 to float
  %multiply.18226.6 = fmul float %272, 0x3FC3BF2820000000
  %multiply.53227.6 = fmul float %multiply.1032.6, %multiply.18226.6
  %add.57.i917.6 = fadd float %add.57.i917.5, %multiply.53227.6
  %273 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278980
  %274 = load i8, ptr addrspace(1) %273, align 4, !invariant.load !142
  %275 = sitofp i8 %274 to float
  %multiply.18226.7 = fmul float %275, 0x3FC3BF2820000000
  %multiply.53227.7 = fmul float %multiply.1032.7, %multiply.18226.7
  %add.57.i917.7 = fadd float %add.57.i917.6, %multiply.53227.7
  %276 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278984
  %277 = load i8, ptr addrspace(1) %276, align 4, !invariant.load !142
  %278 = sitofp i8 %277 to float
  %multiply.18226.8 = fmul float %278, 0x3FC3BF2820000000
  %multiply.53227.8 = fmul float %multiply.1032.8, %multiply.18226.8
  %add.57.i917.8 = fadd float %add.57.i917.7, %multiply.53227.8
  %279 = fptrunc float %add.57.i917.8 to half
  %280 = getelementptr inbounds half, ptr addrspace(1) %100, i64 4
  store half %279, ptr addrspace(1) %280, align 8
  %281 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277953
  %282 = load i8, ptr addrspace(1) %281, align 1, !invariant.load !142
  %283 = sitofp i8 %282 to float
  %multiply.18278 = fmul float %283, 0x3FC3BF2820000000
  %multiply.53279 = fmul float %multiply.1032, %multiply.18278
  %add.57.i918 = fadd float %multiply.53279, 0.000000e+00
  %284 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277957
  %285 = load i8, ptr addrspace(1) %284, align 1, !invariant.load !142
  %286 = sitofp i8 %285 to float
  %multiply.18278.1 = fmul float %286, 0x3FC3BF2820000000
  %multiply.53279.1 = fmul float %multiply.1032.1, %multiply.18278.1
  %add.57.i918.1 = fadd float %add.57.i918, %multiply.53279.1
  %287 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277961
  %288 = load i8, ptr addrspace(1) %287, align 1, !invariant.load !142
  %289 = sitofp i8 %288 to float
  %multiply.18278.2 = fmul float %289, 0x3FC3BF2820000000
  %multiply.53279.2 = fmul float %multiply.1032.2, %multiply.18278.2
  %add.57.i918.2 = fadd float %add.57.i918.1, %multiply.53279.2
  %290 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278465
  %291 = load i8, ptr addrspace(1) %290, align 1, !invariant.load !142
  %292 = sitofp i8 %291 to float
  %multiply.18278.3 = fmul float %292, 0x3FC3BF2820000000
  %multiply.53279.3 = fmul float %multiply.1032.3, %multiply.18278.3
  %add.57.i918.3 = fadd float %add.57.i918.2, %multiply.53279.3
  %293 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278469
  %294 = load i8, ptr addrspace(1) %293, align 1, !invariant.load !142
  %295 = sitofp i8 %294 to float
  %multiply.18278.4 = fmul float %295, 0x3FC3BF2820000000
  %multiply.53279.4 = fmul float %multiply.1032.4, %multiply.18278.4
  %add.57.i918.4 = fadd float %add.57.i918.3, %multiply.53279.4
  %296 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278473
  %297 = load i8, ptr addrspace(1) %296, align 1, !invariant.load !142
  %298 = sitofp i8 %297 to float
  %multiply.18278.5 = fmul float %298, 0x3FC3BF2820000000
  %multiply.53279.5 = fmul float %multiply.1032.5, %multiply.18278.5
  %add.57.i918.5 = fadd float %add.57.i918.4, %multiply.53279.5
  %299 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278977
  %300 = load i8, ptr addrspace(1) %299, align 1, !invariant.load !142
  %301 = sitofp i8 %300 to float
  %multiply.18278.6 = fmul float %301, 0x3FC3BF2820000000
  %multiply.53279.6 = fmul float %multiply.1032.6, %multiply.18278.6
  %add.57.i918.6 = fadd float %add.57.i918.5, %multiply.53279.6
  %302 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278981
  %303 = load i8, ptr addrspace(1) %302, align 1, !invariant.load !142
  %304 = sitofp i8 %303 to float
  %multiply.18278.7 = fmul float %304, 0x3FC3BF2820000000
  %multiply.53279.7 = fmul float %multiply.1032.7, %multiply.18278.7
  %add.57.i918.7 = fadd float %add.57.i918.6, %multiply.53279.7
  %305 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278985
  %306 = load i8, ptr addrspace(1) %305, align 1, !invariant.load !142
  %307 = sitofp i8 %306 to float
  %multiply.18278.8 = fmul float %307, 0x3FC3BF2820000000
  %multiply.53279.8 = fmul float %multiply.1032.8, %multiply.18278.8
  %add.57.i918.8 = fadd float %add.57.i918.7, %multiply.53279.8
  %308 = fptrunc float %add.57.i918.8 to half
  %309 = getelementptr inbounds half, ptr addrspace(1) %100, i64 5
  store half %308, ptr addrspace(1) %309, align 2
  %310 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277954
  %311 = load i8, ptr addrspace(1) %310, align 2, !invariant.load !142
  %312 = sitofp i8 %311 to float
  %multiply.18330 = fmul float %312, 0x3FC3BF2820000000
  %multiply.53331 = fmul float %multiply.1032, %multiply.18330
  %add.57.i919 = fadd float %multiply.53331, 0.000000e+00
  %313 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277958
  %314 = load i8, ptr addrspace(1) %313, align 2, !invariant.load !142
  %315 = sitofp i8 %314 to float
  %multiply.18330.1 = fmul float %315, 0x3FC3BF2820000000
  %multiply.53331.1 = fmul float %multiply.1032.1, %multiply.18330.1
  %add.57.i919.1 = fadd float %add.57.i919, %multiply.53331.1
  %316 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277962
  %317 = load i8, ptr addrspace(1) %316, align 2, !invariant.load !142
  %318 = sitofp i8 %317 to float
  %multiply.18330.2 = fmul float %318, 0x3FC3BF2820000000
  %multiply.53331.2 = fmul float %multiply.1032.2, %multiply.18330.2
  %add.57.i919.2 = fadd float %add.57.i919.1, %multiply.53331.2
  %319 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278466
  %320 = load i8, ptr addrspace(1) %319, align 2, !invariant.load !142
  %321 = sitofp i8 %320 to float
  %multiply.18330.3 = fmul float %321, 0x3FC3BF2820000000
  %multiply.53331.3 = fmul float %multiply.1032.3, %multiply.18330.3
  %add.57.i919.3 = fadd float %add.57.i919.2, %multiply.53331.3
  %322 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278470
  %323 = load i8, ptr addrspace(1) %322, align 2, !invariant.load !142
  %324 = sitofp i8 %323 to float
  %multiply.18330.4 = fmul float %324, 0x3FC3BF2820000000
  %multiply.53331.4 = fmul float %multiply.1032.4, %multiply.18330.4
  %add.57.i919.4 = fadd float %add.57.i919.3, %multiply.53331.4
  %325 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278474
  %326 = load i8, ptr addrspace(1) %325, align 2, !invariant.load !142
  %327 = sitofp i8 %326 to float
  %multiply.18330.5 = fmul float %327, 0x3FC3BF2820000000
  %multiply.53331.5 = fmul float %multiply.1032.5, %multiply.18330.5
  %add.57.i919.5 = fadd float %add.57.i919.4, %multiply.53331.5
  %328 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278978
  %329 = load i8, ptr addrspace(1) %328, align 2, !invariant.load !142
  %330 = sitofp i8 %329 to float
  %multiply.18330.6 = fmul float %330, 0x3FC3BF2820000000
  %multiply.53331.6 = fmul float %multiply.1032.6, %multiply.18330.6
  %add.57.i919.6 = fadd float %add.57.i919.5, %multiply.53331.6
  %331 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278982
  %332 = load i8, ptr addrspace(1) %331, align 2, !invariant.load !142
  %333 = sitofp i8 %332 to float
  %multiply.18330.7 = fmul float %333, 0x3FC3BF2820000000
  %multiply.53331.7 = fmul float %multiply.1032.7, %multiply.18330.7
  %add.57.i919.7 = fadd float %add.57.i919.6, %multiply.53331.7
  %334 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278986
  %335 = load i8, ptr addrspace(1) %334, align 2, !invariant.load !142
  %336 = sitofp i8 %335 to float
  %multiply.18330.8 = fmul float %336, 0x3FC3BF2820000000
  %multiply.53331.8 = fmul float %multiply.1032.8, %multiply.18330.8
  %add.57.i919.8 = fadd float %add.57.i919.7, %multiply.53331.8
  %337 = fptrunc float %add.57.i919.8 to half
  %338 = getelementptr inbounds half, ptr addrspace(1) %100, i64 6
  store half %337, ptr addrspace(1) %338, align 4
  %339 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277955
  %340 = load i8, ptr addrspace(1) %339, align 1, !invariant.load !142
  %341 = sitofp i8 %340 to float
  %multiply.18382 = fmul float %341, 0x3FC3BF2820000000
  %multiply.53383 = fmul float %multiply.1032, %multiply.18382
  %add.57.i920 = fadd float %multiply.53383, 0.000000e+00
  %342 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277959
  %343 = load i8, ptr addrspace(1) %342, align 1, !invariant.load !142
  %344 = sitofp i8 %343 to float
  %multiply.18382.1 = fmul float %344, 0x3FC3BF2820000000
  %multiply.53383.1 = fmul float %multiply.1032.1, %multiply.18382.1
  %add.57.i920.1 = fadd float %add.57.i920, %multiply.53383.1
  %345 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1277963
  %346 = load i8, ptr addrspace(1) %345, align 1, !invariant.load !142
  %347 = sitofp i8 %346 to float
  %multiply.18382.2 = fmul float %347, 0x3FC3BF2820000000
  %multiply.53383.2 = fmul float %multiply.1032.2, %multiply.18382.2
  %add.57.i920.2 = fadd float %add.57.i920.1, %multiply.53383.2
  %348 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278467
  %349 = load i8, ptr addrspace(1) %348, align 1, !invariant.load !142
  %350 = sitofp i8 %349 to float
  %multiply.18382.3 = fmul float %350, 0x3FC3BF2820000000
  %multiply.53383.3 = fmul float %multiply.1032.3, %multiply.18382.3
  %add.57.i920.3 = fadd float %add.57.i920.2, %multiply.53383.3
  %351 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278471
  %352 = load i8, ptr addrspace(1) %351, align 1, !invariant.load !142
  %353 = sitofp i8 %352 to float
  %multiply.18382.4 = fmul float %353, 0x3FC3BF2820000000
  %multiply.53383.4 = fmul float %multiply.1032.4, %multiply.18382.4
  %add.57.i920.4 = fadd float %add.57.i920.3, %multiply.53383.4
  %354 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278475
  %355 = load i8, ptr addrspace(1) %354, align 1, !invariant.load !142
  %356 = sitofp i8 %355 to float
  %multiply.18382.5 = fmul float %356, 0x3FC3BF2820000000
  %multiply.53383.5 = fmul float %multiply.1032.5, %multiply.18382.5
  %add.57.i920.5 = fadd float %add.57.i920.4, %multiply.53383.5
  %357 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278979
  %358 = load i8, ptr addrspace(1) %357, align 1, !invariant.load !142
  %359 = sitofp i8 %358 to float
  %multiply.18382.6 = fmul float %359, 0x3FC3BF2820000000
  %multiply.53383.6 = fmul float %multiply.1032.6, %multiply.18382.6
  %add.57.i920.6 = fadd float %add.57.i920.5, %multiply.53383.6
  %360 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278983
  %361 = load i8, ptr addrspace(1) %360, align 1, !invariant.load !142
  %362 = sitofp i8 %361 to float
  %multiply.18382.7 = fmul float %362, 0x3FC3BF2820000000
  %multiply.53383.7 = fmul float %multiply.1032.7, %multiply.18382.7
  %add.57.i920.7 = fadd float %add.57.i920.6, %multiply.53383.7
  %363 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 1278987
  %364 = load i8, ptr addrspace(1) %363, align 1, !invariant.load !142
  %365 = sitofp i8 %364 to float
  %multiply.18382.8 = fmul float %365, 0x3FC3BF2820000000
  %multiply.53383.8 = fmul float %multiply.1032.8, %multiply.18382.8
  %add.57.i920.8 = fadd float %add.57.i920.7, %multiply.53383.8
  %366 = fptrunc float %add.57.i920.8 to half
  %367 = getelementptr inbounds half, ptr addrspace(1) %100, i64 7
  store half %366, ptr addrspace(1) %367, align 2
  %368 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555904
  %369 = load i8, ptr addrspace(1) %368, align 4, !invariant.load !142
  %370 = sitofp i8 %369 to float
  %multiply.18434 = fmul float %370, 0x3FC3BF2820000000
  %multiply.53435 = fmul float %multiply.1032, %multiply.18434
  %add.57.i921 = fadd float %multiply.53435, 0.000000e+00
  %371 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555908
  %372 = load i8, ptr addrspace(1) %371, align 4, !invariant.load !142
  %373 = sitofp i8 %372 to float
  %multiply.18434.1 = fmul float %373, 0x3FC3BF2820000000
  %multiply.53435.1 = fmul float %multiply.1032.1, %multiply.18434.1
  %add.57.i921.1 = fadd float %add.57.i921, %multiply.53435.1
  %374 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555912
  %375 = load i8, ptr addrspace(1) %374, align 4, !invariant.load !142
  %376 = sitofp i8 %375 to float
  %multiply.18434.2 = fmul float %376, 0x3FC3BF2820000000
  %multiply.53435.2 = fmul float %multiply.1032.2, %multiply.18434.2
  %add.57.i921.2 = fadd float %add.57.i921.1, %multiply.53435.2
  %377 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556416
  %378 = load i8, ptr addrspace(1) %377, align 4, !invariant.load !142
  %379 = sitofp i8 %378 to float
  %multiply.18434.3 = fmul float %379, 0x3FC3BF2820000000
  %multiply.53435.3 = fmul float %multiply.1032.3, %multiply.18434.3
  %add.57.i921.3 = fadd float %add.57.i921.2, %multiply.53435.3
  %380 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556420
  %381 = load i8, ptr addrspace(1) %380, align 4, !invariant.load !142
  %382 = sitofp i8 %381 to float
  %multiply.18434.4 = fmul float %382, 0x3FC3BF2820000000
  %multiply.53435.4 = fmul float %multiply.1032.4, %multiply.18434.4
  %add.57.i921.4 = fadd float %add.57.i921.3, %multiply.53435.4
  %383 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556424
  %384 = load i8, ptr addrspace(1) %383, align 4, !invariant.load !142
  %385 = sitofp i8 %384 to float
  %multiply.18434.5 = fmul float %385, 0x3FC3BF2820000000
  %multiply.53435.5 = fmul float %multiply.1032.5, %multiply.18434.5
  %add.57.i921.5 = fadd float %add.57.i921.4, %multiply.53435.5
  %386 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556928
  %387 = load i8, ptr addrspace(1) %386, align 4, !invariant.load !142
  %388 = sitofp i8 %387 to float
  %multiply.18434.6 = fmul float %388, 0x3FC3BF2820000000
  %multiply.53435.6 = fmul float %multiply.1032.6, %multiply.18434.6
  %add.57.i921.6 = fadd float %add.57.i921.5, %multiply.53435.6
  %389 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556932
  %390 = load i8, ptr addrspace(1) %389, align 4, !invariant.load !142
  %391 = sitofp i8 %390 to float
  %multiply.18434.7 = fmul float %391, 0x3FC3BF2820000000
  %multiply.53435.7 = fmul float %multiply.1032.7, %multiply.18434.7
  %add.57.i921.7 = fadd float %add.57.i921.6, %multiply.53435.7
  %392 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556936
  %393 = load i8, ptr addrspace(1) %392, align 4, !invariant.load !142
  %394 = sitofp i8 %393 to float
  %multiply.18434.8 = fmul float %394, 0x3FC3BF2820000000
  %multiply.53435.8 = fmul float %multiply.1032.8, %multiply.18434.8
  %add.57.i921.8 = fadd float %add.57.i921.7, %multiply.53435.8
  %395 = fptrunc float %add.57.i921.8 to half
  %396 = getelementptr inbounds half, ptr addrspace(1) %100, i64 8
  store half %395, ptr addrspace(1) %396, align 16
  %397 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555905
  %398 = load i8, ptr addrspace(1) %397, align 1, !invariant.load !142
  %399 = sitofp i8 %398 to float
  %multiply.18486 = fmul float %399, 0x3FC3BF2820000000
  %multiply.53487 = fmul float %multiply.1032, %multiply.18486
  %add.57.i922 = fadd float %multiply.53487, 0.000000e+00
  %400 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555909
  %401 = load i8, ptr addrspace(1) %400, align 1, !invariant.load !142
  %402 = sitofp i8 %401 to float
  %multiply.18486.1 = fmul float %402, 0x3FC3BF2820000000
  %multiply.53487.1 = fmul float %multiply.1032.1, %multiply.18486.1
  %add.57.i922.1 = fadd float %add.57.i922, %multiply.53487.1
  %403 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555913
  %404 = load i8, ptr addrspace(1) %403, align 1, !invariant.load !142
  %405 = sitofp i8 %404 to float
  %multiply.18486.2 = fmul float %405, 0x3FC3BF2820000000
  %multiply.53487.2 = fmul float %multiply.1032.2, %multiply.18486.2
  %add.57.i922.2 = fadd float %add.57.i922.1, %multiply.53487.2
  %406 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556417
  %407 = load i8, ptr addrspace(1) %406, align 1, !invariant.load !142
  %408 = sitofp i8 %407 to float
  %multiply.18486.3 = fmul float %408, 0x3FC3BF2820000000
  %multiply.53487.3 = fmul float %multiply.1032.3, %multiply.18486.3
  %add.57.i922.3 = fadd float %add.57.i922.2, %multiply.53487.3
  %409 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556421
  %410 = load i8, ptr addrspace(1) %409, align 1, !invariant.load !142
  %411 = sitofp i8 %410 to float
  %multiply.18486.4 = fmul float %411, 0x3FC3BF2820000000
  %multiply.53487.4 = fmul float %multiply.1032.4, %multiply.18486.4
  %add.57.i922.4 = fadd float %add.57.i922.3, %multiply.53487.4
  %412 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556425
  %413 = load i8, ptr addrspace(1) %412, align 1, !invariant.load !142
  %414 = sitofp i8 %413 to float
  %multiply.18486.5 = fmul float %414, 0x3FC3BF2820000000
  %multiply.53487.5 = fmul float %multiply.1032.5, %multiply.18486.5
  %add.57.i922.5 = fadd float %add.57.i922.4, %multiply.53487.5
  %415 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556929
  %416 = load i8, ptr addrspace(1) %415, align 1, !invariant.load !142
  %417 = sitofp i8 %416 to float
  %multiply.18486.6 = fmul float %417, 0x3FC3BF2820000000
  %multiply.53487.6 = fmul float %multiply.1032.6, %multiply.18486.6
  %add.57.i922.6 = fadd float %add.57.i922.5, %multiply.53487.6
  %418 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556933
  %419 = load i8, ptr addrspace(1) %418, align 1, !invariant.load !142
  %420 = sitofp i8 %419 to float
  %multiply.18486.7 = fmul float %420, 0x3FC3BF2820000000
  %multiply.53487.7 = fmul float %multiply.1032.7, %multiply.18486.7
  %add.57.i922.7 = fadd float %add.57.i922.6, %multiply.53487.7
  %421 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556937
  %422 = load i8, ptr addrspace(1) %421, align 1, !invariant.load !142
  %423 = sitofp i8 %422 to float
  %multiply.18486.8 = fmul float %423, 0x3FC3BF2820000000
  %multiply.53487.8 = fmul float %multiply.1032.8, %multiply.18486.8
  %add.57.i922.8 = fadd float %add.57.i922.7, %multiply.53487.8
  %424 = fptrunc float %add.57.i922.8 to half
  %425 = getelementptr inbounds half, ptr addrspace(1) %100, i64 9
  store half %424, ptr addrspace(1) %425, align 2
  %426 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555906
  %427 = load i8, ptr addrspace(1) %426, align 2, !invariant.load !142
  %428 = sitofp i8 %427 to float
  %multiply.18538 = fmul float %428, 0x3FC3BF2820000000
  %multiply.53539 = fmul float %multiply.1032, %multiply.18538
  %add.57.i923 = fadd float %multiply.53539, 0.000000e+00
  %429 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555910
  %430 = load i8, ptr addrspace(1) %429, align 2, !invariant.load !142
  %431 = sitofp i8 %430 to float
  %multiply.18538.1 = fmul float %431, 0x3FC3BF2820000000
  %multiply.53539.1 = fmul float %multiply.1032.1, %multiply.18538.1
  %add.57.i923.1 = fadd float %add.57.i923, %multiply.53539.1
  %432 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555914
  %433 = load i8, ptr addrspace(1) %432, align 2, !invariant.load !142
  %434 = sitofp i8 %433 to float
  %multiply.18538.2 = fmul float %434, 0x3FC3BF2820000000
  %multiply.53539.2 = fmul float %multiply.1032.2, %multiply.18538.2
  %add.57.i923.2 = fadd float %add.57.i923.1, %multiply.53539.2
  %435 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556418
  %436 = load i8, ptr addrspace(1) %435, align 2, !invariant.load !142
  %437 = sitofp i8 %436 to float
  %multiply.18538.3 = fmul float %437, 0x3FC3BF2820000000
  %multiply.53539.3 = fmul float %multiply.1032.3, %multiply.18538.3
  %add.57.i923.3 = fadd float %add.57.i923.2, %multiply.53539.3
  %438 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556422
  %439 = load i8, ptr addrspace(1) %438, align 2, !invariant.load !142
  %440 = sitofp i8 %439 to float
  %multiply.18538.4 = fmul float %440, 0x3FC3BF2820000000
  %multiply.53539.4 = fmul float %multiply.1032.4, %multiply.18538.4
  %add.57.i923.4 = fadd float %add.57.i923.3, %multiply.53539.4
  %441 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556426
  %442 = load i8, ptr addrspace(1) %441, align 2, !invariant.load !142
  %443 = sitofp i8 %442 to float
  %multiply.18538.5 = fmul float %443, 0x3FC3BF2820000000
  %multiply.53539.5 = fmul float %multiply.1032.5, %multiply.18538.5
  %add.57.i923.5 = fadd float %add.57.i923.4, %multiply.53539.5
  %444 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556930
  %445 = load i8, ptr addrspace(1) %444, align 2, !invariant.load !142
  %446 = sitofp i8 %445 to float
  %multiply.18538.6 = fmul float %446, 0x3FC3BF2820000000
  %multiply.53539.6 = fmul float %multiply.1032.6, %multiply.18538.6
  %add.57.i923.6 = fadd float %add.57.i923.5, %multiply.53539.6
  %447 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556934
  %448 = load i8, ptr addrspace(1) %447, align 2, !invariant.load !142
  %449 = sitofp i8 %448 to float
  %multiply.18538.7 = fmul float %449, 0x3FC3BF2820000000
  %multiply.53539.7 = fmul float %multiply.1032.7, %multiply.18538.7
  %add.57.i923.7 = fadd float %add.57.i923.6, %multiply.53539.7
  %450 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556938
  %451 = load i8, ptr addrspace(1) %450, align 2, !invariant.load !142
  %452 = sitofp i8 %451 to float
  %multiply.18538.8 = fmul float %452, 0x3FC3BF2820000000
  %multiply.53539.8 = fmul float %multiply.1032.8, %multiply.18538.8
  %add.57.i923.8 = fadd float %add.57.i923.7, %multiply.53539.8
  %453 = fptrunc float %add.57.i923.8 to half
  %454 = getelementptr inbounds half, ptr addrspace(1) %100, i64 10
  store half %453, ptr addrspace(1) %454, align 4
  %455 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555907
  %456 = load i8, ptr addrspace(1) %455, align 1, !invariant.load !142
  %457 = sitofp i8 %456 to float
  %multiply.18590 = fmul float %457, 0x3FC3BF2820000000
  %multiply.53591 = fmul float %multiply.1032, %multiply.18590
  %add.57.i924 = fadd float %multiply.53591, 0.000000e+00
  %458 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555911
  %459 = load i8, ptr addrspace(1) %458, align 1, !invariant.load !142
  %460 = sitofp i8 %459 to float
  %multiply.18590.1 = fmul float %460, 0x3FC3BF2820000000
  %multiply.53591.1 = fmul float %multiply.1032.1, %multiply.18590.1
  %add.57.i924.1 = fadd float %add.57.i924, %multiply.53591.1
  %461 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2555915
  %462 = load i8, ptr addrspace(1) %461, align 1, !invariant.load !142
  %463 = sitofp i8 %462 to float
  %multiply.18590.2 = fmul float %463, 0x3FC3BF2820000000
  %multiply.53591.2 = fmul float %multiply.1032.2, %multiply.18590.2
  %add.57.i924.2 = fadd float %add.57.i924.1, %multiply.53591.2
  %464 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556419
  %465 = load i8, ptr addrspace(1) %464, align 1, !invariant.load !142
  %466 = sitofp i8 %465 to float
  %multiply.18590.3 = fmul float %466, 0x3FC3BF2820000000
  %multiply.53591.3 = fmul float %multiply.1032.3, %multiply.18590.3
  %add.57.i924.3 = fadd float %add.57.i924.2, %multiply.53591.3
  %467 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556423
  %468 = load i8, ptr addrspace(1) %467, align 1, !invariant.load !142
  %469 = sitofp i8 %468 to float
  %multiply.18590.4 = fmul float %469, 0x3FC3BF2820000000
  %multiply.53591.4 = fmul float %multiply.1032.4, %multiply.18590.4
  %add.57.i924.4 = fadd float %add.57.i924.3, %multiply.53591.4
  %470 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556427
  %471 = load i8, ptr addrspace(1) %470, align 1, !invariant.load !142
  %472 = sitofp i8 %471 to float
  %multiply.18590.5 = fmul float %472, 0x3FC3BF2820000000
  %multiply.53591.5 = fmul float %multiply.1032.5, %multiply.18590.5
  %add.57.i924.5 = fadd float %add.57.i924.4, %multiply.53591.5
  %473 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556931
  %474 = load i8, ptr addrspace(1) %473, align 1, !invariant.load !142
  %475 = sitofp i8 %474 to float
  %multiply.18590.6 = fmul float %475, 0x3FC3BF2820000000
  %multiply.53591.6 = fmul float %multiply.1032.6, %multiply.18590.6
  %add.57.i924.6 = fadd float %add.57.i924.5, %multiply.53591.6
  %476 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556935
  %477 = load i8, ptr addrspace(1) %476, align 1, !invariant.load !142
  %478 = sitofp i8 %477 to float
  %multiply.18590.7 = fmul float %478, 0x3FC3BF2820000000
  %multiply.53591.7 = fmul float %multiply.1032.7, %multiply.18590.7
  %add.57.i924.7 = fadd float %add.57.i924.6, %multiply.53591.7
  %479 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 2556939
  %480 = load i8, ptr addrspace(1) %479, align 1, !invariant.load !142
  %481 = sitofp i8 %480 to float
  %multiply.18590.8 = fmul float %481, 0x3FC3BF2820000000
  %multiply.53591.8 = fmul float %multiply.1032.8, %multiply.18590.8
  %add.57.i924.8 = fadd float %add.57.i924.7, %multiply.53591.8
  %482 = fptrunc float %add.57.i924.8 to half
  %483 = getelementptr inbounds half, ptr addrspace(1) %100, i64 11
  store half %482, ptr addrspace(1) %483, align 2
  %484 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833856
  %485 = load i8, ptr addrspace(1) %484, align 4, !invariant.load !142
  %486 = sitofp i8 %485 to float
  %multiply.18642 = fmul float %486, 0x3FC3BF2820000000
  %multiply.53643 = fmul float %multiply.1032, %multiply.18642
  %add.57.i925 = fadd float %multiply.53643, 0.000000e+00
  %487 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833860
  %488 = load i8, ptr addrspace(1) %487, align 4, !invariant.load !142
  %489 = sitofp i8 %488 to float
  %multiply.18642.1 = fmul float %489, 0x3FC3BF2820000000
  %multiply.53643.1 = fmul float %multiply.1032.1, %multiply.18642.1
  %add.57.i925.1 = fadd float %add.57.i925, %multiply.53643.1
  %490 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833864
  %491 = load i8, ptr addrspace(1) %490, align 4, !invariant.load !142
  %492 = sitofp i8 %491 to float
  %multiply.18642.2 = fmul float %492, 0x3FC3BF2820000000
  %multiply.53643.2 = fmul float %multiply.1032.2, %multiply.18642.2
  %add.57.i925.2 = fadd float %add.57.i925.1, %multiply.53643.2
  %493 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834368
  %494 = load i8, ptr addrspace(1) %493, align 4, !invariant.load !142
  %495 = sitofp i8 %494 to float
  %multiply.18642.3 = fmul float %495, 0x3FC3BF2820000000
  %multiply.53643.3 = fmul float %multiply.1032.3, %multiply.18642.3
  %add.57.i925.3 = fadd float %add.57.i925.2, %multiply.53643.3
  %496 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834372
  %497 = load i8, ptr addrspace(1) %496, align 4, !invariant.load !142
  %498 = sitofp i8 %497 to float
  %multiply.18642.4 = fmul float %498, 0x3FC3BF2820000000
  %multiply.53643.4 = fmul float %multiply.1032.4, %multiply.18642.4
  %add.57.i925.4 = fadd float %add.57.i925.3, %multiply.53643.4
  %499 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834376
  %500 = load i8, ptr addrspace(1) %499, align 4, !invariant.load !142
  %501 = sitofp i8 %500 to float
  %multiply.18642.5 = fmul float %501, 0x3FC3BF2820000000
  %multiply.53643.5 = fmul float %multiply.1032.5, %multiply.18642.5
  %add.57.i925.5 = fadd float %add.57.i925.4, %multiply.53643.5
  %502 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834880
  %503 = load i8, ptr addrspace(1) %502, align 4, !invariant.load !142
  %504 = sitofp i8 %503 to float
  %multiply.18642.6 = fmul float %504, 0x3FC3BF2820000000
  %multiply.53643.6 = fmul float %multiply.1032.6, %multiply.18642.6
  %add.57.i925.6 = fadd float %add.57.i925.5, %multiply.53643.6
  %505 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834884
  %506 = load i8, ptr addrspace(1) %505, align 4, !invariant.load !142
  %507 = sitofp i8 %506 to float
  %multiply.18642.7 = fmul float %507, 0x3FC3BF2820000000
  %multiply.53643.7 = fmul float %multiply.1032.7, %multiply.18642.7
  %add.57.i925.7 = fadd float %add.57.i925.6, %multiply.53643.7
  %508 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834888
  %509 = load i8, ptr addrspace(1) %508, align 4, !invariant.load !142
  %510 = sitofp i8 %509 to float
  %multiply.18642.8 = fmul float %510, 0x3FC3BF2820000000
  %multiply.53643.8 = fmul float %multiply.1032.8, %multiply.18642.8
  %add.57.i925.8 = fadd float %add.57.i925.7, %multiply.53643.8
  %511 = fptrunc float %add.57.i925.8 to half
  %512 = getelementptr inbounds half, ptr addrspace(1) %100, i64 12
  store half %511, ptr addrspace(1) %512, align 8
  %513 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833857
  %514 = load i8, ptr addrspace(1) %513, align 1, !invariant.load !142
  %515 = sitofp i8 %514 to float
  %multiply.18694 = fmul float %515, 0x3FC3BF2820000000
  %multiply.53695 = fmul float %multiply.1032, %multiply.18694
  %add.57.i926 = fadd float %multiply.53695, 0.000000e+00
  %516 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833861
  %517 = load i8, ptr addrspace(1) %516, align 1, !invariant.load !142
  %518 = sitofp i8 %517 to float
  %multiply.18694.1 = fmul float %518, 0x3FC3BF2820000000
  %multiply.53695.1 = fmul float %multiply.1032.1, %multiply.18694.1
  %add.57.i926.1 = fadd float %add.57.i926, %multiply.53695.1
  %519 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833865
  %520 = load i8, ptr addrspace(1) %519, align 1, !invariant.load !142
  %521 = sitofp i8 %520 to float
  %multiply.18694.2 = fmul float %521, 0x3FC3BF2820000000
  %multiply.53695.2 = fmul float %multiply.1032.2, %multiply.18694.2
  %add.57.i926.2 = fadd float %add.57.i926.1, %multiply.53695.2
  %522 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834369
  %523 = load i8, ptr addrspace(1) %522, align 1, !invariant.load !142
  %524 = sitofp i8 %523 to float
  %multiply.18694.3 = fmul float %524, 0x3FC3BF2820000000
  %multiply.53695.3 = fmul float %multiply.1032.3, %multiply.18694.3
  %add.57.i926.3 = fadd float %add.57.i926.2, %multiply.53695.3
  %525 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834373
  %526 = load i8, ptr addrspace(1) %525, align 1, !invariant.load !142
  %527 = sitofp i8 %526 to float
  %multiply.18694.4 = fmul float %527, 0x3FC3BF2820000000
  %multiply.53695.4 = fmul float %multiply.1032.4, %multiply.18694.4
  %add.57.i926.4 = fadd float %add.57.i926.3, %multiply.53695.4
  %528 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834377
  %529 = load i8, ptr addrspace(1) %528, align 1, !invariant.load !142
  %530 = sitofp i8 %529 to float
  %multiply.18694.5 = fmul float %530, 0x3FC3BF2820000000
  %multiply.53695.5 = fmul float %multiply.1032.5, %multiply.18694.5
  %add.57.i926.5 = fadd float %add.57.i926.4, %multiply.53695.5
  %531 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834881
  %532 = load i8, ptr addrspace(1) %531, align 1, !invariant.load !142
  %533 = sitofp i8 %532 to float
  %multiply.18694.6 = fmul float %533, 0x3FC3BF2820000000
  %multiply.53695.6 = fmul float %multiply.1032.6, %multiply.18694.6
  %add.57.i926.6 = fadd float %add.57.i926.5, %multiply.53695.6
  %534 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834885
  %535 = load i8, ptr addrspace(1) %534, align 1, !invariant.load !142
  %536 = sitofp i8 %535 to float
  %multiply.18694.7 = fmul float %536, 0x3FC3BF2820000000
  %multiply.53695.7 = fmul float %multiply.1032.7, %multiply.18694.7
  %add.57.i926.7 = fadd float %add.57.i926.6, %multiply.53695.7
  %537 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834889
  %538 = load i8, ptr addrspace(1) %537, align 1, !invariant.load !142
  %539 = sitofp i8 %538 to float
  %multiply.18694.8 = fmul float %539, 0x3FC3BF2820000000
  %multiply.53695.8 = fmul float %multiply.1032.8, %multiply.18694.8
  %add.57.i926.8 = fadd float %add.57.i926.7, %multiply.53695.8
  %540 = fptrunc float %add.57.i926.8 to half
  %541 = getelementptr inbounds half, ptr addrspace(1) %100, i64 13
  store half %540, ptr addrspace(1) %541, align 2
  %542 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833858
  %543 = load i8, ptr addrspace(1) %542, align 2, !invariant.load !142
  %544 = sitofp i8 %543 to float
  %multiply.18746 = fmul float %544, 0x3FC3BF2820000000
  %multiply.53747 = fmul float %multiply.1032, %multiply.18746
  %add.57.i927 = fadd float %multiply.53747, 0.000000e+00
  %545 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833862
  %546 = load i8, ptr addrspace(1) %545, align 2, !invariant.load !142
  %547 = sitofp i8 %546 to float
  %multiply.18746.1 = fmul float %547, 0x3FC3BF2820000000
  %multiply.53747.1 = fmul float %multiply.1032.1, %multiply.18746.1
  %add.57.i927.1 = fadd float %add.57.i927, %multiply.53747.1
  %548 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833866
  %549 = load i8, ptr addrspace(1) %548, align 2, !invariant.load !142
  %550 = sitofp i8 %549 to float
  %multiply.18746.2 = fmul float %550, 0x3FC3BF2820000000
  %multiply.53747.2 = fmul float %multiply.1032.2, %multiply.18746.2
  %add.57.i927.2 = fadd float %add.57.i927.1, %multiply.53747.2
  %551 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834370
  %552 = load i8, ptr addrspace(1) %551, align 2, !invariant.load !142
  %553 = sitofp i8 %552 to float
  %multiply.18746.3 = fmul float %553, 0x3FC3BF2820000000
  %multiply.53747.3 = fmul float %multiply.1032.3, %multiply.18746.3
  %add.57.i927.3 = fadd float %add.57.i927.2, %multiply.53747.3
  %554 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834374
  %555 = load i8, ptr addrspace(1) %554, align 2, !invariant.load !142
  %556 = sitofp i8 %555 to float
  %multiply.18746.4 = fmul float %556, 0x3FC3BF2820000000
  %multiply.53747.4 = fmul float %multiply.1032.4, %multiply.18746.4
  %add.57.i927.4 = fadd float %add.57.i927.3, %multiply.53747.4
  %557 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834378
  %558 = load i8, ptr addrspace(1) %557, align 2, !invariant.load !142
  %559 = sitofp i8 %558 to float
  %multiply.18746.5 = fmul float %559, 0x3FC3BF2820000000
  %multiply.53747.5 = fmul float %multiply.1032.5, %multiply.18746.5
  %add.57.i927.5 = fadd float %add.57.i927.4, %multiply.53747.5
  %560 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834882
  %561 = load i8, ptr addrspace(1) %560, align 2, !invariant.load !142
  %562 = sitofp i8 %561 to float
  %multiply.18746.6 = fmul float %562, 0x3FC3BF2820000000
  %multiply.53747.6 = fmul float %multiply.1032.6, %multiply.18746.6
  %add.57.i927.6 = fadd float %add.57.i927.5, %multiply.53747.6
  %563 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834886
  %564 = load i8, ptr addrspace(1) %563, align 2, !invariant.load !142
  %565 = sitofp i8 %564 to float
  %multiply.18746.7 = fmul float %565, 0x3FC3BF2820000000
  %multiply.53747.7 = fmul float %multiply.1032.7, %multiply.18746.7
  %add.57.i927.7 = fadd float %add.57.i927.6, %multiply.53747.7
  %566 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834890
  %567 = load i8, ptr addrspace(1) %566, align 2, !invariant.load !142
  %568 = sitofp i8 %567 to float
  %multiply.18746.8 = fmul float %568, 0x3FC3BF2820000000
  %multiply.53747.8 = fmul float %multiply.1032.8, %multiply.18746.8
  %add.57.i927.8 = fadd float %add.57.i927.7, %multiply.53747.8
  %569 = fptrunc float %add.57.i927.8 to half
  %570 = getelementptr inbounds half, ptr addrspace(1) %100, i64 14
  store half %569, ptr addrspace(1) %570, align 4
  %571 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833859
  %572 = load i8, ptr addrspace(1) %571, align 1, !invariant.load !142
  %573 = sitofp i8 %572 to float
  %multiply.18798 = fmul float %573, 0x3FC3BF2820000000
  %multiply.53799 = fmul float %multiply.1032, %multiply.18798
  %add.57.i928 = fadd float %multiply.53799, 0.000000e+00
  %574 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833863
  %575 = load i8, ptr addrspace(1) %574, align 1, !invariant.load !142
  %576 = sitofp i8 %575 to float
  %multiply.18798.1 = fmul float %576, 0x3FC3BF2820000000
  %multiply.53799.1 = fmul float %multiply.1032.1, %multiply.18798.1
  %add.57.i928.1 = fadd float %add.57.i928, %multiply.53799.1
  %577 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3833867
  %578 = load i8, ptr addrspace(1) %577, align 1, !invariant.load !142
  %579 = sitofp i8 %578 to float
  %multiply.18798.2 = fmul float %579, 0x3FC3BF2820000000
  %multiply.53799.2 = fmul float %multiply.1032.2, %multiply.18798.2
  %add.57.i928.2 = fadd float %add.57.i928.1, %multiply.53799.2
  %580 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834371
  %581 = load i8, ptr addrspace(1) %580, align 1, !invariant.load !142
  %582 = sitofp i8 %581 to float
  %multiply.18798.3 = fmul float %582, 0x3FC3BF2820000000
  %multiply.53799.3 = fmul float %multiply.1032.3, %multiply.18798.3
  %add.57.i928.3 = fadd float %add.57.i928.2, %multiply.53799.3
  %583 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834375
  %584 = load i8, ptr addrspace(1) %583, align 1, !invariant.load !142
  %585 = sitofp i8 %584 to float
  %multiply.18798.4 = fmul float %585, 0x3FC3BF2820000000
  %multiply.53799.4 = fmul float %multiply.1032.4, %multiply.18798.4
  %add.57.i928.4 = fadd float %add.57.i928.3, %multiply.53799.4
  %586 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834379
  %587 = load i8, ptr addrspace(1) %586, align 1, !invariant.load !142
  %588 = sitofp i8 %587 to float
  %multiply.18798.5 = fmul float %588, 0x3FC3BF2820000000
  %multiply.53799.5 = fmul float %multiply.1032.5, %multiply.18798.5
  %add.57.i928.5 = fadd float %add.57.i928.4, %multiply.53799.5
  %589 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834883
  %590 = load i8, ptr addrspace(1) %589, align 1, !invariant.load !142
  %591 = sitofp i8 %590 to float
  %multiply.18798.6 = fmul float %591, 0x3FC3BF2820000000
  %multiply.53799.6 = fmul float %multiply.1032.6, %multiply.18798.6
  %add.57.i928.6 = fadd float %add.57.i928.5, %multiply.53799.6
  %592 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834887
  %593 = load i8, ptr addrspace(1) %592, align 1, !invariant.load !142
  %594 = sitofp i8 %593 to float
  %multiply.18798.7 = fmul float %594, 0x3FC3BF2820000000
  %multiply.53799.7 = fmul float %multiply.1032.7, %multiply.18798.7
  %add.57.i928.7 = fadd float %add.57.i928.6, %multiply.53799.7
  %595 = getelementptr inbounds i8, ptr addrspace(1) %144, i64 3834891
  %596 = load i8, ptr addrspace(1) %595, align 1, !invariant.load !142
  %597 = sitofp i8 %596 to float
  %multiply.18798.8 = fmul float %597, 0x3FC3BF2820000000
  %multiply.53799.8 = fmul float %multiply.1032.8, %multiply.18798.8
  %add.57.i928.8 = fadd float %add.57.i928.7, %multiply.53799.8
  %598 = fptrunc float %add.57.i928.8 to half
  %599 = getelementptr inbounds half, ptr addrspace(1) %100, i64 15
  store half %598, ptr addrspace(1) %599, align 2
  ret void
}

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
attributes #1 = { mustprogress nofree nosync nounwind willreturn memory(argmem: readwrite) }

!140 = !{i32 0, i32 8658}
!141 = !{i32 0, i32 64}
!142 = !{}
