; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -passes=loop-vectorize -S -force-vector-width=4 -enable-interleaved-mem-accesses=true -debug-only=loop-vectorize < %s 2>&1 | FileCheck %s
; REQUIRES: asserts

; This test checks if an unused interleave group is removed by removeDeadRecipes.

%struct.foo = type { ptr, ptr }

define void @test_unused_interleave(ptr %src, i32 %length) {
; CHECK-LABEL: Checking a loop in 'test_unused_interleave'
; CHECK: VPlan 'Initial VPlan for VF={4},UF>=1' {
; CHECK-NEXT: Live-in vp<%0> = VF * UF
; CHECK-NEXT: Live-in vp<%1> = vector-trip-count
; CHECK-NEXT: Live-in ir<%length> = original trip-count
; CHECK-EMPTY:
; CHECK-NEXT: vector.ph:
; CHECK-NEXT: Successor(s): vector loop
; CHECK-EMPTY:
; CHECK-NEXT: <x1> vector loop: {
; CHECK-NEXT:   vector.body:
; CHECK-NEXT:     EMIT vp<%2> = CANONICAL-INDUCTION ir<0>, vp<%3>
; CHECK-NEXT:     EMIT vp<%3> = add nuw vp<%2>, vp<%0>
; CHECK-NEXT:     EMIT branch-on-count vp<%3>, vp<%1>
; CHECK-NEXT:   No successors
; CHECK-NEXT: }
entry:
  br label %for.body

for.body:
  %iv = phi i32 [ %iv.next, %for.body ], [ 0, %entry ]
  %next19.i.i = getelementptr inbounds %struct.foo, ptr %src, i32 %iv, i32 0
  %load_p1 = load ptr, ptr %next19.i.i, align 4
  %arrayidx15.i.i1427 = getelementptr inbounds %struct.foo, ptr %src, i32 %iv
  %val.i.i = getelementptr inbounds %struct.foo, ptr %arrayidx15.i.i1427, i32 0, i32 1
  %load_p2 = load ptr, ptr %val.i.i, align 4
  %iv.next = add nuw nsw i32 %iv, 1
  %cond = icmp eq i32 %iv.next, %length
  br i1 %cond, label %for.end, label %for.body

for.end:
  ret void
}
