; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin9 -mattr=+sse,+sse2,+sse4.1 | FileCheck %s

target datalayout = "e-p:32:32"

define i16 @test1(float %f) nounwind {
; CHECK-LABEL: test1:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    xorps %xmm1, %xmm1
; CHECK-NEXT:    subss LCPI0_0, %xmm0
; CHECK-NEXT:    mulss LCPI0_1, %xmm0
; CHECK-NEXT:    minss LCPI0_2, %xmm0
; CHECK-NEXT:    maxss %xmm1, %xmm0
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ## kill: %AX<def> %AX<kill> %EAX<kill>
; CHECK-NEXT:    retl
;
  %tmp = insertelement <4 x float> undef, float %f, i32 0		; <<4 x float>> [#uses=1]
  %tmp10 = insertelement <4 x float> %tmp, float 0.000000e+00, i32 1		; <<4 x float>> [#uses=1]
  %tmp11 = insertelement <4 x float> %tmp10, float 0.000000e+00, i32 2		; <<4 x float>> [#uses=1]
  %tmp12 = insertelement <4 x float> %tmp11, float 0.000000e+00, i32 3		; <<4 x float>> [#uses=1]
  %tmp28 = tail call <4 x float> @llvm.x86.sse.sub.ss( <4 x float> %tmp12, <4 x float> < float 1.000000e+00, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00 > )		; <<4 x float>> [#uses=1]
  %tmp37 = tail call <4 x float> @llvm.x86.sse.mul.ss( <4 x float> %tmp28, <4 x float> < float 5.000000e-01, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00 > )		; <<4 x float>> [#uses=1]
  %tmp48 = tail call <4 x float> @llvm.x86.sse.min.ss( <4 x float> %tmp37, <4 x float> < float 6.553500e+04, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00 > )		; <<4 x float>> [#uses=1]
  %tmp59 = tail call <4 x float> @llvm.x86.sse.max.ss( <4 x float> %tmp48, <4 x float> zeroinitializer )		; <<4 x float>> [#uses=1]
  %tmp.upgrd.1 = tail call i32 @llvm.x86.sse.cvttss2si( <4 x float> %tmp59 )		; <i32> [#uses=1]
  %tmp69 = trunc i32 %tmp.upgrd.1 to i16		; <i16> [#uses=1]
  ret i16 %tmp69
}

define i16 @test2(float %f) nounwind {
; CHECK-LABEL: test2:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    addss LCPI1_0, %xmm0
; CHECK-NEXT:    mulss LCPI1_1, %xmm0
; CHECK-NEXT:    minss LCPI1_2, %xmm0
; CHECK-NEXT:    xorps %xmm1, %xmm1
; CHECK-NEXT:    maxss %xmm1, %xmm0
; CHECK-NEXT:    cvttss2si %xmm0, %eax
; CHECK-NEXT:    ## kill: %AX<def> %AX<kill> %EAX<kill>
; CHECK-NEXT:    retl
;
  %tmp28 = fsub float %f, 1.000000e+00		; <float> [#uses=1]
  %tmp37 = fmul float %tmp28, 5.000000e-01		; <float> [#uses=1]
  %tmp375 = insertelement <4 x float> undef, float %tmp37, i32 0		; <<4 x float>> [#uses=1]
  %tmp48 = tail call <4 x float> @llvm.x86.sse.min.ss( <4 x float> %tmp375, <4 x float> < float 6.553500e+04, float undef, float undef, float undef > )		; <<4 x float>> [#uses=1]
  %tmp59 = tail call <4 x float> @llvm.x86.sse.max.ss( <4 x float> %tmp48, <4 x float> < float 0.000000e+00, float undef, float undef, float undef > )		; <<4 x float>> [#uses=1]
  %tmp = tail call i32 @llvm.x86.sse.cvttss2si( <4 x float> %tmp59 )		; <i32> [#uses=1]
  %tmp69 = trunc i32 %tmp to i16		; <i16> [#uses=1]
  ret i16 %tmp69
}

declare <4 x float> @llvm.x86.sse.sub.ss(<4 x float>, <4 x float>)

declare <4 x float> @llvm.x86.sse.mul.ss(<4 x float>, <4 x float>)

declare <4 x float> @llvm.x86.sse.min.ss(<4 x float>, <4 x float>)

declare <4 x float> @llvm.x86.sse.max.ss(<4 x float>, <4 x float>)

declare i32 @llvm.x86.sse.cvttss2si(<4 x float>)

declare <4 x float> @llvm.x86.sse41.round.ss(<4 x float>, <4 x float>, i32)

declare <4 x float> @f()

define <4 x float> @test3(<4 x float> %A, float *%b, i32 %C) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    roundss $4, (%eax), %xmm0
; CHECK-NEXT:    retl
;
  %a = load float , float *%b
  %B = insertelement <4 x float> undef, float %a, i32 0
  %X = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %A, <4 x float> %B, i32 4)
  ret <4 x float> %X
}

define <4 x float> @test4(<4 x float> %A, float *%b, i32 %C) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ## BB#0:
; CHECK-NEXT:    subl $28, %esp
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; CHECK-NEXT:    movaps %xmm0, (%esp) ## 16-byte Spill
; CHECK-NEXT:    calll _f
; CHECK-NEXT:    movaps (%esp), %xmm1 ## 16-byte Reload
; CHECK-NEXT:    roundss $4, %xmm1, %xmm0
; CHECK-NEXT:    addl $28, %esp
; CHECK-NEXT:    retl
;
  %a = load float , float *%b
  %B = insertelement <4 x float> undef, float %a, i32 0
  %q = call <4 x float> @f()
  %X = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %q, <4 x float> %B, i32 4)
  ret <4 x float> %X
}

; PR13576
define  <2 x double> @test5() nounwind uwtable readnone noinline {
; CHECK-LABEL: test5:
; CHECK:       ## BB#0: ## %entry
; CHECK-NEXT:    movaps {{.*#+}} xmm0 = [4.569870e+02,1.233210e+02]
; CHECK-NEXT:    movl $128, %eax
; CHECK-NEXT:    cvtsi2sdl %eax, %xmm0
; CHECK-NEXT:    retl
;
entry:
  %0 = tail call <2 x double> @llvm.x86.sse2.cvtsi2sd(<2 x double> <double
4.569870e+02, double 1.233210e+02>, i32 128) nounwind readnone
  ret <2 x double> %0
}

declare <2 x double> @llvm.x86.sse2.cvtsi2sd(<2 x double>, i32) nounwind readnone
