; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips2 | FileCheck %s \
; RUN:    -check-prefix=MIPS
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32 | FileCheck %s \
; RUN:    -check-prefix=MIPS
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r2 | FileCheck %s \
; RUN:    -check-prefix=MIPS32R2
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r3 | FileCheck %s \
; RUN:    -check-prefix=MIPS32R2
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r5 | FileCheck %s \
; RUN:    -check-prefix=MIPS32R2
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r6 | FileCheck %s \
; RUN:    -check-prefix=MIPS32R6
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips3 | FileCheck %s \
; RUN:    -check-prefix=MIPS64
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips4 | FileCheck %s \
; RUN:    -check-prefix=MIPS64
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips64 | FileCheck %s \
; RUN:    -check-prefix=MIPS64
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips64r2 | FileCheck %s \
; RUN:    -check-prefix=MIPS64R2
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips64r3 | FileCheck %s \
; RUN:    -check-prefix=MIPS64R2
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips64r5 | FileCheck %s \
; RUN:    -check-prefix=MIPS64R2
; RUN: llc < %s -mtriple=mips64-unknown-linux-gnu -mcpu=mips64r6 | FileCheck %s \
; RUN:    -check-prefix=MIPS64R6
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r3 -mattr=+micromips | FileCheck %s \
; RUN:    -check-prefix=MM32R3
; RUN: llc < %s -mtriple=mips-unknown-linux-gnu -mcpu=mips32r6 -mattr=+micromips | FileCheck %s \
; RUN:    -check-prefix=MM32R6

define signext i1 @and_i1(i1 signext %a, i1 signext %b) {
; MIPS-LABEL: and_i1:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $2, $4, $5
;
; MIPS32R2-LABEL: and_i1:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $2, $4, $5
;
; MIPS32R6-LABEL: and_i1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $2, $4, $5
;
; MIPS64-LABEL: and_i1:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    and $1, $4, $5
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $1, 0
;
; MIPS64R2-LABEL: and_i1:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    and $1, $4, $5
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    sll $2, $1, 0
;
; MIPS64R6-LABEL: and_i1:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    and $1, $4, $5
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sll $2, $1, 0
;
; MM32R3-LABEL: and_i1:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    and16 $4, $5
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    and16 $4, $5
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 %a, %b
  ret i1 %r
}

define signext i8 @and_i8(i8 signext %a, i8 signext %b) {
; MIPS-LABEL: and_i8:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $2, $4, $5
;
; MIPS32R2-LABEL: and_i8:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $2, $4, $5
;
; MIPS32R6-LABEL: and_i8:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $2, $4, $5
;
; MIPS64-LABEL: and_i8:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    and $1, $4, $5
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $1, 0
;
; MIPS64R2-LABEL: and_i8:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    and $1, $4, $5
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    sll $2, $1, 0
;
; MIPS64R6-LABEL: and_i8:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    and $1, $4, $5
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sll $2, $1, 0
;
; MM32R3-LABEL: and_i8:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    and16 $4, $5
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    and16 $4, $5
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 %a, %b
  ret i8 %r
}

define signext i16 @and_i16(i16 signext %a, i16 signext %b) {
; MIPS-LABEL: and_i16:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $2, $4, $5
;
; MIPS32R2-LABEL: and_i16:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $2, $4, $5
;
; MIPS32R6-LABEL: and_i16:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $2, $4, $5
;
; MIPS64-LABEL: and_i16:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    and $1, $4, $5
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $1, 0
;
; MIPS64R2-LABEL: and_i16:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    and $1, $4, $5
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    sll $2, $1, 0
;
; MIPS64R6-LABEL: and_i16:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    and $1, $4, $5
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sll $2, $1, 0
;
; MM32R3-LABEL: and_i16:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    and16 $4, $5
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i16:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    and16 $4, $5
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 %a, %b
  ret i16 %r
}

define signext i32 @and_i32(i32 signext %a, i32 signext %b) {
; MIPS-LABEL: and_i32:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $2, $4, $5
;
; MIPS32R2-LABEL: and_i32:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $2, $4, $5
;
; MIPS32R6-LABEL: and_i32:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $2, $4, $5
;
; MIPS64-LABEL: and_i32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    and $1, $4, $5
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $1, 0
;
; MIPS64R2-LABEL: and_i32:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    and $1, $4, $5
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    sll $2, $1, 0
;
; MIPS64R6-LABEL: and_i32:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    and $1, $4, $5
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sll $2, $1, 0
;
; MM32R3-LABEL: and_i32:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    and16 $4, $5
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i32:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    and16 $4, $5
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 %a, %b
  ret i32 %r
}

define signext i64 @and_i64(i64 signext %a, i64 signext %b) {
; MIPS-LABEL: and_i64:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    and $2, $4, $6
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $3, $5, $7
;
; MIPS32R2-LABEL: and_i64:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    and $2, $4, $6
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $3, $5, $7
;
; MIPS32R6-LABEL: and_i64:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    and $2, $4, $6
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $3, $5, $7
;
; MIPS64-LABEL: and_i64:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    and $2, $4, $5
;
; MIPS64R2-LABEL: and_i64:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    and $2, $4, $5
;
; MIPS64R6-LABEL: and_i64:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    and $2, $4, $5
;
; MM32R3-LABEL: and_i64:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    and16 $4, $6
; MM32R3-NEXT:    and16 $5, $7
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    move $3, $5
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i64:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    and16 $4, $6
; MM32R6-NEXT:    and16 $5, $7
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    move $3, $5
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 %a, %b
  ret i64 %r
}

define signext i128 @and_i128(i128 signext %a, i128 signext %b) {
; MIPS-LABEL: and_i128:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    lw $1, 20($sp)
; MIPS-NEXT:    lw $2, 16($sp)
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    and $3, $5, $1
; MIPS-NEXT:    lw $1, 24($sp)
; MIPS-NEXT:    and $4, $6, $1
; MIPS-NEXT:    lw $1, 28($sp)
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $5, $7, $1
;
; MIPS32R2-LABEL: and_i128:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    lw $1, 20($sp)
; MIPS32R2-NEXT:    lw $2, 16($sp)
; MIPS32R2-NEXT:    and $2, $4, $2
; MIPS32R2-NEXT:    and $3, $5, $1
; MIPS32R2-NEXT:    lw $1, 24($sp)
; MIPS32R2-NEXT:    and $4, $6, $1
; MIPS32R2-NEXT:    lw $1, 28($sp)
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $5, $7, $1
;
; MIPS32R6-LABEL: and_i128:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lw $1, 20($sp)
; MIPS32R6-NEXT:    lw $2, 16($sp)
; MIPS32R6-NEXT:    and $2, $4, $2
; MIPS32R6-NEXT:    and $3, $5, $1
; MIPS32R6-NEXT:    lw $1, 24($sp)
; MIPS32R6-NEXT:    and $4, $6, $1
; MIPS32R6-NEXT:    lw $1, 28($sp)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $5, $7, $1
;
; MIPS64-LABEL: and_i128:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    and $2, $4, $6
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    and $3, $5, $7
;
; MIPS64R2-LABEL: and_i128:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    and $2, $4, $6
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    and $3, $5, $7
;
; MIPS64R6-LABEL: and_i128:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    and $2, $4, $6
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    and $3, $5, $7
;
; MM32R3-LABEL: and_i128:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    lw $3, 20($sp)
; MM32R3-NEXT:    lw $2, 16($sp)
; MM32R3-NEXT:    and16 $2, $4
; MM32R3-NEXT:    and16 $3, $5
; MM32R3-NEXT:    lw $4, 24($sp)
; MM32R3-NEXT:    and16 $4, $6
; MM32R3-NEXT:    lw $5, 28($sp)
; MM32R3-NEXT:    and16 $5, $7
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i128:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    lw $3, 20($sp)
; MM32R6-NEXT:    lw $2, 16($sp)
; MM32R6-NEXT:    and16 $2, $4
; MM32R6-NEXT:    and16 $3, $5
; MM32R6-NEXT:    lw $4, 24($sp)
; MM32R6-NEXT:    and16 $4, $6
; MM32R6-NEXT:    lw $5, 28($sp)
; MM32R6-NEXT:    and16 $5, $7
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 %a, %b
  ret i128 %r
}

define signext i1 @and_i1_4(i1 signext %b) {
; MIPS-LABEL: and_i1_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i1_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i1_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i1_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    addiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i1_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    addiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i1_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    addiu $2, $zero, 0
;
; MM32R3-LABEL: and_i1_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 4, %b
  ret i1 %r
}

define signext i8 @and_i8_4(i8 signext %b) {
; MIPS-LABEL: and_i8_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 4
;
; MIPS32R2-LABEL: and_i8_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 4
;
; MIPS32R6-LABEL: and_i8_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 4
;
; MIPS64-LABEL: and_i8_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 4
;
; MIPS64R2-LABEL: and_i8_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 4
;
; MIPS64R6-LABEL: and_i8_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 4
;
; MM32R3-LABEL: and_i8_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 4, %b
  ret i8 %r
}

define signext i16 @and_i16_4(i16 signext %b) {
; MIPS-LABEL: and_i16_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 4
;
; MIPS32R2-LABEL: and_i16_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 4
;
; MIPS32R6-LABEL: and_i16_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 4
;
; MIPS64-LABEL: and_i16_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 4
;
; MIPS64R2-LABEL: and_i16_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 4
;
; MIPS64R6-LABEL: and_i16_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 4
;
; MM32R3-LABEL: and_i16_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i16_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 4, %b
  ret i16 %r
}

define signext i32 @and_i32_4(i32 signext %b) {
; MIPS-LABEL: and_i32_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 4
;
; MIPS32R2-LABEL: and_i32_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 4
;
; MIPS32R6-LABEL: and_i32_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 4
;
; MIPS64-LABEL: and_i32_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 4
;
; MIPS64R2-LABEL: and_i32_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 4
;
; MIPS64R6-LABEL: and_i32_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 4
;
; MM32R3-LABEL: and_i32_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i32_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 4, %b
  ret i32 %r
}

define signext i64 @and_i64_4(i64 signext %b) {
; MIPS-LABEL: and_i64_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 4
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 4
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 4
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 4
;
; MIPS64R2-LABEL: and_i64_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 4
;
; MIPS64R6-LABEL: and_i64_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 4
;
; MM32R3-LABEL: and_i64_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $3, $5, 4
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i64_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $3, $5, 4
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 4, %b
  ret i64 %r
}

define signext i128 @and_i128_4(i128 signext %b) {
; MIPS-LABEL: and_i128_4:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 4
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_4:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 4
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 4
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 4
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_4:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 4
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 4
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_4:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $5, $7, 4
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i128_4:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $5, $7, 4
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 4, %b
  ret i128 %r
}

define signext i1 @and_i1_31(i1 signext %b) {
; MIPS-LABEL: and_i1_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    move $2, $4
;
; MIPS32R2-LABEL: and_i1_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    move $2, $4
;
; MIPS32R6-LABEL: and_i1_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    move $2, $4
;
; MIPS64-LABEL: and_i1_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    move $2, $4
;
; MIPS64R2-LABEL: and_i1_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    move $2, $4
;
; MIPS64R6-LABEL: and_i1_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    move $2, $4
;
; MM32R3-LABEL: and_i1_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 31, %b
  ret i1 %r
}

define signext i8 @and_i8_31(i8 signext %b) {
; MIPS-LABEL: and_i8_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 31
;
; MIPS32R2-LABEL: and_i8_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 31
;
; MIPS32R6-LABEL: and_i8_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 31
;
; MIPS64-LABEL: and_i8_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 31
;
; MIPS64R2-LABEL: and_i8_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 31
;
; MIPS64R6-LABEL: and_i8_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 31
;
; MM32R3-LABEL: and_i8_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 31
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 31
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 31, %b
  ret i8 %r
}

define signext i16 @and_i16_31(i16 signext %b) {
; MIPS-LABEL: and_i16_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 31
;
; MIPS32R2-LABEL: and_i16_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 31
;
; MIPS32R6-LABEL: and_i16_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 31
;
; MIPS64-LABEL: and_i16_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 31
;
; MIPS64R2-LABEL: and_i16_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 31
;
; MIPS64R6-LABEL: and_i16_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 31
;
; MM32R3-LABEL: and_i16_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 31
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i16_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 31
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 31, %b
  ret i16 %r
}

define signext i32 @and_i32_31(i32 signext %b) {
; MIPS-LABEL: and_i32_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 31
;
; MIPS32R2-LABEL: and_i32_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 31
;
; MIPS32R6-LABEL: and_i32_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 31
;
; MIPS64-LABEL: and_i32_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 31
;
; MIPS64R2-LABEL: and_i32_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 31
;
; MIPS64R6-LABEL: and_i32_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 31
;
; MM32R3-LABEL: and_i32_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 31
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i32_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 31
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 31, %b
  ret i32 %r
}

define signext i64 @and_i64_31(i64 signext %b) {
; MIPS-LABEL: and_i64_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 31
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 31
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 31
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 31
;
; MIPS64R2-LABEL: and_i64_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 31
;
; MIPS64R6-LABEL: and_i64_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 31
;
; MM32R3-LABEL: and_i64_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $3, $5, 31
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i64_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $3, $5, 31
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 31, %b
  ret i64 %r
}

define signext i128 @and_i128_31(i128 signext %b) {
; MIPS-LABEL: and_i128_31:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 31
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_31:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 31
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_31:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 31
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_31:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 31
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_31:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 31
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_31:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 31
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_31:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $5, $7, 31
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i128_31:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $5, $7, 31
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 31, %b
  ret i128 %r
}

define signext i1 @and_i1_255(i1 signext %b) {
; MIPS-LABEL: and_i1_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    move $2, $4
;
; MIPS32R2-LABEL: and_i1_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    move $2, $4
;
; MIPS32R6-LABEL: and_i1_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    move $2, $4
;
; MIPS64-LABEL: and_i1_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    move $2, $4
;
; MIPS64R2-LABEL: and_i1_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    move $2, $4
;
; MIPS64R6-LABEL: and_i1_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    move $2, $4
;
; MM32R3-LABEL: and_i1_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 255, %b
  ret i1 %r
}

define signext i8 @and_i8_255(i8 signext %b) {
; MIPS-LABEL: and_i8_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    move $2, $4
;
; MIPS32R2-LABEL: and_i8_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    move $2, $4
;
; MIPS32R6-LABEL: and_i8_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    move $2, $4
;
; MIPS64-LABEL: and_i8_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    move $2, $4
;
; MIPS64R2-LABEL: and_i8_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    move $2, $4
;
; MIPS64R6-LABEL: and_i8_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    move $2, $4
;
; MM32R3-LABEL: and_i8_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 255, %b
  ret i8 %r
}

define signext i16 @and_i16_255(i16 signext %b) {
; MIPS-LABEL: and_i16_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 255
;
; MIPS32R2-LABEL: and_i16_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 255
;
; MIPS32R6-LABEL: and_i16_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 255
;
; MIPS64-LABEL: and_i16_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 255
;
; MIPS64R2-LABEL: and_i16_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 255
;
; MIPS64R6-LABEL: and_i16_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 255
;
; MM32R3-LABEL: and_i16_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 255
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i16_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 255
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 255, %b
  ret i16 %r
}

define signext i32 @and_i32_255(i32 signext %b) {
; MIPS-LABEL: and_i32_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 255
;
; MIPS32R2-LABEL: and_i32_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 255
;
; MIPS32R6-LABEL: and_i32_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 255
;
; MIPS64-LABEL: and_i32_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 255
;
; MIPS64R2-LABEL: and_i32_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 255
;
; MIPS64R6-LABEL: and_i32_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 255
;
; MM32R3-LABEL: and_i32_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 255
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i32_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 255
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 255, %b
  ret i32 %r
}

define signext i64 @and_i64_255(i64 signext %b) {
; MIPS-LABEL: and_i64_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 255
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 255
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 255
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 255
;
; MIPS64R2-LABEL: and_i64_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 255
;
; MIPS64R6-LABEL: and_i64_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 255
;
; MM32R3-LABEL: and_i64_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $3, $5, 255
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i64_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $3, $5, 255
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 255, %b
  ret i64 %r
}

define signext i128 @and_i128_255(i128 signext %b) {
; MIPS-LABEL: and_i128_255:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 255
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_255:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 255
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_255:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 255
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_255:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 255
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_255:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 255
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_255:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 255
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_255:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $5, $7, 255
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i128_255:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $5, $7, 255
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 255, %b
  ret i128 %r
}

define signext i1 @and_i1_32768(i1 signext %b) {
; MIPS-LABEL: and_i1_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i1_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i1_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i1_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    addiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i1_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    addiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i1_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    addiu $2, $zero, 0
;
; MM32R3-LABEL: and_i1_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 32768, %b
  ret i1 %r
}

define signext i8 @and_i8_32768(i8 signext %b) {
; MIPS-LABEL: and_i8_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i8_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i8_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i8_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    addiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i8_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    addiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i8_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    addiu $2, $zero, 0
;
; MM32R3-LABEL: and_i8_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 32768, %b
  ret i8 %r
}

define signext i16 @and_i16_32768(i16 signext %b) {
; MIPS-LABEL: and_i16_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $1, $zero, -32768
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    and $2, $4, $1
;
; MIPS32R2-LABEL: and_i16_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    addiu $1, $zero, -32768
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    and $2, $4, $1
;
; MIPS32R6-LABEL: and_i16_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    addiu $1, $zero, -32768
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    and $2, $4, $1
;
; MIPS64-LABEL: and_i16_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    addiu $1, $zero, -32768
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    and $2, $4, $1
;
; MIPS64R2-LABEL: and_i16_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    addiu $1, $zero, -32768
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    and $2, $4, $1
;
; MIPS64R6-LABEL: and_i16_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    addiu $1, $zero, -32768
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    and $2, $4, $1
;
; MM32R3-LABEL: and_i16_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    addiu $2, $zero, -32768
; MM32R3-NEXT:    and16 $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i16_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    addiu $2, $zero, -32768
; MM32R6-NEXT:    and16 $2, $4
; MM32R6-NEXT:    jrc $ra
entry:

  %r = and i16 32768, %b
  ret i16 %r
}

define signext i32 @and_i32_32768(i32 signext %b) {
; MIPS-LABEL: and_i32_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 32768
;
; MIPS32R2-LABEL: and_i32_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 32768
;
; MIPS32R6-LABEL: and_i32_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 32768
;
; MIPS64-LABEL: and_i32_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 32768
;
; MIPS64R2-LABEL: and_i32_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 32768
;
; MIPS64R6-LABEL: and_i32_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 32768
;
; MM32R3-LABEL: and_i32_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $2, $4, 32768
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i32_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $2, $4, 32768
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 32768, %b
  ret i32 %r
}

define signext i64 @and_i64_32768(i64 signext %b) {
; MIPS-LABEL: and_i64_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 32768
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 32768
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 32768
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 32768
;
; MIPS64R2-LABEL: and_i64_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 32768
;
; MIPS64R6-LABEL: and_i64_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 32768
;
; MM32R3-LABEL: and_i64_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $3, $5, 32768
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i64_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $3, $5, 32768
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 32768, %b
  ret i64 %r
}

define signext i128 @and_i128_32768(i128 signext %b) {
; MIPS-LABEL: and_i128_32768:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 32768
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_32768:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 32768
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_32768:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 32768
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_32768:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 32768
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_32768:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 32768
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_32768:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 32768
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_32768:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    andi16 $5, $7, 32768
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i128_32768:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi16 $5, $7, 32768
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 32768, %b
  ret i128 %r
}

define signext i1 @and_i1_65(i1 signext %b) {
; MIPS-LABEL: and_i1_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    move $2, $4
;
; MIPS32R2-LABEL: and_i1_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    move $2, $4
;
; MIPS32R6-LABEL: and_i1_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    move $2, $4
;
; MIPS64-LABEL: and_i1_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    move $2, $4
;
; MIPS64R2-LABEL: and_i1_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    move $2, $4
;
; MIPS64R6-LABEL: and_i1_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    move $2, $4
;
; MM32R3-LABEL: and_i1_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    move $2, $4
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    move $2, $4
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 65, %b
  ret i1 %r
}

define signext i8 @and_i8_65(i8 signext %b) {
; MIPS-LABEL: and_i8_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 65
;
; MIPS32R2-LABEL: and_i8_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 65
;
; MIPS32R6-LABEL: and_i8_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 65
;
; MIPS64-LABEL: and_i8_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 65
;
; MIPS64R2-LABEL: and_i8_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 65
;
; MIPS64R6-LABEL: and_i8_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 65
;
; MM32R3-LABEL: and_i8_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $2, $4, 65
;
; MM32R6-LABEL: and_i8_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $2, $4, 65
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 65, %b
  ret i8 %r
}

define signext i16 @and_i16_65(i16 signext %b) {
; MIPS-LABEL: and_i16_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 65
;
; MIPS32R2-LABEL: and_i16_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 65
;
; MIPS32R6-LABEL: and_i16_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 65
;
; MIPS64-LABEL: and_i16_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 65
;
; MIPS64R2-LABEL: and_i16_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 65
;
; MIPS64R6-LABEL: and_i16_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 65
;
; MM32R3-LABEL: and_i16_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $2, $4, 65
;
; MM32R6-LABEL: and_i16_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $2, $4, 65
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 65, %b
  ret i16 %r
}

define signext i32 @and_i32_65(i32 signext %b) {
; MIPS-LABEL: and_i32_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 65
;
; MIPS32R2-LABEL: and_i32_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 65
;
; MIPS32R6-LABEL: and_i32_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 65
;
; MIPS64-LABEL: and_i32_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 65
;
; MIPS64R2-LABEL: and_i32_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 65
;
; MIPS64R6-LABEL: and_i32_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 65
;
; MM32R3-LABEL: and_i32_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $2, $4, 65
;
; MM32R6-LABEL: and_i32_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $2, $4, 65
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 65, %b
  ret i32 %r
}

define signext i64 @and_i64_65(i64 signext %b) {
; MIPS-LABEL: and_i64_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 65
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 65
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 65
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 65
;
; MIPS64R2-LABEL: and_i64_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 65
;
; MIPS64R6-LABEL: and_i64_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 65
;
; MM32R3-LABEL: and_i64_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $3, $5, 65
;
; MM32R6-LABEL: and_i64_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $3, $5, 65
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 65, %b
  ret i64 %r
}

define signext i128 @and_i128_65(i128 signext %b) {
; MIPS-LABEL: and_i128_65:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 65
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_65:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 65
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_65:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 65
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_65:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 65
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_65:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 65
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_65:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 65
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_65:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $5, $7, 65
;
; MM32R6-LABEL: and_i128_65:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $5, $7, 65
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 65, %b
  ret i128 %r
}

define signext i1 @and_i1_256(i1 signext %b) {
; MIPS-LABEL: and_i1_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i1_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i1_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i1_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    addiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i1_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    addiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i1_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    addiu $2, $zero, 0
;
; MM32R3-LABEL: and_i1_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i1_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i1 256, %b
  ret i1 %r
}

define signext i8 @and_i8_256(i8 signext %b) {
; MIPS-LABEL: and_i8_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i8_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i8_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i8_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    addiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i8_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    addiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i8_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    addiu $2, $zero, 0
;
; MM32R3-LABEL: and_i8_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jrc $ra
;
; MM32R6-LABEL: and_i8_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i8 256, %b
  ret i8 %r
}

define signext i16 @and_i16_256(i16 signext %b) {
; MIPS-LABEL: and_i16_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 256
;
; MIPS32R2-LABEL: and_i16_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 256
;
; MIPS32R6-LABEL: and_i16_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 256
;
; MIPS64-LABEL: and_i16_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 256
;
; MIPS64R2-LABEL: and_i16_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 256
;
; MIPS64R6-LABEL: and_i16_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 256
;
; MM32R3-LABEL: and_i16_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $2, $4, 256
;
; MM32R6-LABEL: and_i16_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $2, $4, 256
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i16 256, %b
  ret i16 %r
}

define signext i32 @and_i32_256(i32 signext %b) {
; MIPS-LABEL: and_i32_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    andi $2, $4, 256
;
; MIPS32R2-LABEL: and_i32_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    andi $2, $4, 256
;
; MIPS32R6-LABEL: and_i32_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    andi $2, $4, 256
;
; MIPS64-LABEL: and_i32_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 256
;
; MIPS64R2-LABEL: and_i32_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 256
;
; MIPS64R6-LABEL: and_i32_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 256
;
; MM32R3-LABEL: and_i32_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $2, $4, 256
;
; MM32R6-LABEL: and_i32_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $2, $4, 256
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i32 256, %b
  ret i32 %r
}

define signext i64 @and_i64_256(i64 signext %b) {
; MIPS-LABEL: and_i64_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $3, $5, 256
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $2, $zero, 0
;
; MIPS32R2-LABEL: and_i64_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $3, $5, 256
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-LABEL: and_i64_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $3, $5, 256
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $2, $zero, 0
;
; MIPS64-LABEL: and_i64_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    andi $2, $4, 256
;
; MIPS64R2-LABEL: and_i64_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    andi $2, $4, 256
;
; MIPS64R6-LABEL: and_i64_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    andi $2, $4, 256
;
; MM32R3-LABEL: and_i64_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $3, $5, 256
;
; MM32R6-LABEL: and_i64_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $3, $5, 256
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i64 256, %b
  ret i64 %r
}

define signext i128 @and_i128_256(i128 signext %b) {
; MIPS-LABEL: and_i128_256:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    andi $5, $7, 256
; MIPS-NEXT:    addiu $2, $zero, 0
; MIPS-NEXT:    addiu $3, $zero, 0
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    addiu $4, $zero, 0
;
; MIPS32R2-LABEL: and_i128_256:
; MIPS32R2:       # %bb.0: # %entry
; MIPS32R2-NEXT:    andi $5, $7, 256
; MIPS32R2-NEXT:    addiu $2, $zero, 0
; MIPS32R2-NEXT:    addiu $3, $zero, 0
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    addiu $4, $zero, 0
;
; MIPS32R6-LABEL: and_i128_256:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    andi $5, $7, 256
; MIPS32R6-NEXT:    addiu $2, $zero, 0
; MIPS32R6-NEXT:    addiu $3, $zero, 0
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    addiu $4, $zero, 0
;
; MIPS64-LABEL: and_i128_256:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    andi $3, $5, 256
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R2-LABEL: and_i128_256:
; MIPS64R2:       # %bb.0: # %entry
; MIPS64R2-NEXT:    andi $3, $5, 256
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    daddiu $2, $zero, 0
;
; MIPS64R6-LABEL: and_i128_256:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    andi $3, $5, 256
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    daddiu $2, $zero, 0
;
; MM32R3-LABEL: and_i128_256:
; MM32R3:       # %bb.0: # %entry
; MM32R3-NEXT:    li16 $2, 0
; MM32R3-NEXT:    li16 $3, 0
; MM32R3-NEXT:    li16 $4, 0
; MM32R3-NEXT:    jr $ra
; MM32R3-NEXT:    andi $5, $7, 256
;
; MM32R6-LABEL: and_i128_256:
; MM32R6:       # %bb.0: # %entry
; MM32R6-NEXT:    andi $5, $7, 256
; MM32R6-NEXT:    li16 $2, 0
; MM32R6-NEXT:    li16 $3, 0
; MM32R6-NEXT:    li16 $4, 0
; MM32R6-NEXT:    jrc $ra
entry:
  %r = and i128 256, %b
  ret i128 %r
}
