; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse2 -global-isel                       -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK64 --check-prefix=CHECK_SMALL --check-prefix=CHECK_SMALL64 --check-prefix=CHECK_NOPIC64
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse2 -global-isel -code-model=large     -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK64 --check-prefix=CHECK_LARGE --check-prefix=CHECK_LARGE64
; RUN: llc -mtriple=i386-linux-gnu   -mattr=+sse2 -global-isel                       -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK32 --check-prefix=CHECK_SMALL --check-prefix=CHECK_SMALL32
; RUN: llc -mtriple=i386-linux-gnu   -mattr=+sse2 -global-isel -code-model=large     -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK32 --check-prefix=CHECK_LARGE --check-prefix=CHECK_LARGE32
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse2 -global-isel -relocation-model=pic -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK64 --check-prefix=CHECK_SMALL --check-prefix=CHECK_SMALL64 --check-prefix=CHECK_PIC64

define void @test_float(float* %a , float %b) {
; CHECK_SMALL64-LABEL: test_float:
; CHECK_SMALL64:       # %bb.0: # %entry
; CHECK_SMALL64-NEXT:    movss .LCPI0_0(%rip), %xmm1 # xmm1 = mem[0],zero,zero,zero
; CHECK_SMALL64-NEXT:    addss %xmm0, %xmm1
; CHECK_SMALL64-NEXT:    movd %xmm1, %eax
; CHECK_SMALL64-NEXT:    movl %eax, (%rdi)
; CHECK_SMALL64-NEXT:    retq
;
; CHECK_LARGE64-LABEL: test_float:
; CHECK_LARGE64:       # %bb.0: # %entry
; CHECK_LARGE64-NEXT:    movabsq $.LCPI0_0, %rax
; CHECK_LARGE64-NEXT:    addss (%rax), %xmm0
; CHECK_LARGE64-NEXT:    movd %xmm0, %eax
; CHECK_LARGE64-NEXT:    movl %eax, (%rdi)
; CHECK_LARGE64-NEXT:    retq
;
; CHECK32-LABEL: test_float:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    movl 4(%esp), %eax
; CHECK32-NEXT:    movl 8(%esp), %ecx
; CHECK32-NEXT:    movss .LCPI0_0, %xmm0 # xmm0 = mem[0],zero,zero,zero
; CHECK32-NEXT:    movd %ecx, %xmm1
; CHECK32-NEXT:    addss %xmm0, %xmm1
; CHECK32-NEXT:    movd %xmm1, %ecx
; CHECK32-NEXT:    movl %ecx, (%eax)
; CHECK32-NEXT:    retl
entry:
  %aa = fadd float 5.500000e+00, %b
  store float %aa, float* %a
  ret void
}

