
use warnings FATAL => qw(all);
use ExtUtils::testlib;
use Test::More tests => 30 ;
use Data::Dumper ;

use Array::IntSpan;

my $trace = shift || 0 ;

my @expect= ([1,3,'ab'],[6,9,'cd']) ;
my $r = Array::IntSpan->new(@expect) ;

diag(Dumper $r) if $trace ;

ok ( defined($r) , 'Array::IntSpan new() works') ;
is_deeply( $r , \@expect, 'new content ok') ;

my $spawn = sub { 'sp:'.$_[2] ;} ;

foreach my $a ( 
               [[0, 0,'bc'],[0,0,[0, 0,'bc']]],
               [[0, 1,'bc'],[0,1,[0, 1,'bc'],[2,3,'ab']]],
               [[0, 3,'bc'],[0,1,[0, 3,'bc']]],
               [[0, 4,'bc'],[0,1,[0, 4,'bc']]],
               [[0, 5,'bc'],[0,1,[0, 5,'bc']]],
               [[0, 6,'bc'],[0,2,[0, 6,'bc'],[7,9,'cd']]],
               [[0, 9,'bc'],[0,2,[0, 9,'bc']]],
               [[0,10,'bc'],[0,2,[0,10,'bc']]],
               [[1, 3,'bc'],[0,1,[1, 3,'bc']]],
               [[1, 2,'bc'],[0,1,[1, 2,'bc'],[3, 3,'ab']]],
               [[2, 2,'bc'],[0,1,[1, 1,'ab'],[2, 2,'bc'],[3,3,'ab']]],
               [[2, 3,'bc'],[0,1,[1, 1,'ab'],[2, 3,'bc']]],
               [[2, 5,'bc'],[0,1,[1, 1,'ab'],[2, 5,'bc']]],
               [[2, 8,'bc'],[0,2,[1, 1,'ab'],[2, 8,'bc'],[9,9,'cd']]],
               [[2, 9,'bc'],[0,2,[1, 1,'ab'],[2, 9,'bc']]],
               [[2,10,'bc'],[0,2,[1, 1,'ab'],[2,10,'bc']]],
               [[4, 4,'bc'],[1,0,[4, 4,'bc']]],
               [[5, 6,'bc'],[1,1,[5, 6,'bc'],[7,9,'cd']]],
               [[5, 9,'bc'],[1,1,[5, 9,'bc']]],
               [[5,11,'bc'],[1,1,[5,11,'bc']]],
               [[6, 6,'bc'],[1,1,[6, 6,'bc'],[7,9,'cd']]],
               [[6, 9,'bc'],[1,1,[6, 9,'bc']]],
               [[7, 9,'bc'],[1,1,[6, 6,'cd'],[7,9,'bc']]],
               [[9,11,'bc'],[1,1,[6, 8,'cd'],[9,11,'bc']]],
               [[10,11,'bc'],[2,0,[10,11,'bc']]],
               [[10,11,'bc', $spawn],[2,0,[10,11,'bc']]],
               [[9,11,'bc', $spawn],[1,1,[6, 8,'sp:cd'],[9,11,'bc']]],
               [[2, 2,'bc', $spawn],[0,1,[1, 1,'sp:ab'],[2, 2,'bc'],[3,3,'sp:ab']]],
              )
  {
    my @r = $r->get_splice_parms(@{$a->[0]}) ;
    is_deeply(\@r, $a->[1], "get_splice_parms @{$a->[0]}") || diag(Dumper \@r);
  }

