/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.Values;

public class SetExp
extends AccessExp {
    Expression new_value;
    public static final int DEFINING_FLAG = 1;
    public static final int GLOBAL_FLAG = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int PROCEDURE = 8;
    public static final int SET_IF_UNBOUND = 16;
    public static final int HAS_VALUE = 32;

    public SetExp(Object symbol, Expression val) {
        this.symbol = symbol;
        this.new_value = val;
    }

    public SetExp(Declaration decl, Expression val) {
        this.binding = decl;
        this.symbol = decl.getSymbol();
        this.new_value = val;
    }

    public static SetExp makeDefinition(Object symbol, Expression val) {
        SetExp sexp = new SetExp(symbol, val);
        sexp.setDefining(true);
        return sexp;
    }

    public static SetExp makeDefinition(Declaration decl, Expression val) {
        SetExp sexp = new SetExp(decl, val);
        sexp.setDefining(true);
        return sexp;
    }

    public final Expression getNewValue() {
        return this.new_value;
    }

    public final boolean isDefining() {
        return (this.flags & 1) != 0;
    }

    public final void setDefining(boolean value) {
        this.flags = value ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean getHasValue() {
        return (this.flags & 0x20) != 0;
    }

    public final void setHasValue(boolean value) {
        this.flags = value ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean isFuncDef() {
        return (this.flags & 8) != 0;
    }

    public final void setFuncDef(boolean value) {
        this.flags = value ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & 0x10) != 0;
    }

    public final void setSetIfUnbound(boolean value) {
        this.flags = value ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext ctx) throws Throwable {
        Environment env = ctx.getEnvironment();
        Symbol sym = this.symbol instanceof Symbol ? (Symbol)this.symbol : env.getSymbol(this.symbol.toString());
        Object property = null;
        Language language = Language.getDefaultLanguage();
        if (this.isFuncDef() && language.hasSeparateFunctionNamespace()) {
            property = EnvironmentKey.FUNCTION;
        }
        if (this.isSetIfUnbound()) {
            Location loc = env.getLocation(sym, property);
            if (!loc.isBound()) {
                loc.set(this.new_value.eval(env));
            }
            if (this.getHasValue()) {
                ctx.writeValue(loc);
            }
            return;
        }
        Object new_val = this.new_value.eval(env);
        if (this.binding != null && !(this.binding.context instanceof ModuleExp)) {
            Object[] evalFrame = ctx.evalFrames[ScopeExp.nesting(this.binding.context)];
            if (this.binding.isIndirectBinding()) {
                if (this.isDefining()) {
                    evalFrame[this.binding.evalIndex] = Location.make(sym);
                }
                Location loc = (Location)evalFrame[this.binding.evalIndex];
                loc.set(this.new_value);
            } else {
                evalFrame[this.binding.evalIndex] = new_val;
            }
        } else if (this.isDefining()) {
            env.define(sym, property, new_val);
        } else {
            env.put(sym, property, new_val);
        }
        if (this.getHasValue()) {
            ctx.writeValue(new_val);
        }
    }

    public void compile(Compilation comp, Target target) {
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr code = comp.getCode();
        boolean needValue = this.getHasValue() && !(target instanceof IgnoreTarget);
        boolean valuePushed = false;
        Declaration decl = this.binding;
        Expression declValue = decl.getValue();
        if (decl.getFlag(0x20000000) && this.isDefining() && !decl.ignorable()) {
            BindingInitializer.create(decl, this.new_value, comp);
        } else if (declValue instanceof LambdaExp && decl.context instanceof ModuleExp && (!decl.isPrivate() || declValue instanceof ClassExp) && ((LambdaExp)declValue).getName() != null && declValue == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(comp);
        } else if (decl.context instanceof ModuleExp && (decl.getFlag(16384) || decl.isAlias()) && this.isDefining() && declValue != null) {
            if (needValue) {
                decl.load(this, 0, comp, Target.pushObject);
                valuePushed = true;
            }
        } else {
            AccessExp access = this;
            Declaration owner = this.contextDecl();
            if (!this.isDefining()) {
                while (decl != null && decl.isAlias() && (declValue = decl.getValue()) instanceof ReferenceExp) {
                    ReferenceExp rexp = (ReferenceExp)declValue;
                    Declaration orig = rexp.binding;
                    if (orig == null || owner != null && orig.needsContext()) break;
                    owner = rexp.contextDecl();
                    access = rexp;
                    decl = orig;
                }
            }
            if (decl.ignorable()) {
                this.new_value.compile(comp, Target.Ignore);
            } else if (decl.isAlias() && this.isDefining()) {
                decl.load(this, 1, comp, Target.pushObject);
                ClassType locType = ClassType.make("gnu.mapping.IndirectableLocation");
                code.emitCheckcast(locType);
                this.new_value.compile(comp, Target.pushObject);
                Method meth = locType.getDeclaredMethod("setAlias", 1);
                code.emitInvokeVirtual(meth);
            } else if (decl.isIndirectBinding()) {
                decl.load(access, 1, comp, Target.pushObject);
                if (this.isSetIfUnbound()) {
                    if (needValue) {
                        code.emitDup();
                        valuePushed = true;
                    }
                    code.pushScope();
                    code.emitDup();
                    Variable symLoc = code.addLocal(Compilation.typeLocation);
                    code.emitStore(symLoc);
                    code.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod("isBound", 0));
                    code.emitIfIntEqZero();
                    code.emitLoad(symLoc);
                }
                this.new_value.compile(comp, Target.pushObject);
                if (needValue && !this.isSetIfUnbound()) {
                    code.emitDupX();
                    valuePushed = true;
                }
                String setterName = "set";
                code.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod(setterName, 1));
                if (this.isSetIfUnbound()) {
                    code.emitFi();
                    code.popScope();
                }
            } else if (decl.isSimple()) {
                Variable var;
                Type type = decl.getType();
                this.new_value.compile(comp, decl);
                if (needValue) {
                    code.emitDup(type);
                    valuePushed = true;
                }
                if ((var = decl.getVariable()) == null) {
                    var = decl.allocateVariable(code);
                }
                code.emitStore(var);
            } else if (decl.context instanceof ClassExp && decl.field == null && !this.getFlag(8) && ((ClassExp)decl.context).isMakingClassPair()) {
                String setName = ClassExp.slotToMethodName("set", decl.getName());
                ClassExp cl = (ClassExp)decl.context;
                Method setter = cl.type.getDeclaredMethod(setName, 1);
                cl.loadHeapFrame(comp);
                this.new_value.compile(comp, decl);
                if (needValue) {
                    code.emitDupX();
                    valuePushed = true;
                }
                code.emitInvoke(setter);
            } else {
                Field field = decl.field;
                if (!field.getStaticFlag()) {
                    decl.loadOwningObject(owner, comp);
                }
                Type type = field.getType();
                this.new_value.compile(comp, decl);
                if (field.getStaticFlag()) {
                    if (needValue) {
                        code.emitDup(type);
                        valuePushed = true;
                    }
                    code.emitPutStatic(field);
                } else {
                    if (needValue) {
                        code.emitDupX();
                        valuePushed = true;
                    }
                    code.emitPutField(field);
                }
            }
        }
        if (needValue && !valuePushed) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (needValue) {
            target.compileFromStack(comp, this.getType());
        } else {
            comp.compileConstant(Values.empty, target);
        }
    }

    public final Type getType() {
        return !this.getHasValue() ? Type.void_type : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkSetExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.new_value = walker.walk(this.new_value);
    }

    public void print(OutPort out) {
        out.startLogicalBlock(this.isDefining() ? "(Define" : "(Set", ")", 2);
        out.writeSpaceFill();
        this.printLineColumn(out);
        if (this.binding == null || this.symbol.toString() != this.binding.getName()) {
            out.print('/');
            out.print(this.symbol);
        }
        if (this.binding != null) {
            out.print('/');
            out.print(this.binding);
        }
        out.writeSpaceLinear();
        this.new_value.print(out);
        out.endLogicalBlock(")");
    }

    public String toString() {
        return "SetExp[" + this.symbol + ":=" + this.new_value + ']';
    }
}

