/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class SynchronizedExp
extends Expression {
    Expression object;
    Expression body;

    public SynchronizedExp(Expression object2, Expression body) {
        this.object = object2;
        this.body = body;
    }

    protected boolean mustCompile() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(CallContext ctx) throws Throwable {
        Object result;
        Object value;
        Object object2 = value = this.object.eval(ctx);
        synchronized (object2) {
            result = this.body.eval(ctx);
        }
        ctx.writeValue(result);
    }

    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        this.object.compile(comp, Target.pushObject);
        code.emitDup(1);
        Scope scope = code.pushScope();
        Variable objvar = scope.addVariable(code, Type.pointer_type, null);
        code.emitStore(objvar);
        code.emitMonitorEnter();
        code.emitTryStart(false, target instanceof IgnoreTarget || target instanceof ConsumerTarget ? null : target.getType());
        this.body.compileWithPosition(comp, target);
        code.emitLoad(objvar);
        code.emitMonitorExit();
        code.emitTryEnd();
        code.emitCatchStart(null);
        code.emitLoad(objvar);
        code.emitMonitorExit();
        code.emitThrow();
        code.emitCatchEnd();
        code.emitTryCatchEnd();
        code.popScope();
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkSynchronizedExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.object = walker.walk(this.object);
        if (walker.exitValue == null) {
            this.body = walker.walk(this.body);
        }
    }

    public void print(OutPort ps) {
        ps.print("(Synchronized ");
        this.object.print(ps);
        ps.print(" ");
        this.body.print(ps);
        ps.print(")");
    }
}

