/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class FormatDate
extends SystemFunction
implements XSLTFunction {
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^ot]+?)([ot]?)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");

    public void checkArguments(StaticContext staticContext) throws XPathException {
        int n = this.getNumberOfArguments();
        if (n != 2 && n != 5) {
            throw new XPathException.Static("Function " + this.getName() + " must have " + "either two or five arguments", ExpressionTool.getLocator(this));
        }
        super.checkArguments(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        AtomicValue atomicValue;
        AtomicValue atomicValue2 = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        DateTimeValue dateTimeValue = (DateTimeValue)atomicValue2.convert(519);
        String string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
        string = this.getNumberOfArguments() > 2 ? ((atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext)) == null ? Locale.getDefault().getLanguage() : ((string = atomicValue.getStringValue()).length() >= 2 ? string.substring(0, 2) : Locale.getDefault().getLanguage())) : Locale.getDefault().getLanguage();
        return new StringValue(FormatDate.formatDate(dateTimeValue, string2, string));
    }

    private static String formatDate(DateTimeValue dateTimeValue, String string, String string2) throws XPathException {
        Numberer numberer = NumberInstruction.makeNumberer(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (n < string.length() && string.charAt(n) != '[') {
                stringBuffer.append(string.charAt(n));
                if (string.charAt(n) == ']' && (++n == string.length() || string.charAt(n) != ']')) {
                    throw new XPathException.Dynamic("Closing ']' in date picture must be written as ']]'");
                }
                ++n;
                continue;
            }
            if (n == string.length()) break;
            if (string.charAt(++n) == '[') {
                stringBuffer.append('[');
                ++n;
                continue;
            }
            int n2 = string.indexOf("]", n);
            if (n2 == -1) {
                throw new XPathException.Dynamic("Date format contains a '[' with no matching ']'");
            }
            String string3 = string.substring(n, n2);
            stringBuffer.append(FormatDate.formatComponent(dateTimeValue, string3.trim(), numberer));
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    private static String formatComponent(DateTimeValue dateTimeValue, String string, Numberer numberer) throws XPathException {
        Calendar calendar = dateTimeValue.getCalendar();
        Matcher matcher = componentPattern.matcher(string);
        if (!matcher.matches()) {
            System.err.println("Unrecognized date/time component [" + string + "] (ignored)");
            return "";
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (string3 == null || string3.equals("")) {
            switch (string2.charAt(0)) {
                case 'F': {
                    string3 = "Nn";
                    break;
                }
                case 'P': {
                    string3 = "n";
                    break;
                }
                case 'C': 
                case 'E': {
                    string3 = "N";
                    break;
                }
                default: {
                    string3 = "1";
                }
            }
        }
        switch (string2.charAt(0)) {
            case 'Y': {
                return FormatDate.formatNumber(string2, calendar.get(1), string3, numberer);
            }
            case 'M': {
                return FormatDate.formatNumber(string2, calendar.get(2) + 1, string3, numberer);
            }
            case 'D': {
                return FormatDate.formatNumber(string2, calendar.get(5), string3, numberer);
            }
            case 'd': {
                return FormatDate.formatNumber(string2, calendar.get(6), string3, numberer);
            }
            case 'W': {
                return FormatDate.formatNumber(string2, calendar.get(3), string3, numberer);
            }
            case 'w': {
                return FormatDate.formatNumber(string2, calendar.get(4), string3, numberer);
            }
            case 'H': {
                return FormatDate.formatNumber(string2, calendar.get(11), string3, numberer);
            }
            case 'h': {
                return FormatDate.formatNumber(string2, calendar.get(10), string3, numberer);
            }
            case 'm': {
                return FormatDate.formatNumber(string2, calendar.get(12), string3, numberer);
            }
            case 's': {
                return FormatDate.formatNumber(string2, calendar.get(13), string3, numberer);
            }
            case 'f': {
                int n = calendar.get(14) % 1000;
                return (1000 + n + "").substring(1);
            }
            case 'Z': 
            case 'z': {
                StringBuffer stringBuffer = new StringBuffer();
                DateTimeValue.appendTimezone(calendar, stringBuffer);
                return stringBuffer.toString();
            }
            case 'F': {
                return FormatDate.formatNumber(string2, calendar.get(7), string3, numberer);
            }
            case 'P': {
                int n = calendar.get(11);
                int n2 = calendar.get(12);
                return FormatDate.formatNumber(string2, n * 60 + n2, string3, numberer);
            }
            case 'C': {
                return "Gregorian";
            }
            case 'E': {
                return "*AD*";
            }
        }
        throw new XPathException.Dynamic("Unknown formatDate/time component specifier '" + string3.charAt(0) + "'");
    }

    private static String formatNumber(String string, int n, String string2, Numberer numberer) throws XPathException {
        Object object;
        int n2;
        int n3;
        Matcher matcher = formatPattern.matcher(string2);
        if (!matcher.matches()) {
            System.err.println("Unrecognized formatDate/time presentation modifier " + string2);
            matcher = formatPattern.matcher("1");
            matcher.matches();
        }
        String string3 = matcher.group(1);
        String string4 = matcher.group(2);
        String string5 = string4.equals("t") ? "traditional" : null;
        String string6 = string4.equals("o") ? "yes" : null;
        String string7 = matcher.group(3);
        if (string7 == null || string7.equals("")) {
            n3 = 1;
            n2 = Integer.MAX_VALUE;
        } else {
            object = FormatDate.getWidths(string7);
            n3 = object[0];
            n2 = object[1];
        }
        if (string3.equals("N") || string3.equals("n") || string3.equals("Nn")) {
            object = "";
            if (string.equals("M")) {
                object = numberer.monthName(n, n3, n2);
            } else if (string.equals("F")) {
                object = numberer.dayName(n, n3, n2);
            } else if (string.equals("P")) {
                object = numberer.halfDayName(n, n3, n2);
            } else {
                string3 = "1";
            }
            if (string3.equals("N")) {
                return ((String)object).toUpperCase();
            }
            if (string3.equals("n")) {
                return ((String)object).toLowerCase();
            }
            return object;
        }
        object = numberer.format(n, string3, 0, ",", string5, string6);
        while (((String)object).length() < n3) {
            object = ("00000000" + (String)object).substring(((String)object).length() + 8 - n3);
        }
        if (((String)object).length() > n2 && string2.charAt(0) == 'Y') {
            object = ((String)object).substring(((String)object).length() - n2);
        }
        return object;
    }

    private static int[] getWidths(String string) throws XPathException {
        try {
            Object object;
            int n = -1;
            int n2 = -1;
            if (!string.equals("")) {
                object = widthPattern.matcher(string);
                if (!((Matcher)object).matches()) {
                    System.err.println("Invalid width specifier '" + string + "' in formatDate/Time picture (ignored)");
                    n = 1;
                    n2 = 50;
                } else {
                    String string2 = ((Matcher)object).group(1);
                    n = string2 == null || string2.equals("") || string2.equals("*") ? 1 : Integer.parseInt(string2);
                    String string3 = ((Matcher)object).group(3);
                    n2 = string3 == null || string3.equals("") || string3.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(string3);
                }
            }
            if (n > n2 && n2 != -1) {
                throw new XPathException.Dynamic("Minimum width in date picture exceeds maximum width");
            }
            object = new int[2];
            object[0] = n;
            object[1] = n2;
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XPathException.Dynamic("Invalid integer as width in date picture");
        }
    }
}

