/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xpath.XPathException;

public final class Rounding
extends SystemFunction {
    public static final int FLOOR = 0;
    public static final int CEILING = 1;
    public static final int ROUND = 2;
    public static final int HALF_EVEN = 3;
    public static final int ABS = 4;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        switch (this.operation) {
            case 0: {
                return numericValue.floor();
            }
            case 1: {
                return numericValue.ceiling();
            }
            case 2: {
                return numericValue.round();
            }
            case 3: {
                int n = 0;
                if (this.getNumberOfArguments() == 2) {
                    AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
                    IntegerValue integerValue = (IntegerValue)atomicValue2.getPrimitiveValue();
                    n = (int)integerValue.getValue();
                }
                return numericValue.roundToHalfEven(n);
            }
            case 4: {
                int n = numericValue.compareTo(IntegerValue.ZERO);
                if (n < 0) {
                    return numericValue.negate();
                }
                if (n == 0) {
                    return numericValue.arithmetic(15, IntegerValue.ZERO);
                }
                return numericValue;
            }
        }
        throw new UnsupportedOperationException("Unknown rounding function");
    }
}

