/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class AttributeValueTemplate {
    private AttributeValueTemplate() {
    }

    public static Expression make(String string, int n, char c, StaticContext staticContext, Stack stack, boolean bl) throws XPathException {
        Expression expression;
        Object object;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n2 = n;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf(c, n2);
            int n5 = string.indexOf("{", n2);
            int n6 = string.indexOf("{{", n2);
            int n7 = string.indexOf("}", n2);
            int n8 = string.indexOf("}}", n2);
            if (!(n5 >= 0 && n4 >= n5 || n7 >= 0 && n4 >= n7)) {
                arrayList.add(new StringValue(string.substring(n2, n4)));
                n2 = n4;
                break;
            }
            if (n7 >= 0 && (n5 < 0 || n7 < n5)) {
                if (n7 != n8) {
                    throw new XPathException.Static("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                arrayList.add(new StringValue(string.substring(n2, n7 + 1)));
                n2 = n7 + 2;
                continue;
            }
            if (n6 >= 0 && n6 == n5) {
                arrayList.add(new StringValue(string.substring(n2, n6 + 1)));
                n2 = n6 + 2;
                continue;
            }
            if (n5 >= 0) {
                if (n5 > n2) {
                    arrayList.add(new StringValue(string.substring(n2, n5)));
                }
                try {
                    object = staticContext instanceof StaticQueryContext ? new QueryParser() : new ExpressionParser();
                    ((ExpressionParser)object).setScanOnly(bl);
                    if (stack != null) {
                        ((ExpressionParser)object).setRangeVariableStack(stack);
                    }
                    expression = ((ExpressionParser)object).parse(string, n5 + 1, 115, staticContext);
                    if (!bl) {
                        expression = expression.simplify();
                    }
                    n2 = ((ExpressionParser)object).getTokenizer().currentTokenStartIndex + 1;
                }
                catch (XPathException.Dynamic dynamic) {
                    return new ErrorExpression(dynamic);
                }
                arrayList.add(AttributeValueTemplate.makeStringJoin(expression));
                continue;
            }
            throw new IllegalStateException("Internal error parsing AVT");
        }
        if (bl) {
            return new IntegerValue(n2);
        }
        if (arrayList.size() == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (arrayList.size() == 1) {
            return ((Expression)arrayList.get(0)).simplify();
        }
        expression = (Concat)SystemFunction.makeSystemFunction("concat");
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        ((FunctionCall)expression).setArguments((Expression[])object);
        return ((FunctionCall)expression).simplify();
    }

    private static Expression makeStringJoin(Expression expression) throws XPathException {
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join");
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        return stringJoin;
    }
}

