/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;

public class XSLText
extends XSLStringConstructor {
    private boolean disable = false;

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "disable-output-escaping") {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        Item item;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            if (!(item instanceof StyleElement)) continue;
            this.compileError("xsl:text may not contain child elements");
            return;
        }
        super.validate();
    }

    public Instruction compile() throws TransformerConfigurationException {
        Text text = new Text(this.disable);
        if (this.select instanceof StringValue && ((StringValue)this.select).getStringValue().equals("")) {
            return null;
        }
        this.compileContent(text);
        return text;
    }
}

