/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.FacetListIterator;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleType
extends SchemaType {
    public static final String FINAL_ALL = "#all";
    public static final String FINAL_LIST = "list";
    public static final String FINAL_UNION = "union";
    public static final String FINAL_RESTRICTION = "restriction";
    private List facets = new ArrayList();

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public void setFacets(List facets) {
        this.facets = facets;
    }

    public void addFacet(Facet facet) {
        this.facets.add(facet);
    }

    public Facet getFacet(String name) {
        Iterator facets = this.getFacets(name);
        if (facets == null) {
            return null;
        }
        return (Facet)facets.next();
    }

    public List getFacetList() {
        return this.facets;
    }

    public Iterator getFacets(String name) {
        FacetListIterator fle = null;
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null && this.getDerivationMethod() != 8) {
            fle = (FacetListIterator)datatype.getFacets(name);
        }
        fle = new FacetListIterator(this.facets, fle);
        fle.setMask(name);
        return fle;
    }

    public FacetListIterator getFacets() {
        FacetListIterator fle = null;
        if (this.getDerivationMethod() == 8) {
            return new FacetListIterator(this.facets, null);
        }
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null && datatype != this) {
            fle = datatype.getFacets();
        }
        return new FacetListIterator(this.facets, fle);
    }

    public Iterator getLocalFacets() {
        if (this.facets == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.facets.iterator();
    }

    public SimpleType getBuiltInBaseType() {
        SimpleType base = this;
        while (base != null && base.getFingerprint() > 1023) {
            base = (SimpleType)base.getBaseType();
        }
        return base;
    }

    public boolean isNamespaceSensitive() {
        SimpleType base = this;
        int fp = base.getFingerprint();
        while (base != null && fp > 1023) {
            fp = (base = (SimpleType)base.getBaseType()).getFingerprint();
            if (fp != 530 && fp != 531) continue;
            return true;
        }
        return false;
    }

    public boolean validate(SchemaMarker schema) throws TransformerException {
        if (this.getFingerprint() < 1023) {
            return true;
        }
        if (this.getBaseType() == null) {
            this.setBaseType(BuiltInSchemaFactory.getSchemaType(593));
        } else if (this.getBaseType() instanceof SimpleType) {
            ((SimpleType)this.getBaseType()).validate(schema);
        } else if (!this.getBaseType().isSimpleType()) {
            schema.error("The base type of the simple type " + this.getDescription() + " is not a simple type", this);
            return false;
        }
        return true;
    }

    public abstract void validateContent(CharSequence var1, NamespaceResolver var2) throws ValidationException;

    public final SequenceIterator getTypedValue(NodeInfo node) throws XPathException {
        try {
            return this.getTypedValue(node.getStringValue());
        }
        catch (ValidationException err) {
            throw new XPathException.Dynamic("Value doesn't match its type annotation. " + err.getMessage());
        }
    }

    public abstract SequenceIterator getTypedValue(CharSequence var1) throws ValidationException;
}

