/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.ConstantPoolHyperlinkListener;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.util.ExtendedJLabel;

public abstract class AbstractDetailPane
extends JPanel {
    public static final String CPINFO_LINK_TEXT = "cp_info #";
    public static final Color COLOR_LINK = new Color(0, 128, 0);
    protected static final Color COLOR_HIGHLIGHT = new Color(128, 0, 0);
    protected BrowserServices services;
    private HashMap labelToMouseListener = new HashMap();

    protected AbstractDetailPane(BrowserServices browserServices) {
        this.services = browserServices;
        this.setupComponent();
    }

    public BrowserServices getBrowserServices() {
        return this.services;
    }

    public abstract void show(TreePath var1);

    protected abstract void setupComponent();

    protected ExtendedJLabel normalLabel() {
        return this.normalLabel("");
    }

    protected ExtendedJLabel normalLabel(String string) {
        ExtendedJLabel extendedJLabel = new ExtendedJLabel(string);
        return extendedJLabel;
    }

    protected ExtendedJLabel highlightLabel() {
        ExtendedJLabel extendedJLabel = this.normalLabel();
        extendedJLabel.setForeground(COLOR_HIGHLIGHT);
        return extendedJLabel;
    }

    protected ExtendedJLabel linkLabel() {
        ExtendedJLabel extendedJLabel = this.normalLabel();
        extendedJLabel.setForeground(COLOR_LINK);
        extendedJLabel.setRequestFocusEnabled(true);
        extendedJLabel.setUnderlined(true);
        return extendedJLabel;
    }

    protected int getIndex(TreePath treePath) {
        return ((BrowserTreeNode)treePath.getLastPathComponent()).getIndex();
    }

    protected AttributeInfo findAttribute(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath2.getLastPathComponent();
        String string = browserTreeNode.getType();
        ClassFile classFile = this.services.getClassFile();
        int n = this.getIndex(treePath2);
        int n2 = this.getIndex(treePath);
        if (string.equals("noContent")) {
            return classFile.getAttributes()[n2];
        }
        if (string.equals("field")) {
            return classFile.getFields()[n].getAttributes()[n2];
        }
        if (string.equals("method")) {
            return classFile.getMethods()[n].getAttributes()[n2];
        }
        return this.findAttribute(treePath2).getAttributes()[n2];
    }

    protected String getConstantPoolEntryName(int n) {
        try {
            return this.services.getClassFile().getConstantPoolEntryName(n);
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            return "invalid constant pool reference";
        }
    }

    protected void constantPoolHyperlink(ExtendedJLabel extendedJLabel, ExtendedJLabel extendedJLabel2, int n) {
        extendedJLabel.setText(CPINFO_LINK_TEXT + n);
        this.setupMouseListener(extendedJLabel, n);
        extendedJLabel.setCursor(Cursor.getPredefinedCursor(12));
        if (extendedJLabel2 != null) {
            extendedJLabel2.setToolTipText(extendedJLabel2.getText());
            extendedJLabel2.setText("<" + this.getConstantPoolEntryName(n) + ">");
        }
    }

    private void setupMouseListener(ExtendedJLabel extendedJLabel, int n) {
        MouseListener mouseListener = (MouseListener)this.labelToMouseListener.get(extendedJLabel);
        if (mouseListener != null) {
            extendedJLabel.removeMouseListener(mouseListener);
        }
        ConstantPoolHyperlinkListener constantPoolHyperlinkListener = new ConstantPoolHyperlinkListener(this.services, n);
        extendedJLabel.addMouseListener(constantPoolHyperlinkListener);
        this.labelToMouseListener.put(extendedJLabel, constantPoolHyperlinkListener);
    }
}

