/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.AnnotationDetailPane;
import org.gjt.jclasslib.browser.detail.ArrayElementValueDetailPane;
import org.gjt.jclasslib.browser.detail.AttributeDetailPane;
import org.gjt.jclasslib.browser.detail.ClassMemberDetailPane;
import org.gjt.jclasslib.browser.detail.ConstantPoolDetailPane;
import org.gjt.jclasslib.browser.detail.ElementValueDetailPane;
import org.gjt.jclasslib.browser.detail.ElementValuePairDetailPane;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.browser.detail.GeneralDetailPane;
import org.gjt.jclasslib.browser.detail.InterfaceDetailPane;

public class BrowserDetailPane
extends JPanel {
    private static final Dimension detailMinimumSize = new Dimension(150, 150);
    private static final Dimension detailPreferredSize = new Dimension(150, 150);
    private BrowserServices services;
    private HashMap nodeTypeToDetailPane = new HashMap();

    public BrowserDetailPane(BrowserServices browserServices) {
        this.services = browserServices;
        this.setupComponent();
    }

    public void showPane(String string, TreePath treePath) {
        if (this.services.getClassFile() == null) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.getLayout();
        AbstractDetailPane abstractDetailPane = (AbstractDetailPane)this.nodeTypeToDetailPane.get(string);
        if (abstractDetailPane != null) {
            abstractDetailPane.show(treePath);
        }
        cardLayout.show(this, string);
    }

    public AttributeDetailPane getAttributeDetailPane() {
        return (AttributeDetailPane)this.nodeTypeToDetailPane.get("attribute");
    }

    private void setupComponent() {
        this.setLayout(new CardLayout());
        this.add((Component)new JPanel(), "noContent");
        this.addScreen(new GeneralDetailPane(this.services), "general");
        this.addScreen(new ConstantPoolDetailPane(this.services), "constantPool");
        this.addScreen(new InterfaceDetailPane(this.services), "interface");
        this.addScreen(new ClassMemberDetailPane(this.services, 1), "field");
        this.addScreen(new ClassMemberDetailPane(this.services, 2), "method");
        this.addScreen(new AttributeDetailPane(this.services), "attribute");
        this.addScreen(new AnnotationDetailPane(this.services), "annotation");
        this.addScreen(new ElementValueDetailPane(this.services), "elementvalue");
        this.addScreen(new ElementValuePairDetailPane(this.services), "elementvaluepair");
        this.addScreen(new ArrayElementValueDetailPane(this.services), "arrayelementvalue");
        this.setMinimumSize(detailMinimumSize);
        this.setPreferredSize(detailPreferredSize);
    }

    private void addScreen(AbstractDetailPane abstractDetailPane, String string) {
        if (abstractDetailPane instanceof FixedListDetailPane) {
            this.add((Component)((FixedListDetailPane)abstractDetailPane).getScrollPane(), string);
        } else {
            this.add((Component)abstractDetailPane, string);
        }
        this.nodeTypeToDetailPane.put(string, abstractDetailPane);
    }
}

