/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class ImmediateByteInstruction
extends AbstractInstruction {
    protected boolean wide;
    private int immediateByte;

    public ImmediateByteInstruction(int n, boolean bl) {
        super(n);
        this.wide = bl;
    }

    public ImmediateByteInstruction(int n, boolean bl, int n2) {
        this(n, bl);
        this.immediateByte = n2;
    }

    public int getSize() {
        return super.getSize() + (this.wide ? 2 : 1);
    }

    public int getImmediateByte() {
        return this.immediateByte;
    }

    public void setImmediateByte(int n) {
        this.immediateByte = n;
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide(boolean bl) {
        this.wide = bl;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.immediateByte = this.wide ? byteCodeInput.readUnsignedShort() : byteCodeInput.readUnsignedByte();
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        if (this.wide) {
            byteCodeOutput.writeShort(this.immediateByte);
        } else {
            byteCodeOutput.writeByte(this.immediateByte);
        }
    }
}

