/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.gjt.jclasslib.util.ExtendedJLabel;

public class ExtendedTableCellRenderer
extends ExtendedJLabel
implements TableCellRenderer {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public ExtendedTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(NO_FOCUS_BORDER);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(NO_FOCUS_BORDER);
        }
        this.setValue(object);
        Color color = this.getBackground();
        boolean bl3 = color != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
        this.setOpaque(!bl3);
        return this;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    private void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }
}

