/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.merge;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JSR68Merger
extends FeaturesHolder {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$merge$JSR68Merger == null ? (class$com$sun$tdk$signaturetest$merge$JSR68Merger = JSR68Merger.class$("com.sun.tdk.signaturetest.merge.JSR68Merger")) : class$com$sun$tdk$signaturetest$merge$JSR68Merger);
    private Log log;
    private Result result;
    private Erasurator erasurator;
    private static final int flagclass = Modifier.PUBLIC.getValue() | Modifier.FINAL.getValue() | Modifier.INTERFACE.getValue() | Modifier.ABSTRACT.getValue();
    private static final int flagfield = Modifier.PUBLIC.getValue() | Modifier.PRIVATE.getValue() | Modifier.PROTECTED.getValue() | Modifier.STATIC.getValue() | Modifier.FINAL.getValue() | Modifier.VOLATILE.getValue() | Modifier.TRANSIENT.getValue();
    private static final int flagmethod = Modifier.PUBLIC.getValue() | Modifier.PRIVATE.getValue() | Modifier.PROTECTED.getValue() | Modifier.STATIC.getValue() | Modifier.FINAL.getValue() | Modifier.ABSTRACT.getValue() | Modifier.ACC_STRICT.getValue() | Modifier.NATIVE.getValue() | Modifier.SYNCHRONIZED.getValue();
    private static final int flaginner = Modifier.PUBLIC.getValue() | Modifier.PRIVATE.getValue() | Modifier.PROTECTED.getValue() | Modifier.STATIC.getValue() | Modifier.FINAL.getValue() | Modifier.INTERFACE.getValue() | Modifier.ABSTRACT.getValue();
    public static final int SOURCE_MODE = 0;
    public static final int BINARY_MODE = 1;
    private int mode;
    private Logger logger;
    private boolean debug = true;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$merge$JSR68Merger;

    public JSR68Merger(Log log, Result result, FeaturesHolder fh) {
        this.log = log;
        this.result = result;
        this.erasurator = new Erasurator();
        this.setFeatures(fh.getSupportedFeatures());
    }

    /*
     * Unable to fully structure code
     */
    public VirtualClassDescriptionLoader merge(MergedSigFile[] files, int mode) {
        this.mode = mode;
        result = new VirtualClassDescriptionLoader();
        this.setLogger();
        i = 0;
        while (i < files.length) {
            mf = files[i];
            it = mf.getClassSet().values().iterator();
            while (it.hasNext()) {
                cd = (ClassDescription)it.next();
                unique = true;
                sameClasses = new ArrayList<ClassDescription>();
                filesForSameClasses = new ArrayList<MergedSigFile>();
                sameClasses.add(cd);
                filesForSameClasses.add(mf);
                j = 0;
                while (j < files.length) {
                    if (i != j && (mfOther = files[j]).getClassSet().containsKey(cd.getQualifiedName())) {
                        unique = false;
                        sameClasses.add((ClassDescription)mfOther.getClassSet().get(cd.getQualifiedName()));
                        filesForSameClasses.add(mfOther);
                    }
                    ++j;
                }
                if (unique) {
                    result.add(cd);
                    continue;
                }
                resultedClass = new ClassDescription();
                resultedClass.setupClassName(cd.getQualifiedName());
                classes = sameClasses.toArray(new ClassDescription[0]);
                filesForClasses = filesForSameClasses.toArray(new MergedSigFile[0]);
                if (!this.merge(classes, resultedClass, filesForClasses) || !this.merge2(classes, resultedClass)) continue;
                result.add(resultedClass);
            }
            ++i;
        }
        it = result.getClassIterator();
        innersToRemove = new ArrayList<ClassDescription>();
        block9: while (it.hasNext()) {
            cd = (ClassDescription)it.next();
            try {
                result.load(cd.getPackageName());
                this.error(JSR68Merger.i18n.getString("Merger.error.packageconflict", cd.getPackageName()));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (cd.getQualifiedName().indexOf("$") < 0) continue;
            try {
                outer = result.load(cd.getDeclaringClassName());
                dc = outer.getDeclaredClasses();
                i = 0;
                while (i < dc.length) {
                    if (dc[i].getQualifiedName().equals(cd.getQualifiedName())) continue block9;
                    ++i;
                }
                it2 = result.getClassIterator();
                while (it2.hasNext()) {
                    similarInner = (ClassDescription)it2.next();
                    if (similarInner.getQualifiedName().indexOf("$") < 0 || !similarInner.getName().equals(cd.getName())) continue;
                    parent = outer;
                    block12: while (true) {
                        parent = result.load(parent.getSuperClass().getQualifiedName());
                        if (!similarInner.getDeclaringClassName().equals(parent.getQualifiedName())) continue;
                        i = 0;
                        while (true) {
                            if (i < files.length) ** break;
                            continue block12;
                            if (files[i].getClassSet().containsKey(cd.getQualifiedName())) {
                                j = 0;
                                while (j < files.length) {
                                    if (files[j].getClassSet().containsKey(similarInner.getQualifiedName()) && j == i) continue block9;
                                    ++j;
                                }
                                innersToRemove.add(cd);
                                continue block9;
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (Exception e) {}
                }
                d = new InnerDescr();
                d.setupClassName(cd.getQualifiedName());
                d.setModifiers(cd.getModifiers());
                newInners = new InnerDescr[dc.length + 1];
                System.arraycopy(dc, 0, newInners, 0, dc.length);
                newInners[dc.length] = d;
                outer.setNestedClasses(newInners);
            }
            catch (ClassNotFoundException ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
        }
        it = result.getClassIterator();
        while (it.hasNext()) {
            if (!innersToRemove.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    private boolean merge(ClassDescription[] similarClasses, ClassDescription result, MergedSigFile[] sigfiles) {
        boolean mAbs = similarClasses[0].isAbstract();
        int i = 1;
        while (i < similarClasses.length) {
            if (similarClasses[i].isAbstract() != mAbs) {
                this.error(similarClasses[0].getQualifiedName() + " " + i18n.getString("Merger.error.modifierconfict", "abstract"));
                return false;
            }
            ++i;
        }
        boolean mInt = similarClasses[0].isInterface();
        int i2 = 1;
        while (i2 < similarClasses.length) {
            if (similarClasses[i2].isInterface() != mInt) {
                this.error(similarClasses[0].getQualifiedName() + i18n.getString("Merger.error.classwithinterface"));
                return false;
            }
            ++i2;
        }
        if (!this.mergeMod(similarClasses, result)) {
            return false;
        }
        if (!this.mergeSuprs(similarClasses, result, sigfiles)) {
            return false;
        }
        return this.mergeInterfaces(similarClasses, result);
    }

    private boolean merge2(ClassDescription[] similarClasses, ClassDescription result) {
        if (this.prepareGenerics(similarClasses, result)) {
            this.mergeAnnotations(similarClasses, result);
            this.mergeTypeParameters(similarClasses, result);
            if (!this.mergeMembers(similarClasses, result)) {
                return false;
            }
            this.checkGenerics(result);
        }
        return true;
    }

    private void checkGenerics(ClassDescription result) {
        ClassDescription eResult = this.erasurator.fullErasure(result);
        ConstructorDescr[] genCostr = eResult.getDeclaredConstructors();
        MethodDescr[] genMeth = eResult.getDeclaredMethods();
        FieldDescr[] genFld = eResult.getDeclaredFields();
        HashSet<String> sims = new HashSet<String>();
        int i = 0;
        while (i < genCostr.length) {
            String s = genCostr[i].getSignature();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredConstructors()[i], s});
            }
            sims.add(s);
            ++i;
        }
        int i2 = 0;
        while (i2 < genMeth.length) {
            String s = genMeth[i2].getSignature();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i2]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredMethods()[i2], s});
            }
            sims.add(s);
            ++i2;
        }
        int i3 = 0;
        while (i3 < genFld.length) {
            String s = genFld[i3].getName();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i3]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredFields()[i3], s});
            }
            sims.add(s);
            ++i3;
        }
    }

    private boolean prepareGenerics(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<ClassDescription> hasGen = new ArrayList<ClassDescription>();
        ArrayList<ClassDescription> noGen = new ArrayList<ClassDescription>();
        int noGenPos = -1;
        int genPos = -1;
        int i = 0;
        while (i < similarClasses.length) {
            if (this.isGeneralized(similarClasses[i])) {
                hasGen.add(similarClasses[i]);
                genPos = i;
            } else {
                noGen.add(similarClasses[i]);
                noGenPos = i;
            }
            ++i;
        }
        if (hasGen.size() == 0 || noGen.size() == 0) {
            return true;
        }
        if (hasGen.size() == 1 && noGen.size() == 1) {
            ClassDescription hasGenCD = similarClasses[genPos];
            ConstructorDescr[] genCostr = hasGenCD.getDeclaredConstructors();
            MethodDescr[] genMeth = hasGenCD.getDeclaredMethods();
            FieldDescr[] genFld = hasGenCD.getDeclaredFields();
            ClassDescription noGenCD = similarClasses[noGenPos];
            ClassDescription hasGenEraCD = this.erasurator.fullErasure(hasGenCD);
            if (noGenCD.equals(hasGenEraCD)) {
                noGenCD.setTypeParameters(hasGenCD.getTypeParameters());
            }
            ConstructorDescr[] noGenCostr = noGenCD.getDeclaredConstructors();
            ConstructorDescr[] eraCostr = hasGenEraCD.getDeclaredConstructors();
            MethodDescr[] noGenMeth = noGenCD.getDeclaredMethods();
            MethodDescr[] eraMeth = hasGenEraCD.getDeclaredMethods();
            FieldDescr[] noGenFld = noGenCD.getDeclaredFields();
            FieldDescr[] eraFld = hasGenEraCD.getDeclaredFields();
            int i2 = 0;
            while (i2 < noGenCostr.length) {
                ConstructorDescr c = noGenCostr[i2];
                int j = 0;
                while (j < eraCostr.length) {
                    ConstructorDescr c2 = eraCostr[j];
                    ConstructorDescr c3 = genCostr[j];
                    if (c.equals(c2) && !c.equals(c3)) {
                        noGenCD.setConstructor(i2, (ConstructorDescr)c3.clone());
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < noGenMeth.length) {
                MethodDescr m = noGenMeth[i3];
                int j = 0;
                while (j < eraMeth.length) {
                    MethodDescr m2 = eraMeth[j];
                    MethodDescr m3 = genMeth[j];
                    if (m.getSignature().equals(m2.getSignature()) && m.getType().equals(m2.getType())) {
                        noGenCD.setMethod(i3, (MethodDescr)m3.clone());
                        break;
                    }
                    ++j;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < noGenFld.length) {
                FieldDescr f = noGenFld[i4];
                int j = 0;
                while (j < eraFld.length) {
                    FieldDescr f2 = eraFld[j];
                    FieldDescr f3 = genFld[j];
                    if (f.equals(f2) && f.getType().equals(f2.getType())) {
                        noGenCD.setField(i4, (FieldDescr)f3.clone());
                        break;
                    }
                    ++j;
                }
                ++i4;
            }
            return true;
        }
        if (hasGen.size() >= 1 || noGen.size() >= 1) {
            ClassDescription res1 = (ClassDescription)result.clone();
            ClassDescription res2 = (ClassDescription)result.clone();
            if (noGen.size() >= 0) {
                this.merge2(noGen.toArray(new ClassDescription[0]), res1);
            } else {
                res1 = (ClassDescription)noGen.get(0);
            }
            if (hasGen.size() >= 0) {
                this.merge2(hasGen.toArray(new ClassDescription[0]), res2);
            } else {
                res1 = (ClassDescription)hasGen.get(0);
            }
            this.merge2(new ClassDescription[]{res1, res2}, result);
            return false;
        }
        return true;
    }

    private boolean isGeneralized(ClassDescription clazz) {
        if (clazz.getTypeParameters() != null) {
            return true;
        }
        Iterator it = clazz.getMembersIterator();
        while (it.hasNext()) {
            MemberDescription md = (MemberDescription)it.next();
            if (!md.getDeclaringClassName().equals(clazz.getQualifiedName()) || md.getTypeParameters() == null) continue;
            return true;
        }
        return false;
    }

    private boolean mergeMod(MemberDescription[] x, MemberDescription z) {
        int i = 0;
        while (i < x.length) {
            z.setModifiers(z.getModifiers() | x[i].getModifiers());
            ++i;
        }
        int visibilityBits = Modifier.PUBLIC.getValue() | Modifier.PROTECTED.getValue() | Modifier.PRIVATE.getValue();
        z.setModifiers(z.getModifiers() & ~visibilityBits);
        int vis = 0;
        int i2 = 0;
        while (i2 < x.length) {
            vis |= x[i2].getModifiers() & visibilityBits;
            ++i2;
        }
        if ((vis & Modifier.PUBLIC.getValue()) != 0) {
            z.setModifiers(z.getModifiers() | Modifier.PUBLIC.getValue());
        } else if ((vis & Modifier.PROTECTED.getValue()) != 0) {
            z.setModifiers(z.getModifiers() | Modifier.PROTECTED.getValue());
        } else if ((vis & Modifier.PRIVATE.getValue()) == 0) {
            z.setModifiers(z.getModifiers() | Modifier.PRIVATE.getValue());
        }
        int i3 = 0;
        while (i3 < x.length) {
            if (!x[i3].isFinal()) {
                z.setModifiers(z.getModifiers() & ~Modifier.FINAL.getValue());
                break;
            }
            ++i3;
        }
        boolean mStat = x[0].isStatic();
        int i4 = 1;
        while (i4 < x.length) {
            if (x[i4].isStatic() != mStat) {
                this.error(JSR68Merger.show(x[0]) + " " + i18n.getString("Merger.error.modifierconfict", "static"));
                return false;
            }
            ++i4;
        }
        return true;
    }

    private boolean mergeSuprs(ClassDescription[] similarClasses, ClassDescription result, MergedSigFile[] sigfiles) {
        ArrayList<SuperClass> superclasses = new ArrayList<SuperClass>();
        int i = 0;
        while (i < similarClasses.length) {
            SuperClass sc = similarClasses[i].getSuperClass();
            if (sc != null && !superclasses.contains(sc)) {
                superclasses.add(sc);
            }
            ++i;
        }
        if (superclasses.isEmpty()) {
            return true;
        }
        if (superclasses.size() == 1) {
            result.setSuperClass((SuperClass)superclasses.iterator().next());
            return true;
        }
        int i2 = 0;
        while (i2 < sigfiles.length) {
            MergedSigFile file = sigfiles[i2];
            boolean all = true;
            int j = 0;
            while (j < superclasses.size()) {
                SuperClass sc = (SuperClass)superclasses.get(j);
                if (!file.getClassSet().containsKey(sc.getQualifiedName())) {
                    all = false;
                    break;
                }
                ++j;
            }
            if (all) {
                int j2 = 0;
                while (j2 < superclasses.size()) {
                    SuperClass scSub = (SuperClass)superclasses.get(j2);
                    boolean subSuperFound = true;
                    int k = 0;
                    while (k < superclasses.size()) {
                        try {
                            if (k != j2) {
                                SuperClass scSuper = (SuperClass)superclasses.get(k);
                                if (!file.getClassHierarchy().isSubclass(scSub.getQualifiedName(), scSuper.getQualifiedName())) {
                                    subSuperFound = false;
                                    break;
                                }
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            this.logger.log(Level.SEVERE, null, ex);
                        }
                        ++k;
                    }
                    if (subSuperFound) {
                        result.setSuperClass(scSub);
                        return true;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        this.error(JSR68Merger.show(result) + " " + i18n.getString("Merger.error.superclassesnotrelated"));
        this.logger.severe("Can't merge superclasses");
        return false;
    }

    private boolean mergeInterfaces(ClassDescription[] similarClasses, ClassDescription result) {
        TreeSet<SuperInterface> ts = new TreeSet<SuperInterface>(new Comparator(){

            public int compare(Object o1, Object o2) {
                SuperInterface s1 = (SuperInterface)o1;
                SuperInterface s2 = (SuperInterface)o2;
                return s1.getQualifiedName().compareTo(s2.getQualifiedName());
            }
        });
        ts.addAll(Arrays.asList(similarClasses[0].getInterfaces()));
        int i = 1;
        while (i < similarClasses.length) {
            ts.addAll(Arrays.asList(similarClasses[i].getInterfaces()));
            ++i;
        }
        result.createInterfaces(ts.size());
        Iterator it = ts.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            SuperInterface si = (SuperInterface)((SuperInterface)it.next()).clone();
            si.setDirect(true);
            result.setInterface(i2++, si);
        }
        return true;
    }

    private boolean mergeMembers(ClassDescription[] similarClasses, ClassDescription result) {
        this.makeMethods(similarClasses, result);
        this.makeCtors(similarClasses, result);
        this.makeFields(similarClasses, result);
        this.makeHiders(similarClasses, result);
        return true;
    }

    private boolean makeHiders(ClassDescription[] similarClasses, ClassDescription result) {
        HashSet internalFields = new HashSet(similarClasses[0].getInternalFields());
        HashSet internalClasses = new HashSet(similarClasses[0].getInternalClasses());
        HashSet xFields = new HashSet(similarClasses[0].getXFields());
        HashSet xClasses = new HashSet(similarClasses[0].getXClasses());
        int i = 1;
        while (i < similarClasses.length) {
            internalFields.retainAll(similarClasses[i].getInternalFields());
            internalClasses.retainAll(similarClasses[i].getInternalClasses());
            xFields.retainAll(similarClasses[i].getXFields());
            xClasses.retainAll(similarClasses[i].getXClasses());
            ++i;
        }
        result.setInternalClasses(internalClasses);
        result.setInternalFields(internalFields);
        result.setXFields(xFields);
        result.setXClasses(xFields);
        return true;
    }

    private boolean makeFields(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<FieldDescr> fields = new ArrayList<FieldDescr>();
        HashSet<String> h = new HashSet<String>();
        int i = 0;
        while (i < similarClasses.length) {
            FieldDescr[] fds = similarClasses[i].getDeclaredFields();
            int j = 0;
            while (j < fds.length) {
                FieldDescr fd = fds[j];
                if (!this.isFeatureSupported(FeaturesHolder.NonStaticConstants) && !fd.isStatic()) {
                    fd.setConstantValue(null);
                }
                ArrayList<FieldDescr> sameFields = new ArrayList<FieldDescr>();
                sameFields.add(fd);
                boolean isUnique = true;
                int k = 0;
                while (k < similarClasses.length) {
                    if (k != i) {
                        FieldDescr[] fd2 = similarClasses[k].getDeclaredFields();
                        int l = 0;
                        while (l < fd2.length) {
                            if (fd2[l].getName().equals(fd.getName())) {
                                isUnique = false;
                                sameFields.add(fd2[l]);
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                if (isUnique) {
                    if (!h.contains(fd.getName())) {
                        fields.add(fd);
                    }
                    h.add(fd.getName());
                } else {
                    FieldDescr f = new FieldDescr();
                    if (this.mergeFields(sameFields.toArray(new FieldDescr[0]), f)) {
                        if (!h.contains(f.getName())) {
                            fields.add(f);
                        }
                        h.add(f.getName());
                    }
                }
                ++j;
            }
            ++i;
        }
        result.setFields(fields.toArray(new FieldDescr[0]));
        return true;
    }

    private boolean mergeFields(FieldDescr[] similarFileds, FieldDescr result) {
        String type = similarFileds[0].getType();
        String value = similarFileds[0].getConstantValue();
        int i = 1;
        while (i < similarFileds.length) {
            if (!type.equals(similarFileds[i].getType())) {
                this.error(JSR68Merger.show(similarFileds[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarFileds[i].getType()});
                return false;
            }
            String anotherValue = similarFileds[i].getConstantValue();
            if (!(value == null && anotherValue == null || value != null && anotherValue != null && value.equals(anotherValue))) {
                this.error(JSR68Merger.show(similarFileds[0]) + i18n.getString("Merger.error.differentvalues"), new Object[]{value, anotherValue});
                return false;
            }
            ++i;
        }
        if (!this.mergeMod(similarFileds, result)) {
            return false;
        }
        result.setupMemberName(similarFileds[0].getQualifiedName());
        result.setType(type);
        result.setConstantValue(value);
        this.mergeAnnotations(similarFileds, result);
        this.mergeTypeParameters(similarFileds, result);
        return true;
    }

    private boolean makeMethods(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<MethodDescr> methods = new ArrayList<MethodDescr>();
        HashSet<String> h = new HashSet<String>();
        int i = 0;
        while (i < similarClasses.length) {
            MethodDescr[] mfs = similarClasses[i].getDeclaredMethods();
            int j = 0;
            while (j < mfs.length) {
                MethodDescr mf = mfs[j];
                ArrayList<MethodDescr> sameMethods = new ArrayList<MethodDescr>();
                ArrayList<Boolean> finalMods = new ArrayList<Boolean>();
                sameMethods.add(mf);
                finalMods.add(new Boolean(mf.isFinal() || similarClasses[i].isFinal()));
                boolean isUnique = true;
                int k = 0;
                while (k < similarClasses.length) {
                    if (k != i) {
                        MethodDescr[] mfs2 = similarClasses[k].getDeclaredMethods();
                        int l = 0;
                        while (l < mfs2.length) {
                            if (mfs2[l].getSignature().equals(mf.getSignature())) {
                                isUnique = false;
                                sameMethods.add(mfs2[l]);
                                finalMods.add(new Boolean(mfs2[l].isFinal() || similarClasses[k].isFinal()));
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                if (isUnique) {
                    if (!h.contains(mf.getSignature())) {
                        methods.add(mf);
                    }
                    h.add(mf.getSignature());
                } else {
                    MethodDescr m = new MethodDescr();
                    if (this.mergeMethods(sameMethods.toArray(new MethodDescr[0]), m, finalMods)) {
                        if (!h.contains(m.getSignature())) {
                            methods.add(m);
                        }
                        h.add(m.getSignature());
                    }
                }
                ++j;
            }
            ++i;
        }
        result.setMethods(methods.toArray(new MethodDescr[0]));
        return true;
    }

    private boolean makeCtors(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<ConstructorDescr> constr = new ArrayList<ConstructorDescr>();
        HashSet<String> h = new HashSet<String>();
        int i = 0;
        while (i < similarClasses.length) {
            ConstructorDescr[] cds = similarClasses[i].getDeclaredConstructors();
            int j = 0;
            while (j < cds.length) {
                ConstructorDescr cd = cds[j];
                ArrayList<ConstructorDescr> sameConstr = new ArrayList<ConstructorDescr>();
                sameConstr.add(cd);
                boolean isUnique = true;
                int k = 0;
                while (k < similarClasses.length) {
                    if (k != i) {
                        ConstructorDescr[] cds2 = similarClasses[k].getDeclaredConstructors();
                        int l = 0;
                        while (l < cds2.length) {
                            if (cds2[l].getSignature().equals(cd.getSignature())) {
                                isUnique = false;
                                sameConstr.add(cds2[l]);
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                if (isUnique) {
                    if (!h.contains(cd.getSignature())) {
                        constr.add(cd);
                    }
                    h.add(cd.getSignature());
                } else {
                    ConstructorDescr c = new ConstructorDescr();
                    if (this.mergeConstructors(sameConstr.toArray(new ConstructorDescr[0]), c)) {
                        if (!h.contains(c.getSignature())) {
                            constr.add(c);
                        }
                        h.add(c.getSignature());
                    }
                }
                ++j;
            }
            ++i;
        }
        result.setConstructors(constr.toArray(new ConstructorDescr[0]));
        return true;
    }

    private boolean mergeMethods(MemberDescription[] similarMethods, MemberDescription result, ArrayList finalMods) {
        String type = similarMethods[0].getType();
        int i = 1;
        while (i < similarMethods.length) {
            if (!type.equals(similarMethods[i].getType())) {
                this.error(JSR68Merger.show(similarMethods[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarMethods[i].getType()});
                return false;
            }
            ++i;
        }
        if (!this.mergeMod(similarMethods, result)) {
            return false;
        }
        result.setupMemberName(similarMethods[0].getQualifiedName());
        result.setType(similarMethods[0].getType());
        this.mergeAnnotations(similarMethods, result);
        boolean notAbstract = false;
        boolean hasFinal = true;
        int i2 = 0;
        while (i2 < similarMethods.length) {
            if (!similarMethods[i2].isAbstract()) {
                notAbstract = true;
            }
            if (!((Boolean)finalMods.get(i2)).booleanValue()) {
                hasFinal = false;
            }
            ++i2;
        }
        if (notAbstract) {
            result.setModifiers(result.getModifiers() & ~Modifier.ABSTRACT.getValue());
        }
        if (hasFinal) {
            result.setModifiers(result.getModifiers() | Modifier.FINAL.getValue());
        }
        result.setArgs(similarMethods[0].getArgs());
        result.setType(similarMethods[0].getType());
        this.mergeTypeParameters(similarMethods, result);
        return this.mergeThrows(similarMethods, result);
    }

    private void mergeTypeParameters(MemberDescription[] similarMembers, MemberDescription result) {
        String tp = null;
        boolean unique = true;
        int i = 0;
        while (i < similarMembers.length) {
            String tpp = similarMembers[i].getTypeParameters();
            if (tpp != null) {
                if (tp == null || tpp.equals(tp)) {
                    tp = tpp;
                } else {
                    unique = false;
                }
            }
            ++i;
        }
        if (unique) {
            result.setTypeParameters(tp);
        } else {
            this.error(JSR68Merger.show(similarMembers[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{tp, similarMembers[0].getTypeParameters()});
        }
    }

    private void mergeAnnotations(MemberDescription[] similarMembers, MemberDescription result) {
        TreeSet<AnnotationItem> annotations = new TreeSet<AnnotationItem>();
        int i = 0;
        while (i < similarMembers.length) {
            AnnotationItem[] annos = similarMembers[i].getAnnoList();
            int j = 0;
            while (j < annos.length) {
                annotations.add(annos[j]);
                ++j;
            }
            ++i;
        }
        result.setAnnoList(annotations.toArray(new AnnotationItem[0]));
    }

    private boolean mergeConstructors(ConstructorDescr[] similarCtors, ConstructorDescr result) {
        String type = similarCtors[0].getType();
        int i = 1;
        while (i < similarCtors.length) {
            if (!type.equals(similarCtors[i].getType())) {
                this.error(JSR68Merger.show(similarCtors[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarCtors[i].getType()});
                return false;
            }
            ++i;
        }
        if (!this.mergeMod(similarCtors, result)) {
            return false;
        }
        result.setupMemberName(similarCtors[0].getQualifiedName());
        result.setType(similarCtors[0].getType());
        result.setArgs(similarCtors[0].getArgs());
        this.mergeAnnotations(similarCtors, result);
        this.mergeTypeParameters(similarCtors, result);
        return this.mergeThrows(similarCtors, result);
    }

    private boolean mergeThrows(MemberDescription[] similarMethods, MemberDescription result) {
        if (this.mode == 1) {
            result.setThrowables("");
            return true;
        }
        String throwList = similarMethods[0].getThrowables();
        int i = 1;
        while (i < similarMethods.length) {
            if (!throwList.equals(similarMethods[1].getThrowables())) {
                Object[] tlist = new Object[]{JSR68Merger.show(throwList), JSR68Merger.show(similarMethods[1].getThrowables())};
                this.error(JSR68Merger.show(similarMethods[0]) + i18n.getString("Merger.error.throwconflict"), tlist);
                return false;
            }
            ++i;
        }
        result.setThrowables(throwList);
        return true;
    }

    private void error(String msg, Object[] params) {
        this.error(MessageFormat.format(msg, params));
    }

    private void error(String msg) {
        this.log.storeError(msg, null);
        this.result.error(i18n.getString("Merger.error"));
    }

    private static String show(MemberDescription x) {
        return x.getQualifiedName();
    }

    private static String show(String x) {
        return x;
    }

    private void setLogger() {
        this.logger = Logger.getLogger("merge");
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(new Handler(){

            public void publish(LogRecord arg0) {
                System.out.println(arg0.getMessage());
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        });
        this.logger.setLevel(Level.SEVERE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SOURCE_MODE = 0;
        BINARY_MODE = 1;
    }
}

