/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class SourceFileAttr
extends Attribute {
    private final ConstantUTFInfo mSourcefile;

    public SourceFileAttr(ConstantPool cp, String fileName) {
        this(cp, "SourceFile", fileName);
    }

    public SourceFileAttr(ConstantPool cp, String name, String fileName) {
        super(cp, name);
        this.mSourcefile = cp.addConstantUTF(fileName);
    }

    public SourceFileAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        this.mSourcefile = (ConstantUTFInfo)cp.getConstant(index);
    }

    public ConstantUTFInfo getFileName() {
        return this.mSourcefile;
    }

    public int getLength() {
        return 2;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSourcefile.getIndex());
    }
}

