/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class ConstantClassInfo
extends ConstantInfo {
    private final TypeDesc mType;
    private final ConstantUTFInfo mNameConstant;

    public ConstantClassInfo(ConstantUTFInfo nameConstant) {
        super(7);
        String name = nameConstant.getValue();
        this.mType = !name.endsWith(";") && !name.startsWith("[") ? TypeDesc.forClass(name) : TypeDesc.forDescriptor(name);
        this.mNameConstant = nameConstant;
    }

    public ConstantClassInfo(ConstantPool cp, String className) {
        super(7);
        String desc = className.replace('.', '/');
        this.mType = TypeDesc.forClass(className);
        this.mNameConstant = cp.addConstantUTF(desc);
    }

    public ConstantClassInfo(ConstantPool cp, String className, int dim) {
        super(7);
        String desc;
        TypeDesc type = TypeDesc.forClass(className);
        if (dim > 0) {
            while (--dim >= 0) {
                type = type.toArrayType();
            }
            desc = type.getDescriptor();
        } else {
            desc = className.replace('.', '/');
        }
        this.mType = type;
        this.mNameConstant = cp.addConstantUTF(desc);
    }

    public ConstantClassInfo(ConstantPool cp, TypeDesc type) {
        super(7);
        String desc = type.isArray() ? type.getDescriptor() : type.getRootName().replace('.', '/');
        this.mType = type;
        this.mNameConstant = cp.addConstantUTF(desc);
    }

    public TypeDesc getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstantClassInfo) {
            ConstantClassInfo other = (ConstantClassInfo)obj;
            return this.mType.equals(other.mType);
        }
        return false;
    }

    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mNameConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_Class_info: ".concat(this.getType().getFullName());
    }
}

