/*
 * Decompiled with CFR 0.152.
 */
package jd.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import jd.io.CharToByteUtf8;
import jd.io.OutputStreamWriter;
import jd.io.encoding.Latin2Encoding;
import jd.io.encoding.SimpleEncoding;
import jd.io.encoding.UnicodeEncoding;

public abstract class Encoding {
    private String name_;
    private String javaName_;
    private static final Hashtable encodingMap_ = new Hashtable(235);

    public static Encoding forName(String string) {
        Encoding encoding = (Encoding)encodingMap_.get(string.toUpperCase());
        return encoding != null ? encoding : new SimpleEncoding(string, string, 127);
    }

    public Encoding(String string, String string2) {
        this.name_ = string;
        this.javaName_ = string2;
    }

    public String getName() {
        return this.name_;
    }

    public String getJavaName() {
        return this.javaName_;
    }

    public abstract boolean isPrintable(char var1);

    public Writer createWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        if ("UTF8".equals(this.javaName_)) {
            return new OutputStreamWriter(outputStream, new CharToByteUtf8());
        }
        try {
            return new java.io.OutputStreamWriter(outputStream, this.javaName_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new java.io.OutputStreamWriter(outputStream, this.name_);
        }
    }

    public static void addEncoding(Encoding encoding) {
        encodingMap_.put(encoding.getName().toUpperCase(), encoding);
    }

    public static void addSimpleEncoding(String string, String string2, int n) {
        Encoding.addEncoding(new SimpleEncoding(string, string2, n));
    }

    static {
        Encoding.addSimpleEncoding("ASCII", "ASCII", 127);
        Encoding.addSimpleEncoding("BIG5", "Big5", 65535);
        Encoding.addSimpleEncoding("EBCDIC-CP-AR1", "Cp420", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-AR2", "Cp918", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-CA", "Cp037", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-CH", "Cp500", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-BE", "Cp500", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-DK", "Cp277", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-ES", "Cp284", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-FI", "Cp278", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-FR", "Cp297", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-GB", "Cp285", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-HE", "Cp424", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-IS", "Cp871", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-IT", "Cp280", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-NL", "Cp037", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-NO", "Cp277", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-ROECE", "Cp870", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-SE", "Cp278", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-US", "Cp037", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-WT", "Cp037", 255);
        Encoding.addSimpleEncoding("EBCDIC-CP-YU", "Cp870", 255);
        Encoding.addSimpleEncoding("EUC-JP", "EUC_JP", 65535);
        Encoding.addSimpleEncoding("EUC-KR", "EUC_KR", 65535);
        Encoding.addSimpleEncoding("EUC-CN", "EUC_CN", 65535);
        Encoding.addSimpleEncoding("EUC-TW", "EUC_TW", 65535);
        Encoding.addSimpleEncoding("GB2312", "EUC_CN", 65535);
        Encoding.addSimpleEncoding("ISO-Latin-1", "ASCII", 255);
        Encoding.addSimpleEncoding("ISO-2022-KR", "ISO2022KR", 65535);
        Encoding.addSimpleEncoding("ISO-2022-JP", "JIS", 65535);
        Encoding.addSimpleEncoding("ISO-8859-1", "ISO8859_1", 255);
        Encoding.addEncoding(new Latin2Encoding());
        Encoding.addSimpleEncoding("ISO-8859-3", "ISO8859_3", 255);
        Encoding.addSimpleEncoding("ISO-8859-4", "ISO8859_4", 255);
        Encoding.addSimpleEncoding("ISO-8859-5", "ISO8859_5", 255);
        Encoding.addSimpleEncoding("ISO-8859-6", "ISO8859_6", 255);
        Encoding.addSimpleEncoding("ISO-8859-7", "ISO8859_7", 255);
        Encoding.addSimpleEncoding("ISO-8859-8", "ISO8859_8", 255);
        Encoding.addSimpleEncoding("ISO-8859-9", "ISO8859_9", 255);
        Encoding.addSimpleEncoding("ISO-10646-UCS-2", "UTF16", 255);
        Encoding.addSimpleEncoding("MacRoman", "MacTEC", 255);
        Encoding.addSimpleEncoding("SHIFT_JIS", "SJIS", 65535);
        Encoding.addSimpleEncoding("US-ASCII", "ISO8859_1", 2047);
        Encoding.addEncoding(new UnicodeEncoding("UTF-8", "UTF8"));
        Encoding.addEncoding(new UnicodeEncoding("UTF-16", "UTF16"));
        Encoding.addEncoding(new UnicodeEncoding("UNICODE", "Unicode"));
        Encoding.addSimpleEncoding("WINDOWS-1250", "Cp1250", 255);
        Encoding.addSimpleEncoding("WINDOWS-1252", "Cp1252", 255);
    }
}

