/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.io.FileInputStream;
import java.io.InputStream;
import jd.io.FileUtil;
import jd.util.BadArgException;

public class Arguments {
    private String[] args_;
    private int length_;
    private int pos_;

    public Arguments(String[] stringArray) throws BadArgException {
        this.args_ = stringArray != null ? stringArray : new String[]{};
        this.length_ = this.args_.length;
        for (int i = 0; i < this.length_; ++i) {
            if (this.args_[i] == null) {
                throw new IllegalArgumentException("argument " + i + " is null");
            }
            if (this.args_[i].length() == 0) {
                throw new IllegalArgumentException("argument " + i + " has zero length");
            }
            if (this.args_[i].charAt(0) != '@' || this.args_[i].length() <= 1) continue;
            this.insertArgumentFile(i);
            --i;
        }
    }

    private void insertArgumentFile(int n) throws BadArgException {
        String string = this.args_[n].substring(1);
        InputStream inputStream = null;
        try {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            String[] stringArray = FileUtil.readLines(inputStream, true);
            String[] stringArray2 = new String[this.length_ + stringArray.length - 1];
            System.arraycopy(this.args_, 0, stringArray2, 0, n);
            System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
            System.arraycopy(this.args_, n + 1, stringArray2, n + stringArray.length, this.length_ - n - 1);
            this.length_ = stringArray2.length;
            this.args_ = stringArray2;
        }
        catch (Exception exception) {
            throw new BadArgException("Cannot read argument file " + string, exception);
        }
        finally {
            FileUtil.close(inputStream);
        }
    }

    public String next() {
        return this.hasMore() ? this.args_[this.pos_++] : null;
    }

    public String next(String string) throws BadArgException {
        String string2 = this.next();
        if (string2 == null) {
            throw new BadArgException(string);
        }
        return string2;
    }

    public boolean match(String string) {
        if (this.hasMore() && this.args_[this.pos_].equals(string)) {
            ++this.pos_;
            return true;
        }
        return false;
    }

    public boolean startsWith(String string) {
        return this.hasMore() && this.args_[this.pos_].startsWith(string);
    }

    public boolean hasMore() {
        return this.pos_ < this.length_;
    }

    public boolean hasMore(int n) {
        return this.pos_ + n <= this.length_;
    }
}

