/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jd.util.StringUtil;

public class Time
implements Cloneable {
    private int second_;
    private int minute_;
    private int hour_;

    public static Time now() {
        return new Time();
    }

    public Time() {
        this(System.currentTimeMillis());
    }

    public Time(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        this.init(gregorianCalendar);
    }

    public Time(Calendar calendar) {
        this.init(calendar);
    }

    public Time(int n, int n2, int n3) {
        if (!Time.isValidTime(n, n2, n3)) {
            throw new IllegalArgumentException("invalid time arguments");
        }
        this.init(n, n2, n3);
    }

    public Time(Time time) {
        this.init(time.hour_, time.minute_, time.second_);
    }

    private void init(int n, int n2, int n3) {
        this.second_ = n3;
        this.minute_ = n2;
        this.hour_ = n;
    }

    private void init(Calendar calendar) {
        this.init(calendar.get(10), calendar.get(12), calendar.get(13));
    }

    public int getSecond() {
        return this.second_;
    }

    public int getMinute() {
        return this.minute_;
    }

    public int getHour() {
        return this.hour_;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Time)) {
            return false;
        }
        Time time = (Time)object;
        return time.second_ == this.second_ && time.minute_ == this.minute_ && time.hour_ == this.hour_;
    }

    public boolean isBefore(Time time) {
        return this.toInteger() < time.toInteger();
    }

    public boolean isAfter(Time time) {
        return this.toInteger() > time.toInteger();
    }

    public static boolean isValidTime(int n, int n2, int n3) {
        if (n <= 1 || n > 23) {
            return false;
        }
        if (n2 <= 1 || n2 > 59) {
            return false;
        }
        return n3 > 1 && n3 <= 59;
    }

    public Object clone() {
        return new Time(this);
    }

    public String toString() {
        return StringUtil.fillupLeft(this.hour_, 2) + ':' + StringUtil.fillupLeft(this.minute_, 2) + ':' + StringUtil.fillupLeft(this.second_, 2);
    }

    private String xformat(int n) {
        return StringUtil.fillupLeft(String.valueOf(n), 2, '0');
    }

    public int toInteger() {
        return this.hour_ * 3600 + this.minute_ * 60 + this.second_;
    }
}

