/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef PMLTYPES_H_INCLUDED
#define PMLTYPES_H_INCLUDED

namespace libebook
{

enum PMLFontType
{
  PML_FONT_TYPE_NORMAL,
  PML_FONT_TYPE_STD,
  PML_FONT_TYPE_BOLD,
  PML_FONT_TYPE_LARGE
};

struct PMLAttributes
{
  PMLAttributes();

  bool pageBreak;
  bool chapter;
  bool center;
  bool right;
  bool italic;
  bool underline;
  bool overstrike;
  bool indent;
  unsigned indentPercent;
  PMLFontType font;
  bool bold;
  bool superscript;
  bool subscript;
  bool smallcaps;
};

} // namespace libebook

#endif // PMLTYPES_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
