/*
 * UPEK TouchChip driver for libfprint
 *
 * Copyright (C) 2012 Vasily Khoruzhick <anarsoul@gmail.com>
 * Copyright (C) 2012 Moganeshwaran Rajasegaran <moganeshwaran@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* *INDENT-OFF* */

#pragma once

#define UPEKTC_CMD_LEN 0x40
#define IMAGE_WIDTH 208
#define IMAGE_HEIGHT 288
#define IMAGE_SIZE (IMAGE_WIDTH * IMAGE_HEIGHT)
#define UPEKTC_SUM_THRESHOLD 10000
#define UPEKET_SUM_THRESHOLD 5000

struct setup_cmd
{
  unsigned char cmd[0x40];
  int           response_len;
};

static const struct setup_cmd upektc_setup_commands[] = {
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xfe, 0x00, 0x01,
      0xc0, 0xbd, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x00, 0xf0, 0xfd, 0x7f, 0x00, 0x60, 0xfd, 0x7f,
      0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x10, 0x00, 0x00, 0x00, 0xcc, 0xf8, 0x2f, 0x01,
      0x09, 0x48, 0xe7, 0x77, 0xf0, 0xfa, 0x2f, 0x01,
      0x09, 0x48, 0xe7, 0x77, 0xe0, 0x3a, 0xe6, 0x77
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf7, 0x00, 0x00,
      0xc8, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x58, 0xf9, 0x2f, 0x01,
      0xe9, 0x4f, 0x01, 0x10, 0xd8, 0xf8, 0x2f, 0x01,
      0x40, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x02, 0xfe, 0x00, 0x01, 0xc0, 0xbd, 0xf0, 0xff,
      0xff, 0xff, 0xff, 0xff, 0x00, 0xf0, 0xfd, 0x7f
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xf7, 0xcd, 0x00,
      0x2c, 0xf9, 0x2f, 0x01, 0x6d, 0x4f, 0x01, 0x10,
      0xac, 0xf8, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0xfe, 0x16, 0x10, 0x03, 0xee, 0x00, 0x37,
      0x01, 0x09, 0x02, 0x0e, 0x03, 0x18, 0x03, 0x1a,
      0x03, 0x20, 0x10, 0x2f, 0x11, 0x3f, 0x12, 0x44,
      0x01, 0x01, 0x07, 0x08, 0x0c, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00,
      0x02, 0xfe, 0x16, 0x10, 0x03, 0xee, 0x00, 0x37,
      0x01, 0x09, 0x02, 0x0e, 0x03, 0x18, 0x03, 0x1a,
      0x03, 0x20, 0x10, 0x2f, 0x11, 0x3f, 0x12, 0x44,
      0x01, 0x01, 0x07, 0x08, 0x0c, 0x00, 0x6c, 0x6c,
      0x00, 0xf9, 0x2f, 0x01, 0x97, 0x40, 0x01, 0x10,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xfa, 0x45, 0x03, 0x10, 0x02, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x00, 0x00, 0x3a, 0x50, 0xf9, 0x2f,
      0x01, 0x18, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
      0xff, 0x00, 0x00, 0x00, 0x00, 0x88, 0xf9, 0x2f,
      0x01, 0x91, 0x99, 0x00, 0x10, 0xf8, 0x00, 0x00,
      0x00, 0xbe, 0x99, 0x00, 0x10, 0xa0, 0xa6, 0x04,
      0x10, 0x01, 0x9b, 0x00, 0x10, 0x18, 0x00, 0x00,
      0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0d, 0xff, 0x36,
      0xdc, 0xf8, 0x2f, 0x01, 0xf1, 0x9d, 0x00, 0x10,
      0xfc, 0xf8, 0x2f, 0x01, 0x9d, 0xf8, 0x2f, 0x01,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x9e, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x13, 0x10, 0x00, 0x00, 0x00, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x0c, 0x37, 0x6a, 0x3d,
      0x73, 0x3d, 0x71, 0x0e, 0x01, 0x0e, 0x81, 0x3d,
      0x51, 0xf8, 0x2f, 0x01, 0x3a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x9e, 0xbf, 0x85,
      0x85, 0x02, 0x05, 0x26, 0x25, 0x4d, 0x13, 0x10,
      0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x09, 0x09,
      0x0f, 0x00, 0x6c, 0x6c, 0xf0, 0xf8, 0x2f, 0x01
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0x7c, 0x0a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
      0x14, 0xf5, 0x2f, 0x01, 0xa0, 0x20, 0x14, 0x00,
      0x40, 0xf8, 0x2f, 0x01, 0x05, 0x90, 0xf6, 0x77,
      0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
      0x50, 0xf8, 0x2f, 0x01, 0x40, 0x39, 0xf4, 0x77,
      0xa8, 0x20, 0x14, 0x00, 0x1c, 0xf6, 0x2f, 0x01,
      0x2c, 0x20, 0xf4, 0x77, 0x80, 0x4d, 0xfb, 0x77
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x03, 0xc8, 0x3a, 0x01, 0x00, 0x00,
      0x1f, 0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c,
      0x6c, 0x6c, 0x6c, 0x40, 0x40, 0x40, 0x40, 0x40,
      0x40, 0x40, 0x40, 0x40, 0x40, 0x6c, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x60, 0x62, 0x62, 0x62, 0x62,
      0x62, 0x51, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x40, 0xf9, 0x2f, 0x01, 0x4f, 0x9d, 0x00,
      0x10, 0x3a, 0x00, 0x00, 0x00, 0x04, 0xf9, 0x01
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x04, 0x02, 0x06, 0x0b, 0x07, 0x13,
      0x0e, 0x55, 0x56, 0x01, 0x44, 0xf8, 0x2f, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
      0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00,
      0xc8, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x07, 0x00, 0x20, 0x00, 0x3a, 0x0e, 0x13, 0x07,
      0x0f, 0x14, 0x07, 0x10, 0x15, 0x07, 0x12, 0x16,
      0x07, 0x13, 0x17, 0x07, 0x14, 0x18, 0x07, 0x15,
      0x18, 0x07, 0x16, 0x19, 0x07, 0x17, 0x1a, 0x07,
      0x19, 0x1b, 0x07, 0x1a, 0x1c, 0x07, 0x1b, 0x1d,
      0x07, 0x1c, 0x1e, 0x07, 0x1d, 0x1f, 0x07, 0x1e,
      0x20, 0x07, 0x1f, 0x21, 0x07, 0x20, 0x22, 0x07,
      0x21, 0x23, 0x07, 0x23, 0x23, 0x07, 0x24, 0x55
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x07, 0x00, 0x20, 0x3a, 0x26, 0x24, 0x07, 0x25,
      0x25, 0x07, 0x26, 0x25, 0x07, 0x27, 0x26, 0x07,
      0x28, 0x27, 0x07, 0x29, 0x27, 0x07, 0x2a, 0x28,
      0x07, 0x2b, 0x29, 0x07, 0x2d, 0x29, 0x07, 0x2e,
      0x2a, 0x07, 0x2f, 0x2b, 0x07, 0x30, 0x2b, 0x07,
      0x31, 0x2c, 0x07, 0x07, 0x1d, 0x1f, 0x07, 0x1e,
      0x20, 0x07, 0x1f, 0x21, 0x07, 0x20, 0x22, 0x07,
      0x21, 0x23, 0x07, 0x23, 0x23, 0x07, 0x24, 0x55
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x06, 0x0e, 0x81, 0x0e,
      0x81, 0x09, 0x4d, 0x00, 0x07, 0x00, 0x20, 0x3a,
      0x26, 0x24, 0x07, 0x25, 0x25, 0x07, 0x26, 0x25,
      0x07, 0x27, 0x26, 0x07, 0x28, 0x27, 0x07, 0x29,
      0x27, 0x07, 0x2a, 0x28, 0x07, 0x2b, 0x29, 0x07,
      0x2d, 0x29, 0x07, 0x2e, 0x2a, 0x07, 0x2f, 0x2b,
      0x07, 0x30, 0x2b, 0x07, 0x31, 0x2c, 0x07, 0x07,
      0x1d, 0x1f, 0x07, 0x1e, 0x20, 0x07, 0x1f, 0x21
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0e, 0x85, 0x36,
      0xd8, 0xf8, 0x2f, 0x01, 0xf1, 0x9d, 0x00, 0x10,
      0xf8, 0xf8, 0x2f, 0x01, 0x99, 0xf8, 0x2f, 0x01,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x9e, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x10, 0x10, 0x00, 0xff, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x00, 0x00,
      0x02, 0x9e, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x10, 0x10, 0x00, 0xff, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c,
      0xec, 0xf8, 0x2f, 0x01, 0x97, 0x40, 0x01, 0x10,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xfa, 0x45, 0x03, 0x10, 0x02, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf7, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x09, 0x09,
      0x0f, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x40, 0x40,
      0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
      0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x62,
      0x62, 0x62, 0x62, 0x62, 0x51, 0x6c, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf7, 0x00, 0x00,
      0x02, 0xf9, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x10, 0x10, 0x00, 0xff, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c,
      0x6c, 0x6c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
      0x40, 0x40, 0x40, 0x40, 0x6c, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x60, 0x62, 0x62, 0x62, 0x62, 0x62
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xf7, 0xf4, 0x00,
      0x14, 0xf9, 0x2f, 0x01, 0x6d, 0x4f, 0x01, 0x10,
      0x94, 0xf8, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0xf9, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x10, 0x10, 0x00, 0xff, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x20, 0x6c, 0x01,
      0x6d, 0x4f, 0x01, 0x10, 0x94, 0xf8, 0x2f, 0x01,
      0x40, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0xf9, 0xbf, 0x85,
      0x85, 0x02, 0x05, 0x26, 0x25, 0x4d, 0x10, 0x10,
      0x00, 0xff, 0x81, 0x6c, 0x00, 0x00, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x09, 0x09,
      0x0f, 0x00, 0x6c, 0x6c, 0xe8, 0xf8, 0x2f, 0x01
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf9, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c,
      0xe8, 0xf8, 0x2f, 0x01, 0xec, 0xf8, 0x2f, 0x01,
      0x97, 0x40, 0x01, 0x10, 0x03, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xfa, 0x45, 0x03, 0x10,
      0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xf9, 0x01, 0x00,
      0x1c, 0xf9, 0x2f, 0x01, 0x6d, 0x4f, 0x01, 0x10,
      0x9c, 0xf8, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x6c, 0xbf, 0x85, 0x85, 0x02, 0x05, 0x26,
      0x25, 0x4d, 0x10, 0x10, 0x00, 0xff, 0x81, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x09, 0x09, 0x0f, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x12, 0x1c, 0x0c, 0x1b,
      0x08, 0x1a, 0x07, 0x30, 0x08, 0x09, 0x6d, 0x08,
      0x27, 0x00, 0x9e, 0x00, 0x1e, 0x23, 0x47, 0x01,
      0x40, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x6c, 0xbf, 0x85,
      0x85, 0x02, 0x05, 0x26, 0x25, 0x4d, 0x10, 0x10,
      0x00, 0xff, 0x81, 0x6c, 0x00, 0x00, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x09, 0x09
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0d, 0xff, 0x36,
      0xdc, 0xf8, 0x2f, 0x01, 0xf1, 0x9d, 0x00, 0x10,
      0xfc, 0xf8, 0x2f, 0x01, 0x9d, 0xf8, 0x2f, 0x01,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1e, 0x3f, 0x05, 0x05, 0x02, 0x05, 0x26,
      0x27, 0x6d, 0x10, 0x10, 0x00, 0xff, 0x85, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x07, 0x08, 0x0c, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x08, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0xcf,
      0x00, 0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x10,
      0xfc, 0xf8, 0x2f, 0x01, 0x9d, 0xf8, 0x2f, 0x01,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1e, 0x3f, 0x05, 0x05, 0x02, 0x05, 0x26,
      0x27, 0x6d, 0x10, 0x10, 0x00, 0xff, 0x85, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x07, 0x08, 0x0c, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x08, 0x0e, 0x85, 0x09,
      0xed, 0x09, 0x6d, 0x09, 0xed, 0x1e, 0x3f, 0x05,
      0x05, 0x02, 0x05, 0x26, 0x27, 0x6d, 0x10, 0x10,
      0x00, 0xff, 0x85, 0x6c, 0x00, 0x00, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x07, 0x08,
      0x0c, 0x00, 0x6c, 0x6c, 0xf0, 0xf8, 0x2f, 0x01,
      0x97, 0x40, 0x01, 0x10, 0x08, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x3e, 0xf9, 0x2f, 0x01
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf3, 0x6c, 0x6c,
      0xf0, 0xf8, 0x2f, 0x01, 0x97, 0x40, 0x01, 0x10,
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x3e, 0xf9, 0x2f, 0x01, 0x04, 0xf9, 0x2f, 0x01,
      0x97, 0x40, 0x01, 0x10, 0x03, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x03, 0x10,
      0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x84, 0x00, 0x00, 0x00, 0x32, 0x02, 0xa3, 0x04,
      0x10, 0x3b, 0xa3, 0x04, 0x10, 0x1a, 0xa3, 0x04,
      0x10, 0xf9, 0xa2, 0x04, 0x10, 0xd8, 0xa2, 0x00,
      0xb9, 0x19, 0xe2, 0x87, 0xba, 0x56, 0x78, 0x72,
      0x68, 0x9e, 0x7a, 0xf4, 0x65, 0x6d, 0xd9, 0xde,
      0xf6, 0x33, 0xa2, 0x04, 0x10, 0x12, 0xa2, 0x04,
      0x10, 0xf1, 0xa1, 0x04, 0x10, 0x04, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xb4, 0x2d, 0x6c, 0xe9
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x06, 0x1a, 0x07, 0x1b,
      0x08, 0x1c, 0x0c, 0x77, 0x21, 0xac, 0xe5, 0x77,
      0x00, 0x00, 0x00, 0x00, 0xaa, 0x4e, 0x01, 0x10,
      0x3c, 0x01, 0x00, 0x00, 0xc4, 0xf8, 0x2f, 0x01,
      0xdc, 0xf8, 0x2f, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xb9, 0x19, 0xe2, 0x87,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x08, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0xcf,
      0x00, 0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0xcc, 0xf8, 0x2f, 0x01, 0x8b, 0x41, 0x01, 0x10,
      0x8c, 0xf8, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x04, 0x3d, 0x51, 0x0a,
      0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xfc, 0xf9, 0x2f, 0x01, 0x31, 0x10, 0x01, 0x10,
      0xd0, 0xf9, 0x2f, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x1a, 0x07, 0x1b, 0x08, 0x1c, 0x0c, 0xc6, 0xf8,
      0x66, 0xbc, 0xc4, 0xbe, 0x0b, 0x25, 0xc5, 0x4c,
      0xf4, 0x03, 0x10, 0x2f, 0x11, 0x3f, 0x12, 0x44
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x10, 0x36,
      0x88, 0xf9, 0x2f, 0x01, 0xf1, 0x9d, 0x00, 0x10,
      0xa8, 0xf9, 0x2f, 0x01, 0x49, 0xf9, 0x2f, 0x01,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x1e, 0x3f, 0x05, 0x05, 0x02, 0x05, 0x26,
      0x27, 0xed, 0x00, 0x10, 0x00, 0xff, 0x85, 0x6c,
      0x00, 0x00, 0xcf, 0x00, 0x01, 0x00, 0x00, 0x1f,
      0x01, 0x01, 0x07, 0x08, 0x0c, 0x00, 0x6c, 0x6c
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x8b, 0x00, 0x00, 0xbc, 0x3a, 0x40, 0xd3, 0x60,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xd8, 0xf4, 0x2f, 0x01, 0x80, 0x69, 0x67,
      0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xf0, 0xfd,
      0x7f, 0x00, 0x60, 0xfd, 0x7f, 0x3c, 0x01, 0x00,
      0x00, 0xa0, 0xf5, 0x2f, 0x01, 0x03, 0x01, 0x00,
      0x00, 0x9a, 0x11, 0xf4, 0x77, 0x9f, 0x11, 0xf4,
      0x77, 0x3c, 0x01, 0x00, 0x00, 0xa0, 0xf5, 0x01
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x00, 0xf6, 0x3a, 0x0b, 0x07, 0xa5,
      0x03, 0x2f, 0x63, 0x97, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0x30, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x12, 0xcd, 0xa6, 0x3c,
      0x36, 0xec, 0x6a, 0x73, 0x00, 0x64, 0x75, 0xdf,
      0x2e, 0x13, 0xec, 0xca, 0x3c, 0x03, 0x00, 0x00,
      0x06, 0xa5, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0x6a, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0xa4, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x06, 0xa5, 0x83, 0x1b, 0x8e, 0xac, 0x00, 0x00,
      0x0b, 0xa5, 0x08, 0x08, 0x03, 0x00, 0x00, 0x01,
      0x02, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x8d, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0xde, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x02, 0x18, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x02, 0x52, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x02, 0x8c, 0x3a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x02, 0xc6, 0x2a, 0x0b, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00,
      0xc8, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf1, 0x2f, 0x01,
      0x49, 0xf9, 0x2f, 0x01, 0x3a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x1e, 0x3f, 0x05,
      0x05, 0x02, 0x05, 0x26, 0x27, 0xed, 0x00, 0x10,
      0x00, 0xff, 0x85, 0x6c, 0x00, 0x00, 0xcf, 0x00,
      0x01, 0x00, 0x00, 0x1f, 0x01, 0x01, 0x07, 0x08,
      0x0c, 0x00, 0x6c, 0x6c, 0x9c, 0xf9, 0x2f, 0x01,
      0x97, 0x40, 0x01, 0x10, 0x03, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xf1, 0x01, 0x00,
      0xb4, 0xf9, 0x2f, 0x01, 0x6d, 0x4f, 0x01, 0x10,
      0x34, 0xf9, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0x10, 0x3a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x01, 0x4a, 0x2e, 0x0b, 0x06, 0xa5,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00, 0x00,
      0xc8, 0x01, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xfb, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x88, 0xf9, 0x2f, 0x01, 0x97, 0x40, 0x01, 0x10,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xfa, 0x45, 0x03, 0x10, 0x02, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xfb, 0x0f, 0x00,
      0xc4, 0xf9, 0x2f, 0x01, 0x6d, 0x4f, 0x01, 0x10,
      0x44, 0xf9, 0x2f, 0x01, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    },
    .response_len = 0x00
  }
};

static const struct setup_cmd upeket_setup_commands[] = {
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF3, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xfe, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xb8, 0x00, 0x00, 0x00, 0x98, 0xf1, 0x12, 0x00,
      0x03, 0xd4, 0xa9, 0x00, 0x64, 0x00, 0x00, 0x00,
      0x14, 0x20, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x84, 0xf1, 0x12, 0x00,
      0x0c, 0x00, 0x00, 0x00, 0x90, 0xf1, 0x12, 0x00,
      0xac, 0x0d, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf7, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x90, 0xf1, 0x12, 0x00,
      0x92, 0xc5, 0xa9, 0x00, 0x48, 0xf1, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xa2, 0xc5, 0xa9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x02, 0xfe, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xb8, 0x00, 0x00, 0x00, 0x98, 0xf1, 0x12, 0x00,
      0x03, 0xd4, 0xa9, 0x00, 0x64, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xf7, 0xcd, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xf8, 0xa9, 0x00,
      0x28, 0xf1, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xbb, 0xc4, 0xa9, 0x00, 0x02, 0xfa, 0x3f, 0x05,
      0x05, 0x02, 0x05, 0x23, 0x27, 0xe5, 0x13, 0x10,
      0x08, 0xff, 0x04, 0x6c, 0xc1, 0x41, 0x1c, 0x4c,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x60, 0xf1, 0x12, 0x00, 0x89, 0xae, 0xa9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8b, 0x00, 0x00, 0x00, 0x3a, 0x8c, 0xf1, 0x12,
      0x00, 0x64, 0xa8, 0xa7, 0x00, 0x84, 0xf1, 0x12,
      0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xf1, 0x12,
      0x00, 0x51, 0xa6, 0xa7, 0x00, 0xf8, 0x00, 0x00,
      0x00, 0x7e, 0xa6, 0xa7, 0x00, 0x24, 0x5a, 0xac,
      0x00, 0x01, 0xf1, 0x12, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x2f, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x7c,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0d, 0xff, 0x00,
      0x34, 0xf1, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xf1, 0x12, 0x00, 0x57, 0xcc, 0xa9, 0x00,
      0x34, 0xf1, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xbd, 0xcc, 0xa9, 0x00, 0x3a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00,
      0x34, 0xf1, 0x12, 0x00, 0x3a, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x0a, 0x37, 0x6a, 0x3d,
      0x73, 0x3d, 0x71, 0x0e, 0x01, 0x0e, 0x81, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0x12, 0x00,
      0x57, 0xcc, 0xa9, 0x00, 0x34, 0xf1, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xbd, 0xcc, 0xa9, 0x00,
      0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xb8, 0x00, 0x00, 0x00, 0x34, 0xf1, 0x12, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x3d, 0x51, 0x0e,
      0x01, 0x0e, 0x81, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xe8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xf1, 0x12, 0x00, 0x57, 0xcc, 0xa9, 0x00,
      0x34, 0xf1, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xbd, 0xcc, 0xa9, 0x00, 0x3a, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00,
      0x34, 0xf1, 0x12, 0x00, 0x3a, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0x78, 0x3A, 0x34, 0x00, 0x00,
      0xC0, 0x00, 0x00, 0x00, 0x00, 0x24, 0x1A, 0x80,
      0x7C, 0x04, 0xF1, 0x12, 0x00, 0x18, 0x00, 0x00,
      0x00, 0x48, 0x00, 0x00, 0x00, 0xCC, 0xEF, 0x12,
      0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xB0, 0xEF, 0x12, 0x00, 0x0C, 0x00, 0x0C,
      0x00, 0x84, 0x21, 0x15, 0x00, 0x48, 0x00, 0x00,
      0x00, 0x0C, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0xB2, 0x3A, 0x0B, 0x88, 0x01,
      0xB4, 0x01, 0x20, 0x91, 0x04, 0x07, 0x02, 0x24,
      0x20, 0xE2, 0x15, 0x0D, 0x10, 0x0F, 0x10, 0x11,
      0x11, 0x11, 0x11, 0x11, 0x12, 0x13, 0x13, 0x13,
      0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x16,
      0x16, 0x16, 0x17, 0x17, 0x17, 0x17, 0x18, 0x18,
      0x18, 0x18, 0x19, 0x19, 0x19, 0x19, 0x1A, 0x1A,
      0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0xEC, 0x3A, 0x0B, 0x1C, 0x1C,
      0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1D, 0x1D, 0x1D,
      0x1E, 0x1D, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1F, 0x1F, 0x20,
      0x20, 0x1F, 0x20, 0x20, 0x20, 0x21, 0x20, 0x21,
      0x20, 0x21, 0x20, 0x20, 0x20, 0x21, 0x20, 0x21,
      0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x21,
      0x21, 0x22, 0x21, 0x22, 0x21, 0x22, 0x22, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x26, 0x3A, 0x0B, 0x22, 0x22,
      0x22, 0x21, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22,
      0x22, 0x21, 0x22, 0x21, 0x22, 0x21, 0x21, 0x21,
      0x22, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x21,
      0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
      0x21, 0x21, 0x21, 0x20, 0x20, 0x21, 0x20, 0x20,
      0x20, 0x20, 0x20, 0x20, 0x1F, 0x1F, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x60, 0x3A, 0x0B, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1F,
      0x1E, 0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D, 0x1D,
      0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1C, 0x1D, 0x1D,
      0x1D, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
      0x1B, 0x1B, 0x1C, 0x1C, 0x1B, 0x1B, 0x1B, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x9A, 0x3A, 0x0B, 0x1B, 0x1B,
      0x1B, 0x1A, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1B,
      0x1B, 0x1B, 0x1B, 0x1A, 0x19, 0x1A, 0x1A, 0x1A,
      0x1A, 0x19, 0x1A, 0x1A, 0x1A, 0x19, 0x19, 0x19,
      0x19, 0x19, 0x19, 0x18, 0x19, 0x18, 0x18, 0x19,
      0x18, 0x17, 0x18, 0x17, 0x17, 0x17, 0x17, 0x17,
      0x17, 0x17, 0x17, 0x16, 0x17, 0x16, 0x16, 0x15,
      0x15, 0x16, 0x15, 0x16, 0x15, 0x15, 0x14, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0xD4, 0x2C, 0x0B, 0x14, 0x15,
      0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x12, 0x10,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x6E, 0x12, 0x00, 0x2B, 0xC5, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0x7C, 0xEF, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0x68, 0x0A, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xD0, 0xFD, 0x7F, 0xDC, 0x6D, 0x12, 0x00,
      0x2A, 0x26, 0x80, 0x7C, 0x98, 0x6D, 0x12, 0x00,
      0x00, 0x26, 0x80, 0x7C, 0xB8, 0x00, 0x00, 0x00,
      0x0C, 0x80, 0x01, 0x10, 0x90, 0x3E, 0x94, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x03, 0xB4, 0x3A, 0x1F, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E,
      0x1E, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1F, 0x1E, 0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D,
      0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1C, 0x1D,
      0x1D, 0x1D, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x03, 0xEE, 0x06, 0x0B, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x85, 0xB7, 0xA9, 0x00,
      0xB8, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00,
      0x18, 0x70, 0x12, 0x00, 0x2B, 0xC5, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0xD4, 0xF0, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x07, 0x00, 0x20, 0x00, 0x3a, 0x32, 0x2b, 0x07,
      0x2e, 0x29, 0x07, 0x2b, 0x27, 0x07, 0x27, 0x25,
      0x07, 0x23, 0x23, 0x07, 0x20, 0x21, 0x07, 0x1c,
      0x1d, 0x07, 0x19, 0x1a, 0x07, 0x15, 0x17, 0x07,
      0x12, 0x15, 0x07, 0x0e, 0x14, 0x07, 0x12, 0x17,
      0x07, 0x15, 0x19, 0x07, 0x19, 0x1c, 0x07, 0x1c,
      0x1f, 0x07, 0x20, 0x23, 0x07, 0x23, 0x25, 0x07,
      0x27, 0x27, 0x07, 0x2b, 0x29, 0x07, 0x2e, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x07, 0x00, 0x20, 0x3a, 0x26, 0x2b, 0x07, 0x32,
      0x2d, 0x07, 0x32, 0x2f, 0x07, 0x2e, 0x2d, 0x07,
      0x2b, 0x2b, 0x07, 0x27, 0x29, 0x07, 0x23, 0x27,
      0x07, 0x20, 0x25, 0x07, 0x1c, 0x22, 0x07, 0x19,
      0x1e, 0x07, 0x15, 0x1b, 0x07, 0x12, 0x19, 0x07,
      0x0e, 0x16, 0x07, 0x07, 0x19, 0x1c, 0x07, 0x1c,
      0x1f, 0x07, 0x20, 0x23, 0x07, 0x23, 0x25, 0x07,
      0x27, 0x27, 0x07, 0x2b, 0x29, 0x07, 0x2e, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x06, 0x0e, 0x81, 0x0e,
      0x81, 0x09, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x26, 0x00, 0x00, 0x00, 0x07, 0x00, 0x20, 0x3a,
      0x26, 0x2b, 0x07, 0x32, 0x2d, 0x07, 0x32, 0x2f,
      0x07, 0x2e, 0x2d, 0x07, 0x2b, 0x2b, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1c, 0x22, 0x07, 0x19, 0x1e, 0x07, 0x15, 0x1b,
      0x07, 0x12, 0x19, 0x07, 0x0e, 0x16, 0x07, 0x07,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3a, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
      0x1c, 0x1d, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e,
      0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3a, 0x3d, 0x3f, 0xff, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0e, 0x85, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
      0x07, 0x00, 0x20, 0x3a, 0x26, 0x2b, 0x07, 0x32,
      0x2d, 0x07, 0x32, 0x2f, 0x07, 0x2e, 0x2d, 0x07,
      0x2b, 0x2b, 0x07, 0x29, 0x07, 0x23, 0x27, 0x07,
      0x20, 0x25, 0x07, 0x1c, 0x22, 0x07, 0x19, 0x1e,
      0x07, 0x15, 0x1b, 0x07, 0x12, 0x19, 0x07, 0x1f,
      0x0e, 0x16, 0x07, 0x07, 0x19, 0x1c, 0x07, 0x1c,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0x0d, 0x62, 0x62,
      0x51, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
      0x3a, 0x41, 0x0e, 0x2b, 0x00, 0x00, 0x00, 0x00,
      0x78, 0xf1, 0x12, 0x00, 0x1a, 0xaa, 0xa7, 0x1f,
      0x00, 0x3a, 0x09, 0x00, 0x00, 0x00, 0x12, 0x41,
      0x0e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x4c, 0xf1, 0x12, 0x00, 0x89, 0xae,
      0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x20, 0x6C, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00,
      0x07, 0x00, 0x20, 0x3A, 0x26, 0x2B, 0x07, 0x32,
      0x2D, 0x07, 0x32, 0x2F, 0x07, 0x2E, 0x2D, 0x07,
      0x2B, 0x2B, 0x07, 0x27, 0x29, 0x07, 0x23, 0x27,
      0x07, 0x20, 0x25, 0x07, 0x1C, 0x22, 0x07, 0x19,
      0x1E, 0x07, 0x15, 0x1B, 0x07, 0x12, 0x19, 0x07,
      0x0E, 0x16, 0x07, 0x07, 0x19, 0x1C, 0x07, 0x1C,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF9, 0x6C, 0x6C,
      0x6C, 0x6C, 0x40, 0x40, 0x2E, 0x6D, 0x64, 0xED,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x4C, 0xF1, 0x12, 0x00, 0x89, 0xAE, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xE8, 0x3D, 0xAC, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x68, 0xF1, 0x12, 0x00,
      0x14, 0xAB, 0xA7, 0x00, 0x03, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF9, 0x00, 0x00,
      0x26, 0x00, 0x00, 0x00, 0x07, 0x00, 0x20, 0x3A,
      0x26, 0x2B, 0x07, 0x32, 0x2D, 0x07, 0x32, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1C, 0x22, 0x07, 0x19, 0x1E, 0x07, 0x15, 0x1B,
      0x07, 0x12, 0x19, 0x07, 0x0E, 0x16, 0x07, 0x07,
      0x19, 0x1C, 0x07, 0x1C, 0xBA, 0xEC, 0x64, 0xED,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x16, 0x1C, 0x13, 0x1B,
      0x0B, 0x1A, 0x0A, 0x30, 0x08, 0x09, 0x6D, 0x08,
      0xA7, 0x00, 0x9E, 0x00, 0x1E, 0x0C, 0x08, 0x1D,
      0x04, 0x23, 0x42, 0x2F, 0x07, 0x2E, 0x2D, 0x07,
      0x2B, 0x2B, 0x07, 0x27, 0x29, 0x07, 0x23, 0x27,
      0x07, 0x20, 0x25, 0x07, 0x1C, 0x22, 0x07, 0x19,
      0x1E, 0x07, 0x15, 0x1B, 0x07, 0x12, 0x19, 0x07,
      0x0E, 0x16, 0x07, 0x07, 0x19, 0x1C, 0x07, 0x1C,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0D, 0xFF, 0x30,
      0x08, 0x09, 0x6D, 0x08, 0xA7, 0x00, 0x9E, 0x00,
      0x1E, 0x0C, 0x08, 0x1D, 0x04, 0x23, 0x42, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1C, 0x22, 0x07, 0x19, 0x1E, 0x07, 0x15, 0x1B,
      0x07, 0x12, 0x19, 0x07, 0x0E, 0x16, 0x07, 0x07,
      0x19, 0x1C, 0x07, 0x1C, 0xBA, 0xEC, 0x64, 0xED,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF7, 0x64, 0xED,
      0x00, 0x00, 0x00, 0x00, 0x7C, 0xF1, 0x12, 0x00,
      0x1A, 0xAA, 0xA7, 0x00, 0x3A, 0x00, 0x00, 0x00,
      0x2A, 0x6D, 0x64, 0xED, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x50, 0xF1, 0x12, 0x00,
      0x89, 0xAE, 0xA9, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xE8, 0x3D, 0xAC, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xA9, 0x00,
      0x02, 0xFA, 0x3F, 0x05, 0x05, 0xC2, 0x85, 0xA6,
      0xA7, 0x6D, 0x10, 0x10, 0x08, 0xFF, 0x85, 0x6C,
      0x00, 0x00, 0xCF, 0x00, 0x01, 0x00, 0x00, 0x1F,
      0x01, 0x01, 0x0A, 0x0B, 0x13, 0x04, 0x6C, 0x6C,
      0x6C, 0x6C, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
      0x42, 0x42, 0x42, 0x42, 0x6C, 0x08, 0x00, 0x00,
      0x00, 0x00, 0x40, 0x42, 0x42, 0x42, 0x42, 0x42,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF7, 0xF3, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0D, 0xFF, 0x30,
      0x08, 0x09, 0x6D, 0x08, 0xA7, 0x00, 0x9E, 0x00,
      0x1E, 0x0C, 0x08, 0x1D, 0x04, 0x23, 0x42, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1C, 0x22, 0x07, 0x19, 0x1E, 0x07, 0x15, 0x1B,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xE8, 0x3D, 0xAC, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x5C, 0xF1, 0x12, 0x00, 0x14, 0xAB, 0xA7, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x5C, 0xF1, 0x12, 0x00,
      0x20, 0xAB, 0xA7, 0x00, 0x58, 0xF1, 0x12, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x99, 0xA9, 0xA7, 0x00,
      0xE8, 0x3D, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF0, 0x8F, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1C, 0x22, 0x07, 0x19, 0x1E, 0x07, 0x15, 0x1B,
      0x07, 0x12, 0x19, 0x07, 0x82, 0xEC, 0x64, 0xED,
      0x24, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xEA, 0x3D, 0xAC, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x08, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0xCF,
      0x00, 0x01, 0x00, 0x00, 0x1F, 0x01, 0x01, 0x00,
      0x0C, 0xCF, 0xA9, 0x00, 0x74, 0x70, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x1C, 0xCF, 0xA9, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF0, 0x8F, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x06, 0x0E, 0x85, 0x09,
      0xED, 0x09, 0x6D, 0x2F, 0x07, 0x2E, 0x2D, 0x07,
      0x2B, 0x2B, 0x07, 0x27, 0x29, 0x07, 0x23, 0x27,
      0x07, 0x20, 0x25, 0x07, 0x1C, 0x22, 0x07, 0x19,
      0x8A, 0xEC, 0x64, 0xED, 0x1C, 0xF1, 0x12, 0x00,
      0xFA, 0xCB, 0xA9, 0x00, 0x08, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x72, 0xF1, 0x12, 0x00,
      0xBD, 0xCC, 0xA9, 0x00, 0x0A, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x09, 0xED, 0x2F,
      0x07, 0x2E, 0x2D, 0x07, 0x2B, 0x2B, 0x07, 0x27,
      0x29, 0x07, 0x23, 0x27, 0x07, 0x20, 0x25, 0x07,
      0x1C, 0x22, 0x07, 0x19, 0x8A, 0xEC, 0x64, 0xED,
      0x1C, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x72, 0xF1, 0x12, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
      0x0A, 0x00, 0x00, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF3, 0x00, 0x00,
      0x8C, 0xF1, 0x12, 0x00, 0x1A, 0xAA, 0xA7, 0x00,
      0x3A, 0x00, 0x00, 0x00, 0x5A, 0x6D, 0x64, 0xED,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x60, 0xF1, 0x12, 0x00, 0x89, 0xAE, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xE8, 0x3D, 0xAC, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x7C, 0xF1, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x84, 0x00, 0x00, 0x00, 0x32, 0x02, 0xE0, 0xAD,
      0x00, 0xFC, 0xDF, 0xAD, 0x00, 0xDB, 0xDF, 0xAD,
      0x00, 0xBA, 0xDF, 0xAD, 0x00, 0x99, 0xDF, 0x6F,
      0x44, 0xC2, 0xE8, 0x20, 0x65, 0x73, 0x83, 0xAC,
      0xD7, 0x88, 0x6D, 0x59, 0x61, 0xE0, 0x3B, 0x3D,
      0xB7, 0xF4, 0xDE, 0xAD, 0x00, 0xD3, 0xDE, 0xAD,
      0x00, 0xB2, 0xDE, 0xAD, 0x00, 0x91, 0xDE, 0x00,
      0xA6, 0xEC, 0x64, 0xED, 0xA2, 0xEC, 0x64, 0xED,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x06, 0x1A, 0x0A, 0x1B,
      0x0B, 0x1C, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x92, 0xD5, 0x90, 0x7C, 0xBB, 0x9B, 0x80, 0x7C,
      0xB8, 0x00, 0x00, 0x00, 0xAC, 0x70, 0x12, 0x00,
      0x85, 0xB7, 0xA9, 0x00, 0xB8, 0x00, 0x00, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x08, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0xCF,
      0x00, 0x01, 0x00, 0x00, 0x1F, 0x01, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00,
      0x4C, 0x70, 0x12, 0x00, 0xEB, 0xC4, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0x68, 0x70, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xE8, 0x03, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xB0, 0x70, 0x12, 0x00,
      0x0C, 0xCF, 0xA9, 0x00, 0x68, 0x70, 0x12, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x00, 0x00,
      0xCF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x1F, 0x01, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
      0xD0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0xA6, 0xB5, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x94, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x28, 0x6F, 0x44, 0xC2,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0x78, 0x3A, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xD0, 0xFD, 0x7F, 0x94, 0xF0, 0x12,
      0x00, 0x2A, 0x26, 0x80, 0x7C, 0x50, 0xF0, 0x12,
      0x00, 0x00, 0x26, 0x80, 0x7C, 0x08, 0x00, 0x00,
      0x00, 0x0C, 0x80, 0x01, 0x10, 0x90, 0x3E, 0x94,
      0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x10, 0x00, 0x00, 0x00, 0x80, 0x69, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0xB2, 0x3A, 0x0B, 0x88, 0x01,
      0xB4, 0x01, 0x20, 0x91, 0x04, 0x07, 0x02, 0x24,
      0x20, 0xE2, 0x15, 0x0D, 0x10, 0x0F, 0x10, 0x11,
      0x11, 0x11, 0x11, 0x11, 0x12, 0x13, 0x13, 0x13,
      0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x16,
      0x16, 0x16, 0x17, 0x17, 0x17, 0x17, 0x18, 0x18,
      0x18, 0x18, 0x19, 0x19, 0x19, 0x19, 0x1A, 0x1A,
      0x1A, 0x1A, 0x1A, 0x1A, 0x1B, 0x1B, 0x1B, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x04, 0xEC, 0x3A, 0x0B, 0x1C, 0x1C,
      0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1D, 0x1D, 0x1D,
      0x1E, 0x1D, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1F, 0x1F, 0x20,
      0x20, 0x1F, 0x20, 0x20, 0x20, 0x21, 0x20, 0x21,
      0x20, 0x21, 0x20, 0x20, 0x20, 0x21, 0x20, 0x21,
      0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x21,
      0x21, 0x22, 0x21, 0x22, 0x21, 0x22, 0x22, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x26, 0x3A, 0x0B, 0x22, 0x22,
      0x22, 0x21, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22,
      0x22, 0x21, 0x22, 0x21, 0x22, 0x21, 0x21, 0x21,
      0x22, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x21,
      0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
      0x21, 0x21, 0x21, 0x20, 0x20, 0x21, 0x20, 0x20,
      0x20, 0x20, 0x20, 0x20, 0x1F, 0x1F, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x60, 0x3A, 0x0B, 0x1F, 0x1F,
      0x1F, 0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1F, 0x1F, 0x1F, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E,
      0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1F,
      0x1E, 0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D, 0x1D,
      0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1C, 0x1D, 0x1D,
      0x1D, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
      0x1B, 0x1B, 0x1C, 0x1C, 0x1B, 0x1B, 0x1B, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0x9A, 0x3A, 0x0B, 0x1B, 0x1B,
      0x1B, 0x1A, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A, 0x1B,
      0x1B, 0x1B, 0x1B, 0x1A, 0x19, 0x1A, 0x1A, 0x1A,
      0x1A, 0x19, 0x1A, 0x1A, 0x1A, 0x19, 0x19, 0x19,
      0x19, 0x19, 0x19, 0x18, 0x19, 0x18, 0x18, 0x19,
      0x18, 0x17, 0x18, 0x17, 0x17, 0x17, 0x17, 0x17,
      0x17, 0x17, 0x17, 0x16, 0x17, 0x16, 0x16, 0x15,
      0x15, 0x16, 0x15, 0x16, 0x15, 0x15, 0x14, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x05, 0xD4, 0x2C, 0x0B, 0x14, 0x15,
      0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x12, 0x10,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x6F, 0x12, 0x00, 0x2B, 0xC5, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0x2C, 0xF0, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF7, 0x1C, 0x1C,
      0x1B, 0x1B, 0x1C, 0x1C, 0x1B, 0x1B, 0x1B, 0x1B,
      0x1B, 0x1B, 0x1B, 0x1A, 0x1B, 0x1B, 0x1A, 0x1A,
      0x1A, 0x1B, 0x1B, 0x1B, 0x1B, 0x1A, 0x19, 0x1A,
      0x1A, 0x1A, 0x1A, 0x19, 0x1A, 0x1A, 0x1A, 0x19,
      0x19, 0x19, 0x19, 0x19, 0x19, 0x18, 0x19, 0x18,
      0x18, 0x19, 0x18, 0x17, 0x18, 0x17, 0x17, 0x17,
      0x17, 0x17, 0x17, 0x17, 0x17, 0x16, 0x17, 0x16,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF7, 0xF3, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x04, 0x3D, 0x40, 0x0A,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x52, 0xED, 0x64, 0xED,
      0xD4, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x0A, 0x10, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x52, 0xED, 0x64, 0xED, 0xD4, 0xF1, 0x12, 0x00,
      0xFA, 0xCB, 0xA9, 0x00, 0x03, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x8B, 0x00, 0x00, 0xA8, 0x3A, 0x00, 0x00, 0x00,
      0x00, 0xDC, 0x00, 0xEA, 0x00, 0x20, 0xED, 0x12,
      0x00, 0x0C, 0x00, 0x0E, 0x00, 0x00, 0xDC, 0xFD,
      0x7F, 0x20, 0xED, 0x12, 0x00, 0x05, 0x00, 0x00,
      0x00, 0xA0, 0x20, 0x15, 0x00, 0xC8, 0x00, 0x00,
      0x01, 0x43, 0x00, 0x3A, 0x00, 0x5C, 0x00, 0x44,
      0x00, 0x6F, 0x00, 0x63, 0x00, 0x75, 0x00, 0x6D,
      0x00, 0x65, 0x00, 0x6E, 0x00, 0x74, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x00, 0xE2, 0x3A, 0x0B, 0x07, 0xA5,
      0x03, 0x2F, 0x63, 0x97, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0x1C, 0x3A, 0x0B, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x12, 0x75, 0xB3, 0x05,
      0xE2, 0xBC, 0x74, 0x68, 0xAD, 0xAC, 0x7B, 0xB1,
      0xF8, 0x52, 0xD5, 0x8F, 0xF7, 0x03, 0x00, 0x00,
      0x06, 0xA5, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0x56, 0x3A, 0x0B, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0x90, 0x3A, 0x0B, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x06, 0xA5, 0x00, 0x22, 0x8E, 0xA3, 0x00, 0x00,
      0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x4C, 0xA5, 0xC8, 0xC8, 0x41, 0x50, 0x52, 0x39,
      0x07, 0x01, 0x00, 0x5F, 0x00, 0x00, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0xCA, 0x3A, 0x0B, 0x01, 0x48,
      0x34, 0x33, 0x00, 0x00, 0x00, 0x00, 0x76, 0x3E,
      0x84, 0x10, 0x2E, 0x48, 0x54, 0x0D, 0x98, 0x4C,
      0x14, 0x12, 0x72, 0x7A, 0x88, 0x0F, 0x9F, 0x84,
      0x98, 0x03, 0x52, 0xA6, 0xA4, 0x0A, 0x6E, 0xA8,
      0x54, 0x0C, 0x13, 0xB6, 0xE8, 0x0A, 0x77, 0xC0,
      0x94, 0x04, 0x73, 0xC6, 0x14, 0x07, 0x80, 0xCA,
      0xA8, 0x08, 0x31, 0xD2, 0x44, 0x09, 0x1E, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x02, 0x04, 0x3A, 0x0B, 0x74, 0x09,
      0x7A, 0xE4, 0x78, 0x17, 0xA5, 0xE4, 0x24, 0x09,
      0x45, 0xE8, 0x68, 0x07, 0xBA, 0xEC, 0xE8, 0x05,
      0xC2, 0xF0, 0x58, 0x16, 0x78, 0xF6, 0x98, 0x15,
      0x7C, 0xFC, 0xB8, 0x19, 0xAD, 0xFC, 0x74, 0x09,
      0x8C, 0x02, 0x39, 0x0D, 0x36, 0x06, 0x99, 0x06,
      0x9B, 0x08, 0x09, 0x0B, 0xA1, 0x0C, 0x25, 0x19,
      0x57, 0x10, 0x29, 0x05, 0x1A, 0x1C, 0x45, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x02, 0x3E, 0x3A, 0x0B, 0x55, 0x1E,
      0x69, 0x16, 0xA4, 0x24, 0xB9, 0x09, 0x1C, 0x44,
      0x55, 0x08, 0x9C, 0x44, 0xC9, 0x0B, 0x9F, 0x4A,
      0xF9, 0x19, 0x4C, 0x4C, 0xF9, 0x13, 0x5E, 0x50,
      0x09, 0x13, 0xB7, 0x6A, 0x09, 0x0A, 0x7C, 0x7A,
      0x75, 0x0F, 0x0E, 0x7E, 0x95, 0x00, 0x81, 0xA6,
      0x99, 0x0E, 0xC0, 0xAE, 0xE5, 0x19, 0xA0, 0xCC,
      0x35, 0x0D, 0x63, 0xE2, 0x85, 0x1F, 0x8E, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x02, 0x78, 0x3A, 0x0B, 0x35, 0x1D,
      0xC1, 0xE8, 0xA9, 0x0C, 0x7A, 0x06, 0xCA, 0x0E,
      0xAD, 0x12, 0xD6, 0x1C, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x02, 0xB2, 0x2A, 0x0B, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x40, 0x6C, 0x12, 0x00, 0x2B, 0xC5, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0xFC, 0xEC, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF1, 0x42, 0x42,
      0x40, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
      0xCE, 0x6D, 0x64, 0xED, 0x00, 0x00, 0x00, 0x00,
      0x30, 0xF2, 0x12, 0x00, 0x1A, 0xAA, 0xA7, 0x00,
      0x3A, 0x00, 0x00, 0x00, 0xF6, 0x6D, 0x64, 0xED,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x04, 0xF2, 0x12, 0x00, 0x89, 0xAE, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF1, 0x01, 0x00,
      0x1C, 0xCF, 0xA9, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x02, 0x0A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x8B, 0x00, 0x00, 0xFC, 0x3A, 0x1E, 0xDC, 0x74,
      0x09, 0x7A, 0xE4, 0x78, 0x17, 0xA5, 0xE4, 0x24,
      0x09, 0x45, 0xE8, 0x68, 0x07, 0xBA, 0xEC, 0xE8,
      0x05, 0xC2, 0xF0, 0x58, 0x16, 0x78, 0xF6, 0x98,
      0x15, 0x7C, 0xFC, 0xB8, 0x19, 0xAD, 0xFC, 0x74,
      0x09, 0x8C, 0x02, 0x39, 0x0D, 0x36, 0x06, 0x99,
      0x06, 0x9B, 0x08, 0x09, 0x0B, 0xA1, 0x0C, 0x25,
      0x19, 0x57, 0x10, 0x29, 0x05, 0x1A, 0x1C, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x8B, 0x00, 0x01, 0x36, 0x2E, 0x0B, 0x06, 0xA5,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x2B, 0xC5, 0xA9, 0x00,
      0x64, 0x00, 0x00, 0x00, 0xD8, 0xEE, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF0, 0xAC, 0x00,
      0xF0, 0xF1, 0x12, 0x00, 0x6A, 0xB1, 0xA7, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x06, 0xA5, 0x00, 0x01,
      0x00, 0x00, 0x12, 0x00, 0x14, 0xAB, 0xA7, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x0C, 0xF2, 0x12, 0x00,
      0x20, 0xAB, 0xA7, 0x00, 0x08, 0xF2, 0x12, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x99, 0xA9, 0xA7, 0x00,
      0xE8, 0x3D, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF0, 0x8F, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x52, 0xED, 0x64, 0xED,
      0xD4, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xEA, 0x3D, 0xAC, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF7, 0x12, 0x00,
      0x88, 0xC4, 0xA9, 0x00, 0xD8, 0xF1, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0xBB, 0xC4, 0xA9, 0x00,
      0x02, 0x00, 0x3F, 0x05, 0x0B, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xEA, 0x6D, 0x64, 0xED, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x10, 0xF2, 0x12, 0x00,
      0x89, 0xAE, 0xA9, 0x00, 0x03, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xA9, 0x00,
      0x02, 0xFA, 0x3F, 0x05, 0x0B, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF7, 0xF3, 0x00,
      0x0C, 0xCF, 0xA9, 0x00, 0x24, 0x71, 0x12, 0x00,
      0x40, 0x00, 0x00, 0x00, 0x1C, 0xCF, 0xA9, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF0, 0x8F, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x01, 0xFB, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xF0, 0xF1, 0x12, 0x00,
      0x89, 0xAE, 0xA9, 0x00, 0x03, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xE8, 0x3D, 0xAC, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x0C, 0xF2, 0x12, 0x00, 0x14, 0xAB, 0xA7, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x0C, 0xF2, 0x12, 0x00,
      0x20, 0xAB, 0xA7, 0x00, 0x08, 0xF2, 0x12, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0xFB, 0x0F, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x02, 0xF0, 0x8F, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x52, 0xED, 0x64, 0xED,
      0xD4, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x07, 0xA4, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x52, 0xED, 0x64, 0xED,
      0xD4, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x03, 0x00, 0x00, 0x00, 0x42, 0xED, 0x64, 0xED,
      0xE4, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x08, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0xCF,
      0x00, 0x01, 0x00, 0x00, 0x1F, 0x01, 0x01, 0x00,
      0xEB, 0xC4, 0xA9, 0x00, 0x64, 0x00, 0x00, 0x00,
      0x24, 0x71, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0xE8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x6C, 0x71, 0x12, 0x00, 0x0C, 0xCF, 0xA9, 0x00,
      0x24, 0x71, 0x12, 0x00, 0x40, 0x00, 0x00, 0x00,
      0x1C, 0xCF, 0xA9, 0x00, 0x00, 0x00, 0x00, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x21, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x36, 0xED, 0x64, 0xED,
      0xB0, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x06, 0xF2, 0x12, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
      0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x52, 0xED, 0x64, 0xED, 0xFC, 0xF1, 0x12, 0x00,
      0x0A, 0x00, 0x00, 0x00, 0x06, 0xF2, 0x12, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
  {
    .cmd = {
      0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x20, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x36, 0xED, 0x64, 0xED,
      0xB0, 0xF1, 0x12, 0x00, 0xFA, 0xCB, 0xA9, 0x00,
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x06, 0xF2, 0x12, 0x00, 0xBD, 0xCC, 0xA9, 0x00,
      0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x52, 0xED, 0x64, 0xED, 0xFC, 0xF1, 0x12, 0x00,
      0x0A, 0x00, 0x00, 0x00, 0x06, 0xF2, 0x12, 0x00,
    },
    .response_len = 0x00
  },
  {
    .cmd = {
      0x82, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x01, 0x02,
      0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
      0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
      0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B,
      0x1C, 0x1D, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
      0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E,
      0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36,
      0x37, 0x38, 0x39, 0x3A, 0x3D, 0x3F, 0xFF, 0x00,
    },
    .response_len = 0x40
  },
};

static const unsigned char scan_cmd[0x40] = {
  0x0e, 0x00, 0x03, 0xa8, 0x00, 0xb6, 0xbb, 0xbb,
  0xb8, 0xb7, 0xb8, 0xb5, 0xb8, 0xb9, 0xb8, 0xb9,
  0xbb, 0xbb, 0xbe, 0xbb, 0x4e, 0x16, 0xf4, 0x77,
  0xa8, 0x07, 0x32, 0x00, 0x6a, 0x16, 0xf4, 0x77,
  0x78, 0x24, 0x61, 0x00, 0xc8, 0x00, 0xec, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x3c, 0xf3, 0x2f, 0x01,
  0x05, 0x90, 0xf6, 0x77, 0x84, 0xf5, 0x2f, 0x01,
  0x05, 0x90, 0xf6, 0x00, 0xc8, 0x00, 0xec, 0x00
};
