/*
 * Copyright(C) 2012 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

namespace Friends
{
    public class Utils : Object
    {
        construct
        {
        }

        /**
         * Convert the timestamp into a string ending in 'ago'.
         * @param t The timestamp as a string.
         */
        public string create_time_string(string t)
        {
            string nt = t + "ZZ";
            var dtime = new DateTime.now_utc ();
            TimeVal ctime = TimeVal ();
            dtime.to_timeval (out ctime);

            TimeVal time = TimeVal ();
            time.from_iso8601 (nt);

            int d = (int)(ctime.tv_sec - time.tv_sec);
            if(d < 60)
                return _("a few seconds ago");
            if(d < 3600)
                return ngettext("%i minute ago", "%i minutes ago", (int) d/60).printf(d/60);
            if(d < 86400)
                return ngettext("%i hour ago", "%i hours ago", (int) d/3600).printf(d/3600);
            return ngettext("%i day ago", "%i days ago", (int) d/86400).printf(d/86400);
        }

        public string? get_avatar_path(string url)
        {
            string _avatar_cache_image = Path.build_path (Path.DIR_SEPARATOR_S, Environment.get_user_cache_dir(), "friends/avatars", GLib.Checksum.compute_for_string (GLib.ChecksumType.SHA1, url));
            debug ("AVATAR PATH: %s", _avatar_cache_image);
            return _avatar_cache_image;
        }
    }
}
