/*
 * Example of an application which only defines a server count
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#include "qservercount.h"

#include <QDebug>
#include <QTimer>

Controller::Controller(QIndicate::Server* server)
: mServer(server)
, mCount(0)
{
    connect(mServer, SIGNAL(serverDisplay()), SLOT(slotServerDisplay()));

    QTimer* timer = new QTimer(this);
    timer->setInterval(2000);
    connect(timer, SIGNAL(timeout()), SLOT(increaseCount()));
    timer->start();
}

void Controller::slotServerDisplay()
{
    qDebug() << "A listener wants us to display the server";
    mCount = 0;
    mServer->setCount(mCount);
}

void Controller::increaseCount()
{
    mCount++;
    mServer->setCount(mCount);
}

int main (int argc, char ** argv)
{
    QApplication app(argc, argv);

    if (argc != 3) {
        qCritical("Syntax: %s <desktop/file> <serverType>", argv[0]);
        return 1;
    }

    QString desktopFile = QString::fromLocal8Bit(argv[1]);
    QString serverType = QString::fromLocal8Bit(argv[2]);

    QIndicate::Server* server = QIndicate::Server::defaultInstance();
    server->setType(serverType);
    server->setDesktopFile(desktopFile);
    server->show();

    Controller controller(server);

    return app.exec();
}

#include "qservercount.moc"
