/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef TCRPARSER_H_INCLUDED
#define TCRPARSER_H_INCLUDED

#include <string>

#include <boost/shared_ptr.hpp>

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

class TCRParser
{
  // -Weffc++
  TCRParser(const TCRParser &other);
  TCRParser &operator=(const TCRParser &other);

public:

  TCRParser(WPXInputStream *input, WPXDocumentInterface *document);

  bool parse();

private:
  void readReplacementTable();

  boost::shared_ptr<WPXInputStream> uncompress();

  void writeText(boost::shared_ptr<WPXInputStream> input);

private:
  WPXInputStream *const m_input;
  WPXDocumentInterface *const m_document;

  std::string m_replacementTable[256];
};

} // namespace libebook

#endif // TCRPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
