/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef LIBEBOOK_UTILS_H_INCLUDED
#define LIBEBOOK_UTILS_H_INCLUDED

#ifdef DEBUG
#include <cstdio>
#endif

#include <string>

#include <boost/shared_ptr.hpp>

#include <libwpd-stream/libwpd-stream.h>
#include <libwpd/libwpd.h>

#ifdef _MSC_VER

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned uint32_t;
typedef int int32_t;
typedef unsigned __int64 uint64_t;
typedef __int64 int64_t;

#else

#ifdef HAVE_CONFIG_H

#include <config.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#else

// assume that the headers are there inside LibreOffice build when no HAVE_CONFIG_H is defined
#include <stdint.h>
#include <inttypes.h>

#endif

#endif

// debug message includes source file and line number
//#define VERBOSE_DEBUG 1

// do nothing with debug messages in a release compile
#ifdef DEBUG
#ifdef VERBOSE_DEBUG
#define EBOOK_DEBUG_MSG(M) std::printf("%15s:%5d: ", __FILE__, __LINE__); std::printf M
#define EBOOK_DEBUG(M) M
#else
#define EBOOK_DEBUG_MSG(M) std::printf M
#define EBOOK_DEBUG(M) M
#endif
#else
#define EBOOK_DEBUG_MSG(M)
#define EBOOK_DEBUG(M)
#endif

#define EBOOK_NUM_ELEMENTS(array) sizeof(array)/sizeof(array[0])

namespace libebook
{

uint8_t readU8(WPXInputStream *input, bool = false);
uint16_t readU16(WPXInputStream *input, bool bigEndian=false);
uint32_t readU32(WPXInputStream *input, bool bigEndian=false);
uint64_t readU64(WPXInputStream *input, bool bigEndian=false);

const unsigned char *readNBytes(WPXInputStream *input, unsigned long numBytes);

std::string readCString(WPXInputStream *input);
std::string readPascalString(WPXInputStream *input);

void skip(WPXInputStream *input, unsigned long numBytes);

void seek(WPXInputStream *input, unsigned long pos);
void seekRelative(WPXInputStream *input, long pos);

unsigned long getLength(WPXInputStream *input);

uint8_t readU8(boost::shared_ptr<WPXInputStream> input, bool = false);
uint16_t readU16(boost::shared_ptr<WPXInputStream> input, bool bigEndian=false);
uint32_t readU32(boost::shared_ptr<WPXInputStream> input, bool bigEndian=false);
uint64_t readU64(boost::shared_ptr<WPXInputStream> input, bool bigEndian=false);

const unsigned char *readNBytes(boost::shared_ptr<WPXInputStream> input, unsigned long numBytes);

std::string readCString(boost::shared_ptr<WPXInputStream> input);
std::string readPascalString(boost::shared_ptr<WPXInputStream> input);

void skip(boost::shared_ptr<WPXInputStream> input, unsigned long numBytes);

void seek(boost::shared_ptr<WPXInputStream> input, unsigned long pos);
void seekRelative(boost::shared_ptr<WPXInputStream> input, long pos);

unsigned long getLength(boost::shared_ptr<WPXInputStream> input);

class EndOfStreamException
{
public:
  EndOfStreamException();
};

class GenericException
{
};

} // namespace libebook

#endif // LIBEBOOK_UTILS_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
