/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef LRFTYPES_H_INCLUDED
#define LRFTYPES_H_INCLUDED

#include <deque>
#include <map>
#include <string>

#include <boost/optional.hpp>

namespace libebook
{

enum ImageType
{
  IMAGE_TYPE_UNKNOWN = 0,
  IMAGE_TYPE_JPEG = 0x11,
  IMAGE_TYPE_PNG = 0x12,
  IMAGE_TYPE_BMP = 0x13
};

struct LRFBookInfo
{
  LRFBookInfo();

  std::string author;
  std::string title;
  std::string bookID;
  std::string publisher;
  boost::optional<std::string> label;
  std::deque<std::string> categories;
  std::string classification;
  boost::optional<std::string> freeText;
};

struct LRFDocInfo
{
  LRFDocInfo();

  std::string language;
  std::string creator;
  std::string creationDate;
  std::string producer;
  unsigned page;
};

struct LRFMetadata
{
  LRFMetadata();

  LRFBookInfo bookInfo;
  LRFDocInfo docInfo;
  boost::optional<std::string> keyword;
};

struct LRFColor
{
  LRFColor();
  explicit LRFColor(unsigned color);
  LRFColor(unsigned char red, unsigned char green, unsigned char blue);

  unsigned char r;
  unsigned char g;
  unsigned char b;
};

struct LRFAttributes
{
  LRFAttributes();

  boost::optional<unsigned> fontSize;
  boost::optional<unsigned> fontWidth;
  boost::optional<unsigned> fontEscapement;
  boost::optional<unsigned> fontOrientation;
  boost::optional<unsigned> fontWeight;
  boost::optional<std::string> fontFacename;
  boost::optional<LRFColor> textColor;
  boost::optional<LRFColor> textBgColor;
  boost::optional<unsigned> wordSpace;
  boost::optional<unsigned> letterSpace;
  boost::optional<unsigned> baseLineSkip;
  boost::optional<unsigned> lineSpace;
  boost::optional<unsigned> parIndent;
  boost::optional<unsigned> parSkip;
  boost::optional<unsigned> height;
  boost::optional<unsigned> width;
  boost::optional<unsigned> locationX;
  boost::optional<unsigned> locationY;
  boost::optional<bool> italic;
  boost::optional<bool> sup;
  boost::optional<bool> sub;
};

typedef std::map<unsigned, LRFAttributes> LRFAttributeMap_t;

}

#endif // LRFTYPES_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
