/*
    Copyright (c) 2008-2009 NetAllied Systems GmbH

    This file is part of COLLADASaxFrameworkLoader.

    Licensed under the MIT Open Source License,
    for details please see LICENSE file or the website
    http://www.opensource.org/licenses/mit-license.php
*/

#include "COLLADASaxFWLStableHeaders.h"
#include "COLLADASaxFWLColladaParserAutoGen15Private.h"


// disable warning "unused variable"
#if defined(__INTEL_COMPILER) && !defined(WIN32)
template <typename T>
inline void disable_warning_unused(T &x) { (void)x; }
#    define DISABLE_WARNING_UNUSED(x) disable_warning_unused(x);
#else
#    define DISABLE_WARNING_UNUSED(x) (void)x;
#endif



namespace COLLADASaxFWL15
{


#ifdef GENERATEDSAXPARSER_VALIDATION


//---------------------------------------------------------------------
const int PCRE_OVECCOUNT = 30;    /* should be a multiple of 3 */

//---------------------------------------------------------------------
ParserError::ErrorType validate__version_enum( ParserString value )
{
    return validate__version_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__version_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__version_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__version_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__COLLADA( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* validationData = (COLLADA__ValidationData*)mValidationDataStack.newObject(sizeof(COLLADA__ValidationData));
        memset(validationData, 0, sizeof(COLLADA__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__COLLADA()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* validationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ASSET) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) || (validationData->validation_current_state == HASH_ELEMENT_SCENE) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_COLLADA, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__asset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 481:
        {
        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 334:
        {
        evaluate_scene__ValidationData* parentValidationData = (evaluate_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->render != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: render" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 614:
        {
        profile_cg_type____technique__ValidationData* parentValidationData = (profile_cg_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->annotate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: annotate" ) )
                return false;
        }
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 615:
        {
        profile_common_type____technique__ValidationData* parentValidationData = (profile_common_type____technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 616:
        {
        profile_gles2_type____technique__ValidationData* parentValidationData = (profile_gles2_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->annotate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: annotate" ) )
                return false;
        }
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 617:
        {
        profile_gles_type____technique__ValidationData* parentValidationData = (profile_gles_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->annotate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: annotate" ) )
                return false;
        }
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 618:
        {
        profile_glsl_type____technique__ValidationData* parentValidationData = (profile_glsl_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->annotate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: annotate" ) )
                return false;
        }
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 320:
        {
        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_animation != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_animation" ) )
                return false;
        }
        if ( parentValidationData->instance_formula != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_formula" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 12:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 536:
        {
        articulated_system__ValidationData* parentValidationData = (articulated_system__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 46:
        {
        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        if ( parentValidationData->imager != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: imager" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 84:
        {
        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 69:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 8:
        {
        extra__ValidationData* parentValidationData = (extra__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 48:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 613:
        {
        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 262:
        {
        image____image_type__ValidationData* parentValidationData = (image____image_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 17:
        {
        instance_kinematics_scene__ValidationData* parentValidationData = (instance_kinematics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->setparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: setparam" ) )
                return false;
        }
        if ( parentValidationData->bind_kinematics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: bind_kinematics_model" ) )
                return false;
        }
        if ( parentValidationData->bind_joint_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: bind_joint_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 216:
        {
        kinematics_model__ValidationData* parentValidationData = (kinematics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 300:
        {
        kinematics_scene__ValidationData* parentValidationData = (kinematics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_kinematics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_kinematics_model" ) )
                return false;
        }
        if ( parentValidationData->instance_articulated_system != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_articulated_system" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 257:
        {
        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation_clip != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: animation_clip" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 239:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: animation" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 584:
        {
        library_articulated_systems__ValidationData* parentValidationData = (library_articulated_systems__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->articulated_system != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: articulated_system" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 565:
        {
        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->camera != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: camera" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 275:
        {
        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->controller != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: controller" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 206:
        {
        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->effect != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: effect" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 96:
        {
        library_force_fields__ValidationData* parentValidationData = (library_force_fields__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->force_field != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: force_field" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 101:
        {
        library_formulas__ValidationData* parentValidationData = (library_formulas__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->formula != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: formula" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 635:
        {
        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->geometry != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: geometry" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 369:
        {
        library_images__ValidationData* parentValidationData = (library_images__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->image != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 285:
        {
        library_joints__ValidationData* parentValidationData = (library_joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joint != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: joint" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 227:
        {
        library_kinematics_models__ValidationData* parentValidationData = (library_kinematics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->kinematics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: kinematics_model" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 172:
        {
        library_kinematics_scenes__ValidationData* parentValidationData = (library_kinematics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->kinematics_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: kinematics_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 145:
        {
        library_lights__ValidationData* parentValidationData = (library_lights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->light != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: light" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 45:
        {
        library_materials__ValidationData* parentValidationData = (library_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->material != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: material" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 620:
        {
        library_nodes__ValidationData* parentValidationData = (library_nodes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 462:
        {
        library_physics_materials__ValidationData* parentValidationData = (library_physics_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_material != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_material" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 7:
        {
        library_physics_models__ValidationData* parentValidationData = (library_physics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_model" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 468:
        {
        library_physics_scenes__ValidationData* parentValidationData = (library_physics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 607:
        {
        library_visual_scenes__ValidationData* parentValidationData = (library_visual_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->visual_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: visual_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 392:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 326:
        {
        material__ValidationData* parentValidationData = (material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_effect != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_effect" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 36:
        {
        node__ValidationData* parentValidationData = (node__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 288:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 241:
        {
        physics_model__ValidationData* parentValidationData = (physics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->rigid_body != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: rigid_body" ) )
                return false;
        }
        if ( parentValidationData->rigid_constraint != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: rigid_constraint" ) )
                return false;
        }
        if ( parentValidationData->instance_physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_physics_model" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 586:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_force_field != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_force_field" ) )
                return false;
        }
        if ( parentValidationData->instance_physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_physics_model" ) )
                return false;
        }
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 42:
        {
        profile_BRIDGE__ValidationData* parentValidationData = (profile_BRIDGE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 143:
        {
        profile_CG__ValidationData* parentValidationData = (profile_CG__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 480:
        {
        profile_COMMON__ValidationData* parentValidationData = (profile_COMMON__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 452:
        {
        profile_GLES2__ValidationData* parentValidationData = (profile_GLES2__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 196:
        {
        profile_GLES__ValidationData* parentValidationData = (profile_GLES__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 148:
        {
        profile_GLSL__ValidationData* parentValidationData = (profile_GLSL__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 710:
        {
        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 395:
        {
        visual_scene__ValidationData* parentValidationData = (visual_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        if ( parentValidationData->evaluate_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: evaluate_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        asset__ValidationData* validationData = (asset__ValidationData*)mValidationDataStack.newObject(sizeof(asset__ValidationData));
        memset(validationData, 0, sizeof(asset__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__asset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* validationData = (asset__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->created < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ASSET, (const ParserChar*)0, "child: created" ) )
                return false;
        }
        if ( validationData->modified < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ASSET, (const ParserChar*)0, "child: modified" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__contributor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->coverage != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: coverage" ) )
                return false;
        }
        if ( parentValidationData->created != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->keywords != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: keywords" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->contributor++;

        contributor__ValidationData* validationData = (contributor__ValidationData*)mValidationDataStack.newObject(sizeof(contributor__ValidationData));
        memset(validationData, 0, sizeof(contributor__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__contributor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* validationData = (contributor__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__author( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->author_email != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: author_email" ) )
                return false;
        }
        if ( parentValidationData->author_website != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: author_website" ) )
                return false;
        }
        if ( parentValidationData->authoring_tool != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: authoring_tool" ) )
                return false;
        }
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->author >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->author++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__author()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__author_email( ParserString value )
{
    return validate__author_email( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__author_email( const ParserChar* value, size_t length )
{
// regular expression: "^[A-Za-z0-9!#-'\*\+\-/=\?\^_`\{-~]+(\.[A-Za-z0-9!#-'\*\+\-/=\?\^_`\{-~]+)*@[A-Za-z0-9!#-'\*\+\-/=\?\^_`\{-~]+(\.[A-Za-z0-9!#-'\*\+\-/=\?\^_`\{-~]+)*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^[A-Za-z0-9!#-'\\*\\+\\-/=\\?\\^_`\\{-~]+(\\.[A-Za-z0-9!#-'\\*\\+\\-/=\\?\\^_`\\{-~]+)*@[A-Za-z0-9!#-'\\*\\+\\-/=\\?\\^_`\\{-~]+(\\.[A-Za-z0-9!#-'\\*\\+\\-/=\\?\\^_`\\{-~]+)*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__author_email__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__author_email__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__author_email( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->author_website != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, "sibling: author_website" ) )
                return false;
        }
        if ( parentValidationData->authoring_tool != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, "sibling: authoring_tool" ) )
                return false;
        }
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->author_email >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHOR_EMAIL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->author_email++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__author_email()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__author_website( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->authoring_tool != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, "sibling: authoring_tool" ) )
                return false;
        }
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->author_website >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->author_website++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__author_website()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__authoring_tool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->authoring_tool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->authoring_tool++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__authoring_tool()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__comments( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->comments >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->comments++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__comments()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__copyright( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COPYRIGHT, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->copyright >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_COPYRIGHT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->copyright++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__copyright()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__source_data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source_data >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE_DATA, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source_data++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__source_data()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__coverage( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->keywords != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: keywords" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->coverage >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_COVERAGE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->coverage++;

        coverage__ValidationData* validationData = (coverage__ValidationData*)mValidationDataStack.newObject(sizeof(coverage__ValidationData));
        memset(validationData, 0, sizeof(coverage__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__coverage()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        coverage__ValidationData* validationData = (coverage__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__geographic_location( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        coverage__ValidationData* parentValidationData = (coverage__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->geographic_location >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_GEOGRAPHIC_LOCATION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->geographic_location++;

        geographic_location__ValidationData* validationData = (geographic_location__ValidationData*)mValidationDataStack.newObject(sizeof(geographic_location__ValidationData));
        memset(validationData, 0, sizeof(geographic_location__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__geographic_location()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geographic_location__ValidationData* validationData = (geographic_location__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->longitude < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_GEOGRAPHIC_LOCATION, (const ParserChar*)0, "child: longitude" ) )
                return false;
        }
        if ( validationData->latitude < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_GEOGRAPHIC_LOCATION, (const ParserChar*)0, "child: latitude" ) )
                return false;
        }
        if ( validationData->altitude < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_GEOGRAPHIC_LOCATION, (const ParserChar*)0, "child: altitude" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__longitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geographic_location__ValidationData* parentValidationData = (geographic_location__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->latitude != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_LONGITUDE, (const ParserChar*)0, "sibling: latitude" ) )
                return false;
        }
        if ( parentValidationData->altitude != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_LONGITUDE, (const ParserChar*)0, "sibling: altitude" ) )
                return false;
        }
        if ( parentValidationData->longitude >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_LONGITUDE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->longitude++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__longitude()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__latitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geographic_location__ValidationData* parentValidationData = (geographic_location__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->longitude < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_LATITUDE, (const ParserChar*)0, "sibling: longitude" ) )
                return false;
        }
        if ( parentValidationData->altitude != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_LATITUDE, (const ParserChar*)0, "sibling: altitude" ) )
                return false;
        }
        if ( parentValidationData->latitude >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_LATITUDE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->latitude++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__latitude()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__altitude_mode_enum( ParserString value )
{
    return validate__altitude_mode_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__altitude_mode_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__altitude_mode_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__altitude_mode_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__altitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geographic_location__ValidationData* parentValidationData = (geographic_location__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->latitude < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_ALTITUDE, (const ParserChar*)0, "sibling: latitude" ) )
                return false;
        }
        if ( parentValidationData->altitude >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ALTITUDE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->altitude++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__altitude()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__created( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->keywords != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: keywords" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->created >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CREATED, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->created++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__created()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__keywords( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->keywords >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->keywords++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__keywords()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__modified( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->modified >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->modified++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__modified()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__revision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->revision >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_REVISION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->revision++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__revision()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__subject( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->subject >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->subject++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__subject()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__title( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->title >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TITLE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->title++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__title()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN( ParserString value )
{
    return validate__NMTOKEN( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])+$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])+$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__unit( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_UNIT, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_UNIT, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_UNIT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->unit >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_UNIT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->unit++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__unit()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__up_axis_enum( ParserString value )
{
    return validate__up_axis_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__up_axis_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__up_axis_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__up_axis_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__up_axis( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->up_axis >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->up_axis++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__up_axis()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__extra( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 481:
        {
        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCENE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 194:
        {
        attachment__ValidationData* parentValidationData = (attachment__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 207:
        {
        nurbs_surface_type____control_vertices__ValidationData* parentValidationData = (nurbs_surface_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 208:
        {
        nurbs_type____control_vertices__ValidationData* parentValidationData = (nurbs_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 209:
        {
        spline_type____control_vertices__ValidationData* parentValidationData = (spline_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 469:
        {
        surface_type____cylinder__ValidationData* parentValidationData = (surface_type____cylinder__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 334:
        {
        evaluate_scene__ValidationData* parentValidationData = (evaluate_scene__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 702:
        {
        imager__ValidationData* parentValidationData = (imager__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 242:
        {
        render__instance_material__ValidationData* parentValidationData = (render__instance_material__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 283:
        {
        joints__ValidationData* parentValidationData = (joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 166:
        {
        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 418:
        {
        profile_GLES__technique__pass__ValidationData* parentValidationData = (profile_GLES__technique__pass__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 419:
        {
        profile_GLSL__technique__pass__ValidationData* parentValidationData = (profile_GLSL__technique__pass__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 100:
        {
        ref_attachment__ValidationData* parentValidationData = (ref_attachment__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 98:
        {
        render__ValidationData* parentValidationData = (render__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 87:
        {
        sampler_states__ValidationData* parentValidationData = (sampler_states__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 466:
        {
        scene__ValidationData* parentValidationData = (scene__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 597:
        {
        instance_rigid_body__technique_common__shape__ValidationData* parentValidationData = (instance_rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BOX) || (parentValidationData->validation_current_state == HASH_ELEMENT_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 598:
        {
        rigid_body__technique_common__shape__ValidationData* parentValidationData = (rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BOX) || (parentValidationData->validation_current_state == HASH_ELEMENT_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 95:
        {
        targets__ValidationData* parentValidationData = (targets__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 614:
        {
        profile_cg_type____technique__ValidationData* parentValidationData = (profile_cg_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 615:
        {
        profile_common_type____technique__ValidationData* parentValidationData = (profile_common_type____technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BLINN) || (parentValidationData->validation_current_state == HASH_ELEMENT_CONSTANT) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LAMBERT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHONG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 616:
        {
        profile_gles2_type____technique__ValidationData* parentValidationData = (profile_gles2_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 617:
        {
        profile_gles_type____technique__ValidationData* parentValidationData = (profile_gles_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 618:
        {
        profile_glsl_type____technique__ValidationData* parentValidationData = (profile_glsl_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 482:
        {
        texture__ValidationData* parentValidationData = (texture__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 222:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 320:
        {
        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_animation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: instance_animation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 12:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 536:
        {
        articulated_system__ValidationData* parentValidationData = (articulated_system__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_KINEMATICS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MOTION) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 575:
        {
        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 54:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 665:
        {
        box__ValidationData* parentValidationData = (box__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->half_extents < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: half_extents" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 68:
        {
        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 46:
        {
        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 59:
        {
        capsule__ValidationData* parentValidationData = (capsule__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 420:
        {
        pass____cg_pass_type__ValidationData* parentValidationData = (pass____cg_pass_type__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 738:
        {
        circle__ValidationData* parentValidationData = (circle__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 585:
        {
        cone__ValidationData* parentValidationData = (cone__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->angle < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: angle" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 84:
        {
        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_MORPH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SKIN) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 115:
        {
        curves__ValidationData* parentValidationData = (curves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->curve < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: curve" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 470:
        {
        cylinder____cylinder_type__ValidationData* parentValidationData = (cylinder____cylinder_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 6:
        {
        edges__ValidationData* parentValidationData = (edges__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 4 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 69:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_BRIDGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_CG) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_COMMON) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_GLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_GLES2) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROFILE_GLSL) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 437:
        {
        ellipse__ValidationData* parentValidationData = (ellipse__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 157:
        {
        faces__ValidationData* parentValidationData = (faces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 48:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 416:
        {
        sampler1D__ValidationData* parentValidationData = (sampler1D__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 66:
        {
        sampler2D____fx_sampler2D_type__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 444:
        {
        sampler3D__ValidationData* parentValidationData = (sampler3D__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 445:
        {
        samplerCUBE__ValidationData* parentValidationData = (samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 305:
        {
        samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 110:
        {
        samplerRECT__ValidationData* parentValidationData = (samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BORDER_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAX_ANISOTROPY) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MIN_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 613:
        {
        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BREP) || (parentValidationData->validation_current_state == HASH_ELEMENT_CONVEX_MESH) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_MESH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPLINE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 421:
        {
        pass____gles2_pass_type__ValidationData* parentValidationData = (pass____gles2_pass_type__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 578:
        {
        shader____gles2_shader_type__ValidationData* parentValidationData = (shader____gles2_shader_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->sources < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: sources" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 67:
        {
        sampler2D____gles_sampler_type__ValidationData* parentValidationData = (sampler2D____gles_sampler_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAGFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MINFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPFILTER) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_BIAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_MAX_LEVEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXCOORD) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_S) || (parentValidationData->validation_current_state == HASH_ELEMENT_WRAP_T) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 446:
        {
        value____gles_texture_pipeline_type__ValidationData* parentValidationData = (value____gles_texture_pipeline_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->texcombiner != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: texcombiner" ) )
                return false;
        }
        if ( parentValidationData->texenv != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: texenv" ) )
                return false;
        }
        if ( parentValidationData->extra >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 579:
        {
        shader____glsl_shader_type__ValidationData* parentValidationData = (shader____glsl_shader_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->sources < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: sources" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 244:
        {
        hyperbola__ValidationData* parentValidationData = (hyperbola__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 262:
        {
        image____image_type__ValidationData* parentValidationData = (image____image_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CREATE_2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_CREATE_3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_CREATE_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_RENDERABLE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 246:
        {
        instance_articulated_system__ValidationData* parentValidationData = (instance_articulated_system__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 623:
        {
        instance_camera__ValidationData* parentValidationData = (instance_camera__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 250:
        {
        instance_controller__ValidationData* parentValidationData = (instance_controller__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 576:
        {
        instance_effect__ValidationData* parentValidationData = (instance_effect__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 354:
        {
        instance_force_field__ValidationData* parentValidationData = (instance_force_field__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 33:
        {
        instance_geometry__ValidationData* parentValidationData = (instance_geometry__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 276:
        {
        instance_image__ValidationData* parentValidationData = (instance_image__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 711:
        {
        instance_joint__ValidationData* parentValidationData = (instance_joint__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 152:
        {
        instance_kinematics_model__ValidationData* parentValidationData = (instance_kinematics_model__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 17:
        {
        instance_kinematics_scene__ValidationData* parentValidationData = (instance_kinematics_scene__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 662:
        {
        instance_light__ValidationData* parentValidationData = (instance_light__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 243:
        {
        instance_material____instance_material_type__ValidationData* parentValidationData = (instance_material____instance_material_type__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 708:
        {
        instance_node__ValidationData* parentValidationData = (instance_node__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 212:
        {
        instance_physics_material__ValidationData* parentValidationData = (instance_physics_material__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 571:
        {
        instance_physics_model__ValidationData* parentValidationData = (instance_physics_model__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 533:
        {
        instance_rigid_body__ValidationData* parentValidationData = (instance_rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 724:
        {
        instance_rigid_constraint__ValidationData* parentValidationData = (instance_rigid_constraint__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 388:
        {
        instance_animation__ValidationData* parentValidationData = (instance_animation__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 587:
        {
        joint__ValidationData* parentValidationData = (joint__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_PRISMATIC) || (parentValidationData->validation_current_state == HASH_ELEMENT_REVOLUTE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 216:
        {
        kinematics_model__ValidationData* parentValidationData = (kinematics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 300:
        {
        kinematics_scene__ValidationData* parentValidationData = (kinematics_scene__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 465:
        {
        kinematics__ValidationData* parentValidationData = (kinematics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 257:
        {
        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation_clip < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: animation_clip" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 239:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: animation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 584:
        {
        library_articulated_systems__ValidationData* parentValidationData = (library_articulated_systems__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->articulated_system < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: articulated_system" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 565:
        {
        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->camera < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: camera" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 275:
        {
        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->controller < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: controller" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 206:
        {
        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->effect < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: effect" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 96:
        {
        library_force_fields__ValidationData* parentValidationData = (library_force_fields__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->force_field < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: force_field" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 101:
        {
        library_formulas__ValidationData* parentValidationData = (library_formulas__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->formula < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: formula" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 635:
        {
        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->geometry < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: geometry" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 369:
        {
        library_images__ValidationData* parentValidationData = (library_images__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->image < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 285:
        {
        library_joints__ValidationData* parentValidationData = (library_joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joint < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: joint" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 227:
        {
        library_kinematics_models__ValidationData* parentValidationData = (library_kinematics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->kinematics_model < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: kinematics_model" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 172:
        {
        library_kinematics_scenes__ValidationData* parentValidationData = (library_kinematics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->kinematics_scene < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: kinematics_scene" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 145:
        {
        library_lights__ValidationData* parentValidationData = (library_lights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->light < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: light" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 45:
        {
        library_materials__ValidationData* parentValidationData = (library_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->material < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: material" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 620:
        {
        library_nodes__ValidationData* parentValidationData = (library_nodes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 462:
        {
        library_physics_materials__ValidationData* parentValidationData = (library_physics_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_material < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_material" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 7:
        {
        library_physics_models__ValidationData* parentValidationData = (library_physics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_model < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_model" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 468:
        {
        library_physics_scenes__ValidationData* parentValidationData = (library_physics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_scene < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_scene" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 607:
        {
        library_visual_scenes__ValidationData* parentValidationData = (library_visual_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->visual_scene < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: visual_scene" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 392:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 223:
        {
        line__ValidationData* parentValidationData = (line__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->direction < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: direction" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 509:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 611:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 326:
        {
        material__ValidationData* parentValidationData = (material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_effect < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: instance_effect" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 304:
        {
        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->targets < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: targets" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 407:
        {
        motion__ValidationData* parentValidationData = (motion__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 36:
        {
        node__ValidationData* parentValidationData = (node__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_CAMERA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_CONTROLLER) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_LIGHT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_NODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOOKAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_NODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCALE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SKEW) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 301:
        {
        nurbs_surface__ValidationData* parentValidationData = (nurbs_surface__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 596:
        {
        nurbs__ValidationData* parentValidationData = (nurbs__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 700:
        {
        parabola__ValidationData* parentValidationData = (parabola__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->focal < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: focal" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 258:
        {
        pcurves__ValidationData* parentValidationData = (pcurves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 288:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 241:
        {
        physics_model__ValidationData* parentValidationData = (physics_model__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 586:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 350:
        {
        plane__ValidationData* parentValidationData = (plane__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->equation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: equation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 460:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 140:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 42:
        {
        profile_BRIDGE__ValidationData* parentValidationData = (profile_BRIDGE__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 143:
        {
        profile_CG__ValidationData* parentValidationData = (profile_CG__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 480:
        {
        profile_COMMON__ValidationData* parentValidationData = (profile_COMMON__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 452:
        {
        profile_GLES2__ValidationData* parentValidationData = (profile_GLES2__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 196:
        {
        profile_GLES__ValidationData* parentValidationData = (profile_GLES__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 148:
        {
        profile_GLSL__ValidationData* parentValidationData = (profile_GLSL__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 57:
        {
        rigid_body__ValidationData* parentValidationData = (rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 647:
        {
        rigid_constraint__ValidationData* parentValidationData = (rigid_constraint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 547:
        {
        shells__ValidationData* parentValidationData = (shells__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 483:
        {
        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertex_weights < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 601:
        {
        solids__ValidationData* parentValidationData = (solids__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 634:
        {
        sphere__ValidationData* parentValidationData = (sphere__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 65:
        {
        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 306:
        {
        surface_curves__ValidationData* parentValidationData = (surface_curves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->curve < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: curve" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 318:
        {
        surfaces__ValidationData* parentValidationData = (surfaces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->surface < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: surface" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 190:
        {
        swept_surface__ValidationData* parentValidationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_AXIS) || (parentValidationData->validation_current_state == HASH_ELEMENT_DIRECTION) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 15:
        {
        torus__ValidationData* parentValidationData = (torus__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 573:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 729:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 357:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 508:
        {
        vertices__ValidationData* parentValidationData = (vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 395:
        {
        visual_scene__ValidationData* parentValidationData = (visual_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 77:
        {
        wires__ValidationData* parentValidationData = (wires__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        extra__ValidationData* validationData = (extra__ValidationData*)mValidationDataStack.newObject(sizeof(extra__ValidationData));
        memset(validationData, 0, sizeof(extra__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__extra()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        extra__ValidationData* validationData = (extra__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "child: technique" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__technique____technique_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 702:
        {
        imager__ValidationData* parentValidationData = (imager__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 166:
        {
        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 54:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 8:
        {
        extra__ValidationData* parentValidationData = (extra__ValidationData*)mValidationDataStack.top();
        parentValidationData->technique++;

        break;
        }

        case 48:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 118:
        {
        formula__ValidationData* parentValidationData = (formula__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 533:
        {
        instance_rigid_body__ValidationData* parentValidationData = (instance_rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 216:
        {
        kinematics_model__ValidationData* parentValidationData = (kinematics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 465:
        {
        kinematics__ValidationData* parentValidationData = (kinematics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 392:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 407:
        {
        motion__ValidationData* parentValidationData = (motion__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 288:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 586:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 57:
        {
        rigid_body__ValidationData* parentValidationData = (rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 647:
        {
        rigid_constraint__ValidationData* parentValidationData = (rigid_constraint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 710:
        {
        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE_COMMON) || (parentValidationData->validation_current_state == HASH_ELEMENT_TOKEN_ARRAY) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TECHNIQUE;
        }
//        parentValidationData->technique++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        technique____technique_type__ValidationData* validationData = (technique____technique_type__ValidationData*)mValidationDataStack.newObject(sizeof(technique____technique_type__ValidationData));
        memset(validationData, 0, sizeof(technique____technique_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__technique____technique_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        technique____technique_type__ValidationData* validationData = (technique____technique_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_animations( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_ANIMATIONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_ANIMATIONS;
        }
//        parentValidationData->library_animations++;

        library_animations__ValidationData* validationData = (library_animations__ValidationData*)mValidationDataStack.newObject(sizeof(library_animations__ValidationData));
        memset(validationData, 0, sizeof(library_animations__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_animations()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animations__ValidationData* validationData = (library_animations__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->animation < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_ANIMATIONS, (const ParserChar*)0, "child: animation" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 12:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANIMATION;
        }
//        parentValidationData->animation++;

        break;
        }

        case 239:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->animation++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        animation__ValidationData* validationData = (animation__ValidationData*)mValidationDataStack.newObject(sizeof(animation__ValidationData));
        memset(validationData, 0, sizeof(animation__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* validationData = (animation__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (validationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__source( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 12:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 68:
        {
        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->edges != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: edges" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 304:
        {
        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->targets != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: targets" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 301:
        {
        nurbs_surface__ValidationData* parentValidationData = (nurbs_surface__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 596:
        {
        nurbs__ValidationData* parentValidationData = (nurbs__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 483:
        {
        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joints != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 65:
        {
        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        source__ValidationData* validationData = (source__ValidationData*)mValidationDataStack.newObject(sizeof(source__ValidationData));
        memset(validationData, 0, sizeof(source__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__source()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* validationData = (source__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ASSET) || (validationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_SIDREF_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) || (validationData->validation_current_state == HASH_ELEMENT_TECHNIQUE_COMMON) || (validationData->validation_current_state == HASH_ELEMENT_TOKEN_ARRAY) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__token_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TOKEN_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TOKEN_ARRAY;
        }
//        parentValidationData->token_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__token_array()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS( const ParserString*value, size_t length )
{
    if( length < 1 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS__stream( const ParserString*value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS__streamEnd( const ParserString*value, size_t length )
{
    if( length < 1 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__IDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IDREF_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IDREF_ARRAY;
        }
//        parentValidationData->IDREF_array++;

        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.newObject(sizeof(IDREF_array__ValidationData));
        memset(validationData, 0, sizeof(IDREF_array__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__IDREF_array()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name( ParserString value )
{
    return validate__Name( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z]|[:])([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z]|[:])([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__Name_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_NAME_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_NAME_ARRAY;
        }
//        parentValidationData->Name_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__Name_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bool_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL_ARRAY;
        }
//        parentValidationData->bool_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bool_array()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__digits_type( const uint8 value )
{
    if( value > 17 )
        return ParserError::ERROR_VALIDATION_MAX_INCLUSIVE;

    if( value < 1 )
        return ParserError::ERROR_VALIDATION_MIN_INCLUSIVE;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__magnitude_type( const sint16 value )
{
    if( value > 308 )
        return ParserError::ERROR_VALIDATION_MAX_INCLUSIVE;

    if( value < -324 )
        return ParserError::ERROR_VALIDATION_MIN_INCLUSIVE;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT_ARRAY;
        }
//        parentValidationData->float_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__int_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT_ARRAY;
        }
//        parentValidationData->int_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__int_array()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sidref_type( ParserString value )
{
    return validate__sidref_type( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sidref_type( const ParserChar* value, size_t length )
{
// regular expression: "^((([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)|.)(/([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)+((\.([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)|(\([0-9]+\)){1,2})?$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^((([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)|.)(/([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)+((\\.([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*)|(\\([0-9]+\\)){1,2})?$");pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sidref_type__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sidref_type__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__SIDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SIDREF_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SIDREF_ARRAY;
        }
//        parentValidationData->SIDREF_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__SIDREF_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__source_type____technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_TOKEN_ARRAY) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TECHNIQUE_COMMON;
        }
//        parentValidationData->technique_common++;

        source_type____technique_common__ValidationData* validationData = (source_type____technique_common__ValidationData*)mValidationDataStack.newObject(sizeof(source_type____technique_common__ValidationData));
        memset(validationData, 0, sizeof(source_type____technique_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__source_type____technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source_type____technique_common__ValidationData* validationData = (source_type____technique_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->accessor < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: accessor" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__accessor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source_type____technique_common__ValidationData* parentValidationData = (source_type____technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->accessor >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ACCESSOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->accessor++;

        accessor__ValidationData* validationData = (accessor__ValidationData*)mValidationDataStack.newObject(sizeof(accessor__ValidationData));
        memset(validationData, 0, sizeof(accessor__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__accessor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        accessor__ValidationData* validationData = (accessor__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sid_type( ParserString value )
{
    return validate__sid_type( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sid_type( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sid_type__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sid_type__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__param____param_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 603:
        {
        accessor__ValidationData* parentValidationData = (accessor__ValidationData*)mValidationDataStack.top();
        parentValidationData->param++;

        break;
        }

        case 54:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->param++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__param____param_type()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sampler_behavior_enum( ParserString value )
{
    return validate__sampler_behavior_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sampler_behavior_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sampler_behavior_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__sampler_behavior_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__sampler( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER;
        }
//        parentValidationData->sampler++;

        sampler__ValidationData* validationData = (sampler__ValidationData*)mValidationDataStack.newObject(sizeof(sampler__ValidationData));
        memset(validationData, 0, sizeof(sampler__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__sampler()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        sampler__ValidationData* validationData = (sampler__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SAMPLER, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__urifragment_type( ParserString value )
{
    return validate__urifragment_type( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__urifragment_type( const ParserChar* value, size_t length )
{
// regular expression: "^(#(.*))$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^(#(.*))$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__urifragment_type__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__urifragment_type__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__input____input_local_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 207:
        {
        nurbs_surface_type____control_vertices__ValidationData* parentValidationData = (nurbs_surface_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 208:
        {
        nurbs_type____control_vertices__ValidationData* parentValidationData = (nurbs_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 209:
        {
        spline_type____control_vertices__ValidationData* parentValidationData = (spline_type____control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 283:
        {
        joints__ValidationData* parentValidationData = (joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 95:
        {
        targets__ValidationData* parentValidationData = (targets__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 557:
        {
        sampler__ValidationData* parentValidationData = (sampler__ValidationData*)mValidationDataStack.top();
        parentValidationData->input++;

        break;
        }

        case 508:
        {
        vertices__ValidationData* parentValidationData = (vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__input____input_local_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__channel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CHANNEL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CHANNEL;
        }
//        parentValidationData->channel++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__channel()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_animation_clips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS;
        }
//        parentValidationData->library_animation_clips++;

        library_animation_clips__ValidationData* validationData = (library_animation_clips__ValidationData*)mValidationDataStack.newObject(sizeof(library_animation_clips__ValidationData));
        memset(validationData, 0, sizeof(library_animation_clips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_animation_clips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animation_clips__ValidationData* validationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->animation_clip < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, (const ParserChar*)0, "child: animation_clip" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__animation_clip( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANIMATION_CLIP, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->animation_clip++;

        animation_clip__ValidationData* validationData = (animation_clip__ValidationData*)mValidationDataStack.newObject(sizeof(animation_clip__ValidationData));
        memset(validationData, 0, sizeof(animation_clip__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__animation_clip()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation_clip__ValidationData* validationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->instance_animation < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ANIMATION_CLIP, (const ParserChar*)0, "child: instance_animation" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__instance_animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_formula != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INSTANCE_ANIMATION, (const ParserChar*)0, "sibling: instance_formula" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INSTANCE_ANIMATION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->instance_animation++;

        instance_animation__ValidationData* validationData = (instance_animation__ValidationData*)mValidationDataStack.newObject(sizeof(instance_animation__ValidationData));
        memset(validationData, 0, sizeof(instance_animation__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__instance_animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        instance_animation__ValidationData* validationData = (instance_animation__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__instance_formula( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 320:
        {
        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_animation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_INSTANCE_FORMULA, (const ParserChar*)0, "sibling: instance_animation" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INSTANCE_FORMULA, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->instance_formula++;

        break;
        }

        case 726:
        {
        axis_info____kinematics_axis_info_type__ValidationData* parentValidationData = (axis_info____kinematics_axis_info_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ACTIVE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMULA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INDEX) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_FORMULA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIMITS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOCKED) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INSTANCE_FORMULA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INSTANCE_FORMULA;
        }
//        parentValidationData->instance_formula++;

        break;
        }

        case 685:
        {
        technique_common____kinematics_model_technique_type__ValidationData* parentValidationData = (technique_common____kinematics_model_technique_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMULA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_FORMULA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINK) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INSTANCE_FORMULA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INSTANCE_FORMULA;
        }
//        parentValidationData->instance_formula++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        instance_formula__ValidationData* validationData = (instance_formula__ValidationData*)mValidationDataStack.newObject(sizeof(instance_formula__ValidationData));
        memset(validationData, 0, sizeof(instance_formula__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__instance_formula()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        instance_formula__ValidationData* validationData = (instance_formula__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__setparam____formula_setparam_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        instance_formula__ValidationData* parentValidationData = (instance_formula__ValidationData*)mValidationDataStack.top();
        parentValidationData->setparam++;

        setparam____formula_setparam_type__ValidationData* validationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.newObject(sizeof(setparam____formula_setparam_type__ValidationData));
        memset(validationData, 0, sizeof(setparam____formula_setparam_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__setparam____formula_setparam_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        setparam____formula_setparam_type__ValidationData* validationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->_float != 0 )
            if ( validationData->_float < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, "child: float" ) )
                    return false;
        if ( validationData->_int != 0 )
            if ( validationData->_int < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, "child: int" ) )
                    return false;
        if ( validationData->SIDREF != 0 )
            if ( validationData->SIDREF < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, "child: SIDREF" ) )
                    return false;
        if ( validationData->_bool != 0 )
            if ( validationData->_bool < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, "child: bool" ) )
                    return false;
        if ( validationData->connect_param != 0 )
            if ( validationData->connect_param < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, "child: connect_param" ) )
                    return false;
        if ( validationData->_float == 0 && validationData->_int == 0 && validationData->SIDREF == 0 && validationData->_bool == 0 && validationData->connect_param == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_SETPARAM, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float____float_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 403:
        {
        profile_GLES2__newparam__usertype__setparam__array__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__array__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 373:
        {
        gles2_program_type____bind_uniform__ValidationData* parentValidationData = (gles2_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 740:
        {
        profile_GLES2__newparam__usertype__setparam__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 27:
        {
        target__ValidationData* parentValidationData = (target__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        case 656:
        {
        newparam____formula_newparam_type__ValidationData* parentValidationData = (newparam____formula_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        case 742:
        {
        setparam____formula_setparam_type__ValidationData* parentValidationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 657:
        {
        newparam____fx_common_newparam_type__ValidationData* parentValidationData = (newparam____fx_common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 341:
        {
        bind____kinematics_bind_type__ValidationData* parentValidationData = (bind____kinematics_bind_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        case 661:
        {
        newparam____kinematics_newparam_type__ValidationData* parentValidationData = (newparam____kinematics_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        case 743:
        {
        setparam____kinematics_setparam_type__ValidationData* parentValidationData = (setparam____kinematics_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_float >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_float++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float____float_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__int____int_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 403:
        {
        profile_GLES2__newparam__usertype__setparam__array__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__array__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 373:
        {
        gles2_program_type____bind_uniform__ValidationData* parentValidationData = (gles2_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 740:
        {
        profile_GLES2__newparam__usertype__setparam__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 656:
        {
        newparam____formula_newparam_type__ValidationData* parentValidationData = (newparam____formula_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        case 742:
        {
        setparam____formula_setparam_type__ValidationData* parentValidationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 341:
        {
        bind____kinematics_bind_type__ValidationData* parentValidationData = (bind____kinematics_bind_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        case 594:
        {
        index__ValidationData* parentValidationData = (index__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        case 661:
        {
        newparam____kinematics_newparam_type__ValidationData* parentValidationData = (newparam____kinematics_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        case 743:
        {
        setparam____kinematics_setparam_type__ValidationData* parentValidationData = (setparam____kinematics_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INT, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_int >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_INT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_int++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__int____int_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__SIDREF( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 282:
        {
        bind_kinematics_model__ValidationData* parentValidationData = (bind_kinematics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 449:
        {
        axis____common_sidref_or_param_type__ValidationData* parentValidationData = (axis____common_sidref_or_param_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 656:
        {
        newparam____formula_newparam_type__ValidationData* parentValidationData = (newparam____formula_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 742:
        {
        setparam____formula_setparam_type__ValidationData* parentValidationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 341:
        {
        bind____kinematics_bind_type__ValidationData* parentValidationData = (bind____kinematics_bind_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 661:
        {
        newparam____kinematics_newparam_type__ValidationData* parentValidationData = (newparam____kinematics_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        case 743:
        {
        setparam____kinematics_setparam_type__ValidationData* parentValidationData = (setparam____kinematics_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SIDREF, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->SIDREF >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SIDREF, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->SIDREF++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__SIDREF()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 403:
        {
        profile_GLES2__newparam__usertype__setparam__array__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__array__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 373:
        {
        gles2_program_type____bind_uniform__ValidationData* parentValidationData = (gles2_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 740:
        {
        profile_GLES2__newparam__usertype__setparam__ValidationData* parentValidationData = (profile_GLES2__newparam__usertype__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_IVEC4) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_MAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC2) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC3) || (parentValidationData->validation_current_state == HASH_ELEMENT_VEC4) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 229:
        {
        active__ValidationData* parentValidationData = (active__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        case 656:
        {
        newparam____formula_newparam_type__ValidationData* parentValidationData = (newparam____formula_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        case 742:
        {
        setparam____formula_setparam_type__ValidationData* parentValidationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 341:
        {
        bind____kinematics_bind_type__ValidationData* parentValidationData = (bind____kinematics_bind_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        case 661:
        {
        newparam____kinematics_newparam_type__ValidationData* parentValidationData = (newparam____kinematics_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        case 743:
        {
        setparam____kinematics_setparam_type__ValidationData* parentValidationData = (setparam____kinematics_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->connect_param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, "sibling: connect_param" ) )
                return false;
        }
        if ( parentValidationData->_bool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->_bool++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bool()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__connect_param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 742:
        {
        setparam____formula_setparam_type__ValidationData* parentValidationData = (setparam____formula_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->connect_param++;

        break;
        }

        case 743:
        {
        setparam____kinematics_setparam_type__ValidationData* parentValidationData = (setparam____kinematics_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->_float != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: float" ) )
                return false;
        }
        if ( parentValidationData->_int != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: int" ) )
                return false;
        }
        if ( parentValidationData->SIDREF != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: SIDREF" ) )
                return false;
        }
        if ( parentValidationData->_bool != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, "sibling: bool" ) )
                return false;
        }
        if ( parentValidationData->connect_param >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONNECT_PARAM, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->connect_param++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__connect_param()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_cameras( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_CAMERAS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_CAMERAS;
        }
//        parentValidationData->library_cameras++;

        library_cameras__ValidationData* validationData = (library_cameras__ValidationData*)mValidationDataStack.newObject(sizeof(library_cameras__ValidationData));
        memset(validationData, 0, sizeof(library_cameras__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_cameras()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_cameras__ValidationData* validationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->camera < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_CAMERAS, (const ParserChar*)0, "child: camera" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__camera( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CAMERA, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->camera++;

        camera__ValidationData* validationData = (camera__ValidationData*)mValidationDataStack.newObject(sizeof(camera__ValidationData));
        memset(validationData, 0, sizeof(camera__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__camera()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* validationData = (camera__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->optics < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CAMERA, (const ParserChar*)0, "child: optics" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__optics( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->imager != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "sibling: imager" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->optics >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_OPTICS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->optics++;

        optics__ValidationData* validationData = (optics__ValidationData*)mValidationDataStack.newObject(sizeof(optics__ValidationData));
        memset(validationData, 0, sizeof(optics__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__optics()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__ValidationData* validationData = (optics__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique_common < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "child: technique_common" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__optics__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->technique_common >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->technique_common++;

        optics__technique_common__ValidationData* validationData = (optics__technique_common__ValidationData*)mValidationDataStack.newObject(sizeof(optics__technique_common__ValidationData));
        memset(validationData, 0, sizeof(optics__technique_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__optics__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* validationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->orthographic != 0 )
            if ( validationData->orthographic < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: orthographic" ) )
                    return false;
        if ( validationData->perspective != 0 )
            if ( validationData->perspective < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: perspective" ) )
                    return false;
        if ( validationData->orthographic == 0 && validationData->perspective == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__orthographic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* parentValidationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->perspective != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, "sibling: perspective" ) )
                return false;
        }
        if ( parentValidationData->orthographic >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->orthographic++;

        orthographic__ValidationData* validationData = (orthographic__ValidationData*)mValidationDataStack.newObject(sizeof(orthographic__ValidationData));
        memset(validationData, 0, sizeof(orthographic__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__orthographic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* validationData = (orthographic__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ZFAR) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__xmag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_XMAG, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_XMAG;
        }
//        parentValidationData->xmag++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__xmag()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__ymag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_YMAG, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_YMAG;
        }
//        parentValidationData->ymag++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__ymag()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__aspect_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 397:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == HASH_ELEMENT_YMAG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASPECT_RATIO;
        }
//        parentValidationData->aspect_ratio++;

        break;
        }

        case 213:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == HASH_ELEMENT_YFOV) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASPECT_RATIO;
        }
//        parentValidationData->aspect_ratio++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__aspect_ratio()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__znear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 397:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASPECT_RATIO) || (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == HASH_ELEMENT_YMAG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZNEAR;
        }
//        parentValidationData->znear++;

        break;
        }

        case 213:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASPECT_RATIO) || (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == HASH_ELEMENT_YFOV) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZNEAR;
        }
//        parentValidationData->znear++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__znear()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__zfar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 397:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ZNEAR) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZFAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZFAR;
        }
//        parentValidationData->zfar++;

        break;
        }

        case 213:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ZNEAR) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZFAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZFAR;
        }
//        parentValidationData->zfar++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__zfar()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__perspective( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* parentValidationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->orthographic != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, "sibling: orthographic" ) )
                return false;
        }
        if ( parentValidationData->perspective >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->perspective++;

        perspective__ValidationData* validationData = (perspective__ValidationData*)mValidationDataStack.newObject(sizeof(perspective__ValidationData));
        memset(validationData, 0, sizeof(perspective__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__perspective()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* validationData = (perspective__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ZFAR) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__xfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_XFOV, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_XFOV;
        }
//        parentValidationData->xfov++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__xfov()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__yfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_YFOV, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_YFOV;
        }
//        parentValidationData->yfov++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__yfov()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__imager( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->imager >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_IMAGER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->imager++;

        imager__ValidationData* validationData = (imager__ValidationData*)mValidationDataStack.newObject(sizeof(imager__ValidationData));
        memset(validationData, 0, sizeof(imager__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__imager()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        imager__ValidationData* validationData = (imager__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "child: technique" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_controllers( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_CONTROLLERS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_CONTROLLERS;
        }
//        parentValidationData->library_controllers++;

        library_controllers__ValidationData* validationData = (library_controllers__ValidationData*)mValidationDataStack.newObject(sizeof(library_controllers__ValidationData));
        memset(validationData, 0, sizeof(library_controllers__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_controllers()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_controllers__ValidationData* validationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->controller < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_CONTROLLERS, (const ParserChar*)0, "child: controller" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__controller( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROLLER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->controller++;

        controller__ValidationData* validationData = (controller__ValidationData*)mValidationDataStack.newObject(sizeof(controller__ValidationData));
        memset(validationData, 0, sizeof(controller__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__controller()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* validationData = (controller__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_MORPH) || (validationData->validation_current_state == HASH_ELEMENT_SKIN) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_CONTROLLER, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__skin( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SKIN, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SKIN;
        }
//        parentValidationData->skin++;

        skin__ValidationData* validationData = (skin__ValidationData*)mValidationDataStack.newObject(sizeof(skin__ValidationData));
        memset(validationData, 0, sizeof(skin__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__skin()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* validationData = (skin__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 3 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->joints < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: joints" ) )
                return false;
        }
        if ( validationData->vertex_weights < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: vertex_weights" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4_type( const float* value, size_t length )
{
    if( length < 16 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4_type__stream( const float* value, size_t length )
{

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4_type__streamEnd( const float* value, size_t length )
{
    if( length < 16 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bind_shape_matrix( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->joints != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->bind_shape_matrix >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->bind_shape_matrix++;

        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.newObject(sizeof(bind_shape_matrix__ValidationData));
        memset(validationData, 0, sizeof(bind_shape_matrix__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bind_shape_matrix()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__joints( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 3 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->joints >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_JOINTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->joints++;

        joints__ValidationData* validationData = (joints__ValidationData*)mValidationDataStack.newObject(sizeof(joints__ValidationData));
        memset(validationData, 0, sizeof(joints__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__joints()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        joints__ValidationData* validationData = (joints__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__vertex_weights( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joints < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vertex_weights++;

        vertex_weights__ValidationData* validationData = (vertex_weights__ValidationData*)mValidationDataStack.newObject(sizeof(vertex_weights__ValidationData));
        memset(validationData, 0, sizeof(vertex_weights__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__vertex_weights()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertex_weights__ValidationData* validationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__input____input_local_offset_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 222:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->v != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: v" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 6:
        {
        edges__ValidationData* parentValidationData = (edges__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 157:
        {
        faces__ValidationData* parentValidationData = (faces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 509:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 611:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 258:
        {
        pcurves__ValidationData* parentValidationData = (pcurves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 460:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INPUT;
        }
//        parentValidationData->input++;

        break;
        }

        case 140:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 547:
        {
        shells__ValidationData* parentValidationData = (shells__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 601:
        {
        solids__ValidationData* parentValidationData = (solids__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 573:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 729:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 357:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 77:
        {
        wires__ValidationData* parentValidationData = (wires__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__input____input_local_offset_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__vcount( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 222:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->v != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: v" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 157:
        {
        faces__ValidationData* parentValidationData = (faces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 3 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 258:
        {
        pcurves__ValidationData* parentValidationData = (pcurves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 3 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 140:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 547:
        {
        shells__ValidationData* parentValidationData = (shells__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 601:
        {
        solids__ValidationData* parentValidationData = (solids__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 77:
        {
        wires__ValidationData* parentValidationData = (wires__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__vcount()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__v( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_V, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_V, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->v >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_V, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->v++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__v()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__morph_method_enum( ParserString value )
{
    return validate__morph_method_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__morph_method_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__morph_method_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__morph_method_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__morph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MORPH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MORPH;
        }
//        parentValidationData->morph++;

        morph__ValidationData* validationData = (morph__ValidationData*)mValidationDataStack.newObject(sizeof(morph__ValidationData));
        memset(validationData, 0, sizeof(morph__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__morph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        morph__ValidationData* validationData = (morph__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_MORPH, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->targets < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_MORPH, (const ParserChar*)0, "child: targets" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__targets( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->targets >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TARGETS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->targets++;

        targets__ValidationData* validationData = (targets__ValidationData*)mValidationDataStack.newObject(sizeof(targets__ValidationData));
        memset(validationData, 0, sizeof(targets__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__targets()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        targets__ValidationData* validationData = (targets__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_geometries( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_GEOMETRIES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_GEOMETRIES;
        }
//        parentValidationData->library_geometries++;

        library_geometries__ValidationData* validationData = (library_geometries__ValidationData*)mValidationDataStack.newObject(sizeof(library_geometries__ValidationData));
        memset(validationData, 0, sizeof(library_geometries__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_geometries()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_geometries__ValidationData* validationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->geometry < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_GEOMETRIES, (const ParserChar*)0, "child: geometry" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__geometry( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_GEOMETRY, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->geometry++;

        geometry__ValidationData* validationData = (geometry__ValidationData*)mValidationDataStack.newObject(sizeof(geometry__ValidationData));
        memset(validationData, 0, sizeof(geometry__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__geometry()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* validationData = (geometry__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_BREP) || (validationData->validation_current_state == HASH_ELEMENT_CONVEX_MESH) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_MESH) || (validationData->validation_current_state == HASH_ELEMENT_SPLINE) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_GEOMETRY, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__convex_mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CONVEX_MESH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CONVEX_MESH;
        }
//        parentValidationData->convex_mesh++;

        convex_mesh__ValidationData* validationData = (convex_mesh__ValidationData*)mValidationDataStack.newObject(sizeof(convex_mesh__ValidationData));
        memset(validationData, 0, sizeof(convex_mesh__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__convex_mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        convex_mesh__ValidationData* validationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LINES) || (validationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (validationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (validationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (validationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (validationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_VERTICES) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_CONVEX_MESH, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 68:
        {
        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->edges != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: edges" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vertices >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VERTICES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vertices++;

        break;
        }

        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VERTICES;
        }
//        parentValidationData->vertices++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VERTICES;
        }
//        parentValidationData->vertices++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        vertices__ValidationData* validationData = (vertices__ValidationData*)mValidationDataStack.newObject(sizeof(vertices__ValidationData));
        memset(validationData, 0, sizeof(vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertices__ValidationData* validationData = (vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName( ParserString value )
{
    return validate__NCName( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__lines( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINES;
        }
//        parentValidationData->lines++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINES;
        }
//        parentValidationData->lines++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        lines__ValidationData* validationData = (lines__ValidationData*)mValidationDataStack.newObject(sizeof(lines__ValidationData));
        memset(validationData, 0, sizeof(lines__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__lines()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        lines__ValidationData* validationData = (lines__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 490:
        {
        ph__ValidationData* parentValidationData = (ph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->h != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: h" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 6:
        {
        edges__ValidationData* parentValidationData = (edges__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 4 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 157:
        {
        faces__ValidationData* parentValidationData = (faces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 509:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 611:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 258:
        {
        pcurves__ValidationData* parentValidationData = (pcurves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 460:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_P, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_P;
        }
//        parentValidationData->p++;

        break;
        }

        case 140:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 547:
        {
        shells__ValidationData* parentValidationData = (shells__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 601:
        {
        solids__ValidationData* parentValidationData = (solids__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 573:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 729:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 357:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 77:
        {
        wires__ValidationData* parentValidationData = (wires__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__p()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__linestrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINESTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINESTRIPS;
        }
//        parentValidationData->linestrips++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINESTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINESTRIPS;
        }
//        parentValidationData->linestrips++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        linestrips__ValidationData* validationData = (linestrips__ValidationData*)mValidationDataStack.newObject(sizeof(linestrips__ValidationData));
        memset(validationData, 0, sizeof(linestrips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__linestrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        linestrips__ValidationData* validationData = (linestrips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__polygons( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYGONS;
        }
//        parentValidationData->polygons++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYGONS;
        }
//        parentValidationData->polygons++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        polygons__ValidationData* validationData = (polygons__ValidationData*)mValidationDataStack.newObject(sizeof(polygons__ValidationData));
        memset(validationData, 0, sizeof(polygons__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__polygons()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polygons__ValidationData* validationData = (polygons__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_INPUT) || (validationData->validation_current_state == HASH_ELEMENT_P) || (validationData->validation_current_state == HASH_ELEMENT_PH) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__ph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PH;
        }
//        parentValidationData->ph++;

        ph__ValidationData* validationData = (ph__ValidationData*)mValidationDataStack.newObject(sizeof(ph__ValidationData));
        memset(validationData, 0, sizeof(ph__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__ph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        ph__ValidationData* validationData = (ph__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->p < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PH, (const ParserChar*)0, "child: p" ) )
                return false;
        }
        if ( validationData->h < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PH, (const ParserChar*)0, "child: h" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__h( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        ph__ValidationData* parentValidationData = (ph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_H, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        parentValidationData->h++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__h()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__polylist( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYLIST, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYLIST;
        }
//        parentValidationData->polylist++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYLIST, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYLIST;
        }
//        parentValidationData->polylist++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        polylist__ValidationData* validationData = (polylist__ValidationData*)mValidationDataStack.newObject(sizeof(polylist__ValidationData));
        memset(validationData, 0, sizeof(polylist__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__polylist()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polylist__ValidationData* validationData = (polylist__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__triangles( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIANGLES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIANGLES;
        }
//        parentValidationData->triangles++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIANGLES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIANGLES;
        }
//        parentValidationData->triangles++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        triangles__ValidationData* validationData = (triangles__ValidationData*)mValidationDataStack.newObject(sizeof(triangles__ValidationData));
        memset(validationData, 0, sizeof(triangles__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__triangles()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        triangles__ValidationData* validationData = (triangles__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__trifans( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIFANS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIFANS;
        }
//        parentValidationData->trifans++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIFANS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIFANS;
        }
//        parentValidationData->trifans++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        trifans__ValidationData* validationData = (trifans__ValidationData*)mValidationDataStack.newObject(sizeof(trifans__ValidationData));
        memset(validationData, 0, sizeof(trifans__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__trifans()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        trifans__ValidationData* validationData = (trifans__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__tristrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 97:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRISTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRISTRIPS;
        }
//        parentValidationData->tristrips++;

        break;
        }

        case 704:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRISTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRISTRIPS;
        }
//        parentValidationData->tristrips++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        tristrips__ValidationData* validationData = (tristrips__ValidationData*)mValidationDataStack.newObject(sizeof(tristrips__ValidationData));
        memset(validationData, 0, sizeof(tristrips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__tristrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        tristrips__ValidationData* validationData = (tristrips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MESH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MESH;
        }
//        parentValidationData->mesh++;

        mesh__ValidationData* validationData = (mesh__ValidationData*)mValidationDataStack.newObject(sizeof(mesh__ValidationData));
        memset(validationData, 0, sizeof(mesh__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        mesh__ValidationData* validationData = (mesh__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LINES) || (validationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (validationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (validationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (validationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (validationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_MESH, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__spline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SPLINE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SPLINE;
        }
//        parentValidationData->spline++;

        spline__ValidationData* validationData = (spline__ValidationData*)mValidationDataStack.newObject(sizeof(spline__ValidationData));
        memset(validationData, 0, sizeof(spline__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__spline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        spline__ValidationData* validationData = (spline__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SPLINE, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->control_vertices < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SPLINE, (const ParserChar*)0, "child: control_vertices" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__spline_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->control_vertices >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->control_vertices++;

        spline_type____control_vertices__ValidationData* validationData = (spline_type____control_vertices__ValidationData*)mValidationDataStack.newObject(sizeof(spline_type____control_vertices__ValidationData));
        memset(validationData, 0, sizeof(spline_type____control_vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__spline_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        spline_type____control_vertices__ValidationData* validationData = (spline_type____control_vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__brep( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BREP, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BREP;
        }
//        parentValidationData->brep++;

        brep__ValidationData* validationData = (brep__ValidationData*)mValidationDataStack.newObject(sizeof(brep__ValidationData));
        memset(validationData, 0, sizeof(brep__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__brep()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* validationData = (brep__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_BREP, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->vertices < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_BREP, (const ParserChar*)0, "child: vertices" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__curves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->surface_curves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: surface_curves" ) )
                return false;
        }
        if ( parentValidationData->surfaces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: surfaces" ) )
                return false;
        }
        if ( parentValidationData->source != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->edges != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: edges" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->curves >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CURVES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->curves++;

        curves__ValidationData* validationData = (curves__ValidationData*)mValidationDataStack.newObject(sizeof(curves__ValidationData));
        memset(validationData, 0, sizeof(curves__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__curves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curves__ValidationData* validationData = (curves__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->curve < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CURVES, (const ParserChar*)0, "child: curve" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__curve( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 115:
        {
        curves__ValidationData* parentValidationData = (curves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->curve++;

        break;
        }

        case 306:
        {
        surface_curves__ValidationData* parentValidationData = (surface_curves__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CURVE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->curve++;

        break;
        }

        case 190:
        {
        swept_surface__ValidationData* parentValidationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CURVE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CURVE;
        }
//        parentValidationData->curve++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        curve__ValidationData* validationData = (curve__ValidationData*)mValidationDataStack.newObject(sizeof(curve__ValidationData));
        memset(validationData, 0, sizeof(curve__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__curve()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* validationData = (curve__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_CIRCLE) || (validationData->validation_current_state == HASH_ELEMENT_ELLIPSE) || (validationData->validation_current_state == HASH_ELEMENT_HYPERBOLA) || (validationData->validation_current_state == HASH_ELEMENT_LINE) || (validationData->validation_current_state == HASH_ELEMENT_NURBS) || (validationData->validation_current_state == HASH_ELEMENT_ORIENT) || (validationData->validation_current_state == HASH_ELEMENT_ORIGIN) || (validationData->validation_current_state == HASH_ELEMENT_PARABOLA) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_CURVE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__line( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINE;
        }
//        parentValidationData->line++;

        line__ValidationData* validationData = (line__ValidationData*)mValidationDataStack.newObject(sizeof(line__ValidationData));
        memset(validationData, 0, sizeof(line__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__line()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        line__ValidationData* validationData = (line__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->origin < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LINE, (const ParserChar*)0, "child: origin" ) )
                return false;
        }
        if ( validationData->direction < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LINE, (const ParserChar*)0, "child: direction" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3_type( const float* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3_type__stream( const float* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3_type__streamEnd( const float* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__origin____float3_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 223:
        {
        line__ValidationData* parentValidationData = (line__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->direction != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, "sibling: direction" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->origin >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->origin++;

        break;
        }

        case 190:
        {
        swept_surface__ValidationData* parentValidationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CURVE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ORIGIN;
        }
//        parentValidationData->origin++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____float3_type__ValidationData));
        memset(validationData, 0, sizeof(origin____float3_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__origin____float3_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__direction( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 223:
        {
        line__ValidationData* parentValidationData = (line__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->origin < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_DIRECTION, (const ParserChar*)0, "sibling: origin" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_DIRECTION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->direction >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_DIRECTION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->direction++;

        break;
        }

        case 190:
        {
        swept_surface__ValidationData* parentValidationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CURVE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_DIRECTION, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_DIRECTION;
        }
//        parentValidationData->direction++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____float3_type__ValidationData));
        memset(validationData, 0, sizeof(origin____float3_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__direction()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__circle( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CIRCLE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CIRCLE;
        }
//        parentValidationData->circle++;

        circle__ValidationData* validationData = (circle__ValidationData*)mValidationDataStack.newObject(sizeof(circle__ValidationData));
        memset(validationData, 0, sizeof(circle__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__circle()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        circle__ValidationData* validationData = (circle__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CIRCLE, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__radius____float_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        surface_type____cylinder__ValidationData* parentValidationData = (surface_type____cylinder__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 738:
        {
        circle__ValidationData* parentValidationData = (circle__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 585:
        {
        cone__ValidationData* parentValidationData = (cone__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->angle != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: angle" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 634:
        {
        sphere__ValidationData* parentValidationData = (sphere__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__radius____float_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__ellipse( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ELLIPSE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ELLIPSE;
        }
//        parentValidationData->ellipse++;

        ellipse__ValidationData* validationData = (ellipse__ValidationData*)mValidationDataStack.newObject(sizeof(ellipse__ValidationData));
        memset(validationData, 0, sizeof(ellipse__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__ellipse()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        ellipse__ValidationData* validationData = (ellipse__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ELLIPSE, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2_type( const float* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2_type__stream( const float* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2_type__streamEnd( const float* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__radius____float2_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 470:
        {
        cylinder____cylinder_type__ValidationData* parentValidationData = (cylinder____cylinder_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->height < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: height" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 437:
        {
        ellipse__ValidationData* parentValidationData = (ellipse__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 244:
        {
        hyperbola__ValidationData* parentValidationData = (hyperbola__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        case 15:
        {
        torus__ValidationData* parentValidationData = (torus__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RADIUS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->radius >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->radius++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.newObject(sizeof(radius____float2_type__ValidationData));
        memset(validationData, 0, sizeof(radius____float2_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__radius____float2_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__parabola( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PARABOLA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PARABOLA;
        }
//        parentValidationData->parabola++;

        parabola__ValidationData* validationData = (parabola__ValidationData*)mValidationDataStack.newObject(sizeof(parabola__ValidationData));
        memset(validationData, 0, sizeof(parabola__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__parabola()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        parabola__ValidationData* validationData = (parabola__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->focal < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PARABOLA, (const ParserChar*)0, "child: focal" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__focal( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        parabola__ValidationData* parentValidationData = (parabola__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FOCAL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->focal >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FOCAL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->focal++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__focal()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__hyperbola( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_HYPERBOLA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_HYPERBOLA;
        }
//        parentValidationData->hyperbola++;

        hyperbola__ValidationData* validationData = (hyperbola__ValidationData*)mValidationDataStack.newObject(sizeof(hyperbola__ValidationData));
        memset(validationData, 0, sizeof(hyperbola__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__hyperbola()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        hyperbola__ValidationData* validationData = (hyperbola__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_HYPERBOLA, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__nurbs( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_NURBS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_NURBS;
        }
//        parentValidationData->nurbs++;

        nurbs__ValidationData* validationData = (nurbs__ValidationData*)mValidationDataStack.newObject(sizeof(nurbs__ValidationData));
        memset(validationData, 0, sizeof(nurbs__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__nurbs()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs__ValidationData* validationData = (nurbs__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_NURBS, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->control_vertices < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_NURBS, (const ParserChar*)0, "child: control_vertices" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__nurbs_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs__ValidationData* parentValidationData = (nurbs__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->control_vertices >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->control_vertices++;

        nurbs_type____control_vertices__ValidationData* validationData = (nurbs_type____control_vertices__ValidationData*)mValidationDataStack.newObject(sizeof(nurbs_type____control_vertices__ValidationData));
        memset(validationData, 0, sizeof(nurbs_type____control_vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__nurbs_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs_type____control_vertices__ValidationData* validationData = (nurbs_type____control_vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4_type( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4_type__stream( const float* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4_type__streamEnd( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__orient( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 109:
        {
        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CIRCLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ELLIPSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_HYPERBOLA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NURBS) || (parentValidationData->validation_current_state == HASH_ELEMENT_ORIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PARABOLA) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ORIENT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ORIENT;
        }
//        parentValidationData->orient++;

        break;
        }

        case 263:
        {
        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CONE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_NURBS_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ORIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SWEPT_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TORUS) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ORIENT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ORIENT;
        }
//        parentValidationData->orient++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.newObject(sizeof(orient__ValidationData));
        memset(validationData, 0, sizeof(orient__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__orient()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__origin____origin_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 109:
        {
        curve__ValidationData* parentValidationData = (curve__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CIRCLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ELLIPSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_HYPERBOLA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NURBS) || (parentValidationData->validation_current_state == HASH_ELEMENT_ORIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PARABOLA) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ORIGIN;
        }
//        parentValidationData->origin++;

        break;
        }

        case 263:
        {
        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CONE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_NURBS_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ORIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SWEPT_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TORUS) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ORIGIN, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ORIGIN;
        }
//        parentValidationData->origin++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        origin____origin_type__ValidationData* validationData = (origin____origin_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____origin_type__ValidationData));
        memset(validationData, 0, sizeof(origin____origin_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__origin____origin_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__surface_curves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->surfaces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: surfaces" ) )
                return false;
        }
        if ( parentValidationData->source != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->edges != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: edges" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->surface_curves >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->surface_curves++;

        surface_curves__ValidationData* validationData = (surface_curves__ValidationData*)mValidationDataStack.newObject(sizeof(surface_curves__ValidationData));
        memset(validationData, 0, sizeof(surface_curves__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__surface_curves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface_curves__ValidationData* validationData = (surface_curves__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->curve < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SURFACE_CURVES, (const ParserChar*)0, "child: curve" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__surfaces( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->edges != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: edges" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->surfaces >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SURFACES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->surfaces++;

        surfaces__ValidationData* validationData = (surfaces__ValidationData*)mValidationDataStack.newObject(sizeof(surfaces__ValidationData));
        memset(validationData, 0, sizeof(surfaces__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__surfaces()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surfaces__ValidationData* validationData = (surfaces__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->surface < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SURFACES, (const ParserChar*)0, "child: surface" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surfaces__ValidationData* parentValidationData = (surfaces__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->surface++;

        surface__ValidationData* validationData = (surface__ValidationData*)mValidationDataStack.newObject(sizeof(surface__ValidationData));
        memset(validationData, 0, sizeof(surface__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* validationData = (surface__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_CONE) || (validationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (validationData->validation_current_state == HASH_ELEMENT_NURBS_SURFACE) || (validationData->validation_current_state == HASH_ELEMENT_ORIENT) || (validationData->validation_current_state == HASH_ELEMENT_ORIGIN) || (validationData->validation_current_state == HASH_ELEMENT_PLANE) || (validationData->validation_current_state == HASH_ELEMENT_SPHERE) || (validationData->validation_current_state == HASH_ELEMENT_SWEPT_SURFACE) || (validationData->validation_current_state == HASH_ELEMENT_TORUS) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__plane( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 597:
        {
        instance_rigid_body__technique_common__shape__ValidationData* parentValidationData = (instance_rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_HOLLOW) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MASS) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PLANE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PLANE;
        }
//        parentValidationData->plane++;

        break;
        }

        case 598:
        {
        rigid_body__technique_common__shape__ValidationData* parentValidationData = (rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_HOLLOW) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MASS) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PLANE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PLANE;
        }
//        parentValidationData->plane++;

        break;
        }

        case 263:
        {
        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PLANE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PLANE;
        }
//        parentValidationData->plane++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        plane__ValidationData* validationData = (plane__ValidationData*)mValidationDataStack.newObject(sizeof(plane__ValidationData));
        memset(validationData, 0, sizeof(plane__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__plane()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        plane__ValidationData* validationData = (plane__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->equation < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PLANE, (const ParserChar*)0, "child: equation" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__equation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        plane__ValidationData* parentValidationData = (plane__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EQUATION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->equation >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_EQUATION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->equation++;

        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.newObject(sizeof(orient__ValidationData));
        memset(validationData, 0, sizeof(orient__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__equation()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__sphere( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 597:
        {
        instance_rigid_body__technique_common__shape__ValidationData* parentValidationData = (instance_rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_HOLLOW) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MASS) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SPHERE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SPHERE;
        }
//        parentValidationData->sphere++;

        break;
        }

        case 598:
        {
        rigid_body__technique_common__shape__ValidationData* parentValidationData = (rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_HOLLOW) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_MASS) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHYSICS_MATERIAL) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SPHERE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SPHERE;
        }
//        parentValidationData->sphere++;

        break;
        }

        case 263:
        {
        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SPHERE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SPHERE;
        }
//        parentValidationData->sphere++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        sphere__ValidationData* validationData = (sphere__ValidationData*)mValidationDataStack.newObject(sizeof(sphere__ValidationData));
        memset(validationData, 0, sizeof(sphere__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__sphere()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        sphere__ValidationData* validationData = (sphere__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SPHERE, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__torus( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TORUS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TORUS;
        }
//        parentValidationData->torus++;

        torus__ValidationData* validationData = (torus__ValidationData*)mValidationDataStack.newObject(sizeof(torus__ValidationData));
        memset(validationData, 0, sizeof(torus__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__torus()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        torus__ValidationData* validationData = (torus__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TORUS, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__swept_surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SWEPT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SWEPT_SURFACE;
        }
//        parentValidationData->swept_surface++;

        swept_surface__ValidationData* validationData = (swept_surface__ValidationData*)mValidationDataStack.newObject(sizeof(swept_surface__ValidationData));
        memset(validationData, 0, sizeof(swept_surface__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__swept_surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        swept_surface__ValidationData* validationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_AXIS) || (validationData->validation_current_state == HASH_ELEMENT_DIRECTION) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_SWEPT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__axis____float3_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        swept_surface__ValidationData* parentValidationData = (swept_surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ORIGIN) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_AXIS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_AXIS;
        }
//        parentValidationData->axis++;

        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____float3_type__ValidationData));
        memset(validationData, 0, sizeof(origin____float3_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__axis____float3_type()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__nurbs_surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_NURBS_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_NURBS_SURFACE;
        }
//        parentValidationData->nurbs_surface++;

        nurbs_surface__ValidationData* validationData = (nurbs_surface__ValidationData*)mValidationDataStack.newObject(sizeof(nurbs_surface__ValidationData));
        memset(validationData, 0, sizeof(nurbs_surface__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__nurbs_surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs_surface__ValidationData* validationData = (nurbs_surface__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_NURBS_SURFACE, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->control_vertices < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_NURBS_SURFACE, (const ParserChar*)0, "child: control_vertices" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__nurbs_surface_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs_surface__ValidationData* parentValidationData = (nurbs_surface__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->control_vertices >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->control_vertices++;

        nurbs_surface_type____control_vertices__ValidationData* validationData = (nurbs_surface_type____control_vertices__ValidationData*)mValidationDataStack.newObject(sizeof(nurbs_surface_type____control_vertices__ValidationData));
        memset(validationData, 0, sizeof(nurbs_surface_type____control_vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__nurbs_surface_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        nurbs_surface_type____control_vertices__ValidationData* validationData = (nurbs_surface_type____control_vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__cone( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CONE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CONE;
        }
//        parentValidationData->cone++;

        cone__ValidationData* validationData = (cone__ValidationData*)mValidationDataStack.newObject(sizeof(cone__ValidationData));
        memset(validationData, 0, sizeof(cone__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__cone()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        cone__ValidationData* validationData = (cone__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONE, (const ParserChar*)0, "child: radius" ) )
                return false;
        }
        if ( validationData->angle < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONE, (const ParserChar*)0, "child: angle" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__angle( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        cone__ValidationData* parentValidationData = (cone__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_ANGLE, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANGLE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->angle >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ANGLE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->angle++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__angle()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__surface_type____cylinder( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface__ValidationData* parentValidationData = (surface__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CYLINDER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CYLINDER;
        }
//        parentValidationData->cylinder++;

        surface_type____cylinder__ValidationData* validationData = (surface_type____cylinder__ValidationData*)mValidationDataStack.newObject(sizeof(surface_type____cylinder__ValidationData));
        memset(validationData, 0, sizeof(surface_type____cylinder__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__surface_type____cylinder()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface_type____cylinder__ValidationData* validationData = (surface_type____cylinder__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->radius < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CYLINDER, (const ParserChar*)0, "child: radius" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__edges( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->wires != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: wires" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EDGES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->edges >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_EDGES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->edges++;

        edges__ValidationData* validationData = (edges__ValidationData*)mValidationDataStack.newObject(sizeof(edges__ValidationData));
        memset(validationData, 0, sizeof(edges__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__edges()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        edges__ValidationData* validationData = (edges__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 4 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_EDGES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__wires( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->faces != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: faces" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WIRES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wires >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WIRES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wires++;

        wires__ValidationData* validationData = (wires__ValidationData*)mValidationDataStack.newObject(sizeof(wires__ValidationData));
        memset(validationData, 0, sizeof(wires__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__wires()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        wires__ValidationData* validationData = (wires__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_WIRES, (const ParserChar*)0, "child: input" ) )
                return false;
        }
        if ( validationData->vcount < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_WIRES, (const ParserChar*)0, "child: vcount" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__faces( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_FACES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->pcurves != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACES, (const ParserChar*)0, "sibling: pcurves" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->faces >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FACES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->faces++;

        faces__ValidationData* validationData = (faces__ValidationData*)mValidationDataStack.newObject(sizeof(faces__ValidationData));
        memset(validationData, 0, sizeof(faces__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__faces()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        faces__ValidationData* validationData = (faces__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 3 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_FACES, (const ParserChar*)0, "child: input" ) )
                return false;
        }
        if ( validationData->vcount < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_FACES, (const ParserChar*)0, "child: vcount" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__pcurves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->shells != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "sibling: shells" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->pcurves >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PCURVES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->pcurves++;

        pcurves__ValidationData* validationData = (pcurves__ValidationData*)mValidationDataStack.newObject(sizeof(pcurves__ValidationData));
        memset(validationData, 0, sizeof(pcurves__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__pcurves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        pcurves__ValidationData* validationData = (pcurves__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 3 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "child: input" ) )
                return false;
        }
        if ( validationData->vcount < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PCURVES, (const ParserChar*)0, "child: vcount" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__shells( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_SHELLS, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->solids != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SHELLS, (const ParserChar*)0, "sibling: solids" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SHELLS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->shells >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SHELLS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->shells++;

        shells__ValidationData* validationData = (shells__ValidationData*)mValidationDataStack.newObject(sizeof(shells__ValidationData));
        memset(validationData, 0, sizeof(shells__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__shells()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        shells__ValidationData* validationData = (shells__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SHELLS, (const ParserChar*)0, "child: input" ) )
                return false;
        }
        if ( validationData->vcount < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SHELLS, (const ParserChar*)0, "child: vcount" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__solids( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        brep__ValidationData* parentValidationData = (brep__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_SOLIDS, (const ParserChar*)0, "sibling: vertices" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOLIDS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->solids >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOLIDS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->solids++;

        solids__ValidationData* validationData = (solids__ValidationData*)mValidationDataStack.newObject(sizeof(solids__ValidationData));
        memset(validationData, 0, sizeof(solids__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__solids()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        solids__ValidationData* validationData = (solids__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SOLIDS, (const ParserChar*)0, "child: input" ) )
                return false;
        }
        if ( validationData->vcount < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SOLIDS, (const ParserChar*)0, "child: vcount" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__library_effects( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORMULAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_JOINTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_KINEMATICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_EFFECTS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_EFFECTS;
        }
//        parentValidationData->library_effects++;

        library_effects__ValidationData* validationData = (library_effects__ValidationData*)mValidationDataStack.newObject(sizeof(library_effects__ValidationData));
        memset(validationData, 0, sizeof(library_effects__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__library_effects()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_effects__ValidationData* validationData = (library_effects__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->effect < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_EFFECTS, (const ParserChar*)0, "child: effect" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__effect( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EFFECT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->effect++;

        effect__ValidationData* validationData = (effect__ValidationData*)mValidationDataStack.newObject(sizeof(effect__ValidationData));
        memset(validationData, 0, sizeof(effect__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__effect()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        effect__ValidationData* validationData = (effect__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_BRIDGE) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_CG) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_COMMON) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_GLES) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_GLES2) || (validationData->validation_current_state == HASH_ELEMENT_PROFILE_GLSL) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_EFFECT, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__annotate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 418:
        {
        profile_GLES__technique__pass__ValidationData* parentValidationData = (profile_GLES__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->states != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: states" ) )
                return false;
        }
        if ( parentValidationData->evaluate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: evaluate" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 419:
        {
        profile_GLSL__technique__pass__ValidationData* parentValidationData = (profile_GLSL__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->states != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: states" ) )
                return false;
        }
        if ( parentValidationData->program != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: program" ) )
                return false;
        }
        if ( parentValidationData->evaluate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: evaluate" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 614:
        {
        profile_cg_type____technique__ValidationData* parentValidationData = (profile_cg_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 616:
        {
        profile_gles2_type____technique__ValidationData* parentValidationData = (profile_gles2_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 617:
        {
        profile_gles_type____technique__ValidationData* parentValidationData = (profile_gles_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 618:
        {
        profile_glsl_type____technique__ValidationData* parentValidationData = (profile_glsl_type____technique__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->pass != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: pass" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 420:
        {
        pass____cg_pass_type__ValidationData* parentValidationData = (pass____cg_pass_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->states != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: states" ) )
                return false;
        }
        if ( parentValidationData->program != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: program" ) )
                return false;
        }
        if ( parentValidationData->evaluate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: evaluate" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 69:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 421:
        {
        pass____gles2_pass_type__ValidationData* parentValidationData = (pass____gles2_pass_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->states != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: states" ) )
                return false;
        }
        if ( parentValidationData->program != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: program" ) )
                return false;
        }
        if ( parentValidationData->evaluate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: evaluate" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        annotate__ValidationData* validationData = (annotate__ValidationData*)mValidationDataStack.newObject(sizeof(annotate__ValidationData));
        memset(validationData, 0, sizeof(annotate__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__annotate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        annotate__ValidationData* validationData = (annotate__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_BOOL) || (validationData->validation_current_state == HASH_ELEMENT_BOOL2) || (validationData->validation_current_state == HASH_ELEMENT_BOOL3) || (validationData->validation_current_state == HASH_ELEMENT_BOOL4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (validationData->validation_current_state == HASH_ELEMENT_INT) || (validationData->validation_current_state == HASH_ELEMENT_INT2) || (validationData->validation_current_state == HASH_ELEMENT_INT3) || (validationData->validation_current_state == HASH_ELEMENT_INT4) || (validationData->validation_current_state == HASH_ELEMENT_STRING) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2_type( const bool* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2_type__stream( const bool* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2_type__streamEnd( const bool* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bool2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool2__ValidationData* validationData = (bool2__ValidationData*)mValidationDataStack.newObject(sizeof(bool2__ValidationData));
        memset(validationData, 0, sizeof(bool2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bool2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3_type( const bool* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3_type__stream( const bool* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3_type__streamEnd( const bool* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bool3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool3__ValidationData* validationData = (bool3__ValidationData*)mValidationDataStack.newObject(sizeof(bool3__ValidationData));
        memset(validationData, 0, sizeof(bool3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bool3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4_type( const bool* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4_type__stream( const bool* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4_type__streamEnd( const bool* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__bool4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool4__ValidationData* validationData = (bool4__ValidationData*)mValidationDataStack.newObject(sizeof(bool4__ValidationData));
        memset(validationData, 0, sizeof(bool4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__bool4()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2_type( const sint64* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2_type__stream( const sint64* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2_type__streamEnd( const sint64* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__int2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int2__ValidationData* validationData = (int2__ValidationData*)mValidationDataStack.newObject(sizeof(int2__ValidationData));
        memset(validationData, 0, sizeof(int2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__int2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3_type( const sint64* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3_type__stream( const sint64* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3_type__streamEnd( const sint64* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int3__ValidationData* validationData = (int3__ValidationData*)mValidationDataStack.newObject(sizeof(int3__ValidationData));
        memset(validationData, 0, sizeof(int3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__int3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4_type( const sint64* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4_type__stream( const sint64* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4_type__streamEnd( const sint64* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__int4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int4__ValidationData* validationData = (int4__ValidationData*)mValidationDataStack.newObject(sizeof(int4__ValidationData));
        memset(validationData, 0, sizeof(int4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__int4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 26:
        {
        speed____common_float2_or_param_type__ValidationData* parentValidationData = (speed____common_float2_or_param_type__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->param != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, "sibling: param" ) )
                return false;
        }
        if ( parentValidationData->float2 >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->float2++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 657:
        {
        newparam____fx_common_newparam_type__ValidationData* parentValidationData = (newparam____fx_common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.newObject(sizeof(radius____float2_type__ValidationData));
        memset(validationData, 0, sizeof(radius____float2_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float2()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 657:
        {
        newparam____fx_common_newparam_type__ValidationData* parentValidationData = (newparam____fx_common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____float3_type__ValidationData));
        memset(validationData, 0, sizeof(origin____float3_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float3()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 657:
        {
        newparam____fx_common_newparam_type__ValidationData* parentValidationData = (newparam____fx_common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.newObject(sizeof(orient__ValidationData));
        memset(validationData, 0, sizeof(orient__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float4()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2_type( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2_type__stream( const float* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2_type__streamEnd( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float2x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x2__ValidationData* validationData = (float2x2__ValidationData*)mValidationDataStack.newObject(sizeof(float2x2__ValidationData));
        memset(validationData, 0, sizeof(float2x2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float2x2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3_type( const float* value, size_t length )
{
    if( length < 9 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3_type__stream( const float* value, size_t length )
{

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3_type__streamEnd( const float* value, size_t length )
{
    if( length < 9 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float3x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3x3__ValidationData* validationData = (float3x3__ValidationData*)mValidationDataStack.newObject(sizeof(float3x3__ValidationData));
        memset(validationData, 0, sizeof(float3x3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float3x3()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float4x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 374:
        {
        glsl_program_type____bind_uniform__ValidationData* parentValidationData = (glsl_program_type____bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 405:
        {
        array____glsl_array_type__ValidationData* parentValidationData = (array____glsl_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.newObject(sizeof(bind_shape_matrix__ValidationData));
        memset(validationData, 0, sizeof(bind_shape_matrix__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float4x4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 498:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__string()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__newparam____fx_newparam_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_NEWPARAM, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_NEWPARAM;
        }
//        parentValidationData->newparam++;

        newparam____fx_newparam_type__ValidationData* validationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.newObject(sizeof(newparam____fx_newparam_type__ValidationData));
        memset(validationData, 0, sizeof(newparam____fx_newparam_type__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__newparam____fx_newparam_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        newparam____fx_newparam_type__ValidationData* validationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_BOOL) || (validationData->validation_current_state == HASH_ELEMENT_BOOL2) || (validationData->validation_current_state == HASH_ELEMENT_BOOL3) || (validationData->validation_current_state == HASH_ELEMENT_BOOL4) || (validationData->validation_current_state == HASH_ELEMENT_ENUM) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (validationData->validation_current_state == HASH_ELEMENT_INT) || (validationData->validation_current_state == HASH_ELEMENT_INT2) || (validationData->validation_current_state == HASH_ELEMENT_INT3) || (validationData->validation_current_state == HASH_ELEMENT_INT4) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_NEWPARAM, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__semantic____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 657:
        {
        newparam____fx_common_newparam_type__ValidationData* parentValidationData = (newparam____fx_common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__semantic____NCName()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum( ParserString value )
{
    return validate__fx_modifier_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__modifier( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 654:
        {
        profile_gles2_type____newparam__ValidationData* parentValidationData = (profile_gles2_type____newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 660:
        {
        newparam____glsl_newparam_type__ValidationData* parentValidationData = (newparam____glsl_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__modifier()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float2x1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.newObject(sizeof(radius____float2_type__ValidationData));
        memset(validationData, 0, sizeof(radius____float2_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float2x1()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3_type( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3_type__stream( const float* value, size_t length )
{

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3_type__streamEnd( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float2x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x3__ValidationData* validationData = (float2x3__ValidationData*)mValidationDataStack.newObject(sizeof(float2x3__ValidationData));
        memset(validationData, 0, sizeof(float2x3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float2x3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4_type( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4_type__stream( const float* value, size_t length )
{

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4_type__streamEnd( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float2x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x4__ValidationData* validationData = (float2x4__ValidationData*)mValidationDataStack.newObject(sizeof(float2x4__ValidationData));
        memset(validationData, 0, sizeof(float2x4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float2x4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float3x1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 655:
        {
        newparam____cg_newparam_type__ValidationData* parentValidationData = (newparam____cg_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 741:
        {
        setparam____cg_setparam_type__ValidationData* parentValidationData = (setparam____cg_setparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 658:
        {
        newparam____fx_newparam_type__ValidationData* parentValidationData = (newparam____fx_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 659:
        {
        newparam____gles_newparam_type__ValidationData* parentValidationData = (newparam____gles_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.newObject(sizeof(origin____float3_type__ValidationData));
        memset(validationData, 0, sizeof(origin____float3_type__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateEnd__float3x1()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2_type( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2_type__stream( const float* value, size_t length )
{

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2_type__streamEnd( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_validateBegin__float3x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 375:
        {
        profile_CG__technique__pass__program__shader__bind_uniform__ValidationData* parentValidationData = (profile_CG__technique__pass__program__shader__bind_uniform__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        case 739:
        {
        instance_effect_type____setparam__ValidationData* parentValidationData = (instance_effect_type____setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        case 404:
        {
        array____cg_array_type__ValidationData* parentValidationData = (array____cg_array_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
      