/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2TABLECONTEXT_H_INCLUDED
#define FB2TABLECONTEXT_H_INCLUDED

#include "FB2ParserContext.h"

namespace libebook
{

class FB2TableModel;

class FB2TableContext : public FB2BlockFormatContextBase
{
  // disable copying
  FB2TableContext(const FB2TableContext &other);
  FB2TableContext &operator=(const FB2TableContext &other);

public:
  FB2TableContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);
  virtual ~FB2TableContext();

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);

private:
  FB2TableModel *m_model;
};

class FB2CellContext : public FB2StyleContextBase
{
  // disable copying
  FB2CellContext(const FB2CellContext &other);
  FB2CellContext &operator=(const FB2CellContext &other);

public:
  FB2CellContext(FB2ParserContext *parentContext, FB2TableModel *model, const FB2BlockFormat &format, bool header);

private:
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);
  virtual void endOfAttributes();

  void openCell();

private:
  FB2TableModel *const m_model;
  const bool m_header;
  bool m_opened;
  int m_columnSpan;
  int m_rowSpan;
  size_t m_coveredColumns;
};

class FB2TrContext : public FB2BlockFormatContextBase
{
  // no copying
  FB2TrContext(const FB2TrContext &);
  FB2TrContext &operator=(const FB2TrContext &);

public:
  FB2TrContext(FB2ParserContext *parentContext, FB2TableModel *model, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const FB2TokenData &name, const FB2TokenData &ns);
  virtual void endOfElement();
  virtual void attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value);

  void openRow(bool header);

private:
  FB2TableModel *m_model;
  bool m_opened;
};

}

#endif // FB2TABLECONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
